// DO NOT EDIT!  Generated automatically by subst-config-vals.

////////////////////////////////////////////////////////////////////////
//
// Copyright (C) 2008-2025 The Octave Project Developers
//
// See the file COPYRIGHT.md in the top-level directory of this
// distribution or <https://octave.org/copyright/>.
//
// This file is part of Octave.
//
// Octave is free software: you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Octave is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Octave; see the file COPYING.  If not, see
// <https://www.gnu.org/licenses/>.
//
////////////////////////////////////////////////////////////////////////

#if defined (HAVE_CONFIG_H)
#  include "config.h"
#endif

#include <string>
#include <map>
#include <iostream>
#include <algorithm>
#include <cstdlib>

#if defined (OCTAVE_USE_WINDOWS_API)
#  include <vector>
#  include <locale>
#  include <codecvt>
#endif

#if ! defined (OCTAVE_PREFIX)
#  define OCTAVE_PREFIX "/usr"
#endif

#if ! defined (OCTAVE_EXEC_PREFIX)
#  define OCTAVE_EXEC_PREFIX "/usr"
#endif

#ifndef OCTAVE_UNUSED
#  define OCTAVE_UNUSED
#endif

#include "shared-fcns.h"

static std::map<std::string, std::string> vars;

static std::string usage_msg = "usage: octave-config [options]";

static std::string help_msg =
  "\n"
  "Options:\n"
  "\n"
  "  -h, -?, --help        Print this message.\n"
  "\n"
  "  --m-site-dir          Print the name of the directory where Octave\n"
  "                        expects to find locally installed .m files.\n"
  "\n"
  "  --oct-site-dir        Print the name of the directory where Octave\n"
  "                        expects to find locally installed .oct files.\n"
  "\n"
  "  -p VAR, --print VAR   Print the value of the given configuration\n"
  "                        variable VAR.  Recognized variables are:\n"
  "\n"
  "                          API_VERSION            LOCALARCHLIBDIR\n"
  "                          ARCHLIBDIR             LOCALFCNFILEDIR\n"    
  "                          BINDIR                 LOCALOCTFILEDIR\n"    
  "                          CANONICAL_HOST_TYPE    LOCALSTARTUPFILEDIR\n"
  "                          DATADIR                LOCALVERARCHLIBDIR\n" 
  "                          DATAROOTDIR            LOCALVERFCNFILEDIR\n" 
  "                          DEFAULT_PAGER          LOCALVEROCTFILEDIR\n" 
  "                          EXEC_PREFIX            MAN1DIR\n"            
  "                          EXEEXT                 MAN1EXT\n"            
  "                          FCNFILEDIR             MANDIR\n"             
  "                          IMAGEDIR               OCTAVE_EXEC_HOME\n"   
  "                          INCLUDEDIR             OCTAVE_HOME\n"        
  "                          INFODIR                OCTDATADIR\n"         
  "                          INFOFILE               OCTDOCDIR\n"          
  "                          LIBDIR                 OCTFILEDIR\n"         
  "                          LIBEXECDIR             OCTFONTSDIR\n"        
  "                          LOCALAPIARCHLIBDIR     OCTINCLUDEDIR\n"      
  "                          LOCALAPIFCNFILEDIR     OCTLIBDIR\n"          
  "                          LOCALAPIOCTFILEDIR     STARTUPFILEDIR\n"     
  "                          LOCALAPIPKGDIR         VERSION\n"            
  "\n"
  "  -v, --version         Print the Octave version number.\n"
  "\n";

static void
initialize ()
{
  set_octave_home ();

  vars["OCTAVE_HOME"] = Voctave_home;
  vars["OCTAVE_EXEC_HOME"] = Voctave_exec_home;

  vars["API_VERSION"] = "api-v60";
  vars["CANONICAL_HOST_TYPE"] = "x86_64-pc-linux-gnu";
  vars["DEFAULT_PAGER"] = "more";
  vars["EXEEXT"] = "";
  vars["MAN1EXT"] = ".1";
  vars["VERSION"] = "10.2.0";

  vars["ARCHLIBDIR"] = prepend_octave_exec_home ("lib/octave/10.2.0/exec/x86_64-pc-linux-gnu");
  vars["BINDIR"] = prepend_octave_exec_home ("bin");
  vars["DATADIR"] = prepend_octave_home ("share");
  vars["DATAROOTDIR"] = prepend_octave_home ("share");
  vars["FCNFILEDIR"] = prepend_octave_home ("share/octave/10.2.0/m");
  vars["IMAGEDIR"] = prepend_octave_home ("share/octave/10.2.0/imagelib");
  vars["INCLUDEDIR"] = prepend_octave_home ("include");
  vars["INFODIR"] = prepend_octave_home ("share/info");
  vars["INFOFILE"] = prepend_octave_home ("share/info/octave.info");
  vars["LIBDIR"] = prepend_octave_exec_home ("lib");
  vars["LIBEXECDIR"] = prepend_octave_exec_home ("lib");
  vars["LOCALAPIARCHLIBDIR"] = prepend_octave_exec_home ("lib/octave/api-v60/site/exec/x86_64-pc-linux-gnu");
  vars["LOCALAPIFCNFILEDIR"] = prepend_octave_home ("share/octave/site/api-v60/m");
  vars["LOCALAPIOCTFILEDIR"] = prepend_octave_exec_home ("lib/octave/site/oct/api-v60/x86_64-pc-linux-gnu");
  vars["LOCALAPIPKGDIR"] = prepend_octave_exec_home ("share/octave/site/api-v60");
  vars["LOCALARCHLIBDIR"] = prepend_octave_exec_home ("lib/octave/site/exec/x86_64-pc-linux-gnu");
  vars["LOCALFCNFILEDIR"] = prepend_octave_home ("share/octave/site/m");
  vars["LOCALOCTFILEDIR"] = prepend_octave_exec_home ("lib/octave/site/oct/x86_64-pc-linux-gnu");
  vars["LOCALSTARTUPFILEDIR"] = prepend_octave_home ("share/octave/site/m/startup");
  vars["LOCALVERARCHLIBDIR"] = prepend_octave_exec_home ("lib/octave/10.2.0/site/exec/x86_64-pc-linux-gnu");
  vars["LOCALVERFCNFILEDIR"] = prepend_octave_home ("share/octave/10.2.0/site/m");
  vars["LOCALVEROCTFILEDIR"] = prepend_octave_exec_home ("lib/octave/10.2.0/site/oct/x86_64-pc-linux-gnu");
  vars["MAN1DIR"] = prepend_octave_home ("share/man/man1");
  vars["MANDIR"] = prepend_octave_home ("share/man");
  vars["OCTDATADIR"] = prepend_octave_home ("share/octave/10.2.0/data");
  vars["OCTDOCDIR"] = prepend_octave_home ("share/octave/10.2.0/doc");
  vars["OCTFILEDIR"] = prepend_octave_exec_home ("lib/octave/10.2.0/oct/x86_64-pc-linux-gnu");
  vars["OCTFONTSDIR"] = prepend_octave_home ("share/octave/10.2.0/fonts");
  vars["OCTINCLUDEDIR"] = prepend_octave_home ("include/octave-10.2.0/octave");
  vars["OCTLIBDIR"] = prepend_octave_exec_home ("lib/octave/10.2.0");
  vars["STARTUPFILEDIR"] = prepend_octave_home ("share/octave/10.2.0/m/startup");
}

#if defined (OCTAVE_USE_WINDOWS_API) && defined (_UNICODE)
extern "C"
int
wmain (int argc, wchar_t **wargv)
{
  static char **argv = new char * [argc + 1];
  std::vector<std::string> argv_str;

  // convert wide character strings to multibyte UTF-8 strings
  std::wstring_convert<std::codecvt_utf8<wchar_t>, wchar_t> wchar_conv;
  for (int i_arg = 0; i_arg < argc; i_arg++)
    argv_str.push_back (wchar_conv.to_bytes (wargv[i_arg]));

  // Get pointers to C strings not before vector is stable.
  for (int i_arg = 0; i_arg < argc; i_arg++)
    argv[i_arg] = &argv_str[i_arg][0];
  argv[argc] = nullptr;

#else
int
main (int argc, char **argv)
{
#endif
  initialize ();

  if (argc == 1)
    {
      std::cout << usage_msg << std::endl;
      return 1;
    }

  for (int i = 1; i < argc; i++)
    {
      std::string arg (argv[i]);

      if (arg == "-h" || arg == "-?" || arg == "--help")
        {
          std::cout << usage_msg << std::endl;
          std::cout << help_msg;
          return 0;
        }
      else if (arg == "--m-site-dir")
        std::cout << vars["LOCALVERFCNFILEDIR"] << std::endl;
      else if (arg == "--oct-site-dir")
        std::cout << vars["LOCALVEROCTFILEDIR"] << std::endl;
      else if (arg == "-v" || arg == "--version")
        std::cout << vars["VERSION"] << std::endl;
      else if (arg == "-p" || arg == "--print")
        {
          if (i < argc-1)
            {
              arg = argv[++i];
              std::cout << vars[arg] << std::endl;
            }
          else
            {
              std::cerr << "octave-config: " << arg
                        << " options requires argument" << std::endl;
              return 1;
            }
        }
      else
        {
          std::cerr << "octave-config: unrecognized argument " << arg
                    << std::endl;
          return 1;
        }
    }

  return 0;
}
