// *********** THIS FILE IS GENERATED - DO NOT EDIT ***********
//     See validation_layer_generator.py for modifications
// ************************************************************

// Copyright (c) 2017-2025 The Khronos Group Inc.
// Copyright (c) 2017-2019 Valve Corporation
// Copyright (c) 2017-2019 LunarG, Inc.
//
// SPDX-License-Identifier: Apache-2.0
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Author: Mark Young <marky@lunarg.com>
//

#include "xr_generated_core_validation.hpp"

#include "api_layer_platform_defines.h"
#include "hex_and_handles.h"
#include "validation_utils.h"
#include "xr_dependencies.h"
#include "xr_generated_dispatch_table.h"

#include "api_layer_platform_defines.h"
#include "xr_dependencies.h"
#include <openxr/openxr.h>
#include <openxr/openxr_platform.h>

#include <algorithm>
#include <cstring>
#include <memory>
#include <sstream>
#include <string>
#include <unordered_map>
#include <unordered_set>
#include <utility>
#include <vector>

#ifdef __clang__
#pragma GCC diagnostic ignored "-Wunused-parameter"
#endif

// Structure used for indicating status of 'flags' test.
enum ValidateXrFlagsResult {
    VALIDATE_XR_FLAGS_ZERO,
    VALIDATE_XR_FLAGS_INVALID,
    VALIDATE_XR_FLAGS_SUCCESS,
};

// Unordered Map associating pointer to a vector of session label information to a session's handle
std::unordered_map<XrSession, std::vector<GenValidUsageXrInternalSessionLabel*>*> g_xr_session_labels;

InstanceHandleInfo g_instance_info;
HandleInfo<XrSession> g_session_info;
HandleInfo<XrSpace> g_space_info;
HandleInfo<XrAction> g_action_info;
HandleInfo<XrSwapchain> g_swapchain_info;
HandleInfo<XrActionSet> g_actionset_info;
HandleInfo<XrDebugUtilsMessengerEXT> g_debugutilsmessengerext_info;
HandleInfo<XrSpatialAnchorMSFT> g_spatialanchormsft_info;
HandleInfo<XrSpatialGraphNodeBindingMSFT> g_spatialgraphnodebindingmsft_info;
HandleInfo<XrHandTrackerEXT> g_handtrackerext_info;
HandleInfo<XrBodyTrackerFB> g_bodytrackerfb_info;
HandleInfo<XrSceneObserverMSFT> g_sceneobservermsft_info;
HandleInfo<XrSceneMSFT> g_scenemsft_info;
HandleInfo<XrFacialTrackerHTC> g_facialtrackerhtc_info;
HandleInfo<XrFoveationProfileFB> g_foveationprofilefb_info;
HandleInfo<XrTriangleMeshFB> g_trianglemeshfb_info;
HandleInfo<XrPassthroughFB> g_passthroughfb_info;
HandleInfo<XrPassthroughLayerFB> g_passthroughlayerfb_info;
HandleInfo<XrGeometryInstanceFB> g_geometryinstancefb_info;
HandleInfo<XrMarkerDetectorML> g_markerdetectorml_info;
HandleInfo<XrExportedLocalizationMapML> g_exportedlocalizationmapml_info;
HandleInfo<XrSpatialAnchorsStorageML> g_spatialanchorsstorageml_info;
HandleInfo<XrSpatialAnchorStoreConnectionMSFT> g_spatialanchorstoreconnectionmsft_info;
HandleInfo<XrSpaceUserFB> g_spaceuserfb_info;
HandleInfo<XrFaceTrackerFB> g_facetrackerfb_info;
HandleInfo<XrEyeTrackerFB> g_eyetrackerfb_info;
HandleInfo<XrVirtualKeyboardMETA> g_virtualkeyboardmeta_info;
HandleInfo<XrPassthroughColorLutMETA> g_passthroughcolorlutmeta_info;
HandleInfo<XrFaceTracker2FB> g_facetracker2fb_info;
HandleInfo<XrEnvironmentDepthProviderMETA> g_environmentdepthprovidermeta_info;
HandleInfo<XrEnvironmentDepthSwapchainMETA> g_environmentdepthswapchainmeta_info;
HandleInfo<XrRenderModelEXT> g_rendermodelext_info;
HandleInfo<XrRenderModelAssetEXT> g_rendermodelassetext_info;
HandleInfo<XrPassthroughHTC> g_passthroughhtc_info;
HandleInfo<XrBodyTrackerHTC> g_bodytrackerhtc_info;
HandleInfo<XrBodyTrackerBD> g_bodytrackerbd_info;
HandleInfo<XrSenseDataProviderBD> g_sensedataproviderbd_info;
HandleInfo<XrSenseDataSnapshotBD> g_sensedatasnapshotbd_info;
HandleInfo<XrAnchorBD> g_anchorbd_info;
HandleInfo<XrPlaneDetectorEXT> g_planedetectorext_info;
HandleInfo<XrTrackableTrackerANDROID> g_trackabletrackerandroid_info;
HandleInfo<XrDeviceAnchorPersistenceANDROID> g_deviceanchorpersistenceandroid_info;
HandleInfo<XrWorldMeshDetectorML> g_worldmeshdetectorml_info;
HandleInfo<XrFacialExpressionClientML> g_facialexpressionclientml_info;
HandleInfo<XrSpatialEntityEXT> g_spatialentityext_info;
HandleInfo<XrSpatialContextEXT> g_spatialcontextext_info;
HandleInfo<XrSpatialSnapshotEXT> g_spatialsnapshotext_info;
HandleInfo<XrSpatialPersistenceContextEXT> g_spatialpersistencecontextext_info;
ValidateXrHandleResult VerifyXrInstanceHandle(const XrInstance* handle_to_check);
ValidateXrHandleResult VerifyXrSessionHandle(const XrSession* handle_to_check);
ValidateXrHandleResult VerifyXrSpaceHandle(const XrSpace* handle_to_check);
ValidateXrHandleResult VerifyXrActionHandle(const XrAction* handle_to_check);
ValidateXrHandleResult VerifyXrSwapchainHandle(const XrSwapchain* handle_to_check);
ValidateXrHandleResult VerifyXrActionSetHandle(const XrActionSet* handle_to_check);
ValidateXrHandleResult VerifyXrDebugUtilsMessengerEXTHandle(const XrDebugUtilsMessengerEXT* handle_to_check);
ValidateXrHandleResult VerifyXrSpatialAnchorMSFTHandle(const XrSpatialAnchorMSFT* handle_to_check);
ValidateXrHandleResult VerifyXrSpatialGraphNodeBindingMSFTHandle(const XrSpatialGraphNodeBindingMSFT* handle_to_check);
ValidateXrHandleResult VerifyXrHandTrackerEXTHandle(const XrHandTrackerEXT* handle_to_check);
ValidateXrHandleResult VerifyXrBodyTrackerFBHandle(const XrBodyTrackerFB* handle_to_check);
ValidateXrHandleResult VerifyXrSceneObserverMSFTHandle(const XrSceneObserverMSFT* handle_to_check);
ValidateXrHandleResult VerifyXrSceneMSFTHandle(const XrSceneMSFT* handle_to_check);
ValidateXrHandleResult VerifyXrFacialTrackerHTCHandle(const XrFacialTrackerHTC* handle_to_check);
ValidateXrHandleResult VerifyXrFoveationProfileFBHandle(const XrFoveationProfileFB* handle_to_check);
ValidateXrHandleResult VerifyXrTriangleMeshFBHandle(const XrTriangleMeshFB* handle_to_check);
ValidateXrHandleResult VerifyXrPassthroughFBHandle(const XrPassthroughFB* handle_to_check);
ValidateXrHandleResult VerifyXrPassthroughLayerFBHandle(const XrPassthroughLayerFB* handle_to_check);
ValidateXrHandleResult VerifyXrGeometryInstanceFBHandle(const XrGeometryInstanceFB* handle_to_check);
ValidateXrHandleResult VerifyXrMarkerDetectorMLHandle(const XrMarkerDetectorML* handle_to_check);
ValidateXrHandleResult VerifyXrExportedLocalizationMapMLHandle(const XrExportedLocalizationMapML* handle_to_check);
ValidateXrHandleResult VerifyXrSpatialAnchorsStorageMLHandle(const XrSpatialAnchorsStorageML* handle_to_check);
ValidateXrHandleResult VerifyXrSpatialAnchorStoreConnectionMSFTHandle(const XrSpatialAnchorStoreConnectionMSFT* handle_to_check);
ValidateXrHandleResult VerifyXrSpaceUserFBHandle(const XrSpaceUserFB* handle_to_check);
ValidateXrHandleResult VerifyXrFaceTrackerFBHandle(const XrFaceTrackerFB* handle_to_check);
ValidateXrHandleResult VerifyXrEyeTrackerFBHandle(const XrEyeTrackerFB* handle_to_check);
ValidateXrHandleResult VerifyXrVirtualKeyboardMETAHandle(const XrVirtualKeyboardMETA* handle_to_check);
ValidateXrHandleResult VerifyXrPassthroughColorLutMETAHandle(const XrPassthroughColorLutMETA* handle_to_check);
ValidateXrHandleResult VerifyXrFaceTracker2FBHandle(const XrFaceTracker2FB* handle_to_check);
ValidateXrHandleResult VerifyXrEnvironmentDepthProviderMETAHandle(const XrEnvironmentDepthProviderMETA* handle_to_check);
ValidateXrHandleResult VerifyXrEnvironmentDepthSwapchainMETAHandle(const XrEnvironmentDepthSwapchainMETA* handle_to_check);
ValidateXrHandleResult VerifyXrRenderModelEXTHandle(const XrRenderModelEXT* handle_to_check);
ValidateXrHandleResult VerifyXrRenderModelAssetEXTHandle(const XrRenderModelAssetEXT* handle_to_check);
ValidateXrHandleResult VerifyXrPassthroughHTCHandle(const XrPassthroughHTC* handle_to_check);
ValidateXrHandleResult VerifyXrBodyTrackerHTCHandle(const XrBodyTrackerHTC* handle_to_check);
ValidateXrHandleResult VerifyXrBodyTrackerBDHandle(const XrBodyTrackerBD* handle_to_check);
ValidateXrHandleResult VerifyXrSenseDataProviderBDHandle(const XrSenseDataProviderBD* handle_to_check);
ValidateXrHandleResult VerifyXrSenseDataSnapshotBDHandle(const XrSenseDataSnapshotBD* handle_to_check);
ValidateXrHandleResult VerifyXrAnchorBDHandle(const XrAnchorBD* handle_to_check);
ValidateXrHandleResult VerifyXrPlaneDetectorEXTHandle(const XrPlaneDetectorEXT* handle_to_check);
ValidateXrHandleResult VerifyXrTrackableTrackerANDROIDHandle(const XrTrackableTrackerANDROID* handle_to_check);
ValidateXrHandleResult VerifyXrDeviceAnchorPersistenceANDROIDHandle(const XrDeviceAnchorPersistenceANDROID* handle_to_check);
ValidateXrHandleResult VerifyXrWorldMeshDetectorMLHandle(const XrWorldMeshDetectorML* handle_to_check);
ValidateXrHandleResult VerifyXrFacialExpressionClientMLHandle(const XrFacialExpressionClientML* handle_to_check);
ValidateXrHandleResult VerifyXrSpatialEntityEXTHandle(const XrSpatialEntityEXT* handle_to_check);
ValidateXrHandleResult VerifyXrSpatialContextEXTHandle(const XrSpatialContextEXT* handle_to_check);
ValidateXrHandleResult VerifyXrSpatialSnapshotEXTHandle(const XrSpatialSnapshotEXT* handle_to_check);
ValidateXrHandleResult VerifyXrSpatialPersistenceContextEXTHandle(const XrSpatialPersistenceContextEXT* handle_to_check);

// Write out prototypes for handle parent verification functions
bool VerifyXrParent(XrObjectType handle1_type, const uint64_t handle1,
                    XrObjectType handle2_type, const uint64_t handle2,
                    bool check_this);

// Function to check if an extension has been enabled
bool ExtensionEnabled(const std::vector<std::string> &extensions, const char* const check_extension_name);

// Functions to validate structures
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrApiLayerProperties* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrExtensionProperties* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrApplicationInfo* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrInstanceCreateInfo* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrInstanceProperties* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrEventDataBuffer* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrSystemGetInfo* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrSystemGraphicsProperties* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrSystemTrackingProperties* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrSystemProperties* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrSessionCreateInfo* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrVector3f* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrSpaceVelocity* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrQuaternionf* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrPosef* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrReferenceSpaceCreateInfo* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrExtent2Df* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrActionSpaceCreateInfo* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrSpaceLocation* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrViewConfigurationProperties* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrViewConfigurationView* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrSwapchainCreateInfo* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrSwapchainImageBaseHeader* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrSwapchainImageAcquireInfo* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrSwapchainImageWaitInfo* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrSwapchainImageReleaseInfo* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrSessionBeginInfo* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrFrameWaitInfo* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrFrameState* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrFrameBeginInfo* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrCompositionLayerBaseHeader* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrFrameEndInfo* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrViewLocateInfo* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrViewState* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrFovf* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrView* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrActionSetCreateInfo* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrActionCreateInfo* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrActionSuggestedBinding* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrInteractionProfileSuggestedBinding* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrSessionActionSetsAttachInfo* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrInteractionProfileState* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrActionStateGetInfo* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrActionStateBoolean* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrActionStateFloat* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrVector2f* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrActionStateVector2f* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrActionStatePose* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrActiveActionSet* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrActionsSyncInfo* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrBoundSourcesForActionEnumerateInfo* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrInputSourceLocalizedNameGetInfo* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrHapticActionInfo* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrHapticBaseHeader* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrBaseInStructure* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrBaseOutStructure* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrOffset2Di* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrExtent2Di* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrRect2Di* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrSwapchainSubImage* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrCompositionLayerProjectionView* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrCompositionLayerProjection* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrCompositionLayerQuad* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrEventDataBaseHeader* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrEventDataEventsLost* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrEventDataInstanceLossPending* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrEventDataSessionStateChanged* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrEventDataReferenceSpaceChangePending* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrEventDataInteractionProfileChanged* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrHapticVibration* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrOffset2Df* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrRect2Df* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrVector4f* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrColor4f* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrColor3f* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrExtent3Df* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrSpheref* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrBoxf* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrFrustumf* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrUuid* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrSpacesLocateInfo* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrSpaceLocationData* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrSpaceLocations* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrSpaceVelocityData* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrSpaceVelocities* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrCompositionLayerCubeKHR* value);
#if defined(XR_USE_PLATFORM_ANDROID)
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrInstanceCreateInfoAndroidKHR* value);
#endif // defined(XR_USE_PLATFORM_ANDROID)
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrCompositionLayerDepthInfoKHR* value);
#if defined(XR_USE_GRAPHICS_API_VULKAN)
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrVulkanSwapchainFormatListCreateInfoKHR* value);
#endif // defined(XR_USE_GRAPHICS_API_VULKAN)
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrCompositionLayerCylinderKHR* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrCompositionLayerEquirectKHR* value);
#if defined(XR_USE_GRAPHICS_API_OPENGL) && defined(XR_USE_PLATFORM_WIN32)
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrGraphicsBindingOpenGLWin32KHR* value);
#endif // defined(XR_USE_GRAPHICS_API_OPENGL) && defined(XR_USE_PLATFORM_WIN32)
#if defined(XR_USE_GRAPHICS_API_OPENGL) && defined(XR_USE_PLATFORM_XLIB)
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrGraphicsBindingOpenGLXlibKHR* value);
#endif // defined(XR_USE_GRAPHICS_API_OPENGL) && defined(XR_USE_PLATFORM_XLIB)
#if defined(XR_USE_GRAPHICS_API_OPENGL) && defined(XR_USE_PLATFORM_XCB)
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrGraphicsBindingOpenGLXcbKHR* value);
#endif // defined(XR_USE_GRAPHICS_API_OPENGL) && defined(XR_USE_PLATFORM_XCB)
#if defined(XR_USE_GRAPHICS_API_OPENGL) && defined(XR_USE_PLATFORM_WAYLAND)
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrGraphicsBindingOpenGLWaylandKHR* value);
#endif // defined(XR_USE_GRAPHICS_API_OPENGL) && defined(XR_USE_PLATFORM_WAYLAND)
#if defined(XR_USE_GRAPHICS_API_OPENGL)
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrSwapchainImageOpenGLKHR* value);
#endif // defined(XR_USE_GRAPHICS_API_OPENGL)
#if defined(XR_USE_GRAPHICS_API_OPENGL)
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrGraphicsRequirementsOpenGLKHR* value);
#endif // defined(XR_USE_GRAPHICS_API_OPENGL)
#if defined(XR_USE_GRAPHICS_API_OPENGL_ES) && defined(XR_USE_PLATFORM_ANDROID)
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrGraphicsBindingOpenGLESAndroidKHR* value);
#endif // defined(XR_USE_GRAPHICS_API_OPENGL_ES) && defined(XR_USE_PLATFORM_ANDROID)
#if defined(XR_USE_GRAPHICS_API_OPENGL_ES)
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrSwapchainImageOpenGLESKHR* value);
#endif // defined(XR_USE_GRAPHICS_API_OPENGL_ES)
#if defined(XR_USE_GRAPHICS_API_OPENGL_ES)
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrGraphicsRequirementsOpenGLESKHR* value);
#endif // defined(XR_USE_GRAPHICS_API_OPENGL_ES)
#if defined(XR_USE_GRAPHICS_API_VULKAN)
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrGraphicsBindingVulkanKHR* value);
#endif // defined(XR_USE_GRAPHICS_API_VULKAN)
#if defined(XR_USE_GRAPHICS_API_VULKAN)
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrSwapchainImageVulkanKHR* value);
#endif // defined(XR_USE_GRAPHICS_API_VULKAN)
#if defined(XR_USE_GRAPHICS_API_VULKAN)
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrGraphicsRequirementsVulkanKHR* value);
#endif // defined(XR_USE_GRAPHICS_API_VULKAN)
#if defined(XR_USE_GRAPHICS_API_D3D11)
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrGraphicsBindingD3D11KHR* value);
#endif // defined(XR_USE_GRAPHICS_API_D3D11)
#if defined(XR_USE_GRAPHICS_API_D3D11)
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrSwapchainImageD3D11KHR* value);
#endif // defined(XR_USE_GRAPHICS_API_D3D11)
#if defined(XR_USE_GRAPHICS_API_D3D11)
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrGraphicsRequirementsD3D11KHR* value);
#endif // defined(XR_USE_GRAPHICS_API_D3D11)
#if defined(XR_USE_GRAPHICS_API_D3D12)
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrGraphicsBindingD3D12KHR* value);
#endif // defined(XR_USE_GRAPHICS_API_D3D12)
#if defined(XR_USE_GRAPHICS_API_D3D12)
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrSwapchainImageD3D12KHR* value);
#endif // defined(XR_USE_GRAPHICS_API_D3D12)
#if defined(XR_USE_GRAPHICS_API_D3D12)
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrGraphicsRequirementsD3D12KHR* value);
#endif // defined(XR_USE_GRAPHICS_API_D3D12)
#if defined(XR_USE_GRAPHICS_API_METAL)
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrGraphicsBindingMetalKHR* value);
#endif // defined(XR_USE_GRAPHICS_API_METAL)
#if defined(XR_USE_GRAPHICS_API_METAL)
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrSwapchainImageMetalKHR* value);
#endif // defined(XR_USE_GRAPHICS_API_METAL)
#if defined(XR_USE_GRAPHICS_API_METAL)
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrGraphicsRequirementsMetalKHR* value);
#endif // defined(XR_USE_GRAPHICS_API_METAL)
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrVisibilityMaskKHR* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrEventDataVisibilityMaskChangedKHR* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrCompositionLayerColorScaleBiasKHR* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrLoaderInitInfoBaseHeaderKHR* value);
#if defined(XR_USE_PLATFORM_ANDROID)
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrLoaderInitInfoAndroidKHR* value);
#endif // defined(XR_USE_PLATFORM_ANDROID)
#if defined(XR_USE_GRAPHICS_API_VULKAN)
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrVulkanInstanceCreateInfoKHR* value);
#endif // defined(XR_USE_GRAPHICS_API_VULKAN)
#if defined(XR_USE_GRAPHICS_API_VULKAN)
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrVulkanDeviceCreateInfoKHR* value);
#endif // defined(XR_USE_GRAPHICS_API_VULKAN)
#if defined(XR_USE_GRAPHICS_API_VULKAN)
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrVulkanGraphicsDeviceGetInfoKHR* value);
#endif // defined(XR_USE_GRAPHICS_API_VULKAN)
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrCompositionLayerEquirect2KHR* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrBindingModificationBaseHeaderKHR* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrBindingModificationsKHR* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrEventDataPerfSettingsEXT* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrDebugUtilsObjectNameInfoEXT* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrDebugUtilsLabelEXT* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrDebugUtilsMessengerCallbackDataEXT* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrDebugUtilsMessengerCreateInfoEXT* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrSystemEyeGazeInteractionPropertiesEXT* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrEyeGazeSampleTimeEXT* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrSessionCreateInfoOverlayEXTX* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrEventDataMainSessionVisibilityChangedEXTX* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrSpatialAnchorCreateInfoMSFT* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrSpatialAnchorSpaceCreateInfoMSFT* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrCompositionLayerImageLayoutFB* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrCompositionLayerAlphaBlendFB* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrViewConfigurationDepthRangeEXT* value);
#if defined(XR_USE_PLATFORM_EGL)
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrGraphicsBindingEGLMNDX* value);
#endif // defined(XR_USE_PLATFORM_EGL)
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrSpatialGraphNodeSpaceCreateInfoMSFT* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrSpatialGraphStaticNodeBindingCreateInfoMSFT* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrSpatialGraphNodeBindingPropertiesGetInfoMSFT* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrSpatialGraphNodeBindingPropertiesMSFT* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrSystemHandTrackingPropertiesEXT* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrHandTrackerCreateInfoEXT* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrHandJointsLocateInfoEXT* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrHandJointLocationEXT* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrHandJointVelocityEXT* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrHandJointLocationsEXT* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrHandJointVelocitiesEXT* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrSystemHandTrackingMeshPropertiesMSFT* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrHandMeshSpaceCreateInfoMSFT* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrHandMeshUpdateInfoMSFT* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrHandMeshIndexBufferMSFT* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrHandMeshVertexMSFT* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrHandMeshVertexBufferMSFT* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrHandMeshMSFT* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrHandPoseTypeInfoMSFT* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrSecondaryViewConfigurationSessionBeginInfoMSFT* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrSecondaryViewConfigurationStateMSFT* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrSecondaryViewConfigurationFrameStateMSFT* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrSecondaryViewConfigurationLayerInfoMSFT* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrSecondaryViewConfigurationFrameEndInfoMSFT* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrSecondaryViewConfigurationSwapchainCreateInfoMSFT* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrControllerModelKeyStateMSFT* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrControllerModelNodePropertiesMSFT* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrControllerModelPropertiesMSFT* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrControllerModelNodeStateMSFT* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrControllerModelStateMSFT* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrViewConfigurationViewFovEPIC* value);
#if defined(XR_USE_PLATFORM_WIN32) && defined(XR_USE_PLATFORM_WIN32)
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrHolographicWindowAttachmentMSFT* value);
#endif // defined(XR_USE_PLATFORM_WIN32) && defined(XR_USE_PLATFORM_WIN32)
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrCompositionLayerReprojectionInfoMSFT* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrCompositionLayerReprojectionPlaneOverrideMSFT* value);
#if defined(XR_USE_PLATFORM_ANDROID) && defined(XR_USE_PLATFORM_ANDROID)
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrAndroidSurfaceSwapchainCreateInfoFB* value);
#endif // defined(XR_USE_PLATFORM_ANDROID) && defined(XR_USE_PLATFORM_ANDROID)
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrSwapchainStateBaseHeaderFB* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrCompositionLayerSecureContentFB* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrBodyJointLocationFB* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrSystemBodyTrackingPropertiesFB* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrBodyTrackerCreateInfoFB* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrBodySkeletonJointFB* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrBodySkeletonFB* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrBodyJointsLocateInfoFB* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrBodyJointLocationsFB* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrInteractionProfileDpadBindingEXT* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrInteractionProfileAnalogThresholdVALVE* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrHandJointsMotionRangeInfoEXT* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrUuidMSFT* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrSceneObserverCreateInfoMSFT* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrSceneCreateInfoMSFT* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrSceneSphereBoundMSFT* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrSceneOrientedBoxBoundMSFT* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrSceneFrustumBoundMSFT* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrSceneBoundsMSFT* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrNewSceneComputeInfoMSFT* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrVisualMeshComputeLodInfoMSFT* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrSceneComponentMSFT* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrSceneComponentsMSFT* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrSceneComponentsGetInfoMSFT* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrSceneComponentLocationMSFT* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrSceneComponentLocationsMSFT* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrSceneComponentsLocateInfoMSFT* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrSceneObjectMSFT* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrSceneObjectsMSFT* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrSceneComponentParentFilterInfoMSFT* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrSceneObjectTypesFilterInfoMSFT* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrScenePlaneMSFT* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrScenePlanesMSFT* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrScenePlaneAlignmentFilterInfoMSFT* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrSceneMeshMSFT* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrSceneMeshesMSFT* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrSceneMeshBuffersGetInfoMSFT* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrSceneMeshBuffersMSFT* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrSceneMeshVertexBufferMSFT* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrSceneMeshIndicesUint32MSFT* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrSceneMeshIndicesUint16MSFT* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrSerializedSceneFragmentDataGetInfoMSFT* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrDeserializeSceneFragmentMSFT* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrSceneDeserializeInfoMSFT* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrEventDataDisplayRefreshRateChangedFB* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrViveTrackerPathsHTCX* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrEventDataViveTrackerConnectedHTCX* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrSystemFacialTrackingPropertiesHTC* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrFacialExpressionsHTC* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrFacialTrackerCreateInfoHTC* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrSystemColorSpacePropertiesFB* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrVector4sFB* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrHandTrackingMeshFB* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrHandTrackingScaleFB* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrHandTrackingAimStateFB* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrHandCapsuleFB* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrHandTrackingCapsulesStateFB* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrSystemSpatialEntityPropertiesFB* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrSpatialAnchorCreateInfoFB* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrSpaceComponentStatusSetInfoFB* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrSpaceComponentStatusFB* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrEventDataSpatialAnchorCreateCompleteFB* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrEventDataSpaceSetStatusCompleteFB* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrFoveationProfileCreateInfoFB* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrSwapchainCreateInfoFoveationFB* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrSwapchainStateFoveationFB* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrFoveationLevelProfileCreateInfoFB* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrSystemKeyboardTrackingPropertiesFB* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrKeyboardTrackingDescriptionFB* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrKeyboardSpaceCreateInfoFB* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrKeyboardTrackingQueryFB* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrTriangleMeshCreateInfoFB* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrSystemPassthroughPropertiesFB* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrSystemPassthroughProperties2FB* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrPassthroughCreateInfoFB* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrPassthroughLayerCreateInfoFB* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrCompositionLayerPassthroughFB* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrGeometryInstanceCreateInfoFB* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrGeometryInstanceTransformFB* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrPassthroughStyleFB* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrPassthroughColorMapMonoToRgbaFB* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrPassthroughColorMapMonoToMonoFB* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrPassthroughBrightnessContrastSaturationFB* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrEventDataPassthroughStateChangedFB* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrRenderModelPathInfoFB* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrRenderModelPropertiesFB* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrRenderModelBufferFB* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrRenderModelLoadInfoFB* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrSystemRenderModelPropertiesFB* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrRenderModelCapabilitiesRequestFB* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrViewLocateFoveatedRenderingVARJO* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrFoveatedViewConfigurationViewVARJO* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrSystemFoveatedRenderingPropertiesVARJO* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrCompositionLayerDepthTestVARJO* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrSystemMarkerTrackingPropertiesVARJO* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrEventDataMarkerTrackingUpdateVARJO* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrMarkerSpaceCreateInfoVARJO* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrFrameEndInfoML* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrGlobalDimmerFrameEndInfoML* value);
#if defined(XR_USE_PLATFORM_ML)
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrCoordinateSpaceCreateInfoML* value);
#endif // defined(XR_USE_PLATFORM_ML)
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrSystemMarkerUnderstandingPropertiesML* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrMarkerDetectorCreateInfoML* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrMarkerDetectorArucoInfoML* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrMarkerDetectorSizeInfoML* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrMarkerDetectorAprilTagInfoML* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrMarkerDetectorCustomProfileInfoML* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrMarkerDetectorSnapshotInfoML* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrMarkerDetectorStateML* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrMarkerSpaceCreateInfoML* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrLocalizationMapML* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrEventDataLocalizationChangedML* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrLocalizationMapQueryInfoBaseHeaderML* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrMapLocalizationRequestInfoML* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrLocalizationMapImportInfoML* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrLocalizationEnableEventsInfoML* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrSpatialAnchorsCreateInfoBaseHeaderML* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrSpatialAnchorsCreateInfoFromPoseML* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrCreateSpatialAnchorsCompletionML* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrSpatialAnchorStateML* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrSpatialAnchorsCreateStorageInfoML* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrSpatialAnchorsQueryInfoBaseHeaderML* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrSpatialAnchorsQueryInfoRadiusML* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrSpatialAnchorsQueryCompletionML* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrSpatialAnchorsCreateInfoFromUuidsML* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrSpatialAnchorsPublishInfoML* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrSpatialAnchorsPublishCompletionML* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrSpatialAnchorsDeleteInfoML* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrSpatialAnchorsDeleteCompletionML* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrSpatialAnchorsUpdateExpirationInfoML* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrSpatialAnchorsUpdateExpirationCompletionML* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrSpatialAnchorCompletionResultML* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrSpatialAnchorsPublishCompletionDetailsML* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrSpatialAnchorsDeleteCompletionDetailsML* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrSpatialAnchorsUpdateExpirationCompletionDetailsML* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrSpatialAnchorPersistenceNameMSFT* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrSpatialAnchorPersistenceInfoMSFT* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrSpatialAnchorFromPersistedAnchorCreateInfoMSFT* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrSceneMarkerMSFT* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrSceneMarkersMSFT* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrSceneMarkerTypeFilterMSFT* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrSceneMarkerQRCodeMSFT* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrSceneMarkerQRCodesMSFT* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrSpaceQueryInfoBaseHeaderFB* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrSpaceFilterInfoBaseHeaderFB* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrSpaceQueryInfoFB* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrSpaceStorageLocationFilterInfoFB* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrSpaceUuidFilterInfoFB* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrSpaceComponentFilterInfoFB* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrSpaceQueryResultFB* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrSpaceQueryResultsFB* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrEventDataSpaceQueryResultsAvailableFB* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrEventDataSpaceQueryCompleteFB* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrSpaceSaveInfoFB* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrSpaceEraseInfoFB* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrEventDataSpaceSaveCompleteFB* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrEventDataSpaceEraseCompleteFB* value);
#if defined(XR_USE_GRAPHICS_API_VULKAN)
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrSwapchainImageFoveationVulkanFB* value);
#endif // defined(XR_USE_GRAPHICS_API_VULKAN)
#if defined(XR_USE_PLATFORM_ANDROID) && defined(XR_USE_PLATFORM_ANDROID)
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrSwapchainStateAndroidSurfaceDimensionsFB* value);
#endif // defined(XR_USE_PLATFORM_ANDROID) && defined(XR_USE_PLATFORM_ANDROID)
#if defined(XR_USE_GRAPHICS_API_OPENGL_ES) && defined(XR_USE_GRAPHICS_API_OPENGL_ES)
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrSwapchainStateSamplerOpenGLESFB* value);
#endif // defined(XR_USE_GRAPHICS_API_OPENGL_ES) && defined(XR_USE_GRAPHICS_API_OPENGL_ES)
#if defined(XR_USE_GRAPHICS_API_VULKAN) && defined(XR_USE_GRAPHICS_API_VULKAN)
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrSwapchainStateSamplerVulkanFB* value);
#endif // defined(XR_USE_GRAPHICS_API_VULKAN) && defined(XR_USE_GRAPHICS_API_VULKAN)
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrSpaceShareInfoFB* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrEventDataSpaceShareCompleteFB* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrCompositionLayerSpaceWarpInfoFB* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrSystemSpaceWarpPropertiesFB* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrHapticAmplitudeEnvelopeVibrationFB* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrOffset3DfFB* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrRect3DfFB* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrSemanticLabelsFB* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrRoomLayoutFB* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrBoundary2DFB* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrSemanticLabelsSupportInfoFB* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrDigitalLensControlALMALENCE* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrEventDataSceneCaptureCompleteFB* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrSceneCaptureRequestInfoFB* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrSpaceContainerFB* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrFoveationEyeTrackedProfileCreateInfoMETA* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrFoveationEyeTrackedStateMETA* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrSystemFoveationEyeTrackedPropertiesMETA* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrSystemFaceTrackingPropertiesFB* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrFaceTrackerCreateInfoFB* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrFaceExpressionInfoFB* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrFaceExpressionStatusFB* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrFaceExpressionWeightsFB* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrEyeGazeFB* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrEyeTrackerCreateInfoFB* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrEyeGazesInfoFB* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrSystemEyeTrackingPropertiesFB* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrEyeGazesFB* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrPassthroughKeyboardHandsIntensityFB* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrCompositionLayerSettingsFB* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrHapticPcmVibrationFB* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrDevicePcmSampleRateStateFB* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrFrameSynthesisInfoEXT* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrFrameSynthesisConfigViewEXT* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrCompositionLayerDepthTestFB* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrLocalDimmingFrameEndInfoMETA* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrPassthroughPreferencesMETA* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrSystemVirtualKeyboardPropertiesMETA* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrVirtualKeyboardCreateInfoMETA* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrVirtualKeyboardSpaceCreateInfoMETA* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrVirtualKeyboardLocationInfoMETA* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrVirtualKeyboardModelVisibilitySetInfoMETA* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrVirtualKeyboardAnimationStateMETA* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrVirtualKeyboardModelAnimationStatesMETA* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrVirtualKeyboardTextureDataMETA* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrVirtualKeyboardInputInfoMETA* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrVirtualKeyboardTextContextChangeInfoMETA* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrEventDataVirtualKeyboardCommitTextMETA* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrEventDataVirtualKeyboardBackspaceMETA* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrEventDataVirtualKeyboardEnterMETA* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrEventDataVirtualKeyboardShownMETA* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrEventDataVirtualKeyboardHiddenMETA* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrExternalCameraIntrinsicsOCULUS* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrExternalCameraExtrinsicsOCULUS* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrExternalCameraOCULUS* value);
#if defined(XR_USE_GRAPHICS_API_VULKAN)
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrVulkanSwapchainCreateInfoMETA* value);
#endif // defined(XR_USE_GRAPHICS_API_VULKAN)
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrPerformanceMetricsStateMETA* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrPerformanceMetricsCounterMETA* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrSpaceListSaveInfoFB* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrEventDataSpaceListSaveCompleteFB* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrSpaceUserCreateInfoFB* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrSystemHeadsetIdPropertiesMETA* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrRecommendedLayerResolutionMETA* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrRecommendedLayerResolutionGetInfoMETA* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrSystemSpacePersistencePropertiesMETA* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrSpacesSaveInfoMETA* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrEventDataSpacesSaveResultMETA* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrSpacesEraseInfoMETA* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrEventDataSpacesEraseResultMETA* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrPassthroughColorLutDataMETA* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrPassthroughColorLutCreateInfoMETA* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrPassthroughColorLutUpdateInfoMETA* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrPassthroughColorMapLutMETA* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrPassthroughColorMapInterpolatedLutMETA* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrSystemPassthroughColorLutPropertiesMETA* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrSpaceTriangleMeshGetInfoMETA* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrSpaceTriangleMeshMETA* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrSystemPropertiesBodyTrackingFullBodyMETA* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrEventDataPassthroughLayerResumedMETA* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrBodyTrackingCalibrationStatusMETA* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrBodyTrackingCalibrationInfoMETA* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrSystemPropertiesBodyTrackingCalibrationMETA* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrSystemFaceTrackingProperties2FB* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrFaceTrackerCreateInfo2FB* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrFaceExpressionInfo2FB* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrFaceExpressionWeights2FB* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrSystemSpatialEntitySharingPropertiesMETA* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrShareSpacesRecipientBaseHeaderMETA* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrShareSpacesInfoMETA* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrEventDataShareSpacesCompleteMETA* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrEnvironmentDepthProviderCreateInfoMETA* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrEnvironmentDepthSwapchainCreateInfoMETA* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrEnvironmentDepthSwapchainStateMETA* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrEnvironmentDepthImageAcquireInfoMETA* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrEnvironmentDepthImageViewMETA* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrEnvironmentDepthImageMETA* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrEnvironmentDepthHandRemovalSetInfoMETA* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrSystemEnvironmentDepthPropertiesMETA* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrRenderModelCreateInfoEXT* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrRenderModelPropertiesGetInfoEXT* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrRenderModelPropertiesEXT* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrRenderModelSpaceCreateInfoEXT* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrRenderModelStateGetInfoEXT* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrRenderModelNodeStateEXT* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrRenderModelStateEXT* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrRenderModelAssetCreateInfoEXT* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrRenderModelAssetDataGetInfoEXT* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrRenderModelAssetDataEXT* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrRenderModelAssetPropertiesGetInfoEXT* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrRenderModelAssetNodePropertiesEXT* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrRenderModelAssetPropertiesEXT* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrInteractionRenderModelIdsEnumerateInfoEXT* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrInteractionRenderModelSubactionPathInfoEXT* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrInteractionRenderModelTopLevelUserPathGetInfoEXT* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrEventDataInteractionRenderModelsChangedEXT* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrPassthroughCreateInfoHTC* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrPassthroughColorHTC* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrPassthroughMeshTransformInfoHTC* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrCompositionLayerPassthroughHTC* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrFoveationApplyInfoHTC* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrFoveationConfigurationHTC* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrFoveationDynamicModeInfoHTC* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrFoveationCustomModeInfoHTC* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrSystemAnchorPropertiesHTC* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrSpatialAnchorNameHTC* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrSpatialAnchorCreateInfoHTC* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrSystemBodyTrackingPropertiesHTC* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrBodyTrackerCreateInfoHTC* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrBodyJointsLocateInfoHTC* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrBodyJointLocationHTC* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrBodyJointLocationsHTC* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrBodySkeletonJointHTC* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrBodySkeletonHTC* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrActiveActionSetPriorityEXT* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrActiveActionSetPrioritiesEXT* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrSystemForceFeedbackCurlPropertiesMNDX* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrForceFeedbackCurlApplyLocationMNDX* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrForceFeedbackCurlApplyLocationsMNDX* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrSystemBodyTrackingPropertiesBD* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrBodyTrackerCreateInfoBD* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrBodyJointsLocateInfoBD* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrBodyJointLocationBD* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrBodyJointLocationsBD* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrSystemSpatialSensingPropertiesBD* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrSpatialEntityComponentGetInfoBD* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrSpatialEntityComponentDataBaseHeaderBD* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrSpatialEntityLocationGetInfoBD* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrSpatialEntityComponentDataLocationBD* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrSpatialEntityComponentDataSemanticBD* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrSpatialEntityComponentDataBoundingBox2DBD* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrSpatialEntityComponentDataPolygonBD* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrSpatialEntityComponentDataBoundingBox3DBD* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrSpatialEntityComponentDataTriangleMeshBD* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrSenseDataProviderCreateInfoBD* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrSenseDataProviderStartInfoBD* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrEventDataSenseDataProviderStateChangedBD* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrEventDataSenseDataUpdatedBD* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrSenseDataQueryInfoBD* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrSenseDataQueryCompletionBD* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrQueriedSenseDataGetInfoBD* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrSpatialEntityStateBD* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrQueriedSenseDataBD* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrSenseDataFilterUuidBD* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrSenseDataFilterSemanticBD* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrSpatialEntityAnchorCreateInfoBD* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrAnchorSpaceCreateInfoBD* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrFutureCompletionEXT* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrSystemSpatialAnchorPropertiesBD* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrSpatialAnchorCreateInfoBD* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrSpatialAnchorCreateCompletionBD* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrSpatialAnchorPersistInfoBD* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrSpatialAnchorUnpersistInfoBD* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrSystemSpatialAnchorSharingPropertiesBD* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrSpatialAnchorShareInfoBD* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrSharedSpatialAnchorDownloadInfoBD* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrSystemSpatialScenePropertiesBD* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrSceneCaptureInfoBD* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrSystemSpatialMeshPropertiesBD* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrSenseDataProviderCreateInfoSpatialMeshBD* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrFuturePollResultProgressBD* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrSystemSpatialPlanePropertiesBD* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrSpatialEntityComponentDataPlaneOrientationBD* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrSenseDataFilterPlaneOrientationBD* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrHandTrackingDataSourceInfoEXT* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrHandTrackingDataSourceStateEXT* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrSystemPlaneDetectionPropertiesEXT* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrPlaneDetectorCreateInfoEXT* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrPlaneDetectorBeginInfoEXT* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrPlaneDetectorGetInfoEXT* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrPlaneDetectorLocationEXT* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrPlaneDetectorLocationsEXT* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrPlaneDetectorPolygonBufferEXT* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrTrackableTrackerCreateInfoANDROID* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrTrackableGetInfoANDROID* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrTrackablePlaneANDROID* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrAnchorSpaceCreateInfoANDROID* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrSystemTrackablesPropertiesANDROID* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrDeviceAnchorPersistenceCreateInfoANDROID* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrPersistedAnchorSpaceCreateInfoANDROID* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrPersistedAnchorSpaceInfoANDROID* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrSystemDeviceAnchorPersistencePropertiesANDROID* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrSystemPassthroughCameraStatePropertiesANDROID* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrPassthroughCameraStateGetInfoANDROID* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrRaycastInfoANDROID* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrRaycastHitResultANDROID* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrRaycastHitResultsANDROID* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrTrackableObjectANDROID* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrTrackableObjectConfigurationANDROID* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrFutureCancelInfoEXT* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrFuturePollInfoEXT* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrFutureCompletionBaseHeaderEXT* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrFuturePollResultEXT* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrEventDataUserPresenceChangedEXT* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrSystemUserPresencePropertiesEXT* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrEventDataHeadsetFitChangedML* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrEventDataEyeCalibrationChangedML* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrUserCalibrationEnableEventsInfoML* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrSystemNotificationsSetInfoML* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrWorldMeshDetectorCreateInfoML* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrWorldMeshBlockStateML* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrWorldMeshStateRequestInfoML* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrWorldMeshStateRequestCompletionML* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrWorldMeshBufferRecommendedSizeInfoML* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrWorldMeshBufferSizeML* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrWorldMeshBufferML* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrWorldMeshBlockRequestML* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrWorldMeshGetInfoML* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrWorldMeshBlockML* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrWorldMeshRequestCompletionInfoML* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrWorldMeshRequestCompletionML* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrSystemFacialExpressionPropertiesML* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrFacialExpressionClientCreateInfoML* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrFacialExpressionBlendShapeGetInfoML* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrFacialExpressionBlendShapePropertiesML* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrSystemSimultaneousHandsAndControllersPropertiesMETA* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrSimultaneousHandsAndControllersTrackingResumeInfoMETA* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrSimultaneousHandsAndControllersTrackingPauseInfoMETA* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrColocationDiscoveryStartInfoMETA* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrColocationDiscoveryStopInfoMETA* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrColocationAdvertisementStartInfoMETA* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrColocationAdvertisementStopInfoMETA* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrEventDataStartColocationAdvertisementCompleteMETA* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrEventDataStopColocationAdvertisementCompleteMETA* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrEventDataColocationAdvertisementCompleteMETA* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrEventDataStartColocationDiscoveryCompleteMETA* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrEventDataColocationDiscoveryResultMETA* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrEventDataColocationDiscoveryCompleteMETA* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrEventDataStopColocationDiscoveryCompleteMETA* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrSystemColocationDiscoveryPropertiesMETA* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrSystemSpatialEntityGroupSharingPropertiesMETA* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrShareSpacesRecipientGroupsMETA* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrSpaceGroupUuidFilterInfoMETA* value);
#if defined(XR_USE_PLATFORM_ANDROID)
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrAnchorSharingInfoANDROID* value);
#endif // defined(XR_USE_PLATFORM_ANDROID)
#if defined(XR_USE_PLATFORM_ANDROID)
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrAnchorSharingTokenANDROID* value);
#endif // defined(XR_USE_PLATFORM_ANDROID)
#if defined(XR_USE_PLATFORM_ANDROID)
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrSystemAnchorSharingExportPropertiesANDROID* value);
#endif // defined(XR_USE_PLATFORM_ANDROID)
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrSystemMarkerTrackingPropertiesANDROID* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrTrackableMarkerDatabaseEntryANDROID* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrTrackableMarkerDatabaseANDROID* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrTrackableMarkerConfigurationANDROID* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrTrackableMarkerANDROID* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrSpatialCapabilityComponentTypesEXT* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrSpatialCapabilityConfigurationBaseHeaderEXT* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrSpatialContextCreateInfoEXT* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrCreateSpatialContextCompletionEXT* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrSpatialDiscoverySnapshotCreateInfoEXT* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrCreateSpatialDiscoverySnapshotCompletionInfoEXT* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrCreateSpatialDiscoverySnapshotCompletionEXT* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrSpatialComponentDataQueryConditionEXT* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrSpatialComponentDataQueryResultEXT* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrSpatialBufferEXT* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrSpatialBufferGetInfoEXT* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrSpatialBounded2DDataEXT* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrSpatialComponentBounded2DListEXT* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrSpatialComponentBounded3DListEXT* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrSpatialComponentParentListEXT* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrSpatialMeshDataEXT* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrSpatialComponentMesh3DListEXT* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrSpatialEntityFromIdCreateInfoEXT* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrSpatialUpdateSnapshotCreateInfoEXT* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrEventDataSpatialDiscoveryRecommendedEXT* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrSpatialFilterTrackingStateEXT* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrSpatialCapabilityConfigurationPlaneTrackingEXT* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrSpatialComponentPlaneAlignmentListEXT* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrSpatialComponentMesh2DListEXT* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrSpatialPolygon2DDataEXT* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrSpatialComponentPolygon2DListEXT* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrSpatialComponentPlaneSemanticLabelListEXT* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrSpatialCapabilityConfigurationQrCodeEXT* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrSpatialCapabilityConfigurationMicroQrCodeEXT* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrSpatialCapabilityConfigurationArucoMarkerEXT* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrSpatialCapabilityConfigurationAprilTagEXT* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrSpatialMarkerSizeEXT* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrSpatialMarkerStaticOptimizationEXT* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrSpatialMarkerDataEXT* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrSpatialComponentMarkerListEXT* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrSpatialCapabilityConfigurationAnchorEXT* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrSpatialComponentAnchorListEXT* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrSpatialAnchorCreateInfoEXT* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrSpatialPersistenceContextCreateInfoEXT* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrCreateSpatialPersistenceContextCompletionEXT* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrSpatialContextPersistenceConfigEXT* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrSpatialDiscoveryPersistenceUuidFilterEXT* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrSpatialPersistenceDataEXT* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrSpatialComponentPersistenceListEXT* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrSpatialEntityPersistInfoEXT* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrPersistSpatialEntityCompletionEXT* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrSpatialEntityUnpersistInfoEXT* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrUnpersistSpatialEntityCompletionEXT* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrLoaderInitPropertyValueEXT* value);
XrResult ValidateXrStruct(GenValidUsageXrInstanceInfo *instance_info, const std::string &command_name,
                          std::vector<GenValidUsageXrObjectInfo>& objects_info, bool check_members, bool check_pnext,
                          const XrLoaderInitInfoPropertiesEXT* value);
// Function used to clean up any residual map values that point to an instance prior to that
// instance being deleted.
void GenValidUsageCleanUpMaps(GenValidUsageXrInstanceInfo *instance_info) {
    EraseAllInstanceTableMapElements(instance_info);
    g_session_info.removeHandlesForInstance(instance_info);
    g_space_info.removeHandlesForInstance(instance_info);
    g_action_info.removeHandlesForInstance(instance_info);
    g_swapchain_info.removeHandlesForInstance(instance_info);
    g_actionset_info.removeHandlesForInstance(instance_info);
    g_debugutilsmessengerext_info.removeHandlesForInstance(instance_info);
    g_spatialanchormsft_info.removeHandlesForInstance(instance_info);
    g_spatialgraphnodebindingmsft_info.removeHandlesForInstance(instance_info);
    g_handtrackerext_info.removeHandlesForInstance(instance_info);
    g_bodytrackerfb_info.removeHandlesForInstance(instance_info);
    g_sceneobservermsft_info.removeHandlesForInstance(instance_info);
    g_scenemsft_info.removeHandlesForInstance(instance_info);
    g_facialtrackerhtc_info.removeHandlesForInstance(instance_info);
    g_foveationprofilefb_info.removeHandlesForInstance(instance_info);
    g_trianglemeshfb_info.removeHandlesForInstance(instance_info);
    g_passthroughfb_info.removeHandlesForInstance(instance_info);
    g_passthroughlayerfb_info.removeHandlesForInstance(instance_info);
    g_geometryinstancefb_info.removeHandlesForInstance(instance_info);
    g_markerdetectorml_info.removeHandlesForInstance(instance_info);
    g_exportedlocalizationmapml_info.removeHandlesForInstance(instance_info);
    g_spatialanchorsstorageml_info.removeHandlesForInstance(instance_info);
    g_spatialanchorstoreconnectionmsft_info.removeHandlesForInstance(instance_info);
    g_spaceuserfb_info.removeHandlesForInstance(instance_info);
    g_facetrackerfb_info.removeHandlesForInstance(instance_info);
    g_eyetrackerfb_info.removeHandlesForInstance(instance_info);
    g_virtualkeyboardmeta_info.removeHandlesForInstance(instance_info);
    g_passthroughcolorlutmeta_info.removeHandlesForInstance(instance_info);
    g_facetracker2fb_info.removeHandlesForInstance(instance_info);
    g_environmentdepthprovidermeta_info.removeHandlesForInstance(instance_info);
    g_environmentdepthswapchainmeta_info.removeHandlesForInstance(instance_info);
    g_rendermodelext_info.removeHandlesForInstance(instance_info);
    g_rendermodelassetext_info.removeHandlesForInstance(instance_info);
    g_passthroughhtc_info.removeHandlesForInstance(instance_info);
    g_bodytrackerhtc_info.removeHandlesForInstance(instance_info);
    g_bodytrackerbd_info.removeHandlesForInstance(instance_info);
    g_sensedataproviderbd_info.removeHandlesForInstance(instance_info);
    g_sensedatasnapshotbd_info.removeHandlesForInstance(instance_info);
    g_anchorbd_info.removeHandlesForInstance(instance_info);
    g_planedetectorext_info.removeHandlesForInstance(instance_info);
    g_trackabletrackerandroid_info.removeHandlesForInstance(instance_info);
    g_deviceanchorpersistenceandroid_info.removeHandlesForInstance(instance_info);
    g_worldmeshdetectorml_info.removeHandlesForInstance(instance_info);
    g_facialexpressionclientml_info.removeHandlesForInstance(instance_info);
    g_spatialentityext_info.removeHandlesForInstance(instance_info);
    g_spatialcontextext_info.removeHandlesForInstance(instance_info);
    g_spatialsnapshotext_info.removeHandlesForInstance(instance_info);
    g_spatialpersistencecontextext_info.removeHandlesForInstance(instance_info);
}

// Function to convert XrObjectType to string
std::string GenValidUsageXrObjectTypeToString(const XrObjectType& type) {
    std::string object_string;
    if (type == XR_OBJECT_TYPE_UNKNOWN) {
        object_string = "Unknown XR Object";
    } else if (type == XR_OBJECT_TYPE_INSTANCE) {
        object_string = "XrInstance";
    } else if (type == XR_OBJECT_TYPE_SESSION) {
        object_string = "XrSession";
    } else if (type == XR_OBJECT_TYPE_SWAPCHAIN) {
        object_string = "XrSwapchain";
    } else if (type == XR_OBJECT_TYPE_SPACE) {
        object_string = "XrSpace";
    } else if (type == XR_OBJECT_TYPE_ACTION_SET) {
        object_string = "XrActionSet";
    } else if (type == XR_OBJECT_TYPE_ACTION) {
        object_string = "XrAction";
    } else if (type == XR_OBJECT_TYPE_DEBUG_UTILS_MESSENGER_EXT) {
        object_string = "XrDebugUtilsMessengerEXT";
    } else if (type == XR_OBJECT_TYPE_SPATIAL_ANCHOR_MSFT) {
        object_string = "XrSpatialAnchorMSFT";
    } else if (type == XR_OBJECT_TYPE_SPATIAL_GRAPH_NODE_BINDING_MSFT) {
        object_string = "XrSpatialGraphNodeBindingMSFT";
    } else if (type == XR_OBJECT_TYPE_HAND_TRACKER_EXT) {
        object_string = "XrHandTrackerEXT";
    } else if (type == XR_OBJECT_TYPE_BODY_TRACKER_FB) {
        object_string = "XrBodyTrackerFB";
    } else if (type == XR_OBJECT_TYPE_SCENE_OBSERVER_MSFT) {
        object_string = "XrSceneObserverMSFT";
    } else if (type == XR_OBJECT_TYPE_SCENE_MSFT) {
        object_string = "XrSceneMSFT";
    } else if (type == XR_OBJECT_TYPE_FACIAL_TRACKER_HTC) {
        object_string = "XrFacialTrackerHTC";
    } else if (type == XR_OBJECT_TYPE_FOVEATION_PROFILE_FB) {
        object_string = "XrFoveationProfileFB";
    } else if (type == XR_OBJECT_TYPE_TRIANGLE_MESH_FB) {
        object_string = "XrTriangleMeshFB";
    } else if (type == XR_OBJECT_TYPE_PASSTHROUGH_FB) {
        object_string = "XrPassthroughFB";
    } else if (type == XR_OBJECT_TYPE_PASSTHROUGH_LAYER_FB) {
        object_string = "XrPassthroughLayerFB";
    } else if (type == XR_OBJECT_TYPE_GEOMETRY_INSTANCE_FB) {
        object_string = "XrGeometryInstanceFB";
    } else if (type == XR_OBJECT_TYPE_MARKER_DETECTOR_ML) {
        object_string = "XrMarkerDetectorML";
    } else if (type == XR_OBJECT_TYPE_EXPORTED_LOCALIZATION_MAP_ML) {
        object_string = "XrExportedLocalizationMapML";
    } else if (type == XR_OBJECT_TYPE_SPATIAL_ANCHORS_STORAGE_ML) {
        object_string = "XrSpatialAnchorsStorageML";
    } else if (type == XR_OBJECT_TYPE_SPATIAL_ANCHOR_STORE_CONNECTION_MSFT) {
        object_string = "XrSpatialAnchorStoreConnectionMSFT";
    } else if (type == XR_OBJECT_TYPE_FACE_TRACKER_FB) {
        object_string = "XrFaceTrackerFB";
    } else if (type == XR_OBJECT_TYPE_EYE_TRACKER_FB) {
        object_string = "XrEyeTrackerFB";
    } else if (type == XR_OBJECT_TYPE_VIRTUAL_KEYBOARD_META) {
        object_string = "XrVirtualKeyboardMETA";
    } else if (type == XR_OBJECT_TYPE_SPACE_USER_FB) {
        object_string = "XrSpaceUserFB";
    } else if (type == XR_OBJECT_TYPE_PASSTHROUGH_COLOR_LUT_META) {
        object_string = "XrPassthroughColorLutMETA";
    } else if (type == XR_OBJECT_TYPE_FACE_TRACKER2_FB) {
        object_string = "XrFaceTracker2FB";
    } else if (type == XR_OBJECT_TYPE_ENVIRONMENT_DEPTH_PROVIDER_META) {
        object_string = "XrEnvironmentDepthProviderMETA";
    } else if (type == XR_OBJECT_TYPE_ENVIRONMENT_DEPTH_SWAPCHAIN_META) {
        object_string = "XrEnvironmentDepthSwapchainMETA";
    } else if (type == XR_OBJECT_TYPE_RENDER_MODEL_EXT) {
        object_string = "XrRenderModelEXT";
    } else if (type == XR_OBJECT_TYPE_RENDER_MODEL_ASSET_EXT) {
        object_string = "XrRenderModelAssetEXT";
    } else if (type == XR_OBJECT_TYPE_PASSTHROUGH_HTC) {
        object_string = "XrPassthroughHTC";
    } else if (type == XR_OBJECT_TYPE_BODY_TRACKER_HTC) {
        object_string = "XrBodyTrackerHTC";
    } else if (type == XR_OBJECT_TYPE_BODY_TRACKER_BD) {
        object_string = "XrBodyTrackerBD";
    } else if (type == XR_OBJECT_TYPE_SENSE_DATA_PROVIDER_BD) {
        object_string = "XrSenseDataProviderBD";
    } else if (type == XR_OBJECT_TYPE_SENSE_DATA_SNAPSHOT_BD) {
        object_string = "XrSenseDataSnapshotBD";
    } else if (type == XR_OBJECT_TYPE_ANCHOR_BD) {
        object_string = "XrAnchorBD";
    } else if (type == XR_OBJECT_TYPE_PLANE_DETECTOR_EXT) {
        object_string = "XrPlaneDetectorEXT";
    } else if (type == XR_OBJECT_TYPE_TRACKABLE_TRACKER_ANDROID) {
        object_string = "XrTrackableTrackerANDROID";
    } else if (type == XR_OBJECT_TYPE_DEVICE_ANCHOR_PERSISTENCE_ANDROID) {
        object_string = "XrDeviceAnchorPersistenceANDROID";
    } else if (type == XR_OBJECT_TYPE_WORLD_MESH_DETECTOR_ML) {
        object_string = "XrWorldMeshDetectorML";
    } else if (type == XR_OBJECT_TYPE_FACIAL_EXPRESSION_CLIENT_ML) {
        object_string = "XrFacialExpressionClientML";
    } else if (type == XR_OBJECT_TYPE_SPATIAL_ENTITY_EXT) {
        object_string = "XrSpatialEntityEXT";
    } else if (type == XR_OBJECT_TYPE_SPATIAL_CONTEXT_EXT) {
        object_string = "XrSpatialContextEXT";
    } else if (type == XR_OBJECT_TYPE_SPATIAL_SNAPSHOT_EXT) {
        object_string = "XrSpatialSnapshotEXT";
    } else if (type == XR_OBJECT_TYPE_SPATIAL_PERSISTENCE_CONTEXT_EXT) {
        object_string = "XrSpatialPersistenceContextEXT";
    }
    return object_string;
}

// Structure used for state validation.

// Result return value for next chain validation
enum NextChainResult {
    NEXT_CHAIN_RESULT_VALID = 0,
    NEXT_CHAIN_RESULT_ERROR = -1,
};

// Prototype for validateNextChain command (it uses the validate structure commands so add it after
NextChainResult ValidateNextChain(GenValidUsageXrInstanceInfo *instance_info,
                                  const std::string &command_name,
                                  std::vector<GenValidUsageXrObjectInfo>& objects_info,
                                  const void* next,
                                  std::unordered_set<XrStructureType>& valid_ext_structs,
                                  std::unordered_set<XrStructureType>& encountered_structs,
                                  std::unordered_set<XrStructureType>& unknown_structs,
                                  std::unordered_set<XrStructureType>& duplicate_structs);

// Function to validate XrInstanceCreateFlags flags
ValidateXrFlagsResult ValidateXrInstanceCreateFlags(const XrFlags64 value) {
    if (0 == value) {
        return VALIDATE_XR_FLAGS_ZERO;
    }
    XrFlags64 int_value = value;
    if (int_value != 0) {
        // Something is left, it must be invalid
        return VALIDATE_XR_FLAGS_INVALID;
    }
    return VALIDATE_XR_FLAGS_SUCCESS;
}

// Function to validate XrSessionCreateFlags flags
ValidateXrFlagsResult ValidateXrSessionCreateFlags(const XrFlags64 value) {
    if (0 == value) {
        return VALIDATE_XR_FLAGS_ZERO;
    }
    XrFlags64 int_value = value;
    if (int_value != 0) {
        // Something is left, it must be invalid
        return VALIDATE_XR_FLAGS_INVALID;
    }
    return VALIDATE_XR_FLAGS_SUCCESS;
}

// Function to validate XrSpaceVelocityFlags flags
ValidateXrFlagsResult ValidateXrSpaceVelocityFlags(const XrFlags64 value) {
    if (0 == value) {
        return VALIDATE_XR_FLAGS_ZERO;
    }
    XrFlags64 int_value = value;
    if ((int_value & XR_SPACE_VELOCITY_LINEAR_VALID_BIT) != 0) {
        // Clear the value XR_SPACE_VELOCITY_LINEAR_VALID_BIT since it is valid
        int_value &= ~XR_SPACE_VELOCITY_LINEAR_VALID_BIT;
    }
    if ((int_value & XR_SPACE_VELOCITY_ANGULAR_VALID_BIT) != 0) {
        // Clear the value XR_SPACE_VELOCITY_ANGULAR_VALID_BIT since it is valid
        int_value &= ~XR_SPACE_VELOCITY_ANGULAR_VALID_BIT;
    }
    if (int_value != 0) {
        // Something is left, it must be invalid
        return VALIDATE_XR_FLAGS_INVALID;
    }
    return VALIDATE_XR_FLAGS_SUCCESS;
}

// Function to validate XrSpaceLocationFlags flags
ValidateXrFlagsResult ValidateXrSpaceLocationFlags(const XrFlags64 value) {
    if (0 == value) {
        return VALIDATE_XR_FLAGS_ZERO;
    }
    XrFlags64 int_value = value;
    if ((int_value & XR_SPACE_LOCATION_ORIENTATION_VALID_BIT) != 0) {
        // Clear the value XR_SPACE_LOCATION_ORIENTATION_VALID_BIT since it is valid
        int_value &= ~XR_SPACE_LOCATION_ORIENTATION_VALID_BIT;
    }
    if ((int_value & XR_SPACE_LOCATION_POSITION_VALID_BIT) != 0) {
        // Clear the value XR_SPACE_LOCATION_POSITION_VALID_BIT since it is valid
        int_value &= ~XR_SPACE_LOCATION_POSITION_VALID_BIT;
    }
    if ((int_value & XR_SPACE_LOCATION_ORIENTATION_TRACKED_BIT) != 0) {
        // Clear the value XR_SPACE_LOCATION_ORIENTATION_TRACKED_BIT since it is valid
        int_value &= ~XR_SPACE_LOCATION_ORIENTATION_TRACKED_BIT;
    }
    if ((int_value & XR_SPACE_LOCATION_POSITION_TRACKED_BIT) != 0) {
        // Clear the value XR_SPACE_LOCATION_POSITION_TRACKED_BIT since it is valid
        int_value &= ~XR_SPACE_LOCATION_POSITION_TRACKED_BIT;
    }
    if (int_value != 0) {
        // Something is left, it must be invalid
        return VALIDATE_XR_FLAGS_INVALID;
    }
    return VALIDATE_XR_FLAGS_SUCCESS;
}

// Function to validate XrSwapchainCreateFlags flags
ValidateXrFlagsResult ValidateXrSwapchainCreateFlags(const XrFlags64 value) {
    if (0 == value) {
        return VALIDATE_XR_FLAGS_ZERO;
    }
    XrFlags64 int_value = value;
    if ((int_value & XR_SWAPCHAIN_CREATE_PROTECTED_CONTENT_BIT) != 0) {
        // Clear the value XR_SWAPCHAIN_CREATE_PROTECTED_CONTENT_BIT since it is valid
        int_value &= ~XR_SWAPCHAIN_CREATE_PROTECTED_CONTENT_BIT;
    }
    if ((int_value & XR_SWAPCHAIN_CREATE_STATIC_IMAGE_BIT) != 0) {
        // Clear the value XR_SWAPCHAIN_CREATE_STATIC_IMAGE_BIT since it is valid
        int_value &= ~XR_SWAPCHAIN_CREATE_STATIC_IMAGE_BIT;
    }
    if (int_value != 0) {
        // Something is left, it must be invalid
        return VALIDATE_XR_FLAGS_INVALID;
    }
    return VALIDATE_XR_FLAGS_SUCCESS;
}

// Function to validate XrSwapchainUsageFlags flags
ValidateXrFlagsResult ValidateXrSwapchainUsageFlags(const XrFlags64 value) {
    if (0 == value) {
        return VALIDATE_XR_FLAGS_ZERO;
    }
    XrFlags64 int_value = value;
    if ((int_value & XR_SWAPCHAIN_USAGE_COLOR_ATTACHMENT_BIT) != 0) {
        // Clear the value XR_SWAPCHAIN_USAGE_COLOR_ATTACHMENT_BIT since it is valid
        int_value &= ~XR_SWAPCHAIN_USAGE_COLOR_ATTACHMENT_BIT;
    }
    if ((int_value & XR_SWAPCHAIN_USAGE_DEPTH_STENCIL_ATTACHMENT_BIT) != 0) {
        // Clear the value XR_SWAPCHAIN_USAGE_DEPTH_STENCIL_ATTACHMENT_BIT since it is valid
        int_value &= ~XR_SWAPCHAIN_USAGE_DEPTH_STENCIL_ATTACHMENT_BIT;
    }
    if ((int_value & XR_SWAPCHAIN_USAGE_UNORDERED_ACCESS_BIT) != 0) {
        // Clear the value XR_SWAPCHAIN_USAGE_UNORDERED_ACCESS_BIT since it is valid
        int_value &= ~XR_SWAPCHAIN_USAGE_UNORDERED_ACCESS_BIT;
    }
    if ((int_value & XR_SWAPCHAIN_USAGE_TRANSFER_SRC_BIT) != 0) {
        // Clear the value XR_SWAPCHAIN_USAGE_TRANSFER_SRC_BIT since it is valid
        int_value &= ~XR_SWAPCHAIN_USAGE_TRANSFER_SRC_BIT;
    }
    if ((int_value & XR_SWAPCHAIN_USAGE_TRANSFER_DST_BIT) != 0) {
        // Clear the value XR_SWAPCHAIN_USAGE_TRANSFER_DST_BIT since it is valid
        int_value &= ~XR_SWAPCHAIN_USAGE_TRANSFER_DST_BIT;
    }
    if ((int_value & XR_SWAPCHAIN_USAGE_SAMPLED_BIT) != 0) {
        // Clear the value XR_SWAPCHAIN_USAGE_SAMPLED_BIT since it is valid
        int_value &= ~XR_SWAPCHAIN_USAGE_SAMPLED_BIT;
    }
    if ((int_value & XR_SWAPCHAIN_USAGE_MUTABLE_FORMAT_BIT) != 0) {
        // Clear the value XR_SWAPCHAIN_USAGE_MUTABLE_FORMAT_BIT since it is valid
        int_value &= ~XR_SWAPCHAIN_USAGE_MUTABLE_FORMAT_BIT;
    }
    if ((int_value & XR_SWAPCHAIN_USAGE_INPUT_ATTACHMENT_BIT_MND) != 0) {
        // Clear the value XR_SWAPCHAIN_USAGE_INPUT_ATTACHMENT_BIT_MND since it is valid
        int_value &= ~XR_SWAPCHAIN_USAGE_INPUT_ATTACHMENT_BIT_MND;
    }
    if ((int_value & XR_SWAPCHAIN_USAGE_INPUT_ATTACHMENT_BIT_KHR) != 0) {
        // Clear the value XR_SWAPCHAIN_USAGE_INPUT_ATTACHMENT_BIT_KHR since it is valid
        int_value &= ~XR_SWAPCHAIN_USAGE_INPUT_ATTACHMENT_BIT_KHR;
    }
    if (int_value != 0) {
        // Something is left, it must be invalid
        return VALIDATE_XR_FLAGS_INVALID;
    }
    return VALIDATE_XR_FLAGS_SUCCESS;
}

// Function to validate XrCompositionLayerFlags flags
ValidateXrFlagsResult ValidateXrCompositionLayerFlags(const XrFlags64 value) {
    if (0 == value) {
        return VALIDATE_XR_FLAGS_ZERO;
    }
    XrFlags64 int_value = value;
    if ((int_value & XR_COMPOSITION_LAYER_CORRECT_CHROMATIC_ABERRATION_BIT) != 0) {
        // Clear the value XR_COMPOSITION_LAYER_CORRECT_CHROMATIC_ABERRATION_BIT since it is valid
        int_value &= ~XR_COMPOSITION_LAYER_CORRECT_CHROMATIC_ABERRATION_BIT;
    }
    if ((int_value & XR_COMPOSITION_LAYER_BLEND_TEXTURE_SOURCE_ALPHA_BIT) != 0) {
        // Clear the value XR_COMPOSITION_LAYER_BLEND_TEXTURE_SOURCE_ALPHA_BIT since it is valid
        int_value &= ~XR_COMPOSITION_LAYER_BLEND_TEXTURE_SOURCE_ALPHA_BIT;
    }
    if ((int_value & XR_COMPOSITION_LAYER_UNPREMULTIPLIED_ALPHA_BIT) != 0) {
        // Clear the value XR_COMPOSITION_LAYER_UNPREMULTIPLIED_ALPHA_BIT since it is valid
        int_value &= ~XR_COMPOSITION_LAYER_UNPREMULTIPLIED_ALPHA_BIT;
    }
    if ((int_value & XR_COMPOSITION_LAYER_INVERTED_ALPHA_BIT_EXT) != 0) {
        // Clear the value XR_COMPOSITION_LAYER_INVERTED_ALPHA_BIT_EXT since it is valid
        int_value &= ~XR_COMPOSITION_LAYER_INVERTED_ALPHA_BIT_EXT;
    }
    if (int_value != 0) {
        // Something is left, it must be invalid
        return VALIDATE_XR_FLAGS_INVALID;
    }
    return VALIDATE_XR_FLAGS_SUCCESS;
}

// Function to validate XrViewStateFlags flags
ValidateXrFlagsResult ValidateXrViewStateFlags(const XrFlags64 value) {
    if (0 == value) {
        return VALIDATE_XR_FLAGS_ZERO;
    }
    XrFlags64 int_value = value;
    if ((int_value & XR_VIEW_STATE_ORIENTATION_VALID_BIT) != 0) {
        // Clear the value XR_VIEW_STATE_ORIENTATION_VALID_BIT since it is valid
        int_value &= ~XR_VIEW_STATE_ORIENTATION_VALID_BIT;
    }
    if ((int_value & XR_VIEW_STATE_POSITION_VALID_BIT) != 0) {
        // Clear the value XR_VIEW_STATE_POSITION_VALID_BIT since it is valid
        int_value &= ~XR_VIEW_STATE_POSITION_VALID_BIT;
    }
    if ((int_value & XR_VIEW_STATE_ORIENTATION_TRACKED_BIT) != 0) {
        // Clear the value XR_VIEW_STATE_ORIENTATION_TRACKED_BIT since it is valid
        int_value &= ~XR_VIEW_STATE_ORIENTATION_TRACKED_BIT;
    }
    if ((int_value & XR_VIEW_STATE_POSITION_TRACKED_BIT) != 0) {
        // Clear the value XR_VIEW_STATE_POSITION_TRACKED_BIT since it is valid
        int_value &= ~XR_VIEW_STATE_POSITION_TRACKED_BIT;
    }
    if (int_value != 0) {
        // Something is left, it must be invalid
        return VALIDATE_XR_FLAGS_INVALID;
    }
    return VALIDATE_XR_FLAGS_SUCCESS;
}

// Function to validate XrInputSourceLocalizedNameFlags flags
ValidateXrFlagsResult ValidateXrInputSourceLocalizedNameFlags(const XrFlags64 value) {
    if (0 == value) {
        return VALIDATE_XR_FLAGS_ZERO;
    }
    XrFlags64 int_value = value;
    if ((int_value & XR_INPUT_SOURCE_LOCALIZED_NAME_USER_PATH_BIT) != 0) {
        // Clear the value XR_INPUT_SOURCE_LOCALIZED_NAME_USER_PATH_BIT since it is valid
        int_value &= ~XR_INPUT_SOURCE_LOCALIZED_NAME_USER_PATH_BIT;
    }
    if ((int_value & XR_INPUT_SOURCE_LOCALIZED_NAME_INTERACTION_PROFILE_BIT) != 0) {
        // Clear the value XR_INPUT_SOURCE_LOCALIZED_NAME_INTERACTION_PROFILE_BIT since it is valid
        int_value &= ~XR_INPUT_SOURCE_LOCALIZED_NAME_INTERACTION_PROFILE_BIT;
    }
    if ((int_value & XR_INPUT_SOURCE_LOCALIZED_NAME_COMPONENT_BIT) != 0) {
        // Clear the value XR_INPUT_SOURCE_LOCALIZED_NAME_COMPONENT_BIT since it is valid
        int_value &= ~XR_INPUT_SOURCE_LOCALIZED_NAME_COMPONENT_BIT;
    }
    if (int_value != 0) {
        // Something is left, it must be invalid
        return VALIDATE_XR_FLAGS_INVALID;
    }
    return VALIDATE_XR_FLAGS_SUCCESS;
}

#if defined(XR_USE_GRAPHICS_API_VULKAN)
// Function to validate XrVulkanInstanceCreateFlagsKHR flags
ValidateXrFlagsResult ValidateXrVulkanInstanceCreateFlagsKHR(const XrFlags64 value) {
    if (0 == value) {
        return VALIDATE_XR_FLAGS_ZERO;
    }
    XrFlags64 int_value = value;
    if (int_value != 0) {
        // Something is left, it must be invalid
        return VALIDATE_XR_FLAGS_INVALID;
    }
    return VALIDATE_XR_FLAGS_SUCCESS;
}

#endif // defined(XR_USE_GRAPHICS_API_VULKAN)
#if defined(XR_USE_GRAPHICS_API_VULKAN)
// Function to validate XrVulkanDeviceCreateFlagsKHR flags
ValidateXrFlagsResult ValidateXrVulkanDeviceCreateFlagsKHR(const XrFlags64 value) {
    if (0 == value) {
        return VALIDATE_XR_FLAGS_ZERO;
    }
    XrFlags64 int_value = value;
    if (int_value != 0) {
        // Something is left, it must be invalid
        return VALIDATE_XR_FLAGS_INVALID;
    }
    return VALIDATE_XR_FLAGS_SUCCESS;
}

#endif // defined(XR_USE_GRAPHICS_API_VULKAN)
// Function to validate XrDebugUtilsMessageSeverityFlagsEXT flags
ValidateXrFlagsResult ValidateXrDebugUtilsMessageSeverityFlagsEXT(const XrFlags64 value) {
    if (0 == value) {
        return VALIDATE_XR_FLAGS_ZERO;
    }
    XrFlags64 int_value = value;
    if ((int_value & XR_DEBUG_UTILS_MESSAGE_SEVERITY_VERBOSE_BIT_EXT) != 0) {
        // Clear the value XR_DEBUG_UTILS_MESSAGE_SEVERITY_VERBOSE_BIT_EXT since it is valid
        int_value &= ~XR_DEBUG_UTILS_MESSAGE_SEVERITY_VERBOSE_BIT_EXT;
    }
    if ((int_value & XR_DEBUG_UTILS_MESSAGE_SEVERITY_INFO_BIT_EXT) != 0) {
        // Clear the value XR_DEBUG_UTILS_MESSAGE_SEVERITY_INFO_BIT_EXT since it is valid
        int_value &= ~XR_DEBUG_UTILS_MESSAGE_SEVERITY_INFO_BIT_EXT;
    }
    if ((int_value & XR_DEBUG_UTILS_MESSAGE_SEVERITY_WARNING_BIT_EXT) != 0) {
        // Clear the value XR_DEBUG_UTILS_MESSAGE_SEVERITY_WARNING_BIT_EXT since it is valid
        int_value &= ~XR_DEBUG_UTILS_MESSAGE_SEVERITY_WARNING_BIT_EXT;
    }
    if ((int_value & XR_DEBUG_UTILS_MESSAGE_SEVERITY_ERROR_BIT_EXT) != 0) {
        // Clear the value XR_DEBUG_UTILS_MESSAGE_SEVERITY_ERROR_BIT_EXT since it is valid
        int_value &= ~XR_DEBUG_UTILS_MESSAGE_SEVERITY_ERROR_BIT_EXT;
    }
    if (int_value != 0) {
        // Something is left, it must be invalid
        return VALIDATE_XR_FLAGS_INVALID;
    }
    return VALIDATE_XR_FLAGS_SUCCESS;
}

// Function to validate XrDebugUtilsMessageTypeFlagsEXT flags
ValidateXrFlagsResult ValidateXrDebugUtilsMessageTypeFlagsEXT(const XrFlags64 value) {
    if (0 == value) {
        return VALIDATE_XR_FLAGS_ZERO;
    }
    XrFlags64 int_value = value;
    if ((int_value & XR_DEBUG_UTILS_MESSAGE_TYPE_GENERAL_BIT_EXT) != 0) {
        // Clear the value XR_DEBUG_UTILS_MESSAGE_TYPE_GENERAL_BIT_EXT since it is valid
        int_value &= ~XR_DEBUG_UTILS_MESSAGE_TYPE_GENERAL_BIT_EXT;
    }
    if ((int_value & XR_DEBUG_UTILS_MESSAGE_TYPE_VALIDATION_BIT_EXT) != 0) {
        // Clear the value XR_DEBUG_UTILS_MESSAGE_TYPE_VALIDATION_BIT_EXT since it is valid
        int_value &= ~XR_DEBUG_UTILS_MESSAGE_TYPE_VALIDATION_BIT_EXT;
    }
    if ((int_value & XR_DEBUG_UTILS_MESSAGE_TYPE_PERFORMANCE_BIT_EXT) != 0) {
        // Clear the value XR_DEBUG_UTILS_MESSAGE_TYPE_PERFORMANCE_BIT_EXT since it is valid
        int_value &= ~XR_DEBUG_UTILS_MESSAGE_TYPE_PERFORMANCE_BIT_EXT;
    }
    if ((int_value & XR_DEBUG_UTILS_MESSAGE_TYPE_CONFORMANCE_BIT_EXT) != 0) {
        // Clear the value XR_DEBUG_UTILS_MESSAGE_TYPE_CONFORMANCE_BIT_EXT since it is valid
        int_value &= ~XR_DEBUG_UTILS_MESSAGE_TYPE_CONFORMANCE_BIT_EXT;
    }
    if (int_value != 0) {
        // Something is left, it must be invalid
        return VALIDATE_XR_FLAGS_INVALID;
    }
    return VALIDATE_XR_FLAGS_SUCCESS;
}

// Function to validate XrOverlaySessionCreateFlagsEXTX flags
ValidateXrFlagsResult ValidateXrOverlaySessionCreateFlagsEXTX(const XrFlags64 value) {
    if (0 == value) {
        return VALIDATE_XR_FLAGS_ZERO;
    }
    XrFlags64 int_value = value;
    if (int_value != 0) {
        // Something is left, it must be invalid
        return VALIDATE_XR_FLAGS_INVALID;
    }
    return VALIDATE_XR_FLAGS_SUCCESS;
}

// Function to validate XrOverlayMainSessionFlagsEXTX flags
ValidateXrFlagsResult ValidateXrOverlayMainSessionFlagsEXTX(const XrFlags64 value) {
    if (0 == value) {
        return VALIDATE_XR_FLAGS_ZERO;
    }
    XrFlags64 int_value = value;
    if ((int_value & XR_OVERLAY_MAIN_SESSION_ENABLED_COMPOSITION_LAYER_INFO_DEPTH_BIT_EXTX) != 0) {
        // Clear the value XR_OVERLAY_MAIN_SESSION_ENABLED_COMPOSITION_LAYER_INFO_DEPTH_BIT_EXTX since it is valid
        int_value &= ~XR_OVERLAY_MAIN_SESSION_ENABLED_COMPOSITION_LAYER_INFO_DEPTH_BIT_EXTX;
    }
    if (int_value != 0) {
        // Something is left, it must be invalid
        return VALIDATE_XR_FLAGS_INVALID;
    }
    return VALIDATE_XR_FLAGS_SUCCESS;
}

// Function to validate XrCompositionLayerImageLayoutFlagsFB flags
ValidateXrFlagsResult ValidateXrCompositionLayerImageLayoutFlagsFB(const XrFlags64 value) {
    if (0 == value) {
        return VALIDATE_XR_FLAGS_ZERO;
    }
    XrFlags64 int_value = value;
    if ((int_value & XR_COMPOSITION_LAYER_IMAGE_LAYOUT_VERTICAL_FLIP_BIT_FB) != 0) {
        // Clear the value XR_COMPOSITION_LAYER_IMAGE_LAYOUT_VERTICAL_FLIP_BIT_FB since it is valid
        int_value &= ~XR_COMPOSITION_LAYER_IMAGE_LAYOUT_VERTICAL_FLIP_BIT_FB;
    }
    if (int_value != 0) {
        // Something is left, it must be invalid
        return VALIDATE_XR_FLAGS_INVALID;
    }
    return VALIDATE_XR_FLAGS_SUCCESS;
}

#if defined(XR_USE_PLATFORM_ANDROID)
// Function to validate XrAndroidSurfaceSwapchainFlagsFB flags
ValidateXrFlagsResult ValidateXrAndroidSurfaceSwapchainFlagsFB(const XrFlags64 value) {
    if (0 == value) {
        return VALIDATE_XR_FLAGS_ZERO;
    }
    XrFlags64 int_value = value;
    if ((int_value & XR_ANDROID_SURFACE_SWAPCHAIN_SYNCHRONOUS_BIT_FB) != 0) {
        // Clear the value XR_ANDROID_SURFACE_SWAPCHAIN_SYNCHRONOUS_BIT_FB since it is valid
        int_value &= ~XR_ANDROID_SURFACE_SWAPCHAIN_SYNCHRONOUS_BIT_FB;
    }
    if ((int_value & XR_ANDROID_SURFACE_SWAPCHAIN_USE_TIMESTAMPS_BIT_FB) != 0) {
        // Clear the value XR_ANDROID_SURFACE_SWAPCHAIN_USE_TIMESTAMPS_BIT_FB since it is valid
        int_value &= ~XR_ANDROID_SURFACE_SWAPCHAIN_USE_TIMESTAMPS_BIT_FB;
    }
    if (int_value != 0) {
        // Something is left, it must be invalid
        return VALIDATE_XR_FLAGS_INVALID;
    }
    return VALIDATE_XR_FLAGS_SUCCESS;
}

#endif // defined(XR_USE_PLATFORM_ANDROID)
// Function to validate XrCompositionLayerSecureContentFlagsFB flags
ValidateXrFlagsResult ValidateXrCompositionLayerSecureContentFlagsFB(const XrFlags64 value) {
    if (0 == value) {
        return VALIDATE_XR_FLAGS_ZERO;
    }
    XrFlags64 int_value = value;
    if ((int_value & XR_COMPOSITION_LAYER_SECURE_CONTENT_EXCLUDE_LAYER_BIT_FB) != 0) {
        // Clear the value XR_COMPOSITION_LAYER_SECURE_CONTENT_EXCLUDE_LAYER_BIT_FB since it is valid
        int_value &= ~XR_COMPOSITION_LAYER_SECURE_CONTENT_EXCLUDE_LAYER_BIT_FB;
    }
    if ((int_value & XR_COMPOSITION_LAYER_SECURE_CONTENT_REPLACE_LAYER_BIT_FB) != 0) {
        // Clear the value XR_COMPOSITION_LAYER_SECURE_CONTENT_REPLACE_LAYER_BIT_FB since it is valid
        int_value &= ~XR_COMPOSITION_LAYER_SECURE_CONTENT_REPLACE_LAYER_BIT_FB;
    }
    if (int_value != 0) {
        // Something is left, it must be invalid
        return VALIDATE_XR_FLAGS_INVALID;
    }
    return VALIDATE_XR_FLAGS_SUCCESS;
}

// Function to validate XrHandTrackingAimFlagsFB flags
ValidateXrFlagsResult ValidateXrHandTrackingAimFlagsFB(const XrFlags64 value) {
    if (0 == value) {
        return VALIDATE_XR_FLAGS_ZERO;
    }
    XrFlags64 int_value = value;
    if ((int_value & XR_HAND_TRACKING_AIM_COMPUTED_BIT_FB) != 0) {
        // Clear the value XR_HAND_TRACKING_AIM_COMPUTED_BIT_FB since it is valid
        int_value &= ~XR_HAND_TRACKING_AIM_COMPUTED_BIT_FB;
    }
    if ((int_value & XR_HAND_TRACKING_AIM_VALID_BIT_FB) != 0) {
        // Clear the value XR_HAND_TRACKING_AIM_VALID_BIT_FB since it is valid
        int_value &= ~XR_HAND_TRACKING_AIM_VALID_BIT_FB;
    }
    if ((int_value & XR_HAND_TRACKING_AIM_INDEX_PINCHING_BIT_FB) != 0) {
        // Clear the value XR_HAND_TRACKING_AIM_INDEX_PINCHING_BIT_FB since it is valid
        int_value &= ~XR_HAND_TRACKING_AIM_INDEX_PINCHING_BIT_FB;
    }
    if ((int_value & XR_HAND_TRACKING_AIM_MIDDLE_PINCHING_BIT_FB) != 0) {
        // Clear the value XR_HAND_TRACKING_AIM_MIDDLE_PINCHING_BIT_FB since it is valid
        int_value &= ~XR_HAND_TRACKING_AIM_MIDDLE_PINCHING_BIT_FB;
    }
    if ((int_value & XR_HAND_TRACKING_AIM_RING_PINCHING_BIT_FB) != 0) {
        // Clear the value XR_HAND_TRACKING_AIM_RING_PINCHING_BIT_FB since it is valid
        int_value &= ~XR_HAND_TRACKING_AIM_RING_PINCHING_BIT_FB;
    }
    if ((int_value & XR_HAND_TRACKING_AIM_LITTLE_PINCHING_BIT_FB) != 0) {
        // Clear the value XR_HAND_TRACKING_AIM_LITTLE_PINCHING_BIT_FB since it is valid
        int_value &= ~XR_HAND_TRACKING_AIM_LITTLE_PINCHING_BIT_FB;
    }
    if ((int_value & XR_HAND_TRACKING_AIM_SYSTEM_GESTURE_BIT_FB) != 0) {
        // Clear the value XR_HAND_TRACKING_AIM_SYSTEM_GESTURE_BIT_FB since it is valid
        int_value &= ~XR_HAND_TRACKING_AIM_SYSTEM_GESTURE_BIT_FB;
    }
    if ((int_value & XR_HAND_TRACKING_AIM_DOMINANT_HAND_BIT_FB) != 0) {
        // Clear the value XR_HAND_TRACKING_AIM_DOMINANT_HAND_BIT_FB since it is valid
        int_value &= ~XR_HAND_TRACKING_AIM_DOMINANT_HAND_BIT_FB;
    }
    if ((int_value & XR_HAND_TRACKING_AIM_MENU_PRESSED_BIT_FB) != 0) {
        // Clear the value XR_HAND_TRACKING_AIM_MENU_PRESSED_BIT_FB since it is valid
        int_value &= ~XR_HAND_TRACKING_AIM_MENU_PRESSED_BIT_FB;
    }
    if (int_value != 0) {
        // Something is left, it must be invalid
        return VALIDATE_XR_FLAGS_INVALID;
    }
    return VALIDATE_XR_FLAGS_SUCCESS;
}

// Function to validate XrSwapchainCreateFoveationFlagsFB flags
ValidateXrFlagsResult ValidateXrSwapchainCreateFoveationFlagsFB(const XrFlags64 value) {
    if (0 == value) {
        return VALIDATE_XR_FLAGS_ZERO;
    }
    XrFlags64 int_value = value;
    if ((int_value & XR_SWAPCHAIN_CREATE_FOVEATION_SCALED_BIN_BIT_FB) != 0) {
        // Clear the value XR_SWAPCHAIN_CREATE_FOVEATION_SCALED_BIN_BIT_FB since it is valid
        int_value &= ~XR_SWAPCHAIN_CREATE_FOVEATION_SCALED_BIN_BIT_FB;
    }
    if ((int_value & XR_SWAPCHAIN_CREATE_FOVEATION_FRAGMENT_DENSITY_MAP_BIT_FB) != 0) {
        // Clear the value XR_SWAPCHAIN_CREATE_FOVEATION_FRAGMENT_DENSITY_MAP_BIT_FB since it is valid
        int_value &= ~XR_SWAPCHAIN_CREATE_FOVEATION_FRAGMENT_DENSITY_MAP_BIT_FB;
    }
    if (int_value != 0) {
        // Something is left, it must be invalid
        return VALIDATE_XR_FLAGS_INVALID;
    }
    return VALIDATE_XR_FLAGS_SUCCESS;
}

// Function to validate XrSwapchainStateFoveationFlagsFB flags
ValidateXrFlagsResult ValidateXrSwapchainStateFoveationFlagsFB(const XrFlags64 value) {
    if (0 == value) {
        return VALIDATE_XR_FLAGS_ZERO;
    }
    XrFlags64 int_value = value;
    if (int_value != 0) {
        // Something is left, it must be invalid
        return VALIDATE_XR_FLAGS_INVALID;
    }
    return VALIDATE_XR_FLAGS_SUCCESS;
}

// Function to validate XrKeyboardTrackingFlagsFB flags
ValidateXrFlagsResult ValidateXrKeyboardTrackingFlagsFB(const XrFlags64 value) {
    if (0 == value) {
        return VALIDATE_XR_FLAGS_ZERO;
    }
    XrFlags64 int_value = value;
    if ((int_value & XR_KEYBOARD_TRACKING_EXISTS_BIT_FB) != 0) {
        // Clear the value XR_KEYBOARD_TRACKING_EXISTS_BIT_FB since it is valid
        int_value &= ~XR_KEYBOARD_TRACKING_EXISTS_BIT_FB;
    }
    if ((int_value & XR_KEYBOARD_TRACKING_LOCAL_BIT_FB) != 0) {
        // Clear the value XR_KEYBOARD_TRACKING_LOCAL_BIT_FB since it is valid
        int_value &= ~XR_KEYBOARD_TRACKING_LOCAL_BIT_FB;
    }
    if ((int_value & XR_KEYBOARD_TRACKING_REMOTE_BIT_FB) != 0) {
        // Clear the value XR_KEYBOARD_TRACKING_REMOTE_BIT_FB since it is valid
        int_value &= ~XR_KEYBOARD_TRACKING_REMOTE_BIT_FB;
    }
    if ((int_value & XR_KEYBOARD_TRACKING_CONNECTED_BIT_FB) != 0) {
        // Clear the value XR_KEYBOARD_TRACKING_CONNECTED_BIT_FB since it is valid
        int_value &= ~XR_KEYBOARD_TRACKING_CONNECTED_BIT_FB;
    }
    if (int_value != 0) {
        // Something is left, it must be invalid
        return VALIDATE_XR_FLAGS_INVALID;
    }
    return VALIDATE_XR_FLAGS_SUCCESS;
}

// Function to validate XrKeyboardTrackingQueryFlagsFB flags
ValidateXrFlagsResult ValidateXrKeyboardTrackingQueryFlagsFB(const XrFlags64 value) {
    if (0 == value) {
        return VALIDATE_XR_FLAGS_ZERO;
    }
    XrFlags64 int_value = value;
    if ((int_value & XR_KEYBOARD_TRACKING_QUERY_LOCAL_BIT_FB) != 0) {
        // Clear the value XR_KEYBOARD_TRACKING_QUERY_LOCAL_BIT_FB since it is valid
        int_value &= ~XR_KEYBOARD_TRACKING_QUERY_LOCAL_BIT_FB;
    }
    if ((int_value & XR_KEYBOARD_TRACKING_QUERY_REMOTE_BIT_FB) != 0) {
        // Clear the value XR_KEYBOARD_TRACKING_QUERY_REMOTE_BIT_FB since it is valid
        int_value &= ~XR_KEYBOARD_TRACKING_QUERY_REMOTE_BIT_FB;
    }
    if (int_value != 0) {
        // Something is left, it must be invalid
        return VALIDATE_XR_FLAGS_INVALID;
    }
    return VALIDATE_XR_FLAGS_SUCCESS;
}

// Function to validate XrTriangleMeshFlagsFB flags
ValidateXrFlagsResult ValidateXrTriangleMeshFlagsFB(const XrFlags64 value) {
    if (0 == value) {
        return VALIDATE_XR_FLAGS_ZERO;
    }
    XrFlags64 int_value = value;
    if ((int_value & XR_TRIANGLE_MESH_MUTABLE_BIT_FB) != 0) {
        // Clear the value XR_TRIANGLE_MESH_MUTABLE_BIT_FB since it is valid
        int_value &= ~XR_TRIANGLE_MESH_MUTABLE_BIT_FB;
    }
    if (int_value != 0) {
        // Something is left, it must be invalid
        return VALIDATE_XR_FLAGS_INVALID;
    }
    return VALIDATE_XR_FLAGS_SUCCESS;
}

// Function to validate XrPassthroughCapabilityFlagsFB flags
ValidateXrFlagsResult ValidateXrPassthroughCapabilityFlagsFB(const XrFlags64 value) {
    if (0 == value) {
        return VALIDATE_XR_FLAGS_ZERO;
    }
    XrFlags64 int_value = value;
    if ((int_value & XR_PASSTHROUGH_CAPABILITY_BIT_FB) != 0) {
        // Clear the value XR_PASSTHROUGH_CAPABILITY_BIT_FB since it is valid
        int_value &= ~XR_PASSTHROUGH_CAPABILITY_BIT_FB;
    }
    if ((int_value & XR_PASSTHROUGH_CAPABILITY_COLOR_BIT_FB) != 0) {
        // Clear the value XR_PASSTHROUGH_CAPABILITY_COLOR_BIT_FB since it is valid
        int_value &= ~XR_PASSTHROUGH_CAPABILITY_COLOR_BIT_FB;
    }
    if ((int_value & XR_PASSTHROUGH_CAPABILITY_LAYER_DEPTH_BIT_FB) != 0) {
        // Clear the value XR_PASSTHROUGH_CAPABILITY_LAYER_DEPTH_BIT_FB since it is valid
        int_value &= ~XR_PASSTHROUGH_CAPABILITY_LAYER_DEPTH_BIT_FB;
    }
    if (int_value != 0) {
        // Something is left, it must be invalid
        return VALIDATE_XR_FLAGS_INVALID;
    }
    return VALIDATE_XR_FLAGS_SUCCESS;
}

// Function to validate XrPassthroughFlagsFB flags
ValidateXrFlagsResult ValidateXrPassthroughFlagsFB(const XrFlags64 value) {
    if (0 == value) {
        return VALIDATE_XR_FLAGS_ZERO;
    }
    XrFlags64 int_value = value;
    if ((int_value & XR_PASSTHROUGH_IS_RUNNING_AT_CREATION_BIT_FB) != 0) {
        // Clear the value XR_PASSTHROUGH_IS_RUNNING_AT_CREATION_BIT_FB since it is valid
        int_value &= ~XR_PASSTHROUGH_IS_RUNNING_AT_CREATION_BIT_FB;
    }
    if ((int_value & XR_PASSTHROUGH_LAYER_DEPTH_BIT_FB) != 0) {
        // Clear the value XR_PASSTHROUGH_LAYER_DEPTH_BIT_FB since it is valid
        int_value &= ~XR_PASSTHROUGH_LAYER_DEPTH_BIT_FB;
    }
    if (int_value != 0) {
        // Something is left, it must be invalid
        return VALIDATE_XR_FLAGS_INVALID;
    }
    return VALIDATE_XR_FLAGS_SUCCESS;
}

// Function to validate XrPassthroughStateChangedFlagsFB flags
ValidateXrFlagsResult ValidateXrPassthroughStateChangedFlagsFB(const XrFlags64 value) {
    if (0 == value) {
        return VALIDATE_XR_FLAGS_ZERO;
    }
    XrFlags64 int_value = value;
    if ((int_value & XR_PASSTHROUGH_STATE_CHANGED_REINIT_REQUIRED_BIT_FB) != 0) {
        // Clear the value XR_PASSTHROUGH_STATE_CHANGED_REINIT_REQUIRED_BIT_FB since it is valid
        int_value &= ~XR_PASSTHROUGH_STATE_CHANGED_REINIT_REQUIRED_BIT_FB;
    }
    if ((int_value & XR_PASSTHROUGH_STATE_CHANGED_NON_RECOVERABLE_ERROR_BIT_FB) != 0) {
        // Clear the value XR_PASSTHROUGH_STATE_CHANGED_NON_RECOVERABLE_ERROR_BIT_FB since it is valid
        int_value &= ~XR_PASSTHROUGH_STATE_CHANGED_NON_RECOVERABLE_ERROR_BIT_FB;
    }
    if ((int_value & XR_PASSTHROUGH_STATE_CHANGED_RECOVERABLE_ERROR_BIT_FB) != 0) {
        // Clear the value XR_PASSTHROUGH_STATE_CHANGED_RECOVERABLE_ERROR_BIT_FB since it is valid
        int_value &= ~XR_PASSTHROUGH_STATE_CHANGED_RECOVERABLE_ERROR_BIT_FB;
    }
    if ((int_value & XR_PASSTHROUGH_STATE_CHANGED_RESTORED_ERROR_BIT_FB) != 0) {
        // Clear the value XR_PASSTHROUGH_STATE_CHANGED_RESTORED_ERROR_BIT_FB since it is valid
        int_value &= ~XR_PASSTHROUGH_STATE_CHANGED_RESTORED_ERROR_BIT_FB;
    }
    if (int_value != 0) {
        // Something is left, it must be invalid
        return VALIDATE_XR_FLAGS_INVALID;
    }
    return VALIDATE_XR_FLAGS_SUCCESS;
}

// Function to validate XrRenderModelFlagsFB flags
ValidateXrFlagsResult ValidateXrRenderModelFlagsFB(const XrFlags64 value) {
    if (0 == value) {
        return VALIDATE_XR_FLAGS_ZERO;
    }
    XrFlags64 int_value = value;
    if ((int_value & XR_RENDER_MODEL_SUPPORTS_GLTF_2_0_SUBSET_1_BIT_FB) != 0) {
        // Clear the value XR_RENDER_MODEL_SUPPORTS_GLTF_2_0_SUBSET_1_BIT_FB since it is valid
        int_value &= ~XR_RENDER_MODEL_SUPPORTS_GLTF_2_0_SUBSET_1_BIT_FB;
    }
    if ((int_value & XR_RENDER_MODEL_SUPPORTS_GLTF_2_0_SUBSET_2_BIT_FB) != 0) {
        // Clear the value XR_RENDER_MODEL_SUPPORTS_GLTF_2_0_SUBSET_2_BIT_FB since it is valid
        int_value &= ~XR_RENDER_MODEL_SUPPORTS_GLTF_2_0_SUBSET_2_BIT_FB;
    }
    if (int_value != 0) {
        // Something is left, it must be invalid
        return VALIDATE_XR_FLAGS_INVALID;
    }
    return VALIDATE_XR_FLAGS_SUCCESS;
}

// Function to validate XrFrameEndInfoFlagsML flags
ValidateXrFlagsResult ValidateXrFrameEndInfoFlagsML(const XrFlags64 value) {
    if (0 == value) {
        return VALIDATE_XR_FLAGS_ZERO;
    }
    XrFlags64 int_value = value;
    if ((int_value & XR_FRAME_END_INFO_PROTECTED_BIT_ML) != 0) {
        // Clear the value XR_FRAME_END_INFO_PROTECTED_BIT_ML since it is valid
        int_value &= ~XR_FRAME_END_INFO_PROTECTED_BIT_ML;
    }
    if ((int_value & XR_FRAME_END_INFO_VIGNETTE_BIT_ML) != 0) {
        // Clear the value XR_FRAME_END_INFO_VIGNETTE_BIT_ML since it is valid
        int_value &= ~XR_FRAME_END_INFO_VIGNETTE_BIT_ML;
    }
    if (int_value != 0) {
        // Something is left, it must be invalid
        return VALIDATE_XR_FLAGS_INVALID;
    }
    return VALIDATE_XR_FLAGS_SUCCESS;
}

// Function to validate XrGlobalDimmerFrameEndInfoFlagsML flags
ValidateXrFlagsResult ValidateXrGlobalDimmerFrameEndInfoFlagsML(const XrFlags64 value) {
    if (0 == value) {
        return VALIDATE_XR_FLAGS_ZERO;
    }
    XrFlags64 int_value = value;
    if ((int_value & XR_GLOBAL_DIMMER_FRAME_END_INFO_ENABLED_BIT_ML) != 0) {
        // Clear the value XR_GLOBAL_DIMMER_FRAME_END_INFO_ENABLED_BIT_ML since it is valid
        int_value &= ~XR_GLOBAL_DIMMER_FRAME_END_INFO_ENABLED_BIT_ML;
    }
    if (int_value != 0) {
        // Something is left, it must be invalid
        return VALIDATE_XR_FLAGS_INVALID;
    }
    return VALIDATE_XR_FLAGS_SUCCESS;
}

// Function to validate XrLocalizationMapErrorFlagsML flags
ValidateXrFlagsResult ValidateXrLocalizationMapErrorFlagsML(const XrFlags64 value) {
    if (0 == value) {
        return VALIDATE_XR_FLAGS_ZERO;
    }
    XrFlags64 int_value = value;
    if ((int_value & XR_LOCALIZATION_MAP_ERROR_UNKNOWN_BIT_ML) != 0) {
        // Clear the value XR_LOCALIZATION_MAP_ERROR_UNKNOWN_BIT_ML since it is valid
        int_value &= ~XR_LOCALIZATION_MAP_ERROR_UNKNOWN_BIT_ML;
    }
    if ((int_value & XR_LOCALIZATION_MAP_ERROR_OUT_OF_MAPPED_AREA_BIT_ML) != 0) {
        // Clear the value XR_LOCALIZATION_MAP_ERROR_OUT_OF_MAPPED_AREA_BIT_ML since it is valid
        int_value &= ~XR_LOCALIZATION_MAP_ERROR_OUT_OF_MAPPED_AREA_BIT_ML;
    }
    if ((int_value & XR_LOCALIZATION_MAP_ERROR_LOW_FEATURE_COUNT_BIT_ML) != 0) {
        // Clear the value XR_LOCALIZATION_MAP_ERROR_LOW_FEATURE_COUNT_BIT_ML since it is valid
        int_value &= ~XR_LOCALIZATION_MAP_ERROR_LOW_FEATURE_COUNT_BIT_ML;
    }
    if ((int_value & XR_LOCALIZATION_MAP_ERROR_EXCESSIVE_MOTION_BIT_ML) != 0) {
        // Clear the value XR_LOCALIZATION_MAP_ERROR_EXCESSIVE_MOTION_BIT_ML since it is valid
        int_value &= ~XR_LOCALIZATION_MAP_ERROR_EXCESSIVE_MOTION_BIT_ML;
    }
    if ((int_value & XR_LOCALIZATION_MAP_ERROR_LOW_LIGHT_BIT_ML) != 0) {
        // Clear the value XR_LOCALIZATION_MAP_ERROR_LOW_LIGHT_BIT_ML since it is valid
        int_value &= ~XR_LOCALIZATION_MAP_ERROR_LOW_LIGHT_BIT_ML;
    }
    if ((int_value & XR_LOCALIZATION_MAP_ERROR_HEADPOSE_BIT_ML) != 0) {
        // Clear the value XR_LOCALIZATION_MAP_ERROR_HEADPOSE_BIT_ML since it is valid
        int_value &= ~XR_LOCALIZATION_MAP_ERROR_HEADPOSE_BIT_ML;
    }
    if (int_value != 0) {
        // Something is left, it must be invalid
        return VALIDATE_XR_FLAGS_INVALID;
    }
    return VALIDATE_XR_FLAGS_SUCCESS;
}

// Function to validate XrCompositionLayerSpaceWarpInfoFlagsFB flags
ValidateXrFlagsResult ValidateXrCompositionLayerSpaceWarpInfoFlagsFB(const XrFlags64 value) {
    if (0 == value) {
        return VALIDATE_XR_FLAGS_ZERO;
    }
    XrFlags64 int_value = value;
    if ((int_value & XR_COMPOSITION_LAYER_SPACE_WARP_INFO_FRAME_SKIP_BIT_FB) != 0) {
        // Clear the value XR_COMPOSITION_LAYER_SPACE_WARP_INFO_FRAME_SKIP_BIT_FB since it is valid
        int_value &= ~XR_COMPOSITION_LAYER_SPACE_WARP_INFO_FRAME_SKIP_BIT_FB;
    }
    if (int_value != 0) {
        // Something is left, it must be invalid
        return VALIDATE_XR_FLAGS_INVALID;
    }
    return VALIDATE_XR_FLAGS_SUCCESS;
}

// Function to validate XrSemanticLabelsSupportFlagsFB flags
ValidateXrFlagsResult ValidateXrSemanticLabelsSupportFlagsFB(const XrFlags64 value) {
    if (0 == value) {
        return VALIDATE_XR_FLAGS_ZERO;
    }
    XrFlags64 int_value = value;
    if ((int_value & XR_SEMANTIC_LABELS_SUPPORT_MULTIPLE_SEMANTIC_LABELS_BIT_FB) != 0) {
        // Clear the value XR_SEMANTIC_LABELS_SUPPORT_MULTIPLE_SEMANTIC_LABELS_BIT_FB since it is valid
        int_value &= ~XR_SEMANTIC_LABELS_SUPPORT_MULTIPLE_SEMANTIC_LABELS_BIT_FB;
    }
    if ((int_value & XR_SEMANTIC_LABELS_SUPPORT_ACCEPT_DESK_TO_TABLE_MIGRATION_BIT_FB) != 0) {
        // Clear the value XR_SEMANTIC_LABELS_SUPPORT_ACCEPT_DESK_TO_TABLE_MIGRATION_BIT_FB since it is valid
        int_value &= ~XR_SEMANTIC_LABELS_SUPPORT_ACCEPT_DESK_TO_TABLE_MIGRATION_BIT_FB;
    }
    if ((int_value & XR_SEMANTIC_LABELS_SUPPORT_ACCEPT_INVISIBLE_WALL_FACE_BIT_FB) != 0) {
        // Clear the value XR_SEMANTIC_LABELS_SUPPORT_ACCEPT_INVISIBLE_WALL_FACE_BIT_FB since it is valid
        int_value &= ~XR_SEMANTIC_LABELS_SUPPORT_ACCEPT_INVISIBLE_WALL_FACE_BIT_FB;
    }
    if (int_value != 0) {
        // Something is left, it must be invalid
        return VALIDATE_XR_FLAGS_INVALID;
    }
    return VALIDATE_XR_FLAGS_SUCCESS;
}

// Function to validate XrDigitalLensControlFlagsALMALENCE flags
ValidateXrFlagsResult ValidateXrDigitalLensControlFlagsALMALENCE(const XrFlags64 value) {
    if (0 == value) {
        return VALIDATE_XR_FLAGS_ZERO;
    }
    XrFlags64 int_value = value;
    if ((int_value & XR_DIGITAL_LENS_CONTROL_PROCESSING_DISABLE_BIT_ALMALENCE) != 0) {
        // Clear the value XR_DIGITAL_LENS_CONTROL_PROCESSING_DISABLE_BIT_ALMALENCE since it is valid
        int_value &= ~XR_DIGITAL_LENS_CONTROL_PROCESSING_DISABLE_BIT_ALMALENCE;
    }
    if (int_value != 0) {
        // Something is left, it must be invalid
        return VALIDATE_XR_FLAGS_INVALID;
    }
    return VALIDATE_XR_FLAGS_SUCCESS;
}

// Function to validate XrFoveationEyeTrackedProfileCreateFlagsMETA flags
ValidateXrFlagsResult ValidateXrFoveationEyeTrackedProfileCreateFlagsMETA(const XrFlags64 value) {
    if (0 == value) {
        return VALIDATE_XR_FLAGS_ZERO;
    }
    XrFlags64 int_value = value;
    if (int_value != 0) {
        // Something is left, it must be invalid
        return VALIDATE_XR_FLAGS_INVALID;
    }
    return VALIDATE_XR_FLAGS_SUCCESS;
}

// Function to validate XrFoveationEyeTrackedStateFlagsMETA flags
ValidateXrFlagsResult ValidateXrFoveationEyeTrackedStateFlagsMETA(const XrFlags64 value) {
    if (0 == value) {
        return VALIDATE_XR_FLAGS_ZERO;
    }
    XrFlags64 int_value = value;
    if ((int_value & XR_FOVEATION_EYE_TRACKED_STATE_VALID_BIT_META) != 0) {
        // Clear the value XR_FOVEATION_EYE_TRACKED_STATE_VALID_BIT_META since it is valid
        int_value &= ~XR_FOVEATION_EYE_TRACKED_STATE_VALID_BIT_META;
    }
    if (int_value != 0) {
        // Something is left, it must be invalid
        return VALIDATE_XR_FLAGS_INVALID;
    }
    return VALIDATE_XR_FLAGS_SUCCESS;
}

// Function to validate XrCompositionLayerSettingsFlagsFB flags
ValidateXrFlagsResult ValidateXrCompositionLayerSettingsFlagsFB(const XrFlags64 value) {
    if (0 == value) {
        return VALIDATE_XR_FLAGS_ZERO;
    }
    XrFlags64 int_value = value;
    if ((int_value & XR_COMPOSITION_LAYER_SETTINGS_NORMAL_SUPER_SAMPLING_BIT_FB) != 0) {
        // Clear the value XR_COMPOSITION_LAYER_SETTINGS_NORMAL_SUPER_SAMPLING_BIT_FB since it is valid
        int_value &= ~XR_COMPOSITION_LAYER_SETTINGS_NORMAL_SUPER_SAMPLING_BIT_FB;
    }
    if ((int_value & XR_COMPOSITION_LAYER_SETTINGS_QUALITY_SUPER_SAMPLING_BIT_FB) != 0) {
        // Clear the value XR_COMPOSITION_LAYER_SETTINGS_QUALITY_SUPER_SAMPLING_BIT_FB since it is valid
        int_value &= ~XR_COMPOSITION_LAYER_SETTINGS_QUALITY_SUPER_SAMPLING_BIT_FB;
    }
    if ((int_value & XR_COMPOSITION_LAYER_SETTINGS_NORMAL_SHARPENING_BIT_FB) != 0) {
        // Clear the value XR_COMPOSITION_LAYER_SETTINGS_NORMAL_SHARPENING_BIT_FB since it is valid
        int_value &= ~XR_COMPOSITION_LAYER_SETTINGS_NORMAL_SHARPENING_BIT_FB;
    }
    if ((int_value & XR_COMPOSITION_LAYER_SETTINGS_QUALITY_SHARPENING_BIT_FB) != 0) {
        // Clear the value XR_COMPOSITION_LAYER_SETTINGS_QUALITY_SHARPENING_BIT_FB since it is valid
        int_value &= ~XR_COMPOSITION_LAYER_SETTINGS_QUALITY_SHARPENING_BIT_FB;
    }
    if ((int_value & XR_COMPOSITION_LAYER_SETTINGS_AUTO_LAYER_FILTER_BIT_META) != 0) {
        // Clear the value XR_COMPOSITION_LAYER_SETTINGS_AUTO_LAYER_FILTER_BIT_META since it is valid
        int_value &= ~XR_COMPOSITION_LAYER_SETTINGS_AUTO_LAYER_FILTER_BIT_META;
    }
    if (int_value != 0) {
        // Something is left, it must be invalid
        return VALIDATE_XR_FLAGS_INVALID;
    }
    return VALIDATE_XR_FLAGS_SUCCESS;
}

// Function to validate XrFrameSynthesisInfoFlagsEXT flags
ValidateXrFlagsResult ValidateXrFrameSynthesisInfoFlagsEXT(const XrFlags64 value) {
    if (0 == value) {
        return VALIDATE_XR_FLAGS_ZERO;
    }
    XrFlags64 int_value = value;
    if ((int_value & XR_FRAME_SYNTHESIS_INFO_USE_2D_MOTION_VECTOR_BIT_EXT) != 0) {
        // Clear the value XR_FRAME_SYNTHESIS_INFO_USE_2D_MOTION_VECTOR_BIT_EXT since it is valid
        int_value &= ~XR_FRAME_SYNTHESIS_INFO_USE_2D_MOTION_VECTOR_BIT_EXT;
    }
    if ((int_value & XR_FRAME_SYNTHESIS_INFO_REQUEST_RELAXED_FRAME_INTERVAL_BIT_EXT) != 0) {
        // Clear the value XR_FRAME_SYNTHESIS_INFO_REQUEST_RELAXED_FRAME_INTERVAL_BIT_EXT since it is valid
        int_value &= ~XR_FRAME_SYNTHESIS_INFO_REQUEST_RELAXED_FRAME_INTERVAL_BIT_EXT;
    }
    if (int_value != 0) {
        // Something is left, it must be invalid
        return VALIDATE_XR_FLAGS_INVALID;
    }
    return VALIDATE_XR_FLAGS_SUCCESS;
}

// Function to validate XrPassthroughPreferenceFlagsMETA flags
ValidateXrFlagsResult ValidateXrPassthroughPreferenceFlagsMETA(const XrFlags64 value) {
    if (0 == value) {
        return VALIDATE_XR_FLAGS_ZERO;
    }
    XrFlags64 int_value = value;
    if ((int_value & XR_PASSTHROUGH_PREFERENCE_DEFAULT_TO_ACTIVE_BIT_META) != 0) {
        // Clear the value XR_PASSTHROUGH_PREFERENCE_DEFAULT_TO_ACTIVE_BIT_META since it is valid
        int_value &= ~XR_PASSTHROUGH_PREFERENCE_DEFAULT_TO_ACTIVE_BIT_META;
    }
    if (int_value != 0) {
        // Something is left, it must be invalid
        return VALIDATE_XR_FLAGS_INVALID;
    }
    return VALIDATE_XR_FLAGS_SUCCESS;
}

// Function to validate XrVirtualKeyboardInputStateFlagsMETA flags
ValidateXrFlagsResult ValidateXrVirtualKeyboardInputStateFlagsMETA(const XrFlags64 value) {
    if (0 == value) {
        return VALIDATE_XR_FLAGS_ZERO;
    }
    XrFlags64 int_value = value;
    if ((int_value & XR_VIRTUAL_KEYBOARD_INPUT_STATE_PRESSED_BIT_META) != 0) {
        // Clear the value XR_VIRTUAL_KEYBOARD_INPUT_STATE_PRESSED_BIT_META since it is valid
        int_value &= ~XR_VIRTUAL_KEYBOARD_INPUT_STATE_PRESSED_BIT_META;
    }
    if (int_value != 0) {
        // Something is left, it must be invalid
        return VALIDATE_XR_FLAGS_INVALID;
    }
    return VALIDATE_XR_FLAGS_SUCCESS;
}

// Function to validate XrExternalCameraStatusFlagsOCULUS flags
ValidateXrFlagsResult ValidateXrExternalCameraStatusFlagsOCULUS(const XrFlags64 value) {
    if (0 == value) {
        return VALIDATE_XR_FLAGS_ZERO;
    }
    XrFlags64 int_value = value;
    if ((int_value & XR_EXTERNAL_CAMERA_STATUS_CONNECTED_BIT_OCULUS) != 0) {
        // Clear the value XR_EXTERNAL_CAMERA_STATUS_CONNECTED_BIT_OCULUS since it is valid
        int_value &= ~XR_EXTERNAL_CAMERA_STATUS_CONNECTED_BIT_OCULUS;
    }
    if ((int_value & XR_EXTERNAL_CAMERA_STATUS_CALIBRATING_BIT_OCULUS) != 0) {
        // Clear the value XR_EXTERNAL_CAMERA_STATUS_CALIBRATING_BIT_OCULUS since it is valid
        int_value &= ~XR_EXTERNAL_CAMERA_STATUS_CALIBRATING_BIT_OCULUS;
    }
    if ((int_value & XR_EXTERNAL_CAMERA_STATUS_CALIBRATION_FAILED_BIT_OCULUS) != 0) {
        // Clear the value XR_EXTERNAL_CAMERA_STATUS_CALIBRATION_FAILED_BIT_OCULUS since it is valid
        int_value &= ~XR_EXTERNAL_CAMERA_STATUS_CALIBRATION_FAILED_BIT_OCULUS;
    }
    if ((int_value & XR_EXTERNAL_CAMERA_STATUS_CALIBRATED_BIT_OCULUS) != 0) {
        // Clear the value XR_EXTERNAL_CAMERA_STATUS_CALIBRATED_BIT_OCULUS since it is valid
        int_value &= ~XR_EXTERNAL_CAMERA_STATUS_CALIBRATED_BIT_OCULUS;
    }
    if ((int_value & XR_EXTERNAL_CAMERA_STATUS_CAPTURING_BIT_OCULUS) != 0) {
        // Clear the value XR_EXTERNAL_CAMERA_STATUS_CAPTURING_BIT_OCULUS since it is valid
        int_value &= ~XR_EXTERNAL_CAMERA_STATUS_CAPTURING_BIT_OCULUS;
    }
    if (int_value != 0) {
        // Something is left, it must be invalid
        return VALIDATE_XR_FLAGS_INVALID;
    }
    return VALIDATE_XR_FLAGS_SUCCESS;
}

// Function to validate XrPerformanceMetricsCounterFlagsMETA flags
ValidateXrFlagsResult ValidateXrPerformanceMetricsCounterFlagsMETA(const XrFlags64 value) {
    if (0 == value) {
        return VALIDATE_XR_FLAGS_ZERO;
    }
    XrFlags64 int_value = value;
    if ((int_value & XR_PERFORMANCE_METRICS_COUNTER_ANY_VALUE_VALID_BIT_META) != 0) {
        // Clear the value XR_PERFORMANCE_METRICS_COUNTER_ANY_VALUE_VALID_BIT_META since it is valid
        int_value &= ~XR_PERFORMANCE_METRICS_COUNTER_ANY_VALUE_VALID_BIT_META;
    }
    if ((int_value & XR_PERFORMANCE_METRICS_COUNTER_UINT_VALUE_VALID_BIT_META) != 0) {
        // Clear the value XR_PERFORMANCE_METRICS_COUNTER_UINT_VALUE_VALID_BIT_META since it is valid
        int_value &= ~XR_PERFORMANCE_METRICS_COUNTER_UINT_VALUE_VALID_BIT_META;
    }
    if ((int_value & XR_PERFORMANCE_METRICS_COUNTER_FLOAT_VALUE_VALID_BIT_META) != 0) {
        // Clear the value XR_PERFORMANCE_METRICS_COUNTER_FLOAT_VALUE_VALID_BIT_META since it is valid
        int_value &= ~XR_PERFORMANCE_METRICS_COUNTER_FLOAT_VALUE_VALID_BIT_META;
    }
    if (int_value != 0) {
        // Something is left, it must be invalid
        return VALIDATE_XR_FLAGS_INVALID;
    }
    return VALIDATE_XR_FLAGS_SUCCESS;
}

// Function to validate XrEnvironmentDepthProviderCreateFlagsMETA flags
ValidateXrFlagsResult ValidateXrEnvironmentDepthProviderCreateFlagsMETA(const XrFlags64 value) {
    if (0 == value) {
        return VALIDATE_XR_FLAGS_ZERO;
    }
    XrFlags64 int_value = value;
    if (int_value != 0) {
        // Something is left, it must be invalid
        return VALIDATE_XR_FLAGS_INVALID;
    }
    return VALIDATE_XR_FLAGS_SUCCESS;
}

// Function to validate XrEnvironmentDepthSwapchainCreateFlagsMETA flags
ValidateXrFlagsResult ValidateXrEnvironmentDepthSwapchainCreateFlagsMETA(const XrFlags64 value) {
    if (0 == value) {
        return VALIDATE_XR_FLAGS_ZERO;
    }
    XrFlags64 int_value = value;
    if (int_value != 0) {
        // Something is left, it must be invalid
        return VALIDATE_XR_FLAGS_INVALID;
    }
    return VALIDATE_XR_FLAGS_SUCCESS;
}

// Function to validate XrFoveationDynamicFlagsHTC flags
ValidateXrFlagsResult ValidateXrFoveationDynamicFlagsHTC(const XrFlags64 value) {
    if (0 == value) {
        return VALIDATE_XR_FLAGS_ZERO;
    }
    XrFlags64 int_value = value;
    if ((int_value & XR_FOVEATION_DYNAMIC_LEVEL_ENABLED_BIT_HTC) != 0) {
        // Clear the value XR_FOVEATION_DYNAMIC_LEVEL_ENABLED_BIT_HTC since it is valid
        int_value &= ~XR_FOVEATION_DYNAMIC_LEVEL_ENABLED_BIT_HTC;
    }
    if ((int_value & XR_FOVEATION_DYNAMIC_CLEAR_FOV_ENABLED_BIT_HTC) != 0) {
        // Clear the value XR_FOVEATION_DYNAMIC_CLEAR_FOV_ENABLED_BIT_HTC since it is valid
        int_value &= ~XR_FOVEATION_DYNAMIC_CLEAR_FOV_ENABLED_BIT_HTC;
    }
    if ((int_value & XR_FOVEATION_DYNAMIC_FOCAL_CENTER_OFFSET_ENABLED_BIT_HTC) != 0) {
        // Clear the value XR_FOVEATION_DYNAMIC_FOCAL_CENTER_OFFSET_ENABLED_BIT_HTC since it is valid
        int_value &= ~XR_FOVEATION_DYNAMIC_FOCAL_CENTER_OFFSET_ENABLED_BIT_HTC;
    }
    if (int_value != 0) {
        // Something is left, it must be invalid
        return VALIDATE_XR_FLAGS_INVALID;
    }
    return VALIDATE_XR_FLAGS_SUCCESS;
}

// Function to validate XrSpatialMeshConfigFlagsBD flags
ValidateXrFlagsResult ValidateXrSpatialMeshConfigFlagsBD(const XrFlags64 value) {
    if (0 == value) {
        return VALIDATE_XR_FLAGS_ZERO;
    }
    XrFlags64 int_value = value;
    if ((int_value & XR_SPATIAL_MESH_CONFIG_SEMANTIC_BIT_BD) != 0) {
        // Clear the value XR_SPATIAL_MESH_CONFIG_SEMANTIC_BIT_BD since it is valid
        int_value &= ~XR_SPATIAL_MESH_CONFIG_SEMANTIC_BIT_BD;
    }
    if ((int_value & XR_SPATIAL_MESH_CONFIG_ALIGN_SEMANTIC_WITH_VERTEX_BIT_BD) != 0) {
        // Clear the value XR_SPATIAL_MESH_CONFIG_ALIGN_SEMANTIC_WITH_VERTEX_BIT_BD since it is valid
        int_value &= ~XR_SPATIAL_MESH_CONFIG_ALIGN_SEMANTIC_WITH_VERTEX_BIT_BD;
    }
    if (int_value != 0) {
        // Something is left, it must be invalid
        return VALIDATE_XR_FLAGS_INVALID;
    }
    return VALIDATE_XR_FLAGS_SUCCESS;
}

// Function to validate XrPlaneDetectionCapabilityFlagsEXT flags
ValidateXrFlagsResult ValidateXrPlaneDetectionCapabilityFlagsEXT(const XrFlags64 value) {
    if (0 == value) {
        return VALIDATE_XR_FLAGS_ZERO;
    }
    XrFlags64 int_value = value;
    if ((int_value & XR_PLANE_DETECTION_CAPABILITY_PLANE_DETECTION_BIT_EXT) != 0) {
        // Clear the value XR_PLANE_DETECTION_CAPABILITY_PLANE_DETECTION_BIT_EXT since it is valid
        int_value &= ~XR_PLANE_DETECTION_CAPABILITY_PLANE_DETECTION_BIT_EXT;
    }
    if ((int_value & XR_PLANE_DETECTION_CAPABILITY_PLANE_HOLES_BIT_EXT) != 0) {
        // Clear the value XR_PLANE_DETECTION_CAPABILITY_PLANE_HOLES_BIT_EXT since it is valid
        int_value &= ~XR_PLANE_DETECTION_CAPABILITY_PLANE_HOLES_BIT_EXT;
    }
    if ((int_value & XR_PLANE_DETECTION_CAPABILITY_SEMANTIC_CEILING_BIT_EXT) != 0) {
        // Clear the value XR_PLANE_DETECTION_CAPABILITY_SEMANTIC_CEILING_BIT_EXT since it is valid
        int_value &= ~XR_PLANE_DETECTION_CAPABILITY_SEMANTIC_CEILING_BIT_EXT;
    }
    if ((int_value & XR_PLANE_DETECTION_CAPABILITY_SEMANTIC_FLOOR_BIT_EXT) != 0) {
        // Clear the value XR_PLANE_DETECTION_CAPABILITY_SEMANTIC_FLOOR_BIT_EXT since it is valid
        int_value &= ~XR_PLANE_DETECTION_CAPABILITY_SEMANTIC_FLOOR_BIT_EXT;
    }
    if ((int_value & XR_PLANE_DETECTION_CAPABILITY_SEMANTIC_WALL_BIT_EXT) != 0) {
        // Clear the value XR_PLANE_DETECTION_CAPABILITY_SEMANTIC_WALL_BIT_EXT since it is valid
        int_value &= ~XR_PLANE_DETECTION_CAPABILITY_SEMANTIC_WALL_BIT_EXT;
    }
    if ((int_value & XR_PLANE_DETECTION_CAPABILITY_SEMANTIC_PLATFORM_BIT_EXT) != 0) {
        // Clear the value XR_PLANE_DETECTION_CAPABILITY_SEMANTIC_PLATFORM_BIT_EXT since it is valid
        int_value &= ~XR_PLANE_DETECTION_CAPABILITY_SEMANTIC_PLATFORM_BIT_EXT;
    }
    if ((int_value & XR_PLANE_DETECTION_CAPABILITY_ORIENTATION_BIT_EXT) != 0) {
        // Clear the value XR_PLANE_DETECTION_CAPABILITY_ORIENTATION_BIT_EXT since it is valid
        int_value &= ~XR_PLANE_DETECTION_CAPABILITY_ORIENTATION_BIT_EXT;
    }
    if (int_value != 0) {
        // Something is left, it must be invalid
        return VALIDATE_XR_FLAGS_INVALID;
    }
    return VALIDATE_XR_FLAGS_SUCCESS;
}

// Function to validate XrPlaneDetectorFlagsEXT flags
ValidateXrFlagsResult ValidateXrPlaneDetectorFlagsEXT(const XrFlags64 value) {
    if (0 == value) {
        return VALIDATE_XR_FLAGS_ZERO;
    }
    XrFlags64 int_value = value;
    if ((int_value & XR_PLANE_DETECTOR_ENABLE_CONTOUR_BIT_EXT) != 0) {
        // Clear the value XR_PLANE_DETECTOR_ENABLE_CONTOUR_BIT_EXT since it is valid
        int_value &= ~XR_PLANE_DETECTOR_ENABLE_CONTOUR_BIT_EXT;
    }
    if (int_value != 0) {
        // Something is left, it must be invalid
        return VALIDATE_XR_FLAGS_INVALID;
    }
    return VALIDATE_XR_FLAGS_SUCCESS;
}

// Function to validate XrWorldMeshDetectorFlagsML flags
ValidateXrFlagsResult ValidateXrWorldMeshDetectorFlagsML(const XrFlags64 value) {
    if (0 == value) {
        return VALIDATE_XR_FLAGS_ZERO;
    }
    XrFlags64 int_value = value;
    if ((int_value & XR_WORLD_MESH_DETECTOR_POINT_CLOUD_BIT_ML) != 0) {
        // Clear the value XR_WORLD_MESH_DETECTOR_POINT_CLOUD_BIT_ML since it is valid
        int_value &= ~XR_WORLD_MESH_DETECTOR_POINT_CLOUD_BIT_ML;
    }
    if ((int_value & XR_WORLD_MESH_DETECTOR_COMPUTE_NORMALS_BIT_ML) != 0) {
        // Clear the value XR_WORLD_MESH_DETECTOR_COMPUTE_NORMALS_BIT_ML since it is valid
        int_value &= ~XR_WORLD_MESH_DETECTOR_COMPUTE_NORMALS_BIT_ML;
    }
    if ((int_value & XR_WORLD_MESH_DETECTOR_COMPUTE_CONFIDENCE_BIT_ML) != 0) {
        // Clear the value XR_WORLD_MESH_DETECTOR_COMPUTE_CONFIDENCE_BIT_ML since it is valid
        int_value &= ~XR_WORLD_MESH_DETECTOR_COMPUTE_CONFIDENCE_BIT_ML;
    }
    if ((int_value & XR_WORLD_MESH_DETECTOR_PLANARIZE_BIT_ML) != 0) {
        // Clear the value XR_WORLD_MESH_DETECTOR_PLANARIZE_BIT_ML since it is valid
        int_value &= ~XR_WORLD_MESH_DETECTOR_PLANARIZE_BIT_ML;
    }
    if ((int_value & XR_WORLD_MESH_DETECTOR_REMOVE_MESH_SKIRT_BIT_ML) != 0) {
        // Clear the value XR_WORLD_MESH_DETECTOR_REMOVE_MESH_SKIRT_BIT_ML since it is valid
        int_value &= ~XR_WORLD_MESH_DETECTOR_REMOVE_MESH_SKIRT_BIT_ML;
    }
    if ((int_value & XR_WORLD_MESH_DETECTOR_INDEX_ORDER_CW_BIT_ML) != 0) {
        // Clear the value XR_WORLD_MESH_DETECTOR_INDEX_ORDER_CW_BIT_ML since it is valid
        int_value &= ~XR_WORLD_MESH_DETECTOR_INDEX_ORDER_CW_BIT_ML;
    }
    if (int_value != 0) {
        // Something is left, it must be invalid
        return VALIDATE_XR_FLAGS_INVALID;
    }
    return VALIDATE_XR_FLAGS_SUCCESS;
}

// Function to validate XrFacialExpressionBlendShapePropertiesFlagsML flags
ValidateXrFlagsResult ValidateXrFacialExpressionBlendShapePropertiesFlagsML(const XrFlags64 value) {
    if (0 == value) {
        return VALIDATE_XR_FLAGS_ZERO;
    }
    XrFlags64 int_value = value;
    if ((int_value & XR_FACIAL_EXPRESSION_BLEND_SHAPE_PROPERTIES_VALID_BIT_ML) != 0) {
        // Clear the value XR_FACIAL_EXPRESSION_BLEND_SHAPE_PROPERTIES_VALID_BIT_ML since it is valid
        int_value &= ~XR_FACIAL_EXPRESSION_BLEND_SHAPE_PROPERTIES_VALID_BIT_ML;
    }
    if ((int_value & XR_FACIAL_EXPRESSION_BLEND_SHAPE_PROPERTIES_TRACKED_BIT_ML) != 0) {
        // Clear the value XR_FACIAL_EXPRESSION_BLEND_SHAPE_PROPERTIES_TRACKED_BIT_ML since it is valid
        int_value &= ~XR_FACIAL_EXPRESSION_BLEND_SHAPE_PROPERTIES_TRACKED_BIT_ML;
    }
    if (int_value != 0) {
        // Something is left, it must be invalid
        return VALIDATE_XR_FLAGS_INVALID;
    }
    return VALIDATE_XR_FLAGS_SUCCESS;
}

// Function to validate XrResult enum
bool ValidateXrEnum(GenValidUsageXrInstanceInfo *instance_info,
                    const std::string &command_name,
                    const std::string &validation_name,
                    const std::string &item_name,
                    std::vector<GenValidUsageXrObjectInfo>& objects_info,
                    const XrResult value) {
    (void)instance_info;  // quiet warnings
    (void)command_name;  // quiet warnings
    (void)validation_name;  // quiet warnings
    (void)item_name;  // quiet warnings
    (void)objects_info;  // quiet warnings
    switch (value) {
        case XR_SUCCESS:
            return true;
        case XR_TIMEOUT_EXPIRED:
            return true;
        case XR_SESSION_LOSS_PENDING:
            return true;
        case XR_EVENT_UNAVAILABLE:
            return true;
        case XR_SPACE_BOUNDS_UNAVAILABLE:
            return true;
        case XR_SESSION_NOT_FOCUSED:
            return true;
        case XR_FRAME_DISCARDED:
            return true;
        case XR_ERROR_VALIDATION_FAILURE:
            return true;
        case XR_ERROR_RUNTIME_FAILURE:
            return true;
        case XR_ERROR_OUT_OF_MEMORY:
            return true;
        case XR_ERROR_API_VERSION_UNSUPPORTED:
            return true;
        case XR_ERROR_INITIALIZATION_FAILED:
            return true;
        case XR_ERROR_FUNCTION_UNSUPPORTED:
            return true;
        case XR_ERROR_FEATURE_UNSUPPORTED:
            return true;
        case XR_ERROR_EXTENSION_NOT_PRESENT:
            return true;
        case XR_ERROR_LIMIT_REACHED:
            return true;
        case XR_ERROR_SIZE_INSUFFICIENT:
            return true;
        case XR_ERROR_HANDLE_INVALID:
            return true;
        case XR_ERROR_INSTANCE_LOST:
            return true;
        case XR_ERROR_SESSION_RUNNING:
            return true;
        case XR_ERROR_SESSION_NOT_RUNNING:
            return true;
        case XR_ERROR_SESSION_LOST:
            return true;
        case XR_ERROR_SYSTEM_INVALID:
            return true;
        case XR_ERROR_PATH_INVALID:
            return true;
        case XR_ERROR_PATH_COUNT_EXCEEDED:
            return true;
        case XR_ERROR_PATH_FORMAT_INVALID:
            return true;
        case XR_ERROR_PATH_UNSUPPORTED:
            return true;
        case XR_ERROR_LAYER_INVALID:
            return true;
        case XR_ERROR_LAYER_LIMIT_EXCEEDED:
            return true;
        case XR_ERROR_SWAPCHAIN_RECT_INVALID:
            return true;
        case XR_ERROR_SWAPCHAIN_FORMAT_UNSUPPORTED:
            return true;
        case XR_ERROR_ACTION_TYPE_MISMATCH:
            return true;
        case XR_ERROR_SESSION_NOT_READY:
            return true;
        case XR_ERROR_SESSION_NOT_STOPPING:
            return true;
        case XR_ERROR_TIME_INVALID:
            return true;
        case XR_ERROR_REFERENCE_SPACE_UNSUPPORTED:
            return true;
        case XR_ERROR_FILE_ACCESS_ERROR:
            return true;
        case XR_ERROR_FILE_CONTENTS_INVALID:
            return true;
        case XR_ERROR_FORM_FACTOR_UNSUPPORTED:
            return true;
        case XR_ERROR_FORM_FACTOR_UNAVAILABLE:
            return true;
        case XR_ERROR_API_LAYER_NOT_PRESENT:
            return true;
        case XR_ERROR_CALL_ORDER_INVALID:
            return true;
        case XR_ERROR_GRAPHICS_DEVICE_INVALID:
            return true;
        case XR_ERROR_POSE_INVALID:
            return true;
        case XR_ERROR_INDEX_OUT_OF_RANGE:
            return true;
        case XR_ERROR_VIEW_CONFIGURATION_TYPE_UNSUPPORTED:
            return true;
        case XR_ERROR_ENVIRONMENT_BLEND_MODE_UNSUPPORTED:
            return true;
        case XR_ERROR_NAME_DUPLICATED:
            return true;
        case XR_ERROR_NAME_INVALID:
            return true;
        case XR_ERROR_ACTIONSET_NOT_ATTACHED:
            return true;
        case XR_ERROR_ACTIONSETS_ALREADY_ATTACHED:
            return true;
        case XR_ERROR_LOCALIZED_NAME_DUPLICATED:
            return true;
        case XR_ERROR_LOCALIZED_NAME_INVALID:
            return true;
        case XR_ERROR_GRAPHICS_REQUIREMENTS_CALL_MISSING:
            return true;
        case XR_ERROR_RUNTIME_UNAVAILABLE:
            return true;
        case XR_ERROR_EXTENSION_DEPENDENCY_NOT_ENABLED:
            return true;
        case XR_ERROR_PERMISSION_INSUFFICIENT:
            return true;
        case XR_ERROR_ANDROID_THREAD_SETTINGS_ID_INVALID_KHR:
            // Enum value XR_ERROR_ANDROID_THREAD_SETTINGS_ID_INVALID_KHR requires extension XR_KHR_android_thread_settings, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_KHR_android_thread_settings")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrResult value \"XR_ERROR_ANDROID_THREAD_SETTINGS_ID_INVALID_KHR\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_KHR_android_thread_settings\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_ERROR_ANDROID_THREAD_SETTINGS_FAILURE_KHR:
            // Enum value XR_ERROR_ANDROID_THREAD_SETTINGS_FAILURE_KHR requires extension XR_KHR_android_thread_settings, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_KHR_android_thread_settings")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrResult value \"XR_ERROR_ANDROID_THREAD_SETTINGS_FAILURE_KHR\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_KHR_android_thread_settings\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_ERROR_CREATE_SPATIAL_ANCHOR_FAILED_MSFT:
            // Enum value XR_ERROR_CREATE_SPATIAL_ANCHOR_FAILED_MSFT requires extension XR_MSFT_spatial_anchor, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_MSFT_spatial_anchor")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrResult value \"XR_ERROR_CREATE_SPATIAL_ANCHOR_FAILED_MSFT\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_MSFT_spatial_anchor\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_ERROR_SECONDARY_VIEW_CONFIGURATION_TYPE_NOT_ENABLED_MSFT:
            // Enum value XR_ERROR_SECONDARY_VIEW_CONFIGURATION_TYPE_NOT_ENABLED_MSFT requires extension XR_MSFT_secondary_view_configuration, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_MSFT_secondary_view_configuration")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrResult value \"XR_ERROR_SECONDARY_VIEW_CONFIGURATION_TYPE_NOT_ENABLED_MSFT\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_MSFT_secondary_view_configuration\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_ERROR_CONTROLLER_MODEL_KEY_INVALID_MSFT:
            // Enum value XR_ERROR_CONTROLLER_MODEL_KEY_INVALID_MSFT requires extension XR_MSFT_controller_model, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_MSFT_controller_model")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrResult value \"XR_ERROR_CONTROLLER_MODEL_KEY_INVALID_MSFT\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_MSFT_controller_model\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_ERROR_REPROJECTION_MODE_UNSUPPORTED_MSFT:
            // Enum value XR_ERROR_REPROJECTION_MODE_UNSUPPORTED_MSFT requires extension XR_MSFT_composition_layer_reprojection, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_MSFT_composition_layer_reprojection")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrResult value \"XR_ERROR_REPROJECTION_MODE_UNSUPPORTED_MSFT\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_MSFT_composition_layer_reprojection\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_ERROR_COMPUTE_NEW_SCENE_NOT_COMPLETED_MSFT:
            // Enum value XR_ERROR_COMPUTE_NEW_SCENE_NOT_COMPLETED_MSFT requires extension XR_MSFT_scene_understanding, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_MSFT_scene_understanding")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrResult value \"XR_ERROR_COMPUTE_NEW_SCENE_NOT_COMPLETED_MSFT\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_MSFT_scene_understanding\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_ERROR_SCENE_COMPONENT_ID_INVALID_MSFT:
            // Enum value XR_ERROR_SCENE_COMPONENT_ID_INVALID_MSFT requires extension XR_MSFT_scene_understanding, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_MSFT_scene_understanding")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrResult value \"XR_ERROR_SCENE_COMPONENT_ID_INVALID_MSFT\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_MSFT_scene_understanding\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_ERROR_SCENE_COMPONENT_TYPE_MISMATCH_MSFT:
            // Enum value XR_ERROR_SCENE_COMPONENT_TYPE_MISMATCH_MSFT requires extension XR_MSFT_scene_understanding, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_MSFT_scene_understanding")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrResult value \"XR_ERROR_SCENE_COMPONENT_TYPE_MISMATCH_MSFT\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_MSFT_scene_understanding\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_ERROR_SCENE_MESH_BUFFER_ID_INVALID_MSFT:
            // Enum value XR_ERROR_SCENE_MESH_BUFFER_ID_INVALID_MSFT requires extension XR_MSFT_scene_understanding, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_MSFT_scene_understanding")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrResult value \"XR_ERROR_SCENE_MESH_BUFFER_ID_INVALID_MSFT\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_MSFT_scene_understanding\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_ERROR_SCENE_COMPUTE_FEATURE_INCOMPATIBLE_MSFT:
            // Enum value XR_ERROR_SCENE_COMPUTE_FEATURE_INCOMPATIBLE_MSFT requires extension XR_MSFT_scene_understanding, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_MSFT_scene_understanding")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrResult value \"XR_ERROR_SCENE_COMPUTE_FEATURE_INCOMPATIBLE_MSFT\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_MSFT_scene_understanding\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_ERROR_SCENE_COMPUTE_CONSISTENCY_MISMATCH_MSFT:
            // Enum value XR_ERROR_SCENE_COMPUTE_CONSISTENCY_MISMATCH_MSFT requires extension XR_MSFT_scene_understanding, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_MSFT_scene_understanding")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrResult value \"XR_ERROR_SCENE_COMPUTE_CONSISTENCY_MISMATCH_MSFT\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_MSFT_scene_understanding\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_ERROR_DISPLAY_REFRESH_RATE_UNSUPPORTED_FB:
            // Enum value XR_ERROR_DISPLAY_REFRESH_RATE_UNSUPPORTED_FB requires extension XR_FB_display_refresh_rate, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_FB_display_refresh_rate")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrResult value \"XR_ERROR_DISPLAY_REFRESH_RATE_UNSUPPORTED_FB\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_FB_display_refresh_rate\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_ERROR_COLOR_SPACE_UNSUPPORTED_FB:
            // Enum value XR_ERROR_COLOR_SPACE_UNSUPPORTED_FB requires extension XR_FB_color_space, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_FB_color_space")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrResult value \"XR_ERROR_COLOR_SPACE_UNSUPPORTED_FB\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_FB_color_space\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_ERROR_SPACE_COMPONENT_NOT_SUPPORTED_FB:
            // Enum value XR_ERROR_SPACE_COMPONENT_NOT_SUPPORTED_FB requires extension XR_FB_spatial_entity, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_FB_spatial_entity")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrResult value \"XR_ERROR_SPACE_COMPONENT_NOT_SUPPORTED_FB\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_FB_spatial_entity\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_ERROR_SPACE_COMPONENT_NOT_ENABLED_FB:
            // Enum value XR_ERROR_SPACE_COMPONENT_NOT_ENABLED_FB requires extension XR_FB_spatial_entity, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_FB_spatial_entity")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrResult value \"XR_ERROR_SPACE_COMPONENT_NOT_ENABLED_FB\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_FB_spatial_entity\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_ERROR_SPACE_COMPONENT_STATUS_PENDING_FB:
            // Enum value XR_ERROR_SPACE_COMPONENT_STATUS_PENDING_FB requires extension XR_FB_spatial_entity, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_FB_spatial_entity")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrResult value \"XR_ERROR_SPACE_COMPONENT_STATUS_PENDING_FB\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_FB_spatial_entity\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_ERROR_SPACE_COMPONENT_STATUS_ALREADY_SET_FB:
            // Enum value XR_ERROR_SPACE_COMPONENT_STATUS_ALREADY_SET_FB requires extension XR_FB_spatial_entity, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_FB_spatial_entity")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrResult value \"XR_ERROR_SPACE_COMPONENT_STATUS_ALREADY_SET_FB\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_FB_spatial_entity\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_ERROR_UNEXPECTED_STATE_PASSTHROUGH_FB:
            // Enum value XR_ERROR_UNEXPECTED_STATE_PASSTHROUGH_FB requires extension XR_FB_passthrough, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_FB_passthrough")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrResult value \"XR_ERROR_UNEXPECTED_STATE_PASSTHROUGH_FB\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_FB_passthrough\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_ERROR_FEATURE_ALREADY_CREATED_PASSTHROUGH_FB:
            // Enum value XR_ERROR_FEATURE_ALREADY_CREATED_PASSTHROUGH_FB requires extension XR_FB_passthrough, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_FB_passthrough")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrResult value \"XR_ERROR_FEATURE_ALREADY_CREATED_PASSTHROUGH_FB\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_FB_passthrough\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_ERROR_FEATURE_REQUIRED_PASSTHROUGH_FB:
            // Enum value XR_ERROR_FEATURE_REQUIRED_PASSTHROUGH_FB requires extension XR_FB_passthrough, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_FB_passthrough")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrResult value \"XR_ERROR_FEATURE_REQUIRED_PASSTHROUGH_FB\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_FB_passthrough\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_ERROR_NOT_PERMITTED_PASSTHROUGH_FB:
            // Enum value XR_ERROR_NOT_PERMITTED_PASSTHROUGH_FB requires extension XR_FB_passthrough, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_FB_passthrough")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrResult value \"XR_ERROR_NOT_PERMITTED_PASSTHROUGH_FB\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_FB_passthrough\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_ERROR_INSUFFICIENT_RESOURCES_PASSTHROUGH_FB:
            // Enum value XR_ERROR_INSUFFICIENT_RESOURCES_PASSTHROUGH_FB requires extension XR_FB_passthrough, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_FB_passthrough")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrResult value \"XR_ERROR_INSUFFICIENT_RESOURCES_PASSTHROUGH_FB\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_FB_passthrough\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_ERROR_UNKNOWN_PASSTHROUGH_FB:
            // Enum value XR_ERROR_UNKNOWN_PASSTHROUGH_FB requires extension XR_FB_passthrough, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_FB_passthrough")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrResult value \"XR_ERROR_UNKNOWN_PASSTHROUGH_FB\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_FB_passthrough\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_ERROR_RENDER_MODEL_KEY_INVALID_FB:
            // Enum value XR_ERROR_RENDER_MODEL_KEY_INVALID_FB requires extension XR_FB_render_model, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_FB_render_model")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrResult value \"XR_ERROR_RENDER_MODEL_KEY_INVALID_FB\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_FB_render_model\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_RENDER_MODEL_UNAVAILABLE_FB:
            // Enum value XR_RENDER_MODEL_UNAVAILABLE_FB requires extension XR_FB_render_model, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_FB_render_model")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrResult value \"XR_RENDER_MODEL_UNAVAILABLE_FB\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_FB_render_model\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_ERROR_MARKER_NOT_TRACKED_VARJO:
            // Enum value XR_ERROR_MARKER_NOT_TRACKED_VARJO requires extension XR_VARJO_marker_tracking, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_VARJO_marker_tracking")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrResult value \"XR_ERROR_MARKER_NOT_TRACKED_VARJO\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_VARJO_marker_tracking\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_ERROR_MARKER_ID_INVALID_VARJO:
            // Enum value XR_ERROR_MARKER_ID_INVALID_VARJO requires extension XR_VARJO_marker_tracking, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_VARJO_marker_tracking")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrResult value \"XR_ERROR_MARKER_ID_INVALID_VARJO\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_VARJO_marker_tracking\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_ERROR_MARKER_DETECTOR_PERMISSION_DENIED_ML:
            // Enum value XR_ERROR_MARKER_DETECTOR_PERMISSION_DENIED_ML requires extension XR_ML_marker_understanding, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_ML_marker_understanding")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrResult value \"XR_ERROR_MARKER_DETECTOR_PERMISSION_DENIED_ML\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_ML_marker_understanding\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_ERROR_MARKER_DETECTOR_LOCATE_FAILED_ML:
            // Enum value XR_ERROR_MARKER_DETECTOR_LOCATE_FAILED_ML requires extension XR_ML_marker_understanding, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_ML_marker_understanding")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrResult value \"XR_ERROR_MARKER_DETECTOR_LOCATE_FAILED_ML\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_ML_marker_understanding\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_ERROR_MARKER_DETECTOR_INVALID_DATA_QUERY_ML:
            // Enum value XR_ERROR_MARKER_DETECTOR_INVALID_DATA_QUERY_ML requires extension XR_ML_marker_understanding, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_ML_marker_understanding")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrResult value \"XR_ERROR_MARKER_DETECTOR_INVALID_DATA_QUERY_ML\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_ML_marker_understanding\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_ERROR_MARKER_DETECTOR_INVALID_CREATE_INFO_ML:
            // Enum value XR_ERROR_MARKER_DETECTOR_INVALID_CREATE_INFO_ML requires extension XR_ML_marker_understanding, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_ML_marker_understanding")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrResult value \"XR_ERROR_MARKER_DETECTOR_INVALID_CREATE_INFO_ML\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_ML_marker_understanding\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_ERROR_MARKER_INVALID_ML:
            // Enum value XR_ERROR_MARKER_INVALID_ML requires extension XR_ML_marker_understanding, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_ML_marker_understanding")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrResult value \"XR_ERROR_MARKER_INVALID_ML\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_ML_marker_understanding\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_ERROR_LOCALIZATION_MAP_INCOMPATIBLE_ML:
            // Enum value XR_ERROR_LOCALIZATION_MAP_INCOMPATIBLE_ML requires extension XR_ML_localization_map, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_ML_localization_map")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrResult value \"XR_ERROR_LOCALIZATION_MAP_INCOMPATIBLE_ML\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_ML_localization_map\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_ERROR_LOCALIZATION_MAP_UNAVAILABLE_ML:
            // Enum value XR_ERROR_LOCALIZATION_MAP_UNAVAILABLE_ML requires extension XR_ML_localization_map, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_ML_localization_map")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrResult value \"XR_ERROR_LOCALIZATION_MAP_UNAVAILABLE_ML\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_ML_localization_map\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_ERROR_LOCALIZATION_MAP_FAIL_ML:
            // Enum value XR_ERROR_LOCALIZATION_MAP_FAIL_ML requires extension XR_ML_localization_map, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_ML_localization_map")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrResult value \"XR_ERROR_LOCALIZATION_MAP_FAIL_ML\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_ML_localization_map\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_ERROR_LOCALIZATION_MAP_IMPORT_EXPORT_PERMISSION_DENIED_ML:
            // Enum value XR_ERROR_LOCALIZATION_MAP_IMPORT_EXPORT_PERMISSION_DENIED_ML requires extension XR_ML_localization_map, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_ML_localization_map")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrResult value \"XR_ERROR_LOCALIZATION_MAP_IMPORT_EXPORT_PERMISSION_DENIED_ML\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_ML_localization_map\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_ERROR_LOCALIZATION_MAP_PERMISSION_DENIED_ML:
            // Enum value XR_ERROR_LOCALIZATION_MAP_PERMISSION_DENIED_ML requires extension XR_ML_localization_map, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_ML_localization_map")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrResult value \"XR_ERROR_LOCALIZATION_MAP_PERMISSION_DENIED_ML\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_ML_localization_map\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_ERROR_LOCALIZATION_MAP_ALREADY_EXISTS_ML:
            // Enum value XR_ERROR_LOCALIZATION_MAP_ALREADY_EXISTS_ML requires extension XR_ML_localization_map, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_ML_localization_map")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrResult value \"XR_ERROR_LOCALIZATION_MAP_ALREADY_EXISTS_ML\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_ML_localization_map\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_ERROR_LOCALIZATION_MAP_CANNOT_EXPORT_CLOUD_MAP_ML:
            // Enum value XR_ERROR_LOCALIZATION_MAP_CANNOT_EXPORT_CLOUD_MAP_ML requires extension XR_ML_localization_map, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_ML_localization_map")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrResult value \"XR_ERROR_LOCALIZATION_MAP_CANNOT_EXPORT_CLOUD_MAP_ML\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_ML_localization_map\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_ERROR_SPATIAL_ANCHORS_PERMISSION_DENIED_ML:
            // Enum value XR_ERROR_SPATIAL_ANCHORS_PERMISSION_DENIED_ML requires extension XR_ML_spatial_anchors, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_ML_spatial_anchors")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrResult value \"XR_ERROR_SPATIAL_ANCHORS_PERMISSION_DENIED_ML\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_ML_spatial_anchors\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_ERROR_SPATIAL_ANCHORS_NOT_LOCALIZED_ML:
            // Enum value XR_ERROR_SPATIAL_ANCHORS_NOT_LOCALIZED_ML requires extension XR_ML_spatial_anchors, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_ML_spatial_anchors")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrResult value \"XR_ERROR_SPATIAL_ANCHORS_NOT_LOCALIZED_ML\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_ML_spatial_anchors\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_ERROR_SPATIAL_ANCHORS_OUT_OF_MAP_BOUNDS_ML:
            // Enum value XR_ERROR_SPATIAL_ANCHORS_OUT_OF_MAP_BOUNDS_ML requires extension XR_ML_spatial_anchors, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_ML_spatial_anchors")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrResult value \"XR_ERROR_SPATIAL_ANCHORS_OUT_OF_MAP_BOUNDS_ML\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_ML_spatial_anchors\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_ERROR_SPATIAL_ANCHORS_SPACE_NOT_LOCATABLE_ML:
            // Enum value XR_ERROR_SPATIAL_ANCHORS_SPACE_NOT_LOCATABLE_ML requires extension XR_ML_spatial_anchors, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_ML_spatial_anchors")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrResult value \"XR_ERROR_SPATIAL_ANCHORS_SPACE_NOT_LOCATABLE_ML\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_ML_spatial_anchors\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_ERROR_SPATIAL_ANCHORS_ANCHOR_NOT_FOUND_ML:
            // Enum value XR_ERROR_SPATIAL_ANCHORS_ANCHOR_NOT_FOUND_ML requires extension XR_ML_spatial_anchors_storage, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_ML_spatial_anchors_storage")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrResult value \"XR_ERROR_SPATIAL_ANCHORS_ANCHOR_NOT_FOUND_ML\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_ML_spatial_anchors_storage\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_ERROR_SPATIAL_ANCHOR_NAME_NOT_FOUND_MSFT:
            // Enum value XR_ERROR_SPATIAL_ANCHOR_NAME_NOT_FOUND_MSFT requires extension XR_MSFT_spatial_anchor_persistence, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_MSFT_spatial_anchor_persistence")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrResult value \"XR_ERROR_SPATIAL_ANCHOR_NAME_NOT_FOUND_MSFT\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_MSFT_spatial_anchor_persistence\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_ERROR_SPATIAL_ANCHOR_NAME_INVALID_MSFT:
            // Enum value XR_ERROR_SPATIAL_ANCHOR_NAME_INVALID_MSFT requires extension XR_MSFT_spatial_anchor_persistence, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_MSFT_spatial_anchor_persistence")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrResult value \"XR_ERROR_SPATIAL_ANCHOR_NAME_INVALID_MSFT\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_MSFT_spatial_anchor_persistence\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_SCENE_MARKER_DATA_NOT_STRING_MSFT:
            // Enum value XR_SCENE_MARKER_DATA_NOT_STRING_MSFT requires extension XR_MSFT_scene_marker, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_MSFT_scene_marker")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrResult value \"XR_SCENE_MARKER_DATA_NOT_STRING_MSFT\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_MSFT_scene_marker\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_ERROR_SPACE_MAPPING_INSUFFICIENT_FB:
            // Enum value XR_ERROR_SPACE_MAPPING_INSUFFICIENT_FB requires extension XR_FB_spatial_entity_sharing, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_FB_spatial_entity_sharing")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrResult value \"XR_ERROR_SPACE_MAPPING_INSUFFICIENT_FB\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_FB_spatial_entity_sharing\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_ERROR_SPACE_LOCALIZATION_FAILED_FB:
            // Enum value XR_ERROR_SPACE_LOCALIZATION_FAILED_FB requires extension XR_FB_spatial_entity_sharing, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_FB_spatial_entity_sharing")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrResult value \"XR_ERROR_SPACE_LOCALIZATION_FAILED_FB\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_FB_spatial_entity_sharing\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_ERROR_SPACE_NETWORK_TIMEOUT_FB:
            // Enum value XR_ERROR_SPACE_NETWORK_TIMEOUT_FB requires extension XR_FB_spatial_entity_sharing, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_FB_spatial_entity_sharing")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrResult value \"XR_ERROR_SPACE_NETWORK_TIMEOUT_FB\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_FB_spatial_entity_sharing\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_ERROR_SPACE_NETWORK_REQUEST_FAILED_FB:
            // Enum value XR_ERROR_SPACE_NETWORK_REQUEST_FAILED_FB requires extension XR_FB_spatial_entity_sharing, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_FB_spatial_entity_sharing")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrResult value \"XR_ERROR_SPACE_NETWORK_REQUEST_FAILED_FB\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_FB_spatial_entity_sharing\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_ERROR_SPACE_CLOUD_STORAGE_DISABLED_FB:
            // Enum value XR_ERROR_SPACE_CLOUD_STORAGE_DISABLED_FB requires extension XR_FB_spatial_entity_sharing, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_FB_spatial_entity_sharing")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrResult value \"XR_ERROR_SPACE_CLOUD_STORAGE_DISABLED_FB\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_FB_spatial_entity_sharing\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_ERROR_SPACE_INSUFFICIENT_RESOURCES_META:
            // Enum value XR_ERROR_SPACE_INSUFFICIENT_RESOURCES_META requires extension XR_META_spatial_entity_persistence, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_META_spatial_entity_persistence")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrResult value \"XR_ERROR_SPACE_INSUFFICIENT_RESOURCES_META\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_META_spatial_entity_persistence\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_ERROR_SPACE_STORAGE_AT_CAPACITY_META:
            // Enum value XR_ERROR_SPACE_STORAGE_AT_CAPACITY_META requires extension XR_META_spatial_entity_persistence, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_META_spatial_entity_persistence")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrResult value \"XR_ERROR_SPACE_STORAGE_AT_CAPACITY_META\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_META_spatial_entity_persistence\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_ERROR_SPACE_INSUFFICIENT_VIEW_META:
            // Enum value XR_ERROR_SPACE_INSUFFICIENT_VIEW_META requires extension XR_META_spatial_entity_persistence, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_META_spatial_entity_persistence")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrResult value \"XR_ERROR_SPACE_INSUFFICIENT_VIEW_META\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_META_spatial_entity_persistence\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_ERROR_SPACE_PERMISSION_INSUFFICIENT_META:
            // Enum value XR_ERROR_SPACE_PERMISSION_INSUFFICIENT_META requires extension XR_META_spatial_entity_persistence, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_META_spatial_entity_persistence")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrResult value \"XR_ERROR_SPACE_PERMISSION_INSUFFICIENT_META\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_META_spatial_entity_persistence\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_ERROR_SPACE_RATE_LIMITED_META:
            // Enum value XR_ERROR_SPACE_RATE_LIMITED_META requires extension XR_META_spatial_entity_persistence, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_META_spatial_entity_persistence")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrResult value \"XR_ERROR_SPACE_RATE_LIMITED_META\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_META_spatial_entity_persistence\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_ERROR_SPACE_TOO_DARK_META:
            // Enum value XR_ERROR_SPACE_TOO_DARK_META requires extension XR_META_spatial_entity_persistence, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_META_spatial_entity_persistence")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrResult value \"XR_ERROR_SPACE_TOO_DARK_META\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_META_spatial_entity_persistence\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_ERROR_SPACE_TOO_BRIGHT_META:
            // Enum value XR_ERROR_SPACE_TOO_BRIGHT_META requires extension XR_META_spatial_entity_persistence, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_META_spatial_entity_persistence")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrResult value \"XR_ERROR_SPACE_TOO_BRIGHT_META\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_META_spatial_entity_persistence\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_ERROR_PASSTHROUGH_COLOR_LUT_BUFFER_SIZE_MISMATCH_META:
            // Enum value XR_ERROR_PASSTHROUGH_COLOR_LUT_BUFFER_SIZE_MISMATCH_META requires extension XR_META_passthrough_color_lut, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_META_passthrough_color_lut")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrResult value \"XR_ERROR_PASSTHROUGH_COLOR_LUT_BUFFER_SIZE_MISMATCH_META\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_META_passthrough_color_lut\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_ENVIRONMENT_DEPTH_NOT_AVAILABLE_META:
            // Enum value XR_ENVIRONMENT_DEPTH_NOT_AVAILABLE_META requires extension XR_META_environment_depth, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_META_environment_depth")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrResult value \"XR_ENVIRONMENT_DEPTH_NOT_AVAILABLE_META\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_META_environment_depth\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_ERROR_RENDER_MODEL_ID_INVALID_EXT:
            // Enum value XR_ERROR_RENDER_MODEL_ID_INVALID_EXT requires extension XR_EXT_render_model, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_EXT_render_model")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrResult value \"XR_ERROR_RENDER_MODEL_ID_INVALID_EXT\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_EXT_render_model\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_ERROR_RENDER_MODEL_ASSET_UNAVAILABLE_EXT:
            // Enum value XR_ERROR_RENDER_MODEL_ASSET_UNAVAILABLE_EXT requires extension XR_EXT_render_model, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_EXT_render_model")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrResult value \"XR_ERROR_RENDER_MODEL_ASSET_UNAVAILABLE_EXT\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_EXT_render_model\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_ERROR_RENDER_MODEL_GLTF_EXTENSION_REQUIRED_EXT:
            // Enum value XR_ERROR_RENDER_MODEL_GLTF_EXTENSION_REQUIRED_EXT requires extension XR_EXT_render_model, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_EXT_render_model")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrResult value \"XR_ERROR_RENDER_MODEL_GLTF_EXTENSION_REQUIRED_EXT\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_EXT_render_model\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_ERROR_NOT_INTERACTION_RENDER_MODEL_EXT:
            // Enum value XR_ERROR_NOT_INTERACTION_RENDER_MODEL_EXT requires extension XR_EXT_interaction_render_model, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_EXT_interaction_render_model")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrResult value \"XR_ERROR_NOT_INTERACTION_RENDER_MODEL_EXT\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_EXT_interaction_render_model\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_ERROR_HINT_ALREADY_SET_QCOM:
            // Enum value XR_ERROR_HINT_ALREADY_SET_QCOM requires extension XR_QCOM_tracking_optimization_settings, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_QCOM_tracking_optimization_settings")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrResult value \"XR_ERROR_HINT_ALREADY_SET_QCOM\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_QCOM_tracking_optimization_settings\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_ERROR_NOT_AN_ANCHOR_HTC:
            // Enum value XR_ERROR_NOT_AN_ANCHOR_HTC requires extension XR_HTC_anchor, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_HTC_anchor")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrResult value \"XR_ERROR_NOT_AN_ANCHOR_HTC\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_HTC_anchor\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_ERROR_SPATIAL_ENTITY_ID_INVALID_BD:
            // Enum value XR_ERROR_SPATIAL_ENTITY_ID_INVALID_BD requires extension XR_BD_spatial_sensing, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_BD_spatial_sensing")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrResult value \"XR_ERROR_SPATIAL_ENTITY_ID_INVALID_BD\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_BD_spatial_sensing\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_ERROR_SPATIAL_SENSING_SERVICE_UNAVAILABLE_BD:
            // Enum value XR_ERROR_SPATIAL_SENSING_SERVICE_UNAVAILABLE_BD requires extension XR_BD_spatial_sensing, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_BD_spatial_sensing")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrResult value \"XR_ERROR_SPATIAL_SENSING_SERVICE_UNAVAILABLE_BD\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_BD_spatial_sensing\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_ERROR_ANCHOR_NOT_SUPPORTED_FOR_ENTITY_BD:
            // Enum value XR_ERROR_ANCHOR_NOT_SUPPORTED_FOR_ENTITY_BD requires extension XR_BD_spatial_sensing, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_BD_spatial_sensing")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrResult value \"XR_ERROR_ANCHOR_NOT_SUPPORTED_FOR_ENTITY_BD\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_BD_spatial_sensing\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_ERROR_SPATIAL_ANCHOR_NOT_FOUND_BD:
            // Enum value XR_ERROR_SPATIAL_ANCHOR_NOT_FOUND_BD requires extension XR_BD_spatial_anchor, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_BD_spatial_anchor")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrResult value \"XR_ERROR_SPATIAL_ANCHOR_NOT_FOUND_BD\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_BD_spatial_anchor\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_ERROR_SPATIAL_ANCHOR_SHARING_NETWORK_TIMEOUT_BD:
            // Enum value XR_ERROR_SPATIAL_ANCHOR_SHARING_NETWORK_TIMEOUT_BD requires extension XR_BD_spatial_anchor_sharing, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_BD_spatial_anchor_sharing")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrResult value \"XR_ERROR_SPATIAL_ANCHOR_SHARING_NETWORK_TIMEOUT_BD\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_BD_spatial_anchor_sharing\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_ERROR_SPATIAL_ANCHOR_SHARING_AUTHENTICATION_FAILURE_BD:
            // Enum value XR_ERROR_SPATIAL_ANCHOR_SHARING_AUTHENTICATION_FAILURE_BD requires extension XR_BD_spatial_anchor_sharing, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_BD_spatial_anchor_sharing")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrResult value \"XR_ERROR_SPATIAL_ANCHOR_SHARING_AUTHENTICATION_FAILURE_BD\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_BD_spatial_anchor_sharing\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_ERROR_SPATIAL_ANCHOR_SHARING_NETWORK_FAILURE_BD:
            // Enum value XR_ERROR_SPATIAL_ANCHOR_SHARING_NETWORK_FAILURE_BD requires extension XR_BD_spatial_anchor_sharing, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_BD_spatial_anchor_sharing")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrResult value \"XR_ERROR_SPATIAL_ANCHOR_SHARING_NETWORK_FAILURE_BD\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_BD_spatial_anchor_sharing\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_ERROR_SPATIAL_ANCHOR_SHARING_LOCALIZATION_FAIL_BD:
            // Enum value XR_ERROR_SPATIAL_ANCHOR_SHARING_LOCALIZATION_FAIL_BD requires extension XR_BD_spatial_anchor_sharing, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_BD_spatial_anchor_sharing")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrResult value \"XR_ERROR_SPATIAL_ANCHOR_SHARING_LOCALIZATION_FAIL_BD\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_BD_spatial_anchor_sharing\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_ERROR_SPATIAL_ANCHOR_SHARING_MAP_INSUFFICIENT_BD:
            // Enum value XR_ERROR_SPATIAL_ANCHOR_SHARING_MAP_INSUFFICIENT_BD requires extension XR_BD_spatial_anchor_sharing, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_BD_spatial_anchor_sharing")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrResult value \"XR_ERROR_SPATIAL_ANCHOR_SHARING_MAP_INSUFFICIENT_BD\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_BD_spatial_anchor_sharing\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_ERROR_SCENE_CAPTURE_FAILURE_BD:
            // Enum value XR_ERROR_SCENE_CAPTURE_FAILURE_BD requires extension XR_BD_spatial_scene, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_BD_spatial_scene")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrResult value \"XR_ERROR_SCENE_CAPTURE_FAILURE_BD\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_BD_spatial_scene\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_ERROR_SPACE_NOT_LOCATABLE_EXT:
            // Enum value XR_ERROR_SPACE_NOT_LOCATABLE_EXT requires extension XR_EXT_plane_detection, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_EXT_plane_detection")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrResult value \"XR_ERROR_SPACE_NOT_LOCATABLE_EXT\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_EXT_plane_detection\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_ERROR_PLANE_DETECTION_PERMISSION_DENIED_EXT:
            // Enum value XR_ERROR_PLANE_DETECTION_PERMISSION_DENIED_EXT requires extension XR_EXT_plane_detection, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_EXT_plane_detection")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrResult value \"XR_ERROR_PLANE_DETECTION_PERMISSION_DENIED_EXT\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_EXT_plane_detection\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_ERROR_MISMATCHING_TRACKABLE_TYPE_ANDROID:
            // Enum value XR_ERROR_MISMATCHING_TRACKABLE_TYPE_ANDROID requires extension XR_ANDROID_trackables, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_ANDROID_trackables")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrResult value \"XR_ERROR_MISMATCHING_TRACKABLE_TYPE_ANDROID\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_ANDROID_trackables\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_ERROR_TRACKABLE_TYPE_NOT_SUPPORTED_ANDROID:
            // Enum value XR_ERROR_TRACKABLE_TYPE_NOT_SUPPORTED_ANDROID requires extension XR_ANDROID_trackables, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_ANDROID_trackables")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrResult value \"XR_ERROR_TRACKABLE_TYPE_NOT_SUPPORTED_ANDROID\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_ANDROID_trackables\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_ERROR_ANCHOR_ID_NOT_FOUND_ANDROID:
            // Enum value XR_ERROR_ANCHOR_ID_NOT_FOUND_ANDROID requires extension XR_ANDROID_device_anchor_persistence, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_ANDROID_device_anchor_persistence")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrResult value \"XR_ERROR_ANCHOR_ID_NOT_FOUND_ANDROID\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_ANDROID_device_anchor_persistence\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_ERROR_ANCHOR_ALREADY_PERSISTED_ANDROID:
            // Enum value XR_ERROR_ANCHOR_ALREADY_PERSISTED_ANDROID requires extension XR_ANDROID_device_anchor_persistence, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_ANDROID_device_anchor_persistence")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrResult value \"XR_ERROR_ANCHOR_ALREADY_PERSISTED_ANDROID\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_ANDROID_device_anchor_persistence\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_ERROR_ANCHOR_NOT_TRACKING_ANDROID:
            // Enum value XR_ERROR_ANCHOR_NOT_TRACKING_ANDROID requires extension XR_ANDROID_device_anchor_persistence, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_ANDROID_device_anchor_persistence")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrResult value \"XR_ERROR_ANCHOR_NOT_TRACKING_ANDROID\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_ANDROID_device_anchor_persistence\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_ERROR_PERSISTED_DATA_NOT_READY_ANDROID:
            // Enum value XR_ERROR_PERSISTED_DATA_NOT_READY_ANDROID requires extension XR_ANDROID_device_anchor_persistence, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_ANDROID_device_anchor_persistence")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrResult value \"XR_ERROR_PERSISTED_DATA_NOT_READY_ANDROID\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_ANDROID_device_anchor_persistence\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_ERROR_FUTURE_PENDING_EXT:
            // Enum value XR_ERROR_FUTURE_PENDING_EXT requires extension XR_EXT_future, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_EXT_future")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrResult value \"XR_ERROR_FUTURE_PENDING_EXT\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_EXT_future\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_ERROR_FUTURE_INVALID_EXT:
            // Enum value XR_ERROR_FUTURE_INVALID_EXT requires extension XR_EXT_future, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_EXT_future")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrResult value \"XR_ERROR_FUTURE_INVALID_EXT\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_EXT_future\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_ERROR_SYSTEM_NOTIFICATION_PERMISSION_DENIED_ML:
            // Enum value XR_ERROR_SYSTEM_NOTIFICATION_PERMISSION_DENIED_ML requires extension XR_ML_system_notifications, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_ML_system_notifications")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrResult value \"XR_ERROR_SYSTEM_NOTIFICATION_PERMISSION_DENIED_ML\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_ML_system_notifications\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_ERROR_SYSTEM_NOTIFICATION_INCOMPATIBLE_SKU_ML:
            // Enum value XR_ERROR_SYSTEM_NOTIFICATION_INCOMPATIBLE_SKU_ML requires extension XR_ML_system_notifications, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_ML_system_notifications")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrResult value \"XR_ERROR_SYSTEM_NOTIFICATION_INCOMPATIBLE_SKU_ML\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_ML_system_notifications\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_ERROR_WORLD_MESH_DETECTOR_PERMISSION_DENIED_ML:
            // Enum value XR_ERROR_WORLD_MESH_DETECTOR_PERMISSION_DENIED_ML requires extension XR_ML_world_mesh_detection, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_ML_world_mesh_detection")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrResult value \"XR_ERROR_WORLD_MESH_DETECTOR_PERMISSION_DENIED_ML\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_ML_world_mesh_detection\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_ERROR_WORLD_MESH_DETECTOR_SPACE_NOT_LOCATABLE_ML:
            // Enum value XR_ERROR_WORLD_MESH_DETECTOR_SPACE_NOT_LOCATABLE_ML requires extension XR_ML_world_mesh_detection, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_ML_world_mesh_detection")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrResult value \"XR_ERROR_WORLD_MESH_DETECTOR_SPACE_NOT_LOCATABLE_ML\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_ML_world_mesh_detection\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_ERROR_FACIAL_EXPRESSION_PERMISSION_DENIED_ML:
            // Enum value XR_ERROR_FACIAL_EXPRESSION_PERMISSION_DENIED_ML requires extension XR_ML_facial_expression, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_ML_facial_expression")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrResult value \"XR_ERROR_FACIAL_EXPRESSION_PERMISSION_DENIED_ML\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_ML_facial_expression\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_ERROR_COLOCATION_DISCOVERY_NETWORK_FAILED_META:
            // Enum value XR_ERROR_COLOCATION_DISCOVERY_NETWORK_FAILED_META requires extension XR_META_colocation_discovery, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_META_colocation_discovery")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrResult value \"XR_ERROR_COLOCATION_DISCOVERY_NETWORK_FAILED_META\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_META_colocation_discovery\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_ERROR_COLOCATION_DISCOVERY_NO_DISCOVERY_METHOD_META:
            // Enum value XR_ERROR_COLOCATION_DISCOVERY_NO_DISCOVERY_METHOD_META requires extension XR_META_colocation_discovery, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_META_colocation_discovery")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrResult value \"XR_ERROR_COLOCATION_DISCOVERY_NO_DISCOVERY_METHOD_META\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_META_colocation_discovery\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_COLOCATION_DISCOVERY_ALREADY_ADVERTISING_META:
            // Enum value XR_COLOCATION_DISCOVERY_ALREADY_ADVERTISING_META requires extension XR_META_colocation_discovery, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_META_colocation_discovery")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrResult value \"XR_COLOCATION_DISCOVERY_ALREADY_ADVERTISING_META\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_META_colocation_discovery\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_COLOCATION_DISCOVERY_ALREADY_DISCOVERING_META:
            // Enum value XR_COLOCATION_DISCOVERY_ALREADY_DISCOVERING_META requires extension XR_META_colocation_discovery, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_META_colocation_discovery")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrResult value \"XR_COLOCATION_DISCOVERY_ALREADY_DISCOVERING_META\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_META_colocation_discovery\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_ERROR_SPACE_GROUP_NOT_FOUND_META:
            // Enum value XR_ERROR_SPACE_GROUP_NOT_FOUND_META requires extension XR_META_spatial_entity_group_sharing, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_META_spatial_entity_group_sharing")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrResult value \"XR_ERROR_SPACE_GROUP_NOT_FOUND_META\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_META_spatial_entity_group_sharing\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_ERROR_ANCHOR_NOT_OWNED_BY_CALLER_ANDROID:
            // Enum value XR_ERROR_ANCHOR_NOT_OWNED_BY_CALLER_ANDROID requires extension XR_ANDROID_anchor_sharing_export, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_ANDROID_anchor_sharing_export")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrResult value \"XR_ERROR_ANCHOR_NOT_OWNED_BY_CALLER_ANDROID\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_ANDROID_anchor_sharing_export\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_ERROR_SPATIAL_CAPABILITY_UNSUPPORTED_EXT:
            // Enum value XR_ERROR_SPATIAL_CAPABILITY_UNSUPPORTED_EXT requires extension XR_EXT_spatial_entity, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_EXT_spatial_entity")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrResult value \"XR_ERROR_SPATIAL_CAPABILITY_UNSUPPORTED_EXT\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_EXT_spatial_entity\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_ERROR_SPATIAL_ENTITY_ID_INVALID_EXT:
            // Enum value XR_ERROR_SPATIAL_ENTITY_ID_INVALID_EXT requires extension XR_EXT_spatial_entity, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_EXT_spatial_entity")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrResult value \"XR_ERROR_SPATIAL_ENTITY_ID_INVALID_EXT\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_EXT_spatial_entity\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_ERROR_SPATIAL_BUFFER_ID_INVALID_EXT:
            // Enum value XR_ERROR_SPATIAL_BUFFER_ID_INVALID_EXT requires extension XR_EXT_spatial_entity, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_EXT_spatial_entity")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrResult value \"XR_ERROR_SPATIAL_BUFFER_ID_INVALID_EXT\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_EXT_spatial_entity\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_ERROR_SPATIAL_COMPONENT_UNSUPPORTED_FOR_CAPABILITY_EXT:
            // Enum value XR_ERROR_SPATIAL_COMPONENT_UNSUPPORTED_FOR_CAPABILITY_EXT requires extension XR_EXT_spatial_entity, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_EXT_spatial_entity")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrResult value \"XR_ERROR_SPATIAL_COMPONENT_UNSUPPORTED_FOR_CAPABILITY_EXT\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_EXT_spatial_entity\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_ERROR_SPATIAL_CAPABILITY_CONFIGURATION_INVALID_EXT:
            // Enum value XR_ERROR_SPATIAL_CAPABILITY_CONFIGURATION_INVALID_EXT requires extension XR_EXT_spatial_entity, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_EXT_spatial_entity")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrResult value \"XR_ERROR_SPATIAL_CAPABILITY_CONFIGURATION_INVALID_EXT\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_EXT_spatial_entity\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_ERROR_SPATIAL_COMPONENT_NOT_ENABLED_EXT:
            // Enum value XR_ERROR_SPATIAL_COMPONENT_NOT_ENABLED_EXT requires extension XR_EXT_spatial_entity, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_EXT_spatial_entity")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrResult value \"XR_ERROR_SPATIAL_COMPONENT_NOT_ENABLED_EXT\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_EXT_spatial_entity\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_ERROR_SPATIAL_PERSISTENCE_SCOPE_UNSUPPORTED_EXT:
            // Enum value XR_ERROR_SPATIAL_PERSISTENCE_SCOPE_UNSUPPORTED_EXT requires extension XR_EXT_spatial_persistence, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_EXT_spatial_persistence")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrResult value \"XR_ERROR_SPATIAL_PERSISTENCE_SCOPE_UNSUPPORTED_EXT\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_EXT_spatial_persistence\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_ERROR_SPATIAL_PERSISTENCE_SCOPE_INCOMPATIBLE_EXT:
            // Enum value XR_ERROR_SPATIAL_PERSISTENCE_SCOPE_INCOMPATIBLE_EXT requires extension XR_EXT_spatial_persistence_operations, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_EXT_spatial_persistence_operations")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrResult value \"XR_ERROR_SPATIAL_PERSISTENCE_SCOPE_INCOMPATIBLE_EXT\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_EXT_spatial_persistence_operations\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
    default:
        return false;
}
}

// Function to validate XrStructureType enum
bool ValidateXrEnum(GenValidUsageXrInstanceInfo *instance_info,
                    const std::string &command_name,
                    const std::string &validation_name,
                    const std::string &item_name,
                    std::vector<GenValidUsageXrObjectInfo>& objects_info,
                    const XrStructureType value) {
    (void)instance_info;  // quiet warnings
    (void)command_name;  // quiet warnings
    (void)validation_name;  // quiet warnings
    (void)item_name;  // quiet warnings
    (void)objects_info;  // quiet warnings
    switch (value) {
        case XR_TYPE_UNKNOWN:
            return false; // Invalid XrStructureType 
        case XR_TYPE_API_LAYER_PROPERTIES:
            return true;
        case XR_TYPE_EXTENSION_PROPERTIES:
            return true;
        case XR_TYPE_INSTANCE_CREATE_INFO:
            return true;
        case XR_TYPE_SYSTEM_GET_INFO:
            return true;
        case XR_TYPE_SYSTEM_PROPERTIES:
            return true;
        case XR_TYPE_VIEW_LOCATE_INFO:
            return true;
        case XR_TYPE_VIEW:
            return true;
        case XR_TYPE_SESSION_CREATE_INFO:
            return true;
        case XR_TYPE_SWAPCHAIN_CREATE_INFO:
            return true;
        case XR_TYPE_SESSION_BEGIN_INFO:
            return true;
        case XR_TYPE_VIEW_STATE:
            return true;
        case XR_TYPE_FRAME_END_INFO:
            return true;
        case XR_TYPE_HAPTIC_VIBRATION:
            return true;
        case XR_TYPE_EVENT_DATA_BUFFER:
            return true;
        case XR_TYPE_EVENT_DATA_INSTANCE_LOSS_PENDING:
            return true;
        case XR_TYPE_EVENT_DATA_SESSION_STATE_CHANGED:
            return true;
        case XR_TYPE_ACTION_STATE_BOOLEAN:
            return true;
        case XR_TYPE_ACTION_STATE_FLOAT:
            return true;
        case XR_TYPE_ACTION_STATE_VECTOR2F:
            return true;
        case XR_TYPE_ACTION_STATE_POSE:
            return true;
        case XR_TYPE_ACTION_SET_CREATE_INFO:
            return true;
        case XR_TYPE_ACTION_CREATE_INFO:
            return true;
        case XR_TYPE_INSTANCE_PROPERTIES:
            return true;
        case XR_TYPE_FRAME_WAIT_INFO:
            return true;
        case XR_TYPE_COMPOSITION_LAYER_PROJECTION:
            return true;
        case XR_TYPE_COMPOSITION_LAYER_QUAD:
            return true;
        case XR_TYPE_REFERENCE_SPACE_CREATE_INFO:
            return true;
        case XR_TYPE_ACTION_SPACE_CREATE_INFO:
            return true;
        case XR_TYPE_EVENT_DATA_REFERENCE_SPACE_CHANGE_PENDING:
            return true;
        case XR_TYPE_VIEW_CONFIGURATION_VIEW:
            return true;
        case XR_TYPE_SPACE_LOCATION:
            return true;
        case XR_TYPE_SPACE_VELOCITY:
            return true;
        case XR_TYPE_FRAME_STATE:
            return true;
        case XR_TYPE_VIEW_CONFIGURATION_PROPERTIES:
            return true;
        case XR_TYPE_FRAME_BEGIN_INFO:
            return true;
        case XR_TYPE_COMPOSITION_LAYER_PROJECTION_VIEW:
            return true;
        case XR_TYPE_EVENT_DATA_EVENTS_LOST:
            return true;
        case XR_TYPE_INTERACTION_PROFILE_SUGGESTED_BINDING:
            return true;
        case XR_TYPE_EVENT_DATA_INTERACTION_PROFILE_CHANGED:
            return true;
        case XR_TYPE_INTERACTION_PROFILE_STATE:
            return true;
        case XR_TYPE_SWAPCHAIN_IMAGE_ACQUIRE_INFO:
            return true;
        case XR_TYPE_SWAPCHAIN_IMAGE_WAIT_INFO:
            return true;
        case XR_TYPE_SWAPCHAIN_IMAGE_RELEASE_INFO:
            return true;
        case XR_TYPE_ACTION_STATE_GET_INFO:
            return true;
        case XR_TYPE_HAPTIC_ACTION_INFO:
            return true;
        case XR_TYPE_SESSION_ACTION_SETS_ATTACH_INFO:
            return true;
        case XR_TYPE_ACTIONS_SYNC_INFO:
            return true;
        case XR_TYPE_BOUND_SOURCES_FOR_ACTION_ENUMERATE_INFO:
            return true;
        case XR_TYPE_INPUT_SOURCE_LOCALIZED_NAME_GET_INFO:
            return true;
        case XR_TYPE_SPACES_LOCATE_INFO:
            return true;
        case XR_TYPE_SPACE_LOCATIONS:
            return true;
        case XR_TYPE_SPACE_VELOCITIES:
            return true;
        case XR_TYPE_COMPOSITION_LAYER_CUBE_KHR:
            // Enum value XR_TYPE_COMPOSITION_LAYER_CUBE_KHR requires extension XR_KHR_composition_layer_cube, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_KHR_composition_layer_cube")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_COMPOSITION_LAYER_CUBE_KHR\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_KHR_composition_layer_cube\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_INSTANCE_CREATE_INFO_ANDROID_KHR:
            // Enum value XR_TYPE_INSTANCE_CREATE_INFO_ANDROID_KHR requires extension XR_KHR_android_create_instance, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_KHR_android_create_instance")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_INSTANCE_CREATE_INFO_ANDROID_KHR\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_KHR_android_create_instance\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_COMPOSITION_LAYER_DEPTH_INFO_KHR:
            // Enum value XR_TYPE_COMPOSITION_LAYER_DEPTH_INFO_KHR requires extension XR_KHR_composition_layer_depth, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_KHR_composition_layer_depth")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_COMPOSITION_LAYER_DEPTH_INFO_KHR\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_KHR_composition_layer_depth\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_VULKAN_SWAPCHAIN_FORMAT_LIST_CREATE_INFO_KHR:
            // Enum value XR_TYPE_VULKAN_SWAPCHAIN_FORMAT_LIST_CREATE_INFO_KHR requires extension XR_KHR_vulkan_swapchain_format_list, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_KHR_vulkan_swapchain_format_list")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_VULKAN_SWAPCHAIN_FORMAT_LIST_CREATE_INFO_KHR\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_KHR_vulkan_swapchain_format_list\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_EVENT_DATA_PERF_SETTINGS_EXT:
            // Enum value XR_TYPE_EVENT_DATA_PERF_SETTINGS_EXT requires extension XR_EXT_performance_settings, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_EXT_performance_settings")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_EVENT_DATA_PERF_SETTINGS_EXT\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_EXT_performance_settings\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_COMPOSITION_LAYER_CYLINDER_KHR:
            // Enum value XR_TYPE_COMPOSITION_LAYER_CYLINDER_KHR requires extension XR_KHR_composition_layer_cylinder, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_KHR_composition_layer_cylinder")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_COMPOSITION_LAYER_CYLINDER_KHR\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_KHR_composition_layer_cylinder\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_COMPOSITION_LAYER_EQUIRECT_KHR:
            // Enum value XR_TYPE_COMPOSITION_LAYER_EQUIRECT_KHR requires extension XR_KHR_composition_layer_equirect, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_KHR_composition_layer_equirect")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_COMPOSITION_LAYER_EQUIRECT_KHR\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_KHR_composition_layer_equirect\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_DEBUG_UTILS_OBJECT_NAME_INFO_EXT:
            // Enum value XR_TYPE_DEBUG_UTILS_OBJECT_NAME_INFO_EXT requires extension XR_EXT_debug_utils, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_EXT_debug_utils")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_DEBUG_UTILS_OBJECT_NAME_INFO_EXT\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_EXT_debug_utils\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_DEBUG_UTILS_MESSENGER_CALLBACK_DATA_EXT:
            // Enum value XR_TYPE_DEBUG_UTILS_MESSENGER_CALLBACK_DATA_EXT requires extension XR_EXT_debug_utils, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_EXT_debug_utils")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_DEBUG_UTILS_MESSENGER_CALLBACK_DATA_EXT\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_EXT_debug_utils\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_DEBUG_UTILS_MESSENGER_CREATE_INFO_EXT:
            // Enum value XR_TYPE_DEBUG_UTILS_MESSENGER_CREATE_INFO_EXT requires extension XR_EXT_debug_utils, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_EXT_debug_utils")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_DEBUG_UTILS_MESSENGER_CREATE_INFO_EXT\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_EXT_debug_utils\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_DEBUG_UTILS_LABEL_EXT:
            // Enum value XR_TYPE_DEBUG_UTILS_LABEL_EXT requires extension XR_EXT_debug_utils, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_EXT_debug_utils")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_DEBUG_UTILS_LABEL_EXT\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_EXT_debug_utils\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_GRAPHICS_BINDING_OPENGL_WIN32_KHR:
            // Enum value XR_TYPE_GRAPHICS_BINDING_OPENGL_WIN32_KHR requires extension XR_KHR_opengl_enable, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_KHR_opengl_enable")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_GRAPHICS_BINDING_OPENGL_WIN32_KHR\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_KHR_opengl_enable\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_GRAPHICS_BINDING_OPENGL_XLIB_KHR:
            // Enum value XR_TYPE_GRAPHICS_BINDING_OPENGL_XLIB_KHR requires extension XR_KHR_opengl_enable, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_KHR_opengl_enable")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_GRAPHICS_BINDING_OPENGL_XLIB_KHR\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_KHR_opengl_enable\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_GRAPHICS_BINDING_OPENGL_XCB_KHR:
            // Enum value XR_TYPE_GRAPHICS_BINDING_OPENGL_XCB_KHR requires extension XR_KHR_opengl_enable, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_KHR_opengl_enable")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_GRAPHICS_BINDING_OPENGL_XCB_KHR\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_KHR_opengl_enable\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_GRAPHICS_BINDING_OPENGL_WAYLAND_KHR:
            // Enum value XR_TYPE_GRAPHICS_BINDING_OPENGL_WAYLAND_KHR requires extension XR_KHR_opengl_enable, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_KHR_opengl_enable")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_GRAPHICS_BINDING_OPENGL_WAYLAND_KHR\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_KHR_opengl_enable\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_SWAPCHAIN_IMAGE_OPENGL_KHR:
            // Enum value XR_TYPE_SWAPCHAIN_IMAGE_OPENGL_KHR requires extension XR_KHR_opengl_enable, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_KHR_opengl_enable")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_SWAPCHAIN_IMAGE_OPENGL_KHR\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_KHR_opengl_enable\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_GRAPHICS_REQUIREMENTS_OPENGL_KHR:
            // Enum value XR_TYPE_GRAPHICS_REQUIREMENTS_OPENGL_KHR requires extension XR_KHR_opengl_enable, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_KHR_opengl_enable")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_GRAPHICS_REQUIREMENTS_OPENGL_KHR\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_KHR_opengl_enable\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_GRAPHICS_BINDING_OPENGL_ES_ANDROID_KHR:
            // Enum value XR_TYPE_GRAPHICS_BINDING_OPENGL_ES_ANDROID_KHR requires extension XR_KHR_opengl_es_enable, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_KHR_opengl_es_enable")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_GRAPHICS_BINDING_OPENGL_ES_ANDROID_KHR\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_KHR_opengl_es_enable\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_SWAPCHAIN_IMAGE_OPENGL_ES_KHR:
            // Enum value XR_TYPE_SWAPCHAIN_IMAGE_OPENGL_ES_KHR requires extension XR_KHR_opengl_es_enable, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_KHR_opengl_es_enable")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_SWAPCHAIN_IMAGE_OPENGL_ES_KHR\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_KHR_opengl_es_enable\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_GRAPHICS_REQUIREMENTS_OPENGL_ES_KHR:
            // Enum value XR_TYPE_GRAPHICS_REQUIREMENTS_OPENGL_ES_KHR requires extension XR_KHR_opengl_es_enable, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_KHR_opengl_es_enable")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_GRAPHICS_REQUIREMENTS_OPENGL_ES_KHR\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_KHR_opengl_es_enable\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_GRAPHICS_BINDING_VULKAN_KHR:
            // Enum value XR_TYPE_GRAPHICS_BINDING_VULKAN_KHR requires extension XR_KHR_vulkan_enable, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_KHR_vulkan_enable")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_GRAPHICS_BINDING_VULKAN_KHR\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_KHR_vulkan_enable\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_SWAPCHAIN_IMAGE_VULKAN_KHR:
            // Enum value XR_TYPE_SWAPCHAIN_IMAGE_VULKAN_KHR requires extension XR_KHR_vulkan_enable, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_KHR_vulkan_enable")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_SWAPCHAIN_IMAGE_VULKAN_KHR\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_KHR_vulkan_enable\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_GRAPHICS_REQUIREMENTS_VULKAN_KHR:
            // Enum value XR_TYPE_GRAPHICS_REQUIREMENTS_VULKAN_KHR requires extension XR_KHR_vulkan_enable, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_KHR_vulkan_enable")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_GRAPHICS_REQUIREMENTS_VULKAN_KHR\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_KHR_vulkan_enable\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_GRAPHICS_BINDING_D3D11_KHR:
            // Enum value XR_TYPE_GRAPHICS_BINDING_D3D11_KHR requires extension XR_KHR_D3D11_enable, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_KHR_D3D11_enable")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_GRAPHICS_BINDING_D3D11_KHR\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_KHR_D3D11_enable\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_SWAPCHAIN_IMAGE_D3D11_KHR:
            // Enum value XR_TYPE_SWAPCHAIN_IMAGE_D3D11_KHR requires extension XR_KHR_D3D11_enable, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_KHR_D3D11_enable")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_SWAPCHAIN_IMAGE_D3D11_KHR\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_KHR_D3D11_enable\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_GRAPHICS_REQUIREMENTS_D3D11_KHR:
            // Enum value XR_TYPE_GRAPHICS_REQUIREMENTS_D3D11_KHR requires extension XR_KHR_D3D11_enable, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_KHR_D3D11_enable")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_GRAPHICS_REQUIREMENTS_D3D11_KHR\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_KHR_D3D11_enable\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_GRAPHICS_BINDING_D3D12_KHR:
            // Enum value XR_TYPE_GRAPHICS_BINDING_D3D12_KHR requires extension XR_KHR_D3D12_enable, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_KHR_D3D12_enable")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_GRAPHICS_BINDING_D3D12_KHR\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_KHR_D3D12_enable\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_SWAPCHAIN_IMAGE_D3D12_KHR:
            // Enum value XR_TYPE_SWAPCHAIN_IMAGE_D3D12_KHR requires extension XR_KHR_D3D12_enable, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_KHR_D3D12_enable")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_SWAPCHAIN_IMAGE_D3D12_KHR\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_KHR_D3D12_enable\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_GRAPHICS_REQUIREMENTS_D3D12_KHR:
            // Enum value XR_TYPE_GRAPHICS_REQUIREMENTS_D3D12_KHR requires extension XR_KHR_D3D12_enable, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_KHR_D3D12_enable")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_GRAPHICS_REQUIREMENTS_D3D12_KHR\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_KHR_D3D12_enable\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_GRAPHICS_BINDING_METAL_KHR:
            // Enum value XR_TYPE_GRAPHICS_BINDING_METAL_KHR requires extension XR_KHR_metal_enable, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_KHR_metal_enable")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_GRAPHICS_BINDING_METAL_KHR\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_KHR_metal_enable\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_SWAPCHAIN_IMAGE_METAL_KHR:
            // Enum value XR_TYPE_SWAPCHAIN_IMAGE_METAL_KHR requires extension XR_KHR_metal_enable, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_KHR_metal_enable")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_SWAPCHAIN_IMAGE_METAL_KHR\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_KHR_metal_enable\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_GRAPHICS_REQUIREMENTS_METAL_KHR:
            // Enum value XR_TYPE_GRAPHICS_REQUIREMENTS_METAL_KHR requires extension XR_KHR_metal_enable, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_KHR_metal_enable")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_GRAPHICS_REQUIREMENTS_METAL_KHR\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_KHR_metal_enable\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_SYSTEM_EYE_GAZE_INTERACTION_PROPERTIES_EXT:
            // Enum value XR_TYPE_SYSTEM_EYE_GAZE_INTERACTION_PROPERTIES_EXT requires extension XR_EXT_eye_gaze_interaction, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_EXT_eye_gaze_interaction")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_SYSTEM_EYE_GAZE_INTERACTION_PROPERTIES_EXT\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_EXT_eye_gaze_interaction\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_EYE_GAZE_SAMPLE_TIME_EXT:
            // Enum value XR_TYPE_EYE_GAZE_SAMPLE_TIME_EXT requires extension XR_EXT_eye_gaze_interaction, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_EXT_eye_gaze_interaction")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_EYE_GAZE_SAMPLE_TIME_EXT\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_EXT_eye_gaze_interaction\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_VISIBILITY_MASK_KHR:
            // Enum value XR_TYPE_VISIBILITY_MASK_KHR requires extension XR_KHR_visibility_mask, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_KHR_visibility_mask")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_VISIBILITY_MASK_KHR\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_KHR_visibility_mask\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_EVENT_DATA_VISIBILITY_MASK_CHANGED_KHR:
            // Enum value XR_TYPE_EVENT_DATA_VISIBILITY_MASK_CHANGED_KHR requires extension XR_KHR_visibility_mask, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_KHR_visibility_mask")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_EVENT_DATA_VISIBILITY_MASK_CHANGED_KHR\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_KHR_visibility_mask\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_SESSION_CREATE_INFO_OVERLAY_EXTX:
            // Enum value XR_TYPE_SESSION_CREATE_INFO_OVERLAY_EXTX requires extension XR_EXTX_overlay, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_EXTX_overlay")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_SESSION_CREATE_INFO_OVERLAY_EXTX\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_EXTX_overlay\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_EVENT_DATA_MAIN_SESSION_VISIBILITY_CHANGED_EXTX:
            // Enum value XR_TYPE_EVENT_DATA_MAIN_SESSION_VISIBILITY_CHANGED_EXTX requires extension XR_EXTX_overlay, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_EXTX_overlay")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_EVENT_DATA_MAIN_SESSION_VISIBILITY_CHANGED_EXTX\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_EXTX_overlay\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_COMPOSITION_LAYER_COLOR_SCALE_BIAS_KHR:
            // Enum value XR_TYPE_COMPOSITION_LAYER_COLOR_SCALE_BIAS_KHR requires extension XR_KHR_composition_layer_color_scale_bias, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_KHR_composition_layer_color_scale_bias")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_COMPOSITION_LAYER_COLOR_SCALE_BIAS_KHR\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_KHR_composition_layer_color_scale_bias\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_SPATIAL_ANCHOR_CREATE_INFO_MSFT:
            // Enum value XR_TYPE_SPATIAL_ANCHOR_CREATE_INFO_MSFT requires extension XR_MSFT_spatial_anchor, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_MSFT_spatial_anchor")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_SPATIAL_ANCHOR_CREATE_INFO_MSFT\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_MSFT_spatial_anchor\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_SPATIAL_ANCHOR_SPACE_CREATE_INFO_MSFT:
            // Enum value XR_TYPE_SPATIAL_ANCHOR_SPACE_CREATE_INFO_MSFT requires extension XR_MSFT_spatial_anchor, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_MSFT_spatial_anchor")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_SPATIAL_ANCHOR_SPACE_CREATE_INFO_MSFT\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_MSFT_spatial_anchor\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_COMPOSITION_LAYER_IMAGE_LAYOUT_FB:
            // Enum value XR_TYPE_COMPOSITION_LAYER_IMAGE_LAYOUT_FB requires extension XR_FB_composition_layer_image_layout, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_FB_composition_layer_image_layout")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_COMPOSITION_LAYER_IMAGE_LAYOUT_FB\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_FB_composition_layer_image_layout\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_COMPOSITION_LAYER_ALPHA_BLEND_FB:
            // Enum value XR_TYPE_COMPOSITION_LAYER_ALPHA_BLEND_FB requires extension XR_FB_composition_layer_alpha_blend, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_FB_composition_layer_alpha_blend")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_COMPOSITION_LAYER_ALPHA_BLEND_FB\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_FB_composition_layer_alpha_blend\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_VIEW_CONFIGURATION_DEPTH_RANGE_EXT:
            // Enum value XR_TYPE_VIEW_CONFIGURATION_DEPTH_RANGE_EXT requires extension XR_EXT_view_configuration_depth_range, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_EXT_view_configuration_depth_range")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_VIEW_CONFIGURATION_DEPTH_RANGE_EXT\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_EXT_view_configuration_depth_range\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_GRAPHICS_BINDING_EGL_MNDX:
            // Enum value XR_TYPE_GRAPHICS_BINDING_EGL_MNDX requires extension XR_MNDX_egl_enable, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_MNDX_egl_enable")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_GRAPHICS_BINDING_EGL_MNDX\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_MNDX_egl_enable\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_SPATIAL_GRAPH_NODE_SPACE_CREATE_INFO_MSFT:
            // Enum value XR_TYPE_SPATIAL_GRAPH_NODE_SPACE_CREATE_INFO_MSFT requires extension XR_MSFT_spatial_graph_bridge, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_MSFT_spatial_graph_bridge")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_SPATIAL_GRAPH_NODE_SPACE_CREATE_INFO_MSFT\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_MSFT_spatial_graph_bridge\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_SPATIAL_GRAPH_STATIC_NODE_BINDING_CREATE_INFO_MSFT:
            // Enum value XR_TYPE_SPATIAL_GRAPH_STATIC_NODE_BINDING_CREATE_INFO_MSFT requires extension XR_MSFT_spatial_graph_bridge, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_MSFT_spatial_graph_bridge")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_SPATIAL_GRAPH_STATIC_NODE_BINDING_CREATE_INFO_MSFT\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_MSFT_spatial_graph_bridge\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_SPATIAL_GRAPH_NODE_BINDING_PROPERTIES_GET_INFO_MSFT:
            // Enum value XR_TYPE_SPATIAL_GRAPH_NODE_BINDING_PROPERTIES_GET_INFO_MSFT requires extension XR_MSFT_spatial_graph_bridge, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_MSFT_spatial_graph_bridge")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_SPATIAL_GRAPH_NODE_BINDING_PROPERTIES_GET_INFO_MSFT\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_MSFT_spatial_graph_bridge\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_SPATIAL_GRAPH_NODE_BINDING_PROPERTIES_MSFT:
            // Enum value XR_TYPE_SPATIAL_GRAPH_NODE_BINDING_PROPERTIES_MSFT requires extension XR_MSFT_spatial_graph_bridge, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_MSFT_spatial_graph_bridge")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_SPATIAL_GRAPH_NODE_BINDING_PROPERTIES_MSFT\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_MSFT_spatial_graph_bridge\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_SYSTEM_HAND_TRACKING_PROPERTIES_EXT:
            // Enum value XR_TYPE_SYSTEM_HAND_TRACKING_PROPERTIES_EXT requires extension XR_EXT_hand_tracking, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_EXT_hand_tracking")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_SYSTEM_HAND_TRACKING_PROPERTIES_EXT\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_EXT_hand_tracking\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_HAND_TRACKER_CREATE_INFO_EXT:
            // Enum value XR_TYPE_HAND_TRACKER_CREATE_INFO_EXT requires extension XR_EXT_hand_tracking, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_EXT_hand_tracking")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_HAND_TRACKER_CREATE_INFO_EXT\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_EXT_hand_tracking\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_HAND_JOINTS_LOCATE_INFO_EXT:
            // Enum value XR_TYPE_HAND_JOINTS_LOCATE_INFO_EXT requires extension XR_EXT_hand_tracking, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_EXT_hand_tracking")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_HAND_JOINTS_LOCATE_INFO_EXT\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_EXT_hand_tracking\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_HAND_JOINT_LOCATIONS_EXT:
            // Enum value XR_TYPE_HAND_JOINT_LOCATIONS_EXT requires extension XR_EXT_hand_tracking, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_EXT_hand_tracking")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_HAND_JOINT_LOCATIONS_EXT\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_EXT_hand_tracking\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_HAND_JOINT_VELOCITIES_EXT:
            // Enum value XR_TYPE_HAND_JOINT_VELOCITIES_EXT requires extension XR_EXT_hand_tracking, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_EXT_hand_tracking")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_HAND_JOINT_VELOCITIES_EXT\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_EXT_hand_tracking\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_SYSTEM_HAND_TRACKING_MESH_PROPERTIES_MSFT:
            // Enum value XR_TYPE_SYSTEM_HAND_TRACKING_MESH_PROPERTIES_MSFT requires extension XR_MSFT_hand_tracking_mesh, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_MSFT_hand_tracking_mesh")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_SYSTEM_HAND_TRACKING_MESH_PROPERTIES_MSFT\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_MSFT_hand_tracking_mesh\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_HAND_MESH_SPACE_CREATE_INFO_MSFT:
            // Enum value XR_TYPE_HAND_MESH_SPACE_CREATE_INFO_MSFT requires extension XR_MSFT_hand_tracking_mesh, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_MSFT_hand_tracking_mesh")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_HAND_MESH_SPACE_CREATE_INFO_MSFT\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_MSFT_hand_tracking_mesh\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_HAND_MESH_UPDATE_INFO_MSFT:
            // Enum value XR_TYPE_HAND_MESH_UPDATE_INFO_MSFT requires extension XR_MSFT_hand_tracking_mesh, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_MSFT_hand_tracking_mesh")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_HAND_MESH_UPDATE_INFO_MSFT\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_MSFT_hand_tracking_mesh\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_HAND_MESH_MSFT:
            // Enum value XR_TYPE_HAND_MESH_MSFT requires extension XR_MSFT_hand_tracking_mesh, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_MSFT_hand_tracking_mesh")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_HAND_MESH_MSFT\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_MSFT_hand_tracking_mesh\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_HAND_POSE_TYPE_INFO_MSFT:
            // Enum value XR_TYPE_HAND_POSE_TYPE_INFO_MSFT requires extension XR_MSFT_hand_tracking_mesh, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_MSFT_hand_tracking_mesh")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_HAND_POSE_TYPE_INFO_MSFT\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_MSFT_hand_tracking_mesh\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_SECONDARY_VIEW_CONFIGURATION_SESSION_BEGIN_INFO_MSFT:
            // Enum value XR_TYPE_SECONDARY_VIEW_CONFIGURATION_SESSION_BEGIN_INFO_MSFT requires extension XR_MSFT_secondary_view_configuration, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_MSFT_secondary_view_configuration")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_SECONDARY_VIEW_CONFIGURATION_SESSION_BEGIN_INFO_MSFT\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_MSFT_secondary_view_configuration\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_SECONDARY_VIEW_CONFIGURATION_STATE_MSFT:
            // Enum value XR_TYPE_SECONDARY_VIEW_CONFIGURATION_STATE_MSFT requires extension XR_MSFT_secondary_view_configuration, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_MSFT_secondary_view_configuration")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_SECONDARY_VIEW_CONFIGURATION_STATE_MSFT\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_MSFT_secondary_view_configuration\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_SECONDARY_VIEW_CONFIGURATION_FRAME_STATE_MSFT:
            // Enum value XR_TYPE_SECONDARY_VIEW_CONFIGURATION_FRAME_STATE_MSFT requires extension XR_MSFT_secondary_view_configuration, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_MSFT_secondary_view_configuration")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_SECONDARY_VIEW_CONFIGURATION_FRAME_STATE_MSFT\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_MSFT_secondary_view_configuration\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_SECONDARY_VIEW_CONFIGURATION_FRAME_END_INFO_MSFT:
            // Enum value XR_TYPE_SECONDARY_VIEW_CONFIGURATION_FRAME_END_INFO_MSFT requires extension XR_MSFT_secondary_view_configuration, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_MSFT_secondary_view_configuration")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_SECONDARY_VIEW_CONFIGURATION_FRAME_END_INFO_MSFT\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_MSFT_secondary_view_configuration\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_SECONDARY_VIEW_CONFIGURATION_LAYER_INFO_MSFT:
            // Enum value XR_TYPE_SECONDARY_VIEW_CONFIGURATION_LAYER_INFO_MSFT requires extension XR_MSFT_secondary_view_configuration, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_MSFT_secondary_view_configuration")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_SECONDARY_VIEW_CONFIGURATION_LAYER_INFO_MSFT\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_MSFT_secondary_view_configuration\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_SECONDARY_VIEW_CONFIGURATION_SWAPCHAIN_CREATE_INFO_MSFT:
            // Enum value XR_TYPE_SECONDARY_VIEW_CONFIGURATION_SWAPCHAIN_CREATE_INFO_MSFT requires extension XR_MSFT_secondary_view_configuration, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_MSFT_secondary_view_configuration")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_SECONDARY_VIEW_CONFIGURATION_SWAPCHAIN_CREATE_INFO_MSFT\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_MSFT_secondary_view_configuration\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_CONTROLLER_MODEL_KEY_STATE_MSFT:
            // Enum value XR_TYPE_CONTROLLER_MODEL_KEY_STATE_MSFT requires extension XR_MSFT_controller_model, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_MSFT_controller_model")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_CONTROLLER_MODEL_KEY_STATE_MSFT\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_MSFT_controller_model\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_CONTROLLER_MODEL_NODE_PROPERTIES_MSFT:
            // Enum value XR_TYPE_CONTROLLER_MODEL_NODE_PROPERTIES_MSFT requires extension XR_MSFT_controller_model, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_MSFT_controller_model")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_CONTROLLER_MODEL_NODE_PROPERTIES_MSFT\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_MSFT_controller_model\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_CONTROLLER_MODEL_PROPERTIES_MSFT:
            // Enum value XR_TYPE_CONTROLLER_MODEL_PROPERTIES_MSFT requires extension XR_MSFT_controller_model, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_MSFT_controller_model")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_CONTROLLER_MODEL_PROPERTIES_MSFT\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_MSFT_controller_model\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_CONTROLLER_MODEL_NODE_STATE_MSFT:
            // Enum value XR_TYPE_CONTROLLER_MODEL_NODE_STATE_MSFT requires extension XR_MSFT_controller_model, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_MSFT_controller_model")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_CONTROLLER_MODEL_NODE_STATE_MSFT\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_MSFT_controller_model\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_CONTROLLER_MODEL_STATE_MSFT:
            // Enum value XR_TYPE_CONTROLLER_MODEL_STATE_MSFT requires extension XR_MSFT_controller_model, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_MSFT_controller_model")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_CONTROLLER_MODEL_STATE_MSFT\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_MSFT_controller_model\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_VIEW_CONFIGURATION_VIEW_FOV_EPIC:
            // Enum value XR_TYPE_VIEW_CONFIGURATION_VIEW_FOV_EPIC requires extension XR_EPIC_view_configuration_fov, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_EPIC_view_configuration_fov")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_VIEW_CONFIGURATION_VIEW_FOV_EPIC\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_EPIC_view_configuration_fov\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_HOLOGRAPHIC_WINDOW_ATTACHMENT_MSFT:
            // Enum value XR_TYPE_HOLOGRAPHIC_WINDOW_ATTACHMENT_MSFT requires extension XR_MSFT_holographic_window_attachment, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_MSFT_holographic_window_attachment")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_HOLOGRAPHIC_WINDOW_ATTACHMENT_MSFT\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_MSFT_holographic_window_attachment\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_COMPOSITION_LAYER_REPROJECTION_INFO_MSFT:
            // Enum value XR_TYPE_COMPOSITION_LAYER_REPROJECTION_INFO_MSFT requires extension XR_MSFT_composition_layer_reprojection, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_MSFT_composition_layer_reprojection")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_COMPOSITION_LAYER_REPROJECTION_INFO_MSFT\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_MSFT_composition_layer_reprojection\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_COMPOSITION_LAYER_REPROJECTION_PLANE_OVERRIDE_MSFT:
            // Enum value XR_TYPE_COMPOSITION_LAYER_REPROJECTION_PLANE_OVERRIDE_MSFT requires extension XR_MSFT_composition_layer_reprojection, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_MSFT_composition_layer_reprojection")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_COMPOSITION_LAYER_REPROJECTION_PLANE_OVERRIDE_MSFT\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_MSFT_composition_layer_reprojection\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_ANDROID_SURFACE_SWAPCHAIN_CREATE_INFO_FB:
            // Enum value XR_TYPE_ANDROID_SURFACE_SWAPCHAIN_CREATE_INFO_FB requires extension XR_FB_android_surface_swapchain_create, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_FB_android_surface_swapchain_create")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_ANDROID_SURFACE_SWAPCHAIN_CREATE_INFO_FB\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_FB_android_surface_swapchain_create\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_COMPOSITION_LAYER_SECURE_CONTENT_FB:
            // Enum value XR_TYPE_COMPOSITION_LAYER_SECURE_CONTENT_FB requires extension XR_FB_composition_layer_secure_content, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_FB_composition_layer_secure_content")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_COMPOSITION_LAYER_SECURE_CONTENT_FB\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_FB_composition_layer_secure_content\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_BODY_TRACKER_CREATE_INFO_FB:
            // Enum value XR_TYPE_BODY_TRACKER_CREATE_INFO_FB requires extension XR_FB_body_tracking, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_FB_body_tracking")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_BODY_TRACKER_CREATE_INFO_FB\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_FB_body_tracking\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_BODY_JOINTS_LOCATE_INFO_FB:
            // Enum value XR_TYPE_BODY_JOINTS_LOCATE_INFO_FB requires extension XR_FB_body_tracking, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_FB_body_tracking")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_BODY_JOINTS_LOCATE_INFO_FB\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_FB_body_tracking\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_SYSTEM_BODY_TRACKING_PROPERTIES_FB:
            // Enum value XR_TYPE_SYSTEM_BODY_TRACKING_PROPERTIES_FB requires extension XR_FB_body_tracking, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_FB_body_tracking")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_SYSTEM_BODY_TRACKING_PROPERTIES_FB\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_FB_body_tracking\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_BODY_JOINT_LOCATIONS_FB:
            // Enum value XR_TYPE_BODY_JOINT_LOCATIONS_FB requires extension XR_FB_body_tracking, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_FB_body_tracking")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_BODY_JOINT_LOCATIONS_FB\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_FB_body_tracking\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_BODY_SKELETON_FB:
            // Enum value XR_TYPE_BODY_SKELETON_FB requires extension XR_FB_body_tracking, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_FB_body_tracking")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_BODY_SKELETON_FB\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_FB_body_tracking\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_INTERACTION_PROFILE_DPAD_BINDING_EXT:
            // Enum value XR_TYPE_INTERACTION_PROFILE_DPAD_BINDING_EXT requires extension XR_EXT_dpad_binding, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_EXT_dpad_binding")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_INTERACTION_PROFILE_DPAD_BINDING_EXT\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_EXT_dpad_binding\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_INTERACTION_PROFILE_ANALOG_THRESHOLD_VALVE:
            // Enum value XR_TYPE_INTERACTION_PROFILE_ANALOG_THRESHOLD_VALVE requires extension XR_VALVE_analog_threshold, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_VALVE_analog_threshold")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_INTERACTION_PROFILE_ANALOG_THRESHOLD_VALVE\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_VALVE_analog_threshold\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_HAND_JOINTS_MOTION_RANGE_INFO_EXT:
            // Enum value XR_TYPE_HAND_JOINTS_MOTION_RANGE_INFO_EXT requires extension XR_EXT_hand_joints_motion_range, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_EXT_hand_joints_motion_range")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_HAND_JOINTS_MOTION_RANGE_INFO_EXT\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_EXT_hand_joints_motion_range\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_LOADER_INIT_INFO_ANDROID_KHR:
            // Enum value XR_TYPE_LOADER_INIT_INFO_ANDROID_KHR requires extension XR_KHR_loader_init_android, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_KHR_loader_init_android")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_LOADER_INIT_INFO_ANDROID_KHR\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_KHR_loader_init_android\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_VULKAN_INSTANCE_CREATE_INFO_KHR:
            // Enum value XR_TYPE_VULKAN_INSTANCE_CREATE_INFO_KHR requires extension XR_KHR_vulkan_enable2, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_KHR_vulkan_enable2")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_VULKAN_INSTANCE_CREATE_INFO_KHR\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_KHR_vulkan_enable2\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_VULKAN_DEVICE_CREATE_INFO_KHR:
            // Enum value XR_TYPE_VULKAN_DEVICE_CREATE_INFO_KHR requires extension XR_KHR_vulkan_enable2, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_KHR_vulkan_enable2")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_VULKAN_DEVICE_CREATE_INFO_KHR\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_KHR_vulkan_enable2\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_VULKAN_GRAPHICS_DEVICE_GET_INFO_KHR:
            // Enum value XR_TYPE_VULKAN_GRAPHICS_DEVICE_GET_INFO_KHR requires extension XR_KHR_vulkan_enable2, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_KHR_vulkan_enable2")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_VULKAN_GRAPHICS_DEVICE_GET_INFO_KHR\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_KHR_vulkan_enable2\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_COMPOSITION_LAYER_EQUIRECT2_KHR:
            // Enum value XR_TYPE_COMPOSITION_LAYER_EQUIRECT2_KHR requires extension XR_KHR_composition_layer_equirect2, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_KHR_composition_layer_equirect2")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_COMPOSITION_LAYER_EQUIRECT2_KHR\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_KHR_composition_layer_equirect2\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_SCENE_OBSERVER_CREATE_INFO_MSFT:
            // Enum value XR_TYPE_SCENE_OBSERVER_CREATE_INFO_MSFT requires extension XR_MSFT_scene_understanding, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_MSFT_scene_understanding")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_SCENE_OBSERVER_CREATE_INFO_MSFT\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_MSFT_scene_understanding\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_SCENE_CREATE_INFO_MSFT:
            // Enum value XR_TYPE_SCENE_CREATE_INFO_MSFT requires extension XR_MSFT_scene_understanding, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_MSFT_scene_understanding")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_SCENE_CREATE_INFO_MSFT\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_MSFT_scene_understanding\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_NEW_SCENE_COMPUTE_INFO_MSFT:
            // Enum value XR_TYPE_NEW_SCENE_COMPUTE_INFO_MSFT requires extension XR_MSFT_scene_understanding, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_MSFT_scene_understanding")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_NEW_SCENE_COMPUTE_INFO_MSFT\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_MSFT_scene_understanding\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_VISUAL_MESH_COMPUTE_LOD_INFO_MSFT:
            // Enum value XR_TYPE_VISUAL_MESH_COMPUTE_LOD_INFO_MSFT requires extension XR_MSFT_scene_understanding, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_MSFT_scene_understanding")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_VISUAL_MESH_COMPUTE_LOD_INFO_MSFT\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_MSFT_scene_understanding\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_SCENE_COMPONENTS_MSFT:
            // Enum value XR_TYPE_SCENE_COMPONENTS_MSFT requires extension XR_MSFT_scene_understanding, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_MSFT_scene_understanding")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_SCENE_COMPONENTS_MSFT\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_MSFT_scene_understanding\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_SCENE_COMPONENTS_GET_INFO_MSFT:
            // Enum value XR_TYPE_SCENE_COMPONENTS_GET_INFO_MSFT requires extension XR_MSFT_scene_understanding, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_MSFT_scene_understanding")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_SCENE_COMPONENTS_GET_INFO_MSFT\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_MSFT_scene_understanding\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_SCENE_COMPONENT_LOCATIONS_MSFT:
            // Enum value XR_TYPE_SCENE_COMPONENT_LOCATIONS_MSFT requires extension XR_MSFT_scene_understanding, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_MSFT_scene_understanding")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_SCENE_COMPONENT_LOCATIONS_MSFT\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_MSFT_scene_understanding\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_SCENE_COMPONENTS_LOCATE_INFO_MSFT:
            // Enum value XR_TYPE_SCENE_COMPONENTS_LOCATE_INFO_MSFT requires extension XR_MSFT_scene_understanding, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_MSFT_scene_understanding")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_SCENE_COMPONENTS_LOCATE_INFO_MSFT\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_MSFT_scene_understanding\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_SCENE_OBJECTS_MSFT:
            // Enum value XR_TYPE_SCENE_OBJECTS_MSFT requires extension XR_MSFT_scene_understanding, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_MSFT_scene_understanding")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_SCENE_OBJECTS_MSFT\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_MSFT_scene_understanding\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_SCENE_COMPONENT_PARENT_FILTER_INFO_MSFT:
            // Enum value XR_TYPE_SCENE_COMPONENT_PARENT_FILTER_INFO_MSFT requires extension XR_MSFT_scene_understanding, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_MSFT_scene_understanding")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_SCENE_COMPONENT_PARENT_FILTER_INFO_MSFT\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_MSFT_scene_understanding\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_SCENE_OBJECT_TYPES_FILTER_INFO_MSFT:
            // Enum value XR_TYPE_SCENE_OBJECT_TYPES_FILTER_INFO_MSFT requires extension XR_MSFT_scene_understanding, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_MSFT_scene_understanding")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_SCENE_OBJECT_TYPES_FILTER_INFO_MSFT\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_MSFT_scene_understanding\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_SCENE_PLANES_MSFT:
            // Enum value XR_TYPE_SCENE_PLANES_MSFT requires extension XR_MSFT_scene_understanding, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_MSFT_scene_understanding")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_SCENE_PLANES_MSFT\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_MSFT_scene_understanding\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_SCENE_PLANE_ALIGNMENT_FILTER_INFO_MSFT:
            // Enum value XR_TYPE_SCENE_PLANE_ALIGNMENT_FILTER_INFO_MSFT requires extension XR_MSFT_scene_understanding, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_MSFT_scene_understanding")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_SCENE_PLANE_ALIGNMENT_FILTER_INFO_MSFT\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_MSFT_scene_understanding\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_SCENE_MESHES_MSFT:
            // Enum value XR_TYPE_SCENE_MESHES_MSFT requires extension XR_MSFT_scene_understanding, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_MSFT_scene_understanding")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_SCENE_MESHES_MSFT\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_MSFT_scene_understanding\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_SCENE_MESH_BUFFERS_GET_INFO_MSFT:
            // Enum value XR_TYPE_SCENE_MESH_BUFFERS_GET_INFO_MSFT requires extension XR_MSFT_scene_understanding, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_MSFT_scene_understanding")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_SCENE_MESH_BUFFERS_GET_INFO_MSFT\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_MSFT_scene_understanding\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_SCENE_MESH_BUFFERS_MSFT:
            // Enum value XR_TYPE_SCENE_MESH_BUFFERS_MSFT requires extension XR_MSFT_scene_understanding, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_MSFT_scene_understanding")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_SCENE_MESH_BUFFERS_MSFT\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_MSFT_scene_understanding\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_SCENE_MESH_VERTEX_BUFFER_MSFT:
            // Enum value XR_TYPE_SCENE_MESH_VERTEX_BUFFER_MSFT requires extension XR_MSFT_scene_understanding, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_MSFT_scene_understanding")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_SCENE_MESH_VERTEX_BUFFER_MSFT\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_MSFT_scene_understanding\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_SCENE_MESH_INDICES_UINT32_MSFT:
            // Enum value XR_TYPE_SCENE_MESH_INDICES_UINT32_MSFT requires extension XR_MSFT_scene_understanding, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_MSFT_scene_understanding")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_SCENE_MESH_INDICES_UINT32_MSFT\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_MSFT_scene_understanding\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_SCENE_MESH_INDICES_UINT16_MSFT:
            // Enum value XR_TYPE_SCENE_MESH_INDICES_UINT16_MSFT requires extension XR_MSFT_scene_understanding, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_MSFT_scene_understanding")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_SCENE_MESH_INDICES_UINT16_MSFT\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_MSFT_scene_understanding\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_SERIALIZED_SCENE_FRAGMENT_DATA_GET_INFO_MSFT:
            // Enum value XR_TYPE_SERIALIZED_SCENE_FRAGMENT_DATA_GET_INFO_MSFT requires extension XR_MSFT_scene_understanding_serialization, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_MSFT_scene_understanding_serialization")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_SERIALIZED_SCENE_FRAGMENT_DATA_GET_INFO_MSFT\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_MSFT_scene_understanding_serialization\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_SCENE_DESERIALIZE_INFO_MSFT:
            // Enum value XR_TYPE_SCENE_DESERIALIZE_INFO_MSFT requires extension XR_MSFT_scene_understanding_serialization, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_MSFT_scene_understanding_serialization")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_SCENE_DESERIALIZE_INFO_MSFT\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_MSFT_scene_understanding_serialization\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_EVENT_DATA_DISPLAY_REFRESH_RATE_CHANGED_FB:
            // Enum value XR_TYPE_EVENT_DATA_DISPLAY_REFRESH_RATE_CHANGED_FB requires extension XR_FB_display_refresh_rate, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_FB_display_refresh_rate")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_EVENT_DATA_DISPLAY_REFRESH_RATE_CHANGED_FB\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_FB_display_refresh_rate\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_VIVE_TRACKER_PATHS_HTCX:
            // Enum value XR_TYPE_VIVE_TRACKER_PATHS_HTCX requires extension XR_HTCX_vive_tracker_interaction, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_HTCX_vive_tracker_interaction")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_VIVE_TRACKER_PATHS_HTCX\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_HTCX_vive_tracker_interaction\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_EVENT_DATA_VIVE_TRACKER_CONNECTED_HTCX:
            // Enum value XR_TYPE_EVENT_DATA_VIVE_TRACKER_CONNECTED_HTCX requires extension XR_HTCX_vive_tracker_interaction, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_HTCX_vive_tracker_interaction")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_EVENT_DATA_VIVE_TRACKER_CONNECTED_HTCX\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_HTCX_vive_tracker_interaction\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_SYSTEM_FACIAL_TRACKING_PROPERTIES_HTC:
            // Enum value XR_TYPE_SYSTEM_FACIAL_TRACKING_PROPERTIES_HTC requires extension XR_HTC_facial_tracking, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_HTC_facial_tracking")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_SYSTEM_FACIAL_TRACKING_PROPERTIES_HTC\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_HTC_facial_tracking\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_FACIAL_TRACKER_CREATE_INFO_HTC:
            // Enum value XR_TYPE_FACIAL_TRACKER_CREATE_INFO_HTC requires extension XR_HTC_facial_tracking, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_HTC_facial_tracking")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_FACIAL_TRACKER_CREATE_INFO_HTC\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_HTC_facial_tracking\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_FACIAL_EXPRESSIONS_HTC:
            // Enum value XR_TYPE_FACIAL_EXPRESSIONS_HTC requires extension XR_HTC_facial_tracking, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_HTC_facial_tracking")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_FACIAL_EXPRESSIONS_HTC\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_HTC_facial_tracking\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_SYSTEM_COLOR_SPACE_PROPERTIES_FB:
            // Enum value XR_TYPE_SYSTEM_COLOR_SPACE_PROPERTIES_FB requires extension XR_FB_color_space, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_FB_color_space")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_SYSTEM_COLOR_SPACE_PROPERTIES_FB\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_FB_color_space\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_HAND_TRACKING_MESH_FB:
            // Enum value XR_TYPE_HAND_TRACKING_MESH_FB requires extension XR_FB_hand_tracking_mesh, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_FB_hand_tracking_mesh")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_HAND_TRACKING_MESH_FB\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_FB_hand_tracking_mesh\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_HAND_TRACKING_SCALE_FB:
            // Enum value XR_TYPE_HAND_TRACKING_SCALE_FB requires extension XR_FB_hand_tracking_mesh, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_FB_hand_tracking_mesh")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_HAND_TRACKING_SCALE_FB\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_FB_hand_tracking_mesh\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_HAND_TRACKING_AIM_STATE_FB:
            // Enum value XR_TYPE_HAND_TRACKING_AIM_STATE_FB requires extension XR_FB_hand_tracking_aim, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_FB_hand_tracking_aim")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_HAND_TRACKING_AIM_STATE_FB\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_FB_hand_tracking_aim\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_HAND_TRACKING_CAPSULES_STATE_FB:
            // Enum value XR_TYPE_HAND_TRACKING_CAPSULES_STATE_FB requires extension XR_FB_hand_tracking_capsules, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_FB_hand_tracking_capsules")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_HAND_TRACKING_CAPSULES_STATE_FB\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_FB_hand_tracking_capsules\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_SYSTEM_SPATIAL_ENTITY_PROPERTIES_FB:
            // Enum value XR_TYPE_SYSTEM_SPATIAL_ENTITY_PROPERTIES_FB requires extension XR_FB_spatial_entity, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_FB_spatial_entity")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_SYSTEM_SPATIAL_ENTITY_PROPERTIES_FB\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_FB_spatial_entity\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_SPATIAL_ANCHOR_CREATE_INFO_FB:
            // Enum value XR_TYPE_SPATIAL_ANCHOR_CREATE_INFO_FB requires extension XR_FB_spatial_entity, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_FB_spatial_entity")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_SPATIAL_ANCHOR_CREATE_INFO_FB\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_FB_spatial_entity\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_SPACE_COMPONENT_STATUS_SET_INFO_FB:
            // Enum value XR_TYPE_SPACE_COMPONENT_STATUS_SET_INFO_FB requires extension XR_FB_spatial_entity, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_FB_spatial_entity")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_SPACE_COMPONENT_STATUS_SET_INFO_FB\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_FB_spatial_entity\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_SPACE_COMPONENT_STATUS_FB:
            // Enum value XR_TYPE_SPACE_COMPONENT_STATUS_FB requires extension XR_FB_spatial_entity, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_FB_spatial_entity")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_SPACE_COMPONENT_STATUS_FB\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_FB_spatial_entity\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_EVENT_DATA_SPATIAL_ANCHOR_CREATE_COMPLETE_FB:
            // Enum value XR_TYPE_EVENT_DATA_SPATIAL_ANCHOR_CREATE_COMPLETE_FB requires extension XR_FB_spatial_entity, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_FB_spatial_entity")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_EVENT_DATA_SPATIAL_ANCHOR_CREATE_COMPLETE_FB\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_FB_spatial_entity\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_EVENT_DATA_SPACE_SET_STATUS_COMPLETE_FB:
            // Enum value XR_TYPE_EVENT_DATA_SPACE_SET_STATUS_COMPLETE_FB requires extension XR_FB_spatial_entity, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_FB_spatial_entity")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_EVENT_DATA_SPACE_SET_STATUS_COMPLETE_FB\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_FB_spatial_entity\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_FOVEATION_PROFILE_CREATE_INFO_FB:
            // Enum value XR_TYPE_FOVEATION_PROFILE_CREATE_INFO_FB requires extension XR_FB_foveation, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_FB_foveation")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_FOVEATION_PROFILE_CREATE_INFO_FB\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_FB_foveation\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_SWAPCHAIN_CREATE_INFO_FOVEATION_FB:
            // Enum value XR_TYPE_SWAPCHAIN_CREATE_INFO_FOVEATION_FB requires extension XR_FB_foveation, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_FB_foveation")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_SWAPCHAIN_CREATE_INFO_FOVEATION_FB\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_FB_foveation\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_SWAPCHAIN_STATE_FOVEATION_FB:
            // Enum value XR_TYPE_SWAPCHAIN_STATE_FOVEATION_FB requires extension XR_FB_foveation, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_FB_foveation")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_SWAPCHAIN_STATE_FOVEATION_FB\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_FB_foveation\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_FOVEATION_LEVEL_PROFILE_CREATE_INFO_FB:
            // Enum value XR_TYPE_FOVEATION_LEVEL_PROFILE_CREATE_INFO_FB requires extension XR_FB_foveation_configuration, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_FB_foveation_configuration")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_FOVEATION_LEVEL_PROFILE_CREATE_INFO_FB\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_FB_foveation_configuration\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_KEYBOARD_SPACE_CREATE_INFO_FB:
            // Enum value XR_TYPE_KEYBOARD_SPACE_CREATE_INFO_FB requires extension XR_FB_keyboard_tracking, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_FB_keyboard_tracking")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_KEYBOARD_SPACE_CREATE_INFO_FB\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_FB_keyboard_tracking\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_KEYBOARD_TRACKING_QUERY_FB:
            // Enum value XR_TYPE_KEYBOARD_TRACKING_QUERY_FB requires extension XR_FB_keyboard_tracking, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_FB_keyboard_tracking")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_KEYBOARD_TRACKING_QUERY_FB\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_FB_keyboard_tracking\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_SYSTEM_KEYBOARD_TRACKING_PROPERTIES_FB:
            // Enum value XR_TYPE_SYSTEM_KEYBOARD_TRACKING_PROPERTIES_FB requires extension XR_FB_keyboard_tracking, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_FB_keyboard_tracking")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_SYSTEM_KEYBOARD_TRACKING_PROPERTIES_FB\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_FB_keyboard_tracking\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_TRIANGLE_MESH_CREATE_INFO_FB:
            // Enum value XR_TYPE_TRIANGLE_MESH_CREATE_INFO_FB requires extension XR_FB_triangle_mesh, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_FB_triangle_mesh")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_TRIANGLE_MESH_CREATE_INFO_FB\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_FB_triangle_mesh\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_SYSTEM_PASSTHROUGH_PROPERTIES_FB:
            // Enum value XR_TYPE_SYSTEM_PASSTHROUGH_PROPERTIES_FB requires extension XR_FB_passthrough, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_FB_passthrough")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_SYSTEM_PASSTHROUGH_PROPERTIES_FB\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_FB_passthrough\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_PASSTHROUGH_CREATE_INFO_FB:
            // Enum value XR_TYPE_PASSTHROUGH_CREATE_INFO_FB requires extension XR_FB_passthrough, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_FB_passthrough")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_PASSTHROUGH_CREATE_INFO_FB\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_FB_passthrough\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_PASSTHROUGH_LAYER_CREATE_INFO_FB:
            // Enum value XR_TYPE_PASSTHROUGH_LAYER_CREATE_INFO_FB requires extension XR_FB_passthrough, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_FB_passthrough")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_PASSTHROUGH_LAYER_CREATE_INFO_FB\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_FB_passthrough\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_COMPOSITION_LAYER_PASSTHROUGH_FB:
            // Enum value XR_TYPE_COMPOSITION_LAYER_PASSTHROUGH_FB requires extension XR_FB_passthrough, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_FB_passthrough")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_COMPOSITION_LAYER_PASSTHROUGH_FB\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_FB_passthrough\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_GEOMETRY_INSTANCE_CREATE_INFO_FB:
            // Enum value XR_TYPE_GEOMETRY_INSTANCE_CREATE_INFO_FB requires extension XR_FB_passthrough, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_FB_passthrough")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_GEOMETRY_INSTANCE_CREATE_INFO_FB\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_FB_passthrough\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_GEOMETRY_INSTANCE_TRANSFORM_FB:
            // Enum value XR_TYPE_GEOMETRY_INSTANCE_TRANSFORM_FB requires extension XR_FB_passthrough, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_FB_passthrough")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_GEOMETRY_INSTANCE_TRANSFORM_FB\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_FB_passthrough\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_SYSTEM_PASSTHROUGH_PROPERTIES2_FB:
            // Enum value XR_TYPE_SYSTEM_PASSTHROUGH_PROPERTIES2_FB requires extension XR_FB_passthrough, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_FB_passthrough")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_SYSTEM_PASSTHROUGH_PROPERTIES2_FB\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_FB_passthrough\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_PASSTHROUGH_STYLE_FB:
            // Enum value XR_TYPE_PASSTHROUGH_STYLE_FB requires extension XR_FB_passthrough, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_FB_passthrough")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_PASSTHROUGH_STYLE_FB\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_FB_passthrough\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_PASSTHROUGH_COLOR_MAP_MONO_TO_RGBA_FB:
            // Enum value XR_TYPE_PASSTHROUGH_COLOR_MAP_MONO_TO_RGBA_FB requires extension XR_FB_passthrough, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_FB_passthrough")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_PASSTHROUGH_COLOR_MAP_MONO_TO_RGBA_FB\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_FB_passthrough\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_PASSTHROUGH_COLOR_MAP_MONO_TO_MONO_FB:
            // Enum value XR_TYPE_PASSTHROUGH_COLOR_MAP_MONO_TO_MONO_FB requires extension XR_FB_passthrough, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_FB_passthrough")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_PASSTHROUGH_COLOR_MAP_MONO_TO_MONO_FB\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_FB_passthrough\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_PASSTHROUGH_BRIGHTNESS_CONTRAST_SATURATION_FB:
            // Enum value XR_TYPE_PASSTHROUGH_BRIGHTNESS_CONTRAST_SATURATION_FB requires extension XR_FB_passthrough, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_FB_passthrough")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_PASSTHROUGH_BRIGHTNESS_CONTRAST_SATURATION_FB\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_FB_passthrough\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_EVENT_DATA_PASSTHROUGH_STATE_CHANGED_FB:
            // Enum value XR_TYPE_EVENT_DATA_PASSTHROUGH_STATE_CHANGED_FB requires extension XR_FB_passthrough, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_FB_passthrough")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_EVENT_DATA_PASSTHROUGH_STATE_CHANGED_FB\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_FB_passthrough\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_RENDER_MODEL_PATH_INFO_FB:
            // Enum value XR_TYPE_RENDER_MODEL_PATH_INFO_FB requires extension XR_FB_render_model, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_FB_render_model")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_RENDER_MODEL_PATH_INFO_FB\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_FB_render_model\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_RENDER_MODEL_PROPERTIES_FB:
            // Enum value XR_TYPE_RENDER_MODEL_PROPERTIES_FB requires extension XR_FB_render_model, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_FB_render_model")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_RENDER_MODEL_PROPERTIES_FB\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_FB_render_model\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_RENDER_MODEL_BUFFER_FB:
            // Enum value XR_TYPE_RENDER_MODEL_BUFFER_FB requires extension XR_FB_render_model, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_FB_render_model")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_RENDER_MODEL_BUFFER_FB\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_FB_render_model\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_RENDER_MODEL_LOAD_INFO_FB:
            // Enum value XR_TYPE_RENDER_MODEL_LOAD_INFO_FB requires extension XR_FB_render_model, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_FB_render_model")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_RENDER_MODEL_LOAD_INFO_FB\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_FB_render_model\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_SYSTEM_RENDER_MODEL_PROPERTIES_FB:
            // Enum value XR_TYPE_SYSTEM_RENDER_MODEL_PROPERTIES_FB requires extension XR_FB_render_model, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_FB_render_model")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_SYSTEM_RENDER_MODEL_PROPERTIES_FB\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_FB_render_model\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_RENDER_MODEL_CAPABILITIES_REQUEST_FB:
            // Enum value XR_TYPE_RENDER_MODEL_CAPABILITIES_REQUEST_FB requires extension XR_FB_render_model, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_FB_render_model")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_RENDER_MODEL_CAPABILITIES_REQUEST_FB\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_FB_render_model\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_BINDING_MODIFICATIONS_KHR:
            // Enum value XR_TYPE_BINDING_MODIFICATIONS_KHR requires extension XR_KHR_binding_modification, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_KHR_binding_modification")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_BINDING_MODIFICATIONS_KHR\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_KHR_binding_modification\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_VIEW_LOCATE_FOVEATED_RENDERING_VARJO:
            // Enum value XR_TYPE_VIEW_LOCATE_FOVEATED_RENDERING_VARJO requires extension XR_VARJO_foveated_rendering, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_VARJO_foveated_rendering")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_VIEW_LOCATE_FOVEATED_RENDERING_VARJO\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_VARJO_foveated_rendering\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_FOVEATED_VIEW_CONFIGURATION_VIEW_VARJO:
            // Enum value XR_TYPE_FOVEATED_VIEW_CONFIGURATION_VIEW_VARJO requires extension XR_VARJO_foveated_rendering, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_VARJO_foveated_rendering")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_FOVEATED_VIEW_CONFIGURATION_VIEW_VARJO\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_VARJO_foveated_rendering\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_SYSTEM_FOVEATED_RENDERING_PROPERTIES_VARJO:
            // Enum value XR_TYPE_SYSTEM_FOVEATED_RENDERING_PROPERTIES_VARJO requires extension XR_VARJO_foveated_rendering, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_VARJO_foveated_rendering")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_SYSTEM_FOVEATED_RENDERING_PROPERTIES_VARJO\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_VARJO_foveated_rendering\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_COMPOSITION_LAYER_DEPTH_TEST_VARJO:
            // Enum value XR_TYPE_COMPOSITION_LAYER_DEPTH_TEST_VARJO requires extension XR_VARJO_composition_layer_depth_test, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_VARJO_composition_layer_depth_test")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_COMPOSITION_LAYER_DEPTH_TEST_VARJO\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_VARJO_composition_layer_depth_test\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_SYSTEM_MARKER_TRACKING_PROPERTIES_VARJO:
            // Enum value XR_TYPE_SYSTEM_MARKER_TRACKING_PROPERTIES_VARJO requires extension XR_VARJO_marker_tracking, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_VARJO_marker_tracking")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_SYSTEM_MARKER_TRACKING_PROPERTIES_VARJO\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_VARJO_marker_tracking\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_EVENT_DATA_MARKER_TRACKING_UPDATE_VARJO:
            // Enum value XR_TYPE_EVENT_DATA_MARKER_TRACKING_UPDATE_VARJO requires extension XR_VARJO_marker_tracking, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_VARJO_marker_tracking")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_EVENT_DATA_MARKER_TRACKING_UPDATE_VARJO\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_VARJO_marker_tracking\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_MARKER_SPACE_CREATE_INFO_VARJO:
            // Enum value XR_TYPE_MARKER_SPACE_CREATE_INFO_VARJO requires extension XR_VARJO_marker_tracking, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_VARJO_marker_tracking")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_MARKER_SPACE_CREATE_INFO_VARJO\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_VARJO_marker_tracking\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_FRAME_END_INFO_ML:
            // Enum value XR_TYPE_FRAME_END_INFO_ML requires extension XR_ML_frame_end_info, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_ML_frame_end_info")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_FRAME_END_INFO_ML\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_ML_frame_end_info\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_GLOBAL_DIMMER_FRAME_END_INFO_ML:
            // Enum value XR_TYPE_GLOBAL_DIMMER_FRAME_END_INFO_ML requires extension XR_ML_global_dimmer, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_ML_global_dimmer")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_GLOBAL_DIMMER_FRAME_END_INFO_ML\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_ML_global_dimmer\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_COORDINATE_SPACE_CREATE_INFO_ML:
            // Enum value XR_TYPE_COORDINATE_SPACE_CREATE_INFO_ML requires extension XR_ML_compat, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_ML_compat")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_COORDINATE_SPACE_CREATE_INFO_ML\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_ML_compat\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_SYSTEM_MARKER_UNDERSTANDING_PROPERTIES_ML:
            // Enum value XR_TYPE_SYSTEM_MARKER_UNDERSTANDING_PROPERTIES_ML requires extension XR_ML_marker_understanding, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_ML_marker_understanding")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_SYSTEM_MARKER_UNDERSTANDING_PROPERTIES_ML\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_ML_marker_understanding\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_MARKER_DETECTOR_CREATE_INFO_ML:
            // Enum value XR_TYPE_MARKER_DETECTOR_CREATE_INFO_ML requires extension XR_ML_marker_understanding, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_ML_marker_understanding")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_MARKER_DETECTOR_CREATE_INFO_ML\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_ML_marker_understanding\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_MARKER_DETECTOR_ARUCO_INFO_ML:
            // Enum value XR_TYPE_MARKER_DETECTOR_ARUCO_INFO_ML requires extension XR_ML_marker_understanding, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_ML_marker_understanding")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_MARKER_DETECTOR_ARUCO_INFO_ML\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_ML_marker_understanding\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_MARKER_DETECTOR_SIZE_INFO_ML:
            // Enum value XR_TYPE_MARKER_DETECTOR_SIZE_INFO_ML requires extension XR_ML_marker_understanding, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_ML_marker_understanding")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_MARKER_DETECTOR_SIZE_INFO_ML\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_ML_marker_understanding\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_MARKER_DETECTOR_APRIL_TAG_INFO_ML:
            // Enum value XR_TYPE_MARKER_DETECTOR_APRIL_TAG_INFO_ML requires extension XR_ML_marker_understanding, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_ML_marker_understanding")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_MARKER_DETECTOR_APRIL_TAG_INFO_ML\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_ML_marker_understanding\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_MARKER_DETECTOR_CUSTOM_PROFILE_INFO_ML:
            // Enum value XR_TYPE_MARKER_DETECTOR_CUSTOM_PROFILE_INFO_ML requires extension XR_ML_marker_understanding, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_ML_marker_understanding")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_MARKER_DETECTOR_CUSTOM_PROFILE_INFO_ML\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_ML_marker_understanding\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_MARKER_DETECTOR_SNAPSHOT_INFO_ML:
            // Enum value XR_TYPE_MARKER_DETECTOR_SNAPSHOT_INFO_ML requires extension XR_ML_marker_understanding, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_ML_marker_understanding")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_MARKER_DETECTOR_SNAPSHOT_INFO_ML\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_ML_marker_understanding\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_MARKER_DETECTOR_STATE_ML:
            // Enum value XR_TYPE_MARKER_DETECTOR_STATE_ML requires extension XR_ML_marker_understanding, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_ML_marker_understanding")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_MARKER_DETECTOR_STATE_ML\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_ML_marker_understanding\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_MARKER_SPACE_CREATE_INFO_ML:
            // Enum value XR_TYPE_MARKER_SPACE_CREATE_INFO_ML requires extension XR_ML_marker_understanding, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_ML_marker_understanding")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_MARKER_SPACE_CREATE_INFO_ML\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_ML_marker_understanding\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_LOCALIZATION_MAP_ML:
            // Enum value XR_TYPE_LOCALIZATION_MAP_ML requires extension XR_ML_localization_map, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_ML_localization_map")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_LOCALIZATION_MAP_ML\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_ML_localization_map\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_EVENT_DATA_LOCALIZATION_CHANGED_ML:
            // Enum value XR_TYPE_EVENT_DATA_LOCALIZATION_CHANGED_ML requires extension XR_ML_localization_map, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_ML_localization_map")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_EVENT_DATA_LOCALIZATION_CHANGED_ML\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_ML_localization_map\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_MAP_LOCALIZATION_REQUEST_INFO_ML:
            // Enum value XR_TYPE_MAP_LOCALIZATION_REQUEST_INFO_ML requires extension XR_ML_localization_map, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_ML_localization_map")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_MAP_LOCALIZATION_REQUEST_INFO_ML\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_ML_localization_map\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_LOCALIZATION_MAP_IMPORT_INFO_ML:
            // Enum value XR_TYPE_LOCALIZATION_MAP_IMPORT_INFO_ML requires extension XR_ML_localization_map, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_ML_localization_map")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_LOCALIZATION_MAP_IMPORT_INFO_ML\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_ML_localization_map\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_LOCALIZATION_ENABLE_EVENTS_INFO_ML:
            // Enum value XR_TYPE_LOCALIZATION_ENABLE_EVENTS_INFO_ML requires extension XR_ML_localization_map, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_ML_localization_map")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_LOCALIZATION_ENABLE_EVENTS_INFO_ML\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_ML_localization_map\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_SPATIAL_ANCHORS_CREATE_INFO_FROM_POSE_ML:
            // Enum value XR_TYPE_SPATIAL_ANCHORS_CREATE_INFO_FROM_POSE_ML requires extension XR_ML_spatial_anchors, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_ML_spatial_anchors")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_SPATIAL_ANCHORS_CREATE_INFO_FROM_POSE_ML\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_ML_spatial_anchors\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_CREATE_SPATIAL_ANCHORS_COMPLETION_ML:
            // Enum value XR_TYPE_CREATE_SPATIAL_ANCHORS_COMPLETION_ML requires extension XR_ML_spatial_anchors, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_ML_spatial_anchors")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_CREATE_SPATIAL_ANCHORS_COMPLETION_ML\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_ML_spatial_anchors\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_SPATIAL_ANCHOR_STATE_ML:
            // Enum value XR_TYPE_SPATIAL_ANCHOR_STATE_ML requires extension XR_ML_spatial_anchors, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_ML_spatial_anchors")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_SPATIAL_ANCHOR_STATE_ML\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_ML_spatial_anchors\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_SPATIAL_ANCHORS_CREATE_STORAGE_INFO_ML:
            // Enum value XR_TYPE_SPATIAL_ANCHORS_CREATE_STORAGE_INFO_ML requires extension XR_ML_spatial_anchors_storage, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_ML_spatial_anchors_storage")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_SPATIAL_ANCHORS_CREATE_STORAGE_INFO_ML\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_ML_spatial_anchors_storage\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_SPATIAL_ANCHORS_QUERY_INFO_RADIUS_ML:
            // Enum value XR_TYPE_SPATIAL_ANCHORS_QUERY_INFO_RADIUS_ML requires extension XR_ML_spatial_anchors_storage, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_ML_spatial_anchors_storage")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_SPATIAL_ANCHORS_QUERY_INFO_RADIUS_ML\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_ML_spatial_anchors_storage\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_SPATIAL_ANCHORS_QUERY_COMPLETION_ML:
            // Enum value XR_TYPE_SPATIAL_ANCHORS_QUERY_COMPLETION_ML requires extension XR_ML_spatial_anchors_storage, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_ML_spatial_anchors_storage")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_SPATIAL_ANCHORS_QUERY_COMPLETION_ML\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_ML_spatial_anchors_storage\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_SPATIAL_ANCHORS_CREATE_INFO_FROM_UUIDS_ML:
            // Enum value XR_TYPE_SPATIAL_ANCHORS_CREATE_INFO_FROM_UUIDS_ML requires extension XR_ML_spatial_anchors_storage, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_ML_spatial_anchors_storage")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_SPATIAL_ANCHORS_CREATE_INFO_FROM_UUIDS_ML\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_ML_spatial_anchors_storage\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_SPATIAL_ANCHORS_PUBLISH_INFO_ML:
            // Enum value XR_TYPE_SPATIAL_ANCHORS_PUBLISH_INFO_ML requires extension XR_ML_spatial_anchors_storage, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_ML_spatial_anchors_storage")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_SPATIAL_ANCHORS_PUBLISH_INFO_ML\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_ML_spatial_anchors_storage\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_SPATIAL_ANCHORS_PUBLISH_COMPLETION_ML:
            // Enum value XR_TYPE_SPATIAL_ANCHORS_PUBLISH_COMPLETION_ML requires extension XR_ML_spatial_anchors_storage, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_ML_spatial_anchors_storage")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_SPATIAL_ANCHORS_PUBLISH_COMPLETION_ML\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_ML_spatial_anchors_storage\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_SPATIAL_ANCHORS_DELETE_INFO_ML:
            // Enum value XR_TYPE_SPATIAL_ANCHORS_DELETE_INFO_ML requires extension XR_ML_spatial_anchors_storage, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_ML_spatial_anchors_storage")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_SPATIAL_ANCHORS_DELETE_INFO_ML\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_ML_spatial_anchors_storage\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_SPATIAL_ANCHORS_DELETE_COMPLETION_ML:
            // Enum value XR_TYPE_SPATIAL_ANCHORS_DELETE_COMPLETION_ML requires extension XR_ML_spatial_anchors_storage, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_ML_spatial_anchors_storage")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_SPATIAL_ANCHORS_DELETE_COMPLETION_ML\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_ML_spatial_anchors_storage\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_SPATIAL_ANCHORS_UPDATE_EXPIRATION_INFO_ML:
            // Enum value XR_TYPE_SPATIAL_ANCHORS_UPDATE_EXPIRATION_INFO_ML requires extension XR_ML_spatial_anchors_storage, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_ML_spatial_anchors_storage")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_SPATIAL_ANCHORS_UPDATE_EXPIRATION_INFO_ML\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_ML_spatial_anchors_storage\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_SPATIAL_ANCHORS_UPDATE_EXPIRATION_COMPLETION_ML:
            // Enum value XR_TYPE_SPATIAL_ANCHORS_UPDATE_EXPIRATION_COMPLETION_ML requires extension XR_ML_spatial_anchors_storage, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_ML_spatial_anchors_storage")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_SPATIAL_ANCHORS_UPDATE_EXPIRATION_COMPLETION_ML\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_ML_spatial_anchors_storage\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_SPATIAL_ANCHORS_PUBLISH_COMPLETION_DETAILS_ML:
            // Enum value XR_TYPE_SPATIAL_ANCHORS_PUBLISH_COMPLETION_DETAILS_ML requires extension XR_ML_spatial_anchors_storage, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_ML_spatial_anchors_storage")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_SPATIAL_ANCHORS_PUBLISH_COMPLETION_DETAILS_ML\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_ML_spatial_anchors_storage\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_SPATIAL_ANCHORS_DELETE_COMPLETION_DETAILS_ML:
            // Enum value XR_TYPE_SPATIAL_ANCHORS_DELETE_COMPLETION_DETAILS_ML requires extension XR_ML_spatial_anchors_storage, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_ML_spatial_anchors_storage")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_SPATIAL_ANCHORS_DELETE_COMPLETION_DETAILS_ML\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_ML_spatial_anchors_storage\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_SPATIAL_ANCHORS_UPDATE_EXPIRATION_COMPLETION_DETAILS_ML:
            // Enum value XR_TYPE_SPATIAL_ANCHORS_UPDATE_EXPIRATION_COMPLETION_DETAILS_ML requires extension XR_ML_spatial_anchors_storage, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_ML_spatial_anchors_storage")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_SPATIAL_ANCHORS_UPDATE_EXPIRATION_COMPLETION_DETAILS_ML\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_ML_spatial_anchors_storage\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_EVENT_DATA_HEADSET_FIT_CHANGED_ML:
            // Enum value XR_TYPE_EVENT_DATA_HEADSET_FIT_CHANGED_ML requires extension XR_ML_user_calibration, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_ML_user_calibration")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_EVENT_DATA_HEADSET_FIT_CHANGED_ML\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_ML_user_calibration\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_EVENT_DATA_EYE_CALIBRATION_CHANGED_ML:
            // Enum value XR_TYPE_EVENT_DATA_EYE_CALIBRATION_CHANGED_ML requires extension XR_ML_user_calibration, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_ML_user_calibration")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_EVENT_DATA_EYE_CALIBRATION_CHANGED_ML\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_ML_user_calibration\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_USER_CALIBRATION_ENABLE_EVENTS_INFO_ML:
            // Enum value XR_TYPE_USER_CALIBRATION_ENABLE_EVENTS_INFO_ML requires extension XR_ML_user_calibration, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_ML_user_calibration")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_USER_CALIBRATION_ENABLE_EVENTS_INFO_ML\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_ML_user_calibration\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_SPATIAL_ANCHOR_PERSISTENCE_INFO_MSFT:
            // Enum value XR_TYPE_SPATIAL_ANCHOR_PERSISTENCE_INFO_MSFT requires extension XR_MSFT_spatial_anchor_persistence, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_MSFT_spatial_anchor_persistence")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_SPATIAL_ANCHOR_PERSISTENCE_INFO_MSFT\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_MSFT_spatial_anchor_persistence\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_SPATIAL_ANCHOR_FROM_PERSISTED_ANCHOR_CREATE_INFO_MSFT:
            // Enum value XR_TYPE_SPATIAL_ANCHOR_FROM_PERSISTED_ANCHOR_CREATE_INFO_MSFT requires extension XR_MSFT_spatial_anchor_persistence, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_MSFT_spatial_anchor_persistence")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_SPATIAL_ANCHOR_FROM_PERSISTED_ANCHOR_CREATE_INFO_MSFT\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_MSFT_spatial_anchor_persistence\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_SCENE_MARKERS_MSFT:
            // Enum value XR_TYPE_SCENE_MARKERS_MSFT requires extension XR_MSFT_scene_marker, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_MSFT_scene_marker")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_SCENE_MARKERS_MSFT\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_MSFT_scene_marker\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_SCENE_MARKER_TYPE_FILTER_MSFT:
            // Enum value XR_TYPE_SCENE_MARKER_TYPE_FILTER_MSFT requires extension XR_MSFT_scene_marker, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_MSFT_scene_marker")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_SCENE_MARKER_TYPE_FILTER_MSFT\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_MSFT_scene_marker\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_SCENE_MARKER_QR_CODES_MSFT:
            // Enum value XR_TYPE_SCENE_MARKER_QR_CODES_MSFT requires extension XR_MSFT_scene_marker, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_MSFT_scene_marker")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_SCENE_MARKER_QR_CODES_MSFT\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_MSFT_scene_marker\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_SPACE_QUERY_INFO_FB:
            // Enum value XR_TYPE_SPACE_QUERY_INFO_FB requires extension XR_FB_spatial_entity_query, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_FB_spatial_entity_query")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_SPACE_QUERY_INFO_FB\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_FB_spatial_entity_query\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_SPACE_QUERY_RESULTS_FB:
            // Enum value XR_TYPE_SPACE_QUERY_RESULTS_FB requires extension XR_FB_spatial_entity_query, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_FB_spatial_entity_query")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_SPACE_QUERY_RESULTS_FB\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_FB_spatial_entity_query\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_SPACE_STORAGE_LOCATION_FILTER_INFO_FB:
            // Enum value XR_TYPE_SPACE_STORAGE_LOCATION_FILTER_INFO_FB requires extension XR_FB_spatial_entity_query, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_FB_spatial_entity_query")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_SPACE_STORAGE_LOCATION_FILTER_INFO_FB\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_FB_spatial_entity_query\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_SPACE_UUID_FILTER_INFO_FB:
            // Enum value XR_TYPE_SPACE_UUID_FILTER_INFO_FB requires extension XR_FB_spatial_entity_query, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_FB_spatial_entity_query")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_SPACE_UUID_FILTER_INFO_FB\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_FB_spatial_entity_query\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_SPACE_COMPONENT_FILTER_INFO_FB:
            // Enum value XR_TYPE_SPACE_COMPONENT_FILTER_INFO_FB requires extension XR_FB_spatial_entity_query, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_FB_spatial_entity_query")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_SPACE_COMPONENT_FILTER_INFO_FB\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_FB_spatial_entity_query\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_EVENT_DATA_SPACE_QUERY_RESULTS_AVAILABLE_FB:
            // Enum value XR_TYPE_EVENT_DATA_SPACE_QUERY_RESULTS_AVAILABLE_FB requires extension XR_FB_spatial_entity_query, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_FB_spatial_entity_query")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_EVENT_DATA_SPACE_QUERY_RESULTS_AVAILABLE_FB\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_FB_spatial_entity_query\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_EVENT_DATA_SPACE_QUERY_COMPLETE_FB:
            // Enum value XR_TYPE_EVENT_DATA_SPACE_QUERY_COMPLETE_FB requires extension XR_FB_spatial_entity_query, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_FB_spatial_entity_query")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_EVENT_DATA_SPACE_QUERY_COMPLETE_FB\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_FB_spatial_entity_query\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_SPACE_SAVE_INFO_FB:
            // Enum value XR_TYPE_SPACE_SAVE_INFO_FB requires extension XR_FB_spatial_entity_storage, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_FB_spatial_entity_storage")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_SPACE_SAVE_INFO_FB\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_FB_spatial_entity_storage\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_SPACE_ERASE_INFO_FB:
            // Enum value XR_TYPE_SPACE_ERASE_INFO_FB requires extension XR_FB_spatial_entity_storage, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_FB_spatial_entity_storage")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_SPACE_ERASE_INFO_FB\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_FB_spatial_entity_storage\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_EVENT_DATA_SPACE_SAVE_COMPLETE_FB:
            // Enum value XR_TYPE_EVENT_DATA_SPACE_SAVE_COMPLETE_FB requires extension XR_FB_spatial_entity_storage, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_FB_spatial_entity_storage")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_EVENT_DATA_SPACE_SAVE_COMPLETE_FB\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_FB_spatial_entity_storage\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_EVENT_DATA_SPACE_ERASE_COMPLETE_FB:
            // Enum value XR_TYPE_EVENT_DATA_SPACE_ERASE_COMPLETE_FB requires extension XR_FB_spatial_entity_storage, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_FB_spatial_entity_storage")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_EVENT_DATA_SPACE_ERASE_COMPLETE_FB\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_FB_spatial_entity_storage\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_SWAPCHAIN_IMAGE_FOVEATION_VULKAN_FB:
            // Enum value XR_TYPE_SWAPCHAIN_IMAGE_FOVEATION_VULKAN_FB requires extension XR_FB_foveation_vulkan, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_FB_foveation_vulkan")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_SWAPCHAIN_IMAGE_FOVEATION_VULKAN_FB\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_FB_foveation_vulkan\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_SWAPCHAIN_STATE_ANDROID_SURFACE_DIMENSIONS_FB:
            // Enum value XR_TYPE_SWAPCHAIN_STATE_ANDROID_SURFACE_DIMENSIONS_FB requires extension XR_FB_swapchain_update_state_android_surface, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_FB_swapchain_update_state_android_surface")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_SWAPCHAIN_STATE_ANDROID_SURFACE_DIMENSIONS_FB\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_FB_swapchain_update_state_android_surface\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_SWAPCHAIN_STATE_SAMPLER_OPENGL_ES_FB:
            // Enum value XR_TYPE_SWAPCHAIN_STATE_SAMPLER_OPENGL_ES_FB requires extension XR_FB_swapchain_update_state_opengl_es, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_FB_swapchain_update_state_opengl_es")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_SWAPCHAIN_STATE_SAMPLER_OPENGL_ES_FB\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_FB_swapchain_update_state_opengl_es\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_SWAPCHAIN_STATE_SAMPLER_VULKAN_FB:
            // Enum value XR_TYPE_SWAPCHAIN_STATE_SAMPLER_VULKAN_FB requires extension XR_FB_swapchain_update_state_vulkan, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_FB_swapchain_update_state_vulkan")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_SWAPCHAIN_STATE_SAMPLER_VULKAN_FB\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_FB_swapchain_update_state_vulkan\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_SPACE_SHARE_INFO_FB:
            // Enum value XR_TYPE_SPACE_SHARE_INFO_FB requires extension XR_FB_spatial_entity_sharing, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_FB_spatial_entity_sharing")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_SPACE_SHARE_INFO_FB\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_FB_spatial_entity_sharing\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_EVENT_DATA_SPACE_SHARE_COMPLETE_FB:
            // Enum value XR_TYPE_EVENT_DATA_SPACE_SHARE_COMPLETE_FB requires extension XR_FB_spatial_entity_sharing, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_FB_spatial_entity_sharing")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_EVENT_DATA_SPACE_SHARE_COMPLETE_FB\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_FB_spatial_entity_sharing\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_COMPOSITION_LAYER_SPACE_WARP_INFO_FB:
            // Enum value XR_TYPE_COMPOSITION_LAYER_SPACE_WARP_INFO_FB requires extension XR_FB_space_warp, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_FB_space_warp")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_COMPOSITION_LAYER_SPACE_WARP_INFO_FB\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_FB_space_warp\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_SYSTEM_SPACE_WARP_PROPERTIES_FB:
            // Enum value XR_TYPE_SYSTEM_SPACE_WARP_PROPERTIES_FB requires extension XR_FB_space_warp, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_FB_space_warp")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_SYSTEM_SPACE_WARP_PROPERTIES_FB\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_FB_space_warp\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_HAPTIC_AMPLITUDE_ENVELOPE_VIBRATION_FB:
            // Enum value XR_TYPE_HAPTIC_AMPLITUDE_ENVELOPE_VIBRATION_FB requires extension XR_FB_haptic_amplitude_envelope, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_FB_haptic_amplitude_envelope")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_HAPTIC_AMPLITUDE_ENVELOPE_VIBRATION_FB\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_FB_haptic_amplitude_envelope\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_SEMANTIC_LABELS_FB:
            // Enum value XR_TYPE_SEMANTIC_LABELS_FB requires extension XR_FB_scene, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_FB_scene")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_SEMANTIC_LABELS_FB\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_FB_scene\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_ROOM_LAYOUT_FB:
            // Enum value XR_TYPE_ROOM_LAYOUT_FB requires extension XR_FB_scene, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_FB_scene")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_ROOM_LAYOUT_FB\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_FB_scene\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_BOUNDARY_2D_FB:
            // Enum value XR_TYPE_BOUNDARY_2D_FB requires extension XR_FB_scene, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_FB_scene")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_BOUNDARY_2D_FB\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_FB_scene\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_SEMANTIC_LABELS_SUPPORT_INFO_FB:
            // Enum value XR_TYPE_SEMANTIC_LABELS_SUPPORT_INFO_FB requires extension XR_FB_scene, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_FB_scene")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_SEMANTIC_LABELS_SUPPORT_INFO_FB\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_FB_scene\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_DIGITAL_LENS_CONTROL_ALMALENCE:
            // Enum value XR_TYPE_DIGITAL_LENS_CONTROL_ALMALENCE requires extension XR_ALMALENCE_digital_lens_control, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_ALMALENCE_digital_lens_control")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_DIGITAL_LENS_CONTROL_ALMALENCE\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_ALMALENCE_digital_lens_control\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_EVENT_DATA_SCENE_CAPTURE_COMPLETE_FB:
            // Enum value XR_TYPE_EVENT_DATA_SCENE_CAPTURE_COMPLETE_FB requires extension XR_FB_scene_capture, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_FB_scene_capture")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_EVENT_DATA_SCENE_CAPTURE_COMPLETE_FB\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_FB_scene_capture\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_SCENE_CAPTURE_REQUEST_INFO_FB:
            // Enum value XR_TYPE_SCENE_CAPTURE_REQUEST_INFO_FB requires extension XR_FB_scene_capture, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_FB_scene_capture")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_SCENE_CAPTURE_REQUEST_INFO_FB\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_FB_scene_capture\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_SPACE_CONTAINER_FB:
            // Enum value XR_TYPE_SPACE_CONTAINER_FB requires extension XR_FB_spatial_entity_container, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_FB_spatial_entity_container")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_SPACE_CONTAINER_FB\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_FB_spatial_entity_container\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_FOVEATION_EYE_TRACKED_PROFILE_CREATE_INFO_META:
            // Enum value XR_TYPE_FOVEATION_EYE_TRACKED_PROFILE_CREATE_INFO_META requires extension XR_META_foveation_eye_tracked, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_META_foveation_eye_tracked")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_FOVEATION_EYE_TRACKED_PROFILE_CREATE_INFO_META\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_META_foveation_eye_tracked\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_FOVEATION_EYE_TRACKED_STATE_META:
            // Enum value XR_TYPE_FOVEATION_EYE_TRACKED_STATE_META requires extension XR_META_foveation_eye_tracked, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_META_foveation_eye_tracked")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_FOVEATION_EYE_TRACKED_STATE_META\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_META_foveation_eye_tracked\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_SYSTEM_FOVEATION_EYE_TRACKED_PROPERTIES_META:
            // Enum value XR_TYPE_SYSTEM_FOVEATION_EYE_TRACKED_PROPERTIES_META requires extension XR_META_foveation_eye_tracked, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_META_foveation_eye_tracked")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_SYSTEM_FOVEATION_EYE_TRACKED_PROPERTIES_META\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_META_foveation_eye_tracked\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_SYSTEM_FACE_TRACKING_PROPERTIES_FB:
            // Enum value XR_TYPE_SYSTEM_FACE_TRACKING_PROPERTIES_FB requires extension XR_FB_face_tracking, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_FB_face_tracking")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_SYSTEM_FACE_TRACKING_PROPERTIES_FB\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_FB_face_tracking\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_FACE_TRACKER_CREATE_INFO_FB:
            // Enum value XR_TYPE_FACE_TRACKER_CREATE_INFO_FB requires extension XR_FB_face_tracking, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_FB_face_tracking")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_FACE_TRACKER_CREATE_INFO_FB\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_FB_face_tracking\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_FACE_EXPRESSION_INFO_FB:
            // Enum value XR_TYPE_FACE_EXPRESSION_INFO_FB requires extension XR_FB_face_tracking, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_FB_face_tracking")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_FACE_EXPRESSION_INFO_FB\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_FB_face_tracking\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_FACE_EXPRESSION_WEIGHTS_FB:
            // Enum value XR_TYPE_FACE_EXPRESSION_WEIGHTS_FB requires extension XR_FB_face_tracking, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_FB_face_tracking")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_FACE_EXPRESSION_WEIGHTS_FB\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_FB_face_tracking\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_EYE_TRACKER_CREATE_INFO_FB:
            // Enum value XR_TYPE_EYE_TRACKER_CREATE_INFO_FB requires extension XR_FB_eye_tracking_social, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_FB_eye_tracking_social")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_EYE_TRACKER_CREATE_INFO_FB\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_FB_eye_tracking_social\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_EYE_GAZES_INFO_FB:
            // Enum value XR_TYPE_EYE_GAZES_INFO_FB requires extension XR_FB_eye_tracking_social, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_FB_eye_tracking_social")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_EYE_GAZES_INFO_FB\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_FB_eye_tracking_social\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_EYE_GAZES_FB:
            // Enum value XR_TYPE_EYE_GAZES_FB requires extension XR_FB_eye_tracking_social, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_FB_eye_tracking_social")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_EYE_GAZES_FB\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_FB_eye_tracking_social\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_SYSTEM_EYE_TRACKING_PROPERTIES_FB:
            // Enum value XR_TYPE_SYSTEM_EYE_TRACKING_PROPERTIES_FB requires extension XR_FB_eye_tracking_social, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_FB_eye_tracking_social")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_SYSTEM_EYE_TRACKING_PROPERTIES_FB\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_FB_eye_tracking_social\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_PASSTHROUGH_KEYBOARD_HANDS_INTENSITY_FB:
            // Enum value XR_TYPE_PASSTHROUGH_KEYBOARD_HANDS_INTENSITY_FB requires extension XR_FB_passthrough_keyboard_hands, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_FB_passthrough_keyboard_hands")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_PASSTHROUGH_KEYBOARD_HANDS_INTENSITY_FB\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_FB_passthrough_keyboard_hands\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_COMPOSITION_LAYER_SETTINGS_FB:
            // Enum value XR_TYPE_COMPOSITION_LAYER_SETTINGS_FB requires extension XR_FB_composition_layer_settings, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_FB_composition_layer_settings")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_COMPOSITION_LAYER_SETTINGS_FB\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_FB_composition_layer_settings\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_HAPTIC_PCM_VIBRATION_FB:
            // Enum value XR_TYPE_HAPTIC_PCM_VIBRATION_FB requires extension XR_FB_haptic_pcm, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_FB_haptic_pcm")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_HAPTIC_PCM_VIBRATION_FB\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_FB_haptic_pcm\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_DEVICE_PCM_SAMPLE_RATE_STATE_FB:
            // Enum value XR_TYPE_DEVICE_PCM_SAMPLE_RATE_STATE_FB requires extension XR_FB_haptic_pcm, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_FB_haptic_pcm")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_DEVICE_PCM_SAMPLE_RATE_STATE_FB\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_FB_haptic_pcm\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_FRAME_SYNTHESIS_INFO_EXT:
            // Enum value XR_TYPE_FRAME_SYNTHESIS_INFO_EXT requires extension XR_EXT_frame_synthesis, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_EXT_frame_synthesis")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_FRAME_SYNTHESIS_INFO_EXT\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_EXT_frame_synthesis\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_FRAME_SYNTHESIS_CONFIG_VIEW_EXT:
            // Enum value XR_TYPE_FRAME_SYNTHESIS_CONFIG_VIEW_EXT requires extension XR_EXT_frame_synthesis, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_EXT_frame_synthesis")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_FRAME_SYNTHESIS_CONFIG_VIEW_EXT\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_EXT_frame_synthesis\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_COMPOSITION_LAYER_DEPTH_TEST_FB:
            // Enum value XR_TYPE_COMPOSITION_LAYER_DEPTH_TEST_FB requires extension XR_FB_composition_layer_depth_test, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_FB_composition_layer_depth_test")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_COMPOSITION_LAYER_DEPTH_TEST_FB\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_FB_composition_layer_depth_test\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_LOCAL_DIMMING_FRAME_END_INFO_META:
            // Enum value XR_TYPE_LOCAL_DIMMING_FRAME_END_INFO_META requires extension XR_META_local_dimming, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_META_local_dimming")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_LOCAL_DIMMING_FRAME_END_INFO_META\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_META_local_dimming\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_PASSTHROUGH_PREFERENCES_META:
            // Enum value XR_TYPE_PASSTHROUGH_PREFERENCES_META requires extension XR_META_passthrough_preferences, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_META_passthrough_preferences")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_PASSTHROUGH_PREFERENCES_META\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_META_passthrough_preferences\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_SYSTEM_VIRTUAL_KEYBOARD_PROPERTIES_META:
            // Enum value XR_TYPE_SYSTEM_VIRTUAL_KEYBOARD_PROPERTIES_META requires extension XR_META_virtual_keyboard, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_META_virtual_keyboard")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_SYSTEM_VIRTUAL_KEYBOARD_PROPERTIES_META\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_META_virtual_keyboard\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_VIRTUAL_KEYBOARD_CREATE_INFO_META:
            // Enum value XR_TYPE_VIRTUAL_KEYBOARD_CREATE_INFO_META requires extension XR_META_virtual_keyboard, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_META_virtual_keyboard")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_VIRTUAL_KEYBOARD_CREATE_INFO_META\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_META_virtual_keyboard\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_VIRTUAL_KEYBOARD_SPACE_CREATE_INFO_META:
            // Enum value XR_TYPE_VIRTUAL_KEYBOARD_SPACE_CREATE_INFO_META requires extension XR_META_virtual_keyboard, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_META_virtual_keyboard")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_VIRTUAL_KEYBOARD_SPACE_CREATE_INFO_META\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_META_virtual_keyboard\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_VIRTUAL_KEYBOARD_LOCATION_INFO_META:
            // Enum value XR_TYPE_VIRTUAL_KEYBOARD_LOCATION_INFO_META requires extension XR_META_virtual_keyboard, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_META_virtual_keyboard")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_VIRTUAL_KEYBOARD_LOCATION_INFO_META\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_META_virtual_keyboard\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_VIRTUAL_KEYBOARD_MODEL_VISIBILITY_SET_INFO_META:
            // Enum value XR_TYPE_VIRTUAL_KEYBOARD_MODEL_VISIBILITY_SET_INFO_META requires extension XR_META_virtual_keyboard, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_META_virtual_keyboard")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_VIRTUAL_KEYBOARD_MODEL_VISIBILITY_SET_INFO_META\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_META_virtual_keyboard\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_VIRTUAL_KEYBOARD_ANIMATION_STATE_META:
            // Enum value XR_TYPE_VIRTUAL_KEYBOARD_ANIMATION_STATE_META requires extension XR_META_virtual_keyboard, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_META_virtual_keyboard")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_VIRTUAL_KEYBOARD_ANIMATION_STATE_META\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_META_virtual_keyboard\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_VIRTUAL_KEYBOARD_MODEL_ANIMATION_STATES_META:
            // Enum value XR_TYPE_VIRTUAL_KEYBOARD_MODEL_ANIMATION_STATES_META requires extension XR_META_virtual_keyboard, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_META_virtual_keyboard")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_VIRTUAL_KEYBOARD_MODEL_ANIMATION_STATES_META\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_META_virtual_keyboard\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_VIRTUAL_KEYBOARD_TEXTURE_DATA_META:
            // Enum value XR_TYPE_VIRTUAL_KEYBOARD_TEXTURE_DATA_META requires extension XR_META_virtual_keyboard, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_META_virtual_keyboard")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_VIRTUAL_KEYBOARD_TEXTURE_DATA_META\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_META_virtual_keyboard\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_VIRTUAL_KEYBOARD_INPUT_INFO_META:
            // Enum value XR_TYPE_VIRTUAL_KEYBOARD_INPUT_INFO_META requires extension XR_META_virtual_keyboard, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_META_virtual_keyboard")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_VIRTUAL_KEYBOARD_INPUT_INFO_META\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_META_virtual_keyboard\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_VIRTUAL_KEYBOARD_TEXT_CONTEXT_CHANGE_INFO_META:
            // Enum value XR_TYPE_VIRTUAL_KEYBOARD_TEXT_CONTEXT_CHANGE_INFO_META requires extension XR_META_virtual_keyboard, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_META_virtual_keyboard")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_VIRTUAL_KEYBOARD_TEXT_CONTEXT_CHANGE_INFO_META\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_META_virtual_keyboard\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_EVENT_DATA_VIRTUAL_KEYBOARD_COMMIT_TEXT_META:
            // Enum value XR_TYPE_EVENT_DATA_VIRTUAL_KEYBOARD_COMMIT_TEXT_META requires extension XR_META_virtual_keyboard, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_META_virtual_keyboard")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_EVENT_DATA_VIRTUAL_KEYBOARD_COMMIT_TEXT_META\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_META_virtual_keyboard\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_EVENT_DATA_VIRTUAL_KEYBOARD_BACKSPACE_META:
            // Enum value XR_TYPE_EVENT_DATA_VIRTUAL_KEYBOARD_BACKSPACE_META requires extension XR_META_virtual_keyboard, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_META_virtual_keyboard")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_EVENT_DATA_VIRTUAL_KEYBOARD_BACKSPACE_META\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_META_virtual_keyboard\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_EVENT_DATA_VIRTUAL_KEYBOARD_ENTER_META:
            // Enum value XR_TYPE_EVENT_DATA_VIRTUAL_KEYBOARD_ENTER_META requires extension XR_META_virtual_keyboard, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_META_virtual_keyboard")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_EVENT_DATA_VIRTUAL_KEYBOARD_ENTER_META\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_META_virtual_keyboard\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_EVENT_DATA_VIRTUAL_KEYBOARD_SHOWN_META:
            // Enum value XR_TYPE_EVENT_DATA_VIRTUAL_KEYBOARD_SHOWN_META requires extension XR_META_virtual_keyboard, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_META_virtual_keyboard")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_EVENT_DATA_VIRTUAL_KEYBOARD_SHOWN_META\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_META_virtual_keyboard\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_EVENT_DATA_VIRTUAL_KEYBOARD_HIDDEN_META:
            // Enum value XR_TYPE_EVENT_DATA_VIRTUAL_KEYBOARD_HIDDEN_META requires extension XR_META_virtual_keyboard, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_META_virtual_keyboard")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_EVENT_DATA_VIRTUAL_KEYBOARD_HIDDEN_META\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_META_virtual_keyboard\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_EXTERNAL_CAMERA_OCULUS:
            // Enum value XR_TYPE_EXTERNAL_CAMERA_OCULUS requires extension XR_OCULUS_external_camera, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_OCULUS_external_camera")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_EXTERNAL_CAMERA_OCULUS\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_OCULUS_external_camera\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_VULKAN_SWAPCHAIN_CREATE_INFO_META:
            // Enum value XR_TYPE_VULKAN_SWAPCHAIN_CREATE_INFO_META requires extension XR_META_vulkan_swapchain_create_info, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_META_vulkan_swapchain_create_info")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_VULKAN_SWAPCHAIN_CREATE_INFO_META\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_META_vulkan_swapchain_create_info\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_PERFORMANCE_METRICS_STATE_META:
            // Enum value XR_TYPE_PERFORMANCE_METRICS_STATE_META requires extension XR_META_performance_metrics, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_META_performance_metrics")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_PERFORMANCE_METRICS_STATE_META\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_META_performance_metrics\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_PERFORMANCE_METRICS_COUNTER_META:
            // Enum value XR_TYPE_PERFORMANCE_METRICS_COUNTER_META requires extension XR_META_performance_metrics, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_META_performance_metrics")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_PERFORMANCE_METRICS_COUNTER_META\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_META_performance_metrics\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_SPACE_LIST_SAVE_INFO_FB:
            // Enum value XR_TYPE_SPACE_LIST_SAVE_INFO_FB requires extension XR_FB_spatial_entity_storage_batch, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_FB_spatial_entity_storage_batch")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_SPACE_LIST_SAVE_INFO_FB\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_FB_spatial_entity_storage_batch\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_EVENT_DATA_SPACE_LIST_SAVE_COMPLETE_FB:
            // Enum value XR_TYPE_EVENT_DATA_SPACE_LIST_SAVE_COMPLETE_FB requires extension XR_FB_spatial_entity_storage_batch, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_FB_spatial_entity_storage_batch")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_EVENT_DATA_SPACE_LIST_SAVE_COMPLETE_FB\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_FB_spatial_entity_storage_batch\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_SPACE_USER_CREATE_INFO_FB:
            // Enum value XR_TYPE_SPACE_USER_CREATE_INFO_FB requires extension XR_FB_spatial_entity_user, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_FB_spatial_entity_user")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_SPACE_USER_CREATE_INFO_FB\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_FB_spatial_entity_user\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_SYSTEM_HEADSET_ID_PROPERTIES_META:
            // Enum value XR_TYPE_SYSTEM_HEADSET_ID_PROPERTIES_META requires extension XR_META_headset_id, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_META_headset_id")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_SYSTEM_HEADSET_ID_PROPERTIES_META\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_META_headset_id\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_RECOMMENDED_LAYER_RESOLUTION_META:
            // Enum value XR_TYPE_RECOMMENDED_LAYER_RESOLUTION_META requires extension XR_META_recommended_layer_resolution, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_META_recommended_layer_resolution")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_RECOMMENDED_LAYER_RESOLUTION_META\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_META_recommended_layer_resolution\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_RECOMMENDED_LAYER_RESOLUTION_GET_INFO_META:
            // Enum value XR_TYPE_RECOMMENDED_LAYER_RESOLUTION_GET_INFO_META requires extension XR_META_recommended_layer_resolution, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_META_recommended_layer_resolution")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_RECOMMENDED_LAYER_RESOLUTION_GET_INFO_META\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_META_recommended_layer_resolution\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_SYSTEM_SPACE_PERSISTENCE_PROPERTIES_META:
            // Enum value XR_TYPE_SYSTEM_SPACE_PERSISTENCE_PROPERTIES_META requires extension XR_META_spatial_entity_persistence, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_META_spatial_entity_persistence")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_SYSTEM_SPACE_PERSISTENCE_PROPERTIES_META\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_META_spatial_entity_persistence\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_SPACES_SAVE_INFO_META:
            // Enum value XR_TYPE_SPACES_SAVE_INFO_META requires extension XR_META_spatial_entity_persistence, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_META_spatial_entity_persistence")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_SPACES_SAVE_INFO_META\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_META_spatial_entity_persistence\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_EVENT_DATA_SPACES_SAVE_RESULT_META:
            // Enum value XR_TYPE_EVENT_DATA_SPACES_SAVE_RESULT_META requires extension XR_META_spatial_entity_persistence, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_META_spatial_entity_persistence")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_EVENT_DATA_SPACES_SAVE_RESULT_META\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_META_spatial_entity_persistence\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_SPACES_ERASE_INFO_META:
            // Enum value XR_TYPE_SPACES_ERASE_INFO_META requires extension XR_META_spatial_entity_persistence, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_META_spatial_entity_persistence")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_SPACES_ERASE_INFO_META\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_META_spatial_entity_persistence\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_EVENT_DATA_SPACES_ERASE_RESULT_META:
            // Enum value XR_TYPE_EVENT_DATA_SPACES_ERASE_RESULT_META requires extension XR_META_spatial_entity_persistence, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_META_spatial_entity_persistence")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_EVENT_DATA_SPACES_ERASE_RESULT_META\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_META_spatial_entity_persistence\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_SYSTEM_PASSTHROUGH_COLOR_LUT_PROPERTIES_META:
            // Enum value XR_TYPE_SYSTEM_PASSTHROUGH_COLOR_LUT_PROPERTIES_META requires extension XR_META_passthrough_color_lut, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_META_passthrough_color_lut")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_SYSTEM_PASSTHROUGH_COLOR_LUT_PROPERTIES_META\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_META_passthrough_color_lut\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_PASSTHROUGH_COLOR_LUT_CREATE_INFO_META:
            // Enum value XR_TYPE_PASSTHROUGH_COLOR_LUT_CREATE_INFO_META requires extension XR_META_passthrough_color_lut, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_META_passthrough_color_lut")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_PASSTHROUGH_COLOR_LUT_CREATE_INFO_META\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_META_passthrough_color_lut\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_PASSTHROUGH_COLOR_LUT_UPDATE_INFO_META:
            // Enum value XR_TYPE_PASSTHROUGH_COLOR_LUT_UPDATE_INFO_META requires extension XR_META_passthrough_color_lut, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_META_passthrough_color_lut")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_PASSTHROUGH_COLOR_LUT_UPDATE_INFO_META\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_META_passthrough_color_lut\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_PASSTHROUGH_COLOR_MAP_LUT_META:
            // Enum value XR_TYPE_PASSTHROUGH_COLOR_MAP_LUT_META requires extension XR_META_passthrough_color_lut, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_META_passthrough_color_lut")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_PASSTHROUGH_COLOR_MAP_LUT_META\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_META_passthrough_color_lut\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_PASSTHROUGH_COLOR_MAP_INTERPOLATED_LUT_META:
            // Enum value XR_TYPE_PASSTHROUGH_COLOR_MAP_INTERPOLATED_LUT_META requires extension XR_META_passthrough_color_lut, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_META_passthrough_color_lut")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_PASSTHROUGH_COLOR_MAP_INTERPOLATED_LUT_META\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_META_passthrough_color_lut\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_SPACE_TRIANGLE_MESH_GET_INFO_META:
            // Enum value XR_TYPE_SPACE_TRIANGLE_MESH_GET_INFO_META requires extension XR_META_spatial_entity_mesh, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_META_spatial_entity_mesh")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_SPACE_TRIANGLE_MESH_GET_INFO_META\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_META_spatial_entity_mesh\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_SPACE_TRIANGLE_MESH_META:
            // Enum value XR_TYPE_SPACE_TRIANGLE_MESH_META requires extension XR_META_spatial_entity_mesh, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_META_spatial_entity_mesh")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_SPACE_TRIANGLE_MESH_META\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_META_spatial_entity_mesh\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_SYSTEM_PROPERTIES_BODY_TRACKING_FULL_BODY_META:
            // Enum value XR_TYPE_SYSTEM_PROPERTIES_BODY_TRACKING_FULL_BODY_META requires extension XR_META_body_tracking_full_body, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_META_body_tracking_full_body")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_SYSTEM_PROPERTIES_BODY_TRACKING_FULL_BODY_META\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_META_body_tracking_full_body\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_EVENT_DATA_PASSTHROUGH_LAYER_RESUMED_META:
            // Enum value XR_TYPE_EVENT_DATA_PASSTHROUGH_LAYER_RESUMED_META requires extension XR_META_passthrough_layer_resumed_event, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_META_passthrough_layer_resumed_event")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_EVENT_DATA_PASSTHROUGH_LAYER_RESUMED_META\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_META_passthrough_layer_resumed_event\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_BODY_TRACKING_CALIBRATION_INFO_META:
            // Enum value XR_TYPE_BODY_TRACKING_CALIBRATION_INFO_META requires extension XR_META_body_tracking_calibration, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_META_body_tracking_calibration")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_BODY_TRACKING_CALIBRATION_INFO_META\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_META_body_tracking_calibration\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_BODY_TRACKING_CALIBRATION_STATUS_META:
            // Enum value XR_TYPE_BODY_TRACKING_CALIBRATION_STATUS_META requires extension XR_META_body_tracking_calibration, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_META_body_tracking_calibration")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_BODY_TRACKING_CALIBRATION_STATUS_META\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_META_body_tracking_calibration\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_SYSTEM_PROPERTIES_BODY_TRACKING_CALIBRATION_META:
            // Enum value XR_TYPE_SYSTEM_PROPERTIES_BODY_TRACKING_CALIBRATION_META requires extension XR_META_body_tracking_calibration, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_META_body_tracking_calibration")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_SYSTEM_PROPERTIES_BODY_TRACKING_CALIBRATION_META\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_META_body_tracking_calibration\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_SYSTEM_FACE_TRACKING_PROPERTIES2_FB:
            // Enum value XR_TYPE_SYSTEM_FACE_TRACKING_PROPERTIES2_FB requires extension XR_FB_face_tracking2, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_FB_face_tracking2")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_SYSTEM_FACE_TRACKING_PROPERTIES2_FB\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_FB_face_tracking2\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_FACE_TRACKER_CREATE_INFO2_FB:
            // Enum value XR_TYPE_FACE_TRACKER_CREATE_INFO2_FB requires extension XR_FB_face_tracking2, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_FB_face_tracking2")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_FACE_TRACKER_CREATE_INFO2_FB\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_FB_face_tracking2\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_FACE_EXPRESSION_INFO2_FB:
            // Enum value XR_TYPE_FACE_EXPRESSION_INFO2_FB requires extension XR_FB_face_tracking2, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_FB_face_tracking2")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_FACE_EXPRESSION_INFO2_FB\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_FB_face_tracking2\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_FACE_EXPRESSION_WEIGHTS2_FB:
            // Enum value XR_TYPE_FACE_EXPRESSION_WEIGHTS2_FB requires extension XR_FB_face_tracking2, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_FB_face_tracking2")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_FACE_EXPRESSION_WEIGHTS2_FB\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_FB_face_tracking2\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_SYSTEM_SPATIAL_ENTITY_SHARING_PROPERTIES_META:
            // Enum value XR_TYPE_SYSTEM_SPATIAL_ENTITY_SHARING_PROPERTIES_META requires extension XR_META_spatial_entity_sharing, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_META_spatial_entity_sharing")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_SYSTEM_SPATIAL_ENTITY_SHARING_PROPERTIES_META\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_META_spatial_entity_sharing\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_SHARE_SPACES_INFO_META:
            // Enum value XR_TYPE_SHARE_SPACES_INFO_META requires extension XR_META_spatial_entity_sharing, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_META_spatial_entity_sharing")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_SHARE_SPACES_INFO_META\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_META_spatial_entity_sharing\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_EVENT_DATA_SHARE_SPACES_COMPLETE_META:
            // Enum value XR_TYPE_EVENT_DATA_SHARE_SPACES_COMPLETE_META requires extension XR_META_spatial_entity_sharing, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_META_spatial_entity_sharing")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_EVENT_DATA_SHARE_SPACES_COMPLETE_META\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_META_spatial_entity_sharing\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_ENVIRONMENT_DEPTH_PROVIDER_CREATE_INFO_META:
            // Enum value XR_TYPE_ENVIRONMENT_DEPTH_PROVIDER_CREATE_INFO_META requires extension XR_META_environment_depth, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_META_environment_depth")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_ENVIRONMENT_DEPTH_PROVIDER_CREATE_INFO_META\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_META_environment_depth\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_ENVIRONMENT_DEPTH_SWAPCHAIN_CREATE_INFO_META:
            // Enum value XR_TYPE_ENVIRONMENT_DEPTH_SWAPCHAIN_CREATE_INFO_META requires extension XR_META_environment_depth, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_META_environment_depth")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_ENVIRONMENT_DEPTH_SWAPCHAIN_CREATE_INFO_META\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_META_environment_depth\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_ENVIRONMENT_DEPTH_SWAPCHAIN_STATE_META:
            // Enum value XR_TYPE_ENVIRONMENT_DEPTH_SWAPCHAIN_STATE_META requires extension XR_META_environment_depth, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_META_environment_depth")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_ENVIRONMENT_DEPTH_SWAPCHAIN_STATE_META\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_META_environment_depth\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_ENVIRONMENT_DEPTH_IMAGE_ACQUIRE_INFO_META:
            // Enum value XR_TYPE_ENVIRONMENT_DEPTH_IMAGE_ACQUIRE_INFO_META requires extension XR_META_environment_depth, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_META_environment_depth")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_ENVIRONMENT_DEPTH_IMAGE_ACQUIRE_INFO_META\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_META_environment_depth\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_ENVIRONMENT_DEPTH_IMAGE_VIEW_META:
            // Enum value XR_TYPE_ENVIRONMENT_DEPTH_IMAGE_VIEW_META requires extension XR_META_environment_depth, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_META_environment_depth")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_ENVIRONMENT_DEPTH_IMAGE_VIEW_META\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_META_environment_depth\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_ENVIRONMENT_DEPTH_IMAGE_META:
            // Enum value XR_TYPE_ENVIRONMENT_DEPTH_IMAGE_META requires extension XR_META_environment_depth, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_META_environment_depth")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_ENVIRONMENT_DEPTH_IMAGE_META\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_META_environment_depth\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_ENVIRONMENT_DEPTH_HAND_REMOVAL_SET_INFO_META:
            // Enum value XR_TYPE_ENVIRONMENT_DEPTH_HAND_REMOVAL_SET_INFO_META requires extension XR_META_environment_depth, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_META_environment_depth")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_ENVIRONMENT_DEPTH_HAND_REMOVAL_SET_INFO_META\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_META_environment_depth\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_SYSTEM_ENVIRONMENT_DEPTH_PROPERTIES_META:
            // Enum value XR_TYPE_SYSTEM_ENVIRONMENT_DEPTH_PROPERTIES_META requires extension XR_META_environment_depth, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_META_environment_depth")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_SYSTEM_ENVIRONMENT_DEPTH_PROPERTIES_META\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_META_environment_depth\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_RENDER_MODEL_CREATE_INFO_EXT:
            // Enum value XR_TYPE_RENDER_MODEL_CREATE_INFO_EXT requires extension XR_EXT_render_model, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_EXT_render_model")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_RENDER_MODEL_CREATE_INFO_EXT\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_EXT_render_model\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_RENDER_MODEL_PROPERTIES_GET_INFO_EXT:
            // Enum value XR_TYPE_RENDER_MODEL_PROPERTIES_GET_INFO_EXT requires extension XR_EXT_render_model, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_EXT_render_model")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_RENDER_MODEL_PROPERTIES_GET_INFO_EXT\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_EXT_render_model\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_RENDER_MODEL_PROPERTIES_EXT:
            // Enum value XR_TYPE_RENDER_MODEL_PROPERTIES_EXT requires extension XR_EXT_render_model, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_EXT_render_model")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_RENDER_MODEL_PROPERTIES_EXT\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_EXT_render_model\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_RENDER_MODEL_SPACE_CREATE_INFO_EXT:
            // Enum value XR_TYPE_RENDER_MODEL_SPACE_CREATE_INFO_EXT requires extension XR_EXT_render_model, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_EXT_render_model")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_RENDER_MODEL_SPACE_CREATE_INFO_EXT\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_EXT_render_model\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_RENDER_MODEL_STATE_GET_INFO_EXT:
            // Enum value XR_TYPE_RENDER_MODEL_STATE_GET_INFO_EXT requires extension XR_EXT_render_model, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_EXT_render_model")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_RENDER_MODEL_STATE_GET_INFO_EXT\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_EXT_render_model\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_RENDER_MODEL_STATE_EXT:
            // Enum value XR_TYPE_RENDER_MODEL_STATE_EXT requires extension XR_EXT_render_model, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_EXT_render_model")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_RENDER_MODEL_STATE_EXT\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_EXT_render_model\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_RENDER_MODEL_ASSET_CREATE_INFO_EXT:
            // Enum value XR_TYPE_RENDER_MODEL_ASSET_CREATE_INFO_EXT requires extension XR_EXT_render_model, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_EXT_render_model")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_RENDER_MODEL_ASSET_CREATE_INFO_EXT\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_EXT_render_model\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_RENDER_MODEL_ASSET_DATA_GET_INFO_EXT:
            // Enum value XR_TYPE_RENDER_MODEL_ASSET_DATA_GET_INFO_EXT requires extension XR_EXT_render_model, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_EXT_render_model")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_RENDER_MODEL_ASSET_DATA_GET_INFO_EXT\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_EXT_render_model\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_RENDER_MODEL_ASSET_DATA_EXT:
            // Enum value XR_TYPE_RENDER_MODEL_ASSET_DATA_EXT requires extension XR_EXT_render_model, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_EXT_render_model")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_RENDER_MODEL_ASSET_DATA_EXT\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_EXT_render_model\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_RENDER_MODEL_ASSET_PROPERTIES_GET_INFO_EXT:
            // Enum value XR_TYPE_RENDER_MODEL_ASSET_PROPERTIES_GET_INFO_EXT requires extension XR_EXT_render_model, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_EXT_render_model")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_RENDER_MODEL_ASSET_PROPERTIES_GET_INFO_EXT\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_EXT_render_model\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_RENDER_MODEL_ASSET_PROPERTIES_EXT:
            // Enum value XR_TYPE_RENDER_MODEL_ASSET_PROPERTIES_EXT requires extension XR_EXT_render_model, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_EXT_render_model")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_RENDER_MODEL_ASSET_PROPERTIES_EXT\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_EXT_render_model\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_INTERACTION_RENDER_MODEL_IDS_ENUMERATE_INFO_EXT:
            // Enum value XR_TYPE_INTERACTION_RENDER_MODEL_IDS_ENUMERATE_INFO_EXT requires extension XR_EXT_interaction_render_model, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_EXT_interaction_render_model")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_INTERACTION_RENDER_MODEL_IDS_ENUMERATE_INFO_EXT\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_EXT_interaction_render_model\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_INTERACTION_RENDER_MODEL_SUBACTION_PATH_INFO_EXT:
            // Enum value XR_TYPE_INTERACTION_RENDER_MODEL_SUBACTION_PATH_INFO_EXT requires extension XR_EXT_interaction_render_model, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_EXT_interaction_render_model")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_INTERACTION_RENDER_MODEL_SUBACTION_PATH_INFO_EXT\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_EXT_interaction_render_model\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_EVENT_DATA_INTERACTION_RENDER_MODELS_CHANGED_EXT:
            // Enum value XR_TYPE_EVENT_DATA_INTERACTION_RENDER_MODELS_CHANGED_EXT requires extension XR_EXT_interaction_render_model, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_EXT_interaction_render_model")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_EVENT_DATA_INTERACTION_RENDER_MODELS_CHANGED_EXT\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_EXT_interaction_render_model\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_INTERACTION_RENDER_MODEL_TOP_LEVEL_USER_PATH_GET_INFO_EXT:
            // Enum value XR_TYPE_INTERACTION_RENDER_MODEL_TOP_LEVEL_USER_PATH_GET_INFO_EXT requires extension XR_EXT_interaction_render_model, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_EXT_interaction_render_model")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_INTERACTION_RENDER_MODEL_TOP_LEVEL_USER_PATH_GET_INFO_EXT\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_EXT_interaction_render_model\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_PASSTHROUGH_CREATE_INFO_HTC:
            // Enum value XR_TYPE_PASSTHROUGH_CREATE_INFO_HTC requires extension XR_HTC_passthrough, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_HTC_passthrough")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_PASSTHROUGH_CREATE_INFO_HTC\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_HTC_passthrough\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_PASSTHROUGH_COLOR_HTC:
            // Enum value XR_TYPE_PASSTHROUGH_COLOR_HTC requires extension XR_HTC_passthrough, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_HTC_passthrough")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_PASSTHROUGH_COLOR_HTC\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_HTC_passthrough\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_PASSTHROUGH_MESH_TRANSFORM_INFO_HTC:
            // Enum value XR_TYPE_PASSTHROUGH_MESH_TRANSFORM_INFO_HTC requires extension XR_HTC_passthrough, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_HTC_passthrough")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_PASSTHROUGH_MESH_TRANSFORM_INFO_HTC\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_HTC_passthrough\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_COMPOSITION_LAYER_PASSTHROUGH_HTC:
            // Enum value XR_TYPE_COMPOSITION_LAYER_PASSTHROUGH_HTC requires extension XR_HTC_passthrough, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_HTC_passthrough")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_COMPOSITION_LAYER_PASSTHROUGH_HTC\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_HTC_passthrough\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_FOVEATION_APPLY_INFO_HTC:
            // Enum value XR_TYPE_FOVEATION_APPLY_INFO_HTC requires extension XR_HTC_foveation, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_HTC_foveation")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_FOVEATION_APPLY_INFO_HTC\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_HTC_foveation\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_FOVEATION_DYNAMIC_MODE_INFO_HTC:
            // Enum value XR_TYPE_FOVEATION_DYNAMIC_MODE_INFO_HTC requires extension XR_HTC_foveation, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_HTC_foveation")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_FOVEATION_DYNAMIC_MODE_INFO_HTC\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_HTC_foveation\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_FOVEATION_CUSTOM_MODE_INFO_HTC:
            // Enum value XR_TYPE_FOVEATION_CUSTOM_MODE_INFO_HTC requires extension XR_HTC_foveation, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_HTC_foveation")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_FOVEATION_CUSTOM_MODE_INFO_HTC\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_HTC_foveation\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_SYSTEM_ANCHOR_PROPERTIES_HTC:
            // Enum value XR_TYPE_SYSTEM_ANCHOR_PROPERTIES_HTC requires extension XR_HTC_anchor, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_HTC_anchor")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_SYSTEM_ANCHOR_PROPERTIES_HTC\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_HTC_anchor\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_SPATIAL_ANCHOR_CREATE_INFO_HTC:
            // Enum value XR_TYPE_SPATIAL_ANCHOR_CREATE_INFO_HTC requires extension XR_HTC_anchor, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_HTC_anchor")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_SPATIAL_ANCHOR_CREATE_INFO_HTC\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_HTC_anchor\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_SYSTEM_BODY_TRACKING_PROPERTIES_HTC:
            // Enum value XR_TYPE_SYSTEM_BODY_TRACKING_PROPERTIES_HTC requires extension XR_HTC_body_tracking, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_HTC_body_tracking")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_SYSTEM_BODY_TRACKING_PROPERTIES_HTC\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_HTC_body_tracking\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_BODY_TRACKER_CREATE_INFO_HTC:
            // Enum value XR_TYPE_BODY_TRACKER_CREATE_INFO_HTC requires extension XR_HTC_body_tracking, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_HTC_body_tracking")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_BODY_TRACKER_CREATE_INFO_HTC\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_HTC_body_tracking\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_BODY_JOINTS_LOCATE_INFO_HTC:
            // Enum value XR_TYPE_BODY_JOINTS_LOCATE_INFO_HTC requires extension XR_HTC_body_tracking, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_HTC_body_tracking")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_BODY_JOINTS_LOCATE_INFO_HTC\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_HTC_body_tracking\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_BODY_JOINT_LOCATIONS_HTC:
            // Enum value XR_TYPE_BODY_JOINT_LOCATIONS_HTC requires extension XR_HTC_body_tracking, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_HTC_body_tracking")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_BODY_JOINT_LOCATIONS_HTC\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_HTC_body_tracking\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_BODY_SKELETON_HTC:
            // Enum value XR_TYPE_BODY_SKELETON_HTC requires extension XR_HTC_body_tracking, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_HTC_body_tracking")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_BODY_SKELETON_HTC\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_HTC_body_tracking\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_ACTIVE_ACTION_SET_PRIORITIES_EXT:
            // Enum value XR_TYPE_ACTIVE_ACTION_SET_PRIORITIES_EXT requires extension XR_EXT_active_action_set_priority, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_EXT_active_action_set_priority")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_ACTIVE_ACTION_SET_PRIORITIES_EXT\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_EXT_active_action_set_priority\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_SYSTEM_FORCE_FEEDBACK_CURL_PROPERTIES_MNDX:
            // Enum value XR_TYPE_SYSTEM_FORCE_FEEDBACK_CURL_PROPERTIES_MNDX requires extension XR_MNDX_force_feedback_curl, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_MNDX_force_feedback_curl")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_SYSTEM_FORCE_FEEDBACK_CURL_PROPERTIES_MNDX\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_MNDX_force_feedback_curl\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_FORCE_FEEDBACK_CURL_APPLY_LOCATIONS_MNDX:
            // Enum value XR_TYPE_FORCE_FEEDBACK_CURL_APPLY_LOCATIONS_MNDX requires extension XR_MNDX_force_feedback_curl, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_MNDX_force_feedback_curl")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_FORCE_FEEDBACK_CURL_APPLY_LOCATIONS_MNDX\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_MNDX_force_feedback_curl\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_BODY_TRACKER_CREATE_INFO_BD:
            // Enum value XR_TYPE_BODY_TRACKER_CREATE_INFO_BD requires extension XR_BD_body_tracking, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_BD_body_tracking")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_BODY_TRACKER_CREATE_INFO_BD\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_BD_body_tracking\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_BODY_JOINTS_LOCATE_INFO_BD:
            // Enum value XR_TYPE_BODY_JOINTS_LOCATE_INFO_BD requires extension XR_BD_body_tracking, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_BD_body_tracking")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_BODY_JOINTS_LOCATE_INFO_BD\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_BD_body_tracking\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_BODY_JOINT_LOCATIONS_BD:
            // Enum value XR_TYPE_BODY_JOINT_LOCATIONS_BD requires extension XR_BD_body_tracking, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_BD_body_tracking")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_BODY_JOINT_LOCATIONS_BD\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_BD_body_tracking\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_SYSTEM_BODY_TRACKING_PROPERTIES_BD:
            // Enum value XR_TYPE_SYSTEM_BODY_TRACKING_PROPERTIES_BD requires extension XR_BD_body_tracking, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_BD_body_tracking")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_SYSTEM_BODY_TRACKING_PROPERTIES_BD\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_BD_body_tracking\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_SYSTEM_SPATIAL_SENSING_PROPERTIES_BD:
            // Enum value XR_TYPE_SYSTEM_SPATIAL_SENSING_PROPERTIES_BD requires extension XR_BD_spatial_sensing, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_BD_spatial_sensing")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_SYSTEM_SPATIAL_SENSING_PROPERTIES_BD\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_BD_spatial_sensing\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_SPATIAL_ENTITY_COMPONENT_GET_INFO_BD:
            // Enum value XR_TYPE_SPATIAL_ENTITY_COMPONENT_GET_INFO_BD requires extension XR_BD_spatial_sensing, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_BD_spatial_sensing")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_SPATIAL_ENTITY_COMPONENT_GET_INFO_BD\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_BD_spatial_sensing\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_SPATIAL_ENTITY_LOCATION_GET_INFO_BD:
            // Enum value XR_TYPE_SPATIAL_ENTITY_LOCATION_GET_INFO_BD requires extension XR_BD_spatial_sensing, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_BD_spatial_sensing")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_SPATIAL_ENTITY_LOCATION_GET_INFO_BD\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_BD_spatial_sensing\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_SPATIAL_ENTITY_COMPONENT_DATA_LOCATION_BD:
            // Enum value XR_TYPE_SPATIAL_ENTITY_COMPONENT_DATA_LOCATION_BD requires extension XR_BD_spatial_sensing, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_BD_spatial_sensing")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_SPATIAL_ENTITY_COMPONENT_DATA_LOCATION_BD\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_BD_spatial_sensing\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_SPATIAL_ENTITY_COMPONENT_DATA_SEMANTIC_BD:
            // Enum value XR_TYPE_SPATIAL_ENTITY_COMPONENT_DATA_SEMANTIC_BD requires extension XR_BD_spatial_sensing, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_BD_spatial_sensing")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_SPATIAL_ENTITY_COMPONENT_DATA_SEMANTIC_BD\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_BD_spatial_sensing\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_SPATIAL_ENTITY_COMPONENT_DATA_BOUNDING_BOX_2D_BD:
            // Enum value XR_TYPE_SPATIAL_ENTITY_COMPONENT_DATA_BOUNDING_BOX_2D_BD requires extension XR_BD_spatial_sensing, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_BD_spatial_sensing")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_SPATIAL_ENTITY_COMPONENT_DATA_BOUNDING_BOX_2D_BD\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_BD_spatial_sensing\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_SPATIAL_ENTITY_COMPONENT_DATA_POLYGON_BD:
            // Enum value XR_TYPE_SPATIAL_ENTITY_COMPONENT_DATA_POLYGON_BD requires extension XR_BD_spatial_sensing, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_BD_spatial_sensing")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_SPATIAL_ENTITY_COMPONENT_DATA_POLYGON_BD\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_BD_spatial_sensing\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_SPATIAL_ENTITY_COMPONENT_DATA_BOUNDING_BOX_3D_BD:
            // Enum value XR_TYPE_SPATIAL_ENTITY_COMPONENT_DATA_BOUNDING_BOX_3D_BD requires extension XR_BD_spatial_sensing, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_BD_spatial_sensing")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_SPATIAL_ENTITY_COMPONENT_DATA_BOUNDING_BOX_3D_BD\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_BD_spatial_sensing\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_SPATIAL_ENTITY_COMPONENT_DATA_TRIANGLE_MESH_BD:
            // Enum value XR_TYPE_SPATIAL_ENTITY_COMPONENT_DATA_TRIANGLE_MESH_BD requires extension XR_BD_spatial_sensing, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_BD_spatial_sensing")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_SPATIAL_ENTITY_COMPONENT_DATA_TRIANGLE_MESH_BD\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_BD_spatial_sensing\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_SENSE_DATA_PROVIDER_CREATE_INFO_BD:
            // Enum value XR_TYPE_SENSE_DATA_PROVIDER_CREATE_INFO_BD requires extension XR_BD_spatial_sensing, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_BD_spatial_sensing")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_SENSE_DATA_PROVIDER_CREATE_INFO_BD\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_BD_spatial_sensing\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_SENSE_DATA_PROVIDER_START_INFO_BD:
            // Enum value XR_TYPE_SENSE_DATA_PROVIDER_START_INFO_BD requires extension XR_BD_spatial_sensing, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_BD_spatial_sensing")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_SENSE_DATA_PROVIDER_START_INFO_BD\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_BD_spatial_sensing\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_EVENT_DATA_SENSE_DATA_PROVIDER_STATE_CHANGED_BD:
            // Enum value XR_TYPE_EVENT_DATA_SENSE_DATA_PROVIDER_STATE_CHANGED_BD requires extension XR_BD_spatial_sensing, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_BD_spatial_sensing")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_EVENT_DATA_SENSE_DATA_PROVIDER_STATE_CHANGED_BD\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_BD_spatial_sensing\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_EVENT_DATA_SENSE_DATA_UPDATED_BD:
            // Enum value XR_TYPE_EVENT_DATA_SENSE_DATA_UPDATED_BD requires extension XR_BD_spatial_sensing, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_BD_spatial_sensing")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_EVENT_DATA_SENSE_DATA_UPDATED_BD\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_BD_spatial_sensing\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_SENSE_DATA_QUERY_INFO_BD:
            // Enum value XR_TYPE_SENSE_DATA_QUERY_INFO_BD requires extension XR_BD_spatial_sensing, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_BD_spatial_sensing")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_SENSE_DATA_QUERY_INFO_BD\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_BD_spatial_sensing\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_SENSE_DATA_QUERY_COMPLETION_BD:
            // Enum value XR_TYPE_SENSE_DATA_QUERY_COMPLETION_BD requires extension XR_BD_spatial_sensing, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_BD_spatial_sensing")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_SENSE_DATA_QUERY_COMPLETION_BD\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_BD_spatial_sensing\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_SENSE_DATA_FILTER_UUID_BD:
            // Enum value XR_TYPE_SENSE_DATA_FILTER_UUID_BD requires extension XR_BD_spatial_sensing, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_BD_spatial_sensing")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_SENSE_DATA_FILTER_UUID_BD\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_BD_spatial_sensing\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_SENSE_DATA_FILTER_SEMANTIC_BD:
            // Enum value XR_TYPE_SENSE_DATA_FILTER_SEMANTIC_BD requires extension XR_BD_spatial_sensing, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_BD_spatial_sensing")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_SENSE_DATA_FILTER_SEMANTIC_BD\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_BD_spatial_sensing\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_QUERIED_SENSE_DATA_GET_INFO_BD:
            // Enum value XR_TYPE_QUERIED_SENSE_DATA_GET_INFO_BD requires extension XR_BD_spatial_sensing, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_BD_spatial_sensing")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_QUERIED_SENSE_DATA_GET_INFO_BD\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_BD_spatial_sensing\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_QUERIED_SENSE_DATA_BD:
            // Enum value XR_TYPE_QUERIED_SENSE_DATA_BD requires extension XR_BD_spatial_sensing, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_BD_spatial_sensing")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_QUERIED_SENSE_DATA_BD\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_BD_spatial_sensing\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_SPATIAL_ENTITY_STATE_BD:
            // Enum value XR_TYPE_SPATIAL_ENTITY_STATE_BD requires extension XR_BD_spatial_sensing, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_BD_spatial_sensing")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_SPATIAL_ENTITY_STATE_BD\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_BD_spatial_sensing\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_SPATIAL_ENTITY_ANCHOR_CREATE_INFO_BD:
            // Enum value XR_TYPE_SPATIAL_ENTITY_ANCHOR_CREATE_INFO_BD requires extension XR_BD_spatial_sensing, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_BD_spatial_sensing")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_SPATIAL_ENTITY_ANCHOR_CREATE_INFO_BD\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_BD_spatial_sensing\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_ANCHOR_SPACE_CREATE_INFO_BD:
            // Enum value XR_TYPE_ANCHOR_SPACE_CREATE_INFO_BD requires extension XR_BD_spatial_sensing, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_BD_spatial_sensing")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_ANCHOR_SPACE_CREATE_INFO_BD\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_BD_spatial_sensing\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_SYSTEM_SPATIAL_ANCHOR_PROPERTIES_BD:
            // Enum value XR_TYPE_SYSTEM_SPATIAL_ANCHOR_PROPERTIES_BD requires extension XR_BD_spatial_anchor, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_BD_spatial_anchor")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_SYSTEM_SPATIAL_ANCHOR_PROPERTIES_BD\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_BD_spatial_anchor\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_SPATIAL_ANCHOR_CREATE_INFO_BD:
            // Enum value XR_TYPE_SPATIAL_ANCHOR_CREATE_INFO_BD requires extension XR_BD_spatial_anchor, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_BD_spatial_anchor")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_SPATIAL_ANCHOR_CREATE_INFO_BD\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_BD_spatial_anchor\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_SPATIAL_ANCHOR_CREATE_COMPLETION_BD:
            // Enum value XR_TYPE_SPATIAL_ANCHOR_CREATE_COMPLETION_BD requires extension XR_BD_spatial_anchor, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_BD_spatial_anchor")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_SPATIAL_ANCHOR_CREATE_COMPLETION_BD\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_BD_spatial_anchor\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_SPATIAL_ANCHOR_PERSIST_INFO_BD:
            // Enum value XR_TYPE_SPATIAL_ANCHOR_PERSIST_INFO_BD requires extension XR_BD_spatial_anchor, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_BD_spatial_anchor")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_SPATIAL_ANCHOR_PERSIST_INFO_BD\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_BD_spatial_anchor\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_SPATIAL_ANCHOR_UNPERSIST_INFO_BD:
            // Enum value XR_TYPE_SPATIAL_ANCHOR_UNPERSIST_INFO_BD requires extension XR_BD_spatial_anchor, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_BD_spatial_anchor")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_SPATIAL_ANCHOR_UNPERSIST_INFO_BD\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_BD_spatial_anchor\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_SYSTEM_SPATIAL_ANCHOR_SHARING_PROPERTIES_BD:
            // Enum value XR_TYPE_SYSTEM_SPATIAL_ANCHOR_SHARING_PROPERTIES_BD requires extension XR_BD_spatial_anchor_sharing, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_BD_spatial_anchor_sharing")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_SYSTEM_SPATIAL_ANCHOR_SHARING_PROPERTIES_BD\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_BD_spatial_anchor_sharing\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_SPATIAL_ANCHOR_SHARE_INFO_BD:
            // Enum value XR_TYPE_SPATIAL_ANCHOR_SHARE_INFO_BD requires extension XR_BD_spatial_anchor_sharing, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_BD_spatial_anchor_sharing")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_SPATIAL_ANCHOR_SHARE_INFO_BD\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_BD_spatial_anchor_sharing\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_SHARED_SPATIAL_ANCHOR_DOWNLOAD_INFO_BD:
            // Enum value XR_TYPE_SHARED_SPATIAL_ANCHOR_DOWNLOAD_INFO_BD requires extension XR_BD_spatial_anchor_sharing, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_BD_spatial_anchor_sharing")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_SHARED_SPATIAL_ANCHOR_DOWNLOAD_INFO_BD\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_BD_spatial_anchor_sharing\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_SYSTEM_SPATIAL_SCENE_PROPERTIES_BD:
            // Enum value XR_TYPE_SYSTEM_SPATIAL_SCENE_PROPERTIES_BD requires extension XR_BD_spatial_scene, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_BD_spatial_scene")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_SYSTEM_SPATIAL_SCENE_PROPERTIES_BD\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_BD_spatial_scene\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_SCENE_CAPTURE_INFO_BD:
            // Enum value XR_TYPE_SCENE_CAPTURE_INFO_BD requires extension XR_BD_spatial_scene, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_BD_spatial_scene")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_SCENE_CAPTURE_INFO_BD\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_BD_spatial_scene\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_SYSTEM_SPATIAL_MESH_PROPERTIES_BD:
            // Enum value XR_TYPE_SYSTEM_SPATIAL_MESH_PROPERTIES_BD requires extension XR_BD_spatial_mesh, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_BD_spatial_mesh")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_SYSTEM_SPATIAL_MESH_PROPERTIES_BD\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_BD_spatial_mesh\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_SENSE_DATA_PROVIDER_CREATE_INFO_SPATIAL_MESH_BD:
            // Enum value XR_TYPE_SENSE_DATA_PROVIDER_CREATE_INFO_SPATIAL_MESH_BD requires extension XR_BD_spatial_mesh, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_BD_spatial_mesh")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_SENSE_DATA_PROVIDER_CREATE_INFO_SPATIAL_MESH_BD\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_BD_spatial_mesh\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_FUTURE_POLL_RESULT_PROGRESS_BD:
            // Enum value XR_TYPE_FUTURE_POLL_RESULT_PROGRESS_BD requires extension XR_BD_future_progress, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_BD_future_progress")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_FUTURE_POLL_RESULT_PROGRESS_BD\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_BD_future_progress\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_SYSTEM_SPATIAL_PLANE_PROPERTIES_BD:
            // Enum value XR_TYPE_SYSTEM_SPATIAL_PLANE_PROPERTIES_BD requires extension XR_BD_spatial_plane, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_BD_spatial_plane")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_SYSTEM_SPATIAL_PLANE_PROPERTIES_BD\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_BD_spatial_plane\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_SPATIAL_ENTITY_COMPONENT_DATA_PLANE_ORIENTATION_BD:
            // Enum value XR_TYPE_SPATIAL_ENTITY_COMPONENT_DATA_PLANE_ORIENTATION_BD requires extension XR_BD_spatial_plane, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_BD_spatial_plane")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_SPATIAL_ENTITY_COMPONENT_DATA_PLANE_ORIENTATION_BD\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_BD_spatial_plane\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_SENSE_DATA_FILTER_PLANE_ORIENTATION_BD:
            // Enum value XR_TYPE_SENSE_DATA_FILTER_PLANE_ORIENTATION_BD requires extension XR_BD_spatial_plane, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_BD_spatial_plane")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_SENSE_DATA_FILTER_PLANE_ORIENTATION_BD\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_BD_spatial_plane\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_HAND_TRACKING_DATA_SOURCE_INFO_EXT:
            // Enum value XR_TYPE_HAND_TRACKING_DATA_SOURCE_INFO_EXT requires extension XR_EXT_hand_tracking_data_source, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_EXT_hand_tracking_data_source")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_HAND_TRACKING_DATA_SOURCE_INFO_EXT\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_EXT_hand_tracking_data_source\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_HAND_TRACKING_DATA_SOURCE_STATE_EXT:
            // Enum value XR_TYPE_HAND_TRACKING_DATA_SOURCE_STATE_EXT requires extension XR_EXT_hand_tracking_data_source, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_EXT_hand_tracking_data_source")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_HAND_TRACKING_DATA_SOURCE_STATE_EXT\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_EXT_hand_tracking_data_source\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_PLANE_DETECTOR_CREATE_INFO_EXT:
            // Enum value XR_TYPE_PLANE_DETECTOR_CREATE_INFO_EXT requires extension XR_EXT_plane_detection, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_EXT_plane_detection")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_PLANE_DETECTOR_CREATE_INFO_EXT\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_EXT_plane_detection\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_PLANE_DETECTOR_BEGIN_INFO_EXT:
            // Enum value XR_TYPE_PLANE_DETECTOR_BEGIN_INFO_EXT requires extension XR_EXT_plane_detection, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_EXT_plane_detection")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_PLANE_DETECTOR_BEGIN_INFO_EXT\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_EXT_plane_detection\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_PLANE_DETECTOR_GET_INFO_EXT:
            // Enum value XR_TYPE_PLANE_DETECTOR_GET_INFO_EXT requires extension XR_EXT_plane_detection, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_EXT_plane_detection")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_PLANE_DETECTOR_GET_INFO_EXT\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_EXT_plane_detection\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_PLANE_DETECTOR_LOCATIONS_EXT:
            // Enum value XR_TYPE_PLANE_DETECTOR_LOCATIONS_EXT requires extension XR_EXT_plane_detection, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_EXT_plane_detection")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_PLANE_DETECTOR_LOCATIONS_EXT\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_EXT_plane_detection\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_PLANE_DETECTOR_LOCATION_EXT:
            // Enum value XR_TYPE_PLANE_DETECTOR_LOCATION_EXT requires extension XR_EXT_plane_detection, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_EXT_plane_detection")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_PLANE_DETECTOR_LOCATION_EXT\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_EXT_plane_detection\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_PLANE_DETECTOR_POLYGON_BUFFER_EXT:
            // Enum value XR_TYPE_PLANE_DETECTOR_POLYGON_BUFFER_EXT requires extension XR_EXT_plane_detection, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_EXT_plane_detection")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_PLANE_DETECTOR_POLYGON_BUFFER_EXT\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_EXT_plane_detection\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_SYSTEM_PLANE_DETECTION_PROPERTIES_EXT:
            // Enum value XR_TYPE_SYSTEM_PLANE_DETECTION_PROPERTIES_EXT requires extension XR_EXT_plane_detection, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_EXT_plane_detection")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_SYSTEM_PLANE_DETECTION_PROPERTIES_EXT\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_EXT_plane_detection\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_TRACKABLE_GET_INFO_ANDROID:
            // Enum value XR_TYPE_TRACKABLE_GET_INFO_ANDROID requires extension XR_ANDROID_trackables, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_ANDROID_trackables")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_TRACKABLE_GET_INFO_ANDROID\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_ANDROID_trackables\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_ANCHOR_SPACE_CREATE_INFO_ANDROID:
            // Enum value XR_TYPE_ANCHOR_SPACE_CREATE_INFO_ANDROID requires extension XR_ANDROID_trackables, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_ANDROID_trackables")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_ANCHOR_SPACE_CREATE_INFO_ANDROID\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_ANDROID_trackables\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_TRACKABLE_PLANE_ANDROID:
            // Enum value XR_TYPE_TRACKABLE_PLANE_ANDROID requires extension XR_ANDROID_trackables, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_ANDROID_trackables")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_TRACKABLE_PLANE_ANDROID\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_ANDROID_trackables\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_TRACKABLE_TRACKER_CREATE_INFO_ANDROID:
            // Enum value XR_TYPE_TRACKABLE_TRACKER_CREATE_INFO_ANDROID requires extension XR_ANDROID_trackables, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_ANDROID_trackables")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_TRACKABLE_TRACKER_CREATE_INFO_ANDROID\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_ANDROID_trackables\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_SYSTEM_TRACKABLES_PROPERTIES_ANDROID:
            // Enum value XR_TYPE_SYSTEM_TRACKABLES_PROPERTIES_ANDROID requires extension XR_ANDROID_trackables, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_ANDROID_trackables")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_SYSTEM_TRACKABLES_PROPERTIES_ANDROID\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_ANDROID_trackables\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_PERSISTED_ANCHOR_SPACE_CREATE_INFO_ANDROID:
            // Enum value XR_TYPE_PERSISTED_ANCHOR_SPACE_CREATE_INFO_ANDROID requires extension XR_ANDROID_device_anchor_persistence, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_ANDROID_device_anchor_persistence")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_PERSISTED_ANCHOR_SPACE_CREATE_INFO_ANDROID\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_ANDROID_device_anchor_persistence\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_PERSISTED_ANCHOR_SPACE_INFO_ANDROID:
            // Enum value XR_TYPE_PERSISTED_ANCHOR_SPACE_INFO_ANDROID requires extension XR_ANDROID_device_anchor_persistence, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_ANDROID_device_anchor_persistence")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_PERSISTED_ANCHOR_SPACE_INFO_ANDROID\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_ANDROID_device_anchor_persistence\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_DEVICE_ANCHOR_PERSISTENCE_CREATE_INFO_ANDROID:
            // Enum value XR_TYPE_DEVICE_ANCHOR_PERSISTENCE_CREATE_INFO_ANDROID requires extension XR_ANDROID_device_anchor_persistence, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_ANDROID_device_anchor_persistence")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_DEVICE_ANCHOR_PERSISTENCE_CREATE_INFO_ANDROID\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_ANDROID_device_anchor_persistence\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_SYSTEM_DEVICE_ANCHOR_PERSISTENCE_PROPERTIES_ANDROID:
            // Enum value XR_TYPE_SYSTEM_DEVICE_ANCHOR_PERSISTENCE_PROPERTIES_ANDROID requires extension XR_ANDROID_device_anchor_persistence, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_ANDROID_device_anchor_persistence")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_SYSTEM_DEVICE_ANCHOR_PERSISTENCE_PROPERTIES_ANDROID\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_ANDROID_device_anchor_persistence\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_PASSTHROUGH_CAMERA_STATE_GET_INFO_ANDROID:
            // Enum value XR_TYPE_PASSTHROUGH_CAMERA_STATE_GET_INFO_ANDROID requires extension XR_ANDROID_passthrough_camera_state, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_ANDROID_passthrough_camera_state")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_PASSTHROUGH_CAMERA_STATE_GET_INFO_ANDROID\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_ANDROID_passthrough_camera_state\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_SYSTEM_PASSTHROUGH_CAMERA_STATE_PROPERTIES_ANDROID:
            // Enum value XR_TYPE_SYSTEM_PASSTHROUGH_CAMERA_STATE_PROPERTIES_ANDROID requires extension XR_ANDROID_passthrough_camera_state, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_ANDROID_passthrough_camera_state")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_SYSTEM_PASSTHROUGH_CAMERA_STATE_PROPERTIES_ANDROID\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_ANDROID_passthrough_camera_state\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_RAYCAST_INFO_ANDROID:
            // Enum value XR_TYPE_RAYCAST_INFO_ANDROID requires extension XR_ANDROID_raycast, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_ANDROID_raycast")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_RAYCAST_INFO_ANDROID\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_ANDROID_raycast\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_RAYCAST_HIT_RESULTS_ANDROID:
            // Enum value XR_TYPE_RAYCAST_HIT_RESULTS_ANDROID requires extension XR_ANDROID_raycast, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_ANDROID_raycast")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_RAYCAST_HIT_RESULTS_ANDROID\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_ANDROID_raycast\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_TRACKABLE_OBJECT_ANDROID:
            // Enum value XR_TYPE_TRACKABLE_OBJECT_ANDROID requires extension XR_ANDROID_trackables_object, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_ANDROID_trackables_object")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_TRACKABLE_OBJECT_ANDROID\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_ANDROID_trackables_object\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_TRACKABLE_OBJECT_CONFIGURATION_ANDROID:
            // Enum value XR_TYPE_TRACKABLE_OBJECT_CONFIGURATION_ANDROID requires extension XR_ANDROID_trackables_object, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_ANDROID_trackables_object")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_TRACKABLE_OBJECT_CONFIGURATION_ANDROID\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_ANDROID_trackables_object\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_FUTURE_CANCEL_INFO_EXT:
            // Enum value XR_TYPE_FUTURE_CANCEL_INFO_EXT requires extension XR_EXT_future, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_EXT_future")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_FUTURE_CANCEL_INFO_EXT\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_EXT_future\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_FUTURE_POLL_INFO_EXT:
            // Enum value XR_TYPE_FUTURE_POLL_INFO_EXT requires extension XR_EXT_future, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_EXT_future")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_FUTURE_POLL_INFO_EXT\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_EXT_future\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_FUTURE_COMPLETION_EXT:
            // Enum value XR_TYPE_FUTURE_COMPLETION_EXT requires extension XR_EXT_future, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_EXT_future")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_FUTURE_COMPLETION_EXT\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_EXT_future\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_FUTURE_POLL_RESULT_EXT:
            // Enum value XR_TYPE_FUTURE_POLL_RESULT_EXT requires extension XR_EXT_future, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_EXT_future")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_FUTURE_POLL_RESULT_EXT\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_EXT_future\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_EVENT_DATA_USER_PRESENCE_CHANGED_EXT:
            // Enum value XR_TYPE_EVENT_DATA_USER_PRESENCE_CHANGED_EXT requires extension XR_EXT_user_presence, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_EXT_user_presence")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_EVENT_DATA_USER_PRESENCE_CHANGED_EXT\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_EXT_user_presence\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_SYSTEM_USER_PRESENCE_PROPERTIES_EXT:
            // Enum value XR_TYPE_SYSTEM_USER_PRESENCE_PROPERTIES_EXT requires extension XR_EXT_user_presence, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_EXT_user_presence")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_SYSTEM_USER_PRESENCE_PROPERTIES_EXT\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_EXT_user_presence\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_SYSTEM_NOTIFICATIONS_SET_INFO_ML:
            // Enum value XR_TYPE_SYSTEM_NOTIFICATIONS_SET_INFO_ML requires extension XR_ML_system_notifications, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_ML_system_notifications")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_SYSTEM_NOTIFICATIONS_SET_INFO_ML\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_ML_system_notifications\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_WORLD_MESH_DETECTOR_CREATE_INFO_ML:
            // Enum value XR_TYPE_WORLD_MESH_DETECTOR_CREATE_INFO_ML requires extension XR_ML_world_mesh_detection, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_ML_world_mesh_detection")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_WORLD_MESH_DETECTOR_CREATE_INFO_ML\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_ML_world_mesh_detection\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_WORLD_MESH_STATE_REQUEST_INFO_ML:
            // Enum value XR_TYPE_WORLD_MESH_STATE_REQUEST_INFO_ML requires extension XR_ML_world_mesh_detection, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_ML_world_mesh_detection")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_WORLD_MESH_STATE_REQUEST_INFO_ML\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_ML_world_mesh_detection\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_WORLD_MESH_BLOCK_STATE_ML:
            // Enum value XR_TYPE_WORLD_MESH_BLOCK_STATE_ML requires extension XR_ML_world_mesh_detection, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_ML_world_mesh_detection")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_WORLD_MESH_BLOCK_STATE_ML\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_ML_world_mesh_detection\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_WORLD_MESH_STATE_REQUEST_COMPLETION_ML:
            // Enum value XR_TYPE_WORLD_MESH_STATE_REQUEST_COMPLETION_ML requires extension XR_ML_world_mesh_detection, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_ML_world_mesh_detection")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_WORLD_MESH_STATE_REQUEST_COMPLETION_ML\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_ML_world_mesh_detection\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_WORLD_MESH_BUFFER_RECOMMENDED_SIZE_INFO_ML:
            // Enum value XR_TYPE_WORLD_MESH_BUFFER_RECOMMENDED_SIZE_INFO_ML requires extension XR_ML_world_mesh_detection, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_ML_world_mesh_detection")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_WORLD_MESH_BUFFER_RECOMMENDED_SIZE_INFO_ML\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_ML_world_mesh_detection\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_WORLD_MESH_BUFFER_SIZE_ML:
            // Enum value XR_TYPE_WORLD_MESH_BUFFER_SIZE_ML requires extension XR_ML_world_mesh_detection, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_ML_world_mesh_detection")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_WORLD_MESH_BUFFER_SIZE_ML\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_ML_world_mesh_detection\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_WORLD_MESH_BUFFER_ML:
            // Enum value XR_TYPE_WORLD_MESH_BUFFER_ML requires extension XR_ML_world_mesh_detection, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_ML_world_mesh_detection")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_WORLD_MESH_BUFFER_ML\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_ML_world_mesh_detection\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_WORLD_MESH_BLOCK_REQUEST_ML:
            // Enum value XR_TYPE_WORLD_MESH_BLOCK_REQUEST_ML requires extension XR_ML_world_mesh_detection, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_ML_world_mesh_detection")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_WORLD_MESH_BLOCK_REQUEST_ML\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_ML_world_mesh_detection\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_WORLD_MESH_GET_INFO_ML:
            // Enum value XR_TYPE_WORLD_MESH_GET_INFO_ML requires extension XR_ML_world_mesh_detection, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_ML_world_mesh_detection")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_WORLD_MESH_GET_INFO_ML\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_ML_world_mesh_detection\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_WORLD_MESH_BLOCK_ML:
            // Enum value XR_TYPE_WORLD_MESH_BLOCK_ML requires extension XR_ML_world_mesh_detection, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_ML_world_mesh_detection")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_WORLD_MESH_BLOCK_ML\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_ML_world_mesh_detection\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_WORLD_MESH_REQUEST_COMPLETION_ML:
            // Enum value XR_TYPE_WORLD_MESH_REQUEST_COMPLETION_ML requires extension XR_ML_world_mesh_detection, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_ML_world_mesh_detection")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_WORLD_MESH_REQUEST_COMPLETION_ML\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_ML_world_mesh_detection\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_WORLD_MESH_REQUEST_COMPLETION_INFO_ML:
            // Enum value XR_TYPE_WORLD_MESH_REQUEST_COMPLETION_INFO_ML requires extension XR_ML_world_mesh_detection, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_ML_world_mesh_detection")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_WORLD_MESH_REQUEST_COMPLETION_INFO_ML\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_ML_world_mesh_detection\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_SYSTEM_FACIAL_EXPRESSION_PROPERTIES_ML:
            // Enum value XR_TYPE_SYSTEM_FACIAL_EXPRESSION_PROPERTIES_ML requires extension XR_ML_facial_expression, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_ML_facial_expression")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_SYSTEM_FACIAL_EXPRESSION_PROPERTIES_ML\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_ML_facial_expression\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_FACIAL_EXPRESSION_CLIENT_CREATE_INFO_ML:
            // Enum value XR_TYPE_FACIAL_EXPRESSION_CLIENT_CREATE_INFO_ML requires extension XR_ML_facial_expression, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_ML_facial_expression")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_FACIAL_EXPRESSION_CLIENT_CREATE_INFO_ML\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_ML_facial_expression\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_FACIAL_EXPRESSION_BLEND_SHAPE_GET_INFO_ML:
            // Enum value XR_TYPE_FACIAL_EXPRESSION_BLEND_SHAPE_GET_INFO_ML requires extension XR_ML_facial_expression, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_ML_facial_expression")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_FACIAL_EXPRESSION_BLEND_SHAPE_GET_INFO_ML\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_ML_facial_expression\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_FACIAL_EXPRESSION_BLEND_SHAPE_PROPERTIES_ML:
            // Enum value XR_TYPE_FACIAL_EXPRESSION_BLEND_SHAPE_PROPERTIES_ML requires extension XR_ML_facial_expression, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_ML_facial_expression")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_FACIAL_EXPRESSION_BLEND_SHAPE_PROPERTIES_ML\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_ML_facial_expression\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_SYSTEM_SIMULTANEOUS_HANDS_AND_CONTROLLERS_PROPERTIES_META:
            // Enum value XR_TYPE_SYSTEM_SIMULTANEOUS_HANDS_AND_CONTROLLERS_PROPERTIES_META requires extension XR_META_simultaneous_hands_and_controllers, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_META_simultaneous_hands_and_controllers")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_SYSTEM_SIMULTANEOUS_HANDS_AND_CONTROLLERS_PROPERTIES_META\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_META_simultaneous_hands_and_controllers\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_SIMULTANEOUS_HANDS_AND_CONTROLLERS_TRACKING_RESUME_INFO_META:
            // Enum value XR_TYPE_SIMULTANEOUS_HANDS_AND_CONTROLLERS_TRACKING_RESUME_INFO_META requires extension XR_META_simultaneous_hands_and_controllers, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_META_simultaneous_hands_and_controllers")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_SIMULTANEOUS_HANDS_AND_CONTROLLERS_TRACKING_RESUME_INFO_META\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_META_simultaneous_hands_and_controllers\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_SIMULTANEOUS_HANDS_AND_CONTROLLERS_TRACKING_PAUSE_INFO_META:
            // Enum value XR_TYPE_SIMULTANEOUS_HANDS_AND_CONTROLLERS_TRACKING_PAUSE_INFO_META requires extension XR_META_simultaneous_hands_and_controllers, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_META_simultaneous_hands_and_controllers")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_SIMULTANEOUS_HANDS_AND_CONTROLLERS_TRACKING_PAUSE_INFO_META\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_META_simultaneous_hands_and_controllers\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_COLOCATION_DISCOVERY_START_INFO_META:
            // Enum value XR_TYPE_COLOCATION_DISCOVERY_START_INFO_META requires extension XR_META_colocation_discovery, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_META_colocation_discovery")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_COLOCATION_DISCOVERY_START_INFO_META\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_META_colocation_discovery\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_COLOCATION_DISCOVERY_STOP_INFO_META:
            // Enum value XR_TYPE_COLOCATION_DISCOVERY_STOP_INFO_META requires extension XR_META_colocation_discovery, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_META_colocation_discovery")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_COLOCATION_DISCOVERY_STOP_INFO_META\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_META_colocation_discovery\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_COLOCATION_ADVERTISEMENT_START_INFO_META:
            // Enum value XR_TYPE_COLOCATION_ADVERTISEMENT_START_INFO_META requires extension XR_META_colocation_discovery, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_META_colocation_discovery")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_COLOCATION_ADVERTISEMENT_START_INFO_META\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_META_colocation_discovery\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_COLOCATION_ADVERTISEMENT_STOP_INFO_META:
            // Enum value XR_TYPE_COLOCATION_ADVERTISEMENT_STOP_INFO_META requires extension XR_META_colocation_discovery, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_META_colocation_discovery")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_COLOCATION_ADVERTISEMENT_STOP_INFO_META\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_META_colocation_discovery\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_EVENT_DATA_START_COLOCATION_ADVERTISEMENT_COMPLETE_META:
            // Enum value XR_TYPE_EVENT_DATA_START_COLOCATION_ADVERTISEMENT_COMPLETE_META requires extension XR_META_colocation_discovery, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_META_colocation_discovery")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_EVENT_DATA_START_COLOCATION_ADVERTISEMENT_COMPLETE_META\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_META_colocation_discovery\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_EVENT_DATA_STOP_COLOCATION_ADVERTISEMENT_COMPLETE_META:
            // Enum value XR_TYPE_EVENT_DATA_STOP_COLOCATION_ADVERTISEMENT_COMPLETE_META requires extension XR_META_colocation_discovery, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_META_colocation_discovery")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_EVENT_DATA_STOP_COLOCATION_ADVERTISEMENT_COMPLETE_META\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_META_colocation_discovery\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_EVENT_DATA_COLOCATION_ADVERTISEMENT_COMPLETE_META:
            // Enum value XR_TYPE_EVENT_DATA_COLOCATION_ADVERTISEMENT_COMPLETE_META requires extension XR_META_colocation_discovery, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_META_colocation_discovery")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_EVENT_DATA_COLOCATION_ADVERTISEMENT_COMPLETE_META\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_META_colocation_discovery\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_EVENT_DATA_START_COLOCATION_DISCOVERY_COMPLETE_META:
            // Enum value XR_TYPE_EVENT_DATA_START_COLOCATION_DISCOVERY_COMPLETE_META requires extension XR_META_colocation_discovery, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_META_colocation_discovery")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_EVENT_DATA_START_COLOCATION_DISCOVERY_COMPLETE_META\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_META_colocation_discovery\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_EVENT_DATA_COLOCATION_DISCOVERY_RESULT_META:
            // Enum value XR_TYPE_EVENT_DATA_COLOCATION_DISCOVERY_RESULT_META requires extension XR_META_colocation_discovery, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_META_colocation_discovery")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_EVENT_DATA_COLOCATION_DISCOVERY_RESULT_META\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_META_colocation_discovery\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_EVENT_DATA_COLOCATION_DISCOVERY_COMPLETE_META:
            // Enum value XR_TYPE_EVENT_DATA_COLOCATION_DISCOVERY_COMPLETE_META requires extension XR_META_colocation_discovery, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_META_colocation_discovery")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_EVENT_DATA_COLOCATION_DISCOVERY_COMPLETE_META\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_META_colocation_discovery\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_EVENT_DATA_STOP_COLOCATION_DISCOVERY_COMPLETE_META:
            // Enum value XR_TYPE_EVENT_DATA_STOP_COLOCATION_DISCOVERY_COMPLETE_META requires extension XR_META_colocation_discovery, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_META_colocation_discovery")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_EVENT_DATA_STOP_COLOCATION_DISCOVERY_COMPLETE_META\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_META_colocation_discovery\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_SYSTEM_COLOCATION_DISCOVERY_PROPERTIES_META:
            // Enum value XR_TYPE_SYSTEM_COLOCATION_DISCOVERY_PROPERTIES_META requires extension XR_META_colocation_discovery, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_META_colocation_discovery")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_SYSTEM_COLOCATION_DISCOVERY_PROPERTIES_META\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_META_colocation_discovery\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_SHARE_SPACES_RECIPIENT_GROUPS_META:
            // Enum value XR_TYPE_SHARE_SPACES_RECIPIENT_GROUPS_META requires extension XR_META_spatial_entity_group_sharing, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_META_spatial_entity_group_sharing")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_SHARE_SPACES_RECIPIENT_GROUPS_META\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_META_spatial_entity_group_sharing\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_SPACE_GROUP_UUID_FILTER_INFO_META:
            // Enum value XR_TYPE_SPACE_GROUP_UUID_FILTER_INFO_META requires extension XR_META_spatial_entity_group_sharing, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_META_spatial_entity_group_sharing")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_SPACE_GROUP_UUID_FILTER_INFO_META\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_META_spatial_entity_group_sharing\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_SYSTEM_SPATIAL_ENTITY_GROUP_SHARING_PROPERTIES_META:
            // Enum value XR_TYPE_SYSTEM_SPATIAL_ENTITY_GROUP_SHARING_PROPERTIES_META requires extension XR_META_spatial_entity_group_sharing, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_META_spatial_entity_group_sharing")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_SYSTEM_SPATIAL_ENTITY_GROUP_SHARING_PROPERTIES_META\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_META_spatial_entity_group_sharing\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_ANCHOR_SHARING_INFO_ANDROID:
            // Enum value XR_TYPE_ANCHOR_SHARING_INFO_ANDROID requires extension XR_ANDROID_anchor_sharing_export, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_ANDROID_anchor_sharing_export")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_ANCHOR_SHARING_INFO_ANDROID\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_ANDROID_anchor_sharing_export\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_ANCHOR_SHARING_TOKEN_ANDROID:
            // Enum value XR_TYPE_ANCHOR_SHARING_TOKEN_ANDROID requires extension XR_ANDROID_anchor_sharing_export, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_ANDROID_anchor_sharing_export")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_ANCHOR_SHARING_TOKEN_ANDROID\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_ANDROID_anchor_sharing_export\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_SYSTEM_ANCHOR_SHARING_EXPORT_PROPERTIES_ANDROID:
            // Enum value XR_TYPE_SYSTEM_ANCHOR_SHARING_EXPORT_PROPERTIES_ANDROID requires extension XR_ANDROID_anchor_sharing_export, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_ANDROID_anchor_sharing_export")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_SYSTEM_ANCHOR_SHARING_EXPORT_PROPERTIES_ANDROID\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_ANDROID_anchor_sharing_export\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_SYSTEM_MARKER_TRACKING_PROPERTIES_ANDROID:
            // Enum value XR_TYPE_SYSTEM_MARKER_TRACKING_PROPERTIES_ANDROID requires extension XR_ANDROID_trackables_marker, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_ANDROID_trackables_marker")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_SYSTEM_MARKER_TRACKING_PROPERTIES_ANDROID\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_ANDROID_trackables_marker\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_TRACKABLE_MARKER_CONFIGURATION_ANDROID:
            // Enum value XR_TYPE_TRACKABLE_MARKER_CONFIGURATION_ANDROID requires extension XR_ANDROID_trackables_marker, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_ANDROID_trackables_marker")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_TRACKABLE_MARKER_CONFIGURATION_ANDROID\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_ANDROID_trackables_marker\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_TRACKABLE_MARKER_ANDROID:
            // Enum value XR_TYPE_TRACKABLE_MARKER_ANDROID requires extension XR_ANDROID_trackables_marker, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_ANDROID_trackables_marker")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_TRACKABLE_MARKER_ANDROID\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_ANDROID_trackables_marker\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_SPATIAL_CAPABILITY_COMPONENT_TYPES_EXT:
            // Enum value XR_TYPE_SPATIAL_CAPABILITY_COMPONENT_TYPES_EXT requires extension XR_EXT_spatial_entity, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_EXT_spatial_entity")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_SPATIAL_CAPABILITY_COMPONENT_TYPES_EXT\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_EXT_spatial_entity\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_SPATIAL_CONTEXT_CREATE_INFO_EXT:
            // Enum value XR_TYPE_SPATIAL_CONTEXT_CREATE_INFO_EXT requires extension XR_EXT_spatial_entity, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_EXT_spatial_entity")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_SPATIAL_CONTEXT_CREATE_INFO_EXT\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_EXT_spatial_entity\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_CREATE_SPATIAL_CONTEXT_COMPLETION_EXT:
            // Enum value XR_TYPE_CREATE_SPATIAL_CONTEXT_COMPLETION_EXT requires extension XR_EXT_spatial_entity, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_EXT_spatial_entity")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_CREATE_SPATIAL_CONTEXT_COMPLETION_EXT\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_EXT_spatial_entity\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_SPATIAL_DISCOVERY_SNAPSHOT_CREATE_INFO_EXT:
            // Enum value XR_TYPE_SPATIAL_DISCOVERY_SNAPSHOT_CREATE_INFO_EXT requires extension XR_EXT_spatial_entity, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_EXT_spatial_entity")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_SPATIAL_DISCOVERY_SNAPSHOT_CREATE_INFO_EXT\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_EXT_spatial_entity\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_CREATE_SPATIAL_DISCOVERY_SNAPSHOT_COMPLETION_INFO_EXT:
            // Enum value XR_TYPE_CREATE_SPATIAL_DISCOVERY_SNAPSHOT_COMPLETION_INFO_EXT requires extension XR_EXT_spatial_entity, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_EXT_spatial_entity")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_CREATE_SPATIAL_DISCOVERY_SNAPSHOT_COMPLETION_INFO_EXT\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_EXT_spatial_entity\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_CREATE_SPATIAL_DISCOVERY_SNAPSHOT_COMPLETION_EXT:
            // Enum value XR_TYPE_CREATE_SPATIAL_DISCOVERY_SNAPSHOT_COMPLETION_EXT requires extension XR_EXT_spatial_entity, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_EXT_spatial_entity")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_CREATE_SPATIAL_DISCOVERY_SNAPSHOT_COMPLETION_EXT\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_EXT_spatial_entity\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_SPATIAL_COMPONENT_DATA_QUERY_CONDITION_EXT:
            // Enum value XR_TYPE_SPATIAL_COMPONENT_DATA_QUERY_CONDITION_EXT requires extension XR_EXT_spatial_entity, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_EXT_spatial_entity")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_SPATIAL_COMPONENT_DATA_QUERY_CONDITION_EXT\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_EXT_spatial_entity\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_SPATIAL_COMPONENT_DATA_QUERY_RESULT_EXT:
            // Enum value XR_TYPE_SPATIAL_COMPONENT_DATA_QUERY_RESULT_EXT requires extension XR_EXT_spatial_entity, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_EXT_spatial_entity")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_SPATIAL_COMPONENT_DATA_QUERY_RESULT_EXT\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_EXT_spatial_entity\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_SPATIAL_BUFFER_GET_INFO_EXT:
            // Enum value XR_TYPE_SPATIAL_BUFFER_GET_INFO_EXT requires extension XR_EXT_spatial_entity, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_EXT_spatial_entity")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_SPATIAL_BUFFER_GET_INFO_EXT\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_EXT_spatial_entity\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_SPATIAL_COMPONENT_BOUNDED_2D_LIST_EXT:
            // Enum value XR_TYPE_SPATIAL_COMPONENT_BOUNDED_2D_LIST_EXT requires extension XR_EXT_spatial_entity, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_EXT_spatial_entity")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_SPATIAL_COMPONENT_BOUNDED_2D_LIST_EXT\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_EXT_spatial_entity\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_SPATIAL_COMPONENT_BOUNDED_3D_LIST_EXT:
            // Enum value XR_TYPE_SPATIAL_COMPONENT_BOUNDED_3D_LIST_EXT requires extension XR_EXT_spatial_entity, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_EXT_spatial_entity")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_SPATIAL_COMPONENT_BOUNDED_3D_LIST_EXT\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_EXT_spatial_entity\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_SPATIAL_COMPONENT_PARENT_LIST_EXT:
            // Enum value XR_TYPE_SPATIAL_COMPONENT_PARENT_LIST_EXT requires extension XR_EXT_spatial_entity, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_EXT_spatial_entity")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_SPATIAL_COMPONENT_PARENT_LIST_EXT\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_EXT_spatial_entity\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_SPATIAL_COMPONENT_MESH_3D_LIST_EXT:
            // Enum value XR_TYPE_SPATIAL_COMPONENT_MESH_3D_LIST_EXT requires extension XR_EXT_spatial_entity, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_EXT_spatial_entity")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_SPATIAL_COMPONENT_MESH_3D_LIST_EXT\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_EXT_spatial_entity\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_SPATIAL_ENTITY_FROM_ID_CREATE_INFO_EXT:
            // Enum value XR_TYPE_SPATIAL_ENTITY_FROM_ID_CREATE_INFO_EXT requires extension XR_EXT_spatial_entity, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_EXT_spatial_entity")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_SPATIAL_ENTITY_FROM_ID_CREATE_INFO_EXT\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_EXT_spatial_entity\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_SPATIAL_UPDATE_SNAPSHOT_CREATE_INFO_EXT:
            // Enum value XR_TYPE_SPATIAL_UPDATE_SNAPSHOT_CREATE_INFO_EXT requires extension XR_EXT_spatial_entity, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_EXT_spatial_entity")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_SPATIAL_UPDATE_SNAPSHOT_CREATE_INFO_EXT\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_EXT_spatial_entity\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_EVENT_DATA_SPATIAL_DISCOVERY_RECOMMENDED_EXT:
            // Enum value XR_TYPE_EVENT_DATA_SPATIAL_DISCOVERY_RECOMMENDED_EXT requires extension XR_EXT_spatial_entity, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_EXT_spatial_entity")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_EVENT_DATA_SPATIAL_DISCOVERY_RECOMMENDED_EXT\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_EXT_spatial_entity\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_SPATIAL_FILTER_TRACKING_STATE_EXT:
            // Enum value XR_TYPE_SPATIAL_FILTER_TRACKING_STATE_EXT requires extension XR_EXT_spatial_entity, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_EXT_spatial_entity")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_SPATIAL_FILTER_TRACKING_STATE_EXT\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_EXT_spatial_entity\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_SPATIAL_CAPABILITY_CONFIGURATION_PLANE_TRACKING_EXT:
            // Enum value XR_TYPE_SPATIAL_CAPABILITY_CONFIGURATION_PLANE_TRACKING_EXT requires extension XR_EXT_spatial_plane_tracking, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_EXT_spatial_plane_tracking")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_SPATIAL_CAPABILITY_CONFIGURATION_PLANE_TRACKING_EXT\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_EXT_spatial_plane_tracking\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_SPATIAL_COMPONENT_PLANE_ALIGNMENT_LIST_EXT:
            // Enum value XR_TYPE_SPATIAL_COMPONENT_PLANE_ALIGNMENT_LIST_EXT requires extension XR_EXT_spatial_plane_tracking, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_EXT_spatial_plane_tracking")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_SPATIAL_COMPONENT_PLANE_ALIGNMENT_LIST_EXT\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_EXT_spatial_plane_tracking\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_SPATIAL_COMPONENT_MESH_2D_LIST_EXT:
            // Enum value XR_TYPE_SPATIAL_COMPONENT_MESH_2D_LIST_EXT requires extension XR_EXT_spatial_plane_tracking, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_EXT_spatial_plane_tracking")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_SPATIAL_COMPONENT_MESH_2D_LIST_EXT\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_EXT_spatial_plane_tracking\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_SPATIAL_COMPONENT_POLYGON_2D_LIST_EXT:
            // Enum value XR_TYPE_SPATIAL_COMPONENT_POLYGON_2D_LIST_EXT requires extension XR_EXT_spatial_plane_tracking, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_EXT_spatial_plane_tracking")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_SPATIAL_COMPONENT_POLYGON_2D_LIST_EXT\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_EXT_spatial_plane_tracking\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_SPATIAL_COMPONENT_PLANE_SEMANTIC_LABEL_LIST_EXT:
            // Enum value XR_TYPE_SPATIAL_COMPONENT_PLANE_SEMANTIC_LABEL_LIST_EXT requires extension XR_EXT_spatial_plane_tracking, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_EXT_spatial_plane_tracking")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_SPATIAL_COMPONENT_PLANE_SEMANTIC_LABEL_LIST_EXT\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_EXT_spatial_plane_tracking\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_SPATIAL_CAPABILITY_CONFIGURATION_QR_CODE_EXT:
            // Enum value XR_TYPE_SPATIAL_CAPABILITY_CONFIGURATION_QR_CODE_EXT requires extension XR_EXT_spatial_marker_tracking, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_EXT_spatial_marker_tracking")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_SPATIAL_CAPABILITY_CONFIGURATION_QR_CODE_EXT\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_EXT_spatial_marker_tracking\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_SPATIAL_CAPABILITY_CONFIGURATION_MICRO_QR_CODE_EXT:
            // Enum value XR_TYPE_SPATIAL_CAPABILITY_CONFIGURATION_MICRO_QR_CODE_EXT requires extension XR_EXT_spatial_marker_tracking, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_EXT_spatial_marker_tracking")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_SPATIAL_CAPABILITY_CONFIGURATION_MICRO_QR_CODE_EXT\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_EXT_spatial_marker_tracking\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_SPATIAL_CAPABILITY_CONFIGURATION_ARUCO_MARKER_EXT:
            // Enum value XR_TYPE_SPATIAL_CAPABILITY_CONFIGURATION_ARUCO_MARKER_EXT requires extension XR_EXT_spatial_marker_tracking, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_EXT_spatial_marker_tracking")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_SPATIAL_CAPABILITY_CONFIGURATION_ARUCO_MARKER_EXT\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_EXT_spatial_marker_tracking\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_SPATIAL_CAPABILITY_CONFIGURATION_APRIL_TAG_EXT:
            // Enum value XR_TYPE_SPATIAL_CAPABILITY_CONFIGURATION_APRIL_TAG_EXT requires extension XR_EXT_spatial_marker_tracking, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_EXT_spatial_marker_tracking")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_SPATIAL_CAPABILITY_CONFIGURATION_APRIL_TAG_EXT\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_EXT_spatial_marker_tracking\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_SPATIAL_MARKER_SIZE_EXT:
            // Enum value XR_TYPE_SPATIAL_MARKER_SIZE_EXT requires extension XR_EXT_spatial_marker_tracking, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_EXT_spatial_marker_tracking")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_SPATIAL_MARKER_SIZE_EXT\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_EXT_spatial_marker_tracking\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_SPATIAL_MARKER_STATIC_OPTIMIZATION_EXT:
            // Enum value XR_TYPE_SPATIAL_MARKER_STATIC_OPTIMIZATION_EXT requires extension XR_EXT_spatial_marker_tracking, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_EXT_spatial_marker_tracking")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_SPATIAL_MARKER_STATIC_OPTIMIZATION_EXT\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_EXT_spatial_marker_tracking\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_SPATIAL_COMPONENT_MARKER_LIST_EXT:
            // Enum value XR_TYPE_SPATIAL_COMPONENT_MARKER_LIST_EXT requires extension XR_EXT_spatial_marker_tracking, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_EXT_spatial_marker_tracking")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_SPATIAL_COMPONENT_MARKER_LIST_EXT\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_EXT_spatial_marker_tracking\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_SPATIAL_CAPABILITY_CONFIGURATION_ANCHOR_EXT:
            // Enum value XR_TYPE_SPATIAL_CAPABILITY_CONFIGURATION_ANCHOR_EXT requires extension XR_EXT_spatial_anchor, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_EXT_spatial_anchor")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_SPATIAL_CAPABILITY_CONFIGURATION_ANCHOR_EXT\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_EXT_spatial_anchor\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_SPATIAL_COMPONENT_ANCHOR_LIST_EXT:
            // Enum value XR_TYPE_SPATIAL_COMPONENT_ANCHOR_LIST_EXT requires extension XR_EXT_spatial_anchor, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_EXT_spatial_anchor")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_SPATIAL_COMPONENT_ANCHOR_LIST_EXT\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_EXT_spatial_anchor\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_SPATIAL_ANCHOR_CREATE_INFO_EXT:
            // Enum value XR_TYPE_SPATIAL_ANCHOR_CREATE_INFO_EXT requires extension XR_EXT_spatial_anchor, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_EXT_spatial_anchor")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_SPATIAL_ANCHOR_CREATE_INFO_EXT\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_EXT_spatial_anchor\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_SPATIAL_PERSISTENCE_CONTEXT_CREATE_INFO_EXT:
            // Enum value XR_TYPE_SPATIAL_PERSISTENCE_CONTEXT_CREATE_INFO_EXT requires extension XR_EXT_spatial_persistence, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_EXT_spatial_persistence")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_SPATIAL_PERSISTENCE_CONTEXT_CREATE_INFO_EXT\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_EXT_spatial_persistence\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_CREATE_SPATIAL_PERSISTENCE_CONTEXT_COMPLETION_EXT:
            // Enum value XR_TYPE_CREATE_SPATIAL_PERSISTENCE_CONTEXT_COMPLETION_EXT requires extension XR_EXT_spatial_persistence, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_EXT_spatial_persistence")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_CREATE_SPATIAL_PERSISTENCE_CONTEXT_COMPLETION_EXT\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_EXT_spatial_persistence\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_SPATIAL_CONTEXT_PERSISTENCE_CONFIG_EXT:
            // Enum value XR_TYPE_SPATIAL_CONTEXT_PERSISTENCE_CONFIG_EXT requires extension XR_EXT_spatial_persistence, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_EXT_spatial_persistence")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_SPATIAL_CONTEXT_PERSISTENCE_CONFIG_EXT\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_EXT_spatial_persistence\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_SPATIAL_DISCOVERY_PERSISTENCE_UUID_FILTER_EXT:
            // Enum value XR_TYPE_SPATIAL_DISCOVERY_PERSISTENCE_UUID_FILTER_EXT requires extension XR_EXT_spatial_persistence, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_EXT_spatial_persistence")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_SPATIAL_DISCOVERY_PERSISTENCE_UUID_FILTER_EXT\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_EXT_spatial_persistence\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_SPATIAL_COMPONENT_PERSISTENCE_LIST_EXT:
            // Enum value XR_TYPE_SPATIAL_COMPONENT_PERSISTENCE_LIST_EXT requires extension XR_EXT_spatial_persistence, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_EXT_spatial_persistence")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_SPATIAL_COMPONENT_PERSISTENCE_LIST_EXT\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_EXT_spatial_persistence\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_SPATIAL_ENTITY_PERSIST_INFO_EXT:
            // Enum value XR_TYPE_SPATIAL_ENTITY_PERSIST_INFO_EXT requires extension XR_EXT_spatial_persistence_operations, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_EXT_spatial_persistence_operations")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_SPATIAL_ENTITY_PERSIST_INFO_EXT\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_EXT_spatial_persistence_operations\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_PERSIST_SPATIAL_ENTITY_COMPLETION_EXT:
            // Enum value XR_TYPE_PERSIST_SPATIAL_ENTITY_COMPLETION_EXT requires extension XR_EXT_spatial_persistence_operations, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_EXT_spatial_persistence_operations")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_PERSIST_SPATIAL_ENTITY_COMPLETION_EXT\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_EXT_spatial_persistence_operations\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_SPATIAL_ENTITY_UNPERSIST_INFO_EXT:
            // Enum value XR_TYPE_SPATIAL_ENTITY_UNPERSIST_INFO_EXT requires extension XR_EXT_spatial_persistence_operations, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_EXT_spatial_persistence_operations")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_SPATIAL_ENTITY_UNPERSIST_INFO_EXT\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_EXT_spatial_persistence_operations\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_UNPERSIST_SPATIAL_ENTITY_COMPLETION_EXT:
            // Enum value XR_TYPE_UNPERSIST_SPATIAL_ENTITY_COMPLETION_EXT requires extension XR_EXT_spatial_persistence_operations, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_EXT_spatial_persistence_operations")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_UNPERSIST_SPATIAL_ENTITY_COMPLETION_EXT\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_EXT_spatial_persistence_operations\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_TYPE_LOADER_INIT_INFO_PROPERTIES_EXT:
            // Enum value XR_TYPE_LOADER_INIT_INFO_PROPERTIES_EXT requires extension XR_EXT_loader_init_properties, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_EXT_loader_init_properties")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrStructureType value \"XR_TYPE_LOADER_INIT_INFO_PROPERTIES_EXT\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_EXT_loader_init_properties\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
    default:
        return false;
}
}

// Function to validate XrFormFactor enum
bool ValidateXrEnum(GenValidUsageXrInstanceInfo *instance_info,
                    const std::string &command_name,
                    const std::string &validation_name,
                    const std::string &item_name,
                    std::vector<GenValidUsageXrObjectInfo>& objects_info,
                    const XrFormFactor value) {
    (void)instance_info;  // quiet warnings
    (void)command_name;  // quiet warnings
    (void)validation_name;  // quiet warnings
    (void)item_name;  // quiet warnings
    (void)objects_info;  // quiet warnings
    switch (value) {
        case XR_FORM_FACTOR_HEAD_MOUNTED_DISPLAY:
            return true;
        case XR_FORM_FACTOR_HANDHELD_DISPLAY:
            return true;
    default:
        return false;
}
}

// Function to validate XrViewConfigurationType enum
bool ValidateXrEnum(GenValidUsageXrInstanceInfo *instance_info,
                    const std::string &command_name,
                    const std::string &validation_name,
                    const std::string &item_name,
                    std::vector<GenValidUsageXrObjectInfo>& objects_info,
                    const XrViewConfigurationType value) {
    (void)instance_info;  // quiet warnings
    (void)command_name;  // quiet warnings
    (void)validation_name;  // quiet warnings
    (void)item_name;  // quiet warnings
    (void)objects_info;  // quiet warnings
    switch (value) {
        case XR_VIEW_CONFIGURATION_TYPE_PRIMARY_MONO:
            return true;
        case XR_VIEW_CONFIGURATION_TYPE_PRIMARY_STEREO:
            return true;
        case XR_VIEW_CONFIGURATION_TYPE_PRIMARY_STEREO_WITH_FOVEATED_INSET:
            return true;
        case XR_VIEW_CONFIGURATION_TYPE_SECONDARY_MONO_FIRST_PERSON_OBSERVER_MSFT:
            // Enum value XR_VIEW_CONFIGURATION_TYPE_SECONDARY_MONO_FIRST_PERSON_OBSERVER_MSFT requires extension XR_MSFT_first_person_observer, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_MSFT_first_person_observer")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrViewConfigurationType value \"XR_VIEW_CONFIGURATION_TYPE_SECONDARY_MONO_FIRST_PERSON_OBSERVER_MSFT\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_MSFT_first_person_observer\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
    default:
        return false;
}
}

// Function to validate XrEnvironmentBlendMode enum
bool ValidateXrEnum(GenValidUsageXrInstanceInfo *instance_info,
                    const std::string &command_name,
                    const std::string &validation_name,
                    const std::string &item_name,
                    std::vector<GenValidUsageXrObjectInfo>& objects_info,
                    const XrEnvironmentBlendMode value) {
    (void)instance_info;  // quiet warnings
    (void)command_name;  // quiet warnings
    (void)validation_name;  // quiet warnings
    (void)item_name;  // quiet warnings
    (void)objects_info;  // quiet warnings
    switch (value) {
        case XR_ENVIRONMENT_BLEND_MODE_OPAQUE:
            return true;
        case XR_ENVIRONMENT_BLEND_MODE_ADDITIVE:
            return true;
        case XR_ENVIRONMENT_BLEND_MODE_ALPHA_BLEND:
            return true;
    default:
        return false;
}
}

// Function to validate XrReferenceSpaceType enum
bool ValidateXrEnum(GenValidUsageXrInstanceInfo *instance_info,
                    const std::string &command_name,
                    const std::string &validation_name,
                    const std::string &item_name,
                    std::vector<GenValidUsageXrObjectInfo>& objects_info,
                    const XrReferenceSpaceType value) {
    (void)instance_info;  // quiet warnings
    (void)command_name;  // quiet warnings
    (void)validation_name;  // quiet warnings
    (void)item_name;  // quiet warnings
    (void)objects_info;  // quiet warnings
    switch (value) {
        case XR_REFERENCE_SPACE_TYPE_VIEW:
            return true;
        case XR_REFERENCE_SPACE_TYPE_LOCAL:
            return true;
        case XR_REFERENCE_SPACE_TYPE_STAGE:
            return true;
        case XR_REFERENCE_SPACE_TYPE_LOCAL_FLOOR:
            return true;
        case XR_REFERENCE_SPACE_TYPE_UNBOUNDED_MSFT:
            // Enum value XR_REFERENCE_SPACE_TYPE_UNBOUNDED_MSFT requires extension XR_MSFT_unbounded_reference_space, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_MSFT_unbounded_reference_space")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrReferenceSpaceType value \"XR_REFERENCE_SPACE_TYPE_UNBOUNDED_MSFT\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_MSFT_unbounded_reference_space\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_REFERENCE_SPACE_TYPE_COMBINED_EYE_VARJO:
            // Enum value XR_REFERENCE_SPACE_TYPE_COMBINED_EYE_VARJO requires extension XR_VARJO_foveated_rendering, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_VARJO_foveated_rendering")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrReferenceSpaceType value \"XR_REFERENCE_SPACE_TYPE_COMBINED_EYE_VARJO\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_VARJO_foveated_rendering\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_REFERENCE_SPACE_TYPE_LOCALIZATION_MAP_ML:
            // Enum value XR_REFERENCE_SPACE_TYPE_LOCALIZATION_MAP_ML requires extension XR_ML_localization_map, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_ML_localization_map")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrReferenceSpaceType value \"XR_REFERENCE_SPACE_TYPE_LOCALIZATION_MAP_ML\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_ML_localization_map\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
    default:
        return false;
}
}

// Function to validate XrActionType enum
bool ValidateXrEnum(GenValidUsageXrInstanceInfo *instance_info,
                    const std::string &command_name,
                    const std::string &validation_name,
                    const std::string &item_name,
                    std::vector<GenValidUsageXrObjectInfo>& objects_info,
                    const XrActionType value) {
    (void)instance_info;  // quiet warnings
    (void)command_name;  // quiet warnings
    (void)validation_name;  // quiet warnings
    (void)item_name;  // quiet warnings
    (void)objects_info;  // quiet warnings
    switch (value) {
        case XR_ACTION_TYPE_BOOLEAN_INPUT:
            return true;
        case XR_ACTION_TYPE_FLOAT_INPUT:
            return true;
        case XR_ACTION_TYPE_VECTOR2F_INPUT:
            return true;
        case XR_ACTION_TYPE_POSE_INPUT:
            return true;
        case XR_ACTION_TYPE_VIBRATION_OUTPUT:
            return true;
    default:
        return false;
}
}

// Function to validate XrEyeVisibility enum
bool ValidateXrEnum(GenValidUsageXrInstanceInfo *instance_info,
                    const std::string &command_name,
                    const std::string &validation_name,
                    const std::string &item_name,
                    std::vector<GenValidUsageXrObjectInfo>& objects_info,
                    const XrEyeVisibility value) {
    (void)instance_info;  // quiet warnings
    (void)command_name;  // quiet warnings
    (void)validation_name;  // quiet warnings
    (void)item_name;  // quiet warnings
    (void)objects_info;  // quiet warnings
    switch (value) {
        case XR_EYE_VISIBILITY_BOTH:
            return true;
        case XR_EYE_VISIBILITY_LEFT:
            return true;
        case XR_EYE_VISIBILITY_RIGHT:
            return true;
    default:
        return false;
}
}

// Function to validate XrSessionState enum
bool ValidateXrEnum(GenValidUsageXrInstanceInfo *instance_info,
                    const std::string &command_name,
                    const std::string &validation_name,
                    const std::string &item_name,
                    std::vector<GenValidUsageXrObjectInfo>& objects_info,
                    const XrSessionState value) {
    (void)instance_info;  // quiet warnings
    (void)command_name;  // quiet warnings
    (void)validation_name;  // quiet warnings
    (void)item_name;  // quiet warnings
    (void)objects_info;  // quiet warnings
    switch (value) {
        case XR_SESSION_STATE_UNKNOWN:
            return true;
        case XR_SESSION_STATE_IDLE:
            return true;
        case XR_SESSION_STATE_READY:
            return true;
        case XR_SESSION_STATE_SYNCHRONIZED:
            return true;
        case XR_SESSION_STATE_VISIBLE:
            return true;
        case XR_SESSION_STATE_FOCUSED:
            return true;
        case XR_SESSION_STATE_STOPPING:
            return true;
        case XR_SESSION_STATE_LOSS_PENDING:
            return true;
        case XR_SESSION_STATE_EXITING:
            return true;
    default:
        return false;
}
}

// Function to validate XrObjectType enum
bool ValidateXrEnum(GenValidUsageXrInstanceInfo *instance_info,
                    const std::string &command_name,
                    const std::string &validation_name,
                    const std::string &item_name,
                    std::vector<GenValidUsageXrObjectInfo>& objects_info,
                    const XrObjectType value) {
    (void)instance_info;  // quiet warnings
    (void)command_name;  // quiet warnings
    (void)validation_name;  // quiet warnings
    (void)item_name;  // quiet warnings
    (void)objects_info;  // quiet warnings
    switch (value) {
        case XR_OBJECT_TYPE_UNKNOWN:
            return true;
        case XR_OBJECT_TYPE_INSTANCE:
            return true;
        case XR_OBJECT_TYPE_SESSION:
            return true;
        case XR_OBJECT_TYPE_SWAPCHAIN:
            return true;
        case XR_OBJECT_TYPE_SPACE:
            return true;
        case XR_OBJECT_TYPE_ACTION_SET:
            return true;
        case XR_OBJECT_TYPE_ACTION:
            return true;
        case XR_OBJECT_TYPE_DEBUG_UTILS_MESSENGER_EXT:
            // Enum value XR_OBJECT_TYPE_DEBUG_UTILS_MESSENGER_EXT requires extension XR_EXT_debug_utils, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_EXT_debug_utils")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrObjectType value \"XR_OBJECT_TYPE_DEBUG_UTILS_MESSENGER_EXT\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_EXT_debug_utils\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_OBJECT_TYPE_SPATIAL_ANCHOR_MSFT:
            // Enum value XR_OBJECT_TYPE_SPATIAL_ANCHOR_MSFT requires extension XR_MSFT_spatial_anchor, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_MSFT_spatial_anchor")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrObjectType value \"XR_OBJECT_TYPE_SPATIAL_ANCHOR_MSFT\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_MSFT_spatial_anchor\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_OBJECT_TYPE_SPATIAL_GRAPH_NODE_BINDING_MSFT:
            // Enum value XR_OBJECT_TYPE_SPATIAL_GRAPH_NODE_BINDING_MSFT requires extension XR_MSFT_spatial_graph_bridge, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_MSFT_spatial_graph_bridge")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrObjectType value \"XR_OBJECT_TYPE_SPATIAL_GRAPH_NODE_BINDING_MSFT\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_MSFT_spatial_graph_bridge\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_OBJECT_TYPE_HAND_TRACKER_EXT:
            // Enum value XR_OBJECT_TYPE_HAND_TRACKER_EXT requires extension XR_EXT_hand_tracking, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_EXT_hand_tracking")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrObjectType value \"XR_OBJECT_TYPE_HAND_TRACKER_EXT\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_EXT_hand_tracking\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_OBJECT_TYPE_BODY_TRACKER_FB:
            // Enum value XR_OBJECT_TYPE_BODY_TRACKER_FB requires extension XR_FB_body_tracking, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_FB_body_tracking")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrObjectType value \"XR_OBJECT_TYPE_BODY_TRACKER_FB\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_FB_body_tracking\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_OBJECT_TYPE_SCENE_OBSERVER_MSFT:
            // Enum value XR_OBJECT_TYPE_SCENE_OBSERVER_MSFT requires extension XR_MSFT_scene_understanding, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_MSFT_scene_understanding")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrObjectType value \"XR_OBJECT_TYPE_SCENE_OBSERVER_MSFT\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_MSFT_scene_understanding\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_OBJECT_TYPE_SCENE_MSFT:
            // Enum value XR_OBJECT_TYPE_SCENE_MSFT requires extension XR_MSFT_scene_understanding, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_MSFT_scene_understanding")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrObjectType value \"XR_OBJECT_TYPE_SCENE_MSFT\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_MSFT_scene_understanding\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_OBJECT_TYPE_FACIAL_TRACKER_HTC:
            // Enum value XR_OBJECT_TYPE_FACIAL_TRACKER_HTC requires extension XR_HTC_facial_tracking, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_HTC_facial_tracking")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrObjectType value \"XR_OBJECT_TYPE_FACIAL_TRACKER_HTC\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_HTC_facial_tracking\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_OBJECT_TYPE_FOVEATION_PROFILE_FB:
            // Enum value XR_OBJECT_TYPE_FOVEATION_PROFILE_FB requires extension XR_FB_foveation, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_FB_foveation")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrObjectType value \"XR_OBJECT_TYPE_FOVEATION_PROFILE_FB\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_FB_foveation\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_OBJECT_TYPE_TRIANGLE_MESH_FB:
            // Enum value XR_OBJECT_TYPE_TRIANGLE_MESH_FB requires extension XR_FB_triangle_mesh, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_FB_triangle_mesh")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrObjectType value \"XR_OBJECT_TYPE_TRIANGLE_MESH_FB\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_FB_triangle_mesh\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_OBJECT_TYPE_PASSTHROUGH_FB:
            // Enum value XR_OBJECT_TYPE_PASSTHROUGH_FB requires extension XR_FB_passthrough, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_FB_passthrough")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrObjectType value \"XR_OBJECT_TYPE_PASSTHROUGH_FB\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_FB_passthrough\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_OBJECT_TYPE_PASSTHROUGH_LAYER_FB:
            // Enum value XR_OBJECT_TYPE_PASSTHROUGH_LAYER_FB requires extension XR_FB_passthrough, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_FB_passthrough")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrObjectType value \"XR_OBJECT_TYPE_PASSTHROUGH_LAYER_FB\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_FB_passthrough\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_OBJECT_TYPE_GEOMETRY_INSTANCE_FB:
            // Enum value XR_OBJECT_TYPE_GEOMETRY_INSTANCE_FB requires extension XR_FB_passthrough, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_FB_passthrough")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrObjectType value \"XR_OBJECT_TYPE_GEOMETRY_INSTANCE_FB\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_FB_passthrough\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_OBJECT_TYPE_MARKER_DETECTOR_ML:
            // Enum value XR_OBJECT_TYPE_MARKER_DETECTOR_ML requires extension XR_ML_marker_understanding, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_ML_marker_understanding")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrObjectType value \"XR_OBJECT_TYPE_MARKER_DETECTOR_ML\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_ML_marker_understanding\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_OBJECT_TYPE_EXPORTED_LOCALIZATION_MAP_ML:
            // Enum value XR_OBJECT_TYPE_EXPORTED_LOCALIZATION_MAP_ML requires extension XR_ML_localization_map, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_ML_localization_map")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrObjectType value \"XR_OBJECT_TYPE_EXPORTED_LOCALIZATION_MAP_ML\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_ML_localization_map\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_OBJECT_TYPE_SPATIAL_ANCHORS_STORAGE_ML:
            // Enum value XR_OBJECT_TYPE_SPATIAL_ANCHORS_STORAGE_ML requires extension XR_ML_spatial_anchors_storage, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_ML_spatial_anchors_storage")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrObjectType value \"XR_OBJECT_TYPE_SPATIAL_ANCHORS_STORAGE_ML\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_ML_spatial_anchors_storage\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_OBJECT_TYPE_SPATIAL_ANCHOR_STORE_CONNECTION_MSFT:
            // Enum value XR_OBJECT_TYPE_SPATIAL_ANCHOR_STORE_CONNECTION_MSFT requires extension XR_MSFT_spatial_anchor_persistence, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_MSFT_spatial_anchor_persistence")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrObjectType value \"XR_OBJECT_TYPE_SPATIAL_ANCHOR_STORE_CONNECTION_MSFT\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_MSFT_spatial_anchor_persistence\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_OBJECT_TYPE_FACE_TRACKER_FB:
            // Enum value XR_OBJECT_TYPE_FACE_TRACKER_FB requires extension XR_FB_face_tracking, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_FB_face_tracking")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrObjectType value \"XR_OBJECT_TYPE_FACE_TRACKER_FB\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_FB_face_tracking\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_OBJECT_TYPE_EYE_TRACKER_FB:
            // Enum value XR_OBJECT_TYPE_EYE_TRACKER_FB requires extension XR_FB_eye_tracking_social, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_FB_eye_tracking_social")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrObjectType value \"XR_OBJECT_TYPE_EYE_TRACKER_FB\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_FB_eye_tracking_social\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_OBJECT_TYPE_VIRTUAL_KEYBOARD_META:
            // Enum value XR_OBJECT_TYPE_VIRTUAL_KEYBOARD_META requires extension XR_META_virtual_keyboard, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_META_virtual_keyboard")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrObjectType value \"XR_OBJECT_TYPE_VIRTUAL_KEYBOARD_META\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_META_virtual_keyboard\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_OBJECT_TYPE_SPACE_USER_FB:
            // Enum value XR_OBJECT_TYPE_SPACE_USER_FB requires extension XR_FB_spatial_entity_user, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_FB_spatial_entity_user")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrObjectType value \"XR_OBJECT_TYPE_SPACE_USER_FB\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_FB_spatial_entity_user\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_OBJECT_TYPE_PASSTHROUGH_COLOR_LUT_META:
            // Enum value XR_OBJECT_TYPE_PASSTHROUGH_COLOR_LUT_META requires extension XR_META_passthrough_color_lut, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_META_passthrough_color_lut")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrObjectType value \"XR_OBJECT_TYPE_PASSTHROUGH_COLOR_LUT_META\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_META_passthrough_color_lut\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_OBJECT_TYPE_FACE_TRACKER2_FB:
            // Enum value XR_OBJECT_TYPE_FACE_TRACKER2_FB requires extension XR_FB_face_tracking2, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_FB_face_tracking2")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrObjectType value \"XR_OBJECT_TYPE_FACE_TRACKER2_FB\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_FB_face_tracking2\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_OBJECT_TYPE_ENVIRONMENT_DEPTH_PROVIDER_META:
            // Enum value XR_OBJECT_TYPE_ENVIRONMENT_DEPTH_PROVIDER_META requires extension XR_META_environment_depth, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_META_environment_depth")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrObjectType value \"XR_OBJECT_TYPE_ENVIRONMENT_DEPTH_PROVIDER_META\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_META_environment_depth\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_OBJECT_TYPE_ENVIRONMENT_DEPTH_SWAPCHAIN_META:
            // Enum value XR_OBJECT_TYPE_ENVIRONMENT_DEPTH_SWAPCHAIN_META requires extension XR_META_environment_depth, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_META_environment_depth")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrObjectType value \"XR_OBJECT_TYPE_ENVIRONMENT_DEPTH_SWAPCHAIN_META\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_META_environment_depth\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_OBJECT_TYPE_RENDER_MODEL_EXT:
            // Enum value XR_OBJECT_TYPE_RENDER_MODEL_EXT requires extension XR_EXT_render_model, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_EXT_render_model")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrObjectType value \"XR_OBJECT_TYPE_RENDER_MODEL_EXT\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_EXT_render_model\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_OBJECT_TYPE_RENDER_MODEL_ASSET_EXT:
            // Enum value XR_OBJECT_TYPE_RENDER_MODEL_ASSET_EXT requires extension XR_EXT_render_model, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_EXT_render_model")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrObjectType value \"XR_OBJECT_TYPE_RENDER_MODEL_ASSET_EXT\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_EXT_render_model\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_OBJECT_TYPE_PASSTHROUGH_HTC:
            // Enum value XR_OBJECT_TYPE_PASSTHROUGH_HTC requires extension XR_HTC_passthrough, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_HTC_passthrough")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrObjectType value \"XR_OBJECT_TYPE_PASSTHROUGH_HTC\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_HTC_passthrough\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_OBJECT_TYPE_BODY_TRACKER_HTC:
            // Enum value XR_OBJECT_TYPE_BODY_TRACKER_HTC requires extension XR_HTC_body_tracking, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_HTC_body_tracking")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrObjectType value \"XR_OBJECT_TYPE_BODY_TRACKER_HTC\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_HTC_body_tracking\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_OBJECT_TYPE_BODY_TRACKER_BD:
            // Enum value XR_OBJECT_TYPE_BODY_TRACKER_BD requires extension XR_BD_body_tracking, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_BD_body_tracking")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrObjectType value \"XR_OBJECT_TYPE_BODY_TRACKER_BD\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_BD_body_tracking\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_OBJECT_TYPE_SENSE_DATA_PROVIDER_BD:
            // Enum value XR_OBJECT_TYPE_SENSE_DATA_PROVIDER_BD requires extension XR_BD_spatial_sensing, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_BD_spatial_sensing")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrObjectType value \"XR_OBJECT_TYPE_SENSE_DATA_PROVIDER_BD\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_BD_spatial_sensing\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_OBJECT_TYPE_SENSE_DATA_SNAPSHOT_BD:
            // Enum value XR_OBJECT_TYPE_SENSE_DATA_SNAPSHOT_BD requires extension XR_BD_spatial_sensing, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_BD_spatial_sensing")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrObjectType value \"XR_OBJECT_TYPE_SENSE_DATA_SNAPSHOT_BD\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_BD_spatial_sensing\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_OBJECT_TYPE_ANCHOR_BD:
            // Enum value XR_OBJECT_TYPE_ANCHOR_BD requires extension XR_BD_spatial_sensing, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_BD_spatial_sensing")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrObjectType value \"XR_OBJECT_TYPE_ANCHOR_BD\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_BD_spatial_sensing\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_OBJECT_TYPE_PLANE_DETECTOR_EXT:
            // Enum value XR_OBJECT_TYPE_PLANE_DETECTOR_EXT requires extension XR_EXT_plane_detection, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_EXT_plane_detection")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrObjectType value \"XR_OBJECT_TYPE_PLANE_DETECTOR_EXT\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_EXT_plane_detection\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_OBJECT_TYPE_TRACKABLE_TRACKER_ANDROID:
            // Enum value XR_OBJECT_TYPE_TRACKABLE_TRACKER_ANDROID requires extension XR_ANDROID_trackables, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_ANDROID_trackables")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrObjectType value \"XR_OBJECT_TYPE_TRACKABLE_TRACKER_ANDROID\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_ANDROID_trackables\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_OBJECT_TYPE_DEVICE_ANCHOR_PERSISTENCE_ANDROID:
            // Enum value XR_OBJECT_TYPE_DEVICE_ANCHOR_PERSISTENCE_ANDROID requires extension XR_ANDROID_device_anchor_persistence, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_ANDROID_device_anchor_persistence")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrObjectType value \"XR_OBJECT_TYPE_DEVICE_ANCHOR_PERSISTENCE_ANDROID\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_ANDROID_device_anchor_persistence\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_OBJECT_TYPE_WORLD_MESH_DETECTOR_ML:
            // Enum value XR_OBJECT_TYPE_WORLD_MESH_DETECTOR_ML requires extension XR_ML_world_mesh_detection, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_ML_world_mesh_detection")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrObjectType value \"XR_OBJECT_TYPE_WORLD_MESH_DETECTOR_ML\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_ML_world_mesh_detection\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_OBJECT_TYPE_FACIAL_EXPRESSION_CLIENT_ML:
            // Enum value XR_OBJECT_TYPE_FACIAL_EXPRESSION_CLIENT_ML requires extension XR_ML_facial_expression, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_ML_facial_expression")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrObjectType value \"XR_OBJECT_TYPE_FACIAL_EXPRESSION_CLIENT_ML\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_ML_facial_expression\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_OBJECT_TYPE_SPATIAL_ENTITY_EXT:
            // Enum value XR_OBJECT_TYPE_SPATIAL_ENTITY_EXT requires extension XR_EXT_spatial_entity, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_EXT_spatial_entity")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrObjectType value \"XR_OBJECT_TYPE_SPATIAL_ENTITY_EXT\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_EXT_spatial_entity\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_OBJECT_TYPE_SPATIAL_CONTEXT_EXT:
            // Enum value XR_OBJECT_TYPE_SPATIAL_CONTEXT_EXT requires extension XR_EXT_spatial_entity, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_EXT_spatial_entity")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrObjectType value \"XR_OBJECT_TYPE_SPATIAL_CONTEXT_EXT\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_EXT_spatial_entity\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_OBJECT_TYPE_SPATIAL_SNAPSHOT_EXT:
            // Enum value XR_OBJECT_TYPE_SPATIAL_SNAPSHOT_EXT requires extension XR_EXT_spatial_entity, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_EXT_spatial_entity")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrObjectType value \"XR_OBJECT_TYPE_SPATIAL_SNAPSHOT_EXT\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_EXT_spatial_entity\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
        case XR_OBJECT_TYPE_SPATIAL_PERSISTENCE_CONTEXT_EXT:
            // Enum value XR_OBJECT_TYPE_SPATIAL_PERSISTENCE_CONTEXT_EXT requires extension XR_EXT_spatial_persistence, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_EXT_spatial_persistence")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrObjectType value \"XR_OBJECT_TYPE_SPATIAL_PERSISTENCE_CONTEXT_EXT\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_EXT_spatial_persistence\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
    default:
        return false;
}
}

#if defined(XR_USE_PLATFORM_ANDROID)
// Function to validate XrAndroidThreadTypeKHR enum
bool ValidateXrEnum(GenValidUsageXrInstanceInfo *instance_info,
                    const std::string &command_name,
                    const std::string &validation_name,
                    const std::string &item_name,
                    std::vector<GenValidUsageXrObjectInfo>& objects_info,
                    const XrAndroidThreadTypeKHR value) {
    (void)instance_info;  // quiet warnings
    (void)command_name;  // quiet warnings
    (void)validation_name;  // quiet warnings
    (void)item_name;  // quiet warnings
    (void)objects_info;  // quiet warnings
    // Enum requires extension XR_KHR_android_thread_settings, so check that it is enabled
    if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_KHR_android_thread_settings")) {
        std::string vuid = "VUID-";
        vuid += validation_name;
        vuid += "-";
        vuid += item_name;
        vuid += "-parameter";
        std::string error_str = "XrAndroidThreadTypeKHR requires extension ";
        error_str += " \"XR_KHR_android_thread_settings\" to be enabled, but it is not enabled";
        CoreValidLogMessage(instance_info, vuid,
                            VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                            objects_info, error_str);
        return false;
    }
    switch (value) {
        case XR_ANDROID_THREAD_TYPE_APPLICATION_MAIN_KHR:
            return true;
        case XR_ANDROID_THREAD_TYPE_APPLICATION_WORKER_KHR:
            return true;
        case XR_ANDROID_THREAD_TYPE_RENDERER_MAIN_KHR:
            return true;
        case XR_ANDROID_THREAD_TYPE_RENDERER_WORKER_KHR:
            return true;
    default:
        return false;
}
}

#endif // defined(XR_USE_PLATFORM_ANDROID)
// Function to validate XrVisibilityMaskTypeKHR enum
bool ValidateXrEnum(GenValidUsageXrInstanceInfo *instance_info,
                    const std::string &command_name,
                    const std::string &validation_name,
                    const std::string &item_name,
                    std::vector<GenValidUsageXrObjectInfo>& objects_info,
                    const XrVisibilityMaskTypeKHR value) {
    (void)instance_info;  // quiet warnings
    (void)command_name;  // quiet warnings
    (void)validation_name;  // quiet warnings
    (void)item_name;  // quiet warnings
    (void)objects_info;  // quiet warnings
    // Enum requires extension XR_KHR_visibility_mask, so check that it is enabled
    if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_KHR_visibility_mask")) {
        std::string vuid = "VUID-";
        vuid += validation_name;
        vuid += "-";
        vuid += item_name;
        vuid += "-parameter";
        std::string error_str = "XrVisibilityMaskTypeKHR requires extension ";
        error_str += " \"XR_KHR_visibility_mask\" to be enabled, but it is not enabled";
        CoreValidLogMessage(instance_info, vuid,
                            VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                            objects_info, error_str);
        return false;
    }
    switch (value) {
        case XR_VISIBILITY_MASK_TYPE_HIDDEN_TRIANGLE_MESH_KHR:
            return true;
        case XR_VISIBILITY_MASK_TYPE_VISIBLE_TRIANGLE_MESH_KHR:
            return true;
        case XR_VISIBILITY_MASK_TYPE_LINE_LOOP_KHR:
            return true;
    default:
        return false;
}
}

// Function to validate XrPerfSettingsDomainEXT enum
bool ValidateXrEnum(GenValidUsageXrInstanceInfo *instance_info,
                    const std::string &command_name,
                    const std::string &validation_name,
                    const std::string &item_name,
                    std::vector<GenValidUsageXrObjectInfo>& objects_info,
                    const XrPerfSettingsDomainEXT value) {
    (void)instance_info;  // quiet warnings
    (void)command_name;  // quiet warnings
    (void)validation_name;  // quiet warnings
    (void)item_name;  // quiet warnings
    (void)objects_info;  // quiet warnings
    // Enum requires extension XR_EXT_performance_settings, so check that it is enabled
    if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_EXT_performance_settings")) {
        std::string vuid = "VUID-";
        vuid += validation_name;
        vuid += "-";
        vuid += item_name;
        vuid += "-parameter";
        std::string error_str = "XrPerfSettingsDomainEXT requires extension ";
        error_str += " \"XR_EXT_performance_settings\" to be enabled, but it is not enabled";
        CoreValidLogMessage(instance_info, vuid,
                            VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                            objects_info, error_str);
        return false;
    }
    switch (value) {
        case XR_PERF_SETTINGS_DOMAIN_CPU_EXT:
            return true;
        case XR_PERF_SETTINGS_DOMAIN_GPU_EXT:
            return true;
    default:
        return false;
}
}

// Function to validate XrPerfSettingsSubDomainEXT enum
bool ValidateXrEnum(GenValidUsageXrInstanceInfo *instance_info,
                    const std::string &command_name,
                    const std::string &validation_name,
                    const std::string &item_name,
                    std::vector<GenValidUsageXrObjectInfo>& objects_info,
                    const XrPerfSettingsSubDomainEXT value) {
    (void)instance_info;  // quiet warnings
    (void)command_name;  // quiet warnings
    (void)validation_name;  // quiet warnings
    (void)item_name;  // quiet warnings
    (void)objects_info;  // quiet warnings
    // Enum requires extension XR_EXT_performance_settings, so check that it is enabled
    if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_EXT_performance_settings")) {
        std::string vuid = "VUID-";
        vuid += validation_name;
        vuid += "-";
        vuid += item_name;
        vuid += "-parameter";
        std::string error_str = "XrPerfSettingsSubDomainEXT requires extension ";
        error_str += " \"XR_EXT_performance_settings\" to be enabled, but it is not enabled";
        CoreValidLogMessage(instance_info, vuid,
                            VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                            objects_info, error_str);
        return false;
    }
    switch (value) {
        case XR_PERF_SETTINGS_SUB_DOMAIN_COMPOSITING_EXT:
            return true;
        case XR_PERF_SETTINGS_SUB_DOMAIN_RENDERING_EXT:
            return true;
        case XR_PERF_SETTINGS_SUB_DOMAIN_THERMAL_EXT:
            return true;
    default:
        return false;
}
}

// Function to validate XrPerfSettingsLevelEXT enum
bool ValidateXrEnum(GenValidUsageXrInstanceInfo *instance_info,
                    const std::string &command_name,
                    const std::string &validation_name,
                    const std::string &item_name,
                    std::vector<GenValidUsageXrObjectInfo>& objects_info,
                    const XrPerfSettingsLevelEXT value) {
    (void)instance_info;  // quiet warnings
    (void)command_name;  // quiet warnings
    (void)validation_name;  // quiet warnings
    (void)item_name;  // quiet warnings
    (void)objects_info;  // quiet warnings
    // Enum requires extension XR_EXT_performance_settings, so check that it is enabled
    if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_EXT_performance_settings")) {
        std::string vuid = "VUID-";
        vuid += validation_name;
        vuid += "-";
        vuid += item_name;
        vuid += "-parameter";
        std::string error_str = "XrPerfSettingsLevelEXT requires extension ";
        error_str += " \"XR_EXT_performance_settings\" to be enabled, but it is not enabled";
        CoreValidLogMessage(instance_info, vuid,
                            VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                            objects_info, error_str);
        return false;
    }
    switch (value) {
        case XR_PERF_SETTINGS_LEVEL_POWER_SAVINGS_EXT:
            return true;
        case XR_PERF_SETTINGS_LEVEL_SUSTAINED_LOW_EXT:
            return true;
        case XR_PERF_SETTINGS_LEVEL_SUSTAINED_HIGH_EXT:
            return true;
        case XR_PERF_SETTINGS_LEVEL_BOOST_EXT:
            return true;
    default:
        return false;
}
}

// Function to validate XrPerfSettingsNotificationLevelEXT enum
bool ValidateXrEnum(GenValidUsageXrInstanceInfo *instance_info,
                    const std::string &command_name,
                    const std::string &validation_name,
                    const std::string &item_name,
                    std::vector<GenValidUsageXrObjectInfo>& objects_info,
                    const XrPerfSettingsNotificationLevelEXT value) {
    (void)instance_info;  // quiet warnings
    (void)command_name;  // quiet warnings
    (void)validation_name;  // quiet warnings
    (void)item_name;  // quiet warnings
    (void)objects_info;  // quiet warnings
    // Enum requires extension XR_EXT_performance_settings, so check that it is enabled
    if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_EXT_performance_settings")) {
        std::string vuid = "VUID-";
        vuid += validation_name;
        vuid += "-";
        vuid += item_name;
        vuid += "-parameter";
        std::string error_str = "XrPerfSettingsNotificationLevelEXT requires extension ";
        error_str += " \"XR_EXT_performance_settings\" to be enabled, but it is not enabled";
        CoreValidLogMessage(instance_info, vuid,
                            VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                            objects_info, error_str);
        return false;
    }
    switch (value) {
        case XR_PERF_SETTINGS_NOTIF_LEVEL_NORMAL_EXT:
            return true;
        case XR_PERF_SETTINGS_NOTIF_LEVEL_WARNING_EXT:
            return true;
        case XR_PERF_SETTINGS_NOTIF_LEVEL_IMPAIRED_EXT:
            return true;
    default:
        return false;
}
}

// Function to validate XrBlendFactorFB enum
bool ValidateXrEnum(GenValidUsageXrInstanceInfo *instance_info,
                    const std::string &command_name,
                    const std::string &validation_name,
                    const std::string &item_name,
                    std::vector<GenValidUsageXrObjectInfo>& objects_info,
                    const XrBlendFactorFB value) {
    (void)instance_info;  // quiet warnings
    (void)command_name;  // quiet warnings
    (void)validation_name;  // quiet warnings
    (void)item_name;  // quiet warnings
    (void)objects_info;  // quiet warnings
    // Enum requires extension XR_FB_composition_layer_alpha_blend, so check that it is enabled
    if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_FB_composition_layer_alpha_blend")) {
        std::string vuid = "VUID-";
        vuid += validation_name;
        vuid += "-";
        vuid += item_name;
        vuid += "-parameter";
        std::string error_str = "XrBlendFactorFB requires extension ";
        error_str += " \"XR_FB_composition_layer_alpha_blend\" to be enabled, but it is not enabled";
        CoreValidLogMessage(instance_info, vuid,
                            VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                            objects_info, error_str);
        return false;
    }
    switch (value) {
        case XR_BLEND_FACTOR_ZERO_FB:
            return true;
        case XR_BLEND_FACTOR_ONE_FB:
            return true;
        case XR_BLEND_FACTOR_SRC_ALPHA_FB:
            return true;
        case XR_BLEND_FACTOR_ONE_MINUS_SRC_ALPHA_FB:
            return true;
        case XR_BLEND_FACTOR_DST_ALPHA_FB:
            return true;
        case XR_BLEND_FACTOR_ONE_MINUS_DST_ALPHA_FB:
            return true;
    default:
        return false;
}
}

// Function to validate XrSpatialGraphNodeTypeMSFT enum
bool ValidateXrEnum(GenValidUsageXrInstanceInfo *instance_info,
                    const std::string &command_name,
                    const std::string &validation_name,
                    const std::string &item_name,
                    std::vector<GenValidUsageXrObjectInfo>& objects_info,
                    const XrSpatialGraphNodeTypeMSFT value) {
    (void)instance_info;  // quiet warnings
    (void)command_name;  // quiet warnings
    (void)validation_name;  // quiet warnings
    (void)item_name;  // quiet warnings
    (void)objects_info;  // quiet warnings
    // Enum requires extension XR_MSFT_spatial_graph_bridge, so check that it is enabled
    if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_MSFT_spatial_graph_bridge")) {
        std::string vuid = "VUID-";
        vuid += validation_name;
        vuid += "-";
        vuid += item_name;
        vuid += "-parameter";
        std::string error_str = "XrSpatialGraphNodeTypeMSFT requires extension ";
        error_str += " \"XR_MSFT_spatial_graph_bridge\" to be enabled, but it is not enabled";
        CoreValidLogMessage(instance_info, vuid,
                            VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                            objects_info, error_str);
        return false;
    }
    switch (value) {
        case XR_SPATIAL_GRAPH_NODE_TYPE_STATIC_MSFT:
            return true;
        case XR_SPATIAL_GRAPH_NODE_TYPE_DYNAMIC_MSFT:
            return true;
    default:
        return false;
}
}

// Function to validate XrHandEXT enum
bool ValidateXrEnum(GenValidUsageXrInstanceInfo *instance_info,
                    const std::string &command_name,
                    const std::string &validation_name,
                    const std::string &item_name,
                    std::vector<GenValidUsageXrObjectInfo>& objects_info,
                    const XrHandEXT value) {
    (void)instance_info;  // quiet warnings
    (void)command_name;  // quiet warnings
    (void)validation_name;  // quiet warnings
    (void)item_name;  // quiet warnings
    (void)objects_info;  // quiet warnings
    // Enum requires extension XR_EXT_hand_tracking, so check that it is enabled
    if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_EXT_hand_tracking")) {
        std::string vuid = "VUID-";
        vuid += validation_name;
        vuid += "-";
        vuid += item_name;
        vuid += "-parameter";
        std::string error_str = "XrHandEXT requires extension ";
        error_str += " \"XR_EXT_hand_tracking\" to be enabled, but it is not enabled";
        CoreValidLogMessage(instance_info, vuid,
                            VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                            objects_info, error_str);
        return false;
    }
    switch (value) {
        case XR_HAND_LEFT_EXT:
            return true;
        case XR_HAND_RIGHT_EXT:
            return true;
    default:
        return false;
}
}

// Function to validate XrHandJointEXT enum
bool ValidateXrEnum(GenValidUsageXrInstanceInfo *instance_info,
                    const std::string &command_name,
                    const std::string &validation_name,
                    const std::string &item_name,
                    std::vector<GenValidUsageXrObjectInfo>& objects_info,
                    const XrHandJointEXT value) {
    (void)instance_info;  // quiet warnings
    (void)command_name;  // quiet warnings
    (void)validation_name;  // quiet warnings
    (void)item_name;  // quiet warnings
    (void)objects_info;  // quiet warnings
    // Enum requires extension XR_EXT_hand_tracking, so check that it is enabled
    if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_EXT_hand_tracking")) {
        std::string vuid = "VUID-";
        vuid += validation_name;
        vuid += "-";
        vuid += item_name;
        vuid += "-parameter";
        std::string error_str = "XrHandJointEXT requires extension ";
        error_str += " \"XR_EXT_hand_tracking\" to be enabled, but it is not enabled";
        CoreValidLogMessage(instance_info, vuid,
                            VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                            objects_info, error_str);
        return false;
    }
    switch (value) {
        case XR_HAND_JOINT_PALM_EXT:
            return true;
        case XR_HAND_JOINT_WRIST_EXT:
            return true;
        case XR_HAND_JOINT_THUMB_METACARPAL_EXT:
            return true;
        case XR_HAND_JOINT_THUMB_PROXIMAL_EXT:
            return true;
        case XR_HAND_JOINT_THUMB_DISTAL_EXT:
            return true;
        case XR_HAND_JOINT_THUMB_TIP_EXT:
            return true;
        case XR_HAND_JOINT_INDEX_METACARPAL_EXT:
            return true;
        case XR_HAND_JOINT_INDEX_PROXIMAL_EXT:
            return true;
        case XR_HAND_JOINT_INDEX_INTERMEDIATE_EXT:
            return true;
        case XR_HAND_JOINT_INDEX_DISTAL_EXT:
            return true;
        case XR_HAND_JOINT_INDEX_TIP_EXT:
            return true;
        case XR_HAND_JOINT_MIDDLE_METACARPAL_EXT:
            return true;
        case XR_HAND_JOINT_MIDDLE_PROXIMAL_EXT:
            return true;
        case XR_HAND_JOINT_MIDDLE_INTERMEDIATE_EXT:
            return true;
        case XR_HAND_JOINT_MIDDLE_DISTAL_EXT:
            return true;
        case XR_HAND_JOINT_MIDDLE_TIP_EXT:
            return true;
        case XR_HAND_JOINT_RING_METACARPAL_EXT:
            return true;
        case XR_HAND_JOINT_RING_PROXIMAL_EXT:
            return true;
        case XR_HAND_JOINT_RING_INTERMEDIATE_EXT:
            return true;
        case XR_HAND_JOINT_RING_DISTAL_EXT:
            return true;
        case XR_HAND_JOINT_RING_TIP_EXT:
            return true;
        case XR_HAND_JOINT_LITTLE_METACARPAL_EXT:
            return true;
        case XR_HAND_JOINT_LITTLE_PROXIMAL_EXT:
            return true;
        case XR_HAND_JOINT_LITTLE_INTERMEDIATE_EXT:
            return true;
        case XR_HAND_JOINT_LITTLE_DISTAL_EXT:
            return true;
        case XR_HAND_JOINT_LITTLE_TIP_EXT:
            return true;
    default:
        return false;
}
}

// Function to validate XrHandJointSetEXT enum
bool ValidateXrEnum(GenValidUsageXrInstanceInfo *instance_info,
                    const std::string &command_name,
                    const std::string &validation_name,
                    const std::string &item_name,
                    std::vector<GenValidUsageXrObjectInfo>& objects_info,
                    const XrHandJointSetEXT value) {
    (void)instance_info;  // quiet warnings
    (void)command_name;  // quiet warnings
    (void)validation_name;  // quiet warnings
    (void)item_name;  // quiet warnings
    (void)objects_info;  // quiet warnings
    // Enum requires extension XR_EXT_hand_tracking, so check that it is enabled
    if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_EXT_hand_tracking")) {
        std::string vuid = "VUID-";
        vuid += validation_name;
        vuid += "-";
        vuid += item_name;
        vuid += "-parameter";
        std::string error_str = "XrHandJointSetEXT requires extension ";
        error_str += " \"XR_EXT_hand_tracking\" to be enabled, but it is not enabled";
        CoreValidLogMessage(instance_info, vuid,
                            VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                            objects_info, error_str);
        return false;
    }
    switch (value) {
        case XR_HAND_JOINT_SET_DEFAULT_EXT:
            return true;
        case XR_HAND_JOINT_SET_HAND_WITH_FOREARM_ULTRALEAP:
            // Enum value XR_HAND_JOINT_SET_HAND_WITH_FOREARM_ULTRALEAP requires extension XR_ULTRALEAP_hand_tracking_forearm, so check that it is enabled
            if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_ULTRALEAP_hand_tracking_forearm")) {
                std::string vuid = "VUID-";
                vuid += validation_name;
                vuid += "-";
                vuid += item_name;
                vuid += "-parameter";
                std::string error_str = "XrHandJointSetEXT value \"XR_HAND_JOINT_SET_HAND_WITH_FOREARM_ULTRALEAP\"";
                error_str += " being used, which requires extension ";
                error_str += " \"XR_ULTRALEAP_hand_tracking_forearm\" to be enabled, but it is not enabled";
                CoreValidLogMessage(instance_info, vuid,
                                    VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                                    objects_info, error_str);
                return false;
            }
            return true;
    default:
        return false;
}
}

// Function to validate XrHandPoseTypeMSFT enum
bool ValidateXrEnum(GenValidUsageXrInstanceInfo *instance_info,
                    const std::string &command_name,
                    const std::string &validation_name,
                    const std::string &item_name,
                    std::vector<GenValidUsageXrObjectInfo>& objects_info,
                    const XrHandPoseTypeMSFT value) {
    (void)instance_info;  // quiet warnings
    (void)command_name;  // quiet warnings
    (void)validation_name;  // quiet warnings
    (void)item_name;  // quiet warnings
    (void)objects_info;  // quiet warnings
    // Enum requires extension XR_MSFT_hand_tracking_mesh, so check that it is enabled
    if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_MSFT_hand_tracking_mesh")) {
        std::string vuid = "VUID-";
        vuid += validation_name;
        vuid += "-";
        vuid += item_name;
        vuid += "-parameter";
        std::string error_str = "XrHandPoseTypeMSFT requires extension ";
        error_str += " \"XR_MSFT_hand_tracking_mesh\" to be enabled, but it is not enabled";
        CoreValidLogMessage(instance_info, vuid,
                            VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                            objects_info, error_str);
        return false;
    }
    switch (value) {
        case XR_HAND_POSE_TYPE_TRACKED_MSFT:
            return true;
        case XR_HAND_POSE_TYPE_REFERENCE_OPEN_PALM_MSFT:
            return true;
    default:
        return false;
}
}

// Function to validate XrReprojectionModeMSFT enum
bool ValidateXrEnum(GenValidUsageXrInstanceInfo *instance_info,
                    const std::string &command_name,
                    const std::string &validation_name,
                    const std::string &item_name,
                    std::vector<GenValidUsageXrObjectInfo>& objects_info,
                    const XrReprojectionModeMSFT value) {
    (void)instance_info;  // quiet warnings
    (void)command_name;  // quiet warnings
    (void)validation_name;  // quiet warnings
    (void)item_name;  // quiet warnings
    (void)objects_info;  // quiet warnings
    // Enum requires extension XR_MSFT_composition_layer_reprojection, so check that it is enabled
    if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_MSFT_composition_layer_reprojection")) {
        std::string vuid = "VUID-";
        vuid += validation_name;
        vuid += "-";
        vuid += item_name;
        vuid += "-parameter";
        std::string error_str = "XrReprojectionModeMSFT requires extension ";
        error_str += " \"XR_MSFT_composition_layer_reprojection\" to be enabled, but it is not enabled";
        CoreValidLogMessage(instance_info, vuid,
                            VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                            objects_info, error_str);
        return false;
    }
    switch (value) {
        case XR_REPROJECTION_MODE_DEPTH_MSFT:
            return true;
        case XR_REPROJECTION_MODE_PLANAR_FROM_DEPTH_MSFT:
            return true;
        case XR_REPROJECTION_MODE_PLANAR_MANUAL_MSFT:
            return true;
        case XR_REPROJECTION_MODE_ORIENTATION_ONLY_MSFT:
            return true;
    default:
        return false;
}
}

// Function to validate XrBodyJointFB enum
bool ValidateXrEnum(GenValidUsageXrInstanceInfo *instance_info,
                    const std::string &command_name,
                    const std::string &validation_name,
                    const std::string &item_name,
                    std::vector<GenValidUsageXrObjectInfo>& objects_info,
                    const XrBodyJointFB value) {
    (void)instance_info;  // quiet warnings
    (void)command_name;  // quiet warnings
    (void)validation_name;  // quiet warnings
    (void)item_name;  // quiet warnings
    (void)objects_info;  // quiet warnings
    // Enum requires extension XR_FB_body_tracking, so check that it is enabled
    if (nullptr != instance_info && !ExtensionEnabled(instance_info->enabled_extensions, "XR_FB_body_tracking")) {
        std::string vuid = "VUID-";
        vuid += validation_name;
        vuid += "-";
        vuid += item_name;
        vuid += "-parameter";
        std::string error_str = "XrBodyJointFB requires extension ";
        error_str += " \"XR_FB_body_tracking\" to be enabled, but it is not enabled";
        CoreValidLogMessage(instance_info, vuid,
                            VALID_USAGE_DEBUG_SEVERITY_ERROR, command_name,
                            objects_info, error_str);
        return false;
    }
    switch (value) {
        case XR_BODY_JOINT_ROOT_FB:
            return true;
        case XR_BODY_JOINT_HIPS_FB:
            return true;
        case XR_BODY_JOINT_SPINE_LOWER_FB:
            return true;
        case XR_BODY_JOINT_SPINE_MIDDLE_FB:
            return true;
        case XR_BODY_JOINT_SPINE_UPPER_FB:
            return true;
        case XR_BODY_JOINT_CHEST_FB:
            return true;
        case XR_BODY_JOINT_NECK_FB:
            return true;
        case XR_BODY_JOINT_HEAD_FB:
            return true;
        case XR_BODY_JOINT_LEFT_SHOULDER_FB:
            return true;
        case XR_BODY_JOINT_LEFT_SCAPULA_FB:
            return true;
        case XR_BODY_JOINT_LEFT_ARM_UPPER_FB:
            return true;
        case XR_BODY_JOINT_LEFT_ARM_LOWER_FB:
            return true;
        case XR_BODY_JOINT_LEFT_HAND_WRIST_TWIST_FB:
            return true;
        case XR_BODY_JOINT_RIGHT_SHOULDER_FB:
            return true;
        case XR_BODY_JOINT_RIGHT_SCAPULA_FB:
            return true;
        case XR_BODY_JOINT_RIGHT_ARM_UPPER_FB:
            return true;
        case XR_BODY_JOINT_RIGHT_ARM_LOWER_FB:
            return true;
        case XR_BODY_JOINT_RIGHT_HAND_WRIST_TWIST_FB:
            return true;
        case XR_BODY_JOINT_LEFT_HAND_PALM_FB:
            return true;
        case XR_BODY_JOINT_LEFT_HAND_WRIST_FB:
            return true;
        case XR_BODY_JOINT_LEFT_HAND_THUMB_METACARPAL_FB:
            return true;
        case XR_BODY_JOINT_LEFT_HAND_THUMB_PROXIMAL_FB:
            return true;
        case XR_BODY_JOINT_LEFT_HAND_THUMB_DISTAL_FB:
            return true;
        case XR_BODY_JOINT_LEFT_HAND_THUMB_TIP_FB:
            return true;
        case XR_BODY_JOINT_LEFT_HAND_INDEX_METACARPAL_FB:
            return true;
        case XR_BODY_JOINT_LEFT_HAND_INDEX_PROXIMAL_FB:
            return true;
        case XR_BODY_JOINT_LEFT_HAND_INDEX_INTERMEDIATE_FB:
            return true;
        case XR_BODY_JOINT_LEFT_HAND_INDEX_DISTAL_FB:
            return true;
        case XR_BODY_JOINT_LEFT_HAND_INDEX_TIP_FB:
            return true;
        case XR_BODY_JOINT_LEFT_HAND_MIDDLE_METACARPAL_FB:
            return true;
        case XR_BODY_JOINT_LEFT_HAND_MIDDLE_PROXIMAL_FB:
            return true;
        case XR_BODY_JOINT_LEFT_HAND_MIDDLE_INTERMEDIATE_FB:
            return true;
        case XR_BODY_JOINT_LEFT_HAND_MIDDLE_DISTAL_FB:
            return true;
        case XR_BODY_JOINT_LEFT_HAND_MIDDLE_TIP_FB:
            return true;
        case XR_BODY_JOINT_LEFT_HAND_RING_METACARPAL_FB:
            return true;
        case XR_BODY_JOINT_LEFT_HAND_RING_PROXIMAL_FB:
            return true;
        case XR_BODY_JOINT_LEFT_HAND_RING_INTERMEDIATE_FB:
            return true;
        case XR_BODY_JOINT_LEFT_HAND_RING_DISTAL_FB:
            return true;
        case XR_BODY_JOINT_LEFT_HAND_RING_TIP_FB:
            return true;
        case XR_BODY_JOINT_LEFT_HAND_LITTLE_METACARPAL_FB:
            return true;
        case XR_BODY_JOINT_LEFT_HAND_LITTLE_PROXIMAL_FB:
            return true;
        case XR_BODY_JOINT_LEFT_HAND_LITTLE_INTERMEDIATE_FB:
            return true;
        case XR_BODY_JOINT_LEFT_HAND_LITTLE_DISTAL_FB:
            return true;
        case XR_BODY_JOINT_LEFT_HAND_LITTLE_TIP_FB:
            return true;
        case XR_BODY_JOINT_RIGHT_HAND_PALM_FB:
            return true;
        case XR_BODY_JOINT_RIGHT_HAND_WRIST_FB:
            return true;
        case XR_BODY_JOINT_RIGHT_HAND_THUMB_METACARPAL_FB:
            return true;
        case XR_BODY_JOINT_RIGHT_HAND_THUMB_PROXIMAL_FB:
            return true;
        case XR_BODY_JOINT_RIGHT_HAND_THUMB_DISTAL_FB:
            return true;
        case XR_BODY_JOINT_RIGHT_HAND_THUMB_TIP_FB:
            return true;
        case XR_BODY_JOINT_RIGHT_HAND_INDEX_METACARPAL_FB:
            return true;
        case XR_BODY_JOINT_RIGHT_HAND_INDEX_PROXIMAL_FB:
            return true;
        case XR_BODY_JOINT_RIGHT_HAND_INDEX_INTERMEDIATE_FB:
            return true;
        case XR_BODY_JOINT_RIGHT_HAND_INDEX_DISTAL_FB:
            return true;
        case XR_BODY_JOINT_RIGHT_HAND_INDEX_TIP_FB:
            return true;
        case XR_BODY_JOINT_RIGHT_HAND_MIDDLE_METACARPAL_FB:
            return true;
        case XR_BODY_JOINT_RIGHT_HAND_MIDDLE_PROXIMAL_FB:
            return true;
        case XR_BODY_JOINT_RIGHT_HAND_MIDDLE_INTERMEDIATE_FB:
            return 