/* BackendsManager.c generated by valac 0.56.17, the Vala compiler
 * generated from BackendsManager.vala, do not modify */

/* -*- Mode: vala; indent-tabs-mode: nil; tab-width: 4 -*-*/
/*-
 * Copyright (c) 2013 Maya Developers (https://launchpad.net/maya)
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301 USA.
 *
 * Authored by: Corentin Noël <tintou@mailoo.org>
 */

#include "elementary-calendar.h"
#include <glib.h>
#include <glib-object.h>
#include <gee.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <gmodule.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	MAYA_BACKENDS_MANAGER_0_PROPERTY,
	MAYA_BACKENDS_MANAGER_NUM_PROPERTIES
};
static GParamSpec* maya_backends_manager_properties[MAYA_BACKENDS_MANAGER_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_module_close0(var) ((var == NULL) ? NULL : (var = (g_module_close (var), NULL)))
typedef MayaBackend* (*MayaBackendsManagerRegisterPluginFunction) (GModule* module);
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
enum  {
	MAYA_BACKENDS_MANAGER_BACKEND_ADDED_SIGNAL,
	MAYA_BACKENDS_MANAGER_BACKEND_REMOVED_SIGNAL,
	MAYA_BACKENDS_MANAGER_NUM_SIGNALS
};
static guint maya_backends_manager_signals[MAYA_BACKENDS_MANAGER_NUM_SIGNALS] = {0};

struct _MayaBackendsManagerPrivate {
	MayaLocalBackend* local_backend;
};

static gint MayaBackendsManager_private_offset;
static gpointer maya_backends_manager_parent_class = NULL;
static MayaBackendsManager* maya_backends_manager_backends_manager;
static MayaBackendsManager* maya_backends_manager_backends_manager = NULL;

static MayaBackendsManager* maya_backends_manager_new (void);
static MayaBackendsManager* maya_backends_manager_construct (GType object_type);
static void maya_backends_manager_find_plugins (MayaBackendsManager* self,
                                         GFile* base_folder);
static void maya_backends_manager_load (MayaBackendsManager* self,
                                 const gchar* path);
static void maya_backends_manager_finalize (GObject * obj);
static GType maya_backends_manager_get_type_once (void);

static inline gpointer
maya_backends_manager_get_instance_private (MayaBackendsManager* self)
{
	return G_STRUCT_MEMBER_P (self, MayaBackendsManager_private_offset);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

MayaBackendsManager*
maya_backends_manager_get_default (void)
{
	MayaBackendsManager* _tmp0_;
	MayaBackendsManager* _tmp2_;
	MayaBackendsManager* _tmp3_;
	MayaBackendsManager* result;
	_tmp0_ = maya_backends_manager_backends_manager;
	if (_tmp0_ == NULL) {
		MayaBackendsManager* _tmp1_;
		_tmp1_ = maya_backends_manager_new ();
		_g_object_unref0 (maya_backends_manager_backends_manager);
		maya_backends_manager_backends_manager = _tmp1_;
	}
	_tmp2_ = maya_backends_manager_backends_manager;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	result = _tmp3_;
	return result;
}

static MayaBackendsManager*
maya_backends_manager_construct (GType object_type)
{
	MayaBackendsManager * self = NULL;
	GeeArrayList* _tmp0_;
	MayaLocalBackend* _tmp1_;
	MayaLocalBackend* _tmp2_;
	GFile* base_folder = NULL;
	GFile* _tmp3_;
	self = (MayaBackendsManager*) g_object_new (object_type, NULL);
	_tmp0_ = gee_array_list_new (MAYA_TYPE_BACKEND, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (self->backends);
	self->backends = _tmp0_;
	_tmp1_ = maya_local_backend_new ();
	_g_object_unref0 (self->priv->local_backend);
	self->priv->local_backend = _tmp1_;
	_tmp2_ = self->priv->local_backend;
	maya_backends_manager_add_backend (self, (MayaBackend*) _tmp2_);
	_tmp3_ = g_file_new_for_path (BUILD_PLUGIN_DIR);
	base_folder = _tmp3_;
	maya_backends_manager_find_plugins (self, base_folder);
	_g_object_unref0 (base_folder);
	return self;
}

static MayaBackendsManager*
maya_backends_manager_new (void)
{
	return maya_backends_manager_construct (MAYA_TYPE_BACKENDS_MANAGER);
}

static void
maya_backends_manager_load (MayaBackendsManager* self,
                            const gchar* path)
{
	GModule* module = NULL;
	GModule* _tmp0_;
	GModule* _tmp1_;
	void* function = NULL;
	GModule* _tmp3_;
	void* _tmp4_ = NULL;
	void* _tmp5_;
	MayaBackendsManagerRegisterPluginFunction register_plugin = NULL;
	void* _tmp6_;
	MayaBackend* plug = NULL;
	MayaBackendsManagerRegisterPluginFunction _tmp7_;
	GModule* _tmp8_;
	MayaBackend* _tmp9_;
	MayaBackend* _tmp10_;
	GModule* _tmp11_;
	MayaBackend* _tmp12_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (path != NULL);
	if (g_module_supported () == FALSE) {
		g_error ("BackendsManager.vala:54: Maya plugins are not supported by this system" \
"!");
	}
	_tmp0_ = g_module_open (path, G_MODULE_BIND_LAZY);
	module = _tmp0_;
	_tmp1_ = module;
	if (_tmp1_ == NULL) {
		const gchar* _tmp2_;
		_tmp2_ = g_module_error ();
		g_critical ("BackendsManager.vala:59: %s", _tmp2_);
		_g_module_close0 (module);
		return;
	}
	_tmp3_ = module;
	g_module_symbol (_tmp3_, "get_backend", &_tmp4_);
	function = _tmp4_;
	_tmp5_ = function;
	if (_tmp5_ == NULL) {
		g_critical ("BackendsManager.vala:66: get_backend () not found in %s", path);
		_g_module_close0 (module);
		return;
	}
	_tmp6_ = function;
	register_plugin = (MayaBackendsManagerRegisterPluginFunction) _tmp6_;
	_tmp7_ = register_plugin;
	_tmp8_ = module;
	_tmp9_ = _tmp7_ (_tmp8_);
	plug = _tmp9_;
	_tmp10_ = plug;
	if (_tmp10_ == NULL) {
		g_critical ("BackendsManager.vala:73: Unknown plugin type for %s !", path);
		_g_object_unref0 (plug);
		_g_module_close0 (module);
		return;
	}
	_tmp11_ = module;
	g_module_make_resident (_tmp11_);
	_tmp12_ = plug;
	maya_backends_manager_add_backend (self, _tmp12_);
	_g_object_unref0 (plug);
	_g_module_close0 (module);
}

static void
maya_backends_manager_find_plugins (MayaBackendsManager* self,
                                    GFile* base_folder)
{
	GFileInfo* file_info = NULL;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (base_folder != NULL);
	file_info = NULL;
	{
		GFileEnumerator* enumerator = NULL;
		GFileEnumerator* _tmp0_;
		_tmp0_ = g_file_enumerate_children (base_folder, G_FILE_ATTRIBUTE_STANDARD_NAME "," G_FILE_ATTRIBUTE_STANDARD_TYPE "," G_FILE_ATTRIBUTE_STANDARD_CONTENT_TYPE, 0, NULL, &_inner_error0_);
		enumerator = _tmp0_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		while (TRUE) {
			GFileInfo* _tmp1_ = NULL;
			GFileEnumerator* _tmp2_;
			GFileInfo* _tmp3_;
			GFileInfo* _tmp4_;
			GFileInfo* _tmp5_;
			GFile* file = NULL;
			GFileInfo* _tmp6_;
			const gchar* _tmp7_;
			GFile* _tmp8_;
			gboolean _tmp9_ = FALSE;
			GFileInfo* _tmp10_;
			_tmp2_ = enumerator;
			_tmp3_ = g_file_enumerator_next_file (_tmp2_, NULL, &_inner_error0_);
			_tmp1_ = _tmp3_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_object_unref0 (enumerator);
				goto __catch0_g_error;
			}
			_tmp4_ = _tmp1_;
			_tmp1_ = NULL;
			_g_object_unref0 (file_info);
			file_info = _tmp4_;
			_tmp5_ = file_info;
			if (!(_tmp5_ != NULL)) {
				_g_object_unref0 (_tmp1_);
				break;
			}
			_tmp6_ = file_info;
			_tmp7_ = g_file_info_get_name (_tmp6_);
			_tmp8_ = g_file_get_child (base_folder, _tmp7_);
			file = _tmp8_;
			_tmp10_ = file_info;
			if (g_file_info_get_file_type (_tmp10_) == G_FILE_TYPE_REGULAR) {
				GFileInfo* _tmp11_;
				const gchar* _tmp12_;
				_tmp11_ = file_info;
				_tmp12_ = g_file_info_get_content_type (_tmp11_);
				_tmp9_ = g_content_type_equals (_tmp12_, "application/x-sharedlib");
			} else {
				_tmp9_ = FALSE;
			}
			if (_tmp9_) {
				GFile* _tmp13_;
				gchar* _tmp14_;
				gchar* _tmp15_;
				_tmp13_ = file;
				_tmp14_ = g_file_get_path (_tmp13_);
				_tmp15_ = _tmp14_;
				maya_backends_manager_load (self, _tmp15_);
				_g_free0 (_tmp15_);
			} else {
				GFileInfo* _tmp16_;
				_tmp16_ = file_info;
				if (g_file_info_get_file_type (_tmp16_) == G_FILE_TYPE_DIRECTORY) {
					GFile* _tmp17_;
					_tmp17_ = file;
					maya_backends_manager_find_plugins (self, _tmp17_);
				}
			}
			_g_object_unref0 (file);
			_g_object_unref0 (_tmp1_);
		}
		_g_object_unref0 (enumerator);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* err = NULL;
		GError* _tmp18_;
		const gchar* _tmp19_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp18_ = err;
		_tmp19_ = _tmp18_->message;
		g_warning ("BackendsManager.vala:94: Unable to scan plugs folder: %s\n", _tmp19_);
		_g_error_free0 (err);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (file_info);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_g_object_unref0 (file_info);
}

void
maya_backends_manager_add_backend (MayaBackendsManager* self,
                                   MayaBackend* b)
{
	GeeArrayList* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (b != NULL);
	_tmp0_ = self->backends;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp0_, b);
	g_signal_emit (self, maya_backends_manager_signals[MAYA_BACKENDS_MANAGER_BACKEND_ADDED_SIGNAL], 0, b);
}

void
maya_backends_manager_remove_backend (MayaBackendsManager* self,
                                      MayaBackend* b)
{
	GeeArrayList* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (b != NULL);
	_tmp0_ = self->backends;
	if (gee_abstract_collection_contains ((GeeAbstractCollection*) _tmp0_, b)) {
		GeeArrayList* _tmp1_;
		_tmp1_ = self->backends;
		gee_abstract_collection_remove ((GeeAbstractCollection*) _tmp1_, b);
		g_signal_emit (self, maya_backends_manager_signals[MAYA_BACKENDS_MANAGER_BACKEND_REMOVED_SIGNAL], 0, b);
	}
}

static void
maya_backends_manager_class_init (MayaBackendsManagerClass * klass,
                                  gpointer klass_data)
{
	maya_backends_manager_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &MayaBackendsManager_private_offset);
	G_OBJECT_CLASS (klass)->finalize = maya_backends_manager_finalize;
	maya_backends_manager_signals[MAYA_BACKENDS_MANAGER_BACKEND_ADDED_SIGNAL] = g_signal_new ("backend-added", MAYA_TYPE_BACKENDS_MANAGER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, MAYA_TYPE_BACKEND);
	maya_backends_manager_signals[MAYA_BACKENDS_MANAGER_BACKEND_REMOVED_SIGNAL] = g_signal_new ("backend-removed", MAYA_TYPE_BACKENDS_MANAGER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, MAYA_TYPE_BACKEND);
}

static void
maya_backends_manager_instance_init (MayaBackendsManager * self,
                                     gpointer klass)
{
	self->priv = maya_backends_manager_get_instance_private (self);
}

static void
maya_backends_manager_finalize (GObject * obj)
{
	MayaBackendsManager * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, MAYA_TYPE_BACKENDS_MANAGER, MayaBackendsManager);
	_g_object_unref0 (self->backends);
	_g_object_unref0 (self->priv->local_backend);
	G_OBJECT_CLASS (maya_backends_manager_parent_class)->finalize (obj);
}

static GType
maya_backends_manager_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (MayaBackendsManagerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) maya_backends_manager_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (MayaBackendsManager), 0, (GInstanceInitFunc) maya_backends_manager_instance_init, NULL };
	GType maya_backends_manager_type_id;
	maya_backends_manager_type_id = g_type_register_static (G_TYPE_OBJECT, "MayaBackendsManager", &g_define_type_info, 0);
	MayaBackendsManager_private_offset = g_type_add_instance_private (maya_backends_manager_type_id, sizeof (MayaBackendsManagerPrivate));
	return maya_backends_manager_type_id;
}

GType
maya_backends_manager_get_type (void)
{
	static volatile gsize maya_backends_manager_type_id__once = 0;
	if (g_once_init_enter (&maya_backends_manager_type_id__once)) {
		GType maya_backends_manager_type_id;
		maya_backends_manager_type_id = maya_backends_manager_get_type_once ();
		g_once_init_leave (&maya_backends_manager_type_id__once, maya_backends_manager_type_id);
	}
	return maya_backends_manager_type_id__once;
}

