/* BookmarkListBox.c generated by valac 0.56.18, the Vala compiler
 * generated from BookmarkListBox.vala, do not modify */

/* BookmarkListBox.vala
 *
 * Copyright 2020 elementary, Inc. <https://elementary.io>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301, USA.
 *
 * Authors : Jeremy Wootten <jeremywootten@gmail.com>
 */

#include <gtk/gtk.h>
#include "pantheon-files-core.h"
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gio/gio.h>
#include <glib/gi18n-lib.h>
#include <granite.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define SIDEBAR_TYPE_BOOKMARK_LIST_BOX (sidebar_bookmark_list_box_get_type ())
#define SIDEBAR_BOOKMARK_LIST_BOX(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SIDEBAR_TYPE_BOOKMARK_LIST_BOX, SidebarBookmarkListBox))
#define SIDEBAR_BOOKMARK_LIST_BOX_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SIDEBAR_TYPE_BOOKMARK_LIST_BOX, SidebarBookmarkListBoxClass))
#define SIDEBAR_IS_BOOKMARK_LIST_BOX(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SIDEBAR_TYPE_BOOKMARK_LIST_BOX))
#define SIDEBAR_IS_BOOKMARK_LIST_BOX_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SIDEBAR_TYPE_BOOKMARK_LIST_BOX))
#define SIDEBAR_BOOKMARK_LIST_BOX_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SIDEBAR_TYPE_BOOKMARK_LIST_BOX, SidebarBookmarkListBoxClass))

typedef struct _SidebarBookmarkListBox SidebarBookmarkListBox;
typedef struct _SidebarBookmarkListBoxClass SidebarBookmarkListBoxClass;
typedef struct _SidebarBookmarkListBoxPrivate SidebarBookmarkListBoxPrivate;
enum  {
	SIDEBAR_BOOKMARK_LIST_BOX_0_PROPERTY,
	SIDEBAR_BOOKMARK_LIST_BOX_SIDEBAR_PROPERTY,
	SIDEBAR_BOOKMARK_LIST_BOX_LIST_BOX_PROPERTY,
	SIDEBAR_BOOKMARK_LIST_BOX_NUM_PROPERTIES
};
static GParamSpec* sidebar_bookmark_list_box_properties[SIDEBAR_BOOKMARK_LIST_BOX_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define SIDEBAR_TYPE_BOOKMARK_ROW (sidebar_bookmark_row_get_type ())
#define SIDEBAR_BOOKMARK_ROW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SIDEBAR_TYPE_BOOKMARK_ROW, SidebarBookmarkRow))
#define SIDEBAR_BOOKMARK_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SIDEBAR_TYPE_BOOKMARK_ROW, SidebarBookmarkRowClass))
#define SIDEBAR_IS_BOOKMARK_ROW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SIDEBAR_TYPE_BOOKMARK_ROW))
#define SIDEBAR_IS_BOOKMARK_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SIDEBAR_TYPE_BOOKMARK_ROW))
#define SIDEBAR_BOOKMARK_ROW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SIDEBAR_TYPE_BOOKMARK_ROW, SidebarBookmarkRowClass))

typedef struct _SidebarBookmarkRow SidebarBookmarkRow;
typedef struct _SidebarBookmarkRowClass SidebarBookmarkRowClass;
typedef struct _Block63Data Block63Data;
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _Block64Data Block64Data;
#define _files_bookmark_unref0(var) ((var == NULL) ? NULL : (var = (files_bookmark_unref (var), NULL)))

struct _SidebarBookmarkListBox {
	GtkBox parent_instance;
	SidebarBookmarkListBoxPrivate * priv;
};

struct _SidebarBookmarkListBoxClass {
	GtkBoxClass parent_class;
	void (*rename_bookmark_by_uri) (SidebarBookmarkListBox* self, const gchar* uri, const gchar* new_name);
	gboolean (*is_drop_target) (SidebarBookmarkListBox* self);
};

struct _SidebarBookmarkListBoxPrivate {
	FilesSidebarInterface* _sidebar;
	GtkListBox* _list_box;
	FilesBookmarkList* bookmark_list;
	FilesTrashMonitor* trash_monitor;
};

struct _Block63Data {
	int _ref_count_;
	SidebarBookmarkListBox* self;
	SidebarBookmarkRow* row;
};

struct _Block64Data {
	int _ref_count_;
	Block63Data * _data63_;
	FilesBookmark* bm;
};

static gint SidebarBookmarkListBox_private_offset;
static gpointer sidebar_bookmark_list_box_parent_class = NULL;
static SidebarSidebarListInterfaceIface * sidebar_bookmark_list_box_sidebar_sidebar_list_interface_parent_iface = NULL;

VALA_EXTERN GType sidebar_bookmark_list_box_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SidebarBookmarkListBox, g_object_unref)
VALA_EXTERN void sidebar_bookmark_list_box_rename_bookmark_by_uri (SidebarBookmarkListBox* self,
                                                       const gchar* uri,
                                                       const gchar* new_name);
VALA_EXTERN gboolean sidebar_bookmark_list_box_is_drop_target (SidebarBookmarkListBox* self);
VALA_EXTERN SidebarBookmarkListBox* sidebar_bookmark_list_box_new (FilesSidebarInterface* sidebar);
VALA_EXTERN SidebarBookmarkListBox* sidebar_bookmark_list_box_construct (GType object_type,
                                                             FilesSidebarInterface* sidebar);
VALA_EXTERN GType sidebar_bookmark_row_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SidebarBookmarkRow, g_object_unref)
VALA_EXTERN SidebarBookmarkRow* sidebar_bookmark_list_box_add_bookmark (SidebarBookmarkListBox* self,
                                                            const gchar* label,
                                                            const gchar* uri,
                                                            GIcon* gicon,
                                                            gboolean pinned,
                                                            gboolean permanent);
static SidebarBookmarkRow* sidebar_bookmark_list_box_insert_bookmark (SidebarBookmarkListBox* self,
                                                               const gchar* label,
                                                               const gchar* uri,
                                                               GIcon* gicon,
                                                               gint index,
                                                               gboolean pinned,
                                                               gboolean permanent);
VALA_EXTERN SidebarBookmarkRow* sidebar_bookmark_row_new (const gchar* _custom_name,
                                              const gchar* uri,
                                              GIcon* gicon,
                                              SidebarSidebarListInterface* list,
                                              gboolean pinned,
                                              gboolean permanent);
VALA_EXTERN SidebarBookmarkRow* sidebar_bookmark_row_construct (GType object_type,
                                                    const gchar* _custom_name,
                                                    const gchar* uri,
                                                    GIcon* gicon,
                                                    SidebarSidebarListInterface* list,
                                                    gboolean pinned,
                                                    gboolean permanent);
static guint32 sidebar_bookmark_list_box_real_add_plugin_item (SidebarSidebarListInterface* base,
                                                        FilesSidebarPluginItem* plugin_item);
static void sidebar_bookmark_list_box_real_select_item (SidebarSidebarListInterface* base,
                                                 GtkListBoxRow* item);
static void sidebar_bookmark_list_box_real_unselect_all_items (SidebarSidebarListInterface* base);
static void sidebar_bookmark_list_box_real_refresh (SidebarSidebarListInterface* base);
static Block63Data* block63_data_ref (Block63Data* _data63_);
static void block63_data_unref (void * _userdata_);
static Block64Data* block64_data_ref (Block64Data* _data64_);
static void block64_data_unref (void * _userdata_);
static void ____lambda170_ (Block64Data* _data64_);
static void _____lambda170__g_object_notify (GObject* _sender,
                                      GParamSpec* pspec,
                                      gpointer self);
VALA_EXTERN gboolean files_is_admin (void);
static void ___lambda171_ (Block63Data* _data63_);
static void ____lambda171__g_object_notify (GObject* _sender,
                                     GParamSpec* pspec,
                                     gpointer self);
static void sidebar_bookmark_list_box_real_rename_bookmark_by_uri (SidebarBookmarkListBox* self,
                                                            const gchar* uri,
                                                            const gchar* new_name);
static gboolean sidebar_bookmark_list_box_real_add_favorite (SidebarSidebarListInterface* base,
                                                      const gchar* uri,
                                                      const gchar* custom_name,
                                                      gint pos);
static gboolean sidebar_bookmark_list_box_real_remove_item_by_id (SidebarSidebarListInterface* base,
                                                           guint32 id);
static SidebarSidebarItemInterface* sidebar_bookmark_list_box_real_get_item_at_index (SidebarSidebarListInterface* base,
                                                                               gint index);
static gboolean sidebar_bookmark_list_box_real_move_item_after (SidebarSidebarListInterface* base,
                                                         SidebarSidebarItemInterface* item,
                                                         gint target_index);
static gboolean sidebar_bookmark_list_box_real_is_drop_target (SidebarBookmarkListBox* self);
static GObject * sidebar_bookmark_list_box_constructor (GType type,
                                                 guint n_construct_properties,
                                                 GObjectConstructParam * construct_properties);
static void _sidebar_bookmark_list_box___lambda172_ (SidebarBookmarkListBox* self);
static void __sidebar_bookmark_list_box___lambda172__files_bookmark_list_loaded (FilesBookmarkList* _sender,
                                                                          gpointer self);
static void _sidebar_bookmark_list_box___lambda173_ (SidebarBookmarkListBox* self,
                                              GtkListBoxRow* row);
static void __sidebar_bookmark_list_box___lambda173__gtk_list_box_row_activated (GtkListBox* _sender,
                                                                          GtkListBoxRow* row,
                                                                          gpointer self);
static void _sidebar_bookmark_list_box___lambda174_ (SidebarBookmarkListBox* self,
                                              GtkListBoxRow* row);
static void __sidebar_bookmark_list_box___lambda174__gtk_list_box_row_selected (GtkListBox* _sender,
                                                                         GtkListBoxRow* row,
                                                                         gpointer self);
static void sidebar_bookmark_list_box_finalize (GObject * obj);
static GType sidebar_bookmark_list_box_get_type_once (void);
static void _vala_sidebar_bookmark_list_box_get_property (GObject * object,
                                                   guint property_id,
                                                   GValue * value,
                                                   GParamSpec * pspec);
static void _vala_sidebar_bookmark_list_box_set_property (GObject * object,
                                                   guint property_id,
                                                   const GValue * value,
                                                   GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

static inline gpointer
sidebar_bookmark_list_box_get_instance_private (SidebarBookmarkListBox* self)
{
	return G_STRUCT_MEMBER_P (self, SidebarBookmarkListBox_private_offset);
}

SidebarBookmarkListBox*
sidebar_bookmark_list_box_construct (GType object_type,
                                     FilesSidebarInterface* sidebar)
{
	SidebarBookmarkListBox * self = NULL;
	g_return_val_if_fail (sidebar != NULL, NULL);
	self = (SidebarBookmarkListBox*) g_object_new (object_type, "sidebar", sidebar, NULL);
	return self;
}

SidebarBookmarkListBox*
sidebar_bookmark_list_box_new (FilesSidebarInterface* sidebar)
{
	return sidebar_bookmark_list_box_construct (SIDEBAR_TYPE_BOOKMARK_LIST_BOX, sidebar);
}

SidebarBookmarkRow*
sidebar_bookmark_list_box_add_bookmark (SidebarBookmarkListBox* self,
                                        const gchar* label,
                                        const gchar* uri,
                                        GIcon* gicon,
                                        gboolean pinned,
                                        gboolean permanent)
{
	SidebarBookmarkRow* _tmp0_;
	SidebarBookmarkRow* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (label != NULL, NULL);
	g_return_val_if_fail (uri != NULL, NULL);
	g_return_val_if_fail (gicon != NULL, NULL);
	_tmp0_ = sidebar_bookmark_list_box_insert_bookmark (self, label, uri, gicon, -1, pinned, permanent);
	result = _tmp0_;
	return result;
}

static SidebarBookmarkRow*
sidebar_bookmark_list_box_insert_bookmark (SidebarBookmarkListBox* self,
                                           const gchar* label,
                                           const gchar* uri,
                                           GIcon* gicon,
                                           gint index,
                                           gboolean pinned,
                                           gboolean permanent)
{
	SidebarBookmarkRow* row = NULL;
	SidebarBookmarkRow* _tmp0_;
	SidebarBookmarkRow* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (label != NULL, NULL);
	g_return_val_if_fail (uri != NULL, NULL);
	g_return_val_if_fail (gicon != NULL, NULL);
	if (sidebar_sidebar_list_interface_has_uri ((SidebarSidebarListInterface*) self, uri, NULL)) {
		result = NULL;
		return result;
	}
	_tmp0_ = sidebar_bookmark_row_new (label, uri, gicon, (SidebarSidebarListInterface*) self, pinned, permanent);
	g_object_ref_sink (_tmp0_);
	row = _tmp0_;
	if (index >= 0) {
		GtkListBox* _tmp1_;
		GtkListBox* _tmp2_;
		SidebarBookmarkRow* _tmp3_;
		_tmp1_ = sidebar_sidebar_list_interface_get_list_box ((SidebarSidebarListInterface*) self);
		_tmp2_ = _tmp1_;
		_tmp3_ = row;
		gtk_list_box_insert (_tmp2_, (GtkWidget*) _tmp3_, index);
	} else {
		GtkListBox* _tmp4_;
		GtkListBox* _tmp5_;
		SidebarBookmarkRow* _tmp6_;
		_tmp4_ = sidebar_sidebar_list_interface_get_list_box ((SidebarSidebarListInterface*) self);
		_tmp5_ = _tmp4_;
		_tmp6_ = row;
		gtk_list_box_insert (_tmp5_, (GtkWidget*) _tmp6_, -1);
	}
	result = row;
	return result;
}

static guint32
sidebar_bookmark_list_box_real_add_plugin_item (SidebarSidebarListInterface* base,
                                                FilesSidebarPluginItem* plugin_item)
{
	SidebarBookmarkListBox * self;
	SidebarBookmarkRow* row = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	GIcon* _tmp4_;
	GIcon* _tmp5_;
	SidebarBookmarkRow* _tmp6_;
	guint32 _tmp7_;
	guint32 _tmp8_;
	guint32 result;
	self = (SidebarBookmarkListBox*) base;
	g_return_val_if_fail (plugin_item != NULL, 0U);
	_tmp0_ = files_sidebar_plugin_item_get_name (plugin_item);
	_tmp1_ = _tmp0_;
	_tmp2_ = files_sidebar_plugin_item_get_uri (plugin_item);
	_tmp3_ = _tmp2_;
	_tmp4_ = files_sidebar_plugin_item_get_icon (plugin_item);
	_tmp5_ = _tmp4_;
	_tmp6_ = sidebar_bookmark_list_box_add_bookmark (self, _tmp1_, _tmp3_, _tmp5_, TRUE, TRUE);
	row = _tmp6_;
	sidebar_sidebar_item_interface_update_plugin_data ((SidebarSidebarItemInterface*) row, plugin_item);
	_tmp7_ = sidebar_sidebar_item_interface_get_id ((SidebarSidebarItemInterface*) row);
	_tmp8_ = _tmp7_;
	result = _tmp8_;
	_g_object_unref0 (row);
	return result;
}

static void
sidebar_bookmark_list_box_real_select_item (SidebarSidebarListInterface* base,
                                            GtkListBoxRow* item)
{
	SidebarBookmarkListBox * self;
	gboolean _tmp0_ = FALSE;
	self = (SidebarBookmarkListBox*) base;
	if (item != NULL) {
		_tmp0_ = SIDEBAR_IS_BOOKMARK_ROW (item);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		GtkListBox* _tmp1_;
		GtkListBox* _tmp2_;
		_tmp1_ = sidebar_sidebar_list_interface_get_list_box ((SidebarSidebarListInterface*) self);
		_tmp2_ = _tmp1_;
		gtk_list_box_select_row (_tmp2_, item);
	} else {
		sidebar_sidebar_list_interface_unselect_all_items ((SidebarSidebarListInterface*) self);
	}
}

static void
sidebar_bookmark_list_box_real_unselect_all_items (SidebarSidebarListInterface* base)
{
	SidebarBookmarkListBox * self;
	GtkListBox* _tmp0_;
	GtkListBox* _tmp1_;
	self = (SidebarBookmarkListBox*) base;
	_tmp0_ = sidebar_sidebar_list_interface_get_list_box ((SidebarSidebarListInterface*) self);
	_tmp1_ = _tmp0_;
	gtk_list_box_unselect_all (_tmp1_);
}

static Block63Data*
block63_data_ref (Block63Data* _data63_)
{
	g_atomic_int_inc (&_data63_->_ref_count_);
	return _data63_;
}

static void
block63_data_unref (void * _userdata_)
{
	Block63Data* _data63_;
	_data63_ = (Block63Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data63_->_ref_count_)) {
		SidebarBookmarkListBox* self;
		self = _data63_->self;
		_g_object_unref0 (_data63_->row);
		_g_object_unref0 (self);
		g_slice_free (Block63Data, _data63_);
	}
}

static Block64Data*
block64_data_ref (Block64Data* _data64_)
{
	g_atomic_int_inc (&_data64_->_ref_count_);
	return _data64_;
}

static void
block64_data_unref (void * _userdata_)
{
	Block64Data* _data64_;
	_data64_ = (Block64Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data64_->_ref_count_)) {
		SidebarBookmarkListBox* self;
		self = _data64_->_data63_->self;
		block63_data_unref (_data64_->_data63_);
		_data64_->_data63_ = NULL;
		g_slice_free (Block64Data, _data64_);
	}
}

static void
____lambda170_ (Block64Data* _data64_)
{
	Block63Data* _data63_;
	SidebarBookmarkListBox* self;
	FilesBookmark* _tmp0_;
	SidebarBookmarkRow* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	_data63_ = _data64_->_data63_;
	self = _data63_->self;
	_tmp0_ = _data64_->bm;
	_tmp1_ = _data63_->row;
	_tmp2_ = sidebar_sidebar_item_interface_get_custom_name ((SidebarSidebarItemInterface*) _tmp1_);
	_tmp3_ = _tmp2_;
	files_bookmark_set_custom_name (_tmp0_, _tmp3_);
}

static void
_____lambda170__g_object_notify (GObject* _sender,
                                 GParamSpec* pspec,
                                 gpointer self)
{
	____lambda170_ (self);
}

static void
___lambda171_ (Block63Data* _data63_)
{
	SidebarBookmarkListBox* self;
	SidebarBookmarkRow* _tmp0_;
	FilesTrashMonitor* _tmp1_;
	GIcon* _tmp2_;
	GIcon* _tmp3_;
	self = _data63_->self;
	_tmp0_ = _data63_->row;
	_tmp1_ = self->priv->trash_monitor;
	_tmp2_ = files_trash_monitor_get_icon (_tmp1_);
	_tmp3_ = _tmp2_;
	sidebar_sidebar_item_interface_update_icon ((SidebarSidebarItemInterface*) _tmp0_, _tmp3_);
	_g_object_unref0 (_tmp3_);
}

static void
____lambda171__g_object_notify (GObject* _sender,
                                GParamSpec* pspec,
                                gpointer self)
{
	___lambda171_ (self);
}

static void
sidebar_bookmark_list_box_real_refresh (SidebarSidebarListInterface* base)
{
	SidebarBookmarkListBox * self;
	Block63Data* _data63_;
	gchar* home_uri = NULL;
	gchar* _tmp0_;
	const gchar* _tmp7_;
	FilesBookmarkList* _tmp31_;
	GList* _tmp32_;
	GList* _tmp33_;
	GError* _inner_error0_ = NULL;
	self = (SidebarBookmarkListBox*) base;
	_data63_ = g_slice_new0 (Block63Data);
	_data63_->_ref_count_ = 1;
	_data63_->self = g_object_ref (self);
	sidebar_sidebar_list_interface_clear ((SidebarSidebarListInterface*) self);
	_tmp0_ = g_strdup ("");
	home_uri = _tmp0_;
	{
		gchar* _tmp1_ = NULL;
		gchar* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_;
		gchar* _tmp5_;
		gchar* _tmp6_;
		_tmp2_ = pf_user_utils_get_real_user_home ();
		_tmp3_ = _tmp2_;
		_tmp4_ = g_filename_to_uri (_tmp3_, NULL, &_inner_error0_);
		_tmp5_ = _tmp4_;
		_g_free0 (_tmp3_);
		_tmp1_ = _tmp5_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_CONVERT_ERROR) {
				goto __catch0_g_convert_error;
			}
			_g_free0 (home_uri);
			block63_data_unref (_data63_);
			_data63_ = NULL;
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
		_tmp6_ = _tmp1_;
		_tmp1_ = NULL;
		_g_free0 (home_uri);
		home_uri = _tmp6_;
		_g_free0 (_tmp1_);
	}
	goto __finally0;
	__catch0_g_convert_error:
	{
		g_clear_error (&_inner_error0_);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_free0 (home_uri);
		block63_data_unref (_data63_);
		_data63_ = NULL;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_tmp7_ = home_uri;
	if (g_strcmp0 (_tmp7_, "") != 0) {
		const gchar* _tmp8_;
		GThemedIcon* _tmp9_;
		GThemedIcon* _tmp10_;
		SidebarBookmarkRow* _tmp11_;
		SidebarBookmarkRow* _tmp12_;
		gchar* _tmp13_;
		gchar** _tmp14_;
		gchar** _tmp15_;
		gint _tmp15__length1;
		gchar* _tmp16_;
		gchar* _tmp17_;
		SidebarBookmarkRow* _tmp18_;
		SidebarBookmarkRow* _tmp19_;
		_tmp8_ = home_uri;
		_tmp9_ = (GThemedIcon*) g_themed_icon_new (FILES_ICON_HOME);
		_tmp10_ = _tmp9_;
		_tmp11_ = sidebar_bookmark_list_box_add_bookmark (self, _ ("Home"), _tmp8_, (GIcon*) _tmp10_, TRUE, TRUE);
		_g_object_unref0 (_data63_->row);
		_data63_->row = _tmp11_;
		_g_object_unref0 (_tmp10_);
		_tmp12_ = _data63_->row;
		_tmp13_ = g_strdup ("<Alt>Home");
		_tmp14_ = g_new0 (gchar*, 1 + 1);
		_tmp14_[0] = _tmp13_;
		_tmp15_ = _tmp14_;
		_tmp15__length1 = 1;
		_tmp16_ = granite_markup_accel_tooltip (_tmp15_, (gint) 1, _ ("View the home folder"));
		_tmp17_ = _tmp16_;
		gtk_widget_set_tooltip_markup ((GtkWidget*) _tmp12_, _tmp17_);
		_g_free0 (_tmp17_);
		_tmp15_ = (_vala_array_free (_tmp15_, _tmp15__length1, (GDestroyNotify) g_free), NULL);
		_tmp18_ = _data63_->row;
		sidebar_sidebar_item_interface_set_can_insert_before ((SidebarSidebarItemInterface*) _tmp18_, FALSE);
		_tmp19_ = _data63_->row;
		sidebar_sidebar_item_interface_set_can_insert_after ((SidebarSidebarItemInterface*) _tmp19_, FALSE);
	}
	if (files_file_utils_protocol_is_supported ("recent")) {
		GThemedIcon* _tmp20_;
		GThemedIcon* _tmp21_;
		SidebarBookmarkRow* _tmp22_;
		SidebarBookmarkRow* _tmp23_;
		gchar* _tmp24_;
		gchar** _tmp25_;
		gchar** _tmp26_;
		gint _tmp26__length1;
		gchar* _tmp27_;
		gchar* _tmp28_;
		SidebarBookmarkRow* _tmp29_;
		SidebarBookmarkRow* _tmp30_;
		_tmp20_ = (GThemedIcon*) g_themed_icon_new (FILES_ICON_RECENT);
		_tmp21_ = _tmp20_;
		_tmp22_ = sidebar_bookmark_list_box_add_bookmark (self, _ (FILES_PROTOCOL_NAME_RECENT), FILES_RECENT_URI, (GIcon*) _tmp21_, TRUE, TRUE);
		_g_object_unref0 (_data63_->row);
		_data63_->row = _tmp22_;
		_g_object_unref0 (_tmp21_);
		_tmp23_ = _data63_->row;
		_tmp24_ = g_strdup ("<Alt>R");
		_tmp25_ = g_new0 (gchar*, 1 + 1);
		_tmp25_[0] = _tmp24_;
		_tmp26_ = _tmp25_;
		_tmp26__length1 = 1;
		_tmp27_ = granite_markup_accel_tooltip (_tmp26_, (gint) 1, _ ("View the list of recently used files"));
		_tmp28_ = _tmp27_;
		gtk_widget_set_tooltip_markup ((GtkWidget*) _tmp23_, _tmp28_);
		_g_free0 (_tmp28_);
		_tmp26_ = (_vala_array_free (_tmp26_, _tmp26__length1, (GDestroyNotify) g_free), NULL);
		_tmp29_ = _data63_->row;
		sidebar_sidebar_item_interface_set_can_insert_before ((SidebarSidebarItemInterface*) _tmp29_, FALSE);
		_tmp30_ = _data63_->row;
		sidebar_sidebar_item_interface_set_can_insert_after ((SidebarSidebarItemInterface*) _tmp30_, TRUE);
	}
	_tmp31_ = self->priv->bookmark_list;
	_tmp32_ = files_bookmark_list_get_list (_tmp31_);
	_tmp33_ = _tmp32_;
	{
		GList* bm_collection = NULL;
		GList* bm_it = NULL;
		bm_collection = _tmp33_;
		for (bm_it = bm_collection; bm_it != NULL; bm_it = bm_it->next) {
			FilesBookmark* bm = NULL;
			bm = (FilesBookmark*) bm_it->data;
			{
				Block64Data* _data64_;
				FilesBookmark* _tmp34_;
				const gchar* _tmp35_;
				const gchar* _tmp36_;
				FilesBookmark* _tmp37_;
				const gchar* _tmp38_;
				const gchar* _tmp39_;
				FilesBookmark* _tmp40_;
				GIcon* _tmp41_;
				GIcon* _tmp42_;
				SidebarBookmarkRow* _tmp43_;
				SidebarBookmarkRow* _tmp44_;
				FilesBookmark* _tmp45_;
				const gchar* _tmp46_;
				const gchar* _tmp47_;
				gchar* _tmp48_;
				gchar* _tmp49_;
				SidebarBookmarkRow* _tmp50_;
				_data64_ = g_slice_new0 (Block64Data);
				_data64_->_ref_count_ = 1;
				_data64_->_data63_ = block63_data_ref (_data63_);
				_data64_->bm = bm;
				_tmp34_ = _data64_->bm;
				_tmp35_ = files_bookmark_get_custom_name (_tmp34_);
				_tmp36_ = _tmp35_;
				_tmp37_ = _data64_->bm;
				_tmp38_ = files_bookmark_get_uri (_tmp37_);
				_tmp39_ = _tmp38_;
				_tmp40_ = _data64_->bm;
				_tmp41_ = files_bookmark_get_icon (_tmp40_);
				_tmp42_ = _tmp41_;
				_tmp43_ = sidebar_bookmark_list_box_add_bookmark (self, _tmp36_, _tmp39_, _tmp42_, FALSE, FALSE);
				_g_object_unref0 (_data63_->row);
				_data63_->row = _tmp43_;
				_g_object_unref0 (_tmp42_);
				_tmp44_ = _data63_->row;
				_tmp45_ = _data64_->bm;
				_tmp46_ = files_bookmark_get_uri (_tmp45_);
				_tmp47_ = _tmp46_;
				_tmp48_ = files_file_utils_sanitize_path (_tmp47_, NULL, FALSE);
				_tmp49_ = _tmp48_;
				gtk_widget_set_tooltip_text ((GtkWidget*) _tmp44_, _tmp49_);
				_g_free0 (_tmp49_);
				_tmp50_ = _data63_->row;
				g_signal_connect_data ((GObject*) _tmp50_, "notify::custom-name", (GCallback) _____lambda170__g_object_notify, block64_data_ref (_data64_), (GClosureNotify) block64_data_unref, 0);
				block64_data_unref (_data64_);
				_data64_ = NULL;
			}
		}
	}
	if (!files_is_admin ()) {
		FilesTrashMonitor* _tmp51_;
		GIcon* _tmp52_;
		GIcon* _tmp53_;
		SidebarBookmarkRow* _tmp54_;
		SidebarBookmarkRow* _tmp55_;
		gchar* _tmp56_;
		gchar** _tmp57_;
		gchar** _tmp58_;
		gint _tmp58__length1;
		gchar* _tmp59_;
		gchar* _tmp60_;
		SidebarBookmarkRow* _tmp61_;
		SidebarBookmarkRow* _tmp62_;
		FilesTrashMonitor* _tmp63_;
		_tmp51_ = self->priv->trash_monitor;
		_tmp52_ = files_trash_monitor_get_icon (_tmp51_);
		_tmp53_ = _tmp52_;
		_tmp54_ = sidebar_bookmark_list_box_add_bookmark (self, _ ("Trash"), _ (FILES_TRASH_URI), _tmp53_, TRUE, TRUE);
		_g_object_unref0 (_data63_->row);
		_data63_->row = _tmp54_;
		_g_object_unref0 (_tmp53_);
		_tmp55_ = _data63_->row;
		_tmp56_ = g_strdup ("<Alt>T");
		_tmp57_ = g_new0 (gchar*, 1 + 1);
		_tmp57_[0] = _tmp56_;
		_tmp58_ = _tmp57_;
		_tmp58__length1 = 1;
		_tmp59_ = granite_markup_accel_tooltip (_tmp58_, (gint) 1, _ ("Open the Trash"));
		_tmp60_ = _tmp59_;
		gtk_widget_set_tooltip_markup ((GtkWidget*) _tmp55_, _tmp60_);
		_g_free0 (_tmp60_);
		_tmp58_ = (_vala_array_free (_tmp58_, _tmp58__length1, (GDestroyNotify) g_free), NULL);
		_tmp61_ = _data63_->row;
		sidebar_sidebar_item_interface_set_can_insert_before ((SidebarSidebarItemInterface*) _tmp61_, TRUE);
		_tmp62_ = _data63_->row;
		sidebar_sidebar_item_interface_set_can_insert_after ((SidebarSidebarItemInterface*) _tmp62_, FALSE);
		_tmp63_ = self->priv->trash_monitor;
		g_signal_connect_data ((GObject*) _tmp63_, "notify::is-empty", (GCallback) ____lambda171__g_object_notify, block63_data_ref (_data63_), (GClosureNotify) block63_data_unref, 0);
	}
	_g_free0 (home_uri);
	block63_data_unref (_data63_);
	_data63_ = NULL;
}

static void
sidebar_bookmark_list_box_real_rename_bookmark_by_uri (SidebarBookmarkListBox* self,
                                                       const gchar* uri,
                                                       const gchar* new_name)
{
	FilesBookmarkList* _tmp0_;
	g_return_if_fail (uri != NULL);
	g_return_if_fail (new_name != NULL);
	_tmp0_ = self->priv->bookmark_list;
	files_bookmark_list_rename_item_with_uri (_tmp0_, uri, new_name);
}

void
sidebar_bookmark_list_box_rename_bookmark_by_uri (SidebarBookmarkListBox* self,
                                                  const gchar* uri,
                                                  const gchar* new_name)
{
	SidebarBookmarkListBoxClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = SIDEBAR_BOOKMARK_LIST_BOX_GET_CLASS (self);
	if (_klass_->rename_bookmark_by_uri) {
		_klass_->rename_bookmark_by_uri (self, uri, new_name);
	}
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static gboolean
sidebar_bookmark_list_box_real_add_favorite (SidebarSidebarListInterface* base,
                                             const gchar* uri,
                                             const gchar* custom_name,
                                             gint pos)
{
	SidebarBookmarkListBox * self;
	gint pinned = 0;
	gint index = 0;
	GtkListBoxRow* row = NULL;
	GtkListBox* _tmp0_;
	GtkListBox* _tmp1_;
	GtkListBoxRow* _tmp2_;
	GtkListBoxRow* _tmp3_;
	FilesBookmark* bm = NULL;
	FilesBookmarkList* _tmp15_;
	FilesBookmark* _tmp16_;
	FilesBookmark* _tmp17_;
	gboolean result;
	self = (SidebarBookmarkListBox*) base;
	g_return_val_if_fail (uri != NULL, FALSE);
	g_return_val_if_fail (custom_name != NULL, FALSE);
	pinned = 0;
	index = 0;
	_tmp0_ = sidebar_sidebar_list_interface_get_list_box ((SidebarSidebarListInterface*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = gtk_list_box_get_row_at_index (_tmp1_, index);
	_tmp3_ = _g_object_ref0 (_tmp2_);
	row = _tmp3_;
	while (TRUE) {
		gboolean _tmp4_ = FALSE;
		GtkListBoxRow* _tmp5_;
		gint _tmp9_;
		GtkListBox* _tmp10_;
		GtkListBox* _tmp11_;
		gint _tmp12_;
		GtkListBoxRow* _tmp13_;
		GtkListBoxRow* _tmp14_;
		_tmp5_ = row;
		if (_tmp5_ != NULL) {
			GtkListBoxRow* _tmp6_;
			gboolean _tmp7_;
			gboolean _tmp8_;
			_tmp6_ = row;
			_tmp7_ = sidebar_sidebar_item_interface_get_pinned ((SidebarSidebarItemInterface*) G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, SIDEBAR_TYPE_BOOKMARK_ROW, SidebarBookmarkRow));
			_tmp8_ = _tmp7_;
			_tmp4_ = _tmp8_;
		} else {
			_tmp4_ = FALSE;
		}
		if (!_tmp4_) {
			break;
		}
		_tmp9_ = pinned;
		pinned = _tmp9_ + 1;
		_tmp10_ = sidebar_sidebar_list_interface_get_list_box ((SidebarSidebarListInterface*) self);
		_tmp11_ = _tmp10_;
		index = index + 1;
		_tmp12_ = index;
		_tmp13_ = gtk_list_box_get_row_at_index (_tmp11_, _tmp12_);
		_tmp14_ = _g_object_ref0 (_tmp13_);
		_g_object_unref0 (row);
		row = _tmp14_;
	}
	if (pos < pinned) {
		pos = pinned;
	}
	_tmp15_ = self->priv->bookmark_list;
	_tmp16_ = files_bookmark_list_insert_uri (_tmp15_, uri, (guint) (pos - pinned), custom_name);
	bm = _tmp16_;
	_tmp17_ = bm;
	if (_tmp17_ != NULL) {
		FilesBookmark* _tmp18_;
		const gchar* _tmp19_;
		const gchar* _tmp20_;
		FilesBookmark* _tmp21_;
		const gchar* _tmp22_;
		const gchar* _tmp23_;
		FilesBookmark* _tmp24_;
		GIcon* _tmp25_;
		GIcon* _tmp26_;
		SidebarBookmarkRow* _tmp27_;
		SidebarBookmarkRow* _tmp28_;
		_tmp18_ = bm;
		_tmp19_ = files_bookmark_get_custom_name (_tmp18_);
		_tmp20_ = _tmp19_;
		_tmp21_ = bm;
		_tmp22_ = files_bookmark_get_uri (_tmp21_);
		_tmp23_ = _tmp22_;
		_tmp24_ = bm;
		_tmp25_ = files_bookmark_get_icon (_tmp24_);
		_tmp26_ = _tmp25_;
		_tmp27_ = sidebar_bookmark_list_box_insert_bookmark (self, _tmp20_, _tmp23_, _tmp26_, pos, FALSE, FALSE);
		_tmp28_ = _tmp27_;
		_g_object_unref0 (_tmp28_);
		_g_object_unref0 (_tmp26_);
		result = TRUE;
		_files_bookmark_unref0 (bm);
		_g_object_unref0 (row);
		return result;
	} else {
		result = FALSE;
		_files_bookmark_unref0 (bm);
		_g_object_unref0 (row);
		return result;
	}
}

static gboolean
sidebar_bookmark_list_box_real_remove_item_by_id (SidebarSidebarListInterface* base,
                                                  guint32 id)
{
	SidebarBookmarkListBox * self;
	gboolean removed = FALSE;
	gint index = 0;
	GtkListBoxRow* row = NULL;
	GtkListBox* _tmp0_;
	GtkListBox* _tmp1_;
	GtkListBoxRow* _tmp2_;
	GtkListBoxRow* _tmp3_;
	gboolean result;
	self = (SidebarBookmarkListBox*) base;
	removed = FALSE;
	index = 0;
	_tmp0_ = sidebar_sidebar_list_interface_get_list_box ((SidebarSidebarListInterface*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = gtk_list_box_get_row_at_index (_tmp1_, index);
	_tmp3_ = _g_object_ref0 (_tmp2_);
	row = _tmp3_;
	while (TRUE) {
		GtkListBoxRow* _tmp4_;
		GtkListBoxRow* _tmp5_;
		GtkListBox* _tmp21_;
		GtkListBox* _tmp22_;
		gint _tmp23_;
		GtkListBoxRow* _tmp24_;
		GtkListBoxRow* _tmp25_;
		_tmp4_ = row;
		if (!(_tmp4_ != NULL)) {
			break;
		}
		_tmp5_ = row;
		if (SIDEBAR_IS_BOOKMARK_ROW (_tmp5_)) {
			SidebarBookmarkRow* bm = NULL;
			GtkListBoxRow* _tmp6_;
			gboolean _tmp7_ = FALSE;
			SidebarBookmarkRow* _tmp8_;
			gboolean _tmp9_;
			gboolean _tmp10_;
			_tmp6_ = row;
			bm = G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, SIDEBAR_TYPE_BOOKMARK_ROW, SidebarBookmarkRow);
			_tmp8_ = bm;
			_tmp9_ = sidebar_sidebar_item_interface_get_permanent ((SidebarSidebarItemInterface*) _tmp8_);
			_tmp10_ = _tmp9_;
			if (!_tmp10_) {
				SidebarBookmarkRow* _tmp11_;
				guint32 _tmp12_;
				guint32 _tmp13_;
				_tmp11_ = bm;
				_tmp12_ = sidebar_sidebar_item_interface_get_id ((SidebarSidebarItemInterface*) _tmp11_);
				_tmp13_ = _tmp12_;
				_tmp7_ = _tmp13_ == id;
			} else {
				_tmp7_ = FALSE;
			}
			if (_tmp7_) {
				GtkListBox* _tmp14_;
				GtkListBox* _tmp15_;
				GtkListBoxRow* _tmp16_;
				FilesBookmarkList* _tmp17_;
				SidebarBookmarkRow* _tmp18_;
				const gchar* _tmp19_;
				const gchar* _tmp20_;
				_tmp14_ = sidebar_sidebar_list_interface_get_list_box ((SidebarSidebarListInterface*) self);
				_tmp15_ = _tmp14_;
				_tmp16_ = row;
				gtk_container_remove ((GtkContainer*) _tmp15_, (GtkWidget*) _tmp16_);
				_tmp17_ = self->priv->bookmark_list;
				_tmp18_ = bm;
				_tmp19_ = sidebar_sidebar_item_interface_get_uri ((SidebarSidebarItemInterface*) _tmp18_);
				_tmp20_ = _tmp19_;
				files_bookmark_list_delete_items_with_uri (_tmp17_, _tmp20_);
				removed = TRUE;
				break;
			}
		}
		_tmp21_ = sidebar_sidebar_list_interface_get_list_box ((SidebarSidebarListInterface*) self);
		_tmp22_ = _tmp21_;
		index = index + 1;
		_tmp23_ = index;
		_tmp24_ = gtk_list_box_get_row_at_index (_tmp22_, _tmp23_);
		_tmp25_ = _g_object_ref0 (_tmp24_);
		_g_object_unref0 (row);
		row = _tmp25_;
	}
	result = removed;
	_g_object_unref0 (row);
	return result;
}

static SidebarSidebarItemInterface*
sidebar_bookmark_list_box_real_get_item_at_index (SidebarSidebarListInterface* base,
                                                  gint index)
{
	SidebarBookmarkListBox * self;
	GtkListBox* _tmp0_;
	GtkListBox* _tmp1_;
	GtkListBoxRow* _tmp2_;
	SidebarSidebarItemInterface* _tmp3_;
	SidebarSidebarItemInterface* result;
	self = (SidebarBookmarkListBox*) base;
	_tmp0_ = sidebar_sidebar_list_interface_get_list_box ((SidebarSidebarListInterface*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = gtk_list_box_get_row_at_index (_tmp1_, index);
	_tmp3_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, SIDEBAR_TYPE_SIDEBAR_ITEM_INTERFACE, SidebarSidebarItemInterface));
	result = _tmp3_;
	return result;
}

static gboolean
sidebar_bookmark_list_box_real_move_item_after (SidebarSidebarListInterface* base,
                                                SidebarSidebarItemInterface* item,
                                                gint target_index)
{
	SidebarBookmarkListBox * self;
	SidebarSidebarListInterface* _tmp0_;
	SidebarSidebarListInterface* _tmp1_;
	gint old_index = 0;
	GtkListBox* _tmp2_;
	GtkListBox* _tmp3_;
	FilesBookmarkList* _tmp10_;
	const gchar* _tmp11_;
	const gchar* _tmp12_;
	gboolean result;
	self = (SidebarBookmarkListBox*) base;
	g_return_val_if_fail (item != NULL, FALSE);
	_tmp0_ = sidebar_sidebar_item_interface_get_list (item);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != G_TYPE_CHECK_INSTANCE_CAST (self, SIDEBAR_TYPE_SIDEBAR_LIST_INTERFACE, SidebarSidebarListInterface)) {
		result = FALSE;
		return result;
	}
	old_index = sidebar_sidebar_item_interface_get_index (item);
	if (old_index == target_index) {
		result = FALSE;
		return result;
	}
	_tmp2_ = sidebar_sidebar_list_interface_get_list_box ((SidebarSidebarListInterface*) self);
	_tmp3_ = _tmp2_;
	gtk_container_remove ((GtkContainer*) _tmp3_, (GtkWidget*) G_TYPE_CHECK_INSTANCE_CAST (item, gtk_list_box_row_get_type (), GtkListBoxRow));
	if (old_index > target_index) {
		GtkListBox* _tmp4_;
		GtkListBox* _tmp5_;
		SidebarSidebarItemInterface* _tmp6_;
		gint _tmp7_;
		_tmp4_ = sidebar_sidebar_list_interface_get_list_box ((SidebarSidebarListInterface*) self);
		_tmp5_ = _tmp4_;
		_tmp6_ = item;
		target_index = target_index + 1;
		_tmp7_ = target_index;
		gtk_list_box_insert (_tmp5_, (GtkWidget*) G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, gtk_list_box_row_get_type (), GtkListBoxRow), _tmp7_);
	} else {
		GtkListBox* _tmp8_;
		GtkListBox* _tmp9_;
		_tmp8_ = sidebar_sidebar_list_interface_get_list_box ((SidebarSidebarListInterface*) self);
		_tmp9_ = _tmp8_;
		gtk_list_box_insert (_tmp9_, (GtkWidget*) G_TYPE_CHECK_INSTANCE_CAST (item, gtk_list_box_row_get_type (), GtkListBoxRow), target_index);
	}
	_tmp10_ = self->priv->bookmark_list;
	_tmp11_ = sidebar_sidebar_item_interface_get_uri (item);
	_tmp12_ = _tmp11_;
	files_bookmark_list_move_item_uri (_tmp10_, _tmp12_, target_index - old_index);
	result = TRUE;
	return result;
}

static gboolean
sidebar_bookmark_list_box_real_is_drop_target (SidebarBookmarkListBox* self)
{
	gboolean result;
	result = TRUE;
	return result;
}

gboolean
sidebar_bookmark_list_box_is_drop_target (SidebarBookmarkListBox* self)
{
	SidebarBookmarkListBoxClass* _klass_;
	g_return_val_if_fail (self != NULL, FALSE);
	_klass_ = SIDEBAR_BOOKMARK_LIST_BOX_GET_CLASS (self);
	if (_klass_->is_drop_target) {
		return _klass_->is_drop_target (self);
	}
	return FALSE;
}

static FilesSidebarInterface*
sidebar_bookmark_list_box_real_get_sidebar (SidebarSidebarListInterface* base)
{
	FilesSidebarInterface* result;
	SidebarBookmarkListBox* self;
	FilesSidebarInterface* _tmp0_;
	self = (SidebarBookmarkListBox*) base;
	_tmp0_ = self->priv->_sidebar;
	result = _tmp0_;
	return result;
}

static void
sidebar_bookmark_list_box_real_set_sidebar (SidebarSidebarListInterface* base,
                                            FilesSidebarInterface* value)
{
	SidebarBookmarkListBox* self;
	FilesSidebarInterface* old_value;
	self = (SidebarBookmarkListBox*) base;
	old_value = sidebar_bookmark_list_box_real_get_sidebar (base);
	if (old_value != value) {
		FilesSidebarInterface* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_sidebar);
		self->priv->_sidebar = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, sidebar_bookmark_list_box_properties[SIDEBAR_BOOKMARK_LIST_BOX_SIDEBAR_PROPERTY]);
	}
}

static GtkListBox*
sidebar_bookmark_list_box_real_get_list_box (SidebarSidebarListInterface* base)
{
	GtkListBox* result;
	SidebarBookmarkListBox* self;
	GtkListBox* _tmp0_;
	self = (SidebarBookmarkListBox*) base;
	_tmp0_ = self->priv->_list_box;
	result = _tmp0_;
	return result;
}

static void
sidebar_bookmark_list_box_real_set_list_box (SidebarSidebarListInterface* base,
                                             GtkListBox* value)
{
	SidebarBookmarkListBox* self;
	GtkListBox* old_value;
	self = (SidebarBookmarkListBox*) base;
	old_value = sidebar_bookmark_list_box_real_get_list_box (base);
	if (old_value != value) {
		GtkListBox* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_list_box);
		self->priv->_list_box = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, sidebar_bookmark_list_box_properties[SIDEBAR_BOOKMARK_LIST_BOX_LIST_BOX_PROPERTY]);
	}
}

static void
_sidebar_bookmark_list_box___lambda172_ (SidebarBookmarkListBox* self)
{
	sidebar_sidebar_list_interface_refresh ((SidebarSidebarListInterface*) self);
}

static void
__sidebar_bookmark_list_box___lambda172__files_bookmark_list_loaded (FilesBookmarkList* _sender,
                                                                     gpointer self)
{
	_sidebar_bookmark_list_box___lambda172_ ((SidebarBookmarkListBox*) self);
}

static void
_sidebar_bookmark_list_box___lambda173_ (SidebarBookmarkListBox* self,
                                         GtkListBoxRow* row)
{
	g_return_if_fail (row != NULL);
	if (SIDEBAR_IS_BOOKMARK_ROW (row)) {
		sidebar_sidebar_item_interface_activated ((SidebarSidebarItemInterface*) G_TYPE_CHECK_INSTANCE_CAST (row, SIDEBAR_TYPE_BOOKMARK_ROW, SidebarBookmarkRow), FILES_OPEN_FLAG_DEFAULT);
	}
}

static void
__sidebar_bookmark_list_box___lambda173__gtk_list_box_row_activated (GtkListBox* _sender,
                                                                     GtkListBoxRow* row,
                                                                     gpointer self)
{
	_sidebar_bookmark_list_box___lambda173_ ((SidebarBookmarkListBox*) self, row);
}

static void
_sidebar_bookmark_list_box___lambda174_ (SidebarBookmarkListBox* self,
                                         GtkListBoxRow* row)
{
	if (SIDEBAR_IS_BOOKMARK_ROW (row)) {
		sidebar_sidebar_list_interface_select_item ((SidebarSidebarListInterface*) self, row);
	}
}

static void
__sidebar_bookmark_list_box___lambda174__gtk_list_box_row_selected (GtkListBox* _sender,
                                                                    GtkListBoxRow* row,
                                                                    gpointer self)
{
	_sidebar_bookmark_list_box___lambda174_ ((SidebarBookmarkListBox*) self, row);
}

static GObject *
sidebar_bookmark_list_box_constructor (GType type,
                                       guint n_construct_properties,
                                       GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	SidebarBookmarkListBox * self;
	GtkListBox* _tmp0_ = NULL;
	GtkListBox* _tmp1_;
	GtkListBox* _tmp2_;
	GtkListBox* _tmp3_;
	FilesTrashMonitor* _tmp4_;
	FilesBookmarkList* _tmp5_;
	FilesBookmarkList* _tmp6_;
	GtkListBox* _tmp7_;
	GtkListBox* _tmp8_;
	GtkListBox* _tmp9_;
	GtkListBox* _tmp10_;
	parent_class = G_OBJECT_CLASS (sidebar_bookmark_list_box_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SIDEBAR_TYPE_BOOKMARK_LIST_BOX, SidebarBookmarkListBox);
	_tmp0_ = (GtkListBox*) gtk_list_box_new ();
	gtk_widget_set_hexpand ((GtkWidget*) _tmp0_, TRUE);
	gtk_list_box_set_selection_mode (_tmp0_, GTK_SELECTION_SINGLE);
	g_object_ref_sink (_tmp0_);
	_tmp1_ = _tmp0_;
	sidebar_sidebar_list_interface_set_list_box ((SidebarSidebarListInterface*) self, _tmp1_);
	_g_object_unref0 (_tmp1_);
	_tmp2_ = sidebar_sidebar_list_interface_get_list_box ((SidebarSidebarListInterface*) self);
	_tmp3_ = _tmp2_;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp3_);
	_tmp4_ = files_trash_monitor_get_default ();
	self->priv->trash_monitor = _tmp4_;
	_tmp5_ = files_bookmark_list_get_instance ();
	_g_object_unref0 (self->priv->bookmark_list);
	self->priv->bookmark_list = _tmp5_;
	_tmp6_ = self->priv->bookmark_list;
	g_signal_connect_object (_tmp6_, "loaded", (GCallback) __sidebar_bookmark_list_box___lambda172__files_bookmark_list_loaded, self, 0);
	_tmp7_ = sidebar_sidebar_list_interface_get_list_box ((SidebarSidebarListInterface*) self);
	_tmp8_ = _tmp7_;
	g_signal_connect_object (_tmp8_, "row-activated", (GCallback) __sidebar_bookmark_list_box___lambda173__gtk_list_box_row_activated, self, 0);
	_tmp9_ = sidebar_sidebar_list_interface_get_list_box ((SidebarSidebarListInterface*) self);
	_tmp10_ = _tmp9_;
	g_signal_connect_object (_tmp10_, "row-selected", (GCallback) __sidebar_bookmark_list_box___lambda174__gtk_list_box_row_selected, self, 0);
	return obj;
}

static void
sidebar_bookmark_list_box_class_init (SidebarBookmarkListBoxClass * klass,
                                      gpointer klass_data)
{
	sidebar_bookmark_list_box_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &SidebarBookmarkListBox_private_offset);
	((SidebarBookmarkListBoxClass *) klass)->rename_bookmark_by_uri = (void (*) (SidebarBookmarkListBox*, const gchar*, const gchar*)) sidebar_bookmark_list_box_real_rename_bookmark_by_uri;
	((SidebarBookmarkListBoxClass *) klass)->is_drop_target = (gboolean (*) (SidebarBookmarkListBox*)) sidebar_bookmark_list_box_real_is_drop_target;
	G_OBJECT_CLASS (klass)->get_property = _vala_sidebar_bookmark_list_box_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_sidebar_bookmark_list_box_set_property;
	G_OBJECT_CLASS (klass)->constructor = sidebar_bookmark_list_box_constructor;
	G_OBJECT_CLASS (klass)->finalize = sidebar_bookmark_list_box_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), SIDEBAR_BOOKMARK_LIST_BOX_SIDEBAR_PROPERTY, sidebar_bookmark_list_box_properties[SIDEBAR_BOOKMARK_LIST_BOX_SIDEBAR_PROPERTY] = g_param_spec_object ("sidebar", "sidebar", "sidebar", FILES_TYPE_SIDEBAR_INTERFACE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SIDEBAR_BOOKMARK_LIST_BOX_LIST_BOX_PROPERTY, sidebar_bookmark_list_box_properties[SIDEBAR_BOOKMARK_LIST_BOX_LIST_BOX_PROPERTY] = g_param_spec_object ("list-box", "list-box", "list-box", gtk_list_box_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
}

static void
sidebar_bookmark_list_box_sidebar_sidebar_list_interface_interface_init (SidebarSidebarListInterfaceIface * iface,
                                                                         gpointer iface_data)
{
	sidebar_bookmark_list_box_sidebar_sidebar_list_interface_parent_iface = g_type_interface_peek_parent (iface);
	iface->add_plugin_item = (guint32 (*) (SidebarSidebarListInterface*, FilesSidebarPluginItem*)) sidebar_bookmark_list_box_real_add_plugin_item;
	iface->select_item = (void (*) (SidebarSidebarListInterface*, GtkListBoxRow*)) sidebar_bookmark_list_box_real_select_item;
	iface->unselect_all_items = (void (*) (SidebarSidebarListInterface*)) sidebar_bookmark_list_box_real_unselect_all_items;
	iface->refresh = (void (*) (SidebarSidebarListInterface*)) sidebar_bookmark_list_box_real_refresh;
	iface->rename_bookmark_by_uri = (void (*) (SidebarSidebarListInterface*, const gchar*, const gchar*)) sidebar_bookmark_list_box_rename_bookmark_by_uri;
	iface->add_favorite = (gboolean (*) (SidebarSidebarListInterface*, const gchar*, const gchar*, gint)) sidebar_bookmark_list_box_real_add_favorite;
	iface->remove_item_by_id = (gboolean (*) (SidebarSidebarListInterface*, guint32)) sidebar_bookmark_list_box_real_remove_item_by_id;
	iface->get_item_at_index = (SidebarSidebarItemInterface* (*) (SidebarSidebarListInterface*, gint)) sidebar_bookmark_list_box_real_get_item_at_index;
	iface->move_item_after = (gboolean (*) (SidebarSidebarListInterface*, SidebarSidebarItemInterface*, gint)) sidebar_bookmark_list_box_real_move_item_after;
	iface->is_drop_target = (gboolean (*) (SidebarSidebarListInterface*)) sidebar_bookmark_list_box_is_drop_target;
	iface->get_sidebar = sidebar_bookmark_list_box_real_get_sidebar;
	iface->set_sidebar = sidebar_bookmark_list_box_real_set_sidebar;
	iface->get_list_box = sidebar_bookmark_list_box_real_get_list_box;
	iface->set_list_box = sidebar_bookmark_list_box_real_set_list_box;
}

static void
sidebar_bookmark_list_box_instance_init (SidebarBookmarkListBox * self,
                                         gpointer klass)
{
	self->priv = sidebar_bookmark_list_box_get_instance_private (self);
}

static void
sidebar_bookmark_list_box_finalize (GObject * obj)
{
	SidebarBookmarkListBox * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SIDEBAR_TYPE_BOOKMARK_LIST_BOX, SidebarBookmarkListBox);
	_g_object_unref0 (self->priv->_sidebar);
	_g_object_unref0 (self->priv->_list_box);
	_g_object_unref0 (self->priv->bookmark_list);
	G_OBJECT_CLASS (sidebar_bookmark_list_box_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
sidebar_bookmark_list_box_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SidebarBookmarkListBoxClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) sidebar_bookmark_list_box_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SidebarBookmarkListBox), 0, (GInstanceInitFunc) sidebar_bookmark_list_box_instance_init, NULL };
	static const GInterfaceInfo sidebar_sidebar_list_interface_info = { (GInterfaceInitFunc) sidebar_bookmark_list_box_sidebar_sidebar_list_interface_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType sidebar_bookmark_list_box_type_id;
	sidebar_bookmark_list_box_type_id = g_type_register_static (gtk_box_get_type (), "SidebarBookmarkListBox", &g_define_type_info, 0);
	g_type_add_interface_static (sidebar_bookmark_list_box_type_id, SIDEBAR_TYPE_SIDEBAR_LIST_INTERFACE, &sidebar_sidebar_list_interface_info);
	SidebarBookmarkListBox_private_offset = g_type_add_instance_private (sidebar_bookmark_list_box_type_id, sizeof (SidebarBookmarkListBoxPrivate));
	return sidebar_bookmark_list_box_type_id;
}

GType
sidebar_bookmark_list_box_get_type (void)
{
	static volatile gsize sidebar_bookmark_list_box_type_id__once = 0;
	if (g_once_init_enter (&sidebar_bookmark_list_box_type_id__once)) {
		GType sidebar_bookmark_list_box_type_id;
		sidebar_bookmark_list_box_type_id = sidebar_bookmark_list_box_get_type_once ();
		g_once_init_leave (&sidebar_bookmark_list_box_type_id__once, sidebar_bookmark_list_box_type_id);
	}
	return sidebar_bookmark_list_box_type_id__once;
}

static void
_vala_sidebar_bookmark_list_box_get_property (GObject * object,
                                              guint property_id,
                                              GValue * value,
                                              GParamSpec * pspec)
{
	SidebarBookmarkListBox * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SIDEBAR_TYPE_BOOKMARK_LIST_BOX, SidebarBookmarkListBox);
	switch (property_id) {
		case SIDEBAR_BOOKMARK_LIST_BOX_SIDEBAR_PROPERTY:
		g_value_set_object (value, sidebar_sidebar_list_interface_get_sidebar ((SidebarSidebarListInterface*) self));
		break;
		case SIDEBAR_BOOKMARK_LIST_BOX_LIST_BOX_PROPERTY:
		g_value_set_object (value, sidebar_sidebar_list_interface_get_list_box ((SidebarSidebarListInterface*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_sidebar_bookmark_list_box_set_property (GObject * object,
                                              guint property_id,
                                              const GValue * value,
                                              GParamSpec * pspec)
{
	SidebarBookmarkListBox * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SIDEBAR_TYPE_BOOKMARK_LIST_BOX, SidebarBookmarkListBox);
	switch (property_id) {
		case SIDEBAR_BOOKMARK_LIST_BOX_SIDEBAR_PROPERTY:
		sidebar_sidebar_list_interface_set_sidebar ((SidebarSidebarListInterface*) self, g_value_get_object (value));
		break;
		case SIDEBAR_BOOKMARK_LIST_BOX_LIST_BOX_PROPERTY:
		sidebar_sidebar_list_interface_set_list_box ((SidebarSidebarListInterface*) self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

