/* AbstractSlot.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from AbstractSlot.vala, do not modify */

/*
 * SPDX-FileCopyrightText: 2015-2025 elementary, Inc. (https://elementary.io)
 * SPDX-License-Identifier: GPL-3.0-or-later
 *
 * Authors : Lucas Baudin <xapantu@gmail.com>
 *           Jeremy Wootten <jeremywootten@gmail.com>
 */

#include "pantheon-files-core.h"
#include <glib.h>
#include <gtk/gtk.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <glib-object.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	FILES_ABSTRACT_SLOT_0_PROPERTY,
	FILES_ABSTRACT_SLOT_DIRECTORY_PROPERTY,
	FILES_ABSTRACT_SLOT_FILE_PROPERTY,
	FILES_ABSTRACT_SLOT_LOCATION_PROPERTY,
	FILES_ABSTRACT_SLOT_URI_PROPERTY,
	FILES_ABSTRACT_SLOT_LOCKED_FOCUS_PROPERTY,
	FILES_ABSTRACT_SLOT_IS_FROZEN_PROPERTY,
	FILES_ABSTRACT_SLOT_OVERLAY_PROPERTY,
	FILES_ABSTRACT_SLOT_SLOT_NUMBER_PROPERTY,
	FILES_ABSTRACT_SLOT_NUM_PROPERTIES
};
static GParamSpec* files_abstract_slot_properties[FILES_ABSTRACT_SLOT_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
enum  {
	FILES_ABSTRACT_SLOT_ACTIVE_SIGNAL,
	FILES_ABSTRACT_SLOT_INACTIVE_SIGNAL,
	FILES_ABSTRACT_SLOT_PATH_CHANGED_SIGNAL,
	FILES_ABSTRACT_SLOT_NEW_CONTAINER_REQUEST_SIGNAL,
	FILES_ABSTRACT_SLOT_SELECTION_CHANGED_SIGNAL,
	FILES_ABSTRACT_SLOT_DIRECTORY_LOADED_SIGNAL,
	FILES_ABSTRACT_SLOT_NUM_SIGNALS
};
static guint files_abstract_slot_signals[FILES_ABSTRACT_SLOT_NUM_SIGNALS] = {0};

struct _FilesAbstractSlotPrivate {
	FilesDirectory* _directory;
	gboolean _is_frozen;
	GtkOverlay* _overlay;
	gint _slot_number;
};

static gint FilesAbstractSlot_private_offset;
static gpointer files_abstract_slot_parent_class = NULL;

static void files_abstract_slot_real_initialize_directory (FilesAbstractSlot* self);
static GList* files_abstract_slot_real_get_selected_files (FilesAbstractSlot* self);
static void files_abstract_slot_real_set_active_state (FilesAbstractSlot* self,
                                                gboolean set_active,
                                                gboolean animate);
static FilesAbstractSlot* files_abstract_slot_real_get_current_slot (FilesAbstractSlot* self);
static void files_abstract_slot_real_reload (FilesAbstractSlot* self,
                                      gboolean non_local_only);
static void files_abstract_slot_real_grab_focus (FilesAbstractSlot* self);
static void files_abstract_slot_real_user_path_change_request (FilesAbstractSlot* self,
                                                        GFile* loc,
                                                        gboolean make_root);
static void files_abstract_slot_real_focus_first_for_empty_selection (FilesAbstractSlot* self,
                                                               gboolean select);
static void files_abstract_slot_real_select_glib_files (FilesAbstractSlot* self,
                                                 GList* locations,
                                                 GFile* focus_location);
static void files_abstract_slot_real_close (FilesAbstractSlot* self);
static GFileInfo* files_abstract_slot_real_lookup_file_info (FilesAbstractSlot* self,
                                                      GFile* loc);
static void files_abstract_slot_real_zoom_out (FilesAbstractSlot* self);
static void files_abstract_slot_real_zoom_in (FilesAbstractSlot* self);
static void files_abstract_slot_real_zoom_normal (FilesAbstractSlot* self);
static gboolean files_abstract_slot_real_set_all_selected (FilesAbstractSlot* self,
                                                    gboolean all_selected);
static GtkWidget* files_abstract_slot_real_get_content_box (FilesAbstractSlot* self);
static gchar* files_abstract_slot_real_get_root_uri (FilesAbstractSlot* self);
static gchar* files_abstract_slot_real_get_tip_uri (FilesAbstractSlot* self);
static gboolean files_abstract_slot_real_get_realized (FilesAbstractSlot* self);
static void g_cclosure_user_marshal_VOID__BOOLEAN_BOOLEAN (GClosure * closure,
                                                    GValue * return_value,
                                                    guint n_param_values,
                                                    const GValue * param_values,
                                                    gpointer invocation_hint,
                                                    gpointer marshal_data);
static void g_cclosure_user_marshal_VOID__OBJECT_ENUM (GClosure * closure,
                                                GValue * return_value,
                                                guint n_param_values,
                                                const GValue * param_values,
                                                gpointer invocation_hint,
                                                gpointer marshal_data);
static GObject * files_abstract_slot_constructor (GType type,
                                           guint n_construct_properties,
                                           GObjectConstructParam * construct_properties);
static void files_abstract_slot_finalize (GObject * obj);
static GType files_abstract_slot_get_type_once (void);
static void _vala_files_abstract_slot_get_property (GObject * object,
                                             guint property_id,
                                             GValue * value,
                                             GParamSpec * pspec);
static void _vala_files_abstract_slot_set_property (GObject * object,
                                             guint property_id,
                                             const GValue * value,
                                             GParamSpec * pspec);

static inline gpointer
files_abstract_slot_get_instance_private (FilesAbstractSlot* self)
{
	return G_STRUCT_MEMBER_P (self, FilesAbstractSlot_private_offset);
}

void
files_abstract_slot_add_extra_widget (FilesAbstractSlot* self,
                                      GtkWidget* widget)
{
	GtkBox* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	_tmp0_ = self->extra_location_widgets;
	gtk_container_add ((GtkContainer*) _tmp0_, widget);
}

void
files_abstract_slot_add_extra_action_widget (FilesAbstractSlot* self,
                                             GtkWidget* widget)
{
	GtkBox* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	_tmp0_ = self->extra_action_widgets;
	gtk_container_add ((GtkContainer*) _tmp0_, widget);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

void
files_abstract_slot_add_overlay (FilesAbstractSlot* self,
                                 GtkWidget* widget)
{
	GtkWidget* _tmp0_;
	GtkOverlay* _tmp1_ = NULL;
	GtkOverlay* _tmp2_;
	GtkBox* _tmp3_;
	GtkOverlay* _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	_tmp0_ = _g_object_ref0 (widget);
	_tmp1_ = (GtkOverlay*) gtk_overlay_new ();
	gtk_widget_set_hexpand ((GtkWidget*) _tmp1_, TRUE);
	gtk_widget_set_vexpand ((GtkWidget*) _tmp1_, TRUE);
	g_object_set ((GtkContainer*) _tmp1_, "child", _tmp0_, NULL);
	_g_object_unref0 (_tmp0_);
	g_object_ref_sink (_tmp1_);
	_tmp2_ = _tmp1_;
	files_abstract_slot_set_overlay (self, _tmp2_);
	_g_object_unref0 (_tmp2_);
	_tmp3_ = self->content_box;
	_tmp4_ = self->priv->_overlay;
	gtk_container_add ((GtkContainer*) _tmp3_, (GtkWidget*) _tmp4_);
}

static void
files_abstract_slot_real_initialize_directory (FilesAbstractSlot* self)
{
	g_critical ("Type `%s' does not implement abstract method `files_abstract_slot_initialize_directory'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return;
}

void
files_abstract_slot_initialize_directory (FilesAbstractSlot* self)
{
	FilesAbstractSlotClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = FILES_ABSTRACT_SLOT_GET_CLASS (self);
	if (_klass_->initialize_directory) {
		_klass_->initialize_directory (self);
	}
}

static GList*
files_abstract_slot_real_get_selected_files (FilesAbstractSlot* self)
{
	g_critical ("Type `%s' does not implement abstract method `files_abstract_slot_get_selected_files'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return NULL;
}

GList*
files_abstract_slot_get_selected_files (FilesAbstractSlot* self)
{
	FilesAbstractSlotClass* _klass_;
	g_return_val_if_fail (self != NULL, NULL);
	_klass_ = FILES_ABSTRACT_SLOT_GET_CLASS (self);
	if (_klass_->get_selected_files) {
		return _klass_->get_selected_files (self);
	}
	return NULL;
}

static void
files_abstract_slot_real_set_active_state (FilesAbstractSlot* self,
                                           gboolean set_active,
                                           gboolean animate)
{
	g_critical ("Type `%s' does not implement abstract method `files_abstract_slot_set_active_state'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return;
}

void
files_abstract_slot_set_active_state (FilesAbstractSlot* self,
                                      gboolean set_active,
                                      gboolean animate)
{
	FilesAbstractSlotClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = FILES_ABSTRACT_SLOT_GET_CLASS (self);
	if (_klass_->set_active_state) {
		_klass_->set_active_state (self, set_active, animate);
	}
}

static FilesAbstractSlot*
files_abstract_slot_real_get_current_slot (FilesAbstractSlot* self)
{
	g_critical ("Type `%s' does not implement abstract method `files_abstract_slot_get_current_slot'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return NULL;
}

FilesAbstractSlot*
files_abstract_slot_get_current_slot (FilesAbstractSlot* self)
{
	FilesAbstractSlotClass* _klass_;
	g_return_val_if_fail (self != NULL, NULL);
	_klass_ = FILES_ABSTRACT_SLOT_GET_CLASS (self);
	if (_klass_->get_current_slot) {
		return _klass_->get_current_slot (self);
	}
	return NULL;
}

static void
files_abstract_slot_real_reload (FilesAbstractSlot* self,
                                 gboolean non_local_only)
{
	g_critical ("Type `%s' does not implement abstract method `files_abstract_slot_reload'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return;
}

void
files_abstract_slot_reload (FilesAbstractSlot* self,
                            gboolean non_local_only)
{
	FilesAbstractSlotClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = FILES_ABSTRACT_SLOT_GET_CLASS (self);
	if (_klass_->reload) {
		_klass_->reload (self, non_local_only);
	}
}

static void
files_abstract_slot_real_grab_focus (FilesAbstractSlot* self)
{
	g_critical ("Type `%s' does not implement abstract method `files_abstract_slot_grab_focus'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return;
}

void
files_abstract_slot_grab_focus (FilesAbstractSlot* self)
{
	FilesAbstractSlotClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = FILES_ABSTRACT_SLOT_GET_CLASS (self);
	if (_klass_->grab_focus) {
		_klass_->grab_focus (self);
	}
}

static void
files_abstract_slot_real_user_path_change_request (FilesAbstractSlot* self,
                                                   GFile* loc,
                                                   gboolean make_root)
{
	g_critical ("Type `%s' does not implement abstract method `files_abstract_slot_user_path_change_request'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return;
}

void
files_abstract_slot_user_path_change_request (FilesAbstractSlot* self,
                                              GFile* loc,
                                              gboolean make_root)
{
	FilesAbstractSlotClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = FILES_ABSTRACT_SLOT_GET_CLASS (self);
	if (_klass_->user_path_change_request) {
		_klass_->user_path_change_request (self, loc, make_root);
	}
}

static void
files_abstract_slot_real_focus_first_for_empty_selection (FilesAbstractSlot* self,
                                                          gboolean select)
{
	g_critical ("Type `%s' does not implement abstract method `files_abstract_slot_focus_first_for_empty_selection'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return;
}

void
files_abstract_slot_focus_first_for_empty_selection (FilesAbstractSlot* self,
                                                     gboolean select)
{
	FilesAbstractSlotClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = FILES_ABSTRACT_SLOT_GET_CLASS (self);
	if (_klass_->focus_first_for_empty_selection) {
		_klass_->focus_first_for_empty_selection (self, select);
	}
}

static void
files_abstract_slot_real_select_glib_files (FilesAbstractSlot* self,
                                            GList* locations,
                                            GFile* focus_location)
{
	g_critical ("Type `%s' does not implement abstract method `files_abstract_slot_select_glib_files'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return;
}

void
files_abstract_slot_select_glib_files (FilesAbstractSlot* self,
                                       GList* locations,
                                       GFile* focus_location)
{
	FilesAbstractSlotClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = FILES_ABSTRACT_SLOT_GET_CLASS (self);
	if (_klass_->select_glib_files) {
		_klass_->select_glib_files (self, locations, focus_location);
	}
}

static void
files_abstract_slot_real_close (FilesAbstractSlot* self)
{
	g_critical ("Type `%s' does not implement abstract method `files_abstract_slot_close'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return;
}

void
files_abstract_slot_close (FilesAbstractSlot* self)
{
	FilesAbstractSlotClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = FILES_ABSTRACT_SLOT_GET_CLASS (self);
	if (_klass_->close) {
		_klass_->close (self);
	}
}

static GFileInfo*
files_abstract_slot_real_lookup_file_info (FilesAbstractSlot* self,
                                           GFile* loc)
{
	g_critical ("Type `%s' does not implement abstract method `files_abstract_slot_lookup_file_info'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return NULL;
}

GFileInfo*
files_abstract_slot_lookup_file_info (FilesAbstractSlot* self,
                                      GFile* loc)
{
	FilesAbstractSlotClass* _klass_;
	g_return_val_if_fail (self != NULL, NULL);
	_klass_ = FILES_ABSTRACT_SLOT_GET_CLASS (self);
	if (_klass_->lookup_file_info) {
		return _klass_->lookup_file_info (self, loc);
	}
	return NULL;
}

static void
files_abstract_slot_real_zoom_out (FilesAbstractSlot* self)
{
}

void
files_abstract_slot_zoom_out (FilesAbstractSlot* self)
{
	FilesAbstractSlotClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = FILES_ABSTRACT_SLOT_GET_CLASS (self);
	if (_klass_->zoom_out) {
		_klass_->zoom_out (self);
	}
}

static void
files_abstract_slot_real_zoom_in (FilesAbstractSlot* self)
{
}

void
files_abstract_slot_zoom_in (FilesAbstractSlot* self)
{
	FilesAbstractSlotClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = FILES_ABSTRACT_SLOT_GET_CLASS (self);
	if (_klass_->zoom_in) {
		_klass_->zoom_in (self);
	}
}

static void
files_abstract_slot_real_zoom_normal (FilesAbstractSlot* self)
{
}

void
files_abstract_slot_zoom_normal (FilesAbstractSlot* self)
{
	FilesAbstractSlotClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = FILES_ABSTRACT_SLOT_GET_CLASS (self);
	if (_klass_->zoom_normal) {
		_klass_->zoom_normal (self);
	}
}

static gboolean
files_abstract_slot_real_set_all_selected (FilesAbstractSlot* self,
                                           gboolean all_selected)
{
	gboolean result;
	result = FALSE;
	return result;
}

gboolean
files_abstract_slot_set_all_selected (FilesAbstractSlot* self,
                                      gboolean all_selected)
{
	FilesAbstractSlotClass* _klass_;
	g_return_val_if_fail (self != NULL, FALSE);
	_klass_ = FILES_ABSTRACT_SLOT_GET_CLASS (self);
	if (_klass_->set_all_selected) {
		return _klass_->set_all_selected (self, all_selected);
	}
	return FALSE;
}

static GtkWidget*
files_abstract_slot_real_get_content_box (FilesAbstractSlot* self)
{
	GtkBox* _tmp0_;
	GtkWidget* _tmp1_;
	GtkWidget* result;
	_tmp0_ = self->content_box;
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, gtk_widget_get_type ()) ? ((GtkWidget*) _tmp0_) : NULL);
	result = _tmp1_;
	return result;
}

GtkWidget*
files_abstract_slot_get_content_box (FilesAbstractSlot* self)
{
	FilesAbstractSlotClass* _klass_;
	g_return_val_if_fail (self != NULL, NULL);
	_klass_ = FILES_ABSTRACT_SLOT_GET_CLASS (self);
	if (_klass_->get_content_box) {
		return _klass_->get_content_box (self);
	}
	return NULL;
}

static gchar*
files_abstract_slot_real_get_root_uri (FilesAbstractSlot* self)
{
	FilesDirectory* _tmp0_;
	FilesDirectory* _tmp1_;
	FilesFile* _tmp2_;
	FilesFile* _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* result;
	_tmp0_ = files_abstract_slot_get_directory (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = files_directory_get_file (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = files_file_get_uri (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = g_strdup (_tmp5_);
	result = _tmp6_;
	return result;
}

gchar*
files_abstract_slot_get_root_uri (FilesAbstractSlot* self)
{
	FilesAbstractSlotClass* _klass_;
	g_return_val_if_fail (self != NULL, NULL);
	_klass_ = FILES_ABSTRACT_SLOT_GET_CLASS (self);
	if (_klass_->get_root_uri) {
		return _klass_->get_root_uri (self);
	}
	return NULL;
}

static gchar*
files_abstract_slot_real_get_tip_uri (FilesAbstractSlot* self)
{
	gchar* result;
	result = NULL;
	return result;
}

gchar*
files_abstract_slot_get_tip_uri (FilesAbstractSlot* self)
{
	FilesAbstractSlotClass* _klass_;
	g_return_val_if_fail (self != NULL, NULL);
	_klass_ = FILES_ABSTRACT_SLOT_GET_CLASS (self);
	if (_klass_->get_tip_uri) {
		return _klass_->get_tip_uri (self);
	}
	return NULL;
}

static gboolean
files_abstract_slot_real_get_realized (FilesAbstractSlot* self)
{
	GtkBox* _tmp0_;
	gboolean result;
	_tmp0_ = self->content_box;
	result = gtk_widget_get_realized ((GtkWidget*) _tmp0_);
	return result;
}

gboolean
files_abstract_slot_get_realized (FilesAbstractSlot* self)
{
	FilesAbstractSlotClass* _klass_;
	g_return_val_if_fail (self != NULL, FALSE);
	_klass_ = FILES_ABSTRACT_SLOT_GET_CLASS (self);
	if (_klass_->get_realized) {
		return _klass_->get_realized (self);
	}
	return FALSE;
}

FilesAbstractSlot*
files_abstract_slot_construct (GType object_type)
{
	FilesAbstractSlot * self = NULL;
	self = (FilesAbstractSlot*) g_object_new (object_type, NULL);
	return self;
}

FilesDirectory*
files_abstract_slot_get_directory (FilesAbstractSlot* self)
{
	FilesDirectory* result;
	FilesAbstractSlot* current = NULL;
	FilesAbstractSlot* _tmp0_;
	FilesAbstractSlot* _tmp1_;
	FilesAbstractSlot* _tmp2_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = files_abstract_slot_get_current_slot (self);
	_tmp1_ = _g_object_ref0 (_tmp0_);
	current = _tmp1_;
	_tmp2_ = current;
	if (_tmp2_ != NULL) {
		FilesAbstractSlot* _tmp3_;
		FilesDirectory* _tmp4_;
		_tmp3_ = current;
		_tmp4_ = _tmp3_->priv->_directory;
		result = _tmp4_;
		_g_object_unref0 (current);
		return result;
	} else {
		result = NULL;
		_g_object_unref0 (current);
		return result;
	}
}

void
files_abstract_slot_set_directory (FilesAbstractSlot* self,
                                   FilesDirectory* value)
{
	FilesDirectory* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _g_object_ref0 (value);
	_g_object_unref0 (self->priv->_directory);
	self->priv->_directory = _tmp0_;
	g_object_notify_by_pspec ((GObject *) self, files_abstract_slot_properties[FILES_ABSTRACT_SLOT_DIRECTORY_PROPERTY]);
}

FilesFile*
files_abstract_slot_get_file (FilesAbstractSlot* self)
{
	FilesFile* result;
	FilesFile* _tmp0_ = NULL;
	FilesDirectory* _tmp1_;
	FilesDirectory* _tmp2_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = files_abstract_slot_get_directory (self);
	_tmp2_ = _tmp1_;
	if (_tmp2_ != NULL) {
		FilesDirectory* _tmp3_;
		FilesDirectory* _tmp4_;
		FilesFile* _tmp5_;
		FilesFile* _tmp6_;
		_tmp3_ = files_abstract_slot_get_directory (self);
		_tmp4_ = _tmp3_;
		_tmp5_ = files_directory_get_file (_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp0_ = _tmp6_;
	} else {
		_tmp0_ = NULL;
	}
	result = _tmp0_;
	return result;
}

GFile*
files_abstract_slot_get_location (FilesAbstractSlot* self)
{
	GFile* result;
	GFile* _tmp0_ = NULL;
	FilesDirectory* _tmp1_;
	FilesDirectory* _tmp2_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = files_abstract_slot_get_directory (self);
	_tmp2_ = _tmp1_;
	if (_tmp2_ != NULL) {
		FilesDirectory* _tmp3_;
		FilesDirectory* _tmp4_;
		GFile* _tmp5_;
		GFile* _tmp6_;
		_tmp3_ = files_abstract_slot_get_directory (self);
		_tmp4_ = _tmp3_;
		_tmp5_ = files_directory_get_location (_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp0_ = _tmp6_;
	} else {
		_tmp0_ = NULL;
	}
	result = _tmp0_;
	return result;
}

void
files_abstract_slot_set_location (FilesAbstractSlot* self,
                                  GFile* value)
{
	FilesDirectory* _tmp0_;
	FilesDirectory* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = files_directory_from_gfile (value);
	_tmp1_ = _tmp0_;
	files_abstract_slot_set_directory (self, _tmp1_);
	_g_object_unref0 (_tmp1_);
	g_object_notify_by_pspec ((GObject *) self, files_abstract_slot_properties[FILES_ABSTRACT_SLOT_LOCATION_PROPERTY]);
}

const gchar*
files_abstract_slot_get_uri (FilesAbstractSlot* self)
{
	const gchar* result;
	const gchar* _tmp0_ = NULL;
	FilesDirectory* _tmp1_;
	FilesDirectory* _tmp2_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = files_abstract_slot_get_directory (self);
	_tmp2_ = _tmp1_;
	if (_tmp2_ != NULL) {
		FilesDirectory* _tmp3_;
		FilesDirectory* _tmp4_;
		FilesFile* _tmp5_;
		FilesFile* _tmp6_;
		const gchar* _tmp7_;
		const gchar* _tmp8_;
		_tmp3_ = files_abstract_slot_get_directory (self);
		_tmp4_ = _tmp3_;
		_tmp5_ = files_directory_get_file (_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp7_ = files_file_get_uri (_tmp6_);
		_tmp8_ = _tmp7_;
		_tmp0_ = _tmp8_;
	} else {
		_tmp0_ = "";
	}
	result = _tmp0_;
	return result;
}

gboolean
files_abstract_slot_get_locked_focus (FilesAbstractSlot* self)
{
	FilesAbstractSlotClass* _klass_;
	g_return_val_if_fail (self != NULL, FALSE);
	_klass_ = FILES_ABSTRACT_SLOT_GET_CLASS (self);
	if (_klass_->get_locked_focus) {
		return _klass_->get_locked_focus (self);
	}
	return FALSE;
}

static gboolean
files_abstract_slot_real_get_locked_focus (FilesAbstractSlot* base)
{
	gboolean result;
	FilesAbstractSlot* self;
	self = base;
	result = FALSE;
	return result;
}

gboolean
files_abstract_slot_get_is_frozen (FilesAbstractSlot* self)
{
	FilesAbstractSlotClass* _klass_;
	g_return_val_if_fail (self != NULL, FALSE);
	_klass_ = FILES_ABSTRACT_SLOT_GET_CLASS (self);
	if (_klass_->get_is_frozen) {
		return _klass_->get_is_frozen (self);
	}
	return FALSE;
}

static gboolean
files_abstract_slot_real_get_is_frozen (FilesAbstractSlot* base)
{
	gboolean result;
	FilesAbstractSlot* self;
	self = base;
	result = self->priv->_is_frozen;
	return result;
}

void
files_abstract_slot_set_is_frozen (FilesAbstractSlot* self,
                                   gboolean value)
{
	FilesAbstractSlotClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = FILES_ABSTRACT_SLOT_GET_CLASS (self);
	if (_klass_->set_is_frozen) {
		_klass_->set_is_frozen (self, value);
	}
}

static void
files_abstract_slot_real_set_is_frozen (FilesAbstractSlot* base,
                                        gboolean value)
{
	FilesAbstractSlot* self;
	gboolean old_value;
	self = base;
	old_value = files_abstract_slot_real_get_is_frozen (base);
	if (old_value != value) {
		self->priv->_is_frozen = value;
		g_object_notify_by_pspec ((GObject *) self, files_abstract_slot_properties[FILES_ABSTRACT_SLOT_IS_FROZEN_PROPERTY]);
	}
}

GtkOverlay*
files_abstract_slot_get_overlay (FilesAbstractSlot* self)
{
	GtkOverlay* result;
	GtkOverlay* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_overlay;
	result = _tmp0_;
	return result;
}

void
files_abstract_slot_set_overlay (FilesAbstractSlot* self,
                                 GtkOverlay* value)
{
	GtkOverlay* old_value;
	g_return_if_fail (self != NULL);
	old_value = files_abstract_slot_get_overlay (self);
	if (old_value != value) {
		GtkOverlay* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_overlay);
		self->priv->_overlay = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, files_abstract_slot_properties[FILES_ABSTRACT_SLOT_OVERLAY_PROPERTY]);
	}
}

gint
files_abstract_slot_get_slot_number (FilesAbstractSlot* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_slot_number;
	return result;
}

void
files_abstract_slot_set_slot_number (FilesAbstractSlot* self,
                                     gint value)
{
	gint old_value;
	g_return_if_fail (self != NULL);
	old_value = files_abstract_slot_get_slot_number (self);
	if (old_value != value) {
		self->priv->_slot_number = value;
		g_object_notify_by_pspec ((GObject *) self, files_abstract_slot_properties[FILES_ABSTRACT_SLOT_SLOT_NUMBER_PROPERTY]);
	}
}

static void
g_cclosure_user_marshal_VOID__BOOLEAN_BOOLEAN (GClosure * closure,
                                               GValue * return_value,
                                               guint n_param_values,
                                               const GValue * param_values,
                                               gpointer invocation_hint,
                                               gpointer marshal_data)
{
	typedef void (*GMarshalFunc_VOID__BOOLEAN_BOOLEAN) (gpointer data1, gboolean arg_1, gboolean arg_2, gpointer data2);
	register GMarshalFunc_VOID__BOOLEAN_BOOLEAN callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 3);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__BOOLEAN_BOOLEAN) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_boolean (param_values + 1), g_value_get_boolean (param_values + 2), data2);
}

static void
g_cclosure_user_marshal_VOID__OBJECT_ENUM (GClosure * closure,
                                           GValue * return_value,
                                           guint n_param_values,
                                           const GValue * param_values,
                                           gpointer invocation_hint,
                                           gpointer marshal_data)
{
	typedef void (*GMarshalFunc_VOID__OBJECT_ENUM) (gpointer data1, gpointer arg_1, gint arg_2, gpointer data2);
	register GMarshalFunc_VOID__OBJECT_ENUM callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 3);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__OBJECT_ENUM) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_object (param_values + 1), g_value_get_enum (param_values + 2), data2);
}

static GObject *
files_abstract_slot_constructor (GType type,
                                 guint n_construct_properties,
                                 GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	FilesAbstractSlot * self;
	GtkBox* _tmp0_ = NULL;
	GtkBox* _tmp1_;
	GtkBox* _tmp2_;
	GtkBox* _tmp3_;
	GtkBox* _tmp4_;
	GtkBox* _tmp5_;
	GtkBox* _tmp6_;
	parent_class = G_OBJECT_CLASS (files_abstract_slot_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, FILES_TYPE_ABSTRACT_SLOT, FilesAbstractSlot);
	_tmp0_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 0);
	gtk_widget_set_vexpand ((GtkWidget*) _tmp0_, TRUE);
	gtk_widget_set_hexpand ((GtkWidget*) _tmp0_, TRUE);
	g_object_ref_sink (_tmp0_);
	_g_object_unref0 (self->content_box);
	self->content_box = _tmp0_;
	_tmp1_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 0);
	g_object_ref_sink (_tmp1_);
	_g_object_unref0 (self->extra_location_widgets);
	self->extra_location_widgets = _tmp1_;
	_tmp2_ = self->content_box;
	_tmp3_ = self->extra_location_widgets;
	gtk_container_add ((GtkContainer*) _tmp2_, (GtkWidget*) _tmp3_);
	_tmp4_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 0);
	g_object_ref_sink (_tmp4_);
	_g_object_unref0 (self->extra_action_widgets);
	self->extra_action_widgets = _tmp4_;
	_tmp5_ = self->content_box;
	_tmp6_ = self->extra_action_widgets;
	gtk_container_add ((GtkContainer*) _tmp5_, (GtkWidget*) _tmp6_);
	files_abstract_slot_set_slot_number (self, -1);
	return obj;
}

static void
files_abstract_slot_class_init (FilesAbstractSlotClass * klass,
                                gpointer klass_data)
{
	files_abstract_slot_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &FilesAbstractSlot_private_offset);
	((FilesAbstractSlotClass *) klass)->initialize_directory = (void (*) (FilesAbstractSlot*)) files_abstract_slot_real_initialize_directory;
	((FilesAbstractSlotClass *) klass)->get_selected_files = (GList* (*) (FilesAbstractSlot*)) files_abstract_slot_real_get_selected_files;
	((FilesAbstractSlotClass *) klass)->set_active_state = (void (*) (FilesAbstractSlot*, gboolean, gboolean)) files_abstract_slot_real_set_active_state;
	((FilesAbstractSlotClass *) klass)->get_current_slot = (FilesAbstractSlot* (*) (FilesAbstractSlot*)) files_abstract_slot_real_get_current_slot;
	((FilesAbstractSlotClass *) klass)->reload = (void (*) (FilesAbstractSlot*, gboolean)) files_abstract_slot_real_reload;
	((FilesAbstractSlotClass *) klass)->grab_focus = (void (*) (FilesAbstractSlot*)) files_abstract_slot_real_grab_focus;
	((FilesAbstractSlotClass *) klass)->user_path_change_request = (void (*) (FilesAbstractSlot*, GFile*, gboolean)) files_abstract_slot_real_user_path_change_request;
	((FilesAbstractSlotClass *) klass)->focus_first_for_empty_selection = (void (*) (FilesAbstractSlot*, gboolean)) files_abstract_slot_real_focus_first_for_empty_selection;
	((FilesAbstractSlotClass *) klass)->select_glib_files = (void (*) (FilesAbstractSlot*, GList*, GFile*)) files_abstract_slot_real_select_glib_files;
	((FilesAbstractSlotClass *) klass)->close = (void (*) (FilesAbstractSlot*)) files_abstract_slot_real_close;
	((FilesAbstractSlotClass *) klass)->lookup_file_info = (GFileInfo* (*) (FilesAbstractSlot*, GFile*)) files_abstract_slot_real_lookup_file_info;
	((FilesAbstractSlotClass *) klass)->zoom_out = (void (*) (FilesAbstractSlot*)) files_abstract_slot_real_zoom_out;
	((FilesAbstractSlotClass *) klass)->zoom_in = (void (*) (FilesAbstractSlot*)) files_abstract_slot_real_zoom_in;
	((FilesAbstractSlotClass *) klass)->zoom_normal = (void (*) (FilesAbstractSlot*)) files_abstract_slot_real_zoom_normal;
	((FilesAbstractSlotClass *) klass)->set_all_selected = (gboolean (*) (FilesAbstractSlot*, gboolean)) files_abstract_slot_real_set_all_selected;
	((FilesAbstractSlotClass *) klass)->get_content_box = (GtkWidget* (*) (FilesAbstractSlot*)) files_abstract_slot_real_get_content_box;
	((FilesAbstractSlotClass *) klass)->get_root_uri = (gchar* (*) (FilesAbstractSlot*)) files_abstract_slot_real_get_root_uri;
	((FilesAbstractSlotClass *) klass)->get_tip_uri = (gchar* (*) (FilesAbstractSlot*)) files_abstract_slot_real_get_tip_uri;
	((FilesAbstractSlotClass *) klass)->get_realized = (gboolean (*) (FilesAbstractSlot*)) files_abstract_slot_real_get_realized;
	FILES_ABSTRACT_SLOT_CLASS (klass)->get_locked_focus = (gboolean (*) (FilesAbstractSlot*)) files_abstract_slot_real_get_locked_focus;
	FILES_ABSTRACT_SLOT_CLASS (klass)->get_is_frozen = (gboolean (*) (FilesAbstractSlot*)) files_abstract_slot_real_get_is_frozen;
	FILES_ABSTRACT_SLOT_CLASS (klass)->set_is_frozen = (void (*) (FilesAbstractSlot*, gboolean)) files_abstract_slot_real_set_is_frozen;
	G_OBJECT_CLASS (klass)->get_property = _vala_files_abstract_slot_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_files_abstract_slot_set_property;
	G_OBJECT_CLASS (klass)->constructor = files_abstract_slot_constructor;
	G_OBJECT_CLASS (klass)->finalize = files_abstract_slot_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), FILES_ABSTRACT_SLOT_DIRECTORY_PROPERTY, files_abstract_slot_properties[FILES_ABSTRACT_SLOT_DIRECTORY_PROPERTY] = g_param_spec_object ("directory", "directory", "directory", FILES_TYPE_DIRECTORY, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), FILES_ABSTRACT_SLOT_FILE_PROPERTY, files_abstract_slot_properties[FILES_ABSTRACT_SLOT_FILE_PROPERTY] = g_param_spec_object ("file", "file", "file", FILES_TYPE_FILE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), FILES_ABSTRACT_SLOT_LOCATION_PROPERTY, files_abstract_slot_properties[FILES_ABSTRACT_SLOT_LOCATION_PROPERTY] = g_param_spec_object ("location", "location", "location", g_file_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), FILES_ABSTRACT_SLOT_URI_PROPERTY, files_abstract_slot_properties[FILES_ABSTRACT_SLOT_URI_PROPERTY] = g_param_spec_string ("uri", "uri", "uri", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), FILES_ABSTRACT_SLOT_LOCKED_FOCUS_PROPERTY, files_abstract_slot_properties[FILES_ABSTRACT_SLOT_LOCKED_FOCUS_PROPERTY] = g_param_spec_boolean ("locked-focus", "locked-focus", "locked-focus", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), FILES_ABSTRACT_SLOT_IS_FROZEN_PROPERTY, files_abstract_slot_properties[FILES_ABSTRACT_SLOT_IS_FROZEN_PROPERTY] = g_param_spec_boolean ("is-frozen", "is-frozen", "is-frozen", TRUE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), FILES_ABSTRACT_SLOT_OVERLAY_PROPERTY, files_abstract_slot_properties[FILES_ABSTRACT_SLOT_OVERLAY_PROPERTY] = g_param_spec_object ("overlay", "overlay", "overlay", gtk_overlay_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), FILES_ABSTRACT_SLOT_SLOT_NUMBER_PROPERTY, files_abstract_slot_properties[FILES_ABSTRACT_SLOT_SLOT_NUMBER_PROPERTY] = g_param_spec_int ("slot-number", "slot-number", "slot-number", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	files_abstract_slot_signals[FILES_ABSTRACT_SLOT_ACTIVE_SIGNAL] = g_signal_new ("active", FILES_TYPE_ABSTRACT_SLOT, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__BOOLEAN_BOOLEAN, G_TYPE_NONE, 2, G_TYPE_BOOLEAN, G_TYPE_BOOLEAN);
	files_abstract_slot_signals[FILES_ABSTRACT_SLOT_INACTIVE_SIGNAL] = g_signal_new ("inactive", FILES_TYPE_ABSTRACT_SLOT, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	files_abstract_slot_signals[FILES_ABSTRACT_SLOT_PATH_CHANGED_SIGNAL] = g_signal_new ("path-changed", FILES_TYPE_ABSTRACT_SLOT, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	files_abstract_slot_signals[FILES_ABSTRACT_SLOT_NEW_CONTAINER_REQUEST_SIGNAL] = g_signal_new ("new-container-request", FILES_TYPE_ABSTRACT_SLOT, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__OBJECT_ENUM, G_TYPE_NONE, 2, g_file_get_type (), FILES_TYPE_OPEN_FLAG);
	files_abstract_slot_signals[FILES_ABSTRACT_SLOT_SELECTION_CHANGED_SIGNAL] = g_signal_new ("selection-changed", FILES_TYPE_ABSTRACT_SLOT, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__POINTER, G_TYPE_NONE, 1, G_TYPE_POINTER);
	files_abstract_slot_signals[FILES_ABSTRACT_SLOT_DIRECTORY_LOADED_SIGNAL] = g_signal_new ("directory-loaded", FILES_TYPE_ABSTRACT_SLOT, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, FILES_TYPE_DIRECTORY);
}

static void
files_abstract_slot_instance_init (FilesAbstractSlot * self,
                                   gpointer klass)
{
	self->priv = files_abstract_slot_get_instance_private (self);
	self->priv->_is_frozen = TRUE;
}

static void
files_abstract_slot_finalize (GObject * obj)
{
	FilesAbstractSlot * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, FILES_TYPE_ABSTRACT_SLOT, FilesAbstractSlot);
	_g_object_unref0 (self->priv->_directory);
	_g_object_unref0 (self->extra_location_widgets);
	_g_object_unref0 (self->extra_action_widgets);
	_g_object_unref0 (self->content_box);
	_g_object_unref0 (self->priv->_overlay);
	G_OBJECT_CLASS (files_abstract_slot_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
files_abstract_slot_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (FilesAbstractSlotClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) files_abstract_slot_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FilesAbstractSlot), 0, (GInstanceInitFunc) files_abstract_slot_instance_init, NULL };
	GType files_abstract_slot_type_id;
	files_abstract_slot_type_id = g_type_register_static (G_TYPE_OBJECT, "FilesAbstractSlot", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
	FilesAbstractSlot_private_offset = g_type_add_instance_private (files_abstract_slot_type_id, sizeof (FilesAbstractSlotPrivate));
	return files_abstract_slot_type_id;
}

GType
files_abstract_slot_get_type (void)
{
	static volatile gsize files_abstract_slot_type_id__once = 0;
	if (g_once_init_enter (&files_abstract_slot_type_id__once)) {
		GType files_abstract_slot_type_id;
		files_abstract_slot_type_id = files_abstract_slot_get_type_once ();
		g_once_init_leave (&files_abstract_slot_type_id__once, files_abstract_slot_type_id);
	}
	return files_abstract_slot_type_id__once;
}

static void
_vala_files_abstract_slot_get_property (GObject * object,
                                        guint property_id,
                                        GValue * value,
                                        GParamSpec * pspec)
{
	FilesAbstractSlot * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, FILES_TYPE_ABSTRACT_SLOT, FilesAbstractSlot);
	switch (property_id) {
		case FILES_ABSTRACT_SLOT_DIRECTORY_PROPERTY:
		g_value_set_object (value, files_abstract_slot_get_directory (self));
		break;
		case FILES_ABSTRACT_SLOT_FILE_PROPERTY:
		g_value_set_object (value, files_abstract_slot_get_file (self));
		break;
		case FILES_ABSTRACT_SLOT_LOCATION_PROPERTY:
		g_value_set_object (value, files_abstract_slot_get_location (self));
		break;
		case FILES_ABSTRACT_SLOT_URI_PROPERTY:
		g_value_set_string (value, files_abstract_slot_get_uri (self));
		break;
		case FILES_ABSTRACT_SLOT_LOCKED_FOCUS_PROPERTY:
		g_value_set_boolean (value, files_abstract_slot_get_locked_focus (self));
		break;
		case FILES_ABSTRACT_SLOT_IS_FROZEN_PROPERTY:
		g_value_set_boolean (value, files_abstract_slot_get_is_frozen (self));
		break;
		case FILES_ABSTRACT_SLOT_OVERLAY_PROPERTY:
		g_value_set_object (value, files_abstract_slot_get_overlay (self));
		break;
		case FILES_ABSTRACT_SLOT_SLOT_NUMBER_PROPERTY:
		g_value_set_int (value, files_abstract_slot_get_slot_number (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_files_abstract_slot_set_property (GObject * object,
                                        guint property_id,
                                        const GValue * value,
                                        GParamSpec * pspec)
{
	FilesAbstractSlot * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, FILES_TYPE_ABSTRACT_SLOT, FilesAbstractSlot);
	switch (property_id) {
		case FILES_ABSTRACT_SLOT_DIRECTORY_PROPERTY:
		files_abstract_slot_set_directory (self, g_value_get_object (value));
		break;
		case FILES_ABSTRACT_SLOT_LOCATION_PROPERTY:
		files_abstract_slot_set_location (self, g_value_get_object (value));
		break;
		case FILES_ABSTRACT_SLOT_IS_FROZEN_PROPERTY:
		files_abstract_slot_set_is_frozen (self, g_value_get_boolean (value));
		break;
		case FILES_ABSTRACT_SLOT_OVERLAY_PROPERTY:
		files_abstract_slot_set_overlay (self, g_value_get_object (value));
		break;
		case FILES_ABSTRACT_SLOT_SLOT_NUMBER_PROPERTY:
		files_abstract_slot_set_slot_number (self, g_value_get_int (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

