/* MainWindow.c generated by valac 0.56.17, the Vala compiler
 * generated from MainWindow.vala, do not modify */

/*
 * SPDX-License-Identifier: LGPL-3.0-or-later
 * SPDX-FileCopyrightText: 2021 elementary, Inc. (https://elementary.io)
 */

#include <gtk/gtk.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <glib.h>
#include <glib/gi18n-lib.h>
#include <stdlib.h>
#include <string.h>
#include <granite-7.h>
#include <gdk/gdk.h>
#include <adwaita.h>
#include <float.h>
#include <math.h>

#define MUSIC_APPLICATION_ACTION_PREFIX "app."
#define MUSIC_APPLICATION_ACTION_SHUFFLE "action-shuffle"
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define MUSIC_TYPE_MAIN_WINDOW (music_main_window_get_type ())
#define MUSIC_MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), MUSIC_TYPE_MAIN_WINDOW, MusicMainWindow))
#define MUSIC_MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), MUSIC_TYPE_MAIN_WINDOW, MusicMainWindowClass))
#define MUSIC_IS_MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), MUSIC_TYPE_MAIN_WINDOW))
#define MUSIC_IS_MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), MUSIC_TYPE_MAIN_WINDOW))
#define MUSIC_MAIN_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), MUSIC_TYPE_MAIN_WINDOW, MusicMainWindowClass))

typedef struct _MusicMainWindow MusicMainWindow;
typedef struct _MusicMainWindowClass MusicMainWindowClass;
typedef struct _MusicMainWindowPrivate MusicMainWindowPrivate;
enum  {
	MUSIC_MAIN_WINDOW_0_PROPERTY,
	MUSIC_MAIN_WINDOW_NUM_PROPERTIES
};
static GParamSpec* music_main_window_properties[MUSIC_MAIN_WINDOW_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _Block2Data Block2Data;
#define _g_free0(var) (var = (g_free (var), NULL))

#define MUSIC_TYPE_PLAYBACK_MANAGER (music_playback_manager_get_type ())
#define MUSIC_PLAYBACK_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), MUSIC_TYPE_PLAYBACK_MANAGER, MusicPlaybackManager))
#define MUSIC_PLAYBACK_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), MUSIC_TYPE_PLAYBACK_MANAGER, MusicPlaybackManagerClass))
#define MUSIC_IS_PLAYBACK_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), MUSIC_TYPE_PLAYBACK_MANAGER))
#define MUSIC_IS_PLAYBACK_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), MUSIC_TYPE_PLAYBACK_MANAGER))
#define MUSIC_PLAYBACK_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), MUSIC_TYPE_PLAYBACK_MANAGER, MusicPlaybackManagerClass))

typedef struct _MusicPlaybackManager MusicPlaybackManager;
typedef struct _MusicPlaybackManagerClass MusicPlaybackManagerClass;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define MUSIC_TYPE_AUDIO_OBJECT (music_audio_object_get_type ())
#define MUSIC_AUDIO_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), MUSIC_TYPE_AUDIO_OBJECT, MusicAudioObject))
#define MUSIC_AUDIO_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), MUSIC_TYPE_AUDIO_OBJECT, MusicAudioObjectClass))
#define MUSIC_IS_AUDIO_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), MUSIC_TYPE_AUDIO_OBJECT))
#define MUSIC_IS_AUDIO_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), MUSIC_TYPE_AUDIO_OBJECT))
#define MUSIC_AUDIO_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), MUSIC_TYPE_AUDIO_OBJECT, MusicAudioObjectClass))

typedef struct _MusicAudioObject MusicAudioObject;
typedef struct _MusicAudioObjectClass MusicAudioObjectClass;

#define MUSIC_TYPE_TRACK_ROW (music_track_row_get_type ())
#define MUSIC_TRACK_ROW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), MUSIC_TYPE_TRACK_ROW, MusicTrackRow))
#define MUSIC_TRACK_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), MUSIC_TYPE_TRACK_ROW, MusicTrackRowClass))
#define MUSIC_IS_TRACK_ROW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), MUSIC_TYPE_TRACK_ROW))
#define MUSIC_IS_TRACK_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), MUSIC_TYPE_TRACK_ROW))
#define MUSIC_TRACK_ROW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), MUSIC_TYPE_TRACK_ROW, MusicTrackRowClass))

typedef struct _MusicTrackRow MusicTrackRow;
typedef struct _MusicTrackRowClass MusicTrackRowClass;
typedef struct _Block3Data Block3Data;

#define MUSIC_TYPE_NOW_PLAYING_VIEW (music_now_playing_view_get_type ())
#define MUSIC_NOW_PLAYING_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), MUSIC_TYPE_NOW_PLAYING_VIEW, MusicNowPlayingView))
#define MUSIC_NOW_PLAYING_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), MUSIC_TYPE_NOW_PLAYING_VIEW, MusicNowPlayingViewClass))
#define MUSIC_IS_NOW_PLAYING_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), MUSIC_TYPE_NOW_PLAYING_VIEW))
#define MUSIC_IS_NOW_PLAYING_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), MUSIC_TYPE_NOW_PLAYING_VIEW))
#define MUSIC_NOW_PLAYING_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), MUSIC_TYPE_NOW_PLAYING_VIEW, MusicNowPlayingViewClass))

typedef struct _MusicNowPlayingView MusicNowPlayingView;
typedef struct _MusicNowPlayingViewClass MusicNowPlayingViewClass;
#define __vala_GdkFileList_free0(var) ((var == NULL) ? NULL : (var = (_vala_GdkFileList_free (var), NULL)))

struct _MusicMainWindow {
	GtkApplicationWindow parent_instance;
	MusicMainWindowPrivate * priv;
};

struct _MusicMainWindowClass {
	GtkApplicationWindowClass parent_class;
};

struct _MusicMainWindowPrivate {
	GtkButton* repeat_button;
	GtkButton* shuffle_button;
	GSettings* settings;
};

struct _Block2Data {
	int _ref_count_;
	MusicMainWindow* self;
	GtkFileDialog* file_dialog;
};

struct _Block3Data {
	int _ref_count_;
	MusicMainWindow* self;
	MusicPlaybackManager* playback_manager;
	GraniteToast* error_toast;
};

static gint MusicMainWindow_private_offset;
static gpointer music_main_window_parent_class = NULL;

VALA_EXTERN GType music_main_window_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MusicMainWindow, g_object_unref)
static void music_main_window_action_open (MusicMainWindow* self);
static Block2Data* block2_data_ref (Block2Data* _data2_);
static void block2_data_unref (void * _userdata_);
static void __lambda15_ (Block2Data* _data2_,
                  GObject* obj,
                  GAsyncResult* res);
static void _vala_array_add4 (GFile** * array,
                       gint* length,
                       gint* size,
                       GFile* value);
VALA_EXTERN GFile** music_application_loop_through_files (GFile** files,
                                              gint files_length1,
                                              gint* result_length1);
VALA_EXTERN GType music_playback_manager_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MusicPlaybackManager, g_object_unref)
VALA_EXTERN MusicPlaybackManager* music_playback_manager_get_default (void);
VALA_EXTERN void music_playback_manager_queue_files (MusicPlaybackManager* self,
                                         GFile** files,
                                         gint files_length1);
static void _gtk_window_destroy_gtk_dialog_response (GtkDialog* _sender,
                                              gint response_id,
                                              gpointer self);
static void ___lambda15__gasync_ready_callback (GObject* source_object,
                                         GAsyncResult* res,
                                         gpointer self);
static void music_main_window_update_repeat_button (MusicMainWindow* self);
static GtkWidget* music_main_window_create_queue_row (MusicMainWindow* self,
                                               GObject* object);
VALA_EXTERN GType music_audio_object_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MusicAudioObject, g_object_unref)
VALA_EXTERN MusicTrackRow* music_track_row_new (MusicAudioObject* audio_object);
VALA_EXTERN MusicTrackRow* music_track_row_construct (GType object_type,
                                          MusicAudioObject* audio_object);
VALA_EXTERN GType music_track_row_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MusicTrackRow, g_object_unref)
VALA_EXTERN MusicMainWindow* music_main_window_new (void);
VALA_EXTERN MusicMainWindow* music_main_window_construct (GType object_type);
static GObject * music_main_window_constructor (GType type,
                                         guint n_construct_properties,
                                         GObjectConstructParam * construct_properties);
static Block3Data* block3_data_ref (Block3Data* _data3_);
static void block3_data_unref (void * _userdata_);
VALA_EXTERN GListStore* music_playback_manager_get_queue_liststore (MusicPlaybackManager* self);
static GtkWidget* _music_main_window_create_queue_row_gtk_list_box_create_widget_func (GObject* item,
                                                                                gpointer self);
VALA_EXTERN GType music_now_playing_view_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MusicNowPlayingView, g_object_unref)
VALA_EXTERN MusicNowPlayingView* music_now_playing_view_new (void);
VALA_EXTERN MusicNowPlayingView* music_now_playing_view_construct (GType object_type);
static void _music_main_window_update_repeat_button_g_settings_changed (GSettings* _sender,
                                                                 const gchar* key,
                                                                 gpointer self);
static gboolean _music_main_window___lambda23_ (MusicMainWindow* self,
                                         GtkDropTarget* target,
                                         GValue* value,
                                         gdouble x,
                                         gdouble y);
static GdkFileList* _vala_GdkFileList_copy (GdkFileList* self);
static void _vala_array_add5 (GFile** * array,
                       gint* length,
                       gint* size,
                       GFile* value);
static void _vala_GdkFileList_free (GdkFileList* self);
static gboolean __music_main_window___lambda23__gtk_drop_target_drop (GtkDropTarget* _sender,
                                                               GValue* value,
                                                               gdouble x,
                                                               gdouble y,
                                                               gpointer self);
static void _music_main_window___lambda24_ (Block3Data* _data3_,
                                     gint count);
static void __music_main_window___lambda24__music_playback_manager_invalids_found (MusicPlaybackManager* _sender,
                                                                            gint count,
                                                                            gpointer self);
static void _music_main_window_action_open_gtk_button_clicked (GtkButton* _sender,
                                                        gpointer self);
static void _music_main_window___lambda25_ (MusicMainWindow* self);
static void __music_main_window___lambda25__gtk_button_clicked (GtkButton* _sender,
                                                         gpointer self);
static void _music_main_window___lambda26_ (Block3Data* _data3_,
                                     GtkListBoxRow* row);
VALA_EXTERN MusicAudioObject* music_track_row_get_audio_object (MusicTrackRow* self);
VALA_EXTERN void music_playback_manager_set_current_audio (MusicPlaybackManager* self,
                                               MusicAudioObject* value);
static void __music_main_window___lambda26__gtk_list_box_row_activated (GtkListBox* _sender,
                                                                 GtkListBoxRow* row,
                                                                 gpointer self);
static void music_main_window_finalize (GObject * obj);
static GType music_main_window_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

static inline gpointer
music_main_window_get_instance_private (MusicMainWindow* self)
{
	return G_STRUCT_MEMBER_P (self, MusicMainWindow_private_offset);
}

static Block2Data*
block2_data_ref (Block2Data* _data2_)
{
	g_atomic_int_inc (&_data2_->_ref_count_);
	return _data2_;
}

static void
block2_data_unref (void * _userdata_)
{
	Block2Data* _data2_;
	_data2_ = (Block2Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data2_->_ref_count_)) {
		MusicMainWindow* self;
		self = _data2_->self;
		_g_object_unref0 (_data2_->file_dialog);
		_g_object_unref0 (self);
		g_slice_free (Block2Data, _data2_);
	}
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
_vala_array_add4 (GFile** * array,
                  gint* length,
                  gint* size,
                  GFile* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (GFile*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_gtk_window_destroy_gtk_dialog_response (GtkDialog* _sender,
                                         gint response_id,
                                         gpointer self)
{
	gtk_window_destroy ((GtkWindow*) self);
}

static void
__lambda15_ (Block2Data* _data2_,
             GObject* obj,
             GAsyncResult* res)
{
	MusicMainWindow* self;
	GError* _inner_error0_ = NULL;
	self = _data2_->self;
	g_return_if_fail (res != NULL);
	{
		GListModel* files = NULL;
		GListModel* _tmp0_;
		GFile** file_array = NULL;
		GFile** _tmp1_;
		gint file_array_length1;
		gint _file_array_size_;
		GFile** files_to_play = NULL;
		GFile** _tmp7_;
		gint _tmp7__length1;
		gint _tmp8_ = 0;
		GFile** _tmp9_;
		gint files_to_play_length1;
		gint _files_to_play_size_;
		MusicPlaybackManager* _tmp10_;
		GFile** _tmp11_;
		gint _tmp11__length1;
		_tmp0_ = gtk_file_dialog_open_multiple_finish (_data2_->file_dialog, res, &_inner_error0_);
		files = _tmp0_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp1_ = g_new0 (GFile*, 0 + 1);
		file_array = _tmp1_;
		file_array_length1 = 0;
		_file_array_size_ = file_array_length1;
		{
			gint i = 0;
			i = 0;
			{
				gboolean _tmp2_ = FALSE;
				_tmp2_ = TRUE;
				while (TRUE) {
					GListModel* _tmp4_;
					GListModel* _tmp5_;
					GObject* _tmp6_;
					if (!_tmp2_) {
						gint _tmp3_;
						_tmp3_ = i;
						i = _tmp3_ + 1;
					}
					_tmp2_ = FALSE;
					_tmp4_ = files;
					if (!(((guint) i) < g_list_model_get_n_items (_tmp4_))) {
						break;
					}
					_tmp5_ = files;
					_tmp6_ = g_list_model_get_item (_tmp5_, (guint) i);
					_vala_array_add4 (&file_array, &file_array_length1, &_file_array_size_, G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, g_file_get_type (), GFile));
				}
			}
		}
		_tmp7_ = file_array;
		_tmp7__length1 = file_array_length1;
		_tmp9_ = music_application_loop_through_files (_tmp7_, (gint) _tmp7__length1, &_tmp8_);
		files_to_play = _tmp9_;
		files_to_play_length1 = _tmp8_;
		_files_to_play_size_ = files_to_play_length1;
		_tmp10_ = music_playback_manager_get_default ();
		_tmp11_ = files_to_play;
		_tmp11__length1 = files_to_play_length1;
		music_playback_manager_queue_files (_tmp10_, _tmp11_, (gint) _tmp11__length1);
		files_to_play = (_vala_array_free (files_to_play, files_to_play_length1, (GDestroyNotify) g_object_unref), NULL);
		file_array = (_vala_array_free (file_array, file_array_length1, (GDestroyNotify) g_object_unref), NULL);
		_g_object_unref0 (files);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp12_;
		GraniteMessageDialog* dialog = NULL;
		GError* _tmp13_;
		const gchar* _tmp14_;
		GThemedIcon* _tmp15_;
		GThemedIcon* _tmp16_;
		GThemedIcon* _tmp17_;
		GtkWindow* _tmp18_;
		GraniteMessageDialog* _tmp19_ = NULL;
		GraniteMessageDialog* _tmp20_;
		GraniteMessageDialog* _tmp21_;
		GraniteMessageDialog* _tmp22_;
		GraniteMessageDialog* _tmp23_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp12_ = e;
		if (g_error_matches (_tmp12_, gtk_dialog_error_quark (), GTK_DIALOG_ERROR_DISMISSED)) {
			_g_error_free0 (e);
			return;
		}
		_tmp13_ = e;
		_tmp14_ = _tmp13_->message;
		_tmp15_ = (GThemedIcon*) g_themed_icon_new ("document-open");
		_tmp16_ = _tmp15_;
		_tmp17_ = (GThemedIcon*) g_themed_icon_new ("dialog-error");
		_tmp18_ = _g_object_ref0 ((GtkWindow*) self);
		_tmp19_ = granite_message_dialog_new ("Couldn't add audio files", _tmp14_, (GIcon*) _tmp16_, GTK_BUTTONS_CLOSE);
		granite_message_dialog_set_badge_icon (_tmp19_, (GIcon*) _tmp17_);
		_g_object_unref0 (_tmp17_);
		gtk_window_set_modal ((GtkWindow*) _tmp19_, TRUE);
		gtk_window_set_transient_for ((GtkWindow*) _tmp19_, _tmp18_);
		_g_object_unref0 (_tmp18_);
		g_object_ref_sink (_tmp19_);
		_tmp20_ = _tmp19_;
		_g_object_unref0 (_tmp16_);
		dialog = _tmp20_;
		_tmp21_ = dialog;
		gtk_window_present ((GtkWindow*) _tmp21_);
		_tmp22_ = dialog;
		_tmp23_ = dialog;
		g_signal_connect_object ((GtkDialog*) _tmp22_, "response", (GCallback) _gtk_window_destroy_gtk_dialog_response, (GtkWindow*) _tmp23_, 0);
		_g_object_unref0 (dialog);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
___lambda15__gasync_ready_callback (GObject* source_object,
                                    GAsyncResult* res,
                                    gpointer self)
{
	__lambda15_ (self, source_object, res);
	block2_data_unref (self);
}

static void
music_main_window_action_open (MusicMainWindow* self)
{
	Block2Data* _data2_;
	GtkFileFilter* all_files_filter = NULL;
	gchar* _tmp0_;
	GtkFileFilter* _tmp1_ = NULL;
	GtkFileFilter* music_files_filter = NULL;
	gchar* _tmp2_;
	GtkFileFilter* _tmp3_ = NULL;
	GListStore* filter_model = NULL;
	GListStore* _tmp4_;
	gchar* _tmp5_;
	GtkFileFilter* _tmp6_;
	GListModel* _tmp7_;
	gchar* _tmp8_;
	GtkFileDialog* _tmp9_ = NULL;
	MusicMainWindow* _tmp10_;
	g_return_if_fail (self != NULL);
	_data2_ = g_slice_new0 (Block2Data);
	_data2_->_ref_count_ = 1;
	_data2_->self = g_object_ref (self);
	_tmp0_ = g_strdup (_ ("All files"));
	_tmp1_ = gtk_file_filter_new ();
	g_object_set (_tmp1_, "name", _tmp0_, NULL);
	_g_free0 (_tmp0_);
	all_files_filter = _tmp1_;
	gtk_file_filter_add_pattern (all_files_filter, "*");
	_tmp2_ = g_strdup (_ ("Music files"));
	_tmp3_ = gtk_file_filter_new ();
	g_object_set (_tmp3_, "name", _tmp2_, NULL);
	_g_free0 (_tmp2_);
	music_files_filter = _tmp3_;
	gtk_file_filter_add_mime_type (music_files_filter, "audio/*");
	_tmp4_ = g_list_store_new (gtk_file_filter_get_type ());
	filter_model = _tmp4_;
	g_list_store_append (filter_model, (GObject*) all_files_filter);
	g_list_store_append (filter_model, (GObject*) music_files_filter);
	_tmp5_ = g_strdup (_ ("Open"));
	_tmp6_ = _g_object_ref0 (music_files_filter);
	_tmp7_ = _g_object_ref0 ((GListModel*) filter_model);
	_tmp8_ = g_strdup (_ ("Open audio files"));
	_tmp9_ = gtk_file_dialog_new ();
	gtk_file_dialog_set_accept_label (_tmp9_, _tmp5_);
	_g_free0 (_tmp5_);
	gtk_file_dialog_set_default_filter (_tmp9_, _tmp6_);
	_g_object_unref0 (_tmp6_);
	gtk_file_dialog_set_filters (_tmp9_, _tmp7_);
	_g_object_unref0 (_tmp7_);
	gtk_file_dialog_set_modal (_tmp9_, TRUE);
	gtk_file_dialog_set_title (_tmp9_, _tmp8_);
	_g_free0 (_tmp8_);
	_data2_->file_dialog = _tmp9_;
	_tmp10_ = self;
	gtk_file_dialog_open_multiple (_data2_->file_dialog, (GtkWindow*) _tmp10_, NULL, ___lambda15__gasync_ready_callback, block2_data_ref (_data2_));
	_g_object_unref0 (filter_model);
	_g_object_unref0 (music_files_filter);
	_g_object_unref0 (all_files_filter);
	block2_data_unref (_data2_);
	_data2_ = NULL;
}

static void
music_main_window_update_repeat_button (MusicMainWindow* self)
{
	GSettings* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	GQuark _tmp4_ = 0U;
	static GQuark _tmp3_label0 = 0;
	static GQuark _tmp3_label1 = 0;
	static GQuark _tmp3_label2 = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->settings;
	_tmp1_ = g_settings_get_string (_tmp0_, "repeat-mode");
	_tmp2_ = _tmp1_;
	_tmp4_ = (NULL == _tmp2_) ? 0 : g_quark_from_string (_tmp2_);
	g_free (_tmp2_);
	if (_tmp4_ == ((0 != _tmp3_label0) ? _tmp3_label0 : (_tmp3_label0 = g_quark_from_static_string ("disabled")))) {
		switch (0) {
			default:
			{
				GtkButton* _tmp5_;
				GtkButton* _tmp6_;
				_tmp5_ = self->priv->repeat_button;
				gtk_button_set_icon_name (_tmp5_, "media-playlist-no-repeat-symbolic");
				_tmp6_ = self->priv->repeat_button;
				gtk_widget_set_tooltip_text ((GtkWidget*) _tmp6_, _ ("Repeat None"));
				break;
			}
		}
	} else if (_tmp4_ == ((0 != _tmp3_label1) ? _tmp3_label1 : (_tmp3_label1 = g_quark_from_static_string ("all")))) {
		switch (0) {
			default:
			{
				GtkButton* _tmp7_;
				GtkButton* _tmp8_;
				_tmp7_ = self->priv->repeat_button;
				gtk_button_set_icon_name (_tmp7_, "media-playlist-repeat-symbolic");
				_tmp8_ = self->priv->repeat_button;
				gtk_widget_set_tooltip_text ((GtkWidget*) _tmp8_, _ ("Repeat All"));
				break;
			}
		}
	} else if (_tmp4_ == ((0 != _tmp3_label2) ? _tmp3_label2 : (_tmp3_label2 = g_quark_from_static_string ("one")))) {
		switch (0) {
			default:
			{
				GtkButton* _tmp9_;
				GtkButton* _tmp10_;
				_tmp9_ = self->priv->repeat_button;
				gtk_button_set_icon_name (_tmp9_, "media-playlist-repeat-song-symbolic");
				_tmp10_ = self->priv->repeat_button;
				gtk_widget_set_tooltip_text ((GtkWidget*) _tmp10_, _ ("Repeat One"));
				break;
			}
		}
	}
}

static GtkWidget*
music_main_window_create_queue_row (MusicMainWindow* self,
                                    GObject* object)
{
	MusicAudioObject* audio_object = NULL;
	MusicTrackRow* _tmp0_;
	GtkWidget* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (object != NULL, NULL);
	audio_object = G_TYPE_CHECK_INSTANCE_CAST (object, MUSIC_TYPE_AUDIO_OBJECT, MusicAudioObject);
	_tmp0_ = music_track_row_new (audio_object);
	g_object_ref_sink (_tmp0_);
	result = (GtkWidget*) _tmp0_;
	return result;
}

MusicMainWindow*
music_main_window_construct (GType object_type)
{
	MusicMainWindow * self = NULL;
	self = (MusicMainWindow*) g_object_new (object_type, NULL);
	return self;
}

MusicMainWindow*
music_main_window_new (void)
{
	return music_main_window_construct (MUSIC_TYPE_MAIN_WINDOW);
}

static Block3Data*
block3_data_ref (Block3Data* _data3_)
{
	g_atomic_int_inc (&_data3_->_ref_count_);
	return _data3_;
}

static void
block3_data_unref (void * _userdata_)
{
	Block3Data* _data3_;
	_data3_ = (Block3Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data3_->_ref_count_)) {
		MusicMainWindow* self;
		self = _data3_->self;
		_g_object_unref0 (_data3_->error_toast);
		_g_object_unref0 (_data3_->playback_manager);
		_g_object_unref0 (self);
		g_slice_free (Block3Data, _data3_);
	}
}

static GtkWidget*
_music_main_window_create_queue_row_gtk_list_box_create_widget_func (GObject* item,
                                                                     gpointer self)
{
	GtkWidget* result;
	result = music_main_window_create_queue_row ((MusicMainWindow*) self, item);
	return result;
}

static void
_music_main_window_update_repeat_button_g_settings_changed (GSettings* _sender,
                                                            const gchar* key,
                                                            gpointer self)
{
	music_main_window_update_repeat_button ((MusicMainWindow*) self);
}

static GdkFileList*
_vala_GdkFileList_copy (GdkFileList* self)
{
	return g_boxed_copy (gdk_file_list_get_type (), self);
}

static gpointer
__vala_GdkFileList_copy0 (gpointer self)
{
	return self ? _vala_GdkFileList_copy (self) : NULL;
}

static void
_vala_array_add5 (GFile** * array,
                  gint* length,
                  gint* size,
                  GFile* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (GFile*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_GdkFileList_free (GdkFileList* self)
{
	g_boxed_free (gdk_file_list_get_type (), self);
}

static gboolean
_music_main_window___lambda23_ (MusicMainWindow* self,
                                GtkDropTarget* target,
                                GValue* value,
                                gdouble x,
                                gdouble y)
{
	gboolean result;
	g_return_val_if_fail (target != NULL, FALSE);
	g_return_val_if_fail (value != NULL, FALSE);
	if (G_VALUE_TYPE (value) == gdk_file_list_get_type ()) {
		GdkFileList* list = NULL;
		GValue _tmp0_;
		GdkFileList* _tmp1_;
		GFile** file_array = NULL;
		GFile** _tmp2_;
		gint file_array_length1;
		gint _file_array_size_;
		GdkFileList* _tmp3_;
		GSList* _tmp4_;
		GFile** files_to_play = NULL;
		GFile** _tmp7_;
		gint _tmp7__length1;
		gint _tmp8_ = 0;
		GFile** _tmp9_;
		gint files_to_play_length1;
		gint _files_to_play_size_;
		MusicPlaybackManager* _tmp10_;
		GFile** _tmp11_;
		gint _tmp11__length1;
		_tmp0_ = *value;
		_tmp1_ = __vala_GdkFileList_copy0 (g_value_get_boxed (&_tmp0_));
		list = _tmp1_;
		_tmp2_ = g_new0 (GFile*, 0 + 1);
		file_array = _tmp2_;
		file_array_length1 = 0;
		_file_array_size_ = file_array_length1;
		_tmp3_ = list;
		_tmp4_ = gdk_file_list_get_files (_tmp3_);
		{
			GSList* file_collection = NULL;
			GSList* file_it = NULL;
			file_collection = _tmp4_;
			for (file_it = file_collection; file_it != NULL; file_it = file_it->next) {
				GFile* file = NULL;
				file = (GFile*) file_it->data;
				{
					GFile* _tmp5_;
					GFile* _tmp6_;
					_tmp5_ = file;
					_tmp6_ = _g_object_ref0 (_tmp5_);
					_vala_array_add5 (&file_array, &file_array_length1, &_file_array_size_, _tmp6_);
				}
			}
			(file_collection == NULL) ? NULL : (file_collection = (g_slist_free (file_collection), NULL));
		}
		_tmp7_ = file_array;
		_tmp7__length1 = file_array_length1;
		_tmp9_ = music_application_loop_through_files (_tmp7_, (gint) _tmp7__length1, &_tmp8_);
		files_to_play = _tmp9_;
		files_to_play_length1 = _tmp8_;
		_files_to_play_size_ = files_to_play_length1;
		_tmp10_ = music_playback_manager_get_default ();
		_tmp11_ = files_to_play;
		_tmp11__length1 = files_to_play_length1;
		music_playback_manager_queue_files (_tmp10_, _tmp11_, (gint) _tmp11__length1);
		result = TRUE;
		files_to_play = (_vala_array_free (files_to_play, files_to_play_length1, (GDestroyNotify) g_object_unref), NULL);
		file_array = (_vala_array_free (file_array, file_array_length1, (GDestroyNotify) g_object_unref), NULL);
		__vala_GdkFileList_free0 (list);
		return result;
	}
	result = FALSE;
	return result;
}

static gboolean
__music_main_window___lambda23__gtk_drop_target_drop (GtkDropTarget* _sender,
                                                      GValue* value,
                                                      gdouble x,
                                                      gdouble y,
                                                      gpointer self)
{
	gboolean result;
	result = _music_main_window___lambda23_ ((MusicMainWindow*) self, _sender, value, x, y);
	return result;
}

static void
_music_main_window___lambda24_ (Block3Data* _data3_,
                                gint count)
{
	MusicMainWindow* self;
	GraniteToast* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	GraniteToast* _tmp3_;
	self = _data3_->self;
	_tmp0_ = _data3_->error_toast;
	_tmp1_ = g_strdup_printf (ngettext ("%d invalid file was not added to the queue", "%d invalid files were not added to the queue", (gulong) count), count);
	_tmp2_ = _tmp1_;
	granite_toast_set_title (_tmp0_, _tmp2_);
	_g_free0 (_tmp2_);
	_tmp3_ = _data3_->error_toast;
	granite_toast_send_notification (_tmp3_);
}

static void
__music_main_window___lambda24__music_playback_manager_invalids_found (MusicPlaybackManager* _sender,
                                                                       gint count,
                                                                       gpointer self)
{
	_music_main_window___lambda24_ (self, count);
}

static void
_music_main_window_action_open_gtk_button_clicked (GtkButton* _sender,
                                                   gpointer self)
{
	music_main_window_action_open ((MusicMainWindow*) self);
}

static void
_music_main_window___lambda25_ (MusicMainWindow* self)
{
	gint enum_step = 0;
	GSettings* _tmp0_;
	_tmp0_ = self->priv->settings;
	enum_step = g_settings_get_enum (_tmp0_, "repeat-mode");
	if (enum_step < 2) {
		GSettings* _tmp1_;
		_tmp1_ = self->priv->settings;
		g_settings_set_enum (_tmp1_, "repeat-mode", enum_step + 1);
	} else {
		GSettings* _tmp2_;
		_tmp2_ = self->priv->settings;
		g_settings_set_enum (_tmp2_, "repeat-mode", 0);
	}
}

static void
__music_main_window___lambda25__gtk_button_clicked (GtkButton* _sender,
                                                    gpointer self)
{
	_music_main_window___lambda25_ ((MusicMainWindow*) self);
}

static void
_music_main_window___lambda26_ (Block3Data* _data3_,
                                GtkListBoxRow* row)
{
	MusicMainWindow* self;
	MusicPlaybackManager* _tmp0_;
	MusicAudioObject* _tmp1_;
	MusicAudioObject* _tmp2_;
	self = _data3_->self;
	g_return_if_fail (row != NULL);
	_tmp0_ = _data3_->playback_manager;
	_tmp1_ = music_track_row_get_audio_object (G_TYPE_CHECK_INSTANCE_CAST (row, MUSIC_TYPE_TRACK_ROW, MusicTrackRow));
	_tmp2_ = _tmp1_;
	music_playback_manager_set_current_audio (_tmp0_, _tmp2_);
}

static void
__music_main_window___lambda26__gtk_list_box_row_activated (GtkListBox* _sender,
                                                            GtkListBoxRow* row,
                                                            gpointer self)
{
	_music_main_window___lambda26_ (self, row);
}

static GObject *
music_main_window_constructor (GType type,
                               guint n_construct_properties,
                               GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	MusicMainWindow * self;
	Block3Data* _data3_;
	MusicPlaybackManager* _tmp0_;
	MusicPlaybackManager* _tmp1_;
	GtkWindowControls* start_window_controls = NULL;
	GtkWindowControls* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	GtkButton* _tmp5_ = NULL;
	GtkButton* _tmp6_;
	GtkHeaderBar* queue_header = NULL;
	GtkLabel* _tmp7_;
	GtkHeaderBar* _tmp8_ = NULL;
	GtkHeaderBar* _tmp9_;
	GtkHeaderBar* _tmp10_;
	GtkWindowControls* _tmp11_;
	GtkHeaderBar* _tmp12_;
	GtkButton* _tmp13_;
	GtkHeaderBar* _tmp14_;
	GtkButton* _tmp15_;
	GranitePlaceholder* queue_placeholder = NULL;
	gchar* _tmp16_;
	GThemedIcon* _tmp17_;
	GranitePlaceholder* _tmp18_ = NULL;
	GtkListBox* queue_listbox = NULL;
	GtkListBox* _tmp19_ = NULL;
	GtkListBox* _tmp20_;
	MusicPlaybackManager* _tmp21_;
	GListStore* _tmp22_;
	GListStore* _tmp23_;
	GtkListBox* _tmp24_;
	GranitePlaceholder* _tmp25_;
	GtkScrolledWindow* scrolled = NULL;
	GtkListBox* _tmp26_;
	GtkWidget* _tmp27_;
	GtkScrolledWindow* _tmp28_ = NULL;
	GtkDropTarget* drop_target = NULL;
	GtkDropTarget* _tmp29_;
	GtkLabel* add_button_label = NULL;
	GtkLabel* _tmp30_;
	GtkBox* add_button_box = NULL;
	GtkBox* _tmp31_;
	GtkBox* _tmp32_;
	GtkImage* _tmp33_;
	GtkImage* _tmp34_;
	GtkBox* _tmp35_;
	GtkLabel* _tmp36_;
	GtkButton* add_button = NULL;
	GtkBox* _tmp37_;
	GtkWidget* _tmp38_;
	GtkButton* _tmp39_ = NULL;
	GtkButton* _tmp40_;
	GtkLabel* _tmp41_;
	GtkButton* _tmp42_;
	GtkActionBar* queue_action_bar = NULL;
	GtkActionBar* _tmp43_;
	GtkActionBar* _tmp44_;
	GtkButton* _tmp45_;
	AdwToolbarView* queue = NULL;
	GtkScrolledWindow* _tmp46_;
	GtkWidget* _tmp47_;
	AdwToolbarView* _tmp48_ = NULL;
	AdwToolbarView* _tmp49_;
	GtkDropTarget* _tmp50_;
	GtkEventController* _tmp51_;
	AdwToolbarView* _tmp52_;
	AdwToolbarView* _tmp53_;
	GtkHeaderBar* _tmp54_;
	AdwToolbarView* _tmp55_;
	GtkActionBar* _tmp56_;
	GraniteToast* _tmp57_;
	GtkOverlay* queue_overlay = NULL;
	AdwToolbarView* _tmp58_;
	GtkWidget* _tmp59_;
	GtkOverlay* _tmp60_ = NULL;
	GtkOverlay* _tmp61_;
	GraniteToast* _tmp62_;
	GtkWindowHandle* queue_handle = NULL;
	GtkOverlay* _tmp63_;
	GtkWidget* _tmp64_;
	GtkWindowHandle* _tmp65_ = NULL;
	GtkWindowControls* end_window_controls = NULL;
	GtkWindowControls* _tmp66_;
	GtkHeaderBar* end_header = NULL;
	GtkLabel* _tmp67_;
	GtkHeaderBar* _tmp68_ = NULL;
	GtkHeaderBar* _tmp69_;
	GtkHeaderBar* _tmp70_;
	GtkHeaderBar* _tmp71_;
	GtkWindowControls* _tmp72_;
	MusicNowPlayingView* now_playing_view = NULL;
	MusicNowPlayingView* _tmp73_ = NULL;
	GtkBox* now_playing = NULL;
	GtkBox* _tmp74_;
	GtkBox* _tmp75_;
	GtkHeaderBar* _tmp76_;
	GtkBox* _tmp77_;
	MusicNowPlayingView* _tmp78_;
	GtkWindowHandle* now_playing_handle = NULL;
	GtkBox* _tmp79_;
	GtkWidget* _tmp80_;
	GtkWindowHandle* _tmp81_ = NULL;
	GtkPaned* paned = NULL;
	GtkWindowHandle* _tmp82_;
	GtkWidget* _tmp83_;
	GtkWindowHandle* _tmp84_;
	GtkWidget* _tmp85_;
	GtkPaned* _tmp86_ = NULL;
	GtkPaned* _tmp87_;
	GtkGrid* null_title = NULL;
	GtkGrid* _tmp88_ = NULL;
	GtkGrid* _tmp89_;
	GSettings* _tmp90_;
	GSettings* _tmp91_;
	GtkPaned* _tmp92_;
	GSettings* _tmp93_;
	GtkDropTarget* _tmp94_;
	MusicPlaybackManager* _tmp95_;
	GtkButton* _tmp96_;
	GtkButton* _tmp97_;
	GtkListBox* _tmp98_;
	parent_class = G_OBJECT_CLASS (music_main_window_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, MUSIC_TYPE_MAIN_WINDOW, MusicMainWindow);
	_data3_ = g_slice_new0 (Block3Data);
	_data3_->_ref_count_ = 1;
	_data3_->self = g_object_ref (self);
	_tmp0_ = music_playback_manager_get_default ();
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_data3_->playback_manager = _tmp1_;
	_tmp2_ = (GtkWindowControls*) gtk_window_controls_new (GTK_PACK_START);
	g_object_ref_sink (_tmp2_);
	start_window_controls = _tmp2_;
	_tmp3_ = g_strdup (MUSIC_APPLICATION_ACTION_PREFIX MUSIC_APPLICATION_ACTION_SHUFFLE);
	_tmp4_ = g_strdup (_ ("Shuffle"));
	_tmp5_ = (GtkButton*) gtk_button_new_from_icon_name ("media-playlist-shuffle-symbolic");
	gtk_actionable_set_action_name ((GtkActionable*) _tmp5_, _tmp3_);
	_g_free0 (_tmp3_);
	gtk_widget_set_tooltip_text ((GtkWidget*) _tmp5_, _tmp4_);
	_g_free0 (_tmp4_);
	g_object_ref_sink (_tmp5_);
	_g_object_unref0 (self->priv->shuffle_button);
	self->priv->shuffle_button = _tmp5_;
	_tmp6_ = (GtkButton*) gtk_button_new ();
	g_object_ref_sink (_tmp6_);
	_g_object_unref0 (self->priv->repeat_button);
	self->priv->repeat_button = _tmp6_;
	_tmp7_ = (GtkLabel*) gtk_label_new ("");
	g_object_ref_sink (_tmp7_);
	_tmp8_ = (GtkHeaderBar*) gtk_header_bar_new ();
	gtk_header_bar_set_show_title_buttons (_tmp8_, FALSE);
	gtk_header_bar_set_title_widget (_tmp8_, (GtkWidget*) _tmp7_);
	_g_object_unref0 (_tmp7_);
	g_object_ref_sink (_tmp8_);
	queue_header = _tmp8_;
	_tmp9_ = queue_header;
	gtk_widget_add_css_class ((GtkWidget*) _tmp9_, GRANITE_STYLE_CLASS_DEFAULT_DECORATION);
	_tmp10_ = queue_header;
	_tmp11_ = start_window_controls;
	gtk_header_bar_pack_start (_tmp10_, (GtkWidget*) _tmp11_);
	_tmp12_ = queue_header;
	_tmp13_ = self->priv->shuffle_button;
	gtk_header_bar_pack_end (_tmp12_, (GtkWidget*) _tmp13_);
	_tmp14_ = queue_header;
	_tmp15_ = self->priv->repeat_button;
	gtk_header_bar_pack_end (_tmp14_, (GtkWidget*) _tmp15_);
	_tmp16_ = g_strdup (_ ("Audio files opened from Files will appear here"));
	_tmp17_ = (GThemedIcon*) g_themed_icon_new ("playlist-queue");
	_tmp18_ = granite_placeholder_new (_ ("Queue is Empty"));
	granite_placeholder_set_description (_tmp18_, _tmp16_);
	_g_free0 (_tmp16_);
	granite_placeholder_set_icon (_tmp18_, (GIcon*) _tmp17_);
	_g_object_unref0 (_tmp17_);
	g_object_ref_sink (_tmp18_);
	queue_placeholder = _tmp18_;
	_tmp19_ = (GtkListBox*) gtk_list_box_new ();
	gtk_widget_set_hexpand ((GtkWidget*) _tmp19_, TRUE);
	gtk_widget_set_vexpand ((GtkWidget*) _tmp19_, TRUE);
	g_object_ref_sink (_tmp19_);
	queue_listbox = _tmp19_;
	_tmp20_ = queue_listbox;
	_tmp21_ = _data3_->playback_manager;
	_tmp22_ = music_playback_manager_get_queue_liststore (_tmp21_);
	_tmp23_ = _tmp22_;
	gtk_list_box_bind_model (_tmp20_, (GListModel*) _tmp23_, _music_main_window_create_queue_row_gtk_list_box_create_widget_func, g_object_ref (self), g_object_unref);
	_tmp24_ = queue_listbox;
	_tmp25_ = queue_placeholder;
	gtk_list_box_set_placeholder (_tmp24_, (GtkWidget*) _tmp25_);
	_tmp26_ = queue_listbox;
	_tmp27_ = _g_object_ref0 ((GtkWidget*) _tmp26_);
	_tmp28_ = (GtkScrolledWindow*) gtk_scrolled_window_new ();
	gtk_scrolled_window_set_child (_tmp28_, _tmp27_);
	_g_object_unref0 (_tmp27_);
	g_object_ref_sink (_tmp28_);
	scrolled = _tmp28_;
	_tmp29_ = gtk_drop_target_new (gdk_file_list_get_type (), GDK_ACTION_COPY);
	drop_target = _tmp29_;
	_tmp30_ = (GtkLabel*) gtk_label_new (_ ("Open Files…"));
	g_object_ref_sink (_tmp30_);
	add_button_label = _tmp30_;
	_tmp31_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 0);
	g_object_ref_sink (_tmp31_);
	add_button_box = _tmp31_;
	_tmp32_ = add_button_box;
	_tmp33_ = (GtkImage*) gtk_image_new_from_icon_name ("document-open-symbolic");
	g_object_ref_sink (_tmp33_);
	_tmp34_ = _tmp33_;
	gtk_box_append (_tmp32_, (GtkWidget*) _tmp34_);
	_g_object_unref0 (_tmp34_);
	_tmp35_ = add_button_box;
	_tmp36_ = add_button_label;
	gtk_box_append (_tmp35_, (GtkWidget*) _tmp36_);
	_tmp37_ = add_button_box;
	_tmp38_ = _g_object_ref0 ((GtkWidget*) _tmp37_);
	_tmp39_ = (GtkButton*) gtk_button_new ();
	gtk_button_set_child (_tmp39_, _tmp38_);
	_g_object_unref0 (_tmp38_);
	g_object_ref_sink (_tmp39_);
	add_button = _tmp39_;
	_tmp40_ = add_button;
	gtk_widget_add_css_class ((GtkWidget*) _tmp40_, GRANITE_STYLE_CLASS_FLAT);
	_tmp41_ = add_button_label;
	_tmp42_ = add_button;
	gtk_label_set_mnemonic_widget (_tmp41_, (GtkWidget*) _tmp42_);
	_tmp43_ = (GtkActionBar*) gtk_action_bar_new ();
	g_object_ref_sink (_tmp43_);
	queue_action_bar = _tmp43_;
	_tmp44_ = queue_action_bar;
	_tmp45_ = add_button;
	gtk_action_bar_pack_start (_tmp44_, (GtkWidget*) _tmp45_);
	_tmp46_ = scrolled;
	_tmp47_ = _g_object_ref0 ((GtkWidget*) _tmp46_);
	_tmp48_ = (AdwToolbarView*) adw_toolbar_view_new ();
	adw_toolbar_view_set_bottom_bar_style (_tmp48_, ADW_TOOLBAR_RAISED);
	adw_toolbar_view_set_content (_tmp48_, _tmp47_);
	_g_object_unref0 (_tmp47_);
	g_object_ref_sink (_tmp48_);
	queue = _tmp48_;
	_tmp49_ = queue;
	_tmp50_ = drop_target;
	_tmp51_ = _g_object_ref0 ((GtkEventController*) _tmp50_);
	gtk_widget_add_controller ((GtkWidget*) _tmp49_, _tmp51_);
	_tmp52_ = queue;
	gtk_widget_add_css_class ((GtkWidget*) _tmp52_, GRANITE_STYLE_CLASS_VIEW);
	_tmp53_ = queue;
	_tmp54_ = queue_header;
	adw_toolbar_view_add_top_bar (_tmp53_, (GtkWidget*) _tmp54_);
	_tmp55_ = queue;
	_tmp56_ = queue_action_bar;
	adw_toolbar_view_add_bottom_bar (_tmp55_, (GtkWidget*) _tmp56_);
	_tmp57_ = granite_toast_new ("");
	g_object_ref_sink (_tmp57_);
	_data3_->error_toast = _tmp57_;
	_tmp58_ = queue;
	_tmp59_ = _g_object_ref0 ((GtkWidget*) _tmp58_);
	_tmp60_ = (GtkOverlay*) gtk_overlay_new ();
	gtk_overlay_set_child (_tmp60_, _tmp59_);
	_g_object_unref0 (_tmp59_);
	g_object_ref_sink (_tmp60_);
	queue_overlay = _tmp60_;
	_tmp61_ = queue_overlay;
	_tmp62_ = _data3_->error_toast;
	gtk_overlay_add_overlay (_tmp61_, (GtkWidget*) _tmp62_);
	_tmp63_ = queue_overlay;
	_tmp64_ = _g_object_ref0 ((GtkWidget*) _tmp63_);
	_tmp65_ = (GtkWindowHandle*) gtk_window_handle_new ();
	gtk_window_handle_set_child (_tmp65_, _tmp64_);
	_g_object_unref0 (_tmp64_);
	g_object_ref_sink (_tmp65_);
	queue_handle = _tmp65_;
	_tmp66_ = (GtkWindowControls*) gtk_window_controls_new (GTK_PACK_END);
	g_object_ref_sink (_tmp66_);
	end_window_controls = _tmp66_;
	_tmp67_ = (GtkLabel*) gtk_label_new ("");
	g_object_ref_sink (_tmp67_);
	_tmp68_ = (GtkHeaderBar*) gtk_header_bar_new ();
	gtk_header_bar_set_show_title_buttons (_tmp68_, FALSE);
	gtk_header_bar_set_title_widget (_tmp68_, (GtkWidget*) _tmp67_);
	_g_object_unref0 (_tmp67_);
	g_object_ref_sink (_tmp68_);
	end_header = _tmp68_;
	_tmp69_ = end_header;
	gtk_widget_add_css_class ((GtkWidget*) _tmp69_, GRANITE_STYLE_CLASS_FLAT);
	_tmp70_ = end_header;
	gtk_widget_add_css_class ((GtkWidget*) _tmp70_, GRANITE_STYLE_CLASS_DEFAULT_DECORATION);
	_tmp71_ = end_header;
	_tmp72_ = end_window_controls;
	gtk_header_bar_pack_end (_tmp71_, (GtkWidget*) _tmp72_);
	_tmp73_ = music_now_playing_view_new ();
	gtk_widget_set_margin_top ((GtkWidget*) _tmp73_, 12);
	gtk_widget_set_margin_end ((GtkWidget*) _tmp73_, 12);
	gtk_widget_set_margin_bottom ((GtkWidget*) _tmp73_, 24);
	gtk_widget_set_margin_start ((GtkWidget*) _tmp73_, 12);
	gtk_widget_set_vexpand ((GtkWidget*) _tmp73_, TRUE);
	g_object_ref_sink (_tmp73_);
	now_playing_view = _tmp73_;
	_tmp74_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 0);
	g_object_ref_sink (_tmp74_);
	now_playing = _tmp74_;
	_tmp75_ = now_playing;
	_tmp76_ = end_header;
	gtk_box_append (_tmp75_, (GtkWidget*) _tmp76_);
	_tmp77_ = now_playing;
	_tmp78_ = now_playing_view;
	gtk_box_append (_tmp77_, (GtkWidget*) _tmp78_);
	_tmp79_ = now_playing;
	_tmp80_ = _g_object_ref0 ((GtkWidget*) _tmp79_);
	_tmp81_ = (GtkWindowHandle*) gtk_window_handle_new ();
	gtk_window_handle_set_child (_tmp81_, _tmp80_);
	_g_object_unref0 (_tmp80_);
	g_object_ref_sink (_tmp81_);
	now_playing_handle = _tmp81_;
	_tmp82_ = queue_handle;
	_tmp83_ = _g_object_ref0 ((GtkWidget*) _tmp82_);
	_tmp84_ = now_playing_handle;
	_tmp85_ = _g_object_ref0 ((GtkWidget*) _tmp84_);
	_tmp86_ = (GtkPaned*) gtk_paned_new (GTK_ORIENTATION_HORIZONTAL);
	gtk_paned_set_start_child (_tmp86_, _tmp83_);
	_g_object_unref0 (_tmp83_);
	gtk_paned_set_end_child (_tmp86_, _tmp85_);
	_g_object_unref0 (_tmp85_);
	gtk_paned_set_resize_end_child (_tmp86_, FALSE);
	gtk_paned_set_shrink_end_child (_tmp86_, FALSE);
	gtk_paned_set_shrink_start_child (_tmp86_, FALSE);
	g_object_ref_sink (_tmp86_);
	paned = _tmp86_;
	_tmp87_ = paned;
	gtk_window_set_child ((GtkWindow*) self, (GtkWidget*) _tmp87_);
	_tmp88_ = (GtkGrid*) gtk_grid_new ();
	gtk_widget_set_visible ((GtkWidget*) _tmp88_, FALSE);
	g_object_ref_sink (_tmp88_);
	null_title = _tmp88_;
	_tmp89_ = null_title;
	gtk_window_set_titlebar ((GtkWindow*) self, (GtkWidget*) _tmp89_);
	_tmp90_ = g_settings_new ("io.elementary.music");
	_g_object_unref0 (self->priv->settings);
	self->priv->settings = _tmp90_;
	_tmp91_ = self->priv->settings;
	_tmp92_ = paned;
	g_settings_bind (_tmp91_, "pane-position", (GObject*) _tmp92_, "position", G_SETTINGS_BIND_DEFAULT);
	_tmp93_ = self->priv->settings;
	g_signal_connect_object (_tmp93_, "changed::repeat-mode", (GCallback) _music_main_window_update_repeat_button_g_settings_changed, self, 0);
	music_main_window_update_repeat_button (self);
	_tmp94_ = drop_target;
	g_signal_connect_object (_tmp94_, "drop", (GCallback) __music_main_window___lambda23__gtk_drop_target_drop, self, 0);
	_tmp95_ = _data3_->playback_manager;
	g_signal_connect_data (_tmp95_, "invalids-found", (GCallback) __music_main_window___lambda24__music_playback_manager_invalids_found, block3_data_ref (_data3_), (GClosureNotify) block3_data_unref, 0);
	_tmp96_ = add_button;
	g_signal_connect_object (_tmp96_, "clicked", (GCallback) _music_main_window_action_open_gtk_button_clicked, self, 0);
	_tmp97_ = self->priv->repeat_button;
	g_signal_connect_object (_tmp97_, "clicked", (GCallback) __music_main_window___lambda25__gtk_button_clicked, self, 0);
	_tmp98_ = queue_listbox;
	g_signal_connect_data (_tmp98_, "row-activated", (GCallback) __music_main_window___lambda26__gtk_list_box_row_activated, block3_data_ref (_data3_), (GClosureNotify) block3_data_unref, 0);
	_g_object_unref0 (null_title);
	_g_object_unref0 (paned);
	_g_object_unref0 (now_playing_handle);
	_g_object_unref0 (now_playing);
	_g_object_unref0 (now_playing_view);
	_g_object_unref0 (end_header);
	_g_object_unref0 (end_window_controls);
	_g_object_unref0 (queue_handle);
	_g_object_unref0 (queue_overlay);
	_g_object_unref0 (queue);
	_g_object_unref0 (queue_action_bar);
	_g_object_unref0 (add_button);
	_g_object_unref0 (add_button_box);
	_g_object_unref0 (add_button_label);
	_g_object_unref0 (drop_target);
	_g_object_unref0 (scrolled);
	_g_object_unref0 (queue_listbox);
	_g_object_unref0 (queue_placeholder);
	_g_object_unref0 (queue_header);
	_g_object_unref0 (start_window_controls);
	block3_data_unref (_data3_);
	_data3_ = NULL;
	return obj;
}

static void
music_main_window_class_init (MusicMainWindowClass * klass,
                              gpointer klass_data)
{
	music_main_window_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &MusicMainWindow_private_offset);
	G_OBJECT_CLASS (klass)->constructor = music_main_window_constructor;
	G_OBJECT_CLASS (klass)->finalize = music_main_window_finalize;
}

static void
music_main_window_instance_init (MusicMainWindow * self,
                                 gpointer klass)
{
	self->priv = music_main_window_get_instance_private (self);
}

static void
music_main_window_finalize (GObject * obj)
{
	MusicMainWindow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, MUSIC_TYPE_MAIN_WINDOW, MusicMainWindow);
	_g_object_unref0 (self->priv->repeat_button);
	_g_object_unref0 (self->priv->shuffle_button);
	_g_object_unref0 (self->priv->settings);
	G_OBJECT_CLASS (music_main_window_parent_class)->finalize (obj);
}

static GType
music_main_window_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (MusicMainWindowClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) music_main_window_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (MusicMainWindow), 0, (GInstanceInitFunc) music_main_window_instance_init, NULL };
	GType music_main_window_type_id;
	music_main_window_type_id = g_type_register_static (gtk_application_window_get_type (), "MusicMainWindow", &g_define_type_info, 0);
	MusicMainWindow_private_offset = g_type_add_instance_private (music_main_window_type_id, sizeof (MusicMainWindowPrivate));
	return music_main_window_type_id;
}

GType
music_main_window_get_type (void)
{
	static volatile gsize music_main_window_type_id__once = 0;
	if (g_once_init_enter (&music_main_window_type_id__once)) {
		GType music_main_window_type_id;
		music_main_window_type_id = music_main_window_get_type_once ();
		g_once_init_leave (&music_main_window_type_id__once, music_main_window_type_id);
	}
	return music_main_window_type_id__once;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

