/* Application.c generated by valac 0.56.18, the Vala compiler
 * generated from Application.vala, do not modify */

/*
* Copyright (c) 2010-2013 Yorba Foundation
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU Lesser General Public
* License as published by the Free Software Foundation; either
* version 2.1 of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* General Public License for more details.
*
* You should have received a copy of the GNU General Public
* License along with this program; if not, write to the
* Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
* Boston, MA 02110-1301 USA
*/

#include "io.elementary.photos.h"
#include <glib.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <gtk/gtk.h>
#include <stdlib.h>
#include <string.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	PHOTOS_APPLICATION_0_PROPERTY,
	PHOTOS_APPLICATION_NUM_PROPERTIES
};
static GParamSpec* photos_application_properties[PHOTOS_APPLICATION_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
enum  {
	PHOTOS_APPLICATION_STARTING_SIGNAL,
	PHOTOS_APPLICATION_EXITING_SIGNAL,
	PHOTOS_APPLICATION_INIT_DONE_SIGNAL,
	PHOTOS_APPLICATION_NUM_SIGNALS
};
static guint photos_application_signals[PHOTOS_APPLICATION_NUM_SIGNALS] = {0};
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _PhotosApplicationPrivate {
	gint system_app_run_retval;
	gboolean direct;
	gboolean fixup_raw_thumbs;
	gboolean running;
	gboolean exiting_fired;
};

static gint PhotosApplication_private_offset;
static gpointer photos_application_parent_class = NULL;
static PhotosApplication* photos_application_instance;
static PhotosApplication* photos_application_instance = NULL;

static PhotosApplication* photos_application_new (gboolean is_direct);
static PhotosApplication* photos_application_construct (GType object_type,
                                                 gboolean is_direct);
static gint photos_application_on_command_line (GApplicationCommandLine* acl);
static gint _photos_application_on_command_line_g_application_command_line (GApplication* _sender,
                                                                     GApplicationCommandLine* command_line,
                                                                     gpointer self);
static void photos_application_on_activated (void);
static void _photos_application_on_activated_g_application_activate (GApplication* _sender,
                                                              gpointer self);
static void _photos_application_on_activated_g_application_startup (GApplication* _sender,
                                                             gpointer self);
static void photos_application_real_starting (PhotosApplication* self);
static void photos_application_real_exiting (PhotosApplication* self,
                                      gboolean panicked);
static void photos_application_real_init_done (PhotosApplication* self);
static GObject * photos_application_constructor (GType type,
                                          guint n_construct_properties,
                                          GObjectConstructParam * construct_properties);
static void photos_application_finalize (GObject * obj);
static GType photos_application_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

static inline gpointer
photos_application_get_instance_private (PhotosApplication* self)
{
	return G_STRUCT_MEMBER_P (self, PhotosApplication_private_offset);
}

void
photos_application_set_raw_thumbs_fix_required (PhotosApplication* self,
                                                gboolean should_fixup)
{
	g_return_if_fail (self != NULL);
	self->priv->fixup_raw_thumbs = should_fixup;
}

gboolean
photos_application_get_raw_thumbs_fix_required (PhotosApplication* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->fixup_raw_thumbs;
	return result;
}

static gint
_photos_application_on_command_line_g_application_command_line (GApplication* _sender,
                                                                GApplicationCommandLine* command_line,
                                                                gpointer self)
{
	gint result;
	result = photos_application_on_command_line (command_line);
	return result;
}

static void
_photos_application_on_activated_g_application_activate (GApplication* _sender,
                                                         gpointer self)
{
	photos_application_on_activated ();
}

static void
_photos_application_on_activated_g_application_startup (GApplication* _sender,
                                                        gpointer self)
{
	photos_application_on_activated ();
}

static PhotosApplication*
photos_application_construct (GType object_type,
                              gboolean is_direct)
{
	PhotosApplication * self = NULL;
	GtkSettings* _tmp0_;
	GError* _inner_error0_ = NULL;
	self = (PhotosApplication*) g_object_new (object_type, NULL);
	if (is_direct) {
		g_application_set_application_id ((GApplication*) self, "io.elementary.photos-direct");
		g_application_set_flags ((GApplication*) self, G_APPLICATION_HANDLES_OPEN | G_APPLICATION_NON_UNIQUE);
	} else {
		g_application_set_application_id ((GApplication*) self, "io.elementary.photos");
		g_application_set_flags ((GApplication*) self, G_APPLICATION_HANDLES_OPEN | G_APPLICATION_HANDLES_COMMAND_LINE);
	}
	{
		g_application_register ((GApplication*) self, NULL, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		g_clear_error (&_inner_error0_);
		photos_application_panic (self);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	self->priv->direct = is_direct;
	if (!self->priv->direct) {
		g_signal_connect ((GApplication*) self, "command-line", (GCallback) _photos_application_on_command_line_g_application_command_line, NULL);
	}
	_tmp0_ = gtk_settings_get_default ();
	g_object_set (_tmp0_, "gtk-application-prefer-dark-theme", TRUE, NULL);
	g_signal_connect ((GApplication*) self, "activate", (GCallback) _photos_application_on_activated_g_application_activate, NULL);
	g_signal_connect ((GApplication*) self, "startup", (GCallback) _photos_application_on_activated_g_application_startup, NULL);
	return self;
}

static PhotosApplication*
photos_application_new (gboolean is_direct)
{
	return photos_application_construct (PHOTOS_TYPE_APPLICATION, is_direct);
}

/**
     * This is a helper for library mode that should only be
     * called if we've gotten a camera mount and are _not_ the primary
     * instance.
     */
void
photos_application_send_to_primary_instance (gchar** argv,
                                             gint argv_length1)
{
	GApplication* _tmp0_;
	_tmp0_ = g_application_get_default ();
	g_application_run (_tmp0_, (gint) argv_length1, argv);
}

/**
     * A helper for library mode that tells the primary
     * instance to bring its window to the foreground.  This
     * should only be called if we are _not_ the primary instance.
     */
void
photos_application_present_primary_instance (void)
{
	GApplication* _tmp0_;
	_tmp0_ = g_application_get_default ();
	g_application_activate (_tmp0_);
}

gboolean
photos_application_app_get_is_remote (void)
{
	GApplication* _tmp0_;
	gboolean result;
	_tmp0_ = g_application_get_default ();
	result = g_application_get_is_remote (_tmp0_);
	return result;
}

/**
     * Signal handler for GApplication's 'command-line' signal.
     *
     * The most likely scenario for this to be fired is if the user
     * either tried to run us twice in library mode, or we've just gotten
     * a camera/removeable-storage mount; in either case, the remote instance
     * will trigger this and exit, and we'll need to bring the window back up...
     */
static void
photos_application_on_activated (void)
{
	LibraryWindow* lw = NULL;
	AppWindow* _tmp0_;
	LibraryWindow* _tmp1_;
	gboolean _tmp2_ = FALSE;
	LibraryWindow* _tmp3_;
	_tmp0_ = app_window_get_instance ();
	_tmp1_ = IS_LIBRARY_WINDOW (_tmp0_) ? ((LibraryWindow*) _tmp0_) : NULL;
	if (_tmp1_ == NULL) {
		_g_object_unref0 (_tmp0_);
	}
	lw = _tmp1_;
	_tmp3_ = lw;
	if (_tmp3_ != NULL) {
		GApplication* _tmp4_;
		_tmp4_ = g_application_get_default ();
		_tmp2_ = !G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, PHOTOS_TYPE_APPLICATION, PhotosApplication)->priv->direct;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		LibraryWindow* _tmp5_;
		LibraryWindow* _tmp6_;
		_tmp5_ = library_window_get_app ();
		_tmp6_ = _tmp5_;
		gtk_window_present ((GtkWindow*) _tmp6_);
		_g_object_unref0 (_tmp6_);
	}
	_g_object_unref0 (lw);
}

/**
     * Signal handler for GApplication's 'command-line' signal.
     *
     * Gets fired whenever a remote instance tries to run, usually
     * with an incoming camera connection.
     *
     * Note: This does _not_ get called in direct-edit mode.
     */
static gint
photos_application_on_command_line (GApplicationCommandLine* acl)
{
	gchar** argv = NULL;
	gint _tmp0_ = 0;
	gchar** _tmp1_;
	gint argv_length1;
	gint _argv_size_;
	gchar** _tmp2_;
	gint _tmp2__length1;
	gint result;
	g_return_val_if_fail (acl != NULL, 0);
	_tmp1_ = g_application_command_line_get_arguments (acl, &_tmp0_);
	argv = _tmp1_;
	argv_length1 = _tmp0_;
	_argv_size_ = argv_length1;
	_tmp2_ = argv;
	_tmp2__length1 = argv_length1;
	if (_tmp2_ != NULL) {
		gchar** _tmp3_;
		gint _tmp3__length1;
		_tmp3_ = argv;
		_tmp3__length1 = argv_length1;
		{
			gchar** s_collection = NULL;
			gint s_collection_length1 = 0;
			gint _s_collection_size_ = 0;
			gint s_it = 0;
			s_collection = _tmp3_;
			s_collection_length1 = _tmp3__length1;
			for (s_it = 0; s_it < s_collection_length1; s_it = s_it + 1) {
				gchar* _tmp4_;
				gchar* s = NULL;
				_tmp4_ = g_strdup (s_collection[s_it]);
				s = _tmp4_;
				{
					LibraryWindow* lw = NULL;
					AppWindow* _tmp5_;
					LibraryWindow* _tmp6_;
					LibraryWindow* _tmp7_;
					_tmp5_ = app_window_get_instance ();
					_tmp6_ = IS_LIBRARY_WINDOW (_tmp5_) ? ((LibraryWindow*) _tmp5_) : NULL;
					if (_tmp6_ == NULL) {
						_g_object_unref0 (_tmp5_);
					}
					lw = _tmp6_;
					_tmp7_ = lw;
					if (_tmp7_ != NULL) {
						LibraryWindow* _tmp8_;
						const gchar* _tmp9_;
						_tmp8_ = lw;
						_tmp9_ = s;
						library_window_mounted_camera_shell_notification (_tmp8_, _tmp9_, FALSE);
					}
					_g_object_unref0 (lw);
					_g_free0 (s);
				}
			}
		}
	}
	photos_application_on_activated ();
	result = 0;
	argv = (_vala_array_free (argv, argv_length1, (GDestroyNotify) g_free), NULL);
	return result;
}

/**
     * Initializes the Photos application object and prepares
     * it for use.
     *
     * Note: This MUST be called prior to calling get_instance (), as the
     * application needs to know what mode it was brought up in; failure to
     * call this first will lead to an assertion.
     *
     * @param is_direct Whether the application was invoked in direct
     * or in library mode; defaults to FALSE, that is, library mode.
     */
void
photos_application_init (gboolean is_direct)
{
	PhotosApplication* _tmp0_;
	_tmp0_ = photos_application_instance;
	if (_tmp0_ == NULL) {
		PhotosApplication* _tmp1_;
		_tmp1_ = photos_application_new (is_direct);
		_g_object_unref0 (photos_application_instance);
		photos_application_instance = _tmp1_;
	}
}

void
photos_application_terminate (void)
{
	GApplication* _tmp0_;
	_tmp0_ = g_application_get_default ();
	photos_application_exit (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, PHOTOS_TYPE_APPLICATION, PhotosApplication));
}

void
photos_application_start (PhotosApplication* self,
                          gchar** argv,
                          gint argv_length1)
{
	AppWindow* _tmp0_;
	AppWindow* _tmp1_;
	AppWindow* _tmp2_;
	AppWindow* _tmp3_;
	guint _tmp5_;
	guint _tmp6_;
	g_return_if_fail (self != NULL);
	if (self->priv->running) {
		return;
	}
	self->priv->running = TRUE;
	g_signal_emit (self, photos_application_signals[PHOTOS_APPLICATION_STARTING_SIGNAL], 0);
	_tmp0_ = app_window_get_instance ();
	_tmp1_ = _tmp0_;
	_vala_assert (_tmp1_ != NULL, "AppWindow.get_instance () != null");
	_g_object_unref0 (_tmp1_);
	_tmp2_ = app_window_get_instance ();
	_tmp3_ = _tmp2_;
	gtk_application_add_window ((GtkApplication*) self, (GtkWindow*) _tmp3_);
	_g_object_unref0 (_tmp3_);
	self->priv->system_app_run_retval = g_application_run ((GApplication*) self, (gint) argv_length1, argv);
	if (!self->priv->direct) {
		guint _tmp4_;
		g_signal_parse_name ("command-line", g_application_get_type (), &_tmp4_, NULL, FALSE);
		g_signal_handlers_disconnect_matched ((GApplication*) self, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp4_, 0, NULL, (GCallback) _photos_application_on_command_line_g_application_command_line, NULL);
	}
	g_signal_parse_name ("activate", g_application_get_type (), &_tmp5_, NULL, FALSE);
	g_signal_handlers_disconnect_matched ((GApplication*) self, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp5_, 0, NULL, (GCallback) _photos_application_on_activated_g_application_activate, NULL);
	g_signal_parse_name ("startup", g_application_get_type (), &_tmp6_, NULL, FALSE);
	g_signal_handlers_disconnect_matched ((GApplication*) self, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp6_, 0, NULL, (GCallback) _photos_application_on_activated_g_application_startup, NULL);
	self->priv->running = FALSE;
}

void
photos_application_exit (PhotosApplication* self)
{
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	if (self->priv->exiting_fired) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = !self->priv->running;
	}
	if (_tmp0_) {
		return;
	}
	self->priv->exiting_fired = TRUE;
	g_signal_emit (self, photos_application_signals[PHOTOS_APPLICATION_EXITING_SIGNAL], 0, FALSE);
	g_application_release ((GApplication*) self);
}

void
photos_application_panic (PhotosApplication* self)
{
	g_return_if_fail (self != NULL);
	if (!self->priv->exiting_fired) {
		self->priv->exiting_fired = TRUE;
		g_signal_emit (self, photos_application_signals[PHOTOS_APPLICATION_EXITING_SIGNAL], 0, TRUE);
	}
	exit (1);
}

/**
     * Allows the caller to ask for some part of the desktop session's functionality to
     * be prevented from running; wrapper for Gtk.Application.inhibit ().
     *
     * Note: The return value is a 'cookie' that needs to be passed to 'uninhibit' to turn
     * off a requested inhibition and should be saved by the caller.
     */
guint
photos_application_app_inhibit (PhotosApplication* self,
                                GtkApplicationInhibitFlags what,
                                const gchar* reason)
{
	AppWindow* _tmp0_;
	AppWindow* _tmp1_;
	guint _tmp2_;
	guint result;
	g_return_val_if_fail (self != NULL, 0U);
	_tmp0_ = app_window_get_instance ();
	_tmp1_ = _tmp0_;
	_tmp2_ = gtk_application_inhibit ((GtkApplication*) self, (GtkWindow*) _tmp1_, what, reason);
	_g_object_unref0 (_tmp1_);
	result = _tmp2_;
	return result;
}

static void
photos_application_real_starting (PhotosApplication* self)
{
}

static void
photos_application_real_exiting (PhotosApplication* self,
                                 gboolean panicked)
{
}

static void
photos_application_real_init_done (PhotosApplication* self)
{
}

static GObject *
photos_application_constructor (GType type,
                                guint n_construct_properties,
                                GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	PhotosApplication * self;
	GtkIconTheme* default_theme = NULL;
	GtkIconTheme* _tmp0_;
	GtkIconTheme* _tmp1_;
	parent_class = G_OBJECT_CLASS (photos_application_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, PHOTOS_TYPE_APPLICATION, PhotosApplication);
	_tmp0_ = gtk_icon_theme_get_default ();
	default_theme = _tmp0_;
	_tmp1_ = default_theme;
	gtk_icon_theme_add_resource_path (_tmp1_, "/io/elementary/photos/icons");
	return obj;
}

static void
photos_application_class_init (PhotosApplicationClass * klass,
                               gpointer klass_data)
{
	photos_application_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &PhotosApplication_private_offset);
	((PhotosApplicationClass *) klass)->starting = photos_application_real_starting;
	((PhotosApplicationClass *) klass)->exiting = photos_application_real_exiting;
	((PhotosApplicationClass *) klass)->init_done = photos_application_real_init_done;
	G_OBJECT_CLASS (klass)->constructor = photos_application_constructor;
	G_OBJECT_CLASS (klass)->finalize = photos_application_finalize;
	photos_application_signals[PHOTOS_APPLICATION_STARTING_SIGNAL] = g_signal_new ("starting", PHOTOS_TYPE_APPLICATION, G_SIGNAL_RUN_LAST, G_STRUCT_OFFSET (PhotosApplicationClass, starting), NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	photos_application_signals[PHOTOS_APPLICATION_EXITING_SIGNAL] = g_signal_new ("exiting", PHOTOS_TYPE_APPLICATION, G_SIGNAL_RUN_LAST, G_STRUCT_OFFSET (PhotosApplicationClass, exiting), NULL, NULL, g_cclosure_marshal_VOID__BOOLEAN, G_TYPE_NONE, 1, G_TYPE_BOOLEAN);
	photos_application_signals[PHOTOS_APPLICATION_INIT_DONE_SIGNAL] = g_signal_new ("init-done", PHOTOS_TYPE_APPLICATION, G_SIGNAL_RUN_LAST, G_STRUCT_OFFSET (PhotosApplicationClass, init_done), NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}

static void
photos_application_instance_init (PhotosApplication * self,
                                  gpointer klass)
{
	self->priv = photos_application_get_instance_private (self);
	self->priv->system_app_run_retval = 0;
	self->priv->fixup_raw_thumbs = FALSE;
	self->priv->running = FALSE;
	self->priv->exiting_fired = FALSE;
}

static void
photos_application_finalize (GObject * obj)
{
	PhotosApplication * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, PHOTOS_TYPE_APPLICATION, PhotosApplication);
	G_OBJECT_CLASS (photos_application_parent_class)->finalize (obj);
}

static GType
photos_application_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (PhotosApplicationClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) photos_application_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PhotosApplication), 0, (GInstanceInitFunc) photos_application_instance_init, NULL };
	GType photos_application_type_id;
	photos_application_type_id = g_type_register_static (gtk_application_get_type (), "PhotosApplication", &g_define_type_info, 0);
	PhotosApplication_private_offset = g_type_add_instance_private (photos_application_type_id, sizeof (PhotosApplicationPrivate));
	return photos_application_type_id;
}

GType
photos_application_get_type (void)
{
	static volatile gsize photos_application_type_id__once = 0;
	if (g_once_init_enter (&photos_application_type_id__once)) {
		GType photos_application_type_id;
		photos_application_type_id = photos_application_get_type_once ();
		g_once_init_leave (&photos_application_type_id__once, photos_application_type_id);
	}
	return photos_application_type_id__once;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

