/* CommandManager.c generated by valac 0.56.18, the Vala compiler
 * generated from CommandManager.vala, do not modify */

/*
* Copyright (c) 2009-2013 Yorba Foundation
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU Lesser General Public
* License as published by the Free Software Foundation; either
* version 2.1 of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* General Public License for more details.
*
* You should have received a copy of the GNU General Public
* License along with this program; if not, write to the
* Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
* Boston, MA 02110-1301 USA
*/
/* Command's overrideable action calls are guaranteed to be called in this order:*/
/**/
/*   * prepare ()*/
/*   * execute () (once and only once)*/
/*   * prepare ()*/
/*   * undo ()*/
/*   * prepare ()*/
/*   * redo ()*/
/*   * prepare ()*/
/*   * undo ()*/
/*   * prepare ()*/
/*   * redo () ...*/
/**/
/* redo ()'s default implementation is to call execute, which in many cases is appropriate.*/

#include "io.elementary.photos.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <glib-object.h>
#include <gee.h>
#include <gobject/gvaluecollector.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	COMMAND_0_PROPERTY,
	COMMAND_NAME_PROPERTY,
	COMMAND_EXPLANATION_PROPERTY,
	COMMAND_NUM_PROPERTIES
};
static GParamSpec* command_properties[COMMAND_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _ParamSpecCommandManager ParamSpecCommandManager;
enum  {
	COMMAND_MANAGER_ALTERED_SIGNAL,
	COMMAND_MANAGER_NUM_SIGNALS
};
static guint command_manager_signals[COMMAND_MANAGER_NUM_SIGNALS] = {0};
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _CommandPrivate {
	gchar* _name;
	gchar* _explanation;
	CommandManager* manager;
};

struct _CommandManagerPrivate {
	gint depth;
	GeeArrayList* undo_stack;
	GeeArrayList* redo_stack;
};

struct _ParamSpecCommandManager {
	GParamSpec parent_instance;
};

static gint Command_private_offset;
static gpointer command_parent_class = NULL;
static gint CommandManager_private_offset;
static gpointer command_manager_parent_class = NULL;

static void command_real_prepare (Command* self);
static void command_real_execute (Command* self);
static void command_real_undo (Command* self);
static void command_real_redo (Command* self);
static gboolean command_real_compress (Command* self,
                                Command* command);
static void command_finalize (GObject * obj);
static GType command_get_type_once (void);
static void _vala_command_get_property (GObject * object,
                                 guint property_id,
                                 GValue * value,
                                 GParamSpec * pspec);
static void _vala_command_set_property (GObject * object,
                                 guint property_id,
                                 const GValue * value,
                                 GParamSpec * pspec);
static Command* command_manager_top (CommandManager* self,
                              GeeArrayList* stack);
static void command_manager_push (CommandManager* self,
                           GeeArrayList* stack,
                           Command* command);
static Command* command_manager_pop (CommandManager* self,
                              GeeArrayList* stack);
static void g_cclosure_user_marshal_VOID__BOOLEAN_BOOLEAN (GClosure * closure,
                                                    GValue * return_value,
                                                    guint n_param_values,
                                                    const GValue * param_values,
                                                    gpointer invocation_hint,
                                                    gpointer marshal_data);
static void command_manager_finalize (CommandManager * obj);
static GType command_manager_get_type_once (void);

static inline gpointer
command_get_instance_private (Command* self)
{
	return G_STRUCT_MEMBER_P (self, Command_private_offset);
}

Command*
command_construct (GType object_type,
                   const gchar* name,
                   const gchar* explanation)
{
	Command * self = NULL;
	g_return_val_if_fail (name != NULL, NULL);
	g_return_val_if_fail (explanation != NULL, NULL);
	self = (Command*) g_object_new (object_type, "name", name, "explanation", explanation, NULL);
	return self;
}

static void
command_real_prepare (Command* self)
{
}

void
command_prepare (Command* self)
{
	CommandClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = COMMAND_GET_CLASS (self);
	if (_klass_->prepare) {
		_klass_->prepare (self);
	}
}

static void
command_real_execute (Command* self)
{
	g_critical ("Type `%s' does not implement abstract method `command_execute'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return;
}

void
command_execute (Command* self)
{
	CommandClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = COMMAND_GET_CLASS (self);
	if (_klass_->execute) {
		_klass_->execute (self);
	}
}

static void
command_real_undo (Command* self)
{
	g_critical ("Type `%s' does not implement abstract method `command_undo'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return;
}

void
command_undo (Command* self)
{
	CommandClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = COMMAND_GET_CLASS (self);
	if (_klass_->undo) {
		_klass_->undo (self);
	}
}

static void
command_real_redo (Command* self)
{
	command_execute (self);
}

void
command_redo (Command* self)
{
	CommandClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = COMMAND_GET_CLASS (self);
	if (_klass_->redo) {
		_klass_->redo (self);
	}
}

static gboolean
command_real_compress (Command* self,
                       Command* command)
{
	gboolean result;
	g_return_val_if_fail (command != NULL, FALSE);
	result = FALSE;
	return result;
}

gboolean
command_compress (Command* self,
                  Command* command)
{
	CommandClass* _klass_;
	g_return_val_if_fail (self != NULL, FALSE);
	_klass_ = COMMAND_GET_CLASS (self);
	if (_klass_->compress) {
		return _klass_->compress (self, command);
	}
	return FALSE;
}

static gpointer
_command_manager_ref0 (gpointer self)
{
	return self ? command_manager_ref (self) : NULL;
}

CommandManager*
command_get_command_manager (Command* self)
{
	CommandManager* _tmp0_;
	CommandManager* _tmp1_;
	CommandManager* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->manager;
	_tmp1_ = _command_manager_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}

void
command_internal_set_command_manager (Command* self,
                                      CommandManager* manager)
{
	CommandManager* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (manager != NULL);
	_tmp0_ = self->priv->manager;
	_vala_assert (_tmp0_ == NULL, "this.manager == null");
	self->priv->manager = manager;
}

const gchar*
command_get_name (Command* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_name;
	result = _tmp0_;
	return result;
}

static void
command_set_name (Command* self,
                  const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = command_get_name (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_name);
		self->priv->_name = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, command_properties[COMMAND_NAME_PROPERTY]);
	}
}

const gchar*
command_get_explanation (Command* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_explanation;
	result = _tmp0_;
	return result;
}

static void
command_set_explanation (Command* self,
                         const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = command_get_explanation (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_explanation);
		self->priv->_explanation = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, command_properties[COMMAND_EXPLANATION_PROPERTY]);
	}
}

static void
command_class_init (CommandClass * klass,
                    gpointer klass_data)
{
	command_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &Command_private_offset);
	((CommandClass *) klass)->prepare = (void (*) (Command*)) command_real_prepare;
	((CommandClass *) klass)->execute = (void (*) (Command*)) command_real_execute;
	((CommandClass *) klass)->undo = (void (*) (Command*)) command_real_undo;
	((CommandClass *) klass)->redo = (void (*) (Command*)) command_real_redo;
	((CommandClass *) klass)->compress = (gboolean (*) (Command*, Command*)) command_real_compress;
	G_OBJECT_CLASS (klass)->get_property = _vala_command_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_command_set_property;
	G_OBJECT_CLASS (klass)->finalize = command_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), COMMAND_NAME_PROPERTY, command_properties[COMMAND_NAME_PROPERTY] = g_param_spec_string ("name", "name", "name", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), COMMAND_EXPLANATION_PROPERTY, command_properties[COMMAND_EXPLANATION_PROPERTY] = g_param_spec_string ("explanation", "explanation", "explanation", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
}

static void
command_instance_init (Command * self,
                       gpointer klass)
{
	self->priv = command_get_instance_private (self);
	self->priv->manager = NULL;
}

static void
command_finalize (GObject * obj)
{
	Command * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_COMMAND, Command);
	_g_free0 (self->priv->_name);
	_g_free0 (self->priv->_explanation);
	G_OBJECT_CLASS (command_parent_class)->finalize (obj);
}

static GType
command_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (CommandClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) command_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Command), 0, (GInstanceInitFunc) command_instance_init, NULL };
	GType command_type_id;
	command_type_id = g_type_register_static (G_TYPE_OBJECT, "Command", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
	Command_private_offset = g_type_add_instance_private (command_type_id, sizeof (CommandPrivate));
	return command_type_id;
}

GType
command_get_type (void)
{
	static volatile gsize command_type_id__once = 0;
	if (g_once_init_enter (&command_type_id__once)) {
		GType command_type_id;
		command_type_id = command_get_type_once ();
		g_once_init_leave (&command_type_id__once, command_type_id);
	}
	return command_type_id__once;
}

static void
_vala_command_get_property (GObject * object,
                            guint property_id,
                            GValue * value,
                            GParamSpec * pspec)
{
	Command * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_COMMAND, Command);
	switch (property_id) {
		case COMMAND_NAME_PROPERTY:
		g_value_set_string (value, command_get_name (self));
		break;
		case COMMAND_EXPLANATION_PROPERTY:
		g_value_set_string (value, command_get_explanation (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_command_set_property (GObject * object,
                            guint property_id,
                            const GValue * value,
                            GParamSpec * pspec)
{
	Command * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_COMMAND, Command);
	switch (property_id) {
		case COMMAND_NAME_PROPERTY:
		command_set_name (self, g_value_get_string (value));
		break;
		case COMMAND_EXPLANATION_PROPERTY:
		command_set_explanation (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static inline gpointer
command_manager_get_instance_private (CommandManager* self)
{
	return G_STRUCT_MEMBER_P (self, CommandManager_private_offset);
}

CommandManager*
command_manager_construct (GType object_type,
                           gint depth)
{
	CommandManager* self = NULL;
	self = (CommandManager*) g_type_create_instance (object_type);
	_vala_assert (depth > 0, "depth > 0");
	self->priv->depth = depth;
	return self;
}

CommandManager*
command_manager_new (gint depth)
{
	return command_manager_construct (TYPE_COMMAND_MANAGER, depth);
}

void
command_manager_reset (CommandManager* self)
{
	GeeArrayList* _tmp0_;
	GeeArrayList* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->undo_stack;
	gee_abstract_collection_clear ((GeeAbstractCollection*) _tmp0_);
	_tmp1_ = self->priv->redo_stack;
	gee_abstract_collection_clear ((GeeAbstractCollection*) _tmp1_);
	g_signal_emit (self, command_manager_signals[COMMAND_MANAGER_ALTERED_SIGNAL], 0, FALSE, FALSE);
}

void
command_manager_execute (CommandManager* self,
                         Command* command)
{
	GeeArrayList* _tmp0_;
	Command* top_command = NULL;
	GeeArrayList* _tmp1_;
	Command* _tmp2_;
	Command* _tmp3_;
	GeeArrayList* _tmp5_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (command != NULL);
	command_internal_set_command_manager (command, self);
	_tmp0_ = self->priv->redo_stack;
	gee_abstract_collection_clear ((GeeAbstractCollection*) _tmp0_);
	_tmp1_ = self->priv->undo_stack;
	_tmp2_ = command_manager_top (self, _tmp1_);
	top_command = _tmp2_;
	_tmp3_ = top_command;
	if (_tmp3_ != NULL) {
		Command* _tmp4_;
		_tmp4_ = top_command;
		if (command_compress (_tmp4_, command)) {
			_g_object_unref0 (top_command);
			return;
		}
	}
	_tmp5_ = self->priv->undo_stack;
	command_manager_push (self, _tmp5_, command);
	command_prepare (command);
	command_execute (command);
	g_signal_emit (self, command_manager_signals[COMMAND_MANAGER_ALTERED_SIGNAL], 0, command_manager_can_undo (self), command_manager_can_redo (self));
	_g_object_unref0 (top_command);
}

gboolean
command_manager_can_undo (CommandManager* self)
{
	GeeArrayList* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->undo_stack;
	_tmp1_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp0_);
	_tmp2_ = _tmp1_;
	result = _tmp2_ > 0;
	return result;
}

Command*
command_manager_get_undo_command (CommandManager* self)
{
	GeeArrayList* _tmp0_;
	Command* _tmp1_;
	Command* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->undo_stack;
	_tmp1_ = command_manager_top (self, _tmp0_);
	result = _tmp1_;
	return result;
}

gboolean
command_manager_undo (CommandManager* self)
{
	Command* command = NULL;
	GeeArrayList* _tmp0_;
	Command* _tmp1_;
	Command* _tmp2_;
	GeeArrayList* _tmp3_;
	Command* _tmp4_;
	Command* _tmp5_;
	Command* _tmp6_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->undo_stack;
	_tmp1_ = command_manager_pop (self, _tmp0_);
	command = _tmp1_;
	_tmp2_ = command;
	if (_tmp2_ == NULL) {
		result = FALSE;
		_g_object_unref0 (command);
		return result;
	}
	_tmp3_ = self->priv->redo_stack;
	_tmp4_ = command;
	command_manager_push (self, _tmp3_, _tmp4_);
	_tmp5_ = command;
	command_prepare (_tmp5_);
	_tmp6_ = command;
	command_undo (_tmp6_);
	g_signal_emit (self, command_manager_signals[COMMAND_MANAGER_ALTERED_SIGNAL], 0, command_manager_can_undo (self), command_manager_can_redo (self));
	result = TRUE;
	_g_object_unref0 (command);
	return result;
}

gboolean
command_manager_can_redo (CommandManager* self)
{
	GeeArrayList* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->redo_stack;
	_tmp1_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp0_);
	_tmp2_ = _tmp1_;
	result = _tmp2_ > 0;
	return result;
}

Command*
command_manager_get_redo_command (CommandManager* self)
{
	GeeArrayList* _tmp0_;
	Command* _tmp1_;
	Command* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->redo_stack;
	_tmp1_ = command_manager_top (self, _tmp0_);
	result = _tmp1_;
	return result;
}

gboolean
command_manager_redo (CommandManager* self)
{
	Command* command = NULL;
	GeeArrayList* _tmp0_;
	Command* _tmp1_;
	Command* _tmp2_;
	GeeArrayList* _tmp3_;
	Command* _tmp4_;
	Command* _tmp5_;
	Command* _tmp6_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->redo_stack;
	_tmp1_ = command_manager_pop (self, _tmp0_);
	command = _tmp1_;
	_tmp2_ = command;
	if (_tmp2_ == NULL) {
		result = FALSE;
		_g_object_unref0 (command);
		return result;
	}
	_tmp3_ = self->priv->undo_stack;
	_tmp4_ = command;
	command_manager_push (self, _tmp3_, _tmp4_);
	_tmp5_ = command;
	command_prepare (_tmp5_);
	_tmp6_ = command;
	command_redo (_tmp6_);
	g_signal_emit (self, command_manager_signals[COMMAND_MANAGER_ALTERED_SIGNAL], 0, command_manager_can_undo (self), command_manager_can_redo (self));
	result = TRUE;
	_g_object_unref0 (command);
	return result;
}

static Command*
command_manager_top (CommandManager* self,
                     GeeArrayList* stack)
{
	Command* _tmp0_ = NULL;
	gint _tmp1_;
	gint _tmp2_;
	Command* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (stack != NULL, NULL);
	_tmp1_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) stack);
	_tmp2_ = _tmp1_;
	if (_tmp2_ > 0) {
		gint _tmp3_;
		gint _tmp4_;
		gpointer _tmp5_;
		_tmp3_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) stack);
		_tmp4_ = _tmp3_;
		_tmp5_ = gee_abstract_list_get ((GeeAbstractList*) stack, _tmp4_ - 1);
		_g_object_unref0 (_tmp0_);
		_tmp0_ = (Command*) _tmp5_;
	} else {
		_g_object_unref0 (_tmp0_);
		_tmp0_ = NULL;
	}
	result = _tmp0_;
	return result;
}

static void
command_manager_push (CommandManager* self,
                      GeeArrayList* stack,
                      Command* command)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (stack != NULL);
	g_return_if_fail (command != NULL);
	gee_abstract_collection_add ((GeeAbstractCollection*) stack, command);
	while (TRUE) {
		gint _tmp0_;
		gint _tmp1_;
		gpointer _tmp2_;
		Command* _tmp3_;
		_tmp0_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) stack);
		_tmp1_ = _tmp0_;
		if (!(_tmp1_ >= self->priv->depth)) {
			break;
		}
		_tmp2_ = gee_abstract_list_remove_at ((GeeAbstractList*) stack, 0);
		_tmp3_ = (Command*) _tmp2_;
		_g_object_unref0 (_tmp3_);
	}
}

static Command*
command_manager_pop (CommandManager* self,
                     GeeArrayList* stack)
{
	gint _tmp0_;
	gint _tmp1_;
	Command* command = NULL;
	gint _tmp2_;
	gint _tmp3_;
	gpointer _tmp4_;
	gboolean removed = FALSE;
	Command* _tmp5_;
	Command* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (stack != NULL, NULL);
	_tmp0_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) stack);
	_tmp1_ = _tmp0_;
	if (_tmp1_ <= 0) {
		result = NULL;
		return result;
	}
	_tmp2_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) stack);
	_tmp3_ = _tmp2_;
	_tmp4_ = gee_abstract_list_get ((GeeAbstractList*) stack, _tmp3_ - 1);
	command = (Command*) _tmp4_;
	_tmp5_ = command;
	removed = gee_abstract_collection_remove ((GeeAbstractCollection*) stack, _tmp5_);
	_vala_assert (removed, "removed");
	result = command;
	return result;
}

static void
g_cclosure_user_marshal_VOID__BOOLEAN_BOOLEAN (GClosure * closure,
                                               GValue * return_value,
                                               guint n_param_values,
                                               const GValue * param_values,
                                               gpointer invocation_hint,
                                               gpointer marshal_data)
{
	typedef void (*GMarshalFunc_VOID__BOOLEAN_BOOLEAN) (gpointer data1, gboolean arg_1, gboolean arg_2, gpointer data2);
	register GMarshalFunc_VOID__BOOLEAN_BOOLEAN callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 3);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__BOOLEAN_BOOLEAN) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_boolean (param_values + 1), g_value_get_boolean (param_values + 2), data2);
}

static void
value_command_manager_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
value_command_manager_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		command_manager_unref (value->data[0].v_pointer);
	}
}

static void
value_command_manager_copy_value (const GValue* src_value,
                                  GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = command_manager_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
value_command_manager_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
value_command_manager_collect_value (GValue* value,
                                     guint n_collect_values,
                                     GTypeCValue* collect_values,
                                     guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		CommandManager * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = command_manager_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
value_command_manager_lcopy_value (const GValue* value,
                                   guint n_collect_values,
                                   GTypeCValue* collect_values,
                                   guint collect_flags)
{
	CommandManager ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = command_manager_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
param_spec_command_manager (const gchar* name,
                            const gchar* nick,
                            const gchar* blurb,
                            GType object_type,
                            GParamFlags flags)
{
	ParamSpecCommandManager* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_COMMAND_MANAGER), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
value_get_command_manager (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_COMMAND_MANAGER), NULL);
	return value->data[0].v_pointer;
}

void
value_set_command_manager (GValue* value,
                           gpointer v_object)
{
	CommandManager * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_COMMAND_MANAGER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_COMMAND_MANAGER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		command_manager_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		command_manager_unref (old);
	}
}

void
value_take_command_manager (GValue* value,
                            gpointer v_object)
{
	CommandManager * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_COMMAND_MANAGER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_COMMAND_MANAGER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		command_manager_unref (old);
	}
}

static void
command_manager_class_init (CommandManagerClass * klass,
                            gpointer klass_data)
{
	command_manager_parent_class = g_type_class_peek_parent (klass);
	((CommandManagerClass *) klass)->finalize = command_manager_finalize;
	g_type_class_adjust_private_offset (klass, &CommandManager_private_offset);
	command_manager_signals[COMMAND_MANAGER_ALTERED_SIGNAL] = g_signal_new ("altered", TYPE_COMMAND_MANAGER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__BOOLEAN_BOOLEAN, G_TYPE_NONE, 2, G_TYPE_BOOLEAN, G_TYPE_BOOLEAN);
}

static void
command_manager_instance_init (CommandManager * self,
                               gpointer klass)
{
	GeeArrayList* _tmp0_;
	GeeArrayList* _tmp1_;
	self->priv = command_manager_get_instance_private (self);
	_tmp0_ = gee_array_list_new (TYPE_COMMAND, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	self->priv->undo_stack = _tmp0_;
	_tmp1_ = gee_array_list_new (TYPE_COMMAND, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	self->priv->redo_stack = _tmp1_;
	self->ref_count = 1;
}

static void
command_manager_finalize (CommandManager * obj)
{
	CommandManager * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_COMMAND_MANAGER, CommandManager);
	g_signal_handlers_destroy (self);
	_g_object_unref0 (self->priv->undo_stack);
	_g_object_unref0 (self->priv->redo_stack);
}

static GType
command_manager_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { value_command_manager_init, value_command_manager_free_value, value_command_manager_copy_value, value_command_manager_peek_pointer, "p", value_command_manager_collect_value, "p", value_command_manager_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (CommandManagerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) command_manager_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (CommandManager), 0, (GInstanceInitFunc) command_manager_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType command_manager_type_id;
	command_manager_type_id = g_type_register_fundamental (g_type_fundamental_next (), "CommandManager", &g_define_type_info, &g_define_type_fundamental_info, 0);
	CommandManager_private_offset = g_type_add_instance_private (command_manager_type_id, sizeof (CommandManagerPrivate));
	return command_manager_type_id;
}

GType
command_manager_get_type (void)
{
	static volatile gsize command_manager_type_id__once = 0;
	if (g_once_init_enter (&command_manager_type_id__once)) {
		GType command_manager_type_id;
		command_manager_type_id = command_manager_get_type_once ();
		g_once_init_leave (&command_manager_type_id__once, command_manager_type_id);
	}
	return command_manager_type_id__once;
}

gpointer
command_manager_ref (gpointer instance)
{
	CommandManager * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
command_manager_unref (gpointer instance)
{
	CommandManager * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		COMMAND_MANAGER_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

