/* AccentColorManager.c generated by valac 0.56.18, the Vala compiler
 * generated from AccentColorManager.vala, do not modify */

/*
 * SPDX-License-Identifier: GPL-3.0-or-later
 * SPDX-FileCopyrightText: 2021-2024 elementary, Inc. (https://elementary.io)
 * Authored by: Marius Meisenzahl <mariusmeisenzahl@gmail.com>
 */

#include <glib-object.h>
#include <glib.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <gdk/gdk.h>
#include <float.h>
#include <math.h>
#include <gexiv2/gexiv2.h>
#include <gdk-pixbuf/gdk-pixbuf.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define SETTINGS_DAEMON_BACKENDS_TYPE_ACCENT_COLOR_MANAGER (settings_daemon_backends_accent_color_manager_get_type ())
#define SETTINGS_DAEMON_BACKENDS_ACCENT_COLOR_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SETTINGS_DAEMON_BACKENDS_TYPE_ACCENT_COLOR_MANAGER, SettingsDaemonBackendsAccentColorManager))
#define SETTINGS_DAEMON_BACKENDS_ACCENT_COLOR_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SETTINGS_DAEMON_BACKENDS_TYPE_ACCENT_COLOR_MANAGER, SettingsDaemonBackendsAccentColorManagerClass))
#define SETTINGS_DAEMON_BACKENDS_IS_ACCENT_COLOR_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SETTINGS_DAEMON_BACKENDS_TYPE_ACCENT_COLOR_MANAGER))
#define SETTINGS_DAEMON_BACKENDS_IS_ACCENT_COLOR_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SETTINGS_DAEMON_BACKENDS_TYPE_ACCENT_COLOR_MANAGER))
#define SETTINGS_DAEMON_BACKENDS_ACCENT_COLOR_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SETTINGS_DAEMON_BACKENDS_TYPE_ACCENT_COLOR_MANAGER, SettingsDaemonBackendsAccentColorManagerClass))

typedef struct _SettingsDaemonBackendsAccentColorManager SettingsDaemonBackendsAccentColorManager;
typedef struct _SettingsDaemonBackendsAccentColorManagerClass SettingsDaemonBackendsAccentColorManagerClass;
typedef struct _SettingsDaemonBackendsAccentColorManagerPrivate SettingsDaemonBackendsAccentColorManagerPrivate;

#define PANTHEON_TYPE_ACCOUNTS_SERVICE (pantheon_accounts_service_get_type ())
#define PANTHEON_ACCOUNTS_SERVICE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PANTHEON_TYPE_ACCOUNTS_SERVICE, PantheonAccountsService))
#define PANTHEON_IS_ACCOUNTS_SERVICE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PANTHEON_TYPE_ACCOUNTS_SERVICE))
#define PANTHEON_ACCOUNTS_SERVICE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), PANTHEON_TYPE_ACCOUNTS_SERVICE, PantheonAccountsServiceIface))

typedef struct _PantheonAccountsService PantheonAccountsService;
typedef struct _PantheonAccountsServiceIface PantheonAccountsServiceIface;

#define PANTHEON_TYPE_ACCOUNTS_SERVICE_PROXY (pantheon_accounts_service_proxy_get_type ())
enum  {
	SETTINGS_DAEMON_BACKENDS_ACCENT_COLOR_MANAGER_0_PROPERTY,
	SETTINGS_DAEMON_BACKENDS_ACCENT_COLOR_MANAGER_ACCOUNTS_SERVICE_PROPERTY,
	SETTINGS_DAEMON_BACKENDS_ACCENT_COLOR_MANAGER_NUM_PROPERTIES
};
static GParamSpec* settings_daemon_backends_accent_color_manager_properties[SETTINGS_DAEMON_BACKENDS_ACCENT_COLOR_MANAGER_NUM_PROPERTIES];
typedef enum  {
	SETTINGS_DAEMON_BACKENDS_ACCENT_COLOR_MANAGER_BACKGROUND_STYLE_NONE
} SettingsDaemonBackendsAccentColorManagerBackgroundStyle;

#define SETTINGS_DAEMON_BACKENDS_ACCENT_COLOR_MANAGER_TYPE_BACKGROUND_STYLE (settings_daemon_backends_accent_color_manager_background_style_get_type ())
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define SETTINGS_DAEMON_BACKENDS_ACCENT_COLOR_MANAGER_TYPE_THEME (settings_daemon_backends_accent_color_manager_theme_get_type ())
typedef struct _SettingsDaemonBackendsAccentColorManagerTheme SettingsDaemonBackendsAccentColorManagerTheme;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _settings_daemon_backends_accent_color_manager_theme_free0(var) ((var == NULL) ? NULL : (var = (settings_daemon_backends_accent_color_manager_theme_free (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_array_unref0(var) ((var == NULL) ? NULL : (var = (g_array_unref (var), NULL)))

struct _SettingsDaemonBackendsAccentColorManager {
	GObject parent_instance;
	SettingsDaemonBackendsAccentColorManagerPrivate * priv;
};

struct _SettingsDaemonBackendsAccentColorManagerClass {
	GObjectClass parent_class;
};

struct _PantheonAccountsServiceIface {
	GTypeInterface parent_iface;
	gint (*get_prefers_color_scheme) (PantheonAccountsService* self);
	void (*set_prefers_color_scheme) (PantheonAccountsService* self, gint value);
	gint (*get_prefers_accent_color) (PantheonAccountsService* self);
	void (*set_prefers_accent_color) (PantheonAccountsService* self, gint value);
};

struct _SettingsDaemonBackendsAccentColorManagerPrivate {
	PantheonAccountsService* _accounts_service;
	GSettings* background_settings;
	GSettings* interface_settings;
};

struct _SettingsDaemonBackendsAccentColorManagerTheme {
	gchar* name;
	gchar* stylesheet;
	GdkRGBA color;
};

static gint SettingsDaemonBackendsAccentColorManager_private_offset;
static gpointer settings_daemon_backends_accent_color_manager_parent_class = NULL;
static SettingsDaemonBackendsAccentColorManagerTheme* settings_daemon_backends_accent_color_manager_themes;
static gint settings_daemon_backends_accent_color_manager_themes_length1;
static SettingsDaemonBackendsAccentColorManagerTheme* settings_daemon_backends_accent_color_manager_themes = NULL;
static gint settings_daemon_backends_accent_color_manager_themes_length1 = 0;
static gint _settings_daemon_backends_accent_color_manager_themes_size_ = 0;

VALA_EXTERN GType settings_daemon_backends_accent_color_manager_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SettingsDaemonBackendsAccentColorManager, g_object_unref)
VALA_EXTERN GType pantheon_accounts_service_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (PantheonAccountsService, g_object_unref)
VALA_EXTERN GType pantheon_accounts_service_proxy_get_type (void) G_GNUC_CONST ;
VALA_EXTERN guint pantheon_accounts_service_register_object (void* object,
                                                 GDBusConnection* connection,
                                                 const gchar* path,
                                                 GError** error);
static GType settings_daemon_backends_accent_color_manager_background_style_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
static GType settings_daemon_backends_accent_color_manager_theme_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
static SettingsDaemonBackendsAccentColorManagerTheme* settings_daemon_backends_accent_color_manager_theme_dup (const SettingsDaemonBackendsAccentColorManagerTheme* self);
static void settings_daemon_backends_accent_color_manager_theme_free (SettingsDaemonBackendsAccentColorManagerTheme* self);
static void settings_daemon_backends_accent_color_manager_theme_copy (const SettingsDaemonBackendsAccentColorManagerTheme* self,
                                                               SettingsDaemonBackendsAccentColorManagerTheme* dest);
static void settings_daemon_backends_accent_color_manager_theme_destroy (SettingsDaemonBackendsAccentColorManagerTheme* self);
G_DEFINE_AUTO_CLEANUP_CLEAR_FUNC (SettingsDaemonBackendsAccentColorManagerTheme, settings_daemon_backends_accent_color_manager_theme_destroy)
static inline void settings_daemon_backends_accent_color_manager_rgba_from_int (gint color,
                                                                  GdkRGBA* result);
VALA_EXTERN SettingsDaemonBackendsAccentColorManager* settings_daemon_backends_accent_color_manager_new (PantheonAccountsService* accounts_service);
VALA_EXTERN SettingsDaemonBackendsAccentColorManager* settings_daemon_backends_accent_color_manager_construct (GType object_type,
                                                                                                   PantheonAccountsService* accounts_service);
static void settings_daemon_backends_accent_color_manager_update_accent_color (SettingsDaemonBackendsAccentColorManager* self);
static SettingsDaemonBackendsAccentColorManagerTheme* settings_daemon_backends_accent_color_manager_get_theme_for_picture (SettingsDaemonBackendsAccentColorManager* self,
                                                                                                                    const gchar* picture_uri);
static SettingsDaemonBackendsAccentColorManagerTheme* settings_daemon_backends_accent_color_manager_get_theme_for_primary_color (SettingsDaemonBackendsAccentColorManager* self,
                                                                                                                          const gchar* primary_color);
static inline gdouble settings_daemon_backends_accent_color_manager_get_match (GdkRGBA* color,
                                                                 GdkRGBA* other);
static guint8* _vala_array_dup1 (guint8* self,
                          gssize length);
VALA_EXTERN PantheonAccountsService* settings_daemon_backends_accent_color_manager_get_accounts_service (SettingsDaemonBackendsAccentColorManager* self);
static void settings_daemon_backends_accent_color_manager_set_accounts_service (SettingsDaemonBackendsAccentColorManager* self,
                                                                         PantheonAccountsService* value);
static GObject * settings_daemon_backends_accent_color_manager_constructor (GType type,
                                                                     guint n_construct_properties,
                                                                     GObjectConstructParam * construct_properties);
static void _settings_daemon_backends_accent_color_manager___lambda12_ (SettingsDaemonBackendsAccentColorManager* self,
                                                                 GVariant* props);
static void _settings_daemon_backends_accent_color_manager_update_accent_color_g_settings_changed (GSettings* _sender,
                                                                                            const gchar* key,
                                                                                            gpointer self);
static void __settings_daemon_backends_accent_color_manager___lambda12__g_dbus_proxy_g_properties_changed (GDBusProxy* _sender,
                                                                                                    GVariant* changed_properties,
                                                                                                    gchar** invalidated_properties,
                                                                                                    gpointer self);
VALA_EXTERN gint pantheon_accounts_service_get_prefers_accent_color (PantheonAccountsService* self);
static void settings_daemon_backends_accent_color_manager_finalize (GObject * obj);
static GType settings_daemon_backends_accent_color_manager_get_type_once (void);
static void _vala_settings_daemon_backends_accent_color_manager_get_property (GObject * object,
                                                                       guint property_id,
                                                                       GValue * value,
                                                                       GParamSpec * pspec);
static void _vala_settings_daemon_backends_accent_color_manager_set_property (GObject * object,
                                                                       guint property_id,
                                                                       const GValue * value,
                                                                       GParamSpec * pspec);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static inline gpointer
settings_daemon_backends_accent_color_manager_get_instance_private (SettingsDaemonBackendsAccentColorManager* self)
{
	return G_STRUCT_MEMBER_P (self, SettingsDaemonBackendsAccentColorManager_private_offset);
}

static GType
settings_daemon_backends_accent_color_manager_background_style_get_type_once (void)
{
	static const GEnumValue values[] = {{SETTINGS_DAEMON_BACKENDS_ACCENT_COLOR_MANAGER_BACKGROUND_STYLE_NONE, "SETTINGS_DAEMON_BACKENDS_ACCENT_COLOR_MANAGER_BACKGROUND_STYLE_NONE", "none"}, {0, NULL, NULL}};
	GType settings_daemon_backends_accent_color_manager_background_style_type_id;
	settings_daemon_backends_accent_color_manager_background_style_type_id = g_enum_register_static ("SettingsDaemonBackendsAccentColorManagerBackgroundStyle", values);
	return settings_daemon_backends_accent_color_manager_background_style_type_id;
}

static GType
settings_daemon_backends_accent_color_manager_background_style_get_type (void)
{
	static volatile gsize settings_daemon_backends_accent_color_manager_background_style_type_id__once = 0;
	if (g_once_init_enter (&settings_daemon_backends_accent_color_manager_background_style_type_id__once)) {
		GType settings_daemon_backends_accent_color_manager_background_style_type_id;
		settings_daemon_backends_accent_color_manager_background_style_type_id = settings_daemon_backends_accent_color_manager_background_style_get_type_once ();
		g_once_init_leave (&settings_daemon_backends_accent_color_manager_background_style_type_id__once, settings_daemon_backends_accent_color_manager_background_style_type_id);
	}
	return settings_daemon_backends_accent_color_manager_background_style_type_id__once;
}

static inline void
settings_daemon_backends_accent_color_manager_rgba_from_int (gint color,
                                                             GdkRGBA* result)
{
	GdkRGBA _tmp0_ = {0};
	_tmp0_.red = ((color >> 16) & 255) / 255.0;
	_tmp0_.green = ((color >> 8) & 255) / 255.0;
	_tmp0_.blue = (color & 255) / 255.0;
	_tmp0_.alpha = 0.0;
	*result = _tmp0_;
	return;
}

SettingsDaemonBackendsAccentColorManager*
settings_daemon_backends_accent_color_manager_construct (GType object_type,
                                                         PantheonAccountsService* accounts_service)
{
	SettingsDaemonBackendsAccentColorManager * self = NULL;
	g_return_val_if_fail (accounts_service != NULL, NULL);
	self = (SettingsDaemonBackendsAccentColorManager*) g_object_new (object_type, "accounts-service", accounts_service, NULL);
	return self;
}

SettingsDaemonBackendsAccentColorManager*
settings_daemon_backends_accent_color_manager_new (PantheonAccountsService* accounts_service)
{
	return settings_daemon_backends_accent_color_manager_construct (SETTINGS_DAEMON_BACKENDS_TYPE_ACCENT_COLOR_MANAGER, accounts_service);
}

static void
settings_daemon_backends_accent_color_manager_update_accent_color (SettingsDaemonBackendsAccentColorManager* self)
{
	gchar* current_stylesheet = NULL;
	GSettings* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	SettingsDaemonBackendsAccentColorManagerTheme* new_theme = NULL;
	GSettings* _tmp3_;
	SettingsDaemonBackendsAccentColorManagerTheme* _tmp9_;
	SettingsDaemonBackendsAccentColorManagerTheme* _tmp15_;
	const gchar* _tmp16_;
	const gchar* _tmp17_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->interface_settings;
	_tmp1_ = g_settings_get_string (_tmp0_, "gtk-theme");
	current_stylesheet = _tmp1_;
	_tmp2_ = current_stylesheet;
	g_debug ("AccentColorManager.vala:82: Current stylesheet: %s", _tmp2_);
	new_theme = NULL;
	_tmp3_ = self->priv->background_settings;
	if (g_settings_get_enum (_tmp3_, "picture-options") != ((gint) SETTINGS_DAEMON_BACKENDS_ACCENT_COLOR_MANAGER_BACKGROUND_STYLE_NONE)) {
		gchar* picture_uri = NULL;
		GSettings* _tmp4_;
		gchar* _tmp5_;
		const gchar* _tmp6_;
		const gchar* _tmp7_;
		SettingsDaemonBackendsAccentColorManagerTheme* _tmp8_;
		_tmp4_ = self->priv->background_settings;
		_tmp5_ = g_settings_get_string (_tmp4_, "picture-uri");
		picture_uri = _tmp5_;
		_tmp6_ = picture_uri;
		g_debug ("AccentColorManager.vala:87: Current wallpaper: %s", _tmp6_);
		_tmp7_ = picture_uri;
		_tmp8_ = settings_daemon_backends_accent_color_manager_get_theme_for_picture (self, _tmp7_);
		_settings_daemon_backends_accent_color_manager_theme_free0 (new_theme);
		new_theme = _tmp8_;
		_g_free0 (picture_uri);
	}
	_tmp9_ = new_theme;
	if (_tmp9_ == NULL) {
		gchar* primary_color = NULL;
		GSettings* _tmp10_;
		gchar* _tmp11_;
		const gchar* _tmp12_;
		const gchar* _tmp13_;
		SettingsDaemonBackendsAccentColorManagerTheme* _tmp14_;
		_tmp10_ = self->priv->background_settings;
		_tmp11_ = g_settings_get_string (_tmp10_, "primary-color");
		primary_color = _tmp11_;
		_tmp12_ = primary_color;
		g_debug ("AccentColorManager.vala:94: Current primary color: %s", _tmp12_);
		_tmp13_ = primary_color;
		_tmp14_ = settings_daemon_backends_accent_color_manager_get_theme_for_primary_color (self, _tmp13_);
		_settings_daemon_backends_accent_color_manager_theme_free0 (new_theme);
		new_theme = _tmp14_;
		_g_free0 (primary_color);
	}
	_tmp15_ = new_theme;
	_tmp16_ = (*_tmp15_).stylesheet;
	_tmp17_ = current_stylesheet;
	if (g_strcmp0 (_tmp16_, _tmp17_) != 0) {
		SettingsDaemonBackendsAccentColorManagerTheme* _tmp18_;
		const gchar* _tmp19_;
		GSettings* _tmp20_;
		SettingsDaemonBackendsAccentColorManagerTheme* _tmp21_;
		const gchar* _tmp22_;
		_tmp18_ = new_theme;
		_tmp19_ = (*_tmp18_).stylesheet;
		g_debug ("AccentColorManager.vala:99: New stylesheet: %s", _tmp19_);
		_tmp20_ = self->priv->interface_settings;
		_tmp21_ = new_theme;
		_tmp22_ = (*_tmp21_).stylesheet;
		g_settings_set_string (_tmp20_, "gtk-theme", _tmp22_);
	}
	_settings_daemon_backends_accent_color_manager_theme_free0 (new_theme);
	_g_free0 (current_stylesheet);
}

static gpointer
_settings_daemon_backends_accent_color_manager_theme_dup0 (gpointer self)
{
	return self ? settings_daemon_backends_accent_color_manager_theme_dup (self) : NULL;
}

static SettingsDaemonBackendsAccentColorManagerTheme*
settings_daemon_backends_accent_color_manager_get_theme_for_primary_color (SettingsDaemonBackendsAccentColorManager* self,
                                                                           const gchar* primary_color)
{
	gdouble best_match = 0.0;
	gint index = 0;
	GdkRGBA color = {0};
	GdkRGBA _tmp0_ = {0};
	SettingsDaemonBackendsAccentColorManagerTheme* _tmp8_;
	gint _tmp8__length1;
	SettingsDaemonBackendsAccentColorManagerTheme _tmp9_;
	SettingsDaemonBackendsAccentColorManagerTheme _tmp10_;
	SettingsDaemonBackendsAccentColorManagerTheme* _tmp11_;
	SettingsDaemonBackendsAccentColorManagerTheme* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (primary_color != NULL, NULL);
	best_match = DBL_MIN;
	index = 0;
	color = _tmp0_;
	gdk_rgba_parse (&color, primary_color);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp1_ = FALSE;
			_tmp1_ = TRUE;
			while (TRUE) {
				SettingsDaemonBackendsAccentColorManagerTheme* _tmp3_;
				gint _tmp3__length1;
				gdouble match = 0.0;
				GdkRGBA _tmp4_;
				SettingsDaemonBackendsAccentColorManagerTheme* _tmp5_;
				gint _tmp5__length1;
				SettingsDaemonBackendsAccentColorManagerTheme _tmp6_;
				GdkRGBA _tmp7_;
				if (!_tmp1_) {
					gint _tmp2_;
					_tmp2_ = i;
					i = _tmp2_ + 1;
				}
				_tmp1_ = FALSE;
				_tmp3_ = settings_daemon_backends_accent_color_manager_themes;
				_tmp3__length1 = settings_daemon_backends_accent_color_manager_themes_length1;
				if (!(i < _tmp3__length1)) {
					break;
				}
				_tmp4_ = color;
				_tmp5_ = settings_daemon_backends_accent_color_manager_themes;
				_tmp5__length1 = settings_daemon_backends_accent_color_manager_themes_length1;
				_tmp6_ = _tmp5_[i];
				_tmp7_ = _tmp6_.color;
				match = settings_daemon_backends_accent_color_manager_get_match (&_tmp4_, &_tmp7_);
				if (match > best_match) {
					best_match = match;
					index = i;
				}
			}
		}
	}
	_tmp8_ = settings_daemon_backends_accent_color_manager_themes;
	_tmp8__length1 = settings_daemon_backends_accent_color_manager_themes_length1;
	_tmp9_ = _tmp8_[index];
	_tmp10_ = _tmp9_;
	_tmp11_ = _settings_daemon_backends_accent_color_manager_theme_dup0 (&_tmp10_);
	result = _tmp11_;
	return result;
}

static guint8*
_vala_array_dup1 (guint8* self,
                  gssize length)
{
	if (length > 0) {
		return _vala_memdup2 (self, length * sizeof (guint8));
	}
	return NULL;
}

static SettingsDaemonBackendsAccentColorManagerTheme*
settings_daemon_backends_accent_color_manager_get_theme_for_picture (SettingsDaemonBackendsAccentColorManager* self,
                                                                     const gchar* picture_uri)
{
	gchar* path = NULL;
	GError* _inner_error0_ = NULL;
	SettingsDaemonBackendsAccentColorManagerTheme* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (picture_uri != NULL, NULL);
	{
		gchar* _tmp0_ = NULL;
		gchar* _tmp1_;
		gchar* _tmp2_;
		_tmp1_ = g_filename_from_uri (picture_uri, NULL, &_inner_error0_);
		_tmp0_ = _tmp1_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_CONVERT_ERROR) {
				goto __catch0_g_convert_error;
			}
			_g_free0 (path);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp2_ = _tmp0_;
		_tmp0_ = NULL;
		_g_free0 (path);
		path = _tmp2_;
		_g_free0 (_tmp0_);
	}
	goto __finally0;
	__catch0_g_convert_error:
	{
		GError* e = NULL;
		GError* _tmp3_;
		const gchar* _tmp4_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp3_ = e;
		_tmp4_ = _tmp3_->message;
		g_warning ("AccentColorManager.vala:127: Failed to convert picture uri to path: '%" \
"s'", _tmp4_);
		result = NULL;
		_g_error_free0 (e);
		_g_free0 (path);
		return result;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_free0 (path);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	{
		GExiv2Metadata* metadata = NULL;
		GExiv2Metadata* _tmp5_;
		GExiv2Metadata* _tmp6_;
		const gchar* _tmp7_;
		gchar* accent_name = NULL;
		GExiv2Metadata* _tmp8_;
		gchar* _tmp9_;
		SettingsDaemonBackendsAccentColorManagerTheme* _tmp10_;
		gint _tmp10__length1;
		_tmp5_ = gexiv2_metadata_new ();
		metadata = _tmp5_;
		_tmp6_ = metadata;
		_tmp7_ = path;
		gexiv2_metadata_open_path (_tmp6_, _tmp7_, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (metadata);
			goto __catch1_g_error;
		}
		_tmp8_ = metadata;
		_tmp9_ = gexiv2_metadata_try_get_tag_string (_tmp8_, "Xmp.xmp.io.elementary.AccentColor", &_inner_error0_);
		accent_name = _tmp9_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (metadata);
			goto __catch1_g_error;
		}
		_tmp10_ = settings_daemon_backends_accent_color_manager_themes;
		_tmp10__length1 = settings_daemon_backends_accent_color_manager_themes_length1;
		{
			SettingsDaemonBackendsAccentColorManagerTheme* theme_collection = NULL;
			gint theme_collection_length1 = 0;
			gint _theme_collection_size_ = 0;
			gint theme_it = 0;
			theme_collection = _tmp10_;
			theme_collection_length1 = _tmp10__length1;
			for (theme_it = 0; theme_it < theme_collection_length1; theme_it = theme_it + 1) {
				SettingsDaemonBackendsAccentColorManagerTheme theme = {0};
				theme = theme_collection[theme_it];
				{
					SettingsDaemonBackendsAccentColorManagerTheme _tmp11_;
					const gchar* _tmp12_;
					const gchar* _tmp13_;
					_tmp11_ = theme;
					_tmp12_ = _tmp11_.name;
					_tmp13_ = accent_name;
					if (g_strcmp0 (_tmp12_, _tmp13_) == 0) {
						SettingsDaemonBackendsAccentColorManagerTheme _tmp14_;
						SettingsDaemonBackendsAccentColorManagerTheme _tmp15_;
						SettingsDaemonBackendsAccentColorManagerTheme* _tmp16_;
						_tmp14_ = theme;
						_tmp15_ = _tmp14_;
						_tmp16_ = _settings_daemon_backends_accent_color_manager_theme_dup0 (&_tmp15_);
						result = _tmp16_;
						_g_free0 (accent_name);
						_g_object_unref0 (metadata);
						_g_free0 (path);
						return result;
					}
				}
			}
		}
		_g_free0 (accent_name);
		_g_object_unref0 (metadata);
	}
	goto __finally1;
	__catch1_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp17_;
		GError* _tmp18_;
		const gchar* _tmp19_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp17_ = path;
		_tmp18_ = e;
		_tmp19_ = _tmp18_->message;
		g_warning ("AccentColorManager.vala:143: Error parsing exif metadata of \"%s\": %s", _tmp17_, _tmp19_);
		_g_error_free0 (e);
	}
	__finally1:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_free0 (path);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	{
		static const gdouble PERCENTAGE_SAMPLE_PIXELS = 0.01;
		GdkPixbuf* pixbuf = NULL;
		const gchar* _tmp20_;
		GdkPixbuf* _tmp21_;
		guint8* raw_pixels = NULL;
		GdkPixbuf* _tmp22_;
		guint _tmp23_ = 0;
		guint8* _tmp24_;
		guint8* _tmp25_;
		gint _tmp25__length1;
		gint raw_pixels_length1;
		gint _raw_pixels_size_;
		gint _tmp26_ = 0;
		GdkPixbuf* _tmp27_;
		gboolean _tmp28_;
		gboolean _tmp29_;
		gint factor = 0;
		gint step_size = 0;
		guint8* _tmp30_;
		gint _tmp30__length1;
		GArray* pixels = NULL;
		GArray* _tmp31_;
		gdouble best_match = 0.0;
		gint index = 0;
		SettingsDaemonBackendsAccentColorManagerTheme* _tmp50_;
		gint _tmp50__length1;
		SettingsDaemonBackendsAccentColorManagerTheme _tmp51_;
		SettingsDaemonBackendsAccentColorManagerTheme _tmp52_;
		SettingsDaemonBackendsAccentColorManagerTheme* _tmp53_;
		_tmp20_ = path;
		_tmp21_ = gdk_pixbuf_new_from_file (_tmp20_, &_inner_error0_);
		pixbuf = _tmp21_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch2_g_error;
		}
		_tmp22_ = pixbuf;
		_tmp24_ = gdk_pixbuf_get_pixels_with_length (_tmp22_, &_tmp23_);
		_tmp25_ = (_tmp24_ != NULL) ? _vala_array_dup1 (_tmp24_, _tmp23_) : _tmp24_;
		_tmp25__length1 = _tmp23_;
		raw_pixels = _tmp25_;
		raw_pixels_length1 = _tmp25__length1;
		_raw_pixels_size_ = raw_pixels_length1;
		_tmp27_ = pixbuf;
		_tmp28_ = gdk_pixbuf_get_has_alpha (_tmp27_);
		_tmp29_ = _tmp28_;
		if (_tmp29_) {
			_tmp26_ = 4;
		} else {
			_tmp26_ = 3;
		}
		factor = _tmp26_;
		_tmp30_ = raw_pixels;
		_tmp30__length1 = raw_pixels_length1;
		step_size = (gint) ((_tmp30__length1 / factor) * PERCENTAGE_SAMPLE_PIXELS);
		_tmp31_ = g_array_new (TRUE, TRUE, sizeof (GdkRGBA));
		pixels = _tmp31_;
		{
			gint i = 0;
			i = 0;
			{
				gboolean _tmp32_ = FALSE;
				_tmp32_ = TRUE;
				while (TRUE) {
					guint8* _tmp33_;
					gint _tmp33__length1;
					gint offset = 0;
					GArray* _tmp34_;
					guint8* _tmp35_;
					gint _tmp35__length1;
					guint8 _tmp36_;
					guint8* _tmp37_;
					gint _tmp37__length1;
					guint8 _tmp38_;
					guint8* _tmp39_;
					gint _tmp39__length1;
					guint8 _tmp40_;
					GdkRGBA _tmp41_ = {0};
					if (!_tmp32_) {
						i += step_size;
					}
					_tmp32_ = FALSE;
					_tmp33_ = raw_pixels;
					_tmp33__length1 = raw_pixels_length1;
					if (!(i < (_tmp33__length1 / factor))) {
						break;
					}
					offset = i * factor;
					_tmp34_ = pixels;
					_tmp35_ = raw_pixels;
					_tmp35__length1 = raw_pixels_length1;
					_tmp36_ = _tmp35_[offset];
					_tmp37_ = raw_pixels;
					_tmp37__length1 = raw_pixels_length1;
					_tmp38_ = _tmp37_[offset + 1];
					_tmp39_ = raw_pixels;
					_tmp39__length1 = raw_pixels_length1;
					_tmp40_ = _tmp39_[offset + 2];
					_tmp41_.red = _tmp36_ / 255.0;
					_tmp41_.green = _tmp38_ / 255.0;
					_tmp41_.blue = _tmp40_ / 255.0;
					_tmp41_.alpha = 0.0;
					g_array_append_val (_tmp34_, _tmp41_);
				}
			}
		}
		best_match = DBL_MIN;
		index = 0;
		{
			gint i = 0;
			i = 0;
			{
				gboolean _tmp42_ = FALSE;
				_tmp42_ = TRUE;
				while (TRUE) {
					SettingsDaemonBackendsAccentColorManagerTheme* _tmp44_;
					gint _tmp44__length1;
					gdouble match = 0.0;
					GArray* _tmp45_;
					if (!_tmp42_) {
						gint _tmp43_;
						_tmp43_ = i;
						i = _tmp43_ + 1;
					}
					_tmp42_ = FALSE;
					_tmp44_ = settings_daemon_backends_accent_color_manager_themes;
					_tmp44__length1 = settings_daemon_backends_accent_color_manager_themes_length1;
					if (!(i < _tmp44__length1)) {
						break;
					}
					match = 0.0;
					_tmp45_ = pixels;
					{
						GArray* pixel_collection = NULL;
						guint pixel_index = 0U;
						pixel_collection = _tmp45_;
						for (pixel_index = 0; pixel_index < pixel_collection->len; pixel_index = pixel_index + 1) {
							GdkRGBA pixel = {0};
							pixel = g_array_index (pixel_collection, GdkRGBA, pixel_index);
							{
								GdkRGBA _tmp46_;
								SettingsDaemonBackendsAccentColorManagerTheme* _tmp47_;
								gint _tmp47__length1;
								SettingsDaemonBackendsAccentColorManagerTheme _tmp48_;
								GdkRGBA _tmp49_;
								_tmp46_ = pixel;
								_tmp47_ = settings_daemon_backends_accent_color_manager_themes;
								_tmp47__length1 = settings_daemon_backends_accent_color_manager_themes_length1;
								_tmp48_ = _tmp47_[i];
								_tmp49_ = _tmp48_.color;
								match += settings_daemon_backends_accent_color_manager_get_match (&_tmp46_, &_tmp49_);
							}
						}
					}
					if (match > best_match) {
						best_match = match;
						index = i;
					}
				}
			}
		}
		_tmp50_ = settings_daemon_backends_accent_color_manager_themes;
		_tmp50__length1 = settings_daemon_backends_accent_color_manager_themes_length1;
		_tmp51_ = _tmp50_[index];
		_tmp52_ = _tmp51_;
		_tmp53_ = _settings_daemon_backends_accent_color_manager_theme_dup0 (&_tmp52_);
		result = _tmp53_;
		_g_array_unref0 (pixels);
		raw_pixels = (g_free (raw_pixels), NULL);
		_g_object_unref0 (pixbuf);
		_g_free0 (path);
		return result;
	}
	goto __finally2;
	__catch2_g_error:
	{
		GError* e = NULL;
		GError* _tmp54_;
		const gchar* _tmp55_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp54_ = e;
		_tmp55_ = _tmp54_->message;
		g_warning ("AccentColorManager.vala:185: %s", _tmp55_);
		_g_error_free0 (e);
	}
	__finally2:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_free0 (path);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	result = NULL;
	_g_free0 (path);
	return result;
}

static inline gdouble
settings_daemon_backends_accent_color_manager_get_match (GdkRGBA* color,
                                                         GdkRGBA* other)
{
	gdouble distance = 0.0;
	GdkRGBA _tmp0_;
	GdkRGBA _tmp1_;
	GdkRGBA _tmp2_;
	GdkRGBA _tmp3_;
	GdkRGBA _tmp4_;
	GdkRGBA _tmp5_;
	gdouble result;
	g_return_val_if_fail (color != NULL, 0.0);
	g_return_val_if_fail (other != NULL, 0.0);
	_tmp0_ = *color;
	_tmp1_ = *other;
	_tmp2_ = *color;
	_tmp3_ = *other;
	_tmp4_ = *color;
	_tmp5_ = *other;
	distance = sqrt ((pow (_tmp0_.red - _tmp1_.red, (gdouble) 2) + pow (_tmp2_.green - _tmp3_.green, (gdouble) 2)) + pow (_tmp4_.blue - _tmp5_.blue, (gdouble) 2));
	if (distance > 0.25) {
		result = 0.0;
		return result;
	}
	result = 1.0 - distance;
	return result;
}

PantheonAccountsService*
settings_daemon_backends_accent_color_manager_get_accounts_service (SettingsDaemonBackendsAccentColorManager* self)
{
	PantheonAccountsService* result;
	PantheonAccountsService* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_accounts_service;
	result = _tmp0_;
	return result;
}

static void
settings_daemon_backends_accent_color_manager_set_accounts_service (SettingsDaemonBackendsAccentColorManager* self,
                                                                    PantheonAccountsService* value)
{
	PantheonAccountsService* old_value;
	g_return_if_fail (self != NULL);
	old_value = settings_daemon_backends_accent_color_manager_get_accounts_service (self);
	if (old_value != value) {
		self->priv->_accounts_service = value;
		g_object_notify_by_pspec ((GObject *) self, settings_daemon_backends_accent_color_manager_properties[SETTINGS_DAEMON_BACKENDS_ACCENT_COLOR_MANAGER_ACCOUNTS_SERVICE_PROPERTY]);
	}
}

static void
settings_daemon_backends_accent_color_manager_theme_copy (const SettingsDaemonBackendsAccentColorManagerTheme* self,
                                                          SettingsDaemonBackendsAccentColorManagerTheme* dest)
{
	const gchar* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	GdkRGBA _tmp4_;
	_tmp0_ = (*self).name;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 ((*dest).name);
	(*dest).name = _tmp1_;
	_tmp2_ = (*self).stylesheet;
	_tmp3_ = g_strdup (_tmp2_);
	_g_free0 ((*dest).stylesheet);
	(*dest).stylesheet = _tmp3_;
	_tmp4_ = (*self).color;
	(*dest).color = _tmp4_;
}

static void
settings_daemon_backends_accent_color_manager_theme_destroy (SettingsDaemonBackendsAccentColorManagerTheme* self)
{
	_g_free0 ((*self).name);
	_g_free0 ((*self).stylesheet);
}

static SettingsDaemonBackendsAccentColorManagerTheme*
settings_daemon_backends_accent_color_manager_theme_dup (const SettingsDaemonBackendsAccentColorManagerTheme* self)
{
	SettingsDaemonBackendsAccentColorManagerTheme* dup;
	dup = g_new0 (SettingsDaemonBackendsAccentColorManagerTheme, 1);
	settings_daemon_backends_accent_color_manager_theme_copy (self, dup);
	return dup;
}

static void
settings_daemon_backends_accent_color_manager_theme_free (SettingsDaemonBackendsAccentColorManagerTheme* self)
{
	settings_daemon_backends_accent_color_manager_theme_destroy (self);
	g_free (self);
}

static GType
settings_daemon_backends_accent_color_manager_theme_get_type_once (void)
{
	GType settings_daemon_backends_accent_color_manager_theme_type_id;
	settings_daemon_backends_accent_color_manager_theme_type_id = g_boxed_type_register_static ("SettingsDaemonBackendsAccentColorManagerTheme", (GBoxedCopyFunc) settings_daemon_backends_accent_color_manager_theme_dup, (GBoxedFreeFunc) settings_daemon_backends_accent_color_manager_theme_free);
	return settings_daemon_backends_accent_color_manager_theme_type_id;
}

static GType
settings_daemon_backends_accent_color_manager_theme_get_type (void)
{
	static volatile gsize settings_daemon_backends_accent_color_manager_theme_type_id__once = 0;
	if (g_once_init_enter (&settings_daemon_backends_accent_color_manager_theme_type_id__once)) {
		GType settings_daemon_backends_accent_color_manager_theme_type_id;
		settings_daemon_backends_accent_color_manager_theme_type_id = settings_daemon_backends_accent_color_manager_theme_get_type_once ();
		g_once_init_leave (&settings_daemon_backends_accent_color_manager_theme_type_id__once, settings_daemon_backends_accent_color_manager_theme_type_id);
	}
	return settings_daemon_backends_accent_color_manager_theme_type_id__once;
}

static void
_settings_daemon_backends_accent_color_manager_update_accent_color_g_settings_changed (GSettings* _sender,
                                                                                       const gchar* key,
                                                                                       gpointer self)
{
	settings_daemon_backends_accent_color_manager_update_accent_color ((SettingsDaemonBackendsAccentColorManager*) self);
}

static void
_settings_daemon_backends_accent_color_manager___lambda12_ (SettingsDaemonBackendsAccentColorManager* self,
                                                            GVariant* props)
{
	gint accent_color = 0;
	gint _tmp0_ = 0;
	gboolean _tmp1_;
	g_return_if_fail (props != NULL);
	_tmp1_ = g_variant_lookup (props, "PrefersAccentColor", "i", &_tmp0_, NULL);
	accent_color = _tmp0_;
	if (!_tmp1_) {
		return;
	}
	if (accent_color == 0) {
		GSettings* _tmp2_;
		GSettings* _tmp3_;
		GSettings* _tmp4_;
		_tmp2_ = self->priv->background_settings;
		g_signal_connect_object (_tmp2_, "changed::picture-options", (GCallback) _settings_daemon_backends_accent_color_manager_update_accent_color_g_settings_changed, self, 0);
		_tmp3_ = self->priv->background_settings;
		g_signal_connect_object (_tmp3_, "changed::picture-uri", (GCallback) _settings_daemon_backends_accent_color_manager_update_accent_color_g_settings_changed, self, 0);
		_tmp4_ = self->priv->background_settings;
		g_signal_connect_object (_tmp4_, "changed::primary-color", (GCallback) _settings_daemon_backends_accent_color_manager_update_accent_color_g_settings_changed, self, 0);
		settings_daemon_backends_accent_color_manager_update_accent_color (self);
	} else {
		GSettings* _tmp5_;
		guint _tmp6_;
		GQuark _tmp7_;
		GSettings* _tmp8_;
		guint _tmp9_;
		GQuark _tmp10_;
		GSettings* _tmp11_;
		guint _tmp12_;
		GQuark _tmp13_;
		_tmp5_ = self->priv->background_settings;
		g_signal_parse_name ("changed::picture-options", g_settings_get_type (), &_tmp6_, &_tmp7_, TRUE);
		g_signal_handlers_disconnect_matched (_tmp5_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_DETAIL | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp6_, _tmp7_, NULL, (GCallback) _settings_daemon_backends_accent_color_manager_update_accent_color_g_settings_changed, self);
		_tmp8_ = self->priv->background_settings;
		g_signal_parse_name ("changed::picture-uri", g_settings_get_type (), &_tmp9_, &_tmp10_, TRUE);
		g_signal_handlers_disconnect_matched (_tmp8_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_DETAIL | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp9_, _tmp10_, NULL, (GCallback) _settings_daemon_backends_accent_color_manager_update_accent_color_g_settings_changed, self);
		_tmp11_ = self->priv->background_settings;
		g_signal_parse_name ("changed::primary-color", g_settings_get_type (), &_tmp12_, &_tmp13_, TRUE);
		g_signal_handlers_disconnect_matched (_tmp11_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_DETAIL | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp12_, _tmp13_, NULL, (GCallback) _settings_daemon_backends_accent_color_manager_update_accent_color_g_settings_changed, self);
	}
}

static void
__settings_daemon_backends_accent_color_manager___lambda12__g_dbus_proxy_g_properties_changed (GDBusProxy* _sender,
                                                                                               GVariant* changed_properties,
                                                                                               gchar** invalidated_properties,
                                                                                               gpointer self)
{
	_settings_daemon_backends_accent_color_manager___lambda12_ ((SettingsDaemonBackendsAccentColorManager*) self, changed_properties);
}

static GObject *
settings_daemon_backends_accent_color_manager_constructor (GType type,
                                                           guint n_construct_properties,
                                                           GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	SettingsDaemonBackendsAccentColorManager * self;
	GSettings* _tmp0_;
	GSettings* _tmp1_;
	PantheonAccountsService* _tmp2_;
	PantheonAccountsService* _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	parent_class = G_OBJECT_CLASS (settings_daemon_backends_accent_color_manager_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SETTINGS_DAEMON_BACKENDS_TYPE_ACCENT_COLOR_MANAGER, SettingsDaemonBackendsAccentColorManager);
	_tmp0_ = g_settings_new ("org.gnome.desktop.background");
	_g_object_unref0 (self->priv->background_settings);
	self->priv->background_settings = _tmp0_;
	_tmp1_ = g_settings_new ("org.gnome.desktop.interface");
	_g_object_unref0 (self->priv->interface_settings);
	self->priv->interface_settings = _tmp1_;
	_tmp2_ = self->priv->_accounts_service;
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, g_dbus_proxy_get_type (), GDBusProxy), "g-properties-changed", (GCallback) __settings_daemon_backends_accent_color_manager___lambda12__g_dbus_proxy_g_properties_changed, self, 0);
	_tmp3_ = self->priv->_accounts_service;
	_tmp4_ = pantheon_accounts_service_get_prefers_accent_color (_tmp3_);
	_tmp5_ = _tmp4_;
	if (_tmp5_ == 0) {
		GSettings* _tmp6_;
		GSettings* _tmp7_;
		GSettings* _tmp8_;
		_tmp6_ = self->priv->background_settings;
		g_signal_connect_object (_tmp6_, "changed::picture-options", (GCallback) _settings_daemon_backends_accent_color_manager_update_accent_color_g_settings_changed, self, 0);
		_tmp7_ = self->priv->background_settings;
		g_signal_connect_object (_tmp7_, "changed::picture-uri", (GCallback) _settings_daemon_backends_accent_color_manager_update_accent_color_g_settings_changed, self, 0);
		_tmp8_ = self->priv->background_settings;
		g_signal_connect_object (_tmp8_, "changed::primary-color", (GCallback) _settings_daemon_backends_accent_color_manager_update_accent_color_g_settings_changed, self, 0);
		settings_daemon_backends_accent_color_manager_update_accent_color (self);
	}
	return obj;
}

static void
settings_daemon_backends_accent_color_manager_class_init (SettingsDaemonBackendsAccentColorManagerClass * klass,
                                                          gpointer klass_data)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	GdkRGBA _tmp2_ = {0};
	SettingsDaemonBackendsAccentColorManagerTheme _tmp3_ = {0};
	gchar* _tmp4_;
	gchar* _tmp5_;
	GdkRGBA _tmp6_ = {0};
	SettingsDaemonBackendsAccentColorManagerTheme _tmp7_ = {0};
	gchar* _tmp8_;
	gchar* _tmp9_;
	GdkRGBA _tmp10_ = {0};
	SettingsDaemonBackendsAccentColorManagerTheme _tmp11_ = {0};
	gchar* _tmp12_;
	gchar* _tmp13_;
	GdkRGBA _tmp14_ = {0};
	SettingsDaemonBackendsAccentColorManagerTheme _tmp15_ = {0};
	gchar* _tmp16_;
	gchar* _tmp17_;
	GdkRGBA _tmp18_ = {0};
	SettingsDaemonBackendsAccentColorManagerTheme _tmp19_ = {0};
	gchar* _tmp20_;
	gchar* _tmp21_;
	GdkRGBA _tmp22_ = {0};
	SettingsDaemonBackendsAccentColorManagerTheme _tmp23_ = {0};
	gchar* _tmp24_;
	gchar* _tmp25_;
	GdkRGBA _tmp26_ = {0};
	SettingsDaemonBackendsAccentColorManagerTheme _tmp27_ = {0};
	gchar* _tmp28_;
	gchar* _tmp29_;
	GdkRGBA _tmp30_ = {0};
	SettingsDaemonBackendsAccentColorManagerTheme _tmp31_ = {0};
	gchar* _tmp32_;
	gchar* _tmp33_;
	GdkRGBA _tmp34_ = {0};
	SettingsDaemonBackendsAccentColorManagerTheme _tmp35_ = {0};
	gchar* _tmp36_;
	gchar* _tmp37_;
	GdkRGBA _tmp38_ = {0};
	SettingsDaemonBackendsAccentColorManagerTheme _tmp39_ = {0};
	SettingsDaemonBackendsAccentColorManagerTheme* _tmp40_;
	settings_daemon_backends_accent_color_manager_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &SettingsDaemonBackendsAccentColorManager_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_settings_daemon_backends_accent_color_manager_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_settings_daemon_backends_accent_color_manager_set_property;
	G_OBJECT_CLASS (klass)->constructor = settings_daemon_backends_accent_color_manager_constructor;
	G_OBJECT_CLASS (klass)->finalize = settings_daemon_backends_accent_color_manager_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), SETTINGS_DAEMON_BACKENDS_ACCENT_COLOR_MANAGER_ACCOUNTS_SERVICE_PROPERTY, settings_daemon_backends_accent_color_manager_properties[SETTINGS_DAEMON_BACKENDS_ACCENT_COLOR_MANAGER_ACCOUNTS_SERVICE_PROPERTY] = g_param_spec_object ("accounts-service", "accounts-service", "accounts-service", PANTHEON_TYPE_ACCOUNTS_SERVICE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	_tmp0_ = g_strdup ("Blue");
	_tmp1_ = g_strdup ("io.elementary.stylesheet.blueberry");
	settings_daemon_backends_accent_color_manager_rgba_from_int (0x3689e6, &_tmp2_);
	memset (&_tmp3_, 0, sizeof (SettingsDaemonBackendsAccentColorManagerTheme));
	_g_free0 (_tmp3_.name);
	_tmp3_.name = _tmp0_;
	_g_free0 (_tmp3_.stylesheet);
	_tmp3_.stylesheet = _tmp1_;
	_tmp3_.color = _tmp2_;
	_tmp4_ = g_strdup ("Mint");
	_tmp5_ = g_strdup ("io.elementary.stylesheet.mint");
	settings_daemon_backends_accent_color_manager_rgba_from_int (0x28bca3, &_tmp6_);
	memset (&_tmp7_, 0, sizeof (SettingsDaemonBackendsAccentColorManagerTheme));
	_g_free0 (_tmp7_.name);
	_tmp7_.name = _tmp4_;
	_g_free0 (_tmp7_.stylesheet);
	_tmp7_.stylesheet = _tmp5_;
	_tmp7_.color = _tmp6_;
	_tmp8_ = g_strdup ("Green");
	_tmp9_ = g_strdup ("io.elementary.stylesheet.lime");
	settings_daemon_backends_accent_color_manager_rgba_from_int (0x68b723, &_tmp10_);
	memset (&_tmp11_, 0, sizeof (SettingsDaemonBackendsAccentColorManagerTheme));
	_g_free0 (_tmp11_.name);
	_tmp11_.name = _tmp8_;
	_g_free0 (_tmp11_.stylesheet);
	_tmp11_.stylesheet = _tmp9_;
	_tmp11_.color = _tmp10_;
	_tmp12_ = g_strdup ("Yellow");
	_tmp13_ = g_strdup ("io.elementary.stylesheet.banana");
	settings_daemon_backends_accent_color_manager_rgba_from_int (0xf9c440, &_tmp14_);
	memset (&_tmp15_, 0, sizeof (SettingsDaemonBackendsAccentColorManagerTheme));
	_g_free0 (_tmp15_.name);
	_tmp15_.name = _tmp12_;
	_g_free0 (_tmp15_.stylesheet);
	_tmp15_.stylesheet = _tmp13_;
	_tmp15_.color = _tmp14_;
	_tmp16_ = g_strdup ("Orange");
	_tmp17_ = g_strdup ("io.elementary.stylesheet.orange");
	settings_daemon_backends_accent_color_manager_rgba_from_int (0xffa154, &_tmp18_);
	memset (&_tmp19_, 0, sizeof (SettingsDaemonBackendsAccentColorManagerTheme));
	_g_free0 (_tmp19_.name);
	_tmp19_.name = _tmp16_;
	_g_free0 (_tmp19_.stylesheet);
	_tmp19_.stylesheet = _tmp17_;
	_tmp19_.color = _tmp18_;
	_tmp20_ = g_strdup ("Red");
	_tmp21_ = g_strdup ("io.elementary.stylesheet.strawberry");
	settings_daemon_backends_accent_color_manager_rgba_from_int (0xed5353, &_tmp22_);
	memset (&_tmp23_, 0, sizeof (SettingsDaemonBackendsAccentColorManagerTheme));
	_g_free0 (_tmp23_.name);
	_tmp23_.name = _tmp20_;
	_g_free0 (_tmp23_.stylesheet);
	_tmp23_.stylesheet = _tmp21_;
	_tmp23_.color = _tmp22_;
	_tmp24_ = g_strdup ("Pink");
	_tmp25_ = g_strdup ("io.elementary.stylesheet.bubblegum");
	settings_daemon_backends_accent_color_manager_rgba_from_int (0xde3e80, &_tmp26_);
	memset (&_tmp27_, 0, sizeof (SettingsDaemonBackendsAccentColorManagerTheme));
	_g_free0 (_tmp27_.name);
	_tmp27_.name = _tmp24_;
	_g_free0 (_tmp27_.stylesheet);
	_tmp27_.stylesheet = _tmp25_;
	_tmp27_.color = _tmp26_;
	_tmp28_ = g_strdup ("Purple");
	_tmp29_ = g_strdup ("io.elementary.stylesheet.grape");
	settings_daemon_backends_accent_color_manager_rgba_from_int (0xa56de2, &_tmp30_);
	memset (&_tmp31_, 0, sizeof (SettingsDaemonBackendsAccentColorManagerTheme));
	_g_free0 (_tmp31_.name);
	_tmp31_.name = _tmp28_;
	_g_free0 (_tmp31_.stylesheet);
	_tmp31_.stylesheet = _tmp29_;
	_tmp31_.color = _tmp30_;
	_tmp32_ = g_strdup ("Brown");
	_tmp33_ = g_strdup ("io.elementary.stylesheet.cocoa");
	settings_daemon_backends_accent_color_manager_rgba_from_int (0x8a715e, &_tmp34_);
	memset (&_tmp35_, 0, sizeof (SettingsDaemonBackendsAccentColorManagerTheme));
	_g_free0 (_tmp35_.name);
	_tmp35_.name = _tmp32_;
	_g_free0 (_tmp35_.stylesheet);
	_tmp35_.stylesheet = _tmp33_;
	_tmp35_.color = _tmp34_;
	_tmp36_ = g_strdup ("Gray");
	_tmp37_ = g_strdup ("io.elementary.stylesheet.slate");
	settings_daemon_backends_accent_color_manager_rgba_from_int (0x667885, &_tmp38_);
	memset (&_tmp39_, 0, sizeof (SettingsDaemonBackendsAccentColorManagerTheme));
	_g_free0 (_tmp39_.name);
	_tmp39_.name = _tmp36_;
	_g_free0 (_tmp39_.stylesheet);
	_tmp39_.stylesheet = _tmp37_;
	_tmp39_.color = _tmp38_;
	_tmp40_ = g_new0 (SettingsDaemonBackendsAccentColorManagerTheme, 10);
	_tmp40_[0] = _tmp3_;
	_tmp40_[1] = _tmp7_;
	_tmp40_[2] = _tmp11_;
	_tmp40_[3] = _tmp15_;
	_tmp40_[4] = _tmp19_;
	_tmp40_[5] = _tmp23_;
	_tmp40_[6] = _tmp27_;
	_tmp40_[7] = _tmp31_;
	_tmp40_[8] = _tmp35_;
	_tmp40_[9] = _tmp39_;
	settings_daemon_backends_accent_color_manager_themes = _tmp40_;
	settings_daemon_backends_accent_color_manager_themes_length1 = 10;
	_settings_daemon_backends_accent_color_manager_themes_size_ = settings_daemon_backends_accent_color_manager_themes_length1;
}

static void
settings_daemon_backends_accent_color_manager_instance_init (SettingsDaemonBackendsAccentColorManager * self,
                                                             gpointer klass)
{
	self->priv = settings_daemon_backends_accent_color_manager_get_instance_private (self);
}

static void
settings_daemon_backends_accent_color_manager_finalize (GObject * obj)
{
	SettingsDaemonBackendsAccentColorManager * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SETTINGS_DAEMON_BACKENDS_TYPE_ACCENT_COLOR_MANAGER, SettingsDaemonBackendsAccentColorManager);
	_g_object_unref0 (self->priv->background_settings);
	_g_object_unref0 (self->priv->interface_settings);
	G_OBJECT_CLASS (settings_daemon_backends_accent_color_manager_parent_class)->finalize (obj);
}

static GType
settings_daemon_backends_accent_color_manager_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SettingsDaemonBackendsAccentColorManagerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) settings_daemon_backends_accent_color_manager_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SettingsDaemonBackendsAccentColorManager), 0, (GInstanceInitFunc) settings_daemon_backends_accent_color_manager_instance_init, NULL };
	GType settings_daemon_backends_accent_color_manager_type_id;
	settings_daemon_backends_accent_color_manager_type_id = g_type_register_static (G_TYPE_OBJECT, "SettingsDaemonBackendsAccentColorManager", &g_define_type_info, 0);
	SettingsDaemonBackendsAccentColorManager_private_offset = g_type_add_instance_private (settings_daemon_backends_accent_color_manager_type_id, sizeof (SettingsDaemonBackendsAccentColorManagerPrivate));
	return settings_daemon_backends_accent_color_manager_type_id;
}

GType
settings_daemon_backends_accent_color_manager_get_type (void)
{
	static volatile gsize settings_daemon_backends_accent_color_manager_type_id__once = 0;
	if (g_once_init_enter (&settings_daemon_backends_accent_color_manager_type_id__once)) {
		GType settings_daemon_backends_accent_color_manager_type_id;
		settings_daemon_backends_accent_color_manager_type_id = settings_daemon_backends_accent_color_manager_get_type_once ();
		g_once_init_leave (&settings_daemon_backends_accent_color_manager_type_id__once, settings_daemon_backends_accent_color_manager_type_id);
	}
	return settings_daemon_backends_accent_color_manager_type_id__once;
}

static void
_vala_settings_daemon_backends_accent_color_manager_get_property (GObject * object,
                                                                  guint property_id,
                                                                  GValue * value,
                                                                  GParamSpec * pspec)
{
	SettingsDaemonBackendsAccentColorManager * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SETTINGS_DAEMON_BACKENDS_TYPE_ACCENT_COLOR_MANAGER, SettingsDaemonBackendsAccentColorManager);
	switch (property_id) {
		case SETTINGS_DAEMON_BACKENDS_ACCENT_COLOR_MANAGER_ACCOUNTS_SERVICE_PROPERTY:
		g_value_set_object (value, settings_daemon_backends_accent_color_manager_get_accounts_service (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_settings_daemon_backends_accent_color_manager_set_property (GObject * object,
                                                                  guint property_id,
                                                                  const GValue * value,
                                                                  GParamSpec * pspec)
{
	SettingsDaemonBackendsAccentColorManager * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SETTINGS_DAEMON_BACKENDS_TYPE_ACCENT_COLOR_MANAGER, SettingsDaemonBackendsAccentColorManager);
	switch (property_id) {
		case SETTINGS_DAEMON_BACKENDS_ACCENT_COLOR_MANAGER_ACCOUNTS_SERVICE_PROPERTY:
		settings_daemon_backends_accent_color_manager_set_accounts_service (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

