// ClientServer wrapper for vtkBoundaryMeshQuality object
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkBoundaryMeshQuality.h"
#include "vtkSystemIncludes.h"
#include "vtkClientServerInterpreter.h"
#include "vtkClientServerStream.h"


static vtkObjectBase *vtkBoundaryMeshQualityClientServerNewCommand(void* /*ctx*/)
{
  return vtkBoundaryMeshQuality::New();
}


static int vtkBoundaryMeshQualityCommand(
  vtkClientServerInterpreter *arlu, vtkObjectBase *ob,
  const char *method, const vtkClientServerStream& msg,
  vtkClientServerStream& resultStream, void* /*ctx*/)
{
  vtkBoundaryMeshQuality *op = vtkBoundaryMeshQuality::SafeDownCast(ob);
  if(!op)
    {
    vtkOStrStreamWrapper vtkmsg;
    vtkmsg << "Cannot cast " << ob->GetClassName() << " object to vtkBoundaryMeshQuality.  "
           << "This probably means the class specifies the incorrect superclass in vtkTypeMacro.";
    resultStream.Reset();
    resultStream << vtkClientServerStream::Error
                 << vtkmsg.str() << 0 << vtkClientServerStream::End;
    return 0;
    }
  (void)arlu;
  if (!strcmp("New",method) && msg.GetNumberOfArguments(0) == 2)
    {
    vtkBoundaryMeshQuality  *temp20;
      {
      temp20 = vtkBoundaryMeshQuality::New();
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << (vtkObjectBase *)temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("IsTypeOf",method) && msg.GetNumberOfArguments(0) == 3)
    {
    char    *temp0;
    int      temp20;
    if(msg.GetArgument(0, 2, &temp0))
      {
      temp20 = vtkBoundaryMeshQuality::IsTypeOf(temp0);
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("IsA",method) && msg.GetNumberOfArguments(0) == 3)
    {
    char    *temp0;
    int      temp20;
    if(msg.GetArgument(0, 2, &temp0))
      {
      temp20 = (op)->IsA(temp0);
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("SafeDownCast",method) && msg.GetNumberOfArguments(0) == 3)
    {
    vtkObjectBase  *temp0;
    vtkBoundaryMeshQuality  *temp20;
    if(vtkClientServerStreamGetArgumentObject(msg, 0, 2, &temp0, "vtkObjectBase"))
      {
      temp20 = vtkBoundaryMeshQuality::SafeDownCast(temp0);
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << (vtkObjectBase *)temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("NewInstance",method) && msg.GetNumberOfArguments(0) == 2)
    {
    vtkBoundaryMeshQuality  *temp20;
      {
      temp20 = (op)->NewInstance();
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << (vtkObjectBase *)temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("GetNumberOfGenerationsFromBaseType",method) && msg.GetNumberOfArguments(0) == 3)
    {
    char    *temp0;
    long long   temp20;
    if(msg.GetArgument(0, 2, &temp0))
      {
      temp20 = vtkBoundaryMeshQuality::GetNumberOfGenerationsFromBaseType(temp0);
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("GetNumberOfGenerationsFromBase",method) && msg.GetNumberOfArguments(0) == 3)
    {
    char    *temp0;
    long long   temp20;
    if(msg.GetArgument(0, 2, &temp0))
      {
      temp20 = (op)->GetNumberOfGenerationsFromBase(temp0);
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("SetDistanceFromCellCenterToFaceCenter",method) && msg.GetNumberOfArguments(0) == 3)
    {
    bool   temp0;
    if(msg.GetArgument(0, 2, &temp0))
      {
      op->SetDistanceFromCellCenterToFaceCenter(temp0);
      return 1;
      }
    }
  if (!strcmp("GetDistanceFromCellCenterToFaceCenter",method) && msg.GetNumberOfArguments(0) == 2)
    {
    bool   temp20;
      {
      temp20 = (op)->GetDistanceFromCellCenterToFaceCenter();
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("DistanceFromCellCenterToFaceCenterOn",method) && msg.GetNumberOfArguments(0) == 2)
    {
      {
      op->DistanceFromCellCenterToFaceCenterOn();
      return 1;
      }
    }
  if (!strcmp("DistanceFromCellCenterToFaceCenterOff",method) && msg.GetNumberOfArguments(0) == 2)
    {
      {
      op->DistanceFromCellCenterToFaceCenterOff();
      return 1;
      }
    }
  if (!strcmp("SetDistanceFromCellCenterToFacePlane",method) && msg.GetNumberOfArguments(0) == 3)
    {
    bool   temp0;
    if(msg.GetArgument(0, 2, &temp0))
      {
      op->SetDistanceFromCellCenterToFacePlane(temp0);
      return 1;
      }
    }
  if (!strcmp("GetDistanceFromCellCenterToFacePlane",method) && msg.GetNumberOfArguments(0) == 2)
    {
    bool   temp20;
      {
      temp20 = (op)->GetDistanceFromCellCenterToFacePlane();
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("DistanceFromCellCenterToFacePlaneOn",method) && msg.GetNumberOfArguments(0) == 2)
    {
      {
      op->DistanceFromCellCenterToFacePlaneOn();
      return 1;
      }
    }
  if (!strcmp("DistanceFromCellCenterToFacePlaneOff",method) && msg.GetNumberOfArguments(0) == 2)
    {
      {
      op->DistanceFromCellCenterToFacePlaneOff();
      return 1;
      }
    }
  if (!strcmp("SetAngleFaceNormalAndCellCenterToFaceCenterVector",method) && msg.GetNumberOfArguments(0) == 3)
    {
    bool   temp0;
    if(msg.GetArgument(0, 2, &temp0))
      {
      op->SetAngleFaceNormalAndCellCenterToFaceCenterVector(temp0);
      return 1;
      }
    }
  if (!strcmp("GetAngleFaceNormalAndCellCenterToFaceCenterVector",method) && msg.GetNumberOfArguments(0) == 2)
    {
    bool   temp20;
      {
      temp20 = (op)->GetAngleFaceNormalAndCellCenterToFaceCenterVector();
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("AngleFaceNormalAndCellCenterToFaceCenterVectorOn",method) && msg.GetNumberOfArguments(0) == 2)
    {
      {
      op->AngleFaceNormalAndCellCenterToFaceCenterVectorOn();
      return 1;
      }
    }
  if (!strcmp("AngleFaceNormalAndCellCenterToFaceCenterVectorOff",method) && msg.GetNumberOfArguments(0) == 2)
    {
      {
      op->AngleFaceNormalAndCellCenterToFaceCenterVectorOff();
      return 1;
      }
    }

  {
    const char* commandName = "vtkPolyDataAlgorithm";
    if (arlu->HasCommandFunction(commandName) &&
        arlu->CallCommandFunction(commandName, op, method, msg, resultStream)) { return 1; }
  }
  if(resultStream.GetNumberOfMessages() > 0 &&
     resultStream.GetCommand(0) == vtkClientServerStream::Error &&
     resultStream.GetNumberOfArguments(0) > 1)
    {
    /* A superclass wrapper prepared a special message. */
    return 0;
    }
  vtkOStrStreamWrapper vtkmsg;
  vtkmsg << "Object type: vtkBoundaryMeshQuality, could not find requested method: \""
         << method << "\"\nor the method was called with incorrect arguments.\n";
  resultStream.Reset();
  resultStream << vtkClientServerStream::Error
               << vtkmsg.str() << vtkClientServerStream::End;
  vtkmsg.rdbuf()->freeze(0);
  return 0;
}


//-------------------------------------------------------------------------auto
extern "C"
{
VTK_ABI_HIDDEN void vtkBoundaryMeshQuality_Init(vtkClientServerInterpreter* csi)
{
  static vtkClientServerInterpreter* last = nullptr;
  if(last != csi)
    {
    last = csi;
    csi->AddNewInstanceFunction("vtkBoundaryMeshQuality", vtkBoundaryMeshQualityClientServerNewCommand);
    csi->AddCommandFunction("vtkBoundaryMeshQuality", vtkBoundaryMeshQualityCommand);
    }
}
}
