/* Unity.c generated by valac 0.56.17, the Vala compiler
 * generated from Unity.vala, do not modify */

/**/
/*  Copyright (C) 2015 Rico Tzschichholz*/
/**/
/*  This file is part of Plank.*/
/**/
/*  Plank is free software: you can redistribute it and/or modify*/
/*  it under the terms of the GNU General Public License as published by*/
/*  the Free Software Foundation, either version 3 of the License, or*/
/*  (at your option) any later version.*/
/**/
/*  Plank is distributed in the hope that it will be useful,*/
/*  but WITHOUT ANY WARRANTY; without even the implied warranty of*/
/*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the*/
/*  GNU General Public License for more details.*/
/**/
/*  You should have received a copy of the GNU General Public License*/
/*  along with this program.  If not, see <http://www.gnu.org/licenses/>.*/
/**/

#include "plank.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gee.h>
#include <glib-object.h>
#include <gio/gio.h>
#include "plank-internal.h"
#include <gobject/gvaluecollector.h>

#define PLANK_UNITY_DBUS_NAME "com.canonical.Unity"
#define PLANK_UNITY_INTERFACE_NAME "com.canonical.Unity.LauncherEntry"
#define PLANK_UNITY_SIGNAL_NAME "Update"
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define PLANK_UNITY_TYPE_LAUNCHER_ENTRY (plank_unity_launcher_entry_get_type ())
#define PLANK_UNITY_LAUNCHER_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PLANK_UNITY_TYPE_LAUNCHER_ENTRY, PlankUnityLauncherEntry))
#define PLANK_UNITY_LAUNCHER_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), PLANK_UNITY_TYPE_LAUNCHER_ENTRY, PlankUnityLauncherEntryClass))
#define PLANK_UNITY_IS_LAUNCHER_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PLANK_UNITY_TYPE_LAUNCHER_ENTRY))
#define PLANK_UNITY_IS_LAUNCHER_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), PLANK_UNITY_TYPE_LAUNCHER_ENTRY))
#define PLANK_UNITY_LAUNCHER_ENTRY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), PLANK_UNITY_TYPE_LAUNCHER_ENTRY, PlankUnityLauncherEntryClass))

typedef struct _PlankUnityLauncherEntry PlankUnityLauncherEntry;
typedef struct _PlankUnityLauncherEntryClass PlankUnityLauncherEntryClass;
enum  {
	PLANK_UNITY_0_PROPERTY,
	PLANK_UNITY_NUM_PROPERTIES
};
static GParamSpec* plank_unity_properties[PLANK_UNITY_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _Block14Data Block14Data;
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _Block15Data Block15Data;
#define _plank_unity_launcher_entry_unref0(var) ((var == NULL) ? NULL : (var = (plank_unity_launcher_entry_unref (var), NULL)))
typedef struct _PlankUnityLauncherEntryPrivate PlankUnityLauncherEntryPrivate;
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
typedef struct _Block16Data Block16Data;
typedef struct _PlankUnityParamSpecLauncherEntry PlankUnityParamSpecLauncherEntry;
#define _g_variant_type_free0(var) ((var == NULL) ? NULL : (var = (g_variant_type_free (var), NULL)))

struct _PlankUnityPrivate {
	GeeHashSet* clients;
	guint launcher_entry_dbus_signal_id;
	guint dbus_name_owner_changed_signal_id;
	GeeHashMap* launcher_entries;
	guint launcher_entries_timer_id;
};

struct _Block14Data {
	int _ref_count_;
	PlankUnity* self;
	gchar* name;
};

struct _Block15Data {
	int _ref_count_;
	PlankUnity* self;
	PlankUnityLauncherEntry* entry;
};

struct _PlankUnityLauncherEntry {
	GTypeInstance parent_instance;
	volatile int ref_count;
	PlankUnityLauncherEntryPrivate * priv;
	guint fast_count;
	gint64 last_update;
	gchar* sender_name;
	GVariant* parameters;
	guint timer_id;
	gboolean warned;
};

struct _PlankUnityLauncherEntryClass {
	GTypeClass parent_class;
	void (*finalize) (PlankUnityLauncherEntry *self);
};

struct _Block16Data {
	int _ref_count_;
	PlankUnity* self;
	gchar* sender_name;
	GVariant* parameters;
};

struct _PlankUnityParamSpecLauncherEntry {
	GParamSpec parent_instance;
};

static gint PlankUnity_private_offset;
static gpointer plank_unity_parent_class = NULL;
static guint plank_unity_unity_bus_id;
static GDBusConnection* plank_unity_connection;
static PlankUnity* plank_unity_instance;
static PlankUnity* plank_unity_instance = NULL;
static GDBusConnection* plank_unity_connection = NULL;
static guint plank_unity_unity_bus_id = 0U;
static GVariantType* plank_unity_payload_variant_type;
static GVariantType* plank_unity_payload_variant_type = NULL;
static gpointer plank_unity_launcher_entry_parent_class = NULL;

static GType plank_unity_client_get_type_once (void);
static gpointer plank_unity_launcher_entry_ref (gpointer instance);
static void plank_unity_launcher_entry_unref (gpointer instance);
static GParamSpec* plank_unity_param_spec_launcher_entry (const gchar* name,
                                                   const gchar* nick,
                                                   const gchar* blurb,
                                                   GType object_type,
                                                   GParamFlags flags) G_GNUC_UNUSED ;
static void plank_unity_value_set_launcher_entry (GValue* value,
                                           gpointer v_object) G_GNUC_UNUSED ;
static void plank_unity_value_take_launcher_entry (GValue* value,
                                            gpointer v_object) G_GNUC_UNUSED ;
static gpointer plank_unity_value_get_launcher_entry (const GValue* value) G_GNUC_UNUSED ;
static GType plank_unity_launcher_entry_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
static PlankUnity* plank_unity_new (void);
static PlankUnity* plank_unity_construct (GType object_type);
static void plank_unity_acquire_unity_dbus (void);
static void plank_unity_handle_bus_acquired (GDBusConnection* conn,
                                      const gchar* name);
static void plank_unity_handle_name_acquired (GDBusConnection* conn,
                                       const gchar* name);
static void plank_unity_handle_name_lost (GDBusConnection* conn,
                                   const gchar* name);
static void plank_unity_release_unity_dbus (void);
static void plank_unity_handle_entry_signal (GDBusConnection* connection,
                                      const gchar* sender_name,
                                      const gchar* object_path,
                                      const gchar* interface_name,
                                      const gchar* signal_name,
                                      GVariant* parameters,
                                      PlankUnity* self);
static void plank_unity_handle_update_request (PlankUnity* self,
                                        const gchar* sender_name,
                                        GVariant* parameters);
static void plank_unity_handle_name_owner_changed (GDBusConnection* connection,
                                            const gchar* sender_name,
                                            const gchar* object_path,
                                            const gchar* interface_name,
                                            const gchar* signal_name,
                                            GVariant* parameters,
                                            PlankUnity* self);
static Block14Data* block14_data_ref (Block14Data* _data14_);
static void block14_data_unref (void * _userdata_);
static gboolean __lambda63_ (Block14Data* _data14_,
                      PlankUnityClient* client);
static gboolean ___lambda63__gee_forall_func (gpointer g,
                                       gpointer self);
static Block15Data* block15_data_ref (Block15Data* _data15_);
static void block15_data_unref (void * _userdata_);
static gboolean _____lambda61_ (Block15Data* _data15_);
static void plank_unity_perform_update (PlankUnity* self,
                                 const gchar* sender_name,
                                 GVariant* parameters);
static gboolean ______lambda61__gsource_func (gpointer self);
static PlankUnityLauncherEntry* plank_unity_launcher_entry_new (void);
static PlankUnityLauncherEntry* plank_unity_launcher_entry_construct (GType object_type);
static gboolean plank_unity_clean_up_launcher_entries (PlankUnity* self);
static Block16Data* block16_data_ref (Block16Data* _data16_);
static void block16_data_unref (void * _userdata_);
static gboolean __lambda62_ (Block16Data* _data16_,
                      PlankUnityClient* client);
static gboolean ___lambda62__gee_forall_func (gpointer g,
                                       gpointer self);
static void plank_unity_launcher_entry_finalize (PlankUnityLauncherEntry * obj);
static GType plank_unity_launcher_entry_get_type_once (void);
static GObject * plank_unity_constructor (GType type,
                                   guint n_construct_properties,
                                   GObjectConstructParam * construct_properties);
static void plank_unity_finalize (GObject * obj);
static GType plank_unity_get_type_once (void);

/**
 * The LauncherEntry corresponding to the sender_name requested an update
 *
 * @param sender_name the dbusname
 * @param parameters the data in a standardize format '(sa{sv})' from libunity
 * @param is_retry whether this data was already processed before and decided to give is another run
 */
void
plank_unity_client_update_launcher_entry (PlankUnityClient* self,
                                          const gchar* sender_name,
                                          GVariant* parameters,
                                          gboolean is_retry)
{
	PlankUnityClientIface* _iface_;
	g_return_if_fail (self != NULL);
	_iface_ = PLANK_UNITY_CLIENT_GET_INTERFACE (self);
	if (_iface_->update_launcher_entry) {
		_iface_->update_launcher_entry (self, sender_name, parameters, is_retry);
	}
}

/**
 * The LauncherEntry corresponding to the sender_name vanished
 *
 * @param sender_name the dbusname
 */
void
plank_unity_client_remove_launcher_entry (PlankUnityClient* self,
                                          const gchar* sender_name)
{
	PlankUnityClientIface* _iface_;
	g_return_if_fail (self != NULL);
	_iface_ = PLANK_UNITY_CLIENT_GET_INTERFACE (self);
	if (_iface_->remove_launcher_entry) {
		_iface_->remove_launcher_entry (self, sender_name);
	}
}

static void
plank_unity_client_default_init (PlankUnityClientIface * iface,
                                 gpointer iface_data)
{
}

/**
 * The interface to provide the LauncherEntry handling.
 */
static GType
plank_unity_client_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (PlankUnityClientIface), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) plank_unity_client_default_init, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
	GType plank_unity_client_type_id;
	plank_unity_client_type_id = g_type_register_static (G_TYPE_INTERFACE, "PlankUnityClient", &g_define_type_info, 0);
	g_type_interface_add_prerequisite (plank_unity_client_type_id, G_TYPE_OBJECT);
	return plank_unity_client_type_id;
}

GType
plank_unity_client_get_type (void)
{
	static volatile gsize plank_unity_client_type_id__once = 0;
	if (g_once_init_enter (&plank_unity_client_type_id__once)) {
		GType plank_unity_client_type_id;
		plank_unity_client_type_id = plank_unity_client_get_type_once ();
		g_once_init_leave (&plank_unity_client_type_id__once, plank_unity_client_type_id);
	}
	return plank_unity_client_type_id__once;
}

static inline gpointer
plank_unity_get_instance_private (PlankUnity* self)
{
	return G_STRUCT_MEMBER_P (self, PlankUnity_private_offset);
}

PlankUnity*
plank_unity_get_default (void)
{
	PlankUnity* _tmp0_;
	PlankUnity* _tmp2_;
	PlankUnity* result;
	_tmp0_ = plank_unity_instance;
	if (_tmp0_ == NULL) {
		PlankUnity* _tmp1_;
		_tmp1_ = plank_unity_new ();
		_g_object_unref0 (plank_unity_instance);
		plank_unity_instance = _tmp1_;
	}
	_tmp2_ = plank_unity_instance;
	result = _tmp2_;
	return result;
}

/**
 * Connect DBus connection and try to aquire unity busname
 */
static void
plank_unity_acquire_unity_dbus (void)
{
	GError* _inner_error0_ = NULL;
	{
		GDBusConnection* _tmp0_;
		_tmp0_ = plank_unity_connection;
		if (_tmp0_ == NULL) {
			GDBusConnection* _tmp1_ = NULL;
			GDBusConnection* _tmp2_;
			GDBusConnection* _tmp3_;
			_tmp2_ = g_bus_get_sync (G_BUS_TYPE_SESSION, NULL, &_inner_error0_);
			_tmp1_ = _tmp2_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
			_tmp3_ = _tmp1_;
			_tmp1_ = NULL;
			_g_object_unref0 (plank_unity_connection);
			plank_unity_connection = _tmp3_;
			_g_object_unref0 (_tmp1_);
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp4_;
		const gchar* _tmp5_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp4_ = e;
		_tmp5_ = _tmp4_->message;
		g_warning ("Unity.vala:92: %s", _tmp5_);
		_g_error_free0 (e);
		return;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	if (plank_unity_unity_bus_id == 0U) {
		plank_unity_unity_bus_id = g_bus_own_name_with_closures (G_BUS_TYPE_SESSION, PLANK_UNITY_DBUS_NAME, G_BUS_NAME_OWNER_FLAGS_ALLOW_REPLACEMENT, (GClosure*) g_cclosure_new ((GCallback) ((GBusAcquiredCallback) plank_unity_handle_bus_acquired), NULL, (GClosureNotify) NULL), (GClosure*) g_cclosure_new ((GCallback) ((GBusNameAcquiredCallback) plank_unity_handle_name_acquired), NULL, (GClosureNotify) NULL), (GClosure*) g_cclosure_new ((GCallback) ((GBusNameLostCallback) plank_unity_handle_name_lost), NULL, (GClosureNotify) NULL));
	}
}

/**
 * Disconnect DBus connection and release unity busname
 */
static void
plank_unity_release_unity_dbus (void)
{
	GDBusConnection* _tmp0_;
	GError* _inner_error0_ = NULL;
	if (plank_unity_unity_bus_id > 0U) {
		g_bus_unown_name (plank_unity_unity_bus_id);
		plank_unity_unity_bus_id = 0U;
	}
	_tmp0_ = plank_unity_connection;
	if (_tmp0_ != NULL) {
		{
			GDBusConnection* _tmp1_;
			GDBusConnection* _tmp2_;
			_tmp1_ = plank_unity_connection;
			g_dbus_connection_flush_sync (_tmp1_, NULL, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
			_tmp2_ = plank_unity_connection;
			g_dbus_connection_close_sync (_tmp2_, NULL, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
		}
		goto __finally0;
		__catch0_g_error:
		{
			GError* e = NULL;
			GError* _tmp3_;
			const gchar* _tmp4_;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp3_ = e;
			_tmp4_ = _tmp3_->message;
			g_warning ("Unity.vala:119: %s", _tmp4_);
			_g_error_free0 (e);
		}
		__finally0:
		{
			GError* _inner_error1_ = NULL;
			_g_object_unref0 (plank_unity_connection);
			plank_unity_connection = NULL;
		}
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
}

static void
plank_unity_handle_bus_acquired (GDBusConnection* conn,
                                 const gchar* name)
{
	g_return_if_fail (conn != NULL);
	g_return_if_fail (name != NULL);
}

static void
plank_unity_handle_name_acquired (GDBusConnection* conn,
                                  const gchar* name)
{
	g_return_if_fail (conn != NULL);
	g_return_if_fail (name != NULL);
	g_debug ("Unity.vala:133: %s acquired", name);
}

static void
plank_unity_handle_name_lost (GDBusConnection* conn,
                              const gchar* name)
{
	g_return_if_fail (conn != NULL);
	g_return_if_fail (name != NULL);
	if (conn == NULL) {
		g_warning ("Unity.vala:139: %s failed", name);
	} else {
		g_debug ("Unity.vala:141: %s lost", name);
	}
}

static PlankUnity*
plank_unity_construct (GType object_type)
{
	PlankUnity * self = NULL;
	self = (PlankUnity*) g_object_new (object_type, NULL);
	return self;
}

static PlankUnity*
plank_unity_new (void)
{
	return plank_unity_construct (PLANK_TYPE_UNITY);
}

/**
 * Add a client which will receive all update requests of running LauncherEntry applications.
 *
 * @param client the client to add
 */
void
plank_unity_add_client (PlankUnity* self,
                        PlankUnityClient* client)
{
	GeeHashSet* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (client != NULL);
	_tmp0_ = self->priv->clients;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp0_, client);
}

/**
 * Remove a client.
 *
 * @param client the client to remove
 */
void
plank_unity_remove_client (PlankUnity* self,
                           PlankUnityClient* client)
{
	GeeHashSet* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (client != NULL);
	_tmp0_ = self->priv->clients;
	gee_abstract_collection_remove ((GeeAbstractCollection*) _tmp0_, client);
}

static void
plank_unity_handle_entry_signal (GDBusConnection* connection,
                                 const gchar* sender_name,
                                 const gchar* object_path,
                                 const gchar* interface_name,
                                 const gchar* signal_name,
                                 GVariant* parameters,
                                 PlankUnity* self)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (connection != NULL);
	g_return_if_fail (sender_name != NULL);
	g_return_if_fail (object_path != NULL);
	g_return_if_fail (interface_name != NULL);
	g_return_if_fail (signal_name != NULL);
	g_return_if_fail (parameters != NULL);
	if (parameters == NULL) {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = signal_name == NULL;
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = sender_name == NULL;
	}
	if (_tmp0_) {
		return;
	}
	if (g_strcmp0 (signal_name, PLANK_UNITY_SIGNAL_NAME) == 0) {
		plank_unity_handle_update_request (self, sender_name, parameters);
	}
}

static Block14Data*
block14_data_ref (Block14Data* _data14_)
{
	g_atomic_int_inc (&_data14_->_ref_count_);
	return _data14_;
}

static void
block14_data_unref (void * _userdata_)
{
	Block14Data* _data14_;
	_data14_ = (Block14Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data14_->_ref_count_)) {
		PlankUnity* self;
		self = _data14_->self;
		_g_free0 (_data14_->name);
		_g_object_unref0 (self);
		g_slice_free (Block14Data, _data14_);
	}
}

static gboolean
__lambda63_ (Block14Data* _data14_,
             PlankUnityClient* client)
{
	PlankUnity* self;
	const gchar* _tmp0_;
	gboolean result;
	self = _data14_->self;
	g_return_val_if_fail (client != NULL, FALSE);
	_tmp0_ = _data14_->name;
	plank_unity_client_remove_launcher_entry (client, _tmp0_);
	result = TRUE;
	_g_object_unref0 (client);
	return result;
}

static gboolean
___lambda63__gee_forall_func (gpointer g,
                              gpointer self)
{
	gboolean result;
	result = __lambda63_ (self, (PlankUnityClient*) g);
	return result;
}

static void
plank_unity_handle_name_owner_changed (GDBusConnection* connection,
                                       const gchar* sender_name,
                                       const gchar* object_path,
                                       const gchar* interface_name,
                                       const gchar* signal_name,
                                       GVariant* parameters,
                                       PlankUnity* self)
{
	Block14Data* _data14_;
	gchar* before = NULL;
	gchar* after = NULL;
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
	const gchar* _tmp4_;
	GeeHashSet* _tmp6_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (connection != NULL);
	g_return_if_fail (sender_name != NULL);
	g_return_if_fail (object_path != NULL);
	g_return_if_fail (interface_name != NULL);
	g_return_if_fail (signal_name != NULL);
	g_return_if_fail (parameters != NULL);
	_data14_ = g_slice_new0 (Block14Data);
	_data14_->_ref_count_ = 1;
	_data14_->self = g_object_ref (self);
	g_variant_get (parameters, "(sss)", &_tmp0_, &_tmp1_, &_tmp2_, NULL);
	_g_free0 (_data14_->name);
	_data14_->name = _tmp0_;
	_g_free0 (before);
	before = _tmp1_;
	_g_free0 (after);
	after = _tmp2_;
	_tmp4_ = after;
	if (_tmp4_ != NULL) {
		const gchar* _tmp5_;
		_tmp5_ = after;
		_tmp3_ = g_strcmp0 (_tmp5_, "") != 0;
	} else {
		_tmp3_ = FALSE;
	}
	if (_tmp3_) {
		_g_free0 (after);
		_g_free0 (before);
		block14_data_unref (_data14_);
		_data14_ = NULL;
		return;
	}
	_tmp6_ = self->priv->clients;
	gee_abstract_collection_foreach ((GeeAbstractCollection*) _tmp6_, ___lambda63__gee_forall_func, _data14_);
	_g_free0 (after);
	_g_free0 (before);
	block14_data_unref (_data14_);
	_data14_ = NULL;
}

static Block15Data*
block15_data_ref (Block15Data* _data15_)
{
	g_atomic_int_inc (&_data15_->_ref_count_);
	return _data15_;
}

static void
block15_data_unref (void * _userdata_)
{
	Block15Data* _data15_;
	_data15_ = (Block15Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data15_->_ref_count_)) {
		PlankUnity* self;
		self = _data15_->self;
		_plank_unity_launcher_entry_unref0 (_data15_->entry);
		_g_object_unref0 (self);
		g_slice_free (Block15Data, _data15_);
	}
}

static gpointer
_g_variant_ref0 (gpointer self)
{
	return self ? g_variant_ref (self) : NULL;
}

static gboolean
_____lambda61_ (Block15Data* _data15_)
{
	PlankUnity* self;
	PlankUnityLauncherEntry* _tmp0_;
	PlankUnityLauncherEntry* _tmp1_;
	PlankUnityLauncherEntry* _tmp2_;
	const gchar* _tmp3_;
	PlankUnityLauncherEntry* _tmp4_;
	GVariant* _tmp5_;
	gboolean result;
	self = _data15_->self;
	_tmp0_ = _data15_->entry;
	_tmp0_->timer_id = 0U;
	_tmp1_ = _data15_->entry;
	_tmp1_->last_update = g_get_monotonic_time ();
	_tmp2_ = _data15_->entry;
	_tmp3_ = _tmp2_->sender_name;
	_tmp4_ = _data15_->entry;
	_tmp5_ = _tmp4_->parameters;
	plank_unity_perform_update (self, _tmp3_, _tmp5_);
	result = FALSE;
	return result;
}

static gboolean
______lambda61__gsource_func (gpointer self)
{
	gboolean result;
	result = _____lambda61_ (self);
	return result;
}

static void
plank_unity_handle_update_request (PlankUnity* self,
                                   const gchar* sender_name,
                                   GVariant* parameters)
{
	Block15Data* _data15_;
	gint64 current_time = 0LL;
	GeeHashMap* _tmp0_;
	gpointer _tmp1_;
	PlankUnityLauncherEntry* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (sender_name != NULL);
	g_return_if_fail (parameters != NULL);
	_data15_ = g_slice_new0 (Block15Data);
	_data15_->_ref_count_ = 1;
	_data15_->self = g_object_ref (self);
	current_time = g_get_monotonic_time ();
	_tmp0_ = self->priv->launcher_entries;
	_tmp1_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp0_, sender_name);
	_plank_unity_launcher_entry_unref0 (_data15_->entry);
	_data15_->entry = (PlankUnityLauncherEntry*) _tmp1_;
	_tmp2_ = _data15_->entry;
	if (_tmp2_ != NULL) {
		PlankUnityLauncherEntry* _tmp3_;
		GVariant* _tmp4_;
		gboolean _tmp5_ = FALSE;
		PlankUnityLauncherEntry* _tmp6_;
		_tmp3_ = _data15_->entry;
		_tmp4_ = _g_variant_ref0 (parameters);
		_g_variant_unref0 (_tmp3_->parameters);
		_tmp3_->parameters = _tmp4_;
		_tmp6_ = _data15_->entry;
		if ((current_time - _tmp6_->last_update) < ((gint64) (PLANK_UNITY_UPDATE_THRESHOLD_DURATION * 1000))) {
			PlankUnityLauncherEntry* _tmp7_;
			_tmp7_ = _data15_->entry;
			_tmp5_ = _tmp7_->fast_count > PLANK_UNITY_UPDATE_THRESHOLD_FAST_COUNT;
		} else {
			_tmp5_ = FALSE;
		}
		if (_tmp5_) {
			PlankUnityLauncherEntry* _tmp8_;
			_tmp8_ = _data15_->entry;
			if (_tmp8_->timer_id <= 0U) {
				PlankUnityLauncherEntry* _tmp9_;
				PlankUnityLauncherEntry* _tmp11_;
				_tmp9_ = _data15_->entry;
				if (!_tmp9_->warned) {
					PlankUnityLauncherEntry* _tmp10_;
					g_warning ("Unity.vala:249: LauncherEntry '%s' is behaving badly, skipping request" \
"s", sender_name);
					_tmp10_ = _data15_->entry;
					_tmp10_->warned = TRUE;
				}
				_tmp11_ = _data15_->entry;
				_tmp11_->timer_id = g_timeout_add_full (G_PRIORITY_DEFAULT, PLANK_UNITY_UPDATE_THRESHOLD_DURATION, ______lambda61__gsource_func, block15_data_ref (_data15_), block15_data_unref);
			}
		} else {
			PlankUnityLauncherEntry* _tmp12_;
			guint _tmp13_;
			PlankUnityLauncherEntry* _tmp14_;
			PlankUnityLauncherEntry* _tmp15_;
			const gchar* _tmp16_;
			PlankUnityLauncherEntry* _tmp17_;
			GVariant* _tmp18_;
			_tmp12_ = _data15_->entry;
			_tmp13_ = _tmp12_->fast_count;
			_tmp12_->fast_count = _tmp13_ + 1;
			_tmp14_ = _data15_->entry;
			_tmp14_->last_update = current_time;
			_tmp15_ = _data15_->entry;
			_tmp16_ = _tmp15_->sender_name;
			_tmp17_ = _data15_->entry;
			_tmp18_ = _tmp17_->parameters;
			plank_unity_perform_update (self, _tmp16_, _tmp18_);
		}
	} else {
		PlankUnityLauncherEntry* _tmp19_;
		PlankUnityLauncherEntry* _tmp20_;
		guint _tmp21_;
		PlankUnityLauncherEntry* _tmp22_;
		PlankUnityLauncherEntry* _tmp23_;
		gchar* _tmp24_;
		PlankUnityLauncherEntry* _tmp25_;
		GVariant* _tmp26_;
		GeeHashMap* _tmp27_;
		PlankUnityLauncherEntry* _tmp28_;
		_tmp19_ = plank_unity_launcher_entry_new ();
		_plank_unity_launcher_entry_unref0 (_data15_->entry);
		_data15_->entry = _tmp19_;
		_tmp20_ = _data15_->entry;
		_tmp21_ = _tmp20_->fast_count;
		_tmp20_->fast_count = _tmp21_ + 1;
		_tmp22_ = _data15_->entry;
		_tmp22_->last_update = current_time;
		_tmp23_ = _data15_->entry;
		_tmp24_ = g_strdup (sender_name);
		_g_free0 (_tmp23_->sender_name);
		_tmp23_->sender_name = _tmp24_;
		_tmp25_ = _data15_->entry;
		_tmp26_ = _g_variant_ref0 (parameters);
		_g_variant_unref0 (_tmp25_->parameters);
		_tmp25_->parameters = _tmp26_;
		_tmp27_ = self->priv->launcher_entries;
		_tmp28_ = _data15_->entry;
		gee_abstract_map_set ((GeeAbstractMap*) _tmp27_, sender_name, _tmp28_);
		plank_unity_perform_update (self, sender_name, parameters);
	}
	if (self->priv->launcher_entries_timer_id <= 0U) {
		self->priv->launcher_entries_timer_id = g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) (60 * 1000), (GSourceFunc) plank_unity_clean_up_launcher_entries, g_object_ref (self), g_object_unref);
	}
	block15_data_unref (_data15_);
	_data15_ = NULL;
}

static gboolean
plank_unity_clean_up_launcher_entries (PlankUnity* self)
{
	gint64 current_time = 0LL;
	GeeMapIterator* launcher_entries_it = NULL;
	GeeHashMap* _tmp0_;
	GeeMapIterator* _tmp1_;
	gboolean keep_running = FALSE;
	GeeHashMap* _tmp7_;
	gint _tmp8_;
	gint _tmp9_;
	GeeHashMap* _tmp10_;
	gint _tmp11_;
	gint _tmp12_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	current_time = g_get_monotonic_time ();
	_tmp0_ = self->priv->launcher_entries;
	_tmp1_ = gee_abstract_map_map_iterator ((GeeAbstractMap*) _tmp0_);
	launcher_entries_it = _tmp1_;
	while (TRUE) {
		GeeMapIterator* _tmp2_;
		PlankUnityLauncherEntry* entry = NULL;
		GeeMapIterator* _tmp3_;
		gpointer _tmp4_;
		PlankUnityLauncherEntry* _tmp5_;
		_tmp2_ = launcher_entries_it;
		if (!gee_map_iterator_next (_tmp2_)) {
			break;
		}
		_tmp3_ = launcher_entries_it;
		_tmp4_ = gee_map_iterator_get_value (_tmp3_);
		entry = (PlankUnityLauncherEntry*) _tmp4_;
		_tmp5_ = entry;
		if ((current_time - _tmp5_->last_update) > ((gint64) ((10 * PLANK_UNITY_UPDATE_THRESHOLD_DURATION) * 1000))) {
			GeeMapIterator* _tmp6_;
			_tmp6_ = launcher_entries_it;
			gee_map_iterator_unset (_tmp6_);
		}
		_plank_unity_launcher_entry_unref0 (entry);
	}
	_tmp7_ = self->priv->launcher_entries;
	_tmp8_ = gee_abstract_map_get_size ((GeeAbstractMap*) _tmp7_);
	_tmp9_ = _tmp8_;
	keep_running = _tmp9_ > 0;
	if (!keep_running) {
		self->priv->launcher_entries_timer_id = 0U;
	}
	_tmp10_ = self->priv->launcher_entries;
	_tmp11_ = gee_abstract_map_get_size ((GeeAbstractMap*) _tmp10_);
	_tmp12_ = _tmp11_;
	plank_logger_verbose ("[Unity] Keeping %i active LauncherEntries", _tmp12_, NULL);
	result = keep_running;
	_g_object_unref0 (launcher_entries_it);
	return result;
}

static Block16Data*
block16_data_ref (Block16Data* _data16_)
{
	g_atomic_int_inc (&_data16_->_ref_count_);
	return _data16_;
}

static void
block16_data_unref (void * _userdata_)
{
	Block16Data* _data16_;
	_data16_ = (Block16Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data16_->_ref_count_)) {
		PlankUnity* self;
		self = _data16_->self;
		_g_free0 (_data16_->sender_name);
		_g_variant_unref0 (_data16_->parameters);
		_g_object_unref0 (self);
		g_slice_free (Block16Data, _data16_);
	}
}

static gboolean
__lambda62_ (Block16Data* _data16_,
             PlankUnityClient* client)
{
	PlankUnity* self;
	gboolean result;
	self = _data16_->self;
	g_return_val_if_fail (client != NULL, FALSE);
	plank_unity_client_update_launcher_entry (client, _data16_->sender_name, _data16_->parameters, FALSE);
	result = TRUE;
	_g_object_unref0 (client);
	return result;
}

static gboolean
___lambda62__gee_forall_func (gpointer g,
                              gpointer self)
{
	gboolean result;
	result = __lambda62_ (self, (PlankUnityClient*) g);
	return result;
}

static void
plank_unity_perform_update (PlankUnity* self,
                            const gchar* sender_name,
                            GVariant* parameters)
{
	Block16Data* _data16_;
	gchar* _tmp0_;
	GVariant* _tmp1_;
	const GVariantType* _tmp2_;
	GeeHashSet* _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (sender_name != NULL);
	g_return_if_fail (parameters != NULL);
	_data16_ = g_slice_new0 (Block16Data);
	_data16_->_ref_count_ = 1;
	_data16_->self = g_object_ref (self);
	_tmp0_ = g_strdup (sender_name);
	_g_free0 (_data16_->sender_name);
	_data16_->sender_name = _tmp0_;
	_tmp1_ = _g_variant_ref0 (parameters);
	_g_variant_unref0 (_data16_->parameters);
	_data16_->parameters = _tmp1_;
	_tmp2_ = plank_unity_payload_variant_type;
	if (!g_variant_is_of_type (_data16_->parameters, _tmp2_)) {
		const gchar* _tmp3_;
		_tmp3_ = g_variant_get_type_string (_data16_->parameters);
		g_warning ("Unity.vala:301: Illegal payload signature '%s' from %s. expected '(sa{" \
"sv})'", _tmp3_, _data16_->sender_name);
		block16_data_unref (_data16_);
		_data16_ = NULL;
		return;
	}
	_tmp4_ = self->priv->clients;
	gee_abstract_collection_foreach ((GeeAbstractCollection*) _tmp4_, ___lambda62__gee_forall_func, _data16_);
	block16_data_unref (_data16_);
	_data16_ = NULL;
}

static PlankUnityLauncherEntry*
plank_unity_launcher_entry_construct (GType object_type)
{
	PlankUnityLauncherEntry* self = NULL;
	self = (PlankUnityLauncherEntry*) g_type_create_instance (object_type);
	return self;
}

static PlankUnityLauncherEntry*
plank_unity_launcher_entry_new (void)
{
	return plank_unity_launcher_entry_construct (PLANK_UNITY_TYPE_LAUNCHER_ENTRY);
}

static void
plank_unity_value_launcher_entry_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
plank_unity_value_launcher_entry_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		plank_unity_launcher_entry_unref (value->data[0].v_pointer);
	}
}

static void
plank_unity_value_launcher_entry_copy_value (const GValue* src_value,
                                             GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = plank_unity_launcher_entry_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
plank_unity_value_launcher_entry_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
plank_unity_value_launcher_entry_collect_value (GValue* value,
                                                guint n_collect_values,
                                                GTypeCValue* collect_values,
                                                guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		PlankUnityLauncherEntry * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = plank_unity_launcher_entry_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
plank_unity_value_launcher_entry_lcopy_value (const GValue* value,
                                              guint n_collect_values,
                                              GTypeCValue* collect_values,
                                              guint collect_flags)
{
	PlankUnityLauncherEntry ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = plank_unity_launcher_entry_ref (value->data[0].v_pointer);
	}
	return NULL;
}

static GParamSpec*
plank_unity_param_spec_launcher_entry (const gchar* name,
                                       const gchar* nick,
                                       const gchar* blurb,
                                       GType object_type,
                                       GParamFlags flags)
{
	PlankUnityParamSpecLauncherEntry* spec;
	g_return_val_if_fail (g_type_is_a (object_type, PLANK_UNITY_TYPE_LAUNCHER_ENTRY), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

static gpointer
plank_unity_value_get_launcher_entry (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, PLANK_UNITY_TYPE_LAUNCHER_ENTRY), NULL);
	return value->data[0].v_pointer;
}

static void
plank_unity_value_set_launcher_entry (GValue* value,
                                      gpointer v_object)
{
	PlankUnityLauncherEntry * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, PLANK_UNITY_TYPE_LAUNCHER_ENTRY));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, PLANK_UNITY_TYPE_LAUNCHER_ENTRY));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		plank_unity_launcher_entry_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		plank_unity_launcher_entry_unref (old);
	}
}

static void
plank_unity_value_take_launcher_entry (GValue* value,
                                       gpointer v_object)
{
	PlankUnityLauncherEntry * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, PLANK_UNITY_TYPE_LAUNCHER_ENTRY));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, PLANK_UNITY_TYPE_LAUNCHER_ENTRY));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		plank_unity_launcher_entry_unref (old);
	}
}

static void
plank_unity_launcher_entry_class_init (PlankUnityLauncherEntryClass * klass,
                                       gpointer klass_data)
{
	plank_unity_launcher_entry_parent_class = g_type_class_peek_parent (klass);
	((PlankUnityLauncherEntryClass *) klass)->finalize = plank_unity_launcher_entry_finalize;
}

static void
plank_unity_launcher_entry_instance_init (PlankUnityLauncherEntry * self,
                                          gpointer klass)
{
	self->fast_count = 0U;
	self->last_update = 0LL;
	self->timer_id = 0U;
	self->warned = FALSE;
	self->ref_count = 1;
}

static void
plank_unity_launcher_entry_finalize (PlankUnityLauncherEntry * obj)
{
	PlankUnityLauncherEntry * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, PLANK_UNITY_TYPE_LAUNCHER_ENTRY, PlankUnityLauncherEntry);
	g_signal_handlers_destroy (self);
	_g_free0 (self->sender_name);
	_g_variant_unref0 (self->parameters);
}

static GType
plank_unity_launcher_entry_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { plank_unity_value_launcher_entry_init, plank_unity_value_launcher_entry_free_value, plank_unity_value_launcher_entry_copy_value, plank_unity_value_launcher_entry_peek_pointer, "p", plank_unity_value_launcher_entry_collect_value, "p", plank_unity_value_launcher_entry_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (PlankUnityLauncherEntryClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) plank_unity_launcher_entry_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PlankUnityLauncherEntry), 0, (GInstanceInitFunc) plank_unity_launcher_entry_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType plank_unity_launcher_entry_type_id;
	plank_unity_launcher_entry_type_id = g_type_register_fundamental (g_type_fundamental_next (), "PlankUnityLauncherEntry", &g_define_type_info, &g_define_type_fundamental_info, 0);
	return plank_unity_launcher_entry_type_id;
}

static GType
plank_unity_launcher_entry_get_type (void)
{
	static volatile gsize plank_unity_launcher_entry_type_id__once = 0;
	if (g_once_init_enter (&plank_unity_launcher_entry_type_id__once)) {
		GType plank_unity_launcher_entry_type_id;
		plank_unity_launcher_entry_type_id = plank_unity_launcher_entry_get_type_once ();
		g_once_init_leave (&plank_unity_launcher_entry_type_id__once, plank_unity_launcher_entry_type_id);
	}
	return plank_unity_launcher_entry_type_id__once;
}

static gpointer
plank_unity_launcher_entry_ref (gpointer instance)
{
	PlankUnityLauncherEntry * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

static void
plank_unity_launcher_entry_unref (gpointer instance)
{
	PlankUnityLauncherEntry * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		PLANK_UNITY_LAUNCHER_ENTRY_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

static GObject *
plank_unity_constructor (GType type,
                         guint n_construct_properties,
                         GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	PlankUnity * self;
	GeeHashSet* _tmp0_;
	GeeHashMap* _tmp1_;
	GDBusConnection* _tmp2_;
	parent_class = G_OBJECT_CLASS (plank_unity_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, PLANK_TYPE_UNITY, PlankUnity);
	_tmp0_ = gee_hash_set_new (PLANK_TYPE_UNITY_CLIENT, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->clients);
	self->priv->clients = _tmp0_;
	_tmp1_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, PLANK_UNITY_TYPE_LAUNCHER_ENTRY, (GBoxedCopyFunc) plank_unity_launcher_entry_ref, (GDestroyNotify) plank_unity_launcher_entry_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->launcher_entries);
	self->priv->launcher_entries = _tmp1_;
	plank_unity_acquire_unity_dbus ();
	_tmp2_ = plank_unity_connection;
	if (_tmp2_ != NULL) {
		GDBusConnection* _tmp3_;
		GDBusConnection* _tmp4_;
		g_debug ("Unity.vala:164: Initializing LauncherEntry support");
		_tmp3_ = plank_unity_connection;
		self->priv->launcher_entry_dbus_signal_id = g_dbus_connection_signal_subscribe (_tmp3_, NULL, PLANK_UNITY_INTERFACE_NAME, NULL, NULL, NULL, G_DBUS_SIGNAL_FLAGS_NONE, (GDBusSignalCallback) plank_unity_handle_entry_signal, g_object_ref (self), g_object_unref);
		_tmp4_ = plank_unity_connection;
		self->priv->dbus_name_owner_changed_signal_id = g_dbus_connection_signal_subscribe (_tmp4_, "org.freedesktop.DBus", "org.freedesktop.DBus", "NameOwnerChanged", "/org/freedesktop/DBus", NULL, G_DBUS_SIGNAL_FLAGS_NONE, (GDBusSignalCallback) plank_unity_handle_name_owner_changed, g_object_ref (self), g_object_unref);
	}
	return obj;
}

static void
plank_unity_class_init (PlankUnityClass * klass,
                        gpointer klass_data)
{
	GVariantType* _tmp0_;
	plank_unity_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &PlankUnity_private_offset);
	G_OBJECT_CLASS (klass)->constructor = plank_unity_constructor;
	G_OBJECT_CLASS (klass)->finalize = plank_unity_finalize;
	plank_unity_acquire_unity_dbus ();
	_tmp0_ = g_variant_type_new ("(sa{sv})");
	_g_variant_type_free0 (plank_unity_payload_variant_type);
	plank_unity_payload_variant_type = _tmp0_;
}

static void
plank_unity_instance_init (PlankUnity * self,
                           gpointer klass)
{
	self->priv = plank_unity_get_instance_private (self);
	self->priv->launcher_entry_dbus_signal_id = 0U;
	self->priv->dbus_name_owner_changed_signal_id = 0U;
	self->priv->launcher_entries_timer_id = 0U;
}

static void
plank_unity_finalize (GObject * obj)
{
	PlankUnity * self;
	GDBusConnection* _tmp0_;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, PLANK_TYPE_UNITY, PlankUnity);
	if (self->priv->launcher_entries_timer_id > 0U) {
		g_source_remove (self->priv->launcher_entries_timer_id);
	}
	_g_object_unref0 (self->priv->clients);
	self->priv->clients = NULL;
	_g_object_unref0 (self->priv->launcher_entries);
	self->priv->launcher_entries = NULL;
	if (plank_unity_unity_bus_id > 0U) {
		g_bus_unown_name (plank_unity_unity_bus_id);
	}
	_tmp0_ = plank_unity_connection;
	if (_tmp0_ != NULL) {
		if (self->priv->launcher_entry_dbus_signal_id > 0U) {
			GDBusConnection* _tmp1_;
			_tmp1_ = plank_unity_connection;
			g_dbus_connection_signal_unsubscribe (_tmp1_, self->priv->launcher_entry_dbus_signal_id);
		}
		if (self->priv->dbus_name_owner_changed_signal_id > 0U) {
			GDBusConnection* _tmp2_;
			_tmp2_ = plank_unity_connection;
			g_dbus_connection_signal_unsubscribe (_tmp2_, self->priv->dbus_name_owner_changed_signal_id);
		}
	}
	_g_object_unref0 (self->priv->clients);
	_g_object_unref0 (self->priv->launcher_entries);
	G_OBJECT_CLASS (plank_unity_parent_class)->finalize (obj);
}

/**
 * Handle the LauncherEntry DBus interface implemented by applications.
 */
static GType
plank_unity_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (PlankUnityClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) plank_unity_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PlankUnity), 0, (GInstanceInitFunc) plank_unity_instance_init, NULL };
	GType plank_unity_type_id;
	plank_unity_type_id = g_type_register_static (G_TYPE_OBJECT, "PlankUnity", &g_define_type_info, 0);
	PlankUnity_private_offset = g_type_add_instance_private (plank_unity_type_id, sizeof (PlankUnityPrivate));
	return plank_unity_type_id;
}

GType
plank_unity_get_type (void)
{
	static volatile gsize plank_unity_type_id__once = 0;
	if (g_once_init_enter (&plank_unity_type_id__once)) {
		GType plank_unity_type_id;
		plank_unity_type_id = plank_unity_get_type_once ();
		g_once_init_leave (&plank_unity_type_id__once, plank_unity_type_id);
	}
	return plank_unity_type_id__once;
}

