#define _CFFI_

/* We try to define Py_LIMITED_API before including Python.h.

   Mess: we can only define it if Py_DEBUG, Py_TRACE_REFS and
   Py_REF_DEBUG are not defined.  This is a best-effort approximation:
   we can learn about Py_DEBUG from pyconfig.h, but it is unclear if
   the same works for the other two macros.  Py_DEBUG implies them,
   but not the other way around.

   The implementation is messy (issue #350): on Windows, with _MSC_VER,
   we have to define Py_LIMITED_API even before including pyconfig.h.
   In that case, we guess what pyconfig.h will do to the macros above,
   and check our guess after the #include.

   Note that on Windows, with CPython 3.x, you need >= 3.5 and virtualenv
   version >= 16.0.0.  With older versions of either, you don't get a
   copy of PYTHON3.DLL in the virtualenv.  We can't check the version of
   CPython *before* we even include pyconfig.h.  ffi.set_source() puts
   a ``#define _CFFI_NO_LIMITED_API'' at the start of this file if it is
   running on Windows < 3.5, as an attempt at fixing it, but that's
   arguably wrong because it may not be the target version of Python.
   Still better than nothing I guess.  As another workaround, you can
   remove the definition of Py_LIMITED_API here.

   See also 'py_limited_api' in cffi/setuptools_ext.py.
*/
#if !defined(_CFFI_USE_EMBEDDING) && !defined(Py_LIMITED_API)
#  ifdef _MSC_VER
#    if !defined(_DEBUG) && !defined(Py_DEBUG) && !defined(Py_TRACE_REFS) && !defined(Py_REF_DEBUG) && !defined(_CFFI_NO_LIMITED_API)
#      define Py_LIMITED_API
#    endif
#    include <pyconfig.h>
     /* sanity-check: Py_LIMITED_API will cause crashes if any of these
        are also defined.  Normally, the Python file PC/pyconfig.h does not
        cause any of these to be defined, with the exception that _DEBUG
        causes Py_DEBUG.  Double-check that. */
#    ifdef Py_LIMITED_API
#      if defined(Py_DEBUG)
#        error "pyconfig.h unexpectedly defines Py_DEBUG, but Py_LIMITED_API is set"
#      endif
#      if defined(Py_TRACE_REFS)
#        error "pyconfig.h unexpectedly defines Py_TRACE_REFS, but Py_LIMITED_API is set"
#      endif
#      if defined(Py_REF_DEBUG)
#        error "pyconfig.h unexpectedly defines Py_REF_DEBUG, but Py_LIMITED_API is set"
#      endif
#    endif
#  else
#    include <pyconfig.h>
#    if !defined(Py_DEBUG) && !defined(Py_TRACE_REFS) && !defined(Py_REF_DEBUG) && !defined(_CFFI_NO_LIMITED_API)
#      define Py_LIMITED_API
#    endif
#  endif
#endif

#include <Python.h>
#ifdef __cplusplus
extern "C" {
#endif
#include <stddef.h>

/* This part is from file 'cffi/parse_c_type.h'.  It is copied at the
   beginning of C sources generated by CFFI's ffi.set_source(). */

typedef void *_cffi_opcode_t;

#define _CFFI_OP(opcode, arg)   (_cffi_opcode_t)(opcode | (((uintptr_t)(arg)) << 8))
#define _CFFI_GETOP(cffi_opcode)    ((unsigned char)(uintptr_t)cffi_opcode)
#define _CFFI_GETARG(cffi_opcode)   (((intptr_t)cffi_opcode) >> 8)

#define _CFFI_OP_PRIMITIVE       1
#define _CFFI_OP_POINTER         3
#define _CFFI_OP_ARRAY           5
#define _CFFI_OP_OPEN_ARRAY      7
#define _CFFI_OP_STRUCT_UNION    9
#define _CFFI_OP_ENUM           11
#define _CFFI_OP_FUNCTION       13
#define _CFFI_OP_FUNCTION_END   15
#define _CFFI_OP_NOOP           17
#define _CFFI_OP_BITFIELD       19
#define _CFFI_OP_TYPENAME       21
#define _CFFI_OP_CPYTHON_BLTN_V 23   // varargs
#define _CFFI_OP_CPYTHON_BLTN_N 25   // noargs
#define _CFFI_OP_CPYTHON_BLTN_O 27   // O  (i.e. a single arg)
#define _CFFI_OP_CONSTANT       29
#define _CFFI_OP_CONSTANT_INT   31
#define _CFFI_OP_GLOBAL_VAR     33
#define _CFFI_OP_DLOPEN_FUNC    35
#define _CFFI_OP_DLOPEN_CONST   37
#define _CFFI_OP_GLOBAL_VAR_F   39
#define _CFFI_OP_EXTERN_PYTHON  41

#define _CFFI_PRIM_VOID          0
#define _CFFI_PRIM_BOOL          1
#define _CFFI_PRIM_CHAR          2
#define _CFFI_PRIM_SCHAR         3
#define _CFFI_PRIM_UCHAR         4
#define _CFFI_PRIM_SHORT         5
#define _CFFI_PRIM_USHORT        6
#define _CFFI_PRIM_INT           7
#define _CFFI_PRIM_UINT          8
#define _CFFI_PRIM_LONG          9
#define _CFFI_PRIM_ULONG        10
#define _CFFI_PRIM_LONGLONG     11
#define _CFFI_PRIM_ULONGLONG    12
#define _CFFI_PRIM_FLOAT        13
#define _CFFI_PRIM_DOUBLE       14
#define _CFFI_PRIM_LONGDOUBLE   15

#define _CFFI_PRIM_WCHAR        16
#define _CFFI_PRIM_INT8         17
#define _CFFI_PRIM_UINT8        18
#define _CFFI_PRIM_INT16        19
#define _CFFI_PRIM_UINT16       20
#define _CFFI_PRIM_INT32        21
#define _CFFI_PRIM_UINT32       22
#define _CFFI_PRIM_INT64        23
#define _CFFI_PRIM_UINT64       24
#define _CFFI_PRIM_INTPTR       25
#define _CFFI_PRIM_UINTPTR      26
#define _CFFI_PRIM_PTRDIFF      27
#define _CFFI_PRIM_SIZE         28
#define _CFFI_PRIM_SSIZE        29
#define _CFFI_PRIM_INT_LEAST8   30
#define _CFFI_PRIM_UINT_LEAST8  31
#define _CFFI_PRIM_INT_LEAST16  32
#define _CFFI_PRIM_UINT_LEAST16 33
#define _CFFI_PRIM_INT_LEAST32  34
#define _CFFI_PRIM_UINT_LEAST32 35
#define _CFFI_PRIM_INT_LEAST64  36
#define _CFFI_PRIM_UINT_LEAST64 37
#define _CFFI_PRIM_INT_FAST8    38
#define _CFFI_PRIM_UINT_FAST8   39
#define _CFFI_PRIM_INT_FAST16   40
#define _CFFI_PRIM_UINT_FAST16  41
#define _CFFI_PRIM_INT_FAST32   42
#define _CFFI_PRIM_UINT_FAST32  43
#define _CFFI_PRIM_INT_FAST64   44
#define _CFFI_PRIM_UINT_FAST64  45
#define _CFFI_PRIM_INTMAX       46
#define _CFFI_PRIM_UINTMAX      47
#define _CFFI_PRIM_FLOATCOMPLEX 48
#define _CFFI_PRIM_DOUBLECOMPLEX 49
#define _CFFI_PRIM_CHAR16       50
#define _CFFI_PRIM_CHAR32       51

#define _CFFI__NUM_PRIM         52
#define _CFFI__UNKNOWN_PRIM           (-1)
#define _CFFI__UNKNOWN_FLOAT_PRIM     (-2)
#define _CFFI__UNKNOWN_LONG_DOUBLE    (-3)

#define _CFFI__IO_FILE_STRUCT         (-1)


struct _cffi_global_s {
    const char *name;
    void *address;
    _cffi_opcode_t type_op;
    void *size_or_direct_fn;  // OP_GLOBAL_VAR: size, or 0 if unknown
                              // OP_CPYTHON_BLTN_*: addr of direct function
};

struct _cffi_getconst_s {
    unsigned long long value;
    const struct _cffi_type_context_s *ctx;
    int gindex;
};

struct _cffi_struct_union_s {
    const char *name;
    int type_index;          // -> _cffi_types, on a OP_STRUCT_UNION
    int flags;               // _CFFI_F_* flags below
    size_t size;
    int alignment;
    int first_field_index;   // -> _cffi_fields array
    int num_fields;
};
#define _CFFI_F_UNION         0x01   // is a union, not a struct
#define _CFFI_F_CHECK_FIELDS  0x02   // complain if fields are not in the
                                     // "standard layout" or if some are missing
#define _CFFI_F_PACKED        0x04   // for CHECK_FIELDS, assume a packed struct
#define _CFFI_F_EXTERNAL      0x08   // in some other ffi.include()
#define _CFFI_F_OPAQUE        0x10   // opaque

struct _cffi_field_s {
    const char *name;
    size_t field_offset;
    size_t field_size;
    _cffi_opcode_t field_type_op;
};

struct _cffi_enum_s {
    const char *name;
    int type_index;          // -> _cffi_types, on a OP_ENUM
    int type_prim;           // _CFFI_PRIM_xxx
    const char *enumerators; // comma-delimited string
};

struct _cffi_typename_s {
    const char *name;
    int type_index;   /* if opaque, points to a possibly artificial
                         OP_STRUCT which is itself opaque */
};

struct _cffi_type_context_s {
    _cffi_opcode_t *types;
    const struct _cffi_global_s *globals;
    const struct _cffi_field_s *fields;
    const struct _cffi_struct_union_s *struct_unions;
    const struct _cffi_enum_s *enums;
    const struct _cffi_typename_s *typenames;
    int num_globals;
    int num_struct_unions;
    int num_enums;
    int num_typenames;
    const char *const *includes;
    int num_types;
    int flags;      /* future extension */
};

struct _cffi_parse_info_s {
    const struct _cffi_type_context_s *ctx;
    _cffi_opcode_t *output;
    unsigned int output_size;
    size_t error_location;
    const char *error_message;
};

struct _cffi_externpy_s {
    const char *name;
    size_t size_of_result;
    void *reserved1, *reserved2;
};

#ifdef _CFFI_INTERNAL
static int parse_c_type(struct _cffi_parse_info_s *info, const char *input);
static int search_in_globals(const struct _cffi_type_context_s *ctx,
                             const char *search, size_t search_len);
static int search_in_struct_unions(const struct _cffi_type_context_s *ctx,
                                   const char *search, size_t search_len);
#endif

/* this block of #ifs should be kept exactly identical between
   c/_cffi_backend.c, cffi/vengine_cpy.py, cffi/vengine_gen.py
   and cffi/_cffi_include.h */
#if defined(_MSC_VER)
# include <malloc.h>   /* for alloca() */
# if _MSC_VER < 1600   /* MSVC < 2010 */
   typedef __int8 int8_t;
   typedef __int16 int16_t;
   typedef __int32 int32_t;
   typedef __int64 int64_t;
   typedef unsigned __int8 uint8_t;
   typedef unsigned __int16 uint16_t;
   typedef unsigned __int32 uint32_t;
   typedef unsigned __int64 uint64_t;
   typedef __int8 int_least8_t;
   typedef __int16 int_least16_t;
   typedef __int32 int_least32_t;
   typedef __int64 int_least64_t;
   typedef unsigned __int8 uint_least8_t;
   typedef unsigned __int16 uint_least16_t;
   typedef unsigned __int32 uint_least32_t;
   typedef unsigned __int64 uint_least64_t;
   typedef __int8 int_fast8_t;
   typedef __int16 int_fast16_t;
   typedef __int32 int_fast32_t;
   typedef __int64 int_fast64_t;
   typedef unsigned __int8 uint_fast8_t;
   typedef unsigned __int16 uint_fast16_t;
   typedef unsigned __int32 uint_fast32_t;
   typedef unsigned __int64 uint_fast64_t;
   typedef __int64 intmax_t;
   typedef unsigned __int64 uintmax_t;
# else
#  include <stdint.h>
# endif
# if _MSC_VER < 1800   /* MSVC < 2013 */
#  ifndef __cplusplus
    typedef unsigned char _Bool;
#  endif
# endif
# define _cffi_float_complex_t   _Fcomplex    /* include <complex.h> for it */
# define _cffi_double_complex_t  _Dcomplex    /* include <complex.h> for it */
#else
# include <stdint.h>
# if (defined (__SVR4) && defined (__sun)) || defined(_AIX) || defined(__hpux)
#  include <alloca.h>
# endif
# define _cffi_float_complex_t   float _Complex
# define _cffi_double_complex_t  double _Complex
#endif

#ifdef __GNUC__
# define _CFFI_UNUSED_FN  __attribute__((unused))
#else
# define _CFFI_UNUSED_FN  /* nothing */
#endif

#ifdef __cplusplus
# ifndef _Bool
   typedef bool _Bool;   /* semi-hackish: C++ has no _Bool; bool is builtin */
# endif
#endif

/**********  CPython-specific section  **********/
#ifndef PYPY_VERSION


#if PY_MAJOR_VERSION >= 3
# define PyInt_FromLong PyLong_FromLong
#endif

#define _cffi_from_c_double PyFloat_FromDouble
#define _cffi_from_c_float PyFloat_FromDouble
#define _cffi_from_c_long PyInt_FromLong
#define _cffi_from_c_ulong PyLong_FromUnsignedLong
#define _cffi_from_c_longlong PyLong_FromLongLong
#define _cffi_from_c_ulonglong PyLong_FromUnsignedLongLong
#define _cffi_from_c__Bool PyBool_FromLong

#define _cffi_to_c_double PyFloat_AsDouble
#define _cffi_to_c_float PyFloat_AsDouble

#define _cffi_from_c_int(x, type)                                        \
    (((type)-1) > 0 ? /* unsigned */                                     \
        (sizeof(type) < sizeof(long) ?                                   \
            PyInt_FromLong((long)x) :                                    \
         sizeof(type) == sizeof(long) ?                                  \
            PyLong_FromUnsignedLong((unsigned long)x) :                  \
            PyLong_FromUnsignedLongLong((unsigned long long)x)) :        \
        (sizeof(type) <= sizeof(long) ?                                  \
            PyInt_FromLong((long)x) :                                    \
            PyLong_FromLongLong((long long)x)))

#define _cffi_to_c_int(o, type)                                          \
    ((type)(                                                             \
     sizeof(type) == 1 ? (((type)-1) > 0 ? (type)_cffi_to_c_u8(o)        \
                                         : (type)_cffi_to_c_i8(o)) :     \
     sizeof(type) == 2 ? (((type)-1) > 0 ? (type)_cffi_to_c_u16(o)       \
                                         : (type)_cffi_to_c_i16(o)) :    \
     sizeof(type) == 4 ? (((type)-1) > 0 ? (type)_cffi_to_c_u32(o)       \
                                         : (type)_cffi_to_c_i32(o)) :    \
     sizeof(type) == 8 ? (((type)-1) > 0 ? (type)_cffi_to_c_u64(o)       \
                                         : (type)_cffi_to_c_i64(o)) :    \
     (Py_FatalError("unsupported size for type " #type), (type)0)))

#define _cffi_to_c_i8                                                    \
                 ((int(*)(PyObject *))_cffi_exports[1])
#define _cffi_to_c_u8                                                    \
                 ((int(*)(PyObject *))_cffi_exports[2])
#define _cffi_to_c_i16                                                   \
                 ((int(*)(PyObject *))_cffi_exports[3])
#define _cffi_to_c_u16                                                   \
                 ((int(*)(PyObject *))_cffi_exports[4])
#define _cffi_to_c_i32                                                   \
                 ((int(*)(PyObject *))_cffi_exports[5])
#define _cffi_to_c_u32                                                   \
                 ((unsigned int(*)(PyObject *))_cffi_exports[6])
#define _cffi_to_c_i64                                                   \
                 ((long long(*)(PyObject *))_cffi_exports[7])
#define _cffi_to_c_u64                                                   \
                 ((unsigned long long(*)(PyObject *))_cffi_exports[8])
#define _cffi_to_c_char                                                  \
                 ((int(*)(PyObject *))_cffi_exports[9])
#define _cffi_from_c_pointer                                             \
    ((PyObject *(*)(char *, struct _cffi_ctypedescr *))_cffi_exports[10])
#define _cffi_to_c_pointer                                               \
    ((char *(*)(PyObject *, struct _cffi_ctypedescr *))_cffi_exports[11])
#define _cffi_get_struct_layout                                          \
    not used any more
#define _cffi_restore_errno                                              \
    ((void(*)(void))_cffi_exports[13])
#define _cffi_save_errno                                                 \
    ((void(*)(void))_cffi_exports[14])
#define _cffi_from_c_char                                                \
    ((PyObject *(*)(char))_cffi_exports[15])
#define _cffi_from_c_deref                                               \
    ((PyObject *(*)(char *, struct _cffi_ctypedescr *))_cffi_exports[16])
#define _cffi_to_c                                                       \
    ((int(*)(char *, struct _cffi_ctypedescr *, PyObject *))_cffi_exports[17])
#define _cffi_from_c_struct                                              \
    ((PyObject *(*)(char *, struct _cffi_ctypedescr *))_cffi_exports[18])
#define _cffi_to_c_wchar_t                                               \
    ((_cffi_wchar_t(*)(PyObject *))_cffi_exports[19])
#define _cffi_from_c_wchar_t                                             \
    ((PyObject *(*)(_cffi_wchar_t))_cffi_exports[20])
#define _cffi_to_c_long_double                                           \
    ((long double(*)(PyObject *))_cffi_exports[21])
#define _cffi_to_c__Bool                                                 \
    ((_Bool(*)(PyObject *))_cffi_exports[22])
#define _cffi_prepare_pointer_call_argument                              \
    ((Py_ssize_t(*)(struct _cffi_ctypedescr *,                           \
                    PyObject *, char **))_cffi_exports[23])
#define _cffi_convert_array_from_object                                  \
    ((int(*)(char *, struct _cffi_ctypedescr *, PyObject *))_cffi_exports[24])
#define _CFFI_CPIDX  25
#define _cffi_call_python                                                \
    ((void(*)(struct _cffi_externpy_s *, char *))_cffi_exports[_CFFI_CPIDX])
#define _cffi_to_c_wchar3216_t                                           \
    ((int(*)(PyObject *))_cffi_exports[26])
#define _cffi_from_c_wchar3216_t                                         \
    ((PyObject *(*)(int))_cffi_exports[27])
#define _CFFI_NUM_EXPORTS 28

struct _cffi_ctypedescr;

static void *_cffi_exports[_CFFI_NUM_EXPORTS];

#define _cffi_type(index)   (                           \
    assert((((uintptr_t)_cffi_types[index]) & 1) == 0), \
    (struct _cffi_ctypedescr *)_cffi_types[index])

static PyObject *_cffi_init(const char *module_name, Py_ssize_t version,
                            const struct _cffi_type_context_s *ctx)
{
    PyObject *module, *o_arg, *new_module;
    void *raw[] = {
        (void *)module_name,
        (void *)version,
        (void *)_cffi_exports,
        (void *)ctx,
    };

    module = PyImport_ImportModule("_cffi_backend");
    if (module == NULL)
        goto failure;

    o_arg = PyLong_FromVoidPtr((void *)raw);
    if (o_arg == NULL)
        goto failure;

    new_module = PyObject_CallMethod(
        module, (char *)"_init_cffi_1_0_external_module", (char *)"O", o_arg);

    Py_DECREF(o_arg);
    Py_DECREF(module);
    return new_module;

  failure:
    Py_XDECREF(module);
    return NULL;
}


#ifdef HAVE_WCHAR_H
typedef wchar_t _cffi_wchar_t;
#else
typedef uint16_t _cffi_wchar_t;   /* same random pick as _cffi_backend.c */
#endif

_CFFI_UNUSED_FN static uint16_t _cffi_to_c_char16_t(PyObject *o)
{
    if (sizeof(_cffi_wchar_t) == 2)
        return (uint16_t)_cffi_to_c_wchar_t(o);
    else
        return (uint16_t)_cffi_to_c_wchar3216_t(o);
}

_CFFI_UNUSED_FN static PyObject *_cffi_from_c_char16_t(uint16_t x)
{
    if (sizeof(_cffi_wchar_t) == 2)
        return _cffi_from_c_wchar_t((_cffi_wchar_t)x);
    else
        return _cffi_from_c_wchar3216_t((int)x);
}

_CFFI_UNUSED_FN static int _cffi_to_c_char32_t(PyObject *o)
{
    if (sizeof(_cffi_wchar_t) == 4)
        return (int)_cffi_to_c_wchar_t(o);
    else
        return (int)_cffi_to_c_wchar3216_t(o);
}

_CFFI_UNUSED_FN static PyObject *_cffi_from_c_char32_t(unsigned int x)
{
    if (sizeof(_cffi_wchar_t) == 4)
        return _cffi_from_c_wchar_t((_cffi_wchar_t)x);
    else
        return _cffi_from_c_wchar3216_t((int)x);
}

union _cffi_union_alignment_u {
    unsigned char m_char;
    unsigned short m_short;
    unsigned int m_int;
    unsigned long m_long;
    unsigned long long m_longlong;
    float m_float;
    double m_double;
    long double m_longdouble;
};

struct _cffi_freeme_s {
    struct _cffi_freeme_s *next;
    union _cffi_union_alignment_u alignment;
};

_CFFI_UNUSED_FN static int
_cffi_convert_array_argument(struct _cffi_ctypedescr *ctptr, PyObject *arg,
                             char **output_data, Py_ssize_t datasize,
                             struct _cffi_freeme_s **freeme)
{
    char *p;
    if (datasize < 0)
        return -1;

    p = *output_data;
    if (p == NULL) {
        struct _cffi_freeme_s *fp = (struct _cffi_freeme_s *)PyObject_Malloc(
            offsetof(struct _cffi_freeme_s, alignment) + (size_t)datasize);
        if (fp == NULL)
            return -1;
        fp->next = *freeme;
        *freeme = fp;
        p = *output_data = (char *)&fp->alignment;
    }
    memset((void *)p, 0, (size_t)datasize);
    return _cffi_convert_array_from_object(p, ctptr, arg);
}

_CFFI_UNUSED_FN static void
_cffi_free_array_arguments(struct _cffi_freeme_s *freeme)
{
    do {
        void *p = (void *)freeme;
        freeme = freeme->next;
        PyObject_Free(p);
    } while (freeme != NULL);
}

/**********  end CPython-specific section  **********/
#else
_CFFI_UNUSED_FN
static void (*_cffi_call_python_org)(struct _cffi_externpy_s *, char *);
# define _cffi_call_python  _cffi_call_python_org
#endif


#define _cffi_array_len(array)   (sizeof(array) / sizeof((array)[0]))

#define _cffi_prim_int(size, sign)                                      \
    ((size) == 1 ? ((sign) ? _CFFI_PRIM_INT8  : _CFFI_PRIM_UINT8)  :    \
     (size) == 2 ? ((sign) ? _CFFI_PRIM_INT16 : _CFFI_PRIM_UINT16) :    \
     (size) == 4 ? ((sign) ? _CFFI_PRIM_INT32 : _CFFI_PRIM_UINT32) :    \
     (size) == 8 ? ((sign) ? _CFFI_PRIM_INT64 : _CFFI_PRIM_UINT64) :    \
     _CFFI__UNKNOWN_PRIM)

#define _cffi_prim_float(size)                                          \
    ((size) == sizeof(float) ? _CFFI_PRIM_FLOAT :                       \
     (size) == sizeof(double) ? _CFFI_PRIM_DOUBLE :                     \
     (size) == sizeof(long double) ? _CFFI__UNKNOWN_LONG_DOUBLE :       \
     _CFFI__UNKNOWN_FLOAT_PRIM)

#define _cffi_check_int(got, got_nonpos, expected)      \
    ((got_nonpos) == (expected <= 0) &&                 \
     (got) == (unsigned long long)expected)

#ifdef MS_WIN32
# define _cffi_stdcall  __stdcall
#else
# define _cffi_stdcall  /* nothing */
#endif

#ifdef __cplusplus
}
#endif

/************************************************************/


#include <sqlite3.h>

#ifndef SQLITE_OPEN_URI
static const long SQLITE_OPEN_URI = 0;
#endif
#ifndef SQLITE_OPEN_READWRITE
static const long SQLITE_OPEN_READWRITE = 0;
#endif
#ifndef SQLITE_OPEN_CREATE
static const long SQLITE_OPEN_CREATE = 0;
#endif


/************************************************************/

static void *_cffi_types[] = {
/*  0 */ _CFFI_OP(_CFFI_OP_FUNCTION, 316), // char *()(sqlite3_stmt *)
/*  1 */ _CFFI_OP(_CFFI_OP_POINTER, 322), // sqlite3_stmt *
/*  2 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/*  3 */ _CFFI_OP(_CFFI_OP_FUNCTION, 23), // char const *()(int)
/*  4 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7), // int
/*  5 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/*  6 */ _CFFI_OP(_CFFI_OP_FUNCTION, 23), // char const *()(sqlite3 *)
/*  7 */ _CFFI_OP(_CFFI_OP_POINTER, 318), // sqlite3 *
/*  8 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/*  9 */ _CFFI_OP(_CFFI_OP_FUNCTION, 23), // char const *()(sqlite3_stmt *, int)
/* 10 */ _CFFI_OP(_CFFI_OP_NOOP, 1),
/* 11 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 12 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 13 */ _CFFI_OP(_CFFI_OP_FUNCTION, 23), // char const *()(void)
/* 14 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 15 */ _CFFI_OP(_CFFI_OP_FUNCTION, 159), // double()(sqlite3_stmt *, int)
/* 16 */ _CFFI_OP(_CFFI_OP_NOOP, 1),
/* 17 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 18 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 19 */ _CFFI_OP(_CFFI_OP_FUNCTION, 159), // double()(sqlite3_value *)
/* 20 */ _CFFI_OP(_CFFI_OP_POINTER, 323), // sqlite3_value *
/* 21 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 22 */ _CFFI_OP(_CFFI_OP_FUNCTION, 4), // int()(char const *)
/* 23 */ _CFFI_OP(_CFFI_OP_POINTER, 317), // char const *
/* 24 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 25 */ _CFFI_OP(_CFFI_OP_FUNCTION, 4), // int()(char const *, sqlite3 * *)
/* 26 */ _CFFI_OP(_CFFI_OP_NOOP, 23),
/* 27 */ _CFFI_OP(_CFFI_OP_POINTER, 7), // sqlite3 * *
/* 28 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 29 */ _CFFI_OP(_CFFI_OP_FUNCTION, 4), // int()(char const *, sqlite3 * *, int, char const *)
/* 30 */ _CFFI_OP(_CFFI_OP_NOOP, 23),
/* 31 */ _CFFI_OP(_CFFI_OP_NOOP, 27),
/* 32 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 33 */ _CFFI_OP(_CFFI_OP_NOOP, 23),
/* 34 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 35 */ _CFFI_OP(_CFFI_OP_FUNCTION, 4), // int()(int)
/* 36 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 37 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 38 */ _CFFI_OP(_CFFI_OP_FUNCTION, 4), // int()(sqlite3 *)
/* 39 */ _CFFI_OP(_CFFI_OP_NOOP, 7),
/* 40 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 41 */ _CFFI_OP(_CFFI_OP_FUNCTION, 4), // int()(sqlite3 *, char const *, char const *, char * *)
/* 42 */ _CFFI_OP(_CFFI_OP_NOOP, 7),
/* 43 */ _CFFI_OP(_CFFI_OP_NOOP, 23),
/* 44 */ _CFFI_OP(_CFFI_OP_NOOP, 23),
/* 45 */ _CFFI_OP(_CFFI_OP_POINTER, 316), // char * *
/* 46 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 47 */ _CFFI_OP(_CFFI_OP_FUNCTION, 4), // int()(sqlite3 *, char const *, char const *, char const *, long long, int, sqlite3_blob * *)
/* 48 */ _CFFI_OP(_CFFI_OP_NOOP, 7),
/* 49 */ _CFFI_OP(_CFFI_OP_NOOP, 23),
/* 50 */ _CFFI_OP(_CFFI_OP_NOOP, 23),
/* 51 */ _CFFI_OP(_CFFI_OP_NOOP, 23),
/* 52 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 11), // long long
/* 53 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 54 */ _CFFI_OP(_CFFI_OP_POINTER, 128), // sqlite3_blob * *
/* 55 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 56 */ _CFFI_OP(_CFFI_OP_FUNCTION, 4), // int()(sqlite3 *, char const *, int, int, void *, void(*)(sqlite3_context *, int, sqlite3_value * *), void(*)(sqlite3_context *), void(*)(sqlite3_context *), void(*)(sqlite3_context *, int, sqlite3_value * *), void(*)(void *))
/* 57 */ _CFFI_OP(_CFFI_OP_NOOP, 7),
/* 58 */ _CFFI_OP(_CFFI_OP_NOOP, 23),
/* 59 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 60 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 61 */ _CFFI_OP(_CFFI_OP_POINTER, 326), // void *
/* 62 */ _CFFI_OP(_CFFI_OP_POINTER, 289), // void(*)(sqlite3_context *, int, sqlite3_value * *)
/* 63 */ _CFFI_OP(_CFFI_OP_POINTER, 267), // void(*)(sqlite3_context *)
/* 64 */ _CFFI_OP(_CFFI_OP_NOOP, 63),
/* 65 */ _CFFI_OP(_CFFI_OP_NOOP, 62),
/* 66 */ _CFFI_OP(_CFFI_OP_POINTER, 313), // void(*)(void *)
/* 67 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 68 */ _CFFI_OP(_CFFI_OP_FUNCTION, 4), // int()(sqlite3 *, char const *, int, int, void *, void(*)(sqlite3_context *, int, sqlite3_value * *), void(*)(sqlite3_context *, int, sqlite3_value * *), void(*)(sqlite3_context *))
/* 69 */ _CFFI_OP(_CFFI_OP_NOOP, 7),
/* 70 */ _CFFI_OP(_CFFI_OP_NOOP, 23),
/* 71 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 72 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 73 */ _CFFI_OP(_CFFI_OP_NOOP, 61),
/* 74 */ _CFFI_OP(_CFFI_OP_NOOP, 62),
/* 75 */ _CFFI_OP(_CFFI_OP_NOOP, 62),
/* 76 */ _CFFI_OP(_CFFI_OP_NOOP, 63),
/* 77 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 78 */ _CFFI_OP(_CFFI_OP_FUNCTION, 4), // int()(sqlite3 *, char const *, int, sqlite3_stmt * *, char const * *)
/* 79 */ _CFFI_OP(_CFFI_OP_NOOP, 7),
/* 80 */ _CFFI_OP(_CFFI_OP_NOOP, 23),
/* 81 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 82 */ _CFFI_OP(_CFFI_OP_POINTER, 1), // sqlite3_stmt * *
/* 83 */ _CFFI_OP(_CFFI_OP_POINTER, 23), // char const * *
/* 84 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 85 */ _CFFI_OP(_CFFI_OP_FUNCTION, 4), // int()(sqlite3 *, char const *, int, void *, int(*)(void *, int, void const *, int, void const *))
/* 86 */ _CFFI_OP(_CFFI_OP_NOOP, 7),
/* 87 */ _CFFI_OP(_CFFI_OP_NOOP, 23),
/* 88 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 89 */ _CFFI_OP(_CFFI_OP_NOOP, 61),
/* 90 */ _CFFI_OP(_CFFI_OP_POINTER, 203), // int(*)(void *, int, void const *, int, void const *)
/* 91 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 92 */ _CFFI_OP(_CFFI_OP_FUNCTION, 4), // int()(sqlite3 *, char const *, unsigned char *, long long, long long, unsigned int)
/* 93 */ _CFFI_OP(_CFFI_OP_NOOP, 7),
/* 94 */ _CFFI_OP(_CFFI_OP_NOOP, 23),
/* 95 */ _CFFI_OP(_CFFI_OP_POINTER, 325), // unsigned char *
/* 96 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 11),
/* 97 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 11),
/* 98 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 8), // unsigned int
/* 99 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 100 */ _CFFI_OP(_CFFI_OP_FUNCTION, 4), // int()(sqlite3 *, int(*)(void *, int, char const *, char const *, char const *, char const *), void *)
/* 101 */ _CFFI_OP(_CFFI_OP_NOOP, 7),
/* 102 */ _CFFI_OP(_CFFI_OP_POINTER, 195), // int(*)(void *, int, char const *, char const *, char const *, char const *)
/* 103 */ _CFFI_OP(_CFFI_OP_NOOP, 61),
/* 104 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 105 */ _CFFI_OP(_CFFI_OP_FUNCTION, 4), // int()(sqlite3 *, int)
/* 106 */ _CFFI_OP(_CFFI_OP_NOOP, 7),
/* 107 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 108 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 109 */ _CFFI_OP(_CFFI_OP_FUNCTION, 4), // int()(sqlite3 *, int, int)
/* 110 */ _CFFI_OP(_CFFI_OP_NOOP, 7),
/* 111 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 112 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 113 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 114 */ _CFFI_OP(_CFFI_OP_FUNCTION, 4), // int()(sqlite3 *, unsigned int, int(*)(unsigned int, void *, void *, void *), void *)
/* 115 */ _CFFI_OP(_CFFI_OP_NOOP, 7),
/* 116 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 8),
/* 117 */ _CFFI_OP(_CFFI_OP_POINTER, 186), // int(*)(unsigned int, void *, void *, void *)
/* 118 */ _CFFI_OP(_CFFI_OP_NOOP, 61),
/* 119 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 120 */ _CFFI_OP(_CFFI_OP_FUNCTION, 4), // int()(sqlite3_backup *)
/* 121 */ _CFFI_OP(_CFFI_OP_POINTER, 319), // sqlite3_backup *
/* 122 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 123 */ _CFFI_OP(_CFFI_OP_FUNCTION, 4), // int()(sqlite3_backup *, int)
/* 124 */ _CFFI_OP(_CFFI_OP_NOOP, 121),
/* 125 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 126 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 127 */ _CFFI_OP(_CFFI_OP_FUNCTION, 4), // int()(sqlite3_blob *)
/* 128 */ _CFFI_OP(_CFFI_OP_POINTER, 320), // sqlite3_blob *
/* 129 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 130 */ _CFFI_OP(_CFFI_OP_FUNCTION, 4), // int()(sqlite3_blob *, void *, int, int)
/* 131 */ _CFFI_OP(_CFFI_OP_NOOP, 128),
/* 132 */ _CFFI_OP(_CFFI_OP_NOOP, 61),
/* 133 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 134 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 135 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 136 */ _CFFI_OP(_CFFI_OP_FUNCTION, 4), // int()(sqlite3_blob *, void const *, int, int)
/* 137 */ _CFFI_OP(_CFFI_OP_NOOP, 128),
/* 138 */ _CFFI_OP(_CFFI_OP_POINTER, 326), // void const *
/* 139 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 140 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 141 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 142 */ _CFFI_OP(_CFFI_OP_FUNCTION, 4), // int()(sqlite3_stmt *)
/* 143 */ _CFFI_OP(_CFFI_OP_NOOP, 1),
/* 144 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 145 */ _CFFI_OP(_CFFI_OP_FUNCTION, 4), // int()(sqlite3_stmt *, int)
/* 146 */ _CFFI_OP(_CFFI_OP_NOOP, 1),
/* 147 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 148 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 149 */ _CFFI_OP(_CFFI_OP_FUNCTION, 4), // int()(sqlite3_stmt *, int, char const *, int, void(*)(void *))
/* 150 */ _CFFI_OP(_CFFI_OP_NOOP, 1),
/* 151 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 152 */ _CFFI_OP(_CFFI_OP_NOOP, 23),
/* 153 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 154 */ _CFFI_OP(_CFFI_OP_NOOP, 66),
/* 155 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 156 */ _CFFI_OP(_CFFI_OP_FUNCTION, 4), // int()(sqlite3_stmt *, int, double)
/* 157 */ _CFFI_OP(_CFFI_OP_NOOP, 1),
/* 158 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 159 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 14), // double
/* 160 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 161 */ _CFFI_OP(_CFFI_OP_FUNCTION, 4), // int()(sqlite3_stmt *, int, int)
/* 162 */ _CFFI_OP(_CFFI_OP_NOOP, 1),
/* 163 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 164 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 165 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 166 */ _CFFI_OP(_CFFI_OP_FUNCTION, 4), // int()(sqlite3_stmt *, int, long long)
/* 167 */ _CFFI_OP(_CFFI_OP_NOOP, 1),
/* 168 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 169 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 11),
/* 170 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 171 */ _CFFI_OP(_CFFI_OP_FUNCTION, 4), // int()(sqlite3_stmt *, int, sqlite3_value const *)
/* 172 */ _CFFI_OP(_CFFI_OP_NOOP, 1),
/* 173 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 174 */ _CFFI_OP(_CFFI_OP_POINTER, 323), // sqlite3_value const *
/* 175 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 176 */ _CFFI_OP(_CFFI_OP_FUNCTION, 4), // int()(sqlite3_stmt *, int, void const *, int, void(*)(void *))
/* 177 */ _CFFI_OP(_CFFI_OP_NOOP, 1),
/* 178 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 179 */ _CFFI_OP(_CFFI_OP_NOOP, 138),
/* 180 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 181 */ _CFFI_OP(_CFFI_OP_NOOP, 66),
/* 182 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 183 */ _CFFI_OP(_CFFI_OP_FUNCTION, 4), // int()(sqlite3_value *)
/* 184 */ _CFFI_OP(_CFFI_OP_NOOP, 20),
/* 185 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 186 */ _CFFI_OP(_CFFI_OP_FUNCTION, 4), // int()(unsigned int, void *, void *, void *)
/* 187 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 8),
/* 188 */ _CFFI_OP(_CFFI_OP_NOOP, 61),
/* 189 */ _CFFI_OP(_CFFI_OP_NOOP, 61),
/* 190 */ _CFFI_OP(_CFFI_OP_NOOP, 61),
/* 191 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 192 */ _CFFI_OP(_CFFI_OP_FUNCTION, 4), // int()(void *)
/* 193 */ _CFFI_OP(_CFFI_OP_NOOP, 61),
/* 194 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 195 */ _CFFI_OP(_CFFI_OP_FUNCTION, 4), // int()(void *, int, char const *, char const *, char const *, char const *)
/* 196 */ _CFFI_OP(_CFFI_OP_NOOP, 61),
/* 197 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 198 */ _CFFI_OP(_CFFI_OP_NOOP, 23),
/* 199 */ _CFFI_OP(_CFFI_OP_NOOP, 23),
/* 200 */ _CFFI_OP(_CFFI_OP_NOOP, 23),
/* 201 */ _CFFI_OP(_CFFI_OP_NOOP, 23),
/* 202 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 203 */ _CFFI_OP(_CFFI_OP_FUNCTION, 4), // int()(void *, int, void const *, int, void const *)
/* 204 */ _CFFI_OP(_CFFI_OP_NOOP, 61),
/* 205 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 206 */ _CFFI_OP(_CFFI_OP_NOOP, 138),
/* 207 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 208 */ _CFFI_OP(_CFFI_OP_NOOP, 138),
/* 209 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 210 */ _CFFI_OP(_CFFI_OP_FUNCTION, 4), // int()(void)
/* 211 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 212 */ _CFFI_OP(_CFFI_OP_FUNCTION, 52), // long long()(sqlite3 *)
/* 213 */ _CFFI_OP(_CFFI_OP_NOOP, 7),
/* 214 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 215 */ _CFFI_OP(_CFFI_OP_FUNCTION, 52), // long long()(sqlite3_stmt *, int)
/* 216 */ _CFFI_OP(_CFFI_OP_NOOP, 1),
/* 217 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 218 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 219 */ _CFFI_OP(_CFFI_OP_FUNCTION, 52), // long long()(sqlite3_value *)
/* 220 */ _CFFI_OP(_CFFI_OP_NOOP, 20),
/* 221 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 222 */ _CFFI_OP(_CFFI_OP_FUNCTION, 121), // sqlite3_backup *()(sqlite3 *, char const *, sqlite3 *, char const *)
/* 223 */ _CFFI_OP(_CFFI_OP_NOOP, 7),
/* 224 */ _CFFI_OP(_CFFI_OP_NOOP, 23),
/* 225 */ _CFFI_OP(_CFFI_OP_NOOP, 7),
/* 226 */ _CFFI_OP(_CFFI_OP_NOOP, 23),
/* 227 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 228 */ _CFFI_OP(_CFFI_OP_FUNCTION, 95), // unsigned char *()(sqlite3 *, char const *, long long *, unsigned int)
/* 229 */ _CFFI_OP(_CFFI_OP_NOOP, 7),
/* 230 */ _CFFI_OP(_CFFI_OP_NOOP, 23),
/* 231 */ _CFFI_OP(_CFFI_OP_POINTER, 52), // long long *
/* 232 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 8),
/* 233 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 234 */ _CFFI_OP(_CFFI_OP_FUNCTION, 324), // unsigned char const *()(sqlite3_stmt *, int)
/* 235 */ _CFFI_OP(_CFFI_OP_NOOP, 1),
/* 236 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 237 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 238 */ _CFFI_OP(_CFFI_OP_FUNCTION, 324), // unsigned char const *()(sqlite3_value *)
/* 239 */ _CFFI_OP(_CFFI_OP_NOOP, 20),
/* 240 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 241 */ _CFFI_OP(_CFFI_OP_FUNCTION, 61), // void *()(int)
/* 242 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 243 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 244 */ _CFFI_OP(_CFFI_OP_FUNCTION, 61), // void *()(sqlite3_context *, int)
/* 245 */ _CFFI_OP(_CFFI_OP_POINTER, 321), // sqlite3_context *
/* 246 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 247 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 248 */ _CFFI_OP(_CFFI_OP_FUNCTION, 61), // void *()(unsigned long long)
/* 249 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 12), // unsigned long long
/* 250 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 251 */ _CFFI_OP(_CFFI_OP_FUNCTION, 138), // void const *()(sqlite3_stmt *, int)
/* 252 */ _CFFI_OP(_CFFI_OP_NOOP, 1),
/* 253 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 254 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 255 */ _CFFI_OP(_CFFI_OP_FUNCTION, 138), // void const *()(sqlite3_value *)
/* 256 */ _CFFI_OP(_CFFI_OP_NOOP, 20),
/* 257 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 258 */ _CFFI_OP(_CFFI_OP_FUNCTION, 326), // void()(sqlite3 *)
/* 259 */ _CFFI_OP(_CFFI_OP_NOOP, 7),
/* 260 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 261 */ _CFFI_OP(_CFFI_OP_FUNCTION, 326), // void()(sqlite3 *, int, int(*)(void *), void *)
/* 262 */ _CFFI_OP(_CFFI_OP_NOOP, 7),
/* 263 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 264 */ _CFFI_OP(_CFFI_OP_POINTER, 192), // int(*)(void *)
/* 265 */ _CFFI_OP(_CFFI_OP_NOOP, 61),
/* 266 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 267 */ _CFFI_OP(_CFFI_OP_FUNCTION, 326), // void()(sqlite3_context *)
/* 268 */ _CFFI_OP(_CFFI_OP_NOOP, 245),
/* 269 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 270 */ _CFFI_OP(_CFFI_OP_FUNCTION, 326), // void()(sqlite3_context *, char const *, int)
/* 271 */ _CFFI_OP(_CFFI_OP_NOOP, 245),
/* 272 */ _CFFI_OP(_CFFI_OP_NOOP, 23),
/* 273 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 274 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 275 */ _CFFI_OP(_CFFI_OP_FUNCTION, 326), // void()(sqlite3_context *, char const *, int, void(*)(void *))
/* 276 */ _CFFI_OP(_CFFI_OP_NOOP, 245),
/* 277 */ _CFFI_OP(_CFFI_OP_NOOP, 23),
/* 278 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 279 */ _CFFI_OP(_CFFI_OP_NOOP, 66),
/* 280 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 281 */ _CFFI_OP(_CFFI_OP_FUNCTION, 326), // void()(sqlite3_context *, double)
/* 282 */ _CFFI_OP(_CFFI_OP_NOOP, 245),
/* 283 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 14),
/* 284 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 285 */ _CFFI_OP(_CFFI_OP_FUNCTION, 326), // void()(sqlite3_context *, int)
/* 286 */ _CFFI_OP(_CFFI_OP_NOOP, 245),
/* 287 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 288 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 289 */ _CFFI_OP(_CFFI_OP_FUNCTION, 326), // void()(sqlite3_context *, int, sqlite3_value * *)
/* 290 */ _CFFI_OP(_CFFI_OP_NOOP, 245),
/* 291 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 292 */ _CFFI_OP(_CFFI_OP_POINTER, 20), // sqlite3_value * *
/* 293 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 294 */ _CFFI_OP(_CFFI_OP_FUNCTION, 326), // void()(sqlite3_context *, long long)
/* 295 */ _CFFI_OP(_CFFI_OP_NOOP, 245),
/* 296 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 11),
/* 297 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 298 */ _CFFI_OP(_CFFI_OP_FUNCTION, 326), // void()(sqlite3_context *, sqlite3_value *)
/* 299 */ _CFFI_OP(_CFFI_OP_NOOP, 245),
/* 300 */ _CFFI_OP(_CFFI_OP_NOOP, 20),
/* 301 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 302 */ _CFFI_OP(_CFFI_OP_FUNCTION, 326), // void()(sqlite3_context *, void const *, int)
/* 303 */ _CFFI_OP(_CFFI_OP_NOOP, 245),
/* 304 */ _CFFI_OP(_CFFI_OP_NOOP, 138),
/* 305 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 306 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 307 */ _CFFI_OP(_CFFI_OP_FUNCTION, 326), // void()(sqlite3_context *, void const *, int, void(*)(void *))
/* 308 */ _CFFI_OP(_CFFI_OP_NOOP, 245),
/* 309 */ _CFFI_OP(_CFFI_OP_NOOP, 138),
/* 310 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 311 */ _CFFI_OP(_CFFI_OP_NOOP, 66),
/* 312 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 313 */ _CFFI_OP(_CFFI_OP_FUNCTION, 326), // void()(void *)
/* 314 */ _CFFI_OP(_CFFI_OP_NOOP, 61),
/* 315 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 316 */ _CFFI_OP(_CFFI_OP_POINTER, 317), // char *
/* 317 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 2), // char
/* 318 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 0), // sqlite3
/* 319 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 1), // sqlite3_backup
/* 320 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 2), // sqlite3_blob
/* 321 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 3), // sqlite3_context
/* 322 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 4), // sqlite3_stmt
/* 323 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 5), // sqlite3_value
/* 324 */ _CFFI_OP(_CFFI_OP_POINTER, 325), // unsigned char const *
/* 325 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 4), // unsigned char
/* 326 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 0), // void
};

static int _cffi_const_SQLITE_OPEN_CREATE(unsigned long long *o)
{
  int n = (SQLITE_OPEN_CREATE) <= 0;
  *o = (unsigned long long)((SQLITE_OPEN_CREATE) | 0);  /* check that SQLITE_OPEN_CREATE is an integer */
  return n;
}

static int _cffi_const_SQLITE_OPEN_READWRITE(unsigned long long *o)
{
  int n = (SQLITE_OPEN_READWRITE) <= 0;
  *o = (unsigned long long)((SQLITE_OPEN_READWRITE) | 0);  /* check that SQLITE_OPEN_READWRITE is an integer */
  return n;
}

static int _cffi_const_SQLITE_OPEN_URI(unsigned long long *o)
{
  int n = (SQLITE_OPEN_URI) <= 0;
  *o = (unsigned long long)((SQLITE_OPEN_URI) | 0);  /* check that SQLITE_OPEN_URI is an integer */
  return n;
}

static void _cffi_const_SQLITE_TRANSIENT(char *o)
{
  *(void * *)o = SQLITE_TRANSIENT;
}

static void * _cffi_d_sqlite3_aggregate_context(sqlite3_context * x0, int x1)
{
  return sqlite3_aggregate_context(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_sqlite3_aggregate_context(PyObject *self, PyObject *args)
{
  sqlite3_context * x0;
  int x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  void * result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "sqlite3_aggregate_context", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(245), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (sqlite3_context *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(245), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = sqlite3_aggregate_context(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(61));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_sqlite3_aggregate_context _cffi_d_sqlite3_aggregate_context
#endif

static int _cffi_d_sqlite3_backup_finish(sqlite3_backup * x0)
{
  return sqlite3_backup_finish(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_sqlite3_backup_finish(PyObject *self, PyObject *arg0)
{
  sqlite3_backup * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(121), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (sqlite3_backup *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(121), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = sqlite3_backup_finish(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_sqlite3_backup_finish _cffi_d_sqlite3_backup_finish
#endif

static sqlite3_backup * _cffi_d_sqlite3_backup_init(sqlite3 * x0, char const * x1, sqlite3 * x2, char const * x3)
{
  return sqlite3_backup_init(x0, x1, x2, x3);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_sqlite3_backup_init(PyObject *self, PyObject *args)
{
  sqlite3 * x0;
  char const * x1;
  sqlite3 * x2;
  char const * x3;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  sqlite3_backup * result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;

  if (!PyArg_UnpackTuple(args, "sqlite3_backup_init", 4, 4, &arg0, &arg1, &arg2, &arg3))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(7), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (sqlite3 *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(7), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(23), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(23), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(7), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (sqlite3 *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(7), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(23), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(23), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = sqlite3_backup_init(x0, x1, x2, x3); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(121));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_sqlite3_backup_init _cffi_d_sqlite3_backup_init
#endif

static int _cffi_d_sqlite3_backup_pagecount(sqlite3_backup * x0)
{
  return sqlite3_backup_pagecount(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_sqlite3_backup_pagecount(PyObject *self, PyObject *arg0)
{
  sqlite3_backup * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(121), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (sqlite3_backup *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(121), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = sqlite3_backup_pagecount(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_sqlite3_backup_pagecount _cffi_d_sqlite3_backup_pagecount
#endif

static int _cffi_d_sqlite3_backup_remaining(sqlite3_backup * x0)
{
  return sqlite3_backup_remaining(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_sqlite3_backup_remaining(PyObject *self, PyObject *arg0)
{
  sqlite3_backup * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(121), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (sqlite3_backup *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(121), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = sqlite3_backup_remaining(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_sqlite3_backup_remaining _cffi_d_sqlite3_backup_remaining
#endif

static int _cffi_d_sqlite3_backup_step(sqlite3_backup * x0, int x1)
{
  return sqlite3_backup_step(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_sqlite3_backup_step(PyObject *self, PyObject *args)
{
  sqlite3_backup * x0;
  int x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "sqlite3_backup_step", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(121), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (sqlite3_backup *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(121), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = sqlite3_backup_step(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_sqlite3_backup_step _cffi_d_sqlite3_backup_step
#endif

static int _cffi_d_sqlite3_bind_blob(sqlite3_stmt * x0, int x1, void const * x2, int x3, void(* x4)(void *))
{
  return sqlite3_bind_blob(x0, x1, x2, x3, x4);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_sqlite3_bind_blob(PyObject *self, PyObject *args)
{
  sqlite3_stmt * x0;
  int x1;
  void const * x2;
  int x3;
  void(* x4)(void *);
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;

  if (!PyArg_UnpackTuple(args, "sqlite3_bind_blob", 5, 5, &arg0, &arg1, &arg2, &arg3, &arg4))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (sqlite3_stmt *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(138), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (void const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(138), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x3 = _cffi_to_c_int(arg3, int);
  if (x3 == (int)-1 && PyErr_Occurred())
    return NULL;

  x4 = (void(*)(void *))_cffi_to_c_pointer(arg4, _cffi_type(66));
  if (x4 == (void(*)(void *))NULL && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = sqlite3_bind_blob(x0, x1, x2, x3, x4); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_sqlite3_bind_blob _cffi_d_sqlite3_bind_blob
#endif

static int _cffi_d_sqlite3_bind_double(sqlite3_stmt * x0, int x1, double x2)
{
  return sqlite3_bind_double(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_sqlite3_bind_double(PyObject *self, PyObject *args)
{
  sqlite3_stmt * x0;
  int x1;
  double x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "sqlite3_bind_double", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (sqlite3_stmt *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  x2 = (double)_cffi_to_c_double(arg2);
  if (x2 == (double)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = sqlite3_bind_double(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_sqlite3_bind_double _cffi_d_sqlite3_bind_double
#endif

static int _cffi_d_sqlite3_bind_int(sqlite3_stmt * x0, int x1, int x2)
{
  return sqlite3_bind_int(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_sqlite3_bind_int(PyObject *self, PyObject *args)
{
  sqlite3_stmt * x0;
  int x1;
  int x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "sqlite3_bind_int", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (sqlite3_stmt *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, int);
  if (x2 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = sqlite3_bind_int(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_sqlite3_bind_int _cffi_d_sqlite3_bind_int
#endif

static int _cffi_d_sqlite3_bind_int64(sqlite3_stmt * x0, int x1, long long x2)
{
  return sqlite3_bind_int64(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_sqlite3_bind_int64(PyObject *self, PyObject *args)
{
  sqlite3_stmt * x0;
  int x1;
  long long x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "sqlite3_bind_int64", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (sqlite3_stmt *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, long long);
  if (x2 == (long long)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = sqlite3_bind_int64(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_sqlite3_bind_int64 _cffi_d_sqlite3_bind_int64
#endif

static int _cffi_d_sqlite3_bind_null(sqlite3_stmt * x0, int x1)
{
  return sqlite3_bind_null(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_sqlite3_bind_null(PyObject *self, PyObject *args)
{
  sqlite3_stmt * x0;
  int x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "sqlite3_bind_null", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (sqlite3_stmt *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = sqlite3_bind_null(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_sqlite3_bind_null _cffi_d_sqlite3_bind_null
#endif

static int _cffi_d_sqlite3_bind_parameter_count(sqlite3_stmt * x0)
{
  return sqlite3_bind_parameter_count(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_sqlite3_bind_parameter_count(PyObject *self, PyObject *arg0)
{
  sqlite3_stmt * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (sqlite3_stmt *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = sqlite3_bind_parameter_count(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_sqlite3_bind_parameter_count _cffi_d_sqlite3_bind_parameter_count
#endif

static char const * _cffi_d_sqlite3_bind_parameter_name(sqlite3_stmt * x0, int x1)
{
  return sqlite3_bind_parameter_name(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_sqlite3_bind_parameter_name(PyObject *self, PyObject *args)
{
  sqlite3_stmt * x0;
  int x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  char const * result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "sqlite3_bind_parameter_name", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (sqlite3_stmt *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = sqlite3_bind_parameter_name(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(23));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_sqlite3_bind_parameter_name _cffi_d_sqlite3_bind_parameter_name
#endif

static int _cffi_d_sqlite3_bind_text(sqlite3_stmt * x0, int x1, char const * x2, int x3, void(* x4)(void *))
{
  return sqlite3_bind_text(x0, x1, x2, x3, x4);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_sqlite3_bind_text(PyObject *self, PyObject *args)
{
  sqlite3_stmt * x0;
  int x1;
  char const * x2;
  int x3;
  void(* x4)(void *);
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;

  if (!PyArg_UnpackTuple(args, "sqlite3_bind_text", 5, 5, &arg0, &arg1, &arg2, &arg3, &arg4))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (sqlite3_stmt *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(23), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(23), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x3 = _cffi_to_c_int(arg3, int);
  if (x3 == (int)-1 && PyErr_Occurred())
    return NULL;

  x4 = (void(*)(void *))_cffi_to_c_pointer(arg4, _cffi_type(66));
  if (x4 == (void(*)(void *))NULL && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = sqlite3_bind_text(x0, x1, x2, x3, x4); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_sqlite3_bind_text _cffi_d_sqlite3_bind_text
#endif

static int _cffi_d_sqlite3_bind_text16(sqlite3_stmt * x0, int x1, void const * x2, int x3, void(* x4)(void *))
{
  return sqlite3_bind_text16(x0, x1, x2, x3, x4);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_sqlite3_bind_text16(PyObject *self, PyObject *args)
{
  sqlite3_stmt * x0;
  int x1;
  void const * x2;
  int x3;
  void(* x4)(void *);
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;

  if (!PyArg_UnpackTuple(args, "sqlite3_bind_text16", 5, 5, &arg0, &arg1, &arg2, &arg3, &arg4))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (sqlite3_stmt *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(138), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (void const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(138), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x3 = _cffi_to_c_int(arg3, int);
  if (x3 == (int)-1 && PyErr_Occurred())
    return NULL;

  x4 = (void(*)(void *))_cffi_to_c_pointer(arg4, _cffi_type(66));
  if (x4 == (void(*)(void *))NULL && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = sqlite3_bind_text16(x0, x1, x2, x3, x4); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_sqlite3_bind_text16 _cffi_d_sqlite3_bind_text16
#endif

static int _cffi_d_sqlite3_bind_value(sqlite3_stmt * x0, int x1, sqlite3_value const * x2)
{
  return sqlite3_bind_value(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_sqlite3_bind_value(PyObject *self, PyObject *args)
{
  sqlite3_stmt * x0;
  int x1;
  sqlite3_value const * x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "sqlite3_bind_value", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (sqlite3_stmt *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(174), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (sqlite3_value const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(174), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = sqlite3_bind_value(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_sqlite3_bind_value _cffi_d_sqlite3_bind_value
#endif

static int _cffi_d_sqlite3_bind_zeroblob(sqlite3_stmt * x0, int x1, int x2)
{
  return sqlite3_bind_zeroblob(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_sqlite3_bind_zeroblob(PyObject *self, PyObject *args)
{
  sqlite3_stmt * x0;
  int x1;
  int x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "sqlite3_bind_zeroblob", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (sqlite3_stmt *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, int);
  if (x2 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = sqlite3_bind_zeroblob(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_sqlite3_bind_zeroblob _cffi_d_sqlite3_bind_zeroblob
#endif

static int _cffi_d_sqlite3_blob_bytes(sqlite3_blob * x0)
{
  return sqlite3_blob_bytes(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_sqlite3_blob_bytes(PyObject *self, PyObject *arg0)
{
  sqlite3_blob * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(128), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (sqlite3_blob *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(128), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = sqlite3_blob_bytes(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_sqlite3_blob_bytes _cffi_d_sqlite3_blob_bytes
#endif

static int _cffi_d_sqlite3_blob_close(sqlite3_blob * x0)
{
  return sqlite3_blob_close(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_sqlite3_blob_close(PyObject *self, PyObject *arg0)
{
  sqlite3_blob * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(128), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (sqlite3_blob *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(128), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = sqlite3_blob_close(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_sqlite3_blob_close _cffi_d_sqlite3_blob_close
#endif

static int _cffi_d_sqlite3_blob_open(sqlite3 * x0, char const * x1, char const * x2, char const * x3, long long x4, int x5, sqlite3_blob * * x6)
{
  return sqlite3_blob_open(x0, x1, x2, x3, x4, x5, x6);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_sqlite3_blob_open(PyObject *self, PyObject *args)
{
  sqlite3 * x0;
  char const * x1;
  char const * x2;
  char const * x3;
  long long x4;
  int x5;
  sqlite3_blob * * x6;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;
  PyObject *arg6;

  if (!PyArg_UnpackTuple(args, "sqlite3_blob_open", 7, 7, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5, &arg6))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(7), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (sqlite3 *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(7), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(23), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(23), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(23), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(23), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(23), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(23), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x4 = _cffi_to_c_int(arg4, long long);
  if (x4 == (long long)-1 && PyErr_Occurred())
    return NULL;

  x5 = _cffi_to_c_int(arg5, int);
  if (x5 == (int)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(54), arg6, (char **)&x6);
  if (datasize != 0) {
    x6 = ((size_t)datasize) <= 640 ? (sqlite3_blob * *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(54), arg6, (char **)&x6,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = sqlite3_blob_open(x0, x1, x2, x3, x4, x5, x6); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_sqlite3_blob_open _cffi_d_sqlite3_blob_open
#endif

static int _cffi_d_sqlite3_blob_read(sqlite3_blob * x0, void * x1, int x2, int x3)
{
  return sqlite3_blob_read(x0, x1, x2, x3);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_sqlite3_blob_read(PyObject *self, PyObject *args)
{
  sqlite3_blob * x0;
  void * x1;
  int x2;
  int x3;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;

  if (!PyArg_UnpackTuple(args, "sqlite3_blob_read", 4, 4, &arg0, &arg1, &arg2, &arg3))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(128), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (sqlite3_blob *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(128), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(61), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (void *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(61), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, int);
  if (x2 == (int)-1 && PyErr_Occurred())
    return NULL;

  x3 = _cffi_to_c_int(arg3, int);
  if (x3 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = sqlite3_blob_read(x0, x1, x2, x3); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_sqlite3_blob_read _cffi_d_sqlite3_blob_read
#endif

static int _cffi_d_sqlite3_blob_write(sqlite3_blob * x0, void const * x1, int x2, int x3)
{
  return sqlite3_blob_write(x0, x1, x2, x3);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_sqlite3_blob_write(PyObject *self, PyObject *args)
{
  sqlite3_blob * x0;
  void const * x1;
  int x2;
  int x3;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;

  if (!PyArg_UnpackTuple(args, "sqlite3_blob_write", 4, 4, &arg0, &arg1, &arg2, &arg3))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(128), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (sqlite3_blob *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(128), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(138), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (void const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(138), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, int);
  if (x2 == (int)-1 && PyErr_Occurred())
    return NULL;

  x3 = _cffi_to_c_int(arg3, int);
  if (x3 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = sqlite3_blob_write(x0, x1, x2, x3); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_sqlite3_blob_write _cffi_d_sqlite3_blob_write
#endif

static int _cffi_d_sqlite3_busy_timeout(sqlite3 * x0, int x1)
{
  return sqlite3_busy_timeout(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_sqlite3_busy_timeout(PyObject *self, PyObject *args)
{
  sqlite3 * x0;
  int x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "sqlite3_busy_timeout", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(7), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (sqlite3 *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(7), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = sqlite3_busy_timeout(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_sqlite3_busy_timeout _cffi_d_sqlite3_busy_timeout
#endif

static int _cffi_d_sqlite3_changes(sqlite3 * x0)
{
  return sqlite3_changes(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_sqlite3_changes(PyObject *self, PyObject *arg0)
{
  sqlite3 * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(7), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (sqlite3 *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(7), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = sqlite3_changes(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_sqlite3_changes _cffi_d_sqlite3_changes
#endif

static int _cffi_d_sqlite3_close(sqlite3 * x0)
{
  return sqlite3_close(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_sqlite3_close(PyObject *self, PyObject *arg0)
{
  sqlite3 * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(7), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (sqlite3 *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(7), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = sqlite3_close(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_sqlite3_close _cffi_d_sqlite3_close
#endif

static void const * _cffi_d_sqlite3_column_blob(sqlite3_stmt * x0, int x1)
{
  return sqlite3_column_blob(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_sqlite3_column_blob(PyObject *self, PyObject *args)
{
  sqlite3_stmt * x0;
  int x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  void const * result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "sqlite3_column_blob", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (sqlite3_stmt *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = sqlite3_column_blob(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(138));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_sqlite3_column_blob _cffi_d_sqlite3_column_blob
#endif

static int _cffi_d_sqlite3_column_bytes(sqlite3_stmt * x0, int x1)
{
  return sqlite3_column_bytes(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_sqlite3_column_bytes(PyObject *self, PyObject *args)
{
  sqlite3_stmt * x0;
  int x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "sqlite3_column_bytes", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (sqlite3_stmt *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = sqlite3_column_bytes(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_sqlite3_column_bytes _cffi_d_sqlite3_column_bytes
#endif

static int _cffi_d_sqlite3_column_count(sqlite3_stmt * x0)
{
  return sqlite3_column_count(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_sqlite3_column_count(PyObject *self, PyObject *arg0)
{
  sqlite3_stmt * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (sqlite3_stmt *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = sqlite3_column_count(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_sqlite3_column_count _cffi_d_sqlite3_column_count
#endif

static char const * _cffi_d_sqlite3_column_decltype(sqlite3_stmt * x0, int x1)
{
  return sqlite3_column_decltype(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_sqlite3_column_decltype(PyObject *self, PyObject *args)
{
  sqlite3_stmt * x0;
  int x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  char const * result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "sqlite3_column_decltype", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (sqlite3_stmt *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = sqlite3_column_decltype(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(23));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_sqlite3_column_decltype _cffi_d_sqlite3_column_decltype
#endif

static double _cffi_d_sqlite3_column_double(sqlite3_stmt * x0, int x1)
{
  return sqlite3_column_double(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_sqlite3_column_double(PyObject *self, PyObject *args)
{
  sqlite3_stmt * x0;
  int x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  double result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "sqlite3_column_double", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (sqlite3_stmt *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = sqlite3_column_double(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_double(result);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_sqlite3_column_double _cffi_d_sqlite3_column_double
#endif

static int _cffi_d_sqlite3_column_int(sqlite3_stmt * x0, int x1)
{
  return sqlite3_column_int(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_sqlite3_column_int(PyObject *self, PyObject *args)
{
  sqlite3_stmt * x0;
  int x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "sqlite3_column_int", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (sqlite3_stmt *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = sqlite3_column_int(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_sqlite3_column_int _cffi_d_sqlite3_column_int
#endif

static long long _cffi_d_sqlite3_column_int64(sqlite3_stmt * x0, int x1)
{
  return sqlite3_column_int64(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_sqlite3_column_int64(PyObject *self, PyObject *args)
{
  sqlite3_stmt * x0;
  int x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  long long result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "sqlite3_column_int64", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (sqlite3_stmt *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = sqlite3_column_int64(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, long long);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_sqlite3_column_int64 _cffi_d_sqlite3_column_int64
#endif

static char const * _cffi_d_sqlite3_column_name(sqlite3_stmt * x0, int x1)
{
  return sqlite3_column_name(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_sqlite3_column_name(PyObject *self, PyObject *args)
{
  sqlite3_stmt * x0;
  int x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  char const * result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "sqlite3_column_name", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (sqlite3_stmt *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = sqlite3_column_name(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(23));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_sqlite3_column_name _cffi_d_sqlite3_column_name
#endif

static unsigned char const * _cffi_d_sqlite3_column_text(sqlite3_stmt * x0, int x1)
{
  return sqlite3_column_text(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_sqlite3_column_text(PyObject *self, PyObject *args)
{
  sqlite3_stmt * x0;
  int x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  unsigned char const * result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "sqlite3_column_text", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (sqlite3_stmt *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = sqlite3_column_text(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(324));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_sqlite3_column_text _cffi_d_sqlite3_column_text
#endif

static void const * _cffi_d_sqlite3_column_text16(sqlite3_stmt * x0, int x1)
{
  return sqlite3_column_text16(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_sqlite3_column_text16(PyObject *self, PyObject *args)
{
  sqlite3_stmt * x0;
  int x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  void const * result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "sqlite3_column_text16", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (sqlite3_stmt *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = sqlite3_column_text16(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(138));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_sqlite3_column_text16 _cffi_d_sqlite3_column_text16
#endif

static int _cffi_d_sqlite3_column_type(sqlite3_stmt * x0, int x1)
{
  return sqlite3_column_type(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_sqlite3_column_type(PyObject *self, PyObject *args)
{
  sqlite3_stmt * x0;
  int x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "sqlite3_column_type", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (sqlite3_stmt *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = sqlite3_column_type(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_sqlite3_column_type _cffi_d_sqlite3_column_type
#endif

static int _cffi_d_sqlite3_complete(char const * x0)
{
  return sqlite3_complete(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_sqlite3_complete(PyObject *self, PyObject *arg0)
{
  char const * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(23), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(23), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = sqlite3_complete(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_sqlite3_complete _cffi_d_sqlite3_complete
#endif

static int _cffi_d_sqlite3_create_collation(sqlite3 * x0, char const * x1, int x2, void * x3, int(* x4)(void *, int, void const *, int, void const *))
{
  return sqlite3_create_collation(x0, x1, x2, x3, x4);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_sqlite3_create_collation(PyObject *self, PyObject *args)
{
  sqlite3 * x0;
  char const * x1;
  int x2;
  void * x3;
  int(* x4)(void *, int, void const *, int, void const *);
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;

  if (!PyArg_UnpackTuple(args, "sqlite3_create_collation", 5, 5, &arg0, &arg1, &arg2, &arg3, &arg4))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(7), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (sqlite3 *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(7), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(23), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(23), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, int);
  if (x2 == (int)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(61), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (void *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(61), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x4 = (int(*)(void *, int, void const *, int, void const *))_cffi_to_c_pointer(arg4, _cffi_type(90));
  if (x4 == (int(*)(void *, int, void const *, int, void const *))NULL && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = sqlite3_create_collation(x0, x1, x2, x3, x4); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_sqlite3_create_collation _cffi_d_sqlite3_create_collation
#endif

static int _cffi_d_sqlite3_create_function(sqlite3 * x0, char const * x1, int x2, int x3, void * x4, void(* x5)(sqlite3_context *, int, sqlite3_value * *), void(* x6)(sqlite3_context *, int, sqlite3_value * *), void(* x7)(sqlite3_context *))
{
  return sqlite3_create_function(x0, x1, x2, x3, x4, x5, x6, x7);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_sqlite3_create_function(PyObject *self, PyObject *args)
{
  sqlite3 * x0;
  char const * x1;
  int x2;
  int x3;
  void * x4;
  void(* x5)(sqlite3_context *, int, sqlite3_value * *);
  void(* x6)(sqlite3_context *, int, sqlite3_value * *);
  void(* x7)(sqlite3_context *);
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;
  PyObject *arg6;
  PyObject *arg7;

  if (!PyArg_UnpackTuple(args, "sqlite3_create_function", 8, 8, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5, &arg6, &arg7))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(7), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (sqlite3 *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(7), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(23), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(23), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, int);
  if (x2 == (int)-1 && PyErr_Occurred())
    return NULL;

  x3 = _cffi_to_c_int(arg3, int);
  if (x3 == (int)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(61), arg4, (char **)&x4);
  if (datasize != 0) {
    x4 = ((size_t)datasize) <= 640 ? (void *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(61), arg4, (char **)&x4,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x5 = (void(*)(sqlite3_context *, int, sqlite3_value * *))_cffi_to_c_pointer(arg5, _cffi_type(62));
  if (x5 == (void(*)(sqlite3_context *, int, sqlite3_value * *))NULL && PyErr_Occurred())
    return NULL;

  x6 = (void(*)(sqlite3_context *, int, sqlite3_value * *))_cffi_to_c_pointer(arg6, _cffi_type(62));
  if (x6 == (void(*)(sqlite3_context *, int, sqlite3_value * *))NULL && PyErr_Occurred())
    return NULL;

  x7 = (void(*)(sqlite3_context *))_cffi_to_c_pointer(arg7, _cffi_type(63));
  if (x7 == (void(*)(sqlite3_context *))NULL && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = sqlite3_create_function(x0, x1, x2, x3, x4, x5, x6, x7); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_sqlite3_create_function _cffi_d_sqlite3_create_function
#endif

static int _cffi_d_sqlite3_create_window_function(sqlite3 * x0, char const * x1, int x2, int x3, void * x4, void(* x5)(sqlite3_context *, int, sqlite3_value * *), void(* x6)(sqlite3_context *), void(* x7)(sqlite3_context *), void(* x8)(sqlite3_context *, int, sqlite3_value * *), void(* x9)(void *))
{
  return sqlite3_create_window_function(x0, x1, x2, x3, x4, x5, x6, x7, x8, x9);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_sqlite3_create_window_function(PyObject *self, PyObject *args)
{
  sqlite3 * x0;
  char const * x1;
  int x2;
  int x3;
  void * x4;
  void(* x5)(sqlite3_context *, int, sqlite3_value * *);
  void(* x6)(sqlite3_context *);
  void(* x7)(sqlite3_context *);
  void(* x8)(sqlite3_context *, int, sqlite3_value * *);
  void(* x9)(void *);
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;
  PyObject *arg6;
  PyObject *arg7;
  PyObject *arg8;
  PyObject *arg9;

  if (!PyArg_UnpackTuple(args, "sqlite3_create_window_function", 10, 10, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5, &arg6, &arg7, &arg8, &arg9))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(7), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (sqlite3 *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(7), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(23), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(23), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, int);
  if (x2 == (int)-1 && PyErr_Occurred())
    return NULL;

  x3 = _cffi_to_c_int(arg3, int);
  if (x3 == (int)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(61), arg4, (char **)&x4);
  if (datasize != 0) {
    x4 = ((size_t)datasize) <= 640 ? (void *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(61), arg4, (char **)&x4,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x5 = (void(*)(sqlite3_context *, int, sqlite3_value * *))_cffi_to_c_pointer(arg5, _cffi_type(62));
  if (x5 == (void(*)(sqlite3_context *, int, sqlite3_value * *))NULL && PyErr_Occurred())
    return NULL;

  x6 = (void(*)(sqlite3_context *))_cffi_to_c_pointer(arg6, _cffi_type(63));
  if (x6 == (void(*)(sqlite3_context *))NULL && PyErr_Occurred())
    return NULL;

  x7 = (void(*)(sqlite3_context *))_cffi_to_c_pointer(arg7, _cffi_type(63));
  if (x7 == (void(*)(sqlite3_context *))NULL && PyErr_Occurred())
    return NULL;

  x8 = (void(*)(sqlite3_context *, int, sqlite3_value * *))_cffi_to_c_pointer(arg8, _cffi_type(62));
  if (x8 == (void(*)(sqlite3_context *, int, sqlite3_value * *))NULL && PyErr_Occurred())
    return NULL;

  x9 = (void(*)(void *))_cffi_to_c_pointer(arg9, _cffi_type(66));
  if (x9 == (void(*)(void *))NULL && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = sqlite3_create_window_function(x0, x1, x2, x3, x4, x5, x6, x7, x8, x9); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_sqlite3_create_window_function _cffi_d_sqlite3_create_window_function
#endif

static int _cffi_d_sqlite3_data_count(sqlite3_stmt * x0)
{
  return sqlite3_data_count(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_sqlite3_data_count(PyObject *self, PyObject *arg0)
{
  sqlite3_stmt * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (sqlite3_stmt *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = sqlite3_data_count(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_sqlite3_data_count _cffi_d_sqlite3_data_count
#endif

static int _cffi_d_sqlite3_deserialize(sqlite3 * x0, char const * x1, unsigned char * x2, long long x3, long long x4, unsigned int x5)
{
  return sqlite3_deserialize(x0, x1, x2, x3, x4, x5);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_sqlite3_deserialize(PyObject *self, PyObject *args)
{
  sqlite3 * x0;
  char const * x1;
  unsigned char * x2;
  long long x3;
  long long x4;
  unsigned int x5;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;

  if (!PyArg_UnpackTuple(args, "sqlite3_deserialize", 6, 6, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(7), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (sqlite3 *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(7), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(23), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(23), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(95), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (unsigned char *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(95), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x3 = _cffi_to_c_int(arg3, long long);
  if (x3 == (long long)-1 && PyErr_Occurred())
    return NULL;

  x4 = _cffi_to_c_int(arg4, long long);
  if (x4 == (long long)-1 && PyErr_Occurred())
    return NULL;

  x5 = _cffi_to_c_int(arg5, unsigned int);
  if (x5 == (unsigned int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = sqlite3_deserialize(x0, x1, x2, x3, x4, x5); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_sqlite3_deserialize _cffi_d_sqlite3_deserialize
#endif

static int _cffi_d_sqlite3_enable_load_extension(sqlite3 * x0, int x1)
{
  return sqlite3_enable_load_extension(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_sqlite3_enable_load_extension(PyObject *self, PyObject *args)
{
  sqlite3 * x0;
  int x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "sqlite3_enable_load_extension", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(7), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (sqlite3 *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(7), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = sqlite3_enable_load_extension(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_sqlite3_enable_load_extension _cffi_d_sqlite3_enable_load_extension
#endif

static int _cffi_d_sqlite3_errcode(sqlite3 * x0)
{
  return sqlite3_errcode(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_sqlite3_errcode(PyObject *self, PyObject *arg0)
{
  sqlite3 * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(7), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (sqlite3 *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(7), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = sqlite3_errcode(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_sqlite3_errcode _cffi_d_sqlite3_errcode
#endif

static char const * _cffi_d_sqlite3_errmsg(sqlite3 * x0)
{
  return sqlite3_errmsg(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_sqlite3_errmsg(PyObject *self, PyObject *arg0)
{
  sqlite3 * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  char const * result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(7), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (sqlite3 *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(7), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = sqlite3_errmsg(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(23));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_sqlite3_errmsg _cffi_d_sqlite3_errmsg
#endif

static char const * _cffi_d_sqlite3_errstr(int x0)
{
  return sqlite3_errstr(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_sqlite3_errstr(PyObject *self, PyObject *arg0)
{
  int x0;
  char const * result;
  PyObject *pyresult;

  x0 = _cffi_to_c_int(arg0, int);
  if (x0 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = sqlite3_errstr(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(23));
  return pyresult;
}
#else
#  define _cffi_f_sqlite3_errstr _cffi_d_sqlite3_errstr
#endif

static char * _cffi_d_sqlite3_expanded_sql(sqlite3_stmt * x0)
{
  return sqlite3_expanded_sql(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_sqlite3_expanded_sql(PyObject *self, PyObject *arg0)
{
  sqlite3_stmt * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  char * result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (sqlite3_stmt *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = sqlite3_expanded_sql(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(316));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_sqlite3_expanded_sql _cffi_d_sqlite3_expanded_sql
#endif

static int _cffi_d_sqlite3_extended_errcode(sqlite3 * x0)
{
  return sqlite3_extended_errcode(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_sqlite3_extended_errcode(PyObject *self, PyObject *arg0)
{
  sqlite3 * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(7), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (sqlite3 *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(7), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = sqlite3_extended_errcode(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_sqlite3_extended_errcode _cffi_d_sqlite3_extended_errcode
#endif

static int _cffi_d_sqlite3_finalize(sqlite3_stmt * x0)
{
  return sqlite3_finalize(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_sqlite3_finalize(PyObject *self, PyObject *arg0)
{
  sqlite3_stmt * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (sqlite3_stmt *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = sqlite3_finalize(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_sqlite3_finalize _cffi_d_sqlite3_finalize
#endif

static void _cffi_d_sqlite3_free(void * x0)
{
  sqlite3_free(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_sqlite3_free(PyObject *self, PyObject *arg0)
{
  void * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(61), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (void *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(61), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { sqlite3_free(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_sqlite3_free _cffi_d_sqlite3_free
#endif

static int _cffi_d_sqlite3_get_autocommit(sqlite3 * x0)
{
  return sqlite3_get_autocommit(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_sqlite3_get_autocommit(PyObject *self, PyObject *arg0)
{
  sqlite3 * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(7), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (sqlite3 *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(7), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = sqlite3_get_autocommit(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_sqlite3_get_autocommit _cffi_d_sqlite3_get_autocommit
#endif

static void _cffi_d_sqlite3_interrupt(sqlite3 * x0)
{
  sqlite3_interrupt(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_sqlite3_interrupt(PyObject *self, PyObject *arg0)
{
  sqlite3 * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(7), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (sqlite3 *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(7), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { sqlite3_interrupt(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_sqlite3_interrupt _cffi_d_sqlite3_interrupt
#endif

static long long _cffi_d_sqlite3_last_insert_rowid(sqlite3 * x0)
{
  return sqlite3_last_insert_rowid(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_sqlite3_last_insert_rowid(PyObject *self, PyObject *arg0)
{
  sqlite3 * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  long long result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(7), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (sqlite3 *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(7), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = sqlite3_last_insert_rowid(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, long long);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_sqlite3_last_insert_rowid _cffi_d_sqlite3_last_insert_rowid
#endif

static char const * _cffi_d_sqlite3_libversion(void)
{
  return sqlite3_libversion();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_sqlite3_libversion(PyObject *self, PyObject *noarg)
{
  char const * result;
  PyObject *pyresult;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = sqlite3_libversion(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(23));
  return pyresult;
}
#else
#  define _cffi_f_sqlite3_libversion _cffi_d_sqlite3_libversion
#endif

static int _cffi_d_sqlite3_libversion_number(void)
{
  return sqlite3_libversion_number();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_sqlite3_libversion_number(PyObject *self, PyObject *noarg)
{
  int result;
  PyObject *pyresult;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = sqlite3_libversion_number(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  return pyresult;
}
#else
#  define _cffi_f_sqlite3_libversion_number _cffi_d_sqlite3_libversion_number
#endif

static int _cffi_d_sqlite3_limit(sqlite3 * x0, int x1, int x2)
{
  return sqlite3_limit(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_sqlite3_limit(PyObject *self, PyObject *args)
{
  sqlite3 * x0;
  int x1;
  int x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "sqlite3_limit", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(7), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (sqlite3 *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(7), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, int);
  if (x2 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = sqlite3_limit(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_sqlite3_limit _cffi_d_sqlite3_limit
#endif

static int _cffi_d_sqlite3_load_extension(sqlite3 * x0, char const * x1, char const * x2, char * * x3)
{
  return sqlite3_load_extension(x0, x1, x2, x3);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_sqlite3_load_extension(PyObject *self, PyObject *args)
{
  sqlite3 * x0;
  char const * x1;
  char const * x2;
  char * * x3;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;

  if (!PyArg_UnpackTuple(args, "sqlite3_load_extension", 4, 4, &arg0, &arg1, &arg2, &arg3))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(7), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (sqlite3 *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(7), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(23), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(23), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(23), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(23), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(45), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (char * *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(45), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = sqlite3_load_extension(x0, x1, x2, x3); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_sqlite3_load_extension _cffi_d_sqlite3_load_extension
#endif

static void * _cffi_d_sqlite3_malloc(int x0)
{
  return sqlite3_malloc(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_sqlite3_malloc(PyObject *self, PyObject *arg0)
{
  int x0;
  void * result;
  PyObject *pyresult;

  x0 = _cffi_to_c_int(arg0, int);
  if (x0 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = sqlite3_malloc(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(61));
  return pyresult;
}
#else
#  define _cffi_f_sqlite3_malloc _cffi_d_sqlite3_malloc
#endif

static void * _cffi_d_sqlite3_malloc64(unsigned long long x0)
{
  return sqlite3_malloc64(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_sqlite3_malloc64(PyObject *self, PyObject *arg0)
{
  unsigned long long x0;
  void * result;
  PyObject *pyresult;

  x0 = _cffi_to_c_int(arg0, unsigned long long);
  if (x0 == (unsigned long long)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = sqlite3_malloc64(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(61));
  return pyresult;
}
#else
#  define _cffi_f_sqlite3_malloc64 _cffi_d_sqlite3_malloc64
#endif

static int _cffi_d_sqlite3_open(char const * x0, sqlite3 * * x1)
{
  return sqlite3_open(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_sqlite3_open(PyObject *self, PyObject *args)
{
  char const * x0;
  sqlite3 * * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "sqlite3_open", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(23), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(23), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(27), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (sqlite3 * *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(27), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = sqlite3_open(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_sqlite3_open _cffi_d_sqlite3_open
#endif

static int _cffi_d_sqlite3_open_v2(char const * x0, sqlite3 * * x1, int x2, char const * x3)
{
  return sqlite3_open_v2(x0, x1, x2, x3);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_sqlite3_open_v2(PyObject *self, PyObject *args)
{
  char const * x0;
  sqlite3 * * x1;
  int x2;
  char const * x3;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;

  if (!PyArg_UnpackTuple(args, "sqlite3_open_v2", 4, 4, &arg0, &arg1, &arg2, &arg3))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(23), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(23), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(27), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (sqlite3 * *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(27), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, int);
  if (x2 == (int)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(23), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(23), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = sqlite3_open_v2(x0, x1, x2, x3); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_sqlite3_open_v2 _cffi_d_sqlite3_open_v2
#endif

static int _cffi_d_sqlite3_prepare(sqlite3 * x0, char const * x1, int x2, sqlite3_stmt * * x3, char const * * x4)
{
  return sqlite3_prepare(x0, x1, x2, x3, x4);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_sqlite3_prepare(PyObject *self, PyObject *args)
{
  sqlite3 * x0;
  char const * x1;
  int x2;
  sqlite3_stmt * * x3;
  char const * * x4;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;

  if (!PyArg_UnpackTuple(args, "sqlite3_prepare", 5, 5, &arg0, &arg1, &arg2, &arg3, &arg4))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(7), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (sqlite3 *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(7), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(23), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(23), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, int);
  if (x2 == (int)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(82), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (sqlite3_stmt * *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(82), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(83), arg4, (char **)&x4);
  if (datasize != 0) {
    x4 = ((size_t)datasize) <= 640 ? (char const * *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(83), arg4, (char **)&x4,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = sqlite3_prepare(x0, x1, x2, x3, x4); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_sqlite3_prepare _cffi_d_sqlite3_prepare
#endif

static int _cffi_d_sqlite3_prepare_v2(sqlite3 * x0, char const * x1, int x2, sqlite3_stmt * * x3, char const * * x4)
{
  return sqlite3_prepare_v2(x0, x1, x2, x3, x4);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_sqlite3_prepare_v2(PyObject *self, PyObject *args)
{
  sqlite3 * x0;
  char const * x1;
  int x2;
  sqlite3_stmt * * x3;
  char const * * x4;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;

  if (!PyArg_UnpackTuple(args, "sqlite3_prepare_v2", 5, 5, &arg0, &arg1, &arg2, &arg3, &arg4))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(7), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (sqlite3 *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(7), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(23), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(23), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, int);
  if (x2 == (int)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(82), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (sqlite3_stmt * *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(82), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(83), arg4, (char **)&x4);
  if (datasize != 0) {
    x4 = ((size_t)datasize) <= 640 ? (char const * *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(83), arg4, (char **)&x4,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = sqlite3_prepare_v2(x0, x1, x2, x3, x4); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_sqlite3_prepare_v2 _cffi_d_sqlite3_prepare_v2
#endif

static void _cffi_d_sqlite3_progress_handler(sqlite3 * x0, int x1, int(* x2)(void *), void * x3)
{
  sqlite3_progress_handler(x0, x1, x2, x3);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_sqlite3_progress_handler(PyObject *self, PyObject *args)
{
  sqlite3 * x0;
  int x1;
  int(* x2)(void *);
  void * x3;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;

  if (!PyArg_UnpackTuple(args, "sqlite3_progress_handler", 4, 4, &arg0, &arg1, &arg2, &arg3))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(7), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (sqlite3 *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(7), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  x2 = (int(*)(void *))_cffi_to_c_pointer(arg2, _cffi_type(264));
  if (x2 == (int(*)(void *))NULL && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(61), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (void *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(61), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { sqlite3_progress_handler(x0, x1, x2, x3); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_sqlite3_progress_handler _cffi_d_sqlite3_progress_handler
#endif

static int _cffi_d_sqlite3_reset(sqlite3_stmt * x0)
{
  return sqlite3_reset(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_sqlite3_reset(PyObject *self, PyObject *arg0)
{
  sqlite3_stmt * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (sqlite3_stmt *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = sqlite3_reset(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_sqlite3_reset _cffi_d_sqlite3_reset
#endif

static void _cffi_d_sqlite3_result_blob(sqlite3_context * x0, void const * x1, int x2, void(* x3)(void *))
{
  sqlite3_result_blob(x0, x1, x2, x3);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_sqlite3_result_blob(PyObject *self, PyObject *args)
{
  sqlite3_context * x0;
  void const * x1;
  int x2;
  void(* x3)(void *);
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;

  if (!PyArg_UnpackTuple(args, "sqlite3_result_blob", 4, 4, &arg0, &arg1, &arg2, &arg3))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(245), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (sqlite3_context *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(245), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(138), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (void const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(138), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, int);
  if (x2 == (int)-1 && PyErr_Occurred())
    return NULL;

  x3 = (void(*)(void *))_cffi_to_c_pointer(arg3, _cffi_type(66));
  if (x3 == (void(*)(void *))NULL && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { sqlite3_result_blob(x0, x1, x2, x3); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_sqlite3_result_blob _cffi_d_sqlite3_result_blob
#endif

static void _cffi_d_sqlite3_result_double(sqlite3_context * x0, double x1)
{
  sqlite3_result_double(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_sqlite3_result_double(PyObject *self, PyObject *args)
{
  sqlite3_context * x0;
  double x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "sqlite3_result_double", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(245), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (sqlite3_context *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(245), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = (double)_cffi_to_c_double(arg1);
  if (x1 == (double)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { sqlite3_result_double(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_sqlite3_result_double _cffi_d_sqlite3_result_double
#endif

static void _cffi_d_sqlite3_result_error(sqlite3_context * x0, char const * x1, int x2)
{
  sqlite3_result_error(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_sqlite3_result_error(PyObject *self, PyObject *args)
{
  sqlite3_context * x0;
  char const * x1;
  int x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "sqlite3_result_error", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(245), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (sqlite3_context *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(245), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(23), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(23), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, int);
  if (x2 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { sqlite3_result_error(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_sqlite3_result_error _cffi_d_sqlite3_result_error
#endif

static void _cffi_d_sqlite3_result_error16(sqlite3_context * x0, void const * x1, int x2)
{
  sqlite3_result_error16(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_sqlite3_result_error16(PyObject *self, PyObject *args)
{
  sqlite3_context * x0;
  void const * x1;
  int x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "sqlite3_result_error16", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(245), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (sqlite3_context *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(245), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(138), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (void const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(138), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, int);
  if (x2 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { sqlite3_result_error16(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_sqlite3_result_error16 _cffi_d_sqlite3_result_error16
#endif

static void _cffi_d_sqlite3_result_error_code(sqlite3_context * x0, int x1)
{
  sqlite3_result_error_code(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_sqlite3_result_error_code(PyObject *self, PyObject *args)
{
  sqlite3_context * x0;
  int x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "sqlite3_result_error_code", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(245), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (sqlite3_context *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(245), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { sqlite3_result_error_code(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_sqlite3_result_error_code _cffi_d_sqlite3_result_error_code
#endif

static void _cffi_d_sqlite3_result_error_nomem(sqlite3_context * x0)
{
  sqlite3_result_error_nomem(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_sqlite3_result_error_nomem(PyObject *self, PyObject *arg0)
{
  sqlite3_context * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(245), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (sqlite3_context *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(245), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { sqlite3_result_error_nomem(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_sqlite3_result_error_nomem _cffi_d_sqlite3_result_error_nomem
#endif

static void _cffi_d_sqlite3_result_error_toobig(sqlite3_context * x0)
{
  sqlite3_result_error_toobig(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_sqlite3_result_error_toobig(PyObject *self, PyObject *arg0)
{
  sqlite3_context * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(245), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (sqlite3_context *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(245), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { sqlite3_result_error_toobig(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_sqlite3_result_error_toobig _cffi_d_sqlite3_result_error_toobig
#endif

static void _cffi_d_sqlite3_result_int(sqlite3_context * x0, int x1)
{
  sqlite3_result_int(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_sqlite3_result_int(PyObject *self, PyObject *args)
{
  sqlite3_context * x0;
  int x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "sqlite3_result_int", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(245), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (sqlite3_context *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(245), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { sqlite3_result_int(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_sqlite3_result_int _cffi_d_sqlite3_result_int
#endif

static void _cffi_d_sqlite3_result_int64(sqlite3_context * x0, long long x1)
{
  sqlite3_result_int64(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_sqlite3_result_int64(PyObject *self, PyObject *args)
{
  sqlite3_context * x0;
  long long x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "sqlite3_result_int64", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(245), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (sqlite3_context *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(245), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, long long);
  if (x1 == (long long)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { sqlite3_result_int64(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_sqlite3_result_int64 _cffi_d_sqlite3_result_int64
#endif

static void _cffi_d_sqlite3_result_null(sqlite3_context * x0)
{
  sqlite3_result_null(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_sqlite3_result_null(PyObject *self, PyObject *arg0)
{
  sqlite3_context * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(245), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (sqlite3_context *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(245), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { sqlite3_result_null(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_sqlite3_result_null _cffi_d_sqlite3_result_null
#endif

static void _cffi_d_sqlite3_result_text(sqlite3_context * x0, char const * x1, int x2, void(* x3)(void *))
{
  sqlite3_result_text(x0, x1, x2, x3);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_sqlite3_result_text(PyObject *self, PyObject *args)
{
  sqlite3_context * x0;
  char const * x1;
  int x2;
  void(* x3)(void *);
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;

  if (!PyArg_UnpackTuple(args, "sqlite3_result_text", 4, 4, &arg0, &arg1, &arg2, &arg3))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(245), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (sqlite3_context *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(245), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(23), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(23), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, int);
  if (x2 == (int)-1 && PyErr_Occurred())
    return NULL;

  x3 = (void(*)(void *))_cffi_to_c_pointer(arg3, _cffi_type(66));
  if (x3 == (void(*)(void *))NULL && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { sqlite3_result_text(x0, x1, x2, x3); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_sqlite3_result_text _cffi_d_sqlite3_result_text
#endif

static void _cffi_d_sqlite3_result_text16(sqlite3_context * x0, void const * x1, int x2, void(* x3)(void *))
{
  sqlite3_result_text16(x0, x1, x2, x3);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_sqlite3_result_text16(PyObject *self, PyObject *args)
{
  sqlite3_context * x0;
  void const * x1;
  int x2;
  void(* x3)(void *);
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;

  if (!PyArg_UnpackTuple(args, "sqlite3_result_text16", 4, 4, &arg0, &arg1, &arg2, &arg3))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(245), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (sqlite3_context *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(245), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(138), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (void const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(138), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, int);
  if (x2 == (int)-1 && PyErr_Occurred())
    return NULL;

  x3 = (void(*)(void *))_cffi_to_c_pointer(arg3, _cffi_type(66));
  if (x3 == (void(*)(void *))NULL && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { sqlite3_result_text16(x0, x1, x2, x3); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_sqlite3_result_text16 _cffi_d_sqlite3_result_text16
#endif

static void _cffi_d_sqlite3_result_text16be(sqlite3_context * x0, void const * x1, int x2, void(* x3)(void *))
{
  sqlite3_result_text16be(x0, x1, x2, x3);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_sqlite3_result_text16be(PyObject *self, PyObject *args)
{
  sqlite3_context * x0;
  void const * x1;
  int x2;
  void(* x3)(void *);
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;

  if (!PyArg_UnpackTuple(args, "sqlite3_result_text16be", 4, 4, &arg0, &arg1, &arg2, &arg3))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(245), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (sqlite3_context *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(245), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(138), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (void const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(138), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, int);
  if (x2 == (int)-1 && PyErr_Occurred())
    return NULL;

  x3 = (void(*)(void *))_cffi_to_c_pointer(arg3, _cffi_type(66));
  if (x3 == (void(*)(void *))NULL && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { sqlite3_result_text16be(x0, x1, x2, x3); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_sqlite3_result_text16be _cffi_d_sqlite3_result_text16be
#endif

static void _cffi_d_sqlite3_result_text16le(sqlite3_context * x0, void const * x1, int x2, void(* x3)(void *))
{
  sqlite3_result_text16le(x0, x1, x2, x3);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_sqlite3_result_text16le(PyObject *self, PyObject *args)
{
  sqlite3_context * x0;
  void const * x1;
  int x2;
  void(* x3)(void *);
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;

  if (!PyArg_UnpackTuple(args, "sqlite3_result_text16le", 4, 4, &arg0, &arg1, &arg2, &arg3))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(245), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (sqlite3_context *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(245), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(138), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (void const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(138), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, int);
  if (x2 == (int)-1 && PyErr_Occurred())
    return NULL;

  x3 = (void(*)(void *))_cffi_to_c_pointer(arg3, _cffi_type(66));
  if (x3 == (void(*)(void *))NULL && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { sqlite3_result_text16le(x0, x1, x2, x3); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_sqlite3_result_text16le _cffi_d_sqlite3_result_text16le
#endif

static void _cffi_d_sqlite3_result_value(sqlite3_context * x0, sqlite3_value * x1)
{
  sqlite3_result_value(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_sqlite3_result_value(PyObject *self, PyObject *args)
{
  sqlite3_context * x0;
  sqlite3_value * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "sqlite3_result_value", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(245), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (sqlite3_context *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(245), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(20), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (sqlite3_value *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(20), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { sqlite3_result_value(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_sqlite3_result_value _cffi_d_sqlite3_result_value
#endif

static void _cffi_d_sqlite3_result_zeroblob(sqlite3_context * x0, int x1)
{
  sqlite3_result_zeroblob(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_sqlite3_result_zeroblob(PyObject *self, PyObject *args)
{
  sqlite3_context * x0;
  int x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "sqlite3_result_zeroblob", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(245), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (sqlite3_context *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(245), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { sqlite3_result_zeroblob(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_sqlite3_result_zeroblob _cffi_d_sqlite3_result_zeroblob
#endif

static unsigned char * _cffi_d_sqlite3_serialize(sqlite3 * x0, char const * x1, long long * x2, unsigned int x3)
{
  return sqlite3_serialize(x0, x1, x2, x3);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_sqlite3_serialize(PyObject *self, PyObject *args)
{
  sqlite3 * x0;
  char const * x1;
  long long * x2;
  unsigned int x3;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  unsigned char * result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;

  if (!PyArg_UnpackTuple(args, "sqlite3_serialize", 4, 4, &arg0, &arg1, &arg2, &arg3))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(7), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (sqlite3 *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(7), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(23), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(23), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(231), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (long long *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(231), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x3 = _cffi_to_c_int(arg3, unsigned int);
  if (x3 == (unsigned int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = sqlite3_serialize(x0, x1, x2, x3); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(95));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_sqlite3_serialize _cffi_d_sqlite3_serialize
#endif

static int _cffi_d_sqlite3_set_authorizer(sqlite3 * x0, int(* x1)(void *, int, char const *, char const *, char const *, char const *), void * x2)
{
  return sqlite3_set_authorizer(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_sqlite3_set_authorizer(PyObject *self, PyObject *args)
{
  sqlite3 * x0;
  int(* x1)(void *, int, char const *, char const *, char const *, char const *);
  void * x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "sqlite3_set_authorizer", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(7), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (sqlite3 *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(7), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = (int(*)(void *, int, char const *, char const *, char const *, char const *))_cffi_to_c_pointer(arg1, _cffi_type(102));
  if (x1 == (int(*)(void *, int, char const *, char const *, char const *, char const *))NULL && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(61), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (void *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(61), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = sqlite3_set_authorizer(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_sqlite3_set_authorizer _cffi_d_sqlite3_set_authorizer
#endif

static int _cffi_d_sqlite3_sleep(int x0)
{
  return sqlite3_sleep(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_sqlite3_sleep(PyObject *self, PyObject *arg0)
{
  int x0;
  int result;
  PyObject *pyresult;

  x0 = _cffi_to_c_int(arg0, int);
  if (x0 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = sqlite3_sleep(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  return pyresult;
}
#else
#  define _cffi_f_sqlite3_sleep _cffi_d_sqlite3_sleep
#endif

static int _cffi_d_sqlite3_step(sqlite3_stmt * x0)
{
  return sqlite3_step(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_sqlite3_step(PyObject *self, PyObject *arg0)
{
  sqlite3_stmt * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (sqlite3_stmt *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = sqlite3_step(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_sqlite3_step _cffi_d_sqlite3_step
#endif

static int _cffi_d_sqlite3_threadsafe(void)
{
  return sqlite3_threadsafe();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_sqlite3_threadsafe(PyObject *self, PyObject *noarg)
{
  int result;
  PyObject *pyresult;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = sqlite3_threadsafe(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  return pyresult;
}
#else
#  define _cffi_f_sqlite3_threadsafe _cffi_d_sqlite3_threadsafe
#endif

static int _cffi_d_sqlite3_total_changes(sqlite3 * x0)
{
  return sqlite3_total_changes(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_sqlite3_total_changes(PyObject *self, PyObject *arg0)
{
  sqlite3 * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(7), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (sqlite3 *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(7), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = sqlite3_total_changes(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_sqlite3_total_changes _cffi_d_sqlite3_total_changes
#endif

static int _cffi_d_sqlite3_trace_v2(sqlite3 * x0, unsigned int x1, int(* x2)(unsigned int, void *, void *, void *), void * x3)
{
  return sqlite3_trace_v2(x0, x1, x2, x3);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_sqlite3_trace_v2(PyObject *self, PyObject *args)
{
  sqlite3 * x0;
  unsigned int x1;
  int(* x2)(unsigned int, void *, void *, void *);
  void * x3;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;

  if (!PyArg_UnpackTuple(args, "sqlite3_trace_v2", 4, 4, &arg0, &arg1, &arg2, &arg3))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(7), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (sqlite3 *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(7), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, unsigned int);
  if (x1 == (unsigned int)-1 && PyErr_Occurred())
    return NULL;

  x2 = (int(*)(unsigned int, void *, void *, void *))_cffi_to_c_pointer(arg2, _cffi_type(117));
  if (x2 == (int(*)(unsigned int, void *, void *, void *))NULL && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(61), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (void *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(61), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = sqlite3_trace_v2(x0, x1, x2, x3); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_sqlite3_trace_v2 _cffi_d_sqlite3_trace_v2
#endif

static void const * _cffi_d_sqlite3_value_blob(sqlite3_value * x0)
{
  return sqlite3_value_blob(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_sqlite3_value_blob(PyObject *self, PyObject *arg0)
{
  sqlite3_value * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  void const * result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(20), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (sqlite3_value *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(20), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = sqlite3_value_blob(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(138));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_sqlite3_value_blob _cffi_d_sqlite3_value_blob
#endif

static int _cffi_d_sqlite3_value_bytes(sqlite3_value * x0)
{
  return sqlite3_value_bytes(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_sqlite3_value_bytes(PyObject *self, PyObject *arg0)
{
  sqlite3_value * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(20), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (sqlite3_value *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(20), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = sqlite3_value_bytes(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_sqlite3_value_bytes _cffi_d_sqlite3_value_bytes
#endif

static int _cffi_d_sqlite3_value_bytes16(sqlite3_value * x0)
{
  return sqlite3_value_bytes16(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_sqlite3_value_bytes16(PyObject *self, PyObject *arg0)
{
  sqlite3_value * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(20), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (sqlite3_value *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(20), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = sqlite3_value_bytes16(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_sqlite3_value_bytes16 _cffi_d_sqlite3_value_bytes16
#endif

static double _cffi_d_sqlite3_value_double(sqlite3_value * x0)
{
  return sqlite3_value_double(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_sqlite3_value_double(PyObject *self, PyObject *arg0)
{
  sqlite3_value * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  double result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(20), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (sqlite3_value *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(20), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = sqlite3_value_double(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_double(result);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_sqlite3_value_double _cffi_d_sqlite3_value_double
#endif

static int _cffi_d_sqlite3_value_int(sqlite3_value * x0)
{
  return sqlite3_value_int(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_sqlite3_value_int(PyObject *self, PyObject *arg0)
{
  sqlite3_value * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(20), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (sqlite3_value *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(20), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = sqlite3_value_int(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_sqlite3_value_int _cffi_d_sqlite3_value_int
#endif

static long long _cffi_d_sqlite3_value_int64(sqlite3_value * x0)
{
  return sqlite3_value_int64(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_sqlite3_value_int64(PyObject *self, PyObject *arg0)
{
  sqlite3_value * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  long long result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(20), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (sqlite3_value *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(20), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = sqlite3_value_int64(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, long long);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_sqlite3_value_int64 _cffi_d_sqlite3_value_int64
#endif

static int _cffi_d_sqlite3_value_numeric_type(sqlite3_value * x0)
{
  return sqlite3_value_numeric_type(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_sqlite3_value_numeric_type(PyObject *self, PyObject *arg0)
{
  sqlite3_value * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(20), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (sqlite3_value *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(20), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = sqlite3_value_numeric_type(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_sqlite3_value_numeric_type _cffi_d_sqlite3_value_numeric_type
#endif

static unsigned char const * _cffi_d_sqlite3_value_text(sqlite3_value * x0)
{
  return sqlite3_value_text(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_sqlite3_value_text(PyObject *self, PyObject *arg0)
{
  sqlite3_value * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  unsigned char const * result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(20), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (sqlite3_value *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(20), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = sqlite3_value_text(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(324));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_sqlite3_value_text _cffi_d_sqlite3_value_text
#endif

static void const * _cffi_d_sqlite3_value_text16(sqlite3_value * x0)
{
  return sqlite3_value_text16(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_sqlite3_value_text16(PyObject *self, PyObject *arg0)
{
  sqlite3_value * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  void const * result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(20), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (sqlite3_value *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(20), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = sqlite3_value_text16(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(138));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_sqlite3_value_text16 _cffi_d_sqlite3_value_text16
#endif

static void const * _cffi_d_sqlite3_value_text16be(sqlite3_value * x0)
{
  return sqlite3_value_text16be(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_sqlite3_value_text16be(PyObject *self, PyObject *arg0)
{
  sqlite3_value * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  void const * result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(20), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (sqlite3_value *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(20), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = sqlite3_value_text16be(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(138));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_sqlite3_value_text16be _cffi_d_sqlite3_value_text16be
#endif

static void const * _cffi_d_sqlite3_value_text16le(sqlite3_value * x0)
{
  return sqlite3_value_text16le(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_sqlite3_value_text16le(PyObject *self, PyObject *arg0)
{
  sqlite3_value * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  void const * result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(20), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (sqlite3_value *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(20), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = sqlite3_value_text16le(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(138));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_sqlite3_value_text16le _cffi_d_sqlite3_value_text16le
#endif

static int _cffi_d_sqlite3_value_type(sqlite3_value * x0)
{
  return sqlite3_value_type(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_sqlite3_value_type(PyObject *self, PyObject *arg0)
{
  sqlite3_value * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(20), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (sqlite3_value *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(20), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = sqlite3_value_type(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_sqlite3_value_type _cffi_d_sqlite3_value_type
#endif

static int _cffi_const_SQLITE3_TEXT(unsigned long long *o)
{
  int n = (SQLITE3_TEXT) <= 0;
  *o = (unsigned long long)((SQLITE3_TEXT) | 0);  /* check that SQLITE3_TEXT is an integer */
  return n;
}

static int _cffi_const_SQLITE_ABORT(unsigned long long *o)
{
  int n = (SQLITE_ABORT) <= 0;
  *o = (unsigned long long)((SQLITE_ABORT) | 0);  /* check that SQLITE_ABORT is an integer */
  return n;
}

static int _cffi_const_SQLITE_ABORT_ROLLBACK(unsigned long long *o)
{
  int n = (SQLITE_ABORT_ROLLBACK) <= 0;
  *o = (unsigned long long)((SQLITE_ABORT_ROLLBACK) | 0);  /* check that SQLITE_ABORT_ROLLBACK is an integer */
  return n;
}

static int _cffi_const_SQLITE_ALTER_TABLE(unsigned long long *o)
{
  int n = (SQLITE_ALTER_TABLE) <= 0;
  *o = (unsigned long long)((SQLITE_ALTER_TABLE) | 0);  /* check that SQLITE_ALTER_TABLE is an integer */
  return n;
}

static int _cffi_const_SQLITE_ANALYZE(unsigned long long *o)
{
  int n = (SQLITE_ANALYZE) <= 0;
  *o = (unsigned long long)((SQLITE_ANALYZE) | 0);  /* check that SQLITE_ANALYZE is an integer */
  return n;
}

static int _cffi_const_SQLITE_ATTACH(unsigned long long *o)
{
  int n = (SQLITE_ATTACH) <= 0;
  *o = (unsigned long long)((SQLITE_ATTACH) | 0);  /* check that SQLITE_ATTACH is an integer */
  return n;
}

static int _cffi_const_SQLITE_AUTH(unsigned long long *o)
{
  int n = (SQLITE_AUTH) <= 0;
  *o = (unsigned long long)((SQLITE_AUTH) | 0);  /* check that SQLITE_AUTH is an integer */
  return n;
}

static int _cffi_const_SQLITE_AUTH_USER(unsigned long long *o)
{
  int n = (SQLITE_AUTH_USER) <= 0;
  *o = (unsigned long long)((SQLITE_AUTH_USER) | 0);  /* check that SQLITE_AUTH_USER is an integer */
  return n;
}

static int _cffi_const_SQLITE_BLOB(unsigned long long *o)
{
  int n = (SQLITE_BLOB) <= 0;
  *o = (unsigned long long)((SQLITE_BLOB) | 0);  /* check that SQLITE_BLOB is an integer */
  return n;
}

static int _cffi_const_SQLITE_BUSY(unsigned long long *o)
{
  int n = (SQLITE_BUSY) <= 0;
  *o = (unsigned long long)((SQLITE_BUSY) | 0);  /* check that SQLITE_BUSY is an integer */
  return n;
}

static int _cffi_const_SQLITE_BUSY_RECOVERY(unsigned long long *o)
{
  int n = (SQLITE_BUSY_RECOVERY) <= 0;
  *o = (unsigned long long)((SQLITE_BUSY_RECOVERY) | 0);  /* check that SQLITE_BUSY_RECOVERY is an integer */
  return n;
}

static int _cffi_const_SQLITE_BUSY_SNAPSHOT(unsigned long long *o)
{
  int n = (SQLITE_BUSY_SNAPSHOT) <= 0;
  *o = (unsigned long long)((SQLITE_BUSY_SNAPSHOT) | 0);  /* check that SQLITE_BUSY_SNAPSHOT is an integer */
  return n;
}

static int _cffi_const_SQLITE_BUSY_TIMEOUT(unsigned long long *o)
{
  int n = (SQLITE_BUSY_TIMEOUT) <= 0;
  *o = (unsigned long long)((SQLITE_BUSY_TIMEOUT) | 0);  /* check that SQLITE_BUSY_TIMEOUT is an integer */
  return n;
}

static int _cffi_const_SQLITE_CANTOPEN(unsigned long long *o)
{
  int n = (SQLITE_CANTOPEN) <= 0;
  *o = (unsigned long long)((SQLITE_CANTOPEN) | 0);  /* check that SQLITE_CANTOPEN is an integer */
  return n;
}

static int _cffi_const_SQLITE_CANTOPEN_CONVPATH(unsigned long long *o)
{
  int n = (SQLITE_CANTOPEN_CONVPATH) <= 0;
  *o = (unsigned long long)((SQLITE_CANTOPEN_CONVPATH) | 0);  /* check that SQLITE_CANTOPEN_CONVPATH is an integer */
  return n;
}

static int _cffi_const_SQLITE_CANTOPEN_DIRTYWAL(unsigned long long *o)
{
  int n = (SQLITE_CANTOPEN_DIRTYWAL) <= 0;
  *o = (unsigned long long)((SQLITE_CANTOPEN_DIRTYWAL) | 0);  /* check that SQLITE_CANTOPEN_DIRTYWAL is an integer */
  return n;
}

static int _cffi_const_SQLITE_CANTOPEN_FULLPATH(unsigned long long *o)
{
  int n = (SQLITE_CANTOPEN_FULLPATH) <= 0;
  *o = (unsigned long long)((SQLITE_CANTOPEN_FULLPATH) | 0);  /* check that SQLITE_CANTOPEN_FULLPATH is an integer */
  return n;
}

static int _cffi_const_SQLITE_CANTOPEN_ISDIR(unsigned long long *o)
{
  int n = (SQLITE_CANTOPEN_ISDIR) <= 0;
  *o = (unsigned long long)((SQLITE_CANTOPEN_ISDIR) | 0);  /* check that SQLITE_CANTOPEN_ISDIR is an integer */
  return n;
}

static int _cffi_const_SQLITE_CANTOPEN_NOTEMPDIR(unsigned long long *o)
{
  int n = (SQLITE_CANTOPEN_NOTEMPDIR) <= 0;
  *o = (unsigned long long)((SQLITE_CANTOPEN_NOTEMPDIR) | 0);  /* check that SQLITE_CANTOPEN_NOTEMPDIR is an integer */
  return n;
}

static int _cffi_const_SQLITE_CANTOPEN_SYMLINK(unsigned long long *o)
{
  int n = (SQLITE_CANTOPEN_SYMLINK) <= 0;
  *o = (unsigned long long)((SQLITE_CANTOPEN_SYMLINK) | 0);  /* check that SQLITE_CANTOPEN_SYMLINK is an integer */
  return n;
}

static int _cffi_const_SQLITE_CONSTRAINT(unsigned long long *o)
{
  int n = (SQLITE_CONSTRAINT) <= 0;
  *o = (unsigned long long)((SQLITE_CONSTRAINT) | 0);  /* check that SQLITE_CONSTRAINT is an integer */
  return n;
}

static int _cffi_const_SQLITE_CONSTRAINT_CHECK(unsigned long long *o)
{
  int n = (SQLITE_CONSTRAINT_CHECK) <= 0;
  *o = (unsigned long long)((SQLITE_CONSTRAINT_CHECK) | 0);  /* check that SQLITE_CONSTRAINT_CHECK is an integer */
  return n;
}

static int _cffi_const_SQLITE_CONSTRAINT_COMMITHOOK(unsigned long long *o)
{
  int n = (SQLITE_CONSTRAINT_COMMITHOOK) <= 0;
  *o = (unsigned long long)((SQLITE_CONSTRAINT_COMMITHOOK) | 0);  /* check that SQLITE_CONSTRAINT_COMMITHOOK is an integer */
  return n;
}

static int _cffi_const_SQLITE_CONSTRAINT_FOREIGNKEY(unsigned long long *o)
{
  int n = (SQLITE_CONSTRAINT_FOREIGNKEY) <= 0;
  *o = (unsigned long long)((SQLITE_CONSTRAINT_FOREIGNKEY) | 0);  /* check that SQLITE_CONSTRAINT_FOREIGNKEY is an integer */
  return n;
}

static int _cffi_const_SQLITE_CONSTRAINT_FUNCTION(unsigned long long *o)
{
  int n = (SQLITE_CONSTRAINT_FUNCTION) <= 0;
  *o = (unsigned long long)((SQLITE_CONSTRAINT_FUNCTION) | 0);  /* check that SQLITE_CONSTRAINT_FUNCTION is an integer */
  return n;
}

static int _cffi_const_SQLITE_CONSTRAINT_NOTNULL(unsigned long long *o)
{
  int n = (SQLITE_CONSTRAINT_NOTNULL) <= 0;
  *o = (unsigned long long)((SQLITE_CONSTRAINT_NOTNULL) | 0);  /* check that SQLITE_CONSTRAINT_NOTNULL is an integer */
  return n;
}

static int _cffi_const_SQLITE_CONSTRAINT_PINNED(unsigned long long *o)
{
  int n = (SQLITE_CONSTRAINT_PINNED) <= 0;
  *o = (unsigned long long)((SQLITE_CONSTRAINT_PINNED) | 0);  /* check that SQLITE_CONSTRAINT_PINNED is an integer */
  return n;
}

static int _cffi_const_SQLITE_CONSTRAINT_PRIMARYKEY(unsigned long long *o)
{
  int n = (SQLITE_CONSTRAINT_PRIMARYKEY) <= 0;
  *o = (unsigned long long)((SQLITE_CONSTRAINT_PRIMARYKEY) | 0);  /* check that SQLITE_CONSTRAINT_PRIMARYKEY is an integer */
  return n;
}

static int _cffi_const_SQLITE_CONSTRAINT_ROWID(unsigned long long *o)
{
  int n = (SQLITE_CONSTRAINT_ROWID) <= 0;
  *o = (unsigned long long)((SQLITE_CONSTRAINT_ROWID) | 0);  /* check that SQLITE_CONSTRAINT_ROWID is an integer */
  return n;
}

static int _cffi_const_SQLITE_CONSTRAINT_TRIGGER(unsigned long long *o)
{
  int n = (SQLITE_CONSTRAINT_TRIGGER) <= 0;
  *o = (unsigned long long)((SQLITE_CONSTRAINT_TRIGGER) | 0);  /* check that SQLITE_CONSTRAINT_TRIGGER is an integer */
  return n;
}

static int _cffi_const_SQLITE_CONSTRAINT_UNIQUE(unsigned long long *o)
{
  int n = (SQLITE_CONSTRAINT_UNIQUE) <= 0;
  *o = (unsigned long long)((SQLITE_CONSTRAINT_UNIQUE) | 0);  /* check that SQLITE_CONSTRAINT_UNIQUE is an integer */
  return n;
}

static int _cffi_const_SQLITE_CONSTRAINT_VTAB(unsigned long long *o)
{
  int n = (SQLITE_CONSTRAINT_VTAB) <= 0;
  *o = (unsigned long long)((SQLITE_CONSTRAINT_VTAB) | 0);  /* check that SQLITE_CONSTRAINT_VTAB is an integer */
  return n;
}

static int _cffi_const_SQLITE_CORRUPT(unsigned long long *o)
{
  int n = (SQLITE_CORRUPT) <= 0;
  *o = (unsigned long long)((SQLITE_CORRUPT) | 0);  /* check that SQLITE_CORRUPT is an integer */
  return n;
}

static int _cffi_const_SQLITE_CORRUPT_INDEX(unsigned long long *o)
{
  int n = (SQLITE_CORRUPT_INDEX) <= 0;
  *o = (unsigned long long)((SQLITE_CORRUPT_INDEX) | 0);  /* check that SQLITE_CORRUPT_INDEX is an integer */
  return n;
}

static int _cffi_const_SQLITE_CORRUPT_SEQUENCE(unsigned long long *o)
{
  int n = (SQLITE_CORRUPT_SEQUENCE) <= 0;
  *o = (unsigned long long)((SQLITE_CORRUPT_SEQUENCE) | 0);  /* check that SQLITE_CORRUPT_SEQUENCE is an integer */
  return n;
}

static int _cffi_const_SQLITE_CORRUPT_VTAB(unsigned long long *o)
{
  int n = (SQLITE_CORRUPT_VTAB) <= 0;
  *o = (unsigned long long)((SQLITE_CORRUPT_VTAB) | 0);  /* check that SQLITE_CORRUPT_VTAB is an integer */
  return n;
}

static int _cffi_const_SQLITE_CREATE_INDEX(unsigned long long *o)
{
  int n = (SQLITE_CREATE_INDEX) <= 0;
  *o = (unsigned long long)((SQLITE_CREATE_INDEX) | 0);  /* check that SQLITE_CREATE_INDEX is an integer */
  return n;
}

static int _cffi_const_SQLITE_CREATE_TABLE(unsigned long long *o)
{
  int n = (SQLITE_CREATE_TABLE) <= 0;
  *o = (unsigned long long)((SQLITE_CREATE_TABLE) | 0);  /* check that SQLITE_CREATE_TABLE is an integer */
  return n;
}

static int _cffi_const_SQLITE_CREATE_TEMP_INDEX(unsigned long long *o)
{
  int n = (SQLITE_CREATE_TEMP_INDEX) <= 0;
  *o = (unsigned long long)((SQLITE_CREATE_TEMP_INDEX) | 0);  /* check that SQLITE_CREATE_TEMP_INDEX is an integer */
  return n;
}

static int _cffi_const_SQLITE_CREATE_TEMP_TABLE(unsigned long long *o)
{
  int n = (SQLITE_CREATE_TEMP_TABLE) <= 0;
  *o = (unsigned long long)((SQLITE_CREATE_TEMP_TABLE) | 0);  /* check that SQLITE_CREATE_TEMP_TABLE is an integer */
  return n;
}

static int _cffi_const_SQLITE_CREATE_TEMP_TRIGGER(unsigned long long *o)
{
  int n = (SQLITE_CREATE_TEMP_TRIGGER) <= 0;
  *o = (unsigned long long)((SQLITE_CREATE_TEMP_TRIGGER) | 0);  /* check that SQLITE_CREATE_TEMP_TRIGGER is an integer */
  return n;
}

static int _cffi_const_SQLITE_CREATE_TEMP_VIEW(unsigned long long *o)
{
  int n = (SQLITE_CREATE_TEMP_VIEW) <= 0;
  *o = (unsigned long long)((SQLITE_CREATE_TEMP_VIEW) | 0);  /* check that SQLITE_CREATE_TEMP_VIEW is an integer */
  return n;
}

static int _cffi_const_SQLITE_CREATE_TRIGGER(unsigned long long *o)
{
  int n = (SQLITE_CREATE_TRIGGER) <= 0;
  *o = (unsigned long long)((SQLITE_CREATE_TRIGGER) | 0);  /* check that SQLITE_CREATE_TRIGGER is an integer */
  return n;
}

static int _cffi_const_SQLITE_CREATE_VIEW(unsigned long long *o)
{
  int n = (SQLITE_CREATE_VIEW) <= 0;
  *o = (unsigned long long)((SQLITE_CREATE_VIEW) | 0);  /* check that SQLITE_CREATE_VIEW is an integer */
  return n;
}

static int _cffi_const_SQLITE_CREATE_VTABLE(unsigned long long *o)
{
  int n = (SQLITE_CREATE_VTABLE) <= 0;
  *o = (unsigned long long)((SQLITE_CREATE_VTABLE) | 0);  /* check that SQLITE_CREATE_VTABLE is an integer */
  return n;
}

static int _cffi_const_SQLITE_DELETE(unsigned long long *o)
{
  int n = (SQLITE_DELETE) <= 0;
  *o = (unsigned long long)((SQLITE_DELETE) | 0);  /* check that SQLITE_DELETE is an integer */
  return n;
}

static int _cffi_const_SQLITE_DENY(unsigned long long *o)
{
  int n = (SQLITE_DENY) <= 0;
  *o = (unsigned long long)((SQLITE_DENY) | 0);  /* check that SQLITE_DENY is an integer */
  return n;
}

static int _cffi_const_SQLITE_DESERIALIZE_FREEONCLOSE(unsigned long long *o)
{
  int n = (SQLITE_DESERIALIZE_FREEONCLOSE) <= 0;
  *o = (unsigned long long)((SQLITE_DESERIALIZE_FREEONCLOSE) | 0);  /* check that SQLITE_DESERIALIZE_FREEONCLOSE is an integer */
  return n;
}

static int _cffi_const_SQLITE_DESERIALIZE_RESIZEABLE(unsigned long long *o)
{
  int n = (SQLITE_DESERIALIZE_RESIZEABLE) <= 0;
  *o = (unsigned long long)((SQLITE_DESERIALIZE_RESIZEABLE) | 0);  /* check that SQLITE_DESERIALIZE_RESIZEABLE is an integer */
  return n;
}

static int _cffi_const_SQLITE_DETACH(unsigned long long *o)
{
  int n = (SQLITE_DETACH) <= 0;
  *o = (unsigned long long)((SQLITE_DETACH) | 0);  /* check that SQLITE_DETACH is an integer */
  return n;
}

static int _cffi_const_SQLITE_DETERMINISTIC(unsigned long long *o)
{
  int n = (SQLITE_DETERMINISTIC) <= 0;
  *o = (unsigned long long)((SQLITE_DETERMINISTIC) | 0);  /* check that SQLITE_DETERMINISTIC is an integer */
  return n;
}

static int _cffi_const_SQLITE_DONE(unsigned long long *o)
{
  int n = (SQLITE_DONE) <= 0;
  *o = (unsigned long long)((SQLITE_DONE) | 0);  /* check that SQLITE_DONE is an integer */
  return n;
}

static int _cffi_const_SQLITE_DROP_INDEX(unsigned long long *o)
{
  int n = (SQLITE_DROP_INDEX) <= 0;
  *o = (unsigned long long)((SQLITE_DROP_INDEX) | 0);  /* check that SQLITE_DROP_INDEX is an integer */
  return n;
}

static int _cffi_const_SQLITE_DROP_TABLE(unsigned long long *o)
{
  int n = (SQLITE_DROP_TABLE) <= 0;
  *o = (unsigned long long)((SQLITE_DROP_TABLE) | 0);  /* check that SQLITE_DROP_TABLE is an integer */
  return n;
}

static int _cffi_const_SQLITE_DROP_TEMP_INDEX(unsigned long long *o)
{
  int n = (SQLITE_DROP_TEMP_INDEX) <= 0;
  *o = (unsigned long long)((SQLITE_DROP_TEMP_INDEX) | 0);  /* check that SQLITE_DROP_TEMP_INDEX is an integer */
  return n;
}

static int _cffi_const_SQLITE_DROP_TEMP_TABLE(unsigned long long *o)
{
  int n = (SQLITE_DROP_TEMP_TABLE) <= 0;
  *o = (unsigned long long)((SQLITE_DROP_TEMP_TABLE) | 0);  /* check that SQLITE_DROP_TEMP_TABLE is an integer */
  return n;
}

static int _cffi_const_SQLITE_DROP_TEMP_TRIGGER(unsigned long long *o)
{
  int n = (SQLITE_DROP_TEMP_TRIGGER) <= 0;
  *o = (unsigned long long)((SQLITE_DROP_TEMP_TRIGGER) | 0);  /* check that SQLITE_DROP_TEMP_TRIGGER is an integer */
  return n;
}

static int _cffi_const_SQLITE_DROP_TEMP_VIEW(unsigned long long *o)
{
  int n = (SQLITE_DROP_TEMP_VIEW) <= 0;
  *o = (unsigned long long)((SQLITE_DROP_TEMP_VIEW) | 0);  /* check that SQLITE_DROP_TEMP_VIEW is an integer */
  return n;
}

static int _cffi_const_SQLITE_DROP_TRIGGER(unsigned long long *o)
{
  int n = (SQLITE_DROP_TRIGGER) <= 0;
  *o = (unsigned long long)((SQLITE_DROP_TRIGGER) | 0);  /* check that SQLITE_DROP_TRIGGER is an integer */
  return n;
}

static int _cffi_const_SQLITE_DROP_VIEW(unsigned long long *o)
{
  int n = (SQLITE_DROP_VIEW) <= 0;
  *o = (unsigned long long)((SQLITE_DROP_VIEW) | 0);  /* check that SQLITE_DROP_VIEW is an integer */
  return n;
}

static int _cffi_const_SQLITE_DROP_VTABLE(unsigned long long *o)
{
  int n = (SQLITE_DROP_VTABLE) <= 0;
  *o = (unsigned long long)((SQLITE_DROP_VTABLE) | 0);  /* check that SQLITE_DROP_VTABLE is an integer */
  return n;
}

static int _cffi_const_SQLITE_EMPTY(unsigned long long *o)
{
  int n = (SQLITE_EMPTY) <= 0;
  *o = (unsigned long long)((SQLITE_EMPTY) | 0);  /* check that SQLITE_EMPTY is an integer */
  return n;
}

static int _cffi_const_SQLITE_ERROR(unsigned long long *o)
{
  int n = (SQLITE_ERROR) <= 0;
  *o = (unsigned long long)((SQLITE_ERROR) | 0);  /* check that SQLITE_ERROR is an integer */
  return n;
}

static int _cffi_const_SQLITE_ERROR_MISSING_COLLSEQ(unsigned long long *o)
{
  int n = (SQLITE_ERROR_MISSING_COLLSEQ) <= 0;
  *o = (unsigned long long)((SQLITE_ERROR_MISSING_COLLSEQ) | 0);  /* check that SQLITE_ERROR_MISSING_COLLSEQ is an integer */
  return n;
}

static int _cffi_const_SQLITE_ERROR_RETRY(unsigned long long *o)
{
  int n = (SQLITE_ERROR_RETRY) <= 0;
  *o = (unsigned long long)((SQLITE_ERROR_RETRY) | 0);  /* check that SQLITE_ERROR_RETRY is an integer */
  return n;
}

static int _cffi_const_SQLITE_ERROR_SNAPSHOT(unsigned long long *o)
{
  int n = (SQLITE_ERROR_SNAPSHOT) <= 0;
  *o = (unsigned long long)((SQLITE_ERROR_SNAPSHOT) | 0);  /* check that SQLITE_ERROR_SNAPSHOT is an integer */
  return n;
}

static int _cffi_const_SQLITE_FLOAT(unsigned long long *o)
{
  int n = (SQLITE_FLOAT) <= 0;
  *o = (unsigned long long)((SQLITE_FLOAT) | 0);  /* check that SQLITE_FLOAT is an integer */
  return n;
}

static int _cffi_const_SQLITE_FORMAT(unsigned long long *o)
{
  int n = (SQLITE_FORMAT) <= 0;
  *o = (unsigned long long)((SQLITE_FORMAT) | 0);  /* check that SQLITE_FORMAT is an integer */
  return n;
}

static int _cffi_const_SQLITE_FULL(unsigned long long *o)
{
  int n = (SQLITE_FULL) <= 0;
  *o = (unsigned long long)((SQLITE_FULL) | 0);  /* check that SQLITE_FULL is an integer */
  return n;
}

static int _cffi_const_SQLITE_FUNCTION(unsigned long long *o)
{
  int n = (SQLITE_FUNCTION) <= 0;
  *o = (unsigned long long)((SQLITE_FUNCTION) | 0);  /* check that SQLITE_FUNCTION is an integer */
  return n;
}

static int _cffi_const_SQLITE_IGNORE(unsigned long long *o)
{
  int n = (SQLITE_IGNORE) <= 0;
  *o = (unsigned long long)((SQLITE_IGNORE) | 0);  /* check that SQLITE_IGNORE is an integer */
  return n;
}

static int _cffi_const_SQLITE_INSERT(unsigned long long *o)
{
  int n = (SQLITE_INSERT) <= 0;
  *o = (unsigned long long)((SQLITE_INSERT) | 0);  /* check that SQLITE_INSERT is an integer */
  return n;
}

static int _cffi_const_SQLITE_INTEGER(unsigned long long *o)
{
  int n = (SQLITE_INTEGER) <= 0;
  *o = (unsigned long long)((SQLITE_INTEGER) | 0);  /* check that SQLITE_INTEGER is an integer */
  return n;
}

static int _cffi_const_SQLITE_INTERNAL(unsigned long long *o)
{
  int n = (SQLITE_INTERNAL) <= 0;
  *o = (unsigned long long)((SQLITE_INTERNAL) | 0);  /* check that SQLITE_INTERNAL is an integer */
  return n;
}

static int _cffi_const_SQLITE_INTERRUPT(unsigned long long *o)
{
  int n = (SQLITE_INTERRUPT) <= 0;
  *o = (unsigned long long)((SQLITE_INTERRUPT) | 0);  /* check that SQLITE_INTERRUPT is an integer */
  return n;
}

static int _cffi_const_SQLITE_IOERR(unsigned long long *o)
{
  int n = (SQLITE_IOERR) <= 0;
  *o = (unsigned long long)((SQLITE_IOERR) | 0);  /* check that SQLITE_IOERR is an integer */
  return n;
}

static int _cffi_const_SQLITE_IOERR_ACCESS(unsigned long long *o)
{
  int n = (SQLITE_IOERR_ACCESS) <= 0;
  *o = (unsigned long long)((SQLITE_IOERR_ACCESS) | 0);  /* check that SQLITE_IOERR_ACCESS is an integer */
  return n;
}

static int _cffi_const_SQLITE_IOERR_AUTH(unsigned long long *o)
{
  int n = (SQLITE_IOERR_AUTH) <= 0;
  *o = (unsigned long long)((SQLITE_IOERR_AUTH) | 0);  /* check that SQLITE_IOERR_AUTH is an integer */
  return n;
}

static int _cffi_const_SQLITE_IOERR_BEGIN_ATOMIC(unsigned long long *o)
{
  int n = (SQLITE_IOERR_BEGIN_ATOMIC) <= 0;
  *o = (unsigned long long)((SQLITE_IOERR_BEGIN_ATOMIC) | 0);  /* check that SQLITE_IOERR_BEGIN_ATOMIC is an integer */
  return n;
}

static int _cffi_const_SQLITE_IOERR_BLOCKED(unsigned long long *o)
{
  int n = (SQLITE_IOERR_BLOCKED) <= 0;
  *o = (unsigned long long)((SQLITE_IOERR_BLOCKED) | 0);  /* check that SQLITE_IOERR_BLOCKED is an integer */
  return n;
}

static int _cffi_const_SQLITE_IOERR_CHECKRESERVEDLOCK(unsigned long long *o)
{
  int n = (SQLITE_IOERR_CHECKRESERVEDLOCK) <= 0;
  *o = (unsigned long long)((SQLITE_IOERR_CHECKRESERVEDLOCK) | 0);  /* check that SQLITE_IOERR_CHECKRESERVEDLOCK is an integer */
  return n;
}

static int _cffi_const_SQLITE_IOERR_CLOSE(unsigned long long *o)
{
  int n = (SQLITE_IOERR_CLOSE) <= 0;
  *o = (unsigned long long)((SQLITE_IOERR_CLOSE) | 0);  /* check that SQLITE_IOERR_CLOSE is an integer */
  return n;
}

static int _cffi_const_SQLITE_IOERR_COMMIT_ATOMIC(unsigned long long *o)
{
  int n = (SQLITE_IOERR_COMMIT_ATOMIC) <= 0;
  *o = (unsigned long long)((SQLITE_IOERR_COMMIT_ATOMIC) | 0);  /* check that SQLITE_IOERR_COMMIT_ATOMIC is an integer */
  return n;
}

static int _cffi_const_SQLITE_IOERR_CONVPATH(unsigned long long *o)
{
  int n = (SQLITE_IOERR_CONVPATH) <= 0;
  *o = (unsigned long long)((SQLITE_IOERR_CONVPATH) | 0);  /* check that SQLITE_IOERR_CONVPATH is an integer */
  return n;
}

static int _cffi_const_SQLITE_IOERR_CORRUPTFS(unsigned long long *o)
{
  int n = (SQLITE_IOERR_CORRUPTFS) <= 0;
  *o = (unsigned long long)((SQLITE_IOERR_CORRUPTFS) | 0);  /* check that SQLITE_IOERR_CORRUPTFS is an integer */
  return n;
}

static int _cffi_const_SQLITE_IOERR_DATA(unsigned long long *o)
{
  int n = (SQLITE_IOERR_DATA) <= 0;
  *o = (unsigned long long)((SQLITE_IOERR_DATA) | 0);  /* check that SQLITE_IOERR_DATA is an integer */
  return n;
}

static int _cffi_const_SQLITE_IOERR_DELETE(unsigned long long *o)
{
  int n = (SQLITE_IOERR_DELETE) <= 0;
  *o = (unsigned long long)((SQLITE_IOERR_DELETE) | 0);  /* check that SQLITE_IOERR_DELETE is an integer */
  return n;
}

static int _cffi_const_SQLITE_IOERR_DELETE_NOENT(unsigned long long *o)
{
  int n = (SQLITE_IOERR_DELETE_NOENT) <= 0;
  *o = (unsigned long long)((SQLITE_IOERR_DELETE_NOENT) | 0);  /* check that SQLITE_IOERR_DELETE_NOENT is an integer */
  return n;
}

static int _cffi_const_SQLITE_IOERR_DIR_CLOSE(unsigned long long *o)
{
  int n = (SQLITE_IOERR_DIR_CLOSE) <= 0;
  *o = (unsigned long long)((SQLITE_IOERR_DIR_CLOSE) | 0);  /* check that SQLITE_IOERR_DIR_CLOSE is an integer */
  return n;
}

static int _cffi_const_SQLITE_IOERR_DIR_FSYNC(unsigned long long *o)
{
  int n = (SQLITE_IOERR_DIR_FSYNC) <= 0;
  *o = (unsigned long long)((SQLITE_IOERR_DIR_FSYNC) | 0);  /* check that SQLITE_IOERR_DIR_FSYNC is an integer */
  return n;
}

static int _cffi_const_SQLITE_IOERR_FSTAT(unsigned long long *o)
{
  int n = (SQLITE_IOERR_FSTAT) <= 0;
  *o = (unsigned long long)((SQLITE_IOERR_FSTAT) | 0);  /* check that SQLITE_IOERR_FSTAT is an integer */
  return n;
}

static int _cffi_const_SQLITE_IOERR_FSYNC(unsigned long long *o)
{
  int n = (SQLITE_IOERR_FSYNC) <= 0;
  *o = (unsigned long long)((SQLITE_IOERR_FSYNC) | 0);  /* check that SQLITE_IOERR_FSYNC is an integer */
  return n;
}

static int _cffi_const_SQLITE_IOERR_GETTEMPPATH(unsigned long long *o)
{
  int n = (SQLITE_IOERR_GETTEMPPATH) <= 0;
  *o = (unsigned long long)((SQLITE_IOERR_GETTEMPPATH) | 0);  /* check that SQLITE_IOERR_GETTEMPPATH is an integer */
  return n;
}

static int _cffi_const_SQLITE_IOERR_LOCK(unsigned long long *o)
{
  int n = (SQLITE_IOERR_LOCK) <= 0;
  *o = (unsigned long long)((SQLITE_IOERR_LOCK) | 0);  /* check that SQLITE_IOERR_LOCK is an integer */
  return n;
}

static int _cffi_const_SQLITE_IOERR_MMAP(unsigned long long *o)
{
  int n = (SQLITE_IOERR_MMAP) <= 0;
  *o = (unsigned long long)((SQLITE_IOERR_MMAP) | 0);  /* check that SQLITE_IOERR_MMAP is an integer */
  return n;
}

static int _cffi_const_SQLITE_IOERR_NOMEM(unsigned long long *o)
{
  int n = (SQLITE_IOERR_NOMEM) <= 0;
  *o = (unsigned long long)((SQLITE_IOERR_NOMEM) | 0);  /* check that SQLITE_IOERR_NOMEM is an integer */
  return n;
}

static int _cffi_const_SQLITE_IOERR_RDLOCK(unsigned long long *o)
{
  int n = (SQLITE_IOERR_RDLOCK) <= 0;
  *o = (unsigned long long)((SQLITE_IOERR_RDLOCK) | 0);  /* check that SQLITE_IOERR_RDLOCK is an integer */
  return n;
}

static int _cffi_const_SQLITE_IOERR_READ(unsigned long long *o)
{
  int n = (SQLITE_IOERR_READ) <= 0;
  *o = (unsigned long long)((SQLITE_IOERR_READ) | 0);  /* check that SQLITE_IOERR_READ is an integer */
  return n;
}

static int _cffi_const_SQLITE_IOERR_ROLLBACK_ATOMIC(unsigned long long *o)
{
  int n = (SQLITE_IOERR_ROLLBACK_ATOMIC) <= 0;
  *o = (unsigned long long)((SQLITE_IOERR_ROLLBACK_ATOMIC) | 0);  /* check that SQLITE_IOERR_ROLLBACK_ATOMIC is an integer */
  return n;
}

static int _cffi_const_SQLITE_IOERR_SEEK(unsigned long long *o)
{
  int n = (SQLITE_IOERR_SEEK) <= 0;
  *o = (unsigned long long)((SQLITE_IOERR_SEEK) | 0);  /* check that SQLITE_IOERR_SEEK is an integer */
  return n;
}

static int _cffi_const_SQLITE_IOERR_SHMLOCK(unsigned long long *o)
{
  int n = (SQLITE_IOERR_SHMLOCK) <= 0;
  *o = (unsigned long long)((SQLITE_IOERR_SHMLOCK) | 0);  /* check that SQLITE_IOERR_SHMLOCK is an integer */
  return n;
}

static int _cffi_const_SQLITE_IOERR_SHMMAP(unsigned long long *o)
{
  int n = (SQLITE_IOERR_SHMMAP) <= 0;
  *o = (unsigned long long)((SQLITE_IOERR_SHMMAP) | 0);  /* check that SQLITE_IOERR_SHMMAP is an integer */
  return n;
}

static int _cffi_const_SQLITE_IOERR_SHMOPEN(unsigned long long *o)
{
  int n = (SQLITE_IOERR_SHMOPEN) <= 0;
  *o = (unsigned long long)((SQLITE_IOERR_SHMOPEN) | 0);  /* check that SQLITE_IOERR_SHMOPEN is an integer */
  return n;
}

static int _cffi_const_SQLITE_IOERR_SHMSIZE(unsigned long long *o)
{
  int n = (SQLITE_IOERR_SHMSIZE) <= 0;
  *o = (unsigned long long)((SQLITE_IOERR_SHMSIZE) | 0);  /* check that SQLITE_IOERR_SHMSIZE is an integer */
  return n;
}

static int _cffi_const_SQLITE_IOERR_SHORT_READ(unsigned long long *o)
{
  int n = (SQLITE_IOERR_SHORT_READ) <= 0;
  *o = (unsigned long long)((SQLITE_IOERR_SHORT_READ) | 0);  /* check that SQLITE_IOERR_SHORT_READ is an integer */
  return n;
}

static int _cffi_const_SQLITE_IOERR_TRUNCATE(unsigned long long *o)
{
  int n = (SQLITE_IOERR_TRUNCATE) <= 0;
  *o = (unsigned long long)((SQLITE_IOERR_TRUNCATE) | 0);  /* check that SQLITE_IOERR_TRUNCATE is an integer */
  return n;
}

static int _cffi_const_SQLITE_IOERR_UNLOCK(unsigned long long *o)
{
  int n = (SQLITE_IOERR_UNLOCK) <= 0;
  *o = (unsigned long long)((SQLITE_IOERR_UNLOCK) | 0);  /* check that SQLITE_IOERR_UNLOCK is an integer */
  return n;
}

static int _cffi_const_SQLITE_IOERR_VNODE(unsigned long long *o)
{
  int n = (SQLITE_IOERR_VNODE) <= 0;
  *o = (unsigned long long)((SQLITE_IOERR_VNODE) | 0);  /* check that SQLITE_IOERR_VNODE is an integer */
  return n;
}

static int _cffi_const_SQLITE_IOERR_WRITE(unsigned long long *o)
{
  int n = (SQLITE_IOERR_WRITE) <= 0;
  *o = (unsigned long long)((SQLITE_IOERR_WRITE) | 0);  /* check that SQLITE_IOERR_WRITE is an integer */
  return n;
}

static int _cffi_const_SQLITE_LIMIT_ATTACHED(unsigned long long *o)
{
  int n = (SQLITE_LIMIT_ATTACHED) <= 0;
  *o = (unsigned long long)((SQLITE_LIMIT_ATTACHED) | 0);  /* check that SQLITE_LIMIT_ATTACHED is an integer */
  return n;
}

static int _cffi_const_SQLITE_LIMIT_COLUMN(unsigned long long *o)
{
  int n = (SQLITE_LIMIT_COLUMN) <= 0;
  *o = (unsigned long long)((SQLITE_LIMIT_COLUMN) | 0);  /* check that SQLITE_LIMIT_COLUMN is an integer */
  return n;
}

static int _cffi_const_SQLITE_LIMIT_COMPOUND_SELECT(unsigned long long *o)
{
  int n = (SQLITE_LIMIT_COMPOUND_SELECT) <= 0;
  *o = (unsigned long long)((SQLITE_LIMIT_COMPOUND_SELECT) | 0);  /* check that SQLITE_LIMIT_COMPOUND_SELECT is an integer */
  return n;
}

static int _cffi_const_SQLITE_LIMIT_EXPR_DEPTH(unsigned long long *o)
{
  int n = (SQLITE_LIMIT_EXPR_DEPTH) <= 0;
  *o = (unsigned long long)((SQLITE_LIMIT_EXPR_DEPTH) | 0);  /* check that SQLITE_LIMIT_EXPR_DEPTH is an integer */
  return n;
}

static int _cffi_const_SQLITE_LIMIT_FUNCTION_ARG(unsigned long long *o)
{
  int n = (SQLITE_LIMIT_FUNCTION_ARG) <= 0;
  *o = (unsigned long long)((SQLITE_LIMIT_FUNCTION_ARG) | 0);  /* check that SQLITE_LIMIT_FUNCTION_ARG is an integer */
  return n;
}

static int _cffi_const_SQLITE_LIMIT_LENGTH(unsigned long long *o)
{
  int n = (SQLITE_LIMIT_LENGTH) <= 0;
  *o = (unsigned long long)((SQLITE_LIMIT_LENGTH) | 0);  /* check that SQLITE_LIMIT_LENGTH is an integer */
  return n;
}

static int _cffi_const_SQLITE_LIMIT_LIKE_PATTERN_LENGTH(unsigned long long *o)
{
  int n = (SQLITE_LIMIT_LIKE_PATTERN_LENGTH) <= 0;
  *o = (unsigned long long)((SQLITE_LIMIT_LIKE_PATTERN_LENGTH) | 0);  /* check that SQLITE_LIMIT_LIKE_PATTERN_LENGTH is an integer */
  return n;
}

static int _cffi_const_SQLITE_LIMIT_SQL_LENGTH(unsigned long long *o)
{
  int n = (SQLITE_LIMIT_SQL_LENGTH) <= 0;
  *o = (unsigned long long)((SQLITE_LIMIT_SQL_LENGTH) | 0);  /* check that SQLITE_LIMIT_SQL_LENGTH is an integer */
  return n;
}

static int _cffi_const_SQLITE_LIMIT_TRIGGER_DEPTH(unsigned long long *o)
{
  int n = (SQLITE_LIMIT_TRIGGER_DEPTH) <= 0;
  *o = (unsigned long long)((SQLITE_LIMIT_TRIGGER_DEPTH) | 0);  /* check that SQLITE_LIMIT_TRIGGER_DEPTH is an integer */
  return n;
}

static int _cffi_const_SQLITE_LIMIT_VARIABLE_NUMBER(unsigned long long *o)
{
  int n = (SQLITE_LIMIT_VARIABLE_NUMBER) <= 0;
  *o = (unsigned long long)((SQLITE_LIMIT_VARIABLE_NUMBER) | 0);  /* check that SQLITE_LIMIT_VARIABLE_NUMBER is an integer */
  return n;
}

static int _cffi_const_SQLITE_LIMIT_VDBE_OP(unsigned long long *o)
{
  int n = (SQLITE_LIMIT_VDBE_OP) <= 0;
  *o = (unsigned long long)((SQLITE_LIMIT_VDBE_OP) | 0);  /* check that SQLITE_LIMIT_VDBE_OP is an integer */
  return n;
}

static int _cffi_const_SQLITE_LIMIT_WORKER_THREADS(unsigned long long *o)
{
  int n = (SQLITE_LIMIT_WORKER_THREADS) <= 0;
  *o = (unsigned long long)((SQLITE_LIMIT_WORKER_THREADS) | 0);  /* check that SQLITE_LIMIT_WORKER_THREADS is an integer */
  return n;
}

static int _cffi_const_SQLITE_LOCKED(unsigned long long *o)
{
  int n = (SQLITE_LOCKED) <= 0;
  *o = (unsigned long long)((SQLITE_LOCKED) | 0);  /* check that SQLITE_LOCKED is an integer */
  return n;
}

static int _cffi_const_SQLITE_LOCKED_SHAREDCACHE(unsigned long long *o)
{
  int n = (SQLITE_LOCKED_SHAREDCACHE) <= 0;
  *o = (unsigned long long)((SQLITE_LOCKED_SHAREDCACHE) | 0);  /* check that SQLITE_LOCKED_SHAREDCACHE is an integer */
  return n;
}

static int _cffi_const_SQLITE_LOCKED_VTAB(unsigned long long *o)
{
  int n = (SQLITE_LOCKED_VTAB) <= 0;
  *o = (unsigned long long)((SQLITE_LOCKED_VTAB) | 0);  /* check that SQLITE_LOCKED_VTAB is an integer */
  return n;
}

static int _cffi_const_SQLITE_MISMATCH(unsigned long long *o)
{
  int n = (SQLITE_MISMATCH) <= 0;
  *o = (unsigned long long)((SQLITE_MISMATCH) | 0);  /* check that SQLITE_MISMATCH is an integer */
  return n;
}

static int _cffi_const_SQLITE_MISUSE(unsigned long long *o)
{
  int n = (SQLITE_MISUSE) <= 0;
  *o = (unsigned long long)((SQLITE_MISUSE) | 0);  /* check that SQLITE_MISUSE is an integer */
  return n;
}

static int _cffi_const_SQLITE_NOLFS(unsigned long long *o)
{
  int n = (SQLITE_NOLFS) <= 0;
  *o = (unsigned long long)((SQLITE_NOLFS) | 0);  /* check that SQLITE_NOLFS is an integer */
  return n;
}

static int _cffi_const_SQLITE_NOMEM(unsigned long long *o)
{
  int n = (SQLITE_NOMEM) <= 0;
  *o = (unsigned long long)((SQLITE_NOMEM) | 0);  /* check that SQLITE_NOMEM is an integer */
  return n;
}

static int _cffi_const_SQLITE_NOTADB(unsigned long long *o)
{
  int n = (SQLITE_NOTADB) <= 0;
  *o = (unsigned long long)((SQLITE_NOTADB) | 0);  /* check that SQLITE_NOTADB is an integer */
  return n;
}

static int _cffi_const_SQLITE_NOTFOUND(unsigned long long *o)
{
  int n = (SQLITE_NOTFOUND) <= 0;
  *o = (unsigned long long)((SQLITE_NOTFOUND) | 0);  /* check that SQLITE_NOTFOUND is an integer */
  return n;
}

static int _cffi_const_SQLITE_NOTICE(unsigned long long *o)
{
  int n = (SQLITE_NOTICE) <= 0;
  *o = (unsigned long long)((SQLITE_NOTICE) | 0);  /* check that SQLITE_NOTICE is an integer */
  return n;
}

static int _cffi_const_SQLITE_NOTICE_RECOVER_ROLLBACK(unsigned long long *o)
{
  int n = (SQLITE_NOTICE_RECOVER_ROLLBACK) <= 0;
  *o = (unsigned long long)((SQLITE_NOTICE_RECOVER_ROLLBACK) | 0);  /* check that SQLITE_NOTICE_RECOVER_ROLLBACK is an integer */
  return n;
}

static int _cffi_const_SQLITE_NOTICE_RECOVER_WAL(unsigned long long *o)
{
  int n = (SQLITE_NOTICE_RECOVER_WAL) <= 0;
  *o = (unsigned long long)((SQLITE_NOTICE_RECOVER_WAL) | 0);  /* check that SQLITE_NOTICE_RECOVER_WAL is an integer */
  return n;
}

static int _cffi_const_SQLITE_NULL(unsigned long long *o)
{
  int n = (SQLITE_NULL) <= 0;
  *o = (unsigned long long)((SQLITE_NULL) | 0);  /* check that SQLITE_NULL is an integer */
  return n;
}

static int _cffi_const_SQLITE_OK(unsigned long long *o)
{
  int n = (SQLITE_OK) <= 0;
  *o = (unsigned long long)((SQLITE_OK) | 0);  /* check that SQLITE_OK is an integer */
  return n;
}

static int _cffi_const_SQLITE_OK_LOAD_PERMANENTLY(unsigned long long *o)
{
  int n = (SQLITE_OK_LOAD_PERMANENTLY) <= 0;
  *o = (unsigned long long)((SQLITE_OK_LOAD_PERMANENTLY) | 0);  /* check that SQLITE_OK_LOAD_PERMANENTLY is an integer */
  return n;
}

static int _cffi_const_SQLITE_OK_SYMLINK(unsigned long long *o)
{
  int n = (SQLITE_OK_SYMLINK) <= 0;
  *o = (unsigned long long)((SQLITE_OK_SYMLINK) | 0);  /* check that SQLITE_OK_SYMLINK is an integer */
  return n;
}

static int _cffi_const_SQLITE_PERM(unsigned long long *o)
{
  int n = (SQLITE_PERM) <= 0;
  *o = (unsigned long long)((SQLITE_PERM) | 0);  /* check that SQLITE_PERM is an integer */
  return n;
}

static int _cffi_const_SQLITE_PRAGMA(unsigned long long *o)
{
  int n = (SQLITE_PRAGMA) <= 0;
  *o = (unsigned long long)((SQLITE_PRAGMA) | 0);  /* check that SQLITE_PRAGMA is an integer */
  return n;
}

static int _cffi_const_SQLITE_PROTOCOL(unsigned long long *o)
{
  int n = (SQLITE_PROTOCOL) <= 0;
  *o = (unsigned long long)((SQLITE_PROTOCOL) | 0);  /* check that SQLITE_PROTOCOL is an integer */
  return n;
}

static int _cffi_const_SQLITE_RANGE(unsigned long long *o)
{
  int n = (SQLITE_RANGE) <= 0;
  *o = (unsigned long long)((SQLITE_RANGE) | 0);  /* check that SQLITE_RANGE is an integer */
  return n;
}

static int _cffi_const_SQLITE_READ(unsigned long long *o)
{
  int n = (SQLITE_READ) <= 0;
  *o = (unsigned long long)((SQLITE_READ) | 0);  /* check that SQLITE_READ is an integer */
  return n;
}

static int _cffi_const_SQLITE_READONLY(unsigned long long *o)
{
  int n = (SQLITE_READONLY) <= 0;
  *o = (unsigned long long)((SQLITE_READONLY) | 0);  /* check that SQLITE_READONLY is an integer */
  return n;
}

static int _cffi_const_SQLITE_READONLY_CANTINIT(unsigned long long *o)
{
  int n = (SQLITE_READONLY_CANTINIT) <= 0;
  *o = (unsigned long long)((SQLITE_READONLY_CANTINIT) | 0);  /* check that SQLITE_READONLY_CANTINIT is an integer */
  return n;
}

static int _cffi_const_SQLITE_READONLY_CANTLOCK(unsigned long long *o)
{
  int n = (SQLITE_READONLY_CANTLOCK) <= 0;
  *o = (unsigned long long)((SQLITE_READONLY_CANTLOCK) | 0);  /* check that SQLITE_READONLY_CANTLOCK is an integer */
  return n;
}

static int _cffi_const_SQLITE_READONLY_DBMOVED(unsigned long long *o)
{
  int n = (SQLITE_READONLY_DBMOVED) <= 0;
  *o = (unsigned long long)((SQLITE_READONLY_DBMOVED) | 0);  /* check that SQLITE_READONLY_DBMOVED is an integer */
  return n;
}

static int _cffi_const_SQLITE_READONLY_DIRECTORY(unsigned long long *o)
{
  int n = (SQLITE_READONLY_DIRECTORY) <= 0;
  *o = (unsigned long long)((SQLITE_READONLY_DIRECTORY) | 0);  /* check that SQLITE_READONLY_DIRECTORY is an integer */
  return n;
}

static int _cffi_const_SQLITE_READONLY_RECOVERY(unsigned long long *o)
{
  int n = (SQLITE_READONLY_RECOVERY) <= 0;
  *o = (unsigned long long)((SQLITE_READONLY_RECOVERY) | 0);  /* check that SQLITE_READONLY_RECOVERY is an integer */
  return n;
}

static int _cffi_const_SQLITE_READONLY_ROLLBACK(unsigned long long *o)
{
  int n = (SQLITE_READONLY_ROLLBACK) <= 0;
  *o = (unsigned long long)((SQLITE_READONLY_ROLLBACK) | 0);  /* check that SQLITE_READONLY_ROLLBACK is an integer */
  return n;
}

static int _cffi_const_SQLITE_RECURSIVE(unsigned long long *o)
{
  int n = (SQLITE_RECURSIVE) <= 0;
  *o = (unsigned long long)((SQLITE_RECURSIVE) | 0);  /* check that SQLITE_RECURSIVE is an integer */
  return n;
}

static int _cffi_const_SQLITE_REINDEX(unsigned long long *o)
{
  int n = (SQLITE_REINDEX) <= 0;
  *o = (unsigned long long)((SQLITE_REINDEX) | 0);  /* check that SQLITE_REINDEX is an integer */
  return n;
}

static int _cffi_const_SQLITE_ROW(unsigned long long *o)
{
  int n = (SQLITE_ROW) <= 0;
  *o = (unsigned long long)((SQLITE_ROW) | 0);  /* check that SQLITE_ROW is an integer */
  return n;
}

static int _cffi_const_SQLITE_SAVEPOINT(unsigned long long *o)
{
  int n = (SQLITE_SAVEPOINT) <= 0;
  *o = (unsigned long long)((SQLITE_SAVEPOINT) | 0);  /* check that SQLITE_SAVEPOINT is an integer */
  return n;
}

static int _cffi_const_SQLITE_SCHEMA(unsigned long long *o)
{
  int n = (SQLITE_SCHEMA) <= 0;
  *o = (unsigned long long)((SQLITE_SCHEMA) | 0);  /* check that SQLITE_SCHEMA is an integer */
  return n;
}

static int _cffi_const_SQLITE_SELECT(unsigned long long *o)
{
  int n = (SQLITE_SELECT) <= 0;
  *o = (unsigned long long)((SQLITE_SELECT) | 0);  /* check that SQLITE_SELECT is an integer */
  return n;
}

static int _cffi_const_SQLITE_SERIALIZE_NOCOPY(unsigned long long *o)
{
  int n = (SQLITE_SERIALIZE_NOCOPY) <= 0;
  *o = (unsigned long long)((SQLITE_SERIALIZE_NOCOPY) | 0);  /* check that SQLITE_SERIALIZE_NOCOPY is an integer */
  return n;
}

static int _cffi_const_SQLITE_TEXT(unsigned long long *o)
{
  int n = (SQLITE_TEXT) <= 0;
  *o = (unsigned long long)((SQLITE_TEXT) | 0);  /* check that SQLITE_TEXT is an integer */
  return n;
}

static int _cffi_const_SQLITE_TOOBIG(unsigned long long *o)
{
  int n = (SQLITE_TOOBIG) <= 0;
  *o = (unsigned long long)((SQLITE_TOOBIG) | 0);  /* check that SQLITE_TOOBIG is an integer */
  return n;
}

static int _cffi_const_SQLITE_TRACE_STMT(unsigned long long *o)
{
  int n = (SQLITE_TRACE_STMT) <= 0;
  *o = (unsigned long long)((SQLITE_TRACE_STMT) | 0);  /* check that SQLITE_TRACE_STMT is an integer */
  return n;
}

static int _cffi_const_SQLITE_TRANSACTION(unsigned long long *o)
{
  int n = (SQLITE_TRANSACTION) <= 0;
  *o = (unsigned long long)((SQLITE_TRANSACTION) | 0);  /* check that SQLITE_TRANSACTION is an integer */
  return n;
}

static int _cffi_const_SQLITE_UPDATE(unsigned long long *o)
{
  int n = (SQLITE_UPDATE) <= 0;
  *o = (unsigned long long)((SQLITE_UPDATE) | 0);  /* check that SQLITE_UPDATE is an integer */
  return n;
}

static int _cffi_const_SQLITE_UTF8(unsigned long long *o)
{
  int n = (SQLITE_UTF8) <= 0;
  *o = (unsigned long long)((SQLITE_UTF8) | 0);  /* check that SQLITE_UTF8 is an integer */
  return n;
}

static int _cffi_const_SQLITE_WARNING(unsigned long long *o)
{
  int n = (SQLITE_WARNING) <= 0;
  *o = (unsigned long long)((SQLITE_WARNING) | 0);  /* check that SQLITE_WARNING is an integer */
  return n;
}

static int _cffi_const_SQLITE_WARNING_AUTOINDEX(unsigned long long *o)
{
  int n = (SQLITE_WARNING_AUTOINDEX) <= 0;
  *o = (unsigned long long)((SQLITE_WARNING_AUTOINDEX) | 0);  /* check that SQLITE_WARNING_AUTOINDEX is an integer */
  return n;
}

static const struct _cffi_global_s _cffi_globals[] = {
  { "SQLITE3_TEXT", (void *)_cffi_const_SQLITE3_TEXT, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "SQLITE_ABORT", (void *)_cffi_const_SQLITE_ABORT, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "SQLITE_ABORT_ROLLBACK", (void *)_cffi_const_SQLITE_ABORT_ROLLBACK, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "SQLITE_ALTER_TABLE", (void *)_cffi_const_SQLITE_ALTER_TABLE, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "SQLITE_ANALYZE", (void *)_cffi_const_SQLITE_ANALYZE, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "SQLITE_ATTACH", (void *)_cffi_const_SQLITE_ATTACH, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "SQLITE_AUTH", (void *)_cffi_const_SQLITE_AUTH, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "SQLITE_AUTH_USER", (void *)_cffi_const_SQLITE_AUTH_USER, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "SQLITE_BLOB", (void *)_cffi_const_SQLITE_BLOB, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "SQLITE_BUSY", (void *)_cffi_const_SQLITE_BUSY, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "SQLITE_BUSY_RECOVERY", (void *)_cffi_const_SQLITE_BUSY_RECOVERY, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "SQLITE_BUSY_SNAPSHOT", (void *)_cffi_const_SQLITE_BUSY_SNAPSHOT, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "SQLITE_BUSY_TIMEOUT", (void *)_cffi_const_SQLITE_BUSY_TIMEOUT, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "SQLITE_CANTOPEN", (void *)_cffi_const_SQLITE_CANTOPEN, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "SQLITE_CANTOPEN_CONVPATH", (void *)_cffi_const_SQLITE_CANTOPEN_CONVPATH, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "SQLITE_CANTOPEN_DIRTYWAL", (void *)_cffi_const_SQLITE_CANTOPEN_DIRTYWAL, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "SQLITE_CANTOPEN_FULLPATH", (void *)_cffi_const_SQLITE_CANTOPEN_FULLPATH, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "SQLITE_CANTOPEN_ISDIR", (void *)_cffi_const_SQLITE_CANTOPEN_ISDIR, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "SQLITE_CANTOPEN_NOTEMPDIR", (void *)_cffi_const_SQLITE_CANTOPEN_NOTEMPDIR, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "SQLITE_CANTOPEN_SYMLINK", (void *)_cffi_const_SQLITE_CANTOPEN_SYMLINK, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "SQLITE_CONSTRAINT", (void *)_cffi_const_SQLITE_CONSTRAINT, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "SQLITE_CONSTRAINT_CHECK", (void *)_cffi_const_SQLITE_CONSTRAINT_CHECK, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "SQLITE_CONSTRAINT_COMMITHOOK", (void *)_cffi_const_SQLITE_CONSTRAINT_COMMITHOOK, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "SQLITE_CONSTRAINT_FOREIGNKEY", (void *)_cffi_const_SQLITE_CONSTRAINT_FOREIGNKEY, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "SQLITE_CONSTRAINT_FUNCTION", (void *)_cffi_const_SQLITE_CONSTRAINT_FUNCTION, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "SQLITE_CONSTRAINT_NOTNULL", (void *)_cffi_const_SQLITE_CONSTRAINT_NOTNULL, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "SQLITE_CONSTRAINT_PINNED", (void *)_cffi_const_SQLITE_CONSTRAINT_PINNED, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "SQLITE_CONSTRAINT_PRIMARYKEY", (void *)_cffi_const_SQLITE_CONSTRAINT_PRIMARYKEY, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "SQLITE_CONSTRAINT_ROWID", (void *)_cffi_const_SQLITE_CONSTRAINT_ROWID, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "SQLITE_CONSTRAINT_TRIGGER", (void *)_cffi_const_SQLITE_CONSTRAINT_TRIGGER, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "SQLITE_CONSTRAINT_UNIQUE", (void *)_cffi_const_SQLITE_CONSTRAINT_UNIQUE, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "SQLITE_CONSTRAINT_VTAB", (void *)_cffi_const_SQLITE_CONSTRAINT_VTAB, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "SQLITE_CORRUPT", (void *)_cffi_const_SQLITE_CORRUPT, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "SQLITE_CORRUPT_INDEX", (void *)_cffi_const_SQLITE_CORRUPT_INDEX, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "SQLITE_CORRUPT_SEQUENCE", (void *)_cffi_const_SQLITE_CORRUPT_SEQUENCE, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "SQLITE_CORRUPT_VTAB", (void *)_cffi_const_SQLITE_CORRUPT_VTAB, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "SQLITE_CREATE_INDEX", (void *)_cffi_const_SQLITE_CREATE_INDEX, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "SQLITE_CREATE_TABLE", (void *)_cffi_const_SQLITE_CREATE_TABLE, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "SQLITE_CREATE_TEMP_INDEX", (void *)_cffi_const_SQLITE_CREATE_TEMP_INDEX, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "SQLITE_CREATE_TEMP_TABLE", (void *)_cffi_const_SQLITE_CREATE_TEMP_TABLE, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "SQLITE_CREATE_TEMP_TRIGGER", (void *)_cffi_const_SQLITE_CREATE_TEMP_TRIGGER, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "SQLITE_CREATE_TEMP_VIEW", (void *)_cffi_const_SQLITE_CREATE_TEMP_VIEW, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "SQLITE_CREATE_TRIGGER", (void *)_cffi_const_SQLITE_CREATE_TRIGGER, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "SQLITE_CREATE_VIEW", (void *)_cffi_const_SQLITE_CREATE_VIEW, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "SQLITE_CREATE_VTABLE", (void *)_cffi_const_SQLITE_CREATE_VTABLE, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "SQLITE_DELETE", (void *)_cffi_const_SQLITE_DELETE, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "SQLITE_DENY", (void *)_cffi_const_SQLITE_DENY, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "SQLITE_DESERIALIZE_FREEONCLOSE", (void *)_cffi_const_SQLITE_DESERIALIZE_FREEONCLOSE, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "SQLITE_DESERIALIZE_RESIZEABLE", (void *)_cffi_const_SQLITE_DESERIALIZE_RESIZEABLE, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "SQLITE_DETACH", (void *)_cffi_const_SQLITE_DETACH, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "SQLITE_DETERMINISTIC", (void *)_cffi_const_SQLITE_DETERMINISTIC, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "SQLITE_DONE", (void *)_cffi_const_SQLITE_DONE, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "SQLITE_DROP_INDEX", (void *)_cffi_const_SQLITE_DROP_INDEX, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "SQLITE_DROP_TABLE", (void *)_cffi_const_SQLITE_DROP_TABLE, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "SQLITE_DROP_TEMP_INDEX", (void *)_cffi_const_SQLITE_DROP_TEMP_INDEX, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "SQLITE_DROP_TEMP_TABLE", (void *)_cffi_const_SQLITE_DROP_TEMP_TABLE, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "SQLITE_DROP_TEMP_TRIGGER", (void *)_cffi_const_SQLITE_DROP_TEMP_TRIGGER, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "SQLITE_DROP_TEMP_VIEW", (void *)_cffi_const_SQLITE_DROP_TEMP_VIEW, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "SQLITE_DROP_TRIGGER", (void *)_cffi_const_SQLITE_DROP_TRIGGER, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "SQLITE_DROP_VIEW", (void *)_cffi_const_SQLITE_DROP_VIEW, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "SQLITE_DROP_VTABLE", (void *)_cffi_const_SQLITE_DROP_VTABLE, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "SQLITE_EMPTY", (void *)_cffi_const_SQLITE_EMPTY, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "SQLITE_ERROR", (void *)_cffi_const_SQLITE_ERROR, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "SQLITE_ERROR_MISSING_COLLSEQ", (void *)_cffi_const_SQLITE_ERROR_MISSING_COLLSEQ, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "SQLITE_ERROR_RETRY", (void *)_cffi_const_SQLITE_ERROR_RETRY, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "SQLITE_ERROR_SNAPSHOT", (void *)_cffi_const_SQLITE_ERROR_SNAPSHOT, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "SQLITE_FLOAT", (void *)_cffi_const_SQLITE_FLOAT, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "SQLITE_FORMAT", (void *)_cffi_const_SQLITE_FORMAT, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "SQLITE_FULL", (void *)_cffi_const_SQLITE_FULL, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "SQLITE_FUNCTION", (void *)_cffi_const_SQLITE_FUNCTION, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "SQLITE_IGNORE", (void *)_cffi_const_SQLITE_IGNORE, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "SQLITE_INSERT", (void *)_cffi_const_SQLITE_INSERT, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "SQLITE_INTEGER", (void *)_cffi_const_SQLITE_INTEGER, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "SQLITE_INTERNAL", (void *)_cffi_const_SQLITE_INTERNAL, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "SQLITE_INTERRUPT", (void *)_cffi_const_SQLITE_INTERRUPT, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "SQLITE_IOERR", (void *)_cffi_const_SQLITE_IOERR, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "SQLITE_IOERR_ACCESS", (void *)_cffi_const_SQLITE_IOERR_ACCESS, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "SQLITE_IOERR_AUTH", (void *)_cffi_const_SQLITE_IOERR_AUTH, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "SQLITE_IOERR_BEGIN_ATOMIC", (void *)_cffi_const_SQLITE_IOERR_BEGIN_ATOMIC, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "SQLITE_IOERR_BLOCKED", (void *)_cffi_const_SQLITE_IOERR_BLOCKED, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "SQLITE_IOERR_CHECKRESERVEDLOCK", (void *)_cffi_const_SQLITE_IOERR_CHECKRESERVEDLOCK, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "SQLITE_IOERR_CLOSE", (void *)_cffi_const_SQLITE_IOERR_CLOSE, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "SQLITE_IOERR_COMMIT_ATOMIC", (void *)_cffi_const_SQLITE_IOERR_COMMIT_ATOMIC, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "SQLITE_IOERR_CONVPATH", (void *)_cffi_const_SQLITE_IOERR_CONVPATH, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "SQLITE_IOERR_CORRUPTFS", (void *)_cffi_const_SQLITE_IOERR_CORRUPTFS, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "SQLITE_IOERR_DATA", (void *)_cffi_const_SQLITE_IOERR_DATA, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "SQLITE_IOERR_DELETE", (void *)_cffi_const_SQLITE_IOERR_DELETE, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "SQLITE_IOERR_DELETE_NOENT", (void *)_cffi_const_SQLITE_IOERR_DELETE_NOENT, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "SQLITE_IOERR_DIR_CLOSE", (void *)_cffi_const_SQLITE_IOERR_DIR_CLOSE, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "SQLITE_IOERR_DIR_FSYNC", (void *)_cffi_const_SQLITE_IOERR_DIR_FSYNC, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "SQLITE_IOERR_FSTAT", (void *)_cffi_const_SQLITE_IOERR_FSTAT, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "SQLITE_IOERR_FSYNC", (void *)_cffi_const_SQLITE_IOERR_FSYNC, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "SQLITE_IOERR_GETTEMPPATH", (void *)_cffi_const_SQLITE_IOERR_GETTEMPPATH, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "SQLITE_IOERR_LOCK", (void *)_cffi_const_SQLITE_IOERR_LOCK, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "SQLITE_IOERR_MMAP", (void *)_cffi_const_SQLITE_IOERR_MMAP, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "SQLITE_IOERR_NOMEM", (void *)_cffi_const_SQLITE_IOERR_NOMEM, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "SQLITE_IOERR_RDLOCK", (void *)_cffi_const_SQLITE_IOERR_RDLOCK, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "SQLITE_IOERR_READ", (void *)_cffi_const_SQLITE_IOERR_READ, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "SQLITE_IOERR_ROLLBACK_ATOMIC", (void *)_cffi_const_SQLITE_IOERR_ROLLBACK_ATOMIC, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "SQLITE_IOERR_SEEK", (void *)_cffi_const_SQLITE_IOERR_SEEK, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "SQLITE_IOERR_SHMLOCK", (void *)_cffi_const_SQLITE_IOERR_SHMLOCK, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "SQLITE_IOERR_SHMMAP", (void *)_cffi_const_SQLITE_IOERR_SHMMAP, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "SQLITE_IOERR_SHMOPEN", (void *)_cffi_const_SQLITE_IOERR_SHMOPEN, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "SQLITE_IOERR_SHMSIZE", (void *)_cffi_const_SQLITE_IOERR_SHMSIZE, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "SQLITE_IOERR_SHORT_READ", (void *)_cffi_const_SQLITE_IOERR_SHORT_READ, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "SQLITE_IOERR_TRUNCATE", (void *)_cffi_const_SQLITE_IOERR_TRUNCATE, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "SQLITE_IOERR_UNLOCK", (void *)_cffi_const_SQLITE_IOERR_UNLOCK, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "SQLITE_IOERR_VNODE", (void *)_cffi_const_SQLITE_IOERR_VNODE, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "SQLITE_IOERR_WRITE", (void *)_cffi_const_SQLITE_IOERR_WRITE, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "SQLITE_LIMIT_ATTACHED", (void *)_cffi_const_SQLITE_LIMIT_ATTACHED, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "SQLITE_LIMIT_COLUMN", (void *)_cffi_const_SQLITE_LIMIT_COLUMN, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "SQLITE_LIMIT_COMPOUND_SELECT", (void *)_cffi_const_SQLITE_LIMIT_COMPOUND_SELECT, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "SQLITE_LIMIT_EXPR_DEPTH", (void *)_cffi_const_SQLITE_LIMIT_EXPR_DEPTH, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "SQLITE_LIMIT_FUNCTION_ARG", (void *)_cffi_const_SQLITE_LIMIT_FUNCTION_ARG, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "SQLITE_LIMIT_LENGTH", (void *)_cffi_const_SQLITE_LIMIT_LENGTH, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "SQLITE_LIMIT_LIKE_PATTERN_LENGTH", (void *)_cffi_const_SQLITE_LIMIT_LIKE_PATTERN_LENGTH, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "SQLITE_LIMIT_SQL_LENGTH", (void *)_cffi_const_SQLITE_LIMIT_SQL_LENGTH, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "SQLITE_LIMIT_TRIGGER_DEPTH", (void *)_cffi_const_SQLITE_LIMIT_TRIGGER_DEPTH, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "SQLITE_LIMIT_VARIABLE_NUMBER", (void *)_cffi_const_SQLITE_LIMIT_VARIABLE_NUMBER, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "SQLITE_LIMIT_VDBE_OP", (void *)_cffi_const_SQLITE_LIMIT_VDBE_OP, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "SQLITE_LIMIT_WORKER_THREADS", (void *)_cffi_const_SQLITE_LIMIT_WORKER_THREADS, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "SQLITE_LOCKED", (void *)_cffi_const_SQLITE_LOCKED, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "SQLITE_LOCKED_SHAREDCACHE", (void *)_cffi_const_SQLITE_LOCKED_SHAREDCACHE, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "SQLITE_LOCKED_VTAB", (void *)_cffi_const_SQLITE_LOCKED_VTAB, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "SQLITE_MISMATCH", (void *)_cffi_const_SQLITE_MISMATCH, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "SQLITE_MISUSE", (void *)_cffi_const_SQLITE_MISUSE, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "SQLITE_NOLFS", (void *)_cffi_const_SQLITE_NOLFS, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "SQLITE_NOMEM", (void *)_cffi_const_SQLITE_NOMEM, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "SQLITE_NOTADB", (void *)_cffi_const_SQLITE_NOTADB, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "SQLITE_NOTFOUND", (void *)_cffi_const_SQLITE_NOTFOUND, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "SQLITE_NOTICE", (void *)_cffi_const_SQLITE_NOTICE, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "SQLITE_NOTICE_RECOVER_ROLLBACK", (void *)_cffi_const_SQLITE_NOTICE_RECOVER_ROLLBACK, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "SQLITE_NOTICE_RECOVER_WAL", (void *)_cffi_const_SQLITE_NOTICE_RECOVER_WAL, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "SQLITE_NULL", (void *)_cffi_const_SQLITE_NULL, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "SQLITE_OK", (void *)_cffi_const_SQLITE_OK, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "SQLITE_OK_LOAD_PERMANENTLY", (void *)_cffi_const_SQLITE_OK_LOAD_PERMANENTLY, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "SQLITE_OK_SYMLINK", (void *)_cffi_const_SQLITE_OK_SYMLINK, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "SQLITE_OPEN_CREATE", (void *)_cffi_const_SQLITE_OPEN_CREATE, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "SQLITE_OPEN_READWRITE", (void *)_cffi_const_SQLITE_OPEN_READWRITE, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "SQLITE_OPEN_URI", (void *)_cffi_const_SQLITE_OPEN_URI, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "SQLITE_PERM", (void *)_cffi_const_SQLITE_PERM, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "SQLITE_PRAGMA", (void *)_cffi_const_SQLITE_PRAGMA, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "SQLITE_PROTOCOL", (void *)_cffi_const_SQLITE_PROTOCOL, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "SQLITE_RANGE", (void *)_cffi_const_SQLITE_RANGE, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "SQLITE_READ", (void *)_cffi_const_SQLITE_READ, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "SQLITE_READONLY", (void *)_cffi_const_SQLITE_READONLY, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "SQLITE_READONLY_CANTINIT", (void *)_cffi_const_SQLITE_READONLY_CANTINIT, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "SQLITE_READONLY_CANTLOCK", (void *)_cffi_const_SQLITE_READONLY_CANTLOCK, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "SQLITE_READONLY_DBMOVED", (void *)_cffi_const_SQLITE_READONLY_DBMOVED, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "SQLITE_READONLY_DIRECTORY", (void *)_cffi_const_SQLITE_READONLY_DIRECTORY, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "SQLITE_READONLY_RECOVERY", (void *)_cffi_const_SQLITE_READONLY_RECOVERY, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "SQLITE_READONLY_ROLLBACK", (void *)_cffi_const_SQLITE_READONLY_ROLLBACK, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "SQLITE_RECURSIVE", (void *)_cffi_const_SQLITE_RECURSIVE, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "SQLITE_REINDEX", (void *)_cffi_const_SQLITE_REINDEX, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "SQLITE_ROW", (void *)_cffi_const_SQLITE_ROW, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "SQLITE_SAVEPOINT", (void *)_cffi_const_SQLITE_SAVEPOINT, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "SQLITE_SCHEMA", (void *)_cffi_const_SQLITE_SCHEMA, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "SQLITE_SELECT", (void *)_cffi_const_SQLITE_SELECT, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "SQLITE_SERIALIZE_NOCOPY", (void *)_cffi_const_SQLITE_SERIALIZE_NOCOPY, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "SQLITE_TEXT", (void *)_cffi_const_SQLITE_TEXT, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "SQLITE_TOOBIG", (void *)_cffi_const_SQLITE_TOOBIG, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "SQLITE_TRACE_STMT", (void *)_cffi_const_SQLITE_TRACE_STMT, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "SQLITE_TRANSACTION", (void *)_cffi_const_SQLITE_TRANSACTION, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "SQLITE_TRANSIENT", (void *)_cffi_const_SQLITE_TRANSIENT, _CFFI_OP(_CFFI_OP_CONSTANT, 61), (void *)0 },
  { "SQLITE_UPDATE", (void *)_cffi_const_SQLITE_UPDATE, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "SQLITE_UTF8", (void *)_cffi_const_SQLITE_UTF8, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "SQLITE_WARNING", (void *)_cffi_const_SQLITE_WARNING, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "SQLITE_WARNING_AUTOINDEX", (void *)_cffi_const_SQLITE_WARNING_AUTOINDEX, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "sqlite3_aggregate_context", (void *)_cffi_f_sqlite3_aggregate_context, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 244), (void *)_cffi_d_sqlite3_aggregate_context },
  { "sqlite3_backup_finish", (void *)_cffi_f_sqlite3_backup_finish, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 120), (void *)_cffi_d_sqlite3_backup_finish },
  { "sqlite3_backup_init", (void *)_cffi_f_sqlite3_backup_init, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 222), (void *)_cffi_d_sqlite3_backup_init },
  { "sqlite3_backup_pagecount", (void *)_cffi_f_sqlite3_backup_pagecount, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 120), (void *)_cffi_d_sqlite3_backup_pagecount },
  { "sqlite3_backup_remaining", (void *)_cffi_f_sqlite3_backup_remaining, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 120), (void *)_cffi_d_sqlite3_backup_remaining },
  { "sqlite3_backup_step", (void *)_cffi_f_sqlite3_backup_step, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 123), (void *)_cffi_d_sqlite3_backup_step },
  { "sqlite3_bind_blob", (void *)_cffi_f_sqlite3_bind_blob, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 176), (void *)_cffi_d_sqlite3_bind_blob },
  { "sqlite3_bind_double", (void *)_cffi_f_sqlite3_bind_double, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 156), (void *)_cffi_d_sqlite3_bind_double },
  { "sqlite3_bind_int", (void *)_cffi_f_sqlite3_bind_int, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 161), (void *)_cffi_d_sqlite3_bind_int },
  { "sqlite3_bind_int64", (void *)_cffi_f_sqlite3_bind_int64, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 166), (void *)_cffi_d_sqlite3_bind_int64 },
  { "sqlite3_bind_null", (void *)_cffi_f_sqlite3_bind_null, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 145), (void *)_cffi_d_sqlite3_bind_null },
  { "sqlite3_bind_parameter_count", (void *)_cffi_f_sqlite3_bind_parameter_count, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 142), (void *)_cffi_d_sqlite3_bind_parameter_count },
  { "sqlite3_bind_parameter_name", (void *)_cffi_f_sqlite3_bind_parameter_name, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 9), (void *)_cffi_d_sqlite3_bind_parameter_name },
  { "sqlite3_bind_text", (void *)_cffi_f_sqlite3_bind_text, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 149), (void *)_cffi_d_sqlite3_bind_text },
  { "sqlite3_bind_text16", (void *)_cffi_f_sqlite3_bind_text16, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 176), (void *)_cffi_d_sqlite3_bind_text16 },
  { "sqlite3_bind_value", (void *)_cffi_f_sqlite3_bind_value, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 171), (void *)_cffi_d_sqlite3_bind_value },
  { "sqlite3_bind_zeroblob", (void *)_cffi_f_sqlite3_bind_zeroblob, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 161), (void *)_cffi_d_sqlite3_bind_zeroblob },
  { "sqlite3_blob_bytes", (void *)_cffi_f_sqlite3_blob_bytes, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 127), (void *)_cffi_d_sqlite3_blob_bytes },
  { "sqlite3_blob_close", (void *)_cffi_f_sqlite3_blob_close, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 127), (void *)_cffi_d_sqlite3_blob_close },
  { "sqlite3_blob_open", (void *)_cffi_f_sqlite3_blob_open, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 47), (void *)_cffi_d_sqlite3_blob_open },
  { "sqlite3_blob_read", (void *)_cffi_f_sqlite3_blob_read, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 130), (void *)_cffi_d_sqlite3_blob_read },
  { "sqlite3_blob_write", (void *)_cffi_f_sqlite3_blob_write, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 136), (void *)_cffi_d_sqlite3_blob_write },
  { "sqlite3_busy_timeout", (void *)_cffi_f_sqlite3_busy_timeout, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 105), (void *)_cffi_d_sqlite3_busy_timeout },
  { "sqlite3_changes", (void *)_cffi_f_sqlite3_changes, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 38), (void *)_cffi_d_sqlite3_changes },
  { "sqlite3_close", (void *)_cffi_f_sqlite3_close, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 38), (void *)_cffi_d_sqlite3_close },
  { "sqlite3_column_blob", (void *)_cffi_f_sqlite3_column_blob, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 251), (void *)_cffi_d_sqlite3_column_blob },
  { "sqlite3_column_bytes", (void *)_cffi_f_sqlite3_column_bytes, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 145), (void *)_cffi_d_sqlite3_column_bytes },
  { "sqlite3_column_count", (void *)_cffi_f_sqlite3_column_count, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 142), (void *)_cffi_d_sqlite3_column_count },
  { "sqlite3_column_decltype", (void *)_cffi_f_sqlite3_column_decltype, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 9), (void *)_cffi_d_sqlite3_column_decltype },
  { "sqlite3_column_double", (void *)_cffi_f_sqlite3_column_double, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 15), (void *)_cffi_d_sqlite3_column_double },
  { "sqlite3_column_int", (void *)_cffi_f_sqlite3_column_int, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 145), (void *)_cffi_d_sqlite3_column_int },
  { "sqlite3_column_int64", (void *)_cffi_f_sqlite3_column_int64, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 215), (void *)_cffi_d_sqlite3_column_int64 },
  { "sqlite3_column_name", (void *)_cffi_f_sqlite3_column_name, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 9), (void *)_cffi_d_sqlite3_column_name },
  { "sqlite3_column_text", (void *)_cffi_f_sqlite3_column_text, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 234), (void *)_cffi_d_sqlite3_column_text },
  { "sqlite3_column_text16", (void *)_cffi_f_sqlite3_column_text16, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 251), (void *)_cffi_d_sqlite3_column_text16 },
  { "sqlite3_column_type", (void *)_cffi_f_sqlite3_column_type, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 145), (void *)_cffi_d_sqlite3_column_type },
  { "sqlite3_complete", (void *)_cffi_f_sqlite3_complete, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 22), (void *)_cffi_d_sqlite3_complete },
  { "sqlite3_create_collation", (void *)_cffi_f_sqlite3_create_collation, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 85), (void *)_cffi_d_sqlite3_create_collation },
  { "sqlite3_create_function", (void *)_cffi_f_sqlite3_create_function, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 68), (void *)_cffi_d_sqlite3_create_function },
  { "sqlite3_create_window_function", (void *)_cffi_f_sqlite3_create_window_function, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 56), (void *)_cffi_d_sqlite3_create_window_function },
  { "sqlite3_data_count", (void *)_cffi_f_sqlite3_data_count, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 142), (void *)_cffi_d_sqlite3_data_count },
  { "sqlite3_deserialize", (void *)_cffi_f_sqlite3_deserialize, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 92), (void *)_cffi_d_sqlite3_deserialize },
  { "sqlite3_enable_load_extension", (void *)_cffi_f_sqlite3_enable_load_extension, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 105), (void *)_cffi_d_sqlite3_enable_load_extension },
  { "sqlite3_errcode", (void *)_cffi_f_sqlite3_errcode, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 38), (void *)_cffi_d_sqlite3_errcode },
  { "sqlite3_errmsg", (void *)_cffi_f_sqlite3_errmsg, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 6), (void *)_cffi_d_sqlite3_errmsg },
  { "sqlite3_errstr", (void *)_cffi_f_sqlite3_errstr, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 3), (void *)_cffi_d_sqlite3_errstr },
  { "sqlite3_expanded_sql", (void *)_cffi_f_sqlite3_expanded_sql, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 0), (void *)_cffi_d_sqlite3_expanded_sql },
  { "sqlite3_extended_errcode", (void *)_cffi_f_sqlite3_extended_errcode, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 38), (void *)_cffi_d_sqlite3_extended_errcode },
  { "sqlite3_finalize", (void *)_cffi_f_sqlite3_finalize, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 142), (void *)_cffi_d_sqlite3_finalize },
  { "sqlite3_free", (void *)_cffi_f_sqlite3_free, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 313), (void *)_cffi_d_sqlite3_free },
  { "sqlite3_get_autocommit", (void *)_cffi_f_sqlite3_get_autocommit, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 38), (void *)_cffi_d_sqlite3_get_autocommit },
  { "sqlite3_interrupt", (void *)_cffi_f_sqlite3_interrupt, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 258), (void *)_cffi_d_sqlite3_interrupt },
  { "sqlite3_last_insert_rowid", (void *)_cffi_f_sqlite3_last_insert_rowid, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 212), (void *)_cffi_d_sqlite3_last_insert_rowid },
  { "sqlite3_libversion", (void *)_cffi_f_sqlite3_libversion, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 13), (void *)_cffi_d_sqlite3_libversion },
  { "sqlite3_libversion_number", (void *)_cffi_f_sqlite3_libversion_number, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 210), (void *)_cffi_d_sqlite3_libversion_number },
  { "sqlite3_limit", (void *)_cffi_f_sqlite3_limit, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 109), (void *)_cffi_d_sqlite3_limit },
  { "sqlite3_load_extension", (void *)_cffi_f_sqlite3_load_extension, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 41), (void *)_cffi_d_sqlite3_load_extension },
  { "sqlite3_malloc", (void *)_cffi_f_sqlite3_malloc, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 241), (void *)_cffi_d_sqlite3_malloc },
  { "sqlite3_malloc64", (void *)_cffi_f_sqlite3_malloc64, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 248), (void *)_cffi_d_sqlite3_malloc64 },
  { "sqlite3_open", (void *)_cffi_f_sqlite3_open, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 25), (void *)_cffi_d_sqlite3_open },
  { "sqlite3_open_v2", (void *)_cffi_f_sqlite3_open_v2, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 29), (void *)_cffi_d_sqlite3_open_v2 },
  { "sqlite3_prepare", (void *)_cffi_f_sqlite3_prepare, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 78), (void *)_cffi_d_sqlite3_prepare },
  { "sqlite3_prepare_v2", (void *)_cffi_f_sqlite3_prepare_v2, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 78), (void *)_cffi_d_sqlite3_prepare_v2 },
  { "sqlite3_progress_handler", (void *)_cffi_f_sqlite3_progress_handler, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 261), (void *)_cffi_d_sqlite3_progress_handler },
  { "sqlite3_reset", (void *)_cffi_f_sqlite3_reset, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 142), (void *)_cffi_d_sqlite3_reset },
  { "sqlite3_result_blob", (void *)_cffi_f_sqlite3_result_blob, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 307), (void *)_cffi_d_sqlite3_result_blob },
  { "sqlite3_result_double", (void *)_cffi_f_sqlite3_result_double, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 281), (void *)_cffi_d_sqlite3_result_double },
  { "sqlite3_result_error", (void *)_cffi_f_sqlite3_result_error, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 270), (void *)_cffi_d_sqlite3_result_error },
  { "sqlite3_result_error16", (void *)_cffi_f_sqlite3_result_error16, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 302), (void *)_cffi_d_sqlite3_result_error16 },
  { "sqlite3_result_error_code", (void *)_cffi_f_sqlite3_result_error_code, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 285), (void *)_cffi_d_sqlite3_result_error_code },
  { "sqlite3_result_error_nomem", (void *)_cffi_f_sqlite3_result_error_nomem, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 267), (void *)_cffi_d_sqlite3_result_error_nomem },
  { "sqlite3_result_error_toobig", (void *)_cffi_f_sqlite3_result_error_toobig, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 267), (void *)_cffi_d_sqlite3_result_error_toobig },
  { "sqlite3_result_int", (void *)_cffi_f_sqlite3_result_int, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 285), (void *)_cffi_d_sqlite3_result_int },
  { "sqlite3_result_int64", (void *)_cffi_f_sqlite3_result_int64, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 294), (void *)_cffi_d_sqlite3_result_int64 },
  { "sqlite3_result_null", (void *)_cffi_f_sqlite3_result_null, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 267), (void *)_cffi_d_sqlite3_result_null },
  { "sqlite3_result_text", (void *)_cffi_f_sqlite3_result_text, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 275), (void *)_cffi_d_sqlite3_result_text },
  { "sqlite3_result_text16", (void *)_cffi_f_sqlite3_result_text16, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 307), (void *)_cffi_d_sqlite3_result_text16 },
  { "sqlite3_result_text16be", (void *)_cffi_f_sqlite3_result_text16be, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 307), (void *)_cffi_d_sqlite3_result_text16be },
  { "sqlite3_result_text16le", (void *)_cffi_f_sqlite3_result_text16le, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 307), (void *)_cffi_d_sqlite3_result_text16le },
  { "sqlite3_result_value", (void *)_cffi_f_sqlite3_result_value, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 298), (void *)_cffi_d_sqlite3_result_value },
  { "sqlite3_result_zeroblob", (void *)_cffi_f_sqlite3_result_zeroblob, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 285), (void *)_cffi_d_sqlite3_result_zeroblob },
  { "sqlite3_serialize", (void *)_cffi_f_sqlite3_serialize, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 228), (void *)_cffi_d_sqlite3_serialize },
  { "sqlite3_set_authorizer", (void *)_cffi_f_sqlite3_set_authorizer, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 100), (void *)_cffi_d_sqlite3_set_authorizer },
  { "sqlite3_sleep", (void *)_cffi_f_sqlite3_sleep, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 35), (void *)_cffi_d_sqlite3_sleep },
  { "sqlite3_step", (void *)_cffi_f_sqlite3_step, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 142), (void *)_cffi_d_sqlite3_step },
  { "sqlite3_threadsafe", (void *)_cffi_f_sqlite3_threadsafe, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 210), (void *)_cffi_d_sqlite3_threadsafe },
  { "sqlite3_total_changes", (void *)_cffi_f_sqlite3_total_changes, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 38), (void *)_cffi_d_sqlite3_total_changes },
  { "sqlite3_trace_v2", (void *)_cffi_f_sqlite3_trace_v2, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 114), (void *)_cffi_d_sqlite3_trace_v2 },
  { "sqlite3_value_blob", (void *)_cffi_f_sqlite3_value_blob, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 255), (void *)_cffi_d_sqlite3_value_blob },
  { "sqlite3_value_bytes", (void *)_cffi_f_sqlite3_value_bytes, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 183), (void *)_cffi_d_sqlite3_value_bytes },
  { "sqlite3_value_bytes16", (void *)_cffi_f_sqlite3_value_bytes16, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 183), (void *)_cffi_d_sqlite3_value_bytes16 },
  { "sqlite3_value_double", (void *)_cffi_f_sqlite3_value_double, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 19), (void *)_cffi_d_sqlite3_value_double },
  { "sqlite3_value_int", (void *)_cffi_f_sqlite3_value_int, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 183), (void *)_cffi_d_sqlite3_value_int },
  { "sqlite3_value_int64", (void *)_cffi_f_sqlite3_value_int64, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 219), (void *)_cffi_d_sqlite3_value_int64 },
  { "sqlite3_value_numeric_type", (void *)_cffi_f_sqlite3_value_numeric_type, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 183), (void *)_cffi_d_sqlite3_value_numeric_type },
  { "sqlite3_value_text", (void *)_cffi_f_sqlite3_value_text, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 238), (void *)_cffi_d_sqlite3_value_text },
  { "sqlite3_value_text16", (void *)_cffi_f_sqlite3_value_text16, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 255), (void *)_cffi_d_sqlite3_value_text16 },
  { "sqlite3_value_text16be", (void *)_cffi_f_sqlite3_value_text16be, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 255), (void *)_cffi_d_sqlite3_value_text16be },
  { "sqlite3_value_text16le", (void *)_cffi_f_sqlite3_value_text16le, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 255), (void *)_cffi_d_sqlite3_value_text16le },
  { "sqlite3_value_type", (void *)_cffi_f_sqlite3_value_type, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 183), (void *)_cffi_d_sqlite3_value_type },
};

static const struct _cffi_struct_union_s _cffi_struct_unions[] = {
  { "$sqlite3", 318, _CFFI_F_OPAQUE,
    (size_t)-1, -1, -1, 0 /* opaque */ },
  { "$sqlite3_backup", 319, _CFFI_F_OPAQUE,
    (size_t)-1, -1, -1, 0 /* opaque */ },
  { "$sqlite3_blob", 320, _CFFI_F_OPAQUE,
    (size_t)-1, -1, -1, 0 /* opaque */ },
  { "$sqlite3_context", 321, _CFFI_F_OPAQUE,
    (size_t)-1, -1, -1, 0 /* opaque */ },
  { "$sqlite3_stmt", 322, _CFFI_F_OPAQUE,
    (size_t)-1, -1, -1, 0 /* opaque */ },
  { "$sqlite3_value", 323, _CFFI_F_OPAQUE,
    (size_t)-1, -1, -1, 0 /* opaque */ },
};

static const struct _cffi_typename_s _cffi_typenames[] = {
  { "sqlite3", 318 },
  { "sqlite3_backup", 319 },
  { "sqlite3_blob", 320 },
  { "sqlite3_context", 321 },
  { "sqlite3_int64", 52 },
  { "sqlite3_stmt", 322 },
  { "sqlite3_uint64", 249 },
  { "sqlite3_value", 323 },
};

static const struct _cffi_type_context_s _cffi_type_context = {
  _cffi_types,
  _cffi_globals,
  NULL,  /* no fields */
  _cffi_struct_unions,
  NULL,  /* no enums */
  _cffi_typenames,
  268,  /* num_globals */
  6,  /* num_struct_unions */
  0,  /* num_enums */
  8,  /* num_typenames */
  NULL,  /* no includes */
  327,  /* num_types */
  0,  /* flags */
};

#ifdef __GNUC__
#  pragma GCC visibility push(default)  /* for -fvisibility= */
#endif

#ifdef PYPY_VERSION
PyMODINIT_FUNC
_cffi_pypyinit__sqlite3_cffi(const void *p[])
{
    p[0] = (const void *)0x2601;
    p[1] = &_cffi_type_context;
#if PY_MAJOR_VERSION >= 3
    return NULL;
#endif
}
#  ifdef _MSC_VER
     PyMODINIT_FUNC
#  if PY_MAJOR_VERSION >= 3
     PyInit__sqlite3_cffi(void) { return NULL; }
#  else
     init_sqlite3_cffi(void) { }
#  endif
#  endif
#elif PY_MAJOR_VERSION >= 3
PyMODINIT_FUNC
PyInit__sqlite3_cffi(void)
{
  return _cffi_init("_sqlite3_cffi", 0x2601, &_cffi_type_context);
}
#else
PyMODINIT_FUNC
init_sqlite3_cffi(void)
{
  _cffi_init("_sqlite3_cffi", 0x2601, &_cffi_type_context);
}
#endif

#ifdef __GNUC__
#  pragma GCC visibility pop
#endif
