/*
 * Interface wrapper code.
 *
 * Generated by SIP 6.15.1
 *
 * Copyright (c) 2026 Riverbank Computing Limited <info@riverbankcomputing.com>
 * 
 * This file is part of PyQt6.
 * 
 * This file may be used under the terms of the GNU General Public License
 * version 3.0 as published by the Free Software Foundation and appearing in
 * the file LICENSE included in the packaging of this file.  Please review the
 * following information to ensure the GNU General Public License version 3.0
 * requirements will be met: http://www.gnu.org/copyleft/gpl.html.
 * 
 * If you do not wish to use this file under the terms of the GPL version 3.0
 * then you may purchase a commercial license.  For more information contact
 * info@riverbankcomputing.com.
 * 
 * This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
 * WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 */

#include "sipAPIQtCore.h"

#line 26 "/build/pyqt6/src/pyqt6-6.10.2/sip/QtCore/qresource.sip"
#include <qresource.h>
#line 29 "/build/pyqt6/src/pyqt6-6.10.2/build/QtCore/sipQtCoreQResource.cpp"

#line 24 "/build/pyqt6/src/pyqt6-6.10.2/sip/QtCore/qstring.sip"
#include <qstring.h>
#line 33 "/build/pyqt6/src/pyqt6-6.10.2/build/QtCore/sipQtCoreQResource.cpp"
#line 26 "/build/pyqt6/src/pyqt6-6.10.2/sip/QtCore/qlocale.sip"
#include <qlocale.h>
#line 36 "/build/pyqt6/src/pyqt6-6.10.2/build/QtCore/sipQtCoreQResource.cpp"
#line 30 "/build/pyqt6/src/pyqt6-6.10.2/sip/QtCore/qbytearray.sip"
#include <qbytearray.h>
#line 39 "/build/pyqt6/src/pyqt6-6.10.2/build/QtCore/sipQtCoreQResource.cpp"
#line 262 "/build/pyqt6/src/pyqt6-6.10.2/sip/QtCore/qdatetime.sip"
#include <qdatetime.h>
#line 42 "/build/pyqt6/src/pyqt6-6.10.2/build/QtCore/sipQtCoreQResource.cpp"
#line 26 "/build/pyqt6/src/pyqt6-6.10.2/sip/QtCore/qstringlist.sip"
#include <qstringlist.h>
#line 45 "/build/pyqt6/src/pyqt6-6.10.2/build/QtCore/sipQtCoreQResource.cpp"


PyDoc_STRVAR(doc_QResource_absoluteFilePath, "absoluteFilePath(self) -> str");

extern "C" {static PyObject *meth_QResource_absoluteFilePath(PyObject *, PyObject *);}
static PyObject *meth_QResource_absoluteFilePath(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QResource *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QResource, &sipCpp))
        {
            ::QString*sipRes;

            sipRes = new ::QString(sipCpp->absoluteFilePath());

            return sipConvertFromNewType(sipRes, sipType_QString, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QResource, sipName_absoluteFilePath, doc_QResource_absoluteFilePath);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QResource_data, "data(self) -> bytes");

extern "C" {static PyObject *meth_QResource_data(PyObject *, PyObject *);}
static PyObject *meth_QResource_data(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QResource *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QResource, &sipCpp))
        {
            PyObject * sipRes = SIP_NULLPTR;
            int sipIsErr = 0;

#line 35 "/build/pyqt6/src/pyqt6-6.10.2/sip/QtCore/qresource.sip"
        // The data may contain embedded '\0's so set the size explicitly.
        
        if (sipCpp->data())
        {
            if ((sipRes = PyBytes_FromStringAndSize((char *)sipCpp->data(), sipCpp->size())) == NULL)
                sipIsErr = 1;
        }
        else
        {
            Py_INCREF(Py_None);
            sipRes = Py_None;
        }
#line 102 "/build/pyqt6/src/pyqt6-6.10.2/build/QtCore/sipQtCoreQResource.cpp"

            if (sipIsErr)
                return 0;

            return sipRes;
        }
    }

    sipNoMethod(sipParseErr, sipName_QResource, sipName_data, doc_QResource_data);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QResource_fileName, "fileName(self) -> str");

extern "C" {static PyObject *meth_QResource_fileName(PyObject *, PyObject *);}
static PyObject *meth_QResource_fileName(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QResource *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QResource, &sipCpp))
        {
            ::QString*sipRes;

            sipRes = new ::QString(sipCpp->fileName());

            return sipConvertFromNewType(sipRes, sipType_QString, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QResource, sipName_fileName, doc_QResource_fileName);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QResource_isValid, "isValid(self) -> bool");

extern "C" {static PyObject *meth_QResource_isValid(PyObject *, PyObject *);}
static PyObject *meth_QResource_isValid(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QResource *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QResource, &sipCpp))
        {
            bool sipRes;

            sipRes = sipCpp->isValid();

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QResource, sipName_isValid, doc_QResource_isValid);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QResource_locale, "locale(self) -> QLocale");

extern "C" {static PyObject *meth_QResource_locale(PyObject *, PyObject *);}
static PyObject *meth_QResource_locale(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QResource *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QResource, &sipCpp))
        {
            ::QLocale*sipRes;

            sipRes = new ::QLocale(sipCpp->locale());

            return sipConvertFromNewType(sipRes, sipType_QLocale, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QResource, sipName_locale, doc_QResource_locale);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QResource_setFileName, "setFileName(self, file: str|None)");

extern "C" {static PyObject *meth_QResource_setFileName(PyObject *, PyObject *);}
static PyObject *meth_QResource_setFileName(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QString* a0;
        int a0State = 0;
        ::QResource *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BJ1", &sipSelf, sipType_QResource, &sipCpp, sipType_QString, &a0, &a0State))
        {
            sipCpp->setFileName(*a0);
            sipReleaseType(const_cast< ::QString *>(a0), sipType_QString, a0State);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QResource, sipName_setFileName, doc_QResource_setFileName);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QResource_setLocale, "setLocale(self, locale: QLocale)");

extern "C" {static PyObject *meth_QResource_setLocale(PyObject *, PyObject *);}
static PyObject *meth_QResource_setLocale(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QLocale* a0;
        ::QResource *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BJ9", &sipSelf, sipType_QResource, &sipCpp, sipType_QLocale, &a0))
        {
            sipCpp->setLocale(*a0);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QResource, sipName_setLocale, doc_QResource_setLocale);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QResource_size, "size(self) -> int");

extern "C" {static PyObject *meth_QResource_size(PyObject *, PyObject *);}
static PyObject *meth_QResource_size(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QResource *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QResource, &sipCpp))
        {
            ::qint64 sipRes;

            sipRes = sipCpp->size();

            return PyLong_FromLongLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QResource, sipName_size, doc_QResource_size);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QResource_registerResource, "registerResource(rccFileName: str|None, mapRoot: str|None = '') -> bool");

extern "C" {static PyObject *meth_QResource_registerResource(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_QResource_registerResource(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QString* a0;
        int a0State = 0;
        const ::QString& a1def = QString();
        const ::QString* a1 = &a1def;
        int a1State = 0;

        static const char *sipKwdList[] = {
            SIP_NULLPTR,
            sipName_mapRoot,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "CJ1|J1", &sipSelf, sipType_QString, &a0, &a0State, sipType_QString, &a1, &a1State))
        {
            bool sipRes;

            sipRes = ::QResource::registerResource(*a0, *a1);
            sipReleaseType(const_cast< ::QString *>(a0), sipType_QString, a0State);
            sipReleaseType(const_cast< ::QString *>(a1), sipType_QString, a1State);

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QResource, sipName_registerResource, doc_QResource_registerResource);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QResource_registerResourceData, "registerResourceData(rccData: bytes, mapRoot: str|None = '') -> bool");

extern "C" {static PyObject *meth_QResource_registerResourceData(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_QResource_registerResourceData(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::uchar* a0;
        const ::QString& a1def = QString();
        const ::QString* a1 = &a1def;
        int a1State = 0;

        static const char *sipKwdList[] = {
            SIP_NULLPTR,
            sipName_mapRoot,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "Cs|J1", &sipSelf, &a0, sipType_QString, &a1, &a1State))
        {
            bool sipRes;

            sipRes = ::QResource::registerResource(a0, *a1);
            sipReleaseType(const_cast< ::QString *>(a1), sipType_QString, a1State);

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QResource, sipName_registerResourceData, doc_QResource_registerResourceData);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QResource_unregisterResource, "unregisterResource(rccFileName: str|None, mapRoot: str|None = '') -> bool");

extern "C" {static PyObject *meth_QResource_unregisterResource(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_QResource_unregisterResource(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QString* a0;
        int a0State = 0;
        const ::QString& a1def = QString();
        const ::QString* a1 = &a1def;
        int a1State = 0;

        static const char *sipKwdList[] = {
            SIP_NULLPTR,
            sipName_mapRoot,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "CJ1|J1", &sipSelf, sipType_QString, &a0, &a0State, sipType_QString, &a1, &a1State))
        {
            bool sipRes;

            sipRes = ::QResource::unregisterResource(*a0, *a1);
            sipReleaseType(const_cast< ::QString *>(a0), sipType_QString, a0State);
            sipReleaseType(const_cast< ::QString *>(a1), sipType_QString, a1State);

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QResource, sipName_unregisterResource, doc_QResource_unregisterResource);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QResource_unregisterResourceData, "unregisterResourceData(rccData: bytes, mapRoot: str|None = '') -> bool");

extern "C" {static PyObject *meth_QResource_unregisterResourceData(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_QResource_unregisterResourceData(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::uchar* a0;
        const ::QString& a1def = QString();
        const ::QString* a1 = &a1def;
        int a1State = 0;

        static const char *sipKwdList[] = {
            SIP_NULLPTR,
            sipName_mapRoot,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "Cs|J1", &sipSelf, &a0, sipType_QString, &a1, &a1State))
        {
            bool sipRes;

            sipRes = ::QResource::unregisterResource(a0, *a1);
            sipReleaseType(const_cast< ::QString *>(a1), sipType_QString, a1State);

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QResource, sipName_unregisterResourceData, doc_QResource_unregisterResourceData);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QResource_children, "children(self) -> list[str]");

extern "C" {static PyObject *meth_QResource_children(PyObject *, PyObject *);}
static PyObject *meth_QResource_children(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QResource *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "p", &sipSelf, sipType_QResource, &sipCpp))
        {
            ::QStringList*sipRes;

            sipRes = new ::QStringList(sipCpp->children());

            return sipConvertFromNewType(sipRes, sipType_QStringList, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QResource, sipName_children, doc_QResource_children);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QResource_isDir, "isDir(self) -> bool");

extern "C" {static PyObject *meth_QResource_isDir(PyObject *, PyObject *);}
static PyObject *meth_QResource_isDir(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QResource *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "p", &sipSelf, sipType_QResource, &sipCpp))
        {
            bool sipRes;

            sipRes = sipCpp->isDir();

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QResource, sipName_isDir, doc_QResource_isDir);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QResource_isFile, "isFile(self) -> bool");

extern "C" {static PyObject *meth_QResource_isFile(PyObject *, PyObject *);}
static PyObject *meth_QResource_isFile(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QResource *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "p", &sipSelf, sipType_QResource, &sipCpp))
        {
            bool sipRes;

            sipRes = sipCpp->isFile();

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QResource, sipName_isFile, doc_QResource_isFile);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QResource_lastModified, "lastModified(self) -> QDateTime");

extern "C" {static PyObject *meth_QResource_lastModified(PyObject *, PyObject *);}
static PyObject *meth_QResource_lastModified(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QResource *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QResource, &sipCpp))
        {
            ::QDateTime*sipRes;

            sipRes = new ::QDateTime(sipCpp->lastModified());

            return sipConvertFromNewType(sipRes, sipType_QDateTime, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QResource, sipName_lastModified, doc_QResource_lastModified);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QResource_compressionAlgorithm, "compressionAlgorithm(self) -> QResource.Compression");

extern "C" {static PyObject *meth_QResource_compressionAlgorithm(PyObject *, PyObject *);}
static PyObject *meth_QResource_compressionAlgorithm(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QResource *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QResource, &sipCpp))
        {
            ::QResource::Compression sipRes;

            sipRes = sipCpp->compressionAlgorithm();

            return sipConvertFromEnum(static_cast<int>(sipRes), sipType_QResource_Compression);
        }
    }

    sipNoMethod(sipParseErr, sipName_QResource, sipName_compressionAlgorithm, doc_QResource_compressionAlgorithm);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QResource_uncompressedSize, "uncompressedSize(self) -> int");

extern "C" {static PyObject *meth_QResource_uncompressedSize(PyObject *, PyObject *);}
static PyObject *meth_QResource_uncompressedSize(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QResource *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QResource, &sipCpp))
        {
            ::qint64 sipRes;

            sipRes = sipCpp->uncompressedSize();

            return PyLong_FromLongLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QResource, sipName_uncompressedSize, doc_QResource_uncompressedSize);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QResource_uncompressedData, "uncompressedData(self) -> QByteArray");

extern "C" {static PyObject *meth_QResource_uncompressedData(PyObject *, PyObject *);}
static PyObject *meth_QResource_uncompressedData(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QResource *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QResource, &sipCpp))
        {
            ::QByteArray*sipRes;

            sipRes = new ::QByteArray(sipCpp->uncompressedData());

            return sipConvertFromNewType(sipRes, sipType_QByteArray, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QResource, sipName_uncompressedData, doc_QResource_uncompressedData);

    return SIP_NULLPTR;
}


/* Call the instance's destructor. */
extern "C" {static void release_QResource(void *, int);}
static void release_QResource(void *sipCppV, int)
{
    delete reinterpret_cast< ::QResource *>(sipCppV);
}


extern "C" {static void *array_QResource(Py_ssize_t);}
static void *array_QResource(Py_ssize_t sipNrElem)
{
    return new ::QResource[sipNrElem];
}


extern "C" {static void array_delete_QResource(void *);}
static void array_delete_QResource(void *sipCpp)
{
    delete[] reinterpret_cast< ::QResource *>(sipCpp);
}


extern "C" {static void dealloc_QResource(sipSimpleWrapper *);}
static void dealloc_QResource(sipSimpleWrapper *sipSelf)
{
    if (sipIsOwnedByPython(sipSelf))
    {
        release_QResource(sipGetAddress(sipSelf), 0);
    }
}


extern "C" {static void *init_type_QResource(sipSimpleWrapper *, PyObject *, PyObject *, PyObject **, PyObject **, PyObject **);}
static void *init_type_QResource(sipSimpleWrapper *, PyObject *sipArgs, PyObject *sipKwds, PyObject **sipUnused, PyObject **, PyObject **sipParseErr)
{
    ::QResource *sipCpp = SIP_NULLPTR;

    {
        const ::QString& a0def = QString();
        const ::QString* a0 = &a0def;
        int a0State = 0;
        const ::QLocale& a1def = QLocale();
        const ::QLocale* a1 = &a1def;

        static const char *sipKwdList[] = {
            sipName_fileName,
            sipName_locale,
        };

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, sipKwdList, sipUnused, "|J1J9", sipType_QString, &a0, &a0State, sipType_QLocale, &a1))
        {
            sipCpp = new ::QResource(*a0, *a1);
            sipReleaseType(const_cast< ::QString *>(a0), sipType_QString, a0State);

            return sipCpp;
        }
    }

    return SIP_NULLPTR;
}


static PyMethodDef methods_QResource[] = {
    {sipName_absoluteFilePath, meth_QResource_absoluteFilePath, METH_VARARGS, doc_QResource_absoluteFilePath},
    {sipName_children, meth_QResource_children, METH_VARARGS, doc_QResource_children},
    {sipName_compressionAlgorithm, meth_QResource_compressionAlgorithm, METH_VARARGS, doc_QResource_compressionAlgorithm},
    {sipName_data, meth_QResource_data, METH_VARARGS, doc_QResource_data},
    {sipName_fileName, meth_QResource_fileName, METH_VARARGS, doc_QResource_fileName},
    {sipName_isDir, meth_QResource_isDir, METH_VARARGS, doc_QResource_isDir},
    {sipName_isFile, meth_QResource_isFile, METH_VARARGS, doc_QResource_isFile},
    {sipName_isValid, meth_QResource_isValid, METH_VARARGS, doc_QResource_isValid},
    {sipName_lastModified, meth_QResource_lastModified, METH_VARARGS, doc_QResource_lastModified},
    {sipName_locale, meth_QResource_locale, METH_VARARGS, doc_QResource_locale},
    {sipName_registerResource, SIP_MLMETH_CAST(meth_QResource_registerResource), METH_VARARGS|METH_KEYWORDS, doc_QResource_registerResource},
    {sipName_registerResourceData, SIP_MLMETH_CAST(meth_QResource_registerResourceData), METH_VARARGS|METH_KEYWORDS, doc_QResource_registerResourceData},
    {sipName_setFileName, meth_QResource_setFileName, METH_VARARGS, doc_QResource_setFileName},
    {sipName_setLocale, meth_QResource_setLocale, METH_VARARGS, doc_QResource_setLocale},
    {sipName_size, meth_QResource_size, METH_VARARGS, doc_QResource_size},
    {sipName_uncompressedData, meth_QResource_uncompressedData, METH_VARARGS, doc_QResource_uncompressedData},
    {sipName_uncompressedSize, meth_QResource_uncompressedSize, METH_VARARGS, doc_QResource_uncompressedSize},
    {sipName_unregisterResource, SIP_MLMETH_CAST(meth_QResource_unregisterResource), METH_VARARGS|METH_KEYWORDS, doc_QResource_unregisterResource},
    {sipName_unregisterResourceData, SIP_MLMETH_CAST(meth_QResource_unregisterResourceData), METH_VARARGS|METH_KEYWORDS, doc_QResource_unregisterResourceData}
};


/* Define the enum members and ints to be added to this type. */
static sipIntInstanceDef intInstances_QResource[] = {
    {sipName_NoCompression, static_cast<int>(::QResource::NoCompression)},
    {sipName_ZlibCompression, static_cast<int>(::QResource::ZlibCompression)},
    {sipName_ZstdCompression, static_cast<int>(::QResource::ZstdCompression)},
    {0, 0}
};

PyDoc_STRVAR(doc_QResource, "\1QResource(fileName: str|None = '', locale: QLocale = QLocale())");


sipClassTypeDef sipTypeDef_QtCore_QResource = {
    {
        SIP_NULLPTR,
        SIP_TYPE_SUPER_INIT|SIP_TYPE_LIMITED_API|SIP_TYPE_CLASS,
        sipNameNr_QResource,
        SIP_NULLPTR,
        SIP_NULLPTR,
    },
    {
        sipNameNr_QResource,
        {0, 0, 1},
        19, methods_QResource,
        0, SIP_NULLPTR,
        {SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, intInstances_QResource, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    },
    doc_QResource,
    -1,
    sipNameNr_PyQt6_sip_simplewrapper,
    SIP_NULLPTR,
    SIP_NULLPTR,
    init_type_QResource,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    dealloc_QResource,
    SIP_NULLPTR,
    array_QResource,
    SIP_NULLPTR,
    release_QResource,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    array_delete_QResource,
    sizeof (::QResource),
};
