// Copyright © 2023-2025 Advanced Micro Devices, Inc.
// SPDX-License-Identifier: MIT

#include "../shim.attn_fwd.h"
#include <aotriton/_internal/triton_kernel.h>
#include <aotriton/_internal/kernel_cluster.h>
#include <aotriton/cpp_tune.h>
#include <string_view>
#ifndef NDEBUG
#include <iostream>
#endif

#define CURRENT_ENTRY_PUBLIC Autotune_attn_fwd__A0__F252

#define ARRAY_SIZE(array)  (sizeof(array) / sizeof(array[0]))

namespace { // Anonymous namespace

using namespace std::literals::string_view_literals;

#if AOTRITON_BUILD_FOR_TUNING
// PSels and Copts in JSON String
static const char* kernel_psels[] = {
  R"xyzw({"PERSISTENT_TYPE": 0, "GRID_CU_MULTIP": 2, "BLOCK_M": 32, "BLOCK_N": 16, "PRE_LOAD_V": true})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 0, "GRID_CU_MULTIP": 2, "BLOCK_M": 32, "BLOCK_N": 16, "PRE_LOAD_V": true})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 0, "GRID_CU_MULTIP": 2, "BLOCK_M": 32, "BLOCK_N": 16, "PRE_LOAD_V": true})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 0, "GRID_CU_MULTIP": 2, "BLOCK_M": 64, "BLOCK_N": 32, "PRE_LOAD_V": false})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 0, "GRID_CU_MULTIP": 2, "BLOCK_M": 64, "BLOCK_N": 32, "PRE_LOAD_V": false})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 0, "GRID_CU_MULTIP": 2, "BLOCK_M": 64, "BLOCK_N": 32, "PRE_LOAD_V": false})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 0, "GRID_CU_MULTIP": 2, "BLOCK_M": 64, "BLOCK_N": 32, "PRE_LOAD_V": true})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 0, "GRID_CU_MULTIP": 2, "BLOCK_M": 64, "BLOCK_N": 32, "PRE_LOAD_V": true})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 0, "GRID_CU_MULTIP": 2, "BLOCK_M": 64, "BLOCK_N": 32, "PRE_LOAD_V": true})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 0, "GRID_CU_MULTIP": 2, "BLOCK_M": 64, "BLOCK_N": 64, "PRE_LOAD_V": false})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 0, "GRID_CU_MULTIP": 2, "BLOCK_M": 64, "BLOCK_N": 64, "PRE_LOAD_V": true})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 0, "GRID_CU_MULTIP": 2, "BLOCK_M": 64, "BLOCK_N": 64, "PRE_LOAD_V": true})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 0, "GRID_CU_MULTIP": 2, "BLOCK_M": 128, "BLOCK_N": 64, "PRE_LOAD_V": false})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 0, "GRID_CU_MULTIP": 2, "BLOCK_M": 128, "BLOCK_N": 64, "PRE_LOAD_V": false})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 0, "GRID_CU_MULTIP": 2, "BLOCK_M": 128, "BLOCK_N": 64, "PRE_LOAD_V": false})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 0, "GRID_CU_MULTIP": 2, "BLOCK_M": 128, "BLOCK_N": 64, "PRE_LOAD_V": true})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 0, "GRID_CU_MULTIP": 2, "BLOCK_M": 128, "BLOCK_N": 128, "PRE_LOAD_V": true})xyzw"
};
static const char* kernel_copts[] = {
  R"xyzw({"waves_per_eu": 2, "num_warps": 2, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 3, "num_warps": 2, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 4, "num_warps": 2, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 2, "num_warps": 2, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 3, "num_warps": 2, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 4, "num_warps": 4, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 2, "num_warps": 2, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 2, "num_warps": 4, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 3, "num_warps": 2, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 2, "num_warps": 4, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 2, "num_warps": 4, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 3, "num_warps": 4, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 2, "num_warps": 2, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 2, "num_warps": 4, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 3, "num_warps": 4, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 2, "num_warps": 4, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 1, "num_warps": 4, "num_stages": 1})xyzw"
};
#endif

struct PerfFields {
  int16_t BLOCK_M;
    int16_t BLOCK_N;
    int8_t  PERSISTENT_TYPE;
    int8_t  GRID_CU_MULTIP;
    bool    PRE_LOAD_V;
};

static PerfFields image_perf_list [] = {
    { .BLOCK_M = 32, .BLOCK_N = 16, .PERSISTENT_TYPE = 0, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = true },
    { .BLOCK_M = 32, .BLOCK_N = 16, .PERSISTENT_TYPE = 0, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = true },
    { .BLOCK_M = 32, .BLOCK_N = 16, .PERSISTENT_TYPE = 0, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = true },
    { .BLOCK_M = 64, .BLOCK_N = 32, .PERSISTENT_TYPE = 0, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = false },
    { .BLOCK_M = 64, .BLOCK_N = 32, .PERSISTENT_TYPE = 0, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = false },
    { .BLOCK_M = 64, .BLOCK_N = 32, .PERSISTENT_TYPE = 0, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = false },
    { .BLOCK_M = 64, .BLOCK_N = 32, .PERSISTENT_TYPE = 0, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = true },
    { .BLOCK_M = 64, .BLOCK_N = 32, .PERSISTENT_TYPE = 0, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = true },
    { .BLOCK_M = 64, .BLOCK_N = 32, .PERSISTENT_TYPE = 0, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = true },
    { .BLOCK_M = 64, .BLOCK_N = 64, .PERSISTENT_TYPE = 0, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = false },
    { .BLOCK_M = 64, .BLOCK_N = 64, .PERSISTENT_TYPE = 0, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = true },
    { .BLOCK_M = 64, .BLOCK_N = 64, .PERSISTENT_TYPE = 0, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = true },
    { .BLOCK_M = 128, .BLOCK_N = 64, .PERSISTENT_TYPE = 0, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = false },
    { .BLOCK_M = 128, .BLOCK_N = 64, .PERSISTENT_TYPE = 0, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = false },
    { .BLOCK_M = 128, .BLOCK_N = 64, .PERSISTENT_TYPE = 0, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = false },
    { .BLOCK_M = 128, .BLOCK_N = 64, .PERSISTENT_TYPE = 0, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = true },
    { .BLOCK_M = 128, .BLOCK_N = 128, .PERSISTENT_TYPE = 0, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = true }
};

// u8R generates char8_t which is poorly supported almost everywhere.
constexpr std::string_view PACKAGE_PATH { R"xyzw(amd-gfx950/flash/attn_fwd/FONLY__＊bf16@16_64_T_T_0_0___gfx950)xyzw" };
constexpr std::string_view FUNC_NAME { R"xyzw(＊bf16@16_64_T_T_0_0)xyzw" };
constexpr std::string_view ARCH_NAME { R"xyzw(gfx950)xyzw" };

// Checksum can be confirmed with `echo -n '<string>' | b2sum -l 64`
// For example:
//   $ echo -n 'amd-gfx110x/flash/attn_fwd/FONLY__^bf16@16,128,False,False,0,0___gfx1100__P__32_32_0_2_False__CO__wave3_warp2_stg1-Gpu-gfx1100' | b2sum -l 64
//   c4b51ee645d79580  -
static AOTRITON_NS::TritonKernelCompactMeta meta_list[] = {
    { 0x3250b2c0u, 0x1b13e711u, 33, 65 }, // 3250b2c01b13e711 = b2sum -l 64 <<< amd-gfx950/flash/attn_fwd/FONLY__＊bf16@16_64_T_T_0_0___gfx950__P__0_2_32_16_True__CO__wave2_warp2_stg1--Arch_gfx950
    { 0xf50802acu, 0x168840efu, 33, 82 }, // f50802ac168840ef = b2sum -l 64 <<< amd-gfx950/flash/attn_fwd/FONLY__＊bf16@16_64_T_T_0_0___gfx950__P__0_2_32_16_True__CO__wave3_warp2_stg1--Arch_gfx950
    { 0xf9441494u, 0xf47ce9c5u, 33, 16 }, // f9441494f47ce9c5 = b2sum -l 64 <<< amd-gfx950/flash/attn_fwd/FONLY__＊bf16@16_64_T_T_0_0___gfx950__P__0_2_32_16_True__CO__wave4_warp2_stg1--Arch_gfx950
    { 0x4a5565d0u, 0xb4a47dc6u, 99, 65 }, // 4a5565d0b4a47dc6 = b2sum -l 64 <<< amd-gfx950/flash/attn_fwd/FONLY__＊bf16@16_64_T_T_0_0___gfx950__P__0_2_64_32_False__CO__wave2_warp2_stg1--Arch_gfx950
    { 0xc8b9dee9u, 0xd8e54f21u, 99, 82 }, // c8b9dee9d8e54f21 = b2sum -l 64 <<< amd-gfx950/flash/attn_fwd/FONLY__＊bf16@16_64_T_T_0_0___gfx950__P__0_2_64_32_False__CO__wave3_warp2_stg1--Arch_gfx950
    { 0x476796e3u, 0xb3a01691u, 99, 195 }, // 476796e3b3a01691 = b2sum -l 64 <<< amd-gfx950/flash/attn_fwd/FONLY__＊bf16@16_64_T_T_0_0___gfx950__P__0_2_64_32_False__CO__wave4_warp4_stg1--Arch_gfx950
    { 0xe6fe8394u, 0x3d6c6c23u, 115, 65 }, // e6fe83943d6c6c23 = b2sum -l 64 <<< amd-gfx950/flash/attn_fwd/FONLY__＊bf16@16_64_T_T_0_0___gfx950__P__0_2_64_32_True__CO__wave2_warp2_stg1--Arch_gfx950
    { 0x4aad81bcu, 0xd7c3546fu, 115, 178 }, // 4aad81bcd7c3546f = b2sum -l 64 <<< amd-gfx950/flash/attn_fwd/FONLY__＊bf16@16_64_T_T_0_0___gfx950__P__0_2_64_32_True__CO__wave2_warp4_stg1--Arch_gfx950
    { 0xb4834090u, 0x92f0cd28u, 115, 82 }, // b483409092f0cd28 = b2sum -l 64 <<< amd-gfx950/flash/attn_fwd/FONLY__＊bf16@16_64_T_T_0_0___gfx950__P__0_2_64_32_True__CO__wave3_warp2_stg1--Arch_gfx950
    { 0x4a7a8133u, 0x7199c1adu, 130, 178 }, // 4a7a81337199c1ad = b2sum -l 64 <<< amd-gfx950/flash/attn_fwd/FONLY__＊bf16@16_64_T_T_0_0___gfx950__P__0_2_64_64_False__CO__wave2_warp4_stg1--Arch_gfx950
    { 0x030547ceu, 0x923f2021u, 163, 178 }, // 030547ce923f2021 = b2sum -l 64 <<< amd-gfx950/flash/attn_fwd/FONLY__＊bf16@16_64_T_T_0_0___gfx950__P__0_2_64_64_True__CO__wave2_warp4_stg1--Arch_gfx950
    { 0x131e1dc1u, 0x2a9febafu, 163, 146 }, // 131e1dc12a9febaf = b2sum -l 64 <<< amd-gfx950/flash/attn_fwd/FONLY__＊bf16@16_64_T_T_0_0___gfx950__P__0_2_64_64_True__CO__wave3_warp4_stg1--Arch_gfx950
    { 0xa43df5d7u, 0x912db495u, 212, 65 }, // a43df5d7912db495 = b2sum -l 64 <<< amd-gfx950/flash/attn_fwd/FONLY__＊bf16@16_64_T_T_0_0___gfx950__P__0_2_128_64_False__CO__wave2_warp2_stg1--Arch_gfx950
    { 0xedc78524u, 0x0064fe96u, 212, 178 }, // edc785240064fe96 = b2sum -l 64 <<< amd-gfx950/flash/attn_fwd/FONLY__＊bf16@16_64_T_T_0_0___gfx950__P__0_2_128_64_False__CO__wave2_warp4_stg1--Arch_gfx950
    { 0x346d5ab5u, 0x3bb10071u, 212, 146 }, // 346d5ab53bb10071 = b2sum -l 64 <<< amd-gfx950/flash/attn_fwd/FONLY__＊bf16@16_64_T_T_0_0___gfx950__P__0_2_128_64_False__CO__wave3_warp4_stg1--Arch_gfx950
    { 0x1525fc9bu, 0xf83646d4u, 229, 178 }, // 1525fc9bf83646d4 = b2sum -l 64 <<< amd-gfx950/flash/attn_fwd/FONLY__＊bf16@16_64_T_T_0_0___gfx950__P__0_2_128_64_True__CO__wave2_warp4_stg1--Arch_gfx950
    { 0x6db2a729u, 0xa9b84542u, 280, 263 }, // 6db2a729a9b84542 = b2sum -l 64 <<< amd-gfx950/flash/attn_fwd/FONLY__＊bf16@16_64_T_T_0_0___gfx950__P__0_2_128_128_True__CO__wave1_warp4_stg1--Arch_gfx950
};

static constexpr int kTotalNumKernels = ARRAY_SIZE(meta_list);

using AOTRITON_NS::v3::flash::autotune::attn_fwd_packed_string;

static AOTRITON_NS::TritonKernelCluster<kTotalNumKernels>
kernel_cluster(meta_list,
               attn_fwd_packed_string);

static int8_t lut[1][10][10] =
{
// GPU gfx950_mod0
{{ 7, 2,10,10,10,10, 9,11,11,11},
 { 2, 5, 9, 9, 9,11, 9,10,11,11},
 { 1,10,13, 6, 6, 6, 8, 6, 8, 8},
 { 1, 0, 2, 1,13,15,15,15,16,16},
 { 6, 1, 1, 6, 3, 3,13,15,13,13},
 { 0, 0, 0, 6, 6,13,13,13,13,13},
 { 1, 1, 2, 8, 4, 4,13,13,13,14},
 { 2, 0, 0, 8, 4, 4,13,13,13,14},
 { 8, 0, 8, 8, 8, 4,13,13,13,14},
 { 8, 1, 8, 8, 4, 4,13,13,13,12}}
// End of GPU gfx950_mod0
}
;

}; // End of anonymous namespace

namespace AOTRITON_NS::v3::flash::autotune {

// using AOTRITON_NS::v2::flash::AttnFwdContext;

void CURRENT_ENTRY_PUBLIC(AttnFwdContext& context, int mod_number) {
#if AOTRITON_BUILD_FOR_TUNING
    int preferred_index = context._has_preferred_kernel;
    context._total_number_of_kernels = kTotalNumKernels;
#ifndef NDEBUG
    std::cerr << "Autotune_attn_fwd__A0__F252 "
              << "kTotalNumKernels = " << kTotalNumKernels << " "
              << "_has_preferred_kernel = " << preferred_index << " "
              << std::endl;
#endif
    if (preferred_index != -1) {
        if (preferred_index >= kTotalNumKernels)
            return ;
        context.kernel_on_device = kernel_cluster.get(preferred_index);
        context.pp_args_index = 9;
        context.package_path = PACKAGE_PATH;
        context.func_name = FUNC_NAME;
        context.arch_name = ARCH_NAME;
        context._preferred_kernel_psels = kernel_psels[preferred_index];
        context._preferred_kernel_copts = kernel_copts[preferred_index];
        const auto& perf = image_perf_list[preferred_index];
        context.PERSISTENT_TYPE = perf.PERSISTENT_TYPE;
    context.GRID_CU_MULTIP = perf.GRID_CU_MULTIP;
    context.BLOCK_M = perf.BLOCK_M;
    context.BLOCK_N = perf.BLOCK_N;
    context.PRE_LOAD_V = perf.PRE_LOAD_V;
        return ;
    }
#endif
    auto kernel_index = attn_fwd__lut_lambda__0(*context.params, mod_number, lut);
    if (kernel_index < 0) {
      return ;
    }
    context.kernel_on_device = kernel_cluster.get(kernel_index);
    context.pp_args_index = 9;
    context.package_path = PACKAGE_PATH;
    context.func_name = FUNC_NAME;
    context.arch_name = ARCH_NAME;
#ifndef NDEBUG
    std::cerr << __FILE__ << " kernel_index = " << int(kernel_index) << std::endl;
#endif
    const auto& perf = image_perf_list[kernel_index];
    context.PERSISTENT_TYPE = perf.PERSISTENT_TYPE;
    context.GRID_CU_MULTIP = perf.GRID_CU_MULTIP;
    context.BLOCK_M = perf.BLOCK_M;
    context.BLOCK_N = perf.BLOCK_N;
    context.PRE_LOAD_V = perf.PRE_LOAD_V;
}

#undef CURRENT_ENTRY_PUBLIC
}

// Human-readable Signature 
// Q = "*bf16:16"
// B = 0
// A = 0
// Sm_scale = "fp32"
// L = "*fp32:16"
// Q_descale = 0
// stride_bz = 0
// stride_az = 0
// Num_head_q = "i32"
// cu_seqlens_q = "*i32:16"
// BLOCK_DMODEL = 64
// Head_dim = "i32"
// PADDED_HEAD = True
// ENABLE_DROPOUT = True
// dropout_p = "fp32"
// philox_seed_ptr = "*u64"
// philox_offset1 = "*u64"
// philox_offset2 = "u64"
// RETURN_ENCODED_SOFTMAX = False
// encoded_softmax = 0
// CAUSAL_TYPE = 0
// Window_left = 0
// BIAS_TYPE = 0
// USE_ALIBI = False
// INT8 = False
// persistent_atomic_counter = 0
// Num_CU = "i32"

// vim: set fileencoding=utf-8

