// Copyright © 2025 Advanced Micro Devices, Inc.
// SPDX-License-Identifier: MIT

// clang-format off
#include "iface.op_attn_fwd.h"
#include <aotriton/util.h>
#include <tuple>
#include "shim.debug_simulate_encoded_softmax.h"
#include "shim.attn_fwd.h"

namespace AOTRITON_NS::v3::flash {

int64_t OpAttnFwdContext::godel_number() const
{
    int64_t sum = 0;
    const auto& args = *params;
    {
        int64_t number = 0;
        if (args.Q->dtype() == DType::kFloat16) number = 0 ;
        if (args.Q->dtype() == DType::kBFloat16) number = 1 ;
        if (args.Q->dtype() == DType::kFloat32) number = 2 ;
        sum += number * 192;
    }
    {
        int64_t number = 0;
        if (args.BLOCK_DMODEL == 16) number = 0 ;
        if (args.BLOCK_DMODEL == 32) number = 1 ;
        if (args.BLOCK_DMODEL == 48) number = 2 ;
        if (args.BLOCK_DMODEL == 64) number = 3 ;
        if (args.BLOCK_DMODEL == 80) number = 4 ;
        if (args.BLOCK_DMODEL == 96) number = 5 ;
        if (args.BLOCK_DMODEL == 128) number = 6 ;
        if (args.BLOCK_DMODEL == 160) number = 7 ;
        if (args.BLOCK_DMODEL == 192) number = 8 ;
        if (args.BLOCK_DMODEL == 224) number = 9 ;
        if (args.BLOCK_DMODEL == 256) number = 10 ;
        if (args.BLOCK_DMODEL == 512) number = 11 ;
        sum += number * 16;
    }
    {
        int64_t number = 0;
        if (args.PADDED_HEAD == false) number = 0 ;
        if (args.PADDED_HEAD == true) number = 1 ;
        sum += number * 8;
    }
    {
        int64_t number = 0;
        if (args.ENABLE_DROPOUT == false) number = 0 ;
        if (args.ENABLE_DROPOUT == true) number = 1 ;
        sum += number * 4;
    }
    {
        int64_t number = 0;
        if (args.CAUSAL_TYPE == 0) number = 0 ;
        if (args.CAUSAL_TYPE == 3) number = 1 ;
        sum += number * 2;
    }
    {
        int64_t number = 0;
        if (args.BIAS_TYPE == 0) number = 0 ;
        if (args.BIAS_TYPE == 1) number = 1 ;
        sum += number * 1;
    }

    return sum;
}

hipError_t
OpAttnFwdContext::lookup_optimal(Gpu gpu) {
    auto [arch_number, mod_number] = get_archmod_number(gpu);
    if (arch_number < 0) {
        return hipErrorNoBinaryForGpu;
    }
    backend_index = BackendEnum::None;
    auto tune_func = optune_table[arch_number][godel_number()];
    if (!tune_func)
        return hipErrorProfilerNotInitialized;
    tune_func(*this, mod_number);
    // Operator's capability is union of all backends
    // Hence there must be a backend that handles the inputs
    return hipSuccess;
}

std::tuple<int, int>
OpAttnFwdContext::get_archmod_number(Gpu gpu) {
    if (gpu == GPU_AMD_ARCH_GFX950_MOD0) return { 0, 0 };
    if (gpu == GPU_AMD_ARCH_GFX1151_MOD0) return { 1, 0 };
    if (gpu == GPU_AMD_ARCH_GFX1150_MOD0) return { 2, 0 };
    if (gpu == GPU_AMD_ARCH_GFX1201_MOD0) return { 3, 0 };
    if (gpu == GPU_AMD_ARCH_GFX1200_MOD0) return { 4, 0 };
    // TODO: print warning about tuning for this GPU mod is not built.
    // Note: if some mod does not have tuning info in the database at all, the
    //       getGpuFromStream should not return that mod from beginning.
    return std::make_tuple(-1, 0);
}

hipError_t
OpAttnFwdContext::launch(Gpu gpu, hipStream_t stream) const {
    if (backend_index < 0) {
        return hipErrorPriorLaunchFailure;
    }
    auto ret = launcher_table[backend_index](*this, gpu, stream);
    // It is possible that the optimal backend does not support certain inputs
    // In this case hipErrorPeerAccessUnsupported will be returned
    if (ret == hipErrorPeerAccessUnsupported) {
        return launcher_table[fallback_backend](*this, gpu, stream);
    }
    return ret;
}

// Launchers are defined in op source file and no need to put them in to
// optune namespace
namespace {
hipError_t launcher_for_kMetro_Triton(const OpAttnFwdContext& context,
                                  Gpu gpu,
                                  hipStream_t stream) {
    if (true) {
        AttnFwdContext bcontext;
        bcontext.params = context.params;
        hipError_t err;
        err = bcontext.lookup_optimal(gpu);
        if (err != hipSuccess)
            return err;
        err = bcontext.launch(stream);
        if (err != hipSuccess)
            return err;
    }

    if (context.params->encoded_softmax ->data_ptr() != nullptr) {
        DebugSimulateEncodedSoftmaxContext bcontext;
        bcontext.params = context.params;
        hipError_t err;
        err = bcontext.lookup_optimal(gpu);
        if (err != hipSuccess)
            return err;
        err = bcontext.launch(stream);
        if (err != hipSuccess)
            return err;
    }

return hipSuccess;
}

}

OpAttnFwdContext::BackendLauncher
OpAttnFwdContext::launcher_table[ BackendEnum::Max ] = {
    &launcher_for_kMetro_Triton
};

namespace optune {

// TODO: list_of_deduplicated_lut_functions

} // namespace autotune

// When Functional's LUT is uniform or empty
namespace {
void optune_op_attn_fwd__Trivial_kMetro_Triton(OpAttnFwdContext& context, int) {
    context.backend_index = OpAttnFwdContext::BackendEnum::kMetro_Triton;
}

}

OpAttnFwdContext::OpTuneTableEntry
OpAttnFwdContext::optune_table[][ 576 ] = {
    {
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
    },
    {
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
    },
    {
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
    },
    {
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
    },
    {
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
        &optune_op_attn_fwd__Trivial_kMetro_Triton,
    },
};

}

// vim: set fileencoding=utf-8

