// components/visitedlink/common/visitedlink.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "components/visitedlink/common/visitedlink.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_conversion_helper.h"
#include "base/trace_event/traced_value.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"

#include "components/visitedlink/common/visitedlink.mojom-params-data.h"
#include "components/visitedlink/common/visitedlink.mojom-shared-message-ids.h"

#include "components/visitedlink/common/visitedlink.mojom-import-headers.h"


#ifndef COMPONENTS_VISITEDLINK_COMMON_VISITEDLINK_MOJOM_JUMBO_H_
#define COMPONENTS_VISITEDLINK_COMMON_VISITEDLINK_MOJOM_JUMBO_H_
#endif
namespace visitedlink {
namespace mojom {
const char VisitedLinkNotificationSink::Name_[] = "visitedlink.mojom.VisitedLinkNotificationSink";

VisitedLinkNotificationSinkProxy::VisitedLinkNotificationSinkProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void VisitedLinkNotificationSinkProxy::UpdateVisitedLinks(
    ::base::ReadOnlySharedMemoryRegion in_table_region) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "visitedlink::mojom::VisitedLinkNotificationSink::UpdateVisitedLinks", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("table_region", base::trace_event::ValueToString(in_table_region, "<value of type ::base::ReadOnlySharedMemoryRegion>"));
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kVisitedLinkNotificationSink_UpdateVisitedLinks_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::visitedlink::mojom::internal::VisitedLinkNotificationSink_UpdateVisitedLinks_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->table_region)::BaseType::BufferWriter
      table_region_writer;
  mojo::internal::Serialize<::mojo_base::mojom::ReadOnlySharedMemoryRegionDataView>(
      in_table_region, buffer, &table_region_writer, &serialization_context);
  params->table_region.Set(
      table_region_writer.is_null() ? nullptr : table_region_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->table_region.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null table_region in VisitedLinkNotificationSink.UpdateVisitedLinks request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(VisitedLinkNotificationSink::Name_);
  message.set_method_name("UpdateVisitedLinks");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void VisitedLinkNotificationSinkProxy::AddVisitedLinks(
    const std::vector<uint64_t>& in_link_hashes) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "visitedlink::mojom::VisitedLinkNotificationSink::AddVisitedLinks", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->BeginArray("link_hashes");
      for (const auto& item0 : in_link_hashes) {
        raw_value->AppendString(base::NumberToString(item0));
      }
      raw_value->EndArray();
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kVisitedLinkNotificationSink_AddVisitedLinks_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::visitedlink::mojom::internal::VisitedLinkNotificationSink_AddVisitedLinks_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->link_hashes)::BaseType::BufferWriter
      link_hashes_writer;
  const mojo::internal::ContainerValidateParams link_hashes_validate_params(
      0, false, nullptr);
  mojo::internal::Serialize<mojo::ArrayDataView<uint64_t>>(
      in_link_hashes, buffer, &link_hashes_writer, &link_hashes_validate_params,
      &serialization_context);
  params->link_hashes.Set(
      link_hashes_writer.is_null() ? nullptr : link_hashes_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->link_hashes.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null link_hashes in VisitedLinkNotificationSink.AddVisitedLinks request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(VisitedLinkNotificationSink::Name_);
  message.set_method_name("AddVisitedLinks");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void VisitedLinkNotificationSinkProxy::ResetVisitedLinks(
    bool in_invalidate_cached_hashes) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "visitedlink::mojom::VisitedLinkNotificationSink::ResetVisitedLinks", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetBoolean("invalidate_cached_hashes", in_invalidate_cached_hashes);
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kVisitedLinkNotificationSink_ResetVisitedLinks_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::visitedlink::mojom::internal::VisitedLinkNotificationSink_ResetVisitedLinks_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  params->invalidate_cached_hashes = in_invalidate_cached_hashes;
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(VisitedLinkNotificationSink::Name_);
  message.set_method_name("ResetVisitedLinks");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

// static
bool VisitedLinkNotificationSinkStubDispatch::Accept(
    VisitedLinkNotificationSink* impl,
    mojo::Message* message) {
  mojo::internal::MessageDispatchContext dispatch_context(message);
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  switch (message->header()->name) {
    case internal::kVisitedLinkNotificationSink_UpdateVisitedLinks_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)visitedlink::mojom::VisitedLinkNotificationSink::UpdateVisitedLinks",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)visitedlink::mojom::VisitedLinkNotificationSink::UpdateVisitedLinks");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::VisitedLinkNotificationSink_UpdateVisitedLinks_Params_Data* params =
          reinterpret_cast<internal::VisitedLinkNotificationSink_UpdateVisitedLinks_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::base::ReadOnlySharedMemoryRegion p_table_region{};
      VisitedLinkNotificationSink_UpdateVisitedLinks_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadTableRegion(&p_table_region))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            VisitedLinkNotificationSink::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->UpdateVisitedLinks(
std::move(p_table_region));
      return true;
    }
    case internal::kVisitedLinkNotificationSink_AddVisitedLinks_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)visitedlink::mojom::VisitedLinkNotificationSink::AddVisitedLinks",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)visitedlink::mojom::VisitedLinkNotificationSink::AddVisitedLinks");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::VisitedLinkNotificationSink_AddVisitedLinks_Params_Data* params =
          reinterpret_cast<internal::VisitedLinkNotificationSink_AddVisitedLinks_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      std::vector<uint64_t> p_link_hashes{};
      VisitedLinkNotificationSink_AddVisitedLinks_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadLinkHashes(&p_link_hashes))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            VisitedLinkNotificationSink::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->AddVisitedLinks(
std::move(p_link_hashes));
      return true;
    }
    case internal::kVisitedLinkNotificationSink_ResetVisitedLinks_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)visitedlink::mojom::VisitedLinkNotificationSink::ResetVisitedLinks",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)visitedlink::mojom::VisitedLinkNotificationSink::ResetVisitedLinks");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::VisitedLinkNotificationSink_ResetVisitedLinks_Params_Data* params =
          reinterpret_cast<internal::VisitedLinkNotificationSink_ResetVisitedLinks_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      bool p_invalidate_cached_hashes{};
      VisitedLinkNotificationSink_ResetVisitedLinks_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success)
        p_invalidate_cached_hashes = input_data_view.invalidate_cached_hashes();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            VisitedLinkNotificationSink::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ResetVisitedLinks(
std::move(p_invalidate_cached_hashes));
      return true;
    }
  }
  return false;
}

// static
bool VisitedLinkNotificationSinkStubDispatch::AcceptWithResponder(
    VisitedLinkNotificationSink* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  mojo::internal::MessageDispatchContext dispatch_context(message);
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kVisitedLinkNotificationSink_UpdateVisitedLinks_Name: {
      break;
    }
    case internal::kVisitedLinkNotificationSink_AddVisitedLinks_Name: {
      break;
    }
    case internal::kVisitedLinkNotificationSink_ResetVisitedLinks_Name: {
      break;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kVisitedLinkNotificationSinkValidationInfo[] = {
    {internal::kVisitedLinkNotificationSink_UpdateVisitedLinks_Name,
     {&internal::VisitedLinkNotificationSink_UpdateVisitedLinks_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kVisitedLinkNotificationSink_AddVisitedLinks_Name,
     {&internal::VisitedLinkNotificationSink_AddVisitedLinks_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kVisitedLinkNotificationSink_ResetVisitedLinks_Name,
     {&internal::VisitedLinkNotificationSink_ResetVisitedLinks_Params_Data::Validate,
      nullptr /* no response */}},
};

bool VisitedLinkNotificationSinkRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::visitedlink::mojom::VisitedLinkNotificationSink::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kVisitedLinkNotificationSinkValidationInfo);
}

}  // namespace mojom
}  // namespace visitedlink

namespace mojo {

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif