// This file is generated by TypeBuilder_cpp.template.

// Copyright (c) 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "content/browser/devtools/protocol/log.h"

#include "content/browser/devtools/protocol/protocol.h"

#include "third_party/inspector_protocol/crdtp/cbor.h"
#include "third_party/inspector_protocol/crdtp/find_by_first.h"
#include "third_party/inspector_protocol/crdtp/span.h"

namespace content {
namespace protocol {
namespace Log {

using crdtp::DeserializerState;
using crdtp::ProtocolTypeTraits;

// ------------- Enum values from types.

const char Metainfo::domainName[] = "Log";
const char Metainfo::commandPrefix[] = "Log.";
const char Metainfo::version[] = "1.3";


const char* LogEntry::SourceEnum::Xml = "xml";
const char* LogEntry::SourceEnum::Javascript = "javascript";
const char* LogEntry::SourceEnum::Network = "network";
const char* LogEntry::SourceEnum::Storage = "storage";
const char* LogEntry::SourceEnum::Appcache = "appcache";
const char* LogEntry::SourceEnum::Rendering = "rendering";
const char* LogEntry::SourceEnum::Security = "security";
const char* LogEntry::SourceEnum::Deprecation = "deprecation";
const char* LogEntry::SourceEnum::Worker = "worker";
const char* LogEntry::SourceEnum::Violation = "violation";
const char* LogEntry::SourceEnum::Intervention = "intervention";
const char* LogEntry::SourceEnum::Recommendation = "recommendation";
const char* LogEntry::SourceEnum::Other = "other";

const char* LogEntry::LevelEnum::Verbose = "verbose";
const char* LogEntry::LevelEnum::Info = "info";
const char* LogEntry::LevelEnum::Warning = "warning";
const char* LogEntry::LevelEnum::Error = "error";
CRDTP_BEGIN_DESERIALIZER(LogEntry)
    CRDTP_DESERIALIZE_FIELD_OPT("args", m_args),
    CRDTP_DESERIALIZE_FIELD("level", m_level),
    CRDTP_DESERIALIZE_FIELD_OPT("lineNumber", m_lineNumber),
    CRDTP_DESERIALIZE_FIELD_OPT("networkRequestId", m_networkRequestId),
    CRDTP_DESERIALIZE_FIELD("source", m_source),
    CRDTP_DESERIALIZE_FIELD_OPT("stackTrace", m_stackTrace),
    CRDTP_DESERIALIZE_FIELD("text", m_text),
    CRDTP_DESERIALIZE_FIELD("timestamp", m_timestamp),
    CRDTP_DESERIALIZE_FIELD_OPT("url", m_url),
    CRDTP_DESERIALIZE_FIELD_OPT("workerId", m_workerId),
CRDTP_END_DESERIALIZER()

CRDTP_BEGIN_SERIALIZER(LogEntry)
    CRDTP_SERIALIZE_FIELD("source", m_source);
    CRDTP_SERIALIZE_FIELD("level", m_level);
    CRDTP_SERIALIZE_FIELD("text", m_text);
    CRDTP_SERIALIZE_FIELD("timestamp", m_timestamp);
    CRDTP_SERIALIZE_FIELD("url", m_url);
    CRDTP_SERIALIZE_FIELD("lineNumber", m_lineNumber);
    CRDTP_SERIALIZE_FIELD("stackTrace", m_stackTrace);
    CRDTP_SERIALIZE_FIELD("networkRequestId", m_networkRequestId);
    CRDTP_SERIALIZE_FIELD("workerId", m_workerId);
    CRDTP_SERIALIZE_FIELD("args", m_args);
CRDTP_END_SERIALIZER();


// ------------- Enum values from params.


// ------------- Frontend notifications.

void Frontend::EntryAdded(std::unique_ptr<protocol::Log::LogEntry> entry)
{
    if (!frontend_channel_)
        return;
    crdtp::ObjectSerializer serializer;
    serializer.AddField(crdtp::MakeSpan("entry"), entry);
    frontend_channel_->SendProtocolNotification(crdtp::CreateNotification("Log.entryAdded", serializer.Finish()));
}

void Frontend::flush()
{
    frontend_channel_->FlushProtocolNotifications();
}

void Frontend::sendRawNotification(std::unique_ptr<Serializable> notification)
{
    frontend_channel_->SendProtocolNotification(std::move(notification));
}

// --------------------- Dispatcher.

class DomainDispatcherImpl : public protocol::DomainDispatcher {
public:
    DomainDispatcherImpl(FrontendChannel* frontendChannel, Backend* backend)
        : DomainDispatcher(frontendChannel)
        , m_backend(backend) {}
    ~DomainDispatcherImpl() override { }

    using CallHandler = void (DomainDispatcherImpl::*)(const crdtp::Dispatchable& dispatchable);

    std::function<void(const crdtp::Dispatchable&)> Dispatch(crdtp::span<uint8_t> command_name) override;

    void disable(const crdtp::Dispatchable& dispatchable);
    void enable(const crdtp::Dispatchable& dispatchable);
 protected:
    Backend* m_backend;
};

namespace {
// This helper method with a static map of command methods (instance methods
// of DomainDispatcherImpl declared just above) by their name is used immediately below,
// in the DomainDispatcherImpl::Dispatch method.
DomainDispatcherImpl::CallHandler CommandByName(crdtp::span<uint8_t> command_name) {
  static auto* commands = [](){
    auto* commands = new std::vector<std::pair<crdtp::span<uint8_t>,
                              DomainDispatcherImpl::CallHandler>>{
    {
          crdtp::SpanFrom("disable"),
          &DomainDispatcherImpl::disable
    },
    {
          crdtp::SpanFrom("enable"),
          &DomainDispatcherImpl::enable
    },
    };
    return commands;
  }();
  return crdtp::FindByFirst<DomainDispatcherImpl::CallHandler>(*commands, command_name, nullptr);
}
}  // namespace

std::function<void(const crdtp::Dispatchable&)> DomainDispatcherImpl::Dispatch(crdtp::span<uint8_t> command_name) {
  CallHandler handler = CommandByName(command_name);
  if (!handler) return nullptr;

  return [this, handler](const crdtp::Dispatchable& dispatchable) {
    (this->*handler)(dispatchable);
  };
}


namespace {


}  // namespace

void DomainDispatcherImpl::disable(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.


    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->Disable();
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), crdtp::SpanFrom("Log.disable"), dispatchable.Serialized());
        return;
    }
    if (weak->get())
        weak->get()->sendResponse(dispatchable.CallId(), response);
    return;
}

namespace {


}  // namespace

void DomainDispatcherImpl::enable(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.


    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->Enable();
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), crdtp::SpanFrom("Log.enable"), dispatchable.Serialized());
        return;
    }
    if (weak->get())
        weak->get()->sendResponse(dispatchable.CallId(), response);
    return;
}

namespace {
// This helper method (with a static map of redirects) is used from Dispatcher::wire
// immediately below.
const std::vector<std::pair<crdtp::span<uint8_t>, crdtp::span<uint8_t>>>& SortedRedirects() {
  static auto* redirects = [](){
    auto* redirects = new std::vector<std::pair<crdtp::span<uint8_t>, crdtp::span<uint8_t>>>{
    };
    return redirects;
  }();
  return *redirects;
}
}  // namespace

// static
void Dispatcher::wire(UberDispatcher* uber, Backend* backend)
{
    auto dispatcher = std::make_unique<DomainDispatcherImpl>(uber->channel(), backend);
    uber->WireBackend(crdtp::SpanFrom("Log"), SortedRedirects(), std::move(dispatcher));
}

} // Log
} // namespace content
} // namespace protocol
