// third_party/blink/public/mojom/conversions/conversions.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_CONVERSIONS_CONVERSIONS_MOJOM_SHARED_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_CONVERSIONS_CONVERSIONS_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <ostream>
#include <type_traits>
#include <utility>

#include "base/compiler_specific.h"
#include "base/containers/flat_map.h"
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "third_party/blink/public/mojom/conversions/conversions.mojom-shared-internal.h"
#include "url/mojom/origin.mojom-shared.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"


#include "base/component_export.h"




namespace blink {
namespace mojom {
class ConversionDataView;



}  // namespace mojom
}  // namespace blink

namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::blink::mojom::ConversionDataView> {
  using Data = ::blink::mojom::internal::Conversion_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace blink {
namespace mojom {
// Interface base classes. They are used for type safety check.
class ConversionHostInterfaceBase {};

using ConversionHostPtrDataView =
    mojo::InterfacePtrDataView<ConversionHostInterfaceBase>;
using ConversionHostRequestDataView =
    mojo::InterfaceRequestDataView<ConversionHostInterfaceBase>;
using ConversionHostAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<ConversionHostInterfaceBase>;
using ConversionHostAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<ConversionHostInterfaceBase>;


class ConversionDataView {
 public:
  ConversionDataView() {}

  ConversionDataView(
      internal::Conversion_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  inline void GetReportingOriginDataView(
      ::url::mojom::OriginDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadReportingOrigin(UserType* output) {
    
    auto* pointer = data_->reporting_origin.Get();
    return mojo::internal::Deserialize<::url::mojom::OriginDataView>(
        pointer, output, context_);
  }
  uint64_t conversion_data() const {
    return data_->conversion_data;
  }
 private:
  internal::Conversion_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



}  // namespace mojom
}  // namespace blink

namespace std {

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::ConversionDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::ConversionDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        Buffer* buffer,
                        ::blink::mojom::internal::Conversion_Data::BufferWriter* output,
                        SerializationContext* context) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    (*output).Allocate(buffer);
    decltype(Traits::reporting_origin(input)) in_reporting_origin = Traits::reporting_origin(input);
    typename decltype((*output)->reporting_origin)::BaseType::BufferWriter
        reporting_origin_writer;
    mojo::internal::Serialize<::url::mojom::OriginDataView>(
        in_reporting_origin, buffer, &reporting_origin_writer, context);
    (*output)->reporting_origin.Set(
        reporting_origin_writer.is_null() ? nullptr : reporting_origin_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->reporting_origin.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null reporting_origin in Conversion struct");
    (*output)->conversion_data = Traits::conversion_data(input);
  }

  static bool Deserialize(::blink::mojom::internal::Conversion_Data* input,
                          UserType* output,
                          SerializationContext* context) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::ConversionDataView data_view(input, context);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace blink {
namespace mojom {

inline void ConversionDataView::GetReportingOriginDataView(
    ::url::mojom::OriginDataView* output) {
  auto pointer = data_->reporting_origin.Get();
  *output = ::url::mojom::OriginDataView(pointer, context_);
}



}  // namespace mojom
}  // namespace blink

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_CONVERSIONS_CONVERSIONS_MOJOM_SHARED_H_