// third_party/blink/public/mojom/devtools/inspector_issue.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "third_party/blink/public/mojom/devtools/inspector_issue.mojom-shared.h"

#include <utility>

#include "base/stl_util.h"  // for base::size()
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"

#include "third_party/blink/public/mojom/devtools/inspector_issue.mojom-params-data.h"
namespace blink {
namespace mojom {

std::ostream& operator<<(std::ostream& os, InspectorIssueCode value) {
  switch(value) {
    case InspectorIssueCode::kSameSiteCookieIssue:
      return os << "InspectorIssueCode::kSameSiteCookieIssue";
    case InspectorIssueCode::kMixedContentIssue:
      return os << "InspectorIssueCode::kMixedContentIssue";
    case InspectorIssueCode::kBlockedByResponseIssue:
      return os << "InspectorIssueCode::kBlockedByResponseIssue";
    case InspectorIssueCode::kContentSecurityPolicyIssue:
      return os << "InspectorIssueCode::kContentSecurityPolicyIssue";
    default:
      return os << "Unknown InspectorIssueCode value: " << static_cast<int32_t>(value);
  }
}

std::ostream& operator<<(std::ostream& os, HeavyAdResolutionStatus value) {
  switch(value) {
    case HeavyAdResolutionStatus::kHeavyAdBlocked:
      return os << "HeavyAdResolutionStatus::kHeavyAdBlocked";
    case HeavyAdResolutionStatus::kHeavyAdWarning:
      return os << "HeavyAdResolutionStatus::kHeavyAdWarning";
    default:
      return os << "Unknown HeavyAdResolutionStatus value: " << static_cast<int32_t>(value);
  }
}

std::ostream& operator<<(std::ostream& os, HeavyAdReason value) {
  switch(value) {
    case HeavyAdReason::kNetworkTotalLimit:
      return os << "HeavyAdReason::kNetworkTotalLimit";
    case HeavyAdReason::kCpuTotalLimit:
      return os << "HeavyAdReason::kCpuTotalLimit";
    case HeavyAdReason::kCpuPeakLimit:
      return os << "HeavyAdReason::kCpuPeakLimit";
    default:
      return os << "Unknown HeavyAdReason value: " << static_cast<int32_t>(value);
  }
}

std::ostream& operator<<(std::ostream& os, MixedContentResolutionStatus value) {
  switch(value) {
    case MixedContentResolutionStatus::kMixedContentBlocked:
      return os << "MixedContentResolutionStatus::kMixedContentBlocked";
    case MixedContentResolutionStatus::kMixedContentAutomaticallyUpgraded:
      return os << "MixedContentResolutionStatus::kMixedContentAutomaticallyUpgraded";
    case MixedContentResolutionStatus::kMixedContentWarning:
      return os << "MixedContentResolutionStatus::kMixedContentWarning";
    default:
      return os << "Unknown MixedContentResolutionStatus value: " << static_cast<int32_t>(value);
  }
}

std::ostream& operator<<(std::ostream& os, ContentSecurityPolicyViolationType value) {
  switch(value) {
    case ContentSecurityPolicyViolationType::kInlineViolation:
      return os << "ContentSecurityPolicyViolationType::kInlineViolation";
    case ContentSecurityPolicyViolationType::kEvalViolation:
      return os << "ContentSecurityPolicyViolationType::kEvalViolation";
    case ContentSecurityPolicyViolationType::kURLViolation:
      return os << "ContentSecurityPolicyViolationType::kURLViolation";
    case ContentSecurityPolicyViolationType::kTrustedTypesSinkViolation:
      return os << "ContentSecurityPolicyViolationType::kTrustedTypesSinkViolation";
    case ContentSecurityPolicyViolationType::kTrustedTypesPolicyViolation:
      return os << "ContentSecurityPolicyViolationType::kTrustedTypesPolicyViolation";
    default:
      return os << "Unknown ContentSecurityPolicyViolationType value: " << static_cast<int32_t>(value);
  }
}

std::ostream& operator<<(std::ostream& os, SameSiteCookieOperation value) {
  switch(value) {
    case SameSiteCookieOperation::kSetCookie:
      return os << "SameSiteCookieOperation::kSetCookie";
    case SameSiteCookieOperation::kReadCookie:
      return os << "SameSiteCookieOperation::kReadCookie";
    default:
      return os << "Unknown SameSiteCookieOperation value: " << static_cast<int32_t>(value);
  }
}

std::ostream& operator<<(std::ostream& os, SameSiteCookieExclusionReason value) {
  switch(value) {
    case SameSiteCookieExclusionReason::kExcludeSameSiteUnspecifiedTreatedAsLax:
      return os << "SameSiteCookieExclusionReason::kExcludeSameSiteUnspecifiedTreatedAsLax";
    case SameSiteCookieExclusionReason::kExcludeSameSiteNoneInsecure:
      return os << "SameSiteCookieExclusionReason::kExcludeSameSiteNoneInsecure";
    case SameSiteCookieExclusionReason::kExcludeSameSiteLax:
      return os << "SameSiteCookieExclusionReason::kExcludeSameSiteLax";
    case SameSiteCookieExclusionReason::kExcludeSameSiteStrict:
      return os << "SameSiteCookieExclusionReason::kExcludeSameSiteStrict";
    default:
      return os << "Unknown SameSiteCookieExclusionReason value: " << static_cast<int32_t>(value);
  }
}

std::ostream& operator<<(std::ostream& os, SameSiteCookieWarningReason value) {
  switch(value) {
    case SameSiteCookieWarningReason::kWarnSameSiteUnspecifiedCrossSiteContext:
      return os << "SameSiteCookieWarningReason::kWarnSameSiteUnspecifiedCrossSiteContext";
    case SameSiteCookieWarningReason::kWarnSameSiteNoneInsecure:
      return os << "SameSiteCookieWarningReason::kWarnSameSiteNoneInsecure";
    case SameSiteCookieWarningReason::kWarnSameSiteUnspecifiedLaxAllowUnsafe:
      return os << "SameSiteCookieWarningReason::kWarnSameSiteUnspecifiedLaxAllowUnsafe";
    case SameSiteCookieWarningReason::kWarnSameSiteStrictLaxDowngradeStrict:
      return os << "SameSiteCookieWarningReason::kWarnSameSiteStrictLaxDowngradeStrict";
    case SameSiteCookieWarningReason::kWarnSameSiteStrictCrossDowngradeStrict:
      return os << "SameSiteCookieWarningReason::kWarnSameSiteStrictCrossDowngradeStrict";
    case SameSiteCookieWarningReason::kWarnSameSiteStrictCrossDowngradeLax:
      return os << "SameSiteCookieWarningReason::kWarnSameSiteStrictCrossDowngradeLax";
    case SameSiteCookieWarningReason::kWarnSameSiteLaxCrossDowngradeStrict:
      return os << "SameSiteCookieWarningReason::kWarnSameSiteLaxCrossDowngradeStrict";
    case SameSiteCookieWarningReason::kWarnSameSiteLaxCrossDowngradeLax:
      return os << "SameSiteCookieWarningReason::kWarnSameSiteLaxCrossDowngradeLax";
    default:
      return os << "Unknown SameSiteCookieWarningReason value: " << static_cast<int32_t>(value);
  }
}

namespace internal {


// static
bool AffectedCookie_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;

  if (!ValidateStructHeaderAndClaimMemory(data, validation_context))
    return false;

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const AffectedCookie_Data* object = static_cast<const AffectedCookie_Data*>(data);

  static constexpr struct {
    uint32_t version;
    uint32_t num_bytes;
  } kVersionSizes[] = {{ 0, 32 }};

  if (object->header_.version <=
          kVersionSizes[base::size(kVersionSizes) - 1].version) {
    // Scan in reverse order to optimize for more recent versions.
    for (int i = base::size(kVersionSizes) - 1; i >= 0; --i) {
      if (object->header_.version >= kVersionSizes[i].version) {
        if (object->header_.num_bytes == kVersionSizes[i].num_bytes)
          break;

        ReportValidationError(
            validation_context,
            mojo::internal::VALIDATION_ERROR_UNEXPECTED_STRUCT_HEADER);
        return false;
      }
    }
  } else if (object->header_.num_bytes <
                 kVersionSizes[base::size(kVersionSizes) - 1].num_bytes) {
    ReportValidationError(
        validation_context,
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_STRUCT_HEADER);
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->name, 1, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams name_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->name, validation_context,
                                         &name_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->path, 2, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams path_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->path, validation_context,
                                         &path_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->domain, 3, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams domain_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->domain, validation_context,
                                         &domain_validate_params)) {
    return false;
  }

  return true;
}

AffectedCookie_Data::AffectedCookie_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool AffectedRequest_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;

  if (!ValidateStructHeaderAndClaimMemory(data, validation_context))
    return false;

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const AffectedRequest_Data* object = static_cast<const AffectedRequest_Data*>(data);

  static constexpr struct {
    uint32_t version;
    uint32_t num_bytes;
  } kVersionSizes[] = {{ 0, 24 }};

  if (object->header_.version <=
          kVersionSizes[base::size(kVersionSizes) - 1].version) {
    // Scan in reverse order to optimize for more recent versions.
    for (int i = base::size(kVersionSizes) - 1; i >= 0; --i) {
      if (object->header_.version >= kVersionSizes[i].version) {
        if (object->header_.num_bytes == kVersionSizes[i].num_bytes)
          break;

        ReportValidationError(
            validation_context,
            mojo::internal::VALIDATION_ERROR_UNEXPECTED_STRUCT_HEADER);
        return false;
      }
    }
  } else if (object->header_.num_bytes <
                 kVersionSizes[base::size(kVersionSizes) - 1].num_bytes) {
    ReportValidationError(
        validation_context,
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_STRUCT_HEADER);
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->request_id, 1, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams request_id_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->request_id, validation_context,
                                         &request_id_validate_params)) {
    return false;
  }

  const mojo::internal::ContainerValidateParams url_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->url, validation_context,
                                         &url_validate_params)) {
    return false;
  }

  return true;
}

AffectedRequest_Data::AffectedRequest_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool AffectedFrame_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;

  if (!ValidateStructHeaderAndClaimMemory(data, validation_context))
    return false;

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const AffectedFrame_Data* object = static_cast<const AffectedFrame_Data*>(data);

  static constexpr struct {
    uint32_t version;
    uint32_t num_bytes;
  } kVersionSizes[] = {{ 0, 16 }};

  if (object->header_.version <=
          kVersionSizes[base::size(kVersionSizes) - 1].version) {
    // Scan in reverse order to optimize for more recent versions.
    for (int i = base::size(kVersionSizes) - 1; i >= 0; --i) {
      if (object->header_.version >= kVersionSizes[i].version) {
        if (object->header_.num_bytes == kVersionSizes[i].num_bytes)
          break;

        ReportValidationError(
            validation_context,
            mojo::internal::VALIDATION_ERROR_UNEXPECTED_STRUCT_HEADER);
        return false;
      }
    }
  } else if (object->header_.num_bytes <
                 kVersionSizes[base::size(kVersionSizes) - 1].num_bytes) {
    ReportValidationError(
        validation_context,
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_STRUCT_HEADER);
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->frame_id, 1, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams frame_id_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->frame_id, validation_context,
                                         &frame_id_validate_params)) {
    return false;
  }

  return true;
}

AffectedFrame_Data::AffectedFrame_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool BlockedByResponseIssueDetails_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;

  if (!ValidateStructHeaderAndClaimMemory(data, validation_context))
    return false;

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const BlockedByResponseIssueDetails_Data* object = static_cast<const BlockedByResponseIssueDetails_Data*>(data);

  static constexpr struct {
    uint32_t version;
    uint32_t num_bytes;
  } kVersionSizes[] = {{ 0, 40 }};

  if (object->header_.version <=
          kVersionSizes[base::size(kVersionSizes) - 1].version) {
    // Scan in reverse order to optimize for more recent versions.
    for (int i = base::size(kVersionSizes) - 1; i >= 0; --i) {
      if (object->header_.version >= kVersionSizes[i].version) {
        if (object->header_.num_bytes == kVersionSizes[i].num_bytes)
          break;

        ReportValidationError(
            validation_context,
            mojo::internal::VALIDATION_ERROR_UNEXPECTED_STRUCT_HEADER);
        return false;
      }
    }
  } else if (object->header_.num_bytes <
                 kVersionSizes[base::size(kVersionSizes) - 1].num_bytes) {
    ReportValidationError(
        validation_context,
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_STRUCT_HEADER);
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->request, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->request, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->parentFrame, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->blockedFrame, validation_context))
    return false;


  if (!::network::mojom::internal::BlockedByResponseReason_Data
        ::Validate(object->reason, validation_context))
    return false;

  return true;
}

BlockedByResponseIssueDetails_Data::BlockedByResponseIssueDetails_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool MixedContentIssueDetails_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;

  if (!ValidateStructHeaderAndClaimMemory(data, validation_context))
    return false;

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const MixedContentIssueDetails_Data* object = static_cast<const MixedContentIssueDetails_Data*>(data);

  static constexpr struct {
    uint32_t version;
    uint32_t num_bytes;
  } kVersionSizes[] = {{ 0, 48 }};

  if (object->header_.version <=
          kVersionSizes[base::size(kVersionSizes) - 1].version) {
    // Scan in reverse order to optimize for more recent versions.
    for (int i = base::size(kVersionSizes) - 1; i >= 0; --i) {
      if (object->header_.version >= kVersionSizes[i].version) {
        if (object->header_.num_bytes == kVersionSizes[i].num_bytes)
          break;

        ReportValidationError(
            validation_context,
            mojo::internal::VALIDATION_ERROR_UNEXPECTED_STRUCT_HEADER);
        return false;
      }
    }
  } else if (object->header_.num_bytes <
                 kVersionSizes[base::size(kVersionSizes) - 1].num_bytes) {
    ReportValidationError(
        validation_context,
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_STRUCT_HEADER);
    return false;
  }


  if (!::blink::mojom::internal::RequestContextType_Data
        ::Validate(object->request_context, validation_context))
    return false;


  if (!::blink::mojom::internal::MixedContentResolutionStatus_Data
        ::Validate(object->resolution_status, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->insecure_url, 3, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams insecure_url_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->insecure_url, validation_context,
                                         &insecure_url_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->main_resource_url, 4, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams main_resource_url_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->main_resource_url, validation_context,
                                         &main_resource_url_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidateStruct(object->request, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->frame, validation_context))
    return false;

  return true;
}

MixedContentIssueDetails_Data::MixedContentIssueDetails_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ContentSecurityPolicyIssueDetails_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;

  if (!ValidateStructHeaderAndClaimMemory(data, validation_context))
    return false;

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const ContentSecurityPolicyIssueDetails_Data* object = static_cast<const ContentSecurityPolicyIssueDetails_Data*>(data);

  static constexpr struct {
    uint32_t version;
    uint32_t num_bytes;
  } kVersionSizes[] = {{ 0, 48 }};

  if (object->header_.version <=
          kVersionSizes[base::size(kVersionSizes) - 1].version) {
    // Scan in reverse order to optimize for more recent versions.
    for (int i = base::size(kVersionSizes) - 1; i >= 0; --i) {
      if (object->header_.version >= kVersionSizes[i].version) {
        if (object->header_.num_bytes == kVersionSizes[i].num_bytes)
          break;

        ReportValidationError(
            validation_context,
            mojo::internal::VALIDATION_ERROR_UNEXPECTED_STRUCT_HEADER);
        return false;
      }
    }
  } else if (object->header_.num_bytes <
                 kVersionSizes[base::size(kVersionSizes) - 1].num_bytes) {
    ReportValidationError(
        validation_context,
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_STRUCT_HEADER);
    return false;
  }

  if (!mojo::internal::ValidateStruct(object->blocked_url, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->violated_directive, 2, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams violated_directive_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->violated_directive, validation_context,
                                         &violated_directive_validate_params)) {
    return false;
  }


  if (!::blink::mojom::internal::ContentSecurityPolicyViolationType_Data
        ::Validate(object->content_security_policy_violation_type, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->frame_ancestor, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->source_location, validation_context))
    return false;

  return true;
}

ContentSecurityPolicyIssueDetails_Data::ContentSecurityPolicyIssueDetails_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool SameSiteCookieIssueDetails_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;

  if (!ValidateStructHeaderAndClaimMemory(data, validation_context))
    return false;

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const SameSiteCookieIssueDetails_Data* object = static_cast<const SameSiteCookieIssueDetails_Data*>(data);

  static constexpr struct {
    uint32_t version;
    uint32_t num_bytes;
  } kVersionSizes[] = {{ 0, 64 }};

  if (object->header_.version <=
          kVersionSizes[base::size(kVersionSizes) - 1].version) {
    // Scan in reverse order to optimize for more recent versions.
    for (int i = base::size(kVersionSizes) - 1; i >= 0; --i) {
      if (object->header_.version >= kVersionSizes[i].version) {
        if (object->header_.num_bytes == kVersionSizes[i].num_bytes)
          break;

        ReportValidationError(
            validation_context,
            mojo::internal::VALIDATION_ERROR_UNEXPECTED_STRUCT_HEADER);
        return false;
      }
    }
  } else if (object->header_.num_bytes <
                 kVersionSizes[base::size(kVersionSizes) - 1].num_bytes) {
    ReportValidationError(
        validation_context,
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_STRUCT_HEADER);
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->cookie, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->cookie, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->exclusion_reason, 2, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams exclusion_reason_validate_params(
      0, ::blink::mojom::internal::SameSiteCookieExclusionReason_Data::Validate);
  if (!mojo::internal::ValidateContainer(object->exclusion_reason, validation_context,
                                         &exclusion_reason_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->warning_reason, 3, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams warning_reason_validate_params(
      0, ::blink::mojom::internal::SameSiteCookieWarningReason_Data::Validate);
  if (!mojo::internal::ValidateContainer(object->warning_reason, validation_context,
                                         &warning_reason_validate_params)) {
    return false;
  }


  if (!::blink::mojom::internal::SameSiteCookieOperation_Data
        ::Validate(object->operation, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->site_for_cookies, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->cookie_url, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->request, validation_context))
    return false;

  return true;
}

SameSiteCookieIssueDetails_Data::SameSiteCookieIssueDetails_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool InspectorIssueDetails_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;

  if (!ValidateStructHeaderAndClaimMemory(data, validation_context))
    return false;

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const InspectorIssueDetails_Data* object = static_cast<const InspectorIssueDetails_Data*>(data);

  static constexpr struct {
    uint32_t version;
    uint32_t num_bytes;
  } kVersionSizes[] = {{ 0, 40 }};

  if (object->header_.version <=
          kVersionSizes[base::size(kVersionSizes) - 1].version) {
    // Scan in reverse order to optimize for more recent versions.
    for (int i = base::size(kVersionSizes) - 1; i >= 0; --i) {
      if (object->header_.version >= kVersionSizes[i].version) {
        if (object->header_.num_bytes == kVersionSizes[i].num_bytes)
          break;

        ReportValidationError(
            validation_context,
            mojo::internal::VALIDATION_ERROR_UNEXPECTED_STRUCT_HEADER);
        return false;
      }
    }
  } else if (object->header_.num_bytes <
                 kVersionSizes[base::size(kVersionSizes) - 1].num_bytes) {
    ReportValidationError(
        validation_context,
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_STRUCT_HEADER);
    return false;
  }

  if (!mojo::internal::ValidateStruct(object->samesite_cookie_issue_details, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->mixed_content_issue_details, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->blocked_by_response_issue_details, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->csp_issue_details, validation_context))
    return false;

  return true;
}

InspectorIssueDetails_Data::InspectorIssueDetails_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool InspectorIssueInfo_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;

  if (!ValidateStructHeaderAndClaimMemory(data, validation_context))
    return false;

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const InspectorIssueInfo_Data* object = static_cast<const InspectorIssueInfo_Data*>(data);

  static constexpr struct {
    uint32_t version;
    uint32_t num_bytes;
  } kVersionSizes[] = {{ 0, 24 }};

  if (object->header_.version <=
          kVersionSizes[base::size(kVersionSizes) - 1].version) {
    // Scan in reverse order to optimize for more recent versions.
    for (int i = base::size(kVersionSizes) - 1; i >= 0; --i) {
      if (object->header_.version >= kVersionSizes[i].version) {
        if (object->header_.num_bytes == kVersionSizes[i].num_bytes)
          break;

        ReportValidationError(
            validation_context,
            mojo::internal::VALIDATION_ERROR_UNEXPECTED_STRUCT_HEADER);
        return false;
      }
    }
  } else if (object->header_.num_bytes <
                 kVersionSizes[base::size(kVersionSizes) - 1].num_bytes) {
    ReportValidationError(
        validation_context,
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_STRUCT_HEADER);
    return false;
  }


  if (!::blink::mojom::internal::InspectorIssueCode_Data
        ::Validate(object->code, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->details, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->details, validation_context))
    return false;

  return true;
}

InspectorIssueInfo_Data::InspectorIssueInfo_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace blink