// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// GENERATED FROM THE API DEFINITION IN
//   qtwebengine/common/extensions/api/tabs.json
// by tools/json_schema_compiler.
// DO NOT EDIT.

#include "qtwebengine/common/extensions/api/tabs.h"

#include <memory>
#include <optional>
#include <ostream>
#include <string>
#include <string_view>
#include <utility>
#include <vector>

#include "base/check.h"
#include "base/check_op.h"
#include "base/notreached.h"
#include "base/strings/string_number_conversions.h"
#include "base/strings/utf_string_conversions.h"
#include "base/values.h"
#include "tools/json_schema_compiler/util.h"

using base::UTF8ToUTF16;

namespace extensions {
namespace api {
namespace tabs {
//
// Properties
//

const int TAB_ID_NONE = -1;

//
// Types
//

Tab::Tab()
: id(0),
index(0),
window_id(0),
selected(false),
highlighted(false),
active(false),
pinned(false),
incognito(false) {}

Tab::~Tab() = default;
Tab::Tab(Tab&& rhs) noexcept = default;
Tab& Tab::operator=(Tab&& rhs) noexcept = default;
Tab Tab::Clone() const {
  Tab out;
  out.id = id;
  out.index = index;
  out.window_id = window_id;
  out.selected = selected;
  out.highlighted = highlighted;
  out.active = active;
  out.pinned = pinned;
  out.url = url;
  out.title = title;
  out.fav_icon_url = fav_icon_url;
  out.status = status;
  out.incognito = incognito;
  return out;
}

// static
bool Tab::Populate(
    const base::Value::Dict& dict, Tab& out) {
  const base::Value* id_value = dict.Find("id");
  if (!id_value) {
    return false;
  }
  {
    auto temp = (*id_value).GetIfInt();
    if (!temp.has_value()) {
      return false;
    }
    out.id = *temp;
  }

  const base::Value* index_value = dict.Find("index");
  if (!index_value) {
    return false;
  }
  {
    auto temp = (*index_value).GetIfInt();
    if (!temp.has_value()) {
      return false;
    }
    out.index = *temp;
  }

  const base::Value* window_id_value = dict.Find("windowId");
  if (!window_id_value) {
    return false;
  }
  {
    auto temp = (*window_id_value).GetIfInt();
    if (!temp.has_value()) {
      return false;
    }
    out.window_id = *temp;
  }

  const base::Value* selected_value = dict.Find("selected");
  if (!selected_value) {
    return false;
  }
  {
    auto temp = (*selected_value).GetIfBool();
    if (!temp.has_value()) {
      return false;
    }
    out.selected = *temp;
  }

  const base::Value* highlighted_value = dict.Find("highlighted");
  if (!highlighted_value) {
    return false;
  }
  {
    auto temp = (*highlighted_value).GetIfBool();
    if (!temp.has_value()) {
      return false;
    }
    out.highlighted = *temp;
  }

  const base::Value* active_value = dict.Find("active");
  if (!active_value) {
    return false;
  }
  {
    auto temp = (*active_value).GetIfBool();
    if (!temp.has_value()) {
      return false;
    }
    out.active = *temp;
  }

  const base::Value* pinned_value = dict.Find("pinned");
  if (!pinned_value) {
    return false;
  }
  {
    auto temp = (*pinned_value).GetIfBool();
    if (!temp.has_value()) {
      return false;
    }
    out.pinned = *temp;
  }

  const base::Value* url_value = dict.Find("url");
  if (!url_value) {
    return false;
  }
  {
    auto* temp = (*url_value).GetIfString();
    if (!temp) {
      return false;
    }
    out.url = *temp;
  }

  const base::Value* title_value = dict.Find("title");
  if (title_value) {
    {
      auto* temp = (*title_value).GetIfString();
      if (!temp) {
        out.title = std::nullopt;
        return false;
      }
      out.title = *temp;
    }
  }

  const base::Value* fav_icon_url_value = dict.Find("favIconUrl");
  if (fav_icon_url_value) {
    {
      auto* temp = (*fav_icon_url_value).GetIfString();
      if (!temp) {
        out.fav_icon_url = std::nullopt;
        return false;
      }
      out.fav_icon_url = *temp;
    }
  }

  const base::Value* status_value = dict.Find("status");
  if (status_value) {
    {
      auto* temp = (*status_value).GetIfString();
      if (!temp) {
        out.status = std::nullopt;
        return false;
      }
      out.status = *temp;
    }
  }

  const base::Value* incognito_value = dict.Find("incognito");
  if (!incognito_value) {
    return false;
  }
  {
    auto temp = (*incognito_value).GetIfBool();
    if (!temp.has_value()) {
      return false;
    }
    out.incognito = *temp;
  }

  return true;
}

// static
bool Tab::Populate(
    const base::Value& value, Tab& out) {
  if (!value.is_dict()) {
    return false;
  }
  return Populate(value.GetDict(), out);
}

// static
std::optional<Tab> Tab::FromValue(const base::Value::Dict& value) {
  Tab out;
  bool result = Populate(value, out);
  if (!result) {
    return std::nullopt;
  }
  return out;
}

// static
std::optional<Tab> Tab::FromValue(const base::Value& value) {
  Tab out;
  bool result = Populate(value, out);
  if (!result) {
    return std::nullopt;
  }
  return out;
}

base::Value::Dict Tab::ToValue() const {
  base::Value::Dict to_value_result;

  to_value_result.Set("id", this->id);

  to_value_result.Set("index", this->index);

  to_value_result.Set("windowId", this->window_id);

  to_value_result.Set("selected", this->selected);

  to_value_result.Set("highlighted", this->highlighted);

  to_value_result.Set("active", this->active);

  to_value_result.Set("pinned", this->pinned);

  to_value_result.Set("url", this->url);

  if (this->title) {
    to_value_result.Set("title", *this->title);

  }
  if (this->fav_icon_url) {
    to_value_result.Set("favIconUrl", *this->fav_icon_url);

  }
  if (this->status) {
    to_value_result.Set("status", *this->status);

  }
  to_value_result.Set("incognito", this->incognito);


  return to_value_result;
}



//
// Functions
//

namespace Update {

Params::UpdateProperties::UpdateProperties()
 {}

Params::UpdateProperties::~UpdateProperties() = default;
Params::UpdateProperties::UpdateProperties(UpdateProperties&& rhs) noexcept = default;
Params::UpdateProperties& Params::UpdateProperties::operator=(UpdateProperties&& rhs) noexcept = default;
Params::UpdateProperties Params::UpdateProperties::Clone() const {
  UpdateProperties out;
  out.url = url;
  out.active = active;
  out.highlighted = highlighted;
  out.selected = selected;
  out.pinned = pinned;
  out.muted = muted;
  out.opener_tab_id = opener_tab_id;
  out.auto_discardable = auto_discardable;
  return out;
}

// static
bool Params::UpdateProperties::Populate(
    const base::Value::Dict& dict, UpdateProperties& out) {
  const base::Value* url_value = dict.Find("url");
  if (url_value) {
    {
      auto* temp = (*url_value).GetIfString();
      if (!temp) {
        out.url = std::nullopt;
        return false;
      }
      out.url = *temp;
    }
  }

  const base::Value* active_value = dict.Find("active");
  if (active_value) {
    {
      auto temp = (*active_value).GetIfBool();
      if (!temp.has_value()) {
        out.active = std::nullopt;
        return false;
      }
      out.active = *temp;
    }
  }

  const base::Value* highlighted_value = dict.Find("highlighted");
  if (highlighted_value) {
    {
      auto temp = (*highlighted_value).GetIfBool();
      if (!temp.has_value()) {
        out.highlighted = std::nullopt;
        return false;
      }
      out.highlighted = *temp;
    }
  }

  const base::Value* selected_value = dict.Find("selected");
  if (selected_value) {
    {
      auto temp = (*selected_value).GetIfBool();
      if (!temp.has_value()) {
        out.selected = std::nullopt;
        return false;
      }
      out.selected = *temp;
    }
  }

  const base::Value* pinned_value = dict.Find("pinned");
  if (pinned_value) {
    {
      auto temp = (*pinned_value).GetIfBool();
      if (!temp.has_value()) {
        out.pinned = std::nullopt;
        return false;
      }
      out.pinned = *temp;
    }
  }

  const base::Value* muted_value = dict.Find("muted");
  if (muted_value) {
    {
      auto temp = (*muted_value).GetIfBool();
      if (!temp.has_value()) {
        out.muted = std::nullopt;
        return false;
      }
      out.muted = *temp;
    }
  }

  const base::Value* opener_tab_id_value = dict.Find("openerTabId");
  if (opener_tab_id_value) {
    {
      auto temp = (*opener_tab_id_value).GetIfInt();
      if (!temp.has_value()) {
        out.opener_tab_id = std::nullopt;
        return false;
      }
      out.opener_tab_id = *temp;
    }
  }

  const base::Value* auto_discardable_value = dict.Find("autoDiscardable");
  if (auto_discardable_value) {
    {
      auto temp = (*auto_discardable_value).GetIfBool();
      if (!temp.has_value()) {
        out.auto_discardable = std::nullopt;
        return false;
      }
      out.auto_discardable = *temp;
    }
  }

  return true;
}

// static
bool Params::UpdateProperties::Populate(
    const base::Value& value, UpdateProperties& out) {
  if (!value.is_dict()) {
    return false;
  }
  return Populate(value.GetDict(), out);
}

// static
std::optional<Params::UpdateProperties> Params::UpdateProperties::FromValue(const base::Value::Dict& value) {
  UpdateProperties out;
  bool result = Populate(value, out);
  if (!result) {
    return std::nullopt;
  }
  return out;
}

// static
std::optional<Params::UpdateProperties> Params::UpdateProperties::FromValue(const base::Value& value) {
  UpdateProperties out;
  bool result = Populate(value, out);
  if (!result) {
    return std::nullopt;
  }
  return out;
}


Params::Params() = default;
Params::~Params() = default;
Params::Params(Params&& rhs) noexcept = default;
Params& Params::operator=(Params&& rhs) noexcept = default;

// static
std::optional<Params> Params::Create(const base::Value::List& args) {
  if (args.size() < 1 || args.size() > 2) {
    return std::nullopt;
  }
  Params params;

  if (0 < args.size() &&
      !args[0].is_none()) {
    const base::Value& tab_id_value = args[0];
    {
      auto temp = tab_id_value.GetIfInt();
      if (!temp.has_value()) {
        params.tab_id = std::nullopt;
        return std::nullopt;
      }
      params.tab_id = *temp;
    }
  }

  if (1 < args.size() &&
      !args[1].is_none()) {
    const base::Value& update_properties_value = args[1];
    {
      if (!update_properties_value.is_dict()) {
        return std::nullopt;
      }
      if (!UpdateProperties::Populate(update_properties_value.GetDict(), params.update_properties)) {
        return std::nullopt;
      }
    }
  }
  else {
    return std::nullopt;
  }

  return params;
}


base::Value::List Results::Create(const Tab& tab) {
  base::Value::List create_results;
  create_results.reserve(1);
  create_results.Append((tab).ToValue());

  return create_results;
}
}  // namespace Update

}  // namespace tabs
}  // namespace api
}  // namespace extensions

