// services/network/public/mojom/site_for_cookies.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_SITE_FOR_COOKIES_MOJOM_SHARED_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_SITE_FOR_COOKIES_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "services/network/public/mojom/site_for_cookies.mojom-shared-internal.h"
#include "services/network/public/mojom/schemeful_site.mojom-shared.h"







namespace network::mojom {
class SiteForCookiesDataView;



}  // network::mojom

namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::network::mojom::SiteForCookiesDataView> {
  using Data = ::network::mojom::internal::SiteForCookies_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace network::mojom {


class SiteForCookiesDataView {
 public:
  SiteForCookiesDataView() = default;

  SiteForCookiesDataView(
      internal::SiteForCookies_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetSiteDataView(
      ::network::mojom::SchemefulSiteDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSite(UserType* output) {
    
    auto* pointer = data_->site.Get();
    return mojo::internal::Deserialize<::network::mojom::SchemefulSiteDataView>(
        pointer, output, message_);
  }
  bool schemefully_same() const {
    return data_->schemefully_same;
  }
  inline void GetFirstPartyUrlDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadFirstPartyUrl(UserType* output) {
    
    auto* pointer = data_->first_party_url.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
 private:
  internal::SiteForCookies_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // network::mojom

namespace std {

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::SiteForCookiesDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::network::mojom::SiteForCookiesDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::network::mojom::internal::SiteForCookies_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::site(input)) in_site = Traits::site(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->site)::BaseType> site_fragment(
            fragment.message());
    mojo::internal::Serialize<::network::mojom::SchemefulSiteDataView>(
        in_site, site_fragment);
    fragment->site.Set(
        site_fragment.is_null() ? nullptr : site_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->site.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null site in SiteForCookies struct");
    fragment->schemefully_same = Traits::schemefully_same(input);
    decltype(Traits::first_party_url(input)) in_first_party_url = Traits::first_party_url(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->first_party_url)::BaseType> first_party_url_fragment(
            fragment.message());
    mojo::internal::Serialize<mojo::StringDataView>(
        in_first_party_url, first_party_url_fragment);
    fragment->first_party_url.Set(
        first_party_url_fragment.is_null() ? nullptr : first_party_url_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->first_party_url.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null first_party_url in SiteForCookies struct");
  }

  static bool Deserialize(::network::mojom::internal::SiteForCookies_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::network::mojom::SiteForCookiesDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace network::mojom {

inline void SiteForCookiesDataView::GetSiteDataView(
    ::network::mojom::SchemefulSiteDataView* output) {
  auto pointer = data_->site.Get();
  *output = ::network::mojom::SchemefulSiteDataView(pointer, message_);
}
inline void SiteForCookiesDataView::GetFirstPartyUrlDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->first_party_url.Get();
  *output = mojo::StringDataView(pointer, message_);
}



}  // network::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

#endif  // SERVICES_NETWORK_PUBLIC_MOJOM_SITE_FOR_COOKIES_MOJOM_SHARED_H_