// SPDX-FileCopyrightText: 2021 Rot127 <unisono@quyllur.org>
// SPDX-License-Identifier: LGPL-3.0-only

// LLVM commit: c2b89fc9e45d325282b8eb6536f6145282dc3fdf
// LLVM commit date: 2024-12-23 13:36:28 -0600 (ISO 8601 format)
// Date of code generation: 2025-02-22 07:05:24-05:00
//========================================
// The following code is generated.
// Do not edit. Repository of code generator:
// https://github.com/rizinorg/rz-hexagon

#include <rz_il/rz_il_opbuilder_begin.h>
#include "../hexagon_il.h"
#include <hexagon/hexagon.h>
#include <rz_il/rz_il_opcodes.h>

// Rx += add(Rs,Rt)
RzILOpEffect *hex_il_op_m2_acci(HexInsnPktBundle *bundle) {
	const HexInsn *hi = bundle->insn;
	HexPkt *pkt = bundle->pkt;
	// READ
	const HexOp *Rx_op = ISA2REG(hi, 'x', false);

	const HexOp *Rs_op = ISA2REG(hi, 's', false);
	RzILOpPure *Rs = READ_REG(pkt, Rs_op, false);
	const HexOp *Rt_op = ISA2REG(hi, 't', false);
	RzILOpPure *Rt = READ_REG(pkt, Rt_op, false);

	// Rx = Rx + Rs + Rt;
	RzILOpPure *op_ADD_2 = ADD(READ_REG(pkt, Rx_op, false), Rs);
	RzILOpPure *op_ADD_4 = ADD(op_ADD_2, Rt);
	RzILOpEffect *op_ASSIGN_5 = WRITE_REG(bundle, Rx_op, op_ADD_4);

	RzILOpEffect *instruction_sequence = op_ASSIGN_5;
	return instruction_sequence;
}

// Rx += add(Rs,Ii)
RzILOpEffect *hex_il_op_m2_accii(HexInsnPktBundle *bundle) {
	const HexInsn *hi = bundle->insn;
	HexPkt *pkt = bundle->pkt;
	// READ
	RzILOpPure *s = SN(32, (st32)ISA2IMM(hi, 's'));
	const HexOp *Rx_op = ISA2REG(hi, 'x', false);

	const HexOp *Rs_op = ISA2REG(hi, 's', false);
	RzILOpPure *Rs = READ_REG(pkt, Rs_op, false);

	// s = s;
	RzILOpEffect *imm_assign_0 = SETL("s", s);

	// Rx = Rx + Rs + s;
	RzILOpPure *op_ADD_4 = ADD(READ_REG(pkt, Rx_op, false), Rs);
	RzILOpPure *op_ADD_5 = ADD(op_ADD_4, VARL("s"));
	RzILOpEffect *op_ASSIGN_6 = WRITE_REG(bundle, Rx_op, op_ADD_5);

	RzILOpEffect *instruction_sequence = SEQN(2, imm_assign_0, op_ASSIGN_6);
	return instruction_sequence;
}

// Rxx += cmpyi(Rs,Rt)
RzILOpEffect *hex_il_op_m2_cmaci_s0(HexInsnPktBundle *bundle) {
	const HexInsn *hi = bundle->insn;
	HexPkt *pkt = bundle->pkt;
	// READ
	const HexOp *Rxx_op = ISA2REG(hi, 'x', false);

	const HexOp *Rs_op = ISA2REG(hi, 's', false);
	RzILOpPure *Rs = READ_REG(pkt, Rs_op, false);
	const HexOp *Rt_op = ISA2REG(hi, 't', false);
	RzILOpPure *Rt = READ_REG(pkt, Rt_op, false);

	// Rxx = Rxx + ((st64) ((st32) ((st16) ((Rs >> 0x10) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x0) & 0xffff)))) + ((st64) ((st32) ((st16) ((Rs >> 0x0) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x10) & 0xffff))));
	RzILOpPure *op_RSHIFT_5 = SHIFTRA(Rs, SN(32, 16));
	RzILOpPure *op_AND_7 = LOGAND(op_RSHIFT_5, SN(32, 0xffff));
	RzILOpPure *op_RSHIFT_14 = SHIFTRA(Rt, SN(32, 0));
	RzILOpPure *op_AND_16 = LOGAND(op_RSHIFT_14, SN(32, 0xffff));
	RzILOpPure *op_MUL_19 = MUL(CAST(32, MSB(CAST(16, MSB(op_AND_7), DUP(op_AND_7))), CAST(16, MSB(DUP(op_AND_7)), DUP(op_AND_7))), CAST(32, MSB(CAST(16, MSB(op_AND_16), DUP(op_AND_16))), CAST(16, MSB(DUP(op_AND_16)), DUP(op_AND_16))));
	RzILOpPure *op_ADD_21 = ADD(READ_REG(pkt, Rxx_op, false), CAST(64, MSB(op_MUL_19), DUP(op_MUL_19)));
	RzILOpPure *op_RSHIFT_25 = SHIFTRA(DUP(Rs), SN(32, 0));
	RzILOpPure *op_AND_27 = LOGAND(op_RSHIFT_25, SN(32, 0xffff));
	RzILOpPure *op_RSHIFT_33 = SHIFTRA(DUP(Rt), SN(32, 16));
	RzILOpPure *op_AND_35 = LOGAND(op_RSHIFT_33, SN(32, 0xffff));
	RzILOpPure *op_MUL_38 = MUL(CAST(32, MSB(CAST(16, MSB(op_AND_27), DUP(op_AND_27))), CAST(16, MSB(DUP(op_AND_27)), DUP(op_AND_27))), CAST(32, MSB(CAST(16, MSB(op_AND_35), DUP(op_AND_35))), CAST(16, MSB(DUP(op_AND_35)), DUP(op_AND_35))));
	RzILOpPure *op_ADD_40 = ADD(op_ADD_21, CAST(64, MSB(op_MUL_38), DUP(op_MUL_38)));
	RzILOpEffect *op_ASSIGN_41 = WRITE_REG(bundle, Rxx_op, op_ADD_40);

	RzILOpEffect *instruction_sequence = op_ASSIGN_41;
	return instruction_sequence;
}

// Rxx += cmpyr(Rs,Rt)
RzILOpEffect *hex_il_op_m2_cmacr_s0(HexInsnPktBundle *bundle) {
	const HexInsn *hi = bundle->insn;
	HexPkt *pkt = bundle->pkt;
	// READ
	const HexOp *Rxx_op = ISA2REG(hi, 'x', false);

	const HexOp *Rs_op = ISA2REG(hi, 's', false);
	RzILOpPure *Rs = READ_REG(pkt, Rs_op, false);
	const HexOp *Rt_op = ISA2REG(hi, 't', false);
	RzILOpPure *Rt = READ_REG(pkt, Rt_op, false);

	// Rxx = Rxx + ((st64) ((st32) ((st16) ((Rs >> 0x0) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x0) & 0xffff)))) - ((st64) ((st32) ((st16) ((Rs >> 0x10) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x10) & 0xffff))));
	RzILOpPure *op_RSHIFT_5 = SHIFTRA(Rs, SN(32, 0));
	RzILOpPure *op_AND_7 = LOGAND(op_RSHIFT_5, SN(32, 0xffff));
	RzILOpPure *op_RSHIFT_14 = SHIFTRA(Rt, SN(32, 0));
	RzILOpPure *op_AND_16 = LOGAND(op_RSHIFT_14, SN(32, 0xffff));
	RzILOpPure *op_MUL_19 = MUL(CAST(32, MSB(CAST(16, MSB(op_AND_7), DUP(op_AND_7))), CAST(16, MSB(DUP(op_AND_7)), DUP(op_AND_7))), CAST(32, MSB(CAST(16, MSB(op_AND_16), DUP(op_AND_16))), CAST(16, MSB(DUP(op_AND_16)), DUP(op_AND_16))));
	RzILOpPure *op_ADD_21 = ADD(READ_REG(pkt, Rxx_op, false), CAST(64, MSB(op_MUL_19), DUP(op_MUL_19)));
	RzILOpPure *op_RSHIFT_25 = SHIFTRA(DUP(Rs), SN(32, 16));
	RzILOpPure *op_AND_27 = LOGAND(op_RSHIFT_25, SN(32, 0xffff));
	RzILOpPure *op_RSHIFT_33 = SHIFTRA(DUP(Rt), SN(32, 16));
	RzILOpPure *op_AND_35 = LOGAND(op_RSHIFT_33, SN(32, 0xffff));
	RzILOpPure *op_MUL_38 = MUL(CAST(32, MSB(CAST(16, MSB(op_AND_27), DUP(op_AND_27))), CAST(16, MSB(DUP(op_AND_27)), DUP(op_AND_27))), CAST(32, MSB(CAST(16, MSB(op_AND_35), DUP(op_AND_35))), CAST(16, MSB(DUP(op_AND_35)), DUP(op_AND_35))));
	RzILOpPure *op_SUB_40 = SUB(op_ADD_21, CAST(64, MSB(op_MUL_38), DUP(op_MUL_38)));
	RzILOpEffect *op_ASSIGN_41 = WRITE_REG(bundle, Rxx_op, op_SUB_40);

	RzILOpEffect *instruction_sequence = op_ASSIGN_41;
	return instruction_sequence;
}

// Rxx += cmpy(Rs,Rt):sat
RzILOpEffect *hex_il_op_m2_cmacs_s0(HexInsnPktBundle *bundle) {
	const HexInsn *hi = bundle->insn;
	HexPkt *pkt = bundle->pkt;
	// READ
	const HexOp *Rxx_op = ISA2REG(hi, 'x', false);

	const HexOp *Rs_op = ISA2REG(hi, 's', false);
	RzILOpPure *Rs = READ_REG(pkt, Rs_op, false);
	const HexOp *Rt_op = ISA2REG(hi, 't', false);
	RzILOpPure *Rt = READ_REG(pkt, Rt_op, false);

	// set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, ((ut32) 0x1));
	RzILOpEffect *set_usr_field_call_171 = hex_set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, CAST(32, IL_FALSE, SN(32, 1)));

	// HYB(gcc_expr_if ((sextract64(((ut64) ((st64) ((st32) ((Rxx >> 0x20) & 0xffffffff))) + (((st64) ((st32) ((st16) ((Rs >> 0x10) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x0) & 0xffff)))) << 0x0) + (((st64) ((st32) ((st16) ((Rs >> 0x0) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x10) & 0xffff)))) << 0x0)), 0x0, 0x20) == ((st64) ((st32) ((Rxx >> 0x20) & 0xffffffff))) + (((st64) ((st32) ((st16) ((Rs >> 0x10) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x0) & 0xffff)))) << 0x0) + (((st64) ((st32) ((st16) ((Rs >> 0x0) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x10) & 0xffff)))) << 0x0))) {{}} else {set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, ((ut32) 0x1))}, ((((st64) ((st32) ((Rxx >> 0x20) & 0xffffffff))) + (((st64) ((st32) ((st16) ((Rs >> 0x10) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x0) & 0xffff)))) << 0x0) + (((st64) ((st32) ((st16) ((Rs >> 0x0) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x10) & 0xffff)))) << 0x0) < ((st64) 0x0)) ? (-(0x1 << 0x1f)) : (0x1 << 0x1f) - ((st64) 0x1)));
	RzILOpPure *op_RSHIFT_14 = SHIFTRA(READ_REG(pkt, Rxx_op, false), SN(32, 0x20));
	RzILOpPure *op_AND_16 = LOGAND(op_RSHIFT_14, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_23 = SHIFTRA(Rs, SN(32, 16));
	RzILOpPure *op_AND_25 = LOGAND(op_RSHIFT_23, SN(32, 0xffff));
	RzILOpPure *op_RSHIFT_32 = SHIFTRA(Rt, SN(32, 0));
	RzILOpPure *op_AND_34 = LOGAND(op_RSHIFT_32, SN(32, 0xffff));
	RzILOpPure *op_MUL_37 = MUL(CAST(32, MSB(CAST(16, MSB(op_AND_25), DUP(op_AND_25))), CAST(16, MSB(DUP(op_AND_25)), DUP(op_AND_25))), CAST(32, MSB(CAST(16, MSB(op_AND_34), DUP(op_AND_34))), CAST(16, MSB(DUP(op_AND_34)), DUP(op_AND_34))));
	RzILOpPure *op_LSHIFT_40 = SHIFTL0(CAST(64, MSB(op_MUL_37), DUP(op_MUL_37)), SN(32, 0));
	RzILOpPure *op_ADD_41 = ADD(CAST(64, MSB(CAST(32, MSB(op_AND_16), DUP(op_AND_16))), CAST(32, MSB(DUP(op_AND_16)), DUP(op_AND_16))), op_LSHIFT_40);
	RzILOpPure *op_RSHIFT_45 = SHIFTRA(DUP(Rs), SN(32, 0));
	RzILOpPure *op_AND_47 = LOGAND(op_RSHIFT_45, SN(32, 0xffff));
	RzILOpPure *op_RSHIFT_53 = SHIFTRA(DUP(Rt), SN(32, 16));
	RzILOpPure *op_AND_55 = LOGAND(op_RSHIFT_53, SN(32, 0xffff));
	RzILOpPure *op_MUL_58 = MUL(CAST(32, MSB(CAST(16, MSB(op_AND_47), DUP(op_AND_47))), CAST(16, MSB(DUP(op_AND_47)), DUP(op_AND_47))), CAST(32, MSB(CAST(16, MSB(op_AND_55), DUP(op_AND_55))), CAST(16, MSB(DUP(op_AND_55)), DUP(op_AND_55))));
	RzILOpPure *op_LSHIFT_61 = SHIFTL0(CAST(64, MSB(op_MUL_58), DUP(op_MUL_58)), SN(32, 0));
	RzILOpPure *op_ADD_62 = ADD(op_ADD_41, op_LSHIFT_61);
	RzILOpPure *op_RSHIFT_71 = SHIFTRA(READ_REG(pkt, Rxx_op, false), SN(32, 0x20));
	RzILOpPure *op_AND_73 = LOGAND(op_RSHIFT_71, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_79 = SHIFTRA(DUP(Rs), SN(32, 16));
	RzILOpPure *op_AND_81 = LOGAND(op_RSHIFT_79, SN(32, 0xffff));
	RzILOpPure *op_RSHIFT_87 = SHIFTRA(DUP(Rt), SN(32, 0));
	RzILOpPure *op_AND_89 = LOGAND(op_RSHIFT_87, SN(32, 0xffff));
	RzILOpPure *op_MUL_92 = MUL(CAST(32, MSB(CAST(16, MSB(op_AND_81), DUP(op_AND_81))), CAST(16, MSB(DUP(op_AND_81)), DUP(op_AND_81))), CAST(32, MSB(CAST(16, MSB(op_AND_89), DUP(op_AND_89))), CAST(16, MSB(DUP(op_AND_89)), DUP(op_AND_89))));
	RzILOpPure *op_LSHIFT_95 = SHIFTL0(CAST(64, MSB(op_MUL_92), DUP(op_MUL_92)), SN(32, 0));
	RzILOpPure *op_ADD_96 = ADD(CAST(64, MSB(CAST(32, MSB(op_AND_73), DUP(op_AND_73))), CAST(32, MSB(DUP(op_AND_73)), DUP(op_AND_73))), op_LSHIFT_95);
	RzILOpPure *op_RSHIFT_100 = SHIFTRA(DUP(Rs), SN(32, 0));
	RzILOpPure *op_AND_102 = LOGAND(op_RSHIFT_100, SN(32, 0xffff));
	RzILOpPure *op_RSHIFT_108 = SHIFTRA(DUP(Rt), SN(32, 16));
	RzILOpPure *op_AND_110 = LOGAND(op_RSHIFT_108, SN(32, 0xffff));
	RzILOpPure *op_MUL_113 = MUL(CAST(32, MSB(CAST(16, MSB(op_AND_102), DUP(op_AND_102))), CAST(16, MSB(DUP(op_AND_102)), DUP(op_AND_102))), CAST(32, MSB(CAST(16, MSB(op_AND_110), DUP(op_AND_110))), CAST(16, MSB(DUP(op_AND_110)), DUP(op_AND_110))));
	RzILOpPure *op_LSHIFT_116 = SHIFTL0(CAST(64, MSB(op_MUL_113), DUP(op_MUL_113)), SN(32, 0));
	RzILOpPure *op_ADD_117 = ADD(op_ADD_96, op_LSHIFT_116);
	RzILOpPure *op_EQ_118 = EQ(SEXTRACT64(CAST(64, IL_FALSE, op_ADD_62), SN(32, 0), SN(32, 0x20)), op_ADD_117);
	RzILOpPure *op_RSHIFT_175 = SHIFTRA(READ_REG(pkt, Rxx_op, false), SN(32, 0x20));
	RzILOpPure *op_AND_177 = LOGAND(op_RSHIFT_175, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_183 = SHIFTRA(DUP(Rs), SN(32, 16));
	RzILOpPure *op_AND_185 = LOGAND(op_RSHIFT_183, SN(32, 0xffff));
	RzILOpPure *op_RSHIFT_191 = SHIFTRA(DUP(Rt), SN(32, 0));
	RzILOpPure *op_AND_193 = LOGAND(op_RSHIFT_191, SN(32, 0xffff));
	RzILOpPure *op_MUL_196 = MUL(CAST(32, MSB(CAST(16, MSB(op_AND_185), DUP(op_AND_185))), CAST(16, MSB(DUP(op_AND_185)), DUP(op_AND_185))), CAST(32, MSB(CAST(16, MSB(op_AND_193), DUP(op_AND_193))), CAST(16, MSB(DUP(op_AND_193)), DUP(op_AND_193))));
	RzILOpPure *op_LSHIFT_199 = SHIFTL0(CAST(64, MSB(op_MUL_196), DUP(op_MUL_196)), SN(32, 0));
	RzILOpPure *op_ADD_200 = ADD(CAST(64, MSB(CAST(32, MSB(op_AND_177), DUP(op_AND_177))), CAST(32, MSB(DUP(op_AND_177)), DUP(op_AND_177))), op_LSHIFT_199);
	RzILOpPure *op_RSHIFT_204 = SHIFTRA(DUP(Rs), SN(32, 0));
	RzILOpPure *op_AND_206 = LOGAND(op_RSHIFT_204, SN(32, 0xffff));
	RzILOpPure *op_RSHIFT_212 = SHIFTRA(DUP(Rt), SN(32, 16));
	RzILOpPure *op_AND_214 = LOGAND(op_RSHIFT_212, SN(32, 0xffff));
	RzILOpPure *op_MUL_217 = MUL(CAST(32, MSB(CAST(16, MSB(op_AND_206), DUP(op_AND_206))), CAST(16, MSB(DUP(op_AND_206)), DUP(op_AND_206))), CAST(32, MSB(CAST(16, MSB(op_AND_214), DUP(op_AND_214))), CAST(16, MSB(DUP(op_AND_214)), DUP(op_AND_214))));
	RzILOpPure *op_LSHIFT_220 = SHIFTL0(CAST(64, MSB(op_MUL_217), DUP(op_MUL_217)), SN(32, 0));
	RzILOpPure *op_ADD_221 = ADD(op_ADD_200, op_LSHIFT_220);
	RzILOpPure *op_LT_224 = SLT(op_ADD_221, CAST(64, MSB(SN(32, 0)), SN(32, 0)));
	RzILOpPure *op_LSHIFT_229 = SHIFTL0(SN(64, 1), SN(32, 31));
	RzILOpPure *op_NEG_230 = NEG(op_LSHIFT_229);
	RzILOpPure *op_LSHIFT_235 = SHIFTL0(SN(64, 1), SN(32, 31));
	RzILOpPure *op_SUB_238 = SUB(op_LSHIFT_235, CAST(64, MSB(SN(32, 1)), SN(32, 1)));
	RzILOpPure *cond_239 = ITE(op_LT_224, op_NEG_230, op_SUB_238);
	RzILOpEffect *gcc_expr_240 = BRANCH(op_EQ_118, EMPTY(), set_usr_field_call_171);

	// h_tmp232 = HYB(gcc_expr_if ((sextract64(((ut64) ((st64) ((st32) ((Rxx >> 0x20) & 0xffffffff))) + (((st64) ((st32) ((st16) ((Rs >> 0x10) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x0) & 0xffff)))) << 0x0) + (((st64) ((st32) ((st16) ((Rs >> 0x0) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x10) & 0xffff)))) << 0x0)), 0x0, 0x20) == ((st64) ((st32) ((Rxx >> 0x20) & 0xffffffff))) + (((st64) ((st32) ((st16) ((Rs >> 0x10) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x0) & 0xffff)))) << 0x0) + (((st64) ((st32) ((st16) ((Rs >> 0x0) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x10) & 0xffff)))) << 0x0))) {{}} else {set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, ((ut32) 0x1))}, ((((st64) ((st32) ((Rxx >> 0x20) & 0xffffffff))) + (((st64) ((st32) ((st16) ((Rs >> 0x10) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x0) & 0xffff)))) << 0x0) + (((st64) ((st32) ((st16) ((Rs >> 0x0) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x10) & 0xffff)))) << 0x0) < ((st64) 0x0)) ? (-(0x1 << 0x1f)) : (0x1 << 0x1f) - ((st64) 0x1)));
	RzILOpEffect *op_ASSIGN_hybrid_tmp_242 = SETL("h_tmp232", cond_239);

	// seq(HYB(gcc_expr_if ((sextract64(((ut64) ((st64) ((st32) ((Rxx > ...;
	RzILOpEffect *seq_243 = SEQN(2, gcc_expr_240, op_ASSIGN_hybrid_tmp_242);

	// Rxx = ((Rxx & (~(0xffffffff << 0x20))) | ((((sextract64(((ut64) ((st64) ((st32) ((Rxx >> 0x20) & 0xffffffff))) + (((st64) ((st32) ((st16) ((Rs >> 0x10) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x0) & 0xffff)))) << 0x0) + (((st64) ((st32) ((st16) ((Rs >> 0x0) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x10) & 0xffff)))) << 0x0)), 0x0, 0x20) == ((st64) ((st32) ((Rxx >> 0x20) & 0xffffffff))) + (((st64) ((st32) ((st16) ((Rs >> 0x10) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x0) & 0xffff)))) << 0x0) + (((st64) ((st32) ((st16) ((Rs >> 0x0) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x10) & 0xffff)))) << 0x0)) ? ((st64) ((st32) ((Rxx >> 0x20) & 0xffffffff))) + (((st64) ((st32) ((st16) ((Rs >> 0x10) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x0) & 0xffff)))) << 0x0) + (((st64) ((st32) ((st16) ((Rs >> 0x0) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x10) & 0xffff)))) << 0x0) : h_tmp232) & 0xffffffff) << 0x20));
	RzILOpPure *op_LSHIFT_5 = SHIFTL0(SN(64, 0xffffffff), SN(32, 0x20));
	RzILOpPure *op_NOT_6 = LOGNOT(op_LSHIFT_5);
	RzILOpPure *op_AND_7 = LOGAND(READ_REG(pkt, Rxx_op, false), op_NOT_6);
	RzILOpPure *op_RSHIFT_122 = SHIFTRA(READ_REG(pkt, Rxx_op, false), SN(32, 0x20));
	RzILOpPure *op_AND_124 = LOGAND(op_RSHIFT_122, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_130 = SHIFTRA(DUP(Rs), SN(32, 16));
	RzILOpPure *op_AND_132 = LOGAND(op_RSHIFT_130, SN(32, 0xffff));
	RzILOpPure *op_RSHIFT_138 = SHIFTRA(DUP(Rt), SN(32, 0));
	RzILOpPure *op_AND_140 = LOGAND(op_RSHIFT_138, SN(32, 0xffff));
	RzILOpPure *op_MUL_143 = MUL(CAST(32, MSB(CAST(16, MSB(op_AND_132), DUP(op_AND_132))), CAST(16, MSB(DUP(op_AND_132)), DUP(op_AND_132))), CAST(32, MSB(CAST(16, MSB(op_AND_140), DUP(op_AND_140))), CAST(16, MSB(DUP(op_AND_140)), DUP(op_AND_140))));
	RzILOpPure *op_LSHIFT_146 = SHIFTL0(CAST(64, MSB(op_MUL_143), DUP(op_MUL_143)), SN(32, 0));
	RzILOpPure *op_ADD_147 = ADD(CAST(64, MSB(CAST(32, MSB(op_AND_124), DUP(op_AND_124))), CAST(32, MSB(DUP(op_AND_124)), DUP(op_AND_124))), op_LSHIFT_146);
	RzILOpPure *op_RSHIFT_151 = SHIFTRA(DUP(Rs), SN(32, 0));
	RzILOpPure *op_AND_153 = LOGAND(op_RSHIFT_151, SN(32, 0xffff));
	RzILOpPure *op_RSHIFT_159 = SHIFTRA(DUP(Rt), SN(32, 16));
	RzILOpPure *op_AND_161 = LOGAND(op_RSHIFT_159, SN(32, 0xffff));
	RzILOpPure *op_MUL_164 = MUL(CAST(32, MSB(CAST(16, MSB(op_AND_153), DUP(op_AND_153))), CAST(16, MSB(DUP(op_AND_153)), DUP(op_AND_153))), CAST(32, MSB(CAST(16, MSB(op_AND_161), DUP(op_AND_161))), CAST(16, MSB(DUP(op_AND_161)), DUP(op_AND_161))));
	RzILOpPure *op_LSHIFT_167 = SHIFTL0(CAST(64, MSB(op_MUL_164), DUP(op_MUL_164)), SN(32, 0));
	RzILOpPure *op_ADD_168 = ADD(op_ADD_147, op_LSHIFT_167);
	RzILOpPure *cond_244 = ITE(DUP(op_EQ_118), op_ADD_168, VARL("h_tmp232"));
	RzILOpPure *op_AND_246 = LOGAND(cond_244, SN(64, 0xffffffff));
	RzILOpPure *op_LSHIFT_250 = SHIFTL0(op_AND_246, SN(32, 0x20));
	RzILOpPure *op_OR_251 = LOGOR(op_AND_7, op_LSHIFT_250);
	RzILOpEffect *op_ASSIGN_252 = WRITE_REG(bundle, Rxx_op, op_OR_251);

	// seq(seq(HYB(gcc_expr_if ((sextract64(((ut64) ((st64) ((st32) ((R ...;
	RzILOpEffect *seq_253 = SEQN(2, seq_243, op_ASSIGN_252);

	// set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, ((ut32) 0x1));
	RzILOpEffect *set_usr_field_call_423 = hex_set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, CAST(32, IL_FALSE, SN(32, 1)));

	// HYB(gcc_expr_if ((sextract64(((ut64) ((st64) ((st32) ((Rxx >> 0x0) & 0xffffffff))) + (((st64) ((st32) ((st16) ((Rs >> 0x0) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x0) & 0xffff)))) << 0x0) - (((st64) ((st32) ((st16) ((Rs >> 0x10) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x10) & 0xffff)))) << 0x0)), 0x0, 0x20) == ((st64) ((st32) ((Rxx >> 0x0) & 0xffffffff))) + (((st64) ((st32) ((st16) ((Rs >> 0x0) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x0) & 0xffff)))) << 0x0) - (((st64) ((st32) ((st16) ((Rs >> 0x10) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x10) & 0xffff)))) << 0x0))) {{}} else {set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, ((ut32) 0x1))}, ((((st64) ((st32) ((Rxx >> 0x0) & 0xffffffff))) + (((st64) ((st32) ((st16) ((Rs >> 0x0) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x0) & 0xffff)))) << 0x0) - (((st64) ((st32) ((st16) ((Rs >> 0x10) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x10) & 0xffff)))) << 0x0) < ((st64) 0x0)) ? (-(0x1 << 0x1f)) : (0x1 << 0x1f) - ((st64) 0x1)));
	RzILOpPure *op_RSHIFT_268 = SHIFTRA(READ_REG(pkt, Rxx_op, false), SN(32, 0));
	RzILOpPure *op_AND_270 = LOGAND(op_RSHIFT_268, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_276 = SHIFTRA(DUP(Rs), SN(32, 0));
	RzILOpPure *op_AND_278 = LOGAND(op_RSHIFT_276, SN(32, 0xffff));
	RzILOpPure *op_RSHIFT_284 = SHIFTRA(DUP(Rt), SN(32, 0));
	RzILOpPure *op_AND_286 = LOGAND(op_RSHIFT_284, SN(32, 0xffff));
	RzILOpPure *op_MUL_289 = MUL(CAST(32, MSB(CAST(16, MSB(op_AND_278), DUP(op_AND_278))), CAST(16, MSB(DUP(op_AND_278)), DUP(op_AND_278))), CAST(32, MSB(CAST(16, MSB(op_AND_286), DUP(op_AND_286))), CAST(16, MSB(DUP(op_AND_286)), DUP(op_AND_286))));
	RzILOpPure *op_LSHIFT_292 = SHIFTL0(CAST(64, MSB(op_MUL_289), DUP(op_MUL_289)), SN(32, 0));
	RzILOpPure *op_ADD_293 = ADD(CAST(64, MSB(CAST(32, MSB(op_AND_270), DUP(op_AND_270))), CAST(32, MSB(DUP(op_AND_270)), DUP(op_AND_270))), op_LSHIFT_292);
	RzILOpPure *op_RSHIFT_297 = SHIFTRA(DUP(Rs), SN(32, 16));
	RzILOpPure *op_AND_299 = LOGAND(op_RSHIFT_297, SN(32, 0xffff));
	RzILOpPure *op_RSHIFT_305 = SHIFTRA(DUP(Rt), SN(32, 16));
	RzILOpPure *op_AND_307 = LOGAND(op_RSHIFT_305, SN(32, 0xffff));
	RzILOpPure *op_MUL_310 = MUL(CAST(32, MSB(CAST(16, MSB(op_AND_299), DUP(op_AND_299))), CAST(16, MSB(DUP(op_AND_299)), DUP(op_AND_299))), CAST(32, MSB(CAST(16, MSB(op_AND_307), DUP(op_AND_307))), CAST(16, MSB(DUP(op_AND_307)), DUP(op_AND_307))));
	RzILOpPure *op_LSHIFT_313 = SHIFTL0(CAST(64, MSB(op_MUL_310), DUP(op_MUL_310)), SN(32, 0));
	RzILOpPure *op_SUB_314 = SUB(op_ADD_293, op_LSHIFT_313);
	RzILOpPure *op_RSHIFT_323 = SHIFTRA(READ_REG(pkt, Rxx_op, false), SN(32, 0));
	RzILOpPure *op_AND_325 = LOGAND(op_RSHIFT_323, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_331 = SHIFTRA(DUP(Rs), SN(32, 0));
	RzILOpPure *op_AND_333 = LOGAND(op_RSHIFT_331, SN(32, 0xffff));
	RzILOpPure *op_RSHIFT_339 = SHIFTRA(DUP(Rt), SN(32, 0));
	RzILOpPure *op_AND_341 = LOGAND(op_RSHIFT_339, SN(32, 0xffff));
	RzILOpPure *op_MUL_344 = MUL(CAST(32, MSB(CAST(16, MSB(op_AND_333), DUP(op_AND_333))), CAST(16, MSB(DUP(op_AND_333)), DUP(op_AND_333))), CAST(32, MSB(CAST(16, MSB(op_AND_341), DUP(op_AND_341))), CAST(16, MSB(DUP(op_AND_341)), DUP(op_AND_341))));
	RzILOpPure *op_LSHIFT_347 = SHIFTL0(CAST(64, MSB(op_MUL_344), DUP(op_MUL_344)), SN(32, 0));
	RzILOpPure *op_ADD_348 = ADD(CAST(64, MSB(CAST(32, MSB(op_AND_325), DUP(op_AND_325))), CAST(32, MSB(DUP(op_AND_325)), DUP(op_AND_325))), op_LSHIFT_347);
	RzILOpPure *op_RSHIFT_352 = SHIFTRA(DUP(Rs), SN(32, 16));
	RzILOpPure *op_AND_354 = LOGAND(op_RSHIFT_352, SN(32, 0xffff));
	RzILOpPure *op_RSHIFT_360 = SHIFTRA(DUP(Rt), SN(32, 16));
	RzILOpPure *op_AND_362 = LOGAND(op_RSHIFT_360, SN(32, 0xffff));
	RzILOpPure *op_MUL_365 = MUL(CAST(32, MSB(CAST(16, MSB(op_AND_354), DUP(op_AND_354))), CAST(16, MSB(DUP(op_AND_354)), DUP(op_AND_354))), CAST(32, MSB(CAST(16, MSB(op_AND_362), DUP(op_AND_362))), CAST(16, MSB(DUP(op_AND_362)), DUP(op_AND_362))));
	RzILOpPure *op_LSHIFT_368 = SHIFTL0(CAST(64, MSB(op_MUL_365), DUP(op_MUL_365)), SN(32, 0));
	RzILOpPure *op_SUB_369 = SUB(op_ADD_348, op_LSHIFT_368);
	RzILOpPure *op_EQ_370 = EQ(SEXTRACT64(CAST(64, IL_FALSE, op_SUB_314), SN(32, 0), SN(32, 0x20)), op_SUB_369);
	RzILOpPure *op_RSHIFT_427 = SHIFTRA(READ_REG(pkt, Rxx_op, false), SN(32, 0));
	RzILOpPure *op_AND_429 = LOGAND(op_RSHIFT_427, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_435 = SHIFTRA(DUP(Rs), SN(32, 0));
	RzILOpPure *op_AND_437 = LOGAND(op_RSHIFT_435, SN(32, 0xffff));
	RzILOpPure *op_RSHIFT_443 = SHIFTRA(DUP(Rt), SN(32, 0));
	RzILOpPure *op_AND_445 = LOGAND(op_RSHIFT_443, SN(32, 0xffff));
	RzILOpPure *op_MUL_448 = MUL(CAST(32, MSB(CAST(16, MSB(op_AND_437), DUP(op_AND_437))), CAST(16, MSB(DUP(op_AND_437)), DUP(op_AND_437))), CAST(32, MSB(CAST(16, MSB(op_AND_445), DUP(op_AND_445))), CAST(16, MSB(DUP(op_AND_445)), DUP(op_AND_445))));
	RzILOpPure *op_LSHIFT_451 = SHIFTL0(CAST(64, MSB(op_MUL_448), DUP(op_MUL_448)), SN(32, 0));
	RzILOpPure *op_ADD_452 = ADD(CAST(64, MSB(CAST(32, MSB(op_AND_429), DUP(op_AND_429))), CAST(32, MSB(DUP(op_AND_429)), DUP(op_AND_429))), op_LSHIFT_451);
	RzILOpPure *op_RSHIFT_456 = SHIFTRA(DUP(Rs), SN(32, 16));
	RzILOpPure *op_AND_458 = LOGAND(op_RSHIFT_456, SN(32, 0xffff));
	RzILOpPure *op_RSHIFT_464 = SHIFTRA(DUP(Rt), SN(32, 16));
	RzILOpPure *op_AND_466 = LOGAND(op_RSHIFT_464, SN(32, 0xffff));
	RzILOpPure *op_MUL_469 = MUL(CAST(32, MSB(CAST(16, MSB(op_AND_458), DUP(op_AND_458))), CAST(16, MSB(DUP(op_AND_458)), DUP(op_AND_458))), CAST(32, MSB(CAST(16, MSB(op_AND_466), DUP(op_AND_466))), CAST(16, MSB(DUP(op_AND_466)), DUP(op_AND_466))));
	RzILOpPure *op_LSHIFT_472 = SHIFTL0(CAST(64, MSB(op_MUL_469), DUP(op_MUL_469)), SN(32, 0));
	RzILOpPure *op_SUB_473 = SUB(op_ADD_452, op_LSHIFT_472);
	RzILOpPure *op_LT_476 = SLT(op_SUB_473, CAST(64, MSB(SN(32, 0)), SN(32, 0)));
	RzILOpPure *op_LSHIFT_481 = SHIFTL0(SN(64, 1), SN(32, 31));
	RzILOpPure *op_NEG_482 = NEG(op_LSHIFT_481);
	RzILOpPure *op_LSHIFT_487 = SHIFTL0(SN(64, 1), SN(32, 31));
	RzILOpPure *op_SUB_490 = SUB(op_LSHIFT_487, CAST(64, MSB(SN(32, 1)), SN(32, 1)));
	RzILOpPure *cond_491 = ITE(op_LT_476, op_NEG_482, op_SUB_490);
	RzILOpEffect *gcc_expr_492 = BRANCH(op_EQ_370, EMPTY(), set_usr_field_call_423);

	// h_tmp233 = HYB(gcc_expr_if ((sextract64(((ut64) ((st64) ((st32) ((Rxx >> 0x0) & 0xffffffff))) + (((st64) ((st32) ((st16) ((Rs >> 0x0) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x0) & 0xffff)))) << 0x0) - (((st64) ((st32) ((st16) ((Rs >> 0x10) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x10) & 0xffff)))) << 0x0)), 0x0, 0x20) == ((st64) ((st32) ((Rxx >> 0x0) & 0xffffffff))) + (((st64) ((st32) ((st16) ((Rs >> 0x0) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x0) & 0xffff)))) << 0x0) - (((st64) ((st32) ((st16) ((Rs >> 0x10) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x10) & 0xffff)))) << 0x0))) {{}} else {set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, ((ut32) 0x1))}, ((((st64) ((st32) ((Rxx >> 0x0) & 0xffffffff))) + (((st64) ((st32) ((st16) ((Rs >> 0x0) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x0) & 0xffff)))) << 0x0) - (((st64) ((st32) ((st16) ((Rs >> 0x10) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x10) & 0xffff)))) << 0x0) < ((st64) 0x0)) ? (-(0x1 << 0x1f)) : (0x1 << 0x1f) - ((st64) 0x1)));
	RzILOpEffect *op_ASSIGN_hybrid_tmp_494 = SETL("h_tmp233", cond_491);

	// seq(HYB(gcc_expr_if ((sextract64(((ut64) ((st64) ((st32) ((Rxx > ...;
	RzILOpEffect *seq_495 = SEQN(2, gcc_expr_492, op_ASSIGN_hybrid_tmp_494);

	// Rxx = ((Rxx & (~(0xffffffff << 0x0))) | ((((sextract64(((ut64) ((st64) ((st32) ((Rxx >> 0x0) & 0xffffffff))) + (((st64) ((st32) ((st16) ((Rs >> 0x0) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x0) & 0xffff)))) << 0x0) - (((st64) ((st32) ((st16) ((Rs >> 0x10) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x10) & 0xffff)))) << 0x0)), 0x0, 0x20) == ((st64) ((st32) ((Rxx >> 0x0) & 0xffffffff))) + (((st64) ((st32) ((st16) ((Rs >> 0x0) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x0) & 0xffff)))) << 0x0) - (((st64) ((st32) ((st16) ((Rs >> 0x10) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x10) & 0xffff)))) << 0x0)) ? ((st64) ((st32) ((Rxx >> 0x0) & 0xffffffff))) + (((st64) ((st32) ((st16) ((Rs >> 0x0) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x0) & 0xffff)))) << 0x0) - (((st64) ((st32) ((st16) ((Rs >> 0x10) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x10) & 0xffff)))) << 0x0) : h_tmp233) & 0xffffffff) << 0x0));
	RzILOpPure *op_LSHIFT_259 = SHIFTL0(SN(64, 0xffffffff), SN(32, 0));
	RzILOpPure *op_NOT_260 = LOGNOT(op_LSHIFT_259);
	RzILOpPure *op_AND_261 = LOGAND(READ_REG(pkt, Rxx_op, false), op_NOT_260);
	RzILOpPure *op_RSHIFT_374 = SHIFTRA(READ_REG(pkt, Rxx_op, false), SN(32, 0));
	RzILOpPure *op_AND_376 = LOGAND(op_RSHIFT_374, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_382 = SHIFTRA(DUP(Rs), SN(32, 0));
	RzILOpPure *op_AND_384 = LOGAND(op_RSHIFT_382, SN(32, 0xffff));
	RzILOpPure *op_RSHIFT_390 = SHIFTRA(DUP(Rt), SN(32, 0));
	RzILOpPure *op_AND_392 = LOGAND(op_RSHIFT_390, SN(32, 0xffff));
	RzILOpPure *op_MUL_395 = MUL(CAST(32, MSB(CAST(16, MSB(op_AND_384), DUP(op_AND_384))), CAST(16, MSB(DUP(op_AND_384)), DUP(op_AND_384))), CAST(32, MSB(CAST(16, MSB(op_AND_392), DUP(op_AND_392))), CAST(16, MSB(DUP(op_AND_392)), DUP(op_AND_392))));
	RzILOpPure *op_LSHIFT_398 = SHIFTL0(CAST(64, MSB(op_MUL_395), DUP(op_MUL_395)), SN(32, 0));
	RzILOpPure *op_ADD_399 = ADD(CAST(64, MSB(CAST(32, MSB(op_AND_376), DUP(op_AND_376))), CAST(32, MSB(DUP(op_AND_376)), DUP(op_AND_376))), op_LSHIFT_398);
	RzILOpPure *op_RSHIFT_403 = SHIFTRA(DUP(Rs), SN(32, 16));
	RzILOpPure *op_AND_405 = LOGAND(op_RSHIFT_403, SN(32, 0xffff));
	RzILOpPure *op_RSHIFT_411 = SHIFTRA(DUP(Rt), SN(32, 16));
	RzILOpPure *op_AND_413 = LOGAND(op_RSHIFT_411, SN(32, 0xffff));
	RzILOpPure *op_MUL_416 = MUL(CAST(32, MSB(CAST(16, MSB(op_AND_405), DUP(op_AND_405))), CAST(16, MSB(DUP(op_AND_405)), DUP(op_AND_405))), CAST(32, MSB(CAST(16, MSB(op_AND_413), DUP(op_AND_413))), CAST(16, MSB(DUP(op_AND_413)), DUP(op_AND_413))));
	RzILOpPure *op_LSHIFT_419 = SHIFTL0(CAST(64, MSB(op_MUL_416), DUP(op_MUL_416)), SN(32, 0));
	RzILOpPure *op_SUB_420 = SUB(op_ADD_399, op_LSHIFT_419);
	RzILOpPure *cond_496 = ITE(DUP(op_EQ_370), op_SUB_420, VARL("h_tmp233"));
	RzILOpPure *op_AND_498 = LOGAND(cond_496, SN(64, 0xffffffff));
	RzILOpPure *op_LSHIFT_502 = SHIFTL0(op_AND_498, SN(32, 0));
	RzILOpPure *op_OR_503 = LOGOR(op_AND_261, op_LSHIFT_502);
	RzILOpEffect *op_ASSIGN_504 = WRITE_REG(bundle, Rxx_op, op_OR_503);

	// seq(seq(HYB(gcc_expr_if ((sextract64(((ut64) ((st64) ((st32) ((R ...;
	RzILOpEffect *seq_505 = SEQN(2, seq_495, op_ASSIGN_504);

	RzILOpEffect *instruction_sequence = SEQN(2, seq_253, seq_505);
	return instruction_sequence;
}

// Rxx += cmpy(Rs,Rt):<<1:sat
RzILOpEffect *hex_il_op_m2_cmacs_s1(HexInsnPktBundle *bundle) {
	const HexInsn *hi = bundle->insn;
	HexPkt *pkt = bundle->pkt;
	// READ
	const HexOp *Rxx_op = ISA2REG(hi, 'x', false);

	const HexOp *Rs_op = ISA2REG(hi, 's', false);
	RzILOpPure *Rs = READ_REG(pkt, Rs_op, false);
	const HexOp *Rt_op = ISA2REG(hi, 't', false);
	RzILOpPure *Rt = READ_REG(pkt, Rt_op, false);

	// set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, ((ut32) 0x1));
	RzILOpEffect *set_usr_field_call_171 = hex_set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, CAST(32, IL_FALSE, SN(32, 1)));

	// HYB(gcc_expr_if ((sextract64(((ut64) ((st64) ((st32) ((Rxx >> 0x20) & 0xffffffff))) + (((st64) ((st32) ((st16) ((Rs >> 0x10) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x0) & 0xffff)))) << 0x1) + (((st64) ((st32) ((st16) ((Rs >> 0x0) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x10) & 0xffff)))) << 0x1)), 0x0, 0x20) == ((st64) ((st32) ((Rxx >> 0x20) & 0xffffffff))) + (((st64) ((st32) ((st16) ((Rs >> 0x10) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x0) & 0xffff)))) << 0x1) + (((st64) ((st32) ((st16) ((Rs >> 0x0) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x10) & 0xffff)))) << 0x1))) {{}} else {set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, ((ut32) 0x1))}, ((((st64) ((st32) ((Rxx >> 0x20) & 0xffffffff))) + (((st64) ((st32) ((st16) ((Rs >> 0x10) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x0) & 0xffff)))) << 0x1) + (((st64) ((st32) ((st16) ((Rs >> 0x0) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x10) & 0xffff)))) << 0x1) < ((st64) 0x0)) ? (-(0x1 << 0x1f)) : (0x1 << 0x1f) - ((st64) 0x1)));
	RzILOpPure *op_RSHIFT_14 = SHIFTRA(READ_REG(pkt, Rxx_op, false), SN(32, 0x20));
	RzILOpPure *op_AND_16 = LOGAND(op_RSHIFT_14, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_23 = SHIFTRA(Rs, SN(32, 16));
	RzILOpPure *op_AND_25 = LOGAND(op_RSHIFT_23, SN(32, 0xffff));
	RzILOpPure *op_RSHIFT_32 = SHIFTRA(Rt, SN(32, 0));
	RzILOpPure *op_AND_34 = LOGAND(op_RSHIFT_32, SN(32, 0xffff));
	RzILOpPure *op_MUL_37 = MUL(CAST(32, MSB(CAST(16, MSB(op_AND_25), DUP(op_AND_25))), CAST(16, MSB(DUP(op_AND_25)), DUP(op_AND_25))), CAST(32, MSB(CAST(16, MSB(op_AND_34), DUP(op_AND_34))), CAST(16, MSB(DUP(op_AND_34)), DUP(op_AND_34))));
	RzILOpPure *op_LSHIFT_40 = SHIFTL0(CAST(64, MSB(op_MUL_37), DUP(op_MUL_37)), SN(32, 1));
	RzILOpPure *op_ADD_41 = ADD(CAST(64, MSB(CAST(32, MSB(op_AND_16), DUP(op_AND_16))), CAST(32, MSB(DUP(op_AND_16)), DUP(op_AND_16))), op_LSHIFT_40);
	RzILOpPure *op_RSHIFT_45 = SHIFTRA(DUP(Rs), SN(32, 0));
	RzILOpPure *op_AND_47 = LOGAND(op_RSHIFT_45, SN(32, 0xffff));
	RzILOpPure *op_RSHIFT_53 = SHIFTRA(DUP(Rt), SN(32, 16));
	RzILOpPure *op_AND_55 = LOGAND(op_RSHIFT_53, SN(32, 0xffff));
	RzILOpPure *op_MUL_58 = MUL(CAST(32, MSB(CAST(16, MSB(op_AND_47), DUP(op_AND_47))), CAST(16, MSB(DUP(op_AND_47)), DUP(op_AND_47))), CAST(32, MSB(CAST(16, MSB(op_AND_55), DUP(op_AND_55))), CAST(16, MSB(DUP(op_AND_55)), DUP(op_AND_55))));
	RzILOpPure *op_LSHIFT_61 = SHIFTL0(CAST(64, MSB(op_MUL_58), DUP(op_MUL_58)), SN(32, 1));
	RzILOpPure *op_ADD_62 = ADD(op_ADD_41, op_LSHIFT_61);
	RzILOpPure *op_RSHIFT_71 = SHIFTRA(READ_REG(pkt, Rxx_op, false), SN(32, 0x20));
	RzILOpPure *op_AND_73 = LOGAND(op_RSHIFT_71, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_79 = SHIFTRA(DUP(Rs), SN(32, 16));
	RzILOpPure *op_AND_81 = LOGAND(op_RSHIFT_79, SN(32, 0xffff));
	RzILOpPure *op_RSHIFT_87 = SHIFTRA(DUP(Rt), SN(32, 0));
	RzILOpPure *op_AND_89 = LOGAND(op_RSHIFT_87, SN(32, 0xffff));
	RzILOpPure *op_MUL_92 = MUL(CAST(32, MSB(CAST(16, MSB(op_AND_81), DUP(op_AND_81))), CAST(16, MSB(DUP(op_AND_81)), DUP(op_AND_81))), CAST(32, MSB(CAST(16, MSB(op_AND_89), DUP(op_AND_89))), CAST(16, MSB(DUP(op_AND_89)), DUP(op_AND_89))));
	RzILOpPure *op_LSHIFT_95 = SHIFTL0(CAST(64, MSB(op_MUL_92), DUP(op_MUL_92)), SN(32, 1));
	RzILOpPure *op_ADD_96 = ADD(CAST(64, MSB(CAST(32, MSB(op_AND_73), DUP(op_AND_73))), CAST(32, MSB(DUP(op_AND_73)), DUP(op_AND_73))), op_LSHIFT_95);
	RzILOpPure *op_RSHIFT_100 = SHIFTRA(DUP(Rs), SN(32, 0));
	RzILOpPure *op_AND_102 = LOGAND(op_RSHIFT_100, SN(32, 0xffff));
	RzILOpPure *op_RSHIFT_108 = SHIFTRA(DUP(Rt), SN(32, 16));
	RzILOpPure *op_AND_110 = LOGAND(op_RSHIFT_108, SN(32, 0xffff));
	RzILOpPure *op_MUL_113 = MUL(CAST(32, MSB(CAST(16, MSB(op_AND_102), DUP(op_AND_102))), CAST(16, MSB(DUP(op_AND_102)), DUP(op_AND_102))), CAST(32, MSB(CAST(16, MSB(op_AND_110), DUP(op_AND_110))), CAST(16, MSB(DUP(op_AND_110)), DUP(op_AND_110))));
	RzILOpPure *op_LSHIFT_116 = SHIFTL0(CAST(64, MSB(op_MUL_113), DUP(op_MUL_113)), SN(32, 1));
	RzILOpPure *op_ADD_117 = ADD(op_ADD_96, op_LSHIFT_116);
	RzILOpPure *op_EQ_118 = EQ(SEXTRACT64(CAST(64, IL_FALSE, op_ADD_62), SN(32, 0), SN(32, 0x20)), op_ADD_117);
	RzILOpPure *op_RSHIFT_175 = SHIFTRA(READ_REG(pkt, Rxx_op, false), SN(32, 0x20));
	RzILOpPure *op_AND_177 = LOGAND(op_RSHIFT_175, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_183 = SHIFTRA(DUP(Rs), SN(32, 16));
	RzILOpPure *op_AND_185 = LOGAND(op_RSHIFT_183, SN(32, 0xffff));
	RzILOpPure *op_RSHIFT_191 = SHIFTRA(DUP(Rt), SN(32, 0));
	RzILOpPure *op_AND_193 = LOGAND(op_RSHIFT_191, SN(32, 0xffff));
	RzILOpPure *op_MUL_196 = MUL(CAST(32, MSB(CAST(16, MSB(op_AND_185), DUP(op_AND_185))), CAST(16, MSB(DUP(op_AND_185)), DUP(op_AND_185))), CAST(32, MSB(CAST(16, MSB(op_AND_193), DUP(op_AND_193))), CAST(16, MSB(DUP(op_AND_193)), DUP(op_AND_193))));
	RzILOpPure *op_LSHIFT_199 = SHIFTL0(CAST(64, MSB(op_MUL_196), DUP(op_MUL_196)), SN(32, 1));
	RzILOpPure *op_ADD_200 = ADD(CAST(64, MSB(CAST(32, MSB(op_AND_177), DUP(op_AND_177))), CAST(32, MSB(DUP(op_AND_177)), DUP(op_AND_177))), op_LSHIFT_199);
	RzILOpPure *op_RSHIFT_204 = SHIFTRA(DUP(Rs), SN(32, 0));
	RzILOpPure *op_AND_206 = LOGAND(op_RSHIFT_204, SN(32, 0xffff));
	RzILOpPure *op_RSHIFT_212 = SHIFTRA(DUP(Rt), SN(32, 16));
	RzILOpPure *op_AND_214 = LOGAND(op_RSHIFT_212, SN(32, 0xffff));
	RzILOpPure *op_MUL_217 = MUL(CAST(32, MSB(CAST(16, MSB(op_AND_206), DUP(op_AND_206))), CAST(16, MSB(DUP(op_AND_206)), DUP(op_AND_206))), CAST(32, MSB(CAST(16, MSB(op_AND_214), DUP(op_AND_214))), CAST(16, MSB(DUP(op_AND_214)), DUP(op_AND_214))));
	RzILOpPure *op_LSHIFT_220 = SHIFTL0(CAST(64, MSB(op_MUL_217), DUP(op_MUL_217)), SN(32, 1));
	RzILOpPure *op_ADD_221 = ADD(op_ADD_200, op_LSHIFT_220);
	RzILOpPure *op_LT_224 = SLT(op_ADD_221, CAST(64, MSB(SN(32, 0)), SN(32, 0)));
	RzILOpPure *op_LSHIFT_229 = SHIFTL0(SN(64, 1), SN(32, 31));
	RzILOpPure *op_NEG_230 = NEG(op_LSHIFT_229);
	RzILOpPure *op_LSHIFT_235 = SHIFTL0(SN(64, 1), SN(32, 31));
	RzILOpPure *op_SUB_238 = SUB(op_LSHIFT_235, CAST(64, MSB(SN(32, 1)), SN(32, 1)));
	RzILOpPure *cond_239 = ITE(op_LT_224, op_NEG_230, op_SUB_238);
	RzILOpEffect *gcc_expr_240 = BRANCH(op_EQ_118, EMPTY(), set_usr_field_call_171);

	// h_tmp234 = HYB(gcc_expr_if ((sextract64(((ut64) ((st64) ((st32) ((Rxx >> 0x20) & 0xffffffff))) + (((st64) ((st32) ((st16) ((Rs >> 0x10) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x0) & 0xffff)))) << 0x1) + (((st64) ((st32) ((st16) ((Rs >> 0x0) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x10) & 0xffff)))) << 0x1)), 0x0, 0x20) == ((st64) ((st32) ((Rxx >> 0x20) & 0xffffffff))) + (((st64) ((st32) ((st16) ((Rs >> 0x10) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x0) & 0xffff)))) << 0x1) + (((st64) ((st32) ((st16) ((Rs >> 0x0) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x10) & 0xffff)))) << 0x1))) {{}} else {set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, ((ut32) 0x1))}, ((((st64) ((st32) ((Rxx >> 0x20) & 0xffffffff))) + (((st64) ((st32) ((st16) ((Rs >> 0x10) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x0) & 0xffff)))) << 0x1) + (((st64) ((st32) ((st16) ((Rs >> 0x0) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x10) & 0xffff)))) << 0x1) < ((st64) 0x0)) ? (-(0x1 << 0x1f)) : (0x1 << 0x1f) - ((st64) 0x1)));
	RzILOpEffect *op_ASSIGN_hybrid_tmp_242 = SETL("h_tmp234", cond_239);

	// seq(HYB(gcc_expr_if ((sextract64(((ut64) ((st64) ((st32) ((Rxx > ...;
	RzILOpEffect *seq_243 = SEQN(2, gcc_expr_240, op_ASSIGN_hybrid_tmp_242);

	// Rxx = ((Rxx & (~(0xffffffff << 0x20))) | ((((sextract64(((ut64) ((st64) ((st32) ((Rxx >> 0x20) & 0xffffffff))) + (((st64) ((st32) ((st16) ((Rs >> 0x10) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x0) & 0xffff)))) << 0x1) + (((st64) ((st32) ((st16) ((Rs >> 0x0) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x10) & 0xffff)))) << 0x1)), 0x0, 0x20) == ((st64) ((st32) ((Rxx >> 0x20) & 0xffffffff))) + (((st64) ((st32) ((st16) ((Rs >> 0x10) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x0) & 0xffff)))) << 0x1) + (((st64) ((st32) ((st16) ((Rs >> 0x0) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x10) & 0xffff)))) << 0x1)) ? ((st64) ((st32) ((Rxx >> 0x20) & 0xffffffff))) + (((st64) ((st32) ((st16) ((Rs >> 0x10) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x0) & 0xffff)))) << 0x1) + (((st64) ((st32) ((st16) ((Rs >> 0x0) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x10) & 0xffff)))) << 0x1) : h_tmp234) & 0xffffffff) << 0x20));
	RzILOpPure *op_LSHIFT_5 = SHIFTL0(SN(64, 0xffffffff), SN(32, 0x20));
	RzILOpPure *op_NOT_6 = LOGNOT(op_LSHIFT_5);
	RzILOpPure *op_AND_7 = LOGAND(READ_REG(pkt, Rxx_op, false), op_NOT_6);
	RzILOpPure *op_RSHIFT_122 = SHIFTRA(READ_REG(pkt, Rxx_op, false), SN(32, 0x20));
	RzILOpPure *op_AND_124 = LOGAND(op_RSHIFT_122, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_130 = SHIFTRA(DUP(Rs), SN(32, 16));
	RzILOpPure *op_AND_132 = LOGAND(op_RSHIFT_130, SN(32, 0xffff));
	RzILOpPure *op_RSHIFT_138 = SHIFTRA(DUP(Rt), SN(32, 0));
	RzILOpPure *op_AND_140 = LOGAND(op_RSHIFT_138, SN(32, 0xffff));
	RzILOpPure *op_MUL_143 = MUL(CAST(32, MSB(CAST(16, MSB(op_AND_132), DUP(op_AND_132))), CAST(16, MSB(DUP(op_AND_132)), DUP(op_AND_132))), CAST(32, MSB(CAST(16, MSB(op_AND_140), DUP(op_AND_140))), CAST(16, MSB(DUP(op_AND_140)), DUP(op_AND_140))));
	RzILOpPure *op_LSHIFT_146 = SHIFTL0(CAST(64, MSB(op_MUL_143), DUP(op_MUL_143)), SN(32, 1));
	RzILOpPure *op_ADD_147 = ADD(CAST(64, MSB(CAST(32, MSB(op_AND_124), DUP(op_AND_124))), CAST(32, MSB(DUP(op_AND_124)), DUP(op_AND_124))), op_LSHIFT_146);
	RzILOpPure *op_RSHIFT_151 = SHIFTRA(DUP(Rs), SN(32, 0));
	RzILOpPure *op_AND_153 = LOGAND(op_RSHIFT_151, SN(32, 0xffff));
	RzILOpPure *op_RSHIFT_159 = SHIFTRA(DUP(Rt), SN(32, 16));
	RzILOpPure *op_AND_161 = LOGAND(op_RSHIFT_159, SN(32, 0xffff));
	RzILOpPure *op_MUL_164 = MUL(CAST(32, MSB(CAST(16, MSB(op_AND_153), DUP(op_AND_153))), CAST(16, MSB(DUP(op_AND_153)), DUP(op_AND_153))), CAST(32, MSB(CAST(16, MSB(op_AND_161), DUP(op_AND_161))), CAST(16, MSB(DUP(op_AND_161)), DUP(op_AND_161))));
	RzILOpPure *op_LSHIFT_167 = SHIFTL0(CAST(64, MSB(op_MUL_164), DUP(op_MUL_164)), SN(32, 1));
	RzILOpPure *op_ADD_168 = ADD(op_ADD_147, op_LSHIFT_167);
	RzILOpPure *cond_244 = ITE(DUP(op_EQ_118), op_ADD_168, VARL("h_tmp234"));
	RzILOpPure *op_AND_246 = LOGAND(cond_244, SN(64, 0xffffffff));
	RzILOpPure *op_LSHIFT_250 = SHIFTL0(op_AND_246, SN(32, 0x20));
	RzILOpPure *op_OR_251 = LOGOR(op_AND_7, op_LSHIFT_250);
	RzILOpEffect *op_ASSIGN_252 = WRITE_REG(bundle, Rxx_op, op_OR_251);

	// seq(seq(HYB(gcc_expr_if ((sextract64(((ut64) ((st64) ((st32) ((R ...;
	RzILOpEffect *seq_253 = SEQN(2, seq_243, op_ASSIGN_252);

	// set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, ((ut32) 0x1));
	RzILOpEffect *set_usr_field_call_423 = hex_set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, CAST(32, IL_FALSE, SN(32, 1)));

	// HYB(gcc_expr_if ((sextract64(((ut64) ((st64) ((st32) ((Rxx >> 0x0) & 0xffffffff))) + (((st64) ((st32) ((st16) ((Rs >> 0x0) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x0) & 0xffff)))) << 0x1) - (((st64) ((st32) ((st16) ((Rs >> 0x10) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x10) & 0xffff)))) << 0x1)), 0x0, 0x20) == ((st64) ((st32) ((Rxx >> 0x0) & 0xffffffff))) + (((st64) ((st32) ((st16) ((Rs >> 0x0) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x0) & 0xffff)))) << 0x1) - (((st64) ((st32) ((st16) ((Rs >> 0x10) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x10) & 0xffff)))) << 0x1))) {{}} else {set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, ((ut32) 0x1))}, ((((st64) ((st32) ((Rxx >> 0x0) & 0xffffffff))) + (((st64) ((st32) ((st16) ((Rs >> 0x0) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x0) & 0xffff)))) << 0x1) - (((st64) ((st32) ((st16) ((Rs >> 0x10) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x10) & 0xffff)))) << 0x1) < ((st64) 0x0)) ? (-(0x1 << 0x1f)) : (0x1 << 0x1f) - ((st64) 0x1)));
	RzILOpPure *op_RSHIFT_268 = SHIFTRA(READ_REG(pkt, Rxx_op, false), SN(32, 0));
	RzILOpPure *op_AND_270 = LOGAND(op_RSHIFT_268, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_276 = SHIFTRA(DUP(Rs), SN(32, 0));
	RzILOpPure *op_AND_278 = LOGAND(op_RSHIFT_276, SN(32, 0xffff));
	RzILOpPure *op_RSHIFT_284 = SHIFTRA(DUP(Rt), SN(32, 0));
	RzILOpPure *op_AND_286 = LOGAND(op_RSHIFT_284, SN(32, 0xffff));
	RzILOpPure *op_MUL_289 = MUL(CAST(32, MSB(CAST(16, MSB(op_AND_278), DUP(op_AND_278))), CAST(16, MSB(DUP(op_AND_278)), DUP(op_AND_278))), CAST(32, MSB(CAST(16, MSB(op_AND_286), DUP(op_AND_286))), CAST(16, MSB(DUP(op_AND_286)), DUP(op_AND_286))));
	RzILOpPure *op_LSHIFT_292 = SHIFTL0(CAST(64, MSB(op_MUL_289), DUP(op_MUL_289)), SN(32, 1));
	RzILOpPure *op_ADD_293 = ADD(CAST(64, MSB(CAST(32, MSB(op_AND_270), DUP(op_AND_270))), CAST(32, MSB(DUP(op_AND_270)), DUP(op_AND_270))), op_LSHIFT_292);
	RzILOpPure *op_RSHIFT_297 = SHIFTRA(DUP(Rs), SN(32, 16));
	RzILOpPure *op_AND_299 = LOGAND(op_RSHIFT_297, SN(32, 0xffff));
	RzILOpPure *op_RSHIFT_305 = SHIFTRA(DUP(Rt), SN(32, 16));
	RzILOpPure *op_AND_307 = LOGAND(op_RSHIFT_305, SN(32, 0xffff));
	RzILOpPure *op_MUL_310 = MUL(CAST(32, MSB(CAST(16, MSB(op_AND_299), DUP(op_AND_299))), CAST(16, MSB(DUP(op_AND_299)), DUP(op_AND_299))), CAST(32, MSB(CAST(16, MSB(op_AND_307), DUP(op_AND_307))), CAST(16, MSB(DUP(op_AND_307)), DUP(op_AND_307))));
	RzILOpPure *op_LSHIFT_313 = SHIFTL0(CAST(64, MSB(op_MUL_310), DUP(op_MUL_310)), SN(32, 1));
	RzILOpPure *op_SUB_314 = SUB(op_ADD_293, op_LSHIFT_313);
	RzILOpPure *op_RSHIFT_323 = SHIFTRA(READ_REG(pkt, Rxx_op, false), SN(32, 0));
	RzILOpPure *op_AND_325 = LOGAND(op_RSHIFT_323, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_331 = SHIFTRA(DUP(Rs), SN(32, 0));
	RzILOpPure *op_AND_333 = LOGAND(op_RSHIFT_331, SN(32, 0xffff));
	RzILOpPure *op_RSHIFT_339 = SHIFTRA(DUP(Rt), SN(32, 0));
	RzILOpPure *op_AND_341 = LOGAND(op_RSHIFT_339, SN(32, 0xffff));
	RzILOpPure *op_MUL_344 = MUL(CAST(32, MSB(CAST(16, MSB(op_AND_333), DUP(op_AND_333))), CAST(16, MSB(DUP(op_AND_333)), DUP(op_AND_333))), CAST(32, MSB(CAST(16, MSB(op_AND_341), DUP(op_AND_341))), CAST(16, MSB(DUP(op_AND_341)), DUP(op_AND_341))));
	RzILOpPure *op_LSHIFT_347 = SHIFTL0(CAST(64, MSB(op_MUL_344), DUP(op_MUL_344)), SN(32, 1));
	RzILOpPure *op_ADD_348 = ADD(CAST(64, MSB(CAST(32, MSB(op_AND_325), DUP(op_AND_325))), CAST(32, MSB(DUP(op_AND_325)), DUP(op_AND_325))), op_LSHIFT_347);
	RzILOpPure *op_RSHIFT_352 = SHIFTRA(DUP(Rs), SN(32, 16));
	RzILOpPure *op_AND_354 = LOGAND(op_RSHIFT_352, SN(32, 0xffff));
	RzILOpPure *op_RSHIFT_360 = SHIFTRA(DUP(Rt), SN(32, 16));
	RzILOpPure *op_AND_362 = LOGAND(op_RSHIFT_360, SN(32, 0xffff));
	RzILOpPure *op_MUL_365 = MUL(CAST(32, MSB(CAST(16, MSB(op_AND_354), DUP(op_AND_354))), CAST(16, MSB(DUP(op_AND_354)), DUP(op_AND_354))), CAST(32, MSB(CAST(16, MSB(op_AND_362), DUP(op_AND_362))), CAST(16, MSB(DUP(op_AND_362)), DUP(op_AND_362))));
	RzILOpPure *op_LSHIFT_368 = SHIFTL0(CAST(64, MSB(op_MUL_365), DUP(op_MUL_365)), SN(32, 1));
	RzILOpPure *op_SUB_369 = SUB(op_ADD_348, op_LSHIFT_368);
	RzILOpPure *op_EQ_370 = EQ(SEXTRACT64(CAST(64, IL_FALSE, op_SUB_314), SN(32, 0), SN(32, 0x20)), op_SUB_369);
	RzILOpPure *op_RSHIFT_427 = SHIFTRA(READ_REG(pkt, Rxx_op, false), SN(32, 0));
	RzILOpPure *op_AND_429 = LOGAND(op_RSHIFT_427, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_435 = SHIFTRA(DUP(Rs), SN(32, 0));
	RzILOpPure *op_AND_437 = LOGAND(op_RSHIFT_435, SN(32, 0xffff));
	RzILOpPure *op_RSHIFT_443 = SHIFTRA(DUP(Rt), SN(32, 0));
	RzILOpPure *op_AND_445 = LOGAND(op_RSHIFT_443, SN(32, 0xffff));
	RzILOpPure *op_MUL_448 = MUL(CAST(32, MSB(CAST(16, MSB(op_AND_437), DUP(op_AND_437))), CAST(16, MSB(DUP(op_AND_437)), DUP(op_AND_437))), CAST(32, MSB(CAST(16, MSB(op_AND_445), DUP(op_AND_445))), CAST(16, MSB(DUP(op_AND_445)), DUP(op_AND_445))));
	RzILOpPure *op_LSHIFT_451 = SHIFTL0(CAST(64, MSB(op_MUL_448), DUP(op_MUL_448)), SN(32, 1));
	RzILOpPure *op_ADD_452 = ADD(CAST(64, MSB(CAST(32, MSB(op_AND_429), DUP(op_AND_429))), CAST(32, MSB(DUP(op_AND_429)), DUP(op_AND_429))), op_LSHIFT_451);
	RzILOpPure *op_RSHIFT_456 = SHIFTRA(DUP(Rs), SN(32, 16));
	RzILOpPure *op_AND_458 = LOGAND(op_RSHIFT_456, SN(32, 0xffff));
	RzILOpPure *op_RSHIFT_464 = SHIFTRA(DUP(Rt), SN(32, 16));
	RzILOpPure *op_AND_466 = LOGAND(op_RSHIFT_464, SN(32, 0xffff));
	RzILOpPure *op_MUL_469 = MUL(CAST(32, MSB(CAST(16, MSB(op_AND_458), DUP(op_AND_458))), CAST(16, MSB(DUP(op_AND_458)), DUP(op_AND_458))), CAST(32, MSB(CAST(16, MSB(op_AND_466), DUP(op_AND_466))), CAST(16, MSB(DUP(op_AND_466)), DUP(op_AND_466))));
	RzILOpPure *op_LSHIFT_472 = SHIFTL0(CAST(64, MSB(op_MUL_469), DUP(op_MUL_469)), SN(32, 1));
	RzILOpPure *op_SUB_473 = SUB(op_ADD_452, op_LSHIFT_472);
	RzILOpPure *op_LT_476 = SLT(op_SUB_473, CAST(64, MSB(SN(32, 0)), SN(32, 0)));
	RzILOpPure *op_LSHIFT_481 = SHIFTL0(SN(64, 1), SN(32, 31));
	RzILOpPure *op_NEG_482 = NEG(op_LSHIFT_481);
	RzILOpPure *op_LSHIFT_487 = SHIFTL0(SN(64, 1), SN(32, 31));
	RzILOpPure *op_SUB_490 = SUB(op_LSHIFT_487, CAST(64, MSB(SN(32, 1)), SN(32, 1)));
	RzILOpPure *cond_491 = ITE(op_LT_476, op_NEG_482, op_SUB_490);
	RzILOpEffect *gcc_expr_492 = BRANCH(op_EQ_370, EMPTY(), set_usr_field_call_423);

	// h_tmp235 = HYB(gcc_expr_if ((sextract64(((ut64) ((st64) ((st32) ((Rxx >> 0x0) & 0xffffffff))) + (((st64) ((st32) ((st16) ((Rs >> 0x0) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x0) & 0xffff)))) << 0x1) - (((st64) ((st32) ((st16) ((Rs >> 0x10) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x10) & 0xffff)))) << 0x1)), 0x0, 0x20) == ((st64) ((st32) ((Rxx >> 0x0) & 0xffffffff))) + (((st64) ((st32) ((st16) ((Rs >> 0x0) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x0) & 0xffff)))) << 0x1) - (((st64) ((st32) ((st16) ((Rs >> 0x10) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x10) & 0xffff)))) << 0x1))) {{}} else {set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, ((ut32) 0x1))}, ((((st64) ((st32) ((Rxx >> 0x0) & 0xffffffff))) + (((st64) ((st32) ((st16) ((Rs >> 0x0) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x0) & 0xffff)))) << 0x1) - (((st64) ((st32) ((st16) ((Rs >> 0x10) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x10) & 0xffff)))) << 0x1) < ((st64) 0x0)) ? (-(0x1 << 0x1f)) : (0x1 << 0x1f) - ((st64) 0x1)));
	RzILOpEffect *op_ASSIGN_hybrid_tmp_494 = SETL("h_tmp235", cond_491);

	// seq(HYB(gcc_expr_if ((sextract64(((ut64) ((st64) ((st32) ((Rxx > ...;
	RzILOpEffect *seq_495 = SEQN(2, gcc_expr_492, op_ASSIGN_hybrid_tmp_494);

	// Rxx = ((Rxx & (~(0xffffffff << 0x0))) | ((((sextract64(((ut64) ((st64) ((st32) ((Rxx >> 0x0) & 0xffffffff))) + (((st64) ((st32) ((st16) ((Rs >> 0x0) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x0) & 0xffff)))) << 0x1) - (((st64) ((st32) ((st16) ((Rs >> 0x10) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x10) & 0xffff)))) << 0x1)), 0x0, 0x20) == ((st64) ((st32) ((Rxx >> 0x0) & 0xffffffff))) + (((st64) ((st32) ((st16) ((Rs >> 0x0) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x0) & 0xffff)))) << 0x1) - (((st64) ((st32) ((st16) ((Rs >> 0x10) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x10) & 0xffff)))) << 0x1)) ? ((st64) ((st32) ((Rxx >> 0x0) & 0xffffffff))) + (((st64) ((st32) ((st16) ((Rs >> 0x0) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x0) & 0xffff)))) << 0x1) - (((st64) ((st32) ((st16) ((Rs >> 0x10) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x10) & 0xffff)))) << 0x1) : h_tmp235) & 0xffffffff) << 0x0));
	RzILOpPure *op_LSHIFT_259 = SHIFTL0(SN(64, 0xffffffff), SN(32, 0));
	RzILOpPure *op_NOT_260 = LOGNOT(op_LSHIFT_259);
	RzILOpPure *op_AND_261 = LOGAND(READ_REG(pkt, Rxx_op, false), op_NOT_260);
	RzILOpPure *op_RSHIFT_374 = SHIFTRA(READ_REG(pkt, Rxx_op, false), SN(32, 0));
	RzILOpPure *op_AND_376 = LOGAND(op_RSHIFT_374, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_382 = SHIFTRA(DUP(Rs), SN(32, 0));
	RzILOpPure *op_AND_384 = LOGAND(op_RSHIFT_382, SN(32, 0xffff));
	RzILOpPure *op_RSHIFT_390 = SHIFTRA(DUP(Rt), SN(32, 0));
	RzILOpPure *op_AND_392 = LOGAND(op_RSHIFT_390, SN(32, 0xffff));
	RzILOpPure *op_MUL_395 = MUL(CAST(32, MSB(CAST(16, MSB(op_AND_384), DUP(op_AND_384))), CAST(16, MSB(DUP(op_AND_384)), DUP(op_AND_384))), CAST(32, MSB(CAST(16, MSB(op_AND_392), DUP(op_AND_392))), CAST(16, MSB(DUP(op_AND_392)), DUP(op_AND_392))));
	RzILOpPure *op_LSHIFT_398 = SHIFTL0(CAST(64, MSB(op_MUL_395), DUP(op_MUL_395)), SN(32, 1));
	RzILOpPure *op_ADD_399 = ADD(CAST(64, MSB(CAST(32, MSB(op_AND_376), DUP(op_AND_376))), CAST(32, MSB(DUP(op_AND_376)), DUP(op_AND_376))), op_LSHIFT_398);
	RzILOpPure *op_RSHIFT_403 = SHIFTRA(DUP(Rs), SN(32, 16));
	RzILOpPure *op_AND_405 = LOGAND(op_RSHIFT_403, SN(32, 0xffff));
	RzILOpPure *op_RSHIFT_411 = SHIFTRA(DUP(Rt), SN(32, 16));
	RzILOpPure *op_AND_413 = LOGAND(op_RSHIFT_411, SN(32, 0xffff));
	RzILOpPure *op_MUL_416 = MUL(CAST(32, MSB(CAST(16, MSB(op_AND_405), DUP(op_AND_405))), CAST(16, MSB(DUP(op_AND_405)), DUP(op_AND_405))), CAST(32, MSB(CAST(16, MSB(op_AND_413), DUP(op_AND_413))), CAST(16, MSB(DUP(op_AND_413)), DUP(op_AND_413))));
	RzILOpPure *op_LSHIFT_419 = SHIFTL0(CAST(64, MSB(op_MUL_416), DUP(op_MUL_416)), SN(32, 1));
	RzILOpPure *op_SUB_420 = SUB(op_ADD_399, op_LSHIFT_419);
	RzILOpPure *cond_496 = ITE(DUP(op_EQ_370), op_SUB_420, VARL("h_tmp235"));
	RzILOpPure *op_AND_498 = LOGAND(cond_496, SN(64, 0xffffffff));
	RzILOpPure *op_LSHIFT_502 = SHIFTL0(op_AND_498, SN(32, 0));
	RzILOpPure *op_OR_503 = LOGOR(op_AND_261, op_LSHIFT_502);
	RzILOpEffect *op_ASSIGN_504 = WRITE_REG(bundle, Rxx_op, op_OR_503);

	// seq(seq(HYB(gcc_expr_if ((sextract64(((ut64) ((st64) ((st32) ((R ...;
	RzILOpEffect *seq_505 = SEQN(2, seq_495, op_ASSIGN_504);

	RzILOpEffect *instruction_sequence = SEQN(2, seq_253, seq_505);
	return instruction_sequence;
}

// Rxx += cmpy(Rs,Rt*):sat
RzILOpEffect *hex_il_op_m2_cmacsc_s0(HexInsnPktBundle *bundle) {
	const HexInsn *hi = bundle->insn;
	HexPkt *pkt = bundle->pkt;
	// READ
	const HexOp *Rxx_op = ISA2REG(hi, 'x', false);

	const HexOp *Rs_op = ISA2REG(hi, 's', false);
	RzILOpPure *Rs = READ_REG(pkt, Rs_op, false);
	const HexOp *Rt_op = ISA2REG(hi, 't', false);
	RzILOpPure *Rt = READ_REG(pkt, Rt_op, false);

	// set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, ((ut32) 0x1));
	RzILOpEffect *set_usr_field_call_171 = hex_set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, CAST(32, IL_FALSE, SN(32, 1)));

	// HYB(gcc_expr_if ((sextract64(((ut64) ((st64) ((st32) ((Rxx >> 0x20) & 0xffffffff))) + (((st64) ((st32) ((st16) ((Rs >> 0x10) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x0) & 0xffff)))) << 0x0) - (((st64) ((st32) ((st16) ((Rs >> 0x0) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x10) & 0xffff)))) << 0x0)), 0x0, 0x20) == ((st64) ((st32) ((Rxx >> 0x20) & 0xffffffff))) + (((st64) ((st32) ((st16) ((Rs >> 0x10) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x0) & 0xffff)))) << 0x0) - (((st64) ((st32) ((st16) ((Rs >> 0x0) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x10) & 0xffff)))) << 0x0))) {{}} else {set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, ((ut32) 0x1))}, ((((st64) ((st32) ((Rxx >> 0x20) & 0xffffffff))) + (((st64) ((st32) ((st16) ((Rs >> 0x10) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x0) & 0xffff)))) << 0x0) - (((st64) ((st32) ((st16) ((Rs >> 0x0) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x10) & 0xffff)))) << 0x0) < ((st64) 0x0)) ? (-(0x1 << 0x1f)) : (0x1 << 0x1f) - ((st64) 0x1)));
	RzILOpPure *op_RSHIFT_14 = SHIFTRA(READ_REG(pkt, Rxx_op, false), SN(32, 0x20));
	RzILOpPure *op_AND_16 = LOGAND(op_RSHIFT_14, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_23 = SHIFTRA(Rs, SN(32, 16));
	RzILOpPure *op_AND_25 = LOGAND(op_RSHIFT_23, SN(32, 0xffff));
	RzILOpPure *op_RSHIFT_32 = SHIFTRA(Rt, SN(32, 0));
	RzILOpPure *op_AND_34 = LOGAND(op_RSHIFT_32, SN(32, 0xffff));
	RzILOpPure *op_MUL_37 = MUL(CAST(32, MSB(CAST(16, MSB(op_AND_25), DUP(op_AND_25))), CAST(16, MSB(DUP(op_AND_25)), DUP(op_AND_25))), CAST(32, MSB(CAST(16, MSB(op_AND_34), DUP(op_AND_34))), CAST(16, MSB(DUP(op_AND_34)), DUP(op_AND_34))));
	RzILOpPure *op_LSHIFT_40 = SHIFTL0(CAST(64, MSB(op_MUL_37), DUP(op_MUL_37)), SN(32, 0));
	RzILOpPure *op_ADD_41 = ADD(CAST(64, MSB(CAST(32, MSB(op_AND_16), DUP(op_AND_16))), CAST(32, MSB(DUP(op_AND_16)), DUP(op_AND_16))), op_LSHIFT_40);
	RzILOpPure *op_RSHIFT_45 = SHIFTRA(DUP(Rs), SN(32, 0));
	RzILOpPure *op_AND_47 = LOGAND(op_RSHIFT_45, SN(32, 0xffff));
	RzILOpPure *op_RSHIFT_53 = SHIFTRA(DUP(Rt), SN(32, 16));
	RzILOpPure *op_AND_55 = LOGAND(op_RSHIFT_53, SN(32, 0xffff));
	RzILOpPure *op_MUL_58 = MUL(CAST(32, MSB(CAST(16, MSB(op_AND_47), DUP(op_AND_47))), CAST(16, MSB(DUP(op_AND_47)), DUP(op_AND_47))), CAST(32, MSB(CAST(16, MSB(op_AND_55), DUP(op_AND_55))), CAST(16, MSB(DUP(op_AND_55)), DUP(op_AND_55))));
	RzILOpPure *op_LSHIFT_61 = SHIFTL0(CAST(64, MSB(op_MUL_58), DUP(op_MUL_58)), SN(32, 0));
	RzILOpPure *op_SUB_62 = SUB(op_ADD_41, op_LSHIFT_61);
	RzILOpPure *op_RSHIFT_71 = SHIFTRA(READ_REG(pkt, Rxx_op, false), SN(32, 0x20));
	RzILOpPure *op_AND_73 = LOGAND(op_RSHIFT_71, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_79 = SHIFTRA(DUP(Rs), SN(32, 16));
	RzILOpPure *op_AND_81 = LOGAND(op_RSHIFT_79, SN(32, 0xffff));
	RzILOpPure *op_RSHIFT_87 = SHIFTRA(DUP(Rt), SN(32, 0));
	RzILOpPure *op_AND_89 = LOGAND(op_RSHIFT_87, SN(32, 0xffff));
	RzILOpPure *op_MUL_92 = MUL(CAST(32, MSB(CAST(16, MSB(op_AND_81), DUP(op_AND_81))), CAST(16, MSB(DUP(op_AND_81)), DUP(op_AND_81))), CAST(32, MSB(CAST(16, MSB(op_AND_89), DUP(op_AND_89))), CAST(16, MSB(DUP(op_AND_89)), DUP(op_AND_89))));
	RzILOpPure *op_LSHIFT_95 = SHIFTL0(CAST(64, MSB(op_MUL_92), DUP(op_MUL_92)), SN(32, 0));
	RzILOpPure *op_ADD_96 = ADD(CAST(64, MSB(CAST(32, MSB(op_AND_73), DUP(op_AND_73))), CAST(32, MSB(DUP(op_AND_73)), DUP(op_AND_73))), op_LSHIFT_95);
	RzILOpPure *op_RSHIFT_100 = SHIFTRA(DUP(Rs), SN(32, 0));
	RzILOpPure *op_AND_102 = LOGAND(op_RSHIFT_100, SN(32, 0xffff));
	RzILOpPure *op_RSHIFT_108 = SHIFTRA(DUP(Rt), SN(32, 16));
	RzILOpPure *op_AND_110 = LOGAND(op_RSHIFT_108, SN(32, 0xffff));
	RzILOpPure *op_MUL_113 = MUL(CAST(32, MSB(CAST(16, MSB(op_AND_102), DUP(op_AND_102))), CAST(16, MSB(DUP(op_AND_102)), DUP(op_AND_102))), CAST(32, MSB(CAST(16, MSB(op_AND_110), DUP(op_AND_110))), CAST(16, MSB(DUP(op_AND_110)), DUP(op_AND_110))));
	RzILOpPure *op_LSHIFT_116 = SHIFTL0(CAST(64, MSB(op_MUL_113), DUP(op_MUL_113)), SN(32, 0));
	RzILOpPure *op_SUB_117 = SUB(op_ADD_96, op_LSHIFT_116);
	RzILOpPure *op_EQ_118 = EQ(SEXTRACT64(CAST(64, IL_FALSE, op_SUB_62), SN(32, 0), SN(32, 0x20)), op_SUB_117);
	RzILOpPure *op_RSHIFT_175 = SHIFTRA(READ_REG(pkt, Rxx_op, false), SN(32, 0x20));
	RzILOpPure *op_AND_177 = LOGAND(op_RSHIFT_175, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_183 = SHIFTRA(DUP(Rs), SN(32, 16));
	RzILOpPure *op_AND_185 = LOGAND(op_RSHIFT_183, SN(32, 0xffff));
	RzILOpPure *op_RSHIFT_191 = SHIFTRA(DUP(Rt), SN(32, 0));
	RzILOpPure *op_AND_193 = LOGAND(op_RSHIFT_191, SN(32, 0xffff));
	RzILOpPure *op_MUL_196 = MUL(CAST(32, MSB(CAST(16, MSB(op_AND_185), DUP(op_AND_185))), CAST(16, MSB(DUP(op_AND_185)), DUP(op_AND_185))), CAST(32, MSB(CAST(16, MSB(op_AND_193), DUP(op_AND_193))), CAST(16, MSB(DUP(op_AND_193)), DUP(op_AND_193))));
	RzILOpPure *op_LSHIFT_199 = SHIFTL0(CAST(64, MSB(op_MUL_196), DUP(op_MUL_196)), SN(32, 0));
	RzILOpPure *op_ADD_200 = ADD(CAST(64, MSB(CAST(32, MSB(op_AND_177), DUP(op_AND_177))), CAST(32, MSB(DUP(op_AND_177)), DUP(op_AND_177))), op_LSHIFT_199);
	RzILOpPure *op_RSHIFT_204 = SHIFTRA(DUP(Rs), SN(32, 0));
	RzILOpPure *op_AND_206 = LOGAND(op_RSHIFT_204, SN(32, 0xffff));
	RzILOpPure *op_RSHIFT_212 = SHIFTRA(DUP(Rt), SN(32, 16));
	RzILOpPure *op_AND_214 = LOGAND(op_RSHIFT_212, SN(32, 0xffff));
	RzILOpPure *op_MUL_217 = MUL(CAST(32, MSB(CAST(16, MSB(op_AND_206), DUP(op_AND_206))), CAST(16, MSB(DUP(op_AND_206)), DUP(op_AND_206))), CAST(32, MSB(CAST(16, MSB(op_AND_214), DUP(op_AND_214))), CAST(16, MSB(DUP(op_AND_214)), DUP(op_AND_214))));
	RzILOpPure *op_LSHIFT_220 = SHIFTL0(CAST(64, MSB(op_MUL_217), DUP(op_MUL_217)), SN(32, 0));
	RzILOpPure *op_SUB_221 = SUB(op_ADD_200, op_LSHIFT_220);
	RzILOpPure *op_LT_224 = SLT(op_SUB_221, CAST(64, MSB(SN(32, 0)), SN(32, 0)));
	RzILOpPure *op_LSHIFT_229 = SHIFTL0(SN(64, 1), SN(32, 31));
	RzILOpPure *op_NEG_230 = NEG(op_LSHIFT_229);
	RzILOpPure *op_LSHIFT_235 = SHIFTL0(SN(64, 1), SN(32, 31));
	RzILOpPure *op_SUB_238 = SUB(op_LSHIFT_235, CAST(64, MSB(SN(32, 1)), SN(32, 1)));
	RzILOpPure *cond_239 = ITE(op_LT_224, op_NEG_230, op_SUB_238);
	RzILOpEffect *gcc_expr_240 = BRANCH(op_EQ_118, EMPTY(), set_usr_field_call_171);

	// h_tmp236 = HYB(gcc_expr_if ((sextract64(((ut64) ((st64) ((st32) ((Rxx >> 0x20) & 0xffffffff))) + (((st64) ((st32) ((st16) ((Rs >> 0x10) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x0) & 0xffff)))) << 0x0) - (((st64) ((st32) ((st16) ((Rs >> 0x0) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x10) & 0xffff)))) << 0x0)), 0x0, 0x20) == ((st64) ((st32) ((Rxx >> 0x20) & 0xffffffff))) + (((st64) ((st32) ((st16) ((Rs >> 0x10) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x0) & 0xffff)))) << 0x0) - (((st64) ((st32) ((st16) ((Rs >> 0x0) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x10) & 0xffff)))) << 0x0))) {{}} else {set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, ((ut32) 0x1))}, ((((st64) ((st32) ((Rxx >> 0x20) & 0xffffffff))) + (((st64) ((st32) ((st16) ((Rs >> 0x10) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x0) & 0xffff)))) << 0x0) - (((st64) ((st32) ((st16) ((Rs >> 0x0) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x10) & 0xffff)))) << 0x0) < ((st64) 0x0)) ? (-(0x1 << 0x1f)) : (0x1 << 0x1f) - ((st64) 0x1)));
	RzILOpEffect *op_ASSIGN_hybrid_tmp_242 = SETL("h_tmp236", cond_239);

	// seq(HYB(gcc_expr_if ((sextract64(((ut64) ((st64) ((st32) ((Rxx > ...;
	RzILOpEffect *seq_243 = SEQN(2, gcc_expr_240, op_ASSIGN_hybrid_tmp_242);

	// Rxx = ((Rxx & (~(0xffffffff << 0x20))) | ((((sextract64(((ut64) ((st64) ((st32) ((Rxx >> 0x20) & 0xffffffff))) + (((st64) ((st32) ((st16) ((Rs >> 0x10) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x0) & 0xffff)))) << 0x0) - (((st64) ((st32) ((st16) ((Rs >> 0x0) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x10) & 0xffff)))) << 0x0)), 0x0, 0x20) == ((st64) ((st32) ((Rxx >> 0x20) & 0xffffffff))) + (((st64) ((st32) ((st16) ((Rs >> 0x10) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x0) & 0xffff)))) << 0x0) - (((st64) ((st32) ((st16) ((Rs >> 0x0) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x10) & 0xffff)))) << 0x0)) ? ((st64) ((st32) ((Rxx >> 0x20) & 0xffffffff))) + (((st64) ((st32) ((st16) ((Rs >> 0x10) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x0) & 0xffff)))) << 0x0) - (((st64) ((st32) ((st16) ((Rs >> 0x0) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x10) & 0xffff)))) << 0x0) : h_tmp236) & 0xffffffff) << 0x20));
	RzILOpPure *op_LSHIFT_5 = SHIFTL0(SN(64, 0xffffffff), SN(32, 0x20));
	RzILOpPure *op_NOT_6 = LOGNOT(op_LSHIFT_5);
	RzILOpPure *op_AND_7 = LOGAND(READ_REG(pkt, Rxx_op, false), op_NOT_6);
	RzILOpPure *op_RSHIFT_122 = SHIFTRA(READ_REG(pkt, Rxx_op, false), SN(32, 0x20));
	RzILOpPure *op_AND_124 = LOGAND(op_RSHIFT_122, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_130 = SHIFTRA(DUP(Rs), SN(32, 16));
	RzILOpPure *op_AND_132 = LOGAND(op_RSHIFT_130, SN(32, 0xffff));
	RzILOpPure *op_RSHIFT_138 = SHIFTRA(DUP(Rt), SN(32, 0));
	RzILOpPure *op_AND_140 = LOGAND(op_RSHIFT_138, SN(32, 0xffff));
	RzILOpPure *op_MUL_143 = MUL(CAST(32, MSB(CAST(16, MSB(op_AND_132), DUP(op_AND_132))), CAST(16, MSB(DUP(op_AND_132)), DUP(op_AND_132))), CAST(32, MSB(CAST(16, MSB(op_AND_140), DUP(op_AND_140))), CAST(16, MSB(DUP(op_AND_140)), DUP(op_AND_140))));
	RzILOpPure *op_LSHIFT_146 = SHIFTL0(CAST(64, MSB(op_MUL_143), DUP(op_MUL_143)), SN(32, 0));
	RzILOpPure *op_ADD_147 = ADD(CAST(64, MSB(CAST(32, MSB(op_AND_124), DUP(op_AND_124))), CAST(32, MSB(DUP(op_AND_124)), DUP(op_AND_124))), op_LSHIFT_146);
	RzILOpPure *op_RSHIFT_151 = SHIFTRA(DUP(Rs), SN(32, 0));
	RzILOpPure *op_AND_153 = LOGAND(op_RSHIFT_151, SN(32, 0xffff));
	RzILOpPure *op_RSHIFT_159 = SHIFTRA(DUP(Rt), SN(32, 16));
	RzILOpPure *op_AND_161 = LOGAND(op_RSHIFT_159, SN(32, 0xffff));
	RzILOpPure *op_MUL_164 = MUL(CAST(32, MSB(CAST(16, MSB(op_AND_153), DUP(op_AND_153))), CAST(16, MSB(DUP(op_AND_153)), DUP(op_AND_153))), CAST(32, MSB(CAST(16, MSB(op_AND_161), DUP(op_AND_161))), CAST(16, MSB(DUP(op_AND_161)), DUP(op_AND_161))));
	RzILOpPure *op_LSHIFT_167 = SHIFTL0(CAST(64, MSB(op_MUL_164), DUP(op_MUL_164)), SN(32, 0));
	RzILOpPure *op_SUB_168 = SUB(op_ADD_147, op_LSHIFT_167);
	RzILOpPure *cond_244 = ITE(DUP(op_EQ_118), op_SUB_168, VARL("h_tmp236"));
	RzILOpPure *op_AND_246 = LOGAND(cond_244, SN(64, 0xffffffff));
	RzILOpPure *op_LSHIFT_250 = SHIFTL0(op_AND_246, SN(32, 0x20));
	RzILOpPure *op_OR_251 = LOGOR(op_AND_7, op_LSHIFT_250);
	RzILOpEffect *op_ASSIGN_252 = WRITE_REG(bundle, Rxx_op, op_OR_251);

	// seq(seq(HYB(gcc_expr_if ((sextract64(((ut64) ((st64) ((st32) ((R ...;
	RzILOpEffect *seq_253 = SEQN(2, seq_243, op_ASSIGN_252);

	// set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, ((ut32) 0x1));
	RzILOpEffect *set_usr_field_call_423 = hex_set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, CAST(32, IL_FALSE, SN(32, 1)));

	// HYB(gcc_expr_if ((sextract64(((ut64) ((st64) ((st32) ((Rxx >> 0x0) & 0xffffffff))) + (((st64) ((st32) ((st16) ((Rs >> 0x0) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x0) & 0xffff)))) << 0x0) + (((st64) ((st32) ((st16) ((Rs >> 0x10) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x10) & 0xffff)))) << 0x0)), 0x0, 0x20) == ((st64) ((st32) ((Rxx >> 0x0) & 0xffffffff))) + (((st64) ((st32) ((st16) ((Rs >> 0x0) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x0) & 0xffff)))) << 0x0) + (((st64) ((st32) ((st16) ((Rs >> 0x10) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x10) & 0xffff)))) << 0x0))) {{}} else {set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, ((ut32) 0x1))}, ((((st64) ((st32) ((Rxx >> 0x0) & 0xffffffff))) + (((st64) ((st32) ((st16) ((Rs >> 0x0) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x0) & 0xffff)))) << 0x0) + (((st64) ((st32) ((st16) ((Rs >> 0x10) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x10) & 0xffff)))) << 0x0) < ((st64) 0x0)) ? (-(0x1 << 0x1f)) : (0x1 << 0x1f) - ((st64) 0x1)));
	RzILOpPure *op_RSHIFT_268 = SHIFTRA(READ_REG(pkt, Rxx_op, false), SN(32, 0));
	RzILOpPure *op_AND_270 = LOGAND(op_RSHIFT_268, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_276 = SHIFTRA(DUP(Rs), SN(32, 0));
	RzILOpPure *op_AND_278 = LOGAND(op_RSHIFT_276, SN(32, 0xffff));
	RzILOpPure *op_RSHIFT_284 = SHIFTRA(DUP(Rt), SN(32, 0));
	RzILOpPure *op_AND_286 = LOGAND(op_RSHIFT_284, SN(32, 0xffff));
	RzILOpPure *op_MUL_289 = MUL(CAST(32, MSB(CAST(16, MSB(op_AND_278), DUP(op_AND_278))), CAST(16, MSB(DUP(op_AND_278)), DUP(op_AND_278))), CAST(32, MSB(CAST(16, MSB(op_AND_286), DUP(op_AND_286))), CAST(16, MSB(DUP(op_AND_286)), DUP(op_AND_286))));
	RzILOpPure *op_LSHIFT_292 = SHIFTL0(CAST(64, MSB(op_MUL_289), DUP(op_MUL_289)), SN(32, 0));
	RzILOpPure *op_ADD_293 = ADD(CAST(64, MSB(CAST(32, MSB(op_AND_270), DUP(op_AND_270))), CAST(32, MSB(DUP(op_AND_270)), DUP(op_AND_270))), op_LSHIFT_292);
	RzILOpPure *op_RSHIFT_297 = SHIFTRA(DUP(Rs), SN(32, 16));
	RzILOpPure *op_AND_299 = LOGAND(op_RSHIFT_297, SN(32, 0xffff));
	RzILOpPure *op_RSHIFT_305 = SHIFTRA(DUP(Rt), SN(32, 16));
	RzILOpPure *op_AND_307 = LOGAND(op_RSHIFT_305, SN(32, 0xffff));
	RzILOpPure *op_MUL_310 = MUL(CAST(32, MSB(CAST(16, MSB(op_AND_299), DUP(op_AND_299))), CAST(16, MSB(DUP(op_AND_299)), DUP(op_AND_299))), CAST(32, MSB(CAST(16, MSB(op_AND_307), DUP(op_AND_307))), CAST(16, MSB(DUP(op_AND_307)), DUP(op_AND_307))));
	RzILOpPure *op_LSHIFT_313 = SHIFTL0(CAST(64, MSB(op_MUL_310), DUP(op_MUL_310)), SN(32, 0));
	RzILOpPure *op_ADD_314 = ADD(op_ADD_293, op_LSHIFT_313);
	RzILOpPure *op_RSHIFT_323 = SHIFTRA(READ_REG(pkt, Rxx_op, false), SN(32, 0));
	RzILOpPure *op_AND_325 = LOGAND(op_RSHIFT_323, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_331 = SHIFTRA(DUP(Rs), SN(32, 0));
	RzILOpPure *op_AND_333 = LOGAND(op_RSHIFT_331, SN(32, 0xffff));
	RzILOpPure *op_RSHIFT_339 = SHIFTRA(DUP(Rt), SN(32, 0));
	RzILOpPure *op_AND_341 = LOGAND(op_RSHIFT_339, SN(32, 0xffff));
	RzILOpPure *op_MUL_344 = MUL(CAST(32, MSB(CAST(16, MSB(op_AND_333), DUP(op_AND_333))), CAST(16, MSB(DUP(op_AND_333)), DUP(op_AND_333))), CAST(32, MSB(CAST(16, MSB(op_AND_341), DUP(op_AND_341))), CAST(16, MSB(DUP(op_AND_341)), DUP(op_AND_341))));
	RzILOpPure *op_LSHIFT_347 = SHIFTL0(CAST(64, MSB(op_MUL_344), DUP(op_MUL_344)), SN(32, 0));
	RzILOpPure *op_ADD_348 = ADD(CAST(64, MSB(CAST(32, MSB(op_AND_325), DUP(op_AND_325))), CAST(32, MSB(DUP(op_AND_325)), DUP(op_AND_325))), op_LSHIFT_347);
	RzILOpPure *op_RSHIFT_352 = SHIFTRA(DUP(Rs), SN(32, 16));
	RzILOpPure *op_AND_354 = LOGAND(op_RSHIFT_352, SN(32, 0xffff));
	RzILOpPure *op_RSHIFT_360 = SHIFTRA(DUP(Rt), SN(32, 16));
	RzILOpPure *op_AND_362 = LOGAND(op_RSHIFT_360, SN(32, 0xffff));
	RzILOpPure *op_MUL_365 = MUL(CAST(32, MSB(CAST(16, MSB(op_AND_354), DUP(op_AND_354))), CAST(16, MSB(DUP(op_AND_354)), DUP(op_AND_354))), CAST(32, MSB(CAST(16, MSB(op_AND_362), DUP(op_AND_362))), CAST(16, MSB(DUP(op_AND_362)), DUP(op_AND_362))));
	RzILOpPure *op_LSHIFT_368 = SHIFTL0(CAST(64, MSB(op_MUL_365), DUP(op_MUL_365)), SN(32, 0));
	RzILOpPure *op_ADD_369 = ADD(op_ADD_348, op_LSHIFT_368);
	RzILOpPure *op_EQ_370 = EQ(SEXTRACT64(CAST(64, IL_FALSE, op_ADD_314), SN(32, 0), SN(32, 0x20)), op_ADD_369);
	RzILOpPure *op_RSHIFT_427 = SHIFTRA(READ_REG(pkt, Rxx_op, false), SN(32, 0));
	RzILOpPure *op_AND_429 = LOGAND(op_RSHIFT_427, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_435 = SHIFTRA(DUP(Rs), SN(32, 0));
	RzILOpPure *op_AND_437 = LOGAND(op_RSHIFT_435, SN(32, 0xffff));
	RzILOpPure *op_RSHIFT_443 = SHIFTRA(DUP(Rt), SN(32, 0));
	RzILOpPure *op_AND_445 = LOGAND(op_RSHIFT_443, SN(32, 0xffff));
	RzILOpPure *op_MUL_448 = MUL(CAST(32, MSB(CAST(16, MSB(op_AND_437), DUP(op_AND_437))), CAST(16, MSB(DUP(op_AND_437)), DUP(op_AND_437))), CAST(32, MSB(CAST(16, MSB(op_AND_445), DUP(op_AND_445))), CAST(16, MSB(DUP(op_AND_445)), DUP(op_AND_445))));
	RzILOpPure *op_LSHIFT_451 = SHIFTL0(CAST(64, MSB(op_MUL_448), DUP(op_MUL_448)), SN(32, 0));
	RzILOpPure *op_ADD_452 = ADD(CAST(64, MSB(CAST(32, MSB(op_AND_429), DUP(op_AND_429))), CAST(32, MSB(DUP(op_AND_429)), DUP(op_AND_429))), op_LSHIFT_451);
	RzILOpPure *op_RSHIFT_456 = SHIFTRA(DUP(Rs), SN(32, 16));
	RzILOpPure *op_AND_458 = LOGAND(op_RSHIFT_456, SN(32, 0xffff));
	RzILOpPure *op_RSHIFT_464 = SHIFTRA(DUP(Rt), SN(32, 16));
	RzILOpPure *op_AND_466 = LOGAND(op_RSHIFT_464, SN(32, 0xffff));
	RzILOpPure *op_MUL_469 = MUL(CAST(32, MSB(CAST(16, MSB(op_AND_458), DUP(op_AND_458))), CAST(16, MSB(DUP(op_AND_458)), DUP(op_AND_458))), CAST(32, MSB(CAST(16, MSB(op_AND_466), DUP(op_AND_466))), CAST(16, MSB(DUP(op_AND_466)), DUP(op_AND_466))));
	RzILOpPure *op_LSHIFT_472 = SHIFTL0(CAST(64, MSB(op_MUL_469), DUP(op_MUL_469)), SN(32, 0));
	RzILOpPure *op_ADD_473 = ADD(op_ADD_452, op_LSHIFT_472);
	RzILOpPure *op_LT_476 = SLT(op_ADD_473, CAST(64, MSB(SN(32, 0)), SN(32, 0)));
	RzILOpPure *op_LSHIFT_481 = SHIFTL0(SN(64, 1), SN(32, 31));
	RzILOpPure *op_NEG_482 = NEG(op_LSHIFT_481);
	RzILOpPure *op_LSHIFT_487 = SHIFTL0(SN(64, 1), SN(32, 31));
	RzILOpPure *op_SUB_490 = SUB(op_LSHIFT_487, CAST(64, MSB(SN(32, 1)), SN(32, 1)));
	RzILOpPure *cond_491 = ITE(op_LT_476, op_NEG_482, op_SUB_490);
	RzILOpEffect *gcc_expr_492 = BRANCH(op_EQ_370, EMPTY(), set_usr_field_call_423);

	// h_tmp237 = HYB(gcc_expr_if ((sextract64(((ut64) ((st64) ((st32) ((Rxx >> 0x0) & 0xffffffff))) + (((st64) ((st32) ((st16) ((Rs >> 0x0) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x0) & 0xffff)))) << 0x0) + (((st64) ((st32) ((st16) ((Rs >> 0x10) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x10) & 0xffff)))) << 0x0)), 0x0, 0x20) == ((st64) ((st32) ((Rxx >> 0x0) & 0xffffffff))) + (((st64) ((st32) ((st16) ((Rs >> 0x0) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x0) & 0xffff)))) << 0x0) + (((st64) ((st32) ((st16) ((Rs >> 0x10) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x10) & 0xffff)))) << 0x0))) {{}} else {set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, ((ut32) 0x1))}, ((((st64) ((st32) ((Rxx >> 0x0) & 0xffffffff))) + (((st64) ((st32) ((st16) ((Rs >> 0x0) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x0) & 0xffff)))) << 0x0) + (((st64) ((st32) ((st16) ((Rs >> 0x10) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x10) & 0xffff)))) << 0x0) < ((st64) 0x0)) ? (-(0x1 << 0x1f)) : (0x1 << 0x1f) - ((st64) 0x1)));
	RzILOpEffect *op_ASSIGN_hybrid_tmp_494 = SETL("h_tmp237", cond_491);

	// seq(HYB(gcc_expr_if ((sextract64(((ut64) ((st64) ((st32) ((Rxx > ...;
	RzILOpEffect *seq_495 = SEQN(2, gcc_expr_492, op_ASSIGN_hybrid_tmp_494);

	// Rxx = ((Rxx & (~(0xffffffff << 0x0))) | ((((sextract64(((ut64) ((st64) ((st32) ((Rxx >> 0x0) & 0xffffffff))) + (((st64) ((st32) ((st16) ((Rs >> 0x0) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x0) & 0xffff)))) << 0x0) + (((st64) ((st32) ((st16) ((Rs >> 0x10) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x10) & 0xffff)))) << 0x0)), 0x0, 0x20) == ((st64) ((st32) ((Rxx >> 0x0) & 0xffffffff))) + (((st64) ((st32) ((st16) ((Rs >> 0x0) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x0) & 0xffff)))) << 0x0) + (((st64) ((st32) ((st16) ((Rs >> 0x10) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x10) & 0xffff)))) << 0x0)) ? ((st64) ((st32) ((Rxx >> 0x0) & 0xffffffff))) + (((st64) ((st32) ((st16) ((Rs >> 0x0) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x0) & 0xffff)))) << 0x0) + (((st64) ((st32) ((st16) ((Rs >> 0x10) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x10) & 0xffff)))) << 0x0) : h_tmp237) & 0xffffffff) << 0x0));
	RzILOpPure *op_LSHIFT_259 = SHIFTL0(SN(64, 0xffffffff), SN(32, 0));
	RzILOpPure *op_NOT_260 = LOGNOT(op_LSHIFT_259);
	RzILOpPure *op_AND_261 = LOGAND(READ_REG(pkt, Rxx_op, false), op_NOT_260);
	RzILOpPure *op_RSHIFT_374 = SHIFTRA(READ_REG(pkt, Rxx_op, false), SN(32, 0));
	RzILOpPure *op_AND_376 = LOGAND(op_RSHIFT_374, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_382 = SHIFTRA(DUP(Rs), SN(32, 0));
	RzILOpPure *op_AND_384 = LOGAND(op_RSHIFT_382, SN(32, 0xffff));
	RzILOpPure *op_RSHIFT_390 = SHIFTRA(DUP(Rt), SN(32, 0));
	RzILOpPure *op_AND_392 = LOGAND(op_RSHIFT_390, SN(32, 0xffff));
	RzILOpPure *op_MUL_395 = MUL(CAST(32, MSB(CAST(16, MSB(op_AND_384), DUP(op_AND_384))), CAST(16, MSB(DUP(op_AND_384)), DUP(op_AND_384))), CAST(32, MSB(CAST(16, MSB(op_AND_392), DUP(op_AND_392))), CAST(16, MSB(DUP(op_AND_392)), DUP(op_AND_392))));
	RzILOpPure *op_LSHIFT_398 = SHIFTL0(CAST(64, MSB(op_MUL_395), DUP(op_MUL_395)), SN(32, 0));
	RzILOpPure *op_ADD_399 = ADD(CAST(64, MSB(CAST(32, MSB(op_AND_376), DUP(op_AND_376))), CAST(32, MSB(DUP(op_AND_376)), DUP(op_AND_376))), op_LSHIFT_398);
	RzILOpPure *op_RSHIFT_403 = SHIFTRA(DUP(Rs), SN(32, 16));
	RzILOpPure *op_AND_405 = LOGAND(op_RSHIFT_403, SN(32, 0xffff));
	RzILOpPure *op_RSHIFT_411 = SHIFTRA(DUP(Rt), SN(32, 16));
	RzILOpPure *op_AND_413 = LOGAND(op_RSHIFT_411, SN(32, 0xffff));
	RzILOpPure *op_MUL_416 = MUL(CAST(32, MSB(CAST(16, MSB(op_AND_405), DUP(op_AND_405))), CAST(16, MSB(DUP(op_AND_405)), DUP(op_AND_405))), CAST(32, MSB(CAST(16, MSB(op_AND_413), DUP(op_AND_413))), CAST(16, MSB(DUP(op_AND_413)), DUP(op_AND_413))));
	RzILOpPure *op_LSHIFT_419 = SHIFTL0(CAST(64, MSB(op_MUL_416), DUP(op_MUL_416)), SN(32, 0));
	RzILOpPure *op_ADD_420 = ADD(op_ADD_399, op_LSHIFT_419);
	RzILOpPure *cond_496 = ITE(DUP(op_EQ_370), op_ADD_420, VARL("h_tmp237"));
	RzILOpPure *op_AND_498 = LOGAND(cond_496, SN(64, 0xffffffff));
	RzILOpPure *op_LSHIFT_502 = SHIFTL0(op_AND_498, SN(32, 0));
	RzILOpPure *op_OR_503 = LOGOR(op_AND_261, op_LSHIFT_502);
	RzILOpEffect *op_ASSIGN_504 = WRITE_REG(bundle, Rxx_op, op_OR_503);

	// seq(seq(HYB(gcc_expr_if ((sextract64(((ut64) ((st64) ((st32) ((R ...;
	RzILOpEffect *seq_505 = SEQN(2, seq_495, op_ASSIGN_504);

	RzILOpEffect *instruction_sequence = SEQN(2, seq_253, seq_505);
	return instruction_sequence;
}

// Rxx += cmpy(Rs,Rt*):<<1:sat
RzILOpEffect *hex_il_op_m2_cmacsc_s1(HexInsnPktBundle *bundle) {
	const HexInsn *hi = bundle->insn;
	HexPkt *pkt = bundle->pkt;
	// READ
	const HexOp *Rxx_op = ISA2REG(hi, 'x', false);

	const HexOp *Rs_op = ISA2REG(hi, 's', false);
	RzILOpPure *Rs = READ_REG(pkt, Rs_op, false);
	const HexOp *Rt_op = ISA2REG(hi, 't', false);
	RzILOpPure *Rt = READ_REG(pkt, Rt_op, false);

	// set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, ((ut32) 0x1));
	RzILOpEffect *set_usr_field_call_171 = hex_set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, CAST(32, IL_FALSE, SN(32, 1)));

	// HYB(gcc_expr_if ((sextract64(((ut64) ((st64) ((st32) ((Rxx >> 0x20) & 0xffffffff))) + (((st64) ((st32) ((st16) ((Rs >> 0x10) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x0) & 0xffff)))) << 0x1) - (((st64) ((st32) ((st16) ((Rs >> 0x0) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x10) & 0xffff)))) << 0x1)), 0x0, 0x20) == ((st64) ((st32) ((Rxx >> 0x20) & 0xffffffff))) + (((st64) ((st32) ((st16) ((Rs >> 0x10) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x0) & 0xffff)))) << 0x1) - (((st64) ((st32) ((st16) ((Rs >> 0x0) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x10) & 0xffff)))) << 0x1))) {{}} else {set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, ((ut32) 0x1))}, ((((st64) ((st32) ((Rxx >> 0x20) & 0xffffffff))) + (((st64) ((st32) ((st16) ((Rs >> 0x10) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x0) & 0xffff)))) << 0x1) - (((st64) ((st32) ((st16) ((Rs >> 0x0) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x10) & 0xffff)))) << 0x1) < ((st64) 0x0)) ? (-(0x1 << 0x1f)) : (0x1 << 0x1f) - ((st64) 0x1)));
	RzILOpPure *op_RSHIFT_14 = SHIFTRA(READ_REG(pkt, Rxx_op, false), SN(32, 0x20));
	RzILOpPure *op_AND_16 = LOGAND(op_RSHIFT_14, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_23 = SHIFTRA(Rs, SN(32, 16));
	RzILOpPure *op_AND_25 = LOGAND(op_RSHIFT_23, SN(32, 0xffff));
	RzILOpPure *op_RSHIFT_32 = SHIFTRA(Rt, SN(32, 0));
	RzILOpPure *op_AND_34 = LOGAND(op_RSHIFT_32, SN(32, 0xffff));
	RzILOpPure *op_MUL_37 = MUL(CAST(32, MSB(CAST(16, MSB(op_AND_25), DUP(op_AND_25))), CAST(16, MSB(DUP(op_AND_25)), DUP(op_AND_25))), CAST(32, MSB(CAST(16, MSB(op_AND_34), DUP(op_AND_34))), CAST(16, MSB(DUP(op_AND_34)), DUP(op_AND_34))));
	RzILOpPure *op_LSHIFT_40 = SHIFTL0(CAST(64, MSB(op_MUL_37), DUP(op_MUL_37)), SN(32, 1));
	RzILOpPure *op_ADD_41 = ADD(CAST(64, MSB(CAST(32, MSB(op_AND_16), DUP(op_AND_16))), CAST(32, MSB(DUP(op_AND_16)), DUP(op_AND_16))), op_LSHIFT_40);
	RzILOpPure *op_RSHIFT_45 = SHIFTRA(DUP(Rs), SN(32, 0));
	RzILOpPure *op_AND_47 = LOGAND(op_RSHIFT_45, SN(32, 0xffff));
	RzILOpPure *op_RSHIFT_53 = SHIFTRA(DUP(Rt), SN(32, 16));
	RzILOpPure *op_AND_55 = LOGAND(op_RSHIFT_53, SN(32, 0xffff));
	RzILOpPure *op_MUL_58 = MUL(CAST(32, MSB(CAST(16, MSB(op_AND_47), DUP(op_AND_47))), CAST(16, MSB(DUP(op_AND_47)), DUP(op_AND_47))), CAST(32, MSB(CAST(16, MSB(op_AND_55), DUP(op_AND_55))), CAST(16, MSB(DUP(op_AND_55)), DUP(op_AND_55))));
	RzILOpPure *op_LSHIFT_61 = SHIFTL0(CAST(64, MSB(op_MUL_58), DUP(op_MUL_58)), SN(32, 1));
	RzILOpPure *op_SUB_62 = SUB(op_ADD_41, op_LSHIFT_61);
	RzILOpPure *op_RSHIFT_71 = SHIFTRA(READ_REG(pkt, Rxx_op, false), SN(32, 0x20));
	RzILOpPure *op_AND_73 = LOGAND(op_RSHIFT_71, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_79 = SHIFTRA(DUP(Rs), SN(32, 16));
	RzILOpPure *op_AND_81 = LOGAND(op_RSHIFT_79, SN(32, 0xffff));
	RzILOpPure *op_RSHIFT_87 = SHIFTRA(DUP(Rt), SN(32, 0));
	RzILOpPure *op_AND_89 = LOGAND(op_RSHIFT_87, SN(32, 0xffff));
	RzILOpPure *op_MUL_92 = MUL(CAST(32, MSB(CAST(16, MSB(op_AND_81), DUP(op_AND_81))), CAST(16, MSB(DUP(op_AND_81)), DUP(op_AND_81))), CAST(32, MSB(CAST(16, MSB(op_AND_89), DUP(op_AND_89))), CAST(16, MSB(DUP(op_AND_89)), DUP(op_AND_89))));
	RzILOpPure *op_LSHIFT_95 = SHIFTL0(CAST(64, MSB(op_MUL_92), DUP(op_MUL_92)), SN(32, 1));
	RzILOpPure *op_ADD_96 = ADD(CAST(64, MSB(CAST(32, MSB(op_AND_73), DUP(op_AND_73))), CAST(32, MSB(DUP(op_AND_73)), DUP(op_AND_73))), op_LSHIFT_95);
	RzILOpPure *op_RSHIFT_100 = SHIFTRA(DUP(Rs), SN(32, 0));
	RzILOpPure *op_AND_102 = LOGAND(op_RSHIFT_100, SN(32, 0xffff));
	RzILOpPure *op_RSHIFT_108 = SHIFTRA(DUP(Rt), SN(32, 16));
	RzILOpPure *op_AND_110 = LOGAND(op_RSHIFT_108, SN(32, 0xffff));
	RzILOpPure *op_MUL_113 = MUL(CAST(32, MSB(CAST(16, MSB(op_AND_102), DUP(op_AND_102))), CAST(16, MSB(DUP(op_AND_102)), DUP(op_AND_102))), CAST(32, MSB(CAST(16, MSB(op_AND_110), DUP(op_AND_110))), CAST(16, MSB(DUP(op_AND_110)), DUP(op_AND_110))));
	RzILOpPure *op_LSHIFT_116 = SHIFTL0(CAST(64, MSB(op_MUL_113), DUP(op_MUL_113)), SN(32, 1));
	RzILOpPure *op_SUB_117 = SUB(op_ADD_96, op_LSHIFT_116);
	RzILOpPure *op_EQ_118 = EQ(SEXTRACT64(CAST(64, IL_FALSE, op_SUB_62), SN(32, 0), SN(32, 0x20)), op_SUB_117);
	RzILOpPure *op_RSHIFT_175 = SHIFTRA(READ_REG(pkt, Rxx_op, false), SN(32, 0x20));
	RzILOpPure *op_AND_177 = LOGAND(op_RSHIFT_175, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_183 = SHIFTRA(DUP(Rs), SN(32, 16));
	RzILOpPure *op_AND_185 = LOGAND(op_RSHIFT_183, SN(32, 0xffff));
	RzILOpPure *op_RSHIFT_191 = SHIFTRA(DUP(Rt), SN(32, 0));
	RzILOpPure *op_AND_193 = LOGAND(op_RSHIFT_191, SN(32, 0xffff));
	RzILOpPure *op_MUL_196 = MUL(CAST(32, MSB(CAST(16, MSB(op_AND_185), DUP(op_AND_185))), CAST(16, MSB(DUP(op_AND_185)), DUP(op_AND_185))), CAST(32, MSB(CAST(16, MSB(op_AND_193), DUP(op_AND_193))), CAST(16, MSB(DUP(op_AND_193)), DUP(op_AND_193))));
	RzILOpPure *op_LSHIFT_199 = SHIFTL0(CAST(64, MSB(op_MUL_196), DUP(op_MUL_196)), SN(32, 1));
	RzILOpPure *op_ADD_200 = ADD(CAST(64, MSB(CAST(32, MSB(op_AND_177), DUP(op_AND_177))), CAST(32, MSB(DUP(op_AND_177)), DUP(op_AND_177))), op_LSHIFT_199);
	RzILOpPure *op_RSHIFT_204 = SHIFTRA(DUP(Rs), SN(32, 0));
	RzILOpPure *op_AND_206 = LOGAND(op_RSHIFT_204, SN(32, 0xffff));
	RzILOpPure *op_RSHIFT_212 = SHIFTRA(DUP(Rt), SN(32, 16));
	RzILOpPure *op_AND_214 = LOGAND(op_RSHIFT_212, SN(32, 0xffff));
	RzILOpPure *op_MUL_217 = MUL(CAST(32, MSB(CAST(16, MSB(op_AND_206), DUP(op_AND_206))), CAST(16, MSB(DUP(op_AND_206)), DUP(op_AND_206))), CAST(32, MSB(CAST(16, MSB(op_AND_214), DUP(op_AND_214))), CAST(16, MSB(DUP(op_AND_214)), DUP(op_AND_214))));
	RzILOpPure *op_LSHIFT_220 = SHIFTL0(CAST(64, MSB(op_MUL_217), DUP(op_MUL_217)), SN(32, 1));
	RzILOpPure *op_SUB_221 = SUB(op_ADD_200, op_LSHIFT_220);
	RzILOpPure *op_LT_224 = SLT(op_SUB_221, CAST(64, MSB(SN(32, 0)), SN(32, 0)));
	RzILOpPure *op_LSHIFT_229 = SHIFTL0(SN(64, 1), SN(32, 31));
	RzILOpPure *op_NEG_230 = NEG(op_LSHIFT_229);
	RzILOpPure *op_LSHIFT_235 = SHIFTL0(SN(64, 1), SN(32, 31));
	RzILOpPure *op_SUB_238 = SUB(op_LSHIFT_235, CAST(64, MSB(SN(32, 1)), SN(32, 1)));
	RzILOpPure *cond_239 = ITE(op_LT_224, op_NEG_230, op_SUB_238);
	RzILOpEffect *gcc_expr_240 = BRANCH(op_EQ_118, EMPTY(), set_usr_field_call_171);

	// h_tmp238 = HYB(gcc_expr_if ((sextract64(((ut64) ((st64) ((st32) ((Rxx >> 0x20) & 0xffffffff))) + (((st64) ((st32) ((st16) ((Rs >> 0x10) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x0) & 0xffff)))) << 0x1) - (((st64) ((st32) ((st16) ((Rs >> 0x0) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x10) & 0xffff)))) << 0x1)), 0x0, 0x20) == ((st64) ((st32) ((Rxx >> 0x20) & 0xffffffff))) + (((st64) ((st32) ((st16) ((Rs >> 0x10) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x0) & 0xffff)))) << 0x1) - (((st64) ((st32) ((st16) ((Rs >> 0x0) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x10) & 0xffff)))) << 0x1))) {{}} else {set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, ((ut32) 0x1))}, ((((st64) ((st32) ((Rxx >> 0x20) & 0xffffffff))) + (((st64) ((st32) ((st16) ((Rs >> 0x10) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x0) & 0xffff)))) << 0x1) - (((st64) ((st32) ((st16) ((Rs >> 0x0) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x10) & 0xffff)))) << 0x1) < ((st64) 0x0)) ? (-(0x1 << 0x1f)) : (0x1 << 0x1f) - ((st64) 0x1)));
	RzILOpEffect *op_ASSIGN_hybrid_tmp_242 = SETL("h_tmp238", cond_239);

	// seq(HYB(gcc_expr_if ((sextract64(((ut64) ((st64) ((st32) ((Rxx > ...;
	RzILOpEffect *seq_243 = SEQN(2, gcc_expr_240, op_ASSIGN_hybrid_tmp_242);

	// Rxx = ((Rxx & (~(0xffffffff << 0x20))) | ((((sextract64(((ut64) ((st64) ((st32) ((Rxx >> 0x20) & 0xffffffff))) + (((st64) ((st32) ((st16) ((Rs >> 0x10) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x0) & 0xffff)))) << 0x1) - (((st64) ((st32) ((st16) ((Rs >> 0x0) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x10) & 0xffff)))) << 0x1)), 0x0, 0x20) == ((st64) ((st32) ((Rxx >> 0x20) & 0xffffffff))) + (((st64) ((st32) ((st16) ((Rs >> 0x10) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x0) & 0xffff)))) << 0x1) - (((st64) ((st32) ((st16) ((Rs >> 0x0) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x10) & 0xffff)))) << 0x1)) ? ((st64) ((st32) ((Rxx >> 0x20) & 0xffffffff))) + (((st64) ((st32) ((st16) ((Rs >> 0x10) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x0) & 0xffff)))) << 0x1) - (((st64) ((st32) ((st16) ((Rs >> 0x0) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x10) & 0xffff)))) << 0x1) : h_tmp238) & 0xffffffff) << 0x20));
	RzILOpPure *op_LSHIFT_5 = SHIFTL0(SN(64, 0xffffffff), SN(32, 0x20));
	RzILOpPure *op_NOT_6 = LOGNOT(op_LSHIFT_5);
	RzILOpPure *op_AND_7 = LOGAND(READ_REG(pkt, Rxx_op, false), op_NOT_6);
	RzILOpPure *op_RSHIFT_122 = SHIFTRA(READ_REG(pkt, Rxx_op, false), SN(32, 0x20));
	RzILOpPure *op_AND_124 = LOGAND(op_RSHIFT_122, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_130 = SHIFTRA(DUP(Rs), SN(32, 16));
	RzILOpPure *op_AND_132 = LOGAND(op_RSHIFT_130, SN(32, 0xffff));
	RzILOpPure *op_RSHIFT_138 = SHIFTRA(DUP(Rt), SN(32, 0));
	RzILOpPure *op_AND_140 = LOGAND(op_RSHIFT_138, SN(32, 0xffff));
	RzILOpPure *op_MUL_143 = MUL(CAST(32, MSB(CAST(16, MSB(op_AND_132), DUP(op_AND_132))), CAST(16, MSB(DUP(op_AND_132)), DUP(op_AND_132))), CAST(32, MSB(CAST(16, MSB(op_AND_140), DUP(op_AND_140))), CAST(16, MSB(DUP(op_AND_140)), DUP(op_AND_140))));
	RzILOpPure *op_LSHIFT_146 = SHIFTL0(CAST(64, MSB(op_MUL_143), DUP(op_MUL_143)), SN(32, 1));
	RzILOpPure *op_ADD_147 = ADD(CAST(64, MSB(CAST(32, MSB(op_AND_124), DUP(op_AND_124))), CAST(32, MSB(DUP(op_AND_124)), DUP(op_AND_124))), op_LSHIFT_146);
	RzILOpPure *op_RSHIFT_151 = SHIFTRA(DUP(Rs), SN(32, 0));
	RzILOpPure *op_AND_153 = LOGAND(op_RSHIFT_151, SN(32, 0xffff));
	RzILOpPure *op_RSHIFT_159 = SHIFTRA(DUP(Rt), SN(32, 16));
	RzILOpPure *op_AND_161 = LOGAND(op_RSHIFT_159, SN(32, 0xffff));
	RzILOpPure *op_MUL_164 = MUL(CAST(32, MSB(CAST(16, MSB(op_AND_153), DUP(op_AND_153))), CAST(16, MSB(DUP(op_AND_153)), DUP(op_AND_153))), CAST(32, MSB(CAST(16, MSB(op_AND_161), DUP(op_AND_161))), CAST(16, MSB(DUP(op_AND_161)), DUP(op_AND_161))));
	RzILOpPure *op_LSHIFT_167 = SHIFTL0(CAST(64, MSB(op_MUL_164), DUP(op_MUL_164)), SN(32, 1));
	RzILOpPure *op_SUB_168 = SUB(op_ADD_147, op_LSHIFT_167);
	RzILOpPure *cond_244 = ITE(DUP(op_EQ_118), op_SUB_168, VARL("h_tmp238"));
	RzILOpPure *op_AND_246 = LOGAND(cond_244, SN(64, 0xffffffff));
	RzILOpPure *op_LSHIFT_250 = SHIFTL0(op_AND_246, SN(32, 0x20));
	RzILOpPure *op_OR_251 = LOGOR(op_AND_7, op_LSHIFT_250);
	RzILOpEffect *op_ASSIGN_252 = WRITE_REG(bundle, Rxx_op, op_OR_251);

	// seq(seq(HYB(gcc_expr_if ((sextract64(((ut64) ((st64) ((st32) ((R ...;
	RzILOpEffect *seq_253 = SEQN(2, seq_243, op_ASSIGN_252);

	// set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, ((ut32) 0x1));
	RzILOpEffect *set_usr_field_call_423 = hex_set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, CAST(32, IL_FALSE, SN(32, 1)));

	// HYB(gcc_expr_if ((sextract64(((ut64) ((st64) ((st32) ((Rxx >> 0x0) & 0xffffffff))) + (((st64) ((st32) ((st16) ((Rs >> 0x0) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x0) & 0xffff)))) << 0x1) + (((st64) ((st32) ((st16) ((Rs >> 0x10) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x10) & 0xffff)))) << 0x1)), 0x0, 0x20) == ((st64) ((st32) ((Rxx >> 0x0) & 0xffffffff))) + (((st64) ((st32) ((st16) ((Rs >> 0x0) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x0) & 0xffff)))) << 0x1) + (((st64) ((st32) ((st16) ((Rs >> 0x10) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x10) & 0xffff)))) << 0x1))) {{}} else {set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, ((ut32) 0x1))}, ((((st64) ((st32) ((Rxx >> 0x0) & 0xffffffff))) + (((st64) ((st32) ((st16) ((Rs >> 0x0) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x0) & 0xffff)))) << 0x1) + (((st64) ((st32) ((st16) ((Rs >> 0x10) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x10) & 0xffff)))) << 0x1) < ((st64) 0x0)) ? (-(0x1 << 0x1f)) : (0x1 << 0x1f) - ((st64) 0x1)));
	RzILOpPure *op_RSHIFT_268 = SHIFTRA(READ_REG(pkt, Rxx_op, false), SN(32, 0));
	RzILOpPure *op_AND_270 = LOGAND(op_RSHIFT_268, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_276 = SHIFTRA(DUP(Rs), SN(32, 0));
	RzILOpPure *op_AND_278 = LOGAND(op_RSHIFT_276, SN(32, 0xffff));
	RzILOpPure *op_RSHIFT_284 = SHIFTRA(DUP(Rt), SN(32, 0));
	RzILOpPure *op_AND_286 = LOGAND(op_RSHIFT_284, SN(32, 0xffff));
	RzILOpPure *op_MUL_289 = MUL(CAST(32, MSB(CAST(16, MSB(op_AND_278), DUP(op_AND_278))), CAST(16, MSB(DUP(op_AND_278)), DUP(op_AND_278))), CAST(32, MSB(CAST(16, MSB(op_AND_286), DUP(op_AND_286))), CAST(16, MSB(DUP(op_AND_286)), DUP(op_AND_286))));
	RzILOpPure *op_LSHIFT_292 = SHIFTL0(CAST(64, MSB(op_MUL_289), DUP(op_MUL_289)), SN(32, 1));
	RzILOpPure *op_ADD_293 = ADD(CAST(64, MSB(CAST(32, MSB(op_AND_270), DUP(op_AND_270))), CAST(32, MSB(DUP(op_AND_270)), DUP(op_AND_270))), op_LSHIFT_292);
	RzILOpPure *op_RSHIFT_297 = SHIFTRA(DUP(Rs), SN(32, 16));
	RzILOpPure *op_AND_299 = LOGAND(op_RSHIFT_297, SN(32, 0xffff));
	RzILOpPure *op_RSHIFT_305 = SHIFTRA(DUP(Rt), SN(32, 16));
	RzILOpPure *op_AND_307 = LOGAND(op_RSHIFT_305, SN(32, 0xffff));
	RzILOpPure *op_MUL_310 = MUL(CAST(32, MSB(CAST(16, MSB(op_AND_299), DUP(op_AND_299))), CAST(16, MSB(DUP(op_AND_299)), DUP(op_AND_299))), CAST(32, MSB(CAST(16, MSB(op_AND_307), DUP(op_AND_307))), CAST(16, MSB(DUP(op_AND_307)), DUP(op_AND_307))));
	RzILOpPure *op_LSHIFT_313 = SHIFTL0(CAST(64, MSB(op_MUL_310), DUP(op_MUL_310)), SN(32, 1));
	RzILOpPure *op_ADD_314 = ADD(op_ADD_293, op_LSHIFT_313);
	RzILOpPure *op_RSHIFT_323 = SHIFTRA(READ_REG(pkt, Rxx_op, false), SN(32, 0));
	RzILOpPure *op_AND_325 = LOGAND(op_RSHIFT_323, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_331 = SHIFTRA(DUP(Rs), SN(32, 0));
	RzILOpPure *op_AND_333 = LOGAND(op_RSHIFT_331, SN(32, 0xffff));
	RzILOpPure *op_RSHIFT_339 = SHIFTRA(DUP(Rt), SN(32, 0));
	RzILOpPure *op_AND_341 = LOGAND(op_RSHIFT_339, SN(32, 0xffff));
	RzILOpPure *op_MUL_344 = MUL(CAST(32, MSB(CAST(16, MSB(op_AND_333), DUP(op_AND_333))), CAST(16, MSB(DUP(op_AND_333)), DUP(op_AND_333))), CAST(32, MSB(CAST(16, MSB(op_AND_341), DUP(op_AND_341))), CAST(16, MSB(DUP(op_AND_341)), DUP(op_AND_341))));
	RzILOpPure *op_LSHIFT_347 = SHIFTL0(CAST(64, MSB(op_MUL_344), DUP(op_MUL_344)), SN(32, 1));
	RzILOpPure *op_ADD_348 = ADD(CAST(64, MSB(CAST(32, MSB(op_AND_325), DUP(op_AND_325))), CAST(32, MSB(DUP(op_AND_325)), DUP(op_AND_325))), op_LSHIFT_347);
	RzILOpPure *op_RSHIFT_352 = SHIFTRA(DUP(Rs), SN(32, 16));
	RzILOpPure *op_AND_354 = LOGAND(op_RSHIFT_352, SN(32, 0xffff));
	RzILOpPure *op_RSHIFT_360 = SHIFTRA(DUP(Rt), SN(32, 16));
	RzILOpPure *op_AND_362 = LOGAND(op_RSHIFT_360, SN(32, 0xffff));
	RzILOpPure *op_MUL_365 = MUL(CAST(32, MSB(CAST(16, MSB(op_AND_354), DUP(op_AND_354))), CAST(16, MSB(DUP(op_AND_354)), DUP(op_AND_354))), CAST(32, MSB(CAST(16, MSB(op_AND_362), DUP(op_AND_362))), CAST(16, MSB(DUP(op_AND_362)), DUP(op_AND_362))));
	RzILOpPure *op_LSHIFT_368 = SHIFTL0(CAST(64, MSB(op_MUL_365), DUP(op_MUL_365)), SN(32, 1));
	RzILOpPure *op_ADD_369 = ADD(op_ADD_348, op_LSHIFT_368);
	RzILOpPure *op_EQ_370 = EQ(SEXTRACT64(CAST(64, IL_FALSE, op_ADD_314), SN(32, 0), SN(32, 0x20)), op_ADD_369);
	RzILOpPure *op_RSHIFT_427 = SHIFTRA(READ_REG(pkt, Rxx_op, false), SN(32, 0));
	RzILOpPure *op_AND_429 = LOGAND(op_RSHIFT_427, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_435 = SHIFTRA(DUP(Rs), SN(32, 0));
	RzILOpPure *op_AND_437 = LOGAND(op_RSHIFT_435, SN(32, 0xffff));
	RzILOpPure *op_RSHIFT_443 = SHIFTRA(DUP(Rt), SN(32, 0));
	RzILOpPure *op_AND_445 = LOGAND(op_RSHIFT_443, SN(32, 0xffff));
	RzILOpPure *op_MUL_448 = MUL(CAST(32, MSB(CAST(16, MSB(op_AND_437), DUP(op_AND_437))), CAST(16, MSB(DUP(op_AND_437)), DUP(op_AND_437))), CAST(32, MSB(CAST(16, MSB(op_AND_445), DUP(op_AND_445))), CAST(16, MSB(DUP(op_AND_445)), DUP(op_AND_445))));
	RzILOpPure *op_LSHIFT_451 = SHIFTL0(CAST(64, MSB(op_MUL_448), DUP(op_MUL_448)), SN(32, 1));
	RzILOpPure *op_ADD_452 = ADD(CAST(64, MSB(CAST(32, MSB(op_AND_429), DUP(op_AND_429))), CAST(32, MSB(DUP(op_AND_429)), DUP(op_AND_429))), op_LSHIFT_451);
	RzILOpPure *op_RSHIFT_456 = SHIFTRA(DUP(Rs), SN(32, 16));
	RzILOpPure *op_AND_458 = LOGAND(op_RSHIFT_456, SN(32, 0xffff));
	RzILOpPure *op_RSHIFT_464 = SHIFTRA(DUP(Rt), SN(32, 16));
	RzILOpPure *op_AND_466 = LOGAND(op_RSHIFT_464, SN(32, 0xffff));
	RzILOpPure *op_MUL_469 = MUL(CAST(32, MSB(CAST(16, MSB(op_AND_458), DUP(op_AND_458))), CAST(16, MSB(DUP(op_AND_458)), DUP(op_AND_458))), CAST(32, MSB(CAST(16, MSB(op_AND_466), DUP(op_AND_466))), CAST(16, MSB(DUP(op_AND_466)), DUP(op_AND_466))));
	RzILOpPure *op_LSHIFT_472 = SHIFTL0(CAST(64, MSB(op_MUL_469), DUP(op_MUL_469)), SN(32, 1));
	RzILOpPure *op_ADD_473 = ADD(op_ADD_452, op_LSHIFT_472);
	RzILOpPure *op_LT_476 = SLT(op_ADD_473, CAST(64, MSB(SN(32, 0)), SN(32, 0)));
	RzILOpPure *op_LSHIFT_481 = SHIFTL0(SN(64, 1), SN(32, 31));
	RzILOpPure *op_NEG_482 = NEG(op_LSHIFT_481);
	RzILOpPure *op_LSHIFT_487 = SHIFTL0(SN(64, 1), SN(32, 31));
	RzILOpPure *op_SUB_490 = SUB(op_LSHIFT_487, CAST(64, MSB(SN(32, 1)), SN(32, 1)));
	RzILOpPure *cond_491 = ITE(op_LT_476, op_NEG_482, op_SUB_490);
	RzILOpEffect *gcc_expr_492 = BRANCH(op_EQ_370, EMPTY(), set_usr_field_call_423);

	// h_tmp239 = HYB(gcc_expr_if ((sextract64(((ut64) ((st64) ((st32) ((Rxx >> 0x0) & 0xffffffff))) + (((st64) ((st32) ((st16) ((Rs >> 0x0) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x0) & 0xffff)))) << 0x1) + (((st64) ((st32) ((st16) ((Rs >> 0x10) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x10) & 0xffff)))) << 0x1)), 0x0, 0x20) == ((st64) ((st32) ((Rxx >> 0x0) & 0xffffffff))) + (((st64) ((st32) ((st16) ((Rs >> 0x0) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x0) & 0xffff)))) << 0x1) + (((st64) ((st32) ((st16) ((Rs >> 0x10) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x10) & 0xffff)))) << 0x1))) {{}} else {set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, ((ut32) 0x1))}, ((((st64) ((st32) ((Rxx >> 0x0) & 0xffffffff))) + (((st64) ((st32) ((st16) ((Rs >> 0x0) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x0) & 0xffff)))) << 0x1) + (((st64) ((st32) ((st16) ((Rs >> 0x10) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x10) & 0xffff)))) << 0x1) < ((st64) 0x0)) ? (-(0x1 << 0x1f)) : (0x1 << 0x1f) - ((st64) 0x1)));
	RzILOpEffect *op_ASSIGN_hybrid_tmp_494 = SETL("h_tmp239", cond_491);

	// seq(HYB(gcc_expr_if ((sextract64(((ut64) ((st64) ((st32) ((Rxx > ...;
	RzILOpEffect *seq_495 = SEQN(2, gcc_expr_492, op_ASSIGN_hybrid_tmp_494);

	// Rxx = ((Rxx & (~(0xffffffff << 0x0))) | ((((sextract64(((ut64) ((st64) ((st32) ((Rxx >> 0x0) & 0xffffffff))) + (((st64) ((st32) ((st16) ((Rs >> 0x0) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x0) & 0xffff)))) << 0x1) + (((st64) ((st32) ((st16) ((Rs >> 0x10) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x10) & 0xffff)))) << 0x1)), 0x0, 0x20) == ((st64) ((st32) ((Rxx >> 0x0) & 0xffffffff))) + (((st64) ((st32) ((st16) ((Rs >> 0x0) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x0) & 0xffff)))) << 0x1) + (((st64) ((st32) ((st16) ((Rs >> 0x10) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x10) & 0xffff)))) << 0x1)) ? ((st64) ((st32) ((Rxx >> 0x0) & 0xffffffff))) + (((st64) ((st32) ((st16) ((Rs >> 0x0) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x0) & 0xffff)))) << 0x1) + (((st64) ((st32) ((st16) ((Rs >> 0x10) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x10) & 0xffff)))) << 0x1) : h_tmp239) & 0xffffffff) << 0x0));
	RzILOpPure *op_LSHIFT_259 = SHIFTL0(SN(64, 0xffffffff), SN(32, 0));
	RzILOpPure *op_NOT_260 = LOGNOT(op_LSHIFT_259);
	RzILOpPure *op_AND_261 = LOGAND(READ_REG(pkt, Rxx_op, false), op_NOT_260);
	RzILOpPure *op_RSHIFT_374 = SHIFTRA(READ_REG(pkt, Rxx_op, false), SN(32, 0));
	RzILOpPure *op_AND_376 = LOGAND(op_RSHIFT_374, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_382 = SHIFTRA(DUP(Rs), SN(32, 0));
	RzILOpPure *op_AND_384 = LOGAND(op_RSHIFT_382, SN(32, 0xffff));
	RzILOpPure *op_RSHIFT_390 = SHIFTRA(DUP(Rt), SN(32, 0));
	RzILOpPure *op_AND_392 = LOGAND(op_RSHIFT_390, SN(32, 0xffff));
	RzILOpPure *op_MUL_395 = MUL(CAST(32, MSB(CAST(16, MSB(op_AND_384), DUP(op_AND_384))), CAST(16, MSB(DUP(op_AND_384)), DUP(op_AND_384))), CAST(32, MSB(CAST(16, MSB(op_AND_392), DUP(op_AND_392))), CAST(16, MSB(DUP(op_AND_392)), DUP(op_AND_392))));
	RzILOpPure *op_LSHIFT_398 = SHIFTL0(CAST(64, MSB(op_MUL_395), DUP(op_MUL_395)), SN(32, 1));
	RzILOpPure *op_ADD_399 = ADD(CAST(64, MSB(CAST(32, MSB(op_AND_376), DUP(op_AND_376))), CAST(32, MSB(DUP(op_AND_376)), DUP(op_AND_376))), op_LSHIFT_398);
	RzILOpPure *op_RSHIFT_403 = SHIFTRA(DUP(Rs), SN(32, 16));
	RzILOpPure *op_AND_405 = LOGAND(op_RSHIFT_403, SN(32, 0xffff));
	RzILOpPure *op_RSHIFT_411 = SHIFTRA(DUP(Rt), SN(32, 16));
	RzILOpPure *op_AND_413 = LOGAND(op_RSHIFT_411, SN(32, 0xffff));
	RzILOpPure *op_MUL_416 = MUL(CAST(32, MSB(CAST(16, MSB(op_AND_405), DUP(op_AND_405))), CAST(16, MSB(DUP(op_AND_405)), DUP(op_AND_405))), CAST(32, MSB(CAST(16, MSB(op_AND_413), DUP(op_AND_413))), CAST(16, MSB(DUP(op_AND_413)), DUP(op_AND_413))));
	RzILOpPure *op_LSHIFT_419 = SHIFTL0(CAST(64, MSB(op_MUL_416), DUP(op_MUL_416)), SN(32, 1));
	RzILOpPure *op_ADD_420 = ADD(op_ADD_399, op_LSHIFT_419);
	RzILOpPure *cond_496 = ITE(DUP(op_EQ_370), op_ADD_420, VARL("h_tmp239"));
	RzILOpPure *op_AND_498 = LOGAND(cond_496, SN(64, 0xffffffff));
	RzILOpPure *op_LSHIFT_502 = SHIFTL0(op_AND_498, SN(32, 0));
	RzILOpPure *op_OR_503 = LOGOR(op_AND_261, op_LSHIFT_502);
	RzILOpEffect *op_ASSIGN_504 = WRITE_REG(bundle, Rxx_op, op_OR_503);

	// seq(seq(HYB(gcc_expr_if ((sextract64(((ut64) ((st64) ((st32) ((R ...;
	RzILOpEffect *seq_505 = SEQN(2, seq_495, op_ASSIGN_504);

	RzILOpEffect *instruction_sequence = SEQN(2, seq_253, seq_505);
	return instruction_sequence;
}

// Rdd = cmpyi(Rs,Rt)
RzILOpEffect *hex_il_op_m2_cmpyi_s0(HexInsnPktBundle *bundle) {
	const HexInsn *hi = bundle->insn;
	HexPkt *pkt = bundle->pkt;
	// READ
	const HexOp *Rdd_op = ISA2REG(hi, 'd', false);
	const HexOp *Rs_op = ISA2REG(hi, 's', false);
	RzILOpPure *Rs = READ_REG(pkt, Rs_op, false);
	const HexOp *Rt_op = ISA2REG(hi, 't', false);
	RzILOpPure *Rt = READ_REG(pkt, Rt_op, false);

	// Rdd = ((st64) ((st32) ((st16) ((Rs >> 0x10) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x0) & 0xffff)))) + ((st64) ((st32) ((st16) ((Rs >> 0x0) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x10) & 0xffff))));
	RzILOpPure *op_RSHIFT_5 = SHIFTRA(Rs, SN(32, 16));
	RzILOpPure *op_AND_7 = LOGAND(op_RSHIFT_5, SN(32, 0xffff));
	RzILOpPure *op_RSHIFT_14 = SHIFTRA(Rt, SN(32, 0));
	RzILOpPure *op_AND_16 = LOGAND(op_RSHIFT_14, SN(32, 0xffff));
	RzILOpPure *op_MUL_19 = MUL(CAST(32, MSB(CAST(16, MSB(op_AND_7), DUP(op_AND_7))), CAST(16, MSB(DUP(op_AND_7)), DUP(op_AND_7))), CAST(32, MSB(CAST(16, MSB(op_AND_16), DUP(op_AND_16))), CAST(16, MSB(DUP(op_AND_16)), DUP(op_AND_16))));
	RzILOpPure *op_RSHIFT_24 = SHIFTRA(DUP(Rs), SN(32, 0));
	RzILOpPure *op_AND_26 = LOGAND(op_RSHIFT_24, SN(32, 0xffff));
	RzILOpPure *op_RSHIFT_32 = SHIFTRA(DUP(Rt), SN(32, 16));
	RzILOpPure *op_AND_34 = LOGAND(op_RSHIFT_32, SN(32, 0xffff));
	RzILOpPure *op_MUL_37 = MUL(CAST(32, MSB(CAST(16, MSB(op_AND_26), DUP(op_AND_26))), CAST(16, MSB(DUP(op_AND_26)), DUP(op_AND_26))), CAST(32, MSB(CAST(16, MSB(op_AND_34), DUP(op_AND_34))), CAST(16, MSB(DUP(op_AND_34)), DUP(op_AND_34))));
	RzILOpPure *op_ADD_39 = ADD(CAST(64, MSB(op_MUL_19), DUP(op_MUL_19)), CAST(64, MSB(op_MUL_37), DUP(op_MUL_37)));
	RzILOpEffect *op_ASSIGN_40 = WRITE_REG(bundle, Rdd_op, op_ADD_39);

	RzILOpEffect *instruction_sequence = op_ASSIGN_40;
	return instruction_sequence;
}

// Rdd = cmpyr(Rs,Rt)
RzILOpEffect *hex_il_op_m2_cmpyr_s0(HexInsnPktBundle *bundle) {
	const HexInsn *hi = bundle->insn;
	HexPkt *pkt = bundle->pkt;
	// READ
	const HexOp *Rdd_op = ISA2REG(hi, 'd', false);
	const HexOp *Rs_op = ISA2REG(hi, 's', false);
	RzILOpPure *Rs = READ_REG(pkt, Rs_op, false);
	const HexOp *Rt_op = ISA2REG(hi, 't', false);
	RzILOpPure *Rt = READ_REG(pkt, Rt_op, false);

	// Rdd = ((st64) ((st32) ((st16) ((Rs >> 0x0) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x0) & 0xffff)))) - ((st64) ((st32) ((st16) ((Rs >> 0x10) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x10) & 0xffff))));
	RzILOpPure *op_RSHIFT_5 = SHIFTRA(Rs, SN(32, 0));
	RzILOpPure *op_AND_7 = LOGAND(op_RSHIFT_5, SN(32, 0xffff));
	RzILOpPure *op_RSHIFT_14 = SHIFTRA(Rt, SN(32, 0));
	RzILOpPure *op_AND_16 = LOGAND(op_RSHIFT_14, SN(32, 0xffff));
	RzILOpPure *op_MUL_19 = MUL(CAST(32, MSB(CAST(16, MSB(op_AND_7), DUP(op_AND_7))), CAST(16, MSB(DUP(op_AND_7)), DUP(op_AND_7))), CAST(32, MSB(CAST(16, MSB(op_AND_16), DUP(op_AND_16))), CAST(16, MSB(DUP(op_AND_16)), DUP(op_AND_16))));
	RzILOpPure *op_RSHIFT_24 = SHIFTRA(DUP(Rs), SN(32, 16));
	RzILOpPure *op_AND_26 = LOGAND(op_RSHIFT_24, SN(32, 0xffff));
	RzILOpPure *op_RSHIFT_32 = SHIFTRA(DUP(Rt), SN(32, 16));
	RzILOpPure *op_AND_34 = LOGAND(op_RSHIFT_32, SN(32, 0xffff));
	RzILOpPure *op_MUL_37 = MUL(CAST(32, MSB(CAST(16, MSB(op_AND_26), DUP(op_AND_26))), CAST(16, MSB(DUP(op_AND_26)), DUP(op_AND_26))), CAST(32, MSB(CAST(16, MSB(op_AND_34), DUP(op_AND_34))), CAST(16, MSB(DUP(op_AND_34)), DUP(op_AND_34))));
	RzILOpPure *op_SUB_39 = SUB(CAST(64, MSB(op_MUL_19), DUP(op_MUL_19)), CAST(64, MSB(op_MUL_37), DUP(op_MUL_37)));
	RzILOpEffect *op_ASSIGN_40 = WRITE_REG(bundle, Rdd_op, op_SUB_39);

	RzILOpEffect *instruction_sequence = op_ASSIGN_40;
	return instruction_sequence;
}

// Rd = cmpy(Rs,Rt):rnd:sat
RzILOpEffect *hex_il_op_m2_cmpyrs_s0(HexInsnPktBundle *bundle) {
	const HexInsn *hi = bundle->insn;
	HexPkt *pkt = bundle->pkt;
	// READ
	const HexOp *Rd_op = ISA2REG(hi, 'd', false);
	const HexOp *Rs_op = ISA2REG(hi, 's', false);
	RzILOpPure *Rs = READ_REG(pkt, Rs_op, false);
	const HexOp *Rt_op = ISA2REG(hi, 't', false);
	RzILOpPure *Rt = READ_REG(pkt, Rt_op, false);

	// set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, ((ut32) 0x1));
	RzILOpEffect *set_usr_field_call_154 = hex_set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, CAST(32, IL_FALSE, SN(32, 1)));

	// HYB(gcc_expr_if ((sextract64(((ut64) (((st64) ((st32) ((st16) ((Rs >> 0x10) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x0) & 0xffff)))) << 0x0) + (((st64) ((st32) ((st16) ((Rs >> 0x0) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x10) & 0xffff)))) << 0x0) + ((st64) 0x8000)), 0x0, 0x20) == (((st64) ((st32) ((st16) ((Rs >> 0x10) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x0) & 0xffff)))) << 0x0) + (((st64) ((st32) ((st16) ((Rs >> 0x0) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x10) & 0xffff)))) << 0x0) + ((st64) 0x8000))) {{}} else {set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, ((ut32) 0x1))}, (((((st64) ((st32) ((st16) ((Rs >> 0x10) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x0) & 0xffff)))) << 0x0) + (((st64) ((st32) ((st16) ((Rs >> 0x0) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x10) & 0xffff)))) << 0x0) + ((st64) 0x8000) < ((st64) 0x0)) ? (-(0x1 << 0x1f)) : (0x1 << 0x1f) - ((st64) 0x1)));
	RzILOpPure *op_RSHIFT_16 = SHIFTRA(Rs, SN(32, 16));
	RzILOpPure *op_AND_18 = LOGAND(op_RSHIFT_16, SN(32, 0xffff));
	RzILOpPure *op_RSHIFT_25 = SHIFTRA(Rt, SN(32, 0));
	RzILOpPure *op_AND_27 = LOGAND(op_RSHIFT_25, SN(32, 0xffff));
	RzILOpPure *op_MUL_30 = MUL(CAST(32, MSB(CAST(16, MSB(op_AND_18), DUP(op_AND_18))), CAST(16, MSB(DUP(op_AND_18)), DUP(op_AND_18))), CAST(32, MSB(CAST(16, MSB(op_AND_27), DUP(op_AND_27))), CAST(16, MSB(DUP(op_AND_27)), DUP(op_AND_27))));
	RzILOpPure *op_LSHIFT_33 = SHIFTL0(CAST(64, MSB(op_MUL_30), DUP(op_MUL_30)), SN(32, 0));
	RzILOpPure *op_RSHIFT_37 = SHIFTRA(DUP(Rs), SN(32, 0));
	RzILOpPure *op_AND_39 = LOGAND(op_RSHIFT_37, SN(32, 0xffff));
	RzILOpPure *op_RSHIFT_45 = SHIFTRA(DUP(Rt), SN(32, 16));
	RzILOpPure *op_AND_47 = LOGAND(op_RSHIFT_45, SN(32, 0xffff));
	RzILOpPure *op_MUL_50 = MUL(CAST(32, MSB(CAST(16, MSB(op_AND_39), DUP(op_AND_39))), CAST(16, MSB(DUP(op_AND_39)), DUP(op_AND_39))), CAST(32, MSB(CAST(16, MSB(op_AND_47), DUP(op_AND_47))), CAST(16, MSB(DUP(op_AND_47)), DUP(op_AND_47))));
	RzILOpPure *op_LSHIFT_53 = SHIFTL0(CAST(64, MSB(op_MUL_50), DUP(op_MUL_50)), SN(32, 0));
	RzILOpPure *op_ADD_54 = ADD(op_LSHIFT_33, op_LSHIFT_53);
	RzILOpPure *op_ADD_57 = ADD(op_ADD_54, CAST(64, MSB(SN(32, 0x8000)), SN(32, 0x8000)));
	RzILOpPure *op_RSHIFT_66 = SHIFTRA(DUP(Rs), SN(32, 16));
	RzILOpPure *op_AND_68 = LOGAND(op_RSHIFT_66, SN(32, 0xffff));
	RzILOpPure *op_RSHIFT_74 = SHIFTRA(DUP(Rt), SN(32, 0));
	RzILOpPure *op_AND_76 = LOGAND(op_RSHIFT_74, SN(32, 0xffff));
	RzILOpPure *op_MUL_79 = MUL(CAST(32, MSB(CAST(16, MSB(op_AND_68), DUP(op_AND_68))), CAST(16, MSB(DUP(op_AND_68)), DUP(op_AND_68))), CAST(32, MSB(CAST(16, MSB(op_AND_76), DUP(op_AND_76))), CAST(16, MSB(DUP(op_AND_76)), DUP(op_AND_76))));
	RzILOpPure *op_LSHIFT_82 = SHIFTL0(CAST(64, MSB(op_MUL_79), DUP(op_MUL_79)), SN(32, 0));
	RzILOpPure *op_RSHIFT_86 = SHIFTRA(DUP(Rs), SN(32, 0));
	RzILOpPure *op_AND_88 = LOGAND(op_RSHIFT_86, SN(32, 0xffff));
	RzILOpPure *op_RSHIFT_94 = SHIFTRA(DUP(Rt), SN(32, 16));
	RzILOpPure *op_AND_96 = LOGAND(op_RSHIFT_94, SN(32, 0xffff));
	RzILOpPure *op_MUL_99 = MUL(CAST(32, MSB(CAST(16, MSB(op_AND_88), DUP(op_AND_88))), CAST(16, MSB(DUP(op_AND_88)), DUP(op_AND_88))), CAST(32, MSB(CAST(16, MSB(op_AND_96), DUP(op_AND_96))), CAST(16, MSB(DUP(op_AND_96)), DUP(op_AND_96))));
	RzILOpPure *op_LSHIFT_102 = SHIFTL0(CAST(64, MSB(op_MUL_99), DUP(op_MUL_99)), SN(32, 0));
	RzILOpPure *op_ADD_103 = ADD(op_LSHIFT_82, op_LSHIFT_102);
	RzILOpPure *op_ADD_106 = ADD(op_ADD_103, CAST(64, MSB(SN(32, 0x8000)), SN(32, 0x8000)));
	RzILOpPure *op_EQ_107 = EQ(SEXTRACT64(CAST(64, IL_FALSE, op_ADD_57), SN(32, 0), SN(32, 0x20)), op_ADD_106);
	RzILOpPure *op_RSHIFT_158 = SHIFTRA(DUP(Rs), SN(32, 16));
	RzILOpPure *op_AND_160 = LOGAND(op_RSHIFT_158, SN(32, 0xffff));
	RzILOpPure *op_RSHIFT_166 = SHIFTRA(DUP(Rt), SN(32, 0));
	RzILOpPure *op_AND_168 = LOGAND(op_RSHIFT_166, SN(32, 0xffff));
	RzILOpPure *op_MUL_171 = MUL(CAST(32, MSB(CAST(16, MSB(op_AND_160), DUP(op_AND_160))), CAST(16, MSB(DUP(op_AND_160)), DUP(op_AND_160))), CAST(32, MSB(CAST(16, MSB(op_AND_168), DUP(op_AND_168))), CAST(16, MSB(DUP(op_AND_168)), DUP(op_AND_168))));
	RzILOpPure *op_LSHIFT_174 = SHIFTL0(CAST(64, MSB(op_MUL_171), DUP(op_MUL_171)), SN(32, 0));
	RzILOpPure *op_RSHIFT_178 = SHIFTRA(DUP(Rs), SN(32, 0));
	RzILOpPure *op_AND_180 = LOGAND(op_RSHIFT_178, SN(32, 0xffff));
	RzILOpPure *op_RSHIFT_186 = SHIFTRA(DUP(Rt), SN(32, 16));
	RzILOpPure *op_AND_188 = LOGAND(op_RSHIFT_186, SN(32, 0xffff));
	RzILOpPure *op_MUL_191 = MUL(CAST(32, MSB(CAST(16, MSB(op_AND_180), DUP(op_AND_180))), CAST(16, MSB(DUP(op_AND_180)), DUP(op_AND_180))), CAST(32, MSB(CAST(16, MSB(op_AND_188), DUP(op_AND_188))), CAST(16, MSB(DUP(op_AND_188)), DUP(op_AND_188))));
	RzILOpPure *op_LSHIFT_194 = SHIFTL0(CAST(64, MSB(op_MUL_191), DUP(op_MUL_191)), SN(32, 0));
	RzILOpPure *op_ADD_195 = ADD(op_LSHIFT_174, op_LSHIFT_194);
	RzILOpPure *op_ADD_198 = ADD(op_ADD_195, CAST(64, MSB(SN(32, 0x8000)), SN(32, 0x8000)));
	RzILOpPure *op_LT_201 = SLT(op_ADD_198, CAST(64, MSB(SN(32, 0)), SN(32, 0)));
	RzILOpPure *op_LSHIFT_206 = SHIFTL0(SN(64, 1), SN(32, 31));
	RzILOpPure *op_NEG_207 = NEG(op_LSHIFT_206);
	RzILOpPure *op_LSHIFT_212 = SHIFTL0(SN(64, 1), SN(32, 31));
	RzILOpPure *op_SUB_215 = SUB(op_LSHIFT_212, CAST(64, MSB(SN(32, 1)), SN(32, 1)));
	RzILOpPure *cond_216 = ITE(op_LT_201, op_NEG_207, op_SUB_215);
	RzILOpEffect *gcc_expr_217 = BRANCH(op_EQ_107, EMPTY(), set_usr_field_call_154);

	// h_tmp240 = HYB(gcc_expr_if ((sextract64(((ut64) (((st64) ((st32) ((st16) ((Rs >> 0x10) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x0) & 0xffff)))) << 0x0) + (((st64) ((st32) ((st16) ((Rs >> 0x0) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x10) & 0xffff)))) << 0x0) + ((st64) 0x8000)), 0x0, 0x20) == (((st64) ((st32) ((st16) ((Rs >> 0x10) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x0) & 0xffff)))) << 0x0) + (((st64) ((st32) ((st16) ((Rs >> 0x0) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x10) & 0xffff)))) << 0x0) + ((st64) 0x8000))) {{}} else {set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, ((ut32) 0x1))}, (((((st64) ((st32) ((st16) ((Rs >> 0x10) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x0) & 0xffff)))) << 0x0) + (((st64) ((st32) ((st16) ((Rs >> 0x0) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x10) & 0xffff)))) << 0x0) + ((st64) 0x8000) < ((st64) 0x0)) ? (-(0x1 << 0x1f)) : (0x1 << 0x1f) - ((st64) 0x1)));
	RzILOpEffect *op_ASSIGN_hybrid_tmp_219 = SETL("h_tmp240", cond_216);

	// seq(HYB(gcc_expr_if ((sextract64(((ut64) (((st64) ((st32) ((st16 ...;
	RzILOpEffect *seq_220 = SEQN(2, gcc_expr_217, op_ASSIGN_hybrid_tmp_219);

	// Rd = ((st32) (((ut64) (((st64) Rd) & (~(0xffff << 0x10)))) | (((ut64) (((st32) ((st16) ((((sextract64(((ut64) (((st64) ((st32) ((st16) ((Rs >> 0x10) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x0) & 0xffff)))) << 0x0) + (((st64) ((st32) ((st16) ((Rs >> 0x0) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x10) & 0xffff)))) << 0x0) + ((st64) 0x8000)), 0x0, 0x20) == (((st64) ((st32) ((st16) ((Rs >> 0x10) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x0) & 0xffff)))) << 0x0) + (((st64) ((st32) ((st16) ((Rs >> 0x0) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x10) & 0xffff)))) << 0x0) + ((st64) 0x8000)) ? (((st64) ((st32) ((st16) ((Rs >> 0x10) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x0) & 0xffff)))) << 0x0) + (((st64) ((st32) ((st16) ((Rs >> 0x0) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x10) & 0xffff)))) << 0x0) + ((st64) 0x8000) : h_tmp240) >> 0x10) & ((st64) 0xffff)))) & 0xffff)) << 0x10)));
	RzILOpPure *op_LSHIFT_5 = SHIFTL0(SN(64, 0xffff), SN(32, 16));
	RzILOpPure *op_NOT_6 = LOGNOT(op_LSHIFT_5);
	RzILOpPure *op_AND_8 = LOGAND(CAST(64, MSB(READ_REG(pkt, Rd_op, true)), READ_REG(pkt, Rd_op, true)), op_NOT_6);
	RzILOpPure *op_RSHIFT_111 = SHIFTRA(DUP(Rs), SN(32, 16));
	RzILOpPure *op_AND_113 = LOGAND(op_RSHIFT_111, SN(32, 0xffff));
	RzILOpPure *op_RSHIFT_119 = SHIFTRA(DUP(Rt), SN(32, 0));
	RzILOpPure *op_AND_121 = LOGAND(op_RSHIFT_119, SN(32, 0xffff));
	RzILOpPure *op_MUL_124 = MUL(CAST(32, MSB(CAST(16, MSB(op_AND_113), DUP(op_AND_113))), CAST(16, MSB(DUP(op_AND_113)), DUP(op_AND_113))), CAST(32, MSB(CAST(16, MSB(op_AND_121), DUP(op_AND_121))), CAST(16, MSB(DUP(op_AND_121)), DUP(op_AND_121))));
	RzILOpPure *op_LSHIFT_127 = SHIFTL0(CAST(64, MSB(op_MUL_124), DUP(op_MUL_124)), SN(32, 0));
	RzILOpPure *op_RSHIFT_131 = SHIFTRA(DUP(Rs), SN(32, 0));
	RzILOpPure *op_AND_133 = LOGAND(op_RSHIFT_131, SN(32, 0xffff));
	RzILOpPure *op_RSHIFT_139 = SHIFTRA(DUP(Rt), SN(32, 16));
	RzILOpPure *op_AND_141 = LOGAND(op_RSHIFT_139, SN(32, 0xffff));
	RzILOpPure *op_MUL_144 = MUL(CAST(32, MSB(CAST(16, MSB(op_AND_133), DUP(op_AND_133))), CAST(16, MSB(DUP(op_AND_133)), DUP(op_AND_133))), CAST(32, MSB(CAST(16, MSB(op_AND_141), DUP(op_AND_141))), CAST(16, MSB(DUP(op_AND_141)), DUP(op_AND_141))));
	RzILOpPure *op_LSHIFT_147 = SHIFTL0(CAST(64, MSB(op_MUL_144), DUP(op_MUL_144)), SN(32, 0));
	RzILOpPure *op_ADD_148 = ADD(op_LSHIFT_127, op_LSHIFT_147);
	RzILOpPure *op_ADD_151 = ADD(op_ADD_148, CAST(64, MSB(SN(32, 0x8000)), SN(32, 0x8000)));
	RzILOpPure *cond_221 = ITE(DUP(op_EQ_107), op_ADD_151, VARL("h_tmp240"));
	RzILOpPure *op_RSHIFT_225 = SHIFTRA(cond_221, SN(32, 16));
	RzILOpPure *op_AND_228 = LOGAND(op_RSHIFT_225, CAST(64, MSB(SN(32, 0xffff)), SN(32, 0xffff)));
	RzILOpPure *op_AND_232 = LOGAND(CAST(32, MSB(CAST(16, MSB(op_AND_228), DUP(op_AND_228))), CAST(16, MSB(DUP(op_AND_228)), DUP(op_AND_228))), SN(32, 0xffff));
	RzILOpPure *op_LSHIFT_237 = SHIFTL0(CAST(64, IL_FALSE, op_AND_232), SN(32, 16));
	RzILOpPure *op_OR_239 = LOGOR(CAST(64, IL_FALSE, op_AND_8), op_LSHIFT_237);
	RzILOpEffect *op_ASSIGN_241 = WRITE_REG(bundle, Rd_op, CAST(32, IL_FALSE, op_OR_239));

	// seq(seq(HYB(gcc_expr_if ((sextract64(((ut64) (((st64) ((st32) (( ...;
	RzILOpEffect *seq_242 = SEQN(2, seq_220, op_ASSIGN_241);

	// set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, ((ut32) 0x1));
	RzILOpEffect *set_usr_field_call_395 = hex_set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, CAST(32, IL_FALSE, SN(32, 1)));

	// HYB(gcc_expr_if ((sextract64(((ut64) (((st64) ((st32) ((st16) ((Rs >> 0x0) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x0) & 0xffff)))) << 0x0) - (((st64) ((st32) ((st16) ((Rs >> 0x10) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x10) & 0xffff)))) << 0x0) + ((st64) 0x8000)), 0x0, 0x20) == (((st64) ((st32) ((st16) ((Rs >> 0x0) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x0) & 0xffff)))) << 0x0) - (((st64) ((st32) ((st16) ((Rs >> 0x10) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x10) & 0xffff)))) << 0x0) + ((st64) 0x8000))) {{}} else {set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, ((ut32) 0x1))}, (((((st64) ((st32) ((st16) ((Rs >> 0x0) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x0) & 0xffff)))) << 0x0) - (((st64) ((st32) ((st16) ((Rs >> 0x10) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x10) & 0xffff)))) << 0x0) + ((st64) 0x8000) < ((st64) 0x0)) ? (-(0x1 << 0x1f)) : (0x1 << 0x1f) - ((st64) 0x1)));
	RzILOpPure *op_RSHIFT_258 = SHIFTRA(DUP(Rs), SN(32, 0));
	RzILOpPure *op_AND_260 = LOGAND(op_RSHIFT_258, SN(32, 0xffff));
	RzILOpPure *op_RSHIFT_266 = SHIFTRA(DUP(Rt), SN(32, 0));
	RzILOpPure *op_AND_268 = LOGAND(op_RSHIFT_266, SN(32, 0xffff));
	RzILOpPure *op_MUL_271 = MUL(CAST(32, MSB(CAST(16, MSB(op_AND_260), DUP(op_AND_260))), CAST(16, MSB(DUP(op_AND_260)), DUP(op_AND_260))), CAST(32, MSB(CAST(16, MSB(op_AND_268), DUP(op_AND_268))), CAST(16, MSB(DUP(op_AND_268)), DUP(op_AND_268))));
	RzILOpPure *op_LSHIFT_274 = SHIFTL0(CAST(64, MSB(op_MUL_271), DUP(op_MUL_271)), SN(32, 0));
	RzILOpPure *op_RSHIFT_278 = SHIFTRA(DUP(Rs), SN(32, 16));
	RzILOpPure *op_AND_280 = LOGAND(op_RSHIFT_278, SN(32, 0xffff));
	RzILOpPure *op_RSHIFT_286 = SHIFTRA(DUP(Rt), SN(32, 16));
	RzILOpPure *op_AND_288 = LOGAND(op_RSHIFT_286, SN(32, 0xffff));
	RzILOpPure *op_MUL_291 = MUL(CAST(32, MSB(CAST(16, MSB(op_AND_280), DUP(op_AND_280))), CAST(16, MSB(DUP(op_AND_280)), DUP(op_AND_280))), CAST(32, MSB(CAST(16, MSB(op_AND_288), DUP(op_AND_288))), CAST(16, MSB(DUP(op_AND_288)), DUP(op_AND_288))));
	RzILOpPure *op_LSHIFT_294 = SHIFTL0(CAST(64, MSB(op_MUL_291), DUP(op_MUL_291)), SN(32, 0));
	RzILOpPure *op_SUB_295 = SUB(op_LSHIFT_274, op_LSHIFT_294);
	RzILOpPure *op_ADD_298 = ADD(op_SUB_295, CAST(64, MSB(SN(32, 0x8000)), SN(32, 0x8000)));
	RzILOpPure *op_RSHIFT_307 = SHIFTRA(DUP(Rs), SN(32, 0));
	RzILOpPure *op_AND_309 = LOGAND(op_RSHIFT_307, SN(32, 0xffff));
	RzILOpPure *op_RSHIFT_315 = SHIFTRA(DUP(Rt), SN(32, 0));
	RzILOpPure *op_AND_317 = LOGAND(op_RSHIFT_315, SN(32, 0xffff));
	RzILOpPure *op_MUL_320 = MUL(CAST(32, MSB(CAST(16, MSB(op_AND_309), DUP(op_AND_309))), CAST(16, MSB(DUP(op_AND_309)), DUP(op_AND_309))), CAST(32, MSB(CAST(16, MSB(op_AND_317), DUP(op_AND_317))), CAST(16, MSB(DUP(op_AND_317)), DUP(op_AND_317))));
	RzILOpPure *op_LSHIFT_323 = SHIFTL0(CAST(64, MSB(op_MUL_320), DUP(op_MUL_320)), SN(32, 0));
	RzILOpPure *op_RSHIFT_327 = SHIFTRA(DUP(Rs), SN(32, 16));
	RzILOpPure *op_AND_329 = LOGAND(op_RSHIFT_327, SN(32, 0xffff));
	RzILOpPure *op_RSHIFT_335 = SHIFTRA(DUP(Rt), SN(32, 16));
	RzILOpPure *op_AND_337 = LOGAND(op_RSHIFT_335, SN(32, 0xffff));
	RzILOpPure *op_MUL_340 = MUL(CAST(32, MSB(CAST(16, MSB(op_AND_329), DUP(op_AND_329))), CAST(16, MSB(DUP(op_AND_329)), DUP(op_AND_329))), CAST(32, MSB(CAST(16, MSB(op_AND_337), DUP(op_AND_337))), CAST(16, MSB(DUP(op_AND_337)), DUP(op_AND_337))));
	RzILOpPure *op_LSHIFT_343 = SHIFTL0(CAST(64, MSB(op_MUL_340), DUP(op_MUL_340)), SN(32, 0));
	RzILOpPure *op_SUB_344 = SUB(op_LSHIFT_323, op_LSHIFT_343);
	RzILOpPure *op_ADD_347 = ADD(op_SUB_344, CAST(64, MSB(SN(32, 0x8000)), SN(32, 0x8000)));
	RzILOpPure *op_EQ_348 = EQ(SEXTRACT64(CAST(64, IL_FALSE, op_ADD_298), SN(32, 0), SN(32, 0x20)), op_ADD_347);
	RzILOpPure *op_RSHIFT_399 = SHIFTRA(DUP(Rs), SN(32, 0));
	RzILOpPure *op_AND_401 = LOGAND(op_RSHIFT_399, SN(32, 0xffff));
	RzILOpPure *op_RSHIFT_407 = SHIFTRA(DUP(Rt), SN(32, 0));
	RzILOpPure *op_AND_409 = LOGAND(op_RSHIFT_407, SN(32, 0xffff));
	RzILOpPure *op_MUL_412 = MUL(CAST(32, MSB(CAST(16, MSB(op_AND_401), DUP(op_AND_401))), CAST(16, MSB(DUP(op_AND_401)), DUP(op_AND_401))), CAST(32, MSB(CAST(16, MSB(op_AND_409), DUP(op_AND_409))), CAST(16, MSB(DUP(op_AND_409)), DUP(op_AND_409))));
	RzILOpPure *op_LSHIFT_415 = SHIFTL0(CAST(64, MSB(op_MUL_412), DUP(op_MUL_412)), SN(32, 0));
	RzILOpPure *op_RSHIFT_419 = SHIFTRA(DUP(Rs), SN(32, 16));
	RzILOpPure *op_AND_421 = LOGAND(op_RSHIFT_419, SN(32, 0xffff));
	RzILOpPure *op_RSHIFT_427 = SHIFTRA(DUP(Rt), SN(32, 16));
	RzILOpPure *op_AND_429 = LOGAND(op_RSHIFT_427, SN(32, 0xffff));
	RzILOpPure *op_MUL_432 = MUL(CAST(32, MSB(CAST(16, MSB(op_AND_421), DUP(op_AND_421))), CAST(16, MSB(DUP(op_AND_421)), DUP(op_AND_421))), CAST(32, MSB(CAST(16, MSB(op_AND_429), DUP(op_AND_429))), CAST(16, MSB(DUP(op_AND_429)), DUP(op_AND_429))));
	RzILOpPure *op_LSHIFT_435 = SHIFTL0(CAST(64, MSB(op_MUL_432), DUP(op_MUL_432)), SN(32, 0));
	RzILOpPure *op_SUB_436 = SUB(op_LSHIFT_415, op_LSHIFT_435);
	RzILOpPure *op_ADD_439 = ADD(op_SUB_436, CAST(64, MSB(SN(32, 0x8000)), SN(32, 0x8000)));
	RzILOpPure *op_LT_442 = SLT(op_ADD_439, CAST(64, MSB(SN(32, 0)), SN(32, 0)));
	RzILOpPure *op_LSHIFT_447 = SHIFTL0(SN(64, 1), SN(32, 31));
	RzILOpPure *op_NEG_448 = NEG(op_LSHIFT_447);
	RzILOpPure *op_LSHIFT_453 = SHIFTL0(SN(64, 1), SN(32, 31));
	RzILOpPure *op_SUB_456 = SUB(op_LSHIFT_453, CAST(64, MSB(SN(32, 1)), SN(32, 1)));
	RzILOpPure *cond_457 = ITE(op_LT_442, op_NEG_448, op_SUB_456);
	RzILOpEffect *gcc_expr_458 = BRANCH(op_EQ_348, EMPTY(), set_usr_field_call_395);

	// h_tmp241 = HYB(gcc_expr_if ((sextract64(((ut64) (((st64) ((st32) ((st16) ((Rs >> 0x0) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x0) & 0xffff)))) << 0x0) - (((st64) ((st32) ((st16) ((Rs >> 0x10) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x10) & 0xffff)))) << 0x0) + ((st64) 0x8000)), 0x0, 0x20) == (((st64) ((st32) ((st16) ((Rs >> 0x0) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x0) & 0xffff)))) << 0x0) - (((st64) ((st32) ((st16) ((Rs >> 0x10) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x10) & 0xffff)))) << 0x0) + ((st64) 0x8000))) {{}} else {set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, ((ut32) 0x1))}, (((((st64) ((st32) ((st16) ((Rs >> 0x0) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x0) & 0xffff)))) << 0x0) - (((st64) ((st32) ((st16) ((Rs >> 0x10) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x10) & 0xffff)))) << 0x0) + ((st64) 0x8000) < ((st64) 0x0)) ? (-(0x1 << 0x1f)) : (0x1 << 0x1f) - ((st64) 0x1)));
	RzILOpEffect *op_ASSIGN_hybrid_tmp_460 = SETL("h_tmp241", cond_457);

	// seq(HYB(gcc_expr_if ((sextract64(((ut64) (((st64) ((st32) ((st16 ...;
	RzILOpEffect *seq_461 = SEQN(2, gcc_expr_458, op_ASSIGN_hybrid_tmp_460);

	// Rd = ((st32) (((ut64) (((st64) Rd) & (~(0xffff << 0x0)))) | (((ut64) (((st32) ((st16) ((((sextract64(((ut64) (((st64) ((st32) ((st16) ((Rs >> 0x0) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x0) & 0xffff)))) << 0x0) - (((st64) ((st32) ((st16) ((Rs >> 0x10) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x10) & 0xffff)))) << 0x0) + ((st64) 0x8000)), 0x0, 0x20) == (((st64) ((st32) ((st16) ((Rs >> 0x0) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x0) & 0xffff)))) << 0x0) - (((st64) ((st32) ((st16) ((Rs >> 0x10) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x10) & 0xffff)))) << 0x0) + ((st64) 0x8000)) ? (((st64) ((st32) ((st16) ((Rs >> 0x0) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x0) & 0xffff)))) << 0x0) - (((st64) ((st32) ((st16) ((Rs >> 0x10) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x10) & 0xffff)))) << 0x0) + ((st64) 0x8000) : h_tmp241) >> 0x10) & ((st64) 0xffff)))) & 0xffff)) << 0x0)));
	RzILOpPure *op_LSHIFT_248 = SHIFTL0(SN(64, 0xffff), SN(32, 0));
	RzILOpPure *op_NOT_249 = LOGNOT(op_LSHIFT_248);
	RzILOpPure *op_AND_251 = LOGAND(CAST(64, MSB(READ_REG(pkt, Rd_op, true)), READ_REG(pkt, Rd_op, true)), op_NOT_249);
	RzILOpPure *op_RSHIFT_352 = SHIFTRA(DUP(Rs), SN(32, 0));
	RzILOpPure *op_AND_354 = LOGAND(op_RSHIFT_352, SN(32, 0xffff));
	RzILOpPure *op_RSHIFT_360 = SHIFTRA(DUP(Rt), SN(32, 0));
	RzILOpPure *op_AND_362 = LOGAND(op_RSHIFT_360, SN(32, 0xffff));
	RzILOpPure *op_MUL_365 = MUL(CAST(32, MSB(CAST(16, MSB(op_AND_354), DUP(op_AND_354))), CAST(16, MSB(DUP(op_AND_354)), DUP(op_AND_354))), CAST(32, MSB(CAST(16, MSB(op_AND_362), DUP(op_AND_362))), CAST(16, MSB(DUP(op_AND_362)), DUP(op_AND_362))));
	RzILOpPure *op_LSHIFT_368 = SHIFTL0(CAST(64, MSB(op_MUL_365), DUP(op_MUL_365)), SN(32, 0));
	RzILOpPure *op_RSHIFT_372 = SHIFTRA(DUP(Rs), SN(32, 16));
	RzILOpPure *op_AND_374 = LOGAND(op_RSHIFT_372, SN(32, 0xffff));
	RzILOpPure *op_RSHIFT_380 = SHIFTRA(DUP(Rt), SN(32, 16));
	RzILOpPure *op_AND_382 = LOGAND(op_RSHIFT_380, SN(32, 0xffff));
	RzILOpPure *op_MUL_385 = MUL(CAST(32, MSB(CAST(16, MSB(op_AND_374), DUP(op_AND_374))), CAST(16, MSB(DUP(op_AND_374)), DUP(op_AND_374))), CAST(32, MSB(CAST(16, MSB(op_AND_382), DUP(op_AND_382))), CAST(16, MSB(DUP(op_AND_382)), DUP(op_AND_382))));
	RzILOpPure *op_LSHIFT_388 = SHIFTL0(CAST(64, MSB(op_MUL_385), DUP(op_MUL_385)), SN(32, 0));
	RzILOpPure *op_SUB_389 = SUB(op_LSHIFT_368, op_LSHIFT_388);
	RzILOpPure *op_ADD_392 = ADD(op_SUB_389, CAST(64, MSB(SN(32, 0x8000)), SN(32, 0x8000)));
	RzILOpPure *cond_462 = ITE(DUP(op_EQ_348), op_ADD_392, VARL("h_tmp241"));
	RzILOpPure *op_RSHIFT_466 = SHIFTRA(cond_462, SN(32, 16));
	RzILOpPure *op_AND_469 = LOGAND(op_RSHIFT_466, CAST(64, MSB(SN(32, 0xffff)), SN(32, 0xffff)));
	RzILOpPure *op_AND_473 = LOGAND(CAST(32, MSB(CAST(16, MSB(op_AND_469), DUP(op_AND_469))), CAST(16, MSB(DUP(op_AND_469)), DUP(op_AND_469))), SN(32, 0xffff));
	RzILOpPure *op_LSHIFT_478 = SHIFTL0(CAST(64, IL_FALSE, op_AND_473), SN(32, 0));
	RzILOpPure *op_OR_480 = LOGOR(CAST(64, IL_FALSE, op_AND_251), op_LSHIFT_478);
	RzILOpEffect *op_ASSIGN_482 = WRITE_REG(bundle, Rd_op, CAST(32, IL_FALSE, op_OR_480));

	// seq(seq(HYB(gcc_expr_if ((sextract64(((ut64) (((st64) ((st32) (( ...;
	RzILOpEffect *seq_483 = SEQN(2, seq_461, op_ASSIGN_482);

	RzILOpEffect *instruction_sequence = SEQN(2, seq_242, seq_483);
	return instruction_sequence;
}

// Rd = cmpy(Rs,Rt):<<1:rnd:sat
RzILOpEffect *hex_il_op_m2_cmpyrs_s1(HexInsnPktBundle *bundle) {
	const HexInsn *hi = bundle->insn;
	HexPkt *pkt = bundle->pkt;
	// READ
	const HexOp *Rd_op = ISA2REG(hi, 'd', false);
	const HexOp *Rs_op = ISA2REG(hi, 's', false);
	RzILOpPure *Rs = READ_REG(pkt, Rs_op, false);
	const HexOp *Rt_op = ISA2REG(hi, 't', false);
	RzILOpPure *Rt = READ_REG(pkt, Rt_op, false);

	// set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, ((ut32) 0x1));
	RzILOpEffect *set_usr_field_call_154 = hex_set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, CAST(32, IL_FALSE, SN(32, 1)));

	// HYB(gcc_expr_if ((sextract64(((ut64) (((st64) ((st32) ((st16) ((Rs >> 0x10) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x0) & 0xffff)))) << 0x1) + (((st64) ((st32) ((st16) ((Rs >> 0x0) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x10) & 0xffff)))) << 0x1) + ((st64) 0x8000)), 0x0, 0x20) == (((st64) ((st32) ((st16) ((Rs >> 0x10) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x0) & 0xffff)))) << 0x1) + (((st64) ((st32) ((st16) ((Rs >> 0x0) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x10) & 0xffff)))) << 0x1) + ((st64) 0x8000))) {{}} else {set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, ((ut32) 0x1))}, (((((st64) ((st32) ((st16) ((Rs >> 0x10) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x0) & 0xffff)))) << 0x1) + (((st64) ((st32) ((st16) ((Rs >> 0x0) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x10) & 0xffff)))) << 0x1) + ((st64) 0x8000) < ((st64) 0x0)) ? (-(0x1 << 0x1f)) : (0x1 << 0x1f) - ((st64) 0x1)));
	RzILOpPure *op_RSHIFT_16 = SHIFTRA(Rs, SN(32, 16));
	RzILOpPure *op_AND_18 = LOGAND(op_RSHIFT_16, SN(32, 0xffff));
	RzILOpPure *op_RSHIFT_25 = SHIFTRA(Rt, SN(32, 0));
	RzILOpPure *op_AND_27 = LOGAND(op_RSHIFT_25, SN(32, 0xffff));
	RzILOpPure *op_MUL_30 = MUL(CAST(32, MSB(CAST(16, MSB(op_AND_18), DUP(op_AND_18))), CAST(16, MSB(DUP(op_AND_18)), DUP(op_AND_18))), CAST(32, MSB(CAST(16, MSB(op_AND_27), DUP(op_AND_27))), CAST(16, MSB(DUP(op_AND_27)), DUP(op_AND_27))));
	RzILOpPure *op_LSHIFT_33 = SHIFTL0(CAST(64, MSB(op_MUL_30), DUP(op_MUL_30)), SN(32, 1));
	RzILOpPure *op_RSHIFT_37 = SHIFTRA(DUP(Rs), SN(32, 0));
	RzILOpPure *op_AND_39 = LOGAND(op_RSHIFT_37, SN(32, 0xffff));
	RzILOpPure *op_RSHIFT_45 = SHIFTRA(DUP(Rt), SN(32, 16));
	RzILOpPure *op_AND_47 = LOGAND(op_RSHIFT_45, SN(32, 0xffff));
	RzILOpPure *op_MUL_50 = MUL(CAST(32, MSB(CAST(16, MSB(op_AND_39), DUP(op_AND_39))), CAST(16, MSB(DUP(op_AND_39)), DUP(op_AND_39))), CAST(32, MSB(CAST(16, MSB(op_AND_47), DUP(op_AND_47))), CAST(16, MSB(DUP(op_AND_47)), DUP(op_AND_47))));
	RzILOpPure *op_LSHIFT_53 = SHIFTL0(CAST(64, MSB(op_MUL_50), DUP(op_MUL_50)), SN(32, 1));
	RzILOpPure *op_ADD_54 = ADD(op_LSHIFT_33, op_LSHIFT_53);
	RzILOpPure *op_ADD_57 = ADD(op_ADD_54, CAST(64, MSB(SN(32, 0x8000)), SN(32, 0x8000)));
	RzILOpPure *op_RSHIFT_66 = SHIFTRA(DUP(Rs), SN(32, 16));
	RzILOpPure *op_AND_68 = LOGAND(op_RSHIFT_66, SN(32, 0xffff));
	RzILOpPure *op_RSHIFT_74 = SHIFTRA(DUP(Rt), SN(32, 0));
	RzILOpPure *op_AND_76 = LOGAND(op_RSHIFT_74, SN(32, 0xffff));
	RzILOpPure *op_MUL_79 = MUL(CAST(32, MSB(CAST(16, MSB(op_AND_68), DUP(op_AND_68))), CAST(16, MSB(DUP(op_AND_68)), DUP(op_AND_68))), CAST(32, MSB(CAST(16, MSB(op_AND_76), DUP(op_AND_76))), CAST(16, MSB(DUP(op_AND_76)), DUP(op_AND_76))));
	RzILOpPure *op_LSHIFT_82 = SHIFTL0(CAST(64, MSB(op_MUL_79), DUP(op_MUL_79)), SN(32, 1));
	RzILOpPure *op_RSHIFT_86 = SHIFTRA(DUP(Rs), SN(32, 0));
	RzILOpPure *op_AND_88 = LOGAND(op_RSHIFT_86, SN(32, 0xffff));
	RzILOpPure *op_RSHIFT_94 = SHIFTRA(DUP(Rt), SN(32, 16));
	RzILOpPure *op_AND_96 = LOGAND(op_RSHIFT_94, SN(32, 0xffff));
	RzILOpPure *op_MUL_99 = MUL(CAST(32, MSB(CAST(16, MSB(op_AND_88), DUP(op_AND_88))), CAST(16, MSB(DUP(op_AND_88)), DUP(op_AND_88))), CAST(32, MSB(CAST(16, MSB(op_AND_96), DUP(op_AND_96))), CAST(16, MSB(DUP(op_AND_96)), DUP(op_AND_96))));
	RzILOpPure *op_LSHIFT_102 = SHIFTL0(CAST(64, MSB(op_MUL_99), DUP(op_MUL_99)), SN(32, 1));
	RzILOpPure *op_ADD_103 = ADD(op_LSHIFT_82, op_LSHIFT_102);
	RzILOpPure *op_ADD_106 = ADD(op_ADD_103, CAST(64, MSB(SN(32, 0x8000)), SN(32, 0x8000)));
	RzILOpPure *op_EQ_107 = EQ(SEXTRACT64(CAST(64, IL_FALSE, op_ADD_57), SN(32, 0), SN(32, 0x20)), op_ADD_106);
	RzILOpPure *op_RSHIFT_158 = SHIFTRA(DUP(Rs), SN(32, 16));
	RzILOpPure *op_AND_160 = LOGAND(op_RSHIFT_158, SN(32, 0xffff));
	RzILOpPure *op_RSHIFT_166 = SHIFTRA(DUP(Rt), SN(32, 0));
	RzILOpPure *op_AND_168 = LOGAND(op_RSHIFT_166, SN(32, 0xffff));
	RzILOpPure *op_MUL_171 = MUL(CAST(32, MSB(CAST(16, MSB(op_AND_160), DUP(op_AND_160))), CAST(16, MSB(DUP(op_AND_160)), DUP(op_AND_160))), CAST(32, MSB(CAST(16, MSB(op_AND_168), DUP(op_AND_168))), CAST(16, MSB(DUP(op_AND_168)), DUP(op_AND_168))));
	RzILOpPure *op_LSHIFT_174 = SHIFTL0(CAST(64, MSB(op_MUL_171), DUP(op_MUL_171)), SN(32, 1));
	RzILOpPure *op_RSHIFT_178 = SHIFTRA(DUP(Rs), SN(32, 0));
	RzILOpPure *op_AND_180 = LOGAND(op_RSHIFT_178, SN(32, 0xffff));
	RzILOpPure *op_RSHIFT_186 = SHIFTRA(DUP(Rt), SN(32, 16));
	RzILOpPure *op_AND_188 = LOGAND(op_RSHIFT_186, SN(32, 0xffff));
	RzILOpPure *op_MUL_191 = MUL(CAST(32, MSB(CAST(16, MSB(op_AND_180), DUP(op_AND_180))), CAST(16, MSB(DUP(op_AND_180)), DUP(op_AND_180))), CAST(32, MSB(CAST(16, MSB(op_AND_188), DUP(op_AND_188))), CAST(16, MSB(DUP(op_AND_188)), DUP(op_AND_188))));
	RzILOpPure *op_LSHIFT_194 = SHIFTL0(CAST(64, MSB(op_MUL_191), DUP(op_MUL_191)), SN(32, 1));
	RzILOpPure *op_ADD_195 = ADD(op_LSHIFT_174, op_LSHIFT_194);
	RzILOpPure *op_ADD_198 = ADD(op_ADD_195, CAST(64, MSB(SN(32, 0x8000)), SN(32, 0x8000)));
	RzILOpPure *op_LT_201 = SLT(op_ADD_198, CAST(64, MSB(SN(32, 0)), SN(32, 0)));
	RzILOpPure *op_LSHIFT_206 = SHIFTL0(SN(64, 1), SN(32, 31));
	RzILOpPure *op_NEG_207 = NEG(op_LSHIFT_206);
	RzILOpPure *op_LSHIFT_212 = SHIFTL0(SN(64, 1), SN(32, 31));
	RzILOpPure *op_SUB_215 = SUB(op_LSHIFT_212, CAST(64, MSB(SN(32, 1)), SN(32, 1)));
	RzILOpPure *cond_216 = ITE(op_LT_201, op_NEG_207, op_SUB_215);
	RzILOpEffect *gcc_expr_217 = BRANCH(op_EQ_107, EMPTY(), set_usr_field_call_154);

	// h_tmp242 = HYB(gcc_expr_if ((sextract64(((ut64) (((st64) ((st32) ((st16) ((Rs >> 0x10) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x0) & 0xffff)))) << 0x1) + (((st64) ((st32) ((st16) ((Rs >> 0x0) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x10) & 0xffff)))) << 0x1) + ((st64) 0x8000)), 0x0, 0x20) == (((st64) ((st32) ((st16) ((Rs >> 0x10) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x0) & 0xffff)))) << 0x1) + (((st64) ((st32) ((st16) ((Rs >> 0x0) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x10) & 0xffff)))) << 0x1) + ((st64) 0x8000))) {{}} else {set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, ((ut32) 0x1))}, (((((st64) ((st32) ((st16) ((Rs >> 0x10) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x0) & 0xffff)))) << 0x1) + (((st64) ((st32) ((st16) ((Rs >> 0x0) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x10) & 0xffff)))) << 0x1) + ((st64) 0x8000) < ((st64) 0x0)) ? (-(0x1 << 0x1f)) : (0x1 << 0x1f) - ((st64) 0x1)));
	RzILOpEffect *op_ASSIGN_hybrid_tmp_219 = SETL("h_tmp242", cond_216);

	// seq(HYB(gcc_expr_if ((sextract64(((ut64) (((st64) ((st32) ((st16 ...;
	RzILOpEffect *seq_220 = SEQN(2, gcc_expr_217, op_ASSIGN_hybrid_tmp_219);

	// Rd = ((st32) (((ut64) (((st64) Rd) & (~(0xffff << 0x10)))) | (((ut64) (((st32) ((st16) ((((sextract64(((ut64) (((st64) ((st32) ((st16) ((Rs >> 0x10) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x0) & 0xffff)))) << 0x1) + (((st64) ((st32) ((st16) ((Rs >> 0x0) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x10) & 0xffff)))) << 0x1) + ((st64) 0x8000)), 0x0, 0x20) == (((st64) ((st32) ((st16) ((Rs >> 0x10) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x0) & 0xffff)))) << 0x1) + (((st64) ((st32) ((st16) ((Rs >> 0x0) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x10) & 0xffff)))) << 0x1) + ((st64) 0x8000)) ? (((st64) ((st32) ((st16) ((Rs >> 0x10) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x0) & 0xffff)))) << 0x1) + (((st64) ((st32) ((st16) ((Rs >> 0x0) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x10) & 0xffff)))) << 0x1) + ((st64) 0x8000) : h_tmp242) >> 0x10) & ((st64) 0xffff)))) & 0xffff)) << 0x10)));
	RzILOpPure *op_LSHIFT_5 = SHIFTL0(SN(64, 0xffff), SN(32, 16));
	RzILOpPure *op_NOT_6 = LOGNOT(op_LSHIFT_5);
	RzILOpPure *op_AND_8 = LOGAND(CAST(64, MSB(READ_REG(pkt, Rd_op, true)), READ_REG(pkt, Rd_op, true)), op_NOT_6);
	RzILOpPure *op_RSHIFT_111 = SHIFTRA(DUP(Rs), SN(32, 16));
	RzILOpPure *op_AND_113 = LOGAND(op_RSHIFT_111, SN(32, 0xffff));
	RzILOpPure *op_RSHIFT_119 = SHIFTRA(DUP(Rt), SN(32, 0));
	RzILOpPure *op_AND_121 = LOGAND(op_RSHIFT_119, SN(32, 0xffff));
	RzILOpPure *op_MUL_124 = MUL(CAST(32, MSB(CAST(16, MSB(op_AND_113), DUP(op_AND_113))), CAST(16, MSB(DUP(op_AND_113)), DUP(op_AND_113))), CAST(32, MSB(CAST(16, MSB(op_AND_121), DUP(op_AND_121))), CAST(16, MSB(DUP(op_AND_121)), DUP(op_AND_121))));
	RzILOpPure *op_LSHIFT_127 = SHIFTL0(CAST(64, MSB(op_MUL_124), DUP(op_MUL_124)), SN(32, 1));
	RzILOpPure *op_RSHIFT_131 = SHIFTRA(DUP(Rs), SN(32, 0));
	RzILOpPure *op_AND_133 = LOGAND(op_RSHIFT_131, SN(32, 0xffff));
	RzILOpPure *op_RSHIFT_139 = SHIFTRA(DUP(Rt), SN(32, 16));
	RzILOpPure *op_AND_141 = LOGAND(op_RSHIFT_139, SN(32, 0xffff));
	RzILOpPure *op_MUL_144 = MUL(CAST(32, MSB(CAST(16, MSB(op_AND_133), DUP(op_AND_133))), CAST(16, MSB(DUP(op_AND_133)), DUP(op_AND_133))), CAST(32, MSB(CAST(16, MSB(op_AND_141), DUP(op_AND_141))), CAST(16, MSB(DUP(op_AND_141)), DUP(op_AND_141))));
	RzILOpPure *op_LSHIFT_147 = SHIFTL0(CAST(64, MSB(op_MUL_144), DUP(op_MUL_144)), SN(32, 1));
	RzILOpPure *op_ADD_148 = ADD(op_LSHIFT_127, op_LSHIFT_147);
	RzILOpPure *op_ADD_151 = ADD(op_ADD_148, CAST(64, MSB(SN(32, 0x8000)), SN(32, 0x8000)));
	RzILOpPure *cond_221 = ITE(DUP(op_EQ_107), op_ADD_151, VARL("h_tmp242"));
	RzILOpPure *op_RSHIFT_225 = SHIFTRA(cond_221, SN(32, 16));
	RzILOpPure *op_AND_228 = LOGAND(op_RSHIFT_225, CAST(64, MSB(SN(32, 0xffff)), SN(32, 0xffff)));
	RzILOpPure *op_AND_232 = LOGAND(CAST(32, MSB(CAST(16, MSB(op_AND_228), DUP(op_AND_228))), CAST(16, MSB(DUP(op_AND_228)), DUP(op_AND_228))), SN(32, 0xffff));
	RzILOpPure *op_LSHIFT_237 = SHIFTL0(CAST(64, IL_FALSE, op_AND_232), SN(32, 16));
	RzILOpPure *op_OR_239 = LOGOR(CAST(64, IL_FALSE, op_AND_8), op_LSHIFT_237);
	RzILOpEffect *op_ASSIGN_241 = WRITE_REG(bundle, Rd_op, CAST(32, IL_FALSE, op_OR_239));

	// seq(seq(HYB(gcc_expr_if ((sextract64(((ut64) (((st64) ((st32) (( ...;
	RzILOpEffect *seq_242 = SEQN(2, seq_220, op_ASSIGN_241);

	// set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, ((ut32) 0x1));
	RzILOpEffect *set_usr_field_call_395 = hex_set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, CAST(32, IL_FALSE, SN(32, 1)));

	// HYB(gcc_expr_if ((sextract64(((ut64) (((st64) ((st32) ((st16) ((Rs >> 0x0) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x0) & 0xffff)))) << 0x1) - (((st64) ((st32) ((st16) ((Rs >> 0x10) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x10) & 0xffff)))) << 0x1) + ((st64) 0x8000)), 0x0, 0x20) == (((st64) ((st32) ((st16) ((Rs >> 0x0) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x0) & 0xffff)))) << 0x1) - (((st64) ((st32) ((st16) ((Rs >> 0x10) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x10) & 0xffff)))) << 0x1) + ((st64) 0x8000))) {{}} else {set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, ((ut32) 0x1))}, (((((st64) ((st32) ((st16) ((Rs >> 0x0) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x0) & 0xffff)))) << 0x1) - (((st64) ((st32) ((st16) ((Rs >> 0x10) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x10) & 0xffff)))) << 0x1) + ((st64) 0x8000) < ((st64) 0x0)) ? (-(0x1 << 0x1f)) : (0x1 << 0x1f) - ((st64) 0x1)));
	RzILOpPure *op_RSHIFT_258 = SHIFTRA(DUP(Rs), SN(32, 0));
	RzILOpPure *op_AND_260 = LOGAND(op_RSHIFT_258, SN(32, 0xffff));
	RzILOpPure *op_RSHIFT_266 = SHIFTRA(DUP(Rt), SN(32, 0));
	RzILOpPure *op_AND_268 = LOGAND(op_RSHIFT_266, SN(32, 0xffff));
	RzILOpPure *op_MUL_271 = MUL(CAST(32, MSB(CAST(16, MSB(op_AND_260), DUP(op_AND_260))), CAST(16, MSB(DUP(op_AND_260)), DUP(op_AND_260))), CAST(32, MSB(CAST(16, MSB(op_AND_268), DUP(op_AND_268))), CAST(16, MSB(DUP(op_AND_268)), DUP(op_AND_268))));
	RzILOpPure *op_LSHIFT_274 = SHIFTL0(CAST(64, MSB(op_MUL_271), DUP(op_MUL_271)), SN(32, 1));
	RzILOpPure *op_RSHIFT_278 = SHIFTRA(DUP(Rs), SN(32, 16));
	RzILOpPure *op_AND_280 = LOGAND(op_RSHIFT_278, SN(32, 0xffff));
	RzILOpPure *op_RSHIFT_286 = SHIFTRA(DUP(Rt), SN(32, 16));
	RzILOpPure *op_AND_288 = LOGAND(op_RSHIFT_286, SN(32, 0xffff));
	RzILOpPure *op_MUL_291 = MUL(CAST(32, MSB(CAST(16, MSB(op_AND_280), DUP(op_AND_280))), CAST(16, MSB(DUP(op_AND_280)), DUP(op_AND_280))), CAST(32, MSB(CAST(16, MSB(op_AND_288), DUP(op_AND_288))), CAST(16, MSB(DUP(op_AND_288)), DUP(op_AND_288))));
	RzILOpPure *op_LSHIFT_294 = SHIFTL0(CAST(64, MSB(op_MUL_291), DUP(op_MUL_291)), SN(32, 1));
	RzILOpPure *op_SUB_295 = SUB(op_LSHIFT_274, op_LSHIFT_294);
	RzILOpPure *op_ADD_298 = ADD(op_SUB_295, CAST(64, MSB(SN(32, 0x8000)), SN(32, 0x8000)));
	RzILOpPure *op_RSHIFT_307 = SHIFTRA(DUP(Rs), SN(32, 0));
	RzILOpPure *op_AND_309 = LOGAND(op_RSHIFT_307, SN(32, 0xffff));
	RzILOpPure *op_RSHIFT_315 = SHIFTRA(DUP(Rt), SN(32, 0));
	RzILOpPure *op_AND_317 = LOGAND(op_RSHIFT_315, SN(32, 0xffff));
	RzILOpPure *op_MUL_320 = MUL(CAST(32, MSB(CAST(16, MSB(op_AND_309), DUP(op_AND_309))), CAST(16, MSB(DUP(op_AND_309)), DUP(op_AND_309))), CAST(32, MSB(CAST(16, MSB(op_AND_317), DUP(op_AND_317))), CAST(16, MSB(DUP(op_AND_317)), DUP(op_AND_317))));
	RzILOpPure *op_LSHIFT_323 = SHIFTL0(CAST(64, MSB(op_MUL_320), DUP(op_MUL_320)), SN(32, 1));
	RzILOpPure *op_RSHIFT_327 = SHIFTRA(DUP(Rs), SN(32, 16));
	RzILOpPure *op_AND_329 = LOGAND(op_RSHIFT_327, SN(32, 0xffff));
	RzILOpPure *op_RSHIFT_335 = SHIFTRA(DUP(Rt), SN(32, 16));
	RzILOpPure *op_AND_337 = LOGAND(op_RSHIFT_335, SN(32, 0xffff));
	RzILOpPure *op_MUL_340 = MUL(CAST(32, MSB(CAST(16, MSB(op_AND_329), DUP(op_AND_329))), CAST(16, MSB(DUP(op_AND_329)), DUP(op_AND_329))), CAST(32, MSB(CAST(16, MSB(op_AND_337), DUP(op_AND_337))), CAST(16, MSB(DUP(op_AND_337)), DUP(op_AND_337))));
	RzILOpPure *op_LSHIFT_343 = SHIFTL0(CAST(64, MSB(op_MUL_340), DUP(op_MUL_340)), SN(32, 1));
	RzILOpPure *op_SUB_344 = SUB(op_LSHIFT_323, op_LSHIFT_343);
	RzILOpPure *op_ADD_347 = ADD(op_SUB_344, CAST(64, MSB(SN(32, 0x8000)), SN(32, 0x8000)));
	RzILOpPure *op_EQ_348 = EQ(SEXTRACT64(CAST(64, IL_FALSE, op_ADD_298), SN(32, 0), SN(32, 0x20)), op_ADD_347);
	RzILOpPure *op_RSHIFT_399 = SHIFTRA(DUP(Rs), SN(32, 0));
	RzILOpPure *op_AND_401 = LOGAND(op_RSHIFT_399, SN(32, 0xffff));
	RzILOpPure *op_RSHIFT_407 = SHIFTRA(DUP(Rt), SN(32, 0));
	RzILOpPure *op_AND_409 = LOGAND(op_RSHIFT_407, SN(32, 0xffff));
	RzILOpPure *op_MUL_412 = MUL(CAST(32, MSB(CAST(16, MSB(op_AND_401), DUP(op_AND_401))), CAST(16, MSB(DUP(op_AND_401)), DUP(op_AND_401))), CAST(32, MSB(CAST(16, MSB(op_AND_409), DUP(op_AND_409))), CAST(16, MSB(DUP(op_AND_409)), DUP(op_AND_409))));
	RzILOpPure *op_LSHIFT_415 = SHIFTL0(CAST(64, MSB(op_MUL_412), DUP(op_MUL_412)), SN(32, 1));
	RzILOpPure *op_RSHIFT_419 = SHIFTRA(DUP(Rs), SN(32, 16));
	RzILOpPure *op_AND_421 = LOGAND(op_RSHIFT_419, SN(32, 0xffff));
	RzILOpPure *op_RSHIFT_427 = SHIFTRA(DUP(Rt), SN(32, 16));
	RzILOpPure *op_AND_429 = LOGAND(op_RSHIFT_427, SN(32, 0xffff));
	RzILOpPure *op_MUL_432 = MUL(CAST(32, MSB(CAST(16, MSB(op_AND_421), DUP(op_AND_421))), CAST(16, MSB(DUP(op_AND_421)), DUP(op_AND_421))), CAST(32, MSB(CAST(16, MSB(op_AND_429), DUP(op_AND_429))), CAST(16, MSB(DUP(op_AND_429)), DUP(op_AND_429))));
	RzILOpPure *op_LSHIFT_435 = SHIFTL0(CAST(64, MSB(op_MUL_432), DUP(op_MUL_432)), SN(32, 1));
	RzILOpPure *op_SUB_436 = SUB(op_LSHIFT_415, op_LSHIFT_435);
	RzILOpPure *op_ADD_439 = ADD(op_SUB_436, CAST(64, MSB(SN(32, 0x8000)), SN(32, 0x8000)));
	RzILOpPure *op_LT_442 = SLT(op_ADD_439, CAST(64, MSB(SN(32, 0)), SN(32, 0)));
	RzILOpPure *op_LSHIFT_447 = SHIFTL0(SN(64, 1), SN(32, 31));
	RzILOpPure *op_NEG_448 = NEG(op_LSHIFT_447);
	RzILOpPure *op_LSHIFT_453 = SHIFTL0(SN(64, 1), SN(32, 31));
	RzILOpPure *op_SUB_456 = SUB(op_LSHIFT_453, CAST(64, MSB(SN(32, 1)), SN(32, 1)));
	RzILOpPure *cond_457 = ITE(op_LT_442, op_NEG_448, op_SUB_456);
	RzILOpEffect *gcc_expr_458 = BRANCH(op_EQ_348, EMPTY(), set_usr_field_call_395);

	// h_tmp243 = HYB(gcc_expr_if ((sextract64(((ut64) (((st64) ((st32) ((st16) ((Rs >> 0x0) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x0) & 0xffff)))) << 0x1) - (((st64) ((st32) ((st16) ((Rs >> 0x10) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x10) & 0xffff)))) << 0x1) + ((st64) 0x8000)), 0x0, 0x20) == (((st64) ((st32) ((st16) ((Rs >> 0x0) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x0) & 0xffff)))) << 0x1) - (((st64) ((st32) ((st16) ((Rs >> 0x10) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x10) & 0xffff)))) << 0x1) + ((st64) 0x8000))) {{}} else {set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, ((ut32) 0x1))}, (((((st64) ((st32) ((st16) ((Rs >> 0x0) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x0) & 0xffff)))) << 0x1) - (((st64) ((st32) ((st16) ((Rs >> 0x10) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x10) & 0xffff)))) << 0x1) + ((st64) 0x8000) < ((st64) 0x0)) ? (-(0x1 << 0x1f)) : (0x1 << 0x1f) - ((st64) 0x1)));
	RzILOpEffect *op_ASSIGN_hybrid_tmp_460 = SETL("h_tmp243", cond_457);

	// seq(HYB(gcc_expr_if ((sextract64(((ut64) (((st64) ((st32) ((st16 ...;
	RzILOpEffect *seq_461 = SEQN(2, gcc_expr_458, op_ASSIGN_hybrid_tmp_460);

	// Rd = ((st32) (((ut64) (((st64) Rd) & (~(0xffff << 0x0)))) | (((ut64) (((st32) ((st16) ((((sextract64(((ut64) (((st64) ((st32) ((st16) ((Rs >> 0x0) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x0) & 0xffff)))) << 0x1) - (((st64) ((st32) ((st16) ((Rs >> 0x10) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x10) & 0xffff)))) << 0x1) + ((st64) 0x8000)), 0x0, 0x20) == (((st64) ((st32) ((st16) ((Rs >> 0x0) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x0) & 0xffff)))) << 0x1) - (((st64) ((st32) ((st16) ((Rs >> 0x10) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x10) & 0xffff)))) << 0x1) + ((st64) 0x8000)) ? (((st64) ((st32) ((st16) ((Rs >> 0x0) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x0) & 0xffff)))) << 0x1) - (((st64) ((st32) ((st16) ((Rs >> 0x10) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x10) & 0xffff)))) << 0x1) + ((st64) 0x8000) : h_tmp243) >> 0x10) & ((st64) 0xffff)))) & 0xffff)) << 0x0)));
	RzILOpPure *op_LSHIFT_248 = SHIFTL0(SN(64, 0xffff), SN(32, 0));
	RzILOpPure *op_NOT_249 = LOGNOT(op_LSHIFT_248);
	RzILOpPure *op_AND_251 = LOGAND(CAST(64, MSB(READ_REG(pkt, Rd_op, true)), READ_REG(pkt, Rd_op, true)), op_NOT_249);
	RzILOpPure *op_RSHIFT_352 = SHIFTRA(DUP(Rs), SN(32, 0));
	RzILOpPure *op_AND_354 = LOGAND(op_RSHIFT_352, SN(32, 0xffff));
	RzILOpPure *op_RSHIFT_360 = SHIFTRA(DUP(Rt), SN(32, 0));
	RzILOpPure *op_AND_362 = LOGAND(op_RSHIFT_360, SN(32, 0xffff));
	RzILOpPure *op_MUL_365 = MUL(CAST(32, MSB(CAST(16, MSB(op_AND_354), DUP(op_AND_354))), CAST(16, MSB(DUP(op_AND_354)), DUP(op_AND_354))), CAST(32, MSB(CAST(16, MSB(op_AND_362), DUP(op_AND_362))), CAST(16, MSB(DUP(op_AND_362)), DUP(op_AND_362))));
	RzILOpPure *op_LSHIFT_368 = SHIFTL0(CAST(64, MSB(op_MUL_365), DUP(op_MUL_365)), SN(32, 1));
	RzILOpPure *op_RSHIFT_372 = SHIFTRA(DUP(Rs), SN(32, 16));
	RzILOpPure *op_AND_374 = LOGAND(op_RSHIFT_372, SN(32, 0xffff));
	RzILOpPure *op_RSHIFT_380 = SHIFTRA(DUP(Rt), SN(32, 16));
	RzILOpPure *op_AND_382 = LOGAND(op_RSHIFT_380, SN(32, 0xffff));
	RzILOpPure *op_MUL_385 = MUL(CAST(32, MSB(CAST(16, MSB(op_AND_374), DUP(op_AND_374))), CAST(16, MSB(DUP(op_AND_374)), DUP(op_AND_374))), CAST(32, MSB(CAST(16, MSB(op_AND_382), DUP(op_AND_382))), CAST(16, MSB(DUP(op_AND_382)), DUP(op_AND_382))));
	RzILOpPure *op_LSHIFT_388 = SHIFTL0(CAST(64, MSB(op_MUL_385), DUP(op_MUL_385)), SN(32, 1));
	RzILOpPure *op_SUB_389 = SUB(op_LSHIFT_368, op_LSHIFT_388);
	RzILOpPure *op_ADD_392 = ADD(op_SUB_389, CAST(64, MSB(SN(32, 0x8000)), SN(32, 0x8000)));
	RzILOpPure *cond_462 = ITE(DUP(op_EQ_348), op_ADD_392, VARL("h_tmp243"));
	RzILOpPure *op_RSHIFT_466 = SHIFTRA(cond_462, SN(32, 16));
	RzILOpPure *op_AND_469 = LOGAND(op_RSHIFT_466, CAST(64, MSB(SN(32, 0xffff)), SN(32, 0xffff)));
	RzILOpPure *op_AND_473 = LOGAND(CAST(32, MSB(CAST(16, MSB(op_AND_469), DUP(op_AND_469))), CAST(16, MSB(DUP(op_AND_469)), DUP(op_AND_469))), SN(32, 0xffff));
	RzILOpPure *op_LSHIFT_478 = SHIFTL0(CAST(64, IL_FALSE, op_AND_473), SN(32, 0));
	RzILOpPure *op_OR_480 = LOGOR(CAST(64, IL_FALSE, op_AND_251), op_LSHIFT_478);
	RzILOpEffect *op_ASSIGN_482 = WRITE_REG(bundle, Rd_op, CAST(32, IL_FALSE, op_OR_480));

	// seq(seq(HYB(gcc_expr_if ((sextract64(((ut64) (((st64) ((st32) (( ...;
	RzILOpEffect *seq_483 = SEQN(2, seq_461, op_ASSIGN_482);

	RzILOpEffect *instruction_sequence = SEQN(2, seq_242, seq_483);
	return instruction_sequence;
}

// Rd = cmpy(Rs,Rt*):rnd:sat
RzILOpEffect *hex_il_op_m2_cmpyrsc_s0(HexInsnPktBundle *bundle) {
	const HexInsn *hi = bundle->insn;
	HexPkt *pkt = bundle->pkt;
	// READ
	const HexOp *Rd_op = ISA2REG(hi, 'd', false);
	const HexOp *Rs_op = ISA2REG(hi, 's', false);
	RzILOpPure *Rs = READ_REG(pkt, Rs_op, false);
	const HexOp *Rt_op = ISA2REG(hi, 't', false);
	RzILOpPure *Rt = READ_REG(pkt, Rt_op, false);

	// set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, ((ut32) 0x1));
	RzILOpEffect *set_usr_field_call_154 = hex_set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, CAST(32, IL_FALSE, SN(32, 1)));

	// HYB(gcc_expr_if ((sextract64(((ut64) (((st64) ((st32) ((st16) ((Rs >> 0x10) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x0) & 0xffff)))) << 0x0) - (((st64) ((st32) ((st16) ((Rs >> 0x0) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x10) & 0xffff)))) << 0x0) + ((st64) 0x8000)), 0x0, 0x20) == (((st64) ((st32) ((st16) ((Rs >> 0x10) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x0) & 0xffff)))) << 0x0) - (((st64) ((st32) ((st16) ((Rs >> 0x0) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x10) & 0xffff)))) << 0x0) + ((st64) 0x8000))) {{}} else {set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, ((ut32) 0x1))}, (((((st64) ((st32) ((st16) ((Rs >> 0x10) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x0) & 0xffff)))) << 0x0) - (((st64) ((st32) ((st16) ((Rs >> 0x0) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x10) & 0xffff)))) << 0x0) + ((st64) 0x8000) < ((st64) 0x0)) ? (-(0x1 << 0x1f)) : (0x1 << 0x1f) - ((st64) 0x1)));
	RzILOpPure *op_RSHIFT_16 = SHIFTRA(Rs, SN(32, 16));
	RzILOpPure *op_AND_18 = LOGAND(op_RSHIFT_16, SN(32, 0xffff));
	RzILOpPure *op_RSHIFT_25 = SHIFTRA(Rt, SN(32, 0));
	RzILOpPure *op_AND_27 = LOGAND(op_RSHIFT_25, SN(32, 0xffff));
	RzILOpPure *op_MUL_30 = MUL(CAST(32, MSB(CAST(16, MSB(op_AND_18), DUP(op_AND_18))), CAST(16, MSB(DUP(op_AND_18)), DUP(op_AND_18))), CAST(32, MSB(CAST(16, MSB(op_AND_27), DUP(op_AND_27))), CAST(16, MSB(DUP(op_AND_27)), DUP(op_AND_27))));
	RzILOpPure *op_LSHIFT_33 = SHIFTL0(CAST(64, MSB(op_MUL_30), DUP(op_MUL_30)), SN(32, 0));
	RzILOpPure *op_RSHIFT_37 = SHIFTRA(DUP(Rs), SN(32, 0));
	RzILOpPure *op_AND_39 = LOGAND(op_RSHIFT_37, SN(32, 0xffff));
	RzILOpPure *op_RSHIFT_45 = SHIFTRA(DUP(Rt), SN(32, 16));
	RzILOpPure *op_AND_47 = LOGAND(op_RSHIFT_45, SN(32, 0xffff));
	RzILOpPure *op_MUL_50 = MUL(CAST(32, MSB(CAST(16, MSB(op_AND_39), DUP(op_AND_39))), CAST(16, MSB(DUP(op_AND_39)), DUP(op_AND_39))), CAST(32, MSB(CAST(16, MSB(op_AND_47), DUP(op_AND_47))), CAST(16, MSB(DUP(op_AND_47)), DUP(op_AND_47))));
	RzILOpPure *op_LSHIFT_53 = SHIFTL0(CAST(64, MSB(op_MUL_50), DUP(op_MUL_50)), SN(32, 0));
	RzILOpPure *op_SUB_54 = SUB(op_LSHIFT_33, op_LSHIFT_53);
	RzILOpPure *op_ADD_57 = ADD(op_SUB_54, CAST(64, MSB(SN(32, 0x8000)), SN(32, 0x8000)));
	RzILOpPure *op_RSHIFT_66 = SHIFTRA(DUP(Rs), SN(32, 16));
	RzILOpPure *op_AND_68 = LOGAND(op_RSHIFT_66, SN(32, 0xffff));
	RzILOpPure *op_RSHIFT_74 = SHIFTRA(DUP(Rt), SN(32, 0));
	RzILOpPure *op_AND_76 = LOGAND(op_RSHIFT_74, SN(32, 0xffff));
	RzILOpPure *op_MUL_79 = MUL(CAST(32, MSB(CAST(16, MSB(op_AND_68), DUP(op_AND_68))), CAST(16, MSB(DUP(op_AND_68)), DUP(op_AND_68))), CAST(32, MSB(CAST(16, MSB(op_AND_76), DUP(op_AND_76))), CAST(16, MSB(DUP(op_AND_76)), DUP(op_AND_76))));
	RzILOpPure *op_LSHIFT_82 = SHIFTL0(CAST(64, MSB(op_MUL_79), DUP(op_MUL_79)), SN(32, 0));
	RzILOpPure *op_RSHIFT_86 = SHIFTRA(DUP(Rs), SN(32, 0));
	RzILOpPure *op_AND_88 = LOGAND(op_RSHIFT_86, SN(32, 0xffff));
	RzILOpPure *op_RSHIFT_94 = SHIFTRA(DUP(Rt), SN(32, 16));
	RzILOpPure *op_AND_96 = LOGAND(op_RSHIFT_94, SN(32, 0xffff));
	RzILOpPure *op_MUL_99 = MUL(CAST(32, MSB(CAST(16, MSB(op_AND_88), DUP(op_AND_88))), CAST(16, MSB(DUP(op_AND_88)), DUP(op_AND_88))), CAST(32, MSB(CAST(16, MSB(op_AND_96), DUP(op_AND_96))), CAST(16, MSB(DUP(op_AND_96)), DUP(op_AND_96))));
	RzILOpPure *op_LSHIFT_102 = SHIFTL0(CAST(64, MSB(op_MUL_99), DUP(op_MUL_99)), SN(32, 0));
	RzILOpPure *op_SUB_103 = SUB(op_LSHIFT_82, op_LSHIFT_102);
	RzILOpPure *op_ADD_106 = ADD(op_SUB_103, CAST(64, MSB(SN(32, 0x8000)), SN(32, 0x8000)));
	RzILOpPure *op_EQ_107 = EQ(SEXTRACT64(CAST(64, IL_FALSE, op_ADD_57), SN(32, 0), SN(32, 0x20)), op_ADD_106);
	RzILOpPure *op_RSHIFT_158 = SHIFTRA(DUP(Rs), SN(32, 16));
	RzILOpPure *op_AND_160 = LOGAND(op_RSHIFT_158, SN(32, 0xffff));
	RzILOpPure *op_RSHIFT_166 = SHIFTRA(DUP(Rt), SN(32, 0));
	RzILOpPure *op_AND_168 = LOGAND(op_RSHIFT_166, SN(32, 0xffff));
	RzILOpPure *op_MUL_171 = MUL(CAST(32, MSB(CAST(16, MSB(op_AND_160), DUP(op_AND_160))), CAST(16, MSB(DUP(op_AND_160)), DUP(op_AND_160))), CAST(32, MSB(CAST(16, MSB(op_AND_168), DUP(op_AND_168))), CAST(16, MSB(DUP(op_AND_168)), DUP(op_AND_168))));
	RzILOpPure *op_LSHIFT_174 = SHIFTL0(CAST(64, MSB(op_MUL_171), DUP(op_MUL_171)), SN(32, 0));
	RzILOpPure *op_RSHIFT_178 = SHIFTRA(DUP(Rs), SN(32, 0));
	RzILOpPure *op_AND_180 = LOGAND(op_RSHIFT_178, SN(32, 0xffff));
	RzILOpPure *op_RSHIFT_186 = SHIFTRA(DUP(Rt), SN(32, 16));
	RzILOpPure *op_AND_188 = LOGAND(op_RSHIFT_186, SN(32, 0xffff));
	RzILOpPure *op_MUL_191 = MUL(CAST(32, MSB(CAST(16, MSB(op_AND_180), DUP(op_AND_180))), CAST(16, MSB(DUP(op_AND_180)), DUP(op_AND_180))), CAST(32, MSB(CAST(16, MSB(op_AND_188), DUP(op_AND_188))), CAST(16, MSB(DUP(op_AND_188)), DUP(op_AND_188))));
	RzILOpPure *op_LSHIFT_194 = SHIFTL0(CAST(64, MSB(op_MUL_191), DUP(op_MUL_191)), SN(32, 0));
	RzILOpPure *op_SUB_195 = SUB(op_LSHIFT_174, op_LSHIFT_194);
	RzILOpPure *op_ADD_198 = ADD(op_SUB_195, CAST(64, MSB(SN(32, 0x8000)), SN(32, 0x8000)));
	RzILOpPure *op_LT_201 = SLT(op_ADD_198, CAST(64, MSB(SN(32, 0)), SN(32, 0)));
	RzILOpPure *op_LSHIFT_206 = SHIFTL0(SN(64, 1), SN(32, 31));
	RzILOpPure *op_NEG_207 = NEG(op_LSHIFT_206);
	RzILOpPure *op_LSHIFT_212 = SHIFTL0(SN(64, 1), SN(32, 31));
	RzILOpPure *op_SUB_215 = SUB(op_LSHIFT_212, CAST(64, MSB(SN(32, 1)), SN(32, 1)));
	RzILOpPure *cond_216 = ITE(op_LT_201, op_NEG_207, op_SUB_215);
	RzILOpEffect *gcc_expr_217 = BRANCH(op_EQ_107, EMPTY(), set_usr_field_call_154);

	// h_tmp244 = HYB(gcc_expr_if ((sextract64(((ut64) (((st64) ((st32) ((st16) ((Rs >> 0x10) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x0) & 0xffff)))) << 0x0) - (((st64) ((st32) ((st16) ((Rs >> 0x0) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x10) & 0xffff)))) << 0x0) + ((st64) 0x8000)), 0x0, 0x20) == (((st64) ((st32) ((st16) ((Rs >> 0x10) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x0) & 0xffff)))) << 0x0) - (((st64) ((st32) ((st16) ((Rs >> 0x0) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x10) & 0xffff)))) << 0x0) + ((st64) 0x8000))) {{}} else {set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, ((ut32) 0x1))}, (((((st64) ((st32) ((st16) ((Rs >> 0x10) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x0) & 0xffff)))) << 0x0) - (((st64) ((st32) ((st16) ((Rs >> 0x0) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x10) & 0xffff)))) << 0x0) + ((st64) 0x8000) < ((st64) 0x0)) ? (-(0x1 << 0x1f)) : (0x1 << 0x1f) - ((st64) 0x1)));
	RzILOpEffect *op_ASSIGN_hybrid_tmp_219 = SETL("h_tmp244", cond_216);

	// seq(HYB(gcc_expr_if ((sextract64(((ut64) (((st64) ((st32) ((st16 ...;
	RzILOpEffect *seq_220 = SEQN(2, gcc_expr_217, op_ASSIGN_hybrid_tmp_219);

	// Rd = ((st32) (((ut64) (((st64) Rd) & (~(0xffff << 0x10)))) | (((ut64) (((st32) ((st16) ((((sextract64(((ut64) (((st64) ((st32) ((st16) ((Rs >> 0x10) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x0) & 0xffff)))) << 0x0) - (((st64) ((st32) ((st16) ((Rs >> 0x0) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x10) & 0xffff)))) << 0x0) + ((st64) 0x8000)), 0x0, 0x20) == (((st64) ((st32) ((st16) ((Rs >> 0x10) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x0) & 0xffff)))) << 0x0) - (((st64) ((st32) ((st16) ((Rs >> 0x0) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x10) & 0xffff)))) << 0x0) + ((st64) 0x8000)) ? (((st64) ((st32) ((st16) ((Rs >> 0x10) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x0) & 0xffff)))) << 0x0) - (((st64) ((st32) ((st16) ((Rs >> 0x0) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x10) & 0xffff)))) << 0x0) + ((st64) 0x8000) : h_tmp244) >> 0x10) & ((st64) 0xffff)))) & 0xffff)) << 0x10)));
	RzILOpPure *op_LSHIFT_5 = SHIFTL0(SN(64, 0xffff), SN(32, 16));
	RzILOpPure *op_NOT_6 = LOGNOT(op_LSHIFT_5);
	RzILOpPure *op_AND_8 = LOGAND(CAST(64, MSB(READ_REG(pkt, Rd_op, true)), READ_REG(pkt, Rd_op, true)), op_NOT_6);
	RzILOpPure *op_RSHIFT_111 = SHIFTRA(DUP(Rs), SN(32, 16));
	RzILOpPure *op_AND_113 = LOGAND(op_RSHIFT_111, SN(32, 0xffff));
	RzILOpPure *op_RSHIFT_119 = SHIFTRA(DUP(Rt), SN(32, 0));
	RzILOpPure *op_AND_121 = LOGAND(op_RSHIFT_119, SN(32, 0xffff));
	RzILOpPure *op_MUL_124 = MUL(CAST(32, MSB(CAST(16, MSB(op_AND_113), DUP(op_AND_113))), CAST(16, MSB(DUP(op_AND_113)), DUP(op_AND_113))), CAST(32, MSB(CAST(16, MSB(op_AND_121), DUP(op_AND_121))), CAST(16, MSB(DUP(op_AND_121)), DUP(op_AND_121))));
	RzILOpPure *op_LSHIFT_127 = SHIFTL0(CAST(64, MSB(op_MUL_124), DUP(op_MUL_124)), SN(32, 0));
	RzILOpPure *op_RSHIFT_131 = SHIFTRA(DUP(Rs), SN(32, 0));
	RzILOpPure *op_AND_133 = LOGAND(op_RSHIFT_131, SN(32, 0xffff));
	RzILOpPure *op_RSHIFT_139 = SHIFTRA(DUP(Rt), SN(32, 16));
	RzILOpPure *op_AND_141 = LOGAND(op_RSHIFT_139, SN(32, 0xffff));
	RzILOpPure *op_MUL_144 = MUL(CAST(32, MSB(CAST(16, MSB(op_AND_133), DUP(op_AND_133))), CAST(16, MSB(DUP(op_AND_133)), DUP(op_AND_133))), CAST(32, MSB(CAST(16, MSB(op_AND_141), DUP(op_AND_141))), CAST(16, MSB(DUP(op_AND_141)), DUP(op_AND_141))));
	RzILOpPure *op_LSHIFT_147 = SHIFTL0(CAST(64, MSB(op_MUL_144), DUP(op_MUL_144)), SN(32, 0));
	RzILOpPure *op_SUB_148 = SUB(op_LSHIFT_127, op_LSHIFT_147);
	RzILOpPure *op_ADD_151 = ADD(op_SUB_148, CAST(64, MSB(SN(32, 0x8000)), SN(32, 0x8000)));
	RzILOpPure *cond_221 = ITE(DUP(op_EQ_107), op_ADD_151, VARL("h_tmp244"));
	RzILOpPure *op_RSHIFT_225 = SHIFTRA(cond_221, SN(32, 16));
	RzILOpPure *op_AND_228 = LOGAND(op_RSHIFT_225, CAST(64, MSB(SN(32, 0xffff)), SN(32, 0xffff)));
	RzILOpPure *op_AND_232 = LOGAND(CAST(32, MSB(CAST(16, MSB(op_AND_228), DUP(op_AND_228))), CAST(16, MSB(DUP(op_AND_228)), DUP(op_AND_228))), SN(32, 0xffff));
	RzILOpPure *op_LSHIFT_237 = SHIFTL0(CAST(64, IL_FALSE, op_AND_232), SN(32, 16));
	RzILOpPure *op_OR_239 = LOGOR(CAST(64, IL_FALSE, op_AND_8), op_LSHIFT_237);
	RzILOpEffect *op_ASSIGN_241 = WRITE_REG(bundle, Rd_op, CAST(32, IL_FALSE, op_OR_239));

	// seq(seq(HYB(gcc_expr_if ((sextract64(((ut64) (((st64) ((st32) (( ...;
	RzILOpEffect *seq_242 = SEQN(2, seq_220, op_ASSIGN_241);

	// set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, ((ut32) 0x1));
	RzILOpEffect *set_usr_field_call_395 = hex_set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, CAST(32, IL_FALSE, SN(32, 1)));

	// HYB(gcc_expr_if ((sextract64(((ut64) (((st64) ((st32) ((st16) ((Rs >> 0x0) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x0) & 0xffff)))) << 0x0) + (((st64) ((st32) ((st16) ((Rs >> 0x10) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x10) & 0xffff)))) << 0x0) + ((st64) 0x8000)), 0x0, 0x20) == (((st64) ((st32) ((st16) ((Rs >> 0x0) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x0) & 0xffff)))) << 0x0) + (((st64) ((st32) ((st16) ((Rs >> 0x10) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x10) & 0xffff)))) << 0x0) + ((st64) 0x8000))) {{}} else {set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, ((ut32) 0x1))}, (((((st64) ((st32) ((st16) ((Rs >> 0x0) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x0) & 0xffff)))) << 0x0) + (((st64) ((st32) ((st16) ((Rs >> 0x10) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x10) & 0xffff)))) << 0x0) + ((st64) 0x8000) < ((st64) 0x0)) ? (-(0x1 << 0x1f)) : (0x1 << 0x1f) - ((st64) 0x1)));
	RzILOpPure *op_RSHIFT_258 = SHIFTRA(DUP(Rs), SN(32, 0));
	RzILOpPure *op_AND_260 = LOGAND(op_RSHIFT_258, SN(32, 0xffff));
	RzILOpPure *op_RSHIFT_266 = SHIFTRA(DUP(Rt), SN(32, 0));
	RzILOpPure *op_AND_268 = LOGAND(op_RSHIFT_266, SN(32, 0xffff));
	RzILOpPure *op_MUL_271 = MUL(CAST(32, MSB(CAST(16, MSB(op_AND_260), DUP(op_AND_260))), CAST(16, MSB(DUP(op_AND_260)), DUP(op_AND_260))), CAST(32, MSB(CAST(16, MSB(op_AND_268), DUP(op_AND_268))), CAST(16, MSB(DUP(op_AND_268)), DUP(op_AND_268))));
	RzILOpPure *op_LSHIFT_274 = SHIFTL0(CAST(64, MSB(op_MUL_271), DUP(op_MUL_271)), SN(32, 0));
	RzILOpPure *op_RSHIFT_278 = SHIFTRA(DUP(Rs), SN(32, 16));
	RzILOpPure *op_AND_280 = LOGAND(op_RSHIFT_278, SN(32, 0xffff));
	RzILOpPure *op_RSHIFT_286 = SHIFTRA(DUP(Rt), SN(32, 16));
	RzILOpPure *op_AND_288 = LOGAND(op_RSHIFT_286, SN(32, 0xffff));
	RzILOpPure *op_MUL_291 = MUL(CAST(32, MSB(CAST(16, MSB(op_AND_280), DUP(op_AND_280))), CAST(16, MSB(DUP(op_AND_280)), DUP(op_AND_280))), CAST(32, MSB(CAST(16, MSB(op_AND_288), DUP(op_AND_288))), CAST(16, MSB(DUP(op_AND_288)), DUP(op_AND_288))));
	RzILOpPure *op_LSHIFT_294 = SHIFTL0(CAST(64, MSB(op_MUL_291), DUP(op_MUL_291)), SN(32, 0));
	RzILOpPure *op_ADD_295 = ADD(op_LSHIFT_274, op_LSHIFT_294);
	RzILOpPure *op_ADD_298 = ADD(op_ADD_295, CAST(64, MSB(SN(32, 0x8000)), SN(32, 0x8000)));
	RzILOpPure *op_RSHIFT_307 = SHIFTRA(DUP(Rs), SN(32, 0));
	RzILOpPure *op_AND_309 = LOGAND(op_RSHIFT_307, SN(32, 0xffff));
	RzILOpPure *op_RSHIFT_315 = SHIFTRA(DUP(Rt), SN(32, 0));
	RzILOpPure *op_AND_317 = LOGAND(op_RSHIFT_315, SN(32, 0xffff));
	RzILOpPure *op_MUL_320 = MUL(CAST(32, MSB(CAST(16, MSB(op_AND_309), DUP(op_AND_309))), CAST(16, MSB(DUP(op_AND_309)), DUP(op_AND_309))), CAST(32, MSB(CAST(16, MSB(op_AND_317), DUP(op_AND_317))), CAST(16, MSB(DUP(op_AND_317)), DUP(op_AND_317))));
	RzILOpPure *op_LSHIFT_323 = SHIFTL0(CAST(64, MSB(op_MUL_320), DUP(op_MUL_320)), SN(32, 0));
	RzILOpPure *op_RSHIFT_327 = SHIFTRA(DUP(Rs), SN(32, 16));
	RzILOpPure *op_AND_329 = LOGAND(op_RSHIFT_327, SN(32, 0xffff));
	RzILOpPure *op_RSHIFT_335 = SHIFTRA(DUP(Rt), SN(32, 16));
	RzILOpPure *op_AND_337 = LOGAND(op_RSHIFT_335, SN(32, 0xffff));
	RzILOpPure *op_MUL_340 = MUL(CAST(32, MSB(CAST(16, MSB(op_AND_329), DUP(op_AND_329))), CAST(16, MSB(DUP(op_AND_329)), DUP(op_AND_329))), CAST(32, MSB(CAST(16, MSB(op_AND_337), DUP(op_AND_337))), CAST(16, MSB(DUP(op_AND_337)), DUP(op_AND_337))));
	RzILOpPure *op_LSHIFT_343 = SHIFTL0(CAST(64, MSB(op_MUL_340), DUP(op_MUL_340)), SN(32, 0));
	RzILOpPure *op_ADD_344 = ADD(op_LSHIFT_323, op_LSHIFT_343);
	RzILOpPure *op_ADD_347 = ADD(op_ADD_344, CAST(64, MSB(SN(32, 0x8000)), SN(32, 0x8000)));
	RzILOpPure *op_EQ_348 = EQ(SEXTRACT64(CAST(64, IL_FALSE, op_ADD_298), SN(32, 0), SN(32, 0x20)), op_ADD_347);
	RzILOpPure *op_RSHIFT_399 = SHIFTRA(DUP(Rs), SN(32, 0));
	RzILOpPure *op_AND_401 = LOGAND(op_RSHIFT_399, SN(32, 0xffff));
	RzILOpPure *op_RSHIFT_407 = SHIFTRA(DUP(Rt), SN(32, 0));
	RzILOpPure *op_AND_409 = LOGAND(op_RSHIFT_407, SN(32, 0xffff));
	RzILOpPure *op_MUL_412 = MUL(CAST(32, MSB(CAST(16, MSB(op_AND_401), DUP(op_AND_401))), CAST(16, MSB(DUP(op_AND_401)), DUP(op_AND_401))), CAST(32, MSB(CAST(16, MSB(op_AND_409), DUP(op_AND_409))), CAST(16, MSB(DUP(op_AND_409)), DUP(op_AND_409))));
	RzILOpPure *op_LSHIFT_415 = SHIFTL0(CAST(64, MSB(op_MUL_412), DUP(op_MUL_412)), SN(32, 0));
	RzILOpPure *op_RSHIFT_419 = SHIFTRA(DUP(Rs), SN(32, 16));
	RzILOpPure *op_AND_421 = LOGAND(op_RSHIFT_419, SN(32, 0xffff));
	RzILOpPure *op_RSHIFT_427 = SHIFTRA(DUP(Rt), SN(32, 16));
	RzILOpPure *op_AND_429 = LOGAND(op_RSHIFT_427, SN(32, 0xffff));
	RzILOpPure *op_MUL_432 = MUL(CAST(32, MSB(CAST(16, MSB(op_AND_421), DUP(op_AND_421))), CAST(16, MSB(DUP(op_AND_421)), DUP(op_AND_421))), CAST(32, MSB(CAST(16, MSB(op_AND_429), DUP(op_AND_429))), CAST(16, MSB(DUP(op_AND_429)), DUP(op_AND_429))));
	RzILOpPure *op_LSHIFT_435 = SHIFTL0(CAST(64, MSB(op_MUL_432), DUP(op_MUL_432)), SN(32, 0));
	RzILOpPure *op_ADD_436 = ADD(op_LSHIFT_415, op_LSHIFT_435);
	RzILOpPure *op_ADD_439 = ADD(op_ADD_436, CAST(64, MSB(SN(32, 0x8000)), SN(32, 0x8000)));
	RzILOpPure *op_LT_442 = SLT(op_ADD_439, CAST(64, MSB(SN(32, 0)), SN(32, 0)));
	RzILOpPure *op_LSHIFT_447 = SHIFTL0(SN(64, 1), SN(32, 31));
	RzILOpPure *op_NEG_448 = NEG(op_LSHIFT_447);
	RzILOpPure *op_LSHIFT_453 = SHIFTL0(SN(64, 1), SN(32, 31));
	RzILOpPure *op_SUB_456 = SUB(op_LSHIFT_453, CAST(64, MSB(SN(32, 1)), SN(32, 1)));
	RzILOpPure *cond_457 = ITE(op_LT_442, op_NEG_448, op_SUB_456);
	RzILOpEffect *gcc_expr_458 = BRANCH(op_EQ_348, EMPTY(), set_usr_field_call_395);

	// h_tmp245 = HYB(gcc_expr_if ((sextract64(((ut64) (((st64) ((st32) ((st16) ((Rs >> 0x0) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x0) & 0xffff)))) << 0x0) + (((st64) ((st32) ((st16) ((Rs >> 0x10) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x10) & 0xffff)))) << 0x0) + ((st64) 0x8000)), 0x0, 0x20) == (((st64) ((st32) ((st16) ((Rs >> 0x0) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x0) & 0xffff)))) << 0x0) + (((st64) ((st32) ((st16) ((Rs >> 0x10) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x10) & 0xffff)))) << 0x0) + ((st64) 0x8000))) {{}} else {set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, ((ut32) 0x1))}, (((((st64) ((st32) ((st16) ((Rs >> 0x0) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x0) & 0xffff)))) << 0x0) + (((st64) ((st32) ((st16) ((Rs >> 0x10) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x10) & 0xffff)))) << 0x0) + ((st64) 0x8000) < ((st64) 0x0)) ? (-(0x1 << 0x1f)) : (0x1 << 0x1f) - ((st64) 0x1)));
	RzILOpEffect *op_ASSIGN_hybrid_tmp_460 = SETL("h_tmp245", cond_457);

	// seq(HYB(gcc_expr_if ((sextract64(((ut64) (((st64) ((st32) ((st16 ...;
	RzILOpEffect *seq_461 = SEQN(2, gcc_expr_458, op_ASSIGN_hybrid_tmp_460);

	// Rd = ((st32) (((ut64) (((st64) Rd) & (~(0xffff << 0x0)))) | (((ut64) (((st32) ((st16) ((((sextract64(((ut64) (((st64) ((st32) ((st16) ((Rs >> 0x0) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x0) & 0xffff)))) << 0x0) + (((st64) ((st32) ((st16) ((Rs >> 0x10) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x10) & 0xffff)))) << 0x0) + ((st64) 0x8000)), 0x0, 0x20) == (((st64) ((st32) ((st16) ((Rs >> 0x0) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x0) & 0xffff)))) << 0x0) + (((st64) ((st32) ((st16) ((Rs >> 0x10) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x10) & 0xffff)))) << 0x0) + ((st64) 0x8000)) ? (((st64) ((st32) ((st16) ((Rs >> 0x0) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x0) & 0xffff)))) << 0x0) + (((st64) ((st32) ((st16) ((Rs >> 0x10) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x10) & 0xffff)))) << 0x0) + ((st64) 0x8000) : h_tmp245) >> 0x10) & ((st64) 0xffff)))) & 0xffff)) << 0x0)));
	RzILOpPure *op_LSHIFT_248 = SHIFTL0(SN(64, 0xffff), SN(32, 0));
	RzILOpPure *op_NOT_249 = LOGNOT(op_LSHIFT_248);
	RzILOpPure *op_AND_251 = LOGAND(CAST(64, MSB(READ_REG(pkt, Rd_op, true)), READ_REG(pkt, Rd_op, true)), op_NOT_249);
	RzILOpPure *op_RSHIFT_352 = SHIFTRA(DUP(Rs), SN(32, 0));
	RzILOpPure *op_AND_354 = LOGAND(op_RSHIFT_352, SN(32, 0xffff));
	RzILOpPure *op_RSHIFT_360 = SHIFTRA(DUP(Rt), SN(32, 0));
	RzILOpPure *op_AND_362 = LOGAND(op_RSHIFT_360, SN(32, 0xffff));
	RzILOpPure *op_MUL_365 = MUL(CAST(32, MSB(CAST(16, MSB(op_AND_354), DUP(op_AND_354))), CAST(16, MSB(DUP(op_AND_354)), DUP(op_AND_354))), CAST(32, MSB(CAST(16, MSB(op_AND_362), DUP(op_AND_362))), CAST(16, MSB(DUP(op_AND_362)), DUP(op_AND_362))));
	RzILOpPure *op_LSHIFT_368 = SHIFTL0(CAST(64, MSB(op_MUL_365), DUP(op_MUL_365)), SN(32, 0));
	RzILOpPure *op_RSHIFT_372 = SHIFTRA(DUP(Rs), SN(32, 16));
	RzILOpPure *op_AND_374 = LOGAND(op_RSHIFT_372, SN(32, 0xffff));
	RzILOpPure *op_RSHIFT_380 = SHIFTRA(DUP(Rt), SN(32, 16));
	RzILOpPure *op_AND_382 = LOGAND(op_RSHIFT_380, SN(32, 0xffff));
	RzILOpPure *op_MUL_385 = MUL(CAST(32, MSB(CAST(16, MSB(op_AND_374), DUP(op_AND_374))), CAST(16, MSB(DUP(op_AND_374)), DUP(op_AND_374))), CAST(32, MSB(CAST(16, MSB(op_AND_382), DUP(op_AND_382))), CAST(16, MSB(DUP(op_AND_382)), DUP(op_AND_382))));
	RzILOpPure *op_LSHIFT_388 = SHIFTL0(CAST(64, MSB(op_MUL_385), DUP(op_MUL_385)), SN(32, 0));
	RzILOpPure *op_ADD_389 = ADD(op_LSHIFT_368, op_LSHIFT_388);
	RzILOpPure *op_ADD_392 = ADD(op_ADD_389, CAST(64, MSB(SN(32, 0x8000)), SN(32, 0x8000)));
	RzILOpPure *cond_462 = ITE(DUP(op_EQ_348), op_ADD_392, VARL("h_tmp245"));
	RzILOpPure *op_RSHIFT_466 = SHIFTRA(cond_462, SN(32, 16));
	RzILOpPure *op_AND_469 = LOGAND(op_RSHIFT_466, CAST(64, MSB(SN(32, 0xffff)), SN(32, 0xffff)));
	RzILOpPure *op_AND_473 = LOGAND(CAST(32, MSB(CAST(16, MSB(op_AND_469), DUP(op_AND_469))), CAST(16, MSB(DUP(op_AND_469)), DUP(op_AND_469))), SN(32, 0xffff));
	RzILOpPure *op_LSHIFT_478 = SHIFTL0(CAST(64, IL_FALSE, op_AND_473), SN(32, 0));
	RzILOpPure *op_OR_480 = LOGOR(CAST(64, IL_FALSE, op_AND_251), op_LSHIFT_478);
	RzILOpEffect *op_ASSIGN_482 = WRITE_REG(bundle, Rd_op, CAST(32, IL_FALSE, op_OR_480));

	// seq(seq(HYB(gcc_expr_if ((sextract64(((ut64) (((st64) ((st32) (( ...;
	RzILOpEffect *seq_483 = SEQN(2, seq_461, op_ASSIGN_482);

	RzILOpEffect *instruction_sequence = SEQN(2, seq_242, seq_483);
	return instruction_sequence;
}

// Rd = cmpy(Rs,Rt*):<<1:rnd:sat
RzILOpEffect *hex_il_op_m2_cmpyrsc_s1(HexInsnPktBundle *bundle) {
	const HexInsn *hi = bundle->insn;
	HexPkt *pkt = bundle->pkt;
	// READ
	const HexOp *Rd_op = ISA2REG(hi, 'd', false);
	const HexOp *Rs_op = ISA2REG(hi, 's', false);
	RzILOpPure *Rs = READ_REG(pkt, Rs_op, false);
	const HexOp *Rt_op = ISA2REG(hi, 't', false);
	RzILOpPure *Rt = READ_REG(pkt, Rt_op, false);

	// set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, ((ut32) 0x1));
	RzILOpEffect *set_usr_field_call_154 = hex_set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, CAST(32, IL_FALSE, SN(32, 1)));

	// HYB(gcc_expr_if ((sextract64(((ut64) (((st64) ((st32) ((st16) ((Rs >> 0x10) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x0) & 0xffff)))) << 0x1) - (((st64) ((st32) ((st16) ((Rs >> 0x0) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x10) & 0xffff)))) << 0x1) + ((st64) 0x8000)), 0x0, 0x20) == (((st64) ((st32) ((st16) ((Rs >> 0x10) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x0) & 0xffff)))) << 0x1) - (((st64) ((st32) ((st16) ((Rs >> 0x0) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x10) & 0xffff)))) << 0x1) + ((st64) 0x8000))) {{}} else {set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, ((ut32) 0x1))}, (((((st64) ((st32) ((st16) ((Rs >> 0x10) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x0) & 0xffff)))) << 0x1) - (((st64) ((st32) ((st16) ((Rs >> 0x0) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x10) & 0xffff)))) << 0x1) + ((st64) 0x8000) < ((st64) 0x0)) ? (-(0x1 << 0x1f)) : (0x1 << 0x1f) - ((st64) 0x1)));
	RzILOpPure *op_RSHIFT_16 = SHIFTRA(Rs, SN(32, 16));
	RzILOpPure *op_AND_18 = LOGAND(op_RSHIFT_16, SN(32, 0xffff));
	RzILOpPure *op_RSHIFT_25 = SHIFTRA(Rt, SN(32, 0));
	RzILOpPure *op_AND_27 = LOGAND(op_RSHIFT_25, SN(32, 0xffff));
	RzILOpPure *op_MUL_30 = MUL(CAST(32, MSB(CAST(16, MSB(op_AND_18), DUP(op_AND_18))), CAST(16, MSB(DUP(op_AND_18)), DUP(op_AND_18))), CAST(32, MSB(CAST(16, MSB(op_AND_27), DUP(op_AND_27))), CAST(16, MSB(DUP(op_AND_27)), DUP(op_AND_27))));
	RzILOpPure *op_LSHIFT_33 = SHIFTL0(CAST(64, MSB(op_MUL_30), DUP(op_MUL_30)), SN(32, 1));
	RzILOpPure *op_RSHIFT_37 = SHIFTRA(DUP(Rs), SN(32, 0));
	RzILOpPure *op_AND_39 = LOGAND(op_RSHIFT_37, SN(32, 0xffff));
	RzILOpPure *op_RSHIFT_45 = SHIFTRA(DUP(Rt), SN(32, 16));
	RzILOpPure *op_AND_47 = LOGAND(op_RSHIFT_45, SN(32, 0xffff));
	RzILOpPure *op_MUL_50 = MUL(CAST(32, MSB(CAST(16, MSB(op_AND_39), DUP(op_AND_39))), CAST(16, MSB(DUP(op_AND_39)), DUP(op_AND_39))), CAST(32, MSB(CAST(16, MSB(op_AND_47), DUP(op_AND_47))), CAST(16, MSB(DUP(op_AND_47)), DUP(op_AND_47))));
	RzILOpPure *op_LSHIFT_53 = SHIFTL0(CAST(64, MSB(op_MUL_50), DUP(op_MUL_50)), SN(32, 1));
	RzILOpPure *op_SUB_54 = SUB(op_LSHIFT_33, op_LSHIFT_53);
	RzILOpPure *op_ADD_57 = ADD(op_SUB_54, CAST(64, MSB(SN(32, 0x8000)), SN(32, 0x8000)));
	RzILOpPure *op_RSHIFT_66 = SHIFTRA(DUP(Rs), SN(32, 16));
	RzILOpPure *op_AND_68 = LOGAND(op_RSHIFT_66, SN(32, 0xffff));
	RzILOpPure *op_RSHIFT_74 = SHIFTRA(DUP(Rt), SN(32, 0));
	RzILOpPure *op_AND_76 = LOGAND(op_RSHIFT_74, SN(32, 0xffff));
	RzILOpPure *op_MUL_79 = MUL(CAST(32, MSB(CAST(16, MSB(op_AND_68), DUP(op_AND_68))), CAST(16, MSB(DUP(op_AND_68)), DUP(op_AND_68))), CAST(32, MSB(CAST(16, MSB(op_AND_76), DUP(op_AND_76))), CAST(16, MSB(DUP(op_AND_76)), DUP(op_AND_76))));
	RzILOpPure *op_LSHIFT_82 = SHIFTL0(CAST(64, MSB(op_MUL_79), DUP(op_MUL_79)), SN(32, 1));
	RzILOpPure *op_RSHIFT_86 = SHIFTRA(DUP(Rs), SN(32, 0));
	RzILOpPure *op_AND_88 = LOGAND(op_RSHIFT_86, SN(32, 0xffff));
	RzILOpPure *op_RSHIFT_94 = SHIFTRA(DUP(Rt), SN(32, 16));
	RzILOpPure *op_AND_96 = LOGAND(op_RSHIFT_94, SN(32, 0xffff));
	RzILOpPure *op_MUL_99 = MUL(CAST(32, MSB(CAST(16, MSB(op_AND_88), DUP(op_AND_88))), CAST(16, MSB(DUP(op_AND_88)), DUP(op_AND_88))), CAST(32, MSB(CAST(16, MSB(op_AND_96), DUP(op_AND_96))), CAST(16, MSB(DUP(op_AND_96)), DUP(op_AND_96))));
	RzILOpPure *op_LSHIFT_102 = SHIFTL0(CAST(64, MSB(op_MUL_99), DUP(op_MUL_99)), SN(32, 1));
	RzILOpPure *op_SUB_103 = SUB(op_LSHIFT_82, op_LSHIFT_102);
	RzILOpPure *op_ADD_106 = ADD(op_SUB_103, CAST(64, MSB(SN(32, 0x8000)), SN(32, 0x8000)));
	RzILOpPure *op_EQ_107 = EQ(SEXTRACT64(CAST(64, IL_FALSE, op_ADD_57), SN(32, 0), SN(32, 0x20)), op_ADD_106);
	RzILOpPure *op_RSHIFT_158 = SHIFTRA(DUP(Rs), SN(32, 16));
	RzILOpPure *op_AND_160 = LOGAND(op_RSHIFT_158, SN(32, 0xffff));
	RzILOpPure *op_RSHIFT_166 = SHIFTRA(DUP(Rt), SN(32, 0));
	RzILOpPure *op_AND_168 = LOGAND(op_RSHIFT_166, SN(32, 0xffff));
	RzILOpPure *op_MUL_171 = MUL(CAST(32, MSB(CAST(16, MSB(op_AND_160), DUP(op_AND_160))), CAST(16, MSB(DUP(op_AND_160)), DUP(op_AND_160))), CAST(32, MSB(CAST(16, MSB(op_AND_168), DUP(op_AND_168))), CAST(16, MSB(DUP(op_AND_168)), DUP(op_AND_168))));
	RzILOpPure *op_LSHIFT_174 = SHIFTL0(CAST(64, MSB(op_MUL_171), DUP(op_MUL_171)), SN(32, 1));
	RzILOpPure *op_RSHIFT_178 = SHIFTRA(DUP(Rs), SN(32, 0));
	RzILOpPure *op_AND_180 = LOGAND(op_RSHIFT_178, SN(32, 0xffff));
	RzILOpPure *op_RSHIFT_186 = SHIFTRA(DUP(Rt), SN(32, 16));
	RzILOpPure *op_AND_188 = LOGAND(op_RSHIFT_186, SN(32, 0xffff));
	RzILOpPure *op_MUL_191 = MUL(CAST(32, MSB(CAST(16, MSB(op_AND_180), DUP(op_AND_180))), CAST(16, MSB(DUP(op_AND_180)), DUP(op_AND_180))), CAST(32, MSB(CAST(16, MSB(op_AND_188), DUP(op_AND_188))), CAST(16, MSB(DUP(op_AND_188)), DUP(op_AND_188))));
	RzILOpPure *op_LSHIFT_194 = SHIFTL0(CAST(64, MSB(op_MUL_191), DUP(op_MUL_191)), SN(32, 1));
	RzILOpPure *op_SUB_195 = SUB(op_LSHIFT_174, op_LSHIFT_194);
	RzILOpPure *op_ADD_198 = ADD(op_SUB_195, CAST(64, MSB(SN(32, 0x8000)), SN(32, 0x8000)));
	RzILOpPure *op_LT_201 = SLT(op_ADD_198, CAST(64, MSB(SN(32, 0)), SN(32, 0)));
	RzILOpPure *op_LSHIFT_206 = SHIFTL0(SN(64, 1), SN(32, 31));
	RzILOpPure *op_NEG_207 = NEG(op_LSHIFT_206);
	RzILOpPure *op_LSHIFT_212 = SHIFTL0(SN(64, 1), SN(32, 31));
	RzILOpPure *op_SUB_215 = SUB(op_LSHIFT_212, CAST(64, MSB(SN(32, 1)), SN(32, 1)));
	RzILOpPure *cond_216 = ITE(op_LT_201, op_NEG_207, op_SUB_215);
	RzILOpEffect *gcc_expr_217 = BRANCH(op_EQ_107, EMPTY(), set_usr_field_call_154);

	// h_tmp246 = HYB(gcc_expr_if ((sextract64(((ut64) (((st64) ((st32) ((st16) ((Rs >> 0x10) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x0) & 0xffff)))) << 0x1) - (((st64) ((st32) ((st16) ((Rs >> 0x0) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x10) & 0xffff)))) << 0x1) + ((st64) 0x8000)), 0x0, 0x20) == (((st64) ((st32) ((st16) ((Rs >> 0x10) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x0) & 0xffff)))) << 0x1) - (((st64) ((st32) ((st16) ((Rs >> 0x0) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x10) & 0xffff)))) << 0x1) + ((st64) 0x8000))) {{}} else {set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, ((ut32) 0x1))}, (((((st64) ((st32) ((st16) ((Rs >> 0x10) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x0) & 0xffff)))) << 0x1) - (((st64) ((st32) ((st16) ((Rs >> 0x0) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x10) & 0xffff)))) << 0x1) + ((st64) 0x8000) < ((st64) 0x0)) ? (-(0x1 << 0x1f)) : (0x1 << 0x1f) - ((st64) 0x1)));
	RzILOpEffect *op_ASSIGN_hybrid_tmp_219 = SETL("h_tmp246", cond_216);

	// seq(HYB(gcc_expr_if ((sextract64(((ut64) (((st64) ((st32) ((st16 ...;
	RzILOpEffect *seq_220 = SEQN(2, gcc_expr_217, op_ASSIGN_hybrid_tmp_219);

	// Rd = ((st32) (((ut64) (((st64) Rd) & (~(0xffff << 0x10)))) | (((ut64) (((st32) ((st16) ((((sextract64(((ut64) (((st64) ((st32) ((st16) ((Rs >> 0x10) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x0) & 0xffff)))) << 0x1) - (((st64) ((st32) ((st16) ((Rs >> 0x0) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x10) & 0xffff)))) << 0x1) + ((st64) 0x8000)), 0x0, 0x20) == (((st64) ((st32) ((st16) ((Rs >> 0x10) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x0) & 0xffff)))) << 0x1) - (((st64) ((st32) ((st16) ((Rs >> 0x0) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x10) & 0xffff)))) << 0x1) + ((st64) 0x8000)) ? (((st64) ((st32) ((st16) ((Rs >> 0x10) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x0) & 0xffff)))) << 0x1) - (((st64) ((st32) ((st16) ((Rs >> 0x0) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x10) & 0xffff)))) << 0x1) + ((st64) 0x8000) : h_tmp246) >> 0x10) & ((st64) 0xffff)))) & 0xffff)) << 0x10)));
	RzILOpPure *op_LSHIFT_5 = SHIFTL0(SN(64, 0xffff), SN(32, 16));
	RzILOpPure *op_NOT_6 = LOGNOT(op_LSHIFT_5);
	RzILOpPure *op_AND_8 = LOGAND(CAST(64, MSB(READ_REG(pkt, Rd_op, true)), READ_REG(pkt, Rd_op, true)), op_NOT_6);
	RzILOpPure *op_RSHIFT_111 = SHIFTRA(DUP(Rs), SN(32, 16));
	RzILOpPure *op_AND_113 = LOGAND(op_RSHIFT_111, SN(32, 0xffff));
	RzILOpPure *op_RSHIFT_119 = SHIFTRA(DUP(Rt), SN(32, 0));
	RzILOpPure *op_AND_121 = LOGAND(op_RSHIFT_119, SN(32, 0xffff));
	RzILOpPure *op_MUL_124 = MUL(CAST(32, MSB(CAST(16, MSB(op_AND_113), DUP(op_AND_113))), CAST(16, MSB(DUP(op_AND_113)), DUP(op_AND_113))), CAST(32, MSB(CAST(16, MSB(op_AND_121), DUP(op_AND_121))), CAST(16, MSB(DUP(op_AND_121)), DUP(op_AND_121))));
	RzILOpPure *op_LSHIFT_127 = SHIFTL0(CAST(64, MSB(op_MUL_124), DUP(op_MUL_124)), SN(32, 1));
	RzILOpPure *op_RSHIFT_131 = SHIFTRA(DUP(Rs), SN(32, 0));
	RzILOpPure *op_AND_133 = LOGAND(op_RSHIFT_131, SN(32, 0xffff));
	RzILOpPure *op_RSHIFT_139 = SHIFTRA(DUP(Rt), SN(32, 16));
	RzILOpPure *op_AND_141 = LOGAND(op_RSHIFT_139, SN(32, 0xffff));
	RzILOpPure *op_MUL_144 = MUL(CAST(32, MSB(CAST(16, MSB(op_AND_133), DUP(op_AND_133))), CAST(16, MSB(DUP(op_AND_133)), DUP(op_AND_133))), CAST(32, MSB(CAST(16, MSB(op_AND_141), DUP(op_AND_141))), CAST(16, MSB(DUP(op_AND_141)), DUP(op_AND_141))));
	RzILOpPure *op_LSHIFT_147 = SHIFTL0(CAST(64, MSB(op_MUL_144), DUP(op_MUL_144)), SN(32, 1));
	RzILOpPure *op_SUB_148 = SUB(op_LSHIFT_127, op_LSHIFT_147);
	RzILOpPure *op_ADD_151 = ADD(op_SUB_148, CAST(64, MSB(SN(32, 0x8000)), SN(32, 0x8000)));
	RzILOpPure *cond_221 = ITE(DUP(op_EQ_107), op_ADD_151, VARL("h_tmp246"));
	RzILOpPure *op_RSHIFT_225 = SHIFTRA(cond_221, SN(32, 16));
	RzILOpPure *op_AND_228 = LOGAND(op_RSHIFT_225, CAST(64, MSB(SN(32, 0xffff)), SN(32, 0xffff)));
	RzILOpPure *op_AND_232 = LOGAND(CAST(32, MSB(CAST(16, MSB(op_AND_228), DUP(op_AND_228))), CAST(16, MSB(DUP(op_AND_228)), DUP(op_AND_228))), SN(32, 0xffff));
	RzILOpPure *op_LSHIFT_237 = SHIFTL0(CAST(64, IL_FALSE, op_AND_232), SN(32, 16));
	RzILOpPure *op_OR_239 = LOGOR(CAST(64, IL_FALSE, op_AND_8), op_LSHIFT_237);
	RzILOpEffect *op_ASSIGN_241 = WRITE_REG(bundle, Rd_op, CAST(32, IL_FALSE, op_OR_239));

	// seq(seq(HYB(gcc_expr_if ((sextract64(((ut64) (((st64) ((st32) (( ...;
	RzILOpEffect *seq_242 = SEQN(2, seq_220, op_ASSIGN_241);

	// set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, ((ut32) 0x1));
	RzILOpEffect *set_usr_field_call_395 = hex_set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, CAST(32, IL_FALSE, SN(32, 1)));

	// HYB(gcc_expr_if ((sextract64(((ut64) (((st64) ((st32) ((st16) ((Rs >> 0x0) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x0) & 0xffff)))) << 0x1) + (((st64) ((st32) ((st16) ((Rs >> 0x10) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x10) & 0xffff)))) << 0x1) + ((st64) 0x8000)), 0x0, 0x20) == (((st64) ((st32) ((st16) ((Rs >> 0x0) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x0) & 0xffff)))) << 0x1) + (((st64) ((st32) ((st16) ((Rs >> 0x10) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x10) & 0xffff)))) << 0x1) + ((st64) 0x8000))) {{}} else {set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, ((ut32) 0x1))}, (((((st64) ((st32) ((st16) ((Rs >> 0x0) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x0) & 0xffff)))) << 0x1) + (((st64) ((st32) ((st16) ((Rs >> 0x10) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x10) & 0xffff)))) << 0x1) + ((st64) 0x8000) < ((st64) 0x0)) ? (-(0x1 << 0x1f)) : (0x1 << 0x1f) - ((st64) 0x1)));
	RzILOpPure *op_RSHIFT_258 = SHIFTRA(DUP(Rs), SN(32, 0));
	RzILOpPure *op_AND_260 = LOGAND(op_RSHIFT_258, SN(32, 0xffff));
	RzILOpPure *op_RSHIFT_266 = SHIFTRA(DUP(Rt), SN(32, 0));
	RzILOpPure *op_AND_268 = LOGAND(op_RSHIFT_266, SN(32, 0xffff));
	RzILOpPure *op_MUL_271 = MUL(CAST(32, MSB(CAST(16, MSB(op_AND_260), DUP(op_AND_260))), CAST(16, MSB(DUP(op_AND_260)), DUP(op_AND_260))), CAST(32, MSB(CAST(16, MSB(op_AND_268), DUP(op_AND_268))), CAST(16, MSB(DUP(op_AND_268)), DUP(op_AND_268))));
	RzILOpPure *op_LSHIFT_274 = SHIFTL0(CAST(64, MSB(op_MUL_271), DUP(op_MUL_271)), SN(32, 1));
	RzILOpPure *op_RSHIFT_278 = SHIFTRA(DUP(Rs), SN(32, 16));
	RzILOpPure *op_AND_280 = LOGAND(op_RSHIFT_278, SN(32, 0xffff));
	RzILOpPure *op_RSHIFT_286 = SHIFTRA(DUP(Rt), SN(32, 16));
	RzILOpPure *op_AND_288 = LOGAND(op_RSHIFT_286, SN(32, 0xffff));
	RzILOpPure *op_MUL_291 = MUL(CAST(32, MSB(CAST(16, MSB(op_AND_280), DUP(op_AND_280))), CAST(16, MSB(DUP(op_AND_280)), DUP(op_AND_280))), CAST(32, MSB(CAST(16, MSB(op_AND_288), DUP(op_AND_288))), CAST(16, MSB(DUP(op_AND_288)), DUP(op_AND_288))));
	RzILOpPure *op_LSHIFT_294 = SHIFTL0(CAST(64, MSB(op_MUL_291), DUP(op_MUL_291)), SN(32, 1));
	RzILOpPure *op_ADD_295 = ADD(op_LSHIFT_274, op_LSHIFT_294);
	RzILOpPure *op_ADD_298 = ADD(op_ADD_295, CAST(64, MSB(SN(32, 0x8000)), SN(32, 0x8000)));
	RzILOpPure *op_RSHIFT_307 = SHIFTRA(DUP(Rs), SN(32, 0));
	RzILOpPure *op_AND_309 = LOGAND(op_RSHIFT_307, SN(32, 0xffff));
	RzILOpPure *op_RSHIFT_315 = SHIFTRA(DUP(Rt), SN(32, 0));
	RzILOpPure *op_AND_317 = LOGAND(op_RSHIFT_315, SN(32, 0xffff));
	RzILOpPure *op_MUL_320 = MUL(CAST(32, MSB(CAST(16, MSB(op_AND_309), DUP(op_AND_309))), CAST(16, MSB(DUP(op_AND_309)), DUP(op_AND_309))), CAST(32, MSB(CAST(16, MSB(op_AND_317), DUP(op_AND_317))), CAST(16, MSB(DUP(op_AND_317)), DUP(op_AND_317))));
	RzILOpPure *op_LSHIFT_323 = SHIFTL0(CAST(64, MSB(op_MUL_320), DUP(op_MUL_320)), SN(32, 1));
	RzILOpPure *op_RSHIFT_327 = SHIFTRA(DUP(Rs), SN(32, 16));
	RzILOpPure *op_AND_329 = LOGAND(op_RSHIFT_327, SN(32, 0xffff));
	RzILOpPure *op_RSHIFT_335 = SHIFTRA(DUP(Rt), SN(32, 16));
	RzILOpPure *op_AND_337 = LOGAND(op_RSHIFT_335, SN(32, 0xffff));
	RzILOpPure *op_MUL_340 = MUL(CAST(32, MSB(CAST(16, MSB(op_AND_329), DUP(op_AND_329))), CAST(16, MSB(DUP(op_AND_329)), DUP(op_AND_329))), CAST(32, MSB(CAST(16, MSB(op_AND_337), DUP(op_AND_337))), CAST(16, MSB(DUP(op_AND_337)), DUP(op_AND_337))));
	RzILOpPure *op_LSHIFT_343 = SHIFTL0(CAST(64, MSB(op_MUL_340), DUP(op_MUL_340)), SN(32, 1));
	RzILOpPure *op_ADD_344 = ADD(op_LSHIFT_323, op_LSHIFT_343);
	RzILOpPure *op_ADD_347 = ADD(op_ADD_344, CAST(64, MSB(SN(32, 0x8000)), SN(32, 0x8000)));
	RzILOpPure *op_EQ_348 = EQ(SEXTRACT64(CAST(64, IL_FALSE, op_ADD_298), SN(32, 0), SN(32, 0x20)), op_ADD_347);
	RzILOpPure *op_RSHIFT_399 = SHIFTRA(DUP(Rs), SN(32, 0));
	RzILOpPure *op_AND_401 = LOGAND(op_RSHIFT_399, SN(32, 0xffff));
	RzILOpPure *op_RSHIFT_407 = SHIFTRA(DUP(Rt), SN(32, 0));
	RzILOpPure *op_AND_409 = LOGAND(op_RSHIFT_407, SN(32, 0xffff));
	RzILOpPure *op_MUL_412 = MUL(CAST(32, MSB(CAST(16, MSB(op_AND_401), DUP(op_AND_401))), CAST(16, MSB(DUP(op_AND_401)), DUP(op_AND_401))), CAST(32, MSB(CAST(16, MSB(op_AND_409), DUP(op_AND_409))), CAST(16, MSB(DUP(op_AND_409)), DUP(op_AND_409))));
	RzILOpPure *op_LSHIFT_415 = SHIFTL0(CAST(64, MSB(op_MUL_412), DUP(op_MUL_412)), SN(32, 1));
	RzILOpPure *op_RSHIFT_419 = SHIFTRA(DUP(Rs), SN(32, 16));
	RzILOpPure *op_AND_421 = LOGAND(op_RSHIFT_419, SN(32, 0xffff));
	RzILOpPure *op_RSHIFT_427 = SHIFTRA(DUP(Rt), SN(32, 16));
	RzILOpPure *op_AND_429 = LOGAND(op_RSHIFT_427, SN(32, 0xffff));
	RzILOpPure *op_MUL_432 = MUL(CAST(32, MSB(CAST(16, MSB(op_AND_421), DUP(op_AND_421))), CAST(16, MSB(DUP(op_AND_421)), DUP(op_AND_421))), CAST(32, MSB(CAST(16, MSB(op_AND_429), DUP(op_AND_429))), CAST(16, MSB(DUP(op_AND_429)), DUP(op_AND_429))));
	RzILOpPure *op_LSHIFT_435 = SHIFTL0(CAST(64, MSB(op_MUL_432), DUP(op_MUL_432)), SN(32, 1));
	RzILOpPure *op_ADD_436 = ADD(op_LSHIFT_415, op_LSHIFT_435);
	RzILOpPure *op_ADD_439 = ADD(op_ADD_436, CAST(64, MSB(SN(32, 0x8000)), SN(32, 0x8000)));
	RzILOpPure *op_LT_442 = SLT(op_ADD_439, CAST(64, MSB(SN(32, 0)), SN(32, 0)));
	RzILOpPure *op_LSHIFT_447 = SHIFTL0(SN(64, 1), SN(32, 31));
	RzILOpPure *op_NEG_448 = NEG(op_LSHIFT_447);
	RzILOpPure *op_LSHIFT_453 = SHIFTL0(SN(64, 1), SN(32, 31));
	RzILOpPure *op_SUB_456 = SUB(op_LSHIFT_453, CAST(64, MSB(SN(32, 1)), SN(32, 1)));
	RzILOpPure *cond_457 = ITE(op_LT_442, op_NEG_448, op_SUB_456);
	RzILOpEffect *gcc_expr_458 = BRANCH(op_EQ_348, EMPTY(), set_usr_field_call_395);

	// h_tmp247 = HYB(gcc_expr_if ((sextract64(((ut64) (((st64) ((st32) ((st16) ((Rs >> 0x0) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x0) & 0xffff)))) << 0x1) + (((st64) ((st32) ((st16) ((Rs >> 0x10) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x10) & 0xffff)))) << 0x1) + ((st64) 0x8000)), 0x0, 0x20) == (((st64) ((st32) ((st16) ((Rs >> 0x0) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x0) & 0xffff)))) << 0x1) + (((st64) ((st32) ((st16) ((Rs >> 0x10) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x10) & 0xffff)))) << 0x1) + ((st64) 0x8000))) {{}} else {set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, ((ut32) 0x1))}, (((((st64) ((st32) ((st16) ((Rs >> 0x0) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x0) & 0xffff)))) << 0x1) + (((st64) ((st32) ((st16) ((Rs >> 0x10) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x10) & 0xffff)))) << 0x1) + ((st64) 0x8000) < ((st64) 0x0)) ? (-(0x1 << 0x1f)) : (0x1 << 0x1f) - ((st64) 0x1)));
	RzILOpEffect *op_ASSIGN_hybrid_tmp_460 = SETL("h_tmp247", cond_457);

	// seq(HYB(gcc_expr_if ((sextract64(((ut64) (((st64) ((st32) ((st16 ...;
	RzILOpEffect *seq_461 = SEQN(2, gcc_expr_458, op_ASSIGN_hybrid_tmp_460);

	// Rd = ((st32) (((ut64) (((st64) Rd) & (~(0xffff << 0x0)))) | (((ut64) (((st32) ((st16) ((((sextract64(((ut64) (((st64) ((st32) ((st16) ((Rs >> 0x0) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x0) & 0xffff)))) << 0x1) + (((st64) ((st32) ((st16) ((Rs >> 0x10) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x10) & 0xffff)))) << 0x1) + ((st64) 0x8000)), 0x0, 0x20) == (((st64) ((st32) ((st16) ((Rs >> 0x0) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x0) & 0xffff)))) << 0x1) + (((st64) ((st32) ((st16) ((Rs >> 0x10) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x10) & 0xffff)))) << 0x1) + ((st64) 0x8000)) ? (((st64) ((st32) ((st16) ((Rs >> 0x0) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x0) & 0xffff)))) << 0x1) + (((st64) ((st32) ((st16) ((Rs >> 0x10) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x10) & 0xffff)))) << 0x1) + ((st64) 0x8000) : h_tmp247) >> 0x10) & ((st64) 0xffff)))) & 0xffff)) << 0x0)));
	RzILOpPure *op_LSHIFT_248 = SHIFTL0(SN(64, 0xffff), SN(32, 0));
	RzILOpPure *op_NOT_249 = LOGNOT(op_LSHIFT_248);
	RzILOpPure *op_AND_251 = LOGAND(CAST(64, MSB(READ_REG(pkt, Rd_op, true)), READ_REG(pkt, Rd_op, true)), op_NOT_249);
	RzILOpPure *op_RSHIFT_352 = SHIFTRA(DUP(Rs), SN(32, 0));
	RzILOpPure *op_AND_354 = LOGAND(op_RSHIFT_352, SN(32, 0xffff));
	RzILOpPure *op_RSHIFT_360 = SHIFTRA(DUP(Rt), SN(32, 0));
	RzILOpPure *op_AND_362 = LOGAND(op_RSHIFT_360, SN(32, 0xffff));
	RzILOpPure *op_MUL_365 = MUL(CAST(32, MSB(CAST(16, MSB(op_AND_354), DUP(op_AND_354))), CAST(16, MSB(DUP(op_AND_354)), DUP(op_AND_354))), CAST(32, MSB(CAST(16, MSB(op_AND_362), DUP(op_AND_362))), CAST(16, MSB(DUP(op_AND_362)), DUP(op_AND_362))));
	RzILOpPure *op_LSHIFT_368 = SHIFTL0(CAST(64, MSB(op_MUL_365), DUP(op_MUL_365)), SN(32, 1));
	RzILOpPure *op_RSHIFT_372 = SHIFTRA(DUP(Rs), SN(32, 16));
	RzILOpPure *op_AND_374 = LOGAND(op_RSHIFT_372, SN(32, 0xffff));
	RzILOpPure *op_RSHIFT_380 = SHIFTRA(DUP(Rt), SN(32, 16));
	RzILOpPure *op_AND_382 = LOGAND(op_RSHIFT_380, SN(32, 0xffff));
	RzILOpPure *op_MUL_385 = MUL(CAST(32, MSB(CAST(16, MSB(op_AND_374), DUP(op_AND_374))), CAST(16, MSB(DUP(op_AND_374)), DUP(op_AND_374))), CAST(32, MSB(CAST(16, MSB(op_AND_382), DUP(op_AND_382))), CAST(16, MSB(DUP(op_AND_382)), DUP(op_AND_382))));
	RzILOpPure *op_LSHIFT_388 = SHIFTL0(CAST(64, MSB(op_MUL_385), DUP(op_MUL_385)), SN(32, 1));
	RzILOpPure *op_ADD_389 = ADD(op_LSHIFT_368, op_LSHIFT_388);
	RzILOpPure *op_ADD_392 = ADD(op_ADD_389, CAST(64, MSB(SN(32, 0x8000)), SN(32, 0x8000)));
	RzILOpPure *cond_462 = ITE(DUP(op_EQ_348), op_ADD_392, VARL("h_tmp247"));
	RzILOpPure *op_RSHIFT_466 = SHIFTRA(cond_462, SN(32, 16));
	RzILOpPure *op_AND_469 = LOGAND(op_RSHIFT_466, CAST(64, MSB(SN(32, 0xffff)), SN(32, 0xffff)));
	RzILOpPure *op_AND_473 = LOGAND(CAST(32, MSB(CAST(16, MSB(op_AND_469), DUP(op_AND_469))), CAST(16, MSB(DUP(op_AND_469)), DUP(op_AND_469))), SN(32, 0xffff));
	RzILOpPure *op_LSHIFT_478 = SHIFTL0(CAST(64, IL_FALSE, op_AND_473), SN(32, 0));
	RzILOpPure *op_OR_480 = LOGOR(CAST(64, IL_FALSE, op_AND_251), op_LSHIFT_478);
	RzILOpEffect *op_ASSIGN_482 = WRITE_REG(bundle, Rd_op, CAST(32, IL_FALSE, op_OR_480));

	// seq(seq(HYB(gcc_expr_if ((sextract64(((ut64) (((st64) ((st32) (( ...;
	RzILOpEffect *seq_483 = SEQN(2, seq_461, op_ASSIGN_482);

	RzILOpEffect *instruction_sequence = SEQN(2, seq_242, seq_483);
	return instruction_sequence;
}

// Rdd = cmpy(Rs,Rt):sat
RzILOpEffect *hex_il_op_m2_cmpys_s0(HexInsnPktBundle *bundle) {
	const HexInsn *hi = bundle->insn;
	HexPkt *pkt = bundle->pkt;
	// READ
	const HexOp *Rdd_op = ISA2REG(hi, 'd', false);
	const HexOp *Rs_op = ISA2REG(hi, 's', false);
	RzILOpPure *Rs = READ_REG(pkt, Rs_op, false);
	const HexOp *Rt_op = ISA2REG(hi, 't', false);
	RzILOpPure *Rt = READ_REG(pkt, Rt_op, false);

	// set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, ((ut32) 0x1));
	RzILOpEffect *set_usr_field_call_144 = hex_set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, CAST(32, IL_FALSE, SN(32, 1)));

	// HYB(gcc_expr_if ((sextract64(((ut64) (((st64) ((st32) ((st16) ((Rs >> 0x10) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x0) & 0xffff)))) << 0x0) + (((st64) ((st32) ((st16) ((Rs >> 0x0) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x10) & 0xffff)))) << 0x0)), 0x0, 0x20) == (((st64) ((st32) ((st16) ((Rs >> 0x10) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x0) & 0xffff)))) << 0x0) + (((st64) ((st32) ((st16) ((Rs >> 0x0) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x10) & 0xffff)))) << 0x0))) {{}} else {set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, ((ut32) 0x1))}, (((((st64) ((st32) ((st16) ((Rs >> 0x10) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x0) & 0xffff)))) << 0x0) + (((st64) ((st32) ((st16) ((Rs >> 0x0) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x10) & 0xffff)))) << 0x0) < ((st64) 0x0)) ? (-(0x1 << 0x1f)) : (0x1 << 0x1f) - ((st64) 0x1)));
	RzILOpPure *op_RSHIFT_15 = SHIFTRA(Rs, SN(32, 16));
	RzILOpPure *op_AND_17 = LOGAND(op_RSHIFT_15, SN(32, 0xffff));
	RzILOpPure *op_RSHIFT_24 = SHIFTRA(Rt, SN(32, 0));
	RzILOpPure *op_AND_26 = LOGAND(op_RSHIFT_24, SN(32, 0xffff));
	RzILOpPure *op_MUL_29 = MUL(CAST(32, MSB(CAST(16, MSB(op_AND_17), DUP(op_AND_17))), CAST(16, MSB(DUP(op_AND_17)), DUP(op_AND_17))), CAST(32, MSB(CAST(16, MSB(op_AND_26), DUP(op_AND_26))), CAST(16, MSB(DUP(op_AND_26)), DUP(op_AND_26))));
	RzILOpPure *op_LSHIFT_32 = SHIFTL0(CAST(64, MSB(op_MUL_29), DUP(op_MUL_29)), SN(32, 0));
	RzILOpPure *op_RSHIFT_36 = SHIFTRA(DUP(Rs), SN(32, 0));
	RzILOpPure *op_AND_38 = LOGAND(op_RSHIFT_36, SN(32, 0xffff));
	RzILOpPure *op_RSHIFT_44 = SHIFTRA(DUP(Rt), SN(32, 16));
	RzILOpPure *op_AND_46 = LOGAND(op_RSHIFT_44, SN(32, 0xffff));
	RzILOpPure *op_MUL_49 = MUL(CAST(32, MSB(CAST(16, MSB(op_AND_38), DUP(op_AND_38))), CAST(16, MSB(DUP(op_AND_38)), DUP(op_AND_38))), CAST(32, MSB(CAST(16, MSB(op_AND_46), DUP(op_AND_46))), CAST(16, MSB(DUP(op_AND_46)), DUP(op_AND_46))));
	RzILOpPure *op_LSHIFT_52 = SHIFTL0(CAST(64, MSB(op_MUL_49), DUP(op_MUL_49)), SN(32, 0));
	RzILOpPure *op_ADD_53 = ADD(op_LSHIFT_32, op_LSHIFT_52);
	RzILOpPure *op_RSHIFT_62 = SHIFTRA(DUP(Rs), SN(32, 16));
	RzILOpPure *op_AND_64 = LOGAND(op_RSHIFT_62, SN(32, 0xffff));
	RzILOpPure *op_RSHIFT_70 = SHIFTRA(DUP(Rt), SN(32, 0));
	RzILOpPure *op_AND_72 = LOGAND(op_RSHIFT_70, SN(32, 0xffff));
	RzILOpPure *op_MUL_75 = MUL(CAST(32, MSB(CAST(16, MSB(op_AND_64), DUP(op_AND_64))), CAST(16, MSB(DUP(op_AND_64)), DUP(op_AND_64))), CAST(32, MSB(CAST(16, MSB(op_AND_72), DUP(op_AND_72))), CAST(16, MSB(DUP(op_AND_72)), DUP(op_AND_72))));
	RzILOpPure *op_LSHIFT_78 = SHIFTL0(CAST(64, MSB(op_MUL_75), DUP(op_MUL_75)), SN(32, 0));
	RzILOpPure *op_RSHIFT_82 = SHIFTRA(DUP(Rs), SN(32, 0));
	RzILOpPure *op_AND_84 = LOGAND(op_RSHIFT_82, SN(32, 0xffff));
	RzILOpPure *op_RSHIFT_90 = SHIFTRA(DUP(Rt), SN(32, 16));
	RzILOpPure *op_AND_92 = LOGAND(op_RSHIFT_90, SN(32, 0xffff));
	RzILOpPure *op_MUL_95 = MUL(CAST(32, MSB(CAST(16, MSB(op_AND_84), DUP(op_AND_84))), CAST(16, MSB(DUP(op_AND_84)), DUP(op_AND_84))), CAST(32, MSB(CAST(16, MSB(op_AND_92), DUP(op_AND_92))), CAST(16, MSB(DUP(op_AND_92)), DUP(op_AND_92))));
	RzILOpPure *op_LSHIFT_98 = SHIFTL0(CAST(64, MSB(op_MUL_95), DUP(op_MUL_95)), SN(32, 0));
	RzILOpPure *op_ADD_99 = ADD(op_LSHIFT_78, op_LSHIFT_98);
	RzILOpPure *op_EQ_100 = EQ(SEXTRACT64(CAST(64, IL_FALSE, op_ADD_53), SN(32, 0), SN(32, 0x20)), op_ADD_99);
	RzILOpPure *op_RSHIFT_148 = SHIFTRA(DUP(Rs), SN(32, 16));
	RzILOpPure *op_AND_150 = LOGAND(op_RSHIFT_148, SN(32, 0xffff));
	RzILOpPure *op_RSHIFT_156 = SHIFTRA(DUP(Rt), SN(32, 0));
	RzILOpPure *op_AND_158 = LOGAND(op_RSHIFT_156, SN(32, 0xffff));
	RzILOpPure *op_MUL_161 = MUL(CAST(32, MSB(CAST(16, MSB(op_AND_150), DUP(op_AND_150))), CAST(16, MSB(DUP(op_AND_150)), DUP(op_AND_150))), CAST(32, MSB(CAST(16, MSB(op_AND_158), DUP(op_AND_158))), CAST(16, MSB(DUP(op_AND_158)), DUP(op_AND_158))));
	RzILOpPure *op_LSHIFT_164 = SHIFTL0(CAST(64, MSB(op_MUL_161), DUP(op_MUL_161)), SN(32, 0));
	RzILOpPure *op_RSHIFT_168 = SHIFTRA(DUP(Rs), SN(32, 0));
	RzILOpPure *op_AND_170 = LOGAND(op_RSHIFT_168, SN(32, 0xffff));
	RzILOpPure *op_RSHIFT_176 = SHIFTRA(DUP(Rt), SN(32, 16));
	RzILOpPure *op_AND_178 = LOGAND(op_RSHIFT_176, SN(32, 0xffff));
	RzILOpPure *op_MUL_181 = MUL(CAST(32, MSB(CAST(16, MSB(op_AND_170), DUP(op_AND_170))), CAST(16, MSB(DUP(op_AND_170)), DUP(op_AND_170))), CAST(32, MSB(CAST(16, MSB(op_AND_178), DUP(op_AND_178))), CAST(16, MSB(DUP(op_AND_178)), DUP(op_AND_178))));
	RzILOpPure *op_LSHIFT_184 = SHIFTL0(CAST(64, MSB(op_MUL_181), DUP(op_MUL_181)), SN(32, 0));
	RzILOpPure *op_ADD_185 = ADD(op_LSHIFT_164, op_LSHIFT_184);
	RzILOpPure *op_LT_188 = SLT(op_ADD_185, CAST(64, MSB(SN(32, 0)), SN(32, 0)));
	RzILOpPure *op_LSHIFT_193 = SHIFTL0(SN(64, 1), SN(32, 31));
	RzILOpPure *op_NEG_194 = NEG(op_LSHIFT_193);
	RzILOpPure *op_LSHIFT_199 = SHIFTL0(SN(64, 1), SN(32, 31));
	RzILOpPure *op_SUB_202 = SUB(op_LSHIFT_199, CAST(64, MSB(SN(32, 1)), SN(32, 1)));
	RzILOpPure *cond_203 = ITE(op_LT_188, op_NEG_194, op_SUB_202);
	RzILOpEffect *gcc_expr_204 = BRANCH(op_EQ_100, EMPTY(), set_usr_field_call_144);

	// h_tmp248 = HYB(gcc_expr_if ((sextract64(((ut64) (((st64) ((st32) ((st16) ((Rs >> 0x10) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x0) & 0xffff)))) << 0x0) + (((st64) ((st32) ((st16) ((Rs >> 0x0) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x10) & 0xffff)))) << 0x0)), 0x0, 0x20) == (((st64) ((st32) ((st16) ((Rs >> 0x10) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x0) & 0xffff)))) << 0x0) + (((st64) ((st32) ((st16) ((Rs >> 0x0) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x10) & 0xffff)))) << 0x0))) {{}} else {set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, ((ut32) 0x1))}, (((((st64) ((st32) ((st16) ((Rs >> 0x10) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x0) & 0xffff)))) << 0x0) + (((st64) ((st32) ((st16) ((Rs >> 0x0) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x10) & 0xffff)))) << 0x0) < ((st64) 0x0)) ? (-(0x1 << 0x1f)) : (0x1 << 0x1f) - ((st64) 0x1)));
	RzILOpEffect *op_ASSIGN_hybrid_tmp_206 = SETL("h_tmp248", cond_203);

	// seq(HYB(gcc_expr_if ((sextract64(((ut64) (((st64) ((st32) ((st16 ...;
	RzILOpEffect *seq_207 = SEQN(2, gcc_expr_204, op_ASSIGN_hybrid_tmp_206);

	// Rdd = ((Rdd & (~(0xffffffff << 0x20))) | ((((sextract64(((ut64) (((st64) ((st32) ((st16) ((Rs >> 0x10) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x0) & 0xffff)))) << 0x0) + (((st64) ((st32) ((st16) ((Rs >> 0x0) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x10) & 0xffff)))) << 0x0)), 0x0, 0x20) == (((st64) ((st32) ((st16) ((Rs >> 0x10) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x0) & 0xffff)))) << 0x0) + (((st64) ((st32) ((st16) ((Rs >> 0x0) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x10) & 0xffff)))) << 0x0)) ? (((st64) ((st32) ((st16) ((Rs >> 0x10) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x0) & 0xffff)))) << 0x0) + (((st64) ((st32) ((st16) ((Rs >> 0x0) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x10) & 0xffff)))) << 0x0) : h_tmp248) & 0xffffffff) << 0x20));
	RzILOpPure *op_LSHIFT_5 = SHIFTL0(SN(64, 0xffffffff), SN(32, 0x20));
	RzILOpPure *op_NOT_6 = LOGNOT(op_LSHIFT_5);
	RzILOpPure *op_AND_7 = LOGAND(READ_REG(pkt, Rdd_op, true), op_NOT_6);
	RzILOpPure *op_RSHIFT_104 = SHIFTRA(DUP(Rs), SN(32, 16));
	RzILOpPure *op_AND_106 = LOGAND(op_RSHIFT_104, SN(32, 0xffff));
	RzILOpPure *op_RSHIFT_112 = SHIFTRA(DUP(Rt), SN(32, 0));
	RzILOpPure *op_AND_114 = LOGAND(op_RSHIFT_112, SN(32, 0xffff));
	RzILOpPure *op_MUL_117 = MUL(CAST(32, MSB(CAST(16, MSB(op_AND_106), DUP(op_AND_106))), CAST(16, MSB(DUP(op_AND_106)), DUP(op_AND_106))), CAST(32, MSB(CAST(16, MSB(op_AND_114), DUP(op_AND_114))), CAST(16, MSB(DUP(op_AND_114)), DUP(op_AND_114))));
	RzILOpPure *op_LSHIFT_120 = SHIFTL0(CAST(64, MSB(op_MUL_117), DUP(op_MUL_117)), SN(32, 0));
	RzILOpPure *op_RSHIFT_124 = SHIFTRA(DUP(Rs), SN(32, 0));
	RzILOpPure *op_AND_126 = LOGAND(op_RSHIFT_124, SN(32, 0xffff));
	RzILOpPure *op_RSHIFT_132 = SHIFTRA(DUP(Rt), SN(32, 16));
	RzILOpPure *op_AND_134 = LOGAND(op_RSHIFT_132, SN(32, 0xffff));
	RzILOpPure *op_MUL_137 = MUL(CAST(32, MSB(CAST(16, MSB(op_AND_126), DUP(op_AND_126))), CAST(16, MSB(DUP(op_AND_126)), DUP(op_AND_126))), CAST(32, MSB(CAST(16, MSB(op_AND_134), DUP(op_AND_134))), CAST(16, MSB(DUP(op_AND_134)), DUP(op_AND_134))));
	RzILOpPure *op_LSHIFT_140 = SHIFTL0(CAST(64, MSB(op_MUL_137), DUP(op_MUL_137)), SN(32, 0));
	RzILOpPure *op_ADD_141 = ADD(op_LSHIFT_120, op_LSHIFT_140);
	RzILOpPure *cond_208 = ITE(DUP(op_EQ_100), op_ADD_141, VARL("h_tmp248"));
	RzILOpPure *op_AND_210 = LOGAND(cond_208, SN(64, 0xffffffff));
	RzILOpPure *op_LSHIFT_214 = SHIFTL0(op_AND_210, SN(32, 0x20));
	RzILOpPure *op_OR_215 = LOGOR(op_AND_7, op_LSHIFT_214);
	RzILOpEffect *op_ASSIGN_216 = WRITE_REG(bundle, Rdd_op, op_OR_215);

	// seq(seq(HYB(gcc_expr_if ((sextract64(((ut64) (((st64) ((st32) (( ...;
	RzILOpEffect *seq_217 = SEQN(2, seq_207, op_ASSIGN_216);

	// set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, ((ut32) 0x1));
	RzILOpEffect *set_usr_field_call_360 = hex_set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, CAST(32, IL_FALSE, SN(32, 1)));

	// HYB(gcc_expr_if ((sextract64(((ut64) (((st64) ((st32) ((st16) ((Rs >> 0x0) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x0) & 0xffff)))) << 0x0) - (((st64) ((st32) ((st16) ((Rs >> 0x10) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x10) & 0xffff)))) << 0x0)), 0x0, 0x20) == (((st64) ((st32) ((st16) ((Rs >> 0x0) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x0) & 0xffff)))) << 0x0) - (((st64) ((st32) ((st16) ((Rs >> 0x10) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x10) & 0xffff)))) << 0x0))) {{}} else {set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, ((ut32) 0x1))}, (((((st64) ((st32) ((st16) ((Rs >> 0x0) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x0) & 0xffff)))) << 0x0) - (((st64) ((st32) ((st16) ((Rs >> 0x10) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x10) & 0xffff)))) << 0x0) < ((st64) 0x0)) ? (-(0x1 << 0x1f)) : (0x1 << 0x1f) - ((st64) 0x1)));
	RzILOpPure *op_RSHIFT_232 = SHIFTRA(DUP(Rs), SN(32, 0));
	RzILOpPure *op_AND_234 = LOGAND(op_RSHIFT_232, SN(32, 0xffff));
	RzILOpPure *op_RSHIFT_240 = SHIFTRA(DUP(Rt), SN(32, 0));
	RzILOpPure *op_AND_242 = LOGAND(op_RSHIFT_240, SN(32, 0xffff));
	RzILOpPure *op_MUL_245 = MUL(CAST(32, MSB(CAST(16, MSB(op_AND_234), DUP(op_AND_234))), CAST(16, MSB(DUP(op_AND_234)), DUP(op_AND_234))), CAST(32, MSB(CAST(16, MSB(op_AND_242), DUP(op_AND_242))), CAST(16, MSB(DUP(op_AND_242)), DUP(op_AND_242))));
	RzILOpPure *op_LSHIFT_248 = SHIFTL0(CAST(64, MSB(op_MUL_245), DUP(op_MUL_245)), SN(32, 0));
	RzILOpPure *op_RSHIFT_252 = SHIFTRA(DUP(Rs), SN(32, 16));
	RzILOpPure *op_AND_254 = LOGAND(op_RSHIFT_252, SN(32, 0xffff));
	RzILOpPure *op_RSHIFT_260 = SHIFTRA(DUP(Rt), SN(32, 16));
	RzILOpPure *op_AND_262 = LOGAND(op_RSHIFT_260, SN(32, 0xffff));
	RzILOpPure *op_MUL_265 = MUL(CAST(32, MSB(CAST(16, MSB(op_AND_254), DUP(op_AND_254))), CAST(16, MSB(DUP(op_AND_254)), DUP(op_AND_254))), CAST(32, MSB(CAST(16, MSB(op_AND_262), DUP(op_AND_262))), CAST(16, MSB(DUP(op_AND_262)), DUP(op_AND_262))));
	RzILOpPure *op_LSHIFT_268 = SHIFTL0(CAST(64, MSB(op_MUL_265), DUP(op_MUL_265)), SN(32, 0));
	RzILOpPure *op_SUB_269 = SUB(op_LSHIFT_248, op_LSHIFT_268);
	RzILOpPure *op_RSHIFT_278 = SHIFTRA(DUP(Rs), SN(32, 0));
	RzILOpPure *op_AND_280 = LOGAND(op_RSHIFT_278, SN(32, 0xffff));
	RzILOpPure *op_RSHIFT_286 = SHIFTRA(DUP(Rt), SN(32, 0));
	RzILOpPure *op_AND_288 = LOGAND(op_RSHIFT_286, SN(32, 0xffff));
	RzILOpPure *op_MUL_291 = MUL(CAST(32, MSB(CAST(16, MSB(op_AND_280), DUP(op_AND_280))), CAST(16, MSB(DUP(op_AND_280)), DUP(op_AND_280))), CAST(32, MSB(CAST(16, MSB(op_AND_288), DUP(op_AND_288))), CAST(16, MSB(DUP(op_AND_288)), DUP(op_AND_288))));
	RzILOpPure *op_LSHIFT_294 = SHIFTL0(CAST(64, MSB(op_MUL_291), DUP(op_MUL_291)), SN(32, 0));
	RzILOpPure *op_RSHIFT_298 = SHIFTRA(DUP(Rs), SN(32, 16));
	RzILOpPure *op_AND_300 = LOGAND(op_RSHIFT_298, SN(32, 0xffff));
	RzILOpPure *op_RSHIFT_306 = SHIFTRA(DUP(Rt), SN(32, 16));
	RzILOpPure *op_AND_308 = LOGAND(op_RSHIFT_306, SN(32, 0xffff));
	RzILOpPure *op_MUL_311 = MUL(CAST(32, MSB(CAST(16, MSB(op_AND_300), DUP(op_AND_300))), CAST(16, MSB(DUP(op_AND_300)), DUP(op_AND_300))), CAST(32, MSB(CAST(16, MSB(op_AND_308), DUP(op_AND_308))), CAST(16, MSB(DUP(op_AND_308)), DUP(op_AND_308))));
	RzILOpPure *op_LSHIFT_314 = SHIFTL0(CAST(64, MSB(op_MUL_311), DUP(op_MUL_311)), SN(32, 0));
	RzILOpPure *op_SUB_315 = SUB(op_LSHIFT_294, op_LSHIFT_314);
	RzILOpPure *op_EQ_316 = EQ(SEXTRACT64(CAST(64, IL_FALSE, op_SUB_269), SN(32, 0), SN(32, 0x20)), op_SUB_315);
	RzILOpPure *op_RSHIFT_364 = SHIFTRA(DUP(Rs), SN(32, 0));
	RzILOpPure *op_AND_366 = LOGAND(op_RSHIFT_364, SN(32, 0xffff));
	RzILOpPure *op_RSHIFT_372 = SHIFTRA(DUP(Rt), SN(32, 0));
	RzILOpPure *op_AND_374 = LOGAND(op_RSHIFT_372, SN(32, 0xffff));
	RzILOpPure *op_MUL_377 = MUL(CAST(32, MSB(CAST(16, MSB(op_AND_366), DUP(op_AND_366))), CAST(16, MSB(DUP(op_AND_366)), DUP(op_AND_366))), CAST(32, MSB(CAST(16, MSB(op_AND_374), DUP(op_AND_374))), CAST(16, MSB(DUP(op_AND_374)), DUP(op_AND_374))));
	RzILOpPure *op_LSHIFT_380 = SHIFTL0(CAST(64, MSB(op_MUL_377), DUP(op_MUL_377)), SN(32, 0));
	RzILOpPure *op_RSHIFT_384 = SHIFTRA(DUP(Rs), SN(32, 16));
	RzILOpPure *op_AND_386 = LOGAND(op_RSHIFT_384, SN(32, 0xffff));
	RzILOpPure *op_RSHIFT_392 = SHIFTRA(DUP(Rt), SN(32, 16));
	RzILOpPure *op_AND_394 = LOGAND(op_RSHIFT_392, SN(32, 0xffff));
	RzILOpPure *op_MUL_397 = MUL(CAST(32, MSB(CAST(16, MSB(op_AND_386), DUP(op_AND_386))), CAST(16, MSB(DUP(op_AND_386)), DUP(op_AND_386))), CAST(32, MSB(CAST(16, MSB(op_AND_394), DUP(op_AND_394))), CAST(16, MSB(DUP(op_AND_394)), DUP(op_AND_394))));
	RzILOpPure *op_LSHIFT_400 = SHIFTL0(CAST(64, MSB(op_MUL_397), DUP(op_MUL_397)), SN(32, 0));
	RzILOpPure *op_SUB_401 = SUB(op_LSHIFT_380, op_LSHIFT_400);
	RzILOpPure *op_LT_404 = SLT(op_SUB_401, CAST(64, MSB(SN(32, 0)), SN(32, 0)));
	RzILOpPure *op_LSHIFT_409 = SHIFTL0(SN(64, 1), SN(32, 31));
	RzILOpPure *op_NEG_410 = NEG(op_LSHIFT_409);
	RzILOpPure *op_LSHIFT_415 = SHIFTL0(SN(64, 1), SN(32, 31));
	RzILOpPure *op_SUB_418 = SUB(op_LSHIFT_415, CAST(64, MSB(SN(32, 1)), SN(32, 1)));
	RzILOpPure *cond_419 = ITE(op_LT_404, op_NEG_410, op_SUB_418);
	RzILOpEffect *gcc_expr_420 = BRANCH(op_EQ_316, EMPTY(), set_usr_field_call_360);

	// h_tmp249 = HYB(gcc_expr_if ((sextract64(((ut64) (((st64) ((st32) ((st16) ((Rs >> 0x0) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x0) & 0xffff)))) << 0x0) - (((st64) ((st32) ((st16) ((Rs >> 0x10) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x10) & 0xffff)))) << 0x0)), 0x0, 0x20) == (((st64) ((st32) ((st16) ((Rs >> 0x0) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x0) & 0xffff)))) << 0x0) - (((st64) ((st32) ((st16) ((Rs >> 0x10) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x10) & 0xffff)))) << 0x0))) {{}} else {set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, ((ut32) 0x1))}, (((((st64) ((st32) ((st16) ((Rs >> 0x0) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x0) & 0xffff)))) << 0x0) - (((st64) ((st32) ((st16) ((Rs >> 0x10) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x10) & 0xffff)))) << 0x0) < ((st64) 0x0)) ? (-(0x1 << 0x1f)) : (0x1 << 0x1f) - ((st64) 0x1)));
	RzILOpEffect *op_ASSIGN_hybrid_tmp_422 = SETL("h_tmp249", cond_419);

	// seq(HYB(gcc_expr_if ((sextract64(((ut64) (((st64) ((st32) ((st16 ...;
	RzILOpEffect *seq_423 = SEQN(2, gcc_expr_420, op_ASSIGN_hybrid_tmp_422);

	// Rdd = ((Rdd & (~(0xffffffff << 0x0))) | ((((sextract64(((ut64) (((st64) ((st32) ((st16) ((Rs >> 0x0) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x0) & 0xffff)))) << 0x0) - (((st64) ((st32) ((st16) ((Rs >> 0x10) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x10) & 0xffff)))) << 0x0)), 0x0, 0x20) == (((st64) ((st32) ((st16) ((Rs >> 0x0) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x0) & 0xffff)))) << 0x0) - (((st64) ((st32) ((st16) ((Rs >> 0x10) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x10) & 0xffff)))) << 0x0)) ? (((st64) ((st32) ((st16) ((Rs >> 0x0) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x0) & 0xffff)))) << 0x0) - (((st64) ((st32) ((st16) ((Rs >> 0x10) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x10) & 0xffff)))) << 0x0) : h_tmp249) & 0xffffffff) << 0x0));
	RzILOpPure *op_LSHIFT_223 = SHIFTL0(SN(64, 0xffffffff), SN(32, 0));
	RzILOpPure *op_NOT_224 = LOGNOT(op_LSHIFT_223);
	RzILOpPure *op_AND_225 = LOGAND(READ_REG(pkt, Rdd_op, true), op_NOT_224);
	RzILOpPure *op_RSHIFT_320 = SHIFTRA(DUP(Rs), SN(32, 0));
	RzILOpPure *op_AND_322 = LOGAND(op_RSHIFT_320, SN(32, 0xffff));
	RzILOpPure *op_RSHIFT_328 = SHIFTRA(DUP(Rt), SN(32, 0));
	RzILOpPure *op_AND_330 = LOGAND(op_RSHIFT_328, SN(32, 0xffff));
	RzILOpPure *op_MUL_333 = MUL(CAST(32, MSB(CAST(16, MSB(op_AND_322), DUP(op_AND_322))), CAST(16, MSB(DUP(op_AND_322)), DUP(op_AND_322))), CAST(32, MSB(CAST(16, MSB(op_AND_330), DUP(op_AND_330))), CAST(16, MSB(DUP(op_AND_330)), DUP(op_AND_330))));
	RzILOpPure *op_LSHIFT_336 = SHIFTL0(CAST(64, MSB(op_MUL_333), DUP(op_MUL_333)), SN(32, 0));
	RzILOpPure *op_RSHIFT_340 = SHIFTRA(DUP(Rs), SN(32, 16));
	RzILOpPure *op_AND_342 = LOGAND(op_RSHIFT_340, SN(32, 0xffff));
	RzILOpPure *op_RSHIFT_348 = SHIFTRA(DUP(Rt), SN(32, 16));
	RzILOpPure *op_AND_350 = LOGAND(op_RSHIFT_348, SN(32, 0xffff));
	RzILOpPure *op_MUL_353 = MUL(CAST(32, MSB(CAST(16, MSB(op_AND_342), DUP(op_AND_342))), CAST(16, MSB(DUP(op_AND_342)), DUP(op_AND_342))), CAST(32, MSB(CAST(16, MSB(op_AND_350), DUP(op_AND_350))), CAST(16, MSB(DUP(op_AND_350)), DUP(op_AND_350))));
	RzILOpPure *op_LSHIFT_356 = SHIFTL0(CAST(64, MSB(op_MUL_353), DUP(op_MUL_353)), SN(32, 0));
	RzILOpPure *op_SUB_357 = SUB(op_LSHIFT_336, op_LSHIFT_356);
	RzILOpPure *cond_424 = ITE(DUP(op_EQ_316), op_SUB_357, VARL("h_tmp249"));
	RzILOpPure *op_AND_426 = LOGAND(cond_424, SN(64, 0xffffffff));
	RzILOpPure *op_LSHIFT_430 = SHIFTL0(op_AND_426, SN(32, 0));
	RzILOpPure *op_OR_431 = LOGOR(op_AND_225, op_LSHIFT_430);
	RzILOpEffect *op_ASSIGN_432 = WRITE_REG(bundle, Rdd_op, op_OR_431);

	// seq(seq(HYB(gcc_expr_if ((sextract64(((ut64) (((st64) ((st32) (( ...;
	RzILOpEffect *seq_433 = SEQN(2, seq_423, op_ASSIGN_432);

	RzILOpEffect *instruction_sequence = SEQN(2, seq_217, seq_433);
	return instruction_sequence;
}

// Rdd = cmpy(Rs,Rt):<<1:sat
RzILOpEffect *hex_il_op_m2_cmpys_s1(HexInsnPktBundle *bundle) {
	const HexInsn *hi = bundle->insn;
	HexPkt *pkt = bundle->pkt;
	// READ
	const HexOp *Rdd_op = ISA2REG(hi, 'd', false);
	const HexOp *Rs_op = ISA2REG(hi, 's', false);
	RzILOpPure *Rs = READ_REG(pkt, Rs_op, false);
	const HexOp *Rt_op = ISA2REG(hi, 't', false);
	RzILOpPure *Rt = READ_REG(pkt, Rt_op, false);

	// set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, ((ut32) 0x1));
	RzILOpEffect *set_usr_field_call_144 = hex_set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, CAST(32, IL_FALSE, SN(32, 1)));

	// HYB(gcc_expr_if ((sextract64(((ut64) (((st64) ((st32) ((st16) ((Rs >> 0x10) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x0) & 0xffff)))) << 0x1) + (((st64) ((st32) ((st16) ((Rs >> 0x0) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x10) & 0xffff)))) << 0x1)), 0x0, 0x20) == (((st64) ((st32) ((st16) ((Rs >> 0x10) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x0) & 0xffff)))) << 0x1) + (((st64) ((st32) ((st16) ((Rs >> 0x0) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x10) & 0xffff)))) << 0x1))) {{}} else {set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, ((ut32) 0x1))}, (((((st64) ((st32) ((st16) ((Rs >> 0x10) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x0) & 0xffff)))) << 0x1) + (((st64) ((st32) ((st16) ((Rs >> 0x0) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x10) & 0xffff)))) << 0x1) < ((st64) 0x0)) ? (-(0x1 << 0x1f)) : (0x1 << 0x1f) - ((st64) 0x1)));
	RzILOpPure *op_RSHIFT_15 = SHIFTRA(Rs, SN(32, 16));
	RzILOpPure *op_AND_17 = LOGAND(op_RSHIFT_15, SN(32, 0xffff));
	RzILOpPure *op_RSHIFT_24 = SHIFTRA(Rt, SN(32, 0));
	RzILOpPure *op_AND_26 = LOGAND(op_RSHIFT_24, SN(32, 0xffff));
	RzILOpPure *op_MUL_29 = MUL(CAST(32, MSB(CAST(16, MSB(op_AND_17), DUP(op_AND_17))), CAST(16, MSB(DUP(op_AND_17)), DUP(op_AND_17))), CAST(32, MSB(CAST(16, MSB(op_AND_26), DUP(op_AND_26))), CAST(16, MSB(DUP(op_AND_26)), DUP(op_AND_26))));
	RzILOpPure *op_LSHIFT_32 = SHIFTL0(CAST(64, MSB(op_MUL_29), DUP(op_MUL_29)), SN(32, 1));
	RzILOpPure *op_RSHIFT_36 = SHIFTRA(DUP(Rs), SN(32, 0));
	RzILOpPure *op_AND_38 = LOGAND(op_RSHIFT_36, SN(32, 0xffff));
	RzILOpPure *op_RSHIFT_44 = SHIFTRA(DUP(Rt), SN(32, 16));
	RzILOpPure *op_AND_46 = LOGAND(op_RSHIFT_44, SN(32, 0xffff));
	RzILOpPure *op_MUL_49 = MUL(CAST(32, MSB(CAST(16, MSB(op_AND_38), DUP(op_AND_38))), CAST(16, MSB(DUP(op_AND_38)), DUP(op_AND_38))), CAST(32, MSB(CAST(16, MSB(op_AND_46), DUP(op_AND_46))), CAST(16, MSB(DUP(op_AND_46)), DUP(op_AND_46))));
	RzILOpPure *op_LSHIFT_52 = SHIFTL0(CAST(64, MSB(op_MUL_49), DUP(op_MUL_49)), SN(32, 1));
	RzILOpPure *op_ADD_53 = ADD(op_LSHIFT_32, op_LSHIFT_52);
	RzILOpPure *op_RSHIFT_62 = SHIFTRA(DUP(Rs), SN(32, 16));
	RzILOpPure *op_AND_64 = LOGAND(op_RSHIFT_62, SN(32, 0xffff));
	RzILOpPure *op_RSHIFT_70 = SHIFTRA(DUP(Rt), SN(32, 0));
	RzILOpPure *op_AND_72 = LOGAND(op_RSHIFT_70, SN(32, 0xffff));
	RzILOpPure *op_MUL_75 = MUL(CAST(32, MSB(CAST(16, MSB(op_AND_64), DUP(op_AND_64))), CAST(16, MSB(DUP(op_AND_64)), DUP(op_AND_64))), CAST(32, MSB(CAST(16, MSB(op_AND_72), DUP(op_AND_72))), CAST(16, MSB(DUP(op_AND_72)), DUP(op_AND_72))));
	RzILOpPure *op_LSHIFT_78 = SHIFTL0(CAST(64, MSB(op_MUL_75), DUP(op_MUL_75)), SN(32, 1));
	RzILOpPure *op_RSHIFT_82 = SHIFTRA(DUP(Rs), SN(32, 0));
	RzILOpPure *op_AND_84 = LOGAND(op_RSHIFT_82, SN(32, 0xffff));
	RzILOpPure *op_RSHIFT_90 = SHIFTRA(DUP(Rt), SN(32, 16));
	RzILOpPure *op_AND_92 = LOGAND(op_RSHIFT_90, SN(32, 0xffff));
	RzILOpPure *op_MUL_95 = MUL(CAST(32, MSB(CAST(16, MSB(op_AND_84), DUP(op_AND_84))), CAST(16, MSB(DUP(op_AND_84)), DUP(op_AND_84))), CAST(32, MSB(CAST(16, MSB(op_AND_92), DUP(op_AND_92))), CAST(16, MSB(DUP(op_AND_92)), DUP(op_AND_92))));
	RzILOpPure *op_LSHIFT_98 = SHIFTL0(CAST(64, MSB(op_MUL_95), DUP(op_MUL_95)), SN(32, 1));
	RzILOpPure *op_ADD_99 = ADD(op_LSHIFT_78, op_LSHIFT_98);
	RzILOpPure *op_EQ_100 = EQ(SEXTRACT64(CAST(64, IL_FALSE, op_ADD_53), SN(32, 0), SN(32, 0x20)), op_ADD_99);
	RzILOpPure *op_RSHIFT_148 = SHIFTRA(DUP(Rs), SN(32, 16));
	RzILOpPure *op_AND_150 = LOGAND(op_RSHIFT_148, SN(32, 0xffff));
	RzILOpPure *op_RSHIFT_156 = SHIFTRA(DUP(Rt), SN(32, 0));
	RzILOpPure *op_AND_158 = LOGAND(op_RSHIFT_156, SN(32, 0xffff));
	RzILOpPure *op_MUL_161 = MUL(CAST(32, MSB(CAST(16, MSB(op_AND_150), DUP(op_AND_150))), CAST(16, MSB(DUP(op_AND_150)), DUP(op_AND_150))), CAST(32, MSB(CAST(16, MSB(op_AND_158), DUP(op_AND_158))), CAST(16, MSB(DUP(op_AND_158)), DUP(op_AND_158))));
	RzILOpPure *op_LSHIFT_164 = SHIFTL0(CAST(64, MSB(op_MUL_161), DUP(op_MUL_161)), SN(32, 1));
	RzILOpPure *op_RSHIFT_168 = SHIFTRA(DUP(Rs), SN(32, 0));
	RzILOpPure *op_AND_170 = LOGAND(op_RSHIFT_168, SN(32, 0xffff));
	RzILOpPure *op_RSHIFT_176 = SHIFTRA(DUP(Rt), SN(32, 16));
	RzILOpPure *op_AND_178 = LOGAND(op_RSHIFT_176, SN(32, 0xffff));
	RzILOpPure *op_MUL_181 = MUL(CAST(32, MSB(CAST(16, MSB(op_AND_170), DUP(op_AND_170))), CAST(16, MSB(DUP(op_AND_170)), DUP(op_AND_170))), CAST(32, MSB(CAST(16, MSB(op_AND_178), DUP(op_AND_178))), CAST(16, MSB(DUP(op_AND_178)), DUP(op_AND_178))));
	RzILOpPure *op_LSHIFT_184 = SHIFTL0(CAST(64, MSB(op_MUL_181), DUP(op_MUL_181)), SN(32, 1));
	RzILOpPure *op_ADD_185 = ADD(op_LSHIFT_164, op_LSHIFT_184);
	RzILOpPure *op_LT_188 = SLT(op_ADD_185, CAST(64, MSB(SN(32, 0)), SN(32, 0)));
	RzILOpPure *op_LSHIFT_193 = SHIFTL0(SN(64, 1), SN(32, 31));
	RzILOpPure *op_NEG_194 = NEG(op_LSHIFT_193);
	RzILOpPure *op_LSHIFT_199 = SHIFTL0(SN(64, 1), SN(32, 31));
	RzILOpPure *op_SUB_202 = SUB(op_LSHIFT_199, CAST(64, MSB(SN(32, 1)), SN(32, 1)));
	RzILOpPure *cond_203 = ITE(op_LT_188, op_NEG_194, op_SUB_202);
	RzILOpEffect *gcc_expr_204 = BRANCH(op_EQ_100, EMPTY(), set_usr_field_call_144);

	// h_tmp250 = HYB(gcc_expr_if ((sextract64(((ut64) (((st64) ((st32) ((st16) ((Rs >> 0x10) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x0) & 0xffff)))) << 0x1) + (((st64) ((st32) ((st16) ((Rs >> 0x0) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x10) & 0xffff)))) << 0x1)), 0x0, 0x20) == (((st64) ((st32) ((st16) ((Rs >> 0x10) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x0) & 0xffff)))) << 0x1) + (((st64) ((st32) ((st16) ((Rs >> 0x0) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x10) & 0xffff)))) << 0x1))) {{}} else {set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, ((ut32) 0x1))}, (((((st64) ((st32) ((st16) ((Rs >> 0x10) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x0) & 0xffff)))) << 0x1) + (((st64) ((st32) ((st16) ((Rs >> 0x0) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x10) & 0xffff)))) << 0x1) < ((st64) 0x0)) ? (-(0x1 << 0x1f)) : (0x1 << 0x1f) - ((st64) 0x1)));
	RzILOpEffect *op_ASSIGN_hybrid_tmp_206 = SETL("h_tmp250", cond_203);

	// seq(HYB(gcc_expr_if ((sextract64(((ut64) (((st64) ((st32) ((st16 ...;
	RzILOpEffect *seq_207 = SEQN(2, gcc_expr_204, op_ASSIGN_hybrid_tmp_206);

	// Rdd = ((Rdd & (~(0xffffffff << 0x20))) | ((((sextract64(((ut64) (((st64) ((st32) ((st16) ((Rs >> 0x10) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x0) & 0xffff)))) << 0x1) + (((st64) ((st32) ((st16) ((Rs >> 0x0) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x10) & 0xffff)))) << 0x1)), 0x0, 0x20) == (((st64) ((st32) ((st16) ((Rs >> 0x10) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x0) & 0xffff)))) << 0x1) + (((st64) ((st32) ((st16) ((Rs >> 0x0) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x10) & 0xffff)))) << 0x1)) ? (((st64) ((st32) ((st16) ((Rs >> 0x10) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x0) & 0xffff)))) << 0x1) + (((st64) ((st32) ((st16) ((Rs >> 0x0) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x10) & 0xffff)))) << 0x1) : h_tmp250) & 0xffffffff) << 0x20));
	RzILOpPure *op_LSHIFT_5 = SHIFTL0(SN(64, 0xffffffff), SN(32, 0x20));
	RzILOpPure *op_NOT_6 = LOGNOT(op_LSHIFT_5);
	RzILOpPure *op_AND_7 = LOGAND(READ_REG(pkt, Rdd_op, true), op_NOT_6);
	RzILOpPure *op_RSHIFT_104 = SHIFTRA(DUP(Rs), SN(32, 16));
	RzILOpPure *op_AND_106 = LOGAND(op_RSHIFT_104, SN(32, 0xffff));
	RzILOpPure *op_RSHIFT_112 = SHIFTRA(DUP(Rt), SN(32, 0));
	RzILOpPure *op_AND_114 = LOGAND(op_RSHIFT_112, SN(32, 0xffff));
	RzILOpPure *op_MUL_117 = MUL(CAST(32, MSB(CAST(16, MSB(op_AND_106), DUP(op_AND_106))), CAST(16, MSB(DUP(op_AND_106)), DUP(op_AND_106))), CAST(32, MSB(CAST(16, MSB(op_AND_114), DUP(op_AND_114))), CAST(16, MSB(DUP(op_AND_114)), DUP(op_AND_114))));
	RzILOpPure *op_LSHIFT_120 = SHIFTL0(CAST(64, MSB(op_MUL_117), DUP(op_MUL_117)), SN(32, 1));
	RzILOpPure *op_RSHIFT_124 = SHIFTRA(DUP(Rs), SN(32, 0));
	RzILOpPure *op_AND_126 = LOGAND(op_RSHIFT_124, SN(32, 0xffff));
	RzILOpPure *op_RSHIFT_132 = SHIFTRA(DUP(Rt), SN(32, 16));
	RzILOpPure *op_AND_134 = LOGAND(op_RSHIFT_132, SN(32, 0xffff));
	RzILOpPure *op_MUL_137 = MUL(CAST(32, MSB(CAST(16, MSB(op_AND_126), DUP(op_AND_126))), CAST(16, MSB(DUP(op_AND_126)), DUP(op_AND_126))), CAST(32, MSB(CAST(16, MSB(op_AND_134), DUP(op_AND_134))), CAST(16, MSB(DUP(op_AND_134)), DUP(op_AND_134))));
	RzILOpPure *op_LSHIFT_140 = SHIFTL0(CAST(64, MSB(op_MUL_137), DUP(op_MUL_137)), SN(32, 1));
	RzILOpPure *op_ADD_141 = ADD(op_LSHIFT_120, op_LSHIFT_140);
	RzILOpPure *cond_208 = ITE(DUP(op_EQ_100), op_ADD_141, VARL("h_tmp250"));
	RzILOpPure *op_AND_210 = LOGAND(cond_208, SN(64, 0xffffffff));
	RzILOpPure *op_LSHIFT_214 = SHIFTL0(op_AND_210, SN(32, 0x20));
	RzILOpPure *op_OR_215 = LOGOR(op_AND_7, op_LSHIFT_214);
	RzILOpEffect *op_ASSIGN_216 = WRITE_REG(bundle, Rdd_op, op_OR_215);

	// seq(seq(HYB(gcc_expr_if ((sextract64(((ut64) (((st64) ((st32) (( ...;
	RzILOpEffect *seq_217 = SEQN(2, seq_207, op_ASSIGN_216);

	// set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, ((ut32) 0x1));
	RzILOpEffect *set_usr_field_call_360 = hex_set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, CAST(32, IL_FALSE, SN(32, 1)));

	// HYB(gcc_expr_if ((sextract64(((ut64) (((st64) ((st32) ((st16) ((Rs >> 0x0) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x0) & 0xffff)))) << 0x1) - (((st64) ((st32) ((st16) ((Rs >> 0x10) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x10) & 0xffff)))) << 0x1)), 0x0, 0x20) == (((st64) ((st32) ((st16) ((Rs >> 0x0) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x0) & 0xffff)))) << 0x1) - (((st64) ((st32) ((st16) ((Rs >> 0x10) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x10) & 0xffff)))) << 0x1))) {{}} else {set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, ((ut32) 0x1))}, (((((st64) ((st32) ((st16) ((Rs >> 0x0) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x0) & 0xffff)))) << 0x1) - (((st64) ((st32) ((st16) ((Rs >> 0x10) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x10) & 0xffff)))) << 0x1) < ((st64) 0x0)) ? (-(0x1 << 0x1f)) : (0x1 << 0x1f) - ((st64) 0x1)));
	RzILOpPure *op_RSHIFT_232 = SHIFTRA(DUP(Rs), SN(32, 0));
	RzILOpPure *op_AND_234 = LOGAND(op_RSHIFT_232, SN(32, 0xffff));
	RzILOpPure *op_RSHIFT_240 = SHIFTRA(DUP(Rt), SN(32, 0));
	RzILOpPure *op_AND_242 = LOGAND(op_RSHIFT_240, SN(32, 0xffff));
	RzILOpPure *op_MUL_245 = MUL(CAST(32, MSB(CAST(16, MSB(op_AND_234), DUP(op_AND_234))), CAST(16, MSB(DUP(op_AND_234)), DUP(op_AND_234))), CAST(32, MSB(CAST(16, MSB(op_AND_242), DUP(op_AND_242))), CAST(16, MSB(DUP(op_AND_242)), DUP(op_AND_242))));
	RzILOpPure *op_LSHIFT_248 = SHIFTL0(CAST(64, MSB(op_MUL_245), DUP(op_MUL_245)), SN(32, 1));
	RzILOpPure *op_RSHIFT_252 = SHIFTRA(DUP(Rs), SN(32, 16));
	RzILOpPure *op_AND_254 = LOGAND(op_RSHIFT_252, SN(32, 0xffff));
	RzILOpPure *op_RSHIFT_260 = SHIFTRA(DUP(Rt), SN(32, 16));
	RzILOpPure *op_AND_262 = LOGAND(op_RSHIFT_260, SN(32, 0xffff));
	RzILOpPure *op_MUL_265 = MUL(CAST(32, MSB(CAST(16, MSB(op_AND_254), DUP(op_AND_254))), CAST(16, MSB(DUP(op_AND_254)), DUP(op_AND_254))), CAST(32, MSB(CAST(16, MSB(op_AND_262), DUP(op_AND_262))), CAST(16, MSB(DUP(op_AND_262)), DUP(op_AND_262))));
	RzILOpPure *op_LSHIFT_268 = SHIFTL0(CAST(64, MSB(op_MUL_265), DUP(op_MUL_265)), SN(32, 1));
	RzILOpPure *op_SUB_269 = SUB(op_LSHIFT_248, op_LSHIFT_268);
	RzILOpPure *op_RSHIFT_278 = SHIFTRA(DUP(Rs), SN(32, 0));
	RzILOpPure *op_AND_280 = LOGAND(op_RSHIFT_278, SN(32, 0xffff));
	RzILOpPure *op_RSHIFT_286 = SHIFTRA(DUP(Rt), SN(32, 0));
	RzILOpPure *op_AND_288 = LOGAND(op_RSHIFT_286, SN(32, 0xffff));
	RzILOpPure *op_MUL_291 = MUL(CAST(32, MSB(CAST(16, MSB(op_AND_280), DUP(op_AND_280))), CAST(16, MSB(DUP(op_AND_280)), DUP(op_AND_280))), CAST(32, MSB(CAST(16, MSB(op_AND_288), DUP(op_AND_288))), CAST(16, MSB(DUP(op_AND_288)), DUP(op_AND_288))));
	RzILOpPure *op_LSHIFT_294 = SHIFTL0(CAST(64, MSB(op_MUL_291), DUP(op_MUL_291)), SN(32, 1));
	RzILOpPure *op_RSHIFT_298 = SHIFTRA(DUP(Rs), SN(32, 16));
	RzILOpPure *op_AND_300 = LOGAND(op_RSHIFT_298, SN(32, 0xffff));
	RzILOpPure *op_RSHIFT_306 = SHIFTRA(DUP(Rt), SN(32, 16));
	RzILOpPure *op_AND_308 = LOGAND(op_RSHIFT_306, SN(32, 0xffff));
	RzILOpPure *op_MUL_311 = MUL(CAST(32, MSB(CAST(16, MSB(op_AND_300), DUP(op_AND_300))), CAST(16, MSB(DUP(op_AND_300)), DUP(op_AND_300))), CAST(32, MSB(CAST(16, MSB(op_AND_308), DUP(op_AND_308))), CAST(16, MSB(DUP(op_AND_308)), DUP(op_AND_308))));
	RzILOpPure *op_LSHIFT_314 = SHIFTL0(CAST(64, MSB(op_MUL_311), DUP(op_MUL_311)), SN(32, 1));
	RzILOpPure *op_SUB_315 = SUB(op_LSHIFT_294, op_LSHIFT_314);
	RzILOpPure *op_EQ_316 = EQ(SEXTRACT64(CAST(64, IL_FALSE, op_SUB_269), SN(32, 0), SN(32, 0x20)), op_SUB_315);
	RzILOpPure *op_RSHIFT_364 = SHIFTRA(DUP(Rs), SN(32, 0));
	RzILOpPure *op_AND_366 = LOGAND(op_RSHIFT_364, SN(32, 0xffff));
	RzILOpPure *op_RSHIFT_372 = SHIFTRA(DUP(Rt), SN(32, 0));
	RzILOpPure *op_AND_374 = LOGAND(op_RSHIFT_372, SN(32, 0xffff));
	RzILOpPure *op_MUL_377 = MUL(CAST(32, MSB(CAST(16, MSB(op_AND_366), DUP(op_AND_366))), CAST(16, MSB(DUP(op_AND_366)), DUP(op_AND_366))), CAST(32, MSB(CAST(16, MSB(op_AND_374), DUP(op_AND_374))), CAST(16, MSB(DUP(op_AND_374)), DUP(op_AND_374))));
	RzILOpPure *op_LSHIFT_380 = SHIFTL0(CAST(64, MSB(op_MUL_377), DUP(op_MUL_377)), SN(32, 1));
	RzILOpPure *op_RSHIFT_384 = SHIFTRA(DUP(Rs), SN(32, 16));
	RzILOpPure *op_AND_386 = LOGAND(op_RSHIFT_384, SN(32, 0xffff));
	RzILOpPure *op_RSHIFT_392 = SHIFTRA(DUP(Rt), SN(32, 16));
	RzILOpPure *op_AND_394 = LOGAND(op_RSHIFT_392, SN(32, 0xffff));
	RzILOpPure *op_MUL_397 = MUL(CAST(32, MSB(CAST(16, MSB(op_AND_386), DUP(op_AND_386))), CAST(16, MSB(DUP(op_AND_386)), DUP(op_AND_386))), CAST(32, MSB(CAST(16, MSB(op_AND_394), DUP(op_AND_394))), CAST(16, MSB(DUP(op_AND_394)), DUP(op_AND_394))));
	RzILOpPure *op_LSHIFT_400 = SHIFTL0(CAST(64, MSB(op_MUL_397), DUP(op_MUL_397)), SN(32, 1));
	RzILOpPure *op_SUB_401 = SUB(op_LSHIFT_380, op_LSHIFT_400);
	RzILOpPure *op_LT_404 = SLT(op_SUB_401, CAST(64, MSB(SN(32, 0)), SN(32, 0)));
	RzILOpPure *op_LSHIFT_409 = SHIFTL0(SN(64, 1), SN(32, 31));
	RzILOpPure *op_NEG_410 = NEG(op_LSHIFT_409);
	RzILOpPure *op_LSHIFT_415 = SHIFTL0(SN(64, 1), SN(32, 31));
	RzILOpPure *op_SUB_418 = SUB(op_LSHIFT_415, CAST(64, MSB(SN(32, 1)), SN(32, 1)));
	RzILOpPure *cond_419 = ITE(op_LT_404, op_NEG_410, op_SUB_418);
	RzILOpEffect *gcc_expr_420 = BRANCH(op_EQ_316, EMPTY(), set_usr_field_call_360);

	// h_tmp251 = HYB(gcc_expr_if ((sextract64(((ut64) (((st64) ((st32) ((st16) ((Rs >> 0x0) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x0) & 0xffff)))) << 0x1) - (((st64) ((st32) ((st16) ((Rs >> 0x10) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x10) & 0xffff)))) << 0x1)), 0x0, 0x20) == (((st64) ((st32) ((st16) ((Rs >> 0x0) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x0) & 0xffff)))) << 0x1) - (((st64) ((st32) ((st16) ((Rs >> 0x10) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x10) & 0xffff)))) << 0x1))) {{}} else {set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, ((ut32) 0x1))}, (((((st64) ((st32) ((st16) ((Rs >> 0x0) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x0) & 0xffff)))) << 0x1) - (((st64) ((st32) ((st16) ((Rs >> 0x10) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x10) & 0xffff)))) << 0x1) < ((st64) 0x0)) ? (-(0x1 << 0x1f)) : (0x1 << 0x1f) - ((st64) 0x1)));
	RzILOpEffect *op_ASSIGN_hybrid_tmp_422 = SETL("h_tmp251", cond_419);

	// seq(HYB(gcc_expr_if ((sextract64(((ut64) (((st64) ((st32) ((st16 ...;
	RzILOpEffect *seq_423 = SEQN(2, gcc_expr_420, op_ASSIGN_hybrid_tmp_422);

	// Rdd = ((Rdd & (~(0xffffffff << 0x0))) | ((((sextract64(((ut64) (((st64) ((st32) ((st16) ((Rs >> 0x0) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x0) & 0xffff)))) << 0x1) - (((st64) ((st32) ((st16) ((Rs >> 0x10) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x10) & 0xffff)))) << 0x1)), 0x0, 0x20) == (((st64) ((st32) ((st16) ((Rs >> 0x0) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x0) & 0xffff)))) << 0x1) - (((st64) ((st32) ((st16) ((Rs >> 0x10) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x10) & 0xffff)))) << 0x1)) ? (((st64) ((st32) ((st16) ((Rs >> 0x0) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x0) & 0xffff)))) << 0x1) - (((st64) ((st32) ((st16) ((Rs >> 0x10) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x10) & 0xffff)))) << 0x1) : h_tmp251) & 0xffffffff) << 0x0));
	RzILOpPure *op_LSHIFT_223 = SHIFTL0(SN(64, 0xffffffff), SN(32, 0));
	RzILOpPure *op_NOT_224 = LOGNOT(op_LSHIFT_223);
	RzILOpPure *op_AND_225 = LOGAND(READ_REG(pkt, Rdd_op, true), op_NOT_224);
	RzILOpPure *op_RSHIFT_320 = SHIFTRA(DUP(Rs), SN(32, 0));
	RzILOpPure *op_AND_322 = LOGAND(op_RSHIFT_320, SN(32, 0xffff));
	RzILOpPure *op_RSHIFT_328 = SHIFTRA(DUP(Rt), SN(32, 0));
	RzILOpPure *op_AND_330 = LOGAND(op_RSHIFT_328, SN(32, 0xffff));
	RzILOpPure *op_MUL_333 = MUL(CAST(32, MSB(CAST(16, MSB(op_AND_322), DUP(op_AND_322))), CAST(16, MSB(DUP(op_AND_322)), DUP(op_AND_322))), CAST(32, MSB(CAST(16, MSB(op_AND_330), DUP(op_AND_330))), CAST(16, MSB(DUP(op_AND_330)), DUP(op_AND_330))));
	RzILOpPure *op_LSHIFT_336 = SHIFTL0(CAST(64, MSB(op_MUL_333), DUP(op_MUL_333)), SN(32, 1));
	RzILOpPure *op_RSHIFT_340 = SHIFTRA(DUP(Rs), SN(32, 16));
	RzILOpPure *op_AND_342 = LOGAND(op_RSHIFT_340, SN(32, 0xffff));
	RzILOpPure *op_RSHIFT_348 = SHIFTRA(DUP(Rt), SN(32, 16));
	RzILOpPure *op_AND_350 = LOGAND(op_RSHIFT_348, SN(32, 0xffff));
	RzILOpPure *op_MUL_353 = MUL(CAST(32, MSB(CAST(16, MSB(op_AND_342), DUP(op_AND_342))), CAST(16, MSB(DUP(op_AND_342)), DUP(op_AND_342))), CAST(32, MSB(CAST(16, MSB(op_AND_350), DUP(op_AND_350))), CAST(16, MSB(DUP(op_AND_350)), DUP(op_AND_350))));
	RzILOpPure *op_LSHIFT_356 = SHIFTL0(CAST(64, MSB(op_MUL_353), DUP(op_MUL_353)), SN(32, 1));
	RzILOpPure *op_SUB_357 = SUB(op_LSHIFT_336, op_LSHIFT_356);
	RzILOpPure *cond_424 = ITE(DUP(op_EQ_316), op_SUB_357, VARL("h_tmp251"));
	RzILOpPure *op_AND_426 = LOGAND(cond_424, SN(64, 0xffffffff));
	RzILOpPure *op_LSHIFT_430 = SHIFTL0(op_AND_426, SN(32, 0));
	RzILOpPure *op_OR_431 = LOGOR(op_AND_225, op_LSHIFT_430);
	RzILOpEffect *op_ASSIGN_432 = WRITE_REG(bundle, Rdd_op, op_OR_431);

	// seq(seq(HYB(gcc_expr_if ((sextract64(((ut64) (((st64) ((st32) (( ...;
	RzILOpEffect *seq_433 = SEQN(2, seq_423, op_ASSIGN_432);

	RzILOpEffect *instruction_sequence = SEQN(2, seq_217, seq_433);
	return instruction_sequence;
}

// Rdd = cmpy(Rs,Rt*):sat
RzILOpEffect *hex_il_op_m2_cmpysc_s0(HexInsnPktBundle *bundle) {
	const HexInsn *hi = bundle->insn;
	HexPkt *pkt = bundle->pkt;
	// READ
	const HexOp *Rdd_op = ISA2REG(hi, 'd', false);
	const HexOp *Rs_op = ISA2REG(hi, 's', false);
	RzILOpPure *Rs = READ_REG(pkt, Rs_op, false);
	const HexOp *Rt_op = ISA2REG(hi, 't', false);
	RzILOpPure *Rt = READ_REG(pkt, Rt_op, false);

	// set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, ((ut32) 0x1));
	RzILOpEffect *set_usr_field_call_144 = hex_set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, CAST(32, IL_FALSE, SN(32, 1)));

	// HYB(gcc_expr_if ((sextract64(((ut64) (((st64) ((st32) ((st16) ((Rs >> 0x10) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x0) & 0xffff)))) << 0x0) - (((st64) ((st32) ((st16) ((Rs >> 0x0) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x10) & 0xffff)))) << 0x0)), 0x0, 0x20) == (((st64) ((st32) ((st16) ((Rs >> 0x10) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x0) & 0xffff)))) << 0x0) - (((st64) ((st32) ((st16) ((Rs >> 0x0) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x10) & 0xffff)))) << 0x0))) {{}} else {set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, ((ut32) 0x1))}, (((((st64) ((st32) ((st16) ((Rs >> 0x10) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x0) & 0xffff)))) << 0x0) - (((st64) ((st32) ((st16) ((Rs >> 0x0) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x10) & 0xffff)))) << 0x0) < ((st64) 0x0)) ? (-(0x1 << 0x1f)) : (0x1 << 0x1f) - ((st64) 0x1)));
	RzILOpPure *op_RSHIFT_15 = SHIFTRA(Rs, SN(32, 16));
	RzILOpPure *op_AND_17 = LOGAND(op_RSHIFT_15, SN(32, 0xffff));
	RzILOpPure *op_RSHIFT_24 = SHIFTRA(Rt, SN(32, 0));
	RzILOpPure *op_AND_26 = LOGAND(op_RSHIFT_24, SN(32, 0xffff));
	RzILOpPure *op_MUL_29 = MUL(CAST(32, MSB(CAST(16, MSB(op_AND_17), DUP(op_AND_17))), CAST(16, MSB(DUP(op_AND_17)), DUP(op_AND_17))), CAST(32, MSB(CAST(16, MSB(op_AND_26), DUP(op_AND_26))), CAST(16, MSB(DUP(op_AND_26)), DUP(op_AND_26))));
	RzILOpPure *op_LSHIFT_32 = SHIFTL0(CAST(64, MSB(op_MUL_29), DUP(op_MUL_29)), SN(32, 0));
	RzILOpPure *op_RSHIFT_36 = SHIFTRA(DUP(Rs), SN(32, 0));
	RzILOpPure *op_AND_38 = LOGAND(op_RSHIFT_36, SN(32, 0xffff));
	RzILOpPure *op_RSHIFT_44 = SHIFTRA(DUP(Rt), SN(32, 16));
	RzILOpPure *op_AND_46 = LOGAND(op_RSHIFT_44, SN(32, 0xffff));
	RzILOpPure *op_MUL_49 = MUL(CAST(32, MSB(CAST(16, MSB(op_AND_38), DUP(op_AND_38))), CAST(16, MSB(DUP(op_AND_38)), DUP(op_AND_38))), CAST(32, MSB(CAST(16, MSB(op_AND_46), DUP(op_AND_46))), CAST(16, MSB(DUP(op_AND_46)), DUP(op_AND_46))));
	RzILOpPure *op_LSHIFT_52 = SHIFTL0(CAST(64, MSB(op_MUL_49), DUP(op_MUL_49)), SN(32, 0));
	RzILOpPure *op_SUB_53 = SUB(op_LSHIFT_32, op_LSHIFT_52);
	RzILOpPure *op_RSHIFT_62 = SHIFTRA(DUP(Rs), SN(32, 16));
	RzILOpPure *op_AND_64 = LOGAND(op_RSHIFT_62, SN(32, 0xffff));
	RzILOpPure *op_RSHIFT_70 = SHIFTRA(DUP(Rt), SN(32, 0));
	RzILOpPure *op_AND_72 = LOGAND(op_RSHIFT_70, SN(32, 0xffff));
	RzILOpPure *op_MUL_75 = MUL(CAST(32, MSB(CAST(16, MSB(op_AND_64), DUP(op_AND_64))), CAST(16, MSB(DUP(op_AND_64)), DUP(op_AND_64))), CAST(32, MSB(CAST(16, MSB(op_AND_72), DUP(op_AND_72))), CAST(16, MSB(DUP(op_AND_72)), DUP(op_AND_72))));
	RzILOpPure *op_LSHIFT_78 = SHIFTL0(CAST(64, MSB(op_MUL_75), DUP(op_MUL_75)), SN(32, 0));
	RzILOpPure *op_RSHIFT_82 = SHIFTRA(DUP(Rs), SN(32, 0));
	RzILOpPure *op_AND_84 = LOGAND(op_RSHIFT_82, SN(32, 0xffff));
	RzILOpPure *op_RSHIFT_90 = SHIFTRA(DUP(Rt), SN(32, 16));
	RzILOpPure *op_AND_92 = LOGAND(op_RSHIFT_90, SN(32, 0xffff));
	RzILOpPure *op_MUL_95 = MUL(CAST(32, MSB(CAST(16, MSB(op_AND_84), DUP(op_AND_84))), CAST(16, MSB(DUP(op_AND_84)), DUP(op_AND_84))), CAST(32, MSB(CAST(16, MSB(op_AND_92), DUP(op_AND_92))), CAST(16, MSB(DUP(op_AND_92)), DUP(op_AND_92))));
	RzILOpPure *op_LSHIFT_98 = SHIFTL0(CAST(64, MSB(op_MUL_95), DUP(op_MUL_95)), SN(32, 0));
	RzILOpPure *op_SUB_99 = SUB(op_LSHIFT_78, op_LSHIFT_98);
	RzILOpPure *op_EQ_100 = EQ(SEXTRACT64(CAST(64, IL_FALSE, op_SUB_53), SN(32, 0), SN(32, 0x20)), op_SUB_99);
	RzILOpPure *op_RSHIFT_148 = SHIFTRA(DUP(Rs), SN(32, 16));
	RzILOpPure *op_AND_150 = LOGAND(op_RSHIFT_148, SN(32, 0xffff));
	RzILOpPure *op_RSHIFT_156 = SHIFTRA(DUP(Rt), SN(32, 0));
	RzILOpPure *op_AND_158 = LOGAND(op_RSHIFT_156, SN(32, 0xffff));
	RzILOpPure *op_MUL_161 = MUL(CAST(32, MSB(CAST(16, MSB(op_AND_150), DUP(op_AND_150))), CAST(16, MSB(DUP(op_AND_150)), DUP(op_AND_150))), CAST(32, MSB(CAST(16, MSB(op_AND_158), DUP(op_AND_158))), CAST(16, MSB(DUP(op_AND_158)), DUP(op_AND_158))));
	RzILOpPure *op_LSHIFT_164 = SHIFTL0(CAST(64, MSB(op_MUL_161), DUP(op_MUL_161)), SN(32, 0));
	RzILOpPure *op_RSHIFT_168 = SHIFTRA(DUP(Rs), SN(32, 0));
	RzILOpPure *op_AND_170 = LOGAND(op_RSHIFT_168, SN(32, 0xffff));
	RzILOpPure *op_RSHIFT_176 = SHIFTRA(DUP(Rt), SN(32, 16));
	RzILOpPure *op_AND_178 = LOGAND(op_RSHIFT_176, SN(32, 0xffff));
	RzILOpPure *op_MUL_181 = MUL(CAST(32, MSB(CAST(16, MSB(op_AND_170), DUP(op_AND_170))), CAST(16, MSB(DUP(op_AND_170)), DUP(op_AND_170))), CAST(32, MSB(CAST(16, MSB(op_AND_178), DUP(op_AND_178))), CAST(16, MSB(DUP(op_AND_178)), DUP(op_AND_178))));
	RzILOpPure *op_LSHIFT_184 = SHIFTL0(CAST(64, MSB(op_MUL_181), DUP(op_MUL_181)), SN(32, 0));
	RzILOpPure *op_SUB_185 = SUB(op_LSHIFT_164, op_LSHIFT_184);
	RzILOpPure *op_LT_188 = SLT(op_SUB_185, CAST(64, MSB(SN(32, 0)), SN(32, 0)));
	RzILOpPure *op_LSHIFT_193 = SHIFTL0(SN(64, 1), SN(32, 31));
	RzILOpPure *op_NEG_194 = NEG(op_LSHIFT_193);
	RzILOpPure *op_LSHIFT_199 = SHIFTL0(SN(64, 1), SN(32, 31));
	RzILOpPure *op_SUB_202 = SUB(op_LSHIFT_199, CAST(64, MSB(SN(32, 1)), SN(32, 1)));
	RzILOpPure *cond_203 = ITE(op_LT_188, op_NEG_194, op_SUB_202);
	RzILOpEffect *gcc_expr_204 = BRANCH(op_EQ_100, EMPTY(), set_usr_field_call_144);

	// h_tmp252 = HYB(gcc_expr_if ((sextract64(((ut64) (((st64) ((st32) ((st16) ((Rs >> 0x10) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x0) & 0xffff)))) << 0x0) - (((st64) ((st32) ((st16) ((Rs >> 0x0) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x10) & 0xffff)))) << 0x0)), 0x0, 0x20) == (((st64) ((st32) ((st16) ((Rs >> 0x10) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x0) & 0xffff)))) << 0x0) - (((st64) ((st32) ((st16) ((Rs >> 0x0) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x10) & 0xffff)))) << 0x0))) {{}} else {set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, ((ut32) 0x1))}, (((((st64) ((st32) ((st16) ((Rs >> 0x10) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x0) & 0xffff)))) << 0x0) - (((st64) ((st32) ((st16) ((Rs >> 0x0) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x10) & 0xffff)))) << 0x0) < ((st64) 0x0)) ? (-(0x1 << 0x1f)) : (0x1 << 0x1f) - ((st64) 0x1)));
	RzILOpEffect *op_ASSIGN_hybrid_tmp_206 = SETL("h_tmp252", cond_203);

	// seq(HYB(gcc_expr_if ((sextract64(((ut64) (((st64) ((st32) ((st16 ...;
	RzILOpEffect *seq_207 = SEQN(2, gcc_expr_204, op_ASSIGN_hybrid_tmp_206);

	// Rdd = ((Rdd & (~(0xffffffff << 0x20))) | ((((sextract64(((ut64) (((st64) ((st32) ((st16) ((Rs >> 0x10) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x0) & 0xffff)))) << 0x0) - (((st64) ((st32) ((st16) ((Rs >> 0x0) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x10) & 0xffff)))) << 0x0)), 0x0, 0x20) == (((st64) ((st32) ((st16) ((Rs >> 0x10) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x0) & 0xffff)))) << 0x0) - (((st64) ((st32) ((st16) ((Rs >> 0x0) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x10) & 0xffff)))) << 0x0)) ? (((st64) ((st32) ((st16) ((Rs >> 0x10) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x0) & 0xffff)))) << 0x0) - (((st64) ((st32) ((st16) ((Rs >> 0x0) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x10) & 0xffff)))) << 0x0) : h_tmp252) & 0xffffffff) << 0x20));
	RzILOpPure *op_LSHIFT_5 = SHIFTL0(SN(64, 0xffffffff), SN(32, 0x20));
	RzILOpPure *op_NOT_6 = LOGNOT(op_LSHIFT_5);
	RzILOpPure *op_AND_7 = LOGAND(READ_REG(pkt, Rdd_op, true), op_NOT_6);
	RzILOpPure *op_RSHIFT_104 = SHIFTRA(DUP(Rs), SN(32, 16));
	RzILOpPure *op_AND_106 = LOGAND(op_RSHIFT_104, SN(32, 0xffff));
	RzILOpPure *op_RSHIFT_112 = SHIFTRA(DUP(Rt), SN(32, 0));
	RzILOpPure *op_AND_114 = LOGAND(op_RSHIFT_112, SN(32, 0xffff));
	RzILOpPure *op_MUL_117 = MUL(CAST(32, MSB(CAST(16, MSB(op_AND_106), DUP(op_AND_106))), CAST(16, MSB(DUP(op_AND_106)), DUP(op_AND_106))), CAST(32, MSB(CAST(16, MSB(op_AND_114), DUP(op_AND_114))), CAST(16, MSB(DUP(op_AND_114)), DUP(op_AND_114))));
	RzILOpPure *op_LSHIFT_120 = SHIFTL0(CAST(64, MSB(op_MUL_117), DUP(op_MUL_117)), SN(32, 0));
	RzILOpPure *op_RSHIFT_124 = SHIFTRA(DUP(Rs), SN(32, 0));
	RzILOpPure *op_AND_126 = LOGAND(op_RSHIFT_124, SN(32, 0xffff));
	RzILOpPure *op_RSHIFT_132 = SHIFTRA(DUP(Rt), SN(32, 16));
	RzILOpPure *op_AND_134 = LOGAND(op_RSHIFT_132, SN(32, 0xffff));
	RzILOpPure *op_MUL_137 = MUL(CAST(32, MSB(CAST(16, MSB(op_AND_126), DUP(op_AND_126))), CAST(16, MSB(DUP(op_AND_126)), DUP(op_AND_126))), CAST(32, MSB(CAST(16, MSB(op_AND_134), DUP(op_AND_134))), CAST(16, MSB(DUP(op_AND_134)), DUP(op_AND_134))));
	RzILOpPure *op_LSHIFT_140 = SHIFTL0(CAST(64, MSB(op_MUL_137), DUP(op_MUL_137)), SN(32, 0));
	RzILOpPure *op_SUB_141 = SUB(op_LSHIFT_120, op_LSHIFT_140);
	RzILOpPure *cond_208 = ITE(DUP(op_EQ_100), op_SUB_141, VARL("h_tmp252"));
	RzILOpPure *op_AND_210 = LOGAND(cond_208, SN(64, 0xffffffff));
	RzILOpPure *op_LSHIFT_214 = SHIFTL0(op_AND_210, SN(32, 0x20));
	RzILOpPure *op_OR_215 = LOGOR(op_AND_7, op_LSHIFT_214);
	RzILOpEffect *op_ASSIGN_216 = WRITE_REG(bundle, Rdd_op, op_OR_215);

	// seq(seq(HYB(gcc_expr_if ((sextract64(((ut64) (((st64) ((st32) (( ...;
	RzILOpEffect *seq_217 = SEQN(2, seq_207, op_ASSIGN_216);

	// set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, ((ut32) 0x1));
	RzILOpEffect *set_usr_field_call_360 = hex_set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, CAST(32, IL_FALSE, SN(32, 1)));

	// HYB(gcc_expr_if ((sextract64(((ut64) (((st64) ((st32) ((st16) ((Rs >> 0x0) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x0) & 0xffff)))) << 0x0) + (((st64) ((st32) ((st16) ((Rs >> 0x10) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x10) & 0xffff)))) << 0x0)), 0x0, 0x20) == (((st64) ((st32) ((st16) ((Rs >> 0x0) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x0) & 0xffff)))) << 0x0) + (((st64) ((st32) ((st16) ((Rs >> 0x10) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x10) & 0xffff)))) << 0x0))) {{}} else {set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, ((ut32) 0x1))}, (((((st64) ((st32) ((st16) ((Rs >> 0x0) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x0) & 0xffff)))) << 0x0) + (((st64) ((st32) ((st16) ((Rs >> 0x10) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x10) & 0xffff)))) << 0x0) < ((st64) 0x0)) ? (-(0x1 << 0x1f)) : (0x1 << 0x1f) - ((st64) 0x1)));
	RzILOpPure *op_RSHIFT_232 = SHIFTRA(DUP(Rs), SN(32, 0));
	RzILOpPure *op_AND_234 = LOGAND(op_RSHIFT_232, SN(32, 0xffff));
	RzILOpPure *op_RSHIFT_240 = SHIFTRA(DUP(Rt), SN(32, 0));
	RzILOpPure *op_AND_242 = LOGAND(op_RSHIFT_240, SN(32, 0xffff));
	RzILOpPure *op_MUL_245 = MUL(CAST(32, MSB(CAST(16, MSB(op_AND_234), DUP(op_AND_234))), CAST(16, MSB(DUP(op_AND_234)), DUP(op_AND_234))), CAST(32, MSB(CAST(16, MSB(op_AND_242), DUP(op_AND_242))), CAST(16, MSB(DUP(op_AND_242)), DUP(op_AND_242))));
	RzILOpPure *op_LSHIFT_248 = SHIFTL0(CAST(64, MSB(op_MUL_245), DUP(op_MUL_245)), SN(32, 0));
	RzILOpPure *op_RSHIFT_252 = SHIFTRA(DUP(Rs), SN(32, 16));
	RzILOpPure *op_AND_254 = LOGAND(op_RSHIFT_252, SN(32, 0xffff));
	RzILOpPure *op_RSHIFT_260 = SHIFTRA(DUP(Rt), SN(32, 16));
	RzILOpPure *op_AND_262 = LOGAND(op_RSHIFT_260, SN(32, 0xffff));
	RzILOpPure *op_MUL_265 = MUL(CAST(32, MSB(CAST(16, MSB(op_AND_254), DUP(op_AND_254))), CAST(16, MSB(DUP(op_AND_254)), DUP(op_AND_254))), CAST(32, MSB(CAST(16, MSB(op_AND_262), DUP(op_AND_262))), CAST(16, MSB(DUP(op_AND_262)), DUP(op_AND_262))));
	RzILOpPure *op_LSHIFT_268 = SHIFTL0(CAST(64, MSB(op_MUL_265), DUP(op_MUL_265)), SN(32, 0));
	RzILOpPure *op_ADD_269 = ADD(op_LSHIFT_248, op_LSHIFT_268);
	RzILOpPure *op_RSHIFT_278 = SHIFTRA(DUP(Rs), SN(32, 0));
	RzILOpPure *op_AND_280 = LOGAND(op_RSHIFT_278, SN(32, 0xffff));
	RzILOpPure *op_RSHIFT_286 = SHIFTRA(DUP(Rt), SN(32, 0));
	RzILOpPure *op_AND_288 = LOGAND(op_RSHIFT_286, SN(32, 0xffff));
	RzILOpPure *op_MUL_291 = MUL(CAST(32, MSB(CAST(16, MSB(op_AND_280), DUP(op_AND_280))), CAST(16, MSB(DUP(op_AND_280)), DUP(op_AND_280))), CAST(32, MSB(CAST(16, MSB(op_AND_288), DUP(op_AND_288))), CAST(16, MSB(DUP(op_AND_288)), DUP(op_AND_288))));
	RzILOpPure *op_LSHIFT_294 = SHIFTL0(CAST(64, MSB(op_MUL_291), DUP(op_MUL_291)), SN(32, 0));
	RzILOpPure *op_RSHIFT_298 = SHIFTRA(DUP(Rs), SN(32, 16));
	RzILOpPure *op_AND_300 = LOGAND(op_RSHIFT_298, SN(32, 0xffff));
	RzILOpPure *op_RSHIFT_306 = SHIFTRA(DUP(Rt), SN(32, 16));
	RzILOpPure *op_AND_308 = LOGAND(op_RSHIFT_306, SN(32, 0xffff));
	RzILOpPure *op_MUL_311 = MUL(CAST(32, MSB(CAST(16, MSB(op_AND_300), DUP(op_AND_300))), CAST(16, MSB(DUP(op_AND_300)), DUP(op_AND_300))), CAST(32, MSB(CAST(16, MSB(op_AND_308), DUP(op_AND_308))), CAST(16, MSB(DUP(op_AND_308)), DUP(op_AND_308))));
	RzILOpPure *op_LSHIFT_314 = SHIFTL0(CAST(64, MSB(op_MUL_311), DUP(op_MUL_311)), SN(32, 0));
	RzILOpPure *op_ADD_315 = ADD(op_LSHIFT_294, op_LSHIFT_314);
	RzILOpPure *op_EQ_316 = EQ(SEXTRACT64(CAST(64, IL_FALSE, op_ADD_269), SN(32, 0), SN(32, 0x20)), op_ADD_315);
	RzILOpPure *op_RSHIFT_364 = SHIFTRA(DUP(Rs), SN(32, 0));
	RzILOpPure *op_AND_366 = LOGAND(op_RSHIFT_364, SN(32, 0xffff));
	RzILOpPure *op_RSHIFT_372 = SHIFTRA(DUP(Rt), SN(32, 0));
	RzILOpPure *op_AND_374 = LOGAND(op_RSHIFT_372, SN(32, 0xffff));
	RzILOpPure *op_MUL_377 = MUL(CAST(32, MSB(CAST(16, MSB(op_AND_366), DUP(op_AND_366))), CAST(16, MSB(DUP(op_AND_366)), DUP(op_AND_366))), CAST(32, MSB(CAST(16, MSB(op_AND_374), DUP(op_AND_374))), CAST(16, MSB(DUP(op_AND_374)), DUP(op_AND_374))));
	RzILOpPure *op_LSHIFT_380 = SHIFTL0(CAST(64, MSB(op_MUL_377), DUP(op_MUL_377)), SN(32, 0));
	RzILOpPure *op_RSHIFT_384 = SHIFTRA(DUP(Rs), SN(32, 16));
	RzILOpPure *op_AND_386 = LOGAND(op_RSHIFT_384, SN(32, 0xffff));
	RzILOpPure *op_RSHIFT_392 = SHIFTRA(DUP(Rt), SN(32, 16));
	RzILOpPure *op_AND_394 = LOGAND(op_RSHIFT_392, SN(32, 0xffff));
	RzILOpPure *op_MUL_397 = MUL(CAST(32, MSB(CAST(16, MSB(op_AND_386), DUP(op_AND_386))), CAST(16, MSB(DUP(op_AND_386)), DUP(op_AND_386))), CAST(32, MSB(CAST(16, MSB(op_AND_394), DUP(op_AND_394))), CAST(16, MSB(DUP(op_AND_394)), DUP(op_AND_394))));
	RzILOpPure *op_LSHIFT_400 = SHIFTL0(CAST(64, MSB(op_MUL_397), DUP(op_MUL_397)), SN(32, 0));
	RzILOpPure *op_ADD_401 = ADD(op_LSHIFT_380, op_LSHIFT_400);
	RzILOpPure *op_LT_404 = SLT(op_ADD_401, CAST(64, MSB(SN(32, 0)), SN(32, 0)));
	RzILOpPure *op_LSHIFT_409 = SHIFTL0(SN(64, 1), SN(32, 31));
	RzILOpPure *op_NEG_410 = NEG(op_LSHIFT_409);
	RzILOpPure *op_LSHIFT_415 = SHIFTL0(SN(64, 1), SN(32, 31));
	RzILOpPure *op_SUB_418 = SUB(op_LSHIFT_415, CAST(64, MSB(SN(32, 1)), SN(32, 1)));
	RzILOpPure *cond_419 = ITE(op_LT_404, op_NEG_410, op_SUB_418);
	RzILOpEffect *gcc_expr_420 = BRANCH(op_EQ_316, EMPTY(), set_usr_field_call_360);

	// h_tmp253 = HYB(gcc_expr_if ((sextract64(((ut64) (((st64) ((st32) ((st16) ((Rs >> 0x0) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x0) & 0xffff)))) << 0x0) + (((st64) ((st32) ((st16) ((Rs >> 0x10) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x10) & 0xffff)))) << 0x0)), 0x0, 0x20) == (((st64) ((st32) ((st16) ((Rs >> 0x0) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x0) & 0xffff)))) << 0x0) + (((st64) ((st32) ((st16) ((Rs >> 0x10) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x10) & 0xffff)))) << 0x0))) {{}} else {set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, ((ut32) 0x1))}, (((((st64) ((st32) ((st16) ((Rs >> 0x0) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x0) & 0xffff)))) << 0x0) + (((st64) ((st32) ((st16) ((Rs >> 0x10) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x10) & 0xffff)))) << 0x0) < ((st64) 0x0)) ? (-(0x1 << 0x1f)) : (0x1 << 0x1f) - ((st64) 0x1)));
	RzILOpEffect *op_ASSIGN_hybrid_tmp_422 = SETL("h_tmp253", cond_419);

	// seq(HYB(gcc_expr_if ((sextract64(((ut64) (((st64) ((st32) ((st16 ...;
	RzILOpEffect *seq_423 = SEQN(2, gcc_expr_420, op_ASSIGN_hybrid_tmp_422);

	// Rdd = ((Rdd & (~(0xffffffff << 0x0))) | ((((sextract64(((ut64) (((st64) ((st32) ((st16) ((Rs >> 0x0) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x0) & 0xffff)))) << 0x0) + (((st64) ((st32) ((st16) ((Rs >> 0x10) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x10) & 0xffff)))) << 0x0)), 0x0, 0x20) == (((st64) ((st32) ((st16) ((Rs >> 0x0) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x0) & 0xffff)))) << 0x0) + (((st64) ((st32) ((st16) ((Rs >> 0x10) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x10) & 0xffff)))) << 0x0)) ? (((st64) ((st32) ((st16) ((Rs >> 0x0) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x0) & 0xffff)))) << 0x0) + (((st64) ((st32) ((st16) ((Rs >> 0x10) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x10) & 0xffff)))) << 0x0) : h_tmp253) & 0xffffffff) << 0x0));
	RzILOpPure *op_LSHIFT_223 = SHIFTL0(SN(64, 0xffffffff), SN(32, 0));
	RzILOpPure *op_NOT_224 = LOGNOT(op_LSHIFT_223);
	RzILOpPure *op_AND_225 = LOGAND(READ_REG(pkt, Rdd_op, true), op_NOT_224);
	RzILOpPure *op_RSHIFT_320 = SHIFTRA(DUP(Rs), SN(32, 0));
	RzILOpPure *op_AND_322 = LOGAND(op_RSHIFT_320, SN(32, 0xffff));
	RzILOpPure *op_RSHIFT_328 = SHIFTRA(DUP(Rt), SN(32, 0));
	RzILOpPure *op_AND_330 = LOGAND(op_RSHIFT_328, SN(32, 0xffff));
	RzILOpPure *op_MUL_333 = MUL(CAST(32, MSB(CAST(16, MSB(op_AND_322), DUP(op_AND_322))), CAST(16, MSB(DUP(op_AND_322)), DUP(op_AND_322))), CAST(32, MSB(CAST(16, MSB(op_AND_330), DUP(op_AND_330))), CAST(16, MSB(DUP(op_AND_330)), DUP(op_AND_330))));
	RzILOpPure *op_LSHIFT_336 = SHIFTL0(CAST(64, MSB(op_MUL_333), DUP(op_MUL_333)), SN(32, 0));
	RzILOpPure *op_RSHIFT_340 = SHIFTRA(DUP(Rs), SN(32, 16));
	RzILOpPure *op_AND_342 = LOGAND(op_RSHIFT_340, SN(32, 0xffff));
	RzILOpPure *op_RSHIFT_348 = SHIFTRA(DUP(Rt), SN(32, 16));
	RzILOpPure *op_AND_350 = LOGAND(op_RSHIFT_348, SN(32, 0xffff));
	RzILOpPure *op_MUL_353 = MUL(CAST(32, MSB(CAST(16, MSB(op_AND_342), DUP(op_AND_342))), CAST(16, MSB(DUP(op_AND_342)), DUP(op_AND_342))), CAST(32, MSB(CAST(16, MSB(op_AND_350), DUP(op_AND_350))), CAST(16, MSB(DUP(op_AND_350)), DUP(op_AND_350))));
	RzILOpPure *op_LSHIFT_356 = SHIFTL0(CAST(64, MSB(op_MUL_353), DUP(op_MUL_353)), SN(32, 0));
	RzILOpPure *op_ADD_357 = ADD(op_LSHIFT_336, op_LSHIFT_356);
	RzILOpPure *cond_424 = ITE(DUP(op_EQ_316), op_ADD_357, VARL("h_tmp253"));
	RzILOpPure *op_AND_426 = LOGAND(cond_424, SN(64, 0xffffffff));
	RzILOpPure *op_LSHIFT_430 = SHIFTL0(op_AND_426, SN(32, 0));
	RzILOpPure *op_OR_431 = LOGOR(op_AND_225, op_LSHIFT_430);
	RzILOpEffect *op_ASSIGN_432 = WRITE_REG(bundle, Rdd_op, op_OR_431);

	// seq(seq(HYB(gcc_expr_if ((sextract64(((ut64) (((st64) ((st32) (( ...;
	RzILOpEffect *seq_433 = SEQN(2, seq_423, op_ASSIGN_432);

	RzILOpEffect *instruction_sequence = SEQN(2, seq_217, seq_433);
	return instruction_sequence;
}

// Rdd = cmpy(Rs,Rt*):<<1:sat
RzILOpEffect *hex_il_op_m2_cmpysc_s1(HexInsnPktBundle *bundle) {
	const HexInsn *hi = bundle->insn;
	HexPkt *pkt = bundle->pkt;
	// READ
	const HexOp *Rdd_op = ISA2REG(hi, 'd', false);
	const HexOp *Rs_op = ISA2REG(hi, 's', false);
	RzILOpPure *Rs = READ_REG(pkt, Rs_op, false);
	const HexOp *Rt_op = ISA2REG(hi, 't', false);
	RzILOpPure *Rt = READ_REG(pkt, Rt_op, false);

	// set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, ((ut32) 0x1));
	RzILOpEffect *set_usr_field_call_144 = hex_set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, CAST(32, IL_FALSE, SN(32, 1)));

	// HYB(gcc_expr_if ((sextract64(((ut64) (((st64) ((st32) ((st16) ((Rs >> 0x10) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x0) & 0xffff)))) << 0x1) - (((st64) ((st32) ((st16) ((Rs >> 0x0) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x10) & 0xffff)))) << 0x1)), 0x0, 0x20) == (((st64) ((st32) ((st16) ((Rs >> 0x10) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x0) & 0xffff)))) << 0x1) - (((st64) ((st32) ((st16) ((Rs >> 0x0) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x10) & 0xffff)))) << 0x1))) {{}} else {set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, ((ut32) 0x1))}, (((((st64) ((st32) ((st16) ((Rs >> 0x10) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x0) & 0xffff)))) << 0x1) - (((st64) ((st32) ((st16) ((Rs >> 0x0) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x10) & 0xffff)))) << 0x1) < ((st64) 0x0)) ? (-(0x1 << 0x1f)) : (0x1 << 0x1f) - ((st64) 0x1)));
	RzILOpPure *op_RSHIFT_15 = SHIFTRA(Rs, SN(32, 16));
	RzILOpPure *op_AND_17 = LOGAND(op_RSHIFT_15, SN(32, 0xffff));
	RzILOpPure *op_RSHIFT_24 = SHIFTRA(Rt, SN(32, 0));
	RzILOpPure *op_AND_26 = LOGAND(op_RSHIFT_24, SN(32, 0xffff));
	RzILOpPure *op_MUL_29 = MUL(CAST(32, MSB(CAST(16, MSB(op_AND_17), DUP(op_AND_17))), CAST(16, MSB(DUP(op_AND_17)), DUP(op_AND_17))), CAST(32, MSB(CAST(16, MSB(op_AND_26), DUP(op_AND_26))), CAST(16, MSB(DUP(op_AND_26)), DUP(op_AND_26))));
	RzILOpPure *op_LSHIFT_32 = SHIFTL0(CAST(64, MSB(op_MUL_29), DUP(op_MUL_29)), SN(32, 1));
	RzILOpPure *op_RSHIFT_36 = SHIFTRA(DUP(Rs), SN(32, 0));
	RzILOpPure *op_AND_38 = LOGAND(op_RSHIFT_36, SN(32, 0xffff));
	RzILOpPure *op_RSHIFT_44 = SHIFTRA(DUP(Rt), SN(32, 16));
	RzILOpPure *op_AND_46 = LOGAND(op_RSHIFT_44, SN(32, 0xffff));
	RzILOpPure *op_MUL_49 = MUL(CAST(32, MSB(CAST(16, MSB(op_AND_38), DUP(op_AND_38))), CAST(16, MSB(DUP(op_AND_38)), DUP(op_AND_38))), CAST(32, MSB(CAST(16, MSB(op_AND_46), DUP(op_AND_46))), CAST(16, MSB(DUP(op_AND_46)), DUP(op_AND_46))));
	RzILOpPure *op_LSHIFT_52 = SHIFTL0(CAST(64, MSB(op_MUL_49), DUP(op_MUL_49)), SN(32, 1));
	RzILOpPure *op_SUB_53 = SUB(op_LSHIFT_32, op_LSHIFT_52);
	RzILOpPure *op_RSHIFT_62 = SHIFTRA(DUP(Rs), SN(32, 16));
	RzILOpPure *op_AND_64 = LOGAND(op_RSHIFT_62, SN(32, 0xffff));
	RzILOpPure *op_RSHIFT_70 = SHIFTRA(DUP(Rt), SN(32, 0));
	RzILOpPure *op_AND_72 = LOGAND(op_RSHIFT_70, SN(32, 0xffff));
	RzILOpPure *op_MUL_75 = MUL(CAST(32, MSB(CAST(16, MSB(op_AND_64), DUP(op_AND_64))), CAST(16, MSB(DUP(op_AND_64)), DUP(op_AND_64))), CAST(32, MSB(CAST(16, MSB(op_AND_72), DUP(op_AND_72))), CAST(16, MSB(DUP(op_AND_72)), DUP(op_AND_72))));
	RzILOpPure *op_LSHIFT_78 = SHIFTL0(CAST(64, MSB(op_MUL_75), DUP(op_MUL_75)), SN(32, 1));
	RzILOpPure *op_RSHIFT_82 = SHIFTRA(DUP(Rs), SN(32, 0));
	RzILOpPure *op_AND_84 = LOGAND(op_RSHIFT_82, SN(32, 0xffff));
	RzILOpPure *op_RSHIFT_90 = SHIFTRA(DUP(Rt), SN(32, 16));
	RzILOpPure *op_AND_92 = LOGAND(op_RSHIFT_90, SN(32, 0xffff));
	RzILOpPure *op_MUL_95 = MUL(CAST(32, MSB(CAST(16, MSB(op_AND_84), DUP(op_AND_84))), CAST(16, MSB(DUP(op_AND_84)), DUP(op_AND_84))), CAST(32, MSB(CAST(16, MSB(op_AND_92), DUP(op_AND_92))), CAST(16, MSB(DUP(op_AND_92)), DUP(op_AND_92))));
	RzILOpPure *op_LSHIFT_98 = SHIFTL0(CAST(64, MSB(op_MUL_95), DUP(op_MUL_95)), SN(32, 1));
	RzILOpPure *op_SUB_99 = SUB(op_LSHIFT_78, op_LSHIFT_98);
	RzILOpPure *op_EQ_100 = EQ(SEXTRACT64(CAST(64, IL_FALSE, op_SUB_53), SN(32, 0), SN(32, 0x20)), op_SUB_99);
	RzILOpPure *op_RSHIFT_148 = SHIFTRA(DUP(Rs), SN(32, 16));
	RzILOpPure *op_AND_150 = LOGAND(op_RSHIFT_148, SN(32, 0xffff));
	RzILOpPure *op_RSHIFT_156 = SHIFTRA(DUP(Rt), SN(32, 0));
	RzILOpPure *op_AND_158 = LOGAND(op_RSHIFT_156, SN(32, 0xffff));
	RzILOpPure *op_MUL_161 = MUL(CAST(32, MSB(CAST(16, MSB(op_AND_150), DUP(op_AND_150))), CAST(16, MSB(DUP(op_AND_150)), DUP(op_AND_150))), CAST(32, MSB(CAST(16, MSB(op_AND_158), DUP(op_AND_158))), CAST(16, MSB(DUP(op_AND_158)), DUP(op_AND_158))));
	RzILOpPure *op_LSHIFT_164 = SHIFTL0(CAST(64, MSB(op_MUL_161), DUP(op_MUL_161)), SN(32, 1));
	RzILOpPure *op_RSHIFT_168 = SHIFTRA(DUP(Rs), SN(32, 0));
	RzILOpPure *op_AND_170 = LOGAND(op_RSHIFT_168, SN(32, 0xffff));
	RzILOpPure *op_RSHIFT_176 = SHIFTRA(DUP(Rt), SN(32, 16));
	RzILOpPure *op_AND_178 = LOGAND(op_RSHIFT_176, SN(32, 0xffff));
	RzILOpPure *op_MUL_181 = MUL(CAST(32, MSB(CAST(16, MSB(op_AND_170), DUP(op_AND_170))), CAST(16, MSB(DUP(op_AND_170)), DUP(op_AND_170))), CAST(32, MSB(CAST(16, MSB(op_AND_178), DUP(op_AND_178))), CAST(16, MSB(DUP(op_AND_178)), DUP(op_AND_178))));
	RzILOpPure *op_LSHIFT_184 = SHIFTL0(CAST(64, MSB(op_MUL_181), DUP(op_MUL_181)), SN(32, 1));
	RzILOpPure *op_SUB_185 = SUB(op_LSHIFT_164, op_LSHIFT_184);
	RzILOpPure *op_LT_188 = SLT(op_SUB_185, CAST(64, MSB(SN(32, 0)), SN(32, 0)));
	RzILOpPure *op_LSHIFT_193 = SHIFTL0(SN(64, 1), SN(32, 31));
	RzILOpPure *op_NEG_194 = NEG(op_LSHIFT_193);
	RzILOpPure *op_LSHIFT_199 = SHIFTL0(SN(64, 1), SN(32, 31));
	RzILOpPure *op_SUB_202 = SUB(op_LSHIFT_199, CAST(64, MSB(SN(32, 1)), SN(32, 1)));
	RzILOpPure *cond_203 = ITE(op_LT_188, op_NEG_194, op_SUB_202);
	RzILOpEffect *gcc_expr_204 = BRANCH(op_EQ_100, EMPTY(), set_usr_field_call_144);

	// h_tmp254 = HYB(gcc_expr_if ((sextract64(((ut64) (((st64) ((st32) ((st16) ((Rs >> 0x10) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x0) & 0xffff)))) << 0x1) - (((st64) ((st32) ((st16) ((Rs >> 0x0) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x10) & 0xffff)))) << 0x1)), 0x0, 0x20) == (((st64) ((st32) ((st16) ((Rs >> 0x10) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x0) & 0xffff)))) << 0x1) - (((st64) ((st32) ((st16) ((Rs >> 0x0) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x10) & 0xffff)))) << 0x1))) {{}} else {set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, ((ut32) 0x1))}, (((((st64) ((st32) ((st16) ((Rs >> 0x10) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x0) & 0xffff)))) << 0x1) - (((st64) ((st32) ((st16) ((Rs >> 0x0) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x10) & 0xffff)))) << 0x1) < ((st64) 0x0)) ? (-(0x1 << 0x1f)) : (0x1 << 0x1f) - ((st64) 0x1)));
	RzILOpEffect *op_ASSIGN_hybrid_tmp_206 = SETL("h_tmp254", cond_203);

	// seq(HYB(gcc_expr_if ((sextract64(((ut64) (((st64) ((st32) ((st16 ...;
	RzILOpEffect *seq_207 = SEQN(2, gcc_expr_204, op_ASSIGN_hybrid_tmp_206);

	// Rdd = ((Rdd & (~(0xffffffff << 0x20))) | ((((sextract64(((ut64) (((st64) ((st32) ((st16) ((Rs >> 0x10) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x0) & 0xffff)))) << 0x1) - (((st64) ((st32) ((st16) ((Rs >> 0x0) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x10) & 0xffff)))) << 0x1)), 0x0, 0x20) == (((st64) ((st32) ((st16) ((Rs >> 0x10) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x0) & 0xffff)))) << 0x1) - (((st64) ((st32) ((st16) ((Rs >> 0x0) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x10) & 0xffff)))) << 0x1)) ? (((st64) ((st32) ((st16) ((Rs >> 0x10) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x0) & 0xffff)))) << 0x1) - (((st64) ((st32) ((st16) ((Rs >> 0x0) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x10) & 0xffff)))) << 0x1) : h_tmp254) & 0xffffffff) << 0x20));
	RzILOpPure *op_LSHIFT_5 = SHIFTL0(SN(64, 0xffffffff), SN(32, 0x20));
	RzILOpPure *op_NOT_6 = LOGNOT(op_LSHIFT_5);
	RzILOpPure *op_AND_7 = LOGAND(READ_REG(pkt, Rdd_op, true), op_NOT_6);
	RzILOpPure *op_RSHIFT_104 = SHIFTRA(DUP(Rs), SN(32, 16));
	RzILOpPure *op_AND_106 = LOGAND(op_RSHIFT_104, SN(32, 0xffff));
	RzILOpPure *op_RSHIFT_112 = SHIFTRA(DUP(Rt), SN(32, 0));
	RzILOpPure *op_AND_114 = LOGAND(op_RSHIFT_112, SN(32, 0xffff));
	RzILOpPure *op_MUL_117 = MUL(CAST(32, MSB(CAST(16, MSB(op_AND_106), DUP(op_AND_106))), CAST(16, MSB(DUP(op_AND_106)), DUP(op_AND_106))), CAST(32, MSB(CAST(16, MSB(op_AND_114), DUP(op_AND_114))), CAST(16, MSB(DUP(op_AND_114)), DUP(op_AND_114))));
	RzILOpPure *op_LSHIFT_120 = SHIFTL0(CAST(64, MSB(op_MUL_117), DUP(op_MUL_117)), SN(32, 1));
	RzILOpPure *op_RSHIFT_124 = SHIFTRA(DUP(Rs), SN(32, 0));
	RzILOpPure *op_AND_126 = LOGAND(op_RSHIFT_124, SN(32, 0xffff));
	RzILOpPure *op_RSHIFT_132 = SHIFTRA(DUP(Rt), SN(32, 16));
	RzILOpPure *op_AND_134 = LOGAND(op_RSHIFT_132, SN(32, 0xffff));
	RzILOpPure *op_MUL_137 = MUL(CAST(32, MSB(CAST(16, MSB(op_AND_126), DUP(op_AND_126))), CAST(16, MSB(DUP(op_AND_126)), DUP(op_AND_126))), CAST(32, MSB(CAST(16, MSB(op_AND_134), DUP(op_AND_134))), CAST(16, MSB(DUP(op_AND_134)), DUP(op_AND_134))));
	RzILOpPure *op_LSHIFT_140 = SHIFTL0(CAST(64, MSB(op_MUL_137), DUP(op_MUL_137)), SN(32, 1));
	RzILOpPure *op_SUB_141 = SUB(op_LSHIFT_120, op_LSHIFT_140);
	RzILOpPure *cond_208 = ITE(DUP(op_EQ_100), op_SUB_141, VARL("h_tmp254"));
	RzILOpPure *op_AND_210 = LOGAND(cond_208, SN(64, 0xffffffff));
	RzILOpPure *op_LSHIFT_214 = SHIFTL0(op_AND_210, SN(32, 0x20));
	RzILOpPure *op_OR_215 = LOGOR(op_AND_7, op_LSHIFT_214);
	RzILOpEffect *op_ASSIGN_216 = WRITE_REG(bundle, Rdd_op, op_OR_215);

	// seq(seq(HYB(gcc_expr_if ((sextract64(((ut64) (((st64) ((st32) (( ...;
	RzILOpEffect *seq_217 = SEQN(2, seq_207, op_ASSIGN_216);

	// set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, ((ut32) 0x1));
	RzILOpEffect *set_usr_field_call_360 = hex_set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, CAST(32, IL_FALSE, SN(32, 1)));

	// HYB(gcc_expr_if ((sextract64(((ut64) (((st64) ((st32) ((st16) ((Rs >> 0x0) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x0) & 0xffff)))) << 0x1) + (((st64) ((st32) ((st16) ((Rs >> 0x10) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x10) & 0xffff)))) << 0x1)), 0x0, 0x20) == (((st64) ((st32) ((st16) ((Rs >> 0x0) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x0) & 0xffff)))) << 0x1) + (((st64) ((st32) ((st16) ((Rs >> 0x10) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x10) & 0xffff)))) << 0x1))) {{}} else {set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, ((ut32) 0x1))}, (((((st64) ((st32) ((st16) ((Rs >> 0x0) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x0) & 0xffff)))) << 0x1) + (((st64) ((st32) ((st16) ((Rs >> 0x10) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x10) & 0xffff)))) << 0x1) < ((st64) 0x0)) ? (-(0x1 << 0x1f)) : (0x1 << 0x1f) - ((st64) 0x1)));
	RzILOpPure *op_RSHIFT_232 = SHIFTRA(DUP(Rs), SN(32, 0));
	RzILOpPure *op_AND_234 = LOGAND(op_RSHIFT_232, SN(32, 0xffff));
	RzILOpPure *op_RSHIFT_240 = SHIFTRA(DUP(Rt), SN(32, 0));
	RzILOpPure *op_AND_242 = LOGAND(op_RSHIFT_240, SN(32, 0xffff));
	RzILOpPure *op_MUL_245 = MUL(CAST(32, MSB(CAST(16, MSB(op_AND_234), DUP(op_AND_234))), CAST(16, MSB(DUP(op_AND_234)), DUP(op_AND_234))), CAST(32, MSB(CAST(16, MSB(op_AND_242), DUP(op_AND_242))), CAST(16, MSB(DUP(op_AND_242)), DUP(op_AND_242))));
	RzILOpPure *op_LSHIFT_248 = SHIFTL0(CAST(64, MSB(op_MUL_245), DUP(op_MUL_245)), SN(32, 1));
	RzILOpPure *op_RSHIFT_252 = SHIFTRA(DUP(Rs), SN(32, 16));
	RzILOpPure *op_AND_254 = LOGAND(op_RSHIFT_252, SN(32, 0xffff));
	RzILOpPure *op_RSHIFT_260 = SHIFTRA(DUP(Rt), SN(32, 16));
	RzILOpPure *op_AND_262 = LOGAND(op_RSHIFT_260, SN(32, 0xffff));
	RzILOpPure *op_MUL_265 = MUL(CAST(32, MSB(CAST(16, MSB(op_AND_254), DUP(op_AND_254))), CAST(16, MSB(DUP(op_AND_254)), DUP(op_AND_254))), CAST(32, MSB(CAST(16, MSB(op_AND_262), DUP(op_AND_262))), CAST(16, MSB(DUP(op_AND_262)), DUP(op_AND_262))));
	RzILOpPure *op_LSHIFT_268 = SHIFTL0(CAST(64, MSB(op_MUL_265), DUP(op_MUL_265)), SN(32, 1));
	RzILOpPure *op_ADD_269 = ADD(op_LSHIFT_248, op_LSHIFT_268);
	RzILOpPure *op_RSHIFT_278 = SHIFTRA(DUP(Rs), SN(32, 0));
	RzILOpPure *op_AND_280 = LOGAND(op_RSHIFT_278, SN(32, 0xffff));
	RzILOpPure *op_RSHIFT_286 = SHIFTRA(DUP(Rt), SN(32, 0));
	RzILOpPure *op_AND_288 = LOGAND(op_RSHIFT_286, SN(32, 0xffff));
	RzILOpPure *op_MUL_291 = MUL(CAST(32, MSB(CAST(16, MSB(op_AND_280), DUP(op_AND_280))), CAST(16, MSB(DUP(op_AND_280)), DUP(op_AND_280))), CAST(32, MSB(CAST(16, MSB(op_AND_288), DUP(op_AND_288))), CAST(16, MSB(DUP(op_AND_288)), DUP(op_AND_288))));
	RzILOpPure *op_LSHIFT_294 = SHIFTL0(CAST(64, MSB(op_MUL_291), DUP(op_MUL_291)), SN(32, 1));
	RzILOpPure *op_RSHIFT_298 = SHIFTRA(DUP(Rs), SN(32, 16));
	RzILOpPure *op_AND_300 = LOGAND(op_RSHIFT_298, SN(32, 0xffff));
	RzILOpPure *op_RSHIFT_306 = SHIFTRA(DUP(Rt), SN(32, 16));
	RzILOpPure *op_AND_308 = LOGAND(op_RSHIFT_306, SN(32, 0xffff));
	RzILOpPure *op_MUL_311 = MUL(CAST(32, MSB(CAST(16, MSB(op_AND_300), DUP(op_AND_300))), CAST(16, MSB(DUP(op_AND_300)), DUP(op_AND_300))), CAST(32, MSB(CAST(16, MSB(op_AND_308), DUP(op_AND_308))), CAST(16, MSB(DUP(op_AND_308)), DUP(op_AND_308))));
	RzILOpPure *op_LSHIFT_314 = SHIFTL0(CAST(64, MSB(op_MUL_311), DUP(op_MUL_311)), SN(32, 1));
	RzILOpPure *op_ADD_315 = ADD(op_LSHIFT_294, op_LSHIFT_314);
	RzILOpPure *op_EQ_316 = EQ(SEXTRACT64(CAST(64, IL_FALSE, op_ADD_269), SN(32, 0), SN(32, 0x20)), op_ADD_315);
	RzILOpPure *op_RSHIFT_364 = SHIFTRA(DUP(Rs), SN(32, 0));
	RzILOpPure *op_AND_366 = LOGAND(op_RSHIFT_364, SN(32, 0xffff));
	RzILOpPure *op_RSHIFT_372 = SHIFTRA(DUP(Rt), SN(32, 0));
	RzILOpPure *op_AND_374 = LOGAND(op_RSHIFT_372, SN(32, 0xffff));
	RzILOpPure *op_MUL_377 = MUL(CAST(32, MSB(CAST(16, MSB(op_AND_366), DUP(op_AND_366))), CAST(16, MSB(DUP(op_AND_366)), DUP(op_AND_366))), CAST(32, MSB(CAST(16, MSB(op_AND_374), DUP(op_AND_374))), CAST(16, MSB(DUP(op_AND_374)), DUP(op_AND_374))));
	RzILOpPure *op_LSHIFT_380 = SHIFTL0(CAST(64, MSB(op_MUL_377), DUP(op_MUL_377)), SN(32, 1));
	RzILOpPure *op_RSHIFT_384 = SHIFTRA(DUP(Rs), SN(32, 16));
	RzILOpPure *op_AND_386 = LOGAND(op_RSHIFT_384, SN(32, 0xffff));
	RzILOpPure *op_RSHIFT_392 = SHIFTRA(DUP(Rt), SN(32, 16));
	RzILOpPure *op_AND_394 = LOGAND(op_RSHIFT_392, SN(32, 0xffff));
	RzILOpPure *op_MUL_397 = MUL(CAST(32, MSB(CAST(16, MSB(op_AND_386), DUP(op_AND_386))), CAST(16, MSB(DUP(op_AND_386)), DUP(op_AND_386))), CAST(32, MSB(CAST(16, MSB(op_AND_394), DUP(op_AND_394))), CAST(16, MSB(DUP(op_AND_394)), DUP(op_AND_394))));
	RzILOpPure *op_LSHIFT_400 = SHIFTL0(CAST(64, MSB(op_MUL_397), DUP(op_MUL_397)), SN(32, 1));
	RzILOpPure *op_ADD_401 = ADD(op_LSHIFT_380, op_LSHIFT_400);
	RzILOpPure *op_LT_404 = SLT(op_ADD_401, CAST(64, MSB(SN(32, 0)), SN(32, 0)));
	RzILOpPure *op_LSHIFT_409 = SHIFTL0(SN(64, 1), SN(32, 31));
	RzILOpPure *op_NEG_410 = NEG(op_LSHIFT_409);
	RzILOpPure *op_LSHIFT_415 = SHIFTL0(SN(64, 1), SN(32, 31));
	RzILOpPure *op_SUB_418 = SUB(op_LSHIFT_415, CAST(64, MSB(SN(32, 1)), SN(32, 1)));
	RzILOpPure *cond_419 = ITE(op_LT_404, op_NEG_410, op_SUB_418);
	RzILOpEffect *gcc_expr_420 = BRANCH(op_EQ_316, EMPTY(), set_usr_field_call_360);

	// h_tmp255 = HYB(gcc_expr_if ((sextract64(((ut64) (((st64) ((st32) ((st16) ((Rs >> 0x0) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x0) & 0xffff)))) << 0x1) + (((st64) ((st32) ((st16) ((Rs >> 0x10) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x10) & 0xffff)))) << 0x1)), 0x0, 0x20) == (((st64) ((st32) ((st16) ((Rs >> 0x0) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x0) & 0xffff)))) << 0x1) + (((st64) ((st32) ((st16) ((Rs >> 0x10) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x10) & 0xffff)))) << 0x1))) {{}} else {set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, ((ut32) 0x1))}, (((((st64) ((st32) ((st16) ((Rs >> 0x0) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x0) & 0xffff)))) << 0x1) + (((st64) ((st32) ((st16) ((Rs >> 0x10) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x10) & 0xffff)))) << 0x1) < ((st64) 0x0)) ? (-(0x1 << 0x1f)) : (0x1 << 0x1f) - ((st64) 0x1)));
	RzILOpEffect *op_ASSIGN_hybrid_tmp_422 = SETL("h_tmp255", cond_419);

	// seq(HYB(gcc_expr_if ((sextract64(((ut64) (((st64) ((st32) ((st16 ...;
	RzILOpEffect *seq_423 = SEQN(2, gcc_expr_420, op_ASSIGN_hybrid_tmp_422);

	// Rdd = ((Rdd & (~(0xffffffff << 0x0))) | ((((sextract64(((ut64) (((st64) ((st32) ((st16) ((Rs >> 0x0) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x0) & 0xffff)))) << 0x1) + (((st64) ((st32) ((st16) ((Rs >> 0x10) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x10) & 0xffff)))) << 0x1)), 0x0, 0x20) == (((st64) ((st32) ((st16) ((Rs >> 0x0) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x0) & 0xffff)))) << 0x1) + (((st64) ((st32) ((st16) ((Rs >> 0x10) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x10) & 0xffff)))) << 0x1)) ? (((st64) ((st32) ((st16) ((Rs >> 0x0) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x0) & 0xffff)))) << 0x1) + (((st64) ((st32) ((st16) ((Rs >> 0x10) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x10) & 0xffff)))) << 0x1) : h_tmp255) & 0xffffffff) << 0x0));
	RzILOpPure *op_LSHIFT_223 = SHIFTL0(SN(64, 0xffffffff), SN(32, 0));
	RzILOpPure *op_NOT_224 = LOGNOT(op_LSHIFT_223);
	RzILOpPure *op_AND_225 = LOGAND(READ_REG(pkt, Rdd_op, true), op_NOT_224);
	RzILOpPure *op_RSHIFT_320 = SHIFTRA(DUP(Rs), SN(32, 0));
	RzILOpPure *op_AND_322 = LOGAND(op_RSHIFT_320, SN(32, 0xffff));
	RzILOpPure *op_RSHIFT_328 = SHIFTRA(DUP(Rt), SN(32, 0));
	RzILOpPure *op_AND_330 = LOGAND(op_RSHIFT_328, SN(32, 0xffff));
	RzILOpPure *op_MUL_333 = MUL(CAST(32, MSB(CAST(16, MSB(op_AND_322), DUP(op_AND_322))), CAST(16, MSB(DUP(op_AND_322)), DUP(op_AND_322))), CAST(32, MSB(CAST(16, MSB(op_AND_330), DUP(op_AND_330))), CAST(16, MSB(DUP(op_AND_330)), DUP(op_AND_330))));
	RzILOpPure *op_LSHIFT_336 = SHIFTL0(CAST(64, MSB(op_MUL_333), DUP(op_MUL_333)), SN(32, 1));
	RzILOpPure *op_RSHIFT_340 = SHIFTRA(DUP(Rs), SN(32, 16));
	RzILOpPure *op_AND_342 = LOGAND(op_RSHIFT_340, SN(32, 0xffff));
	RzILOpPure *op_RSHIFT_348 = SHIFTRA(DUP(Rt), SN(32, 16));
	RzILOpPure *op_AND_350 = LOGAND(op_RSHIFT_348, SN(32, 0xffff));
	RzILOpPure *op_MUL_353 = MUL(CAST(32, MSB(CAST(16, MSB(op_AND_342), DUP(op_AND_342))), CAST(16, MSB(DUP(op_AND_342)), DUP(op_AND_342))), CAST(32, MSB(CAST(16, MSB(op_AND_350), DUP(op_AND_350))), CAST(16, MSB(DUP(op_AND_350)), DUP(op_AND_350))));
	RzILOpPure *op_LSHIFT_356 = SHIFTL0(CAST(64, MSB(op_MUL_353), DUP(op_MUL_353)), SN(32, 1));
	RzILOpPure *op_ADD_357 = ADD(op_LSHIFT_336, op_LSHIFT_356);
	RzILOpPure *cond_424 = ITE(DUP(op_EQ_316), op_ADD_357, VARL("h_tmp255"));
	RzILOpPure *op_AND_426 = LOGAND(cond_424, SN(64, 0xffffffff));
	RzILOpPure *op_LSHIFT_430 = SHIFTL0(op_AND_426, SN(32, 0));
	RzILOpPure *op_OR_431 = LOGOR(op_AND_225, op_LSHIFT_430);
	RzILOpEffect *op_ASSIGN_432 = WRITE_REG(bundle, Rdd_op, op_OR_431);

	// seq(seq(HYB(gcc_expr_if ((sextract64(((ut64) (((st64) ((st32) (( ...;
	RzILOpEffect *seq_433 = SEQN(2, seq_423, op_ASSIGN_432);

	RzILOpEffect *instruction_sequence = SEQN(2, seq_217, seq_433);
	return instruction_sequence;
}

// Rxx -= cmpy(Rs,Rt):sat
RzILOpEffect *hex_il_op_m2_cnacs_s0(HexInsnPktBundle *bundle) {
	const HexInsn *hi = bundle->insn;
	HexPkt *pkt = bundle->pkt;
	// READ
	const HexOp *Rxx_op = ISA2REG(hi, 'x', false);

	const HexOp *Rs_op = ISA2REG(hi, 's', false);
	RzILOpPure *Rs = READ_REG(pkt, Rs_op, false);
	const HexOp *Rt_op = ISA2REG(hi, 't', false);
	RzILOpPure *Rt = READ_REG(pkt, Rt_op, false);

	// set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, ((ut32) 0x1));
	RzILOpEffect *set_usr_field_call_171 = hex_set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, CAST(32, IL_FALSE, SN(32, 1)));

	// HYB(gcc_expr_if ((sextract64(((ut64) ((st64) ((st32) ((Rxx >> 0x20) & 0xffffffff))) - (((st64) ((st32) ((st16) ((Rs >> 0x10) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x0) & 0xffff)))) << 0x0) + (((st64) ((st32) ((st16) ((Rs >> 0x0) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x10) & 0xffff)))) << 0x0)), 0x0, 0x20) == ((st64) ((st32) ((Rxx >> 0x20) & 0xffffffff))) - (((st64) ((st32) ((st16) ((Rs >> 0x10) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x0) & 0xffff)))) << 0x0) + (((st64) ((st32) ((st16) ((Rs >> 0x0) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x10) & 0xffff)))) << 0x0))) {{}} else {set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, ((ut32) 0x1))}, ((((st64) ((st32) ((Rxx >> 0x20) & 0xffffffff))) - (((st64) ((st32) ((st16) ((Rs >> 0x10) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x0) & 0xffff)))) << 0x0) + (((st64) ((st32) ((st16) ((Rs >> 0x0) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x10) & 0xffff)))) << 0x0) < ((st64) 0x0)) ? (-(0x1 << 0x1f)) : (0x1 << 0x1f) - ((st64) 0x1)));
	RzILOpPure *op_RSHIFT_14 = SHIFTRA(READ_REG(pkt, Rxx_op, false), SN(32, 0x20));
	RzILOpPure *op_AND_16 = LOGAND(op_RSHIFT_14, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_23 = SHIFTRA(Rs, SN(32, 16));
	RzILOpPure *op_AND_25 = LOGAND(op_RSHIFT_23, SN(32, 0xffff));
	RzILOpPure *op_RSHIFT_32 = SHIFTRA(Rt, SN(32, 0));
	RzILOpPure *op_AND_34 = LOGAND(op_RSHIFT_32, SN(32, 0xffff));
	RzILOpPure *op_MUL_37 = MUL(CAST(32, MSB(CAST(16, MSB(op_AND_25), DUP(op_AND_25))), CAST(16, MSB(DUP(op_AND_25)), DUP(op_AND_25))), CAST(32, MSB(CAST(16, MSB(op_AND_34), DUP(op_AND_34))), CAST(16, MSB(DUP(op_AND_34)), DUP(op_AND_34))));
	RzILOpPure *op_LSHIFT_40 = SHIFTL0(CAST(64, MSB(op_MUL_37), DUP(op_MUL_37)), SN(32, 0));
	RzILOpPure *op_RSHIFT_44 = SHIFTRA(DUP(Rs), SN(32, 0));
	RzILOpPure *op_AND_46 = LOGAND(op_RSHIFT_44, SN(32, 0xffff));
	RzILOpPure *op_RSHIFT_52 = SHIFTRA(DUP(Rt), SN(32, 16));
	RzILOpPure *op_AND_54 = LOGAND(op_RSHIFT_52, SN(32, 0xffff));
	RzILOpPure *op_MUL_57 = MUL(CAST(32, MSB(CAST(16, MSB(op_AND_46), DUP(op_AND_46))), CAST(16, MSB(DUP(op_AND_46)), DUP(op_AND_46))), CAST(32, MSB(CAST(16, MSB(op_AND_54), DUP(op_AND_54))), CAST(16, MSB(DUP(op_AND_54)), DUP(op_AND_54))));
	RzILOpPure *op_LSHIFT_60 = SHIFTL0(CAST(64, MSB(op_MUL_57), DUP(op_MUL_57)), SN(32, 0));
	RzILOpPure *op_ADD_61 = ADD(op_LSHIFT_40, op_LSHIFT_60);
	RzILOpPure *op_SUB_62 = SUB(CAST(64, MSB(CAST(32, MSB(op_AND_16), DUP(op_AND_16))), CAST(32, MSB(DUP(op_AND_16)), DUP(op_AND_16))), op_ADD_61);
	RzILOpPure *op_RSHIFT_71 = SHIFTRA(READ_REG(pkt, Rxx_op, false), SN(32, 0x20));
	RzILOpPure *op_AND_73 = LOGAND(op_RSHIFT_71, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_79 = SHIFTRA(DUP(Rs), SN(32, 16));
	RzILOpPure *op_AND_81 = LOGAND(op_RSHIFT_79, SN(32, 0xffff));
	RzILOpPure *op_RSHIFT_87 = SHIFTRA(DUP(Rt), SN(32, 0));
	RzILOpPure *op_AND_89 = LOGAND(op_RSHIFT_87, SN(32, 0xffff));
	RzILOpPure *op_MUL_92 = MUL(CAST(32, MSB(CAST(16, MSB(op_AND_81), DUP(op_AND_81))), CAST(16, MSB(DUP(op_AND_81)), DUP(op_AND_81))), CAST(32, MSB(CAST(16, MSB(op_AND_89), DUP(op_AND_89))), CAST(16, MSB(DUP(op_AND_89)), DUP(op_AND_89))));
	RzILOpPure *op_LSHIFT_95 = SHIFTL0(CAST(64, MSB(op_MUL_92), DUP(op_MUL_92)), SN(32, 0));
	RzILOpPure *op_RSHIFT_99 = SHIFTRA(DUP(Rs), SN(32, 0));
	RzILOpPure *op_AND_101 = LOGAND(op_RSHIFT_99, SN(32, 0xffff));
	RzILOpPure *op_RSHIFT_107 = SHIFTRA(DUP(Rt), SN(32, 16));
	RzILOpPure *op_AND_109 = LOGAND(op_RSHIFT_107, SN(32, 0xffff));
	RzILOpPure *op_MUL_112 = MUL(CAST(32, MSB(CAST(16, MSB(op_AND_101), DUP(op_AND_101))), CAST(16, MSB(DUP(op_AND_101)), DUP(op_AND_101))), CAST(32, MSB(CAST(16, MSB(op_AND_109), DUP(op_AND_109))), CAST(16, MSB(DUP(op_AND_109)), DUP(op_AND_109))));
	RzILOpPure *op_LSHIFT_115 = SHIFTL0(CAST(64, MSB(op_MUL_112), DUP(op_MUL_112)), SN(32, 0));
	RzILOpPure *op_ADD_116 = ADD(op_LSHIFT_95, op_LSHIFT_115);
	RzILOpPure *op_SUB_117 = SUB(CAST(64, MSB(CAST(32, MSB(op_AND_73), DUP(op_AND_73))), CAST(32, MSB(DUP(op_AND_73)), DUP(op_AND_73))), op_ADD_116);
	RzILOpPure *op_EQ_118 = EQ(SEXTRACT64(CAST(64, IL_FALSE, op_SUB_62), SN(32, 0), SN(32, 0x20)), op_SUB_117);
	RzILOpPure *op_RSHIFT_175 = SHIFTRA(READ_REG(pkt, Rxx_op, false), SN(32, 0x20));
	RzILOpPure *op_AND_177 = LOGAND(op_RSHIFT_175, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_183 = SHIFTRA(DUP(Rs), SN(32, 16));
	RzILOpPure *op_AND_185 = LOGAND(op_RSHIFT_183, SN(32, 0xffff));
	RzILOpPure *op_RSHIFT_191 = SHIFTRA(DUP(Rt), SN(32, 0));
	RzILOpPure *op_AND_193 = LOGAND(op_RSHIFT_191, SN(32, 0xffff));
	RzILOpPure *op_MUL_196 = MUL(CAST(32, MSB(CAST(16, MSB(op_AND_185), DUP(op_AND_185))), CAST(16, MSB(DUP(op_AND_185)), DUP(op_AND_185))), CAST(32, MSB(CAST(16, MSB(op_AND_193), DUP(op_AND_193))), CAST(16, MSB(DUP(op_AND_193)), DUP(op_AND_193))));
	RzILOpPure *op_LSHIFT_199 = SHIFTL0(CAST(64, MSB(op_MUL_196), DUP(op_MUL_196)), SN(32, 0));
	RzILOpPure *op_RSHIFT_203 = SHIFTRA(DUP(Rs), SN(32, 0));
	RzILOpPure *op_AND_205 = LOGAND(op_RSHIFT_203, SN(32, 0xffff));
	RzILOpPure *op_RSHIFT_211 = SHIFTRA(DUP(Rt), SN(32, 16));
	RzILOpPure *op_AND_213 = LOGAND(op_RSHIFT_211, SN(32, 0xffff));
	RzILOpPure *op_MUL_216 = MUL(CAST(32, MSB(CAST(16, MSB(op_AND_205), DUP(op_AND_205))), CAST(16, MSB(DUP(op_AND_205)), DUP(op_AND_205))), CAST(32, MSB(CAST(16, MSB(op_AND_213), DUP(op_AND_213))), CAST(16, MSB(DUP(op_AND_213)), DUP(op_AND_213))));
	RzILOpPure *op_LSHIFT_219 = SHIFTL0(CAST(64, MSB(op_MUL_216), DUP(op_MUL_216)), SN(32, 0));
	RzILOpPure *op_ADD_220 = ADD(op_LSHIFT_199, op_LSHIFT_219);
	RzILOpPure *op_SUB_221 = SUB(CAST(64, MSB(CAST(32, MSB(op_AND_177), DUP(op_AND_177))), CAST(32, MSB(DUP(op_AND_177)), DUP(op_AND_177))), op_ADD_220);
	RzILOpPure *op_LT_224 = SLT(op_SUB_221, CAST(64, MSB(SN(32, 0)), SN(32, 0)));
	RzILOpPure *op_LSHIFT_229 = SHIFTL0(SN(64, 1), SN(32, 31));
	RzILOpPure *op_NEG_230 = NEG(op_LSHIFT_229);
	RzILOpPure *op_LSHIFT_235 = SHIFTL0(SN(64, 1), SN(32, 31));
	RzILOpPure *op_SUB_238 = SUB(op_LSHIFT_235, CAST(64, MSB(SN(32, 1)), SN(32, 1)));
	RzILOpPure *cond_239 = ITE(op_LT_224, op_NEG_230, op_SUB_238);
	RzILOpEffect *gcc_expr_240 = BRANCH(op_EQ_118, EMPTY(), set_usr_field_call_171);

	// h_tmp256 = HYB(gcc_expr_if ((sextract64(((ut64) ((st64) ((st32) ((Rxx >> 0x20) & 0xffffffff))) - (((st64) ((st32) ((st16) ((Rs >> 0x10) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x0) & 0xffff)))) << 0x0) + (((st64) ((st32) ((st16) ((Rs >> 0x0) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x10) & 0xffff)))) << 0x0)), 0x0, 0x20) == ((st64) ((st32) ((Rxx >> 0x20) & 0xffffffff))) - (((st64) ((st32) ((st16) ((Rs >> 0x10) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x0) & 0xffff)))) << 0x0) + (((st64) ((st32) ((st16) ((Rs >> 0x0) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x10) & 0xffff)))) << 0x0))) {{}} else {set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, ((ut32) 0x1))}, ((((st64) ((st32) ((Rxx >> 0x20) & 0xffffffff))) - (((st64) ((st32) ((st16) ((Rs >> 0x10) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x0) & 0xffff)))) << 0x0) + (((st64) ((st32) ((st16) ((Rs >> 0x0) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x10) & 0xffff)))) << 0x0) < ((st64) 0x0)) ? (-(0x1 << 0x1f)) : (0x1 << 0x1f) - ((st64) 0x1)));
	RzILOpEffect *op_ASSIGN_hybrid_tmp_242 = SETL("h_tmp256", cond_239);

	// seq(HYB(gcc_expr_if ((sextract64(((ut64) ((st64) ((st32) ((Rxx > ...;
	RzILOpEffect *seq_243 = SEQN(2, gcc_expr_240, op_ASSIGN_hybrid_tmp_242);

	// Rxx = ((Rxx & (~(0xffffffff << 0x20))) | ((((sextract64(((ut64) ((st64) ((st32) ((Rxx >> 0x20) & 0xffffffff))) - (((st64) ((st32) ((st16) ((Rs >> 0x10) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x0) & 0xffff)))) << 0x0) + (((st64) ((st32) ((st16) ((Rs >> 0x0) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x10) & 0xffff)))) << 0x0)), 0x0, 0x20) == ((st64) ((st32) ((Rxx >> 0x20) & 0xffffffff))) - (((st64) ((st32) ((st16) ((Rs >> 0x10) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x0) & 0xffff)))) << 0x0) + (((st64) ((st32) ((st16) ((Rs >> 0x0) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x10) & 0xffff)))) << 0x0)) ? ((st64) ((st32) ((Rxx >> 0x20) & 0xffffffff))) - (((st64) ((st32) ((st16) ((Rs >> 0x10) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x0) & 0xffff)))) << 0x0) + (((st64) ((st32) ((st16) ((Rs >> 0x0) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x10) & 0xffff)))) << 0x0) : h_tmp256) & 0xffffffff) << 0x20));
	RzILOpPure *op_LSHIFT_5 = SHIFTL0(SN(64, 0xffffffff), SN(32, 0x20));
	RzILOpPure *op_NOT_6 = LOGNOT(op_LSHIFT_5);
	RzILOpPure *op_AND_7 = LOGAND(READ_REG(pkt, Rxx_op, false), op_NOT_6);
	RzILOpPure *op_RSHIFT_122 = SHIFTRA(READ_REG(pkt, Rxx_op, false), SN(32, 0x20));
	RzILOpPure *op_AND_124 = LOGAND(op_RSHIFT_122, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_130 = SHIFTRA(DUP(Rs), SN(32, 16));
	RzILOpPure *op_AND_132 = LOGAND(op_RSHIFT_130, SN(32, 0xffff));
	RzILOpPure *op_RSHIFT_138 = SHIFTRA(DUP(Rt), SN(32, 0));
	RzILOpPure *op_AND_140 = LOGAND(op_RSHIFT_138, SN(32, 0xffff));
	RzILOpPure *op_MUL_143 = MUL(CAST(32, MSB(CAST(16, MSB(op_AND_132), DUP(op_AND_132))), CAST(16, MSB(DUP(op_AND_132)), DUP(op_AND_132))), CAST(32, MSB(CAST(16, MSB(op_AND_140), DUP(op_AND_140))), CAST(16, MSB(DUP(op_AND_140)), DUP(op_AND_140))));
	RzILOpPure *op_LSHIFT_146 = SHIFTL0(CAST(64, MSB(op_MUL_143), DUP(op_MUL_143)), SN(32, 0));
	RzILOpPure *op_RSHIFT_150 = SHIFTRA(DUP(Rs), SN(32, 0));
	RzILOpPure *op_AND_152 = LOGAND(op_RSHIFT_150, SN(32, 0xffff));
	RzILOpPure *op_RSHIFT_158 = SHIFTRA(DUP(Rt), SN(32, 16));
	RzILOpPure *op_AND_160 = LOGAND(op_RSHIFT_158, SN(32, 0xffff));
	RzILOpPure *op_MUL_163 = MUL(CAST(32, MSB(CAST(16, MSB(op_AND_152), DUP(op_AND_152))), CAST(16, MSB(DUP(op_AND_152)), DUP(op_AND_152))), CAST(32, MSB(CAST(16, MSB(op_AND_160), DUP(op_AND_160))), CAST(16, MSB(DUP(op_AND_160)), DUP(op_AND_160))));
	RzILOpPure *op_LSHIFT_166 = SHIFTL0(CAST(64, MSB(op_MUL_163), DUP(op_MUL_163)), SN(32, 0));
	RzILOpPure *op_ADD_167 = ADD(op_LSHIFT_146, op_LSHIFT_166);
	RzILOpPure *op_SUB_168 = SUB(CAST(64, MSB(CAST(32, MSB(op_AND_124), DUP(op_AND_124))), CAST(32, MSB(DUP(op_AND_124)), DUP(op_AND_124))), op_ADD_167);
	RzILOpPure *cond_244 = ITE(DUP(op_EQ_118), op_SUB_168, VARL("h_tmp256"));
	RzILOpPure *op_AND_246 = LOGAND(cond_244, SN(64, 0xffffffff));
	RzILOpPure *op_LSHIFT_250 = SHIFTL0(op_AND_246, SN(32, 0x20));
	RzILOpPure *op_OR_251 = LOGOR(op_AND_7, op_LSHIFT_250);
	RzILOpEffect *op_ASSIGN_252 = WRITE_REG(bundle, Rxx_op, op_OR_251);

	// seq(seq(HYB(gcc_expr_if ((sextract64(((ut64) ((st64) ((st32) ((R ...;
	RzILOpEffect *seq_253 = SEQN(2, seq_243, op_ASSIGN_252);

	// set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, ((ut32) 0x1));
	RzILOpEffect *set_usr_field_call_423 = hex_set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, CAST(32, IL_FALSE, SN(32, 1)));

	// HYB(gcc_expr_if ((sextract64(((ut64) ((st64) ((st32) ((Rxx >> 0x0) & 0xffffffff))) - (((st64) ((st32) ((st16) ((Rs >> 0x0) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x0) & 0xffff)))) << 0x0) - (((st64) ((st32) ((st16) ((Rs >> 0x10) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x10) & 0xffff)))) << 0x0)), 0x0, 0x20) == ((st64) ((st32) ((Rxx >> 0x0) & 0xffffffff))) - (((st64) ((st32) ((st16) ((Rs >> 0x0) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x0) & 0xffff)))) << 0x0) - (((st64) ((st32) ((st16) ((Rs >> 0x10) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x10) & 0xffff)))) << 0x0))) {{}} else {set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, ((ut32) 0x1))}, ((((st64) ((st32) ((Rxx >> 0x0) & 0xffffffff))) - (((st64) ((st32) ((st16) ((Rs >> 0x0) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x0) & 0xffff)))) << 0x0) - (((st64) ((st32) ((st16) ((Rs >> 0x10) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x10) & 0xffff)))) << 0x0) < ((st64) 0x0)) ? (-(0x1 << 0x1f)) : (0x1 << 0x1f) - ((st64) 0x1)));
	RzILOpPure *op_RSHIFT_268 = SHIFTRA(READ_REG(pkt, Rxx_op, false), SN(32, 0));
	RzILOpPure *op_AND_270 = LOGAND(op_RSHIFT_268, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_276 = SHIFTRA(DUP(Rs), SN(32, 0));
	RzILOpPure *op_AND_278 = LOGAND(op_RSHIFT_276, SN(32, 0xffff));
	RzILOpPure *op_RSHIFT_284 = SHIFTRA(DUP(Rt), SN(32, 0));
	RzILOpPure *op_AND_286 = LOGAND(op_RSHIFT_284, SN(32, 0xffff));
	RzILOpPure *op_MUL_289 = MUL(CAST(32, MSB(CAST(16, MSB(op_AND_278), DUP(op_AND_278))), CAST(16, MSB(DUP(op_AND_278)), DUP(op_AND_278))), CAST(32, MSB(CAST(16, MSB(op_AND_286), DUP(op_AND_286))), CAST(16, MSB(DUP(op_AND_286)), DUP(op_AND_286))));
	RzILOpPure *op_LSHIFT_292 = SHIFTL0(CAST(64, MSB(op_MUL_289), DUP(op_MUL_289)), SN(32, 0));
	RzILOpPure *op_RSHIFT_296 = SHIFTRA(DUP(Rs), SN(32, 16));
	RzILOpPure *op_AND_298 = LOGAND(op_RSHIFT_296, SN(32, 0xffff));
	RzILOpPure *op_RSHIFT_304 = SHIFTRA(DUP(Rt), SN(32, 16));
	RzILOpPure *op_AND_306 = LOGAND(op_RSHIFT_304, SN(32, 0xffff));
	RzILOpPure *op_MUL_309 = MUL(CAST(32, MSB(CAST(16, MSB(op_AND_298), DUP(op_AND_298))), CAST(16, MSB(DUP(op_AND_298)), DUP(op_AND_298))), CAST(32, MSB(CAST(16, MSB(op_AND_306), DUP(op_AND_306))), CAST(16, MSB(DUP(op_AND_306)), DUP(op_AND_306))));
	RzILOpPure *op_LSHIFT_312 = SHIFTL0(CAST(64, MSB(op_MUL_309), DUP(op_MUL_309)), SN(32, 0));
	RzILOpPure *op_SUB_313 = SUB(op_LSHIFT_292, op_LSHIFT_312);
	RzILOpPure *op_SUB_314 = SUB(CAST(64, MSB(CAST(32, MSB(op_AND_270), DUP(op_AND_270))), CAST(32, MSB(DUP(op_AND_270)), DUP(op_AND_270))), op_SUB_313);
	RzILOpPure *op_RSHIFT_323 = SHIFTRA(READ_REG(pkt, Rxx_op, false), SN(32, 0));
	RzILOpPure *op_AND_325 = LOGAND(op_RSHIFT_323, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_331 = SHIFTRA(DUP(Rs), SN(32, 0));
	RzILOpPure *op_AND_333 = LOGAND(op_RSHIFT_331, SN(32, 0xffff));
	RzILOpPure *op_RSHIFT_339 = SHIFTRA(DUP(Rt), SN(32, 0));
	RzILOpPure *op_AND_341 = LOGAND(op_RSHIFT_339, SN(32, 0xffff));
	RzILOpPure *op_MUL_344 = MUL(CAST(32, MSB(CAST(16, MSB(op_AND_333), DUP(op_AND_333))), CAST(16, MSB(DUP(op_AND_333)), DUP(op_AND_333))), CAST(32, MSB(CAST(16, MSB(op_AND_341), DUP(op_AND_341))), CAST(16, MSB(DUP(op_AND_341)), DUP(op_AND_341))));
	RzILOpPure *op_LSHIFT_347 = SHIFTL0(CAST(64, MSB(op_MUL_344), DUP(op_MUL_344)), SN(32, 0));
	RzILOpPure *op_RSHIFT_351 = SHIFTRA(DUP(Rs), SN(32, 16));
	RzILOpPure *op_AND_353 = LOGAND(op_RSHIFT_351, SN(32, 0xffff));
	RzILOpPure *op_RSHIFT_359 = SHIFTRA(DUP(Rt), SN(32, 16));
	RzILOpPure *op_AND_361 = LOGAND(op_RSHIFT_359, SN(32, 0xffff));
	RzILOpPure *op_MUL_364 = MUL(CAST(32, MSB(CAST(16, MSB(op_AND_353), DUP(op_AND_353))), CAST(16, MSB(DUP(op_AND_353)), DUP(op_AND_353))), CAST(32, MSB(CAST(16, MSB(op_AND_361), DUP(op_AND_361))), CAST(16, MSB(DUP(op_AND_361)), DUP(op_AND_361))));
	RzILOpPure *op_LSHIFT_367 = SHIFTL0(CAST(64, MSB(op_MUL_364), DUP(op_MUL_364)), SN(32, 0));
	RzILOpPure *op_SUB_368 = SUB(op_LSHIFT_347, op_LSHIFT_367);
	RzILOpPure *op_SUB_369 = SUB(CAST(64, MSB(CAST(32, MSB(op_AND_325), DUP(op_AND_325))), CAST(32, MSB(DUP(op_AND_325)), DUP(op_AND_325))), op_SUB_368);
	RzILOpPure *op_EQ_370 = EQ(SEXTRACT64(CAST(64, IL_FALSE, op_SUB_314), SN(32, 0), SN(32, 0x20)), op_SUB_369);
	RzILOpPure *op_RSHIFT_427 = SHIFTRA(READ_REG(pkt, Rxx_op, false), SN(32, 0));
	RzILOpPure *op_AND_429 = LOGAND(op_RSHIFT_427, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_435 = SHIFTRA(DUP(Rs), SN(32, 0));
	RzILOpPure *op_AND_437 = LOGAND(op_RSHIFT_435, SN(32, 0xffff));
	RzILOpPure *op_RSHIFT_443 = SHIFTRA(DUP(Rt), SN(32, 0));
	RzILOpPure *op_AND_445 = LOGAND(op_RSHIFT_443, SN(32, 0xffff));
	RzILOpPure *op_MUL_448 = MUL(CAST(32, MSB(CAST(16, MSB(op_AND_437), DUP(op_AND_437))), CAST(16, MSB(DUP(op_AND_437)), DUP(op_AND_437))), CAST(32, MSB(CAST(16, MSB(op_AND_445), DUP(op_AND_445))), CAST(16, MSB(DUP(op_AND_445)), DUP(op_AND_445))));
	RzILOpPure *op_LSHIFT_451 = SHIFTL0(CAST(64, MSB(op_MUL_448), DUP(op_MUL_448)), SN(32, 0));
	RzILOpPure *op_RSHIFT_455 = SHIFTRA(DUP(Rs), SN(32, 16));
	RzILOpPure *op_AND_457 = LOGAND(op_RSHIFT_455, SN(32, 0xffff));
	RzILOpPure *op_RSHIFT_463 = SHIFTRA(DUP(Rt), SN(32, 16));
	RzILOpPure *op_AND_465 = LOGAND(op_RSHIFT_463, SN(32, 0xffff));
	RzILOpPure *op_MUL_468 = MUL(CAST(32, MSB(CAST(16, MSB(op_AND_457), DUP(op_AND_457))), CAST(16, MSB(DUP(op_AND_457)), DUP(op_AND_457))), CAST(32, MSB(CAST(16, MSB(op_AND_465), DUP(op_AND_465))), CAST(16, MSB(DUP(op_AND_465)), DUP(op_AND_465))));
	RzILOpPure *op_LSHIFT_471 = SHIFTL0(CAST(64, MSB(op_MUL_468), DUP(op_MUL_468)), SN(32, 0));
	RzILOpPure *op_SUB_472 = SUB(op_LSHIFT_451, op_LSHIFT_471);
	RzILOpPure *op_SUB_473 = SUB(CAST(64, MSB(CAST(32, MSB(op_AND_429), DUP(op_AND_429))), CAST(32, MSB(DUP(op_AND_429)), DUP(op_AND_429))), op_SUB_472);
	RzILOpPure *op_LT_476 = SLT(op_SUB_473, CAST(64, MSB(SN(32, 0)), SN(32, 0)));
	RzILOpPure *op_LSHIFT_481 = SHIFTL0(SN(64, 1), SN(32, 31));
	RzILOpPure *op_NEG_482 = NEG(op_LSHIFT_481);
	RzILOpPure *op_LSHIFT_487 = SHIFTL0(SN(64, 1), SN(32, 31));
	RzILOpPure *op_SUB_490 = SUB(op_LSHIFT_487, CAST(64, MSB(SN(32, 1)), SN(32, 1)));
	RzILOpPure *cond_491 = ITE(op_LT_476, op_NEG_482, op_SUB_490);
	RzILOpEffect *gcc_expr_492 = BRANCH(op_EQ_370, EMPTY(), set_usr_field_call_423);

	// h_tmp257 = HYB(gcc_expr_if ((sextract64(((ut64) ((st64) ((st32) ((Rxx >> 0x0) & 0xffffffff))) - (((st64) ((st32) ((st16) ((Rs >> 0x0) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x0) & 0xffff)))) << 0x0) - (((st64) ((st32) ((st16) ((Rs >> 0x10) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x10) & 0xffff)))) << 0x0)), 0x0, 0x20) == ((st64) ((st32) ((Rxx >> 0x0) & 0xffffffff))) - (((st64) ((st32) ((st16) ((Rs >> 0x0) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x0) & 0xffff)))) << 0x0) - (((st64) ((st32) ((st16) ((Rs >> 0x10) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x10) & 0xffff)))) << 0x0))) {{}} else {set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, ((ut32) 0x1))}, ((((st64) ((st32) ((Rxx >> 0x0) & 0xffffffff))) - (((st64) ((st32) ((st16) ((Rs >> 0x0) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x0) & 0xffff)))) << 0x0) - (((st64) ((st32) ((st16) ((Rs >> 0x10) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x10) & 0xffff)))) << 0x0) < ((st64) 0x0)) ? (-(0x1 << 0x1f)) : (0x1 << 0x1f) - ((st64) 0x1)));
	RzILOpEffect *op_ASSIGN_hybrid_tmp_494 = SETL("h_tmp257", cond_491);

	// seq(HYB(gcc_expr_if ((sextract64(((ut64) ((st64) ((st32) ((Rxx > ...;
	RzILOpEffect *seq_495 = SEQN(2, gcc_expr_492, op_ASSIGN_hybrid_tmp_494);

	// Rxx = ((Rxx & (~(0xffffffff << 0x0))) | ((((sextract64(((ut64) ((st64) ((st32) ((Rxx >> 0x0) & 0xffffffff))) - (((st64) ((st32) ((st16) ((Rs >> 0x0) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x0) & 0xffff)))) << 0x0) - (((st64) ((st32) ((st16) ((Rs >> 0x10) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x10) & 0xffff)))) << 0x0)), 0x0, 0x20) == ((st64) ((st32) ((Rxx >> 0x0) & 0xffffffff))) - (((st64) ((st32) ((st16) ((Rs >> 0x0) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x0) & 0xffff)))) << 0x0) - (((st64) ((st32) ((st16) ((Rs >> 0x10) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x10) & 0xffff)))) << 0x0)) ? ((st64) ((st32) ((Rxx >> 0x0) & 0xffffffff))) - (((st64) ((st32) ((st16) ((Rs >> 0x0) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x0) & 0xffff)))) << 0x0) - (((st64) ((st32) ((st16) ((Rs >> 0x10) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x10) & 0xffff)))) << 0x0) : h_tmp257) & 0xffffffff) << 0x0));
	RzILOpPure *op_LSHIFT_259 = SHIFTL0(SN(64, 0xffffffff), SN(32, 0));
	RzILOpPure *op_NOT_260 = LOGNOT(op_LSHIFT_259);
	RzILOpPure *op_AND_261 = LOGAND(READ_REG(pkt, Rxx_op, false), op_NOT_260);
	RzILOpPure *op_RSHIFT_374 = SHIFTRA(READ_REG(pkt, Rxx_op, false), SN(32, 0));
	RzILOpPure *op_AND_376 = LOGAND(op_RSHIFT_374, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_382 = SHIFTRA(DUP(Rs), SN(32, 0));
	RzILOpPure *op_AND_384 = LOGAND(op_RSHIFT_382, SN(32, 0xffff));
	RzILOpPure *op_RSHIFT_390 = SHIFTRA(DUP(Rt), SN(32, 0));
	RzILOpPure *op_AND_392 = LOGAND(op_RSHIFT_390, SN(32, 0xffff));
	RzILOpPure *op_MUL_395 = MUL(CAST(32, MSB(CAST(16, MSB(op_AND_384), DUP(op_AND_384))), CAST(16, MSB(DUP(op_AND_384)), DUP(op_AND_384))), CAST(32, MSB(CAST(16, MSB(op_AND_392), DUP(op_AND_392))), CAST(16, MSB(DUP(op_AND_392)), DUP(op_AND_392))));
	RzILOpPure *op_LSHIFT_398 = SHIFTL0(CAST(64, MSB(op_MUL_395), DUP(op_MUL_395)), SN(32, 0));
	RzILOpPure *op_RSHIFT_402 = SHIFTRA(DUP(Rs), SN(32, 16));
	RzILOpPure *op_AND_404 = LOGAND(op_RSHIFT_402, SN(32, 0xffff));
	RzILOpPure *op_RSHIFT_410 = SHIFTRA(DUP(Rt), SN(32, 16));
	RzILOpPure *op_AND_412 = LOGAND(op_RSHIFT_410, SN(32, 0xffff));
	RzILOpPure *op_MUL_415 = MUL(CAST(32, MSB(CAST(16, MSB(op_AND_404), DUP(op_AND_404))), CAST(16, MSB(DUP(op_AND_404)), DUP(op_AND_404))), CAST(32, MSB(CAST(16, MSB(op_AND_412), DUP(op_AND_412))), CAST(16, MSB(DUP(op_AND_412)), DUP(op_AND_412))));
	RzILOpPure *op_LSHIFT_418 = SHIFTL0(CAST(64, MSB(op_MUL_415), DUP(op_MUL_415)), SN(32, 0));
	RzILOpPure *op_SUB_419 = SUB(op_LSHIFT_398, op_LSHIFT_418);
	RzILOpPure *op_SUB_420 = SUB(CAST(64, MSB(CAST(32, MSB(op_AND_376), DUP(op_AND_376))), CAST(32, MSB(DUP(op_AND_376)), DUP(op_AND_376))), op_SUB_419);
	RzILOpPure *cond_496 = ITE(DUP(op_EQ_370), op_SUB_420, VARL("h_tmp257"));
	RzILOpPure *op_AND_498 = LOGAND(cond_496, SN(64, 0xffffffff));
	RzILOpPure *op_LSHIFT_502 = SHIFTL0(op_AND_498, SN(32, 0));
	RzILOpPure *op_OR_503 = LOGOR(op_AND_261, op_LSHIFT_502);
	RzILOpEffect *op_ASSIGN_504 = WRITE_REG(bundle, Rxx_op, op_OR_503);

	// seq(seq(HYB(gcc_expr_if ((sextract64(((ut64) ((st64) ((st32) ((R ...;
	RzILOpEffect *seq_505 = SEQN(2, seq_495, op_ASSIGN_504);

	RzILOpEffect *instruction_sequence = SEQN(2, seq_253, seq_505);
	return instruction_sequence;
}

// Rxx -= cmpy(Rs,Rt):<<1:sat
RzILOpEffect *hex_il_op_m2_cnacs_s1(HexInsnPktBundle *bundle) {
	const HexInsn *hi = bundle->insn;
	HexPkt *pkt = bundle->pkt;
	// READ
	const HexOp *Rxx_op = ISA2REG(hi, 'x', false);

	const HexOp *Rs_op = ISA2REG(hi, 's', false);
	RzILOpPure *Rs = READ_REG(pkt, Rs_op, false);
	const HexOp *Rt_op = ISA2REG(hi, 't', false);
	RzILOpPure *Rt = READ_REG(pkt, Rt_op, false);

	// set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, ((ut32) 0x1));
	RzILOpEffect *set_usr_field_call_171 = hex_set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, CAST(32, IL_FALSE, SN(32, 1)));

	// HYB(gcc_expr_if ((sextract64(((ut64) ((st64) ((st32) ((Rxx >> 0x20) & 0xffffffff))) - (((st64) ((st32) ((st16) ((Rs >> 0x10) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x0) & 0xffff)))) << 0x1) + (((st64) ((st32) ((st16) ((Rs >> 0x0) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x10) & 0xffff)))) << 0x1)), 0x0, 0x20) == ((st64) ((st32) ((Rxx >> 0x20) & 0xffffffff))) - (((st64) ((st32) ((st16) ((Rs >> 0x10) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x0) & 0xffff)))) << 0x1) + (((st64) ((st32) ((st16) ((Rs >> 0x0) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x10) & 0xffff)))) << 0x1))) {{}} else {set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, ((ut32) 0x1))}, ((((st64) ((st32) ((Rxx >> 0x20) & 0xffffffff))) - (((st64) ((st32) ((st16) ((Rs >> 0x10) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x0) & 0xffff)))) << 0x1) + (((st64) ((st32) ((st16) ((Rs >> 0x0) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x10) & 0xffff)))) << 0x1) < ((st64) 0x0)) ? (-(0x1 << 0x1f)) : (0x1 << 0x1f) - ((st64) 0x1)));
	RzILOpPure *op_RSHIFT_14 = SHIFTRA(READ_REG(pkt, Rxx_op, false), SN(32, 0x20));
	RzILOpPure *op_AND_16 = LOGAND(op_RSHIFT_14, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_23 = SHIFTRA(Rs, SN(32, 16));
	RzILOpPure *op_AND_25 = LOGAND(op_RSHIFT_23, SN(32, 0xffff));
	RzILOpPure *op_RSHIFT_32 = SHIFTRA(Rt, SN(32, 0));
	RzILOpPure *op_AND_34 = LOGAND(op_RSHIFT_32, SN(32, 0xffff));
	RzILOpPure *op_MUL_37 = MUL(CAST(32, MSB(CAST(16, MSB(op_AND_25), DUP(op_AND_25))), CAST(16, MSB(DUP(op_AND_25)), DUP(op_AND_25))), CAST(32, MSB(CAST(16, MSB(op_AND_34), DUP(op_AND_34))), CAST(16, MSB(DUP(op_AND_34)), DUP(op_AND_34))));
	RzILOpPure *op_LSHIFT_40 = SHIFTL0(CAST(64, MSB(op_MUL_37), DUP(op_MUL_37)), SN(32, 1));
	RzILOpPure *op_RSHIFT_44 = SHIFTRA(DUP(Rs), SN(32, 0));
	RzILOpPure *op_AND_46 = LOGAND(op_RSHIFT_44, SN(32, 0xffff));
	RzILOpPure *op_RSHIFT_52 = SHIFTRA(DUP(Rt), SN(32, 16));
	RzILOpPure *op_AND_54 = LOGAND(op_RSHIFT_52, SN(32, 0xffff));
	RzILOpPure *op_MUL_57 = MUL(CAST(32, MSB(CAST(16, MSB(op_AND_46), DUP(op_AND_46))), CAST(16, MSB(DUP(op_AND_46)), DUP(op_AND_46))), CAST(32, MSB(CAST(16, MSB(op_AND_54), DUP(op_AND_54))), CAST(16, MSB(DUP(op_AND_54)), DUP(op_AND_54))));
	RzILOpPure *op_LSHIFT_60 = SHIFTL0(CAST(64, MSB(op_MUL_57), DUP(op_MUL_57)), SN(32, 1));
	RzILOpPure *op_ADD_61 = ADD(op_LSHIFT_40, op_LSHIFT_60);
	RzILOpPure *op_SUB_62 = SUB(CAST(64, MSB(CAST(32, MSB(op_AND_16), DUP(op_AND_16))), CAST(32, MSB(DUP(op_AND_16)), DUP(op_AND_16))), op_ADD_61);
	RzILOpPure *op_RSHIFT_71 = SHIFTRA(READ_REG(pkt, Rxx_op, false), SN(32, 0x20));
	RzILOpPure *op_AND_73 = LOGAND(op_RSHIFT_71, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_79 = SHIFTRA(DUP(Rs), SN(32, 16));
	RzILOpPure *op_AND_81 = LOGAND(op_RSHIFT_79, SN(32, 0xffff));
	RzILOpPure *op_RSHIFT_87 = SHIFTRA(DUP(Rt), SN(32, 0));
	RzILOpPure *op_AND_89 = LOGAND(op_RSHIFT_87, SN(32, 0xffff));
	RzILOpPure *op_MUL_92 = MUL(CAST(32, MSB(CAST(16, MSB(op_AND_81), DUP(op_AND_81))), CAST(16, MSB(DUP(op_AND_81)), DUP(op_AND_81))), CAST(32, MSB(CAST(16, MSB(op_AND_89), DUP(op_AND_89))), CAST(16, MSB(DUP(op_AND_89)), DUP(op_AND_89))));
	RzILOpPure *op_LSHIFT_95 = SHIFTL0(CAST(64, MSB(op_MUL_92), DUP(op_MUL_92)), SN(32, 1));
	RzILOpPure *op_RSHIFT_99 = SHIFTRA(DUP(Rs), SN(32, 0));
	RzILOpPure *op_AND_101 = LOGAND(op_RSHIFT_99, SN(32, 0xffff));
	RzILOpPure *op_RSHIFT_107 = SHIFTRA(DUP(Rt), SN(32, 16));
	RzILOpPure *op_AND_109 = LOGAND(op_RSHIFT_107, SN(32, 0xffff));
	RzILOpPure *op_MUL_112 = MUL(CAST(32, MSB(CAST(16, MSB(op_AND_101), DUP(op_AND_101))), CAST(16, MSB(DUP(op_AND_101)), DUP(op_AND_101))), CAST(32, MSB(CAST(16, MSB(op_AND_109), DUP(op_AND_109))), CAST(16, MSB(DUP(op_AND_109)), DUP(op_AND_109))));
	RzILOpPure *op_LSHIFT_115 = SHIFTL0(CAST(64, MSB(op_MUL_112), DUP(op_MUL_112)), SN(32, 1));
	RzILOpPure *op_ADD_116 = ADD(op_LSHIFT_95, op_LSHIFT_115);
	RzILOpPure *op_SUB_117 = SUB(CAST(64, MSB(CAST(32, MSB(op_AND_73), DUP(op_AND_73))), CAST(32, MSB(DUP(op_AND_73)), DUP(op_AND_73))), op_ADD_116);
	RzILOpPure *op_EQ_118 = EQ(SEXTRACT64(CAST(64, IL_FALSE, op_SUB_62), SN(32, 0), SN(32, 0x20)), op_SUB_117);
	RzILOpPure *op_RSHIFT_175 = SHIFTRA(READ_REG(pkt, Rxx_op, false), SN(32, 0x20));
	RzILOpPure *op_AND_177 = LOGAND(op_RSHIFT_175, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_183 = SHIFTRA(DUP(Rs), SN(32, 16));
	RzILOpPure *op_AND_185 = LOGAND(op_RSHIFT_183, SN(32, 0xffff));
	RzILOpPure *op_RSHIFT_191 = SHIFTRA(DUP(Rt), SN(32, 0));
	RzILOpPure *op_AND_193 = LOGAND(op_RSHIFT_191, SN(32, 0xffff));
	RzILOpPure *op_MUL_196 = MUL(CAST(32, MSB(CAST(16, MSB(op_AND_185), DUP(op_AND_185))), CAST(16, MSB(DUP(op_AND_185)), DUP(op_AND_185))), CAST(32, MSB(CAST(16, MSB(op_AND_193), DUP(op_AND_193))), CAST(16, MSB(DUP(op_AND_193)), DUP(op_AND_193))));
	RzILOpPure *op_LSHIFT_199 = SHIFTL0(CAST(64, MSB(op_MUL_196), DUP(op_MUL_196)), SN(32, 1));
	RzILOpPure *op_RSHIFT_203 = SHIFTRA(DUP(Rs), SN(32, 0));
	RzILOpPure *op_AND_205 = LOGAND(op_RSHIFT_203, SN(32, 0xffff));
	RzILOpPure *op_RSHIFT_211 = SHIFTRA(DUP(Rt), SN(32, 16));
	RzILOpPure *op_AND_213 = LOGAND(op_RSHIFT_211, SN(32, 0xffff));
	RzILOpPure *op_MUL_216 = MUL(CAST(32, MSB(CAST(16, MSB(op_AND_205), DUP(op_AND_205))), CAST(16, MSB(DUP(op_AND_205)), DUP(op_AND_205))), CAST(32, MSB(CAST(16, MSB(op_AND_213), DUP(op_AND_213))), CAST(16, MSB(DUP(op_AND_213)), DUP(op_AND_213))));
	RzILOpPure *op_LSHIFT_219 = SHIFTL0(CAST(64, MSB(op_MUL_216), DUP(op_MUL_216)), SN(32, 1));
	RzILOpPure *op_ADD_220 = ADD(op_LSHIFT_199, op_LSHIFT_219);
	RzILOpPure *op_SUB_221 = SUB(CAST(64, MSB(CAST(32, MSB(op_AND_177), DUP(op_AND_177))), CAST(32, MSB(DUP(op_AND_177)), DUP(op_AND_177))), op_ADD_220);
	RzILOpPure *op_LT_224 = SLT(op_SUB_221, CAST(64, MSB(SN(32, 0)), SN(32, 0)));
	RzILOpPure *op_LSHIFT_229 = SHIFTL0(SN(64, 1), SN(32, 31));
	RzILOpPure *op_NEG_230 = NEG(op_LSHIFT_229);
	RzILOpPure *op_LSHIFT_235 = SHIFTL0(SN(64, 1), SN(32, 31));
	RzILOpPure *op_SUB_238 = SUB(op_LSHIFT_235, CAST(64, MSB(SN(32, 1)), SN(32, 1)));
	RzILOpPure *cond_239 = ITE(op_LT_224, op_NEG_230, op_SUB_238);
	RzILOpEffect *gcc_expr_240 = BRANCH(op_EQ_118, EMPTY(), set_usr_field_call_171);

	// h_tmp258 = HYB(gcc_expr_if ((sextract64(((ut64) ((st64) ((st32) ((Rxx >> 0x20) & 0xffffffff))) - (((st64) ((st32) ((st16) ((Rs >> 0x10) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x0) & 0xffff)))) << 0x1) + (((st64) ((st32) ((st16) ((Rs >> 0x0) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x10) & 0xffff)))) << 0x1)), 0x0, 0x20) == ((st64) ((st32) ((Rxx >> 0x20) & 0xffffffff))) - (((st64) ((st32) ((st16) ((Rs >> 0x10) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x0) & 0xffff)))) << 0x1) + (((st64) ((st32) ((st16) ((Rs >> 0x0) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x10) & 0xffff)))) << 0x1))) {{}} else {set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, ((ut32) 0x1))}, ((((st64) ((st32) ((Rxx >> 0x20) & 0xffffffff))) - (((st64) ((st32) ((st16) ((Rs >> 0x10) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x0) & 0xffff)))) << 0x1) + (((st64) ((st32) ((st16) ((Rs >> 0x0) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x10) & 0xffff)))) << 0x1) < ((st64) 0x0)) ? (-(0x1 << 0x1f)) : (0x1 << 0x1f) - ((st64) 0x1)));
	RzILOpEffect *op_ASSIGN_hybrid_tmp_242 = SETL("h_tmp258", cond_239);

	// seq(HYB(gcc_expr_if ((sextract64(((ut64) ((st64) ((st32) ((Rxx > ...;
	RzILOpEffect *seq_243 = SEQN(2, gcc_expr_240, op_ASSIGN_hybrid_tmp_242);

	// Rxx = ((Rxx & (~(0xffffffff << 0x20))) | ((((sextract64(((ut64) ((st64) ((st32) ((Rxx >> 0x20) & 0xffffffff))) - (((st64) ((st32) ((st16) ((Rs >> 0x10) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x0) & 0xffff)))) << 0x1) + (((st64) ((st32) ((st16) ((Rs >> 0x0) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x10) & 0xffff)))) << 0x1)), 0x0, 0x20) == ((st64) ((st32) ((Rxx >> 0x20) & 0xffffffff))) - (((st64) ((st32) ((st16) ((Rs >> 0x10) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x0) & 0xffff)))) << 0x1) + (((st64) ((st32) ((st16) ((Rs >> 0x0) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x10) & 0xffff)))) << 0x1)) ? ((st64) ((st32) ((Rxx >> 0x20) & 0xffffffff))) - (((st64) ((st32) ((st16) ((Rs >> 0x10) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x0) & 0xffff)))) << 0x1) + (((st64) ((st32) ((st16) ((Rs >> 0x0) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x10) & 0xffff)))) << 0x1) : h_tmp258) & 0xffffffff) << 0x20));
	RzILOpPure *op_LSHIFT_5 = SHIFTL0(SN(64, 0xffffffff), SN(32, 0x20));
	RzILOpPure *op_NOT_6 = LOGNOT(op_LSHIFT_5);
	RzILOpPure *op_AND_7 = LOGAND(READ_REG(pkt, Rxx_op, false), op_NOT_6);
	RzILOpPure *op_RSHIFT_122 = SHIFTRA(READ_REG(pkt, Rxx_op, false), SN(32, 0x20));
	RzILOpPure *op_AND_124 = LOGAND(op_RSHIFT_122, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_130 = SHIFTRA(DUP(Rs), SN(32, 16));
	RzILOpPure *op_AND_132 = LOGAND(op_RSHIFT_130, SN(32, 0xffff));
	RzILOpPure *op_RSHIFT_138 = SHIFTRA(DUP(Rt), SN(32, 0));
	RzILOpPure *op_AND_140 = LOGAND(op_RSHIFT_138, SN(32, 0xffff));
	RzILOpPure *op_MUL_143 = MUL(CAST(32, MSB(CAST(16, MSB(op_AND_132), DUP(op_AND_132))), CAST(16, MSB(DUP(op_AND_132)), DUP(op_AND_132))), CAST(32, MSB(CAST(16, MSB(op_AND_140), DUP(op_AND_140))), CAST(16, MSB(DUP(op_AND_140)), DUP(op_AND_140))));
	RzILOpPure *op_LSHIFT_146 = SHIFTL0(CAST(64, MSB(op_MUL_143), DUP(op_MUL_143)), SN(32, 1));
	RzILOpPure *op_RSHIFT_150 = SHIFTRA(DUP(Rs), SN(32, 0));
	RzILOpPure *op_AND_152 = LOGAND(op_RSHIFT_150, SN(32, 0xffff));
	RzILOpPure *op_RSHIFT_158 = SHIFTRA(DUP(Rt), SN(32, 16));
	RzILOpPure *op_AND_160 = LOGAND(op_RSHIFT_158, SN(32, 0xffff));
	RzILOpPure *op_MUL_163 = MUL(CAST(32, MSB(CAST(16, MSB(op_AND_152), DUP(op_AND_152))), CAST(16, MSB(DUP(op_AND_152)), DUP(op_AND_152))), CAST(32, MSB(CAST(16, MSB(op_AND_160), DUP(op_AND_160))), CAST(16, MSB(DUP(op_AND_160)), DUP(op_AND_160))));
	RzILOpPure *op_LSHIFT_166 = SHIFTL0(CAST(64, MSB(op_MUL_163), DUP(op_MUL_163)), SN(32, 1));
	RzILOpPure *op_ADD_167 = ADD(op_LSHIFT_146, op_LSHIFT_166);
	RzILOpPure *op_SUB_168 = SUB(CAST(64, MSB(CAST(32, MSB(op_AND_124), DUP(op_AND_124))), CAST(32, MSB(DUP(op_AND_124)), DUP(op_AND_124))), op_ADD_167);
	RzILOpPure *cond_244 = ITE(DUP(op_EQ_118), op_SUB_168, VARL("h_tmp258"));
	RzILOpPure *op_AND_246 = LOGAND(cond_244, SN(64, 0xffffffff));
	RzILOpPure *op_LSHIFT_250 = SHIFTL0(op_AND_246, SN(32, 0x20));
	RzILOpPure *op_OR_251 = LOGOR(op_AND_7, op_LSHIFT_250);
	RzILOpEffect *op_ASSIGN_252 = WRITE_REG(bundle, Rxx_op, op_OR_251);

	// seq(seq(HYB(gcc_expr_if ((sextract64(((ut64) ((st64) ((st32) ((R ...;
	RzILOpEffect *seq_253 = SEQN(2, seq_243, op_ASSIGN_252);

	// set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, ((ut32) 0x1));
	RzILOpEffect *set_usr_field_call_423 = hex_set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, CAST(32, IL_FALSE, SN(32, 1)));

	// HYB(gcc_expr_if ((sextract64(((ut64) ((st64) ((st32) ((Rxx >> 0x0) & 0xffffffff))) - (((st64) ((st32) ((st16) ((Rs >> 0x0) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x0) & 0xffff)))) << 0x1) - (((st64) ((st32) ((st16) ((Rs >> 0x10) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x10) & 0xffff)))) << 0x1)), 0x0, 0x20) == ((st64) ((st32) ((Rxx >> 0x0) & 0xffffffff))) - (((st64) ((st32) ((st16) ((Rs >> 0x0) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x0) & 0xffff)))) << 0x1) - (((st64) ((st32) ((st16) ((Rs >> 0x10) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x10) & 0xffff)))) << 0x1))) {{}} else {set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, ((ut32) 0x1))}, ((((st64) ((st32) ((Rxx >> 0x0) & 0xffffffff))) - (((st64) ((st32) ((st16) ((Rs >> 0x0) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x0) & 0xffff)))) << 0x1) - (((st64) ((st32) ((st16) ((Rs >> 0x10) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x10) & 0xffff)))) << 0x1) < ((st64) 0x0)) ? (-(0x1 << 0x1f)) : (0x1 << 0x1f) - ((st64) 0x1)));
	RzILOpPure *op_RSHIFT_268 = SHIFTRA(READ_REG(pkt, Rxx_op, false), SN(32, 0));
	RzILOpPure *op_AND_270 = LOGAND(op_RSHIFT_268, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_276 = SHIFTRA(DUP(Rs), SN(32, 0));
	RzILOpPure *op_AND_278 = LOGAND(op_RSHIFT_276, SN(32, 0xffff));
	RzILOpPure *op_RSHIFT_284 = SHIFTRA(DUP(Rt), SN(32, 0));
	RzILOpPure *op_AND_286 = LOGAND(op_RSHIFT_284, SN(32, 0xffff));
	RzILOpPure *op_MUL_289 = MUL(CAST(32, MSB(CAST(16, MSB(op_AND_278), DUP(op_AND_278))), CAST(16, MSB(DUP(op_AND_278)), DUP(op_AND_278))), CAST(32, MSB(CAST(16, MSB(op_AND_286), DUP(op_AND_286))), CAST(16, MSB(DUP(op_AND_286)), DUP(op_AND_286))));
	RzILOpPure *op_LSHIFT_292 = SHIFTL0(CAST(64, MSB(op_MUL_289), DUP(op_MUL_289)), SN(32, 1));
	RzILOpPure *op_RSHIFT_296 = SHIFTRA(DUP(Rs), SN(32, 16));
	RzILOpPure *op_AND_298 = LOGAND(op_RSHIFT_296, SN(32, 0xffff));
	RzILOpPure *op_RSHIFT_304 = SHIFTRA(DUP(Rt), SN(32, 16));
	RzILOpPure *op_AND_306 = LOGAND(op_RSHIFT_304, SN(32, 0xffff));
	RzILOpPure *op_MUL_309 = MUL(CAST(32, MSB(CAST(16, MSB(op_AND_298), DUP(op_AND_298))), CAST(16, MSB(DUP(op_AND_298)), DUP(op_AND_298))), CAST(32, MSB(CAST(16, MSB(op_AND_306), DUP(op_AND_306))), CAST(16, MSB(DUP(op_AND_306)), DUP(op_AND_306))));
	RzILOpPure *op_LSHIFT_312 = SHIFTL0(CAST(64, MSB(op_MUL_309), DUP(op_MUL_309)), SN(32, 1));
	RzILOpPure *op_SUB_313 = SUB(op_LSHIFT_292, op_LSHIFT_312);
	RzILOpPure *op_SUB_314 = SUB(CAST(64, MSB(CAST(32, MSB(op_AND_270), DUP(op_AND_270))), CAST(32, MSB(DUP(op_AND_270)), DUP(op_AND_270))), op_SUB_313);
	RzILOpPure *op_RSHIFT_323 = SHIFTRA(READ_REG(pkt, Rxx_op, false), SN(32, 0));
	RzILOpPure *op_AND_325 = LOGAND(op_RSHIFT_323, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_331 = SHIFTRA(DUP(Rs), SN(32, 0));
	RzILOpPure *op_AND_333 = LOGAND(op_RSHIFT_331, SN(32, 0xffff));
	RzILOpPure *op_RSHIFT_339 = SHIFTRA(DUP(Rt), SN(32, 0));
	RzILOpPure *op_AND_341 = LOGAND(op_RSHIFT_339, SN(32, 0xffff));
	RzILOpPure *op_MUL_344 = MUL(CAST(32, MSB(CAST(16, MSB(op_AND_333), DUP(op_AND_333))), CAST(16, MSB(DUP(op_AND_333)), DUP(op_AND_333))), CAST(32, MSB(CAST(16, MSB(op_AND_341), DUP(op_AND_341))), CAST(16, MSB(DUP(op_AND_341)), DUP(op_AND_341))));
	RzILOpPure *op_LSHIFT_347 = SHIFTL0(CAST(64, MSB(op_MUL_344), DUP(op_MUL_344)), SN(32, 1));
	RzILOpPure *op_RSHIFT_351 = SHIFTRA(DUP(Rs), SN(32, 16));
	RzILOpPure *op_AND_353 = LOGAND(op_RSHIFT_351, SN(32, 0xffff));
	RzILOpPure *op_RSHIFT_359 = SHIFTRA(DUP(Rt), SN(32, 16));
	RzILOpPure *op_AND_361 = LOGAND(op_RSHIFT_359, SN(32, 0xffff));
	RzILOpPure *op_MUL_364 = MUL(CAST(32, MSB(CAST(16, MSB(op_AND_353), DUP(op_AND_353))), CAST(16, MSB(DUP(op_AND_353)), DUP(op_AND_353))), CAST(32, MSB(CAST(16, MSB(op_AND_361), DUP(op_AND_361))), CAST(16, MSB(DUP(op_AND_361)), DUP(op_AND_361))));
	RzILOpPure *op_LSHIFT_367 = SHIFTL0(CAST(64, MSB(op_MUL_364), DUP(op_MUL_364)), SN(32, 1));
	RzILOpPure *op_SUB_368 = SUB(op_LSHIFT_347, op_LSHIFT_367);
	RzILOpPure *op_SUB_369 = SUB(CAST(64, MSB(CAST(32, MSB(op_AND_325), DUP(op_AND_325))), CAST(32, MSB(DUP(op_AND_325)), DUP(op_AND_325))), op_SUB_368);
	RzILOpPure *op_EQ_370 = EQ(SEXTRACT64(CAST(64, IL_FALSE, op_SUB_314), SN(32, 0), SN(32, 0x20)), op_SUB_369);
	RzILOpPure *op_RSHIFT_427 = SHIFTRA(READ_REG(pkt, Rxx_op, false), SN(32, 0));
	RzILOpPure *op_AND_429 = LOGAND(op_RSHIFT_427, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_435 = SHIFTRA(DUP(Rs), SN(32, 0));
	RzILOpPure *op_AND_437 = LOGAND(op_RSHIFT_435, SN(32, 0xffff));
	RzILOpPure *op_RSHIFT_443 = SHIFTRA(DUP(Rt), SN(32, 0));
	RzILOpPure *op_AND_445 = LOGAND(op_RSHIFT_443, SN(32, 0xffff));
	RzILOpPure *op_MUL_448 = MUL(CAST(32, MSB(CAST(16, MSB(op_AND_437), DUP(op_AND_437))), CAST(16, MSB(DUP(op_AND_437)), DUP(op_AND_437))), CAST(32, MSB(CAST(16, MSB(op_AND_445), DUP(op_AND_445))), CAST(16, MSB(DUP(op_AND_445)), DUP(op_AND_445))));
	RzILOpPure *op_LSHIFT_451 = SHIFTL0(CAST(64, MSB(op_MUL_448), DUP(op_MUL_448)), SN(32, 1));
	RzILOpPure *op_RSHIFT_455 = SHIFTRA(DUP(Rs), SN(32, 16));
	RzILOpPure *op_AND_457 = LOGAND(op_RSHIFT_455, SN(32, 0xffff));
	RzILOpPure *op_RSHIFT_463 = SHIFTRA(DUP(Rt), SN(32, 16));
	RzILOpPure *op_AND_465 = LOGAND(op_RSHIFT_463, SN(32, 0xffff));
	RzILOpPure *op_MUL_468 = MUL(CAST(32, MSB(CAST(16, MSB(op_AND_457), DUP(op_AND_457))), CAST(16, MSB(DUP(op_AND_457)), DUP(op_AND_457))), CAST(32, MSB(CAST(16, MSB(op_AND_465), DUP(op_AND_465))), CAST(16, MSB(DUP(op_AND_465)), DUP(op_AND_465))));
	RzILOpPure *op_LSHIFT_471 = SHIFTL0(CAST(64, MSB(op_MUL_468), DUP(op_MUL_468)), SN(32, 1));
	RzILOpPure *op_SUB_472 = SUB(op_LSHIFT_451, op_LSHIFT_471);
	RzILOpPure *op_SUB_473 = SUB(CAST(64, MSB(CAST(32, MSB(op_AND_429), DUP(op_AND_429))), CAST(32, MSB(DUP(op_AND_429)), DUP(op_AND_429))), op_SUB_472);
	RzILOpPure *op_LT_476 = SLT(op_SUB_473, CAST(64, MSB(SN(32, 0)), SN(32, 0)));
	RzILOpPure *op_LSHIFT_481 = SHIFTL0(SN(64, 1), SN(32, 31));
	RzILOpPure *op_NEG_482 = NEG(op_LSHIFT_481);
	RzILOpPure *op_LSHIFT_487 = SHIFTL0(SN(64, 1), SN(32, 31));
	RzILOpPure *op_SUB_490 = SUB(op_LSHIFT_487, CAST(64, MSB(SN(32, 1)), SN(32, 1)));
	RzILOpPure *cond_491 = ITE(op_LT_476, op_NEG_482, op_SUB_490);
	RzILOpEffect *gcc_expr_492 = BRANCH(op_EQ_370, EMPTY(), set_usr_field_call_423);

	// h_tmp259 = HYB(gcc_expr_if ((sextract64(((ut64) ((st64) ((st32) ((Rxx >> 0x0) & 0xffffffff))) - (((st64) ((st32) ((st16) ((Rs >> 0x0) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x0) & 0xffff)))) << 0x1) - (((st64) ((st32) ((st16) ((Rs >> 0x10) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x10) & 0xffff)))) << 0x1)), 0x0, 0x20) == ((st64) ((st32) ((Rxx >> 0x0) & 0xffffffff))) - (((st64) ((st32) ((st16) ((Rs >> 0x0) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x0) & 0xffff)))) << 0x1) - (((st64) ((st32) ((st16) ((Rs >> 0x10) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x10) & 0xffff)))) << 0x1))) {{}} else {set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, ((ut32) 0x1))}, ((((st64) ((st32) ((Rxx >> 0x0) & 0xffffffff))) - (((st64) ((st32) ((st16) ((Rs >> 0x0) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x0) & 0xffff)))) << 0x1) - (((st64) ((st32) ((st16) ((Rs >> 0x10) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x10) & 0xffff)))) << 0x1) < ((st64) 0x0)) ? (-(0x1 << 0x1f)) : (0x1 << 0x1f) - ((st64) 0x1)));
	RzILOpEffect *op_ASSIGN_hybrid_tmp_494 = SETL("h_tmp259", cond_491);

	// seq(HYB(gcc_expr_if ((sextract64(((ut64) ((st64) ((st32) ((Rxx > ...;
	RzILOpEffect *seq_495 = SEQN(2, gcc_expr_492, op_ASSIGN_hybrid_tmp_494);

	// Rxx = ((Rxx & (~(0xffffffff << 0x0))) | ((((sextract64(((ut64) ((st64) ((st32) ((Rxx >> 0x0) & 0xffffffff))) - (((st64) ((st32) ((st16) ((Rs >> 0x0) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x0) & 0xffff)))) << 0x1) - (((st64) ((st32) ((st16) ((Rs >> 0x10) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x10) & 0xffff)))) << 0x1)), 0x0, 0x20) == ((st64) ((st32) ((Rxx >> 0x0) & 0xffffffff))) - (((st64) ((st32) ((st16) ((Rs >> 0x0) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x0) & 0xffff)))) << 0x1) - (((st64) ((st32) ((st16) ((Rs >> 0x10) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x10) & 0xffff)))) << 0x1)) ? ((st64) ((st32) ((Rxx >> 0x0) & 0xffffffff))) - (((st64) ((st32) ((st16) ((Rs >> 0x0) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x0) & 0xffff)))) << 0x1) - (((st64) ((st32) ((st16) ((Rs >> 0x10) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x10) & 0xffff)))) << 0x1) : h_tmp259) & 0xffffffff) << 0x0));
	RzILOpPure *op_LSHIFT_259 = SHIFTL0(SN(64, 0xffffffff), SN(32, 0));
	RzILOpPure *op_NOT_260 = LOGNOT(op_LSHIFT_259);
	RzILOpPure *op_AND_261 = LOGAND(READ_REG(pkt, Rxx_op, false), op_NOT_260);
	RzILOpPure *op_RSHIFT_374 = SHIFTRA(READ_REG(pkt, Rxx_op, false), SN(32, 0));
	RzILOpPure *op_AND_376 = LOGAND(op_RSHIFT_374, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_382 = SHIFTRA(DUP(Rs), SN(32, 0));
	RzILOpPure *op_AND_384 = LOGAND(op_RSHIFT_382, SN(32, 0xffff));
	RzILOpPure *op_RSHIFT_390 = SHIFTRA(DUP(Rt), SN(32, 0));
	RzILOpPure *op_AND_392 = LOGAND(op_RSHIFT_390, SN(32, 0xffff));
	RzILOpPure *op_MUL_395 = MUL(CAST(32, MSB(CAST(16, MSB(op_AND_384), DUP(op_AND_384))), CAST(16, MSB(DUP(op_AND_384)), DUP(op_AND_384))), CAST(32, MSB(CAST(16, MSB(op_AND_392), DUP(op_AND_392))), CAST(16, MSB(DUP(op_AND_392)), DUP(op_AND_392))));
	RzILOpPure *op_LSHIFT_398 = SHIFTL0(CAST(64, MSB(op_MUL_395), DUP(op_MUL_395)), SN(32, 1));
	RzILOpPure *op_RSHIFT_402 = SHIFTRA(DUP(Rs), SN(32, 16));
	RzILOpPure *op_AND_404 = LOGAND(op_RSHIFT_402, SN(32, 0xffff));
	RzILOpPure *op_RSHIFT_410 = SHIFTRA(DUP(Rt), SN(32, 16));
	RzILOpPure *op_AND_412 = LOGAND(op_RSHIFT_410, SN(32, 0xffff));
	RzILOpPure *op_MUL_415 = MUL(CAST(32, MSB(CAST(16, MSB(op_AND_404), DUP(op_AND_404))), CAST(16, MSB(DUP(op_AND_404)), DUP(op_AND_404))), CAST(32, MSB(CAST(16, MSB(op_AND_412), DUP(op_AND_412))), CAST(16, MSB(DUP(op_AND_412)), DUP(op_AND_412))));
	RzILOpPure *op_LSHIFT_418 = SHIFTL0(CAST(64, MSB(op_MUL_415), DUP(op_MUL_415)), SN(32, 1));
	RzILOpPure *op_SUB_419 = SUB(op_LSHIFT_398, op_LSHIFT_418);
	RzILOpPure *op_SUB_420 = SUB(CAST(64, MSB(CAST(32, MSB(op_AND_376), DUP(op_AND_376))), CAST(32, MSB(DUP(op_AND_376)), DUP(op_AND_376))), op_SUB_419);
	RzILOpPure *cond_496 = ITE(DUP(op_EQ_370), op_SUB_420, VARL("h_tmp259"));
	RzILOpPure *op_AND_498 = LOGAND(cond_496, SN(64, 0xffffffff));
	RzILOpPure *op_LSHIFT_502 = SHIFTL0(op_AND_498, SN(32, 0));
	RzILOpPure *op_OR_503 = LOGOR(op_AND_261, op_LSHIFT_502);
	RzILOpEffect *op_ASSIGN_504 = WRITE_REG(bundle, Rxx_op, op_OR_503);

	// seq(seq(HYB(gcc_expr_if ((sextract64(((ut64) ((st64) ((st32) ((R ...;
	RzILOpEffect *seq_505 = SEQN(2, seq_495, op_ASSIGN_504);

	RzILOpEffect *instruction_sequence = SEQN(2, seq_253, seq_505);
	return instruction_sequence;
}

// Rxx -= cmpy(Rs,Rt*):sat
RzILOpEffect *hex_il_op_m2_cnacsc_s0(HexInsnPktBundle *bundle) {
	const HexInsn *hi = bundle->insn;
	HexPkt *pkt = bundle->pkt;
	// READ
	const HexOp *Rxx_op = ISA2REG(hi, 'x', false);

	const HexOp *Rs_op = ISA2REG(hi, 's', false);
	RzILOpPure *Rs = READ_REG(pkt, Rs_op, false);
	const HexOp *Rt_op = ISA2REG(hi, 't', false);
	RzILOpPure *Rt = READ_REG(pkt, Rt_op, false);

	// set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, ((ut32) 0x1));
	RzILOpEffect *set_usr_field_call_171 = hex_set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, CAST(32, IL_FALSE, SN(32, 1)));

	// HYB(gcc_expr_if ((sextract64(((ut64) ((st64) ((st32) ((Rxx >> 0x20) & 0xffffffff))) - (((st64) ((st32) ((st16) ((Rs >> 0x10) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x0) & 0xffff)))) << 0x0) - (((st64) ((st32) ((st16) ((Rs >> 0x0) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x10) & 0xffff)))) << 0x0)), 0x0, 0x20) == ((st64) ((st32) ((Rxx >> 0x20) & 0xffffffff))) - (((st64) ((st32) ((st16) ((Rs >> 0x10) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x0) & 0xffff)))) << 0x0) - (((st64) ((st32) ((st16) ((Rs >> 0x0) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x10) & 0xffff)))) << 0x0))) {{}} else {set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, ((ut32) 0x1))}, ((((st64) ((st32) ((Rxx >> 0x20) & 0xffffffff))) - (((st64) ((st32) ((st16) ((Rs >> 0x10) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x0) & 0xffff)))) << 0x0) - (((st64) ((st32) ((st16) ((Rs >> 0x0) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x10) & 0xffff)))) << 0x0) < ((st64) 0x0)) ? (-(0x1 << 0x1f)) : (0x1 << 0x1f) - ((st64) 0x1)));
	RzILOpPure *op_RSHIFT_14 = SHIFTRA(READ_REG(pkt, Rxx_op, false), SN(32, 0x20));
	RzILOpPure *op_AND_16 = LOGAND(op_RSHIFT_14, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_23 = SHIFTRA(Rs, SN(32, 16));
	RzILOpPure *op_AND_25 = LOGAND(op_RSHIFT_23, SN(32, 0xffff));
	RzILOpPure *op_RSHIFT_32 = SHIFTRA(Rt, SN(32, 0));
	RzILOpPure *op_AND_34 = LOGAND(op_RSHIFT_32, SN(32, 0xffff));
	RzILOpPure *op_MUL_37 = MUL(CAST(32, MSB(CAST(16, MSB(op_AND_25), DUP(op_AND_25))), CAST(16, MSB(DUP(op_AND_25)), DUP(op_AND_25))), CAST(32, MSB(CAST(16, MSB(op_AND_34), DUP(op_AND_34))), CAST(16, MSB(DUP(op_AND_34)), DUP(op_AND_34))));
	RzILOpPure *op_LSHIFT_40 = SHIFTL0(CAST(64, MSB(op_MUL_37), DUP(op_MUL_37)), SN(32, 0));
	RzILOpPure *op_RSHIFT_44 = SHIFTRA(DUP(Rs), SN(32, 0));
	RzILOpPure *op_AND_46 = LOGAND(op_RSHIFT_44, SN(32, 0xffff));
	RzILOpPure *op_RSHIFT_52 = SHIFTRA(DUP(Rt), SN(32, 16));
	RzILOpPure *op_AND_54 = LOGAND(op_RSHIFT_52, SN(32, 0xffff));
	RzILOpPure *op_MUL_57 = MUL(CAST(32, MSB(CAST(16, MSB(op_AND_46), DUP(op_AND_46))), CAST(16, MSB(DUP(op_AND_46)), DUP(op_AND_46))), CAST(32, MSB(CAST(16, MSB(op_AND_54), DUP(op_AND_54))), CAST(16, MSB(DUP(op_AND_54)), DUP(op_AND_54))));
	RzILOpPure *op_LSHIFT_60 = SHIFTL0(CAST(64, MSB(op_MUL_57), DUP(op_MUL_57)), SN(32, 0));
	RzILOpPure *op_SUB_61 = SUB(op_LSHIFT_40, op_LSHIFT_60);
	RzILOpPure *op_SUB_62 = SUB(CAST(64, MSB(CAST(32, MSB(op_AND_16), DUP(op_AND_16))), CAST(32, MSB(DUP(op_AND_16)), DUP(op_AND_16))), op_SUB_61);
	RzILOpPure *op_RSHIFT_71 = SHIFTRA(READ_REG(pkt, Rxx_op, false), SN(32, 0x20));
	RzILOpPure *op_AND_73 = LOGAND(op_RSHIFT_71, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_79 = SHIFTRA(DUP(Rs), SN(32, 16));
	RzILOpPure *op_AND_81 = LOGAND(op_RSHIFT_79, SN(32, 0xffff));
	RzILOpPure *op_RSHIFT_87 = SHIFTRA(DUP(Rt), SN(32, 0));
	RzILOpPure *op_AND_89 = LOGAND(op_RSHIFT_87, SN(32, 0xffff));
	RzILOpPure *op_MUL_92 = MUL(CAST(32, MSB(CAST(16, MSB(op_AND_81), DUP(op_AND_81))), CAST(16, MSB(DUP(op_AND_81)), DUP(op_AND_81))), CAST(32, MSB(CAST(16, MSB(op_AND_89), DUP(op_AND_89))), CAST(16, MSB(DUP(op_AND_89)), DUP(op_AND_89))));
	RzILOpPure *op_LSHIFT_95 = SHIFTL0(CAST(64, MSB(op_MUL_92), DUP(op_MUL_92)), SN(32, 0));
	RzILOpPure *op_RSHIFT_99 = SHIFTRA(DUP(Rs), SN(32, 0));
	RzILOpPure *op_AND_101 = LOGAND(op_RSHIFT_99, SN(32, 0xffff));
	RzILOpPure *op_RSHIFT_107 = SHIFTRA(DUP(Rt), SN(32, 16));
	RzILOpPure *op_AND_109 = LOGAND(op_RSHIFT_107, SN(32, 0xffff));
	RzILOpPure *op_MUL_112 = MUL(CAST(32, MSB(CAST(16, MSB(op_AND_101), DUP(op_AND_101))), CAST(16, MSB(DUP(op_AND_101)), DUP(op_AND_101))), CAST(32, MSB(CAST(16, MSB(op_AND_109), DUP(op_AND_109))), CAST(16, MSB(DUP(op_AND_109)), DUP(op_AND_109))));
	RzILOpPure *op_LSHIFT_115 = SHIFTL0(CAST(64, MSB(op_MUL_112), DUP(op_MUL_112)), SN(32, 0));
	RzILOpPure *op_SUB_116 = SUB(op_LSHIFT_95, op_LSHIFT_115);
	RzILOpPure *op_SUB_117 = SUB(CAST(64, MSB(CAST(32, MSB(op_AND_73), DUP(op_AND_73))), CAST(32, MSB(DUP(op_AND_73)), DUP(op_AND_73))), op_SUB_116);
	RzILOpPure *op_EQ_118 = EQ(SEXTRACT64(CAST(64, IL_FALSE, op_SUB_62), SN(32, 0), SN(32, 0x20)), op_SUB_117);
	RzILOpPure *op_RSHIFT_175 = SHIFTRA(READ_REG(pkt, Rxx_op, false), SN(32, 0x20));
	RzILOpPure *op_AND_177 = LOGAND(op_RSHIFT_175, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_183 = SHIFTRA(DUP(Rs), SN(32, 16));
	RzILOpPure *op_AND_185 = LOGAND(op_RSHIFT_183, SN(32, 0xffff));
	RzILOpPure *op_RSHIFT_191 = SHIFTRA(DUP(Rt), SN(32, 0));
	RzILOpPure *op_AND_193 = LOGAND(op_RSHIFT_191, SN(32, 0xffff));
	RzILOpPure *op_MUL_196 = MUL(CAST(32, MSB(CAST(16, MSB(op_AND_185), DUP(op_AND_185))), CAST(16, MSB(DUP(op_AND_185)), DUP(op_AND_185))), CAST(32, MSB(CAST(16, MSB(op_AND_193), DUP(op_AND_193))), CAST(16, MSB(DUP(op_AND_193)), DUP(op_AND_193))));
	RzILOpPure *op_LSHIFT_199 = SHIFTL0(CAST(64, MSB(op_MUL_196), DUP(op_MUL_196)), SN(32, 0));
	RzILOpPure *op_RSHIFT_203 = SHIFTRA(DUP(Rs), SN(32, 0));
	RzILOpPure *op_AND_205 = LOGAND(op_RSHIFT_203, SN(32, 0xffff));
	RzILOpPure *op_RSHIFT_211 = SHIFTRA(DUP(Rt), SN(32, 16));
	RzILOpPure *op_AND_213 = LOGAND(op_RSHIFT_211, SN(32, 0xffff));
	RzILOpPure *op_MUL_216 = MUL(CAST(32, MSB(CAST(16, MSB(op_AND_205), DUP(op_AND_205))), CAST(16, MSB(DUP(op_AND_205)), DUP(op_AND_205))), CAST(32, MSB(CAST(16, MSB(op_AND_213), DUP(op_AND_213))), CAST(16, MSB(DUP(op_AND_213)), DUP(op_AND_213))));
	RzILOpPure *op_LSHIFT_219 = SHIFTL0(CAST(64, MSB(op_MUL_216), DUP(op_MUL_216)), SN(32, 0));
	RzILOpPure *op_SUB_220 = SUB(op_LSHIFT_199, op_LSHIFT_219);
	RzILOpPure *op_SUB_221 = SUB(CAST(64, MSB(CAST(32, MSB(op_AND_177), DUP(op_AND_177))), CAST(32, MSB(DUP(op_AND_177)), DUP(op_AND_177))), op_SUB_220);
	RzILOpPure *op_LT_224 = SLT(op_SUB_221, CAST(64, MSB(SN(32, 0)), SN(32, 0)));
	RzILOpPure *op_LSHIFT_229 = SHIFTL0(SN(64, 1), SN(32, 31));
	RzILOpPure *op_NEG_230 = NEG(op_LSHIFT_229);
	RzILOpPure *op_LSHIFT_235 = SHIFTL0(SN(64, 1), SN(32, 31));
	RzILOpPure *op_SUB_238 = SUB(op_LSHIFT_235, CAST(64, MSB(SN(32, 1)), SN(32, 1)));
	RzILOpPure *cond_239 = ITE(op_LT_224, op_NEG_230, op_SUB_238);
	RzILOpEffect *gcc_expr_240 = BRANCH(op_EQ_118, EMPTY(), set_usr_field_call_171);

	// h_tmp260 = HYB(gcc_expr_if ((sextract64(((ut64) ((st64) ((st32) ((Rxx >> 0x20) & 0xffffffff))) - (((st64) ((st32) ((st16) ((Rs >> 0x10) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x0) & 0xffff)))) << 0x0) - (((st64) ((st32) ((st16) ((Rs >> 0x0) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x10) & 0xffff)))) << 0x0)), 0x0, 0x20) == ((st64) ((st32) ((Rxx >> 0x20) & 0xffffffff))) - (((st64) ((st32) ((st16) ((Rs >> 0x10) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x0) & 0xffff)))) << 0x0) - (((st64) ((st32) ((st16) ((Rs >> 0x0) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x10) & 0xffff)))) << 0x0))) {{}} else {set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, ((ut32) 0x1))}, ((((st64) ((st32) ((Rxx >> 0x20) & 0xffffffff))) - (((st64) ((st32) ((st16) ((Rs >> 0x10) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x0) & 0xffff)))) << 0x0) - (((st64) ((st32) ((st16) ((Rs >> 0x0) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x10) & 0xffff)))) << 0x0) < ((st64) 0x0)) ? (-(0x1 << 0x1f)) : (0x1 << 0x1f) - ((st64) 0x1)));
	RzILOpEffect *op_ASSIGN_hybrid_tmp_242 = SETL("h_tmp260", cond_239);

	// seq(HYB(gcc_expr_if ((sextract64(((ut64) ((st64) ((st32) ((Rxx > ...;
	RzILOpEffect *seq_243 = SEQN(2, gcc_expr_240, op_ASSIGN_hybrid_tmp_242);

	// Rxx = ((Rxx & (~(0xffffffff << 0x20))) | ((((sextract64(((ut64) ((st64) ((st32) ((Rxx >> 0x20) & 0xffffffff))) - (((st64) ((st32) ((st16) ((Rs >> 0x10) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x0) & 0xffff)))) << 0x0) - (((st64) ((st32) ((st16) ((Rs >> 0x0) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x10) & 0xffff)))) << 0x0)), 0x0, 0x20) == ((st64) ((st32) ((Rxx >> 0x20) & 0xffffffff))) - (((st64) ((st32) ((st16) ((Rs >> 0x10) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x0) & 0xffff)))) << 0x0) - (((st64) ((st32) ((st16) ((Rs >> 0x0) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x10) & 0xffff)))) << 0x0)) ? ((st64) ((st32) ((Rxx >> 0x20) & 0xffffffff))) - (((st64) ((st32) ((st16) ((Rs >> 0x10) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x0) & 0xffff)))) << 0x0) - (((st64) ((st32) ((st16) ((Rs >> 0x0) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x10) & 0xffff)))) << 0x0) : h_tmp260) & 0xffffffff) << 0x20));
	RzILOpPure *op_LSHIFT_5 = SHIFTL0(SN(64, 0xffffffff), SN(32, 0x20));
	RzILOpPure *op_NOT_6 = LOGNOT(op_LSHIFT_5);
	RzILOpPure *op_AND_7 = LOGAND(READ_REG(pkt, Rxx_op, false), op_NOT_6);
	RzILOpPure *op_RSHIFT_122 = SHIFTRA(READ_REG(pkt, Rxx_op, false), SN(32, 0x20));
	RzILOpPure *op_AND_124 = LOGAND(op_RSHIFT_122, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_130 = SHIFTRA(DUP(Rs), SN(32, 16));
	RzILOpPure *op_AND_132 = LOGAND(op_RSHIFT_130, SN(32, 0xffff));
	RzILOpPure *op_RSHIFT_138 = SHIFTRA(DUP(Rt), SN(32, 0));
	RzILOpPure *op_AND_140 = LOGAND(op_RSHIFT_138, SN(32, 0xffff));
	RzILOpPure *op_MUL_143 = MUL(CAST(32, MSB(CAST(16, MSB(op_AND_132), DUP(op_AND_132))), CAST(16, MSB(DUP(op_AND_132)), DUP(op_AND_132))), CAST(32, MSB(CAST(16, MSB(op_AND_140), DUP(op_AND_140))), CAST(16, MSB(DUP(op_AND_140)), DUP(op_AND_140))));
	RzILOpPure *op_LSHIFT_146 = SHIFTL0(CAST(64, MSB(op_MUL_143), DUP(op_MUL_143)), SN(32, 0));
	RzILOpPure *op_RSHIFT_150 = SHIFTRA(DUP(Rs), SN(32, 0));
	RzILOpPure *op_AND_152 = LOGAND(op_RSHIFT_150, SN(32, 0xffff));
	RzILOpPure *op_RSHIFT_158 = SHIFTRA(DUP(Rt), SN(32, 16));
	RzILOpPure *op_AND_160 = LOGAND(op_RSHIFT_158, SN(32, 0xffff));
	RzILOpPure *op_MUL_163 = MUL(CAST(32, MSB(CAST(16, MSB(op_AND_152), DUP(op_AND_152))), CAST(16, MSB(DUP(op_AND_152)), DUP(op_AND_152))), CAST(32, MSB(CAST(16, MSB(op_AND_160), DUP(op_AND_160))), CAST(16, MSB(DUP(op_AND_160)), DUP(op_AND_160))));
	RzILOpPure *op_LSHIFT_166 = SHIFTL0(CAST(64, MSB(op_MUL_163), DUP(op_MUL_163)), SN(32, 0));
	RzILOpPure *op_SUB_167 = SUB(op_LSHIFT_146, op_LSHIFT_166);
	RzILOpPure *op_SUB_168 = SUB(CAST(64, MSB(CAST(32, MSB(op_AND_124), DUP(op_AND_124))), CAST(32, MSB(DUP(op_AND_124)), DUP(op_AND_124))), op_SUB_167);
	RzILOpPure *cond_244 = ITE(DUP(op_EQ_118), op_SUB_168, VARL("h_tmp260"));
	RzILOpPure *op_AND_246 = LOGAND(cond_244, SN(64, 0xffffffff));
	RzILOpPure *op_LSHIFT_250 = SHIFTL0(op_AND_246, SN(32, 0x20));
	RzILOpPure *op_OR_251 = LOGOR(op_AND_7, op_LSHIFT_250);
	RzILOpEffect *op_ASSIGN_252 = WRITE_REG(bundle, Rxx_op, op_OR_251);

	// seq(seq(HYB(gcc_expr_if ((sextract64(((ut64) ((st64) ((st32) ((R ...;
	RzILOpEffect *seq_253 = SEQN(2, seq_243, op_ASSIGN_252);

	// set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, ((ut32) 0x1));
	RzILOpEffect *set_usr_field_call_423 = hex_set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, CAST(32, IL_FALSE, SN(32, 1)));

	// HYB(gcc_expr_if ((sextract64(((ut64) ((st64) ((st32) ((Rxx >> 0x0) & 0xffffffff))) - (((st64) ((st32) ((st16) ((Rs >> 0x0) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x0) & 0xffff)))) << 0x0) + (((st64) ((st32) ((st16) ((Rs >> 0x10) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x10) & 0xffff)))) << 0x0)), 0x0, 0x20) == ((st64) ((st32) ((Rxx >> 0x0) & 0xffffffff))) - (((st64) ((st32) ((st16) ((Rs >> 0x0) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x0) & 0xffff)))) << 0x0) + (((st64) ((st32) ((st16) ((Rs >> 0x10) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x10) & 0xffff)))) << 0x0))) {{}} else {set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, ((ut32) 0x1))}, ((((st64) ((st32) ((Rxx >> 0x0) & 0xffffffff))) - (((st64) ((st32) ((st16) ((Rs >> 0x0) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x0) & 0xffff)))) << 0x0) + (((st64) ((st32) ((st16) ((Rs >> 0x10) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x10) & 0xffff)))) << 0x0) < ((st64) 0x0)) ? (-(0x1 << 0x1f)) : (0x1 << 0x1f) - ((st64) 0x1)));
	RzILOpPure *op_RSHIFT_268 = SHIFTRA(READ_REG(pkt, Rxx_op, false), SN(32, 0));
	RzILOpPure *op_AND_270 = LOGAND(op_RSHIFT_268, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_276 = SHIFTRA(DUP(Rs), SN(32, 0));
	RzILOpPure *op_AND_278 = LOGAND(op_RSHIFT_276, SN(32, 0xffff));
	RzILOpPure *op_RSHIFT_284 = SHIFTRA(DUP(Rt), SN(32, 0));
	RzILOpPure *op_AND_286 = LOGAND(op_RSHIFT_284, SN(32, 0xffff));
	RzILOpPure *op_MUL_289 = MUL(CAST(32, MSB(CAST(16, MSB(op_AND_278), DUP(op_AND_278))), CAST(16, MSB(DUP(op_AND_278)), DUP(op_AND_278))), CAST(32, MSB(CAST(16, MSB(op_AND_286), DUP(op_AND_286))), CAST(16, MSB(DUP(op_AND_286)), DUP(op_AND_286))));
	RzILOpPure *op_LSHIFT_292 = SHIFTL0(CAST(64, MSB(op_MUL_289), DUP(op_MUL_289)), SN(32, 0));
	RzILOpPure *op_RSHIFT_296 = SHIFTRA(DUP(Rs), SN(32, 16));
	RzILOpPure *op_AND_298 = LOGAND(op_RSHIFT_296, SN(32, 0xffff));
	RzILOpPure *op_RSHIFT_304 = SHIFTRA(DUP(Rt), SN(32, 16));
	RzILOpPure *op_AND_306 = LOGAND(op_RSHIFT_304, SN(32, 0xffff));
	RzILOpPure *op_MUL_309 = MUL(CAST(32, MSB(CAST(16, MSB(op_AND_298), DUP(op_AND_298))), CAST(16, MSB(DUP(op_AND_298)), DUP(op_AND_298))), CAST(32, MSB(CAST(16, MSB(op_AND_306), DUP(op_AND_306))), CAST(16, MSB(DUP(op_AND_306)), DUP(op_AND_306))));
	RzILOpPure *op_LSHIFT_312 = SHIFTL0(CAST(64, MSB(op_MUL_309), DUP(op_MUL_309)), SN(32, 0));
	RzILOpPure *op_ADD_313 = ADD(op_LSHIFT_292, op_LSHIFT_312);
	RzILOpPure *op_SUB_314 = SUB(CAST(64, MSB(CAST(32, MSB(op_AND_270), DUP(op_AND_270))), CAST(32, MSB(DUP(op_AND_270)), DUP(op_AND_270))), op_ADD_313);
	RzILOpPure *op_RSHIFT_323 = SHIFTRA(READ_REG(pkt, Rxx_op, false), SN(32, 0));
	RzILOpPure *op_AND_325 = LOGAND(op_RSHIFT_323, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_331 = SHIFTRA(DUP(Rs), SN(32, 0));
	RzILOpPure *op_AND_333 = LOGAND(op_RSHIFT_331, SN(32, 0xffff));
	RzILOpPure *op_RSHIFT_339 = SHIFTRA(DUP(Rt), SN(32, 0));
	RzILOpPure *op_AND_341 = LOGAND(op_RSHIFT_339, SN(32, 0xffff));
	RzILOpPure *op_MUL_344 = MUL(CAST(32, MSB(CAST(16, MSB(op_AND_333), DUP(op_AND_333))), CAST(16, MSB(DUP(op_AND_333)), DUP(op_AND_333))), CAST(32, MSB(CAST(16, MSB(op_AND_341), DUP(op_AND_341))), CAST(16, MSB(DUP(op_AND_341)), DUP(op_AND_341))));
	RzILOpPure *op_LSHIFT_347 = SHIFTL0(CAST(64, MSB(op_MUL_344), DUP(op_MUL_344)), SN(32, 0));
	RzILOpPure *op_RSHIFT_351 = SHIFTRA(DUP(Rs), SN(32, 16));
	RzILOpPure *op_AND_353 = LOGAND(op_RSHIFT_351, SN(32, 0xffff));
	RzILOpPure *op_RSHIFT_359 = SHIFTRA(DUP(Rt), SN(32, 16));
	RzILOpPure *op_AND_361 = LOGAND(op_RSHIFT_359, SN(32, 0xffff));
	RzILOpPure *op_MUL_364 = MUL(CAST(32, MSB(CAST(16, MSB(op_AND_353), DUP(op_AND_353))), CAST(16, MSB(DUP(op_AND_353)), DUP(op_AND_353))), CAST(32, MSB(CAST(16, MSB(op_AND_361), DUP(op_AND_361))), CAST(16, MSB(DUP(op_AND_361)), DUP(op_AND_361))));
	RzILOpPure *op_LSHIFT_367 = SHIFTL0(CAST(64, MSB(op_MUL_364), DUP(op_MUL_364)), SN(32, 0));
	RzILOpPure *op_ADD_368 = ADD(op_LSHIFT_347, op_LSHIFT_367);
	RzILOpPure *op_SUB_369 = SUB(CAST(64, MSB(CAST(32, MSB(op_AND_325), DUP(op_AND_325))), CAST(32, MSB(DUP(op_AND_325)), DUP(op_AND_325))), op_ADD_368);
	RzILOpPure *op_EQ_370 = EQ(SEXTRACT64(CAST(64, IL_FALSE, op_SUB_314), SN(32, 0), SN(32, 0x20)), op_SUB_369);
	RzILOpPure *op_RSHIFT_427 = SHIFTRA(READ_REG(pkt, Rxx_op, false), SN(32, 0));
	RzILOpPure *op_AND_429 = LOGAND(op_RSHIFT_427, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_435 = SHIFTRA(DUP(Rs), SN(32, 0));
	RzILOpPure *op_AND_437 = LOGAND(op_RSHIFT_435, SN(32, 0xffff));
	RzILOpPure *op_RSHIFT_443 = SHIFTRA(DUP(Rt), SN(32, 0));
	RzILOpPure *op_AND_445 = LOGAND(op_RSHIFT_443, SN(32, 0xffff));
	RzILOpPure *op_MUL_448 = MUL(CAST(32, MSB(CAST(16, MSB(op_AND_437), DUP(op_AND_437))), CAST(16, MSB(DUP(op_AND_437)), DUP(op_AND_437))), CAST(32, MSB(CAST(16, MSB(op_AND_445), DUP(op_AND_445))), CAST(16, MSB(DUP(op_AND_445)), DUP(op_AND_445))));
	RzILOpPure *op_LSHIFT_451 = SHIFTL0(CAST(64, MSB(op_MUL_448), DUP(op_MUL_448)), SN(32, 0));
	RzILOpPure *op_RSHIFT_455 = SHIFTRA(DUP(Rs), SN(32, 16));
	RzILOpPure *op_AND_457 = LOGAND(op_RSHIFT_455, SN(32, 0xffff));
	RzILOpPure *op_RSHIFT_463 = SHIFTRA(DUP(Rt), SN(32, 16));
	RzILOpPure *op_AND_465 = LOGAND(op_RSHIFT_463, SN(32, 0xffff));
	RzILOpPure *op_MUL_468 = MUL(CAST(32, MSB(CAST(16, MSB(op_AND_457), DUP(op_AND_457))), CAST(16, MSB(DUP(op_AND_457)), DUP(op_AND_457))), CAST(32, MSB(CAST(16, MSB(op_AND_465), DUP(op_AND_465))), CAST(16, MSB(DUP(op_AND_465)), DUP(op_AND_465))));
	RzILOpPure *op_LSHIFT_471 = SHIFTL0(CAST(64, MSB(op_MUL_468), DUP(op_MUL_468)), SN(32, 0));
	RzILOpPure *op_ADD_472 = ADD(op_LSHIFT_451, op_LSHIFT_471);
	RzILOpPure *op_SUB_473 = SUB(CAST(64, MSB(CAST(32, MSB(op_AND_429), DUP(op_AND_429))), CAST(32, MSB(DUP(op_AND_429)), DUP(op_AND_429))), op_ADD_472);
	RzILOpPure *op_LT_476 = SLT(op_SUB_473, CAST(64, MSB(SN(32, 0)), SN(32, 0)));
	RzILOpPure *op_LSHIFT_481 = SHIFTL0(SN(64, 1), SN(32, 31));
	RzILOpPure *op_NEG_482 = NEG(op_LSHIFT_481);
	RzILOpPure *op_LSHIFT_487 = SHIFTL0(SN(64, 1), SN(32, 31));
	RzILOpPure *op_SUB_490 = SUB(op_LSHIFT_487, CAST(64, MSB(SN(32, 1)), SN(32, 1)));
	RzILOpPure *cond_491 = ITE(op_LT_476, op_NEG_482, op_SUB_490);
	RzILOpEffect *gcc_expr_492 = BRANCH(op_EQ_370, EMPTY(), set_usr_field_call_423);

	// h_tmp261 = HYB(gcc_expr_if ((sextract64(((ut64) ((st64) ((st32) ((Rxx >> 0x0) & 0xffffffff))) - (((st64) ((st32) ((st16) ((Rs >> 0x0) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x0) & 0xffff)))) << 0x0) + (((st64) ((st32) ((st16) ((Rs >> 0x10) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x10) & 0xffff)))) << 0x0)), 0x0, 0x20) == ((st64) ((st32) ((Rxx >> 0x0) & 0xffffffff))) - (((st64) ((st32) ((st16) ((Rs >> 0x0) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x0) & 0xffff)))) << 0x0) + (((st64) ((st32) ((st16) ((Rs >> 0x10) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x10) & 0xffff)))) << 0x0))) {{}} else {set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, ((ut32) 0x1))}, ((((st64) ((st32) ((Rxx >> 0x0) & 0xffffffff))) - (((st64) ((st32) ((st16) ((Rs >> 0x0) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x0) & 0xffff)))) << 0x0) + (((st64) ((st32) ((st16) ((Rs >> 0x10) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x10) & 0xffff)))) << 0x0) < ((st64) 0x0)) ? (-(0x1 << 0x1f)) : (0x1 << 0x1f) - ((st64) 0x1)));
	RzILOpEffect *op_ASSIGN_hybrid_tmp_494 = SETL("h_tmp261", cond_491);

	// seq(HYB(gcc_expr_if ((sextract64(((ut64) ((st64) ((st32) ((Rxx > ...;
	RzILOpEffect *seq_495 = SEQN(2, gcc_expr_492, op_ASSIGN_hybrid_tmp_494);

	// Rxx = ((Rxx & (~(0xffffffff << 0x0))) | ((((sextract64(((ut64) ((st64) ((st32) ((Rxx >> 0x0) & 0xffffffff))) - (((st64) ((st32) ((st16) ((Rs >> 0x0) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x0) & 0xffff)))) << 0x0) + (((st64) ((st32) ((st16) ((Rs >> 0x10) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x10) & 0xffff)))) << 0x0)), 0x0, 0x20) == ((st64) ((st32) ((Rxx >> 0x0) & 0xffffffff))) - (((st64) ((st32) ((st16) ((Rs >> 0x0) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x0) & 0xffff)))) << 0x0) + (((st64) ((st32) ((st16) ((Rs >> 0x10) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x10) & 0xffff)))) << 0x0)) ? ((st64) ((st32) ((Rxx >> 0x0) & 0xffffffff))) - (((st64) ((st32) ((st16) ((Rs >> 0x0) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x0) & 0xffff)))) << 0x0) + (((st64) ((st32) ((st16) ((Rs >> 0x10) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x10) & 0xffff)))) << 0x0) : h_tmp261) & 0xffffffff) << 0x0));
	RzILOpPure *op_LSHIFT_259 = SHIFTL0(SN(64, 0xffffffff), SN(32, 0));
	RzILOpPure *op_NOT_260 = LOGNOT(op_LSHIFT_259);
	RzILOpPure *op_AND_261 = LOGAND(READ_REG(pkt, Rxx_op, false), op_NOT_260);
	RzILOpPure *op_RSHIFT_374 = SHIFTRA(READ_REG(pkt, Rxx_op, false), SN(32, 0));
	RzILOpPure *op_AND_376 = LOGAND(op_RSHIFT_374, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_382 = SHIFTRA(DUP(Rs), SN(32, 0));
	RzILOpPure *op_AND_384 = LOGAND(op_RSHIFT_382, SN(32, 0xffff));
	RzILOpPure *op_RSHIFT_390 = SHIFTRA(DUP(Rt), SN(32, 0));
	RzILOpPure *op_AND_392 = LOGAND(op_RSHIFT_390, SN(32, 0xffff));
	RzILOpPure *op_MUL_395 = MUL(CAST(32, MSB(CAST(16, MSB(op_AND_384), DUP(op_AND_384))), CAST(16, MSB(DUP(op_AND_384)), DUP(op_AND_384))), CAST(32, MSB(CAST(16, MSB(op_AND_392), DUP(op_AND_392))), CAST(16, MSB(DUP(op_AND_392)), DUP(op_AND_392))));
	RzILOpPure *op_LSHIFT_398 = SHIFTL0(CAST(64, MSB(op_MUL_395), DUP(op_MUL_395)), SN(32, 0));
	RzILOpPure *op_RSHIFT_402 = SHIFTRA(DUP(Rs), SN(32, 16));
	RzILOpPure *op_AND_404 = LOGAND(op_RSHIFT_402, SN(32, 0xffff));
	RzILOpPure *op_RSHIFT_410 = SHIFTRA(DUP(Rt), SN(32, 16));
	RzILOpPure *op_AND_412 = LOGAND(op_RSHIFT_410, SN(32, 0xffff));
	RzILOpPure *op_MUL_415 = MUL(CAST(32, MSB(CAST(16, MSB(op_AND_404), DUP(op_AND_404))), CAST(16, MSB(DUP(op_AND_404)), DUP(op_AND_404))), CAST(32, MSB(CAST(16, MSB(op_AND_412), DUP(op_AND_412))), CAST(16, MSB(DUP(op_AND_412)), DUP(op_AND_412))));
	RzILOpPure *op_LSHIFT_418 = SHIFTL0(CAST(64, MSB(op_MUL_415), DUP(op_MUL_415)), SN(32, 0));
	RzILOpPure *op_ADD_419 = ADD(op_LSHIFT_398, op_LSHIFT_418);
	RzILOpPure *op_SUB_420 = SUB(CAST(64, MSB(CAST(32, MSB(op_AND_376), DUP(op_AND_376))), CAST(32, MSB(DUP(op_AND_376)), DUP(op_AND_376))), op_ADD_419);
	RzILOpPure *cond_496 = ITE(DUP(op_EQ_370), op_SUB_420, VARL("h_tmp261"));
	RzILOpPure *op_AND_498 = LOGAND(cond_496, SN(64, 0xffffffff));
	RzILOpPure *op_LSHIFT_502 = SHIFTL0(op_AND_498, SN(32, 0));
	RzILOpPure *op_OR_503 = LOGOR(op_AND_261, op_LSHIFT_502);
	RzILOpEffect *op_ASSIGN_504 = WRITE_REG(bundle, Rxx_op, op_OR_503);

	// seq(seq(HYB(gcc_expr_if ((sextract64(((ut64) ((st64) ((st32) ((R ...;
	RzILOpEffect *seq_505 = SEQN(2, seq_495, op_ASSIGN_504);

	RzILOpEffect *instruction_sequence = SEQN(2, seq_253, seq_505);
	return instruction_sequence;
}

// Rxx -= cmpy(Rs,Rt*):<<1:sat
RzILOpEffect *hex_il_op_m2_cnacsc_s1(HexInsnPktBundle *bundle) {
	const HexInsn *hi = bundle->insn;
	HexPkt *pkt = bundle->pkt;
	// READ
	const HexOp *Rxx_op = ISA2REG(hi, 'x', false);

	const HexOp *Rs_op = ISA2REG(hi, 's', false);
	RzILOpPure *Rs = READ_REG(pkt, Rs_op, false);
	const HexOp *Rt_op = ISA2REG(hi, 't', false);
	RzILOpPure *Rt = READ_REG(pkt, Rt_op, false);

	// set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, ((ut32) 0x1));
	RzILOpEffect *set_usr_field_call_171 = hex_set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, CAST(32, IL_FALSE, SN(32, 1)));

	// HYB(gcc_expr_if ((sextract64(((ut64) ((st64) ((st32) ((Rxx >> 0x20) & 0xffffffff))) - (((st64) ((st32) ((st16) ((Rs >> 0x10) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x0) & 0xffff)))) << 0x1) - (((st64) ((st32) ((st16) ((Rs >> 0x0) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x10) & 0xffff)))) << 0x1)), 0x0, 0x20) == ((st64) ((st32) ((Rxx >> 0x20) & 0xffffffff))) - (((st64) ((st32) ((st16) ((Rs >> 0x10) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x0) & 0xffff)))) << 0x1) - (((st64) ((st32) ((st16) ((Rs >> 0x0) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x10) & 0xffff)))) << 0x1))) {{}} else {set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, ((ut32) 0x1))}, ((((st64) ((st32) ((Rxx >> 0x20) & 0xffffffff))) - (((st64) ((st32) ((st16) ((Rs >> 0x10) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x0) & 0xffff)))) << 0x1) - (((st64) ((st32) ((st16) ((Rs >> 0x0) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x10) & 0xffff)))) << 0x1) < ((st64) 0x0)) ? (-(0x1 << 0x1f)) : (0x1 << 0x1f) - ((st64) 0x1)));
	RzILOpPure *op_RSHIFT_14 = SHIFTRA(READ_REG(pkt, Rxx_op, false), SN(32, 0x20));
	RzILOpPure *op_AND_16 = LOGAND(op_RSHIFT_14, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_23 = SHIFTRA(Rs, SN(32, 16));
	RzILOpPure *op_AND_25 = LOGAND(op_RSHIFT_23, SN(32, 0xffff));
	RzILOpPure *op_RSHIFT_32 = SHIFTRA(Rt, SN(32, 0));
	RzILOpPure *op_AND_34 = LOGAND(op_RSHIFT_32, SN(32, 0xffff));
	RzILOpPure *op_MUL_37 = MUL(CAST(32, MSB(CAST(16, MSB(op_AND_25), DUP(op_AND_25))), CAST(16, MSB(DUP(op_AND_25)), DUP(op_AND_25))), CAST(32, MSB(CAST(16, MSB(op_AND_34), DUP(op_AND_34))), CAST(16, MSB(DUP(op_AND_34)), DUP(op_AND_34))));
	RzILOpPure *op_LSHIFT_40 = SHIFTL0(CAST(64, MSB(op_MUL_37), DUP(op_MUL_37)), SN(32, 1));
	RzILOpPure *op_RSHIFT_44 = SHIFTRA(DUP(Rs), SN(32, 0));
	RzILOpPure *op_AND_46 = LOGAND(op_RSHIFT_44, SN(32, 0xffff));
	RzILOpPure *op_RSHIFT_52 = SHIFTRA(DUP(Rt), SN(32, 16));
	RzILOpPure *op_AND_54 = LOGAND(op_RSHIFT_52, SN(32, 0xffff));
	RzILOpPure *op_MUL_57 = MUL(CAST(32, MSB(CAST(16, MSB(op_AND_46), DUP(op_AND_46))), CAST(16, MSB(DUP(op_AND_46)), DUP(op_AND_46))), CAST(32, MSB(CAST(16, MSB(op_AND_54), DUP(op_AND_54))), CAST(16, MSB(DUP(op_AND_54)), DUP(op_AND_54))));
	RzILOpPure *op_LSHIFT_60 = SHIFTL0(CAST(64, MSB(op_MUL_57), DUP(op_MUL_57)), SN(32, 1));
	RzILOpPure *op_SUB_61 = SUB(op_LSHIFT_40, op_LSHIFT_60);
	RzILOpPure *op_SUB_62 = SUB(CAST(64, MSB(CAST(32, MSB(op_AND_16), DUP(op_AND_16))), CAST(32, MSB(DUP(op_AND_16)), DUP(op_AND_16))), op_SUB_61);
	RzILOpPure *op_RSHIFT_71 = SHIFTRA(READ_REG(pkt, Rxx_op, false), SN(32, 0x20));
	RzILOpPure *op_AND_73 = LOGAND(op_RSHIFT_71, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_79 = SHIFTRA(DUP(Rs), SN(32, 16));
	RzILOpPure *op_AND_81 = LOGAND(op_RSHIFT_79, SN(32, 0xffff));
	RzILOpPure *op_RSHIFT_87 = SHIFTRA(DUP(Rt), SN(32, 0));
	RzILOpPure *op_AND_89 = LOGAND(op_RSHIFT_87, SN(32, 0xffff));
	RzILOpPure *op_MUL_92 = MUL(CAST(32, MSB(CAST(16, MSB(op_AND_81), DUP(op_AND_81))), CAST(16, MSB(DUP(op_AND_81)), DUP(op_AND_81))), CAST(32, MSB(CAST(16, MSB(op_AND_89), DUP(op_AND_89))), CAST(16, MSB(DUP(op_AND_89)), DUP(op_AND_89))));
	RzILOpPure *op_LSHIFT_95 = SHIFTL0(CAST(64, MSB(op_MUL_92), DUP(op_MUL_92)), SN(32, 1));
	RzILOpPure *op_RSHIFT_99 = SHIFTRA(DUP(Rs), SN(32, 0));
	RzILOpPure *op_AND_101 = LOGAND(op_RSHIFT_99, SN(32, 0xffff));
	RzILOpPure *op_RSHIFT_107 = SHIFTRA(DUP(Rt), SN(32, 16));
	RzILOpPure *op_AND_109 = LOGAND(op_RSHIFT_107, SN(32, 0xffff));
	RzILOpPure *op_MUL_112 = MUL(CAST(32, MSB(CAST(16, MSB(op_AND_101), DUP(op_AND_101))), CAST(16, MSB(DUP(op_AND_101)), DUP(op_AND_101))), CAST(32, MSB(CAST(16, MSB(op_AND_109), DUP(op_AND_109))), CAST(16, MSB(DUP(op_AND_109)), DUP(op_AND_109))));
	RzILOpPure *op_LSHIFT_115 = SHIFTL0(CAST(64, MSB(op_MUL_112), DUP(op_MUL_112)), SN(32, 1));
	RzILOpPure *op_SUB_116 = SUB(op_LSHIFT_95, op_LSHIFT_115);
	RzILOpPure *op_SUB_117 = SUB(CAST(64, MSB(CAST(32, MSB(op_AND_73), DUP(op_AND_73))), CAST(32, MSB(DUP(op_AND_73)), DUP(op_AND_73))), op_SUB_116);
	RzILOpPure *op_EQ_118 = EQ(SEXTRACT64(CAST(64, IL_FALSE, op_SUB_62), SN(32, 0), SN(32, 0x20)), op_SUB_117);
	RzILOpPure *op_RSHIFT_175 = SHIFTRA(READ_REG(pkt, Rxx_op, false), SN(32, 0x20));
	RzILOpPure *op_AND_177 = LOGAND(op_RSHIFT_175, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_183 = SHIFTRA(DUP(Rs), SN(32, 16));
	RzILOpPure *op_AND_185 = LOGAND(op_RSHIFT_183, SN(32, 0xffff));
	RzILOpPure *op_RSHIFT_191 = SHIFTRA(DUP(Rt), SN(32, 0));
	RzILOpPure *op_AND_193 = LOGAND(op_RSHIFT_191, SN(32, 0xffff));
	RzILOpPure *op_MUL_196 = MUL(CAST(32, MSB(CAST(16, MSB(op_AND_185), DUP(op_AND_185))), CAST(16, MSB(DUP(op_AND_185)), DUP(op_AND_185))), CAST(32, MSB(CAST(16, MSB(op_AND_193), DUP(op_AND_193))), CAST(16, MSB(DUP(op_AND_193)), DUP(op_AND_193))));
	RzILOpPure *op_LSHIFT_199 = SHIFTL0(CAST(64, MSB(op_MUL_196), DUP(op_MUL_196)), SN(32, 1));
	RzILOpPure *op_RSHIFT_203 = SHIFTRA(DUP(Rs), SN(32, 0));
	RzILOpPure *op_AND_205 = LOGAND(op_RSHIFT_203, SN(32, 0xffff));
	RzILOpPure *op_RSHIFT_211 = SHIFTRA(DUP(Rt), SN(32, 16));
	RzILOpPure *op_AND_213 = LOGAND(op_RSHIFT_211, SN(32, 0xffff));
	RzILOpPure *op_MUL_216 = MUL(CAST(32, MSB(CAST(16, MSB(op_AND_205), DUP(op_AND_205))), CAST(16, MSB(DUP(op_AND_205)), DUP(op_AND_205))), CAST(32, MSB(CAST(16, MSB(op_AND_213), DUP(op_AND_213))), CAST(16, MSB(DUP(op_AND_213)), DUP(op_AND_213))));
	RzILOpPure *op_LSHIFT_219 = SHIFTL0(CAST(64, MSB(op_MUL_216), DUP(op_MUL_216)), SN(32, 1));
	RzILOpPure *op_SUB_220 = SUB(op_LSHIFT_199, op_LSHIFT_219);
	RzILOpPure *op_SUB_221 = SUB(CAST(64, MSB(CAST(32, MSB(op_AND_177), DUP(op_AND_177))), CAST(32, MSB(DUP(op_AND_177)), DUP(op_AND_177))), op_SUB_220);
	RzILOpPure *op_LT_224 = SLT(op_SUB_221, CAST(64, MSB(SN(32, 0)), SN(32, 0)));
	RzILOpPure *op_LSHIFT_229 = SHIFTL0(SN(64, 1), SN(32, 31));
	RzILOpPure *op_NEG_230 = NEG(op_LSHIFT_229);
	RzILOpPure *op_LSHIFT_235 = SHIFTL0(SN(64, 1), SN(32, 31));
	RzILOpPure *op_SUB_238 = SUB(op_LSHIFT_235, CAST(64, MSB(SN(32, 1)), SN(32, 1)));
	RzILOpPure *cond_239 = ITE(op_LT_224, op_NEG_230, op_SUB_238);
	RzILOpEffect *gcc_expr_240 = BRANCH(op_EQ_118, EMPTY(), set_usr_field_call_171);

	// h_tmp262 = HYB(gcc_expr_if ((sextract64(((ut64) ((st64) ((st32) ((Rxx >> 0x20) & 0xffffffff))) - (((st64) ((st32) ((st16) ((Rs >> 0x10) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x0) & 0xffff)))) << 0x1) - (((st64) ((st32) ((st16) ((Rs >> 0x0) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x10) & 0xffff)))) << 0x1)), 0x0, 0x20) == ((st64) ((st32) ((Rxx >> 0x20) & 0xffffffff))) - (((st64) ((st32) ((st16) ((Rs >> 0x10) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x0) & 0xffff)))) << 0x1) - (((st64) ((st32) ((st16) ((Rs >> 0x0) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x10) & 0xffff)))) << 0x1))) {{}} else {set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, ((ut32) 0x1))}, ((((st64) ((st32) ((Rxx >> 0x20) & 0xffffffff))) - (((st64) ((st32) ((st16) ((Rs >> 0x10) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x0) & 0xffff)))) << 0x1) - (((st64) ((st32) ((st16) ((Rs >> 0x0) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x10) & 0xffff)))) << 0x1) < ((st64) 0x0)) ? (-(0x1 << 0x1f)) : (0x1 << 0x1f) - ((st64) 0x1)));
	RzILOpEffect *op_ASSIGN_hybrid_tmp_242 = SETL("h_tmp262", cond_239);

	// seq(HYB(gcc_expr_if ((sextract64(((ut64) ((st64) ((st32) ((Rxx > ...;
	RzILOpEffect *seq_243 = SEQN(2, gcc_expr_240, op_ASSIGN_hybrid_tmp_242);

	// Rxx = ((Rxx & (~(0xffffffff << 0x20))) | ((((sextract64(((ut64) ((st64) ((st32) ((Rxx >> 0x20) & 0xffffffff))) - (((st64) ((st32) ((st16) ((Rs >> 0x10) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x0) & 0xffff)))) << 0x1) - (((st64) ((st32) ((st16) ((Rs >> 0x0) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x10) & 0xffff)))) << 0x1)), 0x0, 0x20) == ((st64) ((st32) ((Rxx >> 0x20) & 0xffffffff))) - (((st64) ((st32) ((st16) ((Rs >> 0x10) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x0) & 0xffff)))) << 0x1) - (((st64) ((st32) ((st16) ((Rs >> 0x0) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x10) & 0xffff)))) << 0x1)) ? ((st64) ((st32) ((Rxx >> 0x20) & 0xffffffff))) - (((st64) ((st32) ((st16) ((Rs >> 0x10) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x0) & 0xffff)))) << 0x1) - (((st64) ((st32) ((st16) ((Rs >> 0x0) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x10) & 0xffff)))) << 0x1) : h_tmp262) & 0xffffffff) << 0x20));
	RzILOpPure *op_LSHIFT_5 = SHIFTL0(SN(64, 0xffffffff), SN(32, 0x20));
	RzILOpPure *op_NOT_6 = LOGNOT(op_LSHIFT_5);
	RzILOpPure *op_AND_7 = LOGAND(READ_REG(pkt, Rxx_op, false), op_NOT_6);
	RzILOpPure *op_RSHIFT_122 = SHIFTRA(READ_REG(pkt, Rxx_op, false), SN(32, 0x20));
	RzILOpPure *op_AND_124 = LOGAND(op_RSHIFT_122, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_130 = SHIFTRA(DUP(Rs), SN(32, 16));
	RzILOpPure *op_AND_132 = LOGAND(op_RSHIFT_130, SN(32, 0xffff));
	RzILOpPure *op_RSHIFT_138 = SHIFTRA(DUP(Rt), SN(32, 0));
	RzILOpPure *op_AND_140 = LOGAND(op_RSHIFT_138, SN(32, 0xffff));
	RzILOpPure *op_MUL_143 = MUL(CAST(32, MSB(CAST(16, MSB(op_AND_132), DUP(op_AND_132))), CAST(16, MSB(DUP(op_AND_132)), DUP(op_AND_132))), CAST(32, MSB(CAST(16, MSB(op_AND_140), DUP(op_AND_140))), CAST(16, MSB(DUP(op_AND_140)), DUP(op_AND_140))));
	RzILOpPure *op_LSHIFT_146 = SHIFTL0(CAST(64, MSB(op_MUL_143), DUP(op_MUL_143)), SN(32, 1));
	RzILOpPure *op_RSHIFT_150 = SHIFTRA(DUP(Rs), SN(32, 0));
	RzILOpPure *op_AND_152 = LOGAND(op_RSHIFT_150, SN(32, 0xffff));
	RzILOpPure *op_RSHIFT_158 = SHIFTRA(DUP(Rt), SN(32, 16));
	RzILOpPure *op_AND_160 = LOGAND(op_RSHIFT_158, SN(32, 0xffff));
	RzILOpPure *op_MUL_163 = MUL(CAST(32, MSB(CAST(16, MSB(op_AND_152), DUP(op_AND_152))), CAST(16, MSB(DUP(op_AND_152)), DUP(op_AND_152))), CAST(32, MSB(CAST(16, MSB(op_AND_160), DUP(op_AND_160))), CAST(16, MSB(DUP(op_AND_160)), DUP(op_AND_160))));
	RzILOpPure *op_LSHIFT_166 = SHIFTL0(CAST(64, MSB(op_MUL_163), DUP(op_MUL_163)), SN(32, 1));
	RzILOpPure *op_SUB_167 = SUB(op_LSHIFT_146, op_LSHIFT_166);
	RzILOpPure *op_SUB_168 = SUB(CAST(64, MSB(CAST(32, MSB(op_AND_124), DUP(op_AND_124))), CAST(32, MSB(DUP(op_AND_124)), DUP(op_AND_124))), op_SUB_167);
	RzILOpPure *cond_244 = ITE(DUP(op_EQ_118), op_SUB_168, VARL("h_tmp262"));
	RzILOpPure *op_AND_246 = LOGAND(cond_244, SN(64, 0xffffffff));
	RzILOpPure *op_LSHIFT_250 = SHIFTL0(op_AND_246, SN(32, 0x20));
	RzILOpPure *op_OR_251 = LOGOR(op_AND_7, op_LSHIFT_250);
	RzILOpEffect *op_ASSIGN_252 = WRITE_REG(bundle, Rxx_op, op_OR_251);

	// seq(seq(HYB(gcc_expr_if ((sextract64(((ut64) ((st64) ((st32) ((R ...;
	RzILOpEffect *seq_253 = SEQN(2, seq_243, op_ASSIGN_252);

	// set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, ((ut32) 0x1));
	RzILOpEffect *set_usr_field_call_423 = hex_set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, CAST(32, IL_FALSE, SN(32, 1)));

	// HYB(gcc_expr_if ((sextract64(((ut64) ((st64) ((st32) ((Rxx >> 0x0) & 0xffffffff))) - (((st64) ((st32) ((st16) ((Rs >> 0x0) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x0) & 0xffff)))) << 0x1) + (((st64) ((st32) ((st16) ((Rs >> 0x10) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x10) & 0xffff)))) << 0x1)), 0x0, 0x20) == ((st64) ((st32) ((Rxx >> 0x0) & 0xffffffff))) - (((st64) ((st32) ((st16) ((Rs >> 0x0) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x0) & 0xffff)))) << 0x1) + (((st64) ((st32) ((st16) ((Rs >> 0x10) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x10) & 0xffff)))) << 0x1))) {{}} else {set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, ((ut32) 0x1))}, ((((st64) ((st32) ((Rxx >> 0x0) & 0xffffffff))) - (((st64) ((st32) ((st16) ((Rs >> 0x0) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x0) & 0xffff)))) << 0x1) + (((st64) ((st32) ((st16) ((Rs >> 0x10) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x10) & 0xffff)))) << 0x1) < ((st64) 0x0)) ? (-(0x1 << 0x1f)) : (0x1 << 0x1f) - ((st64) 0x1)));
	RzILOpPure *op_RSHIFT_268 = SHIFTRA(READ_REG(pkt, Rxx_op, false), SN(32, 0));
	RzILOpPure *op_AND_270 = LOGAND(op_RSHIFT_268, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_276 = SHIFTRA(DUP(Rs), SN(32, 0));
	RzILOpPure *op_AND_278 = LOGAND(op_RSHIFT_276, SN(32, 0xffff));
	RzILOpPure *op_RSHIFT_284 = SHIFTRA(DUP(Rt), SN(32, 0));
	RzILOpPure *op_AND_286 = LOGAND(op_RSHIFT_284, SN(32, 0xffff));
	RzILOpPure *op_MUL_289 = MUL(CAST(32, MSB(CAST(16, MSB(op_AND_278), DUP(op_AND_278))), CAST(16, MSB(DUP(op_AND_278)), DUP(op_AND_278))), CAST(32, MSB(CAST(16, MSB(op_AND_286), DUP(op_AND_286))), CAST(16, MSB(DUP(op_AND_286)), DUP(op_AND_286))));
	RzILOpPure *op_LSHIFT_292 = SHIFTL0(CAST(64, MSB(op_MUL_289), DUP(op_MUL_289)), SN(32, 1));
	RzILOpPure *op_RSHIFT_296 = SHIFTRA(DUP(Rs), SN(32, 16));
	RzILOpPure *op_AND_298 = LOGAND(op_RSHIFT_296, SN(32, 0xffff));
	RzILOpPure *op_RSHIFT_304 = SHIFTRA(DUP(Rt), SN(32, 16));
	RzILOpPure *op_AND_306 = LOGAND(op_RSHIFT_304, SN(32, 0xffff));
	RzILOpPure *op_MUL_309 = MUL(CAST(32, MSB(CAST(16, MSB(op_AND_298), DUP(op_AND_298))), CAST(16, MSB(DUP(op_AND_298)), DUP(op_AND_298))), CAST(32, MSB(CAST(16, MSB(op_AND_306), DUP(op_AND_306))), CAST(16, MSB(DUP(op_AND_306)), DUP(op_AND_306))));
	RzILOpPure *op_LSHIFT_312 = SHIFTL0(CAST(64, MSB(op_MUL_309), DUP(op_MUL_309)), SN(32, 1));
	RzILOpPure *op_ADD_313 = ADD(op_LSHIFT_292, op_LSHIFT_312);
	RzILOpPure *op_SUB_314 = SUB(CAST(64, MSB(CAST(32, MSB(op_AND_270), DUP(op_AND_270))), CAST(32, MSB(DUP(op_AND_270)), DUP(op_AND_270))), op_ADD_313);
	RzILOpPure *op_RSHIFT_323 = SHIFTRA(READ_REG(pkt, Rxx_op, false), SN(32, 0));
	RzILOpPure *op_AND_325 = LOGAND(op_RSHIFT_323, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_331 = SHIFTRA(DUP(Rs), SN(32, 0));
	RzILOpPure *op_AND_333 = LOGAND(op_RSHIFT_331, SN(32, 0xffff));
	RzILOpPure *op_RSHIFT_339 = SHIFTRA(DUP(Rt), SN(32, 0));
	RzILOpPure *op_AND_341 = LOGAND(op_RSHIFT_339, SN(32, 0xffff));
	RzILOpPure *op_MUL_344 = MUL(CAST(32, MSB(CAST(16, MSB(op_AND_333), DUP(op_AND_333))), CAST(16, MSB(DUP(op_AND_333)), DUP(op_AND_333))), CAST(32, MSB(CAST(16, MSB(op_AND_341), DUP(op_AND_341))), CAST(16, MSB(DUP(op_AND_341)), DUP(op_AND_341))));
	RzILOpPure *op_LSHIFT_347 = SHIFTL0(CAST(64, MSB(op_MUL_344), DUP(op_MUL_344)), SN(32, 1));
	RzILOpPure *op_RSHIFT_351 = SHIFTRA(DUP(Rs), SN(32, 16));
	RzILOpPure *op_AND_353 = LOGAND(op_RSHIFT_351, SN(32, 0xffff));
	RzILOpPure *op_RSHIFT_359 = SHIFTRA(DUP(Rt), SN(32, 16));
	RzILOpPure *op_AND_361 = LOGAND(op_RSHIFT_359, SN(32, 0xffff));
	RzILOpPure *op_MUL_364 = MUL(CAST(32, MSB(CAST(16, MSB(op_AND_353), DUP(op_AND_353))), CAST(16, MSB(DUP(op_AND_353)), DUP(op_AND_353))), CAST(32, MSB(CAST(16, MSB(op_AND_361), DUP(op_AND_361))), CAST(16, MSB(DUP(op_AND_361)), DUP(op_AND_361))));
	RzILOpPure *op_LSHIFT_367 = SHIFTL0(CAST(64, MSB(op_MUL_364), DUP(op_MUL_364)), SN(32, 1));
	RzILOpPure *op_ADD_368 = ADD(op_LSHIFT_347, op_LSHIFT_367);
	RzILOpPure *op_SUB_369 = SUB(CAST(64, MSB(CAST(32, MSB(op_AND_325), DUP(op_AND_325))), CAST(32, MSB(DUP(op_AND_325)), DUP(op_AND_325))), op_ADD_368);
	RzILOpPure *op_EQ_370 = EQ(SEXTRACT64(CAST(64, IL_FALSE, op_SUB_314), SN(32, 0), SN(32, 0x20)), op_SUB_369);
	RzILOpPure *op_RSHIFT_427 = SHIFTRA(READ_REG(pkt, Rxx_op, false), SN(32, 0));
	RzILOpPure *op_AND_429 = LOGAND(op_RSHIFT_427, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_435 = SHIFTRA(DUP(Rs), SN(32, 0));
	RzILOpPure *op_AND_437 = LOGAND(op_RSHIFT_435, SN(32, 0xffff));
	RzILOpPure *op_RSHIFT_443 = SHIFTRA(DUP(Rt), SN(32, 0));
	RzILOpPure *op_AND_445 = LOGAND(op_RSHIFT_443, SN(32, 0xffff));
	RzILOpPure *op_MUL_448 = MUL(CAST(32, MSB(CAST(16, MSB(op_AND_437), DUP(op_AND_437))), CAST(16, MSB(DUP(op_AND_437)), DUP(op_AND_437))), CAST(32, MSB(CAST(16, MSB(op_AND_445), DUP(op_AND_445))), CAST(16, MSB(DUP(op_AND_445)), DUP(op_AND_445))));
	RzILOpPure *op_LSHIFT_451 = SHIFTL0(CAST(64, MSB(op_MUL_448), DUP(op_MUL_448)), SN(32, 1));
	RzILOpPure *op_RSHIFT_455 = SHIFTRA(DUP(Rs), SN(32, 16));
	RzILOpPure *op_AND_457 = LOGAND(op_RSHIFT_455, SN(32, 0xffff));
	RzILOpPure *op_RSHIFT_463 = SHIFTRA(DUP(Rt), SN(32, 16));
	RzILOpPure *op_AND_465 = LOGAND(op_RSHIFT_463, SN(32, 0xffff));
	RzILOpPure *op_MUL_468 = MUL(CAST(32, MSB(CAST(16, MSB(op_AND_457), DUP(op_AND_457))), CAST(16, MSB(DUP(op_AND_457)), DUP(op_AND_457))), CAST(32, MSB(CAST(16, MSB(op_AND_465), DUP(op_AND_465))), CAST(16, MSB(DUP(op_AND_465)), DUP(op_AND_465))));
	RzILOpPure *op_LSHIFT_471 = SHIFTL0(CAST(64, MSB(op_MUL_468), DUP(op_MUL_468)), SN(32, 1));
	RzILOpPure *op_ADD_472 = ADD(op_LSHIFT_451, op_LSHIFT_471);
	RzILOpPure *op_SUB_473 = SUB(CAST(64, MSB(CAST(32, MSB(op_AND_429), DUP(op_AND_429))), CAST(32, MSB(DUP(op_AND_429)), DUP(op_AND_429))), op_ADD_472);
	RzILOpPure *op_LT_476 = SLT(op_SUB_473, CAST(64, MSB(SN(32, 0)), SN(32, 0)));
	RzILOpPure *op_LSHIFT_481 = SHIFTL0(SN(64, 1), SN(32, 31));
	RzILOpPure *op_NEG_482 = NEG(op_LSHIFT_481);
	RzILOpPure *op_LSHIFT_487 = SHIFTL0(SN(64, 1), SN(32, 31));
	RzILOpPure *op_SUB_490 = SUB(op_LSHIFT_487, CAST(64, MSB(SN(32, 1)), SN(32, 1)));
	RzILOpPure *cond_491 = ITE(op_LT_476, op_NEG_482, op_SUB_490);
	RzILOpEffect *gcc_expr_492 = BRANCH(op_EQ_370, EMPTY(), set_usr_field_call_423);

	// h_tmp263 = HYB(gcc_expr_if ((sextract64(((ut64) ((st64) ((st32) ((Rxx >> 0x0) & 0xffffffff))) - (((st64) ((st32) ((st16) ((Rs >> 0x0) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x0) & 0xffff)))) << 0x1) + (((st64) ((st32) ((st16) ((Rs >> 0x10) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x10) & 0xffff)))) << 0x1)), 0x0, 0x20) == ((st64) ((st32) ((Rxx >> 0x0) & 0xffffffff))) - (((st64) ((st32) ((st16) ((Rs >> 0x0) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x0) & 0xffff)))) << 0x1) + (((st64) ((st32) ((st16) ((Rs >> 0x10) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x10) & 0xffff)))) << 0x1))) {{}} else {set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, ((ut32) 0x1))}, ((((st64) ((st32) ((Rxx >> 0x0) & 0xffffffff))) - (((st64) ((st32) ((st16) ((Rs >> 0x0) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x0) & 0xffff)))) << 0x1) + (((st64) ((st32) ((st16) ((Rs >> 0x10) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x10) & 0xffff)))) << 0x1) < ((st64) 0x0)) ? (-(0x1 << 0x1f)) : (0x1 << 0x1f) - ((st64) 0x1)));
	RzILOpEffect *op_ASSIGN_hybrid_tmp_494 = SETL("h_tmp263", cond_491);

	// seq(HYB(gcc_expr_if ((sextract64(((ut64) ((st64) ((st32) ((Rxx > ...;
	RzILOpEffect *seq_495 = SEQN(2, gcc_expr_492, op_ASSIGN_hybrid_tmp_494);

	// Rxx = ((Rxx & (~(0xffffffff << 0x0))) | ((((sextract64(((ut64) ((st64) ((st32) ((Rxx >> 0x0) & 0xffffffff))) - (((st64) ((st32) ((st16) ((Rs >> 0x0) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x0) & 0xffff)))) << 0x1) + (((st64) ((st32) ((st16) ((Rs >> 0x10) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x10) & 0xffff)))) << 0x1)), 0x0, 0x20) == ((st64) ((st32) ((Rxx >> 0x0) & 0xffffffff))) - (((st64) ((st32) ((st16) ((Rs >> 0x0) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x0) & 0xffff)))) << 0x1) + (((st64) ((st32) ((st16) ((Rs >> 0x10) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x10) & 0xffff)))) << 0x1)) ? ((st64) ((st32) ((Rxx >> 0x0) & 0xffffffff))) - (((st64) ((st32) ((st16) ((Rs >> 0x0) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x0) & 0xffff)))) << 0x1) + (((st64) ((st32) ((st16) ((Rs >> 0x10) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x10) & 0xffff)))) << 0x1) : h_tmp263) & 0xffffffff) << 0x0));
	RzILOpPure *op_LSHIFT_259 = SHIFTL0(SN(64, 0xffffffff), SN(32, 0));
	RzILOpPure *op_NOT_260 = LOGNOT(op_LSHIFT_259);
	RzILOpPure *op_AND_261 = LOGAND(READ_REG(pkt, Rxx_op, false), op_NOT_260);
	RzILOpPure *op_RSHIFT_374 = SHIFTRA(READ_REG(pkt, Rxx_op, false), SN(32, 0));
	RzILOpPure *op_AND_376 = LOGAND(op_RSHIFT_374, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_382 = SHIFTRA(DUP(Rs), SN(32, 0));
	RzILOpPure *op_AND_384 = LOGAND(op_RSHIFT_382, SN(32, 0xffff));
	RzILOpPure *op_RSHIFT_390 = SHIFTRA(DUP(Rt), SN(32, 0));
	RzILOpPure *op_AND_392 = LOGAND(op_RSHIFT_390, SN(32, 0xffff));
	RzILOpPure *op_MUL_395 = MUL(CAST(32, MSB(CAST(16, MSB(op_AND_384), DUP(op_AND_384))), CAST(16, MSB(DUP(op_AND_384)), DUP(op_AND_384))), CAST(32, MSB(CAST(16, MSB(op_AND_392), DUP(op_AND_392))), CAST(16, MSB(DUP(op_AND_392)), DUP(op_AND_392))));
	RzILOpPure *op_LSHIFT_398 = SHIFTL0(CAST(64, MSB(op_MUL_395), DUP(op_MUL_395)), SN(32, 1));
	RzILOpPure *op_RSHIFT_402 = SHIFTRA(DUP(Rs), SN(32, 16));
	RzILOpPure *op_AND_404 = LOGAND(op_RSHIFT_402, SN(32, 0xffff));
	RzILOpPure *op_RSHIFT_410 = SHIFTRA(DUP(Rt), SN(32, 16));
	RzILOpPure *op_AND_412 = LOGAND(op_RSHIFT_410, SN(32, 0xffff));
	RzILOpPure *op_MUL_415 = MUL(CAST(32, MSB(CAST(16, MSB(op_AND_404), DUP(op_AND_404))), CAST(16, MSB(DUP(op_AND_404)), DUP(op_AND_404))), CAST(32, MSB(CAST(16, MSB(op_AND_412), DUP(op_AND_412))), CAST(16, MSB(DUP(op_AND_412)), DUP(op_AND_412))));
	RzILOpPure *op_LSHIFT_418 = SHIFTL0(CAST(64, MSB(op_MUL_415), DUP(op_MUL_415)), SN(32, 1));
	RzILOpPure *op_ADD_419 = ADD(op_LSHIFT_398, op_LSHIFT_418);
	RzILOpPure *op_SUB_420 = SUB(CAST(64, MSB(CAST(32, MSB(op_AND_376), DUP(op_AND_376))), CAST(32, MSB(DUP(op_AND_376)), DUP(op_AND_376))), op_ADD_419);
	RzILOpPure *cond_496 = ITE(DUP(op_EQ_370), op_SUB_420, VARL("h_tmp263"));
	RzILOpPure *op_AND_498 = LOGAND(cond_496, SN(64, 0xffffffff));
	RzILOpPure *op_LSHIFT_502 = SHIFTL0(op_AND_498, SN(32, 0));
	RzILOpPure *op_OR_503 = LOGOR(op_AND_261, op_LSHIFT_502);
	RzILOpEffect *op_ASSIGN_504 = WRITE_REG(bundle, Rxx_op, op_OR_503);

	// seq(seq(HYB(gcc_expr_if ((sextract64(((ut64) ((st64) ((st32) ((R ...;
	RzILOpEffect *seq_505 = SEQN(2, seq_495, op_ASSIGN_504);

	RzILOpEffect *instruction_sequence = SEQN(2, seq_253, seq_505);
	return instruction_sequence;
}

// Rxx += mpy(Rs,Rt)
RzILOpEffect *hex_il_op_m2_dpmpyss_acc_s0(HexInsnPktBundle *bundle) {
	const HexInsn *hi = bundle->insn;
	HexPkt *pkt = bundle->pkt;
	// READ
	const HexOp *Rxx_op = ISA2REG(hi, 'x', false);

	const HexOp *Rs_op = ISA2REG(hi, 's', false);
	RzILOpPure *Rs = READ_REG(pkt, Rs_op, false);
	const HexOp *Rt_op = ISA2REG(hi, 't', false);
	RzILOpPure *Rt = READ_REG(pkt, Rt_op, false);

	// Rxx = Rxx + ((st64) Rs) * ((st64) Rt);
	RzILOpPure *op_MUL_5 = MUL(CAST(64, MSB(Rs), DUP(Rs)), CAST(64, MSB(Rt), DUP(Rt)));
	RzILOpPure *op_ADD_6 = ADD(READ_REG(pkt, Rxx_op, false), op_MUL_5);
	RzILOpEffect *op_ASSIGN_7 = WRITE_REG(bundle, Rxx_op, op_ADD_6);

	RzILOpEffect *instruction_sequence = op_ASSIGN_7;
	return instruction_sequence;
}

// Rxx -= mpy(Rs,Rt)
RzILOpEffect *hex_il_op_m2_dpmpyss_nac_s0(HexInsnPktBundle *bundle) {
	const HexInsn *hi = bundle->insn;
	HexPkt *pkt = bundle->pkt;
	// READ
	const HexOp *Rxx_op = ISA2REG(hi, 'x', false);

	const HexOp *Rs_op = ISA2REG(hi, 's', false);
	RzILOpPure *Rs = READ_REG(pkt, Rs_op, false);
	const HexOp *Rt_op = ISA2REG(hi, 't', false);
	RzILOpPure *Rt = READ_REG(pkt, Rt_op, false);

	// Rxx = Rxx - ((st64) Rs) * ((st64) Rt);
	RzILOpPure *op_MUL_5 = MUL(CAST(64, MSB(Rs), DUP(Rs)), CAST(64, MSB(Rt), DUP(Rt)));
	RzILOpPure *op_SUB_6 = SUB(READ_REG(pkt, Rxx_op, false), op_MUL_5);
	RzILOpEffect *op_ASSIGN_7 = WRITE_REG(bundle, Rxx_op, op_SUB_6);

	RzILOpEffect *instruction_sequence = op_ASSIGN_7;
	return instruction_sequence;
}

// Rd = mpy(Rs,Rt):rnd
RzILOpEffect *hex_il_op_m2_dpmpyss_rnd_s0(HexInsnPktBundle *bundle) {
	const HexInsn *hi = bundle->insn;
	HexPkt *pkt = bundle->pkt;
	// READ
	const HexOp *Rd_op = ISA2REG(hi, 'd', false);
	const HexOp *Rs_op = ISA2REG(hi, 's', false);
	RzILOpPure *Rs = READ_REG(pkt, Rs_op, false);
	const HexOp *Rt_op = ISA2REG(hi, 't', false);
	RzILOpPure *Rt = READ_REG(pkt, Rt_op, false);

	// Rd = ((st32) (((st64) Rs) * ((st64) Rt) + 0x80000000 >> 0x20));
	RzILOpPure *op_MUL_5 = MUL(CAST(64, MSB(Rs), DUP(Rs)), CAST(64, MSB(Rt), DUP(Rt)));
	RzILOpPure *op_ADD_7 = ADD(op_MUL_5, SN(64, 0x80000000));
	RzILOpPure *op_RSHIFT_9 = SHIFTRA(op_ADD_7, SN(32, 0x20));
	RzILOpEffect *op_ASSIGN_11 = WRITE_REG(bundle, Rd_op, CAST(32, MSB(op_RSHIFT_9), DUP(op_RSHIFT_9)));

	RzILOpEffect *instruction_sequence = op_ASSIGN_11;
	return instruction_sequence;
}

// Rdd = mpy(Rs,Rt)
RzILOpEffect *hex_il_op_m2_dpmpyss_s0(HexInsnPktBundle *bundle) {
	const HexInsn *hi = bundle->insn;
	HexPkt *pkt = bundle->pkt;
	// READ
	const HexOp *Rdd_op = ISA2REG(hi, 'd', false);
	const HexOp *Rs_op = ISA2REG(hi, 's', false);
	RzILOpPure *Rs = READ_REG(pkt, Rs_op, false);
	const HexOp *Rt_op = ISA2REG(hi, 't', false);
	RzILOpPure *Rt = READ_REG(pkt, Rt_op, false);

	// Rdd = ((st64) Rs) * ((st64) Rt);
	RzILOpPure *op_MUL_5 = MUL(CAST(64, MSB(Rs), DUP(Rs)), CAST(64, MSB(Rt), DUP(Rt)));
	RzILOpEffect *op_ASSIGN_6 = WRITE_REG(bundle, Rdd_op, op_MUL_5);

	RzILOpEffect *instruction_sequence = op_ASSIGN_6;
	return instruction_sequence;
}

// Rxx += mpyu(Rs,Rt)
RzILOpEffect *hex_il_op_m2_dpmpyuu_acc_s0(HexInsnPktBundle *bundle) {
	const HexInsn *hi = bundle->insn;
	HexPkt *pkt = bundle->pkt;
	// READ
	const HexOp *Rxx_op = ISA2REG(hi, 'x', false);

	const HexOp *Rs_op = ISA2REG(hi, 's', false);
	RzILOpPure *Rs = READ_REG(pkt, Rs_op, false);
	const HexOp *Rt_op = ISA2REG(hi, 't', false);
	RzILOpPure *Rt = READ_REG(pkt, Rt_op, false);

	// Rxx = ((st64) ((ut64) Rxx) + ((ut64) ((ut32) Rs)) * ((ut64) ((ut32) Rt)));
	RzILOpPure *op_MUL_7 = MUL(CAST(64, IL_FALSE, CAST(32, IL_FALSE, Rs)), CAST(64, IL_FALSE, CAST(32, IL_FALSE, Rt)));
	RzILOpPure *op_ADD_9 = ADD(CAST(64, IL_FALSE, READ_REG(pkt, Rxx_op, false)), op_MUL_7);
	RzILOpEffect *op_ASSIGN_11 = WRITE_REG(bundle, Rxx_op, CAST(64, IL_FALSE, op_ADD_9));

	RzILOpEffect *instruction_sequence = op_ASSIGN_11;
	return instruction_sequence;
}

// Rxx -= mpyu(Rs,Rt)
RzILOpEffect *hex_il_op_m2_dpmpyuu_nac_s0(HexInsnPktBundle *bundle) {
	const HexInsn *hi = bundle->insn;
	HexPkt *pkt = bundle->pkt;
	// READ
	const HexOp *Rxx_op = ISA2REG(hi, 'x', false);

	const HexOp *Rs_op = ISA2REG(hi, 's', false);
	RzILOpPure *Rs = READ_REG(pkt, Rs_op, false);
	const HexOp *Rt_op = ISA2REG(hi, 't', false);
	RzILOpPure *Rt = READ_REG(pkt, Rt_op, false);

	// Rxx = ((st64) ((ut64) Rxx) - ((ut64) ((ut32) Rs)) * ((ut64) ((ut32) Rt)));
	RzILOpPure *op_MUL_7 = MUL(CAST(64, IL_FALSE, CAST(32, IL_FALSE, Rs)), CAST(64, IL_FALSE, CAST(32, IL_FALSE, Rt)));
	RzILOpPure *op_SUB_9 = SUB(CAST(64, IL_FALSE, READ_REG(pkt, Rxx_op, false)), op_MUL_7);
	RzILOpEffect *op_ASSIGN_11 = WRITE_REG(bundle, Rxx_op, CAST(64, IL_FALSE, op_SUB_9));

	RzILOpEffect *instruction_sequence = op_ASSIGN_11;
	return instruction_sequence;
}

// Rdd = mpyu(Rs,Rt)
RzILOpEffect *hex_il_op_m2_dpmpyuu_s0(HexInsnPktBundle *bundle) {
	const HexInsn *hi = bundle->insn;
	HexPkt *pkt = bundle->pkt;
	// READ
	const HexOp *Rdd_op = ISA2REG(hi, 'd', false);
	const HexOp *Rs_op = ISA2REG(hi, 's', false);
	RzILOpPure *Rs = READ_REG(pkt, Rs_op, false);
	const HexOp *Rt_op = ISA2REG(hi, 't', false);
	RzILOpPure *Rt = READ_REG(pkt, Rt_op, false);

	// Rdd = ((st64) ((ut64) ((ut32) Rs)) * ((ut64) ((ut32) Rt)));
	RzILOpPure *op_MUL_7 = MUL(CAST(64, IL_FALSE, CAST(32, IL_FALSE, Rs)), CAST(64, IL_FALSE, CAST(32, IL_FALSE, Rt)));
	RzILOpEffect *op_ASSIGN_9 = WRITE_REG(bundle, Rdd_op, CAST(64, IL_FALSE, op_MUL_7));

	RzILOpEffect *instruction_sequence = op_ASSIGN_9;
	return instruction_sequence;
}

// Rd = mpy(Rs,Rt.h):<<1:rnd:sat
RzILOpEffect *hex_il_op_m2_hmmpyh_rs1(HexInsnPktBundle *bundle) {
	const HexInsn *hi = bundle->insn;
	HexPkt *pkt = bundle->pkt;
	// READ
	const HexOp *Rd_op = ISA2REG(hi, 'd', false);
	const HexOp *Rs_op = ISA2REG(hi, 's', false);
	RzILOpPure *Rs = READ_REG(pkt, Rs_op, false);
	const HexOp *Rt_op = ISA2REG(hi, 't', false);
	RzILOpPure *Rt = READ_REG(pkt, Rt_op, false);

	// set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, ((ut32) 0x1));
	RzILOpEffect *set_usr_field_call_86 = hex_set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, CAST(32, IL_FALSE, SN(32, 1)));

	// HYB(gcc_expr_if ((sextract64(((ut64) ((((st64) Rs) * sextract64(((ut64) ((st16) ((Rt >> 0x10) & 0xffff))), 0x0, 0x10) << 0x1) + ((st64) 0x8000) >> 0x10)), 0x0, 0x20) == ((((st64) Rs) * sextract64(((ut64) ((st16) ((Rt >> 0x10) & 0xffff))), 0x0, 0x10) << 0x1) + ((st64) 0x8000) >> 0x10))) {{}} else {set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, ((ut32) 0x1))}, ((((((st64) Rs) * sextract64(((ut64) ((st16) ((Rt >> 0x10) & 0xffff))), 0x0, 0x10) << 0x1) + ((st64) 0x8000) >> 0x10) < ((st64) 0x0)) ? (-(0x1 << 0x1f)) : (0x1 << 0x1f) - ((st64) 0x1)));
	RzILOpPure *op_RSHIFT_13 = SHIFTRA(Rt, SN(32, 16));
	RzILOpPure *op_AND_15 = LOGAND(op_RSHIFT_13, SN(32, 0xffff));
	RzILOpPure *op_MUL_22 = MUL(CAST(64, MSB(Rs), DUP(Rs)), SEXTRACT64(CAST(64, IL_FALSE, CAST(16, MSB(op_AND_15), DUP(op_AND_15))), SN(32, 0), SN(32, 16)));
	RzILOpPure *op_LSHIFT_24 = SHIFTL0(op_MUL_22, SN(32, 1));
	RzILOpPure *op_ADD_27 = ADD(op_LSHIFT_24, CAST(64, MSB(SN(32, 0x8000)), SN(32, 0x8000)));
	RzILOpPure *op_RSHIFT_29 = SHIFTRA(op_ADD_27, SN(32, 16));
	RzILOpPure *op_RSHIFT_42 = SHIFTRA(DUP(Rt), SN(32, 16));
	RzILOpPure *op_AND_44 = LOGAND(op_RSHIFT_42, SN(32, 0xffff));
	RzILOpPure *op_MUL_51 = MUL(CAST(64, MSB(DUP(Rs)), DUP(Rs)), SEXTRACT64(CAST(64, IL_FALSE, CAST(16, MSB(op_AND_44), DUP(op_AND_44))), SN(32, 0), SN(32, 16)));
	RzILOpPure *op_LSHIFT_53 = SHIFTL0(op_MUL_51, SN(32, 1));
	RzILOpPure *op_ADD_56 = ADD(op_LSHIFT_53, CAST(64, MSB(SN(32, 0x8000)), SN(32, 0x8000)));
	RzILOpPure *op_RSHIFT_58 = SHIFTRA(op_ADD_56, SN(32, 16));
	RzILOpPure *op_EQ_59 = EQ(SEXTRACT64(CAST(64, IL_FALSE, op_RSHIFT_29), SN(32, 0), SN(32, 0x20)), op_RSHIFT_58);
	RzILOpPure *op_RSHIFT_94 = SHIFTRA(DUP(Rt), SN(32, 16));
	RzILOpPure *op_AND_96 = LOGAND(op_RSHIFT_94, SN(32, 0xffff));
	RzILOpPure *op_MUL_103 = MUL(CAST(64, MSB(DUP(Rs)), DUP(Rs)), SEXTRACT64(CAST(64, IL_FALSE, CAST(16, MSB(op_AND_96), DUP(op_AND_96))), SN(32, 0), SN(32, 16)));
	RzILOpPure *op_LSHIFT_105 = SHIFTL0(op_MUL_103, SN(32, 1));
	RzILOpPure *op_ADD_108 = ADD(op_LSHIFT_105, CAST(64, MSB(SN(32, 0x8000)), SN(32, 0x8000)));
	RzILOpPure *op_RSHIFT_110 = SHIFTRA(op_ADD_108, SN(32, 16));
	RzILOpPure *op_LT_113 = SLT(op_RSHIFT_110, CAST(64, MSB(SN(32, 0)), SN(32, 0)));
	RzILOpPure *op_LSHIFT_118 = SHIFTL0(SN(64, 1), SN(32, 31));
	RzILOpPure *op_NEG_119 = NEG(op_LSHIFT_118);
	RzILOpPure *op_LSHIFT_124 = SHIFTL0(SN(64, 1), SN(32, 31));
	RzILOpPure *op_SUB_127 = SUB(op_LSHIFT_124, CAST(64, MSB(SN(32, 1)), SN(32, 1)));
	RzILOpPure *cond_128 = ITE(op_LT_113, op_NEG_119, op_SUB_127);
	RzILOpEffect *gcc_expr_129 = BRANCH(op_EQ_59, EMPTY(), set_usr_field_call_86);

	// h_tmp264 = HYB(gcc_expr_if ((sextract64(((ut64) ((((st64) Rs) * sextract64(((ut64) ((st16) ((Rt >> 0x10) & 0xffff))), 0x0, 0x10) << 0x1) + ((st64) 0x8000) >> 0x10)), 0x0, 0x20) == ((((st64) Rs) * sextract64(((ut64) ((st16) ((Rt >> 0x10) & 0xffff))), 0x0, 0x10) << 0x1) + ((st64) 0x8000) >> 0x10))) {{}} else {set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, ((ut32) 0x1))}, ((((((st64) Rs) * sextract64(((ut64) ((st16) ((Rt >> 0x10) & 0xffff))), 0x0, 0x10) << 0x1) + ((st64) 0x8000) >> 0x10) < ((st64) 0x0)) ? (-(0x1 << 0x1f)) : (0x1 << 0x1f) - ((st64) 0x1)));
	RzILOpEffect *op_ASSIGN_hybrid_tmp_131 = SETL("h_tmp264", cond_128);

	// seq(HYB(gcc_expr_if ((sextract64(((ut64) ((((st64) Rs) * sextrac ...;
	RzILOpEffect *seq_132 = SEQN(2, gcc_expr_129, op_ASSIGN_hybrid_tmp_131);

	// Rd = ((st32) ((sextract64(((ut64) ((((st64) Rs) * sextract64(((ut64) ((st16) ((Rt >> 0x10) & 0xffff))), 0x0, 0x10) << 0x1) + ((st64) 0x8000) >> 0x10)), 0x0, 0x20) == ((((st64) Rs) * sextract64(((ut64) ((st16) ((Rt >> 0x10) & 0xffff))), 0x0, 0x10) << 0x1) + ((st64) 0x8000) >> 0x10)) ? ((((st64) Rs) * sextract64(((ut64) ((st16) ((Rt >> 0x10) & 0xffff))), 0x0, 0x10) << 0x1) + ((st64) 0x8000) >> 0x10) : h_tmp264));
	RzILOpPure *op_RSHIFT_67 = SHIFTRA(DUP(Rt), SN(32, 16));
	RzILOpPure *op_AND_69 = LOGAND(op_RSHIFT_67, SN(32, 0xffff));
	RzILOpPure *op_MUL_76 = MUL(CAST(64, MSB(DUP(Rs)), DUP(Rs)), SEXTRACT64(CAST(64, IL_FALSE, CAST(16, MSB(op_AND_69), DUP(op_AND_69))), SN(32, 0), SN(32, 16)));
	RzILOpPure *op_LSHIFT_78 = SHIFTL0(op_MUL_76, SN(32, 1));
	RzILOpPure *op_ADD_81 = ADD(op_LSHIFT_78, CAST(64, MSB(SN(32, 0x8000)), SN(32, 0x8000)));
	RzILOpPure *op_RSHIFT_83 = SHIFTRA(op_ADD_81, SN(32, 16));
	RzILOpPure *cond_133 = ITE(DUP(op_EQ_59), op_RSHIFT_83, VARL("h_tmp264"));
	RzILOpEffect *op_ASSIGN_135 = WRITE_REG(bundle, Rd_op, CAST(32, MSB(cond_133), DUP(cond_133)));

	// seq(seq(HYB(gcc_expr_if ((sextract64(((ut64) ((((st64) Rs) * sex ...;
	RzILOpEffect *seq_136 = SEQN(2, seq_132, op_ASSIGN_135);

	RzILOpEffect *instruction_sequence = seq_136;
	return instruction_sequence;
}

// Rd = mpy(Rs,Rt.h):<<1:sat
RzILOpEffect *hex_il_op_m2_hmmpyh_s1(HexInsnPktBundle *bundle) {
	const HexInsn *hi = bundle->insn;
	HexPkt *pkt = bundle->pkt;
	// READ
	const HexOp *Rd_op = ISA2REG(hi, 'd', false);
	const HexOp *Rs_op = ISA2REG(hi, 's', false);
	RzILOpPure *Rs = READ_REG(pkt, Rs_op, false);
	const HexOp *Rt_op = ISA2REG(hi, 't', false);
	RzILOpPure *Rt = READ_REG(pkt, Rt_op, false);

	// set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, ((ut32) 0x1));
	RzILOpEffect *set_usr_field_call_77 = hex_set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, CAST(32, IL_FALSE, SN(32, 1)));

	// HYB(gcc_expr_if ((sextract64(((ut64) ((((st64) Rs) * sextract64(((ut64) ((st16) ((Rt >> 0x10) & 0xffff))), 0x0, 0x10) << 0x1) >> 0x10)), 0x0, 0x20) == ((((st64) Rs) * sextract64(((ut64) ((st16) ((Rt >> 0x10) & 0xffff))), 0x0, 0x10) << 0x1) >> 0x10))) {{}} else {set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, ((ut32) 0x1))}, ((((((st64) Rs) * sextract64(((ut64) ((st16) ((Rt >> 0x10) & 0xffff))), 0x0, 0x10) << 0x1) >> 0x10) < ((st64) 0x0)) ? (-(0x1 << 0x1f)) : (0x1 << 0x1f) - ((st64) 0x1)));
	RzILOpPure *op_RSHIFT_13 = SHIFTRA(Rt, SN(32, 16));
	RzILOpPure *op_AND_15 = LOGAND(op_RSHIFT_13, SN(32, 0xffff));
	RzILOpPure *op_MUL_22 = MUL(CAST(64, MSB(Rs), DUP(Rs)), SEXTRACT64(CAST(64, IL_FALSE, CAST(16, MSB(op_AND_15), DUP(op_AND_15))), SN(32, 0), SN(32, 16)));
	RzILOpPure *op_LSHIFT_24 = SHIFTL0(op_MUL_22, SN(32, 1));
	RzILOpPure *op_RSHIFT_26 = SHIFTRA(op_LSHIFT_24, SN(32, 16));
	RzILOpPure *op_RSHIFT_39 = SHIFTRA(DUP(Rt), SN(32, 16));
	RzILOpPure *op_AND_41 = LOGAND(op_RSHIFT_39, SN(32, 0xffff));
	RzILOpPure *op_MUL_48 = MUL(CAST(64, MSB(DUP(Rs)), DUP(Rs)), SEXTRACT64(CAST(64, IL_FALSE, CAST(16, MSB(op_AND_41), DUP(op_AND_41))), SN(32, 0), SN(32, 16)));
	RzILOpPure *op_LSHIFT_50 = SHIFTL0(op_MUL_48, SN(32, 1));
	RzILOpPure *op_RSHIFT_52 = SHIFTRA(op_LSHIFT_50, SN(32, 16));
	RzILOpPure *op_EQ_53 = EQ(SEXTRACT64(CAST(64, IL_FALSE, op_RSHIFT_26), SN(32, 0), SN(32, 0x20)), op_RSHIFT_52);
	RzILOpPure *op_RSHIFT_85 = SHIFTRA(DUP(Rt), SN(32, 16));
	RzILOpPure *op_AND_87 = LOGAND(op_RSHIFT_85, SN(32, 0xffff));
	RzILOpPure *op_MUL_94 = MUL(CAST(64, MSB(DUP(Rs)), DUP(Rs)), SEXTRACT64(CAST(64, IL_FALSE, CAST(16, MSB(op_AND_87), DUP(op_AND_87))), SN(32, 0), SN(32, 16)));
	RzILOpPure *op_LSHIFT_96 = SHIFTL0(op_MUL_94, SN(32, 1));
	RzILOpPure *op_RSHIFT_98 = SHIFTRA(op_LSHIFT_96, SN(32, 16));
	RzILOpPure *op_LT_101 = SLT(op_RSHIFT_98, CAST(64, MSB(SN(32, 0)), SN(32, 0)));
	RzILOpPure *op_LSHIFT_106 = SHIFTL0(SN(64, 1), SN(32, 31));
	RzILOpPure *op_NEG_107 = NEG(op_LSHIFT_106);
	RzILOpPure *op_LSHIFT_112 = SHIFTL0(SN(64, 1), SN(32, 31));
	RzILOpPure *op_SUB_115 = SUB(op_LSHIFT_112, CAST(64, MSB(SN(32, 1)), SN(32, 1)));
	RzILOpPure *cond_116 = ITE(op_LT_101, op_NEG_107, op_SUB_115);
	RzILOpEffect *gcc_expr_117 = BRANCH(op_EQ_53, EMPTY(), set_usr_field_call_77);

	// h_tmp265 = HYB(gcc_expr_if ((sextract64(((ut64) ((((st64) Rs) * sextract64(((ut64) ((st16) ((Rt >> 0x10) & 0xffff))), 0x0, 0x10) << 0x1) >> 0x10)), 0x0, 0x20) == ((((st64) Rs) * sextract64(((ut64) ((st16) ((Rt >> 0x10) & 0xffff))), 0x0, 0x10) << 0x1) >> 0x10))) {{}} else {set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, ((ut32) 0x1))}, ((((((st64) Rs) * sextract64(((ut64) ((st16) ((Rt >> 0x10) & 0xffff))), 0x0, 0x10) << 0x1) >> 0x10) < ((st64) 0x0)) ? (-(0x1 << 0x1f)) : (0x1 << 0x1f) - ((st64) 0x1)));
	RzILOpEffect *op_ASSIGN_hybrid_tmp_119 = SETL("h_tmp265", cond_116);

	// seq(HYB(gcc_expr_if ((sextract64(((ut64) ((((st64) Rs) * sextrac ...;
	RzILOpEffect *seq_120 = SEQN(2, gcc_expr_117, op_ASSIGN_hybrid_tmp_119);

	// Rd = ((st32) ((sextract64(((ut64) ((((st64) Rs) * sextract64(((ut64) ((st16) ((Rt >> 0x10) & 0xffff))), 0x0, 0x10) << 0x1) >> 0x10)), 0x0, 0x20) == ((((st64) Rs) * sextract64(((ut64) ((st16) ((Rt >> 0x10) & 0xffff))), 0x0, 0x10) << 0x1) >> 0x10)) ? ((((st64) Rs) * sextract64(((ut64) ((st16) ((Rt >> 0x10) & 0xffff))), 0x0, 0x10) << 0x1) >> 0x10) : h_tmp265));
	RzILOpPure *op_RSHIFT_61 = SHIFTRA(DUP(Rt), SN(32, 16));
	RzILOpPure *op_AND_63 = LOGAND(op_RSHIFT_61, SN(32, 0xffff));
	RzILOpPure *op_MUL_70 = MUL(CAST(64, MSB(DUP(Rs)), DUP(Rs)), SEXTRACT64(CAST(64, IL_FALSE, CAST(16, MSB(op_AND_63), DUP(op_AND_63))), SN(32, 0), SN(32, 16)));
	RzILOpPure *op_LSHIFT_72 = SHIFTL0(op_MUL_70, SN(32, 1));
	RzILOpPure *op_RSHIFT_74 = SHIFTRA(op_LSHIFT_72, SN(32, 16));
	RzILOpPure *cond_121 = ITE(DUP(op_EQ_53), op_RSHIFT_74, VARL("h_tmp265"));
	RzILOpEffect *op_ASSIGN_123 = WRITE_REG(bundle, Rd_op, CAST(32, MSB(cond_121), DUP(cond_121)));

	// seq(seq(HYB(gcc_expr_if ((sextract64(((ut64) ((((st64) Rs) * sex ...;
	RzILOpEffect *seq_124 = SEQN(2, seq_120, op_ASSIGN_123);

	RzILOpEffect *instruction_sequence = seq_124;
	return instruction_sequence;
}

// Rd = mpy(Rs,Rt.l):<<1:rnd:sat
RzILOpEffect *hex_il_op_m2_hmmpyl_rs1(HexInsnPktBundle *bundle) {
	const HexInsn *hi = bundle->insn;
	HexPkt *pkt = bundle->pkt;
	// READ
	const HexOp *Rd_op = ISA2REG(hi, 'd', false);
	const HexOp *Rs_op = ISA2REG(hi, 's', false);
	RzILOpPure *Rs = READ_REG(pkt, Rs_op, false);
	const HexOp *Rt_op = ISA2REG(hi, 't', false);
	RzILOpPure *Rt = READ_REG(pkt, Rt_op, false);

	// set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, ((ut32) 0x1));
	RzILOpEffect *set_usr_field_call_86 = hex_set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, CAST(32, IL_FALSE, SN(32, 1)));

	// HYB(gcc_expr_if ((sextract64(((ut64) ((((st64) Rs) * sextract64(((ut64) ((st16) ((Rt >> 0x0) & 0xffff))), 0x0, 0x10) << 0x1) + ((st64) 0x8000) >> 0x10)), 0x0, 0x20) == ((((st64) Rs) * sextract64(((ut64) ((st16) ((Rt >> 0x0) & 0xffff))), 0x0, 0x10) << 0x1) + ((st64) 0x8000) >> 0x10))) {{}} else {set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, ((ut32) 0x1))}, ((((((st64) Rs) * sextract64(((ut64) ((st16) ((Rt >> 0x0) & 0xffff))), 0x0, 0x10) << 0x1) + ((st64) 0x8000) >> 0x10) < ((st64) 0x0)) ? (-(0x1 << 0x1f)) : (0x1 << 0x1f) - ((st64) 0x1)));
	RzILOpPure *op_RSHIFT_13 = SHIFTRA(Rt, SN(32, 0));
	RzILOpPure *op_AND_15 = LOGAND(op_RSHIFT_13, SN(32, 0xffff));
	RzILOpPure *op_MUL_22 = MUL(CAST(64, MSB(Rs), DUP(Rs)), SEXTRACT64(CAST(64, IL_FALSE, CAST(16, MSB(op_AND_15), DUP(op_AND_15))), SN(32, 0), SN(32, 16)));
	RzILOpPure *op_LSHIFT_24 = SHIFTL0(op_MUL_22, SN(32, 1));
	RzILOpPure *op_ADD_27 = ADD(op_LSHIFT_24, CAST(64, MSB(SN(32, 0x8000)), SN(32, 0x8000)));
	RzILOpPure *op_RSHIFT_29 = SHIFTRA(op_ADD_27, SN(32, 16));
	RzILOpPure *op_RSHIFT_42 = SHIFTRA(DUP(Rt), SN(32, 0));
	RzILOpPure *op_AND_44 = LOGAND(op_RSHIFT_42, SN(32, 0xffff));
	RzILOpPure *op_MUL_51 = MUL(CAST(64, MSB(DUP(Rs)), DUP(Rs)), SEXTRACT64(CAST(64, IL_FALSE, CAST(16, MSB(op_AND_44), DUP(op_AND_44))), SN(32, 0), SN(32, 16)));
	RzILOpPure *op_LSHIFT_53 = SHIFTL0(op_MUL_51, SN(32, 1));
	RzILOpPure *op_ADD_56 = ADD(op_LSHIFT_53, CAST(64, MSB(SN(32, 0x8000)), SN(32, 0x8000)));
	RzILOpPure *op_RSHIFT_58 = SHIFTRA(op_ADD_56, SN(32, 16));
	RzILOpPure *op_EQ_59 = EQ(SEXTRACT64(CAST(64, IL_FALSE, op_RSHIFT_29), SN(32, 0), SN(32, 0x20)), op_RSHIFT_58);
	RzILOpPure *op_RSHIFT_94 = SHIFTRA(DUP(Rt), SN(32, 0));
	RzILOpPure *op_AND_96 = LOGAND(op_RSHIFT_94, SN(32, 0xffff));
	RzILOpPure *op_MUL_103 = MUL(CAST(64, MSB(DUP(Rs)), DUP(Rs)), SEXTRACT64(CAST(64, IL_FALSE, CAST(16, MSB(op_AND_96), DUP(op_AND_96))), SN(32, 0), SN(32, 16)));
	RzILOpPure *op_LSHIFT_105 = SHIFTL0(op_MUL_103, SN(32, 1));
	RzILOpPure *op_ADD_108 = ADD(op_LSHIFT_105, CAST(64, MSB(SN(32, 0x8000)), SN(32, 0x8000)));
	RzILOpPure *op_RSHIFT_110 = SHIFTRA(op_ADD_108, SN(32, 16));
	RzILOpPure *op_LT_113 = SLT(op_RSHIFT_110, CAST(64, MSB(SN(32, 0)), SN(32, 0)));
	RzILOpPure *op_LSHIFT_118 = SHIFTL0(SN(64, 1), SN(32, 31));
	RzILOpPure *op_NEG_119 = NEG(op_LSHIFT_118);
	RzILOpPure *op_LSHIFT_124 = SHIFTL0(SN(64, 1), SN(32, 31));
	RzILOpPure *op_SUB_127 = SUB(op_LSHIFT_124, CAST(64, MSB(SN(32, 1)), SN(32, 1)));
	RzILOpPure *cond_128 = ITE(op_LT_113, op_NEG_119, op_SUB_127);
	RzILOpEffect *gcc_expr_129 = BRANCH(op_EQ_59, EMPTY(), set_usr_field_call_86);

	// h_tmp266 = HYB(gcc_expr_if ((sextract64(((ut64) ((((st64) Rs) * sextract64(((ut64) ((st16) ((Rt >> 0x0) & 0xffff))), 0x0, 0x10) << 0x1) + ((st64) 0x8000) >> 0x10)), 0x0, 0x20) == ((((st64) Rs) * sextract64(((ut64) ((st16) ((Rt >> 0x0) & 0xffff))), 0x0, 0x10) << 0x1) + ((st64) 0x8000) >> 0x10))) {{}} else {set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, ((ut32) 0x1))}, ((((((st64) Rs) * sextract64(((ut64) ((st16) ((Rt >> 0x0) & 0xffff))), 0x0, 0x10) << 0x1) + ((st64) 0x8000) >> 0x10) < ((st64) 0x0)) ? (-(0x1 << 0x1f)) : (0x1 << 0x1f) - ((st64) 0x1)));
	RzILOpEffect *op_ASSIGN_hybrid_tmp_131 = SETL("h_tmp266", cond_128);

	// seq(HYB(gcc_expr_if ((sextract64(((ut64) ((((st64) Rs) * sextrac ...;
	RzILOpEffect *seq_132 = SEQN(2, gcc_expr_129, op_ASSIGN_hybrid_tmp_131);

	// Rd = ((st32) ((sextract64(((ut64) ((((st64) Rs) * sextract64(((ut64) ((st16) ((Rt >> 0x0) & 0xffff))), 0x0, 0x10) << 0x1) + ((st64) 0x8000) >> 0x10)), 0x0, 0x20) == ((((st64) Rs) * sextract64(((ut64) ((st16) ((Rt >> 0x0) & 0xffff))), 0x0, 0x10) << 0x1) + ((st64) 0x8000) >> 0x10)) ? ((((st64) Rs) * sextract64(((ut64) ((st16) ((Rt >> 0x0) & 0xffff))), 0x0, 0x10) << 0x1) + ((st64) 0x8000) >> 0x10) : h_tmp266));
	RzILOpPure *op_RSHIFT_67 = SHIFTRA(DUP(Rt), SN(32, 0));
	RzILOpPure *op_AND_69 = LOGAND(op_RSHIFT_67, SN(32, 0xffff));
	RzILOpPure *op_MUL_76 = MUL(CAST(64, MSB(DUP(Rs)), DUP(Rs)), SEXTRACT64(CAST(64, IL_FALSE, CAST(16, MSB(op_AND_69), DUP(op_AND_69))), SN(32, 0), SN(32, 16)));
	RzILOpPure *op_LSHIFT_78 = SHIFTL0(op_MUL_76, SN(32, 1));
	RzILOpPure *op_ADD_81 = ADD(op_LSHIFT_78, CAST(64, MSB(SN(32, 0x8000)), SN(32, 0x8000)));
	RzILOpPure *op_RSHIFT_83 = SHIFTRA(op_ADD_81, SN(32, 16));
	RzILOpPure *cond_133 = ITE(DUP(op_EQ_59), op_RSHIFT_83, VARL("h_tmp266"));
	RzILOpEffect *op_ASSIGN_135 = WRITE_REG(bundle, Rd_op, CAST(32, MSB(cond_133), DUP(cond_133)));

	// seq(seq(HYB(gcc_expr_if ((sextract64(((ut64) ((((st64) Rs) * sex ...;
	RzILOpEffect *seq_136 = SEQN(2, seq_132, op_ASSIGN_135);

	RzILOpEffect *instruction_sequence = seq_136;
	return instruction_sequence;
}

// Rd = mpy(Rs,Rt.l):<<1:sat
RzILOpEffect *hex_il_op_m2_hmmpyl_s1(HexInsnPktBundle *bundle) {
	const HexInsn *hi = bundle->insn;
	HexPkt *pkt = bundle->pkt;
	// READ
	const HexOp *Rd_op = ISA2REG(hi, 'd', false);
	const HexOp *Rs_op = ISA2REG(hi, 's', false);
	RzILOpPure *Rs = READ_REG(pkt, Rs_op, false);
	const HexOp *Rt_op = ISA2REG(hi, 't', false);
	RzILOpPure *Rt = READ_REG(pkt, Rt_op, false);

	// set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, ((ut32) 0x1));
	RzILOpEffect *set_usr_field_call_77 = hex_set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, CAST(32, IL_FALSE, SN(32, 1)));

	// HYB(gcc_expr_if ((sextract64(((ut64) ((((st64) Rs) * sextract64(((ut64) ((st16) ((Rt >> 0x0) & 0xffff))), 0x0, 0x10) << 0x1) >> 0x10)), 0x0, 0x20) == ((((st64) Rs) * sextract64(((ut64) ((st16) ((Rt >> 0x0) & 0xffff))), 0x0, 0x10) << 0x1) >> 0x10))) {{}} else {set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, ((ut32) 0x1))}, ((((((st64) Rs) * sextract64(((ut64) ((st16) ((Rt >> 0x0) & 0xffff))), 0x0, 0x10) << 0x1) >> 0x10) < ((st64) 0x0)) ? (-(0x1 << 0x1f)) : (0x1 << 0x1f) - ((st64) 0x1)));
	RzILOpPure *op_RSHIFT_13 = SHIFTRA(Rt, SN(32, 0));
	RzILOpPure *op_AND_15 = LOGAND(op_RSHIFT_13, SN(32, 0xffff));
	RzILOpPure *op_MUL_22 = MUL(CAST(64, MSB(Rs), DUP(Rs)), SEXTRACT64(CAST(64, IL_FALSE, CAST(16, MSB(op_AND_15), DUP(op_AND_15))), SN(32, 0), SN(32, 16)));
	RzILOpPure *op_LSHIFT_24 = SHIFTL0(op_MUL_22, SN(32, 1));
	RzILOpPure *op_RSHIFT_26 = SHIFTRA(op_LSHIFT_24, SN(32, 16));
	RzILOpPure *op_RSHIFT_39 = SHIFTRA(DUP(Rt), SN(32, 0));
	RzILOpPure *op_AND_41 = LOGAND(op_RSHIFT_39, SN(32, 0xffff));
	RzILOpPure *op_MUL_48 = MUL(CAST(64, MSB(DUP(Rs)), DUP(Rs)), SEXTRACT64(CAST(64, IL_FALSE, CAST(16, MSB(op_AND_41), DUP(op_AND_41))), SN(32, 0), SN(32, 16)));
	RzILOpPure *op_LSHIFT_50 = SHIFTL0(op_MUL_48, SN(32, 1));
	RzILOpPure *op_RSHIFT_52 = SHIFTRA(op_LSHIFT_50, SN(32, 16));
	RzILOpPure *op_EQ_53 = EQ(SEXTRACT64(CAST(64, IL_FALSE, op_RSHIFT_26), SN(32, 0), SN(32, 0x20)), op_RSHIFT_52);
	RzILOpPure *op_RSHIFT_85 = SHIFTRA(DUP(Rt), SN(32, 0));
	RzILOpPure *op_AND_87 = LOGAND(op_RSHIFT_85, SN(32, 0xffff));
	RzILOpPure *op_MUL_94 = MUL(CAST(64, MSB(DUP(Rs)), DUP(Rs)), SEXTRACT64(CAST(64, IL_FALSE, CAST(16, MSB(op_AND_87), DUP(op_AND_87))), SN(32, 0), SN(32, 16)));
	RzILOpPure *op_LSHIFT_96 = SHIFTL0(op_MUL_94, SN(32, 1));
	RzILOpPure *op_RSHIFT_98 = SHIFTRA(op_LSHIFT_96, SN(32, 16));
	RzILOpPure *op_LT_101 = SLT(op_RSHIFT_98, CAST(64, MSB(SN(32, 0)), SN(32, 0)));
	RzILOpPure *op_LSHIFT_106 = SHIFTL0(SN(64, 1), SN(32, 31));
	RzILOpPure *op_NEG_107 = NEG(op_LSHIFT_106);
	RzILOpPure *op_LSHIFT_112 = SHIFTL0(SN(64, 1), SN(32, 31));
	RzILOpPure *op_SUB_115 = SUB(op_LSHIFT_112, CAST(64, MSB(SN(32, 1)), SN(32, 1)));
	RzILOpPure *cond_116 = ITE(op_LT_101, op_NEG_107, op_SUB_115);
	RzILOpEffect *gcc_expr_117 = BRANCH(op_EQ_53, EMPTY(), set_usr_field_call_77);

	// h_tmp267 = HYB(gcc_expr_if ((sextract64(((ut64) ((((st64) Rs) * sextract64(((ut64) ((st16) ((Rt >> 0x0) & 0xffff))), 0x0, 0x10) << 0x1) >> 0x10)), 0x0, 0x20) == ((((st64) Rs) * sextract64(((ut64) ((st16) ((Rt >> 0x0) & 0xffff))), 0x0, 0x10) << 0x1) >> 0x10))) {{}} else {set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, ((ut32) 0x1))}, ((((((st64) Rs) * sextract64(((ut64) ((st16) ((Rt >> 0x0) & 0xffff))), 0x0, 0x10) << 0x1) >> 0x10) < ((st64) 0x0)) ? (-(0x1 << 0x1f)) : (0x1 << 0x1f) - ((st64) 0x1)));
	RzILOpEffect *op_ASSIGN_hybrid_tmp_119 = SETL("h_tmp267", cond_116);

	// seq(HYB(gcc_expr_if ((sextract64(((ut64) ((((st64) Rs) * sextrac ...;
	RzILOpEffect *seq_120 = SEQN(2, gcc_expr_117, op_ASSIGN_hybrid_tmp_119);

	// Rd = ((st32) ((sextract64(((ut64) ((((st64) Rs) * sextract64(((ut64) ((st16) ((Rt >> 0x0) & 0xffff))), 0x0, 0x10) << 0x1) >> 0x10)), 0x0, 0x20) == ((((st64) Rs) * sextract64(((ut64) ((st16) ((Rt >> 0x0) & 0xffff))), 0x0, 0x10) << 0x1) >> 0x10)) ? ((((st64) Rs) * sextract64(((ut64) ((st16) ((Rt >> 0x0) & 0xffff))), 0x0, 0x10) << 0x1) >> 0x10) : h_tmp267));
	RzILOpPure *op_RSHIFT_61 = SHIFTRA(DUP(Rt), SN(32, 0));
	RzILOpPure *op_AND_63 = LOGAND(op_RSHIFT_61, SN(32, 0xffff));
	RzILOpPure *op_MUL_70 = MUL(CAST(64, MSB(DUP(Rs)), DUP(Rs)), SEXTRACT64(CAST(64, IL_FALSE, CAST(16, MSB(op_AND_63), DUP(op_AND_63))), SN(32, 0), SN(32, 16)));
	RzILOpPure *op_LSHIFT_72 = SHIFTL0(op_MUL_70, SN(32, 1));
	RzILOpPure *op_RSHIFT_74 = SHIFTRA(op_LSHIFT_72, SN(32, 16));
	RzILOpPure *cond_121 = ITE(DUP(op_EQ_53), op_RSHIFT_74, VARL("h_tmp267"));
	RzILOpEffect *op_ASSIGN_123 = WRITE_REG(bundle, Rd_op, CAST(32, MSB(cond_121), DUP(cond_121)));

	// seq(seq(HYB(gcc_expr_if ((sextract64(((ut64) ((((st64) Rs) * sex ...;
	RzILOpEffect *seq_124 = SEQN(2, seq_120, op_ASSIGN_123);

	RzILOpEffect *instruction_sequence = seq_124;
	return instruction_sequence;
}

// Rx += mpyi(Rs,Rt)
RzILOpEffect *hex_il_op_m2_maci(HexInsnPktBundle *bundle) {
	const HexInsn *hi = bundle->insn;
	HexPkt *pkt = bundle->pkt;
	// READ
	const HexOp *Rx_op = ISA2REG(hi, 'x', false);

	const HexOp *Rs_op = ISA2REG(hi, 's', false);
	RzILOpPure *Rs = READ_REG(pkt, Rs_op, false);
	const HexOp *Rt_op = ISA2REG(hi, 't', false);
	RzILOpPure *Rt = READ_REG(pkt, Rt_op, false);

	// Rx = Rx + Rs * Rt;
	RzILOpPure *op_MUL_3 = MUL(Rs, Rt);
	RzILOpPure *op_ADD_4 = ADD(READ_REG(pkt, Rx_op, false), op_MUL_3);
	RzILOpEffect *op_ASSIGN_5 = WRITE_REG(bundle, Rx_op, op_ADD_4);

	RzILOpEffect *instruction_sequence = op_ASSIGN_5;
	return instruction_sequence;
}

// Rx -= mpyi(Rs,Ii)
RzILOpEffect *hex_il_op_m2_macsin(HexInsnPktBundle *bundle) {
	const HexInsn *hi = bundle->insn;
	HexPkt *pkt = bundle->pkt;
	// READ
	RzILOpPure *u = UN(32, (ut32)ISA2IMM(hi, 'u'));
	const HexOp *Rx_op = ISA2REG(hi, 'x', false);

	const HexOp *Rs_op = ISA2REG(hi, 's', false);
	RzILOpPure *Rs = READ_REG(pkt, Rs_op, false);

	// u = u;
	RzILOpEffect *imm_assign_0 = SETL("u", u);

	// Rx = ((st32) ((ut32) Rx) - ((ut32) Rs) * u);
	RzILOpPure *op_MUL_5 = MUL(CAST(32, IL_FALSE, Rs), VARL("u"));
	RzILOpPure *op_SUB_7 = SUB(CAST(32, IL_FALSE, READ_REG(pkt, Rx_op, false)), op_MUL_5);
	RzILOpEffect *op_ASSIGN_9 = WRITE_REG(bundle, Rx_op, CAST(32, IL_FALSE, op_SUB_7));

	RzILOpEffect *instruction_sequence = SEQN(2, imm_assign_0, op_ASSIGN_9);
	return instruction_sequence;
}

// Rx += mpyi(Rs,Ii)
RzILOpEffect *hex_il_op_m2_macsip(HexInsnPktBundle *bundle) {
	const HexInsn *hi = bundle->insn;
	HexPkt *pkt = bundle->pkt;
	// READ
	RzILOpPure *u = UN(32, (ut32)ISA2IMM(hi, 'u'));
	const HexOp *Rx_op = ISA2REG(hi, 'x', false);

	const HexOp *Rs_op = ISA2REG(hi, 's', false);
	RzILOpPure *Rs = READ_REG(pkt, Rs_op, false);

	// u = u;
	RzILOpEffect *imm_assign_0 = SETL("u", u);

	// Rx = ((st32) ((ut32) Rx) + ((ut32) Rs) * u);
	RzILOpPure *op_MUL_5 = MUL(CAST(32, IL_FALSE, Rs), VARL("u"));
	RzILOpPure *op_ADD_7 = ADD(CAST(32, IL_FALSE, READ_REG(pkt, Rx_op, false)), op_MUL_5);
	RzILOpEffect *op_ASSIGN_9 = WRITE_REG(bundle, Rx_op, CAST(32, IL_FALSE, op_ADD_7));

	RzILOpEffect *instruction_sequence = SEQN(2, imm_assign_0, op_ASSIGN_9);
	return instruction_sequence;
}

// Rxx += vmpywoh(Rss,Rtt):rnd:sat
RzILOpEffect *hex_il_op_m2_mmachs_rs0(HexInsnPktBundle *bundle) {
	const HexInsn *hi = bundle->insn;
	HexPkt *pkt = bundle->pkt;
	// READ
	const HexOp *Rxx_op = ISA2REG(hi, 'x', false);

	const HexOp *Rss_op = ISA2REG(hi, 's', false);
	RzILOpPure *Rss = READ_REG(pkt, Rss_op, false);
	const HexOp *Rtt_op = ISA2REG(hi, 't', false);
	RzILOpPure *Rtt = READ_REG(pkt, Rtt_op, false);

	// set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, ((ut32) 0x1));
	RzILOpEffect *set_usr_field_call_150 = hex_set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, CAST(32, IL_FALSE, SN(32, 1)));

	// HYB(gcc_expr_if ((sextract64(((ut64) ((st64) ((st32) ((Rxx >> 0x20) & 0xffffffff))) + ((((st64) ((st32) ((st64) ((st32) ((Rss >> 0x20) & 0xffffffff))))) * sextract64(((ut64) ((st16) ((Rtt >> 0x30) & ((st64) 0xffff)))), 0x0, 0x10) << 0x0) + ((st64) 0x8000) >> 0x10)), 0x0, 0x20) == ((st64) ((st32) ((Rxx >> 0x20) & 0xffffffff))) + ((((st64) ((st32) ((st64) ((st32) ((Rss >> 0x20) & 0xffffffff))))) * sextract64(((ut64) ((st16) ((Rtt >> 0x30) & ((st64) 0xffff)))), 0x0, 0x10) << 0x0) + ((st64) 0x8000) >> 0x10))) {{}} else {set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, ((ut32) 0x1))}, ((((st64) ((st32) ((Rxx >> 0x20) & 0xffffffff))) + ((((st64) ((st32) ((st64) ((st32) ((Rss >> 0x20) & 0xffffffff))))) * sextract64(((ut64) ((st16) ((Rtt >> 0x30) & ((st64) 0xffff)))), 0x0, 0x10) << 0x0) + ((st64) 0x8000) >> 0x10) < ((st64) 0x0)) ? (-(0x1 << 0x1f)) : (0x1 << 0x1f) - ((st64) 0x1)));
	RzILOpPure *op_RSHIFT_14 = SHIFTRA(READ_REG(pkt, Rxx_op, false), SN(32, 0x20));
	RzILOpPure *op_AND_16 = LOGAND(op_RSHIFT_14, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_23 = SHIFTRA(Rss, SN(32, 0x20));
	RzILOpPure *op_AND_25 = LOGAND(op_RSHIFT_23, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_37 = SHIFTRA(Rtt, SN(32, 0x30));
	RzILOpPure *op_AND_40 = LOGAND(op_RSHIFT_37, CAST(64, MSB(SN(32, 0xffff)), SN(32, 0xffff)));
	RzILOpPure *op_MUL_47 = MUL(CAST(64, MSB(CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(op_AND_25), DUP(op_AND_25))), CAST(32, MSB(DUP(op_AND_25)), DUP(op_AND_25)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_25)), DUP(op_AND_25))), CAST(32, MSB(DUP(op_AND_25)), DUP(op_AND_25))))), CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(DUP(op_AND_25)), DUP(op_AND_25))), CAST(32, MSB(DUP(op_AND_25)), DUP(op_AND_25)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_25)), DUP(op_AND_25))), CAST(32, MSB(DUP(op_AND_25)), DUP(op_AND_25))))), SEXTRACT64(CAST(64, IL_FALSE, CAST(16, MSB(op_AND_40), DUP(op_AND_40))), SN(32, 0), SN(32, 16)));
	RzILOpPure *op_LSHIFT_49 = SHIFTL0(op_MUL_47, SN(32, 0));
	RzILOpPure *op_ADD_52 = ADD(op_LSHIFT_49, CAST(64, MSB(SN(32, 0x8000)), SN(32, 0x8000)));
	RzILOpPure *op_RSHIFT_54 = SHIFTRA(op_ADD_52, SN(32, 16));
	RzILOpPure *op_ADD_55 = ADD(CAST(64, MSB(CAST(32, MSB(op_AND_16), DUP(op_AND_16))), CAST(32, MSB(DUP(op_AND_16)), DUP(op_AND_16))), op_RSHIFT_54);
	RzILOpPure *op_RSHIFT_64 = SHIFTRA(READ_REG(pkt, Rxx_op, false), SN(32, 0x20));
	RzILOpPure *op_AND_66 = LOGAND(op_RSHIFT_64, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_72 = SHIFTRA(DUP(Rss), SN(32, 0x20));
	RzILOpPure *op_AND_74 = LOGAND(op_RSHIFT_72, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_85 = SHIFTRA(DUP(Rtt), SN(32, 0x30));
	RzILOpPure *op_AND_88 = LOGAND(op_RSHIFT_85, CAST(64, MSB(SN(32, 0xffff)), SN(32, 0xffff)));
	RzILOpPure *op_MUL_95 = MUL(CAST(64, MSB(CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(op_AND_74), DUP(op_AND_74))), CAST(32, MSB(DUP(op_AND_74)), DUP(op_AND_74)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_74)), DUP(op_AND_74))), CAST(32, MSB(DUP(op_AND_74)), DUP(op_AND_74))))), CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(DUP(op_AND_74)), DUP(op_AND_74))), CAST(32, MSB(DUP(op_AND_74)), DUP(op_AND_74)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_74)), DUP(op_AND_74))), CAST(32, MSB(DUP(op_AND_74)), DUP(op_AND_74))))), SEXTRACT64(CAST(64, IL_FALSE, CAST(16, MSB(op_AND_88), DUP(op_AND_88))), SN(32, 0), SN(32, 16)));
	RzILOpPure *op_LSHIFT_97 = SHIFTL0(op_MUL_95, SN(32, 0));
	RzILOpPure *op_ADD_100 = ADD(op_LSHIFT_97, CAST(64, MSB(SN(32, 0x8000)), SN(32, 0x8000)));
	RzILOpPure *op_RSHIFT_102 = SHIFTRA(op_ADD_100, SN(32, 16));
	RzILOpPure *op_ADD_103 = ADD(CAST(64, MSB(CAST(32, MSB(op_AND_66), DUP(op_AND_66))), CAST(32, MSB(DUP(op_AND_66)), DUP(op_AND_66))), op_RSHIFT_102);
	RzILOpPure *op_EQ_104 = EQ(SEXTRACT64(CAST(64, IL_FALSE, op_ADD_55), SN(32, 0), SN(32, 0x20)), op_ADD_103);
	RzILOpPure *op_RSHIFT_154 = SHIFTRA(READ_REG(pkt, Rxx_op, false), SN(32, 0x20));
	RzILOpPure *op_AND_156 = LOGAND(op_RSHIFT_154, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_162 = SHIFTRA(DUP(Rss), SN(32, 0x20));
	RzILOpPure *op_AND_164 = LOGAND(op_RSHIFT_162, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_175 = SHIFTRA(DUP(Rtt), SN(32, 0x30));
	RzILOpPure *op_AND_178 = LOGAND(op_RSHIFT_175, CAST(64, MSB(SN(32, 0xffff)), SN(32, 0xffff)));
	RzILOpPure *op_MUL_185 = MUL(CAST(64, MSB(CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(op_AND_164), DUP(op_AND_164))), CAST(32, MSB(DUP(op_AND_164)), DUP(op_AND_164)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_164)), DUP(op_AND_164))), CAST(32, MSB(DUP(op_AND_164)), DUP(op_AND_164))))), CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(DUP(op_AND_164)), DUP(op_AND_164))), CAST(32, MSB(DUP(op_AND_164)), DUP(op_AND_164)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_164)), DUP(op_AND_164))), CAST(32, MSB(DUP(op_AND_164)), DUP(op_AND_164))))), SEXTRACT64(CAST(64, IL_FALSE, CAST(16, MSB(op_AND_178), DUP(op_AND_178))), SN(32, 0), SN(32, 16)));
	RzILOpPure *op_LSHIFT_187 = SHIFTL0(op_MUL_185, SN(32, 0));
	RzILOpPure *op_ADD_190 = ADD(op_LSHIFT_187, CAST(64, MSB(SN(32, 0x8000)), SN(32, 0x8000)));
	RzILOpPure *op_RSHIFT_192 = SHIFTRA(op_ADD_190, SN(32, 16));
	RzILOpPure *op_ADD_193 = ADD(CAST(64, MSB(CAST(32, MSB(op_AND_156), DUP(op_AND_156))), CAST(32, MSB(DUP(op_AND_156)), DUP(op_AND_156))), op_RSHIFT_192);
	RzILOpPure *op_LT_196 = SLT(op_ADD_193, CAST(64, MSB(SN(32, 0)), SN(32, 0)));
	RzILOpPure *op_LSHIFT_201 = SHIFTL0(SN(64, 1), SN(32, 31));
	RzILOpPure *op_NEG_202 = NEG(op_LSHIFT_201);
	RzILOpPure *op_LSHIFT_207 = SHIFTL0(SN(64, 1), SN(32, 31));
	RzILOpPure *op_SUB_210 = SUB(op_LSHIFT_207, CAST(64, MSB(SN(32, 1)), SN(32, 1)));
	RzILOpPure *cond_211 = ITE(op_LT_196, op_NEG_202, op_SUB_210);
	RzILOpEffect *gcc_expr_212 = BRANCH(op_EQ_104, EMPTY(), set_usr_field_call_150);

	// h_tmp268 = HYB(gcc_expr_if ((sextract64(((ut64) ((st64) ((st32) ((Rxx >> 0x20) & 0xffffffff))) + ((((st64) ((st32) ((st64) ((st32) ((Rss >> 0x20) & 0xffffffff))))) * sextract64(((ut64) ((st16) ((Rtt >> 0x30) & ((st64) 0xffff)))), 0x0, 0x10) << 0x0) + ((st64) 0x8000) >> 0x10)), 0x0, 0x20) == ((st64) ((st32) ((Rxx >> 0x20) & 0xffffffff))) + ((((st64) ((st32) ((st64) ((st32) ((Rss >> 0x20) & 0xffffffff))))) * sextract64(((ut64) ((st16) ((Rtt >> 0x30) & ((st64) 0xffff)))), 0x0, 0x10) << 0x0) + ((st64) 0x8000) >> 0x10))) {{}} else {set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, ((ut32) 0x1))}, ((((st64) ((st32) ((Rxx >> 0x20) & 0xffffffff))) + ((((st64) ((st32) ((st64) ((st32) ((Rss >> 0x20) & 0xffffffff))))) * sextract64(((ut64) ((st16) ((Rtt >> 0x30) & ((st64) 0xffff)))), 0x0, 0x10) << 0x0) + ((st64) 0x8000) >> 0x10) < ((st64) 0x0)) ? (-(0x1 << 0x1f)) : (0x1 << 0x1f) - ((st64) 0x1)));
	RzILOpEffect *op_ASSIGN_hybrid_tmp_214 = SETL("h_tmp268", cond_211);

	// seq(HYB(gcc_expr_if ((sextract64(((ut64) ((st64) ((st32) ((Rxx > ...;
	RzILOpEffect *seq_215 = SEQN(2, gcc_expr_212, op_ASSIGN_hybrid_tmp_214);

	// Rxx = ((Rxx & (~(0xffffffff << 0x20))) | ((((sextract64(((ut64) ((st64) ((st32) ((Rxx >> 0x20) & 0xffffffff))) + ((((st64) ((st32) ((st64) ((st32) ((Rss >> 0x20) & 0xffffffff))))) * sextract64(((ut64) ((st16) ((Rtt >> 0x30) & ((st64) 0xffff)))), 0x0, 0x10) << 0x0) + ((st64) 0x8000) >> 0x10)), 0x0, 0x20) == ((st64) ((st32) ((Rxx >> 0x20) & 0xffffffff))) + ((((st64) ((st32) ((st64) ((st32) ((Rss >> 0x20) & 0xffffffff))))) * sextract64(((ut64) ((st16) ((Rtt >> 0x30) & ((st64) 0xffff)))), 0x0, 0x10) << 0x0) + ((st64) 0x8000) >> 0x10)) ? ((st64) ((st32) ((Rxx >> 0x20) & 0xffffffff))) + ((((st64) ((st32) ((st64) ((st32) ((Rss >> 0x20) & 0xffffffff))))) * sextract64(((ut64) ((st16) ((Rtt >> 0x30) & ((st64) 0xffff)))), 0x0, 0x10) << 0x0) + ((st64) 0x8000) >> 0x10) : h_tmp268) & 0xffffffff) << 0x20));
	RzILOpPure *op_LSHIFT_5 = SHIFTL0(SN(64, 0xffffffff), SN(32, 0x20));
	RzILOpPure *op_NOT_6 = LOGNOT(op_LSHIFT_5);
	RzILOpPure *op_AND_7 = LOGAND(READ_REG(pkt, Rxx_op, false), op_NOT_6);
	RzILOpPure *op_RSHIFT_108 = SHIFTRA(READ_REG(pkt, Rxx_op, false), SN(32, 0x20));
	RzILOpPure *op_AND_110 = LOGAND(op_RSHIFT_108, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_116 = SHIFTRA(DUP(Rss), SN(32, 0x20));
	RzILOpPure *op_AND_118 = LOGAND(op_RSHIFT_116, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_129 = SHIFTRA(DUP(Rtt), SN(32, 0x30));
	RzILOpPure *op_AND_132 = LOGAND(op_RSHIFT_129, CAST(64, MSB(SN(32, 0xffff)), SN(32, 0xffff)));
	RzILOpPure *op_MUL_139 = MUL(CAST(64, MSB(CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(op_AND_118), DUP(op_AND_118))), CAST(32, MSB(DUP(op_AND_118)), DUP(op_AND_118)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_118)), DUP(op_AND_118))), CAST(32, MSB(DUP(op_AND_118)), DUP(op_AND_118))))), CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(DUP(op_AND_118)), DUP(op_AND_118))), CAST(32, MSB(DUP(op_AND_118)), DUP(op_AND_118)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_118)), DUP(op_AND_118))), CAST(32, MSB(DUP(op_AND_118)), DUP(op_AND_118))))), SEXTRACT64(CAST(64, IL_FALSE, CAST(16, MSB(op_AND_132), DUP(op_AND_132))), SN(32, 0), SN(32, 16)));
	RzILOpPure *op_LSHIFT_141 = SHIFTL0(op_MUL_139, SN(32, 0));
	RzILOpPure *op_ADD_144 = ADD(op_LSHIFT_141, CAST(64, MSB(SN(32, 0x8000)), SN(32, 0x8000)));
	RzILOpPure *op_RSHIFT_146 = SHIFTRA(op_ADD_144, SN(32, 16));
	RzILOpPure *op_ADD_147 = ADD(CAST(64, MSB(CAST(32, MSB(op_AND_110), DUP(op_AND_110))), CAST(32, MSB(DUP(op_AND_110)), DUP(op_AND_110))), op_RSHIFT_146);
	RzILOpPure *cond_216 = ITE(DUP(op_EQ_104), op_ADD_147, VARL("h_tmp268"));
	RzILOpPure *op_AND_218 = LOGAND(cond_216, SN(64, 0xffffffff));
	RzILOpPure *op_LSHIFT_222 = SHIFTL0(op_AND_218, SN(32, 0x20));
	RzILOpPure *op_OR_223 = LOGOR(op_AND_7, op_LSHIFT_222);
	RzILOpEffect *op_ASSIGN_224 = WRITE_REG(bundle, Rxx_op, op_OR_223);

	// seq(seq(HYB(gcc_expr_if ((sextract64(((ut64) ((st64) ((st32) ((R ...;
	RzILOpEffect *seq_225 = SEQN(2, seq_215, op_ASSIGN_224);

	// set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, ((ut32) 0x1));
	RzILOpEffect *set_usr_field_call_374 = hex_set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, CAST(32, IL_FALSE, SN(32, 1)));

	// HYB(gcc_expr_if ((sextract64(((ut64) ((st64) ((st32) ((Rxx >> 0x0) & 0xffffffff))) + ((((st64) ((st32) ((st64) ((st32) ((Rss >> 0x0) & 0xffffffff))))) * sextract64(((ut64) ((st16) ((Rtt >> 0x10) & ((st64) 0xffff)))), 0x0, 0x10) << 0x0) + ((st64) 0x8000) >> 0x10)), 0x0, 0x20) == ((st64) ((st32) ((Rxx >> 0x0) & 0xffffffff))) + ((((st64) ((st32) ((st64) ((st32) ((Rss >> 0x0) & 0xffffffff))))) * sextract64(((ut64) ((st16) ((Rtt >> 0x10) & ((st64) 0xffff)))), 0x0, 0x10) << 0x0) + ((st64) 0x8000) >> 0x10))) {{}} else {set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, ((ut32) 0x1))}, ((((st64) ((st32) ((Rxx >> 0x0) & 0xffffffff))) + ((((st64) ((st32) ((st64) ((st32) ((Rss >> 0x0) & 0xffffffff))))) * sextract64(((ut64) ((st16) ((Rtt >> 0x10) & ((st64) 0xffff)))), 0x0, 0x10) << 0x0) + ((st64) 0x8000) >> 0x10) < ((st64) 0x0)) ? (-(0x1 << 0x1f)) : (0x1 << 0x1f) - ((st64) 0x1)));
	RzILOpPure *op_RSHIFT_240 = SHIFTRA(READ_REG(pkt, Rxx_op, false), SN(32, 0));
	RzILOpPure *op_AND_242 = LOGAND(op_RSHIFT_240, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_248 = SHIFTRA(DUP(Rss), SN(32, 0));
	RzILOpPure *op_AND_250 = LOGAND(op_RSHIFT_248, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_261 = SHIFTRA(DUP(Rtt), SN(32, 16));
	RzILOpPure *op_AND_264 = LOGAND(op_RSHIFT_261, CAST(64, MSB(SN(32, 0xffff)), SN(32, 0xffff)));
	RzILOpPure *op_MUL_271 = MUL(CAST(64, MSB(CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(op_AND_250), DUP(op_AND_250))), CAST(32, MSB(DUP(op_AND_250)), DUP(op_AND_250)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_250)), DUP(op_AND_250))), CAST(32, MSB(DUP(op_AND_250)), DUP(op_AND_250))))), CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(DUP(op_AND_250)), DUP(op_AND_250))), CAST(32, MSB(DUP(op_AND_250)), DUP(op_AND_250)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_250)), DUP(op_AND_250))), CAST(32, MSB(DUP(op_AND_250)), DUP(op_AND_250))))), SEXTRACT64(CAST(64, IL_FALSE, CAST(16, MSB(op_AND_264), DUP(op_AND_264))), SN(32, 0), SN(32, 16)));
	RzILOpPure *op_LSHIFT_273 = SHIFTL0(op_MUL_271, SN(32, 0));
	RzILOpPure *op_ADD_276 = ADD(op_LSHIFT_273, CAST(64, MSB(SN(32, 0x8000)), SN(32, 0x8000)));
	RzILOpPure *op_RSHIFT_278 = SHIFTRA(op_ADD_276, SN(32, 16));
	RzILOpPure *op_ADD_279 = ADD(CAST(64, MSB(CAST(32, MSB(op_AND_242), DUP(op_AND_242))), CAST(32, MSB(DUP(op_AND_242)), DUP(op_AND_242))), op_RSHIFT_278);
	RzILOpPure *op_RSHIFT_288 = SHIFTRA(READ_REG(pkt, Rxx_op, false), SN(32, 0));
	RzILOpPure *op_AND_290 = LOGAND(op_RSHIFT_288, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_296 = SHIFTRA(DUP(Rss), SN(32, 0));
	RzILOpPure *op_AND_298 = LOGAND(op_RSHIFT_296, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_309 = SHIFTRA(DUP(Rtt), SN(32, 16));
	RzILOpPure *op_AND_312 = LOGAND(op_RSHIFT_309, CAST(64, MSB(SN(32, 0xffff)), SN(32, 0xffff)));
	RzILOpPure *op_MUL_319 = MUL(CAST(64, MSB(CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(op_AND_298), DUP(op_AND_298))), CAST(32, MSB(DUP(op_AND_298)), DUP(op_AND_298)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_298)), DUP(op_AND_298))), CAST(32, MSB(DUP(op_AND_298)), DUP(op_AND_298))))), CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(DUP(op_AND_298)), DUP(op_AND_298))), CAST(32, MSB(DUP(op_AND_298)), DUP(op_AND_298)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_298)), DUP(op_AND_298))), CAST(32, MSB(DUP(op_AND_298)), DUP(op_AND_298))))), SEXTRACT64(CAST(64, IL_FALSE, CAST(16, MSB(op_AND_312), DUP(op_AND_312))), SN(32, 0), SN(32, 16)));
	RzILOpPure *op_LSHIFT_321 = SHIFTL0(op_MUL_319, SN(32, 0));
	RzILOpPure *op_ADD_324 = ADD(op_LSHIFT_321, CAST(64, MSB(SN(32, 0x8000)), SN(32, 0x8000)));
	RzILOpPure *op_RSHIFT_326 = SHIFTRA(op_ADD_324, SN(32, 16));
	RzILOpPure *op_ADD_327 = ADD(CAST(64, MSB(CAST(32, MSB(op_AND_290), DUP(op_AND_290))), CAST(32, MSB(DUP(op_AND_290)), DUP(op_AND_290))), op_RSHIFT_326);
	RzILOpPure *op_EQ_328 = EQ(SEXTRACT64(CAST(64, IL_FALSE, op_ADD_279), SN(32, 0), SN(32, 0x20)), op_ADD_327);
	RzILOpPure *op_RSHIFT_378 = SHIFTRA(READ_REG(pkt, Rxx_op, false), SN(32, 0));
	RzILOpPure *op_AND_380 = LOGAND(op_RSHIFT_378, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_386 = SHIFTRA(DUP(Rss), SN(32, 0));
	RzILOpPure *op_AND_388 = LOGAND(op_RSHIFT_386, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_399 = SHIFTRA(DUP(Rtt), SN(32, 16));
	RzILOpPure *op_AND_402 = LOGAND(op_RSHIFT_399, CAST(64, MSB(SN(32, 0xffff)), SN(32, 0xffff)));
	RzILOpPure *op_MUL_409 = MUL(CAST(64, MSB(CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(op_AND_388), DUP(op_AND_388))), CAST(32, MSB(DUP(op_AND_388)), DUP(op_AND_388)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_388)), DUP(op_AND_388))), CAST(32, MSB(DUP(op_AND_388)), DUP(op_AND_388))))), CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(DUP(op_AND_388)), DUP(op_AND_388))), CAST(32, MSB(DUP(op_AND_388)), DUP(op_AND_388)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_388)), DUP(op_AND_388))), CAST(32, MSB(DUP(op_AND_388)), DUP(op_AND_388))))), SEXTRACT64(CAST(64, IL_FALSE, CAST(16, MSB(op_AND_402), DUP(op_AND_402))), SN(32, 0), SN(32, 16)));
	RzILOpPure *op_LSHIFT_411 = SHIFTL0(op_MUL_409, SN(32, 0));
	RzILOpPure *op_ADD_414 = ADD(op_LSHIFT_411, CAST(64, MSB(SN(32, 0x8000)), SN(32, 0x8000)));
	RzILOpPure *op_RSHIFT_416 = SHIFTRA(op_ADD_414, SN(32, 16));
	RzILOpPure *op_ADD_417 = ADD(CAST(64, MSB(CAST(32, MSB(op_AND_380), DUP(op_AND_380))), CAST(32, MSB(DUP(op_AND_380)), DUP(op_AND_380))), op_RSHIFT_416);
	RzILOpPure *op_LT_420 = SLT(op_ADD_417, CAST(64, MSB(SN(32, 0)), SN(32, 0)));
	RzILOpPure *op_LSHIFT_425 = SHIFTL0(SN(64, 1), SN(32, 31));
	RzILOpPure *op_NEG_426 = NEG(op_LSHIFT_425);
	RzILOpPure *op_LSHIFT_431 = SHIFTL0(SN(64, 1), SN(32, 31));
	RzILOpPure *op_SUB_434 = SUB(op_LSHIFT_431, CAST(64, MSB(SN(32, 1)), SN(32, 1)));
	RzILOpPure *cond_435 = ITE(op_LT_420, op_NEG_426, op_SUB_434);
	RzILOpEffect *gcc_expr_436 = BRANCH(op_EQ_328, EMPTY(), set_usr_field_call_374);

	// h_tmp269 = HYB(gcc_expr_if ((sextract64(((ut64) ((st64) ((st32) ((Rxx >> 0x0) & 0xffffffff))) + ((((st64) ((st32) ((st64) ((st32) ((Rss >> 0x0) & 0xffffffff))))) * sextract64(((ut64) ((st16) ((Rtt >> 0x10) & ((st64) 0xffff)))), 0x0, 0x10) << 0x0) + ((st64) 0x8000) >> 0x10)), 0x0, 0x20) == ((st64) ((st32) ((Rxx >> 0x0) & 0xffffffff))) + ((((st64) ((st32) ((st64) ((st32) ((Rss >> 0x0) & 0xffffffff))))) * sextract64(((ut64) ((st16) ((Rtt >> 0x10) & ((st64) 0xffff)))), 0x0, 0x10) << 0x0) + ((st64) 0x8000) >> 0x10))) {{}} else {set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, ((ut32) 0x1))}, ((((st64) ((st32) ((Rxx >> 0x0) & 0xffffffff))) + ((((st64) ((st32) ((st64) ((st32) ((Rss >> 0x0) & 0xffffffff))))) * sextract64(((ut64) ((st16) ((Rtt >> 0x10) & ((st64) 0xffff)))), 0x0, 0x10) << 0x0) + ((st64) 0x8000) >> 0x10) < ((st64) 0x0)) ? (-(0x1 << 0x1f)) : (0x1 << 0x1f) - ((st64) 0x1)));
	RzILOpEffect *op_ASSIGN_hybrid_tmp_438 = SETL("h_tmp269", cond_435);

	// seq(HYB(gcc_expr_if ((sextract64(((ut64) ((st64) ((st32) ((Rxx > ...;
	RzILOpEffect *seq_439 = SEQN(2, gcc_expr_436, op_ASSIGN_hybrid_tmp_438);

	// Rxx = ((Rxx & (~(0xffffffff << 0x0))) | ((((sextract64(((ut64) ((st64) ((st32) ((Rxx >> 0x0) & 0xffffffff))) + ((((st64) ((st32) ((st64) ((st32) ((Rss >> 0x0) & 0xffffffff))))) * sextract64(((ut64) ((st16) ((Rtt >> 0x10) & ((st64) 0xffff)))), 0x0, 0x10) << 0x0) + ((st64) 0x8000) >> 0x10)), 0x0, 0x20) == ((st64) ((st32) ((Rxx >> 0x0) & 0xffffffff))) + ((((st64) ((st32) ((st64) ((st32) ((Rss >> 0x0) & 0xffffffff))))) * sextract64(((ut64) ((st16) ((Rtt >> 0x10) & ((st64) 0xffff)))), 0x0, 0x10) << 0x0) + ((st64) 0x8000) >> 0x10)) ? ((st64) ((st32) ((Rxx >> 0x0) & 0xffffffff))) + ((((st64) ((st32) ((st64) ((st32) ((Rss >> 0x0) & 0xffffffff))))) * sextract64(((ut64) ((st16) ((Rtt >> 0x10) & ((st64) 0xffff)))), 0x0, 0x10) << 0x0) + ((st64) 0x8000) >> 0x10) : h_tmp269) & 0xffffffff) << 0x0));
	RzILOpPure *op_LSHIFT_231 = SHIFTL0(SN(64, 0xffffffff), SN(32, 0));
	RzILOpPure *op_NOT_232 = LOGNOT(op_LSHIFT_231);
	RzILOpPure *op_AND_233 = LOGAND(READ_REG(pkt, Rxx_op, false), op_NOT_232);
	RzILOpPure *op_RSHIFT_332 = SHIFTRA(READ_REG(pkt, Rxx_op, false), SN(32, 0));
	RzILOpPure *op_AND_334 = LOGAND(op_RSHIFT_332, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_340 = SHIFTRA(DUP(Rss), SN(32, 0));
	RzILOpPure *op_AND_342 = LOGAND(op_RSHIFT_340, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_353 = SHIFTRA(DUP(Rtt), SN(32, 16));
	RzILOpPure *op_AND_356 = LOGAND(op_RSHIFT_353, CAST(64, MSB(SN(32, 0xffff)), SN(32, 0xffff)));
	RzILOpPure *op_MUL_363 = MUL(CAST(64, MSB(CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(op_AND_342), DUP(op_AND_342))), CAST(32, MSB(DUP(op_AND_342)), DUP(op_AND_342)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_342)), DUP(op_AND_342))), CAST(32, MSB(DUP(op_AND_342)), DUP(op_AND_342))))), CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(DUP(op_AND_342)), DUP(op_AND_342))), CAST(32, MSB(DUP(op_AND_342)), DUP(op_AND_342)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_342)), DUP(op_AND_342))), CAST(32, MSB(DUP(op_AND_342)), DUP(op_AND_342))))), SEXTRACT64(CAST(64, IL_FALSE, CAST(16, MSB(op_AND_356), DUP(op_AND_356))), SN(32, 0), SN(32, 16)));
	RzILOpPure *op_LSHIFT_365 = SHIFTL0(op_MUL_363, SN(32, 0));
	RzILOpPure *op_ADD_368 = ADD(op_LSHIFT_365, CAST(64, MSB(SN(32, 0x8000)), SN(32, 0x8000)));
	RzILOpPure *op_RSHIFT_370 = SHIFTRA(op_ADD_368, SN(32, 16));
	RzILOpPure *op_ADD_371 = ADD(CAST(64, MSB(CAST(32, MSB(op_AND_334), DUP(op_AND_334))), CAST(32, MSB(DUP(op_AND_334)), DUP(op_AND_334))), op_RSHIFT_370);
	RzILOpPure *cond_440 = ITE(DUP(op_EQ_328), op_ADD_371, VARL("h_tmp269"));
	RzILOpPure *op_AND_442 = LOGAND(cond_440, SN(64, 0xffffffff));
	RzILOpPure *op_LSHIFT_446 = SHIFTL0(op_AND_442, SN(32, 0));
	RzILOpPure *op_OR_447 = LOGOR(op_AND_233, op_LSHIFT_446);
	RzILOpEffect *op_ASSIGN_448 = WRITE_REG(bundle, Rxx_op, op_OR_447);

	// seq(seq(HYB(gcc_expr_if ((sextract64(((ut64) ((st64) ((st32) ((R ...;
	RzILOpEffect *seq_449 = SEQN(2, seq_439, op_ASSIGN_448);

	RzILOpEffect *instruction_sequence = SEQN(2, seq_225, seq_449);
	return instruction_sequence;
}

// Rxx += vmpywoh(Rss,Rtt):<<1:rnd:sat
RzILOpEffect *hex_il_op_m2_mmachs_rs1(HexInsnPktBundle *bundle) {
	const HexInsn *hi = bundle->insn;
	HexPkt *pkt = bundle->pkt;
	// READ
	const HexOp *Rxx_op = ISA2REG(hi, 'x', false);

	const HexOp *Rss_op = ISA2REG(hi, 's', false);
	RzILOpPure *Rss = READ_REG(pkt, Rss_op, false);
	const HexOp *Rtt_op = ISA2REG(hi, 't', false);
	RzILOpPure *Rtt = READ_REG(pkt, Rtt_op, false);

	// set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, ((ut32) 0x1));
	RzILOpEffect *set_usr_field_call_150 = hex_set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, CAST(32, IL_FALSE, SN(32, 1)));

	// HYB(gcc_expr_if ((sextract64(((ut64) ((st64) ((st32) ((Rxx >> 0x20) & 0xffffffff))) + ((((st64) ((st32) ((st64) ((st32) ((Rss >> 0x20) & 0xffffffff))))) * sextract64(((ut64) ((st16) ((Rtt >> 0x30) & ((st64) 0xffff)))), 0x0, 0x10) << 0x1) + ((st64) 0x8000) >> 0x10)), 0x0, 0x20) == ((st64) ((st32) ((Rxx >> 0x20) & 0xffffffff))) + ((((st64) ((st32) ((st64) ((st32) ((Rss >> 0x20) & 0xffffffff))))) * sextract64(((ut64) ((st16) ((Rtt >> 0x30) & ((st64) 0xffff)))), 0x0, 0x10) << 0x1) + ((st64) 0x8000) >> 0x10))) {{}} else {set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, ((ut32) 0x1))}, ((((st64) ((st32) ((Rxx >> 0x20) & 0xffffffff))) + ((((st64) ((st32) ((st64) ((st32) ((Rss >> 0x20) & 0xffffffff))))) * sextract64(((ut64) ((st16) ((Rtt >> 0x30) & ((st64) 0xffff)))), 0x0, 0x10) << 0x1) + ((st64) 0x8000) >> 0x10) < ((st64) 0x0)) ? (-(0x1 << 0x1f)) : (0x1 << 0x1f) - ((st64) 0x1)));
	RzILOpPure *op_RSHIFT_14 = SHIFTRA(READ_REG(pkt, Rxx_op, false), SN(32, 0x20));
	RzILOpPure *op_AND_16 = LOGAND(op_RSHIFT_14, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_23 = SHIFTRA(Rss, SN(32, 0x20));
	RzILOpPure *op_AND_25 = LOGAND(op_RSHIFT_23, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_37 = SHIFTRA(Rtt, SN(32, 0x30));
	RzILOpPure *op_AND_40 = LOGAND(op_RSHIFT_37, CAST(64, MSB(SN(32, 0xffff)), SN(32, 0xffff)));
	RzILOpPure *op_MUL_47 = MUL(CAST(64, MSB(CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(op_AND_25), DUP(op_AND_25))), CAST(32, MSB(DUP(op_AND_25)), DUP(op_AND_25)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_25)), DUP(op_AND_25))), CAST(32, MSB(DUP(op_AND_25)), DUP(op_AND_25))))), CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(DUP(op_AND_25)), DUP(op_AND_25))), CAST(32, MSB(DUP(op_AND_25)), DUP(op_AND_25)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_25)), DUP(op_AND_25))), CAST(32, MSB(DUP(op_AND_25)), DUP(op_AND_25))))), SEXTRACT64(CAST(64, IL_FALSE, CAST(16, MSB(op_AND_40), DUP(op_AND_40))), SN(32, 0), SN(32, 16)));
	RzILOpPure *op_LSHIFT_49 = SHIFTL0(op_MUL_47, SN(32, 1));
	RzILOpPure *op_ADD_52 = ADD(op_LSHIFT_49, CAST(64, MSB(SN(32, 0x8000)), SN(32, 0x8000)));
	RzILOpPure *op_RSHIFT_54 = SHIFTRA(op_ADD_52, SN(32, 16));
	RzILOpPure *op_ADD_55 = ADD(CAST(64, MSB(CAST(32, MSB(op_AND_16), DUP(op_AND_16))), CAST(32, MSB(DUP(op_AND_16)), DUP(op_AND_16))), op_RSHIFT_54);
	RzILOpPure *op_RSHIFT_64 = SHIFTRA(READ_REG(pkt, Rxx_op, false), SN(32, 0x20));
	RzILOpPure *op_AND_66 = LOGAND(op_RSHIFT_64, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_72 = SHIFTRA(DUP(Rss), SN(32, 0x20));
	RzILOpPure *op_AND_74 = LOGAND(op_RSHIFT_72, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_85 = SHIFTRA(DUP(Rtt), SN(32, 0x30));
	RzILOpPure *op_AND_88 = LOGAND(op_RSHIFT_85, CAST(64, MSB(SN(32, 0xffff)), SN(32, 0xffff)));
	RzILOpPure *op_MUL_95 = MUL(CAST(64, MSB(CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(op_AND_74), DUP(op_AND_74))), CAST(32, MSB(DUP(op_AND_74)), DUP(op_AND_74)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_74)), DUP(op_AND_74))), CAST(32, MSB(DUP(op_AND_74)), DUP(op_AND_74))))), CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(DUP(op_AND_74)), DUP(op_AND_74))), CAST(32, MSB(DUP(op_AND_74)), DUP(op_AND_74)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_74)), DUP(op_AND_74))), CAST(32, MSB(DUP(op_AND_74)), DUP(op_AND_74))))), SEXTRACT64(CAST(64, IL_FALSE, CAST(16, MSB(op_AND_88), DUP(op_AND_88))), SN(32, 0), SN(32, 16)));
	RzILOpPure *op_LSHIFT_97 = SHIFTL0(op_MUL_95, SN(32, 1));
	RzILOpPure *op_ADD_100 = ADD(op_LSHIFT_97, CAST(64, MSB(SN(32, 0x8000)), SN(32, 0x8000)));
	RzILOpPure *op_RSHIFT_102 = SHIFTRA(op_ADD_100, SN(32, 16));
	RzILOpPure *op_ADD_103 = ADD(CAST(64, MSB(CAST(32, MSB(op_AND_66), DUP(op_AND_66))), CAST(32, MSB(DUP(op_AND_66)), DUP(op_AND_66))), op_RSHIFT_102);
	RzILOpPure *op_EQ_104 = EQ(SEXTRACT64(CAST(64, IL_FALSE, op_ADD_55), SN(32, 0), SN(32, 0x20)), op_ADD_103);
	RzILOpPure *op_RSHIFT_154 = SHIFTRA(READ_REG(pkt, Rxx_op, false), SN(32, 0x20));
	RzILOpPure *op_AND_156 = LOGAND(op_RSHIFT_154, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_162 = SHIFTRA(DUP(Rss), SN(32, 0x20));
	RzILOpPure *op_AND_164 = LOGAND(op_RSHIFT_162, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_175 = SHIFTRA(DUP(Rtt), SN(32, 0x30));
	RzILOpPure *op_AND_178 = LOGAND(op_RSHIFT_175, CAST(64, MSB(SN(32, 0xffff)), SN(32, 0xffff)));
	RzILOpPure *op_MUL_185 = MUL(CAST(64, MSB(CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(op_AND_164), DUP(op_AND_164))), CAST(32, MSB(DUP(op_AND_164)), DUP(op_AND_164)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_164)), DUP(op_AND_164))), CAST(32, MSB(DUP(op_AND_164)), DUP(op_AND_164))))), CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(DUP(op_AND_164)), DUP(op_AND_164))), CAST(32, MSB(DUP(op_AND_164)), DUP(op_AND_164)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_164)), DUP(op_AND_164))), CAST(32, MSB(DUP(op_AND_164)), DUP(op_AND_164))))), SEXTRACT64(CAST(64, IL_FALSE, CAST(16, MSB(op_AND_178), DUP(op_AND_178))), SN(32, 0), SN(32, 16)));
	RzILOpPure *op_LSHIFT_187 = SHIFTL0(op_MUL_185, SN(32, 1));
	RzILOpPure *op_ADD_190 = ADD(op_LSHIFT_187, CAST(64, MSB(SN(32, 0x8000)), SN(32, 0x8000)));
	RzILOpPure *op_RSHIFT_192 = SHIFTRA(op_ADD_190, SN(32, 16));
	RzILOpPure *op_ADD_193 = ADD(CAST(64, MSB(CAST(32, MSB(op_AND_156), DUP(op_AND_156))), CAST(32, MSB(DUP(op_AND_156)), DUP(op_AND_156))), op_RSHIFT_192);
	RzILOpPure *op_LT_196 = SLT(op_ADD_193, CAST(64, MSB(SN(32, 0)), SN(32, 0)));
	RzILOpPure *op_LSHIFT_201 = SHIFTL0(SN(64, 1), SN(32, 31));
	RzILOpPure *op_NEG_202 = NEG(op_LSHIFT_201);
	RzILOpPure *op_LSHIFT_207 = SHIFTL0(SN(64, 1), SN(32, 31));
	RzILOpPure *op_SUB_210 = SUB(op_LSHIFT_207, CAST(64, MSB(SN(32, 1)), SN(32, 1)));
	RzILOpPure *cond_211 = ITE(op_LT_196, op_NEG_202, op_SUB_210);
	RzILOpEffect *gcc_expr_212 = BRANCH(op_EQ_104, EMPTY(), set_usr_field_call_150);

	// h_tmp270 = HYB(gcc_expr_if ((sextract64(((ut64) ((st64) ((st32) ((Rxx >> 0x20) & 0xffffffff))) + ((((st64) ((st32) ((st64) ((st32) ((Rss >> 0x20) & 0xffffffff))))) * sextract64(((ut64) ((st16) ((Rtt >> 0x30) & ((st64) 0xffff)))), 0x0, 0x10) << 0x1) + ((st64) 0x8000) >> 0x10)), 0x0, 0x20) == ((st64) ((st32) ((Rxx >> 0x20) & 0xffffffff))) + ((((st64) ((st32) ((st64) ((st32) ((Rss >> 0x20) & 0xffffffff))))) * sextract64(((ut64) ((st16) ((Rtt >> 0x30) & ((st64) 0xffff)))), 0x0, 0x10) << 0x1) + ((st64) 0x8000) >> 0x10))) {{}} else {set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, ((ut32) 0x1))}, ((((st64) ((st32) ((Rxx >> 0x20) & 0xffffffff))) + ((((st64) ((st32) ((st64) ((st32) ((Rss >> 0x20) & 0xffffffff))))) * sextract64(((ut64) ((st16) ((Rtt >> 0x30) & ((st64) 0xffff)))), 0x0, 0x10) << 0x1) + ((st64) 0x8000) >> 0x10) < ((st64) 0x0)) ? (-(0x1 << 0x1f)) : (0x1 << 0x1f) - ((st64) 0x1)));
	RzILOpEffect *op_ASSIGN_hybrid_tmp_214 = SETL("h_tmp270", cond_211);

	// seq(HYB(gcc_expr_if ((sextract64(((ut64) ((st64) ((st32) ((Rxx > ...;
	RzILOpEffect *seq_215 = SEQN(2, gcc_expr_212, op_ASSIGN_hybrid_tmp_214);

	// Rxx = ((Rxx & (~(0xffffffff << 0x20))) | ((((sextract64(((ut64) ((st64) ((st32) ((Rxx >> 0x20) & 0xffffffff))) + ((((st64) ((st32) ((st64) ((st32) ((Rss >> 0x20) & 0xffffffff))))) * sextract64(((ut64) ((st16) ((Rtt >> 0x30) & ((st64) 0xffff)))), 0x0, 0x10) << 0x1) + ((st64) 0x8000) >> 0x10)), 0x0, 0x20) == ((st64) ((st32) ((Rxx >> 0x20) & 0xffffffff))) + ((((st64) ((st32) ((st64) ((st32) ((Rss >> 0x20) & 0xffffffff))))) * sextract64(((ut64) ((st16) ((Rtt >> 0x30) & ((st64) 0xffff)))), 0x0, 0x10) << 0x1) + ((st64) 0x8000) >> 0x10)) ? ((st64) ((st32) ((Rxx >> 0x20) & 0xffffffff))) + ((((st64) ((st32) ((st64) ((st32) ((Rss >> 0x20) & 0xffffffff))))) * sextract64(((ut64) ((st16) ((Rtt >> 0x30) & ((st64) 0xffff)))), 0x0, 0x10) << 0x1) + ((st64) 0x8000) >> 0x10) : h_tmp270) & 0xffffffff) << 0x20));
	RzILOpPure *op_LSHIFT_5 = SHIFTL0(SN(64, 0xffffffff), SN(32, 0x20));
	RzILOpPure *op_NOT_6 = LOGNOT(op_LSHIFT_5);
	RzILOpPure *op_AND_7 = LOGAND(READ_REG(pkt, Rxx_op, false), op_NOT_6);
	RzILOpPure *op_RSHIFT_108 = SHIFTRA(READ_REG(pkt, Rxx_op, false), SN(32, 0x20));
	RzILOpPure *op_AND_110 = LOGAND(op_RSHIFT_108, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_116 = SHIFTRA(DUP(Rss), SN(32, 0x20));
	RzILOpPure *op_AND_118 = LOGAND(op_RSHIFT_116, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_129 = SHIFTRA(DUP(Rtt), SN(32, 0x30));
	RzILOpPure *op_AND_132 = LOGAND(op_RSHIFT_129, CAST(64, MSB(SN(32, 0xffff)), SN(32, 0xffff)));
	RzILOpPure *op_MUL_139 = MUL(CAST(64, MSB(CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(op_AND_118), DUP(op_AND_118))), CAST(32, MSB(DUP(op_AND_118)), DUP(op_AND_118)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_118)), DUP(op_AND_118))), CAST(32, MSB(DUP(op_AND_118)), DUP(op_AND_118))))), CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(DUP(op_AND_118)), DUP(op_AND_118))), CAST(32, MSB(DUP(op_AND_118)), DUP(op_AND_118)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_118)), DUP(op_AND_118))), CAST(32, MSB(DUP(op_AND_118)), DUP(op_AND_118))))), SEXTRACT64(CAST(64, IL_FALSE, CAST(16, MSB(op_AND_132), DUP(op_AND_132))), SN(32, 0), SN(32, 16)));
	RzILOpPure *op_LSHIFT_141 = SHIFTL0(op_MUL_139, SN(32, 1));
	RzILOpPure *op_ADD_144 = ADD(op_LSHIFT_141, CAST(64, MSB(SN(32, 0x8000)), SN(32, 0x8000)));
	RzILOpPure *op_RSHIFT_146 = SHIFTRA(op_ADD_144, SN(32, 16));
	RzILOpPure *op_ADD_147 = ADD(CAST(64, MSB(CAST(32, MSB(op_AND_110), DUP(op_AND_110))), CAST(32, MSB(DUP(op_AND_110)), DUP(op_AND_110))), op_RSHIFT_146);
	RzILOpPure *cond_216 = ITE(DUP(op_EQ_104), op_ADD_147, VARL("h_tmp270"));
	RzILOpPure *op_AND_218 = LOGAND(cond_216, SN(64, 0xffffffff));
	RzILOpPure *op_LSHIFT_222 = SHIFTL0(op_AND_218, SN(32, 0x20));
	RzILOpPure *op_OR_223 = LOGOR(op_AND_7, op_LSHIFT_222);
	RzILOpEffect *op_ASSIGN_224 = WRITE_REG(bundle, Rxx_op, op_OR_223);

	// seq(seq(HYB(gcc_expr_if ((sextract64(((ut64) ((st64) ((st32) ((R ...;
	RzILOpEffect *seq_225 = SEQN(2, seq_215, op_ASSIGN_224);

	// set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, ((ut32) 0x1));
	RzILOpEffect *set_usr_field_call_374 = hex_set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, CAST(32, IL_FALSE, SN(32, 1)));

	// HYB(gcc_expr_if ((sextract64(((ut64) ((st64) ((st32) ((Rxx >> 0x0) & 0xffffffff))) + ((((st64) ((st32) ((st64) ((st32) ((Rss >> 0x0) & 0xffffffff))))) * sextract64(((ut64) ((st16) ((Rtt >> 0x10) & ((st64) 0xffff)))), 0x0, 0x10) << 0x1) + ((st64) 0x8000) >> 0x10)), 0x0, 0x20) == ((st64) ((st32) ((Rxx >> 0x0) & 0xffffffff))) + ((((st64) ((st32) ((st64) ((st32) ((Rss >> 0x0) & 0xffffffff))))) * sextract64(((ut64) ((st16) ((Rtt >> 0x10) & ((st64) 0xffff)))), 0x0, 0x10) << 0x1) + ((st64) 0x8000) >> 0x10))) {{}} else {set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, ((ut32) 0x1))}, ((((st64) ((st32) ((Rxx >> 0x0) & 0xffffffff))) + ((((st64) ((st32) ((st64) ((st32) ((Rss >> 0x0) & 0xffffffff))))) * sextract64(((ut64) ((st16) ((Rtt >> 0x10) & ((st64) 0xffff)))), 0x0, 0x10) << 0x1) + ((st64) 0x8000) >> 0x10) < ((st64) 0x0)) ? (-(0x1 << 0x1f)) : (0x1 << 0x1f) - ((st64) 0x1)));
	RzILOpPure *op_RSHIFT_240 = SHIFTRA(READ_REG(pkt, Rxx_op, false), SN(32, 0));
	RzILOpPure *op_AND_242 = LOGAND(op_RSHIFT_240, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_248 = SHIFTRA(DUP(Rss), SN(32, 0));
	RzILOpPure *op_AND_250 = LOGAND(op_RSHIFT_248, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_261 = SHIFTRA(DUP(Rtt), SN(32, 16));
	RzILOpPure *op_AND_264 = LOGAND(op_RSHIFT_261, CAST(64, MSB(SN(32, 0xffff)), SN(32, 0xffff)));
	RzILOpPure *op_MUL_271 = MUL(CAST(64, MSB(CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(op_AND_250), DUP(op_AND_250))), CAST(32, MSB(DUP(op_AND_250)), DUP(op_AND_250)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_250)), DUP(op_AND_250))), CAST(32, MSB(DUP(op_AND_250)), DUP(op_AND_250))))), CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(DUP(op_AND_250)), DUP(op_AND_250))), CAST(32, MSB(DUP(op_AND_250)), DUP(op_AND_250)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_250)), DUP(op_AND_250))), CAST(32, MSB(DUP(op_AND_250)), DUP(op_AND_250))))), SEXTRACT64(CAST(64, IL_FALSE, CAST(16, MSB(op_AND_264), DUP(op_AND_264))), SN(32, 0), SN(32, 16)));
	RzILOpPure *op_LSHIFT_273 = SHIFTL0(op_MUL_271, SN(32, 1));
	RzILOpPure *op_ADD_276 = ADD(op_LSHIFT_273, CAST(64, MSB(SN(32, 0x8000)), SN(32, 0x8000)));
	RzILOpPure *op_RSHIFT_278 = SHIFTRA(op_ADD_276, SN(32, 16));
	RzILOpPure *op_ADD_279 = ADD(CAST(64, MSB(CAST(32, MSB(op_AND_242), DUP(op_AND_242))), CAST(32, MSB(DUP(op_AND_242)), DUP(op_AND_242))), op_RSHIFT_278);
	RzILOpPure *op_RSHIFT_288 = SHIFTRA(READ_REG(pkt, Rxx_op, false), SN(32, 0));
	RzILOpPure *op_AND_290 = LOGAND(op_RSHIFT_288, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_296 = SHIFTRA(DUP(Rss), SN(32, 0));
	RzILOpPure *op_AND_298 = LOGAND(op_RSHIFT_296, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_309 = SHIFTRA(DUP(Rtt), SN(32, 16));
	RzILOpPure *op_AND_312 = LOGAND(op_RSHIFT_309, CAST(64, MSB(SN(32, 0xffff)), SN(32, 0xffff)));
	RzILOpPure *op_MUL_319 = MUL(CAST(64, MSB(CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(op_AND_298), DUP(op_AND_298))), CAST(32, MSB(DUP(op_AND_298)), DUP(op_AND_298)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_298)), DUP(op_AND_298))), CAST(32, MSB(DUP(op_AND_298)), DUP(op_AND_298))))), CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(DUP(op_AND_298)), DUP(op_AND_298))), CAST(32, MSB(DUP(op_AND_298)), DUP(op_AND_298)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_298)), DUP(op_AND_298))), CAST(32, MSB(DUP(op_AND_298)), DUP(op_AND_298))))), SEXTRACT64(CAST(64, IL_FALSE, CAST(16, MSB(op_AND_312), DUP(op_AND_312))), SN(32, 0), SN(32, 16)));
	RzILOpPure *op_LSHIFT_321 = SHIFTL0(op_MUL_319, SN(32, 1));
	RzILOpPure *op_ADD_324 = ADD(op_LSHIFT_321, CAST(64, MSB(SN(32, 0x8000)), SN(32, 0x8000)));
	RzILOpPure *op_RSHIFT_326 = SHIFTRA(op_ADD_324, SN(32, 16));
	RzILOpPure *op_ADD_327 = ADD(CAST(64, MSB(CAST(32, MSB(op_AND_290), DUP(op_AND_290))), CAST(32, MSB(DUP(op_AND_290)), DUP(op_AND_290))), op_RSHIFT_326);
	RzILOpPure *op_EQ_328 = EQ(SEXTRACT64(CAST(64, IL_FALSE, op_ADD_279), SN(32, 0), SN(32, 0x20)), op_ADD_327);
	RzILOpPure *op_RSHIFT_378 = SHIFTRA(READ_REG(pkt, Rxx_op, false), SN(32, 0));
	RzILOpPure *op_AND_380 = LOGAND(op_RSHIFT_378, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_386 = SHIFTRA(DUP(Rss), SN(32, 0));
	RzILOpPure *op_AND_388 = LOGAND(op_RSHIFT_386, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_399 = SHIFTRA(DUP(Rtt), SN(32, 16));
	RzILOpPure *op_AND_402 = LOGAND(op_RSHIFT_399, CAST(64, MSB(SN(32, 0xffff)), SN(32, 0xffff)));
	RzILOpPure *op_MUL_409 = MUL(CAST(64, MSB(CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(op_AND_388), DUP(op_AND_388))), CAST(32, MSB(DUP(op_AND_388)), DUP(op_AND_388)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_388)), DUP(op_AND_388))), CAST(32, MSB(DUP(op_AND_388)), DUP(op_AND_388))))), CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(DUP(op_AND_388)), DUP(op_AND_388))), CAST(32, MSB(DUP(op_AND_388)), DUP(op_AND_388)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_388)), DUP(op_AND_388))), CAST(32, MSB(DUP(op_AND_388)), DUP(op_AND_388))))), SEXTRACT64(CAST(64, IL_FALSE, CAST(16, MSB(op_AND_402), DUP(op_AND_402))), SN(32, 0), SN(32, 16)));
	RzILOpPure *op_LSHIFT_411 = SHIFTL0(op_MUL_409, SN(32, 1));
	RzILOpPure *op_ADD_414 = ADD(op_LSHIFT_411, CAST(64, MSB(SN(32, 0x8000)), SN(32, 0x8000)));
	RzILOpPure *op_RSHIFT_416 = SHIFTRA(op_ADD_414, SN(32, 16));
	RzILOpPure *op_ADD_417 = ADD(CAST(64, MSB(CAST(32, MSB(op_AND_380), DUP(op_AND_380))), CAST(32, MSB(DUP(op_AND_380)), DUP(op_AND_380))), op_RSHIFT_416);
	RzILOpPure *op_LT_420 = SLT(op_ADD_417, CAST(64, MSB(SN(32, 0)), SN(32, 0)));
	RzILOpPure *op_LSHIFT_425 = SHIFTL0(SN(64, 1), SN(32, 31));
	RzILOpPure *op_NEG_426 = NEG(op_LSHIFT_425);
	RzILOpPure *op_LSHIFT_431 = SHIFTL0(SN(64, 1), SN(32, 31));
	RzILOpPure *op_SUB_434 = SUB(op_LSHIFT_431, CAST(64, MSB(SN(32, 1)), SN(32, 1)));
	RzILOpPure *cond_435 = ITE(op_LT_420, op_NEG_426, op_SUB_434);
	RzILOpEffect *gcc_expr_436 = BRANCH(op_EQ_328, EMPTY(), set_usr_field_call_374);

	// h_tmp271 = HYB(gcc_expr_if ((sextract64(((ut64) ((st64) ((st32) ((Rxx >> 0x0) & 0xffffffff))) + ((((st64) ((st32) ((st64) ((st32) ((Rss >> 0x0) & 0xffffffff))))) * sextract64(((ut64) ((st16) ((Rtt >> 0x10) & ((st64) 0xffff)))), 0x0, 0x10) << 0x1) + ((st64) 0x8000) >> 0x10)), 0x0, 0x20) == ((st64) ((st32) ((Rxx >> 0x0) & 0xffffffff))) + ((((st64) ((st32) ((st64) ((st32) ((Rss >> 0x0) & 0xffffffff))))) * sextract64(((ut64) ((st16) ((Rtt >> 0x10) & ((st64) 0xffff)))), 0x0, 0x10) << 0x1) + ((st64) 0x8000) >> 0x10))) {{}} else {set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, ((ut32) 0x1))}, ((((st64) ((st32) ((Rxx >> 0x0) & 0xffffffff))) + ((((st64) ((st32) ((st64) ((st32) ((Rss >> 0x0) & 0xffffffff))))) * sextract64(((ut64) ((st16) ((Rtt >> 0x10) & ((st64) 0xffff)))), 0x0, 0x10) << 0x1) + ((st64) 0x8000) >> 0x10) < ((st64) 0x0)) ? (-(0x1 << 0x1f)) : (0x1 << 0x1f) - ((st64) 0x1)));
	RzILOpEffect *op_ASSIGN_hybrid_tmp_438 = SETL("h_tmp271", cond_435);

	// seq(HYB(gcc_expr_if ((sextract64(((ut64) ((st64) ((st32) ((Rxx > ...;
	RzILOpEffect *seq_439 = SEQN(2, gcc_expr_436, op_ASSIGN_hybrid_tmp_438);

	// Rxx = ((Rxx & (~(0xffffffff << 0x0))) | ((((sextract64(((ut64) ((st64) ((st32) ((Rxx >> 0x0) & 0xffffffff))) + ((((st64) ((st32) ((st64) ((st32) ((Rss >> 0x0) & 0xffffffff))))) * sextract64(((ut64) ((st16) ((Rtt >> 0x10) & ((st64) 0xffff)))), 0x0, 0x10) << 0x1) + ((st64) 0x8000) >> 0x10)), 0x0, 0x20) == ((st64) ((st32) ((Rxx >> 0x0) & 0xffffffff))) + ((((st64) ((st32) ((st64) ((st32) ((Rss >> 0x0) & 0xffffffff))))) * sextract64(((ut64) ((st16) ((Rtt >> 0x10) & ((st64) 0xffff)))), 0x0, 0x10) << 0x1) + ((st64) 0x8000) >> 0x10)) ? ((st64) ((st32) ((Rxx >> 0x0) & 0xffffffff))) + ((((st64) ((st32) ((st64) ((st32) ((Rss >> 0x0) & 0xffffffff))))) * sextract64(((ut64) ((st16) ((Rtt >> 0x10) & ((st64) 0xffff)))), 0x0, 0x10) << 0x1) + ((st64) 0x8000) >> 0x10) : h_tmp271) & 0xffffffff) << 0x0));
	RzILOpPure *op_LSHIFT_231 = SHIFTL0(SN(64, 0xffffffff), SN(32, 0));
	RzILOpPure *op_NOT_232 = LOGNOT(op_LSHIFT_231);
	RzILOpPure *op_AND_233 = LOGAND(READ_REG(pkt, Rxx_op, false), op_NOT_232);
	RzILOpPure *op_RSHIFT_332 = SHIFTRA(READ_REG(pkt, Rxx_op, false), SN(32, 0));
	RzILOpPure *op_AND_334 = LOGAND(op_RSHIFT_332, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_340 = SHIFTRA(DUP(Rss), SN(32, 0));
	RzILOpPure *op_AND_342 = LOGAND(op_RSHIFT_340, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_353 = SHIFTRA(DUP(Rtt), SN(32, 16));
	RzILOpPure *op_AND_356 = LOGAND(op_RSHIFT_353, CAST(64, MSB(SN(32, 0xffff)), SN(32, 0xffff)));
	RzILOpPure *op_MUL_363 = MUL(CAST(64, MSB(CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(op_AND_342), DUP(op_AND_342))), CAST(32, MSB(DUP(op_AND_342)), DUP(op_AND_342)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_342)), DUP(op_AND_342))), CAST(32, MSB(DUP(op_AND_342)), DUP(op_AND_342))))), CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(DUP(op_AND_342)), DUP(op_AND_342))), CAST(32, MSB(DUP(op_AND_342)), DUP(op_AND_342)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_342)), DUP(op_AND_342))), CAST(32, MSB(DUP(op_AND_342)), DUP(op_AND_342))))), SEXTRACT64(CAST(64, IL_FALSE, CAST(16, MSB(op_AND_356), DUP(op_AND_356))), SN(32, 0), SN(32, 16)));
	RzILOpPure *op_LSHIFT_365 = SHIFTL0(op_MUL_363, SN(32, 1));
	RzILOpPure *op_ADD_368 = ADD(op_LSHIFT_365, CAST(64, MSB(SN(32, 0x8000)), SN(32, 0x8000)));
	RzILOpPure *op_RSHIFT_370 = SHIFTRA(op_ADD_368, SN(32, 16));
	RzILOpPure *op_ADD_371 = ADD(CAST(64, MSB(CAST(32, MSB(op_AND_334), DUP(op_AND_334))), CAST(32, MSB(DUP(op_AND_334)), DUP(op_AND_334))), op_RSHIFT_370);
	RzILOpPure *cond_440 = ITE(DUP(op_EQ_328), op_ADD_371, VARL("h_tmp271"));
	RzILOpPure *op_AND_442 = LOGAND(cond_440, SN(64, 0xffffffff));
	RzILOpPure *op_LSHIFT_446 = SHIFTL0(op_AND_442, SN(32, 0));
	RzILOpPure *op_OR_447 = LOGOR(op_AND_233, op_LSHIFT_446);
	RzILOpEffect *op_ASSIGN_448 = WRITE_REG(bundle, Rxx_op, op_OR_447);

	// seq(seq(HYB(gcc_expr_if ((sextract64(((ut64) ((st64) ((st32) ((R ...;
	RzILOpEffect *seq_449 = SEQN(2, seq_439, op_ASSIGN_448);

	RzILOpEffect *instruction_sequence = SEQN(2, seq_225, seq_449);
	return instruction_sequence;
}

// Rxx += vmpywoh(Rss,Rtt):sat
RzILOpEffect *hex_il_op_m2_mmachs_s0(HexInsnPktBundle *bundle) {
	const HexInsn *hi = bundle->insn;
	HexPkt *pkt = bundle->pkt;
	// READ
	const HexOp *Rxx_op = ISA2REG(hi, 'x', false);

	const HexOp *Rss_op = ISA2REG(hi, 's', false);
	RzILOpPure *Rss = READ_REG(pkt, Rss_op, false);
	const HexOp *Rtt_op = ISA2REG(hi, 't', false);
	RzILOpPure *Rtt = READ_REG(pkt, Rtt_op, false);

	// set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, ((ut32) 0x1));
	RzILOpEffect *set_usr_field_call_141 = hex_set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, CAST(32, IL_FALSE, SN(32, 1)));

	// HYB(gcc_expr_if ((sextract64(((ut64) ((st64) ((st32) ((Rxx >> 0x20) & 0xffffffff))) + ((((st64) ((st32) ((st64) ((st32) ((Rss >> 0x20) & 0xffffffff))))) * sextract64(((ut64) ((st16) ((Rtt >> 0x30) & ((st64) 0xffff)))), 0x0, 0x10) << 0x0) >> 0x10)), 0x0, 0x20) == ((st64) ((st32) ((Rxx >> 0x20) & 0xffffffff))) + ((((st64) ((st32) ((st64) ((st32) ((Rss >> 0x20) & 0xffffffff))))) * sextract64(((ut64) ((st16) ((Rtt >> 0x30) & ((st64) 0xffff)))), 0x0, 0x10) << 0x0) >> 0x10))) {{}} else {set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, ((ut32) 0x1))}, ((((st64) ((st32) ((Rxx >> 0x20) & 0xffffffff))) + ((((st64) ((st32) ((st64) ((st32) ((Rss >> 0x20) & 0xffffffff))))) * sextract64(((ut64) ((st16) ((Rtt >> 0x30) & ((st64) 0xffff)))), 0x0, 0x10) << 0x0) >> 0x10) < ((st64) 0x0)) ? (-(0x1 << 0x1f)) : (0x1 << 0x1f) - ((st64) 0x1)));
	RzILOpPure *op_RSHIFT_14 = SHIFTRA(READ_REG(pkt, Rxx_op, false), SN(32, 0x20));
	RzILOpPure *op_AND_16 = LOGAND(op_RSHIFT_14, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_23 = SHIFTRA(Rss, SN(32, 0x20));
	RzILOpPure *op_AND_25 = LOGAND(op_RSHIFT_23, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_37 = SHIFTRA(Rtt, SN(32, 0x30));
	RzILOpPure *op_AND_40 = LOGAND(op_RSHIFT_37, CAST(64, MSB(SN(32, 0xffff)), SN(32, 0xffff)));
	RzILOpPure *op_MUL_47 = MUL(CAST(64, MSB(CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(op_AND_25), DUP(op_AND_25))), CAST(32, MSB(DUP(op_AND_25)), DUP(op_AND_25)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_25)), DUP(op_AND_25))), CAST(32, MSB(DUP(op_AND_25)), DUP(op_AND_25))))), CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(DUP(op_AND_25)), DUP(op_AND_25))), CAST(32, MSB(DUP(op_AND_25)), DUP(op_AND_25)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_25)), DUP(op_AND_25))), CAST(32, MSB(DUP(op_AND_25)), DUP(op_AND_25))))), SEXTRACT64(CAST(64, IL_FALSE, CAST(16, MSB(op_AND_40), DUP(op_AND_40))), SN(32, 0), SN(32, 16)));
	RzILOpPure *op_LSHIFT_49 = SHIFTL0(op_MUL_47, SN(32, 0));
	RzILOpPure *op_RSHIFT_51 = SHIFTRA(op_LSHIFT_49, SN(32, 16));
	RzILOpPure *op_ADD_52 = ADD(CAST(64, MSB(CAST(32, MSB(op_AND_16), DUP(op_AND_16))), CAST(32, MSB(DUP(op_AND_16)), DUP(op_AND_16))), op_RSHIFT_51);
	RzILOpPure *op_RSHIFT_61 = SHIFTRA(READ_REG(pkt, Rxx_op, false), SN(32, 0x20));
	RzILOpPure *op_AND_63 = LOGAND(op_RSHIFT_61, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_69 = SHIFTRA(DUP(Rss), SN(32, 0x20));
	RzILOpPure *op_AND_71 = LOGAND(op_RSHIFT_69, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_82 = SHIFTRA(DUP(Rtt), SN(32, 0x30));
	RzILOpPure *op_AND_85 = LOGAND(op_RSHIFT_82, CAST(64, MSB(SN(32, 0xffff)), SN(32, 0xffff)));
	RzILOpPure *op_MUL_92 = MUL(CAST(64, MSB(CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(op_AND_71), DUP(op_AND_71))), CAST(32, MSB(DUP(op_AND_71)), DUP(op_AND_71)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_71)), DUP(op_AND_71))), CAST(32, MSB(DUP(op_AND_71)), DUP(op_AND_71))))), CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(DUP(op_AND_71)), DUP(op_AND_71))), CAST(32, MSB(DUP(op_AND_71)), DUP(op_AND_71)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_71)), DUP(op_AND_71))), CAST(32, MSB(DUP(op_AND_71)), DUP(op_AND_71))))), SEXTRACT64(CAST(64, IL_FALSE, CAST(16, MSB(op_AND_85), DUP(op_AND_85))), SN(32, 0), SN(32, 16)));
	RzILOpPure *op_LSHIFT_94 = SHIFTL0(op_MUL_92, SN(32, 0));
	RzILOpPure *op_RSHIFT_96 = SHIFTRA(op_LSHIFT_94, SN(32, 16));
	RzILOpPure *op_ADD_97 = ADD(CAST(64, MSB(CAST(32, MSB(op_AND_63), DUP(op_AND_63))), CAST(32, MSB(DUP(op_AND_63)), DUP(op_AND_63))), op_RSHIFT_96);
	RzILOpPure *op_EQ_98 = EQ(SEXTRACT64(CAST(64, IL_FALSE, op_ADD_52), SN(32, 0), SN(32, 0x20)), op_ADD_97);
	RzILOpPure *op_RSHIFT_145 = SHIFTRA(READ_REG(pkt, Rxx_op, false), SN(32, 0x20));
	RzILOpPure *op_AND_147 = LOGAND(op_RSHIFT_145, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_153 = SHIFTRA(DUP(Rss), SN(32, 0x20));
	RzILOpPure *op_AND_155 = LOGAND(op_RSHIFT_153, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_166 = SHIFTRA(DUP(Rtt), SN(32, 0x30));
	RzILOpPure *op_AND_169 = LOGAND(op_RSHIFT_166, CAST(64, MSB(SN(32, 0xffff)), SN(32, 0xffff)));
	RzILOpPure *op_MUL_176 = MUL(CAST(64, MSB(CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(op_AND_155), DUP(op_AND_155))), CAST(32, MSB(DUP(op_AND_155)), DUP(op_AND_155)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_155)), DUP(op_AND_155))), CAST(32, MSB(DUP(op_AND_155)), DUP(op_AND_155))))), CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(DUP(op_AND_155)), DUP(op_AND_155))), CAST(32, MSB(DUP(op_AND_155)), DUP(op_AND_155)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_155)), DUP(op_AND_155))), CAST(32, MSB(DUP(op_AND_155)), DUP(op_AND_155))))), SEXTRACT64(CAST(64, IL_FALSE, CAST(16, MSB(op_AND_169), DUP(op_AND_169))), SN(32, 0), SN(32, 16)));
	RzILOpPure *op_LSHIFT_178 = SHIFTL0(op_MUL_176, SN(32, 0));
	RzILOpPure *op_RSHIFT_180 = SHIFTRA(op_LSHIFT_178, SN(32, 16));
	RzILOpPure *op_ADD_181 = ADD(CAST(64, MSB(CAST(32, MSB(op_AND_147), DUP(op_AND_147))), CAST(32, MSB(DUP(op_AND_147)), DUP(op_AND_147))), op_RSHIFT_180);
	RzILOpPure *op_LT_184 = SLT(op_ADD_181, CAST(64, MSB(SN(32, 0)), SN(32, 0)));
	RzILOpPure *op_LSHIFT_189 = SHIFTL0(SN(64, 1), SN(32, 31));
	RzILOpPure *op_NEG_190 = NEG(op_LSHIFT_189);
	RzILOpPure *op_LSHIFT_195 = SHIFTL0(SN(64, 1), SN(32, 31));
	RzILOpPure *op_SUB_198 = SUB(op_LSHIFT_195, CAST(64, MSB(SN(32, 1)), SN(32, 1)));
	RzILOpPure *cond_199 = ITE(op_LT_184, op_NEG_190, op_SUB_198);
	RzILOpEffect *gcc_expr_200 = BRANCH(op_EQ_98, EMPTY(), set_usr_field_call_141);

	// h_tmp272 = HYB(gcc_expr_if ((sextract64(((ut64) ((st64) ((st32) ((Rxx >> 0x20) & 0xffffffff))) + ((((st64) ((st32) ((st64) ((st32) ((Rss >> 0x20) & 0xffffffff))))) * sextract64(((ut64) ((st16) ((Rtt >> 0x30) & ((st64) 0xffff)))), 0x0, 0x10) << 0x0) >> 0x10)), 0x0, 0x20) == ((st64) ((st32) ((Rxx >> 0x20) & 0xffffffff))) + ((((st64) ((st32) ((st64) ((st32) ((Rss >> 0x20) & 0xffffffff))))) * sextract64(((ut64) ((st16) ((Rtt >> 0x30) & ((st64) 0xffff)))), 0x0, 0x10) << 0x0) >> 0x10))) {{}} else {set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, ((ut32) 0x1))}, ((((st64) ((st32) ((Rxx >> 0x20) & 0xffffffff))) + ((((st64) ((st32) ((st64) ((st32) ((Rss >> 0x20) & 0xffffffff))))) * sextract64(((ut64) ((st16) ((Rtt >> 0x30) & ((st64) 0xffff)))), 0x0, 0x10) << 0x0) >> 0x10) < ((st64) 0x0)) ? (-(0x1 << 0x1f)) : (0x1 << 0x1f) - ((st64) 0x1)));
	RzILOpEffect *op_ASSIGN_hybrid_tmp_202 = SETL("h_tmp272", cond_199);

	// seq(HYB(gcc_expr_if ((sextract64(((ut64) ((st64) ((st32) ((Rxx > ...;
	RzILOpEffect *seq_203 = SEQN(2, gcc_expr_200, op_ASSIGN_hybrid_tmp_202);

	// Rxx = ((Rxx & (~(0xffffffff << 0x20))) | ((((sextract64(((ut64) ((st64) ((st32) ((Rxx >> 0x20) & 0xffffffff))) + ((((st64) ((st32) ((st64) ((st32) ((Rss >> 0x20) & 0xffffffff))))) * sextract64(((ut64) ((st16) ((Rtt >> 0x30) & ((st64) 0xffff)))), 0x0, 0x10) << 0x0) >> 0x10)), 0x0, 0x20) == ((st64) ((st32) ((Rxx >> 0x20) & 0xffffffff))) + ((((st64) ((st32) ((st64) ((st32) ((Rss >> 0x20) & 0xffffffff))))) * sextract64(((ut64) ((st16) ((Rtt >> 0x30) & ((st64) 0xffff)))), 0x0, 0x10) << 0x0) >> 0x10)) ? ((st64) ((st32) ((Rxx >> 0x20) & 0xffffffff))) + ((((st64) ((st32) ((st64) ((st32) ((Rss >> 0x20) & 0xffffffff))))) * sextract64(((ut64) ((st16) ((Rtt >> 0x30) & ((st64) 0xffff)))), 0x0, 0x10) << 0x0) >> 0x10) : h_tmp272) & 0xffffffff) << 0x20));
	RzILOpPure *op_LSHIFT_5 = SHIFTL0(SN(64, 0xffffffff), SN(32, 0x20));
	RzILOpPure *op_NOT_6 = LOGNOT(op_LSHIFT_5);
	RzILOpPure *op_AND_7 = LOGAND(READ_REG(pkt, Rxx_op, false), op_NOT_6);
	RzILOpPure *op_RSHIFT_102 = SHIFTRA(READ_REG(pkt, Rxx_op, false), SN(32, 0x20));
	RzILOpPure *op_AND_104 = LOGAND(op_RSHIFT_102, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_110 = SHIFTRA(DUP(Rss), SN(32, 0x20));
	RzILOpPure *op_AND_112 = LOGAND(op_RSHIFT_110, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_123 = SHIFTRA(DUP(Rtt), SN(32, 0x30));
	RzILOpPure *op_AND_126 = LOGAND(op_RSHIFT_123, CAST(64, MSB(SN(32, 0xffff)), SN(32, 0xffff)));
	RzILOpPure *op_MUL_133 = MUL(CAST(64, MSB(CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(op_AND_112), DUP(op_AND_112))), CAST(32, MSB(DUP(op_AND_112)), DUP(op_AND_112)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_112)), DUP(op_AND_112))), CAST(32, MSB(DUP(op_AND_112)), DUP(op_AND_112))))), CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(DUP(op_AND_112)), DUP(op_AND_112))), CAST(32, MSB(DUP(op_AND_112)), DUP(op_AND_112)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_112)), DUP(op_AND_112))), CAST(32, MSB(DUP(op_AND_112)), DUP(op_AND_112))))), SEXTRACT64(CAST(64, IL_FALSE, CAST(16, MSB(op_AND_126), DUP(op_AND_126))), SN(32, 0), SN(32, 16)));
	RzILOpPure *op_LSHIFT_135 = SHIFTL0(op_MUL_133, SN(32, 0));
	RzILOpPure *op_RSHIFT_137 = SHIFTRA(op_LSHIFT_135, SN(32, 16));
	RzILOpPure *op_ADD_138 = ADD(CAST(64, MSB(CAST(32, MSB(op_AND_104), DUP(op_AND_104))), CAST(32, MSB(DUP(op_AND_104)), DUP(op_AND_104))), op_RSHIFT_137);
	RzILOpPure *cond_204 = ITE(DUP(op_EQ_98), op_ADD_138, VARL("h_tmp272"));
	RzILOpPure *op_AND_206 = LOGAND(cond_204, SN(64, 0xffffffff));
	RzILOpPure *op_LSHIFT_210 = SHIFTL0(op_AND_206, SN(32, 0x20));
	RzILOpPure *op_OR_211 = LOGOR(op_AND_7, op_LSHIFT_210);
	RzILOpEffect *op_ASSIGN_212 = WRITE_REG(bundle, Rxx_op, op_OR_211);

	// seq(seq(HYB(gcc_expr_if ((sextract64(((ut64) ((st64) ((st32) ((R ...;
	RzILOpEffect *seq_213 = SEQN(2, seq_203, op_ASSIGN_212);

	// set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, ((ut32) 0x1));
	RzILOpEffect *set_usr_field_call_353 = hex_set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, CAST(32, IL_FALSE, SN(32, 1)));

	// HYB(gcc_expr_if ((sextract64(((ut64) ((st64) ((st32) ((Rxx >> 0x0) & 0xffffffff))) + ((((st64) ((st32) ((st64) ((st32) ((Rss >> 0x0) & 0xffffffff))))) * sextract64(((ut64) ((st16) ((Rtt >> 0x10) & ((st64) 0xffff)))), 0x0, 0x10) << 0x0) >> 0x10)), 0x0, 0x20) == ((st64) ((st32) ((Rxx >> 0x0) & 0xffffffff))) + ((((st64) ((st32) ((st64) ((st32) ((Rss >> 0x0) & 0xffffffff))))) * sextract64(((ut64) ((st16) ((Rtt >> 0x10) & ((st64) 0xffff)))), 0x0, 0x10) << 0x0) >> 0x10))) {{}} else {set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, ((ut32) 0x1))}, ((((st64) ((st32) ((Rxx >> 0x0) & 0xffffffff))) + ((((st64) ((st32) ((st64) ((st32) ((Rss >> 0x0) & 0xffffffff))))) * sextract64(((ut64) ((st16) ((Rtt >> 0x10) & ((st64) 0xffff)))), 0x0, 0x10) << 0x0) >> 0x10) < ((st64) 0x0)) ? (-(0x1 << 0x1f)) : (0x1 << 0x1f) - ((st64) 0x1)));
	RzILOpPure *op_RSHIFT_228 = SHIFTRA(READ_REG(pkt, Rxx_op, false), SN(32, 0));
	RzILOpPure *op_AND_230 = LOGAND(op_RSHIFT_228, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_236 = SHIFTRA(DUP(Rss), SN(32, 0));
	RzILOpPure *op_AND_238 = LOGAND(op_RSHIFT_236, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_249 = SHIFTRA(DUP(Rtt), SN(32, 16));
	RzILOpPure *op_AND_252 = LOGAND(op_RSHIFT_249, CAST(64, MSB(SN(32, 0xffff)), SN(32, 0xffff)));
	RzILOpPure *op_MUL_259 = MUL(CAST(64, MSB(CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(op_AND_238), DUP(op_AND_238))), CAST(32, MSB(DUP(op_AND_238)), DUP(op_AND_238)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_238)), DUP(op_AND_238))), CAST(32, MSB(DUP(op_AND_238)), DUP(op_AND_238))))), CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(DUP(op_AND_238)), DUP(op_AND_238))), CAST(32, MSB(DUP(op_AND_238)), DUP(op_AND_238)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_238)), DUP(op_AND_238))), CAST(32, MSB(DUP(op_AND_238)), DUP(op_AND_238))))), SEXTRACT64(CAST(64, IL_FALSE, CAST(16, MSB(op_AND_252), DUP(op_AND_252))), SN(32, 0), SN(32, 16)));
	RzILOpPure *op_LSHIFT_261 = SHIFTL0(op_MUL_259, SN(32, 0));
	RzILOpPure *op_RSHIFT_263 = SHIFTRA(op_LSHIFT_261, SN(32, 16));
	RzILOpPure *op_ADD_264 = ADD(CAST(64, MSB(CAST(32, MSB(op_AND_230), DUP(op_AND_230))), CAST(32, MSB(DUP(op_AND_230)), DUP(op_AND_230))), op_RSHIFT_263);
	RzILOpPure *op_RSHIFT_273 = SHIFTRA(READ_REG(pkt, Rxx_op, false), SN(32, 0));
	RzILOpPure *op_AND_275 = LOGAND(op_RSHIFT_273, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_281 = SHIFTRA(DUP(Rss), SN(32, 0));
	RzILOpPure *op_AND_283 = LOGAND(op_RSHIFT_281, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_294 = SHIFTRA(DUP(Rtt), SN(32, 16));
	RzILOpPure *op_AND_297 = LOGAND(op_RSHIFT_294, CAST(64, MSB(SN(32, 0xffff)), SN(32, 0xffff)));
	RzILOpPure *op_MUL_304 = MUL(CAST(64, MSB(CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(op_AND_283), DUP(op_AND_283))), CAST(32, MSB(DUP(op_AND_283)), DUP(op_AND_283)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_283)), DUP(op_AND_283))), CAST(32, MSB(DUP(op_AND_283)), DUP(op_AND_283))))), CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(DUP(op_AND_283)), DUP(op_AND_283))), CAST(32, MSB(DUP(op_AND_283)), DUP(op_AND_283)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_283)), DUP(op_AND_283))), CAST(32, MSB(DUP(op_AND_283)), DUP(op_AND_283))))), SEXTRACT64(CAST(64, IL_FALSE, CAST(16, MSB(op_AND_297), DUP(op_AND_297))), SN(32, 0), SN(32, 16)));
	RzILOpPure *op_LSHIFT_306 = SHIFTL0(op_MUL_304, SN(32, 0));
	RzILOpPure *op_RSHIFT_308 = SHIFTRA(op_LSHIFT_306, SN(32, 16));
	RzILOpPure *op_ADD_309 = ADD(CAST(64, MSB(CAST(32, MSB(op_AND_275), DUP(op_AND_275))), CAST(32, MSB(DUP(op_AND_275)), DUP(op_AND_275))), op_RSHIFT_308);
	RzILOpPure *op_EQ_310 = EQ(SEXTRACT64(CAST(64, IL_FALSE, op_ADD_264), SN(32, 0), SN(32, 0x20)), op_ADD_309);
	RzILOpPure *op_RSHIFT_357 = SHIFTRA(READ_REG(pkt, Rxx_op, false), SN(32, 0));
	RzILOpPure *op_AND_359 = LOGAND(op_RSHIFT_357, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_365 = SHIFTRA(DUP(Rss), SN(32, 0));
	RzILOpPure *op_AND_367 = LOGAND(op_RSHIFT_365, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_378 = SHIFTRA(DUP(Rtt), SN(32, 16));
	RzILOpPure *op_AND_381 = LOGAND(op_RSHIFT_378, CAST(64, MSB(SN(32, 0xffff)), SN(32, 0xffff)));
	RzILOpPure *op_MUL_388 = MUL(CAST(64, MSB(CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(op_AND_367), DUP(op_AND_367))), CAST(32, MSB(DUP(op_AND_367)), DUP(op_AND_367)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_367)), DUP(op_AND_367))), CAST(32, MSB(DUP(op_AND_367)), DUP(op_AND_367))))), CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(DUP(op_AND_367)), DUP(op_AND_367))), CAST(32, MSB(DUP(op_AND_367)), DUP(op_AND_367)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_367)), DUP(op_AND_367))), CAST(32, MSB(DUP(op_AND_367)), DUP(op_AND_367))))), SEXTRACT64(CAST(64, IL_FALSE, CAST(16, MSB(op_AND_381), DUP(op_AND_381))), SN(32, 0), SN(32, 16)));
	RzILOpPure *op_LSHIFT_390 = SHIFTL0(op_MUL_388, SN(32, 0));
	RzILOpPure *op_RSHIFT_392 = SHIFTRA(op_LSHIFT_390, SN(32, 16));
	RzILOpPure *op_ADD_393 = ADD(CAST(64, MSB(CAST(32, MSB(op_AND_359), DUP(op_AND_359))), CAST(32, MSB(DUP(op_AND_359)), DUP(op_AND_359))), op_RSHIFT_392);
	RzILOpPure *op_LT_396 = SLT(op_ADD_393, CAST(64, MSB(SN(32, 0)), SN(32, 0)));
	RzILOpPure *op_LSHIFT_401 = SHIFTL0(SN(64, 1), SN(32, 31));
	RzILOpPure *op_NEG_402 = NEG(op_LSHIFT_401);
	RzILOpPure *op_LSHIFT_407 = SHIFTL0(SN(64, 1), SN(32, 31));
	RzILOpPure *op_SUB_410 = SUB(op_LSHIFT_407, CAST(64, MSB(SN(32, 1)), SN(32, 1)));
	RzILOpPure *cond_411 = ITE(op_LT_396, op_NEG_402, op_SUB_410);
	RzILOpEffect *gcc_expr_412 = BRANCH(op_EQ_310, EMPTY(), set_usr_field_call_353);

	// h_tmp273 = HYB(gcc_expr_if ((sextract64(((ut64) ((st64) ((st32) ((Rxx >> 0x0) & 0xffffffff))) + ((((st64) ((st32) ((st64) ((st32) ((Rss >> 0x0) & 0xffffffff))))) * sextract64(((ut64) ((st16) ((Rtt >> 0x10) & ((st64) 0xffff)))), 0x0, 0x10) << 0x0) >> 0x10)), 0x0, 0x20) == ((st64) ((st32) ((Rxx >> 0x0) & 0xffffffff))) + ((((st64) ((st32) ((st64) ((st32) ((Rss >> 0x0) & 0xffffffff))))) * sextract64(((ut64) ((st16) ((Rtt >> 0x10) & ((st64) 0xffff)))), 0x0, 0x10) << 0x0) >> 0x10))) {{}} else {set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, ((ut32) 0x1))}, ((((st64) ((st32) ((Rxx >> 0x0) & 0xffffffff))) + ((((st64) ((st32) ((st64) ((st32) ((Rss >> 0x0) & 0xffffffff))))) * sextract64(((ut64) ((st16) ((Rtt >> 0x10) & ((st64) 0xffff)))), 0x0, 0x10) << 0x0) >> 0x10) < ((st64) 0x0)) ? (-(0x1 << 0x1f)) : (0x1 << 0x1f) - ((st64) 0x1)));
	RzILOpEffect *op_ASSIGN_hybrid_tmp_414 = SETL("h_tmp273", cond_411);

	// seq(HYB(gcc_expr_if ((sextract64(((ut64) ((st64) ((st32) ((Rxx > ...;
	RzILOpEffect *seq_415 = SEQN(2, gcc_expr_412, op_ASSIGN_hybrid_tmp_414);

	// Rxx = ((Rxx & (~(0xffffffff << 0x0))) | ((((sextract64(((ut64) ((st64) ((st32) ((Rxx >> 0x0) & 0xffffffff))) + ((((st64) ((st32) ((st64) ((st32) ((Rss >> 0x0) & 0xffffffff))))) * sextract64(((ut64) ((st16) ((Rtt >> 0x10) & ((st64) 0xffff)))), 0x0, 0x10) << 0x0) >> 0x10)), 0x0, 0x20) == ((st64) ((st32) ((Rxx >> 0x0) & 0xffffffff))) + ((((st64) ((st32) ((st64) ((st32) ((Rss >> 0x0) & 0xffffffff))))) * sextract64(((ut64) ((st16) ((Rtt >> 0x10) & ((st64) 0xffff)))), 0x0, 0x10) << 0x0) >> 0x10)) ? ((st64) ((st32) ((Rxx >> 0x0) & 0xffffffff))) + ((((st64) ((st32) ((st64) ((st32) ((Rss >> 0x0) & 0xffffffff))))) * sextract64(((ut64) ((st16) ((Rtt >> 0x10) & ((st64) 0xffff)))), 0x0, 0x10) << 0x0) >> 0x10) : h_tmp273) & 0xffffffff) << 0x0));
	RzILOpPure *op_LSHIFT_219 = SHIFTL0(SN(64, 0xffffffff), SN(32, 0));
	RzILOpPure *op_NOT_220 = LOGNOT(op_LSHIFT_219);
	RzILOpPure *op_AND_221 = LOGAND(READ_REG(pkt, Rxx_op, false), op_NOT_220);
	RzILOpPure *op_RSHIFT_314 = SHIFTRA(READ_REG(pkt, Rxx_op, false), SN(32, 0));
	RzILOpPure *op_AND_316 = LOGAND(op_RSHIFT_314, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_322 = SHIFTRA(DUP(Rss), SN(32, 0));
	RzILOpPure *op_AND_324 = LOGAND(op_RSHIFT_322, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_335 = SHIFTRA(DUP(Rtt), SN(32, 16));
	RzILOpPure *op_AND_338 = LOGAND(op_RSHIFT_335, CAST(64, MSB(SN(32, 0xffff)), SN(32, 0xffff)));
	RzILOpPure *op_MUL_345 = MUL(CAST(64, MSB(CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(op_AND_324), DUP(op_AND_324))), CAST(32, MSB(DUP(op_AND_324)), DUP(op_AND_324)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_324)), DUP(op_AND_324))), CAST(32, MSB(DUP(op_AND_324)), DUP(op_AND_324))))), CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(DUP(op_AND_324)), DUP(op_AND_324))), CAST(32, MSB(DUP(op_AND_324)), DUP(op_AND_324)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_324)), DUP(op_AND_324))), CAST(32, MSB(DUP(op_AND_324)), DUP(op_AND_324))))), SEXTRACT64(CAST(64, IL_FALSE, CAST(16, MSB(op_AND_338), DUP(op_AND_338))), SN(32, 0), SN(32, 16)));
	RzILOpPure *op_LSHIFT_347 = SHIFTL0(op_MUL_345, SN(32, 0));
	RzILOpPure *op_RSHIFT_349 = SHIFTRA(op_LSHIFT_347, SN(32, 16));
	RzILOpPure *op_ADD_350 = ADD(CAST(64, MSB(CAST(32, MSB(op_AND_316), DUP(op_AND_316))), CAST(32, MSB(DUP(op_AND_316)), DUP(op_AND_316))), op_RSHIFT_349);
	RzILOpPure *cond_416 = ITE(DUP(op_EQ_310), op_ADD_350, VARL("h_tmp273"));
	RzILOpPure *op_AND_418 = LOGAND(cond_416, SN(64, 0xffffffff));
	RzILOpPure *op_LSHIFT_422 = SHIFTL0(op_AND_418, SN(32, 0));
	RzILOpPure *op_OR_423 = LOGOR(op_AND_221, op_LSHIFT_422);
	RzILOpEffect *op_ASSIGN_424 = WRITE_REG(bundle, Rxx_op, op_OR_423);

	// seq(seq(HYB(gcc_expr_if ((sextract64(((ut64) ((st64) ((st32) ((R ...;
	RzILOpEffect *seq_425 = SEQN(2, seq_415, op_ASSIGN_424);

	RzILOpEffect *instruction_sequence = SEQN(2, seq_213, seq_425);
	return instruction_sequence;
}

// Rxx += vmpywoh(Rss,Rtt):<<1:sat
RzILOpEffect *hex_il_op_m2_mmachs_s1(HexInsnPktBundle *bundle) {
	const HexInsn *hi = bundle->insn;
	HexPkt *pkt = bundle->pkt;
	// READ
	const HexOp *Rxx_op = ISA2REG(hi, 'x', false);

	const HexOp *Rss_op = ISA2REG(hi, 's', false);
	RzILOpPure *Rss = READ_REG(pkt, Rss_op, false);
	const HexOp *Rtt_op = ISA2REG(hi, 't', false);
	RzILOpPure *Rtt = READ_REG(pkt, Rtt_op, false);

	// set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, ((ut32) 0x1));
	RzILOpEffect *set_usr_field_call_141 = hex_set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, CAST(32, IL_FALSE, SN(32, 1)));

	// HYB(gcc_expr_if ((sextract64(((ut64) ((st64) ((st32) ((Rxx >> 0x20) & 0xffffffff))) + ((((st64) ((st32) ((st64) ((st32) ((Rss >> 0x20) & 0xffffffff))))) * sextract64(((ut64) ((st16) ((Rtt >> 0x30) & ((st64) 0xffff)))), 0x0, 0x10) << 0x1) >> 0x10)), 0x0, 0x20) == ((st64) ((st32) ((Rxx >> 0x20) & 0xffffffff))) + ((((st64) ((st32) ((st64) ((st32) ((Rss >> 0x20) & 0xffffffff))))) * sextract64(((ut64) ((st16) ((Rtt >> 0x30) & ((st64) 0xffff)))), 0x0, 0x10) << 0x1) >> 0x10))) {{}} else {set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, ((ut32) 0x1))}, ((((st64) ((st32) ((Rxx >> 0x20) & 0xffffffff))) + ((((st64) ((st32) ((st64) ((st32) ((Rss >> 0x20) & 0xffffffff))))) * sextract64(((ut64) ((st16) ((Rtt >> 0x30) & ((st64) 0xffff)))), 0x0, 0x10) << 0x1) >> 0x10) < ((st64) 0x0)) ? (-(0x1 << 0x1f)) : (0x1 << 0x1f) - ((st64) 0x1)));
	RzILOpPure *op_RSHIFT_14 = SHIFTRA(READ_REG(pkt, Rxx_op, false), SN(32, 0x20));
	RzILOpPure *op_AND_16 = LOGAND(op_RSHIFT_14, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_23 = SHIFTRA(Rss, SN(32, 0x20));
	RzILOpPure *op_AND_25 = LOGAND(op_RSHIFT_23, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_37 = SHIFTRA(Rtt, SN(32, 0x30));
	RzILOpPure *op_AND_40 = LOGAND(op_RSHIFT_37, CAST(64, MSB(SN(32, 0xffff)), SN(32, 0xffff)));
	RzILOpPure *op_MUL_47 = MUL(CAST(64, MSB(CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(op_AND_25), DUP(op_AND_25))), CAST(32, MSB(DUP(op_AND_25)), DUP(op_AND_25)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_25)), DUP(op_AND_25))), CAST(32, MSB(DUP(op_AND_25)), DUP(op_AND_25))))), CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(DUP(op_AND_25)), DUP(op_AND_25))), CAST(32, MSB(DUP(op_AND_25)), DUP(op_AND_25)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_25)), DUP(op_AND_25))), CAST(32, MSB(DUP(op_AND_25)), DUP(op_AND_25))))), SEXTRACT64(CAST(64, IL_FALSE, CAST(16, MSB(op_AND_40), DUP(op_AND_40))), SN(32, 0), SN(32, 16)));
	RzILOpPure *op_LSHIFT_49 = SHIFTL0(op_MUL_47, SN(32, 1));
	RzILOpPure *op_RSHIFT_51 = SHIFTRA(op_LSHIFT_49, SN(32, 16));
	RzILOpPure *op_ADD_52 = ADD(CAST(64, MSB(CAST(32, MSB(op_AND_16), DUP(op_AND_16))), CAST(32, MSB(DUP(op_AND_16)), DUP(op_AND_16))), op_RSHIFT_51);
	RzILOpPure *op_RSHIFT_61 = SHIFTRA(READ_REG(pkt, Rxx_op, false), SN(32, 0x20));
	RzILOpPure *op_AND_63 = LOGAND(op_RSHIFT_61, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_69 = SHIFTRA(DUP(Rss), SN(32, 0x20));
	RzILOpPure *op_AND_71 = LOGAND(op_RSHIFT_69, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_82 = SHIFTRA(DUP(Rtt), SN(32, 0x30));
	RzILOpPure *op_AND_85 = LOGAND(op_RSHIFT_82, CAST(64, MSB(SN(32, 0xffff)), SN(32, 0xffff)));
	RzILOpPure *op_MUL_92 = MUL(CAST(64, MSB(CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(op_AND_71), DUP(op_AND_71))), CAST(32, MSB(DUP(op_AND_71)), DUP(op_AND_71)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_71)), DUP(op_AND_71))), CAST(32, MSB(DUP(op_AND_71)), DUP(op_AND_71))))), CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(DUP(op_AND_71)), DUP(op_AND_71))), CAST(32, MSB(DUP(op_AND_71)), DUP(op_AND_71)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_71)), DUP(op_AND_71))), CAST(32, MSB(DUP(op_AND_71)), DUP(op_AND_71))))), SEXTRACT64(CAST(64, IL_FALSE, CAST(16, MSB(op_AND_85), DUP(op_AND_85))), SN(32, 0), SN(32, 16)));
	RzILOpPure *op_LSHIFT_94 = SHIFTL0(op_MUL_92, SN(32, 1));
	RzILOpPure *op_RSHIFT_96 = SHIFTRA(op_LSHIFT_94, SN(32, 16));
	RzILOpPure *op_ADD_97 = ADD(CAST(64, MSB(CAST(32, MSB(op_AND_63), DUP(op_AND_63))), CAST(32, MSB(DUP(op_AND_63)), DUP(op_AND_63))), op_RSHIFT_96);
	RzILOpPure *op_EQ_98 = EQ(SEXTRACT64(CAST(64, IL_FALSE, op_ADD_52), SN(32, 0), SN(32, 0x20)), op_ADD_97);
	RzILOpPure *op_RSHIFT_145 = SHIFTRA(READ_REG(pkt, Rxx_op, false), SN(32, 0x20));
	RzILOpPure *op_AND_147 = LOGAND(op_RSHIFT_145, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_153 = SHIFTRA(DUP(Rss), SN(32, 0x20));
	RzILOpPure *op_AND_155 = LOGAND(op_RSHIFT_153, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_166 = SHIFTRA(DUP(Rtt), SN(32, 0x30));
	RzILOpPure *op_AND_169 = LOGAND(op_RSHIFT_166, CAST(64, MSB(SN(32, 0xffff)), SN(32, 0xffff)));
	RzILOpPure *op_MUL_176 = MUL(CAST(64, MSB(CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(op_AND_155), DUP(op_AND_155))), CAST(32, MSB(DUP(op_AND_155)), DUP(op_AND_155)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_155)), DUP(op_AND_155))), CAST(32, MSB(DUP(op_AND_155)), DUP(op_AND_155))))), CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(DUP(op_AND_155)), DUP(op_AND_155))), CAST(32, MSB(DUP(op_AND_155)), DUP(op_AND_155)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_155)), DUP(op_AND_155))), CAST(32, MSB(DUP(op_AND_155)), DUP(op_AND_155))))), SEXTRACT64(CAST(64, IL_FALSE, CAST(16, MSB(op_AND_169), DUP(op_AND_169))), SN(32, 0), SN(32, 16)));
	RzILOpPure *op_LSHIFT_178 = SHIFTL0(op_MUL_176, SN(32, 1));
	RzILOpPure *op_RSHIFT_180 = SHIFTRA(op_LSHIFT_178, SN(32, 16));
	RzILOpPure *op_ADD_181 = ADD(CAST(64, MSB(CAST(32, MSB(op_AND_147), DUP(op_AND_147))), CAST(32, MSB(DUP(op_AND_147)), DUP(op_AND_147))), op_RSHIFT_180);
	RzILOpPure *op_LT_184 = SLT(op_ADD_181, CAST(64, MSB(SN(32, 0)), SN(32, 0)));
	RzILOpPure *op_LSHIFT_189 = SHIFTL0(SN(64, 1), SN(32, 31));
	RzILOpPure *op_NEG_190 = NEG(op_LSHIFT_189);
	RzILOpPure *op_LSHIFT_195 = SHIFTL0(SN(64, 1), SN(32, 31));
	RzILOpPure *op_SUB_198 = SUB(op_LSHIFT_195, CAST(64, MSB(SN(32, 1)), SN(32, 1)));
	RzILOpPure *cond_199 = ITE(op_LT_184, op_NEG_190, op_SUB_198);
	RzILOpEffect *gcc_expr_200 = BRANCH(op_EQ_98, EMPTY(), set_usr_field_call_141);

	// h_tmp274 = HYB(gcc_expr_if ((sextract64(((ut64) ((st64) ((st32) ((Rxx >> 0x20) & 0xffffffff))) + ((((st64) ((st32) ((st64) ((st32) ((Rss >> 0x20) & 0xffffffff))))) * sextract64(((ut64) ((st16) ((Rtt >> 0x30) & ((st64) 0xffff)))), 0x0, 0x10) << 0x1) >> 0x10)), 0x0, 0x20) == ((st64) ((st32) ((Rxx >> 0x20) & 0xffffffff))) + ((((st64) ((st32) ((st64) ((st32) ((Rss >> 0x20) & 0xffffffff))))) * sextract64(((ut64) ((st16) ((Rtt >> 0x30) & ((st64) 0xffff)))), 0x0, 0x10) << 0x1) >> 0x10))) {{}} else {set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, ((ut32) 0x1))}, ((((st64) ((st32) ((Rxx >> 0x20) & 0xffffffff))) + ((((st64) ((st32) ((st64) ((st32) ((Rss >> 0x20) & 0xffffffff))))) * sextract64(((ut64) ((st16) ((Rtt >> 0x30) & ((st64) 0xffff)))), 0x0, 0x10) << 0x1) >> 0x10) < ((st64) 0x0)) ? (-(0x1 << 0x1f)) : (0x1 << 0x1f) - ((st64) 0x1)));
	RzILOpEffect *op_ASSIGN_hybrid_tmp_202 = SETL("h_tmp274", cond_199);

	// seq(HYB(gcc_expr_if ((sextract64(((ut64) ((st64) ((st32) ((Rxx > ...;
	RzILOpEffect *seq_203 = SEQN(2, gcc_expr_200, op_ASSIGN_hybrid_tmp_202);

	// Rxx = ((Rxx & (~(0xffffffff << 0x20))) | ((((sextract64(((ut64) ((st64) ((st32) ((Rxx >> 0x20) & 0xffffffff))) + ((((st64) ((st32) ((st64) ((st32) ((Rss >> 0x20) & 0xffffffff))))) * sextract64(((ut64) ((st16) ((Rtt >> 0x30) & ((st64) 0xffff)))), 0x0, 0x10) << 0x1) >> 0x10)), 0x0, 0x20) == ((st64) ((st32) ((Rxx >> 0x20) & 0xffffffff))) + ((((st64) ((st32) ((st64) ((st32) ((Rss >> 0x20) & 0xffffffff))))) * sextract64(((ut64) ((st16) ((Rtt >> 0x30) & ((st64) 0xffff)))), 0x0, 0x10) << 0x1) >> 0x10)) ? ((st64) ((st32) ((Rxx >> 0x20) & 0xffffffff))) + ((((st64) ((st32) ((st64) ((st32) ((Rss >> 0x20) & 0xffffffff))))) * sextract64(((ut64) ((st16) ((Rtt >> 0x30) & ((st64) 0xffff)))), 0x0, 0x10) << 0x1) >> 0x10) : h_tmp274) & 0xffffffff) << 0x20));
	RzILOpPure *op_LSHIFT_5 = SHIFTL0(SN(64, 0xffffffff), SN(32, 0x20));
	RzILOpPure *op_NOT_6 = LOGNOT(op_LSHIFT_5);
	RzILOpPure *op_AND_7 = LOGAND(READ_REG(pkt, Rxx_op, false), op_NOT_6);
	RzILOpPure *op_RSHIFT_102 = SHIFTRA(READ_REG(pkt, Rxx_op, false), SN(32, 0x20));
	RzILOpPure *op_AND_104 = LOGAND(op_RSHIFT_102, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_110 = SHIFTRA(DUP(Rss), SN(32, 0x20));
	RzILOpPure *op_AND_112 = LOGAND(op_RSHIFT_110, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_123 = SHIFTRA(DUP(Rtt), SN(32, 0x30));
	RzILOpPure *op_AND_126 = LOGAND(op_RSHIFT_123, CAST(64, MSB(SN(32, 0xffff)), SN(32, 0xffff)));
	RzILOpPure *op_MUL_133 = MUL(CAST(64, MSB(CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(op_AND_112), DUP(op_AND_112))), CAST(32, MSB(DUP(op_AND_112)), DUP(op_AND_112)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_112)), DUP(op_AND_112))), CAST(32, MSB(DUP(op_AND_112)), DUP(op_AND_112))))), CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(DUP(op_AND_112)), DUP(op_AND_112))), CAST(32, MSB(DUP(op_AND_112)), DUP(op_AND_112)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_112)), DUP(op_AND_112))), CAST(32, MSB(DUP(op_AND_112)), DUP(op_AND_112))))), SEXTRACT64(CAST(64, IL_FALSE, CAST(16, MSB(op_AND_126), DUP(op_AND_126))), SN(32, 0), SN(32, 16)));
	RzILOpPure *op_LSHIFT_135 = SHIFTL0(op_MUL_133, SN(32, 1));
	RzILOpPure *op_RSHIFT_137 = SHIFTRA(op_LSHIFT_135, SN(32, 16));
	RzILOpPure *op_ADD_138 = ADD(CAST(64, MSB(CAST(32, MSB(op_AND_104), DUP(op_AND_104))), CAST(32, MSB(DUP(op_AND_104)), DUP(op_AND_104))), op_RSHIFT_137);
	RzILOpPure *cond_204 = ITE(DUP(op_EQ_98), op_ADD_138, VARL("h_tmp274"));
	RzILOpPure *op_AND_206 = LOGAND(cond_204, SN(64, 0xffffffff));
	RzILOpPure *op_LSHIFT_210 = SHIFTL0(op_AND_206, SN(32, 0x20));
	RzILOpPure *op_OR_211 = LOGOR(op_AND_7, op_LSHIFT_210);
	RzILOpEffect *op_ASSIGN_212 = WRITE_REG(bundle, Rxx_op, op_OR_211);

	// seq(seq(HYB(gcc_expr_if ((sextract64(((ut64) ((st64) ((st32) ((R ...;
	RzILOpEffect *seq_213 = SEQN(2, seq_203, op_ASSIGN_212);

	// set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, ((ut32) 0x1));
	RzILOpEffect *set_usr_field_call_353 = hex_set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, CAST(32, IL_FALSE, SN(32, 1)));

	// HYB(gcc_expr_if ((sextract64(((ut64) ((st64) ((st32) ((Rxx >> 0x0) & 0xffffffff))) + ((((st64) ((st32) ((st64) ((st32) ((Rss >> 0x0) & 0xffffffff))))) * sextract64(((ut64) ((st16) ((Rtt >> 0x10) & ((st64) 0xffff)))), 0x0, 0x10) << 0x1) >> 0x10)), 0x0, 0x20) == ((st64) ((st32) ((Rxx >> 0x0) & 0xffffffff))) + ((((st64) ((st32) ((st64) ((st32) ((Rss >> 0x0) & 0xffffffff))))) * sextract64(((ut64) ((st16) ((Rtt >> 0x10) & ((st64) 0xffff)))), 0x0, 0x10) << 0x1) >> 0x10))) {{}} else {set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, ((ut32) 0x1))}, ((((st64) ((st32) ((Rxx >> 0x0) & 0xffffffff))) + ((((st64) ((st32) ((st64) ((st32) ((Rss >> 0x0) & 0xffffffff))))) * sextract64(((ut64) ((st16) ((Rtt >> 0x10) & ((st64) 0xffff)))), 0x0, 0x10) << 0x1) >> 0x10) < ((st64) 0x0)) ? (-(0x1 << 0x1f)) : (0x1 << 0x1f) - ((st64) 0x1)));
	RzILOpPure *op_RSHIFT_228 = SHIFTRA(READ_REG(pkt, Rxx_op, false), SN(32, 0));
	RzILOpPure *op_AND_230 = LOGAND(op_RSHIFT_228, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_236 = SHIFTRA(DUP(Rss), SN(32, 0));
	RzILOpPure *op_AND_238 = LOGAND(op_RSHIFT_236, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_249 = SHIFTRA(DUP(Rtt), SN(32, 16));
	RzILOpPure *op_AND_252 = LOGAND(op_RSHIFT_249, CAST(64, MSB(SN(32, 0xffff)), SN(32, 0xffff)));
	RzILOpPure *op_MUL_259 = MUL(CAST(64, MSB(CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(op_AND_238), DUP(op_AND_238))), CAST(32, MSB(DUP(op_AND_238)), DUP(op_AND_238)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_238)), DUP(op_AND_238))), CAST(32, MSB(DUP(op_AND_238)), DUP(op_AND_238))))), CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(DUP(op_AND_238)), DUP(op_AND_238))), CAST(32, MSB(DUP(op_AND_238)), DUP(op_AND_238)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_238)), DUP(op_AND_238))), CAST(32, MSB(DUP(op_AND_238)), DUP(op_AND_238))))), SEXTRACT64(CAST(64, IL_FALSE, CAST(16, MSB(op_AND_252), DUP(op_AND_252))), SN(32, 0), SN(32, 16)));
	RzILOpPure *op_LSHIFT_261 = SHIFTL0(op_MUL_259, SN(32, 1));
	RzILOpPure *op_RSHIFT_263 = SHIFTRA(op_LSHIFT_261, SN(32, 16));
	RzILOpPure *op_ADD_264 = ADD(CAST(64, MSB(CAST(32, MSB(op_AND_230), DUP(op_AND_230))), CAST(32, MSB(DUP(op_AND_230)), DUP(op_AND_230))), op_RSHIFT_263);
	RzILOpPure *op_RSHIFT_273 = SHIFTRA(READ_REG(pkt, Rxx_op, false), SN(32, 0));
	RzILOpPure *op_AND_275 = LOGAND(op_RSHIFT_273, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_281 = SHIFTRA(DUP(Rss), SN(32, 0));
	RzILOpPure *op_AND_283 = LOGAND(op_RSHIFT_281, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_294 = SHIFTRA(DUP(Rtt), SN(32, 16));
	RzILOpPure *op_AND_297 = LOGAND(op_RSHIFT_294, CAST(64, MSB(SN(32, 0xffff)), SN(32, 0xffff)));
	RzILOpPure *op_MUL_304 = MUL(CAST(64, MSB(CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(op_AND_283), DUP(op_AND_283))), CAST(32, MSB(DUP(op_AND_283)), DUP(op_AND_283)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_283)), DUP(op_AND_283))), CAST(32, MSB(DUP(op_AND_283)), DUP(op_AND_283))))), CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(DUP(op_AND_283)), DUP(op_AND_283))), CAST(32, MSB(DUP(op_AND_283)), DUP(op_AND_283)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_283)), DUP(op_AND_283))), CAST(32, MSB(DUP(op_AND_283)), DUP(op_AND_283))))), SEXTRACT64(CAST(64, IL_FALSE, CAST(16, MSB(op_AND_297), DUP(op_AND_297))), SN(32, 0), SN(32, 16)));
	RzILOpPure *op_LSHIFT_306 = SHIFTL0(op_MUL_304, SN(32, 1));
	RzILOpPure *op_RSHIFT_308 = SHIFTRA(op_LSHIFT_306, SN(32, 16));
	RzILOpPure *op_ADD_309 = ADD(CAST(64, MSB(CAST(32, MSB(op_AND_275), DUP(op_AND_275))), CAST(32, MSB(DUP(op_AND_275)), DUP(op_AND_275))), op_RSHIFT_308);
	RzILOpPure *op_EQ_310 = EQ(SEXTRACT64(CAST(64, IL_FALSE, op_ADD_264), SN(32, 0), SN(32, 0x20)), op_ADD_309);
	RzILOpPure *op_RSHIFT_357 = SHIFTRA(READ_REG(pkt, Rxx_op, false), SN(32, 0));
	RzILOpPure *op_AND_359 = LOGAND(op_RSHIFT_357, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_365 = SHIFTRA(DUP(Rss), SN(32, 0));
	RzILOpPure *op_AND_367 = LOGAND(op_RSHIFT_365, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_378 = SHIFTRA(DUP(Rtt), SN(32, 16));
	RzILOpPure *op_AND_381 = LOGAND(op_RSHIFT_378, CAST(64, MSB(SN(32, 0xffff)), SN(32, 0xffff)));
	RzILOpPure *op_MUL_388 = MUL(CAST(64, MSB(CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(op_AND_367), DUP(op_AND_367))), CAST(32, MSB(DUP(op_AND_367)), DUP(op_AND_367)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_367)), DUP(op_AND_367))), CAST(32, MSB(DUP(op_AND_367)), DUP(op_AND_367))))), CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(DUP(op_AND_367)), DUP(op_AND_367))), CAST(32, MSB(DUP(op_AND_367)), DUP(op_AND_367)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_367)), DUP(op_AND_367))), CAST(32, MSB(DUP(op_AND_367)), DUP(op_AND_367))))), SEXTRACT64(CAST(64, IL_FALSE, CAST(16, MSB(op_AND_381), DUP(op_AND_381))), SN(32, 0), SN(32, 16)));
	RzILOpPure *op_LSHIFT_390 = SHIFTL0(op_MUL_388, SN(32, 1));
	RzILOpPure *op_RSHIFT_392 = SHIFTRA(op_LSHIFT_390, SN(32, 16));
	RzILOpPure *op_ADD_393 = ADD(CAST(64, MSB(CAST(32, MSB(op_AND_359), DUP(op_AND_359))), CAST(32, MSB(DUP(op_AND_359)), DUP(op_AND_359))), op_RSHIFT_392);
	RzILOpPure *op_LT_396 = SLT(op_ADD_393, CAST(64, MSB(SN(32, 0)), SN(32, 0)));
	RzILOpPure *op_LSHIFT_401 = SHIFTL0(SN(64, 1), SN(32, 31));
	RzILOpPure *op_NEG_402 = NEG(op_LSHIFT_401);
	RzILOpPure *op_LSHIFT_407 = SHIFTL0(SN(64, 1), SN(32, 31));
	RzILOpPure *op_SUB_410 = SUB(op_LSHIFT_407, CAST(64, MSB(SN(32, 1)), SN(32, 1)));
	RzILOpPure *cond_411 = ITE(op_LT_396, op_NEG_402, op_SUB_410);
	RzILOpEffect *gcc_expr_412 = BRANCH(op_EQ_310, EMPTY(), set_usr_field_call_353);

	// h_tmp275 = HYB(gcc_expr_if ((sextract64(((ut64) ((st64) ((st32) ((Rxx >> 0x0) & 0xffffffff))) + ((((st64) ((st32) ((st64) ((st32) ((Rss >> 0x0) & 0xffffffff))))) * sextract64(((ut64) ((st16) ((Rtt >> 0x10) & ((st64) 0xffff)))), 0x0, 0x10) << 0x1) >> 0x10)), 0x0, 0x20) == ((st64) ((st32) ((Rxx >> 0x0) & 0xffffffff))) + ((((st64) ((st32) ((st64) ((st32) ((Rss >> 0x0) & 0xffffffff))))) * sextract64(((ut64) ((st16) ((Rtt >> 0x10) & ((st64) 0xffff)))), 0x0, 0x10) << 0x1) >> 0x10))) {{}} else {set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, ((ut32) 0x1))}, ((((st64) ((st32) ((Rxx >> 0x0) & 0xffffffff))) + ((((st64) ((st32) ((st64) ((st32) ((Rss >> 0x0) & 0xffffffff))))) * sextract64(((ut64) ((st16) ((Rtt >> 0x10) & ((st64) 0xffff)))), 0x0, 0x10) << 0x1) >> 0x10) < ((st64) 0x0)) ? (-(0x1 << 0x1f)) : (0x1 << 0x1f) - ((st64) 0x1)));
	RzILOpEffect *op_ASSIGN_hybrid_tmp_414 = SETL("h_tmp275", cond_411);

	// seq(HYB(gcc_expr_if ((sextract64(((ut64) ((st64) ((st32) ((Rxx > ...;
	RzILOpEffect *seq_415 = SEQN(2, gcc_expr_412, op_ASSIGN_hybrid_tmp_414);

	// Rxx = ((Rxx & (~(0xffffffff << 0x0))) | ((((sextract64(((ut64) ((st64) ((st32) ((Rxx >> 0x0) & 0xffffffff))) + ((((st64) ((st32) ((st64) ((st32) ((Rss >> 0x0) & 0xffffffff))))) * sextract64(((ut64) ((st16) ((Rtt >> 0x10) & ((st64) 0xffff)))), 0x0, 0x10) << 0x1) >> 0x10)), 0x0, 0x20) == ((st64) ((st32) ((Rxx >> 0x0) & 0xffffffff))) + ((((st64) ((st32) ((st64) ((st32) ((Rss >> 0x0) & 0xffffffff))))) * sextract64(((ut64) ((st16) ((Rtt >> 0x10) & ((st64) 0xffff)))), 0x0, 0x10) << 0x1) >> 0x10)) ? ((st64) ((st32) ((Rxx >> 0x0) & 0xffffffff))) + ((((st64) ((st32) ((st64) ((st32) ((Rss >> 0x0) & 0xffffffff))))) * sextract64(((ut64) ((st16) ((Rtt >> 0x10) & ((st64) 0xffff)))), 0x0, 0x10) << 0x1) >> 0x10) : h_tmp275) & 0xffffffff) << 0x0));
	RzILOpPure *op_LSHIFT_219 = SHIFTL0(SN(64, 0xffffffff), SN(32, 0));
	RzILOpPure *op_NOT_220 = LOGNOT(op_LSHIFT_219);
	RzILOpPure *op_AND_221 = LOGAND(READ_REG(pkt, Rxx_op, false), op_NOT_220);
	RzILOpPure *op_RSHIFT_314 = SHIFTRA(READ_REG(pkt, Rxx_op, false), SN(32, 0));
	RzILOpPure *op_AND_316 = LOGAND(op_RSHIFT_314, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_322 = SHIFTRA(DUP(Rss), SN(32, 0));
	RzILOpPure *op_AND_324 = LOGAND(op_RSHIFT_322, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_335 = SHIFTRA(DUP(Rtt), SN(32, 16));
	RzILOpPure *op_AND_338 = LOGAND(op_RSHIFT_335, CAST(64, MSB(SN(32, 0xffff)), SN(32, 0xffff)));
	RzILOpPure *op_MUL_345 = MUL(CAST(64, MSB(CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(op_AND_324), DUP(op_AND_324))), CAST(32, MSB(DUP(op_AND_324)), DUP(op_AND_324)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_324)), DUP(op_AND_324))), CAST(32, MSB(DUP(op_AND_324)), DUP(op_AND_324))))), CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(DUP(op_AND_324)), DUP(op_AND_324))), CAST(32, MSB(DUP(op_AND_324)), DUP(op_AND_324)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_324)), DUP(op_AND_324))), CAST(32, MSB(DUP(op_AND_324)), DUP(op_AND_324))))), SEXTRACT64(CAST(64, IL_FALSE, CAST(16, MSB(op_AND_338), DUP(op_AND_338))), SN(32, 0), SN(32, 16)));
	RzILOpPure *op_LSHIFT_347 = SHIFTL0(op_MUL_345, SN(32, 1));
	RzILOpPure *op_RSHIFT_349 = SHIFTRA(op_LSHIFT_347, SN(32, 16));
	RzILOpPure *op_ADD_350 = ADD(CAST(64, MSB(CAST(32, MSB(op_AND_316), DUP(op_AND_316))), CAST(32, MSB(DUP(op_AND_316)), DUP(op_AND_316))), op_RSHIFT_349);
	RzILOpPure *cond_416 = ITE(DUP(op_EQ_310), op_ADD_350, VARL("h_tmp275"));
	RzILOpPure *op_AND_418 = LOGAND(cond_416, SN(64, 0xffffffff));
	RzILOpPure *op_LSHIFT_422 = SHIFTL0(op_AND_418, SN(32, 0));
	RzILOpPure *op_OR_423 = LOGOR(op_AND_221, op_LSHIFT_422);
	RzILOpEffect *op_ASSIGN_424 = WRITE_REG(bundle, Rxx_op, op_OR_423);

	// seq(seq(HYB(gcc_expr_if ((sextract64(((ut64) ((st64) ((st32) ((R ...;
	RzILOpEffect *seq_425 = SEQN(2, seq_415, op_ASSIGN_424);

	RzILOpEffect *instruction_sequence = SEQN(2, seq_213, seq_425);
	return instruction_sequence;
}

// Rxx += vmpyweh(Rss,Rtt):rnd:sat
RzILOpEffect *hex_il_op_m2_mmacls_rs0(HexInsnPktBundle *bundle) {
	const HexInsn *hi = bundle->insn;
	HexPkt *pkt = bundle->pkt;
	// READ
	const HexOp *Rxx_op = ISA2REG(hi, 'x', false);

	const HexOp *Rss_op = ISA2REG(hi, 's', false);
	RzILOpPure *Rss = READ_REG(pkt, Rss_op, false);
	const HexOp *Rtt_op = ISA2REG(hi, 't', false);
	RzILOpPure *Rtt = READ_REG(pkt, Rtt_op, false);

	// set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, ((ut32) 0x1));
	RzILOpEffect *set_usr_field_call_150 = hex_set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, CAST(32, IL_FALSE, SN(32, 1)));

	// HYB(gcc_expr_if ((sextract64(((ut64) ((st64) ((st32) ((Rxx >> 0x20) & 0xffffffff))) + ((((st64) ((st32) ((st64) ((st32) ((Rss >> 0x20) & 0xffffffff))))) * sextract64(((ut64) ((st16) ((Rtt >> 0x20) & ((st64) 0xffff)))), 0x0, 0x10) << 0x0) + ((st64) 0x8000) >> 0x10)), 0x0, 0x20) == ((st64) ((st32) ((Rxx >> 0x20) & 0xffffffff))) + ((((st64) ((st32) ((st64) ((st32) ((Rss >> 0x20) & 0xffffffff))))) * sextract64(((ut64) ((st16) ((Rtt >> 0x20) & ((st64) 0xffff)))), 0x0, 0x10) << 0x0) + ((st64) 0x8000) >> 0x10))) {{}} else {set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, ((ut32) 0x1))}, ((((st64) ((st32) ((Rxx >> 0x20) & 0xffffffff))) + ((((st64) ((st32) ((st64) ((st32) ((Rss >> 0x20) & 0xffffffff))))) * sextract64(((ut64) ((st16) ((Rtt >> 0x20) & ((st64) 0xffff)))), 0x0, 0x10) << 0x0) + ((st64) 0x8000) >> 0x10) < ((st64) 0x0)) ? (-(0x1 << 0x1f)) : (0x1 << 0x1f) - ((st64) 0x1)));
	RzILOpPure *op_RSHIFT_14 = SHIFTRA(READ_REG(pkt, Rxx_op, false), SN(32, 0x20));
	RzILOpPure *op_AND_16 = LOGAND(op_RSHIFT_14, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_23 = SHIFTRA(Rss, SN(32, 0x20));
	RzILOpPure *op_AND_25 = LOGAND(op_RSHIFT_23, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_37 = SHIFTRA(Rtt, SN(32, 0x20));
	RzILOpPure *op_AND_40 = LOGAND(op_RSHIFT_37, CAST(64, MSB(SN(32, 0xffff)), SN(32, 0xffff)));
	RzILOpPure *op_MUL_47 = MUL(CAST(64, MSB(CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(op_AND_25), DUP(op_AND_25))), CAST(32, MSB(DUP(op_AND_25)), DUP(op_AND_25)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_25)), DUP(op_AND_25))), CAST(32, MSB(DUP(op_AND_25)), DUP(op_AND_25))))), CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(DUP(op_AND_25)), DUP(op_AND_25))), CAST(32, MSB(DUP(op_AND_25)), DUP(op_AND_25)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_25)), DUP(op_AND_25))), CAST(32, MSB(DUP(op_AND_25)), DUP(op_AND_25))))), SEXTRACT64(CAST(64, IL_FALSE, CAST(16, MSB(op_AND_40), DUP(op_AND_40))), SN(32, 0), SN(32, 16)));
	RzILOpPure *op_LSHIFT_49 = SHIFTL0(op_MUL_47, SN(32, 0));
	RzILOpPure *op_ADD_52 = ADD(op_LSHIFT_49, CAST(64, MSB(SN(32, 0x8000)), SN(32, 0x8000)));
	RzILOpPure *op_RSHIFT_54 = SHIFTRA(op_ADD_52, SN(32, 16));
	RzILOpPure *op_ADD_55 = ADD(CAST(64, MSB(CAST(32, MSB(op_AND_16), DUP(op_AND_16))), CAST(32, MSB(DUP(op_AND_16)), DUP(op_AND_16))), op_RSHIFT_54);
	RzILOpPure *op_RSHIFT_64 = SHIFTRA(READ_REG(pkt, Rxx_op, false), SN(32, 0x20));
	RzILOpPure *op_AND_66 = LOGAND(op_RSHIFT_64, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_72 = SHIFTRA(DUP(Rss), SN(32, 0x20));
	RzILOpPure *op_AND_74 = LOGAND(op_RSHIFT_72, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_85 = SHIFTRA(DUP(Rtt), SN(32, 0x20));
	RzILOpPure *op_AND_88 = LOGAND(op_RSHIFT_85, CAST(64, MSB(SN(32, 0xffff)), SN(32, 0xffff)));
	RzILOpPure *op_MUL_95 = MUL(CAST(64, MSB(CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(op_AND_74), DUP(op_AND_74))), CAST(32, MSB(DUP(op_AND_74)), DUP(op_AND_74)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_74)), DUP(op_AND_74))), CAST(32, MSB(DUP(op_AND_74)), DUP(op_AND_74))))), CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(DUP(op_AND_74)), DUP(op_AND_74))), CAST(32, MSB(DUP(op_AND_74)), DUP(op_AND_74)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_74)), DUP(op_AND_74))), CAST(32, MSB(DUP(op_AND_74)), DUP(op_AND_74))))), SEXTRACT64(CAST(64, IL_FALSE, CAST(16, MSB(op_AND_88), DUP(op_AND_88))), SN(32, 0), SN(32, 16)));
	RzILOpPure *op_LSHIFT_97 = SHIFTL0(op_MUL_95, SN(32, 0));
	RzILOpPure *op_ADD_100 = ADD(op_LSHIFT_97, CAST(64, MSB(SN(32, 0x8000)), SN(32, 0x8000)));
	RzILOpPure *op_RSHIFT_102 = SHIFTRA(op_ADD_100, SN(32, 16));
	RzILOpPure *op_ADD_103 = ADD(CAST(64, MSB(CAST(32, MSB(op_AND_66), DUP(op_AND_66))), CAST(32, MSB(DUP(op_AND_66)), DUP(op_AND_66))), op_RSHIFT_102);
	RzILOpPure *op_EQ_104 = EQ(SEXTRACT64(CAST(64, IL_FALSE, op_ADD_55), SN(32, 0), SN(32, 0x20)), op_ADD_103);
	RzILOpPure *op_RSHIFT_154 = SHIFTRA(READ_REG(pkt, Rxx_op, false), SN(32, 0x20));
	RzILOpPure *op_AND_156 = LOGAND(op_RSHIFT_154, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_162 = SHIFTRA(DUP(Rss), SN(32, 0x20));
	RzILOpPure *op_AND_164 = LOGAND(op_RSHIFT_162, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_175 = SHIFTRA(DUP(Rtt), SN(32, 0x20));
	RzILOpPure *op_AND_178 = LOGAND(op_RSHIFT_175, CAST(64, MSB(SN(32, 0xffff)), SN(32, 0xffff)));
	RzILOpPure *op_MUL_185 = MUL(CAST(64, MSB(CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(op_AND_164), DUP(op_AND_164))), CAST(32, MSB(DUP(op_AND_164)), DUP(op_AND_164)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_164)), DUP(op_AND_164))), CAST(32, MSB(DUP(op_AND_164)), DUP(op_AND_164))))), CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(DUP(op_AND_164)), DUP(op_AND_164))), CAST(32, MSB(DUP(op_AND_164)), DUP(op_AND_164)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_164)), DUP(op_AND_164))), CAST(32, MSB(DUP(op_AND_164)), DUP(op_AND_164))))), SEXTRACT64(CAST(64, IL_FALSE, CAST(16, MSB(op_AND_178), DUP(op_AND_178))), SN(32, 0), SN(32, 16)));
	RzILOpPure *op_LSHIFT_187 = SHIFTL0(op_MUL_185, SN(32, 0));
	RzILOpPure *op_ADD_190 = ADD(op_LSHIFT_187, CAST(64, MSB(SN(32, 0x8000)), SN(32, 0x8000)));
	RzILOpPure *op_RSHIFT_192 = SHIFTRA(op_ADD_190, SN(32, 16));
	RzILOpPure *op_ADD_193 = ADD(CAST(64, MSB(CAST(32, MSB(op_AND_156), DUP(op_AND_156))), CAST(32, MSB(DUP(op_AND_156)), DUP(op_AND_156))), op_RSHIFT_192);
	RzILOpPure *op_LT_196 = SLT(op_ADD_193, CAST(64, MSB(SN(32, 0)), SN(32, 0)));
	RzILOpPure *op_LSHIFT_201 = SHIFTL0(SN(64, 1), SN(32, 31));
	RzILOpPure *op_NEG_202 = NEG(op_LSHIFT_201);
	RzILOpPure *op_LSHIFT_207 = SHIFTL0(SN(64, 1), SN(32, 31));
	RzILOpPure *op_SUB_210 = SUB(op_LSHIFT_207, CAST(64, MSB(SN(32, 1)), SN(32, 1)));
	RzILOpPure *cond_211 = ITE(op_LT_196, op_NEG_202, op_SUB_210);
	RzILOpEffect *gcc_expr_212 = BRANCH(op_EQ_104, EMPTY(), set_usr_field_call_150);

	// h_tmp276 = HYB(gcc_expr_if ((sextract64(((ut64) ((st64) ((st32) ((Rxx >> 0x20) & 0xffffffff))) + ((((st64) ((st32) ((st64) ((st32) ((Rss >> 0x20) & 0xffffffff))))) * sextract64(((ut64) ((st16) ((Rtt >> 0x20) & ((st64) 0xffff)))), 0x0, 0x10) << 0x0) + ((st64) 0x8000) >> 0x10)), 0x0, 0x20) == ((st64) ((st32) ((Rxx >> 0x20) & 0xffffffff))) + ((((st64) ((st32) ((st64) ((st32) ((Rss >> 0x20) & 0xffffffff))))) * sextract64(((ut64) ((st16) ((Rtt >> 0x20) & ((st64) 0xffff)))), 0x0, 0x10) << 0x0) + ((st64) 0x8000) >> 0x10))) {{}} else {set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, ((ut32) 0x1))}, ((((st64) ((st32) ((Rxx >> 0x20) & 0xffffffff))) + ((((st64) ((st32) ((st64) ((st32) ((Rss >> 0x20) & 0xffffffff))))) * sextract64(((ut64) ((st16) ((Rtt >> 0x20) & ((st64) 0xffff)))), 0x0, 0x10) << 0x0) + ((st64) 0x8000) >> 0x10) < ((st64) 0x0)) ? (-(0x1 << 0x1f)) : (0x1 << 0x1f) - ((st64) 0x1)));
	RzILOpEffect *op_ASSIGN_hybrid_tmp_214 = SETL("h_tmp276", cond_211);

	// seq(HYB(gcc_expr_if ((sextract64(((ut64) ((st64) ((st32) ((Rxx > ...;
	RzILOpEffect *seq_215 = SEQN(2, gcc_expr_212, op_ASSIGN_hybrid_tmp_214);

	// Rxx = ((Rxx & (~(0xffffffff << 0x20))) | ((((sextract64(((ut64) ((st64) ((st32) ((Rxx >> 0x20) & 0xffffffff))) + ((((st64) ((st32) ((st64) ((st32) ((Rss >> 0x20) & 0xffffffff))))) * sextract64(((ut64) ((st16) ((Rtt >> 0x20) & ((st64) 0xffff)))), 0x0, 0x10) << 0x0) + ((st64) 0x8000) >> 0x10)), 0x0, 0x20) == ((st64) ((st32) ((Rxx >> 0x20) & 0xffffffff))) + ((((st64) ((st32) ((st64) ((st32) ((Rss >> 0x20) & 0xffffffff))))) * sextract64(((ut64) ((st16) ((Rtt >> 0x20) & ((st64) 0xffff)))), 0x0, 0x10) << 0x0) + ((st64) 0x8000) >> 0x10)) ? ((st64) ((st32) ((Rxx >> 0x20) & 0xffffffff))) + ((((st64) ((st32) ((st64) ((st32) ((Rss >> 0x20) & 0xffffffff))))) * sextract64(((ut64) ((st16) ((Rtt >> 0x20) & ((st64) 0xffff)))), 0x0, 0x10) << 0x0) + ((st64) 0x8000) >> 0x10) : h_tmp276) & 0xffffffff) << 0x20));
	RzILOpPure *op_LSHIFT_5 = SHIFTL0(SN(64, 0xffffffff), SN(32, 0x20));
	RzILOpPure *op_NOT_6 = LOGNOT(op_LSHIFT_5);
	RzILOpPure *op_AND_7 = LOGAND(READ_REG(pkt, Rxx_op, false), op_NOT_6);
	RzILOpPure *op_RSHIFT_108 = SHIFTRA(READ_REG(pkt, Rxx_op, false), SN(32, 0x20));
	RzILOpPure *op_AND_110 = LOGAND(op_RSHIFT_108, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_116 = SHIFTRA(DUP(Rss), SN(32, 0x20));
	RzILOpPure *op_AND_118 = LOGAND(op_RSHIFT_116, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_129 = SHIFTRA(DUP(Rtt), SN(32, 0x20));
	RzILOpPure *op_AND_132 = LOGAND(op_RSHIFT_129, CAST(64, MSB(SN(32, 0xffff)), SN(32, 0xffff)));
	RzILOpPure *op_MUL_139 = MUL(CAST(64, MSB(CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(op_AND_118), DUP(op_AND_118))), CAST(32, MSB(DUP(op_AND_118)), DUP(op_AND_118)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_118)), DUP(op_AND_118))), CAST(32, MSB(DUP(op_AND_118)), DUP(op_AND_118))))), CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(DUP(op_AND_118)), DUP(op_AND_118))), CAST(32, MSB(DUP(op_AND_118)), DUP(op_AND_118)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_118)), DUP(op_AND_118))), CAST(32, MSB(DUP(op_AND_118)), DUP(op_AND_118))))), SEXTRACT64(CAST(64, IL_FALSE, CAST(16, MSB(op_AND_132), DUP(op_AND_132))), SN(32, 0), SN(32, 16)));
	RzILOpPure *op_LSHIFT_141 = SHIFTL0(op_MUL_139, SN(32, 0));
	RzILOpPure *op_ADD_144 = ADD(op_LSHIFT_141, CAST(64, MSB(SN(32, 0x8000)), SN(32, 0x8000)));
	RzILOpPure *op_RSHIFT_146 = SHIFTRA(op_ADD_144, SN(32, 16));
	RzILOpPure *op_ADD_147 = ADD(CAST(64, MSB(CAST(32, MSB(op_AND_110), DUP(op_AND_110))), CAST(32, MSB(DUP(op_AND_110)), DUP(op_AND_110))), op_RSHIFT_146);
	RzILOpPure *cond_216 = ITE(DUP(op_EQ_104), op_ADD_147, VARL("h_tmp276"));
	RzILOpPure *op_AND_218 = LOGAND(cond_216, SN(64, 0xffffffff));
	RzILOpPure *op_LSHIFT_222 = SHIFTL0(op_AND_218, SN(32, 0x20));
	RzILOpPure *op_OR_223 = LOGOR(op_AND_7, op_LSHIFT_222);
	RzILOpEffect *op_ASSIGN_224 = WRITE_REG(bundle, Rxx_op, op_OR_223);

	// seq(seq(HYB(gcc_expr_if ((sextract64(((ut64) ((st64) ((st32) ((R ...;
	RzILOpEffect *seq_225 = SEQN(2, seq_215, op_ASSIGN_224);

	// set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, ((ut32) 0x1));
	RzILOpEffect *set_usr_field_call_374 = hex_set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, CAST(32, IL_FALSE, SN(32, 1)));

	// HYB(gcc_expr_if ((sextract64(((ut64) ((st64) ((st32) ((Rxx >> 0x0) & 0xffffffff))) + ((((st64) ((st32) ((st64) ((st32) ((Rss >> 0x0) & 0xffffffff))))) * sextract64(((ut64) ((st16) ((Rtt >> 0x0) & ((st64) 0xffff)))), 0x0, 0x10) << 0x0) + ((st64) 0x8000) >> 0x10)), 0x0, 0x20) == ((st64) ((st32) ((Rxx >> 0x0) & 0xffffffff))) + ((((st64) ((st32) ((st64) ((st32) ((Rss >> 0x0) & 0xffffffff))))) * sextract64(((ut64) ((st16) ((Rtt >> 0x0) & ((st64) 0xffff)))), 0x0, 0x10) << 0x0) + ((st64) 0x8000) >> 0x10))) {{}} else {set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, ((ut32) 0x1))}, ((((st64) ((st32) ((Rxx >> 0x0) & 0xffffffff))) + ((((st64) ((st32) ((st64) ((st32) ((Rss >> 0x0) & 0xffffffff))))) * sextract64(((ut64) ((st16) ((Rtt >> 0x0) & ((st64) 0xffff)))), 0x0, 0x10) << 0x0) + ((st64) 0x8000) >> 0x10) < ((st64) 0x0)) ? (-(0x1 << 0x1f)) : (0x1 << 0x1f) - ((st64) 0x1)));
	RzILOpPure *op_RSHIFT_240 = SHIFTRA(READ_REG(pkt, Rxx_op, false), SN(32, 0));
	RzILOpPure *op_AND_242 = LOGAND(op_RSHIFT_240, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_248 = SHIFTRA(DUP(Rss), SN(32, 0));
	RzILOpPure *op_AND_250 = LOGAND(op_RSHIFT_248, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_261 = SHIFTRA(DUP(Rtt), SN(32, 0));
	RzILOpPure *op_AND_264 = LOGAND(op_RSHIFT_261, CAST(64, MSB(SN(32, 0xffff)), SN(32, 0xffff)));
	RzILOpPure *op_MUL_271 = MUL(CAST(64, MSB(CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(op_AND_250), DUP(op_AND_250))), CAST(32, MSB(DUP(op_AND_250)), DUP(op_AND_250)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_250)), DUP(op_AND_250))), CAST(32, MSB(DUP(op_AND_250)), DUP(op_AND_250))))), CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(DUP(op_AND_250)), DUP(op_AND_250))), CAST(32, MSB(DUP(op_AND_250)), DUP(op_AND_250)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_250)), DUP(op_AND_250))), CAST(32, MSB(DUP(op_AND_250)), DUP(op_AND_250))))), SEXTRACT64(CAST(64, IL_FALSE, CAST(16, MSB(op_AND_264), DUP(op_AND_264))), SN(32, 0), SN(32, 16)));
	RzILOpPure *op_LSHIFT_273 = SHIFTL0(op_MUL_271, SN(32, 0));
	RzILOpPure *op_ADD_276 = ADD(op_LSHIFT_273, CAST(64, MSB(SN(32, 0x8000)), SN(32, 0x8000)));
	RzILOpPure *op_RSHIFT_278 = SHIFTRA(op_ADD_276, SN(32, 16));
	RzILOpPure *op_ADD_279 = ADD(CAST(64, MSB(CAST(32, MSB(op_AND_242), DUP(op_AND_242))), CAST(32, MSB(DUP(op_AND_242)), DUP(op_AND_242))), op_RSHIFT_278);
	RzILOpPure *op_RSHIFT_288 = SHIFTRA(READ_REG(pkt, Rxx_op, false), SN(32, 0));
	RzILOpPure *op_AND_290 = LOGAND(op_RSHIFT_288, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_296 = SHIFTRA(DUP(Rss), SN(32, 0));
	RzILOpPure *op_AND_298 = LOGAND(op_RSHIFT_296, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_309 = SHIFTRA(DUP(Rtt), SN(32, 0));
	RzILOpPure *op_AND_312 = LOGAND(op_RSHIFT_309, CAST(64, MSB(SN(32, 0xffff)), SN(32, 0xffff)));
	RzILOpPure *op_MUL_319 = MUL(CAST(64, MSB(CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(op_AND_298), DUP(op_AND_298))), CAST(32, MSB(DUP(op_AND_298)), DUP(op_AND_298)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_298)), DUP(op_AND_298))), CAST(32, MSB(DUP(op_AND_298)), DUP(op_AND_298))))), CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(DUP(op_AND_298)), DUP(op_AND_298))), CAST(32, MSB(DUP(op_AND_298)), DUP(op_AND_298)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_298)), DUP(op_AND_298))), CAST(32, MSB(DUP(op_AND_298)), DUP(op_AND_298))))), SEXTRACT64(CAST(64, IL_FALSE, CAST(16, MSB(op_AND_312), DUP(op_AND_312))), SN(32, 0), SN(32, 16)));
	RzILOpPure *op_LSHIFT_321 = SHIFTL0(op_MUL_319, SN(32, 0));
	RzILOpPure *op_ADD_324 = ADD(op_LSHIFT_321, CAST(64, MSB(SN(32, 0x8000)), SN(32, 0x8000)));
	RzILOpPure *op_RSHIFT_326 = SHIFTRA(op_ADD_324, SN(32, 16));
	RzILOpPure *op_ADD_327 = ADD(CAST(64, MSB(CAST(32, MSB(op_AND_290), DUP(op_AND_290))), CAST(32, MSB(DUP(op_AND_290)), DUP(op_AND_290))), op_RSHIFT_326);
	RzILOpPure *op_EQ_328 = EQ(SEXTRACT64(CAST(64, IL_FALSE, op_ADD_279), SN(32, 0), SN(32, 0x20)), op_ADD_327);
	RzILOpPure *op_RSHIFT_378 = SHIFTRA(READ_REG(pkt, Rxx_op, false), SN(32, 0));
	RzILOpPure *op_AND_380 = LOGAND(op_RSHIFT_378, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_386 = SHIFTRA(DUP(Rss), SN(32, 0));
	RzILOpPure *op_AND_388 = LOGAND(op_RSHIFT_386, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_399 = SHIFTRA(DUP(Rtt), SN(32, 0));
	RzILOpPure *op_AND_402 = LOGAND(op_RSHIFT_399, CAST(64, MSB(SN(32, 0xffff)), SN(32, 0xffff)));
	RzILOpPure *op_MUL_409 = MUL(CAST(64, MSB(CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(op_AND_388), DUP(op_AND_388))), CAST(32, MSB(DUP(op_AND_388)), DUP(op_AND_388)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_388)), DUP(op_AND_388))), CAST(32, MSB(DUP(op_AND_388)), DUP(op_AND_388))))), CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(DUP(op_AND_388)), DUP(op_AND_388))), CAST(32, MSB(DUP(op_AND_388)), DUP(op_AND_388)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_388)), DUP(op_AND_388))), CAST(32, MSB(DUP(op_AND_388)), DUP(op_AND_388))))), SEXTRACT64(CAST(64, IL_FALSE, CAST(16, MSB(op_AND_402), DUP(op_AND_402))), SN(32, 0), SN(32, 16)));
	RzILOpPure *op_LSHIFT_411 = SHIFTL0(op_MUL_409, SN(32, 0));
	RzILOpPure *op_ADD_414 = ADD(op_LSHIFT_411, CAST(64, MSB(SN(32, 0x8000)), SN(32, 0x8000)));
	RzILOpPure *op_RSHIFT_416 = SHIFTRA(op_ADD_414, SN(32, 16));
	RzILOpPure *op_ADD_417 = ADD(CAST(64, MSB(CAST(32, MSB(op_AND_380), DUP(op_AND_380))), CAST(32, MSB(DUP(op_AND_380)), DUP(op_AND_380))), op_RSHIFT_416);
	RzILOpPure *op_LT_420 = SLT(op_ADD_417, CAST(64, MSB(SN(32, 0)), SN(32, 0)));
	RzILOpPure *op_LSHIFT_425 = SHIFTL0(SN(64, 1), SN(32, 31));
	RzILOpPure *op_NEG_426 = NEG(op_LSHIFT_425);
	RzILOpPure *op_LSHIFT_431 = SHIFTL0(SN(64, 1), SN(32, 31));
	RzILOpPure *op_SUB_434 = SUB(op_LSHIFT_431, CAST(64, MSB(SN(32, 1)), SN(32, 1)));
	RzILOpPure *cond_435 = ITE(op_LT_420, op_NEG_426, op_SUB_434);
	RzILOpEffect *gcc_expr_436 = BRANCH(op_EQ_328, EMPTY(), set_usr_field_call_374);

	// h_tmp277 = HYB(gcc_expr_if ((sextract64(((ut64) ((st64) ((st32) ((Rxx >> 0x0) & 0xffffffff))) + ((((st64) ((st32) ((st64) ((st32) ((Rss >> 0x0) & 0xffffffff))))) * sextract64(((ut64) ((st16) ((Rtt >> 0x0) & ((st64) 0xffff)))), 0x0, 0x10) << 0x0) + ((st64) 0x8000) >> 0x10)), 0x0, 0x20) == ((st64) ((st32) ((Rxx >> 0x0) & 0xffffffff))) + ((((st64) ((st32) ((st64) ((st32) ((Rss >> 0x0) & 0xffffffff))))) * sextract64(((ut64) ((st16) ((Rtt >> 0x0) & ((st64) 0xffff)))), 0x0, 0x10) << 0x0) + ((st64) 0x8000) >> 0x10))) {{}} else {set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, ((ut32) 0x1))}, ((((st64) ((st32) ((Rxx >> 0x0) & 0xffffffff))) + ((((st64) ((st32) ((st64) ((st32) ((Rss >> 0x0) & 0xffffffff))))) * sextract64(((ut64) ((st16) ((Rtt >> 0x0) & ((st64) 0xffff)))), 0x0, 0x10) << 0x0) + ((st64) 0x8000) >> 0x10) < ((st64) 0x0)) ? (-(0x1 << 0x1f)) : (0x1 << 0x1f) - ((st64) 0x1)));
	RzILOpEffect *op_ASSIGN_hybrid_tmp_438 = SETL("h_tmp277", cond_435);

	// seq(HYB(gcc_expr_if ((sextract64(((ut64) ((st64) ((st32) ((Rxx > ...;
	RzILOpEffect *seq_439 = SEQN(2, gcc_expr_436, op_ASSIGN_hybrid_tmp_438);

	// Rxx = ((Rxx & (~(0xffffffff << 0x0))) | ((((sextract64(((ut64) ((st64) ((st32) ((Rxx >> 0x0) & 0xffffffff))) + ((((st64) ((st32) ((st64) ((st32) ((Rss >> 0x0) & 0xffffffff))))) * sextract64(((ut64) ((st16) ((Rtt >> 0x0) & ((st64) 0xffff)))), 0x0, 0x10) << 0x0) + ((st64) 0x8000) >> 0x10)), 0x0, 0x20) == ((st64) ((st32) ((Rxx >> 0x0) & 0xffffffff))) + ((((st64) ((st32) ((st64) ((st32) ((Rss >> 0x0) & 0xffffffff))))) * sextract64(((ut64) ((st16) ((Rtt >> 0x0) & ((st64) 0xffff)))), 0x0, 0x10) << 0x0) + ((st64) 0x8000) >> 0x10)) ? ((st64) ((st32) ((Rxx >> 0x0) & 0xffffffff))) + ((((st64) ((st32) ((st64) ((st32) ((Rss >> 0x0) & 0xffffffff))))) * sextract64(((ut64) ((st16) ((Rtt >> 0x0) & ((st64) 0xffff)))), 0x0, 0x10) << 0x0) + ((st64) 0x8000) >> 0x10) : h_tmp277) & 0xffffffff) << 0x0));
	RzILOpPure *op_LSHIFT_231 = SHIFTL0(SN(64, 0xffffffff), SN(32, 0));
	RzILOpPure *op_NOT_232 = LOGNOT(op_LSHIFT_231);
	RzILOpPure *op_AND_233 = LOGAND(READ_REG(pkt, Rxx_op, false), op_NOT_232);
	RzILOpPure *op_RSHIFT_332 = SHIFTRA(READ_REG(pkt, Rxx_op, false), SN(32, 0));
	RzILOpPure *op_AND_334 = LOGAND(op_RSHIFT_332, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_340 = SHIFTRA(DUP(Rss), SN(32, 0));
	RzILOpPure *op_AND_342 = LOGAND(op_RSHIFT_340, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_353 = SHIFTRA(DUP(Rtt), SN(32, 0));
	RzILOpPure *op_AND_356 = LOGAND(op_RSHIFT_353, CAST(64, MSB(SN(32, 0xffff)), SN(32, 0xffff)));
	RzILOpPure *op_MUL_363 = MUL(CAST(64, MSB(CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(op_AND_342), DUP(op_AND_342))), CAST(32, MSB(DUP(op_AND_342)), DUP(op_AND_342)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_342)), DUP(op_AND_342))), CAST(32, MSB(DUP(op_AND_342)), DUP(op_AND_342))))), CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(DUP(op_AND_342)), DUP(op_AND_342))), CAST(32, MSB(DUP(op_AND_342)), DUP(op_AND_342)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_342)), DUP(op_AND_342))), CAST(32, MSB(DUP(op_AND_342)), DUP(op_AND_342))))), SEXTRACT64(CAST(64, IL_FALSE, CAST(16, MSB(op_AND_356), DUP(op_AND_356))), SN(32, 0), SN(32, 16)));
	RzILOpPure *op_LSHIFT_365 = SHIFTL0(op_MUL_363, SN(32, 0));
	RzILOpPure *op_ADD_368 = ADD(op_LSHIFT_365, CAST(64, MSB(SN(32, 0x8000)), SN(32, 0x8000)));
	RzILOpPure *op_RSHIFT_370 = SHIFTRA(op_ADD_368, SN(32, 16));
	RzILOpPure *op_ADD_371 = ADD(CAST(64, MSB(CAST(32, MSB(op_AND_334), DUP(op_AND_334))), CAST(32, MSB(DUP(op_AND_334)), DUP(op_AND_334))), op_RSHIFT_370);
	RzILOpPure *cond_440 = ITE(DUP(op_EQ_328), op_ADD_371, VARL("h_tmp277"));
	RzILOpPure *op_AND_442 = LOGAND(cond_440, SN(64, 0xffffffff));
	RzILOpPure *op_LSHIFT_446 = SHIFTL0(op_AND_442, SN(32, 0));
	RzILOpPure *op_OR_447 = LOGOR(op_AND_233, op_LSHIFT_446);
	RzILOpEffect *op_ASSIGN_448 = WRITE_REG(bundle, Rxx_op, op_OR_447);

	// seq(seq(HYB(gcc_expr_if ((sextract64(((ut64) ((st64) ((st32) ((R ...;
	RzILOpEffect *seq_449 = SEQN(2, seq_439, op_ASSIGN_448);

	RzILOpEffect *instruction_sequence = SEQN(2, seq_225, seq_449);
	return instruction_sequence;
}

// Rxx += vmpyweh(Rss,Rtt):<<1:rnd:sat
RzILOpEffect *hex_il_op_m2_mmacls_rs1(HexInsnPktBundle *bundle) {
	const HexInsn *hi = bundle->insn;
	HexPkt *pkt = bundle->pkt;
	// READ
	const HexOp *Rxx_op = ISA2REG(hi, 'x', false);

	const HexOp *Rss_op = ISA2REG(hi, 's', false);
	RzILOpPure *Rss = READ_REG(pkt, Rss_op, false);
	const HexOp *Rtt_op = ISA2REG(hi, 't', false);
	RzILOpPure *Rtt = READ_REG(pkt, Rtt_op, false);

	// set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, ((ut32) 0x1));
	RzILOpEffect *set_usr_field_call_150 = hex_set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, CAST(32, IL_FALSE, SN(32, 1)));

	// HYB(gcc_expr_if ((sextract64(((ut64) ((st64) ((st32) ((Rxx >> 0x20) & 0xffffffff))) + ((((st64) ((st32) ((st64) ((st32) ((Rss >> 0x20) & 0xffffffff))))) * sextract64(((ut64) ((st16) ((Rtt >> 0x20) & ((st64) 0xffff)))), 0x0, 0x10) << 0x1) + ((st64) 0x8000) >> 0x10)), 0x0, 0x20) == ((st64) ((st32) ((Rxx >> 0x20) & 0xffffffff))) + ((((st64) ((st32) ((st64) ((st32) ((Rss >> 0x20) & 0xffffffff))))) * sextract64(((ut64) ((st16) ((Rtt >> 0x20) & ((st64) 0xffff)))), 0x0, 0x10) << 0x1) + ((st64) 0x8000) >> 0x10))) {{}} else {set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, ((ut32) 0x1))}, ((((st64) ((st32) ((Rxx >> 0x20) & 0xffffffff))) + ((((st64) ((st32) ((st64) ((st32) ((Rss >> 0x20) & 0xffffffff))))) * sextract64(((ut64) ((st16) ((Rtt >> 0x20) & ((st64) 0xffff)))), 0x0, 0x10) << 0x1) + ((st64) 0x8000) >> 0x10) < ((st64) 0x0)) ? (-(0x1 << 0x1f)) : (0x1 << 0x1f) - ((st64) 0x1)));
	RzILOpPure *op_RSHIFT_14 = SHIFTRA(READ_REG(pkt, Rxx_op, false), SN(32, 0x20));
	RzILOpPure *op_AND_16 = LOGAND(op_RSHIFT_14, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_23 = SHIFTRA(Rss, SN(32, 0x20));
	RzILOpPure *op_AND_25 = LOGAND(op_RSHIFT_23, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_37 = SHIFTRA(Rtt, SN(32, 0x20));
	RzILOpPure *op_AND_40 = LOGAND(op_RSHIFT_37, CAST(64, MSB(SN(32, 0xffff)), SN(32, 0xffff)));
	RzILOpPure *op_MUL_47 = MUL(CAST(64, MSB(CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(op_AND_25), DUP(op_AND_25))), CAST(32, MSB(DUP(op_AND_25)), DUP(op_AND_25)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_25)), DUP(op_AND_25))), CAST(32, MSB(DUP(op_AND_25)), DUP(op_AND_25))))), CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(DUP(op_AND_25)), DUP(op_AND_25))), CAST(32, MSB(DUP(op_AND_25)), DUP(op_AND_25)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_25)), DUP(op_AND_25))), CAST(32, MSB(DUP(op_AND_25)), DUP(op_AND_25))))), SEXTRACT64(CAST(64, IL_FALSE, CAST(16, MSB(op_AND_40), DUP(op_AND_40))), SN(32, 0), SN(32, 16)));
	RzILOpPure *op_LSHIFT_49 = SHIFTL0(op_MUL_47, SN(32, 1));
	RzILOpPure *op_ADD_52 = ADD(op_LSHIFT_49, CAST(64, MSB(SN(32, 0x8000)), SN(32, 0x8000)));
	RzILOpPure *op_RSHIFT_54 = SHIFTRA(op_ADD_52, SN(32, 16));
	RzILOpPure *op_ADD_55 = ADD(CAST(64, MSB(CAST(32, MSB(op_AND_16), DUP(op_AND_16))), CAST(32, MSB(DUP(op_AND_16)), DUP(op_AND_16))), op_RSHIFT_54);
	RzILOpPure *op_RSHIFT_64 = SHIFTRA(READ_REG(pkt, Rxx_op, false), SN(32, 0x20));
	RzILOpPure *op_AND_66 = LOGAND(op_RSHIFT_64, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_72 = SHIFTRA(DUP(Rss), SN(32, 0x20));
	RzILOpPure *op_AND_74 = LOGAND(op_RSHIFT_72, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_85 = SHIFTRA(DUP(Rtt), SN(32, 0x20));
	RzILOpPure *op_AND_88 = LOGAND(op_RSHIFT_85, CAST(64, MSB(SN(32, 0xffff)), SN(32, 0xffff)));
	RzILOpPure *op_MUL_95 = MUL(CAST(64, MSB(CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(op_AND_74), DUP(op_AND_74))), CAST(32, MSB(DUP(op_AND_74)), DUP(op_AND_74)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_74)), DUP(op_AND_74))), CAST(32, MSB(DUP(op_AND_74)), DUP(op_AND_74))))), CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(DUP(op_AND_74)), DUP(op_AND_74))), CAST(32, MSB(DUP(op_AND_74)), DUP(op_AND_74)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_74)), DUP(op_AND_74))), CAST(32, MSB(DUP(op_AND_74)), DUP(op_AND_74))))), SEXTRACT64(CAST(64, IL_FALSE, CAST(16, MSB(op_AND_88), DUP(op_AND_88))), SN(32, 0), SN(32, 16)));
	RzILOpPure *op_LSHIFT_97 = SHIFTL0(op_MUL_95, SN(32, 1));
	RzILOpPure *op_ADD_100 = ADD(op_LSHIFT_97, CAST(64, MSB(SN(32, 0x8000)), SN(32, 0x8000)));
	RzILOpPure *op_RSHIFT_102 = SHIFTRA(op_ADD_100, SN(32, 16));
	RzILOpPure *op_ADD_103 = ADD(CAST(64, MSB(CAST(32, MSB(op_AND_66), DUP(op_AND_66))), CAST(32, MSB(DUP(op_AND_66)), DUP(op_AND_66))), op_RSHIFT_102);
	RzILOpPure *op_EQ_104 = EQ(SEXTRACT64(CAST(64, IL_FALSE, op_ADD_55), SN(32, 0), SN(32, 0x20)), op_ADD_103);
	RzILOpPure *op_RSHIFT_154 = SHIFTRA(READ_REG(pkt, Rxx_op, false), SN(32, 0x20));
	RzILOpPure *op_AND_156 = LOGAND(op_RSHIFT_154, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_162 = SHIFTRA(DUP(Rss), SN(32, 0x20));
	RzILOpPure *op_AND_164 = LOGAND(op_RSHIFT_162, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_175 = SHIFTRA(DUP(Rtt), SN(32, 0x20));
	RzILOpPure *op_AND_178 = LOGAND(op_RSHIFT_175, CAST(64, MSB(SN(32, 0xffff)), SN(32, 0xffff)));
	RzILOpPure *op_MUL_185 = MUL(CAST(64, MSB(CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(op_AND_164), DUP(op_AND_164))), CAST(32, MSB(DUP(op_AND_164)), DUP(op_AND_164)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_164)), DUP(op_AND_164))), CAST(32, MSB(DUP(op_AND_164)), DUP(op_AND_164))))), CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(DUP(op_AND_164)), DUP(op_AND_164))), CAST(32, MSB(DUP(op_AND_164)), DUP(op_AND_164)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_164)), DUP(op_AND_164))), CAST(32, MSB(DUP(op_AND_164)), DUP(op_AND_164))))), SEXTRACT64(CAST(64, IL_FALSE, CAST(16, MSB(op_AND_178), DUP(op_AND_178))), SN(32, 0), SN(32, 16)));
	RzILOpPure *op_LSHIFT_187 = SHIFTL0(op_MUL_185, SN(32, 1));
	RzILOpPure *op_ADD_190 = ADD(op_LSHIFT_187, CAST(64, MSB(SN(32, 0x8000)), SN(32, 0x8000)));
	RzILOpPure *op_RSHIFT_192 = SHIFTRA(op_ADD_190, SN(32, 16));
	RzILOpPure *op_ADD_193 = ADD(CAST(64, MSB(CAST(32, MSB(op_AND_156), DUP(op_AND_156))), CAST(32, MSB(DUP(op_AND_156)), DUP(op_AND_156))), op_RSHIFT_192);
	RzILOpPure *op_LT_196 = SLT(op_ADD_193, CAST(64, MSB(SN(32, 0)), SN(32, 0)));
	RzILOpPure *op_LSHIFT_201 = SHIFTL0(SN(64, 1), SN(32, 31));
	RzILOpPure *op_NEG_202 = NEG(op_LSHIFT_201);
	RzILOpPure *op_LSHIFT_207 = SHIFTL0(SN(64, 1), SN(32, 31));
	RzILOpPure *op_SUB_210 = SUB(op_LSHIFT_207, CAST(64, MSB(SN(32, 1)), SN(32, 1)));
	RzILOpPure *cond_211 = ITE(op_LT_196, op_NEG_202, op_SUB_210);
	RzILOpEffect *gcc_expr_212 = BRANCH(op_EQ_104, EMPTY(), set_usr_field_call_150);

	// h_tmp278 = HYB(gcc_expr_if ((sextract64(((ut64) ((st64) ((st32) ((Rxx >> 0x20) & 0xffffffff))) + ((((st64) ((st32) ((st64) ((st32) ((Rss >> 0x20) & 0xffffffff))))) * sextract64(((ut64) ((st16) ((Rtt >> 0x20) & ((st64) 0xffff)))), 0x0, 0x10) << 0x1) + ((st64) 0x8000) >> 0x10)), 0x0, 0x20) == ((st64) ((st32) ((Rxx >> 0x20) & 0xffffffff))) + ((((st64) ((st32) ((st64) ((st32) ((Rss >> 0x20) & 0xffffffff))))) * sextract64(((ut64) ((st16) ((Rtt >> 0x20) & ((st64) 0xffff)))), 0x0, 0x10) << 0x1) + ((st64) 0x8000) >> 0x10))) {{}} else {set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, ((ut32) 0x1))}, ((((st64) ((st32) ((Rxx >> 0x20) & 0xffffffff))) + ((((st64) ((st32) ((st64) ((st32) ((Rss >> 0x20) & 0xffffffff))))) * sextract64(((ut64) ((st16) ((Rtt >> 0x20) & ((st64) 0xffff)))), 0x0, 0x10) << 0x1) + ((st64) 0x8000) >> 0x10) < ((st64) 0x0)) ? (-(0x1 << 0x1f)) : (0x1 << 0x1f) - ((st64) 0x1)));
	RzILOpEffect *op_ASSIGN_hybrid_tmp_214 = SETL("h_tmp278", cond_211);

	// seq(HYB(gcc_expr_if ((sextract64(((ut64) ((st64) ((st32) ((Rxx > ...;
	RzILOpEffect *seq_215 = SEQN(2, gcc_expr_212, op_ASSIGN_hybrid_tmp_214);

	// Rxx = ((Rxx & (~(0xffffffff << 0x20))) | ((((sextract64(((ut64) ((st64) ((st32) ((Rxx >> 0x20) & 0xffffffff))) + ((((st64) ((st32) ((st64) ((st32) ((Rss >> 0x20) & 0xffffffff))))) * sextract64(((ut64) ((st16) ((Rtt >> 0x20) & ((st64) 0xffff)))), 0x0, 0x10) << 0x1) + ((st64) 0x8000) >> 0x10)), 0x0, 0x20) == ((st64) ((st32) ((Rxx >> 0x20) & 0xffffffff))) + ((((st64) ((st32) ((st64) ((st32) ((Rss >> 0x20) & 0xffffffff))))) * sextract64(((ut64) ((st16) ((Rtt >> 0x20) & ((st64) 0xffff)))), 0x0, 0x10) << 0x1) + ((st64) 0x8000) >> 0x10)) ? ((st64) ((st32) ((Rxx >> 0x20) & 0xffffffff))) + ((((st64) ((st32) ((st64) ((st32) ((Rss >> 0x20) & 0xffffffff))))) * sextract64(((ut64) ((st16) ((Rtt >> 0x20) & ((st64) 0xffff)))), 0x0, 0x10) << 0x1) + ((st64) 0x8000) >> 0x10) : h_tmp278) & 0xffffffff) << 0x20));
	RzILOpPure *op_LSHIFT_5 = SHIFTL0(SN(64, 0xffffffff), SN(32, 0x20));
	RzILOpPure *op_NOT_6 = LOGNOT(op_LSHIFT_5);
	RzILOpPure *op_AND_7 = LOGAND(READ_REG(pkt, Rxx_op, false), op_NOT_6);
	RzILOpPure *op_RSHIFT_108 = SHIFTRA(READ_REG(pkt, Rxx_op, false), SN(32, 0x20));
	RzILOpPure *op_AND_110 = LOGAND(op_RSHIFT_108, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_116 = SHIFTRA(DUP(Rss), SN(32, 0x20));
	RzILOpPure *op_AND_118 = LOGAND(op_RSHIFT_116, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_129 = SHIFTRA(DUP(Rtt), SN(32, 0x20));
	RzILOpPure *op_AND_132 = LOGAND(op_RSHIFT_129, CAST(64, MSB(SN(32, 0xffff)), SN(32, 0xffff)));
	RzILOpPure *op_MUL_139 = MUL(CAST(64, MSB(CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(op_AND_118), DUP(op_AND_118))), CAST(32, MSB(DUP(op_AND_118)), DUP(op_AND_118)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_118)), DUP(op_AND_118))), CAST(32, MSB(DUP(op_AND_118)), DUP(op_AND_118))))), CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(DUP(op_AND_118)), DUP(op_AND_118))), CAST(32, MSB(DUP(op_AND_118)), DUP(op_AND_118)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_118)), DUP(op_AND_118))), CAST(32, MSB(DUP(op_AND_118)), DUP(op_AND_118))))), SEXTRACT64(CAST(64, IL_FALSE, CAST(16, MSB(op_AND_132), DUP(op_AND_132))), SN(32, 0), SN(32, 16)));
	RzILOpPure *op_LSHIFT_141 = SHIFTL0(op_MUL_139, SN(32, 1));
	RzILOpPure *op_ADD_144 = ADD(op_LSHIFT_141, CAST(64, MSB(SN(32, 0x8000)), SN(32, 0x8000)));
	RzILOpPure *op_RSHIFT_146 = SHIFTRA(op_ADD_144, SN(32, 16));
	RzILOpPure *op_ADD_147 = ADD(CAST(64, MSB(CAST(32, MSB(op_AND_110), DUP(op_AND_110))), CAST(32, MSB(DUP(op_AND_110)), DUP(op_AND_110))), op_RSHIFT_146);
	RzILOpPure *cond_216 = ITE(DUP(op_EQ_104), op_ADD_147, VARL("h_tmp278"));
	RzILOpPure *op_AND_218 = LOGAND(cond_216, SN(64, 0xffffffff));
	RzILOpPure *op_LSHIFT_222 = SHIFTL0(op_AND_218, SN(32, 0x20));
	RzILOpPure *op_OR_223 = LOGOR(op_AND_7, op_LSHIFT_222);
	RzILOpEffect *op_ASSIGN_224 = WRITE_REG(bundle, Rxx_op, op_OR_223);

	// seq(seq(HYB(gcc_expr_if ((sextract64(((ut64) ((st64) ((st32) ((R ...;
	RzILOpEffect *seq_225 = SEQN(2, seq_215, op_ASSIGN_224);

	// set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, ((ut32) 0x1));
	RzILOpEffect *set_usr_field_call_374 = hex_set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, CAST(32, IL_FALSE, SN(32, 1)));

	// HYB(gcc_expr_if ((sextract64(((ut64) ((st64) ((st32) ((Rxx >> 0x0) & 0xffffffff))) + ((((st64) ((st32) ((st64) ((st32) ((Rss >> 0x0) & 0xffffffff))))) * sextract64(((ut64) ((st16) ((Rtt >> 0x0) & ((st64) 0xffff)))), 0x0, 0x10) << 0x1) + ((st64) 0x8000) >> 0x10)), 0x0, 0x20) == ((st64) ((st32) ((Rxx >> 0x0) & 0xffffffff))) + ((((st64) ((st32) ((st64) ((st32) ((Rss >> 0x0) & 0xffffffff))))) * sextract64(((ut64) ((st16) ((Rtt >> 0x0) & ((st64) 0xffff)))), 0x0, 0x10) << 0x1) + ((st64) 0x8000) >> 0x10))) {{}} else {set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, ((ut32) 0x1))}, ((((st64) ((st32) ((Rxx >> 0x0) & 0xffffffff))) + ((((st64) ((st32) ((st64) ((st32) ((Rss >> 0x0) & 0xffffffff))))) * sextract64(((ut64) ((st16) ((Rtt >> 0x0) & ((st64) 0xffff)))), 0x0, 0x10) << 0x1) + ((st64) 0x8000) >> 0x10) < ((st64) 0x0)) ? (-(0x1 << 0x1f)) : (0x1 << 0x1f) - ((st64) 0x1)));
	RzILOpPure *op_RSHIFT_240 = SHIFTRA(READ_REG(pkt, Rxx_op, false), SN(32, 0));
	RzILOpPure *op_AND_242 = LOGAND(op_RSHIFT_240, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_248 = SHIFTRA(DUP(Rss), SN(32, 0));
	RzILOpPure *op_AND_250 = LOGAND(op_RSHIFT_248, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_261 = SHIFTRA(DUP(Rtt), SN(32, 0));
	RzILOpPure *op_AND_264 = LOGAND(op_RSHIFT_261, CAST(64, MSB(SN(32, 0xffff)), SN(32, 0xffff)));
	RzILOpPure *op_MUL_271 = MUL(CAST(64, MSB(CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(op_AND_250), DUP(op_AND_250))), CAST(32, MSB(DUP(op_AND_250)), DUP(op_AND_250)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_250)), DUP(op_AND_250))), CAST(32, MSB(DUP(op_AND_250)), DUP(op_AND_250))))), CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(DUP(op_AND_250)), DUP(op_AND_250))), CAST(32, MSB(DUP(op_AND_250)), DUP(op_AND_250)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_250)), DUP(op_AND_250))), CAST(32, MSB(DUP(op_AND_250)), DUP(op_AND_250))))), SEXTRACT64(CAST(64, IL_FALSE, CAST(16, MSB(op_AND_264), DUP(op_AND_264))), SN(32, 0), SN(32, 16)));
	RzILOpPure *op_LSHIFT_273 = SHIFTL0(op_MUL_271, SN(32, 1));
	RzILOpPure *op_ADD_276 = ADD(op_LSHIFT_273, CAST(64, MSB(SN(32, 0x8000)), SN(32, 0x8000)));
	RzILOpPure *op_RSHIFT_278 = SHIFTRA(op_ADD_276, SN(32, 16));
	RzILOpPure *op_ADD_279 = ADD(CAST(64, MSB(CAST(32, MSB(op_AND_242), DUP(op_AND_242))), CAST(32, MSB(DUP(op_AND_242)), DUP(op_AND_242))), op_RSHIFT_278);
	RzILOpPure *op_RSHIFT_288 = SHIFTRA(READ_REG(pkt, Rxx_op, false), SN(32, 0));
	RzILOpPure *op_AND_290 = LOGAND(op_RSHIFT_288, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_296 = SHIFTRA(DUP(Rss), SN(32, 0));
	RzILOpPure *op_AND_298 = LOGAND(op_RSHIFT_296, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_309 = SHIFTRA(DUP(Rtt), SN(32, 0));
	RzILOpPure *op_AND_312 = LOGAND(op_RSHIFT_309, CAST(64, MSB(SN(32, 0xffff)), SN(32, 0xffff)));
	RzILOpPure *op_MUL_319 = MUL(CAST(64, MSB(CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(op_AND_298), DUP(op_AND_298))), CAST(32, MSB(DUP(op_AND_298)), DUP(op_AND_298)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_298)), DUP(op_AND_298))), CAST(32, MSB(DUP(op_AND_298)), DUP(op_AND_298))))), CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(DUP(op_AND_298)), DUP(op_AND_298))), CAST(32, MSB(DUP(op_AND_298)), DUP(op_AND_298)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_298)), DUP(op_AND_298))), CAST(32, MSB(DUP(op_AND_298)), DUP(op_AND_298))))), SEXTRACT64(CAST(64, IL_FALSE, CAST(16, MSB(op_AND_312), DUP(op_AND_312))), SN(32, 0), SN(32, 16)));
	RzILOpPure *op_LSHIFT_321 = SHIFTL0(op_MUL_319, SN(32, 1));
	RzILOpPure *op_ADD_324 = ADD(op_LSHIFT_321, CAST(64, MSB(SN(32, 0x8000)), SN(32, 0x8000)));
	RzILOpPure *op_RSHIFT_326 = SHIFTRA(op_ADD_324, SN(32, 16));
	RzILOpPure *op_ADD_327 = ADD(CAST(64, MSB(CAST(32, MSB(op_AND_290), DUP(op_AND_290))), CAST(32, MSB(DUP(op_AND_290)), DUP(op_AND_290))), op_RSHIFT_326);
	RzILOpPure *op_EQ_328 = EQ(SEXTRACT64(CAST(64, IL_FALSE, op_ADD_279), SN(32, 0), SN(32, 0x20)), op_ADD_327);
	RzILOpPure *op_RSHIFT_378 = SHIFTRA(READ_REG(pkt, Rxx_op, false), SN(32, 0));
	RzILOpPure *op_AND_380 = LOGAND(op_RSHIFT_378, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_386 = SHIFTRA(DUP(Rss), SN(32, 0));
	RzILOpPure *op_AND_388 = LOGAND(op_RSHIFT_386, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_399 = SHIFTRA(DUP(Rtt), SN(32, 0));
	RzILOpPure *op_AND_402 = LOGAND(op_RSHIFT_399, CAST(64, MSB(SN(32, 0xffff)), SN(32, 0xffff)));
	RzILOpPure *op_MUL_409 = MUL(CAST(64, MSB(CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(op_AND_388), DUP(op_AND_388))), CAST(32, MSB(DUP(op_AND_388)), DUP(op_AND_388)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_388)), DUP(op_AND_388))), CAST(32, MSB(DUP(op_AND_388)), DUP(op_AND_388))))), CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(DUP(op_AND_388)), DUP(op_AND_388))), CAST(32, MSB(DUP(op_AND_388)), DUP(op_AND_388)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_388)), DUP(op_AND_388))), CAST(32, MSB(DUP(op_AND_388)), DUP(op_AND_388))))), SEXTRACT64(CAST(64, IL_FALSE, CAST(16, MSB(op_AND_402), DUP(op_AND_402))), SN(32, 0), SN(32, 16)));
	RzILOpPure *op_LSHIFT_411 = SHIFTL0(op_MUL_409, SN(32, 1));
	RzILOpPure *op_ADD_414 = ADD(op_LSHIFT_411, CAST(64, MSB(SN(32, 0x8000)), SN(32, 0x8000)));
	RzILOpPure *op_RSHIFT_416 = SHIFTRA(op_ADD_414, SN(32, 16));
	RzILOpPure *op_ADD_417 = ADD(CAST(64, MSB(CAST(32, MSB(op_AND_380), DUP(op_AND_380))), CAST(32, MSB(DUP(op_AND_380)), DUP(op_AND_380))), op_RSHIFT_416);
	RzILOpPure *op_LT_420 = SLT(op_ADD_417, CAST(64, MSB(SN(32, 0)), SN(32, 0)));
	RzILOpPure *op_LSHIFT_425 = SHIFTL0(SN(64, 1), SN(32, 31));
	RzILOpPure *op_NEG_426 = NEG(op_LSHIFT_425);
	RzILOpPure *op_LSHIFT_431 = SHIFTL0(SN(64, 1), SN(32, 31));
	RzILOpPure *op_SUB_434 = SUB(op_LSHIFT_431, CAST(64, MSB(SN(32, 1)), SN(32, 1)));
	RzILOpPure *cond_435 = ITE(op_LT_420, op_NEG_426, op_SUB_434);
	RzILOpEffect *gcc_expr_436 = BRANCH(op_EQ_328, EMPTY(), set_usr_field_call_374);

	// h_tmp279 = HYB(gcc_expr_if ((sextract64(((ut64) ((st64) ((st32) ((Rxx >> 0x0) & 0xffffffff))) + ((((st64) ((st32) ((st64) ((st32) ((Rss >> 0x0) & 0xffffffff))))) * sextract64(((ut64) ((st16) ((Rtt >> 0x0) & ((st64) 0xffff)))), 0x0, 0x10) << 0x1) + ((st64) 0x8000) >> 0x10)), 0x0, 0x20) == ((st64) ((st32) ((Rxx >> 0x0) & 0xffffffff))) + ((((st64) ((st32) ((st64) ((st32) ((Rss >> 0x0) & 0xffffffff))))) * sextract64(((ut64) ((st16) ((Rtt >> 0x0) & ((st64) 0xffff)))), 0x0, 0x10) << 0x1) + ((st64) 0x8000) >> 0x10))) {{}} else {set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, ((ut32) 0x1))}, ((((st64) ((st32) ((Rxx >> 0x0) & 0xffffffff))) + ((((st64) ((st32) ((st64) ((st32) ((Rss >> 0x0) & 0xffffffff))))) * sextract64(((ut64) ((st16) ((Rtt >> 0x0) & ((st64) 0xffff)))), 0x0, 0x10) << 0x1) + ((st64) 0x8000) >> 0x10) < ((st64) 0x0)) ? (-(0x1 << 0x1f)) : (0x1 << 0x1f) - ((st64) 0x1)));
	RzILOpEffect *op_ASSIGN_hybrid_tmp_438 = SETL("h_tmp279", cond_435);

	// seq(HYB(gcc_expr_if ((sextract64(((ut64) ((st64) ((st32) ((Rxx > ...;
	RzILOpEffect *seq_439 = SEQN(2, gcc_expr_436, op_ASSIGN_hybrid_tmp_438);

	// Rxx = ((Rxx & (~(0xffffffff << 0x0))) | ((((sextract64(((ut64) ((st64) ((st32) ((Rxx >> 0x0) & 0xffffffff))) + ((((st64) ((st32) ((st64) ((st32) ((Rss >> 0x0) & 0xffffffff))))) * sextract64(((ut64) ((st16) ((Rtt >> 0x0) & ((st64) 0xffff)))), 0x0, 0x10) << 0x1) + ((st64) 0x8000) >> 0x10)), 0x0, 0x20) == ((st64) ((st32) ((Rxx >> 0x0) & 0xffffffff))) + ((((st64) ((st32) ((st64) ((st32) ((Rss >> 0x0) & 0xffffffff))))) * sextract64(((ut64) ((st16) ((Rtt >> 0x0) & ((st64) 0xffff)))), 0x0, 0x10) << 0x1) + ((st64) 0x8000) >> 0x10)) ? ((st64) ((st32) ((Rxx >> 0x0) & 0xffffffff))) + ((((st64) ((st32) ((st64) ((st32) ((Rss >> 0x0) & 0xffffffff))))) * sextract64(((ut64) ((st16) ((Rtt >> 0x0) & ((st64) 0xffff)))), 0x0, 0x10) << 0x1) + ((st64) 0x8000) >> 0x10) : h_tmp279) & 0xffffffff) << 0x0));
	RzILOpPure *op_LSHIFT_231 = SHIFTL0(SN(64, 0xffffffff), SN(32, 0));
	RzILOpPure *op_NOT_232 = LOGNOT(op_LSHIFT_231);
	RzILOpPure *op_AND_233 = LOGAND(READ_REG(pkt, Rxx_op, false), op_NOT_232);
	RzILOpPure *op_RSHIFT_332 = SHIFTRA(READ_REG(pkt, Rxx_op, false), SN(32, 0));
	RzILOpPure *op_AND_334 = LOGAND(op_RSHIFT_332, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_340 = SHIFTRA(DUP(Rss), SN(32, 0));
	RzILOpPure *op_AND_342 = LOGAND(op_RSHIFT_340, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_353 = SHIFTRA(DUP(Rtt), SN(32, 0));
	RzILOpPure *op_AND_356 = LOGAND(op_RSHIFT_353, CAST(64, MSB(SN(32, 0xffff)), SN(32, 0xffff)));
	RzILOpPure *op_MUL_363 = MUL(CAST(64, MSB(CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(op_AND_342), DUP(op_AND_342))), CAST(32, MSB(DUP(op_AND_342)), DUP(op_AND_342)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_342)), DUP(op_AND_342))), CAST(32, MSB(DUP(op_AND_342)), DUP(op_AND_342))))), CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(DUP(op_AND_342)), DUP(op_AND_342))), CAST(32, MSB(DUP(op_AND_342)), DUP(op_AND_342)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_342)), DUP(op_AND_342))), CAST(32, MSB(DUP(op_AND_342)), DUP(op_AND_342))))), SEXTRACT64(CAST(64, IL_FALSE, CAST(16, MSB(op_AND_356), DUP(op_AND_356))), SN(32, 0), SN(32, 16)));
	RzILOpPure *op_LSHIFT_365 = SHIFTL0(op_MUL_363, SN(32, 1));
	RzILOpPure *op_ADD_368 = ADD(op_LSHIFT_365, CAST(64, MSB(SN(32, 0x8000)), SN(32, 0x8000)));
	RzILOpPure *op_RSHIFT_370 = SHIFTRA(op_ADD_368, SN(32, 16));
	RzILOpPure *op_ADD_371 = ADD(CAST(64, MSB(CAST(32, MSB(op_AND_334), DUP(op_AND_334))), CAST(32, MSB(DUP(op_AND_334)), DUP(op_AND_334))), op_RSHIFT_370);
	RzILOpPure *cond_440 = ITE(DUP(op_EQ_328), op_ADD_371, VARL("h_tmp279"));
	RzILOpPure *op_AND_442 = LOGAND(cond_440, SN(64, 0xffffffff));
	RzILOpPure *op_LSHIFT_446 = SHIFTL0(op_AND_442, SN(32, 0));
	RzILOpPure *op_OR_447 = LOGOR(op_AND_233, op_LSHIFT_446);
	RzILOpEffect *op_ASSIGN_448 = WRITE_REG(bundle, Rxx_op, op_OR_447);

	// seq(seq(HYB(gcc_expr_if ((sextract64(((ut64) ((st64) ((st32) ((R ...;
	RzILOpEffect *seq_449 = SEQN(2, seq_439, op_ASSIGN_448);

	RzILOpEffect *instruction_sequence = SEQN(2, seq_225, seq_449);
	return instruction_sequence;
}

// Rxx += vmpyweh(Rss,Rtt):sat
RzILOpEffect *hex_il_op_m2_mmacls_s0(HexInsnPktBundle *bundle) {
	const HexInsn *hi = bundle->insn;
	HexPkt *pkt = bundle->pkt;
	// READ
	const HexOp *Rxx_op = ISA2REG(hi, 'x', false);

	const HexOp *Rss_op = ISA2REG(hi, 's', false);
	RzILOpPure *Rss = READ_REG(pkt, Rss_op, false);
	const HexOp *Rtt_op = ISA2REG(hi, 't', false);
	RzILOpPure *Rtt = READ_REG(pkt, Rtt_op, false);

	// set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, ((ut32) 0x1));
	RzILOpEffect *set_usr_field_call_141 = hex_set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, CAST(32, IL_FALSE, SN(32, 1)));

	// HYB(gcc_expr_if ((sextract64(((ut64) ((st64) ((st32) ((Rxx >> 0x20) & 0xffffffff))) + ((((st64) ((st32) ((st64) ((st32) ((Rss >> 0x20) & 0xffffffff))))) * sextract64(((ut64) ((st16) ((Rtt >> 0x20) & ((st64) 0xffff)))), 0x0, 0x10) << 0x0) >> 0x10)), 0x0, 0x20) == ((st64) ((st32) ((Rxx >> 0x20) & 0xffffffff))) + ((((st64) ((st32) ((st64) ((st32) ((Rss >> 0x20) & 0xffffffff))))) * sextract64(((ut64) ((st16) ((Rtt >> 0x20) & ((st64) 0xffff)))), 0x0, 0x10) << 0x0) >> 0x10))) {{}} else {set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, ((ut32) 0x1))}, ((((st64) ((st32) ((Rxx >> 0x20) & 0xffffffff))) + ((((st64) ((st32) ((st64) ((st32) ((Rss >> 0x20) & 0xffffffff))))) * sextract64(((ut64) ((st16) ((Rtt >> 0x20) & ((st64) 0xffff)))), 0x0, 0x10) << 0x0) >> 0x10) < ((st64) 0x0)) ? (-(0x1 << 0x1f)) : (0x1 << 0x1f) - ((st64) 0x1)));
	RzILOpPure *op_RSHIFT_14 = SHIFTRA(READ_REG(pkt, Rxx_op, false), SN(32, 0x20));
	RzILOpPure *op_AND_16 = LOGAND(op_RSHIFT_14, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_23 = SHIFTRA(Rss, SN(32, 0x20));
	RzILOpPure *op_AND_25 = LOGAND(op_RSHIFT_23, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_37 = SHIFTRA(Rtt, SN(32, 0x20));
	RzILOpPure *op_AND_40 = LOGAND(op_RSHIFT_37, CAST(64, MSB(SN(32, 0xffff)), SN(32, 0xffff)));
	RzILOpPure *op_MUL_47 = MUL(CAST(64, MSB(CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(op_AND_25), DUP(op_AND_25))), CAST(32, MSB(DUP(op_AND_25)), DUP(op_AND_25)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_25)), DUP(op_AND_25))), CAST(32, MSB(DUP(op_AND_25)), DUP(op_AND_25))))), CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(DUP(op_AND_25)), DUP(op_AND_25))), CAST(32, MSB(DUP(op_AND_25)), DUP(op_AND_25)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_25)), DUP(op_AND_25))), CAST(32, MSB(DUP(op_AND_25)), DUP(op_AND_25))))), SEXTRACT64(CAST(64, IL_FALSE, CAST(16, MSB(op_AND_40), DUP(op_AND_40))), SN(32, 0), SN(32, 16)));
	RzILOpPure *op_LSHIFT_49 = SHIFTL0(op_MUL_47, SN(32, 0));
	RzILOpPure *op_RSHIFT_51 = SHIFTRA(op_LSHIFT_49, SN(32, 16));
	RzILOpPure *op_ADD_52 = ADD(CAST(64, MSB(CAST(32, MSB(op_AND_16), DUP(op_AND_16))), CAST(32, MSB(DUP(op_AND_16)), DUP(op_AND_16))), op_RSHIFT_51);
	RzILOpPure *op_RSHIFT_61 = SHIFTRA(READ_REG(pkt, Rxx_op, false), SN(32, 0x20));
	RzILOpPure *op_AND_63 = LOGAND(op_RSHIFT_61, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_69 = SHIFTRA(DUP(Rss), SN(32, 0x20));
	RzILOpPure *op_AND_71 = LOGAND(op_RSHIFT_69, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_82 = SHIFTRA(DUP(Rtt), SN(32, 0x20));
	RzILOpPure *op_AND_85 = LOGAND(op_RSHIFT_82, CAST(64, MSB(SN(32, 0xffff)), SN(32, 0xffff)));
	RzILOpPure *op_MUL_92 = MUL(CAST(64, MSB(CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(op_AND_71), DUP(op_AND_71))), CAST(32, MSB(DUP(op_AND_71)), DUP(op_AND_71)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_71)), DUP(op_AND_71))), CAST(32, MSB(DUP(op_AND_71)), DUP(op_AND_71))))), CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(DUP(op_AND_71)), DUP(op_AND_71))), CAST(32, MSB(DUP(op_AND_71)), DUP(op_AND_71)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_71)), DUP(op_AND_71))), CAST(32, MSB(DUP(op_AND_71)), DUP(op_AND_71))))), SEXTRACT64(CAST(64, IL_FALSE, CAST(16, MSB(op_AND_85), DUP(op_AND_85))), SN(32, 0), SN(32, 16)));
	RzILOpPure *op_LSHIFT_94 = SHIFTL0(op_MUL_92, SN(32, 0));
	RzILOpPure *op_RSHIFT_96 = SHIFTRA(op_LSHIFT_94, SN(32, 16));
	RzILOpPure *op_ADD_97 = ADD(CAST(64, MSB(CAST(32, MSB(op_AND_63), DUP(op_AND_63))), CAST(32, MSB(DUP(op_AND_63)), DUP(op_AND_63))), op_RSHIFT_96);
	RzILOpPure *op_EQ_98 = EQ(SEXTRACT64(CAST(64, IL_FALSE, op_ADD_52), SN(32, 0), SN(32, 0x20)), op_ADD_97);
	RzILOpPure *op_RSHIFT_145 = SHIFTRA(READ_REG(pkt, Rxx_op, false), SN(32, 0x20));
	RzILOpPure *op_AND_147 = LOGAND(op_RSHIFT_145, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_153 = SHIFTRA(DUP(Rss), SN(32, 0x20));
	RzILOpPure *op_AND_155 = LOGAND(op_RSHIFT_153, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_166 = SHIFTRA(DUP(Rtt), SN(32, 0x20));
	RzILOpPure *op_AND_169 = LOGAND(op_RSHIFT_166, CAST(64, MSB(SN(32, 0xffff)), SN(32, 0xffff)));
	RzILOpPure *op_MUL_176 = MUL(CAST(64, MSB(CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(op_AND_155), DUP(op_AND_155))), CAST(32, MSB(DUP(op_AND_155)), DUP(op_AND_155)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_155)), DUP(op_AND_155))), CAST(32, MSB(DUP(op_AND_155)), DUP(op_AND_155))))), CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(DUP(op_AND_155)), DUP(op_AND_155))), CAST(32, MSB(DUP(op_AND_155)), DUP(op_AND_155)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_155)), DUP(op_AND_155))), CAST(32, MSB(DUP(op_AND_155)), DUP(op_AND_155))))), SEXTRACT64(CAST(64, IL_FALSE, CAST(16, MSB(op_AND_169), DUP(op_AND_169))), SN(32, 0), SN(32, 16)));
	RzILOpPure *op_LSHIFT_178 = SHIFTL0(op_MUL_176, SN(32, 0));
	RzILOpPure *op_RSHIFT_180 = SHIFTRA(op_LSHIFT_178, SN(32, 16));
	RzILOpPure *op_ADD_181 = ADD(CAST(64, MSB(CAST(32, MSB(op_AND_147), DUP(op_AND_147))), CAST(32, MSB(DUP(op_AND_147)), DUP(op_AND_147))), op_RSHIFT_180);
	RzILOpPure *op_LT_184 = SLT(op_ADD_181, CAST(64, MSB(SN(32, 0)), SN(32, 0)));
	RzILOpPure *op_LSHIFT_189 = SHIFTL0(SN(64, 1), SN(32, 31));
	RzILOpPure *op_NEG_190 = NEG(op_LSHIFT_189);
	RzILOpPure *op_LSHIFT_195 = SHIFTL0(SN(64, 1), SN(32, 31));
	RzILOpPure *op_SUB_198 = SUB(op_LSHIFT_195, CAST(64, MSB(SN(32, 1)), SN(32, 1)));
	RzILOpPure *cond_199 = ITE(op_LT_184, op_NEG_190, op_SUB_198);
	RzILOpEffect *gcc_expr_200 = BRANCH(op_EQ_98, EMPTY(), set_usr_field_call_141);

	// h_tmp280 = HYB(gcc_expr_if ((sextract64(((ut64) ((st64) ((st32) ((Rxx >> 0x20) & 0xffffffff))) + ((((st64) ((st32) ((st64) ((st32) ((Rss >> 0x20) & 0xffffffff))))) * sextract64(((ut64) ((st16) ((Rtt >> 0x20) & ((st64) 0xffff)))), 0x0, 0x10) << 0x0) >> 0x10)), 0x0, 0x20) == ((st64) ((st32) ((Rxx >> 0x20) & 0xffffffff))) + ((((st64) ((st32) ((st64) ((st32) ((Rss >> 0x20) & 0xffffffff))))) * sextract64(((ut64) ((st16) ((Rtt >> 0x20) & ((st64) 0xffff)))), 0x0, 0x10) << 0x0) >> 0x10))) {{}} else {set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, ((ut32) 0x1))}, ((((st64) ((st32) ((Rxx >> 0x20) & 0xffffffff))) + ((((st64) ((st32) ((st64) ((st32) ((Rss >> 0x20) & 0xffffffff))))) * sextract64(((ut64) ((st16) ((Rtt >> 0x20) & ((st64) 0xffff)))), 0x0, 0x10) << 0x0) >> 0x10) < ((st64) 0x0)) ? (-(0x1 << 0x1f)) : (0x1 << 0x1f) - ((st64) 0x1)));
	RzILOpEffect *op_ASSIGN_hybrid_tmp_202 = SETL("h_tmp280", cond_199);

	// seq(HYB(gcc_expr_if ((sextract64(((ut64) ((st64) ((st32) ((Rxx > ...;
	RzILOpEffect *seq_203 = SEQN(2, gcc_expr_200, op_ASSIGN_hybrid_tmp_202);

	// Rxx = ((Rxx & (~(0xffffffff << 0x20))) | ((((sextract64(((ut64) ((st64) ((st32) ((Rxx >> 0x20) & 0xffffffff))) + ((((st64) ((st32) ((st64) ((st32) ((Rss >> 0x20) & 0xffffffff))))) * sextract64(((ut64) ((st16) ((Rtt >> 0x20) & ((st64) 0xffff)))), 0x0, 0x10) << 0x0) >> 0x10)), 0x0, 0x20) == ((st64) ((st32) ((Rxx >> 0x20) & 0xffffffff))) + ((((st64) ((st32) ((st64) ((st32) ((Rss >> 0x20) & 0xffffffff))))) * sextract64(((ut64) ((st16) ((Rtt >> 0x20) & ((st64) 0xffff)))), 0x0, 0x10) << 0x0) >> 0x10)) ? ((st64) ((st32) ((Rxx >> 0x20) & 0xffffffff))) + ((((st64) ((st32) ((st64) ((st32) ((Rss >> 0x20) & 0xffffffff))))) * sextract64(((ut64) ((st16) ((Rtt >> 0x20) & ((st64) 0xffff)))), 0x0, 0x10) << 0x0) >> 0x10) : h_tmp280) & 0xffffffff) << 0x20));
	RzILOpPure *op_LSHIFT_5 = SHIFTL0(SN(64, 0xffffffff), SN(32, 0x20));
	RzILOpPure *op_NOT_6 = LOGNOT(op_LSHIFT_5);
	RzILOpPure *op_AND_7 = LOGAND(READ_REG(pkt, Rxx_op, false), op_NOT_6);
	RzILOpPure *op_RSHIFT_102 = SHIFTRA(READ_REG(pkt, Rxx_op, false), SN(32, 0x20));
	RzILOpPure *op_AND_104 = LOGAND(op_RSHIFT_102, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_110 = SHIFTRA(DUP(Rss), SN(32, 0x20));
	RzILOpPure *op_AND_112 = LOGAND(op_RSHIFT_110, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_123 = SHIFTRA(DUP(Rtt), SN(32, 0x20));
	RzILOpPure *op_AND_126 = LOGAND(op_RSHIFT_123, CAST(64, MSB(SN(32, 0xffff)), SN(32, 0xffff)));
	RzILOpPure *op_MUL_133 = MUL(CAST(64, MSB(CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(op_AND_112), DUP(op_AND_112))), CAST(32, MSB(DUP(op_AND_112)), DUP(op_AND_112)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_112)), DUP(op_AND_112))), CAST(32, MSB(DUP(op_AND_112)), DUP(op_AND_112))))), CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(DUP(op_AND_112)), DUP(op_AND_112))), CAST(32, MSB(DUP(op_AND_112)), DUP(op_AND_112)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_112)), DUP(op_AND_112))), CAST(32, MSB(DUP(op_AND_112)), DUP(op_AND_112))))), SEXTRACT64(CAST(64, IL_FALSE, CAST(16, MSB(op_AND_126), DUP(op_AND_126))), SN(32, 0), SN(32, 16)));
	RzILOpPure *op_LSHIFT_135 = SHIFTL0(op_MUL_133, SN(32, 0));
	RzILOpPure *op_RSHIFT_137 = SHIFTRA(op_LSHIFT_135, SN(32, 16));
	RzILOpPure *op_ADD_138 = ADD(CAST(64, MSB(CAST(32, MSB(op_AND_104), DUP(op_AND_104))), CAST(32, MSB(DUP(op_AND_104)), DUP(op_AND_104))), op_RSHIFT_137);
	RzILOpPure *cond_204 = ITE(DUP(op_EQ_98), op_ADD_138, VARL("h_tmp280"));
	RzILOpPure *op_AND_206 = LOGAND(cond_204, SN(64, 0xffffffff));
	RzILOpPure *op_LSHIFT_210 = SHIFTL0(op_AND_206, SN(32, 0x20));
	RzILOpPure *op_OR_211 = LOGOR(op_AND_7, op_LSHIFT_210);
	RzILOpEffect *op_ASSIGN_212 = WRITE_REG(bundle, Rxx_op, op_OR_211);

	// seq(seq(HYB(gcc_expr_if ((sextract64(((ut64) ((st64) ((st32) ((R ...;
	RzILOpEffect *seq_213 = SEQN(2, seq_203, op_ASSIGN_212);

	// set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, ((ut32) 0x1));
	RzILOpEffect *set_usr_field_call_353 = hex_set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, CAST(32, IL_FALSE, SN(32, 1)));

	// HYB(gcc_expr_if ((sextract64(((ut64) ((st64) ((st32) ((Rxx >> 0x0) & 0xffffffff))) + ((((st64) ((st32) ((st64) ((st32) ((Rss >> 0x0) & 0xffffffff))))) * sextract64(((ut64) ((st16) ((Rtt >> 0x0) & ((st64) 0xffff)))), 0x0, 0x10) << 0x0) >> 0x10)), 0x0, 0x20) == ((st64) ((st32) ((Rxx >> 0x0) & 0xffffffff))) + ((((st64) ((st32) ((st64) ((st32) ((Rss >> 0x0) & 0xffffffff))))) * sextract64(((ut64) ((st16) ((Rtt >> 0x0) & ((st64) 0xffff)))), 0x0, 0x10) << 0x0) >> 0x10))) {{}} else {set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, ((ut32) 0x1))}, ((((st64) ((st32) ((Rxx >> 0x0) & 0xffffffff))) + ((((st64) ((st32) ((st64) ((st32) ((Rss >> 0x0) & 0xffffffff))))) * sextract64(((ut64) ((st16) ((Rtt >> 0x0) & ((st64) 0xffff)))), 0x0, 0x10) << 0x0) >> 0x10) < ((st64) 0x0)) ? (-(0x1 << 0x1f)) : (0x1 << 0x1f) - ((st64) 0x1)));
	RzILOpPure *op_RSHIFT_228 = SHIFTRA(READ_REG(pkt, Rxx_op, false), SN(32, 0));
	RzILOpPure *op_AND_230 = LOGAND(op_RSHIFT_228, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_236 = SHIFTRA(DUP(Rss), SN(32, 0));
	RzILOpPure *op_AND_238 = LOGAND(op_RSHIFT_236, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_249 = SHIFTRA(DUP(Rtt), SN(32, 0));
	RzILOpPure *op_AND_252 = LOGAND(op_RSHIFT_249, CAST(64, MSB(SN(32, 0xffff)), SN(32, 0xffff)));
	RzILOpPure *op_MUL_259 = MUL(CAST(64, MSB(CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(op_AND_238), DUP(op_AND_238))), CAST(32, MSB(DUP(op_AND_238)), DUP(op_AND_238)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_238)), DUP(op_AND_238))), CAST(32, MSB(DUP(op_AND_238)), DUP(op_AND_238))))), CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(DUP(op_AND_238)), DUP(op_AND_238))), CAST(32, MSB(DUP(op_AND_238)), DUP(op_AND_238)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_238)), DUP(op_AND_238))), CAST(32, MSB(DUP(op_AND_238)), DUP(op_AND_238))))), SEXTRACT64(CAST(64, IL_FALSE, CAST(16, MSB(op_AND_252), DUP(op_AND_252))), SN(32, 0), SN(32, 16)));
	RzILOpPure *op_LSHIFT_261 = SHIFTL0(op_MUL_259, SN(32, 0));
	RzILOpPure *op_RSHIFT_263 = SHIFTRA(op_LSHIFT_261, SN(32, 16));
	RzILOpPure *op_ADD_264 = ADD(CAST(64, MSB(CAST(32, MSB(op_AND_230), DUP(op_AND_230))), CAST(32, MSB(DUP(op_AND_230)), DUP(op_AND_230))), op_RSHIFT_263);
	RzILOpPure *op_RSHIFT_273 = SHIFTRA(READ_REG(pkt, Rxx_op, false), SN(32, 0));
	RzILOpPure *op_AND_275 = LOGAND(op_RSHIFT_273, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_281 = SHIFTRA(DUP(Rss), SN(32, 0));
	RzILOpPure *op_AND_283 = LOGAND(op_RSHIFT_281, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_294 = SHIFTRA(DUP(Rtt), SN(32, 0));
	RzILOpPure *op_AND_297 = LOGAND(op_RSHIFT_294, CAST(64, MSB(SN(32, 0xffff)), SN(32, 0xffff)));
	RzILOpPure *op_MUL_304 = MUL(CAST(64, MSB(CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(op_AND_283), DUP(op_AND_283))), CAST(32, MSB(DUP(op_AND_283)), DUP(op_AND_283)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_283)), DUP(op_AND_283))), CAST(32, MSB(DUP(op_AND_283)), DUP(op_AND_283))))), CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(DUP(op_AND_283)), DUP(op_AND_283))), CAST(32, MSB(DUP(op_AND_283)), DUP(op_AND_283)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_283)), DUP(op_AND_283))), CAST(32, MSB(DUP(op_AND_283)), DUP(op_AND_283))))), SEXTRACT64(CAST(64, IL_FALSE, CAST(16, MSB(op_AND_297), DUP(op_AND_297))), SN(32, 0), SN(32, 16)));
	RzILOpPure *op_LSHIFT_306 = SHIFTL0(op_MUL_304, SN(32, 0));
	RzILOpPure *op_RSHIFT_308 = SHIFTRA(op_LSHIFT_306, SN(32, 16));
	RzILOpPure *op_ADD_309 = ADD(CAST(64, MSB(CAST(32, MSB(op_AND_275), DUP(op_AND_275))), CAST(32, MSB(DUP(op_AND_275)), DUP(op_AND_275))), op_RSHIFT_308);
	RzILOpPure *op_EQ_310 = EQ(SEXTRACT64(CAST(64, IL_FALSE, op_ADD_264), SN(32, 0), SN(32, 0x20)), op_ADD_309);
	RzILOpPure *op_RSHIFT_357 = SHIFTRA(READ_REG(pkt, Rxx_op, false), SN(32, 0));
	RzILOpPure *op_AND_359 = LOGAND(op_RSHIFT_357, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_365 = SHIFTRA(DUP(Rss), SN(32, 0));
	RzILOpPure *op_AND_367 = LOGAND(op_RSHIFT_365, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_378 = SHIFTRA(DUP(Rtt), SN(32, 0));
	RzILOpPure *op_AND_381 = LOGAND(op_RSHIFT_378, CAST(64, MSB(SN(32, 0xffff)), SN(32, 0xffff)));
	RzILOpPure *op_MUL_388 = MUL(CAST(64, MSB(CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(op_AND_367), DUP(op_AND_367))), CAST(32, MSB(DUP(op_AND_367)), DUP(op_AND_367)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_367)), DUP(op_AND_367))), CAST(32, MSB(DUP(op_AND_367)), DUP(op_AND_367))))), CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(DUP(op_AND_367)), DUP(op_AND_367))), CAST(32, MSB(DUP(op_AND_367)), DUP(op_AND_367)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_367)), DUP(op_AND_367))), CAST(32, MSB(DUP(op_AND_367)), DUP(op_AND_367))))), SEXTRACT64(CAST(64, IL_FALSE, CAST(16, MSB(op_AND_381), DUP(op_AND_381))), SN(32, 0), SN(32, 16)));
	RzILOpPure *op_LSHIFT_390 = SHIFTL0(op_MUL_388, SN(32, 0));
	RzILOpPure *op_RSHIFT_392 = SHIFTRA(op_LSHIFT_390, SN(32, 16));
	RzILOpPure *op_ADD_393 = ADD(CAST(64, MSB(CAST(32, MSB(op_AND_359), DUP(op_AND_359))), CAST(32, MSB(DUP(op_AND_359)), DUP(op_AND_359))), op_RSHIFT_392);
	RzILOpPure *op_LT_396 = SLT(op_ADD_393, CAST(64, MSB(SN(32, 0)), SN(32, 0)));
	RzILOpPure *op_LSHIFT_401 = SHIFTL0(SN(64, 1), SN(32, 31));
	RzILOpPure *op_NEG_402 = NEG(op_LSHIFT_401);
	RzILOpPure *op_LSHIFT_407 = SHIFTL0(SN(64, 1), SN(32, 31));
	RzILOpPure *op_SUB_410 = SUB(op_LSHIFT_407, CAST(64, MSB(SN(32, 1)), SN(32, 1)));
	RzILOpPure *cond_411 = ITE(op_LT_396, op_NEG_402, op_SUB_410);
	RzILOpEffect *gcc_expr_412 = BRANCH(op_EQ_310, EMPTY(), set_usr_field_call_353);

	// h_tmp281 = HYB(gcc_expr_if ((sextract64(((ut64) ((st64) ((st32) ((Rxx >> 0x0) & 0xffffffff))) + ((((st64) ((st32) ((st64) ((st32) ((Rss >> 0x0) & 0xffffffff))))) * sextract64(((ut64) ((st16) ((Rtt >> 0x0) & ((st64) 0xffff)))), 0x0, 0x10) << 0x0) >> 0x10)), 0x0, 0x20) == ((st64) ((st32) ((Rxx >> 0x0) & 0xffffffff))) + ((((st64) ((st32) ((st64) ((st32) ((Rss >> 0x0) & 0xffffffff))))) * sextract64(((ut64) ((st16) ((Rtt >> 0x0) & ((st64) 0xffff)))), 0x0, 0x10) << 0x0) >> 0x10))) {{}} else {set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, ((ut32) 0x1))}, ((((st64) ((st32) ((Rxx >> 0x0) & 0xffffffff))) + ((((st64) ((st32) ((st64) ((st32) ((Rss >> 0x0) & 0xffffffff))))) * sextract64(((ut64) ((st16) ((Rtt >> 0x0) & ((st64) 0xffff)))), 0x0, 0x10) << 0x0) >> 0x10) < ((st64) 0x0)) ? (-(0x1 << 0x1f)) : (0x1 << 0x1f) - ((st64) 0x1)));
	RzILOpEffect *op_ASSIGN_hybrid_tmp_414 = SETL("h_tmp281", cond_411);

	// seq(HYB(gcc_expr_if ((sextract64(((ut64) ((st64) ((st32) ((Rxx > ...;
	RzILOpEffect *seq_415 = SEQN(2, gcc_expr_412, op_ASSIGN_hybrid_tmp_414);

	// Rxx = ((Rxx & (~(0xffffffff << 0x0))) | ((((sextract64(((ut64) ((st64) ((st32) ((Rxx >> 0x0) & 0xffffffff))) + ((((st64) ((st32) ((st64) ((st32) ((Rss >> 0x0) & 0xffffffff))))) * sextract64(((ut64) ((st16) ((Rtt >> 0x0) & ((st64) 0xffff)))), 0x0, 0x10) << 0x0) >> 0x10)), 0x0, 0x20) == ((st64) ((st32) ((Rxx >> 0x0) & 0xffffffff))) + ((((st64) ((st32) ((st64) ((st32) ((Rss >> 0x0) & 0xffffffff))))) * sextract64(((ut64) ((st16) ((Rtt >> 0x0) & ((st64) 0xffff)))), 0x0, 0x10) << 0x0) >> 0x10)) ? ((st64) ((st32) ((Rxx >> 0x0) & 0xffffffff))) + ((((st64) ((st32) ((st64) ((st32) ((Rss >> 0x0) & 0xffffffff))))) * sextract64(((ut64) ((st16) ((Rtt >> 0x0) & ((st64) 0xffff)))), 0x0, 0x10) << 0x0) >> 0x10) : h_tmp281) & 0xffffffff) << 0x0));
	RzILOpPure *op_LSHIFT_219 = SHIFTL0(SN(64, 0xffffffff), SN(32, 0));
	RzILOpPure *op_NOT_220 = LOGNOT(op_LSHIFT_219);
	RzILOpPure *op_AND_221 = LOGAND(READ_REG(pkt, Rxx_op, false), op_NOT_220);
	RzILOpPure *op_RSHIFT_314 = SHIFTRA(READ_REG(pkt, Rxx_op, false), SN(32, 0));
	RzILOpPure *op_AND_316 = LOGAND(op_RSHIFT_314, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_322 = SHIFTRA(DUP(Rss), SN(32, 0));
	RzILOpPure *op_AND_324 = LOGAND(op_RSHIFT_322, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_335 = SHIFTRA(DUP(Rtt), SN(32, 0));
	RzILOpPure *op_AND_338 = LOGAND(op_RSHIFT_335, CAST(64, MSB(SN(32, 0xffff)), SN(32, 0xffff)));
	RzILOpPure *op_MUL_345 = MUL(CAST(64, MSB(CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(op_AND_324), DUP(op_AND_324))), CAST(32, MSB(DUP(op_AND_324)), DUP(op_AND_324)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_324)), DUP(op_AND_324))), CAST(32, MSB(DUP(op_AND_324)), DUP(op_AND_324))))), CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(DUP(op_AND_324)), DUP(op_AND_324))), CAST(32, MSB(DUP(op_AND_324)), DUP(op_AND_324)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_324)), DUP(op_AND_324))), CAST(32, MSB(DUP(op_AND_324)), DUP(op_AND_324))))), SEXTRACT64(CAST(64, IL_FALSE, CAST(16, MSB(op_AND_338), DUP(op_AND_338))), SN(32, 0), SN(32, 16)));
	RzILOpPure *op_LSHIFT_347 = SHIFTL0(op_MUL_345, SN(32, 0));
	RzILOpPure *op_RSHIFT_349 = SHIFTRA(op_LSHIFT_347, SN(32, 16));
	RzILOpPure *op_ADD_350 = ADD(CAST(64, MSB(CAST(32, MSB(op_AND_316), DUP(op_AND_316))), CAST(32, MSB(DUP(op_AND_316)), DUP(op_AND_316))), op_RSHIFT_349);
	RzILOpPure *cond_416 = ITE(DUP(op_EQ_310), op_ADD_350, VARL("h_tmp281"));
	RzILOpPure *op_AND_418 = LOGAND(cond_416, SN(64, 0xffffffff));
	RzILOpPure *op_LSHIFT_422 = SHIFTL0(op_AND_418, SN(32, 0));
	RzILOpPure *op_OR_423 = LOGOR(op_AND_221, op_LSHIFT_422);
	RzILOpEffect *op_ASSIGN_424 = WRITE_REG(bundle, Rxx_op, op_OR_423);

	// seq(seq(HYB(gcc_expr_if ((sextract64(((ut64) ((st64) ((st32) ((R ...;
	RzILOpEffect *seq_425 = SEQN(2, seq_415, op_ASSIGN_424);

	RzILOpEffect *instruction_sequence = SEQN(2, seq_213, seq_425);
	return instruction_sequence;
}

// Rxx += vmpyweh(Rss,Rtt):<<1:sat
RzILOpEffect *hex_il_op_m2_mmacls_s1(HexInsnPktBundle *bundle) {
	const HexInsn *hi = bundle->insn;
	HexPkt *pkt = bundle->pkt;
	// READ
	const HexOp *Rxx_op = ISA2REG(hi, 'x', false);

	const HexOp *Rss_op = ISA2REG(hi, 's', false);
	RzILOpPure *Rss = READ_REG(pkt, Rss_op, false);
	const HexOp *Rtt_op = ISA2REG(hi, 't', false);
	RzILOpPure *Rtt = READ_REG(pkt, Rtt_op, false);

	// set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, ((ut32) 0x1));
	RzILOpEffect *set_usr_field_call_141 = hex_set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, CAST(32, IL_FALSE, SN(32, 1)));

	// HYB(gcc_expr_if ((sextract64(((ut64) ((st64) ((st32) ((Rxx >> 0x20) & 0xffffffff))) + ((((st64) ((st32) ((st64) ((st32) ((Rss >> 0x20) & 0xffffffff))))) * sextract64(((ut64) ((st16) ((Rtt >> 0x20) & ((st64) 0xffff)))), 0x0, 0x10) << 0x1) >> 0x10)), 0x0, 0x20) == ((st64) ((st32) ((Rxx >> 0x20) & 0xffffffff))) + ((((st64) ((st32) ((st64) ((st32) ((Rss >> 0x20) & 0xffffffff))))) * sextract64(((ut64) ((st16) ((Rtt >> 0x20) & ((st64) 0xffff)))), 0x0, 0x10) << 0x1) >> 0x10))) {{}} else {set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, ((ut32) 0x1))}, ((((st64) ((st32) ((Rxx >> 0x20) & 0xffffffff))) + ((((st64) ((st32) ((st64) ((st32) ((Rss >> 0x20) & 0xffffffff))))) * sextract64(((ut64) ((st16) ((Rtt >> 0x20) & ((st64) 0xffff)))), 0x0, 0x10) << 0x1) >> 0x10) < ((st64) 0x0)) ? (-(0x1 << 0x1f)) : (0x1 << 0x1f) - ((st64) 0x1)));
	RzILOpPure *op_RSHIFT_14 = SHIFTRA(READ_REG(pkt, Rxx_op, false), SN(32, 0x20));
	RzILOpPure *op_AND_16 = LOGAND(op_RSHIFT_14, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_23 = SHIFTRA(Rss, SN(32, 0x20));
	RzILOpPure *op_AND_25 = LOGAND(op_RSHIFT_23, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_37 = SHIFTRA(Rtt, SN(32, 0x20));
	RzILOpPure *op_AND_40 = LOGAND(op_RSHIFT_37, CAST(64, MSB(SN(32, 0xffff)), SN(32, 0xffff)));
	RzILOpPure *op_MUL_47 = MUL(CAST(64, MSB(CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(op_AND_25), DUP(op_AND_25))), CAST(32, MSB(DUP(op_AND_25)), DUP(op_AND_25)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_25)), DUP(op_AND_25))), CAST(32, MSB(DUP(op_AND_25)), DUP(op_AND_25))))), CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(DUP(op_AND_25)), DUP(op_AND_25))), CAST(32, MSB(DUP(op_AND_25)), DUP(op_AND_25)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_25)), DUP(op_AND_25))), CAST(32, MSB(DUP(op_AND_25)), DUP(op_AND_25))))), SEXTRACT64(CAST(64, IL_FALSE, CAST(16, MSB(op_AND_40), DUP(op_AND_40))), SN(32, 0), SN(32, 16)));
	RzILOpPure *op_LSHIFT_49 = SHIFTL0(op_MUL_47, SN(32, 1));
	RzILOpPure *op_RSHIFT_51 = SHIFTRA(op_LSHIFT_49, SN(32, 16));
	RzILOpPure *op_ADD_52 = ADD(CAST(64, MSB(CAST(32, MSB(op_AND_16), DUP(op_AND_16))), CAST(32, MSB(DUP(op_AND_16)), DUP(op_AND_16))), op_RSHIFT_51);
	RzILOpPure *op_RSHIFT_61 = SHIFTRA(READ_REG(pkt, Rxx_op, false), SN(32, 0x20));
	RzILOpPure *op_AND_63 = LOGAND(op_RSHIFT_61, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_69 = SHIFTRA(DUP(Rss), SN(32, 0x20));
	RzILOpPure *op_AND_71 = LOGAND(op_RSHIFT_69, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_82 = SHIFTRA(DUP(Rtt), SN(32, 0x20));
	RzILOpPure *op_AND_85 = LOGAND(op_RSHIFT_82, CAST(64, MSB(SN(32, 0xffff)), SN(32, 0xffff)));
	RzILOpPure *op_MUL_92 = MUL(CAST(64, MSB(CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(op_AND_71), DUP(op_AND_71))), CAST(32, MSB(DUP(op_AND_71)), DUP(op_AND_71)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_71)), DUP(op_AND_71))), CAST(32, MSB(DUP(op_AND_71)), DUP(op_AND_71))))), CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(DUP(op_AND_71)), DUP(op_AND_71))), CAST(32, MSB(DUP(op_AND_71)), DUP(op_AND_71)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_71)), DUP(op_AND_71))), CAST(32, MSB(DUP(op_AND_71)), DUP(op_AND_71))))), SEXTRACT64(CAST(64, IL_FALSE, CAST(16, MSB(op_AND_85), DUP(op_AND_85))), SN(32, 0), SN(32, 16)));
	RzILOpPure *op_LSHIFT_94 = SHIFTL0(op_MUL_92, SN(32, 1));
	RzILOpPure *op_RSHIFT_96 = SHIFTRA(op_LSHIFT_94, SN(32, 16));
	RzILOpPure *op_ADD_97 = ADD(CAST(64, MSB(CAST(32, MSB(op_AND_63), DUP(op_AND_63))), CAST(32, MSB(DUP(op_AND_63)), DUP(op_AND_63))), op_RSHIFT_96);
	RzILOpPure *op_EQ_98 = EQ(SEXTRACT64(CAST(64, IL_FALSE, op_ADD_52), SN(32, 0), SN(32, 0x20)), op_ADD_97);
	RzILOpPure *op_RSHIFT_145 = SHIFTRA(READ_REG(pkt, Rxx_op, false), SN(32, 0x20));
	RzILOpPure *op_AND_147 = LOGAND(op_RSHIFT_145, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_153 = SHIFTRA(DUP(Rss), SN(32, 0x20));
	RzILOpPure *op_AND_155 = LOGAND(op_RSHIFT_153, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_166 = SHIFTRA(DUP(Rtt), SN(32, 0x20));
	RzILOpPure *op_AND_169 = LOGAND(op_RSHIFT_166, CAST(64, MSB(SN(32, 0xffff)), SN(32, 0xffff)));
	RzILOpPure *op_MUL_176 = MUL(CAST(64, MSB(CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(op_AND_155), DUP(op_AND_155))), CAST(32, MSB(DUP(op_AND_155)), DUP(op_AND_155)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_155)), DUP(op_AND_155))), CAST(32, MSB(DUP(op_AND_155)), DUP(op_AND_155))))), CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(DUP(op_AND_155)), DUP(op_AND_155))), CAST(32, MSB(DUP(op_AND_155)), DUP(op_AND_155)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_155)), DUP(op_AND_155))), CAST(32, MSB(DUP(op_AND_155)), DUP(op_AND_155))))), SEXTRACT64(CAST(64, IL_FALSE, CAST(16, MSB(op_AND_169), DUP(op_AND_169))), SN(32, 0), SN(32, 16)));
	RzILOpPure *op_LSHIFT_178 = SHIFTL0(op_MUL_176, SN(32, 1));
	RzILOpPure *op_RSHIFT_180 = SHIFTRA(op_LSHIFT_178, SN(32, 16));
	RzILOpPure *op_ADD_181 = ADD(CAST(64, MSB(CAST(32, MSB(op_AND_147), DUP(op_AND_147))), CAST(32, MSB(DUP(op_AND_147)), DUP(op_AND_147))), op_RSHIFT_180);
	RzILOpPure *op_LT_184 = SLT(op_ADD_181, CAST(64, MSB(SN(32, 0)), SN(32, 0)));
	RzILOpPure *op_LSHIFT_189 = SHIFTL0(SN(64, 1), SN(32, 31));
	RzILOpPure *op_NEG_190 = NEG(op_LSHIFT_189);
	RzILOpPure *op_LSHIFT_195 = SHIFTL0(SN(64, 1), SN(32, 31));
	RzILOpPure *op_SUB_198 = SUB(op_LSHIFT_195, CAST(64, MSB(SN(32, 1)), SN(32, 1)));
	RzILOpPure *cond_199 = ITE(op_LT_184, op_NEG_190, op_SUB_198);
	RzILOpEffect *gcc_expr_200 = BRANCH(op_EQ_98, EMPTY(), set_usr_field_call_141);

	// h_tmp282 = HYB(gcc_expr_if ((sextract64(((ut64) ((st64) ((st32) ((Rxx >> 0x20) & 0xffffffff))) + ((((st64) ((st32) ((st64) ((st32) ((Rss >> 0x20) & 0xffffffff))))) * sextract64(((ut64) ((st16) ((Rtt >> 0x20) & ((st64) 0xffff)))), 0x0, 0x10) << 0x1) >> 0x10)), 0x0, 0x20) == ((st64) ((st32) ((Rxx >> 0x20) & 0xffffffff))) + ((((st64) ((st32) ((st64) ((st32) ((Rss >> 0x20) & 0xffffffff))))) * sextract64(((ut64) ((st16) ((Rtt >> 0x20) & ((st64) 0xffff)))), 0x0, 0x10) << 0x1) >> 0x10))) {{}} else {set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, ((ut32) 0x1))}, ((((st64) ((st32) ((Rxx >> 0x20) & 0xffffffff))) + ((((st64) ((st32) ((st64) ((st32) ((Rss >> 0x20) & 0xffffffff))))) * sextract64(((ut64) ((st16) ((Rtt >> 0x20) & ((st64) 0xffff)))), 0x0, 0x10) << 0x1) >> 0x10) < ((st64) 0x0)) ? (-(0x1 << 0x1f)) : (0x1 << 0x1f) - ((st64) 0x1)));
	RzILOpEffect *op_ASSIGN_hybrid_tmp_202 = SETL("h_tmp282", cond_199);

	// seq(HYB(gcc_expr_if ((sextract64(((ut64) ((st64) ((st32) ((Rxx > ...;
	RzILOpEffect *seq_203 = SEQN(2, gcc_expr_200, op_ASSIGN_hybrid_tmp_202);

	// Rxx = ((Rxx & (~(0xffffffff << 0x20))) | ((((sextract64(((ut64) ((st64) ((st32) ((Rxx >> 0x20) & 0xffffffff))) + ((((st64) ((st32) ((st64) ((st32) ((Rss >> 0x20) & 0xffffffff))))) * sextract64(((ut64) ((st16) ((Rtt >> 0x20) & ((st64) 0xffff)))), 0x0, 0x10) << 0x1) >> 0x10)), 0x0, 0x20) == ((st64) ((st32) ((Rxx >> 0x20) & 0xffffffff))) + ((((st64) ((st32) ((st64) ((st32) ((Rss >> 0x20) & 0xffffffff))))) * sextract64(((ut64) ((st16) ((Rtt >> 0x20) & ((st64) 0xffff)))), 0x0, 0x10) << 0x1) >> 0x10)) ? ((st64) ((st32) ((Rxx >> 0x20) & 0xffffffff))) + ((((st64) ((st32) ((st64) ((st32) ((Rss >> 0x20) & 0xffffffff))))) * sextract64(((ut64) ((st16) ((Rtt >> 0x20) & ((st64) 0xffff)))), 0x0, 0x10) << 0x1) >> 0x10) : h_tmp282) & 0xffffffff) << 0x20));
	RzILOpPure *op_LSHIFT_5 = SHIFTL0(SN(64, 0xffffffff), SN(32, 0x20));
	RzILOpPure *op_NOT_6 = LOGNOT(op_LSHIFT_5);
	RzILOpPure *op_AND_7 = LOGAND(READ_REG(pkt, Rxx_op, false), op_NOT_6);
	RzILOpPure *op_RSHIFT_102 = SHIFTRA(READ_REG(pkt, Rxx_op, false), SN(32, 0x20));
	RzILOpPure *op_AND_104 = LOGAND(op_RSHIFT_102, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_110 = SHIFTRA(DUP(Rss), SN(32, 0x20));
	RzILOpPure *op_AND_112 = LOGAND(op_RSHIFT_110, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_123 = SHIFTRA(DUP(Rtt), SN(32, 0x20));
	RzILOpPure *op_AND_126 = LOGAND(op_RSHIFT_123, CAST(64, MSB(SN(32, 0xffff)), SN(32, 0xffff)));
	RzILOpPure *op_MUL_133 = MUL(CAST(64, MSB(CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(op_AND_112), DUP(op_AND_112))), CAST(32, MSB(DUP(op_AND_112)), DUP(op_AND_112)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_112)), DUP(op_AND_112))), CAST(32, MSB(DUP(op_AND_112)), DUP(op_AND_112))))), CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(DUP(op_AND_112)), DUP(op_AND_112))), CAST(32, MSB(DUP(op_AND_112)), DUP(op_AND_112)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_112)), DUP(op_AND_112))), CAST(32, MSB(DUP(op_AND_112)), DUP(op_AND_112))))), SEXTRACT64(CAST(64, IL_FALSE, CAST(16, MSB(op_AND_126), DUP(op_AND_126))), SN(32, 0), SN(32, 16)));
	RzILOpPure *op_LSHIFT_135 = SHIFTL0(op_MUL_133, SN(32, 1));
	RzILOpPure *op_RSHIFT_137 = SHIFTRA(op_LSHIFT_135, SN(32, 16));
	RzILOpPure *op_ADD_138 = ADD(CAST(64, MSB(CAST(32, MSB(op_AND_104), DUP(op_AND_104))), CAST(32, MSB(DUP(op_AND_104)), DUP(op_AND_104))), op_RSHIFT_137);
	RzILOpPure *cond_204 = ITE(DUP(op_EQ_98), op_ADD_138, VARL("h_tmp282"));
	RzILOpPure *op_AND_206 = LOGAND(cond_204, SN(64, 0xffffffff));
	RzILOpPure *op_LSHIFT_210 = SHIFTL0(op_AND_206, SN(32, 0x20));
	RzILOpPure *op_OR_211 = LOGOR(op_AND_7, op_LSHIFT_210);
	RzILOpEffect *op_ASSIGN_212 = WRITE_REG(bundle, Rxx_op, op_OR_211);

	// seq(seq(HYB(gcc_expr_if ((sextract64(((ut64) ((st64) ((st32) ((R ...;
	RzILOpEffect *seq_213 = SEQN(2, seq_203, op_ASSIGN_212);

	// set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, ((ut32) 0x1));
	RzILOpEffect *set_usr_field_call_353 = hex_set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, CAST(32, IL_FALSE, SN(32, 1)));

	// HYB(gcc_expr_if ((sextract64(((ut64) ((st64) ((st32) ((Rxx >> 0x0) & 0xffffffff))) + ((((st64) ((st32) ((st64) ((st32) ((Rss >> 0x0) & 0xffffffff))))) * sextract64(((ut64) ((st16) ((Rtt >> 0x0) & ((st64) 0xffff)))), 0x0, 0x10) << 0x1) >> 0x10)), 0x0, 0x20) == ((st64) ((st32) ((Rxx >> 0x0) & 0xffffffff))) + ((((st64) ((st32) ((st64) ((st32) ((Rss >> 0x0) & 0xffffffff))))) * sextract64(((ut64) ((st16) ((Rtt >> 0x0) & ((st64) 0xffff)))), 0x0, 0x10) << 0x1) >> 0x10))) {{}} else {set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, ((ut32) 0x1))}, ((((st64) ((st32) ((Rxx >> 0x0) & 0xffffffff))) + ((((st64) ((st32) ((st64) ((st32) ((Rss >> 0x0) & 0xffffffff))))) * sextract64(((ut64) ((st16) ((Rtt >> 0x0) & ((st64) 0xffff)))), 0x0, 0x10) << 0x1) >> 0x10) < ((st64) 0x0)) ? (-(0x1 << 0x1f)) : (0x1 << 0x1f) - ((st64) 0x1)));
	RzILOpPure *op_RSHIFT_228 = SHIFTRA(READ_REG(pkt, Rxx_op, false), SN(32, 0));
	RzILOpPure *op_AND_230 = LOGAND(op_RSHIFT_228, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_236 = SHIFTRA(DUP(Rss), SN(32, 0));
	RzILOpPure *op_AND_238 = LOGAND(op_RSHIFT_236, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_249 = SHIFTRA(DUP(Rtt), SN(32, 0));
	RzILOpPure *op_AND_252 = LOGAND(op_RSHIFT_249, CAST(64, MSB(SN(32, 0xffff)), SN(32, 0xffff)));
	RzILOpPure *op_MUL_259 = MUL(CAST(64, MSB(CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(op_AND_238), DUP(op_AND_238))), CAST(32, MSB(DUP(op_AND_238)), DUP(op_AND_238)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_238)), DUP(op_AND_238))), CAST(32, MSB(DUP(op_AND_238)), DUP(op_AND_238))))), CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(DUP(op_AND_238)), DUP(op_AND_238))), CAST(32, MSB(DUP(op_AND_238)), DUP(op_AND_238)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_238)), DUP(op_AND_238))), CAST(32, MSB(DUP(op_AND_238)), DUP(op_AND_238))))), SEXTRACT64(CAST(64, IL_FALSE, CAST(16, MSB(op_AND_252), DUP(op_AND_252))), SN(32, 0), SN(32, 16)));
	RzILOpPure *op_LSHIFT_261 = SHIFTL0(op_MUL_259, SN(32, 1));
	RzILOpPure *op_RSHIFT_263 = SHIFTRA(op_LSHIFT_261, SN(32, 16));
	RzILOpPure *op_ADD_264 = ADD(CAST(64, MSB(CAST(32, MSB(op_AND_230), DUP(op_AND_230))), CAST(32, MSB(DUP(op_AND_230)), DUP(op_AND_230))), op_RSHIFT_263);
	RzILOpPure *op_RSHIFT_273 = SHIFTRA(READ_REG(pkt, Rxx_op, false), SN(32, 0));
	RzILOpPure *op_AND_275 = LOGAND(op_RSHIFT_273, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_281 = SHIFTRA(DUP(Rss), SN(32, 0));
	RzILOpPure *op_AND_283 = LOGAND(op_RSHIFT_281, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_294 = SHIFTRA(DUP(Rtt), SN(32, 0));
	RzILOpPure *op_AND_297 = LOGAND(op_RSHIFT_294, CAST(64, MSB(SN(32, 0xffff)), SN(32, 0xffff)));
	RzILOpPure *op_MUL_304 = MUL(CAST(64, MSB(CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(op_AND_283), DUP(op_AND_283))), CAST(32, MSB(DUP(op_AND_283)), DUP(op_AND_283)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_283)), DUP(op_AND_283))), CAST(32, MSB(DUP(op_AND_283)), DUP(op_AND_283))))), CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(DUP(op_AND_283)), DUP(op_AND_283))), CAST(32, MSB(DUP(op_AND_283)), DUP(op_AND_283)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_283)), DUP(op_AND_283))), CAST(32, MSB(DUP(op_AND_283)), DUP(op_AND_283))))), SEXTRACT64(CAST(64, IL_FALSE, CAST(16, MSB(op_AND_297), DUP(op_AND_297))), SN(32, 0), SN(32, 16)));
	RzILOpPure *op_LSHIFT_306 = SHIFTL0(op_MUL_304, SN(32, 1));
	RzILOpPure *op_RSHIFT_308 = SHIFTRA(op_LSHIFT_306, SN(32, 16));
	RzILOpPure *op_ADD_309 = ADD(CAST(64, MSB(CAST(32, MSB(op_AND_275), DUP(op_AND_275))), CAST(32, MSB(DUP(op_AND_275)), DUP(op_AND_275))), op_RSHIFT_308);
	RzILOpPure *op_EQ_310 = EQ(SEXTRACT64(CAST(64, IL_FALSE, op_ADD_264), SN(32, 0), SN(32, 0x20)), op_ADD_309);
	RzILOpPure *op_RSHIFT_357 = SHIFTRA(READ_REG(pkt, Rxx_op, false), SN(32, 0));
	RzILOpPure *op_AND_359 = LOGAND(op_RSHIFT_357, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_365 = SHIFTRA(DUP(Rss), SN(32, 0));
	RzILOpPure *op_AND_367 = LOGAND(op_RSHIFT_365, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_378 = SHIFTRA(DUP(Rtt), SN(32, 0));
	RzILOpPure *op_AND_381 = LOGAND(op_RSHIFT_378, CAST(64, MSB(SN(32, 0xffff)), SN(32, 0xffff)));
	RzILOpPure *op_MUL_388 = MUL(CAST(64, MSB(CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(op_AND_367), DUP(op_AND_367))), CAST(32, MSB(DUP(op_AND_367)), DUP(op_AND_367)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_367)), DUP(op_AND_367))), CAST(32, MSB(DUP(op_AND_367)), DUP(op_AND_367))))), CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(DUP(op_AND_367)), DUP(op_AND_367))), CAST(32, MSB(DUP(op_AND_367)), DUP(op_AND_367)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_367)), DUP(op_AND_367))), CAST(32, MSB(DUP(op_AND_367)), DUP(op_AND_367))))), SEXTRACT64(CAST(64, IL_FALSE, CAST(16, MSB(op_AND_381), DUP(op_AND_381))), SN(32, 0), SN(32, 16)));
	RzILOpPure *op_LSHIFT_390 = SHIFTL0(op_MUL_388, SN(32, 1));
	RzILOpPure *op_RSHIFT_392 = SHIFTRA(op_LSHIFT_390, SN(32, 16));
	RzILOpPure *op_ADD_393 = ADD(CAST(64, MSB(CAST(32, MSB(op_AND_359), DUP(op_AND_359))), CAST(32, MSB(DUP(op_AND_359)), DUP(op_AND_359))), op_RSHIFT_392);
	RzILOpPure *op_LT_396 = SLT(op_ADD_393, CAST(64, MSB(SN(32, 0)), SN(32, 0)));
	RzILOpPure *op_LSHIFT_401 = SHIFTL0(SN(64, 1), SN(32, 31));
	RzILOpPure *op_NEG_402 = NEG(op_LSHIFT_401);
	RzILOpPure *op_LSHIFT_407 = SHIFTL0(SN(64, 1), SN(32, 31));
	RzILOpPure *op_SUB_410 = SUB(op_LSHIFT_407, CAST(64, MSB(SN(32, 1)), SN(32, 1)));
	RzILOpPure *cond_411 = ITE(op_LT_396, op_NEG_402, op_SUB_410);
	RzILOpEffect *gcc_expr_412 = BRANCH(op_EQ_310, EMPTY(), set_usr_field_call_353);

	// h_tmp283 = HYB(gcc_expr_if ((sextract64(((ut64) ((st64) ((st32) ((Rxx >> 0x0) & 0xffffffff))) + ((((st64) ((st32) ((st64) ((st32) ((Rss >> 0x0) & 0xffffffff))))) * sextract64(((ut64) ((st16) ((Rtt >> 0x0) & ((st64) 0xffff)))), 0x0, 0x10) << 0x1) >> 0x10)), 0x0, 0x20) == ((st64) ((st32) ((Rxx >> 0x0) & 0xffffffff))) + ((((st64) ((st32) ((st64) ((st32) ((Rss >> 0x0) & 0xffffffff))))) * sextract64(((ut64) ((st16) ((Rtt >> 0x0) & ((st64) 0xffff)))), 0x0, 0x10) << 0x1) >> 0x10))) {{}} else {set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, ((ut32) 0x1))}, ((((st64) ((st32) ((Rxx >> 0x0) & 0xffffffff))) + ((((st64) ((st32) ((st64) ((st32) ((Rss >> 0x0) & 0xffffffff))))) * sextract64(((ut64) ((st16) ((Rtt >> 0x0) & ((st64) 0xffff)))), 0x0, 0x10) << 0x1) >> 0x10) < ((st64) 0x0)) ? (-(0x1 << 0x1f)) : (0x1 << 0x1f) - ((st64) 0x1)));
	RzILOpEffect *op_ASSIGN_hybrid_tmp_414 = SETL("h_tmp283", cond_411);

	// seq(HYB(gcc_expr_if ((sextract64(((ut64) ((st64) ((st32) ((Rxx > ...;
	RzILOpEffect *seq_415 = SEQN(2, gcc_expr_412, op_ASSIGN_hybrid_tmp_414);

	// Rxx = ((Rxx & (~(0xffffffff << 0x0))) | ((((sextract64(((ut64) ((st64) ((st32) ((Rxx >> 0x0) & 0xffffffff))) + ((((st64) ((st32) ((st64) ((st32) ((Rss >> 0x0) & 0xffffffff))))) * sextract64(((ut64) ((st16) ((Rtt >> 0x0) & ((st64) 0xffff)))), 0x0, 0x10) << 0x1) >> 0x10)), 0x0, 0x20) == ((st64) ((st32) ((Rxx >> 0x0) & 0xffffffff))) + ((((st64) ((st32) ((st64) ((st32) ((Rss >> 0x0) & 0xffffffff))))) * sextract64(((ut64) ((st16) ((Rtt >> 0x0) & ((st64) 0xffff)))), 0x0, 0x10) << 0x1) >> 0x10)) ? ((st64) ((st32) ((Rxx >> 0x0) & 0xffffffff))) + ((((st64) ((st32) ((st64) ((st32) ((Rss >> 0x0) & 0xffffffff))))) * sextract64(((ut64) ((st16) ((Rtt >> 0x0) & ((st64) 0xffff)))), 0x0, 0x10) << 0x1) >> 0x10) : h_tmp283) & 0xffffffff) << 0x0));
	RzILOpPure *op_LSHIFT_219 = SHIFTL0(SN(64, 0xffffffff), SN(32, 0));
	RzILOpPure *op_NOT_220 = LOGNOT(op_LSHIFT_219);
	RzILOpPure *op_AND_221 = LOGAND(READ_REG(pkt, Rxx_op, false), op_NOT_220);
	RzILOpPure *op_RSHIFT_314 = SHIFTRA(READ_REG(pkt, Rxx_op, false), SN(32, 0));
	RzILOpPure *op_AND_316 = LOGAND(op_RSHIFT_314, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_322 = SHIFTRA(DUP(Rss), SN(32, 0));
	RzILOpPure *op_AND_324 = LOGAND(op_RSHIFT_322, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_335 = SHIFTRA(DUP(Rtt), SN(32, 0));
	RzILOpPure *op_AND_338 = LOGAND(op_RSHIFT_335, CAST(64, MSB(SN(32, 0xffff)), SN(32, 0xffff)));
	RzILOpPure *op_MUL_345 = MUL(CAST(64, MSB(CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(op_AND_324), DUP(op_AND_324))), CAST(32, MSB(DUP(op_AND_324)), DUP(op_AND_324)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_324)), DUP(op_AND_324))), CAST(32, MSB(DUP(op_AND_324)), DUP(op_AND_324))))), CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(DUP(op_AND_324)), DUP(op_AND_324))), CAST(32, MSB(DUP(op_AND_324)), DUP(op_AND_324)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_324)), DUP(op_AND_324))), CAST(32, MSB(DUP(op_AND_324)), DUP(op_AND_324))))), SEXTRACT64(CAST(64, IL_FALSE, CAST(16, MSB(op_AND_338), DUP(op_AND_338))), SN(32, 0), SN(32, 16)));
	RzILOpPure *op_LSHIFT_347 = SHIFTL0(op_MUL_345, SN(32, 1));
	RzILOpPure *op_RSHIFT_349 = SHIFTRA(op_LSHIFT_347, SN(32, 16));
	RzILOpPure *op_ADD_350 = ADD(CAST(64, MSB(CAST(32, MSB(op_AND_316), DUP(op_AND_316))), CAST(32, MSB(DUP(op_AND_316)), DUP(op_AND_316))), op_RSHIFT_349);
	RzILOpPure *cond_416 = ITE(DUP(op_EQ_310), op_ADD_350, VARL("h_tmp283"));
	RzILOpPure *op_AND_418 = LOGAND(cond_416, SN(64, 0xffffffff));
	RzILOpPure *op_LSHIFT_422 = SHIFTL0(op_AND_418, SN(32, 0));
	RzILOpPure *op_OR_423 = LOGOR(op_AND_221, op_LSHIFT_422);
	RzILOpEffect *op_ASSIGN_424 = WRITE_REG(bundle, Rxx_op, op_OR_423);

	// seq(seq(HYB(gcc_expr_if ((sextract64(((ut64) ((st64) ((st32) ((R ...;
	RzILOpEffect *seq_425 = SEQN(2, seq_415, op_ASSIGN_424);

	RzILOpEffect *instruction_sequence = SEQN(2, seq_213, seq_425);
	return instruction_sequence;
}

// Rxx += vmpywouh(Rss,Rtt):rnd:sat
RzILOpEffect *hex_il_op_m2_mmacuhs_rs0(HexInsnPktBundle *bundle) {
	const HexInsn *hi = bundle->insn;
	HexPkt *pkt = bundle->pkt;
	// READ
	const HexOp *Rxx_op = ISA2REG(hi, 'x', false);

	const HexOp *Rss_op = ISA2REG(hi, 's', false);
	RzILOpPure *Rss = READ_REG(pkt, Rss_op, false);
	const HexOp *Rtt_op = ISA2REG(hi, 't', false);
	RzILOpPure *Rtt = READ_REG(pkt, Rtt_op, false);

	// set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, ((ut32) 0x1));
	RzILOpEffect *set_usr_field_call_156 = hex_set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, CAST(32, IL_FALSE, SN(32, 1)));

	// HYB(gcc_expr_if ((sextract64(((ut64) ((st64) ((st32) ((Rxx >> 0x20) & 0xffffffff))) + ((((st64) ((ut64) ((st64) ((st32) ((st64) ((st32) ((Rss >> 0x20) & 0xffffffff)))))) * extract64(((ut64) ((ut16) ((Rtt >> 0x30) & ((st64) 0xffff)))), 0x0, 0x10)) << 0x0) + ((st64) 0x8000) >> 0x10)), 0x0, 0x20) == ((st64) ((st32) ((Rxx >> 0x20) & 0xffffffff))) + ((((st64) ((ut64) ((st64) ((st32) ((st64) ((st32) ((Rss >> 0x20) & 0xffffffff)))))) * extract64(((ut64) ((ut16) ((Rtt >> 0x30) & ((st64) 0xffff)))), 0x0, 0x10)) << 0x0) + ((st64) 0x8000) >> 0x10))) {{}} else {set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, ((ut32) 0x1))}, ((((st64) ((st32) ((Rxx >> 0x20) & 0xffffffff))) + ((((st64) ((ut64) ((st64) ((st32) ((st64) ((st32) ((Rss >> 0x20) & 0xffffffff)))))) * extract64(((ut64) ((ut16) ((Rtt >> 0x30) & ((st64) 0xffff)))), 0x0, 0x10)) << 0x0) + ((st64) 0x8000) >> 0x10) < ((st64) 0x0)) ? (-(0x1 << 0x1f)) : (0x1 << 0x1f) - ((st64) 0x1)));
	RzILOpPure *op_RSHIFT_14 = SHIFTRA(READ_REG(pkt, Rxx_op, false), SN(32, 0x20));
	RzILOpPure *op_AND_16 = LOGAND(op_RSHIFT_14, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_23 = SHIFTRA(Rss, SN(32, 0x20));
	RzILOpPure *op_AND_25 = LOGAND(op_RSHIFT_23, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_37 = SHIFTRA(Rtt, SN(32, 0x30));
	RzILOpPure *op_AND_40 = LOGAND(op_RSHIFT_37, CAST(64, MSB(SN(32, 0xffff)), SN(32, 0xffff)));
	RzILOpPure *op_MUL_48 = MUL(CAST(64, IL_FALSE, CAST(64, MSB(CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(op_AND_25), DUP(op_AND_25))), CAST(32, MSB(DUP(op_AND_25)), DUP(op_AND_25)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_25)), DUP(op_AND_25))), CAST(32, MSB(DUP(op_AND_25)), DUP(op_AND_25))))), CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(DUP(op_AND_25)), DUP(op_AND_25))), CAST(32, MSB(DUP(op_AND_25)), DUP(op_AND_25)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_25)), DUP(op_AND_25))), CAST(32, MSB(DUP(op_AND_25)), DUP(op_AND_25)))))), EXTRACT64(CAST(64, IL_FALSE, CAST(16, IL_FALSE, op_AND_40)), SN(32, 0), SN(32, 16)));
	RzILOpPure *op_LSHIFT_51 = SHIFTL0(CAST(64, IL_FALSE, op_MUL_48), SN(32, 0));
	RzILOpPure *op_ADD_54 = ADD(op_LSHIFT_51, CAST(64, MSB(SN(32, 0x8000)), SN(32, 0x8000)));
	RzILOpPure *op_RSHIFT_56 = SHIFTRA(op_ADD_54, SN(32, 16));
	RzILOpPure *op_ADD_57 = ADD(CAST(64, MSB(CAST(32, MSB(op_AND_16), DUP(op_AND_16))), CAST(32, MSB(DUP(op_AND_16)), DUP(op_AND_16))), op_RSHIFT_56);
	RzILOpPure *op_RSHIFT_66 = SHIFTRA(READ_REG(pkt, Rxx_op, false), SN(32, 0x20));
	RzILOpPure *op_AND_68 = LOGAND(op_RSHIFT_66, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_74 = SHIFTRA(DUP(Rss), SN(32, 0x20));
	RzILOpPure *op_AND_76 = LOGAND(op_RSHIFT_74, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_87 = SHIFTRA(DUP(Rtt), SN(32, 0x30));
	RzILOpPure *op_AND_90 = LOGAND(op_RSHIFT_87, CAST(64, MSB(SN(32, 0xffff)), SN(32, 0xffff)));
	RzILOpPure *op_MUL_98 = MUL(CAST(64, IL_FALSE, CAST(64, MSB(CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(op_AND_76), DUP(op_AND_76))), CAST(32, MSB(DUP(op_AND_76)), DUP(op_AND_76)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_76)), DUP(op_AND_76))), CAST(32, MSB(DUP(op_AND_76)), DUP(op_AND_76))))), CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(DUP(op_AND_76)), DUP(op_AND_76))), CAST(32, MSB(DUP(op_AND_76)), DUP(op_AND_76)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_76)), DUP(op_AND_76))), CAST(32, MSB(DUP(op_AND_76)), DUP(op_AND_76)))))), EXTRACT64(CAST(64, IL_FALSE, CAST(16, IL_FALSE, op_AND_90)), SN(32, 0), SN(32, 16)));
	RzILOpPure *op_LSHIFT_101 = SHIFTL0(CAST(64, IL_FALSE, op_MUL_98), SN(32, 0));
	RzILOpPure *op_ADD_104 = ADD(op_LSHIFT_101, CAST(64, MSB(SN(32, 0x8000)), SN(32, 0x8000)));
	RzILOpPure *op_RSHIFT_106 = SHIFTRA(op_ADD_104, SN(32, 16));
	RzILOpPure *op_ADD_107 = ADD(CAST(64, MSB(CAST(32, MSB(op_AND_68), DUP(op_AND_68))), CAST(32, MSB(DUP(op_AND_68)), DUP(op_AND_68))), op_RSHIFT_106);
	RzILOpPure *op_EQ_108 = EQ(SEXTRACT64(CAST(64, IL_FALSE, op_ADD_57), SN(32, 0), SN(32, 0x20)), op_ADD_107);
	RzILOpPure *op_RSHIFT_160 = SHIFTRA(READ_REG(pkt, Rxx_op, false), SN(32, 0x20));
	RzILOpPure *op_AND_162 = LOGAND(op_RSHIFT_160, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_168 = SHIFTRA(DUP(Rss), SN(32, 0x20));
	RzILOpPure *op_AND_170 = LOGAND(op_RSHIFT_168, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_181 = SHIFTRA(DUP(Rtt), SN(32, 0x30));
	RzILOpPure *op_AND_184 = LOGAND(op_RSHIFT_181, CAST(64, MSB(SN(32, 0xffff)), SN(32, 0xffff)));
	RzILOpPure *op_MUL_192 = MUL(CAST(64, IL_FALSE, CAST(64, MSB(CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(op_AND_170), DUP(op_AND_170))), CAST(32, MSB(DUP(op_AND_170)), DUP(op_AND_170)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_170)), DUP(op_AND_170))), CAST(32, MSB(DUP(op_AND_170)), DUP(op_AND_170))))), CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(DUP(op_AND_170)), DUP(op_AND_170))), CAST(32, MSB(DUP(op_AND_170)), DUP(op_AND_170)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_170)), DUP(op_AND_170))), CAST(32, MSB(DUP(op_AND_170)), DUP(op_AND_170)))))), EXTRACT64(CAST(64, IL_FALSE, CAST(16, IL_FALSE, op_AND_184)), SN(32, 0), SN(32, 16)));
	RzILOpPure *op_LSHIFT_195 = SHIFTL0(CAST(64, IL_FALSE, op_MUL_192), SN(32, 0));
	RzILOpPure *op_ADD_198 = ADD(op_LSHIFT_195, CAST(64, MSB(SN(32, 0x8000)), SN(32, 0x8000)));
	RzILOpPure *op_RSHIFT_200 = SHIFTRA(op_ADD_198, SN(32, 16));
	RzILOpPure *op_ADD_201 = ADD(CAST(64, MSB(CAST(32, MSB(op_AND_162), DUP(op_AND_162))), CAST(32, MSB(DUP(op_AND_162)), DUP(op_AND_162))), op_RSHIFT_200);
	RzILOpPure *op_LT_204 = SLT(op_ADD_201, CAST(64, MSB(SN(32, 0)), SN(32, 0)));
	RzILOpPure *op_LSHIFT_209 = SHIFTL0(SN(64, 1), SN(32, 31));
	RzILOpPure *op_NEG_210 = NEG(op_LSHIFT_209);
	RzILOpPure *op_LSHIFT_215 = SHIFTL0(SN(64, 1), SN(32, 31));
	RzILOpPure *op_SUB_218 = SUB(op_LSHIFT_215, CAST(64, MSB(SN(32, 1)), SN(32, 1)));
	RzILOpPure *cond_219 = ITE(op_LT_204, op_NEG_210, op_SUB_218);
	RzILOpEffect *gcc_expr_220 = BRANCH(op_EQ_108, EMPTY(), set_usr_field_call_156);

	// h_tmp284 = HYB(gcc_expr_if ((sextract64(((ut64) ((st64) ((st32) ((Rxx >> 0x20) & 0xffffffff))) + ((((st64) ((ut64) ((st64) ((st32) ((st64) ((st32) ((Rss >> 0x20) & 0xffffffff)))))) * extract64(((ut64) ((ut16) ((Rtt >> 0x30) & ((st64) 0xffff)))), 0x0, 0x10)) << 0x0) + ((st64) 0x8000) >> 0x10)), 0x0, 0x20) == ((st64) ((st32) ((Rxx >> 0x20) & 0xffffffff))) + ((((st64) ((ut64) ((st64) ((st32) ((st64) ((st32) ((Rss >> 0x20) & 0xffffffff)))))) * extract64(((ut64) ((ut16) ((Rtt >> 0x30) & ((st64) 0xffff)))), 0x0, 0x10)) << 0x0) + ((st64) 0x8000) >> 0x10))) {{}} else {set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, ((ut32) 0x1))}, ((((st64) ((st32) ((Rxx >> 0x20) & 0xffffffff))) + ((((st64) ((ut64) ((st64) ((st32) ((st64) ((st32) ((Rss >> 0x20) & 0xffffffff)))))) * extract64(((ut64) ((ut16) ((Rtt >> 0x30) & ((st64) 0xffff)))), 0x0, 0x10)) << 0x0) + ((st64) 0x8000) >> 0x10) < ((st64) 0x0)) ? (-(0x1 << 0x1f)) : (0x1 << 0x1f) - ((st64) 0x1)));
	RzILOpEffect *op_ASSIGN_hybrid_tmp_222 = SETL("h_tmp284", cond_219);

	// seq(HYB(gcc_expr_if ((sextract64(((ut64) ((st64) ((st32) ((Rxx > ...;
	RzILOpEffect *seq_223 = SEQN(2, gcc_expr_220, op_ASSIGN_hybrid_tmp_222);

	// Rxx = ((Rxx & (~(0xffffffff << 0x20))) | ((((sextract64(((ut64) ((st64) ((st32) ((Rxx >> 0x20) & 0xffffffff))) + ((((st64) ((ut64) ((st64) ((st32) ((st64) ((st32) ((Rss >> 0x20) & 0xffffffff)))))) * extract64(((ut64) ((ut16) ((Rtt >> 0x30) & ((st64) 0xffff)))), 0x0, 0x10)) << 0x0) + ((st64) 0x8000) >> 0x10)), 0x0, 0x20) == ((st64) ((st32) ((Rxx >> 0x20) & 0xffffffff))) + ((((st64) ((ut64) ((st64) ((st32) ((st64) ((st32) ((Rss >> 0x20) & 0xffffffff)))))) * extract64(((ut64) ((ut16) ((Rtt >> 0x30) & ((st64) 0xffff)))), 0x0, 0x10)) << 0x0) + ((st64) 0x8000) >> 0x10)) ? ((st64) ((st32) ((Rxx >> 0x20) & 0xffffffff))) + ((((st64) ((ut64) ((st64) ((st32) ((st64) ((st32) ((Rss >> 0x20) & 0xffffffff)))))) * extract64(((ut64) ((ut16) ((Rtt >> 0x30) & ((st64) 0xffff)))), 0x0, 0x10)) << 0x0) + ((st64) 0x8000) >> 0x10) : h_tmp284) & 0xffffffff) << 0x20));
	RzILOpPure *op_LSHIFT_5 = SHIFTL0(SN(64, 0xffffffff), SN(32, 0x20));
	RzILOpPure *op_NOT_6 = LOGNOT(op_LSHIFT_5);
	RzILOpPure *op_AND_7 = LOGAND(READ_REG(pkt, Rxx_op, false), op_NOT_6);
	RzILOpPure *op_RSHIFT_112 = SHIFTRA(READ_REG(pkt, Rxx_op, false), SN(32, 0x20));
	RzILOpPure *op_AND_114 = LOGAND(op_RSHIFT_112, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_120 = SHIFTRA(DUP(Rss), SN(32, 0x20));
	RzILOpPure *op_AND_122 = LOGAND(op_RSHIFT_120, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_133 = SHIFTRA(DUP(Rtt), SN(32, 0x30));
	RzILOpPure *op_AND_136 = LOGAND(op_RSHIFT_133, CAST(64, MSB(SN(32, 0xffff)), SN(32, 0xffff)));
	RzILOpPure *op_MUL_144 = MUL(CAST(64, IL_FALSE, CAST(64, MSB(CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(op_AND_122), DUP(op_AND_122))), CAST(32, MSB(DUP(op_AND_122)), DUP(op_AND_122)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_122)), DUP(op_AND_122))), CAST(32, MSB(DUP(op_AND_122)), DUP(op_AND_122))))), CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(DUP(op_AND_122)), DUP(op_AND_122))), CAST(32, MSB(DUP(op_AND_122)), DUP(op_AND_122)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_122)), DUP(op_AND_122))), CAST(32, MSB(DUP(op_AND_122)), DUP(op_AND_122)))))), EXTRACT64(CAST(64, IL_FALSE, CAST(16, IL_FALSE, op_AND_136)), SN(32, 0), SN(32, 16)));
	RzILOpPure *op_LSHIFT_147 = SHIFTL0(CAST(64, IL_FALSE, op_MUL_144), SN(32, 0));
	RzILOpPure *op_ADD_150 = ADD(op_LSHIFT_147, CAST(64, MSB(SN(32, 0x8000)), SN(32, 0x8000)));
	RzILOpPure *op_RSHIFT_152 = SHIFTRA(op_ADD_150, SN(32, 16));
	RzILOpPure *op_ADD_153 = ADD(CAST(64, MSB(CAST(32, MSB(op_AND_114), DUP(op_AND_114))), CAST(32, MSB(DUP(op_AND_114)), DUP(op_AND_114))), op_RSHIFT_152);
	RzILOpPure *cond_224 = ITE(DUP(op_EQ_108), op_ADD_153, VARL("h_tmp284"));
	RzILOpPure *op_AND_226 = LOGAND(cond_224, SN(64, 0xffffffff));
	RzILOpPure *op_LSHIFT_230 = SHIFTL0(op_AND_226, SN(32, 0x20));
	RzILOpPure *op_OR_231 = LOGOR(op_AND_7, op_LSHIFT_230);
	RzILOpEffect *op_ASSIGN_232 = WRITE_REG(bundle, Rxx_op, op_OR_231);

	// seq(seq(HYB(gcc_expr_if ((sextract64(((ut64) ((st64) ((st32) ((R ...;
	RzILOpEffect *seq_233 = SEQN(2, seq_223, op_ASSIGN_232);

	// set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, ((ut32) 0x1));
	RzILOpEffect *set_usr_field_call_388 = hex_set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, CAST(32, IL_FALSE, SN(32, 1)));

	// HYB(gcc_expr_if ((sextract64(((ut64) ((st64) ((st32) ((Rxx >> 0x0) & 0xffffffff))) + ((((st64) ((ut64) ((st64) ((st32) ((st64) ((st32) ((Rss >> 0x0) & 0xffffffff)))))) * extract64(((ut64) ((ut16) ((Rtt >> 0x10) & ((st64) 0xffff)))), 0x0, 0x10)) << 0x0) + ((st64) 0x8000) >> 0x10)), 0x0, 0x20) == ((st64) ((st32) ((Rxx >> 0x0) & 0xffffffff))) + ((((st64) ((ut64) ((st64) ((st32) ((st64) ((st32) ((Rss >> 0x0) & 0xffffffff)))))) * extract64(((ut64) ((ut16) ((Rtt >> 0x10) & ((st64) 0xffff)))), 0x0, 0x10)) << 0x0) + ((st64) 0x8000) >> 0x10))) {{}} else {set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, ((ut32) 0x1))}, ((((st64) ((st32) ((Rxx >> 0x0) & 0xffffffff))) + ((((st64) ((ut64) ((st64) ((st32) ((st64) ((st32) ((Rss >> 0x0) & 0xffffffff)))))) * extract64(((ut64) ((ut16) ((Rtt >> 0x10) & ((st64) 0xffff)))), 0x0, 0x10)) << 0x0) + ((st64) 0x8000) >> 0x10) < ((st64) 0x0)) ? (-(0x1 << 0x1f)) : (0x1 << 0x1f) - ((st64) 0x1)));
	RzILOpPure *op_RSHIFT_248 = SHIFTRA(READ_REG(pkt, Rxx_op, false), SN(32, 0));
	RzILOpPure *op_AND_250 = LOGAND(op_RSHIFT_248, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_256 = SHIFTRA(DUP(Rss), SN(32, 0));
	RzILOpPure *op_AND_258 = LOGAND(op_RSHIFT_256, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_269 = SHIFTRA(DUP(Rtt), SN(32, 16));
	RzILOpPure *op_AND_272 = LOGAND(op_RSHIFT_269, CAST(64, MSB(SN(32, 0xffff)), SN(32, 0xffff)));
	RzILOpPure *op_MUL_280 = MUL(CAST(64, IL_FALSE, CAST(64, MSB(CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(op_AND_258), DUP(op_AND_258))), CAST(32, MSB(DUP(op_AND_258)), DUP(op_AND_258)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_258)), DUP(op_AND_258))), CAST(32, MSB(DUP(op_AND_258)), DUP(op_AND_258))))), CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(DUP(op_AND_258)), DUP(op_AND_258))), CAST(32, MSB(DUP(op_AND_258)), DUP(op_AND_258)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_258)), DUP(op_AND_258))), CAST(32, MSB(DUP(op_AND_258)), DUP(op_AND_258)))))), EXTRACT64(CAST(64, IL_FALSE, CAST(16, IL_FALSE, op_AND_272)), SN(32, 0), SN(32, 16)));
	RzILOpPure *op_LSHIFT_283 = SHIFTL0(CAST(64, IL_FALSE, op_MUL_280), SN(32, 0));
	RzILOpPure *op_ADD_286 = ADD(op_LSHIFT_283, CAST(64, MSB(SN(32, 0x8000)), SN(32, 0x8000)));
	RzILOpPure *op_RSHIFT_288 = SHIFTRA(op_ADD_286, SN(32, 16));
	RzILOpPure *op_ADD_289 = ADD(CAST(64, MSB(CAST(32, MSB(op_AND_250), DUP(op_AND_250))), CAST(32, MSB(DUP(op_AND_250)), DUP(op_AND_250))), op_RSHIFT_288);
	RzILOpPure *op_RSHIFT_298 = SHIFTRA(READ_REG(pkt, Rxx_op, false), SN(32, 0));
	RzILOpPure *op_AND_300 = LOGAND(op_RSHIFT_298, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_306 = SHIFTRA(DUP(Rss), SN(32, 0));
	RzILOpPure *op_AND_308 = LOGAND(op_RSHIFT_306, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_319 = SHIFTRA(DUP(Rtt), SN(32, 16));
	RzILOpPure *op_AND_322 = LOGAND(op_RSHIFT_319, CAST(64, MSB(SN(32, 0xffff)), SN(32, 0xffff)));
	RzILOpPure *op_MUL_330 = MUL(CAST(64, IL_FALSE, CAST(64, MSB(CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(op_AND_308), DUP(op_AND_308))), CAST(32, MSB(DUP(op_AND_308)), DUP(op_AND_308)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_308)), DUP(op_AND_308))), CAST(32, MSB(DUP(op_AND_308)), DUP(op_AND_308))))), CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(DUP(op_AND_308)), DUP(op_AND_308))), CAST(32, MSB(DUP(op_AND_308)), DUP(op_AND_308)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_308)), DUP(op_AND_308))), CAST(32, MSB(DUP(op_AND_308)), DUP(op_AND_308)))))), EXTRACT64(CAST(64, IL_FALSE, CAST(16, IL_FALSE, op_AND_322)), SN(32, 0), SN(32, 16)));
	RzILOpPure *op_LSHIFT_333 = SHIFTL0(CAST(64, IL_FALSE, op_MUL_330), SN(32, 0));
	RzILOpPure *op_ADD_336 = ADD(op_LSHIFT_333, CAST(64, MSB(SN(32, 0x8000)), SN(32, 0x8000)));
	RzILOpPure *op_RSHIFT_338 = SHIFTRA(op_ADD_336, SN(32, 16));
	RzILOpPure *op_ADD_339 = ADD(CAST(64, MSB(CAST(32, MSB(op_AND_300), DUP(op_AND_300))), CAST(32, MSB(DUP(op_AND_300)), DUP(op_AND_300))), op_RSHIFT_338);
	RzILOpPure *op_EQ_340 = EQ(SEXTRACT64(CAST(64, IL_FALSE, op_ADD_289), SN(32, 0), SN(32, 0x20)), op_ADD_339);
	RzILOpPure *op_RSHIFT_392 = SHIFTRA(READ_REG(pkt, Rxx_op, false), SN(32, 0));
	RzILOpPure *op_AND_394 = LOGAND(op_RSHIFT_392, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_400 = SHIFTRA(DUP(Rss), SN(32, 0));
	RzILOpPure *op_AND_402 = LOGAND(op_RSHIFT_400, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_413 = SHIFTRA(DUP(Rtt), SN(32, 16));
	RzILOpPure *op_AND_416 = LOGAND(op_RSHIFT_413, CAST(64, MSB(SN(32, 0xffff)), SN(32, 0xffff)));
	RzILOpPure *op_MUL_424 = MUL(CAST(64, IL_FALSE, CAST(64, MSB(CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(op_AND_402), DUP(op_AND_402))), CAST(32, MSB(DUP(op_AND_402)), DUP(op_AND_402)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_402)), DUP(op_AND_402))), CAST(32, MSB(DUP(op_AND_402)), DUP(op_AND_402))))), CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(DUP(op_AND_402)), DUP(op_AND_402))), CAST(32, MSB(DUP(op_AND_402)), DUP(op_AND_402)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_402)), DUP(op_AND_402))), CAST(32, MSB(DUP(op_AND_402)), DUP(op_AND_402)))))), EXTRACT64(CAST(64, IL_FALSE, CAST(16, IL_FALSE, op_AND_416)), SN(32, 0), SN(32, 16)));
	RzILOpPure *op_LSHIFT_427 = SHIFTL0(CAST(64, IL_FALSE, op_MUL_424), SN(32, 0));
	RzILOpPure *op_ADD_430 = ADD(op_LSHIFT_427, CAST(64, MSB(SN(32, 0x8000)), SN(32, 0x8000)));
	RzILOpPure *op_RSHIFT_432 = SHIFTRA(op_ADD_430, SN(32, 16));
	RzILOpPure *op_ADD_433 = ADD(CAST(64, MSB(CAST(32, MSB(op_AND_394), DUP(op_AND_394))), CAST(32, MSB(DUP(op_AND_394)), DUP(op_AND_394))), op_RSHIFT_432);
	RzILOpPure *op_LT_436 = SLT(op_ADD_433, CAST(64, MSB(SN(32, 0)), SN(32, 0)));
	RzILOpPure *op_LSHIFT_441 = SHIFTL0(SN(64, 1), SN(32, 31));
	RzILOpPure *op_NEG_442 = NEG(op_LSHIFT_441);
	RzILOpPure *op_LSHIFT_447 = SHIFTL0(SN(64, 1), SN(32, 31));
	RzILOpPure *op_SUB_450 = SUB(op_LSHIFT_447, CAST(64, MSB(SN(32, 1)), SN(32, 1)));
	RzILOpPure *cond_451 = ITE(op_LT_436, op_NEG_442, op_SUB_450);
	RzILOpEffect *gcc_expr_452 = BRANCH(op_EQ_340, EMPTY(), set_usr_field_call_388);

	// h_tmp285 = HYB(gcc_expr_if ((sextract64(((ut64) ((st64) ((st32) ((Rxx >> 0x0) & 0xffffffff))) + ((((st64) ((ut64) ((st64) ((st32) ((st64) ((st32) ((Rss >> 0x0) & 0xffffffff)))))) * extract64(((ut64) ((ut16) ((Rtt >> 0x10) & ((st64) 0xffff)))), 0x0, 0x10)) << 0x0) + ((st64) 0x8000) >> 0x10)), 0x0, 0x20) == ((st64) ((st32) ((Rxx >> 0x0) & 0xffffffff))) + ((((st64) ((ut64) ((st64) ((st32) ((st64) ((st32) ((Rss >> 0x0) & 0xffffffff)))))) * extract64(((ut64) ((ut16) ((Rtt >> 0x10) & ((st64) 0xffff)))), 0x0, 0x10)) << 0x0) + ((st64) 0x8000) >> 0x10))) {{}} else {set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, ((ut32) 0x1))}, ((((st64) ((st32) ((Rxx >> 0x0) & 0xffffffff))) + ((((st64) ((ut64) ((st64) ((st32) ((st64) ((st32) ((Rss >> 0x0) & 0xffffffff)))))) * extract64(((ut64) ((ut16) ((Rtt >> 0x10) & ((st64) 0xffff)))), 0x0, 0x10)) << 0x0) + ((st64) 0x8000) >> 0x10) < ((st64) 0x0)) ? (-(0x1 << 0x1f)) : (0x1 << 0x1f) - ((st64) 0x1)));
	RzILOpEffect *op_ASSIGN_hybrid_tmp_454 = SETL("h_tmp285", cond_451);

	// seq(HYB(gcc_expr_if ((sextract64(((ut64) ((st64) ((st32) ((Rxx > ...;
	RzILOpEffect *seq_455 = SEQN(2, gcc_expr_452, op_ASSIGN_hybrid_tmp_454);

	// Rxx = ((Rxx & (~(0xffffffff << 0x0))) | ((((sextract64(((ut64) ((st64) ((st32) ((Rxx >> 0x0) & 0xffffffff))) + ((((st64) ((ut64) ((st64) ((st32) ((st64) ((st32) ((Rss >> 0x0) & 0xffffffff)))))) * extract64(((ut64) ((ut16) ((Rtt >> 0x10) & ((st64) 0xffff)))), 0x0, 0x10)) << 0x0) + ((st64) 0x8000) >> 0x10)), 0x0, 0x20) == ((st64) ((st32) ((Rxx >> 0x0) & 0xffffffff))) + ((((st64) ((ut64) ((st64) ((st32) ((st64) ((st32) ((Rss >> 0x0) & 0xffffffff)))))) * extract64(((ut64) ((ut16) ((Rtt >> 0x10) & ((st64) 0xffff)))), 0x0, 0x10)) << 0x0) + ((st64) 0x8000) >> 0x10)) ? ((st64) ((st32) ((Rxx >> 0x0) & 0xffffffff))) + ((((st64) ((ut64) ((st64) ((st32) ((st64) ((st32) ((Rss >> 0x0) & 0xffffffff)))))) * extract64(((ut64) ((ut16) ((Rtt >> 0x10) & ((st64) 0xffff)))), 0x0, 0x10)) << 0x0) + ((st64) 0x8000) >> 0x10) : h_tmp285) & 0xffffffff) << 0x0));
	RzILOpPure *op_LSHIFT_239 = SHIFTL0(SN(64, 0xffffffff), SN(32, 0));
	RzILOpPure *op_NOT_240 = LOGNOT(op_LSHIFT_239);
	RzILOpPure *op_AND_241 = LOGAND(READ_REG(pkt, Rxx_op, false), op_NOT_240);
	RzILOpPure *op_RSHIFT_344 = SHIFTRA(READ_REG(pkt, Rxx_op, false), SN(32, 0));
	RzILOpPure *op_AND_346 = LOGAND(op_RSHIFT_344, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_352 = SHIFTRA(DUP(Rss), SN(32, 0));
	RzILOpPure *op_AND_354 = LOGAND(op_RSHIFT_352, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_365 = SHIFTRA(DUP(Rtt), SN(32, 16));
	RzILOpPure *op_AND_368 = LOGAND(op_RSHIFT_365, CAST(64, MSB(SN(32, 0xffff)), SN(32, 0xffff)));
	RzILOpPure *op_MUL_376 = MUL(CAST(64, IL_FALSE, CAST(64, MSB(CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(op_AND_354), DUP(op_AND_354))), CAST(32, MSB(DUP(op_AND_354)), DUP(op_AND_354)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_354)), DUP(op_AND_354))), CAST(32, MSB(DUP(op_AND_354)), DUP(op_AND_354))))), CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(DUP(op_AND_354)), DUP(op_AND_354))), CAST(32, MSB(DUP(op_AND_354)), DUP(op_AND_354)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_354)), DUP(op_AND_354))), CAST(32, MSB(DUP(op_AND_354)), DUP(op_AND_354)))))), EXTRACT64(CAST(64, IL_FALSE, CAST(16, IL_FALSE, op_AND_368)), SN(32, 0), SN(32, 16)));
	RzILOpPure *op_LSHIFT_379 = SHIFTL0(CAST(64, IL_FALSE, op_MUL_376), SN(32, 0));
	RzILOpPure *op_ADD_382 = ADD(op_LSHIFT_379, CAST(64, MSB(SN(32, 0x8000)), SN(32, 0x8000)));
	RzILOpPure *op_RSHIFT_384 = SHIFTRA(op_ADD_382, SN(32, 16));
	RzILOpPure *op_ADD_385 = ADD(CAST(64, MSB(CAST(32, MSB(op_AND_346), DUP(op_AND_346))), CAST(32, MSB(DUP(op_AND_346)), DUP(op_AND_346))), op_RSHIFT_384);
	RzILOpPure *cond_456 = ITE(DUP(op_EQ_340), op_ADD_385, VARL("h_tmp285"));
	RzILOpPure *op_AND_458 = LOGAND(cond_456, SN(64, 0xffffffff));
	RzILOpPure *op_LSHIFT_462 = SHIFTL0(op_AND_458, SN(32, 0));
	RzILOpPure *op_OR_463 = LOGOR(op_AND_241, op_LSHIFT_462);
	RzILOpEffect *op_ASSIGN_464 = WRITE_REG(bundle, Rxx_op, op_OR_463);

	// seq(seq(HYB(gcc_expr_if ((sextract64(((ut64) ((st64) ((st32) ((R ...;
	RzILOpEffect *seq_465 = SEQN(2, seq_455, op_ASSIGN_464);

	RzILOpEffect *instruction_sequence = SEQN(2, seq_233, seq_465);
	return instruction_sequence;
}

// Rxx += vmpywouh(Rss,Rtt):<<1:rnd:sat
RzILOpEffect *hex_il_op_m2_mmacuhs_rs1(HexInsnPktBundle *bundle) {
	const HexInsn *hi = bundle->insn;
	HexPkt *pkt = bundle->pkt;
	// READ
	const HexOp *Rxx_op = ISA2REG(hi, 'x', false);

	const HexOp *Rss_op = ISA2REG(hi, 's', false);
	RzILOpPure *Rss = READ_REG(pkt, Rss_op, false);
	const HexOp *Rtt_op = ISA2REG(hi, 't', false);
	RzILOpPure *Rtt = READ_REG(pkt, Rtt_op, false);

	// set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, ((ut32) 0x1));
	RzILOpEffect *set_usr_field_call_156 = hex_set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, CAST(32, IL_FALSE, SN(32, 1)));

	// HYB(gcc_expr_if ((sextract64(((ut64) ((st64) ((st32) ((Rxx >> 0x20) & 0xffffffff))) + ((((st64) ((ut64) ((st64) ((st32) ((st64) ((st32) ((Rss >> 0x20) & 0xffffffff)))))) * extract64(((ut64) ((ut16) ((Rtt >> 0x30) & ((st64) 0xffff)))), 0x0, 0x10)) << 0x1) + ((st64) 0x8000) >> 0x10)), 0x0, 0x20) == ((st64) ((st32) ((Rxx >> 0x20) & 0xffffffff))) + ((((st64) ((ut64) ((st64) ((st32) ((st64) ((st32) ((Rss >> 0x20) & 0xffffffff)))))) * extract64(((ut64) ((ut16) ((Rtt >> 0x30) & ((st64) 0xffff)))), 0x0, 0x10)) << 0x1) + ((st64) 0x8000) >> 0x10))) {{}} else {set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, ((ut32) 0x1))}, ((((st64) ((st32) ((Rxx >> 0x20) & 0xffffffff))) + ((((st64) ((ut64) ((st64) ((st32) ((st64) ((st32) ((Rss >> 0x20) & 0xffffffff)))))) * extract64(((ut64) ((ut16) ((Rtt >> 0x30) & ((st64) 0xffff)))), 0x0, 0x10)) << 0x1) + ((st64) 0x8000) >> 0x10) < ((st64) 0x0)) ? (-(0x1 << 0x1f)) : (0x1 << 0x1f) - ((st64) 0x1)));
	RzILOpPure *op_RSHIFT_14 = SHIFTRA(READ_REG(pkt, Rxx_op, false), SN(32, 0x20));
	RzILOpPure *op_AND_16 = LOGAND(op_RSHIFT_14, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_23 = SHIFTRA(Rss, SN(32, 0x20));
	RzILOpPure *op_AND_25 = LOGAND(op_RSHIFT_23, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_37 = SHIFTRA(Rtt, SN(32, 0x30));
	RzILOpPure *op_AND_40 = LOGAND(op_RSHIFT_37, CAST(64, MSB(SN(32, 0xffff)), SN(32, 0xffff)));
	RzILOpPure *op_MUL_48 = MUL(CAST(64, IL_FALSE, CAST(64, MSB(CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(op_AND_25), DUP(op_AND_25))), CAST(32, MSB(DUP(op_AND_25)), DUP(op_AND_25)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_25)), DUP(op_AND_25))), CAST(32, MSB(DUP(op_AND_25)), DUP(op_AND_25))))), CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(DUP(op_AND_25)), DUP(op_AND_25))), CAST(32, MSB(DUP(op_AND_25)), DUP(op_AND_25)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_25)), DUP(op_AND_25))), CAST(32, MSB(DUP(op_AND_25)), DUP(op_AND_25)))))), EXTRACT64(CAST(64, IL_FALSE, CAST(16, IL_FALSE, op_AND_40)), SN(32, 0), SN(32, 16)));
	RzILOpPure *op_LSHIFT_51 = SHIFTL0(CAST(64, IL_FALSE, op_MUL_48), SN(32, 1));
	RzILOpPure *op_ADD_54 = ADD(op_LSHIFT_51, CAST(64, MSB(SN(32, 0x8000)), SN(32, 0x8000)));
	RzILOpPure *op_RSHIFT_56 = SHIFTRA(op_ADD_54, SN(32, 16));
	RzILOpPure *op_ADD_57 = ADD(CAST(64, MSB(CAST(32, MSB(op_AND_16), DUP(op_AND_16))), CAST(32, MSB(DUP(op_AND_16)), DUP(op_AND_16))), op_RSHIFT_56);
	RzILOpPure *op_RSHIFT_66 = SHIFTRA(READ_REG(pkt, Rxx_op, false), SN(32, 0x20));
	RzILOpPure *op_AND_68 = LOGAND(op_RSHIFT_66, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_74 = SHIFTRA(DUP(Rss), SN(32, 0x20));
	RzILOpPure *op_AND_76 = LOGAND(op_RSHIFT_74, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_87 = SHIFTRA(DUP(Rtt), SN(32, 0x30));
	RzILOpPure *op_AND_90 = LOGAND(op_RSHIFT_87, CAST(64, MSB(SN(32, 0xffff)), SN(32, 0xffff)));
	RzILOpPure *op_MUL_98 = MUL(CAST(64, IL_FALSE, CAST(64, MSB(CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(op_AND_76), DUP(op_AND_76))), CAST(32, MSB(DUP(op_AND_76)), DUP(op_AND_76)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_76)), DUP(op_AND_76))), CAST(32, MSB(DUP(op_AND_76)), DUP(op_AND_76))))), CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(DUP(op_AND_76)), DUP(op_AND_76))), CAST(32, MSB(DUP(op_AND_76)), DUP(op_AND_76)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_76)), DUP(op_AND_76))), CAST(32, MSB(DUP(op_AND_76)), DUP(op_AND_76)))))), EXTRACT64(CAST(64, IL_FALSE, CAST(16, IL_FALSE, op_AND_90)), SN(32, 0), SN(32, 16)));
	RzILOpPure *op_LSHIFT_101 = SHIFTL0(CAST(64, IL_FALSE, op_MUL_98), SN(32, 1));
	RzILOpPure *op_ADD_104 = ADD(op_LSHIFT_101, CAST(64, MSB(SN(32, 0x8000)), SN(32, 0x8000)));
	RzILOpPure *op_RSHIFT_106 = SHIFTRA(op_ADD_104, SN(32, 16));
	RzILOpPure *op_ADD_107 = ADD(CAST(64, MSB(CAST(32, MSB(op_AND_68), DUP(op_AND_68))), CAST(32, MSB(DUP(op_AND_68)), DUP(op_AND_68))), op_RSHIFT_106);
	RzILOpPure *op_EQ_108 = EQ(SEXTRACT64(CAST(64, IL_FALSE, op_ADD_57), SN(32, 0), SN(32, 0x20)), op_ADD_107);
	RzILOpPure *op_RSHIFT_160 = SHIFTRA(READ_REG(pkt, Rxx_op, false), SN(32, 0x20));
	RzILOpPure *op_AND_162 = LOGAND(op_RSHIFT_160, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_168 = SHIFTRA(DUP(Rss), SN(32, 0x20));
	RzILOpPure *op_AND_170 = LOGAND(op_RSHIFT_168, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_181 = SHIFTRA(DUP(Rtt), SN(32, 0x30));
	RzILOpPure *op_AND_184 = LOGAND(op_RSHIFT_181, CAST(64, MSB(SN(32, 0xffff)), SN(32, 0xffff)));
	RzILOpPure *op_MUL_192 = MUL(CAST(64, IL_FALSE, CAST(64, MSB(CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(op_AND_170), DUP(op_AND_170))), CAST(32, MSB(DUP(op_AND_170)), DUP(op_AND_170)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_170)), DUP(op_AND_170))), CAST(32, MSB(DUP(op_AND_170)), DUP(op_AND_170))))), CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(DUP(op_AND_170)), DUP(op_AND_170))), CAST(32, MSB(DUP(op_AND_170)), DUP(op_AND_170)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_170)), DUP(op_AND_170))), CAST(32, MSB(DUP(op_AND_170)), DUP(op_AND_170)))))), EXTRACT64(CAST(64, IL_FALSE, CAST(16, IL_FALSE, op_AND_184)), SN(32, 0), SN(32, 16)));
	RzILOpPure *op_LSHIFT_195 = SHIFTL0(CAST(64, IL_FALSE, op_MUL_192), SN(32, 1));
	RzILOpPure *op_ADD_198 = ADD(op_LSHIFT_195, CAST(64, MSB(SN(32, 0x8000)), SN(32, 0x8000)));
	RzILOpPure *op_RSHIFT_200 = SHIFTRA(op_ADD_198, SN(32, 16));
	RzILOpPure *op_ADD_201 = ADD(CAST(64, MSB(CAST(32, MSB(op_AND_162), DUP(op_AND_162))), CAST(32, MSB(DUP(op_AND_162)), DUP(op_AND_162))), op_RSHIFT_200);
	RzILOpPure *op_LT_204 = SLT(op_ADD_201, CAST(64, MSB(SN(32, 0)), SN(32, 0)));
	RzILOpPure *op_LSHIFT_209 = SHIFTL0(SN(64, 1), SN(32, 31));
	RzILOpPure *op_NEG_210 = NEG(op_LSHIFT_209);
	RzILOpPure *op_LSHIFT_215 = SHIFTL0(SN(64, 1), SN(32, 31));
	RzILOpPure *op_SUB_218 = SUB(op_LSHIFT_215, CAST(64, MSB(SN(32, 1)), SN(32, 1)));
	RzILOpPure *cond_219 = ITE(op_LT_204, op_NEG_210, op_SUB_218);
	RzILOpEffect *gcc_expr_220 = BRANCH(op_EQ_108, EMPTY(), set_usr_field_call_156);

	// h_tmp286 = HYB(gcc_expr_if ((sextract64(((ut64) ((st64) ((st32) ((Rxx >> 0x20) & 0xffffffff))) + ((((st64) ((ut64) ((st64) ((st32) ((st64) ((st32) ((Rss >> 0x20) & 0xffffffff)))))) * extract64(((ut64) ((ut16) ((Rtt >> 0x30) & ((st64) 0xffff)))), 0x0, 0x10)) << 0x1) + ((st64) 0x8000) >> 0x10)), 0x0, 0x20) == ((st64) ((st32) ((Rxx >> 0x20) & 0xffffffff))) + ((((st64) ((ut64) ((st64) ((st32) ((st64) ((st32) ((Rss >> 0x20) & 0xffffffff)))))) * extract64(((ut64) ((ut16) ((Rtt >> 0x30) & ((st64) 0xffff)))), 0x0, 0x10)) << 0x1) + ((st64) 0x8000) >> 0x10))) {{}} else {set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, ((ut32) 0x1))}, ((((st64) ((st32) ((Rxx >> 0x20) & 0xffffffff))) + ((((st64) ((ut64) ((st64) ((st32) ((st64) ((st32) ((Rss >> 0x20) & 0xffffffff)))))) * extract64(((ut64) ((ut16) ((Rtt >> 0x30) & ((st64) 0xffff)))), 0x0, 0x10)) << 0x1) + ((st64) 0x8000) >> 0x10) < ((st64) 0x0)) ? (-(0x1 << 0x1f)) : (0x1 << 0x1f) - ((st64) 0x1)));
	RzILOpEffect *op_ASSIGN_hybrid_tmp_222 = SETL("h_tmp286", cond_219);

	// seq(HYB(gcc_expr_if ((sextract64(((ut64) ((st64) ((st32) ((Rxx > ...;
	RzILOpEffect *seq_223 = SEQN(2, gcc_expr_220, op_ASSIGN_hybrid_tmp_222);

	// Rxx = ((Rxx & (~(0xffffffff << 0x20))) | ((((sextract64(((ut64) ((st64) ((st32) ((Rxx >> 0x20) & 0xffffffff))) + ((((st64) ((ut64) ((st64) ((st32) ((st64) ((st32) ((Rss >> 0x20) & 0xffffffff)))))) * extract64(((ut64) ((ut16) ((Rtt >> 0x30) & ((st64) 0xffff)))), 0x0, 0x10)) << 0x1) + ((st64) 0x8000) >> 0x10)), 0x0, 0x20) == ((st64) ((st32) ((Rxx >> 0x20) & 0xffffffff))) + ((((st64) ((ut64) ((st64) ((st32) ((st64) ((st32) ((Rss >> 0x20) & 0xffffffff)))))) * extract64(((ut64) ((ut16) ((Rtt >> 0x30) & ((st64) 0xffff)))), 0x0, 0x10)) << 0x1) + ((st64) 0x8000) >> 0x10)) ? ((st64) ((st32) ((Rxx >> 0x20) & 0xffffffff))) + ((((st64) ((ut64) ((st64) ((st32) ((st64) ((st32) ((Rss >> 0x20) & 0xffffffff)))))) * extract64(((ut64) ((ut16) ((Rtt >> 0x30) & ((st64) 0xffff)))), 0x0, 0x10)) << 0x1) + ((st64) 0x8000) >> 0x10) : h_tmp286) & 0xffffffff) << 0x20));
	RzILOpPure *op_LSHIFT_5 = SHIFTL0(SN(64, 0xffffffff), SN(32, 0x20));
	RzILOpPure *op_NOT_6 = LOGNOT(op_LSHIFT_5);
	RzILOpPure *op_AND_7 = LOGAND(READ_REG(pkt, Rxx_op, false), op_NOT_6);
	RzILOpPure *op_RSHIFT_112 = SHIFTRA(READ_REG(pkt, Rxx_op, false), SN(32, 0x20));
	RzILOpPure *op_AND_114 = LOGAND(op_RSHIFT_112, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_120 = SHIFTRA(DUP(Rss), SN(32, 0x20));
	RzILOpPure *op_AND_122 = LOGAND(op_RSHIFT_120, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_133 = SHIFTRA(DUP(Rtt), SN(32, 0x30));
	RzILOpPure *op_AND_136 = LOGAND(op_RSHIFT_133, CAST(64, MSB(SN(32, 0xffff)), SN(32, 0xffff)));
	RzILOpPure *op_MUL_144 = MUL(CAST(64, IL_FALSE, CAST(64, MSB(CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(op_AND_122), DUP(op_AND_122))), CAST(32, MSB(DUP(op_AND_122)), DUP(op_AND_122)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_122)), DUP(op_AND_122))), CAST(32, MSB(DUP(op_AND_122)), DUP(op_AND_122))))), CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(DUP(op_AND_122)), DUP(op_AND_122))), CAST(32, MSB(DUP(op_AND_122)), DUP(op_AND_122)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_122)), DUP(op_AND_122))), CAST(32, MSB(DUP(op_AND_122)), DUP(op_AND_122)))))), EXTRACT64(CAST(64, IL_FALSE, CAST(16, IL_FALSE, op_AND_136)), SN(32, 0), SN(32, 16)));
	RzILOpPure *op_LSHIFT_147 = SHIFTL0(CAST(64, IL_FALSE, op_MUL_144), SN(32, 1));
	RzILOpPure *op_ADD_150 = ADD(op_LSHIFT_147, CAST(64, MSB(SN(32, 0x8000)), SN(32, 0x8000)));
	RzILOpPure *op_RSHIFT_152 = SHIFTRA(op_ADD_150, SN(32, 16));
	RzILOpPure *op_ADD_153 = ADD(CAST(64, MSB(CAST(32, MSB(op_AND_114), DUP(op_AND_114))), CAST(32, MSB(DUP(op_AND_114)), DUP(op_AND_114))), op_RSHIFT_152);
	RzILOpPure *cond_224 = ITE(DUP(op_EQ_108), op_ADD_153, VARL("h_tmp286"));
	RzILOpPure *op_AND_226 = LOGAND(cond_224, SN(64, 0xffffffff));
	RzILOpPure *op_LSHIFT_230 = SHIFTL0(op_AND_226, SN(32, 0x20));
	RzILOpPure *op_OR_231 = LOGOR(op_AND_7, op_LSHIFT_230);
	RzILOpEffect *op_ASSIGN_232 = WRITE_REG(bundle, Rxx_op, op_OR_231);

	// seq(seq(HYB(gcc_expr_if ((sextract64(((ut64) ((st64) ((st32) ((R ...;
	RzILOpEffect *seq_233 = SEQN(2, seq_223, op_ASSIGN_232);

	// set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, ((ut32) 0x1));
	RzILOpEffect *set_usr_field_call_388 = hex_set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, CAST(32, IL_FALSE, SN(32, 1)));

	// HYB(gcc_expr_if ((sextract64(((ut64) ((st64) ((st32) ((Rxx >> 0x0) & 0xffffffff))) + ((((st64) ((ut64) ((st64) ((st32) ((st64) ((st32) ((Rss >> 0x0) & 0xffffffff)))))) * extract64(((ut64) ((ut16) ((Rtt >> 0x10) & ((st64) 0xffff)))), 0x0, 0x10)) << 0x1) + ((st64) 0x8000) >> 0x10)), 0x0, 0x20) == ((st64) ((st32) ((Rxx >> 0x0) & 0xffffffff))) + ((((st64) ((ut64) ((st64) ((st32) ((st64) ((st32) ((Rss >> 0x0) & 0xffffffff)))))) * extract64(((ut64) ((ut16) ((Rtt >> 0x10) & ((st64) 0xffff)))), 0x0, 0x10)) << 0x1) + ((st64) 0x8000) >> 0x10))) {{}} else {set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, ((ut32) 0x1))}, ((((st64) ((st32) ((Rxx >> 0x0) & 0xffffffff))) + ((((st64) ((ut64) ((st64) ((st32) ((st64) ((st32) ((Rss >> 0x0) & 0xffffffff)))))) * extract64(((ut64) ((ut16) ((Rtt >> 0x10) & ((st64) 0xffff)))), 0x0, 0x10)) << 0x1) + ((st64) 0x8000) >> 0x10) < ((st64) 0x0)) ? (-(0x1 << 0x1f)) : (0x1 << 0x1f) - ((st64) 0x1)));
	RzILOpPure *op_RSHIFT_248 = SHIFTRA(READ_REG(pkt, Rxx_op, false), SN(32, 0));
	RzILOpPure *op_AND_250 = LOGAND(op_RSHIFT_248, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_256 = SHIFTRA(DUP(Rss), SN(32, 0));
	RzILOpPure *op_AND_258 = LOGAND(op_RSHIFT_256, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_269 = SHIFTRA(DUP(Rtt), SN(32, 16));
	RzILOpPure *op_AND_272 = LOGAND(op_RSHIFT_269, CAST(64, MSB(SN(32, 0xffff)), SN(32, 0xffff)));
	RzILOpPure *op_MUL_280 = MUL(CAST(64, IL_FALSE, CAST(64, MSB(CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(op_AND_258), DUP(op_AND_258))), CAST(32, MSB(DUP(op_AND_258)), DUP(op_AND_258)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_258)), DUP(op_AND_258))), CAST(32, MSB(DUP(op_AND_258)), DUP(op_AND_258))))), CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(DUP(op_AND_258)), DUP(op_AND_258))), CAST(32, MSB(DUP(op_AND_258)), DUP(op_AND_258)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_258)), DUP(op_AND_258))), CAST(32, MSB(DUP(op_AND_258)), DUP(op_AND_258)))))), EXTRACT64(CAST(64, IL_FALSE, CAST(16, IL_FALSE, op_AND_272)), SN(32, 0), SN(32, 16)));
	RzILOpPure *op_LSHIFT_283 = SHIFTL0(CAST(64, IL_FALSE, op_MUL_280), SN(32, 1));
	RzILOpPure *op_ADD_286 = ADD(op_LSHIFT_283, CAST(64, MSB(SN(32, 0x8000)), SN(32, 0x8000)));
	RzILOpPure *op_RSHIFT_288 = SHIFTRA(op_ADD_286, SN(32, 16));
	RzILOpPure *op_ADD_289 = ADD(CAST(64, MSB(CAST(32, MSB(op_AND_250), DUP(op_AND_250))), CAST(32, MSB(DUP(op_AND_250)), DUP(op_AND_250))), op_RSHIFT_288);
	RzILOpPure *op_RSHIFT_298 = SHIFTRA(READ_REG(pkt, Rxx_op, false), SN(32, 0));
	RzILOpPure *op_AND_300 = LOGAND(op_RSHIFT_298, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_306 = SHIFTRA(DUP(Rss), SN(32, 0));
	RzILOpPure *op_AND_308 = LOGAND(op_RSHIFT_306, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_319 = SHIFTRA(DUP(Rtt), SN(32, 16));
	RzILOpPure *op_AND_322 = LOGAND(op_RSHIFT_319, CAST(64, MSB(SN(32, 0xffff)), SN(32, 0xffff)));
	RzILOpPure *op_MUL_330 = MUL(CAST(64, IL_FALSE, CAST(64, MSB(CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(op_AND_308), DUP(op_AND_308))), CAST(32, MSB(DUP(op_AND_308)), DUP(op_AND_308)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_308)), DUP(op_AND_308))), CAST(32, MSB(DUP(op_AND_308)), DUP(op_AND_308))))), CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(DUP(op_AND_308)), DUP(op_AND_308))), CAST(32, MSB(DUP(op_AND_308)), DUP(op_AND_308)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_308)), DUP(op_AND_308))), CAST(32, MSB(DUP(op_AND_308)), DUP(op_AND_308)))))), EXTRACT64(CAST(64, IL_FALSE, CAST(16, IL_FALSE, op_AND_322)), SN(32, 0), SN(32, 16)));
	RzILOpPure *op_LSHIFT_333 = SHIFTL0(CAST(64, IL_FALSE, op_MUL_330), SN(32, 1));
	RzILOpPure *op_ADD_336 = ADD(op_LSHIFT_333, CAST(64, MSB(SN(32, 0x8000)), SN(32, 0x8000)));
	RzILOpPure *op_RSHIFT_338 = SHIFTRA(op_ADD_336, SN(32, 16));
	RzILOpPure *op_ADD_339 = ADD(CAST(64, MSB(CAST(32, MSB(op_AND_300), DUP(op_AND_300))), CAST(32, MSB(DUP(op_AND_300)), DUP(op_AND_300))), op_RSHIFT_338);
	RzILOpPure *op_EQ_340 = EQ(SEXTRACT64(CAST(64, IL_FALSE, op_ADD_289), SN(32, 0), SN(32, 0x20)), op_ADD_339);
	RzILOpPure *op_RSHIFT_392 = SHIFTRA(READ_REG(pkt, Rxx_op, false), SN(32, 0));
	RzILOpPure *op_AND_394 = LOGAND(op_RSHIFT_392, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_400 = SHIFTRA(DUP(Rss), SN(32, 0));
	RzILOpPure *op_AND_402 = LOGAND(op_RSHIFT_400, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_413 = SHIFTRA(DUP(Rtt), SN(32, 16));
	RzILOpPure *op_AND_416 = LOGAND(op_RSHIFT_413, CAST(64, MSB(SN(32, 0xffff)), SN(32, 0xffff)));
	RzILOpPure *op_MUL_424 = MUL(CAST(64, IL_FALSE, CAST(64, MSB(CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(op_AND_402), DUP(op_AND_402))), CAST(32, MSB(DUP(op_AND_402)), DUP(op_AND_402)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_402)), DUP(op_AND_402))), CAST(32, MSB(DUP(op_AND_402)), DUP(op_AND_402))))), CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(DUP(op_AND_402)), DUP(op_AND_402))), CAST(32, MSB(DUP(op_AND_402)), DUP(op_AND_402)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_402)), DUP(op_AND_402))), CAST(32, MSB(DUP(op_AND_402)), DUP(op_AND_402)))))), EXTRACT64(CAST(64, IL_FALSE, CAST(16, IL_FALSE, op_AND_416)), SN(32, 0), SN(32, 16)));
	RzILOpPure *op_LSHIFT_427 = SHIFTL0(CAST(64, IL_FALSE, op_MUL_424), SN(32, 1));
	RzILOpPure *op_ADD_430 = ADD(op_LSHIFT_427, CAST(64, MSB(SN(32, 0x8000)), SN(32, 0x8000)));
	RzILOpPure *op_RSHIFT_432 = SHIFTRA(op_ADD_430, SN(32, 16));
	RzILOpPure *op_ADD_433 = ADD(CAST(64, MSB(CAST(32, MSB(op_AND_394), DUP(op_AND_394))), CAST(32, MSB(DUP(op_AND_394)), DUP(op_AND_394))), op_RSHIFT_432);
	RzILOpPure *op_LT_436 = SLT(op_ADD_433, CAST(64, MSB(SN(32, 0)), SN(32, 0)));
	RzILOpPure *op_LSHIFT_441 = SHIFTL0(SN(64, 1), SN(32, 31));
	RzILOpPure *op_NEG_442 = NEG(op_LSHIFT_441);
	RzILOpPure *op_LSHIFT_447 = SHIFTL0(SN(64, 1), SN(32, 31));
	RzILOpPure *op_SUB_450 = SUB(op_LSHIFT_447, CAST(64, MSB(SN(32, 1)), SN(32, 1)));
	RzILOpPure *cond_451 = ITE(op_LT_436, op_NEG_442, op_SUB_450);
	RzILOpEffect *gcc_expr_452 = BRANCH(op_EQ_340, EMPTY(), set_usr_field_call_388);

	// h_tmp287 = HYB(gcc_expr_if ((sextract64(((ut64) ((st64) ((st32) ((Rxx >> 0x0) & 0xffffffff))) + ((((st64) ((ut64) ((st64) ((st32) ((st64) ((st32) ((Rss >> 0x0) & 0xffffffff)))))) * extract64(((ut64) ((ut16) ((Rtt >> 0x10) & ((st64) 0xffff)))), 0x0, 0x10)) << 0x1) + ((st64) 0x8000) >> 0x10)), 0x0, 0x20) == ((st64) ((st32) ((Rxx >> 0x0) & 0xffffffff))) + ((((st64) ((ut64) ((st64) ((st32) ((st64) ((st32) ((Rss >> 0x0) & 0xffffffff)))))) * extract64(((ut64) ((ut16) ((Rtt >> 0x10) & ((st64) 0xffff)))), 0x0, 0x10)) << 0x1) + ((st64) 0x8000) >> 0x10))) {{}} else {set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, ((ut32) 0x1))}, ((((st64) ((st32) ((Rxx >> 0x0) & 0xffffffff))) + ((((st64) ((ut64) ((st64) ((st32) ((st64) ((st32) ((Rss >> 0x0) & 0xffffffff)))))) * extract64(((ut64) ((ut16) ((Rtt >> 0x10) & ((st64) 0xffff)))), 0x0, 0x10)) << 0x1) + ((st64) 0x8000) >> 0x10) < ((st64) 0x0)) ? (-(0x1 << 0x1f)) : (0x1 << 0x1f) - ((st64) 0x1)));
	RzILOpEffect *op_ASSIGN_hybrid_tmp_454 = SETL("h_tmp287", cond_451);

	// seq(HYB(gcc_expr_if ((sextract64(((ut64) ((st64) ((st32) ((Rxx > ...;
	RzILOpEffect *seq_455 = SEQN(2, gcc_expr_452, op_ASSIGN_hybrid_tmp_454);

	// Rxx = ((Rxx & (~(0xffffffff << 0x0))) | ((((sextract64(((ut64) ((st64) ((st32) ((Rxx >> 0x0) & 0xffffffff))) + ((((st64) ((ut64) ((st64) ((st32) ((st64) ((st32) ((Rss >> 0x0) & 0xffffffff)))))) * extract64(((ut64) ((ut16) ((Rtt >> 0x10) & ((st64) 0xffff)))), 0x0, 0x10)) << 0x1) + ((st64) 0x8000) >> 0x10)), 0x0, 0x20) == ((st64) ((st32) ((Rxx >> 0x0) & 0xffffffff))) + ((((st64) ((ut64) ((st64) ((st32) ((st64) ((st32) ((Rss >> 0x0) & 0xffffffff)))))) * extract64(((ut64) ((ut16) ((Rtt >> 0x10) & ((st64) 0xffff)))), 0x0, 0x10)) << 0x1) + ((st64) 0x8000) >> 0x10)) ? ((st64) ((st32) ((Rxx >> 0x0) & 0xffffffff))) + ((((st64) ((ut64) ((st64) ((st32) ((st64) ((st32) ((Rss >> 0x0) & 0xffffffff)))))) * extract64(((ut64) ((ut16) ((Rtt >> 0x10) & ((st64) 0xffff)))), 0x0, 0x10)) << 0x1) + ((st64) 0x8000) >> 0x10) : h_tmp287) & 0xffffffff) << 0x0));
	RzILOpPure *op_LSHIFT_239 = SHIFTL0(SN(64, 0xffffffff), SN(32, 0));
	RzILOpPure *op_NOT_240 = LOGNOT(op_LSHIFT_239);
	RzILOpPure *op_AND_241 = LOGAND(READ_REG(pkt, Rxx_op, false), op_NOT_240);
	RzILOpPure *op_RSHIFT_344 = SHIFTRA(READ_REG(pkt, Rxx_op, false), SN(32, 0));
	RzILOpPure *op_AND_346 = LOGAND(op_RSHIFT_344, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_352 = SHIFTRA(DUP(Rss), SN(32, 0));
	RzILOpPure *op_AND_354 = LOGAND(op_RSHIFT_352, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_365 = SHIFTRA(DUP(Rtt), SN(32, 16));
	RzILOpPure *op_AND_368 = LOGAND(op_RSHIFT_365, CAST(64, MSB(SN(32, 0xffff)), SN(32, 0xffff)));
	RzILOpPure *op_MUL_376 = MUL(CAST(64, IL_FALSE, CAST(64, MSB(CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(op_AND_354), DUP(op_AND_354))), CAST(32, MSB(DUP(op_AND_354)), DUP(op_AND_354)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_354)), DUP(op_AND_354))), CAST(32, MSB(DUP(op_AND_354)), DUP(op_AND_354))))), CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(DUP(op_AND_354)), DUP(op_AND_354))), CAST(32, MSB(DUP(op_AND_354)), DUP(op_AND_354)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_354)), DUP(op_AND_354))), CAST(32, MSB(DUP(op_AND_354)), DUP(op_AND_354)))))), EXTRACT64(CAST(64, IL_FALSE, CAST(16, IL_FALSE, op_AND_368)), SN(32, 0), SN(32, 16)));
	RzILOpPure *op_LSHIFT_379 = SHIFTL0(CAST(64, IL_FALSE, op_MUL_376), SN(32, 1));
	RzILOpPure *op_ADD_382 = ADD(op_LSHIFT_379, CAST(64, MSB(SN(32, 0x8000)), SN(32, 0x8000)));
	RzILOpPure *op_RSHIFT_384 = SHIFTRA(op_ADD_382, SN(32, 16));
	RzILOpPure *op_ADD_385 = ADD(CAST(64, MSB(CAST(32, MSB(op_AND_346), DUP(op_AND_346))), CAST(32, MSB(DUP(op_AND_346)), DUP(op_AND_346))), op_RSHIFT_384);
	RzILOpPure *cond_456 = ITE(DUP(op_EQ_340), op_ADD_385, VARL("h_tmp287"));
	RzILOpPure *op_AND_458 = LOGAND(cond_456, SN(64, 0xffffffff));
	RzILOpPure *op_LSHIFT_462 = SHIFTL0(op_AND_458, SN(32, 0));
	RzILOpPure *op_OR_463 = LOGOR(op_AND_241, op_LSHIFT_462);
	RzILOpEffect *op_ASSIGN_464 = WRITE_REG(bundle, Rxx_op, op_OR_463);

	// seq(seq(HYB(gcc_expr_if ((sextract64(((ut64) ((st64) ((st32) ((R ...;
	RzILOpEffect *seq_465 = SEQN(2, seq_455, op_ASSIGN_464);

	RzILOpEffect *instruction_sequence = SEQN(2, seq_233, seq_465);
	return instruction_sequence;
}

// Rxx += vmpywouh(Rss,Rtt):sat
RzILOpEffect *hex_il_op_m2_mmacuhs_s0(HexInsnPktBundle *bundle) {
	const HexInsn *hi = bundle->insn;
	HexPkt *pkt = bundle->pkt;
	// READ
	const HexOp *Rxx_op = ISA2REG(hi, 'x', false);

	const HexOp *Rss_op = ISA2REG(hi, 's', false);
	RzILOpPure *Rss = READ_REG(pkt, Rss_op, false);
	const HexOp *Rtt_op = ISA2REG(hi, 't', false);
	RzILOpPure *Rtt = READ_REG(pkt, Rtt_op, false);

	// set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, ((ut32) 0x1));
	RzILOpEffect *set_usr_field_call_147 = hex_set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, CAST(32, IL_FALSE, SN(32, 1)));

	// HYB(gcc_expr_if ((sextract64(((ut64) ((st64) ((st32) ((Rxx >> 0x20) & 0xffffffff))) + ((((st64) ((ut64) ((st64) ((st32) ((st64) ((st32) ((Rss >> 0x20) & 0xffffffff)))))) * extract64(((ut64) ((ut16) ((Rtt >> 0x30) & ((st64) 0xffff)))), 0x0, 0x10)) << 0x0) >> 0x10)), 0x0, 0x20) == ((st64) ((st32) ((Rxx >> 0x20) & 0xffffffff))) + ((((st64) ((ut64) ((st64) ((st32) ((st64) ((st32) ((Rss >> 0x20) & 0xffffffff)))))) * extract64(((ut64) ((ut16) ((Rtt >> 0x30) & ((st64) 0xffff)))), 0x0, 0x10)) << 0x0) >> 0x10))) {{}} else {set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, ((ut32) 0x1))}, ((((st64) ((st32) ((Rxx >> 0x20) & 0xffffffff))) + ((((st64) ((ut64) ((st64) ((st32) ((st64) ((st32) ((Rss >> 0x20) & 0xffffffff)))))) * extract64(((ut64) ((ut16) ((Rtt >> 0x30) & ((st64) 0xffff)))), 0x0, 0x10)) << 0x0) >> 0x10) < ((st64) 0x0)) ? (-(0x1 << 0x1f)) : (0x1 << 0x1f) - ((st64) 0x1)));
	RzILOpPure *op_RSHIFT_14 = SHIFTRA(READ_REG(pkt, Rxx_op, false), SN(32, 0x20));
	RzILOpPure *op_AND_16 = LOGAND(op_RSHIFT_14, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_23 = SHIFTRA(Rss, SN(32, 0x20));
	RzILOpPure *op_AND_25 = LOGAND(op_RSHIFT_23, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_37 = SHIFTRA(Rtt, SN(32, 0x30));
	RzILOpPure *op_AND_40 = LOGAND(op_RSHIFT_37, CAST(64, MSB(SN(32, 0xffff)), SN(32, 0xffff)));
	RzILOpPure *op_MUL_48 = MUL(CAST(64, IL_FALSE, CAST(64, MSB(CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(op_AND_25), DUP(op_AND_25))), CAST(32, MSB(DUP(op_AND_25)), DUP(op_AND_25)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_25)), DUP(op_AND_25))), CAST(32, MSB(DUP(op_AND_25)), DUP(op_AND_25))))), CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(DUP(op_AND_25)), DUP(op_AND_25))), CAST(32, MSB(DUP(op_AND_25)), DUP(op_AND_25)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_25)), DUP(op_AND_25))), CAST(32, MSB(DUP(op_AND_25)), DUP(op_AND_25)))))), EXTRACT64(CAST(64, IL_FALSE, CAST(16, IL_FALSE, op_AND_40)), SN(32, 0), SN(32, 16)));
	RzILOpPure *op_LSHIFT_51 = SHIFTL0(CAST(64, IL_FALSE, op_MUL_48), SN(32, 0));
	RzILOpPure *op_RSHIFT_53 = SHIFTRA(op_LSHIFT_51, SN(32, 16));
	RzILOpPure *op_ADD_54 = ADD(CAST(64, MSB(CAST(32, MSB(op_AND_16), DUP(op_AND_16))), CAST(32, MSB(DUP(op_AND_16)), DUP(op_AND_16))), op_RSHIFT_53);
	RzILOpPure *op_RSHIFT_63 = SHIFTRA(READ_REG(pkt, Rxx_op, false), SN(32, 0x20));
	RzILOpPure *op_AND_65 = LOGAND(op_RSHIFT_63, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_71 = SHIFTRA(DUP(Rss), SN(32, 0x20));
	RzILOpPure *op_AND_73 = LOGAND(op_RSHIFT_71, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_84 = SHIFTRA(DUP(Rtt), SN(32, 0x30));
	RzILOpPure *op_AND_87 = LOGAND(op_RSHIFT_84, CAST(64, MSB(SN(32, 0xffff)), SN(32, 0xffff)));
	RzILOpPure *op_MUL_95 = MUL(CAST(64, IL_FALSE, CAST(64, MSB(CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(op_AND_73), DUP(op_AND_73))), CAST(32, MSB(DUP(op_AND_73)), DUP(op_AND_73)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_73)), DUP(op_AND_73))), CAST(32, MSB(DUP(op_AND_73)), DUP(op_AND_73))))), CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(DUP(op_AND_73)), DUP(op_AND_73))), CAST(32, MSB(DUP(op_AND_73)), DUP(op_AND_73)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_73)), DUP(op_AND_73))), CAST(32, MSB(DUP(op_AND_73)), DUP(op_AND_73)))))), EXTRACT64(CAST(64, IL_FALSE, CAST(16, IL_FALSE, op_AND_87)), SN(32, 0), SN(32, 16)));
	RzILOpPure *op_LSHIFT_98 = SHIFTL0(CAST(64, IL_FALSE, op_MUL_95), SN(32, 0));
	RzILOpPure *op_RSHIFT_100 = SHIFTRA(op_LSHIFT_98, SN(32, 16));
	RzILOpPure *op_ADD_101 = ADD(CAST(64, MSB(CAST(32, MSB(op_AND_65), DUP(op_AND_65))), CAST(32, MSB(DUP(op_AND_65)), DUP(op_AND_65))), op_RSHIFT_100);
	RzILOpPure *op_EQ_102 = EQ(SEXTRACT64(CAST(64, IL_FALSE, op_ADD_54), SN(32, 0), SN(32, 0x20)), op_ADD_101);
	RzILOpPure *op_RSHIFT_151 = SHIFTRA(READ_REG(pkt, Rxx_op, false), SN(32, 0x20));
	RzILOpPure *op_AND_153 = LOGAND(op_RSHIFT_151, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_159 = SHIFTRA(DUP(Rss), SN(32, 0x20));
	RzILOpPure *op_AND_161 = LOGAND(op_RSHIFT_159, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_172 = SHIFTRA(DUP(Rtt), SN(32, 0x30));
	RzILOpPure *op_AND_175 = LOGAND(op_RSHIFT_172, CAST(64, MSB(SN(32, 0xffff)), SN(32, 0xffff)));
	RzILOpPure *op_MUL_183 = MUL(CAST(64, IL_FALSE, CAST(64, MSB(CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(op_AND_161), DUP(op_AND_161))), CAST(32, MSB(DUP(op_AND_161)), DUP(op_AND_161)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_161)), DUP(op_AND_161))), CAST(32, MSB(DUP(op_AND_161)), DUP(op_AND_161))))), CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(DUP(op_AND_161)), DUP(op_AND_161))), CAST(32, MSB(DUP(op_AND_161)), DUP(op_AND_161)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_161)), DUP(op_AND_161))), CAST(32, MSB(DUP(op_AND_161)), DUP(op_AND_161)))))), EXTRACT64(CAST(64, IL_FALSE, CAST(16, IL_FALSE, op_AND_175)), SN(32, 0), SN(32, 16)));
	RzILOpPure *op_LSHIFT_186 = SHIFTL0(CAST(64, IL_FALSE, op_MUL_183), SN(32, 0));
	RzILOpPure *op_RSHIFT_188 = SHIFTRA(op_LSHIFT_186, SN(32, 16));
	RzILOpPure *op_ADD_189 = ADD(CAST(64, MSB(CAST(32, MSB(op_AND_153), DUP(op_AND_153))), CAST(32, MSB(DUP(op_AND_153)), DUP(op_AND_153))), op_RSHIFT_188);
	RzILOpPure *op_LT_192 = SLT(op_ADD_189, CAST(64, MSB(SN(32, 0)), SN(32, 0)));
	RzILOpPure *op_LSHIFT_197 = SHIFTL0(SN(64, 1), SN(32, 31));
	RzILOpPure *op_NEG_198 = NEG(op_LSHIFT_197);
	RzILOpPure *op_LSHIFT_203 = SHIFTL0(SN(64, 1), SN(32, 31));
	RzILOpPure *op_SUB_206 = SUB(op_LSHIFT_203, CAST(64, MSB(SN(32, 1)), SN(32, 1)));
	RzILOpPure *cond_207 = ITE(op_LT_192, op_NEG_198, op_SUB_206);
	RzILOpEffect *gcc_expr_208 = BRANCH(op_EQ_102, EMPTY(), set_usr_field_call_147);

	// h_tmp288 = HYB(gcc_expr_if ((sextract64(((ut64) ((st64) ((st32) ((Rxx >> 0x20) & 0xffffffff))) + ((((st64) ((ut64) ((st64) ((st32) ((st64) ((st32) ((Rss >> 0x20) & 0xffffffff)))))) * extract64(((ut64) ((ut16) ((Rtt >> 0x30) & ((st64) 0xffff)))), 0x0, 0x10)) << 0x0) >> 0x10)), 0x0, 0x20) == ((st64) ((st32) ((Rxx >> 0x20) & 0xffffffff))) + ((((st64) ((ut64) ((st64) ((st32) ((st64) ((st32) ((Rss >> 0x20) & 0xffffffff)))))) * extract64(((ut64) ((ut16) ((Rtt >> 0x30) & ((st64) 0xffff)))), 0x0, 0x10)) << 0x0) >> 0x10))) {{}} else {set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, ((ut32) 0x1))}, ((((st64) ((st32) ((Rxx >> 0x20) & 0xffffffff))) + ((((st64) ((ut64) ((st64) ((st32) ((st64) ((st32) ((Rss >> 0x20) & 0xffffffff)))))) * extract64(((ut64) ((ut16) ((Rtt >> 0x30) & ((st64) 0xffff)))), 0x0, 0x10)) << 0x0) >> 0x10) < ((st64) 0x0)) ? (-(0x1 << 0x1f)) : (0x1 << 0x1f) - ((st64) 0x1)));
	RzILOpEffect *op_ASSIGN_hybrid_tmp_210 = SETL("h_tmp288", cond_207);

	// seq(HYB(gcc_expr_if ((sextract64(((ut64) ((st64) ((st32) ((Rxx > ...;
	RzILOpEffect *seq_211 = SEQN(2, gcc_expr_208, op_ASSIGN_hybrid_tmp_210);

	// Rxx = ((Rxx & (~(0xffffffff << 0x20))) | ((((sextract64(((ut64) ((st64) ((st32) ((Rxx >> 0x20) & 0xffffffff))) + ((((st64) ((ut64) ((st64) ((st32) ((st64) ((st32) ((Rss >> 0x20) & 0xffffffff)))))) * extract64(((ut64) ((ut16) ((Rtt >> 0x30) & ((st64) 0xffff)))), 0x0, 0x10)) << 0x0) >> 0x10)), 0x0, 0x20) == ((st64) ((st32) ((Rxx >> 0x20) & 0xffffffff))) + ((((st64) ((ut64) ((st64) ((st32) ((st64) ((st32) ((Rss >> 0x20) & 0xffffffff)))))) * extract64(((ut64) ((ut16) ((Rtt >> 0x30) & ((st64) 0xffff)))), 0x0, 0x10)) << 0x0) >> 0x10)) ? ((st64) ((st32) ((Rxx >> 0x20) & 0xffffffff))) + ((((st64) ((ut64) ((st64) ((st32) ((st64) ((st32) ((Rss >> 0x20) & 0xffffffff)))))) * extract64(((ut64) ((ut16) ((Rtt >> 0x30) & ((st64) 0xffff)))), 0x0, 0x10)) << 0x0) >> 0x10) : h_tmp288) & 0xffffffff) << 0x20));
	RzILOpPure *op_LSHIFT_5 = SHIFTL0(SN(64, 0xffffffff), SN(32, 0x20));
	RzILOpPure *op_NOT_6 = LOGNOT(op_LSHIFT_5);
	RzILOpPure *op_AND_7 = LOGAND(READ_REG(pkt, Rxx_op, false), op_NOT_6);
	RzILOpPure *op_RSHIFT_106 = SHIFTRA(READ_REG(pkt, Rxx_op, false), SN(32, 0x20));
	RzILOpPure *op_AND_108 = LOGAND(op_RSHIFT_106, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_114 = SHIFTRA(DUP(Rss), SN(32, 0x20));
	RzILOpPure *op_AND_116 = LOGAND(op_RSHIFT_114, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_127 = SHIFTRA(DUP(Rtt), SN(32, 0x30));
	RzILOpPure *op_AND_130 = LOGAND(op_RSHIFT_127, CAST(64, MSB(SN(32, 0xffff)), SN(32, 0xffff)));
	RzILOpPure *op_MUL_138 = MUL(CAST(64, IL_FALSE, CAST(64, MSB(CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(op_AND_116), DUP(op_AND_116))), CAST(32, MSB(DUP(op_AND_116)), DUP(op_AND_116)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_116)), DUP(op_AND_116))), CAST(32, MSB(DUP(op_AND_116)), DUP(op_AND_116))))), CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(DUP(op_AND_116)), DUP(op_AND_116))), CAST(32, MSB(DUP(op_AND_116)), DUP(op_AND_116)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_116)), DUP(op_AND_116))), CAST(32, MSB(DUP(op_AND_116)), DUP(op_AND_116)))))), EXTRACT64(CAST(64, IL_FALSE, CAST(16, IL_FALSE, op_AND_130)), SN(32, 0), SN(32, 16)));
	RzILOpPure *op_LSHIFT_141 = SHIFTL0(CAST(64, IL_FALSE, op_MUL_138), SN(32, 0));
	RzILOpPure *op_RSHIFT_143 = SHIFTRA(op_LSHIFT_141, SN(32, 16));
	RzILOpPure *op_ADD_144 = ADD(CAST(64, MSB(CAST(32, MSB(op_AND_108), DUP(op_AND_108))), CAST(32, MSB(DUP(op_AND_108)), DUP(op_AND_108))), op_RSHIFT_143);
	RzILOpPure *cond_212 = ITE(DUP(op_EQ_102), op_ADD_144, VARL("h_tmp288"));
	RzILOpPure *op_AND_214 = LOGAND(cond_212, SN(64, 0xffffffff));
	RzILOpPure *op_LSHIFT_218 = SHIFTL0(op_AND_214, SN(32, 0x20));
	RzILOpPure *op_OR_219 = LOGOR(op_AND_7, op_LSHIFT_218);
	RzILOpEffect *op_ASSIGN_220 = WRITE_REG(bundle, Rxx_op, op_OR_219);

	// seq(seq(HYB(gcc_expr_if ((sextract64(((ut64) ((st64) ((st32) ((R ...;
	RzILOpEffect *seq_221 = SEQN(2, seq_211, op_ASSIGN_220);

	// set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, ((ut32) 0x1));
	RzILOpEffect *set_usr_field_call_367 = hex_set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, CAST(32, IL_FALSE, SN(32, 1)));

	// HYB(gcc_expr_if ((sextract64(((ut64) ((st64) ((st32) ((Rxx >> 0x0) & 0xffffffff))) + ((((st64) ((ut64) ((st64) ((st32) ((st64) ((st32) ((Rss >> 0x0) & 0xffffffff)))))) * extract64(((ut64) ((ut16) ((Rtt >> 0x10) & ((st64) 0xffff)))), 0x0, 0x10)) << 0x0) >> 0x10)), 0x0, 0x20) == ((st64) ((st32) ((Rxx >> 0x0) & 0xffffffff))) + ((((st64) ((ut64) ((st64) ((st32) ((st64) ((st32) ((Rss >> 0x0) & 0xffffffff)))))) * extract64(((ut64) ((ut16) ((Rtt >> 0x10) & ((st64) 0xffff)))), 0x0, 0x10)) << 0x0) >> 0x10))) {{}} else {set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, ((ut32) 0x1))}, ((((st64) ((st32) ((Rxx >> 0x0) & 0xffffffff))) + ((((st64) ((ut64) ((st64) ((st32) ((st64) ((st32) ((Rss >> 0x0) & 0xffffffff)))))) * extract64(((ut64) ((ut16) ((Rtt >> 0x10) & ((st64) 0xffff)))), 0x0, 0x10)) << 0x0) >> 0x10) < ((st64) 0x0)) ? (-(0x1 << 0x1f)) : (0x1 << 0x1f) - ((st64) 0x1)));
	RzILOpPure *op_RSHIFT_236 = SHIFTRA(READ_REG(pkt, Rxx_op, false), SN(32, 0));
	RzILOpPure *op_AND_238 = LOGAND(op_RSHIFT_236, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_244 = SHIFTRA(DUP(Rss), SN(32, 0));
	RzILOpPure *op_AND_246 = LOGAND(op_RSHIFT_244, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_257 = SHIFTRA(DUP(Rtt), SN(32, 16));
	RzILOpPure *op_AND_260 = LOGAND(op_RSHIFT_257, CAST(64, MSB(SN(32, 0xffff)), SN(32, 0xffff)));
	RzILOpPure *op_MUL_268 = MUL(CAST(64, IL_FALSE, CAST(64, MSB(CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(op_AND_246), DUP(op_AND_246))), CAST(32, MSB(DUP(op_AND_246)), DUP(op_AND_246)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_246)), DUP(op_AND_246))), CAST(32, MSB(DUP(op_AND_246)), DUP(op_AND_246))))), CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(DUP(op_AND_246)), DUP(op_AND_246))), CAST(32, MSB(DUP(op_AND_246)), DUP(op_AND_246)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_246)), DUP(op_AND_246))), CAST(32, MSB(DUP(op_AND_246)), DUP(op_AND_246)))))), EXTRACT64(CAST(64, IL_FALSE, CAST(16, IL_FALSE, op_AND_260)), SN(32, 0), SN(32, 16)));
	RzILOpPure *op_LSHIFT_271 = SHIFTL0(CAST(64, IL_FALSE, op_MUL_268), SN(32, 0));
	RzILOpPure *op_RSHIFT_273 = SHIFTRA(op_LSHIFT_271, SN(32, 16));
	RzILOpPure *op_ADD_274 = ADD(CAST(64, MSB(CAST(32, MSB(op_AND_238), DUP(op_AND_238))), CAST(32, MSB(DUP(op_AND_238)), DUP(op_AND_238))), op_RSHIFT_273);
	RzILOpPure *op_RSHIFT_283 = SHIFTRA(READ_REG(pkt, Rxx_op, false), SN(32, 0));
	RzILOpPure *op_AND_285 = LOGAND(op_RSHIFT_283, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_291 = SHIFTRA(DUP(Rss), SN(32, 0));
	RzILOpPure *op_AND_293 = LOGAND(op_RSHIFT_291, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_304 = SHIFTRA(DUP(Rtt), SN(32, 16));
	RzILOpPure *op_AND_307 = LOGAND(op_RSHIFT_304, CAST(64, MSB(SN(32, 0xffff)), SN(32, 0xffff)));
	RzILOpPure *op_MUL_315 = MUL(CAST(64, IL_FALSE, CAST(64, MSB(CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(op_AND_293), DUP(op_AND_293))), CAST(32, MSB(DUP(op_AND_293)), DUP(op_AND_293)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_293)), DUP(op_AND_293))), CAST(32, MSB(DUP(op_AND_293)), DUP(op_AND_293))))), CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(DUP(op_AND_293)), DUP(op_AND_293))), CAST(32, MSB(DUP(op_AND_293)), DUP(op_AND_293)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_293)), DUP(op_AND_293))), CAST(32, MSB(DUP(op_AND_293)), DUP(op_AND_293)))))), EXTRACT64(CAST(64, IL_FALSE, CAST(16, IL_FALSE, op_AND_307)), SN(32, 0), SN(32, 16)));
	RzILOpPure *op_LSHIFT_318 = SHIFTL0(CAST(64, IL_FALSE, op_MUL_315), SN(32, 0));
	RzILOpPure *op_RSHIFT_320 = SHIFTRA(op_LSHIFT_318, SN(32, 16));
	RzILOpPure *op_ADD_321 = ADD(CAST(64, MSB(CAST(32, MSB(op_AND_285), DUP(op_AND_285))), CAST(32, MSB(DUP(op_AND_285)), DUP(op_AND_285))), op_RSHIFT_320);
	RzILOpPure *op_EQ_322 = EQ(SEXTRACT64(CAST(64, IL_FALSE, op_ADD_274), SN(32, 0), SN(32, 0x20)), op_ADD_321);
	RzILOpPure *op_RSHIFT_371 = SHIFTRA(READ_REG(pkt, Rxx_op, false), SN(32, 0));
	RzILOpPure *op_AND_373 = LOGAND(op_RSHIFT_371, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_379 = SHIFTRA(DUP(Rss), SN(32, 0));
	RzILOpPure *op_AND_381 = LOGAND(op_RSHIFT_379, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_392 = SHIFTRA(DUP(Rtt), SN(32, 16));
	RzILOpPure *op_AND_395 = LOGAND(op_RSHIFT_392, CAST(64, MSB(SN(32, 0xffff)), SN(32, 0xffff)));
	RzILOpPure *op_MUL_403 = MUL(CAST(64, IL_FALSE, CAST(64, MSB(CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(op_AND_381), DUP(op_AND_381))), CAST(32, MSB(DUP(op_AND_381)), DUP(op_AND_381)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_381)), DUP(op_AND_381))), CAST(32, MSB(DUP(op_AND_381)), DUP(op_AND_381))))), CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(DUP(op_AND_381)), DUP(op_AND_381))), CAST(32, MSB(DUP(op_AND_381)), DUP(op_AND_381)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_381)), DUP(op_AND_381))), CAST(32, MSB(DUP(op_AND_381)), DUP(op_AND_381)))))), EXTRACT64(CAST(64, IL_FALSE, CAST(16, IL_FALSE, op_AND_395)), SN(32, 0), SN(32, 16)));
	RzILOpPure *op_LSHIFT_406 = SHIFTL0(CAST(64, IL_FALSE, op_MUL_403), SN(32, 0));
	RzILOpPure *op_RSHIFT_408 = SHIFTRA(op_LSHIFT_406, SN(32, 16));
	RzILOpPure *op_ADD_409 = ADD(CAST(64, MSB(CAST(32, MSB(op_AND_373), DUP(op_AND_373))), CAST(32, MSB(DUP(op_AND_373)), DUP(op_AND_373))), op_RSHIFT_408);
	RzILOpPure *op_LT_412 = SLT(op_ADD_409, CAST(64, MSB(SN(32, 0)), SN(32, 0)));
	RzILOpPure *op_LSHIFT_417 = SHIFTL0(SN(64, 1), SN(32, 31));
	RzILOpPure *op_NEG_418 = NEG(op_LSHIFT_417);
	RzILOpPure *op_LSHIFT_423 = SHIFTL0(SN(64, 1), SN(32, 31));
	RzILOpPure *op_SUB_426 = SUB(op_LSHIFT_423, CAST(64, MSB(SN(32, 1)), SN(32, 1)));
	RzILOpPure *cond_427 = ITE(op_LT_412, op_NEG_418, op_SUB_426);
	RzILOpEffect *gcc_expr_428 = BRANCH(op_EQ_322, EMPTY(), set_usr_field_call_367);

	// h_tmp289 = HYB(gcc_expr_if ((sextract64(((ut64) ((st64) ((st32) ((Rxx >> 0x0) & 0xffffffff))) + ((((st64) ((ut64) ((st64) ((st32) ((st64) ((st32) ((Rss >> 0x0) & 0xffffffff)))))) * extract64(((ut64) ((ut16) ((Rtt >> 0x10) & ((st64) 0xffff)))), 0x0, 0x10)) << 0x0) >> 0x10)), 0x0, 0x20) == ((st64) ((st32) ((Rxx >> 0x0) & 0xffffffff))) + ((((st64) ((ut64) ((st64) ((st32) ((st64) ((st32) ((Rss >> 0x0) & 0xffffffff)))))) * extract64(((ut64) ((ut16) ((Rtt >> 0x10) & ((st64) 0xffff)))), 0x0, 0x10)) << 0x0) >> 0x10))) {{}} else {set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, ((ut32) 0x1))}, ((((st64) ((st32) ((Rxx >> 0x0) & 0xffffffff))) + ((((st64) ((ut64) ((st64) ((st32) ((st64) ((st32) ((Rss >> 0x0) & 0xffffffff)))))) * extract64(((ut64) ((ut16) ((Rtt >> 0x10) & ((st64) 0xffff)))), 0x0, 0x10)) << 0x0) >> 0x10) < ((st64) 0x0)) ? (-(0x1 << 0x1f)) : (0x1 << 0x1f) - ((st64) 0x1)));
	RzILOpEffect *op_ASSIGN_hybrid_tmp_430 = SETL("h_tmp289", cond_427);

	// seq(HYB(gcc_expr_if ((sextract64(((ut64) ((st64) ((st32) ((Rxx > ...;
	RzILOpEffect *seq_431 = SEQN(2, gcc_expr_428, op_ASSIGN_hybrid_tmp_430);

	// Rxx = ((Rxx & (~(0xffffffff << 0x0))) | ((((sextract64(((ut64) ((st64) ((st32) ((Rxx >> 0x0) & 0xffffffff))) + ((((st64) ((ut64) ((st64) ((st32) ((st64) ((st32) ((Rss >> 0x0) & 0xffffffff)))))) * extract64(((ut64) ((ut16) ((Rtt >> 0x10) & ((st64) 0xffff)))), 0x0, 0x10)) << 0x0) >> 0x10)), 0x0, 0x20) == ((st64) ((st32) ((Rxx >> 0x0) & 0xffffffff))) + ((((st64) ((ut64) ((st64) ((st32) ((st64) ((st32) ((Rss >> 0x0) & 0xffffffff)))))) * extract64(((ut64) ((ut16) ((Rtt >> 0x10) & ((st64) 0xffff)))), 0x0, 0x10)) << 0x0) >> 0x10)) ? ((st64) ((st32) ((Rxx >> 0x0) & 0xffffffff))) + ((((st64) ((ut64) ((st64) ((st32) ((st64) ((st32) ((Rss >> 0x0) & 0xffffffff)))))) * extract64(((ut64) ((ut16) ((Rtt >> 0x10) & ((st64) 0xffff)))), 0x0, 0x10)) << 0x0) >> 0x10) : h_tmp289) & 0xffffffff) << 0x0));
	RzILOpPure *op_LSHIFT_227 = SHIFTL0(SN(64, 0xffffffff), SN(32, 0));
	RzILOpPure *op_NOT_228 = LOGNOT(op_LSHIFT_227);
	RzILOpPure *op_AND_229 = LOGAND(READ_REG(pkt, Rxx_op, false), op_NOT_228);
	RzILOpPure *op_RSHIFT_326 = SHIFTRA(READ_REG(pkt, Rxx_op, false), SN(32, 0));
	RzILOpPure *op_AND_328 = LOGAND(op_RSHIFT_326, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_334 = SHIFTRA(DUP(Rss), SN(32, 0));
	RzILOpPure *op_AND_336 = LOGAND(op_RSHIFT_334, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_347 = SHIFTRA(DUP(Rtt), SN(32, 16));
	RzILOpPure *op_AND_350 = LOGAND(op_RSHIFT_347, CAST(64, MSB(SN(32, 0xffff)), SN(32, 0xffff)));
	RzILOpPure *op_MUL_358 = MUL(CAST(64, IL_FALSE, CAST(64, MSB(CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(op_AND_336), DUP(op_AND_336))), CAST(32, MSB(DUP(op_AND_336)), DUP(op_AND_336)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_336)), DUP(op_AND_336))), CAST(32, MSB(DUP(op_AND_336)), DUP(op_AND_336))))), CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(DUP(op_AND_336)), DUP(op_AND_336))), CAST(32, MSB(DUP(op_AND_336)), DUP(op_AND_336)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_336)), DUP(op_AND_336))), CAST(32, MSB(DUP(op_AND_336)), DUP(op_AND_336)))))), EXTRACT64(CAST(64, IL_FALSE, CAST(16, IL_FALSE, op_AND_350)), SN(32, 0), SN(32, 16)));
	RzILOpPure *op_LSHIFT_361 = SHIFTL0(CAST(64, IL_FALSE, op_MUL_358), SN(32, 0));
	RzILOpPure *op_RSHIFT_363 = SHIFTRA(op_LSHIFT_361, SN(32, 16));
	RzILOpPure *op_ADD_364 = ADD(CAST(64, MSB(CAST(32, MSB(op_AND_328), DUP(op_AND_328))), CAST(32, MSB(DUP(op_AND_328)), DUP(op_AND_328))), op_RSHIFT_363);
	RzILOpPure *cond_432 = ITE(DUP(op_EQ_322), op_ADD_364, VARL("h_tmp289"));
	RzILOpPure *op_AND_434 = LOGAND(cond_432, SN(64, 0xffffffff));
	RzILOpPure *op_LSHIFT_438 = SHIFTL0(op_AND_434, SN(32, 0));
	RzILOpPure *op_OR_439 = LOGOR(op_AND_229, op_LSHIFT_438);
	RzILOpEffect *op_ASSIGN_440 = WRITE_REG(bundle, Rxx_op, op_OR_439);

	// seq(seq(HYB(gcc_expr_if ((sextract64(((ut64) ((st64) ((st32) ((R ...;
	RzILOpEffect *seq_441 = SEQN(2, seq_431, op_ASSIGN_440);

	RzILOpEffect *instruction_sequence = SEQN(2, seq_221, seq_441);
	return instruction_sequence;
}

// Rxx += vmpywouh(Rss,Rtt):<<1:sat
RzILOpEffect *hex_il_op_m2_mmacuhs_s1(HexInsnPktBundle *bundle) {
	const HexInsn *hi = bundle->insn;
	HexPkt *pkt = bundle->pkt;
	// READ
	const HexOp *Rxx_op = ISA2REG(hi, 'x', false);

	const HexOp *Rss_op = ISA2REG(hi, 's', false);
	RzILOpPure *Rss = READ_REG(pkt, Rss_op, false);
	const HexOp *Rtt_op = ISA2REG(hi, 't', false);
	RzILOpPure *Rtt = READ_REG(pkt, Rtt_op, false);

	// set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, ((ut32) 0x1));
	RzILOpEffect *set_usr_field_call_147 = hex_set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, CAST(32, IL_FALSE, SN(32, 1)));

	// HYB(gcc_expr_if ((sextract64(((ut64) ((st64) ((st32) ((Rxx >> 0x20) & 0xffffffff))) + ((((st64) ((ut64) ((st64) ((st32) ((st64) ((st32) ((Rss >> 0x20) & 0xffffffff)))))) * extract64(((ut64) ((ut16) ((Rtt >> 0x30) & ((st64) 0xffff)))), 0x0, 0x10)) << 0x1) >> 0x10)), 0x0, 0x20) == ((st64) ((st32) ((Rxx >> 0x20) & 0xffffffff))) + ((((st64) ((ut64) ((st64) ((st32) ((st64) ((st32) ((Rss >> 0x20) & 0xffffffff)))))) * extract64(((ut64) ((ut16) ((Rtt >> 0x30) & ((st64) 0xffff)))), 0x0, 0x10)) << 0x1) >> 0x10))) {{}} else {set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, ((ut32) 0x1))}, ((((st64) ((st32) ((Rxx >> 0x20) & 0xffffffff))) + ((((st64) ((ut64) ((st64) ((st32) ((st64) ((st32) ((Rss >> 0x20) & 0xffffffff)))))) * extract64(((ut64) ((ut16) ((Rtt >> 0x30) & ((st64) 0xffff)))), 0x0, 0x10)) << 0x1) >> 0x10) < ((st64) 0x0)) ? (-(0x1 << 0x1f)) : (0x1 << 0x1f) - ((st64) 0x1)));
	RzILOpPure *op_RSHIFT_14 = SHIFTRA(READ_REG(pkt, Rxx_op, false), SN(32, 0x20));
	RzILOpPure *op_AND_16 = LOGAND(op_RSHIFT_14, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_23 = SHIFTRA(Rss, SN(32, 0x20));
	RzILOpPure *op_AND_25 = LOGAND(op_RSHIFT_23, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_37 = SHIFTRA(Rtt, SN(32, 0x30));
	RzILOpPure *op_AND_40 = LOGAND(op_RSHIFT_37, CAST(64, MSB(SN(32, 0xffff)), SN(32, 0xffff)));
	RzILOpPure *op_MUL_48 = MUL(CAST(64, IL_FALSE, CAST(64, MSB(CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(op_AND_25), DUP(op_AND_25))), CAST(32, MSB(DUP(op_AND_25)), DUP(op_AND_25)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_25)), DUP(op_AND_25))), CAST(32, MSB(DUP(op_AND_25)), DUP(op_AND_25))))), CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(DUP(op_AND_25)), DUP(op_AND_25))), CAST(32, MSB(DUP(op_AND_25)), DUP(op_AND_25)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_25)), DUP(op_AND_25))), CAST(32, MSB(DUP(op_AND_25)), DUP(op_AND_25)))))), EXTRACT64(CAST(64, IL_FALSE, CAST(16, IL_FALSE, op_AND_40)), SN(32, 0), SN(32, 16)));
	RzILOpPure *op_LSHIFT_51 = SHIFTL0(CAST(64, IL_FALSE, op_MUL_48), SN(32, 1));
	RzILOpPure *op_RSHIFT_53 = SHIFTRA(op_LSHIFT_51, SN(32, 16));
	RzILOpPure *op_ADD_54 = ADD(CAST(64, MSB(CAST(32, MSB(op_AND_16), DUP(op_AND_16))), CAST(32, MSB(DUP(op_AND_16)), DUP(op_AND_16))), op_RSHIFT_53);
	RzILOpPure *op_RSHIFT_63 = SHIFTRA(READ_REG(pkt, Rxx_op, false), SN(32, 0x20));
	RzILOpPure *op_AND_65 = LOGAND(op_RSHIFT_63, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_71 = SHIFTRA(DUP(Rss), SN(32, 0x20));
	RzILOpPure *op_AND_73 = LOGAND(op_RSHIFT_71, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_84 = SHIFTRA(DUP(Rtt), SN(32, 0x30));
	RzILOpPure *op_AND_87 = LOGAND(op_RSHIFT_84, CAST(64, MSB(SN(32, 0xffff)), SN(32, 0xffff)));
	RzILOpPure *op_MUL_95 = MUL(CAST(64, IL_FALSE, CAST(64, MSB(CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(op_AND_73), DUP(op_AND_73))), CAST(32, MSB(DUP(op_AND_73)), DUP(op_AND_73)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_73)), DUP(op_AND_73))), CAST(32, MSB(DUP(op_AND_73)), DUP(op_AND_73))))), CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(DUP(op_AND_73)), DUP(op_AND_73))), CAST(32, MSB(DUP(op_AND_73)), DUP(op_AND_73)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_73)), DUP(op_AND_73))), CAST(32, MSB(DUP(op_AND_73)), DUP(op_AND_73)))))), EXTRACT64(CAST(64, IL_FALSE, CAST(16, IL_FALSE, op_AND_87)), SN(32, 0), SN(32, 16)));
	RzILOpPure *op_LSHIFT_98 = SHIFTL0(CAST(64, IL_FALSE, op_MUL_95), SN(32, 1));
	RzILOpPure *op_RSHIFT_100 = SHIFTRA(op_LSHIFT_98, SN(32, 16));
	RzILOpPure *op_ADD_101 = ADD(CAST(64, MSB(CAST(32, MSB(op_AND_65), DUP(op_AND_65))), CAST(32, MSB(DUP(op_AND_65)), DUP(op_AND_65))), op_RSHIFT_100);
	RzILOpPure *op_EQ_102 = EQ(SEXTRACT64(CAST(64, IL_FALSE, op_ADD_54), SN(32, 0), SN(32, 0x20)), op_ADD_101);
	RzILOpPure *op_RSHIFT_151 = SHIFTRA(READ_REG(pkt, Rxx_op, false), SN(32, 0x20));
	RzILOpPure *op_AND_153 = LOGAND(op_RSHIFT_151, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_159 = SHIFTRA(DUP(Rss), SN(32, 0x20));
	RzILOpPure *op_AND_161 = LOGAND(op_RSHIFT_159, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_172 = SHIFTRA(DUP(Rtt), SN(32, 0x30));
	RzILOpPure *op_AND_175 = LOGAND(op_RSHIFT_172, CAST(64, MSB(SN(32, 0xffff)), SN(32, 0xffff)));
	RzILOpPure *op_MUL_183 = MUL(CAST(64, IL_FALSE, CAST(64, MSB(CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(op_AND_161), DUP(op_AND_161))), CAST(32, MSB(DUP(op_AND_161)), DUP(op_AND_161)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_161)), DUP(op_AND_161))), CAST(32, MSB(DUP(op_AND_161)), DUP(op_AND_161))))), CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(DUP(op_AND_161)), DUP(op_AND_161))), CAST(32, MSB(DUP(op_AND_161)), DUP(op_AND_161)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_161)), DUP(op_AND_161))), CAST(32, MSB(DUP(op_AND_161)), DUP(op_AND_161)))))), EXTRACT64(CAST(64, IL_FALSE, CAST(16, IL_FALSE, op_AND_175)), SN(32, 0), SN(32, 16)));
	RzILOpPure *op_LSHIFT_186 = SHIFTL0(CAST(64, IL_FALSE, op_MUL_183), SN(32, 1));
	RzILOpPure *op_RSHIFT_188 = SHIFTRA(op_LSHIFT_186, SN(32, 16));
	RzILOpPure *op_ADD_189 = ADD(CAST(64, MSB(CAST(32, MSB(op_AND_153), DUP(op_AND_153))), CAST(32, MSB(DUP(op_AND_153)), DUP(op_AND_153))), op_RSHIFT_188);
	RzILOpPure *op_LT_192 = SLT(op_ADD_189, CAST(64, MSB(SN(32, 0)), SN(32, 0)));
	RzILOpPure *op_LSHIFT_197 = SHIFTL0(SN(64, 1), SN(32, 31));
	RzILOpPure *op_NEG_198 = NEG(op_LSHIFT_197);
	RzILOpPure *op_LSHIFT_203 = SHIFTL0(SN(64, 1), SN(32, 31));
	RzILOpPure *op_SUB_206 = SUB(op_LSHIFT_203, CAST(64, MSB(SN(32, 1)), SN(32, 1)));
	RzILOpPure *cond_207 = ITE(op_LT_192, op_NEG_198, op_SUB_206);
	RzILOpEffect *gcc_expr_208 = BRANCH(op_EQ_102, EMPTY(), set_usr_field_call_147);

	// h_tmp290 = HYB(gcc_expr_if ((sextract64(((ut64) ((st64) ((st32) ((Rxx >> 0x20) & 0xffffffff))) + ((((st64) ((ut64) ((st64) ((st32) ((st64) ((st32) ((Rss >> 0x20) & 0xffffffff)))))) * extract64(((ut64) ((ut16) ((Rtt >> 0x30) & ((st64) 0xffff)))), 0x0, 0x10)) << 0x1) >> 0x10)), 0x0, 0x20) == ((st64) ((st32) ((Rxx >> 0x20) & 0xffffffff))) + ((((st64) ((ut64) ((st64) ((st32) ((st64) ((st32) ((Rss >> 0x20) & 0xffffffff)))))) * extract64(((ut64) ((ut16) ((Rtt >> 0x30) & ((st64) 0xffff)))), 0x0, 0x10)) << 0x1) >> 0x10))) {{}} else {set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, ((ut32) 0x1))}, ((((st64) ((st32) ((Rxx >> 0x20) & 0xffffffff))) + ((((st64) ((ut64) ((st64) ((st32) ((st64) ((st32) ((Rss >> 0x20) & 0xffffffff)))))) * extract64(((ut64) ((ut16) ((Rtt >> 0x30) & ((st64) 0xffff)))), 0x0, 0x10)) << 0x1) >> 0x10) < ((st64) 0x0)) ? (-(0x1 << 0x1f)) : (0x1 << 0x1f) - ((st64) 0x1)));
	RzILOpEffect *op_ASSIGN_hybrid_tmp_210 = SETL("h_tmp290", cond_207);

	// seq(HYB(gcc_expr_if ((sextract64(((ut64) ((st64) ((st32) ((Rxx > ...;
	RzILOpEffect *seq_211 = SEQN(2, gcc_expr_208, op_ASSIGN_hybrid_tmp_210);

	// Rxx = ((Rxx & (~(0xffffffff << 0x20))) | ((((sextract64(((ut64) ((st64) ((st32) ((Rxx >> 0x20) & 0xffffffff))) + ((((st64) ((ut64) ((st64) ((st32) ((st64) ((st32) ((Rss >> 0x20) & 0xffffffff)))))) * extract64(((ut64) ((ut16) ((Rtt >> 0x30) & ((st64) 0xffff)))), 0x0, 0x10)) << 0x1) >> 0x10)), 0x0, 0x20) == ((st64) ((st32) ((Rxx >> 0x20) & 0xffffffff))) + ((((st64) ((ut64) ((st64) ((st32) ((st64) ((st32) ((Rss >> 0x20) & 0xffffffff)))))) * extract64(((ut64) ((ut16) ((Rtt >> 0x30) & ((st64) 0xffff)))), 0x0, 0x10)) << 0x1) >> 0x10)) ? ((st64) ((st32) ((Rxx >> 0x20) & 0xffffffff))) + ((((st64) ((ut64) ((st64) ((st32) ((st64) ((st32) ((Rss >> 0x20) & 0xffffffff)))))) * extract64(((ut64) ((ut16) ((Rtt >> 0x30) & ((st64) 0xffff)))), 0x0, 0x10)) << 0x1) >> 0x10) : h_tmp290) & 0xffffffff) << 0x20));
	RzILOpPure *op_LSHIFT_5 = SHIFTL0(SN(64, 0xffffffff), SN(32, 0x20));
	RzILOpPure *op_NOT_6 = LOGNOT(op_LSHIFT_5);
	RzILOpPure *op_AND_7 = LOGAND(READ_REG(pkt, Rxx_op, false), op_NOT_6);
	RzILOpPure *op_RSHIFT_106 = SHIFTRA(READ_REG(pkt, Rxx_op, false), SN(32, 0x20));
	RzILOpPure *op_AND_108 = LOGAND(op_RSHIFT_106, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_114 = SHIFTRA(DUP(Rss), SN(32, 0x20));
	RzILOpPure *op_AND_116 = LOGAND(op_RSHIFT_114, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_127 = SHIFTRA(DUP(Rtt), SN(32, 0x30));
	RzILOpPure *op_AND_130 = LOGAND(op_RSHIFT_127, CAST(64, MSB(SN(32, 0xffff)), SN(32, 0xffff)));
	RzILOpPure *op_MUL_138 = MUL(CAST(64, IL_FALSE, CAST(64, MSB(CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(op_AND_116), DUP(op_AND_116))), CAST(32, MSB(DUP(op_AND_116)), DUP(op_AND_116)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_116)), DUP(op_AND_116))), CAST(32, MSB(DUP(op_AND_116)), DUP(op_AND_116))))), CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(DUP(op_AND_116)), DUP(op_AND_116))), CAST(32, MSB(DUP(op_AND_116)), DUP(op_AND_116)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_116)), DUP(op_AND_116))), CAST(32, MSB(DUP(op_AND_116)), DUP(op_AND_116)))))), EXTRACT64(CAST(64, IL_FALSE, CAST(16, IL_FALSE, op_AND_130)), SN(32, 0), SN(32, 16)));
	RzILOpPure *op_LSHIFT_141 = SHIFTL0(CAST(64, IL_FALSE, op_MUL_138), SN(32, 1));
	RzILOpPure *op_RSHIFT_143 = SHIFTRA(op_LSHIFT_141, SN(32, 16));
	RzILOpPure *op_ADD_144 = ADD(CAST(64, MSB(CAST(32, MSB(op_AND_108), DUP(op_AND_108))), CAST(32, MSB(DUP(op_AND_108)), DUP(op_AND_108))), op_RSHIFT_143);
	RzILOpPure *cond_212 = ITE(DUP(op_EQ_102), op_ADD_144, VARL("h_tmp290"));
	RzILOpPure *op_AND_214 = LOGAND(cond_212, SN(64, 0xffffffff));
	RzILOpPure *op_LSHIFT_218 = SHIFTL0(op_AND_214, SN(32, 0x20));
	RzILOpPure *op_OR_219 = LOGOR(op_AND_7, op_LSHIFT_218);
	RzILOpEffect *op_ASSIGN_220 = WRITE_REG(bundle, Rxx_op, op_OR_219);

	// seq(seq(HYB(gcc_expr_if ((sextract64(((ut64) ((st64) ((st32) ((R ...;
	RzILOpEffect *seq_221 = SEQN(2, seq_211, op_ASSIGN_220);

	// set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, ((ut32) 0x1));
	RzILOpEffect *set_usr_field_call_367 = hex_set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, CAST(32, IL_FALSE, SN(32, 1)));

	// HYB(gcc_expr_if ((sextract64(((ut64) ((st64) ((st32) ((Rxx >> 0x0) & 0xffffffff))) + ((((st64) ((ut64) ((st64) ((st32) ((st64) ((st32) ((Rss >> 0x0) & 0xffffffff)))))) * extract64(((ut64) ((ut16) ((Rtt >> 0x10) & ((st64) 0xffff)))), 0x0, 0x10)) << 0x1) >> 0x10)), 0x0, 0x20) == ((st64) ((st32) ((Rxx >> 0x0) & 0xffffffff))) + ((((st64) ((ut64) ((st64) ((st32) ((st64) ((st32) ((Rss >> 0x0) & 0xffffffff)))))) * extract64(((ut64) ((ut16) ((Rtt >> 0x10) & ((st64) 0xffff)))), 0x0, 0x10)) << 0x1) >> 0x10))) {{}} else {set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, ((ut32) 0x1))}, ((((st64) ((st32) ((Rxx >> 0x0) & 0xffffffff))) + ((((st64) ((ut64) ((st64) ((st32) ((st64) ((st32) ((Rss >> 0x0) & 0xffffffff)))))) * extract64(((ut64) ((ut16) ((Rtt >> 0x10) & ((st64) 0xffff)))), 0x0, 0x10)) << 0x1) >> 0x10) < ((st64) 0x0)) ? (-(0x1 << 0x1f)) : (0x1 << 0x1f) - ((st64) 0x1)));
	RzILOpPure *op_RSHIFT_236 = SHIFTRA(READ_REG(pkt, Rxx_op, false), SN(32, 0));
	RzILOpPure *op_AND_238 = LOGAND(op_RSHIFT_236, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_244 = SHIFTRA(DUP(Rss), SN(32, 0));
	RzILOpPure *op_AND_246 = LOGAND(op_RSHIFT_244, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_257 = SHIFTRA(DUP(Rtt), SN(32, 16));
	RzILOpPure *op_AND_260 = LOGAND(op_RSHIFT_257, CAST(64, MSB(SN(32, 0xffff)), SN(32, 0xffff)));
	RzILOpPure *op_MUL_268 = MUL(CAST(64, IL_FALSE, CAST(64, MSB(CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(op_AND_246), DUP(op_AND_246))), CAST(32, MSB(DUP(op_AND_246)), DUP(op_AND_246)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_246)), DUP(op_AND_246))), CAST(32, MSB(DUP(op_AND_246)), DUP(op_AND_246))))), CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(DUP(op_AND_246)), DUP(op_AND_246))), CAST(32, MSB(DUP(op_AND_246)), DUP(op_AND_246)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_246)), DUP(op_AND_246))), CAST(32, MSB(DUP(op_AND_246)), DUP(op_AND_246)))))), EXTRACT64(CAST(64, IL_FALSE, CAST(16, IL_FALSE, op_AND_260)), SN(32, 0), SN(32, 16)));
	RzILOpPure *op_LSHIFT_271 = SHIFTL0(CAST(64, IL_FALSE, op_MUL_268), SN(32, 1));
	RzILOpPure *op_RSHIFT_273 = SHIFTRA(op_LSHIFT_271, SN(32, 16));
	RzILOpPure *op_ADD_274 = ADD(CAST(64, MSB(CAST(32, MSB(op_AND_238), DUP(op_AND_238))), CAST(32, MSB(DUP(op_AND_238)), DUP(op_AND_238))), op_RSHIFT_273);
	RzILOpPure *op_RSHIFT_283 = SHIFTRA(READ_REG(pkt, Rxx_op, false), SN(32, 0));
	RzILOpPure *op_AND_285 = LOGAND(op_RSHIFT_283, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_291 = SHIFTRA(DUP(Rss), SN(32, 0));
	RzILOpPure *op_AND_293 = LOGAND(op_RSHIFT_291, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_304 = SHIFTRA(DUP(Rtt), SN(32, 16));
	RzILOpPure *op_AND_307 = LOGAND(op_RSHIFT_304, CAST(64, MSB(SN(32, 0xffff)), SN(32, 0xffff)));
	RzILOpPure *op_MUL_315 = MUL(CAST(64, IL_FALSE, CAST(64, MSB(CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(op_AND_293), DUP(op_AND_293))), CAST(32, MSB(DUP(op_AND_293)), DUP(op_AND_293)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_293)), DUP(op_AND_293))), CAST(32, MSB(DUP(op_AND_293)), DUP(op_AND_293))))), CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(DUP(op_AND_293)), DUP(op_AND_293))), CAST(32, MSB(DUP(op_AND_293)), DUP(op_AND_293)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_293)), DUP(op_AND_293))), CAST(32, MSB(DUP(op_AND_293)), DUP(op_AND_293)))))), EXTRACT64(CAST(64, IL_FALSE, CAST(16, IL_FALSE, op_AND_307)), SN(32, 0), SN(32, 16)));
	RzILOpPure *op_LSHIFT_318 = SHIFTL0(CAST(64, IL_FALSE, op_MUL_315), SN(32, 1));
	RzILOpPure *op_RSHIFT_320 = SHIFTRA(op_LSHIFT_318, SN(32, 16));
	RzILOpPure *op_ADD_321 = ADD(CAST(64, MSB(CAST(32, MSB(op_AND_285), DUP(op_AND_285))), CAST(32, MSB(DUP(op_AND_285)), DUP(op_AND_285))), op_RSHIFT_320);
	RzILOpPure *op_EQ_322 = EQ(SEXTRACT64(CAST(64, IL_FALSE, op_ADD_274), SN(32, 0), SN(32, 0x20)), op_ADD_321);
	RzILOpPure *op_RSHIFT_371 = SHIFTRA(READ_REG(pkt, Rxx_op, false), SN(32, 0));
	RzILOpPure *op_AND_373 = LOGAND(op_RSHIFT_371, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_379 = SHIFTRA(DUP(Rss), SN(32, 0));
	RzILOpPure *op_AND_381 = LOGAND(op_RSHIFT_379, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_392 = SHIFTRA(DUP(Rtt), SN(32, 16));
	RzILOpPure *op_AND_395 = LOGAND(op_RSHIFT_392, CAST(64, MSB(SN(32, 0xffff)), SN(32, 0xffff)));
	RzILOpPure *op_MUL_403 = MUL(CAST(64, IL_FALSE, CAST(64, MSB(CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(op_AND_381), DUP(op_AND_381))), CAST(32, MSB(DUP(op_AND_381)), DUP(op_AND_381)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_381)), DUP(op_AND_381))), CAST(32, MSB(DUP(op_AND_381)), DUP(op_AND_381))))), CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(DUP(op_AND_381)), DUP(op_AND_381))), CAST(32, MSB(DUP(op_AND_381)), DUP(op_AND_381)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_381)), DUP(op_AND_381))), CAST(32, MSB(DUP(op_AND_381)), DUP(op_AND_381)))))), EXTRACT64(CAST(64, IL_FALSE, CAST(16, IL_FALSE, op_AND_395)), SN(32, 0), SN(32, 16)));
	RzILOpPure *op_LSHIFT_406 = SHIFTL0(CAST(64, IL_FALSE, op_MUL_403), SN(32, 1));
	RzILOpPure *op_RSHIFT_408 = SHIFTRA(op_LSHIFT_406, SN(32, 16));
	RzILOpPure *op_ADD_409 = ADD(CAST(64, MSB(CAST(32, MSB(op_AND_373), DUP(op_AND_373))), CAST(32, MSB(DUP(op_AND_373)), DUP(op_AND_373))), op_RSHIFT_408);
	RzILOpPure *op_LT_412 = SLT(op_ADD_409, CAST(64, MSB(SN(32, 0)), SN(32, 0)));
	RzILOpPure *op_LSHIFT_417 = SHIFTL0(SN(64, 1), SN(32, 31));
	RzILOpPure *op_NEG_418 = NEG(op_LSHIFT_417);
	RzILOpPure *op_LSHIFT_423 = SHIFTL0(SN(64, 1), SN(32, 31));
	RzILOpPure *op_SUB_426 = SUB(op_LSHIFT_423, CAST(64, MSB(SN(32, 1)), SN(32, 1)));
	RzILOpPure *cond_427 = ITE(op_LT_412, op_NEG_418, op_SUB_426);
	RzILOpEffect *gcc_expr_428 = BRANCH(op_EQ_322, EMPTY(), set_usr_field_call_367);

	// h_tmp291 = HYB(gcc_expr_if ((sextract64(((ut64) ((st64) ((st32) ((Rxx >> 0x0) & 0xffffffff))) + ((((st64) ((ut64) ((st64) ((st32) ((st64) ((st32) ((Rss >> 0x0) & 0xffffffff)))))) * extract64(((ut64) ((ut16) ((Rtt >> 0x10) & ((st64) 0xffff)))), 0x0, 0x10)) << 0x1) >> 0x10)), 0x0, 0x20) == ((st64) ((st32) ((Rxx >> 0x0) & 0xffffffff))) + ((((st64) ((ut64) ((st64) ((st32) ((st64) ((st32) ((Rss >> 0x0) & 0xffffffff)))))) * extract64(((ut64) ((ut16) ((Rtt >> 0x10) & ((st64) 0xffff)))), 0x0, 0x10)) << 0x1) >> 0x10))) {{}} else {set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, ((ut32) 0x1))}, ((((st64) ((st32) ((Rxx >> 0x0) & 0xffffffff))) + ((((st64) ((ut64) ((st64) ((st32) ((st64) ((st32) ((Rss >> 0x0) & 0xffffffff)))))) * extract64(((ut64) ((ut16) ((Rtt >> 0x10) & ((st64) 0xffff)))), 0x0, 0x10)) << 0x1) >> 0x10) < ((st64) 0x0)) ? (-(0x1 << 0x1f)) : (0x1 << 0x1f) - ((st64) 0x1)));
	RzILOpEffect *op_ASSIGN_hybrid_tmp_430 = SETL("h_tmp291", cond_427);

	// seq(HYB(gcc_expr_if ((sextract64(((ut64) ((st64) ((st32) ((Rxx > ...;
	RzILOpEffect *seq_431 = SEQN(2, gcc_expr_428, op_ASSIGN_hybrid_tmp_430);

	// Rxx = ((Rxx & (~(0xffffffff << 0x0))) | ((((sextract64(((ut64) ((st64) ((st32) ((Rxx >> 0x0) & 0xffffffff))) + ((((st64) ((ut64) ((st64) ((st32) ((st64) ((st32) ((Rss >> 0x0) & 0xffffffff)))))) * extract64(((ut64) ((ut16) ((Rtt >> 0x10) & ((st64) 0xffff)))), 0x0, 0x10)) << 0x1) >> 0x10)), 0x0, 0x20) == ((st64) ((st32) ((Rxx >> 0x0) & 0xffffffff))) + ((((st64) ((ut64) ((st64) ((st32) ((st64) ((st32) ((Rss >> 0x0) & 0xffffffff)))))) * extract64(((ut64) ((ut16) ((Rtt >> 0x10) & ((st64) 0xffff)))), 0x0, 0x10)) << 0x1) >> 0x10)) ? ((st64) ((st32) ((Rxx >> 0x0) & 0xffffffff))) + ((((st64) ((ut64) ((st64) ((st32) ((st64) ((st32) ((Rss >> 0x0) & 0xffffffff)))))) * extract64(((ut64) ((ut16) ((Rtt >> 0x10) & ((st64) 0xffff)))), 0x0, 0x10)) << 0x1) >> 0x10) : h_tmp291) & 0xffffffff) << 0x0));
	RzILOpPure *op_LSHIFT_227 = SHIFTL0(SN(64, 0xffffffff), SN(32, 0));
	RzILOpPure *op_NOT_228 = LOGNOT(op_LSHIFT_227);
	RzILOpPure *op_AND_229 = LOGAND(READ_REG(pkt, Rxx_op, false), op_NOT_228);
	RzILOpPure *op_RSHIFT_326 = SHIFTRA(READ_REG(pkt, Rxx_op, false), SN(32, 0));
	RzILOpPure *op_AND_328 = LOGAND(op_RSHIFT_326, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_334 = SHIFTRA(DUP(Rss), SN(32, 0));
	RzILOpPure *op_AND_336 = LOGAND(op_RSHIFT_334, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_347 = SHIFTRA(DUP(Rtt), SN(32, 16));
	RzILOpPure *op_AND_350 = LOGAND(op_RSHIFT_347, CAST(64, MSB(SN(32, 0xffff)), SN(32, 0xffff)));
	RzILOpPure *op_MUL_358 = MUL(CAST(64, IL_FALSE, CAST(64, MSB(CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(op_AND_336), DUP(op_AND_336))), CAST(32, MSB(DUP(op_AND_336)), DUP(op_AND_336)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_336)), DUP(op_AND_336))), CAST(32, MSB(DUP(op_AND_336)), DUP(op_AND_336))))), CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(DUP(op_AND_336)), DUP(op_AND_336))), CAST(32, MSB(DUP(op_AND_336)), DUP(op_AND_336)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_336)), DUP(op_AND_336))), CAST(32, MSB(DUP(op_AND_336)), DUP(op_AND_336)))))), EXTRACT64(CAST(64, IL_FALSE, CAST(16, IL_FALSE, op_AND_350)), SN(32, 0), SN(32, 16)));
	RzILOpPure *op_LSHIFT_361 = SHIFTL0(CAST(64, IL_FALSE, op_MUL_358), SN(32, 1));
	RzILOpPure *op_RSHIFT_363 = SHIFTRA(op_LSHIFT_361, SN(32, 16));
	RzILOpPure *op_ADD_364 = ADD(CAST(64, MSB(CAST(32, MSB(op_AND_328), DUP(op_AND_328))), CAST(32, MSB(DUP(op_AND_328)), DUP(op_AND_328))), op_RSHIFT_363);
	RzILOpPure *cond_432 = ITE(DUP(op_EQ_322), op_ADD_364, VARL("h_tmp291"));
	RzILOpPure *op_AND_434 = LOGAND(cond_432, SN(64, 0xffffffff));
	RzILOpPure *op_LSHIFT_438 = SHIFTL0(op_AND_434, SN(32, 0));
	RzILOpPure *op_OR_439 = LOGOR(op_AND_229, op_LSHIFT_438);
	RzILOpEffect *op_ASSIGN_440 = WRITE_REG(bundle, Rxx_op, op_OR_439);

	// seq(seq(HYB(gcc_expr_if ((sextract64(((ut64) ((st64) ((st32) ((R ...;
	RzILOpEffect *seq_441 = SEQN(2, seq_431, op_ASSIGN_440);

	RzILOpEffect *instruction_sequence = SEQN(2, seq_221, seq_441);
	return instruction_sequence;
}

// Rxx += vmpyweuh(Rss,Rtt):rnd:sat
RzILOpEffect *hex_il_op_m2_mmaculs_rs0(HexInsnPktBundle *bundle) {
	const HexInsn *hi = bundle->insn;
	HexPkt *pkt = bundle->pkt;
	// READ
	const HexOp *Rxx_op = ISA2REG(hi, 'x', false);

	const HexOp *Rss_op = ISA2REG(hi, 's', false);
	RzILOpPure *Rss = READ_REG(pkt, Rss_op, false);
	const HexOp *Rtt_op = ISA2REG(hi, 't', false);
	RzILOpPure *Rtt = READ_REG(pkt, Rtt_op, false);

	// set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, ((ut32) 0x1));
	RzILOpEffect *set_usr_field_call_156 = hex_set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, CAST(32, IL_FALSE, SN(32, 1)));

	// HYB(gcc_expr_if ((sextract64(((ut64) ((st64) ((st32) ((Rxx >> 0x20) & 0xffffffff))) + ((((st64) ((ut64) ((st64) ((st32) ((st64) ((st32) ((Rss >> 0x20) & 0xffffffff)))))) * extract64(((ut64) ((ut16) ((Rtt >> 0x20) & ((st64) 0xffff)))), 0x0, 0x10)) << 0x0) + ((st64) 0x8000) >> 0x10)), 0x0, 0x20) == ((st64) ((st32) ((Rxx >> 0x20) & 0xffffffff))) + ((((st64) ((ut64) ((st64) ((st32) ((st64) ((st32) ((Rss >> 0x20) & 0xffffffff)))))) * extract64(((ut64) ((ut16) ((Rtt >> 0x20) & ((st64) 0xffff)))), 0x0, 0x10)) << 0x0) + ((st64) 0x8000) >> 0x10))) {{}} else {set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, ((ut32) 0x1))}, ((((st64) ((st32) ((Rxx >> 0x20) & 0xffffffff))) + ((((st64) ((ut64) ((st64) ((st32) ((st64) ((st32) ((Rss >> 0x20) & 0xffffffff)))))) * extract64(((ut64) ((ut16) ((Rtt >> 0x20) & ((st64) 0xffff)))), 0x0, 0x10)) << 0x0) + ((st64) 0x8000) >> 0x10) < ((st64) 0x0)) ? (-(0x1 << 0x1f)) : (0x1 << 0x1f) - ((st64) 0x1)));
	RzILOpPure *op_RSHIFT_14 = SHIFTRA(READ_REG(pkt, Rxx_op, false), SN(32, 0x20));
	RzILOpPure *op_AND_16 = LOGAND(op_RSHIFT_14, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_23 = SHIFTRA(Rss, SN(32, 0x20));
	RzILOpPure *op_AND_25 = LOGAND(op_RSHIFT_23, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_37 = SHIFTRA(Rtt, SN(32, 0x20));
	RzILOpPure *op_AND_40 = LOGAND(op_RSHIFT_37, CAST(64, MSB(SN(32, 0xffff)), SN(32, 0xffff)));
	RzILOpPure *op_MUL_48 = MUL(CAST(64, IL_FALSE, CAST(64, MSB(CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(op_AND_25), DUP(op_AND_25))), CAST(32, MSB(DUP(op_AND_25)), DUP(op_AND_25)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_25)), DUP(op_AND_25))), CAST(32, MSB(DUP(op_AND_25)), DUP(op_AND_25))))), CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(DUP(op_AND_25)), DUP(op_AND_25))), CAST(32, MSB(DUP(op_AND_25)), DUP(op_AND_25)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_25)), DUP(op_AND_25))), CAST(32, MSB(DUP(op_AND_25)), DUP(op_AND_25)))))), EXTRACT64(CAST(64, IL_FALSE, CAST(16, IL_FALSE, op_AND_40)), SN(32, 0), SN(32, 16)));
	RzILOpPure *op_LSHIFT_51 = SHIFTL0(CAST(64, IL_FALSE, op_MUL_48), SN(32, 0));
	RzILOpPure *op_ADD_54 = ADD(op_LSHIFT_51, CAST(64, MSB(SN(32, 0x8000)), SN(32, 0x8000)));
	RzILOpPure *op_RSHIFT_56 = SHIFTRA(op_ADD_54, SN(32, 16));
	RzILOpPure *op_ADD_57 = ADD(CAST(64, MSB(CAST(32, MSB(op_AND_16), DUP(op_AND_16))), CAST(32, MSB(DUP(op_AND_16)), DUP(op_AND_16))), op_RSHIFT_56);
	RzILOpPure *op_RSHIFT_66 = SHIFTRA(READ_REG(pkt, Rxx_op, false), SN(32, 0x20));
	RzILOpPure *op_AND_68 = LOGAND(op_RSHIFT_66, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_74 = SHIFTRA(DUP(Rss), SN(32, 0x20));
	RzILOpPure *op_AND_76 = LOGAND(op_RSHIFT_74, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_87 = SHIFTRA(DUP(Rtt), SN(32, 0x20));
	RzILOpPure *op_AND_90 = LOGAND(op_RSHIFT_87, CAST(64, MSB(SN(32, 0xffff)), SN(32, 0xffff)));
	RzILOpPure *op_MUL_98 = MUL(CAST(64, IL_FALSE, CAST(64, MSB(CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(op_AND_76), DUP(op_AND_76))), CAST(32, MSB(DUP(op_AND_76)), DUP(op_AND_76)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_76)), DUP(op_AND_76))), CAST(32, MSB(DUP(op_AND_76)), DUP(op_AND_76))))), CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(DUP(op_AND_76)), DUP(op_AND_76))), CAST(32, MSB(DUP(op_AND_76)), DUP(op_AND_76)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_76)), DUP(op_AND_76))), CAST(32, MSB(DUP(op_AND_76)), DUP(op_AND_76)))))), EXTRACT64(CAST(64, IL_FALSE, CAST(16, IL_FALSE, op_AND_90)), SN(32, 0), SN(32, 16)));
	RzILOpPure *op_LSHIFT_101 = SHIFTL0(CAST(64, IL_FALSE, op_MUL_98), SN(32, 0));
	RzILOpPure *op_ADD_104 = ADD(op_LSHIFT_101, CAST(64, MSB(SN(32, 0x8000)), SN(32, 0x8000)));
	RzILOpPure *op_RSHIFT_106 = SHIFTRA(op_ADD_104, SN(32, 16));
	RzILOpPure *op_ADD_107 = ADD(CAST(64, MSB(CAST(32, MSB(op_AND_68), DUP(op_AND_68))), CAST(32, MSB(DUP(op_AND_68)), DUP(op_AND_68))), op_RSHIFT_106);
	RzILOpPure *op_EQ_108 = EQ(SEXTRACT64(CAST(64, IL_FALSE, op_ADD_57), SN(32, 0), SN(32, 0x20)), op_ADD_107);
	RzILOpPure *op_RSHIFT_160 = SHIFTRA(READ_REG(pkt, Rxx_op, false), SN(32, 0x20));
	RzILOpPure *op_AND_162 = LOGAND(op_RSHIFT_160, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_168 = SHIFTRA(DUP(Rss), SN(32, 0x20));
	RzILOpPure *op_AND_170 = LOGAND(op_RSHIFT_168, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_181 = SHIFTRA(DUP(Rtt), SN(32, 0x20));
	RzILOpPure *op_AND_184 = LOGAND(op_RSHIFT_181, CAST(64, MSB(SN(32, 0xffff)), SN(32, 0xffff)));
	RzILOpPure *op_MUL_192 = MUL(CAST(64, IL_FALSE, CAST(64, MSB(CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(op_AND_170), DUP(op_AND_170))), CAST(32, MSB(DUP(op_AND_170)), DUP(op_AND_170)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_170)), DUP(op_AND_170))), CAST(32, MSB(DUP(op_AND_170)), DUP(op_AND_170))))), CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(DUP(op_AND_170)), DUP(op_AND_170))), CAST(32, MSB(DUP(op_AND_170)), DUP(op_AND_170)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_170)), DUP(op_AND_170))), CAST(32, MSB(DUP(op_AND_170)), DUP(op_AND_170)))))), EXTRACT64(CAST(64, IL_FALSE, CAST(16, IL_FALSE, op_AND_184)), SN(32, 0), SN(32, 16)));
	RzILOpPure *op_LSHIFT_195 = SHIFTL0(CAST(64, IL_FALSE, op_MUL_192), SN(32, 0));
	RzILOpPure *op_ADD_198 = ADD(op_LSHIFT_195, CAST(64, MSB(SN(32, 0x8000)), SN(32, 0x8000)));
	RzILOpPure *op_RSHIFT_200 = SHIFTRA(op_ADD_198, SN(32, 16));
	RzILOpPure *op_ADD_201 = ADD(CAST(64, MSB(CAST(32, MSB(op_AND_162), DUP(op_AND_162))), CAST(32, MSB(DUP(op_AND_162)), DUP(op_AND_162))), op_RSHIFT_200);
	RzILOpPure *op_LT_204 = SLT(op_ADD_201, CAST(64, MSB(SN(32, 0)), SN(32, 0)));
	RzILOpPure *op_LSHIFT_209 = SHIFTL0(SN(64, 1), SN(32, 31));
	RzILOpPure *op_NEG_210 = NEG(op_LSHIFT_209);
	RzILOpPure *op_LSHIFT_215 = SHIFTL0(SN(64, 1), SN(32, 31));
	RzILOpPure *op_SUB_218 = SUB(op_LSHIFT_215, CAST(64, MSB(SN(32, 1)), SN(32, 1)));
	RzILOpPure *cond_219 = ITE(op_LT_204, op_NEG_210, op_SUB_218);
	RzILOpEffect *gcc_expr_220 = BRANCH(op_EQ_108, EMPTY(), set_usr_field_call_156);

	// h_tmp292 = HYB(gcc_expr_if ((sextract64(((ut64) ((st64) ((st32) ((Rxx >> 0x20) & 0xffffffff))) + ((((st64) ((ut64) ((st64) ((st32) ((st64) ((st32) ((Rss >> 0x20) & 0xffffffff)))))) * extract64(((ut64) ((ut16) ((Rtt >> 0x20) & ((st64) 0xffff)))), 0x0, 0x10)) << 0x0) + ((st64) 0x8000) >> 0x10)), 0x0, 0x20) == ((st64) ((st32) ((Rxx >> 0x20) & 0xffffffff))) + ((((st64) ((ut64) ((st64) ((st32) ((st64) ((st32) ((Rss >> 0x20) & 0xffffffff)))))) * extract64(((ut64) ((ut16) ((Rtt >> 0x20) & ((st64) 0xffff)))), 0x0, 0x10)) << 0x0) + ((st64) 0x8000) >> 0x10))) {{}} else {set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, ((ut32) 0x1))}, ((((st64) ((st32) ((Rxx >> 0x20) & 0xffffffff))) + ((((st64) ((ut64) ((st64) ((st32) ((st64) ((st32) ((Rss >> 0x20) & 0xffffffff)))))) * extract64(((ut64) ((ut16) ((Rtt >> 0x20) & ((st64) 0xffff)))), 0x0, 0x10)) << 0x0) + ((st64) 0x8000) >> 0x10) < ((st64) 0x0)) ? (-(0x1 << 0x1f)) : (0x1 << 0x1f) - ((st64) 0x1)));
	RzILOpEffect *op_ASSIGN_hybrid_tmp_222 = SETL("h_tmp292", cond_219);

	// seq(HYB(gcc_expr_if ((sextract64(((ut64) ((st64) ((st32) ((Rxx > ...;
	RzILOpEffect *seq_223 = SEQN(2, gcc_expr_220, op_ASSIGN_hybrid_tmp_222);

	// Rxx = ((Rxx & (~(0xffffffff << 0x20))) | ((((sextract64(((ut64) ((st64) ((st32) ((Rxx >> 0x20) & 0xffffffff))) + ((((st64) ((ut64) ((st64) ((st32) ((st64) ((st32) ((Rss >> 0x20) & 0xffffffff)))))) * extract64(((ut64) ((ut16) ((Rtt >> 0x20) & ((st64) 0xffff)))), 0x0, 0x10)) << 0x0) + ((st64) 0x8000) >> 0x10)), 0x0, 0x20) == ((st64) ((st32) ((Rxx >> 0x20) & 0xffffffff))) + ((((st64) ((ut64) ((st64) ((st32) ((st64) ((st32) ((Rss >> 0x20) & 0xffffffff)))))) * extract64(((ut64) ((ut16) ((Rtt >> 0x20) & ((st64) 0xffff)))), 0x0, 0x10)) << 0x0) + ((st64) 0x8000) >> 0x10)) ? ((st64) ((st32) ((Rxx >> 0x20) & 0xffffffff))) + ((((st64) ((ut64) ((st64) ((st32) ((st64) ((st32) ((Rss >> 0x20) & 0xffffffff)))))) * extract64(((ut64) ((ut16) ((Rtt >> 0x20) & ((st64) 0xffff)))), 0x0, 0x10)) << 0x0) + ((st64) 0x8000) >> 0x10) : h_tmp292) & 0xffffffff) << 0x20));
	RzILOpPure *op_LSHIFT_5 = SHIFTL0(SN(64, 0xffffffff), SN(32, 0x20));
	RzILOpPure *op_NOT_6 = LOGNOT(op_LSHIFT_5);
	RzILOpPure *op_AND_7 = LOGAND(READ_REG(pkt, Rxx_op, false), op_NOT_6);
	RzILOpPure *op_RSHIFT_112 = SHIFTRA(READ_REG(pkt, Rxx_op, false), SN(32, 0x20));
	RzILOpPure *op_AND_114 = LOGAND(op_RSHIFT_112, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_120 = SHIFTRA(DUP(Rss), SN(32, 0x20));
	RzILOpPure *op_AND_122 = LOGAND(op_RSHIFT_120, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_133 = SHIFTRA(DUP(Rtt), SN(32, 0x20));
	RzILOpPure *op_AND_136 = LOGAND(op_RSHIFT_133, CAST(64, MSB(SN(32, 0xffff)), SN(32, 0xffff)));
	RzILOpPure *op_MUL_144 = MUL(CAST(64, IL_FALSE, CAST(64, MSB(CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(op_AND_122), DUP(op_AND_122))), CAST(32, MSB(DUP(op_AND_122)), DUP(op_AND_122)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_122)), DUP(op_AND_122))), CAST(32, MSB(DUP(op_AND_122)), DUP(op_AND_122))))), CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(DUP(op_AND_122)), DUP(op_AND_122))), CAST(32, MSB(DUP(op_AND_122)), DUP(op_AND_122)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_122)), DUP(op_AND_122))), CAST(32, MSB(DUP(op_AND_122)), DUP(op_AND_122)))))), EXTRACT64(CAST(64, IL_FALSE, CAST(16, IL_FALSE, op_AND_136)), SN(32, 0), SN(32, 16)));
	RzILOpPure *op_LSHIFT_147 = SHIFTL0(CAST(64, IL_FALSE, op_MUL_144), SN(32, 0));
	RzILOpPure *op_ADD_150 = ADD(op_LSHIFT_147, CAST(64, MSB(SN(32, 0x8000)), SN(32, 0x8000)));
	RzILOpPure *op_RSHIFT_152 = SHIFTRA(op_ADD_150, SN(32, 16));
	RzILOpPure *op_ADD_153 = ADD(CAST(64, MSB(CAST(32, MSB(op_AND_114), DUP(op_AND_114))), CAST(32, MSB(DUP(op_AND_114)), DUP(op_AND_114))), op_RSHIFT_152);
	RzILOpPure *cond_224 = ITE(DUP(op_EQ_108), op_ADD_153, VARL("h_tmp292"));
	RzILOpPure *op_AND_226 = LOGAND(cond_224, SN(64, 0xffffffff));
	RzILOpPure *op_LSHIFT_230 = SHIFTL0(op_AND_226, SN(32, 0x20));
	RzILOpPure *op_OR_231 = LOGOR(op_AND_7, op_LSHIFT_230);
	RzILOpEffect *op_ASSIGN_232 = WRITE_REG(bundle, Rxx_op, op_OR_231);

	// seq(seq(HYB(gcc_expr_if ((sextract64(((ut64) ((st64) ((st32) ((R ...;
	RzILOpEffect *seq_233 = SEQN(2, seq_223, op_ASSIGN_232);

	// set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, ((ut32) 0x1));
	RzILOpEffect *set_usr_field_call_388 = hex_set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, CAST(32, IL_FALSE, SN(32, 1)));

	// HYB(gcc_expr_if ((sextract64(((ut64) ((st64) ((st32) ((Rxx >> 0x0) & 0xffffffff))) + ((((st64) ((ut64) ((st64) ((st32) ((st64) ((st32) ((Rss >> 0x0) & 0xffffffff)))))) * extract64(((ut64) ((ut16) ((Rtt >> 0x0) & ((st64) 0xffff)))), 0x0, 0x10)) << 0x0) + ((st64) 0x8000) >> 0x10)), 0x0, 0x20) == ((st64) ((st32) ((Rxx >> 0x0) & 0xffffffff))) + ((((st64) ((ut64) ((st64) ((st32) ((st64) ((st32) ((Rss >> 0x0) & 0xffffffff)))))) * extract64(((ut64) ((ut16) ((Rtt >> 0x0) & ((st64) 0xffff)))), 0x0, 0x10)) << 0x0) + ((st64) 0x8000) >> 0x10))) {{}} else {set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, ((ut32) 0x1))}, ((((st64) ((st32) ((Rxx >> 0x0) & 0xffffffff))) + ((((st64) ((ut64) ((st64) ((st32) ((st64) ((st32) ((Rss >> 0x0) & 0xffffffff)))))) * extract64(((ut64) ((ut16) ((Rtt >> 0x0) & ((st64) 0xffff)))), 0x0, 0x10)) << 0x0) + ((st64) 0x8000) >> 0x10) < ((st64) 0x0)) ? (-(0x1 << 0x1f)) : (0x1 << 0x1f) - ((st64) 0x1)));
	RzILOpPure *op_RSHIFT_248 = SHIFTRA(READ_REG(pkt, Rxx_op, false), SN(32, 0));
	RzILOpPure *op_AND_250 = LOGAND(op_RSHIFT_248, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_256 = SHIFTRA(DUP(Rss), SN(32, 0));
	RzILOpPure *op_AND_258 = LOGAND(op_RSHIFT_256, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_269 = SHIFTRA(DUP(Rtt), SN(32, 0));
	RzILOpPure *op_AND_272 = LOGAND(op_RSHIFT_269, CAST(64, MSB(SN(32, 0xffff)), SN(32, 0xffff)));
	RzILOpPure *op_MUL_280 = MUL(CAST(64, IL_FALSE, CAST(64, MSB(CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(op_AND_258), DUP(op_AND_258))), CAST(32, MSB(DUP(op_AND_258)), DUP(op_AND_258)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_258)), DUP(op_AND_258))), CAST(32, MSB(DUP(op_AND_258)), DUP(op_AND_258))))), CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(DUP(op_AND_258)), DUP(op_AND_258))), CAST(32, MSB(DUP(op_AND_258)), DUP(op_AND_258)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_258)), DUP(op_AND_258))), CAST(32, MSB(DUP(op_AND_258)), DUP(op_AND_258)))))), EXTRACT64(CAST(64, IL_FALSE, CAST(16, IL_FALSE, op_AND_272)), SN(32, 0), SN(32, 16)));
	RzILOpPure *op_LSHIFT_283 = SHIFTL0(CAST(64, IL_FALSE, op_MUL_280), SN(32, 0));
	RzILOpPure *op_ADD_286 = ADD(op_LSHIFT_283, CAST(64, MSB(SN(32, 0x8000)), SN(32, 0x8000)));
	RzILOpPure *op_RSHIFT_288 = SHIFTRA(op_ADD_286, SN(32, 16));
	RzILOpPure *op_ADD_289 = ADD(CAST(64, MSB(CAST(32, MSB(op_AND_250), DUP(op_AND_250))), CAST(32, MSB(DUP(op_AND_250)), DUP(op_AND_250))), op_RSHIFT_288);
	RzILOpPure *op_RSHIFT_298 = SHIFTRA(READ_REG(pkt, Rxx_op, false), SN(32, 0));
	RzILOpPure *op_AND_300 = LOGAND(op_RSHIFT_298, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_306 = SHIFTRA(DUP(Rss), SN(32, 0));
	RzILOpPure *op_AND_308 = LOGAND(op_RSHIFT_306, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_319 = SHIFTRA(DUP(Rtt), SN(32, 0));
	RzILOpPure *op_AND_322 = LOGAND(op_RSHIFT_319, CAST(64, MSB(SN(32, 0xffff)), SN(32, 0xffff)));
	RzILOpPure *op_MUL_330 = MUL(CAST(64, IL_FALSE, CAST(64, MSB(CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(op_AND_308), DUP(op_AND_308))), CAST(32, MSB(DUP(op_AND_308)), DUP(op_AND_308)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_308)), DUP(op_AND_308))), CAST(32, MSB(DUP(op_AND_308)), DUP(op_AND_308))))), CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(DUP(op_AND_308)), DUP(op_AND_308))), CAST(32, MSB(DUP(op_AND_308)), DUP(op_AND_308)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_308)), DUP(op_AND_308))), CAST(32, MSB(DUP(op_AND_308)), DUP(op_AND_308)))))), EXTRACT64(CAST(64, IL_FALSE, CAST(16, IL_FALSE, op_AND_322)), SN(32, 0), SN(32, 16)));
	RzILOpPure *op_LSHIFT_333 = SHIFTL0(CAST(64, IL_FALSE, op_MUL_330), SN(32, 0));
	RzILOpPure *op_ADD_336 = ADD(op_LSHIFT_333, CAST(64, MSB(SN(32, 0x8000)), SN(32, 0x8000)));
	RzILOpPure *op_RSHIFT_338 = SHIFTRA(op_ADD_336, SN(32, 16));
	RzILOpPure *op_ADD_339 = ADD(CAST(64, MSB(CAST(32, MSB(op_AND_300), DUP(op_AND_300))), CAST(32, MSB(DUP(op_AND_300)), DUP(op_AND_300))), op_RSHIFT_338);
	RzILOpPure *op_EQ_340 = EQ(SEXTRACT64(CAST(64, IL_FALSE, op_ADD_289), SN(32, 0), SN(32, 0x20)), op_ADD_339);
	RzILOpPure *op_RSHIFT_392 = SHIFTRA(READ_REG(pkt, Rxx_op, false), SN(32, 0));
	RzILOpPure *op_AND_394 = LOGAND(op_RSHIFT_392, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_400 = SHIFTRA(DUP(Rss), SN(32, 0));
	RzILOpPure *op_AND_402 = LOGAND(op_RSHIFT_400, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_413 = SHIFTRA(DUP(Rtt), SN(32, 0));
	RzILOpPure *op_AND_416 = LOGAND(op_RSHIFT_413, CAST(64, MSB(SN(32, 0xffff)), SN(32, 0xffff)));
	RzILOpPure *op_MUL_424 = MUL(CAST(64, IL_FALSE, CAST(64, MSB(CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(op_AND_402), DUP(op_AND_402))), CAST(32, MSB(DUP(op_AND_402)), DUP(op_AND_402)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_402)), DUP(op_AND_402))), CAST(32, MSB(DUP(op_AND_402)), DUP(op_AND_402))))), CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(DUP(op_AND_402)), DUP(op_AND_402))), CAST(32, MSB(DUP(op_AND_402)), DUP(op_AND_402)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_402)), DUP(op_AND_402))), CAST(32, MSB(DUP(op_AND_402)), DUP(op_AND_402)))))), EXTRACT64(CAST(64, IL_FALSE, CAST(16, IL_FALSE, op_AND_416)), SN(32, 0), SN(32, 16)));
	RzILOpPure *op_LSHIFT_427 = SHIFTL0(CAST(64, IL_FALSE, op_MUL_424), SN(32, 0));
	RzILOpPure *op_ADD_430 = ADD(op_LSHIFT_427, CAST(64, MSB(SN(32, 0x8000)), SN(32, 0x8000)));
	RzILOpPure *op_RSHIFT_432 = SHIFTRA(op_ADD_430, SN(32, 16));
	RzILOpPure *op_ADD_433 = ADD(CAST(64, MSB(CAST(32, MSB(op_AND_394), DUP(op_AND_394))), CAST(32, MSB(DUP(op_AND_394)), DUP(op_AND_394))), op_RSHIFT_432);
	RzILOpPure *op_LT_436 = SLT(op_ADD_433, CAST(64, MSB(SN(32, 0)), SN(32, 0)));
	RzILOpPure *op_LSHIFT_441 = SHIFTL0(SN(64, 1), SN(32, 31));
	RzILOpPure *op_NEG_442 = NEG(op_LSHIFT_441);
	RzILOpPure *op_LSHIFT_447 = SHIFTL0(SN(64, 1), SN(32, 31));
	RzILOpPure *op_SUB_450 = SUB(op_LSHIFT_447, CAST(64, MSB(SN(32, 1)), SN(32, 1)));
	RzILOpPure *cond_451 = ITE(op_LT_436, op_NEG_442, op_SUB_450);
	RzILOpEffect *gcc_expr_452 = BRANCH(op_EQ_340, EMPTY(), set_usr_field_call_388);

	// h_tmp293 = HYB(gcc_expr_if ((sextract64(((ut64) ((st64) ((st32) ((Rxx >> 0x0) & 0xffffffff))) + ((((st64) ((ut64) ((st64) ((st32) ((st64) ((st32) ((Rss >> 0x0) & 0xffffffff)))))) * extract64(((ut64) ((ut16) ((Rtt >> 0x0) & ((st64) 0xffff)))), 0x0, 0x10)) << 0x0) + ((st64) 0x8000) >> 0x10)), 0x0, 0x20) == ((st64) ((st32) ((Rxx >> 0x0) & 0xffffffff))) + ((((st64) ((ut64) ((st64) ((st32) ((st64) ((st32) ((Rss >> 0x0) & 0xffffffff)))))) * extract64(((ut64) ((ut16) ((Rtt >> 0x0) & ((st64) 0xffff)))), 0x0, 0x10)) << 0x0) + ((st64) 0x8000) >> 0x10))) {{}} else {set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, ((ut32) 0x1))}, ((((st64) ((st32) ((Rxx >> 0x0) & 0xffffffff))) + ((((st64) ((ut64) ((st64) ((st32) ((st64) ((st32) ((Rss >> 0x0) & 0xffffffff)))))) * extract64(((ut64) ((ut16) ((Rtt >> 0x0) & ((st64) 0xffff)))), 0x0, 0x10)) << 0x0) + ((st64) 0x8000) >> 0x10) < ((st64) 0x0)) ? (-(0x1 << 0x1f)) : (0x1 << 0x1f) - ((st64) 0x1)));
	RzILOpEffect *op_ASSIGN_hybrid_tmp_454 = SETL("h_tmp293", cond_451);

	// seq(HYB(gcc_expr_if ((sextract64(((ut64) ((st64) ((st32) ((Rxx > ...;
	RzILOpEffect *seq_455 = SEQN(2, gcc_expr_452, op_ASSIGN_hybrid_tmp_454);

	// Rxx = ((Rxx & (~(0xffffffff << 0x0))) | ((((sextract64(((ut64) ((st64) ((st32) ((Rxx >> 0x0) & 0xffffffff))) + ((((st64) ((ut64) ((st64) ((st32) ((st64) ((st32) ((Rss >> 0x0) & 0xffffffff)))))) * extract64(((ut64) ((ut16) ((Rtt >> 0x0) & ((st64) 0xffff)))), 0x0, 0x10)) << 0x0) + ((st64) 0x8000) >> 0x10)), 0x0, 0x20) == ((st64) ((st32) ((Rxx >> 0x0) & 0xffffffff))) + ((((st64) ((ut64) ((st64) ((st32) ((st64) ((st32) ((Rss >> 0x0) & 0xffffffff)))))) * extract64(((ut64) ((ut16) ((Rtt >> 0x0) & ((st64) 0xffff)))), 0x0, 0x10)) << 0x0) + ((st64) 0x8000) >> 0x10)) ? ((st64) ((st32) ((Rxx >> 0x0) & 0xffffffff))) + ((((st64) ((ut64) ((st64) ((st32) ((st64) ((st32) ((Rss >> 0x0) & 0xffffffff)))))) * extract64(((ut64) ((ut16) ((Rtt >> 0x0) & ((st64) 0xffff)))), 0x0, 0x10)) << 0x0) + ((st64) 0x8000) >> 0x10) : h_tmp293) & 0xffffffff) << 0x0));
	RzILOpPure *op_LSHIFT_239 = SHIFTL0(SN(64, 0xffffffff), SN(32, 0));
	RzILOpPure *op_NOT_240 = LOGNOT(op_LSHIFT_239);
	RzILOpPure *op_AND_241 = LOGAND(READ_REG(pkt, Rxx_op, false), op_NOT_240);
	RzILOpPure *op_RSHIFT_344 = SHIFTRA(READ_REG(pkt, Rxx_op, false), SN(32, 0));
	RzILOpPure *op_AND_346 = LOGAND(op_RSHIFT_344, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_352 = SHIFTRA(DUP(Rss), SN(32, 0));
	RzILOpPure *op_AND_354 = LOGAND(op_RSHIFT_352, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_365 = SHIFTRA(DUP(Rtt), SN(32, 0));
	RzILOpPure *op_AND_368 = LOGAND(op_RSHIFT_365, CAST(64, MSB(SN(32, 0xffff)), SN(32, 0xffff)));
	RzILOpPure *op_MUL_376 = MUL(CAST(64, IL_FALSE, CAST(64, MSB(CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(op_AND_354), DUP(op_AND_354))), CAST(32, MSB(DUP(op_AND_354)), DUP(op_AND_354)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_354)), DUP(op_AND_354))), CAST(32, MSB(DUP(op_AND_354)), DUP(op_AND_354))))), CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(DUP(op_AND_354)), DUP(op_AND_354))), CAST(32, MSB(DUP(op_AND_354)), DUP(op_AND_354)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_354)), DUP(op_AND_354))), CAST(32, MSB(DUP(op_AND_354)), DUP(op_AND_354)))))), EXTRACT64(CAST(64, IL_FALSE, CAST(16, IL_FALSE, op_AND_368)), SN(32, 0), SN(32, 16)));
	RzILOpPure *op_LSHIFT_379 = SHIFTL0(CAST(64, IL_FALSE, op_MUL_376), SN(32, 0));
	RzILOpPure *op_ADD_382 = ADD(op_LSHIFT_379, CAST(64, MSB(SN(32, 0x8000)), SN(32, 0x8000)));
	RzILOpPure *op_RSHIFT_384 = SHIFTRA(op_ADD_382, SN(32, 16));
	RzILOpPure *op_ADD_385 = ADD(CAST(64, MSB(CAST(32, MSB(op_AND_346), DUP(op_AND_346))), CAST(32, MSB(DUP(op_AND_346)), DUP(op_AND_346))), op_RSHIFT_384);
	RzILOpPure *cond_456 = ITE(DUP(op_EQ_340), op_ADD_385, VARL("h_tmp293"));
	RzILOpPure *op_AND_458 = LOGAND(cond_456, SN(64, 0xffffffff));
	RzILOpPure *op_LSHIFT_462 = SHIFTL0(op_AND_458, SN(32, 0));
	RzILOpPure *op_OR_463 = LOGOR(op_AND_241, op_LSHIFT_462);
	RzILOpEffect *op_ASSIGN_464 = WRITE_REG(bundle, Rxx_op, op_OR_463);

	// seq(seq(HYB(gcc_expr_if ((sextract64(((ut64) ((st64) ((st32) ((R ...;
	RzILOpEffect *seq_465 = SEQN(2, seq_455, op_ASSIGN_464);

	RzILOpEffect *instruction_sequence = SEQN(2, seq_233, seq_465);
	return instruction_sequence;
}

// Rxx += vmpyweuh(Rss,Rtt):<<1:rnd:sat
RzILOpEffect *hex_il_op_m2_mmaculs_rs1(HexInsnPktBundle *bundle) {
	const HexInsn *hi = bundle->insn;
	HexPkt *pkt = bundle->pkt;
	// READ
	const HexOp *Rxx_op = ISA2REG(hi, 'x', false);

	const HexOp *Rss_op = ISA2REG(hi, 's', false);
	RzILOpPure *Rss = READ_REG(pkt, Rss_op, false);
	const HexOp *Rtt_op = ISA2REG(hi, 't', false);
	RzILOpPure *Rtt = READ_REG(pkt, Rtt_op, false);

	// set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, ((ut32) 0x1));
	RzILOpEffect *set_usr_field_call_156 = hex_set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, CAST(32, IL_FALSE, SN(32, 1)));

	// HYB(gcc_expr_if ((sextract64(((ut64) ((st64) ((st32) ((Rxx >> 0x20) & 0xffffffff))) + ((((st64) ((ut64) ((st64) ((st32) ((st64) ((st32) ((Rss >> 0x20) & 0xffffffff)))))) * extract64(((ut64) ((ut16) ((Rtt >> 0x20) & ((st64) 0xffff)))), 0x0, 0x10)) << 0x1) + ((st64) 0x8000) >> 0x10)), 0x0, 0x20) == ((st64) ((st32) ((Rxx >> 0x20) & 0xffffffff))) + ((((st64) ((ut64) ((st64) ((st32) ((st64) ((st32) ((Rss >> 0x20) & 0xffffffff)))))) * extract64(((ut64) ((ut16) ((Rtt >> 0x20) & ((st64) 0xffff)))), 0x0, 0x10)) << 0x1) + ((st64) 0x8000) >> 0x10))) {{}} else {set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, ((ut32) 0x1))}, ((((st64) ((st32) ((Rxx >> 0x20) & 0xffffffff))) + ((((st64) ((ut64) ((st64) ((st32) ((st64) ((st32) ((Rss >> 0x20) & 0xffffffff)))))) * extract64(((ut64) ((ut16) ((Rtt >> 0x20) & ((st64) 0xffff)))), 0x0, 0x10)) << 0x1) + ((st64) 0x8000) >> 0x10) < ((st64) 0x0)) ? (-(0x1 << 0x1f)) : (0x1 << 0x1f) - ((st64) 0x1)));
	RzILOpPure *op_RSHIFT_14 = SHIFTRA(READ_REG(pkt, Rxx_op, false), SN(32, 0x20));
	RzILOpPure *op_AND_16 = LOGAND(op_RSHIFT_14, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_23 = SHIFTRA(Rss, SN(32, 0x20));
	RzILOpPure *op_AND_25 = LOGAND(op_RSHIFT_23, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_37 = SHIFTRA(Rtt, SN(32, 0x20));
	RzILOpPure *op_AND_40 = LOGAND(op_RSHIFT_37, CAST(64, MSB(SN(32, 0xffff)), SN(32, 0xffff)));
	RzILOpPure *op_MUL_48 = MUL(CAST(64, IL_FALSE, CAST(64, MSB(CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(op_AND_25), DUP(op_AND_25))), CAST(32, MSB(DUP(op_AND_25)), DUP(op_AND_25)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_25)), DUP(op_AND_25))), CAST(32, MSB(DUP(op_AND_25)), DUP(op_AND_25))))), CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(DUP(op_AND_25)), DUP(op_AND_25))), CAST(32, MSB(DUP(op_AND_25)), DUP(op_AND_25)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_25)), DUP(op_AND_25))), CAST(32, MSB(DUP(op_AND_25)), DUP(op_AND_25)))))), EXTRACT64(CAST(64, IL_FALSE, CAST(16, IL_FALSE, op_AND_40)), SN(32, 0), SN(32, 16)));
	RzILOpPure *op_LSHIFT_51 = SHIFTL0(CAST(64, IL_FALSE, op_MUL_48), SN(32, 1));
	RzILOpPure *op_ADD_54 = ADD(op_LSHIFT_51, CAST(64, MSB(SN(32, 0x8000)), SN(32, 0x8000)));
	RzILOpPure *op_RSHIFT_56 = SHIFTRA(op_ADD_54, SN(32, 16));
	RzILOpPure *op_ADD_57 = ADD(CAST(64, MSB(CAST(32, MSB(op_AND_16), DUP(op_AND_16))), CAST(32, MSB(DUP(op_AND_16)), DUP(op_AND_16))), op_RSHIFT_56);
	RzILOpPure *op_RSHIFT_66 = SHIFTRA(READ_REG(pkt, Rxx_op, false), SN(32, 0x20));
	RzILOpPure *op_AND_68 = LOGAND(op_RSHIFT_66, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_74 = SHIFTRA(DUP(Rss), SN(32, 0x20));
	RzILOpPure *op_AND_76 = LOGAND(op_RSHIFT_74, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_87 = SHIFTRA(DUP(Rtt), SN(32, 0x20));
	RzILOpPure *op_AND_90 = LOGAND(op_RSHIFT_87, CAST(64, MSB(SN(32, 0xffff)), SN(32, 0xffff)));
	RzILOpPure *op_MUL_98 = MUL(CAST(64, IL_FALSE, CAST(64, MSB(CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(op_AND_76), DUP(op_AND_76))), CAST(32, MSB(DUP(op_AND_76)), DUP(op_AND_76)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_76)), DUP(op_AND_76))), CAST(32, MSB(DUP(op_AND_76)), DUP(op_AND_76))))), CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(DUP(op_AND_76)), DUP(op_AND_76))), CAST(32, MSB(DUP(op_AND_76)), DUP(op_AND_76)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_76)), DUP(op_AND_76))), CAST(32, MSB(DUP(op_AND_76)), DUP(op_AND_76)))))), EXTRACT64(CAST(64, IL_FALSE, CAST(16, IL_FALSE, op_AND_90)), SN(32, 0), SN(32, 16)));
	RzILOpPure *op_LSHIFT_101 = SHIFTL0(CAST(64, IL_FALSE, op_MUL_98), SN(32, 1));
	RzILOpPure *op_ADD_104 = ADD(op_LSHIFT_101, CAST(64, MSB(SN(32, 0x8000)), SN(32, 0x8000)));
	RzILOpPure *op_RSHIFT_106 = SHIFTRA(op_ADD_104, SN(32, 16));
	RzILOpPure *op_ADD_107 = ADD(CAST(64, MSB(CAST(32, MSB(op_AND_68), DUP(op_AND_68))), CAST(32, MSB(DUP(op_AND_68)), DUP(op_AND_68))), op_RSHIFT_106);
	RzILOpPure *op_EQ_108 = EQ(SEXTRACT64(CAST(64, IL_FALSE, op_ADD_57), SN(32, 0), SN(32, 0x20)), op_ADD_107);
	RzILOpPure *op_RSHIFT_160 = SHIFTRA(READ_REG(pkt, Rxx_op, false), SN(32, 0x20));
	RzILOpPure *op_AND_162 = LOGAND(op_RSHIFT_160, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_168 = SHIFTRA(DUP(Rss), SN(32, 0x20));
	RzILOpPure *op_AND_170 = LOGAND(op_RSHIFT_168, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_181 = SHIFTRA(DUP(Rtt), SN(32, 0x20));
	RzILOpPure *op_AND_184 = LOGAND(op_RSHIFT_181, CAST(64, MSB(SN(32, 0xffff)), SN(32, 0xffff)));
	RzILOpPure *op_MUL_192 = MUL(CAST(64, IL_FALSE, CAST(64, MSB(CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(op_AND_170), DUP(op_AND_170))), CAST(32, MSB(DUP(op_AND_170)), DUP(op_AND_170)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_170)), DUP(op_AND_170))), CAST(32, MSB(DUP(op_AND_170)), DUP(op_AND_170))))), CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(DUP(op_AND_170)), DUP(op_AND_170))), CAST(32, MSB(DUP(op_AND_170)), DUP(op_AND_170)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_170)), DUP(op_AND_170))), CAST(32, MSB(DUP(op_AND_170)), DUP(op_AND_170)))))), EXTRACT64(CAST(64, IL_FALSE, CAST(16, IL_FALSE, op_AND_184)), SN(32, 0), SN(32, 16)));
	RzILOpPure *op_LSHIFT_195 = SHIFTL0(CAST(64, IL_FALSE, op_MUL_192), SN(32, 1));
	RzILOpPure *op_ADD_198 = ADD(op_LSHIFT_195, CAST(64, MSB(SN(32, 0x8000)), SN(32, 0x8000)));
	RzILOpPure *op_RSHIFT_200 = SHIFTRA(op_ADD_198, SN(32, 16));
	RzILOpPure *op_ADD_201 = ADD(CAST(64, MSB(CAST(32, MSB(op_AND_162), DUP(op_AND_162))), CAST(32, MSB(DUP(op_AND_162)), DUP(op_AND_162))), op_RSHIFT_200);
	RzILOpPure *op_LT_204 = SLT(op_ADD_201, CAST(64, MSB(SN(32, 0)), SN(32, 0)));
	RzILOpPure *op_LSHIFT_209 = SHIFTL0(SN(64, 1), SN(32, 31));
	RzILOpPure *op_NEG_210 = NEG(op_LSHIFT_209);
	RzILOpPure *op_LSHIFT_215 = SHIFTL0(SN(64, 1), SN(32, 31));
	RzILOpPure *op_SUB_218 = SUB(op_LSHIFT_215, CAST(64, MSB(SN(32, 1)), SN(32, 1)));
	RzILOpPure *cond_219 = ITE(op_LT_204, op_NEG_210, op_SUB_218);
	RzILOpEffect *gcc_expr_220 = BRANCH(op_EQ_108, EMPTY(), set_usr_field_call_156);

	// h_tmp294 = HYB(gcc_expr_if ((sextract64(((ut64) ((st64) ((st32) ((Rxx >> 0x20) & 0xffffffff))) + ((((st64) ((ut64) ((st64) ((st32) ((st64) ((st32) ((Rss >> 0x20) & 0xffffffff)))))) * extract64(((ut64) ((ut16) ((Rtt >> 0x20) & ((st64) 0xffff)))), 0x0, 0x10)) << 0x1) + ((st64) 0x8000) >> 0x10)), 0x0, 0x20) == ((st64) ((st32) ((Rxx >> 0x20) & 0xffffffff))) + ((((st64) ((ut64) ((st64) ((st32) ((st64) ((st32) ((Rss >> 0x20) & 0xffffffff)))))) * extract64(((ut64) ((ut16) ((Rtt >> 0x20) & ((st64) 0xffff)))), 0x0, 0x10)) << 0x1) + ((st64) 0x8000) >> 0x10))) {{}} else {set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, ((ut32) 0x1))}, ((((st64) ((st32) ((Rxx >> 0x20) & 0xffffffff))) + ((((st64) ((ut64) ((st64) ((st32) ((st64) ((st32) ((Rss >> 0x20) & 0xffffffff)))))) * extract64(((ut64) ((ut16) ((Rtt >> 0x20) & ((st64) 0xffff)))), 0x0, 0x10)) << 0x1) + ((st64) 0x8000) >> 0x10) < ((st64) 0x0)) ? (-(0x1 << 0x1f)) : (0x1 << 0x1f) - ((st64) 0x1)));
	RzILOpEffect *op_ASSIGN_hybrid_tmp_222 = SETL("h_tmp294", cond_219);

	// seq(HYB(gcc_expr_if ((sextract64(((ut64) ((st64) ((st32) ((Rxx > ...;
	RzILOpEffect *seq_223 = SEQN(2, gcc_expr_220, op_ASSIGN_hybrid_tmp_222);

	// Rxx = ((Rxx & (~(0xffffffff << 0x20))) | ((((sextract64(((ut64) ((st64) ((st32) ((Rxx >> 0x20) & 0xffffffff))) + ((((st64) ((ut64) ((st64) ((st32) ((st64) ((st32) ((Rss >> 0x20) & 0xffffffff)))))) * extract64(((ut64) ((ut16) ((Rtt >> 0x20) & ((st64) 0xffff)))), 0x0, 0x10)) << 0x1) + ((st64) 0x8000) >> 0x10)), 0x0, 0x20) == ((st64) ((st32) ((Rxx >> 0x20) & 0xffffffff))) + ((((st64) ((ut64) ((st64) ((st32) ((st64) ((st32) ((Rss >> 0x20) & 0xffffffff)))))) * extract64(((ut64) ((ut16) ((Rtt >> 0x20) & ((st64) 0xffff)))), 0x0, 0x10)) << 0x1) + ((st64) 0x8000) >> 0x10)) ? ((st64) ((st32) ((Rxx >> 0x20) & 0xffffffff))) + ((((st64) ((ut64) ((st64) ((st32) ((st64) ((st32) ((Rss >> 0x20) & 0xffffffff)))))) * extract64(((ut64) ((ut16) ((Rtt >> 0x20) & ((st64) 0xffff)))), 0x0, 0x10)) << 0x1) + ((st64) 0x8000) >> 0x10) : h_tmp294) & 0xffffffff) << 0x20));
	RzILOpPure *op_LSHIFT_5 = SHIFTL0(SN(64, 0xffffffff), SN(32, 0x20));
	RzILOpPure *op_NOT_6 = LOGNOT(op_LSHIFT_5);
	RzILOpPure *op_AND_7 = LOGAND(READ_REG(pkt, Rxx_op, false), op_NOT_6);
	RzILOpPure *op_RSHIFT_112 = SHIFTRA(READ_REG(pkt, Rxx_op, false), SN(32, 0x20));
	RzILOpPure *op_AND_114 = LOGAND(op_RSHIFT_112, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_120 = SHIFTRA(DUP(Rss), SN(32, 0x20));
	RzILOpPure *op_AND_122 = LOGAND(op_RSHIFT_120, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_133 = SHIFTRA(DUP(Rtt), SN(32, 0x20));
	RzILOpPure *op_AND_136 = LOGAND(op_RSHIFT_133, CAST(64, MSB(SN(32, 0xffff)), SN(32, 0xffff)));
	RzILOpPure *op_MUL_144 = MUL(CAST(64, IL_FALSE, CAST(64, MSB(CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(op_AND_122), DUP(op_AND_122))), CAST(32, MSB(DUP(op_AND_122)), DUP(op_AND_122)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_122)), DUP(op_AND_122))), CAST(32, MSB(DUP(op_AND_122)), DUP(op_AND_122))))), CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(DUP(op_AND_122)), DUP(op_AND_122))), CAST(32, MSB(DUP(op_AND_122)), DUP(op_AND_122)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_122)), DUP(op_AND_122))), CAST(32, MSB(DUP(op_AND_122)), DUP(op_AND_122)))))), EXTRACT64(CAST(64, IL_FALSE, CAST(16, IL_FALSE, op_AND_136)), SN(32, 0), SN(32, 16)));
	RzILOpPure *op_LSHIFT_147 = SHIFTL0(CAST(64, IL_FALSE, op_MUL_144), SN(32, 1));
	RzILOpPure *op_ADD_150 = ADD(op_LSHIFT_147, CAST(64, MSB(SN(32, 0x8000)), SN(32, 0x8000)));
	RzILOpPure *op_RSHIFT_152 = SHIFTRA(op_ADD_150, SN(32, 16));
	RzILOpPure *op_ADD_153 = ADD(CAST(64, MSB(CAST(32, MSB(op_AND_114), DUP(op_AND_114))), CAST(32, MSB(DUP(op_AND_114)), DUP(op_AND_114))), op_RSHIFT_152);
	RzILOpPure *cond_224 = ITE(DUP(op_EQ_108), op_ADD_153, VARL("h_tmp294"));
	RzILOpPure *op_AND_226 = LOGAND(cond_224, SN(64, 0xffffffff));
	RzILOpPure *op_LSHIFT_230 = SHIFTL0(op_AND_226, SN(32, 0x20));
	RzILOpPure *op_OR_231 = LOGOR(op_AND_7, op_LSHIFT_230);
	RzILOpEffect *op_ASSIGN_232 = WRITE_REG(bundle, Rxx_op, op_OR_231);

	// seq(seq(HYB(gcc_expr_if ((sextract64(((ut64) ((st64) ((st32) ((R ...;
	RzILOpEffect *seq_233 = SEQN(2, seq_223, op_ASSIGN_232);

	// set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, ((ut32) 0x1));
	RzILOpEffect *set_usr_field_call_388 = hex_set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, CAST(32, IL_FALSE, SN(32, 1)));

	// HYB(gcc_expr_if ((sextract64(((ut64) ((st64) ((st32) ((Rxx >> 0x0) & 0xffffffff))) + ((((st64) ((ut64) ((st64) ((st32) ((st64) ((st32) ((Rss >> 0x0) & 0xffffffff)))))) * extract64(((ut64) ((ut16) ((Rtt >> 0x0) & ((st64) 0xffff)))), 0x0, 0x10)) << 0x1) + ((st64) 0x8000) >> 0x10)), 0x0, 0x20) == ((st64) ((st32) ((Rxx >> 0x0) & 0xffffffff))) + ((((st64) ((ut64) ((st64) ((st32) ((st64) ((st32) ((Rss >> 0x0) & 0xffffffff)))))) * extract64(((ut64) ((ut16) ((Rtt >> 0x0) & ((st64) 0xffff)))), 0x0, 0x10)) << 0x1) + ((st64) 0x8000) >> 0x10))) {{}} else {set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, ((ut32) 0x1))}, ((((st64) ((st32) ((Rxx >> 0x0) & 0xffffffff))) + ((((st64) ((ut64) ((st64) ((st32) ((st64) ((st32) ((Rss >> 0x0) & 0xffffffff)))))) * extract64(((ut64) ((ut16) ((Rtt >> 0x0) & ((st64) 0xffff)))), 0x0, 0x10)) << 0x1) + ((st64) 0x8000) >> 0x10) < ((st64) 0x0)) ? (-(0x1 << 0x1f)) : (0x1 << 0x1f) - ((st64) 0x1)));
	RzILOpPure *op_RSHIFT_248 = SHIFTRA(READ_REG(pkt, Rxx_op, false), SN(32, 0));
	RzILOpPure *op_AND_250 = LOGAND(op_RSHIFT_248, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_256 = SHIFTRA(DUP(Rss), SN(32, 0));
	RzILOpPure *op_AND_258 = LOGAND(op_RSHIFT_256, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_269 = SHIFTRA(DUP(Rtt), SN(32, 0));
	RzILOpPure *op_AND_272 = LOGAND(op_RSHIFT_269, CAST(64, MSB(SN(32, 0xffff)), SN(32, 0xffff)));
	RzILOpPure *op_MUL_280 = MUL(CAST(64, IL_FALSE, CAST(64, MSB(CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(op_AND_258), DUP(op_AND_258))), CAST(32, MSB(DUP(op_AND_258)), DUP(op_AND_258)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_258)), DUP(op_AND_258))), CAST(32, MSB(DUP(op_AND_258)), DUP(op_AND_258))))), CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(DUP(op_AND_258)), DUP(op_AND_258))), CAST(32, MSB(DUP(op_AND_258)), DUP(op_AND_258)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_258)), DUP(op_AND_258))), CAST(32, MSB(DUP(op_AND_258)), DUP(op_AND_258)))))), EXTRACT64(CAST(64, IL_FALSE, CAST(16, IL_FALSE, op_AND_272)), SN(32, 0), SN(32, 16)));
	RzILOpPure *op_LSHIFT_283 = SHIFTL0(CAST(64, IL_FALSE, op_MUL_280), SN(32, 1));
	RzILOpPure *op_ADD_286 = ADD(op_LSHIFT_283, CAST(64, MSB(SN(32, 0x8000)), SN(32, 0x8000)));
	RzILOpPure *op_RSHIFT_288 = SHIFTRA(op_ADD_286, SN(32, 16));
	RzILOpPure *op_ADD_289 = ADD(CAST(64, MSB(CAST(32, MSB(op_AND_250), DUP(op_AND_250))), CAST(32, MSB(DUP(op_AND_250)), DUP(op_AND_250))), op_RSHIFT_288);
	RzILOpPure *op_RSHIFT_298 = SHIFTRA(READ_REG(pkt, Rxx_op, false), SN(32, 0));
	RzILOpPure *op_AND_300 = LOGAND(op_RSHIFT_298, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_306 = SHIFTRA(DUP(Rss), SN(32, 0));
	RzILOpPure *op_AND_308 = LOGAND(op_RSHIFT_306, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_319 = SHIFTRA(DUP(Rtt), SN(32, 0));
	RzILOpPure *op_AND_322 = LOGAND(op_RSHIFT_319, CAST(64, MSB(SN(32, 0xffff)), SN(32, 0xffff)));
	RzILOpPure *op_MUL_330 = MUL(CAST(64, IL_FALSE, CAST(64, MSB(CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(op_AND_308), DUP(op_AND_308))), CAST(32, MSB(DUP(op_AND_308)), DUP(op_AND_308)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_308)), DUP(op_AND_308))), CAST(32, MSB(DUP(op_AND_308)), DUP(op_AND_308))))), CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(DUP(op_AND_308)), DUP(op_AND_308))), CAST(32, MSB(DUP(op_AND_308)), DUP(op_AND_308)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_308)), DUP(op_AND_308))), CAST(32, MSB(DUP(op_AND_308)), DUP(op_AND_308)))))), EXTRACT64(CAST(64, IL_FALSE, CAST(16, IL_FALSE, op_AND_322)), SN(32, 0), SN(32, 16)));
	RzILOpPure *op_LSHIFT_333 = SHIFTL0(CAST(64, IL_FALSE, op_MUL_330), SN(32, 1));
	RzILOpPure *op_ADD_336 = ADD(op_LSHIFT_333, CAST(64, MSB(SN(32, 0x8000)), SN(32, 0x8000)));
	RzILOpPure *op_RSHIFT_338 = SHIFTRA(op_ADD_336, SN(32, 16));
	RzILOpPure *op_ADD_339 = ADD(CAST(64, MSB(CAST(32, MSB(op_AND_300), DUP(op_AND_300))), CAST(32, MSB(DUP(op_AND_300)), DUP(op_AND_300))), op_RSHIFT_338);
	RzILOpPure *op_EQ_340 = EQ(SEXTRACT64(CAST(64, IL_FALSE, op_ADD_289), SN(32, 0), SN(32, 0x20)), op_ADD_339);
	RzILOpPure *op_RSHIFT_392 = SHIFTRA(READ_REG(pkt, Rxx_op, false), SN(32, 0));
	RzILOpPure *op_AND_394 = LOGAND(op_RSHIFT_392, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_400 = SHIFTRA(DUP(Rss), SN(32, 0));
	RzILOpPure *op_AND_402 = LOGAND(op_RSHIFT_400, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_413 = SHIFTRA(DUP(Rtt), SN(32, 0));
	RzILOpPure *op_AND_416 = LOGAND(op_RSHIFT_413, CAST(64, MSB(SN(32, 0xffff)), SN(32, 0xffff)));
	RzILOpPure *op_MUL_424 = MUL(CAST(64, IL_FALSE, CAST(64, MSB(CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(op_AND_402), DUP(op_AND_402))), CAST(32, MSB(DUP(op_AND_402)), DUP(op_AND_402)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_402)), DUP(op_AND_402))), CAST(32, MSB(DUP(op_AND_402)), DUP(op_AND_402))))), CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(DUP(op_AND_402)), DUP(op_AND_402))), CAST(32, MSB(DUP(op_AND_402)), DUP(op_AND_402)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_402)), DUP(op_AND_402))), CAST(32, MSB(DUP(op_AND_402)), DUP(op_AND_402)))))), EXTRACT64(CAST(64, IL_FALSE, CAST(16, IL_FALSE, op_AND_416)), SN(32, 0), SN(32, 16)));
	RzILOpPure *op_LSHIFT_427 = SHIFTL0(CAST(64, IL_FALSE, op_MUL_424), SN(32, 1));
	RzILOpPure *op_ADD_430 = ADD(op_LSHIFT_427, CAST(64, MSB(SN(32, 0x8000)), SN(32, 0x8000)));
	RzILOpPure *op_RSHIFT_432 = SHIFTRA(op_ADD_430, SN(32, 16));
	RzILOpPure *op_ADD_433 = ADD(CAST(64, MSB(CAST(32, MSB(op_AND_394), DUP(op_AND_394))), CAST(32, MSB(DUP(op_AND_394)), DUP(op_AND_394))), op_RSHIFT_432);
	RzILOpPure *op_LT_436 = SLT(op_ADD_433, CAST(64, MSB(SN(32, 0)), SN(32, 0)));
	RzILOpPure *op_LSHIFT_441 = SHIFTL0(SN(64, 1), SN(32, 31));
	RzILOpPure *op_NEG_442 = NEG(op_LSHIFT_441);
	RzILOpPure *op_LSHIFT_447 = SHIFTL0(SN(64, 1), SN(32, 31));
	RzILOpPure *op_SUB_450 = SUB(op_LSHIFT_447, CAST(64, MSB(SN(32, 1)), SN(32, 1)));
	RzILOpPure *cond_451 = ITE(op_LT_436, op_NEG_442, op_SUB_450);
	RzILOpEffect *gcc_expr_452 = BRANCH(op_EQ_340, EMPTY(), set_usr_field_call_388);

	// h_tmp295 = HYB(gcc_expr_if ((sextract64(((ut64) ((st64) ((st32) ((Rxx >> 0x0) & 0xffffffff))) + ((((st64) ((ut64) ((st64) ((st32) ((st64) ((st32) ((Rss >> 0x0) & 0xffffffff)))))) * extract64(((ut64) ((ut16) ((Rtt >> 0x0) & ((st64) 0xffff)))), 0x0, 0x10)) << 0x1) + ((st64) 0x8000) >> 0x10)), 0x0, 0x20) == ((st64) ((st32) ((Rxx >> 0x0) & 0xffffffff))) + ((((st64) ((ut64) ((st64) ((st32) ((st64) ((st32) ((Rss >> 0x0) & 0xffffffff)))))) * extract64(((ut64) ((ut16) ((Rtt >> 0x0) & ((st64) 0xffff)))), 0x0, 0x10)) << 0x1) + ((st64) 0x8000) >> 0x10))) {{}} else {set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, ((ut32) 0x1))}, ((((st64) ((st32) ((Rxx >> 0x0) & 0xffffffff))) + ((((st64) ((ut64) ((st64) ((st32) ((st64) ((st32) ((Rss >> 0x0) & 0xffffffff)))))) * extract64(((ut64) ((ut16) ((Rtt >> 0x0) & ((st64) 0xffff)))), 0x0, 0x10)) << 0x1) + ((st64) 0x8000) >> 0x10) < ((st64) 0x0)) ? (-(0x1 << 0x1f)) : (0x1 << 0x1f) - ((st64) 0x1)));
	RzILOpEffect *op_ASSIGN_hybrid_tmp_454 = SETL("h_tmp295", cond_451);

	// seq(HYB(gcc_expr_if ((sextract64(((ut64) ((st64) ((st32) ((Rxx > ...;
	RzILOpEffect *seq_455 = SEQN(2, gcc_expr_452, op_ASSIGN_hybrid_tmp_454);

	// Rxx = ((Rxx & (~(0xffffffff << 0x0))) | ((((sextract64(((ut64) ((st64) ((st32) ((Rxx >> 0x0) & 0xffffffff))) + ((((st64) ((ut64) ((st64) ((st32) ((st64) ((st32) ((Rss >> 0x0) & 0xffffffff)))))) * extract64(((ut64) ((ut16) ((Rtt >> 0x0) & ((st64) 0xffff)))), 0x0, 0x10)) << 0x1) + ((st64) 0x8000) >> 0x10)), 0x0, 0x20) == ((st64) ((st32) ((Rxx >> 0x0) & 0xffffffff))) + ((((st64) ((ut64) ((st64) ((st32) ((st64) ((st32) ((Rss >> 0x0) & 0xffffffff)))))) * extract64(((ut64) ((ut16) ((Rtt >> 0x0) & ((st64) 0xffff)))), 0x0, 0x10)) << 0x1) + ((st64) 0x8000) >> 0x10)) ? ((st64) ((st32) ((Rxx >> 0x0) & 0xffffffff))) + ((((st64) ((ut64) ((st64) ((st32) ((st64) ((st32) ((Rss >> 0x0) & 0xffffffff)))))) * extract64(((ut64) ((ut16) ((Rtt >> 0x0) & ((st64) 0xffff)))), 0x0, 0x10)) << 0x1) + ((st64) 0x8000) >> 0x10) : h_tmp295) & 0xffffffff) << 0x0));
	RzILOpPure *op_LSHIFT_239 = SHIFTL0(SN(64, 0xffffffff), SN(32, 0));
	RzILOpPure *op_NOT_240 = LOGNOT(op_LSHIFT_239);
	RzILOpPure *op_AND_241 = LOGAND(READ_REG(pkt, Rxx_op, false), op_NOT_240);
	RzILOpPure *op_RSHIFT_344 = SHIFTRA(READ_REG(pkt, Rxx_op, false), SN(32, 0));
	RzILOpPure *op_AND_346 = LOGAND(op_RSHIFT_344, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_352 = SHIFTRA(DUP(Rss), SN(32, 0));
	RzILOpPure *op_AND_354 = LOGAND(op_RSHIFT_352, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_365 = SHIFTRA(DUP(Rtt), SN(32, 0));
	RzILOpPure *op_AND_368 = LOGAND(op_RSHIFT_365, CAST(64, MSB(SN(32, 0xffff)), SN(32, 0xffff)));
	RzILOpPure *op_MUL_376 = MUL(CAST(64, IL_FALSE, CAST(64, MSB(CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(op_AND_354), DUP(op_AND_354))), CAST(32, MSB(DUP(op_AND_354)), DUP(op_AND_354)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_354)), DUP(op_AND_354))), CAST(32, MSB(DUP(op_AND_354)), DUP(op_AND_354))))), CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(DUP(op_AND_354)), DUP(op_AND_354))), CAST(32, MSB(DUP(op_AND_354)), DUP(op_AND_354)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_354)), DUP(op_AND_354))), CAST(32, MSB(DUP(op_AND_354)), DUP(op_AND_354)))))), EXTRACT64(CAST(64, IL_FALSE, CAST(16, IL_FALSE, op_AND_368)), SN(32, 0), SN(32, 16)));
	RzILOpPure *op_LSHIFT_379 = SHIFTL0(CAST(64, IL_FALSE, op_MUL_376), SN(32, 1));
	RzILOpPure *op_ADD_382 = ADD(op_LSHIFT_379, CAST(64, MSB(SN(32, 0x8000)), SN(32, 0x8000)));
	RzILOpPure *op_RSHIFT_384 = SHIFTRA(op_ADD_382, SN(32, 16));
	RzILOpPure *op_ADD_385 = ADD(CAST(64, MSB(CAST(32, MSB(op_AND_346), DUP(op_AND_346))), CAST(32, MSB(DUP(op_AND_346)), DUP(op_AND_346))), op_RSHIFT_384);
	RzILOpPure *cond_456 = ITE(DUP(op_EQ_340), op_ADD_385, VARL("h_tmp295"));
	RzILOpPure *op_AND_458 = LOGAND(cond_456, SN(64, 0xffffffff));
	RzILOpPure *op_LSHIFT_462 = SHIFTL0(op_AND_458, SN(32, 0));
	RzILOpPure *op_OR_463 = LOGOR(op_AND_241, op_LSHIFT_462);
	RzILOpEffect *op_ASSIGN_464 = WRITE_REG(bundle, Rxx_op, op_OR_463);

	// seq(seq(HYB(gcc_expr_if ((sextract64(((ut64) ((st64) ((st32) ((R ...;
	RzILOpEffect *seq_465 = SEQN(2, seq_455, op_ASSIGN_464);

	RzILOpEffect *instruction_sequence = SEQN(2, seq_233, seq_465);
	return instruction_sequence;
}

// Rxx += vmpyweuh(Rss,Rtt):sat
RzILOpEffect *hex_il_op_m2_mmaculs_s0(HexInsnPktBundle *bundle) {
	const HexInsn *hi = bundle->insn;
	HexPkt *pkt = bundle->pkt;
	// READ
	const HexOp *Rxx_op = ISA2REG(hi, 'x', false);

	const HexOp *Rss_op = ISA2REG(hi, 's', false);
	RzILOpPure *Rss = READ_REG(pkt, Rss_op, false);
	const HexOp *Rtt_op = ISA2REG(hi, 't', false);
	RzILOpPure *Rtt = READ_REG(pkt, Rtt_op, false);

	// set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, ((ut32) 0x1));
	RzILOpEffect *set_usr_field_call_147 = hex_set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, CAST(32, IL_FALSE, SN(32, 1)));

	// HYB(gcc_expr_if ((sextract64(((ut64) ((st64) ((st32) ((Rxx >> 0x20) & 0xffffffff))) + ((((st64) ((ut64) ((st64) ((st32) ((st64) ((st32) ((Rss >> 0x20) & 0xffffffff)))))) * extract64(((ut64) ((ut16) ((Rtt >> 0x20) & ((st64) 0xffff)))), 0x0, 0x10)) << 0x0) >> 0x10)), 0x0, 0x20) == ((st64) ((st32) ((Rxx >> 0x20) & 0xffffffff))) + ((((st64) ((ut64) ((st64) ((st32) ((st64) ((st32) ((Rss >> 0x20) & 0xffffffff)))))) * extract64(((ut64) ((ut16) ((Rtt >> 0x20) & ((st64) 0xffff)))), 0x0, 0x10)) << 0x0) >> 0x10))) {{}} else {set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, ((ut32) 0x1))}, ((((st64) ((st32) ((Rxx >> 0x20) & 0xffffffff))) + ((((st64) ((ut64) ((st64) ((st32) ((st64) ((st32) ((Rss >> 0x20) & 0xffffffff)))))) * extract64(((ut64) ((ut16) ((Rtt >> 0x20) & ((st64) 0xffff)))), 0x0, 0x10)) << 0x0) >> 0x10) < ((st64) 0x0)) ? (-(0x1 << 0x1f)) : (0x1 << 0x1f) - ((st64) 0x1)));
	RzILOpPure *op_RSHIFT_14 = SHIFTRA(READ_REG(pkt, Rxx_op, false), SN(32, 0x20));
	RzILOpPure *op_AND_16 = LOGAND(op_RSHIFT_14, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_23 = SHIFTRA(Rss, SN(32, 0x20));
	RzILOpPure *op_AND_25 = LOGAND(op_RSHIFT_23, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_37 = SHIFTRA(Rtt, SN(32, 0x20));
	RzILOpPure *op_AND_40 = LOGAND(op_RSHIFT_37, CAST(64, MSB(SN(32, 0xffff)), SN(32, 0xffff)));
	RzILOpPure *op_MUL_48 = MUL(CAST(64, IL_FALSE, CAST(64, MSB(CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(op_AND_25), DUP(op_AND_25))), CAST(32, MSB(DUP(op_AND_25)), DUP(op_AND_25)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_25)), DUP(op_AND_25))), CAST(32, MSB(DUP(op_AND_25)), DUP(op_AND_25))))), CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(DUP(op_AND_25)), DUP(op_AND_25))), CAST(32, MSB(DUP(op_AND_25)), DUP(op_AND_25)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_25)), DUP(op_AND_25))), CAST(32, MSB(DUP(op_AND_25)), DUP(op_AND_25)))))), EXTRACT64(CAST(64, IL_FALSE, CAST(16, IL_FALSE, op_AND_40)), SN(32, 0), SN(32, 16)));
	RzILOpPure *op_LSHIFT_51 = SHIFTL0(CAST(64, IL_FALSE, op_MUL_48), SN(32, 0));
	RzILOpPure *op_RSHIFT_53 = SHIFTRA(op_LSHIFT_51, SN(32, 16));
	RzILOpPure *op_ADD_54 = ADD(CAST(64, MSB(CAST(32, MSB(op_AND_16), DUP(op_AND_16))), CAST(32, MSB(DUP(op_AND_16)), DUP(op_AND_16))), op_RSHIFT_53);
	RzILOpPure *op_RSHIFT_63 = SHIFTRA(READ_REG(pkt, Rxx_op, false), SN(32, 0x20));
	RzILOpPure *op_AND_65 = LOGAND(op_RSHIFT_63, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_71 = SHIFTRA(DUP(Rss), SN(32, 0x20));
	RzILOpPure *op_AND_73 = LOGAND(op_RSHIFT_71, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_84 = SHIFTRA(DUP(Rtt), SN(32, 0x20));
	RzILOpPure *op_AND_87 = LOGAND(op_RSHIFT_84, CAST(64, MSB(SN(32, 0xffff)), SN(32, 0xffff)));
	RzILOpPure *op_MUL_95 = MUL(CAST(64, IL_FALSE, CAST(64, MSB(CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(op_AND_73), DUP(op_AND_73))), CAST(32, MSB(DUP(op_AND_73)), DUP(op_AND_73)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_73)), DUP(op_AND_73))), CAST(32, MSB(DUP(op_AND_73)), DUP(op_AND_73))))), CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(DUP(op_AND_73)), DUP(op_AND_73))), CAST(32, MSB(DUP(op_AND_73)), DUP(op_AND_73)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_73)), DUP(op_AND_73))), CAST(32, MSB(DUP(op_AND_73)), DUP(op_AND_73)))))), EXTRACT64(CAST(64, IL_FALSE, CAST(16, IL_FALSE, op_AND_87)), SN(32, 0), SN(32, 16)));
	RzILOpPure *op_LSHIFT_98 = SHIFTL0(CAST(64, IL_FALSE, op_MUL_95), SN(32, 0));
	RzILOpPure *op_RSHIFT_100 = SHIFTRA(op_LSHIFT_98, SN(32, 16));
	RzILOpPure *op_ADD_101 = ADD(CAST(64, MSB(CAST(32, MSB(op_AND_65), DUP(op_AND_65))), CAST(32, MSB(DUP(op_AND_65)), DUP(op_AND_65))), op_RSHIFT_100);
	RzILOpPure *op_EQ_102 = EQ(SEXTRACT64(CAST(64, IL_FALSE, op_ADD_54), SN(32, 0), SN(32, 0x20)), op_ADD_101);
	RzILOpPure *op_RSHIFT_151 = SHIFTRA(READ_REG(pkt, Rxx_op, false), SN(32, 0x20));
	RzILOpPure *op_AND_153 = LOGAND(op_RSHIFT_151, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_159 = SHIFTRA(DUP(Rss), SN(32, 0x20));
	RzILOpPure *op_AND_161 = LOGAND(op_RSHIFT_159, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_172 = SHIFTRA(DUP(Rtt), SN(32, 0x20));
	RzILOpPure *op_AND_175 = LOGAND(op_RSHIFT_172, CAST(64, MSB(SN(32, 0xffff)), SN(32, 0xffff)));
	RzILOpPure *op_MUL_183 = MUL(CAST(64, IL_FALSE, CAST(64, MSB(CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(op_AND_161), DUP(op_AND_161))), CAST(32, MSB(DUP(op_AND_161)), DUP(op_AND_161)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_161)), DUP(op_AND_161))), CAST(32, MSB(DUP(op_AND_161)), DUP(op_AND_161))))), CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(DUP(op_AND_161)), DUP(op_AND_161))), CAST(32, MSB(DUP(op_AND_161)), DUP(op_AND_161)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_161)), DUP(op_AND_161))), CAST(32, MSB(DUP(op_AND_161)), DUP(op_AND_161)))))), EXTRACT64(CAST(64, IL_FALSE, CAST(16, IL_FALSE, op_AND_175)), SN(32, 0), SN(32, 16)));
	RzILOpPure *op_LSHIFT_186 = SHIFTL0(CAST(64, IL_FALSE, op_MUL_183), SN(32, 0));
	RzILOpPure *op_RSHIFT_188 = SHIFTRA(op_LSHIFT_186, SN(32, 16));
	RzILOpPure *op_ADD_189 = ADD(CAST(64, MSB(CAST(32, MSB(op_AND_153), DUP(op_AND_153))), CAST(32, MSB(DUP(op_AND_153)), DUP(op_AND_153))), op_RSHIFT_188);
	RzILOpPure *op_LT_192 = SLT(op_ADD_189, CAST(64, MSB(SN(32, 0)), SN(32, 0)));
	RzILOpPure *op_LSHIFT_197 = SHIFTL0(SN(64, 1), SN(32, 31));
	RzILOpPure *op_NEG_198 = NEG(op_LSHIFT_197);
	RzILOpPure *op_LSHIFT_203 = SHIFTL0(SN(64, 1), SN(32, 31));
	RzILOpPure *op_SUB_206 = SUB(op_LSHIFT_203, CAST(64, MSB(SN(32, 1)), SN(32, 1)));
	RzILOpPure *cond_207 = ITE(op_LT_192, op_NEG_198, op_SUB_206);
	RzILOpEffect *gcc_expr_208 = BRANCH(op_EQ_102, EMPTY(), set_usr_field_call_147);

	// h_tmp296 = HYB(gcc_expr_if ((sextract64(((ut64) ((st64) ((st32) ((Rxx >> 0x20) & 0xffffffff))) + ((((st64) ((ut64) ((st64) ((st32) ((st64) ((st32) ((Rss >> 0x20) & 0xffffffff)))))) * extract64(((ut64) ((ut16) ((Rtt >> 0x20) & ((st64) 0xffff)))), 0x0, 0x10)) << 0x0) >> 0x10)), 0x0, 0x20) == ((st64) ((st32) ((Rxx >> 0x20) & 0xffffffff))) + ((((st64) ((ut64) ((st64) ((st32) ((st64) ((st32) ((Rss >> 0x20) & 0xffffffff)))))) * extract64(((ut64) ((ut16) ((Rtt >> 0x20) & ((st64) 0xffff)))), 0x0, 0x10)) << 0x0) >> 0x10))) {{}} else {set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, ((ut32) 0x1))}, ((((st64) ((st32) ((Rxx >> 0x20) & 0xffffffff))) + ((((st64) ((ut64) ((st64) ((st32) ((st64) ((st32) ((Rss >> 0x20) & 0xffffffff)))))) * extract64(((ut64) ((ut16) ((Rtt >> 0x20) & ((st64) 0xffff)))), 0x0, 0x10)) << 0x0) >> 0x10) < ((st64) 0x0)) ? (-(0x1 << 0x1f)) : (0x1 << 0x1f) - ((st64) 0x1)));
	RzILOpEffect *op_ASSIGN_hybrid_tmp_210 = SETL("h_tmp296", cond_207);

	// seq(HYB(gcc_expr_if ((sextract64(((ut64) ((st64) ((st32) ((Rxx > ...;
	RzILOpEffect *seq_211 = SEQN(2, gcc_expr_208, op_ASSIGN_hybrid_tmp_210);

	// Rxx = ((Rxx & (~(0xffffffff << 0x20))) | ((((sextract64(((ut64) ((st64) ((st32) ((Rxx >> 0x20) & 0xffffffff))) + ((((st64) ((ut64) ((st64) ((st32) ((st64) ((st32) ((Rss >> 0x20) & 0xffffffff)))))) * extract64(((ut64) ((ut16) ((Rtt >> 0x20) & ((st64) 0xffff)))), 0x0, 0x10)) << 0x0) >> 0x10)), 0x0, 0x20) == ((st64) ((st32) ((Rxx >> 0x20) & 0xffffffff))) + ((((st64) ((ut64) ((st64) ((st32) ((st64) ((st32) ((Rss >> 0x20) & 0xffffffff)))))) * extract64(((ut64) ((ut16) ((Rtt >> 0x20) & ((st64) 0xffff)))), 0x0, 0x10)) << 0x0) >> 0x10)) ? ((st64) ((st32) ((Rxx >> 0x20) & 0xffffffff))) + ((((st64) ((ut64) ((st64) ((st32) ((st64) ((st32) ((Rss >> 0x20) & 0xffffffff)))))) * extract64(((ut64) ((ut16) ((Rtt >> 0x20) & ((st64) 0xffff)))), 0x0, 0x10)) << 0x0) >> 0x10) : h_tmp296) & 0xffffffff) << 0x20));
	RzILOpPure *op_LSHIFT_5 = SHIFTL0(SN(64, 0xffffffff), SN(32, 0x20));
	RzILOpPure *op_NOT_6 = LOGNOT(op_LSHIFT_5);
	RzILOpPure *op_AND_7 = LOGAND(READ_REG(pkt, Rxx_op, false), op_NOT_6);
	RzILOpPure *op_RSHIFT_106 = SHIFTRA(READ_REG(pkt, Rxx_op, false), SN(32, 0x20));
	RzILOpPure *op_AND_108 = LOGAND(op_RSHIFT_106, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_114 = SHIFTRA(DUP(Rss), SN(32, 0x20));
	RzILOpPure *op_AND_116 = LOGAND(op_RSHIFT_114, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_127 = SHIFTRA(DUP(Rtt), SN(32, 0x20));
	RzILOpPure *op_AND_130 = LOGAND(op_RSHIFT_127, CAST(64, MSB(SN(32, 0xffff)), SN(32, 0xffff)));
	RzILOpPure *op_MUL_138 = MUL(CAST(64, IL_FALSE, CAST(64, MSB(CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(op_AND_116), DUP(op_AND_116))), CAST(32, MSB(DUP(op_AND_116)), DUP(op_AND_116)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_116)), DUP(op_AND_116))), CAST(32, MSB(DUP(op_AND_116)), DUP(op_AND_116))))), CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(DUP(op_AND_116)), DUP(op_AND_116))), CAST(32, MSB(DUP(op_AND_116)), DUP(op_AND_116)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_116)), DUP(op_AND_116))), CAST(32, MSB(DUP(op_AND_116)), DUP(op_AND_116)))))), EXTRACT64(CAST(64, IL_FALSE, CAST(16, IL_FALSE, op_AND_130)), SN(32, 0), SN(32, 16)));
	RzILOpPure *op_LSHIFT_141 = SHIFTL0(CAST(64, IL_FALSE, op_MUL_138), SN(32, 0));
	RzILOpPure *op_RSHIFT_143 = SHIFTRA(op_LSHIFT_141, SN(32, 16));
	RzILOpPure *op_ADD_144 = ADD(CAST(64, MSB(CAST(32, MSB(op_AND_108), DUP(op_AND_108))), CAST(32, MSB(DUP(op_AND_108)), DUP(op_AND_108))), op_RSHIFT_143);
	RzILOpPure *cond_212 = ITE(DUP(op_EQ_102), op_ADD_144, VARL("h_tmp296"));
	RzILOpPure *op_AND_214 = LOGAND(cond_212, SN(64, 0xffffffff));
	RzILOpPure *op_LSHIFT_218 = SHIFTL0(op_AND_214, SN(32, 0x20));
	RzILOpPure *op_OR_219 = LOGOR(op_AND_7, op_LSHIFT_218);
	RzILOpEffect *op_ASSIGN_220 = WRITE_REG(bundle, Rxx_op, op_OR_219);

	// seq(seq(HYB(gcc_expr_if ((sextract64(((ut64) ((st64) ((st32) ((R ...;
	RzILOpEffect *seq_221 = SEQN(2, seq_211, op_ASSIGN_220);

	// set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, ((ut32) 0x1));
	RzILOpEffect *set_usr_field_call_367 = hex_set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, CAST(32, IL_FALSE, SN(32, 1)));

	// HYB(gcc_expr_if ((sextract64(((ut64) ((st64) ((st32) ((Rxx >> 0x0) & 0xffffffff))) + ((((st64) ((ut64) ((st64) ((st32) ((st64) ((st32) ((Rss >> 0x0) & 0xffffffff)))))) * extract64(((ut64) ((ut16) ((Rtt >> 0x0) & ((st64) 0xffff)))), 0x0, 0x10)) << 0x0) >> 0x10)), 0x0, 0x20) == ((st64) ((st32) ((Rxx >> 0x0) & 0xffffffff))) + ((((st64) ((ut64) ((st64) ((st32) ((st64) ((st32) ((Rss >> 0x0) & 0xffffffff)))))) * extract64(((ut64) ((ut16) ((Rtt >> 0x0) & ((st64) 0xffff)))), 0x0, 0x10)) << 0x0) >> 0x10))) {{}} else {set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, ((ut32) 0x1))}, ((((st64) ((st32) ((Rxx >> 0x0) & 0xffffffff))) + ((((st64) ((ut64) ((st64) ((st32) ((st64) ((st32) ((Rss >> 0x0) & 0xffffffff)))))) * extract64(((ut64) ((ut16) ((Rtt >> 0x0) & ((st64) 0xffff)))), 0x0, 0x10)) << 0x0) >> 0x10) < ((st64) 0x0)) ? (-(0x1 << 0x1f)) : (0x1 << 0x1f) - ((st64) 0x1)));
	RzILOpPure *op_RSHIFT_236 = SHIFTRA(READ_REG(pkt, Rxx_op, false), SN(32, 0));
	RzILOpPure *op_AND_238 = LOGAND(op_RSHIFT_236, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_244 = SHIFTRA(DUP(Rss), SN(32, 0));
	RzILOpPure *op_AND_246 = LOGAND(op_RSHIFT_244, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_257 = SHIFTRA(DUP(Rtt), SN(32, 0));
	RzILOpPure *op_AND_260 = LOGAND(op_RSHIFT_257, CAST(64, MSB(SN(32, 0xffff)), SN(32, 0xffff)));
	RzILOpPure *op_MUL_268 = MUL(CAST(64, IL_FALSE, CAST(64, MSB(CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(op_AND_246), DUP(op_AND_246))), CAST(32, MSB(DUP(op_AND_246)), DUP(op_AND_246)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_246)), DUP(op_AND_246))), CAST(32, MSB(DUP(op_AND_246)), DUP(op_AND_246))))), CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(DUP(op_AND_246)), DUP(op_AND_246))), CAST(32, MSB(DUP(op_AND_246)), DUP(op_AND_246)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_246)), DUP(op_AND_246))), CAST(32, MSB(DUP(op_AND_246)), DUP(op_AND_246)))))), EXTRACT64(CAST(64, IL_FALSE, CAST(16, IL_FALSE, op_AND_260)), SN(32, 0), SN(32, 16)));
	RzILOpPure *op_LSHIFT_271 = SHIFTL0(CAST(64, IL_FALSE, op_MUL_268), SN(32, 0));
	RzILOpPure *op_RSHIFT_273 = SHIFTRA(op_LSHIFT_271, SN(32, 16));
	RzILOpPure *op_ADD_274 = ADD(CAST(64, MSB(CAST(32, MSB(op_AND_238), DUP(op_AND_238))), CAST(32, MSB(DUP(op_AND_238)), DUP(op_AND_238))), op_RSHIFT_273);
	RzILOpPure *op_RSHIFT_283 = SHIFTRA(READ_REG(pkt, Rxx_op, false), SN(32, 0));
	RzILOpPure *op_AND_285 = LOGAND(op_RSHIFT_283, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_291 = SHIFTRA(DUP(Rss), SN(32, 0));
	RzILOpPure *op_AND_293 = LOGAND(op_RSHIFT_291, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_304 = SHIFTRA(DUP(Rtt), SN(32, 0));
	RzILOpPure *op_AND_307 = LOGAND(op_RSHIFT_304, CAST(64, MSB(SN(32, 0xffff)), SN(32, 0xffff)));
	RzILOpPure *op_MUL_315 = MUL(CAST(64, IL_FALSE, CAST(64, MSB(CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(op_AND_293), DUP(op_AND_293))), CAST(32, MSB(DUP(op_AND_293)), DUP(op_AND_293)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_293)), DUP(op_AND_293))), CAST(32, MSB(DUP(op_AND_293)), DUP(op_AND_293))))), CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(DUP(op_AND_293)), DUP(op_AND_293))), CAST(32, MSB(DUP(op_AND_293)), DUP(op_AND_293)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_293)), DUP(op_AND_293))), CAST(32, MSB(DUP(op_AND_293)), DUP(op_AND_293)))))), EXTRACT64(CAST(64, IL_FALSE, CAST(16, IL_FALSE, op_AND_307)), SN(32, 0), SN(32, 16)));
	RzILOpPure *op_LSHIFT_318 = SHIFTL0(CAST(64, IL_FALSE, op_MUL_315), SN(32, 0));
	RzILOpPure *op_RSHIFT_320 = SHIFTRA(op_LSHIFT_318, SN(32, 16));
	RzILOpPure *op_ADD_321 = ADD(CAST(64, MSB(CAST(32, MSB(op_AND_285), DUP(op_AND_285))), CAST(32, MSB(DUP(op_AND_285)), DUP(op_AND_285))), op_RSHIFT_320);
	RzILOpPure *op_EQ_322 = EQ(SEXTRACT64(CAST(64, IL_FALSE, op_ADD_274), SN(32, 0), SN(32, 0x20)), op_ADD_321);
	RzILOpPure *op_RSHIFT_371 = SHIFTRA(READ_REG(pkt, Rxx_op, false), SN(32, 0));
	RzILOpPure *op_AND_373 = LOGAND(op_RSHIFT_371, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_379 = SHIFTRA(DUP(Rss), SN(32, 0));
	RzILOpPure *op_AND_381 = LOGAND(op_RSHIFT_379, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_392 = SHIFTRA(DUP(Rtt), SN(32, 0));
	RzILOpPure *op_AND_395 = LOGAND(op_RSHIFT_392, CAST(64, MSB(SN(32, 0xffff)), SN(32, 0xffff)));
	RzILOpPure *op_MUL_403 = MUL(CAST(64, IL_FALSE, CAST(64, MSB(CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(op_AND_381), DUP(op_AND_381))), CAST(32, MSB(DUP(op_AND_381)), DUP(op_AND_381)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_381)), DUP(op_AND_381))), CAST(32, MSB(DUP(op_AND_381)), DUP(op_AND_381))))), CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(DUP(op_AND_381)), DUP(op_AND_381))), CAST(32, MSB(DUP(op_AND_381)), DUP(op_AND_381)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_381)), DUP(op_AND_381))), CAST(32, MSB(DUP(op_AND_381)), DUP(op_AND_381)))))), EXTRACT64(CAST(64, IL_FALSE, CAST(16, IL_FALSE, op_AND_395)), SN(32, 0), SN(32, 16)));
	RzILOpPure *op_LSHIFT_406 = SHIFTL0(CAST(64, IL_FALSE, op_MUL_403), SN(32, 0));
	RzILOpPure *op_RSHIFT_408 = SHIFTRA(op_LSHIFT_406, SN(32, 16));
	RzILOpPure *op_ADD_409 = ADD(CAST(64, MSB(CAST(32, MSB(op_AND_373), DUP(op_AND_373))), CAST(32, MSB(DUP(op_AND_373)), DUP(op_AND_373))), op_RSHIFT_408);
	RzILOpPure *op_LT_412 = SLT(op_ADD_409, CAST(64, MSB(SN(32, 0)), SN(32, 0)));
	RzILOpPure *op_LSHIFT_417 = SHIFTL0(SN(64, 1), SN(32, 31));
	RzILOpPure *op_NEG_418 = NEG(op_LSHIFT_417);
	RzILOpPure *op_LSHIFT_423 = SHIFTL0(SN(64, 1), SN(32, 31));
	RzILOpPure *op_SUB_426 = SUB(op_LSHIFT_423, CAST(64, MSB(SN(32, 1)), SN(32, 1)));
	RzILOpPure *cond_427 = ITE(op_LT_412, op_NEG_418, op_SUB_426);
	RzILOpEffect *gcc_expr_428 = BRANCH(op_EQ_322, EMPTY(), set_usr_field_call_367);

	// h_tmp297 = HYB(gcc_expr_if ((sextract64(((ut64) ((st64) ((st32) ((Rxx >> 0x0) & 0xffffffff))) + ((((st64) ((ut64) ((st64) ((st32) ((st64) ((st32) ((Rss >> 0x0) & 0xffffffff)))))) * extract64(((ut64) ((ut16) ((Rtt >> 0x0) & ((st64) 0xffff)))), 0x0, 0x10)) << 0x0) >> 0x10)), 0x0, 0x20) == ((st64) ((st32) ((Rxx >> 0x0) & 0xffffffff))) + ((((st64) ((ut64) ((st64) ((st32) ((st64) ((st32) ((Rss >> 0x0) & 0xffffffff)))))) * extract64(((ut64) ((ut16) ((Rtt >> 0x0) & ((st64) 0xffff)))), 0x0, 0x10)) << 0x0) >> 0x10))) {{}} else {set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, ((ut32) 0x1))}, ((((st64) ((st32) ((Rxx >> 0x0) & 0xffffffff))) + ((((st64) ((ut64) ((st64) ((st32) ((st64) ((st32) ((Rss >> 0x0) & 0xffffffff)))))) * extract64(((ut64) ((ut16) ((Rtt >> 0x0) & ((st64) 0xffff)))), 0x0, 0x10)) << 0x0) >> 0x10) < ((st64) 0x0)) ? (-(0x1 << 0x1f)) : (0x1 << 0x1f) - ((st64) 0x1)));
	RzILOpEffect *op_ASSIGN_hybrid_tmp_430 = SETL("h_tmp297", cond_427);

	// seq(HYB(gcc_expr_if ((sextract64(((ut64) ((st64) ((st32) ((Rxx > ...;
	RzILOpEffect *seq_431 = SEQN(2, gcc_expr_428, op_ASSIGN_hybrid_tmp_430);

	// Rxx = ((Rxx & (~(0xffffffff << 0x0))) | ((((sextract64(((ut64) ((st64) ((st32) ((Rxx >> 0x0) & 0xffffffff))) + ((((st64) ((ut64) ((st64) ((st32) ((st64) ((st32) ((Rss >> 0x0) & 0xffffffff)))))) * extract64(((ut64) ((ut16) ((Rtt >> 0x0) & ((st64) 0xffff)))), 0x0, 0x10)) << 0x0) >> 0x10)), 0x0, 0x20) == ((st64) ((st32) ((Rxx >> 0x0) & 0xffffffff))) + ((((st64) ((ut64) ((st64) ((st32) ((st64) ((st32) ((Rss >> 0x0) & 0xffffffff)))))) * extract64(((ut64) ((ut16) ((Rtt >> 0x0) & ((st64) 0xffff)))), 0x0, 0x10)) << 0x0) >> 0x10)) ? ((st64) ((st32) ((Rxx >> 0x0) & 0xffffffff))) + ((((st64) ((ut64) ((st64) ((st32) ((st64) ((st32) ((Rss >> 0x0) & 0xffffffff)))))) * extract64(((ut64) ((ut16) ((Rtt >> 0x0) & ((st64) 0xffff)))), 0x0, 0x10)) << 0x0) >> 0x10) : h_tmp297) & 0xffffffff) << 0x0));
	RzILOpPure *op_LSHIFT_227 = SHIFTL0(SN(64, 0xffffffff), SN(32, 0));
	RzILOpPure *op_NOT_228 = LOGNOT(op_LSHIFT_227);
	RzILOpPure *op_AND_229 = LOGAND(READ_REG(pkt, Rxx_op, false), op_NOT_228);
	RzILOpPure *op_RSHIFT_326 = SHIFTRA(READ_REG(pkt, Rxx_op, false), SN(32, 0));
	RzILOpPure *op_AND_328 = LOGAND(op_RSHIFT_326, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_334 = SHIFTRA(DUP(Rss), SN(32, 0));
	RzILOpPure *op_AND_336 = LOGAND(op_RSHIFT_334, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_347 = SHIFTRA(DUP(Rtt), SN(32, 0));
	RzILOpPure *op_AND_350 = LOGAND(op_RSHIFT_347, CAST(64, MSB(SN(32, 0xffff)), SN(32, 0xffff)));
	RzILOpPure *op_MUL_358 = MUL(CAST(64, IL_FALSE, CAST(64, MSB(CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(op_AND_336), DUP(op_AND_336))), CAST(32, MSB(DUP(op_AND_336)), DUP(op_AND_336)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_336)), DUP(op_AND_336))), CAST(32, MSB(DUP(op_AND_336)), DUP(op_AND_336))))), CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(DUP(op_AND_336)), DUP(op_AND_336))), CAST(32, MSB(DUP(op_AND_336)), DUP(op_AND_336)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_336)), DUP(op_AND_336))), CAST(32, MSB(DUP(op_AND_336)), DUP(op_AND_336)))))), EXTRACT64(CAST(64, IL_FALSE, CAST(16, IL_FALSE, op_AND_350)), SN(32, 0), SN(32, 16)));
	RzILOpPure *op_LSHIFT_361 = SHIFTL0(CAST(64, IL_FALSE, op_MUL_358), SN(32, 0));
	RzILOpPure *op_RSHIFT_363 = SHIFTRA(op_LSHIFT_361, SN(32, 16));
	RzILOpPure *op_ADD_364 = ADD(CAST(64, MSB(CAST(32, MSB(op_AND_328), DUP(op_AND_328))), CAST(32, MSB(DUP(op_AND_328)), DUP(op_AND_328))), op_RSHIFT_363);
	RzILOpPure *cond_432 = ITE(DUP(op_EQ_322), op_ADD_364, VARL("h_tmp297"));
	RzILOpPure *op_AND_434 = LOGAND(cond_432, SN(64, 0xffffffff));
	RzILOpPure *op_LSHIFT_438 = SHIFTL0(op_AND_434, SN(32, 0));
	RzILOpPure *op_OR_439 = LOGOR(op_AND_229, op_LSHIFT_438);
	RzILOpEffect *op_ASSIGN_440 = WRITE_REG(bundle, Rxx_op, op_OR_439);

	// seq(seq(HYB(gcc_expr_if ((sextract64(((ut64) ((st64) ((st32) ((R ...;
	RzILOpEffect *seq_441 = SEQN(2, seq_431, op_ASSIGN_440);

	RzILOpEffect *instruction_sequence = SEQN(2, seq_221, seq_441);
	return instruction_sequence;
}

// Rxx += vmpyweuh(Rss,Rtt):<<1:sat
RzILOpEffect *hex_il_op_m2_mmaculs_s1(HexInsnPktBundle *bundle) {
	const HexInsn *hi = bundle->insn;
	HexPkt *pkt = bundle->pkt;
	// READ
	const HexOp *Rxx_op = ISA2REG(hi, 'x', false);

	const HexOp *Rss_op = ISA2REG(hi, 's', false);
	RzILOpPure *Rss = READ_REG(pkt, Rss_op, false);
	const HexOp *Rtt_op = ISA2REG(hi, 't', false);
	RzILOpPure *Rtt = READ_REG(pkt, Rtt_op, false);

	// set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, ((ut32) 0x1));
	RzILOpEffect *set_usr_field_call_147 = hex_set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, CAST(32, IL_FALSE, SN(32, 1)));

	// HYB(gcc_expr_if ((sextract64(((ut64) ((st64) ((st32) ((Rxx >> 0x20) & 0xffffffff))) + ((((st64) ((ut64) ((st64) ((st32) ((st64) ((st32) ((Rss >> 0x20) & 0xffffffff)))))) * extract64(((ut64) ((ut16) ((Rtt >> 0x20) & ((st64) 0xffff)))), 0x0, 0x10)) << 0x1) >> 0x10)), 0x0, 0x20) == ((st64) ((st32) ((Rxx >> 0x20) & 0xffffffff))) + ((((st64) ((ut64) ((st64) ((st32) ((st64) ((st32) ((Rss >> 0x20) & 0xffffffff)))))) * extract64(((ut64) ((ut16) ((Rtt >> 0x20) & ((st64) 0xffff)))), 0x0, 0x10)) << 0x1) >> 0x10))) {{}} else {set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, ((ut32) 0x1))}, ((((st64) ((st32) ((Rxx >> 0x20) & 0xffffffff))) + ((((st64) ((ut64) ((st64) ((st32) ((st64) ((st32) ((Rss >> 0x20) & 0xffffffff)))))) * extract64(((ut64) ((ut16) ((Rtt >> 0x20) & ((st64) 0xffff)))), 0x0, 0x10)) << 0x1) >> 0x10) < ((st64) 0x0)) ? (-(0x1 << 0x1f)) : (0x1 << 0x1f) - ((st64) 0x1)));
	RzILOpPure *op_RSHIFT_14 = SHIFTRA(READ_REG(pkt, Rxx_op, false), SN(32, 0x20));
	RzILOpPure *op_AND_16 = LOGAND(op_RSHIFT_14, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_23 = SHIFTRA(Rss, SN(32, 0x20));
	RzILOpPure *op_AND_25 = LOGAND(op_RSHIFT_23, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_37 = SHIFTRA(Rtt, SN(32, 0x20));
	RzILOpPure *op_AND_40 = LOGAND(op_RSHIFT_37, CAST(64, MSB(SN(32, 0xffff)), SN(32, 0xffff)));
	RzILOpPure *op_MUL_48 = MUL(CAST(64, IL_FALSE, CAST(64, MSB(CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(op_AND_25), DUP(op_AND_25))), CAST(32, MSB(DUP(op_AND_25)), DUP(op_AND_25)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_25)), DUP(op_AND_25))), CAST(32, MSB(DUP(op_AND_25)), DUP(op_AND_25))))), CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(DUP(op_AND_25)), DUP(op_AND_25))), CAST(32, MSB(DUP(op_AND_25)), DUP(op_AND_25)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_25)), DUP(op_AND_25))), CAST(32, MSB(DUP(op_AND_25)), DUP(op_AND_25)))))), EXTRACT64(CAST(64, IL_FALSE, CAST(16, IL_FALSE, op_AND_40)), SN(32, 0), SN(32, 16)));
	RzILOpPure *op_LSHIFT_51 = SHIFTL0(CAST(64, IL_FALSE, op_MUL_48), SN(32, 1));
	RzILOpPure *op_RSHIFT_53 = SHIFTRA(op_LSHIFT_51, SN(32, 16));
	RzILOpPure *op_ADD_54 = ADD(CAST(64, MSB(CAST(32, MSB(op_AND_16), DUP(op_AND_16))), CAST(32, MSB(DUP(op_AND_16)), DUP(op_AND_16))), op_RSHIFT_53);
	RzILOpPure *op_RSHIFT_63 = SHIFTRA(READ_REG(pkt, Rxx_op, false), SN(32, 0x20));
	RzILOpPure *op_AND_65 = LOGAND(op_RSHIFT_63, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_71 = SHIFTRA(DUP(Rss), SN(32, 0x20));
	RzILOpPure *op_AND_73 = LOGAND(op_RSHIFT_71, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_84 = SHIFTRA(DUP(Rtt), SN(32, 0x20));
	RzILOpPure *op_AND_87 = LOGAND(op_RSHIFT_84, CAST(64, MSB(SN(32, 0xffff)), SN(32, 0xffff)));
	RzILOpPure *op_MUL_95 = MUL(CAST(64, IL_FALSE, CAST(64, MSB(CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(op_AND_73), DUP(op_AND_73))), CAST(32, MSB(DUP(op_AND_73)), DUP(op_AND_73)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_73)), DUP(op_AND_73))), CAST(32, MSB(DUP(op_AND_73)), DUP(op_AND_73))))), CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(DUP(op_AND_73)), DUP(op_AND_73))), CAST(32, MSB(DUP(op_AND_73)), DUP(op_AND_73)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_73)), DUP(op_AND_73))), CAST(32, MSB(DUP(op_AND_73)), DUP(op_AND_73)))))), EXTRACT64(CAST(64, IL_FALSE, CAST(16, IL_FALSE, op_AND_87)), SN(32, 0), SN(32, 16)));
	RzILOpPure *op_LSHIFT_98 = SHIFTL0(CAST(64, IL_FALSE, op_MUL_95), SN(32, 1));
	RzILOpPure *op_RSHIFT_100 = SHIFTRA(op_LSHIFT_98, SN(32, 16));
	RzILOpPure *op_ADD_101 = ADD(CAST(64, MSB(CAST(32, MSB(op_AND_65), DUP(op_AND_65))), CAST(32, MSB(DUP(op_AND_65)), DUP(op_AND_65))), op_RSHIFT_100);
	RzILOpPure *op_EQ_102 = EQ(SEXTRACT64(CAST(64, IL_FALSE, op_ADD_54), SN(32, 0), SN(32, 0x20)), op_ADD_101);
	RzILOpPure *op_RSHIFT_151 = SHIFTRA(READ_REG(pkt, Rxx_op, false), SN(32, 0x20));
	RzILOpPure *op_AND_153 = LOGAND(op_RSHIFT_151, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_159 = SHIFTRA(DUP(Rss), SN(32, 0x20));
	RzILOpPure *op_AND_161 = LOGAND(op_RSHIFT_159, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_172 = SHIFTRA(DUP(Rtt), SN(32, 0x20));
	RzILOpPure *op_AND_175 = LOGAND(op_RSHIFT_172, CAST(64, MSB(SN(32, 0xffff)), SN(32, 0xffff)));
	RzILOpPure *op_MUL_183 = MUL(CAST(64, IL_FALSE, CAST(64, MSB(CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(op_AND_161), DUP(op_AND_161))), CAST(32, MSB(DUP(op_AND_161)), DUP(op_AND_161)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_161)), DUP(op_AND_161))), CAST(32, MSB(DUP(op_AND_161)), DUP(op_AND_161))))), CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(DUP(op_AND_161)), DUP(op_AND_161))), CAST(32, MSB(DUP(op_AND_161)), DUP(op_AND_161)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_161)), DUP(op_AND_161))), CAST(32, MSB(DUP(op_AND_161)), DUP(op_AND_161)))))), EXTRACT64(CAST(64, IL_FALSE, CAST(16, IL_FALSE, op_AND_175)), SN(32, 0), SN(32, 16)));
	RzILOpPure *op_LSHIFT_186 = SHIFTL0(CAST(64, IL_FALSE, op_MUL_183), SN(32, 1));
	RzILOpPure *op_RSHIFT_188 = SHIFTRA(op_LSHIFT_186, SN(32, 16));
	RzILOpPure *op_ADD_189 = ADD(CAST(64, MSB(CAST(32, MSB(op_AND_153), DUP(op_AND_153))), CAST(32, MSB(DUP(op_AND_153)), DUP(op_AND_153))), op_RSHIFT_188);
	RzILOpPure *op_LT_192 = SLT(op_ADD_189, CAST(64, MSB(SN(32, 0)), SN(32, 0)));
	RzILOpPure *op_LSHIFT_197 = SHIFTL0(SN(64, 1), SN(32, 31));
	RzILOpPure *op_NEG_198 = NEG(op_LSHIFT_197);
	RzILOpPure *op_LSHIFT_203 = SHIFTL0(SN(64, 1), SN(32, 31));
	RzILOpPure *op_SUB_206 = SUB(op_LSHIFT_203, CAST(64, MSB(SN(32, 1)), SN(32, 1)));
	RzILOpPure *cond_207 = ITE(op_LT_192, op_NEG_198, op_SUB_206);
	RzILOpEffect *gcc_expr_208 = BRANCH(op_EQ_102, EMPTY(), set_usr_field_call_147);

	// h_tmp298 = HYB(gcc_expr_if ((sextract64(((ut64) ((st64) ((st32) ((Rxx >> 0x20) & 0xffffffff))) + ((((st64) ((ut64) ((st64) ((st32) ((st64) ((st32) ((Rss >> 0x20) & 0xffffffff)))))) * extract64(((ut64) ((ut16) ((Rtt >> 0x20) & ((st64) 0xffff)))), 0x0, 0x10)) << 0x1) >> 0x10)), 0x0, 0x20) == ((st64) ((st32) ((Rxx >> 0x20) & 0xffffffff))) + ((((st64) ((ut64) ((st64) ((st32) ((st64) ((st32) ((Rss >> 0x20) & 0xffffffff)))))) * extract64(((ut64) ((ut16) ((Rtt >> 0x20) & ((st64) 0xffff)))), 0x0, 0x10)) << 0x1) >> 0x10))) {{}} else {set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, ((ut32) 0x1))}, ((((st64) ((st32) ((Rxx >> 0x20) & 0xffffffff))) + ((((st64) ((ut64) ((st64) ((st32) ((st64) ((st32) ((Rss >> 0x20) & 0xffffffff)))))) * extract64(((ut64) ((ut16) ((Rtt >> 0x20) & ((st64) 0xffff)))), 0x0, 0x10)) << 0x1) >> 0x10) < ((st64) 0x0)) ? (-(0x1 << 0x1f)) : (0x1 << 0x1f) - ((st64) 0x1)));
	RzILOpEffect *op_ASSIGN_hybrid_tmp_210 = SETL("h_tmp298", cond_207);

	// seq(HYB(gcc_expr_if ((sextract64(((ut64) ((st64) ((st32) ((Rxx > ...;
	RzILOpEffect *seq_211 = SEQN(2, gcc_expr_208, op_ASSIGN_hybrid_tmp_210);

	// Rxx = ((Rxx & (~(0xffffffff << 0x20))) | ((((sextract64(((ut64) ((st64) ((st32) ((Rxx >> 0x20) & 0xffffffff))) + ((((st64) ((ut64) ((st64) ((st32) ((st64) ((st32) ((Rss >> 0x20) & 0xffffffff)))))) * extract64(((ut64) ((ut16) ((Rtt >> 0x20) & ((st64) 0xffff)))), 0x0, 0x10)) << 0x1) >> 0x10)), 0x0, 0x20) == ((st64) ((st32) ((Rxx >> 0x20) & 0xffffffff))) + ((((st64) ((ut64) ((st64) ((st32) ((st64) ((st32) ((Rss >> 0x20) & 0xffffffff)))))) * extract64(((ut64) ((ut16) ((Rtt >> 0x20) & ((st64) 0xffff)))), 0x0, 0x10)) << 0x1) >> 0x10)) ? ((st64) ((st32) ((Rxx >> 0x20) & 0xffffffff))) + ((((st64) ((ut64) ((st64) ((st32) ((st64) ((st32) ((Rss >> 0x20) & 0xffffffff)))))) * extract64(((ut64) ((ut16) ((Rtt >> 0x20) & ((st64) 0xffff)))), 0x0, 0x10)) << 0x1) >> 0x10) : h_tmp298) & 0xffffffff) << 0x20));
	RzILOpPure *op_LSHIFT_5 = SHIFTL0(SN(64, 0xffffffff), SN(32, 0x20));
	RzILOpPure *op_NOT_6 = LOGNOT(op_LSHIFT_5);
	RzILOpPure *op_AND_7 = LOGAND(READ_REG(pkt, Rxx_op, false), op_NOT_6);
	RzILOpPure *op_RSHIFT_106 = SHIFTRA(READ_REG(pkt, Rxx_op, false), SN(32, 0x20));
	RzILOpPure *op_AND_108 = LOGAND(op_RSHIFT_106, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_114 = SHIFTRA(DUP(Rss), SN(32, 0x20));
	RzILOpPure *op_AND_116 = LOGAND(op_RSHIFT_114, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_127 = SHIFTRA(DUP(Rtt), SN(32, 0x20));
	RzILOpPure *op_AND_130 = LOGAND(op_RSHIFT_127, CAST(64, MSB(SN(32, 0xffff)), SN(32, 0xffff)));
	RzILOpPure *op_MUL_138 = MUL(CAST(64, IL_FALSE, CAST(64, MSB(CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(op_AND_116), DUP(op_AND_116))), CAST(32, MSB(DUP(op_AND_116)), DUP(op_AND_116)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_116)), DUP(op_AND_116))), CAST(32, MSB(DUP(op_AND_116)), DUP(op_AND_116))))), CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(DUP(op_AND_116)), DUP(op_AND_116))), CAST(32, MSB(DUP(op_AND_116)), DUP(op_AND_116)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_116)), DUP(op_AND_116))), CAST(32, MSB(DUP(op_AND_116)), DUP(op_AND_116)))))), EXTRACT64(CAST(64, IL_FALSE, CAST(16, IL_FALSE, op_AND_130)), SN(32, 0), SN(32, 16)));
	RzILOpPure *op_LSHIFT_141 = SHIFTL0(CAST(64, IL_FALSE, op_MUL_138), SN(32, 1));
	RzILOpPure *op_RSHIFT_143 = SHIFTRA(op_LSHIFT_141, SN(32, 16));
	RzILOpPure *op_ADD_144 = ADD(CAST(64, MSB(CAST(32, MSB(op_AND_108), DUP(op_AND_108))), CAST(32, MSB(DUP(op_AND_108)), DUP(op_AND_108))), op_RSHIFT_143);
	RzILOpPure *cond_212 = ITE(DUP(op_EQ_102), op_ADD_144, VARL("h_tmp298"));
	RzILOpPure *op_AND_214 = LOGAND(cond_212, SN(64, 0xffffffff));
	RzILOpPure *op_LSHIFT_218 = SHIFTL0(op_AND_214, SN(32, 0x20));
	RzILOpPure *op_OR_219 = LOGOR(op_AND_7, op_LSHIFT_218);
	RzILOpEffect *op_ASSIGN_220 = WRITE_REG(bundle, Rxx_op, op_OR_219);

	// seq(seq(HYB(gcc_expr_if ((sextract64(((ut64) ((st64) ((st32) ((R ...;
	RzILOpEffect *seq_221 = SEQN(2, seq_211, op_ASSIGN_220);

	// set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, ((ut32) 0x1));
	RzILOpEffect *set_usr_field_call_367 = hex_set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, CAST(32, IL_FALSE, SN(32, 1)));

	// HYB(gcc_expr_if ((sextract64(((ut64) ((st64) ((st32) ((Rxx >> 0x0) & 0xffffffff))) + ((((st64) ((ut64) ((st64) ((st32) ((st64) ((st32) ((Rss >> 0x0) & 0xffffffff)))))) * extract64(((ut64) ((ut16) ((Rtt >> 0x0) & ((st64) 0xffff)))), 0x0, 0x10)) << 0x1) >> 0x10)), 0x0, 0x20) == ((st64) ((st32) ((Rxx >> 0x0) & 0xffffffff))) + ((((st64) ((ut64) ((st64) ((st32) ((st64) ((st32) ((Rss >> 0x0) & 0xffffffff)))))) * extract64(((ut64) ((ut16) ((Rtt >> 0x0) & ((st64) 0xffff)))), 0x0, 0x10)) << 0x1) >> 0x10))) {{}} else {set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, ((ut32) 0x1))}, ((((st64) ((st32) ((Rxx >> 0x0) & 0xffffffff))) + ((((st64) ((ut64) ((st64) ((st32) ((st64) ((st32) ((Rss >> 0x0) & 0xffffffff)))))) * extract64(((ut64) ((ut16) ((Rtt >> 0x0) & ((st64) 0xffff)))), 0x0, 0x10)) << 0x1) >> 0x10) < ((st64) 0x0)) ? (-(0x1 << 0x1f)) : (0x1 << 0x1f) - ((st64) 0x1)));
	RzILOpPure *op_RSHIFT_236 = SHIFTRA(READ_REG(pkt, Rxx_op, false), SN(32, 0));
	RzILOpPure *op_AND_238 = LOGAND(op_RSHIFT_236, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_244 = SHIFTRA(DUP(Rss), SN(32, 0));
	RzILOpPure *op_AND_246 = LOGAND(op_RSHIFT_244, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_257 = SHIFTRA(DUP(Rtt), SN(32, 0));
	RzILOpPure *op_AND_260 = LOGAND(op_RSHIFT_257, CAST(64, MSB(SN(32, 0xffff)), SN(32, 0xffff)));
	RzILOpPure *op_MUL_268 = MUL(CAST(64, IL_FALSE, CAST(64, MSB(CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(op_AND_246), DUP(op_AND_246))), CAST(32, MSB(DUP(op_AND_246)), DUP(op_AND_246)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_246)), DUP(op_AND_246))), CAST(32, MSB(DUP(op_AND_246)), DUP(op_AND_246))))), CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(DUP(op_AND_246)), DUP(op_AND_246))), CAST(32, MSB(DUP(op_AND_246)), DUP(op_AND_246)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_246)), DUP(op_AND_246))), CAST(32, MSB(DUP(op_AND_246)), DUP(op_AND_246)))))), EXTRACT64(CAST(64, IL_FALSE, CAST(16, IL_FALSE, op_AND_260)), SN(32, 0), SN(32, 16)));
	RzILOpPure *op_LSHIFT_271 = SHIFTL0(CAST(64, IL_FALSE, op_MUL_268), SN(32, 1));
	RzILOpPure *op_RSHIFT_273 = SHIFTRA(op_LSHIFT_271, SN(32, 16));
	RzILOpPure *op_ADD_274 = ADD(CAST(64, MSB(CAST(32, MSB(op_AND_238), DUP(op_AND_238))), CAST(32, MSB(DUP(op_AND_238)), DUP(op_AND_238))), op_RSHIFT_273);
	RzILOpPure *op_RSHIFT_283 = SHIFTRA(READ_REG(pkt, Rxx_op, false), SN(32, 0));
	RzILOpPure *op_AND_285 = LOGAND(op_RSHIFT_283, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_291 = SHIFTRA(DUP(Rss), SN(32, 0));
	RzILOpPure *op_AND_293 = LOGAND(op_RSHIFT_291, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_304 = SHIFTRA(DUP(Rtt), SN(32, 0));
	RzILOpPure *op_AND_307 = LOGAND(op_RSHIFT_304, CAST(64, MSB(SN(32, 0xffff)), SN(32, 0xffff)));
	RzILOpPure *op_MUL_315 = MUL(CAST(64, IL_FALSE, CAST(64, MSB(CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(op_AND_293), DUP(op_AND_293))), CAST(32, MSB(DUP(op_AND_293)), DUP(op_AND_293)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_293)), DUP(op_AND_293))), CAST(32, MSB(DUP(op_AND_293)), DUP(op_AND_293))))), CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(DUP(op_AND_293)), DUP(op_AND_293))), CAST(32, MSB(DUP(op_AND_293)), DUP(op_AND_293)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_293)), DUP(op_AND_293))), CAST(32, MSB(DUP(op_AND_293)), DUP(op_AND_293)))))), EXTRACT64(CAST(64, IL_FALSE, CAST(16, IL_FALSE, op_AND_307)), SN(32, 0), SN(32, 16)));
	RzILOpPure *op_LSHIFT_318 = SHIFTL0(CAST(64, IL_FALSE, op_MUL_315), SN(32, 1));
	RzILOpPure *op_RSHIFT_320 = SHIFTRA(op_LSHIFT_318, SN(32, 16));
	RzILOpPure *op_ADD_321 = ADD(CAST(64, MSB(CAST(32, MSB(op_AND_285), DUP(op_AND_285))), CAST(32, MSB(DUP(op_AND_285)), DUP(op_AND_285))), op_RSHIFT_320);
	RzILOpPure *op_EQ_322 = EQ(SEXTRACT64(CAST(64, IL_FALSE, op_ADD_274), SN(32, 0), SN(32, 0x20)), op_ADD_321);
	RzILOpPure *op_RSHIFT_371 = SHIFTRA(READ_REG(pkt, Rxx_op, false), SN(32, 0));
	RzILOpPure *op_AND_373 = LOGAND(op_RSHIFT_371, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_379 = SHIFTRA(DUP(Rss), SN(32, 0));
	RzILOpPure *op_AND_381 = LOGAND(op_RSHIFT_379, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_392 = SHIFTRA(DUP(Rtt), SN(32, 0));
	RzILOpPure *op_AND_395 = LOGAND(op_RSHIFT_392, CAST(64, MSB(SN(32, 0xffff)), SN(32, 0xffff)));
	RzILOpPure *op_MUL_403 = MUL(CAST(64, IL_FALSE, CAST(64, MSB(CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(op_AND_381), DUP(op_AND_381))), CAST(32, MSB(DUP(op_AND_381)), DUP(op_AND_381)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_381)), DUP(op_AND_381))), CAST(32, MSB(DUP(op_AND_381)), DUP(op_AND_381))))), CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(DUP(op_AND_381)), DUP(op_AND_381))), CAST(32, MSB(DUP(op_AND_381)), DUP(op_AND_381)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_381)), DUP(op_AND_381))), CAST(32, MSB(DUP(op_AND_381)), DUP(op_AND_381)))))), EXTRACT64(CAST(64, IL_FALSE, CAST(16, IL_FALSE, op_AND_395)), SN(32, 0), SN(32, 16)));
	RzILOpPure *op_LSHIFT_406 = SHIFTL0(CAST(64, IL_FALSE, op_MUL_403), SN(32, 1));
	RzILOpPure *op_RSHIFT_408 = SHIFTRA(op_LSHIFT_406, SN(32, 16));
	RzILOpPure *op_ADD_409 = ADD(CAST(64, MSB(CAST(32, MSB(op_AND_373), DUP(op_AND_373))), CAST(32, MSB(DUP(op_AND_373)), DUP(op_AND_373))), op_RSHIFT_408);
	RzILOpPure *op_LT_412 = SLT(op_ADD_409, CAST(64, MSB(SN(32, 0)), SN(32, 0)));
	RzILOpPure *op_LSHIFT_417 = SHIFTL0(SN(64, 1), SN(32, 31));
	RzILOpPure *op_NEG_418 = NEG(op_LSHIFT_417);
	RzILOpPure *op_LSHIFT_423 = SHIFTL0(SN(64, 1), SN(32, 31));
	RzILOpPure *op_SUB_426 = SUB(op_LSHIFT_423, CAST(64, MSB(SN(32, 1)), SN(32, 1)));
	RzILOpPure *cond_427 = ITE(op_LT_412, op_NEG_418, op_SUB_426);
	RzILOpEffect *gcc_expr_428 = BRANCH(op_EQ_322, EMPTY(), set_usr_field_call_367);

	// h_tmp299 = HYB(gcc_expr_if ((sextract64(((ut64) ((st64) ((st32) ((Rxx >> 0x0) & 0xffffffff))) + ((((st64) ((ut64) ((st64) ((st32) ((st64) ((st32) ((Rss >> 0x0) & 0xffffffff)))))) * extract64(((ut64) ((ut16) ((Rtt >> 0x0) & ((st64) 0xffff)))), 0x0, 0x10)) << 0x1) >> 0x10)), 0x0, 0x20) == ((st64) ((st32) ((Rxx >> 0x0) & 0xffffffff))) + ((((st64) ((ut64) ((st64) ((st32) ((st64) ((st32) ((Rss >> 0x0) & 0xffffffff)))))) * extract64(((ut64) ((ut16) ((Rtt >> 0x0) & ((st64) 0xffff)))), 0x0, 0x10)) << 0x1) >> 0x10))) {{}} else {set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, ((ut32) 0x1))}, ((((st64) ((st32) ((Rxx >> 0x0) & 0xffffffff))) + ((((st64) ((ut64) ((st64) ((st32) ((st64) ((st32) ((Rss >> 0x0) & 0xffffffff)))))) * extract64(((ut64) ((ut16) ((Rtt >> 0x0) & ((st64) 0xffff)))), 0x0, 0x10)) << 0x1) >> 0x10) < ((st64) 0x0)) ? (-(0x1 << 0x1f)) : (0x1 << 0x1f) - ((st64) 0x1)));
	RzILOpEffect *op_ASSIGN_hybrid_tmp_430 = SETL("h_tmp299", cond_427);

	// seq(HYB(gcc_expr_if ((sextract64(((ut64) ((st64) ((st32) ((Rxx > ...;
	RzILOpEffect *seq_431 = SEQN(2, gcc_expr_428, op_ASSIGN_hybrid_tmp_430);

	// Rxx = ((Rxx & (~(0xffffffff << 0x0))) | ((((sextract64(((ut64) ((st64) ((st32) ((Rxx >> 0x0) & 0xffffffff))) + ((((st64) ((ut64) ((st64) ((st32) ((st64) ((st32) ((Rss >> 0x0) & 0xffffffff)))))) * extract64(((ut64) ((ut16) ((Rtt >> 0x0) & ((st64) 0xffff)))), 0x0, 0x10)) << 0x1) >> 0x10)), 0x0, 0x20) == ((st64) ((st32) ((Rxx >> 0x0) & 0xffffffff))) + ((((st64) ((ut64) ((st64) ((st32) ((st64) ((st32) ((Rss >> 0x0) & 0xffffffff)))))) * extract64(((ut64) ((ut16) ((Rtt >> 0x0) & ((st64) 0xffff)))), 0x0, 0x10)) << 0x1) >> 0x10)) ? ((st64) ((st32) ((Rxx >> 0x0) & 0xffffffff))) + ((((st64) ((ut64) ((st64) ((st32) ((st64) ((st32) ((Rss >> 0x0) & 0xffffffff)))))) * extract64(((ut64) ((ut16) ((Rtt >> 0x0) & ((st64) 0xffff)))), 0x0, 0x10)) << 0x1) >> 0x10) : h_tmp299) & 0xffffffff) << 0x0));
	RzILOpPure *op_LSHIFT_227 = SHIFTL0(SN(64, 0xffffffff), SN(32, 0));
	RzILOpPure *op_NOT_228 = LOGNOT(op_LSHIFT_227);
	RzILOpPure *op_AND_229 = LOGAND(READ_REG(pkt, Rxx_op, false), op_NOT_228);
	RzILOpPure *op_RSHIFT_326 = SHIFTRA(READ_REG(pkt, Rxx_op, false), SN(32, 0));
	RzILOpPure *op_AND_328 = LOGAND(op_RSHIFT_326, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_334 = SHIFTRA(DUP(Rss), SN(32, 0));
	RzILOpPure *op_AND_336 = LOGAND(op_RSHIFT_334, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_347 = SHIFTRA(DUP(Rtt), SN(32, 0));
	RzILOpPure *op_AND_350 = LOGAND(op_RSHIFT_347, CAST(64, MSB(SN(32, 0xffff)), SN(32, 0xffff)));
	RzILOpPure *op_MUL_358 = MUL(CAST(64, IL_FALSE, CAST(64, MSB(CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(op_AND_336), DUP(op_AND_336))), CAST(32, MSB(DUP(op_AND_336)), DUP(op_AND_336)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_336)), DUP(op_AND_336))), CAST(32, MSB(DUP(op_AND_336)), DUP(op_AND_336))))), CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(DUP(op_AND_336)), DUP(op_AND_336))), CAST(32, MSB(DUP(op_AND_336)), DUP(op_AND_336)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_336)), DUP(op_AND_336))), CAST(32, MSB(DUP(op_AND_336)), DUP(op_AND_336)))))), EXTRACT64(CAST(64, IL_FALSE, CAST(16, IL_FALSE, op_AND_350)), SN(32, 0), SN(32, 16)));
	RzILOpPure *op_LSHIFT_361 = SHIFTL0(CAST(64, IL_FALSE, op_MUL_358), SN(32, 1));
	RzILOpPure *op_RSHIFT_363 = SHIFTRA(op_LSHIFT_361, SN(32, 16));
	RzILOpPure *op_ADD_364 = ADD(CAST(64, MSB(CAST(32, MSB(op_AND_328), DUP(op_AND_328))), CAST(32, MSB(DUP(op_AND_328)), DUP(op_AND_328))), op_RSHIFT_363);
	RzILOpPure *cond_432 = ITE(DUP(op_EQ_322), op_ADD_364, VARL("h_tmp299"));
	RzILOpPure *op_AND_434 = LOGAND(cond_432, SN(64, 0xffffffff));
	RzILOpPure *op_LSHIFT_438 = SHIFTL0(op_AND_434, SN(32, 0));
	RzILOpPure *op_OR_439 = LOGOR(op_AND_229, op_LSHIFT_438);
	RzILOpEffect *op_ASSIGN_440 = WRITE_REG(bundle, Rxx_op, op_OR_439);

	// seq(seq(HYB(gcc_expr_if ((sextract64(((ut64) ((st64) ((st32) ((R ...;
	RzILOpEffect *seq_441 = SEQN(2, seq_431, op_ASSIGN_440);

	RzILOpEffect *instruction_sequence = SEQN(2, seq_221, seq_441);
	return instruction_sequence;
}

// Rdd = vmpywoh(Rss,Rtt):rnd:sat
RzILOpEffect *hex_il_op_m2_mmpyh_rs0(HexInsnPktBundle *bundle) {
	const HexInsn *hi = bundle->insn;
	HexPkt *pkt = bundle->pkt;
	// READ
	const HexOp *Rdd_op = ISA2REG(hi, 'd', false);
	const HexOp *Rss_op = ISA2REG(hi, 's', false);
	RzILOpPure *Rss = READ_REG(pkt, Rss_op, false);
	const HexOp *Rtt_op = ISA2REG(hi, 't', false);
	RzILOpPure *Rtt = READ_REG(pkt, Rtt_op, false);

	// set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, ((ut32) 0x1));
	RzILOpEffect *set_usr_field_call_123 = hex_set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, CAST(32, IL_FALSE, SN(32, 1)));

	// HYB(gcc_expr_if ((sextract64(((ut64) ((((st64) ((st32) ((st64) ((st32) ((Rss >> 0x20) & 0xffffffff))))) * sextract64(((ut64) ((st16) ((Rtt >> 0x30) & ((st64) 0xffff)))), 0x0, 0x10) << 0x0) + ((st64) 0x8000) >> 0x10)), 0x0, 0x20) == ((((st64) ((st32) ((st64) ((st32) ((Rss >> 0x20) & 0xffffffff))))) * sextract64(((ut64) ((st16) ((Rtt >> 0x30) & ((st64) 0xffff)))), 0x0, 0x10) << 0x0) + ((st64) 0x8000) >> 0x10))) {{}} else {set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, ((ut32) 0x1))}, ((((((st64) ((st32) ((st64) ((st32) ((Rss >> 0x20) & 0xffffffff))))) * sextract64(((ut64) ((st16) ((Rtt >> 0x30) & ((st64) 0xffff)))), 0x0, 0x10) << 0x0) + ((st64) 0x8000) >> 0x10) < ((st64) 0x0)) ? (-(0x1 << 0x1f)) : (0x1 << 0x1f) - ((st64) 0x1)));
	RzILOpPure *op_RSHIFT_15 = SHIFTRA(Rss, SN(32, 0x20));
	RzILOpPure *op_AND_17 = LOGAND(op_RSHIFT_15, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_29 = SHIFTRA(Rtt, SN(32, 0x30));
	RzILOpPure *op_AND_32 = LOGAND(op_RSHIFT_29, CAST(64, MSB(SN(32, 0xffff)), SN(32, 0xffff)));
	RzILOpPure *op_MUL_39 = MUL(CAST(64, MSB(CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(op_AND_17), DUP(op_AND_17))), CAST(32, MSB(DUP(op_AND_17)), DUP(op_AND_17)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_17)), DUP(op_AND_17))), CAST(32, MSB(DUP(op_AND_17)), DUP(op_AND_17))))), CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(DUP(op_AND_17)), DUP(op_AND_17))), CAST(32, MSB(DUP(op_AND_17)), DUP(op_AND_17)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_17)), DUP(op_AND_17))), CAST(32, MSB(DUP(op_AND_17)), DUP(op_AND_17))))), SEXTRACT64(CAST(64, IL_FALSE, CAST(16, MSB(op_AND_32), DUP(op_AND_32))), SN(32, 0), SN(32, 16)));
	RzILOpPure *op_LSHIFT_41 = SHIFTL0(op_MUL_39, SN(32, 0));
	RzILOpPure *op_ADD_44 = ADD(op_LSHIFT_41, CAST(64, MSB(SN(32, 0x8000)), SN(32, 0x8000)));
	RzILOpPure *op_RSHIFT_46 = SHIFTRA(op_ADD_44, SN(32, 16));
	RzILOpPure *op_RSHIFT_55 = SHIFTRA(DUP(Rss), SN(32, 0x20));
	RzILOpPure *op_AND_57 = LOGAND(op_RSHIFT_55, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_68 = SHIFTRA(DUP(Rtt), SN(32, 0x30));
	RzILOpPure *op_AND_71 = LOGAND(op_RSHIFT_68, CAST(64, MSB(SN(32, 0xffff)), SN(32, 0xffff)));
	RzILOpPure *op_MUL_78 = MUL(CAST(64, MSB(CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(op_AND_57), DUP(op_AND_57))), CAST(32, MSB(DUP(op_AND_57)), DUP(op_AND_57)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_57)), DUP(op_AND_57))), CAST(32, MSB(DUP(op_AND_57)), DUP(op_AND_57))))), CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(DUP(op_AND_57)), DUP(op_AND_57))), CAST(32, MSB(DUP(op_AND_57)), DUP(op_AND_57)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_57)), DUP(op_AND_57))), CAST(32, MSB(DUP(op_AND_57)), DUP(op_AND_57))))), SEXTRACT64(CAST(64, IL_FALSE, CAST(16, MSB(op_AND_71), DUP(op_AND_71))), SN(32, 0), SN(32, 16)));
	RzILOpPure *op_LSHIFT_80 = SHIFTL0(op_MUL_78, SN(32, 0));
	RzILOpPure *op_ADD_83 = ADD(op_LSHIFT_80, CAST(64, MSB(SN(32, 0x8000)), SN(32, 0x8000)));
	RzILOpPure *op_RSHIFT_85 = SHIFTRA(op_ADD_83, SN(32, 16));
	RzILOpPure *op_EQ_86 = EQ(SEXTRACT64(CAST(64, IL_FALSE, op_RSHIFT_46), SN(32, 0), SN(32, 0x20)), op_RSHIFT_85);
	RzILOpPure *op_RSHIFT_127 = SHIFTRA(DUP(Rss), SN(32, 0x20));
	RzILOpPure *op_AND_129 = LOGAND(op_RSHIFT_127, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_140 = SHIFTRA(DUP(Rtt), SN(32, 0x30));
	RzILOpPure *op_AND_143 = LOGAND(op_RSHIFT_140, CAST(64, MSB(SN(32, 0xffff)), SN(32, 0xffff)));
	RzILOpPure *op_MUL_150 = MUL(CAST(64, MSB(CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(op_AND_129), DUP(op_AND_129))), CAST(32, MSB(DUP(op_AND_129)), DUP(op_AND_129)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_129)), DUP(op_AND_129))), CAST(32, MSB(DUP(op_AND_129)), DUP(op_AND_129))))), CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(DUP(op_AND_129)), DUP(op_AND_129))), CAST(32, MSB(DUP(op_AND_129)), DUP(op_AND_129)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_129)), DUP(op_AND_129))), CAST(32, MSB(DUP(op_AND_129)), DUP(op_AND_129))))), SEXTRACT64(CAST(64, IL_FALSE, CAST(16, MSB(op_AND_143), DUP(op_AND_143))), SN(32, 0), SN(32, 16)));
	RzILOpPure *op_LSHIFT_152 = SHIFTL0(op_MUL_150, SN(32, 0));
	RzILOpPure *op_ADD_155 = ADD(op_LSHIFT_152, CAST(64, MSB(SN(32, 0x8000)), SN(32, 0x8000)));
	RzILOpPure *op_RSHIFT_157 = SHIFTRA(op_ADD_155, SN(32, 16));
	RzILOpPure *op_LT_160 = SLT(op_RSHIFT_157, CAST(64, MSB(SN(32, 0)), SN(32, 0)));
	RzILOpPure *op_LSHIFT_165 = SHIFTL0(SN(64, 1), SN(32, 31));
	RzILOpPure *op_NEG_166 = NEG(op_LSHIFT_165);
	RzILOpPure *op_LSHIFT_171 = SHIFTL0(SN(64, 1), SN(32, 31));
	RzILOpPure *op_SUB_174 = SUB(op_LSHIFT_171, CAST(64, MSB(SN(32, 1)), SN(32, 1)));
	RzILOpPure *cond_175 = ITE(op_LT_160, op_NEG_166, op_SUB_174);
	RzILOpEffect *gcc_expr_176 = BRANCH(op_EQ_86, EMPTY(), set_usr_field_call_123);

	// h_tmp300 = HYB(gcc_expr_if ((sextract64(((ut64) ((((st64) ((st32) ((st64) ((st32) ((Rss >> 0x20) & 0xffffffff))))) * sextract64(((ut64) ((st16) ((Rtt >> 0x30) & ((st64) 0xffff)))), 0x0, 0x10) << 0x0) + ((st64) 0x8000) >> 0x10)), 0x0, 0x20) == ((((st64) ((st32) ((st64) ((st32) ((Rss >> 0x20) & 0xffffffff))))) * sextract64(((ut64) ((st16) ((Rtt >> 0x30) & ((st64) 0xffff)))), 0x0, 0x10) << 0x0) + ((st64) 0x8000) >> 0x10))) {{}} else {set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, ((ut32) 0x1))}, ((((((st64) ((st32) ((st64) ((st32) ((Rss >> 0x20) & 0xffffffff))))) * sextract64(((ut64) ((st16) ((Rtt >> 0x30) & ((st64) 0xffff)))), 0x0, 0x10) << 0x0) + ((st64) 0x8000) >> 0x10) < ((st64) 0x0)) ? (-(0x1 << 0x1f)) : (0x1 << 0x1f) - ((st64) 0x1)));
	RzILOpEffect *op_ASSIGN_hybrid_tmp_178 = SETL("h_tmp300", cond_175);

	// seq(HYB(gcc_expr_if ((sextract64(((ut64) ((((st64) ((st32) ((st6 ...;
	RzILOpEffect *seq_179 = SEQN(2, gcc_expr_176, op_ASSIGN_hybrid_tmp_178);

	// Rdd = ((Rdd & (~(0xffffffff << 0x20))) | ((((sextract64(((ut64) ((((st64) ((st32) ((st64) ((st32) ((Rss >> 0x20) & 0xffffffff))))) * sextract64(((ut64) ((st16) ((Rtt >> 0x30) & ((st64) 0xffff)))), 0x0, 0x10) << 0x0) + ((st64) 0x8000) >> 0x10)), 0x0, 0x20) == ((((st64) ((st32) ((st64) ((st32) ((Rss >> 0x20) & 0xffffffff))))) * sextract64(((ut64) ((st16) ((Rtt >> 0x30) & ((st64) 0xffff)))), 0x0, 0x10) << 0x0) + ((st64) 0x8000) >> 0x10)) ? ((((st64) ((st32) ((st64) ((st32) ((Rss >> 0x20) & 0xffffffff))))) * sextract64(((ut64) ((st16) ((Rtt >> 0x30) & ((st64) 0xffff)))), 0x0, 0x10) << 0x0) + ((st64) 0x8000) >> 0x10) : h_tmp300) & 0xffffffff) << 0x20));
	RzILOpPure *op_LSHIFT_5 = SHIFTL0(SN(64, 0xffffffff), SN(32, 0x20));
	RzILOpPure *op_NOT_6 = LOGNOT(op_LSHIFT_5);
	RzILOpPure *op_AND_7 = LOGAND(READ_REG(pkt, Rdd_op, true), op_NOT_6);
	RzILOpPure *op_RSHIFT_90 = SHIFTRA(DUP(Rss), SN(32, 0x20));
	RzILOpPure *op_AND_92 = LOGAND(op_RSHIFT_90, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_103 = SHIFTRA(DUP(Rtt), SN(32, 0x30));
	RzILOpPure *op_AND_106 = LOGAND(op_RSHIFT_103, CAST(64, MSB(SN(32, 0xffff)), SN(32, 0xffff)));
	RzILOpPure *op_MUL_113 = MUL(CAST(64, MSB(CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(op_AND_92), DUP(op_AND_92))), CAST(32, MSB(DUP(op_AND_92)), DUP(op_AND_92)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_92)), DUP(op_AND_92))), CAST(32, MSB(DUP(op_AND_92)), DUP(op_AND_92))))), CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(DUP(op_AND_92)), DUP(op_AND_92))), CAST(32, MSB(DUP(op_AND_92)), DUP(op_AND_92)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_92)), DUP(op_AND_92))), CAST(32, MSB(DUP(op_AND_92)), DUP(op_AND_92))))), SEXTRACT64(CAST(64, IL_FALSE, CAST(16, MSB(op_AND_106), DUP(op_AND_106))), SN(32, 0), SN(32, 16)));
	RzILOpPure *op_LSHIFT_115 = SHIFTL0(op_MUL_113, SN(32, 0));
	RzILOpPure *op_ADD_118 = ADD(op_LSHIFT_115, CAST(64, MSB(SN(32, 0x8000)), SN(32, 0x8000)));
	RzILOpPure *op_RSHIFT_120 = SHIFTRA(op_ADD_118, SN(32, 16));
	RzILOpPure *cond_180 = ITE(DUP(op_EQ_86), op_RSHIFT_120, VARL("h_tmp300"));
	RzILOpPure *op_AND_182 = LOGAND(cond_180, SN(64, 0xffffffff));
	RzILOpPure *op_LSHIFT_186 = SHIFTL0(op_AND_182, SN(32, 0x20));
	RzILOpPure *op_OR_187 = LOGOR(op_AND_7, op_LSHIFT_186);
	RzILOpEffect *op_ASSIGN_188 = WRITE_REG(bundle, Rdd_op, op_OR_187);

	// seq(seq(HYB(gcc_expr_if ((sextract64(((ut64) ((((st64) ((st32) ( ...;
	RzILOpEffect *seq_189 = SEQN(2, seq_179, op_ASSIGN_188);

	// set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, ((ut32) 0x1));
	RzILOpEffect *set_usr_field_call_311 = hex_set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, CAST(32, IL_FALSE, SN(32, 1)));

	// HYB(gcc_expr_if ((sextract64(((ut64) ((((st64) ((st32) ((st64) ((st32) ((Rss >> 0x0) & 0xffffffff))))) * sextract64(((ut64) ((st16) ((Rtt >> 0x10) & ((st64) 0xffff)))), 0x0, 0x10) << 0x0) + ((st64) 0x8000) >> 0x10)), 0x0, 0x20) == ((((st64) ((st32) ((st64) ((st32) ((Rss >> 0x0) & 0xffffffff))))) * sextract64(((ut64) ((st16) ((Rtt >> 0x10) & ((st64) 0xffff)))), 0x0, 0x10) << 0x0) + ((st64) 0x8000) >> 0x10))) {{}} else {set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, ((ut32) 0x1))}, ((((((st64) ((st32) ((st64) ((st32) ((Rss >> 0x0) & 0xffffffff))))) * sextract64(((ut64) ((st16) ((Rtt >> 0x10) & ((st64) 0xffff)))), 0x0, 0x10) << 0x0) + ((st64) 0x8000) >> 0x10) < ((st64) 0x0)) ? (-(0x1 << 0x1f)) : (0x1 << 0x1f) - ((st64) 0x1)));
	RzILOpPure *op_RSHIFT_204 = SHIFTRA(DUP(Rss), SN(32, 0));
	RzILOpPure *op_AND_206 = LOGAND(op_RSHIFT_204, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_217 = SHIFTRA(DUP(Rtt), SN(32, 16));
	RzILOpPure *op_AND_220 = LOGAND(op_RSHIFT_217, CAST(64, MSB(SN(32, 0xffff)), SN(32, 0xffff)));
	RzILOpPure *op_MUL_227 = MUL(CAST(64, MSB(CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(op_AND_206), DUP(op_AND_206))), CAST(32, MSB(DUP(op_AND_206)), DUP(op_AND_206)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_206)), DUP(op_AND_206))), CAST(32, MSB(DUP(op_AND_206)), DUP(op_AND_206))))), CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(DUP(op_AND_206)), DUP(op_AND_206))), CAST(32, MSB(DUP(op_AND_206)), DUP(op_AND_206)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_206)), DUP(op_AND_206))), CAST(32, MSB(DUP(op_AND_206)), DUP(op_AND_206))))), SEXTRACT64(CAST(64, IL_FALSE, CAST(16, MSB(op_AND_220), DUP(op_AND_220))), SN(32, 0), SN(32, 16)));
	RzILOpPure *op_LSHIFT_229 = SHIFTL0(op_MUL_227, SN(32, 0));
	RzILOpPure *op_ADD_232 = ADD(op_LSHIFT_229, CAST(64, MSB(SN(32, 0x8000)), SN(32, 0x8000)));
	RzILOpPure *op_RSHIFT_234 = SHIFTRA(op_ADD_232, SN(32, 16));
	RzILOpPure *op_RSHIFT_243 = SHIFTRA(DUP(Rss), SN(32, 0));
	RzILOpPure *op_AND_245 = LOGAND(op_RSHIFT_243, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_256 = SHIFTRA(DUP(Rtt), SN(32, 16));
	RzILOpPure *op_AND_259 = LOGAND(op_RSHIFT_256, CAST(64, MSB(SN(32, 0xffff)), SN(32, 0xffff)));
	RzILOpPure *op_MUL_266 = MUL(CAST(64, MSB(CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(op_AND_245), DUP(op_AND_245))), CAST(32, MSB(DUP(op_AND_245)), DUP(op_AND_245)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_245)), DUP(op_AND_245))), CAST(32, MSB(DUP(op_AND_245)), DUP(op_AND_245))))), CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(DUP(op_AND_245)), DUP(op_AND_245))), CAST(32, MSB(DUP(op_AND_245)), DUP(op_AND_245)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_245)), DUP(op_AND_245))), CAST(32, MSB(DUP(op_AND_245)), DUP(op_AND_245))))), SEXTRACT64(CAST(64, IL_FALSE, CAST(16, MSB(op_AND_259), DUP(op_AND_259))), SN(32, 0), SN(32, 16)));
	RzILOpPure *op_LSHIFT_268 = SHIFTL0(op_MUL_266, SN(32, 0));
	RzILOpPure *op_ADD_271 = ADD(op_LSHIFT_268, CAST(64, MSB(SN(32, 0x8000)), SN(32, 0x8000)));
	RzILOpPure *op_RSHIFT_273 = SHIFTRA(op_ADD_271, SN(32, 16));
	RzILOpPure *op_EQ_274 = EQ(SEXTRACT64(CAST(64, IL_FALSE, op_RSHIFT_234), SN(32, 0), SN(32, 0x20)), op_RSHIFT_273);
	RzILOpPure *op_RSHIFT_315 = SHIFTRA(DUP(Rss), SN(32, 0));
	RzILOpPure *op_AND_317 = LOGAND(op_RSHIFT_315, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_328 = SHIFTRA(DUP(Rtt), SN(32, 16));
	RzILOpPure *op_AND_331 = LOGAND(op_RSHIFT_328, CAST(64, MSB(SN(32, 0xffff)), SN(32, 0xffff)));
	RzILOpPure *op_MUL_338 = MUL(CAST(64, MSB(CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(op_AND_317), DUP(op_AND_317))), CAST(32, MSB(DUP(op_AND_317)), DUP(op_AND_317)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_317)), DUP(op_AND_317))), CAST(32, MSB(DUP(op_AND_317)), DUP(op_AND_317))))), CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(DUP(op_AND_317)), DUP(op_AND_317))), CAST(32, MSB(DUP(op_AND_317)), DUP(op_AND_317)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_317)), DUP(op_AND_317))), CAST(32, MSB(DUP(op_AND_317)), DUP(op_AND_317))))), SEXTRACT64(CAST(64, IL_FALSE, CAST(16, MSB(op_AND_331), DUP(op_AND_331))), SN(32, 0), SN(32, 16)));
	RzILOpPure *op_LSHIFT_340 = SHIFTL0(op_MUL_338, SN(32, 0));
	RzILOpPure *op_ADD_343 = ADD(op_LSHIFT_340, CAST(64, MSB(SN(32, 0x8000)), SN(32, 0x8000)));
	RzILOpPure *op_RSHIFT_345 = SHIFTRA(op_ADD_343, SN(32, 16));
	RzILOpPure *op_LT_348 = SLT(op_RSHIFT_345, CAST(64, MSB(SN(32, 0)), SN(32, 0)));
	RzILOpPure *op_LSHIFT_353 = SHIFTL0(SN(64, 1), SN(32, 31));
	RzILOpPure *op_NEG_354 = NEG(op_LSHIFT_353);
	RzILOpPure *op_LSHIFT_359 = SHIFTL0(SN(64, 1), SN(32, 31));
	RzILOpPure *op_SUB_362 = SUB(op_LSHIFT_359, CAST(64, MSB(SN(32, 1)), SN(32, 1)));
	RzILOpPure *cond_363 = ITE(op_LT_348, op_NEG_354, op_SUB_362);
	RzILOpEffect *gcc_expr_364 = BRANCH(op_EQ_274, EMPTY(), set_usr_field_call_311);

	// h_tmp301 = HYB(gcc_expr_if ((sextract64(((ut64) ((((st64) ((st32) ((st64) ((st32) ((Rss >> 0x0) & 0xffffffff))))) * sextract64(((ut64) ((st16) ((Rtt >> 0x10) & ((st64) 0xffff)))), 0x0, 0x10) << 0x0) + ((st64) 0x8000) >> 0x10)), 0x0, 0x20) == ((((st64) ((st32) ((st64) ((st32) ((Rss >> 0x0) & 0xffffffff))))) * sextract64(((ut64) ((st16) ((Rtt >> 0x10) & ((st64) 0xffff)))), 0x0, 0x10) << 0x0) + ((st64) 0x8000) >> 0x10))) {{}} else {set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, ((ut32) 0x1))}, ((((((st64) ((st32) ((st64) ((st32) ((Rss >> 0x0) & 0xffffffff))))) * sextract64(((ut64) ((st16) ((Rtt >> 0x10) & ((st64) 0xffff)))), 0x0, 0x10) << 0x0) + ((st64) 0x8000) >> 0x10) < ((st64) 0x0)) ? (-(0x1 << 0x1f)) : (0x1 << 0x1f) - ((st64) 0x1)));
	RzILOpEffect *op_ASSIGN_hybrid_tmp_366 = SETL("h_tmp301", cond_363);

	// seq(HYB(gcc_expr_if ((sextract64(((ut64) ((((st64) ((st32) ((st6 ...;
	RzILOpEffect *seq_367 = SEQN(2, gcc_expr_364, op_ASSIGN_hybrid_tmp_366);

	// Rdd = ((Rdd & (~(0xffffffff << 0x0))) | ((((sextract64(((ut64) ((((st64) ((st32) ((st64) ((st32) ((Rss >> 0x0) & 0xffffffff))))) * sextract64(((ut64) ((st16) ((Rtt >> 0x10) & ((st64) 0xffff)))), 0x0, 0x10) << 0x0) + ((st64) 0x8000) >> 0x10)), 0x0, 0x20) == ((((st64) ((st32) ((st64) ((st32) ((Rss >> 0x0) & 0xffffffff))))) * sextract64(((ut64) ((st16) ((Rtt >> 0x10) & ((st64) 0xffff)))), 0x0, 0x10) << 0x0) + ((st64) 0x8000) >> 0x10)) ? ((((st64) ((st32) ((st64) ((st32) ((Rss >> 0x0) & 0xffffffff))))) * sextract64(((ut64) ((st16) ((Rtt >> 0x10) & ((st64) 0xffff)))), 0x0, 0x10) << 0x0) + ((st64) 0x8000) >> 0x10) : h_tmp301) & 0xffffffff) << 0x0));
	RzILOpPure *op_LSHIFT_195 = SHIFTL0(SN(64, 0xffffffff), SN(32, 0));
	RzILOpPure *op_NOT_196 = LOGNOT(op_LSHIFT_195);
	RzILOpPure *op_AND_197 = LOGAND(READ_REG(pkt, Rdd_op, true), op_NOT_196);
	RzILOpPure *op_RSHIFT_278 = SHIFTRA(DUP(Rss), SN(32, 0));
	RzILOpPure *op_AND_280 = LOGAND(op_RSHIFT_278, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_291 = SHIFTRA(DUP(Rtt), SN(32, 16));
	RzILOpPure *op_AND_294 = LOGAND(op_RSHIFT_291, CAST(64, MSB(SN(32, 0xffff)), SN(32, 0xffff)));
	RzILOpPure *op_MUL_301 = MUL(CAST(64, MSB(CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(op_AND_280), DUP(op_AND_280))), CAST(32, MSB(DUP(op_AND_280)), DUP(op_AND_280)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_280)), DUP(op_AND_280))), CAST(32, MSB(DUP(op_AND_280)), DUP(op_AND_280))))), CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(DUP(op_AND_280)), DUP(op_AND_280))), CAST(32, MSB(DUP(op_AND_280)), DUP(op_AND_280)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_280)), DUP(op_AND_280))), CAST(32, MSB(DUP(op_AND_280)), DUP(op_AND_280))))), SEXTRACT64(CAST(64, IL_FALSE, CAST(16, MSB(op_AND_294), DUP(op_AND_294))), SN(32, 0), SN(32, 16)));
	RzILOpPure *op_LSHIFT_303 = SHIFTL0(op_MUL_301, SN(32, 0));
	RzILOpPure *op_ADD_306 = ADD(op_LSHIFT_303, CAST(64, MSB(SN(32, 0x8000)), SN(32, 0x8000)));
	RzILOpPure *op_RSHIFT_308 = SHIFTRA(op_ADD_306, SN(32, 16));
	RzILOpPure *cond_368 = ITE(DUP(op_EQ_274), op_RSHIFT_308, VARL("h_tmp301"));
	RzILOpPure *op_AND_370 = LOGAND(cond_368, SN(64, 0xffffffff));
	RzILOpPure *op_LSHIFT_374 = SHIFTL0(op_AND_370, SN(32, 0));
	RzILOpPure *op_OR_375 = LOGOR(op_AND_197, op_LSHIFT_374);
	RzILOpEffect *op_ASSIGN_376 = WRITE_REG(bundle, Rdd_op, op_OR_375);

	// seq(seq(HYB(gcc_expr_if ((sextract64(((ut64) ((((st64) ((st32) ( ...;
	RzILOpEffect *seq_377 = SEQN(2, seq_367, op_ASSIGN_376);

	RzILOpEffect *instruction_sequence = SEQN(2, seq_189, seq_377);
	return instruction_sequence;
}

// Rdd = vmpywoh(Rss,Rtt):<<1:rnd:sat
RzILOpEffect *hex_il_op_m2_mmpyh_rs1(HexInsnPktBundle *bundle) {
	const HexInsn *hi = bundle->insn;
	HexPkt *pkt = bundle->pkt;
	// READ
	const HexOp *Rdd_op = ISA2REG(hi, 'd', false);
	const HexOp *Rss_op = ISA2REG(hi, 's', false);
	RzILOpPure *Rss = READ_REG(pkt, Rss_op, false);
	const HexOp *Rtt_op = ISA2REG(hi, 't', false);
	RzILOpPure *Rtt = READ_REG(pkt, Rtt_op, false);

	// set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, ((ut32) 0x1));
	RzILOpEffect *set_usr_field_call_123 = hex_set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, CAST(32, IL_FALSE, SN(32, 1)));

	// HYB(gcc_expr_if ((sextract64(((ut64) ((((st64) ((st32) ((st64) ((st32) ((Rss >> 0x20) & 0xffffffff))))) * sextract64(((ut64) ((st16) ((Rtt >> 0x30) & ((st64) 0xffff)))), 0x0, 0x10) << 0x1) + ((st64) 0x8000) >> 0x10)), 0x0, 0x20) == ((((st64) ((st32) ((st64) ((st32) ((Rss >> 0x20) & 0xffffffff))))) * sextract64(((ut64) ((st16) ((Rtt >> 0x30) & ((st64) 0xffff)))), 0x0, 0x10) << 0x1) + ((st64) 0x8000) >> 0x10))) {{}} else {set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, ((ut32) 0x1))}, ((((((st64) ((st32) ((st64) ((st32) ((Rss >> 0x20) & 0xffffffff))))) * sextract64(((ut64) ((st16) ((Rtt >> 0x30) & ((st64) 0xffff)))), 0x0, 0x10) << 0x1) + ((st64) 0x8000) >> 0x10) < ((st64) 0x0)) ? (-(0x1 << 0x1f)) : (0x1 << 0x1f) - ((st64) 0x1)));
	RzILOpPure *op_RSHIFT_15 = SHIFTRA(Rss, SN(32, 0x20));
	RzILOpPure *op_AND_17 = LOGAND(op_RSHIFT_15, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_29 = SHIFTRA(Rtt, SN(32, 0x30));
	RzILOpPure *op_AND_32 = LOGAND(op_RSHIFT_29, CAST(64, MSB(SN(32, 0xffff)), SN(32, 0xffff)));
	RzILOpPure *op_MUL_39 = MUL(CAST(64, MSB(CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(op_AND_17), DUP(op_AND_17))), CAST(32, MSB(DUP(op_AND_17)), DUP(op_AND_17)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_17)), DUP(op_AND_17))), CAST(32, MSB(DUP(op_AND_17)), DUP(op_AND_17))))), CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(DUP(op_AND_17)), DUP(op_AND_17))), CAST(32, MSB(DUP(op_AND_17)), DUP(op_AND_17)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_17)), DUP(op_AND_17))), CAST(32, MSB(DUP(op_AND_17)), DUP(op_AND_17))))), SEXTRACT64(CAST(64, IL_FALSE, CAST(16, MSB(op_AND_32), DUP(op_AND_32))), SN(32, 0), SN(32, 16)));
	RzILOpPure *op_LSHIFT_41 = SHIFTL0(op_MUL_39, SN(32, 1));
	RzILOpPure *op_ADD_44 = ADD(op_LSHIFT_41, CAST(64, MSB(SN(32, 0x8000)), SN(32, 0x8000)));
	RzILOpPure *op_RSHIFT_46 = SHIFTRA(op_ADD_44, SN(32, 16));
	RzILOpPure *op_RSHIFT_55 = SHIFTRA(DUP(Rss), SN(32, 0x20));
	RzILOpPure *op_AND_57 = LOGAND(op_RSHIFT_55, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_68 = SHIFTRA(DUP(Rtt), SN(32, 0x30));
	RzILOpPure *op_AND_71 = LOGAND(op_RSHIFT_68, CAST(64, MSB(SN(32, 0xffff)), SN(32, 0xffff)));
	RzILOpPure *op_MUL_78 = MUL(CAST(64, MSB(CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(op_AND_57), DUP(op_AND_57))), CAST(32, MSB(DUP(op_AND_57)), DUP(op_AND_57)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_57)), DUP(op_AND_57))), CAST(32, MSB(DUP(op_AND_57)), DUP(op_AND_57))))), CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(DUP(op_AND_57)), DUP(op_AND_57))), CAST(32, MSB(DUP(op_AND_57)), DUP(op_AND_57)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_57)), DUP(op_AND_57))), CAST(32, MSB(DUP(op_AND_57)), DUP(op_AND_57))))), SEXTRACT64(CAST(64, IL_FALSE, CAST(16, MSB(op_AND_71), DUP(op_AND_71))), SN(32, 0), SN(32, 16)));
	RzILOpPure *op_LSHIFT_80 = SHIFTL0(op_MUL_78, SN(32, 1));
	RzILOpPure *op_ADD_83 = ADD(op_LSHIFT_80, CAST(64, MSB(SN(32, 0x8000)), SN(32, 0x8000)));
	RzILOpPure *op_RSHIFT_85 = SHIFTRA(op_ADD_83, SN(32, 16));
	RzILOpPure *op_EQ_86 = EQ(SEXTRACT64(CAST(64, IL_FALSE, op_RSHIFT_46), SN(32, 0), SN(32, 0x20)), op_RSHIFT_85);
	RzILOpPure *op_RSHIFT_127 = SHIFTRA(DUP(Rss), SN(32, 0x20));
	RzILOpPure *op_AND_129 = LOGAND(op_RSHIFT_127, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_140 = SHIFTRA(DUP(Rtt), SN(32, 0x30));
	RzILOpPure *op_AND_143 = LOGAND(op_RSHIFT_140, CAST(64, MSB(SN(32, 0xffff)), SN(32, 0xffff)));
	RzILOpPure *op_MUL_150 = MUL(CAST(64, MSB(CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(op_AND_129), DUP(op_AND_129))), CAST(32, MSB(DUP(op_AND_129)), DUP(op_AND_129)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_129)), DUP(op_AND_129))), CAST(32, MSB(DUP(op_AND_129)), DUP(op_AND_129))))), CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(DUP(op_AND_129)), DUP(op_AND_129))), CAST(32, MSB(DUP(op_AND_129)), DUP(op_AND_129)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_129)), DUP(op_AND_129))), CAST(32, MSB(DUP(op_AND_129)), DUP(op_AND_129))))), SEXTRACT64(CAST(64, IL_FALSE, CAST(16, MSB(op_AND_143), DUP(op_AND_143))), SN(32, 0), SN(32, 16)));
	RzILOpPure *op_LSHIFT_152 = SHIFTL0(op_MUL_150, SN(32, 1));
	RzILOpPure *op_ADD_155 = ADD(op_LSHIFT_152, CAST(64, MSB(SN(32, 0x8000)), SN(32, 0x8000)));
	RzILOpPure *op_RSHIFT_157 = SHIFTRA(op_ADD_155, SN(32, 16));
	RzILOpPure *op_LT_160 = SLT(op_RSHIFT_157, CAST(64, MSB(SN(32, 0)), SN(32, 0)));
	RzILOpPure *op_LSHIFT_165 = SHIFTL0(SN(64, 1), SN(32, 31));
	RzILOpPure *op_NEG_166 = NEG(op_LSHIFT_165);
	RzILOpPure *op_LSHIFT_171 = SHIFTL0(SN(64, 1), SN(32, 31));
	RzILOpPure *op_SUB_174 = SUB(op_LSHIFT_171, CAST(64, MSB(SN(32, 1)), SN(32, 1)));
	RzILOpPure *cond_175 = ITE(op_LT_160, op_NEG_166, op_SUB_174);
	RzILOpEffect *gcc_expr_176 = BRANCH(op_EQ_86, EMPTY(), set_usr_field_call_123);

	// h_tmp302 = HYB(gcc_expr_if ((sextract64(((ut64) ((((st64) ((st32) ((st64) ((st32) ((Rss >> 0x20) & 0xffffffff))))) * sextract64(((ut64) ((st16) ((Rtt >> 0x30) & ((st64) 0xffff)))), 0x0, 0x10) << 0x1) + ((st64) 0x8000) >> 0x10)), 0x0, 0x20) == ((((st64) ((st32) ((st64) ((st32) ((Rss >> 0x20) & 0xffffffff))))) * sextract64(((ut64) ((st16) ((Rtt >> 0x30) & ((st64) 0xffff)))), 0x0, 0x10) << 0x1) + ((st64) 0x8000) >> 0x10))) {{}} else {set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, ((ut32) 0x1))}, ((((((st64) ((st32) ((st64) ((st32) ((Rss >> 0x20) & 0xffffffff))))) * sextract64(((ut64) ((st16) ((Rtt >> 0x30) & ((st64) 0xffff)))), 0x0, 0x10) << 0x1) + ((st64) 0x8000) >> 0x10) < ((st64) 0x0)) ? (-(0x1 << 0x1f)) : (0x1 << 0x1f) - ((st64) 0x1)));
	RzILOpEffect *op_ASSIGN_hybrid_tmp_178 = SETL("h_tmp302", cond_175);

	// seq(HYB(gcc_expr_if ((sextract64(((ut64) ((((st64) ((st32) ((st6 ...;
	RzILOpEffect *seq_179 = SEQN(2, gcc_expr_176, op_ASSIGN_hybrid_tmp_178);

	// Rdd = ((Rdd & (~(0xffffffff << 0x20))) | ((((sextract64(((ut64) ((((st64) ((st32) ((st64) ((st32) ((Rss >> 0x20) & 0xffffffff))))) * sextract64(((ut64) ((st16) ((Rtt >> 0x30) & ((st64) 0xffff)))), 0x0, 0x10) << 0x1) + ((st64) 0x8000) >> 0x10)), 0x0, 0x20) == ((((st64) ((st32) ((st64) ((st32) ((Rss >> 0x20) & 0xffffffff))))) * sextract64(((ut64) ((st16) ((Rtt >> 0x30) & ((st64) 0xffff)))), 0x0, 0x10) << 0x1) + ((st64) 0x8000) >> 0x10)) ? ((((st64) ((st32) ((st64) ((st32) ((Rss >> 0x20) & 0xffffffff))))) * sextract64(((ut64) ((st16) ((Rtt >> 0x30) & ((st64) 0xffff)))), 0x0, 0x10) << 0x1) + ((st64) 0x8000) >> 0x10) : h_tmp302) & 0xffffffff) << 0x20));
	RzILOpPure *op_LSHIFT_5 = SHIFTL0(SN(64, 0xffffffff), SN(32, 0x20));
	RzILOpPure *op_NOT_6 = LOGNOT(op_LSHIFT_5);
	RzILOpPure *op_AND_7 = LOGAND(READ_REG(pkt, Rdd_op, true), op_NOT_6);
	RzILOpPure *op_RSHIFT_90 = SHIFTRA(DUP(Rss), SN(32, 0x20));
	RzILOpPure *op_AND_92 = LOGAND(op_RSHIFT_90, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_103 = SHIFTRA(DUP(Rtt), SN(32, 0x30));
	RzILOpPure *op_AND_106 = LOGAND(op_RSHIFT_103, CAST(64, MSB(SN(32, 0xffff)), SN(32, 0xffff)));
	RzILOpPure *op_MUL_113 = MUL(CAST(64, MSB(CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(op_AND_92), DUP(op_AND_92))), CAST(32, MSB(DUP(op_AND_92)), DUP(op_AND_92)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_92)), DUP(op_AND_92))), CAST(32, MSB(DUP(op_AND_92)), DUP(op_AND_92))))), CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(DUP(op_AND_92)), DUP(op_AND_92))), CAST(32, MSB(DUP(op_AND_92)), DUP(op_AND_92)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_92)), DUP(op_AND_92))), CAST(32, MSB(DUP(op_AND_92)), DUP(op_AND_92))))), SEXTRACT64(CAST(64, IL_FALSE, CAST(16, MSB(op_AND_106), DUP(op_AND_106))), SN(32, 0), SN(32, 16)));
	RzILOpPure *op_LSHIFT_115 = SHIFTL0(op_MUL_113, SN(32, 1));
	RzILOpPure *op_ADD_118 = ADD(op_LSHIFT_115, CAST(64, MSB(SN(32, 0x8000)), SN(32, 0x8000)));
	RzILOpPure *op_RSHIFT_120 = SHIFTRA(op_ADD_118, SN(32, 16));
	RzILOpPure *cond_180 = ITE(DUP(op_EQ_86), op_RSHIFT_120, VARL("h_tmp302"));
	RzILOpPure *op_AND_182 = LOGAND(cond_180, SN(64, 0xffffffff));
	RzILOpPure *op_LSHIFT_186 = SHIFTL0(op_AND_182, SN(32, 0x20));
	RzILOpPure *op_OR_187 = LOGOR(op_AND_7, op_LSHIFT_186);
	RzILOpEffect *op_ASSIGN_188 = WRITE_REG(bundle, Rdd_op, op_OR_187);

	// seq(seq(HYB(gcc_expr_if ((sextract64(((ut64) ((((st64) ((st32) ( ...;
	RzILOpEffect *seq_189 = SEQN(2, seq_179, op_ASSIGN_188);

	// set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, ((ut32) 0x1));
	RzILOpEffect *set_usr_field_call_311 = hex_set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, CAST(32, IL_FALSE, SN(32, 1)));

	// HYB(gcc_expr_if ((sextract64(((ut64) ((((st64) ((st32) ((st64) ((st32) ((Rss >> 0x0) & 0xffffffff))))) * sextract64(((ut64) ((st16) ((Rtt >> 0x10) & ((st64) 0xffff)))), 0x0, 0x10) << 0x1) + ((st64) 0x8000) >> 0x10)), 0x0, 0x20) == ((((st64) ((st32) ((st64) ((st32) ((Rss >> 0x0) & 0xffffffff))))) * sextract64(((ut64) ((st16) ((Rtt >> 0x10) & ((st64) 0xffff)))), 0x0, 0x10) << 0x1) + ((st64) 0x8000) >> 0x10))) {{}} else {set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, ((ut32) 0x1))}, ((((((st64) ((st32) ((st64) ((st32) ((Rss >> 0x0) & 0xffffffff))))) * sextract64(((ut64) ((st16) ((Rtt >> 0x10) & ((st64) 0xffff)))), 0x0, 0x10) << 0x1) + ((st64) 0x8000) >> 0x10) < ((st64) 0x0)) ? (-(0x1 << 0x1f)) : (0x1 << 0x1f) - ((st64) 0x1)));
	RzILOpPure *op_RSHIFT_204 = SHIFTRA(DUP(Rss), SN(32, 0));
	RzILOpPure *op_AND_206 = LOGAND(op_RSHIFT_204, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_217 = SHIFTRA(DUP(Rtt), SN(32, 16));
	RzILOpPure *op_AND_220 = LOGAND(op_RSHIFT_217, CAST(64, MSB(SN(32, 0xffff)), SN(32, 0xffff)));
	RzILOpPure *op_MUL_227 = MUL(CAST(64, MSB(CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(op_AND_206), DUP(op_AND_206))), CAST(32, MSB(DUP(op_AND_206)), DUP(op_AND_206)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_206)), DUP(op_AND_206))), CAST(32, MSB(DUP(op_AND_206)), DUP(op_AND_206))))), CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(DUP(op_AND_206)), DUP(op_AND_206))), CAST(32, MSB(DUP(op_AND_206)), DUP(op_AND_206)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_206)), DUP(op_AND_206))), CAST(32, MSB(DUP(op_AND_206)), DUP(op_AND_206))))), SEXTRACT64(CAST(64, IL_FALSE, CAST(16, MSB(op_AND_220), DUP(op_AND_220))), SN(32, 0), SN(32, 16)));
	RzILOpPure *op_LSHIFT_229 = SHIFTL0(op_MUL_227, SN(32, 1));
	RzILOpPure *op_ADD_232 = ADD(op_LSHIFT_229, CAST(64, MSB(SN(32, 0x8000)), SN(32, 0x8000)));
	RzILOpPure *op_RSHIFT_234 = SHIFTRA(op_ADD_232, SN(32, 16));
	RzILOpPure *op_RSHIFT_243 = SHIFTRA(DUP(Rss), SN(32, 0));
	RzILOpPure *op_AND_245 = LOGAND(op_RSHIFT_243, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_256 = SHIFTRA(DUP(Rtt), SN(32, 16));
	RzILOpPure *op_AND_259 = LOGAND(op_RSHIFT_256, CAST(64, MSB(SN(32, 0xffff)), SN(32, 0xffff)));
	RzILOpPure *op_MUL_266 = MUL(CAST(64, MSB(CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(op_AND_245), DUP(op_AND_245))), CAST(32, MSB(DUP(op_AND_245)), DUP(op_AND_245)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_245)), DUP(op_AND_245))), CAST(32, MSB(DUP(op_AND_245)), DUP(op_AND_245))))), CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(DUP(op_AND_245)), DUP(op_AND_245))), CAST(32, MSB(DUP(op_AND_245)), DUP(op_AND_245)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_245)), DUP(op_AND_245))), CAST(32, MSB(DUP(op_AND_245)), DUP(op_AND_245))))), SEXTRACT64(CAST(64, IL_FALSE, CAST(16, MSB(op_AND_259), DUP(op_AND_259))), SN(32, 0), SN(32, 16)));
	RzILOpPure *op_LSHIFT_268 = SHIFTL0(op_MUL_266, SN(32, 1));
	RzILOpPure *op_ADD_271 = ADD(op_LSHIFT_268, CAST(64, MSB(SN(32, 0x8000)), SN(32, 0x8000)));
	RzILOpPure *op_RSHIFT_273 = SHIFTRA(op_ADD_271, SN(32, 16));
	RzILOpPure *op_EQ_274 = EQ(SEXTRACT64(CAST(64, IL_FALSE, op_RSHIFT_234), SN(32, 0), SN(32, 0x20)), op_RSHIFT_273);
	RzILOpPure *op_RSHIFT_315 = SHIFTRA(DUP(Rss), SN(32, 0));
	RzILOpPure *op_AND_317 = LOGAND(op_RSHIFT_315, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_328 = SHIFTRA(DUP(Rtt), SN(32, 16));
	RzILOpPure *op_AND_331 = LOGAND(op_RSHIFT_328, CAST(64, MSB(SN(32, 0xffff)), SN(32, 0xffff)));
	RzILOpPure *op_MUL_338 = MUL(CAST(64, MSB(CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(op_AND_317), DUP(op_AND_317))), CAST(32, MSB(DUP(op_AND_317)), DUP(op_AND_317)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_317)), DUP(op_AND_317))), CAST(32, MSB(DUP(op_AND_317)), DUP(op_AND_317))))), CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(DUP(op_AND_317)), DUP(op_AND_317))), CAST(32, MSB(DUP(op_AND_317)), DUP(op_AND_317)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_317)), DUP(op_AND_317))), CAST(32, MSB(DUP(op_AND_317)), DUP(op_AND_317))))), SEXTRACT64(CAST(64, IL_FALSE, CAST(16, MSB(op_AND_331), DUP(op_AND_331))), SN(32, 0), SN(32, 16)));
	RzILOpPure *op_LSHIFT_340 = SHIFTL0(op_MUL_338, SN(32, 1));
	RzILOpPure *op_ADD_343 = ADD(op_LSHIFT_340, CAST(64, MSB(SN(32, 0x8000)), SN(32, 0x8000)));
	RzILOpPure *op_RSHIFT_345 = SHIFTRA(op_ADD_343, SN(32, 16));
	RzILOpPure *op_LT_348 = SLT(op_RSHIFT_345, CAST(64, MSB(SN(32, 0)), SN(32, 0)));
	RzILOpPure *op_LSHIFT_353 = SHIFTL0(SN(64, 1), SN(32, 31));
	RzILOpPure *op_NEG_354 = NEG(op_LSHIFT_353);
	RzILOpPure *op_LSHIFT_359 = SHIFTL0(SN(64, 1), SN(32, 31));
	RzILOpPure *op_SUB_362 = SUB(op_LSHIFT_359, CAST(64, MSB(SN(32, 1)), SN(32, 1)));
	RzILOpPure *cond_363 = ITE(op_LT_348, op_NEG_354, op_SUB_362);
	RzILOpEffect *gcc_expr_364 = BRANCH(op_EQ_274, EMPTY(), set_usr_field_call_311);

	// h_tmp303 = HYB(gcc_expr_if ((sextract64(((ut64) ((((st64) ((st32) ((st64) ((st32) ((Rss >> 0x0) & 0xffffffff))))) * sextract64(((ut64) ((st16) ((Rtt >> 0x10) & ((st64) 0xffff)))), 0x0, 0x10) << 0x1) + ((st64) 0x8000) >> 0x10)), 0x0, 0x20) == ((((st64) ((st32) ((st64) ((st32) ((Rss >> 0x0) & 0xffffffff))))) * sextract64(((ut64) ((st16) ((Rtt >> 0x10) & ((st64) 0xffff)))), 0x0, 0x10) << 0x1) + ((st64) 0x8000) >> 0x10))) {{}} else {set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, ((ut32) 0x1))}, ((((((st64) ((st32) ((st64) ((st32) ((Rss >> 0x0) & 0xffffffff))))) * sextract64(((ut64) ((st16) ((Rtt >> 0x10) & ((st64) 0xffff)))), 0x0, 0x10) << 0x1) + ((st64) 0x8000) >> 0x10) < ((st64) 0x0)) ? (-(0x1 << 0x1f)) : (0x1 << 0x1f) - ((st64) 0x1)));
	RzILOpEffect *op_ASSIGN_hybrid_tmp_366 = SETL("h_tmp303", cond_363);

	// seq(HYB(gcc_expr_if ((sextract64(((ut64) ((((st64) ((st32) ((st6 ...;
	RzILOpEffect *seq_367 = SEQN(2, gcc_expr_364, op_ASSIGN_hybrid_tmp_366);

	// Rdd = ((Rdd & (~(0xffffffff << 0x0))) | ((((sextract64(((ut64) ((((st64) ((st32) ((st64) ((st32) ((Rss >> 0x0) & 0xffffffff))))) * sextract64(((ut64) ((st16) ((Rtt >> 0x10) & ((st64) 0xffff)))), 0x0, 0x10) << 0x1) + ((st64) 0x8000) >> 0x10)), 0x0, 0x20) == ((((st64) ((st32) ((st64) ((st32) ((Rss >> 0x0) & 0xffffffff))))) * sextract64(((ut64) ((st16) ((Rtt >> 0x10) & ((st64) 0xffff)))), 0x0, 0x10) << 0x1) + ((st64) 0x8000) >> 0x10)) ? ((((st64) ((st32) ((st64) ((st32) ((Rss >> 0x0) & 0xffffffff))))) * sextract64(((ut64) ((st16) ((Rtt >> 0x10) & ((st64) 0xffff)))), 0x0, 0x10) << 0x1) + ((st64) 0x8000) >> 0x10) : h_tmp303) & 0xffffffff) << 0x0));
	RzILOpPure *op_LSHIFT_195 = SHIFTL0(SN(64, 0xffffffff), SN(32, 0));
	RzILOpPure *op_NOT_196 = LOGNOT(op_LSHIFT_195);
	RzILOpPure *op_AND_197 = LOGAND(READ_REG(pkt, Rdd_op, true), op_NOT_196);
	RzILOpPure *op_RSHIFT_278 = SHIFTRA(DUP(Rss), SN(32, 0));
	RzILOpPure *op_AND_280 = LOGAND(op_RSHIFT_278, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_291 = SHIFTRA(DUP(Rtt), SN(32, 16));
	RzILOpPure *op_AND_294 = LOGAND(op_RSHIFT_291, CAST(64, MSB(SN(32, 0xffff)), SN(32, 0xffff)));
	RzILOpPure *op_MUL_301 = MUL(CAST(64, MSB(CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(op_AND_280), DUP(op_AND_280))), CAST(32, MSB(DUP(op_AND_280)), DUP(op_AND_280)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_280)), DUP(op_AND_280))), CAST(32, MSB(DUP(op_AND_280)), DUP(op_AND_280))))), CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(DUP(op_AND_280)), DUP(op_AND_280))), CAST(32, MSB(DUP(op_AND_280)), DUP(op_AND_280)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_280)), DUP(op_AND_280))), CAST(32, MSB(DUP(op_AND_280)), DUP(op_AND_280))))), SEXTRACT64(CAST(64, IL_FALSE, CAST(16, MSB(op_AND_294), DUP(op_AND_294))), SN(32, 0), SN(32, 16)));
	RzILOpPure *op_LSHIFT_303 = SHIFTL0(op_MUL_301, SN(32, 1));
	RzILOpPure *op_ADD_306 = ADD(op_LSHIFT_303, CAST(64, MSB(SN(32, 0x8000)), SN(32, 0x8000)));
	RzILOpPure *op_RSHIFT_308 = SHIFTRA(op_ADD_306, SN(32, 16));
	RzILOpPure *cond_368 = ITE(DUP(op_EQ_274), op_RSHIFT_308, VARL("h_tmp303"));
	RzILOpPure *op_AND_370 = LOGAND(cond_368, SN(64, 0xffffffff));
	RzILOpPure *op_LSHIFT_374 = SHIFTL0(op_AND_370, SN(32, 0));
	RzILOpPure *op_OR_375 = LOGOR(op_AND_197, op_LSHIFT_374);
	RzILOpEffect *op_ASSIGN_376 = WRITE_REG(bundle, Rdd_op, op_OR_375);

	// seq(seq(HYB(gcc_expr_if ((sextract64(((ut64) ((((st64) ((st32) ( ...;
	RzILOpEffect *seq_377 = SEQN(2, seq_367, op_ASSIGN_376);

	RzILOpEffect *instruction_sequence = SEQN(2, seq_189, seq_377);
	return instruction_sequence;
}

// Rdd = vmpywoh(Rss,Rtt):sat
RzILOpEffect *hex_il_op_m2_mmpyh_s0(HexInsnPktBundle *bundle) {
	const HexInsn *hi = bundle->insn;
	HexPkt *pkt = bundle->pkt;
	// READ
	const HexOp *Rdd_op = ISA2REG(hi, 'd', false);
	const HexOp *Rss_op = ISA2REG(hi, 's', false);
	RzILOpPure *Rss = READ_REG(pkt, Rss_op, false);
	const HexOp *Rtt_op = ISA2REG(hi, 't', false);
	RzILOpPure *Rtt = READ_REG(pkt, Rtt_op, false);

	// set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, ((ut32) 0x1));
	RzILOpEffect *set_usr_field_call_114 = hex_set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, CAST(32, IL_FALSE, SN(32, 1)));

	// HYB(gcc_expr_if ((sextract64(((ut64) ((((st64) ((st32) ((st64) ((st32) ((Rss >> 0x20) & 0xffffffff))))) * sextract64(((ut64) ((st16) ((Rtt >> 0x30) & ((st64) 0xffff)))), 0x0, 0x10) << 0x0) >> 0x10)), 0x0, 0x20) == ((((st64) ((st32) ((st64) ((st32) ((Rss >> 0x20) & 0xffffffff))))) * sextract64(((ut64) ((st16) ((Rtt >> 0x30) & ((st64) 0xffff)))), 0x0, 0x10) << 0x0) >> 0x10))) {{}} else {set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, ((ut32) 0x1))}, ((((((st64) ((st32) ((st64) ((st32) ((Rss >> 0x20) & 0xffffffff))))) * sextract64(((ut64) ((st16) ((Rtt >> 0x30) & ((st64) 0xffff)))), 0x0, 0x10) << 0x0) >> 0x10) < ((st64) 0x0)) ? (-(0x1 << 0x1f)) : (0x1 << 0x1f) - ((st64) 0x1)));
	RzILOpPure *op_RSHIFT_15 = SHIFTRA(Rss, SN(32, 0x20));
	RzILOpPure *op_AND_17 = LOGAND(op_RSHIFT_15, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_29 = SHIFTRA(Rtt, SN(32, 0x30));
	RzILOpPure *op_AND_32 = LOGAND(op_RSHIFT_29, CAST(64, MSB(SN(32, 0xffff)), SN(32, 0xffff)));
	RzILOpPure *op_MUL_39 = MUL(CAST(64, MSB(CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(op_AND_17), DUP(op_AND_17))), CAST(32, MSB(DUP(op_AND_17)), DUP(op_AND_17)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_17)), DUP(op_AND_17))), CAST(32, MSB(DUP(op_AND_17)), DUP(op_AND_17))))), CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(DUP(op_AND_17)), DUP(op_AND_17))), CAST(32, MSB(DUP(op_AND_17)), DUP(op_AND_17)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_17)), DUP(op_AND_17))), CAST(32, MSB(DUP(op_AND_17)), DUP(op_AND_17))))), SEXTRACT64(CAST(64, IL_FALSE, CAST(16, MSB(op_AND_32), DUP(op_AND_32))), SN(32, 0), SN(32, 16)));
	RzILOpPure *op_LSHIFT_41 = SHIFTL0(op_MUL_39, SN(32, 0));
	RzILOpPure *op_RSHIFT_43 = SHIFTRA(op_LSHIFT_41, SN(32, 16));
	RzILOpPure *op_RSHIFT_52 = SHIFTRA(DUP(Rss), SN(32, 0x20));
	RzILOpPure *op_AND_54 = LOGAND(op_RSHIFT_52, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_65 = SHIFTRA(DUP(Rtt), SN(32, 0x30));
	RzILOpPure *op_AND_68 = LOGAND(op_RSHIFT_65, CAST(64, MSB(SN(32, 0xffff)), SN(32, 0xffff)));
	RzILOpPure *op_MUL_75 = MUL(CAST(64, MSB(CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(op_AND_54), DUP(op_AND_54))), CAST(32, MSB(DUP(op_AND_54)), DUP(op_AND_54)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_54)), DUP(op_AND_54))), CAST(32, MSB(DUP(op_AND_54)), DUP(op_AND_54))))), CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(DUP(op_AND_54)), DUP(op_AND_54))), CAST(32, MSB(DUP(op_AND_54)), DUP(op_AND_54)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_54)), DUP(op_AND_54))), CAST(32, MSB(DUP(op_AND_54)), DUP(op_AND_54))))), SEXTRACT64(CAST(64, IL_FALSE, CAST(16, MSB(op_AND_68), DUP(op_AND_68))), SN(32, 0), SN(32, 16)));
	RzILOpPure *op_LSHIFT_77 = SHIFTL0(op_MUL_75, SN(32, 0));
	RzILOpPure *op_RSHIFT_79 = SHIFTRA(op_LSHIFT_77, SN(32, 16));
	RzILOpPure *op_EQ_80 = EQ(SEXTRACT64(CAST(64, IL_FALSE, op_RSHIFT_43), SN(32, 0), SN(32, 0x20)), op_RSHIFT_79);
	RzILOpPure *op_RSHIFT_118 = SHIFTRA(DUP(Rss), SN(32, 0x20));
	RzILOpPure *op_AND_120 = LOGAND(op_RSHIFT_118, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_131 = SHIFTRA(DUP(Rtt), SN(32, 0x30));
	RzILOpPure *op_AND_134 = LOGAND(op_RSHIFT_131, CAST(64, MSB(SN(32, 0xffff)), SN(32, 0xffff)));
	RzILOpPure *op_MUL_141 = MUL(CAST(64, MSB(CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(op_AND_120), DUP(op_AND_120))), CAST(32, MSB(DUP(op_AND_120)), DUP(op_AND_120)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_120)), DUP(op_AND_120))), CAST(32, MSB(DUP(op_AND_120)), DUP(op_AND_120))))), CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(DUP(op_AND_120)), DUP(op_AND_120))), CAST(32, MSB(DUP(op_AND_120)), DUP(op_AND_120)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_120)), DUP(op_AND_120))), CAST(32, MSB(DUP(op_AND_120)), DUP(op_AND_120))))), SEXTRACT64(CAST(64, IL_FALSE, CAST(16, MSB(op_AND_134), DUP(op_AND_134))), SN(32, 0), SN(32, 16)));
	RzILOpPure *op_LSHIFT_143 = SHIFTL0(op_MUL_141, SN(32, 0));
	RzILOpPure *op_RSHIFT_145 = SHIFTRA(op_LSHIFT_143, SN(32, 16));
	RzILOpPure *op_LT_148 = SLT(op_RSHIFT_145, CAST(64, MSB(SN(32, 0)), SN(32, 0)));
	RzILOpPure *op_LSHIFT_153 = SHIFTL0(SN(64, 1), SN(32, 31));
	RzILOpPure *op_NEG_154 = NEG(op_LSHIFT_153);
	RzILOpPure *op_LSHIFT_159 = SHIFTL0(SN(64, 1), SN(32, 31));
	RzILOpPure *op_SUB_162 = SUB(op_LSHIFT_159, CAST(64, MSB(SN(32, 1)), SN(32, 1)));
	RzILOpPure *cond_163 = ITE(op_LT_148, op_NEG_154, op_SUB_162);
	RzILOpEffect *gcc_expr_164 = BRANCH(op_EQ_80, EMPTY(), set_usr_field_call_114);

	// h_tmp304 = HYB(gcc_expr_if ((sextract64(((ut64) ((((st64) ((st32) ((st64) ((st32) ((Rss >> 0x20) & 0xffffffff))))) * sextract64(((ut64) ((st16) ((Rtt >> 0x30) & ((st64) 0xffff)))), 0x0, 0x10) << 0x0) >> 0x10)), 0x0, 0x20) == ((((st64) ((st32) ((st64) ((st32) ((Rss >> 0x20) & 0xffffffff))))) * sextract64(((ut64) ((st16) ((Rtt >> 0x30) & ((st64) 0xffff)))), 0x0, 0x10) << 0x0) >> 0x10))) {{}} else {set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, ((ut32) 0x1))}, ((((((st64) ((st32) ((st64) ((st32) ((Rss >> 0x20) & 0xffffffff))))) * sextract64(((ut64) ((st16) ((Rtt >> 0x30) & ((st64) 0xffff)))), 0x0, 0x10) << 0x0) >> 0x10) < ((st64) 0x0)) ? (-(0x1 << 0x1f)) : (0x1 << 0x1f) - ((st64) 0x1)));
	RzILOpEffect *op_ASSIGN_hybrid_tmp_166 = SETL("h_tmp304", cond_163);

	// seq(HYB(gcc_expr_if ((sextract64(((ut64) ((((st64) ((st32) ((st6 ...;
	RzILOpEffect *seq_167 = SEQN(2, gcc_expr_164, op_ASSIGN_hybrid_tmp_166);

	// Rdd = ((Rdd & (~(0xffffffff << 0x20))) | ((((sextract64(((ut64) ((((st64) ((st32) ((st64) ((st32) ((Rss >> 0x20) & 0xffffffff))))) * sextract64(((ut64) ((st16) ((Rtt >> 0x30) & ((st64) 0xffff)))), 0x0, 0x10) << 0x0) >> 0x10)), 0x0, 0x20) == ((((st64) ((st32) ((st64) ((st32) ((Rss >> 0x20) & 0xffffffff))))) * sextract64(((ut64) ((st16) ((Rtt >> 0x30) & ((st64) 0xffff)))), 0x0, 0x10) << 0x0) >> 0x10)) ? ((((st64) ((st32) ((st64) ((st32) ((Rss >> 0x20) & 0xffffffff))))) * sextract64(((ut64) ((st16) ((Rtt >> 0x30) & ((st64) 0xffff)))), 0x0, 0x10) << 0x0) >> 0x10) : h_tmp304) & 0xffffffff) << 0x20));
	RzILOpPure *op_LSHIFT_5 = SHIFTL0(SN(64, 0xffffffff), SN(32, 0x20));
	RzILOpPure *op_NOT_6 = LOGNOT(op_LSHIFT_5);
	RzILOpPure *op_AND_7 = LOGAND(READ_REG(pkt, Rdd_op, true), op_NOT_6);
	RzILOpPure *op_RSHIFT_84 = SHIFTRA(DUP(Rss), SN(32, 0x20));
	RzILOpPure *op_AND_86 = LOGAND(op_RSHIFT_84, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_97 = SHIFTRA(DUP(Rtt), SN(32, 0x30));
	RzILOpPure *op_AND_100 = LOGAND(op_RSHIFT_97, CAST(64, MSB(SN(32, 0xffff)), SN(32, 0xffff)));
	RzILOpPure *op_MUL_107 = MUL(CAST(64, MSB(CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(op_AND_86), DUP(op_AND_86))), CAST(32, MSB(DUP(op_AND_86)), DUP(op_AND_86)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_86)), DUP(op_AND_86))), CAST(32, MSB(DUP(op_AND_86)), DUP(op_AND_86))))), CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(DUP(op_AND_86)), DUP(op_AND_86))), CAST(32, MSB(DUP(op_AND_86)), DUP(op_AND_86)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_86)), DUP(op_AND_86))), CAST(32, MSB(DUP(op_AND_86)), DUP(op_AND_86))))), SEXTRACT64(CAST(64, IL_FALSE, CAST(16, MSB(op_AND_100), DUP(op_AND_100))), SN(32, 0), SN(32, 16)));
	RzILOpPure *op_LSHIFT_109 = SHIFTL0(op_MUL_107, SN(32, 0));
	RzILOpPure *op_RSHIFT_111 = SHIFTRA(op_LSHIFT_109, SN(32, 16));
	RzILOpPure *cond_168 = ITE(DUP(op_EQ_80), op_RSHIFT_111, VARL("h_tmp304"));
	RzILOpPure *op_AND_170 = LOGAND(cond_168, SN(64, 0xffffffff));
	RzILOpPure *op_LSHIFT_174 = SHIFTL0(op_AND_170, SN(32, 0x20));
	RzILOpPure *op_OR_175 = LOGOR(op_AND_7, op_LSHIFT_174);
	RzILOpEffect *op_ASSIGN_176 = WRITE_REG(bundle, Rdd_op, op_OR_175);

	// seq(seq(HYB(gcc_expr_if ((sextract64(((ut64) ((((st64) ((st32) ( ...;
	RzILOpEffect *seq_177 = SEQN(2, seq_167, op_ASSIGN_176);

	// set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, ((ut32) 0x1));
	RzILOpEffect *set_usr_field_call_290 = hex_set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, CAST(32, IL_FALSE, SN(32, 1)));

	// HYB(gcc_expr_if ((sextract64(((ut64) ((((st64) ((st32) ((st64) ((st32) ((Rss >> 0x0) & 0xffffffff))))) * sextract64(((ut64) ((st16) ((Rtt >> 0x10) & ((st64) 0xffff)))), 0x0, 0x10) << 0x0) >> 0x10)), 0x0, 0x20) == ((((st64) ((st32) ((st64) ((st32) ((Rss >> 0x0) & 0xffffffff))))) * sextract64(((ut64) ((st16) ((Rtt >> 0x10) & ((st64) 0xffff)))), 0x0, 0x10) << 0x0) >> 0x10))) {{}} else {set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, ((ut32) 0x1))}, ((((((st64) ((st32) ((st64) ((st32) ((Rss >> 0x0) & 0xffffffff))))) * sextract64(((ut64) ((st16) ((Rtt >> 0x10) & ((st64) 0xffff)))), 0x0, 0x10) << 0x0) >> 0x10) < ((st64) 0x0)) ? (-(0x1 << 0x1f)) : (0x1 << 0x1f) - ((st64) 0x1)));
	RzILOpPure *op_RSHIFT_192 = SHIFTRA(DUP(Rss), SN(32, 0));
	RzILOpPure *op_AND_194 = LOGAND(op_RSHIFT_192, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_205 = SHIFTRA(DUP(Rtt), SN(32, 16));
	RzILOpPure *op_AND_208 = LOGAND(op_RSHIFT_205, CAST(64, MSB(SN(32, 0xffff)), SN(32, 0xffff)));
	RzILOpPure *op_MUL_215 = MUL(CAST(64, MSB(CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(op_AND_194), DUP(op_AND_194))), CAST(32, MSB(DUP(op_AND_194)), DUP(op_AND_194)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_194)), DUP(op_AND_194))), CAST(32, MSB(DUP(op_AND_194)), DUP(op_AND_194))))), CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(DUP(op_AND_194)), DUP(op_AND_194))), CAST(32, MSB(DUP(op_AND_194)), DUP(op_AND_194)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_194)), DUP(op_AND_194))), CAST(32, MSB(DUP(op_AND_194)), DUP(op_AND_194))))), SEXTRACT64(CAST(64, IL_FALSE, CAST(16, MSB(op_AND_208), DUP(op_AND_208))), SN(32, 0), SN(32, 16)));
	RzILOpPure *op_LSHIFT_217 = SHIFTL0(op_MUL_215, SN(32, 0));
	RzILOpPure *op_RSHIFT_219 = SHIFTRA(op_LSHIFT_217, SN(32, 16));
	RzILOpPure *op_RSHIFT_228 = SHIFTRA(DUP(Rss), SN(32, 0));
	RzILOpPure *op_AND_230 = LOGAND(op_RSHIFT_228, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_241 = SHIFTRA(DUP(Rtt), SN(32, 16));
	RzILOpPure *op_AND_244 = LOGAND(op_RSHIFT_241, CAST(64, MSB(SN(32, 0xffff)), SN(32, 0xffff)));
	RzILOpPure *op_MUL_251 = MUL(CAST(64, MSB(CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(op_AND_230), DUP(op_AND_230))), CAST(32, MSB(DUP(op_AND_230)), DUP(op_AND_230)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_230)), DUP(op_AND_230))), CAST(32, MSB(DUP(op_AND_230)), DUP(op_AND_230))))), CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(DUP(op_AND_230)), DUP(op_AND_230))), CAST(32, MSB(DUP(op_AND_230)), DUP(op_AND_230)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_230)), DUP(op_AND_230))), CAST(32, MSB(DUP(op_AND_230)), DUP(op_AND_230))))), SEXTRACT64(CAST(64, IL_FALSE, CAST(16, MSB(op_AND_244), DUP(op_AND_244))), SN(32, 0), SN(32, 16)));
	RzILOpPure *op_LSHIFT_253 = SHIFTL0(op_MUL_251, SN(32, 0));
	RzILOpPure *op_RSHIFT_255 = SHIFTRA(op_LSHIFT_253, SN(32, 16));
	RzILOpPure *op_EQ_256 = EQ(SEXTRACT64(CAST(64, IL_FALSE, op_RSHIFT_219), SN(32, 0), SN(32, 0x20)), op_RSHIFT_255);
	RzILOpPure *op_RSHIFT_294 = SHIFTRA(DUP(Rss), SN(32, 0));
	RzILOpPure *op_AND_296 = LOGAND(op_RSHIFT_294, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_307 = SHIFTRA(DUP(Rtt), SN(32, 16));
	RzILOpPure *op_AND_310 = LOGAND(op_RSHIFT_307, CAST(64, MSB(SN(32, 0xffff)), SN(32, 0xffff)));
	RzILOpPure *op_MUL_317 = MUL(CAST(64, MSB(CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(op_AND_296), DUP(op_AND_296))), CAST(32, MSB(DUP(op_AND_296)), DUP(op_AND_296)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_296)), DUP(op_AND_296))), CAST(32, MSB(DUP(op_AND_296)), DUP(op_AND_296))))), CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(DUP(op_AND_296)), DUP(op_AND_296))), CAST(32, MSB(DUP(op_AND_296)), DUP(op_AND_296)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_296)), DUP(op_AND_296))), CAST(32, MSB(DUP(op_AND_296)), DUP(op_AND_296))))), SEXTRACT64(CAST(64, IL_FALSE, CAST(16, MSB(op_AND_310), DUP(op_AND_310))), SN(32, 0), SN(32, 16)));
	RzILOpPure *op_LSHIFT_319 = SHIFTL0(op_MUL_317, SN(32, 0));
	RzILOpPure *op_RSHIFT_321 = SHIFTRA(op_LSHIFT_319, SN(32, 16));
	RzILOpPure *op_LT_324 = SLT(op_RSHIFT_321, CAST(64, MSB(SN(32, 0)), SN(32, 0)));
	RzILOpPure *op_LSHIFT_329 = SHIFTL0(SN(64, 1), SN(32, 31));
	RzILOpPure *op_NEG_330 = NEG(op_LSHIFT_329);
	RzILOpPure *op_LSHIFT_335 = SHIFTL0(SN(64, 1), SN(32, 31));
	RzILOpPure *op_SUB_338 = SUB(op_LSHIFT_335, CAST(64, MSB(SN(32, 1)), SN(32, 1)));
	RzILOpPure *cond_339 = ITE(op_LT_324, op_NEG_330, op_SUB_338);
	RzILOpEffect *gcc_expr_340 = BRANCH(op_EQ_256, EMPTY(), set_usr_field_call_290);

	// h_tmp305 = HYB(gcc_expr_if ((sextract64(((ut64) ((((st64) ((st32) ((st64) ((st32) ((Rss >> 0x0) & 0xffffffff))))) * sextract64(((ut64) ((st16) ((Rtt >> 0x10) & ((st64) 0xffff)))), 0x0, 0x10) << 0x0) >> 0x10)), 0x0, 0x20) == ((((st64) ((st32) ((st64) ((st32) ((Rss >> 0x0) & 0xffffffff))))) * sextract64(((ut64) ((st16) ((Rtt >> 0x10) & ((st64) 0xffff)))), 0x0, 0x10) << 0x0) >> 0x10))) {{}} else {set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, ((ut32) 0x1))}, ((((((st64) ((st32) ((st64) ((st32) ((Rss >> 0x0) & 0xffffffff))))) * sextract64(((ut64) ((st16) ((Rtt >> 0x10) & ((st64) 0xffff)))), 0x0, 0x10) << 0x0) >> 0x10) < ((st64) 0x0)) ? (-(0x1 << 0x1f)) : (0x1 << 0x1f) - ((st64) 0x1)));
	RzILOpEffect *op_ASSIGN_hybrid_tmp_342 = SETL("h_tmp305", cond_339);

	// seq(HYB(gcc_expr_if ((sextract64(((ut64) ((((st64) ((st32) ((st6 ...;
	RzILOpEffect *seq_343 = SEQN(2, gcc_expr_340, op_ASSIGN_hybrid_tmp_342);

	// Rdd = ((Rdd & (~(0xffffffff << 0x0))) | ((((sextract64(((ut64) ((((st64) ((st32) ((st64) ((st32) ((Rss >> 0x0) & 0xffffffff))))) * sextract64(((ut64) ((st16) ((Rtt >> 0x10) & ((st64) 0xffff)))), 0x0, 0x10) << 0x0) >> 0x10)), 0x0, 0x20) == ((((st64) ((st32) ((st64) ((st32) ((Rss >> 0x0) & 0xffffffff))))) * sextract64(((ut64) ((st16) ((Rtt >> 0x10) & ((st64) 0xffff)))), 0x0, 0x10) << 0x0) >> 0x10)) ? ((((st64) ((st32) ((st64) ((st32) ((Rss >> 0x0) & 0xffffffff))))) * sextract64(((ut64) ((st16) ((Rtt >> 0x10) & ((st64) 0xffff)))), 0x0, 0x10) << 0x0) >> 0x10) : h_tmp305) & 0xffffffff) << 0x0));
	RzILOpPure *op_LSHIFT_183 = SHIFTL0(SN(64, 0xffffffff), SN(32, 0));
	RzILOpPure *op_NOT_184 = LOGNOT(op_LSHIFT_183);
	RzILOpPure *op_AND_185 = LOGAND(READ_REG(pkt, Rdd_op, true), op_NOT_184);
	RzILOpPure *op_RSHIFT_260 = SHIFTRA(DUP(Rss), SN(32, 0));
	RzILOpPure *op_AND_262 = LOGAND(op_RSHIFT_260, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_273 = SHIFTRA(DUP(Rtt), SN(32, 16));
	RzILOpPure *op_AND_276 = LOGAND(op_RSHIFT_273, CAST(64, MSB(SN(32, 0xffff)), SN(32, 0xffff)));
	RzILOpPure *op_MUL_283 = MUL(CAST(64, MSB(CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(op_AND_262), DUP(op_AND_262))), CAST(32, MSB(DUP(op_AND_262)), DUP(op_AND_262)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_262)), DUP(op_AND_262))), CAST(32, MSB(DUP(op_AND_262)), DUP(op_AND_262))))), CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(DUP(op_AND_262)), DUP(op_AND_262))), CAST(32, MSB(DUP(op_AND_262)), DUP(op_AND_262)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_262)), DUP(op_AND_262))), CAST(32, MSB(DUP(op_AND_262)), DUP(op_AND_262))))), SEXTRACT64(CAST(64, IL_FALSE, CAST(16, MSB(op_AND_276), DUP(op_AND_276))), SN(32, 0), SN(32, 16)));
	RzILOpPure *op_LSHIFT_285 = SHIFTL0(op_MUL_283, SN(32, 0));
	RzILOpPure *op_RSHIFT_287 = SHIFTRA(op_LSHIFT_285, SN(32, 16));
	RzILOpPure *cond_344 = ITE(DUP(op_EQ_256), op_RSHIFT_287, VARL("h_tmp305"));
	RzILOpPure *op_AND_346 = LOGAND(cond_344, SN(64, 0xffffffff));
	RzILOpPure *op_LSHIFT_350 = SHIFTL0(op_AND_346, SN(32, 0));
	RzILOpPure *op_OR_351 = LOGOR(op_AND_185, op_LSHIFT_350);
	RzILOpEffect *op_ASSIGN_352 = WRITE_REG(bundle, Rdd_op, op_OR_351);

	// seq(seq(HYB(gcc_expr_if ((sextract64(((ut64) ((((st64) ((st32) ( ...;
	RzILOpEffect *seq_353 = SEQN(2, seq_343, op_ASSIGN_352);

	RzILOpEffect *instruction_sequence = SEQN(2, seq_177, seq_353);
	return instruction_sequence;
}

// Rdd = vmpywoh(Rss,Rtt):<<1:sat
RzILOpEffect *hex_il_op_m2_mmpyh_s1(HexInsnPktBundle *bundle) {
	const HexInsn *hi = bundle->insn;
	HexPkt *pkt = bundle->pkt;
	// READ
	const HexOp *Rdd_op = ISA2REG(hi, 'd', false);
	const HexOp *Rss_op = ISA2REG(hi, 's', false);
	RzILOpPure *Rss = READ_REG(pkt, Rss_op, false);
	const HexOp *Rtt_op = ISA2REG(hi, 't', false);
	RzILOpPure *Rtt = READ_REG(pkt, Rtt_op, false);

	// set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, ((ut32) 0x1));
	RzILOpEffect *set_usr_field_call_114 = hex_set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, CAST(32, IL_FALSE, SN(32, 1)));

	// HYB(gcc_expr_if ((sextract64(((ut64) ((((st64) ((st32) ((st64) ((st32) ((Rss >> 0x20) & 0xffffffff))))) * sextract64(((ut64) ((st16) ((Rtt >> 0x30) & ((st64) 0xffff)))), 0x0, 0x10) << 0x1) >> 0x10)), 0x0, 0x20) == ((((st64) ((st32) ((st64) ((st32) ((Rss >> 0x20) & 0xffffffff))))) * sextract64(((ut64) ((st16) ((Rtt >> 0x30) & ((st64) 0xffff)))), 0x0, 0x10) << 0x1) >> 0x10))) {{}} else {set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, ((ut32) 0x1))}, ((((((st64) ((st32) ((st64) ((st32) ((Rss >> 0x20) & 0xffffffff))))) * sextract64(((ut64) ((st16) ((Rtt >> 0x30) & ((st64) 0xffff)))), 0x0, 0x10) << 0x1) >> 0x10) < ((st64) 0x0)) ? (-(0x1 << 0x1f)) : (0x1 << 0x1f) - ((st64) 0x1)));
	RzILOpPure *op_RSHIFT_15 = SHIFTRA(Rss, SN(32, 0x20));
	RzILOpPure *op_AND_17 = LOGAND(op_RSHIFT_15, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_29 = SHIFTRA(Rtt, SN(32, 0x30));
	RzILOpPure *op_AND_32 = LOGAND(op_RSHIFT_29, CAST(64, MSB(SN(32, 0xffff)), SN(32, 0xffff)));
	RzILOpPure *op_MUL_39 = MUL(CAST(64, MSB(CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(op_AND_17), DUP(op_AND_17))), CAST(32, MSB(DUP(op_AND_17)), DUP(op_AND_17)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_17)), DUP(op_AND_17))), CAST(32, MSB(DUP(op_AND_17)), DUP(op_AND_17))))), CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(DUP(op_AND_17)), DUP(op_AND_17))), CAST(32, MSB(DUP(op_AND_17)), DUP(op_AND_17)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_17)), DUP(op_AND_17))), CAST(32, MSB(DUP(op_AND_17)), DUP(op_AND_17))))), SEXTRACT64(CAST(64, IL_FALSE, CAST(16, MSB(op_AND_32), DUP(op_AND_32))), SN(32, 0), SN(32, 16)));
	RzILOpPure *op_LSHIFT_41 = SHIFTL0(op_MUL_39, SN(32, 1));
	RzILOpPure *op_RSHIFT_43 = SHIFTRA(op_LSHIFT_41, SN(32, 16));
	RzILOpPure *op_RSHIFT_52 = SHIFTRA(DUP(Rss), SN(32, 0x20));
	RzILOpPure *op_AND_54 = LOGAND(op_RSHIFT_52, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_65 = SHIFTRA(DUP(Rtt), SN(32, 0x30));
	RzILOpPure *op_AND_68 = LOGAND(op_RSHIFT_65, CAST(64, MSB(SN(32, 0xffff)), SN(32, 0xffff)));
	RzILOpPure *op_MUL_75 = MUL(CAST(64, MSB(CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(op_AND_54), DUP(op_AND_54))), CAST(32, MSB(DUP(op_AND_54)), DUP(op_AND_54)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_54)), DUP(op_AND_54))), CAST(32, MSB(DUP(op_AND_54)), DUP(op_AND_54))))), CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(DUP(op_AND_54)), DUP(op_AND_54))), CAST(32, MSB(DUP(op_AND_54)), DUP(op_AND_54)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_54)), DUP(op_AND_54))), CAST(32, MSB(DUP(op_AND_54)), DUP(op_AND_54))))), SEXTRACT64(CAST(64, IL_FALSE, CAST(16, MSB(op_AND_68), DUP(op_AND_68))), SN(32, 0), SN(32, 16)));
	RzILOpPure *op_LSHIFT_77 = SHIFTL0(op_MUL_75, SN(32, 1));
	RzILOpPure *op_RSHIFT_79 = SHIFTRA(op_LSHIFT_77, SN(32, 16));
	RzILOpPure *op_EQ_80 = EQ(SEXTRACT64(CAST(64, IL_FALSE, op_RSHIFT_43), SN(32, 0), SN(32, 0x20)), op_RSHIFT_79);
	RzILOpPure *op_RSHIFT_118 = SHIFTRA(DUP(Rss), SN(32, 0x20));
	RzILOpPure *op_AND_120 = LOGAND(op_RSHIFT_118, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_131 = SHIFTRA(DUP(Rtt), SN(32, 0x30));
	RzILOpPure *op_AND_134 = LOGAND(op_RSHIFT_131, CAST(64, MSB(SN(32, 0xffff)), SN(32, 0xffff)));
	RzILOpPure *op_MUL_141 = MUL(CAST(64, MSB(CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(op_AND_120), DUP(op_AND_120))), CAST(32, MSB(DUP(op_AND_120)), DUP(op_AND_120)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_120)), DUP(op_AND_120))), CAST(32, MSB(DUP(op_AND_120)), DUP(op_AND_120))))), CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(DUP(op_AND_120)), DUP(op_AND_120))), CAST(32, MSB(DUP(op_AND_120)), DUP(op_AND_120)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_120)), DUP(op_AND_120))), CAST(32, MSB(DUP(op_AND_120)), DUP(op_AND_120))))), SEXTRACT64(CAST(64, IL_FALSE, CAST(16, MSB(op_AND_134), DUP(op_AND_134))), SN(32, 0), SN(32, 16)));
	RzILOpPure *op_LSHIFT_143 = SHIFTL0(op_MUL_141, SN(32, 1));
	RzILOpPure *op_RSHIFT_145 = SHIFTRA(op_LSHIFT_143, SN(32, 16));
	RzILOpPure *op_LT_148 = SLT(op_RSHIFT_145, CAST(64, MSB(SN(32, 0)), SN(32, 0)));
	RzILOpPure *op_LSHIFT_153 = SHIFTL0(SN(64, 1), SN(32, 31));
	RzILOpPure *op_NEG_154 = NEG(op_LSHIFT_153);
	RzILOpPure *op_LSHIFT_159 = SHIFTL0(SN(64, 1), SN(32, 31));
	RzILOpPure *op_SUB_162 = SUB(op_LSHIFT_159, CAST(64, MSB(SN(32, 1)), SN(32, 1)));
	RzILOpPure *cond_163 = ITE(op_LT_148, op_NEG_154, op_SUB_162);
	RzILOpEffect *gcc_expr_164 = BRANCH(op_EQ_80, EMPTY(), set_usr_field_call_114);

	// h_tmp306 = HYB(gcc_expr_if ((sextract64(((ut64) ((((st64) ((st32) ((st64) ((st32) ((Rss >> 0x20) & 0xffffffff))))) * sextract64(((ut64) ((st16) ((Rtt >> 0x30) & ((st64) 0xffff)))), 0x0, 0x10) << 0x1) >> 0x10)), 0x0, 0x20) == ((((st64) ((st32) ((st64) ((st32) ((Rss >> 0x20) & 0xffffffff))))) * sextract64(((ut64) ((st16) ((Rtt >> 0x30) & ((st64) 0xffff)))), 0x0, 0x10) << 0x1) >> 0x10))) {{}} else {set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, ((ut32) 0x1))}, ((((((st64) ((st32) ((st64) ((st32) ((Rss >> 0x20) & 0xffffffff))))) * sextract64(((ut64) ((st16) ((Rtt >> 0x30) & ((st64) 0xffff)))), 0x0, 0x10) << 0x1) >> 0x10) < ((st64) 0x0)) ? (-(0x1 << 0x1f)) : (0x1 << 0x1f) - ((st64) 0x1)));
	RzILOpEffect *op_ASSIGN_hybrid_tmp_166 = SETL("h_tmp306", cond_163);

	// seq(HYB(gcc_expr_if ((sextract64(((ut64) ((((st64) ((st32) ((st6 ...;
	RzILOpEffect *seq_167 = SEQN(2, gcc_expr_164, op_ASSIGN_hybrid_tmp_166);

	// Rdd = ((Rdd & (~(0xffffffff << 0x20))) | ((((sextract64(((ut64) ((((st64) ((st32) ((st64) ((st32) ((Rss >> 0x20) & 0xffffffff))))) * sextract64(((ut64) ((st16) ((Rtt >> 0x30) & ((st64) 0xffff)))), 0x0, 0x10) << 0x1) >> 0x10)), 0x0, 0x20) == ((((st64) ((st32) ((st64) ((st32) ((Rss >> 0x20) & 0xffffffff))))) * sextract64(((ut64) ((st16) ((Rtt >> 0x30) & ((st64) 0xffff)))), 0x0, 0x10) << 0x1) >> 0x10)) ? ((((st64) ((st32) ((st64) ((st32) ((Rss >> 0x20) & 0xffffffff))))) * sextract64(((ut64) ((st16) ((Rtt >> 0x30) & ((st64) 0xffff)))), 0x0, 0x10) << 0x1) >> 0x10) : h_tmp306) & 0xffffffff) << 0x20));
	RzILOpPure *op_LSHIFT_5 = SHIFTL0(SN(64, 0xffffffff), SN(32, 0x20));
	RzILOpPure *op_NOT_6 = LOGNOT(op_LSHIFT_5);
	RzILOpPure *op_AND_7 = LOGAND(READ_REG(pkt, Rdd_op, true), op_NOT_6);
	RzILOpPure *op_RSHIFT_84 = SHIFTRA(DUP(Rss), SN(32, 0x20));
	RzILOpPure *op_AND_86 = LOGAND(op_RSHIFT_84, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_97 = SHIFTRA(DUP(Rtt), SN(32, 0x30));
	RzILOpPure *op_AND_100 = LOGAND(op_RSHIFT_97, CAST(64, MSB(SN(32, 0xffff)), SN(32, 0xffff)));
	RzILOpPure *op_MUL_107 = MUL(CAST(64, MSB(CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(op_AND_86), DUP(op_AND_86))), CAST(32, MSB(DUP(op_AND_86)), DUP(op_AND_86)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_86)), DUP(op_AND_86))), CAST(32, MSB(DUP(op_AND_86)), DUP(op_AND_86))))), CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(DUP(op_AND_86)), DUP(op_AND_86))), CAST(32, MSB(DUP(op_AND_86)), DUP(op_AND_86)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_86)), DUP(op_AND_86))), CAST(32, MSB(DUP(op_AND_86)), DUP(op_AND_86))))), SEXTRACT64(CAST(64, IL_FALSE, CAST(16, MSB(op_AND_100), DUP(op_AND_100))), SN(32, 0), SN(32, 16)));
	RzILOpPure *op_LSHIFT_109 = SHIFTL0(op_MUL_107, SN(32, 1));
	RzILOpPure *op_RSHIFT_111 = SHIFTRA(op_LSHIFT_109, SN(32, 16));
	RzILOpPure *cond_168 = ITE(DUP(op_EQ_80), op_RSHIFT_111, VARL("h_tmp306"));
	RzILOpPure *op_AND_170 = LOGAND(cond_168, SN(64, 0xffffffff));
	RzILOpPure *op_LSHIFT_174 = SHIFTL0(op_AND_170, SN(32, 0x20));
	RzILOpPure *op_OR_175 = LOGOR(op_AND_7, op_LSHIFT_174);
	RzILOpEffect *op_ASSIGN_176 = WRITE_REG(bundle, Rdd_op, op_OR_175);

	// seq(seq(HYB(gcc_expr_if ((sextract64(((ut64) ((((st64) ((st32) ( ...;
	RzILOpEffect *seq_177 = SEQN(2, seq_167, op_ASSIGN_176);

	// set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, ((ut32) 0x1));
	RzILOpEffect *set_usr_field_call_290 = hex_set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, CAST(32, IL_FALSE, SN(32, 1)));

	// HYB(gcc_expr_if ((sextract64(((ut64) ((((st64) ((st32) ((st64) ((st32) ((Rss >> 0x0) & 0xffffffff))))) * sextract64(((ut64) ((st16) ((Rtt >> 0x10) & ((st64) 0xffff)))), 0x0, 0x10) << 0x1) >> 0x10)), 0x0, 0x20) == ((((st64) ((st32) ((st64) ((st32) ((Rss >> 0x0) & 0xffffffff))))) * sextract64(((ut64) ((st16) ((Rtt >> 0x10) & ((st64) 0xffff)))), 0x0, 0x10) << 0x1) >> 0x10))) {{}} else {set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, ((ut32) 0x1))}, ((((((st64) ((st32) ((st64) ((st32) ((Rss >> 0x0) & 0xffffffff))))) * sextract64(((ut64) ((st16) ((Rtt >> 0x10) & ((st64) 0xffff)))), 0x0, 0x10) << 0x1) >> 0x10) < ((st64) 0x0)) ? (-(0x1 << 0x1f)) : (0x1 << 0x1f) - ((st64) 0x1)));
	RzILOpPure *op_RSHIFT_192 = SHIFTRA(DUP(Rss), SN(32, 0));
	RzILOpPure *op_AND_194 = LOGAND(op_RSHIFT_192, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_205 = SHIFTRA(DUP(Rtt), SN(32, 16));
	RzILOpPure *op_AND_208 = LOGAND(op_RSHIFT_205, CAST(64, MSB(SN(32, 0xffff)), SN(32, 0xffff)));
	RzILOpPure *op_MUL_215 = MUL(CAST(64, MSB(CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(op_AND_194), DUP(op_AND_194))), CAST(32, MSB(DUP(op_AND_194)), DUP(op_AND_194)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_194)), DUP(op_AND_194))), CAST(32, MSB(DUP(op_AND_194)), DUP(op_AND_194))))), CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(DUP(op_AND_194)), DUP(op_AND_194))), CAST(32, MSB(DUP(op_AND_194)), DUP(op_AND_194)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_194)), DUP(op_AND_194))), CAST(32, MSB(DUP(op_AND_194)), DUP(op_AND_194))))), SEXTRACT64(CAST(64, IL_FALSE, CAST(16, MSB(op_AND_208), DUP(op_AND_208))), SN(32, 0), SN(32, 16)));
	RzILOpPure *op_LSHIFT_217 = SHIFTL0(op_MUL_215, SN(32, 1));
	RzILOpPure *op_RSHIFT_219 = SHIFTRA(op_LSHIFT_217, SN(32, 16));
	RzILOpPure *op_RSHIFT_228 = SHIFTRA(DUP(Rss), SN(32, 0));
	RzILOpPure *op_AND_230 = LOGAND(op_RSHIFT_228, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_241 = SHIFTRA(DUP(Rtt), SN(32, 16));
	RzILOpPure *op_AND_244 = LOGAND(op_RSHIFT_241, CAST(64, MSB(SN(32, 0xffff)), SN(32, 0xffff)));
	RzILOpPure *op_MUL_251 = MUL(CAST(64, MSB(CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(op_AND_230), DUP(op_AND_230))), CAST(32, MSB(DUP(op_AND_230)), DUP(op_AND_230)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_230)), DUP(op_AND_230))), CAST(32, MSB(DUP(op_AND_230)), DUP(op_AND_230))))), CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(DUP(op_AND_230)), DUP(op_AND_230))), CAST(32, MSB(DUP(op_AND_230)), DUP(op_AND_230)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_230)), DUP(op_AND_230))), CAST(32, MSB(DUP(op_AND_230)), DUP(op_AND_230))))), SEXTRACT64(CAST(64, IL_FALSE, CAST(16, MSB(op_AND_244), DUP(op_AND_244))), SN(32, 0), SN(32, 16)));
	RzILOpPure *op_LSHIFT_253 = SHIFTL0(op_MUL_251, SN(32, 1));
	RzILOpPure *op_RSHIFT_255 = SHIFTRA(op_LSHIFT_253, SN(32, 16));
	RzILOpPure *op_EQ_256 = EQ(SEXTRACT64(CAST(64, IL_FALSE, op_RSHIFT_219), SN(32, 0), SN(32, 0x20)), op_RSHIFT_255);
	RzILOpPure *op_RSHIFT_294 = SHIFTRA(DUP(Rss), SN(32, 0));
	RzILOpPure *op_AND_296 = LOGAND(op_RSHIFT_294, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_307 = SHIFTRA(DUP(Rtt), SN(32, 16));
	RzILOpPure *op_AND_310 = LOGAND(op_RSHIFT_307, CAST(64, MSB(SN(32, 0xffff)), SN(32, 0xffff)));
	RzILOpPure *op_MUL_317 = MUL(CAST(64, MSB(CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(op_AND_296), DUP(op_AND_296))), CAST(32, MSB(DUP(op_AND_296)), DUP(op_AND_296)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_296)), DUP(op_AND_296))), CAST(32, MSB(DUP(op_AND_296)), DUP(op_AND_296))))), CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(DUP(op_AND_296)), DUP(op_AND_296))), CAST(32, MSB(DUP(op_AND_296)), DUP(op_AND_296)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_296)), DUP(op_AND_296))), CAST(32, MSB(DUP(op_AND_296)), DUP(op_AND_296))))), SEXTRACT64(CAST(64, IL_FALSE, CAST(16, MSB(op_AND_310), DUP(op_AND_310))), SN(32, 0), SN(32, 16)));
	RzILOpPure *op_LSHIFT_319 = SHIFTL0(op_MUL_317, SN(32, 1));
	RzILOpPure *op_RSHIFT_321 = SHIFTRA(op_LSHIFT_319, SN(32, 16));
	RzILOpPure *op_LT_324 = SLT(op_RSHIFT_321, CAST(64, MSB(SN(32, 0)), SN(32, 0)));
	RzILOpPure *op_LSHIFT_329 = SHIFTL0(SN(64, 1), SN(32, 31));
	RzILOpPure *op_NEG_330 = NEG(op_LSHIFT_329);
	RzILOpPure *op_LSHIFT_335 = SHIFTL0(SN(64, 1), SN(32, 31));
	RzILOpPure *op_SUB_338 = SUB(op_LSHIFT_335, CAST(64, MSB(SN(32, 1)), SN(32, 1)));
	RzILOpPure *cond_339 = ITE(op_LT_324, op_NEG_330, op_SUB_338);
	RzILOpEffect *gcc_expr_340 = BRANCH(op_EQ_256, EMPTY(), set_usr_field_call_290);

	// h_tmp307 = HYB(gcc_expr_if ((sextract64(((ut64) ((((st64) ((st32) ((st64) ((st32) ((Rss >> 0x0) & 0xffffffff))))) * sextract64(((ut64) ((st16) ((Rtt >> 0x10) & ((st64) 0xffff)))), 0x0, 0x10) << 0x1) >> 0x10)), 0x0, 0x20) == ((((st64) ((st32) ((st64) ((st32) ((Rss >> 0x0) & 0xffffffff))))) * sextract64(((ut64) ((st16) ((Rtt >> 0x10) & ((st64) 0xffff)))), 0x0, 0x10) << 0x1) >> 0x10))) {{}} else {set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, ((ut32) 0x1))}, ((((((st64) ((st32) ((st64) ((st32) ((Rss >> 0x0) & 0xffffffff))))) * sextract64(((ut64) ((st16) ((Rtt >> 0x10) & ((st64) 0xffff)))), 0x0, 0x10) << 0x1) >> 0x10) < ((st64) 0x0)) ? (-(0x1 << 0x1f)) : (0x1 << 0x1f) - ((st64) 0x1)));
	RzILOpEffect *op_ASSIGN_hybrid_tmp_342 = SETL("h_tmp307", cond_339);

	// seq(HYB(gcc_expr_if ((sextract64(((ut64) ((((st64) ((st32) ((st6 ...;
	RzILOpEffect *seq_343 = SEQN(2, gcc_expr_340, op_ASSIGN_hybrid_tmp_342);

	// Rdd = ((Rdd & (~(0xffffffff << 0x0))) | ((((sextract64(((ut64) ((((st64) ((st32) ((st64) ((st32) ((Rss >> 0x0) & 0xffffffff))))) * sextract64(((ut64) ((st16) ((Rtt >> 0x10) & ((st64) 0xffff)))), 0x0, 0x10) << 0x1) >> 0x10)), 0x0, 0x20) == ((((st64) ((st32) ((st64) ((st32) ((Rss >> 0x0) & 0xffffffff))))) * sextract64(((ut64) ((st16) ((Rtt >> 0x10) & ((st64) 0xffff)))), 0x0, 0x10) << 0x1) >> 0x10)) ? ((((st64) ((st32) ((st64) ((st32) ((Rss >> 0x0) & 0xffffffff))))) * sextract64(((ut64) ((st16) ((Rtt >> 0x10) & ((st64) 0xffff)))), 0x0, 0x10) << 0x1) >> 0x10) : h_tmp307) & 0xffffffff) << 0x0));
	RzILOpPure *op_LSHIFT_183 = SHIFTL0(SN(64, 0xffffffff), SN(32, 0));
	RzILOpPure *op_NOT_184 = LOGNOT(op_LSHIFT_183);
	RzILOpPure *op_AND_185 = LOGAND(READ_REG(pkt, Rdd_op, true), op_NOT_184);
	RzILOpPure *op_RSHIFT_260 = SHIFTRA(DUP(Rss), SN(32, 0));
	RzILOpPure *op_AND_262 = LOGAND(op_RSHIFT_260, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_273 = SHIFTRA(DUP(Rtt), SN(32, 16));
	RzILOpPure *op_AND_276 = LOGAND(op_RSHIFT_273, CAST(64, MSB(SN(32, 0xffff)), SN(32, 0xffff)));
	RzILOpPure *op_MUL_283 = MUL(CAST(64, MSB(CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(op_AND_262), DUP(op_AND_262))), CAST(32, MSB(DUP(op_AND_262)), DUP(op_AND_262)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_262)), DUP(op_AND_262))), CAST(32, MSB(DUP(op_AND_262)), DUP(op_AND_262))))), CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(DUP(op_AND_262)), DUP(op_AND_262))), CAST(32, MSB(DUP(op_AND_262)), DUP(op_AND_262)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_262)), DUP(op_AND_262))), CAST(32, MSB(DUP(op_AND_262)), DUP(op_AND_262))))), SEXTRACT64(CAST(64, IL_FALSE, CAST(16, MSB(op_AND_276), DUP(op_AND_276))), SN(32, 0), SN(32, 16)));
	RzILOpPure *op_LSHIFT_285 = SHIFTL0(op_MUL_283, SN(32, 1));
	RzILOpPure *op_RSHIFT_287 = SHIFTRA(op_LSHIFT_285, SN(32, 16));
	RzILOpPure *cond_344 = ITE(DUP(op_EQ_256), op_RSHIFT_287, VARL("h_tmp307"));
	RzILOpPure *op_AND_346 = LOGAND(cond_344, SN(64, 0xffffffff));
	RzILOpPure *op_LSHIFT_350 = SHIFTL0(op_AND_346, SN(32, 0));
	RzILOpPure *op_OR_351 = LOGOR(op_AND_185, op_LSHIFT_350);
	RzILOpEffect *op_ASSIGN_352 = WRITE_REG(bundle, Rdd_op, op_OR_351);

	// seq(seq(HYB(gcc_expr_if ((sextract64(((ut64) ((((st64) ((st32) ( ...;
	RzILOpEffect *seq_353 = SEQN(2, seq_343, op_ASSIGN_352);

	RzILOpEffect *instruction_sequence = SEQN(2, seq_177, seq_353);
	return instruction_sequence;
}

// Rdd = vmpyweh(Rss,Rtt):rnd:sat
RzILOpEffect *hex_il_op_m2_mmpyl_rs0(HexInsnPktBundle *bundle) {
	const HexInsn *hi = bundle->insn;
	HexPkt *pkt = bundle->pkt;
	// READ
	const HexOp *Rdd_op = ISA2REG(hi, 'd', false);
	const HexOp *Rss_op = ISA2REG(hi, 's', false);
	RzILOpPure *Rss = READ_REG(pkt, Rss_op, false);
	const HexOp *Rtt_op = ISA2REG(hi, 't', false);
	RzILOpPure *Rtt = READ_REG(pkt, Rtt_op, false);

	// set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, ((ut32) 0x1));
	RzILOpEffect *set_usr_field_call_123 = hex_set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, CAST(32, IL_FALSE, SN(32, 1)));

	// HYB(gcc_expr_if ((sextract64(((ut64) ((((st64) ((st32) ((st64) ((st32) ((Rss >> 0x20) & 0xffffffff))))) * sextract64(((ut64) ((st16) ((Rtt >> 0x20) & ((st64) 0xffff)))), 0x0, 0x10) << 0x0) + ((st64) 0x8000) >> 0x10)), 0x0, 0x20) == ((((st64) ((st32) ((st64) ((st32) ((Rss >> 0x20) & 0xffffffff))))) * sextract64(((ut64) ((st16) ((Rtt >> 0x20) & ((st64) 0xffff)))), 0x0, 0x10) << 0x0) + ((st64) 0x8000) >> 0x10))) {{}} else {set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, ((ut32) 0x1))}, ((((((st64) ((st32) ((st64) ((st32) ((Rss >> 0x20) & 0xffffffff))))) * sextract64(((ut64) ((st16) ((Rtt >> 0x20) & ((st64) 0xffff)))), 0x0, 0x10) << 0x0) + ((st64) 0x8000) >> 0x10) < ((st64) 0x0)) ? (-(0x1 << 0x1f)) : (0x1 << 0x1f) - ((st64) 0x1)));
	RzILOpPure *op_RSHIFT_15 = SHIFTRA(Rss, SN(32, 0x20));
	RzILOpPure *op_AND_17 = LOGAND(op_RSHIFT_15, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_29 = SHIFTRA(Rtt, SN(32, 0x20));
	RzILOpPure *op_AND_32 = LOGAND(op_RSHIFT_29, CAST(64, MSB(SN(32, 0xffff)), SN(32, 0xffff)));
	RzILOpPure *op_MUL_39 = MUL(CAST(64, MSB(CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(op_AND_17), DUP(op_AND_17))), CAST(32, MSB(DUP(op_AND_17)), DUP(op_AND_17)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_17)), DUP(op_AND_17))), CAST(32, MSB(DUP(op_AND_17)), DUP(op_AND_17))))), CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(DUP(op_AND_17)), DUP(op_AND_17))), CAST(32, MSB(DUP(op_AND_17)), DUP(op_AND_17)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_17)), DUP(op_AND_17))), CAST(32, MSB(DUP(op_AND_17)), DUP(op_AND_17))))), SEXTRACT64(CAST(64, IL_FALSE, CAST(16, MSB(op_AND_32), DUP(op_AND_32))), SN(32, 0), SN(32, 16)));
	RzILOpPure *op_LSHIFT_41 = SHIFTL0(op_MUL_39, SN(32, 0));
	RzILOpPure *op_ADD_44 = ADD(op_LSHIFT_41, CAST(64, MSB(SN(32, 0x8000)), SN(32, 0x8000)));
	RzILOpPure *op_RSHIFT_46 = SHIFTRA(op_ADD_44, SN(32, 16));
	RzILOpPure *op_RSHIFT_55 = SHIFTRA(DUP(Rss), SN(32, 0x20));
	RzILOpPure *op_AND_57 = LOGAND(op_RSHIFT_55, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_68 = SHIFTRA(DUP(Rtt), SN(32, 0x20));
	RzILOpPure *op_AND_71 = LOGAND(op_RSHIFT_68, CAST(64, MSB(SN(32, 0xffff)), SN(32, 0xffff)));
	RzILOpPure *op_MUL_78 = MUL(CAST(64, MSB(CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(op_AND_57), DUP(op_AND_57))), CAST(32, MSB(DUP(op_AND_57)), DUP(op_AND_57)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_57)), DUP(op_AND_57))), CAST(32, MSB(DUP(op_AND_57)), DUP(op_AND_57))))), CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(DUP(op_AND_57)), DUP(op_AND_57))), CAST(32, MSB(DUP(op_AND_57)), DUP(op_AND_57)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_57)), DUP(op_AND_57))), CAST(32, MSB(DUP(op_AND_57)), DUP(op_AND_57))))), SEXTRACT64(CAST(64, IL_FALSE, CAST(16, MSB(op_AND_71), DUP(op_AND_71))), SN(32, 0), SN(32, 16)));
	RzILOpPure *op_LSHIFT_80 = SHIFTL0(op_MUL_78, SN(32, 0));
	RzILOpPure *op_ADD_83 = ADD(op_LSHIFT_80, CAST(64, MSB(SN(32, 0x8000)), SN(32, 0x8000)));
	RzILOpPure *op_RSHIFT_85 = SHIFTRA(op_ADD_83, SN(32, 16));
	RzILOpPure *op_EQ_86 = EQ(SEXTRACT64(CAST(64, IL_FALSE, op_RSHIFT_46), SN(32, 0), SN(32, 0x20)), op_RSHIFT_85);
	RzILOpPure *op_RSHIFT_127 = SHIFTRA(DUP(Rss), SN(32, 0x20));
	RzILOpPure *op_AND_129 = LOGAND(op_RSHIFT_127, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_140 = SHIFTRA(DUP(Rtt), SN(32, 0x20));
	RzILOpPure *op_AND_143 = LOGAND(op_RSHIFT_140, CAST(64, MSB(SN(32, 0xffff)), SN(32, 0xffff)));
	RzILOpPure *op_MUL_150 = MUL(CAST(64, MSB(CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(op_AND_129), DUP(op_AND_129))), CAST(32, MSB(DUP(op_AND_129)), DUP(op_AND_129)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_129)), DUP(op_AND_129))), CAST(32, MSB(DUP(op_AND_129)), DUP(op_AND_129))))), CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(DUP(op_AND_129)), DUP(op_AND_129))), CAST(32, MSB(DUP(op_AND_129)), DUP(op_AND_129)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_129)), DUP(op_AND_129))), CAST(32, MSB(DUP(op_AND_129)), DUP(op_AND_129))))), SEXTRACT64(CAST(64, IL_FALSE, CAST(16, MSB(op_AND_143), DUP(op_AND_143))), SN(32, 0), SN(32, 16)));
	RzILOpPure *op_LSHIFT_152 = SHIFTL0(op_MUL_150, SN(32, 0));
	RzILOpPure *op_ADD_155 = ADD(op_LSHIFT_152, CAST(64, MSB(SN(32, 0x8000)), SN(32, 0x8000)));
	RzILOpPure *op_RSHIFT_157 = SHIFTRA(op_ADD_155, SN(32, 16));
	RzILOpPure *op_LT_160 = SLT(op_RSHIFT_157, CAST(64, MSB(SN(32, 0)), SN(32, 0)));
	RzILOpPure *op_LSHIFT_165 = SHIFTL0(SN(64, 1), SN(32, 31));
	RzILOpPure *op_NEG_166 = NEG(op_LSHIFT_165);
	RzILOpPure *op_LSHIFT_171 = SHIFTL0(SN(64, 1), SN(32, 31));
	RzILOpPure *op_SUB_174 = SUB(op_LSHIFT_171, CAST(64, MSB(SN(32, 1)), SN(32, 1)));
	RzILOpPure *cond_175 = ITE(op_LT_160, op_NEG_166, op_SUB_174);
	RzILOpEffect *gcc_expr_176 = BRANCH(op_EQ_86, EMPTY(), set_usr_field_call_123);

	// h_tmp308 = HYB(gcc_expr_if ((sextract64(((ut64) ((((st64) ((st32) ((st64) ((st32) ((Rss >> 0x20) & 0xffffffff))))) * sextract64(((ut64) ((st16) ((Rtt >> 0x20) & ((st64) 0xffff)))), 0x0, 0x10) << 0x0) + ((st64) 0x8000) >> 0x10)), 0x0, 0x20) == ((((st64) ((st32) ((st64) ((st32) ((Rss >> 0x20) & 0xffffffff))))) * sextract64(((ut64) ((st16) ((Rtt >> 0x20) & ((st64) 0xffff)))), 0x0, 0x10) << 0x0) + ((st64) 0x8000) >> 0x10))) {{}} else {set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, ((ut32) 0x1))}, ((((((st64) ((st32) ((st64) ((st32) ((Rss >> 0x20) & 0xffffffff))))) * sextract64(((ut64) ((st16) ((Rtt >> 0x20) & ((st64) 0xffff)))), 0x0, 0x10) << 0x0) + ((st64) 0x8000) >> 0x10) < ((st64) 0x0)) ? (-(0x1 << 0x1f)) : (0x1 << 0x1f) - ((st64) 0x1)));
	RzILOpEffect *op_ASSIGN_hybrid_tmp_178 = SETL("h_tmp308", cond_175);

	// seq(HYB(gcc_expr_if ((sextract64(((ut64) ((((st64) ((st32) ((st6 ...;
	RzILOpEffect *seq_179 = SEQN(2, gcc_expr_176, op_ASSIGN_hybrid_tmp_178);

	// Rdd = ((Rdd & (~(0xffffffff << 0x20))) | ((((sextract64(((ut64) ((((st64) ((st32) ((st64) ((st32) ((Rss >> 0x20) & 0xffffffff))))) * sextract64(((ut64) ((st16) ((Rtt >> 0x20) & ((st64) 0xffff)))), 0x0, 0x10) << 0x0) + ((st64) 0x8000) >> 0x10)), 0x0, 0x20) == ((((st64) ((st32) ((st64) ((st32) ((Rss >> 0x20) & 0xffffffff))))) * sextract64(((ut64) ((st16) ((Rtt >> 0x20) & ((st64) 0xffff)))), 0x0, 0x10) << 0x0) + ((st64) 0x8000) >> 0x10)) ? ((((st64) ((st32) ((st64) ((st32) ((Rss >> 0x20) & 0xffffffff))))) * sextract64(((ut64) ((st16) ((Rtt >> 0x20) & ((st64) 0xffff)))), 0x0, 0x10) << 0x0) + ((st64) 0x8000) >> 0x10) : h_tmp308) & 0xffffffff) << 0x20));
	RzILOpPure *op_LSHIFT_5 = SHIFTL0(SN(64, 0xffffffff), SN(32, 0x20));
	RzILOpPure *op_NOT_6 = LOGNOT(op_LSHIFT_5);
	RzILOpPure *op_AND_7 = LOGAND(READ_REG(pkt, Rdd_op, true), op_NOT_6);
	RzILOpPure *op_RSHIFT_90 = SHIFTRA(DUP(Rss), SN(32, 0x20));
	RzILOpPure *op_AND_92 = LOGAND(op_RSHIFT_90, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_103 = SHIFTRA(DUP(Rtt), SN(32, 0x20));
	RzILOpPure *op_AND_106 = LOGAND(op_RSHIFT_103, CAST(64, MSB(SN(32, 0xffff)), SN(32, 0xffff)));
	RzILOpPure *op_MUL_113 = MUL(CAST(64, MSB(CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(op_AND_92), DUP(op_AND_92))), CAST(32, MSB(DUP(op_AND_92)), DUP(op_AND_92)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_92)), DUP(op_AND_92))), CAST(32, MSB(DUP(op_AND_92)), DUP(op_AND_92))))), CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(DUP(op_AND_92)), DUP(op_AND_92))), CAST(32, MSB(DUP(op_AND_92)), DUP(op_AND_92)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_92)), DUP(op_AND_92))), CAST(32, MSB(DUP(op_AND_92)), DUP(op_AND_92))))), SEXTRACT64(CAST(64, IL_FALSE, CAST(16, MSB(op_AND_106), DUP(op_AND_106))), SN(32, 0), SN(32, 16)));
	RzILOpPure *op_LSHIFT_115 = SHIFTL0(op_MUL_113, SN(32, 0));
	RzILOpPure *op_ADD_118 = ADD(op_LSHIFT_115, CAST(64, MSB(SN(32, 0x8000)), SN(32, 0x8000)));
	RzILOpPure *op_RSHIFT_120 = SHIFTRA(op_ADD_118, SN(32, 16));
	RzILOpPure *cond_180 = ITE(DUP(op_EQ_86), op_RSHIFT_120, VARL("h_tmp308"));
	RzILOpPure *op_AND_182 = LOGAND(cond_180, SN(64, 0xffffffff));
	RzILOpPure *op_LSHIFT_186 = SHIFTL0(op_AND_182, SN(32, 0x20));
	RzILOpPure *op_OR_187 = LOGOR(op_AND_7, op_LSHIFT_186);
	RzILOpEffect *op_ASSIGN_188 = WRITE_REG(bundle, Rdd_op, op_OR_187);

	// seq(seq(HYB(gcc_expr_if ((sextract64(((ut64) ((((st64) ((st32) ( ...;
	RzILOpEffect *seq_189 = SEQN(2, seq_179, op_ASSIGN_188);

	// set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, ((ut32) 0x1));
	RzILOpEffect *set_usr_field_call_311 = hex_set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, CAST(32, IL_FALSE, SN(32, 1)));

	// HYB(gcc_expr_if ((sextract64(((ut64) ((((st64) ((st32) ((st64) ((st32) ((Rss >> 0x0) & 0xffffffff))))) * sextract64(((ut64) ((st16) ((Rtt >> 0x0) & ((st64) 0xffff)))), 0x0, 0x10) << 0x0) + ((st64) 0x8000) >> 0x10)), 0x0, 0x20) == ((((st64) ((st32) ((st64) ((st32) ((Rss >> 0x0) & 0xffffffff))))) * sextract64(((ut64) ((st16) ((Rtt >> 0x0) & ((st64) 0xffff)))), 0x0, 0x10) << 0x0) + ((st64) 0x8000) >> 0x10))) {{}} else {set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, ((ut32) 0x1))}, ((((((st64) ((st32) ((st64) ((st32) ((Rss >> 0x0) & 0xffffffff))))) * sextract64(((ut64) ((st16) ((Rtt >> 0x0) & ((st64) 0xffff)))), 0x0, 0x10) << 0x0) + ((st64) 0x8000) >> 0x10) < ((st64) 0x0)) ? (-(0x1 << 0x1f)) : (0x1 << 0x1f) - ((st64) 0x1)));
	RzILOpPure *op_RSHIFT_204 = SHIFTRA(DUP(Rss), SN(32, 0));
	RzILOpPure *op_AND_206 = LOGAND(op_RSHIFT_204, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_217 = SHIFTRA(DUP(Rtt), SN(32, 0));
	RzILOpPure *op_AND_220 = LOGAND(op_RSHIFT_217, CAST(64, MSB(SN(32, 0xffff)), SN(32, 0xffff)));
	RzILOpPure *op_MUL_227 = MUL(CAST(64, MSB(CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(op_AND_206), DUP(op_AND_206))), CAST(32, MSB(DUP(op_AND_206)), DUP(op_AND_206)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_206)), DUP(op_AND_206))), CAST(32, MSB(DUP(op_AND_206)), DUP(op_AND_206))))), CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(DUP(op_AND_206)), DUP(op_AND_206))), CAST(32, MSB(DUP(op_AND_206)), DUP(op_AND_206)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_206)), DUP(op_AND_206))), CAST(32, MSB(DUP(op_AND_206)), DUP(op_AND_206))))), SEXTRACT64(CAST(64, IL_FALSE, CAST(16, MSB(op_AND_220), DUP(op_AND_220))), SN(32, 0), SN(32, 16)));
	RzILOpPure *op_LSHIFT_229 = SHIFTL0(op_MUL_227, SN(32, 0));
	RzILOpPure *op_ADD_232 = ADD(op_LSHIFT_229, CAST(64, MSB(SN(32, 0x8000)), SN(32, 0x8000)));
	RzILOpPure *op_RSHIFT_234 = SHIFTRA(op_ADD_232, SN(32, 16));
	RzILOpPure *op_RSHIFT_243 = SHIFTRA(DUP(Rss), SN(32, 0));
	RzILOpPure *op_AND_245 = LOGAND(op_RSHIFT_243, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_256 = SHIFTRA(DUP(Rtt), SN(32, 0));
	RzILOpPure *op_AND_259 = LOGAND(op_RSHIFT_256, CAST(64, MSB(SN(32, 0xffff)), SN(32, 0xffff)));
	RzILOpPure *op_MUL_266 = MUL(CAST(64, MSB(CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(op_AND_245), DUP(op_AND_245))), CAST(32, MSB(DUP(op_AND_245)), DUP(op_AND_245)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_245)), DUP(op_AND_245))), CAST(32, MSB(DUP(op_AND_245)), DUP(op_AND_245))))), CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(DUP(op_AND_245)), DUP(op_AND_245))), CAST(32, MSB(DUP(op_AND_245)), DUP(op_AND_245)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_245)), DUP(op_AND_245))), CAST(32, MSB(DUP(op_AND_245)), DUP(op_AND_245))))), SEXTRACT64(CAST(64, IL_FALSE, CAST(16, MSB(op_AND_259), DUP(op_AND_259))), SN(32, 0), SN(32, 16)));
	RzILOpPure *op_LSHIFT_268 = SHIFTL0(op_MUL_266, SN(32, 0));
	RzILOpPure *op_ADD_271 = ADD(op_LSHIFT_268, CAST(64, MSB(SN(32, 0x8000)), SN(32, 0x8000)));
	RzILOpPure *op_RSHIFT_273 = SHIFTRA(op_ADD_271, SN(32, 16));
	RzILOpPure *op_EQ_274 = EQ(SEXTRACT64(CAST(64, IL_FALSE, op_RSHIFT_234), SN(32, 0), SN(32, 0x20)), op_RSHIFT_273);
	RzILOpPure *op_RSHIFT_315 = SHIFTRA(DUP(Rss), SN(32, 0));
	RzILOpPure *op_AND_317 = LOGAND(op_RSHIFT_315, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_328 = SHIFTRA(DUP(Rtt), SN(32, 0));
	RzILOpPure *op_AND_331 = LOGAND(op_RSHIFT_328, CAST(64, MSB(SN(32, 0xffff)), SN(32, 0xffff)));
	RzILOpPure *op_MUL_338 = MUL(CAST(64, MSB(CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(op_AND_317), DUP(op_AND_317))), CAST(32, MSB(DUP(op_AND_317)), DUP(op_AND_317)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_317)), DUP(op_AND_317))), CAST(32, MSB(DUP(op_AND_317)), DUP(op_AND_317))))), CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(DUP(op_AND_317)), DUP(op_AND_317))), CAST(32, MSB(DUP(op_AND_317)), DUP(op_AND_317)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_317)), DUP(op_AND_317))), CAST(32, MSB(DUP(op_AND_317)), DUP(op_AND_317))))), SEXTRACT64(CAST(64, IL_FALSE, CAST(16, MSB(op_AND_331), DUP(op_AND_331))), SN(32, 0), SN(32, 16)));
	RzILOpPure *op_LSHIFT_340 = SHIFTL0(op_MUL_338, SN(32, 0));
	RzILOpPure *op_ADD_343 = ADD(op_LSHIFT_340, CAST(64, MSB(SN(32, 0x8000)), SN(32, 0x8000)));
	RzILOpPure *op_RSHIFT_345 = SHIFTRA(op_ADD_343, SN(32, 16));
	RzILOpPure *op_LT_348 = SLT(op_RSHIFT_345, CAST(64, MSB(SN(32, 0)), SN(32, 0)));
	RzILOpPure *op_LSHIFT_353 = SHIFTL0(SN(64, 1), SN(32, 31));
	RzILOpPure *op_NEG_354 = NEG(op_LSHIFT_353);
	RzILOpPure *op_LSHIFT_359 = SHIFTL0(SN(64, 1), SN(32, 31));
	RzILOpPure *op_SUB_362 = SUB(op_LSHIFT_359, CAST(64, MSB(SN(32, 1)), SN(32, 1)));
	RzILOpPure *cond_363 = ITE(op_LT_348, op_NEG_354, op_SUB_362);
	RzILOpEffect *gcc_expr_364 = BRANCH(op_EQ_274, EMPTY(), set_usr_field_call_311);

	// h_tmp309 = HYB(gcc_expr_if ((sextract64(((ut64) ((((st64) ((st32) ((st64) ((st32) ((Rss >> 0x0) & 0xffffffff))))) * sextract64(((ut64) ((st16) ((Rtt >> 0x0) & ((st64) 0xffff)))), 0x0, 0x10) << 0x0) + ((st64) 0x8000) >> 0x10)), 0x0, 0x20) == ((((st64) ((st32) ((st64) ((st32) ((Rss >> 0x0) & 0xffffffff))))) * sextract64(((ut64) ((st16) ((Rtt >> 0x0) & ((st64) 0xffff)))), 0x0, 0x10) << 0x0) + ((st64) 0x8000) >> 0x10))) {{}} else {set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, ((ut32) 0x1))}, ((((((st64) ((st32) ((st64) ((st32) ((Rss >> 0x0) & 0xffffffff))))) * sextract64(((ut64) ((st16) ((Rtt >> 0x0) & ((st64) 0xffff)))), 0x0, 0x10) << 0x0) + ((st64) 0x8000) >> 0x10) < ((st64) 0x0)) ? (-(0x1 << 0x1f)) : (0x1 << 0x1f) - ((st64) 0x1)));
	RzILOpEffect *op_ASSIGN_hybrid_tmp_366 = SETL("h_tmp309", cond_363);

	// seq(HYB(gcc_expr_if ((sextract64(((ut64) ((((st64) ((st32) ((st6 ...;
	RzILOpEffect *seq_367 = SEQN(2, gcc_expr_364, op_ASSIGN_hybrid_tmp_366);

	// Rdd = ((Rdd & (~(0xffffffff << 0x0))) | ((((sextract64(((ut64) ((((st64) ((st32) ((st64) ((st32) ((Rss >> 0x0) & 0xffffffff))))) * sextract64(((ut64) ((st16) ((Rtt >> 0x0) & ((st64) 0xffff)))), 0x0, 0x10) << 0x0) + ((st64) 0x8000) >> 0x10)), 0x0, 0x20) == ((((st64) ((st32) ((st64) ((st32) ((Rss >> 0x0) & 0xffffffff))))) * sextract64(((ut64) ((st16) ((Rtt >> 0x0) & ((st64) 0xffff)))), 0x0, 0x10) << 0x0) + ((st64) 0x8000) >> 0x10)) ? ((((st64) ((st32) ((st64) ((st32) ((Rss >> 0x0) & 0xffffffff))))) * sextract64(((ut64) ((st16) ((Rtt >> 0x0) & ((st64) 0xffff)))), 0x0, 0x10) << 0x0) + ((st64) 0x8000) >> 0x10) : h_tmp309) & 0xffffffff) << 0x0));
	RzILOpPure *op_LSHIFT_195 = SHIFTL0(SN(64, 0xffffffff), SN(32, 0));
	RzILOpPure *op_NOT_196 = LOGNOT(op_LSHIFT_195);
	RzILOpPure *op_AND_197 = LOGAND(READ_REG(pkt, Rdd_op, true), op_NOT_196);
	RzILOpPure *op_RSHIFT_278 = SHIFTRA(DUP(Rss), SN(32, 0));
	RzILOpPure *op_AND_280 = LOGAND(op_RSHIFT_278, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_291 = SHIFTRA(DUP(Rtt), SN(32, 0));
	RzILOpPure *op_AND_294 = LOGAND(op_RSHIFT_291, CAST(64, MSB(SN(32, 0xffff)), SN(32, 0xffff)));
	RzILOpPure *op_MUL_301 = MUL(CAST(64, MSB(CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(op_AND_280), DUP(op_AND_280))), CAST(32, MSB(DUP(op_AND_280)), DUP(op_AND_280)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_280)), DUP(op_AND_280))), CAST(32, MSB(DUP(op_AND_280)), DUP(op_AND_280))))), CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(DUP(op_AND_280)), DUP(op_AND_280))), CAST(32, MSB(DUP(op_AND_280)), DUP(op_AND_280)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_280)), DUP(op_AND_280))), CAST(32, MSB(DUP(op_AND_280)), DUP(op_AND_280))))), SEXTRACT64(CAST(64, IL_FALSE, CAST(16, MSB(op_AND_294), DUP(op_AND_294))), SN(32, 0), SN(32, 16)));
	RzILOpPure *op_LSHIFT_303 = SHIFTL0(op_MUL_301, SN(32, 0));
	RzILOpPure *op_ADD_306 = ADD(op_LSHIFT_303, CAST(64, MSB(SN(32, 0x8000)), SN(32, 0x8000)));
	RzILOpPure *op_RSHIFT_308 = SHIFTRA(op_ADD_306, SN(32, 16));
	RzILOpPure *cond_368 = ITE(DUP(op_EQ_274), op_RSHIFT_308, VARL("h_tmp309"));
	RzILOpPure *op_AND_370 = LOGAND(cond_368, SN(64, 0xffffffff));
	RzILOpPure *op_LSHIFT_374 = SHIFTL0(op_AND_370, SN(32, 0));
	RzILOpPure *op_OR_375 = LOGOR(op_AND_197, op_LSHIFT_374);
	RzILOpEffect *op_ASSIGN_376 = WRITE_REG(bundle, Rdd_op, op_OR_375);

	// seq(seq(HYB(gcc_expr_if ((sextract64(((ut64) ((((st64) ((st32) ( ...;
	RzILOpEffect *seq_377 = SEQN(2, seq_367, op_ASSIGN_376);

	RzILOpEffect *instruction_sequence = SEQN(2, seq_189, seq_377);
	return instruction_sequence;
}

// Rdd = vmpyweh(Rss,Rtt):<<1:rnd:sat
RzILOpEffect *hex_il_op_m2_mmpyl_rs1(HexInsnPktBundle *bundle) {
	const HexInsn *hi = bundle->insn;
	HexPkt *pkt = bundle->pkt;
	// READ
	const HexOp *Rdd_op = ISA2REG(hi, 'd', false);
	const HexOp *Rss_op = ISA2REG(hi, 's', false);
	RzILOpPure *Rss = READ_REG(pkt, Rss_op, false);
	const HexOp *Rtt_op = ISA2REG(hi, 't', false);
	RzILOpPure *Rtt = READ_REG(pkt, Rtt_op, false);

	// set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, ((ut32) 0x1));
	RzILOpEffect *set_usr_field_call_123 = hex_set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, CAST(32, IL_FALSE, SN(32, 1)));

	// HYB(gcc_expr_if ((sextract64(((ut64) ((((st64) ((st32) ((st64) ((st32) ((Rss >> 0x20) & 0xffffffff))))) * sextract64(((ut64) ((st16) ((Rtt >> 0x20) & ((st64) 0xffff)))), 0x0, 0x10) << 0x1) + ((st64) 0x8000) >> 0x10)), 0x0, 0x20) == ((((st64) ((st32) ((st64) ((st32) ((Rss >> 0x20) & 0xffffffff))))) * sextract64(((ut64) ((st16) ((Rtt >> 0x20) & ((st64) 0xffff)))), 0x0, 0x10) << 0x1) + ((st64) 0x8000) >> 0x10))) {{}} else {set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, ((ut32) 0x1))}, ((((((st64) ((st32) ((st64) ((st32) ((Rss >> 0x20) & 0xffffffff))))) * sextract64(((ut64) ((st16) ((Rtt >> 0x20) & ((st64) 0xffff)))), 0x0, 0x10) << 0x1) + ((st64) 0x8000) >> 0x10) < ((st64) 0x0)) ? (-(0x1 << 0x1f)) : (0x1 << 0x1f) - ((st64) 0x1)));
	RzILOpPure *op_RSHIFT_15 = SHIFTRA(Rss, SN(32, 0x20));
	RzILOpPure *op_AND_17 = LOGAND(op_RSHIFT_15, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_29 = SHIFTRA(Rtt, SN(32, 0x20));
	RzILOpPure *op_AND_32 = LOGAND(op_RSHIFT_29, CAST(64, MSB(SN(32, 0xffff)), SN(32, 0xffff)));
	RzILOpPure *op_MUL_39 = MUL(CAST(64, MSB(CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(op_AND_17), DUP(op_AND_17))), CAST(32, MSB(DUP(op_AND_17)), DUP(op_AND_17)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_17)), DUP(op_AND_17))), CAST(32, MSB(DUP(op_AND_17)), DUP(op_AND_17))))), CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(DUP(op_AND_17)), DUP(op_AND_17))), CAST(32, MSB(DUP(op_AND_17)), DUP(op_AND_17)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_17)), DUP(op_AND_17))), CAST(32, MSB(DUP(op_AND_17)), DUP(op_AND_17))))), SEXTRACT64(CAST(64, IL_FALSE, CAST(16, MSB(op_AND_32), DUP(op_AND_32))), SN(32, 0), SN(32, 16)));
	RzILOpPure *op_LSHIFT_41 = SHIFTL0(op_MUL_39, SN(32, 1));
	RzILOpPure *op_ADD_44 = ADD(op_LSHIFT_41, CAST(64, MSB(SN(32, 0x8000)), SN(32, 0x8000)));
	RzILOpPure *op_RSHIFT_46 = SHIFTRA(op_ADD_44, SN(32, 16));
	RzILOpPure *op_RSHIFT_55 = SHIFTRA(DUP(Rss), SN(32, 0x20));
	RzILOpPure *op_AND_57 = LOGAND(op_RSHIFT_55, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_68 = SHIFTRA(DUP(Rtt), SN(32, 0x20));
	RzILOpPure *op_AND_71 = LOGAND(op_RSHIFT_68, CAST(64, MSB(SN(32, 0xffff)), SN(32, 0xffff)));
	RzILOpPure *op_MUL_78 = MUL(CAST(64, MSB(CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(op_AND_57), DUP(op_AND_57))), CAST(32, MSB(DUP(op_AND_57)), DUP(op_AND_57)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_57)), DUP(op_AND_57))), CAST(32, MSB(DUP(op_AND_57)), DUP(op_AND_57))))), CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(DUP(op_AND_57)), DUP(op_AND_57))), CAST(32, MSB(DUP(op_AND_57)), DUP(op_AND_57)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_57)), DUP(op_AND_57))), CAST(32, MSB(DUP(op_AND_57)), DUP(op_AND_57))))), SEXTRACT64(CAST(64, IL_FALSE, CAST(16, MSB(op_AND_71), DUP(op_AND_71))), SN(32, 0), SN(32, 16)));
	RzILOpPure *op_LSHIFT_80 = SHIFTL0(op_MUL_78, SN(32, 1));
	RzILOpPure *op_ADD_83 = ADD(op_LSHIFT_80, CAST(64, MSB(SN(32, 0x8000)), SN(32, 0x8000)));
	RzILOpPure *op_RSHIFT_85 = SHIFTRA(op_ADD_83, SN(32, 16));
	RzILOpPure *op_EQ_86 = EQ(SEXTRACT64(CAST(64, IL_FALSE, op_RSHIFT_46), SN(32, 0), SN(32, 0x20)), op_RSHIFT_85);
	RzILOpPure *op_RSHIFT_127 = SHIFTRA(DUP(Rss), SN(32, 0x20));
	RzILOpPure *op_AND_129 = LOGAND(op_RSHIFT_127, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_140 = SHIFTRA(DUP(Rtt), SN(32, 0x20));
	RzILOpPure *op_AND_143 = LOGAND(op_RSHIFT_140, CAST(64, MSB(SN(32, 0xffff)), SN(32, 0xffff)));
	RzILOpPure *op_MUL_150 = MUL(CAST(64, MSB(CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(op_AND_129), DUP(op_AND_129))), CAST(32, MSB(DUP(op_AND_129)), DUP(op_AND_129)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_129)), DUP(op_AND_129))), CAST(32, MSB(DUP(op_AND_129)), DUP(op_AND_129))))), CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(DUP(op_AND_129)), DUP(op_AND_129))), CAST(32, MSB(DUP(op_AND_129)), DUP(op_AND_129)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_129)), DUP(op_AND_129))), CAST(32, MSB(DUP(op_AND_129)), DUP(op_AND_129))))), SEXTRACT64(CAST(64, IL_FALSE, CAST(16, MSB(op_AND_143), DUP(op_AND_143))), SN(32, 0), SN(32, 16)));
	RzILOpPure *op_LSHIFT_152 = SHIFTL0(op_MUL_150, SN(32, 1));
	RzILOpPure *op_ADD_155 = ADD(op_LSHIFT_152, CAST(64, MSB(SN(32, 0x8000)), SN(32, 0x8000)));
	RzILOpPure *op_RSHIFT_157 = SHIFTRA(op_ADD_155, SN(32, 16));
	RzILOpPure *op_LT_160 = SLT(op_RSHIFT_157, CAST(64, MSB(SN(32, 0)), SN(32, 0)));
	RzILOpPure *op_LSHIFT_165 = SHIFTL0(SN(64, 1), SN(32, 31));
	RzILOpPure *op_NEG_166 = NEG(op_LSHIFT_165);
	RzILOpPure *op_LSHIFT_171 = SHIFTL0(SN(64, 1), SN(32, 31));
	RzILOpPure *op_SUB_174 = SUB(op_LSHIFT_171, CAST(64, MSB(SN(32, 1)), SN(32, 1)));
	RzILOpPure *cond_175 = ITE(op_LT_160, op_NEG_166, op_SUB_174);
	RzILOpEffect *gcc_expr_176 = BRANCH(op_EQ_86, EMPTY(), set_usr_field_call_123);

	// h_tmp310 = HYB(gcc_expr_if ((sextract64(((ut64) ((((st64) ((st32) ((st64) ((st32) ((Rss >> 0x20) & 0xffffffff))))) * sextract64(((ut64) ((st16) ((Rtt >> 0x20) & ((st64) 0xffff)))), 0x0, 0x10) << 0x1) + ((st64) 0x8000) >> 0x10)), 0x0, 0x20) == ((((st64) ((st32) ((st64) ((st32) ((Rss >> 0x20) & 0xffffffff))))) * sextract64(((ut64) ((st16) ((Rtt >> 0x20) & ((st64) 0xffff)))), 0x0, 0x10) << 0x1) + ((st64) 0x8000) >> 0x10))) {{}} else {set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, ((ut32) 0x1))}, ((((((st64) ((st32) ((st64) ((st32) ((Rss >> 0x20) & 0xffffffff))))) * sextract64(((ut64) ((st16) ((Rtt >> 0x20) & ((st64) 0xffff)))), 0x0, 0x10) << 0x1) + ((st64) 0x8000) >> 0x10) < ((st64) 0x0)) ? (-(0x1 << 0x1f)) : (0x1 << 0x1f) - ((st64) 0x1)));
	RzILOpEffect *op_ASSIGN_hybrid_tmp_178 = SETL("h_tmp310", cond_175);

	// seq(HYB(gcc_expr_if ((sextract64(((ut64) ((((st64) ((st32) ((st6 ...;
	RzILOpEffect *seq_179 = SEQN(2, gcc_expr_176, op_ASSIGN_hybrid_tmp_178);

	// Rdd = ((Rdd & (~(0xffffffff << 0x20))) | ((((sextract64(((ut64) ((((st64) ((st32) ((st64) ((st32) ((Rss >> 0x20) & 0xffffffff))))) * sextract64(((ut64) ((st16) ((Rtt >> 0x20) & ((st64) 0xffff)))), 0x0, 0x10) << 0x1) + ((st64) 0x8000) >> 0x10)), 0x0, 0x20) == ((((st64) ((st32) ((st64) ((st32) ((Rss >> 0x20) & 0xffffffff))))) * sextract64(((ut64) ((st16) ((Rtt >> 0x20) & ((st64) 0xffff)))), 0x0, 0x10) << 0x1) + ((st64) 0x8000) >> 0x10)) ? ((((st64) ((st32) ((st64) ((st32) ((Rss >> 0x20) & 0xffffffff))))) * sextract64(((ut64) ((st16) ((Rtt >> 0x20) & ((st64) 0xffff)))), 0x0, 0x10) << 0x1) + ((st64) 0x8000) >> 0x10) : h_tmp310) & 0xffffffff) << 0x20));
	RzILOpPure *op_LSHIFT_5 = SHIFTL0(SN(64, 0xffffffff), SN(32, 0x20));
	RzILOpPure *op_NOT_6 = LOGNOT(op_LSHIFT_5);
	RzILOpPure *op_AND_7 = LOGAND(READ_REG(pkt, Rdd_op, true), op_NOT_6);
	RzILOpPure *op_RSHIFT_90 = SHIFTRA(DUP(Rss), SN(32, 0x20));
	RzILOpPure *op_AND_92 = LOGAND(op_RSHIFT_90, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_103 = SHIFTRA(DUP(Rtt), SN(32, 0x20));
	RzILOpPure *op_AND_106 = LOGAND(op_RSHIFT_103, CAST(64, MSB(SN(32, 0xffff)), SN(32, 0xffff)));
	RzILOpPure *op_MUL_113 = MUL(CAST(64, MSB(CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(op_AND_92), DUP(op_AND_92))), CAST(32, MSB(DUP(op_AND_92)), DUP(op_AND_92)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_92)), DUP(op_AND_92))), CAST(32, MSB(DUP(op_AND_92)), DUP(op_AND_92))))), CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(DUP(op_AND_92)), DUP(op_AND_92))), CAST(32, MSB(DUP(op_AND_92)), DUP(op_AND_92)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_92)), DUP(op_AND_92))), CAST(32, MSB(DUP(op_AND_92)), DUP(op_AND_92))))), SEXTRACT64(CAST(64, IL_FALSE, CAST(16, MSB(op_AND_106), DUP(op_AND_106))), SN(32, 0), SN(32, 16)));
	RzILOpPure *op_LSHIFT_115 = SHIFTL0(op_MUL_113, SN(32, 1));
	RzILOpPure *op_ADD_118 = ADD(op_LSHIFT_115, CAST(64, MSB(SN(32, 0x8000)), SN(32, 0x8000)));
	RzILOpPure *op_RSHIFT_120 = SHIFTRA(op_ADD_118, SN(32, 16));
	RzILOpPure *cond_180 = ITE(DUP(op_EQ_86), op_RSHIFT_120, VARL("h_tmp310"));
	RzILOpPure *op_AND_182 = LOGAND(cond_180, SN(64, 0xffffffff));
	RzILOpPure *op_LSHIFT_186 = SHIFTL0(op_AND_182, SN(32, 0x20));
	RzILOpPure *op_OR_187 = LOGOR(op_AND_7, op_LSHIFT_186);
	RzILOpEffect *op_ASSIGN_188 = WRITE_REG(bundle, Rdd_op, op_OR_187);

	// seq(seq(HYB(gcc_expr_if ((sextract64(((ut64) ((((st64) ((st32) ( ...;
	RzILOpEffect *seq_189 = SEQN(2, seq_179, op_ASSIGN_188);

	// set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, ((ut32) 0x1));
	RzILOpEffect *set_usr_field_call_311 = hex_set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, CAST(32, IL_FALSE, SN(32, 1)));

	// HYB(gcc_expr_if ((sextract64(((ut64) ((((st64) ((st32) ((st64) ((st32) ((Rss >> 0x0) & 0xffffffff))))) * sextract64(((ut64) ((st16) ((Rtt >> 0x0) & ((st64) 0xffff)))), 0x0, 0x10) << 0x1) + ((st64) 0x8000) >> 0x10)), 0x0, 0x20) == ((((st64) ((st32) ((st64) ((st32) ((Rss >> 0x0) & 0xffffffff))))) * sextract64(((ut64) ((st16) ((Rtt >> 0x0) & ((st64) 0xffff)))), 0x0, 0x10) << 0x1) + ((st64) 0x8000) >> 0x10))) {{}} else {set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, ((ut32) 0x1))}, ((((((st64) ((st32) ((st64) ((st32) ((Rss >> 0x0) & 0xffffffff))))) * sextract64(((ut64) ((st16) ((Rtt >> 0x0) & ((st64) 0xffff)))), 0x0, 0x10) << 0x1) + ((st64) 0x8000) >> 0x10) < ((st64) 0x0)) ? (-(0x1 << 0x1f)) : (0x1 << 0x1f) - ((st64) 0x1)));
	RzILOpPure *op_RSHIFT_204 = SHIFTRA(DUP(Rss), SN(32, 0));
	RzILOpPure *op_AND_206 = LOGAND(op_RSHIFT_204, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_217 = SHIFTRA(DUP(Rtt), SN(32, 0));
	RzILOpPure *op_AND_220 = LOGAND(op_RSHIFT_217, CAST(64, MSB(SN(32, 0xffff)), SN(32, 0xffff)));
	RzILOpPure *op_MUL_227 = MUL(CAST(64, MSB(CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(op_AND_206), DUP(op_AND_206))), CAST(32, MSB(DUP(op_AND_206)), DUP(op_AND_206)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_206)), DUP(op_AND_206))), CAST(32, MSB(DUP(op_AND_206)), DUP(op_AND_206))))), CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(DUP(op_AND_206)), DUP(op_AND_206))), CAST(32, MSB(DUP(op_AND_206)), DUP(op_AND_206)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_206)), DUP(op_AND_206))), CAST(32, MSB(DUP(op_AND_206)), DUP(op_AND_206))))), SEXTRACT64(CAST(64, IL_FALSE, CAST(16, MSB(op_AND_220), DUP(op_AND_220))), SN(32, 0), SN(32, 16)));
	RzILOpPure *op_LSHIFT_229 = SHIFTL0(op_MUL_227, SN(32, 1));
	RzILOpPure *op_ADD_232 = ADD(op_LSHIFT_229, CAST(64, MSB(SN(32, 0x8000)), SN(32, 0x8000)));
	RzILOpPure *op_RSHIFT_234 = SHIFTRA(op_ADD_232, SN(32, 16));
	RzILOpPure *op_RSHIFT_243 = SHIFTRA(DUP(Rss), SN(32, 0));
	RzILOpPure *op_AND_245 = LOGAND(op_RSHIFT_243, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_256 = SHIFTRA(DUP(Rtt), SN(32, 0));
	RzILOpPure *op_AND_259 = LOGAND(op_RSHIFT_256, CAST(64, MSB(SN(32, 0xffff)), SN(32, 0xffff)));
	RzILOpPure *op_MUL_266 = MUL(CAST(64, MSB(CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(op_AND_245), DUP(op_AND_245))), CAST(32, MSB(DUP(op_AND_245)), DUP(op_AND_245)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_245)), DUP(op_AND_245))), CAST(32, MSB(DUP(op_AND_245)), DUP(op_AND_245))))), CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(DUP(op_AND_245)), DUP(op_AND_245))), CAST(32, MSB(DUP(op_AND_245)), DUP(op_AND_245)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_245)), DUP(op_AND_245))), CAST(32, MSB(DUP(op_AND_245)), DUP(op_AND_245))))), SEXTRACT64(CAST(64, IL_FALSE, CAST(16, MSB(op_AND_259), DUP(op_AND_259))), SN(32, 0), SN(32, 16)));
	RzILOpPure *op_LSHIFT_268 = SHIFTL0(op_MUL_266, SN(32, 1));
	RzILOpPure *op_ADD_271 = ADD(op_LSHIFT_268, CAST(64, MSB(SN(32, 0x8000)), SN(32, 0x8000)));
	RzILOpPure *op_RSHIFT_273 = SHIFTRA(op_ADD_271, SN(32, 16));
	RzILOpPure *op_EQ_274 = EQ(SEXTRACT64(CAST(64, IL_FALSE, op_RSHIFT_234), SN(32, 0), SN(32, 0x20)), op_RSHIFT_273);
	RzILOpPure *op_RSHIFT_315 = SHIFTRA(DUP(Rss), SN(32, 0));
	RzILOpPure *op_AND_317 = LOGAND(op_RSHIFT_315, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_328 = SHIFTRA(DUP(Rtt), SN(32, 0));
	RzILOpPure *op_AND_331 = LOGAND(op_RSHIFT_328, CAST(64, MSB(SN(32, 0xffff)), SN(32, 0xffff)));
	RzILOpPure *op_MUL_338 = MUL(CAST(64, MSB(CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(op_AND_317), DUP(op_AND_317))), CAST(32, MSB(DUP(op_AND_317)), DUP(op_AND_317)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_317)), DUP(op_AND_317))), CAST(32, MSB(DUP(op_AND_317)), DUP(op_AND_317))))), CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(DUP(op_AND_317)), DUP(op_AND_317))), CAST(32, MSB(DUP(op_AND_317)), DUP(op_AND_317)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_317)), DUP(op_AND_317))), CAST(32, MSB(DUP(op_AND_317)), DUP(op_AND_317))))), SEXTRACT64(CAST(64, IL_FALSE, CAST(16, MSB(op_AND_331), DUP(op_AND_331))), SN(32, 0), SN(32, 16)));
	RzILOpPure *op_LSHIFT_340 = SHIFTL0(op_MUL_338, SN(32, 1));
	RzILOpPure *op_ADD_343 = ADD(op_LSHIFT_340, CAST(64, MSB(SN(32, 0x8000)), SN(32, 0x8000)));
	RzILOpPure *op_RSHIFT_345 = SHIFTRA(op_ADD_343, SN(32, 16));
	RzILOpPure *op_LT_348 = SLT(op_RSHIFT_345, CAST(64, MSB(SN(32, 0)), SN(32, 0)));
	RzILOpPure *op_LSHIFT_353 = SHIFTL0(SN(64, 1), SN(32, 31));
	RzILOpPure *op_NEG_354 = NEG(op_LSHIFT_353);
	RzILOpPure *op_LSHIFT_359 = SHIFTL0(SN(64, 1), SN(32, 31));
	RzILOpPure *op_SUB_362 = SUB(op_LSHIFT_359, CAST(64, MSB(SN(32, 1)), SN(32, 1)));
	RzILOpPure *cond_363 = ITE(op_LT_348, op_NEG_354, op_SUB_362);
	RzILOpEffect *gcc_expr_364 = BRANCH(op_EQ_274, EMPTY(), set_usr_field_call_311);

	// h_tmp311 = HYB(gcc_expr_if ((sextract64(((ut64) ((((st64) ((st32) ((st64) ((st32) ((Rss >> 0x0) & 0xffffffff))))) * sextract64(((ut64) ((st16) ((Rtt >> 0x0) & ((st64) 0xffff)))), 0x0, 0x10) << 0x1) + ((st64) 0x8000) >> 0x10)), 0x0, 0x20) == ((((st64) ((st32) ((st64) ((st32) ((Rss >> 0x0) & 0xffffffff))))) * sextract64(((ut64) ((st16) ((Rtt >> 0x0) & ((st64) 0xffff)))), 0x0, 0x10) << 0x1) + ((st64) 0x8000) >> 0x10))) {{}} else {set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, ((ut32) 0x1))}, ((((((st64) ((st32) ((st64) ((st32) ((Rss >> 0x0) & 0xffffffff))))) * sextract64(((ut64) ((st16) ((Rtt >> 0x0) & ((st64) 0xffff)))), 0x0, 0x10) << 0x1) + ((st64) 0x8000) >> 0x10) < ((st64) 0x0)) ? (-(0x1 << 0x1f)) : (0x1 << 0x1f) - ((st64) 0x1)));
	RzILOpEffect *op_ASSIGN_hybrid_tmp_366 = SETL("h_tmp311", cond_363);

	// seq(HYB(gcc_expr_if ((sextract64(((ut64) ((((st64) ((st32) ((st6 ...;
	RzILOpEffect *seq_367 = SEQN(2, gcc_expr_364, op_ASSIGN_hybrid_tmp_366);

	// Rdd = ((Rdd & (~(0xffffffff << 0x0))) | ((((sextract64(((ut64) ((((st64) ((st32) ((st64) ((st32) ((Rss >> 0x0) & 0xffffffff))))) * sextract64(((ut64) ((st16) ((Rtt >> 0x0) & ((st64) 0xffff)))), 0x0, 0x10) << 0x1) + ((st64) 0x8000) >> 0x10)), 0x0, 0x20) == ((((st64) ((st32) ((st64) ((st32) ((Rss >> 0x0) & 0xffffffff))))) * sextract64(((ut64) ((st16) ((Rtt >> 0x0) & ((st64) 0xffff)))), 0x0, 0x10) << 0x1) + ((st64) 0x8000) >> 0x10)) ? ((((st64) ((st32) ((st64) ((st32) ((Rss >> 0x0) & 0xffffffff))))) * sextract64(((ut64) ((st16) ((Rtt >> 0x0) & ((st64) 0xffff)))), 0x0, 0x10) << 0x1) + ((st64) 0x8000) >> 0x10) : h_tmp311) & 0xffffffff) << 0x0));
	RzILOpPure *op_LSHIFT_195 = SHIFTL0(SN(64, 0xffffffff), SN(32, 0));
	RzILOpPure *op_NOT_196 = LOGNOT(op_LSHIFT_195);
	RzILOpPure *op_AND_197 = LOGAND(READ_REG(pkt, Rdd_op, true), op_NOT_196);
	RzILOpPure *op_RSHIFT_278 = SHIFTRA(DUP(Rss), SN(32, 0));
	RzILOpPure *op_AND_280 = LOGAND(op_RSHIFT_278, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_291 = SHIFTRA(DUP(Rtt), SN(32, 0));
	RzILOpPure *op_AND_294 = LOGAND(op_RSHIFT_291, CAST(64, MSB(SN(32, 0xffff)), SN(32, 0xffff)));
	RzILOpPure *op_MUL_301 = MUL(CAST(64, MSB(CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(op_AND_280), DUP(op_AND_280))), CAST(32, MSB(DUP(op_AND_280)), DUP(op_AND_280)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_280)), DUP(op_AND_280))), CAST(32, MSB(DUP(op_AND_280)), DUP(op_AND_280))))), CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(DUP(op_AND_280)), DUP(op_AND_280))), CAST(32, MSB(DUP(op_AND_280)), DUP(op_AND_280)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_280)), DUP(op_AND_280))), CAST(32, MSB(DUP(op_AND_280)), DUP(op_AND_280))))), SEXTRACT64(CAST(64, IL_FALSE, CAST(16, MSB(op_AND_294), DUP(op_AND_294))), SN(32, 0), SN(32, 16)));
	RzILOpPure *op_LSHIFT_303 = SHIFTL0(op_MUL_301, SN(32, 1));
	RzILOpPure *op_ADD_306 = ADD(op_LSHIFT_303, CAST(64, MSB(SN(32, 0x8000)), SN(32, 0x8000)));
	RzILOpPure *op_RSHIFT_308 = SHIFTRA(op_ADD_306, SN(32, 16));
	RzILOpPure *cond_368 = ITE(DUP(op_EQ_274), op_RSHIFT_308, VARL("h_tmp311"));
	RzILOpPure *op_AND_370 = LOGAND(cond_368, SN(64, 0xffffffff));
	RzILOpPure *op_LSHIFT_374 = SHIFTL0(op_AND_370, SN(32, 0));
	RzILOpPure *op_OR_375 = LOGOR(op_AND_197, op_LSHIFT_374);
	RzILOpEffect *op_ASSIGN_376 = WRITE_REG(bundle, Rdd_op, op_OR_375);

	// seq(seq(HYB(gcc_expr_if ((sextract64(((ut64) ((((st64) ((st32) ( ...;
	RzILOpEffect *seq_377 = SEQN(2, seq_367, op_ASSIGN_376);

	RzILOpEffect *instruction_sequence = SEQN(2, seq_189, seq_377);
	return instruction_sequence;
}

// Rdd = vmpyweh(Rss,Rtt):sat
RzILOpEffect *hex_il_op_m2_mmpyl_s0(HexInsnPktBundle *bundle) {
	const HexInsn *hi = bundle->insn;
	HexPkt *pkt = bundle->pkt;
	// READ
	const HexOp *Rdd_op = ISA2REG(hi, 'd', false);
	const HexOp *Rss_op = ISA2REG(hi, 's', false);
	RzILOpPure *Rss = READ_REG(pkt, Rss_op, false);
	const HexOp *Rtt_op = ISA2REG(hi, 't', false);
	RzILOpPure *Rtt = READ_REG(pkt, Rtt_op, false);

	// set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, ((ut32) 0x1));
	RzILOpEffect *set_usr_field_call_114 = hex_set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, CAST(32, IL_FALSE, SN(32, 1)));

	// HYB(gcc_expr_if ((sextract64(((ut64) ((((st64) ((st32) ((st64) ((st32) ((Rss >> 0x20) & 0xffffffff))))) * sextract64(((ut64) ((st16) ((Rtt >> 0x20) & ((st64) 0xffff)))), 0x0, 0x10) << 0x0) >> 0x10)), 0x0, 0x20) == ((((st64) ((st32) ((st64) ((st32) ((Rss >> 0x20) & 0xffffffff))))) * sextract64(((ut64) ((st16) ((Rtt >> 0x20) & ((st64) 0xffff)))), 0x0, 0x10) << 0x0) >> 0x10))) {{}} else {set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, ((ut32) 0x1))}, ((((((st64) ((st32) ((st64) ((st32) ((Rss >> 0x20) & 0xffffffff))))) * sextract64(((ut64) ((st16) ((Rtt >> 0x20) & ((st64) 0xffff)))), 0x0, 0x10) << 0x0) >> 0x10) < ((st64) 0x0)) ? (-(0x1 << 0x1f)) : (0x1 << 0x1f) - ((st64) 0x1)));
	RzILOpPure *op_RSHIFT_15 = SHIFTRA(Rss, SN(32, 0x20));
	RzILOpPure *op_AND_17 = LOGAND(op_RSHIFT_15, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_29 = SHIFTRA(Rtt, SN(32, 0x20));
	RzILOpPure *op_AND_32 = LOGAND(op_RSHIFT_29, CAST(64, MSB(SN(32, 0xffff)), SN(32, 0xffff)));
	RzILOpPure *op_MUL_39 = MUL(CAST(64, MSB(CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(op_AND_17), DUP(op_AND_17))), CAST(32, MSB(DUP(op_AND_17)), DUP(op_AND_17)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_17)), DUP(op_AND_17))), CAST(32, MSB(DUP(op_AND_17)), DUP(op_AND_17))))), CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(DUP(op_AND_17)), DUP(op_AND_17))), CAST(32, MSB(DUP(op_AND_17)), DUP(op_AND_17)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_17)), DUP(op_AND_17))), CAST(32, MSB(DUP(op_AND_17)), DUP(op_AND_17))))), SEXTRACT64(CAST(64, IL_FALSE, CAST(16, MSB(op_AND_32), DUP(op_AND_32))), SN(32, 0), SN(32, 16)));
	RzILOpPure *op_LSHIFT_41 = SHIFTL0(op_MUL_39, SN(32, 0));
	RzILOpPure *op_RSHIFT_43 = SHIFTRA(op_LSHIFT_41, SN(32, 16));
	RzILOpPure *op_RSHIFT_52 = SHIFTRA(DUP(Rss), SN(32, 0x20));
	RzILOpPure *op_AND_54 = LOGAND(op_RSHIFT_52, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_65 = SHIFTRA(DUP(Rtt), SN(32, 0x20));
	RzILOpPure *op_AND_68 = LOGAND(op_RSHIFT_65, CAST(64, MSB(SN(32, 0xffff)), SN(32, 0xffff)));
	RzILOpPure *op_MUL_75 = MUL(CAST(64, MSB(CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(op_AND_54), DUP(op_AND_54))), CAST(32, MSB(DUP(op_AND_54)), DUP(op_AND_54)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_54)), DUP(op_AND_54))), CAST(32, MSB(DUP(op_AND_54)), DUP(op_AND_54))))), CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(DUP(op_AND_54)), DUP(op_AND_54))), CAST(32, MSB(DUP(op_AND_54)), DUP(op_AND_54)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_54)), DUP(op_AND_54))), CAST(32, MSB(DUP(op_AND_54)), DUP(op_AND_54))))), SEXTRACT64(CAST(64, IL_FALSE, CAST(16, MSB(op_AND_68), DUP(op_AND_68))), SN(32, 0), SN(32, 16)));
	RzILOpPure *op_LSHIFT_77 = SHIFTL0(op_MUL_75, SN(32, 0));
	RzILOpPure *op_RSHIFT_79 = SHIFTRA(op_LSHIFT_77, SN(32, 16));
	RzILOpPure *op_EQ_80 = EQ(SEXTRACT64(CAST(64, IL_FALSE, op_RSHIFT_43), SN(32, 0), SN(32, 0x20)), op_RSHIFT_79);
	RzILOpPure *op_RSHIFT_118 = SHIFTRA(DUP(Rss), SN(32, 0x20));
	RzILOpPure *op_AND_120 = LOGAND(op_RSHIFT_118, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_131 = SHIFTRA(DUP(Rtt), SN(32, 0x20));
	RzILOpPure *op_AND_134 = LOGAND(op_RSHIFT_131, CAST(64, MSB(SN(32, 0xffff)), SN(32, 0xffff)));
	RzILOpPure *op_MUL_141 = MUL(CAST(64, MSB(CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(op_AND_120), DUP(op_AND_120))), CAST(32, MSB(DUP(op_AND_120)), DUP(op_AND_120)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_120)), DUP(op_AND_120))), CAST(32, MSB(DUP(op_AND_120)), DUP(op_AND_120))))), CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(DUP(op_AND_120)), DUP(op_AND_120))), CAST(32, MSB(DUP(op_AND_120)), DUP(op_AND_120)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_120)), DUP(op_AND_120))), CAST(32, MSB(DUP(op_AND_120)), DUP(op_AND_120))))), SEXTRACT64(CAST(64, IL_FALSE, CAST(16, MSB(op_AND_134), DUP(op_AND_134))), SN(32, 0), SN(32, 16)));
	RzILOpPure *op_LSHIFT_143 = SHIFTL0(op_MUL_141, SN(32, 0));
	RzILOpPure *op_RSHIFT_145 = SHIFTRA(op_LSHIFT_143, SN(32, 16));
	RzILOpPure *op_LT_148 = SLT(op_RSHIFT_145, CAST(64, MSB(SN(32, 0)), SN(32, 0)));
	RzILOpPure *op_LSHIFT_153 = SHIFTL0(SN(64, 1), SN(32, 31));
	RzILOpPure *op_NEG_154 = NEG(op_LSHIFT_153);
	RzILOpPure *op_LSHIFT_159 = SHIFTL0(SN(64, 1), SN(32, 31));
	RzILOpPure *op_SUB_162 = SUB(op_LSHIFT_159, CAST(64, MSB(SN(32, 1)), SN(32, 1)));
	RzILOpPure *cond_163 = ITE(op_LT_148, op_NEG_154, op_SUB_162);
	RzILOpEffect *gcc_expr_164 = BRANCH(op_EQ_80, EMPTY(), set_usr_field_call_114);

	// h_tmp312 = HYB(gcc_expr_if ((sextract64(((ut64) ((((st64) ((st32) ((st64) ((st32) ((Rss >> 0x20) & 0xffffffff))))) * sextract64(((ut64) ((st16) ((Rtt >> 0x20) & ((st64) 0xffff)))), 0x0, 0x10) << 0x0) >> 0x10)), 0x0, 0x20) == ((((st64) ((st32) ((st64) ((st32) ((Rss >> 0x20) & 0xffffffff))))) * sextract64(((ut64) ((st16) ((Rtt >> 0x20) & ((st64) 0xffff)))), 0x0, 0x10) << 0x0) >> 0x10))) {{}} else {set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, ((ut32) 0x1))}, ((((((st64) ((st32) ((st64) ((st32) ((Rss >> 0x20) & 0xffffffff))))) * sextract64(((ut64) ((st16) ((Rtt >> 0x20) & ((st64) 0xffff)))), 0x0, 0x10) << 0x0) >> 0x10) < ((st64) 0x0)) ? (-(0x1 << 0x1f)) : (0x1 << 0x1f) - ((st64) 0x1)));
	RzILOpEffect *op_ASSIGN_hybrid_tmp_166 = SETL("h_tmp312", cond_163);

	// seq(HYB(gcc_expr_if ((sextract64(((ut64) ((((st64) ((st32) ((st6 ...;
	RzILOpEffect *seq_167 = SEQN(2, gcc_expr_164, op_ASSIGN_hybrid_tmp_166);

	// Rdd = ((Rdd & (~(0xffffffff << 0x20))) | ((((sextract64(((ut64) ((((st64) ((st32) ((st64) ((st32) ((Rss >> 0x20) & 0xffffffff))))) * sextract64(((ut64) ((st16) ((Rtt >> 0x20) & ((st64) 0xffff)))), 0x0, 0x10) << 0x0) >> 0x10)), 0x0, 0x20) == ((((st64) ((st32) ((st64) ((st32) ((Rss >> 0x20) & 0xffffffff))))) * sextract64(((ut64) ((st16) ((Rtt >> 0x20) & ((st64) 0xffff)))), 0x0, 0x10) << 0x0) >> 0x10)) ? ((((st64) ((st32) ((st64) ((st32) ((Rss >> 0x20) & 0xffffffff))))) * sextract64(((ut64) ((st16) ((Rtt >> 0x20) & ((st64) 0xffff)))), 0x0, 0x10) << 0x0) >> 0x10) : h_tmp312) & 0xffffffff) << 0x20));
	RzILOpPure *op_LSHIFT_5 = SHIFTL0(SN(64, 0xffffffff), SN(32, 0x20));
	RzILOpPure *op_NOT_6 = LOGNOT(op_LSHIFT_5);
	RzILOpPure *op_AND_7 = LOGAND(READ_REG(pkt, Rdd_op, true), op_NOT_6);
	RzILOpPure *op_RSHIFT_84 = SHIFTRA(DUP(Rss), SN(32, 0x20));
	RzILOpPure *op_AND_86 = LOGAND(op_RSHIFT_84, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_97 = SHIFTRA(DUP(Rtt), SN(32, 0x20));
	RzILOpPure *op_AND_100 = LOGAND(op_RSHIFT_97, CAST(64, MSB(SN(32, 0xffff)), SN(32, 0xffff)));
	RzILOpPure *op_MUL_107 = MUL(CAST(64, MSB(CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(op_AND_86), DUP(op_AND_86))), CAST(32, MSB(DUP(op_AND_86)), DUP(op_AND_86)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_86)), DUP(op_AND_86))), CAST(32, MSB(DUP(op_AND_86)), DUP(op_AND_86))))), CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(DUP(op_AND_86)), DUP(op_AND_86))), CAST(32, MSB(DUP(op_AND_86)), DUP(op_AND_86)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_86)), DUP(op_AND_86))), CAST(32, MSB(DUP(op_AND_86)), DUP(op_AND_86))))), SEXTRACT64(CAST(64, IL_FALSE, CAST(16, MSB(op_AND_100), DUP(op_AND_100))), SN(32, 0), SN(32, 16)));
	RzILOpPure *op_LSHIFT_109 = SHIFTL0(op_MUL_107, SN(32, 0));
	RzILOpPure *op_RSHIFT_111 = SHIFTRA(op_LSHIFT_109, SN(32, 16));
	RzILOpPure *cond_168 = ITE(DUP(op_EQ_80), op_RSHIFT_111, VARL("h_tmp312"));
	RzILOpPure *op_AND_170 = LOGAND(cond_168, SN(64, 0xffffffff));
	RzILOpPure *op_LSHIFT_174 = SHIFTL0(op_AND_170, SN(32, 0x20));
	RzILOpPure *op_OR_175 = LOGOR(op_AND_7, op_LSHIFT_174);
	RzILOpEffect *op_ASSIGN_176 = WRITE_REG(bundle, Rdd_op, op_OR_175);

	// seq(seq(HYB(gcc_expr_if ((sextract64(((ut64) ((((st64) ((st32) ( ...;
	RzILOpEffect *seq_177 = SEQN(2, seq_167, op_ASSIGN_176);

	// set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, ((ut32) 0x1));
	RzILOpEffect *set_usr_field_call_290 = hex_set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, CAST(32, IL_FALSE, SN(32, 1)));

	// HYB(gcc_expr_if ((sextract64(((ut64) ((((st64) ((st32) ((st64) ((st32) ((Rss >> 0x0) & 0xffffffff))))) * sextract64(((ut64) ((st16) ((Rtt >> 0x0) & ((st64) 0xffff)))), 0x0, 0x10) << 0x0) >> 0x10)), 0x0, 0x20) == ((((st64) ((st32) ((st64) ((st32) ((Rss >> 0x0) & 0xffffffff))))) * sextract64(((ut64) ((st16) ((Rtt >> 0x0) & ((st64) 0xffff)))), 0x0, 0x10) << 0x0) >> 0x10))) {{}} else {set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, ((ut32) 0x1))}, ((((((st64) ((st32) ((st64) ((st32) ((Rss >> 0x0) & 0xffffffff))))) * sextract64(((ut64) ((st16) ((Rtt >> 0x0) & ((st64) 0xffff)))), 0x0, 0x10) << 0x0) >> 0x10) < ((st64) 0x0)) ? (-(0x1 << 0x1f)) : (0x1 << 0x1f) - ((st64) 0x1)));
	RzILOpPure *op_RSHIFT_192 = SHIFTRA(DUP(Rss), SN(32, 0));
	RzILOpPure *op_AND_194 = LOGAND(op_RSHIFT_192, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_205 = SHIFTRA(DUP(Rtt), SN(32, 0));
	RzILOpPure *op_AND_208 = LOGAND(op_RSHIFT_205, CAST(64, MSB(SN(32, 0xffff)), SN(32, 0xffff)));
	RzILOpPure *op_MUL_215 = MUL(CAST(64, MSB(CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(op_AND_194), DUP(op_AND_194))), CAST(32, MSB(DUP(op_AND_194)), DUP(op_AND_194)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_194)), DUP(op_AND_194))), CAST(32, MSB(DUP(op_AND_194)), DUP(op_AND_194))))), CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(DUP(op_AND_194)), DUP(op_AND_194))), CAST(32, MSB(DUP(op_AND_194)), DUP(op_AND_194)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_194)), DUP(op_AND_194))), CAST(32, MSB(DUP(op_AND_194)), DUP(op_AND_194))))), SEXTRACT64(CAST(64, IL_FALSE, CAST(16, MSB(op_AND_208), DUP(op_AND_208))), SN(32, 0), SN(32, 16)));
	RzILOpPure *op_LSHIFT_217 = SHIFTL0(op_MUL_215, SN(32, 0));
	RzILOpPure *op_RSHIFT_219 = SHIFTRA(op_LSHIFT_217, SN(32, 16));
	RzILOpPure *op_RSHIFT_228 = SHIFTRA(DUP(Rss), SN(32, 0));
	RzILOpPure *op_AND_230 = LOGAND(op_RSHIFT_228, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_241 = SHIFTRA(DUP(Rtt), SN(32, 0));
	RzILOpPure *op_AND_244 = LOGAND(op_RSHIFT_241, CAST(64, MSB(SN(32, 0xffff)), SN(32, 0xffff)));
	RzILOpPure *op_MUL_251 = MUL(CAST(64, MSB(CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(op_AND_230), DUP(op_AND_230))), CAST(32, MSB(DUP(op_AND_230)), DUP(op_AND_230)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_230)), DUP(op_AND_230))), CAST(32, MSB(DUP(op_AND_230)), DUP(op_AND_230))))), CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(DUP(op_AND_230)), DUP(op_AND_230))), CAST(32, MSB(DUP(op_AND_230)), DUP(op_AND_230)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_230)), DUP(op_AND_230))), CAST(32, MSB(DUP(op_AND_230)), DUP(op_AND_230))))), SEXTRACT64(CAST(64, IL_FALSE, CAST(16, MSB(op_AND_244), DUP(op_AND_244))), SN(32, 0), SN(32, 16)));
	RzILOpPure *op_LSHIFT_253 = SHIFTL0(op_MUL_251, SN(32, 0));
	RzILOpPure *op_RSHIFT_255 = SHIFTRA(op_LSHIFT_253, SN(32, 16));
	RzILOpPure *op_EQ_256 = EQ(SEXTRACT64(CAST(64, IL_FALSE, op_RSHIFT_219), SN(32, 0), SN(32, 0x20)), op_RSHIFT_255);
	RzILOpPure *op_RSHIFT_294 = SHIFTRA(DUP(Rss), SN(32, 0));
	RzILOpPure *op_AND_296 = LOGAND(op_RSHIFT_294, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_307 = SHIFTRA(DUP(Rtt), SN(32, 0));
	RzILOpPure *op_AND_310 = LOGAND(op_RSHIFT_307, CAST(64, MSB(SN(32, 0xffff)), SN(32, 0xffff)));
	RzILOpPure *op_MUL_317 = MUL(CAST(64, MSB(CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(op_AND_296), DUP(op_AND_296))), CAST(32, MSB(DUP(op_AND_296)), DUP(op_AND_296)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_296)), DUP(op_AND_296))), CAST(32, MSB(DUP(op_AND_296)), DUP(op_AND_296))))), CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(DUP(op_AND_296)), DUP(op_AND_296))), CAST(32, MSB(DUP(op_AND_296)), DUP(op_AND_296)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_296)), DUP(op_AND_296))), CAST(32, MSB(DUP(op_AND_296)), DUP(op_AND_296))))), SEXTRACT64(CAST(64, IL_FALSE, CAST(16, MSB(op_AND_310), DUP(op_AND_310))), SN(32, 0), SN(32, 16)));
	RzILOpPure *op_LSHIFT_319 = SHIFTL0(op_MUL_317, SN(32, 0));
	RzILOpPure *op_RSHIFT_321 = SHIFTRA(op_LSHIFT_319, SN(32, 16));
	RzILOpPure *op_LT_324 = SLT(op_RSHIFT_321, CAST(64, MSB(SN(32, 0)), SN(32, 0)));
	RzILOpPure *op_LSHIFT_329 = SHIFTL0(SN(64, 1), SN(32, 31));
	RzILOpPure *op_NEG_330 = NEG(op_LSHIFT_329);
	RzILOpPure *op_LSHIFT_335 = SHIFTL0(SN(64, 1), SN(32, 31));
	RzILOpPure *op_SUB_338 = SUB(op_LSHIFT_335, CAST(64, MSB(SN(32, 1)), SN(32, 1)));
	RzILOpPure *cond_339 = ITE(op_LT_324, op_NEG_330, op_SUB_338);
	RzILOpEffect *gcc_expr_340 = BRANCH(op_EQ_256, EMPTY(), set_usr_field_call_290);

	// h_tmp313 = HYB(gcc_expr_if ((sextract64(((ut64) ((((st64) ((st32) ((st64) ((st32) ((Rss >> 0x0) & 0xffffffff))))) * sextract64(((ut64) ((st16) ((Rtt >> 0x0) & ((st64) 0xffff)))), 0x0, 0x10) << 0x0) >> 0x10)), 0x0, 0x20) == ((((st64) ((st32) ((st64) ((st32) ((Rss >> 0x0) & 0xffffffff))))) * sextract64(((ut64) ((st16) ((Rtt >> 0x0) & ((st64) 0xffff)))), 0x0, 0x10) << 0x0) >> 0x10))) {{}} else {set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, ((ut32) 0x1))}, ((((((st64) ((st32) ((st64) ((st32) ((Rss >> 0x0) & 0xffffffff))))) * sextract64(((ut64) ((st16) ((Rtt >> 0x0) & ((st64) 0xffff)))), 0x0, 0x10) << 0x0) >> 0x10) < ((st64) 0x0)) ? (-(0x1 << 0x1f)) : (0x1 << 0x1f) - ((st64) 0x1)));
	RzILOpEffect *op_ASSIGN_hybrid_tmp_342 = SETL("h_tmp313", cond_339);

	// seq(HYB(gcc_expr_if ((sextract64(((ut64) ((((st64) ((st32) ((st6 ...;
	RzILOpEffect *seq_343 = SEQN(2, gcc_expr_340, op_ASSIGN_hybrid_tmp_342);

	// Rdd = ((Rdd & (~(0xffffffff << 0x0))) | ((((sextract64(((ut64) ((((st64) ((st32) ((st64) ((st32) ((Rss >> 0x0) & 0xffffffff))))) * sextract64(((ut64) ((st16) ((Rtt >> 0x0) & ((st64) 0xffff)))), 0x0, 0x10) << 0x0) >> 0x10)), 0x0, 0x20) == ((((st64) ((st32) ((st64) ((st32) ((Rss >> 0x0) & 0xffffffff))))) * sextract64(((ut64) ((st16) ((Rtt >> 0x0) & ((st64) 0xffff)))), 0x0, 0x10) << 0x0) >> 0x10)) ? ((((st64) ((st32) ((st64) ((st32) ((Rss >> 0x0) & 0xffffffff))))) * sextract64(((ut64) ((st16) ((Rtt >> 0x0) & ((st64) 0xffff)))), 0x0, 0x10) << 0x0) >> 0x10) : h_tmp313) & 0xffffffff) << 0x0));
	RzILOpPure *op_LSHIFT_183 = SHIFTL0(SN(64, 0xffffffff), SN(32, 0));
	RzILOpPure *op_NOT_184 = LOGNOT(op_LSHIFT_183);
	RzILOpPure *op_AND_185 = LOGAND(READ_REG(pkt, Rdd_op, true), op_NOT_184);
	RzILOpPure *op_RSHIFT_260 = SHIFTRA(DUP(Rss), SN(32, 0));
	RzILOpPure *op_AND_262 = LOGAND(op_RSHIFT_260, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_273 = SHIFTRA(DUP(Rtt), SN(32, 0));
	RzILOpPure *op_AND_276 = LOGAND(op_RSHIFT_273, CAST(64, MSB(SN(32, 0xffff)), SN(32, 0xffff)));
	RzILOpPure *op_MUL_283 = MUL(CAST(64, MSB(CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(op_AND_262), DUP(op_AND_262))), CAST(32, MSB(DUP(op_AND_262)), DUP(op_AND_262)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_262)), DUP(op_AND_262))), CAST(32, MSB(DUP(op_AND_262)), DUP(op_AND_262))))), CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(DUP(op_AND_262)), DUP(op_AND_262))), CAST(32, MSB(DUP(op_AND_262)), DUP(op_AND_262)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_262)), DUP(op_AND_262))), CAST(32, MSB(DUP(op_AND_262)), DUP(op_AND_262))))), SEXTRACT64(CAST(64, IL_FALSE, CAST(16, MSB(op_AND_276), DUP(op_AND_276))), SN(32, 0), SN(32, 16)));
	RzILOpPure *op_LSHIFT_285 = SHIFTL0(op_MUL_283, SN(32, 0));
	RzILOpPure *op_RSHIFT_287 = SHIFTRA(op_LSHIFT_285, SN(32, 16));
	RzILOpPure *cond_344 = ITE(DUP(op_EQ_256), op_RSHIFT_287, VARL("h_tmp313"));
	RzILOpPure *op_AND_346 = LOGAND(cond_344, SN(64, 0xffffffff));
	RzILOpPure *op_LSHIFT_350 = SHIFTL0(op_AND_346, SN(32, 0));
	RzILOpPure *op_OR_351 = LOGOR(op_AND_185, op_LSHIFT_350);
	RzILOpEffect *op_ASSIGN_352 = WRITE_REG(bundle, Rdd_op, op_OR_351);

	// seq(seq(HYB(gcc_expr_if ((sextract64(((ut64) ((((st64) ((st32) ( ...;
	RzILOpEffect *seq_353 = SEQN(2, seq_343, op_ASSIGN_352);

	RzILOpEffect *instruction_sequence = SEQN(2, seq_177, seq_353);
	return instruction_sequence;
}

// Rdd = vmpyweh(Rss,Rtt):<<1:sat
RzILOpEffect *hex_il_op_m2_mmpyl_s1(HexInsnPktBundle *bundle) {
	const HexInsn *hi = bundle->insn;
	HexPkt *pkt = bundle->pkt;
	// READ
	const HexOp *Rdd_op = ISA2REG(hi, 'd', false);
	const HexOp *Rss_op = ISA2REG(hi, 's', false);
	RzILOpPure *Rss = READ_REG(pkt, Rss_op, false);
	const HexOp *Rtt_op = ISA2REG(hi, 't', false);
	RzILOpPure *Rtt = READ_REG(pkt, Rtt_op, false);

	// set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, ((ut32) 0x1));
	RzILOpEffect *set_usr_field_call_114 = hex_set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, CAST(32, IL_FALSE, SN(32, 1)));

	// HYB(gcc_expr_if ((sextract64(((ut64) ((((st64) ((st32) ((st64) ((st32) ((Rss >> 0x20) & 0xffffffff))))) * sextract64(((ut64) ((st16) ((Rtt >> 0x20) & ((st64) 0xffff)))), 0x0, 0x10) << 0x1) >> 0x10)), 0x0, 0x20) == ((((st64) ((st32) ((st64) ((st32) ((Rss >> 0x20) & 0xffffffff))))) * sextract64(((ut64) ((st16) ((Rtt >> 0x20) & ((st64) 0xffff)))), 0x0, 0x10) << 0x1) >> 0x10))) {{}} else {set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, ((ut32) 0x1))}, ((((((st64) ((st32) ((st64) ((st32) ((Rss >> 0x20) & 0xffffffff))))) * sextract64(((ut64) ((st16) ((Rtt >> 0x20) & ((st64) 0xffff)))), 0x0, 0x10) << 0x1) >> 0x10) < ((st64) 0x0)) ? (-(0x1 << 0x1f)) : (0x1 << 0x1f) - ((st64) 0x1)));
	RzILOpPure *op_RSHIFT_15 = SHIFTRA(Rss, SN(32, 0x20));
	RzILOpPure *op_AND_17 = LOGAND(op_RSHIFT_15, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_29 = SHIFTRA(Rtt, SN(32, 0x20));
	RzILOpPure *op_AND_32 = LOGAND(op_RSHIFT_29, CAST(64, MSB(SN(32, 0xffff)), SN(32, 0xffff)));
	RzILOpPure *op_MUL_39 = MUL(CAST(64, MSB(CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(op_AND_17), DUP(op_AND_17))), CAST(32, MSB(DUP(op_AND_17)), DUP(op_AND_17)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_17)), DUP(op_AND_17))), CAST(32, MSB(DUP(op_AND_17)), DUP(op_AND_17))))), CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(DUP(op_AND_17)), DUP(op_AND_17))), CAST(32, MSB(DUP(op_AND_17)), DUP(op_AND_17)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_17)), DUP(op_AND_17))), CAST(32, MSB(DUP(op_AND_17)), DUP(op_AND_17))))), SEXTRACT64(CAST(64, IL_FALSE, CAST(16, MSB(op_AND_32), DUP(op_AND_32))), SN(32, 0), SN(32, 16)));
	RzILOpPure *op_LSHIFT_41 = SHIFTL0(op_MUL_39, SN(32, 1));
	RzILOpPure *op_RSHIFT_43 = SHIFTRA(op_LSHIFT_41, SN(32, 16));
	RzILOpPure *op_RSHIFT_52 = SHIFTRA(DUP(Rss), SN(32, 0x20));
	RzILOpPure *op_AND_54 = LOGAND(op_RSHIFT_52, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_65 = SHIFTRA(DUP(Rtt), SN(32, 0x20));
	RzILOpPure *op_AND_68 = LOGAND(op_RSHIFT_65, CAST(64, MSB(SN(32, 0xffff)), SN(32, 0xffff)));
	RzILOpPure *op_MUL_75 = MUL(CAST(64, MSB(CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(op_AND_54), DUP(op_AND_54))), CAST(32, MSB(DUP(op_AND_54)), DUP(op_AND_54)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_54)), DUP(op_AND_54))), CAST(32, MSB(DUP(op_AND_54)), DUP(op_AND_54))))), CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(DUP(op_AND_54)), DUP(op_AND_54))), CAST(32, MSB(DUP(op_AND_54)), DUP(op_AND_54)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_54)), DUP(op_AND_54))), CAST(32, MSB(DUP(op_AND_54)), DUP(op_AND_54))))), SEXTRACT64(CAST(64, IL_FALSE, CAST(16, MSB(op_AND_68), DUP(op_AND_68))), SN(32, 0), SN(32, 16)));
	RzILOpPure *op_LSHIFT_77 = SHIFTL0(op_MUL_75, SN(32, 1));
	RzILOpPure *op_RSHIFT_79 = SHIFTRA(op_LSHIFT_77, SN(32, 16));
	RzILOpPure *op_EQ_80 = EQ(SEXTRACT64(CAST(64, IL_FALSE, op_RSHIFT_43), SN(32, 0), SN(32, 0x20)), op_RSHIFT_79);
	RzILOpPure *op_RSHIFT_118 = SHIFTRA(DUP(Rss), SN(32, 0x20));
	RzILOpPure *op_AND_120 = LOGAND(op_RSHIFT_118, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_131 = SHIFTRA(DUP(Rtt), SN(32, 0x20));
	RzILOpPure *op_AND_134 = LOGAND(op_RSHIFT_131, CAST(64, MSB(SN(32, 0xffff)), SN(32, 0xffff)));
	RzILOpPure *op_MUL_141 = MUL(CAST(64, MSB(CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(op_AND_120), DUP(op_AND_120))), CAST(32, MSB(DUP(op_AND_120)), DUP(op_AND_120)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_120)), DUP(op_AND_120))), CAST(32, MSB(DUP(op_AND_120)), DUP(op_AND_120))))), CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(DUP(op_AND_120)), DUP(op_AND_120))), CAST(32, MSB(DUP(op_AND_120)), DUP(op_AND_120)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_120)), DUP(op_AND_120))), CAST(32, MSB(DUP(op_AND_120)), DUP(op_AND_120))))), SEXTRACT64(CAST(64, IL_FALSE, CAST(16, MSB(op_AND_134), DUP(op_AND_134))), SN(32, 0), SN(32, 16)));
	RzILOpPure *op_LSHIFT_143 = SHIFTL0(op_MUL_141, SN(32, 1));
	RzILOpPure *op_RSHIFT_145 = SHIFTRA(op_LSHIFT_143, SN(32, 16));
	RzILOpPure *op_LT_148 = SLT(op_RSHIFT_145, CAST(64, MSB(SN(32, 0)), SN(32, 0)));
	RzILOpPure *op_LSHIFT_153 = SHIFTL0(SN(64, 1), SN(32, 31));
	RzILOpPure *op_NEG_154 = NEG(op_LSHIFT_153);
	RzILOpPure *op_LSHIFT_159 = SHIFTL0(SN(64, 1), SN(32, 31));
	RzILOpPure *op_SUB_162 = SUB(op_LSHIFT_159, CAST(64, MSB(SN(32, 1)), SN(32, 1)));
	RzILOpPure *cond_163 = ITE(op_LT_148, op_NEG_154, op_SUB_162);
	RzILOpEffect *gcc_expr_164 = BRANCH(op_EQ_80, EMPTY(), set_usr_field_call_114);

	// h_tmp314 = HYB(gcc_expr_if ((sextract64(((ut64) ((((st64) ((st32) ((st64) ((st32) ((Rss >> 0x20) & 0xffffffff))))) * sextract64(((ut64) ((st16) ((Rtt >> 0x20) & ((st64) 0xffff)))), 0x0, 0x10) << 0x1) >> 0x10)), 0x0, 0x20) == ((((st64) ((st32) ((st64) ((st32) ((Rss >> 0x20) & 0xffffffff))))) * sextract64(((ut64) ((st16) ((Rtt >> 0x20) & ((st64) 0xffff)))), 0x0, 0x10) << 0x1) >> 0x10))) {{}} else {set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, ((ut32) 0x1))}, ((((((st64) ((st32) ((st64) ((st32) ((Rss >> 0x20) & 0xffffffff))))) * sextract64(((ut64) ((st16) ((Rtt >> 0x20) & ((st64) 0xffff)))), 0x0, 0x10) << 0x1) >> 0x10) < ((st64) 0x0)) ? (-(0x1 << 0x1f)) : (0x1 << 0x1f) - ((st64) 0x1)));
	RzILOpEffect *op_ASSIGN_hybrid_tmp_166 = SETL("h_tmp314", cond_163);

	// seq(HYB(gcc_expr_if ((sextract64(((ut64) ((((st64) ((st32) ((st6 ...;
	RzILOpEffect *seq_167 = SEQN(2, gcc_expr_164, op_ASSIGN_hybrid_tmp_166);

	// Rdd = ((Rdd & (~(0xffffffff << 0x20))) | ((((sextract64(((ut64) ((((st64) ((st32) ((st64) ((st32) ((Rss >> 0x20) & 0xffffffff))))) * sextract64(((ut64) ((st16) ((Rtt >> 0x20) & ((st64) 0xffff)))), 0x0, 0x10) << 0x1) >> 0x10)), 0x0, 0x20) == ((((st64) ((st32) ((st64) ((st32) ((Rss >> 0x20) & 0xffffffff))))) * sextract64(((ut64) ((st16) ((Rtt >> 0x20) & ((st64) 0xffff)))), 0x0, 0x10) << 0x1) >> 0x10)) ? ((((st64) ((st32) ((st64) ((st32) ((Rss >> 0x20) & 0xffffffff))))) * sextract64(((ut64) ((st16) ((Rtt >> 0x20) & ((st64) 0xffff)))), 0x0, 0x10) << 0x1) >> 0x10) : h_tmp314) & 0xffffffff) << 0x20));
	RzILOpPure *op_LSHIFT_5 = SHIFTL0(SN(64, 0xffffffff), SN(32, 0x20));
	RzILOpPure *op_NOT_6 = LOGNOT(op_LSHIFT_5);
	RzILOpPure *op_AND_7 = LOGAND(READ_REG(pkt, Rdd_op, true), op_NOT_6);
	RzILOpPure *op_RSHIFT_84 = SHIFTRA(DUP(Rss), SN(32, 0x20));
	RzILOpPure *op_AND_86 = LOGAND(op_RSHIFT_84, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_97 = SHIFTRA(DUP(Rtt), SN(32, 0x20));
	RzILOpPure *op_AND_100 = LOGAND(op_RSHIFT_97, CAST(64, MSB(SN(32, 0xffff)), SN(32, 0xffff)));
	RzILOpPure *op_MUL_107 = MUL(CAST(64, MSB(CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(op_AND_86), DUP(op_AND_86))), CAST(32, MSB(DUP(op_AND_86)), DUP(op_AND_86)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_86)), DUP(op_AND_86))), CAST(32, MSB(DUP(op_AND_86)), DUP(op_AND_86))))), CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(DUP(op_AND_86)), DUP(op_AND_86))), CAST(32, MSB(DUP(op_AND_86)), DUP(op_AND_86)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_86)), DUP(op_AND_86))), CAST(32, MSB(DUP(op_AND_86)), DUP(op_AND_86))))), SEXTRACT64(CAST(64, IL_FALSE, CAST(16, MSB(op_AND_100), DUP(op_AND_100))), SN(32, 0), SN(32, 16)));
	RzILOpPure *op_LSHIFT_109 = SHIFTL0(op_MUL_107, SN(32, 1));
	RzILOpPure *op_RSHIFT_111 = SHIFTRA(op_LSHIFT_109, SN(32, 16));
	RzILOpPure *cond_168 = ITE(DUP(op_EQ_80), op_RSHIFT_111, VARL("h_tmp314"));
	RzILOpPure *op_AND_170 = LOGAND(cond_168, SN(64, 0xffffffff));
	RzILOpPure *op_LSHIFT_174 = SHIFTL0(op_AND_170, SN(32, 0x20));
	RzILOpPure *op_OR_175 = LOGOR(op_AND_7, op_LSHIFT_174);
	RzILOpEffect *op_ASSIGN_176 = WRITE_REG(bundle, Rdd_op, op_OR_175);

	// seq(seq(HYB(gcc_expr_if ((sextract64(((ut64) ((((st64) ((st32) ( ...;
	RzILOpEffect *seq_177 = SEQN(2, seq_167, op_ASSIGN_176);

	// set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, ((ut32) 0x1));
	RzILOpEffect *set_usr_field_call_290 = hex_set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, CAST(32, IL_FALSE, SN(32, 1)));

	// HYB(gcc_expr_if ((sextract64(((ut64) ((((st64) ((st32) ((st64) ((st32) ((Rss >> 0x0) & 0xffffffff))))) * sextract64(((ut64) ((st16) ((Rtt >> 0x0) & ((st64) 0xffff)))), 0x0, 0x10) << 0x1) >> 0x10)), 0x0, 0x20) == ((((st64) ((st32) ((st64) ((st32) ((Rss >> 0x0) & 0xffffffff))))) * sextract64(((ut64) ((st16) ((Rtt >> 0x0) & ((st64) 0xffff)))), 0x0, 0x10) << 0x1) >> 0x10))) {{}} else {set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, ((ut32) 0x1))}, ((((((st64) ((st32) ((st64) ((st32) ((Rss >> 0x0) & 0xffffffff))))) * sextract64(((ut64) ((st16) ((Rtt >> 0x0) & ((st64) 0xffff)))), 0x0, 0x10) << 0x1) >> 0x10) < ((st64) 0x0)) ? (-(0x1 << 0x1f)) : (0x1 << 0x1f) - ((st64) 0x1)));
	RzILOpPure *op_RSHIFT_192 = SHIFTRA(DUP(Rss), SN(32, 0));
	RzILOpPure *op_AND_194 = LOGAND(op_RSHIFT_192, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_205 = SHIFTRA(DUP(Rtt), SN(32, 0));
	RzILOpPure *op_AND_208 = LOGAND(op_RSHIFT_205, CAST(64, MSB(SN(32, 0xffff)), SN(32, 0xffff)));
	RzILOpPure *op_MUL_215 = MUL(CAST(64, MSB(CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(op_AND_194), DUP(op_AND_194))), CAST(32, MSB(DUP(op_AND_194)), DUP(op_AND_194)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_194)), DUP(op_AND_194))), CAST(32, MSB(DUP(op_AND_194)), DUP(op_AND_194))))), CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(DUP(op_AND_194)), DUP(op_AND_194))), CAST(32, MSB(DUP(op_AND_194)), DUP(op_AND_194)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_194)), DUP(op_AND_194))), CAST(32, MSB(DUP(op_AND_194)), DUP(op_AND_194))))), SEXTRACT64(CAST(64, IL_FALSE, CAST(16, MSB(op_AND_208), DUP(op_AND_208))), SN(32, 0), SN(32, 16)));
	RzILOpPure *op_LSHIFT_217 = SHIFTL0(op_MUL_215, SN(32, 1));
	RzILOpPure *op_RSHIFT_219 = SHIFTRA(op_LSHIFT_217, SN(32, 16));
	RzILOpPure *op_RSHIFT_228 = SHIFTRA(DUP(Rss), SN(32, 0));
	RzILOpPure *op_AND_230 = LOGAND(op_RSHIFT_228, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_241 = SHIFTRA(DUP(Rtt), SN(32, 0));
	RzILOpPure *op_AND_244 = LOGAND(op_RSHIFT_241, CAST(64, MSB(SN(32, 0xffff)), SN(32, 0xffff)));
	RzILOpPure *op_MUL_251 = MUL(CAST(64, MSB(CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(op_AND_230), DUP(op_AND_230))), CAST(32, MSB(DUP(op_AND_230)), DUP(op_AND_230)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_230)), DUP(op_AND_230))), CAST(32, MSB(DUP(op_AND_230)), DUP(op_AND_230))))), CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(DUP(op_AND_230)), DUP(op_AND_230))), CAST(32, MSB(DUP(op_AND_230)), DUP(op_AND_230)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_230)), DUP(op_AND_230))), CAST(32, MSB(DUP(op_AND_230)), DUP(op_AND_230))))), SEXTRACT64(CAST(64, IL_FALSE, CAST(16, MSB(op_AND_244), DUP(op_AND_244))), SN(32, 0), SN(32, 16)));
	RzILOpPure *op_LSHIFT_253 = SHIFTL0(op_MUL_251, SN(32, 1));
	RzILOpPure *op_RSHIFT_255 = SHIFTRA(op_LSHIFT_253, SN(32, 16));
	RzILOpPure *op_EQ_256 = EQ(SEXTRACT64(CAST(64, IL_FALSE, op_RSHIFT_219), SN(32, 0), SN(32, 0x20)), op_RSHIFT_255);
	RzILOpPure *op_RSHIFT_294 = SHIFTRA(DUP(Rss), SN(32, 0));
	RzILOpPure *op_AND_296 = LOGAND(op_RSHIFT_294, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_307 = SHIFTRA(DUP(Rtt), SN(32, 0));
	RzILOpPure *op_AND_310 = LOGAND(op_RSHIFT_307, CAST(64, MSB(SN(32, 0xffff)), SN(32, 0xffff)));
	RzILOpPure *op_MUL_317 = MUL(CAST(64, MSB(CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(op_AND_296), DUP(op_AND_296))), CAST(32, MSB(DUP(op_AND_296)), DUP(op_AND_296)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_296)), DUP(op_AND_296))), CAST(32, MSB(DUP(op_AND_296)), DUP(op_AND_296))))), CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(DUP(op_AND_296)), DUP(op_AND_296))), CAST(32, MSB(DUP(op_AND_296)), DUP(op_AND_296)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_296)), DUP(op_AND_296))), CAST(32, MSB(DUP(op_AND_296)), DUP(op_AND_296))))), SEXTRACT64(CAST(64, IL_FALSE, CAST(16, MSB(op_AND_310), DUP(op_AND_310))), SN(32, 0), SN(32, 16)));
	RzILOpPure *op_LSHIFT_319 = SHIFTL0(op_MUL_317, SN(32, 1));
	RzILOpPure *op_RSHIFT_321 = SHIFTRA(op_LSHIFT_319, SN(32, 16));
	RzILOpPure *op_LT_324 = SLT(op_RSHIFT_321, CAST(64, MSB(SN(32, 0)), SN(32, 0)));
	RzILOpPure *op_LSHIFT_329 = SHIFTL0(SN(64, 1), SN(32, 31));
	RzILOpPure *op_NEG_330 = NEG(op_LSHIFT_329);
	RzILOpPure *op_LSHIFT_335 = SHIFTL0(SN(64, 1), SN(32, 31));
	RzILOpPure *op_SUB_338 = SUB(op_LSHIFT_335, CAST(64, MSB(SN(32, 1)), SN(32, 1)));
	RzILOpPure *cond_339 = ITE(op_LT_324, op_NEG_330, op_SUB_338);
	RzILOpEffect *gcc_expr_340 = BRANCH(op_EQ_256, EMPTY(), set_usr_field_call_290);

	// h_tmp315 = HYB(gcc_expr_if ((sextract64(((ut64) ((((st64) ((st32) ((st64) ((st32) ((Rss >> 0x0) & 0xffffffff))))) * sextract64(((ut64) ((st16) ((Rtt >> 0x0) & ((st64) 0xffff)))), 0x0, 0x10) << 0x1) >> 0x10)), 0x0, 0x20) == ((((st64) ((st32) ((st64) ((st32) ((Rss >> 0x0) & 0xffffffff))))) * sextract64(((ut64) ((st16) ((Rtt >> 0x0) & ((st64) 0xffff)))), 0x0, 0x10) << 0x1) >> 0x10))) {{}} else {set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, ((ut32) 0x1))}, ((((((st64) ((st32) ((st64) ((st32) ((Rss >> 0x0) & 0xffffffff))))) * sextract64(((ut64) ((st16) ((Rtt >> 0x0) & ((st64) 0xffff)))), 0x0, 0x10) << 0x1) >> 0x10) < ((st64) 0x0)) ? (-(0x1 << 0x1f)) : (0x1 << 0x1f) - ((st64) 0x1)));
	RzILOpEffect *op_ASSIGN_hybrid_tmp_342 = SETL("h_tmp315", cond_339);

	// seq(HYB(gcc_expr_if ((sextract64(((ut64) ((((st64) ((st32) ((st6 ...;
	RzILOpEffect *seq_343 = SEQN(2, gcc_expr_340, op_ASSIGN_hybrid_tmp_342);

	// Rdd = ((Rdd & (~(0xffffffff << 0x0))) | ((((sextract64(((ut64) ((((st64) ((st32) ((st64) ((st32) ((Rss >> 0x0) & 0xffffffff))))) * sextract64(((ut64) ((st16) ((Rtt >> 0x0) & ((st64) 0xffff)))), 0x0, 0x10) << 0x1) >> 0x10)), 0x0, 0x20) == ((((st64) ((st32) ((st64) ((st32) ((Rss >> 0x0) & 0xffffffff))))) * sextract64(((ut64) ((st16) ((Rtt >> 0x0) & ((st64) 0xffff)))), 0x0, 0x10) << 0x1) >> 0x10)) ? ((((st64) ((st32) ((st64) ((st32) ((Rss >> 0x0) & 0xffffffff))))) * sextract64(((ut64) ((st16) ((Rtt >> 0x0) & ((st64) 0xffff)))), 0x0, 0x10) << 0x1) >> 0x10) : h_tmp315) & 0xffffffff) << 0x0));
	RzILOpPure *op_LSHIFT_183 = SHIFTL0(SN(64, 0xffffffff), SN(32, 0));
	RzILOpPure *op_NOT_184 = LOGNOT(op_LSHIFT_183);
	RzILOpPure *op_AND_185 = LOGAND(READ_REG(pkt, Rdd_op, true), op_NOT_184);
	RzILOpPure *op_RSHIFT_260 = SHIFTRA(DUP(Rss), SN(32, 0));
	RzILOpPure *op_AND_262 = LOGAND(op_RSHIFT_260, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_273 = SHIFTRA(DUP(Rtt), SN(32, 0));
	RzILOpPure *op_AND_276 = LOGAND(op_RSHIFT_273, CAST(64, MSB(SN(32, 0xffff)), SN(32, 0xffff)));
	RzILOpPure *op_MUL_283 = MUL(CAST(64, MSB(CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(op_AND_262), DUP(op_AND_262))), CAST(32, MSB(DUP(op_AND_262)), DUP(op_AND_262)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_262)), DUP(op_AND_262))), CAST(32, MSB(DUP(op_AND_262)), DUP(op_AND_262))))), CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(DUP(op_AND_262)), DUP(op_AND_262))), CAST(32, MSB(DUP(op_AND_262)), DUP(op_AND_262)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_262)), DUP(op_AND_262))), CAST(32, MSB(DUP(op_AND_262)), DUP(op_AND_262))))), SEXTRACT64(CAST(64, IL_FALSE, CAST(16, MSB(op_AND_276), DUP(op_AND_276))), SN(32, 0), SN(32, 16)));
	RzILOpPure *op_LSHIFT_285 = SHIFTL0(op_MUL_283, SN(32, 1));
	RzILOpPure *op_RSHIFT_287 = SHIFTRA(op_LSHIFT_285, SN(32, 16));
	RzILOpPure *cond_344 = ITE(DUP(op_EQ_256), op_RSHIFT_287, VARL("h_tmp315"));
	RzILOpPure *op_AND_346 = LOGAND(cond_344, SN(64, 0xffffffff));
	RzILOpPure *op_LSHIFT_350 = SHIFTL0(op_AND_346, SN(32, 0));
	RzILOpPure *op_OR_351 = LOGOR(op_AND_185, op_LSHIFT_350);
	RzILOpEffect *op_ASSIGN_352 = WRITE_REG(bundle, Rdd_op, op_OR_351);

	// seq(seq(HYB(gcc_expr_if ((sextract64(((ut64) ((((st64) ((st32) ( ...;
	RzILOpEffect *seq_353 = SEQN(2, seq_343, op_ASSIGN_352);

	RzILOpEffect *instruction_sequence = SEQN(2, seq_177, seq_353);
	return instruction_sequence;
}

// Rdd = vmpywouh(Rss,Rtt):rnd:sat
RzILOpEffect *hex_il_op_m2_mmpyuh_rs0(HexInsnPktBundle *bundle) {
	const HexInsn *hi = bundle->insn;
	HexPkt *pkt = bundle->pkt;
	// READ
	const HexOp *Rdd_op = ISA2REG(hi, 'd', false);
	const HexOp *Rss_op = ISA2REG(hi, 's', false);
	RzILOpPure *Rss = READ_REG(pkt, Rss_op, false);
	const HexOp *Rtt_op = ISA2REG(hi, 't', false);
	RzILOpPure *Rtt = READ_REG(pkt, Rtt_op, false);

	// set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, ((ut32) 0x1));
	RzILOpEffect *set_usr_field_call_129 = hex_set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, CAST(32, IL_FALSE, SN(32, 1)));

	// HYB(gcc_expr_if ((sextract64(((ut64) ((((st64) ((ut64) ((st64) ((st32) ((st64) ((st32) ((Rss >> 0x20) & 0xffffffff)))))) * extract64(((ut64) ((ut16) ((Rtt >> 0x30) & ((st64) 0xffff)))), 0x0, 0x10)) << 0x0) + ((st64) 0x8000) >> 0x10)), 0x0, 0x20) == ((((st64) ((ut64) ((st64) ((st32) ((st64) ((st32) ((Rss >> 0x20) & 0xffffffff)))))) * extract64(((ut64) ((ut16) ((Rtt >> 0x30) & ((st64) 0xffff)))), 0x0, 0x10)) << 0x0) + ((st64) 0x8000) >> 0x10))) {{}} else {set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, ((ut32) 0x1))}, ((((((st64) ((ut64) ((st64) ((st32) ((st64) ((st32) ((Rss >> 0x20) & 0xffffffff)))))) * extract64(((ut64) ((ut16) ((Rtt >> 0x30) & ((st64) 0xffff)))), 0x0, 0x10)) << 0x0) + ((st64) 0x8000) >> 0x10) < ((st64) 0x0)) ? (-(0x1 << 0x1f)) : (0x1 << 0x1f) - ((st64) 0x1)));
	RzILOpPure *op_RSHIFT_15 = SHIFTRA(Rss, SN(32, 0x20));
	RzILOpPure *op_AND_17 = LOGAND(op_RSHIFT_15, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_29 = SHIFTRA(Rtt, SN(32, 0x30));
	RzILOpPure *op_AND_32 = LOGAND(op_RSHIFT_29, CAST(64, MSB(SN(32, 0xffff)), SN(32, 0xffff)));
	RzILOpPure *op_MUL_40 = MUL(CAST(64, IL_FALSE, CAST(64, MSB(CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(op_AND_17), DUP(op_AND_17))), CAST(32, MSB(DUP(op_AND_17)), DUP(op_AND_17)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_17)), DUP(op_AND_17))), CAST(32, MSB(DUP(op_AND_17)), DUP(op_AND_17))))), CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(DUP(op_AND_17)), DUP(op_AND_17))), CAST(32, MSB(DUP(op_AND_17)), DUP(op_AND_17)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_17)), DUP(op_AND_17))), CAST(32, MSB(DUP(op_AND_17)), DUP(op_AND_17)))))), EXTRACT64(CAST(64, IL_FALSE, CAST(16, IL_FALSE, op_AND_32)), SN(32, 0), SN(32, 16)));
	RzILOpPure *op_LSHIFT_43 = SHIFTL0(CAST(64, IL_FALSE, op_MUL_40), SN(32, 0));
	RzILOpPure *op_ADD_46 = ADD(op_LSHIFT_43, CAST(64, MSB(SN(32, 0x8000)), SN(32, 0x8000)));
	RzILOpPure *op_RSHIFT_48 = SHIFTRA(op_ADD_46, SN(32, 16));
	RzILOpPure *op_RSHIFT_57 = SHIFTRA(DUP(Rss), SN(32, 0x20));
	RzILOpPure *op_AND_59 = LOGAND(op_RSHIFT_57, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_70 = SHIFTRA(DUP(Rtt), SN(32, 0x30));
	RzILOpPure *op_AND_73 = LOGAND(op_RSHIFT_70, CAST(64, MSB(SN(32, 0xffff)), SN(32, 0xffff)));
	RzILOpPure *op_MUL_81 = MUL(CAST(64, IL_FALSE, CAST(64, MSB(CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(op_AND_59), DUP(op_AND_59))), CAST(32, MSB(DUP(op_AND_59)), DUP(op_AND_59)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_59)), DUP(op_AND_59))), CAST(32, MSB(DUP(op_AND_59)), DUP(op_AND_59))))), CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(DUP(op_AND_59)), DUP(op_AND_59))), CAST(32, MSB(DUP(op_AND_59)), DUP(op_AND_59)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_59)), DUP(op_AND_59))), CAST(32, MSB(DUP(op_AND_59)), DUP(op_AND_59)))))), EXTRACT64(CAST(64, IL_FALSE, CAST(16, IL_FALSE, op_AND_73)), SN(32, 0), SN(32, 16)));
	RzILOpPure *op_LSHIFT_84 = SHIFTL0(CAST(64, IL_FALSE, op_MUL_81), SN(32, 0));
	RzILOpPure *op_ADD_87 = ADD(op_LSHIFT_84, CAST(64, MSB(SN(32, 0x8000)), SN(32, 0x8000)));
	RzILOpPure *op_RSHIFT_89 = SHIFTRA(op_ADD_87, SN(32, 16));
	RzILOpPure *op_EQ_90 = EQ(SEXTRACT64(CAST(64, IL_FALSE, op_RSHIFT_48), SN(32, 0), SN(32, 0x20)), op_RSHIFT_89);
	RzILOpPure *op_RSHIFT_133 = SHIFTRA(DUP(Rss), SN(32, 0x20));
	RzILOpPure *op_AND_135 = LOGAND(op_RSHIFT_133, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_146 = SHIFTRA(DUP(Rtt), SN(32, 0x30));
	RzILOpPure *op_AND_149 = LOGAND(op_RSHIFT_146, CAST(64, MSB(SN(32, 0xffff)), SN(32, 0xffff)));
	RzILOpPure *op_MUL_157 = MUL(CAST(64, IL_FALSE, CAST(64, MSB(CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(op_AND_135), DUP(op_AND_135))), CAST(32, MSB(DUP(op_AND_135)), DUP(op_AND_135)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_135)), DUP(op_AND_135))), CAST(32, MSB(DUP(op_AND_135)), DUP(op_AND_135))))), CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(DUP(op_AND_135)), DUP(op_AND_135))), CAST(32, MSB(DUP(op_AND_135)), DUP(op_AND_135)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_135)), DUP(op_AND_135))), CAST(32, MSB(DUP(op_AND_135)), DUP(op_AND_135)))))), EXTRACT64(CAST(64, IL_FALSE, CAST(16, IL_FALSE, op_AND_149)), SN(32, 0), SN(32, 16)));
	RzILOpPure *op_LSHIFT_160 = SHIFTL0(CAST(64, IL_FALSE, op_MUL_157), SN(32, 0));
	RzILOpPure *op_ADD_163 = ADD(op_LSHIFT_160, CAST(64, MSB(SN(32, 0x8000)), SN(32, 0x8000)));
	RzILOpPure *op_RSHIFT_165 = SHIFTRA(op_ADD_163, SN(32, 16));
	RzILOpPure *op_LT_168 = SLT(op_RSHIFT_165, CAST(64, MSB(SN(32, 0)), SN(32, 0)));
	RzILOpPure *op_LSHIFT_173 = SHIFTL0(SN(64, 1), SN(32, 31));
	RzILOpPure *op_NEG_174 = NEG(op_LSHIFT_173);
	RzILOpPure *op_LSHIFT_179 = SHIFTL0(SN(64, 1), SN(32, 31));
	RzILOpPure *op_SUB_182 = SUB(op_LSHIFT_179, CAST(64, MSB(SN(32, 1)), SN(32, 1)));
	RzILOpPure *cond_183 = ITE(op_LT_168, op_NEG_174, op_SUB_182);
	RzILOpEffect *gcc_expr_184 = BRANCH(op_EQ_90, EMPTY(), set_usr_field_call_129);

	// h_tmp316 = HYB(gcc_expr_if ((sextract64(((ut64) ((((st64) ((ut64) ((st64) ((st32) ((st64) ((st32) ((Rss >> 0x20) & 0xffffffff)))))) * extract64(((ut64) ((ut16) ((Rtt >> 0x30) & ((st64) 0xffff)))), 0x0, 0x10)) << 0x0) + ((st64) 0x8000) >> 0x10)), 0x0, 0x20) == ((((st64) ((ut64) ((st64) ((st32) ((st64) ((st32) ((Rss >> 0x20) & 0xffffffff)))))) * extract64(((ut64) ((ut16) ((Rtt >> 0x30) & ((st64) 0xffff)))), 0x0, 0x10)) << 0x0) + ((st64) 0x8000) >> 0x10))) {{}} else {set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, ((ut32) 0x1))}, ((((((st64) ((ut64) ((st64) ((st32) ((st64) ((st32) ((Rss >> 0x20) & 0xffffffff)))))) * extract64(((ut64) ((ut16) ((Rtt >> 0x30) & ((st64) 0xffff)))), 0x0, 0x10)) << 0x0) + ((st64) 0x8000) >> 0x10) < ((st64) 0x0)) ? (-(0x1 << 0x1f)) : (0x1 << 0x1f) - ((st64) 0x1)));
	RzILOpEffect *op_ASSIGN_hybrid_tmp_186 = SETL("h_tmp316", cond_183);

	// seq(HYB(gcc_expr_if ((sextract64(((ut64) ((((st64) ((ut64) ((st6 ...;
	RzILOpEffect *seq_187 = SEQN(2, gcc_expr_184, op_ASSIGN_hybrid_tmp_186);

	// Rdd = ((Rdd & (~(0xffffffff << 0x20))) | ((((sextract64(((ut64) ((((st64) ((ut64) ((st64) ((st32) ((st64) ((st32) ((Rss >> 0x20) & 0xffffffff)))))) * extract64(((ut64) ((ut16) ((Rtt >> 0x30) & ((st64) 0xffff)))), 0x0, 0x10)) << 0x0) + ((st64) 0x8000) >> 0x10)), 0x0, 0x20) == ((((st64) ((ut64) ((st64) ((st32) ((st64) ((st32) ((Rss >> 0x20) & 0xffffffff)))))) * extract64(((ut64) ((ut16) ((Rtt >> 0x30) & ((st64) 0xffff)))), 0x0, 0x10)) << 0x0) + ((st64) 0x8000) >> 0x10)) ? ((((st64) ((ut64) ((st64) ((st32) ((st64) ((st32) ((Rss >> 0x20) & 0xffffffff)))))) * extract64(((ut64) ((ut16) ((Rtt >> 0x30) & ((st64) 0xffff)))), 0x0, 0x10)) << 0x0) + ((st64) 0x8000) >> 0x10) : h_tmp316) & 0xffffffff) << 0x20));
	RzILOpPure *op_LSHIFT_5 = SHIFTL0(SN(64, 0xffffffff), SN(32, 0x20));
	RzILOpPure *op_NOT_6 = LOGNOT(op_LSHIFT_5);
	RzILOpPure *op_AND_7 = LOGAND(READ_REG(pkt, Rdd_op, true), op_NOT_6);
	RzILOpPure *op_RSHIFT_94 = SHIFTRA(DUP(Rss), SN(32, 0x20));
	RzILOpPure *op_AND_96 = LOGAND(op_RSHIFT_94, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_107 = SHIFTRA(DUP(Rtt), SN(32, 0x30));
	RzILOpPure *op_AND_110 = LOGAND(op_RSHIFT_107, CAST(64, MSB(SN(32, 0xffff)), SN(32, 0xffff)));
	RzILOpPure *op_MUL_118 = MUL(CAST(64, IL_FALSE, CAST(64, MSB(CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(op_AND_96), DUP(op_AND_96))), CAST(32, MSB(DUP(op_AND_96)), DUP(op_AND_96)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_96)), DUP(op_AND_96))), CAST(32, MSB(DUP(op_AND_96)), DUP(op_AND_96))))), CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(DUP(op_AND_96)), DUP(op_AND_96))), CAST(32, MSB(DUP(op_AND_96)), DUP(op_AND_96)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_96)), DUP(op_AND_96))), CAST(32, MSB(DUP(op_AND_96)), DUP(op_AND_96)))))), EXTRACT64(CAST(64, IL_FALSE, CAST(16, IL_FALSE, op_AND_110)), SN(32, 0), SN(32, 16)));
	RzILOpPure *op_LSHIFT_121 = SHIFTL0(CAST(64, IL_FALSE, op_MUL_118), SN(32, 0));
	RzILOpPure *op_ADD_124 = ADD(op_LSHIFT_121, CAST(64, MSB(SN(32, 0x8000)), SN(32, 0x8000)));
	RzILOpPure *op_RSHIFT_126 = SHIFTRA(op_ADD_124, SN(32, 16));
	RzILOpPure *cond_188 = ITE(DUP(op_EQ_90), op_RSHIFT_126, VARL("h_tmp316"));
	RzILOpPure *op_AND_190 = LOGAND(cond_188, SN(64, 0xffffffff));
	RzILOpPure *op_LSHIFT_194 = SHIFTL0(op_AND_190, SN(32, 0x20));
	RzILOpPure *op_OR_195 = LOGOR(op_AND_7, op_LSHIFT_194);
	RzILOpEffect *op_ASSIGN_196 = WRITE_REG(bundle, Rdd_op, op_OR_195);

	// seq(seq(HYB(gcc_expr_if ((sextract64(((ut64) ((((st64) ((ut64) ( ...;
	RzILOpEffect *seq_197 = SEQN(2, seq_187, op_ASSIGN_196);

	// set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, ((ut32) 0x1));
	RzILOpEffect *set_usr_field_call_325 = hex_set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, CAST(32, IL_FALSE, SN(32, 1)));

	// HYB(gcc_expr_if ((sextract64(((ut64) ((((st64) ((ut64) ((st64) ((st32) ((st64) ((st32) ((Rss >> 0x0) & 0xffffffff)))))) * extract64(((ut64) ((ut16) ((Rtt >> 0x10) & ((st64) 0xffff)))), 0x0, 0x10)) << 0x0) + ((st64) 0x8000) >> 0x10)), 0x0, 0x20) == ((((st64) ((ut64) ((st64) ((st32) ((st64) ((st32) ((Rss >> 0x0) & 0xffffffff)))))) * extract64(((ut64) ((ut16) ((Rtt >> 0x10) & ((st64) 0xffff)))), 0x0, 0x10)) << 0x0) + ((st64) 0x8000) >> 0x10))) {{}} else {set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, ((ut32) 0x1))}, ((((((st64) ((ut64) ((st64) ((st32) ((st64) ((st32) ((Rss >> 0x0) & 0xffffffff)))))) * extract64(((ut64) ((ut16) ((Rtt >> 0x10) & ((st64) 0xffff)))), 0x0, 0x10)) << 0x0) + ((st64) 0x8000) >> 0x10) < ((st64) 0x0)) ? (-(0x1 << 0x1f)) : (0x1 << 0x1f) - ((st64) 0x1)));
	RzILOpPure *op_RSHIFT_212 = SHIFTRA(DUP(Rss), SN(32, 0));
	RzILOpPure *op_AND_214 = LOGAND(op_RSHIFT_212, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_225 = SHIFTRA(DUP(Rtt), SN(32, 16));
	RzILOpPure *op_AND_228 = LOGAND(op_RSHIFT_225, CAST(64, MSB(SN(32, 0xffff)), SN(32, 0xffff)));
	RzILOpPure *op_MUL_236 = MUL(CAST(64, IL_FALSE, CAST(64, MSB(CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(op_AND_214), DUP(op_AND_214))), CAST(32, MSB(DUP(op_AND_214)), DUP(op_AND_214)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_214)), DUP(op_AND_214))), CAST(32, MSB(DUP(op_AND_214)), DUP(op_AND_214))))), CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(DUP(op_AND_214)), DUP(op_AND_214))), CAST(32, MSB(DUP(op_AND_214)), DUP(op_AND_214)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_214)), DUP(op_AND_214))), CAST(32, MSB(DUP(op_AND_214)), DUP(op_AND_214)))))), EXTRACT64(CAST(64, IL_FALSE, CAST(16, IL_FALSE, op_AND_228)), SN(32, 0), SN(32, 16)));
	RzILOpPure *op_LSHIFT_239 = SHIFTL0(CAST(64, IL_FALSE, op_MUL_236), SN(32, 0));
	RzILOpPure *op_ADD_242 = ADD(op_LSHIFT_239, CAST(64, MSB(SN(32, 0x8000)), SN(32, 0x8000)));
	RzILOpPure *op_RSHIFT_244 = SHIFTRA(op_ADD_242, SN(32, 16));
	RzILOpPure *op_RSHIFT_253 = SHIFTRA(DUP(Rss), SN(32, 0));
	RzILOpPure *op_AND_255 = LOGAND(op_RSHIFT_253, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_266 = SHIFTRA(DUP(Rtt), SN(32, 16));
	RzILOpPure *op_AND_269 = LOGAND(op_RSHIFT_266, CAST(64, MSB(SN(32, 0xffff)), SN(32, 0xffff)));
	RzILOpPure *op_MUL_277 = MUL(CAST(64, IL_FALSE, CAST(64, MSB(CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(op_AND_255), DUP(op_AND_255))), CAST(32, MSB(DUP(op_AND_255)), DUP(op_AND_255)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_255)), DUP(op_AND_255))), CAST(32, MSB(DUP(op_AND_255)), DUP(op_AND_255))))), CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(DUP(op_AND_255)), DUP(op_AND_255))), CAST(32, MSB(DUP(op_AND_255)), DUP(op_AND_255)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_255)), DUP(op_AND_255))), CAST(32, MSB(DUP(op_AND_255)), DUP(op_AND_255)))))), EXTRACT64(CAST(64, IL_FALSE, CAST(16, IL_FALSE, op_AND_269)), SN(32, 0), SN(32, 16)));
	RzILOpPure *op_LSHIFT_280 = SHIFTL0(CAST(64, IL_FALSE, op_MUL_277), SN(32, 0));
	RzILOpPure *op_ADD_283 = ADD(op_LSHIFT_280, CAST(64, MSB(SN(32, 0x8000)), SN(32, 0x8000)));
	RzILOpPure *op_RSHIFT_285 = SHIFTRA(op_ADD_283, SN(32, 16));
	RzILOpPure *op_EQ_286 = EQ(SEXTRACT64(CAST(64, IL_FALSE, op_RSHIFT_244), SN(32, 0), SN(32, 0x20)), op_RSHIFT_285);
	RzILOpPure *op_RSHIFT_329 = SHIFTRA(DUP(Rss), SN(32, 0));
	RzILOpPure *op_AND_331 = LOGAND(op_RSHIFT_329, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_342 = SHIFTRA(DUP(Rtt), SN(32, 16));
	RzILOpPure *op_AND_345 = LOGAND(op_RSHIFT_342, CAST(64, MSB(SN(32, 0xffff)), SN(32, 0xffff)));
	RzILOpPure *op_MUL_353 = MUL(CAST(64, IL_FALSE, CAST(64, MSB(CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(op_AND_331), DUP(op_AND_331))), CAST(32, MSB(DUP(op_AND_331)), DUP(op_AND_331)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_331)), DUP(op_AND_331))), CAST(32, MSB(DUP(op_AND_331)), DUP(op_AND_331))))), CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(DUP(op_AND_331)), DUP(op_AND_331))), CAST(32, MSB(DUP(op_AND_331)), DUP(op_AND_331)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_331)), DUP(op_AND_331))), CAST(32, MSB(DUP(op_AND_331)), DUP(op_AND_331)))))), EXTRACT64(CAST(64, IL_FALSE, CAST(16, IL_FALSE, op_AND_345)), SN(32, 0), SN(32, 16)));
	RzILOpPure *op_LSHIFT_356 = SHIFTL0(CAST(64, IL_FALSE, op_MUL_353), SN(32, 0));
	RzILOpPure *op_ADD_359 = ADD(op_LSHIFT_356, CAST(64, MSB(SN(32, 0x8000)), SN(32, 0x8000)));
	RzILOpPure *op_RSHIFT_361 = SHIFTRA(op_ADD_359, SN(32, 16));
	RzILOpPure *op_LT_364 = SLT(op_RSHIFT_361, CAST(64, MSB(SN(32, 0)), SN(32, 0)));
	RzILOpPure *op_LSHIFT_369 = SHIFTL0(SN(64, 1), SN(32, 31));
	RzILOpPure *op_NEG_370 = NEG(op_LSHIFT_369);
	RzILOpPure *op_LSHIFT_375 = SHIFTL0(SN(64, 1), SN(32, 31));
	RzILOpPure *op_SUB_378 = SUB(op_LSHIFT_375, CAST(64, MSB(SN(32, 1)), SN(32, 1)));
	RzILOpPure *cond_379 = ITE(op_LT_364, op_NEG_370, op_SUB_378);
	RzILOpEffect *gcc_expr_380 = BRANCH(op_EQ_286, EMPTY(), set_usr_field_call_325);

	// h_tmp317 = HYB(gcc_expr_if ((sextract64(((ut64) ((((st64) ((ut64) ((st64) ((st32) ((st64) ((st32) ((Rss >> 0x0) & 0xffffffff)))))) * extract64(((ut64) ((ut16) ((Rtt >> 0x10) & ((st64) 0xffff)))), 0x0, 0x10)) << 0x0) + ((st64) 0x8000) >> 0x10)), 0x0, 0x20) == ((((st64) ((ut64) ((st64) ((st32) ((st64) ((st32) ((Rss >> 0x0) & 0xffffffff)))))) * extract64(((ut64) ((ut16) ((Rtt >> 0x10) & ((st64) 0xffff)))), 0x0, 0x10)) << 0x0) + ((st64) 0x8000) >> 0x10))) {{}} else {set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, ((ut32) 0x1))}, ((((((st64) ((ut64) ((st64) ((st32) ((st64) ((st32) ((Rss >> 0x0) & 0xffffffff)))))) * extract64(((ut64) ((ut16) ((Rtt >> 0x10) & ((st64) 0xffff)))), 0x0, 0x10)) << 0x0) + ((st64) 0x8000) >> 0x10) < ((st64) 0x0)) ? (-(0x1 << 0x1f)) : (0x1 << 0x1f) - ((st64) 0x1)));
	RzILOpEffect *op_ASSIGN_hybrid_tmp_382 = SETL("h_tmp317", cond_379);

	// seq(HYB(gcc_expr_if ((sextract64(((ut64) ((((st64) ((ut64) ((st6 ...;
	RzILOpEffect *seq_383 = SEQN(2, gcc_expr_380, op_ASSIGN_hybrid_tmp_382);

	// Rdd = ((Rdd & (~(0xffffffff << 0x0))) | ((((sextract64(((ut64) ((((st64) ((ut64) ((st64) ((st32) ((st64) ((st32) ((Rss >> 0x0) & 0xffffffff)))))) * extract64(((ut64) ((ut16) ((Rtt >> 0x10) & ((st64) 0xffff)))), 0x0, 0x10)) << 0x0) + ((st64) 0x8000) >> 0x10)), 0x0, 0x20) == ((((st64) ((ut64) ((st64) ((st32) ((st64) ((st32) ((Rss >> 0x0) & 0xffffffff)))))) * extract64(((ut64) ((ut16) ((Rtt >> 0x10) & ((st64) 0xffff)))), 0x0, 0x10)) << 0x0) + ((st64) 0x8000) >> 0x10)) ? ((((st64) ((ut64) ((st64) ((st32) ((st64) ((st32) ((Rss >> 0x0) & 0xffffffff)))))) * extract64(((ut64) ((ut16) ((Rtt >> 0x10) & ((st64) 0xffff)))), 0x0, 0x10)) << 0x0) + ((st64) 0x8000) >> 0x10) : h_tmp317) & 0xffffffff) << 0x0));
	RzILOpPure *op_LSHIFT_203 = SHIFTL0(SN(64, 0xffffffff), SN(32, 0));
	RzILOpPure *op_NOT_204 = LOGNOT(op_LSHIFT_203);
	RzILOpPure *op_AND_205 = LOGAND(READ_REG(pkt, Rdd_op, true), op_NOT_204);
	RzILOpPure *op_RSHIFT_290 = SHIFTRA(DUP(Rss), SN(32, 0));
	RzILOpPure *op_AND_292 = LOGAND(op_RSHIFT_290, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_303 = SHIFTRA(DUP(Rtt), SN(32, 16));
	RzILOpPure *op_AND_306 = LOGAND(op_RSHIFT_303, CAST(64, MSB(SN(32, 0xffff)), SN(32, 0xffff)));
	RzILOpPure *op_MUL_314 = MUL(CAST(64, IL_FALSE, CAST(64, MSB(CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(op_AND_292), DUP(op_AND_292))), CAST(32, MSB(DUP(op_AND_292)), DUP(op_AND_292)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_292)), DUP(op_AND_292))), CAST(32, MSB(DUP(op_AND_292)), DUP(op_AND_292))))), CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(DUP(op_AND_292)), DUP(op_AND_292))), CAST(32, MSB(DUP(op_AND_292)), DUP(op_AND_292)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_292)), DUP(op_AND_292))), CAST(32, MSB(DUP(op_AND_292)), DUP(op_AND_292)))))), EXTRACT64(CAST(64, IL_FALSE, CAST(16, IL_FALSE, op_AND_306)), SN(32, 0), SN(32, 16)));
	RzILOpPure *op_LSHIFT_317 = SHIFTL0(CAST(64, IL_FALSE, op_MUL_314), SN(32, 0));
	RzILOpPure *op_ADD_320 = ADD(op_LSHIFT_317, CAST(64, MSB(SN(32, 0x8000)), SN(32, 0x8000)));
	RzILOpPure *op_RSHIFT_322 = SHIFTRA(op_ADD_320, SN(32, 16));
	RzILOpPure *cond_384 = ITE(DUP(op_EQ_286), op_RSHIFT_322, VARL("h_tmp317"));
	RzILOpPure *op_AND_386 = LOGAND(cond_384, SN(64, 0xffffffff));
	RzILOpPure *op_LSHIFT_390 = SHIFTL0(op_AND_386, SN(32, 0));
	RzILOpPure *op_OR_391 = LOGOR(op_AND_205, op_LSHIFT_390);
	RzILOpEffect *op_ASSIGN_392 = WRITE_REG(bundle, Rdd_op, op_OR_391);

	// seq(seq(HYB(gcc_expr_if ((sextract64(((ut64) ((((st64) ((ut64) ( ...;
	RzILOpEffect *seq_393 = SEQN(2, seq_383, op_ASSIGN_392);

	RzILOpEffect *instruction_sequence = SEQN(2, seq_197, seq_393);
	return instruction_sequence;
}

// Rdd = vmpywouh(Rss,Rtt):<<1:rnd:sat
RzILOpEffect *hex_il_op_m2_mmpyuh_rs1(HexInsnPktBundle *bundle) {
	const HexInsn *hi = bundle->insn;
	HexPkt *pkt = bundle->pkt;
	// READ
	const HexOp *Rdd_op = ISA2REG(hi, 'd', false);
	const HexOp *Rss_op = ISA2REG(hi, 's', false);
	RzILOpPure *Rss = READ_REG(pkt, Rss_op, false);
	const HexOp *Rtt_op = ISA2REG(hi, 't', false);
	RzILOpPure *Rtt = READ_REG(pkt, Rtt_op, false);

	// set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, ((ut32) 0x1));
	RzILOpEffect *set_usr_field_call_129 = hex_set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, CAST(32, IL_FALSE, SN(32, 1)));

	// HYB(gcc_expr_if ((sextract64(((ut64) ((((st64) ((ut64) ((st64) ((st32) ((st64) ((st32) ((Rss >> 0x20) & 0xffffffff)))))) * extract64(((ut64) ((ut16) ((Rtt >> 0x30) & ((st64) 0xffff)))), 0x0, 0x10)) << 0x1) + ((st64) 0x8000) >> 0x10)), 0x0, 0x20) == ((((st64) ((ut64) ((st64) ((st32) ((st64) ((st32) ((Rss >> 0x20) & 0xffffffff)))))) * extract64(((ut64) ((ut16) ((Rtt >> 0x30) & ((st64) 0xffff)))), 0x0, 0x10)) << 0x1) + ((st64) 0x8000) >> 0x10))) {{}} else {set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, ((ut32) 0x1))}, ((((((st64) ((ut64) ((st64) ((st32) ((st64) ((st32) ((Rss >> 0x20) & 0xffffffff)))))) * extract64(((ut64) ((ut16) ((Rtt >> 0x30) & ((st64) 0xffff)))), 0x0, 0x10)) << 0x1) + ((st64) 0x8000) >> 0x10) < ((st64) 0x0)) ? (-(0x1 << 0x1f)) : (0x1 << 0x1f) - ((st64) 0x1)));
	RzILOpPure *op_RSHIFT_15 = SHIFTRA(Rss, SN(32, 0x20));
	RzILOpPure *op_AND_17 = LOGAND(op_RSHIFT_15, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_29 = SHIFTRA(Rtt, SN(32, 0x30));
	RzILOpPure *op_AND_32 = LOGAND(op_RSHIFT_29, CAST(64, MSB(SN(32, 0xffff)), SN(32, 0xffff)));
	RzILOpPure *op_MUL_40 = MUL(CAST(64, IL_FALSE, CAST(64, MSB(CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(op_AND_17), DUP(op_AND_17))), CAST(32, MSB(DUP(op_AND_17)), DUP(op_AND_17)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_17)), DUP(op_AND_17))), CAST(32, MSB(DUP(op_AND_17)), DUP(op_AND_17))))), CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(DUP(op_AND_17)), DUP(op_AND_17))), CAST(32, MSB(DUP(op_AND_17)), DUP(op_AND_17)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_17)), DUP(op_AND_17))), CAST(32, MSB(DUP(op_AND_17)), DUP(op_AND_17)))))), EXTRACT64(CAST(64, IL_FALSE, CAST(16, IL_FALSE, op_AND_32)), SN(32, 0), SN(32, 16)));
	RzILOpPure *op_LSHIFT_43 = SHIFTL0(CAST(64, IL_FALSE, op_MUL_40), SN(32, 1));
	RzILOpPure *op_ADD_46 = ADD(op_LSHIFT_43, CAST(64, MSB(SN(32, 0x8000)), SN(32, 0x8000)));
	RzILOpPure *op_RSHIFT_48 = SHIFTRA(op_ADD_46, SN(32, 16));
	RzILOpPure *op_RSHIFT_57 = SHIFTRA(DUP(Rss), SN(32, 0x20));
	RzILOpPure *op_AND_59 = LOGAND(op_RSHIFT_57, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_70 = SHIFTRA(DUP(Rtt), SN(32, 0x30));
	RzILOpPure *op_AND_73 = LOGAND(op_RSHIFT_70, CAST(64, MSB(SN(32, 0xffff)), SN(32, 0xffff)));
	RzILOpPure *op_MUL_81 = MUL(CAST(64, IL_FALSE, CAST(64, MSB(CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(op_AND_59), DUP(op_AND_59))), CAST(32, MSB(DUP(op_AND_59)), DUP(op_AND_59)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_59)), DUP(op_AND_59))), CAST(32, MSB(DUP(op_AND_59)), DUP(op_AND_59))))), CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(DUP(op_AND_59)), DUP(op_AND_59))), CAST(32, MSB(DUP(op_AND_59)), DUP(op_AND_59)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_59)), DUP(op_AND_59))), CAST(32, MSB(DUP(op_AND_59)), DUP(op_AND_59)))))), EXTRACT64(CAST(64, IL_FALSE, CAST(16, IL_FALSE, op_AND_73)), SN(32, 0), SN(32, 16)));
	RzILOpPure *op_LSHIFT_84 = SHIFTL0(CAST(64, IL_FALSE, op_MUL_81), SN(32, 1));
	RzILOpPure *op_ADD_87 = ADD(op_LSHIFT_84, CAST(64, MSB(SN(32, 0x8000)), SN(32, 0x8000)));
	RzILOpPure *op_RSHIFT_89 = SHIFTRA(op_ADD_87, SN(32, 16));
	RzILOpPure *op_EQ_90 = EQ(SEXTRACT64(CAST(64, IL_FALSE, op_RSHIFT_48), SN(32, 0), SN(32, 0x20)), op_RSHIFT_89);
	RzILOpPure *op_RSHIFT_133 = SHIFTRA(DUP(Rss), SN(32, 0x20));
	RzILOpPure *op_AND_135 = LOGAND(op_RSHIFT_133, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_146 = SHIFTRA(DUP(Rtt), SN(32, 0x30));
	RzILOpPure *op_AND_149 = LOGAND(op_RSHIFT_146, CAST(64, MSB(SN(32, 0xffff)), SN(32, 0xffff)));
	RzILOpPure *op_MUL_157 = MUL(CAST(64, IL_FALSE, CAST(64, MSB(CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(op_AND_135), DUP(op_AND_135))), CAST(32, MSB(DUP(op_AND_135)), DUP(op_AND_135)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_135)), DUP(op_AND_135))), CAST(32, MSB(DUP(op_AND_135)), DUP(op_AND_135))))), CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(DUP(op_AND_135)), DUP(op_AND_135))), CAST(32, MSB(DUP(op_AND_135)), DUP(op_AND_135)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_135)), DUP(op_AND_135))), CAST(32, MSB(DUP(op_AND_135)), DUP(op_AND_135)))))), EXTRACT64(CAST(64, IL_FALSE, CAST(16, IL_FALSE, op_AND_149)), SN(32, 0), SN(32, 16)));
	RzILOpPure *op_LSHIFT_160 = SHIFTL0(CAST(64, IL_FALSE, op_MUL_157), SN(32, 1));
	RzILOpPure *op_ADD_163 = ADD(op_LSHIFT_160, CAST(64, MSB(SN(32, 0x8000)), SN(32, 0x8000)));
	RzILOpPure *op_RSHIFT_165 = SHIFTRA(op_ADD_163, SN(32, 16));
	RzILOpPure *op_LT_168 = SLT(op_RSHIFT_165, CAST(64, MSB(SN(32, 0)), SN(32, 0)));
	RzILOpPure *op_LSHIFT_173 = SHIFTL0(SN(64, 1), SN(32, 31));
	RzILOpPure *op_NEG_174 = NEG(op_LSHIFT_173);
	RzILOpPure *op_LSHIFT_179 = SHIFTL0(SN(64, 1), SN(32, 31));
	RzILOpPure *op_SUB_182 = SUB(op_LSHIFT_179, CAST(64, MSB(SN(32, 1)), SN(32, 1)));
	RzILOpPure *cond_183 = ITE(op_LT_168, op_NEG_174, op_SUB_182);
	RzILOpEffect *gcc_expr_184 = BRANCH(op_EQ_90, EMPTY(), set_usr_field_call_129);

	// h_tmp318 = HYB(gcc_expr_if ((sextract64(((ut64) ((((st64) ((ut64) ((st64) ((st32) ((st64) ((st32) ((Rss >> 0x20) & 0xffffffff)))))) * extract64(((ut64) ((ut16) ((Rtt >> 0x30) & ((st64) 0xffff)))), 0x0, 0x10)) << 0x1) + ((st64) 0x8000) >> 0x10)), 0x0, 0x20) == ((((st64) ((ut64) ((st64) ((st32) ((st64) ((st32) ((Rss >> 0x20) & 0xffffffff)))))) * extract64(((ut64) ((ut16) ((Rtt >> 0x30) & ((st64) 0xffff)))), 0x0, 0x10)) << 0x1) + ((st64) 0x8000) >> 0x10))) {{}} else {set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, ((ut32) 0x1))}, ((((((st64) ((ut64) ((st64) ((st32) ((st64) ((st32) ((Rss >> 0x20) & 0xffffffff)))))) * extract64(((ut64) ((ut16) ((Rtt >> 0x30) & ((st64) 0xffff)))), 0x0, 0x10)) << 0x1) + ((st64) 0x8000) >> 0x10) < ((st64) 0x0)) ? (-(0x1 << 0x1f)) : (0x1 << 0x1f) - ((st64) 0x1)));
	RzILOpEffect *op_ASSIGN_hybrid_tmp_186 = SETL("h_tmp318", cond_183);

	// seq(HYB(gcc_expr_if ((sextract64(((ut64) ((((st64) ((ut64) ((st6 ...;
	RzILOpEffect *seq_187 = SEQN(2, gcc_expr_184, op_ASSIGN_hybrid_tmp_186);

	// Rdd = ((Rdd & (~(0xffffffff << 0x20))) | ((((sextract64(((ut64) ((((st64) ((ut64) ((st64) ((st32) ((st64) ((st32) ((Rss >> 0x20) & 0xffffffff)))))) * extract64(((ut64) ((ut16) ((Rtt >> 0x30) & ((st64) 0xffff)))), 0x0, 0x10)) << 0x1) + ((st64) 0x8000) >> 0x10)), 0x0, 0x20) == ((((st64) ((ut64) ((st64) ((st32) ((st64) ((st32) ((Rss >> 0x20) & 0xffffffff)))))) * extract64(((ut64) ((ut16) ((Rtt >> 0x30) & ((st64) 0xffff)))), 0x0, 0x10)) << 0x1) + ((st64) 0x8000) >> 0x10)) ? ((((st64) ((ut64) ((st64) ((st32) ((st64) ((st32) ((Rss >> 0x20) & 0xffffffff)))))) * extract64(((ut64) ((ut16) ((Rtt >> 0x30) & ((st64) 0xffff)))), 0x0, 0x10)) << 0x1) + ((st64) 0x8000) >> 0x10) : h_tmp318) & 0xffffffff) << 0x20));
	RzILOpPure *op_LSHIFT_5 = SHIFTL0(SN(64, 0xffffffff), SN(32, 0x20));
	RzILOpPure *op_NOT_6 = LOGNOT(op_LSHIFT_5);
	RzILOpPure *op_AND_7 = LOGAND(READ_REG(pkt, Rdd_op, true), op_NOT_6);
	RzILOpPure *op_RSHIFT_94 = SHIFTRA(DUP(Rss), SN(32, 0x20));
	RzILOpPure *op_AND_96 = LOGAND(op_RSHIFT_94, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_107 = SHIFTRA(DUP(Rtt), SN(32, 0x30));
	RzILOpPure *op_AND_110 = LOGAND(op_RSHIFT_107, CAST(64, MSB(SN(32, 0xffff)), SN(32, 0xffff)));
	RzILOpPure *op_MUL_118 = MUL(CAST(64, IL_FALSE, CAST(64, MSB(CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(op_AND_96), DUP(op_AND_96))), CAST(32, MSB(DUP(op_AND_96)), DUP(op_AND_96)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_96)), DUP(op_AND_96))), CAST(32, MSB(DUP(op_AND_96)), DUP(op_AND_96))))), CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(DUP(op_AND_96)), DUP(op_AND_96))), CAST(32, MSB(DUP(op_AND_96)), DUP(op_AND_96)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_96)), DUP(op_AND_96))), CAST(32, MSB(DUP(op_AND_96)), DUP(op_AND_96)))))), EXTRACT64(CAST(64, IL_FALSE, CAST(16, IL_FALSE, op_AND_110)), SN(32, 0), SN(32, 16)));
	RzILOpPure *op_LSHIFT_121 = SHIFTL0(CAST(64, IL_FALSE, op_MUL_118), SN(32, 1));
	RzILOpPure *op_ADD_124 = ADD(op_LSHIFT_121, CAST(64, MSB(SN(32, 0x8000)), SN(32, 0x8000)));
	RzILOpPure *op_RSHIFT_126 = SHIFTRA(op_ADD_124, SN(32, 16));
	RzILOpPure *cond_188 = ITE(DUP(op_EQ_90), op_RSHIFT_126, VARL("h_tmp318"));
	RzILOpPure *op_AND_190 = LOGAND(cond_188, SN(64, 0xffffffff));
	RzILOpPure *op_LSHIFT_194 = SHIFTL0(op_AND_190, SN(32, 0x20));
	RzILOpPure *op_OR_195 = LOGOR(op_AND_7, op_LSHIFT_194);
	RzILOpEffect *op_ASSIGN_196 = WRITE_REG(bundle, Rdd_op, op_OR_195);

	// seq(seq(HYB(gcc_expr_if ((sextract64(((ut64) ((((st64) ((ut64) ( ...;
	RzILOpEffect *seq_197 = SEQN(2, seq_187, op_ASSIGN_196);

	// set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, ((ut32) 0x1));
	RzILOpEffect *set_usr_field_call_325 = hex_set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, CAST(32, IL_FALSE, SN(32, 1)));

	// HYB(gcc_expr_if ((sextract64(((ut64) ((((st64) ((ut64) ((st64) ((st32) ((st64) ((st32) ((Rss >> 0x0) & 0xffffffff)))))) * extract64(((ut64) ((ut16) ((Rtt >> 0x10) & ((st64) 0xffff)))), 0x0, 0x10)) << 0x1) + ((st64) 0x8000) >> 0x10)), 0x0, 0x20) == ((((st64) ((ut64) ((st64) ((st32) ((st64) ((st32) ((Rss >> 0x0) & 0xffffffff)))))) * extract64(((ut64) ((ut16) ((Rtt >> 0x10) & ((st64) 0xffff)))), 0x0, 0x10)) << 0x1) + ((st64) 0x8000) >> 0x10))) {{}} else {set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, ((ut32) 0x1))}, ((((((st64) ((ut64) ((st64) ((st32) ((st64) ((st32) ((Rss >> 0x0) & 0xffffffff)))))) * extract64(((ut64) ((ut16) ((Rtt >> 0x10) & ((st64) 0xffff)))), 0x0, 0x10)) << 0x1) + ((st64) 0x8000) >> 0x10) < ((st64) 0x0)) ? (-(0x1 << 0x1f)) : (0x1 << 0x1f) - ((st64) 0x1)));
	RzILOpPure *op_RSHIFT_212 = SHIFTRA(DUP(Rss), SN(32, 0));
	RzILOpPure *op_AND_214 = LOGAND(op_RSHIFT_212, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_225 = SHIFTRA(DUP(Rtt), SN(32, 16));
	RzILOpPure *op_AND_228 = LOGAND(op_RSHIFT_225, CAST(64, MSB(SN(32, 0xffff)), SN(32, 0xffff)));
	RzILOpPure *op_MUL_236 = MUL(CAST(64, IL_FALSE, CAST(64, MSB(CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(op_AND_214), DUP(op_AND_214))), CAST(32, MSB(DUP(op_AND_214)), DUP(op_AND_214)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_214)), DUP(op_AND_214))), CAST(32, MSB(DUP(op_AND_214)), DUP(op_AND_214))))), CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(DUP(op_AND_214)), DUP(op_AND_214))), CAST(32, MSB(DUP(op_AND_214)), DUP(op_AND_214)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_214)), DUP(op_AND_214))), CAST(32, MSB(DUP(op_AND_214)), DUP(op_AND_214)))))), EXTRACT64(CAST(64, IL_FALSE, CAST(16, IL_FALSE, op_AND_228)), SN(32, 0), SN(32, 16)));
	RzILOpPure *op_LSHIFT_239 = SHIFTL0(CAST(64, IL_FALSE, op_MUL_236), SN(32, 1));
	RzILOpPure *op_ADD_242 = ADD(op_LSHIFT_239, CAST(64, MSB(SN(32, 0x8000)), SN(32, 0x8000)));
	RzILOpPure *op_RSHIFT_244 = SHIFTRA(op_ADD_242, SN(32, 16));
	RzILOpPure *op_RSHIFT_253 = SHIFTRA(DUP(Rss), SN(32, 0));
	RzILOpPure *op_AND_255 = LOGAND(op_RSHIFT_253, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_266 = SHIFTRA(DUP(Rtt), SN(32, 16));
	RzILOpPure *op_AND_269 = LOGAND(op_RSHIFT_266, CAST(64, MSB(SN(32, 0xffff)), SN(32, 0xffff)));
	RzILOpPure *op_MUL_277 = MUL(CAST(64, IL_FALSE, CAST(64, MSB(CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(op_AND_255), DUP(op_AND_255))), CAST(32, MSB(DUP(op_AND_255)), DUP(op_AND_255)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_255)), DUP(op_AND_255))), CAST(32, MSB(DUP(op_AND_255)), DUP(op_AND_255))))), CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(DUP(op_AND_255)), DUP(op_AND_255))), CAST(32, MSB(DUP(op_AND_255)), DUP(op_AND_255)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_255)), DUP(op_AND_255))), CAST(32, MSB(DUP(op_AND_255)), DUP(op_AND_255)))))), EXTRACT64(CAST(64, IL_FALSE, CAST(16, IL_FALSE, op_AND_269)), SN(32, 0), SN(32, 16)));
	RzILOpPure *op_LSHIFT_280 = SHIFTL0(CAST(64, IL_FALSE, op_MUL_277), SN(32, 1));
	RzILOpPure *op_ADD_283 = ADD(op_LSHIFT_280, CAST(64, MSB(SN(32, 0x8000)), SN(32, 0x8000)));
	RzILOpPure *op_RSHIFT_285 = SHIFTRA(op_ADD_283, SN(32, 16));
	RzILOpPure *op_EQ_286 = EQ(SEXTRACT64(CAST(64, IL_FALSE, op_RSHIFT_244), SN(32, 0), SN(32, 0x20)), op_RSHIFT_285);
	RzILOpPure *op_RSHIFT_329 = SHIFTRA(DUP(Rss), SN(32, 0));
	RzILOpPure *op_AND_331 = LOGAND(op_RSHIFT_329, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_342 = SHIFTRA(DUP(Rtt), SN(32, 16));
	RzILOpPure *op_AND_345 = LOGAND(op_RSHIFT_342, CAST(64, MSB(SN(32, 0xffff)), SN(32, 0xffff)));
	RzILOpPure *op_MUL_353 = MUL(CAST(64, IL_FALSE, CAST(64, MSB(CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(op_AND_331), DUP(op_AND_331))), CAST(32, MSB(DUP(op_AND_331)), DUP(op_AND_331)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_331)), DUP(op_AND_331))), CAST(32, MSB(DUP(op_AND_331)), DUP(op_AND_331))))), CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(DUP(op_AND_331)), DUP(op_AND_331))), CAST(32, MSB(DUP(op_AND_331)), DUP(op_AND_331)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_331)), DUP(op_AND_331))), CAST(32, MSB(DUP(op_AND_331)), DUP(op_AND_331)))))), EXTRACT64(CAST(64, IL_FALSE, CAST(16, IL_FALSE, op_AND_345)), SN(32, 0), SN(32, 16)));
	RzILOpPure *op_LSHIFT_356 = SHIFTL0(CAST(64, IL_FALSE, op_MUL_353), SN(32, 1));
	RzILOpPure *op_ADD_359 = ADD(op_LSHIFT_356, CAST(64, MSB(SN(32, 0x8000)), SN(32, 0x8000)));
	RzILOpPure *op_RSHIFT_361 = SHIFTRA(op_ADD_359, SN(32, 16));
	RzILOpPure *op_LT_364 = SLT(op_RSHIFT_361, CAST(64, MSB(SN(32, 0)), SN(32, 0)));
	RzILOpPure *op_LSHIFT_369 = SHIFTL0(SN(64, 1), SN(32, 31));
	RzILOpPure *op_NEG_370 = NEG(op_LSHIFT_369);
	RzILOpPure *op_LSHIFT_375 = SHIFTL0(SN(64, 1), SN(32, 31));
	RzILOpPure *op_SUB_378 = SUB(op_LSHIFT_375, CAST(64, MSB(SN(32, 1)), SN(32, 1)));
	RzILOpPure *cond_379 = ITE(op_LT_364, op_NEG_370, op_SUB_378);
	RzILOpEffect *gcc_expr_380 = BRANCH(op_EQ_286, EMPTY(), set_usr_field_call_325);

	// h_tmp319 = HYB(gcc_expr_if ((sextract64(((ut64) ((((st64) ((ut64) ((st64) ((st32) ((st64) ((st32) ((Rss >> 0x0) & 0xffffffff)))))) * extract64(((ut64) ((ut16) ((Rtt >> 0x10) & ((st64) 0xffff)))), 0x0, 0x10)) << 0x1) + ((st64) 0x8000) >> 0x10)), 0x0, 0x20) == ((((st64) ((ut64) ((st64) ((st32) ((st64) ((st32) ((Rss >> 0x0) & 0xffffffff)))))) * extract64(((ut64) ((ut16) ((Rtt >> 0x10) & ((st64) 0xffff)))), 0x0, 0x10)) << 0x1) + ((st64) 0x8000) >> 0x10))) {{}} else {set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, ((ut32) 0x1))}, ((((((st64) ((ut64) ((st64) ((st32) ((st64) ((st32) ((Rss >> 0x0) & 0xffffffff)))))) * extract64(((ut64) ((ut16) ((Rtt >> 0x10) & ((st64) 0xffff)))), 0x0, 0x10)) << 0x1) + ((st64) 0x8000) >> 0x10) < ((st64) 0x0)) ? (-(0x1 << 0x1f)) : (0x1 << 0x1f) - ((st64) 0x1)));
	RzILOpEffect *op_ASSIGN_hybrid_tmp_382 = SETL("h_tmp319", cond_379);

	// seq(HYB(gcc_expr_if ((sextract64(((ut64) ((((st64) ((ut64) ((st6 ...;
	RzILOpEffect *seq_383 = SEQN(2, gcc_expr_380, op_ASSIGN_hybrid_tmp_382);

	// Rdd = ((Rdd & (~(0xffffffff << 0x0))) | ((((sextract64(((ut64) ((((st64) ((ut64) ((st64) ((st32) ((st64) ((st32) ((Rss >> 0x0) & 0xffffffff)))))) * extract64(((ut64) ((ut16) ((Rtt >> 0x10) & ((st64) 0xffff)))), 0x0, 0x10)) << 0x1) + ((st64) 0x8000) >> 0x10)), 0x0, 0x20) == ((((st64) ((ut64) ((st64) ((st32) ((st64) ((st32) ((Rss >> 0x0) & 0xffffffff)))))) * extract64(((ut64) ((ut16) ((Rtt >> 0x10) & ((st64) 0xffff)))), 0x0, 0x10)) << 0x1) + ((st64) 0x8000) >> 0x10)) ? ((((st64) ((ut64) ((st64) ((st32) ((st64) ((st32) ((Rss >> 0x0) & 0xffffffff)))))) * extract64(((ut64) ((ut16) ((Rtt >> 0x10) & ((st64) 0xffff)))), 0x0, 0x10)) << 0x1) + ((st64) 0x8000) >> 0x10) : h_tmp319) & 0xffffffff) << 0x0));
	RzILOpPure *op_LSHIFT_203 = SHIFTL0(SN(64, 0xffffffff), SN(32, 0));
	RzILOpPure *op_NOT_204 = LOGNOT(op_LSHIFT_203);
	RzILOpPure *op_AND_205 = LOGAND(READ_REG(pkt, Rdd_op, true), op_NOT_204);
	RzILOpPure *op_RSHIFT_290 = SHIFTRA(DUP(Rss), SN(32, 0));
	RzILOpPure *op_AND_292 = LOGAND(op_RSHIFT_290, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_303 = SHIFTRA(DUP(Rtt), SN(32, 16));
	RzILOpPure *op_AND_306 = LOGAND(op_RSHIFT_303, CAST(64, MSB(SN(32, 0xffff)), SN(32, 0xffff)));
	RzILOpPure *op_MUL_314 = MUL(CAST(64, IL_FALSE, CAST(64, MSB(CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(op_AND_292), DUP(op_AND_292))), CAST(32, MSB(DUP(op_AND_292)), DUP(op_AND_292)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_292)), DUP(op_AND_292))), CAST(32, MSB(DUP(op_AND_292)), DUP(op_AND_292))))), CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(DUP(op_AND_292)), DUP(op_AND_292))), CAST(32, MSB(DUP(op_AND_292)), DUP(op_AND_292)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_292)), DUP(op_AND_292))), CAST(32, MSB(DUP(op_AND_292)), DUP(op_AND_292)))))), EXTRACT64(CAST(64, IL_FALSE, CAST(16, IL_FALSE, op_AND_306)), SN(32, 0), SN(32, 16)));
	RzILOpPure *op_LSHIFT_317 = SHIFTL0(CAST(64, IL_FALSE, op_MUL_314), SN(32, 1));
	RzILOpPure *op_ADD_320 = ADD(op_LSHIFT_317, CAST(64, MSB(SN(32, 0x8000)), SN(32, 0x8000)));
	RzILOpPure *op_RSHIFT_322 = SHIFTRA(op_ADD_320, SN(32, 16));
	RzILOpPure *cond_384 = ITE(DUP(op_EQ_286), op_RSHIFT_322, VARL("h_tmp319"));
	RzILOpPure *op_AND_386 = LOGAND(cond_384, SN(64, 0xffffffff));
	RzILOpPure *op_LSHIFT_390 = SHIFTL0(op_AND_386, SN(32, 0));
	RzILOpPure *op_OR_391 = LOGOR(op_AND_205, op_LSHIFT_390);
	RzILOpEffect *op_ASSIGN_392 = WRITE_REG(bundle, Rdd_op, op_OR_391);

	// seq(seq(HYB(gcc_expr_if ((sextract64(((ut64) ((((st64) ((ut64) ( ...;
	RzILOpEffect *seq_393 = SEQN(2, seq_383, op_ASSIGN_392);

	RzILOpEffect *instruction_sequence = SEQN(2, seq_197, seq_393);
	return instruction_sequence;
}

// Rdd = vmpywouh(Rss,Rtt):sat
RzILOpEffect *hex_il_op_m2_mmpyuh_s0(HexInsnPktBundle *bundle) {
	const HexInsn *hi = bundle->insn;
	HexPkt *pkt = bundle->pkt;
	// READ
	const HexOp *Rdd_op = ISA2REG(hi, 'd', false);
	const HexOp *Rss_op = ISA2REG(hi, 's', false);
	RzILOpPure *Rss = READ_REG(pkt, Rss_op, false);
	const HexOp *Rtt_op = ISA2REG(hi, 't', false);
	RzILOpPure *Rtt = READ_REG(pkt, Rtt_op, false);

	// set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, ((ut32) 0x1));
	RzILOpEffect *set_usr_field_call_120 = hex_set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, CAST(32, IL_FALSE, SN(32, 1)));

	// HYB(gcc_expr_if ((sextract64(((ut64) ((((st64) ((ut64) ((st64) ((st32) ((st64) ((st32) ((Rss >> 0x20) & 0xffffffff)))))) * extract64(((ut64) ((ut16) ((Rtt >> 0x30) & ((st64) 0xffff)))), 0x0, 0x10)) << 0x0) >> 0x10)), 0x0, 0x20) == ((((st64) ((ut64) ((st64) ((st32) ((st64) ((st32) ((Rss >> 0x20) & 0xffffffff)))))) * extract64(((ut64) ((ut16) ((Rtt >> 0x30) & ((st64) 0xffff)))), 0x0, 0x10)) << 0x0) >> 0x10))) {{}} else {set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, ((ut32) 0x1))}, ((((((st64) ((ut64) ((st64) ((st32) ((st64) ((st32) ((Rss >> 0x20) & 0xffffffff)))))) * extract64(((ut64) ((ut16) ((Rtt >> 0x30) & ((st64) 0xffff)))), 0x0, 0x10)) << 0x0) >> 0x10) < ((st64) 0x0)) ? (-(0x1 << 0x1f)) : (0x1 << 0x1f) - ((st64) 0x1)));
	RzILOpPure *op_RSHIFT_15 = SHIFTRA(Rss, SN(32, 0x20));
	RzILOpPure *op_AND_17 = LOGAND(op_RSHIFT_15, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_29 = SHIFTRA(Rtt, SN(32, 0x30));
	RzILOpPure *op_AND_32 = LOGAND(op_RSHIFT_29, CAST(64, MSB(SN(32, 0xffff)), SN(32, 0xffff)));
	RzILOpPure *op_MUL_40 = MUL(CAST(64, IL_FALSE, CAST(64, MSB(CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(op_AND_17), DUP(op_AND_17))), CAST(32, MSB(DUP(op_AND_17)), DUP(op_AND_17)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_17)), DUP(op_AND_17))), CAST(32, MSB(DUP(op_AND_17)), DUP(op_AND_17))))), CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(DUP(op_AND_17)), DUP(op_AND_17))), CAST(32, MSB(DUP(op_AND_17)), DUP(op_AND_17)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_17)), DUP(op_AND_17))), CAST(32, MSB(DUP(op_AND_17)), DUP(op_AND_17)))))), EXTRACT64(CAST(64, IL_FALSE, CAST(16, IL_FALSE, op_AND_32)), SN(32, 0), SN(32, 16)));
	RzILOpPure *op_LSHIFT_43 = SHIFTL0(CAST(64, IL_FALSE, op_MUL_40), SN(32, 0));
	RzILOpPure *op_RSHIFT_45 = SHIFTRA(op_LSHIFT_43, SN(32, 16));
	RzILOpPure *op_RSHIFT_54 = SHIFTRA(DUP(Rss), SN(32, 0x20));
	RzILOpPure *op_AND_56 = LOGAND(op_RSHIFT_54, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_67 = SHIFTRA(DUP(Rtt), SN(32, 0x30));
	RzILOpPure *op_AND_70 = LOGAND(op_RSHIFT_67, CAST(64, MSB(SN(32, 0xffff)), SN(32, 0xffff)));
	RzILOpPure *op_MUL_78 = MUL(CAST(64, IL_FALSE, CAST(64, MSB(CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(op_AND_56), DUP(op_AND_56))), CAST(32, MSB(DUP(op_AND_56)), DUP(op_AND_56)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_56)), DUP(op_AND_56))), CAST(32, MSB(DUP(op_AND_56)), DUP(op_AND_56))))), CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(DUP(op_AND_56)), DUP(op_AND_56))), CAST(32, MSB(DUP(op_AND_56)), DUP(op_AND_56)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_56)), DUP(op_AND_56))), CAST(32, MSB(DUP(op_AND_56)), DUP(op_AND_56)))))), EXTRACT64(CAST(64, IL_FALSE, CAST(16, IL_FALSE, op_AND_70)), SN(32, 0), SN(32, 16)));
	RzILOpPure *op_LSHIFT_81 = SHIFTL0(CAST(64, IL_FALSE, op_MUL_78), SN(32, 0));
	RzILOpPure *op_RSHIFT_83 = SHIFTRA(op_LSHIFT_81, SN(32, 16));
	RzILOpPure *op_EQ_84 = EQ(SEXTRACT64(CAST(64, IL_FALSE, op_RSHIFT_45), SN(32, 0), SN(32, 0x20)), op_RSHIFT_83);
	RzILOpPure *op_RSHIFT_124 = SHIFTRA(DUP(Rss), SN(32, 0x20));
	RzILOpPure *op_AND_126 = LOGAND(op_RSHIFT_124, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_137 = SHIFTRA(DUP(Rtt), SN(32, 0x30));
	RzILOpPure *op_AND_140 = LOGAND(op_RSHIFT_137, CAST(64, MSB(SN(32, 0xffff)), SN(32, 0xffff)));
	RzILOpPure *op_MUL_148 = MUL(CAST(64, IL_FALSE, CAST(64, MSB(CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(op_AND_126), DUP(op_AND_126))), CAST(32, MSB(DUP(op_AND_126)), DUP(op_AND_126)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_126)), DUP(op_AND_126))), CAST(32, MSB(DUP(op_AND_126)), DUP(op_AND_126))))), CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(DUP(op_AND_126)), DUP(op_AND_126))), CAST(32, MSB(DUP(op_AND_126)), DUP(op_AND_126)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_126)), DUP(op_AND_126))), CAST(32, MSB(DUP(op_AND_126)), DUP(op_AND_126)))))), EXTRACT64(CAST(64, IL_FALSE, CAST(16, IL_FALSE, op_AND_140)), SN(32, 0), SN(32, 16)));
	RzILOpPure *op_LSHIFT_151 = SHIFTL0(CAST(64, IL_FALSE, op_MUL_148), SN(32, 0));
	RzILOpPure *op_RSHIFT_153 = SHIFTRA(op_LSHIFT_151, SN(32, 16));
	RzILOpPure *op_LT_156 = SLT(op_RSHIFT_153, CAST(64, MSB(SN(32, 0)), SN(32, 0)));
	RzILOpPure *op_LSHIFT_161 = SHIFTL0(SN(64, 1), SN(32, 31));
	RzILOpPure *op_NEG_162 = NEG(op_LSHIFT_161);
	RzILOpPure *op_LSHIFT_167 = SHIFTL0(SN(64, 1), SN(32, 31));
	RzILOpPure *op_SUB_170 = SUB(op_LSHIFT_167, CAST(64, MSB(SN(32, 1)), SN(32, 1)));
	RzILOpPure *cond_171 = ITE(op_LT_156, op_NEG_162, op_SUB_170);
	RzILOpEffect *gcc_expr_172 = BRANCH(op_EQ_84, EMPTY(), set_usr_field_call_120);

	// h_tmp320 = HYB(gcc_expr_if ((sextract64(((ut64) ((((st64) ((ut64) ((st64) ((st32) ((st64) ((st32) ((Rss >> 0x20) & 0xffffffff)))))) * extract64(((ut64) ((ut16) ((Rtt >> 0x30) & ((st64) 0xffff)))), 0x0, 0x10)) << 0x0) >> 0x10)), 0x0, 0x20) == ((((st64) ((ut64) ((st64) ((st32) ((st64) ((st32) ((Rss >> 0x20) & 0xffffffff)))))) * extract64(((ut64) ((ut16) ((Rtt >> 0x30) & ((st64) 0xffff)))), 0x0, 0x10)) << 0x0) >> 0x10))) {{}} else {set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, ((ut32) 0x1))}, ((((((st64) ((ut64) ((st64) ((st32) ((st64) ((st32) ((Rss >> 0x20) & 0xffffffff)))))) * extract64(((ut64) ((ut16) ((Rtt >> 0x30) & ((st64) 0xffff)))), 0x0, 0x10)) << 0x0) >> 0x10) < ((st64) 0x0)) ? (-(0x1 << 0x1f)) : (0x1 << 0x1f) - ((st64) 0x1)));
	RzILOpEffect *op_ASSIGN_hybrid_tmp_174 = SETL("h_tmp320", cond_171);

	// seq(HYB(gcc_expr_if ((sextract64(((ut64) ((((st64) ((ut64) ((st6 ...;
	RzILOpEffect *seq_175 = SEQN(2, gcc_expr_172, op_ASSIGN_hybrid_tmp_174);

	// Rdd = ((Rdd & (~(0xffffffff << 0x20))) | ((((sextract64(((ut64) ((((st64) ((ut64) ((st64) ((st32) ((st64) ((st32) ((Rss >> 0x20) & 0xffffffff)))))) * extract64(((ut64) ((ut16) ((Rtt >> 0x30) & ((st64) 0xffff)))), 0x0, 0x10)) << 0x0) >> 0x10)), 0x0, 0x20) == ((((st64) ((ut64) ((st64) ((st32) ((st64) ((st32) ((Rss >> 0x20) & 0xffffffff)))))) * extract64(((ut64) ((ut16) ((Rtt >> 0x30) & ((st64) 0xffff)))), 0x0, 0x10)) << 0x0) >> 0x10)) ? ((((st64) ((ut64) ((st64) ((st32) ((st64) ((st32) ((Rss >> 0x20) & 0xffffffff)))))) * extract64(((ut64) ((ut16) ((Rtt >> 0x30) & ((st64) 0xffff)))), 0x0, 0x10)) << 0x0) >> 0x10) : h_tmp320) & 0xffffffff) << 0x20));
	RzILOpPure *op_LSHIFT_5 = SHIFTL0(SN(64, 0xffffffff), SN(32, 0x20));
	RzILOpPure *op_NOT_6 = LOGNOT(op_LSHIFT_5);
	RzILOpPure *op_AND_7 = LOGAND(READ_REG(pkt, Rdd_op, true), op_NOT_6);
	RzILOpPure *op_RSHIFT_88 = SHIFTRA(DUP(Rss), SN(32, 0x20));
	RzILOpPure *op_AND_90 = LOGAND(op_RSHIFT_88, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_101 = SHIFTRA(DUP(Rtt), SN(32, 0x30));
	RzILOpPure *op_AND_104 = LOGAND(op_RSHIFT_101, CAST(64, MSB(SN(32, 0xffff)), SN(32, 0xffff)));
	RzILOpPure *op_MUL_112 = MUL(CAST(64, IL_FALSE, CAST(64, MSB(CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(op_AND_90), DUP(op_AND_90))), CAST(32, MSB(DUP(op_AND_90)), DUP(op_AND_90)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_90)), DUP(op_AND_90))), CAST(32, MSB(DUP(op_AND_90)), DUP(op_AND_90))))), CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(DUP(op_AND_90)), DUP(op_AND_90))), CAST(32, MSB(DUP(op_AND_90)), DUP(op_AND_90)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_90)), DUP(op_AND_90))), CAST(32, MSB(DUP(op_AND_90)), DUP(op_AND_90)))))), EXTRACT64(CAST(64, IL_FALSE, CAST(16, IL_FALSE, op_AND_104)), SN(32, 0), SN(32, 16)));
	RzILOpPure *op_LSHIFT_115 = SHIFTL0(CAST(64, IL_FALSE, op_MUL_112), SN(32, 0));
	RzILOpPure *op_RSHIFT_117 = SHIFTRA(op_LSHIFT_115, SN(32, 16));
	RzILOpPure *cond_176 = ITE(DUP(op_EQ_84), op_RSHIFT_117, VARL("h_tmp320"));
	RzILOpPure *op_AND_178 = LOGAND(cond_176, SN(64, 0xffffffff));
	RzILOpPure *op_LSHIFT_182 = SHIFTL0(op_AND_178, SN(32, 0x20));
	RzILOpPure *op_OR_183 = LOGOR(op_AND_7, op_LSHIFT_182);
	RzILOpEffect *op_ASSIGN_184 = WRITE_REG(bundle, Rdd_op, op_OR_183);

	// seq(seq(HYB(gcc_expr_if ((sextract64(((ut64) ((((st64) ((ut64) ( ...;
	RzILOpEffect *seq_185 = SEQN(2, seq_175, op_ASSIGN_184);

	// set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, ((ut32) 0x1));
	RzILOpEffect *set_usr_field_call_304 = hex_set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, CAST(32, IL_FALSE, SN(32, 1)));

	// HYB(gcc_expr_if ((sextract64(((ut64) ((((st64) ((ut64) ((st64) ((st32) ((st64) ((st32) ((Rss >> 0x0) & 0xffffffff)))))) * extract64(((ut64) ((ut16) ((Rtt >> 0x10) & ((st64) 0xffff)))), 0x0, 0x10)) << 0x0) >> 0x10)), 0x0, 0x20) == ((((st64) ((ut64) ((st64) ((st32) ((st64) ((st32) ((Rss >> 0x0) & 0xffffffff)))))) * extract64(((ut64) ((ut16) ((Rtt >> 0x10) & ((st64) 0xffff)))), 0x0, 0x10)) << 0x0) >> 0x10))) {{}} else {set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, ((ut32) 0x1))}, ((((((st64) ((ut64) ((st64) ((st32) ((st64) ((st32) ((Rss >> 0x0) & 0xffffffff)))))) * extract64(((ut64) ((ut16) ((Rtt >> 0x10) & ((st64) 0xffff)))), 0x0, 0x10)) << 0x0) >> 0x10) < ((st64) 0x0)) ? (-(0x1 << 0x1f)) : (0x1 << 0x1f) - ((st64) 0x1)));
	RzILOpPure *op_RSHIFT_200 = SHIFTRA(DUP(Rss), SN(32, 0));
	RzILOpPure *op_AND_202 = LOGAND(op_RSHIFT_200, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_213 = SHIFTRA(DUP(Rtt), SN(32, 16));
	RzILOpPure *op_AND_216 = LOGAND(op_RSHIFT_213, CAST(64, MSB(SN(32, 0xffff)), SN(32, 0xffff)));
	RzILOpPure *op_MUL_224 = MUL(CAST(64, IL_FALSE, CAST(64, MSB(CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(op_AND_202), DUP(op_AND_202))), CAST(32, MSB(DUP(op_AND_202)), DUP(op_AND_202)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_202)), DUP(op_AND_202))), CAST(32, MSB(DUP(op_AND_202)), DUP(op_AND_202))))), CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(DUP(op_AND_202)), DUP(op_AND_202))), CAST(32, MSB(DUP(op_AND_202)), DUP(op_AND_202)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_202)), DUP(op_AND_202))), CAST(32, MSB(DUP(op_AND_202)), DUP(op_AND_202)))))), EXTRACT64(CAST(64, IL_FALSE, CAST(16, IL_FALSE, op_AND_216)), SN(32, 0), SN(32, 16)));
	RzILOpPure *op_LSHIFT_227 = SHIFTL0(CAST(64, IL_FALSE, op_MUL_224), SN(32, 0));
	RzILOpPure *op_RSHIFT_229 = SHIFTRA(op_LSHIFT_227, SN(32, 16));
	RzILOpPure *op_RSHIFT_238 = SHIFTRA(DUP(Rss), SN(32, 0));
	RzILOpPure *op_AND_240 = LOGAND(op_RSHIFT_238, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_251 = SHIFTRA(DUP(Rtt), SN(32, 16));
	RzILOpPure *op_AND_254 = LOGAND(op_RSHIFT_251, CAST(64, MSB(SN(32, 0xffff)), SN(32, 0xffff)));
	RzILOpPure *op_MUL_262 = MUL(CAST(64, IL_FALSE, CAST(64, MSB(CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(op_AND_240), DUP(op_AND_240))), CAST(32, MSB(DUP(op_AND_240)), DUP(op_AND_240)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_240)), DUP(op_AND_240))), CAST(32, MSB(DUP(op_AND_240)), DUP(op_AND_240))))), CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(DUP(op_AND_240)), DUP(op_AND_240))), CAST(32, MSB(DUP(op_AND_240)), DUP(op_AND_240)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_240)), DUP(op_AND_240))), CAST(32, MSB(DUP(op_AND_240)), DUP(op_AND_240)))))), EXTRACT64(CAST(64, IL_FALSE, CAST(16, IL_FALSE, op_AND_254)), SN(32, 0), SN(32, 16)));
	RzILOpPure *op_LSHIFT_265 = SHIFTL0(CAST(64, IL_FALSE, op_MUL_262), SN(32, 0));
	RzILOpPure *op_RSHIFT_267 = SHIFTRA(op_LSHIFT_265, SN(32, 16));
	RzILOpPure *op_EQ_268 = EQ(SEXTRACT64(CAST(64, IL_FALSE, op_RSHIFT_229), SN(32, 0), SN(32, 0x20)), op_RSHIFT_267);
	RzILOpPure *op_RSHIFT_308 = SHIFTRA(DUP(Rss), SN(32, 0));
	RzILOpPure *op_AND_310 = LOGAND(op_RSHIFT_308, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_321 = SHIFTRA(DUP(Rtt), SN(32, 16));
	RzILOpPure *op_AND_324 = LOGAND(op_RSHIFT_321, CAST(64, MSB(SN(32, 0xffff)), SN(32, 0xffff)));
	RzILOpPure *op_MUL_332 = MUL(CAST(64, IL_FALSE, CAST(64, MSB(CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(op_AND_310), DUP(op_AND_310))), CAST(32, MSB(DUP(op_AND_310)), DUP(op_AND_310)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_310)), DUP(op_AND_310))), CAST(32, MSB(DUP(op_AND_310)), DUP(op_AND_310))))), CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(DUP(op_AND_310)), DUP(op_AND_310))), CAST(32, MSB(DUP(op_AND_310)), DUP(op_AND_310)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_310)), DUP(op_AND_310))), CAST(32, MSB(DUP(op_AND_310)), DUP(op_AND_310)))))), EXTRACT64(CAST(64, IL_FALSE, CAST(16, IL_FALSE, op_AND_324)), SN(32, 0), SN(32, 16)));
	RzILOpPure *op_LSHIFT_335 = SHIFTL0(CAST(64, IL_FALSE, op_MUL_332), SN(32, 0));
	RzILOpPure *op_RSHIFT_337 = SHIFTRA(op_LSHIFT_335, SN(32, 16));
	RzILOpPure *op_LT_340 = SLT(op_RSHIFT_337, CAST(64, MSB(SN(32, 0)), SN(32, 0)));
	RzILOpPure *op_LSHIFT_345 = SHIFTL0(SN(64, 1), SN(32, 31));
	RzILOpPure *op_NEG_346 = NEG(op_LSHIFT_345);
	RzILOpPure *op_LSHIFT_351 = SHIFTL0(SN(64, 1), SN(32, 31));
	RzILOpPure *op_SUB_354 = SUB(op_LSHIFT_351, CAST(64, MSB(SN(32, 1)), SN(32, 1)));
	RzILOpPure *cond_355 = ITE(op_LT_340, op_NEG_346, op_SUB_354);
	RzILOpEffect *gcc_expr_356 = BRANCH(op_EQ_268, EMPTY(), set_usr_field_call_304);

	// h_tmp321 = HYB(gcc_expr_if ((sextract64(((ut64) ((((st64) ((ut64) ((st64) ((st32) ((st64) ((st32) ((Rss >> 0x0) & 0xffffffff)))))) * extract64(((ut64) ((ut16) ((Rtt >> 0x10) & ((st64) 0xffff)))), 0x0, 0x10)) << 0x0) >> 0x10)), 0x0, 0x20) == ((((st64) ((ut64) ((st64) ((st32) ((st64) ((st32) ((Rss >> 0x0) & 0xffffffff)))))) * extract64(((ut64) ((ut16) ((Rtt >> 0x10) & ((st64) 0xffff)))), 0x0, 0x10)) << 0x0) >> 0x10))) {{}} else {set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, ((ut32) 0x1))}, ((((((st64) ((ut64) ((st64) ((st32) ((st64) ((st32) ((Rss >> 0x0) & 0xffffffff)))))) * extract64(((ut64) ((ut16) ((Rtt >> 0x10) & ((st64) 0xffff)))), 0x0, 0x10)) << 0x0) >> 0x10) < ((st64) 0x0)) ? (-(0x1 << 0x1f)) : (0x1 << 0x1f) - ((st64) 0x1)));
	RzILOpEffect *op_ASSIGN_hybrid_tmp_358 = SETL("h_tmp321", cond_355);

	// seq(HYB(gcc_expr_if ((sextract64(((ut64) ((((st64) ((ut64) ((st6 ...;
	RzILOpEffect *seq_359 = SEQN(2, gcc_expr_356, op_ASSIGN_hybrid_tmp_358);

	// Rdd = ((Rdd & (~(0xffffffff << 0x0))) | ((((sextract64(((ut64) ((((st64) ((ut64) ((st64) ((st32) ((st64) ((st32) ((Rss >> 0x0) & 0xffffffff)))))) * extract64(((ut64) ((ut16) ((Rtt >> 0x10) & ((st64) 0xffff)))), 0x0, 0x10)) << 0x0) >> 0x10)), 0x0, 0x20) == ((((st64) ((ut64) ((st64) ((st32) ((st64) ((st32) ((Rss >> 0x0) & 0xffffffff)))))) * extract64(((ut64) ((ut16) ((Rtt >> 0x10) & ((st64) 0xffff)))), 0x0, 0x10)) << 0x0) >> 0x10)) ? ((((st64) ((ut64) ((st64) ((st32) ((st64) ((st32) ((Rss >> 0x0) & 0xffffffff)))))) * extract64(((ut64) ((ut16) ((Rtt >> 0x10) & ((st64) 0xffff)))), 0x0, 0x10)) << 0x0) >> 0x10) : h_tmp321) & 0xffffffff) << 0x0));
	RzILOpPure *op_LSHIFT_191 = SHIFTL0(SN(64, 0xffffffff), SN(32, 0));
	RzILOpPure *op_NOT_192 = LOGNOT(op_LSHIFT_191);
	RzILOpPure *op_AND_193 = LOGAND(READ_REG(pkt, Rdd_op, true), op_NOT_192);
	RzILOpPure *op_RSHIFT_272 = SHIFTRA(DUP(Rss), SN(32, 0));
	RzILOpPure *op_AND_274 = LOGAND(op_RSHIFT_272, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_285 = SHIFTRA(DUP(Rtt), SN(32, 16));
	RzILOpPure *op_AND_288 = LOGAND(op_RSHIFT_285, CAST(64, MSB(SN(32, 0xffff)), SN(32, 0xffff)));
	RzILOpPure *op_MUL_296 = MUL(CAST(64, IL_FALSE, CAST(64, MSB(CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(op_AND_274), DUP(op_AND_274))), CAST(32, MSB(DUP(op_AND_274)), DUP(op_AND_274)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_274)), DUP(op_AND_274))), CAST(32, MSB(DUP(op_AND_274)), DUP(op_AND_274))))), CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(DUP(op_AND_274)), DUP(op_AND_274))), CAST(32, MSB(DUP(op_AND_274)), DUP(op_AND_274)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_274)), DUP(op_AND_274))), CAST(32, MSB(DUP(op_AND_274)), DUP(op_AND_274)))))), EXTRACT64(CAST(64, IL_FALSE, CAST(16, IL_FALSE, op_AND_288)), SN(32, 0), SN(32, 16)));
	RzILOpPure *op_LSHIFT_299 = SHIFTL0(CAST(64, IL_FALSE, op_MUL_296), SN(32, 0));
	RzILOpPure *op_RSHIFT_301 = SHIFTRA(op_LSHIFT_299, SN(32, 16));
	RzILOpPure *cond_360 = ITE(DUP(op_EQ_268), op_RSHIFT_301, VARL("h_tmp321"));
	RzILOpPure *op_AND_362 = LOGAND(cond_360, SN(64, 0xffffffff));
	RzILOpPure *op_LSHIFT_366 = SHIFTL0(op_AND_362, SN(32, 0));
	RzILOpPure *op_OR_367 = LOGOR(op_AND_193, op_LSHIFT_366);
	RzILOpEffect *op_ASSIGN_368 = WRITE_REG(bundle, Rdd_op, op_OR_367);

	// seq(seq(HYB(gcc_expr_if ((sextract64(((ut64) ((((st64) ((ut64) ( ...;
	RzILOpEffect *seq_369 = SEQN(2, seq_359, op_ASSIGN_368);

	RzILOpEffect *instruction_sequence = SEQN(2, seq_185, seq_369);
	return instruction_sequence;
}

// Rdd = vmpywouh(Rss,Rtt):<<1:sat
RzILOpEffect *hex_il_op_m2_mmpyuh_s1(HexInsnPktBundle *bundle) {
	const HexInsn *hi = bundle->insn;
	HexPkt *pkt = bundle->pkt;
	// READ
	const HexOp *Rdd_op = ISA2REG(hi, 'd', false);
	const HexOp *Rss_op = ISA2REG(hi, 's', false);
	RzILOpPure *Rss = READ_REG(pkt, Rss_op, false);
	const HexOp *Rtt_op = ISA2REG(hi, 't', false);
	RzILOpPure *Rtt = READ_REG(pkt, Rtt_op, false);

	// set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, ((ut32) 0x1));
	RzILOpEffect *set_usr_field_call_120 = hex_set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, CAST(32, IL_FALSE, SN(32, 1)));

	// HYB(gcc_expr_if ((sextract64(((ut64) ((((st64) ((ut64) ((st64) ((st32) ((st64) ((st32) ((Rss >> 0x20) & 0xffffffff)))))) * extract64(((ut64) ((ut16) ((Rtt >> 0x30) & ((st64) 0xffff)))), 0x0, 0x10)) << 0x1) >> 0x10)), 0x0, 0x20) == ((((st64) ((ut64) ((st64) ((st32) ((st64) ((st32) ((Rss >> 0x20) & 0xffffffff)))))) * extract64(((ut64) ((ut16) ((Rtt >> 0x30) & ((st64) 0xffff)))), 0x0, 0x10)) << 0x1) >> 0x10))) {{}} else {set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, ((ut32) 0x1))}, ((((((st64) ((ut64) ((st64) ((st32) ((st64) ((st32) ((Rss >> 0x20) & 0xffffffff)))))) * extract64(((ut64) ((ut16) ((Rtt >> 0x30) & ((st64) 0xffff)))), 0x0, 0x10)) << 0x1) >> 0x10) < ((st64) 0x0)) ? (-(0x1 << 0x1f)) : (0x1 << 0x1f) - ((st64) 0x1)));
	RzILOpPure *op_RSHIFT_15 = SHIFTRA(Rss, SN(32, 0x20));
	RzILOpPure *op_AND_17 = LOGAND(op_RSHIFT_15, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_29 = SHIFTRA(Rtt, SN(32, 0x30));
	RzILOpPure *op_AND_32 = LOGAND(op_RSHIFT_29, CAST(64, MSB(SN(32, 0xffff)), SN(32, 0xffff)));
	RzILOpPure *op_MUL_40 = MUL(CAST(64, IL_FALSE, CAST(64, MSB(CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(op_AND_17), DUP(op_AND_17))), CAST(32, MSB(DUP(op_AND_17)), DUP(op_AND_17)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_17)), DUP(op_AND_17))), CAST(32, MSB(DUP(op_AND_17)), DUP(op_AND_17))))), CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(DUP(op_AND_17)), DUP(op_AND_17))), CAST(32, MSB(DUP(op_AND_17)), DUP(op_AND_17)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_17)), DUP(op_AND_17))), CAST(32, MSB(DUP(op_AND_17)), DUP(op_AND_17)))))), EXTRACT64(CAST(64, IL_FALSE, CAST(16, IL_FALSE, op_AND_32)), SN(32, 0), SN(32, 16)));
	RzILOpPure *op_LSHIFT_43 = SHIFTL0(CAST(64, IL_FALSE, op_MUL_40), SN(32, 1));
	RzILOpPure *op_RSHIFT_45 = SHIFTRA(op_LSHIFT_43, SN(32, 16));
	RzILOpPure *op_RSHIFT_54 = SHIFTRA(DUP(Rss), SN(32, 0x20));
	RzILOpPure *op_AND_56 = LOGAND(op_RSHIFT_54, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_67 = SHIFTRA(DUP(Rtt), SN(32, 0x30));
	RzILOpPure *op_AND_70 = LOGAND(op_RSHIFT_67, CAST(64, MSB(SN(32, 0xffff)), SN(32, 0xffff)));
	RzILOpPure *op_MUL_78 = MUL(CAST(64, IL_FALSE, CAST(64, MSB(CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(op_AND_56), DUP(op_AND_56))), CAST(32, MSB(DUP(op_AND_56)), DUP(op_AND_56)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_56)), DUP(op_AND_56))), CAST(32, MSB(DUP(op_AND_56)), DUP(op_AND_56))))), CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(DUP(op_AND_56)), DUP(op_AND_56))), CAST(32, MSB(DUP(op_AND_56)), DUP(op_AND_56)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_56)), DUP(op_AND_56))), CAST(32, MSB(DUP(op_AND_56)), DUP(op_AND_56)))))), EXTRACT64(CAST(64, IL_FALSE, CAST(16, IL_FALSE, op_AND_70)), SN(32, 0), SN(32, 16)));
	RzILOpPure *op_LSHIFT_81 = SHIFTL0(CAST(64, IL_FALSE, op_MUL_78), SN(32, 1));
	RzILOpPure *op_RSHIFT_83 = SHIFTRA(op_LSHIFT_81, SN(32, 16));
	RzILOpPure *op_EQ_84 = EQ(SEXTRACT64(CAST(64, IL_FALSE, op_RSHIFT_45), SN(32, 0), SN(32, 0x20)), op_RSHIFT_83);
	RzILOpPure *op_RSHIFT_124 = SHIFTRA(DUP(Rss), SN(32, 0x20));
	RzILOpPure *op_AND_126 = LOGAND(op_RSHIFT_124, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_137 = SHIFTRA(DUP(Rtt), SN(32, 0x30));
	RzILOpPure *op_AND_140 = LOGAND(op_RSHIFT_137, CAST(64, MSB(SN(32, 0xffff)), SN(32, 0xffff)));
	RzILOpPure *op_MUL_148 = MUL(CAST(64, IL_FALSE, CAST(64, MSB(CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(op_AND_126), DUP(op_AND_126))), CAST(32, MSB(DUP(op_AND_126)), DUP(op_AND_126)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_126)), DUP(op_AND_126))), CAST(32, MSB(DUP(op_AND_126)), DUP(op_AND_126))))), CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(DUP(op_AND_126)), DUP(op_AND_126))), CAST(32, MSB(DUP(op_AND_126)), DUP(op_AND_126)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_126)), DUP(op_AND_126))), CAST(32, MSB(DUP(op_AND_126)), DUP(op_AND_126)))))), EXTRACT64(CAST(64, IL_FALSE, CAST(16, IL_FALSE, op_AND_140)), SN(32, 0), SN(32, 16)));
	RzILOpPure *op_LSHIFT_151 = SHIFTL0(CAST(64, IL_FALSE, op_MUL_148), SN(32, 1));
	RzILOpPure *op_RSHIFT_153 = SHIFTRA(op_LSHIFT_151, SN(32, 16));
	RzILOpPure *op_LT_156 = SLT(op_RSHIFT_153, CAST(64, MSB(SN(32, 0)), SN(32, 0)));
	RzILOpPure *op_LSHIFT_161 = SHIFTL0(SN(64, 1), SN(32, 31));
	RzILOpPure *op_NEG_162 = NEG(op_LSHIFT_161);
	RzILOpPure *op_LSHIFT_167 = SHIFTL0(SN(64, 1), SN(32, 31));
	RzILOpPure *op_SUB_170 = SUB(op_LSHIFT_167, CAST(64, MSB(SN(32, 1)), SN(32, 1)));
	RzILOpPure *cond_171 = ITE(op_LT_156, op_NEG_162, op_SUB_170);
	RzILOpEffect *gcc_expr_172 = BRANCH(op_EQ_84, EMPTY(), set_usr_field_call_120);

	// h_tmp322 = HYB(gcc_expr_if ((sextract64(((ut64) ((((st64) ((ut64) ((st64) ((st32) ((st64) ((st32) ((Rss >> 0x20) & 0xffffffff)))))) * extract64(((ut64) ((ut16) ((Rtt >> 0x30) & ((st64) 0xffff)))), 0x0, 0x10)) << 0x1) >> 0x10)), 0x0, 0x20) == ((((st64) ((ut64) ((st64) ((st32) ((st64) ((st32) ((Rss >> 0x20) & 0xffffffff)))))) * extract64(((ut64) ((ut16) ((Rtt >> 0x30) & ((st64) 0xffff)))), 0x0, 0x10)) << 0x1) >> 0x10))) {{}} else {set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, ((ut32) 0x1))}, ((((((st64) ((ut64) ((st64) ((st32) ((st64) ((st32) ((Rss >> 0x20) & 0xffffffff)))))) * extract64(((ut64) ((ut16) ((Rtt >> 0x30) & ((st64) 0xffff)))), 0x0, 0x10)) << 0x1) >> 0x10) < ((st64) 0x0)) ? (-(0x1 << 0x1f)) : (0x1 << 0x1f) - ((st64) 0x1)));
	RzILOpEffect *op_ASSIGN_hybrid_tmp_174 = SETL("h_tmp322", cond_171);

	// seq(HYB(gcc_expr_if ((sextract64(((ut64) ((((st64) ((ut64) ((st6 ...;
	RzILOpEffect *seq_175 = SEQN(2, gcc_expr_172, op_ASSIGN_hybrid_tmp_174);

	// Rdd = ((Rdd & (~(0xffffffff << 0x20))) | ((((sextract64(((ut64) ((((st64) ((ut64) ((st64) ((st32) ((st64) ((st32) ((Rss >> 0x20) & 0xffffffff)))))) * extract64(((ut64) ((ut16) ((Rtt >> 0x30) & ((st64) 0xffff)))), 0x0, 0x10)) << 0x1) >> 0x10)), 0x0, 0x20) == ((((st64) ((ut64) ((st64) ((st32) ((st64) ((st32) ((Rss >> 0x20) & 0xffffffff)))))) * extract64(((ut64) ((ut16) ((Rtt >> 0x30) & ((st64) 0xffff)))), 0x0, 0x10)) << 0x1) >> 0x10)) ? ((((st64) ((ut64) ((st64) ((st32) ((st64) ((st32) ((Rss >> 0x20) & 0xffffffff)))))) * extract64(((ut64) ((ut16) ((Rtt >> 0x30) & ((st64) 0xffff)))), 0x0, 0x10)) << 0x1) >> 0x10) : h_tmp322) & 0xffffffff) << 0x20));
	RzILOpPure *op_LSHIFT_5 = SHIFTL0(SN(64, 0xffffffff), SN(32, 0x20));
	RzILOpPure *op_NOT_6 = LOGNOT(op_LSHIFT_5);
	RzILOpPure *op_AND_7 = LOGAND(READ_REG(pkt, Rdd_op, true), op_NOT_6);
	RzILOpPure *op_RSHIFT_88 = SHIFTRA(DUP(Rss), SN(32, 0x20));
	RzILOpPure *op_AND_90 = LOGAND(op_RSHIFT_88, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_101 = SHIFTRA(DUP(Rtt), SN(32, 0x30));
	RzILOpPure *op_AND_104 = LOGAND(op_RSHIFT_101, CAST(64, MSB(SN(32, 0xffff)), SN(32, 0xffff)));
	RzILOpPure *op_MUL_112 = MUL(CAST(64, IL_FALSE, CAST(64, MSB(CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(op_AND_90), DUP(op_AND_90))), CAST(32, MSB(DUP(op_AND_90)), DUP(op_AND_90)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_90)), DUP(op_AND_90))), CAST(32, MSB(DUP(op_AND_90)), DUP(op_AND_90))))), CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(DUP(op_AND_90)), DUP(op_AND_90))), CAST(32, MSB(DUP(op_AND_90)), DUP(op_AND_90)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_90)), DUP(op_AND_90))), CAST(32, MSB(DUP(op_AND_90)), DUP(op_AND_90)))))), EXTRACT64(CAST(64, IL_FALSE, CAST(16, IL_FALSE, op_AND_104)), SN(32, 0), SN(32, 16)));
	RzILOpPure *op_LSHIFT_115 = SHIFTL0(CAST(64, IL_FALSE, op_MUL_112), SN(32, 1));
	RzILOpPure *op_RSHIFT_117 = SHIFTRA(op_LSHIFT_115, SN(32, 16));
	RzILOpPure *cond_176 = ITE(DUP(op_EQ_84), op_RSHIFT_117, VARL("h_tmp322"));
	RzILOpPure *op_AND_178 = LOGAND(cond_176, SN(64, 0xffffffff));
	RzILOpPure *op_LSHIFT_182 = SHIFTL0(op_AND_178, SN(32, 0x20));
	RzILOpPure *op_OR_183 = LOGOR(op_AND_7, op_LSHIFT_182);
	RzILOpEffect *op_ASSIGN_184 = WRITE_REG(bundle, Rdd_op, op_OR_183);

	// seq(seq(HYB(gcc_expr_if ((sextract64(((ut64) ((((st64) ((ut64) ( ...;
	RzILOpEffect *seq_185 = SEQN(2, seq_175, op_ASSIGN_184);

	// set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, ((ut32) 0x1));
	RzILOpEffect *set_usr_field_call_304 = hex_set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, CAST(32, IL_FALSE, SN(32, 1)));

	// HYB(gcc_expr_if ((sextract64(((ut64) ((((st64) ((ut64) ((st64) ((st32) ((st64) ((st32) ((Rss >> 0x0) & 0xffffffff)))))) * extract64(((ut64) ((ut16) ((Rtt >> 0x10) & ((st64) 0xffff)))), 0x0, 0x10)) << 0x1) >> 0x10)), 0x0, 0x20) == ((((st64) ((ut64) ((st64) ((st32) ((st64) ((st32) ((Rss >> 0x0) & 0xffffffff)))))) * extract64(((ut64) ((ut16) ((Rtt >> 0x10) & ((st64) 0xffff)))), 0x0, 0x10)) << 0x1) >> 0x10))) {{}} else {set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, ((ut32) 0x1))}, ((((((st64) ((ut64) ((st64) ((st32) ((st64) ((st32) ((Rss >> 0x0) & 0xffffffff)))))) * extract64(((ut64) ((ut16) ((Rtt >> 0x10) & ((st64) 0xffff)))), 0x0, 0x10)) << 0x1) >> 0x10) < ((st64) 0x0)) ? (-(0x1 << 0x1f)) : (0x1 << 0x1f) - ((st64) 0x1)));
	RzILOpPure *op_RSHIFT_200 = SHIFTRA(DUP(Rss), SN(32, 0));
	RzILOpPure *op_AND_202 = LOGAND(op_RSHIFT_200, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_213 = SHIFTRA(DUP(Rtt), SN(32, 16));
	RzILOpPure *op_AND_216 = LOGAND(op_RSHIFT_213, CAST(64, MSB(SN(32, 0xffff)), SN(32, 0xffff)));
	RzILOpPure *op_MUL_224 = MUL(CAST(64, IL_FALSE, CAST(64, MSB(CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(op_AND_202), DUP(op_AND_202))), CAST(32, MSB(DUP(op_AND_202)), DUP(op_AND_202)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_202)), DUP(op_AND_202))), CAST(32, MSB(DUP(op_AND_202)), DUP(op_AND_202))))), CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(DUP(op_AND_202)), DUP(op_AND_202))), CAST(32, MSB(DUP(op_AND_202)), DUP(op_AND_202)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_202)), DUP(op_AND_202))), CAST(32, MSB(DUP(op_AND_202)), DUP(op_AND_202)))))), EXTRACT64(CAST(64, IL_FALSE, CAST(16, IL_FALSE, op_AND_216)), SN(32, 0), SN(32, 16)));
	RzILOpPure *op_LSHIFT_227 = SHIFTL0(CAST(64, IL_FALSE, op_MUL_224), SN(32, 1));
	RzILOpPure *op_RSHIFT_229 = SHIFTRA(op_LSHIFT_227, SN(32, 16));
	RzILOpPure *op_RSHIFT_238 = SHIFTRA(DUP(Rss), SN(32, 0));
	RzILOpPure *op_AND_240 = LOGAND(op_RSHIFT_238, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_251 = SHIFTRA(DUP(Rtt), SN(32, 16));
	RzILOpPure *op_AND_254 = LOGAND(op_RSHIFT_251, CAST(64, MSB(SN(32, 0xffff)), SN(32, 0xffff)));
	RzILOpPure *op_MUL_262 = MUL(CAST(64, IL_FALSE, CAST(64, MSB(CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(op_AND_240), DUP(op_AND_240))), CAST(32, MSB(DUP(op_AND_240)), DUP(op_AND_240)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_240)), DUP(op_AND_240))), CAST(32, MSB(DUP(op_AND_240)), DUP(op_AND_240))))), CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(DUP(op_AND_240)), DUP(op_AND_240))), CAST(32, MSB(DUP(op_AND_240)), DUP(op_AND_240)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_240)), DUP(op_AND_240))), CAST(32, MSB(DUP(op_AND_240)), DUP(op_AND_240)))))), EXTRACT64(CAST(64, IL_FALSE, CAST(16, IL_FALSE, op_AND_254)), SN(32, 0), SN(32, 16)));
	RzILOpPure *op_LSHIFT_265 = SHIFTL0(CAST(64, IL_FALSE, op_MUL_262), SN(32, 1));
	RzILOpPure *op_RSHIFT_267 = SHIFTRA(op_LSHIFT_265, SN(32, 16));
	RzILOpPure *op_EQ_268 = EQ(SEXTRACT64(CAST(64, IL_FALSE, op_RSHIFT_229), SN(32, 0), SN(32, 0x20)), op_RSHIFT_267);
	RzILOpPure *op_RSHIFT_308 = SHIFTRA(DUP(Rss), SN(32, 0));
	RzILOpPure *op_AND_310 = LOGAND(op_RSHIFT_308, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_321 = SHIFTRA(DUP(Rtt), SN(32, 16));
	RzILOpPure *op_AND_324 = LOGAND(op_RSHIFT_321, CAST(64, MSB(SN(32, 0xffff)), SN(32, 0xffff)));
	RzILOpPure *op_MUL_332 = MUL(CAST(64, IL_FALSE, CAST(64, MSB(CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(op_AND_310), DUP(op_AND_310))), CAST(32, MSB(DUP(op_AND_310)), DUP(op_AND_310)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_310)), DUP(op_AND_310))), CAST(32, MSB(DUP(op_AND_310)), DUP(op_AND_310))))), CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(DUP(op_AND_310)), DUP(op_AND_310))), CAST(32, MSB(DUP(op_AND_310)), DUP(op_AND_310)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_310)), DUP(op_AND_310))), CAST(32, MSB(DUP(op_AND_310)), DUP(op_AND_310)))))), EXTRACT64(CAST(64, IL_FALSE, CAST(16, IL_FALSE, op_AND_324)), SN(32, 0), SN(32, 16)));
	RzILOpPure *op_LSHIFT_335 = SHIFTL0(CAST(64, IL_FALSE, op_MUL_332), SN(32, 1));
	RzILOpPure *op_RSHIFT_337 = SHIFTRA(op_LSHIFT_335, SN(32, 16));
	RzILOpPure *op_LT_340 = SLT(op_RSHIFT_337, CAST(64, MSB(SN(32, 0)), SN(32, 0)));
	RzILOpPure *op_LSHIFT_345 = SHIFTL0(SN(64, 1), SN(32, 31));
	RzILOpPure *op_NEG_346 = NEG(op_LSHIFT_345);
	RzILOpPure *op_LSHIFT_351 = SHIFTL0(SN(64, 1), SN(32, 31));
	RzILOpPure *op_SUB_354 = SUB(op_LSHIFT_351, CAST(64, MSB(SN(32, 1)), SN(32, 1)));
	RzILOpPure *cond_355 = ITE(op_LT_340, op_NEG_346, op_SUB_354);
	RzILOpEffect *gcc_expr_356 = BRANCH(op_EQ_268, EMPTY(), set_usr_field_call_304);

	// h_tmp323 = HYB(gcc_expr_if ((sextract64(((ut64) ((((st64) ((ut64) ((st64) ((st32) ((st64) ((st32) ((Rss >> 0x0) & 0xffffffff)))))) * extract64(((ut64) ((ut16) ((Rtt >> 0x10) & ((st64) 0xffff)))), 0x0, 0x10)) << 0x1) >> 0x10)), 0x0, 0x20) == ((((st64) ((ut64) ((st64) ((st32) ((st64) ((st32) ((Rss >> 0x0) & 0xffffffff)))))) * extract64(((ut64) ((ut16) ((Rtt >> 0x10) & ((st64) 0xffff)))), 0x0, 0x10)) << 0x1) >> 0x10))) {{}} else {set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, ((ut32) 0x1))}, ((((((st64) ((ut64) ((st64) ((st32) ((st64) ((st32) ((Rss >> 0x0) & 0xffffffff)))))) * extract64(((ut64) ((ut16) ((Rtt >> 0x10) & ((st64) 0xffff)))), 0x0, 0x10)) << 0x1) >> 0x10) < ((st64) 0x0)) ? (-(0x1 << 0x1f)) : (0x1 << 0x1f) - ((st64) 0x1)));
	RzILOpEffect *op_ASSIGN_hybrid_tmp_358 = SETL("h_tmp323", cond_355);

	// seq(HYB(gcc_expr_if ((sextract64(((ut64) ((((st64) ((ut64) ((st6 ...;
	RzILOpEffect *seq_359 = SEQN(2, gcc_expr_356, op_ASSIGN_hybrid_tmp_358);

	// Rdd = ((Rdd & (~(0xffffffff << 0x0))) | ((((sextract64(((ut64) ((((st64) ((ut64) ((st64) ((st32) ((st64) ((st32) ((Rss >> 0x0) & 0xffffffff)))))) * extract64(((ut64) ((ut16) ((Rtt >> 0x10) & ((st64) 0xffff)))), 0x0, 0x10)) << 0x1) >> 0x10)), 0x0, 0x20) == ((((st64) ((ut64) ((st64) ((st32) ((st64) ((st32) ((Rss >> 0x0) & 0xffffffff)))))) * extract64(((ut64) ((ut16) ((Rtt >> 0x10) & ((st64) 0xffff)))), 0x0, 0x10)) << 0x1) >> 0x10)) ? ((((st64) ((ut64) ((st64) ((st32) ((st64) ((st32) ((Rss >> 0x0) & 0xffffffff)))))) * extract64(((ut64) ((ut16) ((Rtt >> 0x10) & ((st64) 0xffff)))), 0x0, 0x10)) << 0x1) >> 0x10) : h_tmp323) & 0xffffffff) << 0x0));
	RzILOpPure *op_LSHIFT_191 = SHIFTL0(SN(64, 0xffffffff), SN(32, 0));
	RzILOpPure *op_NOT_192 = LOGNOT(op_LSHIFT_191);
	RzILOpPure *op_AND_193 = LOGAND(READ_REG(pkt, Rdd_op, true), op_NOT_192);
	RzILOpPure *op_RSHIFT_272 = SHIFTRA(DUP(Rss), SN(32, 0));
	RzILOpPure *op_AND_274 = LOGAND(op_RSHIFT_272, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_285 = SHIFTRA(DUP(Rtt), SN(32, 16));
	RzILOpPure *op_AND_288 = LOGAND(op_RSHIFT_285, CAST(64, MSB(SN(32, 0xffff)), SN(32, 0xffff)));
	RzILOpPure *op_MUL_296 = MUL(CAST(64, IL_FALSE, CAST(64, MSB(CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(op_AND_274), DUP(op_AND_274))), CAST(32, MSB(DUP(op_AND_274)), DUP(op_AND_274)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_274)), DUP(op_AND_274))), CAST(32, MSB(DUP(op_AND_274)), DUP(op_AND_274))))), CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(DUP(op_AND_274)), DUP(op_AND_274))), CAST(32, MSB(DUP(op_AND_274)), DUP(op_AND_274)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_274)), DUP(op_AND_274))), CAST(32, MSB(DUP(op_AND_274)), DUP(op_AND_274)))))), EXTRACT64(CAST(64, IL_FALSE, CAST(16, IL_FALSE, op_AND_288)), SN(32, 0), SN(32, 16)));
	RzILOpPure *op_LSHIFT_299 = SHIFTL0(CAST(64, IL_FALSE, op_MUL_296), SN(32, 1));
	RzILOpPure *op_RSHIFT_301 = SHIFTRA(op_LSHIFT_299, SN(32, 16));
	RzILOpPure *cond_360 = ITE(DUP(op_EQ_268), op_RSHIFT_301, VARL("h_tmp323"));
	RzILOpPure *op_AND_362 = LOGAND(cond_360, SN(64, 0xffffffff));
	RzILOpPure *op_LSHIFT_366 = SHIFTL0(op_AND_362, SN(32, 0));
	RzILOpPure *op_OR_367 = LOGOR(op_AND_193, op_LSHIFT_366);
	RzILOpEffect *op_ASSIGN_368 = WRITE_REG(bundle, Rdd_op, op_OR_367);

	// seq(seq(HYB(gcc_expr_if ((sextract64(((ut64) ((((st64) ((ut64) ( ...;
	RzILOpEffect *seq_369 = SEQN(2, seq_359, op_ASSIGN_368);

	RzILOpEffect *instruction_sequence = SEQN(2, seq_185, seq_369);
	return instruction_sequence;
}

// Rdd = vmpyweuh(Rss,Rtt):rnd:sat
RzILOpEffect *hex_il_op_m2_mmpyul_rs0(HexInsnPktBundle *bundle) {
	const HexInsn *hi = bundle->insn;
	HexPkt *pkt = bundle->pkt;
	// READ
	const HexOp *Rdd_op = ISA2REG(hi, 'd', false);
	const HexOp *Rss_op = ISA2REG(hi, 's', false);
	RzILOpPure *Rss = READ_REG(pkt, Rss_op, false);
	const HexOp *Rtt_op = ISA2REG(hi, 't', false);
	RzILOpPure *Rtt = READ_REG(pkt, Rtt_op, false);

	// set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, ((ut32) 0x1));
	RzILOpEffect *set_usr_field_call_129 = hex_set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, CAST(32, IL_FALSE, SN(32, 1)));

	// HYB(gcc_expr_if ((sextract64(((ut64) ((((st64) ((ut64) ((st64) ((st32) ((st64) ((st32) ((Rss >> 0x20) & 0xffffffff)))))) * extract64(((ut64) ((ut16) ((Rtt >> 0x20) & ((st64) 0xffff)))), 0x0, 0x10)) << 0x0) + ((st64) 0x8000) >> 0x10)), 0x0, 0x20) == ((((st64) ((ut64) ((st64) ((st32) ((st64) ((st32) ((Rss >> 0x20) & 0xffffffff)))))) * extract64(((ut64) ((ut16) ((Rtt >> 0x20) & ((st64) 0xffff)))), 0x0, 0x10)) << 0x0) + ((st64) 0x8000) >> 0x10))) {{}} else {set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, ((ut32) 0x1))}, ((((((st64) ((ut64) ((st64) ((st32) ((st64) ((st32) ((Rss >> 0x20) & 0xffffffff)))))) * extract64(((ut64) ((ut16) ((Rtt >> 0x20) & ((st64) 0xffff)))), 0x0, 0x10)) << 0x0) + ((st64) 0x8000) >> 0x10) < ((st64) 0x0)) ? (-(0x1 << 0x1f)) : (0x1 << 0x1f) - ((st64) 0x1)));
	RzILOpPure *op_RSHIFT_15 = SHIFTRA(Rss, SN(32, 0x20));
	RzILOpPure *op_AND_17 = LOGAND(op_RSHIFT_15, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_29 = SHIFTRA(Rtt, SN(32, 0x20));
	RzILOpPure *op_AND_32 = LOGAND(op_RSHIFT_29, CAST(64, MSB(SN(32, 0xffff)), SN(32, 0xffff)));
	RzILOpPure *op_MUL_40 = MUL(CAST(64, IL_FALSE, CAST(64, MSB(CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(op_AND_17), DUP(op_AND_17))), CAST(32, MSB(DUP(op_AND_17)), DUP(op_AND_17)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_17)), DUP(op_AND_17))), CAST(32, MSB(DUP(op_AND_17)), DUP(op_AND_17))))), CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(DUP(op_AND_17)), DUP(op_AND_17))), CAST(32, MSB(DUP(op_AND_17)), DUP(op_AND_17)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_17)), DUP(op_AND_17))), CAST(32, MSB(DUP(op_AND_17)), DUP(op_AND_17)))))), EXTRACT64(CAST(64, IL_FALSE, CAST(16, IL_FALSE, op_AND_32)), SN(32, 0), SN(32, 16)));
	RzILOpPure *op_LSHIFT_43 = SHIFTL0(CAST(64, IL_FALSE, op_MUL_40), SN(32, 0));
	RzILOpPure *op_ADD_46 = ADD(op_LSHIFT_43, CAST(64, MSB(SN(32, 0x8000)), SN(32, 0x8000)));
	RzILOpPure *op_RSHIFT_48 = SHIFTRA(op_ADD_46, SN(32, 16));
	RzILOpPure *op_RSHIFT_57 = SHIFTRA(DUP(Rss), SN(32, 0x20));
	RzILOpPure *op_AND_59 = LOGAND(op_RSHIFT_57, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_70 = SHIFTRA(DUP(Rtt), SN(32, 0x20));
	RzILOpPure *op_AND_73 = LOGAND(op_RSHIFT_70, CAST(64, MSB(SN(32, 0xffff)), SN(32, 0xffff)));
	RzILOpPure *op_MUL_81 = MUL(CAST(64, IL_FALSE, CAST(64, MSB(CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(op_AND_59), DUP(op_AND_59))), CAST(32, MSB(DUP(op_AND_59)), DUP(op_AND_59)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_59)), DUP(op_AND_59))), CAST(32, MSB(DUP(op_AND_59)), DUP(op_AND_59))))), CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(DUP(op_AND_59)), DUP(op_AND_59))), CAST(32, MSB(DUP(op_AND_59)), DUP(op_AND_59)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_59)), DUP(op_AND_59))), CAST(32, MSB(DUP(op_AND_59)), DUP(op_AND_59)))))), EXTRACT64(CAST(64, IL_FALSE, CAST(16, IL_FALSE, op_AND_73)), SN(32, 0), SN(32, 16)));
	RzILOpPure *op_LSHIFT_84 = SHIFTL0(CAST(64, IL_FALSE, op_MUL_81), SN(32, 0));
	RzILOpPure *op_ADD_87 = ADD(op_LSHIFT_84, CAST(64, MSB(SN(32, 0x8000)), SN(32, 0x8000)));
	RzILOpPure *op_RSHIFT_89 = SHIFTRA(op_ADD_87, SN(32, 16));
	RzILOpPure *op_EQ_90 = EQ(SEXTRACT64(CAST(64, IL_FALSE, op_RSHIFT_48), SN(32, 0), SN(32, 0x20)), op_RSHIFT_89);
	RzILOpPure *op_RSHIFT_133 = SHIFTRA(DUP(Rss), SN(32, 0x20));
	RzILOpPure *op_AND_135 = LOGAND(op_RSHIFT_133, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_146 = SHIFTRA(DUP(Rtt), SN(32, 0x20));
	RzILOpPure *op_AND_149 = LOGAND(op_RSHIFT_146, CAST(64, MSB(SN(32, 0xffff)), SN(32, 0xffff)));
	RzILOpPure *op_MUL_157 = MUL(CAST(64, IL_FALSE, CAST(64, MSB(CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(op_AND_135), DUP(op_AND_135))), CAST(32, MSB(DUP(op_AND_135)), DUP(op_AND_135)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_135)), DUP(op_AND_135))), CAST(32, MSB(DUP(op_AND_135)), DUP(op_AND_135))))), CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(DUP(op_AND_135)), DUP(op_AND_135))), CAST(32, MSB(DUP(op_AND_135)), DUP(op_AND_135)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_135)), DUP(op_AND_135))), CAST(32, MSB(DUP(op_AND_135)), DUP(op_AND_135)))))), EXTRACT64(CAST(64, IL_FALSE, CAST(16, IL_FALSE, op_AND_149)), SN(32, 0), SN(32, 16)));
	RzILOpPure *op_LSHIFT_160 = SHIFTL0(CAST(64, IL_FALSE, op_MUL_157), SN(32, 0));
	RzILOpPure *op_ADD_163 = ADD(op_LSHIFT_160, CAST(64, MSB(SN(32, 0x8000)), SN(32, 0x8000)));
	RzILOpPure *op_RSHIFT_165 = SHIFTRA(op_ADD_163, SN(32, 16));
	RzILOpPure *op_LT_168 = SLT(op_RSHIFT_165, CAST(64, MSB(SN(32, 0)), SN(32, 0)));
	RzILOpPure *op_LSHIFT_173 = SHIFTL0(SN(64, 1), SN(32, 31));
	RzILOpPure *op_NEG_174 = NEG(op_LSHIFT_173);
	RzILOpPure *op_LSHIFT_179 = SHIFTL0(SN(64, 1), SN(32, 31));
	RzILOpPure *op_SUB_182 = SUB(op_LSHIFT_179, CAST(64, MSB(SN(32, 1)), SN(32, 1)));
	RzILOpPure *cond_183 = ITE(op_LT_168, op_NEG_174, op_SUB_182);
	RzILOpEffect *gcc_expr_184 = BRANCH(op_EQ_90, EMPTY(), set_usr_field_call_129);

	// h_tmp324 = HYB(gcc_expr_if ((sextract64(((ut64) ((((st64) ((ut64) ((st64) ((st32) ((st64) ((st32) ((Rss >> 0x20) & 0xffffffff)))))) * extract64(((ut64) ((ut16) ((Rtt >> 0x20) & ((st64) 0xffff)))), 0x0, 0x10)) << 0x0) + ((st64) 0x8000) >> 0x10)), 0x0, 0x20) == ((((st64) ((ut64) ((st64) ((st32) ((st64) ((st32) ((Rss >> 0x20) & 0xffffffff)))))) * extract64(((ut64) ((ut16) ((Rtt >> 0x20) & ((st64) 0xffff)))), 0x0, 0x10)) << 0x0) + ((st64) 0x8000) >> 0x10))) {{}} else {set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, ((ut32) 0x1))}, ((((((st64) ((ut64) ((st64) ((st32) ((st64) ((st32) ((Rss >> 0x20) & 0xffffffff)))))) * extract64(((ut64) ((ut16) ((Rtt >> 0x20) & ((st64) 0xffff)))), 0x0, 0x10)) << 0x0) + ((st64) 0x8000) >> 0x10) < ((st64) 0x0)) ? (-(0x1 << 0x1f)) : (0x1 << 0x1f) - ((st64) 0x1)));
	RzILOpEffect *op_ASSIGN_hybrid_tmp_186 = SETL("h_tmp324", cond_183);

	// seq(HYB(gcc_expr_if ((sextract64(((ut64) ((((st64) ((ut64) ((st6 ...;
	RzILOpEffect *seq_187 = SEQN(2, gcc_expr_184, op_ASSIGN_hybrid_tmp_186);

	// Rdd = ((Rdd & (~(0xffffffff << 0x20))) | ((((sextract64(((ut64) ((((st64) ((ut64) ((st64) ((st32) ((st64) ((st32) ((Rss >> 0x20) & 0xffffffff)))))) * extract64(((ut64) ((ut16) ((Rtt >> 0x20) & ((st64) 0xffff)))), 0x0, 0x10)) << 0x0) + ((st64) 0x8000) >> 0x10)), 0x0, 0x20) == ((((st64) ((ut64) ((st64) ((st32) ((st64) ((st32) ((Rss >> 0x20) & 0xffffffff)))))) * extract64(((ut64) ((ut16) ((Rtt >> 0x20) & ((st64) 0xffff)))), 0x0, 0x10)) << 0x0) + ((st64) 0x8000) >> 0x10)) ? ((((st64) ((ut64) ((st64) ((st32) ((st64) ((st32) ((Rss >> 0x20) & 0xffffffff)))))) * extract64(((ut64) ((ut16) ((Rtt >> 0x20) & ((st64) 0xffff)))), 0x0, 0x10)) << 0x0) + ((st64) 0x8000) >> 0x10) : h_tmp324) & 0xffffffff) << 0x20));
	RzILOpPure *op_LSHIFT_5 = SHIFTL0(SN(64, 0xffffffff), SN(32, 0x20));
	RzILOpPure *op_NOT_6 = LOGNOT(op_LSHIFT_5);
	RzILOpPure *op_AND_7 = LOGAND(READ_REG(pkt, Rdd_op, true), op_NOT_6);
	RzILOpPure *op_RSHIFT_94 = SHIFTRA(DUP(Rss), SN(32, 0x20));
	RzILOpPure *op_AND_96 = LOGAND(op_RSHIFT_94, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_107 = SHIFTRA(DUP(Rtt), SN(32, 0x20));
	RzILOpPure *op_AND_110 = LOGAND(op_RSHIFT_107, CAST(64, MSB(SN(32, 0xffff)), SN(32, 0xffff)));
	RzILOpPure *op_MUL_118 = MUL(CAST(64, IL_FALSE, CAST(64, MSB(CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(op_AND_96), DUP(op_AND_96))), CAST(32, MSB(DUP(op_AND_96)), DUP(op_AND_96)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_96)), DUP(op_AND_96))), CAST(32, MSB(DUP(op_AND_96)), DUP(op_AND_96))))), CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(DUP(op_AND_96)), DUP(op_AND_96))), CAST(32, MSB(DUP(op_AND_96)), DUP(op_AND_96)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_96)), DUP(op_AND_96))), CAST(32, MSB(DUP(op_AND_96)), DUP(op_AND_96)))))), EXTRACT64(CAST(64, IL_FALSE, CAST(16, IL_FALSE, op_AND_110)), SN(32, 0), SN(32, 16)));
	RzILOpPure *op_LSHIFT_121 = SHIFTL0(CAST(64, IL_FALSE, op_MUL_118), SN(32, 0));
	RzILOpPure *op_ADD_124 = ADD(op_LSHIFT_121, CAST(64, MSB(SN(32, 0x8000)), SN(32, 0x8000)));
	RzILOpPure *op_RSHIFT_126 = SHIFTRA(op_ADD_124, SN(32, 16));
	RzILOpPure *cond_188 = ITE(DUP(op_EQ_90), op_RSHIFT_126, VARL("h_tmp324"));
	RzILOpPure *op_AND_190 = LOGAND(cond_188, SN(64, 0xffffffff));
	RzILOpPure *op_LSHIFT_194 = SHIFTL0(op_AND_190, SN(32, 0x20));
	RzILOpPure *op_OR_195 = LOGOR(op_AND_7, op_LSHIFT_194);
	RzILOpEffect *op_ASSIGN_196 = WRITE_REG(bundle, Rdd_op, op_OR_195);

	// seq(seq(HYB(gcc_expr_if ((sextract64(((ut64) ((((st64) ((ut64) ( ...;
	RzILOpEffect *seq_197 = SEQN(2, seq_187, op_ASSIGN_196);

	// set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, ((ut32) 0x1));
	RzILOpEffect *set_usr_field_call_325 = hex_set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, CAST(32, IL_FALSE, SN(32, 1)));

	// HYB(gcc_expr_if ((sextract64(((ut64) ((((st64) ((ut64) ((st64) ((st32) ((st64) ((st32) ((Rss >> 0x0) & 0xffffffff)))))) * extract64(((ut64) ((ut16) ((Rtt >> 0x0) & ((st64) 0xffff)))), 0x0, 0x10)) << 0x0) + ((st64) 0x8000) >> 0x10)), 0x0, 0x20) == ((((st64) ((ut64) ((st64) ((st32) ((st64) ((st32) ((Rss >> 0x0) & 0xffffffff)))))) * extract64(((ut64) ((ut16) ((Rtt >> 0x0) & ((st64) 0xffff)))), 0x0, 0x10)) << 0x0) + ((st64) 0x8000) >> 0x10))) {{}} else {set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, ((ut32) 0x1))}, ((((((st64) ((ut64) ((st64) ((st32) ((st64) ((st32) ((Rss >> 0x0) & 0xffffffff)))))) * extract64(((ut64) ((ut16) ((Rtt >> 0x0) & ((st64) 0xffff)))), 0x0, 0x10)) << 0x0) + ((st64) 0x8000) >> 0x10) < ((st64) 0x0)) ? (-(0x1 << 0x1f)) : (0x1 << 0x1f) - ((st64) 0x1)));
	RzILOpPure *op_RSHIFT_212 = SHIFTRA(DUP(Rss), SN(32, 0));
	RzILOpPure *op_AND_214 = LOGAND(op_RSHIFT_212, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_225 = SHIFTRA(DUP(Rtt), SN(32, 0));
	RzILOpPure *op_AND_228 = LOGAND(op_RSHIFT_225, CAST(64, MSB(SN(32, 0xffff)), SN(32, 0xffff)));
	RzILOpPure *op_MUL_236 = MUL(CAST(64, IL_FALSE, CAST(64, MSB(CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(op_AND_214), DUP(op_AND_214))), CAST(32, MSB(DUP(op_AND_214)), DUP(op_AND_214)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_214)), DUP(op_AND_214))), CAST(32, MSB(DUP(op_AND_214)), DUP(op_AND_214))))), CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(DUP(op_AND_214)), DUP(op_AND_214))), CAST(32, MSB(DUP(op_AND_214)), DUP(op_AND_214)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_214)), DUP(op_AND_214))), CAST(32, MSB(DUP(op_AND_214)), DUP(op_AND_214)))))), EXTRACT64(CAST(64, IL_FALSE, CAST(16, IL_FALSE, op_AND_228)), SN(32, 0), SN(32, 16)));
	RzILOpPure *op_LSHIFT_239 = SHIFTL0(CAST(64, IL_FALSE, op_MUL_236), SN(32, 0));
	RzILOpPure *op_ADD_242 = ADD(op_LSHIFT_239, CAST(64, MSB(SN(32, 0x8000)), SN(32, 0x8000)));
	RzILOpPure *op_RSHIFT_244 = SHIFTRA(op_ADD_242, SN(32, 16));
	RzILOpPure *op_RSHIFT_253 = SHIFTRA(DUP(Rss), SN(32, 0));
	RzILOpPure *op_AND_255 = LOGAND(op_RSHIFT_253, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_266 = SHIFTRA(DUP(Rtt), SN(32, 0));
	RzILOpPure *op_AND_269 = LOGAND(op_RSHIFT_266, CAST(64, MSB(SN(32, 0xffff)), SN(32, 0xffff)));
	RzILOpPure *op_MUL_277 = MUL(CAST(64, IL_FALSE, CAST(64, MSB(CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(op_AND_255), DUP(op_AND_255))), CAST(32, MSB(DUP(op_AND_255)), DUP(op_AND_255)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_255)), DUP(op_AND_255))), CAST(32, MSB(DUP(op_AND_255)), DUP(op_AND_255))))), CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(DUP(op_AND_255)), DUP(op_AND_255))), CAST(32, MSB(DUP(op_AND_255)), DUP(op_AND_255)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_255)), DUP(op_AND_255))), CAST(32, MSB(DUP(op_AND_255)), DUP(op_AND_255)))))), EXTRACT64(CAST(64, IL_FALSE, CAST(16, IL_FALSE, op_AND_269)), SN(32, 0), SN(32, 16)));
	RzILOpPure *op_LSHIFT_280 = SHIFTL0(CAST(64, IL_FALSE, op_MUL_277), SN(32, 0));
	RzILOpPure *op_ADD_283 = ADD(op_LSHIFT_280, CAST(64, MSB(SN(32, 0x8000)), SN(32, 0x8000)));
	RzILOpPure *op_RSHIFT_285 = SHIFTRA(op_ADD_283, SN(32, 16));
	RzILOpPure *op_EQ_286 = EQ(SEXTRACT64(CAST(64, IL_FALSE, op_RSHIFT_244), SN(32, 0), SN(32, 0x20)), op_RSHIFT_285);
	RzILOpPure *op_RSHIFT_329 = SHIFTRA(DUP(Rss), SN(32, 0));
	RzILOpPure *op_AND_331 = LOGAND(op_RSHIFT_329, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_342 = SHIFTRA(DUP(Rtt), SN(32, 0));
	RzILOpPure *op_AND_345 = LOGAND(op_RSHIFT_342, CAST(64, MSB(SN(32, 0xffff)), SN(32, 0xffff)));
	RzILOpPure *op_MUL_353 = MUL(CAST(64, IL_FALSE, CAST(64, MSB(CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(op_AND_331), DUP(op_AND_331))), CAST(32, MSB(DUP(op_AND_331)), DUP(op_AND_331)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_331)), DUP(op_AND_331))), CAST(32, MSB(DUP(op_AND_331)), DUP(op_AND_331))))), CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(DUP(op_AND_331)), DUP(op_AND_331))), CAST(32, MSB(DUP(op_AND_331)), DUP(op_AND_331)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_331)), DUP(op_AND_331))), CAST(32, MSB(DUP(op_AND_331)), DUP(op_AND_331)))))), EXTRACT64(CAST(64, IL_FALSE, CAST(16, IL_FALSE, op_AND_345)), SN(32, 0), SN(32, 16)));
	RzILOpPure *op_LSHIFT_356 = SHIFTL0(CAST(64, IL_FALSE, op_MUL_353), SN(32, 0));
	RzILOpPure *op_ADD_359 = ADD(op_LSHIFT_356, CAST(64, MSB(SN(32, 0x8000)), SN(32, 0x8000)));
	RzILOpPure *op_RSHIFT_361 = SHIFTRA(op_ADD_359, SN(32, 16));
	RzILOpPure *op_LT_364 = SLT(op_RSHIFT_361, CAST(64, MSB(SN(32, 0)), SN(32, 0)));
	RzILOpPure *op_LSHIFT_369 = SHIFTL0(SN(64, 1), SN(32, 31));
	RzILOpPure *op_NEG_370 = NEG(op_LSHIFT_369);
	RzILOpPure *op_LSHIFT_375 = SHIFTL0(SN(64, 1), SN(32, 31));
	RzILOpPure *op_SUB_378 = SUB(op_LSHIFT_375, CAST(64, MSB(SN(32, 1)), SN(32, 1)));
	RzILOpPure *cond_379 = ITE(op_LT_364, op_NEG_370, op_SUB_378);
	RzILOpEffect *gcc_expr_380 = BRANCH(op_EQ_286, EMPTY(), set_usr_field_call_325);

	// h_tmp325 = HYB(gcc_expr_if ((sextract64(((ut64) ((((st64) ((ut64) ((st64) ((st32) ((st64) ((st32) ((Rss >> 0x0) & 0xffffffff)))))) * extract64(((ut64) ((ut16) ((Rtt >> 0x0) & ((st64) 0xffff)))), 0x0, 0x10)) << 0x0) + ((st64) 0x8000) >> 0x10)), 0x0, 0x20) == ((((st64) ((ut64) ((st64) ((st32) ((st64) ((st32) ((Rss >> 0x0) & 0xffffffff)))))) * extract64(((ut64) ((ut16) ((Rtt >> 0x0) & ((st64) 0xffff)))), 0x0, 0x10)) << 0x0) + ((st64) 0x8000) >> 0x10))) {{}} else {set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, ((ut32) 0x1))}, ((((((st64) ((ut64) ((st64) ((st32) ((st64) ((st32) ((Rss >> 0x0) & 0xffffffff)))))) * extract64(((ut64) ((ut16) ((Rtt >> 0x0) & ((st64) 0xffff)))), 0x0, 0x10)) << 0x0) + ((st64) 0x8000) >> 0x10) < ((st64) 0x0)) ? (-(0x1 << 0x1f)) : (0x1 << 0x1f) - ((st64) 0x1)));
	RzILOpEffect *op_ASSIGN_hybrid_tmp_382 = SETL("h_tmp325", cond_379);

	// seq(HYB(gcc_expr_if ((sextract64(((ut64) ((((st64) ((ut64) ((st6 ...;
	RzILOpEffect *seq_383 = SEQN(2, gcc_expr_380, op_ASSIGN_hybrid_tmp_382);

	// Rdd = ((Rdd & (~(0xffffffff << 0x0))) | ((((sextract64(((ut64) ((((st64) ((ut64) ((st64) ((st32) ((st64) ((st32) ((Rss >> 0x0) & 0xffffffff)))))) * extract64(((ut64) ((ut16) ((Rtt >> 0x0) & ((st64) 0xffff)))), 0x0, 0x10)) << 0x0) + ((st64) 0x8000) >> 0x10)), 0x0, 0x20) == ((((st64) ((ut64) ((st64) ((st32) ((st64) ((st32) ((Rss >> 0x0) & 0xffffffff)))))) * extract64(((ut64) ((ut16) ((Rtt >> 0x0) & ((st64) 0xffff)))), 0x0, 0x10)) << 0x0) + ((st64) 0x8000) >> 0x10)) ? ((((st64) ((ut64) ((st64) ((st32) ((st64) ((st32) ((Rss >> 0x0) & 0xffffffff)))))) * extract64(((ut64) ((ut16) ((Rtt >> 0x0) & ((st64) 0xffff)))), 0x0, 0x10)) << 0x0) + ((st64) 0x8000) >> 0x10) : h_tmp325) & 0xffffffff) << 0x0));
	RzILOpPure *op_LSHIFT_203 = SHIFTL0(SN(64, 0xffffffff), SN(32, 0));
	RzILOpPure *op_NOT_204 = LOGNOT(op_LSHIFT_203);
	RzILOpPure *op_AND_205 = LOGAND(READ_REG(pkt, Rdd_op, true), op_NOT_204);
	RzILOpPure *op_RSHIFT_290 = SHIFTRA(DUP(Rss), SN(32, 0));
	RzILOpPure *op_AND_292 = LOGAND(op_RSHIFT_290, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_303 = SHIFTRA(DUP(Rtt), SN(32, 0));
	RzILOpPure *op_AND_306 = LOGAND(op_RSHIFT_303, CAST(64, MSB(SN(32, 0xffff)), SN(32, 0xffff)));
	RzILOpPure *op_MUL_314 = MUL(CAST(64, IL_FALSE, CAST(64, MSB(CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(op_AND_292), DUP(op_AND_292))), CAST(32, MSB(DUP(op_AND_292)), DUP(op_AND_292)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_292)), DUP(op_AND_292))), CAST(32, MSB(DUP(op_AND_292)), DUP(op_AND_292))))), CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(DUP(op_AND_292)), DUP(op_AND_292))), CAST(32, MSB(DUP(op_AND_292)), DUP(op_AND_292)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_292)), DUP(op_AND_292))), CAST(32, MSB(DUP(op_AND_292)), DUP(op_AND_292)))))), EXTRACT64(CAST(64, IL_FALSE, CAST(16, IL_FALSE, op_AND_306)), SN(32, 0), SN(32, 16)));
	RzILOpPure *op_LSHIFT_317 = SHIFTL0(CAST(64, IL_FALSE, op_MUL_314), SN(32, 0));
	RzILOpPure *op_ADD_320 = ADD(op_LSHIFT_317, CAST(64, MSB(SN(32, 0x8000)), SN(32, 0x8000)));
	RzILOpPure *op_RSHIFT_322 = SHIFTRA(op_ADD_320, SN(32, 16));
	RzILOpPure *cond_384 = ITE(DUP(op_EQ_286), op_RSHIFT_322, VARL("h_tmp325"));
	RzILOpPure *op_AND_386 = LOGAND(cond_384, SN(64, 0xffffffff));
	RzILOpPure *op_LSHIFT_390 = SHIFTL0(op_AND_386, SN(32, 0));
	RzILOpPure *op_OR_391 = LOGOR(op_AND_205, op_LSHIFT_390);
	RzILOpEffect *op_ASSIGN_392 = WRITE_REG(bundle, Rdd_op, op_OR_391);

	// seq(seq(HYB(gcc_expr_if ((sextract64(((ut64) ((((st64) ((ut64) ( ...;
	RzILOpEffect *seq_393 = SEQN(2, seq_383, op_ASSIGN_392);

	RzILOpEffect *instruction_sequence = SEQN(2, seq_197, seq_393);
	return instruction_sequence;
}

// Rdd = vmpyweuh(Rss,Rtt):<<1:rnd:sat
RzILOpEffect *hex_il_op_m2_mmpyul_rs1(HexInsnPktBundle *bundle) {
	const HexInsn *hi = bundle->insn;
	HexPkt *pkt = bundle->pkt;
	// READ
	const HexOp *Rdd_op = ISA2REG(hi, 'd', false);
	const HexOp *Rss_op = ISA2REG(hi, 's', false);
	RzILOpPure *Rss = READ_REG(pkt, Rss_op, false);
	const HexOp *Rtt_op = ISA2REG(hi, 't', false);
	RzILOpPure *Rtt = READ_REG(pkt, Rtt_op, false);

	// set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, ((ut32) 0x1));
	RzILOpEffect *set_usr_field_call_129 = hex_set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, CAST(32, IL_FALSE, SN(32, 1)));

	// HYB(gcc_expr_if ((sextract64(((ut64) ((((st64) ((ut64) ((st64) ((st32) ((st64) ((st32) ((Rss >> 0x20) & 0xffffffff)))))) * extract64(((ut64) ((ut16) ((Rtt >> 0x20) & ((st64) 0xffff)))), 0x0, 0x10)) << 0x1) + ((st64) 0x8000) >> 0x10)), 0x0, 0x20) == ((((st64) ((ut64) ((st64) ((st32) ((st64) ((st32) ((Rss >> 0x20) & 0xffffffff)))))) * extract64(((ut64) ((ut16) ((Rtt >> 0x20) & ((st64) 0xffff)))), 0x0, 0x10)) << 0x1) + ((st64) 0x8000) >> 0x10))) {{}} else {set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, ((ut32) 0x1))}, ((((((st64) ((ut64) ((st64) ((st32) ((st64) ((st32) ((Rss >> 0x20) & 0xffffffff)))))) * extract64(((ut64) ((ut16) ((Rtt >> 0x20) & ((st64) 0xffff)))), 0x0, 0x10)) << 0x1) + ((st64) 0x8000) >> 0x10) < ((st64) 0x0)) ? (-(0x1 << 0x1f)) : (0x1 << 0x1f) - ((st64) 0x1)));
	RzILOpPure *op_RSHIFT_15 = SHIFTRA(Rss, SN(32, 0x20));
	RzILOpPure *op_AND_17 = LOGAND(op_RSHIFT_15, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_29 = SHIFTRA(Rtt, SN(32, 0x20));
	RzILOpPure *op_AND_32 = LOGAND(op_RSHIFT_29, CAST(64, MSB(SN(32, 0xffff)), SN(32, 0xffff)));
	RzILOpPure *op_MUL_40 = MUL(CAST(64, IL_FALSE, CAST(64, MSB(CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(op_AND_17), DUP(op_AND_17))), CAST(32, MSB(DUP(op_AND_17)), DUP(op_AND_17)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_17)), DUP(op_AND_17))), CAST(32, MSB(DUP(op_AND_17)), DUP(op_AND_17))))), CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(DUP(op_AND_17)), DUP(op_AND_17))), CAST(32, MSB(DUP(op_AND_17)), DUP(op_AND_17)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_17)), DUP(op_AND_17))), CAST(32, MSB(DUP(op_AND_17)), DUP(op_AND_17)))))), EXTRACT64(CAST(64, IL_FALSE, CAST(16, IL_FALSE, op_AND_32)), SN(32, 0), SN(32, 16)));
	RzILOpPure *op_LSHIFT_43 = SHIFTL0(CAST(64, IL_FALSE, op_MUL_40), SN(32, 1));
	RzILOpPure *op_ADD_46 = ADD(op_LSHIFT_43, CAST(64, MSB(SN(32, 0x8000)), SN(32, 0x8000)));
	RzILOpPure *op_RSHIFT_48 = SHIFTRA(op_ADD_46, SN(32, 16));
	RzILOpPure *op_RSHIFT_57 = SHIFTRA(DUP(Rss), SN(32, 0x20));
	RzILOpPure *op_AND_59 = LOGAND(op_RSHIFT_57, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_70 = SHIFTRA(DUP(Rtt), SN(32, 0x20));
	RzILOpPure *op_AND_73 = LOGAND(op_RSHIFT_70, CAST(64, MSB(SN(32, 0xffff)), SN(32, 0xffff)));
	RzILOpPure *op_MUL_81 = MUL(CAST(64, IL_FALSE, CAST(64, MSB(CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(op_AND_59), DUP(op_AND_59))), CAST(32, MSB(DUP(op_AND_59)), DUP(op_AND_59)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_59)), DUP(op_AND_59))), CAST(32, MSB(DUP(op_AND_59)), DUP(op_AND_59))))), CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(DUP(op_AND_59)), DUP(op_AND_59))), CAST(32, MSB(DUP(op_AND_59)), DUP(op_AND_59)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_59)), DUP(op_AND_59))), CAST(32, MSB(DUP(op_AND_59)), DUP(op_AND_59)))))), EXTRACT64(CAST(64, IL_FALSE, CAST(16, IL_FALSE, op_AND_73)), SN(32, 0), SN(32, 16)));
	RzILOpPure *op_LSHIFT_84 = SHIFTL0(CAST(64, IL_FALSE, op_MUL_81), SN(32, 1));
	RzILOpPure *op_ADD_87 = ADD(op_LSHIFT_84, CAST(64, MSB(SN(32, 0x8000)), SN(32, 0x8000)));
	RzILOpPure *op_RSHIFT_89 = SHIFTRA(op_ADD_87, SN(32, 16));
	RzILOpPure *op_EQ_90 = EQ(SEXTRACT64(CAST(64, IL_FALSE, op_RSHIFT_48), SN(32, 0), SN(32, 0x20)), op_RSHIFT_89);
	RzILOpPure *op_RSHIFT_133 = SHIFTRA(DUP(Rss), SN(32, 0x20));
	RzILOpPure *op_AND_135 = LOGAND(op_RSHIFT_133, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_146 = SHIFTRA(DUP(Rtt), SN(32, 0x20));
	RzILOpPure *op_AND_149 = LOGAND(op_RSHIFT_146, CAST(64, MSB(SN(32, 0xffff)), SN(32, 0xffff)));
	RzILOpPure *op_MUL_157 = MUL(CAST(64, IL_FALSE, CAST(64, MSB(CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(op_AND_135), DUP(op_AND_135))), CAST(32, MSB(DUP(op_AND_135)), DUP(op_AND_135)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_135)), DUP(op_AND_135))), CAST(32, MSB(DUP(op_AND_135)), DUP(op_AND_135))))), CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(DUP(op_AND_135)), DUP(op_AND_135))), CAST(32, MSB(DUP(op_AND_135)), DUP(op_AND_135)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_135)), DUP(op_AND_135))), CAST(32, MSB(DUP(op_AND_135)), DUP(op_AND_135)))))), EXTRACT64(CAST(64, IL_FALSE, CAST(16, IL_FALSE, op_AND_149)), SN(32, 0), SN(32, 16)));
	RzILOpPure *op_LSHIFT_160 = SHIFTL0(CAST(64, IL_FALSE, op_MUL_157), SN(32, 1));
	RzILOpPure *op_ADD_163 = ADD(op_LSHIFT_160, CAST(64, MSB(SN(32, 0x8000)), SN(32, 0x8000)));
	RzILOpPure *op_RSHIFT_165 = SHIFTRA(op_ADD_163, SN(32, 16));
	RzILOpPure *op_LT_168 = SLT(op_RSHIFT_165, CAST(64, MSB(SN(32, 0)), SN(32, 0)));
	RzILOpPure *op_LSHIFT_173 = SHIFTL0(SN(64, 1), SN(32, 31));
	RzILOpPure *op_NEG_174 = NEG(op_LSHIFT_173);
	RzILOpPure *op_LSHIFT_179 = SHIFTL0(SN(64, 1), SN(32, 31));
	RzILOpPure *op_SUB_182 = SUB(op_LSHIFT_179, CAST(64, MSB(SN(32, 1)), SN(32, 1)));
	RzILOpPure *cond_183 = ITE(op_LT_168, op_NEG_174, op_SUB_182);
	RzILOpEffect *gcc_expr_184 = BRANCH(op_EQ_90, EMPTY(), set_usr_field_call_129);

	// h_tmp326 = HYB(gcc_expr_if ((sextract64(((ut64) ((((st64) ((ut64) ((st64) ((st32) ((st64) ((st32) ((Rss >> 0x20) & 0xffffffff)))))) * extract64(((ut64) ((ut16) ((Rtt >> 0x20) & ((st64) 0xffff)))), 0x0, 0x10)) << 0x1) + ((st64) 0x8000) >> 0x10)), 0x0, 0x20) == ((((st64) ((ut64) ((st64) ((st32) ((st64) ((st32) ((Rss >> 0x20) & 0xffffffff)))))) * extract64(((ut64) ((ut16) ((Rtt >> 0x20) & ((st64) 0xffff)))), 0x0, 0x10)) << 0x1) + ((st64) 0x8000) >> 0x10))) {{}} else {set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, ((ut32) 0x1))}, ((((((st64) ((ut64) ((st64) ((st32) ((st64) ((st32) ((Rss >> 0x20) & 0xffffffff)))))) * extract64(((ut64) ((ut16) ((Rtt >> 0x20) & ((st64) 0xffff)))), 0x0, 0x10)) << 0x1) + ((st64) 0x8000) >> 0x10) < ((st64) 0x0)) ? (-(0x1 << 0x1f)) : (0x1 << 0x1f) - ((st64) 0x1)));
	RzILOpEffect *op_ASSIGN_hybrid_tmp_186 = SETL("h_tmp326", cond_183);

	// seq(HYB(gcc_expr_if ((sextract64(((ut64) ((((st64) ((ut64) ((st6 ...;
	RzILOpEffect *seq_187 = SEQN(2, gcc_expr_184, op_ASSIGN_hybrid_tmp_186);

	// Rdd = ((Rdd & (~(0xffffffff << 0x20))) | ((((sextract64(((ut64) ((((st64) ((ut64) ((st64) ((st32) ((st64) ((st32) ((Rss >> 0x20) & 0xffffffff)))))) * extract64(((ut64) ((ut16) ((Rtt >> 0x20) & ((st64) 0xffff)))), 0x0, 0x10)) << 0x1) + ((st64) 0x8000) >> 0x10)), 0x0, 0x20) == ((((st64) ((ut64) ((st64) ((st32) ((st64) ((st32) ((Rss >> 0x20) & 0xffffffff)))))) * extract64(((ut64) ((ut16) ((Rtt >> 0x20) & ((st64) 0xffff)))), 0x0, 0x10)) << 0x1) + ((st64) 0x8000) >> 0x10)) ? ((((st64) ((ut64) ((st64) ((st32) ((st64) ((st32) ((Rss >> 0x20) & 0xffffffff)))))) * extract64(((ut64) ((ut16) ((Rtt >> 0x20) & ((st64) 0xffff)))), 0x0, 0x10)) << 0x1) + ((st64) 0x8000) >> 0x10) : h_tmp326) & 0xffffffff) << 0x20));
	RzILOpPure *op_LSHIFT_5 = SHIFTL0(SN(64, 0xffffffff), SN(32, 0x20));
	RzILOpPure *op_NOT_6 = LOGNOT(op_LSHIFT_5);
	RzILOpPure *op_AND_7 = LOGAND(READ_REG(pkt, Rdd_op, true), op_NOT_6);
	RzILOpPure *op_RSHIFT_94 = SHIFTRA(DUP(Rss), SN(32, 0x20));
	RzILOpPure *op_AND_96 = LOGAND(op_RSHIFT_94, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_107 = SHIFTRA(DUP(Rtt), SN(32, 0x20));
	RzILOpPure *op_AND_110 = LOGAND(op_RSHIFT_107, CAST(64, MSB(SN(32, 0xffff)), SN(32, 0xffff)));
	RzILOpPure *op_MUL_118 = MUL(CAST(64, IL_FALSE, CAST(64, MSB(CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(op_AND_96), DUP(op_AND_96))), CAST(32, MSB(DUP(op_AND_96)), DUP(op_AND_96)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_96)), DUP(op_AND_96))), CAST(32, MSB(DUP(op_AND_96)), DUP(op_AND_96))))), CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(DUP(op_AND_96)), DUP(op_AND_96))), CAST(32, MSB(DUP(op_AND_96)), DUP(op_AND_96)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_96)), DUP(op_AND_96))), CAST(32, MSB(DUP(op_AND_96)), DUP(op_AND_96)))))), EXTRACT64(CAST(64, IL_FALSE, CAST(16, IL_FALSE, op_AND_110)), SN(32, 0), SN(32, 16)));
	RzILOpPure *op_LSHIFT_121 = SHIFTL0(CAST(64, IL_FALSE, op_MUL_118), SN(32, 1));
	RzILOpPure *op_ADD_124 = ADD(op_LSHIFT_121, CAST(64, MSB(SN(32, 0x8000)), SN(32, 0x8000)));
	RzILOpPure *op_RSHIFT_126 = SHIFTRA(op_ADD_124, SN(32, 16));
	RzILOpPure *cond_188 = ITE(DUP(op_EQ_90), op_RSHIFT_126, VARL("h_tmp326"));
	RzILOpPure *op_AND_190 = LOGAND(cond_188, SN(64, 0xffffffff));
	RzILOpPure *op_LSHIFT_194 = SHIFTL0(op_AND_190, SN(32, 0x20));
	RzILOpPure *op_OR_195 = LOGOR(op_AND_7, op_LSHIFT_194);
	RzILOpEffect *op_ASSIGN_196 = WRITE_REG(bundle, Rdd_op, op_OR_195);

	// seq(seq(HYB(gcc_expr_if ((sextract64(((ut64) ((((st64) ((ut64) ( ...;
	RzILOpEffect *seq_197 = SEQN(2, seq_187, op_ASSIGN_196);

	// set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, ((ut32) 0x1));
	RzILOpEffect *set_usr_field_call_325 = hex_set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, CAST(32, IL_FALSE, SN(32, 1)));

	// HYB(gcc_expr_if ((sextract64(((ut64) ((((st64) ((ut64) ((st64) ((st32) ((st64) ((st32) ((Rss >> 0x0) & 0xffffffff)))))) * extract64(((ut64) ((ut16) ((Rtt >> 0x0) & ((st64) 0xffff)))), 0x0, 0x10)) << 0x1) + ((st64) 0x8000) >> 0x10)), 0x0, 0x20) == ((((st64) ((ut64) ((st64) ((st32) ((st64) ((st32) ((Rss >> 0x0) & 0xffffffff)))))) * extract64(((ut64) ((ut16) ((Rtt >> 0x0) & ((st64) 0xffff)))), 0x0, 0x10)) << 0x1) + ((st64) 0x8000) >> 0x10))) {{}} else {set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, ((ut32) 0x1))}, ((((((st64) ((ut64) ((st64) ((st32) ((st64) ((st32) ((Rss >> 0x0) & 0xffffffff)))))) * extract64(((ut64) ((ut16) ((Rtt >> 0x0) & ((st64) 0xffff)))), 0x0, 0x10)) << 0x1) + ((st64) 0x8000) >> 0x10) < ((st64) 0x0)) ? (-(0x1 << 0x1f)) : (0x1 << 0x1f) - ((st64) 0x1)));
	RzILOpPure *op_RSHIFT_212 = SHIFTRA(DUP(Rss), SN(32, 0));
	RzILOpPure *op_AND_214 = LOGAND(op_RSHIFT_212, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_225 = SHIFTRA(DUP(Rtt), SN(32, 0));
	RzILOpPure *op_AND_228 = LOGAND(op_RSHIFT_225, CAST(64, MSB(SN(32, 0xffff)), SN(32, 0xffff)));
	RzILOpPure *op_MUL_236 = MUL(CAST(64, IL_FALSE, CAST(64, MSB(CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(op_AND_214), DUP(op_AND_214))), CAST(32, MSB(DUP(op_AND_214)), DUP(op_AND_214)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_214)), DUP(op_AND_214))), CAST(32, MSB(DUP(op_AND_214)), DUP(op_AND_214))))), CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(DUP(op_AND_214)), DUP(op_AND_214))), CAST(32, MSB(DUP(op_AND_214)), DUP(op_AND_214)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_214)), DUP(op_AND_214))), CAST(32, MSB(DUP(op_AND_214)), DUP(op_AND_214)))))), EXTRACT64(CAST(64, IL_FALSE, CAST(16, IL_FALSE, op_AND_228)), SN(32, 0), SN(32, 16)));
	RzILOpPure *op_LSHIFT_239 = SHIFTL0(CAST(64, IL_FALSE, op_MUL_236), SN(32, 1));
	RzILOpPure *op_ADD_242 = ADD(op_LSHIFT_239, CAST(64, MSB(SN(32, 0x8000)), SN(32, 0x8000)));
	RzILOpPure *op_RSHIFT_244 = SHIFTRA(op_ADD_242, SN(32, 16));
	RzILOpPure *op_RSHIFT_253 = SHIFTRA(DUP(Rss), SN(32, 0));
	RzILOpPure *op_AND_255 = LOGAND(op_RSHIFT_253, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_266 = SHIFTRA(DUP(Rtt), SN(32, 0));
	RzILOpPure *op_AND_269 = LOGAND(op_RSHIFT_266, CAST(64, MSB(SN(32, 0xffff)), SN(32, 0xffff)));
	RzILOpPure *op_MUL_277 = MUL(CAST(64, IL_FALSE, CAST(64, MSB(CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(op_AND_255), DUP(op_AND_255))), CAST(32, MSB(DUP(op_AND_255)), DUP(op_AND_255)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_255)), DUP(op_AND_255))), CAST(32, MSB(DUP(op_AND_255)), DUP(op_AND_255))))), CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(DUP(op_AND_255)), DUP(op_AND_255))), CAST(32, MSB(DUP(op_AND_255)), DUP(op_AND_255)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_255)), DUP(op_AND_255))), CAST(32, MSB(DUP(op_AND_255)), DUP(op_AND_255)))))), EXTRACT64(CAST(64, IL_FALSE, CAST(16, IL_FALSE, op_AND_269)), SN(32, 0), SN(32, 16)));
	RzILOpPure *op_LSHIFT_280 = SHIFTL0(CAST(64, IL_FALSE, op_MUL_277), SN(32, 1));
	RzILOpPure *op_ADD_283 = ADD(op_LSHIFT_280, CAST(64, MSB(SN(32, 0x8000)), SN(32, 0x8000)));
	RzILOpPure *op_RSHIFT_285 = SHIFTRA(op_ADD_283, SN(32, 16));
	RzILOpPure *op_EQ_286 = EQ(SEXTRACT64(CAST(64, IL_FALSE, op_RSHIFT_244), SN(32, 0), SN(32, 0x20)), op_RSHIFT_285);
	RzILOpPure *op_RSHIFT_329 = SHIFTRA(DUP(Rss), SN(32, 0));
	RzILOpPure *op_AND_331 = LOGAND(op_RSHIFT_329, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_342 = SHIFTRA(DUP(Rtt), SN(32, 0));
	RzILOpPure *op_AND_345 = LOGAND(op_RSHIFT_342, CAST(64, MSB(SN(32, 0xffff)), SN(32, 0xffff)));
	RzILOpPure *op_MUL_353 = MUL(CAST(64, IL_FALSE, CAST(64, MSB(CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(op_AND_331), DUP(op_AND_331))), CAST(32, MSB(DUP(op_AND_331)), DUP(op_AND_331)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_331)), DUP(op_AND_331))), CAST(32, MSB(DUP(op_AND_331)), DUP(op_AND_331))))), CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(DUP(op_AND_331)), DUP(op_AND_331))), CAST(32, MSB(DUP(op_AND_331)), DUP(op_AND_331)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_331)), DUP(op_AND_331))), CAST(32, MSB(DUP(op_AND_331)), DUP(op_AND_331)))))), EXTRACT64(CAST(64, IL_FALSE, CAST(16, IL_FALSE, op_AND_345)), SN(32, 0), SN(32, 16)));
	RzILOpPure *op_LSHIFT_356 = SHIFTL0(CAST(64, IL_FALSE, op_MUL_353), SN(32, 1));
	RzILOpPure *op_ADD_359 = ADD(op_LSHIFT_356, CAST(64, MSB(SN(32, 0x8000)), SN(32, 0x8000)));
	RzILOpPure *op_RSHIFT_361 = SHIFTRA(op_ADD_359, SN(32, 16));
	RzILOpPure *op_LT_364 = SLT(op_RSHIFT_361, CAST(64, MSB(SN(32, 0)), SN(32, 0)));
	RzILOpPure *op_LSHIFT_369 = SHIFTL0(SN(64, 1), SN(32, 31));
	RzILOpPure *op_NEG_370 = NEG(op_LSHIFT_369);
	RzILOpPure *op_LSHIFT_375 = SHIFTL0(SN(64, 1), SN(32, 31));
	RzILOpPure *op_SUB_378 = SUB(op_LSHIFT_375, CAST(64, MSB(SN(32, 1)), SN(32, 1)));
	RzILOpPure *cond_379 = ITE(op_LT_364, op_NEG_370, op_SUB_378);
	RzILOpEffect *gcc_expr_380 = BRANCH(op_EQ_286, EMPTY(), set_usr_field_call_325);

	// h_tmp327 = HYB(gcc_expr_if ((sextract64(((ut64) ((((st64) ((ut64) ((st64) ((st32) ((st64) ((st32) ((Rss >> 0x0) & 0xffffffff)))))) * extract64(((ut64) ((ut16) ((Rtt >> 0x0) & ((st64) 0xffff)))), 0x0, 0x10)) << 0x1) + ((st64) 0x8000) >> 0x10)), 0x0, 0x20) == ((((st64) ((ut64) ((st64) ((st32) ((st64) ((st32) ((Rss >> 0x0) & 0xffffffff)))))) * extract64(((ut64) ((ut16) ((Rtt >> 0x0) & ((st64) 0xffff)))), 0x0, 0x10)) << 0x1) + ((st64) 0x8000) >> 0x10))) {{}} else {set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, ((ut32) 0x1))}, ((((((st64) ((ut64) ((st64) ((st32) ((st64) ((st32) ((Rss >> 0x0) & 0xffffffff)))))) * extract64(((ut64) ((ut16) ((Rtt >> 0x0) & ((st64) 0xffff)))), 0x0, 0x10)) << 0x1) + ((st64) 0x8000) >> 0x10) < ((st64) 0x0)) ? (-(0x1 << 0x1f)) : (0x1 << 0x1f) - ((st64) 0x1)));
	RzILOpEffect *op_ASSIGN_hybrid_tmp_382 = SETL("h_tmp327", cond_379);

	// seq(HYB(gcc_expr_if ((sextract64(((ut64) ((((st64) ((ut64) ((st6 ...;
	RzILOpEffect *seq_383 = SEQN(2, gcc_expr_380, op_ASSIGN_hybrid_tmp_382);

	// Rdd = ((Rdd & (~(0xffffffff << 0x0))) | ((((sextract64(((ut64) ((((st64) ((ut64) ((st64) ((st32) ((st64) ((st32) ((Rss >> 0x0) & 0xffffffff)))))) * extract64(((ut64) ((ut16) ((Rtt >> 0x0) & ((st64) 0xffff)))), 0x0, 0x10)) << 0x1) + ((st64) 0x8000) >> 0x10)), 0x0, 0x20) == ((((st64) ((ut64) ((st64) ((st32) ((st64) ((st32) ((Rss >> 0x0) & 0xffffffff)))))) * extract64(((ut64) ((ut16) ((Rtt >> 0x0) & ((st64) 0xffff)))), 0x0, 0x10)) << 0x1) + ((st64) 0x8000) >> 0x10)) ? ((((st64) ((ut64) ((st64) ((st32) ((st64) ((st32) ((Rss >> 0x0) & 0xffffffff)))))) * extract64(((ut64) ((ut16) ((Rtt >> 0x0) & ((st64) 0xffff)))), 0x0, 0x10)) << 0x1) + ((st64) 0x8000) >> 0x10) : h_tmp327) & 0xffffffff) << 0x0));
	RzILOpPure *op_LSHIFT_203 = SHIFTL0(SN(64, 0xffffffff), SN(32, 0));
	RzILOpPure *op_NOT_204 = LOGNOT(op_LSHIFT_203);
	RzILOpPure *op_AND_205 = LOGAND(READ_REG(pkt, Rdd_op, true), op_NOT_204);
	RzILOpPure *op_RSHIFT_290 = SHIFTRA(DUP(Rss), SN(32, 0));
	RzILOpPure *op_AND_292 = LOGAND(op_RSHIFT_290, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_303 = SHIFTRA(DUP(Rtt), SN(32, 0));
	RzILOpPure *op_AND_306 = LOGAND(op_RSHIFT_303, CAST(64, MSB(SN(32, 0xffff)), SN(32, 0xffff)));
	RzILOpPure *op_MUL_314 = MUL(CAST(64, IL_FALSE, CAST(64, MSB(CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(op_AND_292), DUP(op_AND_292))), CAST(32, MSB(DUP(op_AND_292)), DUP(op_AND_292)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_292)), DUP(op_AND_292))), CAST(32, MSB(DUP(op_AND_292)), DUP(op_AND_292))))), CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(DUP(op_AND_292)), DUP(op_AND_292))), CAST(32, MSB(DUP(op_AND_292)), DUP(op_AND_292)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_292)), DUP(op_AND_292))), CAST(32, MSB(DUP(op_AND_292)), DUP(op_AND_292)))))), EXTRACT64(CAST(64, IL_FALSE, CAST(16, IL_FALSE, op_AND_306)), SN(32, 0), SN(32, 16)));
	RzILOpPure *op_LSHIFT_317 = SHIFTL0(CAST(64, IL_FALSE, op_MUL_314), SN(32, 1));
	RzILOpPure *op_ADD_320 = ADD(op_LSHIFT_317, CAST(64, MSB(SN(32, 0x8000)), SN(32, 0x8000)));
	RzILOpPure *op_RSHIFT_322 = SHIFTRA(op_ADD_320, SN(32, 16));
	RzILOpPure *cond_384 = ITE(DUP(op_EQ_286), op_RSHIFT_322, VARL("h_tmp327"));
	RzILOpPure *op_AND_386 = LOGAND(cond_384, SN(64, 0xffffffff));
	RzILOpPure *op_LSHIFT_390 = SHIFTL0(op_AND_386, SN(32, 0));
	RzILOpPure *op_OR_391 = LOGOR(op_AND_205, op_LSHIFT_390);
	RzILOpEffect *op_ASSIGN_392 = WRITE_REG(bundle, Rdd_op, op_OR_391);

	// seq(seq(HYB(gcc_expr_if ((sextract64(((ut64) ((((st64) ((ut64) ( ...;
	RzILOpEffect *seq_393 = SEQN(2, seq_383, op_ASSIGN_392);

	RzILOpEffect *instruction_sequence = SEQN(2, seq_197, seq_393);
	return instruction_sequence;
}

// Rdd = vmpyweuh(Rss,Rtt):sat
RzILOpEffect *hex_il_op_m2_mmpyul_s0(HexInsnPktBundle *bundle) {
	const HexInsn *hi = bundle->insn;
	HexPkt *pkt = bundle->pkt;
	// READ
	const HexOp *Rdd_op = ISA2REG(hi, 'd', false);
	const HexOp *Rss_op = ISA2REG(hi, 's', false);
	RzILOpPure *Rss = READ_REG(pkt, Rss_op, false);
	const HexOp *Rtt_op = ISA2REG(hi, 't', false);
	RzILOpPure *Rtt = READ_REG(pkt, Rtt_op, false);

	// set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, ((ut32) 0x1));
	RzILOpEffect *set_usr_field_call_120 = hex_set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, CAST(32, IL_FALSE, SN(32, 1)));

	// HYB(gcc_expr_if ((sextract64(((ut64) ((((st64) ((ut64) ((st64) ((st32) ((st64) ((st32) ((Rss >> 0x20) & 0xffffffff)))))) * extract64(((ut64) ((ut16) ((Rtt >> 0x20) & ((st64) 0xffff)))), 0x0, 0x10)) << 0x0) >> 0x10)), 0x0, 0x20) == ((((st64) ((ut64) ((st64) ((st32) ((st64) ((st32) ((Rss >> 0x20) & 0xffffffff)))))) * extract64(((ut64) ((ut16) ((Rtt >> 0x20) & ((st64) 0xffff)))), 0x0, 0x10)) << 0x0) >> 0x10))) {{}} else {set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, ((ut32) 0x1))}, ((((((st64) ((ut64) ((st64) ((st32) ((st64) ((st32) ((Rss >> 0x20) & 0xffffffff)))))) * extract64(((ut64) ((ut16) ((Rtt >> 0x20) & ((st64) 0xffff)))), 0x0, 0x10)) << 0x0) >> 0x10) < ((st64) 0x0)) ? (-(0x1 << 0x1f)) : (0x1 << 0x1f) - ((st64) 0x1)));
	RzILOpPure *op_RSHIFT_15 = SHIFTRA(Rss, SN(32, 0x20));
	RzILOpPure *op_AND_17 = LOGAND(op_RSHIFT_15, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_29 = SHIFTRA(Rtt, SN(32, 0x20));
	RzILOpPure *op_AND_32 = LOGAND(op_RSHIFT_29, CAST(64, MSB(SN(32, 0xffff)), SN(32, 0xffff)));
	RzILOpPure *op_MUL_40 = MUL(CAST(64, IL_FALSE, CAST(64, MSB(CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(op_AND_17), DUP(op_AND_17))), CAST(32, MSB(DUP(op_AND_17)), DUP(op_AND_17)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_17)), DUP(op_AND_17))), CAST(32, MSB(DUP(op_AND_17)), DUP(op_AND_17))))), CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(DUP(op_AND_17)), DUP(op_AND_17))), CAST(32, MSB(DUP(op_AND_17)), DUP(op_AND_17)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_17)), DUP(op_AND_17))), CAST(32, MSB(DUP(op_AND_17)), DUP(op_AND_17)))))), EXTRACT64(CAST(64, IL_FALSE, CAST(16, IL_FALSE, op_AND_32)), SN(32, 0), SN(32, 16)));
	RzILOpPure *op_LSHIFT_43 = SHIFTL0(CAST(64, IL_FALSE, op_MUL_40), SN(32, 0));
	RzILOpPure *op_RSHIFT_45 = SHIFTRA(op_LSHIFT_43, SN(32, 16));
	RzILOpPure *op_RSHIFT_54 = SHIFTRA(DUP(Rss), SN(32, 0x20));
	RzILOpPure *op_AND_56 = LOGAND(op_RSHIFT_54, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_67 = SHIFTRA(DUP(Rtt), SN(32, 0x20));
	RzILOpPure *op_AND_70 = LOGAND(op_RSHIFT_67, CAST(64, MSB(SN(32, 0xffff)), SN(32, 0xffff)));
	RzILOpPure *op_MUL_78 = MUL(CAST(64, IL_FALSE, CAST(64, MSB(CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(op_AND_56), DUP(op_AND_56))), CAST(32, MSB(DUP(op_AND_56)), DUP(op_AND_56)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_56)), DUP(op_AND_56))), CAST(32, MSB(DUP(op_AND_56)), DUP(op_AND_56))))), CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(DUP(op_AND_56)), DUP(op_AND_56))), CAST(32, MSB(DUP(op_AND_56)), DUP(op_AND_56)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_56)), DUP(op_AND_56))), CAST(32, MSB(DUP(op_AND_56)), DUP(op_AND_56)))))), EXTRACT64(CAST(64, IL_FALSE, CAST(16, IL_FALSE, op_AND_70)), SN(32, 0), SN(32, 16)));
	RzILOpPure *op_LSHIFT_81 = SHIFTL0(CAST(64, IL_FALSE, op_MUL_78), SN(32, 0));
	RzILOpPure *op_RSHIFT_83 = SHIFTRA(op_LSHIFT_81, SN(32, 16));
	RzILOpPure *op_EQ_84 = EQ(SEXTRACT64(CAST(64, IL_FALSE, op_RSHIFT_45), SN(32, 0), SN(32, 0x20)), op_RSHIFT_83);
	RzILOpPure *op_RSHIFT_124 = SHIFTRA(DUP(Rss), SN(32, 0x20));
	RzILOpPure *op_AND_126 = LOGAND(op_RSHIFT_124, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_137 = SHIFTRA(DUP(Rtt), SN(32, 0x20));
	RzILOpPure *op_AND_140 = LOGAND(op_RSHIFT_137, CAST(64, MSB(SN(32, 0xffff)), SN(32, 0xffff)));
	RzILOpPure *op_MUL_148 = MUL(CAST(64, IL_FALSE, CAST(64, MSB(CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(op_AND_126), DUP(op_AND_126))), CAST(32, MSB(DUP(op_AND_126)), DUP(op_AND_126)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_126)), DUP(op_AND_126))), CAST(32, MSB(DUP(op_AND_126)), DUP(op_AND_126))))), CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(DUP(op_AND_126)), DUP(op_AND_126))), CAST(32, MSB(DUP(op_AND_126)), DUP(op_AND_126)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_126)), DUP(op_AND_126))), CAST(32, MSB(DUP(op_AND_126)), DUP(op_AND_126)))))), EXTRACT64(CAST(64, IL_FALSE, CAST(16, IL_FALSE, op_AND_140)), SN(32, 0), SN(32, 16)));
	RzILOpPure *op_LSHIFT_151 = SHIFTL0(CAST(64, IL_FALSE, op_MUL_148), SN(32, 0));
	RzILOpPure *op_RSHIFT_153 = SHIFTRA(op_LSHIFT_151, SN(32, 16));
	RzILOpPure *op_LT_156 = SLT(op_RSHIFT_153, CAST(64, MSB(SN(32, 0)), SN(32, 0)));
	RzILOpPure *op_LSHIFT_161 = SHIFTL0(SN(64, 1), SN(32, 31));
	RzILOpPure *op_NEG_162 = NEG(op_LSHIFT_161);
	RzILOpPure *op_LSHIFT_167 = SHIFTL0(SN(64, 1), SN(32, 31));
	RzILOpPure *op_SUB_170 = SUB(op_LSHIFT_167, CAST(64, MSB(SN(32, 1)), SN(32, 1)));
	RzILOpPure *cond_171 = ITE(op_LT_156, op_NEG_162, op_SUB_170);
	RzILOpEffect *gcc_expr_172 = BRANCH(op_EQ_84, EMPTY(), set_usr_field_call_120);

	// h_tmp328 = HYB(gcc_expr_if ((sextract64(((ut64) ((((st64) ((ut64) ((st64) ((st32) ((st64) ((st32) ((Rss >> 0x20) & 0xffffffff)))))) * extract64(((ut64) ((ut16) ((Rtt >> 0x20) & ((st64) 0xffff)))), 0x0, 0x10)) << 0x0) >> 0x10)), 0x0, 0x20) == ((((st64) ((ut64) ((st64) ((st32) ((st64) ((st32) ((Rss >> 0x20) & 0xffffffff)))))) * extract64(((ut64) ((ut16) ((Rtt >> 0x20) & ((st64) 0xffff)))), 0x0, 0x10)) << 0x0) >> 0x10))) {{}} else {set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, ((ut32) 0x1))}, ((((((st64) ((ut64) ((st64) ((st32) ((st64) ((st32) ((Rss >> 0x20) & 0xffffffff)))))) * extract64(((ut64) ((ut16) ((Rtt >> 0x20) & ((st64) 0xffff)))), 0x0, 0x10)) << 0x0) >> 0x10) < ((st64) 0x0)) ? (-(0x1 << 0x1f)) : (0x1 << 0x1f) - ((st64) 0x1)));
	RzILOpEffect *op_ASSIGN_hybrid_tmp_174 = SETL("h_tmp328", cond_171);

	// seq(HYB(gcc_expr_if ((sextract64(((ut64) ((((st64) ((ut64) ((st6 ...;
	RzILOpEffect *seq_175 = SEQN(2, gcc_expr_172, op_ASSIGN_hybrid_tmp_174);

	// Rdd = ((Rdd & (~(0xffffffff << 0x20))) | ((((sextract64(((ut64) ((((st64) ((ut64) ((st64) ((st32) ((st64) ((st32) ((Rss >> 0x20) & 0xffffffff)))))) * extract64(((ut64) ((ut16) ((Rtt >> 0x20) & ((st64) 0xffff)))), 0x0, 0x10)) << 0x0) >> 0x10)), 0x0, 0x20) == ((((st64) ((ut64) ((st64) ((st32) ((st64) ((st32) ((Rss >> 0x20) & 0xffffffff)))))) * extract64(((ut64) ((ut16) ((Rtt >> 0x20) & ((st64) 0xffff)))), 0x0, 0x10)) << 0x0) >> 0x10)) ? ((((st64) ((ut64) ((st64) ((st32) ((st64) ((st32) ((Rss >> 0x20) & 0xffffffff)))))) * extract64(((ut64) ((ut16) ((Rtt >> 0x20) & ((st64) 0xffff)))), 0x0, 0x10)) << 0x0) >> 0x10) : h_tmp328) & 0xffffffff) << 0x20));
	RzILOpPure *op_LSHIFT_5 = SHIFTL0(SN(64, 0xffffffff), SN(32, 0x20));
	RzILOpPure *op_NOT_6 = LOGNOT(op_LSHIFT_5);
	RzILOpPure *op_AND_7 = LOGAND(READ_REG(pkt, Rdd_op, true), op_NOT_6);
	RzILOpPure *op_RSHIFT_88 = SHIFTRA(DUP(Rss), SN(32, 0x20));
	RzILOpPure *op_AND_90 = LOGAND(op_RSHIFT_88, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_101 = SHIFTRA(DUP(Rtt), SN(32, 0x20));
	RzILOpPure *op_AND_104 = LOGAND(op_RSHIFT_101, CAST(64, MSB(SN(32, 0xffff)), SN(32, 0xffff)));
	RzILOpPure *op_MUL_112 = MUL(CAST(64, IL_FALSE, CAST(64, MSB(CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(op_AND_90), DUP(op_AND_90))), CAST(32, MSB(DUP(op_AND_90)), DUP(op_AND_90)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_90)), DUP(op_AND_90))), CAST(32, MSB(DUP(op_AND_90)), DUP(op_AND_90))))), CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(DUP(op_AND_90)), DUP(op_AND_90))), CAST(32, MSB(DUP(op_AND_90)), DUP(op_AND_90)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_90)), DUP(op_AND_90))), CAST(32, MSB(DUP(op_AND_90)), DUP(op_AND_90)))))), EXTRACT64(CAST(64, IL_FALSE, CAST(16, IL_FALSE, op_AND_104)), SN(32, 0), SN(32, 16)));
	RzILOpPure *op_LSHIFT_115 = SHIFTL0(CAST(64, IL_FALSE, op_MUL_112), SN(32, 0));
	RzILOpPure *op_RSHIFT_117 = SHIFTRA(op_LSHIFT_115, SN(32, 16));
	RzILOpPure *cond_176 = ITE(DUP(op_EQ_84), op_RSHIFT_117, VARL("h_tmp328"));
	RzILOpPure *op_AND_178 = LOGAND(cond_176, SN(64, 0xffffffff));
	RzILOpPure *op_LSHIFT_182 = SHIFTL0(op_AND_178, SN(32, 0x20));
	RzILOpPure *op_OR_183 = LOGOR(op_AND_7, op_LSHIFT_182);
	RzILOpEffect *op_ASSIGN_184 = WRITE_REG(bundle, Rdd_op, op_OR_183);

	// seq(seq(HYB(gcc_expr_if ((sextract64(((ut64) ((((st64) ((ut64) ( ...;
	RzILOpEffect *seq_185 = SEQN(2, seq_175, op_ASSIGN_184);

	// set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, ((ut32) 0x1));
	RzILOpEffect *set_usr_field_call_304 = hex_set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, CAST(32, IL_FALSE, SN(32, 1)));

	// HYB(gcc_expr_if ((sextract64(((ut64) ((((st64) ((ut64) ((st64) ((st32) ((st64) ((st32) ((Rss >> 0x0) & 0xffffffff)))))) * extract64(((ut64) ((ut16) ((Rtt >> 0x0) & ((st64) 0xffff)))), 0x0, 0x10)) << 0x0) >> 0x10)), 0x0, 0x20) == ((((st64) ((ut64) ((st64) ((st32) ((st64) ((st32) ((Rss >> 0x0) & 0xffffffff)))))) * extract64(((ut64) ((ut16) ((Rtt >> 0x0) & ((st64) 0xffff)))), 0x0, 0x10)) << 0x0) >> 0x10))) {{}} else {set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, ((ut32) 0x1))}, ((((((st64) ((ut64) ((st64) ((st32) ((st64) ((st32) ((Rss >> 0x0) & 0xffffffff)))))) * extract64(((ut64) ((ut16) ((Rtt >> 0x0) & ((st64) 0xffff)))), 0x0, 0x10)) << 0x0) >> 0x10) < ((st64) 0x0)) ? (-(0x1 << 0x1f)) : (0x1 << 0x1f) - ((st64) 0x1)));
	RzILOpPure *op_RSHIFT_200 = SHIFTRA(DUP(Rss), SN(32, 0));
	RzILOpPure *op_AND_202 = LOGAND(op_RSHIFT_200, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_213 = SHIFTRA(DUP(Rtt), SN(32, 0));
	RzILOpPure *op_AND_216 = LOGAND(op_RSHIFT_213, CAST(64, MSB(SN(32, 0xffff)), SN(32, 0xffff)));
	RzILOpPure *op_MUL_224 = MUL(CAST(64, IL_FALSE, CAST(64, MSB(CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(op_AND_202), DUP(op_AND_202))), CAST(32, MSB(DUP(op_AND_202)), DUP(op_AND_202)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_202)), DUP(op_AND_202))), CAST(32, MSB(DUP(op_AND_202)), DUP(op_AND_202))))), CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(DUP(op_AND_202)), DUP(op_AND_202))), CAST(32, MSB(DUP(op_AND_202)), DUP(op_AND_202)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_202)), DUP(op_AND_202))), CAST(32, MSB(DUP(op_AND_202)), DUP(op_AND_202)))))), EXTRACT64(CAST(64, IL_FALSE, CAST(16, IL_FALSE, op_AND_216)), SN(32, 0), SN(32, 16)));
	RzILOpPure *op_LSHIFT_227 = SHIFTL0(CAST(64, IL_FALSE, op_MUL_224), SN(32, 0));
	RzILOpPure *op_RSHIFT_229 = SHIFTRA(op_LSHIFT_227, SN(32, 16));
	RzILOpPure *op_RSHIFT_238 = SHIFTRA(DUP(Rss), SN(32, 0));
	RzILOpPure *op_AND_240 = LOGAND(op_RSHIFT_238, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_251 = SHIFTRA(DUP(Rtt), SN(32, 0));
	RzILOpPure *op_AND_254 = LOGAND(op_RSHIFT_251, CAST(64, MSB(SN(32, 0xffff)), SN(32, 0xffff)));
	RzILOpPure *op_MUL_262 = MUL(CAST(64, IL_FALSE, CAST(64, MSB(CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(op_AND_240), DUP(op_AND_240))), CAST(32, MSB(DUP(op_AND_240)), DUP(op_AND_240)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_240)), DUP(op_AND_240))), CAST(32, MSB(DUP(op_AND_240)), DUP(op_AND_240))))), CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(DUP(op_AND_240)), DUP(op_AND_240))), CAST(32, MSB(DUP(op_AND_240)), DUP(op_AND_240)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_240)), DUP(op_AND_240))), CAST(32, MSB(DUP(op_AND_240)), DUP(op_AND_240)))))), EXTRACT64(CAST(64, IL_FALSE, CAST(16, IL_FALSE, op_AND_254)), SN(32, 0), SN(32, 16)));
	RzILOpPure *op_LSHIFT_265 = SHIFTL0(CAST(64, IL_FALSE, op_MUL_262), SN(32, 0));
	RzILOpPure *op_RSHIFT_267 = SHIFTRA(op_LSHIFT_265, SN(32, 16));
	RzILOpPure *op_EQ_268 = EQ(SEXTRACT64(CAST(64, IL_FALSE, op_RSHIFT_229), SN(32, 0), SN(32, 0x20)), op_RSHIFT_267);
	RzILOpPure *op_RSHIFT_308 = SHIFTRA(DUP(Rss), SN(32, 0));
	RzILOpPure *op_AND_310 = LOGAND(op_RSHIFT_308, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_321 = SHIFTRA(DUP(Rtt), SN(32, 0));
	RzILOpPure *op_AND_324 = LOGAND(op_RSHIFT_321, CAST(64, MSB(SN(32, 0xffff)), SN(32, 0xffff)));
	RzILOpPure *op_MUL_332 = MUL(CAST(64, IL_FALSE, CAST(64, MSB(CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(op_AND_310), DUP(op_AND_310))), CAST(32, MSB(DUP(op_AND_310)), DUP(op_AND_310)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_310)), DUP(op_AND_310))), CAST(32, MSB(DUP(op_AND_310)), DUP(op_AND_310))))), CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(DUP(op_AND_310)), DUP(op_AND_310))), CAST(32, MSB(DUP(op_AND_310)), DUP(op_AND_310)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_310)), DUP(op_AND_310))), CAST(32, MSB(DUP(op_AND_310)), DUP(op_AND_310)))))), EXTRACT64(CAST(64, IL_FALSE, CAST(16, IL_FALSE, op_AND_324)), SN(32, 0), SN(32, 16)));
	RzILOpPure *op_LSHIFT_335 = SHIFTL0(CAST(64, IL_FALSE, op_MUL_332), SN(32, 0));
	RzILOpPure *op_RSHIFT_337 = SHIFTRA(op_LSHIFT_335, SN(32, 16));
	RzILOpPure *op_LT_340 = SLT(op_RSHIFT_337, CAST(64, MSB(SN(32, 0)), SN(32, 0)));
	RzILOpPure *op_LSHIFT_345 = SHIFTL0(SN(64, 1), SN(32, 31));
	RzILOpPure *op_NEG_346 = NEG(op_LSHIFT_345);
	RzILOpPure *op_LSHIFT_351 = SHIFTL0(SN(64, 1), SN(32, 31));
	RzILOpPure *op_SUB_354 = SUB(op_LSHIFT_351, CAST(64, MSB(SN(32, 1)), SN(32, 1)));
	RzILOpPure *cond_355 = ITE(op_LT_340, op_NEG_346, op_SUB_354);
	RzILOpEffect *gcc_expr_356 = BRANCH(op_EQ_268, EMPTY(), set_usr_field_call_304);

	// h_tmp329 = HYB(gcc_expr_if ((sextract64(((ut64) ((((st64) ((ut64) ((st64) ((st32) ((st64) ((st32) ((Rss >> 0x0) & 0xffffffff)))))) * extract64(((ut64) ((ut16) ((Rtt >> 0x0) & ((st64) 0xffff)))), 0x0, 0x10)) << 0x0) >> 0x10)), 0x0, 0x20) == ((((st64) ((ut64) ((st64) ((st32) ((st64) ((st32) ((Rss >> 0x0) & 0xffffffff)))))) * extract64(((ut64) ((ut16) ((Rtt >> 0x0) & ((st64) 0xffff)))), 0x0, 0x10)) << 0x0) >> 0x10))) {{}} else {set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, ((ut32) 0x1))}, ((((((st64) ((ut64) ((st64) ((st32) ((st64) ((st32) ((Rss >> 0x0) & 0xffffffff)))))) * extract64(((ut64) ((ut16) ((Rtt >> 0x0) & ((st64) 0xffff)))), 0x0, 0x10)) << 0x0) >> 0x10) < ((st64) 0x0)) ? (-(0x1 << 0x1f)) : (0x1 << 0x1f) - ((st64) 0x1)));
	RzILOpEffect *op_ASSIGN_hybrid_tmp_358 = SETL("h_tmp329", cond_355);

	// seq(HYB(gcc_expr_if ((sextract64(((ut64) ((((st64) ((ut64) ((st6 ...;
	RzILOpEffect *seq_359 = SEQN(2, gcc_expr_356, op_ASSIGN_hybrid_tmp_358);

	// Rdd = ((Rdd & (~(0xffffffff << 0x0))) | ((((sextract64(((ut64) ((((st64) ((ut64) ((st64) ((st32) ((st64) ((st32) ((Rss >> 0x0) & 0xffffffff)))))) * extract64(((ut64) ((ut16) ((Rtt >> 0x0) & ((st64) 0xffff)))), 0x0, 0x10)) << 0x0) >> 0x10)), 0x0, 0x20) == ((((st64) ((ut64) ((st64) ((st32) ((st64) ((st32) ((Rss >> 0x0) & 0xffffffff)))))) * extract64(((ut64) ((ut16) ((Rtt >> 0x0) & ((st64) 0xffff)))), 0x0, 0x10)) << 0x0) >> 0x10)) ? ((((st64) ((ut64) ((st64) ((st32) ((st64) ((st32) ((Rss >> 0x0) & 0xffffffff)))))) * extract64(((ut64) ((ut16) ((Rtt >> 0x0) & ((st64) 0xffff)))), 0x0, 0x10)) << 0x0) >> 0x10) : h_tmp329) & 0xffffffff) << 0x0));
	RzILOpPure *op_LSHIFT_191 = SHIFTL0(SN(64, 0xffffffff), SN(32, 0));
	RzILOpPure *op_NOT_192 = LOGNOT(op_LSHIFT_191);
	RzILOpPure *op_AND_193 = LOGAND(READ_REG(pkt, Rdd_op, true), op_NOT_192);
	RzILOpPure *op_RSHIFT_272 = SHIFTRA(DUP(Rss), SN(32, 0));
	RzILOpPure *op_AND_274 = LOGAND(op_RSHIFT_272, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_285 = SHIFTRA(DUP(Rtt), SN(32, 0));
	RzILOpPure *op_AND_288 = LOGAND(op_RSHIFT_285, CAST(64, MSB(SN(32, 0xffff)), SN(32, 0xffff)));
	RzILOpPure *op_MUL_296 = MUL(CAST(64, IL_FALSE, CAST(64, MSB(CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(op_AND_274), DUP(op_AND_274))), CAST(32, MSB(DUP(op_AND_274)), DUP(op_AND_274)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_274)), DUP(op_AND_274))), CAST(32, MSB(DUP(op_AND_274)), DUP(op_AND_274))))), CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(DUP(op_AND_274)), DUP(op_AND_274))), CAST(32, MSB(DUP(op_AND_274)), DUP(op_AND_274)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_274)), DUP(op_AND_274))), CAST(32, MSB(DUP(op_AND_274)), DUP(op_AND_274)))))), EXTRACT64(CAST(64, IL_FALSE, CAST(16, IL_FALSE, op_AND_288)), SN(32, 0), SN(32, 16)));
	RzILOpPure *op_LSHIFT_299 = SHIFTL0(CAST(64, IL_FALSE, op_MUL_296), SN(32, 0));
	RzILOpPure *op_RSHIFT_301 = SHIFTRA(op_LSHIFT_299, SN(32, 16));
	RzILOpPure *cond_360 = ITE(DUP(op_EQ_268), op_RSHIFT_301, VARL("h_tmp329"));
	RzILOpPure *op_AND_362 = LOGAND(cond_360, SN(64, 0xffffffff));
	RzILOpPure *op_LSHIFT_366 = SHIFTL0(op_AND_362, SN(32, 0));
	RzILOpPure *op_OR_367 = LOGOR(op_AND_193, op_LSHIFT_366);
	RzILOpEffect *op_ASSIGN_368 = WRITE_REG(bundle, Rdd_op, op_OR_367);

	// seq(seq(HYB(gcc_expr_if ((sextract64(((ut64) ((((st64) ((ut64) ( ...;
	RzILOpEffect *seq_369 = SEQN(2, seq_359, op_ASSIGN_368);

	RzILOpEffect *instruction_sequence = SEQN(2, seq_185, seq_369);
	return instruction_sequence;
}

// Rdd = vmpyweuh(Rss,Rtt):<<1:sat
RzILOpEffect *hex_il_op_m2_mmpyul_s1(HexInsnPktBundle *bundle) {
	const HexInsn *hi = bundle->insn;
	HexPkt *pkt = bundle->pkt;
	// READ
	const HexOp *Rdd_op = ISA2REG(hi, 'd', false);
	const HexOp *Rss_op = ISA2REG(hi, 's', false);
	RzILOpPure *Rss = READ_REG(pkt, Rss_op, false);
	const HexOp *Rtt_op = ISA2REG(hi, 't', false);
	RzILOpPure *Rtt = READ_REG(pkt, Rtt_op, false);

	// set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, ((ut32) 0x1));
	RzILOpEffect *set_usr_field_call_120 = hex_set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, CAST(32, IL_FALSE, SN(32, 1)));

	// HYB(gcc_expr_if ((sextract64(((ut64) ((((st64) ((ut64) ((st64) ((st32) ((st64) ((st32) ((Rss >> 0x20) & 0xffffffff)))))) * extract64(((ut64) ((ut16) ((Rtt >> 0x20) & ((st64) 0xffff)))), 0x0, 0x10)) << 0x1) >> 0x10)), 0x0, 0x20) == ((((st64) ((ut64) ((st64) ((st32) ((st64) ((st32) ((Rss >> 0x20) & 0xffffffff)))))) * extract64(((ut64) ((ut16) ((Rtt >> 0x20) & ((st64) 0xffff)))), 0x0, 0x10)) << 0x1) >> 0x10))) {{}} else {set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, ((ut32) 0x1))}, ((((((st64) ((ut64) ((st64) ((st32) ((st64) ((st32) ((Rss >> 0x20) & 0xffffffff)))))) * extract64(((ut64) ((ut16) ((Rtt >> 0x20) & ((st64) 0xffff)))), 0x0, 0x10)) << 0x1) >> 0x10) < ((st64) 0x0)) ? (-(0x1 << 0x1f)) : (0x1 << 0x1f) - ((st64) 0x1)));
	RzILOpPure *op_RSHIFT_15 = SHIFTRA(Rss, SN(32, 0x20));
	RzILOpPure *op_AND_17 = LOGAND(op_RSHIFT_15, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_29 = SHIFTRA(Rtt, SN(32, 0x20));
	RzILOpPure *op_AND_32 = LOGAND(op_RSHIFT_29, CAST(64, MSB(SN(32, 0xffff)), SN(32, 0xffff)));
	RzILOpPure *op_MUL_40 = MUL(CAST(64, IL_FALSE, CAST(64, MSB(CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(op_AND_17), DUP(op_AND_17))), CAST(32, MSB(DUP(op_AND_17)), DUP(op_AND_17)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_17)), DUP(op_AND_17))), CAST(32, MSB(DUP(op_AND_17)), DUP(op_AND_17))))), CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(DUP(op_AND_17)), DUP(op_AND_17))), CAST(32, MSB(DUP(op_AND_17)), DUP(op_AND_17)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_17)), DUP(op_AND_17))), CAST(32, MSB(DUP(op_AND_17)), DUP(op_AND_17)))))), EXTRACT64(CAST(64, IL_FALSE, CAST(16, IL_FALSE, op_AND_32)), SN(32, 0), SN(32, 16)));
	RzILOpPure *op_LSHIFT_43 = SHIFTL0(CAST(64, IL_FALSE, op_MUL_40), SN(32, 1));
	RzILOpPure *op_RSHIFT_45 = SHIFTRA(op_LSHIFT_43, SN(32, 16));
	RzILOpPure *op_RSHIFT_54 = SHIFTRA(DUP(Rss), SN(32, 0x20));
	RzILOpPure *op_AND_56 = LOGAND(op_RSHIFT_54, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_67 = SHIFTRA(DUP(Rtt), SN(32, 0x20));
	RzILOpPure *op_AND_70 = LOGAND(op_RSHIFT_67, CAST(64, MSB(SN(32, 0xffff)), SN(32, 0xffff)));
	RzILOpPure *op_MUL_78 = MUL(CAST(64, IL_FALSE, CAST(64, MSB(CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(op_AND_56), DUP(op_AND_56))), CAST(32, MSB(DUP(op_AND_56)), DUP(op_AND_56)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_56)), DUP(op_AND_56))), CAST(32, MSB(DUP(op_AND_56)), DUP(op_AND_56))))), CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(DUP(op_AND_56)), DUP(op_AND_56))), CAST(32, MSB(DUP(op_AND_56)), DUP(op_AND_56)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_56)), DUP(op_AND_56))), CAST(32, MSB(DUP(op_AND_56)), DUP(op_AND_56)))))), EXTRACT64(CAST(64, IL_FALSE, CAST(16, IL_FALSE, op_AND_70)), SN(32, 0), SN(32, 16)));
	RzILOpPure *op_LSHIFT_81 = SHIFTL0(CAST(64, IL_FALSE, op_MUL_78), SN(32, 1));
	RzILOpPure *op_RSHIFT_83 = SHIFTRA(op_LSHIFT_81, SN(32, 16));
	RzILOpPure *op_EQ_84 = EQ(SEXTRACT64(CAST(64, IL_FALSE, op_RSHIFT_45), SN(32, 0), SN(32, 0x20)), op_RSHIFT_83);
	RzILOpPure *op_RSHIFT_124 = SHIFTRA(DUP(Rss), SN(32, 0x20));
	RzILOpPure *op_AND_126 = LOGAND(op_RSHIFT_124, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_137 = SHIFTRA(DUP(Rtt), SN(32, 0x20));
	RzILOpPure *op_AND_140 = LOGAND(op_RSHIFT_137, CAST(64, MSB(SN(32, 0xffff)), SN(32, 0xffff)));
	RzILOpPure *op_MUL_148 = MUL(CAST(64, IL_FALSE, CAST(64, MSB(CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(op_AND_126), DUP(op_AND_126))), CAST(32, MSB(DUP(op_AND_126)), DUP(op_AND_126)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_126)), DUP(op_AND_126))), CAST(32, MSB(DUP(op_AND_126)), DUP(op_AND_126))))), CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(DUP(op_AND_126)), DUP(op_AND_126))), CAST(32, MSB(DUP(op_AND_126)), DUP(op_AND_126)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_126)), DUP(op_AND_126))), CAST(32, MSB(DUP(op_AND_126)), DUP(op_AND_126)))))), EXTRACT64(CAST(64, IL_FALSE, CAST(16, IL_FALSE, op_AND_140)), SN(32, 0), SN(32, 16)));
	RzILOpPure *op_LSHIFT_151 = SHIFTL0(CAST(64, IL_FALSE, op_MUL_148), SN(32, 1));
	RzILOpPure *op_RSHIFT_153 = SHIFTRA(op_LSHIFT_151, SN(32, 16));
	RzILOpPure *op_LT_156 = SLT(op_RSHIFT_153, CAST(64, MSB(SN(32, 0)), SN(32, 0)));
	RzILOpPure *op_LSHIFT_161 = SHIFTL0(SN(64, 1), SN(32, 31));
	RzILOpPure *op_NEG_162 = NEG(op_LSHIFT_161);
	RzILOpPure *op_LSHIFT_167 = SHIFTL0(SN(64, 1), SN(32, 31));
	RzILOpPure *op_SUB_170 = SUB(op_LSHIFT_167, CAST(64, MSB(SN(32, 1)), SN(32, 1)));
	RzILOpPure *cond_171 = ITE(op_LT_156, op_NEG_162, op_SUB_170);
	RzILOpEffect *gcc_expr_172 = BRANCH(op_EQ_84, EMPTY(), set_usr_field_call_120);

	// h_tmp330 = HYB(gcc_expr_if ((sextract64(((ut64) ((((st64) ((ut64) ((st64) ((st32) ((st64) ((st32) ((Rss >> 0x20) & 0xffffffff)))))) * extract64(((ut64) ((ut16) ((Rtt >> 0x20) & ((st64) 0xffff)))), 0x0, 0x10)) << 0x1) >> 0x10)), 0x0, 0x20) == ((((st64) ((ut64) ((st64) ((st32) ((st64) ((st32) ((Rss >> 0x20) & 0xffffffff)))))) * extract64(((ut64) ((ut16) ((Rtt >> 0x20) & ((st64) 0xffff)))), 0x0, 0x10)) << 0x1) >> 0x10))) {{}} else {set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, ((ut32) 0x1))}, ((((((st64) ((ut64) ((st64) ((st32) ((st64) ((st32) ((Rss >> 0x20) & 0xffffffff)))))) * extract64(((ut64) ((ut16) ((Rtt >> 0x20) & ((st64) 0xffff)))), 0x0, 0x10)) << 0x1) >> 0x10) < ((st64) 0x0)) ? (-(0x1 << 0x1f)) : (0x1 << 0x1f) - ((st64) 0x1)));
	RzILOpEffect *op_ASSIGN_hybrid_tmp_174 = SETL("h_tmp330", cond_171);

	// seq(HYB(gcc_expr_if ((sextract64(((ut64) ((((st64) ((ut64) ((st6 ...;
	RzILOpEffect *seq_175 = SEQN(2, gcc_expr_172, op_ASSIGN_hybrid_tmp_174);

	// Rdd = ((Rdd & (~(0xffffffff << 0x20))) | ((((sextract64(((ut64) ((((st64) ((ut64) ((st64) ((st32) ((st64) ((st32) ((Rss >> 0x20) & 0xffffffff)))))) * extract64(((ut64) ((ut16) ((Rtt >> 0x20) & ((st64) 0xffff)))), 0x0, 0x10)) << 0x1) >> 0x10)), 0x0, 0x20) == ((((st64) ((ut64) ((st64) ((st32) ((st64) ((st32) ((Rss >> 0x20) & 0xffffffff)))))) * extract64(((ut64) ((ut16) ((Rtt >> 0x20) & ((st64) 0xffff)))), 0x0, 0x10)) << 0x1) >> 0x10)) ? ((((st64) ((ut64) ((st64) ((st32) ((st64) ((st32) ((Rss >> 0x20) & 0xffffffff)))))) * extract64(((ut64) ((ut16) ((Rtt >> 0x20) & ((st64) 0xffff)))), 0x0, 0x10)) << 0x1) >> 0x10) : h_tmp330) & 0xffffffff) << 0x20));
	RzILOpPure *op_LSHIFT_5 = SHIFTL0(SN(64, 0xffffffff), SN(32, 0x20));
	RzILOpPure *op_NOT_6 = LOGNOT(op_LSHIFT_5);
	RzILOpPure *op_AND_7 = LOGAND(READ_REG(pkt, Rdd_op, true), op_NOT_6);
	RzILOpPure *op_RSHIFT_88 = SHIFTRA(DUP(Rss), SN(32, 0x20));
	RzILOpPure *op_AND_90 = LOGAND(op_RSHIFT_88, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_101 = SHIFTRA(DUP(Rtt), SN(32, 0x20));
	RzILOpPure *op_AND_104 = LOGAND(op_RSHIFT_101, CAST(64, MSB(SN(32, 0xffff)), SN(32, 0xffff)));
	RzILOpPure *op_MUL_112 = MUL(CAST(64, IL_FALSE, CAST(64, MSB(CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(op_AND_90), DUP(op_AND_90))), CAST(32, MSB(DUP(op_AND_90)), DUP(op_AND_90)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_90)), DUP(op_AND_90))), CAST(32, MSB(DUP(op_AND_90)), DUP(op_AND_90))))), CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(DUP(op_AND_90)), DUP(op_AND_90))), CAST(32, MSB(DUP(op_AND_90)), DUP(op_AND_90)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_90)), DUP(op_AND_90))), CAST(32, MSB(DUP(op_AND_90)), DUP(op_AND_90)))))), EXTRACT64(CAST(64, IL_FALSE, CAST(16, IL_FALSE, op_AND_104)), SN(32, 0), SN(32, 16)));
	RzILOpPure *op_LSHIFT_115 = SHIFTL0(CAST(64, IL_FALSE, op_MUL_112), SN(32, 1));
	RzILOpPure *op_RSHIFT_117 = SHIFTRA(op_LSHIFT_115, SN(32, 16));
	RzILOpPure *cond_176 = ITE(DUP(op_EQ_84), op_RSHIFT_117, VARL("h_tmp330"));
	RzILOpPure *op_AND_178 = LOGAND(cond_176, SN(64, 0xffffffff));
	RzILOpPure *op_LSHIFT_182 = SHIFTL0(op_AND_178, SN(32, 0x20));
	RzILOpPure *op_OR_183 = LOGOR(op_AND_7, op_LSHIFT_182);
	RzILOpEffect *op_ASSIGN_184 = WRITE_REG(bundle, Rdd_op, op_OR_183);

	// seq(seq(HYB(gcc_expr_if ((sextract64(((ut64) ((((st64) ((ut64) ( ...;
	RzILOpEffect *seq_185 = SEQN(2, seq_175, op_ASSIGN_184);

	// set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, ((ut32) 0x1));
	RzILOpEffect *set_usr_field_call_304 = hex_set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, CAST(32, IL_FALSE, SN(32, 1)));

	// HYB(gcc_expr_if ((sextract64(((ut64) ((((st64) ((ut64) ((st64) ((st32) ((st64) ((st32) ((Rss >> 0x0) & 0xffffffff)))))) * extract64(((ut64) ((ut16) ((Rtt >> 0x0) & ((st64) 0xffff)))), 0x0, 0x10)) << 0x1) >> 0x10)), 0x0, 0x20) == ((((st64) ((ut64) ((st64) ((st32) ((st64) ((st32) ((Rss >> 0x0) & 0xffffffff)))))) * extract64(((ut64) ((ut16) ((Rtt >> 0x0) & ((st64) 0xffff)))), 0x0, 0x10)) << 0x1) >> 0x10))) {{}} else {set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, ((ut32) 0x1))}, ((((((st64) ((ut64) ((st64) ((st32) ((st64) ((st32) ((Rss >> 0x0) & 0xffffffff)))))) * extract64(((ut64) ((ut16) ((Rtt >> 0x0) & ((st64) 0xffff)))), 0x0, 0x10)) << 0x1) >> 0x10) < ((st64) 0x0)) ? (-(0x1 << 0x1f)) : (0x1 << 0x1f) - ((st64) 0x1)));
	RzILOpPure *op_RSHIFT_200 = SHIFTRA(DUP(Rss), SN(32, 0));
	RzILOpPure *op_AND_202 = LOGAND(op_RSHIFT_200, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_213 = SHIFTRA(DUP(Rtt), SN(32, 0));
	RzILOpPure *op_AND_216 = LOGAND(op_RSHIFT_213, CAST(64, MSB(SN(32, 0xffff)), SN(32, 0xffff)));
	RzILOpPure *op_MUL_224 = MUL(CAST(64, IL_FALSE, CAST(64, MSB(CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(op_AND_202), DUP(op_AND_202))), CAST(32, MSB(DUP(op_AND_202)), DUP(op_AND_202)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_202)), DUP(op_AND_202))), CAST(32, MSB(DUP(op_AND_202)), DUP(op_AND_202))))), CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(DUP(op_AND_202)), DUP(op_AND_202))), CAST(32, MSB(DUP(op_AND_202)), DUP(op_AND_202)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_202)), DUP(op_AND_202))), CAST(32, MSB(DUP(op_AND_202)), DUP(op_AND_202)))))), EXTRACT64(CAST(64, IL_FALSE, CAST(16, IL_FALSE, op_AND_216)), SN(32, 0), SN(32, 16)));
	RzILOpPure *op_LSHIFT_227 = SHIFTL0(CAST(64, IL_FALSE, op_MUL_224), SN(32, 1));
	RzILOpPure *op_RSHIFT_229 = SHIFTRA(op_LSHIFT_227, SN(32, 16));
	RzILOpPure *op_RSHIFT_238 = SHIFTRA(DUP(Rss), SN(32, 0));
	RzILOpPure *op_AND_240 = LOGAND(op_RSHIFT_238, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_251 = SHIFTRA(DUP(Rtt), SN(32, 0));
	RzILOpPure *op_AND_254 = LOGAND(op_RSHIFT_251, CAST(64, MSB(SN(32, 0xffff)), SN(32, 0xffff)));
	RzILOpPure *op_MUL_262 = MUL(CAST(64, IL_FALSE, CAST(64, MSB(CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(op_AND_240), DUP(op_AND_240))), CAST(32, MSB(DUP(op_AND_240)), DUP(op_AND_240)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_240)), DUP(op_AND_240))), CAST(32, MSB(DUP(op_AND_240)), DUP(op_AND_240))))), CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(DUP(op_AND_240)), DUP(op_AND_240))), CAST(32, MSB(DUP(op_AND_240)), DUP(op_AND_240)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_240)), DUP(op_AND_240))), CAST(32, MSB(DUP(op_AND_240)), DUP(op_AND_240)))))), EXTRACT64(CAST(64, IL_FALSE, CAST(16, IL_FALSE, op_AND_254)), SN(32, 0), SN(32, 16)));
	RzILOpPure *op_LSHIFT_265 = SHIFTL0(CAST(64, IL_FALSE, op_MUL_262), SN(32, 1));
	RzILOpPure *op_RSHIFT_267 = SHIFTRA(op_LSHIFT_265, SN(32, 16));
	RzILOpPure *op_EQ_268 = EQ(SEXTRACT64(CAST(64, IL_FALSE, op_RSHIFT_229), SN(32, 0), SN(32, 0x20)), op_RSHIFT_267);
	RzILOpPure *op_RSHIFT_308 = SHIFTRA(DUP(Rss), SN(32, 0));
	RzILOpPure *op_AND_310 = LOGAND(op_RSHIFT_308, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_321 = SHIFTRA(DUP(Rtt), SN(32, 0));
	RzILOpPure *op_AND_324 = LOGAND(op_RSHIFT_321, CAST(64, MSB(SN(32, 0xffff)), SN(32, 0xffff)));
	RzILOpPure *op_MUL_332 = MUL(CAST(64, IL_FALSE, CAST(64, MSB(CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(op_AND_310), DUP(op_AND_310))), CAST(32, MSB(DUP(op_AND_310)), DUP(op_AND_310)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_310)), DUP(op_AND_310))), CAST(32, MSB(DUP(op_AND_310)), DUP(op_AND_310))))), CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(DUP(op_AND_310)), DUP(op_AND_310))), CAST(32, MSB(DUP(op_AND_310)), DUP(op_AND_310)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_310)), DUP(op_AND_310))), CAST(32, MSB(DUP(op_AND_310)), DUP(op_AND_310)))))), EXTRACT64(CAST(64, IL_FALSE, CAST(16, IL_FALSE, op_AND_324)), SN(32, 0), SN(32, 16)));
	RzILOpPure *op_LSHIFT_335 = SHIFTL0(CAST(64, IL_FALSE, op_MUL_332), SN(32, 1));
	RzILOpPure *op_RSHIFT_337 = SHIFTRA(op_LSHIFT_335, SN(32, 16));
	RzILOpPure *op_LT_340 = SLT(op_RSHIFT_337, CAST(64, MSB(SN(32, 0)), SN(32, 0)));
	RzILOpPure *op_LSHIFT_345 = SHIFTL0(SN(64, 1), SN(32, 31));
	RzILOpPure *op_NEG_346 = NEG(op_LSHIFT_345);
	RzILOpPure *op_LSHIFT_351 = SHIFTL0(SN(64, 1), SN(32, 31));
	RzILOpPure *op_SUB_354 = SUB(op_LSHIFT_351, CAST(64, MSB(SN(32, 1)), SN(32, 1)));
	RzILOpPure *cond_355 = ITE(op_LT_340, op_NEG_346, op_SUB_354);
	RzILOpEffect *gcc_expr_356 = BRANCH(op_EQ_268, EMPTY(), set_usr_field_call_304);

	// h_tmp331 = HYB(gcc_expr_if ((sextract64(((ut64) ((((st64) ((ut64) ((st64) ((st32) ((st64) ((st32) ((Rss >> 0x0) & 0xffffffff)))))) * extract64(((ut64) ((ut16) ((Rtt >> 0x0) & ((st64) 0xffff)))), 0x0, 0x10)) << 0x1) >> 0x10)), 0x0, 0x20) == ((((st64) ((ut64) ((st64) ((st32) ((st64) ((st32) ((Rss >> 0x0) & 0xffffffff)))))) * extract64(((ut64) ((ut16) ((Rtt >> 0x0) & ((st64) 0xffff)))), 0x0, 0x10)) << 0x1) >> 0x10))) {{}} else {set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, ((ut32) 0x1))}, ((((((st64) ((ut64) ((st64) ((st32) ((st64) ((st32) ((Rss >> 0x0) & 0xffffffff)))))) * extract64(((ut64) ((ut16) ((Rtt >> 0x0) & ((st64) 0xffff)))), 0x0, 0x10)) << 0x1) >> 0x10) < ((st64) 0x0)) ? (-(0x1 << 0x1f)) : (0x1 << 0x1f) - ((st64) 0x1)));
	RzILOpEffect *op_ASSIGN_hybrid_tmp_358 = SETL("h_tmp331", cond_355);

	// seq(HYB(gcc_expr_if ((sextract64(((ut64) ((((st64) ((ut64) ((st6 ...;
	RzILOpEffect *seq_359 = SEQN(2, gcc_expr_356, op_ASSIGN_hybrid_tmp_358);

	// Rdd = ((Rdd & (~(0xffffffff << 0x0))) | ((((sextract64(((ut64) ((((st64) ((ut64) ((st64) ((st32) ((st64) ((st32) ((Rss >> 0x0) & 0xffffffff)))))) * extract64(((ut64) ((ut16) ((Rtt >> 0x0) & ((st64) 0xffff)))), 0x0, 0x10)) << 0x1) >> 0x10)), 0x0, 0x20) == ((((st64) ((ut64) ((st64) ((st32) ((st64) ((st32) ((Rss >> 0x0) & 0xffffffff)))))) * extract64(((ut64) ((ut16) ((Rtt >> 0x0) & ((st64) 0xffff)))), 0x0, 0x10)) << 0x1) >> 0x10)) ? ((((st64) ((ut64) ((st64) ((st32) ((st64) ((st32) ((Rss >> 0x0) & 0xffffffff)))))) * extract64(((ut64) ((ut16) ((Rtt >> 0x0) & ((st64) 0xffff)))), 0x0, 0x10)) << 0x1) >> 0x10) : h_tmp331) & 0xffffffff) << 0x0));
	RzILOpPure *op_LSHIFT_191 = SHIFTL0(SN(64, 0xffffffff), SN(32, 0));
	RzILOpPure *op_NOT_192 = LOGNOT(op_LSHIFT_191);
	RzILOpPure *op_AND_193 = LOGAND(READ_REG(pkt, Rdd_op, true), op_NOT_192);
	RzILOpPure *op_RSHIFT_272 = SHIFTRA(DUP(Rss), SN(32, 0));
	RzILOpPure *op_AND_274 = LOGAND(op_RSHIFT_272, SN(64, 0xffffffff));
	RzILOpPure *op_RSHIFT_285 = SHIFTRA(DUP(Rtt), SN(32, 0));
	RzILOpPure *op_AND_288 = LOGAND(op_RSHIFT_285, CAST(64, MSB(SN(32, 0xffff)), SN(32, 0xffff)));
	RzILOpPure *op_MUL_296 = MUL(CAST(64, IL_FALSE, CAST(64, MSB(CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(op_AND_274), DUP(op_AND_274))), CAST(32, MSB(DUP(op_AND_274)), DUP(op_AND_274)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_274)), DUP(op_AND_274))), CAST(32, MSB(DUP(op_AND_274)), DUP(op_AND_274))))), CAST(32, MSB(CAST(64, MSB(CAST(32, MSB(DUP(op_AND_274)), DUP(op_AND_274))), CAST(32, MSB(DUP(op_AND_274)), DUP(op_AND_274)))), CAST(64, MSB(CAST(32, MSB(DUP(op_AND_274)), DUP(op_AND_274))), CAST(32, MSB(DUP(op_AND_274)), DUP(op_AND_274)))))), EXTRACT64(CAST(64, IL_FALSE, CAST(16, IL_FALSE, op_AND_288)), SN(32, 0), SN(32, 16)));
	RzILOpPure *op_LSHIFT_299 = SHIFTL0(CAST(64, IL_FALSE, op_MUL_296), SN(32, 1));
	RzILOpPure *op_RSHIFT_301 = SHIFTRA(op_LSHIFT_299, SN(32, 16));
	RzILOpPure *cond_360 = ITE(DUP(op_EQ_268), op_RSHIFT_301, VARL("h_tmp331"));
	RzILOpPure *op_AND_362 = LOGAND(cond_360, SN(64, 0xffffffff));
	RzILOpPure *op_LSHIFT_366 = SHIFTL0(op_AND_362, SN(32, 0));
	RzILOpPure *op_OR_367 = LOGOR(op_AND_193, op_LSHIFT_366);
	RzILOpEffect *op_ASSIGN_368 = WRITE_REG(bundle, Rdd_op, op_OR_367);

	// seq(seq(HYB(gcc_expr_if ((sextract64(((ut64) ((((st64) ((ut64) ( ...;
	RzILOpEffect *seq_369 = SEQN(2, seq_359, op_ASSIGN_368);

	RzILOpEffect *instruction_sequence = SEQN(2, seq_185, seq_369);
	return instruction_sequence;
}

// Rx -= mpyi(Rs,Rt)
RzILOpEffect *hex_il_op_m2_mnaci(HexInsnPktBundle *bundle) {
	const HexInsn *hi = bundle->insn;
	HexPkt *pkt = bundle->pkt;
	// READ
	const HexOp *Rx_op = ISA2REG(hi, 'x', false);

	const HexOp *Rs_op = ISA2REG(hi, 's', false);
	RzILOpPure *Rs = READ_REG(pkt, Rs_op, false);
	const HexOp *Rt_op = ISA2REG(hi, 't', false);
	RzILOpPure *Rt = READ_REG(pkt, Rt_op, false);

	// Rx = Rx - Rs * Rt;
	RzILOpPure *op_MUL_3 = MUL(Rs, Rt);
	RzILOpPure *op_SUB_4 = SUB(READ_REG(pkt, Rx_op, false), op_MUL_3);
	RzILOpEffect *op_ASSIGN_5 = WRITE_REG(bundle, Rx_op, op_SUB_4);

	RzILOpEffect *instruction_sequence = op_ASSIGN_5;
	return instruction_sequence;
}

// Rx += mpy(Rs.h,Rt.h)
RzILOpEffect *hex_il_op_m2_mpy_acc_hh_s0(HexInsnPktBundle *bundle) {
	const HexInsn *hi = bundle->insn;
	HexPkt *pkt = bundle->pkt;
	// READ
	const HexOp *Rx_op = ISA2REG(hi, 'x', false);

	const HexOp *Rs_op = ISA2REG(hi, 's', false);
	RzILOpPure *Rs = READ_REG(pkt, Rs_op, false);
	const HexOp *Rt_op = ISA2REG(hi, 't', false);
	RzILOpPure *Rt = READ_REG(pkt, Rt_op, false);

	// Rx = ((st32) ((st64) Rx) + ((st64) ((st32) ((st16) ((Rs >> 0x10) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x10) & 0xffff)))));
	RzILOpPure *op_RSHIFT_5 = SHIFTRA(Rs, SN(32, 16));
	RzILOpPure *op_AND_7 = LOGAND(op_RSHIFT_5, SN(32, 0xffff));
	RzILOpPure *op_RSHIFT_14 = SHIFTRA(Rt, SN(32, 16));
	RzILOpPure *op_AND_16 = LOGAND(op_RSHIFT_14, SN(32, 0xffff));
	RzILOpPure *op_MUL_19 = MUL(CAST(32, MSB(CAST(16, MSB(op_AND_7), DUP(op_AND_7))), CAST(16, MSB(DUP(op_AND_7)), DUP(op_AND_7))), CAST(32, MSB(CAST(16, MSB(op_AND_16), DUP(op_AND_16))), CAST(16, MSB(DUP(op_AND_16)), DUP(op_AND_16))));
	RzILOpPure *op_ADD_22 = ADD(CAST(64, MSB(READ_REG(pkt, Rx_op, false)), READ_REG(pkt, Rx_op, false)), CAST(64, MSB(op_MUL_19), DUP(op_MUL_19)));
	RzILOpEffect *op_ASSIGN_24 = WRITE_REG(bundle, Rx_op, CAST(32, MSB(op_ADD_22), DUP(op_ADD_22)));

	RzILOpEffect *instruction_sequence = op_ASSIGN_24;
	return instruction_sequence;
}

// Rx += mpy(Rs.h,Rt.h):<<1
RzILOpEffect *hex_il_op_m2_mpy_acc_hh_s1(HexInsnPktBundle *bundle) {
	const HexInsn *hi = bundle->insn;
	HexPkt *pkt = bundle->pkt;
	// READ
	const HexOp *Rx_op = ISA2REG(hi, 'x', false);

	const HexOp *Rs_op = ISA2REG(hi, 's', false);
	RzILOpPure *Rs = READ_REG(pkt, Rs_op, false);
	const HexOp *Rt_op = ISA2REG(hi, 't', false);
	RzILOpPure *Rt = READ_REG(pkt, Rt_op, false);

	// Rx = ((st32) ((st64) Rx) + (((st64) ((st32) ((st16) ((Rs >> 0x10) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x10) & 0xffff)))) << 0x1));
	RzILOpPure *op_RSHIFT_5 = SHIFTRA(Rs, SN(32, 16));
	RzILOpPure *op_AND_7 = LOGAND(op_RSHIFT_5, SN(32, 0xffff));
	RzILOpPure *op_RSHIFT_14 = SHIFTRA(Rt, SN(32, 16));
	RzILOpPure *op_AND_16 = LOGAND(op_RSHIFT_14, SN(32, 0xffff));
	RzILOpPure *op_MUL_19 = MUL(CAST(32, MSB(CAST(16, MSB(op_AND_7), DUP(op_AND_7))), CAST(16, MSB(DUP(op_AND_7)), DUP(op_AND_7))), CAST(32, MSB(CAST(16, MSB(op_AND_16), DUP(op_AND_16))), CAST(16, MSB(DUP(op_AND_16)), DUP(op_AND_16))));
	RzILOpPure *op_LSHIFT_22 = SHIFTL0(CAST(64, MSB(op_MUL_19), DUP(op_MUL_19)), SN(32, 1));
	RzILOpPure *op_ADD_24 = ADD(CAST(64, MSB(READ_REG(pkt, Rx_op, false)), READ_REG(pkt, Rx_op, false)), op_LSHIFT_22);
	RzILOpEffect *op_ASSIGN_26 = WRITE_REG(bundle, Rx_op, CAST(32, MSB(op_ADD_24), DUP(op_ADD_24)));

	RzILOpEffect *instruction_sequence = op_ASSIGN_26;
	return instruction_sequence;
}

// Rx += mpy(Rs.h,Rt.l)
RzILOpEffect *hex_il_op_m2_mpy_acc_hl_s0(HexInsnPktBundle *bundle) {
	const HexInsn *hi = bundle->insn;
	HexPkt *pkt = bundle->pkt;
	// READ
	const HexOp *Rx_op = ISA2REG(hi, 'x', false);

	const HexOp *Rs_op = ISA2REG(hi, 's', false);
	RzILOpPure *Rs = READ_REG(pkt, Rs_op, false);
	const HexOp *Rt_op = ISA2REG(hi, 't', false);
	RzILOpPure *Rt = READ_REG(pkt, Rt_op, false);

	// Rx = ((st32) ((st64) Rx) + ((st64) ((st32) ((st16) ((Rs >> 0x10) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x0) & 0xffff)))));
	RzILOpPure *op_RSHIFT_5 = SHIFTRA(Rs, SN(32, 16));
	RzILOpPure *op_AND_7 = LOGAND(op_RSHIFT_5, SN(32, 0xffff));
	RzILOpPure *op_RSHIFT_14 = SHIFTRA(Rt, SN(32, 0));
	RzILOpPure *op_AND_16 = LOGAND(op_RSHIFT_14, SN(32, 0xffff));
	RzILOpPure *op_MUL_19 = MUL(CAST(32, MSB(CAST(16, MSB(op_AND_7), DUP(op_AND_7))), CAST(16, MSB(DUP(op_AND_7)), DUP(op_AND_7))), CAST(32, MSB(CAST(16, MSB(op_AND_16), DUP(op_AND_16))), CAST(16, MSB(DUP(op_AND_16)), DUP(op_AND_16))));
	RzILOpPure *op_ADD_22 = ADD(CAST(64, MSB(READ_REG(pkt, Rx_op, false)), READ_REG(pkt, Rx_op, false)), CAST(64, MSB(op_MUL_19), DUP(op_MUL_19)));
	RzILOpEffect *op_ASSIGN_24 = WRITE_REG(bundle, Rx_op, CAST(32, MSB(op_ADD_22), DUP(op_ADD_22)));

	RzILOpEffect *instruction_sequence = op_ASSIGN_24;
	return instruction_sequence;
}

// Rx += mpy(Rs.h,Rt.l):<<1
RzILOpEffect *hex_il_op_m2_mpy_acc_hl_s1(HexInsnPktBundle *bundle) {
	const HexInsn *hi = bundle->insn;
	HexPkt *pkt = bundle->pkt;
	// READ
	const HexOp *Rx_op = ISA2REG(hi, 'x', false);

	const HexOp *Rs_op = ISA2REG(hi, 's', false);
	RzILOpPure *Rs = READ_REG(pkt, Rs_op, false);
	const HexOp *Rt_op = ISA2REG(hi, 't', false);
	RzILOpPure *Rt = READ_REG(pkt, Rt_op, false);

	// Rx = ((st32) ((st64) Rx) + (((st64) ((st32) ((st16) ((Rs >> 0x10) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x0) & 0xffff)))) << 0x1));
	RzILOpPure *op_RSHIFT_5 = SHIFTRA(Rs, SN(32, 16));
	RzILOpPure *op_AND_7 = LOGAND(op_RSHIFT_5, SN(32, 0xffff));
	RzILOpPure *op_RSHIFT_14 = SHIFTRA(Rt, SN(32, 0));
	RzILOpPure *op_AND_16 = LOGAND(op_RSHIFT_14, SN(32, 0xffff));
	RzILOpPure *op_MUL_19 = MUL(CAST(32, MSB(CAST(16, MSB(op_AND_7), DUP(op_AND_7))), CAST(16, MSB(DUP(op_AND_7)), DUP(op_AND_7))), CAST(32, MSB(CAST(16, MSB(op_AND_16), DUP(op_AND_16))), CAST(16, MSB(DUP(op_AND_16)), DUP(op_AND_16))));
	RzILOpPure *op_LSHIFT_22 = SHIFTL0(CAST(64, MSB(op_MUL_19), DUP(op_MUL_19)), SN(32, 1));
	RzILOpPure *op_ADD_24 = ADD(CAST(64, MSB(READ_REG(pkt, Rx_op, false)), READ_REG(pkt, Rx_op, false)), op_LSHIFT_22);
	RzILOpEffect *op_ASSIGN_26 = WRITE_REG(bundle, Rx_op, CAST(32, MSB(op_ADD_24), DUP(op_ADD_24)));

	RzILOpEffect *instruction_sequence = op_ASSIGN_26;
	return instruction_sequence;
}

// Rx += mpy(Rs.l,Rt.h)
RzILOpEffect *hex_il_op_m2_mpy_acc_lh_s0(HexInsnPktBundle *bundle) {
	const HexInsn *hi = bundle->insn;
	HexPkt *pkt = bundle->pkt;
	// READ
	const HexOp *Rx_op = ISA2REG(hi, 'x', false);

	const HexOp *Rs_op = ISA2REG(hi, 's', false);
	RzILOpPure *Rs = READ_REG(pkt, Rs_op, false);
	const HexOp *Rt_op = ISA2REG(hi, 't', false);
	RzILOpPure *Rt = READ_REG(pkt, Rt_op, false);

	// Rx = ((st32) ((st64) Rx) + ((st64) ((st32) ((st16) ((Rs >> 0x0) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x10) & 0xffff)))));
	RzILOpPure *op_RSHIFT_5 = SHIFTRA(Rs, SN(32, 0));
	RzILOpPure *op_AND_7 = LOGAND(op_RSHIFT_5, SN(32, 0xffff));
	RzILOpPure *op_RSHIFT_14 = SHIFTRA(Rt, SN(32, 16));
	RzILOpPure *op_AND_16 = LOGAND(op_RSHIFT_14, SN(32, 0xffff));
	RzILOpPure *op_MUL_19 = MUL(CAST(32, MSB(CAST(16, MSB(op_AND_7), DUP(op_AND_7))), CAST(16, MSB(DUP(op_AND_7)), DUP(op_AND_7))), CAST(32, MSB(CAST(16, MSB(op_AND_16), DUP(op_AND_16))), CAST(16, MSB(DUP(op_AND_16)), DUP(op_AND_16))));
	RzILOpPure *op_ADD_22 = ADD(CAST(64, MSB(READ_REG(pkt, Rx_op, false)), READ_REG(pkt, Rx_op, false)), CAST(64, MSB(op_MUL_19), DUP(op_MUL_19)));
	RzILOpEffect *op_ASSIGN_24 = WRITE_REG(bundle, Rx_op, CAST(32, MSB(op_ADD_22), DUP(op_ADD_22)));

	RzILOpEffect *instruction_sequence = op_ASSIGN_24;
	return instruction_sequence;
}

// Rx += mpy(Rs.l,Rt.h):<<1
RzILOpEffect *hex_il_op_m2_mpy_acc_lh_s1(HexInsnPktBundle *bundle) {
	const HexInsn *hi = bundle->insn;
	HexPkt *pkt = bundle->pkt;
	// READ
	const HexOp *Rx_op = ISA2REG(hi, 'x', false);

	const HexOp *Rs_op = ISA2REG(hi, 's', false);
	RzILOpPure *Rs = READ_REG(pkt, Rs_op, false);
	const HexOp *Rt_op = ISA2REG(hi, 't', false);
	RzILOpPure *Rt = READ_REG(pkt, Rt_op, false);

	// Rx = ((st32) ((st64) Rx) + (((st64) ((st32) ((st16) ((Rs >> 0x0) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x10) & 0xffff)))) << 0x1));
	RzILOpPure *op_RSHIFT_5 = SHIFTRA(Rs, SN(32, 0));
	RzILOpPure *op_AND_7 = LOGAND(op_RSHIFT_5, SN(32, 0xffff));
	RzILOpPure *op_RSHIFT_14 = SHIFTRA(Rt, SN(32, 16));
	RzILOpPure *op_AND_16 = LOGAND(op_RSHIFT_14, SN(32, 0xffff));
	RzILOpPure *op_MUL_19 = MUL(CAST(32, MSB(CAST(16, MSB(op_AND_7), DUP(op_AND_7))), CAST(16, MSB(DUP(op_AND_7)), DUP(op_AND_7))), CAST(32, MSB(CAST(16, MSB(op_AND_16), DUP(op_AND_16))), CAST(16, MSB(DUP(op_AND_16)), DUP(op_AND_16))));
	RzILOpPure *op_LSHIFT_22 = SHIFTL0(CAST(64, MSB(op_MUL_19), DUP(op_MUL_19)), SN(32, 1));
	RzILOpPure *op_ADD_24 = ADD(CAST(64, MSB(READ_REG(pkt, Rx_op, false)), READ_REG(pkt, Rx_op, false)), op_LSHIFT_22);
	RzILOpEffect *op_ASSIGN_26 = WRITE_REG(bundle, Rx_op, CAST(32, MSB(op_ADD_24), DUP(op_ADD_24)));

	RzILOpEffect *instruction_sequence = op_ASSIGN_26;
	return instruction_sequence;
}

// Rx += mpy(Rs.l,Rt.l)
RzILOpEffect *hex_il_op_m2_mpy_acc_ll_s0(HexInsnPktBundle *bundle) {
	const HexInsn *hi = bundle->insn;
	HexPkt *pkt = bundle->pkt;
	// READ
	const HexOp *Rx_op = ISA2REG(hi, 'x', false);

	const HexOp *Rs_op = ISA2REG(hi, 's', false);
	RzILOpPure *Rs = READ_REG(pkt, Rs_op, false);
	const HexOp *Rt_op = ISA2REG(hi, 't', false);
	RzILOpPure *Rt = READ_REG(pkt, Rt_op, false);

	// Rx = ((st32) ((st64) Rx) + ((st64) ((st32) ((st16) ((Rs >> 0x0) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x0) & 0xffff)))));
	RzILOpPure *op_RSHIFT_5 = SHIFTRA(Rs, SN(32, 0));
	RzILOpPure *op_AND_7 = LOGAND(op_RSHIFT_5, SN(32, 0xffff));
	RzILOpPure *op_RSHIFT_14 = SHIFTRA(Rt, SN(32, 0));
	RzILOpPure *op_AND_16 = LOGAND(op_RSHIFT_14, SN(32, 0xffff));
	RzILOpPure *op_MUL_19 = MUL(CAST(32, MSB(CAST(16, MSB(op_AND_7), DUP(op_AND_7))), CAST(16, MSB(DUP(op_AND_7)), DUP(op_AND_7))), CAST(32, MSB(CAST(16, MSB(op_AND_16), DUP(op_AND_16))), CAST(16, MSB(DUP(op_AND_16)), DUP(op_AND_16))));
	RzILOpPure *op_ADD_22 = ADD(CAST(64, MSB(READ_REG(pkt, Rx_op, false)), READ_REG(pkt, Rx_op, false)), CAST(64, MSB(op_MUL_19), DUP(op_MUL_19)));
	RzILOpEffect *op_ASSIGN_24 = WRITE_REG(bundle, Rx_op, CAST(32, MSB(op_ADD_22), DUP(op_ADD_22)));

	RzILOpEffect *instruction_sequence = op_ASSIGN_24;
	return instruction_sequence;
}

// Rx += mpy(Rs.l,Rt.l):<<1
RzILOpEffect *hex_il_op_m2_mpy_acc_ll_s1(HexInsnPktBundle *bundle) {
	const HexInsn *hi = bundle->insn;
	HexPkt *pkt = bundle->pkt;
	// READ
	const HexOp *Rx_op = ISA2REG(hi, 'x', false);

	const HexOp *Rs_op = ISA2REG(hi, 's', false);
	RzILOpPure *Rs = READ_REG(pkt, Rs_op, false);
	const HexOp *Rt_op = ISA2REG(hi, 't', false);
	RzILOpPure *Rt = READ_REG(pkt, Rt_op, false);

	// Rx = ((st32) ((st64) Rx) + (((st64) ((st32) ((st16) ((Rs >> 0x0) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x0) & 0xffff)))) << 0x1));
	RzILOpPure *op_RSHIFT_5 = SHIFTRA(Rs, SN(32, 0));
	RzILOpPure *op_AND_7 = LOGAND(op_RSHIFT_5, SN(32, 0xffff));
	RzILOpPure *op_RSHIFT_14 = SHIFTRA(Rt, SN(32, 0));
	RzILOpPure *op_AND_16 = LOGAND(op_RSHIFT_14, SN(32, 0xffff));
	RzILOpPure *op_MUL_19 = MUL(CAST(32, MSB(CAST(16, MSB(op_AND_7), DUP(op_AND_7))), CAST(16, MSB(DUP(op_AND_7)), DUP(op_AND_7))), CAST(32, MSB(CAST(16, MSB(op_AND_16), DUP(op_AND_16))), CAST(16, MSB(DUP(op_AND_16)), DUP(op_AND_16))));
	RzILOpPure *op_LSHIFT_22 = SHIFTL0(CAST(64, MSB(op_MUL_19), DUP(op_MUL_19)), SN(32, 1));
	RzILOpPure *op_ADD_24 = ADD(CAST(64, MSB(READ_REG(pkt, Rx_op, false)), READ_REG(pkt, Rx_op, false)), op_LSHIFT_22);
	RzILOpEffect *op_ASSIGN_26 = WRITE_REG(bundle, Rx_op, CAST(32, MSB(op_ADD_24), DUP(op_ADD_24)));

	RzILOpEffect *instruction_sequence = op_ASSIGN_26;
	return instruction_sequence;
}

// Rx += mpy(Rs.h,Rt.h):sat
RzILOpEffect *hex_il_op_m2_mpy_acc_sat_hh_s0(HexInsnPktBundle *bundle) {
	const HexInsn *hi = bundle->insn;
	HexPkt *pkt = bundle->pkt;
	// READ
	const HexOp *Rx_op = ISA2REG(hi, 'x', false);

	const HexOp *Rs_op = ISA2REG(hi, 's', false);
	RzILOpPure *Rs = READ_REG(pkt, Rs_op, false);
	const HexOp *Rt_op = ISA2REG(hi, 't', false);
	RzILOpPure *Rt = READ_REG(pkt, Rt_op, false);

	// set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, ((ut32) 0x1));
	RzILOpEffect *set_usr_field_call_74 = hex_set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, CAST(32, IL_FALSE, SN(32, 1)));

	// HYB(gcc_expr_if ((sextract64(((ut64) ((st64) Rx) + ((st64) ((st32) ((st16) ((Rs >> 0x10) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x10) & 0xffff))))), 0x0, 0x20) == ((st64) Rx) + ((st64) ((st32) ((st16) ((Rs >> 0x10) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x10) & 0xffff)))))) {{}} else {set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, ((ut32) 0x1))}, ((((st64) Rx) + ((st64) ((st32) ((st16) ((Rs >> 0x10) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x10) & 0xffff)))) < ((st64) 0x0)) ? (-(0x1 << 0x1f)) : (0x1 << 0x1f) - ((st64) 0x1)));
	RzILOpPure *op_RSHIFT_8 = SHIFTRA(Rs, SN(32, 16));
	RzILOpPure *op_AND_10 = LOGAND(op_RSHIFT_8, SN(32, 0xffff));
	RzILOpPure *op_RSHIFT_17 = SHIFTRA(Rt, SN(32, 16));
	RzILOpPure *op_AND_19 = LOGAND(op_RSHIFT_17, SN(32, 0xffff));
	RzILOpPure *op_MUL_22 = MUL(CAST(32, MSB(CAST(16, MSB(op_AND_10), DUP(op_AND_10))), CAST(16, MSB(DUP(op_AND_10)), DUP(op_AND_10))), CAST(32, MSB(CAST(16, MSB(op_AND_19), DUP(op_AND_19))), CAST(16, MSB(DUP(op_AND_19)), DUP(op_AND_19))));
	RzILOpPure *op_ADD_25 = ADD(CAST(64, MSB(READ_REG(pkt, Rx_op, false)), READ_REG(pkt, Rx_op, false)), CAST(64, MSB(op_MUL_22), DUP(op_MUL_22)));
	RzILOpPure *op_RSHIFT_34 = SHIFTRA(DUP(Rs), SN(32, 16));
	RzILOpPure *op_AND_36 = LOGAND(op_RSHIFT_34, SN(32, 0xffff));
	RzILOpPure *op_RSHIFT_42 = SHIFTRA(DUP(Rt), SN(32, 16));
	RzILOpPure *op_AND_44 = LOGAND(op_RSHIFT_42, SN(32, 0xffff));
	RzILOpPure *op_MUL_47 = MUL(CAST(32, MSB(CAST(16, MSB(op_AND_36), DUP(op_AND_36))), CAST(16, MSB(DUP(op_AND_36)), DUP(op_AND_36))), CAST(32, MSB(CAST(16, MSB(op_AND_44), DUP(op_AND_44))), CAST(16, MSB(DUP(op_AND_44)), DUP(op_AND_44))));
	RzILOpPure *op_ADD_50 = ADD(CAST(64, MSB(READ_REG(pkt, Rx_op, false)), READ_REG(pkt, Rx_op, false)), CAST(64, MSB(op_MUL_47), DUP(op_MUL_47)));
	RzILOpPure *op_EQ_51 = EQ(SEXTRACT64(CAST(64, IL_FALSE, op_ADD_25), SN(32, 0), SN(32, 0x20)), op_ADD_50);
	RzILOpPure *op_RSHIFT_78 = SHIFTRA(DUP(Rs), SN(32, 16));
	RzILOpPure *op_AND_80 = LOGAND(op_RSHIFT_78, SN(32, 0xffff));
	RzILOpPure *op_RSHIFT_86 = SHIFTRA(DUP(Rt), SN(32, 16));
	RzILOpPure *op_AND_88 = LOGAND(op_RSHIFT_86, SN(32, 0xffff));
	RzILOpPure *op_MUL_91 = MUL(CAST(32, MSB(CAST(16, MSB(op_AND_80), DUP(op_AND_80))), CAST(16, MSB(DUP(op_AND_80)), DUP(op_AND_80))), CAST(32, MSB(CAST(16, MSB(op_AND_88), DUP(op_AND_88))), CAST(16, MSB(DUP(op_AND_88)), DUP(op_AND_88))));
	RzILOpPure *op_ADD_94 = ADD(CAST(64, MSB(READ_REG(pkt, Rx_op, false)), READ_REG(pkt, Rx_op, false)), CAST(64, MSB(op_MUL_91), DUP(op_MUL_91)));
	RzILOpPure *op_LT_97 = SLT(op_ADD_94, CAST(64, MSB(SN(32, 0)), SN(32, 0)));
	RzILOpPure *op_LSHIFT_102 = SHIFTL0(SN(64, 1), SN(32, 31));
	RzILOpPure *op_NEG_103 = NEG(op_LSHIFT_102);
	RzILOpPure *op_LSHIFT_108 = SHIFTL0(SN(64, 1), SN(32, 31));
	RzILOpPure *op_SUB_111 = SUB(op_LSHIFT_108, CAST(64, MSB(SN(32, 1)), SN(32, 1)));
	RzILOpPure *cond_112 = ITE(op_LT_97, op_NEG_103, op_SUB_111);
	RzILOpEffect *gcc_expr_113 = BRANCH(op_EQ_51, EMPTY(), set_usr_field_call_74);

	// h_tmp332 = HYB(gcc_expr_if ((sextract64(((ut64) ((st64) Rx) + ((st64) ((st32) ((st16) ((Rs >> 0x10) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x10) & 0xffff))))), 0x0, 0x20) == ((st64) Rx) + ((st64) ((st32) ((st16) ((Rs >> 0x10) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x10) & 0xffff)))))) {{}} else {set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, ((ut32) 0x1))}, ((((st64) Rx) + ((st64) ((st32) ((st16) ((Rs >> 0x10) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x10) & 0xffff)))) < ((st64) 0x0)) ? (-(0x1 << 0x1f)) : (0x1 << 0x1f) - ((st64) 0x1)));
	RzILOpEffect *op_ASSIGN_hybrid_tmp_115 = SETL("h_tmp332", cond_112);

	// seq(HYB(gcc_expr_if ((sextract64(((ut64) ((st64) Rx) + ((st64) ( ...;
	RzILOpEffect *seq_116 = SEQN(2, gcc_expr_113, op_ASSIGN_hybrid_tmp_115);

	// Rx = ((st32) ((sextract64(((ut64) ((st64) Rx) + ((st64) ((st32) ((st16) ((Rs >> 0x10) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x10) & 0xffff))))), 0x0, 0x20) == ((st64) Rx) + ((st64) ((st32) ((st16) ((Rs >> 0x10) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x10) & 0xffff))))) ? ((st64) Rx) + ((st64) ((st32) ((st16) ((Rs >> 0x10) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x10) & 0xffff)))) : h_tmp332));
	RzILOpPure *op_RSHIFT_55 = SHIFTRA(DUP(Rs), SN(32, 16));
	RzILOpPure *op_AND_57 = LOGAND(op_RSHIFT_55, SN(32, 0xffff));
	RzILOpPure *op_RSHIFT_63 = SHIFTRA(DUP(Rt), SN(32, 16));
	RzILOpPure *op_AND_65 = LOGAND(op_RSHIFT_63, SN(32, 0xffff));
	RzILOpPure *op_MUL_68 = MUL(CAST(32, MSB(CAST(16, MSB(op_AND_57), DUP(op_AND_57))), CAST(16, MSB(DUP(op_AND_57)), DUP(op_AND_57))), CAST(32, MSB(CAST(16, MSB(op_AND_65), DUP(op_AND_65))), CAST(16, MSB(DUP(op_AND_65)), DUP(op_AND_65))));
	RzILOpPure *op_ADD_71 = ADD(CAST(64, MSB(READ_REG(pkt, Rx_op, false)), READ_REG(pkt, Rx_op, false)), CAST(64, MSB(op_MUL_68), DUP(op_MUL_68)));
	RzILOpPure *cond_117 = ITE(DUP(op_EQ_51), op_ADD_71, VARL("h_tmp332"));
	RzILOpEffect *op_ASSIGN_119 = WRITE_REG(bundle, Rx_op, CAST(32, MSB(cond_117), DUP(cond_117)));

	// seq(seq(HYB(gcc_expr_if ((sextract64(((ut64) ((st64) Rx) + ((st6 ...;
	RzILOpEffect *seq_120 = SEQN(2, seq_116, op_ASSIGN_119);

	RzILOpEffect *instruction_sequence = seq_120;
	return instruction_sequence;
}

// Rx += mpy(Rs.h,Rt.h):<<1:sat
RzILOpEffect *hex_il_op_m2_mpy_acc_sat_hh_s1(HexInsnPktBundle *bundle) {
	const HexInsn *hi = bundle->insn;
	HexPkt *pkt = bundle->pkt;
	// READ
	const HexOp *Rx_op = ISA2REG(hi, 'x', false);

	const HexOp *Rs_op = ISA2REG(hi, 's', false);
	RzILOpPure *Rs = READ_REG(pkt, Rs_op, false);
	const HexOp *Rt_op = ISA2REG(hi, 't', false);
	RzILOpPure *Rt = READ_REG(pkt, Rt_op, false);

	// set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, ((ut32) 0x1));
	RzILOpEffect *set_usr_field_call_80 = hex_set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, CAST(32, IL_FALSE, SN(32, 1)));

	// HYB(gcc_expr_if ((sextract64(((ut64) ((st64) Rx) + (((st64) ((st32) ((st16) ((Rs >> 0x10) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x10) & 0xffff)))) << 0x1)), 0x0, 0x20) == ((st64) Rx) + (((st64) ((st32) ((st16) ((Rs >> 0x10) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x10) & 0xffff)))) << 0x1))) {{}} else {set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, ((ut32) 0x1))}, ((((st64) Rx) + (((st64) ((st32) ((st16) ((Rs >> 0x10) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x10) & 0xffff)))) << 0x1) < ((st64) 0x0)) ? (-(0x1 << 0x1f)) : (0x1 << 0x1f) - ((st64) 0x1)));
	RzILOpPure *op_RSHIFT_8 = SHIFTRA(Rs, SN(32, 16));
	RzILOpPure *op_AND_10 = LOGAND(op_RSHIFT_8, SN(32, 0xffff));
	RzILOpPure *op_RSHIFT_17 = SHIFTRA(Rt, SN(32, 16));
	RzILOpPure *op_AND_19 = LOGAND(op_RSHIFT_17, SN(32, 0xffff));
	RzILOpPure *op_MUL_22 = MUL(CAST(32, MSB(CAST(16, MSB(op_AND_10), DUP(op_AND_10))), CAST(16, MSB(DUP(op_AND_10)), DUP(op_AND_10))), CAST(32, MSB(CAST(16, MSB(op_AND_19), DUP(op_AND_19))), CAST(16, MSB(DUP(op_AND_19)), DUP(op_AND_19))));
	RzILOpPure *op_LSHIFT_25 = SHIFTL0(CAST(64, MSB(op_MUL_22), DUP(op_MUL_22)), SN(32, 1));
	RzILOpPure *op_ADD_27 = ADD(CAST(64, MSB(READ_REG(pkt, Rx_op, false)), READ_REG(pkt, Rx_op, false)), op_LSHIFT_25);
	RzILOpPure *op_RSHIFT_36 = SHIFTRA(DUP(Rs), SN(32, 16));
	RzILOpPure *op_AND_38 = LOGAND(op_RSHIFT_36, SN(32, 0xffff));
	RzILOpPure *op_RSHIFT_44 = SHIFTRA(DUP(Rt), SN(32, 16));
	RzILOpPure *op_AND_46 = LOGAND(op_RSHIFT_44, SN(32, 0xffff));
	RzILOpPure *op_MUL_49 = MUL(CAST(32, MSB(CAST(16, MSB(op_AND_38), DUP(op_AND_38))), CAST(16, MSB(DUP(op_AND_38)), DUP(op_AND_38))), CAST(32, MSB(CAST(16, MSB(op_AND_46), DUP(op_AND_46))), CAST(16, MSB(DUP(op_AND_46)), DUP(op_AND_46))));
	RzILOpPure *op_LSHIFT_52 = SHIFTL0(CAST(64, MSB(op_MUL_49), DUP(op_MUL_49)), SN(32, 1));
	RzILOpPure *op_ADD_54 = ADD(CAST(64, MSB(READ_REG(pkt, Rx_op, false)), READ_REG(pkt, Rx_op, false)), op_LSHIFT_52);
	RzILOpPure *op_EQ_55 = EQ(SEXTRACT64(CAST(64, IL_FALSE, op_ADD_27), SN(32, 0), SN(32, 0x20)), op_ADD_54);
	RzILOpPure *op_RSHIFT_84 = SHIFTRA(DUP(Rs), SN(32, 16));
	RzILOpPure *op_AND_86 = LOGAND(op_RSHIFT_84, SN(32, 0xffff));
	RzILOpPure *op_RSHIFT_92 = SHIFTRA(DUP(Rt), SN(32, 16));
	RzILOpPure *op_AND_94 = LOGAND(op_RSHIFT_92, SN(32, 0xffff));
	RzILOpPure *op_MUL_97 = MUL(CAST(32, MSB(CAST(16, MSB(op_AND_86), DUP(op_AND_86))), CAST(16, MSB(DUP(op_AND_86)), DUP(op_AND_86))), CAST(32, MSB(CAST(16, MSB(op_AND_94), DUP(op_AND_94))), CAST(16, MSB(DUP(op_AND_94)), DUP(op_AND_94))));
	RzILOpPure *op_LSHIFT_100 = SHIFTL0(CAST(64, MSB(op_MUL_97), DUP(op_MUL_97)), SN(32, 1));
	RzILOpPure *op_ADD_102 = ADD(CAST(64, MSB(READ_REG(pkt, Rx_op, false)), READ_REG(pkt, Rx_op, false)), op_LSHIFT_100);
	RzILOpPure *op_LT_105 = SLT(op_ADD_102, CAST(64, MSB(SN(32, 0)), SN(32, 0)));
	RzILOpPure *op_LSHIFT_110 = SHIFTL0(SN(64, 1), SN(32, 31));
	RzILOpPure *op_NEG_111 = NEG(op_LSHIFT_110);
	RzILOpPure *op_LSHIFT_116 = SHIFTL0(SN(64, 1), SN(32, 31));
	RzILOpPure *op_SUB_119 = SUB(op_LSHIFT_116, CAST(64, MSB(SN(32, 1)), SN(32, 1)));
	RzILOpPure *cond_120 = ITE(op_LT_105, op_NEG_111, op_SUB_119);
	RzILOpEffect *gcc_expr_121 = BRANCH(op_EQ_55, EMPTY(), set_usr_field_call_80);

	// h_tmp333 = HYB(gcc_expr_if ((sextract64(((ut64) ((st64) Rx) + (((st64) ((st32) ((st16) ((Rs >> 0x10) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x10) & 0xffff)))) << 0x1)), 0x0, 0x20) == ((st64) Rx) + (((st64) ((st32) ((st16) ((Rs >> 0x10) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x10) & 0xffff)))) << 0x1))) {{}} else {set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, ((ut32) 0x1))}, ((((st64) Rx) + (((st64) ((st32) ((st16) ((Rs >> 0x10) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x10) & 0xffff)))) << 0x1) < ((st64) 0x0)) ? (-(0x1 << 0x1f)) : (0x1 << 0x1f) - ((st64) 0x1)));
	RzILOpEffect *op_ASSIGN_hybrid_tmp_123 = SETL("h_tmp333", cond_120);

	// seq(HYB(gcc_expr_if ((sextract64(((ut64) ((st64) Rx) + (((st64)  ...;
	RzILOpEffect *seq_124 = SEQN(2, gcc_expr_121, op_ASSIGN_hybrid_tmp_123);

	// Rx = ((st32) ((sextract64(((ut64) ((st64) Rx) + (((st64) ((st32) ((st16) ((Rs >> 0x10) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x10) & 0xffff)))) << 0x1)), 0x0, 0x20) == ((st64) Rx) + (((st64) ((st32) ((st16) ((Rs >> 0x10) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x10) & 0xffff)))) << 0x1)) ? ((st64) Rx) + (((st64) ((st32) ((st16) ((Rs >> 0x10) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x10) & 0xffff)))) << 0x1) : h_tmp333));
	RzILOpPure *op_RSHIFT_59 = SHIFTRA(DUP(Rs), SN(32, 16));
	RzILOpPure *op_AND_61 = LOGAND(op_RSHIFT_59, SN(32, 0xffff));
	RzILOpPure *op_RSHIFT_67 = SHIFTRA(DUP(Rt), SN(32, 16));
	RzILOpPure *op_AND_69 = LOGAND(op_RSHIFT_67, SN(32, 0xffff));
	RzILOpPure *op_MUL_72 = MUL(CAST(32, MSB(CAST(16, MSB(op_AND_61), DUP(op_AND_61))), CAST(16, MSB(DUP(op_AND_61)), DUP(op_AND_61))), CAST(32, MSB(CAST(16, MSB(op_AND_69), DUP(op_AND_69))), CAST(16, MSB(DUP(op_AND_69)), DUP(op_AND_69))));
	RzILOpPure *op_LSHIFT_75 = SHIFTL0(CAST(64, MSB(op_MUL_72), DUP(op_MUL_72)), SN(32, 1));
	RzILOpPure *op_ADD_77 = ADD(CAST(64, MSB(READ_REG(pkt, Rx_op, false)), READ_REG(pkt, Rx_op, false)), op_LSHIFT_75);
	RzILOpPure *cond_125 = ITE(DUP(op_EQ_55), op_ADD_77, VARL("h_tmp333"));
	RzILOpEffect *op_ASSIGN_127 = WRITE_REG(bundle, Rx_op, CAST(32, MSB(cond_125), DUP(cond_125)));

	// seq(seq(HYB(gcc_expr_if ((sextract64(((ut64) ((st64) Rx) + (((st ...;
	RzILOpEffect *seq_128 = SEQN(2, seq_124, op_ASSIGN_127);

	RzILOpEffect *instruction_sequence = seq_128;
	return instruction_sequence;
}

// Rx += mpy(Rs.h,Rt.l):sat
RzILOpEffect *hex_il_op_m2_mpy_acc_sat_hl_s0(HexInsnPktBundle *bundle) {
	const HexInsn *hi = bundle->insn;
	HexPkt *pkt = bundle->pkt;
	// READ
	const HexOp *Rx_op = ISA2REG(hi, 'x', false);

	const HexOp *Rs_op = ISA2REG(hi, 's', false);
	RzILOpPure *Rs = READ_REG(pkt, Rs_op, false);
	const HexOp *Rt_op = ISA2REG(hi, 't', false);
	RzILOpPure *Rt = READ_REG(pkt, Rt_op, false);

	// set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, ((ut32) 0x1));
	RzILOpEffect *set_usr_field_call_74 = hex_set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, CAST(32, IL_FALSE, SN(32, 1)));

	// HYB(gcc_expr_if ((sextract64(((ut64) ((st64) Rx) + ((st64) ((st32) ((st16) ((Rs >> 0x10) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x0) & 0xffff))))), 0x0, 0x20) == ((st64) Rx) + ((st64) ((st32) ((st16) ((Rs >> 0x10) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x0) & 0xffff)))))) {{}} else {set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, ((ut32) 0x1))}, ((((st64) Rx) + ((st64) ((st32) ((st16) ((Rs >> 0x10) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x0) & 0xffff)))) < ((st64) 0x0)) ? (-(0x1 << 0x1f)) : (0x1 << 0x1f) - ((st64) 0x1)));
	RzILOpPure *op_RSHIFT_8 = SHIFTRA(Rs, SN(32, 16));
	RzILOpPure *op_AND_10 = LOGAND(op_RSHIFT_8, SN(32, 0xffff));
	RzILOpPure *op_RSHIFT_17 = SHIFTRA(Rt, SN(32, 0));
	RzILOpPure *op_AND_19 = LOGAND(op_RSHIFT_17, SN(32, 0xffff));
	RzILOpPure *op_MUL_22 = MUL(CAST(32, MSB(CAST(16, MSB(op_AND_10), DUP(op_AND_10))), CAST(16, MSB(DUP(op_AND_10)), DUP(op_AND_10))), CAST(32, MSB(CAST(16, MSB(op_AND_19), DUP(op_AND_19))), CAST(16, MSB(DUP(op_AND_19)), DUP(op_AND_19))));
	RzILOpPure *op_ADD_25 = ADD(CAST(64, MSB(READ_REG(pkt, Rx_op, false)), READ_REG(pkt, Rx_op, false)), CAST(64, MSB(op_MUL_22), DUP(op_MUL_22)));
	RzILOpPure *op_RSHIFT_34 = SHIFTRA(DUP(Rs), SN(32, 16));
	RzILOpPure *op_AND_36 = LOGAND(op_RSHIFT_34, SN(32, 0xffff));
	RzILOpPure *op_RSHIFT_42 = SHIFTRA(DUP(Rt), SN(32, 0));
	RzILOpPure *op_AND_44 = LOGAND(op_RSHIFT_42, SN(32, 0xffff));
	RzILOpPure *op_MUL_47 = MUL(CAST(32, MSB(CAST(16, MSB(op_AND_36), DUP(op_AND_36))), CAST(16, MSB(DUP(op_AND_36)), DUP(op_AND_36))), CAST(32, MSB(CAST(16, MSB(op_AND_44), DUP(op_AND_44))), CAST(16, MSB(DUP(op_AND_44)), DUP(op_AND_44))));
	RzILOpPure *op_ADD_50 = ADD(CAST(64, MSB(READ_REG(pkt, Rx_op, false)), READ_REG(pkt, Rx_op, false)), CAST(64, MSB(op_MUL_47), DUP(op_MUL_47)));
	RzILOpPure *op_EQ_51 = EQ(SEXTRACT64(CAST(64, IL_FALSE, op_ADD_25), SN(32, 0), SN(32, 0x20)), op_ADD_50);
	RzILOpPure *op_RSHIFT_78 = SHIFTRA(DUP(Rs), SN(32, 16));
	RzILOpPure *op_AND_80 = LOGAND(op_RSHIFT_78, SN(32, 0xffff));
	RzILOpPure *op_RSHIFT_86 = SHIFTRA(DUP(Rt), SN(32, 0));
	RzILOpPure *op_AND_88 = LOGAND(op_RSHIFT_86, SN(32, 0xffff));
	RzILOpPure *op_MUL_91 = MUL(CAST(32, MSB(CAST(16, MSB(op_AND_80), DUP(op_AND_80))), CAST(16, MSB(DUP(op_AND_80)), DUP(op_AND_80))), CAST(32, MSB(CAST(16, MSB(op_AND_88), DUP(op_AND_88))), CAST(16, MSB(DUP(op_AND_88)), DUP(op_AND_88))));
	RzILOpPure *op_ADD_94 = ADD(CAST(64, MSB(READ_REG(pkt, Rx_op, false)), READ_REG(pkt, Rx_op, false)), CAST(64, MSB(op_MUL_91), DUP(op_MUL_91)));
	RzILOpPure *op_LT_97 = SLT(op_ADD_94, CAST(64, MSB(SN(32, 0)), SN(32, 0)));
	RzILOpPure *op_LSHIFT_102 = SHIFTL0(SN(64, 1), SN(32, 31));
	RzILOpPure *op_NEG_103 = NEG(op_LSHIFT_102);
	RzILOpPure *op_LSHIFT_108 = SHIFTL0(SN(64, 1), SN(32, 31));
	RzILOpPure *op_SUB_111 = SUB(op_LSHIFT_108, CAST(64, MSB(SN(32, 1)), SN(32, 1)));
	RzILOpPure *cond_112 = ITE(op_LT_97, op_NEG_103, op_SUB_111);
	RzILOpEffect *gcc_expr_113 = BRANCH(op_EQ_51, EMPTY(), set_usr_field_call_74);

	// h_tmp334 = HYB(gcc_expr_if ((sextract64(((ut64) ((st64) Rx) + ((st64) ((st32) ((st16) ((Rs >> 0x10) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x0) & 0xffff))))), 0x0, 0x20) == ((st64) Rx) + ((st64) ((st32) ((st16) ((Rs >> 0x10) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x0) & 0xffff)))))) {{}} else {set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, ((ut32) 0x1))}, ((((st64) Rx) + ((st64) ((st32) ((st16) ((Rs >> 0x10) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x0) & 0xffff)))) < ((st64) 0x0)) ? (-(0x1 << 0x1f)) : (0x1 << 0x1f) - ((st64) 0x1)));
	RzILOpEffect *op_ASSIGN_hybrid_tmp_115 = SETL("h_tmp334", cond_112);

	// seq(HYB(gcc_expr_if ((sextract64(((ut64) ((st64) Rx) + ((st64) ( ...;
	RzILOpEffect *seq_116 = SEQN(2, gcc_expr_113, op_ASSIGN_hybrid_tmp_115);

	// Rx = ((st32) ((sextract64(((ut64) ((st64) Rx) + ((st64) ((st32) ((st16) ((Rs >> 0x10) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x0) & 0xffff))))), 0x0, 0x20) == ((st64) Rx) + ((st64) ((st32) ((st16) ((Rs >> 0x10) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x0) & 0xffff))))) ? ((st64) Rx) + ((st64) ((st32) ((st16) ((Rs >> 0x10) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x0) & 0xffff)))) : h_tmp334));
	RzILOpPure *op_RSHIFT_55 = SHIFTRA(DUP(Rs), SN(32, 16));
	RzILOpPure *op_AND_57 = LOGAND(op_RSHIFT_55, SN(32, 0xffff));
	RzILOpPure *op_RSHIFT_63 = SHIFTRA(DUP(Rt), SN(32, 0));
	RzILOpPure *op_AND_65 = LOGAND(op_RSHIFT_63, SN(32, 0xffff));
	RzILOpPure *op_MUL_68 = MUL(CAST(32, MSB(CAST(16, MSB(op_AND_57), DUP(op_AND_57))), CAST(16, MSB(DUP(op_AND_57)), DUP(op_AND_57))), CAST(32, MSB(CAST(16, MSB(op_AND_65), DUP(op_AND_65))), CAST(16, MSB(DUP(op_AND_65)), DUP(op_AND_65))));
	RzILOpPure *op_ADD_71 = ADD(CAST(64, MSB(READ_REG(pkt, Rx_op, false)), READ_REG(pkt, Rx_op, false)), CAST(64, MSB(op_MUL_68), DUP(op_MUL_68)));
	RzILOpPure *cond_117 = ITE(DUP(op_EQ_51), op_ADD_71, VARL("h_tmp334"));
	RzILOpEffect *op_ASSIGN_119 = WRITE_REG(bundle, Rx_op, CAST(32, MSB(cond_117), DUP(cond_117)));

	// seq(seq(HYB(gcc_expr_if ((sextract64(((ut64) ((st64) Rx) + ((st6 ...;
	RzILOpEffect *seq_120 = SEQN(2, seq_116, op_ASSIGN_119);

	RzILOpEffect *instruction_sequence = seq_120;
	return instruction_sequence;
}

// Rx += mpy(Rs.h,Rt.l):<<1:sat
RzILOpEffect *hex_il_op_m2_mpy_acc_sat_hl_s1(HexInsnPktBundle *bundle) {
	const HexInsn *hi = bundle->insn;
	HexPkt *pkt = bundle->pkt;
	// READ
	const HexOp *Rx_op = ISA2REG(hi, 'x', false);

	const HexOp *Rs_op = ISA2REG(hi, 's', false);
	RzILOpPure *Rs = READ_REG(pkt, Rs_op, false);
	const HexOp *Rt_op = ISA2REG(hi, 't', false);
	RzILOpPure *Rt = READ_REG(pkt, Rt_op, false);

	// set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, ((ut32) 0x1));
	RzILOpEffect *set_usr_field_call_80 = hex_set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, CAST(32, IL_FALSE, SN(32, 1)));

	// HYB(gcc_expr_if ((sextract64(((ut64) ((st64) Rx) + (((st64) ((st32) ((st16) ((Rs >> 0x10) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x0) & 0xffff)))) << 0x1)), 0x0, 0x20) == ((st64) Rx) + (((st64) ((st32) ((st16) ((Rs >> 0x10) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x0) & 0xffff)))) << 0x1))) {{}} else {set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, ((ut32) 0x1))}, ((((st64) Rx) + (((st64) ((st32) ((st16) ((Rs >> 0x10) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x0) & 0xffff)))) << 0x1) < ((st64) 0x0)) ? (-(0x1 << 0x1f)) : (0x1 << 0x1f) - ((st64) 0x1)));
	RzILOpPure *op_RSHIFT_8 = SHIFTRA(Rs, SN(32, 16));
	RzILOpPure *op_AND_10 = LOGAND(op_RSHIFT_8, SN(32, 0xffff));
	RzILOpPure *op_RSHIFT_17 = SHIFTRA(Rt, SN(32, 0));
	RzILOpPure *op_AND_19 = LOGAND(op_RSHIFT_17, SN(32, 0xffff));
	RzILOpPure *op_MUL_22 = MUL(CAST(32, MSB(CAST(16, MSB(op_AND_10), DUP(op_AND_10))), CAST(16, MSB(DUP(op_AND_10)), DUP(op_AND_10))), CAST(32, MSB(CAST(16, MSB(op_AND_19), DUP(op_AND_19))), CAST(16, MSB(DUP(op_AND_19)), DUP(op_AND_19))));
	RzILOpPure *op_LSHIFT_25 = SHIFTL0(CAST(64, MSB(op_MUL_22), DUP(op_MUL_22)), SN(32, 1));
	RzILOpPure *op_ADD_27 = ADD(CAST(64, MSB(READ_REG(pkt, Rx_op, false)), READ_REG(pkt, Rx_op, false)), op_LSHIFT_25);
	RzILOpPure *op_RSHIFT_36 = SHIFTRA(DUP(Rs), SN(32, 16));
	RzILOpPure *op_AND_38 = LOGAND(op_RSHIFT_36, SN(32, 0xffff));
	RzILOpPure *op_RSHIFT_44 = SHIFTRA(DUP(Rt), SN(32, 0));
	RzILOpPure *op_AND_46 = LOGAND(op_RSHIFT_44, SN(32, 0xffff));
	RzILOpPure *op_MUL_49 = MUL(CAST(32, MSB(CAST(16, MSB(op_AND_38), DUP(op_AND_38))), CAST(16, MSB(DUP(op_AND_38)), DUP(op_AND_38))), CAST(32, MSB(CAST(16, MSB(op_AND_46), DUP(op_AND_46))), CAST(16, MSB(DUP(op_AND_46)), DUP(op_AND_46))));
	RzILOpPure *op_LSHIFT_52 = SHIFTL0(CAST(64, MSB(op_MUL_49), DUP(op_MUL_49)), SN(32, 1));
	RzILOpPure *op_ADD_54 = ADD(CAST(64, MSB(READ_REG(pkt, Rx_op, false)), READ_REG(pkt, Rx_op, false)), op_LSHIFT_52);
	RzILOpPure *op_EQ_55 = EQ(SEXTRACT64(CAST(64, IL_FALSE, op_ADD_27), SN(32, 0), SN(32, 0x20)), op_ADD_54);
	RzILOpPure *op_RSHIFT_84 = SHIFTRA(DUP(Rs), SN(32, 16));
	RzILOpPure *op_AND_86 = LOGAND(op_RSHIFT_84, SN(32, 0xffff));
	RzILOpPure *op_RSHIFT_92 = SHIFTRA(DUP(Rt), SN(32, 0));
	RzILOpPure *op_AND_94 = LOGAND(op_RSHIFT_92, SN(32, 0xffff));
	RzILOpPure *op_MUL_97 = MUL(CAST(32, MSB(CAST(16, MSB(op_AND_86), DUP(op_AND_86))), CAST(16, MSB(DUP(op_AND_86)), DUP(op_AND_86))), CAST(32, MSB(CAST(16, MSB(op_AND_94), DUP(op_AND_94))), CAST(16, MSB(DUP(op_AND_94)), DUP(op_AND_94))));
	RzILOpPure *op_LSHIFT_100 = SHIFTL0(CAST(64, MSB(op_MUL_97), DUP(op_MUL_97)), SN(32, 1));
	RzILOpPure *op_ADD_102 = ADD(CAST(64, MSB(READ_REG(pkt, Rx_op, false)), READ_REG(pkt, Rx_op, false)), op_LSHIFT_100);
	RzILOpPure *op_LT_105 = SLT(op_ADD_102, CAST(64, MSB(SN(32, 0)), SN(32, 0)));
	RzILOpPure *op_LSHIFT_110 = SHIFTL0(SN(64, 1), SN(32, 31));
	RzILOpPure *op_NEG_111 = NEG(op_LSHIFT_110);
	RzILOpPure *op_LSHIFT_116 = SHIFTL0(SN(64, 1), SN(32, 31));
	RzILOpPure *op_SUB_119 = SUB(op_LSHIFT_116, CAST(64, MSB(SN(32, 1)), SN(32, 1)));
	RzILOpPure *cond_120 = ITE(op_LT_105, op_NEG_111, op_SUB_119);
	RzILOpEffect *gcc_expr_121 = BRANCH(op_EQ_55, EMPTY(), set_usr_field_call_80);

	// h_tmp335 = HYB(gcc_expr_if ((sextract64(((ut64) ((st64) Rx) + (((st64) ((st32) ((st16) ((Rs >> 0x10) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x0) & 0xffff)))) << 0x1)), 0x0, 0x20) == ((st64) Rx) + (((st64) ((st32) ((st16) ((Rs >> 0x10) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x0) & 0xffff)))) << 0x1))) {{}} else {set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, ((ut32) 0x1))}, ((((st64) Rx) + (((st64) ((st32) ((st16) ((Rs >> 0x10) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x0) & 0xffff)))) << 0x1) < ((st64) 0x0)) ? (-(0x1 << 0x1f)) : (0x1 << 0x1f) - ((st64) 0x1)));
	RzILOpEffect *op_ASSIGN_hybrid_tmp_123 = SETL("h_tmp335", cond_120);

	// seq(HYB(gcc_expr_if ((sextract64(((ut64) ((st64) Rx) + (((st64)  ...;
	RzILOpEffect *seq_124 = SEQN(2, gcc_expr_121, op_ASSIGN_hybrid_tmp_123);

	// Rx = ((st32) ((sextract64(((ut64) ((st64) Rx) + (((st64) ((st32) ((st16) ((Rs >> 0x10) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x0) & 0xffff)))) << 0x1)), 0x0, 0x20) == ((st64) Rx) + (((st64) ((st32) ((st16) ((Rs >> 0x10) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x0) & 0xffff)))) << 0x1)) ? ((st64) Rx) + (((st64) ((st32) ((st16) ((Rs >> 0x10) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x0) & 0xffff)))) << 0x1) : h_tmp335));
	RzILOpPure *op_RSHIFT_59 = SHIFTRA(DUP(Rs), SN(32, 16));
	RzILOpPure *op_AND_61 = LOGAND(op_RSHIFT_59, SN(32, 0xffff));
	RzILOpPure *op_RSHIFT_67 = SHIFTRA(DUP(Rt), SN(32, 0));
	RzILOpPure *op_AND_69 = LOGAND(op_RSHIFT_67, SN(32, 0xffff));
	RzILOpPure *op_MUL_72 = MUL(CAST(32, MSB(CAST(16, MSB(op_AND_61), DUP(op_AND_61))), CAST(16, MSB(DUP(op_AND_61)), DUP(op_AND_61))), CAST(32, MSB(CAST(16, MSB(op_AND_69), DUP(op_AND_69))), CAST(16, MSB(DUP(op_AND_69)), DUP(op_AND_69))));
	RzILOpPure *op_LSHIFT_75 = SHIFTL0(CAST(64, MSB(op_MUL_72), DUP(op_MUL_72)), SN(32, 1));
	RzILOpPure *op_ADD_77 = ADD(CAST(64, MSB(READ_REG(pkt, Rx_op, false)), READ_REG(pkt, Rx_op, false)), op_LSHIFT_75);
	RzILOpPure *cond_125 = ITE(DUP(op_EQ_55), op_ADD_77, VARL("h_tmp335"));
	RzILOpEffect *op_ASSIGN_127 = WRITE_REG(bundle, Rx_op, CAST(32, MSB(cond_125), DUP(cond_125)));

	// seq(seq(HYB(gcc_expr_if ((sextract64(((ut64) ((st64) Rx) + (((st ...;
	RzILOpEffect *seq_128 = SEQN(2, seq_124, op_ASSIGN_127);

	RzILOpEffect *instruction_sequence = seq_128;
	return instruction_sequence;
}

// Rx += mpy(Rs.l,Rt.h):sat
RzILOpEffect *hex_il_op_m2_mpy_acc_sat_lh_s0(HexInsnPktBundle *bundle) {
	const HexInsn *hi = bundle->insn;
	HexPkt *pkt = bundle->pkt;
	// READ
	const HexOp *Rx_op = ISA2REG(hi, 'x', false);

	const HexOp *Rs_op = ISA2REG(hi, 's', false);
	RzILOpPure *Rs = READ_REG(pkt, Rs_op, false);
	const HexOp *Rt_op = ISA2REG(hi, 't', false);
	RzILOpPure *Rt = READ_REG(pkt, Rt_op, false);

	// set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, ((ut32) 0x1));
	RzILOpEffect *set_usr_field_call_74 = hex_set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, CAST(32, IL_FALSE, SN(32, 1)));

	// HYB(gcc_expr_if ((sextract64(((ut64) ((st64) Rx) + ((st64) ((st32) ((st16) ((Rs >> 0x0) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x10) & 0xffff))))), 0x0, 0x20) == ((st64) Rx) + ((st64) ((st32) ((st16) ((Rs >> 0x0) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x10) & 0xffff)))))) {{}} else {set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, ((ut32) 0x1))}, ((((st64) Rx) + ((st64) ((st32) ((st16) ((Rs >> 0x0) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x10) & 0xffff)))) < ((st64) 0x0)) ? (-(0x1 << 0x1f)) : (0x1 << 0x1f) - ((st64) 0x1)));
	RzILOpPure *op_RSHIFT_8 = SHIFTRA(Rs, SN(32, 0));
	RzILOpPure *op_AND_10 = LOGAND(op_RSHIFT_8, SN(32, 0xffff));
	RzILOpPure *op_RSHIFT_17 = SHIFTRA(Rt, SN(32, 16));
	RzILOpPure *op_AND_19 = LOGAND(op_RSHIFT_17, SN(32, 0xffff));
	RzILOpPure *op_MUL_22 = MUL(CAST(32, MSB(CAST(16, MSB(op_AND_10), DUP(op_AND_10))), CAST(16, MSB(DUP(op_AND_10)), DUP(op_AND_10))), CAST(32, MSB(CAST(16, MSB(op_AND_19), DUP(op_AND_19))), CAST(16, MSB(DUP(op_AND_19)), DUP(op_AND_19))));
	RzILOpPure *op_ADD_25 = ADD(CAST(64, MSB(READ_REG(pkt, Rx_op, false)), READ_REG(pkt, Rx_op, false)), CAST(64, MSB(op_MUL_22), DUP(op_MUL_22)));
	RzILOpPure *op_RSHIFT_34 = SHIFTRA(DUP(Rs), SN(32, 0));
	RzILOpPure *op_AND_36 = LOGAND(op_RSHIFT_34, SN(32, 0xffff));
	RzILOpPure *op_RSHIFT_42 = SHIFTRA(DUP(Rt), SN(32, 16));
	RzILOpPure *op_AND_44 = LOGAND(op_RSHIFT_42, SN(32, 0xffff));
	RzILOpPure *op_MUL_47 = MUL(CAST(32, MSB(CAST(16, MSB(op_AND_36), DUP(op_AND_36))), CAST(16, MSB(DUP(op_AND_36)), DUP(op_AND_36))), CAST(32, MSB(CAST(16, MSB(op_AND_44), DUP(op_AND_44))), CAST(16, MSB(DUP(op_AND_44)), DUP(op_AND_44))));
	RzILOpPure *op_ADD_50 = ADD(CAST(64, MSB(READ_REG(pkt, Rx_op, false)), READ_REG(pkt, Rx_op, false)), CAST(64, MSB(op_MUL_47), DUP(op_MUL_47)));
	RzILOpPure *op_EQ_51 = EQ(SEXTRACT64(CAST(64, IL_FALSE, op_ADD_25), SN(32, 0), SN(32, 0x20)), op_ADD_50);
	RzILOpPure *op_RSHIFT_78 = SHIFTRA(DUP(Rs), SN(32, 0));
	RzILOpPure *op_AND_80 = LOGAND(op_RSHIFT_78, SN(32, 0xffff));
	RzILOpPure *op_RSHIFT_86 = SHIFTRA(DUP(Rt), SN(32, 16));
	RzILOpPure *op_AND_88 = LOGAND(op_RSHIFT_86, SN(32, 0xffff));
	RzILOpPure *op_MUL_91 = MUL(CAST(32, MSB(CAST(16, MSB(op_AND_80), DUP(op_AND_80))), CAST(16, MSB(DUP(op_AND_80)), DUP(op_AND_80))), CAST(32, MSB(CAST(16, MSB(op_AND_88), DUP(op_AND_88))), CAST(16, MSB(DUP(op_AND_88)), DUP(op_AND_88))));
	RzILOpPure *op_ADD_94 = ADD(CAST(64, MSB(READ_REG(pkt, Rx_op, false)), READ_REG(pkt, Rx_op, false)), CAST(64, MSB(op_MUL_91), DUP(op_MUL_91)));
	RzILOpPure *op_LT_97 = SLT(op_ADD_94, CAST(64, MSB(SN(32, 0)), SN(32, 0)));
	RzILOpPure *op_LSHIFT_102 = SHIFTL0(SN(64, 1), SN(32, 31));
	RzILOpPure *op_NEG_103 = NEG(op_LSHIFT_102);
	RzILOpPure *op_LSHIFT_108 = SHIFTL0(SN(64, 1), SN(32, 31));
	RzILOpPure *op_SUB_111 = SUB(op_LSHIFT_108, CAST(64, MSB(SN(32, 1)), SN(32, 1)));
	RzILOpPure *cond_112 = ITE(op_LT_97, op_NEG_103, op_SUB_111);
	RzILOpEffect *gcc_expr_113 = BRANCH(op_EQ_51, EMPTY(), set_usr_field_call_74);

	// h_tmp336 = HYB(gcc_expr_if ((sextract64(((ut64) ((st64) Rx) + ((st64) ((st32) ((st16) ((Rs >> 0x0) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x10) & 0xffff))))), 0x0, 0x20) == ((st64) Rx) + ((st64) ((st32) ((st16) ((Rs >> 0x0) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x10) & 0xffff)))))) {{}} else {set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, ((ut32) 0x1))}, ((((st64) Rx) + ((st64) ((st32) ((st16) ((Rs >> 0x0) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x10) & 0xffff)))) < ((st64) 0x0)) ? (-(0x1 << 0x1f)) : (0x1 << 0x1f) - ((st64) 0x1)));
	RzILOpEffect *op_ASSIGN_hybrid_tmp_115 = SETL("h_tmp336", cond_112);

	// seq(HYB(gcc_expr_if ((sextract64(((ut64) ((st64) Rx) + ((st64) ( ...;
	RzILOpEffect *seq_116 = SEQN(2, gcc_expr_113, op_ASSIGN_hybrid_tmp_115);

	// Rx = ((st32) ((sextract64(((ut64) ((st64) Rx) + ((st64) ((st32) ((st16) ((Rs >> 0x0) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x10) & 0xffff))))), 0x0, 0x20) == ((st64) Rx) + ((st64) ((st32) ((st16) ((Rs >> 0x0) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x10) & 0xffff))))) ? ((st64) Rx) + ((st64) ((st32) ((st16) ((Rs >> 0x0) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x10) & 0xffff)))) : h_tmp336));
	RzILOpPure *op_RSHIFT_55 = SHIFTRA(DUP(Rs), SN(32, 0));
	RzILOpPure *op_AND_57 = LOGAND(op_RSHIFT_55, SN(32, 0xffff));
	RzILOpPure *op_RSHIFT_63 = SHIFTRA(DUP(Rt), SN(32, 16));
	RzILOpPure *op_AND_65 = LOGAND(op_RSHIFT_63, SN(32, 0xffff));
	RzILOpPure *op_MUL_68 = MUL(CAST(32, MSB(CAST(16, MSB(op_AND_57), DUP(op_AND_57))), CAST(16, MSB(DUP(op_AND_57)), DUP(op_AND_57))), CAST(32, MSB(CAST(16, MSB(op_AND_65), DUP(op_AND_65))), CAST(16, MSB(DUP(op_AND_65)), DUP(op_AND_65))));
	RzILOpPure *op_ADD_71 = ADD(CAST(64, MSB(READ_REG(pkt, Rx_op, false)), READ_REG(pkt, Rx_op, false)), CAST(64, MSB(op_MUL_68), DUP(op_MUL_68)));
	RzILOpPure *cond_117 = ITE(DUP(op_EQ_51), op_ADD_71, VARL("h_tmp336"));
	RzILOpEffect *op_ASSIGN_119 = WRITE_REG(bundle, Rx_op, CAST(32, MSB(cond_117), DUP(cond_117)));

	// seq(seq(HYB(gcc_expr_if ((sextract64(((ut64) ((st64) Rx) + ((st6 ...;
	RzILOpEffect *seq_120 = SEQN(2, seq_116, op_ASSIGN_119);

	RzILOpEffect *instruction_sequence = seq_120;
	return instruction_sequence;
}

// Rx += mpy(Rs.l,Rt.h):<<1:sat
RzILOpEffect *hex_il_op_m2_mpy_acc_sat_lh_s1(HexInsnPktBundle *bundle) {
	const HexInsn *hi = bundle->insn;
	HexPkt *pkt = bundle->pkt;
	// READ
	const HexOp *Rx_op = ISA2REG(hi, 'x', false);

	const HexOp *Rs_op = ISA2REG(hi, 's', false);
	RzILOpPure *Rs = READ_REG(pkt, Rs_op, false);
	const HexOp *Rt_op = ISA2REG(hi, 't', false);
	RzILOpPure *Rt = READ_REG(pkt, Rt_op, false);

	// set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, ((ut32) 0x1));
	RzILOpEffect *set_usr_field_call_80 = hex_set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, CAST(32, IL_FALSE, SN(32, 1)));

	// HYB(gcc_expr_if ((sextract64(((ut64) ((st64) Rx) + (((st64) ((st32) ((st16) ((Rs >> 0x0) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x10) & 0xffff)))) << 0x1)), 0x0, 0x20) == ((st64) Rx) + (((st64) ((st32) ((st16) ((Rs >> 0x0) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x10) & 0xffff)))) << 0x1))) {{}} else {set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, ((ut32) 0x1))}, ((((st64) Rx) + (((st64) ((st32) ((st16) ((Rs >> 0x0) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x10) & 0xffff)))) << 0x1) < ((st64) 0x0)) ? (-(0x1 << 0x1f)) : (0x1 << 0x1f) - ((st64) 0x1)));
	RzILOpPure *op_RSHIFT_8 = SHIFTRA(Rs, SN(32, 0));
	RzILOpPure *op_AND_10 = LOGAND(op_RSHIFT_8, SN(32, 0xffff));
	RzILOpPure *op_RSHIFT_17 = SHIFTRA(Rt, SN(32, 16));
	RzILOpPure *op_AND_19 = LOGAND(op_RSHIFT_17, SN(32, 0xffff));
	RzILOpPure *op_MUL_22 = MUL(CAST(32, MSB(CAST(16, MSB(op_AND_10), DUP(op_AND_10))), CAST(16, MSB(DUP(op_AND_10)), DUP(op_AND_10))), CAST(32, MSB(CAST(16, MSB(op_AND_19), DUP(op_AND_19))), CAST(16, MSB(DUP(op_AND_19)), DUP(op_AND_19))));
	RzILOpPure *op_LSHIFT_25 = SHIFTL0(CAST(64, MSB(op_MUL_22), DUP(op_MUL_22)), SN(32, 1));
	RzILOpPure *op_ADD_27 = ADD(CAST(64, MSB(READ_REG(pkt, Rx_op, false)), READ_REG(pkt, Rx_op, false)), op_LSHIFT_25);
	RzILOpPure *op_RSHIFT_36 = SHIFTRA(DUP(Rs), SN(32, 0));
	RzILOpPure *op_AND_38 = LOGAND(op_RSHIFT_36, SN(32, 0xffff));
	RzILOpPure *op_RSHIFT_44 = SHIFTRA(DUP(Rt), SN(32, 16));
	RzILOpPure *op_AND_46 = LOGAND(op_RSHIFT_44, SN(32, 0xffff));
	RzILOpPure *op_MUL_49 = MUL(CAST(32, MSB(CAST(16, MSB(op_AND_38), DUP(op_AND_38))), CAST(16, MSB(DUP(op_AND_38)), DUP(op_AND_38))), CAST(32, MSB(CAST(16, MSB(op_AND_46), DUP(op_AND_46))), CAST(16, MSB(DUP(op_AND_46)), DUP(op_AND_46))));
	RzILOpPure *op_LSHIFT_52 = SHIFTL0(CAST(64, MSB(op_MUL_49), DUP(op_MUL_49)), SN(32, 1));
	RzILOpPure *op_ADD_54 = ADD(CAST(64, MSB(READ_REG(pkt, Rx_op, false)), READ_REG(pkt, Rx_op, false)), op_LSHIFT_52);
	RzILOpPure *op_EQ_55 = EQ(SEXTRACT64(CAST(64, IL_FALSE, op_ADD_27), SN(32, 0), SN(32, 0x20)), op_ADD_54);
	RzILOpPure *op_RSHIFT_84 = SHIFTRA(DUP(Rs), SN(32, 0));
	RzILOpPure *op_AND_86 = LOGAND(op_RSHIFT_84, SN(32, 0xffff));
	RzILOpPure *op_RSHIFT_92 = SHIFTRA(DUP(Rt), SN(32, 16));
	RzILOpPure *op_AND_94 = LOGAND(op_RSHIFT_92, SN(32, 0xffff));
	RzILOpPure *op_MUL_97 = MUL(CAST(32, MSB(CAST(16, MSB(op_AND_86), DUP(op_AND_86))), CAST(16, MSB(DUP(op_AND_86)), DUP(op_AND_86))), CAST(32, MSB(CAST(16, MSB(op_AND_94), DUP(op_AND_94))), CAST(16, MSB(DUP(op_AND_94)), DUP(op_AND_94))));
	RzILOpPure *op_LSHIFT_100 = SHIFTL0(CAST(64, MSB(op_MUL_97), DUP(op_MUL_97)), SN(32, 1));
	RzILOpPure *op_ADD_102 = ADD(CAST(64, MSB(READ_REG(pkt, Rx_op, false)), READ_REG(pkt, Rx_op, false)), op_LSHIFT_100);
	RzILOpPure *op_LT_105 = SLT(op_ADD_102, CAST(64, MSB(SN(32, 0)), SN(32, 0)));
	RzILOpPure *op_LSHIFT_110 = SHIFTL0(SN(64, 1), SN(32, 31));
	RzILOpPure *op_NEG_111 = NEG(op_LSHIFT_110);
	RzILOpPure *op_LSHIFT_116 = SHIFTL0(SN(64, 1), SN(32, 31));
	RzILOpPure *op_SUB_119 = SUB(op_LSHIFT_116, CAST(64, MSB(SN(32, 1)), SN(32, 1)));
	RzILOpPure *cond_120 = ITE(op_LT_105, op_NEG_111, op_SUB_119);
	RzILOpEffect *gcc_expr_121 = BRANCH(op_EQ_55, EMPTY(), set_usr_field_call_80);

	// h_tmp337 = HYB(gcc_expr_if ((sextract64(((ut64) ((st64) Rx) + (((st64) ((st32) ((st16) ((Rs >> 0x0) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x10) & 0xffff)))) << 0x1)), 0x0, 0x20) == ((st64) Rx) + (((st64) ((st32) ((st16) ((Rs >> 0x0) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x10) & 0xffff)))) << 0x1))) {{}} else {set_usr_field(bundle, HEX_REG_FIELD_USR_OVF, ((ut32) 0x1))}, ((((st64) Rx) + (((st64) ((st32) ((st16) ((Rs >> 0x0) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x10) & 0xffff)))) << 0x1) < ((st64) 0x0)) ? (-(0x1 << 0x1f)) : (0x1 << 0x1f) - ((st64) 0x1)));
	RzILOpEffect *op_ASSIGN_hybrid_tmp_123 = SETL("h_tmp337", cond_120);

	// seq(HYB(gcc_expr_if ((sextract64(((ut64) ((st64) Rx) + (((st64)  ...;
	RzILOpEffect *seq_124 = SEQN(2, gcc_expr_121, op_ASSIGN_hybrid_tmp_123);

	// Rx = ((st32) ((sextract64(((ut64) ((st64) Rx) + (((st64) ((st32) ((st16) ((Rs >> 0x0) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x10) & 0xffff)))) << 0x1)), 0x0, 0x20) == ((st64) Rx) + (((st64) ((st32) ((st16) ((Rs >> 0x0) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x10) & 0xffff)))) << 0x1)) ? ((st64) Rx) + (((st64) ((st32) ((st16) ((Rs >> 0x0) & 0xffff))) * ((st32) ((st16) ((Rt >> 0x10) & 0xffff)))) << 0x1) : h_tmp337));
	RzILOpPure *op_RSHIFT_59 = SHIFTRA(DUP(Rs), SN(32, 0));
	RzILOpPure *op_AND_61 = LOGAND(op_RSHIFT_59, SN(32, 0xffff));
	RzILOpPure *op_RSHIFT_67 = SHIFTRA(DUP(Rt), SN(32, 16));
	Rz