
/* Python wrapper functions auto-generated by pidl */
#define PY_SSIZE_T_CLEAN 1 /* We use Py_ssize_t for PyArg_ParseTupleAndKeywords */
#include "lib/replace/system/python.h"
#include "python/py3compat.h"
#include "includes.h"
#include "python/modules.h"
#include <pytalloc.h>
#include "librpc/rpc/pyrpc.h"
#include "librpc/rpc/pyrpc_util.h"
#include "bin/default/librpc/gen_ndr/ndr_winreg.h"
#include "bin/default/librpc/gen_ndr/ndr_winreg_c.h"

/*
 * Suppress compiler warnings if the generated code does not call these
 * functions
 */
#ifndef _MAYBE_UNUSED_
#ifdef __has_attribute
#if __has_attribute(unused)
#define _MAYBE_UNUSED_ __attribute__ ((unused))
#else
#define _MAYBE_UNUSED_
#endif
#endif
#endif
/*
 * These functions are here to ensure they can be optimized out by
 * the compiler based on the constant input values
 */

static inline unsigned long long ndr_sizeof2uintmax(size_t var_size)
{
	switch (var_size) {
	case 8:
		return UINT64_MAX;
	case 4:
		return UINT32_MAX;
	case 2:
		return UINT16_MAX;
	case 1:
		return UINT8_MAX;
	}

	return 0;
}

static inline _MAYBE_UNUSED_ long long ndr_sizeof2intmax(size_t var_size)
{
	switch (var_size) {
	case 8:
		return INT64_MAX;
	case 4:
		return INT32_MAX;
	case 2:
		return INT16_MAX;
	case 1:
		return INT8_MAX;
	}

	return 0;
}

#include "librpc/gen_ndr/lsa.h"
#include "librpc/gen_ndr/security.h"
#include "librpc/gen_ndr/misc.h"
static PyTypeObject winreg_String_Type;
static PyTypeObject KeySecurityData_Type;
static PyTypeObject winreg_SecBuf_Type;
static PyTypeObject winreg_StringBuf_Type;
static PyTypeObject winreg_ValNameBuf_Type;
static PyTypeObject KeySecurityAttribute_Type;
static PyTypeObject QueryMultipleValue_Type;
static PyTypeObject winreg_InterfaceType;
static PyTypeObject winreg_OpenHKCR_Type;
static PyTypeObject winreg_OpenHKCU_Type;
static PyTypeObject winreg_OpenHKLM_Type;
static PyTypeObject winreg_OpenHKPD_Type;
static PyTypeObject winreg_OpenHKU_Type;
static PyTypeObject winreg_CloseKey_Type;
static PyTypeObject winreg_CreateKey_Type;
static PyTypeObject winreg_DeleteKey_Type;
static PyTypeObject winreg_DeleteValue_Type;
static PyTypeObject winreg_EnumKey_Type;
static PyTypeObject winreg_EnumValue_Type;
static PyTypeObject winreg_FlushKey_Type;
static PyTypeObject winreg_GetKeySecurity_Type;
static PyTypeObject winreg_LoadKey_Type;
static PyTypeObject winreg_NotifyChangeKeyValue_Type;
static PyTypeObject winreg_OpenKey_Type;
static PyTypeObject winreg_QueryInfoKey_Type;
static PyTypeObject winreg_QueryValue_Type;
static PyTypeObject winreg_ReplaceKey_Type;
static PyTypeObject winreg_RestoreKey_Type;
static PyTypeObject winreg_SaveKey_Type;
static PyTypeObject winreg_SetKeySecurity_Type;
static PyTypeObject winreg_SetValue_Type;
static PyTypeObject winreg_UnLoadKey_Type;
static PyTypeObject winreg_InitiateSystemShutdown_Type;
static PyTypeObject winreg_AbortSystemShutdown_Type;
static PyTypeObject winreg_GetVersion_Type;
static PyTypeObject winreg_OpenHKCC_Type;
static PyTypeObject winreg_OpenHKDD_Type;
static PyTypeObject winreg_QueryMultipleValues_Type;
static PyTypeObject winreg_InitiateSystemShutdownEx_Type;
static PyTypeObject winreg_SaveKeyEx_Type;
static PyTypeObject winreg_OpenHKPT_Type;
static PyTypeObject winreg_OpenHKPN_Type;
static PyTypeObject winreg_QueryMultipleValues2_Type;
static PyTypeObject winreg_DeleteKeyEx_Type;

static PyTypeObject *BaseObject_Type;
static PyTypeObject *policy_handle_Type;
static PyTypeObject *lsa_StringLarge_Type;
static PyTypeObject *ClientConnection_Type;
static PyTypeObject *ndr_syntax_id_Type;

static PyObject *py_winreg_String_get_name_len(PyObject *obj, void *closure)
{
	struct winreg_String *object = pytalloc_get_ptr(obj);
	PyObject *py_name_len;
	py_name_len = PyLong_FromLong((uint16_t)(object->name_len));
	return py_name_len;
}

static int py_winreg_String_set_name_len(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winreg_String *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->name_len");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->name_len));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->name_len = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_winreg_String_get_name_size(PyObject *obj, void *closure)
{
	struct winreg_String *object = pytalloc_get_ptr(obj);
	PyObject *py_name_size;
	py_name_size = PyLong_FromLong((uint16_t)(object->name_size));
	return py_name_size;
}

static int py_winreg_String_set_name_size(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winreg_String *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->name_size");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->name_size));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->name_size = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_winreg_String_get_name(PyObject *obj, void *closure)
{
	struct winreg_String *object = pytalloc_get_ptr(obj);
	PyObject *py_name;
	if (object->name == NULL) {
		Py_RETURN_NONE;
	}
	if (object->name == NULL) {
		py_name = Py_None;
		Py_INCREF(py_name);
	} else {
		if (object->name == NULL) {
			py_name = Py_None;
			Py_INCREF(py_name);
		} else {
			py_name = PyUnicode_Decode(object->name, strlen(object->name), "utf-8", "ignore");
		}
	}
	return py_name;
}

static int py_winreg_String_set_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winreg_String *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->name");
		return -1;
	}
	if (value == Py_None) {
		object->name = NULL;
	} else {
		object->name = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->name = talloc_str;
		}
	}
	return 0;
}

static PyGetSetDef py_winreg_String_getsetters[] = {
	{
		.name = discard_const_p(char, "name_len"),
		.get = py_winreg_String_get_name_len,
		.set = py_winreg_String_set_name_len,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "name_size"),
		.get = py_winreg_String_get_name_size,
		.set = py_winreg_String_set_name_size,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "name"),
		.get = py_winreg_String_get_name,
		.set = py_winreg_String_set_name,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{ .name = NULL }
};

static PyObject *py_winreg_String_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct winreg_String, type);
}

static PyObject *py_winreg_String_ndr_pack(PyObject *py_obj,  PyObject *Py_UNUSED(ignored))
{
	struct winreg_String *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;
	TALLOC_CTX *tmp_ctx = talloc_new(pytalloc_get_mem_ctx(py_obj));
	if (tmp_ctx == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}
	err = ndr_push_struct_blob(&blob, tmp_ctx, object, (ndr_push_flags_fn_t)ndr_push_winreg_String);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(tmp_ctx);
		PyErr_SetNdrError(err);
		return NULL;
	}

	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(tmp_ctx);
	return ret;
}

static PyObject *py_winreg_String_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct winreg_String *object = pytalloc_get_ptr(py_obj);
	DATA_BLOB blob = {.data = NULL, .length = 0};
	Py_ssize_t blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_winreg_String);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_winreg_String);
	}
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_winreg_String_ndr_print(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct winreg_String *object = pytalloc_get_ptr(py_obj);
	const char * const kwnames[] = { "print_secrets", NULL };
	PyObject *py_print_secrets = NULL;
	PyObject *ret;
	char *retstr;
	bool ok;

	ok = PyArg_ParseTupleAndKeywords(args, kwargs, "|O:__ndr_print__",
		discard_const_p(char *, kwnames),
		&py_print_secrets);
	if (!ok) {
		return NULL;
	}

	if (py_print_secrets != NULL && PyObject_IsTrue(py_print_secrets)) {
		retstr = ndr_print_struct_secret_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_winreg_String, "winreg_String", object);
	} else {
		retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_winreg_String, "winreg_String", object);
		}
	ret = PyUnicode_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_winreg_String_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_winreg_String_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winreg_String_ndr_unpack), METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winreg_String_ndr_print), METH_VARARGS|METH_KEYWORDS, "S.ndr_print(object, print_secrets=False) -> String\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject winreg_String_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "winreg.String",
	.tp_getset = py_winreg_String_getsetters,
	.tp_methods = py_winreg_String_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_winreg_String_new,
};


static PyObject *py_KeySecurityData_get_data(PyObject *obj, void *closure)
{
	struct KeySecurityData *object = pytalloc_get_ptr(obj);
	PyObject *py_data;
	if (object->data == NULL) {
		Py_RETURN_NONE;
	}
	if (object->data == NULL) {
		py_data = Py_None;
		Py_INCREF(py_data);
	} else {
		py_data = PyList_New(object->len);
		if (py_data == NULL) {
			return NULL;
		}
		{
			int data_cntr_1;
			for (data_cntr_1 = 0; data_cntr_1 < (object->len); data_cntr_1++) {
				PyObject *py_data_1;
				py_data_1 = PyLong_FromLong((uint16_t)((object->data)[data_cntr_1]));
				PyList_SetItem(py_data, data_cntr_1, py_data_1);
			}
		}
	}
	return py_data;
}

static int py_KeySecurityData_set_data(PyObject *py_obj, PyObject *value, void *closure)
{
	struct KeySecurityData *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->data));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->data");
		return -1;
	}
	if (value == Py_None) {
		object->data = NULL;
	} else {
		object->data = NULL;
		PY_CHECK_TYPE(&PyList_Type, value, return -1;);
		{
			int data_cntr_1;
			object->data = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->data, PyList_GET_SIZE(value));
			if (!object->data) { return -1; }
			talloc_set_name_const(object->data, "ARRAY: object->data");
			for (data_cntr_1 = 0; data_cntr_1 < PyList_GET_SIZE(value); data_cntr_1++) {
				if (PyList_GET_ITEM(value, data_cntr_1) == NULL) {
					PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: (object->data)[data_cntr_1]");
					return -1;
				}
				{
					const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof((object->data)[data_cntr_1]));
					if (PyLong_Check(PyList_GET_ITEM(value, data_cntr_1))) {
						unsigned long long test_var;
						test_var = PyLong_AsUnsignedLongLong(PyList_GET_ITEM(value, data_cntr_1));
						if (PyErr_Occurred() != NULL) {
							return -1;
						}
						if (test_var > uint_max) {
							PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
							  PyLong_Type.tp_name, uint_max, test_var);
							return -1;
						}
						(object->data)[data_cntr_1] = test_var;
					} else {
						PyErr_Format(PyExc_TypeError, "Expected type %s",
						  PyLong_Type.tp_name);
						return -1;
					}
				}
			}
		}
	}
	return 0;
}

static PyObject *py_KeySecurityData_get_size(PyObject *obj, void *closure)
{
	struct KeySecurityData *object = pytalloc_get_ptr(obj);
	PyObject *py_size;
	py_size = PyLong_FromUnsignedLongLong((uint32_t)(object->size));
	return py_size;
}

static int py_KeySecurityData_set_size(PyObject *py_obj, PyObject *value, void *closure)
{
	struct KeySecurityData *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->size");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->size));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->size = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_KeySecurityData_get_len(PyObject *obj, void *closure)
{
	struct KeySecurityData *object = pytalloc_get_ptr(obj);
	PyObject *py_len;
	py_len = PyLong_FromUnsignedLongLong((uint32_t)(object->len));
	return py_len;
}

static int py_KeySecurityData_set_len(PyObject *py_obj, PyObject *value, void *closure)
{
	struct KeySecurityData *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->len");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->len));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->len = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyGetSetDef py_KeySecurityData_getsetters[] = {
	{
		.name = discard_const_p(char, "data"),
		.get = py_KeySecurityData_get_data,
		.set = py_KeySecurityData_set_data,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "size"),
		.get = py_KeySecurityData_get_size,
		.set = py_KeySecurityData_set_size,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "len"),
		.get = py_KeySecurityData_get_len,
		.set = py_KeySecurityData_set_len,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{ .name = NULL }
};

static PyObject *py_KeySecurityData_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct KeySecurityData, type);
}


static PyTypeObject KeySecurityData_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "winreg.KeySecurityData",
	.tp_getset = py_KeySecurityData_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_KeySecurityData_new,
};


static PyObject *py_winreg_SecBuf_get_length(PyObject *obj, void *closure)
{
	struct winreg_SecBuf *object = pytalloc_get_ptr(obj);
	PyObject *py_length;
	py_length = PyLong_FromUnsignedLongLong((uint32_t)(object->length));
	return py_length;
}

static int py_winreg_SecBuf_set_length(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winreg_SecBuf *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->length");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->length));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->length = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_winreg_SecBuf_get_sd(PyObject *obj, void *closure)
{
	struct winreg_SecBuf *object = pytalloc_get_ptr(obj);
	PyObject *py_sd;
	py_sd = pytalloc_reference_ex(&KeySecurityData_Type, pytalloc_get_mem_ctx(obj), &object->sd);
	return py_sd;
}

static int py_winreg_SecBuf_set_sd(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winreg_SecBuf *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->sd");
		return -1;
	}
	PY_CHECK_TYPE(&KeySecurityData_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->sd = *(struct KeySecurityData *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_winreg_SecBuf_get_inherit(PyObject *obj, void *closure)
{
	struct winreg_SecBuf *object = pytalloc_get_ptr(obj);
	PyObject *py_inherit;
	py_inherit = PyLong_FromLong((uint16_t)(object->inherit));
	return py_inherit;
}

static int py_winreg_SecBuf_set_inherit(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winreg_SecBuf *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->inherit");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->inherit));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->inherit = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyGetSetDef py_winreg_SecBuf_getsetters[] = {
	{
		.name = discard_const_p(char, "length"),
		.get = py_winreg_SecBuf_get_length,
		.set = py_winreg_SecBuf_set_length,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "sd"),
		.get = py_winreg_SecBuf_get_sd,
		.set = py_winreg_SecBuf_set_sd,
		.doc = discard_const_p(char, "PIDL-generated element of base type KeySecurityData")
	},
	{
		.name = discard_const_p(char, "inherit"),
		.get = py_winreg_SecBuf_get_inherit,
		.set = py_winreg_SecBuf_set_inherit,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{ .name = NULL }
};

static PyObject *py_winreg_SecBuf_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct winreg_SecBuf, type);
}


static PyTypeObject winreg_SecBuf_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "winreg.SecBuf",
	.tp_getset = py_winreg_SecBuf_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_winreg_SecBuf_new,
};


static PyObject *py_winreg_StringBuf_get_length(PyObject *obj, void *closure)
{
	struct winreg_StringBuf *object = pytalloc_get_ptr(obj);
	PyObject *py_length;
	py_length = PyLong_FromLong((uint16_t)(object->length));
	return py_length;
}

static int py_winreg_StringBuf_set_length(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winreg_StringBuf *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->length");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->length));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->length = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_winreg_StringBuf_get_size(PyObject *obj, void *closure)
{
	struct winreg_StringBuf *object = pytalloc_get_ptr(obj);
	PyObject *py_size;
	py_size = PyLong_FromLong((uint16_t)(object->size));
	return py_size;
}

static int py_winreg_StringBuf_set_size(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winreg_StringBuf *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->size");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->size));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->size = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_winreg_StringBuf_get_name(PyObject *obj, void *closure)
{
	struct winreg_StringBuf *object = pytalloc_get_ptr(obj);
	PyObject *py_name;
	if (object->name == NULL) {
		Py_RETURN_NONE;
	}
	if (object->name == NULL) {
		py_name = Py_None;
		Py_INCREF(py_name);
	} else {
		if (object->name == NULL) {
			py_name = Py_None;
			Py_INCREF(py_name);
		} else {
			py_name = PyUnicode_Decode(object->name, strlen(object->name), "utf-8", "ignore");
		}
	}
	return py_name;
}

static int py_winreg_StringBuf_set_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winreg_StringBuf *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->name");
		return -1;
	}
	if (value == Py_None) {
		object->name = NULL;
	} else {
		object->name = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->name = talloc_str;
		}
	}
	return 0;
}

static PyGetSetDef py_winreg_StringBuf_getsetters[] = {
	{
		.name = discard_const_p(char, "length"),
		.get = py_winreg_StringBuf_get_length,
		.set = py_winreg_StringBuf_set_length,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "size"),
		.get = py_winreg_StringBuf_get_size,
		.set = py_winreg_StringBuf_set_size,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "name"),
		.get = py_winreg_StringBuf_get_name,
		.set = py_winreg_StringBuf_set_name,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{ .name = NULL }
};

static PyObject *py_winreg_StringBuf_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct winreg_StringBuf, type);
}


static PyTypeObject winreg_StringBuf_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "winreg.StringBuf",
	.tp_getset = py_winreg_StringBuf_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_winreg_StringBuf_new,
};


static PyObject *py_winreg_ValNameBuf_get_length(PyObject *obj, void *closure)
{
	struct winreg_ValNameBuf *object = pytalloc_get_ptr(obj);
	PyObject *py_length;
	py_length = PyLong_FromLong((uint16_t)(object->length));
	return py_length;
}

static int py_winreg_ValNameBuf_set_length(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winreg_ValNameBuf *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->length");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->length));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->length = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_winreg_ValNameBuf_get_size(PyObject *obj, void *closure)
{
	struct winreg_ValNameBuf *object = pytalloc_get_ptr(obj);
	PyObject *py_size;
	py_size = PyLong_FromLong((uint16_t)(object->size));
	return py_size;
}

static int py_winreg_ValNameBuf_set_size(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winreg_ValNameBuf *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->size");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->size));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->size = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_winreg_ValNameBuf_get_name(PyObject *obj, void *closure)
{
	struct winreg_ValNameBuf *object = pytalloc_get_ptr(obj);
	PyObject *py_name;
	if (object->name == NULL) {
		Py_RETURN_NONE;
	}
	if (object->name == NULL) {
		py_name = Py_None;
		Py_INCREF(py_name);
	} else {
		if (object->name == NULL) {
			py_name = Py_None;
			Py_INCREF(py_name);
		} else {
			py_name = PyUnicode_Decode(object->name, strlen(object->name), "utf-8", "ignore");
		}
	}
	return py_name;
}

static int py_winreg_ValNameBuf_set_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winreg_ValNameBuf *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->name");
		return -1;
	}
	if (value == Py_None) {
		object->name = NULL;
	} else {
		object->name = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->name = talloc_str;
		}
	}
	return 0;
}

static PyGetSetDef py_winreg_ValNameBuf_getsetters[] = {
	{
		.name = discard_const_p(char, "length"),
		.get = py_winreg_ValNameBuf_get_length,
		.set = py_winreg_ValNameBuf_set_length,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "size"),
		.get = py_winreg_ValNameBuf_get_size,
		.set = py_winreg_ValNameBuf_set_size,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "name"),
		.get = py_winreg_ValNameBuf_get_name,
		.set = py_winreg_ValNameBuf_set_name,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{ .name = NULL }
};

static PyObject *py_winreg_ValNameBuf_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct winreg_ValNameBuf, type);
}


static PyTypeObject winreg_ValNameBuf_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "winreg.ValNameBuf",
	.tp_getset = py_winreg_ValNameBuf_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_winreg_ValNameBuf_new,
};


static PyObject *py_KeySecurityAttribute_get_data_size(PyObject *obj, void *closure)
{
	struct KeySecurityAttribute *object = pytalloc_get_ptr(obj);
	PyObject *py_data_size;
	py_data_size = PyLong_FromUnsignedLongLong((uint32_t)(object->data_size));
	return py_data_size;
}

static int py_KeySecurityAttribute_set_data_size(PyObject *py_obj, PyObject *value, void *closure)
{
	struct KeySecurityAttribute *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->data_size");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->data_size));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->data_size = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_KeySecurityAttribute_get_sec_data(PyObject *obj, void *closure)
{
	struct KeySecurityAttribute *object = pytalloc_get_ptr(obj);
	PyObject *py_sec_data;
	py_sec_data = pytalloc_reference_ex(&KeySecurityData_Type, pytalloc_get_mem_ctx(obj), &object->sec_data);
	return py_sec_data;
}

static int py_KeySecurityAttribute_set_sec_data(PyObject *py_obj, PyObject *value, void *closure)
{
	struct KeySecurityAttribute *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->sec_data");
		return -1;
	}
	PY_CHECK_TYPE(&KeySecurityData_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->sec_data = *(struct KeySecurityData *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_KeySecurityAttribute_get_inherit(PyObject *obj, void *closure)
{
	struct KeySecurityAttribute *object = pytalloc_get_ptr(obj);
	PyObject *py_inherit;
	py_inherit = PyLong_FromLong((uint16_t)(object->inherit));
	return py_inherit;
}

static int py_KeySecurityAttribute_set_inherit(PyObject *py_obj, PyObject *value, void *closure)
{
	struct KeySecurityAttribute *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->inherit");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->inherit));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->inherit = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyGetSetDef py_KeySecurityAttribute_getsetters[] = {
	{
		.name = discard_const_p(char, "data_size"),
		.get = py_KeySecurityAttribute_get_data_size,
		.set = py_KeySecurityAttribute_set_data_size,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "sec_data"),
		.get = py_KeySecurityAttribute_get_sec_data,
		.set = py_KeySecurityAttribute_set_sec_data,
		.doc = discard_const_p(char, "PIDL-generated element of base type KeySecurityData")
	},
	{
		.name = discard_const_p(char, "inherit"),
		.get = py_KeySecurityAttribute_get_inherit,
		.set = py_KeySecurityAttribute_set_inherit,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{ .name = NULL }
};

static PyObject *py_KeySecurityAttribute_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct KeySecurityAttribute, type);
}


static PyTypeObject KeySecurityAttribute_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "winreg.KeySecurityAttribute",
	.tp_getset = py_KeySecurityAttribute_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_KeySecurityAttribute_new,
};


static PyObject *py_QueryMultipleValue_get_ve_valuename(PyObject *obj, void *closure)
{
	struct QueryMultipleValue *object = pytalloc_get_ptr(obj);
	PyObject *py_ve_valuename;
	if (object->ve_valuename == NULL) {
		Py_RETURN_NONE;
	}
	if (object->ve_valuename == NULL) {
		py_ve_valuename = Py_None;
		Py_INCREF(py_ve_valuename);
	} else {
		py_ve_valuename = pytalloc_reference_ex(&winreg_ValNameBuf_Type, object->ve_valuename, object->ve_valuename);
	}
	return py_ve_valuename;
}

static int py_QueryMultipleValue_set_ve_valuename(PyObject *py_obj, PyObject *value, void *closure)
{
	struct QueryMultipleValue *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->ve_valuename));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->ve_valuename");
		return -1;
	}
	if (value == Py_None) {
		object->ve_valuename = NULL;
	} else {
		object->ve_valuename = NULL;
		PY_CHECK_TYPE(&winreg_ValNameBuf_Type, value, return -1;);
		if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->ve_valuename = (struct winreg_ValNameBuf *)pytalloc_get_ptr(value);
	}
	return 0;
}

static PyObject *py_QueryMultipleValue_get_ve_valuelen(PyObject *obj, void *closure)
{
	struct QueryMultipleValue *object = pytalloc_get_ptr(obj);
	PyObject *py_ve_valuelen;
	py_ve_valuelen = PyLong_FromUnsignedLongLong((uint32_t)(object->ve_valuelen));
	return py_ve_valuelen;
}

static int py_QueryMultipleValue_set_ve_valuelen(PyObject *py_obj, PyObject *value, void *closure)
{
	struct QueryMultipleValue *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->ve_valuelen");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->ve_valuelen));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->ve_valuelen = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_QueryMultipleValue_get_ve_valueptr(PyObject *obj, void *closure)
{
	struct QueryMultipleValue *object = pytalloc_get_ptr(obj);
	PyObject *py_ve_valueptr;
	py_ve_valueptr = PyLong_FromUnsignedLongLong((uint32_t)(object->ve_valueptr));
	return py_ve_valueptr;
}

static int py_QueryMultipleValue_set_ve_valueptr(PyObject *py_obj, PyObject *value, void *closure)
{
	struct QueryMultipleValue *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->ve_valueptr");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->ve_valueptr));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->ve_valueptr = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_QueryMultipleValue_get_ve_type(PyObject *obj, void *closure)
{
	struct QueryMultipleValue *object = pytalloc_get_ptr(obj);
	PyObject *py_ve_type;
	py_ve_type = PyLong_FromUnsignedLongLong((uint32_t)(object->ve_type));
	return py_ve_type;
}

static int py_QueryMultipleValue_set_ve_type(PyObject *py_obj, PyObject *value, void *closure)
{
	struct QueryMultipleValue *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->ve_type");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->ve_type));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->ve_type = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyGetSetDef py_QueryMultipleValue_getsetters[] = {
	{
		.name = discard_const_p(char, "ve_valuename"),
		.get = py_QueryMultipleValue_get_ve_valuename,
		.set = py_QueryMultipleValue_set_ve_valuename,
		.doc = discard_const_p(char, "PIDL-generated element of base type winreg_ValNameBuf")
	},
	{
		.name = discard_const_p(char, "ve_valuelen"),
		.get = py_QueryMultipleValue_get_ve_valuelen,
		.set = py_QueryMultipleValue_set_ve_valuelen,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "ve_valueptr"),
		.get = py_QueryMultipleValue_get_ve_valueptr,
		.set = py_QueryMultipleValue_set_ve_valueptr,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "ve_type"),
		.get = py_QueryMultipleValue_get_ve_type,
		.set = py_QueryMultipleValue_set_ve_type,
		.doc = discard_const_p(char, "PIDL-generated element of base type winreg_Type")
	},
	{ .name = NULL }
};

static PyObject *py_QueryMultipleValue_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct QueryMultipleValue, type);
}


static PyTypeObject QueryMultipleValue_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "winreg.QueryMultipleValue",
	.tp_getset = py_QueryMultipleValue_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_QueryMultipleValue_new,
};



static PyObject *py_winreg_OpenHKCR_in_get_system_name(PyObject *obj, void *closure)
{
	struct winreg_OpenHKCR *object = pytalloc_get_ptr(obj);
	PyObject *py_system_name;
	if (object->in.system_name == NULL) {
		Py_RETURN_NONE;
	}
	if (object->in.system_name == NULL) {
		py_system_name = Py_None;
		Py_INCREF(py_system_name);
	} else {
		py_system_name = PyLong_FromLong((uint16_t)(*object->in.system_name));
	}
	return py_system_name;
}

static int py_winreg_OpenHKCR_in_set_system_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winreg_OpenHKCR *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->in.system_name));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.system_name");
		return -1;
	}
	if (value == Py_None) {
		object->in.system_name = NULL;
	} else {
		object->in.system_name = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->in.system_name);
		if (object->in.system_name == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		{
			const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(*object->in.system_name));
			if (PyLong_Check(value)) {
				unsigned long long test_var;
				test_var = PyLong_AsUnsignedLongLong(value);
				if (PyErr_Occurred() != NULL) {
					return -1;
				}
				if (test_var > uint_max) {
					PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
					  PyLong_Type.tp_name, uint_max, test_var);
					return -1;
				}
				*object->in.system_name = test_var;
			} else {
				PyErr_Format(PyExc_TypeError, "Expected type %s",
				  PyLong_Type.tp_name);
				return -1;
			}
		}
	}
	return 0;
}

static PyObject *py_winreg_OpenHKCR_in_get_access_mask(PyObject *obj, void *closure)
{
	struct winreg_OpenHKCR *object = pytalloc_get_ptr(obj);
	PyObject *py_access_mask;
	py_access_mask = PyLong_FromUnsignedLongLong((uint32_t)(object->in.access_mask));
	return py_access_mask;
}

static int py_winreg_OpenHKCR_in_set_access_mask(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winreg_OpenHKCR *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.access_mask");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->in.access_mask));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->in.access_mask = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_winreg_OpenHKCR_out_get_handle(PyObject *obj, void *closure)
{
	struct winreg_OpenHKCR *object = pytalloc_get_ptr(obj);
	PyObject *py_handle;
	if (object->out.handle == NULL) {
		Py_RETURN_NONE;
	}
	py_handle = pytalloc_reference_ex(policy_handle_Type, object->out.handle, object->out.handle);
	return py_handle;
}

static int py_winreg_OpenHKCR_out_set_handle(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winreg_OpenHKCR *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->out.handle));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->out.handle");
		return -1;
	}
	object->out.handle = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->out.handle);
	if (object->out.handle == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	PY_CHECK_TYPE(policy_handle_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->out.handle = (struct policy_handle *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_winreg_OpenHKCR_get_result(PyObject *obj, void *closure)
{
	struct winreg_OpenHKCR *object = pytalloc_get_ptr(obj);
	PyObject *py_result;
	py_result = PyErr_FromWERROR(object->out.result);
	return py_result;
}

static int py_winreg_OpenHKCR_set_result(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winreg_OpenHKCR *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->out.result");
		return -1;
	}
	object->out.result = W_ERROR(PyLong_AsLong(value));
	return 0;
}

static PyGetSetDef py_winreg_OpenHKCR_getsetters[] = {
	{
		.name = discard_const_p(char, "in_system_name"),
		.get = py_winreg_OpenHKCR_in_get_system_name,
		.set = py_winreg_OpenHKCR_in_set_system_name,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "in_access_mask"),
		.get = py_winreg_OpenHKCR_in_get_access_mask,
		.set = py_winreg_OpenHKCR_in_set_access_mask,
		.doc = discard_const_p(char, "PIDL-generated element of base type winreg_AccessMask")
	},
	{
		.name = discard_const_p(char, "out_handle"),
		.get = py_winreg_OpenHKCR_out_get_handle,
		.set = py_winreg_OpenHKCR_out_set_handle,
		.doc = discard_const_p(char, "PIDL-generated element of base type policy_handle")
	},
	{
		.name = discard_const_p(char, "result"),
		.get = py_winreg_OpenHKCR_get_result,
		.set = py_winreg_OpenHKCR_set_result,
		.doc = discard_const_p(char, "PIDL-generated element of type WERROR")
	},
	{ .name = NULL }
};

static PyObject *py_winreg_OpenHKCR_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyObject *self = pytalloc_new(struct winreg_OpenHKCR, type);
	struct winreg_OpenHKCR *_self = (struct winreg_OpenHKCR *)pytalloc_get_ptr(self);
	TALLOC_CTX *mem_ctx = pytalloc_get_mem_ctx(self);
	_self->out.handle = talloc_zero(mem_ctx, struct policy_handle);
	return self;
}

static PyObject *py_winreg_OpenHKCR_ndr_opnum(PyTypeObject *type, PyObject *Py_UNUSED(ignored))
{


	return PyLong_FromLong(0);
}

static PyObject *py_winreg_OpenHKCR_ndr_pack(PyObject *py_obj, ndr_flags_type ndr_inout_flags, libndr_flags ndr_push_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct winreg_OpenHKCR *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	struct ndr_push *push = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;

	if (ndr_table_winreg.num_calls < 1) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_winreg_OpenHKCR_ndr_pack");
		return NULL;
	}
	call = &ndr_table_winreg.calls[0];

	push = ndr_push_init_ctx(pytalloc_get_mem_ctx(py_obj));
	if (push == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	push->flags |= ndr_push_flags;

	err = call->ndr_push(push, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(push);
		PyErr_SetNdrError(err);
		return NULL;
	}
	blob = ndr_push_blob(push);
	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(push);
	return ret;
}

static PyObject *py_winreg_OpenHKCR_ndr_pack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_in__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_winreg_OpenHKCR_ndr_pack(py_obj, NDR_IN, ndr_push_flags);
}

static PyObject *py_winreg_OpenHKCR_ndr_pack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_out__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_winreg_OpenHKCR_ndr_pack(py_obj, NDR_OUT, ndr_push_flags);
}

static PyObject *py_winreg_OpenHKCR_ndr_unpack(PyObject *py_obj, const DATA_BLOB *blob, ndr_flags_type ndr_inout_flags, libndr_flags ndr_pull_flags, bool allow_remaining)
{
	const struct ndr_interface_call *call = NULL;
	struct winreg_OpenHKCR *object = pytalloc_get_ptr(py_obj);
	struct ndr_pull *pull = NULL;
	enum ndr_err_code err;

	if (ndr_table_winreg.num_calls < 1) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_winreg_OpenHKCR_ndr_unpack");
		return NULL;
	}
	call = &ndr_table_winreg.calls[0];

	pull = ndr_pull_init_blob(blob, object);
	if (pull == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	pull->flags |= ndr_pull_flags;

	err = call->ndr_pull(pull, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(pull);
		PyErr_SetNdrError(err);
		return NULL;
	}
	if (!allow_remaining) {
		uint32_t highest_ofs;

		if (pull->offset > pull->relative_highest_offset) {
			highest_ofs = pull->offset;
		} else {
			highest_ofs = pull->relative_highest_offset;
		}
		if (highest_ofs < pull->data_size) {
			err = ndr_pull_error(pull, NDR_ERR_UNREAD_BYTES,
				"not all bytes consumed ofs[%u] size[%u]",
				highest_ofs, pull->data_size);
			TALLOC_FREE(pull);
			PyErr_SetNdrError(err);
			return NULL;
		}
	}

	TALLOC_FREE(pull);
	Py_RETURN_NONE;
}

static PyObject *py_winreg_OpenHKCR_ndr_unpack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_in__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_winreg_OpenHKCR_ndr_unpack(py_obj, &blob, NDR_IN, ndr_pull_flags, allow_remaining);
}

static PyObject *py_winreg_OpenHKCR_ndr_unpack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_out__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_winreg_OpenHKCR_ndr_unpack(py_obj, &blob, NDR_OUT, ndr_pull_flags, allow_remaining);
}

static PyObject *py_winreg_OpenHKCR_ndr_print(PyObject *py_obj, PyObject *args, PyObject *kwargs, const char *name, ndr_flags_type ndr_inout_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct winreg_OpenHKCR *object = pytalloc_get_ptr(py_obj);
	const char * const kwnames[] = { "print_secrets", NULL };
	PyObject *py_print_secrets = NULL;
	PyObject *ret;
	char *retstr;
	bool ok;

	ok = PyArg_ParseTupleAndKeywords(args, kwargs, "|O:__ndr_print__",
		discard_const_p(char *, kwnames),
		&py_print_secrets);
	if (!ok) {
		return NULL;
	}

	if (ndr_table_winreg.num_calls < 1) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_winreg_OpenHKCR_ndr_print");
		return NULL;
	}
	call = &ndr_table_winreg.calls[0];

	if (py_print_secrets != NULL && PyObject_IsTrue(py_print_secrets)) {
		retstr = ndr_print_function_secret_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	} else {
		retstr = ndr_print_function_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	}
	ret = PyUnicode_FromString(retstr);
	TALLOC_FREE(retstr);

	return ret;
}

static PyObject *py_winreg_OpenHKCR_ndr_print_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	return py_winreg_OpenHKCR_ndr_print(py_obj, args, kwargs, "winreg_OpenHKCR_in", NDR_IN);
}

static PyObject *py_winreg_OpenHKCR_ndr_print_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	return py_winreg_OpenHKCR_ndr_print(py_obj, args, kwargs, "winreg_OpenHKCR_out", NDR_OUT);
}

static PyMethodDef py_winreg_OpenHKCR_methods[] = {
	{ "opnum", (PyCFunction)py_winreg_OpenHKCR_ndr_opnum, METH_NOARGS|METH_CLASS,
		"winreg.OpenHKCR.opnum() -> 0 (0x00) " },
	{ "__ndr_pack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winreg_OpenHKCR_ndr_pack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_in(object, bigendian=False, ndr64=False) -> blob\nNDR pack input" },
	{ "__ndr_pack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winreg_OpenHKCR_ndr_pack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_out(object, bigendian=False, ndr64=False) -> blob\nNDR pack output" },
	{ "__ndr_unpack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winreg_OpenHKCR_ndr_unpack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_in(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack input" },
	{ "__ndr_unpack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winreg_OpenHKCR_ndr_unpack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_out(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack output" },
	{ "__ndr_print_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winreg_OpenHKCR_ndr_print_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_print_in(object, print_secrets=False) -> String\nNDR print input" },
	{ "__ndr_print_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winreg_OpenHKCR_ndr_print_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_print_out(object, print_secrets=False) -> String\nNDR print output" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject winreg_OpenHKCR_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "winreg.OpenHKCR",
	.tp_getset = py_winreg_OpenHKCR_getsetters,
	.tp_methods = py_winreg_OpenHKCR_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_winreg_OpenHKCR_new,
};

static bool pack_py_winreg_OpenHKCR_args_in(PyObject *args, PyObject *kwargs, struct winreg_OpenHKCR *r)
{
	PyObject *py_system_name;
	PyObject *py_access_mask;
	const char *kwnames[] = {
		"system_name", "access_mask", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OO:winreg_OpenHKCR", discard_const_p(char *, kwnames), &py_system_name, &py_access_mask)) {
		return false;
	}

	if (py_system_name == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.system_name");
		return false;
	}
	if (py_system_name == Py_None) {
		r->in.system_name = NULL;
	} else {
		r->in.system_name = talloc_ptrtype(r, r->in.system_name);
		if (r->in.system_name == NULL) {
			PyErr_NoMemory();
			return false;
		}
		{
			const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(*r->in.system_name));
			if (PyLong_Check(py_system_name)) {
				unsigned long long test_var;
				test_var = PyLong_AsUnsignedLongLong(py_system_name);
				if (PyErr_Occurred() != NULL) {
					return false;
				}
				if (test_var > uint_max) {
					PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
					  PyLong_Type.tp_name, uint_max, test_var);
					return false;
				}
				*r->in.system_name = test_var;
			} else {
				PyErr_Format(PyExc_TypeError, "Expected type %s",
				  PyLong_Type.tp_name);
				return false;
			}
		}
	}
	if (py_access_mask == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.access_mask");
		return false;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(r->in.access_mask));
		if (PyLong_Check(py_access_mask)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(py_access_mask);
			if (PyErr_Occurred() != NULL) {
				return false;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return false;
			}
			r->in.access_mask = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return false;
		}
	}
	return true;
}

static PyObject *unpack_py_winreg_OpenHKCR_args_out(struct winreg_OpenHKCR *r, bool raise_result_exception)
{
	PyObject *py_handle = NULL;
	PyObject *result = NULL;
	size_t result_size = 1;

	if (raise_result_exception) {
		if (!W_ERROR_IS_OK(r->out.result)) {
			PyErr_SetWERROR(r->out.result);
			return NULL;
		}

	} else {
		/* WERROR will be part of the results */
		result_size += 1;
	}

	if (result_size > 1) {
		result = PyTuple_New(result_size);
		if (result == NULL) {
			return NULL;
		}
	}

	py_handle = pytalloc_reference_ex(policy_handle_Type, r->out.handle, r->out.handle);
	if (result_size > 1) {
		PyTuple_SetItem(result, 0, py_handle);
	}
	if (result_size == 1) {
		result = py_handle;
	}

	if (!raise_result_exception) {
		PyTuple_SetItem(result, 1, PyErr_FromWERROR(r->out.result));
	}

	return result;
}


static PyObject *py_winreg_OpenHKCU_in_get_system_name(PyObject *obj, void *closure)
{
	struct winreg_OpenHKCU *object = pytalloc_get_ptr(obj);
	PyObject *py_system_name;
	if (object->in.system_name == NULL) {
		Py_RETURN_NONE;
	}
	if (object->in.system_name == NULL) {
		py_system_name = Py_None;
		Py_INCREF(py_system_name);
	} else {
		py_system_name = PyLong_FromLong((uint16_t)(*object->in.system_name));
	}
	return py_system_name;
}

static int py_winreg_OpenHKCU_in_set_system_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winreg_OpenHKCU *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->in.system_name));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.system_name");
		return -1;
	}
	if (value == Py_None) {
		object->in.system_name = NULL;
	} else {
		object->in.system_name = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->in.system_name);
		if (object->in.system_name == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		{
			const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(*object->in.system_name));
			if (PyLong_Check(value)) {
				unsigned long long test_var;
				test_var = PyLong_AsUnsignedLongLong(value);
				if (PyErr_Occurred() != NULL) {
					return -1;
				}
				if (test_var > uint_max) {
					PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
					  PyLong_Type.tp_name, uint_max, test_var);
					return -1;
				}
				*object->in.system_name = test_var;
			} else {
				PyErr_Format(PyExc_TypeError, "Expected type %s",
				  PyLong_Type.tp_name);
				return -1;
			}
		}
	}
	return 0;
}

static PyObject *py_winreg_OpenHKCU_in_get_access_mask(PyObject *obj, void *closure)
{
	struct winreg_OpenHKCU *object = pytalloc_get_ptr(obj);
	PyObject *py_access_mask;
	py_access_mask = PyLong_FromUnsignedLongLong((uint32_t)(object->in.access_mask));
	return py_access_mask;
}

static int py_winreg_OpenHKCU_in_set_access_mask(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winreg_OpenHKCU *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.access_mask");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->in.access_mask));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->in.access_mask = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_winreg_OpenHKCU_out_get_handle(PyObject *obj, void *closure)
{
	struct winreg_OpenHKCU *object = pytalloc_get_ptr(obj);
	PyObject *py_handle;
	if (object->out.handle == NULL) {
		Py_RETURN_NONE;
	}
	py_handle = pytalloc_reference_ex(policy_handle_Type, object->out.handle, object->out.handle);
	return py_handle;
}

static int py_winreg_OpenHKCU_out_set_handle(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winreg_OpenHKCU *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->out.handle));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->out.handle");
		return -1;
	}
	object->out.handle = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->out.handle);
	if (object->out.handle == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	PY_CHECK_TYPE(policy_handle_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->out.handle = (struct policy_handle *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_winreg_OpenHKCU_get_result(PyObject *obj, void *closure)
{
	struct winreg_OpenHKCU *object = pytalloc_get_ptr(obj);
	PyObject *py_result;
	py_result = PyErr_FromWERROR(object->out.result);
	return py_result;
}

static int py_winreg_OpenHKCU_set_result(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winreg_OpenHKCU *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->out.result");
		return -1;
	}
	object->out.result = W_ERROR(PyLong_AsLong(value));
	return 0;
}

static PyGetSetDef py_winreg_OpenHKCU_getsetters[] = {
	{
		.name = discard_const_p(char, "in_system_name"),
		.get = py_winreg_OpenHKCU_in_get_system_name,
		.set = py_winreg_OpenHKCU_in_set_system_name,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "in_access_mask"),
		.get = py_winreg_OpenHKCU_in_get_access_mask,
		.set = py_winreg_OpenHKCU_in_set_access_mask,
		.doc = discard_const_p(char, "PIDL-generated element of base type winreg_AccessMask")
	},
	{
		.name = discard_const_p(char, "out_handle"),
		.get = py_winreg_OpenHKCU_out_get_handle,
		.set = py_winreg_OpenHKCU_out_set_handle,
		.doc = discard_const_p(char, "PIDL-generated element of base type policy_handle")
	},
	{
		.name = discard_const_p(char, "result"),
		.get = py_winreg_OpenHKCU_get_result,
		.set = py_winreg_OpenHKCU_set_result,
		.doc = discard_const_p(char, "PIDL-generated element of type WERROR")
	},
	{ .name = NULL }
};

static PyObject *py_winreg_OpenHKCU_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyObject *self = pytalloc_new(struct winreg_OpenHKCU, type);
	struct winreg_OpenHKCU *_self = (struct winreg_OpenHKCU *)pytalloc_get_ptr(self);
	TALLOC_CTX *mem_ctx = pytalloc_get_mem_ctx(self);
	_self->out.handle = talloc_zero(mem_ctx, struct policy_handle);
	return self;
}

static PyObject *py_winreg_OpenHKCU_ndr_opnum(PyTypeObject *type, PyObject *Py_UNUSED(ignored))
{


	return PyLong_FromLong(1);
}

static PyObject *py_winreg_OpenHKCU_ndr_pack(PyObject *py_obj, ndr_flags_type ndr_inout_flags, libndr_flags ndr_push_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct winreg_OpenHKCU *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	struct ndr_push *push = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;

	if (ndr_table_winreg.num_calls < 2) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_winreg_OpenHKCU_ndr_pack");
		return NULL;
	}
	call = &ndr_table_winreg.calls[1];

	push = ndr_push_init_ctx(pytalloc_get_mem_ctx(py_obj));
	if (push == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	push->flags |= ndr_push_flags;

	err = call->ndr_push(push, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(push);
		PyErr_SetNdrError(err);
		return NULL;
	}
	blob = ndr_push_blob(push);
	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(push);
	return ret;
}

static PyObject *py_winreg_OpenHKCU_ndr_pack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_in__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_winreg_OpenHKCU_ndr_pack(py_obj, NDR_IN, ndr_push_flags);
}

static PyObject *py_winreg_OpenHKCU_ndr_pack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_out__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_winreg_OpenHKCU_ndr_pack(py_obj, NDR_OUT, ndr_push_flags);
}

static PyObject *py_winreg_OpenHKCU_ndr_unpack(PyObject *py_obj, const DATA_BLOB *blob, ndr_flags_type ndr_inout_flags, libndr_flags ndr_pull_flags, bool allow_remaining)
{
	const struct ndr_interface_call *call = NULL;
	struct winreg_OpenHKCU *object = pytalloc_get_ptr(py_obj);
	struct ndr_pull *pull = NULL;
	enum ndr_err_code err;

	if (ndr_table_winreg.num_calls < 2) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_winreg_OpenHKCU_ndr_unpack");
		return NULL;
	}
	call = &ndr_table_winreg.calls[1];

	pull = ndr_pull_init_blob(blob, object);
	if (pull == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	pull->flags |= ndr_pull_flags;

	err = call->ndr_pull(pull, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(pull);
		PyErr_SetNdrError(err);
		return NULL;
	}
	if (!allow_remaining) {
		uint32_t highest_ofs;

		if (pull->offset > pull->relative_highest_offset) {
			highest_ofs = pull->offset;
		} else {
			highest_ofs = pull->relative_highest_offset;
		}
		if (highest_ofs < pull->data_size) {
			err = ndr_pull_error(pull, NDR_ERR_UNREAD_BYTES,
				"not all bytes consumed ofs[%u] size[%u]",
				highest_ofs, pull->data_size);
			TALLOC_FREE(pull);
			PyErr_SetNdrError(err);
			return NULL;
		}
	}

	TALLOC_FREE(pull);
	Py_RETURN_NONE;
}

static PyObject *py_winreg_OpenHKCU_ndr_unpack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_in__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_winreg_OpenHKCU_ndr_unpack(py_obj, &blob, NDR_IN, ndr_pull_flags, allow_remaining);
}

static PyObject *py_winreg_OpenHKCU_ndr_unpack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_out__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_winreg_OpenHKCU_ndr_unpack(py_obj, &blob, NDR_OUT, ndr_pull_flags, allow_remaining);
}

static PyObject *py_winreg_OpenHKCU_ndr_print(PyObject *py_obj, PyObject *args, PyObject *kwargs, const char *name, ndr_flags_type ndr_inout_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct winreg_OpenHKCU *object = pytalloc_get_ptr(py_obj);
	const char * const kwnames[] = { "print_secrets", NULL };
	PyObject *py_print_secrets = NULL;
	PyObject *ret;
	char *retstr;
	bool ok;

	ok = PyArg_ParseTupleAndKeywords(args, kwargs, "|O:__ndr_print__",
		discard_const_p(char *, kwnames),
		&py_print_secrets);
	if (!ok) {
		return NULL;
	}

	if (ndr_table_winreg.num_calls < 2) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_winreg_OpenHKCU_ndr_print");
		return NULL;
	}
	call = &ndr_table_winreg.calls[1];

	if (py_print_secrets != NULL && PyObject_IsTrue(py_print_secrets)) {
		retstr = ndr_print_function_secret_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	} else {
		retstr = ndr_print_function_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	}
	ret = PyUnicode_FromString(retstr);
	TALLOC_FREE(retstr);

	return ret;
}

static PyObject *py_winreg_OpenHKCU_ndr_print_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	return py_winreg_OpenHKCU_ndr_print(py_obj, args, kwargs, "winreg_OpenHKCU_in", NDR_IN);
}

static PyObject *py_winreg_OpenHKCU_ndr_print_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	return py_winreg_OpenHKCU_ndr_print(py_obj, args, kwargs, "winreg_OpenHKCU_out", NDR_OUT);
}

static PyMethodDef py_winreg_OpenHKCU_methods[] = {
	{ "opnum", (PyCFunction)py_winreg_OpenHKCU_ndr_opnum, METH_NOARGS|METH_CLASS,
		"winreg.OpenHKCU.opnum() -> 1 (0x01) " },
	{ "__ndr_pack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winreg_OpenHKCU_ndr_pack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_in(object, bigendian=False, ndr64=False) -> blob\nNDR pack input" },
	{ "__ndr_pack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winreg_OpenHKCU_ndr_pack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_out(object, bigendian=False, ndr64=False) -> blob\nNDR pack output" },
	{ "__ndr_unpack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winreg_OpenHKCU_ndr_unpack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_in(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack input" },
	{ "__ndr_unpack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winreg_OpenHKCU_ndr_unpack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_out(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack output" },
	{ "__ndr_print_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winreg_OpenHKCU_ndr_print_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_print_in(object, print_secrets=False) -> String\nNDR print input" },
	{ "__ndr_print_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winreg_OpenHKCU_ndr_print_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_print_out(object, print_secrets=False) -> String\nNDR print output" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject winreg_OpenHKCU_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "winreg.OpenHKCU",
	.tp_getset = py_winreg_OpenHKCU_getsetters,
	.tp_methods = py_winreg_OpenHKCU_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_winreg_OpenHKCU_new,
};

static bool pack_py_winreg_OpenHKCU_args_in(PyObject *args, PyObject *kwargs, struct winreg_OpenHKCU *r)
{
	PyObject *py_system_name;
	PyObject *py_access_mask;
	const char *kwnames[] = {
		"system_name", "access_mask", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OO:winreg_OpenHKCU", discard_const_p(char *, kwnames), &py_system_name, &py_access_mask)) {
		return false;
	}

	if (py_system_name == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.system_name");
		return false;
	}
	if (py_system_name == Py_None) {
		r->in.system_name = NULL;
	} else {
		r->in.system_name = talloc_ptrtype(r, r->in.system_name);
		if (r->in.system_name == NULL) {
			PyErr_NoMemory();
			return false;
		}
		{
			const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(*r->in.system_name));
			if (PyLong_Check(py_system_name)) {
				unsigned long long test_var;
				test_var = PyLong_AsUnsignedLongLong(py_system_name);
				if (PyErr_Occurred() != NULL) {
					return false;
				}
				if (test_var > uint_max) {
					PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
					  PyLong_Type.tp_name, uint_max, test_var);
					return false;
				}
				*r->in.system_name = test_var;
			} else {
				PyErr_Format(PyExc_TypeError, "Expected type %s",
				  PyLong_Type.tp_name);
				return false;
			}
		}
	}
	if (py_access_mask == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.access_mask");
		return false;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(r->in.access_mask));
		if (PyLong_Check(py_access_mask)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(py_access_mask);
			if (PyErr_Occurred() != NULL) {
				return false;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return false;
			}
			r->in.access_mask = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return false;
		}
	}
	return true;
}

static PyObject *unpack_py_winreg_OpenHKCU_args_out(struct winreg_OpenHKCU *r, bool raise_result_exception)
{
	PyObject *py_handle = NULL;
	PyObject *result = NULL;
	size_t result_size = 1;

	if (raise_result_exception) {
		if (!W_ERROR_IS_OK(r->out.result)) {
			PyErr_SetWERROR(r->out.result);
			return NULL;
		}

	} else {
		/* WERROR will be part of the results */
		result_size += 1;
	}

	if (result_size > 1) {
		result = PyTuple_New(result_size);
		if (result == NULL) {
			return NULL;
		}
	}

	py_handle = pytalloc_reference_ex(policy_handle_Type, r->out.handle, r->out.handle);
	if (result_size > 1) {
		PyTuple_SetItem(result, 0, py_handle);
	}
	if (result_size == 1) {
		result = py_handle;
	}

	if (!raise_result_exception) {
		PyTuple_SetItem(result, 1, PyErr_FromWERROR(r->out.result));
	}

	return result;
}


static PyObject *py_winreg_OpenHKLM_in_get_system_name(PyObject *obj, void *closure)
{
	struct winreg_OpenHKLM *object = pytalloc_get_ptr(obj);
	PyObject *py_system_name;
	if (object->in.system_name == NULL) {
		Py_RETURN_NONE;
	}
	if (object->in.system_name == NULL) {
		py_system_name = Py_None;
		Py_INCREF(py_system_name);
	} else {
		py_system_name = PyLong_FromLong((uint16_t)(*object->in.system_name));
	}
	return py_system_name;
}

static int py_winreg_OpenHKLM_in_set_system_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winreg_OpenHKLM *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->in.system_name));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.system_name");
		return -1;
	}
	if (value == Py_None) {
		object->in.system_name = NULL;
	} else {
		object->in.system_name = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->in.system_name);
		if (object->in.system_name == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		{
			const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(*object->in.system_name));
			if (PyLong_Check(value)) {
				unsigned long long test_var;
				test_var = PyLong_AsUnsignedLongLong(value);
				if (PyErr_Occurred() != NULL) {
					return -1;
				}
				if (test_var > uint_max) {
					PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
					  PyLong_Type.tp_name, uint_max, test_var);
					return -1;
				}
				*object->in.system_name = test_var;
			} else {
				PyErr_Format(PyExc_TypeError, "Expected type %s",
				  PyLong_Type.tp_name);
				return -1;
			}
		}
	}
	return 0;
}

static PyObject *py_winreg_OpenHKLM_in_get_access_mask(PyObject *obj, void *closure)
{
	struct winreg_OpenHKLM *object = pytalloc_get_ptr(obj);
	PyObject *py_access_mask;
	py_access_mask = PyLong_FromUnsignedLongLong((uint32_t)(object->in.access_mask));
	return py_access_mask;
}

static int py_winreg_OpenHKLM_in_set_access_mask(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winreg_OpenHKLM *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.access_mask");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->in.access_mask));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->in.access_mask = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_winreg_OpenHKLM_out_get_handle(PyObject *obj, void *closure)
{
	struct winreg_OpenHKLM *object = pytalloc_get_ptr(obj);
	PyObject *py_handle;
	if (object->out.handle == NULL) {
		Py_RETURN_NONE;
	}
	py_handle = pytalloc_reference_ex(policy_handle_Type, object->out.handle, object->out.handle);
	return py_handle;
}

static int py_winreg_OpenHKLM_out_set_handle(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winreg_OpenHKLM *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->out.handle));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->out.handle");
		return -1;
	}
	object->out.handle = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->out.handle);
	if (object->out.handle == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	PY_CHECK_TYPE(policy_handle_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->out.handle = (struct policy_handle *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_winreg_OpenHKLM_get_result(PyObject *obj, void *closure)
{
	struct winreg_OpenHKLM *object = pytalloc_get_ptr(obj);
	PyObject *py_result;
	py_result = PyErr_FromWERROR(object->out.result);
	return py_result;
}

static int py_winreg_OpenHKLM_set_result(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winreg_OpenHKLM *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->out.result");
		return -1;
	}
	object->out.result = W_ERROR(PyLong_AsLong(value));
	return 0;
}

static PyGetSetDef py_winreg_OpenHKLM_getsetters[] = {
	{
		.name = discard_const_p(char, "in_system_name"),
		.get = py_winreg_OpenHKLM_in_get_system_name,
		.set = py_winreg_OpenHKLM_in_set_system_name,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "in_access_mask"),
		.get = py_winreg_OpenHKLM_in_get_access_mask,
		.set = py_winreg_OpenHKLM_in_set_access_mask,
		.doc = discard_const_p(char, "PIDL-generated element of base type winreg_AccessMask")
	},
	{
		.name = discard_const_p(char, "out_handle"),
		.get = py_winreg_OpenHKLM_out_get_handle,
		.set = py_winreg_OpenHKLM_out_set_handle,
		.doc = discard_const_p(char, "PIDL-generated element of base type policy_handle")
	},
	{
		.name = discard_const_p(char, "result"),
		.get = py_winreg_OpenHKLM_get_result,
		.set = py_winreg_OpenHKLM_set_result,
		.doc = discard_const_p(char, "PIDL-generated element of type WERROR")
	},
	{ .name = NULL }
};

static PyObject *py_winreg_OpenHKLM_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyObject *self = pytalloc_new(struct winreg_OpenHKLM, type);
	struct winreg_OpenHKLM *_self = (struct winreg_OpenHKLM *)pytalloc_get_ptr(self);
	TALLOC_CTX *mem_ctx = pytalloc_get_mem_ctx(self);
	_self->out.handle = talloc_zero(mem_ctx, struct policy_handle);
	return self;
}

static PyObject *py_winreg_OpenHKLM_ndr_opnum(PyTypeObject *type, PyObject *Py_UNUSED(ignored))
{


	return PyLong_FromLong(2);
}

static PyObject *py_winreg_OpenHKLM_ndr_pack(PyObject *py_obj, ndr_flags_type ndr_inout_flags, libndr_flags ndr_push_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct winreg_OpenHKLM *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	struct ndr_push *push = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;

	if (ndr_table_winreg.num_calls < 3) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_winreg_OpenHKLM_ndr_pack");
		return NULL;
	}
	call = &ndr_table_winreg.calls[2];

	push = ndr_push_init_ctx(pytalloc_get_mem_ctx(py_obj));
	if (push == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	push->flags |= ndr_push_flags;

	err = call->ndr_push(push, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(push);
		PyErr_SetNdrError(err);
		return NULL;
	}
	blob = ndr_push_blob(push);
	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(push);
	return ret;
}

static PyObject *py_winreg_OpenHKLM_ndr_pack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_in__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_winreg_OpenHKLM_ndr_pack(py_obj, NDR_IN, ndr_push_flags);
}

static PyObject *py_winreg_OpenHKLM_ndr_pack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_out__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_winreg_OpenHKLM_ndr_pack(py_obj, NDR_OUT, ndr_push_flags);
}

static PyObject *py_winreg_OpenHKLM_ndr_unpack(PyObject *py_obj, const DATA_BLOB *blob, ndr_flags_type ndr_inout_flags, libndr_flags ndr_pull_flags, bool allow_remaining)
{
	const struct ndr_interface_call *call = NULL;
	struct winreg_OpenHKLM *object = pytalloc_get_ptr(py_obj);
	struct ndr_pull *pull = NULL;
	enum ndr_err_code err;

	if (ndr_table_winreg.num_calls < 3) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_winreg_OpenHKLM_ndr_unpack");
		return NULL;
	}
	call = &ndr_table_winreg.calls[2];

	pull = ndr_pull_init_blob(blob, object);
	if (pull == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	pull->flags |= ndr_pull_flags;

	err = call->ndr_pull(pull, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(pull);
		PyErr_SetNdrError(err);
		return NULL;
	}
	if (!allow_remaining) {
		uint32_t highest_ofs;

		if (pull->offset > pull->relative_highest_offset) {
			highest_ofs = pull->offset;
		} else {
			highest_ofs = pull->relative_highest_offset;
		}
		if (highest_ofs < pull->data_size) {
			err = ndr_pull_error(pull, NDR_ERR_UNREAD_BYTES,
				"not all bytes consumed ofs[%u] size[%u]",
				highest_ofs, pull->data_size);
			TALLOC_FREE(pull);
			PyErr_SetNdrError(err);
			return NULL;
		}
	}

	TALLOC_FREE(pull);
	Py_RETURN_NONE;
}

static PyObject *py_winreg_OpenHKLM_ndr_unpack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_in__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_winreg_OpenHKLM_ndr_unpack(py_obj, &blob, NDR_IN, ndr_pull_flags, allow_remaining);
}

static PyObject *py_winreg_OpenHKLM_ndr_unpack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_out__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_winreg_OpenHKLM_ndr_unpack(py_obj, &blob, NDR_OUT, ndr_pull_flags, allow_remaining);
}

static PyObject *py_winreg_OpenHKLM_ndr_print(PyObject *py_obj, PyObject *args, PyObject *kwargs, const char *name, ndr_flags_type ndr_inout_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct winreg_OpenHKLM *object = pytalloc_get_ptr(py_obj);
	const char * const kwnames[] = { "print_secrets", NULL };
	PyObject *py_print_secrets = NULL;
	PyObject *ret;
	char *retstr;
	bool ok;

	ok = PyArg_ParseTupleAndKeywords(args, kwargs, "|O:__ndr_print__",
		discard_const_p(char *, kwnames),
		&py_print_secrets);
	if (!ok) {
		return NULL;
	}

	if (ndr_table_winreg.num_calls < 3) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_winreg_OpenHKLM_ndr_print");
		return NULL;
	}
	call = &ndr_table_winreg.calls[2];

	if (py_print_secrets != NULL && PyObject_IsTrue(py_print_secrets)) {
		retstr = ndr_print_function_secret_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	} else {
		retstr = ndr_print_function_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	}
	ret = PyUnicode_FromString(retstr);
	TALLOC_FREE(retstr);

	return ret;
}

static PyObject *py_winreg_OpenHKLM_ndr_print_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	return py_winreg_OpenHKLM_ndr_print(py_obj, args, kwargs, "winreg_OpenHKLM_in", NDR_IN);
}

static PyObject *py_winreg_OpenHKLM_ndr_print_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	return py_winreg_OpenHKLM_ndr_print(py_obj, args, kwargs, "winreg_OpenHKLM_out", NDR_OUT);
}

static PyMethodDef py_winreg_OpenHKLM_methods[] = {
	{ "opnum", (PyCFunction)py_winreg_OpenHKLM_ndr_opnum, METH_NOARGS|METH_CLASS,
		"winreg.OpenHKLM.opnum() -> 2 (0x02) " },
	{ "__ndr_pack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winreg_OpenHKLM_ndr_pack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_in(object, bigendian=False, ndr64=False) -> blob\nNDR pack input" },
	{ "__ndr_pack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winreg_OpenHKLM_ndr_pack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_out(object, bigendian=False, ndr64=False) -> blob\nNDR pack output" },
	{ "__ndr_unpack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winreg_OpenHKLM_ndr_unpack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_in(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack input" },
	{ "__ndr_unpack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winreg_OpenHKLM_ndr_unpack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_out(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack output" },
	{ "__ndr_print_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winreg_OpenHKLM_ndr_print_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_print_in(object, print_secrets=False) -> String\nNDR print input" },
	{ "__ndr_print_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winreg_OpenHKLM_ndr_print_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_print_out(object, print_secrets=False) -> String\nNDR print output" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject winreg_OpenHKLM_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "winreg.OpenHKLM",
	.tp_getset = py_winreg_OpenHKLM_getsetters,
	.tp_methods = py_winreg_OpenHKLM_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_winreg_OpenHKLM_new,
};

static bool pack_py_winreg_OpenHKLM_args_in(PyObject *args, PyObject *kwargs, struct winreg_OpenHKLM *r)
{
	PyObject *py_system_name;
	PyObject *py_access_mask;
	const char *kwnames[] = {
		"system_name", "access_mask", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OO:winreg_OpenHKLM", discard_const_p(char *, kwnames), &py_system_name, &py_access_mask)) {
		return false;
	}

	if (py_system_name == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.system_name");
		return false;
	}
	if (py_system_name == Py_None) {
		r->in.system_name = NULL;
	} else {
		r->in.system_name = talloc_ptrtype(r, r->in.system_name);
		if (r->in.system_name == NULL) {
			PyErr_NoMemory();
			return false;
		}
		{
			const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(*r->in.system_name));
			if (PyLong_Check(py_system_name)) {
				unsigned long long test_var;
				test_var = PyLong_AsUnsignedLongLong(py_system_name);
				if (PyErr_Occurred() != NULL) {
					return false;
				}
				if (test_var > uint_max) {
					PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
					  PyLong_Type.tp_name, uint_max, test_var);
					return false;
				}
				*r->in.system_name = test_var;
			} else {
				PyErr_Format(PyExc_TypeError, "Expected type %s",
				  PyLong_Type.tp_name);
				return false;
			}
		}
	}
	if (py_access_mask == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.access_mask");
		return false;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(r->in.access_mask));
		if (PyLong_Check(py_access_mask)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(py_access_mask);
			if (PyErr_Occurred() != NULL) {
				return false;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return false;
			}
			r->in.access_mask = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return false;
		}
	}
	return true;
}

static PyObject *unpack_py_winreg_OpenHKLM_args_out(struct winreg_OpenHKLM *r, bool raise_result_exception)
{
	PyObject *py_handle = NULL;
	PyObject *result = NULL;
	size_t result_size = 1;

	if (raise_result_exception) {
		if (!W_ERROR_IS_OK(r->out.result)) {
			PyErr_SetWERROR(r->out.result);
			return NULL;
		}

	} else {
		/* WERROR will be part of the results */
		result_size += 1;
	}

	if (result_size > 1) {
		result = PyTuple_New(result_size);
		if (result == NULL) {
			return NULL;
		}
	}

	py_handle = pytalloc_reference_ex(policy_handle_Type, r->out.handle, r->out.handle);
	if (result_size > 1) {
		PyTuple_SetItem(result, 0, py_handle);
	}
	if (result_size == 1) {
		result = py_handle;
	}

	if (!raise_result_exception) {
		PyTuple_SetItem(result, 1, PyErr_FromWERROR(r->out.result));
	}

	return result;
}


static PyObject *py_winreg_OpenHKPD_in_get_system_name(PyObject *obj, void *closure)
{
	struct winreg_OpenHKPD *object = pytalloc_get_ptr(obj);
	PyObject *py_system_name;
	if (object->in.system_name == NULL) {
		Py_RETURN_NONE;
	}
	if (object->in.system_name == NULL) {
		py_system_name = Py_None;
		Py_INCREF(py_system_name);
	} else {
		py_system_name = PyLong_FromLong((uint16_t)(*object->in.system_name));
	}
	return py_system_name;
}

static int py_winreg_OpenHKPD_in_set_system_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winreg_OpenHKPD *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->in.system_name));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.system_name");
		return -1;
	}
	if (value == Py_None) {
		object->in.system_name = NULL;
	} else {
		object->in.system_name = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->in.system_name);
		if (object->in.system_name == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		{
			const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(*object->in.system_name));
			if (PyLong_Check(value)) {
				unsigned long long test_var;
				test_var = PyLong_AsUnsignedLongLong(value);
				if (PyErr_Occurred() != NULL) {
					return -1;
				}
				if (test_var > uint_max) {
					PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
					  PyLong_Type.tp_name, uint_max, test_var);
					return -1;
				}
				*object->in.system_name = test_var;
			} else {
				PyErr_Format(PyExc_TypeError, "Expected type %s",
				  PyLong_Type.tp_name);
				return -1;
			}
		}
	}
	return 0;
}

static PyObject *py_winreg_OpenHKPD_in_get_access_mask(PyObject *obj, void *closure)
{
	struct winreg_OpenHKPD *object = pytalloc_get_ptr(obj);
	PyObject *py_access_mask;
	py_access_mask = PyLong_FromUnsignedLongLong((uint32_t)(object->in.access_mask));
	return py_access_mask;
}

static int py_winreg_OpenHKPD_in_set_access_mask(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winreg_OpenHKPD *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.access_mask");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->in.access_mask));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->in.access_mask = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_winreg_OpenHKPD_out_get_handle(PyObject *obj, void *closure)
{
	struct winreg_OpenHKPD *object = pytalloc_get_ptr(obj);
	PyObject *py_handle;
	if (object->out.handle == NULL) {
		Py_RETURN_NONE;
	}
	py_handle = pytalloc_reference_ex(policy_handle_Type, object->out.handle, object->out.handle);
	return py_handle;
}

static int py_winreg_OpenHKPD_out_set_handle(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winreg_OpenHKPD *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->out.handle));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->out.handle");
		return -1;
	}
	object->out.handle = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->out.handle);
	if (object->out.handle == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	PY_CHECK_TYPE(policy_handle_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->out.handle = (struct policy_handle *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_winreg_OpenHKPD_get_result(PyObject *obj, void *closure)
{
	struct winreg_OpenHKPD *object = pytalloc_get_ptr(obj);
	PyObject *py_result;
	py_result = PyErr_FromWERROR(object->out.result);
	return py_result;
}

static int py_winreg_OpenHKPD_set_result(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winreg_OpenHKPD *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->out.result");
		return -1;
	}
	object->out.result = W_ERROR(PyLong_AsLong(value));
	return 0;
}

static PyGetSetDef py_winreg_OpenHKPD_getsetters[] = {
	{
		.name = discard_const_p(char, "in_system_name"),
		.get = py_winreg_OpenHKPD_in_get_system_name,
		.set = py_winreg_OpenHKPD_in_set_system_name,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "in_access_mask"),
		.get = py_winreg_OpenHKPD_in_get_access_mask,
		.set = py_winreg_OpenHKPD_in_set_access_mask,
		.doc = discard_const_p(char, "PIDL-generated element of base type winreg_AccessMask")
	},
	{
		.name = discard_const_p(char, "out_handle"),
		.get = py_winreg_OpenHKPD_out_get_handle,
		.set = py_winreg_OpenHKPD_out_set_handle,
		.doc = discard_const_p(char, "PIDL-generated element of base type policy_handle")
	},
	{
		.name = discard_const_p(char, "result"),
		.get = py_winreg_OpenHKPD_get_result,
		.set = py_winreg_OpenHKPD_set_result,
		.doc = discard_const_p(char, "PIDL-generated element of type WERROR")
	},
	{ .name = NULL }
};

static PyObject *py_winreg_OpenHKPD_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyObject *self = pytalloc_new(struct winreg_OpenHKPD, type);
	struct winreg_OpenHKPD *_self = (struct winreg_OpenHKPD *)pytalloc_get_ptr(self);
	TALLOC_CTX *mem_ctx = pytalloc_get_mem_ctx(self);
	_self->out.handle = talloc_zero(mem_ctx, struct policy_handle);
	return self;
}

static PyObject *py_winreg_OpenHKPD_ndr_opnum(PyTypeObject *type, PyObject *Py_UNUSED(ignored))
{


	return PyLong_FromLong(3);
}

static PyObject *py_winreg_OpenHKPD_ndr_pack(PyObject *py_obj, ndr_flags_type ndr_inout_flags, libndr_flags ndr_push_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct winreg_OpenHKPD *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	struct ndr_push *push = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;

	if (ndr_table_winreg.num_calls < 4) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_winreg_OpenHKPD_ndr_pack");
		return NULL;
	}
	call = &ndr_table_winreg.calls[3];

	push = ndr_push_init_ctx(pytalloc_get_mem_ctx(py_obj));
	if (push == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	push->flags |= ndr_push_flags;

	err = call->ndr_push(push, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(push);
		PyErr_SetNdrError(err);
		return NULL;
	}
	blob = ndr_push_blob(push);
	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(push);
	return ret;
}

static PyObject *py_winreg_OpenHKPD_ndr_pack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_in__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_winreg_OpenHKPD_ndr_pack(py_obj, NDR_IN, ndr_push_flags);
}

static PyObject *py_winreg_OpenHKPD_ndr_pack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_out__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_winreg_OpenHKPD_ndr_pack(py_obj, NDR_OUT, ndr_push_flags);
}

static PyObject *py_winreg_OpenHKPD_ndr_unpack(PyObject *py_obj, const DATA_BLOB *blob, ndr_flags_type ndr_inout_flags, libndr_flags ndr_pull_flags, bool allow_remaining)
{
	const struct ndr_interface_call *call = NULL;
	struct winreg_OpenHKPD *object = pytalloc_get_ptr(py_obj);
	struct ndr_pull *pull = NULL;
	enum ndr_err_code err;

	if (ndr_table_winreg.num_calls < 4) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_winreg_OpenHKPD_ndr_unpack");
		return NULL;
	}
	call = &ndr_table_winreg.calls[3];

	pull = ndr_pull_init_blob(blob, object);
	if (pull == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	pull->flags |= ndr_pull_flags;

	err = call->ndr_pull(pull, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(pull);
		PyErr_SetNdrError(err);
		return NULL;
	}
	if (!allow_remaining) {
		uint32_t highest_ofs;

		if (pull->offset > pull->relative_highest_offset) {
			highest_ofs = pull->offset;
		} else {
			highest_ofs = pull->relative_highest_offset;
		}
		if (highest_ofs < pull->data_size) {
			err = ndr_pull_error(pull, NDR_ERR_UNREAD_BYTES,
				"not all bytes consumed ofs[%u] size[%u]",
				highest_ofs, pull->data_size);
			TALLOC_FREE(pull);
			PyErr_SetNdrError(err);
			return NULL;
		}
	}

	TALLOC_FREE(pull);
	Py_RETURN_NONE;
}

static PyObject *py_winreg_OpenHKPD_ndr_unpack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_in__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_winreg_OpenHKPD_ndr_unpack(py_obj, &blob, NDR_IN, ndr_pull_flags, allow_remaining);
}

static PyObject *py_winreg_OpenHKPD_ndr_unpack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_out__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_winreg_OpenHKPD_ndr_unpack(py_obj, &blob, NDR_OUT, ndr_pull_flags, allow_remaining);
}

static PyObject *py_winreg_OpenHKPD_ndr_print(PyObject *py_obj, PyObject *args, PyObject *kwargs, const char *name, ndr_flags_type ndr_inout_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct winreg_OpenHKPD *object = pytalloc_get_ptr(py_obj);
	const char * const kwnames[] = { "print_secrets", NULL };
	PyObject *py_print_secrets = NULL;
	PyObject *ret;
	char *retstr;
	bool ok;

	ok = PyArg_ParseTupleAndKeywords(args, kwargs, "|O:__ndr_print__",
		discard_const_p(char *, kwnames),
		&py_print_secrets);
	if (!ok) {
		return NULL;
	}

	if (ndr_table_winreg.num_calls < 4) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_winreg_OpenHKPD_ndr_print");
		return NULL;
	}
	call = &ndr_table_winreg.calls[3];

	if (py_print_secrets != NULL && PyObject_IsTrue(py_print_secrets)) {
		retstr = ndr_print_function_secret_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	} else {
		retstr = ndr_print_function_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	}
	ret = PyUnicode_FromString(retstr);
	TALLOC_FREE(retstr);

	return ret;
}

static PyObject *py_winreg_OpenHKPD_ndr_print_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	return py_winreg_OpenHKPD_ndr_print(py_obj, args, kwargs, "winreg_OpenHKPD_in", NDR_IN);
}

static PyObject *py_winreg_OpenHKPD_ndr_print_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	return py_winreg_OpenHKPD_ndr_print(py_obj, args, kwargs, "winreg_OpenHKPD_out", NDR_OUT);
}

static PyMethodDef py_winreg_OpenHKPD_methods[] = {
	{ "opnum", (PyCFunction)py_winreg_OpenHKPD_ndr_opnum, METH_NOARGS|METH_CLASS,
		"winreg.OpenHKPD.opnum() -> 3 (0x03) " },
	{ "__ndr_pack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winreg_OpenHKPD_ndr_pack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_in(object, bigendian=False, ndr64=False) -> blob\nNDR pack input" },
	{ "__ndr_pack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winreg_OpenHKPD_ndr_pack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_out(object, bigendian=False, ndr64=False) -> blob\nNDR pack output" },
	{ "__ndr_unpack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winreg_OpenHKPD_ndr_unpack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_in(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack input" },
	{ "__ndr_unpack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winreg_OpenHKPD_ndr_unpack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_out(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack output" },
	{ "__ndr_print_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winreg_OpenHKPD_ndr_print_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_print_in(object, print_secrets=False) -> String\nNDR print input" },
	{ "__ndr_print_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winreg_OpenHKPD_ndr_print_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_print_out(object, print_secrets=False) -> String\nNDR print output" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject winreg_OpenHKPD_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "winreg.OpenHKPD",
	.tp_getset = py_winreg_OpenHKPD_getsetters,
	.tp_methods = py_winreg_OpenHKPD_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_winreg_OpenHKPD_new,
};

static bool pack_py_winreg_OpenHKPD_args_in(PyObject *args, PyObject *kwargs, struct winreg_OpenHKPD *r)
{
	PyObject *py_system_name;
	PyObject *py_access_mask;
	const char *kwnames[] = {
		"system_name", "access_mask", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OO:winreg_OpenHKPD", discard_const_p(char *, kwnames), &py_system_name, &py_access_mask)) {
		return false;
	}

	if (py_system_name == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.system_name");
		return false;
	}
	if (py_system_name == Py_None) {
		r->in.system_name = NULL;
	} else {
		r->in.system_name = talloc_ptrtype(r, r->in.system_name);
		if (r->in.system_name == NULL) {
			PyErr_NoMemory();
			return false;
		}
		{
			const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(*r->in.system_name));
			if (PyLong_Check(py_system_name)) {
				unsigned long long test_var;
				test_var = PyLong_AsUnsignedLongLong(py_system_name);
				if (PyErr_Occurred() != NULL) {
					return false;
				}
				if (test_var > uint_max) {
					PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
					  PyLong_Type.tp_name, uint_max, test_var);
					return false;
				}
				*r->in.system_name = test_var;
			} else {
				PyErr_Format(PyExc_TypeError, "Expected type %s",
				  PyLong_Type.tp_name);
				return false;
			}
		}
	}
	if (py_access_mask == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.access_mask");
		return false;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(r->in.access_mask));
		if (PyLong_Check(py_access_mask)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(py_access_mask);
			if (PyErr_Occurred() != NULL) {
				return false;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return false;
			}
			r->in.access_mask = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return false;
		}
	}
	return true;
}

static PyObject *unpack_py_winreg_OpenHKPD_args_out(struct winreg_OpenHKPD *r, bool raise_result_exception)
{
	PyObject *py_handle = NULL;
	PyObject *result = NULL;
	size_t result_size = 1;

	if (raise_result_exception) {
		if (!W_ERROR_IS_OK(r->out.result)) {
			PyErr_SetWERROR(r->out.result);
			return NULL;
		}

	} else {
		/* WERROR will be part of the results */
		result_size += 1;
	}

	if (result_size > 1) {
		result = PyTuple_New(result_size);
		if (result == NULL) {
			return NULL;
		}
	}

	py_handle = pytalloc_reference_ex(policy_handle_Type, r->out.handle, r->out.handle);
	if (result_size > 1) {
		PyTuple_SetItem(result, 0, py_handle);
	}
	if (result_size == 1) {
		result = py_handle;
	}

	if (!raise_result_exception) {
		PyTuple_SetItem(result, 1, PyErr_FromWERROR(r->out.result));
	}

	return result;
}


static PyObject *py_winreg_OpenHKU_in_get_system_name(PyObject *obj, void *closure)
{
	struct winreg_OpenHKU *object = pytalloc_get_ptr(obj);
	PyObject *py_system_name;
	if (object->in.system_name == NULL) {
		Py_RETURN_NONE;
	}
	if (object->in.system_name == NULL) {
		py_system_name = Py_None;
		Py_INCREF(py_system_name);
	} else {
		py_system_name = PyLong_FromLong((uint16_t)(*object->in.system_name));
	}
	return py_system_name;
}

static int py_winreg_OpenHKU_in_set_system_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winreg_OpenHKU *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->in.system_name));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.system_name");
		return -1;
	}
	if (value == Py_None) {
		object->in.system_name = NULL;
	} else {
		object->in.system_name = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->in.system_name);
		if (object->in.system_name == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		{
			const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(*object->in.system_name));
			if (PyLong_Check(value)) {
				unsigned long long test_var;
				test_var = PyLong_AsUnsignedLongLong(value);
				if (PyErr_Occurred() != NULL) {
					return -1;
				}
				if (test_var > uint_max) {
					PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
					  PyLong_Type.tp_name, uint_max, test_var);
					return -1;
				}
				*object->in.system_name = test_var;
			} else {
				PyErr_Format(PyExc_TypeError, "Expected type %s",
				  PyLong_Type.tp_name);
				return -1;
			}
		}
	}
	return 0;
}

static PyObject *py_winreg_OpenHKU_in_get_access_mask(PyObject *obj, void *closure)
{
	struct winreg_OpenHKU *object = pytalloc_get_ptr(obj);
	PyObject *py_access_mask;
	py_access_mask = PyLong_FromUnsignedLongLong((uint32_t)(object->in.access_mask));
	return py_access_mask;
}

static int py_winreg_OpenHKU_in_set_access_mask(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winreg_OpenHKU *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.access_mask");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->in.access_mask));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->in.access_mask = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_winreg_OpenHKU_out_get_handle(PyObject *obj, void *closure)
{
	struct winreg_OpenHKU *object = pytalloc_get_ptr(obj);
	PyObject *py_handle;
	if (object->out.handle == NULL) {
		Py_RETURN_NONE;
	}
	py_handle = pytalloc_reference_ex(policy_handle_Type, object->out.handle, object->out.handle);
	return py_handle;
}

static int py_winreg_OpenHKU_out_set_handle(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winreg_OpenHKU *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->out.handle));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->out.handle");
		return -1;
	}
	object->out.handle = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->out.handle);
	if (object->out.handle == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	PY_CHECK_TYPE(policy_handle_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->out.handle = (struct policy_handle *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_winreg_OpenHKU_get_result(PyObject *obj, void *closure)
{
	struct winreg_OpenHKU *object = pytalloc_get_ptr(obj);
	PyObject *py_result;
	py_result = PyErr_FromWERROR(object->out.result);
	return py_result;
}

static int py_winreg_OpenHKU_set_result(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winreg_OpenHKU *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->out.result");
		return -1;
	}
	object->out.result = W_ERROR(PyLong_AsLong(value));
	return 0;
}

static PyGetSetDef py_winreg_OpenHKU_getsetters[] = {
	{
		.name = discard_const_p(char, "in_system_name"),
		.get = py_winreg_OpenHKU_in_get_system_name,
		.set = py_winreg_OpenHKU_in_set_system_name,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "in_access_mask"),
		.get = py_winreg_OpenHKU_in_get_access_mask,
		.set = py_winreg_OpenHKU_in_set_access_mask,
		.doc = discard_const_p(char, "PIDL-generated element of base type winreg_AccessMask")
	},
	{
		.name = discard_const_p(char, "out_handle"),
		.get = py_winreg_OpenHKU_out_get_handle,
		.set = py_winreg_OpenHKU_out_set_handle,
		.doc = discard_const_p(char, "PIDL-generated element of base type policy_handle")
	},
	{
		.name = discard_const_p(char, "result"),
		.get = py_winreg_OpenHKU_get_result,
		.set = py_winreg_OpenHKU_set_result,
		.doc = discard_const_p(char, "PIDL-generated element of type WERROR")
	},
	{ .name = NULL }
};

static PyObject *py_winreg_OpenHKU_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyObject *self = pytalloc_new(struct winreg_OpenHKU, type);
	struct winreg_OpenHKU *_self = (struct winreg_OpenHKU *)pytalloc_get_ptr(self);
	TALLOC_CTX *mem_ctx = pytalloc_get_mem_ctx(self);
	_self->out.handle = talloc_zero(mem_ctx, struct policy_handle);
	return self;
}

static PyObject *py_winreg_OpenHKU_ndr_opnum(PyTypeObject *type, PyObject *Py_UNUSED(ignored))
{


	return PyLong_FromLong(4);
}

static PyObject *py_winreg_OpenHKU_ndr_pack(PyObject *py_obj, ndr_flags_type ndr_inout_flags, libndr_flags ndr_push_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct winreg_OpenHKU *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	struct ndr_push *push = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;

	if (ndr_table_winreg.num_calls < 5) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_winreg_OpenHKU_ndr_pack");
		return NULL;
	}
	call = &ndr_table_winreg.calls[4];

	push = ndr_push_init_ctx(pytalloc_get_mem_ctx(py_obj));
	if (push == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	push->flags |= ndr_push_flags;

	err = call->ndr_push(push, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(push);
		PyErr_SetNdrError(err);
		return NULL;
	}
	blob = ndr_push_blob(push);
	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(push);
	return ret;
}

static PyObject *py_winreg_OpenHKU_ndr_pack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_in__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_winreg_OpenHKU_ndr_pack(py_obj, NDR_IN, ndr_push_flags);
}

static PyObject *py_winreg_OpenHKU_ndr_pack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_out__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_winreg_OpenHKU_ndr_pack(py_obj, NDR_OUT, ndr_push_flags);
}

static PyObject *py_winreg_OpenHKU_ndr_unpack(PyObject *py_obj, const DATA_BLOB *blob, ndr_flags_type ndr_inout_flags, libndr_flags ndr_pull_flags, bool allow_remaining)
{
	const struct ndr_interface_call *call = NULL;
	struct winreg_OpenHKU *object = pytalloc_get_ptr(py_obj);
	struct ndr_pull *pull = NULL;
	enum ndr_err_code err;

	if (ndr_table_winreg.num_calls < 5) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_winreg_OpenHKU_ndr_unpack");
		return NULL;
	}
	call = &ndr_table_winreg.calls[4];

	pull = ndr_pull_init_blob(blob, object);
	if (pull == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	pull->flags |= ndr_pull_flags;

	err = call->ndr_pull(pull, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(pull);
		PyErr_SetNdrError(err);
		return NULL;
	}
	if (!allow_remaining) {
		uint32_t highest_ofs;

		if (pull->offset > pull->relative_highest_offset) {
			highest_ofs = pull->offset;
		} else {
			highest_ofs = pull->relative_highest_offset;
		}
		if (highest_ofs < pull->data_size) {
			err = ndr_pull_error(pull, NDR_ERR_UNREAD_BYTES,
				"not all bytes consumed ofs[%u] size[%u]",
				highest_ofs, pull->data_size);
			TALLOC_FREE(pull);
			PyErr_SetNdrError(err);
			return NULL;
		}
	}

	TALLOC_FREE(pull);
	Py_RETURN_NONE;
}

static PyObject *py_winreg_OpenHKU_ndr_unpack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_in__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_winreg_OpenHKU_ndr_unpack(py_obj, &blob, NDR_IN, ndr_pull_flags, allow_remaining);
}

static PyObject *py_winreg_OpenHKU_ndr_unpack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_out__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_winreg_OpenHKU_ndr_unpack(py_obj, &blob, NDR_OUT, ndr_pull_flags, allow_remaining);
}

static PyObject *py_winreg_OpenHKU_ndr_print(PyObject *py_obj, PyObject *args, PyObject *kwargs, const char *name, ndr_flags_type ndr_inout_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct winreg_OpenHKU *object = pytalloc_get_ptr(py_obj);
	const char * const kwnames[] = { "print_secrets", NULL };
	PyObject *py_print_secrets = NULL;
	PyObject *ret;
	char *retstr;
	bool ok;

	ok = PyArg_ParseTupleAndKeywords(args, kwargs, "|O:__ndr_print__",
		discard_const_p(char *, kwnames),
		&py_print_secrets);
	if (!ok) {
		return NULL;
	}

	if (ndr_table_winreg.num_calls < 5) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_winreg_OpenHKU_ndr_print");
		return NULL;
	}
	call = &ndr_table_winreg.calls[4];

	if (py_print_secrets != NULL && PyObject_IsTrue(py_print_secrets)) {
		retstr = ndr_print_function_secret_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	} else {
		retstr = ndr_print_function_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	}
	ret = PyUnicode_FromString(retstr);
	TALLOC_FREE(retstr);

	return ret;
}

static PyObject *py_winreg_OpenHKU_ndr_print_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	return py_winreg_OpenHKU_ndr_print(py_obj, args, kwargs, "winreg_OpenHKU_in", NDR_IN);
}

static PyObject *py_winreg_OpenHKU_ndr_print_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	return py_winreg_OpenHKU_ndr_print(py_obj, args, kwargs, "winreg_OpenHKU_out", NDR_OUT);
}

static PyMethodDef py_winreg_OpenHKU_methods[] = {
	{ "opnum", (PyCFunction)py_winreg_OpenHKU_ndr_opnum, METH_NOARGS|METH_CLASS,
		"winreg.OpenHKU.opnum() -> 4 (0x04) " },
	{ "__ndr_pack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winreg_OpenHKU_ndr_pack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_in(object, bigendian=False, ndr64=False) -> blob\nNDR pack input" },
	{ "__ndr_pack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winreg_OpenHKU_ndr_pack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_out(object, bigendian=False, ndr64=False) -> blob\nNDR pack output" },
	{ "__ndr_unpack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winreg_OpenHKU_ndr_unpack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_in(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack input" },
	{ "__ndr_unpack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winreg_OpenHKU_ndr_unpack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_out(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack output" },
	{ "__ndr_print_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winreg_OpenHKU_ndr_print_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_print_in(object, print_secrets=False) -> String\nNDR print input" },
	{ "__ndr_print_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winreg_OpenHKU_ndr_print_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_print_out(object, print_secrets=False) -> String\nNDR print output" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject winreg_OpenHKU_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "winreg.OpenHKU",
	.tp_getset = py_winreg_OpenHKU_getsetters,
	.tp_methods = py_winreg_OpenHKU_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_winreg_OpenHKU_new,
};

static bool pack_py_winreg_OpenHKU_args_in(PyObject *args, PyObject *kwargs, struct winreg_OpenHKU *r)
{
	PyObject *py_system_name;
	PyObject *py_access_mask;
	const char *kwnames[] = {
		"system_name", "access_mask", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OO:winreg_OpenHKU", discard_const_p(char *, kwnames), &py_system_name, &py_access_mask)) {
		return false;
	}

	if (py_system_name == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.system_name");
		return false;
	}
	if (py_system_name == Py_None) {
		r->in.system_name = NULL;
	} else {
		r->in.system_name = talloc_ptrtype(r, r->in.system_name);
		if (r->in.system_name == NULL) {
			PyErr_NoMemory();
			return false;
		}
		{
			const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(*r->in.system_name));
			if (PyLong_Check(py_system_name)) {
				unsigned long long test_var;
				test_var = PyLong_AsUnsignedLongLong(py_system_name);
				if (PyErr_Occurred() != NULL) {
					return false;
				}
				if (test_var > uint_max) {
					PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
					  PyLong_Type.tp_name, uint_max, test_var);
					return false;
				}
				*r->in.system_name = test_var;
			} else {
				PyErr_Format(PyExc_TypeError, "Expected type %s",
				  PyLong_Type.tp_name);
				return false;
			}
		}
	}
	if (py_access_mask == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.access_mask");
		return false;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(r->in.access_mask));
		if (PyLong_Check(py_access_mask)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(py_access_mask);
			if (PyErr_Occurred() != NULL) {
				return false;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return false;
			}
			r->in.access_mask = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return false;
		}
	}
	return true;
}

static PyObject *unpack_py_winreg_OpenHKU_args_out(struct winreg_OpenHKU *r, bool raise_result_exception)
{
	PyObject *py_handle = NULL;
	PyObject *result = NULL;
	size_t result_size = 1;

	if (raise_result_exception) {
		if (!W_ERROR_IS_OK(r->out.result)) {
			PyErr_SetWERROR(r->out.result);
			return NULL;
		}

	} else {
		/* WERROR will be part of the results */
		result_size += 1;
	}

	if (result_size > 1) {
		result = PyTuple_New(result_size);
		if (result == NULL) {
			return NULL;
		}
	}

	py_handle = pytalloc_reference_ex(policy_handle_Type, r->out.handle, r->out.handle);
	if (result_size > 1) {
		PyTuple_SetItem(result, 0, py_handle);
	}
	if (result_size == 1) {
		result = py_handle;
	}

	if (!raise_result_exception) {
		PyTuple_SetItem(result, 1, PyErr_FromWERROR(r->out.result));
	}

	return result;
}


static PyObject *py_winreg_CloseKey_in_get_handle(PyObject *obj, void *closure)
{
	struct winreg_CloseKey *object = pytalloc_get_ptr(obj);
	PyObject *py_handle;
	if (object->in.handle == NULL) {
		Py_RETURN_NONE;
	}
	py_handle = pytalloc_reference_ex(policy_handle_Type, object->in.handle, object->in.handle);
	return py_handle;
}

static int py_winreg_CloseKey_in_set_handle(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winreg_CloseKey *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->in.handle));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.handle");
		return -1;
	}
	object->in.handle = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->in.handle);
	if (object->in.handle == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	PY_CHECK_TYPE(policy_handle_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->in.handle = (struct policy_handle *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_winreg_CloseKey_out_get_handle(PyObject *obj, void *closure)
{
	struct winreg_CloseKey *object = pytalloc_get_ptr(obj);
	PyObject *py_handle;
	if (object->out.handle == NULL) {
		Py_RETURN_NONE;
	}
	py_handle = pytalloc_reference_ex(policy_handle_Type, object->out.handle, object->out.handle);
	return py_handle;
}

static int py_winreg_CloseKey_out_set_handle(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winreg_CloseKey *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->out.handle));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->out.handle");
		return -1;
	}
	object->out.handle = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->out.handle);
	if (object->out.handle == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	PY_CHECK_TYPE(policy_handle_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->out.handle = (struct policy_handle *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_winreg_CloseKey_get_result(PyObject *obj, void *closure)
{
	struct winreg_CloseKey *object = pytalloc_get_ptr(obj);
	PyObject *py_result;
	py_result = PyErr_FromWERROR(object->out.result);
	return py_result;
}

static int py_winreg_CloseKey_set_result(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winreg_CloseKey *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->out.result");
		return -1;
	}
	object->out.result = W_ERROR(PyLong_AsLong(value));
	return 0;
}

static PyGetSetDef py_winreg_CloseKey_getsetters[] = {
	{
		.name = discard_const_p(char, "in_handle"),
		.get = py_winreg_CloseKey_in_get_handle,
		.set = py_winreg_CloseKey_in_set_handle,
		.doc = discard_const_p(char, "PIDL-generated element of base type policy_handle")
	},
	{
		.name = discard_const_p(char, "out_handle"),
		.get = py_winreg_CloseKey_out_get_handle,
		.set = py_winreg_CloseKey_out_set_handle,
		.doc = discard_const_p(char, "PIDL-generated element of base type policy_handle")
	},
	{
		.name = discard_const_p(char, "result"),
		.get = py_winreg_CloseKey_get_result,
		.set = py_winreg_CloseKey_set_result,
		.doc = discard_const_p(char, "PIDL-generated element of type WERROR")
	},
	{ .name = NULL }
};

static PyObject *py_winreg_CloseKey_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyObject *self = pytalloc_new(struct winreg_CloseKey, type);
	struct winreg_CloseKey *_self = (struct winreg_CloseKey *)pytalloc_get_ptr(self);
	TALLOC_CTX *mem_ctx = pytalloc_get_mem_ctx(self);
	_self->in.handle = talloc_zero(mem_ctx, struct policy_handle);
	_self->out.handle = talloc_zero(mem_ctx, struct policy_handle);
	return self;
}

static PyObject *py_winreg_CloseKey_ndr_opnum(PyTypeObject *type, PyObject *Py_UNUSED(ignored))
{


	return PyLong_FromLong(5);
}

static PyObject *py_winreg_CloseKey_ndr_pack(PyObject *py_obj, ndr_flags_type ndr_inout_flags, libndr_flags ndr_push_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct winreg_CloseKey *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	struct ndr_push *push = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;

	if (ndr_table_winreg.num_calls < 6) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_winreg_CloseKey_ndr_pack");
		return NULL;
	}
	call = &ndr_table_winreg.calls[5];

	push = ndr_push_init_ctx(pytalloc_get_mem_ctx(py_obj));
	if (push == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	push->flags |= ndr_push_flags;

	err = call->ndr_push(push, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(push);
		PyErr_SetNdrError(err);
		return NULL;
	}
	blob = ndr_push_blob(push);
	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(push);
	return ret;
}

static PyObject *py_winreg_CloseKey_ndr_pack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_in__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_winreg_CloseKey_ndr_pack(py_obj, NDR_IN, ndr_push_flags);
}

static PyObject *py_winreg_CloseKey_ndr_pack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_out__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_winreg_CloseKey_ndr_pack(py_obj, NDR_OUT, ndr_push_flags);
}

static PyObject *py_winreg_CloseKey_ndr_unpack(PyObject *py_obj, const DATA_BLOB *blob, ndr_flags_type ndr_inout_flags, libndr_flags ndr_pull_flags, bool allow_remaining)
{
	const struct ndr_interface_call *call = NULL;
	struct winreg_CloseKey *object = pytalloc_get_ptr(py_obj);
	struct ndr_pull *pull = NULL;
	enum ndr_err_code err;

	if (ndr_table_winreg.num_calls < 6) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_winreg_CloseKey_ndr_unpack");
		return NULL;
	}
	call = &ndr_table_winreg.calls[5];

	pull = ndr_pull_init_blob(blob, object);
	if (pull == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	pull->flags |= ndr_pull_flags;

	err = call->ndr_pull(pull, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(pull);
		PyErr_SetNdrError(err);
		return NULL;
	}
	if (!allow_remaining) {
		uint32_t highest_ofs;

		if (pull->offset > pull->relative_highest_offset) {
			highest_ofs = pull->offset;
		} else {
			highest_ofs = pull->relative_highest_offset;
		}
		if (highest_ofs < pull->data_size) {
			err = ndr_pull_error(pull, NDR_ERR_UNREAD_BYTES,
				"not all bytes consumed ofs[%u] size[%u]",
				highest_ofs, pull->data_size);
			TALLOC_FREE(pull);
			PyErr_SetNdrError(err);
			return NULL;
		}
	}

	TALLOC_FREE(pull);
	Py_RETURN_NONE;
}

static PyObject *py_winreg_CloseKey_ndr_unpack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_in__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_winreg_CloseKey_ndr_unpack(py_obj, &blob, NDR_IN, ndr_pull_flags, allow_remaining);
}

static PyObject *py_winreg_CloseKey_ndr_unpack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_out__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_winreg_CloseKey_ndr_unpack(py_obj, &blob, NDR_OUT, ndr_pull_flags, allow_remaining);
}

static PyObject *py_winreg_CloseKey_ndr_print(PyObject *py_obj, PyObject *args, PyObject *kwargs, const char *name, ndr_flags_type ndr_inout_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct winreg_CloseKey *object = pytalloc_get_ptr(py_obj);
	const char * const kwnames[] = { "print_secrets", NULL };
	PyObject *py_print_secrets = NULL;
	PyObject *ret;
	char *retstr;
	bool ok;

	ok = PyArg_ParseTupleAndKeywords(args, kwargs, "|O:__ndr_print__",
		discard_const_p(char *, kwnames),
		&py_print_secrets);
	if (!ok) {
		return NULL;
	}

	if (ndr_table_winreg.num_calls < 6) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_winreg_CloseKey_ndr_print");
		return NULL;
	}
	call = &ndr_table_winreg.calls[5];

	if (py_print_secrets != NULL && PyObject_IsTrue(py_print_secrets)) {
		retstr = ndr_print_function_secret_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	} else {
		retstr = ndr_print_function_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	}
	ret = PyUnicode_FromString(retstr);
	TALLOC_FREE(retstr);

	return ret;
}

static PyObject *py_winreg_CloseKey_ndr_print_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	return py_winreg_CloseKey_ndr_print(py_obj, args, kwargs, "winreg_CloseKey_in", NDR_IN);
}

static PyObject *py_winreg_CloseKey_ndr_print_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	return py_winreg_CloseKey_ndr_print(py_obj, args, kwargs, "winreg_CloseKey_out", NDR_OUT);
}

static PyMethodDef py_winreg_CloseKey_methods[] = {
	{ "opnum", (PyCFunction)py_winreg_CloseKey_ndr_opnum, METH_NOARGS|METH_CLASS,
		"winreg.CloseKey.opnum() -> 5 (0x05) " },
	{ "__ndr_pack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winreg_CloseKey_ndr_pack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_in(object, bigendian=False, ndr64=False) -> blob\nNDR pack input" },
	{ "__ndr_pack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winreg_CloseKey_ndr_pack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_out(object, bigendian=False, ndr64=False) -> blob\nNDR pack output" },
	{ "__ndr_unpack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winreg_CloseKey_ndr_unpack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_in(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack input" },
	{ "__ndr_unpack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winreg_CloseKey_ndr_unpack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_out(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack output" },
	{ "__ndr_print_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winreg_CloseKey_ndr_print_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_print_in(object, print_secrets=False) -> String\nNDR print input" },
	{ "__ndr_print_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winreg_CloseKey_ndr_print_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_print_out(object, print_secrets=False) -> String\nNDR print output" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject winreg_CloseKey_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "winreg.CloseKey",
	.tp_getset = py_winreg_CloseKey_getsetters,
	.tp_methods = py_winreg_CloseKey_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_winreg_CloseKey_new,
};

static bool pack_py_winreg_CloseKey_args_in(PyObject *args, PyObject *kwargs, struct winreg_CloseKey *r)
{
	PyObject *py_handle;
	const char *kwnames[] = {
		"handle", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "O:winreg_CloseKey", discard_const_p(char *, kwnames), &py_handle)) {
		return false;
	}

	if (py_handle == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.handle");
		return false;
	}
	r->in.handle = talloc_ptrtype(r, r->in.handle);
	if (r->in.handle == NULL) {
		PyErr_NoMemory();
		return false;
	}
	PY_CHECK_TYPE(policy_handle_Type, py_handle, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_handle)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.handle = (struct policy_handle *)pytalloc_get_ptr(py_handle);
	return true;
}

static PyObject *unpack_py_winreg_CloseKey_args_out(struct winreg_CloseKey *r, bool raise_result_exception)
{
	PyObject *py_handle = NULL;
	PyObject *result = NULL;
	size_t result_size = 1;

	if (raise_result_exception) {
		if (!W_ERROR_IS_OK(r->out.result)) {
			PyErr_SetWERROR(r->out.result);
			return NULL;
		}

	} else {
		/* WERROR will be part of the results */
		result_size += 1;
	}

	if (result_size > 1) {
		result = PyTuple_New(result_size);
		if (result == NULL) {
			return NULL;
		}
	}

	py_handle = pytalloc_reference_ex(policy_handle_Type, r->out.handle, r->out.handle);
	if (result_size > 1) {
		PyTuple_SetItem(result, 0, py_handle);
	}
	if (result_size == 1) {
		result = py_handle;
	}

	if (!raise_result_exception) {
		PyTuple_SetItem(result, 1, PyErr_FromWERROR(r->out.result));
	}

	return result;
}


static PyObject *py_winreg_CreateKey_in_get_handle(PyObject *obj, void *closure)
{
	struct winreg_CreateKey *object = pytalloc_get_ptr(obj);
	PyObject *py_handle;
	if (object->in.handle == NULL) {
		Py_RETURN_NONE;
	}
	py_handle = pytalloc_reference_ex(policy_handle_Type, object->in.handle, object->in.handle);
	return py_handle;
}

static int py_winreg_CreateKey_in_set_handle(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winreg_CreateKey *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->in.handle));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.handle");
		return -1;
	}
	object->in.handle = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->in.handle);
	if (object->in.handle == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	PY_CHECK_TYPE(policy_handle_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->in.handle = (struct policy_handle *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_winreg_CreateKey_in_get_name(PyObject *obj, void *closure)
{
	struct winreg_CreateKey *object = pytalloc_get_ptr(obj);
	PyObject *py_name;
	py_name = pytalloc_reference_ex(&winreg_String_Type, pytalloc_get_mem_ctx(obj), &object->in.name);
	return py_name;
}

static int py_winreg_CreateKey_in_set_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winreg_CreateKey *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.name");
		return -1;
	}
	PY_CHECK_TYPE(&winreg_String_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->in.name = *(struct winreg_String *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_winreg_CreateKey_in_get_keyclass(PyObject *obj, void *closure)
{
	struct winreg_CreateKey *object = pytalloc_get_ptr(obj);
	PyObject *py_keyclass;
	py_keyclass = pytalloc_reference_ex(&winreg_String_Type, pytalloc_get_mem_ctx(obj), &object->in.keyclass);
	return py_keyclass;
}

static int py_winreg_CreateKey_in_set_keyclass(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winreg_CreateKey *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.keyclass");
		return -1;
	}
	PY_CHECK_TYPE(&winreg_String_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->in.keyclass = *(struct winreg_String *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_winreg_CreateKey_in_get_options(PyObject *obj, void *closure)
{
	struct winreg_CreateKey *object = pytalloc_get_ptr(obj);
	PyObject *py_options;
	py_options = PyLong_FromUnsignedLongLong((uint32_t)(object->in.options));
	return py_options;
}

static int py_winreg_CreateKey_in_set_options(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winreg_CreateKey *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.options");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->in.options));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->in.options = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_winreg_CreateKey_in_get_access_mask(PyObject *obj, void *closure)
{
	struct winreg_CreateKey *object = pytalloc_get_ptr(obj);
	PyObject *py_access_mask;
	py_access_mask = PyLong_FromUnsignedLongLong((uint32_t)(object->in.access_mask));
	return py_access_mask;
}

static int py_winreg_CreateKey_in_set_access_mask(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winreg_CreateKey *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.access_mask");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->in.access_mask));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->in.access_mask = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_winreg_CreateKey_in_get_secdesc(PyObject *obj, void *closure)
{
	struct winreg_CreateKey *object = pytalloc_get_ptr(obj);
	PyObject *py_secdesc;
	if (object->in.secdesc == NULL) {
		Py_RETURN_NONE;
	}
	if (object->in.secdesc == NULL) {
		py_secdesc = Py_None;
		Py_INCREF(py_secdesc);
	} else {
		py_secdesc = pytalloc_reference_ex(&winreg_SecBuf_Type, object->in.secdesc, object->in.secdesc);
	}
	return py_secdesc;
}

static int py_winreg_CreateKey_in_set_secdesc(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winreg_CreateKey *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->in.secdesc));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.secdesc");
		return -1;
	}
	if (value == Py_None) {
		object->in.secdesc = NULL;
	} else {
		object->in.secdesc = NULL;
		PY_CHECK_TYPE(&winreg_SecBuf_Type, value, return -1;);
		if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->in.secdesc = (struct winreg_SecBuf *)pytalloc_get_ptr(value);
	}
	return 0;
}

static PyObject *py_winreg_CreateKey_out_get_new_handle(PyObject *obj, void *closure)
{
	struct winreg_CreateKey *object = pytalloc_get_ptr(obj);
	PyObject *py_new_handle;
	if (object->out.new_handle == NULL) {
		Py_RETURN_NONE;
	}
	py_new_handle = pytalloc_reference_ex(policy_handle_Type, object->out.new_handle, object->out.new_handle);
	return py_new_handle;
}

static int py_winreg_CreateKey_out_set_new_handle(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winreg_CreateKey *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->out.new_handle));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->out.new_handle");
		return -1;
	}
	object->out.new_handle = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->out.new_handle);
	if (object->out.new_handle == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	PY_CHECK_TYPE(policy_handle_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->out.new_handle = (struct policy_handle *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_winreg_CreateKey_in_get_action_taken(PyObject *obj, void *closure)
{
	struct winreg_CreateKey *object = pytalloc_get_ptr(obj);
	PyObject *py_action_taken;
	if (object->in.action_taken == NULL) {
		Py_RETURN_NONE;
	}
	if (object->in.action_taken == NULL) {
		py_action_taken = Py_None;
		Py_INCREF(py_action_taken);
	} else {
		py_action_taken = PyLong_FromUnsignedLongLong((uint32_t)(*object->in.action_taken));
	}
	return py_action_taken;
}

static int py_winreg_CreateKey_in_set_action_taken(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winreg_CreateKey *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->in.action_taken));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.action_taken");
		return -1;
	}
	if (value == Py_None) {
		object->in.action_taken = NULL;
	} else {
		object->in.action_taken = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->in.action_taken);
		if (object->in.action_taken == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		{
			const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(*object->in.action_taken));
			if (PyLong_Check(value)) {
				unsigned long long test_var;
				test_var = PyLong_AsUnsignedLongLong(value);
				if (PyErr_Occurred() != NULL) {
					return -1;
				}
				if (test_var > uint_max) {
					PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
					  PyLong_Type.tp_name, uint_max, test_var);
					return -1;
				}
				*object->in.action_taken = test_var;
			} else {
				PyErr_Format(PyExc_TypeError, "Expected type %s",
				  PyLong_Type.tp_name);
				return -1;
			}
		}
	}
	return 0;
}

static PyObject *py_winreg_CreateKey_out_get_action_taken(PyObject *obj, void *closure)
{
	struct winreg_CreateKey *object = pytalloc_get_ptr(obj);
	PyObject *py_action_taken;
	if (object->out.action_taken == NULL) {
		Py_RETURN_NONE;
	}
	if (object->out.action_taken == NULL) {
		py_action_taken = Py_None;
		Py_INCREF(py_action_taken);
	} else {
		py_action_taken = PyLong_FromUnsignedLongLong((uint32_t)(*object->out.action_taken));
	}
	return py_action_taken;
}

static int py_winreg_CreateKey_out_set_action_taken(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winreg_CreateKey *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->out.action_taken));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->out.action_taken");
		return -1;
	}
	if (value == Py_None) {
		object->out.action_taken = NULL;
	} else {
		object->out.action_taken = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->out.action_taken);
		if (object->out.action_taken == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		{
			const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(*object->out.action_taken));
			if (PyLong_Check(value)) {
				unsigned long long test_var;
				test_var = PyLong_AsUnsignedLongLong(value);
				if (PyErr_Occurred() != NULL) {
					return -1;
				}
				if (test_var > uint_max) {
					PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
					  PyLong_Type.tp_name, uint_max, test_var);
					return -1;
				}
				*object->out.action_taken = test_var;
			} else {
				PyErr_Format(PyExc_TypeError, "Expected type %s",
				  PyLong_Type.tp_name);
				return -1;
			}
		}
	}
	return 0;
}

static PyObject *py_winreg_CreateKey_get_result(PyObject *obj, void *closure)
{
	struct winreg_CreateKey *object = pytalloc_get_ptr(obj);
	PyObject *py_result;
	py_result = PyErr_FromWERROR(object->out.result);
	return py_result;
}

static int py_winreg_CreateKey_set_result(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winreg_CreateKey *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->out.result");
		return -1;
	}
	object->out.result = W_ERROR(PyLong_AsLong(value));
	return 0;
}

static PyGetSetDef py_winreg_CreateKey_getsetters[] = {
	{
		.name = discard_const_p(char, "in_handle"),
		.get = py_winreg_CreateKey_in_get_handle,
		.set = py_winreg_CreateKey_in_set_handle,
		.doc = discard_const_p(char, "PIDL-generated element of base type policy_handle")
	},
	{
		.name = discard_const_p(char, "in_name"),
		.get = py_winreg_CreateKey_in_get_name,
		.set = py_winreg_CreateKey_in_set_name,
		.doc = discard_const_p(char, "PIDL-generated element of base type winreg_String")
	},
	{
		.name = discard_const_p(char, "in_keyclass"),
		.get = py_winreg_CreateKey_in_get_keyclass,
		.set = py_winreg_CreateKey_in_set_keyclass,
		.doc = discard_const_p(char, "PIDL-generated element of base type winreg_String")
	},
	{
		.name = discard_const_p(char, "in_options"),
		.get = py_winreg_CreateKey_in_get_options,
		.set = py_winreg_CreateKey_in_set_options,
		.doc = discard_const_p(char, "PIDL-generated element of base type winreg_KeyOptions")
	},
	{
		.name = discard_const_p(char, "in_access_mask"),
		.get = py_winreg_CreateKey_in_get_access_mask,
		.set = py_winreg_CreateKey_in_set_access_mask,
		.doc = discard_const_p(char, "PIDL-generated element of base type winreg_AccessMask")
	},
	{
		.name = discard_const_p(char, "in_secdesc"),
		.get = py_winreg_CreateKey_in_get_secdesc,
		.set = py_winreg_CreateKey_in_set_secdesc,
		.doc = discard_const_p(char, "PIDL-generated element of base type winreg_SecBuf")
	},
	{
		.name = discard_const_p(char, "out_new_handle"),
		.get = py_winreg_CreateKey_out_get_new_handle,
		.set = py_winreg_CreateKey_out_set_new_handle,
		.doc = discard_const_p(char, "PIDL-generated element of base type policy_handle")
	},
	{
		.name = discard_const_p(char, "in_action_taken"),
		.get = py_winreg_CreateKey_in_get_action_taken,
		.set = py_winreg_CreateKey_in_set_action_taken,
		.doc = discard_const_p(char, "PIDL-generated element of base type winreg_CreateAction")
	},
	{
		.name = discard_const_p(char, "out_action_taken"),
		.get = py_winreg_CreateKey_out_get_action_taken,
		.set = py_winreg_CreateKey_out_set_action_taken,
		.doc = discard_const_p(char, "PIDL-generated element of base type winreg_CreateAction")
	},
	{
		.name = discard_const_p(char, "result"),
		.get = py_winreg_CreateKey_get_result,
		.set = py_winreg_CreateKey_set_result,
		.doc = discard_const_p(char, "PIDL-generated element of type WERROR")
	},
	{ .name = NULL }
};

static PyObject *py_winreg_CreateKey_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyObject *self = pytalloc_new(struct winreg_CreateKey, type);
	struct winreg_CreateKey *_self = (struct winreg_CreateKey *)pytalloc_get_ptr(self);
	TALLOC_CTX *mem_ctx = pytalloc_get_mem_ctx(self);
	_self->in.handle = talloc_zero(mem_ctx, struct policy_handle);
	_self->out.new_handle = talloc_zero(mem_ctx, struct policy_handle);
	return self;
}

static PyObject *py_winreg_CreateKey_ndr_opnum(PyTypeObject *type, PyObject *Py_UNUSED(ignored))
{


	return PyLong_FromLong(6);
}

static PyObject *py_winreg_CreateKey_ndr_pack(PyObject *py_obj, ndr_flags_type ndr_inout_flags, libndr_flags ndr_push_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct winreg_CreateKey *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	struct ndr_push *push = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;

	if (ndr_table_winreg.num_calls < 7) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_winreg_CreateKey_ndr_pack");
		return NULL;
	}
	call = &ndr_table_winreg.calls[6];

	push = ndr_push_init_ctx(pytalloc_get_mem_ctx(py_obj));
	if (push == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	push->flags |= ndr_push_flags;

	err = call->ndr_push(push, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(push);
		PyErr_SetNdrError(err);
		return NULL;
	}
	blob = ndr_push_blob(push);
	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(push);
	return ret;
}

static PyObject *py_winreg_CreateKey_ndr_pack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_in__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_winreg_CreateKey_ndr_pack(py_obj, NDR_IN, ndr_push_flags);
}

static PyObject *py_winreg_CreateKey_ndr_pack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_out__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_winreg_CreateKey_ndr_pack(py_obj, NDR_OUT, ndr_push_flags);
}

static PyObject *py_winreg_CreateKey_ndr_unpack(PyObject *py_obj, const DATA_BLOB *blob, ndr_flags_type ndr_inout_flags, libndr_flags ndr_pull_flags, bool allow_remaining)
{
	const struct ndr_interface_call *call = NULL;
	struct winreg_CreateKey *object = pytalloc_get_ptr(py_obj);
	struct ndr_pull *pull = NULL;
	enum ndr_err_code err;

	if (ndr_table_winreg.num_calls < 7) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_winreg_CreateKey_ndr_unpack");
		return NULL;
	}
	call = &ndr_table_winreg.calls[6];

	pull = ndr_pull_init_blob(blob, object);
	if (pull == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	pull->flags |= ndr_pull_flags;

	err = call->ndr_pull(pull, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(pull);
		PyErr_SetNdrError(err);
		return NULL;
	}
	if (!allow_remaining) {
		uint32_t highest_ofs;

		if (pull->offset > pull->relative_highest_offset) {
			highest_ofs = pull->offset;
		} else {
			highest_ofs = pull->relative_highest_offset;
		}
		if (highest_ofs < pull->data_size) {
			err = ndr_pull_error(pull, NDR_ERR_UNREAD_BYTES,
				"not all bytes consumed ofs[%u] size[%u]",
				highest_ofs, pull->data_size);
			TALLOC_FREE(pull);
			PyErr_SetNdrError(err);
			return NULL;
		}
	}

	TALLOC_FREE(pull);
	Py_RETURN_NONE;
}

static PyObject *py_winreg_CreateKey_ndr_unpack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_in__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_winreg_CreateKey_ndr_unpack(py_obj, &blob, NDR_IN, ndr_pull_flags, allow_remaining);
}

static PyObject *py_winreg_CreateKey_ndr_unpack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_out__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_winreg_CreateKey_ndr_unpack(py_obj, &blob, NDR_OUT, ndr_pull_flags, allow_remaining);
}

static PyObject *py_winreg_CreateKey_ndr_print(PyObject *py_obj, PyObject *args, PyObject *kwargs, const char *name, ndr_flags_type ndr_inout_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct winreg_CreateKey *object = pytalloc_get_ptr(py_obj);
	const char * const kwnames[] = { "print_secrets", NULL };
	PyObject *py_print_secrets = NULL;
	PyObject *ret;
	char *retstr;
	bool ok;

	ok = PyArg_ParseTupleAndKeywords(args, kwargs, "|O:__ndr_print__",
		discard_const_p(char *, kwnames),
		&py_print_secrets);
	if (!ok) {
		return NULL;
	}

	if (ndr_table_winreg.num_calls < 7) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_winreg_CreateKey_ndr_print");
		return NULL;
	}
	call = &ndr_table_winreg.calls[6];

	if (py_print_secrets != NULL && PyObject_IsTrue(py_print_secrets)) {
		retstr = ndr_print_function_secret_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	} else {
		retstr = ndr_print_function_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	}
	ret = PyUnicode_FromString(retstr);
	TALLOC_FREE(retstr);

	return ret;
}

static PyObject *py_winreg_CreateKey_ndr_print_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	return py_winreg_CreateKey_ndr_print(py_obj, args, kwargs, "winreg_CreateKey_in", NDR_IN);
}

static PyObject *py_winreg_CreateKey_ndr_print_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	return py_winreg_CreateKey_ndr_print(py_obj, args, kwargs, "winreg_CreateKey_out", NDR_OUT);
}

static PyMethodDef py_winreg_CreateKey_methods[] = {
	{ "opnum", (PyCFunction)py_winreg_CreateKey_ndr_opnum, METH_NOARGS|METH_CLASS,
		"winreg.CreateKey.opnum() -> 6 (0x06) " },
	{ "__ndr_pack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winreg_CreateKey_ndr_pack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_in(object, bigendian=False, ndr64=False) -> blob\nNDR pack input" },
	{ "__ndr_pack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winreg_CreateKey_ndr_pack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_out(object, bigendian=False, ndr64=False) -> blob\nNDR pack output" },
	{ "__ndr_unpack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winreg_CreateKey_ndr_unpack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_in(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack input" },
	{ "__ndr_unpack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winreg_CreateKey_ndr_unpack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_out(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack output" },
	{ "__ndr_print_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winreg_CreateKey_ndr_print_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_print_in(object, print_secrets=False) -> String\nNDR print input" },
	{ "__ndr_print_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winreg_CreateKey_ndr_print_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_print_out(object, print_secrets=False) -> String\nNDR print output" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject winreg_CreateKey_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "winreg.CreateKey",
	.tp_getset = py_winreg_CreateKey_getsetters,
	.tp_methods = py_winreg_CreateKey_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_winreg_CreateKey_new,
};

static bool pack_py_winreg_CreateKey_args_in(PyObject *args, PyObject *kwargs, struct winreg_CreateKey *r)
{
	PyObject *py_handle;
	PyObject *py_name;
	PyObject *py_keyclass;
	PyObject *py_options;
	PyObject *py_access_mask;
	PyObject *py_secdesc;
	PyObject *py_action_taken;
	const char *kwnames[] = {
		"handle", "name", "keyclass", "options", "access_mask", "secdesc", "action_taken", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOOOOOO:winreg_CreateKey", discard_const_p(char *, kwnames), &py_handle, &py_name, &py_keyclass, &py_options, &py_access_mask, &py_secdesc, &py_action_taken)) {
		return false;
	}

	if (py_handle == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.handle");
		return false;
	}
	r->in.handle = talloc_ptrtype(r, r->in.handle);
	if (r->in.handle == NULL) {
		PyErr_NoMemory();
		return false;
	}
	PY_CHECK_TYPE(policy_handle_Type, py_handle, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_handle)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.handle = (struct policy_handle *)pytalloc_get_ptr(py_handle);
	if (py_name == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.name");
		return false;
	}
	PY_CHECK_TYPE(&winreg_String_Type, py_name, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_name)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.name = *(struct winreg_String *)pytalloc_get_ptr(py_name);
	if (py_keyclass == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.keyclass");
		return false;
	}
	PY_CHECK_TYPE(&winreg_String_Type, py_keyclass, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_keyclass)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.keyclass = *(struct winreg_String *)pytalloc_get_ptr(py_keyclass);
	if (py_options == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.options");
		return false;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(r->in.options));
		if (PyLong_Check(py_options)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(py_options);
			if (PyErr_Occurred() != NULL) {
				return false;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return false;
			}
			r->in.options = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return false;
		}
	}
	if (py_access_mask == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.access_mask");
		return false;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(r->in.access_mask));
		if (PyLong_Check(py_access_mask)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(py_access_mask);
			if (PyErr_Occurred() != NULL) {
				return false;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return false;
			}
			r->in.access_mask = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return false;
		}
	}
	if (py_secdesc == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.secdesc");
		return false;
	}
	if (py_secdesc == Py_None) {
		r->in.secdesc = NULL;
	} else {
		r->in.secdesc = NULL;
		PY_CHECK_TYPE(&winreg_SecBuf_Type, py_secdesc, return false;);
		if (talloc_reference(r, pytalloc_get_mem_ctx(py_secdesc)) == NULL) {
			PyErr_NoMemory();
			return false;
		}
		r->in.secdesc = (struct winreg_SecBuf *)pytalloc_get_ptr(py_secdesc);
	}
	if (py_action_taken == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.action_taken");
		return false;
	}
	if (py_action_taken == Py_None) {
		r->in.action_taken = NULL;
	} else {
		r->in.action_taken = talloc_ptrtype(r, r->in.action_taken);
		if (r->in.action_taken == NULL) {
			PyErr_NoMemory();
			return false;
		}
		{
			const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(*r->in.action_taken));
			if (PyLong_Check(py_action_taken)) {
				unsigned long long test_var;
				test_var = PyLong_AsUnsignedLongLong(py_action_taken);
				if (PyErr_Occurred() != NULL) {
					return false;
				}
				if (test_var > uint_max) {
					PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
					  PyLong_Type.tp_name, uint_max, test_var);
					return false;
				}
				*r->in.action_taken = test_var;
			} else {
				PyErr_Format(PyExc_TypeError, "Expected type %s",
				  PyLong_Type.tp_name);
				return false;
			}
		}
	}
	return true;
}

static PyObject *unpack_py_winreg_CreateKey_args_out(struct winreg_CreateKey *r, bool raise_result_exception)
{
	PyObject *py_new_handle = NULL;
	PyObject *py_action_taken = NULL;
	PyObject *result = NULL;
	size_t result_size = 2;

	if (raise_result_exception) {
		if (!W_ERROR_IS_OK(r->out.result)) {
			PyErr_SetWERROR(r->out.result);
			return NULL;
		}

	} else {
		/* WERROR will be part of the results */
		result_size += 1;
	}

	if (result_size > 1) {
		result = PyTuple_New(result_size);
		if (result == NULL) {
			return NULL;
		}
	}

	py_new_handle = pytalloc_reference_ex(policy_handle_Type, r->out.new_handle, r->out.new_handle);
	PyTuple_SetItem(result, 0, py_new_handle);

	if (r->out.action_taken == NULL) {
		py_action_taken = Py_None;
		Py_INCREF(py_action_taken);
	} else {
		py_action_taken = PyLong_FromUnsignedLongLong((uint32_t)(*r->out.action_taken));
	}
	PyTuple_SetItem(result, 1, py_action_taken);

	if (!raise_result_exception) {
		PyTuple_SetItem(result, 2, PyErr_FromWERROR(r->out.result));
	}

	return result;
}


static PyObject *py_winreg_DeleteKey_in_get_handle(PyObject *obj, void *closure)
{
	struct winreg_DeleteKey *object = pytalloc_get_ptr(obj);
	PyObject *py_handle;
	if (object->in.handle == NULL) {
		Py_RETURN_NONE;
	}
	py_handle = pytalloc_reference_ex(policy_handle_Type, object->in.handle, object->in.handle);
	return py_handle;
}

static int py_winreg_DeleteKey_in_set_handle(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winreg_DeleteKey *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->in.handle));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.handle");
		return -1;
	}
	object->in.handle = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->in.handle);
	if (object->in.handle == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	PY_CHECK_TYPE(policy_handle_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->in.handle = (struct policy_handle *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_winreg_DeleteKey_in_get_key(PyObject *obj, void *closure)
{
	struct winreg_DeleteKey *object = pytalloc_get_ptr(obj);
	PyObject *py_key;
	py_key = pytalloc_reference_ex(&winreg_String_Type, pytalloc_get_mem_ctx(obj), &object->in.key);
	return py_key;
}

static int py_winreg_DeleteKey_in_set_key(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winreg_DeleteKey *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.key");
		return -1;
	}
	PY_CHECK_TYPE(&winreg_String_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->in.key = *(struct winreg_String *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_winreg_DeleteKey_get_result(PyObject *obj, void *closure)
{
	struct winreg_DeleteKey *object = pytalloc_get_ptr(obj);
	PyObject *py_result;
	py_result = PyErr_FromWERROR(object->out.result);
	return py_result;
}

static int py_winreg_DeleteKey_set_result(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winreg_DeleteKey *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->out.result");
		return -1;
	}
	object->out.result = W_ERROR(PyLong_AsLong(value));
	return 0;
}

static PyGetSetDef py_winreg_DeleteKey_getsetters[] = {
	{
		.name = discard_const_p(char, "in_handle"),
		.get = py_winreg_DeleteKey_in_get_handle,
		.set = py_winreg_DeleteKey_in_set_handle,
		.doc = discard_const_p(char, "PIDL-generated element of base type policy_handle")
	},
	{
		.name = discard_const_p(char, "in_key"),
		.get = py_winreg_DeleteKey_in_get_key,
		.set = py_winreg_DeleteKey_in_set_key,
		.doc = discard_const_p(char, "PIDL-generated element of base type winreg_String")
	},
	{
		.name = discard_const_p(char, "result"),
		.get = py_winreg_DeleteKey_get_result,
		.set = py_winreg_DeleteKey_set_result,
		.doc = discard_const_p(char, "PIDL-generated element of type WERROR")
	},
	{ .name = NULL }
};

static PyObject *py_winreg_DeleteKey_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyObject *self = pytalloc_new(struct winreg_DeleteKey, type);
	struct winreg_DeleteKey *_self = (struct winreg_DeleteKey *)pytalloc_get_ptr(self);
	TALLOC_CTX *mem_ctx = pytalloc_get_mem_ctx(self);
	_self->in.handle = talloc_zero(mem_ctx, struct policy_handle);
	return self;
}

static PyObject *py_winreg_DeleteKey_ndr_opnum(PyTypeObject *type, PyObject *Py_UNUSED(ignored))
{


	return PyLong_FromLong(7);
}

static PyObject *py_winreg_DeleteKey_ndr_pack(PyObject *py_obj, ndr_flags_type ndr_inout_flags, libndr_flags ndr_push_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct winreg_DeleteKey *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	struct ndr_push *push = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;

	if (ndr_table_winreg.num_calls < 8) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_winreg_DeleteKey_ndr_pack");
		return NULL;
	}
	call = &ndr_table_winreg.calls[7];

	push = ndr_push_init_ctx(pytalloc_get_mem_ctx(py_obj));
	if (push == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	push->flags |= ndr_push_flags;

	err = call->ndr_push(push, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(push);
		PyErr_SetNdrError(err);
		return NULL;
	}
	blob = ndr_push_blob(push);
	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(push);
	return ret;
}

static PyObject *py_winreg_DeleteKey_ndr_pack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_in__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_winreg_DeleteKey_ndr_pack(py_obj, NDR_IN, ndr_push_flags);
}

static PyObject *py_winreg_DeleteKey_ndr_pack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_out__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_winreg_DeleteKey_ndr_pack(py_obj, NDR_OUT, ndr_push_flags);
}

static PyObject *py_winreg_DeleteKey_ndr_unpack(PyObject *py_obj, const DATA_BLOB *blob, ndr_flags_type ndr_inout_flags, libndr_flags ndr_pull_flags, bool allow_remaining)
{
	const struct ndr_interface_call *call = NULL;
	struct winreg_DeleteKey *object = pytalloc_get_ptr(py_obj);
	struct ndr_pull *pull = NULL;
	enum ndr_err_code err;

	if (ndr_table_winreg.num_calls < 8) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_winreg_DeleteKey_ndr_unpack");
		return NULL;
	}
	call = &ndr_table_winreg.calls[7];

	pull = ndr_pull_init_blob(blob, object);
	if (pull == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	pull->flags |= ndr_pull_flags;

	err = call->ndr_pull(pull, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(pull);
		PyErr_SetNdrError(err);
		return NULL;
	}
	if (!allow_remaining) {
		uint32_t highest_ofs;

		if (pull->offset > pull->relative_highest_offset) {
			highest_ofs = pull->offset;
		} else {
			highest_ofs = pull->relative_highest_offset;
		}
		if (highest_ofs < pull->data_size) {
			err = ndr_pull_error(pull, NDR_ERR_UNREAD_BYTES,
				"not all bytes consumed ofs[%u] size[%u]",
				highest_ofs, pull->data_size);
			TALLOC_FREE(pull);
			PyErr_SetNdrError(err);
			return NULL;
		}
	}

	TALLOC_FREE(pull);
	Py_RETURN_NONE;
}

static PyObject *py_winreg_DeleteKey_ndr_unpack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_in__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_winreg_DeleteKey_ndr_unpack(py_obj, &blob, NDR_IN, ndr_pull_flags, allow_remaining);
}

static PyObject *py_winreg_DeleteKey_ndr_unpack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_out__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_winreg_DeleteKey_ndr_unpack(py_obj, &blob, NDR_OUT, ndr_pull_flags, allow_remaining);
}

static PyObject *py_winreg_DeleteKey_ndr_print(PyObject *py_obj, PyObject *args, PyObject *kwargs, const char *name, ndr_flags_type ndr_inout_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct winreg_DeleteKey *object = pytalloc_get_ptr(py_obj);
	const char * const kwnames[] = { "print_secrets", NULL };
	PyObject *py_print_secrets = NULL;
	PyObject *ret;
	char *retstr;
	bool ok;

	ok = PyArg_ParseTupleAndKeywords(args, kwargs, "|O:__ndr_print__",
		discard_const_p(char *, kwnames),
		&py_print_secrets);
	if (!ok) {
		return NULL;
	}

	if (ndr_table_winreg.num_calls < 8) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_winreg_DeleteKey_ndr_print");
		return NULL;
	}
	call = &ndr_table_winreg.calls[7];

	if (py_print_secrets != NULL && PyObject_IsTrue(py_print_secrets)) {
		retstr = ndr_print_function_secret_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	} else {
		retstr = ndr_print_function_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	}
	ret = PyUnicode_FromString(retstr);
	TALLOC_FREE(retstr);

	return ret;
}

static PyObject *py_winreg_DeleteKey_ndr_print_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	return py_winreg_DeleteKey_ndr_print(py_obj, args, kwargs, "winreg_DeleteKey_in", NDR_IN);
}

static PyObject *py_winreg_DeleteKey_ndr_print_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	return py_winreg_DeleteKey_ndr_print(py_obj, args, kwargs, "winreg_DeleteKey_out", NDR_OUT);
}

static PyMethodDef py_winreg_DeleteKey_methods[] = {
	{ "opnum", (PyCFunction)py_winreg_DeleteKey_ndr_opnum, METH_NOARGS|METH_CLASS,
		"winreg.DeleteKey.opnum() -> 7 (0x07) " },
	{ "__ndr_pack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winreg_DeleteKey_ndr_pack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_in(object, bigendian=False, ndr64=False) -> blob\nNDR pack input" },
	{ "__ndr_pack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winreg_DeleteKey_ndr_pack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_out(object, bigendian=False, ndr64=False) -> blob\nNDR pack output" },
	{ "__ndr_unpack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winreg_DeleteKey_ndr_unpack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_in(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack input" },
	{ "__ndr_unpack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winreg_DeleteKey_ndr_unpack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_out(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack output" },
	{ "__ndr_print_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winreg_DeleteKey_ndr_print_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_print_in(object, print_secrets=False) -> String\nNDR print input" },
	{ "__ndr_print_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winreg_DeleteKey_ndr_print_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_print_out(object, print_secrets=False) -> String\nNDR print output" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject winreg_DeleteKey_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "winreg.DeleteKey",
	.tp_getset = py_winreg_DeleteKey_getsetters,
	.tp_methods = py_winreg_DeleteKey_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_winreg_DeleteKey_new,
};

static bool pack_py_winreg_DeleteKey_args_in(PyObject *args, PyObject *kwargs, struct winreg_DeleteKey *r)
{
	PyObject *py_handle;
	PyObject *py_key;
	const char *kwnames[] = {
		"handle", "key", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OO:winreg_DeleteKey", discard_const_p(char *, kwnames), &py_handle, &py_key)) {
		return false;
	}

	if (py_handle == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.handle");
		return false;
	}
	r->in.handle = talloc_ptrtype(r, r->in.handle);
	if (r->in.handle == NULL) {
		PyErr_NoMemory();
		return false;
	}
	PY_CHECK_TYPE(policy_handle_Type, py_handle, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_handle)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.handle = (struct policy_handle *)pytalloc_get_ptr(py_handle);
	if (py_key == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.key");
		return false;
	}
	PY_CHECK_TYPE(&winreg_String_Type, py_key, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_key)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.key = *(struct winreg_String *)pytalloc_get_ptr(py_key);
	return true;
}

static PyObject *unpack_py_winreg_DeleteKey_args_out(struct winreg_DeleteKey *r, bool raise_result_exception)
{
	PyObject *result = NULL;
	size_t result_size = 0;

	if (raise_result_exception) {
		if (!W_ERROR_IS_OK(r->out.result)) {
			PyErr_SetWERROR(r->out.result);
			return NULL;
		}

	} else {
		/* WERROR will be part of the results */
		result_size += 1;
	}

	if (!raise_result_exception) {
		result = PyErr_FromWERROR(r->out.result);
	}

	if (result_size == 0) {
		result = Py_None;
		Py_INCREF(result);
	}

	return result;
}


static PyObject *py_winreg_DeleteValue_in_get_handle(PyObject *obj, void *closure)
{
	struct winreg_DeleteValue *object = pytalloc_get_ptr(obj);
	PyObject *py_handle;
	if (object->in.handle == NULL) {
		Py_RETURN_NONE;
	}
	py_handle = pytalloc_reference_ex(policy_handle_Type, object->in.handle, object->in.handle);
	return py_handle;
}

static int py_winreg_DeleteValue_in_set_handle(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winreg_DeleteValue *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->in.handle));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.handle");
		return -1;
	}
	object->in.handle = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->in.handle);
	if (object->in.handle == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	PY_CHECK_TYPE(policy_handle_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->in.handle = (struct policy_handle *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_winreg_DeleteValue_in_get_value(PyObject *obj, void *closure)
{
	struct winreg_DeleteValue *object = pytalloc_get_ptr(obj);
	PyObject *py_value;
	py_value = pytalloc_reference_ex(&winreg_String_Type, pytalloc_get_mem_ctx(obj), &object->in.value);
	return py_value;
}

static int py_winreg_DeleteValue_in_set_value(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winreg_DeleteValue *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.value");
		return -1;
	}
	PY_CHECK_TYPE(&winreg_String_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->in.value = *(struct winreg_String *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_winreg_DeleteValue_get_result(PyObject *obj, void *closure)
{
	struct winreg_DeleteValue *object = pytalloc_get_ptr(obj);
	PyObject *py_result;
	py_result = PyErr_FromWERROR(object->out.result);
	return py_result;
}

static int py_winreg_DeleteValue_set_result(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winreg_DeleteValue *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->out.result");
		return -1;
	}
	object->out.result = W_ERROR(PyLong_AsLong(value));
	return 0;
}

static PyGetSetDef py_winreg_DeleteValue_getsetters[] = {
	{
		.name = discard_const_p(char, "in_handle"),
		.get = py_winreg_DeleteValue_in_get_handle,
		.set = py_winreg_DeleteValue_in_set_handle,
		.doc = discard_const_p(char, "PIDL-generated element of base type policy_handle")
	},
	{
		.name = discard_const_p(char, "in_value"),
		.get = py_winreg_DeleteValue_in_get_value,
		.set = py_winreg_DeleteValue_in_set_value,
		.doc = discard_const_p(char, "PIDL-generated element of base type winreg_String")
	},
	{
		.name = discard_const_p(char, "result"),
		.get = py_winreg_DeleteValue_get_result,
		.set = py_winreg_DeleteValue_set_result,
		.doc = discard_const_p(char, "PIDL-generated element of type WERROR")
	},
	{ .name = NULL }
};

static PyObject *py_winreg_DeleteValue_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyObject *self = pytalloc_new(struct winreg_DeleteValue, type);
	struct winreg_DeleteValue *_self = (struct winreg_DeleteValue *)pytalloc_get_ptr(self);
	TALLOC_CTX *mem_ctx = pytalloc_get_mem_ctx(self);
	_self->in.handle = talloc_zero(mem_ctx, struct policy_handle);
	return self;
}

static PyObject *py_winreg_DeleteValue_ndr_opnum(PyTypeObject *type, PyObject *Py_UNUSED(ignored))
{


	return PyLong_FromLong(8);
}

static PyObject *py_winreg_DeleteValue_ndr_pack(PyObject *py_obj, ndr_flags_type ndr_inout_flags, libndr_flags ndr_push_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct winreg_DeleteValue *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	struct ndr_push *push = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;

	if (ndr_table_winreg.num_calls < 9) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_winreg_DeleteValue_ndr_pack");
		return NULL;
	}
	call = &ndr_table_winreg.calls[8];

	push = ndr_push_init_ctx(pytalloc_get_mem_ctx(py_obj));
	if (push == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	push->flags |= ndr_push_flags;

	err = call->ndr_push(push, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(push);
		PyErr_SetNdrError(err);
		return NULL;
	}
	blob = ndr_push_blob(push);
	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(push);
	return ret;
}

static PyObject *py_winreg_DeleteValue_ndr_pack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_in__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_winreg_DeleteValue_ndr_pack(py_obj, NDR_IN, ndr_push_flags);
}

static PyObject *py_winreg_DeleteValue_ndr_pack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_out__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_winreg_DeleteValue_ndr_pack(py_obj, NDR_OUT, ndr_push_flags);
}

static PyObject *py_winreg_DeleteValue_ndr_unpack(PyObject *py_obj, const DATA_BLOB *blob, ndr_flags_type ndr_inout_flags, libndr_flags ndr_pull_flags, bool allow_remaining)
{
	const struct ndr_interface_call *call = NULL;
	struct winreg_DeleteValue *object = pytalloc_get_ptr(py_obj);
	struct ndr_pull *pull = NULL;
	enum ndr_err_code err;

	if (ndr_table_winreg.num_calls < 9) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_winreg_DeleteValue_ndr_unpack");
		return NULL;
	}
	call = &ndr_table_winreg.calls[8];

	pull = ndr_pull_init_blob(blob, object);
	if (pull == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	pull->flags |= ndr_pull_flags;

	err = call->ndr_pull(pull, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(pull);
		PyErr_SetNdrError(err);
		return NULL;
	}
	if (!allow_remaining) {
		uint32_t highest_ofs;

		if (pull->offset > pull->relative_highest_offset) {
			highest_ofs = pull->offset;
		} else {
			highest_ofs = pull->relative_highest_offset;
		}
		if (highest_ofs < pull->data_size) {
			err = ndr_pull_error(pull, NDR_ERR_UNREAD_BYTES,
				"not all bytes consumed ofs[%u] size[%u]",
				highest_ofs, pull->data_size);
			TALLOC_FREE(pull);
			PyErr_SetNdrError(err);
			return NULL;
		}
	}

	TALLOC_FREE(pull);
	Py_RETURN_NONE;
}

static PyObject *py_winreg_DeleteValue_ndr_unpack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_in__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_winreg_DeleteValue_ndr_unpack(py_obj, &blob, NDR_IN, ndr_pull_flags, allow_remaining);
}

static PyObject *py_winreg_DeleteValue_ndr_unpack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_out__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_winreg_DeleteValue_ndr_unpack(py_obj, &blob, NDR_OUT, ndr_pull_flags, allow_remaining);
}

static PyObject *py_winreg_DeleteValue_ndr_print(PyObject *py_obj, PyObject *args, PyObject *kwargs, const char *name, ndr_flags_type ndr_inout_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct winreg_DeleteValue *object = pytalloc_get_ptr(py_obj);
	const char * const kwnames[] = { "print_secrets", NULL };
	PyObject *py_print_secrets = NULL;
	PyObject *ret;
	char *retstr;
	bool ok;

	ok = PyArg_ParseTupleAndKeywords(args, kwargs, "|O:__ndr_print__",
		discard_const_p(char *, kwnames),
		&py_print_secrets);
	if (!ok) {
		return NULL;
	}

	if (ndr_table_winreg.num_calls < 9) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_winreg_DeleteValue_ndr_print");
		return NULL;
	}
	call = &ndr_table_winreg.calls[8];

	if (py_print_secrets != NULL && PyObject_IsTrue(py_print_secrets)) {
		retstr = ndr_print_function_secret_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	} else {
		retstr = ndr_print_function_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	}
	ret = PyUnicode_FromString(retstr);
	TALLOC_FREE(retstr);

	return ret;
}

static PyObject *py_winreg_DeleteValue_ndr_print_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	return py_winreg_DeleteValue_ndr_print(py_obj, args, kwargs, "winreg_DeleteValue_in", NDR_IN);
}

static PyObject *py_winreg_DeleteValue_ndr_print_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	return py_winreg_DeleteValue_ndr_print(py_obj, args, kwargs, "winreg_DeleteValue_out", NDR_OUT);
}

static PyMethodDef py_winreg_DeleteValue_methods[] = {
	{ "opnum", (PyCFunction)py_winreg_DeleteValue_ndr_opnum, METH_NOARGS|METH_CLASS,
		"winreg.DeleteValue.opnum() -> 8 (0x08) " },
	{ "__ndr_pack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winreg_DeleteValue_ndr_pack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_in(object, bigendian=False, ndr64=False) -> blob\nNDR pack input" },
	{ "__ndr_pack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winreg_DeleteValue_ndr_pack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_out(object, bigendian=False, ndr64=False) -> blob\nNDR pack output" },
	{ "__ndr_unpack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winreg_DeleteValue_ndr_unpack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_in(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack input" },
	{ "__ndr_unpack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winreg_DeleteValue_ndr_unpack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_out(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack output" },
	{ "__ndr_print_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winreg_DeleteValue_ndr_print_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_print_in(object, print_secrets=False) -> String\nNDR print input" },
	{ "__ndr_print_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winreg_DeleteValue_ndr_print_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_print_out(object, print_secrets=False) -> String\nNDR print output" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject winreg_DeleteValue_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "winreg.DeleteValue",
	.tp_getset = py_winreg_DeleteValue_getsetters,
	.tp_methods = py_winreg_DeleteValue_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_winreg_DeleteValue_new,
};

static bool pack_py_winreg_DeleteValue_args_in(PyObject *args, PyObject *kwargs, struct winreg_DeleteValue *r)
{
	PyObject *py_handle;
	PyObject *py_value;
	const char *kwnames[] = {
		"handle", "value", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OO:winreg_DeleteValue", discard_const_p(char *, kwnames), &py_handle, &py_value)) {
		return false;
	}

	if (py_handle == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.handle");
		return false;
	}
	r->in.handle = talloc_ptrtype(r, r->in.handle);
	if (r->in.handle == NULL) {
		PyErr_NoMemory();
		return false;
	}
	PY_CHECK_TYPE(policy_handle_Type, py_handle, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_handle)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.handle = (struct policy_handle *)pytalloc_get_ptr(py_handle);
	if (py_value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.value");
		return false;
	}
	PY_CHECK_TYPE(&winreg_String_Type, py_value, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_value)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.value = *(struct winreg_String *)pytalloc_get_ptr(py_value);
	return true;
}

static PyObject *unpack_py_winreg_DeleteValue_args_out(struct winreg_DeleteValue *r, bool raise_result_exception)
{
	PyObject *result = NULL;
	size_t result_size = 0;

	if (raise_result_exception) {
		if (!W_ERROR_IS_OK(r->out.result)) {
			PyErr_SetWERROR(r->out.result);
			return NULL;
		}

	} else {
		/* WERROR will be part of the results */
		result_size += 1;
	}

	if (!raise_result_exception) {
		result = PyErr_FromWERROR(r->out.result);
	}

	if (result_size == 0) {
		result = Py_None;
		Py_INCREF(result);
	}

	return result;
}


static PyObject *py_winreg_EnumKey_in_get_handle(PyObject *obj, void *closure)
{
	struct winreg_EnumKey *object = pytalloc_get_ptr(obj);
	PyObject *py_handle;
	if (object->in.handle == NULL) {
		Py_RETURN_NONE;
	}
	py_handle = pytalloc_reference_ex(policy_handle_Type, object->in.handle, object->in.handle);
	return py_handle;
}

static int py_winreg_EnumKey_in_set_handle(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winreg_EnumKey *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->in.handle));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.handle");
		return -1;
	}
	object->in.handle = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->in.handle);
	if (object->in.handle == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	PY_CHECK_TYPE(policy_handle_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->in.handle = (struct policy_handle *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_winreg_EnumKey_in_get_enum_index(PyObject *obj, void *closure)
{
	struct winreg_EnumKey *object = pytalloc_get_ptr(obj);
	PyObject *py_enum_index;
	py_enum_index = PyLong_FromUnsignedLongLong((uint32_t)(object->in.enum_index));
	return py_enum_index;
}

static int py_winreg_EnumKey_in_set_enum_index(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winreg_EnumKey *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.enum_index");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->in.enum_index));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->in.enum_index = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_winreg_EnumKey_in_get_name(PyObject *obj, void *closure)
{
	struct winreg_EnumKey *object = pytalloc_get_ptr(obj);
	PyObject *py_name;
	if (object->in.name == NULL) {
		Py_RETURN_NONE;
	}
	py_name = pytalloc_reference_ex(&winreg_StringBuf_Type, object->in.name, object->in.name);
	return py_name;
}

static int py_winreg_EnumKey_in_set_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winreg_EnumKey *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->in.name));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.name");
		return -1;
	}
	object->in.name = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->in.name);
	if (object->in.name == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	PY_CHECK_TYPE(&winreg_StringBuf_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->in.name = (struct winreg_StringBuf *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_winreg_EnumKey_out_get_name(PyObject *obj, void *closure)
{
	struct winreg_EnumKey *object = pytalloc_get_ptr(obj);
	PyObject *py_name;
	if (object->out.name == NULL) {
		Py_RETURN_NONE;
	}
	py_name = pytalloc_reference_ex(&winreg_StringBuf_Type, object->out.name, object->out.name);
	return py_name;
}

static int py_winreg_EnumKey_out_set_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winreg_EnumKey *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->out.name));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->out.name");
		return -1;
	}
	object->out.name = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->out.name);
	if (object->out.name == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	PY_CHECK_TYPE(&winreg_StringBuf_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->out.name = (struct winreg_StringBuf *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_winreg_EnumKey_in_get_keyclass(PyObject *obj, void *closure)
{
	struct winreg_EnumKey *object = pytalloc_get_ptr(obj);
	PyObject *py_keyclass;
	if (object->in.keyclass == NULL) {
		Py_RETURN_NONE;
	}
	if (object->in.keyclass == NULL) {
		py_keyclass = Py_None;
		Py_INCREF(py_keyclass);
	} else {
		py_keyclass = pytalloc_reference_ex(&winreg_StringBuf_Type, object->in.keyclass, object->in.keyclass);
	}
	return py_keyclass;
}

static int py_winreg_EnumKey_in_set_keyclass(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winreg_EnumKey *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->in.keyclass));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.keyclass");
		return -1;
	}
	if (value == Py_None) {
		object->in.keyclass = NULL;
	} else {
		object->in.keyclass = NULL;
		PY_CHECK_TYPE(&winreg_StringBuf_Type, value, return -1;);
		if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->in.keyclass = (struct winreg_StringBuf *)pytalloc_get_ptr(value);
	}
	return 0;
}

static PyObject *py_winreg_EnumKey_out_get_keyclass(PyObject *obj, void *closure)
{
	struct winreg_EnumKey *object = pytalloc_get_ptr(obj);
	PyObject *py_keyclass;
	if (object->out.keyclass == NULL) {
		Py_RETURN_NONE;
	}
	if (object->out.keyclass == NULL) {
		py_keyclass = Py_None;
		Py_INCREF(py_keyclass);
	} else {
		py_keyclass = pytalloc_reference_ex(&winreg_StringBuf_Type, object->out.keyclass, object->out.keyclass);
	}
	return py_keyclass;
}

static int py_winreg_EnumKey_out_set_keyclass(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winreg_EnumKey *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->out.keyclass));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->out.keyclass");
		return -1;
	}
	if (value == Py_None) {
		object->out.keyclass = NULL;
	} else {
		object->out.keyclass = NULL;
		PY_CHECK_TYPE(&winreg_StringBuf_Type, value, return -1;);
		if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->out.keyclass = (struct winreg_StringBuf *)pytalloc_get_ptr(value);
	}
	return 0;
}

static PyObject *py_winreg_EnumKey_in_get_last_changed_time(PyObject *obj, void *closure)
{
	struct winreg_EnumKey *object = pytalloc_get_ptr(obj);
	PyObject *py_last_changed_time;
	if (object->in.last_changed_time == NULL) {
		Py_RETURN_NONE;
	}
	if (object->in.last_changed_time == NULL) {
		py_last_changed_time = Py_None;
		Py_INCREF(py_last_changed_time);
	} else {
		py_last_changed_time = PyLong_FromUnsignedLongLong(*object->in.last_changed_time);
	}
	return py_last_changed_time;
}

static int py_winreg_EnumKey_in_set_last_changed_time(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winreg_EnumKey *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->in.last_changed_time));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.last_changed_time");
		return -1;
	}
	if (value == Py_None) {
		object->in.last_changed_time = NULL;
	} else {
		object->in.last_changed_time = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->in.last_changed_time);
		if (object->in.last_changed_time == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		{
			const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(*object->in.last_changed_time));
			if (PyLong_Check(value)) {
				unsigned long long test_var;
				test_var = PyLong_AsUnsignedLongLong(value);
				if (PyErr_Occurred() != NULL) {
					return -1;
				}
				if (test_var > uint_max) {
					PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
					  PyLong_Type.tp_name, uint_max, test_var);
					return -1;
				}
				*object->in.last_changed_time = test_var;
			} else {
				PyErr_Format(PyExc_TypeError, "Expected type %s",
				  PyLong_Type.tp_name);
				return -1;
			}
		}
	}
	return 0;
}

static PyObject *py_winreg_EnumKey_out_get_last_changed_time(PyObject *obj, void *closure)
{
	struct winreg_EnumKey *object = pytalloc_get_ptr(obj);
	PyObject *py_last_changed_time;
	if (object->out.last_changed_time == NULL) {
		Py_RETURN_NONE;
	}
	if (object->out.last_changed_time == NULL) {
		py_last_changed_time = Py_None;
		Py_INCREF(py_last_changed_time);
	} else {
		py_last_changed_time = PyLong_FromUnsignedLongLong(*object->out.last_changed_time);
	}
	return py_last_changed_time;
}

static int py_winreg_EnumKey_out_set_last_changed_time(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winreg_EnumKey *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->out.last_changed_time));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->out.last_changed_time");
		return -1;
	}
	if (value == Py_None) {
		object->out.last_changed_time = NULL;
	} else {
		object->out.last_changed_time = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->out.last_changed_time);
		if (object->out.last_changed_time == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		{
			const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(*object->out.last_changed_time));
			if (PyLong_Check(value)) {
				unsigned long long test_var;
				test_var = PyLong_AsUnsignedLongLong(value);
				if (PyErr_Occurred() != NULL) {
					return -1;
				}
				if (test_var > uint_max) {
					PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
					  PyLong_Type.tp_name, uint_max, test_var);
					return -1;
				}
				*object->out.last_changed_time = test_var;
			} else {
				PyErr_Format(PyExc_TypeError, "Expected type %s",
				  PyLong_Type.tp_name);
				return -1;
			}
		}
	}
	return 0;
}

static PyObject *py_winreg_EnumKey_get_result(PyObject *obj, void *closure)
{
	struct winreg_EnumKey *object = pytalloc_get_ptr(obj);
	PyObject *py_result;
	py_result = PyErr_FromWERROR(object->out.result);
	return py_result;
}

static int py_winreg_EnumKey_set_result(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winreg_EnumKey *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->out.result");
		return -1;
	}
	object->out.result = W_ERROR(PyLong_AsLong(value));
	return 0;
}

static PyGetSetDef py_winreg_EnumKey_getsetters[] = {
	{
		.name = discard_const_p(char, "in_handle"),
		.get = py_winreg_EnumKey_in_get_handle,
		.set = py_winreg_EnumKey_in_set_handle,
		.doc = discard_const_p(char, "PIDL-generated element of base type policy_handle")
	},
	{
		.name = discard_const_p(char, "in_enum_index"),
		.get = py_winreg_EnumKey_in_get_enum_index,
		.set = py_winreg_EnumKey_in_set_enum_index,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "in_name"),
		.get = py_winreg_EnumKey_in_get_name,
		.set = py_winreg_EnumKey_in_set_name,
		.doc = discard_const_p(char, "PIDL-generated element of base type winreg_StringBuf")
	},
	{
		.name = discard_const_p(char, "out_name"),
		.get = py_winreg_EnumKey_out_get_name,
		.set = py_winreg_EnumKey_out_set_name,
		.doc = discard_const_p(char, "PIDL-generated element of base type winreg_StringBuf")
	},
	{
		.name = discard_const_p(char, "in_keyclass"),
		.get = py_winreg_EnumKey_in_get_keyclass,
		.set = py_winreg_EnumKey_in_set_keyclass,
		.doc = discard_const_p(char, "PIDL-generated element of base type winreg_StringBuf")
	},
	{
		.name = discard_const_p(char, "out_keyclass"),
		.get = py_winreg_EnumKey_out_get_keyclass,
		.set = py_winreg_EnumKey_out_set_keyclass,
		.doc = discard_const_p(char, "PIDL-generated element of base type winreg_StringBuf")
	},
	{
		.name = discard_const_p(char, "in_last_changed_time"),
		.get = py_winreg_EnumKey_in_get_last_changed_time,
		.set = py_winreg_EnumKey_in_set_last_changed_time,
		.doc = discard_const_p(char, "PIDL-generated element of base type NTTIME")
	},
	{
		.name = discard_const_p(char, "out_last_changed_time"),
		.get = py_winreg_EnumKey_out_get_last_changed_time,
		.set = py_winreg_EnumKey_out_set_last_changed_time,
		.doc = discard_const_p(char, "PIDL-generated element of base type NTTIME")
	},
	{
		.name = discard_const_p(char, "result"),
		.get = py_winreg_EnumKey_get_result,
		.set = py_winreg_EnumKey_set_result,
		.doc = discard_const_p(char, "PIDL-generated element of type WERROR")
	},
	{ .name = NULL }
};

static PyObject *py_winreg_EnumKey_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyObject *self = pytalloc_new(struct winreg_EnumKey, type);
	struct winreg_EnumKey *_self = (struct winreg_EnumKey *)pytalloc_get_ptr(self);
	TALLOC_CTX *mem_ctx = pytalloc_get_mem_ctx(self);
	_self->in.handle = talloc_zero(mem_ctx, struct policy_handle);
	_self->in.name = talloc_zero(mem_ctx, struct winreg_StringBuf);
	_self->out.name = talloc_zero(mem_ctx, struct winreg_StringBuf);
	return self;
}

static PyObject *py_winreg_EnumKey_ndr_opnum(PyTypeObject *type, PyObject *Py_UNUSED(ignored))
{


	return PyLong_FromLong(9);
}

static PyObject *py_winreg_EnumKey_ndr_pack(PyObject *py_obj, ndr_flags_type ndr_inout_flags, libndr_flags ndr_push_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct winreg_EnumKey *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	struct ndr_push *push = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;

	if (ndr_table_winreg.num_calls < 10) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_winreg_EnumKey_ndr_pack");
		return NULL;
	}
	call = &ndr_table_winreg.calls[9];

	push = ndr_push_init_ctx(pytalloc_get_mem_ctx(py_obj));
	if (push == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	push->flags |= ndr_push_flags;

	err = call->ndr_push(push, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(push);
		PyErr_SetNdrError(err);
		return NULL;
	}
	blob = ndr_push_blob(push);
	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(push);
	return ret;
}

static PyObject *py_winreg_EnumKey_ndr_pack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_in__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_winreg_EnumKey_ndr_pack(py_obj, NDR_IN, ndr_push_flags);
}

static PyObject *py_winreg_EnumKey_ndr_pack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_out__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_winreg_EnumKey_ndr_pack(py_obj, NDR_OUT, ndr_push_flags);
}

static PyObject *py_winreg_EnumKey_ndr_unpack(PyObject *py_obj, const DATA_BLOB *blob, ndr_flags_type ndr_inout_flags, libndr_flags ndr_pull_flags, bool allow_remaining)
{
	const struct ndr_interface_call *call = NULL;
	struct winreg_EnumKey *object = pytalloc_get_ptr(py_obj);
	struct ndr_pull *pull = NULL;
	enum ndr_err_code err;

	if (ndr_table_winreg.num_calls < 10) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_winreg_EnumKey_ndr_unpack");
		return NULL;
	}
	call = &ndr_table_winreg.calls[9];

	pull = ndr_pull_init_blob(blob, object);
	if (pull == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	pull->flags |= ndr_pull_flags;

	err = call->ndr_pull(pull, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(pull);
		PyErr_SetNdrError(err);
		return NULL;
	}
	if (!allow_remaining) {
		uint32_t highest_ofs;

		if (pull->offset > pull->relative_highest_offset) {
			highest_ofs = pull->offset;
		} else {
			highest_ofs = pull->relative_highest_offset;
		}
		if (highest_ofs < pull->data_size) {
			err = ndr_pull_error(pull, NDR_ERR_UNREAD_BYTES,
				"not all bytes consumed ofs[%u] size[%u]",
				highest_ofs, pull->data_size);
			TALLOC_FREE(pull);
			PyErr_SetNdrError(err);
			return NULL;
		}
	}

	TALLOC_FREE(pull);
	Py_RETURN_NONE;
}

static PyObject *py_winreg_EnumKey_ndr_unpack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_in__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_winreg_EnumKey_ndr_unpack(py_obj, &blob, NDR_IN, ndr_pull_flags, allow_remaining);
}

static PyObject *py_winreg_EnumKey_ndr_unpack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_out__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_winreg_EnumKey_ndr_unpack(py_obj, &blob, NDR_OUT, ndr_pull_flags, allow_remaining);
}

static PyObject *py_winreg_EnumKey_ndr_print(PyObject *py_obj, PyObject *args, PyObject *kwargs, const char *name, ndr_flags_type ndr_inout_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct winreg_EnumKey *object = pytalloc_get_ptr(py_obj);
	const char * const kwnames[] = { "print_secrets", NULL };
	PyObject *py_print_secrets = NULL;
	PyObject *ret;
	char *retstr;
	bool ok;

	ok = PyArg_ParseTupleAndKeywords(args, kwargs, "|O:__ndr_print__",
		discard_const_p(char *, kwnames),
		&py_print_secrets);
	if (!ok) {
		return NULL;
	}

	if (ndr_table_winreg.num_calls < 10) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_winreg_EnumKey_ndr_print");
		return NULL;
	}
	call = &ndr_table_winreg.calls[9];

	if (py_print_secrets != NULL && PyObject_IsTrue(py_print_secrets)) {
		retstr = ndr_print_function_secret_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	} else {
		retstr = ndr_print_function_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	}
	ret = PyUnicode_FromString(retstr);
	TALLOC_FREE(retstr);

	return ret;
}

static PyObject *py_winreg_EnumKey_ndr_print_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	return py_winreg_EnumKey_ndr_print(py_obj, args, kwargs, "winreg_EnumKey_in", NDR_IN);
}

static PyObject *py_winreg_EnumKey_ndr_print_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	return py_winreg_EnumKey_ndr_print(py_obj, args, kwargs, "winreg_EnumKey_out", NDR_OUT);
}

static PyMethodDef py_winreg_EnumKey_methods[] = {
	{ "opnum", (PyCFunction)py_winreg_EnumKey_ndr_opnum, METH_NOARGS|METH_CLASS,
		"winreg.EnumKey.opnum() -> 9 (0x09) " },
	{ "__ndr_pack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winreg_EnumKey_ndr_pack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_in(object, bigendian=False, ndr64=False) -> blob\nNDR pack input" },
	{ "__ndr_pack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winreg_EnumKey_ndr_pack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_out(object, bigendian=False, ndr64=False) -> blob\nNDR pack output" },
	{ "__ndr_unpack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winreg_EnumKey_ndr_unpack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_in(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack input" },
	{ "__ndr_unpack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winreg_EnumKey_ndr_unpack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_out(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack output" },
	{ "__ndr_print_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winreg_EnumKey_ndr_print_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_print_in(object, print_secrets=False) -> String\nNDR print input" },
	{ "__ndr_print_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winreg_EnumKey_ndr_print_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_print_out(object, print_secrets=False) -> String\nNDR print output" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject winreg_EnumKey_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "winreg.EnumKey",
	.tp_getset = py_winreg_EnumKey_getsetters,
	.tp_methods = py_winreg_EnumKey_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_winreg_EnumKey_new,
};

static bool pack_py_winreg_EnumKey_args_in(PyObject *args, PyObject *kwargs, struct winreg_EnumKey *r)
{
	PyObject *py_handle;
	PyObject *py_enum_index;
	PyObject *py_name;
	PyObject *py_keyclass;
	PyObject *py_last_changed_time;
	const char *kwnames[] = {
		"handle", "enum_index", "name", "keyclass", "last_changed_time", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOOOO:winreg_EnumKey", discard_const_p(char *, kwnames), &py_handle, &py_enum_index, &py_name, &py_keyclass, &py_last_changed_time)) {
		return false;
	}

	if (py_handle == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.handle");
		return false;
	}
	r->in.handle = talloc_ptrtype(r, r->in.handle);
	if (r->in.handle == NULL) {
		PyErr_NoMemory();
		return false;
	}
	PY_CHECK_TYPE(policy_handle_Type, py_handle, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_handle)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.handle = (struct policy_handle *)pytalloc_get_ptr(py_handle);
	if (py_enum_index == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.enum_index");
		return false;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(r->in.enum_index));
		if (PyLong_Check(py_enum_index)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(py_enum_index);
			if (PyErr_Occurred() != NULL) {
				return false;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return false;
			}
			r->in.enum_index = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return false;
		}
	}
	if (py_name == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.name");
		return false;
	}
	r->in.name = talloc_ptrtype(r, r->in.name);
	if (r->in.name == NULL) {
		PyErr_NoMemory();
		return false;
	}
	PY_CHECK_TYPE(&winreg_StringBuf_Type, py_name, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_name)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.name = (struct winreg_StringBuf *)pytalloc_get_ptr(py_name);
	if (py_keyclass == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.keyclass");
		return false;
	}
	if (py_keyclass == Py_None) {
		r->in.keyclass = NULL;
	} else {
		r->in.keyclass = NULL;
		PY_CHECK_TYPE(&winreg_StringBuf_Type, py_keyclass, return false;);
		if (talloc_reference(r, pytalloc_get_mem_ctx(py_keyclass)) == NULL) {
			PyErr_NoMemory();
			return false;
		}
		r->in.keyclass = (struct winreg_StringBuf *)pytalloc_get_ptr(py_keyclass);
	}
	if (py_last_changed_time == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.last_changed_time");
		return false;
	}
	if (py_last_changed_time == Py_None) {
		r->in.last_changed_time = NULL;
	} else {
		r->in.last_changed_time = talloc_ptrtype(r, r->in.last_changed_time);
		if (r->in.last_changed_time == NULL) {
			PyErr_NoMemory();
			return false;
		}
		{
			const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(*r->in.last_changed_time));
			if (PyLong_Check(py_last_changed_time)) {
				unsigned long long test_var;
				test_var = PyLong_AsUnsignedLongLong(py_last_changed_time);
				if (PyErr_Occurred() != NULL) {
					return false;
				}
				if (test_var > uint_max) {
					PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
					  PyLong_Type.tp_name, uint_max, test_var);
					return false;
				}
				*r->in.last_changed_time = test_var;
			} else {
				PyErr_Format(PyExc_TypeError, "Expected type %s",
				  PyLong_Type.tp_name);
				return false;
			}
		}
	}
	return true;
}

static PyObject *unpack_py_winreg_EnumKey_args_out(struct winreg_EnumKey *r, bool raise_result_exception)
{
	PyObject *py_name = NULL;
	PyObject *py_keyclass = NULL;
	PyObject *py_last_changed_time = NULL;
	PyObject *result = NULL;
	size_t result_size = 3;

	if (raise_result_exception) {
		if (!W_ERROR_IS_OK(r->out.result)) {
			PyErr_SetWERROR(r->out.result);
			return NULL;
		}

	} else {
		/* WERROR will be part of the results */
		result_size += 1;
	}

	if (result_size > 1) {
		result = PyTuple_New(result_size);
		if (result == NULL) {
			return NULL;
		}
	}

	py_name = pytalloc_reference_ex(&winreg_StringBuf_Type, r->out.name, r->out.name);
	PyTuple_SetItem(result, 0, py_name);

	if (r->out.keyclass == NULL) {
		py_keyclass = Py_None;
		Py_INCREF(py_keyclass);
	} else {
		py_keyclass = pytalloc_reference_ex(&winreg_StringBuf_Type, r->out.keyclass, r->out.keyclass);
	}
	PyTuple_SetItem(result, 1, py_keyclass);

	if (r->out.last_changed_time == NULL) {
		py_last_changed_time = Py_None;
		Py_INCREF(py_last_changed_time);
	} else {
		py_last_changed_time = PyLong_FromUnsignedLongLong(*r->out.last_changed_time);
	}
	PyTuple_SetItem(result, 2, py_last_changed_time);

	if (!raise_result_exception) {
		PyTuple_SetItem(result, 3, PyErr_FromWERROR(r->out.result));
	}

	return result;
}


static PyObject *py_winreg_EnumValue_in_get_handle(PyObject *obj, void *closure)
{
	struct winreg_EnumValue *object = pytalloc_get_ptr(obj);
	PyObject *py_handle;
	if (object->in.handle == NULL) {
		Py_RETURN_NONE;
	}
	py_handle = pytalloc_reference_ex(policy_handle_Type, object->in.handle, object->in.handle);
	return py_handle;
}

static int py_winreg_EnumValue_in_set_handle(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winreg_EnumValue *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->in.handle));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.handle");
		return -1;
	}
	object->in.handle = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->in.handle);
	if (object->in.handle == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	PY_CHECK_TYPE(policy_handle_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->in.handle = (struct policy_handle *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_winreg_EnumValue_in_get_enum_index(PyObject *obj, void *closure)
{
	struct winreg_EnumValue *object = pytalloc_get_ptr(obj);
	PyObject *py_enum_index;
	py_enum_index = PyLong_FromUnsignedLongLong((uint32_t)(object->in.enum_index));
	return py_enum_index;
}

static int py_winreg_EnumValue_in_set_enum_index(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winreg_EnumValue *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.enum_index");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->in.enum_index));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->in.enum_index = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_winreg_EnumValue_in_get_name(PyObject *obj, void *closure)
{
	struct winreg_EnumValue *object = pytalloc_get_ptr(obj);
	PyObject *py_name;
	if (object->in.name == NULL) {
		Py_RETURN_NONE;
	}
	py_name = pytalloc_reference_ex(&winreg_ValNameBuf_Type, object->in.name, object->in.name);
	return py_name;
}

static int py_winreg_EnumValue_in_set_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winreg_EnumValue *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->in.name));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.name");
		return -1;
	}
	object->in.name = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->in.name);
	if (object->in.name == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	PY_CHECK_TYPE(&winreg_ValNameBuf_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->in.name = (struct winreg_ValNameBuf *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_winreg_EnumValue_out_get_name(PyObject *obj, void *closure)
{
	struct winreg_EnumValue *object = pytalloc_get_ptr(obj);
	PyObject *py_name;
	if (object->out.name == NULL) {
		Py_RETURN_NONE;
	}
	py_name = pytalloc_reference_ex(&winreg_ValNameBuf_Type, object->out.name, object->out.name);
	return py_name;
}

static int py_winreg_EnumValue_out_set_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winreg_EnumValue *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->out.name));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->out.name");
		return -1;
	}
	object->out.name = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->out.name);
	if (object->out.name == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	PY_CHECK_TYPE(&winreg_ValNameBuf_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->out.name = (struct winreg_ValNameBuf *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_winreg_EnumValue_in_get_type(PyObject *obj, void *closure)
{
	struct winreg_EnumValue *object = pytalloc_get_ptr(obj);
	PyObject *py_type;
	if (object->in.type == NULL) {
		Py_RETURN_NONE;
	}
	if (object->in.type == NULL) {
		py_type = Py_None;
		Py_INCREF(py_type);
	} else {
		py_type = PyLong_FromUnsignedLongLong((uint32_t)(*object->in.type));
	}
	return py_type;
}

static int py_winreg_EnumValue_in_set_type(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winreg_EnumValue *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->in.type));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.type");
		return -1;
	}
	if (value == Py_None) {
		object->in.type = NULL;
	} else {
		object->in.type = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->in.type);
		if (object->in.type == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		{
			const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(*object->in.type));
			if (PyLong_Check(value)) {
				unsigned long long test_var;
				test_var = PyLong_AsUnsignedLongLong(value);
				if (PyErr_Occurred() != NULL) {
					return -1;
				}
				if (test_var > uint_max) {
					PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
					  PyLong_Type.tp_name, uint_max, test_var);
					return -1;
				}
				*object->in.type = test_var;
			} else {
				PyErr_Format(PyExc_TypeError, "Expected type %s",
				  PyLong_Type.tp_name);
				return -1;
			}
		}
	}
	return 0;
}

static PyObject *py_winreg_EnumValue_out_get_type(PyObject *obj, void *closure)
{
	struct winreg_EnumValue *object = pytalloc_get_ptr(obj);
	PyObject *py_type;
	if (object->out.type == NULL) {
		Py_RETURN_NONE;
	}
	if (object->out.type == NULL) {
		py_type = Py_None;
		Py_INCREF(py_type);
	} else {
		py_type = PyLong_FromUnsignedLongLong((uint32_t)(*object->out.type));
	}
	return py_type;
}

static int py_winreg_EnumValue_out_set_type(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winreg_EnumValue *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->out.type));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->out.type");
		return -1;
	}
	if (value == Py_None) {
		object->out.type = NULL;
	} else {
		object->out.type = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->out.type);
		if (object->out.type == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		{
			const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(*object->out.type));
			if (PyLong_Check(value)) {
				unsigned long long test_var;
				test_var = PyLong_AsUnsignedLongLong(value);
				if (PyErr_Occurred() != NULL) {
					return -1;
				}
				if (test_var > uint_max) {
					PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
					  PyLong_Type.tp_name, uint_max, test_var);
					return -1;
				}
				*object->out.type = test_var;
			} else {
				PyErr_Format(PyExc_TypeError, "Expected type %s",
				  PyLong_Type.tp_name);
				return -1;
			}
		}
	}
	return 0;
}

static PyObject *py_winreg_EnumValue_in_get_value(PyObject *obj, void *closure)
{
	struct winreg_EnumValue *object = pytalloc_get_ptr(obj);
	PyObject *py_value;
	if (object->in.value == NULL) {
		Py_RETURN_NONE;
	}
	if (object->in.value == NULL) {
		py_value = Py_None;
		Py_INCREF(py_value);
	} else {
		py_value = PyList_New(object->in.length?*object->in.length:0);
		if (py_value == NULL) {
			return NULL;
		}
		{
			int value_cntr_1;
			for (value_cntr_1 = 0; value_cntr_1 < (object->in.length?*object->in.length:0); value_cntr_1++) {
				PyObject *py_value_1;
				py_value_1 = PyLong_FromLong((uint16_t)((object->in.value)[value_cntr_1]));
				PyList_SetItem(py_value, value_cntr_1, py_value_1);
			}
		}
	}
	return py_value;
}

static int py_winreg_EnumValue_in_set_value(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winreg_EnumValue *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->in.value));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.value");
		return -1;
	}
	if (value == Py_None) {
		object->in.value = NULL;
	} else {
		object->in.value = NULL;
		PY_CHECK_TYPE(&PyList_Type, value, return -1;);
		{
			int value_cntr_1;
			object->in.value = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->in.value, PyList_GET_SIZE(value));
			if (!object->in.value) { return -1; }
			talloc_set_name_const(object->in.value, "ARRAY: object->in.value");
			for (value_cntr_1 = 0; value_cntr_1 < PyList_GET_SIZE(value); value_cntr_1++) {
				if (PyList_GET_ITEM(value, value_cntr_1) == NULL) {
					PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: (object->in.value)[value_cntr_1]");
					return -1;
				}
				{
					const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof((object->in.value)[value_cntr_1]));
					if (PyLong_Check(PyList_GET_ITEM(value, value_cntr_1))) {
						unsigned long long test_var;
						test_var = PyLong_AsUnsignedLongLong(PyList_GET_ITEM(value, value_cntr_1));
						if (PyErr_Occurred() != NULL) {
							return -1;
						}
						if (test_var > uint_max) {
							PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
							  PyLong_Type.tp_name, uint_max, test_var);
							return -1;
						}
						(object->in.value)[value_cntr_1] = test_var;
					} else {
						PyErr_Format(PyExc_TypeError, "Expected type %s",
						  PyLong_Type.tp_name);
						return -1;
					}
				}
			}
		}
	}
	return 0;
}

static PyObject *py_winreg_EnumValue_out_get_value(PyObject *obj, void *closure)
{
	struct winreg_EnumValue *object = pytalloc_get_ptr(obj);
	PyObject *py_value;
	if (object->out.value == NULL) {
		Py_RETURN_NONE;
	}
	if (object->out.value == NULL) {
		py_value = Py_None;
		Py_INCREF(py_value);
	} else {
		py_value = PyList_New(object->out.length?*object->out.length:0);
		if (py_value == NULL) {
			return NULL;
		}
		{
			int value_cntr_1;
			for (value_cntr_1 = 0; value_cntr_1 < (object->out.length?*object->out.length:0); value_cntr_1++) {
				PyObject *py_value_1;
				py_value_1 = PyLong_FromLong((uint16_t)((object->out.value)[value_cntr_1]));
				PyList_SetItem(py_value, value_cntr_1, py_value_1);
			}
		}
	}
	return py_value;
}

static int py_winreg_EnumValue_out_set_value(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winreg_EnumValue *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->out.value));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->out.value");
		return -1;
	}
	if (value == Py_None) {
		object->out.value = NULL;
	} else {
		object->out.value = NULL;
		PY_CHECK_TYPE(&PyList_Type, value, return -1;);
		{
			int value_cntr_1;
			object->out.value = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->out.value, PyList_GET_SIZE(value));
			if (!object->out.value) { return -1; }
			talloc_set_name_const(object->out.value, "ARRAY: object->out.value");
			for (value_cntr_1 = 0; value_cntr_1 < PyList_GET_SIZE(value); value_cntr_1++) {
				if (PyList_GET_ITEM(value, value_cntr_1) == NULL) {
					PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: (object->out.value)[value_cntr_1]");
					return -1;
				}
				{
					const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof((object->out.value)[value_cntr_1]));
					if (PyLong_Check(PyList_GET_ITEM(value, value_cntr_1))) {
						unsigned long long test_var;
						test_var = PyLong_AsUnsignedLongLong(PyList_GET_ITEM(value, value_cntr_1));
						if (PyErr_Occurred() != NULL) {
							return -1;
						}
						if (test_var > uint_max) {
							PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
							  PyLong_Type.tp_name, uint_max, test_var);
							return -1;
						}
						(object->out.value)[value_cntr_1] = test_var;
					} else {
						PyErr_Format(PyExc_TypeError, "Expected type %s",
						  PyLong_Type.tp_name);
						return -1;
					}
				}
			}
		}
	}
	return 0;
}

static PyObject *py_winreg_EnumValue_in_get_size(PyObject *obj, void *closure)
{
	struct winreg_EnumValue *object = pytalloc_get_ptr(obj);
	PyObject *py_size;
	if (object->in.size == NULL) {
		Py_RETURN_NONE;
	}
	if (object->in.size == NULL) {
		py_size = Py_None;
		Py_INCREF(py_size);
	} else {
		py_size = PyLong_FromUnsignedLongLong((uint32_t)(*object->in.size));
	}
	return py_size;
}

static int py_winreg_EnumValue_in_set_size(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winreg_EnumValue *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->in.size));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.size");
		return -1;
	}
	if (value == Py_None) {
		object->in.size = NULL;
	} else {
		object->in.size = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->in.size);
		if (object->in.size == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		{
			const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(*object->in.size));
			if (PyLong_Check(value)) {
				unsigned long long test_var;
				test_var = PyLong_AsUnsignedLongLong(value);
				if (PyErr_Occurred() != NULL) {
					return -1;
				}
				if (test_var > uint_max) {
					PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
					  PyLong_Type.tp_name, uint_max, test_var);
					return -1;
				}
				*object->in.size = test_var;
			} else {
				PyErr_Format(PyExc_TypeError, "Expected type %s",
				  PyLong_Type.tp_name);
				return -1;
			}
		}
	}
	return 0;
}

static PyObject *py_winreg_EnumValue_out_get_size(PyObject *obj, void *closure)
{
	struct winreg_EnumValue *object = pytalloc_get_ptr(obj);
	PyObject *py_size;
	if (object->out.size == NULL) {
		Py_RETURN_NONE;
	}
	if (object->out.size == NULL) {
		py_size = Py_None;
		Py_INCREF(py_size);
	} else {
		py_size = PyLong_FromUnsignedLongLong((uint32_t)(*object->out.size));
	}
	return py_size;
}

static int py_winreg_EnumValue_out_set_size(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winreg_EnumValue *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->out.size));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->out.size");
		return -1;
	}
	if (value == Py_None) {
		object->out.size = NULL;
	} else {
		object->out.size = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->out.size);
		if (object->out.size == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		{
			const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(*object->out.size));
			if (PyLong_Check(value)) {
				unsigned long long test_var;
				test_var = PyLong_AsUnsignedLongLong(value);
				if (PyErr_Occurred() != NULL) {
					return -1;
				}
				if (test_var > uint_max) {
					PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
					  PyLong_Type.tp_name, uint_max, test_var);
					return -1;
				}
				*object->out.size = test_var;
			} else {
				PyErr_Format(PyExc_TypeError, "Expected type %s",
				  PyLong_Type.tp_name);
				return -1;
			}
		}
	}
	return 0;
}

static PyObject *py_winreg_EnumValue_in_get_length(PyObject *obj, void *closure)
{
	struct winreg_EnumValue *object = pytalloc_get_ptr(obj);
	PyObject *py_length;
	if (object->in.length == NULL) {
		Py_RETURN_NONE;
	}
	if (object->in.length == NULL) {
		py_length = Py_None;
		Py_INCREF(py_length);
	} else {
		py_length = PyLong_FromUnsignedLongLong((uint32_t)(*object->in.length));
	}
	return py_length;
}

static int py_winreg_EnumValue_in_set_length(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winreg_EnumValue *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->in.length));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.length");
		return -1;
	}
	if (value == Py_None) {
		object->in.length = NULL;
	} else {
		object->in.length = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->in.length);
		if (object->in.length == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		{
			const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(*object->in.length));
			if (PyLong_Check(value)) {
				unsigned long long test_var;
				test_var = PyLong_AsUnsignedLongLong(value);
				if (PyErr_Occurred() != NULL) {
					return -1;
				}
				if (test_var > uint_max) {
					PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
					  PyLong_Type.tp_name, uint_max, test_var);
					return -1;
				}
				*object->in.length = test_var;
			} else {
				PyErr_Format(PyExc_TypeError, "Expected type %s",
				  PyLong_Type.tp_name);
				return -1;
			}
		}
	}
	return 0;
}

static PyObject *py_winreg_EnumValue_out_get_length(PyObject *obj, void *closure)
{
	struct winreg_EnumValue *object = pytalloc_get_ptr(obj);
	PyObject *py_length;
	if (object->out.length == NULL) {
		Py_RETURN_NONE;
	}
	if (object->out.length == NULL) {
		py_length = Py_None;
		Py_INCREF(py_length);
	} else {
		py_length = PyLong_FromUnsignedLongLong((uint32_t)(*object->out.length));
	}
	return py_length;
}

static int py_winreg_EnumValue_out_set_length(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winreg_EnumValue *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->out.length));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->out.length");
		return -1;
	}
	if (value == Py_None) {
		object->out.length = NULL;
	} else {
		object->out.length = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->out.length);
		if (object->out.length == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		{
			const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(*object->out.length));
			if (PyLong_Check(value)) {
				unsigned long long test_var;
				test_var = PyLong_AsUnsignedLongLong(value);
				if (PyErr_Occurred() != NULL) {
					return -1;
				}
				if (test_var > uint_max) {
					PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
					  PyLong_Type.tp_name, uint_max, test_var);
					return -1;
				}
				*object->out.length = test_var;
			} else {
				PyErr_Format(PyExc_TypeError, "Expected type %s",
				  PyLong_Type.tp_name);
				return -1;
			}
		}
	}
	return 0;
}

static PyObject *py_winreg_EnumValue_get_result(PyObject *obj, void *closure)
{
	struct winreg_EnumValue *object = pytalloc_get_ptr(obj);
	PyObject *py_result;
	py_result = PyErr_FromWERROR(object->out.result);
	return py_result;
}

static int py_winreg_EnumValue_set_result(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winreg_EnumValue *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->out.result");
		return -1;
	}
	object->out.result = W_ERROR(PyLong_AsLong(value));
	return 0;
}

static PyGetSetDef py_winreg_EnumValue_getsetters[] = {
	{
		.name = discard_const_p(char, "in_handle"),
		.get = py_winreg_EnumValue_in_get_handle,
		.set = py_winreg_EnumValue_in_set_handle,
		.doc = discard_const_p(char, "PIDL-generated element of base type policy_handle")
	},
	{
		.name = discard_const_p(char, "in_enum_index"),
		.get = py_winreg_EnumValue_in_get_enum_index,
		.set = py_winreg_EnumValue_in_set_enum_index,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "in_name"),
		.get = py_winreg_EnumValue_in_get_name,
		.set = py_winreg_EnumValue_in_set_name,
		.doc = discard_const_p(char, "PIDL-generated element of base type winreg_ValNameBuf")
	},
	{
		.name = discard_const_p(char, "out_name"),
		.get = py_winreg_EnumValue_out_get_name,
		.set = py_winreg_EnumValue_out_set_name,
		.doc = discard_const_p(char, "PIDL-generated element of base type winreg_ValNameBuf")
	},
	{
		.name = discard_const_p(char, "in_type"),
		.get = py_winreg_EnumValue_in_get_type,
		.set = py_winreg_EnumValue_in_set_type,
		.doc = discard_const_p(char, "PIDL-generated element of base type winreg_Type")
	},
	{
		.name = discard_const_p(char, "out_type"),
		.get = py_winreg_EnumValue_out_get_type,
		.set = py_winreg_EnumValue_out_set_type,
		.doc = discard_const_p(char, "PIDL-generated element of base type winreg_Type")
	},
	{
		.name = discard_const_p(char, "in_value"),
		.get = py_winreg_EnumValue_in_get_value,
		.set = py_winreg_EnumValue_in_set_value,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "out_value"),
		.get = py_winreg_EnumValue_out_get_value,
		.set = py_winreg_EnumValue_out_set_value,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "in_size"),
		.get = py_winreg_EnumValue_in_get_size,
		.set = py_winreg_EnumValue_in_set_size,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "out_size"),
		.get = py_winreg_EnumValue_out_get_size,
		.set = py_winreg_EnumValue_out_set_size,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "in_length"),
		.get = py_winreg_EnumValue_in_get_length,
		.set = py_winreg_EnumValue_in_set_length,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "out_length"),
		.get = py_winreg_EnumValue_out_get_length,
		.set = py_winreg_EnumValue_out_set_length,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "result"),
		.get = py_winreg_EnumValue_get_result,
		.set = py_winreg_EnumValue_set_result,
		.doc = discard_const_p(char, "PIDL-generated element of type WERROR")
	},
	{ .name = NULL }
};

static PyObject *py_winreg_EnumValue_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyObject *self = pytalloc_new(struct winreg_EnumValue, type);
	struct winreg_EnumValue *_self = (struct winreg_EnumValue *)pytalloc_get_ptr(self);
	TALLOC_CTX *mem_ctx = pytalloc_get_mem_ctx(self);
	_self->in.handle = talloc_zero(mem_ctx, struct policy_handle);
	_self->in.name = talloc_zero(mem_ctx, struct winreg_ValNameBuf);
	_self->out.name = talloc_zero(mem_ctx, struct winreg_ValNameBuf);
	return self;
}

static PyObject *py_winreg_EnumValue_ndr_opnum(PyTypeObject *type, PyObject *Py_UNUSED(ignored))
{


	return PyLong_FromLong(10);
}

static PyObject *py_winreg_EnumValue_ndr_pack(PyObject *py_obj, ndr_flags_type ndr_inout_flags, libndr_flags ndr_push_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct winreg_EnumValue *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	struct ndr_push *push = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;

	if (ndr_table_winreg.num_calls < 11) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_winreg_EnumValue_ndr_pack");
		return NULL;
	}
	call = &ndr_table_winreg.calls[10];

	push = ndr_push_init_ctx(pytalloc_get_mem_ctx(py_obj));
	if (push == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	push->flags |= ndr_push_flags;

	err = call->ndr_push(push, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(push);
		PyErr_SetNdrError(err);
		return NULL;
	}
	blob = ndr_push_blob(push);
	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(push);
	return ret;
}

static PyObject *py_winreg_EnumValue_ndr_pack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_in__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_winreg_EnumValue_ndr_pack(py_obj, NDR_IN, ndr_push_flags);
}

static PyObject *py_winreg_EnumValue_ndr_pack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_out__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_winreg_EnumValue_ndr_pack(py_obj, NDR_OUT, ndr_push_flags);
}

static PyObject *py_winreg_EnumValue_ndr_unpack(PyObject *py_obj, const DATA_BLOB *blob, ndr_flags_type ndr_inout_flags, libndr_flags ndr_pull_flags, bool allow_remaining)
{
	const struct ndr_interface_call *call = NULL;
	struct winreg_EnumValue *object = pytalloc_get_ptr(py_obj);
	struct ndr_pull *pull = NULL;
	enum ndr_err_code err;

	if (ndr_table_winreg.num_calls < 11) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_winreg_EnumValue_ndr_unpack");
		return NULL;
	}
	call = &ndr_table_winreg.calls[10];

	pull = ndr_pull_init_blob(blob, object);
	if (pull == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	pull->flags |= ndr_pull_flags;

	err = call->ndr_pull(pull, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(pull);
		PyErr_SetNdrError(err);
		return NULL;
	}
	if (!allow_remaining) {
		uint32_t highest_ofs;

		if (pull->offset > pull->relative_highest_offset) {
			highest_ofs = pull->offset;
		} else {
			highest_ofs = pull->relative_highest_offset;
		}
		if (highest_ofs < pull->data_size) {
			err = ndr_pull_error(pull, NDR_ERR_UNREAD_BYTES,
				"not all bytes consumed ofs[%u] size[%u]",
				highest_ofs, pull->data_size);
			TALLOC_FREE(pull);
			PyErr_SetNdrError(err);
			return NULL;
		}
	}

	TALLOC_FREE(pull);
	Py_RETURN_NONE;
}

static PyObject *py_winreg_EnumValue_ndr_unpack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_in__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_winreg_EnumValue_ndr_unpack(py_obj, &blob, NDR_IN, ndr_pull_flags, allow_remaining);
}

static PyObject *py_winreg_EnumValue_ndr_unpack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_out__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_winreg_EnumValue_ndr_unpack(py_obj, &blob, NDR_OUT, ndr_pull_flags, allow_remaining);
}

static PyObject *py_winreg_EnumValue_ndr_print(PyObject *py_obj, PyObject *args, PyObject *kwargs, const char *name, ndr_flags_type ndr_inout_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct winreg_EnumValue *object = pytalloc_get_ptr(py_obj);
	const char * const kwnames[] = { "print_secrets", NULL };
	PyObject *py_print_secrets = NULL;
	PyObject *ret;
	char *retstr;
	bool ok;

	ok = PyArg_ParseTupleAndKeywords(args, kwargs, "|O:__ndr_print__",
		discard_const_p(char *, kwnames),
		&py_print_secrets);
	if (!ok) {
		return NULL;
	}

	if (ndr_table_winreg.num_calls < 11) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_winreg_EnumValue_ndr_print");
		return NULL;
	}
	call = &ndr_table_winreg.calls[10];

	if (py_print_secrets != NULL && PyObject_IsTrue(py_print_secrets)) {
		retstr = ndr_print_function_secret_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	} else {
		retstr = ndr_print_function_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	}
	ret = PyUnicode_FromString(retstr);
	TALLOC_FREE(retstr);

	return ret;
}

static PyObject *py_winreg_EnumValue_ndr_print_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	return py_winreg_EnumValue_ndr_print(py_obj, args, kwargs, "winreg_EnumValue_in", NDR_IN);
}

static PyObject *py_winreg_EnumValue_ndr_print_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	return py_winreg_EnumValue_ndr_print(py_obj, args, kwargs, "winreg_EnumValue_out", NDR_OUT);
}

static PyMethodDef py_winreg_EnumValue_methods[] = {
	{ "opnum", (PyCFunction)py_winreg_EnumValue_ndr_opnum, METH_NOARGS|METH_CLASS,
		"winreg.EnumValue.opnum() -> 10 (0x0a) " },
	{ "__ndr_pack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winreg_EnumValue_ndr_pack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_in(object, bigendian=False, ndr64=False) -> blob\nNDR pack input" },
	{ "__ndr_pack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winreg_EnumValue_ndr_pack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_out(object, bigendian=False, ndr64=False) -> blob\nNDR pack output" },
	{ "__ndr_unpack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winreg_EnumValue_ndr_unpack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_in(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack input" },
	{ "__ndr_unpack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winreg_EnumValue_ndr_unpack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_out(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack output" },
	{ "__ndr_print_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winreg_EnumValue_ndr_print_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_print_in(object, print_secrets=False) -> String\nNDR print input" },
	{ "__ndr_print_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winreg_EnumValue_ndr_print_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_print_out(object, print_secrets=False) -> String\nNDR print output" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject winreg_EnumValue_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "winreg.EnumValue",
	.tp_getset = py_winreg_EnumValue_getsetters,
	.tp_methods = py_winreg_EnumValue_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_winreg_EnumValue_new,
};

static bool pack_py_winreg_EnumValue_args_in(PyObject *args, PyObject *kwargs, struct winreg_EnumValue *r)
{
	PyObject *py_handle;
	PyObject *py_enum_index;
	PyObject *py_name;
	PyObject *py_type;
	PyObject *py_value;
	PyObject *py_size;
	PyObject *py_length;
	const char *kwnames[] = {
		"handle", "enum_index", "name", "type", "value", "size", "length", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOOOOOO:winreg_EnumValue", discard_const_p(char *, kwnames), &py_handle, &py_enum_index, &py_name, &py_type, &py_value, &py_size, &py_length)) {
		return false;
	}

	if (py_handle == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.handle");
		return false;
	}
	r->in.handle = talloc_ptrtype(r, r->in.handle);
	if (r->in.handle == NULL) {
		PyErr_NoMemory();
		return false;
	}
	PY_CHECK_TYPE(policy_handle_Type, py_handle, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_handle)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.handle = (struct policy_handle *)pytalloc_get_ptr(py_handle);
	if (py_enum_index == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.enum_index");
		return false;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(r->in.enum_index));
		if (PyLong_Check(py_enum_index)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(py_enum_index);
			if (PyErr_Occurred() != NULL) {
				return false;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return false;
			}
			r->in.enum_index = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return false;
		}
	}
	if (py_name == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.name");
		return false;
	}
	r->in.name = talloc_ptrtype(r, r->in.name);
	if (r->in.name == NULL) {
		PyErr_NoMemory();
		return false;
	}
	PY_CHECK_TYPE(&winreg_ValNameBuf_Type, py_name, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_name)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.name = (struct winreg_ValNameBuf *)pytalloc_get_ptr(py_name);
	if (py_type == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.type");
		return false;
	}
	if (py_type == Py_None) {
		r->in.type = NULL;
	} else {
		r->in.type = talloc_ptrtype(r, r->in.type);
		if (r->in.type == NULL) {
			PyErr_NoMemory();
			return false;
		}
		{
			const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(*r->in.type));
			if (PyLong_Check(py_type)) {
				unsigned long long test_var;
				test_var = PyLong_AsUnsignedLongLong(py_type);
				if (PyErr_Occurred() != NULL) {
					return false;
				}
				if (test_var > uint_max) {
					PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
					  PyLong_Type.tp_name, uint_max, test_var);
					return false;
				}
				*r->in.type = test_var;
			} else {
				PyErr_Format(PyExc_TypeError, "Expected type %s",
				  PyLong_Type.tp_name);
				return false;
			}
		}
	}
	if (py_value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.value");
		return false;
	}
	if (py_value == Py_None) {
		r->in.value = NULL;
	} else {
		r->in.value = NULL;
		PY_CHECK_TYPE(&PyList_Type, py_value, return false;);
		{
			int value_cntr_1;
			r->in.value = talloc_array_ptrtype(r, r->in.value, PyList_GET_SIZE(py_value));
			if (!r->in.value) { return false; }
			talloc_set_name_const(r->in.value, "ARRAY: r->in.value");
			for (value_cntr_1 = 0; value_cntr_1 < PyList_GET_SIZE(py_value); value_cntr_1++) {
				if (PyList_GET_ITEM(py_value, value_cntr_1) == NULL) {
					PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: (r->in.value)[value_cntr_1]");
					return false;
				}
				{
					const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof((r->in.value)[value_cntr_1]));
					if (PyLong_Check(PyList_GET_ITEM(py_value, value_cntr_1))) {
						unsigned long long test_var;
						test_var = PyLong_AsUnsignedLongLong(PyList_GET_ITEM(py_value, value_cntr_1));
						if (PyErr_Occurred() != NULL) {
							return false;
						}
						if (test_var > uint_max) {
							PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
							  PyLong_Type.tp_name, uint_max, test_var);
							return false;
						}
						(r->in.value)[value_cntr_1] = test_var;
					} else {
						PyErr_Format(PyExc_TypeError, "Expected type %s",
						  PyLong_Type.tp_name);
						return false;
					}
				}
			}
		}
	}
	if (py_size == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.size");
		return false;
	}
	if (py_size == Py_None) {
		r->in.size = NULL;
	} else {
		r->in.size = talloc_ptrtype(r, r->in.size);
		if (r->in.size == NULL) {
			PyErr_NoMemory();
			return false;
		}
		{
			const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(*r->in.size));
			if (PyLong_Check(py_size)) {
				unsigned long long test_var;
				test_var = PyLong_AsUnsignedLongLong(py_size);
				if (PyErr_Occurred() != NULL) {
					return false;
				}
				if (test_var > uint_max) {
					PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
					  PyLong_Type.tp_name, uint_max, test_var);
					return false;
				}
				*r->in.size = test_var;
			} else {
				PyErr_Format(PyExc_TypeError, "Expected type %s",
				  PyLong_Type.tp_name);
				return false;
			}
		}
	}
	if (py_length == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.length");
		return false;
	}
	if (py_length == Py_None) {
		r->in.length = NULL;
	} else {
		r->in.length = talloc_ptrtype(r, r->in.length);
		if (r->in.length == NULL) {
			PyErr_NoMemory();
			return false;
		}
		{
			const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(*r->in.length));
			if (PyLong_Check(py_length)) {
				unsigned long long test_var;
				test_var = PyLong_AsUnsignedLongLong(py_length);
				if (PyErr_Occurred() != NULL) {
					return false;
				}
				if (test_var > uint_max) {
					PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
					  PyLong_Type.tp_name, uint_max, test_var);
					return false;
				}
				*r->in.length = test_var;
			} else {
				PyErr_Format(PyExc_TypeError, "Expected type %s",
				  PyLong_Type.tp_name);
				return false;
			}
		}
	}
	return true;
}

static PyObject *unpack_py_winreg_EnumValue_args_out(struct winreg_EnumValue *r, bool raise_result_exception)
{
	PyObject *py_name = NULL;
	PyObject *py_type = NULL;
	PyObject *py_value = NULL;
	PyObject *py_size = NULL;
	PyObject *py_length = NULL;
	PyObject *result = NULL;
	size_t result_size = 5;

	if (raise_result_exception) {
		if (!W_ERROR_IS_OK(r->out.result)) {
			PyErr_SetWERROR(r->out.result);
			return NULL;
		}

	} else {
		/* WERROR will be part of the results */
		result_size += 1;
	}

	if (result_size > 1) {
		result = PyTuple_New(result_size);
		if (result == NULL) {
			return NULL;
		}
	}

	py_name = pytalloc_reference_ex(&winreg_ValNameBuf_Type, r->out.name, r->out.name);
	PyTuple_SetItem(result, 0, py_name);

	if (r->out.type == NULL) {
		py_type = Py_None;
		Py_INCREF(py_type);
	} else {
		py_type = PyLong_FromUnsignedLongLong((uint32_t)(*r->out.type));
	}
	PyTuple_SetItem(result, 1, py_type);

	if (r->out.value == NULL) {
		py_value = Py_None;
		Py_INCREF(py_value);
	} else {
		py_value = PyList_New(r->out.length?*r->out.length:0);
		if (py_value == NULL) {
			return NULL;
		}
		{
			int value_cntr_1;
			for (value_cntr_1 = 0; value_cntr_1 < (r->out.length?*r->out.length:0); value_cntr_1++) {
				PyObject *py_value_1;
				py_value_1 = PyLong_FromLong((uint16_t)((r->out.value)[value_cntr_1]));
				PyList_SetItem(py_value, value_cntr_1, py_value_1);
			}
		}
	}
	PyTuple_SetItem(result, 2, py_value);

	if (r->out.size == NULL) {
		py_size = Py_None;
		Py_INCREF(py_size);
	} else {
		py_size = PyLong_FromUnsignedLongLong((uint32_t)(*r->out.size));
	}
	PyTuple_SetItem(result, 3, py_size);

	if (r->out.length == NULL) {
		py_length = Py_None;
		Py_INCREF(py_length);
	} else {
		py_length = PyLong_FromUnsignedLongLong((uint32_t)(*r->out.length));
	}
	PyTuple_SetItem(result, 4, py_length);

	if (!raise_result_exception) {
		PyTuple_SetItem(result, 5, PyErr_FromWERROR(r->out.result));
	}

	return result;
}


static PyObject *py_winreg_FlushKey_in_get_handle(PyObject *obj, void *closure)
{
	struct winreg_FlushKey *object = pytalloc_get_ptr(obj);
	PyObject *py_handle;
	if (object->in.handle == NULL) {
		Py_RETURN_NONE;
	}
	py_handle = pytalloc_reference_ex(policy_handle_Type, object->in.handle, object->in.handle);
	return py_handle;
}

static int py_winreg_FlushKey_in_set_handle(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winreg_FlushKey *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->in.handle));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.handle");
		return -1;
	}
	object->in.handle = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->in.handle);
	if (object->in.handle == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	PY_CHECK_TYPE(policy_handle_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->in.handle = (struct policy_handle *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_winreg_FlushKey_get_result(PyObject *obj, void *closure)
{
	struct winreg_FlushKey *object = pytalloc_get_ptr(obj);
	PyObject *py_result;
	py_result = PyErr_FromWERROR(object->out.result);
	return py_result;
}

static int py_winreg_FlushKey_set_result(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winreg_FlushKey *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->out.result");
		return -1;
	}
	object->out.result = W_ERROR(PyLong_AsLong(value));
	return 0;
}

static PyGetSetDef py_winreg_FlushKey_getsetters[] = {
	{
		.name = discard_const_p(char, "in_handle"),
		.get = py_winreg_FlushKey_in_get_handle,
		.set = py_winreg_FlushKey_in_set_handle,
		.doc = discard_const_p(char, "PIDL-generated element of base type policy_handle")
	},
	{
		.name = discard_const_p(char, "result"),
		.get = py_winreg_FlushKey_get_result,
		.set = py_winreg_FlushKey_set_result,
		.doc = discard_const_p(char, "PIDL-generated element of type WERROR")
	},
	{ .name = NULL }
};

static PyObject *py_winreg_FlushKey_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyObject *self = pytalloc_new(struct winreg_FlushKey, type);
	struct winreg_FlushKey *_self = (struct winreg_FlushKey *)pytalloc_get_ptr(self);
	TALLOC_CTX *mem_ctx = pytalloc_get_mem_ctx(self);
	_self->in.handle = talloc_zero(mem_ctx, struct policy_handle);
	return self;
}

static PyObject *py_winreg_FlushKey_ndr_opnum(PyTypeObject *type, PyObject *Py_UNUSED(ignored))
{


	return PyLong_FromLong(11);
}

static PyObject *py_winreg_FlushKey_ndr_pack(PyObject *py_obj, ndr_flags_type ndr_inout_flags, libndr_flags ndr_push_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct winreg_FlushKey *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	struct ndr_push *push = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;

	if (ndr_table_winreg.num_calls < 12) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_winreg_FlushKey_ndr_pack");
		return NULL;
	}
	call = &ndr_table_winreg.calls[11];

	push = ndr_push_init_ctx(pytalloc_get_mem_ctx(py_obj));
	if (push == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	push->flags |= ndr_push_flags;

	err = call->ndr_push(push, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(push);
		PyErr_SetNdrError(err);
		return NULL;
	}
	blob = ndr_push_blob(push);
	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(push);
	return ret;
}

static PyObject *py_winreg_FlushKey_ndr_pack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_in__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_winreg_FlushKey_ndr_pack(py_obj, NDR_IN, ndr_push_flags);
}

static PyObject *py_winreg_FlushKey_ndr_pack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_out__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_winreg_FlushKey_ndr_pack(py_obj, NDR_OUT, ndr_push_flags);
}

static PyObject *py_winreg_FlushKey_ndr_unpack(PyObject *py_obj, const DATA_BLOB *blob, ndr_flags_type ndr_inout_flags, libndr_flags ndr_pull_flags, bool allow_remaining)
{
	const struct ndr_interface_call *call = NULL;
	struct winreg_FlushKey *object = pytalloc_get_ptr(py_obj);
	struct ndr_pull *pull = NULL;
	enum ndr_err_code err;

	if (ndr_table_winreg.num_calls < 12) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_winreg_FlushKey_ndr_unpack");
		return NULL;
	}
	call = &ndr_table_winreg.calls[11];

	pull = ndr_pull_init_blob(blob, object);
	if (pull == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	pull->flags |= ndr_pull_flags;

	err = call->ndr_pull(pull, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(pull);
		PyErr_SetNdrError(err);
		return NULL;
	}
	if (!allow_remaining) {
		uint32_t highest_ofs;

		if (pull->offset > pull->relative_highest_offset) {
			highest_ofs = pull->offset;
		} else {
			highest_ofs = pull->relative_highest_offset;
		}
		if (highest_ofs < pull->data_size) {
			err = ndr_pull_error(pull, NDR_ERR_UNREAD_BYTES,
				"not all bytes consumed ofs[%u] size[%u]",
				highest_ofs, pull->data_size);
			TALLOC_FREE(pull);
			PyErr_SetNdrError(err);
			return NULL;
		}
	}

	TALLOC_FREE(pull);
	Py_RETURN_NONE;
}

static PyObject *py_winreg_FlushKey_ndr_unpack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_in__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_winreg_FlushKey_ndr_unpack(py_obj, &blob, NDR_IN, ndr_pull_flags, allow_remaining);
}

static PyObject *py_winreg_FlushKey_ndr_unpack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_out__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_winreg_FlushKey_ndr_unpack(py_obj, &blob, NDR_OUT, ndr_pull_flags, allow_remaining);
}

static PyObject *py_winreg_FlushKey_ndr_print(PyObject *py_obj, PyObject *args, PyObject *kwargs, const char *name, ndr_flags_type ndr_inout_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct winreg_FlushKey *object = pytalloc_get_ptr(py_obj);
	const char * const kwnames[] = { "print_secrets", NULL };
	PyObject *py_print_secrets = NULL;
	PyObject *ret;
	char *retstr;
	bool ok;

	ok = PyArg_ParseTupleAndKeywords(args, kwargs, "|O:__ndr_print__",
		discard_const_p(char *, kwnames),
		&py_print_secrets);
	if (!ok) {
		return NULL;
	}

	if (ndr_table_winreg.num_calls < 12) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_winreg_FlushKey_ndr_print");
		return NULL;
	}
	call = &ndr_table_winreg.calls[11];

	if (py_print_secrets != NULL && PyObject_IsTrue(py_print_secrets)) {
		retstr = ndr_print_function_secret_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	} else {
		retstr = ndr_print_function_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	}
	ret = PyUnicode_FromString(retstr);
	TALLOC_FREE(retstr);

	return ret;
}

static PyObject *py_winreg_FlushKey_ndr_print_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	return py_winreg_FlushKey_ndr_print(py_obj, args, kwargs, "winreg_FlushKey_in", NDR_IN);
}

static PyObject *py_winreg_FlushKey_ndr_print_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	return py_winreg_FlushKey_ndr_print(py_obj, args, kwargs, "winreg_FlushKey_out", NDR_OUT);
}

static PyMethodDef py_winreg_FlushKey_methods[] = {
	{ "opnum", (PyCFunction)py_winreg_FlushKey_ndr_opnum, METH_NOARGS|METH_CLASS,
		"winreg.FlushKey.opnum() -> 11 (0x0b) " },
	{ "__ndr_pack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winreg_FlushKey_ndr_pack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_in(object, bigendian=False, ndr64=False) -> blob\nNDR pack input" },
	{ "__ndr_pack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winreg_FlushKey_ndr_pack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_out(object, bigendian=False, ndr64=False) -> blob\nNDR pack output" },
	{ "__ndr_unpack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winreg_FlushKey_ndr_unpack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_in(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack input" },
	{ "__ndr_unpack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winreg_FlushKey_ndr_unpack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_out(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack output" },
	{ "__ndr_print_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winreg_FlushKey_ndr_print_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_print_in(object, print_secrets=False) -> String\nNDR print input" },
	{ "__ndr_print_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winreg_FlushKey_ndr_print_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_print_out(object, print_secrets=False) -> String\nNDR print output" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject winreg_FlushKey_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "winreg.FlushKey",
	.tp_getset = py_winreg_FlushKey_getsetters,
	.tp_methods = py_winreg_FlushKey_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_winreg_FlushKey_new,
};

static bool pack_py_winreg_FlushKey_args_in(PyObject *args, PyObject *kwargs, struct winreg_FlushKey *r)
{
	PyObject *py_handle;
	const char *kwnames[] = {
		"handle", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "O:winreg_FlushKey", discard_const_p(char *, kwnames), &py_handle)) {
		return false;
	}

	if (py_handle == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.handle");
		return false;
	}
	r->in.handle = talloc_ptrtype(r, r->in.handle);
	if (r->in.handle == NULL) {
		PyErr_NoMemory();
		return false;
	}
	PY_CHECK_TYPE(policy_handle_Type, py_handle, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_handle)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.handle = (struct policy_handle *)pytalloc_get_ptr(py_handle);
	return true;
}

static PyObject *unpack_py_winreg_FlushKey_args_out(struct winreg_FlushKey *r, bool raise_result_exception)
{
	PyObject *result = NULL;
	size_t result_size = 0;

	if (raise_result_exception) {
		if (!W_ERROR_IS_OK(r->out.result)) {
			PyErr_SetWERROR(r->out.result);
			return NULL;
		}

	} else {
		/* WERROR will be part of the results */
		result_size += 1;
	}

	if (!raise_result_exception) {
		result = PyErr_FromWERROR(r->out.result);
	}

	if (result_size == 0) {
		result = Py_None;
		Py_INCREF(result);
	}

	return result;
}


static PyObject *py_winreg_GetKeySecurity_in_get_handle(PyObject *obj, void *closure)
{
	struct winreg_GetKeySecurity *object = pytalloc_get_ptr(obj);
	PyObject *py_handle;
	if (object->in.handle == NULL) {
		Py_RETURN_NONE;
	}
	py_handle = pytalloc_reference_ex(policy_handle_Type, object->in.handle, object->in.handle);
	return py_handle;
}

static int py_winreg_GetKeySecurity_in_set_handle(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winreg_GetKeySecurity *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->in.handle));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.handle");
		return -1;
	}
	object->in.handle = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->in.handle);
	if (object->in.handle == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	PY_CHECK_TYPE(policy_handle_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->in.handle = (struct policy_handle *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_winreg_GetKeySecurity_in_get_sec_info(PyObject *obj, void *closure)
{
	struct winreg_GetKeySecurity *object = pytalloc_get_ptr(obj);
	PyObject *py_sec_info;
	py_sec_info = PyLong_FromUnsignedLongLong((uint32_t)(object->in.sec_info));
	return py_sec_info;
}

static int py_winreg_GetKeySecurity_in_set_sec_info(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winreg_GetKeySecurity *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.sec_info");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->in.sec_info));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->in.sec_info = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_winreg_GetKeySecurity_in_get_sd(PyObject *obj, void *closure)
{
	struct winreg_GetKeySecurity *object = pytalloc_get_ptr(obj);
	PyObject *py_sd;
	if (object->in.sd == NULL) {
		Py_RETURN_NONE;
	}
	py_sd = pytalloc_reference_ex(&KeySecurityData_Type, object->in.sd, object->in.sd);
	return py_sd;
}

static int py_winreg_GetKeySecurity_in_set_sd(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winreg_GetKeySecurity *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->in.sd));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.sd");
		return -1;
	}
	object->in.sd = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->in.sd);
	if (object->in.sd == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	PY_CHECK_TYPE(&KeySecurityData_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->in.sd = (struct KeySecurityData *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_winreg_GetKeySecurity_out_get_sd(PyObject *obj, void *closure)
{
	struct winreg_GetKeySecurity *object = pytalloc_get_ptr(obj);
	PyObject *py_sd;
	if (object->out.sd == NULL) {
		Py_RETURN_NONE;
	}
	py_sd = pytalloc_reference_ex(&KeySecurityData_Type, object->out.sd, object->out.sd);
	return py_sd;
}

static int py_winreg_GetKeySecurity_out_set_sd(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winreg_GetKeySecurity *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->out.sd));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->out.sd");
		return -1;
	}
	object->out.sd = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->out.sd);
	if (object->out.sd == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	PY_CHECK_TYPE(&KeySecurityData_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->out.sd = (struct KeySecurityData *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_winreg_GetKeySecurity_get_result(PyObject *obj, void *closure)
{
	struct winreg_GetKeySecurity *object = pytalloc_get_ptr(obj);
	PyObject *py_result;
	py_result = PyErr_FromWERROR(object->out.result);
	return py_result;
}

static int py_winreg_GetKeySecurity_set_result(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winreg_GetKeySecurity *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->out.result");
		return -1;
	}
	object->out.result = W_ERROR(PyLong_AsLong(value));
	return 0;
}

static PyGetSetDef py_winreg_GetKeySecurity_getsetters[] = {
	{
		.name = discard_const_p(char, "in_handle"),
		.get = py_winreg_GetKeySecurity_in_get_handle,
		.set = py_winreg_GetKeySecurity_in_set_handle,
		.doc = discard_const_p(char, "PIDL-generated element of base type policy_handle")
	},
	{
		.name = discard_const_p(char, "in_sec_info"),
		.get = py_winreg_GetKeySecurity_in_get_sec_info,
		.set = py_winreg_GetKeySecurity_in_set_sec_info,
		.doc = discard_const_p(char, "PIDL-generated element of base type security_secinfo")
	},
	{
		.name = discard_const_p(char, "in_sd"),
		.get = py_winreg_GetKeySecurity_in_get_sd,
		.set = py_winreg_GetKeySecurity_in_set_sd,
		.doc = discard_const_p(char, "PIDL-generated element of base type KeySecurityData")
	},
	{
		.name = discard_const_p(char, "out_sd"),
		.get = py_winreg_GetKeySecurity_out_get_sd,
		.set = py_winreg_GetKeySecurity_out_set_sd,
		.doc = discard_const_p(char, "PIDL-generated element of base type KeySecurityData")
	},
	{
		.name = discard_const_p(char, "result"),
		.get = py_winreg_GetKeySecurity_get_result,
		.set = py_winreg_GetKeySecurity_set_result,
		.doc = discard_const_p(char, "PIDL-generated element of type WERROR")
	},
	{ .name = NULL }
};

static PyObject *py_winreg_GetKeySecurity_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyObject *self = pytalloc_new(struct winreg_GetKeySecurity, type);
	struct winreg_GetKeySecurity *_self = (struct winreg_GetKeySecurity *)pytalloc_get_ptr(self);
	TALLOC_CTX *mem_ctx = pytalloc_get_mem_ctx(self);
	_self->in.handle = talloc_zero(mem_ctx, struct policy_handle);
	_self->in.sd = talloc_zero(mem_ctx, struct KeySecurityData);
	_self->out.sd = talloc_zero(mem_ctx, struct KeySecurityData);
	return self;
}

static PyObject *py_winreg_GetKeySecurity_ndr_opnum(PyTypeObject *type, PyObject *Py_UNUSED(ignored))
{


	return PyLong_FromLong(12);
}

static PyObject *py_winreg_GetKeySecurity_ndr_pack(PyObject *py_obj, ndr_flags_type ndr_inout_flags, libndr_flags ndr_push_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct winreg_GetKeySecurity *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	struct ndr_push *push = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;

	if (ndr_table_winreg.num_calls < 13) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_winreg_GetKeySecurity_ndr_pack");
		return NULL;
	}
	call = &ndr_table_winreg.calls[12];

	push = ndr_push_init_ctx(pytalloc_get_mem_ctx(py_obj));
	if (push == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	push->flags |= ndr_push_flags;

	err = call->ndr_push(push, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(push);
		PyErr_SetNdrError(err);
		return NULL;
	}
	blob = ndr_push_blob(push);
	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(push);
	return ret;
}

static PyObject *py_winreg_GetKeySecurity_ndr_pack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_in__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_winreg_GetKeySecurity_ndr_pack(py_obj, NDR_IN, ndr_push_flags);
}

static PyObject *py_winreg_GetKeySecurity_ndr_pack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_out__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_winreg_GetKeySecurity_ndr_pack(py_obj, NDR_OUT, ndr_push_flags);
}

static PyObject *py_winreg_GetKeySecurity_ndr_unpack(PyObject *py_obj, const DATA_BLOB *blob, ndr_flags_type ndr_inout_flags, libndr_flags ndr_pull_flags, bool allow_remaining)
{
	const struct ndr_interface_call *call = NULL;
	struct winreg_GetKeySecurity *object = pytalloc_get_ptr(py_obj);
	struct ndr_pull *pull = NULL;
	enum ndr_err_code err;

	if (ndr_table_winreg.num_calls < 13) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_winreg_GetKeySecurity_ndr_unpack");
		return NULL;
	}
	call = &ndr_table_winreg.calls[12];

	pull = ndr_pull_init_blob(blob, object);
	if (pull == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	pull->flags |= ndr_pull_flags;

	err = call->ndr_pull(pull, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(pull);
		PyErr_SetNdrError(err);
		return NULL;
	}
	if (!allow_remaining) {
		uint32_t highest_ofs;

		if (pull->offset > pull->relative_highest_offset) {
			highest_ofs = pull->offset;
		} else {
			highest_ofs = pull->relative_highest_offset;
		}
		if (highest_ofs < pull->data_size) {
			err = ndr_pull_error(pull, NDR_ERR_UNREAD_BYTES,
				"not all bytes consumed ofs[%u] size[%u]",
				highest_ofs, pull->data_size);
			TALLOC_FREE(pull);
			PyErr_SetNdrError(err);
			return NULL;
		}
	}

	TALLOC_FREE(pull);
	Py_RETURN_NONE;
}

static PyObject *py_winreg_GetKeySecurity_ndr_unpack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_in__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_winreg_GetKeySecurity_ndr_unpack(py_obj, &blob, NDR_IN, ndr_pull_flags, allow_remaining);
}

static PyObject *py_winreg_GetKeySecurity_ndr_unpack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_out__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_winreg_GetKeySecurity_ndr_unpack(py_obj, &blob, NDR_OUT, ndr_pull_flags, allow_remaining);
}

static PyObject *py_winreg_GetKeySecurity_ndr_print(PyObject *py_obj, PyObject *args, PyObject *kwargs, const char *name, ndr_flags_type ndr_inout_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct winreg_GetKeySecurity *object = pytalloc_get_ptr(py_obj);
	const char * const kwnames[] = { "print_secrets", NULL };
	PyObject *py_print_secrets = NULL;
	PyObject *ret;
	char *retstr;
	bool ok;

	ok = PyArg_ParseTupleAndKeywords(args, kwargs, "|O:__ndr_print__",
		discard_const_p(char *, kwnames),
		&py_print_secrets);
	if (!ok) {
		return NULL;
	}

	if (ndr_table_winreg.num_calls < 13) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_winreg_GetKeySecurity_ndr_print");
		return NULL;
	}
	call = &ndr_table_winreg.calls[12];

	if (py_print_secrets != NULL && PyObject_IsTrue(py_print_secrets)) {
		retstr = ndr_print_function_secret_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	} else {
		retstr = ndr_print_function_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	}
	ret = PyUnicode_FromString(retstr);
	TALLOC_FREE(retstr);

	return ret;
}

static PyObject *py_winreg_GetKeySecurity_ndr_print_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	return py_winreg_GetKeySecurity_ndr_print(py_obj, args, kwargs, "winreg_GetKeySecurity_in", NDR_IN);
}

static PyObject *py_winreg_GetKeySecurity_ndr_print_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	return py_winreg_GetKeySecurity_ndr_print(py_obj, args, kwargs, "winreg_GetKeySecurity_out", NDR_OUT);
}

static PyMethodDef py_winreg_GetKeySecurity_methods[] = {
	{ "opnum", (PyCFunction)py_winreg_GetKeySecurity_ndr_opnum, METH_NOARGS|METH_CLASS,
		"winreg.GetKeySecurity.opnum() -> 12 (0x0c) " },
	{ "__ndr_pack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winreg_GetKeySecurity_ndr_pack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_in(object, bigendian=False, ndr64=False) -> blob\nNDR pack input" },
	{ "__ndr_pack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winreg_GetKeySecurity_ndr_pack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_out(object, bigendian=False, ndr64=False) -> blob\nNDR pack output" },
	{ "__ndr_unpack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winreg_GetKeySecurity_ndr_unpack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_in(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack input" },
	{ "__ndr_unpack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winreg_GetKeySecurity_ndr_unpack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_out(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack output" },
	{ "__ndr_print_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winreg_GetKeySecurity_ndr_print_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_print_in(object, print_secrets=False) -> String\nNDR print input" },
	{ "__ndr_print_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winreg_GetKeySecurity_ndr_print_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_print_out(object, print_secrets=False) -> String\nNDR print output" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject winreg_GetKeySecurity_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "winreg.GetKeySecurity",
	.tp_getset = py_winreg_GetKeySecurity_getsetters,
	.tp_methods = py_winreg_GetKeySecurity_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_winreg_GetKeySecurity_new,
};

static bool pack_py_winreg_GetKeySecurity_args_in(PyObject *args, PyObject *kwargs, struct winreg_GetKeySecurity *r)
{
	PyObject *py_handle;
	PyObject *py_sec_info;
	PyObject *py_sd;
	const char *kwnames[] = {
		"handle", "sec_info", "sd", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOO:winreg_GetKeySecurity", discard_const_p(char *, kwnames), &py_handle, &py_sec_info, &py_sd)) {
		return false;
	}

	if (py_handle == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.handle");
		return false;
	}
	r->in.handle = talloc_ptrtype(r, r->in.handle);
	if (r->in.handle == NULL) {
		PyErr_NoMemory();
		return false;
	}
	PY_CHECK_TYPE(policy_handle_Type, py_handle, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_handle)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.handle = (struct policy_handle *)pytalloc_get_ptr(py_handle);
	if (py_sec_info == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.sec_info");
		return false;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(r->in.sec_info));
		if (PyLong_Check(py_sec_info)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(py_sec_info);
			if (PyErr_Occurred() != NULL) {
				return false;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return false;
			}
			r->in.sec_info = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return false;
		}
	}
	if (py_sd == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.sd");
		return false;
	}
	r->in.sd = talloc_ptrtype(r, r->in.sd);
	if (r->in.sd == NULL) {
		PyErr_NoMemory();
		return false;
	}
	PY_CHECK_TYPE(&KeySecurityData_Type, py_sd, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_sd)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.sd = (struct KeySecurityData *)pytalloc_get_ptr(py_sd);
	return true;
}

static PyObject *unpack_py_winreg_GetKeySecurity_args_out(struct winreg_GetKeySecurity *r, bool raise_result_exception)
{
	PyObject *py_sd = NULL;
	PyObject *result = NULL;
	size_t result_size = 1;

	if (raise_result_exception) {
		if (!W_ERROR_IS_OK(r->out.result)) {
			PyErr_SetWERROR(r->out.result);
			return NULL;
		}

	} else {
		/* WERROR will be part of the results */
		result_size += 1;
	}

	if (result_size > 1) {
		result = PyTuple_New(result_size);
		if (result == NULL) {
			return NULL;
		}
	}

	py_sd = pytalloc_reference_ex(&KeySecurityData_Type, r->out.sd, r->out.sd);
	if (result_size > 1) {
		PyTuple_SetItem(result, 0, py_sd);
	}
	if (result_size == 1) {
		result = py_sd;
	}

	if (!raise_result_exception) {
		PyTuple_SetItem(result, 1, PyErr_FromWERROR(r->out.result));
	}

	return result;
}


static PyObject *py_winreg_LoadKey_in_get_handle(PyObject *obj, void *closure)
{
	struct winreg_LoadKey *object = pytalloc_get_ptr(obj);
	PyObject *py_handle;
	if (object->in.handle == NULL) {
		Py_RETURN_NONE;
	}
	py_handle = pytalloc_reference_ex(policy_handle_Type, object->in.handle, object->in.handle);
	return py_handle;
}

static int py_winreg_LoadKey_in_set_handle(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winreg_LoadKey *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->in.handle));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.handle");
		return -1;
	}
	object->in.handle = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->in.handle);
	if (object->in.handle == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	PY_CHECK_TYPE(policy_handle_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->in.handle = (struct policy_handle *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_winreg_LoadKey_in_get_keyname(PyObject *obj, void *closure)
{
	struct winreg_LoadKey *object = pytalloc_get_ptr(obj);
	PyObject *py_keyname;
	if (object->in.keyname == NULL) {
		Py_RETURN_NONE;
	}
	if (object->in.keyname == NULL) {
		py_keyname = Py_None;
		Py_INCREF(py_keyname);
	} else {
		py_keyname = pytalloc_reference_ex(&winreg_String_Type, object->in.keyname, object->in.keyname);
	}
	return py_keyname;
}

static int py_winreg_LoadKey_in_set_keyname(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winreg_LoadKey *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->in.keyname));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.keyname");
		return -1;
	}
	if (value == Py_None) {
		object->in.keyname = NULL;
	} else {
		object->in.keyname = NULL;
		PY_CHECK_TYPE(&winreg_String_Type, value, return -1;);
		if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->in.keyname = (struct winreg_String *)pytalloc_get_ptr(value);
	}
	return 0;
}

static PyObject *py_winreg_LoadKey_in_get_filename(PyObject *obj, void *closure)
{
	struct winreg_LoadKey *object = pytalloc_get_ptr(obj);
	PyObject *py_filename;
	if (object->in.filename == NULL) {
		Py_RETURN_NONE;
	}
	if (object->in.filename == NULL) {
		py_filename = Py_None;
		Py_INCREF(py_filename);
	} else {
		py_filename = pytalloc_reference_ex(&winreg_String_Type, object->in.filename, object->in.filename);
	}
	return py_filename;
}

static int py_winreg_LoadKey_in_set_filename(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winreg_LoadKey *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->in.filename));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.filename");
		return -1;
	}
	if (value == Py_None) {
		object->in.filename = NULL;
	} else {
		object->in.filename = NULL;
		PY_CHECK_TYPE(&winreg_String_Type, value, return -1;);
		if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->in.filename = (struct winreg_String *)pytalloc_get_ptr(value);
	}
	return 0;
}

static PyObject *py_winreg_LoadKey_get_result(PyObject *obj, void *closure)
{
	struct winreg_LoadKey *object = pytalloc_get_ptr(obj);
	PyObject *py_result;
	py_result = PyErr_FromWERROR(object->out.result);
	return py_result;
}

static int py_winreg_LoadKey_set_result(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winreg_LoadKey *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->out.result");
		return -1;
	}
	object->out.result = W_ERROR(PyLong_AsLong(value));
	return 0;
}

static PyGetSetDef py_winreg_LoadKey_getsetters[] = {
	{
		.name = discard_const_p(char, "in_handle"),
		.get = py_winreg_LoadKey_in_get_handle,
		.set = py_winreg_LoadKey_in_set_handle,
		.doc = discard_const_p(char, "PIDL-generated element of base type policy_handle")
	},
	{
		.name = discard_const_p(char, "in_keyname"),
		.get = py_winreg_LoadKey_in_get_keyname,
		.set = py_winreg_LoadKey_in_set_keyname,
		.doc = discard_const_p(char, "PIDL-generated element of base type winreg_String")
	},
	{
		.name = discard_const_p(char, "in_filename"),
		.get = py_winreg_LoadKey_in_get_filename,
		.set = py_winreg_LoadKey_in_set_filename,
		.doc = discard_const_p(char, "PIDL-generated element of base type winreg_String")
	},
	{
		.name = discard_const_p(char, "result"),
		.get = py_winreg_LoadKey_get_result,
		.set = py_winreg_LoadKey_set_result,
		.doc = discard_const_p(char, "PIDL-generated element of type WERROR")
	},
	{ .name = NULL }
};

static PyObject *py_winreg_LoadKey_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyObject *self = pytalloc_new(struct winreg_LoadKey, type);
	struct winreg_LoadKey *_self = (struct winreg_LoadKey *)pytalloc_get_ptr(self);
	TALLOC_CTX *mem_ctx = pytalloc_get_mem_ctx(self);
	_self->in.handle = talloc_zero(mem_ctx, struct policy_handle);
	return self;
}

static PyObject *py_winreg_LoadKey_ndr_opnum(PyTypeObject *type, PyObject *Py_UNUSED(ignored))
{


	return PyLong_FromLong(13);
}

static PyObject *py_winreg_LoadKey_ndr_pack(PyObject *py_obj, ndr_flags_type ndr_inout_flags, libndr_flags ndr_push_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct winreg_LoadKey *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	struct ndr_push *push = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;

	if (ndr_table_winreg.num_calls < 14) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_winreg_LoadKey_ndr_pack");
		return NULL;
	}
	call = &ndr_table_winreg.calls[13];

	push = ndr_push_init_ctx(pytalloc_get_mem_ctx(py_obj));
	if (push == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	push->flags |= ndr_push_flags;

	err = call->ndr_push(push, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(push);
		PyErr_SetNdrError(err);
		return NULL;
	}
	blob = ndr_push_blob(push);
	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(push);
	return ret;
}

static PyObject *py_winreg_LoadKey_ndr_pack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_in__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_winreg_LoadKey_ndr_pack(py_obj, NDR_IN, ndr_push_flags);
}

static PyObject *py_winreg_LoadKey_ndr_pack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_out__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_winreg_LoadKey_ndr_pack(py_obj, NDR_OUT, ndr_push_flags);
}

static PyObject *py_winreg_LoadKey_ndr_unpack(PyObject *py_obj, const DATA_BLOB *blob, ndr_flags_type ndr_inout_flags, libndr_flags ndr_pull_flags, bool allow_remaining)
{
	const struct ndr_interface_call *call = NULL;
	struct winreg_LoadKey *object = pytalloc_get_ptr(py_obj);
	struct ndr_pull *pull = NULL;
	enum ndr_err_code err;

	if (ndr_table_winreg.num_calls < 14) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_winreg_LoadKey_ndr_unpack");
		return NULL;
	}
	call = &ndr_table_winreg.calls[13];

	pull = ndr_pull_init_blob(blob, object);
	if (pull == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	pull->flags |= ndr_pull_flags;

	err = call->ndr_pull(pull, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(pull);
		PyErr_SetNdrError(err);
		return NULL;
	}
	if (!allow_remaining) {
		uint32_t highest_ofs;

		if (pull->offset > pull->relative_highest_offset) {
			highest_ofs = pull->offset;
		} else {
			highest_ofs = pull->relative_highest_offset;
		}
		if (highest_ofs < pull->data_size) {
			err = ndr_pull_error(pull, NDR_ERR_UNREAD_BYTES,
				"not all bytes consumed ofs[%u] size[%u]",
				highest_ofs, pull->data_size);
			TALLOC_FREE(pull);
			PyErr_SetNdrError(err);
			return NULL;
		}
	}

	TALLOC_FREE(pull);
	Py_RETURN_NONE;
}

static PyObject *py_winreg_LoadKey_ndr_unpack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_in__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_winreg_LoadKey_ndr_unpack(py_obj, &blob, NDR_IN, ndr_pull_flags, allow_remaining);
}

static PyObject *py_winreg_LoadKey_ndr_unpack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_out__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_winreg_LoadKey_ndr_unpack(py_obj, &blob, NDR_OUT, ndr_pull_flags, allow_remaining);
}

static PyObject *py_winreg_LoadKey_ndr_print(PyObject *py_obj, PyObject *args, PyObject *kwargs, const char *name, ndr_flags_type ndr_inout_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct winreg_LoadKey *object = pytalloc_get_ptr(py_obj);
	const char * const kwnames[] = { "print_secrets", NULL };
	PyObject *py_print_secrets = NULL;
	PyObject *ret;
	char *retstr;
	bool ok;

	ok = PyArg_ParseTupleAndKeywords(args, kwargs, "|O:__ndr_print__",
		discard_const_p(char *, kwnames),
		&py_print_secrets);
	if (!ok) {
		return NULL;
	}

	if (ndr_table_winreg.num_calls < 14) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_winreg_LoadKey_ndr_print");
		return NULL;
	}
	call = &ndr_table_winreg.calls[13];

	if (py_print_secrets != NULL && PyObject_IsTrue(py_print_secrets)) {
		retstr = ndr_print_function_secret_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	} else {
		retstr = ndr_print_function_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	}
	ret = PyUnicode_FromString(retstr);
	TALLOC_FREE(retstr);

	return ret;
}

static PyObject *py_winreg_LoadKey_ndr_print_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	return py_winreg_LoadKey_ndr_print(py_obj, args, kwargs, "winreg_LoadKey_in", NDR_IN);
}

static PyObject *py_winreg_LoadKey_ndr_print_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	return py_winreg_LoadKey_ndr_print(py_obj, args, kwargs, "winreg_LoadKey_out", NDR_OUT);
}

static PyMethodDef py_winreg_LoadKey_methods[] = {
	{ "opnum", (PyCFunction)py_winreg_LoadKey_ndr_opnum, METH_NOARGS|METH_CLASS,
		"winreg.LoadKey.opnum() -> 13 (0x0d) " },
	{ "__ndr_pack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winreg_LoadKey_ndr_pack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_in(object, bigendian=False, ndr64=False) -> blob\nNDR pack input" },
	{ "__ndr_pack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winreg_LoadKey_ndr_pack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_out(object, bigendian=False, ndr64=False) -> blob\nNDR pack output" },
	{ "__ndr_unpack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winreg_LoadKey_ndr_unpack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_in(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack input" },
	{ "__ndr_unpack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winreg_LoadKey_ndr_unpack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_out(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack output" },
	{ "__ndr_print_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winreg_LoadKey_ndr_print_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_print_in(object, print_secrets=False) -> String\nNDR print input" },
	{ "__ndr_print_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winreg_LoadKey_ndr_print_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_print_out(object, print_secrets=False) -> String\nNDR print output" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject winreg_LoadKey_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "winreg.LoadKey",
	.tp_getset = py_winreg_LoadKey_getsetters,
	.tp_methods = py_winreg_LoadKey_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_winreg_LoadKey_new,
};

static bool pack_py_winreg_LoadKey_args_in(PyObject *args, PyObject *kwargs, struct winreg_LoadKey *r)
{
	PyObject *py_handle;
	PyObject *py_keyname;
	PyObject *py_filename;
	const char *kwnames[] = {
		"handle", "keyname", "filename", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOO:winreg_LoadKey", discard_const_p(char *, kwnames), &py_handle, &py_keyname, &py_filename)) {
		return false;
	}

	if (py_handle == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.handle");
		return false;
	}
	r->in.handle = talloc_ptrtype(r, r->in.handle);
	if (r->in.handle == NULL) {
		PyErr_NoMemory();
		return false;
	}
	PY_CHECK_TYPE(policy_handle_Type, py_handle, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_handle)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.handle = (struct policy_handle *)pytalloc_get_ptr(py_handle);
	if (py_keyname == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.keyname");
		return false;
	}
	if (py_keyname == Py_None) {
		r->in.keyname = NULL;
	} else {
		r->in.keyname = NULL;
		PY_CHECK_TYPE(&winreg_String_Type, py_keyname, return false;);
		if (talloc_reference(r, pytalloc_get_mem_ctx(py_keyname)) == NULL) {
			PyErr_NoMemory();
			return false;
		}
		r->in.keyname = (struct winreg_String *)pytalloc_get_ptr(py_keyname);
	}
	if (py_filename == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.filename");
		return false;
	}
	if (py_filename == Py_None) {
		r->in.filename = NULL;
	} else {
		r->in.filename = NULL;
		PY_CHECK_TYPE(&winreg_String_Type, py_filename, return false;);
		if (talloc_reference(r, pytalloc_get_mem_ctx(py_filename)) == NULL) {
			PyErr_NoMemory();
			return false;
		}
		r->in.filename = (struct winreg_String *)pytalloc_get_ptr(py_filename);
	}
	return true;
}

static PyObject *unpack_py_winreg_LoadKey_args_out(struct winreg_LoadKey *r, bool raise_result_exception)
{
	PyObject *result = NULL;
	size_t result_size = 0;

	if (raise_result_exception) {
		if (!W_ERROR_IS_OK(r->out.result)) {
			PyErr_SetWERROR(r->out.result);
			return NULL;
		}

	} else {
		/* WERROR will be part of the results */
		result_size += 1;
	}

	if (!raise_result_exception) {
		result = PyErr_FromWERROR(r->out.result);
	}

	if (result_size == 0) {
		result = Py_None;
		Py_INCREF(result);
	}

	return result;
}


static PyObject *py_winreg_NotifyChangeKeyValue_in_get_handle(PyObject *obj, void *closure)
{
	struct winreg_NotifyChangeKeyValue *object = pytalloc_get_ptr(obj);
	PyObject *py_handle;
	if (object->in.handle == NULL) {
		Py_RETURN_NONE;
	}
	py_handle = pytalloc_reference_ex(policy_handle_Type, object->in.handle, object->in.handle);
	return py_handle;
}

static int py_winreg_NotifyChangeKeyValue_in_set_handle(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winreg_NotifyChangeKeyValue *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->in.handle));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.handle");
		return -1;
	}
	object->in.handle = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->in.handle);
	if (object->in.handle == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	PY_CHECK_TYPE(policy_handle_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->in.handle = (struct policy_handle *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_winreg_NotifyChangeKeyValue_in_get_watch_subtree(PyObject *obj, void *closure)
{
	struct winreg_NotifyChangeKeyValue *object = pytalloc_get_ptr(obj);
	PyObject *py_watch_subtree;
	py_watch_subtree = PyLong_FromLong((uint16_t)(object->in.watch_subtree));
	return py_watch_subtree;
}

static int py_winreg_NotifyChangeKeyValue_in_set_watch_subtree(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winreg_NotifyChangeKeyValue *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.watch_subtree");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->in.watch_subtree));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->in.watch_subtree = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_winreg_NotifyChangeKeyValue_in_get_notify_filter(PyObject *obj, void *closure)
{
	struct winreg_NotifyChangeKeyValue *object = pytalloc_get_ptr(obj);
	PyObject *py_notify_filter;
	py_notify_filter = PyLong_FromUnsignedLongLong((uint32_t)(object->in.notify_filter));
	return py_notify_filter;
}

static int py_winreg_NotifyChangeKeyValue_in_set_notify_filter(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winreg_NotifyChangeKeyValue *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.notify_filter");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->in.notify_filter));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->in.notify_filter = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_winreg_NotifyChangeKeyValue_in_get_unknown(PyObject *obj, void *closure)
{
	struct winreg_NotifyChangeKeyValue *object = pytalloc_get_ptr(obj);
	PyObject *py_unknown;
	py_unknown = PyLong_FromUnsignedLongLong((uint32_t)(object->in.unknown));
	return py_unknown;
}

static int py_winreg_NotifyChangeKeyValue_in_set_unknown(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winreg_NotifyChangeKeyValue *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.unknown");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->in.unknown));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->in.unknown = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_winreg_NotifyChangeKeyValue_in_get_string1(PyObject *obj, void *closure)
{
	struct winreg_NotifyChangeKeyValue *object = pytalloc_get_ptr(obj);
	PyObject *py_string1;
	py_string1 = pytalloc_reference_ex(&winreg_String_Type, pytalloc_get_mem_ctx(obj), &object->in.string1);
	return py_string1;
}

static int py_winreg_NotifyChangeKeyValue_in_set_string1(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winreg_NotifyChangeKeyValue *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.string1");
		return -1;
	}
	PY_CHECK_TYPE(&winreg_String_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->in.string1 = *(struct winreg_String *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_winreg_NotifyChangeKeyValue_in_get_string2(PyObject *obj, void *closure)
{
	struct winreg_NotifyChangeKeyValue *object = pytalloc_get_ptr(obj);
	PyObject *py_string2;
	py_string2 = pytalloc_reference_ex(&winreg_String_Type, pytalloc_get_mem_ctx(obj), &object->in.string2);
	return py_string2;
}

static int py_winreg_NotifyChangeKeyValue_in_set_string2(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winreg_NotifyChangeKeyValue *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.string2");
		return -1;
	}
	PY_CHECK_TYPE(&winreg_String_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->in.string2 = *(struct winreg_String *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_winreg_NotifyChangeKeyValue_in_get_unknown2(PyObject *obj, void *closure)
{
	struct winreg_NotifyChangeKeyValue *object = pytalloc_get_ptr(obj);
	PyObject *py_unknown2;
	py_unknown2 = PyLong_FromUnsignedLongLong((uint32_t)(object->in.unknown2));
	return py_unknown2;
}

static int py_winreg_NotifyChangeKeyValue_in_set_unknown2(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winreg_NotifyChangeKeyValue *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.unknown2");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->in.unknown2));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->in.unknown2 = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_winreg_NotifyChangeKeyValue_get_result(PyObject *obj, void *closure)
{
	struct winreg_NotifyChangeKeyValue *object = pytalloc_get_ptr(obj);
	PyObject *py_result;
	py_result = PyErr_FromWERROR(object->out.result);
	return py_result;
}

static int py_winreg_NotifyChangeKeyValue_set_result(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winreg_NotifyChangeKeyValue *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->out.result");
		return -1;
	}
	object->out.result = W_ERROR(PyLong_AsLong(value));
	return 0;
}

static PyGetSetDef py_winreg_NotifyChangeKeyValue_getsetters[] = {
	{
		.name = discard_const_p(char, "in_handle"),
		.get = py_winreg_NotifyChangeKeyValue_in_get_handle,
		.set = py_winreg_NotifyChangeKeyValue_in_set_handle,
		.doc = discard_const_p(char, "PIDL-generated element of base type policy_handle")
	},
	{
		.name = discard_const_p(char, "in_watch_subtree"),
		.get = py_winreg_NotifyChangeKeyValue_in_get_watch_subtree,
		.set = py_winreg_NotifyChangeKeyValue_in_set_watch_subtree,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "in_notify_filter"),
		.get = py_winreg_NotifyChangeKeyValue_in_get_notify_filter,
		.set = py_winreg_NotifyChangeKeyValue_in_set_notify_filter,
		.doc = discard_const_p(char, "PIDL-generated element of base type winreg_NotifyChangeType")
	},
	{
		.name = discard_const_p(char, "in_unknown"),
		.get = py_winreg_NotifyChangeKeyValue_in_get_unknown,
		.set = py_winreg_NotifyChangeKeyValue_in_set_unknown,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "in_string1"),
		.get = py_winreg_NotifyChangeKeyValue_in_get_string1,
		.set = py_winreg_NotifyChangeKeyValue_in_set_string1,
		.doc = discard_const_p(char, "PIDL-generated element of base type winreg_String")
	},
	{
		.name = discard_const_p(char, "in_string2"),
		.get = py_winreg_NotifyChangeKeyValue_in_get_string2,
		.set = py_winreg_NotifyChangeKeyValue_in_set_string2,
		.doc = discard_const_p(char, "PIDL-generated element of base type winreg_String")
	},
	{
		.name = discard_const_p(char, "in_unknown2"),
		.get = py_winreg_NotifyChangeKeyValue_in_get_unknown2,
		.set = py_winreg_NotifyChangeKeyValue_in_set_unknown2,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "result"),
		.get = py_winreg_NotifyChangeKeyValue_get_result,
		.set = py_winreg_NotifyChangeKeyValue_set_result,
		.doc = discard_const_p(char, "PIDL-generated element of type WERROR")
	},
	{ .name = NULL }
};

static PyObject *py_winreg_NotifyChangeKeyValue_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyObject *self = pytalloc_new(struct winreg_NotifyChangeKeyValue, type);
	struct winreg_NotifyChangeKeyValue *_self = (struct winreg_NotifyChangeKeyValue *)pytalloc_get_ptr(self);
	TALLOC_CTX *mem_ctx = pytalloc_get_mem_ctx(self);
	_self->in.handle = talloc_zero(mem_ctx, struct policy_handle);
	return self;
}

static PyObject *py_winreg_NotifyChangeKeyValue_ndr_opnum(PyTypeObject *type, PyObject *Py_UNUSED(ignored))
{


	return PyLong_FromLong(14);
}

static PyObject *py_winreg_NotifyChangeKeyValue_ndr_pack(PyObject *py_obj, ndr_flags_type ndr_inout_flags, libndr_flags ndr_push_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct winreg_NotifyChangeKeyValue *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	struct ndr_push *push = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;

	if (ndr_table_winreg.num_calls < 15) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_winreg_NotifyChangeKeyValue_ndr_pack");
		return NULL;
	}
	call = &ndr_table_winreg.calls[14];

	push = ndr_push_init_ctx(pytalloc_get_mem_ctx(py_obj));
	if (push == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	push->flags |= ndr_push_flags;

	err = call->ndr_push(push, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(push);
		PyErr_SetNdrError(err);
		return NULL;
	}
	blob = ndr_push_blob(push);
	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(push);
	return ret;
}

static PyObject *py_winreg_NotifyChangeKeyValue_ndr_pack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_in__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_winreg_NotifyChangeKeyValue_ndr_pack(py_obj, NDR_IN, ndr_push_flags);
}

static PyObject *py_winreg_NotifyChangeKeyValue_ndr_pack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_out__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_winreg_NotifyChangeKeyValue_ndr_pack(py_obj, NDR_OUT, ndr_push_flags);
}

static PyObject *py_winreg_NotifyChangeKeyValue_ndr_unpack(PyObject *py_obj, const DATA_BLOB *blob, ndr_flags_type ndr_inout_flags, libndr_flags ndr_pull_flags, bool allow_remaining)
{
	const struct ndr_interface_call *call = NULL;
	struct winreg_NotifyChangeKeyValue *object = pytalloc_get_ptr(py_obj);
	struct ndr_pull *pull = NULL;
	enum ndr_err_code err;

	if (ndr_table_winreg.num_calls < 15) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_winreg_NotifyChangeKeyValue_ndr_unpack");
		return NULL;
	}
	call = &ndr_table_winreg.calls[14];

	pull = ndr_pull_init_blob(blob, object);
	if (pull == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	pull->flags |= ndr_pull_flags;

	err = call->ndr_pull(pull, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(pull);
		PyErr_SetNdrError(err);
		return NULL;
	}
	if (!allow_remaining) {
		uint32_t highest_ofs;

		if (pull->offset > pull->relative_highest_offset) {
			highest_ofs = pull->offset;
		} else {
			highest_ofs = pull->relative_highest_offset;
		}
		if (highest_ofs < pull->data_size) {
			err = ndr_pull_error(pull, NDR_ERR_UNREAD_BYTES,
				"not all bytes consumed ofs[%u] size[%u]",
				highest_ofs, pull->data_size);
			TALLOC_FREE(pull);
			PyErr_SetNdrError(err);
			return NULL;
		}
	}

	TALLOC_FREE(pull);
	Py_RETURN_NONE;
}

static PyObject *py_winreg_NotifyChangeKeyValue_ndr_unpack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_in__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_winreg_NotifyChangeKeyValue_ndr_unpack(py_obj, &blob, NDR_IN, ndr_pull_flags, allow_remaining);
}

static PyObject *py_winreg_NotifyChangeKeyValue_ndr_unpack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_out__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_winreg_NotifyChangeKeyValue_ndr_unpack(py_obj, &blob, NDR_OUT, ndr_pull_flags, allow_remaining);
}

static PyObject *py_winreg_NotifyChangeKeyValue_ndr_print(PyObject *py_obj, PyObject *args, PyObject *kwargs, const char *name, ndr_flags_type ndr_inout_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct winreg_NotifyChangeKeyValue *object = pytalloc_get_ptr(py_obj);
	const char * const kwnames[] = { "print_secrets", NULL };
	PyObject *py_print_secrets = NULL;
	PyObject *ret;
	char *retstr;
	bool ok;

	ok = PyArg_ParseTupleAndKeywords(args, kwargs, "|O:__ndr_print__",
		discard_const_p(char *, kwnames),
		&py_print_secrets);
	if (!ok) {
		return NULL;
	}

	if (ndr_table_winreg.num_calls < 15) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_winreg_NotifyChangeKeyValue_ndr_print");
		return NULL;
	}
	call = &ndr_table_winreg.calls[14];

	if (py_print_secrets != NULL && PyObject_IsTrue(py_print_secrets)) {
		retstr = ndr_print_function_secret_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	} else {
		retstr = ndr_print_function_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	}
	ret = PyUnicode_FromString(retstr);
	TALLOC_FREE(retstr);

	return ret;
}

static PyObject *py_winreg_NotifyChangeKeyValue_ndr_print_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	return py_winreg_NotifyChangeKeyValue_ndr_print(py_obj, args, kwargs, "winreg_NotifyChangeKeyValue_in", NDR_IN);
}

static PyObject *py_winreg_NotifyChangeKeyValue_ndr_print_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	return py_winreg_NotifyChangeKeyValue_ndr_print(py_obj, args, kwargs, "winreg_NotifyChangeKeyValue_out", NDR_OUT);
}

static PyMethodDef py_winreg_NotifyChangeKeyValue_methods[] = {
	{ "opnum", (PyCFunction)py_winreg_NotifyChangeKeyValue_ndr_opnum, METH_NOARGS|METH_CLASS,
		"winreg.NotifyChangeKeyValue.opnum() -> 14 (0x0e) " },
	{ "__ndr_pack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winreg_NotifyChangeKeyValue_ndr_pack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_in(object, bigendian=False, ndr64=False) -> blob\nNDR pack input" },
	{ "__ndr_pack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winreg_NotifyChangeKeyValue_ndr_pack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_out(object, bigendian=False, ndr64=False) -> blob\nNDR pack output" },
	{ "__ndr_unpack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winreg_NotifyChangeKeyValue_ndr_unpack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_in(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack input" },
	{ "__ndr_unpack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winreg_NotifyChangeKeyValue_ndr_unpack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_out(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack output" },
	{ "__ndr_print_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winreg_NotifyChangeKeyValue_ndr_print_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_print_in(object, print_secrets=False) -> String\nNDR print input" },
	{ "__ndr_print_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winreg_NotifyChangeKeyValue_ndr_print_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_print_out(object, print_secrets=False) -> String\nNDR print output" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject winreg_NotifyChangeKeyValue_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "winreg.NotifyChangeKeyValue",
	.tp_getset = py_winreg_NotifyChangeKeyValue_getsetters,
	.tp_methods = py_winreg_NotifyChangeKeyValue_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_winreg_NotifyChangeKeyValue_new,
};

static bool pack_py_winreg_NotifyChangeKeyValue_args_in(PyObject *args, PyObject *kwargs, struct winreg_NotifyChangeKeyValue *r)
{
	PyObject *py_handle;
	PyObject *py_watch_subtree;
	PyObject *py_notify_filter;
	PyObject *py_unknown;
	PyObject *py_string1;
	PyObject *py_string2;
	PyObject *py_unknown2;
	const char *kwnames[] = {
		"handle", "watch_subtree", "notify_filter", "unknown", "string1", "string2", "unknown2", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOOOOOO:winreg_NotifyChangeKeyValue", discard_const_p(char *, kwnames), &py_handle, &py_watch_subtree, &py_notify_filter, &py_unknown, &py_string1, &py_string2, &py_unknown2)) {
		return false;
	}

	if (py_handle == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.handle");
		return false;
	}
	r->in.handle = talloc_ptrtype(r, r->in.handle);
	if (r->in.handle == NULL) {
		PyErr_NoMemory();
		return false;
	}
	PY_CHECK_TYPE(policy_handle_Type, py_handle, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_handle)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.handle = (struct policy_handle *)pytalloc_get_ptr(py_handle);
	if (py_watch_subtree == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.watch_subtree");
		return false;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(r->in.watch_subtree));
		if (PyLong_Check(py_watch_subtree)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(py_watch_subtree);
			if (PyErr_Occurred() != NULL) {
				return false;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return false;
			}
			r->in.watch_subtree = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return false;
		}
	}
	if (py_notify_filter == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.notify_filter");
		return false;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(r->in.notify_filter));
		if (PyLong_Check(py_notify_filter)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(py_notify_filter);
			if (PyErr_Occurred() != NULL) {
				return false;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return false;
			}
			r->in.notify_filter = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return false;
		}
	}
	if (py_unknown == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.unknown");
		return false;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(r->in.unknown));
		if (PyLong_Check(py_unknown)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(py_unknown);
			if (PyErr_Occurred() != NULL) {
				return false;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return false;
			}
			r->in.unknown = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return false;
		}
	}
	if (py_string1 == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.string1");
		return false;
	}
	PY_CHECK_TYPE(&winreg_String_Type, py_string1, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_string1)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.string1 = *(struct winreg_String *)pytalloc_get_ptr(py_string1);
	if (py_string2 == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.string2");
		return false;
	}
	PY_CHECK_TYPE(&winreg_String_Type, py_string2, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_string2)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.string2 = *(struct winreg_String *)pytalloc_get_ptr(py_string2);
	if (py_unknown2 == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.unknown2");
		return false;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(r->in.unknown2));
		if (PyLong_Check(py_unknown2)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(py_unknown2);
			if (PyErr_Occurred() != NULL) {
				return false;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return false;
			}
			r->in.unknown2 = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return false;
		}
	}
	return true;
}

static PyObject *unpack_py_winreg_NotifyChangeKeyValue_args_out(struct winreg_NotifyChangeKeyValue *r, bool raise_result_exception)
{
	PyObject *result = NULL;
	size_t result_size = 0;

	if (raise_result_exception) {
		if (!W_ERROR_IS_OK(r->out.result)) {
			PyErr_SetWERROR(r->out.result);
			return NULL;
		}

	} else {
		/* WERROR will be part of the results */
		result_size += 1;
	}

	if (!raise_result_exception) {
		result = PyErr_FromWERROR(r->out.result);
	}

	if (result_size == 0) {
		result = Py_None;
		Py_INCREF(result);
	}

	return result;
}


static PyObject *py_winreg_OpenKey_in_get_parent_handle(PyObject *obj, void *closure)
{
	struct winreg_OpenKey *object = pytalloc_get_ptr(obj);
	PyObject *py_parent_handle;
	if (object->in.parent_handle == NULL) {
		Py_RETURN_NONE;
	}
	py_parent_handle = pytalloc_reference_ex(policy_handle_Type, object->in.parent_handle, object->in.parent_handle);
	return py_parent_handle;
}

static int py_winreg_OpenKey_in_set_parent_handle(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winreg_OpenKey *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->in.parent_handle));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.parent_handle");
		return -1;
	}
	object->in.parent_handle = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->in.parent_handle);
	if (object->in.parent_handle == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	PY_CHECK_TYPE(policy_handle_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->in.parent_handle = (struct policy_handle *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_winreg_OpenKey_in_get_keyname(PyObject *obj, void *closure)
{
	struct winreg_OpenKey *object = pytalloc_get_ptr(obj);
	PyObject *py_keyname;
	py_keyname = pytalloc_reference_ex(&winreg_String_Type, pytalloc_get_mem_ctx(obj), &object->in.keyname);
	return py_keyname;
}

static int py_winreg_OpenKey_in_set_keyname(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winreg_OpenKey *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.keyname");
		return -1;
	}
	PY_CHECK_TYPE(&winreg_String_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->in.keyname = *(struct winreg_String *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_winreg_OpenKey_in_get_options(PyObject *obj, void *closure)
{
	struct winreg_OpenKey *object = pytalloc_get_ptr(obj);
	PyObject *py_options;
	py_options = PyLong_FromUnsignedLongLong((uint32_t)(object->in.options));
	return py_options;
}

static int py_winreg_OpenKey_in_set_options(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winreg_OpenKey *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.options");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->in.options));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->in.options = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_winreg_OpenKey_in_get_access_mask(PyObject *obj, void *closure)
{
	struct winreg_OpenKey *object = pytalloc_get_ptr(obj);
	PyObject *py_access_mask;
	py_access_mask = PyLong_FromUnsignedLongLong((uint32_t)(object->in.access_mask));
	return py_access_mask;
}

static int py_winreg_OpenKey_in_set_access_mask(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winreg_OpenKey *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.access_mask");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->in.access_mask));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->in.access_mask = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_winreg_OpenKey_out_get_handle(PyObject *obj, void *closure)
{
	struct winreg_OpenKey *object = pytalloc_get_ptr(obj);
	PyObject *py_handle;
	if (object->out.handle == NULL) {
		Py_RETURN_NONE;
	}
	py_handle = pytalloc_reference_ex(policy_handle_Type, object->out.handle, object->out.handle);
	return py_handle;
}

static int py_winreg_OpenKey_out_set_handle(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winreg_OpenKey *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->out.handle));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->out.handle");
		return -1;
	}
	object->out.handle = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->out.handle);
	if (object->out.handle == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	PY_CHECK_TYPE(policy_handle_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->out.handle = (struct policy_handle *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_winreg_OpenKey_get_result(PyObject *obj, void *closure)
{
	struct winreg_OpenKey *object = pytalloc_get_ptr(obj);
	PyObject *py_result;
	py_result = PyErr_FromWERROR(object->out.result);
	return py_result;
}

static int py_winreg_OpenKey_set_result(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winreg_OpenKey *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->out.result");
		return -1;
	}
	object->out.result = W_ERROR(PyLong_AsLong(value));
	return 0;
}

static PyGetSetDef py_winreg_OpenKey_getsetters[] = {
	{
		.name = discard_const_p(char, "in_parent_handle"),
		.get = py_winreg_OpenKey_in_get_parent_handle,
		.set = py_winreg_OpenKey_in_set_parent_handle,
		.doc = discard_const_p(char, "PIDL-generated element of base type policy_handle")
	},
	{
		.name = discard_const_p(char, "in_keyname"),
		.get = py_winreg_OpenKey_in_get_keyname,
		.set = py_winreg_OpenKey_in_set_keyname,
		.doc = discard_const_p(char, "PIDL-generated element of base type winreg_String")
	},
	{
		.name = discard_const_p(char, "in_options"),
		.get = py_winreg_OpenKey_in_get_options,
		.set = py_winreg_OpenKey_in_set_options,
		.doc = discard_const_p(char, "PIDL-generated element of base type winreg_KeyOptions")
	},
	{
		.name = discard_const_p(char, "in_access_mask"),
		.get = py_winreg_OpenKey_in_get_access_mask,
		.set = py_winreg_OpenKey_in_set_access_mask,
		.doc = discard_const_p(char, "PIDL-generated element of base type winreg_AccessMask")
	},
	{
		.name = discard_const_p(char, "out_handle"),
		.get = py_winreg_OpenKey_out_get_handle,
		.set = py_winreg_OpenKey_out_set_handle,
		.doc = discard_const_p(char, "PIDL-generated element of base type policy_handle")
	},
	{
		.name = discard_const_p(char, "result"),
		.get = py_winreg_OpenKey_get_result,
		.set = py_winreg_OpenKey_set_result,
		.doc = discard_const_p(char, "PIDL-generated element of type WERROR")
	},
	{ .name = NULL }
};

static PyObject *py_winreg_OpenKey_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyObject *self = pytalloc_new(struct winreg_OpenKey, type);
	struct winreg_OpenKey *_self = (struct winreg_OpenKey *)pytalloc_get_ptr(self);
	TALLOC_CTX *mem_ctx = pytalloc_get_mem_ctx(self);
	_self->in.parent_handle = talloc_zero(mem_ctx, struct policy_handle);
	_self->out.handle = talloc_zero(mem_ctx, struct policy_handle);
	return self;
}

static PyObject *py_winreg_OpenKey_ndr_opnum(PyTypeObject *type, PyObject *Py_UNUSED(ignored))
{


	return PyLong_FromLong(15);
}

static PyObject *py_winreg_OpenKey_ndr_pack(PyObject *py_obj, ndr_flags_type ndr_inout_flags, libndr_flags ndr_push_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct winreg_OpenKey *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	struct ndr_push *push = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;

	if (ndr_table_winreg.num_calls < 16) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_winreg_OpenKey_ndr_pack");
		return NULL;
	}
	call = &ndr_table_winreg.calls[15];

	push = ndr_push_init_ctx(pytalloc_get_mem_ctx(py_obj));
	if (push == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	push->flags |= ndr_push_flags;

	err = call->ndr_push(push, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(push);
		PyErr_SetNdrError(err);
		return NULL;
	}
	blob = ndr_push_blob(push);
	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(push);
	return ret;
}

static PyObject *py_winreg_OpenKey_ndr_pack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_in__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_winreg_OpenKey_ndr_pack(py_obj, NDR_IN, ndr_push_flags);
}

static PyObject *py_winreg_OpenKey_ndr_pack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_out__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_winreg_OpenKey_ndr_pack(py_obj, NDR_OUT, ndr_push_flags);
}

static PyObject *py_winreg_OpenKey_ndr_unpack(PyObject *py_obj, const DATA_BLOB *blob, ndr_flags_type ndr_inout_flags, libndr_flags ndr_pull_flags, bool allow_remaining)
{
	const struct ndr_interface_call *call = NULL;
	struct winreg_OpenKey *object = pytalloc_get_ptr(py_obj);
	struct ndr_pull *pull = NULL;
	enum ndr_err_code err;

	if (ndr_table_winreg.num_calls < 16) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_winreg_OpenKey_ndr_unpack");
		return NULL;
	}
	call = &ndr_table_winreg.calls[15];

	pull = ndr_pull_init_blob(blob, object);
	if (pull == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	pull->flags |= ndr_pull_flags;

	err = call->ndr_pull(pull, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(pull);
		PyErr_SetNdrError(err);
		return NULL;
	}
	if (!allow_remaining) {
		uint32_t highest_ofs;

		if (pull->offset > pull->relative_highest_offset) {
			highest_ofs = pull->offset;
		} else {
			highest_ofs = pull->relative_highest_offset;
		}
		if (highest_ofs < pull->data_size) {
			err = ndr_pull_error(pull, NDR_ERR_UNREAD_BYTES,
				"not all bytes consumed ofs[%u] size[%u]",
				highest_ofs, pull->data_size);
			TALLOC_FREE(pull);
			PyErr_SetNdrError(err);
			return NULL;
		}
	}

	TALLOC_FREE(pull);
	Py_RETURN_NONE;
}

static PyObject *py_winreg_OpenKey_ndr_unpack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_in__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_winreg_OpenKey_ndr_unpack(py_obj, &blob, NDR_IN, ndr_pull_flags, allow_remaining);
}

static PyObject *py_winreg_OpenKey_ndr_unpack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_out__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_winreg_OpenKey_ndr_unpack(py_obj, &blob, NDR_OUT, ndr_pull_flags, allow_remaining);
}

static PyObject *py_winreg_OpenKey_ndr_print(PyObject *py_obj, PyObject *args, PyObject *kwargs, const char *name, ndr_flags_type ndr_inout_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct winreg_OpenKey *object = pytalloc_get_ptr(py_obj);
	const char * const kwnames[] = { "print_secrets", NULL };
	PyObject *py_print_secrets = NULL;
	PyObject *ret;
	char *retstr;
	bool ok;

	ok = PyArg_ParseTupleAndKeywords(args, kwargs, "|O:__ndr_print__",
		discard_const_p(char *, kwnames),
		&py_print_secrets);
	if (!ok) {
		return NULL;
	}

	if (ndr_table_winreg.num_calls < 16) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_winreg_OpenKey_ndr_print");
		return NULL;
	}
	call = &ndr_table_winreg.calls[15];

	if (py_print_secrets != NULL && PyObject_IsTrue(py_print_secrets)) {
		retstr = ndr_print_function_secret_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	} else {
		retstr = ndr_print_function_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	}
	ret = PyUnicode_FromString(retstr);
	TALLOC_FREE(retstr);

	return ret;
}

static PyObject *py_winreg_OpenKey_ndr_print_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	return py_winreg_OpenKey_ndr_print(py_obj, args, kwargs, "winreg_OpenKey_in", NDR_IN);
}

static PyObject *py_winreg_OpenKey_ndr_print_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	return py_winreg_OpenKey_ndr_print(py_obj, args, kwargs, "winreg_OpenKey_out", NDR_OUT);
}

static PyMethodDef py_winreg_OpenKey_methods[] = {
	{ "opnum", (PyCFunction)py_winreg_OpenKey_ndr_opnum, METH_NOARGS|METH_CLASS,
		"winreg.OpenKey.opnum() -> 15 (0x0f) " },
	{ "__ndr_pack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winreg_OpenKey_ndr_pack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_in(object, bigendian=False, ndr64=False) -> blob\nNDR pack input" },
	{ "__ndr_pack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winreg_OpenKey_ndr_pack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_out(object, bigendian=False, ndr64=False) -> blob\nNDR pack output" },
	{ "__ndr_unpack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winreg_OpenKey_ndr_unpack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_in(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack input" },
	{ "__ndr_unpack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winreg_OpenKey_ndr_unpack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_out(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack output" },
	{ "__ndr_print_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winreg_OpenKey_ndr_print_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_print_in(object, print_secrets=False) -> String\nNDR print input" },
	{ "__ndr_print_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winreg_OpenKey_ndr_print_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_print_out(object, print_secrets=False) -> String\nNDR print output" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject winreg_OpenKey_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "winreg.OpenKey",
	.tp_getset = py_winreg_OpenKey_getsetters,
	.tp_methods = py_winreg_OpenKey_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_winreg_OpenKey_new,
};

static bool pack_py_winreg_OpenKey_args_in(PyObject *args, PyObject *kwargs, struct winreg_OpenKey *r)
{
	PyObject *py_parent_handle;
	PyObject *py_keyname;
	PyObject *py_options;
	PyObject *py_access_mask;
	const char *kwnames[] = {
		"parent_handle", "keyname", "options", "access_mask", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOOO:winreg_OpenKey", discard_const_p(char *, kwnames), &py_parent_handle, &py_keyname, &py_options, &py_access_mask)) {
		return false;
	}

	if (py_parent_handle == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.parent_handle");
		return false;
	}
	r->in.parent_handle = talloc_ptrtype(r, r->in.parent_handle);
	if (r->in.parent_handle == NULL) {
		PyErr_NoMemory();
		return false;
	}
	PY_CHECK_TYPE(policy_handle_Type, py_parent_handle, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_parent_handle)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.parent_handle = (struct policy_handle *)pytalloc_get_ptr(py_parent_handle);
	if (py_keyname == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.keyname");
		return false;
	}
	PY_CHECK_TYPE(&winreg_String_Type, py_keyname, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_keyname)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.keyname = *(struct winreg_String *)pytalloc_get_ptr(py_keyname);
	if (py_options == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.options");
		return false;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(r->in.options));
		if (PyLong_Check(py_options)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(py_options);
			if (PyErr_Occurred() != NULL) {
				return false;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return false;
			}
			r->in.options = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return false;
		}
	}
	if (py_access_mask == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.access_mask");
		return false;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(r->in.access_mask));
		if (PyLong_Check(py_access_mask)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(py_access_mask);
			if (PyErr_Occurred() != NULL) {
				return false;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return false;
			}
			r->in.access_mask = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return false;
		}
	}
	return true;
}

static PyObject *unpack_py_winreg_OpenKey_args_out(struct winreg_OpenKey *r, bool raise_result_exception)
{
	PyObject *py_handle = NULL;
	PyObject *result = NULL;
	size_t result_size = 1;

	if (raise_result_exception) {
		if (!W_ERROR_IS_OK(r->out.result)) {
			PyErr_SetWERROR(r->out.result);
			return NULL;
		}

	} else {
		/* WERROR will be part of the results */
		result_size += 1;
	}

	if (result_size > 1) {
		result = PyTuple_New(result_size);
		if (result == NULL) {
			return NULL;
		}
	}

	py_handle = pytalloc_reference_ex(policy_handle_Type, r->out.handle, r->out.handle);
	if (result_size > 1) {
		PyTuple_SetItem(result, 0, py_handle);
	}
	if (result_size == 1) {
		result = py_handle;
	}

	if (!raise_result_exception) {
		PyTuple_SetItem(result, 1, PyErr_FromWERROR(r->out.result));
	}

	return result;
}


static PyObject *py_winreg_QueryInfoKey_in_get_handle(PyObject *obj, void *closure)
{
	struct winreg_QueryInfoKey *object = pytalloc_get_ptr(obj);
	PyObject *py_handle;
	if (object->in.handle == NULL) {
		Py_RETURN_NONE;
	}
	py_handle = pytalloc_reference_ex(policy_handle_Type, object->in.handle, object->in.handle);
	return py_handle;
}

static int py_winreg_QueryInfoKey_in_set_handle(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winreg_QueryInfoKey *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->in.handle));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.handle");
		return -1;
	}
	object->in.handle = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->in.handle);
	if (object->in.handle == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	PY_CHECK_TYPE(policy_handle_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->in.handle = (struct policy_handle *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_winreg_QueryInfoKey_in_get_classname(PyObject *obj, void *closure)
{
	struct winreg_QueryInfoKey *object = pytalloc_get_ptr(obj);
	PyObject *py_classname;
	if (object->in.classname == NULL) {
		Py_RETURN_NONE;
	}
	py_classname = pytalloc_reference_ex(&winreg_String_Type, object->in.classname, object->in.classname);
	return py_classname;
}

static int py_winreg_QueryInfoKey_in_set_classname(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winreg_QueryInfoKey *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->in.classname));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.classname");
		return -1;
	}
	object->in.classname = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->in.classname);
	if (object->in.classname == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	PY_CHECK_TYPE(&winreg_String_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->in.classname = (struct winreg_String *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_winreg_QueryInfoKey_out_get_classname(PyObject *obj, void *closure)
{
	struct winreg_QueryInfoKey *object = pytalloc_get_ptr(obj);
	PyObject *py_classname;
	if (object->out.classname == NULL) {
		Py_RETURN_NONE;
	}
	py_classname = pytalloc_reference_ex(&winreg_String_Type, object->out.classname, object->out.classname);
	return py_classname;
}

static int py_winreg_QueryInfoKey_out_set_classname(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winreg_QueryInfoKey *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->out.classname));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->out.classname");
		return -1;
	}
	object->out.classname = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->out.classname);
	if (object->out.classname == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	PY_CHECK_TYPE(&winreg_String_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->out.classname = (struct winreg_String *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_winreg_QueryInfoKey_out_get_num_subkeys(PyObject *obj, void *closure)
{
	struct winreg_QueryInfoKey *object = pytalloc_get_ptr(obj);
	PyObject *py_num_subkeys;
	if (object->out.num_subkeys == NULL) {
		Py_RETURN_NONE;
	}
	py_num_subkeys = PyLong_FromUnsignedLongLong((uint32_t)(*object->out.num_subkeys));
	return py_num_subkeys;
}

static int py_winreg_QueryInfoKey_out_set_num_subkeys(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winreg_QueryInfoKey *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->out.num_subkeys));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->out.num_subkeys");
		return -1;
	}
	object->out.num_subkeys = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->out.num_subkeys);
	if (object->out.num_subkeys == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(*object->out.num_subkeys));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			*object->out.num_subkeys = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_winreg_QueryInfoKey_out_get_max_subkeylen(PyObject *obj, void *closure)
{
	struct winreg_QueryInfoKey *object = pytalloc_get_ptr(obj);
	PyObject *py_max_subkeylen;
	if (object->out.max_subkeylen == NULL) {
		Py_RETURN_NONE;
	}
	py_max_subkeylen = PyLong_FromUnsignedLongLong((uint32_t)(*object->out.max_subkeylen));
	return py_max_subkeylen;
}

static int py_winreg_QueryInfoKey_out_set_max_subkeylen(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winreg_QueryInfoKey *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->out.max_subkeylen));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->out.max_subkeylen");
		return -1;
	}
	object->out.max_subkeylen = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->out.max_subkeylen);
	if (object->out.max_subkeylen == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(*object->out.max_subkeylen));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			*object->out.max_subkeylen = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_winreg_QueryInfoKey_out_get_max_classlen(PyObject *obj, void *closure)
{
	struct winreg_QueryInfoKey *object = pytalloc_get_ptr(obj);
	PyObject *py_max_classlen;
	if (object->out.max_classlen == NULL) {
		Py_RETURN_NONE;
	}
	py_max_classlen = PyLong_FromUnsignedLongLong((uint32_t)(*object->out.max_classlen));
	return py_max_classlen;
}

static int py_winreg_QueryInfoKey_out_set_max_classlen(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winreg_QueryInfoKey *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->out.max_classlen));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->out.max_classlen");
		return -1;
	}
	object->out.max_classlen = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->out.max_classlen);
	if (object->out.max_classlen == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(*object->out.max_classlen));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			*object->out.max_classlen = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_winreg_QueryInfoKey_out_get_num_values(PyObject *obj, void *closure)
{
	struct winreg_QueryInfoKey *object = pytalloc_get_ptr(obj);
	PyObject *py_num_values;
	if (object->out.num_values == NULL) {
		Py_RETURN_NONE;
	}
	py_num_values = PyLong_FromUnsignedLongLong((uint32_t)(*object->out.num_values));
	return py_num_values;
}

static int py_winreg_QueryInfoKey_out_set_num_values(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winreg_QueryInfoKey *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->out.num_values));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->out.num_values");
		return -1;
	}
	object->out.num_values = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->out.num_values);
	if (object->out.num_values == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(*object->out.num_values));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			*object->out.num_values = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_winreg_QueryInfoKey_out_get_max_valnamelen(PyObject *obj, void *closure)
{
	struct winreg_QueryInfoKey *object = pytalloc_get_ptr(obj);
	PyObject *py_max_valnamelen;
	if (object->out.max_valnamelen == NULL) {
		Py_RETURN_NONE;
	}
	py_max_valnamelen = PyLong_FromUnsignedLongLong((uint32_t)(*object->out.max_valnamelen));
	return py_max_valnamelen;
}

static int py_winreg_QueryInfoKey_out_set_max_valnamelen(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winreg_QueryInfoKey *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->out.max_valnamelen));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->out.max_valnamelen");
		return -1;
	}
	object->out.max_valnamelen = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->out.max_valnamelen);
	if (object->out.max_valnamelen == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(*object->out.max_valnamelen));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			*object->out.max_valnamelen = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_winreg_QueryInfoKey_out_get_max_valbufsize(PyObject *obj, void *closure)
{
	struct winreg_QueryInfoKey *object = pytalloc_get_ptr(obj);
	PyObject *py_max_valbufsize;
	if (object->out.max_valbufsize == NULL) {
		Py_RETURN_NONE;
	}
	py_max_valbufsize = PyLong_FromUnsignedLongLong((uint32_t)(*object->out.max_valbufsize));
	return py_max_valbufsize;
}

static int py_winreg_QueryInfoKey_out_set_max_valbufsize(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winreg_QueryInfoKey *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->out.max_valbufsize));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->out.max_valbufsize");
		return -1;
	}
	object->out.max_valbufsize = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->out.max_valbufsize);
	if (object->out.max_valbufsize == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(*object->out.max_valbufsize));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			*object->out.max_valbufsize = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_winreg_QueryInfoKey_out_get_secdescsize(PyObject *obj, void *closure)
{
	struct winreg_QueryInfoKey *object = pytalloc_get_ptr(obj);
	PyObject *py_secdescsize;
	if (object->out.secdescsize == NULL) {
		Py_RETURN_NONE;
	}
	py_secdescsize = PyLong_FromUnsignedLongLong((uint32_t)(*object->out.secdescsize));
	return py_secdescsize;
}

static int py_winreg_QueryInfoKey_out_set_secdescsize(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winreg_QueryInfoKey *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->out.secdescsize));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->out.secdescsize");
		return -1;
	}
	object->out.secdescsize = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->out.secdescsize);
	if (object->out.secdescsize == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(*object->out.secdescsize));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			*object->out.secdescsize = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_winreg_QueryInfoKey_out_get_last_changed_time(PyObject *obj, void *closure)
{
	struct winreg_QueryInfoKey *object = pytalloc_get_ptr(obj);
	PyObject *py_last_changed_time;
	if (object->out.last_changed_time == NULL) {
		Py_RETURN_NONE;
	}
	py_last_changed_time = PyLong_FromUnsignedLongLong(*object->out.last_changed_time);
	return py_last_changed_time;
}

static int py_winreg_QueryInfoKey_out_set_last_changed_time(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winreg_QueryInfoKey *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->out.last_changed_time));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->out.last_changed_time");
		return -1;
	}
	object->out.last_changed_time = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->out.last_changed_time);
	if (object->out.last_changed_time == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(*object->out.last_changed_time));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			*object->out.last_changed_time = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_winreg_QueryInfoKey_get_result(PyObject *obj, void *closure)
{
	struct winreg_QueryInfoKey *object = pytalloc_get_ptr(obj);
	PyObject *py_result;
	py_result = PyErr_FromWERROR(object->out.result);
	return py_result;
}

static int py_winreg_QueryInfoKey_set_result(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winreg_QueryInfoKey *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->out.result");
		return -1;
	}
	object->out.result = W_ERROR(PyLong_AsLong(value));
	return 0;
}

static PyGetSetDef py_winreg_QueryInfoKey_getsetters[] = {
	{
		.name = discard_const_p(char, "in_handle"),
		.get = py_winreg_QueryInfoKey_in_get_handle,
		.set = py_winreg_QueryInfoKey_in_set_handle,
		.doc = discard_const_p(char, "PIDL-generated element of base type policy_handle")
	},
	{
		.name = discard_const_p(char, "in_classname"),
		.get = py_winreg_QueryInfoKey_in_get_classname,
		.set = py_winreg_QueryInfoKey_in_set_classname,
		.doc = discard_const_p(char, "PIDL-generated element of base type winreg_String")
	},
	{
		.name = discard_const_p(char, "out_classname"),
		.get = py_winreg_QueryInfoKey_out_get_classname,
		.set = py_winreg_QueryInfoKey_out_set_classname,
		.doc = discard_const_p(char, "PIDL-generated element of base type winreg_String")
	},
	{
		.name = discard_const_p(char, "out_num_subkeys"),
		.get = py_winreg_QueryInfoKey_out_get_num_subkeys,
		.set = py_winreg_QueryInfoKey_out_set_num_subkeys,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "out_max_subkeylen"),
		.get = py_winreg_QueryInfoKey_out_get_max_subkeylen,
		.set = py_winreg_QueryInfoKey_out_set_max_subkeylen,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "out_max_classlen"),
		.get = py_winreg_QueryInfoKey_out_get_max_classlen,
		.set = py_winreg_QueryInfoKey_out_set_max_classlen,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "out_num_values"),
		.get = py_winreg_QueryInfoKey_out_get_num_values,
		.set = py_winreg_QueryInfoKey_out_set_num_values,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "out_max_valnamelen"),
		.get = py_winreg_QueryInfoKey_out_get_max_valnamelen,
		.set = py_winreg_QueryInfoKey_out_set_max_valnamelen,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "out_max_valbufsize"),
		.get = py_winreg_QueryInfoKey_out_get_max_valbufsize,
		.set = py_winreg_QueryInfoKey_out_set_max_valbufsize,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "out_secdescsize"),
		.get = py_winreg_QueryInfoKey_out_get_secdescsize,
		.set = py_winreg_QueryInfoKey_out_set_secdescsize,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "out_last_changed_time"),
		.get = py_winreg_QueryInfoKey_out_get_last_changed_time,
		.set = py_winreg_QueryInfoKey_out_set_last_changed_time,
		.doc = discard_const_p(char, "PIDL-generated element of base type NTTIME")
	},
	{
		.name = discard_const_p(char, "result"),
		.get = py_winreg_QueryInfoKey_get_result,
		.set = py_winreg_QueryInfoKey_set_result,
		.doc = discard_const_p(char, "PIDL-generated element of type WERROR")
	},
	{ .name = NULL }
};

static PyObject *py_winreg_QueryInfoKey_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyObject *self = pytalloc_new(struct winreg_QueryInfoKey, type);
	struct winreg_QueryInfoKey *_self = (struct winreg_QueryInfoKey *)pytalloc_get_ptr(self);
	TALLOC_CTX *mem_ctx = pytalloc_get_mem_ctx(self);
	_self->in.handle = talloc_zero(mem_ctx, struct policy_handle);
	_self->in.classname = talloc_zero(mem_ctx, struct winreg_String);
	_self->out.classname = talloc_zero(mem_ctx, struct winreg_String);
	_self->out.num_subkeys = talloc_zero(mem_ctx, uint32_t);
	_self->out.max_subkeylen = talloc_zero(mem_ctx, uint32_t);
	_self->out.max_classlen = talloc_zero(mem_ctx, uint32_t);
	_self->out.num_values = talloc_zero(mem_ctx, uint32_t);
	_self->out.max_valnamelen = talloc_zero(mem_ctx, uint32_t);
	_self->out.max_valbufsize = talloc_zero(mem_ctx, uint32_t);
	_self->out.secdescsize = talloc_zero(mem_ctx, uint32_t);
	_self->out.last_changed_time = talloc_zero(mem_ctx, NTTIME);
	return self;
}

static PyObject *py_winreg_QueryInfoKey_ndr_opnum(PyTypeObject *type, PyObject *Py_UNUSED(ignored))
{


	return PyLong_FromLong(16);
}

static PyObject *py_winreg_QueryInfoKey_ndr_pack(PyObject *py_obj, ndr_flags_type ndr_inout_flags, libndr_flags ndr_push_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct winreg_QueryInfoKey *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	struct ndr_push *push = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;

	if (ndr_table_winreg.num_calls < 17) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_winreg_QueryInfoKey_ndr_pack");
		return NULL;
	}
	call = &ndr_table_winreg.calls[16];

	push = ndr_push_init_ctx(pytalloc_get_mem_ctx(py_obj));
	if (push == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	push->flags |= ndr_push_flags;

	err = call->ndr_push(push, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(push);
		PyErr_SetNdrError(err);
		return NULL;
	}
	blob = ndr_push_blob(push);
	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(push);
	return ret;
}

static PyObject *py_winreg_QueryInfoKey_ndr_pack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_in__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_winreg_QueryInfoKey_ndr_pack(py_obj, NDR_IN, ndr_push_flags);
}

static PyObject *py_winreg_QueryInfoKey_ndr_pack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_out__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_winreg_QueryInfoKey_ndr_pack(py_obj, NDR_OUT, ndr_push_flags);
}

static PyObject *py_winreg_QueryInfoKey_ndr_unpack(PyObject *py_obj, const DATA_BLOB *blob, ndr_flags_type ndr_inout_flags, libndr_flags ndr_pull_flags, bool allow_remaining)
{
	const struct ndr_interface_call *call = NULL;
	struct winreg_QueryInfoKey *object = pytalloc_get_ptr(py_obj);
	struct ndr_pull *pull = NULL;
	enum ndr_err_code err;

	if (ndr_table_winreg.num_calls < 17) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_winreg_QueryInfoKey_ndr_unpack");
		return NULL;
	}
	call = &ndr_table_winreg.calls[16];

	pull = ndr_pull_init_blob(blob, object);
	if (pull == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	pull->flags |= ndr_pull_flags;

	err = call->ndr_pull(pull, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(pull);
		PyErr_SetNdrError(err);
		return NULL;
	}
	if (!allow_remaining) {
		uint32_t highest_ofs;

		if (pull->offset > pull->relative_highest_offset) {
			highest_ofs = pull->offset;
		} else {
			highest_ofs = pull->relative_highest_offset;
		}
		if (highest_ofs < pull->data_size) {
			err = ndr_pull_error(pull, NDR_ERR_UNREAD_BYTES,
				"not all bytes consumed ofs[%u] size[%u]",
				highest_ofs, pull->data_size);
			TALLOC_FREE(pull);
			PyErr_SetNdrError(err);
			return NULL;
		}
	}

	TALLOC_FREE(pull);
	Py_RETURN_NONE;
}

static PyObject *py_winreg_QueryInfoKey_ndr_unpack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_in__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_winreg_QueryInfoKey_ndr_unpack(py_obj, &blob, NDR_IN, ndr_pull_flags, allow_remaining);
}

static PyObject *py_winreg_QueryInfoKey_ndr_unpack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_out__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_winreg_QueryInfoKey_ndr_unpack(py_obj, &blob, NDR_OUT, ndr_pull_flags, allow_remaining);
}

static PyObject *py_winreg_QueryInfoKey_ndr_print(PyObject *py_obj, PyObject *args, PyObject *kwargs, const char *name, ndr_flags_type ndr_inout_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct winreg_QueryInfoKey *object = pytalloc_get_ptr(py_obj);
	const char * const kwnames[] = { "print_secrets", NULL };
	PyObject *py_print_secrets = NULL;
	PyObject *ret;
	char *retstr;
	bool ok;

	ok = PyArg_ParseTupleAndKeywords(args, kwargs, "|O:__ndr_print__",
		discard_const_p(char *, kwnames),
		&py_print_secrets);
	if (!ok) {
		return NULL;
	}

	if (ndr_table_winreg.num_calls < 17) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_winreg_QueryInfoKey_ndr_print");
		return NULL;
	}
	call = &ndr_table_winreg.calls[16];

	if (py_print_secrets != NULL && PyObject_IsTrue(py_print_secrets)) {
		retstr = ndr_print_function_secret_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	} else {
		retstr = ndr_print_function_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	}
	ret = PyUnicode_FromString(retstr);
	TALLOC_FREE(retstr);

	return ret;
}

static PyObject *py_winreg_QueryInfoKey_ndr_print_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	return py_winreg_QueryInfoKey_ndr_print(py_obj, args, kwargs, "winreg_QueryInfoKey_in", NDR_IN);
}

static PyObject *py_winreg_QueryInfoKey_ndr_print_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	return py_winreg_QueryInfoKey_ndr_print(py_obj, args, kwargs, "winreg_QueryInfoKey_out", NDR_OUT);
}

static PyMethodDef py_winreg_QueryInfoKey_methods[] = {
	{ "opnum", (PyCFunction)py_winreg_QueryInfoKey_ndr_opnum, METH_NOARGS|METH_CLASS,
		"winreg.QueryInfoKey.opnum() -> 16 (0x10) " },
	{ "__ndr_pack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winreg_QueryInfoKey_ndr_pack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_in(object, bigendian=False, ndr64=False) -> blob\nNDR pack input" },
	{ "__ndr_pack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winreg_QueryInfoKey_ndr_pack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_out(object, bigendian=False, ndr64=False) -> blob\nNDR pack output" },
	{ "__ndr_unpack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winreg_QueryInfoKey_ndr_unpack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_in(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack input" },
	{ "__ndr_unpack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winreg_QueryInfoKey_ndr_unpack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_out(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack output" },
	{ "__ndr_print_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winreg_QueryInfoKey_ndr_print_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_print_in(object, print_secrets=False) -> String\nNDR print input" },
	{ "__ndr_print_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winreg_QueryInfoKey_ndr_print_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_print_out(object, print_secrets=False) -> String\nNDR print output" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject winreg_QueryInfoKey_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "winreg.QueryInfoKey",
	.tp_getset = py_winreg_QueryInfoKey_getsetters,
	.tp_methods = py_winreg_QueryInfoKey_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_winreg_QueryInfoKey_new,
};

static bool pack_py_winreg_QueryInfoKey_args_in(PyObject *args, PyObject *kwargs, struct winreg_QueryInfoKey *r)
{
	PyObject *py_handle;
	PyObject *py_classname;
	const char *kwnames[] = {
		"handle", "classname", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OO:winreg_QueryInfoKey", discard_const_p(char *, kwnames), &py_handle, &py_classname)) {
		return false;
	}

	if (py_handle == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.handle");
		return false;
	}
	r->in.handle = talloc_ptrtype(r, r->in.handle);
	if (r->in.handle == NULL) {
		PyErr_NoMemory();
		return false;
	}
	PY_CHECK_TYPE(policy_handle_Type, py_handle, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_handle)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.handle = (struct policy_handle *)pytalloc_get_ptr(py_handle);
	if (py_classname == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.classname");
		return false;
	}
	r->in.classname = talloc_ptrtype(r, r->in.classname);
	if (r->in.classname == NULL) {
		PyErr_NoMemory();
		return false;
	}
	PY_CHECK_TYPE(&winreg_String_Type, py_classname, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_classname)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.classname = (struct winreg_String *)pytalloc_get_ptr(py_classname);
	return true;
}

static PyObject *unpack_py_winreg_QueryInfoKey_args_out(struct winreg_QueryInfoKey *r, bool raise_result_exception)
{
	PyObject *py_classname = NULL;
	PyObject *py_num_subkeys = NULL;
	PyObject *py_max_subkeylen = NULL;
	PyObject *py_max_classlen = NULL;
	PyObject *py_num_values = NULL;
	PyObject *py_max_valnamelen = NULL;
	PyObject *py_max_valbufsize = NULL;
	PyObject *py_secdescsize = NULL;
	PyObject *py_last_changed_time = NULL;
	PyObject *result = NULL;
	size_t result_size = 9;

	if (raise_result_exception) {
		if (!W_ERROR_IS_OK(r->out.result)) {
			PyErr_SetWERROR(r->out.result);
			return NULL;
		}

	} else {
		/* WERROR will be part of the results */
		result_size += 1;
	}

	if (result_size > 1) {
		result = PyTuple_New(result_size);
		if (result == NULL) {
			return NULL;
		}
	}

	py_classname = pytalloc_reference_ex(&winreg_String_Type, r->out.classname, r->out.classname);
	PyTuple_SetItem(result, 0, py_classname);

	py_num_subkeys = PyLong_FromUnsignedLongLong((uint32_t)(*r->out.num_subkeys));
	PyTuple_SetItem(result, 1, py_num_subkeys);

	py_max_subkeylen = PyLong_FromUnsignedLongLong((uint32_t)(*r->out.max_subkeylen));
	PyTuple_SetItem(result, 2, py_max_subkeylen);

	py_max_classlen = PyLong_FromUnsignedLongLong((uint32_t)(*r->out.max_classlen));
	PyTuple_SetItem(result, 3, py_max_classlen);

	py_num_values = PyLong_FromUnsignedLongLong((uint32_t)(*r->out.num_values));
	PyTuple_SetItem(result, 4, py_num_values);

	py_max_valnamelen = PyLong_FromUnsignedLongLong((uint32_t)(*r->out.max_valnamelen));
	PyTuple_SetItem(result, 5, py_max_valnamelen);

	py_max_valbufsize = PyLong_FromUnsignedLongLong((uint32_t)(*r->out.max_valbufsize));
	PyTuple_SetItem(result, 6, py_max_valbufsize);

	py_secdescsize = PyLong_FromUnsignedLongLong((uint32_t)(*r->out.secdescsize));
	PyTuple_SetItem(result, 7, py_secdescsize);

	py_last_changed_time = PyLong_FromUnsignedLongLong(*r->out.last_changed_time);
	PyTuple_SetItem(result, 8, py_last_changed_time);

	if (!raise_result_exception) {
		PyTuple_SetItem(result, 9, PyErr_FromWERROR(r->out.result));
	}

	return result;
}


static PyObject *py_winreg_QueryValue_in_get_handle(PyObject *obj, void *closure)
{
	struct winreg_QueryValue *object = pytalloc_get_ptr(obj);
	PyObject *py_handle;
	if (object->in.handle == NULL) {
		Py_RETURN_NONE;
	}
	py_handle = pytalloc_reference_ex(policy_handle_Type, object->in.handle, object->in.handle);
	return py_handle;
}

static int py_winreg_QueryValue_in_set_handle(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winreg_QueryValue *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->in.handle));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.handle");
		return -1;
	}
	object->in.handle = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->in.handle);
	if (object->in.handle == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	PY_CHECK_TYPE(policy_handle_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->in.handle = (struct policy_handle *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_winreg_QueryValue_in_get_value_name(PyObject *obj, void *closure)
{
	struct winreg_QueryValue *object = pytalloc_get_ptr(obj);
	PyObject *py_value_name;
	if (object->in.value_name == NULL) {
		Py_RETURN_NONE;
	}
	py_value_name = pytalloc_reference_ex(&winreg_String_Type, object->in.value_name, object->in.value_name);
	return py_value_name;
}

static int py_winreg_QueryValue_in_set_value_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winreg_QueryValue *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->in.value_name));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.value_name");
		return -1;
	}
	object->in.value_name = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->in.value_name);
	if (object->in.value_name == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	PY_CHECK_TYPE(&winreg_String_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->in.value_name = (struct winreg_String *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_winreg_QueryValue_in_get_type(PyObject *obj, void *closure)
{
	struct winreg_QueryValue *object = pytalloc_get_ptr(obj);
	PyObject *py_type;
	if (object->in.type == NULL) {
		Py_RETURN_NONE;
	}
	if (object->in.type == NULL) {
		py_type = Py_None;
		Py_INCREF(py_type);
	} else {
		py_type = PyLong_FromUnsignedLongLong((uint32_t)(*object->in.type));
	}
	return py_type;
}

static int py_winreg_QueryValue_in_set_type(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winreg_QueryValue *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->in.type));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.type");
		return -1;
	}
	if (value == Py_None) {
		object->in.type = NULL;
	} else {
		object->in.type = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->in.type);
		if (object->in.type == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		{
			const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(*object->in.type));
			if (PyLong_Check(value)) {
				unsigned long long test_var;
				test_var = PyLong_AsUnsignedLongLong(value);
				if (PyErr_Occurred() != NULL) {
					return -1;
				}
				if (test_var > uint_max) {
					PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
					  PyLong_Type.tp_name, uint_max, test_var);
					return -1;
				}
				*object->in.type = test_var;
			} else {
				PyErr_Format(PyExc_TypeError, "Expected type %s",
				  PyLong_Type.tp_name);
				return -1;
			}
		}
	}
	return 0;
}

static PyObject *py_winreg_QueryValue_out_get_type(PyObject *obj, void *closure)
{
	struct winreg_QueryValue *object = pytalloc_get_ptr(obj);
	PyObject *py_type;
	if (object->out.type == NULL) {
		Py_RETURN_NONE;
	}
	if (object->out.type == NULL) {
		py_type = Py_None;
		Py_INCREF(py_type);
	} else {
		py_type = PyLong_FromUnsignedLongLong((uint32_t)(*object->out.type));
	}
	return py_type;
}

static int py_winreg_QueryValue_out_set_type(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winreg_QueryValue *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->out.type));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->out.type");
		return -1;
	}
	if (value == Py_None) {
		object->out.type = NULL;
	} else {
		object->out.type = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->out.type);
		if (object->out.type == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		{
			const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(*object->out.type));
			if (PyLong_Check(value)) {
				unsigned long long test_var;
				test_var = PyLong_AsUnsignedLongLong(value);
				if (PyErr_Occurred() != NULL) {
					return -1;
				}
				if (test_var > uint_max) {
					PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
					  PyLong_Type.tp_name, uint_max, test_var);
					return -1;
				}
				*object->out.type = test_var;
			} else {
				PyErr_Format(PyExc_TypeError, "Expected type %s",
				  PyLong_Type.tp_name);
				return -1;
			}
		}
	}
	return 0;
}

static PyObject *py_winreg_QueryValue_in_get_data(PyObject *obj, void *closure)
{
	struct winreg_QueryValue *object = pytalloc_get_ptr(obj);
	PyObject *py_data;
	if (object->in.data == NULL) {
		Py_RETURN_NONE;
	}
	if (object->in.data == NULL) {
		py_data = Py_None;
		Py_INCREF(py_data);
	} else {
		py_data = PyList_New(object->in.data_length?*object->in.data_length:0);
		if (py_data == NULL) {
			return NULL;
		}
		{
			int data_cntr_1;
			for (data_cntr_1 = 0; data_cntr_1 < (object->in.data_length?*object->in.data_length:0); data_cntr_1++) {
				PyObject *py_data_1;
				py_data_1 = PyLong_FromLong((uint16_t)((object->in.data)[data_cntr_1]));
				PyList_SetItem(py_data, data_cntr_1, py_data_1);
			}
		}
	}
	return py_data;
}

static int py_winreg_QueryValue_in_set_data(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winreg_QueryValue *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->in.data));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.data");
		return -1;
	}
	if (value == Py_None) {
		object->in.data = NULL;
	} else {
		object->in.data = NULL;
		PY_CHECK_TYPE(&PyList_Type, value, return -1;);
		{
			int data_cntr_1;
			object->in.data = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->in.data, PyList_GET_SIZE(value));
			if (!object->in.data) { return -1; }
			talloc_set_name_const(object->in.data, "ARRAY: object->in.data");
			for (data_cntr_1 = 0; data_cntr_1 < PyList_GET_SIZE(value); data_cntr_1++) {
				if (PyList_GET_ITEM(value, data_cntr_1) == NULL) {
					PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: (object->in.data)[data_cntr_1]");
					return -1;
				}
				{
					const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof((object->in.data)[data_cntr_1]));
					if (PyLong_Check(PyList_GET_ITEM(value, data_cntr_1))) {
						unsigned long long test_var;
						test_var = PyLong_AsUnsignedLongLong(PyList_GET_ITEM(value, data_cntr_1));
						if (PyErr_Occurred() != NULL) {
							return -1;
						}
						if (test_var > uint_max) {
							PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
							  PyLong_Type.tp_name, uint_max, test_var);
							return -1;
						}
						(object->in.data)[data_cntr_1] = test_var;
					} else {
						PyErr_Format(PyExc_TypeError, "Expected type %s",
						  PyLong_Type.tp_name);
						return -1;
					}
				}
			}
		}
	}
	return 0;
}

static PyObject *py_winreg_QueryValue_out_get_data(PyObject *obj, void *closure)
{
	struct winreg_QueryValue *object = pytalloc_get_ptr(obj);
	PyObject *py_data;
	if (object->out.data == NULL) {
		Py_RETURN_NONE;
	}
	if (object->out.data == NULL) {
		py_data = Py_None;
		Py_INCREF(py_data);
	} else {
		py_data = PyList_New(object->out.data_length?*object->out.data_length:0);
		if (py_data == NULL) {
			return NULL;
		}
		{
			int data_cntr_1;
			for (data_cntr_1 = 0; data_cntr_1 < (object->out.data_length?*object->out.data_length:0); data_cntr_1++) {
				PyObject *py_data_1;
				py_data_1 = PyLong_FromLong((uint16_t)((object->out.data)[data_cntr_1]));
				PyList_SetItem(py_data, data_cntr_1, py_data_1);
			}
		}
	}
	return py_data;
}

static int py_winreg_QueryValue_out_set_data(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winreg_QueryValue *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->out.data));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->out.data");
		return -1;
	}
	if (value == Py_None) {
		object->out.data = NULL;
	} else {
		object->out.data = NULL;
		PY_CHECK_TYPE(&PyList_Type, value, return -1;);
		{
			int data_cntr_1;
			object->out.data = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->out.data, PyList_GET_SIZE(value));
			if (!object->out.data) { return -1; }
			talloc_set_name_const(object->out.data, "ARRAY: object->out.data");
			for (data_cntr_1 = 0; data_cntr_1 < PyList_GET_SIZE(value); data_cntr_1++) {
				if (PyList_GET_ITEM(value, data_cntr_1) == NULL) {
					PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: (object->out.data)[data_cntr_1]");
					return -1;
				}
				{
					const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof((object->out.data)[data_cntr_1]));
					if (PyLong_Check(PyList_GET_ITEM(value, data_cntr_1))) {
						unsigned long long test_var;
						test_var = PyLong_AsUnsignedLongLong(PyList_GET_ITEM(value, data_cntr_1));
						if (PyErr_Occurred() != NULL) {
							return -1;
						}
						if (test_var > uint_max) {
							PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
							  PyLong_Type.tp_name, uint_max, test_var);
							return -1;
						}
						(object->out.data)[data_cntr_1] = test_var;
					} else {
						PyErr_Format(PyExc_TypeError, "Expected type %s",
						  PyLong_Type.tp_name);
						return -1;
					}
				}
			}
		}
	}
	return 0;
}

static PyObject *py_winreg_QueryValue_in_get_data_size(PyObject *obj, void *closure)
{
	struct winreg_QueryValue *object = pytalloc_get_ptr(obj);
	PyObject *py_data_size;
	if (object->in.data_size == NULL) {
		Py_RETURN_NONE;
	}
	if (object->in.data_size == NULL) {
		py_data_size = Py_None;
		Py_INCREF(py_data_size);
	} else {
		py_data_size = PyLong_FromUnsignedLongLong((uint32_t)(*object->in.data_size));
	}
	return py_data_size;
}

static int py_winreg_QueryValue_in_set_data_size(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winreg_QueryValue *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->in.data_size));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.data_size");
		return -1;
	}
	if (value == Py_None) {
		object->in.data_size = NULL;
	} else {
		object->in.data_size = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->in.data_size);
		if (object->in.data_size == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		{
			const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(*object->in.data_size));
			if (PyLong_Check(value)) {
				unsigned long long test_var;
				test_var = PyLong_AsUnsignedLongLong(value);
				if (PyErr_Occurred() != NULL) {
					return -1;
				}
				if (test_var > uint_max) {
					PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
					  PyLong_Type.tp_name, uint_max, test_var);
					return -1;
				}
				*object->in.data_size = test_var;
			} else {
				PyErr_Format(PyExc_TypeError, "Expected type %s",
				  PyLong_Type.tp_name);
				return -1;
			}
		}
	}
	return 0;
}

static PyObject *py_winreg_QueryValue_out_get_data_size(PyObject *obj, void *closure)
{
	struct winreg_QueryValue *object = pytalloc_get_ptr(obj);
	PyObject *py_data_size;
	if (object->out.data_size == NULL) {
		Py_RETURN_NONE;
	}
	if (object->out.data_size == NULL) {
		py_data_size = Py_None;
		Py_INCREF(py_data_size);
	} else {
		py_data_size = PyLong_FromUnsignedLongLong((uint32_t)(*object->out.data_size));
	}
	return py_data_size;
}

static int py_winreg_QueryValue_out_set_data_size(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winreg_QueryValue *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->out.data_size));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->out.data_size");
		return -1;
	}
	if (value == Py_None) {
		object->out.data_size = NULL;
	} else {
		object->out.data_size = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->out.data_size);
		if (object->out.data_size == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		{
			const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(*object->out.data_size));
			if (PyLong_Check(value)) {
				unsigned long long test_var;
				test_var = PyLong_AsUnsignedLongLong(value);
				if (PyErr_Occurred() != NULL) {
					return -1;
				}
				if (test_var > uint_max) {
					PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
					  PyLong_Type.tp_name, uint_max, test_var);
					return -1;
				}
				*object->out.data_size = test_var;
			} else {
				PyErr_Format(PyExc_TypeError, "Expected type %s",
				  PyLong_Type.tp_name);
				return -1;
			}
		}
	}
	return 0;
}

static PyObject *py_winreg_QueryValue_in_get_data_length(PyObject *obj, void *closure)
{
	struct winreg_QueryValue *object = pytalloc_get_ptr(obj);
	PyObject *py_data_length;
	if (object->in.data_length == NULL) {
		Py_RETURN_NONE;
	}
	if (object->in.data_length == NULL) {
		py_data_length = Py_None;
		Py_INCREF(py_data_length);
	} else {
		py_data_length = PyLong_FromUnsignedLongLong((uint32_t)(*object->in.data_length));
	}
	return py_data_length;
}

static int py_winreg_QueryValue_in_set_data_length(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winreg_QueryValue *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->in.data_length));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.data_length");
		return -1;
	}
	if (value == Py_None) {
		object->in.data_length = NULL;
	} else {
		object->in.data_length = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->in.data_length);
		if (object->in.data_length == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		{
			const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(*object->in.data_length));
			if (PyLong_Check(value)) {
				unsigned long long test_var;
				test_var = PyLong_AsUnsignedLongLong(value);
				if (PyErr_Occurred() != NULL) {
					return -1;
				}
				if (test_var > uint_max) {
					PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
					  PyLong_Type.tp_name, uint_max, test_var);
					return -1;
				}
				*object->in.data_length = test_var;
			} else {
				PyErr_Format(PyExc_TypeError, "Expected type %s",
				  PyLong_Type.tp_name);
				return -1;
			}
		}
	}
	return 0;
}

static PyObject *py_winreg_QueryValue_out_get_data_length(PyObject *obj, void *closure)
{
	struct winreg_QueryValue *object = pytalloc_get_ptr(obj);
	PyObject *py_data_length;
	if (object->out.data_length == NULL) {
		Py_RETURN_NONE;
	}
	if (object->out.data_length == NULL) {
		py_data_length = Py_None;
		Py_INCREF(py_data_length);
	} else {
		py_data_length = PyLong_FromUnsignedLongLong((uint32_t)(*object->out.data_length));
	}
	return py_data_length;
}

static int py_winreg_QueryValue_out_set_data_length(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winreg_QueryValue *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->out.data_length));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->out.data_length");
		return -1;
	}
	if (value == Py_None) {
		object->out.data_length = NULL;
	} else {
		object->out.data_length = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->out.data_length);
		if (object->out.data_length == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		{
			const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(*object->out.data_length));
			if (PyLong_Check(value)) {
				unsigned long long test_var;
				test_var = PyLong_AsUnsignedLongLong(value);
				if (PyErr_Occurred() != NULL) {
					return -1;
				}
				if (test_var > uint_max) {
					PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
					  PyLong_Type.tp_name, uint_max, test_var);
					return -1;
				}
				*object->out.data_length = test_var;
			} else {
				PyErr_Format(PyExc_TypeError, "Expected type %s",
				  PyLong_Type.tp_name);
				return -1;
			}
		}
	}
	return 0;
}

static PyObject *py_winreg_QueryValue_get_result(PyObject *obj, void *closure)
{
	struct winreg_QueryValue *object = pytalloc_get_ptr(obj);
	PyObject *py_result;
	py_result = PyErr_FromWERROR(object->out.result);
	return py_result;
}

static int py_winreg_QueryValue_set_result(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winreg_QueryValue *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->out.result");
		return -1;
	}
	object->out.result = W_ERROR(PyLong_AsLong(value));
	return 0;
}

static PyGetSetDef py_winreg_QueryValue_getsetters[] = {
	{
		.name = discard_const_p(char, "in_handle"),
		.get = py_winreg_QueryValue_in_get_handle,
		.set = py_winreg_QueryValue_in_set_handle,
		.doc = discard_const_p(char, "PIDL-generated element of base type policy_handle")
	},
	{
		.name = discard_const_p(char, "in_value_name"),
		.get = py_winreg_QueryValue_in_get_value_name,
		.set = py_winreg_QueryValue_in_set_value_name,
		.doc = discard_const_p(char, "PIDL-generated element of base type winreg_String")
	},
	{
		.name = discard_const_p(char, "in_type"),
		.get = py_winreg_QueryValue_in_get_type,
		.set = py_winreg_QueryValue_in_set_type,
		.doc = discard_const_p(char, "PIDL-generated element of base type winreg_Type")
	},
	{
		.name = discard_const_p(char, "out_type"),
		.get = py_winreg_QueryValue_out_get_type,
		.set = py_winreg_QueryValue_out_set_type,
		.doc = discard_const_p(char, "PIDL-generated element of base type winreg_Type")
	},
	{
		.name = discard_const_p(char, "in_data"),
		.get = py_winreg_QueryValue_in_get_data,
		.set = py_winreg_QueryValue_in_set_data,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "out_data"),
		.get = py_winreg_QueryValue_out_get_data,
		.set = py_winreg_QueryValue_out_set_data,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "in_data_size"),
		.get = py_winreg_QueryValue_in_get_data_size,
		.set = py_winreg_QueryValue_in_set_data_size,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "out_data_size"),
		.get = py_winreg_QueryValue_out_get_data_size,
		.set = py_winreg_QueryValue_out_set_data_size,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "in_data_length"),
		.get = py_winreg_QueryValue_in_get_data_length,
		.set = py_winreg_QueryValue_in_set_data_length,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "out_data_length"),
		.get = py_winreg_QueryValue_out_get_data_length,
		.set = py_winreg_QueryValue_out_set_data_length,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "result"),
		.get = py_winreg_QueryValue_get_result,
		.set = py_winreg_QueryValue_set_result,
		.doc = discard_const_p(char, "PIDL-generated element of type WERROR")
	},
	{ .name = NULL }
};

static PyObject *py_winreg_QueryValue_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyObject *self = pytalloc_new(struct winreg_QueryValue, type);
	struct winreg_QueryValue *_self = (struct winreg_QueryValue *)pytalloc_get_ptr(self);
	TALLOC_CTX *mem_ctx = pytalloc_get_mem_ctx(self);
	_self->in.handle = talloc_zero(mem_ctx, struct policy_handle);
	_self->in.value_name = talloc_zero(mem_ctx, struct winreg_String);
	return self;
}

static PyObject *py_winreg_QueryValue_ndr_opnum(PyTypeObject *type, PyObject *Py_UNUSED(ignored))
{


	return PyLong_FromLong(17);
}

static PyObject *py_winreg_QueryValue_ndr_pack(PyObject *py_obj, ndr_flags_type ndr_inout_flags, libndr_flags ndr_push_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct winreg_QueryValue *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	struct ndr_push *push = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;

	if (ndr_table_winreg.num_calls < 18) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_winreg_QueryValue_ndr_pack");
		return NULL;
	}
	call = &ndr_table_winreg.calls[17];

	push = ndr_push_init_ctx(pytalloc_get_mem_ctx(py_obj));
	if (push == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	push->flags |= ndr_push_flags;

	err = call->ndr_push(push, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(push);
		PyErr_SetNdrError(err);
		return NULL;
	}
	blob = ndr_push_blob(push);
	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(push);
	return ret;
}

static PyObject *py_winreg_QueryValue_ndr_pack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_in__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_winreg_QueryValue_ndr_pack(py_obj, NDR_IN, ndr_push_flags);
}

static PyObject *py_winreg_QueryValue_ndr_pack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_out__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_winreg_QueryValue_ndr_pack(py_obj, NDR_OUT, ndr_push_flags);
}

static PyObject *py_winreg_QueryValue_ndr_unpack(PyObject *py_obj, const DATA_BLOB *blob, ndr_flags_type ndr_inout_flags, libndr_flags ndr_pull_flags, bool allow_remaining)
{
	const struct ndr_interface_call *call = NULL;
	struct winreg_QueryValue *object = pytalloc_get_ptr(py_obj);
	struct ndr_pull *pull = NULL;
	enum ndr_err_code err;

	if (ndr_table_winreg.num_calls < 18) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_winreg_QueryValue_ndr_unpack");
		return NULL;
	}
	call = &ndr_table_winreg.calls[17];

	pull = ndr_pull_init_blob(blob, object);
	if (pull == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	pull->flags |= ndr_pull_flags;

	err = call->ndr_pull(pull, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(pull);
		PyErr_SetNdrError(err);
		return NULL;
	}
	if (!allow_remaining) {
		uint32_t highest_ofs;

		if (pull->offset > pull->relative_highest_offset) {
			highest_ofs = pull->offset;
		} else {
			highest_ofs = pull->relative_highest_offset;
		}
		if (highest_ofs < pull->data_size) {
			err = ndr_pull_error(pull, NDR_ERR_UNREAD_BYTES,
				"not all bytes consumed ofs[%u] size[%u]",
				highest_ofs, pull->data_size);
			TALLOC_FREE(pull);
			PyErr_SetNdrError(err);
			return NULL;
		}
	}

	TALLOC_FREE(pull);
	Py_RETURN_NONE;
}

static PyObject *py_winreg_QueryValue_ndr_unpack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_in__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_winreg_QueryValue_ndr_unpack(py_obj, &blob, NDR_IN, ndr_pull_flags, allow_remaining);
}

static PyObject *py_winreg_QueryValue_ndr_unpack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_out__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_winreg_QueryValue_ndr_unpack(py_obj, &blob, NDR_OUT, ndr_pull_flags, allow_remaining);
}

static PyObject *py_winreg_QueryValue_ndr_print(PyObject *py_obj, PyObject *args, PyObject *kwargs, const char *name, ndr_flags_type ndr_inout_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct winreg_QueryValue *object = pytalloc_get_ptr(py_obj);
	const char * const kwnames[] = { "print_secrets", NULL };
	PyObject *py_print_secrets = NULL;
	PyObject *ret;
	char *retstr;
	bool ok;

	ok = PyArg_ParseTupleAndKeywords(args, kwargs, "|O:__ndr_print__",
		discard_const_p(char *, kwnames),
		&py_print_secrets);
	if (!ok) {
		return NULL;
	}

	if (ndr_table_winreg.num_calls < 18) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_winreg_QueryValue_ndr_print");
		return NULL;
	}
	call = &ndr_table_winreg.calls[17];

	if (py_print_secrets != NULL && PyObject_IsTrue(py_print_secrets)) {
		retstr = ndr_print_function_secret_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	} else {
		retstr = ndr_print_function_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	}
	ret = PyUnicode_FromString(retstr);
	TALLOC_FREE(retstr);

	return ret;
}

static PyObject *py_winreg_QueryValue_ndr_print_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	return py_winreg_QueryValue_ndr_print(py_obj, args, kwargs, "winreg_QueryValue_in", NDR_IN);
}

static PyObject *py_winreg_QueryValue_ndr_print_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	return py_winreg_QueryValue_ndr_print(py_obj, args, kwargs, "winreg_QueryValue_out", NDR_OUT);
}

static PyMethodDef py_winreg_QueryValue_methods[] = {
	{ "opnum", (PyCFunction)py_winreg_QueryValue_ndr_opnum, METH_NOARGS|METH_CLASS,
		"winreg.QueryValue.opnum() -> 17 (0x11) " },
	{ "__ndr_pack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winreg_QueryValue_ndr_pack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_in(object, bigendian=False, ndr64=False) -> blob\nNDR pack input" },
	{ "__ndr_pack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winreg_QueryValue_ndr_pack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_out(object, bigendian=False, ndr64=False) -> blob\nNDR pack output" },
	{ "__ndr_unpack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winreg_QueryValue_ndr_unpack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_in(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack input" },
	{ "__ndr_unpack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winreg_QueryValue_ndr_unpack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_out(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack output" },
	{ "__ndr_print_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winreg_QueryValue_ndr_print_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_print_in(object, print_secrets=False) -> String\nNDR print input" },
	{ "__ndr_print_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winreg_QueryValue_ndr_print_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_print_out(object, print_secrets=False) -> String\nNDR print output" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject winreg_QueryValue_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "winreg.QueryValue",
	.tp_getset = py_winreg_QueryValue_getsetters,
	.tp_methods = py_winreg_QueryValue_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_winreg_QueryValue_new,
};

static bool pack_py_winreg_QueryValue_args_in(PyObject *args, PyObject *kwargs, struct winreg_QueryValue *r)
{
	PyObject *py_handle;
	PyObject *py_value_name;
	PyObject *py_type;
	PyObject *py_data;
	PyObject *py_data_size;
	PyObject *py_data_length;
	const char *kwnames[] = {
		"handle", "value_name", "type", "data", "data_size", "data_length", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOOOOO:winreg_QueryValue", discard_const_p(char *, kwnames), &py_handle, &py_value_name, &py_type, &py_data, &py_data_size, &py_data_length)) {
		return false;
	}

	if (py_handle == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.handle");
		return false;
	}
	r->in.handle = talloc_ptrtype(r, r->in.handle);
	if (r->in.handle == NULL) {
		PyErr_NoMemory();
		return false;
	}
	PY_CHECK_TYPE(policy_handle_Type, py_handle, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_handle)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.handle = (struct policy_handle *)pytalloc_get_ptr(py_handle);
	if (py_value_name == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.value_name");
		return false;
	}
	r->in.value_name = talloc_ptrtype(r, r->in.value_name);
	if (r->in.value_name == NULL) {
		PyErr_NoMemory();
		return false;
	}
	PY_CHECK_TYPE(&winreg_String_Type, py_value_name, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_value_name)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.value_name = (struct winreg_String *)pytalloc_get_ptr(py_value_name);
	if (py_type == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.type");
		return false;
	}
	if (py_type == Py_None) {
		r->in.type = NULL;
	} else {
		r->in.type = talloc_ptrtype(r, r->in.type);
		if (r->in.type == NULL) {
			PyErr_NoMemory();
			return false;
		}
		{
			const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(*r->in.type));
			if (PyLong_Check(py_type)) {
				unsigned long long test_var;
				test_var = PyLong_AsUnsignedLongLong(py_type);
				if (PyErr_Occurred() != NULL) {
					return false;
				}
				if (test_var > uint_max) {
					PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
					  PyLong_Type.tp_name, uint_max, test_var);
					return false;
				}
				*r->in.type = test_var;
			} else {
				PyErr_Format(PyExc_TypeError, "Expected type %s",
				  PyLong_Type.tp_name);
				return false;
			}
		}
	}
	if (py_data == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.data");
		return false;
	}
	if (py_data == Py_None) {
		r->in.data = NULL;
	} else {
		r->in.data = NULL;
		PY_CHECK_TYPE(&PyList_Type, py_data, return false;);
		{
			int data_cntr_1;
			r->in.data = talloc_array_ptrtype(r, r->in.data, PyList_GET_SIZE(py_data));
			if (!r->in.data) { return false; }
			talloc_set_name_const(r->in.data, "ARRAY: r->in.data");
			for (data_cntr_1 = 0; data_cntr_1 < PyList_GET_SIZE(py_data); data_cntr_1++) {
				if (PyList_GET_ITEM(py_data, data_cntr_1) == NULL) {
					PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: (r->in.data)[data_cntr_1]");
					return false;
				}
				{
					const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof((r->in.data)[data_cntr_1]));
					if (PyLong_Check(PyList_GET_ITEM(py_data, data_cntr_1))) {
						unsigned long long test_var;
						test_var = PyLong_AsUnsignedLongLong(PyList_GET_ITEM(py_data, data_cntr_1));
						if (PyErr_Occurred() != NULL) {
							return false;
						}
						if (test_var > uint_max) {
							PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
							  PyLong_Type.tp_name, uint_max, test_var);
							return false;
						}
						(r->in.data)[data_cntr_1] = test_var;
					} else {
						PyErr_Format(PyExc_TypeError, "Expected type %s",
						  PyLong_Type.tp_name);
						return false;
					}
				}
			}
		}
	}
	if (py_data_size == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.data_size");
		return false;
	}
	if (py_data_size == Py_None) {
		r->in.data_size = NULL;
	} else {
		r->in.data_size = talloc_ptrtype(r, r->in.data_size);
		if (r->in.data_size == NULL) {
			PyErr_NoMemory();
			return false;
		}
		{
			const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(*r->in.data_size));
			if (PyLong_Check(py_data_size)) {
				unsigned long long test_var;
				test_var = PyLong_AsUnsignedLongLong(py_data_size);
				if (PyErr_Occurred() != NULL) {
					return false;
				}
				if (test_var > uint_max) {
					PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
					  PyLong_Type.tp_name, uint_max, test_var);
					return false;
				}
				*r->in.data_size = test_var;
			} else {
				PyErr_Format(PyExc_TypeError, "Expected type %s",
				  PyLong_Type.tp_name);
				return false;
			}
		}
	}
	if (py_data_length == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.data_length");
		return false;
	}
	if (py_data_length == Py_None) {
		r->in.data_length = NULL;
	} else {
		r->in.data_length = talloc_ptrtype(r, r->in.data_length);
		if (r->in.data_length == NULL) {
			PyErr_NoMemory();
			return false;
		}
		{
			const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(*r->in.data_length));
			if (PyLong_Check(py_data_length)) {
				unsigned long long test_var;
				test_var = PyLong_AsUnsignedLongLong(py_data_length);
				if (PyErr_Occurred() != NULL) {
					return false;
				}
				if (test_var > uint_max) {
					PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
					  PyLong_Type.tp_name, uint_max, test_var);
					return false;
				}
				*r->in.data_length = test_var;
			} else {
				PyErr_Format(PyExc_TypeError, "Expected type %s",
				  PyLong_Type.tp_name);
				return false;
			}
		}
	}
	return true;
}

static PyObject *unpack_py_winreg_QueryValue_args_out(struct winreg_QueryValue *r, bool raise_result_exception)
{
	PyObject *py_type = NULL;
	PyObject *py_data = NULL;
	PyObject *py_data_size = NULL;
	PyObject *py_data_length = NULL;
	PyObject *result = NULL;
	size_t result_size = 4;

	if (raise_result_exception) {
		if (!W_ERROR_IS_OK(r->out.result)) {
			PyErr_SetWERROR(r->out.result);
			return NULL;
		}

	} else {
		/* WERROR will be part of the results */
		result_size += 1;
	}

	if (result_size > 1) {
		result = PyTuple_New(result_size);
		if (result == NULL) {
			return NULL;
		}
	}

	if (r->out.type == NULL) {
		py_type = Py_None;
		Py_INCREF(py_type);
	} else {
		py_type = PyLong_FromUnsignedLongLong((uint32_t)(*r->out.type));
	}
	PyTuple_SetItem(result, 0, py_type);

	if (r->out.data == NULL) {
		py_data = Py_None;
		Py_INCREF(py_data);
	} else {
		py_data = PyList_New(r->out.data_length?*r->out.data_length:0);
		if (py_data == NULL) {
			return NULL;
		}
		{
			int data_cntr_1;
			for (data_cntr_1 = 0; data_cntr_1 < (r->out.data_length?*r->out.data_length:0); data_cntr_1++) {
				PyObject *py_data_1;
				py_data_1 = PyLong_FromLong((uint16_t)((r->out.data)[data_cntr_1]));
				PyList_SetItem(py_data, data_cntr_1, py_data_1);
			}
		}
	}
	PyTuple_SetItem(result, 1, py_data);

	if (r->out.data_size == NULL) {
		py_data_size = Py_None;
		Py_INCREF(py_data_size);
	} else {
		py_data_size = PyLong_FromUnsignedLongLong((uint32_t)(*r->out.data_size));
	}
	PyTuple_SetItem(result, 2, py_data_size);

	if (r->out.data_length == NULL) {
		py_data_length = Py_None;
		Py_INCREF(py_data_length);
	} else {
		py_data_length = PyLong_FromUnsignedLongLong((uint32_t)(*r->out.data_length));
	}
	PyTuple_SetItem(result, 3, py_data_length);

	if (!raise_result_exception) {
		PyTuple_SetItem(result, 4, PyErr_FromWERROR(r->out.result));
	}

	return result;
}


static PyObject *py_winreg_ReplaceKey_in_get_handle(PyObject *obj, void *closure)
{
	struct winreg_ReplaceKey *object = pytalloc_get_ptr(obj);
	PyObject *py_handle;
	if (object->in.handle == NULL) {
		Py_RETURN_NONE;
	}
	py_handle = pytalloc_reference_ex(policy_handle_Type, object->in.handle, object->in.handle);
	return py_handle;
}

static int py_winreg_ReplaceKey_in_set_handle(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winreg_ReplaceKey *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->in.handle));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.handle");
		return -1;
	}
	object->in.handle = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->in.handle);
	if (object->in.handle == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	PY_CHECK_TYPE(policy_handle_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->in.handle = (struct policy_handle *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_winreg_ReplaceKey_in_get_subkey(PyObject *obj, void *closure)
{
	struct winreg_ReplaceKey *object = pytalloc_get_ptr(obj);
	PyObject *py_subkey;
	if (object->in.subkey == NULL) {
		Py_RETURN_NONE;
	}
	py_subkey = pytalloc_reference_ex(&winreg_String_Type, object->in.subkey, object->in.subkey);
	return py_subkey;
}

static int py_winreg_ReplaceKey_in_set_subkey(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winreg_ReplaceKey *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->in.subkey));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.subkey");
		return -1;
	}
	object->in.subkey = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->in.subkey);
	if (object->in.subkey == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	PY_CHECK_TYPE(&winreg_String_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->in.subkey = (struct winreg_String *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_winreg_ReplaceKey_in_get_new_file(PyObject *obj, void *closure)
{
	struct winreg_ReplaceKey *object = pytalloc_get_ptr(obj);
	PyObject *py_new_file;
	if (object->in.new_file == NULL) {
		Py_RETURN_NONE;
	}
	py_new_file = pytalloc_reference_ex(&winreg_String_Type, object->in.new_file, object->in.new_file);
	return py_new_file;
}

static int py_winreg_ReplaceKey_in_set_new_file(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winreg_ReplaceKey *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->in.new_file));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.new_file");
		return -1;
	}
	object->in.new_file = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->in.new_file);
	if (object->in.new_file == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	PY_CHECK_TYPE(&winreg_String_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->in.new_file = (struct winreg_String *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_winreg_ReplaceKey_in_get_old_file(PyObject *obj, void *closure)
{
	struct winreg_ReplaceKey *object = pytalloc_get_ptr(obj);
	PyObject *py_old_file;
	if (object->in.old_file == NULL) {
		Py_RETURN_NONE;
	}
	py_old_file = pytalloc_reference_ex(&winreg_String_Type, object->in.old_file, object->in.old_file);
	return py_old_file;
}

static int py_winreg_ReplaceKey_in_set_old_file(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winreg_ReplaceKey *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->in.old_file));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.old_file");
		return -1;
	}
	object->in.old_file = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->in.old_file);
	if (object->in.old_file == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	PY_CHECK_TYPE(&winreg_String_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->in.old_file = (struct winreg_String *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_winreg_ReplaceKey_get_result(PyObject *obj, void *closure)
{
	struct winreg_ReplaceKey *object = pytalloc_get_ptr(obj);
	PyObject *py_result;
	py_result = PyErr_FromWERROR(object->out.result);
	return py_result;
}

static int py_winreg_ReplaceKey_set_result(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winreg_ReplaceKey *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->out.result");
		return -1;
	}
	object->out.result = W_ERROR(PyLong_AsLong(value));
	return 0;
}

static PyGetSetDef py_winreg_ReplaceKey_getsetters[] = {
	{
		.name = discard_const_p(char, "in_handle"),
		.get = py_winreg_ReplaceKey_in_get_handle,
		.set = py_winreg_ReplaceKey_in_set_handle,
		.doc = discard_const_p(char, "PIDL-generated element of base type policy_handle")
	},
	{
		.name = discard_const_p(char, "in_subkey"),
		.get = py_winreg_ReplaceKey_in_get_subkey,
		.set = py_winreg_ReplaceKey_in_set_subkey,
		.doc = discard_const_p(char, "PIDL-generated element of base type winreg_String")
	},
	{
		.name = discard_const_p(char, "in_new_file"),
		.get = py_winreg_ReplaceKey_in_get_new_file,
		.set = py_winreg_ReplaceKey_in_set_new_file,
		.doc = discard_const_p(char, "PIDL-generated element of base type winreg_String")
	},
	{
		.name = discard_const_p(char, "in_old_file"),
		.get = py_winreg_ReplaceKey_in_get_old_file,
		.set = py_winreg_ReplaceKey_in_set_old_file,
		.doc = discard_const_p(char, "PIDL-generated element of base type winreg_String")
	},
	{
		.name = discard_const_p(char, "result"),
		.get = py_winreg_ReplaceKey_get_result,
		.set = py_winreg_ReplaceKey_set_result,
		.doc = discard_const_p(char, "PIDL-generated element of type WERROR")
	},
	{ .name = NULL }
};

static PyObject *py_winreg_ReplaceKey_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyObject *self = pytalloc_new(struct winreg_ReplaceKey, type);
	struct winreg_ReplaceKey *_self = (struct winreg_ReplaceKey *)pytalloc_get_ptr(self);
	TALLOC_CTX *mem_ctx = pytalloc_get_mem_ctx(self);
	_self->in.handle = talloc_zero(mem_ctx, struct policy_handle);
	_self->in.subkey = talloc_zero(mem_ctx, struct winreg_String);
	_self->in.new_file = talloc_zero(mem_ctx, struct winreg_String);
	_self->in.old_file = talloc_zero(mem_ctx, struct winreg_String);
	return self;
}

static PyObject *py_winreg_ReplaceKey_ndr_opnum(PyTypeObject *type, PyObject *Py_UNUSED(ignored))
{


	return PyLong_FromLong(18);
}

static PyObject *py_winreg_ReplaceKey_ndr_pack(PyObject *py_obj, ndr_flags_type ndr_inout_flags, libndr_flags ndr_push_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct winreg_ReplaceKey *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	struct ndr_push *push = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;

	if (ndr_table_winreg.num_calls < 19) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_winreg_ReplaceKey_ndr_pack");
		return NULL;
	}
	call = &ndr_table_winreg.calls[18];

	push = ndr_push_init_ctx(pytalloc_get_mem_ctx(py_obj));
	if (push == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	push->flags |= ndr_push_flags;

	err = call->ndr_push(push, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(push);
		PyErr_SetNdrError(err);
		return NULL;
	}
	blob = ndr_push_blob(push);
	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(push);
	return ret;
}

static PyObject *py_winreg_ReplaceKey_ndr_pack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_in__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_winreg_ReplaceKey_ndr_pack(py_obj, NDR_IN, ndr_push_flags);
}

static PyObject *py_winreg_ReplaceKey_ndr_pack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_out__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_winreg_ReplaceKey_ndr_pack(py_obj, NDR_OUT, ndr_push_flags);
}

static PyObject *py_winreg_ReplaceKey_ndr_unpack(PyObject *py_obj, const DATA_BLOB *blob, ndr_flags_type ndr_inout_flags, libndr_flags ndr_pull_flags, bool allow_remaining)
{
	const struct ndr_interface_call *call = NULL;
	struct winreg_ReplaceKey *object = pytalloc_get_ptr(py_obj);
	struct ndr_pull *pull = NULL;
	enum ndr_err_code err;

	if (ndr_table_winreg.num_calls < 19) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_winreg_ReplaceKey_ndr_unpack");
		return NULL;
	}
	call = &ndr_table_winreg.calls[18];

	pull = ndr_pull_init_blob(blob, object);
	if (pull == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	pull->flags |= ndr_pull_flags;

	err = call->ndr_pull(pull, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(pull);
		PyErr_SetNdrError(err);
		return NULL;
	}
	if (!allow_remaining) {
		uint32_t highest_ofs;

		if (pull->offset > pull->relative_highest_offset) {
			highest_ofs = pull->offset;
		} else {
			highest_ofs = pull->relative_highest_offset;
		}
		if (highest_ofs < pull->data_size) {
			err = ndr_pull_error(pull, NDR_ERR_UNREAD_BYTES,
				"not all bytes consumed ofs[%u] size[%u]",
				highest_ofs, pull->data_size);
			TALLOC_FREE(pull);
			PyErr_SetNdrError(err);
			return NULL;
		}
	}

	TALLOC_FREE(pull);
	Py_RETURN_NONE;
}

static PyObject *py_winreg_ReplaceKey_ndr_unpack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_in__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_winreg_ReplaceKey_ndr_unpack(py_obj, &blob, NDR_IN, ndr_pull_flags, allow_remaining);
}

static PyObject *py_winreg_ReplaceKey_ndr_unpack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_out__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_winreg_ReplaceKey_ndr_unpack(py_obj, &blob, NDR_OUT, ndr_pull_flags, allow_remaining);
}

static PyObject *py_winreg_ReplaceKey_ndr_print(PyObject *py_obj, PyObject *args, PyObject *kwargs, const char *name, ndr_flags_type ndr_inout_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct winreg_ReplaceKey *object = pytalloc_get_ptr(py_obj);
	const char * const kwnames[] = { "print_secrets", NULL };
	PyObject *py_print_secrets = NULL;
	PyObject *ret;
	char *retstr;
	bool ok;

	ok = PyArg_ParseTupleAndKeywords(args, kwargs, "|O:__ndr_print__",
		discard_const_p(char *, kwnames),
		&py_print_secrets);
	if (!ok) {
		return NULL;
	}

	if (ndr_table_winreg.num_calls < 19) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_winreg_ReplaceKey_ndr_print");
		return NULL;
	}
	call = &ndr_table_winreg.calls[18];

	if (py_print_secrets != NULL && PyObject_IsTrue(py_print_secrets)) {
		retstr = ndr_print_function_secret_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	} else {
		retstr = ndr_print_function_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	}
	ret = PyUnicode_FromString(retstr);
	TALLOC_FREE(retstr);

	return ret;
}

static PyObject *py_winreg_ReplaceKey_ndr_print_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	return py_winreg_ReplaceKey_ndr_print(py_obj, args, kwargs, "winreg_ReplaceKey_in", NDR_IN);
}

static PyObject *py_winreg_ReplaceKey_ndr_print_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	return py_winreg_ReplaceKey_ndr_print(py_obj, args, kwargs, "winreg_ReplaceKey_out", NDR_OUT);
}

static PyMethodDef py_winreg_ReplaceKey_methods[] = {
	{ "opnum", (PyCFunction)py_winreg_ReplaceKey_ndr_opnum, METH_NOARGS|METH_CLASS,
		"winreg.ReplaceKey.opnum() -> 18 (0x12) " },
	{ "__ndr_pack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winreg_ReplaceKey_ndr_pack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_in(object, bigendian=False, ndr64=False) -> blob\nNDR pack input" },
	{ "__ndr_pack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winreg_ReplaceKey_ndr_pack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_out(object, bigendian=False, ndr64=False) -> blob\nNDR pack output" },
	{ "__ndr_unpack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winreg_ReplaceKey_ndr_unpack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_in(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack input" },
	{ "__ndr_unpack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winreg_ReplaceKey_ndr_unpack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_out(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack output" },
	{ "__ndr_print_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winreg_ReplaceKey_ndr_print_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_print_in(object, print_secrets=False) -> String\nNDR print input" },
	{ "__ndr_print_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winreg_ReplaceKey_ndr_print_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_print_out(object, print_secrets=False) -> String\nNDR print output" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject winreg_ReplaceKey_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "winreg.ReplaceKey",
	.tp_getset = py_winreg_ReplaceKey_getsetters,
	.tp_methods = py_winreg_ReplaceKey_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_winreg_ReplaceKey_new,
};

static bool pack_py_winreg_ReplaceKey_args_in(PyObject *args, PyObject *kwargs, struct winreg_ReplaceKey *r)
{
	PyObject *py_handle;
	PyObject *py_subkey;
	PyObject *py_new_file;
	PyObject *py_old_file;
	const char *kwnames[] = {
		"handle", "subkey", "new_file", "old_file", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOOO:winreg_ReplaceKey", discard_const_p(char *, kwnames), &py_handle, &py_subkey, &py_new_file, &py_old_file)) {
		return false;
	}

	if (py_handle == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.handle");
		return false;
	}
	r->in.handle = talloc_ptrtype(r, r->in.handle);
	if (r->in.handle == NULL) {
		PyErr_NoMemory();
		return false;
	}
	PY_CHECK_TYPE(policy_handle_Type, py_handle, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_handle)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.handle = (struct policy_handle *)pytalloc_get_ptr(py_handle);
	if (py_subkey == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.subkey");
		return false;
	}
	r->in.subkey = talloc_ptrtype(r, r->in.subkey);
	if (r->in.subkey == NULL) {
		PyErr_NoMemory();
		return false;
	}
	PY_CHECK_TYPE(&winreg_String_Type, py_subkey, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_subkey)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.subkey = (struct winreg_String *)pytalloc_get_ptr(py_subkey);
	if (py_new_file == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.new_file");
		return false;
	}
	r->in.new_file = talloc_ptrtype(r, r->in.new_file);
	if (r->in.new_file == NULL) {
		PyErr_NoMemory();
		return false;
	}
	PY_CHECK_TYPE(&winreg_String_Type, py_new_file, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_new_file)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.new_file = (struct winreg_String *)pytalloc_get_ptr(py_new_file);
	if (py_old_file == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.old_file");
		return false;
	}
	r->in.old_file = talloc_ptrtype(r, r->in.old_file);
	if (r->in.old_file == NULL) {
		PyErr_NoMemory();
		return false;
	}
	PY_CHECK_TYPE(&winreg_String_Type, py_old_file, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_old_file)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.old_file = (struct winreg_String *)pytalloc_get_ptr(py_old_file);
	return true;
}

static PyObject *unpack_py_winreg_ReplaceKey_args_out(struct winreg_ReplaceKey *r, bool raise_result_exception)
{
	PyObject *result = NULL;
	size_t result_size = 0;

	if (raise_result_exception) {
		if (!W_ERROR_IS_OK(r->out.result)) {
			PyErr_SetWERROR(r->out.result);
			return NULL;
		}

	} else {
		/* WERROR will be part of the results */
		result_size += 1;
	}

	if (!raise_result_exception) {
		result = PyErr_FromWERROR(r->out.result);
	}

	if (result_size == 0) {
		result = Py_None;
		Py_INCREF(result);
	}

	return result;
}


static PyObject *py_winreg_RestoreKey_in_get_handle(PyObject *obj, void *closure)
{
	struct winreg_RestoreKey *object = pytalloc_get_ptr(obj);
	PyObject *py_handle;
	if (object->in.handle == NULL) {
		Py_RETURN_NONE;
	}
	py_handle = pytalloc_reference_ex(policy_handle_Type, object->in.handle, object->in.handle);
	return py_handle;
}

static int py_winreg_RestoreKey_in_set_handle(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winreg_RestoreKey *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->in.handle));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.handle");
		return -1;
	}
	object->in.handle = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->in.handle);
	if (object->in.handle == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	PY_CHECK_TYPE(policy_handle_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->in.handle = (struct policy_handle *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_winreg_RestoreKey_in_get_filename(PyObject *obj, void *closure)
{
	struct winreg_RestoreKey *object = pytalloc_get_ptr(obj);
	PyObject *py_filename;
	if (object->in.filename == NULL) {
		Py_RETURN_NONE;
	}
	py_filename = pytalloc_reference_ex(&winreg_String_Type, object->in.filename, object->in.filename);
	return py_filename;
}

static int py_winreg_RestoreKey_in_set_filename(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winreg_RestoreKey *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->in.filename));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.filename");
		return -1;
	}
	object->in.filename = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->in.filename);
	if (object->in.filename == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	PY_CHECK_TYPE(&winreg_String_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->in.filename = (struct winreg_String *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_winreg_RestoreKey_in_get_flags(PyObject *obj, void *closure)
{
	struct winreg_RestoreKey *object = pytalloc_get_ptr(obj);
	PyObject *py_flags;
	py_flags = PyLong_FromUnsignedLongLong((uint32_t)(object->in.flags));
	return py_flags;
}

static int py_winreg_RestoreKey_in_set_flags(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winreg_RestoreKey *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.flags");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->in.flags));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->in.flags = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_winreg_RestoreKey_get_result(PyObject *obj, void *closure)
{
	struct winreg_RestoreKey *object = pytalloc_get_ptr(obj);
	PyObject *py_result;
	py_result = PyErr_FromWERROR(object->out.result);
	return py_result;
}

static int py_winreg_RestoreKey_set_result(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winreg_RestoreKey *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->out.result");
		return -1;
	}
	object->out.result = W_ERROR(PyLong_AsLong(value));
	return 0;
}

static PyGetSetDef py_winreg_RestoreKey_getsetters[] = {
	{
		.name = discard_const_p(char, "in_handle"),
		.get = py_winreg_RestoreKey_in_get_handle,
		.set = py_winreg_RestoreKey_in_set_handle,
		.doc = discard_const_p(char, "PIDL-generated element of base type policy_handle")
	},
	{
		.name = discard_const_p(char, "in_filename"),
		.get = py_winreg_RestoreKey_in_get_filename,
		.set = py_winreg_RestoreKey_in_set_filename,
		.doc = discard_const_p(char, "PIDL-generated element of base type winreg_String")
	},
	{
		.name = discard_const_p(char, "in_flags"),
		.get = py_winreg_RestoreKey_in_get_flags,
		.set = py_winreg_RestoreKey_in_set_flags,
		.doc = discard_const_p(char, "PIDL-generated element of base type winreg_RestoreKeyFlags")
	},
	{
		.name = discard_const_p(char, "result"),
		.get = py_winreg_RestoreKey_get_result,
		.set = py_winreg_RestoreKey_set_result,
		.doc = discard_const_p(char, "PIDL-generated element of type WERROR")
	},
	{ .name = NULL }
};

static PyObject *py_winreg_RestoreKey_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyObject *self = pytalloc_new(struct winreg_RestoreKey, type);
	struct winreg_RestoreKey *_self = (struct winreg_RestoreKey *)pytalloc_get_ptr(self);
	TALLOC_CTX *mem_ctx = pytalloc_get_mem_ctx(self);
	_self->in.handle = talloc_zero(mem_ctx, struct policy_handle);
	_self->in.filename = talloc_zero(mem_ctx, struct winreg_String);
	return self;
}

static PyObject *py_winreg_RestoreKey_ndr_opnum(PyTypeObject *type, PyObject *Py_UNUSED(ignored))
{


	return PyLong_FromLong(19);
}

static PyObject *py_winreg_RestoreKey_ndr_pack(PyObject *py_obj, ndr_flags_type ndr_inout_flags, libndr_flags ndr_push_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct winreg_RestoreKey *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	struct ndr_push *push = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;

	if (ndr_table_winreg.num_calls < 20) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_winreg_RestoreKey_ndr_pack");
		return NULL;
	}
	call = &ndr_table_winreg.calls[19];

	push = ndr_push_init_ctx(pytalloc_get_mem_ctx(py_obj));
	if (push == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	push->flags |= ndr_push_flags;

	err = call->ndr_push(push, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(push);
		PyErr_SetNdrError(err);
		return NULL;
	}
	blob = ndr_push_blob(push);
	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(push);
	return ret;
}

static PyObject *py_winreg_RestoreKey_ndr_pack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_in__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_winreg_RestoreKey_ndr_pack(py_obj, NDR_IN, ndr_push_flags);
}

static PyObject *py_winreg_RestoreKey_ndr_pack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_out__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_winreg_RestoreKey_ndr_pack(py_obj, NDR_OUT, ndr_push_flags);
}

static PyObject *py_winreg_RestoreKey_ndr_unpack(PyObject *py_obj, const DATA_BLOB *blob, ndr_flags_type ndr_inout_flags, libndr_flags ndr_pull_flags, bool allow_remaining)
{
	const struct ndr_interface_call *call = NULL;
	struct winreg_RestoreKey *object = pytalloc_get_ptr(py_obj);
	struct ndr_pull *pull = NULL;
	enum ndr_err_code err;

	if (ndr_table_winreg.num_calls < 20) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_winreg_RestoreKey_ndr_unpack");
		return NULL;
	}
	call = &ndr_table_winreg.calls[19];

	pull = ndr_pull_init_blob(blob, object);
	if (pull == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	pull->flags |= ndr_pull_flags;

	err = call->ndr_pull(pull, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(pull);
		PyErr_SetNdrError(err);
		return NULL;
	}
	if (!allow_remaining) {
		uint32_t highest_ofs;

		if (pull->offset > pull->relative_highest_offset) {
			highest_ofs = pull->offset;
		} else {
			highest_ofs = pull->relative_highest_offset;
		}
		if (highest_ofs < pull->data_size) {
			err = ndr_pull_error(pull, NDR_ERR_UNREAD_BYTES,
				"not all bytes consumed ofs[%u] size[%u]",
				highest_ofs, pull->data_size);
			TALLOC_FREE(pull);
			PyErr_SetNdrError(err);
			return NULL;
		}
	}

	TALLOC_FREE(pull);
	Py_RETURN_NONE;
}

static PyObject *py_winreg_RestoreKey_ndr_unpack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_in__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_winreg_RestoreKey_ndr_unpack(py_obj, &blob, NDR_IN, ndr_pull_flags, allow_remaining);
}

static PyObject *py_winreg_RestoreKey_ndr_unpack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_out__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_winreg_RestoreKey_ndr_unpack(py_obj, &blob, NDR_OUT, ndr_pull_flags, allow_remaining);
}

static PyObject *py_winreg_RestoreKey_ndr_print(PyObject *py_obj, PyObject *args, PyObject *kwargs, const char *name, ndr_flags_type ndr_inout_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct winreg_RestoreKey *object = pytalloc_get_ptr(py_obj);
	const char * const kwnames[] = { "print_secrets", NULL };
	PyObject *py_print_secrets = NULL;
	PyObject *ret;
	char *retstr;
	bool ok;

	ok = PyArg_ParseTupleAndKeywords(args, kwargs, "|O:__ndr_print__",
		discard_const_p(char *, kwnames),
		&py_print_secrets);
	if (!ok) {
		return NULL;
	}

	if (ndr_table_winreg.num_calls < 20) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_winreg_RestoreKey_ndr_print");
		return NULL;
	}
	call = &ndr_table_winreg.calls[19];

	if (py_print_secrets != NULL && PyObject_IsTrue(py_print_secrets)) {
		retstr = ndr_print_function_secret_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	} else {
		retstr = ndr_print_function_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	}
	ret = PyUnicode_FromString(retstr);
	TALLOC_FREE(retstr);

	return ret;
}

static PyObject *py_winreg_RestoreKey_ndr_print_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	return py_winreg_RestoreKey_ndr_print(py_obj, args, kwargs, "winreg_RestoreKey_in", NDR_IN);
}

static PyObject *py_winreg_RestoreKey_ndr_print_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	return py_winreg_RestoreKey_ndr_print(py_obj, args, kwargs, "winreg_RestoreKey_out", NDR_OUT);
}

static PyMethodDef py_winreg_RestoreKey_methods[] = {
	{ "opnum", (PyCFunction)py_winreg_RestoreKey_ndr_opnum, METH_NOARGS|METH_CLASS,
		"winreg.RestoreKey.opnum() -> 19 (0x13) " },
	{ "__ndr_pack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winreg_RestoreKey_ndr_pack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_in(object, bigendian=False, ndr64=False) -> blob\nNDR pack input" },
	{ "__ndr_pack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winreg_RestoreKey_ndr_pack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_out(object, bigendian=False, ndr64=False) -> blob\nNDR pack output" },
	{ "__ndr_unpack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winreg_RestoreKey_ndr_unpack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_in(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack input" },
	{ "__ndr_unpack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winreg_RestoreKey_ndr_unpack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_out(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack output" },
	{ "__ndr_print_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winreg_RestoreKey_ndr_print_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_print_in(object, print_secrets=False) -> String\nNDR print input" },
	{ "__ndr_print_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winreg_RestoreKey_ndr_print_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_print_out(object, print_secrets=False) -> String\nNDR print output" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject winreg_RestoreKey_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "winreg.RestoreKey",
	.tp_getset = py_winreg_RestoreKey_getsetters,
	.tp_methods = py_winreg_RestoreKey_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_winreg_RestoreKey_new,
};

static bool pack_py_winreg_RestoreKey_args_in(PyObject *args, PyObject *kwargs, struct winreg_RestoreKey *r)
{
	PyObject *py_handle;
	PyObject *py_filename;
	PyObject *py_flags;
	const char *kwnames[] = {
		"handle", "filename", "flags", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOO:winreg_RestoreKey", discard_const_p(char *, kwnames), &py_handle, &py_filename, &py_flags)) {
		return false;
	}

	if (py_handle == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.handle");
		return false;
	}
	r->in.handle = talloc_ptrtype(r, r->in.handle);
	if (r->in.handle == NULL) {
		PyErr_NoMemory();
		return false;
	}
	PY_CHECK_TYPE(policy_handle_Type, py_handle, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_handle)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.handle = (struct policy_handle *)pytalloc_get_ptr(py_handle);
	if (py_filename == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.filename");
		return false;
	}
	r->in.filename = talloc_ptrtype(r, r->in.filename);
	if (r->in.filename == NULL) {
		PyErr_NoMemory();
		return false;
	}
	PY_CHECK_TYPE(&winreg_String_Type, py_filename, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_filename)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.filename = (struct winreg_String *)pytalloc_get_ptr(py_filename);
	if (py_flags == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.flags");
		return false;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(r->in.flags));
		if (PyLong_Check(py_flags)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(py_flags);
			if (PyErr_Occurred() != NULL) {
				return false;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return false;
			}
			r->in.flags = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return false;
		}
	}
	return true;
}

static PyObject *unpack_py_winreg_RestoreKey_args_out(struct winreg_RestoreKey *r, bool raise_result_exception)
{
	PyObject *result = NULL;
	size_t result_size = 0;

	if (raise_result_exception) {
		if (!W_ERROR_IS_OK(r->out.result)) {
			PyErr_SetWERROR(r->out.result);
			return NULL;
		}

	} else {
		/* WERROR will be part of the results */
		result_size += 1;
	}

	if (!raise_result_exception) {
		result = PyErr_FromWERROR(r->out.result);
	}

	if (result_size == 0) {
		result = Py_None;
		Py_INCREF(result);
	}

	return result;
}


static PyObject *py_winreg_SaveKey_in_get_handle(PyObject *obj, void *closure)
{
	struct winreg_SaveKey *object = pytalloc_get_ptr(obj);
	PyObject *py_handle;
	if (object->in.handle == NULL) {
		Py_RETURN_NONE;
	}
	py_handle = pytalloc_reference_ex(policy_handle_Type, object->in.handle, object->in.handle);
	return py_handle;
}

static int py_winreg_SaveKey_in_set_handle(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winreg_SaveKey *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->in.handle));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.handle");
		return -1;
	}
	object->in.handle = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->in.handle);
	if (object->in.handle == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	PY_CHECK_TYPE(policy_handle_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->in.handle = (struct policy_handle *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_winreg_SaveKey_in_get_filename(PyObject *obj, void *closure)
{
	struct winreg_SaveKey *object = pytalloc_get_ptr(obj);
	PyObject *py_filename;
	if (object->in.filename == NULL) {
		Py_RETURN_NONE;
	}
	py_filename = pytalloc_reference_ex(&winreg_String_Type, object->in.filename, object->in.filename);
	return py_filename;
}

static int py_winreg_SaveKey_in_set_filename(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winreg_SaveKey *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->in.filename));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.filename");
		return -1;
	}
	object->in.filename = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->in.filename);
	if (object->in.filename == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	PY_CHECK_TYPE(&winreg_String_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->in.filename = (struct winreg_String *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_winreg_SaveKey_in_get_sec_attrib(PyObject *obj, void *closure)
{
	struct winreg_SaveKey *object = pytalloc_get_ptr(obj);
	PyObject *py_sec_attrib;
	if (object->in.sec_attrib == NULL) {
		Py_RETURN_NONE;
	}
	if (object->in.sec_attrib == NULL) {
		py_sec_attrib = Py_None;
		Py_INCREF(py_sec_attrib);
	} else {
		py_sec_attrib = pytalloc_reference_ex(&KeySecurityAttribute_Type, object->in.sec_attrib, object->in.sec_attrib);
	}
	return py_sec_attrib;
}

static int py_winreg_SaveKey_in_set_sec_attrib(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winreg_SaveKey *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->in.sec_attrib));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.sec_attrib");
		return -1;
	}
	if (value == Py_None) {
		object->in.sec_attrib = NULL;
	} else {
		object->in.sec_attrib = NULL;
		PY_CHECK_TYPE(&KeySecurityAttribute_Type, value, return -1;);
		if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->in.sec_attrib = (struct KeySecurityAttribute *)pytalloc_get_ptr(value);
	}
	return 0;
}

static PyObject *py_winreg_SaveKey_get_result(PyObject *obj, void *closure)
{
	struct winreg_SaveKey *object = pytalloc_get_ptr(obj);
	PyObject *py_result;
	py_result = PyErr_FromWERROR(object->out.result);
	return py_result;
}

static int py_winreg_SaveKey_set_result(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winreg_SaveKey *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->out.result");
		return -1;
	}
	object->out.result = W_ERROR(PyLong_AsLong(value));
	return 0;
}

static PyGetSetDef py_winreg_SaveKey_getsetters[] = {
	{
		.name = discard_const_p(char, "in_handle"),
		.get = py_winreg_SaveKey_in_get_handle,
		.set = py_winreg_SaveKey_in_set_handle,
		.doc = discard_const_p(char, "PIDL-generated element of base type policy_handle")
	},
	{
		.name = discard_const_p(char, "in_filename"),
		.get = py_winreg_SaveKey_in_get_filename,
		.set = py_winreg_SaveKey_in_set_filename,
		.doc = discard_const_p(char, "PIDL-generated element of base type winreg_String")
	},
	{
		.name = discard_const_p(char, "in_sec_attrib"),
		.get = py_winreg_SaveKey_in_get_sec_attrib,
		.set = py_winreg_SaveKey_in_set_sec_attrib,
		.doc = discard_const_p(char, "PIDL-generated element of base type KeySecurityAttribute")
	},
	{
		.name = discard_const_p(char, "result"),
		.get = py_winreg_SaveKey_get_result,
		.set = py_winreg_SaveKey_set_result,
		.doc = discard_const_p(char, "PIDL-generated element of type WERROR")
	},
	{ .name = NULL }
};

static PyObject *py_winreg_SaveKey_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyObject *self = pytalloc_new(struct winreg_SaveKey, type);
	struct winreg_SaveKey *_self = (struct winreg_SaveKey *)pytalloc_get_ptr(self);
	TALLOC_CTX *mem_ctx = pytalloc_get_mem_ctx(self);
	_self->in.handle = talloc_zero(mem_ctx, struct policy_handle);
	_self->in.filename = talloc_zero(mem_ctx, struct winreg_String);
	return self;
}

static PyObject *py_winreg_SaveKey_ndr_opnum(PyTypeObject *type, PyObject *Py_UNUSED(ignored))
{


	return PyLong_FromLong(20);
}

static PyObject *py_winreg_SaveKey_ndr_pack(PyObject *py_obj, ndr_flags_type ndr_inout_flags, libndr_flags ndr_push_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct winreg_SaveKey *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	struct ndr_push *push = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;

	if (ndr_table_winreg.num_calls < 21) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_winreg_SaveKey_ndr_pack");
		return NULL;
	}
	call = &ndr_table_winreg.calls[20];

	push = ndr_push_init_ctx(pytalloc_get_mem_ctx(py_obj));
	if (push == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	push->flags |= ndr_push_flags;

	err = call->ndr_push(push, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(push);
		PyErr_SetNdrError(err);
		return NULL;
	}
	blob = ndr_push_blob(push);
	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(push);
	return ret;
}

static PyObject *py_winreg_SaveKey_ndr_pack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_in__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_winreg_SaveKey_ndr_pack(py_obj, NDR_IN, ndr_push_flags);
}

static PyObject *py_winreg_SaveKey_ndr_pack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_out__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_winreg_SaveKey_ndr_pack(py_obj, NDR_OUT, ndr_push_flags);
}

static PyObject *py_winreg_SaveKey_ndr_unpack(PyObject *py_obj, const DATA_BLOB *blob, ndr_flags_type ndr_inout_flags, libndr_flags ndr_pull_flags, bool allow_remaining)
{
	const struct ndr_interface_call *call = NULL;
	struct winreg_SaveKey *object = pytalloc_get_ptr(py_obj);
	struct ndr_pull *pull = NULL;
	enum ndr_err_code err;

	if (ndr_table_winreg.num_calls < 21) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_winreg_SaveKey_ndr_unpack");
		return NULL;
	}
	call = &ndr_table_winreg.calls[20];

	pull = ndr_pull_init_blob(blob, object);
	if (pull == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	pull->flags |= ndr_pull_flags;

	err = call->ndr_pull(pull, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(pull);
		PyErr_SetNdrError(err);
		return NULL;
	}
	if (!allow_remaining) {
		uint32_t highest_ofs;

		if (pull->offset > pull->relative_highest_offset) {
			highest_ofs = pull->offset;
		} else {
			highest_ofs = pull->relative_highest_offset;
		}
		if (highest_ofs < pull->data_size) {
			err = ndr_pull_error(pull, NDR_ERR_UNREAD_BYTES,
				"not all bytes consumed ofs[%u] size[%u]",
				highest_ofs, pull->data_size);
			TALLOC_FREE(pull);
			PyErr_SetNdrError(err);
			return NULL;
		}
	}

	TALLOC_FREE(pull);
	Py_RETURN_NONE;
}

static PyObject *py_winreg_SaveKey_ndr_unpack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_in__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_winreg_SaveKey_ndr_unpack(py_obj, &blob, NDR_IN, ndr_pull_flags, allow_remaining);
}

static PyObject *py_winreg_SaveKey_ndr_unpack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_out__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_winreg_SaveKey_ndr_unpack(py_obj, &blob, NDR_OUT, ndr_pull_flags, allow_remaining);
}

static PyObject *py_winreg_SaveKey_ndr_print(PyObject *py_obj, PyObject *args, PyObject *kwargs, const char *name, ndr_flags_type ndr_inout_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct winreg_SaveKey *object = pytalloc_get_ptr(py_obj);
	const char * const kwnames[] = { "print_secrets", NULL };
	PyObject *py_print_secrets = NULL;
	PyObject *ret;
	char *retstr;
	bool ok;

	ok = PyArg_ParseTupleAndKeywords(args, kwargs, "|O:__ndr_print__",
		discard_const_p(char *, kwnames),
		&py_print_secrets);
	if (!ok) {
		return NULL;
	}

	if (ndr_table_winreg.num_calls < 21) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_winreg_SaveKey_ndr_print");
		return NULL;
	}
	call = &ndr_table_winreg.calls[20];

	if (py_print_secrets != NULL && PyObject_IsTrue(py_print_secrets)) {
		retstr = ndr_print_function_secret_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	} else {
		retstr = ndr_print_function_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	}
	ret = PyUnicode_FromString(retstr);
	TALLOC_FREE(retstr);

	return ret;
}

static PyObject *py_winreg_SaveKey_ndr_print_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	return py_winreg_SaveKey_ndr_print(py_obj, args, kwargs, "winreg_SaveKey_in", NDR_IN);
}

static PyObject *py_winreg_SaveKey_ndr_print_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	return py_winreg_SaveKey_ndr_print(py_obj, args, kwargs, "winreg_SaveKey_out", NDR_OUT);
}

static PyMethodDef py_winreg_SaveKey_methods[] = {
	{ "opnum", (PyCFunction)py_winreg_SaveKey_ndr_opnum, METH_NOARGS|METH_CLASS,
		"winreg.SaveKey.opnum() -> 20 (0x14) " },
	{ "__ndr_pack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winreg_SaveKey_ndr_pack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_in(object, bigendian=False, ndr64=False) -> blob\nNDR pack input" },
	{ "__ndr_pack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winreg_SaveKey_ndr_pack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_out(object, bigendian=False, ndr64=False) -> blob\nNDR pack output" },
	{ "__ndr_unpack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winreg_SaveKey_ndr_unpack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_in(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack input" },
	{ "__ndr_unpack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winreg_SaveKey_ndr_unpack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_out(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack output" },
	{ "__ndr_print_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winreg_SaveKey_ndr_print_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_print_in(object, print_secrets=False) -> String\nNDR print input" },
	{ "__ndr_print_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winreg_SaveKey_ndr_print_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_print_out(object, print_secrets=False) -> String\nNDR print output" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject winreg_SaveKey_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "winreg.SaveKey",
	.tp_getset = py_winreg_SaveKey_getsetters,
	.tp_methods = py_winreg_SaveKey_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_winreg_SaveKey_new,
};

static bool pack_py_winreg_SaveKey_args_in(PyObject *args, PyObject *kwargs, struct winreg_SaveKey *r)
{
	PyObject *py_handle;
	PyObject *py_filename;
	PyObject *py_sec_attrib;
	const char *kwnames[] = {
		"handle", "filename", "sec_attrib", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOO:winreg_SaveKey", discard_const_p(char *, kwnames), &py_handle, &py_filename, &py_sec_attrib)) {
		return false;
	}

	if (py_handle == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.handle");
		return false;
	}
	r->in.handle = talloc_ptrtype(r, r->in.handle);
	if (r->in.handle == NULL) {
		PyErr_NoMemory();
		return false;
	}
	PY_CHECK_TYPE(policy_handle_Type, py_handle, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_handle)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.handle = (struct policy_handle *)pytalloc_get_ptr(py_handle);
	if (py_filename == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.filename");
		return false;
	}
	r->in.filename = talloc_ptrtype(r, r->in.filename);
	if (r->in.filename == NULL) {
		PyErr_NoMemory();
		return false;
	}
	PY_CHECK_TYPE(&winreg_String_Type, py_filename, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_filename)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.filename = (struct winreg_String *)pytalloc_get_ptr(py_filename);
	if (py_sec_attrib == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.sec_attrib");
		return false;
	}
	if (py_sec_attrib == Py_None) {
		r->in.sec_attrib = NULL;
	} else {
		r->in.sec_attrib = NULL;
		PY_CHECK_TYPE(&KeySecurityAttribute_Type, py_sec_attrib, return false;);
		if (talloc_reference(r, pytalloc_get_mem_ctx(py_sec_attrib)) == NULL) {
			PyErr_NoMemory();
			return false;
		}
		r->in.sec_attrib = (struct KeySecurityAttribute *)pytalloc_get_ptr(py_sec_attrib);
	}
	return true;
}

static PyObject *unpack_py_winreg_SaveKey_args_out(struct winreg_SaveKey *r, bool raise_result_exception)
{
	PyObject *result = NULL;
	size_t result_size = 0;

	if (raise_result_exception) {
		if (!W_ERROR_IS_OK(r->out.result)) {
			PyErr_SetWERROR(r->out.result);
			return NULL;
		}

	} else {
		/* WERROR will be part of the results */
		result_size += 1;
	}

	if (!raise_result_exception) {
		result = PyErr_FromWERROR(r->out.result);
	}

	if (result_size == 0) {
		result = Py_None;
		Py_INCREF(result);
	}

	return result;
}


static PyObject *py_winreg_SetKeySecurity_in_get_handle(PyObject *obj, void *closure)
{
	struct winreg_SetKeySecurity *object = pytalloc_get_ptr(obj);
	PyObject *py_handle;
	if (object->in.handle == NULL) {
		Py_RETURN_NONE;
	}
	py_handle = pytalloc_reference_ex(policy_handle_Type, object->in.handle, object->in.handle);
	return py_handle;
}

static int py_winreg_SetKeySecurity_in_set_handle(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winreg_SetKeySecurity *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->in.handle));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.handle");
		return -1;
	}
	object->in.handle = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->in.handle);
	if (object->in.handle == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	PY_CHECK_TYPE(policy_handle_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->in.handle = (struct policy_handle *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_winreg_SetKeySecurity_in_get_sec_info(PyObject *obj, void *closure)
{
	struct winreg_SetKeySecurity *object = pytalloc_get_ptr(obj);
	PyObject *py_sec_info;
	py_sec_info = PyLong_FromUnsignedLongLong((uint32_t)(object->in.sec_info));
	return py_sec_info;
}

static int py_winreg_SetKeySecurity_in_set_sec_info(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winreg_SetKeySecurity *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.sec_info");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->in.sec_info));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->in.sec_info = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_winreg_SetKeySecurity_in_get_sd(PyObject *obj, void *closure)
{
	struct winreg_SetKeySecurity *object = pytalloc_get_ptr(obj);
	PyObject *py_sd;
	if (object->in.sd == NULL) {
		Py_RETURN_NONE;
	}
	py_sd = pytalloc_reference_ex(&KeySecurityData_Type, object->in.sd, object->in.sd);
	return py_sd;
}

static int py_winreg_SetKeySecurity_in_set_sd(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winreg_SetKeySecurity *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->in.sd));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.sd");
		return -1;
	}
	object->in.sd = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->in.sd);
	if (object->in.sd == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	PY_CHECK_TYPE(&KeySecurityData_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->in.sd = (struct KeySecurityData *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_winreg_SetKeySecurity_get_result(PyObject *obj, void *closure)
{
	struct winreg_SetKeySecurity *object = pytalloc_get_ptr(obj);
	PyObject *py_result;
	py_result = PyErr_FromWERROR(object->out.result);
	return py_result;
}

static int py_winreg_SetKeySecurity_set_result(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winreg_SetKeySecurity *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->out.result");
		return -1;
	}
	object->out.result = W_ERROR(PyLong_AsLong(value));
	return 0;
}

static PyGetSetDef py_winreg_SetKeySecurity_getsetters[] = {
	{
		.name = discard_const_p(char, "in_handle"),
		.get = py_winreg_SetKeySecurity_in_get_handle,
		.set = py_winreg_SetKeySecurity_in_set_handle,
		.doc = discard_const_p(char, "PIDL-generated element of base type policy_handle")
	},
	{
		.name = discard_const_p(char, "in_sec_info"),
		.get = py_winreg_SetKeySecurity_in_get_sec_info,
		.set = py_winreg_SetKeySecurity_in_set_sec_info,
		.doc = discard_const_p(char, "PIDL-generated element of base type security_secinfo")
	},
	{
		.name = discard_const_p(char, "in_sd"),
		.get = py_winreg_SetKeySecurity_in_get_sd,
		.set = py_winreg_SetKeySecurity_in_set_sd,
		.doc = discard_const_p(char, "PIDL-generated element of base type KeySecurityData")
	},
	{
		.name = discard_const_p(char, "result"),
		.get = py_winreg_SetKeySecurity_get_result,
		.set = py_winreg_SetKeySecurity_set_result,
		.doc = discard_const_p(char, "PIDL-generated element of type WERROR")
	},
	{ .name = NULL }
};

static PyObject *py_winreg_SetKeySecurity_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyObject *self = pytalloc_new(struct winreg_SetKeySecurity, type);
	struct winreg_SetKeySecurity *_self = (struct winreg_SetKeySecurity *)pytalloc_get_ptr(self);
	TALLOC_CTX *mem_ctx = pytalloc_get_mem_ctx(self);
	_self->in.handle = talloc_zero(mem_ctx, struct policy_handle);
	_self->in.sd = talloc_zero(mem_ctx, struct KeySecurityData);
	return self;
}

static PyObject *py_winreg_SetKeySecurity_ndr_opnum(PyTypeObject *type, PyObject *Py_UNUSED(ignored))
{


	return PyLong_FromLong(21);
}

static PyObject *py_winreg_SetKeySecurity_ndr_pack(PyObject *py_obj, ndr_flags_type ndr_inout_flags, libndr_flags ndr_push_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct winreg_SetKeySecurity *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	struct ndr_push *push = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;

	if (ndr_table_winreg.num_calls < 22) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_winreg_SetKeySecurity_ndr_pack");
		return NULL;
	}
	call = &ndr_table_winreg.calls[21];

	push = ndr_push_init_ctx(pytalloc_get_mem_ctx(py_obj));
	if (push == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	push->flags |= ndr_push_flags;

	err = call->ndr_push(push, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(push);
		PyErr_SetNdrError(err);
		return NULL;
	}
	blob = ndr_push_blob(push);
	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(push);
	return ret;
}

static PyObject *py_winreg_SetKeySecurity_ndr_pack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_in__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_winreg_SetKeySecurity_ndr_pack(py_obj, NDR_IN, ndr_push_flags);
}

static PyObject *py_winreg_SetKeySecurity_ndr_pack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_out__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_winreg_SetKeySecurity_ndr_pack(py_obj, NDR_OUT, ndr_push_flags);
}

static PyObject *py_winreg_SetKeySecurity_ndr_unpack(PyObject *py_obj, const DATA_BLOB *blob, ndr_flags_type ndr_inout_flags, libndr_flags ndr_pull_flags, bool allow_remaining)
{
	const struct ndr_interface_call *call = NULL;
	struct winreg_SetKeySecurity *object = pytalloc_get_ptr(py_obj);
	struct ndr_pull *pull = NULL;
	enum ndr_err_code err;

	if (ndr_table_winreg.num_calls < 22) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_winreg_SetKeySecurity_ndr_unpack");
		return NULL;
	}
	call = &ndr_table_winreg.calls[21];

	pull = ndr_pull_init_blob(blob, object);
	if (pull == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	pull->flags |= ndr_pull_flags;

	err = call->ndr_pull(pull, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(pull);
		PyErr_SetNdrError(err);
		return NULL;
	}
	if (!allow_remaining) {
		uint32_t highest_ofs;

		if (pull->offset > pull->relative_highest_offset) {
			highest_ofs = pull->offset;
		} else {
			highest_ofs = pull->relative_highest_offset;
		}
		if (highest_ofs < pull->data_size) {
			err = ndr_pull_error(pull, NDR_ERR_UNREAD_BYTES,
				"not all bytes consumed ofs[%u] size[%u]",
				highest_ofs, pull->data_size);
			TALLOC_FREE(pull);
			PyErr_SetNdrError(err);
			return NULL;
		}
	}

	TALLOC_FREE(pull);
	Py_RETURN_NONE;
}

static PyObject *py_winreg_SetKeySecurity_ndr_unpack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_in__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_winreg_SetKeySecurity_ndr_unpack(py_obj, &blob, NDR_IN, ndr_pull_flags, allow_remaining);
}

static PyObject *py_winreg_SetKeySecurity_ndr_unpack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_out__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_winreg_SetKeySecurity_ndr_unpack(py_obj, &blob, NDR_OUT, ndr_pull_flags, allow_remaining);
}

static PyObject *py_winreg_SetKeySecurity_ndr_print(PyObject *py_obj, PyObject *args, PyObject *kwargs, const char *name, ndr_flags_type ndr_inout_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct winreg_SetKeySecurity *object = pytalloc_get_ptr(py_obj);
	const char * const kwnames[] = { "print_secrets", NULL };
	PyObject *py_print_secrets = NULL;
	PyObject *ret;
	char *retstr;
	bool ok;

	ok = PyArg_ParseTupleAndKeywords(args, kwargs, "|O:__ndr_print__",
		discard_const_p(char *, kwnames),
		&py_print_secrets);
	if (!ok) {
		return NULL;
	}

	if (ndr_table_winreg.num_calls < 22) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_winreg_SetKeySecurity_ndr_print");
		return NULL;
	}
	call = &ndr_table_winreg.calls[21];

	if (py_print_secrets != NULL && PyObject_IsTrue(py_print_secrets)) {
		retstr = ndr_print_function_secret_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	} else {
		retstr = ndr_print_function_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	}
	ret = PyUnicode_FromString(retstr);
	TALLOC_FREE(retstr);

	return ret;
}

static PyObject *py_winreg_SetKeySecurity_ndr_print_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	return py_winreg_SetKeySecurity_ndr_print(py_obj, args, kwargs, "winreg_SetKeySecurity_in", NDR_IN);
}

static PyObject *py_winreg_SetKeySecurity_ndr_print_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	return py_winreg_SetKeySecurity_ndr_print(py_obj, args, kwargs, "winreg_SetKeySecurity_out", NDR_OUT);
}

static PyMethodDef py_winreg_SetKeySecurity_methods[] = {
	{ "opnum", (PyCFunction)py_winreg_SetKeySecurity_ndr_opnum, METH_NOARGS|METH_CLASS,
		"winreg.SetKeySecurity.opnum() -> 21 (0x15) " },
	{ "__ndr_pack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winreg_SetKeySecurity_ndr_pack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_in(object, bigendian=False, ndr64=False) -> blob\nNDR pack input" },
	{ "__ndr_pack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winreg_SetKeySecurity_ndr_pack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_out(object, bigendian=False, ndr64=False) -> blob\nNDR pack output" },
	{ "__ndr_unpack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winreg_SetKeySecurity_ndr_unpack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_in(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack input" },
	{ "__ndr_unpack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winreg_SetKeySecurity_ndr_unpack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_out(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack output" },
	{ "__ndr_print_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winreg_SetKeySecurity_ndr_print_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_print_in(object, print_secrets=False) -> String\nNDR print input" },
	{ "__ndr_print_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winreg_SetKeySecurity_ndr_print_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_print_out(object, print_secrets=False) -> String\nNDR print output" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject winreg_SetKeySecurity_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "winreg.SetKeySecurity",
	.tp_getset = py_winreg_SetKeySecurity_getsetters,
	.tp_methods = py_winreg_SetKeySecurity_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_winreg_SetKeySecurity_new,
};

static bool pack_py_winreg_SetKeySecurity_args_in(PyObject *args, PyObject *kwargs, struct winreg_SetKeySecurity *r)
{
	PyObject *py_handle;
	PyObject *py_sec_info;
	PyObject *py_sd;
	const char *kwnames[] = {
		"handle", "sec_info", "sd", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOO:winreg_SetKeySecurity", discard_const_p(char *, kwnames), &py_handle, &py_sec_info, &py_sd)) {
		return false;
	}

	if (py_handle == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.handle");
		return false;
	}
	r->in.handle = talloc_ptrtype(r, r->in.handle);
	if (r->in.handle == NULL) {
		PyErr_NoMemory();
		return false;
	}
	PY_CHECK_TYPE(policy_handle_Type, py_handle, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_handle)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.handle = (struct policy_handle *)pytalloc_get_ptr(py_handle);
	if (py_sec_info == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.sec_info");
		return false;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(r->in.sec_info));
		if (PyLong_Check(py_sec_info)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(py_sec_info);
			if (PyErr_Occurred() != NULL) {
				return false;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return false;
			}
			r->in.sec_info = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return false;
		}
	}
	if (py_sd == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.sd");
		return false;
	}
	r->in.sd = talloc_ptrtype(r, r->in.sd);
	if (r->in.sd == NULL) {
		PyErr_NoMemory();
		return false;
	}
	PY_CHECK_TYPE(&KeySecurityData_Type, py_sd, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_sd)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.sd = (struct KeySecurityData *)pytalloc_get_ptr(py_sd);
	return true;
}

static PyObject *unpack_py_winreg_SetKeySecurity_args_out(struct winreg_SetKeySecurity *r, bool raise_result_exception)
{
	PyObject *result = NULL;
	size_t result_size = 0;

	if (raise_result_exception) {
		if (!W_ERROR_IS_OK(r->out.result)) {
			PyErr_SetWERROR(r->out.result);
			return NULL;
		}

	} else {
		/* WERROR will be part of the results */
		result_size += 1;
	}

	if (!raise_result_exception) {
		result = PyErr_FromWERROR(r->out.result);
	}

	if (result_size == 0) {
		result = Py_None;
		Py_INCREF(result);
	}

	return result;
}


static PyObject *py_winreg_SetValue_in_get_handle(PyObject *obj, void *closure)
{
	struct winreg_SetValue *object = pytalloc_get_ptr(obj);
	PyObject *py_handle;
	if (object->in.handle == NULL) {
		Py_RETURN_NONE;
	}
	py_handle = pytalloc_reference_ex(policy_handle_Type, object->in.handle, object->in.handle);
	return py_handle;
}

static int py_winreg_SetValue_in_set_handle(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winreg_SetValue *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->in.handle));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.handle");
		return -1;
	}
	object->in.handle = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->in.handle);
	if (object->in.handle == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	PY_CHECK_TYPE(policy_handle_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->in.handle = (struct policy_handle *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_winreg_SetValue_in_get_name(PyObject *obj, void *closure)
{
	struct winreg_SetValue *object = pytalloc_get_ptr(obj);
	PyObject *py_name;
	py_name = pytalloc_reference_ex(&winreg_String_Type, pytalloc_get_mem_ctx(obj), &object->in.name);
	return py_name;
}

static int py_winreg_SetValue_in_set_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winreg_SetValue *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.name");
		return -1;
	}
	PY_CHECK_TYPE(&winreg_String_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->in.name = *(struct winreg_String *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_winreg_SetValue_in_get_type(PyObject *obj, void *closure)
{
	struct winreg_SetValue *object = pytalloc_get_ptr(obj);
	PyObject *py_type;
	py_type = PyLong_FromUnsignedLongLong((uint32_t)(object->in.type));
	return py_type;
}

static int py_winreg_SetValue_in_set_type(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winreg_SetValue *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.type");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->in.type));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->in.type = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_winreg_SetValue_in_get_data(PyObject *obj, void *closure)
{
	struct winreg_SetValue *object = pytalloc_get_ptr(obj);
	PyObject *py_data;
	if (object->in.data == NULL) {
		Py_RETURN_NONE;
	}
	py_data = PyList_New(object->in.size);
	if (py_data == NULL) {
		return NULL;
	}
	{
		int data_cntr_1;
		for (data_cntr_1 = 0; data_cntr_1 < (object->in.size); data_cntr_1++) {
			PyObject *py_data_1;
			py_data_1 = PyLong_FromLong((uint16_t)((object->in.data)[data_cntr_1]));
			PyList_SetItem(py_data, data_cntr_1, py_data_1);
		}
	}
	return py_data;
}

static int py_winreg_SetValue_in_set_data(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winreg_SetValue *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->in.data));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.data");
		return -1;
	}
	object->in.data = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->in.data);
	if (object->in.data == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int data_cntr_1;
		object->in.data = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->in.data, PyList_GET_SIZE(value));
		if (!object->in.data) { return -1; }
		talloc_set_name_const(object->in.data, "ARRAY: object->in.data");
		for (data_cntr_1 = 0; data_cntr_1 < PyList_GET_SIZE(value); data_cntr_1++) {
			if (PyList_GET_ITEM(value, data_cntr_1) == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: (object->in.data)[data_cntr_1]");
				return -1;
			}
			{
				const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof((object->in.data)[data_cntr_1]));
				if (PyLong_Check(PyList_GET_ITEM(value, data_cntr_1))) {
					unsigned long long test_var;
					test_var = PyLong_AsUnsignedLongLong(PyList_GET_ITEM(value, data_cntr_1));
					if (PyErr_Occurred() != NULL) {
						return -1;
					}
					if (test_var > uint_max) {
						PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
						  PyLong_Type.tp_name, uint_max, test_var);
						return -1;
					}
					(object->in.data)[data_cntr_1] = test_var;
				} else {
					PyErr_Format(PyExc_TypeError, "Expected type %s",
					  PyLong_Type.tp_name);
					return -1;
				}
			}
		}
	}
	return 0;
}

static PyObject *py_winreg_SetValue_in_get_size(PyObject *obj, void *closure)
{
	struct winreg_SetValue *object = pytalloc_get_ptr(obj);
	PyObject *py_size;
	py_size = PyLong_FromUnsignedLongLong((uint32_t)(object->in.size));
	return py_size;
}

static int py_winreg_SetValue_in_set_size(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winreg_SetValue *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.size");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->in.size));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->in.size = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_winreg_SetValue_get_result(PyObject *obj, void *closure)
{
	struct winreg_SetValue *object = pytalloc_get_ptr(obj);
	PyObject *py_result;
	py_result = PyErr_FromWERROR(object->out.result);
	return py_result;
}

static int py_winreg_SetValue_set_result(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winreg_SetValue *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->out.result");
		return -1;
	}
	object->out.result = W_ERROR(PyLong_AsLong(value));
	return 0;
}

static PyGetSetDef py_winreg_SetValue_getsetters[] = {
	{
		.name = discard_const_p(char, "in_handle"),
		.get = py_winreg_SetValue_in_get_handle,
		.set = py_winreg_SetValue_in_set_handle,
		.doc = discard_const_p(char, "PIDL-generated element of base type policy_handle")
	},
	{
		.name = discard_const_p(char, "in_name"),
		.get = py_winreg_SetValue_in_get_name,
		.set = py_winreg_SetValue_in_set_name,
		.doc = discard_const_p(char, "PIDL-generated element of base type winreg_String")
	},
	{
		.name = discard_const_p(char, "in_type"),
		.get = py_winreg_SetValue_in_get_type,
		.set = py_winreg_SetValue_in_set_type,
		.doc = discard_const_p(char, "PIDL-generated element of base type winreg_Type")
	},
	{
		.name = discard_const_p(char, "in_data"),
		.get = py_winreg_SetValue_in_get_data,
		.set = py_winreg_SetValue_in_set_data,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "in_size"),
		.get = py_winreg_SetValue_in_get_size,
		.set = py_winreg_SetValue_in_set_size,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "result"),
		.get = py_winreg_SetValue_get_result,
		.set = py_winreg_SetValue_set_result,
		.doc = discard_const_p(char, "PIDL-generated element of type WERROR")
	},
	{ .name = NULL }
};

static PyObject *py_winreg_SetValue_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyObject *self = pytalloc_new(struct winreg_SetValue, type);
	struct winreg_SetValue *_self = (struct winreg_SetValue *)pytalloc_get_ptr(self);
	TALLOC_CTX *mem_ctx = pytalloc_get_mem_ctx(self);
	_self->in.handle = talloc_zero(mem_ctx, struct policy_handle);
	_self->in.data = talloc_zero(mem_ctx, uint8_t);
	return self;
}

static PyObject *py_winreg_SetValue_ndr_opnum(PyTypeObject *type, PyObject *Py_UNUSED(ignored))
{


	return PyLong_FromLong(22);
}

static PyObject *py_winreg_SetValue_ndr_pack(PyObject *py_obj, ndr_flags_type ndr_inout_flags, libndr_flags ndr_push_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct winreg_SetValue *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	struct ndr_push *push = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;

	if (ndr_table_winreg.num_calls < 23) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_winreg_SetValue_ndr_pack");
		return NULL;
	}
	call = &ndr_table_winreg.calls[22];

	push = ndr_push_init_ctx(pytalloc_get_mem_ctx(py_obj));
	if (push == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	push->flags |= ndr_push_flags;

	err = call->ndr_push(push, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(push);
		PyErr_SetNdrError(err);
		return NULL;
	}
	blob = ndr_push_blob(push);
	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(push);
	return ret;
}

static PyObject *py_winreg_SetValue_ndr_pack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_in__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_winreg_SetValue_ndr_pack(py_obj, NDR_IN, ndr_push_flags);
}

static PyObject *py_winreg_SetValue_ndr_pack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_out__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_winreg_SetValue_ndr_pack(py_obj, NDR_OUT, ndr_push_flags);
}

static PyObject *py_winreg_SetValue_ndr_unpack(PyObject *py_obj, const DATA_BLOB *blob, ndr_flags_type ndr_inout_flags, libndr_flags ndr_pull_flags, bool allow_remaining)
{
	const struct ndr_interface_call *call = NULL;
	struct winreg_SetValue *object = pytalloc_get_ptr(py_obj);
	struct ndr_pull *pull = NULL;
	enum ndr_err_code err;

	if (ndr_table_winreg.num_calls < 23) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_winreg_SetValue_ndr_unpack");
		return NULL;
	}
	call = &ndr_table_winreg.calls[22];

	pull = ndr_pull_init_blob(blob, object);
	if (pull == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	pull->flags |= ndr_pull_flags;

	err = call->ndr_pull(pull, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(pull);
		PyErr_SetNdrError(err);
		return NULL;
	}
	if (!allow_remaining) {
		uint32_t highest_ofs;

		if (pull->offset > pull->relative_highest_offset) {
			highest_ofs = pull->offset;
		} else {
			highest_ofs = pull->relative_highest_offset;
		}
		if (highest_ofs < pull->data_size) {
			err = ndr_pull_error(pull, NDR_ERR_UNREAD_BYTES,
				"not all bytes consumed ofs[%u] size[%u]",
				highest_ofs, pull->data_size);
			TALLOC_FREE(pull);
			PyErr_SetNdrError(err);
			return NULL;
		}
	}

	TALLOC_FREE(pull);
	Py_RETURN_NONE;
}

static PyObject *py_winreg_SetValue_ndr_unpack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_in__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_winreg_SetValue_ndr_unpack(py_obj, &blob, NDR_IN, ndr_pull_flags, allow_remaining);
}

static PyObject *py_winreg_SetValue_ndr_unpack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_out__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_winreg_SetValue_ndr_unpack(py_obj, &blob, NDR_OUT, ndr_pull_flags, allow_remaining);
}

static PyObject *py_winreg_SetValue_ndr_print(PyObject *py_obj, PyObject *args, PyObject *kwargs, const char *name, ndr_flags_type ndr_inout_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct winreg_SetValue *object = pytalloc_get_ptr(py_obj);
	const char * const kwnames[] = { "print_secrets", NULL };
	PyObject *py_print_secrets = NULL;
	PyObject *ret;
	char *retstr;
	bool ok;

	ok = PyArg_ParseTupleAndKeywords(args, kwargs, "|O:__ndr_print__",
		discard_const_p(char *, kwnames),
		&py_print_secrets);
	if (!ok) {
		return NULL;
	}

	if (ndr_table_winreg.num_calls < 23) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_winreg_SetValue_ndr_print");
		return NULL;
	}
	call = &ndr_table_winreg.calls[22];

	if (py_print_secrets != NULL && PyObject_IsTrue(py_print_secrets)) {
		retstr = ndr_print_function_secret_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	} else {
		retstr = ndr_print_function_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	}
	ret = PyUnicode_FromString(retstr);
	TALLOC_FREE(retstr);

	return ret;
}

static PyObject *py_winreg_SetValue_ndr_print_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	return py_winreg_SetValue_ndr_print(py_obj, args, kwargs, "winreg_SetValue_in", NDR_IN);
}

static PyObject *py_winreg_SetValue_ndr_print_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	return py_winreg_SetValue_ndr_print(py_obj, args, kwargs, "winreg_SetValue_out", NDR_OUT);
}

static PyMethodDef py_winreg_SetValue_methods[] = {
	{ "opnum", (PyCFunction)py_winreg_SetValue_ndr_opnum, METH_NOARGS|METH_CLASS,
		"winreg.SetValue.opnum() -> 22 (0x16) " },
	{ "__ndr_pack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winreg_SetValue_ndr_pack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_in(object, bigendian=False, ndr64=False) -> blob\nNDR pack input" },
	{ "__ndr_pack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winreg_SetValue_ndr_pack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_out(object, bigendian=False, ndr64=False) -> blob\nNDR pack output" },
	{ "__ndr_unpack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winreg_SetValue_ndr_unpack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_in(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack input" },
	{ "__ndr_unpack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winreg_SetValue_ndr_unpack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_out(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack output" },
	{ "__ndr_print_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winreg_SetValue_ndr_print_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_print_in(object, print_secrets=False) -> String\nNDR print input" },
	{ "__ndr_print_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winreg_SetValue_ndr_print_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_print_out(object, print_secrets=False) -> String\nNDR print output" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject winreg_SetValue_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "winreg.SetValue",
	.tp_getset = py_winreg_SetValue_getsetters,
	.tp_methods = py_winreg_SetValue_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_winreg_SetValue_new,
};

static bool pack_py_winreg_SetValue_args_in(PyObject *args, PyObject *kwargs, struct winreg_SetValue *r)
{
	PyObject *py_handle;
	PyObject *py_name;
	PyObject *py_type;
	PyObject *py_data;
	const char *kwnames[] = {
		"handle", "name", "type", "data", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOOO:winreg_SetValue", discard_const_p(char *, kwnames), &py_handle, &py_name, &py_type, &py_data)) {
		return false;
	}

	if (py_handle == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.handle");
		return false;
	}
	r->in.handle = talloc_ptrtype(r, r->in.handle);
	if (r->in.handle == NULL) {
		PyErr_NoMemory();
		return false;
	}
	PY_CHECK_TYPE(policy_handle_Type, py_handle, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_handle)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.handle = (struct policy_handle *)pytalloc_get_ptr(py_handle);
	if (py_name == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.name");
		return false;
	}
	PY_CHECK_TYPE(&winreg_String_Type, py_name, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_name)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.name = *(struct winreg_String *)pytalloc_get_ptr(py_name);
	if (py_type == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.type");
		return false;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(r->in.type));
		if (PyLong_Check(py_type)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(py_type);
			if (PyErr_Occurred() != NULL) {
				return false;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return false;
			}
			r->in.type = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return false;
		}
	}
	if (py_data == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.data");
		return false;
	}
	r->in.data = talloc_ptrtype(r, r->in.data);
	if (r->in.data == NULL) {
		PyErr_NoMemory();
		return false;
	}
	PY_CHECK_TYPE(&PyList_Type, py_data, return false;);
	{
		int data_cntr_1;
		r->in.data = talloc_array_ptrtype(r, r->in.data, PyList_GET_SIZE(py_data));
		if (!r->in.data) { return false; }
		talloc_set_name_const(r->in.data, "ARRAY: r->in.data");
		for (data_cntr_1 = 0; data_cntr_1 < PyList_GET_SIZE(py_data); data_cntr_1++) {
			if (PyList_GET_ITEM(py_data, data_cntr_1) == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: (r->in.data)[data_cntr_1]");
				return false;
			}
			{
				const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof((r->in.data)[data_cntr_1]));
				if (PyLong_Check(PyList_GET_ITEM(py_data, data_cntr_1))) {
					unsigned long long test_var;
					test_var = PyLong_AsUnsignedLongLong(PyList_GET_ITEM(py_data, data_cntr_1));
					if (PyErr_Occurred() != NULL) {
						return false;
					}
					if (test_var > uint_max) {
						PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
						  PyLong_Type.tp_name, uint_max, test_var);
						return false;
					}
					(r->in.data)[data_cntr_1] = test_var;
				} else {
					PyErr_Format(PyExc_TypeError, "Expected type %s",
					  PyLong_Type.tp_name);
					return false;
				}
			}
		}
	}
	PY_CHECK_TYPE(&PyList_Type, py_data, return false;);
	r->in.size = PyList_GET_SIZE(py_data);
	return true;
}

static PyObject *unpack_py_winreg_SetValue_args_out(struct winreg_SetValue *r, bool raise_result_exception)
{
	PyObject *result = NULL;
	size_t result_size = 0;

	if (raise_result_exception) {
		if (!W_ERROR_IS_OK(r->out.result)) {
			PyErr_SetWERROR(r->out.result);
			return NULL;
		}

	} else {
		/* WERROR will be part of the results */
		result_size += 1;
	}

	if (!raise_result_exception) {
		result = PyErr_FromWERROR(r->out.result);
	}

	if (result_size == 0) {
		result = Py_None;
		Py_INCREF(result);
	}

	return result;
}


static PyObject *py_winreg_UnLoadKey_in_get_handle(PyObject *obj, void *closure)
{
	struct winreg_UnLoadKey *object = pytalloc_get_ptr(obj);
	PyObject *py_handle;
	if (object->in.handle == NULL) {
		Py_RETURN_NONE;
	}
	py_handle = pytalloc_reference_ex(policy_handle_Type, object->in.handle, object->in.handle);
	return py_handle;
}

static int py_winreg_UnLoadKey_in_set_handle(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winreg_UnLoadKey *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->in.handle));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.handle");
		return -1;
	}
	object->in.handle = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->in.handle);
	if (object->in.handle == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	PY_CHECK_TYPE(policy_handle_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->in.handle = (struct policy_handle *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_winreg_UnLoadKey_in_get_subkey(PyObject *obj, void *closure)
{
	struct winreg_UnLoadKey *object = pytalloc_get_ptr(obj);
	PyObject *py_subkey;
	if (object->in.subkey == NULL) {
		Py_RETURN_NONE;
	}
	py_subkey = pytalloc_reference_ex(&winreg_String_Type, object->in.subkey, object->in.subkey);
	return py_subkey;
}

static int py_winreg_UnLoadKey_in_set_subkey(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winreg_UnLoadKey *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->in.subkey));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.subkey");
		return -1;
	}
	object->in.subkey = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->in.subkey);
	if (object->in.subkey == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	PY_CHECK_TYPE(&winreg_String_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->in.subkey = (struct winreg_String *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_winreg_UnLoadKey_get_result(PyObject *obj, void *closure)
{
	struct winreg_UnLoadKey *object = pytalloc_get_ptr(obj);
	PyObject *py_result;
	py_result = PyErr_FromWERROR(object->out.result);
	return py_result;
}

static int py_winreg_UnLoadKey_set_result(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winreg_UnLoadKey *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->out.result");
		return -1;
	}
	object->out.result = W_ERROR(PyLong_AsLong(value));
	return 0;
}

static PyGetSetDef py_winreg_UnLoadKey_getsetters[] = {
	{
		.name = discard_const_p(char, "in_handle"),
		.get = py_winreg_UnLoadKey_in_get_handle,
		.set = py_winreg_UnLoadKey_in_set_handle,
		.doc = discard_const_p(char, "PIDL-generated element of base type policy_handle")
	},
	{
		.name = discard_const_p(char, "in_subkey"),
		.get = py_winreg_UnLoadKey_in_get_subkey,
		.set = py_winreg_UnLoadKey_in_set_subkey,
		.doc = discard_const_p(char, "PIDL-generated element of base type winreg_String")
	},
	{
		.name = discard_const_p(char, "result"),
		.get = py_winreg_UnLoadKey_get_result,
		.set = py_winreg_UnLoadKey_set_result,
		.doc = discard_const_p(char, "PIDL-generated element of type WERROR")
	},
	{ .name = NULL }
};

static PyObject *py_winreg_UnLoadKey_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyObject *self = pytalloc_new(struct winreg_UnLoadKey, type);
	struct winreg_UnLoadKey *_self = (struct winreg_UnLoadKey *)pytalloc_get_ptr(self);
	TALLOC_CTX *mem_ctx = pytalloc_get_mem_ctx(self);
	_self->in.handle = talloc_zero(mem_ctx, struct policy_handle);
	_self->in.subkey = talloc_zero(mem_ctx, struct winreg_String);
	return self;
}

static PyObject *py_winreg_UnLoadKey_ndr_opnum(PyTypeObject *type, PyObject *Py_UNUSED(ignored))
{


	return PyLong_FromLong(23);
}

static PyObject *py_winreg_UnLoadKey_ndr_pack(PyObject *py_obj, ndr_flags_type ndr_inout_flags, libndr_flags ndr_push_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct winreg_UnLoadKey *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	struct ndr_push *push = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;

	if (ndr_table_winreg.num_calls < 24) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_winreg_UnLoadKey_ndr_pack");
		return NULL;
	}
	call = &ndr_table_winreg.calls[23];

	push = ndr_push_init_ctx(pytalloc_get_mem_ctx(py_obj));
	if (push == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	push->flags |= ndr_push_flags;

	err = call->ndr_push(push, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(push);
		PyErr_SetNdrError(err);
		return NULL;
	}
	blob = ndr_push_blob(push);
	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(push);
	return ret;
}

static PyObject *py_winreg_UnLoadKey_ndr_pack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_in__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_winreg_UnLoadKey_ndr_pack(py_obj, NDR_IN, ndr_push_flags);
}

static PyObject *py_winreg_UnLoadKey_ndr_pack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_out__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_winreg_UnLoadKey_ndr_pack(py_obj, NDR_OUT, ndr_push_flags);
}

static PyObject *py_winreg_UnLoadKey_ndr_unpack(PyObject *py_obj, const DATA_BLOB *blob, ndr_flags_type ndr_inout_flags, libndr_flags ndr_pull_flags, bool allow_remaining)
{
	const struct ndr_interface_call *call = NULL;
	struct winreg_UnLoadKey *object = pytalloc_get_ptr(py_obj);
	struct ndr_pull *pull = NULL;
	enum ndr_err_code err;

	if (ndr_table_winreg.num_calls < 24) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_winreg_UnLoadKey_ndr_unpack");
		return NULL;
	}
	call = &ndr_table_winreg.calls[23];

	pull = ndr_pull_init_blob(blob, object);
	if (pull == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	pull->flags |= ndr_pull_flags;

	err = call->ndr_pull(pull, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(pull);
		PyErr_SetNdrError(err);
		return NULL;
	}
	if (!allow_remaining) {
		uint32_t highest_ofs;

		if (pull->offset > pull->relative_highest_offset) {
			highest_ofs = pull->offset;
		} else {
			highest_ofs = pull->relative_highest_offset;
		}
		if (highest_ofs < pull->data_size) {
			err = ndr_pull_error(pull, NDR_ERR_UNREAD_BYTES,
				"not all bytes consumed ofs[%u] size[%u]",
				highest_ofs, pull->data_size);
			TALLOC_FREE(pull);
			PyErr_SetNdrError(err);
			return NULL;
		}
	}

	TALLOC_FREE(pull);
	Py_RETURN_NONE;
}

static PyObject *py_winreg_UnLoadKey_ndr_unpack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_in__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_winreg_UnLoadKey_ndr_unpack(py_obj, &blob, NDR_IN, ndr_pull_flags, allow_remaining);
}

static PyObject *py_winreg_UnLoadKey_ndr_unpack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_out__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_winreg_UnLoadKey_ndr_unpack(py_obj, &blob, NDR_OUT, ndr_pull_flags, allow_remaining);
}

static PyObject *py_winreg_UnLoadKey_ndr_print(PyObject *py_obj, PyObject *args, PyObject *kwargs, const char *name, ndr_flags_type ndr_inout_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct winreg_UnLoadKey *object = pytalloc_get_ptr(py_obj);
	const char * const kwnames[] = { "print_secrets", NULL };
	PyObject *py_print_secrets = NULL;
	PyObject *ret;
	char *retstr;
	bool ok;

	ok = PyArg_ParseTupleAndKeywords(args, kwargs, "|O:__ndr_print__",
		discard_const_p(char *, kwnames),
		&py_print_secrets);
	if (!ok) {
		return NULL;
	}

	if (ndr_table_winreg.num_calls < 24) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_winreg_UnLoadKey_ndr_print");
		return NULL;
	}
	call = &ndr_table_winreg.calls[23];

	if (py_print_secrets != NULL && PyObject_IsTrue(py_print_secrets)) {
		retstr = ndr_print_function_secret_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	} else {
		retstr = ndr_print_function_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	}
	ret = PyUnicode_FromString(retstr);
	TALLOC_FREE(retstr);

	return ret;
}

static PyObject *py_winreg_UnLoadKey_ndr_print_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	return py_winreg_UnLoadKey_ndr_print(py_obj, args, kwargs, "winreg_UnLoadKey_in", NDR_IN);
}

static PyObject *py_winreg_UnLoadKey_ndr_print_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	return py_winreg_UnLoadKey_ndr_print(py_obj, args, kwargs, "winreg_UnLoadKey_out", NDR_OUT);
}

static PyMethodDef py_winreg_UnLoadKey_methods[] = {
	{ "opnum", (PyCFunction)py_winreg_UnLoadKey_ndr_opnum, METH_NOARGS|METH_CLASS,
		"winreg.UnLoadKey.opnum() -> 23 (0x17) " },
	{ "__ndr_pack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winreg_UnLoadKey_ndr_pack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_in(object, bigendian=False, ndr64=False) -> blob\nNDR pack input" },
	{ "__ndr_pack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winreg_UnLoadKey_ndr_pack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_out(object, bigendian=False, ndr64=False) -> blob\nNDR pack output" },
	{ "__ndr_unpack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winreg_UnLoadKey_ndr_unpack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_in(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack input" },
	{ "__ndr_unpack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winreg_UnLoadKey_ndr_unpack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_out(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack output" },
	{ "__ndr_print_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winreg_UnLoadKey_ndr_print_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_print_in(object, print_secrets=False) -> String\nNDR print input" },
	{ "__ndr_print_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winreg_UnLoadKey_ndr_print_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_print_out(object, print_secrets=False) -> String\nNDR print output" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject winreg_UnLoadKey_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "winreg.UnLoadKey",
	.tp_getset = py_winreg_UnLoadKey_getsetters,
	.tp_methods = py_winreg_UnLoadKey_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_winreg_UnLoadKey_new,
};

static bool pack_py_winreg_UnLoadKey_args_in(PyObject *args, PyObject *kwargs, struct winreg_UnLoadKey *r)
{
	PyObject *py_handle;
	PyObject *py_subkey;
	const char *kwnames[] = {
		"handle", "subkey", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OO:winreg_UnLoadKey", discard_const_p(char *, kwnames), &py_handle, &py_subkey)) {
		return false;
	}

	if (py_handle == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.handle");
		return false;
	}
	r->in.handle = talloc_ptrtype(r, r->in.handle);
	if (r->in.handle == NULL) {
		PyErr_NoMemory();
		return false;
	}
	PY_CHECK_TYPE(policy_handle_Type, py_handle, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_handle)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.handle = (struct policy_handle *)pytalloc_get_ptr(py_handle);
	if (py_subkey == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.subkey");
		return false;
	}
	r->in.subkey = talloc_ptrtype(r, r->in.subkey);
	if (r->in.subkey == NULL) {
		PyErr_NoMemory();
		return false;
	}
	PY_CHECK_TYPE(&winreg_String_Type, py_subkey, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_subkey)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.subkey = (struct winreg_String *)pytalloc_get_ptr(py_subkey);
	return true;
}

static PyObject *unpack_py_winreg_UnLoadKey_args_out(struct winreg_UnLoadKey *r, bool raise_result_exception)
{
	PyObject *result = NULL;
	size_t result_size = 0;

	if (raise_result_exception) {
		if (!W_ERROR_IS_OK(r->out.result)) {
			PyErr_SetWERROR(r->out.result);
			return NULL;
		}

	} else {
		/* WERROR will be part of the results */
		result_size += 1;
	}

	if (!raise_result_exception) {
		result = PyErr_FromWERROR(r->out.result);
	}

	if (result_size == 0) {
		result = Py_None;
		Py_INCREF(result);
	}

	return result;
}


static PyObject *py_winreg_InitiateSystemShutdown_in_get_hostname(PyObject *obj, void *closure)
{
	struct winreg_InitiateSystemShutdown *object = pytalloc_get_ptr(obj);
	PyObject *py_hostname;
	if (object->in.hostname == NULL) {
		Py_RETURN_NONE;
	}
	if (object->in.hostname == NULL) {
		py_hostname = Py_None;
		Py_INCREF(py_hostname);
	} else {
		py_hostname = PyLong_FromLong((uint16_t)(*object->in.hostname));
	}
	return py_hostname;
}

static int py_winreg_InitiateSystemShutdown_in_set_hostname(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winreg_InitiateSystemShutdown *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->in.hostname));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.hostname");
		return -1;
	}
	if (value == Py_None) {
		object->in.hostname = NULL;
	} else {
		object->in.hostname = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->in.hostname);
		if (object->in.hostname == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		{
			const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(*object->in.hostname));
			if (PyLong_Check(value)) {
				unsigned long long test_var;
				test_var = PyLong_AsUnsignedLongLong(value);
				if (PyErr_Occurred() != NULL) {
					return -1;
				}
				if (test_var > uint_max) {
					PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
					  PyLong_Type.tp_name, uint_max, test_var);
					return -1;
				}
				*object->in.hostname = test_var;
			} else {
				PyErr_Format(PyExc_TypeError, "Expected type %s",
				  PyLong_Type.tp_name);
				return -1;
			}
		}
	}
	return 0;
}

static PyObject *py_winreg_InitiateSystemShutdown_in_get_message(PyObject *obj, void *closure)
{
	struct winreg_InitiateSystemShutdown *object = pytalloc_get_ptr(obj);
	PyObject *py_message;
	if (object->in.message == NULL) {
		Py_RETURN_NONE;
	}
	if (object->in.message == NULL) {
		py_message = Py_None;
		Py_INCREF(py_message);
	} else {
		py_message = pytalloc_reference_ex(lsa_StringLarge_Type, object->in.message, object->in.message);
	}
	return py_message;
}

static int py_winreg_InitiateSystemShutdown_in_set_message(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winreg_InitiateSystemShutdown *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->in.message));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.message");
		return -1;
	}
	if (value == Py_None) {
		object->in.message = NULL;
	} else {
		object->in.message = NULL;
		PY_CHECK_TYPE(lsa_StringLarge_Type, value, return -1;);
		if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->in.message = (struct lsa_StringLarge *)pytalloc_get_ptr(value);
	}
	return 0;
}

static PyObject *py_winreg_InitiateSystemShutdown_in_get_timeout(PyObject *obj, void *closure)
{
	struct winreg_InitiateSystemShutdown *object = pytalloc_get_ptr(obj);
	PyObject *py_timeout;
	py_timeout = PyLong_FromUnsignedLongLong((uint32_t)(object->in.timeout));
	return py_timeout;
}

static int py_winreg_InitiateSystemShutdown_in_set_timeout(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winreg_InitiateSystemShutdown *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.timeout");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->in.timeout));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->in.timeout = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_winreg_InitiateSystemShutdown_in_get_force_apps(PyObject *obj, void *closure)
{
	struct winreg_InitiateSystemShutdown *object = pytalloc_get_ptr(obj);
	PyObject *py_force_apps;
	py_force_apps = PyLong_FromLong((uint16_t)(object->in.force_apps));
	return py_force_apps;
}

static int py_winreg_InitiateSystemShutdown_in_set_force_apps(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winreg_InitiateSystemShutdown *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.force_apps");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->in.force_apps));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->in.force_apps = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_winreg_InitiateSystemShutdown_in_get_do_reboot(PyObject *obj, void *closure)
{
	struct winreg_InitiateSystemShutdown *object = pytalloc_get_ptr(obj);
	PyObject *py_do_reboot;
	py_do_reboot = PyLong_FromLong((uint16_t)(object->in.do_reboot));
	return py_do_reboot;
}

static int py_winreg_InitiateSystemShutdown_in_set_do_reboot(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winreg_InitiateSystemShutdown *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.do_reboot");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->in.do_reboot));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->in.do_reboot = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_winreg_InitiateSystemShutdown_get_result(PyObject *obj, void *closure)
{
	struct winreg_InitiateSystemShutdown *object = pytalloc_get_ptr(obj);
	PyObject *py_result;
	py_result = PyErr_FromWERROR(object->out.result);
	return py_result;
}

static int py_winreg_InitiateSystemShutdown_set_result(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winreg_InitiateSystemShutdown *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->out.result");
		return -1;
	}
	object->out.result = W_ERROR(PyLong_AsLong(value));
	return 0;
}

static PyGetSetDef py_winreg_InitiateSystemShutdown_getsetters[] = {
	{
		.name = discard_const_p(char, "in_hostname"),
		.get = py_winreg_InitiateSystemShutdown_in_get_hostname,
		.set = py_winreg_InitiateSystemShutdown_in_set_hostname,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "in_message"),
		.get = py_winreg_InitiateSystemShutdown_in_get_message,
		.set = py_winreg_InitiateSystemShutdown_in_set_message,
		.doc = discard_const_p(char, "PIDL-generated element of base type lsa_StringLarge")
	},
	{
		.name = discard_const_p(char, "in_timeout"),
		.get = py_winreg_InitiateSystemShutdown_in_get_timeout,
		.set = py_winreg_InitiateSystemShutdown_in_set_timeout,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "in_force_apps"),
		.get = py_winreg_InitiateSystemShutdown_in_get_force_apps,
		.set = py_winreg_InitiateSystemShutdown_in_set_force_apps,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "in_do_reboot"),
		.get = py_winreg_InitiateSystemShutdown_in_get_do_reboot,
		.set = py_winreg_InitiateSystemShutdown_in_set_do_reboot,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "result"),
		.get = py_winreg_InitiateSystemShutdown_get_result,
		.set = py_winreg_InitiateSystemShutdown_set_result,
		.doc = discard_const_p(char, "PIDL-generated element of type WERROR")
	},
	{ .name = NULL }
};

static PyObject *py_winreg_InitiateSystemShutdown_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyObject *self = pytalloc_new(struct winreg_InitiateSystemShutdown, type);
	return self;
}

static PyObject *py_winreg_InitiateSystemShutdown_ndr_opnum(PyTypeObject *type, PyObject *Py_UNUSED(ignored))
{


	return PyLong_FromLong(24);
}

static PyObject *py_winreg_InitiateSystemShutdown_ndr_pack(PyObject *py_obj, ndr_flags_type ndr_inout_flags, libndr_flags ndr_push_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct winreg_InitiateSystemShutdown *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	struct ndr_push *push = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;

	if (ndr_table_winreg.num_calls < 25) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_winreg_InitiateSystemShutdown_ndr_pack");
		return NULL;
	}
	call = &ndr_table_winreg.calls[24];

	push = ndr_push_init_ctx(pytalloc_get_mem_ctx(py_obj));
	if (push == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	push->flags |= ndr_push_flags;

	err = call->ndr_push(push, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(push);
		PyErr_SetNdrError(err);
		return NULL;
	}
	blob = ndr_push_blob(push);
	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(push);
	return ret;
}

static PyObject *py_winreg_InitiateSystemShutdown_ndr_pack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_in__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_winreg_InitiateSystemShutdown_ndr_pack(py_obj, NDR_IN, ndr_push_flags);
}

static PyObject *py_winreg_InitiateSystemShutdown_ndr_pack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_out__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_winreg_InitiateSystemShutdown_ndr_pack(py_obj, NDR_OUT, ndr_push_flags);
}

static PyObject *py_winreg_InitiateSystemShutdown_ndr_unpack(PyObject *py_obj, const DATA_BLOB *blob, ndr_flags_type ndr_inout_flags, libndr_flags ndr_pull_flags, bool allow_remaining)
{
	const struct ndr_interface_call *call = NULL;
	struct winreg_InitiateSystemShutdown *object = pytalloc_get_ptr(py_obj);
	struct ndr_pull *pull = NULL;
	enum ndr_err_code err;

	if (ndr_table_winreg.num_calls < 25) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_winreg_InitiateSystemShutdown_ndr_unpack");
		return NULL;
	}
	call = &ndr_table_winreg.calls[24];

	pull = ndr_pull_init_blob(blob, object);
	if (pull == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	pull->flags |= ndr_pull_flags;

	err = call->ndr_pull(pull, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(pull);
		PyErr_SetNdrError(err);
		return NULL;
	}
	if (!allow_remaining) {
		uint32_t highest_ofs;

		if (pull->offset > pull->relative_highest_offset) {
			highest_ofs = pull->offset;
		} else {
			highest_ofs = pull->relative_highest_offset;
		}
		if (highest_ofs < pull->data_size) {
			err = ndr_pull_error(pull, NDR_ERR_UNREAD_BYTES,
				"not all bytes consumed ofs[%u] size[%u]",
				highest_ofs, pull->data_size);
			TALLOC_FREE(pull);
			PyErr_SetNdrError(err);
			return NULL;
		}
	}

	TALLOC_FREE(pull);
	Py_RETURN_NONE;
}

static PyObject *py_winreg_InitiateSystemShutdown_ndr_unpack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_in__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_winreg_InitiateSystemShutdown_ndr_unpack(py_obj, &blob, NDR_IN, ndr_pull_flags, allow_remaining);
}

static PyObject *py_winreg_InitiateSystemShutdown_ndr_unpack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_out__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_winreg_InitiateSystemShutdown_ndr_unpack(py_obj, &blob, NDR_OUT, ndr_pull_flags, allow_remaining);
}

static PyObject *py_winreg_InitiateSystemShutdown_ndr_print(PyObject *py_obj, PyObject *args, PyObject *kwargs, const char *name, ndr_flags_type ndr_inout_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct winreg_InitiateSystemShutdown *object = pytalloc_get_ptr(py_obj);
	const char * const kwnames[] = { "print_secrets", NULL };
	PyObject *py_print_secrets = NULL;
	PyObject *ret;
	char *retstr;
	bool ok;

	ok = PyArg_ParseTupleAndKeywords(args, kwargs, "|O:__ndr_print__",
		discard_const_p(char *, kwnames),
		&py_print_secrets);
	if (!ok) {
		return NULL;
	}

	if (ndr_table_winreg.num_calls < 25) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_winreg_InitiateSystemShutdown_ndr_print");
		return NULL;
	}
	call = &ndr_table_winreg.calls[24];

	if (py_print_secrets != NULL && PyObject_IsTrue(py_print_secrets)) {
		retstr = ndr_print_function_secret_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	} else {
		retstr = ndr_print_function_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	}
	ret = PyUnicode_FromString(retstr);
	TALLOC_FREE(retstr);

	return ret;
}

static PyObject *py_winreg_InitiateSystemShutdown_ndr_print_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	return py_winreg_InitiateSystemShutdown_ndr_print(py_obj, args, kwargs, "winreg_InitiateSystemShutdown_in", NDR_IN);
}

static PyObject *py_winreg_InitiateSystemShutdown_ndr_print_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	return py_winreg_InitiateSystemShutdown_ndr_print(py_obj, args, kwargs, "winreg_InitiateSystemShutdown_out", NDR_OUT);
}

static PyMethodDef py_winreg_InitiateSystemShutdown_methods[] = {
	{ "opnum", (PyCFunction)py_winreg_InitiateSystemShutdown_ndr_opnum, METH_NOARGS|METH_CLASS,
		"winreg.InitiateSystemShutdown.opnum() -> 24 (0x18) " },
	{ "__ndr_pack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winreg_InitiateSystemShutdown_ndr_pack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_in(object, bigendian=False, ndr64=False) -> blob\nNDR pack input" },
	{ "__ndr_pack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winreg_InitiateSystemShutdown_ndr_pack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_out(object, bigendian=False, ndr64=False) -> blob\nNDR pack output" },
	{ "__ndr_unpack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winreg_InitiateSystemShutdown_ndr_unpack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_in(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack input" },
	{ "__ndr_unpack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winreg_InitiateSystemShutdown_ndr_unpack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_out(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack output" },
	{ "__ndr_print_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winreg_InitiateSystemShutdown_ndr_print_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_print_in(object, print_secrets=False) -> String\nNDR print input" },
	{ "__ndr_print_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winreg_InitiateSystemShutdown_ndr_print_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_print_out(object, print_secrets=False) -> String\nNDR print output" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject winreg_InitiateSystemShutdown_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "winreg.InitiateSystemShutdown",
	.tp_getset = py_winreg_InitiateSystemShutdown_getsetters,
	.tp_methods = py_winreg_InitiateSystemShutdown_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_winreg_InitiateSystemShutdown_new,
};

static bool pack_py_winreg_InitiateSystemShutdown_args_in(PyObject *args, PyObject *kwargs, struct winreg_InitiateSystemShutdown *r)
{
	PyObject *py_hostname;
	PyObject *py_message;
	PyObject *py_timeout;
	PyObject *py_force_apps;
	PyObject *py_do_reboot;
	const char *kwnames[] = {
		"hostname", "message", "timeout", "force_apps", "do_reboot", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOOOO:winreg_InitiateSystemShutdown", discard_const_p(char *, kwnames), &py_hostname, &py_message, &py_timeout, &py_force_apps, &py_do_reboot)) {
		return false;
	}

	if (py_hostname == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.hostname");
		return false;
	}
	if (py_hostname == Py_None) {
		r->in.hostname = NULL;
	} else {
		r->in.hostname = talloc_ptrtype(r, r->in.hostname);
		if (r->in.hostname == NULL) {
			PyErr_NoMemory();
			return false;
		}
		{
			const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(*r->in.hostname));
			if (PyLong_Check(py_hostname)) {
				unsigned long long test_var;
				test_var = PyLong_AsUnsignedLongLong(py_hostname);
				if (PyErr_Occurred() != NULL) {
					return false;
				}
				if (test_var > uint_max) {
					PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
					  PyLong_Type.tp_name, uint_max, test_var);
					return false;
				}
				*r->in.hostname = test_var;
			} else {
				PyErr_Format(PyExc_TypeError, "Expected type %s",
				  PyLong_Type.tp_name);
				return false;
			}
		}
	}
	if (py_message == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.message");
		return false;
	}
	if (py_message == Py_None) {
		r->in.message = NULL;
	} else {
		r->in.message = NULL;
		PY_CHECK_TYPE(lsa_StringLarge_Type, py_message, return false;);
		if (talloc_reference(r, pytalloc_get_mem_ctx(py_message)) == NULL) {
			PyErr_NoMemory();
			return false;
		}
		r->in.message = (struct lsa_StringLarge *)pytalloc_get_ptr(py_message);
	}
	if (py_timeout == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.timeout");
		return false;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(r->in.timeout));
		if (PyLong_Check(py_timeout)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(py_timeout);
			if (PyErr_Occurred() != NULL) {
				return false;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return false;
			}
			r->in.timeout = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return false;
		}
	}
	if (py_force_apps == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.force_apps");
		return false;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(r->in.force_apps));
		if (PyLong_Check(py_force_apps)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(py_force_apps);
			if (PyErr_Occurred() != NULL) {
				return false;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return false;
			}
			r->in.force_apps = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return false;
		}
	}
	if (py_do_reboot == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.do_reboot");
		return false;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(r->in.do_reboot));
		if (PyLong_Check(py_do_reboot)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(py_do_reboot);
			if (PyErr_Occurred() != NULL) {
				return false;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return false;
			}
			r->in.do_reboot = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return false;
		}
	}
	return true;
}

static PyObject *unpack_py_winreg_InitiateSystemShutdown_args_out(struct winreg_InitiateSystemShutdown *r, bool raise_result_exception)
{
	PyObject *result = NULL;
	size_t result_size = 0;

	if (raise_result_exception) {
		if (!W_ERROR_IS_OK(r->out.result)) {
			PyErr_SetWERROR(r->out.result);
			return NULL;
		}

	} else {
		/* WERROR will be part of the results */
		result_size += 1;
	}

	if (!raise_result_exception) {
		result = PyErr_FromWERROR(r->out.result);
	}

	if (result_size == 0) {
		result = Py_None;
		Py_INCREF(result);
	}

	return result;
}


static PyObject *py_winreg_AbortSystemShutdown_in_get_server(PyObject *obj, void *closure)
{
	struct winreg_AbortSystemShutdown *object = pytalloc_get_ptr(obj);
	PyObject *py_server;
	if (object->in.server == NULL) {
		Py_RETURN_NONE;
	}
	if (object->in.server == NULL) {
		py_server = Py_None;
		Py_INCREF(py_server);
	} else {
		py_server = PyLong_FromLong((uint16_t)(*object->in.server));
	}
	return py_server;
}

static int py_winreg_AbortSystemShutdown_in_set_server(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winreg_AbortSystemShutdown *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->in.server));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.server");
		return -1;
	}
	if (value == Py_None) {
		object->in.server = NULL;
	} else {
		object->in.server = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->in.server);
		if (object->in.server == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		{
			const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(*object->in.server));
			if (PyLong_Check(value)) {
				unsigned long long test_var;
				test_var = PyLong_AsUnsignedLongLong(value);
				if (PyErr_Occurred() != NULL) {
					return -1;
				}
				if (test_var > uint_max) {
					PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
					  PyLong_Type.tp_name, uint_max, test_var);
					return -1;
				}
				*object->in.server = test_var;
			} else {
				PyErr_Format(PyExc_TypeError, "Expected type %s",
				  PyLong_Type.tp_name);
				return -1;
			}
		}
	}
	return 0;
}

static PyObject *py_winreg_AbortSystemShutdown_get_result(PyObject *obj, void *closure)
{
	struct winreg_AbortSystemShutdown *object = pytalloc_get_ptr(obj);
	PyObject *py_result;
	py_result = PyErr_FromWERROR(object->out.result);
	return py_result;
}

static int py_winreg_AbortSystemShutdown_set_result(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winreg_AbortSystemShutdown *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->out.result");
		return -1;
	}
	object->out.result = W_ERROR(PyLong_AsLong(value));
	return 0;
}

static PyGetSetDef py_winreg_AbortSystemShutdown_getsetters[] = {
	{
		.name = discard_const_p(char, "in_server"),
		.get = py_winreg_AbortSystemShutdown_in_get_server,
		.set = py_winreg_AbortSystemShutdown_in_set_server,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "result"),
		.get = py_winreg_AbortSystemShutdown_get_result,
		.set = py_winreg_AbortSystemShutdown_set_result,
		.doc = discard_const_p(char, "PIDL-generated element of type WERROR")
	},
	{ .name = NULL }
};

static PyObject *py_winreg_AbortSystemShutdown_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyObject *self = pytalloc_new(struct winreg_AbortSystemShutdown, type);
	return self;
}

static PyObject *py_winreg_AbortSystemShutdown_ndr_opnum(PyTypeObject *type, PyObject *Py_UNUSED(ignored))
{


	return PyLong_FromLong(25);
}

static PyObject *py_winreg_AbortSystemShutdown_ndr_pack(PyObject *py_obj, ndr_flags_type ndr_inout_flags, libndr_flags ndr_push_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct winreg_AbortSystemShutdown *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	struct ndr_push *push = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;

	if (ndr_table_winreg.num_calls < 26) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_winreg_AbortSystemShutdown_ndr_pack");
		return NULL;
	}
	call = &ndr_table_winreg.calls[25];

	push = ndr_push_init_ctx(pytalloc_get_mem_ctx(py_obj));
	if (push == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	push->flags |= ndr_push_flags;

	err = call->ndr_push(push, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(push);
		PyErr_SetNdrError(err);
		return NULL;
	}
	blob = ndr_push_blob(push);
	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(push);
	return ret;
}

static PyObject *py_winreg_AbortSystemShutdown_ndr_pack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_in__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_winreg_AbortSystemShutdown_ndr_pack(py_obj, NDR_IN, ndr_push_flags);
}

static PyObject *py_winreg_AbortSystemShutdown_ndr_pack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_out__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_winreg_AbortSystemShutdown_ndr_pack(py_obj, NDR_OUT, ndr_push_flags);
}

static PyObject *py_winreg_AbortSystemShutdown_ndr_unpack(PyObject *py_obj, const DATA_BLOB *blob, ndr_flags_type ndr_inout_flags, libndr_flags ndr_pull_flags, bool allow_remaining)
{
	const struct ndr_interface_call *call = NULL;
	struct winreg_AbortSystemShutdown *object = pytalloc_get_ptr(py_obj);
	struct ndr_pull *pull = NULL;
	enum ndr_err_code err;

	if (ndr_table_winreg.num_calls < 26) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_winreg_AbortSystemShutdown_ndr_unpack");
		return NULL;
	}
	call = &ndr_table_winreg.calls[25];

	pull = ndr_pull_init_blob(blob, object);
	if (pull == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	pull->flags |= ndr_pull_flags;

	err = call->ndr_pull(pull, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(pull);
		PyErr_SetNdrError(err);
		return NULL;
	}
	if (!allow_remaining) {
		uint32_t highest_ofs;

		if (pull->offset > pull->relative_highest_offset) {
			highest_ofs = pull->offset;
		} else {
			highest_ofs = pull->relative_highest_offset;
		}
		if (highest_ofs < pull->data_size) {
			err = ndr_pull_error(pull, NDR_ERR_UNREAD_BYTES,
				"not all bytes consumed ofs[%u] size[%u]",
				highest_ofs, pull->data_size);
			TALLOC_FREE(pull);
			PyErr_SetNdrError(err);
			return NULL;
		}
	}

	TALLOC_FREE(pull);
	Py_RETURN_NONE;
}

static PyObject *py_winreg_AbortSystemShutdown_ndr_unpack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_in__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_winreg_AbortSystemShutdown_ndr_unpack(py_obj, &blob, NDR_IN, ndr_pull_flags, allow_remaining);
}

static PyObject *py_winreg_AbortSystemShutdown_ndr_unpack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_out__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_winreg_AbortSystemShutdown_ndr_unpack(py_obj, &blob, NDR_OUT, ndr_pull_flags, allow_remaining);
}

static PyObject *py_winreg_AbortSystemShutdown_ndr_print(PyObject *py_obj, PyObject *args, PyObject *kwargs, const char *name, ndr_flags_type ndr_inout_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct winreg_AbortSystemShutdown *object = pytalloc_get_ptr(py_obj);
	const char * const kwnames[] = { "print_secrets", NULL };
	PyObject *py_print_secrets = NULL;
	PyObject *ret;
	char *retstr;
	bool ok;

	ok = PyArg_ParseTupleAndKeywords(args, kwargs, "|O:__ndr_print__",
		discard_const_p(char *, kwnames),
		&py_print_secrets);
	if (!ok) {
		return NULL;
	}

	if (ndr_table_winreg.num_calls < 26) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_winreg_AbortSystemShutdown_ndr_print");
		return NULL;
	}
	call = &ndr_table_winreg.calls[25];

	if (py_print_secrets != NULL && PyObject_IsTrue(py_print_secrets)) {
		retstr = ndr_print_function_secret_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	} else {
		retstr = ndr_print_function_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	}
	ret = PyUnicode_FromString(retstr);
	TALLOC_FREE(retstr);

	return ret;
}

static PyObject *py_winreg_AbortSystemShutdown_ndr_print_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	return py_winreg_AbortSystemShutdown_ndr_print(py_obj, args, kwargs, "winreg_AbortSystemShutdown_in", NDR_IN);
}

static PyObject *py_winreg_AbortSystemShutdown_ndr_print_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	return py_winreg_AbortSystemShutdown_ndr_print(py_obj, args, kwargs, "winreg_AbortSystemShutdown_out", NDR_OUT);
}

static PyMethodDef py_winreg_AbortSystemShutdown_methods[] = {
	{ "opnum", (PyCFunction)py_winreg_AbortSystemShutdown_ndr_opnum, METH_NOARGS|METH_CLASS,
		"winreg.AbortSystemShutdown.opnum() -> 25 (0x19) " },
	{ "__ndr_pack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winreg_AbortSystemShutdown_ndr_pack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_in(object, bigendian=False, ndr64=False) -> blob\nNDR pack input" },
	{ "__ndr_pack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winreg_AbortSystemShutdown_ndr_pack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_out(object, bigendian=False, ndr64=False) -> blob\nNDR pack output" },
	{ "__ndr_unpack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winreg_AbortSystemShutdown_ndr_unpack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_in(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack input" },
	{ "__ndr_unpack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winreg_AbortSystemShutdown_ndr_unpack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_out(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack output" },
	{ "__ndr_print_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winreg_AbortSystemShutdown_ndr_print_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_print_in(object, print_secrets=False) -> String\nNDR print input" },
	{ "__ndr_print_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winreg_AbortSystemShutdown_ndr_print_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_print_out(object, print_secrets=False) -> String\nNDR print output" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject winreg_AbortSystemShutdown_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "winreg.AbortSystemShutdown",
	.tp_getset = py_winreg_AbortSystemShutdown_getsetters,
	.tp_methods = py_winreg_AbortSystemShutdown_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_winreg_AbortSystemShutdown_new,
};

static bool pack_py_winreg_AbortSystemShutdown_args_in(PyObject *args, PyObject *kwargs, struct winreg_AbortSystemShutdown *r)
{
	PyObject *py_server;
	const char *kwnames[] = {
		"server", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "O:winreg_AbortSystemShutdown", discard_const_p(char *, kwnames), &py_server)) {
		return false;
	}

	if (py_server == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.server");
		return false;
	}
	if (py_server == Py_None) {
		r->in.server = NULL;
	} else {
		r->in.server = talloc_ptrtype(r, r->in.server);
		if (r->in.server == NULL) {
			PyErr_NoMemory();
			return false;
		}
		{
			const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(*r->in.server));
			if (PyLong_Check(py_server)) {
				unsigned long long test_var;
				test_var = PyLong_AsUnsignedLongLong(py_server);
				if (PyErr_Occurred() != NULL) {
					return false;
				}
				if (test_var > uint_max) {
					PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
					  PyLong_Type.tp_name, uint_max, test_var);
					return false;
				}
				*r->in.server = test_var;
			} else {
				PyErr_Format(PyExc_TypeError, "Expected type %s",
				  PyLong_Type.tp_name);
				return false;
			}
		}
	}
	return true;
}

static PyObject *unpack_py_winreg_AbortSystemShutdown_args_out(struct winreg_AbortSystemShutdown *r, bool raise_result_exception)
{
	PyObject *result = NULL;
	size_t result_size = 0;

	if (raise_result_exception) {
		if (!W_ERROR_IS_OK(r->out.result)) {
			PyErr_SetWERROR(r->out.result);
			return NULL;
		}

	} else {
		/* WERROR will be part of the results */
		result_size += 1;
	}

	if (!raise_result_exception) {
		result = PyErr_FromWERROR(r->out.result);
	}

	if (result_size == 0) {
		result = Py_None;
		Py_INCREF(result);
	}

	return result;
}


static PyObject *py_winreg_GetVersion_in_get_handle(PyObject *obj, void *closure)
{
	struct winreg_GetVersion *object = pytalloc_get_ptr(obj);
	PyObject *py_handle;
	if (object->in.handle == NULL) {
		Py_RETURN_NONE;
	}
	py_handle = pytalloc_reference_ex(policy_handle_Type, object->in.handle, object->in.handle);
	return py_handle;
}

static int py_winreg_GetVersion_in_set_handle(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winreg_GetVersion *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->in.handle));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.handle");
		return -1;
	}
	object->in.handle = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->in.handle);
	if (object->in.handle == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	PY_CHECK_TYPE(policy_handle_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->in.handle = (struct policy_handle *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_winreg_GetVersion_out_get_version(PyObject *obj, void *closure)
{
	struct winreg_GetVersion *object = pytalloc_get_ptr(obj);
	PyObject *py_version;
	if (object->out.version == NULL) {
		Py_RETURN_NONE;
	}
	py_version = PyLong_FromUnsignedLongLong((uint32_t)(*object->out.version));
	return py_version;
}

static int py_winreg_GetVersion_out_set_version(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winreg_GetVersion *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->out.version));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->out.version");
		return -1;
	}
	object->out.version = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->out.version);
	if (object->out.version == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(*object->out.version));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			*object->out.version = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_winreg_GetVersion_get_result(PyObject *obj, void *closure)
{
	struct winreg_GetVersion *object = pytalloc_get_ptr(obj);
	PyObject *py_result;
	py_result = PyErr_FromWERROR(object->out.result);
	return py_result;
}

static int py_winreg_GetVersion_set_result(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winreg_GetVersion *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->out.result");
		return -1;
	}
	object->out.result = W_ERROR(PyLong_AsLong(value));
	return 0;
}

static PyGetSetDef py_winreg_GetVersion_getsetters[] = {
	{
		.name = discard_const_p(char, "in_handle"),
		.get = py_winreg_GetVersion_in_get_handle,
		.set = py_winreg_GetVersion_in_set_handle,
		.doc = discard_const_p(char, "PIDL-generated element of base type policy_handle")
	},
	{
		.name = discard_const_p(char, "out_version"),
		.get = py_winreg_GetVersion_out_get_version,
		.set = py_winreg_GetVersion_out_set_version,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "result"),
		.get = py_winreg_GetVersion_get_result,
		.set = py_winreg_GetVersion_set_result,
		.doc = discard_const_p(char, "PIDL-generated element of type WERROR")
	},
	{ .name = NULL }
};

static PyObject *py_winreg_GetVersion_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyObject *self = pytalloc_new(struct winreg_GetVersion, type);
	struct winreg_GetVersion *_self = (struct winreg_GetVersion *)pytalloc_get_ptr(self);
	TALLOC_CTX *mem_ctx = pytalloc_get_mem_ctx(self);
	_self->in.handle = talloc_zero(mem_ctx, struct policy_handle);
	_self->out.version = talloc_zero(mem_ctx, uint32_t);
	return self;
}

static PyObject *py_winreg_GetVersion_ndr_opnum(PyTypeObject *type, PyObject *Py_UNUSED(ignored))
{


	return PyLong_FromLong(26);
}

static PyObject *py_winreg_GetVersion_ndr_pack(PyObject *py_obj, ndr_flags_type ndr_inout_flags, libndr_flags ndr_push_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct winreg_GetVersion *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	struct ndr_push *push = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;

	if (ndr_table_winreg.num_calls < 27) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_winreg_GetVersion_ndr_pack");
		return NULL;
	}
	call = &ndr_table_winreg.calls[26];

	push = ndr_push_init_ctx(pytalloc_get_mem_ctx(py_obj));
	if (push == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	push->flags |= ndr_push_flags;

	err = call->ndr_push(push, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(push);
		PyErr_SetNdrError(err);
		return NULL;
	}
	blob = ndr_push_blob(push);
	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(push);
	return ret;
}

static PyObject *py_winreg_GetVersion_ndr_pack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_in__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_winreg_GetVersion_ndr_pack(py_obj, NDR_IN, ndr_push_flags);
}

static PyObject *py_winreg_GetVersion_ndr_pack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_out__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_winreg_GetVersion_ndr_pack(py_obj, NDR_OUT, ndr_push_flags);
}

static PyObject *py_winreg_GetVersion_ndr_unpack(PyObject *py_obj, const DATA_BLOB *blob, ndr_flags_type ndr_inout_flags, libndr_flags ndr_pull_flags, bool allow_remaining)
{
	const struct ndr_interface_call *call = NULL;
	struct winreg_GetVersion *object = pytalloc_get_ptr(py_obj);
	struct ndr_pull *pull = NULL;
	enum ndr_err_code err;

	if (ndr_table_winreg.num_calls < 27) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_winreg_GetVersion_ndr_unpack");
		return NULL;
	}
	call = &ndr_table_winreg.calls[26];

	pull = ndr_pull_init_blob(blob, object);
	if (pull == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	pull->flags |= ndr_pull_flags;

	err = call->ndr_pull(pull, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(pull);
		PyErr_SetNdrError(err);
		return NULL;
	}
	if (!allow_remaining) {
		uint32_t highest_ofs;

		if (pull->offset > pull->relative_highest_offset) {
			highest_ofs = pull->offset;
		} else {
			highest_ofs = pull->relative_highest_offset;
		}
		if (highest_ofs < pull->data_size) {
			err = ndr_pull_error(pull, NDR_ERR_UNREAD_BYTES,
				"not all bytes consumed ofs[%u] size[%u]",
				highest_ofs, pull->data_size);
			TALLOC_FREE(pull);
			PyErr_SetNdrError(err);
			return NULL;
		}
	}

	TALLOC_FREE(pull);
	Py_RETURN_NONE;
}

static PyObject *py_winreg_GetVersion_ndr_unpack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_in__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_winreg_GetVersion_ndr_unpack(py_obj, &blob, NDR_IN, ndr_pull_flags, allow_remaining);
}

static PyObject *py_winreg_GetVersion_ndr_unpack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_out__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_winreg_GetVersion_ndr_unpack(py_obj, &blob, NDR_OUT, ndr_pull_flags, allow_remaining);
}

static PyObject *py_winreg_GetVersion_ndr_print(PyObject *py_obj, PyObject *args, PyObject *kwargs, const char *name, ndr_flags_type ndr_inout_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct winreg_GetVersion *object = pytalloc_get_ptr(py_obj);
	const char * const kwnames[] = { "print_secrets", NULL };
	PyObject *py_print_secrets = NULL;
	PyObject *ret;
	char *retstr;
	bool ok;

	ok = PyArg_ParseTupleAndKeywords(args, kwargs, "|O:__ndr_print__",
		discard_const_p(char *, kwnames),
		&py_print_secrets);
	if (!ok) {
		return NULL;
	}

	if (ndr_table_winreg.num_calls < 27) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_winreg_GetVersion_ndr_print");
		return NULL;
	}
	call = &ndr_table_winreg.calls[26];

	if (py_print_secrets != NULL && PyObject_IsTrue(py_print_secrets)) {
		retstr = ndr_print_function_secret_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	} else {
		retstr = ndr_print_function_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	}
	ret = PyUnicode_FromString(retstr);
	TALLOC_FREE(retstr);

	return ret;
}

static PyObject *py_winreg_GetVersion_ndr_print_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	return py_winreg_GetVersion_ndr_print(py_obj, args, kwargs, "winreg_GetVersion_in", NDR_IN);
}

static PyObject *py_winreg_GetVersion_ndr_print_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	return py_winreg_GetVersion_ndr_print(py_obj, args, kwargs, "winreg_GetVersion_out", NDR_OUT);
}

static PyMethodDef py_winreg_GetVersion_methods[] = {
	{ "opnum", (PyCFunction)py_winreg_GetVersion_ndr_opnum, METH_NOARGS|METH_CLASS,
		"winreg.GetVersion.opnum() -> 26 (0x1a) " },
	{ "__ndr_pack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winreg_GetVersion_ndr_pack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_in(object, bigendian=False, ndr64=False) -> blob\nNDR pack input" },
	{ "__ndr_pack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winreg_GetVersion_ndr_pack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_out(object, bigendian=False, ndr64=False) -> blob\nNDR pack output" },
	{ "__ndr_unpack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winreg_GetVersion_ndr_unpack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_in(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack input" },
	{ "__ndr_unpack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winreg_GetVersion_ndr_unpack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_out(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack output" },
	{ "__ndr_print_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winreg_GetVersion_ndr_print_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_print_in(object, print_secrets=False) -> String\nNDR print input" },
	{ "__ndr_print_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winreg_GetVersion_ndr_print_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_print_out(object, print_secrets=False) -> String\nNDR print output" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject winreg_GetVersion_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "winreg.GetVersion",
	.tp_getset = py_winreg_GetVersion_getsetters,
	.tp_methods = py_winreg_GetVersion_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_winreg_GetVersion_new,
};

static bool pack_py_winreg_GetVersion_args_in(PyObject *args, PyObject *kwargs, struct winreg_GetVersion *r)
{
	PyObject *py_handle;
	const char *kwnames[] = {
		"handle", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "O:winreg_GetVersion", discard_const_p(char *, kwnames), &py_handle)) {
		return false;
	}

	if (py_handle == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.handle");
		return false;
	}
	r->in.handle = talloc_ptrtype(r, r->in.handle);
	if (r->in.handle == NULL) {
		PyErr_NoMemory();
		return false;
	}
	PY_CHECK_TYPE(policy_handle_Type, py_handle, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_handle)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.handle = (struct policy_handle *)pytalloc_get_ptr(py_handle);
	return true;
}

static PyObject *unpack_py_winreg_GetVersion_args_out(struct winreg_GetVersion *r, bool raise_result_exception)
{
	PyObject *py_version = NULL;
	PyObject *result = NULL;
	size_t result_size = 1;

	if (raise_result_exception) {
		if (!W_ERROR_IS_OK(r->out.result)) {
			PyErr_SetWERROR(r->out.result);
			return NULL;
		}

	} else {
		/* WERROR will be part of the results */
		result_size += 1;
	}

	if (result_size > 1) {
		result = PyTuple_New(result_size);
		if (result == NULL) {
			return NULL;
		}
	}

	py_version = PyLong_FromUnsignedLongLong((uint32_t)(*r->out.version));
	if (result_size > 1) {
		PyTuple_SetItem(result, 0, py_version);
	}
	if (result_size == 1) {
		result = py_version;
	}

	if (!raise_result_exception) {
		PyTuple_SetItem(result, 1, PyErr_FromWERROR(r->out.result));
	}

	return result;
}


static PyObject *py_winreg_OpenHKCC_in_get_system_name(PyObject *obj, void *closure)
{
	struct winreg_OpenHKCC *object = pytalloc_get_ptr(obj);
	PyObject *py_system_name;
	if (object->in.system_name == NULL) {
		Py_RETURN_NONE;
	}
	if (object->in.system_name == NULL) {
		py_system_name = Py_None;
		Py_INCREF(py_system_name);
	} else {
		py_system_name = PyLong_FromLong((uint16_t)(*object->in.system_name));
	}
	return py_system_name;
}

static int py_winreg_OpenHKCC_in_set_system_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winreg_OpenHKCC *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->in.system_name));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.system_name");
		return -1;
	}
	if (value == Py_None) {
		object->in.system_name = NULL;
	} else {
		object->in.system_name = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->in.system_name);
		if (object->in.system_name == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		{
			const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(*object->in.system_name));
			if (PyLong_Check(value)) {
				unsigned long long test_var;
				test_var = PyLong_AsUnsignedLongLong(value);
				if (PyErr_Occurred() != NULL) {
					return -1;
				}
				if (test_var > uint_max) {
					PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
					  PyLong_Type.tp_name, uint_max, test_var);
					return -1;
				}
				*object->in.system_name = test_var;
			} else {
				PyErr_Format(PyExc_TypeError, "Expected type %s",
				  PyLong_Type.tp_name);
				return -1;
			}
		}
	}
	return 0;
}

static PyObject *py_winreg_OpenHKCC_in_get_access_mask(PyObject *obj, void *closure)
{
	struct winreg_OpenHKCC *object = pytalloc_get_ptr(obj);
	PyObject *py_access_mask;
	py_access_mask = PyLong_FromUnsignedLongLong((uint32_t)(object->in.access_mask));
	return py_access_mask;
}

static int py_winreg_OpenHKCC_in_set_access_mask(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winreg_OpenHKCC *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.access_mask");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->in.access_mask));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->in.access_mask = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_winreg_OpenHKCC_out_get_handle(PyObject *obj, void *closure)
{
	struct winreg_OpenHKCC *object = pytalloc_get_ptr(obj);
	PyObject *py_handle;
	if (object->out.handle == NULL) {
		Py_RETURN_NONE;
	}
	py_handle = pytalloc_reference_ex(policy_handle_Type, object->out.handle, object->out.handle);
	return py_handle;
}

static int py_winreg_OpenHKCC_out_set_handle(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winreg_OpenHKCC *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->out.handle));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->out.handle");
		return -1;
	}
	object->out.handle = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->out.handle);
	if (object->out.handle == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	PY_CHECK_TYPE(policy_handle_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->out.handle = (struct policy_handle *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_winreg_OpenHKCC_get_result(PyObject *obj, void *closure)
{
	struct winreg_OpenHKCC *object = pytalloc_get_ptr(obj);
	PyObject *py_result;
	py_result = PyErr_FromWERROR(object->out.result);
	return py_result;
}

static int py_winreg_OpenHKCC_set_result(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winreg_OpenHKCC *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->out.result");
		return -1;
	}
	object->out.result = W_ERROR(PyLong_AsLong(value));
	return 0;
}

static PyGetSetDef py_winreg_OpenHKCC_getsetters[] = {
	{
		.name = discard_const_p(char, "in_system_name"),
		.get = py_winreg_OpenHKCC_in_get_system_name,
		.set = py_winreg_OpenHKCC_in_set_system_name,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "in_access_mask"),
		.get = py_winreg_OpenHKCC_in_get_access_mask,
		.set = py_winreg_OpenHKCC_in_set_access_mask,
		.doc = discard_const_p(char, "PIDL-generated element of base type winreg_AccessMask")
	},
	{
		.name = discard_const_p(char, "out_handle"),
		.get = py_winreg_OpenHKCC_out_get_handle,
		.set = py_winreg_OpenHKCC_out_set_handle,
		.doc = discard_const_p(char, "PIDL-generated element of base type policy_handle")
	},
	{
		.name = discard_const_p(char, "result"),
		.get = py_winreg_OpenHKCC_get_result,
		.set = py_winreg_OpenHKCC_set_result,
		.doc = discard_const_p(char, "PIDL-generated element of type WERROR")
	},
	{ .name = NULL }
};

static PyObject *py_winreg_OpenHKCC_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyObject *self = pytalloc_new(struct winreg_OpenHKCC, type);
	struct winreg_OpenHKCC *_self = (struct winreg_OpenHKCC *)pytalloc_get_ptr(self);
	TALLOC_CTX *mem_ctx = pytalloc_get_mem_ctx(self);
	_self->out.handle = talloc_zero(mem_ctx, struct policy_handle);
	return self;
}

static PyObject *py_winreg_OpenHKCC_ndr_opnum(PyTypeObject *type, PyObject *Py_UNUSED(ignored))
{


	return PyLong_FromLong(27);
}

static PyObject *py_winreg_OpenHKCC_ndr_pack(PyObject *py_obj, ndr_flags_type ndr_inout_flags, libndr_flags ndr_push_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct winreg_OpenHKCC *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	struct ndr_push *push = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;

	if (ndr_table_winreg.num_calls < 28) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_winreg_OpenHKCC_ndr_pack");
		return NULL;
	}
	call = &ndr_table_winreg.calls[27];

	push = ndr_push_init_ctx(pytalloc_get_mem_ctx(py_obj));
	if (push == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	push->flags |= ndr_push_flags;

	err = call->ndr_push(push, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(push);
		PyErr_SetNdrError(err);
		return NULL;
	}
	blob = ndr_push_blob(push);
	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(push);
	return ret;
}

static PyObject *py_winreg_OpenHKCC_ndr_pack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_in__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_winreg_OpenHKCC_ndr_pack(py_obj, NDR_IN, ndr_push_flags);
}

static PyObject *py_winreg_OpenHKCC_ndr_pack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_out__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_winreg_OpenHKCC_ndr_pack(py_obj, NDR_OUT, ndr_push_flags);
}

static PyObject *py_winreg_OpenHKCC_ndr_unpack(PyObject *py_obj, const DATA_BLOB *blob, ndr_flags_type ndr_inout_flags, libndr_flags ndr_pull_flags, bool allow_remaining)
{
	const struct ndr_interface_call *call = NULL;
	struct winreg_OpenHKCC *object = pytalloc_get_ptr(py_obj);
	struct ndr_pull *pull = NULL;
	enum ndr_err_code err;

	if (ndr_table_winreg.num_calls < 28) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_winreg_OpenHKCC_ndr_unpack");
		return NULL;
	}
	call = &ndr_table_winreg.calls[27];

	pull = ndr_pull_init_blob(blob, object);
	if (pull == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	pull->flags |= ndr_pull_flags;

	err = call->ndr_pull(pull, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(pull);
		PyErr_SetNdrError(err);
		return NULL;
	}
	if (!allow_remaining) {
		uint32_t highest_ofs;

		if (pull->offset > pull->relative_highest_offset) {
			highest_ofs = pull->offset;
		} else {
			highest_ofs = pull->relative_highest_offset;
		}
		if (highest_ofs < pull->data_size) {
			err = ndr_pull_error(pull, NDR_ERR_UNREAD_BYTES,
				"not all bytes consumed ofs[%u] size[%u]",
				highest_ofs, pull->data_size);
			TALLOC_FREE(pull);
			PyErr_SetNdrError(err);
			return NULL;
		}
	}

	TALLOC_FREE(pull);
	Py_RETURN_NONE;
}

static PyObject *py_winreg_OpenHKCC_ndr_unpack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_in__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_winreg_OpenHKCC_ndr_unpack(py_obj, &blob, NDR_IN, ndr_pull_flags, allow_remaining);
}

static PyObject *py_winreg_OpenHKCC_ndr_unpack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_out__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_winreg_OpenHKCC_ndr_unpack(py_obj, &blob, NDR_OUT, ndr_pull_flags, allow_remaining);
}

static PyObject *py_winreg_OpenHKCC_ndr_print(PyObject *py_obj, PyObject *args, PyObject *kwargs, const char *name, ndr_flags_type ndr_inout_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct winreg_OpenHKCC *object = pytalloc_get_ptr(py_obj);
	const char * const kwnames[] = { "print_secrets", NULL };
	PyObject *py_print_secrets = NULL;
	PyObject *ret;
	char *retstr;
	bool ok;

	ok = PyArg_ParseTupleAndKeywords(args, kwargs, "|O:__ndr_print__",
		discard_const_p(char *, kwnames),
		&py_print_secrets);
	if (!ok) {
		return NULL;
	}

	if (ndr_table_winreg.num_calls < 28) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_winreg_OpenHKCC_ndr_print");
		return NULL;
	}
	call = &ndr_table_winreg.calls[27];

	if (py_print_secrets != NULL && PyObject_IsTrue(py_print_secrets)) {
		retstr = ndr_print_function_secret_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	} else {
		retstr = ndr_print_function_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	}
	ret = PyUnicode_FromString(retstr);
	TALLOC_FREE(retstr);

	return ret;
}

static PyObject *py_winreg_OpenHKCC_ndr_print_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	return py_winreg_OpenHKCC_ndr_print(py_obj, args, kwargs, "winreg_OpenHKCC_in", NDR_IN);
}

static PyObject *py_winreg_OpenHKCC_ndr_print_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	return py_winreg_OpenHKCC_ndr_print(py_obj, args, kwargs, "winreg_OpenHKCC_out", NDR_OUT);
}

static PyMethodDef py_winreg_OpenHKCC_methods[] = {
	{ "opnum", (PyCFunction)py_winreg_OpenHKCC_ndr_opnum, METH_NOARGS|METH_CLASS,
		"winreg.OpenHKCC.opnum() -> 27 (0x1b) " },
	{ "__ndr_pack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winreg_OpenHKCC_ndr_pack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_in(object, bigendian=False, ndr64=False) -> blob\nNDR pack input" },
	{ "__ndr_pack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winreg_OpenHKCC_ndr_pack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_out(object, bigendian=False, ndr64=False) -> blob\nNDR pack output" },
	{ "__ndr_unpack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winreg_OpenHKCC_ndr_unpack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_in(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack input" },
	{ "__ndr_unpack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winreg_OpenHKCC_ndr_unpack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_out(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack output" },
	{ "__ndr_print_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winreg_OpenHKCC_ndr_print_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_print_in(object, print_secrets=False) -> String\nNDR print input" },
	{ "__ndr_print_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winreg_OpenHKCC_ndr_print_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_print_out(object, print_secrets=False) -> String\nNDR print output" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject winreg_OpenHKCC_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "winreg.OpenHKCC",
	.tp_getset = py_winreg_OpenHKCC_getsetters,
	.tp_methods = py_winreg_OpenHKCC_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_winreg_OpenHKCC_new,
};

static bool pack_py_winreg_OpenHKCC_args_in(PyObject *args, PyObject *kwargs, struct winreg_OpenHKCC *r)
{
	PyObject *py_system_name;
	PyObject *py_access_mask;
	const char *kwnames[] = {
		"system_name", "access_mask", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OO:winreg_OpenHKCC", discard_const_p(char *, kwnames), &py_system_name, &py_access_mask)) {
		return false;
	}

	if (py_system_name == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.system_name");
		return false;
	}
	if (py_system_name == Py_None) {
		r->in.system_name = NULL;
	} else {
		r->in.system_name = talloc_ptrtype(r, r->in.system_name);
		if (r->in.system_name == NULL) {
			PyErr_NoMemory();
			return false;
		}
		{
			const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(*r->in.system_name));
			if (PyLong_Check(py_system_name)) {
				unsigned long long test_var;
				test_var = PyLong_AsUnsignedLongLong(py_system_name);
				if (PyErr_Occurred() != NULL) {
					return false;
				}
				if (test_var > uint_max) {
					PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
					  PyLong_Type.tp_name, uint_max, test_var);
					return false;
				}
				*r->in.system_name = test_var;
			} else {
				PyErr_Format(PyExc_TypeError, "Expected type %s",
				  PyLong_Type.tp_name);
				return false;
			}
		}
	}
	if (py_access_mask == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.access_mask");
		return false;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(r->in.access_mask));
		if (PyLong_Check(py_access_mask)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(py_access_mask);
			if (PyErr_Occurred() != NULL) {
				return false;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return false;
			}
			r->in.access_mask = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return false;
		}
	}
	return true;
}

static PyObject *unpack_py_winreg_OpenHKCC_args_out(struct winreg_OpenHKCC *r, bool raise_result_exception)
{
	PyObject *py_handle = NULL;
	PyObject *result = NULL;
	size_t result_size = 1;

	if (raise_result_exception) {
		if (!W_ERROR_IS_OK(r->out.result)) {
			PyErr_SetWERROR(r->out.result);
			return NULL;
		}

	} else {
		/* WERROR will be part of the results */
		result_size += 1;
	}

	if (result_size > 1) {
		result = PyTuple_New(result_size);
		if (result == NULL) {
			return NULL;
		}
	}

	py_handle = pytalloc_reference_ex(policy_handle_Type, r->out.handle, r->out.handle);
	if (result_size > 1) {
		PyTuple_SetItem(result, 0, py_handle);
	}
	if (result_size == 1) {
		result = py_handle;
	}

	if (!raise_result_exception) {
		PyTuple_SetItem(result, 1, PyErr_FromWERROR(r->out.result));
	}

	return result;
}


static PyObject *py_winreg_OpenHKDD_in_get_system_name(PyObject *obj, void *closure)
{
	struct winreg_OpenHKDD *object = pytalloc_get_ptr(obj);
	PyObject *py_system_name;
	if (object->in.system_name == NULL) {
		Py_RETURN_NONE;
	}
	if (object->in.system_name == NULL) {
		py_system_name = Py_None;
		Py_INCREF(py_system_name);
	} else {
		py_system_name = PyLong_FromLong((uint16_t)(*object->in.system_name));
	}
	return py_system_name;
}

static int py_winreg_OpenHKDD_in_set_system_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winreg_OpenHKDD *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->in.system_name));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.system_name");
		return -1;
	}
	if (value == Py_None) {
		object->in.system_name = NULL;
	} else {
		object->in.system_name = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->in.system_name);
		if (object->in.system_name == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		{
			const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(*object->in.system_name));
			if (PyLong_Check(value)) {
				unsigned long long test_var;
				test_var = PyLong_AsUnsignedLongLong(value);
				if (PyErr_Occurred() != NULL) {
					return -1;
				}
				if (test_var > uint_max) {
					PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
					  PyLong_Type.tp_name, uint_max, test_var);
					return -1;
				}
				*object->in.system_name = test_var;
			} else {
				PyErr_Format(PyExc_TypeError, "Expected type %s",
				  PyLong_Type.tp_name);
				return -1;
			}
		}
	}
	return 0;
}

static PyObject *py_winreg_OpenHKDD_in_get_access_mask(PyObject *obj, void *closure)
{
	struct winreg_OpenHKDD *object = pytalloc_get_ptr(obj);
	PyObject *py_access_mask;
	py_access_mask = PyLong_FromUnsignedLongLong((uint32_t)(object->in.access_mask));
	return py_access_mask;
}

static int py_winreg_OpenHKDD_in_set_access_mask(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winreg_OpenHKDD *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.access_mask");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->in.access_mask));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->in.access_mask = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_winreg_OpenHKDD_out_get_handle(PyObject *obj, void *closure)
{
	struct winreg_OpenHKDD *object = pytalloc_get_ptr(obj);
	PyObject *py_handle;
	if (object->out.handle == NULL) {
		Py_RETURN_NONE;
	}
	py_handle = pytalloc_reference_ex(policy_handle_Type, object->out.handle, object->out.handle);
	return py_handle;
}

static int py_winreg_OpenHKDD_out_set_handle(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winreg_OpenHKDD *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->out.handle));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->out.handle");
		return -1;
	}
	object->out.handle = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->out.handle);
	if (object->out.handle == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	PY_CHECK_TYPE(policy_handle_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->out.handle = (struct policy_handle *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_winreg_OpenHKDD_get_result(PyObject *obj, void *closure)
{
	struct winreg_OpenHKDD *object = pytalloc_get_ptr(obj);
	PyObject *py_result;
	py_result = PyErr_FromWERROR(object->out.result);
	return py_result;
}

static int py_winreg_OpenHKDD_set_result(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winreg_OpenHKDD *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->out.result");
		return -1;
	}
	object->out.result = W_ERROR(PyLong_AsLong(value));
	return 0;
}

static PyGetSetDef py_winreg_OpenHKDD_getsetters[] = {
	{
		.name = discard_const_p(char, "in_system_name"),
		.get = py_winreg_OpenHKDD_in_get_system_name,
		.set = py_winreg_OpenHKDD_in_set_system_name,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "in_access_mask"),
		.get = py_winreg_OpenHKDD_in_get_access_mask,
		.set = py_winreg_OpenHKDD_in_set_access_mask,
		.doc = discard_const_p(char, "PIDL-generated element of base type winreg_AccessMask")
	},
	{
		.name = discard_const_p(char, "out_handle"),
		.get = py_winreg_OpenHKDD_out_get_handle,
		.set = py_winreg_OpenHKDD_out_set_handle,
		.doc = discard_const_p(char, "PIDL-generated element of base type policy_handle")
	},
	{
		.name = discard_const_p(char, "result"),
		.get = py_winreg_OpenHKDD_get_result,
		.set = py_winreg_OpenHKDD_set_result,
		.doc = discard_const_p(char, "PIDL-generated element of type WERROR")
	},
	{ .name = NULL }
};

static PyObject *py_winreg_OpenHKDD_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyObject *self = pytalloc_new(struct winreg_OpenHKDD, type);
	struct winreg_OpenHKDD *_self = (struct winreg_OpenHKDD *)pytalloc_get_ptr(self);
	TALLOC_CTX *mem_ctx = pytalloc_get_mem_ctx(self);
	_self->out.handle = talloc_zero(mem_ctx, struct policy_handle);
	return self;
}

static PyObject *py_winreg_OpenHKDD_ndr_opnum(PyTypeObject *type, PyObject *Py_UNUSED(ignored))
{


	return PyLong_FromLong(28);
}

static PyObject *py_winreg_OpenHKDD_ndr_pack(PyObject *py_obj, ndr_flags_type ndr_inout_flags, libndr_flags ndr_push_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct winreg_OpenHKDD *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	struct ndr_push *push = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;

	if (ndr_table_winreg.num_calls < 29) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_winreg_OpenHKDD_ndr_pack");
		return NULL;
	}
	call = &ndr_table_winreg.calls[28];

	push = ndr_push_init_ctx(pytalloc_get_mem_ctx(py_obj));
	if (push == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	push->flags |= ndr_push_flags;

	err = call->ndr_push(push, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(push);
		PyErr_SetNdrError(err);
		return NULL;
	}
	blob = ndr_push_blob(push);
	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(push);
	return ret;
}

static PyObject *py_winreg_OpenHKDD_ndr_pack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_in__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_winreg_OpenHKDD_ndr_pack(py_obj, NDR_IN, ndr_push_flags);
}

static PyObject *py_winreg_OpenHKDD_ndr_pack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_out__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_winreg_OpenHKDD_ndr_pack(py_obj, NDR_OUT, ndr_push_flags);
}

static PyObject *py_winreg_OpenHKDD_ndr_unpack(PyObject *py_obj, const DATA_BLOB *blob, ndr_flags_type ndr_inout_flags, libndr_flags ndr_pull_flags, bool allow_remaining)
{
	const struct ndr_interface_call *call = NULL;
	struct winreg_OpenHKDD *object = pytalloc_get_ptr(py_obj);
	struct ndr_pull *pull = NULL;
	enum ndr_err_code err;

	if (ndr_table_winreg.num_calls < 29) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_winreg_OpenHKDD_ndr_unpack");
		return NULL;
	}
	call = &ndr_table_winreg.calls[28];

	pull = ndr_pull_init_blob(blob, object);
	if (pull == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	pull->flags |= ndr_pull_flags;

	err = call->ndr_pull(pull, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(pull);
		PyErr_SetNdrError(err);
		return NULL;
	}
	if (!allow_remaining) {
		uint32_t highest_ofs;

		if (pull->offset > pull->relative_highest_offset) {
			highest_ofs = pull->offset;
		} else {
			highest_ofs = pull->relative_highest_offset;
		}
		if (highest_ofs < pull->data_size) {
			err = ndr_pull_error(pull, NDR_ERR_UNREAD_BYTES,
				"not all bytes consumed ofs[%u] size[%u]",
				highest_ofs, pull->data_size);
			TALLOC_FREE(pull);
			PyErr_SetNdrError(err);
			return NULL;
		}
	}

	TALLOC_FREE(pull);
	Py_RETURN_NONE;
}

static PyObject *py_winreg_OpenHKDD_ndr_unpack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_in__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_winreg_OpenHKDD_ndr_unpack(py_obj, &blob, NDR_IN, ndr_pull_flags, allow_remaining);
}

static PyObject *py_winreg_OpenHKDD_ndr_unpack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_out__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_winreg_OpenHKDD_ndr_unpack(py_obj, &blob, NDR_OUT, ndr_pull_flags, allow_remaining);
}

static PyObject *py_winreg_OpenHKDD_ndr_print(PyObject *py_obj, PyObject *args, PyObject *kwargs, const char *name, ndr_flags_type ndr_inout_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct winreg_OpenHKDD *object = pytalloc_get_ptr(py_obj);
	const char * const kwnames[] = { "print_secrets", NULL };
	PyObject *py_print_secrets = NULL;
	PyObject *ret;
	char *retstr;
	bool ok;

	ok = PyArg_ParseTupleAndKeywords(args, kwargs, "|O:__ndr_print__",
		discard_const_p(char *, kwnames),
		&py_print_secrets);
	if (!ok) {
		return NULL;
	}

	if (ndr_table_winreg.num_calls < 29) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_winreg_OpenHKDD_ndr_print");
		return NULL;
	}
	call = &ndr_table_winreg.calls[28];

	if (py_print_secrets != NULL && PyObject_IsTrue(py_print_secrets)) {
		retstr = ndr_print_function_secret_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	} else {
		retstr = ndr_print_function_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	}
	ret = PyUnicode_FromString(retstr);
	TALLOC_FREE(retstr);

	return ret;
}

static PyObject *py_winreg_OpenHKDD_ndr_print_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	return py_winreg_OpenHKDD_ndr_print(py_obj, args, kwargs, "winreg_OpenHKDD_in", NDR_IN);
}

static PyObject *py_winreg_OpenHKDD_ndr_print_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	return py_winreg_OpenHKDD_ndr_print(py_obj, args, kwargs, "winreg_OpenHKDD_out", NDR_OUT);
}

static PyMethodDef py_winreg_OpenHKDD_methods[] = {
	{ "opnum", (PyCFunction)py_winreg_OpenHKDD_ndr_opnum, METH_NOARGS|METH_CLASS,
		"winreg.OpenHKDD.opnum() -> 28 (0x1c) " },
	{ "__ndr_pack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winreg_OpenHKDD_ndr_pack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_in(object, bigendian=False, ndr64=False) -> blob\nNDR pack input" },
	{ "__ndr_pack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winreg_OpenHKDD_ndr_pack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_out(object, bigendian=False, ndr64=False) -> blob\nNDR pack output" },
	{ "__ndr_unpack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winreg_OpenHKDD_ndr_unpack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_in(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack input" },
	{ "__ndr_unpack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winreg_OpenHKDD_ndr_unpack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_out(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack output" },
	{ "__ndr_print_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winreg_OpenHKDD_ndr_print_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_print_in(object, print_secrets=False) -> String\nNDR print input" },
	{ "__ndr_print_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winreg_OpenHKDD_ndr_print_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_print_out(object, print_secrets=False) -> String\nNDR print output" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject winreg_OpenHKDD_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "winreg.OpenHKDD",
	.tp_getset = py_winreg_OpenHKDD_getsetters,
	.tp_methods = py_winreg_OpenHKDD_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_winreg_OpenHKDD_new,
};

static bool pack_py_winreg_OpenHKDD_args_in(PyObject *args, PyObject *kwargs, struct winreg_OpenHKDD *r)
{
	PyObject *py_system_name;
	PyObject *py_access_mask;
	const char *kwnames[] = {
		"system_name", "access_mask", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OO:winreg_OpenHKDD", discard_const_p(char *, kwnames), &py_system_name, &py_access_mask)) {
		return false;
	}

	if (py_system_name == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.system_name");
		return false;
	}
	if (py_system_name == Py_None) {
		r->in.system_name = NULL;
	} else {
		r->in.system_name = talloc_ptrtype(r, r->in.system_name);
		if (r->in.system_name == NULL) {
			PyErr_NoMemory();
			return false;
		}
		{
			const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(*r->in.system_name));
			if (PyLong_Check(py_system_name)) {
				unsigned long long test_var;
				test_var = PyLong_AsUnsignedLongLong(py_system_name);
				if (PyErr_Occurred() != NULL) {
					return false;
				}
				if (test_var > uint_max) {
					PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
					  PyLong_Type.tp_name, uint_max, test_var);
					return false;
				}
				*r->in.system_name = test_var;
			} else {
				PyErr_Format(PyExc_TypeError, "Expected type %s",
				  PyLong_Type.tp_name);
				return false;
			}
		}
	}
	if (py_access_mask == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.access_mask");
		return false;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(r->in.access_mask));
		if (PyLong_Check(py_access_mask)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(py_access_mask);
			if (PyErr_Occurred() != NULL) {
				return false;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return false;
			}
			r->in.access_mask = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return false;
		}
	}
	return true;
}

static PyObject *unpack_py_winreg_OpenHKDD_args_out(struct winreg_OpenHKDD *r, bool raise_result_exception)
{
	PyObject *py_handle = NULL;
	PyObject *result = NULL;
	size_t result_size = 1;

	if (raise_result_exception) {
		if (!W_ERROR_IS_OK(r->out.result)) {
			PyErr_SetWERROR(r->out.result);
			return NULL;
		}

	} else {
		/* WERROR will be part of the results */
		result_size += 1;
	}

	if (result_size > 1) {
		result = PyTuple_New(result_size);
		if (result == NULL) {
			return NULL;
		}
	}

	py_handle = pytalloc_reference_ex(policy_handle_Type, r->out.handle, r->out.handle);
	if (result_size > 1) {
		PyTuple_SetItem(result, 0, py_handle);
	}
	if (result_size == 1) {
		result = py_handle;
	}

	if (!raise_result_exception) {
		PyTuple_SetItem(result, 1, PyErr_FromWERROR(r->out.result));
	}

	return result;
}


static PyObject *py_winreg_QueryMultipleValues_in_get_key_handle(PyObject *obj, void *closure)
{
	struct winreg_QueryMultipleValues *object = pytalloc_get_ptr(obj);
	PyObject *py_key_handle;
	if (object->in.key_handle == NULL) {
		Py_RETURN_NONE;
	}
	py_key_handle = pytalloc_reference_ex(policy_handle_Type, object->in.key_handle, object->in.key_handle);
	return py_key_handle;
}

static int py_winreg_QueryMultipleValues_in_set_key_handle(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winreg_QueryMultipleValues *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->in.key_handle));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.key_handle");
		return -1;
	}
	object->in.key_handle = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->in.key_handle);
	if (object->in.key_handle == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	PY_CHECK_TYPE(policy_handle_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->in.key_handle = (struct policy_handle *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_winreg_QueryMultipleValues_in_get_values_in(PyObject *obj, void *closure)
{
	struct winreg_QueryMultipleValues *object = pytalloc_get_ptr(obj);
	PyObject *py_values_in;
	if (object->in.values_in == NULL) {
		Py_RETURN_NONE;
	}
	py_values_in = PyList_New(object->in.num_values);
	if (py_values_in == NULL) {
		return NULL;
	}
	{
		int values_in_cntr_1;
		for (values_in_cntr_1 = 0; values_in_cntr_1 < (object->in.num_values); values_in_cntr_1++) {
			PyObject *py_values_in_1;
			py_values_in_1 = pytalloc_reference_ex(&QueryMultipleValue_Type, object->in.values_in, &(object->in.values_in)[values_in_cntr_1]);
			PyList_SetItem(py_values_in, values_in_cntr_1, py_values_in_1);
		}
	}
	return py_values_in;
}

static int py_winreg_QueryMultipleValues_in_set_values_in(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winreg_QueryMultipleValues *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->in.values_in));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.values_in");
		return -1;
	}
	object->in.values_in = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->in.values_in);
	if (object->in.values_in == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int values_in_cntr_1;
		object->in.values_in = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->in.values_in, PyList_GET_SIZE(value));
		if (!object->in.values_in) { return -1; }
		talloc_set_name_const(object->in.values_in, "ARRAY: object->in.values_in");
		for (values_in_cntr_1 = 0; values_in_cntr_1 < PyList_GET_SIZE(value); values_in_cntr_1++) {
			if (PyList_GET_ITEM(value, values_in_cntr_1) == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: (object->in.values_in)[values_in_cntr_1]");
				return -1;
			}
			PY_CHECK_TYPE(&QueryMultipleValue_Type, PyList_GET_ITEM(value, values_in_cntr_1), return -1;);
			if (talloc_reference(object->in.values_in, pytalloc_get_mem_ctx(PyList_GET_ITEM(value, values_in_cntr_1))) == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			(object->in.values_in)[values_in_cntr_1] = *(struct QueryMultipleValue *)pytalloc_get_ptr(PyList_GET_ITEM(value, values_in_cntr_1));
		}
	}
	return 0;
}

static PyObject *py_winreg_QueryMultipleValues_out_get_values_out(PyObject *obj, void *closure)
{
	struct winreg_QueryMultipleValues *object = pytalloc_get_ptr(obj);
	PyObject *py_values_out;
	if (object->out.values_out == NULL) {
		Py_RETURN_NONE;
	}
	py_values_out = PyList_New(object->in.num_values);
	if (py_values_out == NULL) {
		return NULL;
	}
	{
		int values_out_cntr_1;
		for (values_out_cntr_1 = 0; values_out_cntr_1 < (object->in.num_values); values_out_cntr_1++) {
			PyObject *py_values_out_1;
			py_values_out_1 = pytalloc_reference_ex(&QueryMultipleValue_Type, object->out.values_out, &(object->out.values_out)[values_out_cntr_1]);
			PyList_SetItem(py_values_out, values_out_cntr_1, py_values_out_1);
		}
	}
	return py_values_out;
}

static int py_winreg_QueryMultipleValues_out_set_values_out(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winreg_QueryMultipleValues *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->out.values_out));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->out.values_out");
		return -1;
	}
	object->out.values_out = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->out.values_out);
	if (object->out.values_out == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int values_out_cntr_1;
		object->out.values_out = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->out.values_out, PyList_GET_SIZE(value));
		if (!object->out.values_out) { return -1; }
		talloc_set_name_const(object->out.values_out, "ARRAY: object->out.values_out");
		for (values_out_cntr_1 = 0; values_out_cntr_1 < PyList_GET_SIZE(value); values_out_cntr_1++) {
			if (PyList_GET_ITEM(value, values_out_cntr_1) == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: (object->out.values_out)[values_out_cntr_1]");
				return -1;
			}
			PY_CHECK_TYPE(&QueryMultipleValue_Type, PyList_GET_ITEM(value, values_out_cntr_1), return -1;);
			if (talloc_reference(object->out.values_out, pytalloc_get_mem_ctx(PyList_GET_ITEM(value, values_out_cntr_1))) == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			(object->out.values_out)[values_out_cntr_1] = *(struct QueryMultipleValue *)pytalloc_get_ptr(PyList_GET_ITEM(value, values_out_cntr_1));
		}
	}
	return 0;
}

static PyObject *py_winreg_QueryMultipleValues_in_get_num_values(PyObject *obj, void *closure)
{
	struct winreg_QueryMultipleValues *object = pytalloc_get_ptr(obj);
	PyObject *py_num_values;
	py_num_values = PyLong_FromUnsignedLongLong((uint32_t)(object->in.num_values));
	return py_num_values;
}

static int py_winreg_QueryMultipleValues_in_set_num_values(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winreg_QueryMultipleValues *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.num_values");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->in.num_values));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->in.num_values = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_winreg_QueryMultipleValues_in_get_buffer(PyObject *obj, void *closure)
{
	struct winreg_QueryMultipleValues *object = pytalloc_get_ptr(obj);
	PyObject *py_buffer;
	if (object->in.buffer == NULL) {
		Py_RETURN_NONE;
	}
	if (object->in.buffer == NULL) {
		py_buffer = Py_None;
		Py_INCREF(py_buffer);
	} else {
		py_buffer = PyList_New(*object->in.buffer_size);
		if (py_buffer == NULL) {
			return NULL;
		}
		{
			int buffer_cntr_1;
			for (buffer_cntr_1 = 0; buffer_cntr_1 < (*object->in.buffer_size); buffer_cntr_1++) {
				PyObject *py_buffer_1;
				py_buffer_1 = PyLong_FromLong((uint16_t)((object->in.buffer)[buffer_cntr_1]));
				PyList_SetItem(py_buffer, buffer_cntr_1, py_buffer_1);
			}
		}
	}
	return py_buffer;
}

static int py_winreg_QueryMultipleValues_in_set_buffer(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winreg_QueryMultipleValues *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->in.buffer));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.buffer");
		return -1;
	}
	if (value == Py_None) {
		object->in.buffer = NULL;
	} else {
		object->in.buffer = NULL;
		PY_CHECK_TYPE(&PyList_Type, value, return -1;);
		{
			int buffer_cntr_1;
			object->in.buffer = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->in.buffer, PyList_GET_SIZE(value));
			if (!object->in.buffer) { return -1; }
			talloc_set_name_const(object->in.buffer, "ARRAY: object->in.buffer");
			for (buffer_cntr_1 = 0; buffer_cntr_1 < PyList_GET_SIZE(value); buffer_cntr_1++) {
				if (PyList_GET_ITEM(value, buffer_cntr_1) == NULL) {
					PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: (object->in.buffer)[buffer_cntr_1]");
					return -1;
				}
				{
					const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof((object->in.buffer)[buffer_cntr_1]));
					if (PyLong_Check(PyList_GET_ITEM(value, buffer_cntr_1))) {
						unsigned long long test_var;
						test_var = PyLong_AsUnsignedLongLong(PyList_GET_ITEM(value, buffer_cntr_1));
						if (PyErr_Occurred() != NULL) {
							return -1;
						}
						if (test_var > uint_max) {
							PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
							  PyLong_Type.tp_name, uint_max, test_var);
							return -1;
						}
						(object->in.buffer)[buffer_cntr_1] = test_var;
					} else {
						PyErr_Format(PyExc_TypeError, "Expected type %s",
						  PyLong_Type.tp_name);
						return -1;
					}
				}
			}
		}
	}
	return 0;
}

static PyObject *py_winreg_QueryMultipleValues_out_get_buffer(PyObject *obj, void *closure)
{
	struct winreg_QueryMultipleValues *object = pytalloc_get_ptr(obj);
	PyObject *py_buffer;
	if (object->out.buffer == NULL) {
		Py_RETURN_NONE;
	}
	if (object->out.buffer == NULL) {
		py_buffer = Py_None;
		Py_INCREF(py_buffer);
	} else {
		py_buffer = PyList_New(*object->out.buffer_size);
		if (py_buffer == NULL) {
			return NULL;
		}
		{
			int buffer_cntr_1;
			for (buffer_cntr_1 = 0; buffer_cntr_1 < (*object->out.buffer_size); buffer_cntr_1++) {
				PyObject *py_buffer_1;
				py_buffer_1 = PyLong_FromLong((uint16_t)((object->out.buffer)[buffer_cntr_1]));
				PyList_SetItem(py_buffer, buffer_cntr_1, py_buffer_1);
			}
		}
	}
	return py_buffer;
}

static int py_winreg_QueryMultipleValues_out_set_buffer(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winreg_QueryMultipleValues *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->out.buffer));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->out.buffer");
		return -1;
	}
	if (value == Py_None) {
		object->out.buffer = NULL;
	} else {
		object->out.buffer = NULL;
		PY_CHECK_TYPE(&PyList_Type, value, return -1;);
		{
			int buffer_cntr_1;
			object->out.buffer = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->out.buffer, PyList_GET_SIZE(value));
			if (!object->out.buffer) { return -1; }
			talloc_set_name_const(object->out.buffer, "ARRAY: object->out.buffer");
			for (buffer_cntr_1 = 0; buffer_cntr_1 < PyList_GET_SIZE(value); buffer_cntr_1++) {
				if (PyList_GET_ITEM(value, buffer_cntr_1) == NULL) {
					PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: (object->out.buffer)[buffer_cntr_1]");
					return -1;
				}
				{
					const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof((object->out.buffer)[buffer_cntr_1]));
					if (PyLong_Check(PyList_GET_ITEM(value, buffer_cntr_1))) {
						unsigned long long test_var;
						test_var = PyLong_AsUnsignedLongLong(PyList_GET_ITEM(value, buffer_cntr_1));
						if (PyErr_Occurred() != NULL) {
							return -1;
						}
						if (test_var > uint_max) {
							PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
							  PyLong_Type.tp_name, uint_max, test_var);
							return -1;
						}
						(object->out.buffer)[buffer_cntr_1] = test_var;
					} else {
						PyErr_Format(PyExc_TypeError, "Expected type %s",
						  PyLong_Type.tp_name);
						return -1;
					}
				}
			}
		}
	}
	return 0;
}

static PyObject *py_winreg_QueryMultipleValues_in_get_buffer_size(PyObject *obj, void *closure)
{
	struct winreg_QueryMultipleValues *object = pytalloc_get_ptr(obj);
	PyObject *py_buffer_size;
	if (object->in.buffer_size == NULL) {
		Py_RETURN_NONE;
	}
	py_buffer_size = PyLong_FromUnsignedLongLong((uint32_t)(*object->in.buffer_size));
	return py_buffer_size;
}

static int py_winreg_QueryMultipleValues_in_set_buffer_size(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winreg_QueryMultipleValues *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->in.buffer_size));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.buffer_size");
		return -1;
	}
	object->in.buffer_size = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->in.buffer_size);
	if (object->in.buffer_size == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(*object->in.buffer_size));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			*object->in.buffer_size = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_winreg_QueryMultipleValues_out_get_buffer_size(PyObject *obj, void *closure)
{
	struct winreg_QueryMultipleValues *object = pytalloc_get_ptr(obj);
	PyObject *py_buffer_size;
	if (object->out.buffer_size == NULL) {
		Py_RETURN_NONE;
	}
	py_buffer_size = PyLong_FromUnsignedLongLong((uint32_t)(*object->out.buffer_size));
	return py_buffer_size;
}

static int py_winreg_QueryMultipleValues_out_set_buffer_size(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winreg_QueryMultipleValues *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->out.buffer_size));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->out.buffer_size");
		return -1;
	}
	object->out.buffer_size = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->out.buffer_size);
	if (object->out.buffer_size == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(*object->out.buffer_size));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			*object->out.buffer_size = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_winreg_QueryMultipleValues_get_result(PyObject *obj, void *closure)
{
	struct winreg_QueryMultipleValues *object = pytalloc_get_ptr(obj);
	PyObject *py_result;
	py_result = PyErr_FromWERROR(object->out.result);
	return py_result;
}

static int py_winreg_QueryMultipleValues_set_result(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winreg_QueryMultipleValues *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->out.result");
		return -1;
	}
	object->out.result = W_ERROR(PyLong_AsLong(value));
	return 0;
}

static PyGetSetDef py_winreg_QueryMultipleValues_getsetters[] = {
	{
		.name = discard_const_p(char, "in_key_handle"),
		.get = py_winreg_QueryMultipleValues_in_get_key_handle,
		.set = py_winreg_QueryMultipleValues_in_set_key_handle,
		.doc = discard_const_p(char, "PIDL-generated element of base type policy_handle")
	},
	{
		.name = discard_const_p(char, "in_values_in"),
		.get = py_winreg_QueryMultipleValues_in_get_values_in,
		.set = py_winreg_QueryMultipleValues_in_set_values_in,
		.doc = discard_const_p(char, "PIDL-generated element of base type QueryMultipleValue")
	},
	{
		.name = discard_const_p(char, "out_values_out"),
		.get = py_winreg_QueryMultipleValues_out_get_values_out,
		.set = py_winreg_QueryMultipleValues_out_set_values_out,
		.doc = discard_const_p(char, "PIDL-generated element of base type QueryMultipleValue")
	},
	{
		.name = discard_const_p(char, "in_num_values"),
		.get = py_winreg_QueryMultipleValues_in_get_num_values,
		.set = py_winreg_QueryMultipleValues_in_set_num_values,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "in_buffer"),
		.get = py_winreg_QueryMultipleValues_in_get_buffer,
		.set = py_winreg_QueryMultipleValues_in_set_buffer,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "out_buffer"),
		.get = py_winreg_QueryMultipleValues_out_get_buffer,
		.set = py_winreg_QueryMultipleValues_out_set_buffer,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "in_buffer_size"),
		.get = py_winreg_QueryMultipleValues_in_get_buffer_size,
		.set = py_winreg_QueryMultipleValues_in_set_buffer_size,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "out_buffer_size"),
		.get = py_winreg_QueryMultipleValues_out_get_buffer_size,
		.set = py_winreg_QueryMultipleValues_out_set_buffer_size,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "result"),
		.get = py_winreg_QueryMultipleValues_get_result,
		.set = py_winreg_QueryMultipleValues_set_result,
		.doc = discard_const_p(char, "PIDL-generated element of type WERROR")
	},
	{ .name = NULL }
};

static PyObject *py_winreg_QueryMultipleValues_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyObject *self = pytalloc_new(struct winreg_QueryMultipleValues, type);
	struct winreg_QueryMultipleValues *_self = (struct winreg_QueryMultipleValues *)pytalloc_get_ptr(self);
	TALLOC_CTX *mem_ctx = pytalloc_get_mem_ctx(self);
	_self->in.key_handle = talloc_zero(mem_ctx, struct policy_handle);
	_self->in.values_in = talloc_zero(mem_ctx, struct QueryMultipleValue);
	_self->out.values_out = talloc_zero(mem_ctx, struct QueryMultipleValue);
	_self->in.buffer_size = talloc_zero(mem_ctx, uint32_t);
	_self->out.buffer_size = talloc_zero(mem_ctx, uint32_t);
	return self;
}

static PyObject *py_winreg_QueryMultipleValues_ndr_opnum(PyTypeObject *type, PyObject *Py_UNUSED(ignored))
{


	return PyLong_FromLong(29);
}

static PyObject *py_winreg_QueryMultipleValues_ndr_pack(PyObject *py_obj, ndr_flags_type ndr_inout_flags, libndr_flags ndr_push_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct winreg_QueryMultipleValues *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	struct ndr_push *push = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;

	if (ndr_table_winreg.num_calls < 30) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_winreg_QueryMultipleValues_ndr_pack");
		return NULL;
	}
	call = &ndr_table_winreg.calls[29];

	push = ndr_push_init_ctx(pytalloc_get_mem_ctx(py_obj));
	if (push == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	push->flags |= ndr_push_flags;

	err = call->ndr_push(push, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(push);
		PyErr_SetNdrError(err);
		return NULL;
	}
	blob = ndr_push_blob(push);
	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(push);
	return ret;
}

static PyObject *py_winreg_QueryMultipleValues_ndr_pack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_in__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_winreg_QueryMultipleValues_ndr_pack(py_obj, NDR_IN, ndr_push_flags);
}

static PyObject *py_winreg_QueryMultipleValues_ndr_pack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_out__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_winreg_QueryMultipleValues_ndr_pack(py_obj, NDR_OUT, ndr_push_flags);
}

static PyObject *py_winreg_QueryMultipleValues_ndr_unpack(PyObject *py_obj, const DATA_BLOB *blob, ndr_flags_type ndr_inout_flags, libndr_flags ndr_pull_flags, bool allow_remaining)
{
	const struct ndr_interface_call *call = NULL;
	struct winreg_QueryMultipleValues *object = pytalloc_get_ptr(py_obj);
	struct ndr_pull *pull = NULL;
	enum ndr_err_code err;

	if (ndr_table_winreg.num_calls < 30) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_winreg_QueryMultipleValues_ndr_unpack");
		return NULL;
	}
	call = &ndr_table_winreg.calls[29];

	pull = ndr_pull_init_blob(blob, object);
	if (pull == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	pull->flags |= ndr_pull_flags;

	err = call->ndr_pull(pull, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(pull);
		PyErr_SetNdrError(err);
		return NULL;
	}
	if (!allow_remaining) {
		uint32_t highest_ofs;

		if (pull->offset > pull->relative_highest_offset) {
			highest_ofs = pull->offset;
		} else {
			highest_ofs = pull->relative_highest_offset;
		}
		if (highest_ofs < pull->data_size) {
			err = ndr_pull_error(pull, NDR_ERR_UNREAD_BYTES,
				"not all bytes consumed ofs[%u] size[%u]",
				highest_ofs, pull->data_size);
			TALLOC_FREE(pull);
			PyErr_SetNdrError(err);
			return NULL;
		}
	}

	TALLOC_FREE(pull);
	Py_RETURN_NONE;
}

static PyObject *py_winreg_QueryMultipleValues_ndr_unpack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_in__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_winreg_QueryMultipleValues_ndr_unpack(py_obj, &blob, NDR_IN, ndr_pull_flags, allow_remaining);
}

static PyObject *py_winreg_QueryMultipleValues_ndr_unpack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_out__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_winreg_QueryMultipleValues_ndr_unpack(py_obj, &blob, NDR_OUT, ndr_pull_flags, allow_remaining);
}

static PyObject *py_winreg_QueryMultipleValues_ndr_print(PyObject *py_obj, PyObject *args, PyObject *kwargs, const char *name, ndr_flags_type ndr_inout_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct winreg_QueryMultipleValues *object = pytalloc_get_ptr(py_obj);
	const char * const kwnames[] = { "print_secrets", NULL };
	PyObject *py_print_secrets = NULL;
	PyObject *ret;
	char *retstr;
	bool ok;

	ok = PyArg_ParseTupleAndKeywords(args, kwargs, "|O:__ndr_print__",
		discard_const_p(char *, kwnames),
		&py_print_secrets);
	if (!ok) {
		return NULL;
	}

	if (ndr_table_winreg.num_calls < 30) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_winreg_QueryMultipleValues_ndr_print");
		return NULL;
	}
	call = &ndr_table_winreg.calls[29];

	if (py_print_secrets != NULL && PyObject_IsTrue(py_print_secrets)) {
		retstr = ndr_print_function_secret_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	} else {
		retstr = ndr_print_function_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	}
	ret = PyUnicode_FromString(retstr);
	TALLOC_FREE(retstr);

	return ret;
}

static PyObject *py_winreg_QueryMultipleValues_ndr_print_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	return py_winreg_QueryMultipleValues_ndr_print(py_obj, args, kwargs, "winreg_QueryMultipleValues_in", NDR_IN);
}

static PyObject *py_winreg_QueryMultipleValues_ndr_print_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	return py_winreg_QueryMultipleValues_ndr_print(py_obj, args, kwargs, "winreg_QueryMultipleValues_out", NDR_OUT);
}

static PyMethodDef py_winreg_QueryMultipleValues_methods[] = {
	{ "opnum", (PyCFunction)py_winreg_QueryMultipleValues_ndr_opnum, METH_NOARGS|METH_CLASS,
		"winreg.QueryMultipleValues.opnum() -> 29 (0x1d) " },
	{ "__ndr_pack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winreg_QueryMultipleValues_ndr_pack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_in(object, bigendian=False, ndr64=False) -> blob\nNDR pack input" },
	{ "__ndr_pack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winreg_QueryMultipleValues_ndr_pack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_out(object, bigendian=False, ndr64=False) -> blob\nNDR pack output" },
	{ "__ndr_unpack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winreg_QueryMultipleValues_ndr_unpack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_in(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack input" },
	{ "__ndr_unpack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winreg_QueryMultipleValues_ndr_unpack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_out(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack output" },
	{ "__ndr_print_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winreg_QueryMultipleValues_ndr_print_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_print_in(object, print_secrets=False) -> String\nNDR print input" },
	{ "__ndr_print_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winreg_QueryMultipleValues_ndr_print_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_print_out(object, print_secrets=False) -> String\nNDR print output" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject winreg_QueryMultipleValues_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "winreg.QueryMultipleValues",
	.tp_getset = py_winreg_QueryMultipleValues_getsetters,
	.tp_methods = py_winreg_QueryMultipleValues_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_winreg_QueryMultipleValues_new,
};

static bool pack_py_winreg_QueryMultipleValues_args_in(PyObject *args, PyObject *kwargs, struct winreg_QueryMultipleValues *r)
{
	PyObject *py_key_handle;
	PyObject *py_values_in;
	PyObject *py_buffer;
	const char *kwnames[] = {
		"key_handle", "values_in", "buffer", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOO:winreg_QueryMultipleValues", discard_const_p(char *, kwnames), &py_key_handle, &py_values_in, &py_buffer)) {
		return false;
	}

	if (py_key_handle == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.key_handle");
		return false;
	}
	r->in.key_handle = talloc_ptrtype(r, r->in.key_handle);
	if (r->in.key_handle == NULL) {
		PyErr_NoMemory();
		return false;
	}
	PY_CHECK_TYPE(policy_handle_Type, py_key_handle, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_key_handle)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.key_handle = (struct policy_handle *)pytalloc_get_ptr(py_key_handle);
	if (py_values_in == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.values_in");
		return false;
	}
	r->in.values_in = talloc_ptrtype(r, r->in.values_in);
	if (r->in.values_in == NULL) {
		PyErr_NoMemory();
		return false;
	}
	PY_CHECK_TYPE(&PyList_Type, py_values_in, return false;);
	{
		int values_in_cntr_1;
		r->in.values_in = talloc_array_ptrtype(r, r->in.values_in, PyList_GET_SIZE(py_values_in));
		if (!r->in.values_in) { return false; }
		talloc_set_name_const(r->in.values_in, "ARRAY: r->in.values_in");
		for (values_in_cntr_1 = 0; values_in_cntr_1 < PyList_GET_SIZE(py_values_in); values_in_cntr_1++) {
			if (PyList_GET_ITEM(py_values_in, values_in_cntr_1) == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: (r->in.values_in)[values_in_cntr_1]");
				return false;
			}
			PY_CHECK_TYPE(&QueryMultipleValue_Type, PyList_GET_ITEM(py_values_in, values_in_cntr_1), return false;);
			if (talloc_reference(r->in.values_in, pytalloc_get_mem_ctx(PyList_GET_ITEM(py_values_in, values_in_cntr_1))) == NULL) {
				PyErr_NoMemory();
				return false;
			}
			(r->in.values_in)[values_in_cntr_1] = *(struct QueryMultipleValue *)pytalloc_get_ptr(PyList_GET_ITEM(py_values_in, values_in_cntr_1));
		}
	}
	PY_CHECK_TYPE(&PyList_Type, py_values_in, return false;);
	r->in.num_values = PyList_GET_SIZE(py_values_in);
	if (py_buffer == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.buffer");
		return false;
	}
	if (py_buffer == Py_None) {
		r->in.buffer = NULL;
	} else {
		r->in.buffer = NULL;
		PY_CHECK_TYPE(&PyList_Type, py_buffer, return false;);
		{
			int buffer_cntr_1;
			r->in.buffer = talloc_array_ptrtype(r, r->in.buffer, PyList_GET_SIZE(py_buffer));
			if (!r->in.buffer) { return false; }
			talloc_set_name_const(r->in.buffer, "ARRAY: r->in.buffer");
			for (buffer_cntr_1 = 0; buffer_cntr_1 < PyList_GET_SIZE(py_buffer); buffer_cntr_1++) {
				if (PyList_GET_ITEM(py_buffer, buffer_cntr_1) == NULL) {
					PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: (r->in.buffer)[buffer_cntr_1]");
					return false;
				}
				{
					const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof((r->in.buffer)[buffer_cntr_1]));
					if (PyLong_Check(PyList_GET_ITEM(py_buffer, buffer_cntr_1))) {
						unsigned long long test_var;
						test_var = PyLong_AsUnsignedLongLong(PyList_GET_ITEM(py_buffer, buffer_cntr_1));
						if (PyErr_Occurred() != NULL) {
							return false;
						}
						if (test_var > uint_max) {
							PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
							  PyLong_Type.tp_name, uint_max, test_var);
							return false;
						}
						(r->in.buffer)[buffer_cntr_1] = test_var;
					} else {
						PyErr_Format(PyExc_TypeError, "Expected type %s",
						  PyLong_Type.tp_name);
						return false;
					}
				}
			}
		}
	}
	PY_CHECK_TYPE(&PyList_Type, py_buffer, return false;);
	r->in.buffer_size = talloc_ptrtype(r, r->in.buffer_size);
	if (r->in.buffer_size == NULL) {
		PyErr_NoMemory();
		return false;
	}
	*r->in.buffer_size = PyList_GET_SIZE(py_buffer);
	return true;
}

static PyObject *unpack_py_winreg_QueryMultipleValues_args_out(struct winreg_QueryMultipleValues *r, bool raise_result_exception)
{
	PyObject *py_values_out = NULL;
	PyObject *py_buffer = NULL;
	PyObject *result = NULL;
	size_t result_size = 2;

	if (raise_result_exception) {
		if (!W_ERROR_IS_OK(r->out.result)) {
			PyErr_SetWERROR(r->out.result);
			return NULL;
		}

	} else {
		/* WERROR will be part of the results */
		result_size += 1;
	}

	if (result_size > 1) {
		result = PyTuple_New(result_size);
		if (result == NULL) {
			return NULL;
		}
	}

	py_values_out = PyList_New(r->in.num_values);
	if (py_values_out == NULL) {
		return NULL;
	}
	{
		int values_out_cntr_1;
		for (values_out_cntr_1 = 0; values_out_cntr_1 < (r->in.num_values); values_out_cntr_1++) {
			PyObject *py_values_out_1;
			py_values_out_1 = pytalloc_reference_ex(&QueryMultipleValue_Type, r->out.values_out, &(r->out.values_out)[values_out_cntr_1]);
			PyList_SetItem(py_values_out, values_out_cntr_1, py_values_out_1);
		}
	}
	PyTuple_SetItem(result, 0, py_values_out);

	if (r->out.buffer == NULL) {
		py_buffer = Py_None;
		Py_INCREF(py_buffer);
	} else {
		py_buffer = PyList_New(*r->out.buffer_size);
		if (py_buffer == NULL) {
			return NULL;
		}
		{
			int buffer_cntr_1;
			for (buffer_cntr_1 = 0; buffer_cntr_1 < (*r->out.buffer_size); buffer_cntr_1++) {
				PyObject *py_buffer_1;
				py_buffer_1 = PyLong_FromLong((uint16_t)((r->out.buffer)[buffer_cntr_1]));
				PyList_SetItem(py_buffer, buffer_cntr_1, py_buffer_1);
			}
		}
	}
	PyTuple_SetItem(result, 1, py_buffer);

	if (!raise_result_exception) {
		PyTuple_SetItem(result, 2, PyErr_FromWERROR(r->out.result));
	}

	return result;
}


static PyObject *py_winreg_InitiateSystemShutdownEx_in_get_hostname(PyObject *obj, void *closure)
{
	struct winreg_InitiateSystemShutdownEx *object = pytalloc_get_ptr(obj);
	PyObject *py_hostname;
	if (object->in.hostname == NULL) {
		Py_RETURN_NONE;
	}
	if (object->in.hostname == NULL) {
		py_hostname = Py_None;
		Py_INCREF(py_hostname);
	} else {
		py_hostname = PyLong_FromLong((uint16_t)(*object->in.hostname));
	}
	return py_hostname;
}

static int py_winreg_InitiateSystemShutdownEx_in_set_hostname(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winreg_InitiateSystemShutdownEx *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->in.hostname));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.hostname");
		return -1;
	}
	if (value == Py_None) {
		object->in.hostname = NULL;
	} else {
		object->in.hostname = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->in.hostname);
		if (object->in.hostname == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		{
			const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(*object->in.hostname));
			if (PyLong_Check(value)) {
				unsigned long long test_var;
				test_var = PyLong_AsUnsignedLongLong(value);
				if (PyErr_Occurred() != NULL) {
					return -1;
				}
				if (test_var > uint_max) {
					PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
					  PyLong_Type.tp_name, uint_max, test_var);
					return -1;
				}
				*object->in.hostname = test_var;
			} else {
				PyErr_Format(PyExc_TypeError, "Expected type %s",
				  PyLong_Type.tp_name);
				return -1;
			}
		}
	}
	return 0;
}

static PyObject *py_winreg_InitiateSystemShutdownEx_in_get_message(PyObject *obj, void *closure)
{
	struct winreg_InitiateSystemShutdownEx *object = pytalloc_get_ptr(obj);
	PyObject *py_message;
	if (object->in.message == NULL) {
		Py_RETURN_NONE;
	}
	if (object->in.message == NULL) {
		py_message = Py_None;
		Py_INCREF(py_message);
	} else {
		py_message = pytalloc_reference_ex(lsa_StringLarge_Type, object->in.message, object->in.message);
	}
	return py_message;
}

static int py_winreg_InitiateSystemShutdownEx_in_set_message(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winreg_InitiateSystemShutdownEx *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->in.message));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.message");
		return -1;
	}
	if (value == Py_None) {
		object->in.message = NULL;
	} else {
		object->in.message = NULL;
		PY_CHECK_TYPE(lsa_StringLarge_Type, value, return -1;);
		if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->in.message = (struct lsa_StringLarge *)pytalloc_get_ptr(value);
	}
	return 0;
}

static PyObject *py_winreg_InitiateSystemShutdownEx_in_get_timeout(PyObject *obj, void *closure)
{
	struct winreg_InitiateSystemShutdownEx *object = pytalloc_get_ptr(obj);
	PyObject *py_timeout;
	py_timeout = PyLong_FromUnsignedLongLong((uint32_t)(object->in.timeout));
	return py_timeout;
}

static int py_winreg_InitiateSystemShutdownEx_in_set_timeout(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winreg_InitiateSystemShutdownEx *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.timeout");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->in.timeout));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->in.timeout = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_winreg_InitiateSystemShutdownEx_in_get_force_apps(PyObject *obj, void *closure)
{
	struct winreg_InitiateSystemShutdownEx *object = pytalloc_get_ptr(obj);
	PyObject *py_force_apps;
	py_force_apps = PyLong_FromLong((uint16_t)(object->in.force_apps));
	return py_force_apps;
}

static int py_winreg_InitiateSystemShutdownEx_in_set_force_apps(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winreg_InitiateSystemShutdownEx *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.force_apps");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->in.force_apps));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->in.force_apps = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_winreg_InitiateSystemShutdownEx_in_get_do_reboot(PyObject *obj, void *closure)
{
	struct winreg_InitiateSystemShutdownEx *object = pytalloc_get_ptr(obj);
	PyObject *py_do_reboot;
	py_do_reboot = PyLong_FromLong((uint16_t)(object->in.do_reboot));
	return py_do_reboot;
}

static int py_winreg_InitiateSystemShutdownEx_in_set_do_reboot(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winreg_InitiateSystemShutdownEx *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.do_reboot");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->in.do_reboot));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->in.do_reboot = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_winreg_InitiateSystemShutdownEx_in_get_reason(PyObject *obj, void *closure)
{
	struct winreg_InitiateSystemShutdownEx *object = pytalloc_get_ptr(obj);
	PyObject *py_reason;
	py_reason = PyLong_FromUnsignedLongLong((uint32_t)(object->in.reason));
	return py_reason;
}

static int py_winreg_InitiateSystemShutdownEx_in_set_reason(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winreg_InitiateSystemShutdownEx *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.reason");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->in.reason));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->in.reason = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_winreg_InitiateSystemShutdownEx_get_result(PyObject *obj, void *closure)
{
	struct winreg_InitiateSystemShutdownEx *object = pytalloc_get_ptr(obj);
	PyObject *py_result;
	py_result = PyErr_FromWERROR(object->out.result);
	return py_result;
}

static int py_winreg_InitiateSystemShutdownEx_set_result(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winreg_InitiateSystemShutdownEx *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->out.result");
		return -1;
	}
	object->out.result = W_ERROR(PyLong_AsLong(value));
	return 0;
}

static PyGetSetDef py_winreg_InitiateSystemShutdownEx_getsetters[] = {
	{
		.name = discard_const_p(char, "in_hostname"),
		.get = py_winreg_InitiateSystemShutdownEx_in_get_hostname,
		.set = py_winreg_InitiateSystemShutdownEx_in_set_hostname,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "in_message"),
		.get = py_winreg_InitiateSystemShutdownEx_in_get_message,
		.set = py_winreg_InitiateSystemShutdownEx_in_set_message,
		.doc = discard_const_p(char, "PIDL-generated element of base type lsa_StringLarge")
	},
	{
		.name = discard_const_p(char, "in_timeout"),
		.get = py_winreg_InitiateSystemShutdownEx_in_get_timeout,
		.set = py_winreg_InitiateSystemShutdownEx_in_set_timeout,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "in_force_apps"),
		.get = py_winreg_InitiateSystemShutdownEx_in_get_force_apps,
		.set = py_winreg_InitiateSystemShutdownEx_in_set_force_apps,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "in_do_reboot"),
		.get = py_winreg_InitiateSystemShutdownEx_in_get_do_reboot,
		.set = py_winreg_InitiateSystemShutdownEx_in_set_do_reboot,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "in_reason"),
		.get = py_winreg_InitiateSystemShutdownEx_in_get_reason,
		.set = py_winreg_InitiateSystemShutdownEx_in_set_reason,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "result"),
		.get = py_winreg_InitiateSystemShutdownEx_get_result,
		.set = py_winreg_InitiateSystemShutdownEx_set_result,
		.doc = discard_const_p(char, "PIDL-generated element of type WERROR")
	},
	{ .name = NULL }
};

static PyObject *py_winreg_InitiateSystemShutdownEx_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyObject *self = pytalloc_new(struct winreg_InitiateSystemShutdownEx, type);
	return self;
}

static PyObject *py_winreg_InitiateSystemShutdownEx_ndr_opnum(PyTypeObject *type, PyObject *Py_UNUSED(ignored))
{


	return PyLong_FromLong(30);
}

static PyObject *py_winreg_InitiateSystemShutdownEx_ndr_pack(PyObject *py_obj, ndr_flags_type ndr_inout_flags, libndr_flags ndr_push_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct winreg_InitiateSystemShutdownEx *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	struct ndr_push *push = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;

	if (ndr_table_winreg.num_calls < 31) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_winreg_InitiateSystemShutdownEx_ndr_pack");
		return NULL;
	}
	call = &ndr_table_winreg.calls[30];

	push = ndr_push_init_ctx(pytalloc_get_mem_ctx(py_obj));
	if (push == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	push->flags |= ndr_push_flags;

	err = call->ndr_push(push, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(push);
		PyErr_SetNdrError(err);
		return NULL;
	}
	blob = ndr_push_blob(push);
	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(push);
	return ret;
}

static PyObject *py_winreg_InitiateSystemShutdownEx_ndr_pack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_in__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_winreg_InitiateSystemShutdownEx_ndr_pack(py_obj, NDR_IN, ndr_push_flags);
}

static PyObject *py_winreg_InitiateSystemShutdownEx_ndr_pack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_out__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_winreg_InitiateSystemShutdownEx_ndr_pack(py_obj, NDR_OUT, ndr_push_flags);
}

static PyObject *py_winreg_InitiateSystemShutdownEx_ndr_unpack(PyObject *py_obj, const DATA_BLOB *blob, ndr_flags_type ndr_inout_flags, libndr_flags ndr_pull_flags, bool allow_remaining)
{
	const struct ndr_interface_call *call = NULL;
	struct winreg_InitiateSystemShutdownEx *object = pytalloc_get_ptr(py_obj);
	struct ndr_pull *pull = NULL;
	enum ndr_err_code err;

	if (ndr_table_winreg.num_calls < 31) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_winreg_InitiateSystemShutdownEx_ndr_unpack");
		return NULL;
	}
	call = &ndr_table_winreg.calls[30];

	pull = ndr_pull_init_blob(blob, object);
	if (pull == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	pull->flags |= ndr_pull_flags;

	err = call->ndr_pull(pull, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(pull);
		PyErr_SetNdrError(err);
		return NULL;
	}
	if (!allow_remaining) {
		uint32_t highest_ofs;

		if (pull->offset > pull->relative_highest_offset) {
			highest_ofs = pull->offset;
		} else {
			highest_ofs = pull->relative_highest_offset;
		}
		if (highest_ofs < pull->data_size) {
			err = ndr_pull_error(pull, NDR_ERR_UNREAD_BYTES,
				"not all bytes consumed ofs[%u] size[%u]",
				highest_ofs, pull->data_size);
			TALLOC_FREE(pull);
			PyErr_SetNdrError(err);
			return NULL;
		}
	}

	TALLOC_FREE(pull);
	Py_RETURN_NONE;
}

static PyObject *py_winreg_InitiateSystemShutdownEx_ndr_unpack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_in__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_winreg_InitiateSystemShutdownEx_ndr_unpack(py_obj, &blob, NDR_IN, ndr_pull_flags, allow_remaining);
}

static PyObject *py_winreg_InitiateSystemShutdownEx_ndr_unpack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_out__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_winreg_InitiateSystemShutdownEx_ndr_unpack(py_obj, &blob, NDR_OUT, ndr_pull_flags, allow_remaining);
}

static PyObject *py_winreg_InitiateSystemShutdownEx_ndr_print(PyObject *py_obj, PyObject *args, PyObject *kwargs, const char *name, ndr_flags_type ndr_inout_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct winreg_InitiateSystemShutdownEx *object = pytalloc_get_ptr(py_obj);
	const char * const kwnames[] = { "print_secrets", NULL };
	PyObject *py_print_secrets = NULL;
	PyObject *ret;
	char *retstr;
	bool ok;

	ok = PyArg_ParseTupleAndKeywords(args, kwargs, "|O:__ndr_print__",
		discard_const_p(char *, kwnames),
		&py_print_secrets);
	if (!ok) {
		return NULL;
	}

	if (ndr_table_winreg.num_calls < 31) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_winreg_InitiateSystemShutdownEx_ndr_print");
		return NULL;
	}
	call = &ndr_table_winreg.calls[30];

	if (py_print_secrets != NULL && PyObject_IsTrue(py_print_secrets)) {
		retstr = ndr_print_function_secret_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	} else {
		retstr = ndr_print_function_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	}
	ret = PyUnicode_FromString(retstr);
	TALLOC_FREE(retstr);

	return ret;
}

static PyObject *py_winreg_InitiateSystemShutdownEx_ndr_print_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	return py_winreg_InitiateSystemShutdownEx_ndr_print(py_obj, args, kwargs, "winreg_InitiateSystemShutdownEx_in", NDR_IN);
}

static PyObject *py_winreg_InitiateSystemShutdownEx_ndr_print_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	return py_winreg_InitiateSystemShutdownEx_ndr_print(py_obj, args, kwargs, "winreg_InitiateSystemShutdownEx_out", NDR_OUT);
}

static PyMethodDef py_winreg_InitiateSystemShutdownEx_methods[] = {
	{ "opnum", (PyCFunction)py_winreg_InitiateSystemShutdownEx_ndr_opnum, METH_NOARGS|METH_CLASS,
		"winreg.InitiateSystemShutdownEx.opnum() -> 30 (0x1e) " },
	{ "__ndr_pack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winreg_InitiateSystemShutdownEx_ndr_pack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_in(object, bigendian=False, ndr64=False) -> blob\nNDR pack input" },
	{ "__ndr_pack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winreg_InitiateSystemShutdownEx_ndr_pack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_out(object, bigendian=False, ndr64=False) -> blob\nNDR pack output" },
	{ "__ndr_unpack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winreg_InitiateSystemShutdownEx_ndr_unpack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_in(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack input" },
	{ "__ndr_unpack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winreg_InitiateSystemShutdownEx_ndr_unpack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_out(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack output" },
	{ "__ndr_print_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winreg_InitiateSystemShutdownEx_ndr_print_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_print_in(object, print_secrets=False) -> String\nNDR print input" },
	{ "__ndr_print_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winreg_InitiateSystemShutdownEx_ndr_print_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_print_out(object, print_secrets=False) -> String\nNDR print output" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject winreg_InitiateSystemShutdownEx_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "winreg.InitiateSystemShutdownEx",
	.tp_getset = py_winreg_InitiateSystemShutdownEx_getsetters,
	.tp_methods = py_winreg_InitiateSystemShutdownEx_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_winreg_InitiateSystemShutdownEx_new,
};

static bool pack_py_winreg_InitiateSystemShutdownEx_args_in(PyObject *args, PyObject *kwargs, struct winreg_InitiateSystemShutdownEx *r)
{
	PyObject *py_hostname;
	PyObject *py_message;
	PyObject *py_timeout;
	PyObject *py_force_apps;
	PyObject *py_do_reboot;
	PyObject *py_reason;
	const char *kwnames[] = {
		"hostname", "message", "timeout", "force_apps", "do_reboot", "reason", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOOOOO:winreg_InitiateSystemShutdownEx", discard_const_p(char *, kwnames), &py_hostname, &py_message, &py_timeout, &py_force_apps, &py_do_reboot, &py_reason)) {
		return false;
	}

	if (py_hostname == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.hostname");
		return false;
	}
	if (py_hostname == Py_None) {
		r->in.hostname = NULL;
	} else {
		r->in.hostname = talloc_ptrtype(r, r->in.hostname);
		if (r->in.hostname == NULL) {
			PyErr_NoMemory();
			return false;
		}
		{
			const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(*r->in.hostname));
			if (PyLong_Check(py_hostname)) {
				unsigned long long test_var;
				test_var = PyLong_AsUnsignedLongLong(py_hostname);
				if (PyErr_Occurred() != NULL) {
					return false;
				}
				if (test_var > uint_max) {
					PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
					  PyLong_Type.tp_name, uint_max, test_var);
					return false;
				}
				*r->in.hostname = test_var;
			} else {
				PyErr_Format(PyExc_TypeError, "Expected type %s",
				  PyLong_Type.tp_name);
				return false;
			}
		}
	}
	if (py_message == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.message");
		return false;
	}
	if (py_message == Py_None) {
		r->in.message = NULL;
	} else {
		r->in.message = NULL;
		PY_CHECK_TYPE(lsa_StringLarge_Type, py_message, return false;);
		if (talloc_reference(r, pytalloc_get_mem_ctx(py_message)) == NULL) {
			PyErr_NoMemory();
			return false;
		}
		r->in.message = (struct lsa_StringLarge *)pytalloc_get_ptr(py_message);
	}
	if (py_timeout == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.timeout");
		return false;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(r->in.timeout));
		if (PyLong_Check(py_timeout)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(py_timeout);
			if (PyErr_Occurred() != NULL) {
				return false;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return false;
			}
			r->in.timeout = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return false;
		}
	}
	if (py_force_apps == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.force_apps");
		return false;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(r->in.force_apps));
		if (PyLong_Check(py_force_apps)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(py_force_apps);
			if (PyErr_Occurred() != NULL) {
				return false;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return false;
			}
			r->in.force_apps = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return false;
		}
	}
	if (py_do_reboot == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.do_reboot");
		return false;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(r->in.do_reboot));
		if (PyLong_Check(py_do_reboot)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(py_do_reboot);
			if (PyErr_Occurred() != NULL) {
				return false;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return false;
			}
			r->in.do_reboot = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return false;
		}
	}
	if (py_reason == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.reason");
		return false;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(r->in.reason));
		if (PyLong_Check(py_reason)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(py_reason);
			if (PyErr_Occurred() != NULL) {
				return false;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return false;
			}
			r->in.reason = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return false;
		}
	}
	return true;
}

static PyObject *unpack_py_winreg_InitiateSystemShutdownEx_args_out(struct winreg_InitiateSystemShutdownEx *r, bool raise_result_exception)
{
	PyObject *result = NULL;
	size_t result_size = 0;

	if (raise_result_exception) {
		if (!W_ERROR_IS_OK(r->out.result)) {
			PyErr_SetWERROR(r->out.result);
			return NULL;
		}

	} else {
		/* WERROR will be part of the results */
		result_size += 1;
	}

	if (!raise_result_exception) {
		result = PyErr_FromWERROR(r->out.result);
	}

	if (result_size == 0) {
		result = Py_None;
		Py_INCREF(result);
	}

	return result;
}


static PyObject *py_winreg_SaveKeyEx_in_get_handle(PyObject *obj, void *closure)
{
	struct winreg_SaveKeyEx *object = pytalloc_get_ptr(obj);
	PyObject *py_handle;
	if (object->in.handle == NULL) {
		Py_RETURN_NONE;
	}
	py_handle = pytalloc_reference_ex(policy_handle_Type, object->in.handle, object->in.handle);
	return py_handle;
}

static int py_winreg_SaveKeyEx_in_set_handle(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winreg_SaveKeyEx *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->in.handle));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.handle");
		return -1;
	}
	object->in.handle = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->in.handle);
	if (object->in.handle == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	PY_CHECK_TYPE(policy_handle_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->in.handle = (struct policy_handle *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_winreg_SaveKeyEx_in_get_filename(PyObject *obj, void *closure)
{
	struct winreg_SaveKeyEx *object = pytalloc_get_ptr(obj);
	PyObject *py_filename;
	if (object->in.filename == NULL) {
		Py_RETURN_NONE;
	}
	py_filename = pytalloc_reference_ex(&winreg_String_Type, object->in.filename, object->in.filename);
	return py_filename;
}

static int py_winreg_SaveKeyEx_in_set_filename(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winreg_SaveKeyEx *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->in.filename));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.filename");
		return -1;
	}
	object->in.filename = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->in.filename);
	if (object->in.filename == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	PY_CHECK_TYPE(&winreg_String_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->in.filename = (struct winreg_String *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_winreg_SaveKeyEx_in_get_sec_attrib(PyObject *obj, void *closure)
{
	struct winreg_SaveKeyEx *object = pytalloc_get_ptr(obj);
	PyObject *py_sec_attrib;
	if (object->in.sec_attrib == NULL) {
		Py_RETURN_NONE;
	}
	if (object->in.sec_attrib == NULL) {
		py_sec_attrib = Py_None;
		Py_INCREF(py_sec_attrib);
	} else {
		py_sec_attrib = pytalloc_reference_ex(&KeySecurityAttribute_Type, object->in.sec_attrib, object->in.sec_attrib);
	}
	return py_sec_attrib;
}

static int py_winreg_SaveKeyEx_in_set_sec_attrib(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winreg_SaveKeyEx *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->in.sec_attrib));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.sec_attrib");
		return -1;
	}
	if (value == Py_None) {
		object->in.sec_attrib = NULL;
	} else {
		object->in.sec_attrib = NULL;
		PY_CHECK_TYPE(&KeySecurityAttribute_Type, value, return -1;);
		if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->in.sec_attrib = (struct KeySecurityAttribute *)pytalloc_get_ptr(value);
	}
	return 0;
}

static PyObject *py_winreg_SaveKeyEx_in_get_flags(PyObject *obj, void *closure)
{
	struct winreg_SaveKeyEx *object = pytalloc_get_ptr(obj);
	PyObject *py_flags;
	py_flags = PyLong_FromUnsignedLongLong((uint32_t)(object->in.flags));
	return py_flags;
}

static int py_winreg_SaveKeyEx_in_set_flags(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winreg_SaveKeyEx *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.flags");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->in.flags));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->in.flags = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_winreg_SaveKeyEx_get_result(PyObject *obj, void *closure)
{
	struct winreg_SaveKeyEx *object = pytalloc_get_ptr(obj);
	PyObject *py_result;
	py_result = PyErr_FromWERROR(object->out.result);
	return py_result;
}

static int py_winreg_SaveKeyEx_set_result(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winreg_SaveKeyEx *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->out.result");
		return -1;
	}
	object->out.result = W_ERROR(PyLong_AsLong(value));
	return 0;
}

static PyGetSetDef py_winreg_SaveKeyEx_getsetters[] = {
	{
		.name = discard_const_p(char, "in_handle"),
		.get = py_winreg_SaveKeyEx_in_get_handle,
		.set = py_winreg_SaveKeyEx_in_set_handle,
		.doc = discard_const_p(char, "PIDL-generated element of base type policy_handle")
	},
	{
		.name = discard_const_p(char, "in_filename"),
		.get = py_winreg_SaveKeyEx_in_get_filename,
		.set = py_winreg_SaveKeyEx_in_set_filename,
		.doc = discard_const_p(char, "PIDL-generated element of base type winreg_String")
	},
	{
		.name = discard_const_p(char, "in_sec_attrib"),
		.get = py_winreg_SaveKeyEx_in_get_sec_attrib,
		.set = py_winreg_SaveKeyEx_in_set_sec_attrib,
		.doc = discard_const_p(char, "PIDL-generated element of base type KeySecurityAttribute")
	},
	{
		.name = discard_const_p(char, "in_flags"),
		.get = py_winreg_SaveKeyEx_in_get_flags,
		.set = py_winreg_SaveKeyEx_in_set_flags,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "result"),
		.get = py_winreg_SaveKeyEx_get_result,
		.set = py_winreg_SaveKeyEx_set_result,
		.doc = discard_const_p(char, "PIDL-generated element of type WERROR")
	},
	{ .name = NULL }
};

static PyObject *py_winreg_SaveKeyEx_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyObject *self = pytalloc_new(struct winreg_SaveKeyEx, type);
	struct winreg_SaveKeyEx *_self = (struct winreg_SaveKeyEx *)pytalloc_get_ptr(self);
	TALLOC_CTX *mem_ctx = pytalloc_get_mem_ctx(self);
	_self->in.handle = talloc_zero(mem_ctx, struct policy_handle);
	_self->in.filename = talloc_zero(mem_ctx, struct winreg_String);
	return self;
}

static PyObject *py_winreg_SaveKeyEx_ndr_opnum(PyTypeObject *type, PyObject *Py_UNUSED(ignored))
{


	return PyLong_FromLong(31);
}

static PyObject *py_winreg_SaveKeyEx_ndr_pack(PyObject *py_obj, ndr_flags_type ndr_inout_flags, libndr_flags ndr_push_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct winreg_SaveKeyEx *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	struct ndr_push *push = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;

	if (ndr_table_winreg.num_calls < 32) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_winreg_SaveKeyEx_ndr_pack");
		return NULL;
	}
	call = &ndr_table_winreg.calls[31];

	push = ndr_push_init_ctx(pytalloc_get_mem_ctx(py_obj));
	if (push == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	push->flags |= ndr_push_flags;

	err = call->ndr_push(push, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(push);
		PyErr_SetNdrError(err);
		return NULL;
	}
	blob = ndr_push_blob(push);
	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(push);
	return ret;
}

static PyObject *py_winreg_SaveKeyEx_ndr_pack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_in__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_winreg_SaveKeyEx_ndr_pack(py_obj, NDR_IN, ndr_push_flags);
}

static PyObject *py_winreg_SaveKeyEx_ndr_pack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_out__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_winreg_SaveKeyEx_ndr_pack(py_obj, NDR_OUT, ndr_push_flags);
}

static PyObject *py_winreg_SaveKeyEx_ndr_unpack(PyObject *py_obj, const DATA_BLOB *blob, ndr_flags_type ndr_inout_flags, libndr_flags ndr_pull_flags, bool allow_remaining)
{
	const struct ndr_interface_call *call = NULL;
	struct winreg_SaveKeyEx *object = pytalloc_get_ptr(py_obj);
	struct ndr_pull *pull = NULL;
	enum ndr_err_code err;

	if (ndr_table_winreg.num_calls < 32) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_winreg_SaveKeyEx_ndr_unpack");
		return NULL;
	}
	call = &ndr_table_winreg.calls[31];

	pull = ndr_pull_init_blob(blob, object);
	if (pull == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	pull->flags |= ndr_pull_flags;

	err = call->ndr_pull(pull, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(pull);
		PyErr_SetNdrError(err);
		return NULL;
	}
	if (!allow_remaining) {
		uint32_t highest_ofs;

		if (pull->offset > pull->relative_highest_offset) {
			highest_ofs = pull->offset;
		} else {
			highest_ofs = pull->relative_highest_offset;
		}
		if (highest_ofs < pull->data_size) {
			err = ndr_pull_error(pull, NDR_ERR_UNREAD_BYTES,
				"not all bytes consumed ofs[%u] size[%u]",
				highest_ofs, pull->data_size);
			TALLOC_FREE(pull);
			PyErr_SetNdrError(err);
			return NULL;
		}
	}

	TALLOC_FREE(pull);
	Py_RETURN_NONE;
}

static PyObject *py_winreg_SaveKeyEx_ndr_unpack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_in__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_winreg_SaveKeyEx_ndr_unpack(py_obj, &blob, NDR_IN, ndr_pull_flags, allow_remaining);
}

static PyObject *py_winreg_SaveKeyEx_ndr_unpack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_out__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_winreg_SaveKeyEx_ndr_unpack(py_obj, &blob, NDR_OUT, ndr_pull_flags, allow_remaining);
}

static PyObject *py_winreg_SaveKeyEx_ndr_print(PyObject *py_obj, PyObject *args, PyObject *kwargs, const char *name, ndr_flags_type ndr_inout_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct winreg_SaveKeyEx *object = pytalloc_get_ptr(py_obj);
	const char * const kwnames[] = { "print_secrets", NULL };
	PyObject *py_print_secrets = NULL;
	PyObject *ret;
	char *retstr;
	bool ok;

	ok = PyArg_ParseTupleAndKeywords(args, kwargs, "|O:__ndr_print__",
		discard_const_p(char *, kwnames),
		&py_print_secrets);
	if (!ok) {
		return NULL;
	}

	if (ndr_table_winreg.num_calls < 32) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_winreg_SaveKeyEx_ndr_print");
		return NULL;
	}
	call = &ndr_table_winreg.calls[31];

	if (py_print_secrets != NULL && PyObject_IsTrue(py_print_secrets)) {
		retstr = ndr_print_function_secret_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	} else {
		retstr = ndr_print_function_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	}
	ret = PyUnicode_FromString(retstr);
	TALLOC_FREE(retstr);

	return ret;
}

static PyObject *py_winreg_SaveKeyEx_ndr_print_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	return py_winreg_SaveKeyEx_ndr_print(py_obj, args, kwargs, "winreg_SaveKeyEx_in", NDR_IN);
}

static PyObject *py_winreg_SaveKeyEx_ndr_print_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	return py_winreg_SaveKeyEx_ndr_print(py_obj, args, kwargs, "winreg_SaveKeyEx_out", NDR_OUT);
}

static PyMethodDef py_winreg_SaveKeyEx_methods[] = {
	{ "opnum", (PyCFunction)py_winreg_SaveKeyEx_ndr_opnum, METH_NOARGS|METH_CLASS,
		"winreg.SaveKeyEx.opnum() -> 31 (0x1f) " },
	{ "__ndr_pack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winreg_SaveKeyEx_ndr_pack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_in(object, bigendian=False, ndr64=False) -> blob\nNDR pack input" },
	{ "__ndr_pack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winreg_SaveKeyEx_ndr_pack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_out(object, bigendian=False, ndr64=False) -> blob\nNDR pack output" },
	{ "__ndr_unpack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winreg_SaveKeyEx_ndr_unpack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_in(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack input" },
	{ "__ndr_unpack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winreg_SaveKeyEx_ndr_unpack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_out(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack output" },
	{ "__ndr_print_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winreg_SaveKeyEx_ndr_print_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_print_in(object, print_secrets=False) -> String\nNDR print input" },
	{ "__ndr_print_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winreg_SaveKeyEx_ndr_print_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_print_out(object, print_secrets=False) -> String\nNDR print output" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject winreg_SaveKeyEx_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "winreg.SaveKeyEx",
	.tp_getset = py_winreg_SaveKeyEx_getsetters,
	.tp_methods = py_winreg_SaveKeyEx_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_winreg_SaveKeyEx_new,
};

static bool pack_py_winreg_SaveKeyEx_args_in(PyObject *args, PyObject *kwargs, struct winreg_SaveKeyEx *r)
{
	PyObject *py_handle;
	PyObject *py_filename;
	PyObject *py_sec_attrib;
	PyObject *py_flags;
	const char *kwnames[] = {
		"handle", "filename", "sec_attrib", "flags", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOOO:winreg_SaveKeyEx", discard_const_p(char *, kwnames), &py_handle, &py_filename, &py_sec_attrib, &py_flags)) {
		return false;
	}

	if (py_handle == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.handle");
		return false;
	}
	r->in.handle = talloc_ptrtype(r, r->in.handle);
	if (r->in.handle == NULL) {
		PyErr_NoMemory();
		return false;
	}
	PY_CHECK_TYPE(policy_handle_Type, py_handle, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_handle)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.handle = (struct policy_handle *)pytalloc_get_ptr(py_handle);
	if (py_filename == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.filename");
		return false;
	}
	r->in.filename = talloc_ptrtype(r, r->in.filename);
	if (r->in.filename == NULL) {
		PyErr_NoMemory();
		return false;
	}
	PY_CHECK_TYPE(&winreg_String_Type, py_filename, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_filename)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.filename = (struct winreg_String *)pytalloc_get_ptr(py_filename);
	if (py_sec_attrib == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.sec_attrib");
		return false;
	}
	if (py_sec_attrib == Py_None) {
		r->in.sec_attrib = NULL;
	} else {
		r->in.sec_attrib = NULL;
		PY_CHECK_TYPE(&KeySecurityAttribute_Type, py_sec_attrib, return false;);
		if (talloc_reference(r, pytalloc_get_mem_ctx(py_sec_attrib)) == NULL) {
			PyErr_NoMemory();
			return false;
		}
		r->in.sec_attrib = (struct KeySecurityAttribute *)pytalloc_get_ptr(py_sec_attrib);
	}
	if (py_flags == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.flags");
		return false;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(r->in.flags));
		if (PyLong_Check(py_flags)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(py_flags);
			if (PyErr_Occurred() != NULL) {
				return false;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return false;
			}
			r->in.flags = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return false;
		}
	}
	return true;
}

static PyObject *unpack_py_winreg_SaveKeyEx_args_out(struct winreg_SaveKeyEx *r, bool raise_result_exception)
{
	PyObject *result = NULL;
	size_t result_size = 0;

	if (raise_result_exception) {
		if (!W_ERROR_IS_OK(r->out.result)) {
			PyErr_SetWERROR(r->out.result);
			return NULL;
		}

	} else {
		/* WERROR will be part of the results */
		result_size += 1;
	}

	if (!raise_result_exception) {
		result = PyErr_FromWERROR(r->out.result);
	}

	if (result_size == 0) {
		result = Py_None;
		Py_INCREF(result);
	}

	return result;
}


static PyObject *py_winreg_OpenHKPT_in_get_system_name(PyObject *obj, void *closure)
{
	struct winreg_OpenHKPT *object = pytalloc_get_ptr(obj);
	PyObject *py_system_name;
	if (object->in.system_name == NULL) {
		Py_RETURN_NONE;
	}
	if (object->in.system_name == NULL) {
		py_system_name = Py_None;
		Py_INCREF(py_system_name);
	} else {
		py_system_name = PyLong_FromLong((uint16_t)(*object->in.system_name));
	}
	return py_system_name;
}

static int py_winreg_OpenHKPT_in_set_system_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winreg_OpenHKPT *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->in.system_name));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.system_name");
		return -1;
	}
	if (value == Py_None) {
		object->in.system_name = NULL;
	} else {
		object->in.system_name = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->in.system_name);
		if (object->in.system_name == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		{
			const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(*object->in.system_name));
			if (PyLong_Check(value)) {
				unsigned long long test_var;
				test_var = PyLong_AsUnsignedLongLong(value);
				if (PyErr_Occurred() != NULL) {
					return -1;
				}
				if (test_var > uint_max) {
					PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
					  PyLong_Type.tp_name, uint_max, test_var);
					return -1;
				}
				*object->in.system_name = test_var;
			} else {
				PyErr_Format(PyExc_TypeError, "Expected type %s",
				  PyLong_Type.tp_name);
				return -1;
			}
		}
	}
	return 0;
}

static PyObject *py_winreg_OpenHKPT_in_get_access_mask(PyObject *obj, void *closure)
{
	struct winreg_OpenHKPT *object = pytalloc_get_ptr(obj);
	PyObject *py_access_mask;
	py_access_mask = PyLong_FromUnsignedLongLong((uint32_t)(object->in.access_mask));
	return py_access_mask;
}

static int py_winreg_OpenHKPT_in_set_access_mask(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winreg_OpenHKPT *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.access_mask");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->in.access_mask));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->in.access_mask = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_winreg_OpenHKPT_out_get_handle(PyObject *obj, void *closure)
{
	struct winreg_OpenHKPT *object = pytalloc_get_ptr(obj);
	PyObject *py_handle;
	if (object->out.handle == NULL) {
		Py_RETURN_NONE;
	}
	py_handle = pytalloc_reference_ex(policy_handle_Type, object->out.handle, object->out.handle);
	return py_handle;
}

static int py_winreg_OpenHKPT_out_set_handle(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winreg_OpenHKPT *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->out.handle));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->out.handle");
		return -1;
	}
	object->out.handle = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->out.handle);
	if (object->out.handle == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	PY_CHECK_TYPE(policy_handle_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->out.handle = (struct policy_handle *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_winreg_OpenHKPT_get_result(PyObject *obj, void *closure)
{
	struct winreg_OpenHKPT *object = pytalloc_get_ptr(obj);
	PyObject *py_result;
	py_result = PyErr_FromWERROR(object->out.result);
	return py_result;
}

static int py_winreg_OpenHKPT_set_result(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winreg_OpenHKPT *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->out.result");
		return -1;
	}
	object->out.result = W_ERROR(PyLong_AsLong(value));
	return 0;
}

static PyGetSetDef py_winreg_OpenHKPT_getsetters[] = {
	{
		.name = discard_const_p(char, "in_system_name"),
		.get = py_winreg_OpenHKPT_in_get_system_name,
		.set = py_winreg_OpenHKPT_in_set_system_name,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "in_access_mask"),
		.get = py_winreg_OpenHKPT_in_get_access_mask,
		.set = py_winreg_OpenHKPT_in_set_access_mask,
		.doc = discard_const_p(char, "PIDL-generated element of base type winreg_AccessMask")
	},
	{
		.name = discard_const_p(char, "out_handle"),
		.get = py_winreg_OpenHKPT_out_get_handle,
		.set = py_winreg_OpenHKPT_out_set_handle,
		.doc = discard_const_p(char, "PIDL-generated element of base type policy_handle")
	},
	{
		.name = discard_const_p(char, "result"),
		.get = py_winreg_OpenHKPT_get_result,
		.set = py_winreg_OpenHKPT_set_result,
		.doc = discard_const_p(char, "PIDL-generated element of type WERROR")
	},
	{ .name = NULL }
};

static PyObject *py_winreg_OpenHKPT_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyObject *self = pytalloc_new(struct winreg_OpenHKPT, type);
	struct winreg_OpenHKPT *_self = (struct winreg_OpenHKPT *)pytalloc_get_ptr(self);
	TALLOC_CTX *mem_ctx = pytalloc_get_mem_ctx(self);
	_self->out.handle = talloc_zero(mem_ctx, struct policy_handle);
	return self;
}

static PyObject *py_winreg_OpenHKPT_ndr_opnum(PyTypeObject *type, PyObject *Py_UNUSED(ignored))
{


	return PyLong_FromLong(32);
}

static PyObject *py_winreg_OpenHKPT_ndr_pack(PyObject *py_obj, ndr_flags_type ndr_inout_flags, libndr_flags ndr_push_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct winreg_OpenHKPT *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	struct ndr_push *push = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;

	if (ndr_table_winreg.num_calls < 33) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_winreg_OpenHKPT_ndr_pack");
		return NULL;
	}
	call = &ndr_table_winreg.calls[32];

	push = ndr_push_init_ctx(pytalloc_get_mem_ctx(py_obj));
	if (push == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	push->flags |= ndr_push_flags;

	err = call->ndr_push(push, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(push);
		PyErr_SetNdrError(err);
		return NULL;
	}
	blob = ndr_push_blob(push);
	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(push);
	return ret;
}

static PyObject *py_winreg_OpenHKPT_ndr_pack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_in__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_winreg_OpenHKPT_ndr_pack(py_obj, NDR_IN, ndr_push_flags);
}

static PyObject *py_winreg_OpenHKPT_ndr_pack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_out__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_winreg_OpenHKPT_ndr_pack(py_obj, NDR_OUT, ndr_push_flags);
}

static PyObject *py_winreg_OpenHKPT_ndr_unpack(PyObject *py_obj, const DATA_BLOB *blob, ndr_flags_type ndr_inout_flags, libndr_flags ndr_pull_flags, bool allow_remaining)
{
	const struct ndr_interface_call *call = NULL;
	struct winreg_OpenHKPT *object = pytalloc_get_ptr(py_obj);
	struct ndr_pull *pull = NULL;
	enum ndr_err_code err;

	if (ndr_table_winreg.num_calls < 33) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_winreg_OpenHKPT_ndr_unpack");
		return NULL;
	}
	call = &ndr_table_winreg.calls[32];

	pull = ndr_pull_init_blob(blob, object);
	if (pull == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	pull->flags |= ndr_pull_flags;

	err = call->ndr_pull(pull, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(pull);
		PyErr_SetNdrError(err);
		return NULL;
	}
	if (!allow_remaining) {
		uint32_t highest_ofs;

		if (pull->offset > pull->relative_highest_offset) {
			highest_ofs = pull->offset;
		} else {
			highest_ofs = pull->relative_highest_offset;
		}
		if (highest_ofs < pull->data_size) {
			err = ndr_pull_error(pull, NDR_ERR_UNREAD_BYTES,
				"not all bytes consumed ofs[%u] size[%u]",
				highest_ofs, pull->data_size);
			TALLOC_FREE(pull);
			PyErr_SetNdrError(err);
			return NULL;
		}
	}

	TALLOC_FREE(pull);
	Py_RETURN_NONE;
}

static PyObject *py_winreg_OpenHKPT_ndr_unpack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_in__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_winreg_OpenHKPT_ndr_unpack(py_obj, &blob, NDR_IN, ndr_pull_flags, allow_remaining);
}

static PyObject *py_winreg_OpenHKPT_ndr_unpack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_out__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_winreg_OpenHKPT_ndr_unpack(py_obj, &blob, NDR_OUT, ndr_pull_flags, allow_remaining);
}

static PyObject *py_winreg_OpenHKPT_ndr_print(PyObject *py_obj, PyObject *args, PyObject *kwargs, const char *name, ndr_flags_type ndr_inout_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct winreg_OpenHKPT *object = pytalloc_get_ptr(py_obj);
	const char * const kwnames[] = { "print_secrets", NULL };
	PyObject *py_print_secrets = NULL;
	PyObject *ret;
	char *retstr;
	bool ok;

	ok = PyArg_ParseTupleAndKeywords(args, kwargs, "|O:__ndr_print__",
		discard_const_p(char *, kwnames),
		&py_print_secrets);
	if (!ok) {
		return NULL;
	}

	if (ndr_table_winreg.num_calls < 33) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_winreg_OpenHKPT_ndr_print");
		return NULL;
	}
	call = &ndr_table_winreg.calls[32];

	if (py_print_secrets != NULL && PyObject_IsTrue(py_print_secrets)) {
		retstr = ndr_print_function_secret_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	} else {
		retstr = ndr_print_function_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	}
	ret = PyUnicode_FromString(retstr);
	TALLOC_FREE(retstr);

	return ret;
}

static PyObject *py_winreg_OpenHKPT_ndr_print_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	return py_winreg_OpenHKPT_ndr_print(py_obj, args, kwargs, "winreg_OpenHKPT_in", NDR_IN);
}

static PyObject *py_winreg_OpenHKPT_ndr_print_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	return py_winreg_OpenHKPT_ndr_print(py_obj, args, kwargs, "winreg_OpenHKPT_out", NDR_OUT);
}

static PyMethodDef py_winreg_OpenHKPT_methods[] = {
	{ "opnum", (PyCFunction)py_winreg_OpenHKPT_ndr_opnum, METH_NOARGS|METH_CLASS,
		"winreg.OpenHKPT.opnum() -> 32 (0x20) " },
	{ "__ndr_pack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winreg_OpenHKPT_ndr_pack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_in(object, bigendian=False, ndr64=False) -> blob\nNDR pack input" },
	{ "__ndr_pack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winreg_OpenHKPT_ndr_pack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_out(object, bigendian=False, ndr64=False) -> blob\nNDR pack output" },
	{ "__ndr_unpack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winreg_OpenHKPT_ndr_unpack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_in(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack input" },
	{ "__ndr_unpack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winreg_OpenHKPT_ndr_unpack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_out(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack output" },
	{ "__ndr_print_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winreg_OpenHKPT_ndr_print_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_print_in(object, print_secrets=False) -> String\nNDR print input" },
	{ "__ndr_print_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winreg_OpenHKPT_ndr_print_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_print_out(object, print_secrets=False) -> String\nNDR print output" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject winreg_OpenHKPT_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "winreg.OpenHKPT",
	.tp_getset = py_winreg_OpenHKPT_getsetters,
	.tp_methods = py_winreg_OpenHKPT_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_winreg_OpenHKPT_new,
};

static bool pack_py_winreg_OpenHKPT_args_in(PyObject *args, PyObject *kwargs, struct winreg_OpenHKPT *r)
{
	PyObject *py_system_name;
	PyObject *py_access_mask;
	const char *kwnames[] = {
		"system_name", "access_mask", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OO:winreg_OpenHKPT", discard_const_p(char *, kwnames), &py_system_name, &py_access_mask)) {
		return false;
	}

	if (py_system_name == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.system_name");
		return false;
	}
	if (py_system_name == Py_None) {
		r->in.system_name = NULL;
	} else {
		r->in.system_name = talloc_ptrtype(r, r->in.system_name);
		if (r->in.system_name == NULL) {
			PyErr_NoMemory();
			return false;
		}
		{
			const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(*r->in.system_name));
			if (PyLong_Check(py_system_name)) {
				unsigned long long test_var;
				test_var = PyLong_AsUnsignedLongLong(py_system_name);
				if (PyErr_Occurred() != NULL) {
					return false;
				}
				if (test_var > uint_max) {
					PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
					  PyLong_Type.tp_name, uint_max, test_var);
					return false;
				}
				*r->in.system_name = test_var;
			} else {
				PyErr_Format(PyExc_TypeError, "Expected type %s",
				  PyLong_Type.tp_name);
				return false;
			}
		}
	}
	if (py_access_mask == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.access_mask");
		return false;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(r->in.access_mask));
		if (PyLong_Check(py_access_mask)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(py_access_mask);
			if (PyErr_Occurred() != NULL) {
				return false;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return false;
			}
			r->in.access_mask = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return false;
		}
	}
	return true;
}

static PyObject *unpack_py_winreg_OpenHKPT_args_out(struct winreg_OpenHKPT *r, bool raise_result_exception)
{
	PyObject *py_handle = NULL;
	PyObject *result = NULL;
	size_t result_size = 1;

	if (raise_result_exception) {
		if (!W_ERROR_IS_OK(r->out.result)) {
			PyErr_SetWERROR(r->out.result);
			return NULL;
		}

	} else {
		/* WERROR will be part of the results */
		result_size += 1;
	}

	if (result_size > 1) {
		result = PyTuple_New(result_size);
		if (result == NULL) {
			return NULL;
		}
	}

	py_handle = pytalloc_reference_ex(policy_handle_Type, r->out.handle, r->out.handle);
	if (result_size > 1) {
		PyTuple_SetItem(result, 0, py_handle);
	}
	if (result_size == 1) {
		result = py_handle;
	}

	if (!raise_result_exception) {
		PyTuple_SetItem(result, 1, PyErr_FromWERROR(r->out.result));
	}

	return result;
}


static PyObject *py_winreg_OpenHKPN_in_get_system_name(PyObject *obj, void *closure)
{
	struct winreg_OpenHKPN *object = pytalloc_get_ptr(obj);
	PyObject *py_system_name;
	if (object->in.system_name == NULL) {
		Py_RETURN_NONE;
	}
	if (object->in.system_name == NULL) {
		py_system_name = Py_None;
		Py_INCREF(py_system_name);
	} else {
		py_system_name = PyLong_FromLong((uint16_t)(*object->in.system_name));
	}
	return py_system_name;
}

static int py_winreg_OpenHKPN_in_set_system_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winreg_OpenHKPN *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->in.system_name));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.system_name");
		return -1;
	}
	if (value == Py_None) {
		object->in.system_name = NULL;
	} else {
		object->in.system_name = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->in.system_name);
		if (object->in.system_name == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		{
			const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(*object->in.system_name));
			if (PyLong_Check(value)) {
				unsigned long long test_var;
				test_var = PyLong_AsUnsignedLongLong(value);
				if (PyErr_Occurred() != NULL) {
					return -1;
				}
				if (test_var > uint_max) {
					PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
					  PyLong_Type.tp_name, uint_max, test_var);
					return -1;
				}
				*object->in.system_name = test_var;
			} else {
				PyErr_Format(PyExc_TypeError, "Expected type %s",
				  PyLong_Type.tp_name);
				return -1;
			}
		}
	}
	return 0;
}

static PyObject *py_winreg_OpenHKPN_in_get_access_mask(PyObject *obj, void *closure)
{
	struct winreg_OpenHKPN *object = pytalloc_get_ptr(obj);
	PyObject *py_access_mask;
	py_access_mask = PyLong_FromUnsignedLongLong((uint32_t)(object->in.access_mask));
	return py_access_mask;
}

static int py_winreg_OpenHKPN_in_set_access_mask(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winreg_OpenHKPN *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.access_mask");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->in.access_mask));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->in.access_mask = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_winreg_OpenHKPN_out_get_handle(PyObject *obj, void *closure)
{
	struct winreg_OpenHKPN *object = pytalloc_get_ptr(obj);
	PyObject *py_handle;
	if (object->out.handle == NULL) {
		Py_RETURN_NONE;
	}
	py_handle = pytalloc_reference_ex(policy_handle_Type, object->out.handle, object->out.handle);
	return py_handle;
}

static int py_winreg_OpenHKPN_out_set_handle(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winreg_OpenHKPN *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->out.handle));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->out.handle");
		return -1;
	}
	object->out.handle = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->out.handle);
	if (object->out.handle == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	PY_CHECK_TYPE(policy_handle_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->out.handle = (struct policy_handle *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_winreg_OpenHKPN_get_result(PyObject *obj, void *closure)
{
	struct winreg_OpenHKPN *object = pytalloc_get_ptr(obj);
	PyObject *py_result;
	py_result = PyErr_FromWERROR(object->out.result);
	return py_result;
}

static int py_winreg_OpenHKPN_set_result(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winreg_OpenHKPN *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->out.result");
		return -1;
	}
	object->out.result = W_ERROR(PyLong_AsLong(value));
	return 0;
}

static PyGetSetDef py_winreg_OpenHKPN_getsetters[] = {
	{
		.name = discard_const_p(char, "in_system_name"),
		.get = py_winreg_OpenHKPN_in_get_system_name,
		.set = py_winreg_OpenHKPN_in_set_system_name,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "in_access_mask"),
		.get = py_winreg_OpenHKPN_in_get_access_mask,
		.set = py_winreg_OpenHKPN_in_set_access_mask,
		.doc = discard_const_p(char, "PIDL-generated element of base type winreg_AccessMask")
	},
	{
		.name = discard_const_p(char, "out_handle"),
		.get = py_winreg_OpenHKPN_out_get_handle,
		.set = py_winreg_OpenHKPN_out_set_handle,
		.doc = discard_const_p(char, "PIDL-generated element of base type policy_handle")
	},
	{
		.name = discard_const_p(char, "result"),
		.get = py_winreg_OpenHKPN_get_result,
		.set = py_winreg_OpenHKPN_set_result,
		.doc = discard_const_p(char, "PIDL-generated element of type WERROR")
	},
	{ .name = NULL }
};

static PyObject *py_winreg_OpenHKPN_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyObject *self = pytalloc_new(struct winreg_OpenHKPN, type);
	struct winreg_OpenHKPN *_self = (struct winreg_OpenHKPN *)pytalloc_get_ptr(self);
	TALLOC_CTX *mem_ctx = pytalloc_get_mem_ctx(self);
	_self->out.handle = talloc_zero(mem_ctx, struct policy_handle);
	return self;
}

static PyObject *py_winreg_OpenHKPN_ndr_opnum(PyTypeObject *type, PyObject *Py_UNUSED(ignored))
{


	return PyLong_FromLong(33);
}

static PyObject *py_winreg_OpenHKPN_ndr_pack(PyObject *py_obj, ndr_flags_type ndr_inout_flags, libndr_flags ndr_push_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct winreg_OpenHKPN *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	struct ndr_push *push = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;

	if (ndr_table_winreg.num_calls < 34) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_winreg_OpenHKPN_ndr_pack");
		return NULL;
	}
	call = &ndr_table_winreg.calls[33];

	push = ndr_push_init_ctx(pytalloc_get_mem_ctx(py_obj));
	if (push == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	push->flags |= ndr_push_flags;

	err = call->ndr_push(push, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(push);
		PyErr_SetNdrError(err);
		return NULL;
	}
	blob = ndr_push_blob(push);
	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(push);
	return ret;
}

static PyObject *py_winreg_OpenHKPN_ndr_pack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_in__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_winreg_OpenHKPN_ndr_pack(py_obj, NDR_IN, ndr_push_flags);
}

static PyObject *py_winreg_OpenHKPN_ndr_pack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_out__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_winreg_OpenHKPN_ndr_pack(py_obj, NDR_OUT, ndr_push_flags);
}

static PyObject *py_winreg_OpenHKPN_ndr_unpack(PyObject *py_obj, const DATA_BLOB *blob, ndr_flags_type ndr_inout_flags, libndr_flags ndr_pull_flags, bool allow_remaining)
{
	const struct ndr_interface_call *call = NULL;
	struct winreg_OpenHKPN *object = pytalloc_get_ptr(py_obj);
	struct ndr_pull *pull = NULL;
	enum ndr_err_code err;

	if (ndr_table_winreg.num_calls < 34) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_winreg_OpenHKPN_ndr_unpack");
		return NULL;
	}
	call = &ndr_table_winreg.calls[33];

	pull = ndr_pull_init_blob(blob, object);
	if (pull == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	pull->flags |= ndr_pull_flags;

	err = call->ndr_pull(pull, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(pull);
		PyErr_SetNdrError(err);
		return NULL;
	}
	if (!allow_remaining) {
		uint32_t highest_ofs;

		if (pull->offset > pull->relative_highest_offset) {
			highest_ofs = pull->offset;
		} else {
			highest_ofs = pull->relative_highest_offset;
		}
		if (highest_ofs < pull->data_size) {
			err = ndr_pull_error(pull, NDR_ERR_UNREAD_BYTES,
				"not all bytes consumed ofs[%u] size[%u]",
				highest_ofs, pull->data_size);
			TALLOC_FREE(pull);
			PyErr_SetNdrError(err);
			return NULL;
		}
	}

	TALLOC_FREE(pull);
	Py_RETURN_NONE;
}

static PyObject *py_winreg_OpenHKPN_ndr_unpack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_in__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_winreg_OpenHKPN_ndr_unpack(py_obj, &blob, NDR_IN, ndr_pull_flags, allow_remaining);
}

static PyObject *py_winreg_OpenHKPN_ndr_unpack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_out__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_winreg_OpenHKPN_ndr_unpack(py_obj, &blob, NDR_OUT, ndr_pull_flags, allow_remaining);
}

static PyObject *py_winreg_OpenHKPN_ndr_print(PyObject *py_obj, PyObject *args, PyObject *kwargs, const char *name, ndr_flags_type ndr_inout_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct winreg_OpenHKPN *object = pytalloc_get_ptr(py_obj);
	const char * const kwnames[] = { "print_secrets", NULL };
	PyObject *py_print_secrets = NULL;
	PyObject *ret;
	char *retstr;
	bool ok;

	ok = PyArg_ParseTupleAndKeywords(args, kwargs, "|O:__ndr_print__",
		discard_const_p(char *, kwnames),
		&py_print_secrets);
	if (!ok) {
		return NULL;
	}

	if (ndr_table_winreg.num_calls < 34) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_winreg_OpenHKPN_ndr_print");
		return NULL;
	}
	call = &ndr_table_winreg.calls[33];

	if (py_print_secrets != NULL && PyObject_IsTrue(py_print_secrets)) {
		retstr = ndr_print_function_secret_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	} else {
		retstr = ndr_print_function_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	}
	ret = PyUnicode_FromString(retstr);
	TALLOC_FREE(retstr);

	return ret;
}

static PyObject *py_winreg_OpenHKPN_ndr_print_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	return py_winreg_OpenHKPN_ndr_print(py_obj, args, kwargs, "winreg_OpenHKPN_in", NDR_IN);
}

static PyObject *py_winreg_OpenHKPN_ndr_print_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	return py_winreg_OpenHKPN_ndr_print(py_obj, args, kwargs, "winreg_OpenHKPN_out", NDR_OUT);
}

static PyMethodDef py_winreg_OpenHKPN_methods[] = {
	{ "opnum", (PyCFunction)py_winreg_OpenHKPN_ndr_opnum, METH_NOARGS|METH_CLASS,
		"winreg.OpenHKPN.opnum() -> 33 (0x21) " },
	{ "__ndr_pack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winreg_OpenHKPN_ndr_pack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_in(object, bigendian=False, ndr64=False) -> blob\nNDR pack input" },
	{ "__ndr_pack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winreg_OpenHKPN_ndr_pack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_out(object, bigendian=False, ndr64=False) -> blob\nNDR pack output" },
	{ "__ndr_unpack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winreg_OpenHKPN_ndr_unpack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_in(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack input" },
	{ "__ndr_unpack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winreg_OpenHKPN_ndr_unpack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_out(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack output" },
	{ "__ndr_print_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winreg_OpenHKPN_ndr_print_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_print_in(object, print_secrets=False) -> String\nNDR print input" },
	{ "__ndr_print_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winreg_OpenHKPN_ndr_print_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_print_out(object, print_secrets=False) -> String\nNDR print output" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject winreg_OpenHKPN_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "winreg.OpenHKPN",
	.tp_getset = py_winreg_OpenHKPN_getsetters,
	.tp_methods = py_winreg_OpenHKPN_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_winreg_OpenHKPN_new,
};

static bool pack_py_winreg_OpenHKPN_args_in(PyObject *args, PyObject *kwargs, struct winreg_OpenHKPN *r)
{
	PyObject *py_system_name;
	PyObject *py_access_mask;
	const char *kwnames[] = {
		"system_name", "access_mask", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OO:winreg_OpenHKPN", discard_const_p(char *, kwnames), &py_system_name, &py_access_mask)) {
		return false;
	}

	if (py_system_name == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.system_name");
		return false;
	}
	if (py_system_name == Py_None) {
		r->in.system_name = NULL;
	} else {
		r->in.system_name = talloc_ptrtype(r, r->in.system_name);
		if (r->in.system_name == NULL) {
			PyErr_NoMemory();
			return false;
		}
		{
			const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(*r->in.system_name));
			if (PyLong_Check(py_system_name)) {
				unsigned long long test_var;
				test_var = PyLong_AsUnsignedLongLong(py_system_name);
				if (PyErr_Occurred() != NULL) {
					return false;
				}
				if (test_var > uint_max) {
					PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
					  PyLong_Type.tp_name, uint_max, test_var);
					return false;
				}
				*r->in.system_name = test_var;
			} else {
				PyErr_Format(PyExc_TypeError, "Expected type %s",
				  PyLong_Type.tp_name);
				return false;
			}
		}
	}
	if (py_access_mask == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.access_mask");
		return false;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(r->in.access_mask));
		if (PyLong_Check(py_access_mask)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(py_access_mask);
			if (PyErr_Occurred() != NULL) {
				return false;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return false;
			}
			r->in.access_mask = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return false;
		}
	}
	return true;
}

static PyObject *unpack_py_winreg_OpenHKPN_args_out(struct winreg_OpenHKPN *r, bool raise_result_exception)
{
	PyObject *py_handle = NULL;
	PyObject *result = NULL;
	size_t result_size = 1;

	if (raise_result_exception) {
		if (!W_ERROR_IS_OK(r->out.result)) {
			PyErr_SetWERROR(r->out.result);
			return NULL;
		}

	} else {
		/* WERROR will be part of the results */
		result_size += 1;
	}

	if (result_size > 1) {
		result = PyTuple_New(result_size);
		if (result == NULL) {
			return NULL;
		}
	}

	py_handle = pytalloc_reference_ex(policy_handle_Type, r->out.handle, r->out.handle);
	if (result_size > 1) {
		PyTuple_SetItem(result, 0, py_handle);
	}
	if (result_size == 1) {
		result = py_handle;
	}

	if (!raise_result_exception) {
		PyTuple_SetItem(result, 1, PyErr_FromWERROR(r->out.result));
	}

	return result;
}


static PyObject *py_winreg_QueryMultipleValues2_in_get_key_handle(PyObject *obj, void *closure)
{
	struct winreg_QueryMultipleValues2 *object = pytalloc_get_ptr(obj);
	PyObject *py_key_handle;
	if (object->in.key_handle == NULL) {
		Py_RETURN_NONE;
	}
	py_key_handle = pytalloc_reference_ex(policy_handle_Type, object->in.key_handle, object->in.key_handle);
	return py_key_handle;
}

static int py_winreg_QueryMultipleValues2_in_set_key_handle(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winreg_QueryMultipleValues2 *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->in.key_handle));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.key_handle");
		return -1;
	}
	object->in.key_handle = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->in.key_handle);
	if (object->in.key_handle == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	PY_CHECK_TYPE(policy_handle_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->in.key_handle = (struct policy_handle *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_winreg_QueryMultipleValues2_in_get_values_in(PyObject *obj, void *closure)
{
	struct winreg_QueryMultipleValues2 *object = pytalloc_get_ptr(obj);
	PyObject *py_values_in;
	if (object->in.values_in == NULL) {
		Py_RETURN_NONE;
	}
	py_values_in = PyList_New(object->in.num_values);
	if (py_values_in == NULL) {
		return NULL;
	}
	{
		int values_in_cntr_1;
		for (values_in_cntr_1 = 0; values_in_cntr_1 < (object->in.num_values); values_in_cntr_1++) {
			PyObject *py_values_in_1;
			py_values_in_1 = pytalloc_reference_ex(&QueryMultipleValue_Type, object->in.values_in, &(object->in.values_in)[values_in_cntr_1]);
			PyList_SetItem(py_values_in, values_in_cntr_1, py_values_in_1);
		}
	}
	return py_values_in;
}

static int py_winreg_QueryMultipleValues2_in_set_values_in(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winreg_QueryMultipleValues2 *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->in.values_in));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.values_in");
		return -1;
	}
	object->in.values_in = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->in.values_in);
	if (object->in.values_in == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int values_in_cntr_1;
		object->in.values_in = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->in.values_in, PyList_GET_SIZE(value));
		if (!object->in.values_in) { return -1; }
		talloc_set_name_const(object->in.values_in, "ARRAY: object->in.values_in");
		for (values_in_cntr_1 = 0; values_in_cntr_1 < PyList_GET_SIZE(value); values_in_cntr_1++) {
			if (PyList_GET_ITEM(value, values_in_cntr_1) == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: (object->in.values_in)[values_in_cntr_1]");
				return -1;
			}
			PY_CHECK_TYPE(&QueryMultipleValue_Type, PyList_GET_ITEM(value, values_in_cntr_1), return -1;);
			if (talloc_reference(object->in.values_in, pytalloc_get_mem_ctx(PyList_GET_ITEM(value, values_in_cntr_1))) == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			(object->in.values_in)[values_in_cntr_1] = *(struct QueryMultipleValue *)pytalloc_get_ptr(PyList_GET_ITEM(value, values_in_cntr_1));
		}
	}
	return 0;
}

static PyObject *py_winreg_QueryMultipleValues2_out_get_values_out(PyObject *obj, void *closure)
{
	struct winreg_QueryMultipleValues2 *object = pytalloc_get_ptr(obj);
	PyObject *py_values_out;
	if (object->out.values_out == NULL) {
		Py_RETURN_NONE;
	}
	py_values_out = PyList_New(object->in.num_values);
	if (py_values_out == NULL) {
		return NULL;
	}
	{
		int values_out_cntr_1;
		for (values_out_cntr_1 = 0; values_out_cntr_1 < (object->in.num_values); values_out_cntr_1++) {
			PyObject *py_values_out_1;
			py_values_out_1 = pytalloc_reference_ex(&QueryMultipleValue_Type, object->out.values_out, &(object->out.values_out)[values_out_cntr_1]);
			PyList_SetItem(py_values_out, values_out_cntr_1, py_values_out_1);
		}
	}
	return py_values_out;
}

static int py_winreg_QueryMultipleValues2_out_set_values_out(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winreg_QueryMultipleValues2 *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->out.values_out));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->out.values_out");
		return -1;
	}
	object->out.values_out = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->out.values_out);
	if (object->out.values_out == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int values_out_cntr_1;
		object->out.values_out = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->out.values_out, PyList_GET_SIZE(value));
		if (!object->out.values_out) { return -1; }
		talloc_set_name_const(object->out.values_out, "ARRAY: object->out.values_out");
		for (values_out_cntr_1 = 0; values_out_cntr_1 < PyList_GET_SIZE(value); values_out_cntr_1++) {
			if (PyList_GET_ITEM(value, values_out_cntr_1) == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: (object->out.values_out)[values_out_cntr_1]");
				return -1;
			}
			PY_CHECK_TYPE(&QueryMultipleValue_Type, PyList_GET_ITEM(value, values_out_cntr_1), return -1;);
			if (talloc_reference(object->out.values_out, pytalloc_get_mem_ctx(PyList_GET_ITEM(value, values_out_cntr_1))) == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			(object->out.values_out)[values_out_cntr_1] = *(struct QueryMultipleValue *)pytalloc_get_ptr(PyList_GET_ITEM(value, values_out_cntr_1));
		}
	}
	return 0;
}

static PyObject *py_winreg_QueryMultipleValues2_in_get_num_values(PyObject *obj, void *closure)
{
	struct winreg_QueryMultipleValues2 *object = pytalloc_get_ptr(obj);
	PyObject *py_num_values;
	py_num_values = PyLong_FromUnsignedLongLong((uint32_t)(object->in.num_values));
	return py_num_values;
}

static int py_winreg_QueryMultipleValues2_in_set_num_values(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winreg_QueryMultipleValues2 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.num_values");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->in.num_values));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->in.num_values = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_winreg_QueryMultipleValues2_in_get_buffer(PyObject *obj, void *closure)
{
	struct winreg_QueryMultipleValues2 *object = pytalloc_get_ptr(obj);
	PyObject *py_buffer;
	if (object->in.buffer == NULL) {
		Py_RETURN_NONE;
	}
	if (object->in.buffer == NULL) {
		py_buffer = Py_None;
		Py_INCREF(py_buffer);
	} else {
		py_buffer = PyList_New(*object->in.offered);
		if (py_buffer == NULL) {
			return NULL;
		}
		{
			int buffer_cntr_1;
			for (buffer_cntr_1 = 0; buffer_cntr_1 < (*object->in.offered); buffer_cntr_1++) {
				PyObject *py_buffer_1;
				py_buffer_1 = PyLong_FromLong((uint16_t)((object->in.buffer)[buffer_cntr_1]));
				PyList_SetItem(py_buffer, buffer_cntr_1, py_buffer_1);
			}
		}
	}
	return py_buffer;
}

static int py_winreg_QueryMultipleValues2_in_set_buffer(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winreg_QueryMultipleValues2 *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->in.buffer));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.buffer");
		return -1;
	}
	if (value == Py_None) {
		object->in.buffer = NULL;
	} else {
		object->in.buffer = NULL;
		PY_CHECK_TYPE(&PyList_Type, value, return -1;);
		{
			int buffer_cntr_1;
			object->in.buffer = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->in.buffer, PyList_GET_SIZE(value));
			if (!object->in.buffer) { return -1; }
			talloc_set_name_const(object->in.buffer, "ARRAY: object->in.buffer");
			for (buffer_cntr_1 = 0; buffer_cntr_1 < PyList_GET_SIZE(value); buffer_cntr_1++) {
				if (PyList_GET_ITEM(value, buffer_cntr_1) == NULL) {
					PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: (object->in.buffer)[buffer_cntr_1]");
					return -1;
				}
				{
					const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof((object->in.buffer)[buffer_cntr_1]));
					if (PyLong_Check(PyList_GET_ITEM(value, buffer_cntr_1))) {
						unsigned long long test_var;
						test_var = PyLong_AsUnsignedLongLong(PyList_GET_ITEM(value, buffer_cntr_1));
						if (PyErr_Occurred() != NULL) {
							return -1;
						}
						if (test_var > uint_max) {
							PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
							  PyLong_Type.tp_name, uint_max, test_var);
							return -1;
						}
						(object->in.buffer)[buffer_cntr_1] = test_var;
					} else {
						PyErr_Format(PyExc_TypeError, "Expected type %s",
						  PyLong_Type.tp_name);
						return -1;
					}
				}
			}
		}
	}
	return 0;
}

static PyObject *py_winreg_QueryMultipleValues2_out_get_buffer(PyObject *obj, void *closure)
{
	struct winreg_QueryMultipleValues2 *object = pytalloc_get_ptr(obj);
	PyObject *py_buffer;
	if (object->out.buffer == NULL) {
		Py_RETURN_NONE;
	}
	if (object->out.buffer == NULL) {
		py_buffer = Py_None;
		Py_INCREF(py_buffer);
	} else {
		py_buffer = PyList_New(*object->in.offered);
		if (py_buffer == NULL) {
			return NULL;
		}
		{
			int buffer_cntr_1;
			for (buffer_cntr_1 = 0; buffer_cntr_1 < (*object->in.offered); buffer_cntr_1++) {
				PyObject *py_buffer_1;
				py_buffer_1 = PyLong_FromLong((uint16_t)((object->out.buffer)[buffer_cntr_1]));
				PyList_SetItem(py_buffer, buffer_cntr_1, py_buffer_1);
			}
		}
	}
	return py_buffer;
}

static int py_winreg_QueryMultipleValues2_out_set_buffer(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winreg_QueryMultipleValues2 *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->out.buffer));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->out.buffer");
		return -1;
	}
	if (value == Py_None) {
		object->out.buffer = NULL;
	} else {
		object->out.buffer = NULL;
		PY_CHECK_TYPE(&PyList_Type, value, return -1;);
		{
			int buffer_cntr_1;
			object->out.buffer = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->out.buffer, PyList_GET_SIZE(value));
			if (!object->out.buffer) { return -1; }
			talloc_set_name_const(object->out.buffer, "ARRAY: object->out.buffer");
			for (buffer_cntr_1 = 0; buffer_cntr_1 < PyList_GET_SIZE(value); buffer_cntr_1++) {
				if (PyList_GET_ITEM(value, buffer_cntr_1) == NULL) {
					PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: (object->out.buffer)[buffer_cntr_1]");
					return -1;
				}
				{
					const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof((object->out.buffer)[buffer_cntr_1]));
					if (PyLong_Check(PyList_GET_ITEM(value, buffer_cntr_1))) {
						unsigned long long test_var;
						test_var = PyLong_AsUnsignedLongLong(PyList_GET_ITEM(value, buffer_cntr_1));
						if (PyErr_Occurred() != NULL) {
							return -1;
						}
						if (test_var > uint_max) {
							PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
							  PyLong_Type.tp_name, uint_max, test_var);
							return -1;
						}
						(object->out.buffer)[buffer_cntr_1] = test_var;
					} else {
						PyErr_Format(PyExc_TypeError, "Expected type %s",
						  PyLong_Type.tp_name);
						return -1;
					}
				}
			}
		}
	}
	return 0;
}

static PyObject *py_winreg_QueryMultipleValues2_in_get_offered(PyObject *obj, void *closure)
{
	struct winreg_QueryMultipleValues2 *object = pytalloc_get_ptr(obj);
	PyObject *py_offered;
	if (object->in.offered == NULL) {
		Py_RETURN_NONE;
	}
	py_offered = PyLong_FromUnsignedLongLong((uint32_t)(*object->in.offered));
	return py_offered;
}

static int py_winreg_QueryMultipleValues2_in_set_offered(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winreg_QueryMultipleValues2 *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->in.offered));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.offered");
		return -1;
	}
	object->in.offered = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->in.offered);
	if (object->in.offered == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(*object->in.offered));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			*object->in.offered = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_winreg_QueryMultipleValues2_out_get_needed(PyObject *obj, void *closure)
{
	struct winreg_QueryMultipleValues2 *object = pytalloc_get_ptr(obj);
	PyObject *py_needed;
	if (object->out.needed == NULL) {
		Py_RETURN_NONE;
	}
	py_needed = PyLong_FromUnsignedLongLong((uint32_t)(*object->out.needed));
	return py_needed;
}

static int py_winreg_QueryMultipleValues2_out_set_needed(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winreg_QueryMultipleValues2 *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->out.needed));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->out.needed");
		return -1;
	}
	object->out.needed = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->out.needed);
	if (object->out.needed == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(*object->out.needed));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			*object->out.needed = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_winreg_QueryMultipleValues2_get_result(PyObject *obj, void *closure)
{
	struct winreg_QueryMultipleValues2 *object = pytalloc_get_ptr(obj);
	PyObject *py_result;
	py_result = PyErr_FromWERROR(object->out.result);
	return py_result;
}

static int py_winreg_QueryMultipleValues2_set_result(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winreg_QueryMultipleValues2 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->out.result");
		return -1;
	}
	object->out.result = W_ERROR(PyLong_AsLong(value));
	return 0;
}

static PyGetSetDef py_winreg_QueryMultipleValues2_getsetters[] = {
	{
		.name = discard_const_p(char, "in_key_handle"),
		.get = py_winreg_QueryMultipleValues2_in_get_key_handle,
		.set = py_winreg_QueryMultipleValues2_in_set_key_handle,
		.doc = discard_const_p(char, "PIDL-generated element of base type policy_handle")
	},
	{
		.name = discard_const_p(char, "in_values_in"),
		.get = py_winreg_QueryMultipleValues2_in_get_values_in,
		.set = py_winreg_QueryMultipleValues2_in_set_values_in,
		.doc = discard_const_p(char, "PIDL-generated element of base type QueryMultipleValue")
	},
	{
		.name = discard_const_p(char, "out_values_out"),
		.get = py_winreg_QueryMultipleValues2_out_get_values_out,
		.set = py_winreg_QueryMultipleValues2_out_set_values_out,
		.doc = discard_const_p(char, "PIDL-generated element of base type QueryMultipleValue")
	},
	{
		.name = discard_const_p(char, "in_num_values"),
		.get = py_winreg_QueryMultipleValues2_in_get_num_values,
		.set = py_winreg_QueryMultipleValues2_in_set_num_values,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "in_buffer"),
		.get = py_winreg_QueryMultipleValues2_in_get_buffer,
		.set = py_winreg_QueryMultipleValues2_in_set_buffer,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "out_buffer"),
		.get = py_winreg_QueryMultipleValues2_out_get_buffer,
		.set = py_winreg_QueryMultipleValues2_out_set_buffer,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "in_offered"),
		.get = py_winreg_QueryMultipleValues2_in_get_offered,
		.set = py_winreg_QueryMultipleValues2_in_set_offered,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "out_needed"),
		.get = py_winreg_QueryMultipleValues2_out_get_needed,
		.set = py_winreg_QueryMultipleValues2_out_set_needed,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "result"),
		.get = py_winreg_QueryMultipleValues2_get_result,
		.set = py_winreg_QueryMultipleValues2_set_result,
		.doc = discard_const_p(char, "PIDL-generated element of type WERROR")
	},
	{ .name = NULL }
};

static PyObject *py_winreg_QueryMultipleValues2_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyObject *self = pytalloc_new(struct winreg_QueryMultipleValues2, type);
	struct winreg_QueryMultipleValues2 *_self = (struct winreg_QueryMultipleValues2 *)pytalloc_get_ptr(self);
	TALLOC_CTX *mem_ctx = pytalloc_get_mem_ctx(self);
	_self->in.key_handle = talloc_zero(mem_ctx, struct policy_handle);
	_self->in.values_in = talloc_zero(mem_ctx, struct QueryMultipleValue);
	_self->out.values_out = talloc_zero(mem_ctx, struct QueryMultipleValue);
	_self->in.offered = talloc_zero(mem_ctx, uint32_t);
	_self->out.needed = talloc_zero(mem_ctx, uint32_t);
	return self;
}

static PyObject *py_winreg_QueryMultipleValues2_ndr_opnum(PyTypeObject *type, PyObject *Py_UNUSED(ignored))
{


	return PyLong_FromLong(34);
}

static PyObject *py_winreg_QueryMultipleValues2_ndr_pack(PyObject *py_obj, ndr_flags_type ndr_inout_flags, libndr_flags ndr_push_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct winreg_QueryMultipleValues2 *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	struct ndr_push *push = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;

	if (ndr_table_winreg.num_calls < 35) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_winreg_QueryMultipleValues2_ndr_pack");
		return NULL;
	}
	call = &ndr_table_winreg.calls[34];

	push = ndr_push_init_ctx(pytalloc_get_mem_ctx(py_obj));
	if (push == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	push->flags |= ndr_push_flags;

	err = call->ndr_push(push, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(push);
		PyErr_SetNdrError(err);
		return NULL;
	}
	blob = ndr_push_blob(push);
	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(push);
	return ret;
}

static PyObject *py_winreg_QueryMultipleValues2_ndr_pack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_in__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_winreg_QueryMultipleValues2_ndr_pack(py_obj, NDR_IN, ndr_push_flags);
}

static PyObject *py_winreg_QueryMultipleValues2_ndr_pack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_out__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_winreg_QueryMultipleValues2_ndr_pack(py_obj, NDR_OUT, ndr_push_flags);
}

static PyObject *py_winreg_QueryMultipleValues2_ndr_unpack(PyObject *py_obj, const DATA_BLOB *blob, ndr_flags_type ndr_inout_flags, libndr_flags ndr_pull_flags, bool allow_remaining)
{
	const struct ndr_interface_call *call = NULL;
	struct winreg_QueryMultipleValues2 *object = pytalloc_get_ptr(py_obj);
	struct ndr_pull *pull = NULL;
	enum ndr_err_code err;

	if (ndr_table_winreg.num_calls < 35) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_winreg_QueryMultipleValues2_ndr_unpack");
		return NULL;
	}
	call = &ndr_table_winreg.calls[34];

	pull = ndr_pull_init_blob(blob, object);
	if (pull == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	pull->flags |= ndr_pull_flags;

	err = call->ndr_pull(pull, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(pull);
		PyErr_SetNdrError(err);
		return NULL;
	}
	if (!allow_remaining) {
		uint32_t highest_ofs;

		if (pull->offset > pull->relative_highest_offset) {
			highest_ofs = pull->offset;
		} else {
			highest_ofs = pull->relative_highest_offset;
		}
		if (highest_ofs < pull->data_size) {
			err = ndr_pull_error(pull, NDR_ERR_UNREAD_BYTES,
				"not all bytes consumed ofs[%u] size[%u]",
				highest_ofs, pull->data_size);
			TALLOC_FREE(pull);
			PyErr_SetNdrError(err);
			return NULL;
		}
	}

	TALLOC_FREE(pull);
	Py_RETURN_NONE;
}

static PyObject *py_winreg_QueryMultipleValues2_ndr_unpack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_in__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_winreg_QueryMultipleValues2_ndr_unpack(py_obj, &blob, NDR_IN, ndr_pull_flags, allow_remaining);
}

static PyObject *py_winreg_QueryMultipleValues2_ndr_unpack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_out__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_winreg_QueryMultipleValues2_ndr_unpack(py_obj, &blob, NDR_OUT, ndr_pull_flags, allow_remaining);
}

static PyObject *py_winreg_QueryMultipleValues2_ndr_print(PyObject *py_obj, PyObject *args, PyObject *kwargs, const char *name, ndr_flags_type ndr_inout_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct winreg_QueryMultipleValues2 *object = pytalloc_get_ptr(py_obj);
	const char * const kwnames[] = { "print_secrets", NULL };
	PyObject *py_print_secrets = NULL;
	PyObject *ret;
	char *retstr;
	bool ok;

	ok = PyArg_ParseTupleAndKeywords(args, kwargs, "|O:__ndr_print__",
		discard_const_p(char *, kwnames),
		&py_print_secrets);
	if (!ok) {
		return NULL;
	}

	if (ndr_table_winreg.num_calls < 35) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_winreg_QueryMultipleValues2_ndr_print");
		return NULL;
	}
	call = &ndr_table_winreg.calls[34];

	if (py_print_secrets != NULL && PyObject_IsTrue(py_print_secrets)) {
		retstr = ndr_print_function_secret_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	} else {
		retstr = ndr_print_function_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	}
	ret = PyUnicode_FromString(retstr);
	TALLOC_FREE(retstr);

	return ret;
}

static PyObject *py_winreg_QueryMultipleValues2_ndr_print_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	return py_winreg_QueryMultipleValues2_ndr_print(py_obj, args, kwargs, "winreg_QueryMultipleValues2_in", NDR_IN);
}

static PyObject *py_winreg_QueryMultipleValues2_ndr_print_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	return py_winreg_QueryMultipleValues2_ndr_print(py_obj, args, kwargs, "winreg_QueryMultipleValues2_out", NDR_OUT);
}

static PyMethodDef py_winreg_QueryMultipleValues2_methods[] = {
	{ "opnum", (PyCFunction)py_winreg_QueryMultipleValues2_ndr_opnum, METH_NOARGS|METH_CLASS,
		"winreg.QueryMultipleValues2.opnum() -> 34 (0x22) " },
	{ "__ndr_pack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winreg_QueryMultipleValues2_ndr_pack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_in(object, bigendian=False, ndr64=False) -> blob\nNDR pack input" },
	{ "__ndr_pack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winreg_QueryMultipleValues2_ndr_pack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_out(object, bigendian=False, ndr64=False) -> blob\nNDR pack output" },
	{ "__ndr_unpack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winreg_QueryMultipleValues2_ndr_unpack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_in(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack input" },
	{ "__ndr_unpack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winreg_QueryMultipleValues2_ndr_unpack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_out(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack output" },
	{ "__ndr_print_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winreg_QueryMultipleValues2_ndr_print_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_print_in(object, print_secrets=False) -> String\nNDR print input" },
	{ "__ndr_print_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winreg_QueryMultipleValues2_ndr_print_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_print_out(object, print_secrets=False) -> String\nNDR print output" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject winreg_QueryMultipleValues2_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "winreg.QueryMultipleValues2",
	.tp_getset = py_winreg_QueryMultipleValues2_getsetters,
	.tp_methods = py_winreg_QueryMultipleValues2_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_winreg_QueryMultipleValues2_new,
};

static bool pack_py_winreg_QueryMultipleValues2_args_in(PyObject *args, PyObject *kwargs, struct winreg_QueryMultipleValues2 *r)
{
	PyObject *py_key_handle;
	PyObject *py_values_in;
	PyObject *py_buffer;
	const char *kwnames[] = {
		"key_handle", "values_in", "buffer", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOO:winreg_QueryMultipleValues2", discard_const_p(char *, kwnames), &py_key_handle, &py_values_in, &py_buffer)) {
		return false;
	}

	if (py_key_handle == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.key_handle");
		return false;
	}
	r->in.key_handle = talloc_ptrtype(r, r->in.key_handle);
	if (r->in.key_handle == NULL) {
		PyErr_NoMemory();
		return false;
	}
	PY_CHECK_TYPE(policy_handle_Type, py_key_handle, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_key_handle)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.key_handle = (struct policy_handle *)pytalloc_get_ptr(py_key_handle);
	if (py_values_in == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.values_in");
		return false;
	}
	r->in.values_in = talloc_ptrtype(r, r->in.values_in);
	if (r->in.values_in == NULL) {
		PyErr_NoMemory();
		return false;
	}
	PY_CHECK_TYPE(&PyList_Type, py_values_in, return false;);
	{
		int values_in_cntr_1;
		r->in.values_in = talloc_array_ptrtype(r, r->in.values_in, PyList_GET_SIZE(py_values_in));
		if (!r->in.values_in) { return false; }
		talloc_set_name_const(r->in.values_in, "ARRAY: r->in.values_in");
		for (values_in_cntr_1 = 0; values_in_cntr_1 < PyList_GET_SIZE(py_values_in); values_in_cntr_1++) {
			if (PyList_GET_ITEM(py_values_in, values_in_cntr_1) == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: (r->in.values_in)[values_in_cntr_1]");
				return false;
			}
			PY_CHECK_TYPE(&QueryMultipleValue_Type, PyList_GET_ITEM(py_values_in, values_in_cntr_1), return false;);
			if (talloc_reference(r->in.values_in, pytalloc_get_mem_ctx(PyList_GET_ITEM(py_values_in, values_in_cntr_1))) == NULL) {
				PyErr_NoMemory();
				return false;
			}
			(r->in.values_in)[values_in_cntr_1] = *(struct QueryMultipleValue *)pytalloc_get_ptr(PyList_GET_ITEM(py_values_in, values_in_cntr_1));
		}
	}
	PY_CHECK_TYPE(&PyList_Type, py_values_in, return false;);
	r->in.num_values = PyList_GET_SIZE(py_values_in);
	if (py_buffer == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.buffer");
		return false;
	}
	if (py_buffer == Py_None) {
		r->in.buffer = NULL;
	} else {
		r->in.buffer = NULL;
		PY_CHECK_TYPE(&PyList_Type, py_buffer, return false;);
		{
			int buffer_cntr_1;
			r->in.buffer = talloc_array_ptrtype(r, r->in.buffer, PyList_GET_SIZE(py_buffer));
			if (!r->in.buffer) { return false; }
			talloc_set_name_const(r->in.buffer, "ARRAY: r->in.buffer");
			for (buffer_cntr_1 = 0; buffer_cntr_1 < PyList_GET_SIZE(py_buffer); buffer_cntr_1++) {
				if (PyList_GET_ITEM(py_buffer, buffer_cntr_1) == NULL) {
					PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: (r->in.buffer)[buffer_cntr_1]");
					return false;
				}
				{
					const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof((r->in.buffer)[buffer_cntr_1]));
					if (PyLong_Check(PyList_GET_ITEM(py_buffer, buffer_cntr_1))) {
						unsigned long long test_var;
						test_var = PyLong_AsUnsignedLongLong(PyList_GET_ITEM(py_buffer, buffer_cntr_1));
						if (PyErr_Occurred() != NULL) {
							return false;
						}
						if (test_var > uint_max) {
							PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
							  PyLong_Type.tp_name, uint_max, test_var);
							return false;
						}
						(r->in.buffer)[buffer_cntr_1] = test_var;
					} else {
						PyErr_Format(PyExc_TypeError, "Expected type %s",
						  PyLong_Type.tp_name);
						return false;
					}
				}
			}
		}
	}
	PY_CHECK_TYPE(&PyList_Type, py_buffer, return false;);
	r->in.offered = talloc_ptrtype(r, r->in.offered);
	if (r->in.offered == NULL) {
		PyErr_NoMemory();
		return false;
	}
	*r->in.offered = PyList_GET_SIZE(py_buffer);
	return true;
}

static PyObject *unpack_py_winreg_QueryMultipleValues2_args_out(struct winreg_QueryMultipleValues2 *r, bool raise_result_exception)
{
	PyObject *py_values_out = NULL;
	PyObject *py_buffer = NULL;
	PyObject *py_needed = NULL;
	PyObject *result = NULL;
	size_t result_size = 3;

	if (raise_result_exception) {
		if (!W_ERROR_IS_OK(r->out.result)) {
			PyErr_SetWERROR(r->out.result);
			return NULL;
		}

	} else {
		/* WERROR will be part of the results */
		result_size += 1;
	}

	if (result_size > 1) {
		result = PyTuple_New(result_size);
		if (result == NULL) {
			return NULL;
		}
	}

	py_values_out = PyList_New(r->in.num_values);
	if (py_values_out == NULL) {
		return NULL;
	}
	{
		int values_out_cntr_1;
		for (values_out_cntr_1 = 0; values_out_cntr_1 < (r->in.num_values); values_out_cntr_1++) {
			PyObject *py_values_out_1;
			py_values_out_1 = pytalloc_reference_ex(&QueryMultipleValue_Type, r->out.values_out, &(r->out.values_out)[values_out_cntr_1]);
			PyList_SetItem(py_values_out, values_out_cntr_1, py_values_out_1);
		}
	}
	PyTuple_SetItem(result, 0, py_values_out);

	if (r->out.buffer == NULL) {
		py_buffer = Py_None;
		Py_INCREF(py_buffer);
	} else {
		py_buffer = PyList_New(*r->in.offered);
		if (py_buffer == NULL) {
			return NULL;
		}
		{
			int buffer_cntr_1;
			for (buffer_cntr_1 = 0; buffer_cntr_1 < (*r->in.offered); buffer_cntr_1++) {
				PyObject *py_buffer_1;
				py_buffer_1 = PyLong_FromLong((uint16_t)((r->out.buffer)[buffer_cntr_1]));
				PyList_SetItem(py_buffer, buffer_cntr_1, py_buffer_1);
			}
		}
	}
	PyTuple_SetItem(result, 1, py_buffer);

	py_needed = PyLong_FromUnsignedLongLong((uint32_t)(*r->out.needed));
	PyTuple_SetItem(result, 2, py_needed);

	if (!raise_result_exception) {
		PyTuple_SetItem(result, 3, PyErr_FromWERROR(r->out.result));
	}

	return result;
}


static PyObject *py_winreg_DeleteKeyEx_in_get_handle(PyObject *obj, void *closure)
{
	struct winreg_DeleteKeyEx *object = pytalloc_get_ptr(obj);
	PyObject *py_handle;
	if (object->in.handle == NULL) {
		Py_RETURN_NONE;
	}
	py_handle = pytalloc_reference_ex(policy_handle_Type, object->in.handle, object->in.handle);
	return py_handle;
}

static int py_winreg_DeleteKeyEx_in_set_handle(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winreg_DeleteKeyEx *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->in.handle));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.handle");
		return -1;
	}
	object->in.handle = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->in.handle);
	if (object->in.handle == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	PY_CHECK_TYPE(policy_handle_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->in.handle = (struct policy_handle *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_winreg_DeleteKeyEx_in_get_key(PyObject *obj, void *closure)
{
	struct winreg_DeleteKeyEx *object = pytalloc_get_ptr(obj);
	PyObject *py_key;
	if (object->in.key == NULL) {
		Py_RETURN_NONE;
	}
	py_key = pytalloc_reference_ex(&winreg_String_Type, object->in.key, object->in.key);
	return py_key;
}

static int py_winreg_DeleteKeyEx_in_set_key(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winreg_DeleteKeyEx *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->in.key));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.key");
		return -1;
	}
	object->in.key = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->in.key);
	if (object->in.key == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	PY_CHECK_TYPE(&winreg_String_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->in.key = (struct winreg_String *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_winreg_DeleteKeyEx_in_get_access_mask(PyObject *obj, void *closure)
{
	struct winreg_DeleteKeyEx *object = pytalloc_get_ptr(obj);
	PyObject *py_access_mask;
	py_access_mask = PyLong_FromUnsignedLongLong((uint32_t)(object->in.access_mask));
	return py_access_mask;
}

static int py_winreg_DeleteKeyEx_in_set_access_mask(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winreg_DeleteKeyEx *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.access_mask");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->in.access_mask));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->in.access_mask = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_winreg_DeleteKeyEx_in_get_reserved(PyObject *obj, void *closure)
{
	struct winreg_DeleteKeyEx *object = pytalloc_get_ptr(obj);
	PyObject *py_reserved;
	py_reserved = PyLong_FromUnsignedLongLong((uint32_t)(object->in.reserved));
	return py_reserved;
}

static int py_winreg_DeleteKeyEx_in_set_reserved(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winreg_DeleteKeyEx *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.reserved");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->in.reserved));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->in.reserved = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_winreg_DeleteKeyEx_get_result(PyObject *obj, void *closure)
{
	struct winreg_DeleteKeyEx *object = pytalloc_get_ptr(obj);
	PyObject *py_result;
	py_result = PyErr_FromWERROR(object->out.result);
	return py_result;
}

static int py_winreg_DeleteKeyEx_set_result(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winreg_DeleteKeyEx *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->out.result");
		return -1;
	}
	object->out.result = W_ERROR(PyLong_AsLong(value));
	return 0;
}

static PyGetSetDef py_winreg_DeleteKeyEx_getsetters[] = {
	{
		.name = discard_const_p(char, "in_handle"),
		.get = py_winreg_DeleteKeyEx_in_get_handle,
		.set = py_winreg_DeleteKeyEx_in_set_handle,
		.doc = discard_const_p(char, "PIDL-generated element of base type policy_handle")
	},
	{
		.name = discard_const_p(char, "in_key"),
		.get = py_winreg_DeleteKeyEx_in_get_key,
		.set = py_winreg_DeleteKeyEx_in_set_key,
		.doc = discard_const_p(char, "PIDL-generated element of base type winreg_String")
	},
	{
		.name = discard_const_p(char, "in_access_mask"),
		.get = py_winreg_DeleteKeyEx_in_get_access_mask,
		.set = py_winreg_DeleteKeyEx_in_set_access_mask,
		.doc = discard_const_p(char, "PIDL-generated element of base type winreg_AccessMask")
	},
	{
		.name = discard_const_p(char, "in_reserved"),
		.get = py_winreg_DeleteKeyEx_in_get_reserved,
		.set = py_winreg_DeleteKeyEx_in_set_reserved,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "result"),
		.get = py_winreg_DeleteKeyEx_get_result,
		.set = py_winreg_DeleteKeyEx_set_result,
		.doc = discard_const_p(char, "PIDL-generated element of type WERROR")
	},
	{ .name = NULL }
};

static PyObject *py_winreg_DeleteKeyEx_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyObject *self = pytalloc_new(struct winreg_DeleteKeyEx, type);
	struct winreg_DeleteKeyEx *_self = (struct winreg_DeleteKeyEx *)pytalloc_get_ptr(self);
	TALLOC_CTX *mem_ctx = pytalloc_get_mem_ctx(self);
	_self->in.handle = talloc_zero(mem_ctx, struct policy_handle);
	_self->in.key = talloc_zero(mem_ctx, struct winreg_String);
	return self;
}

static PyObject *py_winreg_DeleteKeyEx_ndr_opnum(PyTypeObject *type, PyObject *Py_UNUSED(ignored))
{


	return PyLong_FromLong(35);
}

static PyObject *py_winreg_DeleteKeyEx_ndr_pack(PyObject *py_obj, ndr_flags_type ndr_inout_flags, libndr_flags ndr_push_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct winreg_DeleteKeyEx *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	struct ndr_push *push = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;

	if (ndr_table_winreg.num_calls < 36) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_winreg_DeleteKeyEx_ndr_pack");
		return NULL;
	}
	call = &ndr_table_winreg.calls[35];

	push = ndr_push_init_ctx(pytalloc_get_mem_ctx(py_obj));
	if (push == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	push->flags |= ndr_push_flags;

	err = call->ndr_push(push, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(push);
		PyErr_SetNdrError(err);
		return NULL;
	}
	blob = ndr_push_blob(push);
	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(push);
	return ret;
}

static PyObject *py_winreg_DeleteKeyEx_ndr_pack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_in__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_winreg_DeleteKeyEx_ndr_pack(py_obj, NDR_IN, ndr_push_flags);
}

static PyObject *py_winreg_DeleteKeyEx_ndr_pack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_out__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_winreg_DeleteKeyEx_ndr_pack(py_obj, NDR_OUT, ndr_push_flags);
}

static PyObject *py_winreg_DeleteKeyEx_ndr_unpack(PyObject *py_obj, const DATA_BLOB *blob, ndr_flags_type ndr_inout_flags, libndr_flags ndr_pull_flags, bool allow_remaining)
{
	const struct ndr_interface_call *call = NULL;
	struct winreg_DeleteKeyEx *object = pytalloc_get_ptr(py_obj);
	struct ndr_pull *pull = NULL;
	enum ndr_err_code err;

	if (ndr_table_winreg.num_calls < 36) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_winreg_DeleteKeyEx_ndr_unpack");
		return NULL;
	}
	call = &ndr_table_winreg.calls[35];

	pull = ndr_pull_init_blob(blob, object);
	if (pull == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	pull->flags |= ndr_pull_flags;

	err = call->ndr_pull(pull, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(pull);
		PyErr_SetNdrError(err);
		return NULL;
	}
	if (!allow_remaining) {
		uint32_t highest_ofs;

		if (pull->offset > pull->relative_highest_offset) {
			highest_ofs = pull->offset;
		} else {
			highest_ofs = pull->relative_highest_offset;
		}
		if (highest_ofs < pull->data_size) {
			err = ndr_pull_error(pull, NDR_ERR_UNREAD_BYTES,
				"not all bytes consumed ofs[%u] size[%u]",
				highest_ofs, pull->data_size);
			TALLOC_FREE(pull);
			PyErr_SetNdrError(err);
			return NULL;
		}
	}

	TALLOC_FREE(pull);
	Py_RETURN_NONE;
}

static PyObject *py_winreg_DeleteKeyEx_ndr_unpack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_in__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_winreg_DeleteKeyEx_ndr_unpack(py_obj, &blob, NDR_IN, ndr_pull_flags, allow_remaining);
}

static PyObject *py_winreg_DeleteKeyEx_ndr_unpack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_out__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_winreg_DeleteKeyEx_ndr_unpack(py_obj, &blob, NDR_OUT, ndr_pull_flags, allow_remaining);
}

static PyObject *py_winreg_DeleteKeyEx_ndr_print(PyObject *py_obj, PyObject *args, PyObject *kwargs, const char *name, ndr_flags_type ndr_inout_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct winreg_DeleteKeyEx *object = pytalloc_get_ptr(py_obj);
	const char * const kwnames[] = { "print_secrets", NULL };
	PyObject *py_print_secrets = NULL;
	PyObject *ret;
	char *retstr;
	bool ok;

	ok = PyArg_ParseTupleAndKeywords(args, kwargs, "|O:__ndr_print__",
		discard_const_p(char *, kwnames),
		&py_print_secrets);
	if (!ok) {
		return NULL;
	}

	if (ndr_table_winreg.num_calls < 36) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_winreg_DeleteKeyEx_ndr_print");
		return NULL;
	}
	call = &ndr_table_winreg.calls[35];

	if (py_print_secrets != NULL && PyObject_IsTrue(py_print_secrets)) {
		retstr = ndr_print_function_secret_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	} else {
		retstr = ndr_print_function_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	}
	ret = PyUnicode_FromString(retstr);
	TALLOC_FREE(retstr);

	return ret;
}

static PyObject *py_winreg_DeleteKeyEx_ndr_print_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	return py_winreg_DeleteKeyEx_ndr_print(py_obj, args, kwargs, "winreg_DeleteKeyEx_in", NDR_IN);
}

static PyObject *py_winreg_DeleteKeyEx_ndr_print_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	return py_winreg_DeleteKeyEx_ndr_print(py_obj, args, kwargs, "winreg_DeleteKeyEx_out", NDR_OUT);
}

static PyMethodDef py_winreg_DeleteKeyEx_methods[] = {
	{ "opnum", (PyCFunction)py_winreg_DeleteKeyEx_ndr_opnum, METH_NOARGS|METH_CLASS,
		"winreg.DeleteKeyEx.opnum() -> 35 (0x23) " },
	{ "__ndr_pack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winreg_DeleteKeyEx_ndr_pack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_in(object, bigendian=False, ndr64=False) -> blob\nNDR pack input" },
	{ "__ndr_pack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winreg_DeleteKeyEx_ndr_pack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_out(object, bigendian=False, ndr64=False) -> blob\nNDR pack output" },
	{ "__ndr_unpack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winreg_DeleteKeyEx_ndr_unpack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_in(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack input" },
	{ "__ndr_unpack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winreg_DeleteKeyEx_ndr_unpack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_out(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack output" },
	{ "__ndr_print_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winreg_DeleteKeyEx_ndr_print_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_print_in(object, print_secrets=False) -> String\nNDR print input" },
	{ "__ndr_print_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winreg_DeleteKeyEx_ndr_print_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_print_out(object, print_secrets=False) -> String\nNDR print output" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject winreg_DeleteKeyEx_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "winreg.DeleteKeyEx",
	.tp_getset = py_winreg_DeleteKeyEx_getsetters,
	.tp_methods = py_winreg_DeleteKeyEx_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_winreg_DeleteKeyEx_new,
};

static bool pack_py_winreg_DeleteKeyEx_args_in(PyObject *args, PyObject *kwargs, struct winreg_DeleteKeyEx *r)
{
	PyObject *py_handle;
	PyObject *py_key;
	PyObject *py_access_mask;
	PyObject *py_reserved;
	const char *kwnames[] = {
		"handle", "key", "access_mask", "reserved", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOOO:winreg_DeleteKeyEx", discard_const_p(char *, kwnames), &py_handle, &py_key, &py_access_mask, &py_reserved)) {
		return false;
	}

	if (py_handle == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.handle");
		return false;
	}
	r->in.handle = talloc_ptrtype(r, r->in.handle);
	if (r->in.handle == NULL) {
		PyErr_NoMemory();
		return false;
	}
	PY_CHECK_TYPE(policy_handle_Type, py_handle, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_handle)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.handle = (struct policy_handle *)pytalloc_get_ptr(py_handle);
	if (py_key == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.key");
		return false;
	}
	r->in.key = talloc_ptrtype(r, r->in.key);
	if (r->in.key == NULL) {
		PyErr_NoMemory();
		return false;
	}
	PY_CHECK_TYPE(&winreg_String_Type, py_key, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_key)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.key = (struct winreg_String *)pytalloc_get_ptr(py_key);
	if (py_access_mask == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.access_mask");
		return false;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(r->in.access_mask));
		if (PyLong_Check(py_access_mask)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(py_access_mask);
			if (PyErr_Occurred() != NULL) {
				return false;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return false;
			}
			r->in.access_mask = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return false;
		}
	}
	if (py_reserved == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.reserved");
		return false;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(r->in.reserved));
		if (PyLong_Check(py_reserved)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(py_reserved);
			if (PyErr_Occurred() != NULL) {
				return false;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return false;
			}
			r->in.reserved = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return false;
		}
	}
	return true;
}

static PyObject *unpack_py_winreg_DeleteKeyEx_args_out(struct winreg_DeleteKeyEx *r, bool raise_result_exception)
{
	PyObject *result = NULL;
	size_t result_size = 0;

	if (raise_result_exception) {
		if (!W_ERROR_IS_OK(r->out.result)) {
			PyErr_SetWERROR(r->out.result);
			return NULL;
		}

	} else {
		/* WERROR will be part of the results */
		result_size += 1;
	}

	if (!raise_result_exception) {
		result = PyErr_FromWERROR(r->out.result);
	}

	if (result_size == 0) {
		result = Py_None;
		Py_INCREF(result);
	}

	return result;
}

const struct PyNdrRpcMethodDef py_ndr_winreg_methods[] = {
	{
		.name = "OpenHKCR",
		.doc = "S.OpenHKCR(system_name, access_mask) -> handle",
		.call = (py_dcerpc_call_fn)dcerpc_winreg_OpenHKCR_r,
		.pack_in_data = (py_data_pack_fn)pack_py_winreg_OpenHKCR_args_in,
		.unpack_out_data = (py_data_unpack_fn)unpack_py_winreg_OpenHKCR_args_out,
		.opnum = 0,
		.table = &ndr_table_winreg,
	},
	{
		.name = "OpenHKCU",
		.doc = "S.OpenHKCU(system_name, access_mask) -> handle",
		.call = (py_dcerpc_call_fn)dcerpc_winreg_OpenHKCU_r,
		.pack_in_data = (py_data_pack_fn)pack_py_winreg_OpenHKCU_args_in,
		.unpack_out_data = (py_data_unpack_fn)unpack_py_winreg_OpenHKCU_args_out,
		.opnum = 1,
		.table = &ndr_table_winreg,
	},
	{
		.name = "OpenHKLM",
		.doc = "S.OpenHKLM(system_name, access_mask) -> handle",
		.call = (py_dcerpc_call_fn)dcerpc_winreg_OpenHKLM_r,
		.pack_in_data = (py_data_pack_fn)pack_py_winreg_OpenHKLM_args_in,
		.unpack_out_data = (py_data_unpack_fn)unpack_py_winreg_OpenHKLM_args_out,
		.opnum = 2,
		.table = &ndr_table_winreg,
	},
	{
		.name = "OpenHKPD",
		.doc = "S.OpenHKPD(system_name, access_mask) -> handle",
		.call = (py_dcerpc_call_fn)dcerpc_winreg_OpenHKPD_r,
		.pack_in_data = (py_data_pack_fn)pack_py_winreg_OpenHKPD_args_in,
		.unpack_out_data = (py_data_unpack_fn)unpack_py_winreg_OpenHKPD_args_out,
		.opnum = 3,
		.table = &ndr_table_winreg,
	},
	{
		.name = "OpenHKU",
		.doc = "S.OpenHKU(system_name, access_mask) -> handle",
		.call = (py_dcerpc_call_fn)dcerpc_winreg_OpenHKU_r,
		.pack_in_data = (py_data_pack_fn)pack_py_winreg_OpenHKU_args_in,
		.unpack_out_data = (py_data_unpack_fn)unpack_py_winreg_OpenHKU_args_out,
		.opnum = 4,
		.table = &ndr_table_winreg,
	},
	{
		.name = "CloseKey",
		.doc = "S.CloseKey(handle) -> handle",
		.call = (py_dcerpc_call_fn)dcerpc_winreg_CloseKey_r,
		.pack_in_data = (py_data_pack_fn)pack_py_winreg_CloseKey_args_in,
		.unpack_out_data = (py_data_unpack_fn)unpack_py_winreg_CloseKey_args_out,
		.opnum = 5,
		.table = &ndr_table_winreg,
	},
	{
		.name = "CreateKey",
		.doc = "S.CreateKey(handle, name, keyclass, options, access_mask, secdesc, action_taken) -> (new_handle, action_taken)",
		.call = (py_dcerpc_call_fn)dcerpc_winreg_CreateKey_r,
		.pack_in_data = (py_data_pack_fn)pack_py_winreg_CreateKey_args_in,
		.unpack_out_data = (py_data_unpack_fn)unpack_py_winreg_CreateKey_args_out,
		.opnum = 6,
		.table = &ndr_table_winreg,
	},
	{
		.name = "DeleteKey",
		.doc = "S.DeleteKey(handle, key) -> None",
		.call = (py_dcerpc_call_fn)dcerpc_winreg_DeleteKey_r,
		.pack_in_data = (py_data_pack_fn)pack_py_winreg_DeleteKey_args_in,
		.unpack_out_data = (py_data_unpack_fn)unpack_py_winreg_DeleteKey_args_out,
		.opnum = 7,
		.table = &ndr_table_winreg,
	},
	{
		.name = "DeleteValue",
		.doc = "S.DeleteValue(handle, value) -> None",
		.call = (py_dcerpc_call_fn)dcerpc_winreg_DeleteValue_r,
		.pack_in_data = (py_data_pack_fn)pack_py_winreg_DeleteValue_args_in,
		.unpack_out_data = (py_data_unpack_fn)unpack_py_winreg_DeleteValue_args_out,
		.opnum = 8,
		.table = &ndr_table_winreg,
	},
	{
		.name = "EnumKey",
		.doc = "S.EnumKey(handle, enum_index, name, keyclass, last_changed_time) -> (name, keyclass, last_changed_time)",
		.call = (py_dcerpc_call_fn)dcerpc_winreg_EnumKey_r,
		.pack_in_data = (py_data_pack_fn)pack_py_winreg_EnumKey_args_in,
		.unpack_out_data = (py_data_unpack_fn)unpack_py_winreg_EnumKey_args_out,
		.opnum = 9,
		.table = &ndr_table_winreg,
	},
	{
		.name = "EnumValue",
		.doc = "S.EnumValue(handle, enum_index, name, type, value, size, length) -> (name, type, value, size, length)",
		.call = (py_dcerpc_call_fn)dcerpc_winreg_EnumValue_r,
		.pack_in_data = (py_data_pack_fn)pack_py_winreg_EnumValue_args_in,
		.unpack_out_data = (py_data_unpack_fn)unpack_py_winreg_EnumValue_args_out,
		.opnum = 10,
		.table = &ndr_table_winreg,
	},
	{
		.name = "FlushKey",
		.doc = "S.FlushKey(handle) -> None",
		.call = (py_dcerpc_call_fn)dcerpc_winreg_FlushKey_r,
		.pack_in_data = (py_data_pack_fn)pack_py_winreg_FlushKey_args_in,
		.unpack_out_data = (py_data_unpack_fn)unpack_py_winreg_FlushKey_args_out,
		.opnum = 11,
		.table = &ndr_table_winreg,
	},
	{
		.name = "GetKeySecurity",
		.doc = "S.GetKeySecurity(handle, sec_info, sd) -> sd",
		.call = (py_dcerpc_call_fn)dcerpc_winreg_GetKeySecurity_r,
		.pack_in_data = (py_data_pack_fn)pack_py_winreg_GetKeySecurity_args_in,
		.unpack_out_data = (py_data_unpack_fn)unpack_py_winreg_GetKeySecurity_args_out,
		.opnum = 12,
		.table = &ndr_table_winreg,
	},
	{
		.name = "LoadKey",
		.doc = "S.LoadKey(handle, keyname, filename) -> None",
		.call = (py_dcerpc_call_fn)dcerpc_winreg_LoadKey_r,
		.pack_in_data = (py_data_pack_fn)pack_py_winreg_LoadKey_args_in,
		.unpack_out_data = (py_data_unpack_fn)unpack_py_winreg_LoadKey_args_out,
		.opnum = 13,
		.table = &ndr_table_winreg,
	},
	{
		.name = "NotifyChangeKeyValue",
		.doc = "S.NotifyChangeKeyValue(handle, watch_subtree, notify_filter, unknown, string1, string2, unknown2) -> None",
		.call = (py_dcerpc_call_fn)dcerpc_winreg_NotifyChangeKeyValue_r,
		.pack_in_data = (py_data_pack_fn)pack_py_winreg_NotifyChangeKeyValue_args_in,
		.unpack_out_data = (py_data_unpack_fn)unpack_py_winreg_NotifyChangeKeyValue_args_out,
		.opnum = 14,
		.table = &ndr_table_winreg,
	},
	{
		.name = "OpenKey",
		.doc = "S.OpenKey(parent_handle, keyname, options, access_mask) -> handle",
		.call = (py_dcerpc_call_fn)dcerpc_winreg_OpenKey_r,
		.pack_in_data = (py_data_pack_fn)pack_py_winreg_OpenKey_args_in,
		.unpack_out_data = (py_data_unpack_fn)unpack_py_winreg_OpenKey_args_out,
		.opnum = 15,
		.table = &ndr_table_winreg,
	},
	{
		.name = "QueryInfoKey",
		.doc = "S.QueryInfoKey(handle, classname) -> (classname, num_subkeys, max_subkeylen, max_classlen, num_values, max_valnamelen, max_valbufsize, secdescsize, last_changed_time)",
		.call = (py_dcerpc_call_fn)dcerpc_winreg_QueryInfoKey_r,
		.pack_in_data = (py_data_pack_fn)pack_py_winreg_QueryInfoKey_args_in,
		.unpack_out_data = (py_data_unpack_fn)unpack_py_winreg_QueryInfoKey_args_out,
		.opnum = 16,
		.table = &ndr_table_winreg,
	},
	{
		.name = "QueryValue",
		.doc = "S.QueryValue(handle, value_name, type, data, data_size, data_length) -> (type, data, data_size, data_length)",
		.call = (py_dcerpc_call_fn)dcerpc_winreg_QueryValue_r,
		.pack_in_data = (py_data_pack_fn)pack_py_winreg_QueryValue_args_in,
		.unpack_out_data = (py_data_unpack_fn)unpack_py_winreg_QueryValue_args_out,
		.opnum = 17,
		.table = &ndr_table_winreg,
	},
	{
		.name = "ReplaceKey",
		.doc = "S.ReplaceKey(handle, subkey, new_file, old_file) -> None",
		.call = (py_dcerpc_call_fn)dcerpc_winreg_ReplaceKey_r,
		.pack_in_data = (py_data_pack_fn)pack_py_winreg_ReplaceKey_args_in,
		.unpack_out_data = (py_data_unpack_fn)unpack_py_winreg_ReplaceKey_args_out,
		.opnum = 18,
		.table = &ndr_table_winreg,
	},
	{
		.name = "RestoreKey",
		.doc = "S.RestoreKey(handle, filename, flags) -> None",
		.call = (py_dcerpc_call_fn)dcerpc_winreg_RestoreKey_r,
		.pack_in_data = (py_data_pack_fn)pack_py_winreg_RestoreKey_args_in,
		.unpack_out_data = (py_data_unpack_fn)unpack_py_winreg_RestoreKey_args_out,
		.opnum = 19,
		.table = &ndr_table_winreg,
	},
	{
		.name = "SaveKey",
		.doc = "S.SaveKey(handle, filename, sec_attrib) -> None",
		.call = (py_dcerpc_call_fn)dcerpc_winreg_SaveKey_r,
		.pack_in_data = (py_data_pack_fn)pack_py_winreg_SaveKey_args_in,
		.unpack_out_data = (py_data_unpack_fn)unpack_py_winreg_SaveKey_args_out,
		.opnum = 20,
		.table = &ndr_table_winreg,
	},
	{
		.name = "SetKeySecurity",
		.doc = "S.SetKeySecurity(handle, sec_info, sd) -> None",
		.call = (py_dcerpc_call_fn)dcerpc_winreg_SetKeySecurity_r,
		.pack_in_data = (py_data_pack_fn)pack_py_winreg_SetKeySecurity_args_in,
		.unpack_out_data = (py_data_unpack_fn)unpack_py_winreg_SetKeySecurity_args_out,
		.opnum = 21,
		.table = &ndr_table_winreg,
	},
	{
		.name = "SetValue",
		.doc = "S.SetValue(handle, name, type, data) -> None",
		.call = (py_dcerpc_call_fn)dcerpc_winreg_SetValue_r,
		.pack_in_data = (py_data_pack_fn)pack_py_winreg_SetValue_args_in,
		.unpack_out_data = (py_data_unpack_fn)unpack_py_winreg_SetValue_args_out,
		.opnum = 22,
		.table = &ndr_table_winreg,
	},
	{
		.name = "UnLoadKey",
		.doc = "S.UnLoadKey(handle, subkey) -> None",
		.call = (py_dcerpc_call_fn)dcerpc_winreg_UnLoadKey_r,
		.pack_in_data = (py_data_pack_fn)pack_py_winreg_UnLoadKey_args_in,
		.unpack_out_data = (py_data_unpack_fn)unpack_py_winreg_UnLoadKey_args_out,
		.opnum = 23,
		.table = &ndr_table_winreg,
	},
	{
		.name = "InitiateSystemShutdown",
		.doc = "S.InitiateSystemShutdown(hostname, message, timeout, force_apps, do_reboot) -> None",
		.call = (py_dcerpc_call_fn)dcerpc_winreg_InitiateSystemShutdown_r,
		.pack_in_data = (py_data_pack_fn)pack_py_winreg_InitiateSystemShutdown_args_in,
		.unpack_out_data = (py_data_unpack_fn)unpack_py_winreg_InitiateSystemShutdown_args_out,
		.opnum = 24,
		.table = &ndr_table_winreg,
	},
	{
		.name = "AbortSystemShutdown",
		.doc = "S.AbortSystemShutdown(server) -> None",
		.call = (py_dcerpc_call_fn)dcerpc_winreg_AbortSystemShutdown_r,
		.pack_in_data = (py_data_pack_fn)pack_py_winreg_AbortSystemShutdown_args_in,
		.unpack_out_data = (py_data_unpack_fn)unpack_py_winreg_AbortSystemShutdown_args_out,
		.opnum = 25,
		.table = &ndr_table_winreg,
	},
	{
		.name = "GetVersion",
		.doc = "S.GetVersion(handle) -> version",
		.call = (py_dcerpc_call_fn)dcerpc_winreg_GetVersion_r,
		.pack_in_data = (py_data_pack_fn)pack_py_winreg_GetVersion_args_in,
		.unpack_out_data = (py_data_unpack_fn)unpack_py_winreg_GetVersion_args_out,
		.opnum = 26,
		.table = &ndr_table_winreg,
	},
	{
		.name = "OpenHKCC",
		.doc = "S.OpenHKCC(system_name, access_mask) -> handle",
		.call = (py_dcerpc_call_fn)dcerpc_winreg_OpenHKCC_r,
		.pack_in_data = (py_data_pack_fn)pack_py_winreg_OpenHKCC_args_in,
		.unpack_out_data = (py_data_unpack_fn)unpack_py_winreg_OpenHKCC_args_out,
		.opnum = 27,
		.table = &ndr_table_winreg,
	},
	{
		.name = "OpenHKDD",
		.doc = "S.OpenHKDD(system_name, access_mask) -> handle",
		.call = (py_dcerpc_call_fn)dcerpc_winreg_OpenHKDD_r,
		.pack_in_data = (py_data_pack_fn)pack_py_winreg_OpenHKDD_args_in,
		.unpack_out_data = (py_data_unpack_fn)unpack_py_winreg_OpenHKDD_args_out,
		.opnum = 28,
		.table = &ndr_table_winreg,
	},
	{
		.name = "QueryMultipleValues",
		.doc = "S.QueryMultipleValues(key_handle, values_in, buffer) -> (values_out, buffer)",
		.call = (py_dcerpc_call_fn)dcerpc_winreg_QueryMultipleValues_r,
		.pack_in_data = (py_data_pack_fn)pack_py_winreg_QueryMultipleValues_args_in,
		.unpack_out_data = (py_data_unpack_fn)unpack_py_winreg_QueryMultipleValues_args_out,
		.opnum = 29,
		.table = &ndr_table_winreg,
	},
	{
		.name = "InitiateSystemShutdownEx",
		.doc = "S.InitiateSystemShutdownEx(hostname, message, timeout, force_apps, do_reboot, reason) -> None",
		.call = (py_dcerpc_call_fn)dcerpc_winreg_InitiateSystemShutdownEx_r,
		.pack_in_data = (py_data_pack_fn)pack_py_winreg_InitiateSystemShutdownEx_args_in,
		.unpack_out_data = (py_data_unpack_fn)unpack_py_winreg_InitiateSystemShutdownEx_args_out,
		.opnum = 30,
		.table = &ndr_table_winreg,
	},
	{
		.name = "SaveKeyEx",
		.doc = "S.SaveKeyEx(handle, filename, sec_attrib, flags) -> None",
		.call = (py_dcerpc_call_fn)dcerpc_winreg_SaveKeyEx_r,
		.pack_in_data = (py_data_pack_fn)pack_py_winreg_SaveKeyEx_args_in,
		.unpack_out_data = (py_data_unpack_fn)unpack_py_winreg_SaveKeyEx_args_out,
		.opnum = 31,
		.table = &ndr_table_winreg,
	},
	{
		.name = "OpenHKPT",
		.doc = "S.OpenHKPT(system_name, access_mask) -> handle",
		.call = (py_dcerpc_call_fn)dcerpc_winreg_OpenHKPT_r,
		.pack_in_data = (py_data_pack_fn)pack_py_winreg_OpenHKPT_args_in,
		.unpack_out_data = (py_data_unpack_fn)unpack_py_winreg_OpenHKPT_args_out,
		.opnum = 32,
		.table = &ndr_table_winreg,
	},
	{
		.name = "OpenHKPN",
		.doc = "S.OpenHKPN(system_name, access_mask) -> handle",
		.call = (py_dcerpc_call_fn)dcerpc_winreg_OpenHKPN_r,
		.pack_in_data = (py_data_pack_fn)pack_py_winreg_OpenHKPN_args_in,
		.unpack_out_data = (py_data_unpack_fn)unpack_py_winreg_OpenHKPN_args_out,
		.opnum = 33,
		.table = &ndr_table_winreg,
	},
	{
		.name = "QueryMultipleValues2",
		.doc = "S.QueryMultipleValues2(key_handle, values_in, buffer) -> (values_out, buffer, needed)",
		.call = (py_dcerpc_call_fn)dcerpc_winreg_QueryMultipleValues2_r,
		.pack_in_data = (py_data_pack_fn)pack_py_winreg_QueryMultipleValues2_args_in,
		.unpack_out_data = (py_data_unpack_fn)unpack_py_winreg_QueryMultipleValues2_args_out,
		.opnum = 34,
		.table = &ndr_table_winreg,
	},
	{
		.name = "DeleteKeyEx",
		.doc = "S.DeleteKeyEx(handle, key, access_mask, reserved) -> None",
		.call = (py_dcerpc_call_fn)dcerpc_winreg_DeleteKeyEx_r,
		.pack_in_data = (py_data_pack_fn)pack_py_winreg_DeleteKeyEx_args_in,
		.unpack_out_data = (py_data_unpack_fn)unpack_py_winreg_DeleteKeyEx_args_out,
		.opnum = 35,
		.table = &ndr_table_winreg,
	},
	{
		.name = NULL,
	},
};

static PyObject *interface_winreg_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return py_dcerpc_interface_init_helper(type, args, kwargs, &ndr_table_winreg);
}

#define PY_DOC_WINREG "Remote Registry Service"
static PyTypeObject winreg_InterfaceType = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "winreg.winreg",
	.tp_basicsize = sizeof(dcerpc_InterfaceObject),
	.tp_doc = "winreg(binding, lp_ctx=None, credentials=None, basis_connection=None) -> connection\n"
"\n\n"
"Parameters\n"
"----------\n"
"binding : str\n"
"    A DCE/RPC binding string (for example: ncacn_ip_tcp:127.0.0.1)\n"
"lp_ctx : param.LoadParm\n"
"    Should be a path to a smb.conf file or a param.LoadParm object\n"
"credentials : credentials.Credentials, optional\n"
"    A credentials.Credentials object (default is None).\n"
"basis_connection : samba.dcerpc.ClientConnection, optional\n"
"    A winreg client connection object (default is None).\n"
"\n\n"
"Returns\n"
"-------\n"
"samba.dcerpc.ClientConnection\n"
"    A ClientConnection object\n"
"\n\n"
"Raises\n"
"------\n"
"samba.NTSTATUSError\n"
"    An NTSTATUS error\n"
"\n"PY_DOC_WINREG,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = interface_winreg_new,
};

static PyObject *syntax_winreg_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return py_dcerpc_syntax_init_helper(type, args, kwargs, &ndr_table_winreg.syntax_id);
}

#define PY_DOC_WINREG_SYNTAX "Remote Registry Service"
static PyTypeObject winreg_SyntaxType = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "winreg.winreg_abstract_syntax",
	.tp_doc = "winreg_abstract_syntax()\n"PY_DOC_WINREG_SYNTAX,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = syntax_winreg_new,
};

static PyMethodDef winreg_methods[] = {
	{ NULL, NULL, 0, NULL }
};

static struct PyModuleDef moduledef = {
	PyModuleDef_HEAD_INIT,
	.m_name = "winreg",
	.m_doc = "winreg DCE/RPC",
	.m_size = -1,
	.m_methods = winreg_methods,
};
MODULE_INIT_FUNC(winreg)
{
	PyObject *m = NULL;
	PyObject *dep_samba_dcerpc_lsa = NULL;
	PyObject *dep_samba_dcerpc_security = NULL;
	PyObject *dep_samba_dcerpc_misc = NULL;
	PyObject *dep_talloc = NULL;
	PyObject *dep_samba_dcerpc_base = NULL;

	dep_samba_dcerpc_lsa = PyImport_ImportModule("samba.dcerpc.lsa");
	if (dep_samba_dcerpc_lsa == NULL)
		goto out;

	dep_samba_dcerpc_security = PyImport_ImportModule("samba.dcerpc.security");
	if (dep_samba_dcerpc_security == NULL)
		goto out;

	dep_samba_dcerpc_misc = PyImport_ImportModule("samba.dcerpc.misc");
	if (dep_samba_dcerpc_misc == NULL)
		goto out;

	dep_talloc = PyImport_ImportModule("talloc");
	if (dep_talloc == NULL)
		goto out;

	dep_samba_dcerpc_base = PyImport_ImportModule("samba.dcerpc.base");
	if (dep_samba_dcerpc_base == NULL)
		goto out;

	BaseObject_Type = (PyTypeObject *)PyObject_GetAttrString(dep_talloc, "BaseObject");
	if (BaseObject_Type == NULL)
		goto out;

	policy_handle_Type = (PyTypeObject *)PyObject_GetAttrString(dep_samba_dcerpc_misc, "policy_handle");
	if (policy_handle_Type == NULL)
		goto out;

	lsa_StringLarge_Type = (PyTypeObject *)PyObject_GetAttrString(dep_samba_dcerpc_lsa, "StringLarge");
	if (lsa_StringLarge_Type == NULL)
		goto out;

	ClientConnection_Type = (PyTypeObject *)PyObject_GetAttrString(dep_samba_dcerpc_base, "ClientConnection");
	if (ClientConnection_Type == NULL)
		goto out;

	ndr_syntax_id_Type = (PyTypeObject *)PyObject_GetAttrString(dep_samba_dcerpc_misc, "ndr_syntax_id");
	if (ndr_syntax_id_Type == NULL)
		goto out;

	winreg_String_Type.tp_base = BaseObject_Type;
	winreg_String_Type.tp_basicsize = pytalloc_BaseObject_size();

	KeySecurityData_Type.tp_base = BaseObject_Type;
	KeySecurityData_Type.tp_basicsize = pytalloc_BaseObject_size();

	winreg_SecBuf_Type.tp_base = BaseObject_Type;
	winreg_SecBuf_Type.tp_basicsize = pytalloc_BaseObject_size();

	winreg_StringBuf_Type.tp_base = BaseObject_Type;
	winreg_StringBuf_Type.tp_basicsize = pytalloc_BaseObject_size();

	winreg_ValNameBuf_Type.tp_base = BaseObject_Type;
	winreg_ValNameBuf_Type.tp_basicsize = pytalloc_BaseObject_size();

	KeySecurityAttribute_Type.tp_base = BaseObject_Type;
	KeySecurityAttribute_Type.tp_basicsize = pytalloc_BaseObject_size();

	QueryMultipleValue_Type.tp_base = BaseObject_Type;
	QueryMultipleValue_Type.tp_basicsize = pytalloc_BaseObject_size();

	winreg_OpenHKCR_Type.tp_base = BaseObject_Type;
	winreg_OpenHKCR_Type.tp_basicsize = pytalloc_BaseObject_size();

	winreg_OpenHKCU_Type.tp_base = BaseObject_Type;
	winreg_OpenHKCU_Type.tp_basicsize = pytalloc_BaseObject_size();

	winreg_OpenHKLM_Type.tp_base = BaseObject_Type;
	winreg_OpenHKLM_Type.tp_basicsize = pytalloc_BaseObject_size();

	winreg_OpenHKPD_Type.tp_base = BaseObject_Type;
	winreg_OpenHKPD_Type.tp_basicsize = pytalloc_BaseObject_size();

	winreg_OpenHKU_Type.tp_base = BaseObject_Type;
	winreg_OpenHKU_Type.tp_basicsize = pytalloc_BaseObject_size();

	winreg_CloseKey_Type.tp_base = BaseObject_Type;
	winreg_CloseKey_Type.tp_basicsize = pytalloc_BaseObject_size();

	winreg_CreateKey_Type.tp_base = BaseObject_Type;
	winreg_CreateKey_Type.tp_basicsize = pytalloc_BaseObject_size();

	winreg_DeleteKey_Type.tp_base = BaseObject_Type;
	winreg_DeleteKey_Type.tp_basicsize = pytalloc_BaseObject_size();

	winreg_DeleteValue_Type.tp_base = BaseObject_Type;
	winreg_DeleteValue_Type.tp_basicsize = pytalloc_BaseObject_size();

	winreg_EnumKey_Type.tp_base = BaseObject_Type;
	winreg_EnumKey_Type.tp_basicsize = pytalloc_BaseObject_size();

	winreg_EnumValue_Type.tp_base = BaseObject_Type;
	winreg_EnumValue_Type.tp_basicsize = pytalloc_BaseObject_size();

	winreg_FlushKey_Type.tp_base = BaseObject_Type;
	winreg_FlushKey_Type.tp_basicsize = pytalloc_BaseObject_size();

	winreg_GetKeySecurity_Type.tp_base = BaseObject_Type;
	winreg_GetKeySecurity_Type.tp_basicsize = pytalloc_BaseObject_size();

	winreg_LoadKey_Type.tp_base = BaseObject_Type;
	winreg_LoadKey_Type.tp_basicsize = pytalloc_BaseObject_size();

	winreg_NotifyChangeKeyValue_Type.tp_base = BaseObject_Type;
	winreg_NotifyChangeKeyValue_Type.tp_basicsize = pytalloc_BaseObject_size();

	winreg_OpenKey_Type.tp_base = BaseObject_Type;
	winreg_OpenKey_Type.tp_basicsize = pytalloc_BaseObject_size();

	winreg_QueryInfoKey_Type.tp_base = BaseObject_Type;
	winreg_QueryInfoKey_Type.tp_basicsize = pytalloc_BaseObject_size();

	winreg_QueryValue_Type.tp_base = BaseObject_Type;
	winreg_QueryValue_Type.tp_basicsize = pytalloc_BaseObject_size();

	winreg_ReplaceKey_Type.tp_base = BaseObject_Type;
	winreg_ReplaceKey_Type.tp_basicsize = pytalloc_BaseObject_size();

	winreg_RestoreKey_Type.tp_base = BaseObject_Type;
	winreg_RestoreKey_Type.tp_basicsize = pytalloc_BaseObject_size();

	winreg_SaveKey_Type.tp_base = BaseObject_Type;
	winreg_SaveKey_Type.tp_basicsize = pytalloc_BaseObject_size();

	winreg_SetKeySecurity_Type.tp_base = BaseObject_Type;
	winreg_SetKeySecurity_Type.tp_basicsize = pytalloc_BaseObject_size();

	winreg_SetValue_Type.tp_base = BaseObject_Type;
	winreg_SetValue_Type.tp_basicsize = pytalloc_BaseObject_size();

	winreg_UnLoadKey_Type.tp_base = BaseObject_Type;
	winreg_UnLoadKey_Type.tp_basicsize = pytalloc_BaseObject_size();

	winreg_InitiateSystemShutdown_Type.tp_base = BaseObject_Type;
	winreg_InitiateSystemShutdown_Type.tp_basicsize = pytalloc_BaseObject_size();

	winreg_AbortSystemShutdown_Type.tp_base = BaseObject_Type;
	winreg_AbortSystemShutdown_Type.tp_basicsize = pytalloc_BaseObject_size();

	winreg_GetVersion_Type.tp_base = BaseObject_Type;
	winreg_GetVersion_Type.tp_basicsize = pytalloc_BaseObject_size();

	winreg_OpenHKCC_Type.tp_base = BaseObject_Type;
	winreg_OpenHKCC_Type.tp_basicsize = pytalloc_BaseObject_size();

	winreg_OpenHKDD_Type.tp_base = BaseObject_Type;
	winreg_OpenHKDD_Type.tp_basicsize = pytalloc_BaseObject_size();

	winreg_QueryMultipleValues_Type.tp_base = BaseObject_Type;
	winreg_QueryMultipleValues_Type.tp_basicsize = pytalloc_BaseObject_size();

	winreg_InitiateSystemShutdownEx_Type.tp_base = BaseObject_Type;
	winreg_InitiateSystemShutdownEx_Type.tp_basicsize = pytalloc_BaseObject_size();

	winreg_SaveKeyEx_Type.tp_base = BaseObject_Type;
	winreg_SaveKeyEx_Type.tp_basicsize = pytalloc_BaseObject_size();

	winreg_OpenHKPT_Type.tp_base = BaseObject_Type;
	winreg_OpenHKPT_Type.tp_basicsize = pytalloc_BaseObject_size();

	winreg_OpenHKPN_Type.tp_base = BaseObject_Type;
	winreg_OpenHKPN_Type.tp_basicsize = pytalloc_BaseObject_size();

	winreg_QueryMultipleValues2_Type.tp_base = BaseObject_Type;
	winreg_QueryMultipleValues2_Type.tp_basicsize = pytalloc_BaseObject_size();

	winreg_DeleteKeyEx_Type.tp_base = BaseObject_Type;
	winreg_DeleteKeyEx_Type.tp_basicsize = pytalloc_BaseObject_size();

	winreg_InterfaceType.tp_base = ClientConnection_Type;

	winreg_SyntaxType.tp_base = ndr_syntax_id_Type;
	winreg_SyntaxType.tp_basicsize = pytalloc_BaseObject_size();

	if (PyType_Ready(&winreg_String_Type) < 0)
		goto out;
	if (PyType_Ready(&KeySecurityData_Type) < 0)
		goto out;
	if (PyType_Ready(&winreg_SecBuf_Type) < 0)
		goto out;
	if (PyType_Ready(&winreg_StringBuf_Type) < 0)
		goto out;
	if (PyType_Ready(&winreg_ValNameBuf_Type) < 0)
		goto out;
	if (PyType_Ready(&KeySecurityAttribute_Type) < 0)
		goto out;
	if (PyType_Ready(&QueryMultipleValue_Type) < 0)
		goto out;
	if (PyType_Ready(&winreg_OpenHKCR_Type) < 0)
		goto out;
	if (PyType_Ready(&winreg_OpenHKCU_Type) < 0)
		goto out;
	if (PyType_Ready(&winreg_OpenHKLM_Type) < 0)
		goto out;
	if (PyType_Ready(&winreg_OpenHKPD_Type) < 0)
		goto out;
	if (PyType_Ready(&winreg_OpenHKU_Type) < 0)
		goto out;
	if (PyType_Ready(&winreg_CloseKey_Type) < 0)
		goto out;
	if (PyType_Ready(&winreg_CreateKey_Type) < 0)
		goto out;
	if (PyType_Ready(&winreg_DeleteKey_Type) < 0)
		goto out;
	if (PyType_Ready(&winreg_DeleteValue_Type) < 0)
		goto out;
	if (PyType_Ready(&winreg_EnumKey_Type) < 0)
		goto out;
	if (PyType_Ready(&winreg_EnumValue_Type) < 0)
		goto out;
	if (PyType_Ready(&winreg_FlushKey_Type) < 0)
		goto out;
	if (PyType_Ready(&winreg_GetKeySecurity_Type) < 0)
		goto out;
	if (PyType_Ready(&winreg_LoadKey_Type) < 0)
		goto out;
	if (PyType_Ready(&winreg_NotifyChangeKeyValue_Type) < 0)
		goto out;
	if (PyType_Ready(&winreg_OpenKey_Type) < 0)
		goto out;
	if (PyType_Ready(&winreg_QueryInfoKey_Type) < 0)
		goto out;
	if (PyType_Ready(&winreg_QueryValue_Type) < 0)
		goto out;
	if (PyType_Ready(&winreg_ReplaceKey_Type) < 0)
		goto out;
	if (PyType_Ready(&winreg_RestoreKey_Type) < 0)
		goto out;
	if (PyType_Ready(&winreg_SaveKey_Type) < 0)
		goto out;
	if (PyType_Ready(&winreg_SetKeySecurity_Type) < 0)
		goto out;
	if (PyType_Ready(&winreg_SetValue_Type) < 0)
		goto out;
	if (PyType_Ready(&winreg_UnLoadKey_Type) < 0)
		goto out;
	if (PyType_Ready(&winreg_InitiateSystemShutdown_Type) < 0)
		goto out;
	if (PyType_Ready(&winreg_AbortSystemShutdown_Type) < 0)
		goto out;
	if (PyType_Ready(&winreg_GetVersion_Type) < 0)
		goto out;
	if (PyType_Ready(&winreg_OpenHKCC_Type) < 0)
		goto out;
	if (PyType_Ready(&winreg_OpenHKDD_Type) < 0)
		goto out;
	if (PyType_Ready(&winreg_QueryMultipleValues_Type) < 0)
		goto out;
	if (PyType_Ready(&winreg_InitiateSystemShutdownEx_Type) < 0)
		goto out;
	if (PyType_Ready(&winreg_SaveKeyEx_Type) < 0)
		goto out;
	if (PyType_Ready(&winreg_OpenHKPT_Type) < 0)
		goto out;
	if (PyType_Ready(&winreg_OpenHKPN_Type) < 0)
		goto out;
	if (PyType_Ready(&winreg_QueryMultipleValues2_Type) < 0)
		goto out;
	if (PyType_Ready(&winreg_DeleteKeyEx_Type) < 0)
		goto out;
	if (PyType_Ready(&winreg_InterfaceType) < 0)
		goto out;
	if (PyType_Ready(&winreg_SyntaxType) < 0)
		goto out;
	if (!PyInterface_AddNdrRpcMethods(&winreg_InterfaceType, py_ndr_winreg_methods))
		return NULL;

#ifdef PY_STRING_PATCH
	PY_STRING_PATCH(&winreg_String_Type);
#endif
#ifdef PY_KEYSECURITYDATA_PATCH
	PY_KEYSECURITYDATA_PATCH(&KeySecurityData_Type);
#endif
#ifdef PY_SECBUF_PATCH
	PY_SECBUF_PATCH(&winreg_SecBuf_Type);
#endif
#ifdef PY_STRINGBUF_PATCH
	PY_STRINGBUF_PATCH(&winreg_StringBuf_Type);
#endif
#ifdef PY_VALNAMEBUF_PATCH
	PY_VALNAMEBUF_PATCH(&winreg_ValNameBuf_Type);
#endif
#ifdef PY_KEYSECURITYATTRIBUTE_PATCH
	PY_KEYSECURITYATTRIBUTE_PATCH(&KeySecurityAttribute_Type);
#endif
#ifdef PY_QUERYMULTIPLEVALUE_PATCH
	PY_QUERYMULTIPLEVALUE_PATCH(&QueryMultipleValue_Type);
#endif
#ifdef PY_OPENHKCR_PATCH
	PY_OPENHKCR_PATCH(&winreg_OpenHKCR_Type);
#endif
#ifdef PY_OPENHKCU_PATCH
	PY_OPENHKCU_PATCH(&winreg_OpenHKCU_Type);
#endif
#ifdef PY_OPENHKLM_PATCH
	PY_OPENHKLM_PATCH(&winreg_OpenHKLM_Type);
#endif
#ifdef PY_OPENHKPD_PATCH
	PY_OPENHKPD_PATCH(&winreg_OpenHKPD_Type);
#endif
#ifdef PY_OPENHKU_PATCH
	PY_OPENHKU_PATCH(&winreg_OpenHKU_Type);
#endif
#ifdef PY_CLOSEKEY_PATCH
	PY_CLOSEKEY_PATCH(&winreg_CloseKey_Type);
#endif
#ifdef PY_CREATEKEY_PATCH
	PY_CREATEKEY_PATCH(&winreg_CreateKey_Type);
#endif
#ifdef PY_DELETEKEY_PATCH
	PY_DELETEKEY_PATCH(&winreg_DeleteKey_Type);
#endif
#ifdef PY_DELETEVALUE_PATCH
	PY_DELETEVALUE_PATCH(&winreg_DeleteValue_Type);
#endif
#ifdef PY_ENUMKEY_PATCH
	PY_ENUMKEY_PATCH(&winreg_EnumKey_Type);
#endif
#ifdef PY_ENUMVALUE_PATCH
	PY_ENUMVALUE_PATCH(&winreg_EnumValue_Type);
#endif
#ifdef PY_FLUSHKEY_PATCH
	PY_FLUSHKEY_PATCH(&winreg_FlushKey_Type);
#endif
#ifdef PY_GETKEYSECURITY_PATCH
	PY_GETKEYSECURITY_PATCH(&winreg_GetKeySecurity_Type);
#endif
#ifdef PY_LOADKEY_PATCH
	PY_LOADKEY_PATCH(&winreg_LoadKey_Type);
#endif
#ifdef PY_NOTIFYCHANGEKEYVALUE_PATCH
	PY_NOTIFYCHANGEKEYVALUE_PATCH(&winreg_NotifyChangeKeyValue_Type);
#endif
#ifdef PY_OPENKEY_PATCH
	PY_OPENKEY_PATCH(&winreg_OpenKey_Type);
#endif
#ifdef PY_QUERYINFOKEY_PATCH
	PY_QUERYINFOKEY_PATCH(&winreg_QueryInfoKey_Type);
#endif
#ifdef PY_QUERYVALUE_PATCH
	PY_QUERYVALUE_PATCH(&winreg_QueryValue_Type);
#endif
#ifdef PY_REPLACEKEY_PATCH
	PY_REPLACEKEY_PATCH(&winreg_ReplaceKey_Type);
#endif
#ifdef PY_RESTOREKEY_PATCH
	PY_RESTOREKEY_PATCH(&winreg_RestoreKey_Type);
#endif
#ifdef PY_SAVEKEY_PATCH
	PY_SAVEKEY_PATCH(&winreg_SaveKey_Type);
#endif
#ifdef PY_SETKEYSECURITY_PATCH
	PY_SETKEYSECURITY_PATCH(&winreg_SetKeySecurity_Type);
#endif
#ifdef PY_SETVALUE_PATCH
	PY_SETVALUE_PATCH(&winreg_SetValue_Type);
#endif
#ifdef PY_UNLOADKEY_PATCH
	PY_UNLOADKEY_PATCH(&winreg_UnLoadKey_Type);
#endif
#ifdef PY_INITIATESYSTEMSHUTDOWN_PATCH
	PY_INITIATESYSTEMSHUTDOWN_PATCH(&winreg_InitiateSystemShutdown_Type);
#endif
#ifdef PY_ABORTSYSTEMSHUTDOWN_PATCH
	PY_ABORTSYSTEMSHUTDOWN_PATCH(&winreg_AbortSystemShutdown_Type);
#endif
#ifdef PY_GETVERSION_PATCH
	PY_GETVERSION_PATCH(&winreg_GetVersion_Type);
#endif
#ifdef PY_OPENHKCC_PATCH
	PY_OPENHKCC_PATCH(&winreg_OpenHKCC_Type);
#endif
#ifdef PY_OPENHKDD_PATCH
	PY_OPENHKDD_PATCH(&winreg_OpenHKDD_Type);
#endif
#ifdef PY_QUERYMULTIPLEVALUES_PATCH
	PY_QUERYMULTIPLEVALUES_PATCH(&winreg_QueryMultipleValues_Type);
#endif
#ifdef PY_INITIATESYSTEMSHUTDOWNEX_PATCH
	PY_INITIATESYSTEMSHUTDOWNEX_PATCH(&winreg_InitiateSystemShutdownEx_Type);
#endif
#ifdef PY_SAVEKEYEX_PATCH
	PY_SAVEKEYEX_PATCH(&winreg_SaveKeyEx_Type);
#endif
#ifdef PY_OPENHKPT_PATCH
	PY_OPENHKPT_PATCH(&winreg_OpenHKPT_Type);
#endif
#ifdef PY_OPENHKPN_PATCH
	PY_OPENHKPN_PATCH(&winreg_OpenHKPN_Type);
#endif
#ifdef PY_QUERYMULTIPLEVALUES2_PATCH
	PY_QUERYMULTIPLEVALUES2_PATCH(&winreg_QueryMultipleValues2_Type);
#endif
#ifdef PY_DELETEKEYEX_PATCH
	PY_DELETEKEYEX_PATCH(&winreg_DeleteKeyEx_Type);
#endif
#ifdef PY_WINREG_PATCH
	PY_WINREG_PATCH(&winreg_InterfaceType);
#endif
#ifdef PY_WINREG_ABSTRACT_SYNTAX_PATCH
	PY_WINREG_ABSTRACT_SYNTAX_PATCH(&winreg_SyntaxType);
#endif
#ifdef PY_ABSTRACT_SYNTAX_PATCH
	PY_ABSTRACT_SYNTAX_PATCH(&winreg_SyntaxType);
#endif

	m = PyModule_Create(&moduledef);
	if (m == NULL)
		goto out;

	PyModule_AddObject(m, "REG_KEY_READ", PyLong_FromLong((STANDARD_RIGHTS_READ_ACCESS|KEY_QUERY_VALUE|KEY_ENUMERATE_SUB_KEYS|KEY_NOTIFY)));
	PyModule_AddObject(m, "REG_KEY_EXECUTE", PyLong_FromLong(REG_KEY_READ));
	PyModule_AddObject(m, "REG_KEY_WRITE", PyLong_FromLong((STANDARD_RIGHTS_WRITE_ACCESS|KEY_SET_VALUE|KEY_CREATE_SUB_KEY)));
	PyModule_AddObject(m, "REG_KEY_ALL", PyLong_FromLong((STANDARD_RIGHTS_REQUIRED_ACCESS|REG_KEY_READ|REG_KEY_WRITE|KEY_CREATE_LINK)));
	PyModule_AddObject(m, "REG_OPTION_NON_VOLATILE", PyLong_FromUnsignedLongLong(0x00000000));
	PyModule_AddObject(m, "KEY_QUERY_VALUE", PyLong_FromUnsignedLongLong((uint32_t)(KEY_QUERY_VALUE)));
	PyModule_AddObject(m, "KEY_SET_VALUE", PyLong_FromUnsignedLongLong((uint32_t)(KEY_SET_VALUE)));
	PyModule_AddObject(m, "KEY_CREATE_SUB_KEY", PyLong_FromUnsignedLongLong((uint32_t)(KEY_CREATE_SUB_KEY)));
	PyModule_AddObject(m, "KEY_ENUMERATE_SUB_KEYS", PyLong_FromUnsignedLongLong((uint32_t)(KEY_ENUMERATE_SUB_KEYS)));
	PyModule_AddObject(m, "KEY_NOTIFY", PyLong_FromUnsignedLongLong((uint32_t)(KEY_NOTIFY)));
	PyModule_AddObject(m, "KEY_CREATE_LINK", PyLong_FromUnsignedLongLong((uint32_t)(KEY_CREATE_LINK)));
	PyModule_AddObject(m, "KEY_WOW64_64KEY", PyLong_FromUnsignedLongLong((uint32_t)(KEY_WOW64_64KEY)));
	PyModule_AddObject(m, "KEY_WOW64_32KEY", PyLong_FromUnsignedLongLong((uint32_t)(KEY_WOW64_32KEY)));
	PyModule_AddObject(m, "REG_OPTION_VOLATILE", PyLong_FromUnsignedLongLong((uint32_t)(REG_OPTION_VOLATILE)));
	PyModule_AddObject(m, "REG_OPTION_CREATE_LINK", PyLong_FromUnsignedLongLong((uint32_t)(REG_OPTION_CREATE_LINK)));
	PyModule_AddObject(m, "REG_OPTION_BACKUP_RESTORE", PyLong_FromUnsignedLongLong((uint32_t)(REG_OPTION_BACKUP_RESTORE)));
	PyModule_AddObject(m, "REG_OPTION_OPEN_LINK", PyLong_FromUnsignedLongLong((uint32_t)(REG_OPTION_OPEN_LINK)));
	PyModule_AddObject(m, "REG_ACTION_NONE", PyLong_FromUnsignedLongLong((uint32_t)(REG_ACTION_NONE)));
	PyModule_AddObject(m, "REG_CREATED_NEW_KEY", PyLong_FromUnsignedLongLong((uint32_t)(REG_CREATED_NEW_KEY)));
	PyModule_AddObject(m, "REG_OPENED_EXISTING_KEY", PyLong_FromUnsignedLongLong((uint32_t)(REG_OPENED_EXISTING_KEY)));
	PyModule_AddObject(m, "REG_NOTIFY_CHANGE_NAME", PyLong_FromUnsignedLongLong((uint32_t)(REG_NOTIFY_CHANGE_NAME)));
	PyModule_AddObject(m, "REG_NOTIFY_CHANGE_ATTRIBUTES", PyLong_FromUnsignedLongLong((uint32_t)(REG_NOTIFY_CHANGE_ATTRIBUTES)));
	PyModule_AddObject(m, "REG_NOTIFY_CHANGE_LAST_SET", PyLong_FromUnsignedLongLong((uint32_t)(REG_NOTIFY_CHANGE_LAST_SET)));
	PyModule_AddObject(m, "REG_NOTIFY_CHANGE_SECURITY", PyLong_FromUnsignedLongLong((uint32_t)(REG_NOTIFY_CHANGE_SECURITY)));
	PyModule_AddObject(m, "REG_WHOLE_HIVE_VOLATILE", PyLong_FromUnsignedLongLong((uint32_t)(REG_WHOLE_HIVE_VOLATILE)));
	PyModule_AddObject(m, "REG_REFRESH_HIVE", PyLong_FromUnsignedLongLong((uint32_t)(REG_REFRESH_HIVE)));
	PyModule_AddObject(m, "REG_NO_LAZY_FLUSH", PyLong_FromUnsignedLongLong((uint32_t)(REG_NO_LAZY_FLUSH)));
	PyModule_AddObject(m, "REG_FORCE_RESTORE", PyLong_FromUnsignedLongLong((uint32_t)(REG_FORCE_RESTORE)));
	Py_INCREF((PyObject *)(void *)&winreg_String_Type);
	PyModule_AddObject(m, "String", (PyObject *)(void *)&winreg_String_Type);
	Py_INCREF((PyObject *)(void *)&KeySecurityData_Type);
	PyModule_AddObject(m, "KeySecurityData", (PyObject *)(void *)&KeySecurityData_Type);
	Py_INCREF((PyObject *)(void *)&winreg_SecBuf_Type);
	PyModule_AddObject(m, "SecBuf", (PyObject *)(void *)&winreg_SecBuf_Type);
	Py_INCREF((PyObject *)(void *)&winreg_StringBuf_Type);
	PyModule_AddObject(m, "StringBuf", (PyObject *)(void *)&winreg_StringBuf_Type);
	Py_INCREF((PyObject *)(void *)&winreg_ValNameBuf_Type);
	PyModule_AddObject(m, "ValNameBuf", (PyObject *)(void *)&winreg_ValNameBuf_Type);
	Py_INCREF((PyObject *)(void *)&KeySecurityAttribute_Type);
	PyModule_AddObject(m, "KeySecurityAttribute", (PyObject *)(void *)&KeySecurityAttribute_Type);
	Py_INCREF((PyObject *)(void *)&QueryMultipleValue_Type);
	PyModule_AddObject(m, "QueryMultipleValue", (PyObject *)(void *)&QueryMultipleValue_Type);
	Py_INCREF((PyObject *)(void *)&winreg_OpenHKCR_Type);
	PyModule_AddObject(m, "OpenHKCR", (PyObject *)(void *)&winreg_OpenHKCR_Type);
	Py_INCREF((PyObject *)(void *)&winreg_OpenHKCU_Type);
	PyModule_AddObject(m, "OpenHKCU", (PyObject *)(void *)&winreg_OpenHKCU_Type);
	Py_INCREF((PyObject *)(void *)&winreg_OpenHKLM_Type);
	PyModule_AddObject(m, "OpenHKLM", (PyObject *)(void *)&winreg_OpenHKLM_Type);
	Py_INCREF((PyObject *)(void *)&winreg_OpenHKPD_Type);
	PyModule_AddObject(m, "OpenHKPD", (PyObject *)(void *)&winreg_OpenHKPD_Type);
	Py_INCREF((PyObject *)(void *)&winreg_OpenHKU_Type);
	PyModule_AddObject(m, "OpenHKU", (PyObject *)(void *)&winreg_OpenHKU_Type);
	Py_INCREF((PyObject *)(void *)&winreg_CloseKey_Type);
	PyModule_AddObject(m, "CloseKey", (PyObject *)(void *)&winreg_CloseKey_Type);
	Py_INCREF((PyObject *)(void *)&winreg_CreateKey_Type);
	PyModule_AddObject(m, "CreateKey", (PyObject *)(void *)&winreg_CreateKey_Type);
	Py_INCREF((PyObject *)(void *)&winreg_DeleteKey_Type);
	PyModule_AddObject(m, "DeleteKey", (PyObject *)(void *)&winreg_DeleteKey_Type);
	Py_INCREF((PyObject *)(void *)&winreg_DeleteValue_Type);
	PyModule_AddObject(m, "DeleteValue", (PyObject *)(void *)&winreg_DeleteValue_Type);
	Py_INCREF((PyObject *)(void *)&winreg_EnumKey_Type);
	PyModule_AddObject(m, "EnumKey", (PyObject *)(void *)&winreg_EnumKey_Type);
	Py_INCREF((PyObject *)(void *)&winreg_EnumValue_Type);
	PyModule_AddObject(m, "EnumValue", (PyObject *)(void *)&winreg_EnumValue_Type);
	Py_INCREF((PyObject *)(void *)&winreg_FlushKey_Type);
	PyModule_AddObject(m, "FlushKey", (PyObject *)(void *)&winreg_FlushKey_Type);
	Py_INCREF((PyObject *)(void *)&winreg_GetKeySecurity_Type);
	PyModule_AddObject(m, "GetKeySecurity", (PyObject *)(void *)&winreg_GetKeySecurity_Type);
	Py_INCREF((PyObject *)(void *)&winreg_LoadKey_Type);
	PyModule_AddObject(m, "LoadKey", (PyObject *)(void *)&winreg_LoadKey_Type);
	Py_INCREF((PyObject *)(void *)&winreg_NotifyChangeKeyValue_Type);
	PyModule_AddObject(m, "NotifyChangeKeyValue", (PyObject *)(void *)&winreg_NotifyChangeKeyValue_Type);
	Py_INCREF((PyObject *)(void *)&winreg_OpenKey_Type);
	PyModule_AddObject(m, "OpenKey", (PyObject *)(void *)&winreg_OpenKey_Type);
	Py_INCREF((PyObject *)(void *)&winreg_QueryInfoKey_Type);
	PyModule_AddObject(m, "QueryInfoKey", (PyObject *)(void *)&winreg_QueryInfoKey_Type);
	Py_INCREF((PyObject *)(void *)&winreg_QueryValue_Type);
	PyModule_AddObject(m, "QueryValue", (PyObject *)(void *)&winreg_QueryValue_Type);
	Py_INCREF((PyObject *)(void *)&winreg_ReplaceKey_Type);
	PyModule_AddObject(m, "ReplaceKey", (PyObject *)(void *)&winreg_ReplaceKey_Type);
	Py_INCREF((PyObject *)(void *)&winreg_RestoreKey_Type);
	PyModule_AddObject(m, "RestoreKey", (PyObject *)(void *)&winreg_RestoreKey_Type);
	Py_INCREF((PyObject *)(void *)&winreg_SaveKey_Type);
	PyModule_AddObject(m, "SaveKey", (PyObject *)(void *)&winreg_SaveKey_Type);
	Py_INCREF((PyObject *)(void *)&winreg_SetKeySecurity_Type);
	PyModule_AddObject(m, "SetKeySecurity", (PyObject *)(void *)&winreg_SetKeySecurity_Type);
	Py_INCREF((PyObject *)(void *)&winreg_SetValue_Type);
	PyModule_AddObject(m, "SetValue", (PyObject *)(void *)&winreg_SetValue_Type);
	Py_INCREF((PyObject *)(void *)&winreg_UnLoadKey_Type);
	PyModule_AddObject(m, "UnLoadKey", (PyObject *)(void *)&winreg_UnLoadKey_Type);
	Py_INCREF((PyObject *)(void *)&winreg_InitiateSystemShutdown_Type);
	PyModule_AddObject(m, "InitiateSystemShutdown", (PyObject *)(void *)&winreg_InitiateSystemShutdown_Type);
	Py_INCREF((PyObject *)(void *)&winreg_AbortSystemShutdown_Type);
	PyModule_AddObject(m, "AbortSystemShutdown", (PyObject *)(void *)&winreg_AbortSystemShutdown_Type);
	Py_INCREF((PyObject *)(void *)&winreg_GetVersion_Type);
	PyModule_AddObject(m, "GetVersion", (PyObject *)(void *)&winreg_GetVersion_Type);
	Py_INCREF((PyObject *)(void *)&winreg_OpenHKCC_Type);
	PyModule_AddObject(m, "OpenHKCC", (PyObject *)(void *)&winreg_OpenHKCC_Type);
	Py_INCREF((PyObject *)(void *)&winreg_OpenHKDD_Type);
	PyModule_AddObject(m, "OpenHKDD", (PyObject *)(void *)&winreg_OpenHKDD_Type);
	Py_INCREF((PyObject *)(void *)&winreg_QueryMultipleValues_Type);
	PyModule_AddObject(m, "QueryMultipleValues", (PyObject *)(void *)&winreg_QueryMultipleValues_Type);
	Py_INCREF((PyObject *)(void *)&winreg_InitiateSystemShutdownEx_Type);
	PyModule_AddObject(m, "InitiateSystemShutdownEx", (PyObject *)(void *)&winreg_InitiateSystemShutdownEx_Type);
	Py_INCREF((PyObject *)(void *)&winreg_SaveKeyEx_Type);
	PyModule_AddObject(m, "SaveKeyEx", (PyObject *)(void *)&winreg_SaveKeyEx_Type);
	Py_INCREF((PyObject *)(void *)&winreg_OpenHKPT_Type);
	PyModule_AddObject(m, "OpenHKPT", (PyObject *)(void *)&winreg_OpenHKPT_Type);
	Py_INCREF((PyObject *)(void *)&winreg_OpenHKPN_Type);
	PyModule_AddObject(m, "OpenHKPN", (PyObject *)(void *)&winreg_OpenHKPN_Type);
	Py_INCREF((PyObject *)(void *)&winreg_QueryMultipleValues2_Type);
	PyModule_AddObject(m, "QueryMultipleValues2", (PyObject *)(void *)&winreg_QueryMultipleValues2_Type);
	Py_INCREF((PyObject *)(void *)&winreg_DeleteKeyEx_Type);
	PyModule_AddObject(m, "DeleteKeyEx", (PyObject *)(void *)&winreg_DeleteKeyEx_Type);
	Py_INCREF((PyObject *)(void *)&winreg_InterfaceType);
	PyModule_AddObject(m, "winreg", (PyObject *)(void *)&winreg_InterfaceType);
	Py_INCREF((PyObject *)(void *)&winreg_SyntaxType);
	PyModule_AddObject(m, "winreg_abstract_syntax", (PyObject *)(void *)&winreg_SyntaxType);
	Py_INCREF((PyObject *)(void *)&winreg_SyntaxType);
	PyModule_AddObject(m, "abstract_syntax", (PyObject *)(void *)&winreg_SyntaxType);
#ifdef PY_MOD_WINREG_PATCH
	PY_MOD_WINREG_PATCH(m);
#endif
	out:
	Py_XDECREF(dep_samba_dcerpc_lsa);
	Py_XDECREF(dep_samba_dcerpc_security);
	Py_XDECREF(dep_samba_dcerpc_misc);
	Py_XDECREF(dep_talloc);
	Py_XDECREF(dep_samba_dcerpc_base);
	return m;

}
