/* PhotosUploader.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from PhotosUploader.vala, do not modify */

/* Copyright 2016 Software Freedom Conservancy Inc.
 * Copyright 2019 Jens Georg <mail@jensge.org>
 *
 * This software is licensed under the GNU LGPL (version 2.1 or later).
 * See the COPYING file in this distribution.
 */

#include "shotwell-plugin-common.h"
#include <glib-object.h>
#include "shotwell-plugin-dev-1.0.h"
#include <gio/gio.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <libsoup/soup.h>
#include "shotwell-publishing.h"

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define PUBLISHING_GOOGLE_PHOTOS_TYPE_UPLOAD_TRANSACTION (publishing_google_photos_upload_transaction_get_type ())
#define PUBLISHING_GOOGLE_PHOTOS_UPLOAD_TRANSACTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PUBLISHING_GOOGLE_PHOTOS_TYPE_UPLOAD_TRANSACTION, PublishingGooglePhotosUploadTransaction))
#define PUBLISHING_GOOGLE_PHOTOS_UPLOAD_TRANSACTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), PUBLISHING_GOOGLE_PHOTOS_TYPE_UPLOAD_TRANSACTION, PublishingGooglePhotosUploadTransactionClass))
#define PUBLISHING_GOOGLE_PHOTOS_IS_UPLOAD_TRANSACTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PUBLISHING_GOOGLE_PHOTOS_TYPE_UPLOAD_TRANSACTION))
#define PUBLISHING_GOOGLE_PHOTOS_IS_UPLOAD_TRANSACTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), PUBLISHING_GOOGLE_PHOTOS_TYPE_UPLOAD_TRANSACTION))
#define PUBLISHING_GOOGLE_PHOTOS_UPLOAD_TRANSACTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), PUBLISHING_GOOGLE_PHOTOS_TYPE_UPLOAD_TRANSACTION, PublishingGooglePhotosUploadTransactionClass))

typedef struct _PublishingGooglePhotosUploadTransaction PublishingGooglePhotosUploadTransaction;
typedef struct _PublishingGooglePhotosUploadTransactionClass PublishingGooglePhotosUploadTransactionClass;
typedef struct _PublishingGooglePhotosUploadTransactionPrivate PublishingGooglePhotosUploadTransactionPrivate;

#define PUBLISHING_GOOGLE_PHOTOS_TYPE_PUBLISHING_PARAMETERS (publishing_google_photos_publishing_parameters_get_type ())
#define PUBLISHING_GOOGLE_PHOTOS_PUBLISHING_PARAMETERS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PUBLISHING_GOOGLE_PHOTOS_TYPE_PUBLISHING_PARAMETERS, PublishingGooglePhotosPublishingParameters))
#define PUBLISHING_GOOGLE_PHOTOS_PUBLISHING_PARAMETERS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), PUBLISHING_GOOGLE_PHOTOS_TYPE_PUBLISHING_PARAMETERS, PublishingGooglePhotosPublishingParametersClass))
#define PUBLISHING_GOOGLE_PHOTOS_IS_PUBLISHING_PARAMETERS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PUBLISHING_GOOGLE_PHOTOS_TYPE_PUBLISHING_PARAMETERS))
#define PUBLISHING_GOOGLE_PHOTOS_IS_PUBLISHING_PARAMETERS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), PUBLISHING_GOOGLE_PHOTOS_TYPE_PUBLISHING_PARAMETERS))
#define PUBLISHING_GOOGLE_PHOTOS_PUBLISHING_PARAMETERS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), PUBLISHING_GOOGLE_PHOTOS_TYPE_PUBLISHING_PARAMETERS, PublishingGooglePhotosPublishingParametersClass))

typedef struct _PublishingGooglePhotosPublishingParameters PublishingGooglePhotosPublishingParameters;
typedef struct _PublishingGooglePhotosPublishingParametersClass PublishingGooglePhotosPublishingParametersClass;
#define _publishing_google_photos_publishing_parameters_unref0(var) ((var == NULL) ? NULL : (var = (publishing_google_photos_publishing_parameters_unref (var), NULL)))
#define _publishing_rest_support_session_unref0(var) ((var == NULL) ? NULL : (var = (publishing_rest_support_session_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _publishing_rest_support_transaction_unref0(var) ((var == NULL) ? NULL : (var = (publishing_rest_support_transaction_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _PublishingGooglePhotosUploadTransactionExecuteAsyncData PublishingGooglePhotosUploadTransactionExecuteAsyncData;

#define PUBLISHING_GOOGLE_PHOTOS_TYPE_UPLOADER (publishing_google_photos_uploader_get_type ())
#define PUBLISHING_GOOGLE_PHOTOS_UPLOADER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PUBLISHING_GOOGLE_PHOTOS_TYPE_UPLOADER, PublishingGooglePhotosUploader))
#define PUBLISHING_GOOGLE_PHOTOS_UPLOADER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), PUBLISHING_GOOGLE_PHOTOS_TYPE_UPLOADER, PublishingGooglePhotosUploaderClass))
#define PUBLISHING_GOOGLE_PHOTOS_IS_UPLOADER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PUBLISHING_GOOGLE_PHOTOS_TYPE_UPLOADER))
#define PUBLISHING_GOOGLE_PHOTOS_IS_UPLOADER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), PUBLISHING_GOOGLE_PHOTOS_TYPE_UPLOADER))
#define PUBLISHING_GOOGLE_PHOTOS_UPLOADER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), PUBLISHING_GOOGLE_PHOTOS_TYPE_UPLOADER, PublishingGooglePhotosUploaderClass))

typedef struct _PublishingGooglePhotosUploader PublishingGooglePhotosUploader;
typedef struct _PublishingGooglePhotosUploaderClass PublishingGooglePhotosUploaderClass;
typedef struct _PublishingGooglePhotosUploaderPrivate PublishingGooglePhotosUploaderPrivate;
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _PublishingGooglePhotosUploadTransaction {
	PublishingRESTSupportGooglePublisherAuthenticatedTransaction parent_instance;
	PublishingGooglePhotosUploadTransactionPrivate * priv;
};

struct _PublishingGooglePhotosUploadTransactionClass {
	PublishingRESTSupportGooglePublisherAuthenticatedTransactionClass parent_class;
};

struct _PublishingGooglePhotosUploadTransactionPrivate {
	PublishingGooglePhotosPublishingParameters* parameters;
	PublishingRESTSupportGoogleSession* session;
	SpitPublishingPublishable* publishable;
	GInputStream* mapped_file;
};

struct _PublishingGooglePhotosUploadTransactionExecuteAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	PublishingGooglePhotosUploadTransaction* self;
	gchar* basename;
	SpitPublishingPublishable* _tmp0_;
	gchar* _tmp1_;
	gint64 mapped_file_size;
	GFileInputStream* _tmp2_;
	SpitPublishingPublishable* _tmp3_;
	GFile* _tmp4_;
	GFile* _tmp5_;
	GFileInputStream* _tmp6_;
	GFileInputStream* _tmp7_;
	GFileInputStream* _tmp8_;
	GFileInfo* info;
	GInputStream* _tmp9_;
	GFileInfo* _tmp10_;
	GFileInfo* _tmp11_;
	GError* e;
	gchar* msg;
	SpitPublishingPublishable* _tmp12_;
	GFile* _tmp13_;
	GFile* _tmp14_;
	gchar* _tmp15_;
	gchar* _tmp16_;
	GError* _tmp17_;
	const gchar* _tmp18_;
	gchar* _tmp19_;
	gchar* _tmp20_;
	const gchar* _tmp21_;
	const gchar* _tmp22_;
	GError* _tmp23_;
	SoupMessage* outbound_message;
	gchar* _tmp24_;
	gchar* _tmp25_;
	SoupMessage* _tmp26_;
	SoupMessage* _tmp27_;
	SoupMessageHeaders* _tmp28_;
	SoupMessageHeaders* _tmp29_;
	PublishingRESTSupportGoogleSession* _tmp30_;
	gchar* _tmp31_;
	gchar* _tmp32_;
	gchar* _tmp33_;
	gchar* _tmp34_;
	SoupMessageHeaders* _tmp35_;
	SoupMessageHeaders* _tmp36_;
	const gchar* _tmp37_;
	SoupMessageHeaders* _tmp38_;
	SoupMessageHeaders* _tmp39_;
	SoupMessageHeaders* _tmp40_;
	SoupMessageHeaders* _tmp41_;
	GInputStream* _tmp42_;
	GError* _inner_error0_;
};

struct _PublishingGooglePhotosUploader {
	PublishingRESTSupportBatchUploader parent_instance;
	PublishingGooglePhotosUploaderPrivate * priv;
	gchar** upload_tokens;
	gint upload_tokens_length1;
	gint _upload_tokens_size_;
	gchar** titles;
	gint titles_length1;
	gint _titles_size_;
};

struct _PublishingGooglePhotosUploaderClass {
	PublishingRESTSupportBatchUploaderClass parent_class;
};

struct _PublishingGooglePhotosUploaderPrivate {
	PublishingGooglePhotosPublishingParameters* parameters;
};

static gint PublishingGooglePhotosUploadTransaction_private_offset;
static gpointer publishing_google_photos_upload_transaction_parent_class = NULL;
static gint PublishingGooglePhotosUploader_private_offset;
static gpointer publishing_google_photos_uploader_parent_class = NULL;

VALA_EXTERN GType publishing_google_photos_upload_transaction_get_type (void) G_GNUC_CONST ;
VALA_EXTERN gpointer publishing_google_photos_publishing_parameters_ref (gpointer instance);
VALA_EXTERN void publishing_google_photos_publishing_parameters_unref (gpointer instance);
VALA_EXTERN GParamSpec* publishing_google_photos_param_spec_publishing_parameters (const gchar* name,
                                                                       const gchar* nick,
                                                                       const gchar* blurb,
                                                                       GType object_type,
                                                                       GParamFlags flags);
VALA_EXTERN void publishing_google_photos_value_set_publishing_parameters (GValue* value,
                                                               gpointer v_object);
VALA_EXTERN void publishing_google_photos_value_take_publishing_parameters (GValue* value,
                                                                gpointer v_object);
VALA_EXTERN gpointer publishing_google_photos_value_get_publishing_parameters (const GValue* value);
VALA_EXTERN GType publishing_google_photos_publishing_parameters_get_type (void) G_GNUC_CONST ;
VALA_EXTERN PublishingGooglePhotosUploadTransaction* publishing_google_photos_upload_transaction_new (PublishingRESTSupportGoogleSession* session,
                                                                                          PublishingGooglePhotosPublishingParameters* parameters,
                                                                                          SpitPublishingPublishable* publishable);
VALA_EXTERN PublishingGooglePhotosUploadTransaction* publishing_google_photos_upload_transaction_construct (GType object_type,
                                                                                                PublishingRESTSupportGoogleSession* session,
                                                                                                PublishingGooglePhotosPublishingParameters* parameters,
                                                                                                SpitPublishingPublishable* publishable);
VALA_EXTERN SpitPublishingPublishable* publishing_google_photos_upload_transaction_get_publishable (PublishingGooglePhotosUploadTransaction* self);
static void publishing_google_photos_upload_transaction_real_execute_async_data_free (gpointer _data);
static void publishing_google_photos_upload_transaction_real_execute_async (PublishingRESTSupportTransaction* base,
                                                                     GAsyncReadyCallback _callback_,
                                                                     gpointer _user_data_);
static gboolean publishing_google_photos_upload_transaction_real_execute_async_co (PublishingGooglePhotosUploadTransactionExecuteAsyncData* _data_);
static void publishing_google_photos_upload_transaction_execute_async_ready (GObject* source_object,
                                                                      GAsyncResult* _res_,
                                                                      gpointer _user_data_);
static void publishing_google_photos_upload_transaction_finalize (PublishingRESTSupportTransaction * obj);
static GType publishing_google_photos_upload_transaction_get_type_once (void);
VALA_EXTERN GType publishing_google_photos_uploader_get_type (void) G_GNUC_CONST ;
VALA_EXTERN PublishingGooglePhotosUploader* publishing_google_photos_uploader_new (PublishingRESTSupportGoogleSession* session,
                                                                       SpitPublishingPublishable** publishables,
                                                                       gint publishables_length1,
                                                                       PublishingGooglePhotosPublishingParameters* parameters);
VALA_EXTERN PublishingGooglePhotosUploader* publishing_google_photos_uploader_construct (GType object_type,
                                                                             PublishingRESTSupportGoogleSession* session,
                                                                             SpitPublishingPublishable** publishables,
                                                                             gint publishables_length1,
                                                                             PublishingGooglePhotosPublishingParameters* parameters);
static PublishingRESTSupportTransaction* publishing_google_photos_uploader_real_create_transaction (PublishingRESTSupportBatchUploader* base,
                                                                                             SpitPublishingPublishable* publishable);
static void publishing_google_photos_uploader_on_transaction_completed (PublishingGooglePhotosUploader* self,
                                                                 PublishingRESTSupportTransaction* txn);
static void _publishing_google_photos_uploader_on_transaction_completed_publishing_rest_support_transaction_completed (PublishingRESTSupportTransaction* _sender,
                                                                                                                gpointer self);
static void _vala_array_add36 (gchar** * array,
                        gint* length,
                        gint* size,
                        gchar* value);
static void _vala_array_add37 (gchar** * array,
                        gint* length,
                        gint* size,
                        gchar* value);
static void publishing_google_photos_uploader_finalize (PublishingRESTSupportBatchUploader * obj);
static GType publishing_google_photos_uploader_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

static inline gpointer
publishing_google_photos_upload_transaction_get_instance_private (PublishingGooglePhotosUploadTransaction* self)
{
	return G_STRUCT_MEMBER_P (self, PublishingGooglePhotosUploadTransaction_private_offset);
}

static gpointer
_publishing_rest_support_session_ref0 (gpointer self)
{
	return self ? publishing_rest_support_session_ref (self) : NULL;
}

static gpointer
_publishing_google_photos_publishing_parameters_ref0 (gpointer self)
{
	return self ? publishing_google_photos_publishing_parameters_ref (self) : NULL;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

PublishingGooglePhotosUploadTransaction*
publishing_google_photos_upload_transaction_construct (GType object_type,
                                                       PublishingRESTSupportGoogleSession* session,
                                                       PublishingGooglePhotosPublishingParameters* parameters,
                                                       SpitPublishingPublishable* publishable)
{
	PublishingGooglePhotosUploadTransaction* self = NULL;
	PublishingRESTSupportGoogleSession* _tmp0_;
	PublishingGooglePhotosPublishingParameters* _tmp1_;
	SpitPublishingPublishable* _tmp2_;
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (session, PUBLISHING_REST_SUPPORT_TYPE_GOOGLE_SESSION), NULL);
	g_return_val_if_fail (PUBLISHING_GOOGLE_PHOTOS_IS_PUBLISHING_PARAMETERS (parameters), NULL);
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (publishable, SPIT_PUBLISHING_TYPE_PUBLISHABLE), NULL);
	self = (PublishingGooglePhotosUploadTransaction*) publishing_rest_support_google_publisher_authenticated_transaction_construct (object_type, session, "https://photoslibrary.googleapis.com/v1/uploads", PUBLISHING_REST_SUPPORT_HTTP_METHOD_POST);
	_vala_assert (publishing_rest_support_session_is_authenticated (G_TYPE_CHECK_INSTANCE_CAST (session, PUBLISHING_REST_SUPPORT_TYPE_SESSION, PublishingRESTSupportSession)), "session.is_authenticated()");
	_tmp0_ = _publishing_rest_support_session_ref0 (session);
	_publishing_rest_support_session_unref0 (self->priv->session);
	self->priv->session = _tmp0_;
	_tmp1_ = _publishing_google_photos_publishing_parameters_ref0 (parameters);
	_publishing_google_photos_publishing_parameters_unref0 (self->priv->parameters);
	self->priv->parameters = _tmp1_;
	_tmp2_ = _g_object_ref0 (publishable);
	_g_object_unref0 (self->priv->publishable);
	self->priv->publishable = _tmp2_;
	return self;
}

PublishingGooglePhotosUploadTransaction*
publishing_google_photos_upload_transaction_new (PublishingRESTSupportGoogleSession* session,
                                                 PublishingGooglePhotosPublishingParameters* parameters,
                                                 SpitPublishingPublishable* publishable)
{
	return publishing_google_photos_upload_transaction_construct (PUBLISHING_GOOGLE_PHOTOS_TYPE_UPLOAD_TRANSACTION, session, parameters, publishable);
}

SpitPublishingPublishable*
publishing_google_photos_upload_transaction_get_publishable (PublishingGooglePhotosUploadTransaction* self)
{
	SpitPublishingPublishable* _tmp0_;
	SpitPublishingPublishable* _tmp1_;
	SpitPublishingPublishable* result;
	g_return_val_if_fail (PUBLISHING_GOOGLE_PHOTOS_IS_UPLOAD_TRANSACTION (self), NULL);
	_tmp0_ = self->priv->publishable;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}

static void
publishing_google_photos_upload_transaction_real_execute_async_data_free (gpointer _data)
{
	PublishingGooglePhotosUploadTransactionExecuteAsyncData* _data_;
	_data_ = _data;
	_publishing_rest_support_transaction_unref0 (_data_->self);
	g_slice_free (PublishingGooglePhotosUploadTransactionExecuteAsyncData, _data_);
}

static gpointer
_publishing_rest_support_transaction_ref0 (gpointer self)
{
	return self ? publishing_rest_support_transaction_ref (self) : NULL;
}

static void
publishing_google_photos_upload_transaction_real_execute_async (PublishingRESTSupportTransaction* base,
                                                                GAsyncReadyCallback _callback_,
                                                                gpointer _user_data_)
{
	PublishingGooglePhotosUploadTransaction * self;
	PublishingGooglePhotosUploadTransactionExecuteAsyncData* _data_;
	PublishingGooglePhotosUploadTransaction* _tmp0_;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, PUBLISHING_GOOGLE_PHOTOS_TYPE_UPLOAD_TRANSACTION, PublishingGooglePhotosUploadTransaction);
	_data_ = g_slice_new0 (PublishingGooglePhotosUploadTransactionExecuteAsyncData);
	_data_->_async_result = g_task_new (NULL, NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, publishing_google_photos_upload_transaction_real_execute_async_data_free);
	_tmp0_ = _publishing_rest_support_transaction_ref0 (self);
	_data_->self = _tmp0_;
	publishing_google_photos_upload_transaction_real_execute_async_co (_data_);
}

static void
publishing_google_photos_upload_transaction_execute_finish (PublishingRESTSupportTransaction* base,
                                                            GAsyncResult* _res_,
                                                            GError** error)
{
	PublishingGooglePhotosUploadTransactionExecuteAsyncData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
}

static void
publishing_google_photos_upload_transaction_execute_async_ready (GObject* source_object,
                                                                 GAsyncResult* _res_,
                                                                 gpointer _user_data_)
{
	PublishingGooglePhotosUploadTransactionExecuteAsyncData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	publishing_google_photos_upload_transaction_real_execute_async_co (_data_);
}

static gboolean
publishing_google_photos_upload_transaction_real_execute_async_co (PublishingGooglePhotosUploadTransactionExecuteAsyncData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->self->priv->publishable;
	_data_->_tmp1_ = spit_publishing_publishable_get_param_string (_data_->_tmp0_, SPIT_PUBLISHING_PUBLISHABLE_PARAM_STRING_BASENAME);
	_data_->basename = _data_->_tmp1_;
	_data_->mapped_file_size = (gint64) -1;
	{
		_data_->_tmp3_ = _data_->self->priv->publishable;
		_data_->_tmp4_ = spit_publishing_publishable_get_serialized_file (_data_->_tmp3_);
		_data_->_tmp5_ = _data_->_tmp4_;
		_data_->_tmp6_ = g_file_read (_data_->_tmp5_, NULL, &_data_->_inner_error0_);
		_data_->_tmp7_ = _data_->_tmp6_;
		_g_object_unref0 (_data_->_tmp5_);
		_data_->_tmp2_ = _data_->_tmp7_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_data_->_tmp8_ = _data_->_tmp2_;
		_data_->_tmp2_ = NULL;
		_g_object_unref0 (_data_->self->priv->mapped_file);
		_data_->self->priv->mapped_file = G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp8_, g_input_stream_get_type (), GInputStream);
		_data_->_tmp9_ = _data_->self->priv->mapped_file;
		_data_->_tmp10_ = g_file_input_stream_query_info (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp9_, g_file_input_stream_get_type (), GFileInputStream), "standard::size", NULL, &_data_->_inner_error0_);
		_data_->info = _data_->_tmp10_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			_g_object_unref0 (_data_->_tmp2_);
			goto __catch0_g_error;
		}
		_data_->_tmp11_ = _data_->info;
		_data_->mapped_file_size = g_file_info_get_size (_data_->_tmp11_);
		_g_object_unref0 (_data_->info);
		_g_object_unref0 (_data_->_tmp2_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		_data_->e = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->_tmp12_ = _data_->self->priv->publishable;
		_data_->_tmp13_ = spit_publishing_publishable_get_serialized_file (_data_->_tmp12_);
		_data_->_tmp14_ = _data_->_tmp13_;
		_data_->_tmp15_ = g_file_get_path (_data_->_tmp14_);
		_data_->_tmp16_ = _data_->_tmp15_;
		_data_->_tmp17_ = _data_->e;
		_data_->_tmp18_ = _data_->_tmp17_->message;
		_data_->_tmp19_ = g_strdup_printf ("Google Photos: couldn't read data from %s: %s", _data_->_tmp16_, _data_->_tmp18_);
		_data_->_tmp20_ = _data_->_tmp19_;
		_g_free0 (_data_->_tmp16_);
		_g_object_unref0 (_data_->_tmp14_);
		_data_->msg = _data_->_tmp20_;
		_data_->_tmp21_ = _data_->msg;
		g_warning ("PhotosUploader.vala:43: %s", _data_->_tmp21_);
		_data_->_tmp22_ = _data_->msg;
		_data_->_tmp23_ = g_error_new_literal (SPIT_PUBLISHING_PUBLISHING_ERROR, SPIT_PUBLISHING_PUBLISHING_ERROR_LOCAL_FILE_ERROR, _data_->_tmp22_);
		_data_->_inner_error0_ = _data_->_tmp23_;
		_g_free0 (_data_->msg);
		_g_error_free0 (_data_->e);
		goto __finally0;
	}
	__finally0:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		if (_data_->_inner_error0_->domain == SPIT_PUBLISHING_PUBLISHING_ERROR) {
			g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
			_g_free0 (_data_->basename);
			g_object_unref (_data_->_async_result);
			return FALSE;
		} else {
			_g_free0 (_data_->basename);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
			g_clear_error (&_data_->_inner_error0_);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
	}
	_data_->_tmp24_ = publishing_rest_support_transaction_get_endpoint_url (G_TYPE_CHECK_INSTANCE_CAST (_data_->self, PUBLISHING_REST_SUPPORT_TYPE_TRANSACTION, PublishingRESTSupportTransaction));
	_data_->_tmp25_ = _data_->_tmp24_;
	_data_->_tmp26_ = soup_message_new ("POST", _data_->_tmp25_);
	_data_->_tmp27_ = _data_->_tmp26_;
	_g_free0 (_data_->_tmp25_);
	_data_->outbound_message = _data_->_tmp27_;
	_data_->_tmp28_ = soup_message_get_request_headers (_data_->outbound_message);
	_data_->_tmp29_ = _data_->_tmp28_;
	_data_->_tmp30_ = _data_->self->priv->session;
	_data_->_tmp31_ = publishing_rest_support_google_session_get_access_token (_data_->_tmp30_);
	_data_->_tmp32_ = _data_->_tmp31_;
	_data_->_tmp33_ = g_strconcat ("Bearer ", _data_->_tmp32_, NULL);
	_data_->_tmp34_ = _data_->_tmp33_;
	soup_message_headers_append (_data_->_tmp29_, "Authorization", _data_->_tmp34_);
	_g_free0 (_data_->_tmp34_);
	_g_free0 (_data_->_tmp32_);
	_data_->_tmp35_ = soup_message_get_request_headers (_data_->outbound_message);
	_data_->_tmp36_ = _data_->_tmp35_;
	_data_->_tmp37_ = _data_->basename;
	soup_message_headers_append (_data_->_tmp36_, "X-Goog-Upload-File-Name", _data_->_tmp37_);
	_data_->_tmp38_ = soup_message_get_request_headers (_data_->outbound_message);
	_data_->_tmp39_ = _data_->_tmp38_;
	soup_message_headers_append (_data_->_tmp39_, "X-Goog-Upload-Protocol", "raw");
	_data_->_tmp40_ = soup_message_get_request_headers (_data_->outbound_message);
	_data_->_tmp41_ = _data_->_tmp40_;
	soup_message_headers_set_content_type (_data_->_tmp41_, "application/octet-stream", NULL);
	_data_->_tmp42_ = _data_->self->priv->mapped_file;
	soup_message_set_request_body (_data_->outbound_message, NULL, _data_->_tmp42_, (gssize) _data_->mapped_file_size);
	publishing_rest_support_transaction_set_message (G_TYPE_CHECK_INSTANCE_CAST (_data_->self, PUBLISHING_REST_SUPPORT_TYPE_TRANSACTION, PublishingRESTSupportTransaction), _data_->outbound_message, (gulong) _data_->mapped_file_size);
	publishing_rest_support_transaction_set_is_executed (G_TYPE_CHECK_INSTANCE_CAST (_data_->self, PUBLISHING_REST_SUPPORT_TYPE_TRANSACTION, PublishingRESTSupportTransaction), TRUE);
	_data_->_state_ = 1;
	publishing_rest_support_transaction_send_async (G_TYPE_CHECK_INSTANCE_CAST (_data_->self, PUBLISHING_REST_SUPPORT_TYPE_TRANSACTION, PublishingRESTSupportTransaction), publishing_google_photos_upload_transaction_execute_async_ready, _data_);
	return FALSE;
	_state_1:
	publishing_rest_support_transaction_send_finish (G_TYPE_CHECK_INSTANCE_CAST (_data_->self, PUBLISHING_REST_SUPPORT_TYPE_TRANSACTION, PublishingRESTSupportTransaction), _data_->_res_, &_data_->_inner_error0_);
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		if (_data_->_inner_error0_->domain == SPIT_PUBLISHING_PUBLISHING_ERROR) {
			g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
			_g_object_unref0 (_data_->outbound_message);
			_g_free0 (_data_->basename);
			g_object_unref (_data_->_async_result);
			return FALSE;
		} else {
			_g_object_unref0 (_data_->outbound_message);
			_g_free0 (_data_->basename);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
			g_clear_error (&_data_->_inner_error0_);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
	}
	_g_object_unref0 (_data_->outbound_message);
	_g_free0 (_data_->basename);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
publishing_google_photos_upload_transaction_class_init (PublishingGooglePhotosUploadTransactionClass * klass,
                                                        gpointer klass_data)
{
	publishing_google_photos_upload_transaction_parent_class = g_type_class_peek_parent (klass);
	((PublishingRESTSupportTransactionClass *) klass)->finalize = publishing_google_photos_upload_transaction_finalize;
	g_type_class_adjust_private_offset (klass, &PublishingGooglePhotosUploadTransaction_private_offset);
	((PublishingRESTSupportTransactionClass *) klass)->execute_async = (void (*) (PublishingRESTSupportTransaction*, GAsyncReadyCallback, gpointer)) publishing_google_photos_upload_transaction_real_execute_async;
	((PublishingRESTSupportTransactionClass *) klass)->execute_finish = (void (*) (PublishingRESTSupportTransaction*, GAsyncResult*, GError**)) publishing_google_photos_upload_transaction_execute_finish;
}

static void
publishing_google_photos_upload_transaction_instance_init (PublishingGooglePhotosUploadTransaction * self,
                                                           gpointer klass)
{
	self->priv = publishing_google_photos_upload_transaction_get_instance_private (self);
}

static void
publishing_google_photos_upload_transaction_finalize (PublishingRESTSupportTransaction * obj)
{
	PublishingGooglePhotosUploadTransaction * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, PUBLISHING_GOOGLE_PHOTOS_TYPE_UPLOAD_TRANSACTION, PublishingGooglePhotosUploadTransaction);
	_publishing_google_photos_publishing_parameters_unref0 (self->priv->parameters);
	_publishing_rest_support_session_unref0 (self->priv->session);
	_g_object_unref0 (self->priv->publishable);
	_g_object_unref0 (self->priv->mapped_file);
	PUBLISHING_REST_SUPPORT_TRANSACTION_CLASS (publishing_google_photos_upload_transaction_parent_class)->finalize (obj);
}

static GType
publishing_google_photos_upload_transaction_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (PublishingGooglePhotosUploadTransactionClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) publishing_google_photos_upload_transaction_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PublishingGooglePhotosUploadTransaction), 0, (GInstanceInitFunc) publishing_google_photos_upload_transaction_instance_init, NULL };
	GType publishing_google_photos_upload_transaction_type_id;
	publishing_google_photos_upload_transaction_type_id = g_type_register_static (PUBLISHING_REST_SUPPORT_GOOGLE_PUBLISHER_TYPE_AUTHENTICATED_TRANSACTION, "PublishingGooglePhotosUploadTransaction", &g_define_type_info, 0);
	PublishingGooglePhotosUploadTransaction_private_offset = g_type_add_instance_private (publishing_google_photos_upload_transaction_type_id, sizeof (PublishingGooglePhotosUploadTransactionPrivate));
	return publishing_google_photos_upload_transaction_type_id;
}

GType
publishing_google_photos_upload_transaction_get_type (void)
{
	static volatile gsize publishing_google_photos_upload_transaction_type_id__once = 0;
	if (g_once_init_enter (&publishing_google_photos_upload_transaction_type_id__once)) {
		GType publishing_google_photos_upload_transaction_type_id;
		publishing_google_photos_upload_transaction_type_id = publishing_google_photos_upload_transaction_get_type_once ();
		g_once_init_leave (&publishing_google_photos_upload_transaction_type_id__once, publishing_google_photos_upload_transaction_type_id);
	}
	return publishing_google_photos_upload_transaction_type_id__once;
}

static inline gpointer
publishing_google_photos_uploader_get_instance_private (PublishingGooglePhotosUploader* self)
{
	return G_STRUCT_MEMBER_P (self, PublishingGooglePhotosUploader_private_offset);
}

PublishingGooglePhotosUploader*
publishing_google_photos_uploader_construct (GType object_type,
                                             PublishingRESTSupportGoogleSession* session,
                                             SpitPublishingPublishable** publishables,
                                             gint publishables_length1,
                                             PublishingGooglePhotosPublishingParameters* parameters)
{
	PublishingGooglePhotosUploader* self = NULL;
	PublishingGooglePhotosPublishingParameters* _tmp0_;
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (session, PUBLISHING_REST_SUPPORT_TYPE_GOOGLE_SESSION), NULL);
	g_return_val_if_fail (PUBLISHING_GOOGLE_PHOTOS_IS_PUBLISHING_PARAMETERS (parameters), NULL);
	self = (PublishingGooglePhotosUploader*) publishing_rest_support_batch_uploader_construct (object_type, G_TYPE_CHECK_INSTANCE_CAST (session, PUBLISHING_REST_SUPPORT_TYPE_SESSION, PublishingRESTSupportSession), publishables, (gint) publishables_length1);
	_tmp0_ = _publishing_google_photos_publishing_parameters_ref0 (parameters);
	_publishing_google_photos_publishing_parameters_unref0 (self->priv->parameters);
	self->priv->parameters = _tmp0_;
	return self;
}

PublishingGooglePhotosUploader*
publishing_google_photos_uploader_new (PublishingRESTSupportGoogleSession* session,
                                       SpitPublishingPublishable** publishables,
                                       gint publishables_length1,
                                       PublishingGooglePhotosPublishingParameters* parameters)
{
	return publishing_google_photos_uploader_construct (PUBLISHING_GOOGLE_PHOTOS_TYPE_UPLOADER, session, publishables, publishables_length1, parameters);
}

static void
_publishing_google_photos_uploader_on_transaction_completed_publishing_rest_support_transaction_completed (PublishingRESTSupportTransaction* _sender,
                                                                                                           gpointer self)
{
	publishing_google_photos_uploader_on_transaction_completed ((PublishingGooglePhotosUploader*) self, _sender);
}

static PublishingRESTSupportTransaction*
publishing_google_photos_uploader_real_create_transaction (PublishingRESTSupportBatchUploader* base,
                                                           SpitPublishingPublishable* publishable)
{
	PublishingGooglePhotosUploader * self;
	PublishingGooglePhotosUploadTransaction* txn = NULL;
	PublishingRESTSupportSession* _tmp0_;
	PublishingRESTSupportGoogleSession* _tmp1_;
	PublishingGooglePhotosPublishingParameters* _tmp2_;
	SpitPublishingPublishable* _tmp3_;
	SpitPublishingPublishable* _tmp4_;
	PublishingGooglePhotosUploadTransaction* _tmp5_;
	PublishingGooglePhotosUploadTransaction* _tmp6_;
	PublishingRESTSupportTransaction* result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, PUBLISHING_GOOGLE_PHOTOS_TYPE_UPLOADER, PublishingGooglePhotosUploader);
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (publishable, SPIT_PUBLISHING_TYPE_PUBLISHABLE), NULL);
	_tmp0_ = publishing_rest_support_batch_uploader_get_session (G_TYPE_CHECK_INSTANCE_CAST (self, PUBLISHING_REST_SUPPORT_TYPE_BATCH_UPLOADER, PublishingRESTSupportBatchUploader));
	_tmp1_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, PUBLISHING_REST_SUPPORT_TYPE_GOOGLE_SESSION, PublishingRESTSupportGoogleSession);
	_tmp2_ = self->priv->parameters;
	_tmp3_ = publishing_rest_support_batch_uploader_get_current_publishable (G_TYPE_CHECK_INSTANCE_CAST (self, PUBLISHING_REST_SUPPORT_TYPE_BATCH_UPLOADER, PublishingRESTSupportBatchUploader));
	_tmp4_ = _tmp3_;
	_tmp5_ = publishing_google_photos_upload_transaction_new (_tmp1_, _tmp2_, _tmp4_);
	_tmp6_ = _tmp5_;
	_g_object_unref0 (_tmp4_);
	_publishing_rest_support_session_unref0 (_tmp1_);
	txn = _tmp6_;
	g_signal_connect (G_TYPE_CHECK_INSTANCE_CAST (txn, PUBLISHING_REST_SUPPORT_TYPE_TRANSACTION, PublishingRESTSupportTransaction), "completed", (GCallback) _publishing_google_photos_uploader_on_transaction_completed_publishing_rest_support_transaction_completed, self);
	result = G_TYPE_CHECK_INSTANCE_CAST (txn, PUBLISHING_REST_SUPPORT_TYPE_TRANSACTION, PublishingRESTSupportTransaction);
	return result;
}

static void
_vala_array_add36 (gchar** * array,
                   gint* length,
                   gint* size,
                   gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add37 (gchar** * array,
                   gint* length,
                   gint* size,
                   gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
publishing_google_photos_uploader_on_transaction_completed (PublishingGooglePhotosUploader* self,
                                                            PublishingRESTSupportTransaction* txn)
{
	guint _tmp0_;
	gchar* _tmp1_;
	gchar* title = NULL;
	SpitPublishingPublishable* _tmp2_;
	SpitPublishingPublishable* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	SpitPublishingPublishable* publishable = NULL;
	SpitPublishingPublishable* _tmp6_;
	gboolean _tmp7_ = FALSE;
	const gchar* _tmp8_;
	const gchar* _tmp12_;
	gchar* _tmp13_;
	g_return_if_fail (PUBLISHING_GOOGLE_PHOTOS_IS_UPLOADER (self));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (txn, PUBLISHING_REST_SUPPORT_TYPE_TRANSACTION));
	g_signal_parse_name ("completed", PUBLISHING_REST_SUPPORT_TYPE_TRANSACTION, &_tmp0_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (txn, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp0_, 0, NULL, (GCallback) _publishing_google_photos_uploader_on_transaction_completed_publishing_rest_support_transaction_completed, self);
	_tmp1_ = publishing_rest_support_transaction_get_response (txn);
	_vala_array_add36 (&self->upload_tokens, &self->upload_tokens_length1, &self->_upload_tokens_size_, _tmp1_);
	_tmp2_ = publishing_google_photos_upload_transaction_get_publishable (G_TYPE_CHECK_INSTANCE_CAST (txn, PUBLISHING_GOOGLE_PHOTOS_TYPE_UPLOAD_TRANSACTION, PublishingGooglePhotosUploadTransaction));
	_tmp3_ = _tmp2_;
	_tmp4_ = spit_publishing_publishable_get_publishing_name (_tmp3_);
	_tmp5_ = _tmp4_;
	_g_object_unref0 (_tmp3_);
	title = _tmp5_;
	_tmp6_ = publishing_google_photos_upload_transaction_get_publishable (G_TYPE_CHECK_INSTANCE_CAST (txn, PUBLISHING_GOOGLE_PHOTOS_TYPE_UPLOAD_TRANSACTION, PublishingGooglePhotosUploadTransaction));
	publishable = _tmp6_;
	_tmp8_ = title;
	if (_tmp8_ == NULL) {
		_tmp7_ = TRUE;
	} else {
		const gchar* _tmp9_;
		_tmp9_ = title;
		_tmp7_ = g_strcmp0 (_tmp9_, "") == 0;
	}
	if (_tmp7_) {
		SpitPublishingPublishable* _tmp10_;
		gchar* _tmp11_;
		_tmp10_ = publishable;
		_tmp11_ = spit_publishing_publishable_get_param_string (_tmp10_, SPIT_PUBLISHING_PUBLISHABLE_PARAM_STRING_BASENAME);
		_g_free0 (title);
		title = _tmp11_;
	}
	_tmp12_ = title;
	_tmp13_ = g_strdup (_tmp12_);
	_vala_array_add37 (&self->titles, &self->titles_length1, &self->_titles_size_, _tmp13_);
	_g_object_unref0 (publishable);
	_g_free0 (title);
}

static void
publishing_google_photos_uploader_class_init (PublishingGooglePhotosUploaderClass * klass,
                                              gpointer klass_data)
{
	publishing_google_photos_uploader_parent_class = g_type_class_peek_parent (klass);
	((PublishingRESTSupportBatchUploaderClass *) klass)->finalize = publishing_google_photos_uploader_finalize;
	g_type_class_adjust_private_offset (klass, &PublishingGooglePhotosUploader_private_offset);
	((PublishingRESTSupportBatchUploaderClass *) klass)->create_transaction = (PublishingRESTSupportTransaction* (*) (PublishingRESTSupportBatchUploader*, SpitPublishingPublishable*)) publishing_google_photos_uploader_real_create_transaction;
}

static void
publishing_google_photos_uploader_instance_init (PublishingGooglePhotosUploader * self,
                                                 gpointer klass)
{
	gchar** _tmp0_;
	gchar** _tmp1_;
	self->priv = publishing_google_photos_uploader_get_instance_private (self);
	_tmp0_ = g_new0 (gchar*, 0 + 1);
	self->upload_tokens = _tmp0_;
	self->upload_tokens_length1 = 0;
	self->_upload_tokens_size_ = self->upload_tokens_length1;
	_tmp1_ = g_new0 (gchar*, 0 + 1);
	self->titles = _tmp1_;
	self->titles_length1 = 0;
	self->_titles_size_ = self->titles_length1;
}

static void
publishing_google_photos_uploader_finalize (PublishingRESTSupportBatchUploader * obj)
{
	PublishingGooglePhotosUploader * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, PUBLISHING_GOOGLE_PHOTOS_TYPE_UPLOADER, PublishingGooglePhotosUploader);
	_publishing_google_photos_publishing_parameters_unref0 (self->priv->parameters);
	self->upload_tokens = (_vala_array_free (self->upload_tokens, self->upload_tokens_length1, (GDestroyNotify) g_free), NULL);
	self->titles = (_vala_array_free (self->titles, self->titles_length1, (GDestroyNotify) g_free), NULL);
	PUBLISHING_REST_SUPPORT_BATCH_UPLOADER_CLASS (publishing_google_photos_uploader_parent_class)->finalize (obj);
}

static GType
publishing_google_photos_uploader_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (PublishingGooglePhotosUploaderClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) publishing_google_photos_uploader_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PublishingGooglePhotosUploader), 0, (GInstanceInitFunc) publishing_google_photos_uploader_instance_init, NULL };
	GType publishing_google_photos_uploader_type_id;
	publishing_google_photos_uploader_type_id = g_type_register_static (PUBLISHING_REST_SUPPORT_TYPE_BATCH_UPLOADER, "PublishingGooglePhotosUploader", &g_define_type_info, 0);
	PublishingGooglePhotosUploader_private_offset = g_type_add_instance_private (publishing_google_photos_uploader_type_id, sizeof (PublishingGooglePhotosUploaderPrivate));
	return publishing_google_photos_uploader_type_id;
}

GType
publishing_google_photos_uploader_get_type (void)
{
	static volatile gsize publishing_google_photos_uploader_type_id__once = 0;
	if (g_once_init_enter (&publishing_google_photos_uploader_type_id__once)) {
		GType publishing_google_photos_uploader_type_id;
		publishing_google_photos_uploader_type_id = publishing_google_photos_uploader_get_type_once ();
		g_once_init_leave (&publishing_google_photos_uploader_type_id__once, publishing_google_photos_uploader_type_id);
	}
	return publishing_google_photos_uploader_type_id__once;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

