/* DataCollection.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from DataCollection.vala, do not modify */

/* Copyright 2016 Software Freedom Conservancy Inc.
 *
 * This software is licensed under the GNU LGPL (version 2.1 or later).
 * See the COPYING file in this distribution.
 */

#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gee.h>
#include <gobject/gvaluecollector.h>

#define DATA_COLLECTION_INVALID_OBJECT_ORDINAL ((gint64) -1)
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_DATA_COLLECTION (data_collection_get_type ())
#define DATA_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATA_COLLECTION, DataCollection))
#define DATA_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATA_COLLECTION, DataCollectionClass))
#define IS_DATA_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATA_COLLECTION))
#define IS_DATA_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATA_COLLECTION))
#define DATA_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATA_COLLECTION, DataCollectionClass))

typedef struct _DataCollection DataCollection;
typedef struct _DataCollectionClass DataCollectionClass;
typedef struct _DataCollectionPrivate DataCollectionPrivate;

#define TYPE_DATA_OBJECT (data_object_get_type ())
#define DATA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATA_OBJECT, DataObject))
#define DATA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATA_OBJECT, DataObjectClass))
#define IS_DATA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATA_OBJECT))
#define IS_DATA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATA_OBJECT))
#define DATA_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATA_OBJECT, DataObjectClass))

typedef struct _DataObject DataObject;
typedef struct _DataObjectClass DataObjectClass;

#define TYPE_ALTERATION (alteration_get_type ())
#define ALTERATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ALTERATION, Alteration))
#define ALTERATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ALTERATION, AlterationClass))
#define IS_ALTERATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ALTERATION))
#define IS_ALTERATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ALTERATION))
#define ALTERATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ALTERATION, AlterationClass))

typedef struct _Alteration Alteration;
typedef struct _AlterationClass AlterationClass;
typedef gint64 (*Comparator) (void* a, void* b, gpointer user_data);
typedef gboolean (*ComparatorPredicate) (DataObject* object, Alteration* alteration, gpointer user_data);
typedef gboolean (*ProgressMonitor) (guint64 current, guint64 total, gboolean do_event_loop, gpointer user_data);

#define TYPE_MARKER (marker_get_type ())
#define MARKER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MARKER, Marker))
#define IS_MARKER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MARKER))
#define MARKER_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_MARKER, MarkerIface))

typedef struct _Marker Marker;
typedef struct _MarkerIface MarkerIface;

#define TYPE_DATA_SET (data_set_get_type ())
#define DATA_SET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATA_SET, DataSet))
#define DATA_SET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATA_SET, DataSetClass))
#define IS_DATA_SET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATA_SET))
#define IS_DATA_SET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATA_SET))
#define DATA_SET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATA_SET, DataSetClass))

typedef struct _DataSet DataSet;
typedef struct _DataSetClass DataSetClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _data_set_unref0(var) ((var == NULL) ? NULL : (var = (data_set_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define TYPE_SINGLETON_COLLECTION (singleton_collection_get_type ())
#define SINGLETON_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SINGLETON_COLLECTION, SingletonCollection))
#define SINGLETON_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SINGLETON_COLLECTION, SingletonCollectionClass))
#define IS_SINGLETON_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SINGLETON_COLLECTION))
#define IS_SINGLETON_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SINGLETON_COLLECTION))
#define SINGLETON_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SINGLETON_COLLECTION, SingletonCollectionClass))

typedef struct _SingletonCollection SingletonCollection;
typedef struct _SingletonCollectionClass SingletonCollectionClass;
#define _data_collection_unref0(var) ((var == NULL) ? NULL : (var = (data_collection_unref (var), NULL)))

#define DATA_COLLECTION_TYPE_MARKER_IMPL (data_collection_marker_impl_get_type ())
#define DATA_COLLECTION_MARKER_IMPL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DATA_COLLECTION_TYPE_MARKER_IMPL, DataCollectionMarkerImpl))
#define DATA_COLLECTION_MARKER_IMPL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DATA_COLLECTION_TYPE_MARKER_IMPL, DataCollectionMarkerImplClass))
#define DATA_COLLECTION_IS_MARKER_IMPL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DATA_COLLECTION_TYPE_MARKER_IMPL))
#define DATA_COLLECTION_IS_MARKER_IMPL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DATA_COLLECTION_TYPE_MARKER_IMPL))
#define DATA_COLLECTION_MARKER_IMPL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DATA_COLLECTION_TYPE_MARKER_IMPL, DataCollectionMarkerImplClass))

typedef struct _DataCollectionMarkerImpl DataCollectionMarkerImpl;
typedef struct _DataCollectionMarkerImplClass DataCollectionMarkerImplClass;
typedef gboolean (*MarkedAction) (DataObject* object, GObject* user, gpointer user_data);
typedef struct _DataCollectionMarkerImplPrivate DataCollectionMarkerImplPrivate;
#define _alteration_unref0(var) ((var == NULL) ? NULL : (var = (alteration_unref (var), NULL)))
typedef gboolean (*ValueEqualFunc) (GValue* a, GValue* b, gpointer user_data);
#define __vala_GValue_free0(var) ((var == NULL) ? NULL : (var = (_vala_GValue_free (var), NULL)))
enum  {
	DATA_COLLECTION_MARKER_IMPL_0_PROPERTY,
	DATA_COLLECTION_MARKER_IMPL_NUM_PROPERTIES
};
static GParamSpec* data_collection_marker_impl_properties[DATA_COLLECTION_MARKER_IMPL_NUM_PROPERTIES];
typedef struct _ParamSpecDataCollection ParamSpecDataCollection;
enum  {
	DATA_COLLECTION_ITEMS_ADDED_SIGNAL,
	DATA_COLLECTION_ITEMS_REMOVED_SIGNAL,
	DATA_COLLECTION_CONTENTS_ALTERED_SIGNAL,
	DATA_COLLECTION_ITEMS_ALTERED_SIGNAL,
	DATA_COLLECTION_ORDERING_CHANGED_SIGNAL,
	DATA_COLLECTION_PROPERTY_SET_SIGNAL,
	DATA_COLLECTION_PROPERTY_CLEARED_SIGNAL,
	DATA_COLLECTION_FROZEN_SIGNAL,
	DATA_COLLECTION_THAWED_SIGNAL,
	DATA_COLLECTION_NUM_SIGNALS
};
static guint data_collection_signals[DATA_COLLECTION_NUM_SIGNALS] = {0};
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _MarkerIface {
	GTypeInterface parent_iface;
	void (*mark) (Marker* self, DataObject* object);
	void (*unmark) (Marker* self, DataObject* object);
	gboolean (*toggle) (Marker* self, DataObject* object);
	void (*mark_many) (Marker* self, GeeCollection* list);
	void (*unmark_many) (Marker* self, GeeCollection* list);
	void (*mark_all) (Marker* self);
	gint (*get_count) (Marker* self);
	GeeCollection* (*get_all) (Marker* self);
};

struct _DataCollection {
	GTypeInstance parent_instance;
	volatile int ref_count;
	DataCollectionPrivate * priv;
};

struct _DataCollectionClass {
	GTypeClass parent_class;
	void (*finalize) (DataCollection *self);
	gchar* (*to_string) (DataCollection* self);
	void (*notify_items_added) (DataCollection* self, GeeIterable* added);
	void (*notify_items_removed) (DataCollection* self, GeeIterable* removed);
	void (*notify_contents_altered) (DataCollection* self, GeeIterable* added, GeeIterable* removed);
	void (*notify_items_altered) (DataCollection* self, GeeMap* items);
	void (*notify_ordering_changed) (DataCollection* self);
	void (*notify_property_set) (DataCollection* self, const gchar* name, GValue* old, GValue* val);
	void (*notify_property_cleared) (DataCollection* self, const gchar* name);
	gboolean (*valid_type) (DataCollection* self, DataObject* object);
	void (*set_comparator) (DataCollection* self, Comparator comparator, gpointer comparator_target, ComparatorPredicate predicate, gpointer predicate_target);
	void (*reset_comparator) (DataCollection* self);
	GeeCollection* (*get_all) (DataCollection* self);
	gint (*get_count) (DataCollection* self);
	DataObject* (*get_at) (DataCollection* self, gint index);
	gint (*index_of) (DataCollection* self, DataObject* object);
	gboolean (*contains) (DataCollection* self, DataObject* object);
	gboolean (*add) (DataCollection* self, DataObject* object);
	GeeCollection* (*add_many) (DataCollection* self, GeeCollection* objects, ProgressMonitor monitor, gpointer monitor_target);
	void (*remove_marked) (DataCollection* self, Marker* m);
	void (*clear) (DataCollection* self);
	void (*close) (DataCollection* self);
	void (*notify_frozen) (DataCollection* self);
	void (*notify_thawed) (DataCollection* self);
	void (*items_added) (DataCollection* self, GeeIterable* added);
	void (*items_removed) (DataCollection* self, GeeIterable* removed);
	void (*contents_altered) (DataCollection* self, GeeIterable* added, GeeIterable* removed);
	void (*items_altered) (DataCollection* self, GeeMap* items);
	void (*ordering_changed) (DataCollection* self);
	void (*property_set) (DataCollection* self, const gchar* name, GValue* old, GValue* val);
	void (*property_cleared) (DataCollection* self, const gchar* name);
	void (*frozen) (DataCollection* self);
	void (*thawed) (DataCollection* self);
};

struct _DataCollectionPrivate {
	gchar* name;
	DataSet* dataset;
	GeeHashMap* properties;
	gint64 object_ordinal_generator;
	gint notifies_frozen;
	GeeHashMap* frozen_items_altered;
	gboolean fire_ordering_changed;
};

struct _DataCollectionMarkerImpl {
	GObject parent_instance;
	DataCollectionMarkerImplPrivate * priv;
	DataCollection* owner;
	GeeHashSet* marked;
	gint freeze_count;
};

struct _DataCollectionMarkerImplClass {
	GObjectClass parent_class;
};

struct _ParamSpecDataCollection {
	GParamSpec parent_instance;
};

static gint DataCollection_private_offset;
static gpointer data_collection_parent_class = NULL;
static gpointer data_collection_marker_impl_parent_class = NULL;
static MarkerIface * data_collection_marker_impl_marker_parent_iface = NULL;

VALA_EXTERN gpointer data_collection_ref (gpointer instance);
VALA_EXTERN void data_collection_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_data_collection (const gchar* name,
                                        const gchar* nick,
                                        const gchar* blurb,
                                        GType object_type,
                                        GParamFlags flags);
VALA_EXTERN void value_set_data_collection (GValue* value,
                                gpointer v_object);
VALA_EXTERN void value_take_data_collection (GValue* value,
                                 gpointer v_object);
VALA_EXTERN gpointer value_get_data_collection (const GValue* value);
VALA_EXTERN GType data_collection_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (DataCollection, data_collection_unref)
VALA_EXTERN GType data_object_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (DataObject, g_object_unref)
VALA_EXTERN gpointer alteration_ref (gpointer instance);
VALA_EXTERN void alteration_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_alteration (const gchar* name,
                                   const gchar* nick,
                                   const gchar* blurb,
                                   GType object_type,
                                   GParamFlags flags);
VALA_EXTERN void value_set_alteration (GValue* value,
                           gpointer v_object);
VALA_EXTERN void value_take_alteration (GValue* value,
                            gpointer v_object);
VALA_EXTERN gpointer value_get_alteration (const GValue* value);
VALA_EXTERN GType alteration_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Alteration, alteration_unref)
VALA_EXTERN GType marker_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Marker, g_object_unref)
VALA_EXTERN gpointer data_set_ref (gpointer instance);
VALA_EXTERN void data_set_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_data_set (const gchar* name,
                                 const gchar* nick,
                                 const gchar* blurb,
                                 GType object_type,
                                 GParamFlags flags);
VALA_EXTERN void value_set_data_set (GValue* value,
                         gpointer v_object);
VALA_EXTERN void value_take_data_set (GValue* value,
                          gpointer v_object);
VALA_EXTERN gpointer value_get_data_set (const GValue* value);
VALA_EXTERN GType data_set_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (DataSet, data_set_unref)
VALA_EXTERN gchar* data_collection_to_string (DataCollection* self);
VALA_EXTERN void data_collection_notify_items_added (DataCollection* self,
                                         GeeIterable* added);
VALA_EXTERN void data_collection_notify_items_removed (DataCollection* self,
                                           GeeIterable* removed);
VALA_EXTERN void data_collection_notify_contents_altered (DataCollection* self,
                                              GeeIterable* added,
                                              GeeIterable* removed);
VALA_EXTERN void data_collection_notify_items_altered (DataCollection* self,
                                           GeeMap* items);
VALA_EXTERN void data_collection_notify_ordering_changed (DataCollection* self);
VALA_EXTERN void data_collection_notify_property_set (DataCollection* self,
                                          const gchar* name,
                                          GValue* old,
                                          GValue* val);
VALA_EXTERN void data_collection_notify_property_cleared (DataCollection* self,
                                              const gchar* name);
VALA_EXTERN gboolean data_collection_valid_type (DataCollection* self,
                                     DataObject* object);
VALA_EXTERN void data_collection_set_comparator (DataCollection* self,
                                     Comparator comparator,
                                     gpointer comparator_target,
                                     ComparatorPredicate predicate,
                                     gpointer predicate_target);
VALA_EXTERN void data_collection_reset_comparator (DataCollection* self);
VALA_EXTERN GeeCollection* data_collection_get_all (DataCollection* self);
VALA_EXTERN gint data_collection_get_count (DataCollection* self);
VALA_EXTERN DataObject* data_collection_get_at (DataCollection* self,
                                    gint index);
VALA_EXTERN gint data_collection_index_of (DataCollection* self,
                               DataObject* object);
VALA_EXTERN gboolean data_collection_contains (DataCollection* self,
                                   DataObject* object);
VALA_EXTERN gboolean data_collection_add (DataCollection* self,
                              DataObject* object);
VALA_EXTERN GeeCollection* data_collection_add_many (DataCollection* self,
                                         GeeCollection* objects,
                                         ProgressMonitor monitor,
                                         gpointer monitor_target);
VALA_EXTERN void data_collection_remove_marked (DataCollection* self,
                                    Marker* m);
VALA_EXTERN void data_collection_clear (DataCollection* self);
VALA_EXTERN void data_collection_close (DataCollection* self);
VALA_EXTERN void data_collection_notify_frozen (DataCollection* self);
VALA_EXTERN void data_collection_notify_thawed (DataCollection* self);
VALA_EXTERN DataSet* data_set_new (void);
VALA_EXTERN DataSet* data_set_construct (GType object_type);
static GValue* _g_value_dup (GValue* self);
static void _vala_GValue_free (GValue* self);
VALA_EXTERN DataCollection* data_collection_new (const gchar* name);
VALA_EXTERN DataCollection* data_collection_construct (GType object_type,
                                           const gchar* name);
static gchar* data_collection_real_to_string (DataCollection* self);
static void data_collection_real_notify_items_added (DataCollection* self,
                                              GeeIterable* added);
static void data_collection_real_notify_items_removed (DataCollection* self,
                                                GeeIterable* removed);
static void data_collection_real_notify_contents_altered (DataCollection* self,
                                                   GeeIterable* added,
                                                   GeeIterable* removed);
static void data_collection_real_notify_items_altered (DataCollection* self,
                                                GeeMap* items);
static void data_collection_real_notify_ordering_changed (DataCollection* self);
static void data_collection_real_notify_property_set (DataCollection* self,
                                               const gchar* name,
                                               GValue* old,
                                               GValue* val);
static void data_collection_real_notify_property_cleared (DataCollection* self,
                                                   const gchar* name);
VALA_EXTERN GeeCollection* data_collection_get_singleton (DataObject* object);
VALA_EXTERN SingletonCollection* singleton_collection_new (GType g_type,
                                               GBoxedCopyFunc g_dup_func,
                                               GDestroyNotify g_destroy_func,
                                               gconstpointer object);
VALA_EXTERN SingletonCollection* singleton_collection_construct (GType object_type,
                                                     GType g_type,
                                                     GBoxedCopyFunc g_dup_func,
                                                     GDestroyNotify g_destroy_func,
                                                     gconstpointer object);
VALA_EXTERN GType singleton_collection_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SingletonCollection, g_object_unref)
VALA_EXTERN GeeMap* data_collection_get_alteration_singleton (DataObject* object,
                                                  Alteration* alteration);
static gboolean data_collection_real_valid_type (DataCollection* self,
                                          DataObject* object);
VALA_EXTERN Comparator data_collection_get_comparator (DataCollection* self,
                                           gpointer* result_target);
VALA_EXTERN Comparator data_set_get_comparator (DataSet* self,
                                    gpointer* result_target);
VALA_EXTERN ComparatorPredicate data_collection_get_comparator_predicate (DataCollection* self,
                                                              gpointer* result_target);
VALA_EXTERN ComparatorPredicate data_set_get_comparator_predicate (DataSet* self,
                                                       gpointer* result_target);
static void data_collection_real_set_comparator (DataCollection* self,
                                          Comparator comparator,
                                          gpointer comparator_target,
                                          ComparatorPredicate predicate,
                                          gpointer predicate_target);
VALA_EXTERN void data_set_set_comparator (DataSet* self,
                              Comparator user_comparator,
                              gpointer user_comparator_target,
                              ComparatorPredicate comparator_predicate,
                              gpointer comparator_predicate_target);
static void data_collection_real_reset_comparator (DataCollection* self);
VALA_EXTERN void data_set_reset_comparator (DataSet* self);
static GeeCollection* data_collection_real_get_all (DataCollection* self);
VALA_EXTERN GeeList* data_set_get_all (DataSet* self);
VALA_EXTERN DataSet* data_collection_get_dataset_copy (DataCollection* self);
VALA_EXTERN DataSet* data_set_copy (DataSet* self);
static gint data_collection_real_get_count (DataCollection* self);
VALA_EXTERN gint data_set_get_count (DataSet* self);
static DataObject* data_collection_real_get_at (DataCollection* self,
                                         gint index);
VALA_EXTERN DataObject* data_set_get_at (DataSet* self,
                             gint index);
static gint data_collection_real_index_of (DataCollection* self,
                                    DataObject* object);
VALA_EXTERN gint data_set_index_of (DataSet* self,
                        DataObject* object);
static gboolean data_collection_real_contains (DataCollection* self,
                                        DataObject* object);
static gboolean data_collection_internal_contains (DataCollection* self,
                                            DataObject* object);
VALA_EXTERN gboolean data_set_contains (DataSet* self,
                            DataObject* object);
VALA_EXTERN DataCollection* data_object_get_membership (DataObject* self);
static void data_collection_internal_add (DataCollection* self,
                                   DataObject* object);
VALA_EXTERN void data_object_internal_set_membership (DataObject* self,
                                          DataCollection* collection,
                                          gint64 ordinal);
VALA_EXTERN gboolean data_set_add (DataSet* self,
                       DataObject* object);
static void data_collection_internal_add_many (DataCollection* self,
                                        GeeList* objects,
                                        ProgressMonitor monitor,
                                        gpointer monitor_target);
VALA_EXTERN gboolean data_set_add_many (DataSet* self,
                            GeeCollection* objects);
static void data_collection_internal_remove (DataCollection* self,
                                      DataObject* object);
VALA_EXTERN gboolean data_set_remove (DataSet* self,
                          DataObject* object);
VALA_EXTERN void data_object_internal_clear_membership (DataObject* self);
static gboolean data_collection_real_add (DataCollection* self,
                                   DataObject* object);
VALA_EXTERN gchar* data_object_to_string (DataObject* self);
VALA_EXTERN void data_object_notify_membership_changed (DataObject* self,
                                            DataCollection* collection);
static GeeCollection* data_collection_real_add_many (DataCollection* self,
                                              GeeCollection* objects,
                                              ProgressMonitor monitor,
                                              gpointer monitor_target);
VALA_EXTERN Marker* data_collection_start_marking (DataCollection* self);
static DataCollectionMarkerImpl* data_collection_marker_impl_new (DataCollection* owner);
static DataCollectionMarkerImpl* data_collection_marker_impl_construct (GType object_type,
                                                                 DataCollection* owner);
static GType data_collection_marker_impl_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (DataCollectionMarkerImpl, g_object_unref)
VALA_EXTERN Marker* data_collection_mark (DataCollection* self,
                              DataObject* object);
VALA_EXTERN void marker_mark (Marker* self,
                  DataObject* object);
VALA_EXTERN Marker* data_collection_mark_many (DataCollection* self,
                                   GeeCollection* objects);
VALA_EXTERN void marker_mark_many (Marker* self,
                       GeeCollection* list);
VALA_EXTERN void data_collection_act_on_marked (DataCollection* self,
                                    Marker* m,
                                    MarkedAction action,
                                    gpointer action_target,
                                    ProgressMonitor monitor,
                                    gpointer monitor_target,
                                    GObject* user);
static gboolean data_collection_marker_impl_is_valid (DataCollectionMarkerImpl* self,
                                               DataCollection* collection);
static void data_collection_marker_impl_freeze (DataCollectionMarkerImpl* self);
static void data_collection_marker_impl_finished (DataCollectionMarkerImpl* self);
static void data_collection_real_remove_marked (DataCollection* self,
                                         Marker* m);
static void data_collection_real_clear (DataCollection* self);
static void data_collection_real_close (DataCollection* self);
VALA_EXTERN void data_collection_internal_notify_altered (DataCollection* self,
                                              DataObject* object,
                                              Alteration* alteration);
VALA_EXTERN gboolean data_set_resort_object (DataSet* self,
                                 DataObject* object,
                                 Alteration* alteration);
VALA_EXTERN gboolean data_collection_are_notifications_frozen (DataCollection* self);
VALA_EXTERN Alteration* alteration_compress (Alteration* self,
                                 Alteration* other);
VALA_EXTERN GValue* data_collection_get_property (DataCollection* self,
                                      const gchar* name);
VALA_EXTERN void data_collection_set_property (DataCollection* self,
                                   const gchar* name,
                                   GValue* val,
                                   ValueEqualFunc value_equals,
                                   gpointer value_equals_target);
VALA_EXTERN gboolean bool_value_equals (GValue* a,
                            GValue* b);
static gboolean _bool_value_equals_value_equal_func (GValue* a,
                                              GValue* b,
                                              gpointer self);
VALA_EXTERN gboolean int_value_equals (GValue* a,
                           GValue* b);
static gboolean _int_value_equals_value_equal_func (GValue* a,
                                             GValue* b,
                                             gpointer self);
VALA_EXTERN void data_object_notify_collection_property_set (DataObject* self,
                                                 const gchar* name,
                                                 GValue* old,
                                                 GValue* val);
VALA_EXTERN void data_collection_clear_property (DataCollection* self,
                                     const gchar* name);
VALA_EXTERN void data_object_notify_collection_property_cleared (DataObject* self,
                                                     const gchar* name);
VALA_EXTERN void data_collection_freeze_notifications (DataCollection* self);
VALA_EXTERN void data_collection_thaw_notifications (DataCollection* self);
static void data_collection_real_notify_frozen (DataCollection* self);
static void data_collection_real_notify_thawed (DataCollection* self);
static void data_collection_real_items_added (DataCollection* self,
                                       GeeIterable* added);
static void data_collection_real_items_removed (DataCollection* self,
                                         GeeIterable* removed);
static void data_collection_real_contents_altered (DataCollection* self,
                                            GeeIterable* added,
                                            GeeIterable* removed);
static void g_cclosure_user_marshal_VOID__OBJECT_OBJECT (GClosure * closure,
                                                  GValue * return_value,
                                                  guint n_param_values,
                                                  const GValue * param_values,
                                                  gpointer invocation_hint,
                                                  gpointer marshal_data);
static void data_collection_real_items_altered (DataCollection* self,
                                         GeeMap* items);
static void data_collection_real_ordering_changed (DataCollection* self);
static void data_collection_real_property_set (DataCollection* self,
                                        const gchar* name,
                                        GValue* old,
                                        GValue* val);
static void g_cclosure_user_marshal_VOID__STRING_POINTER_BOXED (GClosure * closure,
                                                         GValue * return_value,
                                                         guint n_param_values,
                                                         const GValue * param_values,
                                                         gpointer invocation_hint,
                                                         gpointer marshal_data);
static void data_collection_real_property_cleared (DataCollection* self,
                                            const gchar* name);
static void data_collection_real_frozen (DataCollection* self);
static void data_collection_real_thawed (DataCollection* self);
static void data_collection_marker_impl_on_items_removed (DataCollectionMarkerImpl* self,
                                                   GeeIterable* removed);
static void _data_collection_marker_impl_on_items_removed_data_collection_items_removed (DataCollection* _sender,
                                                                                  GeeIterable* removed,
                                                                                  gpointer self);
static void data_collection_marker_impl_real_mark (Marker* base,
                                            DataObject* object);
static void data_collection_marker_impl_real_unmark (Marker* base,
                                              DataObject* object);
static gboolean data_collection_marker_impl_real_toggle (Marker* base,
                                                  DataObject* object);
static void data_collection_marker_impl_real_mark_many (Marker* base,
                                                 GeeCollection* list);
static void data_collection_marker_impl_real_unmark_many (Marker* base,
                                                   GeeCollection* list);
static void data_collection_marker_impl_real_mark_all (Marker* base);
static gint data_collection_marker_impl_real_get_count (Marker* base);
static GeeCollection* data_collection_marker_impl_real_get_all (Marker* base);
VALA_EXTERN void marker_unmark (Marker* self,
                    DataObject* object);
VALA_EXTERN gboolean marker_toggle (Marker* self,
                        DataObject* object);
VALA_EXTERN void marker_unmark_many (Marker* self,
                         GeeCollection* list);
VALA_EXTERN void marker_mark_all (Marker* self);
VALA_EXTERN gint marker_get_count (Marker* self);
VALA_EXTERN GeeCollection* marker_get_all (Marker* self);
static void data_collection_marker_impl_finalize (GObject * obj);
static GType data_collection_marker_impl_get_type_once (void);
static void data_collection_finalize (DataCollection * obj);
static GType data_collection_get_type_once (void);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static inline gpointer
data_collection_get_instance_private (DataCollection* self)
{
	return G_STRUCT_MEMBER_P (self, DataCollection_private_offset);
}

static GValue*
_g_value_dup (GValue* self)
{
	return g_boxed_copy (G_TYPE_VALUE, self);
}

static void
_vala_GValue_free (GValue* self)
{
	g_boxed_free (G_TYPE_VALUE, self);
}

DataCollection*
data_collection_construct (GType object_type,
                           const gchar* name)
{
	DataCollection* self = NULL;
	gchar* _tmp0_;
	g_return_val_if_fail (name != NULL, NULL);
	self = (DataCollection*) g_type_create_instance (object_type);
	_tmp0_ = g_strdup (name);
	_g_free0 (self->priv->name);
	self->priv->name = _tmp0_;
	return self;
}

DataCollection*
data_collection_new (const gchar* name)
{
	return data_collection_construct (TYPE_DATA_COLLECTION, name);
}

static gchar*
data_collection_real_to_string (DataCollection* self)
{
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* result;
	_tmp0_ = self->priv->name;
	_tmp1_ = g_strdup_printf ("%s (%d)", _tmp0_, data_collection_get_count (self));
	result = _tmp1_;
	return result;
}

gchar*
data_collection_to_string (DataCollection* self)
{
	DataCollectionClass* _klass_;
	g_return_val_if_fail (IS_DATA_COLLECTION (self), NULL);
	_klass_ = DATA_COLLECTION_GET_CLASS (self);
	if (_klass_->to_string) {
		return _klass_->to_string (self);
	}
	return NULL;
}

static void
data_collection_real_notify_items_added (DataCollection* self,
                                         GeeIterable* added)
{
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (added, GEE_TYPE_ITERABLE));
	g_signal_emit (self, data_collection_signals[DATA_COLLECTION_ITEMS_ADDED_SIGNAL], 0, added);
}

void
data_collection_notify_items_added (DataCollection* self,
                                    GeeIterable* added)
{
	DataCollectionClass* _klass_;
	g_return_if_fail (IS_DATA_COLLECTION (self));
	_klass_ = DATA_COLLECTION_GET_CLASS (self);
	if (_klass_->notify_items_added) {
		_klass_->notify_items_added (self, added);
	}
}

static void
data_collection_real_notify_items_removed (DataCollection* self,
                                           GeeIterable* removed)
{
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (removed, GEE_TYPE_ITERABLE));
	g_signal_emit (self, data_collection_signals[DATA_COLLECTION_ITEMS_REMOVED_SIGNAL], 0, removed);
}

void
data_collection_notify_items_removed (DataCollection* self,
                                      GeeIterable* removed)
{
	DataCollectionClass* _klass_;
	g_return_if_fail (IS_DATA_COLLECTION (self));
	_klass_ = DATA_COLLECTION_GET_CLASS (self);
	if (_klass_->notify_items_removed) {
		_klass_->notify_items_removed (self, removed);
	}
}

static void
data_collection_real_notify_contents_altered (DataCollection* self,
                                              GeeIterable* added,
                                              GeeIterable* removed)
{
	g_return_if_fail ((added == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (added, GEE_TYPE_ITERABLE));
	g_return_if_fail ((removed == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (removed, GEE_TYPE_ITERABLE));
	g_signal_emit (self, data_collection_signals[DATA_COLLECTION_CONTENTS_ALTERED_SIGNAL], 0, added, removed);
}

void
data_collection_notify_contents_altered (DataCollection* self,
                                         GeeIterable* added,
                                         GeeIterable* removed)
{
	DataCollectionClass* _klass_;
	g_return_if_fail (IS_DATA_COLLECTION (self));
	_klass_ = DATA_COLLECTION_GET_CLASS (self);
	if (_klass_->notify_contents_altered) {
		_klass_->notify_contents_altered (self, added, removed);
	}
}

static void
data_collection_real_notify_items_altered (DataCollection* self,
                                           GeeMap* items)
{
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (items, GEE_TYPE_MAP));
	g_signal_emit (self, data_collection_signals[DATA_COLLECTION_ITEMS_ALTERED_SIGNAL], 0, items);
}

void
data_collection_notify_items_altered (DataCollection* self,
                                      GeeMap* items)
{
	DataCollectionClass* _klass_;
	g_return_if_fail (IS_DATA_COLLECTION (self));
	_klass_ = DATA_COLLECTION_GET_CLASS (self);
	if (_klass_->notify_items_altered) {
		_klass_->notify_items_altered (self, items);
	}
}

static void
data_collection_real_notify_ordering_changed (DataCollection* self)
{
	g_signal_emit (self, data_collection_signals[DATA_COLLECTION_ORDERING_CHANGED_SIGNAL], 0);
}

void
data_collection_notify_ordering_changed (DataCollection* self)
{
	DataCollectionClass* _klass_;
	g_return_if_fail (IS_DATA_COLLECTION (self));
	_klass_ = DATA_COLLECTION_GET_CLASS (self);
	if (_klass_->notify_ordering_changed) {
		_klass_->notify_ordering_changed (self);
	}
}

static void
data_collection_real_notify_property_set (DataCollection* self,
                                          const gchar* name,
                                          GValue* old,
                                          GValue* val)
{
	GValue _tmp0_;
	g_return_if_fail (name != NULL);
	g_return_if_fail (val != NULL);
	_tmp0_ = *val;
	g_signal_emit (self, data_collection_signals[DATA_COLLECTION_PROPERTY_SET_SIGNAL], 0, name, old, &_tmp0_);
}

void
data_collection_notify_property_set (DataCollection* self,
                                     const gchar* name,
                                     GValue* old,
                                     GValue* val)
{
	DataCollectionClass* _klass_;
	g_return_if_fail (IS_DATA_COLLECTION (self));
	_klass_ = DATA_COLLECTION_GET_CLASS (self);
	if (_klass_->notify_property_set) {
		_klass_->notify_property_set (self, name, old, val);
	}
}

static void
data_collection_real_notify_property_cleared (DataCollection* self,
                                              const gchar* name)
{
	g_return_if_fail (name != NULL);
	g_signal_emit (self, data_collection_signals[DATA_COLLECTION_PROPERTY_CLEARED_SIGNAL], 0, name);
}

void
data_collection_notify_property_cleared (DataCollection* self,
                                         const gchar* name)
{
	DataCollectionClass* _klass_;
	g_return_if_fail (IS_DATA_COLLECTION (self));
	_klass_ = DATA_COLLECTION_GET_CLASS (self);
	if (_klass_->notify_property_cleared) {
		_klass_->notify_property_cleared (self, name);
	}
}

GeeCollection*
data_collection_get_singleton (DataObject* object)
{
	SingletonCollection* _tmp0_;
	GeeCollection* result;
	g_return_val_if_fail (IS_DATA_OBJECT (object), NULL);
	_tmp0_ = singleton_collection_new (TYPE_DATA_OBJECT, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, object);
	result = G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_COLLECTION, GeeCollection);
	return result;
}

GeeMap*
data_collection_get_alteration_singleton (DataObject* object,
                                          Alteration* alteration)
{
	GeeMap* map = NULL;
	GeeHashMap* _tmp0_;
	GeeMap* result;
	g_return_val_if_fail (IS_DATA_OBJECT (object), NULL);
	g_return_val_if_fail (IS_ALTERATION (alteration), NULL);
	_tmp0_ = gee_hash_map_new (TYPE_DATA_OBJECT, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, TYPE_ALTERATION, (GBoxedCopyFunc) alteration_ref, (GDestroyNotify) alteration_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	map = G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_MAP, GeeMap);
	gee_map_set (map, object, alteration);
	result = map;
	return result;
}

static gboolean
data_collection_real_valid_type (DataCollection* self,
                                 DataObject* object)
{
	gboolean result;
	g_return_val_if_fail (IS_DATA_OBJECT (object), FALSE);
	result = TRUE;
	return result;
}

gboolean
data_collection_valid_type (DataCollection* self,
                            DataObject* object)
{
	DataCollectionClass* _klass_;
	g_return_val_if_fail (IS_DATA_COLLECTION (self), FALSE);
	_klass_ = DATA_COLLECTION_GET_CLASS (self);
	if (_klass_->valid_type) {
		return _klass_->valid_type (self, object);
	}
	return FALSE;
}

Comparator
data_collection_get_comparator (DataCollection* self,
                                gpointer* result_target)
{
	DataSet* _tmp0_;
	gpointer _tmp1_ = NULL;
	Comparator _tmp2_;
	Comparator _tmp3_;
	gpointer _tmp3__target;
	Comparator result;
	g_return_val_if_fail (IS_DATA_COLLECTION (self), NULL);
	_tmp0_ = self->priv->dataset;
	_tmp2_ = data_set_get_comparator (_tmp0_, &_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp3__target = _tmp1_;
	*result_target = _tmp3__target;
	result = _tmp3_;
	return result;
}

ComparatorPredicate
data_collection_get_comparator_predicate (DataCollection* self,
                                          gpointer* result_target)
{
	DataSet* _tmp0_;
	gpointer _tmp1_ = NULL;
	ComparatorPredicate _tmp2_;
	ComparatorPredicate _tmp3_;
	gpointer _tmp3__target;
	ComparatorPredicate result;
	g_return_val_if_fail (IS_DATA_COLLECTION (self), NULL);
	_tmp0_ = self->priv->dataset;
	_tmp2_ = data_set_get_comparator_predicate (_tmp0_, &_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp3__target = _tmp1_;
	*result_target = _tmp3__target;
	result = _tmp3_;
	return result;
}

static void
data_collection_real_set_comparator (DataCollection* self,
                                     Comparator comparator,
                                     gpointer comparator_target,
                                     ComparatorPredicate predicate,
                                     gpointer predicate_target)
{
	DataSet* _tmp0_;
	_tmp0_ = self->priv->dataset;
	data_set_set_comparator (_tmp0_, comparator, comparator_target, predicate, predicate_target);
	data_collection_notify_ordering_changed (self);
}

void
data_collection_set_comparator (DataCollection* self,
                                Comparator comparator,
                                gpointer comparator_target,
                                ComparatorPredicate predicate,
                                gpointer predicate_target)
{
	DataCollectionClass* _klass_;
	g_return_if_fail (IS_DATA_COLLECTION (self));
	_klass_ = DATA_COLLECTION_GET_CLASS (self);
	if (_klass_->set_comparator) {
		_klass_->set_comparator (self, comparator, comparator_target, predicate, predicate_target);
	}
}

static void
data_collection_real_reset_comparator (DataCollection* self)
{
	DataSet* _tmp0_;
	_tmp0_ = self->priv->dataset;
	data_set_reset_comparator (_tmp0_);
	data_collection_notify_ordering_changed (self);
}

void
data_collection_reset_comparator (DataCollection* self)
{
	DataCollectionClass* _klass_;
	g_return_if_fail (IS_DATA_COLLECTION (self));
	_klass_ = DATA_COLLECTION_GET_CLASS (self);
	if (_klass_->reset_comparator) {
		_klass_->reset_comparator (self);
	}
}

static GeeCollection*
data_collection_real_get_all (DataCollection* self)
{
	DataSet* _tmp0_;
	GeeList* _tmp1_;
	GeeCollection* result;
	_tmp0_ = self->priv->dataset;
	_tmp1_ = data_set_get_all (_tmp0_);
	result = G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GEE_TYPE_COLLECTION, GeeCollection);
	return result;
}

GeeCollection*
data_collection_get_all (DataCollection* self)
{
	DataCollectionClass* _klass_;
	g_return_val_if_fail (IS_DATA_COLLECTION (self), NULL);
	_klass_ = DATA_COLLECTION_GET_CLASS (self);
	if (_klass_->get_all) {
		return _klass_->get_all (self);
	}
	return NULL;
}

DataSet*
data_collection_get_dataset_copy (DataCollection* self)
{
	DataSet* _tmp0_;
	DataSet* _tmp1_;
	DataSet* result;
	g_return_val_if_fail (IS_DATA_COLLECTION (self), NULL);
	_tmp0_ = self->priv->dataset;
	_tmp1_ = data_set_copy (_tmp0_);
	result = _tmp1_;
	return result;
}

static gint
data_collection_real_get_count (DataCollection* self)
{
	DataSet* _tmp0_;
	gint result;
	_tmp0_ = self->priv->dataset;
	result = data_set_get_count (_tmp0_);
	return result;
}

gint
data_collection_get_count (DataCollection* self)
{
	DataCollectionClass* _klass_;
	g_return_val_if_fail (IS_DATA_COLLECTION (self), 0);
	_klass_ = DATA_COLLECTION_GET_CLASS (self);
	if (_klass_->get_count) {
		return _klass_->get_count (self);
	}
	return -1;
}

static DataObject*
data_collection_real_get_at (DataCollection* self,
                             gint index)
{
	DataSet* _tmp0_;
	DataObject* _tmp1_;
	DataObject* result;
	_tmp0_ = self->priv->dataset;
	_tmp1_ = data_set_get_at (_tmp0_, index);
	result = _tmp1_;
	return result;
}

DataObject*
data_collection_get_at (DataCollection* self,
                        gint index)
{
	DataCollectionClass* _klass_;
	g_return_val_if_fail (IS_DATA_COLLECTION (self), NULL);
	_klass_ = DATA_COLLECTION_GET_CLASS (self);
	if (_klass_->get_at) {
		return _klass_->get_at (self, index);
	}
	return NULL;
}

static gint
data_collection_real_index_of (DataCollection* self,
                               DataObject* object)
{
	DataSet* _tmp0_;
	gint result;
	g_return_val_if_fail (IS_DATA_OBJECT (object), 0);
	_tmp0_ = self->priv->dataset;
	result = data_set_index_of (_tmp0_, object);
	return result;
}

gint
data_collection_index_of (DataCollection* self,
                          DataObject* object)
{
	DataCollectionClass* _klass_;
	g_return_val_if_fail (IS_DATA_COLLECTION (self), 0);
	_klass_ = DATA_COLLECTION_GET_CLASS (self);
	if (_klass_->index_of) {
		return _klass_->index_of (self, object);
	}
	return -1;
}

static gboolean
data_collection_real_contains (DataCollection* self,
                               DataObject* object)
{
	gboolean result;
	g_return_val_if_fail (IS_DATA_OBJECT (object), FALSE);
	result = data_collection_internal_contains (self, object);
	return result;
}

gboolean
data_collection_contains (DataCollection* self,
                          DataObject* object)
{
	DataCollectionClass* _klass_;
	g_return_val_if_fail (IS_DATA_COLLECTION (self), FALSE);
	_klass_ = DATA_COLLECTION_GET_CLASS (self);
	if (_klass_->contains) {
		return _klass_->contains (self, object);
	}
	return FALSE;
}

static gboolean
data_collection_internal_contains (DataCollection* self,
                                   DataObject* object)
{
	DataSet* _tmp0_;
	DataCollection* _tmp1_;
	DataCollection* _tmp2_;
	gboolean result;
	g_return_val_if_fail (IS_DATA_COLLECTION (self), FALSE);
	g_return_val_if_fail (IS_DATA_OBJECT (object), FALSE);
	_tmp0_ = self->priv->dataset;
	if (!data_set_contains (_tmp0_, object)) {
		result = FALSE;
		return result;
	}
	_tmp1_ = data_object_get_membership (object);
	_tmp2_ = _tmp1_;
	_vala_assert (_tmp2_ == self, "object.get_membership() == this");
	_data_collection_unref0 (_tmp2_);
	result = TRUE;
	return result;
}

static void
data_collection_internal_add (DataCollection* self,
                              DataObject* object)
{
	DataCollection* _tmp0_;
	gint64 _tmp1_;
	gboolean added = FALSE;
	DataSet* _tmp2_;
	g_return_if_fail (IS_DATA_COLLECTION (self));
	g_return_if_fail (IS_DATA_OBJECT (object));
	_vala_assert (data_collection_valid_type (self, object), "valid_type(object)");
	_tmp0_ = self;
	_tmp1_ = self->priv->object_ordinal_generator;
	self->priv->object_ordinal_generator = _tmp1_ + 1;
	data_object_internal_set_membership (object, _tmp0_, _tmp1_);
	_tmp2_ = self->priv->dataset;
	added = data_set_add (_tmp2_, object);
	_vala_assert (added, "added");
}

static void
data_collection_internal_add_many (DataCollection* self,
                                   GeeList* objects,
                                   ProgressMonitor monitor,
                                   gpointer monitor_target)
{
	gint count = 0;
	gint _tmp0_;
	gint _tmp1_;
	gboolean added = FALSE;
	DataSet* _tmp9_;
	g_return_if_fail (IS_DATA_COLLECTION (self));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (objects, GEE_TYPE_LIST));
	_tmp0_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (objects, GEE_TYPE_COLLECTION, GeeCollection));
	_tmp1_ = _tmp0_;
	count = _tmp1_;
	{
		gint ctr = 0;
		ctr = 0;
		{
			gboolean _tmp2_ = FALSE;
			_tmp2_ = TRUE;
			while (TRUE) {
				DataObject* object = NULL;
				gpointer _tmp4_;
				DataObject* _tmp5_;
				DataObject* _tmp6_;
				DataCollection* _tmp7_;
				gint64 _tmp8_;
				if (!_tmp2_) {
					gint _tmp3_;
					_tmp3_ = ctr;
					ctr = _tmp3_ + 1;
				}
				_tmp2_ = FALSE;
				if (!(ctr < count)) {
					break;
				}
				_tmp4_ = gee_list_get (objects, ctr);
				object = (DataObject*) _tmp4_;
				_tmp5_ = object;
				_vala_assert (data_collection_valid_type (self, _tmp5_), "valid_type(object)");
				_tmp6_ = object;
				_tmp7_ = self;
				_tmp8_ = self->priv->object_ordinal_generator;
				self->priv->object_ordinal_generator = _tmp8_ + 1;
				data_object_internal_set_membership (_tmp6_, _tmp7_, _tmp8_);
				if (monitor != NULL) {
					monitor ((guint64) ctr, (guint64) count, TRUE, monitor_target);
				}
				_g_object_unref0 (object);
			}
		}
	}
	_tmp9_ = self->priv->dataset;
	added = data_set_add_many (_tmp9_, G_TYPE_CHECK_INSTANCE_CAST (objects, GEE_TYPE_COLLECTION, GeeCollection));
	_vala_assert (added, "added");
}

static void
data_collection_internal_remove (DataCollection* self,
                                 DataObject* object)
{
	gboolean removed = FALSE;
	DataSet* _tmp0_;
	g_return_if_fail (IS_DATA_COLLECTION (self));
	g_return_if_fail (IS_DATA_OBJECT (object));
	_tmp0_ = self->priv->dataset;
	removed = data_set_remove (_tmp0_, object);
	_vala_assert (removed, "removed");
	data_object_internal_clear_membership (object);
}

static gboolean
data_collection_real_add (DataCollection* self,
                          DataObject* object)
{
	GeeCollection* added = NULL;
	GeeCollection* _tmp4_;
	GeeCollection* _tmp5_;
	GeeCollection* _tmp6_;
	gboolean result;
	g_return_val_if_fail (IS_DATA_OBJECT (object), FALSE);
	if (data_collection_internal_contains (self, object)) {
		gchar* _tmp0_;
		gchar* _tmp1_;
		gchar* _tmp2_;
		gchar* _tmp3_;
		_tmp0_ = data_collection_to_string (self);
		_tmp1_ = _tmp0_;
		_tmp2_ = data_object_to_string (object);
		_tmp3_ = _tmp2_;
		g_debug ("DataCollection.vala:311: %s cannot add %s: already present", _tmp1_, _tmp3_);
		_g_free0 (_tmp3_);
		_g_free0 (_tmp1_);
		result = FALSE;
		return result;
	}
	data_collection_internal_add (self, object);
	_tmp4_ = data_collection_get_singleton (object);
	added = _tmp4_;
	_tmp5_ = added;
	data_collection_notify_items_added (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, GEE_TYPE_ITERABLE, GeeIterable));
	_tmp6_ = added;
	data_collection_notify_contents_altered (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, GEE_TYPE_ITERABLE, GeeIterable), NULL);
	data_object_notify_membership_changed (object, self);
	result = TRUE;
	_g_object_unref0 (added);
	return result;
}

gboolean
data_collection_add (DataCollection* self,
                     DataObject* object)
{
	DataCollectionClass* _klass_;
	g_return_val_if_fail (IS_DATA_COLLECTION (self), FALSE);
	_klass_ = DATA_COLLECTION_GET_CLASS (self);
	if (_klass_->add) {
		return _klass_->add (self, object);
	}
	return FALSE;
}

static GeeCollection*
data_collection_real_add_many (DataCollection* self,
                               GeeCollection* objects,
                               ProgressMonitor monitor,
                               gpointer monitor_target)
{
	GeeArrayList* added = NULL;
	GeeArrayList* _tmp0_;
	gint count = 0;
	GeeArrayList* _tmp13_;
	gint _tmp14_;
	gint _tmp15_;
	GeeArrayList* _tmp16_;
	GeeArrayList* _tmp17_;
	GeeArrayList* _tmp18_;
	GeeCollection* result;
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (objects, GEE_TYPE_COLLECTION), NULL);
	_tmp0_ = gee_array_list_new (TYPE_DATA_OBJECT, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	added = _tmp0_;
	{
		GeeIterator* _object_it = NULL;
		GeeIterator* _tmp1_;
		_tmp1_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (objects, GEE_TYPE_ITERABLE, GeeIterable));
		_object_it = _tmp1_;
		while (TRUE) {
			GeeIterator* _tmp2_;
			DataObject* object = NULL;
			GeeIterator* _tmp3_;
			gpointer _tmp4_;
			DataObject* _tmp5_;
			GeeArrayList* _tmp11_;
			DataObject* _tmp12_;
			_tmp2_ = _object_it;
			if (!gee_iterator_next (_tmp2_)) {
				break;
			}
			_tmp3_ = _object_it;
			_tmp4_ = gee_iterator_get (_tmp3_);
			object = (DataObject*) _tmp4_;
			_tmp5_ = object;
			if (data_collection_internal_contains (self, _tmp5_)) {
				gchar* _tmp6_;
				gchar* _tmp7_;
				DataObject* _tmp8_;
				gchar* _tmp9_;
				gchar* _tmp10_;
				_tmp6_ = data_collection_to_string (self);
				_tmp7_ = _tmp6_;
				_tmp8_ = object;
				_tmp9_ = data_object_to_string (_tmp8_);
				_tmp10_ = _tmp9_;
				g_debug ("DataCollection.vala:335: %s cannot add %s: already present", _tmp7_, _tmp10_);
				_g_free0 (_tmp10_);
				_g_free0 (_tmp7_);
				_g_object_unref0 (object);
				continue;
			}
			_tmp11_ = added;
			_tmp12_ = object;
			gee_abstract_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp11_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), _tmp12_);
			_g_object_unref0 (object);
		}
		_g_object_unref0 (_object_it);
	}
	_tmp13_ = added;
	_tmp14_ = gee_abstract_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection));
	_tmp15_ = _tmp14_;
	count = _tmp15_;
	if (count == 0) {
		result = G_TYPE_CHECK_INSTANCE_CAST (added, GEE_TYPE_COLLECTION, GeeCollection);
		return result;
	}
	_tmp16_ = added;
	data_collection_internal_add_many (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp16_, GEE_TYPE_LIST, GeeList), monitor, monitor_target);
	_tmp17_ = added;
	data_collection_notify_items_added (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp17_, GEE_TYPE_ITERABLE, GeeIterable));
	_tmp18_ = added;
	data_collection_notify_contents_altered (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp18_, GEE_TYPE_ITERABLE, GeeIterable), NULL);
	{
		gint ctr = 0;
		ctr = 0;
		{
			gboolean _tmp19_ = FALSE;
			_tmp19_ = TRUE;
			while (TRUE) {
				GeeArrayList* _tmp21_;
				gpointer _tmp22_;
				DataObject* _tmp23_;
				if (!_tmp19_) {
					gint _tmp20_;
					_tmp20_ = ctr;
					ctr = _tmp20_ + 1;
				}
				_tmp19_ = FALSE;
				if (!(ctr < count)) {
					break;
				}
				_tmp21_ = added;
				_tmp22_ = gee_abstract_list_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp21_, GEE_TYPE_ABSTRACT_LIST, GeeAbstractList), ctr);
				_tmp23_ = (DataObject*) _tmp22_;
				data_object_notify_membership_changed (_tmp23_, self);
				_g_object_unref0 (_tmp23_);
			}
		}
	}
	result = G_TYPE_CHECK_INSTANCE_CAST (added, GEE_TYPE_COLLECTION, GeeCollection);
	return result;
}

GeeCollection*
data_collection_add_many (DataCollection* self,
                          GeeCollection* objects,
                          ProgressMonitor monitor,
                          gpointer monitor_target)
{
	DataCollectionClass* _klass_;
	g_return_val_if_fail (IS_DATA_COLLECTION (self), NULL);
	_klass_ = DATA_COLLECTION_GET_CLASS (self);
	if (_klass_->add_many) {
		return _klass_->add_many (self, objects, monitor, monitor_target);
	}
	return NULL;
}

Marker*
data_collection_start_marking (DataCollection* self)
{
	DataCollectionMarkerImpl* _tmp0_;
	Marker* result;
	g_return_val_if_fail (IS_DATA_COLLECTION (self), NULL);
	_tmp0_ = data_collection_marker_impl_new (self);
	result = G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, TYPE_MARKER, Marker);
	return result;
}

Marker*
data_collection_mark (DataCollection* self,
                      DataObject* object)
{
	Marker* marker = NULL;
	DataCollectionMarkerImpl* _tmp0_;
	Marker* result;
	g_return_val_if_fail (IS_DATA_COLLECTION (self), NULL);
	g_return_val_if_fail (IS_DATA_OBJECT (object), NULL);
	_tmp0_ = data_collection_marker_impl_new (self);
	marker = G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, TYPE_MARKER, Marker);
	marker_mark (marker, object);
	result = marker;
	return result;
}

Marker*
data_collection_mark_many (DataCollection* self,
                           GeeCollection* objects)
{
	Marker* marker = NULL;
	DataCollectionMarkerImpl* _tmp0_;
	Marker* result;
	g_return_val_if_fail (IS_DATA_COLLECTION (self), NULL);
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (objects, GEE_TYPE_COLLECTION), NULL);
	_tmp0_ = data_collection_marker_impl_new (self);
	marker = G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, TYPE_MARKER, Marker);
	marker_mark_many (marker, objects);
	result = marker;
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

void
data_collection_act_on_marked (DataCollection* self,
                               Marker* m,
                               MarkedAction action,
                               gpointer action_target,
                               ProgressMonitor monitor,
                               gpointer monitor_target,
                               GObject* user)
{
	DataCollectionMarkerImpl* marker = NULL;
	DataCollectionMarkerImpl* _tmp0_;
	DataCollectionMarkerImpl* _tmp1_;
	DataCollectionMarkerImpl* _tmp2_;
	guint64 count = 0ULL;
	guint64 total = 0ULL;
	DataCollectionMarkerImpl* _tmp3_;
	GeeHashSet* _tmp4_;
	gint _tmp5_;
	gint _tmp6_;
	DataCollectionMarkerImpl* _tmp21_;
	g_return_if_fail (IS_DATA_COLLECTION (self));
	g_return_if_fail (IS_MARKER (m));
	g_return_if_fail ((user == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (user, G_TYPE_OBJECT));
	_tmp0_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (m, DATA_COLLECTION_TYPE_MARKER_IMPL, DataCollectionMarkerImpl));
	marker = _tmp0_;
	_tmp1_ = marker;
	_vala_assert (data_collection_marker_impl_is_valid (_tmp1_, self), "marker.is_valid(this)");
	_tmp2_ = marker;
	data_collection_marker_impl_freeze (_tmp2_);
	count = (guint64) 0;
	_tmp3_ = marker;
	_tmp4_ = _tmp3_->marked;
	_tmp5_ = gee_abstract_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection));
	_tmp6_ = _tmp5_;
	total = (guint64) _tmp6_;
	{
		GeeIterator* _object_it = NULL;
		DataCollectionMarkerImpl* _tmp7_;
		GeeHashSet* _tmp8_;
		GeeIterator* _tmp9_;
		_tmp7_ = marker;
		_tmp8_ = _tmp7_->marked;
		_tmp9_ = gee_abstract_collection_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection));
		_object_it = _tmp9_;
		while (TRUE) {
			GeeIterator* _tmp10_;
			DataObject* object = NULL;
			GeeIterator* _tmp11_;
			gpointer _tmp12_;
			DataObject* _tmp13_;
			DataObject* _tmp17_;
			_tmp10_ = _object_it;
			if (!gee_iterator_next (_tmp10_)) {
				break;
			}
			_tmp11_ = _object_it;
			_tmp12_ = gee_iterator_get (_tmp11_);
			object = (DataObject*) _tmp12_;
			_tmp13_ = object;
			if (!data_collection_internal_contains (self, _tmp13_)) {
				DataObject* _tmp14_;
				gchar* _tmp15_;
				gchar* _tmp16_;
				_tmp14_ = object;
				_tmp15_ = data_object_to_string (_tmp14_);
				_tmp16_ = _tmp15_;
				g_warning ("DataCollection.vala:399: act_on_marked: marker holding ref to unknown " \
"%s", _tmp16_);
				_g_free0 (_tmp16_);
				_g_object_unref0 (object);
				continue;
			}
			_tmp17_ = object;
			if (!action (_tmp17_, user, action_target)) {
				_g_object_unref0 (object);
				break;
			}
			if (monitor != NULL) {
				ProgressMonitor _tmp18_;
				gpointer _tmp18__target;
				guint64 _tmp19_;
				guint64 _tmp20_;
				_tmp18_ = monitor;
				_tmp18__target = monitor_target;
				count = count + 1;
				_tmp19_ = count;
				_tmp20_ = total;
				if (!_tmp18_ (_tmp19_, _tmp20_, TRUE, _tmp18__target)) {
					_g_object_unref0 (object);
					break;
				}
			}
			_g_object_unref0 (object);
		}
		_g_object_unref0 (_object_it);
	}
	_tmp21_ = marker;
	data_collection_marker_impl_finished (_tmp21_);
	_g_object_unref0 (marker);
}

static void
data_collection_real_remove_marked (DataCollection* self,
                                    Marker* m)
{
	DataCollectionMarkerImpl* marker = NULL;
	DataCollectionMarkerImpl* _tmp0_;
	DataCollectionMarkerImpl* _tmp1_;
	DataCollectionMarkerImpl* _tmp2_;
	GeeArrayList* skipped = NULL;
	GeeArrayList* _tmp18_;
	DataCollectionMarkerImpl* _tmp22_;
	GeeHashSet* _tmp23_;
	gint _tmp24_;
	gint _tmp25_;
	DataCollectionMarkerImpl* _tmp37_;
	g_return_if_fail (IS_MARKER (m));
	_tmp0_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (m, DATA_COLLECTION_TYPE_MARKER_IMPL, DataCollectionMarkerImpl));
	marker = _tmp0_;
	_tmp1_ = marker;
	_vala_assert (data_collection_marker_impl_is_valid (_tmp1_, self), "marker.is_valid(this)");
	_tmp2_ = marker;
	data_collection_marker_impl_freeze (_tmp2_);
	skipped = NULL;
	{
		GeeIterator* _object_it = NULL;
		DataCollectionMarkerImpl* _tmp3_;
		GeeHashSet* _tmp4_;
		GeeIterator* _tmp5_;
		_tmp3_ = marker;
		_tmp4_ = _tmp3_->marked;
		_tmp5_ = gee_abstract_collection_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection));
		_object_it = _tmp5_;
		while (TRUE) {
			GeeIterator* _tmp6_;
			DataObject* object = NULL;
			GeeIterator* _tmp7_;
			gpointer _tmp8_;
			DataObject* _tmp9_;
			DataObject* _tmp17_;
			_tmp6_ = _object_it;
			if (!gee_iterator_next (_tmp6_)) {
				break;
			}
			_tmp7_ = _object_it;
			_tmp8_ = gee_iterator_get (_tmp7_);
			object = (DataObject*) _tmp8_;
			_tmp9_ = object;
			if (!data_collection_internal_contains (self, _tmp9_)) {
				DataObject* _tmp10_;
				gchar* _tmp11_;
				gchar* _tmp12_;
				GeeArrayList* _tmp13_;
				GeeArrayList* _tmp15_;
				DataObject* _tmp16_;
				_tmp10_ = object;
				_tmp11_ = data_object_to_string (_tmp10_);
				_tmp12_ = _tmp11_;
				g_warning ("DataCollection.vala:432: remove_marked: marker holding ref to unknown " \
"%s", _tmp12_);
				_g_free0 (_tmp12_);
				_tmp13_ = skipped;
				if (_tmp13_ == NULL) {
					GeeArrayList* _tmp14_;
					_tmp14_ = gee_array_list_new (TYPE_DATA_OBJECT, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
					_g_object_unref0 (skipped);
					skipped = _tmp14_;
				}
				_tmp15_ = skipped;
				_tmp16_ = object;
				gee_abstract_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp15_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), _tmp16_);
				_g_object_unref0 (object);
				continue;
			}
			_tmp17_ = object;
			data_collection_internal_remove (self, _tmp17_);
			_g_object_unref0 (object);
		}
		_g_object_unref0 (_object_it);
	}
	_tmp18_ = skipped;
	if (_tmp18_ != NULL) {
		DataCollectionMarkerImpl* _tmp19_;
		GeeHashSet* _tmp20_;
		GeeArrayList* _tmp21_;
		_tmp19_ = marker;
		_tmp20_ = _tmp19_->marked;
		_tmp21_ = skipped;
		gee_collection_remove_all (G_TYPE_CHECK_INSTANCE_CAST (_tmp20_, GEE_TYPE_COLLECTION, GeeCollection), G_TYPE_CHECK_INSTANCE_CAST (_tmp21_, GEE_TYPE_COLLECTION, GeeCollection));
	}
	_tmp22_ = marker;
	_tmp23_ = _tmp22_->marked;
	_tmp24_ = gee_abstract_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp23_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection));
	_tmp25_ = _tmp24_;
	if (_tmp25_ > 0) {
		DataCollectionMarkerImpl* _tmp26_;
		GeeHashSet* _tmp27_;
		DataCollectionMarkerImpl* _tmp28_;
		GeeHashSet* _tmp29_;
		_tmp26_ = marker;
		_tmp27_ = _tmp26_->marked;
		data_collection_notify_items_removed (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp27_, GEE_TYPE_ITERABLE, GeeIterable));
		_tmp28_ = marker;
		_tmp29_ = _tmp28_->marked;
		data_collection_notify_contents_altered (self, NULL, G_TYPE_CHECK_INSTANCE_CAST (_tmp29_, GEE_TYPE_ITERABLE, GeeIterable));
		{
			GeeIterator* _object_it = NULL;
			DataCollectionMarkerImpl* _tmp30_;
			GeeHashSet* _tmp31_;
			GeeIterator* _tmp32_;
			_tmp30_ = marker;
			_tmp31_ = _tmp30_->marked;
			_tmp32_ = gee_abstract_collection_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp31_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection));
			_object_it = _tmp32_;
			while (TRUE) {
				GeeIterator* _tmp33_;
				DataObject* object = NULL;
				GeeIterator* _tmp34_;
				gpointer _tmp35_;
				DataObject* _tmp36_;
				_tmp33_ = _object_it;
				if (!gee_iterator_next (_tmp33_)) {
					break;
				}
				_tmp34_ = _object_it;
				_tmp35_ = gee_iterator_get (_tmp34_);
				object = (DataObject*) _tmp35_;
				_tmp36_ = object;
				data_object_notify_membership_changed (_tmp36_, NULL);
				_g_object_unref0 (object);
			}
			_g_object_unref0 (_object_it);
		}
	}
	_tmp37_ = marker;
	data_collection_marker_impl_finished (_tmp37_);
	_g_object_unref0 (skipped);
	_g_object_unref0 (marker);
}

void
data_collection_remove_marked (DataCollection* self,
                               Marker* m)
{
	DataCollectionClass* _klass_;
	g_return_if_fail (IS_DATA_COLLECTION (self));
	_klass_ = DATA_COLLECTION_GET_CLASS (self);
	if (_klass_->remove_marked) {
		_klass_->remove_marked (self, m);
	}
}

static void
data_collection_real_clear (DataCollection* self)
{
	DataSet* _tmp0_;
	GeeArrayList* removed = NULL;
	GeeArrayList* _tmp1_;
	GeeArrayList* _tmp10_;
	GeeArrayList* _tmp11_;
	_tmp0_ = self->priv->dataset;
	if (data_set_get_count (_tmp0_) == 0) {
		return;
	}
	_tmp1_ = gee_array_list_new (TYPE_DATA_OBJECT, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	removed = _tmp1_;
	{
		gboolean _tmp2_ = FALSE;
		_tmp2_ = TRUE;
		while (TRUE) {
			DataObject* object = NULL;
			DataSet* _tmp4_;
			DataObject* _tmp5_;
			DataObject* _tmp6_;
			GeeArrayList* _tmp7_;
			DataObject* _tmp8_;
			DataObject* _tmp9_;
			if (!_tmp2_) {
				DataSet* _tmp3_;
				_tmp3_ = self->priv->dataset;
				if (!(data_set_get_count (_tmp3_) > 0)) {
					break;
				}
			}
			_tmp2_ = FALSE;
			_tmp4_ = self->priv->dataset;
			_tmp5_ = data_set_get_at (_tmp4_, 0);
			object = _tmp5_;
			_tmp6_ = object;
			_vala_assert (_tmp6_ != NULL, "object != null");
			_tmp7_ = removed;
			_tmp8_ = object;
			gee_abstract_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), _tmp8_);
			_tmp9_ = object;
			data_collection_internal_remove (self, _tmp9_);
			_g_object_unref0 (object);
		}
	}
	_tmp10_ = removed;
	data_collection_notify_items_removed (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, GEE_TYPE_ITERABLE, GeeIterable));
	_tmp11_ = removed;
	data_collection_notify_contents_altered (self, NULL, G_TYPE_CHECK_INSTANCE_CAST (_tmp11_, GEE_TYPE_ITERABLE, GeeIterable));
	{
		GeeArrayList* _object_list = NULL;
		GeeArrayList* _tmp12_;
		gint _object_size = 0;
		GeeArrayList* _tmp13_;
		gint _tmp14_;
		gint _tmp15_;
		gint _object_index = 0;
		_tmp12_ = removed;
		_object_list = _tmp12_;
		_tmp13_ = _object_list;
		_tmp14_ = gee_abstract_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection));
		_tmp15_ = _tmp14_;
		_object_size = _tmp15_;
		_object_index = -1;
		while (TRUE) {
			gint _tmp16_;
			gint _tmp17_;
			DataObject* object = NULL;
			GeeArrayList* _tmp18_;
			gpointer _tmp19_;
			DataObject* _tmp20_;
			_object_index = _object_index + 1;
			_tmp16_ = _object_index;
			_tmp17_ = _object_size;
			if (!(_tmp16_ < _tmp17_)) {
				break;
			}
			_tmp18_ = _object_list;
			_tmp19_ = gee_abstract_list_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp18_, GEE_TYPE_ABSTRACT_LIST, GeeAbstractList), _object_index);
			object = (DataObject*) _tmp19_;
			_tmp20_ = object;
			data_object_notify_membership_changed (_tmp20_, NULL);
			_g_object_unref0 (object);
		}
	}
	_g_object_unref0 (removed);
}

void
data_collection_clear (DataCollection* self)
{
	DataCollectionClass* _klass_;
	g_return_if_fail (IS_DATA_COLLECTION (self));
	_klass_ = DATA_COLLECTION_GET_CLASS (self);
	if (_klass_->clear) {
		_klass_->clear (self);
	}
}

static void
data_collection_real_close (DataCollection* self)
{
	data_collection_clear (self);
}

void
data_collection_close (DataCollection* self)
{
	DataCollectionClass* _klass_;
	g_return_if_fail (IS_DATA_COLLECTION (self));
	_klass_ = DATA_COLLECTION_GET_CLASS (self);
	if (_klass_->close) {
		_klass_->close (self);
	}
}

static gpointer
_alteration_ref0 (gpointer self)
{
	return self ? alteration_ref (self) : NULL;
}

void
data_collection_internal_notify_altered (DataCollection* self,
                                         DataObject* object,
                                         Alteration* alteration)
{
	gboolean resort_occurred = FALSE;
	DataSet* _tmp0_;
	GeeMap* _tmp12_;
	GeeMap* _tmp13_;
	g_return_if_fail (IS_DATA_COLLECTION (self));
	g_return_if_fail (IS_DATA_OBJECT (object));
	g_return_if_fail (IS_ALTERATION (alteration));
	_vala_assert (data_collection_internal_contains (self, object), "internal_contains(object)");
	_tmp0_ = self->priv->dataset;
	resort_occurred = data_set_resort_object (_tmp0_, object, alteration);
	if (data_collection_are_notifications_frozen (self)) {
		GeeHashMap* _tmp1_;
		Alteration* current = NULL;
		GeeHashMap* _tmp3_;
		gpointer _tmp4_;
		Alteration* _tmp5_;
		GeeHashMap* _tmp9_;
		Alteration* _tmp10_;
		gboolean _tmp11_ = FALSE;
		_tmp1_ = self->priv->frozen_items_altered;
		if (_tmp1_ == NULL) {
			GeeHashMap* _tmp2_;
			_tmp2_ = gee_hash_map_new (TYPE_DATA_OBJECT, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, TYPE_ALTERATION, (GBoxedCopyFunc) alteration_ref, (GDestroyNotify) alteration_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
			_g_object_unref0 (self->priv->frozen_items_altered);
			self->priv->frozen_items_altered = _tmp2_;
		}
		_tmp3_ = self->priv->frozen_items_altered;
		_tmp4_ = gee_abstract_map_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), object);
		current = (Alteration*) _tmp4_;
		_tmp5_ = current;
		if (_tmp5_ != NULL) {
			Alteration* _tmp6_;
			Alteration* _tmp7_;
			_tmp6_ = current;
			_tmp7_ = alteration_compress (_tmp6_, alteration);
			_alteration_unref0 (current);
			current = _tmp7_;
		} else {
			Alteration* _tmp8_;
			_tmp8_ = _alteration_ref0 (alteration);
			_alteration_unref0 (current);
			current = _tmp8_;
		}
		_tmp9_ = self->priv->frozen_items_altered;
		_tmp10_ = current;
		gee_abstract_map_set (G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), object, _tmp10_);
		if (self->priv->fire_ordering_changed) {
			_tmp11_ = TRUE;
		} else {
			_tmp11_ = resort_occurred;
		}
		self->priv->fire_ordering_changed = _tmp11_;
		_alteration_unref0 (current);
		return;
	}
	if (resort_occurred) {
		data_collection_notify_ordering_changed (self);
	}
	_tmp12_ = data_collection_get_alteration_singleton (object, alteration);
	_tmp13_ = _tmp12_;
	data_collection_notify_items_altered (self, _tmp13_);
	_g_object_unref0 (_tmp13_);
}

GValue*
data_collection_get_property (DataCollection* self,
                              const gchar* name)
{
	GeeHashMap* _tmp0_;
	gpointer _tmp1_;
	GValue* result;
	g_return_val_if_fail (IS_DATA_COLLECTION (self), NULL);
	g_return_val_if_fail (name != NULL, NULL);
	_tmp0_ = self->priv->properties;
	_tmp1_ = gee_abstract_map_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), name);
	result = (GValue*) _tmp1_;
	return result;
}

static gboolean
_bool_value_equals_value_equal_func (GValue* a,
                                     GValue* b,
                                     gpointer self)
{
	gboolean result;
	result = bool_value_equals (a, b);
	return result;
}

static gboolean
_int_value_equals_value_equal_func (GValue* a,
                                    GValue* b,
                                    gpointer self)
{
	gboolean result;
	result = int_value_equals (a, b);
	return result;
}

void
data_collection_set_property (DataCollection* self,
                              const gchar* name,
                              GValue* val,
                              ValueEqualFunc value_equals,
                              gpointer value_equals_target)
{
	GValue* old = NULL;
	GeeHashMap* _tmp0_;
	gpointer _tmp1_;
	GValue* _tmp2_;
	GeeHashMap* _tmp6_;
	GValue _tmp7_;
	GValue* _tmp8_;
	GValue _tmp9_;
	gint count = 0;
	DataSet* _tmp10_;
	g_return_if_fail (IS_DATA_COLLECTION (self));
	g_return_if_fail (name != NULL);
	g_return_if_fail (val != NULL);
	if (value_equals == NULL) {
		if (G_VALUE_HOLDS (val, G_TYPE_BOOLEAN)) {
			value_equals = _bool_value_equals_value_equal_func;
			value_equals_target = NULL;
		} else {
			if (G_VALUE_HOLDS (val, G_TYPE_INT)) {
				value_equals = _int_value_equals_value_equal_func;
				value_equals_target = NULL;
			} else {
				g_error ("DataCollection.vala:539: value_equals must be specified for this type");
			}
		}
	}
	_tmp0_ = self->priv->properties;
	_tmp1_ = gee_abstract_map_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), name);
	old = (GValue*) _tmp1_;
	_tmp2_ = old;
	if (((gpointer) _tmp2_) != NULL) {
		GValue* _tmp3_;
		GValue _tmp4_;
		GValue _tmp5_;
		_tmp3_ = old;
		_tmp4_ = *val;
		_tmp5_ = *_tmp3_;
		if (value_equals (&_tmp5_, &_tmp4_, value_equals_target)) {
			__vala_GValue_free0 (old);
			return;
		}
	}
	_tmp6_ = self->priv->properties;
	_tmp7_ = *val;
	gee_abstract_map_set (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), name, &_tmp7_);
	_tmp8_ = old;
	_tmp9_ = *val;
	data_collection_notify_property_set (self, name, _tmp8_, &_tmp9_);
	_tmp10_ = self->priv->dataset;
	count = data_set_get_count (_tmp10_);
	{
		gint ctr = 0;
		ctr = 0;
		{
			gboolean _tmp11_ = FALSE;
			_tmp11_ = TRUE;
			while (TRUE) {
				DataSet* _tmp13_;
				DataObject* _tmp14_;
				DataObject* _tmp15_;
				GValue* _tmp16_;
				GValue _tmp17_;
				if (!_tmp11_) {
					gint _tmp12_;
					_tmp12_ = ctr;
					ctr = _tmp12_ + 1;
				}
				_tmp11_ = FALSE;
				if (!(ctr < count)) {
					break;
				}
				_tmp13_ = self->priv->dataset;
				_tmp14_ = data_set_get_at (_tmp13_, ctr);
				_tmp15_ = _tmp14_;
				_tmp16_ = old;
				_tmp17_ = *val;
				data_object_notify_collection_property_set (_tmp15_, name, _tmp16_, &_tmp17_);
				_g_object_unref0 (_tmp15_);
			}
		}
	}
	__vala_GValue_free0 (old);
}

void
data_collection_clear_property (DataCollection* self,
                                const gchar* name)
{
	GeeHashMap* _tmp0_;
	gint count = 0;
	DataSet* _tmp1_;
	g_return_if_fail (IS_DATA_COLLECTION (self));
	g_return_if_fail (name != NULL);
	_tmp0_ = self->priv->properties;
	if (!gee_abstract_map_unset (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), name, NULL)) {
		return;
	}
	data_collection_notify_property_cleared (self, name);
	_tmp1_ = self->priv->dataset;
	count = data_set_get_count (_tmp1_);
	{
		gint ctr = 0;
		ctr = 0;
		{
			gboolean _tmp2_ = FALSE;
			_tmp2_ = TRUE;
			while (TRUE) {
				DataSet* _tmp4_;
				DataObject* _tmp5_;
				DataObject* _tmp6_;
				if (!_tmp2_) {
					gint _tmp3_;
					_tmp3_ = ctr;
					ctr = _tmp3_ + 1;
				}
				_tmp2_ = FALSE;
				if (!(ctr < count)) {
					break;
				}
				_tmp4_ = self->priv->dataset;
				_tmp5_ = data_set_get_at (_tmp4_, ctr);
				_tmp6_ = _tmp5_;
				data_object_notify_collection_property_cleared (_tmp6_, name);
				_g_object_unref0 (_tmp6_);
			}
		}
	}
}

void
data_collection_freeze_notifications (DataCollection* self)
{
	gint _tmp0_;
	g_return_if_fail (IS_DATA_COLLECTION (self));
	_tmp0_ = self->priv->notifies_frozen;
	self->priv->notifies_frozen = _tmp0_ + 1;
	if (_tmp0_ == 0) {
		data_collection_notify_frozen (self);
	}
}

void
data_collection_thaw_notifications (DataCollection* self)
{
	gint _tmp0_;
	g_return_if_fail (IS_DATA_COLLECTION (self));
	if (self->priv->notifies_frozen == 0) {
		return;
	}
	self->priv->notifies_frozen = self->priv->notifies_frozen - 1;
	_tmp0_ = self->priv->notifies_frozen;
	if (_tmp0_ == 0) {
		data_collection_notify_thawed (self);
	}
}

gboolean
data_collection_are_notifications_frozen (DataCollection* self)
{
	gboolean result;
	g_return_val_if_fail (IS_DATA_COLLECTION (self), FALSE);
	result = self->priv->notifies_frozen > 0;
	return result;
}

static void
data_collection_real_notify_frozen (DataCollection* self)
{
	g_signal_emit (self, data_collection_signals[DATA_COLLECTION_FROZEN_SIGNAL], 0);
}

void
data_collection_notify_frozen (DataCollection* self)
{
	DataCollectionClass* _klass_;
	g_return_if_fail (IS_DATA_COLLECTION (self));
	_klass_ = DATA_COLLECTION_GET_CLASS (self);
	if (_klass_->notify_frozen) {
		_klass_->notify_frozen (self);
	}
}

static void
data_collection_real_notify_thawed (DataCollection* self)
{
	GeeHashMap* _tmp0_;
	_tmp0_ = self->priv->frozen_items_altered;
	if (_tmp0_ != NULL) {
		GeeMap* copy = NULL;
		GeeHashMap* _tmp1_;
		GeeMap* _tmp2_;
		GeeMap* _tmp3_;
		_tmp1_ = self->priv->frozen_items_altered;
		_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GEE_TYPE_MAP, GeeMap));
		copy = _tmp2_;
		_g_object_unref0 (self->priv->frozen_items_altered);
		self->priv->frozen_items_altered = NULL;
		_tmp3_ = copy;
		data_collection_notify_items_altered (self, _tmp3_);
		_g_object_unref0 (copy);
	}
	if (self->priv->fire_ordering_changed) {
		self->priv->fire_ordering_changed = FALSE;
		data_collection_notify_ordering_changed (self);
	}
	g_signal_emit (self, data_collection_signals[DATA_COLLECTION_THAWED_SIGNAL], 0);
}

void
data_collection_notify_thawed (DataCollection* self)
{
	DataCollectionClass* _klass_;
	g_return_if_fail (IS_DATA_COLLECTION (self));
	_klass_ = DATA_COLLECTION_GET_CLASS (self);
	if (_klass_->notify_thawed) {
		_klass_->notify_thawed (self);
	}
}

static void
data_collection_real_items_added (DataCollection* self,
                                  GeeIterable* added)
{
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (added, GEE_TYPE_ITERABLE));
}

static void
data_collection_real_items_removed (DataCollection* self,
                                    GeeIterable* removed)
{
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (removed, GEE_TYPE_ITERABLE));
}

static void
data_collection_real_contents_altered (DataCollection* self,
                                       GeeIterable* added,
                                       GeeIterable* removed)
{
	g_return_if_fail ((added == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (added, GEE_TYPE_ITERABLE));
	g_return_if_fail ((removed == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (removed, GEE_TYPE_ITERABLE));
}

static void
g_cclosure_user_marshal_VOID__OBJECT_OBJECT (GClosure * closure,
                                             GValue * return_value,
                                             guint n_param_values,
                                             const GValue * param_values,
                                             gpointer invocation_hint,
                                             gpointer marshal_data)
{
	typedef void (*GMarshalFunc_VOID__OBJECT_OBJECT) (gpointer data1, gpointer arg_1, gpointer arg_2, gpointer data2);
	register GMarshalFunc_VOID__OBJECT_OBJECT callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 3);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__OBJECT_OBJECT) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_object (param_values + 1), g_value_get_object (param_values + 2), data2);
}

static void
data_collection_real_items_altered (DataCollection* self,
                                    GeeMap* items)
{
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (items, GEE_TYPE_MAP));
}

static void
data_collection_real_ordering_changed (DataCollection* self)
{
}

static void
data_collection_real_property_set (DataCollection* self,
                                   const gchar* name,
                                   GValue* old,
                                   GValue* val)
{
	g_return_if_fail (name != NULL);
	g_return_if_fail (val != NULL);
}

static void
g_cclosure_user_marshal_VOID__STRING_POINTER_BOXED (GClosure * closure,
                                                    GValue * return_value,
                                                    guint n_param_values,
                                                    const GValue * param_values,
                                                    gpointer invocation_hint,
                                                    gpointer marshal_data)
{
	typedef void (*GMarshalFunc_VOID__STRING_POINTER_BOXED) (gpointer data1, const char* arg_1, gpointer arg_2, gpointer arg_3, gpointer data2);
	register GMarshalFunc_VOID__STRING_POINTER_BOXED callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 4);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__STRING_POINTER_BOXED) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_string (param_values + 1), g_value_get_pointer (param_values + 2), g_value_get_boxed (param_values + 3), data2);
}

static void
data_collection_real_property_cleared (DataCollection* self,
                                       const gchar* name)
{
	g_return_if_fail (name != NULL);
}

static void
data_collection_real_frozen (DataCollection* self)
{
}

static void
data_collection_real_thawed (DataCollection* self)
{
}

static void
_data_collection_marker_impl_on_items_removed_data_collection_items_removed (DataCollection* _sender,
                                                                             GeeIterable* removed,
                                                                             gpointer self)
{
	data_collection_marker_impl_on_items_removed ((DataCollectionMarkerImpl*) self, removed);
}

static gpointer
_data_collection_ref0 (gpointer self)
{
	return self ? data_collection_ref (self) : NULL;
}

static DataCollectionMarkerImpl*
data_collection_marker_impl_construct (GType object_type,
                                       DataCollection* owner)
{
	DataCollectionMarkerImpl * self = NULL;
	DataCollection* _tmp0_;
	g_return_val_if_fail (IS_DATA_COLLECTION (owner), NULL);
	self = (DataCollectionMarkerImpl*) g_object_new (object_type, NULL);
	_tmp0_ = _data_collection_ref0 (owner);
	_data_collection_unref0 (self->owner);
	self->owner = _tmp0_;
	g_signal_connect_object (owner, "items-removed", (GCallback) _data_collection_marker_impl_on_items_removed_data_collection_items_removed, self, 0);
	return self;
}

static DataCollectionMarkerImpl*
data_collection_marker_impl_new (DataCollection* owner)
{
	return data_collection_marker_impl_construct (DATA_COLLECTION_TYPE_MARKER_IMPL, owner);
}

static void
data_collection_marker_impl_real_mark (Marker* base,
                                       DataObject* object)
{
	DataCollectionMarkerImpl * self;
	DataCollection* _tmp0_;
	GeeHashSet* _tmp1_;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, DATA_COLLECTION_TYPE_MARKER_IMPL, DataCollectionMarkerImpl);
	g_return_if_fail (IS_DATA_OBJECT (object));
	_tmp0_ = self->owner;
	_vala_assert (data_collection_internal_contains (_tmp0_, object), "owner.internal_contains(object)");
	_tmp1_ = self->marked;
	gee_abstract_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), object);
}

static void
data_collection_marker_impl_real_unmark (Marker* base,
                                         DataObject* object)
{
	DataCollectionMarkerImpl * self;
	DataCollection* _tmp0_;
	GeeHashSet* _tmp1_;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, DATA_COLLECTION_TYPE_MARKER_IMPL, DataCollectionMarkerImpl);
	g_return_if_fail (IS_DATA_OBJECT (object));
	_tmp0_ = self->owner;
	_vala_assert (data_collection_internal_contains (_tmp0_, object), "owner.internal_contains(object)");
	_tmp1_ = self->marked;
	gee_abstract_collection_remove (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), object);
}

static gboolean
data_collection_marker_impl_real_toggle (Marker* base,
                                         DataObject* object)
{
	DataCollectionMarkerImpl * self;
	DataCollection* _tmp0_;
	GeeHashSet* _tmp1_;
	GeeHashSet* _tmp4_;
	gboolean result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, DATA_COLLECTION_TYPE_MARKER_IMPL, DataCollectionMarkerImpl);
	g_return_val_if_fail (IS_DATA_OBJECT (object), FALSE);
	_tmp0_ = self->owner;
	_vala_assert (data_collection_internal_contains (_tmp0_, object), "owner.internal_contains(object)");
	_tmp1_ = self->marked;
	if (gee_abstract_collection_contains (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), object)) {
		GeeHashSet* _tmp2_;
		_tmp2_ = self->marked;
		gee_abstract_collection_remove (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), object);
	} else {
		GeeHashSet* _tmp3_;
		_tmp3_ = self->marked;
		gee_abstract_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), object);
	}
	_tmp4_ = self->marked;
	result = gee_abstract_collection_contains (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), object);
	return result;
}

static void
data_collection_marker_impl_real_mark_many (Marker* base,
                                            GeeCollection* list)
{
	DataCollectionMarkerImpl * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, DATA_COLLECTION_TYPE_MARKER_IMPL, DataCollectionMarkerImpl);
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (list, GEE_TYPE_COLLECTION));
	{
		GeeIterator* _object_it = NULL;
		GeeIterator* _tmp0_;
		_tmp0_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (list, GEE_TYPE_ITERABLE, GeeIterable));
		_object_it = _tmp0_;
		while (TRUE) {
			GeeIterator* _tmp1_;
			DataObject* object = NULL;
			GeeIterator* _tmp2_;
			gpointer _tmp3_;
			DataCollection* _tmp4_;
			DataObject* _tmp5_;
			GeeHashSet* _tmp6_;
			DataObject* _tmp7_;
			_tmp1_ = _object_it;
			if (!gee_iterator_next (_tmp1_)) {
				break;
			}
			_tmp2_ = _object_it;
			_tmp3_ = gee_iterator_get (_tmp2_);
			object = (DataObject*) _tmp3_;
			_tmp4_ = self->owner;
			_tmp5_ = object;
			_vala_assert (data_collection_internal_contains (_tmp4_, _tmp5_), "owner.internal_contains(object)");
			_tmp6_ = self->marked;
			_tmp7_ = object;
			gee_abstract_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), _tmp7_);
			_g_object_unref0 (object);
		}
		_g_object_unref0 (_object_it);
	}
}

static void
data_collection_marker_impl_real_unmark_many (Marker* base,
                                              GeeCollection* list)
{
	DataCollectionMarkerImpl * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, DATA_COLLECTION_TYPE_MARKER_IMPL, DataCollectionMarkerImpl);
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (list, GEE_TYPE_COLLECTION));
	{
		GeeIterator* _object_it = NULL;
		GeeIterator* _tmp0_;
		_tmp0_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (list, GEE_TYPE_ITERABLE, GeeIterable));
		_object_it = _tmp0_;
		while (TRUE) {
			GeeIterator* _tmp1_;
			DataObject* object = NULL;
			GeeIterator* _tmp2_;
			gpointer _tmp3_;
			DataCollection* _tmp4_;
			DataObject* _tmp5_;
			GeeHashSet* _tmp6_;
			DataObject* _tmp7_;
			_tmp1_ = _object_it;
			if (!gee_iterator_next (_tmp1_)) {
				break;
			}
			_tmp2_ = _object_it;
			_tmp3_ = gee_iterator_get (_tmp2_);
			object = (DataObject*) _tmp3_;
			_tmp4_ = self->owner;
			_tmp5_ = object;
			_vala_assert (data_collection_internal_contains (_tmp4_, _tmp5_), "owner.internal_contains(object)");
			_tmp6_ = self->marked;
			_tmp7_ = object;
			gee_abstract_collection_remove (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), _tmp7_);
			_g_object_unref0 (object);
		}
		_g_object_unref0 (_object_it);
	}
}

static void
data_collection_marker_impl_real_mark_all (Marker* base)
{
	DataCollectionMarkerImpl * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, DATA_COLLECTION_TYPE_MARKER_IMPL, DataCollectionMarkerImpl);
	{
		GeeIterator* _object_it = NULL;
		DataCollection* _tmp0_;
		GeeCollection* _tmp1_;
		GeeCollection* _tmp2_;
		GeeIterator* _tmp3_;
		GeeIterator* _tmp4_;
		_tmp0_ = self->owner;
		_tmp1_ = data_collection_get_all (_tmp0_);
		_tmp2_ = _tmp1_;
		_tmp3_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, GEE_TYPE_ITERABLE, GeeIterable));
		_tmp4_ = _tmp3_;
		_g_object_unref0 (_tmp2_);
		_object_it = _tmp4_;
		while (TRUE) {
			GeeIterator* _tmp5_;
			DataObject* object = NULL;
			GeeIterator* _tmp6_;
			gpointer _tmp7_;
			GeeHashSet* _tmp8_;
			DataObject* _tmp9_;
			_tmp5_ = _object_it;
			if (!gee_iterator_next (_tmp5_)) {
				break;
			}
			_tmp6_ = _object_it;
			_tmp7_ = gee_iterator_get (_tmp6_);
			object = (DataObject*) _tmp7_;
			_tmp8_ = self->marked;
			_tmp9_ = object;
			gee_abstract_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), _tmp9_);
			_g_object_unref0 (object);
		}
		_g_object_unref0 (_object_it);
	}
}

static gint
data_collection_marker_impl_real_get_count (Marker* base)
{
	DataCollectionMarkerImpl * self;
	gint _tmp0_ = 0;
	GeeHashSet* _tmp1_;
	gint result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, DATA_COLLECTION_TYPE_MARKER_IMPL, DataCollectionMarkerImpl);
	_tmp1_ = self->marked;
	if (_tmp1_ != NULL) {
		GeeHashSet* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		_tmp2_ = self->marked;
		_tmp3_ = gee_abstract_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection));
		_tmp4_ = _tmp3_;
		_tmp0_ = _tmp4_;
	} else {
		_tmp0_ = self->freeze_count;
	}
	result = _tmp0_;
	return result;
}

static GeeCollection*
data_collection_marker_impl_real_get_all (Marker* base)
{
	DataCollectionMarkerImpl * self;
	GeeArrayList* copy = NULL;
	GeeArrayList* _tmp0_;
	GeeHashSet* _tmp1_;
	GeeCollection* result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, DATA_COLLECTION_TYPE_MARKER_IMPL, DataCollectionMarkerImpl);
	_tmp0_ = gee_array_list_new (TYPE_DATA_OBJECT, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	copy = _tmp0_;
	_tmp1_ = self->marked;
	gee_array_list_add_all (copy, G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GEE_TYPE_COLLECTION, GeeCollection));
	result = G_TYPE_CHECK_INSTANCE_CAST (copy, GEE_TYPE_COLLECTION, GeeCollection);
	return result;
}

static void
data_collection_marker_impl_on_items_removed (DataCollectionMarkerImpl* self,
                                              GeeIterable* removed)
{
	g_return_if_fail (DATA_COLLECTION_IS_MARKER_IMPL (self));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (removed, GEE_TYPE_ITERABLE));
	{
		GeeIterator* _object_it = NULL;
		GeeIterator* _tmp0_;
		_tmp0_ = gee_iterable_iterator (removed);
		_object_it = _tmp0_;
		while (TRUE) {
			GeeIterator* _tmp1_;
			DataObject* object = NULL;
			GeeIterator* _tmp2_;
			gpointer _tmp3_;
			GeeHashSet* _tmp4_;
			DataObject* _tmp5_;
			_tmp1_ = _object_it;
			if (!gee_iterator_next (_tmp1_)) {
				break;
			}
			_tmp2_ = _object_it;
			_tmp3_ = gee_iterator_get (_tmp2_);
			object = (DataObject*) _tmp3_;
			_tmp4_ = self->marked;
			_tmp5_ = object;
			gee_abstract_collection_remove (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), _tmp5_);
			_g_object_unref0 (object);
		}
		_g_object_unref0 (_object_it);
	}
}

static void
data_collection_marker_impl_freeze (DataCollectionMarkerImpl* self)
{
	DataCollection* _tmp0_;
	guint _tmp1_;
	g_return_if_fail (DATA_COLLECTION_IS_MARKER_IMPL (self));
	_tmp0_ = self->owner;
	g_signal_parse_name ("items-removed", TYPE_DATA_COLLECTION, &_tmp1_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (_tmp0_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp1_, 0, NULL, (GCallback) _data_collection_marker_impl_on_items_removed_data_collection_items_removed, self);
}

static void
data_collection_marker_impl_finished (DataCollectionMarkerImpl* self)
{
	GeeHashSet* _tmp0_;
	g_return_if_fail (DATA_COLLECTION_IS_MARKER_IMPL (self));
	_tmp0_ = self->marked;
	if (_tmp0_ != NULL) {
		GeeHashSet* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		_tmp1_ = self->marked;
		_tmp2_ = gee_abstract_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection));
		_tmp3_ = _tmp2_;
		self->freeze_count = _tmp3_;
	}
	_g_object_unref0 (self->marked);
	self->marked = NULL;
}

static gboolean
data_collection_marker_impl_is_valid (DataCollectionMarkerImpl* self,
                                      DataCollection* collection)
{
	gboolean _tmp0_ = FALSE;
	DataCollection* _tmp1_;
	gboolean result;
	g_return_val_if_fail (DATA_COLLECTION_IS_MARKER_IMPL (self), FALSE);
	g_return_val_if_fail (IS_DATA_COLLECTION (collection), FALSE);
	_tmp1_ = self->owner;
	if (collection == _tmp1_) {
		GeeHashSet* _tmp2_;
		_tmp2_ = self->marked;
		_tmp0_ = _tmp2_ != NULL;
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

static void
data_collection_marker_impl_class_init (DataCollectionMarkerImplClass * klass,
                                        gpointer klass_data)
{
	data_collection_marker_impl_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->finalize = data_collection_marker_impl_finalize;
}

static void
data_collection_marker_impl_marker_interface_init (MarkerIface * iface,
                                                   gpointer iface_data)
{
	data_collection_marker_impl_marker_parent_iface = g_type_interface_peek_parent (iface);
	iface->mark = (void (*) (Marker*, DataObject*)) data_collection_marker_impl_real_mark;
	iface->unmark = (void (*) (Marker*, DataObject*)) data_collection_marker_impl_real_unmark;
	iface->toggle = (gboolean (*) (Marker*, DataObject*)) data_collection_marker_impl_real_toggle;
	iface->mark_many = (void (*) (Marker*, GeeCollection*)) data_collection_marker_impl_real_mark_many;
	iface->unmark_many = (void (*) (Marker*, GeeCollection*)) data_collection_marker_impl_real_unmark_many;
	iface->mark_all = (void (*) (Marker*)) data_collection_marker_impl_real_mark_all;
	iface->get_count = (gint (*) (Marker*)) data_collection_marker_impl_real_get_count;
	iface->get_all = (GeeCollection* (*) (Marker*)) data_collection_marker_impl_real_get_all;
}

static void
data_collection_marker_impl_instance_init (DataCollectionMarkerImpl * self,
                                           gpointer klass)
{
	GeeHashSet* _tmp0_;
	_tmp0_ = gee_hash_set_new (TYPE_DATA_OBJECT, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL);
	self->marked = _tmp0_;
	self->freeze_count = 0;
}

static void
data_collection_marker_impl_finalize (GObject * obj)
{
	DataCollectionMarkerImpl * self;
	DataCollection* _tmp0_;
	guint _tmp1_;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, DATA_COLLECTION_TYPE_MARKER_IMPL, DataCollectionMarkerImpl);
	_tmp0_ = self->owner;
	g_signal_parse_name ("items-removed", TYPE_DATA_COLLECTION, &_tmp1_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (_tmp0_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp1_, 0, NULL, (GCallback) _data_collection_marker_impl_on_items_removed_data_collection_items_removed, self);
	_data_collection_unref0 (self->owner);
	_g_object_unref0 (self->marked);
	G_OBJECT_CLASS (data_collection_marker_impl_parent_class)->finalize (obj);
}

static GType
data_collection_marker_impl_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (DataCollectionMarkerImplClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) data_collection_marker_impl_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DataCollectionMarkerImpl), 0, (GInstanceInitFunc) data_collection_marker_impl_instance_init, NULL };
	static const GInterfaceInfo marker_info = { (GInterfaceInitFunc) data_collection_marker_impl_marker_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType data_collection_marker_impl_type_id;
	data_collection_marker_impl_type_id = g_type_register_static (G_TYPE_OBJECT, "DataCollectionMarkerImpl", &g_define_type_info, 0);
	g_type_add_interface_static (data_collection_marker_impl_type_id, TYPE_MARKER, &marker_info);
	return data_collection_marker_impl_type_id;
}

static GType
data_collection_marker_impl_get_type (void)
{
	static volatile gsize data_collection_marker_impl_type_id__once = 0;
	if (g_once_init_enter (&data_collection_marker_impl_type_id__once)) {
		GType data_collection_marker_impl_type_id;
		data_collection_marker_impl_type_id = data_collection_marker_impl_get_type_once ();
		g_once_init_leave (&data_collection_marker_impl_type_id__once, data_collection_marker_impl_type_id);
	}
	return data_collection_marker_impl_type_id__once;
}

static void
value_data_collection_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
value_data_collection_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		data_collection_unref (value->data[0].v_pointer);
	}
}

static void
value_data_collection_copy_value (const GValue* src_value,
                                  GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = data_collection_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
value_data_collection_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
value_data_collection_collect_value (GValue* value,
                                     guint n_collect_values,
                                     GTypeCValue* collect_values,
                                     guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		DataCollection * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = data_collection_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
value_data_collection_lcopy_value (const GValue* value,
                                   guint n_collect_values,
                                   GTypeCValue* collect_values,
                                   guint collect_flags)
{
	DataCollection ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = data_collection_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
param_spec_data_collection (const gchar* name,
                            const gchar* nick,
                            const gchar* blurb,
                            GType object_type,
                            GParamFlags flags)
{
	ParamSpecDataCollection* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_DATA_COLLECTION), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
value_get_data_collection (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_DATA_COLLECTION), NULL);
	return value->data[0].v_pointer;
}

void
value_set_data_collection (GValue* value,
                           gpointer v_object)
{
	DataCollection * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_DATA_COLLECTION));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_DATA_COLLECTION));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		data_collection_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		data_collection_unref (old);
	}
}

void
value_take_data_collection (GValue* value,
                            gpointer v_object)
{
	DataCollection * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_DATA_COLLECTION));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_DATA_COLLECTION));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		data_collection_unref (old);
	}
}

static void
data_collection_class_init (DataCollectionClass * klass,
                            gpointer klass_data)
{
	data_collection_parent_class = g_type_class_peek_parent (klass);
	((DataCollectionClass *) klass)->finalize = data_collection_finalize;
	g_type_class_adjust_private_offset (klass, &DataCollection_private_offset);
	((DataCollectionClass *) klass)->to_string = (gchar* (*) (DataCollection*)) data_collection_real_to_string;
	((DataCollectionClass *) klass)->notify_items_added = (void (*) (DataCollection*, GeeIterable*)) data_collection_real_notify_items_added;
	((DataCollectionClass *) klass)->notify_items_removed = (void (*) (DataCollection*, GeeIterable*)) data_collection_real_notify_items_removed;
	((DataCollectionClass *) klass)->notify_contents_altered = (void (*) (DataCollection*, GeeIterable*, GeeIterable*)) data_collection_real_notify_contents_altered;
	((DataCollectionClass *) klass)->notify_items_altered = (void (*) (DataCollection*, GeeMap*)) data_collection_real_notify_items_altered;
	((DataCollectionClass *) klass)->notify_ordering_changed = (void (*) (DataCollection*)) data_collection_real_notify_ordering_changed;
	((DataCollectionClass *) klass)->notify_property_set = (void (*) (DataCollection*, const gchar*, GValue*, GValue*)) data_collection_real_notify_property_set;
	((DataCollectionClass *) klass)->notify_property_cleared = (void (*) (DataCollection*, const gchar*)) data_collection_real_notify_property_cleared;
	((DataCollectionClass *) klass)->valid_type = (gboolean (*) (DataCollection*, DataObject*)) data_collection_real_valid_type;
	((DataCollectionClass *) klass)->set_comparator = (void (*) (DataCollection*, Comparator, gpointer, ComparatorPredicate, gpointer)) data_collection_real_set_comparator;
	((DataCollectionClass *) klass)->reset_comparator = (void (*) (DataCollection*)) data_collection_real_reset_comparator;
	((DataCollectionClass *) klass)->get_all = (GeeCollection* (*) (DataCollection*)) data_collection_real_get_all;
	((DataCollectionClass *) klass)->get_count = (gint (*) (DataCollection*)) data_collection_real_get_count;
	((DataCollectionClass *) klass)->get_at = (DataObject* (*) (DataCollection*, gint)) data_collection_real_get_at;
	((DataCollectionClass *) klass)->index_of = (gint (*) (DataCollection*, DataObject*)) data_collection_real_index_of;
	((DataCollectionClass *) klass)->contains = (gboolean (*) (DataCollection*, DataObject*)) data_collection_real_contains;
	((DataCollectionClass *) klass)->add = (gboolean (*) (DataCollection*, DataObject*)) data_collection_real_add;
	((DataCollectionClass *) klass)->add_many = (GeeCollection* (*) (DataCollection*, GeeCollection*, ProgressMonitor, gpointer)) data_collection_real_add_many;
	((DataCollectionClass *) klass)->remove_marked = (void (*) (DataCollection*, Marker*)) data_collection_real_remove_marked;
	((DataCollectionClass *) klass)->clear = (void (*) (DataCollection*)) data_collection_real_clear;
	((DataCollectionClass *) klass)->close = (void (*) (DataCollection*)) data_collection_real_close;
	((DataCollectionClass *) klass)->notify_frozen = (void (*) (DataCollection*)) data_collection_real_notify_frozen;
	((DataCollectionClass *) klass)->notify_thawed = (void (*) (DataCollection*)) data_collection_real_notify_thawed;
	((DataCollectionClass *) klass)->items_added = data_collection_real_items_added;
	((DataCollectionClass *) klass)->items_removed = data_collection_real_items_removed;
	((DataCollectionClass *) klass)->contents_altered = data_collection_real_contents_altered;
	((DataCollectionClass *) klass)->items_altered = data_collection_real_items_altered;
	((DataCollectionClass *) klass)->ordering_changed = data_collection_real_ordering_changed;
	((DataCollectionClass *) klass)->property_set = data_collection_real_property_set;
	((DataCollectionClass *) klass)->property_cleared = data_collection_real_property_cleared;
	((DataCollectionClass *) klass)->frozen = data_collection_real_frozen;
	((DataCollectionClass *) klass)->thawed = data_collection_real_thawed;
	data_collection_signals[DATA_COLLECTION_ITEMS_ADDED_SIGNAL] = g_signal_new ("items-added", TYPE_DATA_COLLECTION, G_SIGNAL_RUN_LAST, G_STRUCT_OFFSET (DataCollectionClass, items_added), NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, GEE_TYPE_ITERABLE);
	data_collection_signals[DATA_COLLECTION_ITEMS_REMOVED_SIGNAL] = g_signal_new ("items-removed", TYPE_DATA_COLLECTION, G_SIGNAL_RUN_LAST, G_STRUCT_OFFSET (DataCollectionClass, items_removed), NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, GEE_TYPE_ITERABLE);
	data_collection_signals[DATA_COLLECTION_CONTENTS_ALTERED_SIGNAL] = g_signal_new ("contents-altered", TYPE_DATA_COLLECTION, G_SIGNAL_RUN_LAST, G_STRUCT_OFFSET (DataCollectionClass, contents_altered), NULL, NULL, g_cclosure_user_marshal_VOID__OBJECT_OBJECT, G_TYPE_NONE, 2, GEE_TYPE_ITERABLE, GEE_TYPE_ITERABLE);
	data_collection_signals[DATA_COLLECTION_ITEMS_ALTERED_SIGNAL] = g_signal_new ("items-altered", TYPE_DATA_COLLECTION, G_SIGNAL_RUN_LAST, G_STRUCT_OFFSET (DataCollectionClass, items_altered), NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, GEE_TYPE_MAP);
	data_collection_signals[DATA_COLLECTION_ORDERING_CHANGED_SIGNAL] = g_signal_new ("ordering-changed", TYPE_DATA_COLLECTION, G_SIGNAL_RUN_LAST, G_STRUCT_OFFSET (DataCollectionClass, ordering_changed), NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	data_collection_signals[DATA_COLLECTION_PROPERTY_SET_SIGNAL] = g_signal_new ("property-set", TYPE_DATA_COLLECTION, G_SIGNAL_RUN_LAST, G_STRUCT_OFFSET (DataCollectionClass, property_set), NULL, NULL, g_cclosure_user_marshal_VOID__STRING_POINTER_BOXED, G_TYPE_NONE, 3, G_TYPE_STRING, G_TYPE_POINTER, G_TYPE_VALUE);
	data_collection_signals[DATA_COLLECTION_PROPERTY_CLEARED_SIGNAL] = g_signal_new ("property-cleared", TYPE_DATA_COLLECTION, G_SIGNAL_RUN_LAST, G_STRUCT_OFFSET (DataCollectionClass, property_cleared), NULL, NULL, g_cclosure_marshal_VOID__STRING, G_TYPE_NONE, 1, G_TYPE_STRING);
	data_collection_signals[DATA_COLLECTION_FROZEN_SIGNAL] = g_signal_new ("frozen", TYPE_DATA_COLLECTION, G_SIGNAL_RUN_LAST, G_STRUCT_OFFSET (DataCollectionClass, frozen), NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	data_collection_signals[DATA_COLLECTION_THAWED_SIGNAL] = g_signal_new ("thawed", TYPE_DATA_COLLECTION, G_SIGNAL_RUN_LAST, G_STRUCT_OFFSET (DataCollectionClass, thawed), NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}

static void
data_collection_instance_init (DataCollection * self,
                               gpointer klass)
{
	DataSet* _tmp0_;
	GeeHashMap* _tmp1_;
	self->priv = data_collection_get_instance_private (self);
	_tmp0_ = data_set_new ();
	self->priv->dataset = _tmp0_;
	_tmp1_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, G_TYPE_VALUE, (GBoxedCopyFunc) _g_value_dup, (GDestroyNotify) _vala_GValue_free, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	self->priv->properties = _tmp1_;
	self->priv->object_ordinal_generator = (gint64) 0;
	self->priv->notifies_frozen = 0;
	self->priv->frozen_items_altered = NULL;
	self->priv->fire_ordering_changed = FALSE;
	self->ref_count = 1;
}

static void
data_collection_finalize (DataCollection * obj)
{
	DataCollection * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_DATA_COLLECTION, DataCollection);
	g_signal_handlers_destroy (self);
	_g_free0 (self->priv->name);
	_data_set_unref0 (self->priv->dataset);
	_g_object_unref0 (self->priv->properties);
	_g_object_unref0 (self->priv->frozen_items_altered);
}

static GType
data_collection_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { value_data_collection_init, value_data_collection_free_value, value_data_collection_copy_value, value_data_collection_peek_pointer, "p", value_data_collection_collect_value, "p", value_data_collection_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (DataCollectionClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) data_collection_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DataCollection), 0, (GInstanceInitFunc) data_collection_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType data_collection_type_id;
	data_collection_type_id = g_type_register_fundamental (g_type_fundamental_next (), "DataCollection", &g_define_type_info, &g_define_type_fundamental_info, 0);
	DataCollection_private_offset = g_type_add_instance_private (data_collection_type_id, sizeof (DataCollectionPrivate));
	return data_collection_type_id;
}

GType
data_collection_get_type (void)
{
	static volatile gsize data_collection_type_id__once = 0;
	if (g_once_init_enter (&data_collection_type_id__once)) {
		GType data_collection_type_id;
		data_collection_type_id = data_collection_get_type_once ();
		g_once_init_leave (&data_collection_type_id__once, data_collection_type_id);
	}
	return data_collection_type_id__once;
}

gpointer
data_collection_ref (gpointer instance)
{
	DataCollection * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
data_collection_unref (gpointer instance)
{
	DataCollection * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		DATA_COLLECTION_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

