/*
* Copyright(c) 2019 Intel Corporation
* SPDX - License - Identifier: BSD - 2 - Clause - Patent
*/

#include "EbRateControlTables.h"
static const EbBitNumber initial_rate_control_sad64x64_tables[] = {
     //Q0.txt
    8433,    15005,    17578,    20095,
    22006,    23178,    24255,    25537,
    26140,    26757,    27467,    27979,
    28488,    28944,    29356,    29670,
    30047,    30377,    30703,    31010,
    31343,    31522,    31632,    31840,
    32120,    32306,    32398,    32408,
    32668,    32915,    33046,    33092,
    33172,    33374,    33344,    33317,
    33790,    33744,    33964,    34270,
    34440,    34474,    34550,    34703,
    34653,    34919,    35075,    35163,
    35458,    35333,    35574,    35562,
    36108,    36427,    36845,    37184,
    37196,    37367,    37469,    37951,
    37510,    38009,    38826,    38823,
     //Q01.txt
    2135,    6317,    9166,    11760,
    13718,    14993,    16052,    17263,
    17871,    18474,    19128,    19601,
    20081,    20498,    20893,    21235,
    21580,    21886,    22187,    22491,
    22773,    22955,    23077,    23233,
    23479,    23605,    23729,    23739,
    23988,    24214,    24336,    24403,
    24520,    24720,    24719,    24747,
    25086,    25085,    25239,    25508,
    25641,    25620,    25720,    25861,
    25871,    26094,    26326,    26330,
    26595,    26641,    26774,    26761,
    27212,    27429,    27763,    28219,
    28177,    28255,    28367,    28823,
    28536,    28859,    29580,    29501,
     //Q02.txt
    961,    2830,    5863,    9184,
    11400,    12705,    13779,    15003,
    15615,    16214,    16854,    17324,
    17798,    18210,    18606,    18955,
    19300,    19608,    19905,    20213,
    20492,    20681,    20812,    20965,
    21206,    21335,    21460,    21473,
    21728,    21947,    22076,    22145,
    22268,    22469,    22473,    22498,
    22836,    22845,    22993,    23258,
    23377,    23359,    23461,    23618,
    23635,    23864,    24106,    24094,
    24362,    24431,    24563,    24536,
    24965,    25208,    25553,    26026,
    25960,    26050,    26160,    26611,
    26337,    26651,    27396,    27259,
     //Q03.txt
    536,    1432,    3066,    5519,
    8942,    10635,    11897,    13229,
    13894,    14525,    15181,    15668,
    16144,    16563,    16976,    17339,
    17680,    17994,    18299,    18613,
    18895,    19081,    19215,    19372,
    19615,    19749,    19880,    19896,
    20152,    20375,    20500,    20577,
    20707,    20900,    20917,    20944,
    21266,    21292,    21430,    21689,
    21814,    21788,    21895,    22061,
    22081,    22317,    22556,    22541,
    22805,    22884,    23015,    22983,
    23410,    23648,    24006,    24457,
    24393,    24511,    24608,    25059,
    24791,    25098,    25856,    25688,
     //Q04.txt
    446,    1127,    2334,    3760,
    6184,    7651,    8705,    9796,
    10387,    10960,    11546,    12000,
    12443,    12833,    13215,    13559,
    13875,    14167,    14444,    14722,
    14983,    15157,    15286,    15431,
    15667,    15784,    15917,    15949,
    16180,    16410,    16527,    16609,
    16730,    16930,    16976,    17013,
    17313,    17349,    17490,    17716,
    17844,    17848,    17977,    18122,
    18180,    18426,    18621,    18600,
    18867,    19000,    19146,    19113,
    19464,    19723,    20099,    20513,
    20419,    20596,    20650,    21058,
    20901,    21163,    21877,    21619,
     //Q05.txt
    320,    887,    1720,    2477,
    4048,    5366,    6328,    7256,
    7791,    8311,    8828,    9235,
    9632,    9976,    10308,    10606,
    10862,    11113,    11343,    11565,
    11778,    11924,    12025,    12134,
    12315,    12395,    12489,    12493,
    12682,    12836,    12972,    13015,
    13089,    13248,    13294,    13315,
    13531,    13527,    13643,    13818,
    13884,    13955,    13980,    14149,
    14134,    14361,    14436,    14447,
    14811,    14760,    14902,    14909,
    15176,    15362,    15756,    15910,
    15892,    16055,    16074,    16423,
    16189,    16543,    17040,    17211,
     //Q06.txt
    302,    726,    1400,    1986,
    2985,    4060,    4895,    5670,
    6129,    6566,    6996,    7338,
    7669,    7956,    8232,    8486,
    8701,    8906,    9100,    9287,
    9467,    9590,    9670,    9769,
    9907,    9973,    10053,    10057,
    10190,    10326,    10435,    10478,
    10533,    10678,    10718,    10744,
    10933,    10913,    11016,    11155,
    11198,    11280,    11300,    11405,
    11446,    11597,    11685,    11698,
    11998,    11979,    12142,    12112,
    12313,    12523,    12831,    12966,
    13002,    13099,    13182,    13448,
    13357,    13578,    14091,    14339,
     //Q07.txt
    234,    564,    1094,    1521,
    2144,    3078,    3933,    4678,
    5126,    5546,    5958,    6285,
    6604,    6881,    7145,    7393,
    7602,    7801,    7989,    8168,
    8347,    8469,    8551,    8652,
    8787,    8853,    8933,    8943,
    9078,    9209,    9323,    9366,
    9422,    9566,    9612,    9642,
    9823,    9814,    9914,    10044,
    10092,    10170,    10205,    10300,
    10348,    10493,    10588,    10601,
    10884,    10880,    11036,    11012,
    11195,    11407,    11718,    11846,
    11878,    11983,    12063,    12324,
    12234,    12458,    12953,    13140,
     //Q08.txt
    197,    479,    918,    1263,
    1732,    2503,    3267,    3948,
    4370,    4762,    5150,    5458,
    5759,    6023,    6273,    6512,
    6713,    6905,    7088,    7263,
    7432,    7556,    7639,    7741,
    7874,    7939,    8026,    8039,
    8171,    8298,    8416,    8459,
    8520,    8662,    8709,    8746,
    8916,    8913,    9018,    9141,
    9194,    9265,    9306,    9400,
    9451,    9597,    9694,    9706,
    9974,    9979,    10133,    10112,
    10290,    10502,    10799,    10930,
    10954,    11061,    11142,    11401,
    11314,    11536,    12011,    12156,
     //Q09.txt
    161,    395,    764,    1047,
    1403,    2041,    2730,    3398,
    3829,    4218,    4598,    4898,
    5192,    5447,    5689,    5922,
    6118,    6307,    6484,    6653,
    6820,    6941,    7025,    7125,
    7257,    7325,    7402,    7421,
    7549,    7674,    7791,    7835,
    7898,    8032,    8083,    8121,
    8288,    8285,    8391,    8506,
    8560,    8633,    8677,    8767,
    8823,    8958,    9058,    9072,
    9324,    9336,    9487,    9465,
    9632,    9841,    10141,    10264,
    10281,    10389,    10471,    10722,
    10647,    10849,    11322,    11429,
     //Q10.txt
    144,    347,    661,    898,
    1200,    1732,    2304,    2889,
    3301,    3675,    4036,    4322,
    4601,    4843,    5075,    5299,
    5487,    5666,    5839,    6002,
    6162,    6283,    6367,    6465,
    6595,    6660,    6743,    6763,
    6886,    7012,    7126,    7169,
    7231,    7370,    7419,    7461,
    7619,    7624,    7728,    7838,
    7892,    7963,    8011,    8101,
    8154,    8292,    8390,    8409,
    8647,    8672,    8816,    8796,
    8958,    9166,    9463,    9578,
    9586,    9706,    9788,    10033,
    9956,    10163,    10616,    10696,
     //Q11.txt
    130,    310,    588,    795,
    1054,    1511,    1996,    2510,
    2929,    3296,    3649,    3926,
    4195,    4429,    4653,    4868,
    5050,    5224,    5393,    5551,
    5705,    5822,    5906,    6003,
    6128,    6193,    6276,    6297,
    6418,    6538,    6653,    6694,
    6756,    6893,    6941,    6985,
    7136,    7144,    7245,    7351,
    7409,    7476,    7524,    7613,
    7667,    7799,    7899,    7917,
    8143,    8173,    8314,    8291,
    8450,    8653,    8939,    9061,
    9061,    9192,    9270,    9507,
    9428,    9629,    10080,    10130,
     //Q12.txt
    111,    265,    504,    680,
    904,    1295,    1693,    2101,
    2531,    2913,    3261,    3535,
    3800,    4028,    4247,    4457,
    4636,    4805,    4970,    5122,
    5275,    5389,    5476,    5570,
    5693,    5760,    5840,    5864,
    5981,    6099,    6216,    6256,
    6317,    6453,    6503,    6544,
    6692,    6702,    6802,    6905,
    6965,    7030,    7080,    7168,
    7224,    7351,    7449,    7472,
    7685,    7720,    7854,    7838,
    7987,    8188,    8460,    8587,
    8589,    8713,    8789,    9019,
    8946,    9149,    9583,    9616,
     //Q13.txt
    101,    240,    450,    604,
    801,    1147,    1491,    1823,
    2216,    2588,    2923,    3189,
    3445,    3665,    3874,    4077,
    4249,    4413,    4571,    4718,
    4867,    4979,    5065,    5159,
    5278,    5343,    5420,    5448,
    5561,    5677,    5793,    5830,
    5898,    6028,    6077,    6121,
    6263,    6273,    6375,    6468,
    6531,    6596,    6646,    6735,
    6789,    6916,    7015,    7034,
    7241,    7279,    7412,    7394,
    7535,    7739,    8001,    8129,
    8125,    8252,    8331,    8553,
    8487,    8688,    9110,    9121,
     //Q14.txt
    93,    220,    409,    545,
    723,    1036,    1344,    1627,
    1986,    2351,    2679,    2938,
    3190,    3404,    3607,    3805,
    3972,    4131,    4286,    4425,
    4571,    4679,    4764,    4855,
    4972,    5037,    5114,    5139,
    5253,    5366,    5477,    5515,
    5580,    5706,    5754,    5803,
    5937,    5951,    6050,    6142,
    6205,    6264,    6318,    6406,
    6463,    6580,    6677,    6699,
    6897,    6936,    7070,    7051,
    7185,    7384,    7645,    7770,
    7761,    7894,    7967,    8190,
    8121,    8313,    8731,    8727,
     //Q15.txt
    87,    201,    372,    494,
    654,    938,    1216,    1463,
    1785,    2131,    2450,    2704,
    2950,    3161,    3359,    3550,
    3712,    3866,    4018,    4156,
    4297,    4403,    4490,    4579,
    4694,    4757,    4833,    4859,
    4968,    5080,    5192,    5228,
    5293,    5420,    5466,    5516,
    5649,    5661,    5758,    5847,
    5912,    5969,    6021,    6106,
    6163,    6281,    6374,    6399,
    6590,    6630,    6758,    6743,
    6877,    7076,    7328,    7447,
    7438,    7569,    7643,    7862,
    7794,    7984,    8387,    8374,
     //Q16.txt
    79,    183,    334,    441,
    580,    831,    1079,    1297,
    1582,    1895,    2199,    2446,
    2686,    2890,    3083,    3271,
    3428,    3579,    3726,    3859,
    3997,    4101,    4188,    4274,
    4386,    4446,    4522,    4551,
    4658,    4767,    4877,    4912,
    4976,    5098,    5149,    5196,
    5325,    5341,    5434,    5520,
    5585,    5639,    5693,    5777,
    5831,    5950,    6043,    6066,
    6251,    6295,    6417,    6402,
    6531,    6727,    6978,    7092,
    7081,    7211,    7289,    7494,
    7432,    7621,    8017,    7991,
     //Q17.txt
    74,    170,    309,    405,
    531,    763,    992,    1193,
    1455,    1745,    2035,    2280,
    2518,    2720,    2911,    3096,
    3249,    3398,    3541,    3674,
    3808,    3908,    3994,    4078,
    4190,    4251,    4324,    4351,
    4457,    4564,    4673,    4707,
    4770,    4892,    4937,    4985,
    5111,    5127,    5219,    5303,
    5366,    5421,    5474,    5558,
    5615,    5727,    5817,    5843,
    6018,    6063,    6184,    6169,
    6295,    6488,    6731,    6848,
    6834,    6962,    7039,    7246,
    7182,    7359,    7750,    7719,
     //Q18.txt
    69,    157,    284,    372,
    487,    697,    910,    1097,
    1337,    1602,    1869,    2106,
    2337,    2534,    2718,    2899,
    3049,    3192,    3332,    3460,
    3592,    3690,    3774,    3858,
    3967,    4025,    4099,    4127,
    4231,    4334,    4441,    4476,
    4536,    4656,    4702,    4752,
    4872,    4890,    4981,    5061,
    5122,    5179,    5229,    5314,
    5369,    5483,    5571,    5597,
    5766,    5813,    5929,    5913,
    6038,    6227,    6469,    6581,
    6562,    6691,    6768,    6972,
    6909,    7089,    7467,    7424,
     //Q19.txt
    65,    147,    265,    346,
    449,    642,    842,    1017,
    1241,    1485,    1736,    1966,
    2192,    2385,    2566,    2744,
    2891,    3033,    3168,    3293,
    3423,    3520,    3603,    3685,
    3792,    3849,    3920,    3949,
    4049,    4151,    4255,    4290,
    4352,    4469,    4515,    4562,
    4679,    4699,    4787,    4864,
    4926,    4983,    5033,    5115,
    5167,    5279,    5364,    5394,
    5552,    5603,    5718,    5703,
    5821,    6011,    6246,    6353,
    6336,    6465,    6542,    6739,
    6680,    6850,    7224,    7176,
     //Q20.txt
    61,    138,    244,    316,
    408,    579,    763,    926,
    1131,    1355,    1586,    1802,
    2018,    2205,    2385,    2560,
    2706,    2845,    2977,    3099,
    3225,    3320,    3403,    3484,
    3589,    3644,    3717,    3746,
    3844,    3944,    4049,    4081,
    4143,    4255,    4301,    4350,
    4465,    4481,    4570,    4639,
    4709,    4759,    4811,    4893,
    4947,    5054,    5140,    5166,
    5325,    5376,    5487,    5476,
    5589,    5777,    6002,    6113,
    6092,    6225,    6290,    6490,
    6431,    6596,    6961,    6913,
     //Q21.txt
    57,    128,    227,    293,
    379,    532,    705,    862,
    1051,    1261,    1475,    1680,
    1885,    2068,    2242,    2414,
    2555,    2692,    2821,    2940,
    3063,    3157,    3239,    3318,
    3420,    3477,    3544,    3577,
    3673,    3771,    3873,    3904,
    3968,    4078,    4123,    4172,
    4283,    4304,    4386,    4460,
    4525,    4576,    4624,    4707,
    4759,    4866,    4950,    4978,
    5128,    5172,    5293,    5278,
    5391,    5572,    5793,    5903,
    5885,    6012,    6082,    6275,
    6217,    6382,    6739,    6681,
     //Q22.txt
    54,    121,    213,    276,
    355,    494,    657,    808,
    986,    1184,    1387,    1581,
    1778,    1956,    2128,    2297,
    2437,    2572,    2697,    2814,
    2935,    3027,    3109,    3187,
    3288,    3342,    3409,    3439,
    3533,    3630,    3731,    3763,
    3823,    3933,    3978,    4025,
    4134,    4154,    4237,    4307,
    4368,    4419,    4468,    4548,
    4602,    4706,    4789,    4817,
    4964,    5012,    5121,    5107,
    5219,    5395,    5616,    5723,
    5698,    5831,    5905,    6088,
    6032,    6187,    6546,    6482,
     //Q23.txt
    53,    115,    201,    259,
    331,    458,    608,    752,
    920,    1104,    1296,    1478,
    1663,    1831,    1999,    2165,
    2302,    2434,    2558,    2672,
    2791,    2880,    2961,    3039,
    3137,    3192,    3257,    3289,
    3383,    3474,    3575,    3605,
    3664,    3771,    3817,    3862,
    3971,    3993,    4073,    4141,
    4202,    4254,    4301,    4382,
    4434,    4535,    4617,    4643,
    4788,    4836,    4946,    4934,
    5039,    5213,    5433,    5534,
    5513,    5641,    5714,    5893,
    5841,    5996,    6341,    6278,
     //Q24.txt
    49,    108,    189,    241,
    306,    420,    557,    695,
    853,    1025,    1206,    1375,
    1549,    1710,    1874,    2037,
    2173,    2303,    2424,    2536,
    2653,    2740,    2821,    2897,
    2993,    3047,    3114,    3145,
    3236,    3326,    3427,    3455,
    3516,    3619,    3665,    3709,
    3813,    3836,    3915,    3979,
    4041,    4091,    4139,    4219,
    4273,    4369,    4449,    4477,
    4616,    4662,    4771,    4759,
    4862,    5032,    5247,    5344,
    5322,    5456,    5526,    5701,
    5648,    5799,    6135,    6074,
     //Q25.txt
    46,    100,    171,    217,
    273,    371,    488,    615,
    756,    912,    1076,    1229,
    1386,    1531,    1683,    1840,
    1971,    2097,    2212,    2322,
    2433,    2519,    2598,    2673,
    2766,    2819,    2883,    2917,
    3005,    3094,    3189,    3218,
    3278,    3377,    3424,    3467,
    3568,    3590,    3666,    3734,
    3789,    3840,    3885,    3962,
    4019,    4109,    4187,    4217,
    4349,    4395,    4501,    4488,
    4591,    4759,    4965,    5063,
    5043,    5163,    5238,    5408,
    5357,    5507,    5830,    5764,
     //Q26.txt
    43,    93,    157,    198,
    247,    333,    434,    549,
    677,    819,    970,    1111,
    1255,    1387,    1527,    1677,
    1802,    1924,    2035,    2141,
    2250,    2335,    2413,    2485,
    2575,    2629,    2693,    2728,
    2811,    2898,    2992,    3021,
    3077,    3175,    3220,    3263,
    3360,    3385,    3458,    3518,
    3575,    3626,    3668,    3747,
    3796,    3889,    3965,    3997,
    4120,    4169,    4268,    4258,
    4358,    4520,    4720,    4818,
    4794,    4915,    4991,    5153,
    5103,    5251,    5563,    5496,
     //Q27.txt
    41,    87,    145,    181,
    224,    303,    390,    496,
    612,    743,    883,    1013,
    1146,    1270,    1399,    1540,
    1662,    1778,    1886,    1990,
    2096,    2178,    2254,    2325,
    2413,    2468,    2528,    2564,
    2646,    2731,    2821,    2850,
    2905,    3002,    3045,    3088,
    3180,    3205,    3277,    3335,
    3391,    3438,    3481,    3560,
    3610,    3697,    3772,    3800,
    3921,    3967,    4067,    4057,
    4151,    4315,    4507,    4600,
    4576,    4699,    4769,    4927,
    4879,    5019,    5327,    5256,
     //Q28.txt
    39,    81,    134,    167,
    205,    275,    353,    449,
    554,    674,    803,    924,
    1048,    1163,    1281,    1413,
    1526,    1638,    1742,    1841,
    1944,    2024,    2099,    2169,
    2256,    2309,    2370,    2405,
    2484,    2568,    2656,    2682,
    2740,    2830,    2875,    2915,
    3004,    3031,    3099,    3159,
    3208,    3257,    3296,    3375,
    3421,    3508,    3580,    3612,
    3727,    3770,    3862,    3857,
    3945,    4103,    4292,    4381,
    4362,    4475,    4551,    4705,
    4654,    4792,    5091,    5018,
     //Q29.txt
    37,    77,    125,    155,
    189,    253,    322,    409,
    503,    613,    731,    843,
    958,    1064,    1175,    1295,
    1400,    1506,    1604,    1698,
    1797,    1875,    1948,    2015,
    2100,    2152,    2209,    2246,
    2322,    2404,    2490,    2513,
    2570,    2656,    2702,    2740,
    2828,    2856,    2920,    2976,
    3029,    3075,    3114,    3188,
    3234,    3316,    3387,    3418,
    3528,    3573,    3663,    3656,
    3741,    3893,    4074,    4161,
    4140,    4258,    4327,    4472,
    4430,    4562,    4843,    4776,
     //Q30.txt
    35,    72,    117,    145,
    174,    232,    295,    375,
    462,    563,    673,    777,
    885,    985,    1088,    1202,
    1299,    1400,    1493,    1585,
    1680,    1755,    1827,    1893,
    1974,    2028,    2083,    2119,
    2194,    2273,    2356,    2381,
    2436,    2521,    2563,    2603,
    2686,    2714,    2778,    2829,
    2881,    2930,    2965,    3042,
    3084,    3162,    3229,    3261,
    3366,    3410,    3503,    3493,
    3576,    3720,    3895,    3984,
    3966,    4073,    4145,    4280,
    4240,    4370,    4644,    4572,
     //Q31.txt
    33,    67,    107,    131,
    157,    210,    265,    337,
    413,    502,    601,    697,
    795,    886,    980,    1084,
    1174,    1265,    1353,    1438,
    1528,    1600,    1668,    1733,
    1812,    1863,    1918,    1955,
    2025,    2101,    2181,    2203,
    2256,    2341,    2380,    2420,
    2500,    2522,    2588,    2636,
    2689,    2733,    2768,    2842,
    2881,    2962,    3026,    3054,
    3152,    3196,    3281,    3275,
    3354,    3497,    3659,    3748,
    3724,    3835,    3901,    4031,
    3991,    4125,    4376,    4309,
     //Q32.txt
    31,    62,    99,    120,
    142,    190,    238,    302,
    368,    448,    537,    623,
    714,    798,    884,    979,
    1061,    1146,    1226,    1305,
    1391,    1458,    1525,    1588,
    1664,    1714,    1765,    1803,
    1871,    1945,    2021,    2043,
    2096,    2172,    2215,    2252,
    2329,    2354,    2416,    2461,
    2510,    2552,    2590,    2661,
    2699,    2775,    2837,    2866,
    2960,    3002,    3085,    3076,
    3151,    3287,    3445,    3532,
    3508,    3610,    3679,    3805,
    3766,    3891,    4136,    4069,
     //Q33.txt
    30,    59,    93,    112,
    132,    176,    220,    279,
    342,    415,    498,    579,
    666,    747,    832,    924,
    1001,    1085,    1162,    1240,
    1324,    1391,    1460,    1523,
    1599,    1649,    1699,    1737,
    1804,    1877,    1953,    1975,
    2029,    2103,    2144,    2181,
    2256,    2282,    2340,    2384,
    2434,    2476,    2509,    2578,
    2618,    2690,    2754,    2780,
    2870,    2909,    2988,    2983,
    3057,    3183,    3341,    3425,
    3403,    3499,    3567,    3692,
    3652,    3768,    4008,    3944,
     //Q34.txt
    29,    56,    86,    104,
    122,    162,    203,    257,
    313,    379,    454,    528,
    609,    685,    764,    849,
    921,    998,    1071,    1144,
    1223,    1287,    1353,    1413,
    1487,    1536,    1585,    1622,
    1686,    1757,    1832,    1854,
    1903,    1974,    2014,    2054,
    2124,    2150,    2207,    2247,
    2295,    2337,    2369,    2439,
    2475,    2546,    2607,    2633,
    2717,    2754,    2833,    2828,
    2898,    3026,    3171,    3251,
    3235,    3327,    3393,    3513,
    3475,    3591,    3814,    3755,
     //Q35.txt
    27,    51,    80,    95,
    111,    147,    183,    232,
    282,    341,    407,    473,
    546,    615,    687,    765,
    831,    901,    968,    1035,
    1108,    1167,    1229,    1285,
    1355,    1402,    1450,    1486,
    1545,    1613,    1686,    1705,
    1753,    1822,    1860,    1898,
    1964,    1992,    2043,    2083,
    2131,    2170,    2202,    2266,
    2304,    2371,    2428,    2453,
    2533,    2569,    2639,    2638,
    2707,    2829,    2967,    3042,
    3025,    3117,    3179,    3293,
    3255,    3365,    3581,    3521,
     //Q36.txt
    26,    48,    74,    88,
    101,    134,    165,    210,
    254,    307,    366,    425,
    490,    553,    618,    692,
    752,    816,    878,    940,
    1008,    1063,    1121,    1173,
    1238,    1285,    1330,    1366,
    1421,    1488,    1554,    1575,
    1620,    1687,    1724,    1759,
    1824,    1847,    1901,    1937,
    1986,    2020,    2053,    2114,
    2151,    2216,    2270,    2294,
    2370,    2404,    2474,    2471,
    2539,    2650,    2784,    2858,
    2835,    2930,    2990,    3101,
    3064,    3170,    3367,    3314,
     //Q37.txt
    24,    46,    69,    82,
    93,    124,    152,    192,
    232,    279,    333,    387,
    446,    503,    564,    631,
    686,    745,    802,    860,
    923,    976,    1030,    1081,
    1142,    1185,    1227,    1262,
    1316,    1376,    1440,    1461,
    1505,    1567,    1603,    1640,
    1699,    1723,    1775,    1808,
    1856,    1891,    1920,    1979,
    2014,    2075,    2131,    2152,
    2224,    2257,    2324,    2322,
    2386,    2493,    2619,    2686,
    2676,    2761,    2819,    2921,
    2885,    2990,    3176,    3126,
     //Q38.txt
    23,    43,    64,    75,
    86,    113,    138,    175,
    210,    253,    302,    350,
    403,    455,    510,    572,
    623,    678,    731,    784,
    841,    891,    943,    990,
    1048,    1089,    1129,    1163,
    1214,    1270,    1332,    1352,
    1393,    1451,    1486,    1521,
    1579,    1603,    1652,    1684,
    1731,    1763,    1794,    1851,
    1883,    1940,    1995,    2015,
    2083,    2116,    2176,    2178,
    2238,    2340,    2462,    2525,
    2510,    2594,    2653,    2750,
    2714,    2816,    2991,    2946,
     //Q39.txt
    22,    40,    60,    70,
    79,    104,    126,    159,
    190,    230,    273,    316,
    364,    411,    460,    517,
    563,    612,    661,    709,
    762,    808,    856,    899,
    953,    992,    1031,    1063,
    1108,    1160,    1220,    1238,
    1279,    1330,    1366,    1400,
    1453,    1478,    1523,    1554,
    1599,    1629,    1660,    1715,
    1745,    1799,    1852,    1869,
    1933,    1963,    2023,    2023,
    2079,    2177,    2288,    2356,
    2338,    2420,    2476,    2563,
    2529,    2629,    2794,    2751,
     //Q40.txt
    22,    38,    56,    65,
    73,    96,    116,    146,
    175,    210,    250,    288,
    332,    374,    419,    472,
    514,    559,    605,    649,
    698,    740,    786,    827,
    877,    913,    949,    980,
    1023,    1074,    1128,    1145,
    1184,    1233,    1266,    1297,
    1350,    1373,    1415,    1447,
    1491,    1518,    1546,    1602,
    1629,    1681,    1732,    1747,
    1805,    1840,    1892,    1896,
    1948,    2043,    2145,    2210,
    2196,    2269,    2326,    2409,
    2376,    2471,    2627,    2585,
     //Q41.txt
    21,    36,    53,    60,
    68,    88,    106,    133,
    159,    190,    226,    261,
    301,    338,    379,    427,
    464,    506,    548,    589,
    633,    673,    716,    753,
    799,    832,    868,    896,
    937,    983,    1034,    1051,
    1087,    1131,    1162,    1193,
    1241,    1262,    1305,    1332,
    1374,    1401,    1429,    1482,
    1508,    1558,    1605,    1623,
    1675,    1703,    1755,    1759,
    1808,    1896,    1996,    2058,
    2041,    2113,    2169,    2245,
    2212,    2307,    2447,    2411,
     //Q42.txt
    20,    34,    50,    56,
    63,    82,    98,    122,
    145,    174,    206,    238,
    274,    309,    345,    389,
    423,    461,    499,    536,
    578,    614,    653,    689,
    731,    763,    796,    822,
    859,    902,    951,    966,
    1001,    1041,    1070,    1101,
    1145,    1163,    1203,    1232,
    1272,    1295,    1322,    1374,
    1400,    1445,    1489,    1506,
    1553,    1582,    1632,    1634,
    1683,    1765,    1856,    1911,
    1900,    1970,    2020,    2094,
    2063,    2151,    2283,    2253,
     //Q43.txt
    19,    32,    47,    53,
    58,    75,    90,    112,
    133,    159,    188,    216,
    249,    280,    313,    353,
    384,    418,    454,    488,
    525,    558,    595,    628,
    666,    697,    726,    752,
    787,    826,    874,    886,
    919,    956,    984,    1012,
    1051,    1072,    1109,    1135,
    1171,    1196,    1220,    1268,
    1293,    1334,    1379,    1393,
    1438,    1466,    1511,    1511,
    1559,    1636,    1722,    1776,
    1762,    1826,    1879,    1947,
    1914,    2002,    2121,    2095,
     //Q44.txt
    19,    31,    44,    50,
    54,    70,    83,    103,
    122,    145,    172,    198,
    228,    256,    285,    322,
    350,    381,    414,    444,
    479,    510,    543,    574,
    611,    639,    667,    690,
    722,    759,    804,    813,
    846,    878,    906,    931,
    971,    987,    1023,    1047,
    1081,    1103,    1129,    1171,
    1196,    1238,    1276,    1290,
    1332,    1357,    1402,    1403,
    1446,    1520,    1597,    1649,
    1639,    1700,    1752,    1808,
    1782,    1866,    1975,    1952,
     //Q45.txt
    18,    29,    42,    47,
    51,    65,    77,    95,
    112,    133,    157,    181,
    207,    233,    260,    294,
    319,    346,    377,    404,
    435,    464,    495,    522,
    556,    582,    609,    632,
    659,    695,    735,    745,
    773,    804,    831,    853,
    890,    906,    938,    961,
    992,    1013,    1036,    1079,
    1102,    1138,    1176,    1190,
    1225,    1250,    1289,    1292,
    1335,    1404,    1474,    1522,
    1514,    1568,    1616,    1672,
    1644,    1727,    1824,    1805,
     //Q46.txt
    18,    28,    40,    44,
    47,    61,    71,    88,
    103,    122,    144,    165,
    190,    213,    237,    268,
    291,    317,    344,    368,
    396,    423,    451,    476,
    508,    532,    556,    578,
    604,    635,    674,    683,
    711,    738,    760,    784,
    816,    830,    861,    883,
    911,    931,    954,    995,
    1013,    1050,    1084,    1096,
    1131,    1150,    1186,    1191,
    1228,    1295,    1357,    1406,
    1395,    1445,    1491,    1544,
    1520,    1598,    1685,    1669,
     //Q47.txt
    17,    27,    38,    42,
    45,    57,    66,    81,
    95,    113,    133,    152,
    174,    195,    218,    245,
    266,    289,    314,    337,
    362,    385,    412,    436,
    464,    487,    509,    529,
    553,    582,    618,    625,
    651,    677,    696,    717,
    749,    764,    791,    810,
    838,    855,    878,    916,
    933,    967,    999,    1009,
    1038,    1060,    1093,    1095,
    1131,    1195,    1248,    1294,
    1285,    1331,    1375,    1426,
    1402,    1472,    1550,    1542,
     //Q48.txt
    17,    26,    36,    39,
    42,    53,    62,    75,
    87,    104,    122,    139,
    160,    178,    199,    224,
    243,    264,    287,    307,
    331,    352,    376,    398,
    423,    445,    465,    483,
    505,    533,    565,    572,
    596,    618,    637,    658,
    686,    699,    724,    741,
    768,    785,    806,    842,
    855,    886,    918,    926,
    954,    971,    1004,    1006,
    1039,    1098,    1146,    1192,
    1181,    1225,    1263,    1312,
    1288,    1356,    1423,    1420,
     //Q49.txt
    16,    25,    34,    37,
    39,    49,    57,    70,
    80,    95,    112,    128,
    146,    163,    181,    204,
    222,    240,    261,    280,
    301,    320,    343,    362,
    386,    405,    423,    441,
    462,    486,    516,    523,
    545,    565,    582,    600,
    626,    637,    662,    681,
    702,    719,    739,    770,
    784,    812,    841,    847,
    872,    889,    918,    920,
    952,    1003,    1045,    1087,
    1081,    1119,    1157,    1200,
    1176,    1243,    1301,    1302,
     //Q50.txt
    16,    24,    33,    35,
    37,    46,    53,    65,
    75,    88,    103,    118,
    135,    150,    167,    187,
    203,    220,    239,    256,
    276,    293,    314,    331,
    353,    371,    388,    404,
    423,    446,    473,    478,
    499,    517,    533,    549,
    573,    584,    608,    624,
    643,    658,    677,    707,
    719,    746,    772,    779,
    800,    815,    841,    843,
    873,    917,    954,    993,
    992,    1026,    1059,    1101,
    1079,    1138,    1190,    1192,
     //Q51.txt
    15,    22,    31,    33,
    35,    43,    50,    60,
    69,    81,    95,    108,
    123,    137,    153,    171,
    186,    201,    218,    234,
    252,    267,    286,    303,
    322,    338,    354,    369,
    386,    407,    430,    437,
    455,    472,    487,    503,
    524,    534,    556,    569,
    590,    603,    619,    649,
    658,    684,    706,    714,
    731,    745,    768,    770,
    798,    839,    870,    904,
    906,    937,    969,    1003,
    986,    1039,    1081,    1090,
     //Q52.txt
    15,    21,    29,    31,
    33,    41,    46,    56,
    64,    75,    88,    100,
    113,    126,    140,    157,
    170,    184,    199,    214,
    230,    244,    261,    277,
    294,    309,    323,    337,
    352,    371,    393,    398,
    415,    429,    443,    458,
    478,    486,    506,    521,
    538,    550,    567,    594,
    601,    625,    646,    651,
    666,    678,    698,    700,
    727,    765,    791,    819,
    822,    852,    882,    911,
    896,    947,    981,    993,
     //Q53.txt
    15,    21,    28,    29,
    31,    38,    43,    52,
    59,    69,    81,    92,
    104,    115,    128,    143,
    156,    168,    182,    195,
    210,    222,    238,    252,
    268,    281,    295,    308,
    321,    338,    359,    364,
    379,    392,    403,    418,
    436,    444,    463,    476,
    491,    503,    517,    543,
    549,    570,    589,    594,
    609,    617,    638,    636,
    661,    694,    716,    744,
    748,    771,    798,    825,
    813,    859,    888,    901,
     //Q54.txt
    14,    19,    26,    28,
    29,    35,    40,    48,
    54,    64,    74,    84,
    96,    106,    118,    131,
    142,    154,    167,    179,
    191,    202,    218,    230,
    245,    257,    269,    282,
    294,    309,    328,    332,
    345,    357,    368,    382,
    397,    406,    422,    433,
    448,    459,    472,    496,
    503,    522,    539,    543,
    555,    562,    579,    579,
    601,    630,    648,    673,
    677,    698,    724,    750,
    736,    781,    800,    820,
     //Q55.txt
    13,    18,    25,    26,
    27,    33,    38,    44,
    50,    58,    68,    77,
    87,    96,    107,    119,
    129,    140,    151,    163,
    174,    184,    198,    209,
    222,    233,    245,    256,
    266,    280,    297,    300,
    313,    324,    333,    345,
    359,    367,    382,    393,
    405,    415,    427,    450,
    454,    472,    488,    491,
    502,    507,    523,    523,
    542,    569,    581,    604,
    611,    626,    652,    671,
    661,    698,    715,    738,
     //Q56.txt
    13,    18,    23,    25,
    25,    31,    35,    41,
    46,    53,    62,    70,
    79,    88,    97,    109,
    117,    127,    138,    148,
    157,    167,    179,    189,
    202,    210,    222,    232,
    242,    253,    268,    272,
    283,    292,    301,    313,
    324,    332,    346,    356,
    367,    377,    386,    408,
    411,    427,    440,    444,
    452,    454,    471,    472,
    490,    512,    522,    542,
    551,    562,    588,    602,
    593,    625,    638,    663,
     //Q57.txt
    12,    17,    22,    23,
    24,    28,    32,    37,
    42,    48,    56,    64,
    72,    79,    88,    98,
    106,    114,    124,    133,
    142,    150,    161,    170,
    181,    190,    200,    209,
    218,    228,    241,    245,
    256,    264,    272,    282,
    293,    299,    310,    321,
    330,    339,    349,    368,
    370,    385,    396,    400,
    408,    408,    421,    424,
    440,    458,    466,    485,
    493,    503,    523,    539,
    530,    557,    567,    592,
     //Q58.txt
    12,    16,    21,    21,
    22,    26,    29,    34,
    38,    44,    51,    57,
    64,    71,    79,    88,
    95,    102,    111,    119,
    127,    134,    144,    152,
    162,    169,    178,    187,
    195,    204,    216,    218,
    227,    235,    243,    251,
    262,    267,    277,    287,
    296,    303,    311,    329,
    331,    343,    352,    356,
    362,    363,    376,    377,
    394,    409,    413,    432,
    439,    446,    463,    477,
    470,    495,    500,    523,
     //Q59.txt
    11,    15,    19,    20,
    20,    24,    27,    31,
    34,    39,    45,    51,
    57,    63,    70,    77,
    84,    91,    99,    105,
    112,    119,    128,    135,
    143,    150,    158,    166,
    173,    181,    191,    194,
    202,    208,    215,    223,
    232,    238,    245,    254,
    262,    268,    276,    290,
    293,    304,    312,    315,
    319,    320,    330,    332,
    347,    360,    363,    378,
    386,    393,    408,    419,
    414,    436,    436,    459,
     //Q60.txt
    11,    14,    18,    18,
    18,    22,    24,    27,
    30,    35,    40,    45,
    50,    55,    61,    67,
    73,    79,    86,    92,
    98,    104,    112,    118,
    126,    131,    139,    146,
    151,    158,    167,    170,
    177,    182,    188,    195,
    202,    207,    214,    221,
    228,    233,    240,    253,
    255,    264,    271,    274,
    278,    280,    286,    289,
    303,    314,    314,    329,
    336,    342,    353,    364,
    358,    375,    375,    398,
     //Q61.txt
    10,    13,    16,    16,
    16,    19,    21,    24,
    26,    30,    35,    39,
    43,    47,    53,    58,
    63,    68,    74,    79,
    84,    89,    97,    101,
    108,    113,    119,    126,
    131,    136,    144,    147,
    153,    157,    162,    168,
    173,    178,    184,    190,
    196,    199,    205,    216,
    217,    226,    232,    236,
    240,    239,    245,    247,
    260,    270,    268,    281,
    289,    294,    300,    311,
    306,    318,    315,    341,
     //Q62.txt
    9,    11,    14,    14,
    14,    17,    18,    20,
    22,    25,    29,    32,
    35,    38,    43,    47,
    51,    56,    61,    65,
    68,    73,    79,    83,
    88,    92,    97,    103,
    107,    112,    118,    120,
    125,    128,    132,    137,
    141,    145,    149,    154,
    159,    161,    165,    173,
    173,    180,    184,    189,
    194,    193,    197,    202,
    213,    218,    219,    228,
    235,    241,    247,    253,
    249,    257,    253,    277,
     //Q63.txt
    9,    10,    12,    12,
    12,    13,    15,    16,
    17,    20,    22,    24,
    27,    29,    33,    36,
    39,    42,    46,    49,
    52,    55,    60,    63,
    67,    69,    74,    79,
    81,    85,    90,    92,
    96,    98,    101,    104,
    107,    110,    113,    118,
    121,    122,    125,    130,
    129,    134,    136,    142,
    146,    147,    149,    154,
    162,    165,    166,    170,
    176,    178,    184,    187,
    186,    192,    190,    212,
};

static const EbBitNumber initial_rate_control_intra_sad64x64_tables[] = {
     //Q00.txt
    23321,    25349,    27949,    29185,
    29008,    29509,    30245,    30561,
    31327,    31812,    32137,    32271,
    32765,    33464,    34222,    33984,
    34449,    34763,    34582,    35193,
    35594,    35794,    35814,    35006,
    34851,    35329,    34934,    35150,
    35291,    36626,    36653,    37541,
    36772,    36745,    36917,    36212,
    35592,    35488,    35662,    33989,
    34742,    35507,    35511,    36065,
    36030,    37168,    36393,    35742,
    37839,    35920,    38729,    38959,
    36270,    39367,    39047,    36516,
    35325,    35197,    33217,    33761,
    33155,    34627,    34303,    34218,
     //Q01.txt
    15066,    17197,    19402,    20304,
    20479,    20922,    21569,    21916,
    22430,    22829,    23133,    23265,
    23649,    24121,    24649,    24453,
    24813,    25107,    24948,    25356,
    25665,    25826,    25847,    25357,
    25217,    25545,    25312,    25473,
    25546,    26451,    26490,    27135,
    26639,    26566,    26664,    26266,
    25937,    25774,    25907,    24777,
    25307,    25770,    25756,    26128,
    26055,    26763,    26298,    25826,
    27252,    26108,    27664,    27898,
    26363,    28234,    28056,    26369,
    25494,    25406,    24200,    24575,
    23823,    24998,    24600,    24557,
     //Q02.txt
    13014,    15153,    17303,    18179,
    18355,    18788,    19414,    19764,
    20253,    20640,    20937,    21059,
    21444,    21888,    22404,    22210,
    22556,    22837,    22702,    23086,
    23380,    23542,    23559,    23083,
    22957,    23264,    23048,    23199,
    23272,    24146,    24175,    24809,
    24336,    24246,    24343,    23954,
    23654,    23438,    23596,    22542,
    23041,    23452,    23458,    23817,
    23741,    24446,    23975,    23505,
    24894,    23847,    25316,    25555,
    24152,    25859,    25701,    24051,
    23202,    23129,    22019,    22373,
    21548,    22741,    22327,    22250,
     //Q03.txt
    11534,    13750,    15868,    16720,
    16905,    17330,    17945,    18295,
    18705,    19137,    19429,    19547,
    19932,    20355,    20868,    20645,
    21012,    21292,    21166,    21525,
    21807,    21976,    21991,    21520,
    21405,    21697,    21493,    21621,
    21691,    22551,    22574,    23206,
    22753,    22654,    22749,    22363,
    22077,    21802,    22002,    21002,
    21474,    21861,    21876,    22207,
    22127,    22825,    22354,    21881,
    23240,    22253,    23673,    23920,
    22590,    24192,    24062,    22429,
    21581,    21519,    20469,    20807,
    19907,    21131,    20743,    20633,
     //Q04.txt
    8221,    10061,    11788,    12473,
    12719,    13142,    13645,    13957,
    14294,    14667,    14902,    15023,
    15342,    15671,    16141,    15976,
    16226,    16439,    16346,    16614,
    16860,    16963,    16947,    16618,
    16482,    16713,    16595,    16706,
    16655,    17259,    17232,    17782,
    17410,    17274,    17388,    17042,
    16810,    16593,    16802,    15880,
    16236,    16525,    16551,    16941,
    16536,    17103,    16660,    16186,
    17011,    16310,    17254,    17649,
    17058,    17969,    17538,    16361,
    15761,    16035,    15429,    15018,
    14785,    15324,    14622,    15862,
     //Q05.txt
    6165,    7848,    9435,    10092,
    10294,    10726,    11168,    11466,
    11798,    12145,    12388,    12493,
    12799,    13100,    13557,    13423,
    13649,    13836,    13753,    14003,
    14286,    14422,    14462,    14227,
    14059,    14366,    14244,    14345,
    14353,    14907,    14939,    15486,
    15119,    15030,    15147,    14753,
    14483,    14212,    14341,    13492,
    13847,    14039,    14085,    14499,
    14229,    14668,    14241,    13774,
    14774,    14301,    15261,    15629,
    15184,    15996,    15653,    14636,
    13930,    14008,    13256,    12520,
    12276,    12726,    12020,    13403,
     //Q06.txt
    4719,    6233,    7578,    8132,
    8333,    8722,    9091,    9347,
    9635,    9919,    10121,    10211,
    10460,    10687,    11083,    10972,
    11133,    11283,    11199,    11394,
    11632,    11740,    11759,    11578,
    11403,    11666,    11594,    11691,
    11671,    12090,    12102,    12604,
    12324,    12232,    12312,    12053,
    11801,    11607,    11719,    11106,
    11361,    11468,    11526,    11871,
    11562,    11990,    11578,    11264,
    12056,    11645,    12423,    12691,
    12398,    13046,    12773,    11970,
    11398,    11377,    10844,    10259,
    10097,    10505,    9883,    11071,
     //Q07.txt
    3940,    5359,    6619,    7134,
    7339,    7717,    8065,    8311,
    8588,    8862,    9059,    9147,
    9385,    9602,    9990,    9883,
    10033,    10170,    10084,    10274,
    10520,    10624,    10643,    10473,
    10300,    10558,    10498,    10590,
    10566,    10972,    10978,    11463,
    11189,    11115,    11194,    10938,
    10691,    10498,    10617,    10038,
    10280,    10399,    10460,    10796,
    10505,    10933,    10525,    10201,
    10973,    10595,    11345,    11608,
    11346,    11965,    11733,    10963,
    10401,    10383,    9873,    9328,
    9158,    9576,    8977,    10053,
     //Q08.txt
    3375,    4690,    5871,    6353,
    6554,    6920,    7250,    7482,
    7751,    8014,    8204,    8291,
    8520,    8727,    9102,    9003,
    9143,    9270,    9182,    9374,
    9618,    9718,    9738,    9575,
    9408,    9660,    9610,    9698,
    9671,    10063,    10064,    10535,
    10266,    10207,    10286,    10034,
    9791,    9604,    9728,    9181,
    9413,    9537,    9595,    9924,
    9647,    10077,    9673,    9345,
    10095,    9740,    10475,    10729,
    10496,    11087,    10882,    10135,
    9597,    9581,    9095,    8573,
    8405,    8825,    8242,    9228,
     //Q09.txt
    2994,    4242,    5364,    5817,
    6013,    6365,    6679,    6901,
    7162,    7413,    7599,    7684,
    7902,    8106,    8467,    8373,
    8506,    8623,    8536,    8727,
    8968,    9063,    9083,    8927,
    8764,    9011,    8965,    9050,
    9021,    9402,    9399,    9855,
    9585,    9543,    9621,    9373,
    9134,    8958,    9082,    8558,
    8782,    8907,    8965,    9286,
    9020,    9442,    9048,    8718,
    9451,    9116,    9831,    10081,
    9868,    10436,    10251,    9525,
    9006,    8991,    8522,    8025,
    7855,    8272,    7709,    8627,
     //Q10.txt
    2594,    3770,    4831,    5254,
    5445,    5787,    6087,    6299,
    6552,    6795,    6977,    7059,
    7268,    7467,    7820,    7731,
    7856,    7965,    7877,    8070,
    8309,    8401,    8421,    8271,
    8113,    8353,    8314,    8394,
    8364,    8736,    8728,    9172,
    8909,    8878,    8956,    8711,
    8469,    8309,    8435,    7931,
    8145,    8272,    8329,    8638,
    8388,    8809,    8419,    8090,
    8802,    8485,    9188,    9437,
    9240,    9784,    9622,    8917,
    8410,    8398,    7948,    7473,
    7304,    7713,    7169,    8026,
     //Q11.txt
    2327,    3450,    4462,    4859,
    5045,    5375,    5661,    5866,
    6110,    6346,    6523,    6602,
    6803,    6996,    7339,    7256,
    7374,    7477,    7388,    7579,
    7816,    7904,    7925,    7777,
    7625,    7858,    7822,    7901,
    7870,    8231,    8220,    8652,
    8395,    8373,    8449,    8210,
    7964,    7820,    7945,    7461,
    7666,    7793,    7850,    8150,
    7908,    8327,    7943,    7619,
    8308,    8009,    8697,    8942,
    8760,    9281,    9138,    8448,
    7961,    7948,    7507,    7051,
    6894,    7294,    6761,    7575,
     //Q12.txt
    2075,    3156,    4124,    4502,
    4679,    4999,    5274,    5470,
    5705,    5935,    6108,    6186,
    6377,    6565,    6900,    6821,
    6933,    7030,    6944,    7134,
    7364,    7450,    7471,    7326,
    7180,    7407,    7375,    7448,
    7420,    7773,    7758,    8179,
    7929,    7913,    7988,    7750,
    7492,    7375,    7499,    7028,
    7232,    7356,    7412,    7707,
    7471,    7883,    7509,    7188,
    7860,    7572,    8246,    8489,
    8316,    8826,    8694,    8018,
    7543,    7529,    7102,    6665,
    6514,    6909,    6384,    7154,
     //Q13.txt
    1848,    2877,    3802,    4157,
    4328,    4641,    4904,    5094,
    5321,    5546,    5715,    5791,
    5977,    6158,    6487,    6412,
    6519,    6609,    6525,    6714,
    6941,    7024,    7044,    6904,
    6763,    6984,    6955,    7026,
    6997,    7341,    7325,    7736,
    7494,    7479,    7555,    7322,
    7064,    6955,    7079,    6626,
    6819,    6944,    6998,    7283,
    7060,    7468,    7099,    6789,
    7436,    7158,    7824,    8064,
    7906,    8396,    8278,    7616,
    7157,    7141,    6727,    6303,
    6159,    6543,    6033,    6768,
     //Q14.txt
    1694,    2680,    3568,    3908,
    4072,    4375,    4629,    4811,
    5032,    5251,    5416,    5490,
    5670,    5847,    6167,    6096,
    6198,    6283,    6200,    6387,
    6611,    6691,    6712,    6573,
    6437,    6653,    6626,    6696,
    6666,    7001,    6985,    7384,
    7150,    7139,    7214,    6984,
    6729,    6625,    6750,    6311,
    6496,    6621,    6676,    6952,
    6735,    7142,    6777,    6475,
    7101,    6834,    7488,    7725,
    7574,    8049,    7944,    7298,
    6845,    6832,    6429,    6018,
    5882,    6252,    5755,    6461,
     //Q15.txt
    1558,    2502,    3357,    3685,
    3840,    4135,    4381,    4557,
    4773,    4984,    5146,    5220,
    5394,    5566,    5879,    5812,
    5908,    5990,    5907,    6093,
    6314,    6390,    6413,    6274,
    6144,    6354,    6329,    6399,
    6368,    6697,    6678,    7069,
    6840,    6831,    6906,    6679,
    6429,    6331,    6453,    6029,
    6198,    6331,    6384,    6655,
    6443,    6843,    6486,    6190,
    6799,    6542,    7186,    7418,
    7278,    7739,    7641,    7007,
    6564,    6551,    6158,    5759,
    5631,    5987,    5506,    6183,
     //Q16.txt
    1405,    2306,    3125,    3438,
    3588,    3873,    4110,    4281,
    4492,    4698,    4855,    4928,
    5097,    5265,    5570,    5507,
    5600,    5679,    5596,    5781,
    5998,    6072,    6094,    5959,
    5833,    6037,    6014,    6082,
    6053,    6374,    6355,    6737,
    6513,    6508,    6580,    6355,
    6112,    6017,    6139,    5728,
    5888,    6023,    6077,    6337,
    6134,    6531,    6180,    5890,
    6480,    6233,    6868,    7096,
    6961,    7410,    7323,    6703,
    6267,    6254,    5871,    5482,
    5362,    5712,    5242,    5890,
     //Q17.txt
    1312,    2183,    2975,    3277,
    3422,    3701,    3930,    4096,
    4301,    4502,    4657,    4729,
    4893,    5057,    5357,    5295,
    5385,    5461,    5380,    5562,
    5777,    5849,    5869,    5738,
    5615,    5814,    5792,    5860,
    5831,    6146,    6125,    6499,
    6281,    6278,    6349,    6126,
    5888,    5797,    5918,    5517,
    5669,    5806,    5858,    6110,
    5914,    6307,    5960,    5680,
    6251,    6013,    6639,    6861,
    6735,    7170,    7088,    6484,
    6054,    6040,    5668,    5289,
    5170,    5508,    5053,    5682,
     //Q18.txt
    1217,    2051,    2810,    3101,
    3241,    3510,    3732,    3893,
    4094,    4289,    4441,    4512,
    4672,    4831,    5124,    5065,
    5152,    5225,    5145,    5325,
    5538,    5607,    5626,    5497,
    5380,    5574,    5553,    5619,
    5590,    5900,    5878,    6244,
    6033,    6031,    6100,    5880,
    5647,    5561,    5679,    5292,
    5437,    5571,    5625,    5869,
    5678,    6065,    5725,    5450,
    6009,    5780,    6395,    6613,
    6495,    6919,    6842,    6249,
    5826,    5816,    5449,    5080,
    4966,    5296,    4850,    5459,
     //Q19.txt
    1140,    1944,    2679,    2958,
    3094,    3356,    3571,    3727,
    3923,    4113,    4262,    4333,
    4489,    4644,    4930,    4873,
    4957,    5028,    4949,    5127,
    5338,    5405,    5425,    5297,
    5183,    5373,    5353,    5418,
    5388,    5692,    5671,    6030,
    5824,    5824,    5891,    5674,
    5445,    5362,    5479,    5102,
    5242,    5375,    5428,    5666,
    5480,    5865,    5530,    5261,
    5803,    5582,    6189,    6402,
    6290,    6704,    6633,    6051,
    5634,    5625,    5265,    4905,
    4795,    5115,    4681,    5273,
     //Q20.txt
    1050,    1821,    2530,    2799,
    2930,    3185,    3393,    3545,
    3738,    3923,    4069,    4140,
    4292,    4445,    4724,    4670,
    4751,    4819,    4742,    4918,
    5125,    5192,    5211,    5087,
    4977,    5162,    5146,    5207,
    5180,    5477,    5456,    5807,
    5606,    5608,    5674,    5460,
    5234,    5155,    5270,    4903,
    5038,    5171,    5223,    5456,
    5271,    5651,    5324,    5062,
    5589,    5374,    5973,    6181,
    6073,    6478,    6413,    5844,
    5433,    5423,    5073,    4722,
    4616,    4926,    4504,    5077,
     //Q21.txt
    982,    1724,    2408,    2666,
    2793,    3040,    3243,    3390,
    3578,    3759,    3902,    3973,
    4121,    4270,    4543,    4491,
    4569,    4636,    4559,    4733,
    4939,    5002,    5021,    4901,
    4796,    4975,    4959,    5019,
    4992,    5285,    5264,    5606,
    5411,    5414,    5480,    5268,
    5047,    4971,    5083,    4728,
    4857,    4988,    5039,    5268,
    5086,    5458,    5138,    4884,
    5398,    5191,    5779,    5986,
    5886,    6278,    6219,    5659,
    5255,    5245,    4899,    4556,
    4454,    4760,    4342,    4903,
     //Q22.txt
    929,    1648,    2310,    2559,
    2683,    2923,    3120,    3265,
    3449,    3624,    3765,    3835,
    3980,    4126,    4394,    4344,
    4418,    4485,    4408,    4580,
    4784,    4845,    4864,    4746,
    4644,    4818,    4801,    4863,
    4836,    5122,    5102,    5438,
    5247,    5251,    5316,    5107,
    4890,    4818,    4926,    4582,
    4706,    4834,    4886,    5110,
    4932,    5299,    4984,    4735,
    5237,    5037,    5617,    5820,
    5725,    6109,    6049,    5500,
    5107,    5094,    4756,    4421,
    4322,    4617,    4212,    4757,
     //Q23.txt
    868,    1562,    2202,    2443,
    2564,    2798,    2990,    3130,
    3311,    3483,    3622,    3690,
    3832,    3975,    4239,    4190,
    4263,    4328,    4251,    4423,
    4622,    4684,    4702,    4586,
    4489,    4658,    4643,    4702,
    4677,    4958,    4937,    5267,
    5080,    5085,    5150,    4944,
    4730,    4660,    4766,    4432,
    4550,    4678,    4731,    4949,
    4773,    5137,    4826,    4582,
    5073,    4877,    5451,    5650,
    5559,    5934,    5881,    5340,
    4951,    4941,    4610,    4280,
    4187,    4473,    4075,    4609,
     //Q24.txt
    815,    1483,    2100,    2333,
    2449,    2676,    2862,    2997,
    3175,    3341,    3478,    3545,
    3684,    3822,    4082,    4034,
    4104,    4168,    4093,    4260,
    4458,    4518,    4537,    4422,
    4329,    4494,    4477,    4536,
    4512,    4787,    4767,    5090,
    4907,    4914,    4979,    4775,
    4566,    4501,    4602,    4277,
    4391,    4517,    4569,    4782,
    4610,    4966,    4663,    4425,
    4903,    4714,    5280,    5475,
    5386,    5753,    5705,    5172,
    4790,    4781,    4456,    4135,
    4043,    4324,    3936,    4455,
     //Q25.txt
    732,    1361,    1947,    2169,
    2276,    2493,    2671,    2800,
    2972,    3131,    3264,    3329,
    3464,    3598,    3848,    3805,
    3871,    3933,    3860,    4023,
    4215,    4274,    4293,    4181,
    4094,    4252,    4238,    4293,
    4270,    4540,    4519,    4833,
    4655,    4665,    4729,    4527,
    4326,    4264,    4360,    4051,
    4158,    4281,    4332,    4539,
    4373,    4722,    4425,    4195,
    4658,    4477,    5032,    5221,
    5138,    5491,    5444,    4930,
    4554,    4545,    4227,    3919,
    3834,    4101,    3729,    4225,
     //Q26.txt
    664,    1260,    1820,    2030,
    2129,    2338,    2508,    2632,
    2799,    2953,    3081,    3146,
    3275,    3404,    3648,    3607,
    3670,    3731,    3659,    3820,
    4006,    4063,    4084,    3975,
    3891,    4044,    4029,    4085,
    4064,    4325,    4304,    4610,
    4438,    4450,    4513,    4315,
    4118,    4061,    4152,    3856,
    3958,    4078,    4128,    4327,
    4166,    4508,    4220,    3994,
    4444,    4271,    4817,    5002,
    4922,    5261,    5218,    4718,
    4351,    4340,    4034,    3732,
    3651,    3910,    3552,    4030,
     //Q27.txt
    612,    1177,    1713,    1915,
    2007,    2207,    2369,    2488,
    2650,    2799,    2924,    2986,
    3111,    3236,    3472,    3434,
    3494,    3555,    3483,    3640,
    3822,    3878,    3899,    3793,
    3713,    3861,    3847,    3901,
    3881,    4135,    4114,    4413,
    4246,    4257,    4320,    4126,
    3934,    3882,    3969,    3688,
    3782,    3896,    3948,    4139,
    3985,    4318,    4036,    3818,
    4253,    4089,    4624,    4803,
    4729,    5053,    5019,    4530,
    4169,    4160,    3859,    3566,
    3490,    3740,    3394,    3854,
     //Q28.txt
    560,    1095,    1608,    1799,
    1886,    2078,    2234,    2348,
    2504,    2647,    2768,    2830,
    2951,    3071,    3300,    3264,
    3321,    3379,    3311,    3464,
    3641,    3697,    3717,    3615,
    3539,    3680,    3666,    3719,
    3702,    3949,    3927,    4217,
    4057,    4068,    4130,    3940,
    3754,    3705,    3788,    3520,
    3610,    3718,    3770,    3960,
    3807,    4133,    3857,    3647,
    4068,    3910,    4435,    4607,
    4538,    4850,    4819,    4343,
    3991,    3986,    3692,    3408,
    3331,    3575,    3242,    3684,
     //Q29.txt
    513,    1017,    1504,    1686,
    1768,    1951,    2100,    2209,
    2360,    2497,    2614,    2674,
    2791,    2906,    3129,    3095,
    3148,    3205,    3137,    3287,
    3460,    3514,    3535,    3435,
    3363,    3498,    3486,    3537,
    3521,    3760,    3740,    4020,
    3865,    3878,    3938,    3755,
    3573,    3529,    3605,    3351,
    3436,    3543,    3592,    3777,
    3628,    3946,    3676,    3476,
    3881,    3729,    4241,    4407,
    4344,    4645,    4623,    4156,
    3813,    3806,    3525,    3247,
    3177,    3411,    3089,    3514,
     //Q30.txt
    477,    955,    1421,    1596,
    1673,    1848,    1992,    2097,
    2242,    2375,    2487,    2547,
    2660,    2770,    2986,    2954,
    3006,    3060,    2994,    3140,
    3309,    3360,    3382,    3286,
    3217,    3347,    3336,    3385,
    3369,    3602,    3582,    3853,
    3703,    3718,    3776,    3597,
    3420,    3380,    3453,    3209,
    3289,    3394,    3442,    3618,
    3477,    3787,    3525,    3332,
    3724,    3576,    4079,    4240,
    4180,    4473,    4447,    4000,
    3664,    3658,    3383,    3116,
    3047,    3269,    2961,    3372,
     //Q31.txt
    430,    875,    1316,    1480,
    1549,    1717,    1852,    1952,
    2091,    2217,    2325,    2382,
    2489,    2595,    2802,    2773,
    2821,    2875,    2811,    2953,
    3115,    3166,    3187,    3094,
    3030,    3154,    3144,    3191,
    3176,    3400,    3382,    3641,
    3498,    3514,    3570,    3399,
    3229,    3192,    3260,    3029,
    3106,    3206,    3252,    3422,
    3285,    3587,    3334,    3147,
    3524,    3384,    3874,    4026,
    3973,    4251,    4230,    3797,
    3475,    3462,    3201,    2945,
    2880,    3096,    2802,    3189,
     //Q32.txt
    389,    803,    1220,    1375,
    1439,    1596,    1725,    1820,
    1953,    2073,    2177,    2232,
    2336,    2436,    2635,    2608,
    2654,    2706,    2645,    2782,
    2940,    2986,    3008,    2919,
    2859,    2977,    2968,    3014,
    3000,    3217,    3198,    3448,
    3312,    3326,    3382,    3216,
    3051,    3020,    3083,    2867,
    2936,    3030,    3078,    3240,
    3110,    3403,    3157,    2977,
    3341,    3207,    3684,    3831,
    3779,    4045,    4029,    3609,
    3298,    3287,    3033,    2788,
    2728,    2929,    2652,    3020,
     //Q33.txt
    369,    769,    1175,    1327,
    1387,    1540,    1666,    1758,
    1886,    2003,    2104,    2158,
    2259,    2356,    2548,    2523,
    2567,    2620,    2561,    2692,
    2845,    2891,    2913,    2826,
    2769,    2883,    2874,    2919,
    2907,    3117,    3098,    3342,
    3209,    3224,    3278,    3118,
    2959,    2927,    2988,    2777,
    2846,    2941,    2986,    3142,
    3016,    3300,    3060,    2887,
    3240,    3110,    3573,    3715,
    3666,    3926,    3903,    3497,
    3196,    3188,    2939,    2699,
    2642,    2838,    2571,    2929,
     //Q34.txt
    340,    714,    1102,    1247,
    1302,    1450,    1569,    1656,
    1780,    1893,    1990,    2043,
    2139,    2233,    2417,    2395,
    2437,    2488,    2432,    2559,
    2707,    2752,    2772,    2688,
    2637,    2745,    2737,    2778,
    2769,    2972,    2955,    3190,
    3063,    3078,    3130,    2971,
    2821,    2792,    2851,    2648,
    2714,    2806,    2849,    2999,
    2878,    3154,    2922,    2755,
    3097,    2971,    3424,    3561,
    3515,    3761,    3742,    3349,
    3059,    3048,    2809,    2581,
    2523,    2713,    2453,    2796,
     //Q35.txt
    307,    652,    1016,    1152,
    1202,    1341,    1454,    1537,
    1654,    1761,    1853,    1904,
    1996,    2084,    2261,    2240,
    2280,    2330,    2275,    2398,
    2540,    2583,    2603,    2523,
    2475,    2578,    2571,    2610,
    2602,    2798,    2780,    3003,
    2885,    2899,    2949,    2796,
    2654,    2628,    2682,    2494,
    2553,    2640,    2684,    2830,
    2713,    2978,    2755,    2597,
    2924,    2804,    3239,    3371,
    3330,    3563,    3549,    3173,
    2886,    2880,    2655,    2431,
    2380,    2559,    2315,    2637,
     //Q36.txt
    278,    597,    941,    1069,
    1114,    1246,    1353,    1430,
    1543,    1643,    1731,    1781,
    1868,    1952,    2120,    2102,
    2139,    2189,    2136,    2254,
    2390,    2432,    2451,    2376,
    2330,    2429,    2423,    2459,
    2453,    2640,    2623,    2836,
    2723,    2739,    2789,    2640,
    2504,    2480,    2534,    2355,
    2411,    2493,    2536,    2675,
    2563,    2820,    2605,    2452,
    2769,    2653,    3075,    3201,
    3157,    3383,    3373,    3010,
    2733,    2726,    2512,    2296,
    2249,    2420,    2190,    2494,
     //Q37.txt
    254,    551,    875,    996,
    1037,    1162,    1263,    1337,
    1445,    1540,    1625,    1672,
    1755,    1836,    1997,    1979,
    2016,    2064,    2014,    2126,
    2257,    2297,    2317,    2244,
    2203,    2295,    2289,    2326,
    2320,    2500,    2483,    2687,
    2580,    2597,    2644,    2502,
    2370,    2350,    2399,    2232,
    2284,    2362,    2405,    2537,
    2431,    2681,    2471,    2326,
    2629,    2518,    2926,    3046,
    3008,    3221,    3211,    2864,
    2601,    2592,    2383,    2179,
    2136,    2296,    2078,    2368,
     //Q38.txt
    232,    507,    812,    928,
    965,    1083,    1179,    1249,
    1351,    1440,    1521,    1568,
    1647,    1724,    1876,    1862,
    1896,    1942,    1895,    2001,
    2128,    2165,    2184,    2117,
    2078,    2167,    2162,    2197,
    2191,    2364,    2348,    2543,
    2441,    2457,    2503,    2366,
    2241,    2223,    2268,    2112,
    2159,    2234,    2278,    2403,
    2302,    2544,    2341,    2203,
    2495,    2387,    2781,    2895,
    2859,    3063,    3058,    2723,
    2470,    2462,    2257,    2066,
    2021,    2175,    1970,    2242,
     //Q39.txt
    210,    462,    749,    857,
    889,    1000,    1090,    1156,
    1252,    1336,    1414,    1459,
    1533,    1606,    1751,    1739,
    1770,    1816,    1771,    1872,
    1992,    2029,    2048,    1982,
    1947,    2032,    2029,    2059,
    2056,    2220,    2207,    2391,
    2296,    2310,    2353,    2223,
    2106,    2090,    2130,    1985,
    2027,    2100,    2144,    2263,
    2167,    2398,    2205,    2073,
    2350,    2248,    2632,    2736,
    2704,    2895,    2892,    2577,
    2332,    2324,    2130,    1944,
    1904,    2051,    1855,    2112,
     //Q40.txt
    192,    426,    696,    798,
    827,    932,    1016,    1079,
    1170,    1249,    1324,    1367,
    1438,    1507,    1644,    1635,
    1664,    1710,    1666,    1761,
    1877,    1911,    1930,    1867,
    1837,    1916,    1914,    1943,
    1941,    2097,    2084,    2261,
    2170,    2184,    2227,    2101,
    1990,    1975,    2015,    1879,
    1917,    1985,    2028,    2143,
    2051,    2269,    2087,    1963,
    2228,    2132,    2500,    2600,
    2569,    2750,    2749,    2445,
    2214,    2207,    2023,    1842,
    1799,    1946,    1760,    2003,
     //Q41.txt
    175,    390,    642,    739,
    764,    861,    941,    1000,
    1085,    1160,    1231,    1273,
    1339,    1404,    1534,    1526,
    1555,    1598,    1557,    1646,
    1757,    1789,    1808,    1750,
    1721,    1796,    1795,    1823,
    1822,    1971,    1958,    2125,
    2040,    2054,    2094,    1973,
    1869,    1859,    1893,    1766,
    1800,    1867,    1907,    2019,
    1930,    2143,    1964,    1849,
    2100,    2007,    2361,    2456,
    2426,    2599,    2600,    2310,
    2089,    2081,    1903,    1736,
    1693,    1835,    1659,    1888,
     //Q42.txt
    159,    358,    593,    684,
    706,    798,    872,    928,
    1007,    1080,    1146,    1187,
    1249,    1310,    1432,    1427,
    1455,    1497,    1459,    1543,
    1647,    1678,    1696,    1642,
    1617,    1687,    1686,    1714,
    1713,    1855,    1843,    1999,
    1921,    1934,    1972,    1856,
    1759,    1751,    1783,    1664,
    1696,    1760,    1799,    1902,
    1819,    2021,    1853,    1742,
    1982,    1895,    2234,    2325,
    2295,    2459,    2461,    2185,
    1974,    1968,    1799,    1637,
    1602,    1728,    1566,    1781,
     //Q43.txt
    145,    329,    547,    633,
    652,    737,    808,    860,
    934,    1002,    1064,    1104,
    1162,    1219,    1334,    1331,
    1356,    1398,    1364,    1443,
    1541,    1569,    1586,    1536,
    1515,    1580,    1579,    1607,
    1607,    1740,    1729,    1876,
    1803,    1816,    1852,    1741,
    1652,    1646,    1674,    1563,
    1593,    1653,    1691,    1789,
    1710,    1901,    1745,    1638,
    1868,    1782,    2105,    2192,
    2167,    2321,    2319,    2062,
    1862,    1856,    1697,    1544,
    1510,    1630,    1476,    1678,
     //Q44.txt
    132,    302,    507,    588,
    603,    683,    750,    798,
    868,    931,    990,    1028,
    1083,    1136,    1245,    1243,
    1269,    1309,    1277,    1350,
    1443,    1471,    1488,    1440,
    1422,    1483,    1483,    1509,
    1510,    1637,    1628,    1766,
    1697,    1710,    1746,    1639,
    1556,    1550,    1575,    1473,
    1499,    1556,    1595,    1685,
    1612,    1797,    1646,    1545,
    1763,    1682,    1988,    2072,
    2048,    2195,    2191,    1951,
    1761,    1752,    1602,    1453,
    1426,    1536,    1395,    1585,
     //Q45.txt
    121,    277,    469,    543,
    556,    630,    692,    738,
    802,    861,    916,    953,
    1004,    1054,    1158,    1156,
    1181,    1220,    1190,    1259,
    1345,    1372,    1389,    1346,
    1329,    1386,    1386,    1411,
    1414,    1532,    1524,    1653,
    1589,    1602,    1636,    1535,
    1459,    1454,    1476,    1383,
    1406,    1461,    1498,    1581,
    1514,    1687,    1545,    1451,
    1656,    1582,    1872,    1951,
    1929,    2066,    2062,    1836,
    1657,    1646,    1509,    1368,
    1341,    1444,    1312,    1491,
     //Q46.txt
    110,    255,    432,    503,
    513,    582,    640,    683,
    742,    796,    849,    884,
    931,    978,    1073,    1074,
    1098,    1135,    1110,    1172,
    1254,    1278,    1297,    1257,
    1241,    1295,    1295,    1317,
    1321,    1433,    1427,    1548,
    1488,    1501,    1534,    1438,
    1368,    1362,    1384,    1298,
    1317,    1370,    1406,    1485,
    1421,    1586,    1452,    1361,
    1556,    1485,    1762,    1835,
    1815,    1945,    1943,    1730,
    1557,    1551,    1419,    1285,
    1262,    1357,    1237,    1402,
     //Q47.txt
    101,    235,    399,    465,
    473,    537,    591,    631,
    687,    737,    786,    820,
    863,    907,    996,    998,
    1021,    1059,    1036,    1093,
    1170,    1193,    1210,    1174,
    1161,    1211,    1211,    1234,
    1237,    1343,    1337,    1450,
    1395,    1408,    1438,    1348,
    1284,    1279,    1298,    1218,
    1236,    1287,    1321,    1397,
    1335,    1491,    1364,    1281,
    1464,    1397,    1658,    1729,
    1715,    1834,    1836,    1628,
    1466,    1463,    1339,    1209,
    1191,    1279,    1165,    1321,
     //Q48.txt
    92,    216,    368,    430,
    436,    496,    545,    583,
    634,    680,    725,    760,
    799,    839,    924,    927,
    949,    985,    964,    1015,
    1087,    1110,    1126,    1094,
    1085,    1130,    1130,    1152,
    1155,    1254,    1252,    1354,
    1303,    1315,    1343,    1259,
    1202,    1198,    1215,    1142,
    1157,    1205,    1237,    1308,
    1251,    1398,    1280,    1202,
    1374,    1310,    1556,    1626,
    1607,    1723,    1723,    1528,
    1382,    1376,    1257,    1136,
    1117,    1200,    1097,    1241,
     //Q49.txt
    84,    199,    338,    398,
    401,    456,    502,    537,
    583,    626,    669,    701,
    738,    775,    851,    858,
    880,    915,    897,    942,
    1009,    1030,    1046,    1018,
    1010,    1051,    1052,    1073,
    1078,    1171,    1168,    1263,
    1216,    1230,    1255,    1175,
    1124,    1123,    1136,    1071,
    1083,    1130,    1159,    1224,
    1172,    1309,    1201,    1124,
    1288,    1227,    1460,    1525,
    1509,    1617,    1613,    1436,
    1295,    1293,    1182,    1067,
    1047,    1125,    1030,    1165,
     //Q50.txt
    76,    183,    313,    368,
    370,    421,    464,    496,
    538,    578,    618,    649,
    682,    717,    787,    795,
    816,    850,    834,    875,
    937,    958,    973,    947,
    939,    980,    981,    1000,
    1006,    1091,    1090,    1178,
    1134,    1148,    1174,    1097,
    1053,    1052,    1064,    1003,
    1012,    1056,    1086,    1146,
    1097,    1228,    1124,    1054,
    1207,    1150,    1368,    1428,
    1416,    1517,    1514,    1347,
    1217,    1213,    1110,    999,
    986,    1056,    967,    1094,
     //Q51.txt
    70,    168,    290,    341,
    341,    388,    427,    457,
    495,    533,    569,    599,
    630,    661,    726,    735,
    754,    787,    775,    811,
    868,    887,    902,    880,
    873,    911,    913,    932,
    937,    1018,    1017,    1097,
    1057,    1070,    1093,    1022,
    985,    983,    993,    940,
    946,    988,    1016,    1071,
    1027,    1148,    1053,    987,
    1132,    1078,    1281,    1339,
    1328,    1420,    1415,    1261,
    1142,    1135,    1038,    940,
    928,    991,    909,    1027,
     //Q52.txt
    64,    154,    267,    316,
    313,    356,    393,    421,
    455,    490,    523,    552,
    581,    607,    668,    678,
    697,    727,    718,    749,
    801,    820,    835,    817,
    811,    846,    849,    866,
    870,    946,    946,    1020,
    983,    998,    1020,    952,
    918,    917,    926,    878,
    882,    923,    950,    1002,
    959,    1072,    984,    921,
    1057,    1008,    1199,    1251,
    1245,    1328,    1325,    1180,
    1066,    1063,    975,    879,
    871,    924,    854,    963,
     //Q53.txt
    59,    142,    245,    292,
    288,    328,    362,    388,
    418,    450,    480,    508,
    534,    558,    614,    625,
    641,    670,    665,    691,
    740,    757,    771,    756,
    751,    783,    787,    801,
    807,    878,    879,    944,
    914,    925,    948,    886,
    855,    856,    863,    822,
    824,    861,    887,    934,
    895,    1000,    917,    860,
    989,    940,    1117,    1169,
    1162,    1240,    1239,    1104,
    998,    995,    907,    822,
    811,    869,    799,    904,
     //Q54.txt
    54,    130,    225,    270,
    266,    302,    333,    357,
    383,    412,    440,    467,
    491,    512,    564,    575,
    590,    620,    616,    638,
    682,    697,    712,    699,
    697,    727,    732,    743,
    748,    814,    817,    876,
    849,    858,    882,    819,
    795,    798,    804,    767,
    766,    802,    828,    872,
    835,    929,    855,    802,
    918,    877,    1044,    1089,
    1084,    1153,    1154,    1029,
    931,    928,    849,    768,
    758,    813,    749,    846,
     //Q55.txt
    50,    118,    205,    249,
    243,    275,    305,    326,
    348,    374,    400,    427,
    448,    468,    513,    525,
    538,    568,    566,    583,
    624,    637,    651,    642,
    641,    669,    672,    683,
    689,    749,    755,    807,
    781,    791,    812,    755,
    736,    738,    744,    710,
    710,    745,    770,    808,
    775,    866,    793,    745,
    855,    813,    962,    1010,
    1001,    1072,    1068,    950,
    866,    862,    785,    711,
    702,    752,    697,    787,
     //Q56.txt
    46,    108,    188,    229,
    222,    252,    279,    298,
    318,    341,    364,    389,
    408,    427,    467,    478,
    491,    520,    519,    533,
    570,    581,    595,    589,
    588,    614,    617,    628,
    634,    690,    695,    739,
    717,    726,    746,    694,
    681,    683,    686,    659,
    655,    691,    712,    747,
    718,    798,    733,    690,
    793,    753,    892,    933,
    928,    988,    986,    881,
    802,    801,    731,    662,
    655,    696,    648,    731,
     //Q57.txt
    42,    97,    170,    210,
    202,    229,    253,    271,
    288,    309,    330,    353,
    370,    386,    421,    432,
    446,    474,    474,    483,
    516,    527,    541,    537,
    537,    561,    566,    575,
    580,    629,    637,    675,
    657,    665,    683,    635,
    627,    627,    630,    609,
    604,    635,    657,    685,
    661,    733,    676,    636,
    729,    695,    819,    860,
    855,    905,    909,    809,
    742,    738,    676,    613,
    605,    643,    600,    678,
     //Q58.txt
    38,    87,    153,    191,
    182,    206,    228,    245,
    259,    279,    297,    319,
    332,    347,    378,    388,
    403,    429,    430,    433,
    464,    473,    487,    484,
    487,    508,    514,    520,
    527,    569,    577,    612,
    594,    603,    619,    573,
    571,    572,    577,    558,
    554,    579,    602,    627,
    605,    669,    620,    586,
    665,    635,    748,    784,
    783,    828,    821,    740,
    678,    674,    618,    562,
    558,    595,    552,    625,
     //Q59.txt
    35,    78,    137,    172,
    162,    184,    204,    219,
    233,    250,    265,    285,
    298,    310,    336,    346,
    361,    385,    386,    386,
    413,    420,    433,    433,
    438,    457,    460,    468,
    474,    510,    518,    550,
    533,    543,    556,    517,
    518,    519,    523,    507,
    500,    525,    547,    570,
    550,    608,    562,    533,
    603,    576,    679,    706,
    708,    743,    743,    674,
    618,    614,    559,    514,
    511,    541,    505,    574,
     //Q60.txt
    32,    68,    120,    153,
    143,    163,    180,    195,
    206,    221,    236,    253,
    263,    274,    295,    305,
    319,    338,    342,    339,
    361,    367,    378,    383,
    387,    406,    410,    416,
    422,    453,    462,    487,
    475,    483,    493,    461,
    466,    464,    466,    455,
    448,    471,    490,    510,
    492,    539,    504,    480,
    542,    517,    604,    632,
    634,    664,    661,    607,
    556,    553,    506,    464,
    461,    487,    456,    520,
     //Q61.txt
    29,    59,    104,    134,
    124,    142,    158,    170,
    181,    194,    207,    221,
    231,    240,    258,    267,
    279,    294,    301,    296,
    310,    315,    327,    333,
    337,    354,    358,    364,
    368,    394,    404,    423,
    414,    423,    433,    403,
    412,    408,    413,    405,
    395,    416,    433,    450,
    437,    471,    444,    424,
    476,    459,    526,    552,
    553,    581,    577,    533,
    493,    492,    444,    414,
    411,    436,    405,    465,
     //Q62.txt
    26,    50,    85,    113,
    102,    117,    130,    141,
    150,    163,    173,    184,
    193,    201,    217,    222,
    235,    248,    255,    248,
    253,    257,    265,    273,
    277,    289,    294,    300,
    301,    318,    328,    336,
    334,    342,    346,    335,
    346,    336,    345,    342,
    330,    351,    364,    377,
    367,    391,    371,    357,
    398,    385,    438,    460,
    458,    481,    474,    443,
    409,    411,    376,    354,
    350,    375,    347,    400,
     //Q63.txt
    22,    39,    64,    89,
    77,    89,    99,    108,
    117,    126,    135,    144,
    152,    158,    171,    176,
    185,    195,    203,    197,
    199,    201,    207,    216,
    219,    226,    228,    233,
    236,    243,    253,    258,
    254,    265,    267,    268,
    274,    260,    270,    270,
    265,    276,    282,    291,
    290,    307,    289,    286,
    303,    302,    312,    328,
    338,    346,    345,    334,
    323,    325,    297,    283,
    286,    305,    276,    321
};

/**************************************
 * Function Declarations
 **************************************/
EbErrorType rate_control_tables_ctor(
    RateControlTables *initial_rate_control_tables_array)
{
    int qp_index, interval_index, temporal_index;
    for(qp_index = 0; qp_index < 64; qp_index++){
        for(interval_index= 0; interval_index < NUMBER_OF_SAD_INTERVALS;interval_index++){
             for (temporal_index=0; temporal_index < MAX_TEMPORAL_LAYERS; temporal_index++){
                     if (interval_index < (NUMBER_OF_SAD_INTERVALS >> 1)){
                    // intrinsics used in initial RC are assuming signed 16 bits is the maximum
                    initial_rate_control_tables_array[qp_index].sad_bits_array[temporal_index][interval_index] =
                        CLIP3(1,
                        (uint16_t)((1<<15)-1),
                        (uint16_t)initial_rate_control_sad64x64_tables[qp_index*(NUMBER_OF_SAD_INTERVALS >> 1) + interval_index]);

                    initial_rate_control_tables_array[qp_index].intra_sad_bits_array[temporal_index][interval_index] =
                        CLIP3(1,
                        (uint16_t)((1<<15)-1),
                        (uint16_t)initial_rate_control_intra_sad64x64_tables[qp_index*(NUMBER_OF_SAD_INTERVALS >> 1) + interval_index]);

                }
                else{

                    initial_rate_control_tables_array[qp_index].sad_bits_array[temporal_index][interval_index] =
                        CLIP3(1,
                        (uint16_t)((1<<15)-1),
                        (uint16_t)initial_rate_control_sad64x64_tables[qp_index*(NUMBER_OF_SAD_INTERVALS >> 1) + ((NUMBER_OF_SAD_INTERVALS >> 1) - 1)]);
                    initial_rate_control_tables_array[qp_index].intra_sad_bits_array[temporal_index][interval_index] =
                        CLIP3(1,
                        (uint16_t)((1<<15)-1),
                        initial_rate_control_intra_sad64x64_tables[qp_index*(NUMBER_OF_SAD_INTERVALS >> 1) + ((NUMBER_OF_SAD_INTERVALS >> 1) - 1)]);

                }

             }
        }
    }
    return EB_ErrorNone;
}
