/* Plug.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from Plug.vala, do not modify */

/* -*- Mode: vala; indent-tabs-mode: nil; tab-width: 4 -*-*/
/*-
 * Copyright (c) 2012-2014 Switchboard Developers (http://launchpad.net/switchboard)
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as published by
 * the Free Software Foundation, either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authored by: Corentin Noël <corentin@elementaryos.org>
 */

#include "switchboard.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gee.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <gio/gio.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	SWITCHBOARD_PLUG_0_PROPERTY,
	SWITCHBOARD_PLUG_CATEGORY_PROPERTY,
	SWITCHBOARD_PLUG_CODE_NAME_PROPERTY,
	SWITCHBOARD_PLUG_DISPLAY_NAME_PROPERTY,
	SWITCHBOARD_PLUG_DESCRIPTION_PROPERTY,
	SWITCHBOARD_PLUG_ICON_PROPERTY,
	SWITCHBOARD_PLUG_SUPPORTED_SETTINGS_PROPERTY,
	SWITCHBOARD_PLUG_CAN_SHOW_PROPERTY,
	SWITCHBOARD_PLUG_NUM_PROPERTIES
};
static GParamSpec* switchboard_plug_properties[SWITCHBOARD_PLUG_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
enum  {
	SWITCHBOARD_PLUG_VISIBILITY_CHANGED_SIGNAL,
	SWITCHBOARD_PLUG_NUM_SIGNALS
};
static guint switchboard_plug_signals[SWITCHBOARD_PLUG_NUM_SIGNALS] = {0};

struct _SwitchboardPlugPrivate {
	SwitchboardPlugCategory _category;
	gchar* _code_name;
	gchar* _display_name;
	gchar* _description;
	gchar* _icon;
	GeeTreeMap* _supported_settings;
	gboolean _can_show;
};

static gint SwitchboardPlug_private_offset;
static gpointer switchboard_plug_parent_class = NULL;

static GtkWidget* switchboard_plug_real_get_widget (SwitchboardPlug* self);
static void switchboard_plug_real_shown (SwitchboardPlug* self);
static void switchboard_plug_real_hidden (SwitchboardPlug* self);
static void switchboard_plug_real_search_callback (SwitchboardPlug* self,
                                            const gchar* location);
static void switchboard_plug_finalize (GObject * obj);
static GType switchboard_plug_get_type_once (void);
static void _vala_switchboard_plug_get_property (GObject * object,
                                          guint property_id,
                                          GValue * value,
                                          GParamSpec * pspec);
static void _vala_switchboard_plug_set_property (GObject * object,
                                          guint property_id,
                                          const GValue * value,
                                          GParamSpec * pspec);

static inline gpointer
switchboard_plug_get_instance_private (SwitchboardPlug* self)
{
	return G_STRUCT_MEMBER_P (self, SwitchboardPlug_private_offset);
}

static GType
switchboard_plug_category_get_type_once (void)
{
	static const GEnumValue values[] = {{SWITCHBOARD_PLUG_CATEGORY_PERSONAL, "SWITCHBOARD_PLUG_CATEGORY_PERSONAL", "personal"}, {SWITCHBOARD_PLUG_CATEGORY_HARDWARE, "SWITCHBOARD_PLUG_CATEGORY_HARDWARE", "hardware"}, {SWITCHBOARD_PLUG_CATEGORY_NETWORK, "SWITCHBOARD_PLUG_CATEGORY_NETWORK", "network"}, {SWITCHBOARD_PLUG_CATEGORY_SYSTEM, "SWITCHBOARD_PLUG_CATEGORY_SYSTEM", "system"}, {0, NULL, NULL}};
	GType switchboard_plug_category_type_id;
	switchboard_plug_category_type_id = g_enum_register_static ("SwitchboardPlugCategory", values);
	return switchboard_plug_category_type_id;
}

GType
switchboard_plug_category_get_type (void)
{
	static volatile gsize switchboard_plug_category_type_id__once = 0;
	if (g_once_init_enter (&switchboard_plug_category_type_id__once)) {
		GType switchboard_plug_category_type_id;
		switchboard_plug_category_type_id = switchboard_plug_category_get_type_once ();
		g_once_init_leave (&switchboard_plug_category_type_id__once, switchboard_plug_category_type_id);
	}
	return switchboard_plug_category_type_id__once;
}

/**
     * Returns the widget that contain the whole interface.
     *
     * @return a {@link Gtk.Widget} containing the interface.
     */
static GtkWidget*
switchboard_plug_real_get_widget (SwitchboardPlug* self)
{
	g_critical ("Type `%s' does not implement abstract method `switchboard_plug_get_widget'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return NULL;
}

GtkWidget*
switchboard_plug_get_widget (SwitchboardPlug* self)
{
	SwitchboardPlugClass* _klass_;
	g_return_val_if_fail (self != NULL, NULL);
	_klass_ = SWITCHBOARD_PLUG_GET_CLASS (self);
	if (_klass_->get_widget) {
		return _klass_->get_widget (self);
	}
	return NULL;
}

/**
     * Called when the plug appears to the user.
     */
static void
switchboard_plug_real_shown (SwitchboardPlug* self)
{
	g_critical ("Type `%s' does not implement abstract method `switchboard_plug_shown'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return;
}

void
switchboard_plug_shown (SwitchboardPlug* self)
{
	SwitchboardPlugClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = SWITCHBOARD_PLUG_GET_CLASS (self);
	if (_klass_->shown) {
		_klass_->shown (self);
	}
}

/**
     * Called when the plug disappear to the user.
     *
     * This is not called when the plug got destroyed or the window is closed, use ~Plug () instead.
     */
static void
switchboard_plug_real_hidden (SwitchboardPlug* self)
{
	g_critical ("Type `%s' does not implement abstract method `switchboard_plug_hidden'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return;
}

void
switchboard_plug_hidden (SwitchboardPlug* self)
{
	SwitchboardPlugClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = SWITCHBOARD_PLUG_GET_CLASS (self);
	if (_klass_->hidden) {
		_klass_->hidden (self);
	}
}

void
switchboard_plug_search (SwitchboardPlug* self,
                         const gchar* search,
                         GAsyncReadyCallback _callback_,
                         gpointer _user_data_)
{
	SwitchboardPlugClass* _klass_;
	_klass_ = SWITCHBOARD_PLUG_GET_CLASS (self);
	if (_klass_->search) {
		_klass_->search (self, search, _callback_, _user_data_);
	}
}

GeeTreeMap*
switchboard_plug_search_finish (SwitchboardPlug* self,
                                GAsyncResult* _res_)
{
	SwitchboardPlugClass* _klass_;
	_klass_ = SWITCHBOARD_PLUG_GET_CLASS (self);
	if (_klass_->search_finish) {
		return _klass_->search_finish (self, _res_);
	}
	return NULL;
}

/**
     * This function is used when the user click on a search result, it should show the selected setting (right tab…).
     *
     * @param location a {@link string} that represents the setting to show.
     */
static void
switchboard_plug_real_search_callback (SwitchboardPlug* self,
                                       const gchar* location)
{
	g_critical ("Type `%s' does not implement abstract method `switchboard_plug_search_callback'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return;
}

void
switchboard_plug_search_callback (SwitchboardPlug* self,
                                  const gchar* location)
{
	SwitchboardPlugClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = SWITCHBOARD_PLUG_GET_CLASS (self);
	if (_klass_->search_callback) {
		_klass_->search_callback (self, location);
	}
}

SwitchboardPlug*
switchboard_plug_construct (GType object_type)
{
	SwitchboardPlug * self = NULL;
	self = (SwitchboardPlug*) g_object_new (object_type, NULL);
	return self;
}

SwitchboardPlugCategory
switchboard_plug_get_category (SwitchboardPlug* self)
{
	SwitchboardPlugCategory result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_category;
	return result;
}

static void
switchboard_plug_set_category (SwitchboardPlug* self,
                               SwitchboardPlugCategory value)
{
	SwitchboardPlugCategory old_value;
	g_return_if_fail (self != NULL);
	old_value = switchboard_plug_get_category (self);
	if (old_value != value) {
		self->priv->_category = value;
		g_object_notify_by_pspec ((GObject *) self, switchboard_plug_properties[SWITCHBOARD_PLUG_CATEGORY_PROPERTY]);
	}
}

const gchar*
switchboard_plug_get_code_name (SwitchboardPlug* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_code_name;
	result = _tmp0_;
	return result;
}

static void
switchboard_plug_set_code_name (SwitchboardPlug* self,
                                const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = switchboard_plug_get_code_name (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_code_name);
		self->priv->_code_name = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, switchboard_plug_properties[SWITCHBOARD_PLUG_CODE_NAME_PROPERTY]);
	}
}

const gchar*
switchboard_plug_get_display_name (SwitchboardPlug* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_display_name;
	result = _tmp0_;
	return result;
}

static void
switchboard_plug_set_display_name (SwitchboardPlug* self,
                                   const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = switchboard_plug_get_display_name (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_display_name);
		self->priv->_display_name = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, switchboard_plug_properties[SWITCHBOARD_PLUG_DISPLAY_NAME_PROPERTY]);
	}
}

const gchar*
switchboard_plug_get_description (SwitchboardPlug* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_description;
	result = _tmp0_;
	return result;
}

static void
switchboard_plug_set_description (SwitchboardPlug* self,
                                  const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = switchboard_plug_get_description (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_description);
		self->priv->_description = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, switchboard_plug_properties[SWITCHBOARD_PLUG_DESCRIPTION_PROPERTY]);
	}
}

const gchar*
switchboard_plug_get_icon (SwitchboardPlug* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_icon;
	result = _tmp0_;
	return result;
}

static void
switchboard_plug_set_icon (SwitchboardPlug* self,
                           const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = switchboard_plug_get_icon (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_icon);
		self->priv->_icon = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, switchboard_plug_properties[SWITCHBOARD_PLUG_ICON_PROPERTY]);
	}
}

GeeTreeMap*
switchboard_plug_get_supported_settings (SwitchboardPlug* self)
{
	GeeTreeMap* result;
	GeeTreeMap* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_supported_settings;
	result = _tmp0_;
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
switchboard_plug_set_supported_settings (SwitchboardPlug* self,
                                         GeeTreeMap* value)
{
	GeeTreeMap* old_value;
	g_return_if_fail (self != NULL);
	old_value = switchboard_plug_get_supported_settings (self);
	if (old_value != value) {
		GeeTreeMap* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_supported_settings);
		self->priv->_supported_settings = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, switchboard_plug_properties[SWITCHBOARD_PLUG_SUPPORTED_SETTINGS_PROPERTY]);
	}
}

gboolean
switchboard_plug_get_can_show (SwitchboardPlug* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_can_show;
	return result;
}

void
switchboard_plug_set_can_show (SwitchboardPlug* self,
                               gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = switchboard_plug_get_can_show (self);
	if (old_value != value) {
		self->priv->_can_show = value;
		g_object_notify_by_pspec ((GObject *) self, switchboard_plug_properties[SWITCHBOARD_PLUG_CAN_SHOW_PROPERTY]);
	}
}

static void
switchboard_plug_class_init (SwitchboardPlugClass * klass,
                             gpointer klass_data)
{
	switchboard_plug_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &SwitchboardPlug_private_offset);
	((SwitchboardPlugClass *) klass)->get_widget = (GtkWidget* (*) (SwitchboardPlug*)) switchboard_plug_real_get_widget;
	((SwitchboardPlugClass *) klass)->shown = (void (*) (SwitchboardPlug*)) switchboard_plug_real_shown;
	((SwitchboardPlugClass *) klass)->hidden = (void (*) (SwitchboardPlug*)) switchboard_plug_real_hidden;
	((SwitchboardPlugClass *) klass)->search_callback = (void (*) (SwitchboardPlug*, const gchar*)) switchboard_plug_real_search_callback;
	G_OBJECT_CLASS (klass)->get_property = _vala_switchboard_plug_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_switchboard_plug_set_property;
	G_OBJECT_CLASS (klass)->finalize = switchboard_plug_finalize;
	/**
	     * The category under which the plug will be stored.
	     *
	     * Possible {@link Category} values are PERSONAL, HARDWARE, NETWORK or SYSTEM.
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), SWITCHBOARD_PLUG_CATEGORY_PROPERTY, switchboard_plug_properties[SWITCHBOARD_PLUG_CATEGORY_PROPERTY] = g_param_spec_enum ("category", "category", "category", SWITCHBOARD_PLUG_TYPE_CATEGORY, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	/**
	     * The unique name representing the plug.
	     *
	     * It is also used to recognise it with the open-plug command.
	     * for example "system-pantheon-info" for the official Info plug of the pantheon desktop.
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), SWITCHBOARD_PLUG_CODE_NAME_PROPERTY, switchboard_plug_properties[SWITCHBOARD_PLUG_CODE_NAME_PROPERTY] = g_param_spec_string ("code-name", "code-name", "code-name", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	/**
	     * The localised name of the plug.
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), SWITCHBOARD_PLUG_DISPLAY_NAME_PROPERTY, switchboard_plug_properties[SWITCHBOARD_PLUG_DISPLAY_NAME_PROPERTY] = g_param_spec_string ("display-name", "display-name", "display-name", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	/**
	     * A short description of the plug.
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), SWITCHBOARD_PLUG_DESCRIPTION_PROPERTY, switchboard_plug_properties[SWITCHBOARD_PLUG_DESCRIPTION_PROPERTY] = g_param_spec_string ("description", "description", "description", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	/**
	     * The icon representing the plug.
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), SWITCHBOARD_PLUG_ICON_PROPERTY, switchboard_plug_properties[SWITCHBOARD_PLUG_ICON_PROPERTY] = g_param_spec_string ("icon", "icon", "icon", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	/**
	     * A map of settings:// endpoints and location to pass to the
	     * {@link search_callback} method if the value is not %NULL.
	     * For example {"input/keyboard", "keyboard"}.
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), SWITCHBOARD_PLUG_SUPPORTED_SETTINGS_PROPERTY, switchboard_plug_properties[SWITCHBOARD_PLUG_SUPPORTED_SETTINGS_PROPERTY] = g_param_spec_object ("supported-settings", "supported-settings", "supported-settings", GEE_TYPE_TREE_MAP, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	/**
	     * Inform if the plug should be shown or not
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), SWITCHBOARD_PLUG_CAN_SHOW_PROPERTY, switchboard_plug_properties[SWITCHBOARD_PLUG_CAN_SHOW_PROPERTY] = g_param_spec_boolean ("can-show", "can-show", "can-show", TRUE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	     * Inform the application that the plug can now be listed in the available plugs.
	     * The application will also listen to the notify::can-show signal.
	     *
	     * @deprecated: The changing {@link can_show} activate the notify::can-show signal.
	     */
	switchboard_plug_signals[SWITCHBOARD_PLUG_VISIBILITY_CHANGED_SIGNAL] = g_signal_new ("visibility-changed", SWITCHBOARD_TYPE_PLUG, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}

static void
switchboard_plug_instance_init (SwitchboardPlug * self,
                                gpointer klass)
{
	GeeTreeMap* _tmp0_;
	self->priv = switchboard_plug_get_instance_private (self);
	_tmp0_ = gee_tree_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL, NULL, NULL, NULL);
	self->priv->_supported_settings = _tmp0_;
	self->priv->_can_show = TRUE;
}

static void
switchboard_plug_finalize (GObject * obj)
{
	SwitchboardPlug * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SWITCHBOARD_TYPE_PLUG, SwitchboardPlug);
	_g_free0 (self->priv->_code_name);
	_g_free0 (self->priv->_display_name);
	_g_free0 (self->priv->_description);
	_g_free0 (self->priv->_icon);
	_g_object_unref0 (self->priv->_supported_settings);
	G_OBJECT_CLASS (switchboard_plug_parent_class)->finalize (obj);
}

static GType
switchboard_plug_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SwitchboardPlugClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) switchboard_plug_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SwitchboardPlug), 0, (GInstanceInitFunc) switchboard_plug_instance_init, NULL };
	GType switchboard_plug_type_id;
	switchboard_plug_type_id = g_type_register_static (G_TYPE_OBJECT, "SwitchboardPlug", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
	SwitchboardPlug_private_offset = g_type_add_instance_private (switchboard_plug_type_id, sizeof (SwitchboardPlugPrivate));
	return switchboard_plug_type_id;
}

GType
switchboard_plug_get_type (void)
{
	static volatile gsize switchboard_plug_type_id__once = 0;
	if (g_once_init_enter (&switchboard_plug_type_id__once)) {
		GType switchboard_plug_type_id;
		switchboard_plug_type_id = switchboard_plug_get_type_once ();
		g_once_init_leave (&switchboard_plug_type_id__once, switchboard_plug_type_id);
	}
	return switchboard_plug_type_id__once;
}

static void
_vala_switchboard_plug_get_property (GObject * object,
                                     guint property_id,
                                     GValue * value,
                                     GParamSpec * pspec)
{
	SwitchboardPlug * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SWITCHBOARD_TYPE_PLUG, SwitchboardPlug);
	switch (property_id) {
		case SWITCHBOARD_PLUG_CATEGORY_PROPERTY:
		g_value_set_enum (value, switchboard_plug_get_category (self));
		break;
		case SWITCHBOARD_PLUG_CODE_NAME_PROPERTY:
		g_value_set_string (value, switchboard_plug_get_code_name (self));
		break;
		case SWITCHBOARD_PLUG_DISPLAY_NAME_PROPERTY:
		g_value_set_string (value, switchboard_plug_get_display_name (self));
		break;
		case SWITCHBOARD_PLUG_DESCRIPTION_PROPERTY:
		g_value_set_string (value, switchboard_plug_get_description (self));
		break;
		case SWITCHBOARD_PLUG_ICON_PROPERTY:
		g_value_set_string (value, switchboard_plug_get_icon (self));
		break;
		case SWITCHBOARD_PLUG_SUPPORTED_SETTINGS_PROPERTY:
		g_value_set_object (value, switchboard_plug_get_supported_settings (self));
		break;
		case SWITCHBOARD_PLUG_CAN_SHOW_PROPERTY:
		g_value_set_boolean (value, switchboard_plug_get_can_show (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_switchboard_plug_set_property (GObject * object,
                                     guint property_id,
                                     const GValue * value,
                                     GParamSpec * pspec)
{
	SwitchboardPlug * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SWITCHBOARD_TYPE_PLUG, SwitchboardPlug);
	switch (property_id) {
		case SWITCHBOARD_PLUG_CATEGORY_PROPERTY:
		switchboard_plug_set_category (self, g_value_get_enum (value));
		break;
		case SWITCHBOARD_PLUG_CODE_NAME_PROPERTY:
		switchboard_plug_set_code_name (self, g_value_get_string (value));
		break;
		case SWITCHBOARD_PLUG_DISPLAY_NAME_PROPERTY:
		switchboard_plug_set_display_name (self, g_value_get_string (value));
		break;
		case SWITCHBOARD_PLUG_DESCRIPTION_PROPERTY:
		switchboard_plug_set_description (self, g_value_get_string (value));
		break;
		case SWITCHBOARD_PLUG_ICON_PROPERTY:
		switchboard_plug_set_icon (self, g_value_get_string (value));
		break;
		case SWITCHBOARD_PLUG_SUPPORTED_SETTINGS_PROPERTY:
		switchboard_plug_set_supported_settings (self, g_value_get_object (value));
		break;
		case SWITCHBOARD_PLUG_CAN_SHOW_PROPERTY:
		switchboard_plug_set_can_show (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

