/* FirmwareReleaseView.c generated by valac 0.56.18, the Vala compiler
 * generated from FirmwareReleaseView.vala, do not modify */

/*
 * SPDX-License-Identifier: GPL-3.0-or-later
 * SPDX-FileCopyrightText: 2021-2023 elementary, Inc. (https://elementary.io)
 *
 * Authored by: Marius Meisenzahl <mariusmeisenzahl@gmail.com>
 */

#include "system.h"
#include <fwupd.h>
#include <granite-7.h>
#include <gtk/gtk.h>
#include <adwaita.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <glib/gi18n-lib.h>
#include <appstream.h>
#include <glib-object.h>
#include <pango/pango.h>
#include <float.h>
#include <math.h>

#define ABOUT_GETTEXT_PACKAGE "io.elementary.settings.system"
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	ABOUT_FIRMWARE_RELEASE_VIEW_0_PROPERTY,
	ABOUT_FIRMWARE_RELEASE_VIEW_NUM_PROPERTIES
};
static GParamSpec* about_firmware_release_view_properties[ABOUT_FIRMWARE_RELEASE_VIEW_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_ptr_array_unref0(var) ((var == NULL) ? NULL : (var = (g_ptr_array_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
enum  {
	ABOUT_FIRMWARE_RELEASE_VIEW_UPDATE_SIGNAL,
	ABOUT_FIRMWARE_RELEASE_VIEW_NUM_SIGNALS
};
static guint about_firmware_release_view_signals[ABOUT_FIRMWARE_RELEASE_VIEW_NUM_SIGNALS] = {0};

struct _AboutFirmwareReleaseViewPrivate {
	FwupdDevice* device;
	FwupdRelease* release;
	GranitePlaceholder* placeholder;
	GtkScrolledWindow* scrolled_window;
	GtkStack* stack;
	GtkRevealer* update_button_revealer;
	GtkButton* update_button;
	GtkLabel* title_label;
	GtkLabel* summary_label;
	GtkLabel* description_label;
	GtkLabel* version_value_label;
	GtkLabel* vendor_value_label;
	GtkLabel* size_value_label;
	GtkLabel* install_duration_value_label;
	AdwLeaflet* deck;
};

static gint AboutFirmwareReleaseView_private_offset;
static gpointer about_firmware_release_view_parent_class = NULL;

static void about_firmware_release_view_go_back (AboutFirmwareReleaseView* self);
static void g_cclosure_user_marshal_VOID__OBJECT_OBJECT (GClosure * closure,
                                                  GValue * return_value,
                                                  guint n_param_values,
                                                  const GValue * param_values,
                                                  gpointer invocation_hint,
                                                  gpointer marshal_data);
static GObject * about_firmware_release_view_constructor (GType type,
                                                   guint n_construct_properties,
                                                   GObjectConstructParam * construct_properties);
static void _about_firmware_release_view___lambda21_ (AboutFirmwareReleaseView* self);
static void __about_firmware_release_view___lambda21__gtk_button_clicked (GtkButton* _sender,
                                                                   gpointer self);
static void _about_firmware_release_view___lambda22_ (AboutFirmwareReleaseView* self);
static void __about_firmware_release_view___lambda22__gtk_button_clicked (GtkButton* _sender,
                                                                   gpointer self);
static void about_firmware_release_view_finalize (GObject * obj);
static GType about_firmware_release_view_get_type_once (void);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static inline gpointer
about_firmware_release_view_get_instance_private (AboutFirmwareReleaseView* self)
{
	return G_STRUCT_MEMBER_P (self, AboutFirmwareReleaseView_private_offset);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static gpointer
_g_ptr_array_ref0 (gpointer self)
{
	return self ? g_ptr_array_ref (self) : NULL;
}

void
about_firmware_release_view_update_view (AboutFirmwareReleaseView* self,
                                         FwupdDevice* device,
                                         FwupdRelease* release)
{
	FwupdDevice* _tmp0_;
	FwupdRelease* _tmp1_;
	gchar* device_name = NULL;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	GtkLabel* _tmp4_;
	const gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	GtkRevealer* _tmp8_;
	GtkStack* _tmp26_;
	GtkScrolledWindow* _tmp27_;
	gchar* release_version = NULL;
	const gchar* _tmp28_;
	gchar* _tmp29_;
	gboolean _tmp30_ = FALSE;
	GtkLabel* _tmp37_;
	const gchar* _tmp38_;
	GtkLabel* _tmp46_;
	const gchar* _tmp47_;
	GtkLabel* _tmp48_;
	const gchar* _tmp49_;
	GtkLabel* _tmp50_;
	gchar* _tmp51_;
	gchar* _tmp52_;
	guint32 duration_minutes = 0U;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (device != NULL);
	_tmp0_ = _g_object_ref0 (device);
	_g_object_unref0 (self->priv->device);
	self->priv->device = _tmp0_;
	_tmp1_ = _g_object_ref0 (release);
	_g_object_unref0 (self->priv->release);
	self->priv->release = _tmp1_;
	_tmp2_ = fwupd_device_get_name (device);
	_tmp3_ = g_strdup (_tmp2_);
	device_name = _tmp3_;
	_tmp4_ = self->priv->title_label;
	_tmp5_ = device_name;
	_tmp6_ = g_strdup_printf ("<b>%s</b>", _tmp5_);
	_tmp7_ = _tmp6_;
	gtk_label_set_label (_tmp4_, _tmp7_);
	_g_free0 (_tmp7_);
	_tmp8_ = self->priv->update_button_revealer;
	gtk_revealer_set_reveal_child (_tmp8_, release != NULL);
	if (release == NULL) {
		GranitePlaceholder* _tmp9_;
		const gchar* _tmp10_;
		GPtrArray* icons = NULL;
		GPtrArray* _tmp11_;
		GPtrArray* _tmp12_;
		GPtrArray* _tmp13_;
		gpointer* _tmp14_;
		gint _tmp14__length1;
		GtkStack* _tmp24_;
		GranitePlaceholder* _tmp25_;
		_tmp9_ = self->priv->placeholder;
		_tmp10_ = device_name;
		granite_placeholder_set_title (_tmp9_, _tmp10_);
		_tmp11_ = fwupd_device_get_icons (device);
		_tmp12_ = _g_ptr_array_ref0 (_tmp11_);
		icons = _tmp12_;
		_tmp13_ = icons;
		_tmp14_ = _tmp13_->pdata;
		_tmp14__length1 = _tmp13_->len;
		if (_tmp14_ != NULL) {
			GranitePlaceholder* _tmp15_;
			GPtrArray* _tmp16_;
			gpointer* _tmp17_;
			gint _tmp17__length1;
			const gchar* _tmp18_;
			GThemedIcon* _tmp19_;
			GThemedIcon* _tmp20_;
			_tmp15_ = self->priv->placeholder;
			_tmp16_ = icons;
			_tmp17_ = _tmp16_->pdata;
			_tmp17__length1 = _tmp16_->len;
			_tmp18_ = _tmp17_[0];
			_tmp19_ = (GThemedIcon*) g_themed_icon_new (_tmp18_);
			_tmp20_ = _tmp19_;
			granite_placeholder_set_icon (_tmp15_, (GIcon*) _tmp20_);
			_g_object_unref0 (_tmp20_);
		} else {
			GranitePlaceholder* _tmp21_;
			GThemedIcon* _tmp22_;
			GThemedIcon* _tmp23_;
			_tmp21_ = self->priv->placeholder;
			_tmp22_ = (GThemedIcon*) g_themed_icon_new ("application-x-firmware");
			_tmp23_ = _tmp22_;
			granite_placeholder_set_icon (_tmp21_, (GIcon*) _tmp23_);
			_g_object_unref0 (_tmp23_);
		}
		_tmp24_ = self->priv->stack;
		_tmp25_ = self->priv->placeholder;
		gtk_stack_set_visible_child (_tmp24_, (GtkWidget*) _tmp25_);
		_g_ptr_array_unref0 (icons);
		_g_free0 (device_name);
		return;
	}
	_tmp26_ = self->priv->stack;
	_tmp27_ = self->priv->scrolled_window;
	gtk_stack_set_visible_child (_tmp26_, (GtkWidget*) _tmp27_);
	_tmp28_ = fwupd_release_get_version (release);
	_tmp29_ = g_strdup (_tmp28_);
	release_version = _tmp29_;
	if (fwupd_release_get_flags (release) == FWUPD_RELEASE_FLAG_IS_UPGRADE) {
		const gchar* _tmp31_;
		const gchar* _tmp32_;
		_tmp31_ = release_version;
		_tmp32_ = fwupd_device_get_version (device);
		_tmp30_ = g_strcmp0 (_tmp31_, _tmp32_) != 0;
	} else {
		_tmp30_ = FALSE;
	}
	if (_tmp30_) {
		GtkButton* _tmp33_;
		GtkButton* _tmp34_;
		_tmp33_ = self->priv->update_button;
		gtk_button_set_label (_tmp33_, _ ("Update"));
		_tmp34_ = self->priv->update_button;
		gtk_widget_set_sensitive ((GtkWidget*) _tmp34_, TRUE);
	} else {
		GtkButton* _tmp35_;
		GtkButton* _tmp36_;
		_tmp35_ = self->priv->update_button;
		gtk_button_set_label (_tmp35_, _ ("Up to date"));
		_tmp36_ = self->priv->update_button;
		gtk_widget_set_sensitive ((GtkWidget*) _tmp36_, FALSE);
	}
	_tmp37_ = self->priv->summary_label;
	_tmp38_ = fwupd_release_get_summary (release);
	gtk_label_set_label (_tmp37_, _tmp38_);
	{
		gchar* _tmp39_ = NULL;
		const gchar* _tmp40_;
		gchar* _tmp41_;
		GtkLabel* _tmp42_;
		_tmp40_ = fwupd_release_get_description (release);
		_tmp41_ = as_markup_convert (_tmp40_, AS_MARKUP_KIND_XML, &_inner_error0_);
		_tmp39_ = _tmp41_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp42_ = self->priv->description_label;
		gtk_label_set_label (_tmp42_, _tmp39_);
		_g_free0 (_tmp39_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GtkLabel* _tmp43_;
		GError* _tmp44_;
		const gchar* _tmp45_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp43_ = self->priv->description_label;
		gtk_label_set_label (_tmp43_, "");
		_tmp44_ = e;
		_tmp45_ = _tmp44_->message;
		g_warning ("FirmwareReleaseView.vala:218: Could not convert markup of release: %s", _tmp45_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_free0 (release_version);
		_g_free0 (device_name);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_tmp46_ = self->priv->version_value_label;
	_tmp47_ = release_version;
	gtk_label_set_label (_tmp46_, _tmp47_);
	_tmp48_ = self->priv->vendor_value_label;
	_tmp49_ = fwupd_release_get_vendor (release);
	gtk_label_set_label (_tmp48_, _tmp49_);
	_tmp50_ = self->priv->size_value_label;
	_tmp51_ = g_format_size_full (fwupd_release_get_size (release), G_FORMAT_SIZE_DEFAULT);
	_tmp52_ = _tmp51_;
	gtk_label_set_label (_tmp50_, _tmp52_);
	_g_free0 (_tmp52_);
	duration_minutes = fwupd_release_get_install_duration (release) / 60;
	if (duration_minutes < ((guint32) 1)) {
		GtkLabel* _tmp53_;
		_tmp53_ = self->priv->install_duration_value_label;
		gtk_label_set_label (_tmp53_, _ ("less than a minute"));
	} else {
		GtkLabel* _tmp54_;
		gchar* _tmp55_;
		gchar* _tmp56_;
		_tmp54_ = self->priv->install_duration_value_label;
		_tmp55_ = g_strdup_printf (g_dngettext (ABOUT_GETTEXT_PACKAGE, "%llu minute", "%llu minutes", (gulong) duration_minutes), duration_minutes);
		_tmp56_ = _tmp55_;
		gtk_label_set_label (_tmp54_, _tmp56_);
		_g_free0 (_tmp56_);
	}
	_g_free0 (release_version);
	_g_free0 (device_name);
}

static void
about_firmware_release_view_go_back (AboutFirmwareReleaseView* self)
{
	AdwLeaflet* _tmp0_;
	AdwLeaflet* _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->deck;
	if (_tmp0_ == NULL) {
		GtkWidget* _tmp1_;
		AdwLeaflet* _tmp2_;
		_tmp1_ = gtk_widget_get_ancestor ((GtkWidget*) self, adw_leaflet_get_type ());
		_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, adw_leaflet_get_type (), AdwLeaflet));
		_g_object_unref0 (self->priv->deck);
		self->priv->deck = _tmp2_;
	}
	_tmp3_ = self->priv->deck;
	adw_leaflet_navigate (_tmp3_, ADW_NAVIGATION_DIRECTION_BACK);
}

AboutFirmwareReleaseView*
about_firmware_release_view_construct (GType object_type)
{
	AboutFirmwareReleaseView * self = NULL;
	self = (AboutFirmwareReleaseView*) g_object_new (object_type, NULL);
	return self;
}

AboutFirmwareReleaseView*
about_firmware_release_view_new (void)
{
	return about_firmware_release_view_construct (ABOUT_TYPE_FIRMWARE_RELEASE_VIEW);
}

static void
g_cclosure_user_marshal_VOID__OBJECT_OBJECT (GClosure * closure,
                                             GValue * return_value,
                                             guint n_param_values,
                                             const GValue * param_values,
                                             gpointer invocation_hint,
                                             gpointer marshal_data)
{
	typedef void (*GMarshalFunc_VOID__OBJECT_OBJECT) (gpointer data1, gpointer arg_1, gpointer arg_2, gpointer data2);
	register GMarshalFunc_VOID__OBJECT_OBJECT callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 3);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__OBJECT_OBJECT) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_object (param_values + 1), g_value_get_object (param_values + 2), data2);
}

static void
_about_firmware_release_view___lambda21_ (AboutFirmwareReleaseView* self)
{
	about_firmware_release_view_go_back (self);
}

static void
__about_firmware_release_view___lambda21__gtk_button_clicked (GtkButton* _sender,
                                                              gpointer self)
{
	_about_firmware_release_view___lambda21_ ((AboutFirmwareReleaseView*) self);
}

static void
_about_firmware_release_view___lambda22_ (AboutFirmwareReleaseView* self)
{
	FwupdDevice* _tmp0_;
	FwupdRelease* _tmp1_;
	about_firmware_release_view_go_back (self);
	_tmp0_ = self->priv->device;
	_tmp1_ = self->priv->release;
	g_signal_emit (self, about_firmware_release_view_signals[ABOUT_FIRMWARE_RELEASE_VIEW_UPDATE_SIGNAL], 0, _tmp0_, _tmp1_);
}

static void
__about_firmware_release_view___lambda22__gtk_button_clicked (GtkButton* _sender,
                                                              gpointer self)
{
	_about_firmware_release_view___lambda22_ ((AboutFirmwareReleaseView*) self);
}

static GObject *
about_firmware_release_view_constructor (GType type,
                                         guint n_construct_properties,
                                         GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	AboutFirmwareReleaseView * self;
	GtkButton* back_button = NULL;
	GtkButton* _tmp0_ = NULL;
	GtkButton* _tmp1_;
	GtkLabel* _tmp2_ = NULL;
	GtkButton* _tmp3_ = NULL;
	GtkButton* _tmp4_;
	GtkButton* _tmp5_;
	GtkWidget* _tmp6_;
	GtkRevealer* _tmp7_ = NULL;
	GtkCenterBox* header_box = NULL;
	GtkButton* _tmp8_;
	GtkWidget* _tmp9_;
	GtkLabel* _tmp10_;
	GtkWidget* _tmp11_;
	GtkRevealer* _tmp12_;
	GtkWidget* _tmp13_;
	GtkCenterBox* _tmp14_ = NULL;
	GtkLabel* _tmp15_ = NULL;
	GtkLabel* _tmp16_;
	GtkLabel* _tmp17_ = NULL;
	GtkLabel* version_label = NULL;
	GtkLabel* _tmp18_ = NULL;
	GtkLabel* _tmp19_ = NULL;
	GtkLabel* vendor_label = NULL;
	GtkLabel* _tmp20_ = NULL;
	GtkLabel* _tmp21_ = NULL;
	GtkLabel* size_label = NULL;
	GtkLabel* _tmp22_ = NULL;
	GtkLabel* _tmp23_ = NULL;
	GtkLabel* install_duration_label = NULL;
	GtkLabel* _tmp24_ = NULL;
	GtkLabel* _tmp25_ = NULL;
	GtkGrid* key_val_grid = NULL;
	GtkGrid* _tmp26_ = NULL;
	GtkGrid* _tmp27_;
	GtkGrid* _tmp28_;
	GtkLabel* _tmp29_;
	GtkGrid* _tmp30_;
	GtkLabel* _tmp31_;
	GtkGrid* _tmp32_;
	GtkLabel* _tmp33_;
	GtkGrid* _tmp34_;
	GtkLabel* _tmp35_;
	GtkGrid* _tmp36_;
	GtkLabel* _tmp37_;
	GtkGrid* _tmp38_;
	GtkLabel* _tmp39_;
	GtkGrid* _tmp40_;
	GtkLabel* _tmp41_;
	GtkGrid* _tmp42_;
	GtkLabel* _tmp43_;
	gchar* _tmp44_;
	GranitePlaceholder* _tmp45_ = NULL;
	GtkBox* box = NULL;
	GtkBox* _tmp46_ = NULL;
	GtkBox* _tmp47_;
	GtkLabel* _tmp48_;
	GtkBox* _tmp49_;
	GtkLabel* _tmp50_;
	GtkBox* _tmp51_;
	GtkGrid* _tmp52_;
	GtkBox* _tmp53_;
	GtkWidget* _tmp54_;
	GtkScrolledWindow* _tmp55_ = NULL;
	GtkStack* _tmp56_;
	GtkStack* _tmp57_;
	GranitePlaceholder* _tmp58_;
	GtkStack* _tmp59_;
	GtkScrolledWindow* _tmp60_;
	GtkCenterBox* _tmp61_;
	GtkSeparator* _tmp62_;
	GtkSeparator* _tmp63_;
	GtkStack* _tmp64_;
	GtkButton* _tmp65_;
	GtkButton* _tmp66_;
	parent_class = G_OBJECT_CLASS (about_firmware_release_view_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, ABOUT_TYPE_FIRMWARE_RELEASE_VIEW, AboutFirmwareReleaseView);
	_tmp0_ = (GtkButton*) gtk_button_new_with_label (_ ("All Updates"));
	gtk_widget_set_halign ((GtkWidget*) _tmp0_, GTK_ALIGN_START);
	gtk_widget_set_margin_top ((GtkWidget*) _tmp0_, 6);
	gtk_widget_set_margin_end ((GtkWidget*) _tmp0_, 6);
	gtk_widget_set_margin_bottom ((GtkWidget*) _tmp0_, 6);
	gtk_widget_set_margin_start ((GtkWidget*) _tmp0_, 6);
	g_object_ref_sink (_tmp0_);
	back_button = _tmp0_;
	_tmp1_ = back_button;
	gtk_widget_add_css_class ((GtkWidget*) _tmp1_, GRANITE_STYLE_CLASS_BACK_BUTTON);
	_tmp2_ = (GtkLabel*) gtk_label_new ("");
	gtk_label_set_ellipsize (_tmp2_, PANGO_ELLIPSIZE_END);
	gtk_label_set_use_markup (_tmp2_, TRUE);
	g_object_ref_sink (_tmp2_);
	_g_object_unref0 (self->priv->title_label);
	self->priv->title_label = _tmp2_;
	_tmp3_ = (GtkButton*) gtk_button_new_with_label ("");
	gtk_widget_set_halign ((GtkWidget*) _tmp3_, GTK_ALIGN_END);
	gtk_widget_set_margin_top ((GtkWidget*) _tmp3_, 6);
	gtk_widget_set_margin_end ((GtkWidget*) _tmp3_, 6);
	gtk_widget_set_margin_bottom ((GtkWidget*) _tmp3_, 6);
	gtk_widget_set_margin_start ((GtkWidget*) _tmp3_, 6);
	gtk_widget_set_sensitive ((GtkWidget*) _tmp3_, FALSE);
	g_object_ref_sink (_tmp3_);
	_g_object_unref0 (self->priv->update_button);
	self->priv->update_button = _tmp3_;
	_tmp4_ = self->priv->update_button;
	gtk_widget_add_css_class ((GtkWidget*) _tmp4_, GRANITE_STYLE_CLASS_SUGGESTED_ACTION);
	_tmp5_ = self->priv->update_button;
	_tmp6_ = _g_object_ref0 ((GtkWidget*) _tmp5_);
	_tmp7_ = (GtkRevealer*) gtk_revealer_new ();
	gtk_revealer_set_child (_tmp7_, _tmp6_);
	_g_object_unref0 (_tmp6_);
	g_object_ref_sink (_tmp7_);
	_g_object_unref0 (self->priv->update_button_revealer);
	self->priv->update_button_revealer = _tmp7_;
	_tmp8_ = back_button;
	_tmp9_ = _g_object_ref0 ((GtkWidget*) _tmp8_);
	_tmp10_ = self->priv->title_label;
	_tmp11_ = _g_object_ref0 ((GtkWidget*) _tmp10_);
	_tmp12_ = self->priv->update_button_revealer;
	_tmp13_ = _g_object_ref0 ((GtkWidget*) _tmp12_);
	_tmp14_ = (GtkCenterBox*) gtk_center_box_new ();
	gtk_widget_set_hexpand ((GtkWidget*) _tmp14_, TRUE);
	gtk_center_box_set_start_widget (_tmp14_, _tmp9_);
	_g_object_unref0 (_tmp9_);
	gtk_center_box_set_center_widget (_tmp14_, _tmp11_);
	_g_object_unref0 (_tmp11_);
	gtk_center_box_set_end_widget (_tmp14_, _tmp13_);
	_g_object_unref0 (_tmp13_);
	g_object_ref_sink (_tmp14_);
	header_box = _tmp14_;
	_tmp15_ = (GtkLabel*) gtk_label_new ("");
	gtk_widget_set_halign ((GtkWidget*) _tmp15_, GTK_ALIGN_START);
	gtk_label_set_wrap (_tmp15_, TRUE);
	g_object_ref_sink (_tmp15_);
	_g_object_unref0 (self->priv->summary_label);
	self->priv->summary_label = _tmp15_;
	_tmp16_ = self->priv->summary_label;
	gtk_widget_add_css_class ((GtkWidget*) _tmp16_, GRANITE_STYLE_CLASS_H2_LABEL);
	_tmp17_ = (GtkLabel*) gtk_label_new ("");
	gtk_widget_set_halign ((GtkWidget*) _tmp17_, GTK_ALIGN_START);
	gtk_label_set_wrap (_tmp17_, TRUE);
	g_object_ref_sink (_tmp17_);
	_g_object_unref0 (self->priv->description_label);
	self->priv->description_label = _tmp17_;
	_tmp18_ = (GtkLabel*) gtk_label_new (_ ("Version:"));
	gtk_label_set_xalign (_tmp18_, (gfloat) 1);
	g_object_ref_sink (_tmp18_);
	version_label = _tmp18_;
	_tmp19_ = (GtkLabel*) gtk_label_new ("");
	gtk_label_set_xalign (_tmp19_, (gfloat) 0);
	gtk_widget_set_hexpand ((GtkWidget*) _tmp19_, TRUE);
	g_object_ref_sink (_tmp19_);
	_g_object_unref0 (self->priv->version_value_label);
	self->priv->version_value_label = _tmp19_;
	_tmp20_ = (GtkLabel*) gtk_label_new (_ ("Vendor:"));
	gtk_label_set_xalign (_tmp20_, (gfloat) 1);
	g_object_ref_sink (_tmp20_);
	vendor_label = _tmp20_;
	_tmp21_ = (GtkLabel*) gtk_label_new ("");
	gtk_label_set_xalign (_tmp21_, (gfloat) 0);
	gtk_widget_set_hexpand ((GtkWidget*) _tmp21_, TRUE);
	g_object_ref_sink (_tmp21_);
	_g_object_unref0 (self->priv->vendor_value_label);
	self->priv->vendor_value_label = _tmp21_;
	_tmp22_ = (GtkLabel*) gtk_label_new (_ ("Size:"));
	gtk_label_set_xalign (_tmp22_, (gfloat) 1);
	g_object_ref_sink (_tmp22_);
	size_label = _tmp22_;
	_tmp23_ = (GtkLabel*) gtk_label_new ("");
	gtk_label_set_xalign (_tmp23_, (gfloat) 0);
	gtk_widget_set_hexpand ((GtkWidget*) _tmp23_, TRUE);
	g_object_ref_sink (_tmp23_);
	_g_object_unref0 (self->priv->size_value_label);
	self->priv->size_value_label = _tmp23_;
	_tmp24_ = (GtkLabel*) gtk_label_new (_ ("Estimated time to install:"));
	gtk_label_set_xalign (_tmp24_, (gfloat) 1);
	g_object_ref_sink (_tmp24_);
	install_duration_label = _tmp24_;
	_tmp25_ = (GtkLabel*) gtk_label_new ("");
	gtk_label_set_xalign (_tmp25_, (gfloat) 0);
	gtk_widget_set_hexpand ((GtkWidget*) _tmp25_, TRUE);
	g_object_ref_sink (_tmp25_);
	_g_object_unref0 (self->priv->install_duration_value_label);
	self->priv->install_duration_value_label = _tmp25_;
	_tmp26_ = (GtkGrid*) gtk_grid_new ();
	gtk_grid_set_column_homogeneous (_tmp26_, TRUE);
	gtk_grid_set_column_spacing (_tmp26_, 6);
	gtk_widget_set_halign ((GtkWidget*) _tmp26_, GTK_ALIGN_CENTER);
	gtk_widget_set_margin_top ((GtkWidget*) _tmp26_, 12);
	gtk_grid_set_row_spacing (_tmp26_, 3);
	g_object_ref_sink (_tmp26_);
	key_val_grid = _tmp26_;
	_tmp27_ = key_val_grid;
	gtk_widget_add_css_class ((GtkWidget*) _tmp27_, GRANITE_STYLE_CLASS_DIM_LABEL);
	_tmp28_ = key_val_grid;
	_tmp29_ = version_label;
	gtk_grid_attach (_tmp28_, (GtkWidget*) _tmp29_, 0, 0, 1, 1);
	_tmp30_ = key_val_grid;
	_tmp31_ = self->priv->version_value_label;
	gtk_grid_attach (_tmp30_, (GtkWidget*) _tmp31_, 1, 0, 1, 1);
	_tmp32_ = key_val_grid;
	_tmp33_ = vendor_label;
	gtk_grid_attach (_tmp32_, (GtkWidget*) _tmp33_, 0, 1, 1, 1);
	_tmp34_ = key_val_grid;
	_tmp35_ = self->priv->vendor_value_label;
	gtk_grid_attach (_tmp34_, (GtkWidget*) _tmp35_, 1, 1, 1, 1);
	_tmp36_ = key_val_grid;
	_tmp37_ = size_label;
	gtk_grid_attach (_tmp36_, (GtkWidget*) _tmp37_, 0, 2, 1, 1);
	_tmp38_ = key_val_grid;
	_tmp39_ = self->priv->size_value_label;
	gtk_grid_attach (_tmp38_, (GtkWidget*) _tmp39_, 1, 2, 1, 1);
	_tmp40_ = key_val_grid;
	_tmp41_ = install_duration_label;
	gtk_grid_attach (_tmp40_, (GtkWidget*) _tmp41_, 0, 3, 1, 1);
	_tmp42_ = key_val_grid;
	_tmp43_ = self->priv->install_duration_value_label;
	gtk_grid_attach (_tmp42_, (GtkWidget*) _tmp43_, 1, 3, 1, 1);
	_tmp44_ = g_strdup (_ ("There are no releases available for this device."));
	_tmp45_ = granite_placeholder_new ("");
	granite_placeholder_set_description (_tmp45_, _tmp44_);
	_g_free0 (_tmp44_);
	g_object_ref_sink (_tmp45_);
	_g_object_unref0 (self->priv->placeholder);
	self->priv->placeholder = _tmp45_;
	_tmp46_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 12);
	gtk_widget_set_halign ((GtkWidget*) _tmp46_, GTK_ALIGN_CENTER);
	gtk_widget_set_margin_top ((GtkWidget*) _tmp46_, 12);
	gtk_widget_set_margin_end ((GtkWidget*) _tmp46_, 12);
	gtk_widget_set_margin_bottom ((GtkWidget*) _tmp46_, 12);
	gtk_widget_set_margin_start ((GtkWidget*) _tmp46_, 12);
	gtk_widget_set_vexpand ((GtkWidget*) _tmp46_, TRUE);
	g_object_ref_sink (_tmp46_);
	box = _tmp46_;
	_tmp47_ = box;
	_tmp48_ = self->priv->summary_label;
	gtk_box_append (_tmp47_, (GtkWidget*) _tmp48_);
	_tmp49_ = box;
	_tmp50_ = self->priv->description_label;
	gtk_box_append (_tmp49_, (GtkWidget*) _tmp50_);
	_tmp51_ = box;
	_tmp52_ = key_val_grid;
	gtk_box_append (_tmp51_, (GtkWidget*) _tmp52_);
	_tmp53_ = box;
	_tmp54_ = _g_object_ref0 ((GtkWidget*) _tmp53_);
	_tmp55_ = (GtkScrolledWindow*) gtk_scrolled_window_new ();
	gtk_scrolled_window_set_child (_tmp55_, _tmp54_);
	_g_object_unref0 (_tmp54_);
	g_object_set (_tmp55_, "hscrollbar-policy", GTK_POLICY_NEVER, NULL);
	gtk_widget_set_vexpand ((GtkWidget*) _tmp55_, TRUE);
	g_object_ref_sink (_tmp55_);
	_g_object_unref0 (self->priv->scrolled_window);
	self->priv->scrolled_window = _tmp55_;
	_tmp56_ = (GtkStack*) gtk_stack_new ();
	g_object_ref_sink (_tmp56_);
	_g_object_unref0 (self->priv->stack);
	self->priv->stack = _tmp56_;
	_tmp57_ = self->priv->stack;
	_tmp58_ = self->priv->placeholder;
	gtk_stack_add_child (_tmp57_, (GtkWidget*) _tmp58_);
	_tmp59_ = self->priv->stack;
	_tmp60_ = self->priv->scrolled_window;
	gtk_stack_add_child (_tmp59_, (GtkWidget*) _tmp60_);
	gtk_orientable_set_orientation ((GtkOrientable*) self, GTK_ORIENTATION_VERTICAL);
	gtk_widget_add_css_class ((GtkWidget*) self, GRANITE_STYLE_CLASS_VIEW);
	_tmp61_ = header_box;
	gtk_box_append ((GtkBox*) self, (GtkWidget*) _tmp61_);
	_tmp62_ = (GtkSeparator*) gtk_separator_new (GTK_ORIENTATION_HORIZONTAL);
	g_object_ref_sink (_tmp62_);
	_tmp63_ = _tmp62_;
	gtk_box_append ((GtkBox*) self, (GtkWidget*) _tmp63_);
	_g_object_unref0 (_tmp63_);
	_tmp64_ = self->priv->stack;
	gtk_box_append ((GtkBox*) self, (GtkWidget*) _tmp64_);
	_tmp65_ = back_button;
	g_signal_connect_object (_tmp65_, "clicked", (GCallback) __about_firmware_release_view___lambda21__gtk_button_clicked, self, 0);
	_tmp66_ = self->priv->update_button;
	g_signal_connect_object (_tmp66_, "clicked", (GCallback) __about_firmware_release_view___lambda22__gtk_button_clicked, self, 0);
	_g_object_unref0 (box);
	_g_object_unref0 (key_val_grid);
	_g_object_unref0 (install_duration_label);
	_g_object_unref0 (size_label);
	_g_object_unref0 (vendor_label);
	_g_object_unref0 (version_label);
	_g_object_unref0 (header_box);
	_g_object_unref0 (back_button);
	return obj;
}

static void
about_firmware_release_view_class_init (AboutFirmwareReleaseViewClass * klass,
                                        gpointer klass_data)
{
	about_firmware_release_view_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &AboutFirmwareReleaseView_private_offset);
	G_OBJECT_CLASS (klass)->constructor = about_firmware_release_view_constructor;
	G_OBJECT_CLASS (klass)->finalize = about_firmware_release_view_finalize;
	about_firmware_release_view_signals[ABOUT_FIRMWARE_RELEASE_VIEW_UPDATE_SIGNAL] = g_signal_new ("update", ABOUT_TYPE_FIRMWARE_RELEASE_VIEW, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__OBJECT_OBJECT, G_TYPE_NONE, 2, fwupd_device_get_type (), fwupd_release_get_type ());
}

static void
about_firmware_release_view_instance_init (AboutFirmwareReleaseView * self,
                                           gpointer klass)
{
	self->priv = about_firmware_release_view_get_instance_private (self);
}

static void
about_firmware_release_view_finalize (GObject * obj)
{
	AboutFirmwareReleaseView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, ABOUT_TYPE_FIRMWARE_RELEASE_VIEW, AboutFirmwareReleaseView);
	_g_object_unref0 (self->priv->device);
	_g_object_unref0 (self->priv->release);
	_g_object_unref0 (self->priv->placeholder);
	_g_object_unref0 (self->priv->scrolled_window);
	_g_object_unref0 (self->priv->stack);
	_g_object_unref0 (self->priv->update_button_revealer);
	_g_object_unref0 (self->priv->update_button);
	_g_object_unref0 (self->priv->title_label);
	_g_object_unref0 (self->priv->summary_label);
	_g_object_unref0 (self->priv->description_label);
	_g_object_unref0 (self->priv->version_value_label);
	_g_object_unref0 (self->priv->vendor_value_label);
	_g_object_unref0 (self->priv->size_value_label);
	_g_object_unref0 (self->priv->install_duration_value_label);
	_g_object_unref0 (self->priv->deck);
	G_OBJECT_CLASS (about_firmware_release_view_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
about_firmware_release_view_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (AboutFirmwareReleaseViewClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) about_firmware_release_view_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (AboutFirmwareReleaseView), 0, (GInstanceInitFunc) about_firmware_release_view_instance_init, NULL };
	GType about_firmware_release_view_type_id;
	about_firmware_release_view_type_id = g_type_register_static (gtk_box_get_type (), "AboutFirmwareReleaseView", &g_define_type_info, 0);
	AboutFirmwareReleaseView_private_offset = g_type_add_instance_private (about_firmware_release_view_type_id, sizeof (AboutFirmwareReleaseViewPrivate));
	return about_firmware_release_view_type_id;
}

GType
about_firmware_release_view_get_type (void)
{
	static volatile gsize about_firmware_release_view_type_id__once = 0;
	if (g_once_init_enter (&about_firmware_release_view_type_id__once)) {
		GType about_firmware_release_view_type_id;
		about_firmware_release_view_type_id = about_firmware_release_view_get_type_once ();
		g_once_init_leave (&about_firmware_release_view_type_id__once, about_firmware_release_view_type_id);
	}
	return about_firmware_release_view_type_id__once;
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

