/* AppManager.c generated by valac 0.56.17, the Vala compiler
 * generated from AppManager.vala, do not modify */

/*
* Copyright 2020 elementary, Inc. (https://elementary.io)
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public
* License as published by the Free Software Foundation; either
* version 3 of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* General Public License for more details.
*
* You should have received a copy of the GNU General Public
* License along with this program; if not, write to the
* Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
* Boston, MA 02110-1301 USA
*
* Authored by: Marius Meisenzahl <mariusmeisenzahl@gmail.com>
*/

#include "applications.h"
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <flatpak.h>
#include <glib-object.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	PERMISSIONS_BACKEND_APP_MANAGER_0_PROPERTY,
	PERMISSIONS_BACKEND_APP_MANAGER_APPS_PROPERTY,
	PERMISSIONS_BACKEND_APP_MANAGER_NUM_PROPERTIES
};
static GParamSpec* permissions_backend_app_manager_properties[PERMISSIONS_BACKEND_APP_MANAGER_NUM_PROPERTIES];
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_ptr_array_unref0(var) ((var == NULL) ? NULL : (var = (g_ptr_array_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

struct _PermissionsBackendAppManagerPrivate {
	GHashTable* _apps;
};

static gint PermissionsBackendAppManager_private_offset;
static gpointer permissions_backend_app_manager_parent_class = NULL;
static PermissionsBackendAppManager* permissions_backend_app_manager_instance;
static PermissionsBackendAppManager* permissions_backend_app_manager_instance = NULL;

static void permissions_backend_app_manager_get_apps_for_installation (PermissionsBackendAppManager* self,
                                                                FlatpakInstallation* installation);
static void ___lambda32_ (PermissionsBackendAppManager* self,
                   FlatpakInstalledRef* installed_ref);
static void ____lambda32__gfunc (gconstpointer data,
                          gpointer self);
static void permissions_backend_app_manager_set_apps (PermissionsBackendAppManager* self,
                                               GHashTable* value);
static GObject * permissions_backend_app_manager_constructor (GType type,
                                                       guint n_construct_properties,
                                                       GObjectConstructParam * construct_properties);
static void _g_free0_ (gpointer var);
static void _g_object_unref0_ (gpointer var);
static void permissions_backend_app_manager_finalize (GObject * obj);
static GType permissions_backend_app_manager_get_type_once (void);
static void _vala_permissions_backend_app_manager_get_property (GObject * object,
                                                         guint property_id,
                                                         GValue * value,
                                                         GParamSpec * pspec);
static void _vala_permissions_backend_app_manager_set_property (GObject * object,
                                                         guint property_id,
                                                         const GValue * value,
                                                         GParamSpec * pspec);

static inline gpointer
permissions_backend_app_manager_get_instance_private (PermissionsBackendAppManager* self)
{
	return G_STRUCT_MEMBER_P (self, PermissionsBackendAppManager_private_offset);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

PermissionsBackendAppManager*
permissions_backend_app_manager_get_default (void)
{
	PermissionsBackendAppManager* _tmp0_;
	PermissionsBackendAppManager* _tmp2_;
	PermissionsBackendAppManager* _tmp3_;
	PermissionsBackendAppManager* result;
	_tmp0_ = permissions_backend_app_manager_instance;
	if (_tmp0_ == NULL) {
		PermissionsBackendAppManager* _tmp1_;
		_tmp1_ = permissions_backend_app_manager_new ();
		_g_object_unref0 (permissions_backend_app_manager_instance);
		permissions_backend_app_manager_instance = _tmp1_;
	}
	_tmp2_ = permissions_backend_app_manager_instance;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	result = _tmp3_;
	return result;
}

static void
___lambda32_ (PermissionsBackendAppManager* self,
              FlatpakInstalledRef* installed_ref)
{
	const gchar* id = NULL;
	const gchar* _tmp0_;
	GHashTable* _tmp1_;
	const gchar* _tmp2_;
	gconstpointer _tmp3_;
	g_return_if_fail (installed_ref != NULL);
	_tmp0_ = flatpak_ref_get_name ((FlatpakRef*) installed_ref);
	id = _tmp0_;
	_tmp1_ = self->priv->_apps;
	_tmp2_ = id;
	_tmp3_ = g_hash_table_lookup (_tmp1_, _tmp2_);
	if (((PermissionsBackendApp*) _tmp3_) == NULL) {
		GHashTable* _tmp4_;
		const gchar* _tmp5_;
		gchar* _tmp6_;
		PermissionsBackendApp* _tmp7_;
		_tmp4_ = self->priv->_apps;
		_tmp5_ = id;
		_tmp6_ = g_strdup (_tmp5_);
		_tmp7_ = permissions_backend_app_new (installed_ref);
		g_hash_table_insert (_tmp4_, _tmp6_, _tmp7_);
	}
}

static void
____lambda32__gfunc (gconstpointer data,
                     gpointer self)
{
	___lambda32_ ((PermissionsBackendAppManager*) self, (FlatpakInstalledRef*) data);
}

static void
permissions_backend_app_manager_get_apps_for_installation (PermissionsBackendAppManager* self,
                                                           FlatpakInstallation* installation)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (installation != NULL);
	{
		GPtrArray* _tmp0_ = NULL;
		GPtrArray* _tmp1_;
		_tmp1_ = flatpak_installation_list_installed_refs_by_kind (installation, FLATPAK_REF_KIND_APP, NULL, &_inner_error0_);
		_tmp0_ = _tmp1_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		g_ptr_array_foreach (_tmp0_, ____lambda32__gfunc, self);
		_g_ptr_array_unref0 (_tmp0_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp2_;
		const gchar* _tmp3_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp2_ = e;
		_tmp3_ = _tmp2_->message;
		g_critical ("AppManager.vala:61: Unable to get installed flatpaks: %s", _tmp3_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

PermissionsBackendAppManager*
permissions_backend_app_manager_construct (GType object_type)
{
	PermissionsBackendAppManager * self = NULL;
	self = (PermissionsBackendAppManager*) g_object_new (object_type, NULL);
	return self;
}

PermissionsBackendAppManager*
permissions_backend_app_manager_new (void)
{
	return permissions_backend_app_manager_construct (PERMISSIONS_BACKEND_TYPE_APP_MANAGER);
}

GHashTable*
permissions_backend_app_manager_get_apps (PermissionsBackendAppManager* self)
{
	GHashTable* result;
	GHashTable* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_apps;
	result = _tmp0_;
	return result;
}

static gpointer
_g_hash_table_ref0 (gpointer self)
{
	return self ? g_hash_table_ref (self) : NULL;
}

static void
permissions_backend_app_manager_set_apps (PermissionsBackendAppManager* self,
                                          GHashTable* value)
{
	GHashTable* old_value;
	g_return_if_fail (self != NULL);
	old_value = permissions_backend_app_manager_get_apps (self);
	if (old_value != value) {
		GHashTable* _tmp0_;
		_tmp0_ = _g_hash_table_ref0 (value);
		_g_hash_table_unref0 (self->priv->_apps);
		self->priv->_apps = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, permissions_backend_app_manager_properties[PERMISSIONS_BACKEND_APP_MANAGER_APPS_PROPERTY]);
	}
}

static void
_g_free0_ (gpointer var)
{
	var = (g_free (var), NULL);
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static GObject *
permissions_backend_app_manager_constructor (GType type,
                                             guint n_construct_properties,
                                             GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	PermissionsBackendAppManager * self;
	GHashFunc _tmp0_;
	GEqualFunc _tmp1_;
	GHashTable* _tmp2_;
	GHashTable* _tmp3_;
	GError* _inner_error0_ = NULL;
	parent_class = G_OBJECT_CLASS (permissions_backend_app_manager_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, PERMISSIONS_BACKEND_TYPE_APP_MANAGER, PermissionsBackendAppManager);
	_tmp0_ = g_str_hash;
	_tmp1_ = g_str_equal;
	_tmp2_ = g_hash_table_new_full (_tmp0_, _tmp1_, _g_free0_, _g_object_unref0_);
	_tmp3_ = _tmp2_;
	permissions_backend_app_manager_set_apps (self, _tmp3_);
	_g_hash_table_unref0 (_tmp3_);
	{
		FlatpakInstallation* installation = NULL;
		FlatpakInstallation* _tmp4_;
		FlatpakInstallation* _tmp5_;
		_tmp4_ = flatpak_installation_new_user (NULL, &_inner_error0_);
		installation = _tmp4_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp5_ = installation;
		permissions_backend_app_manager_get_apps_for_installation (self, _tmp5_);
		_g_object_unref0 (installation);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp6_;
		const gchar* _tmp7_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp6_ = e;
		_tmp7_ = _tmp6_->message;
		g_critical ("AppManager.vala:41: Unable to get flatpak user installation : %s", _tmp7_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
	}
	{
		FlatpakInstallation* installation = NULL;
		FlatpakInstallation* _tmp8_;
		FlatpakInstallation* _tmp9_;
		_tmp8_ = flatpak_installation_new_system (NULL, &_inner_error0_);
		installation = _tmp8_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch1_g_error;
		}
		_tmp9_ = installation;
		permissions_backend_app_manager_get_apps_for_installation (self, _tmp9_);
		_g_object_unref0 (installation);
	}
	goto __finally1;
	__catch1_g_error:
	{
		GError* e = NULL;
		GError* _tmp10_;
		const gchar* _tmp11_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp10_ = e;
		_tmp11_ = _tmp10_->message;
		g_critical ("AppManager.vala:48: Unable to get flatpak system installation : %s", _tmp11_);
		_g_error_free0 (e);
	}
	__finally1:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
	}
	return obj;
}

static void
permissions_backend_app_manager_class_init (PermissionsBackendAppManagerClass * klass,
                                            gpointer klass_data)
{
	permissions_backend_app_manager_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &PermissionsBackendAppManager_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_permissions_backend_app_manager_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_permissions_backend_app_manager_set_property;
	G_OBJECT_CLASS (klass)->constructor = permissions_backend_app_manager_constructor;
	G_OBJECT_CLASS (klass)->finalize = permissions_backend_app_manager_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), PERMISSIONS_BACKEND_APP_MANAGER_APPS_PROPERTY, permissions_backend_app_manager_properties[PERMISSIONS_BACKEND_APP_MANAGER_APPS_PROPERTY] = g_param_spec_boxed ("apps", "apps", "apps", G_TYPE_HASH_TABLE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

static void
permissions_backend_app_manager_instance_init (PermissionsBackendAppManager * self,
                                               gpointer klass)
{
	self->priv = permissions_backend_app_manager_get_instance_private (self);
}

static void
permissions_backend_app_manager_finalize (GObject * obj)
{
	PermissionsBackendAppManager * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, PERMISSIONS_BACKEND_TYPE_APP_MANAGER, PermissionsBackendAppManager);
	_g_hash_table_unref0 (self->priv->_apps);
	G_OBJECT_CLASS (permissions_backend_app_manager_parent_class)->finalize (obj);
}

static GType
permissions_backend_app_manager_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (PermissionsBackendAppManagerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) permissions_backend_app_manager_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PermissionsBackendAppManager), 0, (GInstanceInitFunc) permissions_backend_app_manager_instance_init, NULL };
	GType permissions_backend_app_manager_type_id;
	permissions_backend_app_manager_type_id = g_type_register_static (G_TYPE_OBJECT, "PermissionsBackendAppManager", &g_define_type_info, 0);
	PermissionsBackendAppManager_private_offset = g_type_add_instance_private (permissions_backend_app_manager_type_id, sizeof (PermissionsBackendAppManagerPrivate));
	return permissions_backend_app_manager_type_id;
}

GType
permissions_backend_app_manager_get_type (void)
{
	static volatile gsize permissions_backend_app_manager_type_id__once = 0;
	if (g_once_init_enter (&permissions_backend_app_manager_type_id__once)) {
		GType permissions_backend_app_manager_type_id;
		permissions_backend_app_manager_type_id = permissions_backend_app_manager_get_type_once ();
		g_once_init_leave (&permissions_backend_app_manager_type_id__once, permissions_backend_app_manager_type_id);
	}
	return permissions_backend_app_manager_type_id__once;
}

static void
_vala_permissions_backend_app_manager_get_property (GObject * object,
                                                    guint property_id,
                                                    GValue * value,
                                                    GParamSpec * pspec)
{
	PermissionsBackendAppManager * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, PERMISSIONS_BACKEND_TYPE_APP_MANAGER, PermissionsBackendAppManager);
	switch (property_id) {
		case PERMISSIONS_BACKEND_APP_MANAGER_APPS_PROPERTY:
		g_value_set_boxed (value, permissions_backend_app_manager_get_apps (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_permissions_backend_app_manager_set_property (GObject * object,
                                                    guint property_id,
                                                    const GValue * value,
                                                    GParamSpec * pspec)
{
	PermissionsBackendAppManager * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, PERMISSIONS_BACKEND_TYPE_APP_MANAGER, PermissionsBackendAppManager);
	switch (property_id) {
		case PERMISSIONS_BACKEND_APP_MANAGER_APPS_PROPERTY:
		permissions_backend_app_manager_set_apps (self, g_value_get_boxed (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

