/* DeviceRow.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from DeviceRow.vala, do not modify */

/* -*- Mode: vala; indent-tabs-mode: nil; tab-width: 4 -*-*/
/*-
 * Copyright (c) 2016 elementary LLC.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authored by: Corentin Noël <corentin@elementary.io>
 */

#include "bluetooth.h"
#include <gtk/gtk.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <glib/gi18n-lib.h>
#include <gio/gio.h>
#include <float.h>
#include <math.h>
#include <granite-7.h>
#include <pango/pango.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	BLUETOOTH_DEVICE_ROW_0_PROPERTY,
	BLUETOOTH_DEVICE_ROW_DEVICE_PROPERTY,
	BLUETOOTH_DEVICE_ROW_NUM_PROPERTIES
};
static GParamSpec* bluetooth_device_row_properties[BLUETOOTH_DEVICE_ROW_NUM_PROPERTIES];
typedef enum  {
	BLUETOOTH_DEVICE_ROW_STATUS_UNPAIRED,
	BLUETOOTH_DEVICE_ROW_STATUS_PAIRING,
	BLUETOOTH_DEVICE_ROW_STATUS_CONNECTED,
	BLUETOOTH_DEVICE_ROW_STATUS_CONNECTING,
	BLUETOOTH_DEVICE_ROW_STATUS_DISCONNECTING,
	BLUETOOTH_DEVICE_ROW_STATUS_NOT_CONNECTED,
	BLUETOOTH_DEVICE_ROW_STATUS_UNABLE_TO_CONNECT,
	BLUETOOTH_DEVICE_ROW_STATUS_UNABLE_TO_CONNECT_PAIRED
} BluetoothDeviceRowStatus;

#define BLUETOOTH_DEVICE_ROW_TYPE_STATUS (bluetooth_device_row_status_get_type ())
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _BluetoothDeviceRowOnActivateData BluetoothDeviceRowOnActivateData;
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _Block2Data Block2Data;
#define _g_variant_type_free0(var) ((var == NULL) ? NULL : (var = (g_variant_type_free (var), NULL)))
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
enum  {
	BLUETOOTH_DEVICE_ROW_STATUS_CHANGED_SIGNAL,
	BLUETOOTH_DEVICE_ROW_NUM_SIGNALS
};
static guint bluetooth_device_row_signals[BLUETOOTH_DEVICE_ROW_NUM_SIGNALS] = {0};

struct _BluetoothDeviceRowPrivate {
	BluetoothServicesDevice* _device;
	GtkButton* connect_button;
	GtkButton* forget_button;
	GtkImage* state;
	GtkLabel* state_label;
	GtkLinkButton* settings_button;
};

struct _BluetoothDeviceRowOnActivateData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	BluetoothDeviceRow* self;
	BluetoothServicesDevice* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	BluetoothServicesDevice* _tmp3_;
	BluetoothServicesDevice* _tmp4_;
	BluetoothServicesDevice* _tmp5_;
	gboolean _tmp6_;
	gboolean _tmp7_;
	GError* e;
	GError* _tmp8_;
	const gchar* _tmp9_;
	BluetoothServicesDevice* _tmp10_;
	gboolean _tmp11_;
	gboolean _tmp12_;
	BluetoothServicesDevice* _tmp13_;
	GError* _vala1_e;
	GError* _tmp14_;
	const gchar* _tmp15_;
	BluetoothServicesDevice* _tmp16_;
	GError* _vala2_e;
	GtkImage* _tmp17_;
	GError* _tmp18_;
	const gchar* _tmp19_;
	GError* _inner_error0_;
};

struct _Block2Data {
	int _ref_count_;
	BluetoothDeviceRow* self;
	GtkImage* image;
	GtkLabel* label;
	BluetoothServicesAdapter* adapter;
};

static gint BluetoothDeviceRow_private_offset;
static gpointer bluetooth_device_row_parent_class = NULL;
static GtkSizeGroup* bluetooth_device_row_size_group;
static GtkSizeGroup* bluetooth_device_row_size_group = NULL;

static GType bluetooth_device_row_status_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
static gchar* bluetooth_device_row_status_to_string (BluetoothDeviceRowStatus self);
static void bluetooth_device_row_on_activate_data_free (gpointer _data);
static gboolean bluetooth_device_row_on_activate_co (BluetoothDeviceRowOnActivateData* _data_);
static void bluetooth_device_row_set_status (BluetoothDeviceRow* self,
                                      BluetoothDeviceRowStatus status);
static void bluetooth_device_row_on_activate_ready (GObject* source_object,
                                             GAsyncResult* _res_,
                                             gpointer _user_data_);
static void bluetooth_device_row_compute_status (BluetoothDeviceRow* self);
static GObject * bluetooth_device_row_constructor (GType type,
                                            guint n_construct_properties,
                                            GObjectConstructParam * construct_properties);
static Block2Data* block2_data_ref (Block2Data* _data2_);
static void block2_data_unref (void * _userdata_);
static void _bluetooth_device_row___lambda29_ (Block2Data* _data2_,
                                        GVariant* changed,
                                        gchar** invalid);
static void __bluetooth_device_row___lambda29__g_dbus_proxy_g_properties_changed (GDBusProxy* _sender,
                                                                           GVariant* changed_properties,
                                                                           gchar** invalidated_properties,
                                                                           gpointer self);
static void _bluetooth_device_row___lambda30_ (Block2Data* _data2_,
                                        GVariant* changed,
                                        gchar** invalid);
static void __bluetooth_device_row___lambda30__g_dbus_proxy_g_properties_changed (GDBusProxy* _sender,
                                                                           GVariant* changed_properties,
                                                                           gchar** invalidated_properties,
                                                                           gpointer self);
static void _bluetooth_device_row___lambda31_ (BluetoothDeviceRow* self);
static void __bluetooth_device_row___lambda31__gtk_button_clicked (GtkButton* _sender,
                                                            gpointer self);
static void _bluetooth_device_row___lambda32_ (Block2Data* _data2_);
static void __bluetooth_device_row___lambda32__gtk_button_clicked (GtkButton* _sender,
                                                            gpointer self);
static void bluetooth_device_row_finalize (GObject * obj);
static GType bluetooth_device_row_get_type_once (void);
static void _vala_bluetooth_device_row_get_property (GObject * object,
                                              guint property_id,
                                              GValue * value,
                                              GParamSpec * pspec);
static void _vala_bluetooth_device_row_set_property (GObject * object,
                                              guint property_id,
                                              const GValue * value,
                                              GParamSpec * pspec);

static inline gpointer
bluetooth_device_row_get_instance_private (BluetoothDeviceRow* self)
{
	return G_STRUCT_MEMBER_P (self, BluetoothDeviceRow_private_offset);
}

static gchar*
bluetooth_device_row_status_to_string (BluetoothDeviceRowStatus self)
{
	gchar* result;
	switch (self) {
		case BLUETOOTH_DEVICE_ROW_STATUS_UNPAIRED:
		{
			gchar* _tmp0_;
			_tmp0_ = g_strdup (_ ("Available"));
			result = _tmp0_;
			return result;
		}
		case BLUETOOTH_DEVICE_ROW_STATUS_PAIRING:
		{
			gchar* _tmp1_;
			_tmp1_ = g_strdup (_ ("Pairing…"));
			result = _tmp1_;
			return result;
		}
		case BLUETOOTH_DEVICE_ROW_STATUS_CONNECTED:
		{
			gchar* _tmp2_;
			_tmp2_ = g_strdup (_ ("Connected"));
			result = _tmp2_;
			return result;
		}
		case BLUETOOTH_DEVICE_ROW_STATUS_CONNECTING:
		{
			gchar* _tmp3_;
			_tmp3_ = g_strdup (_ ("Connecting…"));
			result = _tmp3_;
			return result;
		}
		case BLUETOOTH_DEVICE_ROW_STATUS_DISCONNECTING:
		{
			gchar* _tmp4_;
			_tmp4_ = g_strdup (_ ("Disconnecting…"));
			result = _tmp4_;
			return result;
		}
		case BLUETOOTH_DEVICE_ROW_STATUS_UNABLE_TO_CONNECT:
		case BLUETOOTH_DEVICE_ROW_STATUS_UNABLE_TO_CONNECT_PAIRED:
		{
			gchar* _tmp5_;
			_tmp5_ = g_strdup (_ ("Unable to Connect"));
			result = _tmp5_;
			return result;
		}
		default:
		{
			gchar* _tmp6_;
			_tmp6_ = g_strdup (_ ("Not Connected"));
			result = _tmp6_;
			return result;
		}
	}
}

static GType
bluetooth_device_row_status_get_type_once (void)
{
	static const GEnumValue values[] = {{BLUETOOTH_DEVICE_ROW_STATUS_UNPAIRED, "BLUETOOTH_DEVICE_ROW_STATUS_UNPAIRED", "unpaired"}, {BLUETOOTH_DEVICE_ROW_STATUS_PAIRING, "BLUETOOTH_DEVICE_ROW_STATUS_PAIRING", "pairing"}, {BLUETOOTH_DEVICE_ROW_STATUS_CONNECTED, "BLUETOOTH_DEVICE_ROW_STATUS_CONNECTED", "connected"}, {BLUETOOTH_DEVICE_ROW_STATUS_CONNECTING, "BLUETOOTH_DEVICE_ROW_STATUS_CONNECTING", "connecting"}, {BLUETOOTH_DEVICE_ROW_STATUS_DISCONNECTING, "BLUETOOTH_DEVICE_ROW_STATUS_DISCONNECTING", "disconnecting"}, {BLUETOOTH_DEVICE_ROW_STATUS_NOT_CONNECTED, "BLUETOOTH_DEVICE_ROW_STATUS_NOT_CONNECTED", "not-connected"}, {BLUETOOTH_DEVICE_ROW_STATUS_UNABLE_TO_CONNECT, "BLUETOOTH_DEVICE_ROW_STATUS_UNABLE_TO_CONNECT", "unable-to-connect"}, {BLUETOOTH_DEVICE_ROW_STATUS_UNABLE_TO_CONNECT_PAIRED, "BLUETOOTH_DEVICE_ROW_STATUS_UNABLE_TO_CONNECT_PAIRED", "unable-to-connect-paired"}, {0, NULL, NULL}};
	GType bluetooth_device_row_status_type_id;
	bluetooth_device_row_status_type_id = g_enum_register_static ("BluetoothDeviceRowStatus", values);
	return bluetooth_device_row_status_type_id;
}

static GType
bluetooth_device_row_status_get_type (void)
{
	static volatile gsize bluetooth_device_row_status_type_id__once = 0;
	if (g_once_init_enter (&bluetooth_device_row_status_type_id__once)) {
		GType bluetooth_device_row_status_type_id;
		bluetooth_device_row_status_type_id = bluetooth_device_row_status_get_type_once ();
		g_once_init_leave (&bluetooth_device_row_status_type_id__once, bluetooth_device_row_status_type_id);
	}
	return bluetooth_device_row_status_type_id__once;
}

BluetoothDeviceRow*
bluetooth_device_row_construct (GType object_type,
                                BluetoothServicesDevice* device)
{
	BluetoothDeviceRow * self = NULL;
	g_return_val_if_fail (device != NULL, NULL);
	self = (BluetoothDeviceRow*) g_object_new (object_type, "device", device, NULL);
	return self;
}

BluetoothDeviceRow*
bluetooth_device_row_new (BluetoothServicesDevice* device)
{
	return bluetooth_device_row_construct (BLUETOOTH_TYPE_DEVICE_ROW, device);
}

static void
bluetooth_device_row_on_activate_data_free (gpointer _data)
{
	BluetoothDeviceRowOnActivateData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (BluetoothDeviceRowOnActivateData, _data_);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

void
bluetooth_device_row_on_activate (BluetoothDeviceRow* self,
                                  GAsyncReadyCallback _callback_,
                                  gpointer _user_data_)
{
	BluetoothDeviceRowOnActivateData* _data_;
	BluetoothDeviceRow* _tmp0_;
	g_return_if_fail (self != NULL);
	_data_ = g_slice_new0 (BluetoothDeviceRowOnActivateData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, bluetooth_device_row_on_activate_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	bluetooth_device_row_on_activate_co (_data_);
}

void
bluetooth_device_row_on_activate_finish (BluetoothDeviceRow* self,
                                         GAsyncResult* _res_)
{
	BluetoothDeviceRowOnActivateData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static void
bluetooth_device_row_on_activate_ready (GObject* source_object,
                                        GAsyncResult* _res_,
                                        gpointer _user_data_)
{
	BluetoothDeviceRowOnActivateData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	bluetooth_device_row_on_activate_co (_data_);
}

static gboolean
bluetooth_device_row_on_activate_co (BluetoothDeviceRowOnActivateData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		case 3:
		goto _state_3;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->self->priv->_device;
	_data_->_tmp1_ = bluetooth_services_device_get_paired (_data_->_tmp0_);
	_data_->_tmp2_ = _data_->_tmp1_;
	if (!_data_->_tmp2_) {
		bluetooth_device_row_set_status (_data_->self, BLUETOOTH_DEVICE_ROW_STATUS_PAIRING);
		{
			_data_->_tmp3_ = _data_->self->priv->_device;
			_data_->_state_ = 1;
			bluetooth_services_device_pair (_data_->_tmp3_, bluetooth_device_row_on_activate_ready, _data_);
			return FALSE;
			_state_1:
			bluetooth_services_device_pair_finish (_data_->_tmp3_, _data_->_res_, &_data_->_inner_error0_);
			if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
			_data_->_tmp4_ = _data_->self->priv->_device;
			_data_->_tmp5_ = _data_->self->priv->_device;
			_data_->_tmp6_ = bluetooth_services_device_get_paired (_data_->_tmp5_);
			_data_->_tmp7_ = _data_->_tmp6_;
			bluetooth_services_device_set_trusted (_data_->_tmp4_, _data_->_tmp7_);
		}
		goto __finally0;
		__catch0_g_error:
		{
			_data_->e = _data_->_inner_error0_;
			_data_->_inner_error0_ = NULL;
			bluetooth_device_row_set_status (_data_->self, BLUETOOTH_DEVICE_ROW_STATUS_UNABLE_TO_CONNECT);
			_data_->_tmp8_ = _data_->e;
			_data_->_tmp9_ = _data_->_tmp8_->message;
			g_critical ("DeviceRow.vala:249: %s", _data_->_tmp9_);
			_g_error_free0 (_data_->e);
		}
		__finally0:
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
			g_clear_error (&_data_->_inner_error0_);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
	} else {
		_data_->_tmp10_ = _data_->self->priv->_device;
		_data_->_tmp11_ = bluetooth_services_device_get_connected (_data_->_tmp10_);
		_data_->_tmp12_ = _data_->_tmp11_;
		if (!_data_->_tmp12_) {
			bluetooth_device_row_set_status (_data_->self, BLUETOOTH_DEVICE_ROW_STATUS_CONNECTING);
			{
				_data_->_tmp13_ = _data_->self->priv->_device;
				_data_->_state_ = 2;
				bluetooth_services_device_connect (_data_->_tmp13_, bluetooth_device_row_on_activate_ready, _data_);
				return FALSE;
				_state_2:
				bluetooth_services_device_connect_finish (_data_->_tmp13_, _data_->_res_, &_data_->_inner_error0_);
				if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
					goto __catch1_g_error;
				}
			}
			goto __finally1;
			__catch1_g_error:
			{
				_data_->_vala1_e = _data_->_inner_error0_;
				_data_->_inner_error0_ = NULL;
				bluetooth_device_row_set_status (_data_->self, BLUETOOTH_DEVICE_ROW_STATUS_UNABLE_TO_CONNECT_PAIRED);
				_data_->_tmp14_ = _data_->_vala1_e;
				_data_->_tmp15_ = _data_->_tmp14_->message;
				g_critical ("DeviceRow.vala:257: %s", _data_->_tmp15_);
				_g_error_free0 (_data_->_vala1_e);
			}
			__finally1:
			if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
				g_clear_error (&_data_->_inner_error0_);
				g_object_unref (_data_->_async_result);
				return FALSE;
			}
		} else {
			bluetooth_device_row_set_status (_data_->self, BLUETOOTH_DEVICE_ROW_STATUS_DISCONNECTING);
			{
				_data_->_tmp16_ = _data_->self->priv->_device;
				_data_->_state_ = 3;
				bluetooth_services_device_disconnect (_data_->_tmp16_, bluetooth_device_row_on_activate_ready, _data_);
				return FALSE;
				_state_3:
				bluetooth_services_device_disconnect_finish (_data_->_tmp16_, _data_->_res_, &_data_->_inner_error0_);
				if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
					goto __catch2_g_error;
				}
			}
			goto __finally2;
			__catch2_g_error:
			{
				_data_->_vala2_e = _data_->_inner_error0_;
				_data_->_inner_error0_ = NULL;
				_data_->_tmp17_ = _data_->self->priv->state;
				g_object_set (_data_->_tmp17_, "icon-name", "user-busy", NULL);
				_data_->_tmp18_ = _data_->_vala2_e;
				_data_->_tmp19_ = _data_->_tmp18_->message;
				g_critical ("DeviceRow.vala:265: %s", _data_->_tmp19_);
				_g_error_free0 (_data_->_vala2_e);
			}
			__finally2:
			if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
				g_clear_error (&_data_->_inner_error0_);
				g_object_unref (_data_->_async_result);
				return FALSE;
			}
		}
	}
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
bluetooth_device_row_compute_status (BluetoothDeviceRow* self)
{
	BluetoothServicesDevice* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_device;
	_tmp1_ = bluetooth_services_device_get_paired (_tmp0_);
	_tmp2_ = _tmp1_;
	if (!_tmp2_) {
		bluetooth_device_row_set_status (self, BLUETOOTH_DEVICE_ROW_STATUS_UNPAIRED);
	} else {
		BluetoothServicesDevice* _tmp3_;
		gboolean _tmp4_;
		gboolean _tmp5_;
		_tmp3_ = self->priv->_device;
		_tmp4_ = bluetooth_services_device_get_connected (_tmp3_);
		_tmp5_ = _tmp4_;
		if (_tmp5_) {
			bluetooth_device_row_set_status (self, BLUETOOTH_DEVICE_ROW_STATUS_CONNECTED);
		} else {
			bluetooth_device_row_set_status (self, BLUETOOTH_DEVICE_ROW_STATUS_NOT_CONNECTED);
		}
	}
}

static void
bluetooth_device_row_set_status (BluetoothDeviceRow* self,
                                 BluetoothDeviceRowStatus status)
{
	GtkLabel* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	GtkImage* _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->state_label;
	_tmp1_ = bluetooth_device_row_status_to_string (status);
	_tmp2_ = _tmp1_;
	gtk_label_set_label (_tmp0_, _tmp2_);
	_g_free0 (_tmp2_);
	_tmp3_ = self->priv->state;
	gtk_widget_set_visible ((GtkWidget*) _tmp3_, TRUE);
	switch (status) {
		case BLUETOOTH_DEVICE_ROW_STATUS_UNPAIRED:
		{
			GtkButton* _tmp4_;
			GtkButton* _tmp5_;
			GtkLinkButton* _tmp6_;
			GtkImage* _tmp7_;
			GtkButton* _tmp8_;
			_tmp4_ = self->priv->connect_button;
			gtk_button_set_label (_tmp4_, _ ("Pair"));
			_tmp5_ = self->priv->connect_button;
			gtk_widget_set_sensitive ((GtkWidget*) _tmp5_, TRUE);
			_tmp6_ = self->priv->settings_button;
			gtk_widget_set_visible ((GtkWidget*) _tmp6_, FALSE);
			_tmp7_ = self->priv->state;
			gtk_widget_set_visible ((GtkWidget*) _tmp7_, FALSE);
			_tmp8_ = self->priv->forget_button;
			gtk_widget_set_visible ((GtkWidget*) _tmp8_, FALSE);
			break;
		}
		case BLUETOOTH_DEVICE_ROW_STATUS_PAIRING:
		{
			GtkButton* _tmp9_;
			GtkImage* _tmp10_;
			GtkLinkButton* _tmp11_;
			GtkButton* _tmp12_;
			_tmp9_ = self->priv->connect_button;
			gtk_widget_set_sensitive ((GtkWidget*) _tmp9_, FALSE);
			_tmp10_ = self->priv->state;
			g_object_set (_tmp10_, "icon-name", "emblem-mixed", NULL);
			_tmp11_ = self->priv->settings_button;
			gtk_widget_set_visible ((GtkWidget*) _tmp11_, FALSE);
			_tmp12_ = self->priv->forget_button;
			gtk_widget_set_visible ((GtkWidget*) _tmp12_, FALSE);
			break;
		}
		case BLUETOOTH_DEVICE_ROW_STATUS_CONNECTED:
		{
			GtkButton* _tmp13_;
			GtkButton* _tmp14_;
			GtkImage* _tmp15_;
			GtkLinkButton* _tmp16_;
			const gchar* _tmp17_;
			const gchar* _tmp18_;
			GtkButton* _tmp20_;
			GtkButton* _tmp21_;
			_tmp13_ = self->priv->connect_button;
			gtk_button_set_label (_tmp13_, _ ("Disconnect"));
			_tmp14_ = self->priv->connect_button;
			gtk_widget_set_sensitive ((GtkWidget*) _tmp14_, TRUE);
			_tmp15_ = self->priv->state;
			g_object_set (_tmp15_, "icon-name", "emblem-enabled", NULL);
			_tmp16_ = self->priv->settings_button;
			_tmp17_ = gtk_link_button_get_uri (_tmp16_);
			_tmp18_ = _tmp17_;
			if (g_strcmp0 (_tmp18_, "") != 0) {
				GtkLinkButton* _tmp19_;
				_tmp19_ = self->priv->settings_button;
				gtk_widget_set_visible ((GtkWidget*) _tmp19_, TRUE);
			}
			_tmp20_ = self->priv->forget_button;
			gtk_widget_set_sensitive ((GtkWidget*) _tmp20_, TRUE);
			_tmp21_ = self->priv->forget_button;
			gtk_widget_set_visible ((GtkWidget*) _tmp21_, TRUE);
			break;
		}
		case BLUETOOTH_DEVICE_ROW_STATUS_CONNECTING:
		{
			GtkButton* _tmp22_;
			GtkImage* _tmp23_;
			GtkLinkButton* _tmp24_;
			GtkButton* _tmp25_;
			GtkButton* _tmp26_;
			_tmp22_ = self->priv->connect_button;
			gtk_widget_set_sensitive ((GtkWidget*) _tmp22_, FALSE);
			_tmp23_ = self->priv->state;
			g_object_set (_tmp23_, "icon-name", "emblem-mixed", NULL);
			_tmp24_ = self->priv->settings_button;
			gtk_widget_set_visible ((GtkWidget*) _tmp24_, FALSE);
			_tmp25_ = self->priv->forget_button;
			gtk_widget_set_sensitive ((GtkWidget*) _tmp25_, FALSE);
			_tmp26_ = self->priv->forget_button;
			gtk_widget_set_visible ((GtkWidget*) _tmp26_, TRUE);
			break;
		}
		case BLUETOOTH_DEVICE_ROW_STATUS_DISCONNECTING:
		{
			GtkButton* _tmp27_;
			GtkImage* _tmp28_;
			GtkLinkButton* _tmp29_;
			GtkButton* _tmp30_;
			GtkButton* _tmp31_;
			_tmp27_ = self->priv->connect_button;
			gtk_widget_set_sensitive ((GtkWidget*) _tmp27_, FALSE);
			_tmp28_ = self->priv->state;
			g_object_set (_tmp28_, "icon-name", "emblem-mixed", NULL);
			_tmp29_ = self->priv->settings_button;
			gtk_widget_set_visible ((GtkWidget*) _tmp29_, FALSE);
			_tmp30_ = self->priv->forget_button;
			gtk_widget_set_sensitive ((GtkWidget*) _tmp30_, FALSE);
			_tmp31_ = self->priv->forget_button;
			gtk_widget_set_visible ((GtkWidget*) _tmp31_, TRUE);
			break;
		}
		case BLUETOOTH_DEVICE_ROW_STATUS_NOT_CONNECTED:
		{
			GtkButton* _tmp32_;
			GtkButton* _tmp33_;
			GtkImage* _tmp34_;
			GtkLinkButton* _tmp35_;
			GtkButton* _tmp36_;
			GtkButton* _tmp37_;
			_tmp32_ = self->priv->connect_button;
			gtk_button_set_label (_tmp32_, _ ("Connect"));
			_tmp33_ = self->priv->connect_button;
			gtk_widget_set_sensitive ((GtkWidget*) _tmp33_, TRUE);
			_tmp34_ = self->priv->state;
			g_object_set (_tmp34_, "icon-name", "emblem-disabled", NULL);
			_tmp35_ = self->priv->settings_button;
			gtk_widget_set_visible ((GtkWidget*) _tmp35_, FALSE);
			_tmp36_ = self->priv->forget_button;
			gtk_widget_set_sensitive ((GtkWidget*) _tmp36_, TRUE);
			_tmp37_ = self->priv->forget_button;
			gtk_widget_set_visible ((GtkWidget*) _tmp37_, TRUE);
			break;
		}
		case BLUETOOTH_DEVICE_ROW_STATUS_UNABLE_TO_CONNECT:
		{
			GtkButton* _tmp38_;
			GtkImage* _tmp39_;
			GtkLinkButton* _tmp40_;
			GtkButton* _tmp41_;
			_tmp38_ = self->priv->connect_button;
			gtk_widget_set_sensitive ((GtkWidget*) _tmp38_, TRUE);
			_tmp39_ = self->priv->state;
			g_object_set (_tmp39_, "icon-name", "emblem-error", NULL);
			_tmp40_ = self->priv->settings_button;
			gtk_widget_set_visible ((GtkWidget*) _tmp40_, FALSE);
			_tmp41_ = self->priv->forget_button;
			gtk_widget_set_visible ((GtkWidget*) _tmp41_, FALSE);
			break;
		}
		case BLUETOOTH_DEVICE_ROW_STATUS_UNABLE_TO_CONNECT_PAIRED:
		{
			GtkButton* _tmp42_;
			GtkImage* _tmp43_;
			GtkLinkButton* _tmp44_;
			GtkButton* _tmp45_;
			GtkButton* _tmp46_;
			_tmp42_ = self->priv->connect_button;
			gtk_widget_set_sensitive ((GtkWidget*) _tmp42_, TRUE);
			_tmp43_ = self->priv->state;
			g_object_set (_tmp43_, "icon-name", "emblem-error", NULL);
			_tmp44_ = self->priv->settings_button;
			gtk_widget_set_visible ((GtkWidget*) _tmp44_, FALSE);
			_tmp45_ = self->priv->forget_button;
			gtk_widget_set_sensitive ((GtkWidget*) _tmp45_, TRUE);
			_tmp46_ = self->priv->forget_button;
			gtk_widget_set_visible ((GtkWidget*) _tmp46_, TRUE);
			break;
		}
		default:
		break;
	}
	g_signal_emit (self, bluetooth_device_row_signals[BLUETOOTH_DEVICE_ROW_STATUS_CHANGED_SIGNAL], 0);
}

BluetoothServicesDevice*
bluetooth_device_row_get_device (BluetoothDeviceRow* self)
{
	BluetoothServicesDevice* result;
	BluetoothServicesDevice* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_device;
	result = _tmp0_;
	return result;
}

static void
bluetooth_device_row_set_device (BluetoothDeviceRow* self,
                                 BluetoothServicesDevice* value)
{
	BluetoothServicesDevice* old_value;
	g_return_if_fail (self != NULL);
	old_value = bluetooth_device_row_get_device (self);
	if (old_value != value) {
		BluetoothServicesDevice* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_device);
		self->priv->_device = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, bluetooth_device_row_properties[BLUETOOTH_DEVICE_ROW_DEVICE_PROPERTY]);
	}
}

static Block2Data*
block2_data_ref (Block2Data* _data2_)
{
	g_atomic_int_inc (&_data2_->_ref_count_);
	return _data2_;
}

static void
block2_data_unref (void * _userdata_)
{
	Block2Data* _data2_;
	_data2_ = (Block2Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data2_->_ref_count_)) {
		BluetoothDeviceRow* self;
		self = _data2_->self;
		_g_object_unref0 (_data2_->adapter);
		_g_object_unref0 (_data2_->label);
		_g_object_unref0 (_data2_->image);
		_g_object_unref0 (self);
		g_slice_free (Block2Data, _data2_);
	}
}

static void
_bluetooth_device_row___lambda29_ (Block2Data* _data2_,
                                   GVariant* changed,
                                   gchar** invalid)
{
	BluetoothDeviceRow* self;
	GVariant* powered = NULL;
	GVariantType* _tmp0_;
	GVariantType* _tmp1_;
	GVariant* _tmp2_;
	GVariant* _tmp3_;
	GVariant* _tmp4_;
	self = _data2_->self;
	g_return_if_fail (changed != NULL);
	_tmp0_ = g_variant_type_new ("b");
	_tmp1_ = _tmp0_;
	_tmp2_ = g_variant_lookup_value (changed, "Powered", _tmp1_);
	_tmp3_ = _tmp2_;
	_g_variant_type_free0 (_tmp1_);
	powered = _tmp3_;
	_tmp4_ = powered;
	if (_tmp4_ != NULL) {
		BluetoothServicesAdapter* _tmp5_;
		gboolean _tmp6_;
		gboolean _tmp7_;
		_tmp5_ = _data2_->adapter;
		_tmp6_ = bluetooth_services_adapter_get_powered (_tmp5_);
		_tmp7_ = _tmp6_;
		gtk_widget_set_sensitive ((GtkWidget*) self, _tmp7_);
		gtk_list_box_row_changed ((GtkListBoxRow*) self);
	}
	_g_variant_unref0 (powered);
}

static void
__bluetooth_device_row___lambda29__g_dbus_proxy_g_properties_changed (GDBusProxy* _sender,
                                                                      GVariant* changed_properties,
                                                                      gchar** invalidated_properties,
                                                                      gpointer self)
{
	_bluetooth_device_row___lambda29_ (self, changed_properties, invalidated_properties);
}

static void
_bluetooth_device_row___lambda30_ (Block2Data* _data2_,
                                   GVariant* changed,
                                   gchar** invalid)
{
	BluetoothDeviceRow* self;
	GVariant* paired = NULL;
	GVariantType* _tmp0_;
	GVariantType* _tmp1_;
	GVariant* _tmp2_;
	GVariant* _tmp3_;
	GVariant* _tmp4_;
	GVariant* connected = NULL;
	GVariantType* _tmp6_;
	GVariantType* _tmp7_;
	GVariant* _tmp8_;
	GVariant* _tmp9_;
	GVariant* _tmp10_;
	GVariant* name = NULL;
	GVariantType* _tmp11_;
	GVariantType* _tmp12_;
	GVariant* _tmp13_;
	GVariant* _tmp14_;
	GVariant* _tmp15_;
	GVariant* icon = NULL;
	GVariantType* _tmp21_;
	GVariantType* _tmp22_;
	GVariant* _tmp23_;
	GVariant* _tmp24_;
	GVariant* _tmp25_;
	self = _data2_->self;
	g_return_if_fail (changed != NULL);
	_tmp0_ = g_variant_type_new ("b");
	_tmp1_ = _tmp0_;
	_tmp2_ = g_variant_lookup_value (changed, "Paired", _tmp1_);
	_tmp3_ = _tmp2_;
	_g_variant_type_free0 (_tmp1_);
	paired = _tmp3_;
	_tmp4_ = paired;
	if (_tmp4_ != NULL) {
		BluetoothServicesDevice* _tmp5_;
		bluetooth_device_row_compute_status (self);
		_tmp5_ = self->priv->_device;
		bluetooth_services_device_connect (_tmp5_, NULL, NULL);
		gtk_list_box_row_changed ((GtkListBoxRow*) self);
	}
	_tmp6_ = g_variant_type_new ("b");
	_tmp7_ = _tmp6_;
	_tmp8_ = g_variant_lookup_value (changed, "Connected", _tmp7_);
	_tmp9_ = _tmp8_;
	_g_variant_type_free0 (_tmp7_);
	connected = _tmp9_;
	_tmp10_ = connected;
	if (_tmp10_ != NULL) {
		bluetooth_device_row_compute_status (self);
		gtk_list_box_row_changed ((GtkListBoxRow*) self);
	}
	_tmp11_ = g_variant_type_new ("s");
	_tmp12_ = _tmp11_;
	_tmp13_ = g_variant_lookup_value (changed, "Name", _tmp12_);
	_tmp14_ = _tmp13_;
	_g_variant_type_free0 (_tmp12_);
	name = _tmp14_;
	_tmp15_ = name;
	if (_tmp15_ != NULL) {
		GtkLabel* _tmp16_;
		BluetoothServicesDevice* _tmp17_;
		gchar* _tmp18_;
		gchar* _tmp19_;
		gchar* _tmp20_;
		_tmp16_ = _data2_->label;
		_tmp17_ = self->priv->_device;
		_tmp18_ = bluetooth_services_device_get_name (_tmp17_);
		_tmp19_ = _tmp18_;
		_tmp20_ = _tmp19_;
		gtk_label_set_label (_tmp16_, _tmp20_);
		_g_free0 (_tmp20_);
	}
	_tmp21_ = g_variant_type_new ("s");
	_tmp22_ = _tmp21_;
	_tmp23_ = g_variant_lookup_value (changed, "Icon", _tmp22_);
	_tmp24_ = _tmp23_;
	_g_variant_type_free0 (_tmp22_);
	icon = _tmp24_;
	_tmp25_ = icon;
	if (_tmp25_ != NULL) {
		gchar* _tmp26_ = NULL;
		BluetoothServicesDevice* _tmp27_;
		gchar* _tmp28_;
		gchar* _tmp29_;
		GtkImage* _tmp31_;
		_tmp27_ = self->priv->_device;
		_tmp28_ = bluetooth_services_device_get_icon (_tmp27_);
		_tmp29_ = _tmp28_;
		_tmp26_ = _tmp29_;
		if (_tmp26_ == NULL) {
			gchar* _tmp30_;
			_tmp30_ = g_strdup ("bluetooth");
			_g_free0 (_tmp26_);
			_tmp26_ = _tmp30_;
		}
		_tmp31_ = _data2_->image;
		g_object_set (_tmp31_, "icon-name", _tmp26_, NULL);
		_g_free0 (_tmp26_);
	}
	_g_variant_unref0 (icon);
	_g_variant_unref0 (name);
	_g_variant_unref0 (connected);
	_g_variant_unref0 (paired);
}

static void
__bluetooth_device_row___lambda30__g_dbus_proxy_g_properties_changed (GDBusProxy* _sender,
                                                                      GVariant* changed_properties,
                                                                      gchar** invalidated_properties,
                                                                      gpointer self)
{
	_bluetooth_device_row___lambda30_ (self, changed_properties, invalidated_properties);
}

static void
_bluetooth_device_row___lambda31_ (BluetoothDeviceRow* self)
{
	bluetooth_device_row_on_activate (self, NULL, NULL);
}

static void
__bluetooth_device_row___lambda31__gtk_button_clicked (GtkButton* _sender,
                                                       gpointer self)
{
	_bluetooth_device_row___lambda31_ ((BluetoothDeviceRow*) self);
}

static void
_bluetooth_device_row___lambda32_ (Block2Data* _data2_)
{
	BluetoothDeviceRow* self;
	GError* _inner_error0_ = NULL;
	self = _data2_->self;
	{
		BluetoothServicesAdapter* _tmp0_;
		BluetoothServicesDevice* _tmp1_;
		gchar* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_;
		char* _tmp5_;
		char* _tmp6_;
		_tmp0_ = _data2_->adapter;
		_tmp1_ = self->priv->_device;
		g_object_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, g_dbus_proxy_get_type (), GDBusProxy), "g-object-path", &_tmp2_, NULL);
		_tmp3_ = _tmp2_;
		_tmp4_ = _tmp3_;
		_tmp5_ = g_strdup (_tmp4_);
		_tmp6_ = _tmp5_;
		bluetooth_services_adapter_remove_device (_tmp0_, _tmp6_, &_inner_error0_);
		_g_free0 (_tmp6_);
		_g_free0 (_tmp4_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp7_;
		const gchar* _tmp8_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp7_ = e;
		_tmp8_ = _tmp7_->message;
		g_debug ("DeviceRow.vala:234: Forget bluetooth device failed: %s", _tmp8_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
__bluetooth_device_row___lambda32__gtk_button_clicked (GtkButton* _sender,
                                                       gpointer self)
{
	_bluetooth_device_row___lambda32_ (self);
}

static GObject *
bluetooth_device_row_constructor (GType type,
                                  guint n_construct_properties,
                                  GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	BluetoothDeviceRow * self;
	Block2Data* _data2_;
	gchar* _tmp0_ = NULL;
	BluetoothServicesDevice* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	GtkImage* _tmp5_ = NULL;
	GtkImage* _tmp6_;
	GtkImage* _tmp7_;
	GtkImage* _tmp8_;
	GtkLabel* _tmp9_ = NULL;
	GtkLabel* _tmp10_;
	GtkOverlay* overlay = NULL;
	GtkImage* _tmp11_;
	GtkWidget* _tmp12_;
	BluetoothServicesDevice* _tmp13_;
	gchar* _tmp14_;
	gchar* _tmp15_;
	GtkOverlay* _tmp16_ = NULL;
	GtkOverlay* _tmp17_;
	GtkImage* _tmp18_;
	gchar* device_name = NULL;
	BluetoothServicesDevice* _tmp19_;
	gchar* _tmp20_;
	gchar* _tmp21_;
	const gchar* _tmp22_;
	const gchar* _tmp47_;
	GtkLabel* _tmp48_;
	GtkLabel* _tmp49_;
	GtkLabel* _tmp50_;
	GtkLabel* _tmp51_;
	GtkImage* _tmp52_;
	GtkLinkButton* _tmp53_ = NULL;
	gchar* _tmp54_;
	GtkButton* _tmp55_ = NULL;
	GtkButton* _tmp56_ = NULL;
	GtkSizeGroup* _tmp57_;
	GtkButton* _tmp58_;
	GtkGrid* grid = NULL;
	GtkGrid* _tmp59_ = NULL;
	GtkGrid* _tmp60_;
	GtkOverlay* _tmp61_;
	GtkGrid* _tmp62_;
	GtkLabel* _tmp63_;
	GtkGrid* _tmp64_;
	GtkLabel* _tmp65_;
	GtkGrid* _tmp66_;
	GtkLinkButton* _tmp67_;
	GtkGrid* _tmp68_;
	GtkButton* _tmp69_;
	GtkGrid* _tmp70_;
	GtkButton* _tmp71_;
	GtkGrid* _tmp72_;
	BluetoothServicesDevice* _tmp73_;
	gchar* _tmp74_;
	gchar* _tmp75_;
	gchar* _tmp76_;
	GQuark _tmp78_ = 0U;
	static GQuark _tmp77_label0 = 0;
	static GQuark _tmp77_label1 = 0;
	static GQuark _tmp77_label2 = 0;
	static GQuark _tmp77_label3 = 0;
	static GQuark _tmp77_label4 = 0;
	static GQuark _tmp77_label5 = 0;
	static GQuark _tmp77_label6 = 0;
	BluetoothServicesObjectManager* _tmp89_;
	BluetoothServicesDevice* _tmp90_;
	char* _tmp91_;
	char* _tmp92_;
	char* _tmp93_;
	BluetoothServicesAdapter* _tmp94_;
	BluetoothServicesAdapter* _tmp95_;
	BluetoothServicesAdapter* _tmp96_;
	gboolean _tmp97_;
	gboolean _tmp98_;
	BluetoothServicesAdapter* _tmp99_;
	BluetoothServicesDevice* _tmp100_;
	GtkButton* _tmp101_;
	GtkButton* _tmp102_;
	parent_class = G_OBJECT_CLASS (bluetooth_device_row_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BLUETOOTH_TYPE_DEVICE_ROW, BluetoothDeviceRow);
	_data2_ = g_slice_new0 (Block2Data);
	_data2_->_ref_count_ = 1;
	_data2_->self = g_object_ref (self);
	_tmp1_ = self->priv->_device;
	_tmp2_ = bluetooth_services_device_get_icon (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp0_ = _tmp3_;
	if (_tmp0_ == NULL) {
		gchar* _tmp4_;
		_tmp4_ = g_strdup ("bluetooth");
		_g_free0 (_tmp0_);
		_tmp0_ = _tmp4_;
	}
	_tmp5_ = (GtkImage*) gtk_image_new_from_icon_name (_tmp0_);
	gtk_image_set_pixel_size (_tmp5_, 32);
	g_object_ref_sink (_tmp5_);
	_data2_->image = _tmp5_;
	_tmp6_ = (GtkImage*) gtk_image_new_from_icon_name ("emblem-disabled");
	g_object_ref_sink (_tmp6_);
	_g_object_unref0 (self->priv->state);
	self->priv->state = _tmp6_;
	_tmp7_ = self->priv->state;
	gtk_widget_set_halign ((GtkWidget*) _tmp7_, GTK_ALIGN_END);
	_tmp8_ = self->priv->state;
	gtk_widget_set_valign ((GtkWidget*) _tmp8_, GTK_ALIGN_END);
	_tmp9_ = (GtkLabel*) gtk_label_new (NULL);
	gtk_label_set_xalign (_tmp9_, (gfloat) 0);
	g_object_ref_sink (_tmp9_);
	_g_object_unref0 (self->priv->state_label);
	self->priv->state_label = _tmp9_;
	_tmp10_ = self->priv->state_label;
	gtk_widget_add_css_class ((GtkWidget*) _tmp10_, GRANITE_STYLE_CLASS_SMALL_LABEL);
	_tmp11_ = _data2_->image;
	_tmp12_ = _g_object_ref0 ((GtkWidget*) _tmp11_);
	_tmp13_ = self->priv->_device;
	_tmp14_ = bluetooth_services_device_get_address (_tmp13_);
	_tmp15_ = _tmp14_;
	_tmp16_ = (GtkOverlay*) gtk_overlay_new ();
	gtk_overlay_set_child (_tmp16_, _tmp12_);
	_g_object_unref0 (_tmp12_);
	gtk_widget_set_tooltip_text ((GtkWidget*) _tmp16_, _tmp15_);
	_g_free0 (_tmp15_);
	g_object_ref_sink (_tmp16_);
	overlay = _tmp16_;
	_tmp17_ = overlay;
	_tmp18_ = self->priv->state;
	gtk_overlay_add_overlay (_tmp17_, (GtkWidget*) _tmp18_);
	_tmp19_ = self->priv->_device;
	_tmp20_ = bluetooth_services_device_get_name (_tmp19_);
	_tmp21_ = _tmp20_;
	device_name = _tmp21_;
	_tmp22_ = device_name;
	if (_tmp22_ == NULL) {
		BluetoothServicesDevice* _tmp23_;
		gchar* _tmp24_;
		gchar* _tmp25_;
		gchar* _tmp26_;
		gboolean _tmp27_;
		_tmp23_ = self->priv->_device;
		_tmp24_ = bluetooth_services_device_get_icon (_tmp23_);
		_tmp25_ = _tmp24_;
		_tmp26_ = _tmp25_;
		_tmp27_ = _tmp26_ != NULL;
		_g_free0 (_tmp26_);
		if (_tmp27_) {
			BluetoothServicesDevice* _tmp28_;
			gchar* _tmp29_;
			gchar* _tmp30_;
			gchar* _tmp31_;
			GQuark _tmp33_ = 0U;
			static GQuark _tmp32_label0 = 0;
			static GQuark _tmp32_label1 = 0;
			static GQuark _tmp32_label2 = 0;
			static GQuark _tmp32_label3 = 0;
			static GQuark _tmp32_label4 = 0;
			static GQuark _tmp32_label5 = 0;
			static GQuark _tmp32_label6 = 0;
			_tmp28_ = self->priv->_device;
			_tmp29_ = bluetooth_services_device_get_icon (_tmp28_);
			_tmp30_ = _tmp29_;
			_tmp31_ = _tmp30_;
			_tmp33_ = (NULL == _tmp31_) ? 0 : g_quark_from_string (_tmp31_);
			g_free (_tmp31_);
			if (_tmp33_ == ((0 != _tmp32_label0) ? _tmp32_label0 : (_tmp32_label0 = g_quark_from_static_string ("audio-card")))) {
				switch (0) {
					default:
					{
						gchar* _tmp34_;
						_tmp34_ = g_strdup (_ ("Speaker"));
						_g_free0 (device_name);
						device_name = _tmp34_;
						break;
					}
				}
			} else if (_tmp33_ == ((0 != _tmp32_label1) ? _tmp32_label1 : (_tmp32_label1 = g_quark_from_static_string ("input-gaming")))) {
				switch (0) {
					default:
					{
						gchar* _tmp35_;
						_tmp35_ = g_strdup (_ ("Controller"));
						_g_free0 (device_name);
						device_name = _tmp35_;
						break;
					}
				}
			} else if (_tmp33_ == ((0 != _tmp32_label2) ? _tmp32_label2 : (_tmp32_label2 = g_quark_from_static_string ("input-keyboard")))) {
				switch (0) {
					default:
					{
						gchar* _tmp36_;
						_tmp36_ = g_strdup (_ ("Keyboard"));
						_g_free0 (device_name);
						device_name = _tmp36_;
						break;
					}
				}
			} else if (_tmp33_ == ((0 != _tmp32_label3) ? _tmp32_label3 : (_tmp32_label3 = g_quark_from_static_string ("input-mouse")))) {
				switch (0) {
					default:
					{
						gchar* _tmp37_;
						_tmp37_ = g_strdup (_ ("Mouse"));
						_g_free0 (device_name);
						device_name = _tmp37_;
						break;
					}
				}
			} else if (_tmp33_ == ((0 != _tmp32_label4) ? _tmp32_label4 : (_tmp32_label4 = g_quark_from_static_string ("input-tablet")))) {
				switch (0) {
					default:
					{
						gchar* _tmp38_;
						_tmp38_ = g_strdup (_ ("Tablet"));
						_g_free0 (device_name);
						device_name = _tmp38_;
						break;
					}
				}
			} else if (_tmp33_ == ((0 != _tmp32_label5) ? _tmp32_label5 : (_tmp32_label5 = g_quark_from_static_string ("input-touchpad")))) {
				switch (0) {
					default:
					{
						gchar* _tmp39_;
						_tmp39_ = g_strdup (_ ("Touchpad"));
						_g_free0 (device_name);
						device_name = _tmp39_;
						break;
					}
				}
			} else if (_tmp33_ == ((0 != _tmp32_label6) ? _tmp32_label6 : (_tmp32_label6 = g_quark_from_static_string ("phone")))) {
				switch (0) {
					default:
					{
						gchar* _tmp40_;
						_tmp40_ = g_strdup (_ ("Phone"));
						_g_free0 (device_name);
						device_name = _tmp40_;
						break;
					}
				}
			} else {
				switch (0) {
					default:
					{
						BluetoothServicesDevice* _tmp41_;
						gchar* _tmp42_;
						gchar* _tmp43_;
						_tmp41_ = self->priv->_device;
						_tmp42_ = bluetooth_services_device_get_address (_tmp41_);
						_tmp43_ = _tmp42_;
						_g_free0 (device_name);
						device_name = _tmp43_;
					}
				}
			}
		} else {
			BluetoothServicesDevice* _tmp44_;
			gchar* _tmp45_;
			gchar* _tmp46_;
			_tmp44_ = self->priv->_device;
			_tmp45_ = bluetooth_services_device_get_address (_tmp44_);
			_tmp46_ = _tmp45_;
			_g_free0 (device_name);
			device_name = _tmp46_;
		}
	}
	_tmp47_ = device_name;
	_tmp48_ = (GtkLabel*) gtk_label_new (_tmp47_);
	g_object_ref_sink (_tmp48_);
	_data2_->label = _tmp48_;
	_tmp49_ = _data2_->label;
	gtk_label_set_ellipsize (_tmp49_, PANGO_ELLIPSIZE_END);
	_tmp50_ = _data2_->label;
	gtk_widget_set_hexpand ((GtkWidget*) _tmp50_, TRUE);
	_tmp51_ = _data2_->label;
	gtk_label_set_xalign (_tmp51_, (gfloat) 0);
	_tmp52_ = (GtkImage*) gtk_image_new_from_icon_name ("view-more-horizontal-symbolic");
	g_object_ref_sink (_tmp52_);
	_tmp53_ = (GtkLinkButton*) gtk_link_button_new ("");
	gtk_button_set_child ((GtkButton*) _tmp53_, (GtkWidget*) _tmp52_);
	_g_object_unref0 (_tmp52_);
	gtk_widget_set_margin_end ((GtkWidget*) _tmp53_, 3);
	gtk_widget_set_valign ((GtkWidget*) _tmp53_, GTK_ALIGN_CENTER);
	gtk_widget_set_visible ((GtkWidget*) _tmp53_, FALSE);
	g_object_ref_sink (_tmp53_);
	_g_object_unref0 (self->priv->settings_button);
	self->priv->settings_button = _tmp53_;
	_tmp54_ = g_strdup (_ ("Forget this device"));
	_tmp55_ = (GtkButton*) gtk_button_new_from_icon_name ("edit-delete-symbolic");
	gtk_button_set_has_frame (_tmp55_, FALSE);
	gtk_widget_set_margin_end ((GtkWidget*) _tmp55_, 3);
	gtk_widget_set_tooltip_text ((GtkWidget*) _tmp55_, _tmp54_);
	_g_free0 (_tmp54_);
	gtk_widget_set_valign ((GtkWidget*) _tmp55_, GTK_ALIGN_CENTER);
	gtk_widget_set_visible ((GtkWidget*) _tmp55_, FALSE);
	g_object_ref_sink (_tmp55_);
	_g_object_unref0 (self->priv->forget_button);
	self->priv->forget_button = _tmp55_;
	_tmp56_ = (GtkButton*) gtk_button_new ();
	gtk_widget_set_valign ((GtkWidget*) _tmp56_, GTK_ALIGN_CENTER);
	g_object_ref_sink (_tmp56_);
	_g_object_unref0 (self->priv->connect_button);
	self->priv->connect_button = _tmp56_;
	_tmp57_ = bluetooth_device_row_size_group;
	_tmp58_ = self->priv->connect_button;
	gtk_size_group_add_widget (_tmp57_, (GtkWidget*) _tmp58_);
	_tmp59_ = (GtkGrid*) gtk_grid_new ();
	gtk_grid_set_column_spacing (_tmp59_, 6);
	g_object_ref_sink (_tmp59_);
	grid = _tmp59_;
	_tmp60_ = grid;
	_tmp61_ = overlay;
	gtk_grid_attach (_tmp60_, (GtkWidget*) _tmp61_, 0, 0, 1, 2);
	_tmp62_ = grid;
	_tmp63_ = _data2_->label;
	gtk_grid_attach (_tmp62_, (GtkWidget*) _tmp63_, 1, 0, 1, 1);
	_tmp64_ = grid;
	_tmp65_ = self->priv->state_label;
	gtk_grid_attach (_tmp64_, (GtkWidget*) _tmp65_, 1, 1, 1, 1);
	_tmp66_ = grid;
	_tmp67_ = self->priv->settings_button;
	gtk_grid_attach (_tmp66_, (GtkWidget*) _tmp67_, 2, 0, 1, 2);
	_tmp68_ = grid;
	_tmp69_ = self->priv->forget_button;
	gtk_grid_attach (_tmp68_, (GtkWidget*) _tmp69_, 3, 0, 1, 2);
	_tmp70_ = grid;
	_tmp71_ = self->priv->connect_button;
	gtk_grid_attach (_tmp70_, (GtkWidget*) _tmp71_, 4, 0, 1, 2);
	_tmp72_ = grid;
	gtk_list_box_row_set_child ((GtkListBoxRow*) self, (GtkWidget*) _tmp72_);
	_tmp73_ = self->priv->_device;
	_tmp74_ = bluetooth_services_device_get_icon (_tmp73_);
	_tmp75_ = _tmp74_;
	_tmp76_ = _tmp75_;
	_tmp78_ = (NULL == _tmp76_) ? 0 : g_quark_from_string (_tmp76_);
	g_free (_tmp76_);
	if (((_tmp78_ == ((0 != _tmp77_label0) ? _tmp77_label0 : (_tmp77_label0 = g_quark_from_static_string ("audio-card")))) || (_tmp78_ == ((0 != _tmp77_label1) ? _tmp77_label1 : (_tmp77_label1 = g_quark_from_static_string ("audio-headphones"))))) || (_tmp78_ == ((0 != _tmp77_label2) ? _tmp77_label2 : (_tmp77_label2 = g_quark_from_static_string ("audio-headset"))))) {
		switch (0) {
			default:
			{
				GtkLinkButton* _tmp79_;
				GtkLinkButton* _tmp80_;
				_tmp79_ = self->priv->settings_button;
				gtk_link_button_set_uri (_tmp79_, "settings://sound");
				_tmp80_ = self->priv->settings_button;
				gtk_widget_set_tooltip_text ((GtkWidget*) _tmp80_, _ ("Sound Settings"));
				break;
			}
		}
	} else if ((_tmp78_ == ((0 != _tmp77_label3) ? _tmp77_label3 : (_tmp77_label3 = g_quark_from_static_string ("input-gaming")))) || (_tmp78_ == ((0 != _tmp77_label4) ? _tmp77_label4 : (_tmp77_label4 = g_quark_from_static_string ("input-keyboard"))))) {
		switch (0) {
			default:
			{
				GtkLinkButton* _tmp81_;
				GtkLinkButton* _tmp82_;
				_tmp81_ = self->priv->settings_button;
				gtk_link_button_set_uri (_tmp81_, "settings://input/keyboard");
				_tmp82_ = self->priv->settings_button;
				gtk_widget_set_tooltip_text ((GtkWidget*) _tmp82_, _ ("Keyboard Settings"));
				break;
			}
		}
	} else if (_tmp78_ == ((0 != _tmp77_label5) ? _tmp77_label5 : (_tmp77_label5 = g_quark_from_static_string ("input-mouse")))) {
		switch (0) {
			default:
			{
				GtkLinkButton* _tmp83_;
				GtkLinkButton* _tmp84_;
				_tmp83_ = self->priv->settings_button;
				gtk_link_button_set_uri (_tmp83_, "settings://input/pointer/mouse");
				_tmp84_ = self->priv->settings_button;
				gtk_widget_set_tooltip_text ((GtkWidget*) _tmp84_, _ ("Mouse & Touchpad Settings"));
				break;
			}
		}
	} else if (_tmp78_ == ((0 != _tmp77_label6) ? _tmp77_label6 : (_tmp77_label6 = g_quark_from_static_string ("printer")))) {
		switch (0) {
			default:
			{
				GtkLinkButton* _tmp85_;
				GtkLinkButton* _tmp86_;
				_tmp85_ = self->priv->settings_button;
				gtk_link_button_set_uri (_tmp85_, "settings://printer");
				_tmp86_ = self->priv->settings_button;
				gtk_widget_set_tooltip_text ((GtkWidget*) _tmp86_, _ ("Printer Settings"));
				break;
			}
		}
	} else {
		switch (0) {
			default:
			{
				GtkLinkButton* _tmp87_;
				GtkLinkButton* _tmp88_;
				_tmp87_ = self->priv->settings_button;
				gtk_link_button_set_uri (_tmp87_, "");
				_tmp88_ = self->priv->settings_button;
				gtk_widget_set_tooltip_text ((GtkWidget*) _tmp88_, NULL);
				break;
			}
		}
	}
	_tmp89_ = bluetooth_services_object_manager_get_default ();
	_tmp90_ = self->priv->_device;
	_tmp91_ = bluetooth_services_device_get_adapter (_tmp90_);
	_tmp92_ = _tmp91_;
	_tmp93_ = _tmp92_;
	_tmp94_ = bluetooth_services_object_manager_get_adapter_from_path (_tmp89_, (const gchar*) _tmp93_);
	_tmp95_ = _tmp94_;
	_g_free0 (_tmp93_);
	_data2_->adapter = _tmp95_;
	bluetooth_device_row_compute_status (self);
	_tmp96_ = _data2_->adapter;
	_tmp97_ = bluetooth_services_adapter_get_powered (_tmp96_);
	_tmp98_ = _tmp97_;
	gtk_widget_set_sensitive ((GtkWidget*) self, _tmp98_);
	_tmp99_ = _data2_->adapter;
	g_signal_connect_data (G_TYPE_CHECK_INSTANCE_CAST (_tmp99_, g_dbus_proxy_get_type (), GDBusProxy), "g-properties-changed", (GCallback) __bluetooth_device_row___lambda29__g_dbus_proxy_g_properties_changed, block2_data_ref (_data2_), (GClosureNotify) block2_data_unref, 0);
	_tmp100_ = self->priv->_device;
	g_signal_connect_data (G_TYPE_CHECK_INSTANCE_CAST (_tmp100_, g_dbus_proxy_get_type (), GDBusProxy), "g-properties-changed", (GCallback) __bluetooth_device_row___lambda30__g_dbus_proxy_g_properties_changed, block2_data_ref (_data2_), (GClosureNotify) block2_data_unref, 0);
	_tmp101_ = self->priv->connect_button;
	g_signal_connect_object (_tmp101_, "clicked", (GCallback) __bluetooth_device_row___lambda31__gtk_button_clicked, self, 0);
	_tmp102_ = self->priv->forget_button;
	g_signal_connect_data (_tmp102_, "clicked", (GCallback) __bluetooth_device_row___lambda32__gtk_button_clicked, block2_data_ref (_data2_), (GClosureNotify) block2_data_unref, 0);
	_g_object_unref0 (grid);
	_g_free0 (device_name);
	_g_object_unref0 (overlay);
	_g_free0 (_tmp0_);
	block2_data_unref (_data2_);
	_data2_ = NULL;
	return obj;
}

static void
bluetooth_device_row_class_init (BluetoothDeviceRowClass * klass,
                                 gpointer klass_data)
{
	GtkSizeGroup* _tmp0_;
	bluetooth_device_row_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &BluetoothDeviceRow_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_bluetooth_device_row_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_bluetooth_device_row_set_property;
	G_OBJECT_CLASS (klass)->constructor = bluetooth_device_row_constructor;
	G_OBJECT_CLASS (klass)->finalize = bluetooth_device_row_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), BLUETOOTH_DEVICE_ROW_DEVICE_PROPERTY, bluetooth_device_row_properties[BLUETOOTH_DEVICE_ROW_DEVICE_PROPERTY] = g_param_spec_object ("device", "device", "device", BLUETOOTH_SERVICES_TYPE_DEVICE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	bluetooth_device_row_signals[BLUETOOTH_DEVICE_ROW_STATUS_CHANGED_SIGNAL] = g_signal_new ("status-changed", BLUETOOTH_TYPE_DEVICE_ROW, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	_tmp0_ = gtk_size_group_new (GTK_SIZE_GROUP_HORIZONTAL);
	_g_object_unref0 (bluetooth_device_row_size_group);
	bluetooth_device_row_size_group = _tmp0_;
}

static void
bluetooth_device_row_instance_init (BluetoothDeviceRow * self,
                                    gpointer klass)
{
	self->priv = bluetooth_device_row_get_instance_private (self);
}

static void
bluetooth_device_row_finalize (GObject * obj)
{
	BluetoothDeviceRow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BLUETOOTH_TYPE_DEVICE_ROW, BluetoothDeviceRow);
	_g_object_unref0 (self->priv->_device);
	_g_object_unref0 (self->priv->connect_button);
	_g_object_unref0 (self->priv->forget_button);
	_g_object_unref0 (self->priv->state);
	_g_object_unref0 (self->priv->state_label);
	_g_object_unref0 (self->priv->settings_button);
	G_OBJECT_CLASS (bluetooth_device_row_parent_class)->finalize (obj);
}

static GType
bluetooth_device_row_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (BluetoothDeviceRowClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) bluetooth_device_row_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BluetoothDeviceRow), 0, (GInstanceInitFunc) bluetooth_device_row_instance_init, NULL };
	GType bluetooth_device_row_type_id;
	bluetooth_device_row_type_id = g_type_register_static (gtk_list_box_row_get_type (), "BluetoothDeviceRow", &g_define_type_info, 0);
	BluetoothDeviceRow_private_offset = g_type_add_instance_private (bluetooth_device_row_type_id, sizeof (BluetoothDeviceRowPrivate));
	return bluetooth_device_row_type_id;
}

GType
bluetooth_device_row_get_type (void)
{
	static volatile gsize bluetooth_device_row_type_id__once = 0;
	if (g_once_init_enter (&bluetooth_device_row_type_id__once)) {
		GType bluetooth_device_row_type_id;
		bluetooth_device_row_type_id = bluetooth_device_row_get_type_once ();
		g_once_init_leave (&bluetooth_device_row_type_id__once, bluetooth_device_row_type_id);
	}
	return bluetooth_device_row_type_id__once;
}

static void
_vala_bluetooth_device_row_get_property (GObject * object,
                                         guint property_id,
                                         GValue * value,
                                         GParamSpec * pspec)
{
	BluetoothDeviceRow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, BLUETOOTH_TYPE_DEVICE_ROW, BluetoothDeviceRow);
	switch (property_id) {
		case BLUETOOTH_DEVICE_ROW_DEVICE_PROPERTY:
		g_value_set_object (value, bluetooth_device_row_get_device (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_bluetooth_device_row_set_property (GObject * object,
                                         guint property_id,
                                         const GValue * value,
                                         GParamSpec * pspec)
{
	BluetoothDeviceRow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, BLUETOOTH_TYPE_DEVICE_ROW, BluetoothDeviceRow);
	switch (property_id) {
		case BLUETOOTH_DEVICE_ROW_DEVICE_PROPERTY:
		bluetooth_device_row_set_device (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

