/* Touchpad.c generated by valac 0.56.18, the Vala compiler
 * generated from Touchpad.vala, do not modify */

/*
 * SPDX-License-Identifier: GPL-2.0-or-later
 * SPDX-FileCopyrightText: 2011-2024 elementary, Inc. (https://elementary.io)
 */

#include "mouse-touchpad.h"
#include <gio/gio.h>
#include <gtk/gtk.h>
#include <glib-object.h>
#include <glib.h>
#include <glib/gi18n-lib.h>
#include <stdlib.h>
#include <string.h>
#include <granite-7.h>
#include <switchboard.h>
#include <float.h>
#include <math.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	MOUSE_TOUCHPAD_TOUCHPAD_VIEW_0_PROPERTY,
	MOUSE_TOUCHPAD_TOUCHPAD_VIEW_NUM_PROPERTIES
};
static GParamSpec* mouse_touchpad_touchpad_view_properties[MOUSE_TOUCHPAD_TOUCHPAD_VIEW_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _Block5Data Block5Data;
#define _g_free0(var) (var = (g_free (var), NULL))

struct _MouseTouchpadTouchpadViewPrivate {
	GSettings* glib_settings;
	GtkCheckButton* areas_click_method_radio;
	GtkCheckButton* multitouch_click_method_radio;
	GtkCheckButton* other_click_method_radio;
};

struct _Block5Data {
	int _ref_count_;
	MouseTouchpadTouchpadView* self;
	GtkSwitch* natural_scrolling_switch;
	GraniteHeaderLabel* natural_scrolling_header;
	GtkCheckButton* disabled_scroll_radio;
};

static gint MouseTouchpadTouchpadView_private_offset;
static gpointer mouse_touchpad_touchpad_view_parent_class = NULL;

static void mouse_touchpad_touchpad_view_update_click_method (MouseTouchpadTouchpadView* self);
static GObject * mouse_touchpad_touchpad_view_constructor (GType type,
                                                    guint n_construct_properties,
                                                    GObjectConstructParam * construct_properties);
static Block5Data* block5_data_ref (Block5Data* _data5_);
static void block5_data_unref (void * _userdata_);
static gboolean _mouse_touchpad_touchpad_view___lambda15_ (GValue* value,
                                                    GVariant* variant,
                                                    void* user_data);
static gboolean __mouse_touchpad_touchpad_view___lambda15__gsettings_bind_get_mapping (GValue* value,
                                                                                GVariant* variant,
                                                                                void* user_data);
static GVariant* _mouse_touchpad_touchpad_view___lambda16_ (GValue* value,
                                                     const GVariantType* expected_type,
                                                     void* user_data);
static GVariant* __mouse_touchpad_touchpad_view___lambda16__gsettings_bind_set_mapping (GValue* value,
                                                                                 const GVariantType* expected_type,
                                                                                 void* user_data);
static void _mouse_touchpad_touchpad_view_update_click_method_g_settings_changed (GSettings* _sender,
                                                                           const gchar* key,
                                                                           gpointer self);
static void _mouse_touchpad_touchpad_view___lambda17_ (MouseTouchpadTouchpadView* self);
static void __mouse_touchpad_touchpad_view___lambda17__gtk_check_button_toggled (GtkCheckButton* _sender,
                                                                          gpointer self);
static void _mouse_touchpad_touchpad_view___lambda18_ (MouseTouchpadTouchpadView* self);
static void __mouse_touchpad_touchpad_view___lambda18__gtk_check_button_toggled (GtkCheckButton* _sender,
                                                                          gpointer self);
static void _mouse_touchpad_touchpad_view___lambda19_ (Block5Data* _data5_);
static void __mouse_touchpad_touchpad_view___lambda19__gtk_check_button_toggled (GtkCheckButton* _sender,
                                                                          gpointer self);
static void _mouse_touchpad_touchpad_view___lambda20_ (MouseTouchpadTouchpadView* self);
static void __mouse_touchpad_touchpad_view___lambda20__gtk_check_button_toggled (GtkCheckButton* _sender,
                                                                          gpointer self);
static void _mouse_touchpad_touchpad_view___lambda21_ (MouseTouchpadTouchpadView* self);
static void __mouse_touchpad_touchpad_view___lambda21__gtk_check_button_toggled (GtkCheckButton* _sender,
                                                                          gpointer self);
static void mouse_touchpad_touchpad_view_finalize (GObject * obj);
static GType mouse_touchpad_touchpad_view_get_type_once (void);

static inline gpointer
mouse_touchpad_touchpad_view_get_instance_private (MouseTouchpadTouchpadView* self)
{
	return G_STRUCT_MEMBER_P (self, MouseTouchpadTouchpadView_private_offset);
}

MouseTouchpadTouchpadView*
mouse_touchpad_touchpad_view_construct (GType object_type)
{
	MouseTouchpadTouchpadView * self = NULL;
	GThemedIcon* _tmp0_;
	GThemedIcon* _tmp1_;
	_tmp0_ = (GThemedIcon*) g_themed_icon_new ("input-touchpad");
	_tmp1_ = _tmp0_;
	self = (MouseTouchpadTouchpadView*) g_object_new (object_type, "icon", _tmp1_, "title", _ ("Touchpad"), NULL);
	_g_object_unref0 (_tmp1_);
	return self;
}

MouseTouchpadTouchpadView*
mouse_touchpad_touchpad_view_new (void)
{
	return mouse_touchpad_touchpad_view_construct (MOUSE_TOUCHPAD_TYPE_TOUCHPAD_VIEW);
}

static void
mouse_touchpad_touchpad_view_update_click_method (MouseTouchpadTouchpadView* self)
{
	GSettings* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	GQuark _tmp4_ = 0U;
	static GQuark _tmp3_label0 = 0;
	static GQuark _tmp3_label1 = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->glib_settings;
	_tmp1_ = g_settings_get_string (_tmp0_, "click-method");
	_tmp2_ = _tmp1_;
	_tmp4_ = (NULL == _tmp2_) ? 0 : g_quark_from_string (_tmp2_);
	g_free (_tmp2_);
	if (_tmp4_ == ((0 != _tmp3_label0) ? _tmp3_label0 : (_tmp3_label0 = g_quark_from_static_string ("fingers")))) {
		switch (0) {
			default:
			{
				GtkCheckButton* _tmp5_;
				_tmp5_ = self->priv->multitouch_click_method_radio;
				gtk_check_button_set_active (_tmp5_, TRUE);
				break;
			}
		}
	} else if (_tmp4_ == ((0 != _tmp3_label1) ? _tmp3_label1 : (_tmp3_label1 = g_quark_from_static_string ("areas")))) {
		switch (0) {
			default:
			{
				GtkCheckButton* _tmp6_;
				_tmp6_ = self->priv->areas_click_method_radio;
				gtk_check_button_set_active (_tmp6_, TRUE);
				break;
			}
		}
	} else {
		switch (0) {
			default:
			{
				GtkCheckButton* _tmp7_;
				_tmp7_ = self->priv->other_click_method_radio;
				gtk_check_button_set_active (_tmp7_, TRUE);
				break;
			}
		}
	}
}

static Block5Data*
block5_data_ref (Block5Data* _data5_)
{
	g_atomic_int_inc (&_data5_->_ref_count_);
	return _data5_;
}

static void
block5_data_unref (void * _userdata_)
{
	Block5Data* _data5_;
	_data5_ = (Block5Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data5_->_ref_count_)) {
		MouseTouchpadTouchpadView* self;
		self = _data5_->self;
		_g_object_unref0 (_data5_->disabled_scroll_radio);
		_g_object_unref0 (_data5_->natural_scrolling_header);
		_g_object_unref0 (_data5_->natural_scrolling_switch);
		_g_object_unref0 (self);
		g_slice_free (Block5Data, _data5_);
	}
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static gboolean
_mouse_touchpad_touchpad_view___lambda15_ (GValue* value,
                                           GVariant* variant,
                                           void* user_data)
{
	const gchar* _tmp0_;
	gboolean result;
	g_return_val_if_fail (value != NULL, FALSE);
	g_return_val_if_fail (variant != NULL, FALSE);
	_tmp0_ = g_variant_get_string (variant, NULL);
	g_value_set_boolean (value, g_strcmp0 (_tmp0_, "disabled-on-external-mouse") == 0);
	result = TRUE;
	return result;
}

static gboolean
__mouse_touchpad_touchpad_view___lambda15__gsettings_bind_get_mapping (GValue* value,
                                                                       GVariant* variant,
                                                                       void* user_data)
{
	gboolean result;
	result = _mouse_touchpad_touchpad_view___lambda15_ (value, variant, user_data);
	return result;
}

static GVariant*
_mouse_touchpad_touchpad_view___lambda16_ (GValue* value,
                                           const GVariantType* expected_type,
                                           void* user_data)
{
	GVariant* result;
	g_return_val_if_fail (value != NULL, NULL);
	g_return_val_if_fail (expected_type != NULL, NULL);
	if (g_value_get_boolean (value)) {
		GVariant* _tmp0_;
		_tmp0_ = g_variant_new ("s", "disabled-on-external-mouse", NULL);
		g_variant_ref_sink (_tmp0_);
		result = _tmp0_;
		return result;
	} else {
		GVariant* _tmp1_;
		_tmp1_ = g_variant_new ("s", "enabled", NULL);
		g_variant_ref_sink (_tmp1_);
		result = _tmp1_;
		return result;
	}
}

static GVariant*
__mouse_touchpad_touchpad_view___lambda16__gsettings_bind_set_mapping (GValue* value,
                                                                       const GVariantType* expected_type,
                                                                       void* user_data)
{
	GVariant* result;
	result = _mouse_touchpad_touchpad_view___lambda16_ (value, expected_type, user_data);
	return result;
}

static void
_mouse_touchpad_touchpad_view_update_click_method_g_settings_changed (GSettings* _sender,
                                                                      const gchar* key,
                                                                      gpointer self)
{
	mouse_touchpad_touchpad_view_update_click_method ((MouseTouchpadTouchpadView*) self);
}

static void
_mouse_touchpad_touchpad_view___lambda17_ (MouseTouchpadTouchpadView* self)
{
	GSettings* _tmp0_;
	_tmp0_ = self->priv->glib_settings;
	g_settings_set_string (_tmp0_, "click-method", "fingers");
}

static void
__mouse_touchpad_touchpad_view___lambda17__gtk_check_button_toggled (GtkCheckButton* _sender,
                                                                     gpointer self)
{
	_mouse_touchpad_touchpad_view___lambda17_ ((MouseTouchpadTouchpadView*) self);
}

static void
_mouse_touchpad_touchpad_view___lambda18_ (MouseTouchpadTouchpadView* self)
{
	GSettings* _tmp0_;
	_tmp0_ = self->priv->glib_settings;
	g_settings_set_string (_tmp0_, "click-method", "areas");
}

static void
__mouse_touchpad_touchpad_view___lambda18__gtk_check_button_toggled (GtkCheckButton* _sender,
                                                                     gpointer self)
{
	_mouse_touchpad_touchpad_view___lambda18_ ((MouseTouchpadTouchpadView*) self);
}

static void
_mouse_touchpad_touchpad_view___lambda19_ (Block5Data* _data5_)
{
	MouseTouchpadTouchpadView* self;
	GraniteHeaderLabel* _tmp0_;
	GtkCheckButton* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	GtkSwitch* _tmp4_;
	GtkCheckButton* _tmp5_;
	gboolean _tmp6_;
	gboolean _tmp7_;
	self = _data5_->self;
	_tmp0_ = _data5_->natural_scrolling_header;
	_tmp1_ = _data5_->disabled_scroll_radio;
	_tmp2_ = gtk_check_button_get_active (_tmp1_);
	_tmp3_ = _tmp2_;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp0_, !_tmp3_);
	_tmp4_ = _data5_->natural_scrolling_switch;
	_tmp5_ = _data5_->disabled_scroll_radio;
	_tmp6_ = gtk_check_button_get_active (_tmp5_);
	_tmp7_ = _tmp6_;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp4_, !_tmp7_);
}

static void
__mouse_touchpad_touchpad_view___lambda19__gtk_check_button_toggled (GtkCheckButton* _sender,
                                                                     gpointer self)
{
	_mouse_touchpad_touchpad_view___lambda19_ (self);
}

static void
_mouse_touchpad_touchpad_view___lambda20_ (MouseTouchpadTouchpadView* self)
{
	GSettings* _tmp0_;
	GSettings* _tmp1_;
	_tmp0_ = self->priv->glib_settings;
	g_settings_set_boolean (_tmp0_, "edge-scrolling-enabled", FALSE);
	_tmp1_ = self->priv->glib_settings;
	g_settings_set_boolean (_tmp1_, "two-finger-scrolling-enabled", TRUE);
}

static void
__mouse_touchpad_touchpad_view___lambda20__gtk_check_button_toggled (GtkCheckButton* _sender,
                                                                     gpointer self)
{
	_mouse_touchpad_touchpad_view___lambda20_ ((MouseTouchpadTouchpadView*) self);
}

static void
_mouse_touchpad_touchpad_view___lambda21_ (MouseTouchpadTouchpadView* self)
{
	GSettings* _tmp0_;
	GSettings* _tmp1_;
	_tmp0_ = self->priv->glib_settings;
	g_settings_set_boolean (_tmp0_, "edge-scrolling-enabled", TRUE);
	_tmp1_ = self->priv->glib_settings;
	g_settings_set_boolean (_tmp1_, "two-finger-scrolling-enabled", FALSE);
}

static void
__mouse_touchpad_touchpad_view___lambda21__gtk_check_button_toggled (GtkCheckButton* _sender,
                                                                     gpointer self)
{
	_mouse_touchpad_touchpad_view___lambda21_ ((MouseTouchpadTouchpadView*) self);
}

static GObject *
mouse_touchpad_touchpad_view_constructor (GType type,
                                          guint n_construct_properties,
                                          GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	MouseTouchpadTouchpadView * self;
	Block5Data* _data5_;
	GtkAdjustment* pointer_speed_adjustment = NULL;
	GtkAdjustment* _tmp0_;
	GtkScale* pointer_speed_scale = NULL;
	GtkAdjustment* _tmp1_;
	GtkScale* _tmp2_ = NULL;
	GtkScale* _tmp3_;
	GtkScale* _tmp4_;
	GtkScale* _tmp5_;
	GraniteHeaderLabel* pointer_speed_header = NULL;
	GtkScale* _tmp6_;
	GtkWidget* _tmp7_;
	GraniteHeaderLabel* _tmp8_ = NULL;
	GtkCheckButton* _tmp9_;
	GtkCheckButton* _tmp10_;
	GtkLabel* multitouch_click_method_label = NULL;
	GtkLabel* _tmp11_;
	GtkImage* multitouch_click_method_image = NULL;
	GtkImage* _tmp12_ = NULL;
	GtkBox* multitouch_click_method_box = NULL;
	GtkBox* _tmp13_;
	GtkBox* _tmp14_;
	GtkImage* _tmp15_;
	GtkBox* _tmp16_;
	GtkLabel* _tmp17_;
	GtkBox* _tmp18_;
	GtkCheckButton* _tmp19_;
	GtkCheckButton* _tmp20_;
	GtkCheckButton* _tmp21_;
	GtkCheckButton* _tmp22_ = NULL;
	GtkCheckButton* _tmp23_;
	GtkLabel* areas_click_method_label = NULL;
	GtkLabel* _tmp24_;
	GtkImage* areas_click_method_image = NULL;
	GtkImage* _tmp25_ = NULL;
	GtkBox* areas_click_method_box = NULL;
	GtkBox* _tmp26_;
	GtkBox* _tmp27_;
	GtkImage* _tmp28_;
	GtkBox* _tmp29_;
	GtkLabel* _tmp30_;
	GtkBox* _tmp31_;
	GtkCheckButton* _tmp32_;
	GraniteHeaderLabel* click_method_label = NULL;
	GraniteHeaderLabel* _tmp33_;
	GtkBox* click_method_box = NULL;
	GtkBox* _tmp34_;
	GtkBox* _tmp35_;
	GtkCheckButton* _tmp36_;
	GtkBox* _tmp37_;
	GtkCheckButton* _tmp38_;
	GtkCheckButton* tap_to_click_check = NULL;
	GtkCheckButton* _tmp39_ = NULL;
	GtkCheckButton* tap_and_drag_check = NULL;
	GtkCheckButton* _tmp40_ = NULL;
	GtkBox* tap_box = NULL;
	GtkBox* _tmp41_;
	GtkBox* _tmp42_;
	GtkCheckButton* _tmp43_;
	GtkBox* _tmp44_;
	GtkCheckButton* _tmp45_;
	GraniteHeaderLabel* scroll_method_label = NULL;
	GraniteHeaderLabel* _tmp46_;
	GtkCheckButton* two_finger_scroll_radio = NULL;
	GtkCheckButton* _tmp47_;
	GtkCheckButton* _tmp48_;
	GtkLabel* two_finger_scroll_label = NULL;
	GtkLabel* _tmp49_;
	GtkImage* two_finger_scroll_image = NULL;
	GtkImage* _tmp50_ = NULL;
	GtkBox* two_finger_scroll_box = NULL;
	GtkBox* _tmp51_;
	GtkBox* _tmp52_;
	GtkImage* _tmp53_;
	GtkBox* _tmp54_;
	GtkLabel* _tmp55_;
	GtkBox* _tmp56_;
	GtkCheckButton* _tmp57_;
	GtkCheckButton* edge_scroll_radio = NULL;
	GtkCheckButton* _tmp58_;
	GtkCheckButton* _tmp59_;
	GtkCheckButton* _tmp60_ = NULL;
	GtkCheckButton* _tmp61_;
	GtkLabel* edge_scroll_label = NULL;
	GtkLabel* _tmp62_;
	GtkImage* edge_scroll_image = NULL;
	GtkImage* _tmp63_ = NULL;
	GtkBox* edge_scroll_box = NULL;
	GtkBox* _tmp64_;
	GtkBox* _tmp65_;
	GtkImage* _tmp66_;
	GtkBox* _tmp67_;
	GtkLabel* _tmp68_;
	GtkBox* _tmp69_;
	GtkCheckButton* _tmp70_;
	GtkBox* scroll_method_box = NULL;
	GtkBox* _tmp71_;
	GtkBox* _tmp72_;
	GtkCheckButton* _tmp73_;
	GtkBox* _tmp74_;
	GtkCheckButton* _tmp75_;
	GtkSwitch* _tmp76_ = NULL;
	GtkSwitch* _tmp77_;
	GtkWidget* _tmp78_;
	gchar* _tmp79_;
	GraniteHeaderLabel* _tmp80_ = NULL;
	GtkBox* natural_scrolling_box = NULL;
	GtkBox* _tmp81_ = NULL;
	GtkBox* _tmp82_;
	GraniteHeaderLabel* _tmp83_;
	GtkBox* _tmp84_;
	GtkSwitch* _tmp85_;
	GraniteHeaderLabel* disable_label = NULL;
	GraniteHeaderLabel* _tmp86_;
	GtkCheckButton* disable_while_typing_check = NULL;
	GtkCheckButton* _tmp87_;
	GtkCheckButton* disable_with_mouse_check = NULL;
	GtkCheckButton* _tmp88_;
	GtkBox* disable_box = NULL;
	GtkBox* _tmp89_;
	GtkBox* _tmp90_;
	GtkCheckButton* _tmp91_;
	GtkBox* _tmp92_;
	GtkCheckButton* _tmp93_;
	GtkBox* content_box = NULL;
	GtkBox* _tmp94_;
	GtkBox* _tmp95_;
	GraniteHeaderLabel* _tmp96_;
	GtkBox* _tmp97_;
	GtkScale* _tmp98_;
	GtkBox* _tmp99_;
	GraniteHeaderLabel* _tmp100_;
	GtkBox* _tmp101_;
	GtkBox* _tmp102_;
	GtkBox* _tmp103_;
	GraniteHeaderLabel* _tmp104_;
	GraniteHeaderLabel* _tmp105_;
	GtkBox* _tmp106_;
	GtkBox* _tmp107_;
	GtkBox* _tmp108_;
	GraniteHeaderLabel* _tmp109_;
	GtkBox* _tmp110_;
	GtkBox* _tmp111_;
	GtkBox* _tmp112_;
	GraniteHeaderLabel* _tmp113_;
	GtkBox* _tmp114_;
	GtkBox* _tmp115_;
	GtkBox* _tmp116_;
	GtkBox* _tmp117_;
	GtkBox* _tmp118_;
	GSettings* _tmp119_;
	GSettings* _tmp120_;
	GtkCheckButton* _tmp121_;
	GSettings* _tmp122_;
	GtkSwitch* _tmp123_;
	GSettings* _tmp124_;
	GtkAdjustment* _tmp125_;
	GSettings* _tmp126_;
	GtkCheckButton* _tmp127_;
	GSettings* _tmp128_;
	GtkCheckButton* _tmp129_;
	GtkCheckButton* _tmp130_;
	GtkCheckButton* _tmp131_;
	GSettings* _tmp132_;
	GtkCheckButton* _tmp133_;
	GtkCheckButton* _tmp134_;
	GtkCheckButton* _tmp135_;
	GtkCheckButton* _tmp136_ = NULL;
	GSettings* _tmp137_;
	GtkCheckButton* _tmp138_;
	GtkCheckButton* _tmp139_;
	GtkCheckButton* _tmp140_;
	GtkCheckButton* _tmp141_;
	GtkCheckButton* _tmp142_ = NULL;
	GtkCheckButton* _tmp143_;
	GtkCheckButton* _tmp144_;
	GtkCheckButton* _tmp145_;
	gboolean two_finger_scrolling = FALSE;
	GSettings* _tmp146_;
	gboolean _tmp147_ = FALSE;
	GSettings* _tmp148_;
	parent_class = G_OBJECT_CLASS (mouse_touchpad_touchpad_view_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, MOUSE_TOUCHPAD_TYPE_TOUCHPAD_VIEW, MouseTouchpadTouchpadView);
	_data5_ = g_slice_new0 (Block5Data);
	_data5_->_ref_count_ = 1;
	_data5_->self = g_object_ref (self);
	switchboard_settings_page_set_show_end_title_buttons ((SwitchboardSettingsPage*) self, TRUE);
	_tmp0_ = gtk_adjustment_new ((gdouble) 0, (gdouble) -1, (gdouble) 1, 0.1, (gdouble) 0, (gdouble) 0);
	g_object_ref_sink (_tmp0_);
	pointer_speed_adjustment = _tmp0_;
	_tmp1_ = pointer_speed_adjustment;
	_tmp2_ = (GtkScale*) gtk_scale_new (GTK_ORIENTATION_HORIZONTAL, _tmp1_);
	gtk_scale_set_digits (_tmp2_, 2);
	gtk_scale_set_draw_value (_tmp2_, FALSE);
	gtk_widget_set_hexpand ((GtkWidget*) _tmp2_, TRUE);
	g_object_ref_sink (_tmp2_);
	pointer_speed_scale = _tmp2_;
	_tmp3_ = pointer_speed_scale;
	gtk_scale_add_mark (_tmp3_, (gdouble) -1, GTK_POS_BOTTOM, _ ("Slower"));
	_tmp4_ = pointer_speed_scale;
	gtk_scale_add_mark (_tmp4_, (gdouble) 0, GTK_POS_BOTTOM, NULL);
	_tmp5_ = pointer_speed_scale;
	gtk_scale_add_mark (_tmp5_, (gdouble) 1, GTK_POS_BOTTOM, _ ("Faster"));
	_tmp6_ = pointer_speed_scale;
	_tmp7_ = _g_object_ref0 ((GtkWidget*) _tmp6_);
	_tmp8_ = granite_header_label_new (_ ("Pointer Speed"));
	granite_header_label_set_mnemonic_widget (_tmp8_, _tmp7_);
	_g_object_unref0 (_tmp7_);
	g_object_ref_sink (_tmp8_);
	pointer_speed_header = _tmp8_;
	_tmp9_ = (GtkCheckButton*) gtk_check_button_new ();
	g_object_ref_sink (_tmp9_);
	_g_object_unref0 (self->priv->multitouch_click_method_radio);
	self->priv->multitouch_click_method_radio = _tmp9_;
	_tmp10_ = self->priv->multitouch_click_method_radio;
	gtk_widget_add_css_class ((GtkWidget*) _tmp10_, "image-button");
	_tmp11_ = (GtkLabel*) gtk_label_new (_ ("Multitouch"));
	g_object_ref_sink (_tmp11_);
	multitouch_click_method_label = _tmp11_;
	_tmp12_ = (GtkImage*) gtk_image_new_from_icon_name ("touchpad-click-multitouch-symbolic");
	gtk_image_set_pixel_size (_tmp12_, 32);
	g_object_ref_sink (_tmp12_);
	multitouch_click_method_image = _tmp12_;
	_tmp13_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 0);
	g_object_ref_sink (_tmp13_);
	multitouch_click_method_box = _tmp13_;
	_tmp14_ = multitouch_click_method_box;
	_tmp15_ = multitouch_click_method_image;
	gtk_box_append (_tmp14_, (GtkWidget*) _tmp15_);
	_tmp16_ = multitouch_click_method_box;
	_tmp17_ = multitouch_click_method_label;
	gtk_box_append (_tmp16_, (GtkWidget*) _tmp17_);
	_tmp18_ = multitouch_click_method_box;
	_tmp19_ = self->priv->multitouch_click_method_radio;
	gtk_widget_set_parent ((GtkWidget*) _tmp18_, (GtkWidget*) _tmp19_);
	_tmp20_ = self->priv->multitouch_click_method_radio;
	_tmp21_ = _g_object_ref0 (_tmp20_);
	_tmp22_ = (GtkCheckButton*) gtk_check_button_new ();
	gtk_check_button_set_group (_tmp22_, _tmp21_);
	_g_object_unref0 (_tmp21_);
	g_object_ref_sink (_tmp22_);
	_g_object_unref0 (self->priv->areas_click_method_radio);
	self->priv->areas_click_method_radio = _tmp22_;
	_tmp23_ = self->priv->areas_click_method_radio;
	gtk_widget_add_css_class ((GtkWidget*) _tmp23_, "image-button");
	_tmp24_ = (GtkLabel*) gtk_label_new (_ ("Areas"));
	g_object_ref_sink (_tmp24_);
	areas_click_method_label = _tmp24_;
	_tmp25_ = (GtkImage*) gtk_image_new_from_icon_name ("touchpad-click-areas-symbolic");
	gtk_image_set_pixel_size (_tmp25_, 32);
	g_object_ref_sink (_tmp25_);
	areas_click_method_image = _tmp25_;
	_tmp26_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 0);
	g_object_ref_sink (_tmp26_);
	areas_click_method_box = _tmp26_;
	_tmp27_ = areas_click_method_box;
	_tmp28_ = areas_click_method_image;
	gtk_box_append (_tmp27_, (GtkWidget*) _tmp28_);
	_tmp29_ = areas_click_method_box;
	_tmp30_ = areas_click_method_label;
	gtk_box_append (_tmp29_, (GtkWidget*) _tmp30_);
	_tmp31_ = areas_click_method_box;
	_tmp32_ = self->priv->areas_click_method_radio;
	gtk_widget_set_parent ((GtkWidget*) _tmp31_, (GtkWidget*) _tmp32_);
	_tmp33_ = granite_header_label_new (_ ("Physical Secondary Clicking"));
	g_object_ref_sink (_tmp33_);
	click_method_label = _tmp33_;
	_tmp34_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 12);
	g_object_ref_sink (_tmp34_);
	click_method_box = _tmp34_;
	_tmp35_ = click_method_box;
	_tmp36_ = self->priv->multitouch_click_method_radio;
	gtk_box_append (_tmp35_, (GtkWidget*) _tmp36_);
	_tmp37_ = click_method_box;
	_tmp38_ = self->priv->areas_click_method_radio;
	gtk_box_append (_tmp37_, (GtkWidget*) _tmp38_);
	_tmp39_ = (GtkCheckButton*) gtk_check_button_new_with_label (_ ("Tap to click"));
	gtk_widget_set_halign ((GtkWidget*) _tmp39_, GTK_ALIGN_START);
	g_object_ref_sink (_tmp39_);
	tap_to_click_check = _tmp39_;
	_tmp40_ = (GtkCheckButton*) gtk_check_button_new_with_label (_ ("Double-tap and move to drag"));
	gtk_widget_set_halign ((GtkWidget*) _tmp40_, GTK_ALIGN_START);
	g_object_ref_sink (_tmp40_);
	tap_and_drag_check = _tmp40_;
	_tmp41_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 24);
	g_object_ref_sink (_tmp41_);
	tap_box = _tmp41_;
	_tmp42_ = tap_box;
	_tmp43_ = tap_to_click_check;
	gtk_box_append (_tmp42_, (GtkWidget*) _tmp43_);
	_tmp44_ = tap_box;
	_tmp45_ = tap_and_drag_check;
	gtk_box_append (_tmp44_, (GtkWidget*) _tmp45_);
	_tmp46_ = granite_header_label_new (_ ("Scroll Method"));
	g_object_ref_sink (_tmp46_);
	scroll_method_label = _tmp46_;
	_tmp47_ = (GtkCheckButton*) gtk_check_button_new ();
	g_object_ref_sink (_tmp47_);
	two_finger_scroll_radio = _tmp47_;
	_tmp48_ = two_finger_scroll_radio;
	gtk_widget_add_css_class ((GtkWidget*) _tmp48_, "image-button");
	_tmp49_ = (GtkLabel*) gtk_label_new (_ ("Two-finger"));
	g_object_ref_sink (_tmp49_);
	two_finger_scroll_label = _tmp49_;
	_tmp50_ = (GtkImage*) gtk_image_new_from_icon_name ("touchpad-scroll-two-finger-symbolic");
	gtk_image_set_pixel_size (_tmp50_, 32);
	g_object_ref_sink (_tmp50_);
	two_finger_scroll_image = _tmp50_;
	_tmp51_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 0);
	g_object_ref_sink (_tmp51_);
	two_finger_scroll_box = _tmp51_;
	_tmp52_ = two_finger_scroll_box;
	_tmp53_ = two_finger_scroll_image;
	gtk_box_append (_tmp52_, (GtkWidget*) _tmp53_);
	_tmp54_ = two_finger_scroll_box;
	_tmp55_ = two_finger_scroll_label;
	gtk_box_append (_tmp54_, (GtkWidget*) _tmp55_);
	_tmp56_ = two_finger_scroll_box;
	_tmp57_ = two_finger_scroll_radio;
	gtk_widget_set_parent ((GtkWidget*) _tmp56_, (GtkWidget*) _tmp57_);
	_tmp58_ = two_finger_scroll_radio;
	_tmp59_ = _g_object_ref0 (_tmp58_);
	_tmp60_ = (GtkCheckButton*) gtk_check_button_new ();
	gtk_check_button_set_group (_tmp60_, _tmp59_);
	_g_object_unref0 (_tmp59_);
	g_object_ref_sink (_tmp60_);
	edge_scroll_radio = _tmp60_;
	_tmp61_ = edge_scroll_radio;
	gtk_widget_add_css_class ((GtkWidget*) _tmp61_, "image-button");
	_tmp62_ = (GtkLabel*) gtk_label_new (_ ("Edge"));
	g_object_ref_sink (_tmp62_);
	edge_scroll_label = _tmp62_;
	_tmp63_ = (GtkImage*) gtk_image_new_from_icon_name ("touchpad-scroll-edge-symbolic");
	gtk_image_set_pixel_size (_tmp63_, 32);
	g_object_ref_sink (_tmp63_);
	edge_scroll_image = _tmp63_;
	_tmp64_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 0);
	g_object_ref_sink (_tmp64_);
	edge_scroll_box = _tmp64_;
	_tmp65_ = edge_scroll_box;
	_tmp66_ = edge_scroll_image;
	gtk_box_append (_tmp65_, (GtkWidget*) _tmp66_);
	_tmp67_ = edge_scroll_box;
	_tmp68_ = edge_scroll_label;
	gtk_box_append (_tmp67_, (GtkWidget*) _tmp68_);
	_tmp69_ = edge_scroll_box;
	_tmp70_ = edge_scroll_radio;
	gtk_widget_set_parent ((GtkWidget*) _tmp69_, (GtkWidget*) _tmp70_);
	_tmp71_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 24);
	g_object_ref_sink (_tmp71_);
	scroll_method_box = _tmp71_;
	_tmp72_ = scroll_method_box;
	_tmp73_ = two_finger_scroll_radio;
	gtk_box_append (_tmp72_, (GtkWidget*) _tmp73_);
	_tmp74_ = scroll_method_box;
	_tmp75_ = edge_scroll_radio;
	gtk_box_append (_tmp74_, (GtkWidget*) _tmp75_);
	_tmp76_ = (GtkSwitch*) gtk_switch_new ();
	gtk_widget_set_halign ((GtkWidget*) _tmp76_, GTK_ALIGN_END);
	gtk_widget_set_hexpand ((GtkWidget*) _tmp76_, TRUE);
	gtk_widget_set_valign ((GtkWidget*) _tmp76_, GTK_ALIGN_CENTER);
	g_object_ref_sink (_tmp76_);
	_data5_->natural_scrolling_switch = _tmp76_;
	_tmp77_ = _data5_->natural_scrolling_switch;
	_tmp78_ = _g_object_ref0 ((GtkWidget*) _tmp77_);
	_tmp79_ = g_strdup (_ ("Scrolling moves the content, not the view"));
	_tmp80_ = granite_header_label_new (_ ("Natural Scrolling"));
	granite_header_label_set_mnemonic_widget (_tmp80_, _tmp78_);
	_g_object_unref0 (_tmp78_);
	granite_header_label_set_secondary_text (_tmp80_, _tmp79_);
	_g_free0 (_tmp79_);
	g_object_ref_sink (_tmp80_);
	_data5_->natural_scrolling_header = _tmp80_;
	_tmp81_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 12);
	gtk_widget_set_margin_top ((GtkWidget*) _tmp81_, 12);
	g_object_ref_sink (_tmp81_);
	natural_scrolling_box = _tmp81_;
	_tmp82_ = natural_scrolling_box;
	_tmp83_ = _data5_->natural_scrolling_header;
	gtk_box_append (_tmp82_, (GtkWidget*) _tmp83_);
	_tmp84_ = natural_scrolling_box;
	_tmp85_ = _data5_->natural_scrolling_switch;
	gtk_box_append (_tmp84_, (GtkWidget*) _tmp85_);
	_tmp86_ = granite_header_label_new (_ ("Ignore"));
	g_object_ref_sink (_tmp86_);
	disable_label = _tmp86_;
	_tmp87_ = (GtkCheckButton*) gtk_check_button_new_with_label (_ ("While typing"));
	g_object_ref_sink (_tmp87_);
	disable_while_typing_check = _tmp87_;
	_tmp88_ = (GtkCheckButton*) gtk_check_button_new_with_label (_ ("When mouse is connected"));
	g_object_ref_sink (_tmp88_);
	disable_with_mouse_check = _tmp88_;
	_tmp89_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 24);
	g_object_ref_sink (_tmp89_);
	disable_box = _tmp89_;
	_tmp90_ = disable_box;
	_tmp91_ = disable_while_typing_check;
	gtk_box_append (_tmp90_, (GtkWidget*) _tmp91_);
	_tmp92_ = disable_box;
	_tmp93_ = disable_with_mouse_check;
	gtk_box_append (_tmp92_, (GtkWidget*) _tmp93_);
	_tmp94_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 6);
	g_object_ref_sink (_tmp94_);
	content_box = _tmp94_;
	_tmp95_ = content_box;
	_tmp96_ = pointer_speed_header;
	gtk_box_append (_tmp95_, (GtkWidget*) _tmp96_);
	_tmp97_ = content_box;
	_tmp98_ = pointer_speed_scale;
	gtk_box_append (_tmp97_, (GtkWidget*) _tmp98_);
	_tmp99_ = content_box;
	_tmp100_ = disable_label;
	gtk_box_append (_tmp99_, (GtkWidget*) _tmp100_);
	_tmp101_ = content_box;
	_tmp102_ = disable_box;
	gtk_box_append (_tmp101_, (GtkWidget*) _tmp102_);
	_tmp103_ = content_box;
	_tmp104_ = granite_header_label_new (_ ("Tapping"));
	g_object_ref_sink (_tmp104_);
	_tmp105_ = _tmp104_;
	gtk_box_append (_tmp103_, (GtkWidget*) _tmp105_);
	_g_object_unref0 (_tmp105_);
	_tmp106_ = content_box;
	_tmp107_ = tap_box;
	gtk_box_append (_tmp106_, (GtkWidget*) _tmp107_);
	_tmp108_ = content_box;
	_tmp109_ = click_method_label;
	gtk_box_append (_tmp108_, (GtkWidget*) _tmp109_);
	_tmp110_ = content_box;
	_tmp111_ = click_method_box;
	gtk_box_append (_tmp110_, (GtkWidget*) _tmp111_);
	_tmp112_ = content_box;
	_tmp113_ = scroll_method_label;
	gtk_box_append (_tmp112_, (GtkWidget*) _tmp113_);
	_tmp114_ = content_box;
	_tmp115_ = scroll_method_box;
	gtk_box_append (_tmp114_, (GtkWidget*) _tmp115_);
	_tmp116_ = content_box;
	_tmp117_ = natural_scrolling_box;
	gtk_box_append (_tmp116_, (GtkWidget*) _tmp117_);
	_tmp118_ = content_box;
	switchboard_settings_page_set_child ((SwitchboardSettingsPage*) self, (GtkWidget*) _tmp118_);
	_tmp119_ = g_settings_new ("org.gnome.desktop.peripherals.touchpad");
	_g_object_unref0 (self->priv->glib_settings);
	self->priv->glib_settings = _tmp119_;
	_tmp120_ = self->priv->glib_settings;
	_tmp121_ = disable_while_typing_check;
	g_settings_bind (_tmp120_, "disable-while-typing", (GObject*) _tmp121_, "active", G_SETTINGS_BIND_DEFAULT);
	_tmp122_ = self->priv->glib_settings;
	_tmp123_ = _data5_->natural_scrolling_switch;
	g_settings_bind (_tmp122_, "natural-scroll", (GObject*) _tmp123_, "active", G_SETTINGS_BIND_DEFAULT);
	_tmp124_ = self->priv->glib_settings;
	_tmp125_ = pointer_speed_adjustment;
	g_settings_bind (_tmp124_, "speed", (GObject*) _tmp125_, "value", G_SETTINGS_BIND_DEFAULT);
	_tmp126_ = self->priv->glib_settings;
	_tmp127_ = tap_to_click_check;
	g_settings_bind (_tmp126_, "tap-to-click", (GObject*) _tmp127_, "active", G_SETTINGS_BIND_DEFAULT);
	_tmp128_ = self->priv->glib_settings;
	_tmp129_ = tap_and_drag_check;
	g_settings_bind (_tmp128_, "tap-and-drag", (GObject*) _tmp129_, "active", G_SETTINGS_BIND_DEFAULT);
	_tmp130_ = tap_to_click_check;
	_tmp131_ = tap_and_drag_check;
	g_object_bind_property_with_closures ((GObject*) _tmp130_, "active", (GObject*) _tmp131_, "sensitive", G_BINDING_SYNC_CREATE, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	_tmp132_ = self->priv->glib_settings;
	_tmp133_ = disable_with_mouse_check;
	g_settings_bind_with_mapping (_tmp132_, "send-events", (GObject*) _tmp133_, "active", G_SETTINGS_BIND_DEFAULT, __mouse_touchpad_touchpad_view___lambda15__gsettings_bind_get_mapping, __mouse_touchpad_touchpad_view___lambda16__gsettings_bind_set_mapping, NULL, NULL);
	_tmp134_ = self->priv->multitouch_click_method_radio;
	_tmp135_ = _g_object_ref0 (_tmp134_);
	_tmp136_ = (GtkCheckButton*) gtk_check_button_new ();
	gtk_check_button_set_group (_tmp136_, _tmp135_);
	_g_object_unref0 (_tmp135_);
	g_object_ref_sink (_tmp136_);
	_g_object_unref0 (self->priv->other_click_method_radio);
	self->priv->other_click_method_radio = _tmp136_;
	mouse_touchpad_touchpad_view_update_click_method (self);
	_tmp137_ = self->priv->glib_settings;
	g_signal_connect_object (_tmp137_, "changed::click-method", (GCallback) _mouse_touchpad_touchpad_view_update_click_method_g_settings_changed, self, 0);
	_tmp138_ = self->priv->multitouch_click_method_radio;
	g_signal_connect_object (_tmp138_, "toggled", (GCallback) __mouse_touchpad_touchpad_view___lambda17__gtk_check_button_toggled, self, 0);
	_tmp139_ = self->priv->areas_click_method_radio;
	g_signal_connect_object (_tmp139_, "toggled", (GCallback) __mouse_touchpad_touchpad_view___lambda18__gtk_check_button_toggled, self, 0);
	_tmp140_ = two_finger_scroll_radio;
	_tmp141_ = _g_object_ref0 (_tmp140_);
	_tmp142_ = (GtkCheckButton*) gtk_check_button_new ();
	gtk_check_button_set_group (_tmp142_, _tmp141_);
	_g_object_unref0 (_tmp141_);
	g_object_ref_sink (_tmp142_);
	_data5_->disabled_scroll_radio = _tmp142_;
	_tmp143_ = _data5_->disabled_scroll_radio;
	g_signal_connect_data (_tmp143_, "toggled", (GCallback) __mouse_touchpad_touchpad_view___lambda19__gtk_check_button_toggled, block5_data_ref (_data5_), (GClosureNotify) block5_data_unref, 0);
	_tmp144_ = two_finger_scroll_radio;
	g_signal_connect_object (_tmp144_, "toggled", (GCallback) __mouse_touchpad_touchpad_view___lambda20__gtk_check_button_toggled, self, 0);
	_tmp145_ = edge_scroll_radio;
	g_signal_connect_object (_tmp145_, "toggled", (GCallback) __mouse_touchpad_touchpad_view___lambda21__gtk_check_button_toggled, self, 0);
	_tmp146_ = self->priv->glib_settings;
	two_finger_scrolling = g_settings_get_boolean (_tmp146_, "two-finger-scrolling-enabled");
	_tmp148_ = self->priv->glib_settings;
	if (!g_settings_get_boolean (_tmp148_, "edge-scrolling-enabled")) {
		_tmp147_ = !two_finger_scrolling;
	} else {
		_tmp147_ = FALSE;
	}
	if (_tmp147_) {
		GtkCheckButton* _tmp149_;
		_tmp149_ = _data5_->disabled_scroll_radio;
		gtk_check_button_set_active (_tmp149_, TRUE);
	} else {
		if (two_finger_scrolling) {
			GtkCheckButton* _tmp150_;
			_tmp150_ = two_finger_scroll_radio;
			gtk_check_button_set_active (_tmp150_, TRUE);
		} else {
			GtkCheckButton* _tmp151_;
			_tmp151_ = edge_scroll_radio;
			gtk_check_button_set_active (_tmp151_, TRUE);
		}
	}
	_g_object_unref0 (content_box);
	_g_object_unref0 (disable_box);
	_g_object_unref0 (disable_with_mouse_check);
	_g_object_unref0 (disable_while_typing_check);
	_g_object_unref0 (disable_label);
	_g_object_unref0 (natural_scrolling_box);
	_g_object_unref0 (scroll_method_box);
	_g_object_unref0 (edge_scroll_box);
	_g_object_unref0 (edge_scroll_image);
	_g_object_unref0 (edge_scroll_label);
	_g_object_unref0 (edge_scroll_radio);
	_g_object_unref0 (two_finger_scroll_box);
	_g_object_unref0 (two_finger_scroll_image);
	_g_object_unref0 (two_finger_scroll_label);
	_g_object_unref0 (two_finger_scroll_radio);
	_g_object_unref0 (scroll_method_label);
	_g_object_unref0 (tap_box);
	_g_object_unref0 (tap_and_drag_check);
	_g_object_unref0 (tap_to_click_check);
	_g_object_unref0 (click_method_box);
	_g_object_unref0 (click_method_label);
	_g_object_unref0 (areas_click_method_box);
	_g_object_unref0 (areas_click_method_image);
	_g_object_unref0 (areas_click_method_label);
	_g_object_unref0 (multitouch_click_method_box);
	_g_object_unref0 (multitouch_click_method_image);
	_g_object_unref0 (multitouch_click_method_label);
	_g_object_unref0 (pointer_speed_header);
	_g_object_unref0 (pointer_speed_scale);
	_g_object_unref0 (pointer_speed_adjustment);
	block5_data_unref (_data5_);
	_data5_ = NULL;
	return obj;
}

static void
mouse_touchpad_touchpad_view_class_init (MouseTouchpadTouchpadViewClass * klass,
                                         gpointer klass_data)
{
	mouse_touchpad_touchpad_view_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &MouseTouchpadTouchpadView_private_offset);
	G_OBJECT_CLASS (klass)->constructor = mouse_touchpad_touchpad_view_constructor;
	G_OBJECT_CLASS (klass)->finalize = mouse_touchpad_touchpad_view_finalize;
}

static void
mouse_touchpad_touchpad_view_instance_init (MouseTouchpadTouchpadView * self,
                                            gpointer klass)
{
	self->priv = mouse_touchpad_touchpad_view_get_instance_private (self);
}

static void
mouse_touchpad_touchpad_view_finalize (GObject * obj)
{
	MouseTouchpadTouchpadView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, MOUSE_TOUCHPAD_TYPE_TOUCHPAD_VIEW, MouseTouchpadTouchpadView);
	_g_object_unref0 (self->priv->glib_settings);
	_g_object_unref0 (self->priv->areas_click_method_radio);
	_g_object_unref0 (self->priv->multitouch_click_method_radio);
	_g_object_unref0 (self->priv->other_click_method_radio);
	G_OBJECT_CLASS (mouse_touchpad_touchpad_view_parent_class)->finalize (obj);
}

static GType
mouse_touchpad_touchpad_view_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (MouseTouchpadTouchpadViewClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) mouse_touchpad_touchpad_view_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (MouseTouchpadTouchpadView), 0, (GInstanceInitFunc) mouse_touchpad_touchpad_view_instance_init, NULL };
	GType mouse_touchpad_touchpad_view_type_id;
	mouse_touchpad_touchpad_view_type_id = g_type_register_static (SWITCHBOARD_TYPE_SETTINGS_PAGE, "MouseTouchpadTouchpadView", &g_define_type_info, 0);
	MouseTouchpadTouchpadView_private_offset = g_type_add_instance_private (mouse_touchpad_touchpad_view_type_id, sizeof (MouseTouchpadTouchpadViewPrivate));
	return mouse_touchpad_touchpad_view_type_id;
}

GType
mouse_touchpad_touchpad_view_get_type (void)
{
	static volatile gsize mouse_touchpad_touchpad_view_type_id__once = 0;
	if (g_once_init_enter (&mouse_touchpad_touchpad_view_type_id__once)) {
		GType mouse_touchpad_touchpad_view_type_id;
		mouse_touchpad_touchpad_view_type_id = mouse_touchpad_touchpad_view_get_type_once ();
		g_once_init_leave (&mouse_touchpad_touchpad_view_type_id__once, mouse_touchpad_touchpad_view_type_id);
	}
	return mouse_touchpad_touchpad_view_type_id__once;
}

