/* JobRow.c generated by valac 0.56.17, the Vala compiler
 * generated from JobRow.vala, do not modify */

/*-
 * Copyright 2015 - 2022 elementary, Inc. (https://elementary.io)
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 51 Franklin Street - Fifth Floor,
 * Boston, MA 02110-1301, USA.
 *
 * Authored by: Corentin Noël <corentin@elementary.io>
 */

#include "io.elementary.settings.printers.h"
#include <gtk/gtk.h>
#include <glib-object.h>
#include <glib.h>
#include <gio/gio.h>
#include "cups/ipp.h"
#include <glib/gi18n-lib.h>
#include <stdlib.h>
#include <string.h>
#include <granite-7.h>
#include <pango/pango.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	PRINTERS_JOB_ROW_0_PROPERTY,
	PRINTERS_JOB_ROW_JOB_PROPERTY,
	PRINTERS_JOB_ROW_PRINTER_PROPERTY,
	PRINTERS_JOB_ROW_NUM_PROPERTIES
};
static GParamSpec* printers_job_row_properties[PRINTERS_JOB_ROW_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))
typedef struct _Block16Data Block16Data;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

struct _PrintersJobRowPrivate {
	PrintersJob* _job;
	PrintersPrinter* _printer;
	GtkButton* start_pause_button;
	GtkImage* job_state_icon;
	GtkRevealer* action_revealer;
	GtkLabel* date_label;
	GtkLabel* state_label;
};

struct _Block16Data {
	int _ref_count_;
	PrintersJobRow* self;
	GtkButton* cancel_button;
};

static gint PrintersJobRow_private_offset;
static gpointer printers_job_row_parent_class = NULL;
static GtkSizeGroup* printers_job_row_size_group;
static GtkSizeGroup* printers_job_row_size_group = NULL;

static void printers_job_row_update_state (PrintersJobRow* self);
static GObject * printers_job_row_constructor (GType type,
                                        guint n_construct_properties,
                                        GObjectConstructParam * construct_properties);
static Block16Data* block16_data_ref (Block16Data* _data16_);
static void block16_data_unref (void * _userdata_);
static void _printers_job_row_update_state_printers_job_state_changed (PrintersJob* _sender,
                                                                gpointer self);
static void _printers_job_row___lambda6_ (PrintersJobRow* self);
static void __printers_job_row___lambda6__gtk_button_clicked (GtkButton* _sender,
                                                       gpointer self);
static void _printers_job_row___lambda7_ (Block16Data* _data16_);
static void __printers_job_row___lambda7__gtk_button_clicked (GtkButton* _sender,
                                                       gpointer self);
static void printers_job_row_finalize (GObject * obj);
static GType printers_job_row_get_type_once (void);
static void _vala_printers_job_row_get_property (GObject * object,
                                          guint property_id,
                                          GValue * value,
                                          GParamSpec * pspec);
static void _vala_printers_job_row_set_property (GObject * object,
                                          guint property_id,
                                          const GValue * value,
                                          GParamSpec * pspec);

static inline gpointer
printers_job_row_get_instance_private (PrintersJobRow* self)
{
	return G_STRUCT_MEMBER_P (self, PrintersJobRow_private_offset);
}

PrintersJobRow*
printers_job_row_construct (GType object_type,
                            PrintersPrinter* printer,
                            PrintersJob* job)
{
	PrintersJobRow * self = NULL;
	g_return_val_if_fail (printer != NULL, NULL);
	g_return_val_if_fail (job != NULL, NULL);
	self = (PrintersJobRow*) g_object_new (object_type, "job", job, "printer", printer, NULL);
	return self;
}

PrintersJobRow*
printers_job_row_new (PrintersPrinter* printer,
                      PrintersJob* job)
{
	return printers_job_row_construct (PRINTERS_TYPE_JOB_ROW, printer, job);
}

static void
printers_job_row_update_state (PrintersJobRow* self)
{
	GtkImage* _tmp0_;
	PrintersJob* _tmp1_;
	GIcon* _tmp2_;
	GIcon* _tmp3_;
	PrintersJob* _tmp4_;
	ipp_jstate_t _tmp5_;
	ipp_jstate_t _tmp6_;
	GtkLabel* _tmp19_;
	PrintersJob* _tmp20_;
	gchar* _tmp21_;
	gchar* _tmp22_;
	GDateTime* time = NULL;
	PrintersJob* _tmp23_;
	GDateTime* _tmp24_;
	GDateTime* _tmp25_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->job_state_icon;
	_tmp1_ = self->priv->_job;
	_tmp2_ = printers_job_state_icon (_tmp1_);
	_tmp3_ = _tmp2_;
	g_object_set (_tmp0_, "gicon", _tmp3_, NULL);
	_g_object_unref0 (_tmp3_);
	_tmp4_ = self->priv->_job;
	_tmp5_ = printers_job_get_state (_tmp4_);
	_tmp6_ = _tmp5_;
	if (_tmp6_ == IPP_JOB_HELD) {
		GtkButton* _tmp7_;
		GtkRevealer* _tmp8_;
		_tmp7_ = self->priv->start_pause_button;
		gtk_button_set_label (_tmp7_, _ ("Resume"));
		_tmp8_ = self->priv->action_revealer;
		gtk_revealer_set_reveal_child (_tmp8_, TRUE);
	} else {
		gboolean _tmp9_ = FALSE;
		PrintersJob* _tmp10_;
		ipp_jstate_t _tmp11_;
		ipp_jstate_t _tmp12_;
		_tmp10_ = self->priv->_job;
		_tmp11_ = printers_job_get_state (_tmp10_);
		_tmp12_ = _tmp11_;
		if (_tmp12_ == IPP_JOB_PROCESSING) {
			_tmp9_ = TRUE;
		} else {
			PrintersJob* _tmp13_;
			ipp_jstate_t _tmp14_;
			ipp_jstate_t _tmp15_;
			_tmp13_ = self->priv->_job;
			_tmp14_ = printers_job_get_state (_tmp13_);
			_tmp15_ = _tmp14_;
			_tmp9_ = _tmp15_ == IPP_JOB_PENDING;
		}
		if (_tmp9_) {
			GtkButton* _tmp16_;
			GtkRevealer* _tmp17_;
			_tmp16_ = self->priv->start_pause_button;
			gtk_button_set_label (_tmp16_, _ ("Pause"));
			_tmp17_ = self->priv->action_revealer;
			gtk_revealer_set_reveal_child (_tmp17_, TRUE);
		} else {
			GtkRevealer* _tmp18_;
			_tmp18_ = self->priv->action_revealer;
			gtk_revealer_set_reveal_child (_tmp18_, FALSE);
		}
	}
	_tmp19_ = self->priv->state_label;
	_tmp20_ = self->priv->_job;
	_tmp21_ = printers_job_translated_job_state (_tmp20_);
	_tmp22_ = _tmp21_;
	gtk_label_set_label (_tmp19_, _tmp22_);
	_g_free0 (_tmp22_);
	_tmp23_ = self->priv->_job;
	_tmp24_ = printers_job_get_display_time (_tmp23_);
	time = _tmp24_;
	_tmp25_ = time;
	if (_tmp25_ != NULL) {
		GtkLabel* _tmp26_;
		GDateTime* _tmp27_;
		gchar* _tmp28_;
		gchar* _tmp29_;
		_tmp26_ = self->priv->date_label;
		_tmp27_ = time;
		_tmp28_ = granite_date_time_get_relative_datetime (_tmp27_);
		_tmp29_ = _tmp28_;
		gtk_label_set_label (_tmp26_, _tmp29_);
		_g_free0 (_tmp29_);
	} else {
		GtkLabel* _tmp30_;
		_tmp30_ = self->priv->date_label;
		gtk_label_set_label (_tmp30_, NULL);
	}
	gtk_list_box_row_changed ((GtkListBoxRow*) self);
	_g_date_time_unref0 (time);
}

PrintersJob*
printers_job_row_get_job (PrintersJobRow* self)
{
	PrintersJob* result;
	PrintersJob* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_job;
	result = _tmp0_;
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

void
printers_job_row_set_job (PrintersJobRow* self,
                          PrintersJob* value)
{
	PrintersJob* old_value;
	g_return_if_fail (self != NULL);
	old_value = printers_job_row_get_job (self);
	if (old_value != value) {
		PrintersJob* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_job);
		self->priv->_job = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, printers_job_row_properties[PRINTERS_JOB_ROW_JOB_PROPERTY]);
	}
}

PrintersPrinter*
printers_job_row_get_printer (PrintersJobRow* self)
{
	PrintersPrinter* result;
	PrintersPrinter* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_printer;
	result = _tmp0_;
	return result;
}

void
printers_job_row_set_printer (PrintersJobRow* self,
                              PrintersPrinter* value)
{
	PrintersPrinter* old_value;
	g_return_if_fail (self != NULL);
	old_value = printers_job_row_get_printer (self);
	if (old_value != value) {
		PrintersPrinter* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_printer);
		self->priv->_printer = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, printers_job_row_properties[PRINTERS_JOB_ROW_PRINTER_PROPERTY]);
	}
}

static Block16Data*
block16_data_ref (Block16Data* _data16_)
{
	g_atomic_int_inc (&_data16_->_ref_count_);
	return _data16_;
}

static void
block16_data_unref (void * _userdata_)
{
	Block16Data* _data16_;
	_data16_ = (Block16Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data16_->_ref_count_)) {
		PrintersJobRow* self;
		self = _data16_->self;
		_g_object_unref0 (_data16_->cancel_button);
		_g_object_unref0 (self);
		g_slice_free (Block16Data, _data16_);
	}
}

static void
_printers_job_row_update_state_printers_job_state_changed (PrintersJob* _sender,
                                                           gpointer self)
{
	printers_job_row_update_state ((PrintersJobRow*) self);
}

static void
_printers_job_row___lambda6_ (PrintersJobRow* self)
{
	CupsPkHelper* pk_helper = NULL;
	CupsPkHelper* _tmp0_;
	gboolean _tmp1_ = FALSE;
	PrintersJob* _tmp2_;
	ipp_jstate_t _tmp3_;
	ipp_jstate_t _tmp4_;
	GError* _inner_error0_ = NULL;
	_tmp0_ = cups_get_pk_helper ();
	pk_helper = _tmp0_;
	_tmp2_ = self->priv->_job;
	_tmp3_ = printers_job_get_state (_tmp2_);
	_tmp4_ = _tmp3_;
	if (_tmp4_ == IPP_JOB_PROCESSING) {
		_tmp1_ = TRUE;
	} else {
		PrintersJob* _tmp5_;
		ipp_jstate_t _tmp6_;
		ipp_jstate_t _tmp7_;
		_tmp5_ = self->priv->_job;
		_tmp6_ = printers_job_get_state (_tmp5_);
		_tmp7_ = _tmp6_;
		_tmp1_ = _tmp7_ == IPP_JOB_PENDING;
	}
	if (_tmp1_) {
		{
			CupsPkHelper* _tmp8_;
			PrintersJob* _tmp9_;
			gint _tmp10_;
			gint _tmp11_;
			gchar* _tmp12_;
			gchar* _tmp13_;
			_tmp8_ = pk_helper;
			_tmp9_ = self->priv->_job;
			_tmp10_ = printers_job_get_uid (_tmp9_);
			_tmp11_ = _tmp10_;
			_tmp12_ = cups_pk_helper_job_set_hold_until (_tmp8_, _tmp11_, "indefinite", &_inner_error0_);
			_tmp13_ = _tmp12_;
			_g_free0 (_tmp13_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
		}
		goto __finally0;
		__catch0_g_error:
		{
			GError* e = NULL;
			GError* _tmp14_;
			const gchar* _tmp15_;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp14_ = e;
			_tmp15_ = _tmp14_->message;
			g_critical ("JobRow.vala:124: %s", _tmp15_);
			_g_error_free0 (e);
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	} else {
		PrintersJob* _tmp16_;
		ipp_jstate_t _tmp17_;
		ipp_jstate_t _tmp18_;
		_tmp16_ = self->priv->_job;
		_tmp17_ = printers_job_get_state (_tmp16_);
		_tmp18_ = _tmp17_;
		if (_tmp18_ == IPP_JOB_HELD) {
			{
				CupsPkHelper* _tmp19_;
				PrintersJob* _tmp20_;
				gint _tmp21_;
				gint _tmp22_;
				gchar* _tmp23_;
				gchar* _tmp24_;
				_tmp19_ = pk_helper;
				_tmp20_ = self->priv->_job;
				_tmp21_ = printers_job_get_uid (_tmp20_);
				_tmp22_ = _tmp21_;
				_tmp23_ = cups_pk_helper_job_set_hold_until (_tmp19_, _tmp22_, "no-hold", &_inner_error0_);
				_tmp24_ = _tmp23_;
				_g_free0 (_tmp24_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					goto __catch1_g_error;
				}
			}
			goto __finally1;
			__catch1_g_error:
			{
				GError* e = NULL;
				GError* _tmp25_;
				const gchar* _tmp26_;
				e = _inner_error0_;
				_inner_error0_ = NULL;
				_tmp25_ = e;
				_tmp26_ = _tmp25_->message;
				g_critical ("JobRow.vala:130: %s", _tmp26_);
				_g_error_free0 (e);
			}
			__finally1:
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return;
			}
		} else {
			g_critical ("JobRow.vala:133: Unexpected job state when trying to pause or resume");
		}
	}
}

static void
__printers_job_row___lambda6__gtk_button_clicked (GtkButton* _sender,
                                                  gpointer self)
{
	_printers_job_row___lambda6_ ((PrintersJobRow*) self);
}

static void
_printers_job_row___lambda7_ (Block16Data* _data16_)
{
	PrintersJobRow* self;
	CupsPkHelper* pk_helper = NULL;
	CupsPkHelper* _tmp0_;
	GError* _inner_error0_ = NULL;
	self = _data16_->self;
	_tmp0_ = cups_get_pk_helper ();
	pk_helper = _tmp0_;
	{
		CupsPkHelper* _tmp1_;
		PrintersJob* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gchar* _tmp5_;
		gchar* _tmp6_;
		GtkButton* _tmp7_;
		GtkButton* _tmp8_;
		_tmp1_ = pk_helper;
		_tmp2_ = self->priv->_job;
		_tmp3_ = printers_job_get_uid (_tmp2_);
		_tmp4_ = _tmp3_;
		_tmp5_ = cups_pk_helper_job_cancel_purge (_tmp1_, _tmp4_, FALSE, &_inner_error0_);
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp6_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp7_ = self->priv->start_pause_button;
		gtk_widget_set_sensitive ((GtkWidget*) _tmp7_, FALSE);
		_tmp8_ = _data16_->cancel_button;
		gtk_widget_set_sensitive ((GtkWidget*) _tmp8_, FALSE);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp9_;
		const gchar* _tmp10_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp9_ = e;
		_tmp10_ = _tmp9_->message;
		g_critical ("JobRow.vala:144: %s", _tmp10_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
__printers_job_row___lambda7__gtk_button_clicked (GtkButton* _sender,
                                                  gpointer self)
{
	_printers_job_row___lambda7_ (self);
}

static GObject *
printers_job_row_constructor (GType type,
                              guint n_construct_properties,
                              GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	PrintersJobRow * self;
	Block16Data* _data16_;
	GtkImage* icon = NULL;
	PrintersJob* _tmp0_;
	GIcon* _tmp1_;
	GIcon* _tmp2_;
	GtkImage* _tmp3_;
	GtkImage* _tmp4_;
	GtkImage* _tmp5_;
	PrintersJob* _tmp6_;
	GIcon* _tmp7_;
	GtkImage* _tmp8_ = NULL;
	GtkOverlay* icon_overlay = NULL;
	GtkImage* _tmp9_;
	GtkWidget* _tmp10_;
	GtkOverlay* _tmp11_ = NULL;
	GtkOverlay* _tmp12_;
	GtkImage* _tmp13_;
	GtkLabel* title = NULL;
	PrintersJob* _tmp14_;
	const gchar* _tmp15_;
	const gchar* _tmp16_;
	GtkLabel* _tmp17_ = NULL;
	GtkLabel* _tmp18_ = NULL;
	GtkLabel* _tmp19_;
	PrintersJob* _tmp20_;
	GDateTime* _tmp21_;
	GDateTime* _tmp22_;
	gchar* _tmp23_;
	gchar* _tmp24_;
	GtkLabel* _tmp25_ = NULL;
	GtkLabel* _tmp26_;
	gchar* _tmp27_;
	GtkButton* _tmp28_ = NULL;
	GtkButton* _tmp29_;
	GtkButton* _tmp30_;
	GtkButton* _tmp31_;
	GtkButton* _tmp32_ = NULL;
	GtkSizeGroup* _tmp33_;
	GtkButton* _tmp34_;
	GtkBox* action_box = NULL;
	GtkBox* _tmp35_ = NULL;
	GtkBox* _tmp36_;
	GtkButton* _tmp37_;
	GtkBox* _tmp38_;
	GtkButton* _tmp39_;
	GtkBox* _tmp40_;
	GtkWidget* _tmp41_;
	GtkRevealer* _tmp42_ = NULL;
	GtkGrid* grid = NULL;
	GtkGrid* _tmp43_ = NULL;
	GtkGrid* _tmp44_;
	GtkOverlay* _tmp45_;
	GtkGrid* _tmp46_;
	GtkLabel* _tmp47_;
	GtkGrid* _tmp48_;
	GtkLabel* _tmp49_;
	GtkGrid* _tmp50_;
	GtkLabel* _tmp51_;
	GtkGrid* _tmp52_;
	GtkRevealer* _tmp53_;
	GtkGrid* _tmp54_;
	PrintersJob* _tmp55_;
	GtkButton* _tmp56_;
	GtkButton* _tmp57_;
	parent_class = G_OBJECT_CLASS (printers_job_row_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, PRINTERS_TYPE_JOB_ROW, PrintersJobRow);
	_data16_ = g_slice_new0 (Block16Data);
	_data16_->_ref_count_ = 1;
	_data16_->self = g_object_ref (self);
	_tmp0_ = self->priv->_job;
	_tmp1_ = printers_job_get_file_icon (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = (GtkImage*) gtk_image_new_from_gicon (_tmp2_);
	g_object_ref_sink (_tmp3_);
	_tmp4_ = _tmp3_;
	_g_object_unref0 (_tmp2_);
	icon = _tmp4_;
	_tmp5_ = icon;
	gtk_widget_add_css_class ((GtkWidget*) _tmp5_, GRANITE_STYLE_CLASS_LARGE_ICONS);
	_tmp6_ = self->priv->_job;
	_tmp7_ = printers_job_state_icon (_tmp6_);
	_tmp8_ = (GtkImage*) gtk_image_new ();
	g_object_set (_tmp8_, "gicon", _tmp7_, NULL);
	_g_object_unref0 (_tmp7_);
	gtk_widget_set_halign ((GtkWidget*) _tmp8_, GTK_ALIGN_END);
	gtk_widget_set_valign ((GtkWidget*) _tmp8_, GTK_ALIGN_END);
	g_object_ref_sink (_tmp8_);
	_g_object_unref0 (self->priv->job_state_icon);
	self->priv->job_state_icon = _tmp8_;
	_tmp9_ = icon;
	_tmp10_ = _g_object_ref0 ((GtkWidget*) _tmp9_);
	_tmp11_ = (GtkOverlay*) gtk_overlay_new ();
	gtk_overlay_set_child (_tmp11_, _tmp10_);
	_g_object_unref0 (_tmp10_);
	g_object_ref_sink (_tmp11_);
	icon_overlay = _tmp11_;
	_tmp12_ = icon_overlay;
	_tmp13_ = self->priv->job_state_icon;
	gtk_overlay_add_overlay (_tmp12_, (GtkWidget*) _tmp13_);
	_tmp14_ = self->priv->_job;
	_tmp15_ = printers_job_get_title (_tmp14_);
	_tmp16_ = _tmp15_;
	_tmp17_ = (GtkLabel*) gtk_label_new (_tmp16_);
	gtk_widget_set_halign ((GtkWidget*) _tmp17_, GTK_ALIGN_START);
	gtk_widget_set_hexpand ((GtkWidget*) _tmp17_, TRUE);
	gtk_label_set_ellipsize (_tmp17_, PANGO_ELLIPSIZE_END);
	g_object_ref_sink (_tmp17_);
	title = _tmp17_;
	_tmp18_ = (GtkLabel*) gtk_label_new ("");
	gtk_widget_set_halign ((GtkWidget*) _tmp18_, GTK_ALIGN_START);
	gtk_label_set_ellipsize (_tmp18_, PANGO_ELLIPSIZE_END);
	g_object_ref_sink (_tmp18_);
	_g_object_unref0 (self->priv->state_label);
	self->priv->state_label = _tmp18_;
	_tmp19_ = self->priv->state_label;
	gtk_widget_add_css_class ((GtkWidget*) _tmp19_, GRANITE_STYLE_CLASS_SMALL_LABEL);
	_tmp20_ = self->priv->_job;
	_tmp21_ = printers_job_get_creation_time (_tmp20_);
	_tmp22_ = _tmp21_;
	_tmp23_ = granite_date_time_get_relative_datetime (_tmp22_);
	_tmp24_ = _tmp23_;
	_tmp25_ = (GtkLabel*) gtk_label_new (_tmp24_);
	gtk_widget_set_halign ((GtkWidget*) _tmp25_, GTK_ALIGN_END);
	g_object_ref_sink (_tmp25_);
	_g_object_unref0 (self->priv->date_label);
	self->priv->date_label = _tmp25_;
	_g_free0 (_tmp24_);
	_tmp26_ = self->priv->date_label;
	gtk_widget_add_css_class ((GtkWidget*) _tmp26_, GRANITE_STYLE_CLASS_DIM_LABEL);
	_tmp27_ = g_strdup (_ ("Cancel"));
	_tmp28_ = (GtkButton*) gtk_button_new_from_icon_name ("process-stop-symbolic");
	gtk_widget_set_tooltip_text ((GtkWidget*) _tmp28_, _tmp27_);
	_g_free0 (_tmp27_);
	g_object_ref_sink (_tmp28_);
	_data16_->cancel_button = _tmp28_;
	_tmp29_ = _data16_->cancel_button;
	gtk_widget_add_css_class ((GtkWidget*) _tmp29_, GRANITE_STYLE_CLASS_FLAT);
	_tmp30_ = _data16_->cancel_button;
	gtk_widget_add_css_class ((GtkWidget*) _tmp30_, GRANITE_STYLE_CLASS_ACCENT);
	_tmp31_ = _data16_->cancel_button;
	gtk_widget_add_css_class ((GtkWidget*) _tmp31_, "red");
	_tmp32_ = (GtkButton*) gtk_button_new ();
	gtk_widget_set_valign ((GtkWidget*) _tmp32_, GTK_ALIGN_CENTER);
	g_object_ref_sink (_tmp32_);
	_g_object_unref0 (self->priv->start_pause_button);
	self->priv->start_pause_button = _tmp32_;
	_tmp33_ = printers_job_row_size_group;
	_tmp34_ = self->priv->start_pause_button;
	gtk_size_group_add_widget (_tmp33_, (GtkWidget*) _tmp34_);
	_tmp35_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 3);
	gtk_widget_set_margin_start ((GtkWidget*) _tmp35_, 6);
	g_object_ref_sink (_tmp35_);
	action_box = _tmp35_;
	_tmp36_ = action_box;
	_tmp37_ = _data16_->cancel_button;
	gtk_box_append (_tmp36_, (GtkWidget*) _tmp37_);
	_tmp38_ = action_box;
	_tmp39_ = self->priv->start_pause_button;
	gtk_box_append (_tmp38_, (GtkWidget*) _tmp39_);
	_tmp40_ = action_box;
	_tmp41_ = _g_object_ref0 ((GtkWidget*) _tmp40_);
	_tmp42_ = (GtkRevealer*) gtk_revealer_new ();
	gtk_revealer_set_transition_type (_tmp42_, GTK_REVEALER_TRANSITION_TYPE_SLIDE_LEFT);
	gtk_revealer_set_child (_tmp42_, _tmp41_);
	_g_object_unref0 (_tmp41_);
	g_object_ref_sink (_tmp42_);
	_g_object_unref0 (self->priv->action_revealer);
	self->priv->action_revealer = _tmp42_;
	_tmp43_ = (GtkGrid*) gtk_grid_new ();
	gtk_grid_set_column_spacing (_tmp43_, 6);
	g_object_ref_sink (_tmp43_);
	grid = _tmp43_;
	_tmp44_ = grid;
	_tmp45_ = icon_overlay;
	gtk_grid_attach (_tmp44_, (GtkWidget*) _tmp45_, 0, 0, 1, 2);
	_tmp46_ = grid;
	_tmp47_ = title;
	gtk_grid_attach (_tmp46_, (GtkWidget*) _tmp47_, 1, 0, 1, 1);
	_tmp48_ = grid;
	_tmp49_ = self->priv->state_label;
	gtk_grid_attach (_tmp48_, (GtkWidget*) _tmp49_, 1, 1, 1, 1);
	_tmp50_ = grid;
	_tmp51_ = self->priv->date_label;
	gtk_grid_attach (_tmp50_, (GtkWidget*) _tmp51_, 2, 0, 1, 2);
	_tmp52_ = grid;
	_tmp53_ = self->priv->action_revealer;
	gtk_grid_attach (_tmp52_, (GtkWidget*) _tmp53_, 3, 0, 1, 2);
	_tmp54_ = grid;
	gtk_list_box_row_set_child ((GtkListBoxRow*) self, (GtkWidget*) _tmp54_);
	printers_job_row_update_state (self);
	_tmp55_ = self->priv->_job;
	g_signal_connect_object (_tmp55_, "state-changed", (GCallback) _printers_job_row_update_state_printers_job_state_changed, self, 0);
	_tmp56_ = self->priv->start_pause_button;
	g_signal_connect_object (_tmp56_, "clicked", (GCallback) __printers_job_row___lambda6__gtk_button_clicked, self, 0);
	_tmp57_ = _data16_->cancel_button;
	g_signal_connect_data (_tmp57_, "clicked", (GCallback) __printers_job_row___lambda7__gtk_button_clicked, block16_data_ref (_data16_), (GClosureNotify) block16_data_unref, 0);
	_g_object_unref0 (grid);
	_g_object_unref0 (action_box);
	_g_object_unref0 (title);
	_g_object_unref0 (icon_overlay);
	_g_object_unref0 (icon);
	block16_data_unref (_data16_);
	_data16_ = NULL;
	return obj;
}

static void
printers_job_row_class_init (PrintersJobRowClass * klass,
                             gpointer klass_data)
{
	GtkSizeGroup* _tmp0_;
	printers_job_row_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &PrintersJobRow_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_printers_job_row_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_printers_job_row_set_property;
	G_OBJECT_CLASS (klass)->constructor = printers_job_row_constructor;
	G_OBJECT_CLASS (klass)->finalize = printers_job_row_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), PRINTERS_JOB_ROW_JOB_PROPERTY, printers_job_row_properties[PRINTERS_JOB_ROW_JOB_PROPERTY] = g_param_spec_object ("job", "job", "job", PRINTERS_TYPE_JOB, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PRINTERS_JOB_ROW_PRINTER_PROPERTY, printers_job_row_properties[PRINTERS_JOB_ROW_PRINTER_PROPERTY] = g_param_spec_object ("printer", "printer", "printer", PRINTERS_TYPE_PRINTER, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	_tmp0_ = gtk_size_group_new (GTK_SIZE_GROUP_HORIZONTAL);
	_g_object_unref0 (printers_job_row_size_group);
	printers_job_row_size_group = _tmp0_;
}

static void
printers_job_row_instance_init (PrintersJobRow * self,
                                gpointer klass)
{
	self->priv = printers_job_row_get_instance_private (self);
}

static void
printers_job_row_finalize (GObject * obj)
{
	PrintersJobRow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, PRINTERS_TYPE_JOB_ROW, PrintersJobRow);
	_g_object_unref0 (self->priv->_job);
	_g_object_unref0 (self->priv->_printer);
	_g_object_unref0 (self->priv->start_pause_button);
	_g_object_unref0 (self->priv->job_state_icon);
	_g_object_unref0 (self->priv->action_revealer);
	_g_object_unref0 (self->priv->date_label);
	_g_object_unref0 (self->priv->state_label);
	G_OBJECT_CLASS (printers_job_row_parent_class)->finalize (obj);
}

static GType
printers_job_row_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (PrintersJobRowClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) printers_job_row_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PrintersJobRow), 0, (GInstanceInitFunc) printers_job_row_instance_init, NULL };
	GType printers_job_row_type_id;
	printers_job_row_type_id = g_type_register_static (gtk_list_box_row_get_type (), "PrintersJobRow", &g_define_type_info, 0);
	PrintersJobRow_private_offset = g_type_add_instance_private (printers_job_row_type_id, sizeof (PrintersJobRowPrivate));
	return printers_job_row_type_id;
}

GType
printers_job_row_get_type (void)
{
	static volatile gsize printers_job_row_type_id__once = 0;
	if (g_once_init_enter (&printers_job_row_type_id__once)) {
		GType printers_job_row_type_id;
		printers_job_row_type_id = printers_job_row_get_type_once ();
		g_once_init_leave (&printers_job_row_type_id__once, printers_job_row_type_id);
	}
	return printers_job_row_type_id__once;
}

static void
_vala_printers_job_row_get_property (GObject * object,
                                     guint property_id,
                                     GValue * value,
                                     GParamSpec * pspec)
{
	PrintersJobRow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, PRINTERS_TYPE_JOB_ROW, PrintersJobRow);
	switch (property_id) {
		case PRINTERS_JOB_ROW_JOB_PROPERTY:
		g_value_set_object (value, printers_job_row_get_job (self));
		break;
		case PRINTERS_JOB_ROW_PRINTER_PROPERTY:
		g_value_set_object (value, printers_job_row_get_printer (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_printers_job_row_set_property (GObject * object,
                                     guint property_id,
                                     const GValue * value,
                                     GParamSpec * pspec)
{
	PrintersJobRow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, PRINTERS_TYPE_JOB_ROW, PrintersJobRow);
	switch (property_id) {
		case PRINTERS_JOB_ROW_JOB_PROPERTY:
		printers_job_row_set_job (self, g_value_get_object (value));
		break;
		case PRINTERS_JOB_ROW_PRINTER_PROPERTY:
		printers_job_row_set_printer (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

