/* PulseAudioManager.c generated by valac 0.56.17, the Vala compiler
 * generated from PulseAudioManager.vala, do not modify */

/* -*- Mode: vala; indent-tabs-mode: nil; tab-width: 4 -*-*/
/*-
 * Copyright (c) 2016-2018 elementary LLC. (https://elementary.io)
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301 USA.
 *
 * Authored by: Corentin Noël <corentin@elementary.io>
 */
/*
 * Vocabulary of PulseAudio:
 *  - Source: Input (microphone)
 *  - Sink: Output (speaker)
 */

#include "io.elementary.settings.sound.h"
#include <pulse/pulseaudio.h>
#include <gio/gio.h>
#include <pulse/glib-mainloop.h>
#include <glib.h>
#include <gee.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <float.h>
#include <math.h>
#include "pulse/ext-stream-restore.h"

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	SOUND_PULSE_AUDIO_MANAGER_0_PROPERTY,
	SOUND_PULSE_AUDIO_MANAGER_CONTEXT_PROPERTY,
	SOUND_PULSE_AUDIO_MANAGER_APPS_PROPERTY,
	SOUND_PULSE_AUDIO_MANAGER_DEFAULT_OUTPUT_PROPERTY,
	SOUND_PULSE_AUDIO_MANAGER_DEFAULT_INPUT_PROPERTY,
	SOUND_PULSE_AUDIO_MANAGER_NUM_PROPERTIES
};
static GParamSpec* sound_pulse_audio_manager_properties[SOUND_PULSE_AUDIO_MANAGER_NUM_PROPERTIES];
#define _pa_context_unref0(var) ((var == NULL) ? NULL : (var = (pa_context_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _pa_glib_mainloop_free0(var) ((var == NULL) ? NULL : (var = (pa_glib_mainloop_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _SoundPulseAudioManagerSetDefaultDeviceData SoundPulseAudioManagerSetDefaultDeviceData;
typedef struct _Block4Data Block4Data;
#define _pa_operation_unref0(var) ((var == NULL) ? NULL : (var = (pa_operation_unref (var), NULL)))
typedef struct _SoundPulseAudioManagerSetCardProfileByIndexData SoundPulseAudioManagerSetCardProfileByIndexData;
typedef struct _Block5Data Block5Data;
typedef struct _SoundPulseAudioManagerWaitForUpdateData SoundPulseAudioManagerWaitForUpdateData;
typedef struct _Block6Data Block6Data;
typedef struct _SoundPulseAudioManagerSetSinkPortByNameData SoundPulseAudioManagerSetSinkPortByNameData;
typedef struct _Block7Data Block7Data;
typedef struct _SoundPulseAudioManagerSetSourcePortByNameData SoundPulseAudioManagerSetSourcePortByNameData;
typedef struct _Block8Data Block8Data;
typedef struct _SoundPulseAudioManagerSetDefaultSinkData SoundPulseAudioManagerSetDefaultSinkData;
typedef struct _Block9Data Block9Data;
typedef struct _SoundPulseAudioManagerSetDefaultSourceData SoundPulseAudioManagerSetDefaultSourceData;
typedef struct _Block10Data Block10Data;
#define _pa_proplist_free0(var) ((var == NULL) ? NULL : (var = (pa_proplist_free (var), NULL)))
typedef struct _SoundPulseAudioManagerReconnectToPulseData SoundPulseAudioManagerReconnectToPulseData;
typedef struct _Block11Data Block11Data;
typedef struct _Block12Data Block12Data;
typedef struct _Block13Data Block13Data;
typedef struct _Block14Data Block14Data;
enum  {
	SOUND_PULSE_AUDIO_MANAGER_NEW_DEVICE_SIGNAL,
	SOUND_PULSE_AUDIO_MANAGER_NUM_SIGNALS
};
static guint sound_pulse_audio_manager_signals[SOUND_PULSE_AUDIO_MANAGER_NUM_SIGNALS] = {0};

struct _SoundPulseAudioManagerPrivate {
	pa_context* _context;
	GListStore* _apps;
	pa_glib_mainloop* loop;
	gboolean is_ready;
	guint reconnect_timer_id;
	GeeHashMap* input_devices;
	GeeHashMap* output_devices;
	SoundDevice* _default_output;
	SoundDevice* _default_input;
	gchar* default_source_name;
	gchar* default_sink_name;
	GeeHashMap* volume_operations;
};

struct _SoundPulseAudioManagerSetDefaultDeviceData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	SoundPulseAudioManager* self;
	SoundDevice* device;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	gboolean _tmp3_;
	gboolean _tmp4_;
	SoundDevice* _tmp5_;
	gboolean _tmp6_;
	gboolean _tmp7_;
	SoundDevice* _tmp8_;
	SoundDevice* _tmp9_;
	SoundDevice* other_device;
	SoundDevice* _tmp10_;
	gchar* profile_name;
	SoundDevice* _tmp11_;
	gchar* _tmp12_;
	const gchar* _tmp13_;
	GeeArrayList* _tmp14_;
	GeeArrayList* _tmp15_;
	gpointer _tmp16_;
	const gchar* _tmp17_;
	const gchar* _tmp18_;
	const gchar* _tmp19_;
	const gchar* _tmp20_;
	const gchar* _tmp21_;
	const gchar* _tmp22_;
	guint32 _tmp23_;
	guint32 _tmp24_;
	const gchar* _tmp25_;
	const gchar* _tmp26_;
	gboolean _tmp27_;
	gboolean _tmp28_;
	gboolean _tmp29_;
	gboolean _tmp30_;
	gboolean _tmp31_;
	const gchar* _tmp32_;
	const gchar* _tmp33_;
	const gchar* _tmp34_;
	const gchar* _tmp35_;
	const gchar* _tmp36_;
	const gchar* _tmp37_;
	const gchar* _tmp38_;
	const gchar* _tmp39_;
	const gchar* _tmp40_;
	const gchar* _tmp41_;
	const gchar* _tmp42_;
	const gchar* _tmp43_;
	gboolean _tmp44_;
	gboolean _tmp45_;
	gboolean _tmp46_;
	const gchar* _tmp47_;
	const gchar* _tmp48_;
	const gchar* _tmp49_;
	const gchar* _tmp50_;
	const gchar* _tmp51_;
	const gchar* _tmp52_;
	const gchar* _tmp53_;
	const gchar* _tmp54_;
	const gchar* _tmp55_;
	const gchar* _tmp56_;
	const gchar* _tmp57_;
	const gchar* _tmp58_;
	gboolean _tmp59_;
	gboolean _tmp60_;
	gboolean _tmp61_;
	gboolean _tmp62_;
	const gchar* _tmp63_;
	const gchar* _tmp64_;
	gboolean _tmp65_;
	gboolean _tmp66_;
	gboolean _tmp67_;
	const gchar* _tmp68_;
	const gchar* _tmp69_;
	const gchar* _tmp70_;
	gboolean _tmp71_;
	gboolean _tmp72_;
	gboolean _tmp73_;
	gboolean _tmp74_;
	gboolean _tmp75_;
	const gchar* _tmp76_;
	const gchar* _tmp77_;
	const gchar* _tmp78_;
	const gchar* _tmp79_;
	const gchar* _tmp80_;
	const gchar* _tmp81_;
	const gchar* _tmp82_;
	const gchar* _tmp83_;
	gboolean _tmp84_;
	gboolean _tmp85_;
	gboolean _tmp86_;
	const gchar* _tmp87_;
	const gchar* _tmp88_;
	const gchar* _tmp89_;
	const gchar* _tmp90_;
	const gchar* _tmp91_;
	const gchar* _tmp92_;
	const gchar* _tmp93_;
	const gchar* _tmp94_;
};

struct _Block4Data {
	int _ref_count_;
	SoundPulseAudioManager* self;
	guint32 card_index;
	gchar* profile_name;
	gpointer _async_data_;
};

struct _SoundPulseAudioManagerSetCardProfileByIndexData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	SoundPulseAudioManager* self;
	guint32 card_index;
	gchar* profile_name;
	Block4Data* _data4_;
	pa_context* _tmp0_;
	pa_operation* _tmp1_;
	pa_operation* _tmp2_;
};

struct _Block5Data {
	int _ref_count_;
	SoundPulseAudioManager* self;
	gulong handler_id;
	SoundDevice* device;
	gchar* prop_name;
	gpointer _async_data_;
};

struct _SoundPulseAudioManagerWaitForUpdateData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	SoundPulseAudioManager* self;
	SoundDevice* device;
	gchar* prop_name;
	Block5Data* _data5_;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gulong _tmp3_;
};

struct _Block6Data {
	int _ref_count_;
	SoundPulseAudioManager* self;
	gchar* sink_name;
	gchar* port_name;
	gpointer _async_data_;
};

struct _SoundPulseAudioManagerSetSinkPortByNameData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	SoundPulseAudioManager* self;
	gchar* sink_name;
	gchar* port_name;
	Block6Data* _data6_;
	pa_context* _tmp0_;
	pa_operation* _tmp1_;
	pa_operation* _tmp2_;
};

struct _Block7Data {
	int _ref_count_;
	SoundPulseAudioManager* self;
	gchar* source_name;
	gchar* port_name;
	gpointer _async_data_;
};

struct _SoundPulseAudioManagerSetSourcePortByNameData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	SoundPulseAudioManager* self;
	gchar* source_name;
	gchar* port_name;
	Block7Data* _data7_;
	pa_context* _tmp0_;
	pa_operation* _tmp1_;
	pa_operation* _tmp2_;
};

struct _Block8Data {
	int _ref_count_;
	SoundPulseAudioManager* self;
	gchar* sink_name;
	gpointer _async_data_;
};

struct _SoundPulseAudioManagerSetDefaultSinkData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	SoundPulseAudioManager* self;
	gchar* sink_name;
	Block8Data* _data8_;
	pa_context* _tmp0_;
	pa_operation* _tmp1_;
	pa_operation* _tmp2_;
};

struct _Block9Data {
	int _ref_count_;
	SoundPulseAudioManager* self;
	gchar* source_name;
	gpointer _async_data_;
};

struct _SoundPulseAudioManagerSetDefaultSourceData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	SoundPulseAudioManager* self;
	gchar* source_name;
	Block9Data* _data9_;
	pa_context* _tmp0_;
	pa_operation* _tmp1_;
	pa_operation* _tmp2_;
};

struct _Block10Data {
	int _ref_count_;
	SoundPulseAudioManager* self;
	SoundDevice* device;
};

struct _SoundPulseAudioManagerReconnectToPulseData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	SoundPulseAudioManager* self;
	pa_context* _tmp0_;
	pa_proplist* props;
	pa_proplist* _tmp1_;
	pa_proplist* _tmp2_;
	pa_glib_mainloop* _tmp3_;
	pa_mainloop_api* _tmp4_;
	pa_proplist* _tmp5_;
	pa_context* _tmp6_;
	pa_context* _tmp7_;
	pa_context* _tmp8_;
	pa_context* _tmp9_;
	pa_context* _tmp10_;
	const gchar* _tmp11_;
};

struct _Block11Data {
	int _ref_count_;
	SoundPulseAudioManager* self;
	SoundDevice* device;
};

struct _Block12Data {
	int _ref_count_;
	SoundPulseAudioManager* self;
	SoundDevice* device;
};

struct _Block13Data {
	int _ref_count_;
	SoundPulseAudioManager* self;
	SoundApp* app;
};

struct _Block14Data {
	int _ref_count_;
	SoundPulseAudioManager* self;
	SoundApp* app;
};

static gint SoundPulseAudioManager_private_offset;
static gpointer sound_pulse_audio_manager_parent_class = NULL;
static SoundPulseAudioManager* sound_pulse_audio_manager_pam;
static SoundPulseAudioManager* sound_pulse_audio_manager_pam = NULL;
static gboolean sound_pulse_audio_manager_debug_enabled;
static gboolean sound_pulse_audio_manager_debug_enabled = FALSE;

static SoundPulseAudioManager* sound_pulse_audio_manager_new (void);
static SoundPulseAudioManager* sound_pulse_audio_manager_construct (GType object_type);
static void sound_pulse_audio_manager_reconnect_to_pulse (SoundPulseAudioManager* self,
                                                   GAsyncReadyCallback _callback_,
                                                   gpointer _user_data_);
static void sound_pulse_audio_manager_reconnect_to_pulse_finish (SoundPulseAudioManager* self,
                                                          GAsyncResult* _res_);
static void sound_pulse_audio_manager_set_default_device_data_free (gpointer _data);
static gboolean sound_pulse_audio_manager_set_default_device_co (SoundPulseAudioManagerSetDefaultDeviceData* _data_);
static void sound_pulse_audio_manager_set_card_profile_by_index (SoundPulseAudioManager* self,
                                                          guint32 card_index,
                                                          const gchar* profile_name,
                                                          GAsyncReadyCallback _callback_,
                                                          gpointer _user_data_);
static void sound_pulse_audio_manager_set_card_profile_by_index_finish (SoundPulseAudioManager* self,
                                                                 GAsyncResult* _res_);
static void sound_pulse_audio_manager_set_default_device_ready (GObject* source_object,
                                                         GAsyncResult* _res_,
                                                         gpointer _user_data_);
static void sound_pulse_audio_manager_wait_for_update (SoundPulseAudioManager* self,
                                                SoundDevice* device,
                                                const gchar* prop_name,
                                                GAsyncReadyCallback _callback_,
                                                gpointer _user_data_);
static void sound_pulse_audio_manager_wait_for_update_finish (SoundPulseAudioManager* self,
                                                       GAsyncResult* _res_);
static void sound_pulse_audio_manager_set_sink_port_by_name (SoundPulseAudioManager* self,
                                                      const gchar* sink_name,
                                                      const gchar* port_name,
                                                      GAsyncReadyCallback _callback_,
                                                      gpointer _user_data_);
static void sound_pulse_audio_manager_set_sink_port_by_name_finish (SoundPulseAudioManager* self,
                                                             GAsyncResult* _res_);
static void sound_pulse_audio_manager_set_source_port_by_name (SoundPulseAudioManager* self,
                                                        const gchar* source_name,
                                                        const gchar* port_name,
                                                        GAsyncReadyCallback _callback_,
                                                        gpointer _user_data_);
static void sound_pulse_audio_manager_set_source_port_by_name_finish (SoundPulseAudioManager* self,
                                                               GAsyncResult* _res_);
static void sound_pulse_audio_manager_set_default_sink (SoundPulseAudioManager* self,
                                                 const gchar* sink_name,
                                                 GAsyncReadyCallback _callback_,
                                                 gpointer _user_data_);
static void sound_pulse_audio_manager_set_default_sink_finish (SoundPulseAudioManager* self,
                                                        GAsyncResult* _res_);
static void sound_pulse_audio_manager_set_default_source (SoundPulseAudioManager* self,
                                                   const gchar* source_name,
                                                   GAsyncReadyCallback _callback_,
                                                   gpointer _user_data_);
static void sound_pulse_audio_manager_set_default_source_finish (SoundPulseAudioManager* self,
                                                          GAsyncResult* _res_);
static void sound_pulse_audio_manager_set_card_profile_by_index_data_free (gpointer _data);
static gboolean sound_pulse_audio_manager_set_card_profile_by_index_co (SoundPulseAudioManagerSetCardProfileByIndexData* _data_);
static Block4Data* block4_data_ref (Block4Data* _data4_);
static void block4_data_unref (void * _userdata_);
static void __lambda8_ (Block4Data* _data4_,
                 pa_context* c,
                 gint success);
static void ___lambda8__pa_context_success_cb_t (pa_context* c,
                                          gint success,
                                          gpointer self);
static void sound_pulse_audio_manager_wait_for_update_data_free (gpointer _data);
static gboolean sound_pulse_audio_manager_wait_for_update_co (SoundPulseAudioManagerWaitForUpdateData* _data_);
static Block5Data* block5_data_ref (Block5Data* _data5_);
static void block5_data_unref (void * _userdata_);
static void __lambda9_ (Block5Data* _data5_,
                 GObject* s,
                 GParamSpec* p);
static void ___lambda9__g_object_notify (GObject* _sender,
                                  GParamSpec* pspec,
                                  gpointer self);
static void sound_pulse_audio_manager_set_sink_port_by_name_data_free (gpointer _data);
static gboolean sound_pulse_audio_manager_set_sink_port_by_name_co (SoundPulseAudioManagerSetSinkPortByNameData* _data_);
static Block6Data* block6_data_ref (Block6Data* _data6_);
static void block6_data_unref (void * _userdata_);
static void __lambda10_ (Block6Data* _data6_,
                  pa_context* c,
                  gint success);
static void ___lambda10__pa_context_success_cb_t (pa_context* c,
                                           gint success,
                                           gpointer self);
static void sound_pulse_audio_manager_set_source_port_by_name_data_free (gpointer _data);
static gboolean sound_pulse_audio_manager_set_source_port_by_name_co (SoundPulseAudioManagerSetSourcePortByNameData* _data_);
static Block7Data* block7_data_ref (Block7Data* _data7_);
static void block7_data_unref (void * _userdata_);
static void __lambda11_ (Block7Data* _data7_,
                  pa_context* c,
                  gint success);
static void ___lambda11__pa_context_success_cb_t (pa_context* c,
                                           gint success,
                                           gpointer self);
static void sound_pulse_audio_manager_set_default_sink_data_free (gpointer _data);
static gboolean sound_pulse_audio_manager_set_default_sink_co (SoundPulseAudioManagerSetDefaultSinkData* _data_);
static Block8Data* block8_data_ref (Block8Data* _data8_);
static void block8_data_unref (void * _userdata_);
static void __lambda12_ (Block8Data* _data8_,
                  pa_context* c,
                  gint success);
static void ___lambda12__pa_context_success_cb_t (pa_context* c,
                                           gint success,
                                           gpointer self);
static void sound_pulse_audio_manager_set_default_source_data_free (gpointer _data);
static gboolean sound_pulse_audio_manager_set_default_source_co (SoundPulseAudioManagerSetDefaultSourceData* _data_);
static Block9Data* block9_data_ref (Block9Data* _data9_);
static void block9_data_unref (void * _userdata_);
static void __lambda13_ (Block9Data* _data9_,
                  pa_context* c,
                  gint success);
static void ___lambda13__pa_context_success_cb_t (pa_context* c,
                                           gint success,
                                           gpointer self);
static Block10Data* block10_data_ref (Block10Data* _data10_);
static void block10_data_unref (void * _userdata_);
static gboolean __lambda14_ (Block10Data* _data10_,
                      pa_operation* operation);
static gboolean ___lambda14__gee_forall_func (gpointer g,
                                       gpointer self);
static pa_volume_t sound_pulse_audio_manager_double_to_volume (gdouble vol);
static gboolean sound_pulse_audio_manager_reconnect_timeout (SoundPulseAudioManager* self);
static void sound_pulse_audio_manager_reconnect_to_pulse_data_free (gpointer _data);
static gboolean sound_pulse_audio_manager_reconnect_to_pulse_co (SoundPulseAudioManagerReconnectToPulseData* _data_);
static void sound_pulse_audio_manager_set_context (SoundPulseAudioManager* self,
                                            pa_context* value);
static void sound_pulse_audio_manager_context_state_callback (SoundPulseAudioManager* self,
                                                       pa_context* c);
static void _sound_pulse_audio_manager_context_state_callback_pa_context_notify_cb_t (pa_context* c,
                                                                               gpointer self);
static void sound_pulse_audio_manager_subscribe_callback (SoundPulseAudioManager* self,
                                                   pa_context* c,
                                                   pa_subscription_event_type_t t,
                                                   guint32 index);
static void _sound_pulse_audio_manager_subscribe_callback_pa_context_subscribe_cb_t (pa_context* c,
                                                                              pa_subscription_event_type_t t,
                                                                              guint32 idx,
                                                                              gpointer self);
static void sound_pulse_audio_manager_server_info_callback (SoundPulseAudioManager* self,
                                                     pa_context* context,
                                                     pa_server_info* server);
static void _sound_pulse_audio_manager_server_info_callback_pa_server_info_cb_t (pa_context* c,
                                                                          pa_server_info* i,
                                                                          gpointer self);
static void sound_pulse_audio_manager_sink_input_info_callback (SoundPulseAudioManager* self,
                                                         pa_context* c,
                                                         pa_sink_input_info* sink_input,
                                                         gint eol);
static void _sound_pulse_audio_manager_sink_input_info_callback_pa_sink_input_info_cb_t (pa_context* c,
                                                                                  pa_sink_input_info* i,
                                                                                  gint eol,
                                                                                  gpointer self);
static gboolean _sound_pulse_audio_manager_reconnect_timeout_gsource_func (gpointer self);
static void sound_pulse_audio_manager_sink_info_callback (SoundPulseAudioManager* self,
                                                   pa_context* c,
                                                   pa_sink_info* sink,
                                                   gint eol);
static void _sound_pulse_audio_manager_sink_info_callback_pa_sink_info_cb_t (pa_context* c,
                                                                      pa_sink_info* i,
                                                                      gint eol,
                                                                      gpointer self);
static void sound_pulse_audio_manager_card_info_callback (SoundPulseAudioManager* self,
                                                   pa_context* c,
                                                   pa_card_info* card,
                                                   gint eol);
static void _sound_pulse_audio_manager_card_info_callback_pa_card_info_cb_t (pa_context* c,
                                                                      pa_card_info* i,
                                                                      gint eol,
                                                                      gpointer self);
static void sound_pulse_audio_manager_remove_devices_by_card (SoundPulseAudioManager* self,
                                                       GeeHashMap* devices,
                                                       guint32 card_index);
static void sound_pulse_audio_manager_source_info_callback (SoundPulseAudioManager* self,
                                                     pa_context* c,
                                                     pa_source_info* source,
                                                     gint eol);
static void _sound_pulse_audio_manager_source_info_callback_pa_source_info_cb_t (pa_context* c,
                                                                          pa_source_info* i,
                                                                          gint eol,
                                                                          gpointer self);
static Block11Data* block11_data_ref (Block11Data* _data11_);
static void block11_data_unref (void * _userdata_);
static gboolean ______lambda7_ (Block11Data* _data11_,
                         pa_operation* operation);
static gboolean _______lambda7__gee_forall_func (gpointer g,
                                          gpointer self);
static gdouble sound_pulse_audio_manager_volume_to_double (pa_volume_t vol);
static void sound_pulse_audio_manager_set_default_input (SoundPulseAudioManager* self,
                                                  SoundDevice* value);
static Block12Data* block12_data_ref (Block12Data* _data12_);
static void block12_data_unref (void * _userdata_);
static gboolean ______lambda4_ (Block12Data* _data12_,
                         pa_operation* operation);
static gboolean _______lambda4__gee_forall_func (gpointer g,
                                          gpointer self);
static void sound_pulse_audio_manager_set_default_output (SoundPulseAudioManager* self,
                                                   SoundDevice* value);
static void _vala_array_add1 (pa_card_port_info** * array,
                       gint* length,
                       gint* size,
                       pa_card_port_info* value);
static gchar* sound_pulse_audio_manager_get_device_id (pa_card_info* card,
                                                pa_card_port_info* port);
static GeeArrayList* sound_pulse_audio_manager_get_relevant_card_port_profiles (SoundPulseAudioManager* self,
                                                                         pa_card_port_info* port);
static void sound_pulse_audio_manager_cleanup_devices (SoundPulseAudioManager* self,
                                                GeeHashMap* devices,
                                                pa_card_info* card,
                                                pa_card_port_info** relevant_ports,
                                                gint relevant_ports_length1);
static pa_card_profile_info2** _vala_array_dup1 (pa_card_profile_info2** self,
                                          gssize length);
static gint __lambda6_ (SoundPulseAudioManager* self,
                 pa_card_profile_info2* a,
                 pa_card_profile_info2* b);
static gint ___lambda6__gcompare_data_func (gconstpointer a,
                                     gconstpointer b,
                                     gpointer self);
static void sound_pulse_audio_manager_ext_stream_restore_read_sink_callback (SoundPulseAudioManager* self,
                                                                      pa_context* c,
                                                                      pa_ext_stream_restore_info* info,
                                                                      gint eol);
static void _sound_pulse_audio_manager_ext_stream_restore_read_sink_callback_pulse_audio_ext_stream_restore_read_cb (pa_context* c,
                                                                                                              pa_ext_stream_restore_info* info,
                                                                                                              gint eol,
                                                                                                              gpointer self);
static void sound_pulse_audio_manager_ext_stream_restore_read_source_callback (SoundPulseAudioManager* self,
                                                                        pa_context* c,
                                                                        pa_ext_stream_restore_info* info,
                                                                        gint eol);
static void _sound_pulse_audio_manager_ext_stream_restore_read_source_callback_pulse_audio_ext_stream_restore_read_cb (pa_context* c,
                                                                                                                pa_ext_stream_restore_info* info,
                                                                                                                gint eol,
                                                                                                                gpointer self);
static void __lambda5_ (SoundPulseAudioManager* self,
                 pa_context* c,
                 gint success);
static void ___lambda5__pa_context_success_cb_t (pa_context* c,
                                          gint success,
                                          gpointer self);
static Block13Data* block13_data_ref (Block13Data* _data13_);
static void block13_data_unref (void * _userdata_);
static void __lambda15_ (Block13Data* _data13_,
                  pa_context* c,
                  gint success);
static void ___lambda15__pa_context_success_cb_t (pa_context* c,
                                           gint success,
                                           gpointer self);
static Block14Data* block14_data_ref (Block14Data* _data14_);
static void block14_data_unref (void * _userdata_);
static void __lambda16_ (Block14Data* _data14_,
                  pa_context* c,
                  gint success);
static void ___lambda16__pa_context_success_cb_t (pa_context* c,
                                           gint success,
                                           gpointer self);
static GObject * sound_pulse_audio_manager_constructor (GType type,
                                                 guint n_construct_properties,
                                                 GObjectConstructParam * construct_properties);
static gboolean _vala_string_array_contains (gchar* * stack,
                                      gssize stack_length,
                                      const gchar* needle);
static void sound_pulse_audio_manager_finalize (GObject * obj);
static GType sound_pulse_audio_manager_get_type_once (void);
static void _vala_sound_pulse_audio_manager_get_property (GObject * object,
                                                   guint property_id,
                                                   GValue * value,
                                                   GParamSpec * pspec);
static void _vala_sound_pulse_audio_manager_set_property (GObject * object,
                                                   guint property_id,
                                                   const GValue * value,
                                                   GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static inline gpointer
sound_pulse_audio_manager_get_instance_private (SoundPulseAudioManager* self)
{
	return G_STRUCT_MEMBER_P (self, SoundPulseAudioManager_private_offset);
}

SoundPulseAudioManager*
sound_pulse_audio_manager_get_default (void)
{
	SoundPulseAudioManager* _tmp0_;
	SoundPulseAudioManager* _tmp2_;
	SoundPulseAudioManager* result;
	_tmp0_ = sound_pulse_audio_manager_pam;
	if (_tmp0_ == NULL) {
		SoundPulseAudioManager* _tmp1_;
		_tmp1_ = sound_pulse_audio_manager_new ();
		_g_object_unref0 (sound_pulse_audio_manager_pam);
		sound_pulse_audio_manager_pam = _tmp1_;
	}
	_tmp2_ = sound_pulse_audio_manager_pam;
	result = _tmp2_;
	return result;
}

static SoundPulseAudioManager*
sound_pulse_audio_manager_construct (GType object_type)
{
	SoundPulseAudioManager * self = NULL;
	self = (SoundPulseAudioManager*) g_object_new (object_type, NULL);
	return self;
}

static SoundPulseAudioManager*
sound_pulse_audio_manager_new (void)
{
	return sound_pulse_audio_manager_construct (SOUND_TYPE_PULSE_AUDIO_MANAGER);
}

void
sound_pulse_audio_manager_start (SoundPulseAudioManager* self)
{
	g_return_if_fail (self != NULL);
	sound_pulse_audio_manager_reconnect_to_pulse (self, NULL, NULL);
}

static void
sound_pulse_audio_manager_set_default_device_data_free (gpointer _data)
{
	SoundPulseAudioManagerSetDefaultDeviceData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->device);
	_g_object_unref0 (_data_->self);
	g_slice_free (SoundPulseAudioManagerSetDefaultDeviceData, _data_);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

void
sound_pulse_audio_manager_set_default_device (SoundPulseAudioManager* self,
                                              SoundDevice* device,
                                              GAsyncReadyCallback _callback_,
                                              gpointer _user_data_)
{
	SoundPulseAudioManagerSetDefaultDeviceData* _data_;
	SoundPulseAudioManager* _tmp0_;
	SoundDevice* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (device != NULL);
	_data_ = g_slice_new0 (SoundPulseAudioManagerSetDefaultDeviceData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, sound_pulse_audio_manager_set_default_device_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (device);
	_g_object_unref0 (_data_->device);
	_data_->device = _tmp1_;
	sound_pulse_audio_manager_set_default_device_co (_data_);
}

void
sound_pulse_audio_manager_set_default_device_finish (SoundPulseAudioManager* self,
                                                     GAsyncResult* _res_)
{
	SoundPulseAudioManagerSetDefaultDeviceData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static void
sound_pulse_audio_manager_set_default_device_ready (GObject* source_object,
                                                    GAsyncResult* _res_,
                                                    gpointer _user_data_)
{
	SoundPulseAudioManagerSetDefaultDeviceData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	sound_pulse_audio_manager_set_default_device_co (_data_);
}

static gboolean
sound_pulse_audio_manager_set_default_device_co (SoundPulseAudioManagerSetDefaultDeviceData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		case 3:
		goto _state_3;
		case 4:
		goto _state_4;
		case 5:
		goto _state_5;
		case 6:
		goto _state_6;
		case 7:
		goto _state_7;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	g_debug ("PulseAudioManager.vala:80: \n");
	_data_->_tmp0_ = sound_device_get_id (_data_->device);
	_data_->_tmp1_ = _data_->_tmp0_;
	g_debug ("PulseAudioManager.vala:81: set_default_device: %s", _data_->_tmp1_);
	_data_->_tmp3_ = sound_device_get_input (_data_->device);
	_data_->_tmp4_ = _data_->_tmp3_;
	if (_data_->_tmp4_) {
		_data_->_tmp2_ = "input";
	} else {
		_data_->_tmp2_ = "output";
	}
	g_debug ("PulseAudioManager.vala:82: \t%s", _data_->_tmp2_);
	_data_->_tmp6_ = sound_device_get_input (_data_->device);
	_data_->_tmp7_ = _data_->_tmp6_;
	if (_data_->_tmp7_) {
		_data_->_tmp8_ = _data_->self->priv->_default_output;
		_data_->_tmp5_ = _data_->_tmp8_;
	} else {
		_data_->_tmp9_ = _data_->self->priv->_default_input;
		_data_->_tmp5_ = _data_->_tmp9_;
	}
	_data_->_tmp10_ = _g_object_ref0 (_data_->_tmp5_);
	_data_->other_device = _data_->_tmp10_;
	_data_->_tmp11_ = _data_->other_device;
	_data_->_tmp12_ = sound_device_get_matching_profile (_data_->device, _data_->_tmp11_);
	_data_->profile_name = _data_->_tmp12_;
	_data_->_tmp13_ = _data_->profile_name;
	if (_data_->_tmp13_ == NULL) {
		_data_->_tmp14_ = sound_device_get_profiles (_data_->device);
		_data_->_tmp15_ = _data_->_tmp14_;
		_data_->_tmp16_ = gee_abstract_list_get ((GeeAbstractList*) _data_->_tmp15_, 0);
		_g_free0 (_data_->profile_name);
		_data_->profile_name = (gchar*) _data_->_tmp16_;
	}
	_data_->_tmp17_ = _data_->profile_name;
	_data_->_tmp18_ = sound_device_get_card_active_profile_name (_data_->device);
	_data_->_tmp19_ = _data_->_tmp18_;
	if (g_strcmp0 (_data_->_tmp17_, _data_->_tmp19_) != 0) {
		_data_->_tmp20_ = sound_device_get_card_active_profile_name (_data_->device);
		_data_->_tmp21_ = _data_->_tmp20_;
		_data_->_tmp22_ = _data_->profile_name;
		g_debug ("PulseAudioManager.vala:97: set card profile: %s > %s", _data_->_tmp21_, _data_->_tmp22_);
		_data_->_tmp23_ = sound_device_get_card_index (_data_->device);
		_data_->_tmp24_ = _data_->_tmp23_;
		_data_->_tmp25_ = _data_->profile_name;
		_data_->_state_ = 1;
		sound_pulse_audio_manager_set_card_profile_by_index (_data_->self, _data_->_tmp24_, _data_->_tmp25_, sound_pulse_audio_manager_set_default_device_ready, _data_);
		return FALSE;
		_state_1:
		sound_pulse_audio_manager_set_card_profile_by_index_finish (_data_->self, _data_->_res_);
		g_debug ("PulseAudioManager.vala:101: wait for card sink / source");
		_data_->_tmp27_ = sound_device_get_input (_data_->device);
		_data_->_tmp28_ = _data_->_tmp27_;
		if (_data_->_tmp28_) {
			_data_->_tmp26_ = "card-source-name";
		} else {
			_data_->_tmp26_ = "card-sink-name";
		}
		_data_->_state_ = 2;
		sound_pulse_audio_manager_wait_for_update (_data_->self, _data_->device, _data_->_tmp26_, sound_pulse_audio_manager_set_default_device_ready, _data_);
		return FALSE;
		_state_2:
		sound_pulse_audio_manager_wait_for_update_finish (_data_->self, _data_->_res_);
	}
	_data_->_tmp30_ = sound_device_get_input (_data_->device);
	_data_->_tmp31_ = _data_->_tmp30_;
	if (!_data_->_tmp31_) {
		_data_->_tmp32_ = sound_device_get_port_name (_data_->device);
		_data_->_tmp33_ = _data_->_tmp32_;
		_data_->_tmp34_ = sound_device_get_card_sink_port_name (_data_->device);
		_data_->_tmp35_ = _data_->_tmp34_;
		_data_->_tmp29_ = g_strcmp0 (_data_->_tmp33_, _data_->_tmp35_) != 0;
	} else {
		_data_->_tmp29_ = FALSE;
	}
	if (_data_->_tmp29_) {
		_data_->_tmp36_ = sound_device_get_card_sink_port_name (_data_->device);
		_data_->_tmp37_ = _data_->_tmp36_;
		_data_->_tmp38_ = sound_device_get_port_name (_data_->device);
		_data_->_tmp39_ = _data_->_tmp38_;
		g_debug ("PulseAudioManager.vala:108: set sink port: %s > %s", _data_->_tmp37_, _data_->_tmp39_);
		_data_->_tmp40_ = sound_device_get_card_sink_name (_data_->device);
		_data_->_tmp41_ = _data_->_tmp40_;
		_data_->_tmp42_ = sound_device_get_port_name (_data_->device);
		_data_->_tmp43_ = _data_->_tmp42_;
		_data_->_state_ = 3;
		sound_pulse_audio_manager_set_sink_port_by_name (_data_->self, _data_->_tmp41_, _data_->_tmp43_, sound_pulse_audio_manager_set_default_device_ready, _data_);
		return FALSE;
		_state_3:
		sound_pulse_audio_manager_set_sink_port_by_name_finish (_data_->self, _data_->_res_);
	}
	_data_->_tmp45_ = sound_device_get_input (_data_->device);
	_data_->_tmp46_ = _data_->_tmp45_;
	if (_data_->_tmp46_) {
		_data_->_tmp47_ = sound_device_get_port_name (_data_->device);
		_data_->_tmp48_ = _data_->_tmp47_;
		_data_->_tmp49_ = sound_device_get_card_source_port_name (_data_->device);
		_data_->_tmp50_ = _data_->_tmp49_;
		_data_->_tmp44_ = g_strcmp0 (_data_->_tmp48_, _data_->_tmp50_) != 0;
	} else {
		_data_->_tmp44_ = FALSE;
	}
	if (_data_->_tmp44_) {
		_data_->_tmp51_ = sound_device_get_card_source_port_name (_data_->device);
		_data_->_tmp52_ = _data_->_tmp51_;
		_data_->_tmp53_ = sound_device_get_port_name (_data_->device);
		_data_->_tmp54_ = _data_->_tmp53_;
		g_debug ("PulseAudioManager.vala:114: set source port: %s > %s", _data_->_tmp52_, _data_->_tmp54_);
		_data_->_tmp55_ = sound_device_get_card_source_name (_data_->device);
		_data_->_tmp56_ = _data_->_tmp55_;
		_data_->_tmp57_ = sound_device_get_port_name (_data_->device);
		_data_->_tmp58_ = _data_->_tmp57_;
		_data_->_state_ = 4;
		sound_pulse_audio_manager_set_source_port_by_name (_data_->self, _data_->_tmp56_, _data_->_tmp58_, sound_pulse_audio_manager_set_default_device_ready, _data_);
		return FALSE;
		_state_4:
		sound_pulse_audio_manager_set_source_port_by_name_finish (_data_->self, _data_->_res_);
	}
	_data_->_tmp61_ = sound_device_get_input (_data_->device);
	_data_->_tmp62_ = _data_->_tmp61_;
	if (!_data_->_tmp62_) {
		_data_->_tmp63_ = sound_device_get_sink_name (_data_->device);
		_data_->_tmp64_ = _data_->_tmp63_;
		_data_->_tmp60_ = _data_->_tmp64_ == NULL;
	} else {
		_data_->_tmp60_ = FALSE;
	}
	if (_data_->_tmp60_) {
		_data_->_tmp59_ = TRUE;
	} else {
		_data_->_tmp66_ = sound_device_get_input (_data_->device);
		_data_->_tmp67_ = _data_->_tmp66_;
		if (_data_->_tmp67_) {
			_data_->_tmp68_ = sound_device_get_source_name (_data_->device);
			_data_->_tmp69_ = _data_->_tmp68_;
			_data_->_tmp65_ = _data_->_tmp69_ == NULL;
		} else {
			_data_->_tmp65_ = FALSE;
		}
		_data_->_tmp59_ = _data_->_tmp65_;
	}
	if (_data_->_tmp59_) {
		g_debug ("PulseAudioManager.vala:121: wait for sink / source");
		_data_->_tmp71_ = sound_device_get_input (_data_->device);
		_data_->_tmp72_ = _data_->_tmp71_;
		if (_data_->_tmp72_) {
			_data_->_tmp70_ = "source-name";
		} else {
			_data_->_tmp70_ = "sink-name";
		}
		_data_->_state_ = 5;
		sound_pulse_audio_manager_wait_for_update (_data_->self, _data_->device, _data_->_tmp70_, sound_pulse_audio_manager_set_default_device_ready, _data_);
		return FALSE;
		_state_5:
		sound_pulse_audio_manager_wait_for_update_finish (_data_->self, _data_->_res_);
	}
	_data_->_tmp74_ = sound_device_get_input (_data_->device);
	_data_->_tmp75_ = _data_->_tmp74_;
	if (!_data_->_tmp75_) {
		_data_->_tmp76_ = sound_device_get_sink_name (_data_->device);
		_data_->_tmp77_ = _data_->_tmp76_;
		_data_->_tmp78_ = _data_->self->priv->default_sink_name;
		_data_->_tmp73_ = g_strcmp0 (_data_->_tmp77_, _data_->_tmp78_) != 0;
	} else {
		_data_->_tmp73_ = FALSE;
	}
	if (_data_->_tmp73_) {
		_data_->_tmp79_ = _data_->self->priv->default_sink_name;
		_data_->_tmp80_ = sound_device_get_sink_name (_data_->device);
		_data_->_tmp81_ = _data_->_tmp80_;
		g_debug ("PulseAudioManager.vala:128: set sink: %s > %s", _data_->_tmp79_, _data_->_tmp81_);
		_data_->_tmp82_ = sound_device_get_sink_name (_data_->device);
		_data_->_tmp83_ = _data_->_tmp82_;
		_data_->_state_ = 6;
		sound_pulse_audio_manager_set_default_sink (_data_->self, _data_->_tmp83_, sound_pulse_audio_manager_set_default_device_ready, _data_);
		return FALSE;
		_state_6:
		sound_pulse_audio_manager_set_default_sink_finish (_data_->self, _data_->_res_);
	}
	_data_->_tmp85_ = sound_device_get_input (_data_->device);
	_data_->_tmp86_ = _data_->_tmp85_;
	if (_data_->_tmp86_) {
		_data_->_tmp87_ = sound_device_get_source_name (_data_->device);
		_data_->_tmp88_ = _data_->_tmp87_;
		_data_->_tmp89_ = _data_->self->priv->default_source_name;
		_data_->_tmp84_ = g_strcmp0 (_data_->_tmp88_, _data_->_tmp89_) != 0;
	} else {
		_data_->_tmp84_ = FALSE;
	}
	if (_data_->_tmp84_) {
		_data_->_tmp90_ = _data_->self->priv->default_source_name;
		_data_->_tmp91_ = sound_device_get_source_name (_data_->device);
		_data_->_tmp92_ = _data_->_tmp91_;
		g_debug ("PulseAudioManager.vala:133: set source: %s > %s", _data_->_tmp90_, _data_->_tmp92_);
		_data_->_tmp93_ = sound_device_get_source_name (_data_->device);
		_data_->_tmp94_ = _data_->_tmp93_;
		_data_->_state_ = 7;
		sound_pulse_audio_manager_set_default_source (_data_->self, _data_->_tmp94_, sound_pulse_audio_manager_set_default_device_ready, _data_);
		return FALSE;
		_state_7:
		sound_pulse_audio_manager_set_default_source_finish (_data_->self, _data_->_res_);
	}
	_g_free0 (_data_->profile_name);
	_g_object_unref0 (_data_->other_device);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
sound_pulse_audio_manager_set_card_profile_by_index_data_free (gpointer _data)
{
	SoundPulseAudioManagerSetCardProfileByIndexData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (SoundPulseAudioManagerSetCardProfileByIndexData, _data_);
}

static void
sound_pulse_audio_manager_set_card_profile_by_index (SoundPulseAudioManager* self,
                                                     guint32 card_index,
                                                     const gchar* profile_name,
                                                     GAsyncReadyCallback _callback_,
                                                     gpointer _user_data_)
{
	SoundPulseAudioManagerSetCardProfileByIndexData* _data_;
	SoundPulseAudioManager* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (profile_name != NULL);
	_data_ = g_slice_new0 (SoundPulseAudioManagerSetCardProfileByIndexData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, sound_pulse_audio_manager_set_card_profile_by_index_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_data_->card_index = card_index;
	_tmp1_ = g_strdup (profile_name);
	_g_free0 (_data_->profile_name);
	_data_->profile_name = _tmp1_;
	sound_pulse_audio_manager_set_card_profile_by_index_co (_data_);
}

static void
sound_pulse_audio_manager_set_card_profile_by_index_finish (SoundPulseAudioManager* self,
                                                            GAsyncResult* _res_)
{
	SoundPulseAudioManagerSetCardProfileByIndexData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static Block4Data*
block4_data_ref (Block4Data* _data4_)
{
	g_atomic_int_inc (&_data4_->_ref_count_);
	return _data4_;
}

static void
block4_data_unref (void * _userdata_)
{
	Block4Data* _data4_;
	_data4_ = (Block4Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data4_->_ref_count_)) {
		SoundPulseAudioManager* self;
		self = _data4_->self;
		_g_free0 (_data4_->profile_name);
		_g_object_unref0 (self);
		g_slice_free (Block4Data, _data4_);
	}
}

static void
__lambda8_ (Block4Data* _data4_,
            pa_context* c,
            gint success)
{
	SoundPulseAudioManager* self;
	self = _data4_->self;
	g_return_if_fail (c != NULL);
	if (success == 1) {
		sound_pulse_audio_manager_set_card_profile_by_index_co (_data4_->_async_data_);
	} else {
		g_warning ("PulseAudioManager.vala:143: setting card %u profile to %s failed", (guint) _data4_->card_index, _data4_->profile_name);
	}
}

static void
___lambda8__pa_context_success_cb_t (pa_context* c,
                                     gint success,
                                     gpointer self)
{
	__lambda8_ (self, c, success);
}

static gboolean
sound_pulse_audio_manager_set_card_profile_by_index_co (SoundPulseAudioManagerSetCardProfileByIndexData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_data4_ = g_slice_new0 (Block4Data);
	_data_->_data4_->_ref_count_ = 1;
	_data_->_data4_->self = g_object_ref (_data_->self);
	_data_->_data4_->card_index = _data_->card_index;
	_g_free0 (_data_->_data4_->profile_name);
	_data_->_data4_->profile_name = _data_->profile_name;
	_data_->_data4_->_async_data_ = _data_;
	_data_->_tmp0_ = _data_->self->priv->_context;
	_data_->_tmp1_ = pa_context_set_card_profile_by_index (_data_->_tmp0_, _data_->_data4_->card_index, _data_->_data4_->profile_name, ___lambda8__pa_context_success_cb_t, _data_->_data4_);
	_data_->_tmp2_ = _data_->_tmp1_;
	_pa_operation_unref0 (_data_->_tmp2_);
	_data_->_state_ = 1;
	return FALSE;
	_state_1:
	;
	block4_data_unref (_data_->_data4_);
	_data_->_data4_ = NULL;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
sound_pulse_audio_manager_wait_for_update_data_free (gpointer _data)
{
	SoundPulseAudioManagerWaitForUpdateData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (SoundPulseAudioManagerWaitForUpdateData, _data_);
}

static void
sound_pulse_audio_manager_wait_for_update (SoundPulseAudioManager* self,
                                           SoundDevice* device,
                                           const gchar* prop_name,
                                           GAsyncReadyCallback _callback_,
                                           gpointer _user_data_)
{
	SoundPulseAudioManagerWaitForUpdateData* _data_;
	SoundPulseAudioManager* _tmp0_;
	SoundDevice* _tmp1_;
	gchar* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (device != NULL);
	g_return_if_fail (prop_name != NULL);
	_data_ = g_slice_new0 (SoundPulseAudioManagerWaitForUpdateData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, sound_pulse_audio_manager_wait_for_update_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (device);
	_g_object_unref0 (_data_->device);
	_data_->device = _tmp1_;
	_tmp2_ = g_strdup (prop_name);
	_g_free0 (_data_->prop_name);
	_data_->prop_name = _tmp2_;
	sound_pulse_audio_manager_wait_for_update_co (_data_);
}

static void
sound_pulse_audio_manager_wait_for_update_finish (SoundPulseAudioManager* self,
                                                  GAsyncResult* _res_)
{
	SoundPulseAudioManagerWaitForUpdateData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static Block5Data*
block5_data_ref (Block5Data* _data5_)
{
	g_atomic_int_inc (&_data5_->_ref_count_);
	return _data5_;
}

static void
block5_data_unref (void * _userdata_)
{
	Block5Data* _data5_;
	_data5_ = (Block5Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data5_->_ref_count_)) {
		SoundPulseAudioManager* self;
		self = _data5_->self;
		_g_object_unref0 (_data5_->device);
		_g_free0 (_data5_->prop_name);
		_g_object_unref0 (self);
		g_slice_free (Block5Data, _data5_);
	}
}

static void
__lambda9_ (Block5Data* _data5_,
            GObject* s,
            GParamSpec* p)
{
	SoundPulseAudioManager* self;
	gchar* prop_value = NULL;
	gchar* _tmp0_ = NULL;
	const gchar* _tmp1_;
	self = _data5_->self;
	g_return_if_fail (s != NULL);
	g_return_if_fail (p != NULL);
	g_object_get ((GObject*) _data5_->device, _data5_->prop_name, &_tmp0_, NULL);
	_g_free0 (prop_value);
	prop_value = _tmp0_;
	_tmp1_ = prop_value;
	if (_tmp1_ != NULL) {
		g_signal_handler_disconnect ((GObject*) _data5_->device, _data5_->handler_id);
		sound_pulse_audio_manager_wait_for_update_co (_data5_->_async_data_);
	}
	_g_free0 (prop_value);
}

static void
___lambda9__g_object_notify (GObject* _sender,
                             GParamSpec* pspec,
                             gpointer self)
{
	__lambda9_ (self, _sender, pspec);
}

static gboolean
sound_pulse_audio_manager_wait_for_update_co (SoundPulseAudioManagerWaitForUpdateData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_data5_ = g_slice_new0 (Block5Data);
	_data_->_data5_->_ref_count_ = 1;
	_data_->_data5_->self = g_object_ref (_data_->self);
	_g_object_unref0 (_data_->_data5_->device);
	_data_->_data5_->device = _data_->device;
	_g_free0 (_data_->_data5_->prop_name);
	_data_->_data5_->prop_name = _data_->prop_name;
	_data_->_data5_->_async_data_ = _data_;
	_data_->_tmp0_ = sound_device_get_id (_data_->_data5_->device);
	_data_->_tmp1_ = _data_->_tmp0_;
	g_debug ("PulseAudioManager.vala:152: wait_for_update: %s:%s", _data_->_tmp1_, _data_->_data5_->prop_name);
	_data_->_data5_->handler_id = (gulong) 0;
	_data_->_tmp2_ = g_strconcat ("notify::", _data_->_data5_->prop_name, NULL);
	_data_->_tmp3_ = g_signal_connect_data ((GObject*) _data_->_data5_->device, _data_->_tmp2_, (GCallback) ___lambda9__g_object_notify, block5_data_ref (_data_->_data5_), (GClosureNotify) block5_data_unref, 0);
	_data_->_data5_->handler_id = _data_->_tmp3_;
	_g_free0 (_data_->_tmp2_);
	_data_->_state_ = 1;
	return FALSE;
	_state_1:
	;
	block5_data_unref (_data_->_data5_);
	_data_->_data5_ = NULL;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
sound_pulse_audio_manager_set_sink_port_by_name_data_free (gpointer _data)
{
	SoundPulseAudioManagerSetSinkPortByNameData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (SoundPulseAudioManagerSetSinkPortByNameData, _data_);
}

static void
sound_pulse_audio_manager_set_sink_port_by_name (SoundPulseAudioManager* self,
                                                 const gchar* sink_name,
                                                 const gchar* port_name,
                                                 GAsyncReadyCallback _callback_,
                                                 gpointer _user_data_)
{
	SoundPulseAudioManagerSetSinkPortByNameData* _data_;
	SoundPulseAudioManager* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (sink_name != NULL);
	g_return_if_fail (port_name != NULL);
	_data_ = g_slice_new0 (SoundPulseAudioManagerSetSinkPortByNameData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, sound_pulse_audio_manager_set_sink_port_by_name_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = g_strdup (sink_name);
	_g_free0 (_data_->sink_name);
	_data_->sink_name = _tmp1_;
	_tmp2_ = g_strdup (port_name);
	_g_free0 (_data_->port_name);
	_data_->port_name = _tmp2_;
	sound_pulse_audio_manager_set_sink_port_by_name_co (_data_);
}

static void
sound_pulse_audio_manager_set_sink_port_by_name_finish (SoundPulseAudioManager* self,
                                                        GAsyncResult* _res_)
{
	SoundPulseAudioManagerSetSinkPortByNameData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static Block6Data*
block6_data_ref (Block6Data* _data6_)
{
	g_atomic_int_inc (&_data6_->_ref_count_);
	return _data6_;
}

static void
block6_data_unref (void * _userdata_)
{
	Block6Data* _data6_;
	_data6_ = (Block6Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data6_->_ref_count_)) {
		SoundPulseAudioManager* self;
		self = _data6_->self;
		_g_free0 (_data6_->sink_name);
		_g_free0 (_data6_->port_name);
		_g_object_unref0 (self);
		g_slice_free (Block6Data, _data6_);
	}
}

static void
__lambda10_ (Block6Data* _data6_,
             pa_context* c,
             gint success)
{
	SoundPulseAudioManager* self;
	self = _data6_->self;
	g_return_if_fail (c != NULL);
	if (success == 1) {
		sound_pulse_audio_manager_set_sink_port_by_name_co (_data6_->_async_data_);
	} else {
		g_warning ("PulseAudioManager.vala:171: setting sink %s port to %s failed", _data6_->sink_name, _data6_->port_name);
	}
}

static void
___lambda10__pa_context_success_cb_t (pa_context* c,
                                      gint success,
                                      gpointer self)
{
	__lambda10_ (self, c, success);
}

static gboolean
sound_pulse_audio_manager_set_sink_port_by_name_co (SoundPulseAudioManagerSetSinkPortByNameData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_data6_ = g_slice_new0 (Block6Data);
	_data_->_data6_->_ref_count_ = 1;
	_data_->_data6_->self = g_object_ref (_data_->self);
	_g_free0 (_data_->_data6_->sink_name);
	_data_->_data6_->sink_name = _data_->sink_name;
	_g_free0 (_data_->_data6_->port_name);
	_data_->_data6_->port_name = _data_->port_name;
	_data_->_data6_->_async_data_ = _data_;
	_data_->_tmp0_ = _data_->self->priv->_context;
	_data_->_tmp1_ = pa_context_set_sink_port_by_name (_data_->_tmp0_, _data_->_data6_->sink_name, _data_->_data6_->port_name, ___lambda10__pa_context_success_cb_t, _data_->_data6_);
	_data_->_tmp2_ = _data_->_tmp1_;
	_pa_operation_unref0 (_data_->_tmp2_);
	_data_->_state_ = 1;
	return FALSE;
	_state_1:
	;
	block6_data_unref (_data_->_data6_);
	_data_->_data6_ = NULL;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
sound_pulse_audio_manager_set_source_port_by_name_data_free (gpointer _data)
{
	SoundPulseAudioManagerSetSourcePortByNameData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (SoundPulseAudioManagerSetSourcePortByNameData, _data_);
}

static void
sound_pulse_audio_manager_set_source_port_by_name (SoundPulseAudioManager* self,
                                                   const gchar* source_name,
                                                   const gchar* port_name,
                                                   GAsyncReadyCallback _callback_,
                                                   gpointer _user_data_)
{
	SoundPulseAudioManagerSetSourcePortByNameData* _data_;
	SoundPulseAudioManager* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (source_name != NULL);
	g_return_if_fail (port_name != NULL);
	_data_ = g_slice_new0 (SoundPulseAudioManagerSetSourcePortByNameData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, sound_pulse_audio_manager_set_source_port_by_name_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = g_strdup (source_name);
	_g_free0 (_data_->source_name);
	_data_->source_name = _tmp1_;
	_tmp2_ = g_strdup (port_name);
	_g_free0 (_data_->port_name);
	_data_->port_name = _tmp2_;
	sound_pulse_audio_manager_set_source_port_by_name_co (_data_);
}

static void
sound_pulse_audio_manager_set_source_port_by_name_finish (SoundPulseAudioManager* self,
                                                          GAsyncResult* _res_)
{
	SoundPulseAudioManagerSetSourcePortByNameData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static Block7Data*
block7_data_ref (Block7Data* _data7_)
{
	g_atomic_int_inc (&_data7_->_ref_count_);
	return _data7_;
}

static void
block7_data_unref (void * _userdata_)
{
	Block7Data* _data7_;
	_data7_ = (Block7Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data7_->_ref_count_)) {
		SoundPulseAudioManager* self;
		self = _data7_->self;
		_g_free0 (_data7_->source_name);
		_g_free0 (_data7_->port_name);
		_g_object_unref0 (self);
		g_slice_free (Block7Data, _data7_);
	}
}

static void
__lambda11_ (Block7Data* _data7_,
             pa_context* c,
             gint success)
{
	SoundPulseAudioManager* self;
	self = _data7_->self;
	g_return_if_fail (c != NULL);
	if (success == 1) {
		sound_pulse_audio_manager_set_source_port_by_name_co (_data7_->_async_data_);
	} else {
		g_warning ("PulseAudioManager.vala:183: setting source %s port to %s failed", _data7_->source_name, _data7_->port_name);
	}
}

static void
___lambda11__pa_context_success_cb_t (pa_context* c,
                                      gint success,
                                      gpointer self)
{
	__lambda11_ (self, c, success);
}

static gboolean
sound_pulse_audio_manager_set_source_port_by_name_co (SoundPulseAudioManagerSetSourcePortByNameData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_data7_ = g_slice_new0 (Block7Data);
	_data_->_data7_->_ref_count_ = 1;
	_data_->_data7_->self = g_object_ref (_data_->self);
	_g_free0 (_data_->_data7_->source_name);
	_data_->_data7_->source_name = _data_->source_name;
	_g_free0 (_data_->_data7_->port_name);
	_data_->_data7_->port_name = _data_->port_name;
	_data_->_data7_->_async_data_ = _data_;
	_data_->_tmp0_ = _data_->self->priv->_context;
	_data_->_tmp1_ = pa_context_set_source_port_by_name (_data_->_tmp0_, _data_->_data7_->source_name, _data_->_data7_->port_name, ___lambda11__pa_context_success_cb_t, _data_->_data7_);
	_data_->_tmp2_ = _data_->_tmp1_;
	_pa_operation_unref0 (_data_->_tmp2_);
	_data_->_state_ = 1;
	return FALSE;
	_state_1:
	;
	block7_data_unref (_data_->_data7_);
	_data_->_data7_ = NULL;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
sound_pulse_audio_manager_set_default_sink_data_free (gpointer _data)
{
	SoundPulseAudioManagerSetDefaultSinkData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (SoundPulseAudioManagerSetDefaultSinkData, _data_);
}

static void
sound_pulse_audio_manager_set_default_sink (SoundPulseAudioManager* self,
                                            const gchar* sink_name,
                                            GAsyncReadyCallback _callback_,
                                            gpointer _user_data_)
{
	SoundPulseAudioManagerSetDefaultSinkData* _data_;
	SoundPulseAudioManager* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (sink_name != NULL);
	_data_ = g_slice_new0 (SoundPulseAudioManagerSetDefaultSinkData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, sound_pulse_audio_manager_set_default_sink_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = g_strdup (sink_name);
	_g_free0 (_data_->sink_name);
	_data_->sink_name = _tmp1_;
	sound_pulse_audio_manager_set_default_sink_co (_data_);
}

static void
sound_pulse_audio_manager_set_default_sink_finish (SoundPulseAudioManager* self,
                                                   GAsyncResult* _res_)
{
	SoundPulseAudioManagerSetDefaultSinkData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static Block8Data*
block8_data_ref (Block8Data* _data8_)
{
	g_atomic_int_inc (&_data8_->_ref_count_);
	return _data8_;
}

static void
block8_data_unref (void * _userdata_)
{
	Block8Data* _data8_;
	_data8_ = (Block8Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data8_->_ref_count_)) {
		SoundPulseAudioManager* self;
		self = _data8_->self;
		_g_free0 (_data8_->sink_name);
		_g_object_unref0 (self);
		g_slice_free (Block8Data, _data8_);
	}
}

static void
__lambda12_ (Block8Data* _data8_,
             pa_context* c,
             gint success)
{
	SoundPulseAudioManager* self;
	self = _data8_->self;
	g_return_if_fail (c != NULL);
	if (success == 1) {
		sound_pulse_audio_manager_set_default_sink_co (_data8_->_async_data_);
	} else {
		g_warning ("PulseAudioManager.vala:195: setting default sink to %s failed", _data8_->sink_name);
	}
}

static void
___lambda12__pa_context_success_cb_t (pa_context* c,
                                      gint success,
                                      gpointer self)
{
	__lambda12_ (self, c, success);
}

static gboolean
sound_pulse_audio_manager_set_default_sink_co (SoundPulseAudioManagerSetDefaultSinkData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_data8_ = g_slice_new0 (Block8Data);
	_data_->_data8_->_ref_count_ = 1;
	_data_->_data8_->self = g_object_ref (_data_->self);
	_g_free0 (_data_->_data8_->sink_name);
	_data_->_data8_->sink_name = _data_->sink_name;
	_data_->_data8_->_async_data_ = _data_;
	_data_->_tmp0_ = _data_->self->priv->_context;
	_data_->_tmp1_ = pa_context_set_default_sink (_data_->_tmp0_, _data_->_data8_->sink_name, ___lambda12__pa_context_success_cb_t, _data_->_data8_);
	_data_->_tmp2_ = _data_->_tmp1_;
	_pa_operation_unref0 (_data_->_tmp2_);
	_data_->_state_ = 1;
	return FALSE;
	_state_1:
	;
	block8_data_unref (_data_->_data8_);
	_data_->_data8_ = NULL;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
sound_pulse_audio_manager_set_default_source_data_free (gpointer _data)
{
	SoundPulseAudioManagerSetDefaultSourceData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (SoundPulseAudioManagerSetDefaultSourceData, _data_);
}

static void
sound_pulse_audio_manager_set_default_source (SoundPulseAudioManager* self,
                                              const gchar* source_name,
                                              GAsyncReadyCallback _callback_,
                                              gpointer _user_data_)
{
	SoundPulseAudioManagerSetDefaultSourceData* _data_;
	SoundPulseAudioManager* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (source_name != NULL);
	_data_ = g_slice_new0 (SoundPulseAudioManagerSetDefaultSourceData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, sound_pulse_audio_manager_set_default_source_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = g_strdup (source_name);
	_g_free0 (_data_->source_name);
	_data_->source_name = _tmp1_;
	sound_pulse_audio_manager_set_default_source_co (_data_);
}

static void
sound_pulse_audio_manager_set_default_source_finish (SoundPulseAudioManager* self,
                                                     GAsyncResult* _res_)
{
	SoundPulseAudioManagerSetDefaultSourceData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static Block9Data*
block9_data_ref (Block9Data* _data9_)
{
	g_atomic_int_inc (&_data9_->_ref_count_);
	return _data9_;
}

static void
block9_data_unref (void * _userdata_)
{
	Block9Data* _data9_;
	_data9_ = (Block9Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data9_->_ref_count_)) {
		SoundPulseAudioManager* self;
		self = _data9_->self;
		_g_free0 (_data9_->source_name);
		_g_object_unref0 (self);
		g_slice_free (Block9Data, _data9_);
	}
}

static void
__lambda13_ (Block9Data* _data9_,
             pa_context* c,
             gint success)
{
	SoundPulseAudioManager* self;
	self = _data9_->self;
	g_return_if_fail (c != NULL);
	if (success == 1) {
		sound_pulse_audio_manager_set_default_source_co (_data9_->_async_data_);
	} else {
		g_warning ("PulseAudioManager.vala:207: setting default source to %s failed", _data9_->source_name);
	}
}

static void
___lambda13__pa_context_success_cb_t (pa_context* c,
                                      gint success,
                                      gpointer self)
{
	__lambda13_ (self, c, success);
}

static gboolean
sound_pulse_audio_manager_set_default_source_co (SoundPulseAudioManagerSetDefaultSourceData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_data9_ = g_slice_new0 (Block9Data);
	_data_->_data9_->_ref_count_ = 1;
	_data_->_data9_->self = g_object_ref (_data_->self);
	_g_free0 (_data_->_data9_->source_name);
	_data_->_data9_->source_name = _data_->source_name;
	_data_->_data9_->_async_data_ = _data_;
	_data_->_tmp0_ = _data_->self->priv->_context;
	_data_->_tmp1_ = pa_context_set_default_source (_data_->_tmp0_, _data_->_data9_->source_name, ___lambda13__pa_context_success_cb_t, _data_->_data9_);
	_data_->_tmp2_ = _data_->_tmp1_;
	_pa_operation_unref0 (_data_->_tmp2_);
	_data_->_state_ = 1;
	return FALSE;
	_state_1:
	;
	block9_data_unref (_data_->_data9_);
	_data_->_data9_ = NULL;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

void
sound_pulse_audio_manager_change_device_mute (SoundPulseAudioManager* self,
                                              SoundDevice* device,
                                              gboolean mute)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_;
	gboolean _tmp2_;
	g_return_if_fail (self != NULL);
	if (device == NULL) {
		return;
	}
	_tmp1_ = sound_device_get_input (device);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		const gchar* _tmp3_;
		const gchar* _tmp4_;
		_tmp3_ = sound_device_get_source_name (device);
		_tmp4_ = _tmp3_;
		_tmp0_ = _tmp4_ != NULL;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		pa_context* _tmp5_;
		const gchar* _tmp6_;
		const gchar* _tmp7_;
		pa_operation* _tmp8_;
		pa_operation* _tmp9_;
		_tmp5_ = self->priv->_context;
		_tmp6_ = sound_device_get_source_name (device);
		_tmp7_ = _tmp6_;
		_tmp8_ = pa_context_set_source_mute_by_name (_tmp5_, _tmp7_, mute, NULL, NULL);
		_tmp9_ = _tmp8_;
		_pa_operation_unref0 (_tmp9_);
	} else {
		const gchar* _tmp10_;
		const gchar* _tmp11_;
		_tmp10_ = sound_device_get_sink_name (device);
		_tmp11_ = _tmp10_;
		if (_tmp11_ != NULL) {
			pa_context* _tmp12_;
			const gchar* _tmp13_;
			const gchar* _tmp14_;
			pa_operation* _tmp15_;
			pa_operation* _tmp16_;
			_tmp12_ = self->priv->_context;
			_tmp13_ = sound_device_get_sink_name (device);
			_tmp14_ = _tmp13_;
			_tmp15_ = pa_context_set_sink_mute_by_name (_tmp12_, _tmp14_, mute, NULL, NULL);
			_tmp16_ = _tmp15_;
			_pa_operation_unref0 (_tmp16_);
		}
	}
}

static Block10Data*
block10_data_ref (Block10Data* _data10_)
{
	g_atomic_int_inc (&_data10_->_ref_count_);
	return _data10_;
}

static void
block10_data_unref (void * _userdata_)
{
	Block10Data* _data10_;
	_data10_ = (Block10Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data10_->_ref_count_)) {
		SoundPulseAudioManager* self;
		self = _data10_->self;
		_g_object_unref0 (_data10_->device);
		_g_object_unref0 (self);
		g_slice_free (Block10Data, _data10_);
	}
}

static gboolean
__lambda14_ (Block10Data* _data10_,
             pa_operation* operation)
{
	SoundPulseAudioManager* self;
	GeeLinkedList* _tmp0_;
	gboolean result;
	self = _data10_->self;
	g_return_val_if_fail (operation != NULL, FALSE);
	if (pa_operation_get_state (operation) == PA_OPERATION_RUNNING) {
		pa_operation_cancel (operation);
	}
	_tmp0_ = _data10_->device->volume_operations;
	gee_abstract_collection_remove ((GeeAbstractCollection*) _tmp0_, operation);
	result = G_SOURCE_CONTINUE;
	_pa_operation_unref0 (operation);
	return result;
}

static gboolean
___lambda14__gee_forall_func (gpointer g,
                              gpointer self)
{
	gboolean result;
	result = __lambda14_ (self, (pa_operation*) g);
	return result;
}

void
sound_pulse_audio_manager_change_device_volume (SoundPulseAudioManager* self,
                                                SoundDevice* device,
                                                gdouble volume)
{
	Block10Data* _data10_;
	SoundDevice* _tmp0_;
	GeeLinkedList* _tmp1_;
	pa_cvolume cvol = {0};
	pa_cvolume _tmp2_;
	pa_operation* operation = NULL;
	gboolean _tmp3_;
	gboolean _tmp4_;
	pa_operation* _tmp15_;
	g_return_if_fail (self != NULL);
	_data10_ = g_slice_new0 (Block10Data);
	_data10_->_ref_count_ = 1;
	_data10_->self = g_object_ref (self);
	_tmp0_ = _g_object_ref0 (device);
	_g_object_unref0 (_data10_->device);
	_data10_->device = _tmp0_;
	if (_data10_->device == NULL) {
		block10_data_unref (_data10_);
		_data10_ = NULL;
		return;
	}
	_tmp1_ = _data10_->device->volume_operations;
	gee_abstract_collection_foreach ((GeeAbstractCollection*) _tmp1_, ___lambda14__gee_forall_func, _data10_);
	_tmp2_ = _data10_->device->cvolume;
	cvol = _tmp2_;
	pa_cvolume_scale (&cvol, sound_pulse_audio_manager_double_to_volume (volume));
	operation = NULL;
	_tmp3_ = sound_device_get_input (_data10_->device);
	_tmp4_ = _tmp3_;
	if (_tmp4_) {
		pa_context* _tmp5_;
		const gchar* _tmp6_;
		const gchar* _tmp7_;
		pa_cvolume _tmp8_;
		pa_operation* _tmp9_;
		_tmp5_ = self->priv->_context;
		_tmp6_ = sound_device_get_source_name (_data10_->device);
		_tmp7_ = _tmp6_;
		_tmp8_ = cvol;
		_tmp9_ = pa_context_set_source_volume_by_name (_tmp5_, _tmp7_, &_tmp8_, NULL, NULL);
		_pa_operation_unref0 (operation);
		operation = _tmp9_;
	} else {
		pa_context* _tmp10_;
		const gchar* _tmp11_;
		const gchar* _tmp12_;
		pa_cvolume _tmp13_;
		pa_operation* _tmp14_;
		_tmp10_ = self->priv->_context;
		_tmp11_ = sound_device_get_sink_name (_data10_->device);
		_tmp12_ = _tmp11_;
		_tmp13_ = cvol;
		_tmp14_ = pa_context_set_sink_volume_by_name (_tmp10_, _tmp12_, &_tmp13_, NULL, NULL);
		_pa_operation_unref0 (operation);
		operation = _tmp14_;
	}
	_tmp15_ = operation;
	if (_tmp15_ != NULL) {
		GeeLinkedList* _tmp16_;
		pa_operation* _tmp17_;
		_tmp16_ = _data10_->device->volume_operations;
		_tmp17_ = operation;
		gee_abstract_collection_add ((GeeAbstractCollection*) _tmp16_, _tmp17_);
	}
	_pa_operation_unref0 (operation);
	block10_data_unref (_data10_);
	_data10_ = NULL;
}

void
sound_pulse_audio_manager_change_device_balance (SoundPulseAudioManager* self,
                                                 SoundDevice* device,
                                                 gfloat balance)
{
	pa_cvolume cvol = {0};
	pa_cvolume _tmp0_;
	pa_channel_map _tmp1_;
	pa_operation* operation = NULL;
	gboolean _tmp2_;
	gboolean _tmp3_;
	pa_operation* _tmp14_;
	g_return_if_fail (self != NULL);
	if (device == NULL) {
		return;
	}
	_tmp0_ = device->cvolume;
	cvol = _tmp0_;
	_tmp1_ = device->channel_map;
	cvol = *pa_cvolume_set_balance (&cvol, &_tmp1_, balance);
	operation = NULL;
	_tmp2_ = sound_device_get_input (device);
	_tmp3_ = _tmp2_;
	if (_tmp3_) {
		pa_context* _tmp4_;
		const gchar* _tmp5_;
		const gchar* _tmp6_;
		pa_cvolume _tmp7_;
		pa_operation* _tmp8_;
		_tmp4_ = self->priv->_context;
		_tmp5_ = sound_device_get_source_name (device);
		_tmp6_ = _tmp5_;
		_tmp7_ = cvol;
		_tmp8_ = pa_context_set_source_volume_by_name (_tmp4_, _tmp6_, &_tmp7_, NULL, NULL);
		_pa_operation_unref0 (operation);
		operation = _tmp8_;
	} else {
		pa_context* _tmp9_;
		const gchar* _tmp10_;
		const gchar* _tmp11_;
		pa_cvolume _tmp12_;
		pa_operation* _tmp13_;
		_tmp9_ = self->priv->_context;
		_tmp10_ = sound_device_get_sink_name (device);
		_tmp11_ = _tmp10_;
		_tmp12_ = cvol;
		_tmp13_ = pa_context_set_sink_volume_by_name (_tmp9_, _tmp11_, &_tmp12_, NULL, NULL);
		_pa_operation_unref0 (operation);
		operation = _tmp13_;
	}
	_tmp14_ = operation;
	if (_tmp14_ != NULL) {
		GeeLinkedList* _tmp15_;
		pa_operation* _tmp16_;
		_tmp15_ = device->volume_operations;
		_tmp16_ = operation;
		gee_abstract_collection_add ((GeeAbstractCollection*) _tmp15_, _tmp16_);
	}
	_pa_operation_unref0 (operation);
}

static gboolean
sound_pulse_audio_manager_reconnect_timeout (SoundPulseAudioManager* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	self->priv->reconnect_timer_id = 0U;
	sound_pulse_audio_manager_reconnect_to_pulse (self, NULL, NULL);
	result = FALSE;
	return result;
}

static void
sound_pulse_audio_manager_reconnect_to_pulse_data_free (gpointer _data)
{
	SoundPulseAudioManagerReconnectToPulseData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (SoundPulseAudioManagerReconnectToPulseData, _data_);
}

static void
sound_pulse_audio_manager_reconnect_to_pulse (SoundPulseAudioManager* self,
                                              GAsyncReadyCallback _callback_,
                                              gpointer _user_data_)
{
	SoundPulseAudioManagerReconnectToPulseData* _data_;
	SoundPulseAudioManager* _tmp0_;
	g_return_if_fail (self != NULL);
	_data_ = g_slice_new0 (SoundPulseAudioManagerReconnectToPulseData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, sound_pulse_audio_manager_reconnect_to_pulse_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	sound_pulse_audio_manager_reconnect_to_pulse_co (_data_);
}

static void
sound_pulse_audio_manager_reconnect_to_pulse_finish (SoundPulseAudioManager* self,
                                                     GAsyncResult* _res_)
{
	SoundPulseAudioManagerReconnectToPulseData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static void
_sound_pulse_audio_manager_context_state_callback_pa_context_notify_cb_t (pa_context* c,
                                                                          gpointer self)
{
	sound_pulse_audio_manager_context_state_callback ((SoundPulseAudioManager*) self, c);
}

static gboolean
sound_pulse_audio_manager_reconnect_to_pulse_co (SoundPulseAudioManagerReconnectToPulseData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	if (_data_->self->priv->is_ready) {
		_data_->_tmp0_ = _data_->self->priv->_context;
		pa_context_disconnect (_data_->_tmp0_);
		sound_pulse_audio_manager_set_context (_data_->self, NULL);
		_data_->self->priv->is_ready = FALSE;
	}
	_data_->_tmp1_ = pa_proplist_new ();
	_data_->props = _data_->_tmp1_;
	_data_->_tmp2_ = _data_->props;
	pa_proplist_sets (_data_->_tmp2_, PA_PROP_APPLICATION_ID, "io.elementary.settings.sound");
	_data_->_tmp3_ = _data_->self->priv->loop;
	_data_->_tmp4_ = pa_glib_mainloop_get_api (_data_->_tmp3_);
	_data_->_tmp5_ = _data_->props;
	_data_->_tmp6_ = pa_context_new_with_proplist (_data_->_tmp4_, NULL, _data_->_tmp5_);
	_data_->_tmp7_ = _data_->_tmp6_;
	sound_pulse_audio_manager_set_context (_data_->self, _data_->_tmp7_);
	_pa_context_unref0 (_data_->_tmp7_);
	_data_->_tmp8_ = _data_->self->priv->_context;
	pa_context_set_state_callback (_data_->_tmp8_, _sound_pulse_audio_manager_context_state_callback_pa_context_notify_cb_t, _data_->self);
	_data_->_tmp9_ = _data_->self->priv->_context;
	if (pa_context_connect (_data_->_tmp9_, NULL, PA_CONTEXT_NOFAIL, NULL) < 0) {
		_data_->_tmp10_ = _data_->self->priv->_context;
		_data_->_tmp11_ = pa_strerror (pa_context_errno (_data_->_tmp10_));
		g_warning ("PulseAudioManager.vala:296: pa_context_connect () failed: %s\n", _data_->_tmp11_);
	}
	_pa_proplist_free0 (_data_->props);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
_sound_pulse_audio_manager_subscribe_callback_pa_context_subscribe_cb_t (pa_context* c,
                                                                         pa_subscription_event_type_t t,
                                                                         guint32 idx,
                                                                         gpointer self)
{
	sound_pulse_audio_manager_subscribe_callback ((SoundPulseAudioManager*) self, c, t, idx);
}

static void
_sound_pulse_audio_manager_server_info_callback_pa_server_info_cb_t (pa_context* c,
                                                                     pa_server_info* i,
                                                                     gpointer self)
{
	sound_pulse_audio_manager_server_info_callback ((SoundPulseAudioManager*) self, c, i);
}

static void
_sound_pulse_audio_manager_sink_input_info_callback_pa_sink_input_info_cb_t (pa_context* c,
                                                                             pa_sink_input_info* i,
                                                                             gint eol,
                                                                             gpointer self)
{
	sound_pulse_audio_manager_sink_input_info_callback ((SoundPulseAudioManager*) self, c, i, eol);
}

static gboolean
_sound_pulse_audio_manager_reconnect_timeout_gsource_func (gpointer self)
{
	gboolean result;
	result = sound_pulse_audio_manager_reconnect_timeout ((SoundPulseAudioManager*) self);
	return result;
}

static void
sound_pulse_audio_manager_context_state_callback (SoundPulseAudioManager* self,
                                                  pa_context* c)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (c != NULL);
	switch (pa_context_get_state (c)) {
		case PA_CONTEXT_READY:
		{
			pa_operation* _tmp0_;
			pa_operation* _tmp1_;
			pa_context* _tmp2_;
			pa_operation* _tmp3_;
			pa_operation* _tmp4_;
			pa_context* _tmp5_;
			pa_operation* _tmp6_;
			pa_operation* _tmp7_;
			pa_context_set_subscribe_callback (c, _sound_pulse_audio_manager_subscribe_callback_pa_context_subscribe_cb_t, self);
			_tmp0_ = pa_context_subscribe (c, ((((PA_SUBSCRIPTION_MASK_SERVER | PA_SUBSCRIPTION_MASK_SINK) | PA_SUBSCRIPTION_MASK_SOURCE) | PA_SUBSCRIPTION_MASK_SINK_INPUT) | PA_SUBSCRIPTION_MASK_SOURCE_OUTPUT) | PA_SUBSCRIPTION_MASK_CARD, NULL, NULL);
			_tmp1_ = _tmp0_;
			_pa_operation_unref0 (_tmp1_);
			_tmp2_ = self->priv->_context;
			_tmp3_ = pa_context_get_server_info (_tmp2_, _sound_pulse_audio_manager_server_info_callback_pa_server_info_cb_t, self);
			_tmp4_ = _tmp3_;
			_pa_operation_unref0 (_tmp4_);
			_tmp5_ = self->priv->_context;
			_tmp6_ = pa_context_get_sink_input_info_list (_tmp5_, _sound_pulse_audio_manager_sink_input_info_callback_pa_sink_input_info_cb_t, self);
			_tmp7_ = _tmp6_;
			_pa_operation_unref0 (_tmp7_);
			self->priv->is_ready = TRUE;
			break;
		}
		case PA_CONTEXT_FAILED:
		case PA_CONTEXT_TERMINATED:
		{
			if (self->priv->reconnect_timer_id == 0U) {
				self->priv->reconnect_timer_id = g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, (guint) 2, _sound_pulse_audio_manager_reconnect_timeout_gsource_func, g_object_ref (self), g_object_unref);
			}
			break;
		}
		default:
		{
			self->priv->is_ready = FALSE;
			break;
		}
	}
}

static void
_sound_pulse_audio_manager_sink_info_callback_pa_sink_info_cb_t (pa_context* c,
                                                                 pa_sink_info* i,
                                                                 gint eol,
                                                                 gpointer self)
{
	sound_pulse_audio_manager_sink_info_callback ((SoundPulseAudioManager*) self, c, i, eol);
}

static void
_sound_pulse_audio_manager_card_info_callback_pa_card_info_cb_t (pa_context* c,
                                                                 pa_card_info* i,
                                                                 gint eol,
                                                                 gpointer self)
{
	sound_pulse_audio_manager_card_info_callback ((SoundPulseAudioManager*) self, c, i, eol);
}

static void
_sound_pulse_audio_manager_source_info_callback_pa_source_info_cb_t (pa_context* c,
                                                                     pa_source_info* i,
                                                                     gint eol,
                                                                     gpointer self)
{
	sound_pulse_audio_manager_source_info_callback ((SoundPulseAudioManager*) self, c, i, eol);
}

static void
sound_pulse_audio_manager_subscribe_callback (SoundPulseAudioManager* self,
                                              pa_context* c,
                                              pa_subscription_event_type_t t,
                                              guint32 index)
{
	pa_subscription_event_type_t source_type = 0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (c != NULL);
	source_type = t & PA_SUBSCRIPTION_EVENT_FACILITY_MASK;
	switch (source_type) {
		case PA_SUBSCRIPTION_EVENT_SINK:
		{
			pa_subscription_event_type_t event_type = 0;
			event_type = t & PA_SUBSCRIPTION_EVENT_TYPE_MASK;
			switch (event_type) {
				case PA_SUBSCRIPTION_EVENT_NEW:
				{
					pa_operation* _tmp0_;
					pa_operation* _tmp1_;
					_tmp0_ = pa_context_get_sink_info_by_index (c, index, _sound_pulse_audio_manager_sink_info_callback_pa_sink_info_cb_t, self);
					_tmp1_ = _tmp0_;
					_pa_operation_unref0 (_tmp1_);
					break;
				}
				case PA_SUBSCRIPTION_EVENT_CHANGE:
				{
					pa_operation* _tmp2_;
					pa_operation* _tmp3_;
					_tmp2_ = pa_context_get_sink_info_by_index (c, index, _sound_pulse_audio_manager_sink_info_callback_pa_sink_info_cb_t, self);
					_tmp3_ = _tmp2_;
					_pa_operation_unref0 (_tmp3_);
					break;
				}
				case PA_SUBSCRIPTION_EVENT_REMOVE:
				{
					g_debug ("PulseAudioManager.vala:349: subscribe_callback:SINK:REMOVE");
					{
						GeeIterator* _device_it = NULL;
						GeeHashMap* _tmp4_;
						GeeCollection* _tmp5_;
						GeeCollection* _tmp6_;
						GeeCollection* _tmp7_;
						GeeIterator* _tmp8_;
						GeeIterator* _tmp9_;
						_tmp4_ = self->priv->output_devices;
						_tmp5_ = gee_abstract_map_get_values ((GeeAbstractMap*) _tmp4_);
						_tmp6_ = _tmp5_;
						_tmp7_ = _tmp6_;
						_tmp8_ = gee_iterable_iterator ((GeeIterable*) _tmp7_);
						_tmp9_ = _tmp8_;
						_g_object_unref0 (_tmp7_);
						_device_it = _tmp9_;
						while (TRUE) {
							GeeIterator* _tmp10_;
							SoundDevice* device = NULL;
							GeeIterator* _tmp11_;
							gpointer _tmp12_;
							SoundDevice* _tmp13_;
							gint _tmp14_;
							gint _tmp15_;
							SoundDevice* _tmp25_;
							gint _tmp26_;
							gint _tmp27_;
							_tmp10_ = _device_it;
							if (!gee_iterator_next (_tmp10_)) {
								break;
							}
							_tmp11_ = _device_it;
							_tmp12_ = gee_iterator_get (_tmp11_);
							device = (SoundDevice*) _tmp12_;
							_tmp13_ = device;
							_tmp14_ = sound_device_get_sink_index (_tmp13_);
							_tmp15_ = _tmp14_;
							if (((guint32) _tmp15_) == index) {
								SoundDevice* _tmp16_;
								const gchar* _tmp17_;
								const gchar* _tmp18_;
								SoundDevice* _tmp19_;
								SoundDevice* _tmp20_;
								SoundDevice* _tmp21_;
								SoundDevice* _tmp22_;
								const gchar* _tmp23_;
								const gchar* _tmp24_;
								_tmp16_ = device;
								_tmp17_ = sound_device_get_id (_tmp16_);
								_tmp18_ = _tmp17_;
								g_debug ("PulseAudioManager.vala:352: \tupdating device: %s", _tmp18_);
								_tmp19_ = device;
								sound_device_set_sink_name (_tmp19_, NULL);
								_tmp20_ = device;
								sound_device_set_sink_index (_tmp20_, -1);
								_tmp21_ = device;
								sound_device_set_is_default (_tmp21_, FALSE);
								_tmp22_ = device;
								_tmp23_ = sound_device_get_sink_name (_tmp22_);
								_tmp24_ = _tmp23_;
								g_debug ("PulseAudioManager.vala:356: \t\tdevice.sink_name: %s", _tmp24_);
							}
							_tmp25_ = device;
							_tmp26_ = sound_device_get_card_sink_index (_tmp25_);
							_tmp27_ = _tmp26_;
							if (((guint32) _tmp27_) == index) {
								SoundDevice* _tmp28_;
								const gchar* _tmp29_;
								const gchar* _tmp30_;
								SoundDevice* _tmp31_;
								SoundDevice* _tmp32_;
								SoundDevice* _tmp33_;
								SoundDevice* _tmp34_;
								const gchar* _tmp35_;
								const gchar* _tmp36_;
								_tmp28_ = device;
								_tmp29_ = sound_device_get_id (_tmp28_);
								_tmp30_ = _tmp29_;
								g_debug ("PulseAudioManager.vala:360: \tupdating device: %s", _tmp30_);
								_tmp31_ = device;
								sound_device_set_card_sink_name (_tmp31_, NULL);
								_tmp32_ = device;
								sound_device_set_card_sink_index (_tmp32_, -1);
								_tmp33_ = device;
								sound_device_set_card_sink_port_name (_tmp33_, NULL);
								_tmp34_ = device;
								_tmp35_ = sound_device_get_card_sink_name (_tmp34_);
								_tmp36_ = _tmp35_;
								g_debug ("PulseAudioManager.vala:364: \t\tdevice.card_sink_name: %s", _tmp36_);
							}
							_g_object_unref0 (device);
						}
						_g_object_unref0 (_device_it);
					}
					break;
				}
				default:
				break;
			}
			break;
		}
		case PA_SUBSCRIPTION_EVENT_SINK_INPUT:
		{
			switch (t & PA_SUBSCRIPTION_EVENT_TYPE_MASK) {
				case PA_SUBSCRIPTION_EVENT_NEW:
				case PA_SUBSCRIPTION_EVENT_CHANGE:
				{
					pa_operation* _tmp37_;
					pa_operation* _tmp38_;
					_tmp37_ = pa_context_get_sink_input_info (c, index, _sound_pulse_audio_manager_sink_input_info_callback_pa_sink_input_info_cb_t, self);
					_tmp38_ = _tmp37_;
					_pa_operation_unref0 (_tmp38_);
					break;
				}
				case PA_SUBSCRIPTION_EVENT_REMOVE:
				{
					{
						guint i = 0U;
						i = (guint) 0;
						{
							gboolean _tmp39_ = FALSE;
							_tmp39_ = TRUE;
							while (TRUE) {
								GListStore* _tmp41_;
								GListStore* _tmp42_;
								GObject* _tmp43_;
								SoundApp* _tmp44_;
								guint32 _tmp45_;
								guint32 _tmp46_;
								gboolean _tmp47_;
								if (!_tmp39_) {
									guint _tmp40_;
									_tmp40_ = i;
									i = _tmp40_ + 1;
								}
								_tmp39_ = FALSE;
								_tmp41_ = self->priv->_apps;
								if (!(i < g_list_model_get_n_items ((GListModel*) _tmp41_))) {
									break;
								}
								_tmp42_ = self->priv->_apps;
								_tmp43_ = g_list_model_get_item ((GListModel*) _tmp42_, i);
								_tmp44_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp43_, SOUND_TYPE_APP, SoundApp);
								_tmp45_ = sound_app_get_index (_tmp44_);
								_tmp46_ = _tmp45_;
								_tmp47_ = index == _tmp46_;
								_g_object_unref0 (_tmp44_);
								if (_tmp47_) {
									GListStore* _tmp48_;
									_tmp48_ = self->priv->_apps;
									g_list_store_remove (_tmp48_, i);
								}
							}
						}
					}
					break;
				}
				default:
				{
					break;
				}
			}
			break;
		}
		case PA_SUBSCRIPTION_EVENT_SERVER:
		{
			pa_context* _tmp49_;
			pa_operation* _tmp50_;
			pa_operation* _tmp51_;
			_tmp49_ = self->priv->_context;
			_tmp50_ = pa_context_get_server_info (_tmp49_, _sound_pulse_audio_manager_server_info_callback_pa_server_info_cb_t, self);
			_tmp51_ = _tmp50_;
			_pa_operation_unref0 (_tmp51_);
			break;
		}
		case PA_SUBSCRIPTION_EVENT_CARD:
		{
			pa_subscription_event_type_t event_type = 0;
			event_type = t & PA_SUBSCRIPTION_EVENT_TYPE_MASK;
			switch (event_type) {
				case PA_SUBSCRIPTION_EVENT_NEW:
				{
					pa_operation* _tmp52_;
					pa_operation* _tmp53_;
					_tmp52_ = pa_context_get_card_info_by_index (c, index, _sound_pulse_audio_manager_card_info_callback_pa_card_info_cb_t, self);
					_tmp53_ = _tmp52_;
					_pa_operation_unref0 (_tmp53_);
					break;
				}
				case PA_SUBSCRIPTION_EVENT_CHANGE:
				{
					pa_operation* _tmp54_;
					pa_operation* _tmp55_;
					_tmp54_ = pa_context_get_card_info_by_index (c, index, _sound_pulse_audio_manager_card_info_callback_pa_card_info_cb_t, self);
					_tmp55_ = _tmp54_;
					_pa_operation_unref0 (_tmp55_);
					break;
				}
				case PA_SUBSCRIPTION_EVENT_REMOVE:
				{
					GeeHashMap* _tmp56_;
					GeeHashMap* _tmp57_;
					_tmp56_ = self->priv->output_devices;
					sound_pulse_audio_manager_remove_devices_by_card (self, _tmp56_, index);
					_tmp57_ = self->priv->input_devices;
					sound_pulse_audio_manager_remove_devices_by_card (self, _tmp57_, index);
					break;
				}
				default:
				break;
			}
			break;
		}
		case PA_SUBSCRIPTION_EVENT_SOURCE:
		case PA_SUBSCRIPTION_EVENT_SOURCE_OUTPUT:
		{
			pa_subscription_event_type_t event_type = 0;
			event_type = t & PA_SUBSCRIPTION_EVENT_TYPE_MASK;
			switch (event_type) {
				case PA_SUBSCRIPTION_EVENT_NEW:
				{
					pa_operation* _tmp58_;
					pa_operation* _tmp59_;
					_tmp58_ = pa_context_get_source_info_by_index (c, index, _sound_pulse_audio_manager_source_info_callback_pa_source_info_cb_t, self);
					_tmp59_ = _tmp58_;
					_pa_operation_unref0 (_tmp59_);
					break;
				}
				case PA_SUBSCRIPTION_EVENT_CHANGE:
				{
					pa_operation* _tmp60_;
					pa_operation* _tmp61_;
					_tmp60_ = pa_context_get_source_info_by_index (c, index, _sound_pulse_audio_manager_source_info_callback_pa_source_info_cb_t, self);
					_tmp61_ = _tmp60_;
					_pa_operation_unref0 (_tmp61_);
					break;
				}
				case PA_SUBSCRIPTION_EVENT_REMOVE:
				{
					g_debug ("PulseAudioManager.vala:430: subscribe_callback:SOURCE:REMOVE");
					{
						GeeIterator* _device_it = NULL;
						GeeHashMap* _tmp62_;
						GeeCollection* _tmp63_;
						GeeCollection* _tmp64_;
						GeeCollection* _tmp65_;
						GeeIterator* _tmp66_;
						GeeIterator* _tmp67_;
						_tmp62_ = self->priv->input_devices;
						_tmp63_ = gee_abstract_map_get_values ((GeeAbstractMap*) _tmp62_);
						_tmp64_ = _tmp63_;
						_tmp65_ = _tmp64_;
						_tmp66_ = gee_iterable_iterator ((GeeIterable*) _tmp65_);
						_tmp67_ = _tmp66_;
						_g_object_unref0 (_tmp65_);
						_device_it = _tmp67_;
						while (TRUE) {
							GeeIterator* _tmp68_;
							SoundDevice* device = NULL;
							GeeIterator* _tmp69_;
							gpointer _tmp70_;
							SoundDevice* _tmp71_;
							gint _tmp72_;
							gint _tmp73_;
							SoundDevice* _tmp83_;
							gint _tmp84_;
							gint _tmp85_;
							_tmp68_ = _device_it;
							if (!gee_iterator_next (_tmp68_)) {
								break;
							}
							_tmp69_ = _device_it;
							_tmp70_ = gee_iterator_get (_tmp69_);
							device = (SoundDevice*) _tmp70_;
							_tmp71_ = device;
							_tmp72_ = sound_device_get_source_index (_tmp71_);
							_tmp73_ = _tmp72_;
							if (((guint32) _tmp73_) == index) {
								SoundDevice* _tmp74_;
								const gchar* _tmp75_;
								const gchar* _tmp76_;
								SoundDevice* _tmp77_;
								SoundDevice* _tmp78_;
								SoundDevice* _tmp79_;
								SoundDevice* _tmp80_;
								const gchar* _tmp81_;
								const gchar* _tmp82_;
								_tmp74_ = device;
								_tmp75_ = sound_device_get_id (_tmp74_);
								_tmp76_ = _tmp75_;
								g_debug ("PulseAudioManager.vala:433: \tupdating device: %s", _tmp76_);
								_tmp77_ = device;
								sound_device_set_source_name (_tmp77_, NULL);
								_tmp78_ = device;
								sound_device_set_source_index (_tmp78_, -1);
								_tmp79_ = device;
								sound_device_set_is_default (_tmp79_, FALSE);
								_tmp80_ = device;
								_tmp81_ = sound_device_get_source_name (_tmp80_);
								_tmp82_ = _tmp81_;
								g_debug ("PulseAudioManager.vala:437: \t\tdevice.source_name: %s", _tmp82_);
							}
							_tmp83_ = device;
							_tmp84_ = sound_device_get_card_source_index (_tmp83_);
							_tmp85_ = _tmp84_;
							if (((guint32) _tmp85_) == index) {
								SoundDevice* _tmp86_;
								const gchar* _tmp87_;
								const gchar* _tmp88_;
								SoundDevice* _tmp89_;
								SoundDevice* _tmp90_;
								SoundDevice* _tmp91_;
								SoundDevice* _tmp92_;
								const gchar* _tmp93_;
								const gchar* _tmp94_;
								_tmp86_ = device;
								_tmp87_ = sound_device_get_id (_tmp86_);
								_tmp88_ = _tmp87_;
								g_debug ("PulseAudioManager.vala:441: \tupdating device: %s", _tmp88_);
								_tmp89_ = device;
								sound_device_set_card_source_name (_tmp89_, NULL);
								_tmp90_ = device;
								sound_device_set_card_source_index (_tmp90_, -1);
								_tmp91_ = device;
								sound_device_set_card_source_port_name (_tmp91_, NULL);
								_tmp92_ = device;
								_tmp93_ = sound_device_get_card_source_name (_tmp92_);
								_tmp94_ = _tmp93_;
								g_debug ("PulseAudioManager.vala:445: \t\tdevice.card_source_name: %s", _tmp94_);
							}
							_g_object_unref0 (device);
						}
						_g_object_unref0 (_device_it);
					}
					break;
				}
				default:
				break;
			}
			break;
		}
		default:
		break;
	}
}

static Block11Data*
block11_data_ref (Block11Data* _data11_)
{
	g_atomic_int_inc (&_data11_->_ref_count_);
	return _data11_;
}

static void
block11_data_unref (void * _userdata_)
{
	Block11Data* _data11_;
	_data11_ = (Block11Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data11_->_ref_count_)) {
		SoundPulseAudioManager* self;
		self = _data11_->self;
		_g_object_unref0 (_data11_->device);
		_g_object_unref0 (self);
		g_slice_free (Block11Data, _data11_);
	}
}

static gboolean
______lambda7_ (Block11Data* _data11_,
                pa_operation* operation)
{
	SoundPulseAudioManager* self;
	gboolean result;
	self = _data11_->self;
	g_return_val_if_fail (operation != NULL, FALSE);
	if (pa_operation_get_state (operation) != PA_OPERATION_RUNNING) {
		SoundDevice* _tmp0_;
		GeeLinkedList* _tmp1_;
		_tmp0_ = _data11_->device;
		_tmp1_ = _tmp0_->volume_operations;
		gee_abstract_collection_remove ((GeeAbstractCollection*) _tmp1_, operation);
	}
	result = G_SOURCE_CONTINUE;
	_pa_operation_unref0 (operation);
	return result;
}

static gboolean
_______lambda7__gee_forall_func (gpointer g,
                                 gpointer self)
{
	gboolean result;
	result = ______lambda7_ (self, (pa_operation*) g);
	return result;
}

static void
sound_pulse_audio_manager_source_info_callback (SoundPulseAudioManager* self,
                                                pa_context* c,
                                                pa_source_info* source,
                                                gint eol)
{
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	pa_source_port_info* _tmp8_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (c != NULL);
	if (source == NULL) {
		return;
	}
	if ((*source).monitor_of_sink != PA_INVALID_INDEX) {
		return;
	}
	g_debug ("PulseAudioManager.vala:470: source info update");
	_tmp0_ = (*source).description;
	_tmp1_ = (*source).name;
	g_debug ("PulseAudioManager.vala:471: \tsource: %s (%s)", _tmp0_, _tmp1_);
	g_debug ("PulseAudioManager.vala:472: \t\tcard: %u", (guint) (*source).card);
	_tmp2_ = (*source).name;
	if (g_strcmp0 (_tmp2_, "auto_null") == 0) {
		return;
	}
	if (sound_pulse_audio_manager_debug_enabled) {
		pa_source_port_info** _tmp3_;
		gint _tmp3__length1;
		_tmp3_ = (*source).ports;
		_tmp3__length1 = (*source).n_ports;
		{
			pa_source_port_info** port_collection = NULL;
			gint port_collection_length1 = 0;
			gint _port_collection_size_ = 0;
			gint port_it = 0;
			port_collection = _tmp3_;
			port_collection_length1 = _tmp3__length1;
			for (port_it = 0; port_it < port_collection_length1; port_it = port_it + 1) {
				pa_source_port_info* port = NULL;
				port = port_collection[port_it];
				{
					pa_source_port_info* _tmp4_;
					const gchar* _tmp5_;
					pa_source_port_info* _tmp6_;
					const gchar* _tmp7_;
					_tmp4_ = port;
					_tmp5_ = (*_tmp4_).description;
					_tmp6_ = port;
					_tmp7_ = (*_tmp6_).name;
					g_debug ("PulseAudioManager.vala:480: \t\tport: %s (%s)", _tmp5_, _tmp7_);
				}
			}
		}
	}
	_tmp8_ = (*source).active_port;
	if (_tmp8_ != NULL) {
		pa_source_port_info* _tmp9_;
		const gchar* _tmp10_;
		pa_source_port_info* _tmp11_;
		const gchar* _tmp12_;
		_tmp9_ = (*source).active_port;
		_tmp10_ = (*_tmp9_).description;
		_tmp11_ = (*source).active_port;
		_tmp12_ = (*_tmp11_).name;
		g_debug ("PulseAudioManager.vala:485: \t\tactive port: %s (%s)", _tmp10_, _tmp12_);
	}
	{
		GeeIterator* _device_it = NULL;
		GeeHashMap* _tmp13_;
		GeeCollection* _tmp14_;
		GeeCollection* _tmp15_;
		GeeCollection* _tmp16_;
		GeeIterator* _tmp17_;
		GeeIterator* _tmp18_;
		_tmp13_ = self->priv->input_devices;
		_tmp14_ = gee_abstract_map_get_values ((GeeAbstractMap*) _tmp13_);
		_tmp15_ = _tmp14_;
		_tmp16_ = _tmp15_;
		_tmp17_ = gee_iterable_iterator ((GeeIterable*) _tmp16_);
		_tmp18_ = _tmp17_;
		_g_object_unref0 (_tmp16_);
		_device_it = _tmp18_;
		while (TRUE) {
			Block11Data* _data11_;
			GeeIterator* _tmp19_;
			GeeIterator* _tmp20_;
			gpointer _tmp21_;
			SoundDevice* _tmp22_;
			guint32 _tmp23_;
			guint32 _tmp24_;
			_data11_ = g_slice_new0 (Block11Data);
			_data11_->_ref_count_ = 1;
			_data11_->self = g_object_ref (self);
			_tmp19_ = _device_it;
			if (!gee_iterator_next (_tmp19_)) {
				block11_data_unref (_data11_);
				_data11_ = NULL;
				break;
			}
			_tmp20_ = _device_it;
			_tmp21_ = gee_iterator_get (_tmp20_);
			_data11_->device = (SoundDevice*) _tmp21_;
			_tmp22_ = _data11_->device;
			_tmp23_ = sound_device_get_card_index (_tmp22_);
			_tmp24_ = _tmp23_;
			if (_tmp24_ == (*source).card) {
				SoundDevice* _tmp25_;
				const gchar* _tmp26_;
				const gchar* _tmp27_;
				SoundDevice* _tmp28_;
				SoundDevice* _tmp29_;
				const gchar* _tmp30_;
				SoundDevice* _tmp31_;
				const gchar* _tmp32_;
				const gchar* _tmp33_;
				pa_source_port_info* _tmp34_;
				gboolean _tmp38_ = FALSE;
				pa_source_port_info* _tmp39_;
				_tmp25_ = _data11_->device;
				_tmp26_ = sound_device_get_id (_tmp25_);
				_tmp27_ = _tmp26_;
				g_debug ("PulseAudioManager.vala:490: \t\tupdating device: %s", _tmp27_);
				_tmp28_ = _data11_->device;
				sound_device_set_card_source_index (_tmp28_, (gint) (*source).index);
				_tmp29_ = _data11_->device;
				_tmp30_ = (*source).name;
				sound_device_set_card_source_name (_tmp29_, _tmp30_);
				_tmp31_ = _data11_->device;
				_tmp32_ = sound_device_get_card_source_name (_tmp31_);
				_tmp33_ = _tmp32_;
				g_debug ("PulseAudioManager.vala:493: \t\t\tdevice.card_source_name: %s", _tmp33_);
				_tmp34_ = (*source).active_port;
				if (_tmp34_ != NULL) {
					SoundDevice* _tmp35_;
					pa_source_port_info* _tmp36_;
					const gchar* _tmp37_;
					_tmp35_ = _data11_->device;
					_tmp36_ = (*source).active_port;
					_tmp37_ = (*_tmp36_).name;
					sound_device_set_card_source_port_name (_tmp35_, _tmp37_);
				}
				_tmp39_ = (*source).active_port;
				if (_tmp39_ != NULL) {
					SoundDevice* _tmp40_;
					const gchar* _tmp41_;
					const gchar* _tmp42_;
					pa_source_port_info* _tmp43_;
					const gchar* _tmp44_;
					_tmp40_ = _data11_->device;
					_tmp41_ = sound_device_get_port_name (_tmp40_);
					_tmp42_ = _tmp41_;
					_tmp43_ = (*source).active_port;
					_tmp44_ = (*_tmp43_).name;
					_tmp38_ = g_strcmp0 (_tmp42_, _tmp44_) == 0;
				} else {
					_tmp38_ = FALSE;
				}
				if (_tmp38_) {
					SoundDevice* _tmp45_;
					const gchar* _tmp46_;
					SoundDevice* _tmp47_;
					const gchar* _tmp48_;
					const gchar* _tmp49_;
					SoundDevice* _tmp50_;
					SoundDevice* _tmp51_;
					const gchar* _tmp52_;
					const gchar* _tmp53_;
					const gchar* _tmp54_ = NULL;
					SoundDevice* _tmp55_;
					gboolean _tmp56_;
					gboolean _tmp57_;
					SoundDevice* _tmp58_;
					SoundDevice* _tmp59_;
					pa_cvolume _tmp60_;
					SoundDevice* _tmp61_;
					pa_channel_map _tmp62_;
					SoundDevice* _tmp63_;
					pa_channel_map _tmp64_;
					SoundDevice* _tmp65_;
					GeeLinkedList* _tmp66_;
					SoundDevice* _tmp67_;
					GeeLinkedList* _tmp68_;
					gboolean _tmp69_;
					gboolean _tmp70_;
					SoundDevice* _tmp72_;
					gboolean _tmp73_;
					gboolean _tmp74_;
					_tmp45_ = _data11_->device;
					_tmp46_ = (*source).name;
					sound_device_set_source_name (_tmp45_, _tmp46_);
					_tmp47_ = _data11_->device;
					_tmp48_ = sound_device_get_card_source_name (_tmp47_);
					_tmp49_ = _tmp48_;
					g_debug ("PulseAudioManager.vala:501: \t\t\tdevice.source_name: %s", _tmp49_);
					_tmp50_ = _data11_->device;
					sound_device_set_source_index (_tmp50_, (gint) (*source).index);
					_tmp51_ = _data11_->device;
					_tmp52_ = (*source).name;
					_tmp53_ = self->priv->default_source_name;
					sound_device_set_is_default (_tmp51_, g_strcmp0 (_tmp52_, _tmp53_) == 0);
					_tmp55_ = _data11_->device;
					_tmp56_ = sound_device_get_is_default (_tmp55_);
					_tmp57_ = _tmp56_;
					if (_tmp57_) {
						_tmp54_ = "true";
					} else {
						_tmp54_ = "false";
					}
					g_debug ("PulseAudioManager.vala:504: \t\t\tis_default: %s", _tmp54_);
					_tmp58_ = _data11_->device;
					sound_device_set_is_muted (_tmp58_, (*source).mute != 0);
					_tmp59_ = _data11_->device;
					_tmp60_ = (*source).volume;
					_tmp59_->cvolume = _tmp60_;
					_tmp61_ = _data11_->device;
					_tmp62_ = (*source).channel_map;
					_tmp61_->channel_map = _tmp62_;
					_tmp63_ = _data11_->device;
					_tmp64_ = (*source).channel_map;
					sound_device_set_balance (_tmp63_, pa_cvolume_get_balance (&(*source).volume, &_tmp64_));
					_tmp65_ = _data11_->device;
					_tmp66_ = _tmp65_->volume_operations;
					gee_abstract_collection_foreach ((GeeAbstractCollection*) _tmp66_, _______lambda7__gee_forall_func, _data11_);
					_tmp67_ = _data11_->device;
					_tmp68_ = _tmp67_->volume_operations;
					_tmp69_ = gee_collection_get_is_empty ((GeeCollection*) _tmp68_);
					_tmp70_ = _tmp69_;
					if (_tmp70_) {
						SoundDevice* _tmp71_;
						_tmp71_ = _data11_->device;
						sound_device_set_volume (_tmp71_, sound_pulse_audio_manager_volume_to_double (pa_cvolume_max (&(*source).volume)));
					}
					_tmp72_ = _data11_->device;
					_tmp73_ = sound_device_get_is_default (_tmp72_);
					_tmp74_ = _tmp73_;
					if (_tmp74_) {
						SoundDevice* _tmp75_;
						_tmp75_ = _data11_->device;
						sound_pulse_audio_manager_set_default_input (self, _tmp75_);
					}
				} else {
					SoundDevice* _tmp76_;
					SoundDevice* _tmp77_;
					SoundDevice* _tmp78_;
					_tmp76_ = _data11_->device;
					sound_device_set_source_name (_tmp76_, NULL);
					_tmp77_ = _data11_->device;
					sound_device_set_source_index (_tmp77_, -1);
					_tmp78_ = _data11_->device;
					sound_device_set_is_default (_tmp78_, FALSE);
				}
			}
			block11_data_unref (_data11_);
			_data11_ = NULL;
		}
		_g_object_unref0 (_device_it);
	}
}

static Block12Data*
block12_data_ref (Block12Data* _data12_)
{
	g_atomic_int_inc (&_data12_->_ref_count_);
	return _data12_;
}

static void
block12_data_unref (void * _userdata_)
{
	Block12Data* _data12_;
	_data12_ = (Block12Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data12_->_ref_count_)) {
		SoundPulseAudioManager* self;
		self = _data12_->self;
		_g_object_unref0 (_data12_->device);
		_g_object_unref0 (self);
		g_slice_free (Block12Data, _data12_);
	}
}

static gboolean
______lambda4_ (Block12Data* _data12_,
                pa_operation* operation)
{
	SoundPulseAudioManager* self;
	gboolean result;
	self = _data12_->self;
	g_return_val_if_fail (operation != NULL, FALSE);
	if (pa_operation_get_state (operation) != PA_OPERATION_RUNNING) {
		SoundDevice* _tmp0_;
		GeeLinkedList* _tmp1_;
		_tmp0_ = _data12_->device;
		_tmp1_ = _tmp0_->volume_operations;
		gee_abstract_collection_remove ((GeeAbstractCollection*) _tmp1_, operation);
	}
	result = G_SOURCE_CONTINUE;
	_pa_operation_unref0 (operation);
	return result;
}

static gboolean
_______lambda4__gee_forall_func (gpointer g,
                                 gpointer self)
{
	gboolean result;
	result = ______lambda4_ (self, (pa_operation*) g);
	return result;
}

static void
sound_pulse_audio_manager_sink_info_callback (SoundPulseAudioManager* self,
                                              pa_context* c,
                                              pa_sink_info* sink,
                                              gint eol)
{
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	pa_sink_port_info* _tmp8_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (c != NULL);
	if (sink == NULL) {
		return;
	}
	g_debug ("PulseAudioManager.vala:540: sink info update");
	_tmp0_ = (*sink).description;
	_tmp1_ = (*sink).name;
	g_debug ("PulseAudioManager.vala:541: \tsink: %s (%s)", _tmp0_, _tmp1_);
	_tmp2_ = (*sink).name;
	if (g_strcmp0 (_tmp2_, "auto_null") == 0) {
		return;
	}
	g_debug ("PulseAudioManager.vala:547: \t\tcard: %u", (guint) (*sink).card);
	if (sound_pulse_audio_manager_debug_enabled) {
		pa_sink_port_info** _tmp3_;
		gint _tmp3__length1;
		_tmp3_ = (*sink).ports;
		_tmp3__length1 = (*sink).n_ports;
		{
			pa_sink_port_info** port_collection = NULL;
			gint port_collection_length1 = 0;
			gint _port_collection_size_ = 0;
			gint port_it = 0;
			port_collection = _tmp3_;
			port_collection_length1 = _tmp3__length1;
			for (port_it = 0; port_it < port_collection_length1; port_it = port_it + 1) {
				pa_sink_port_info* port = NULL;
				port = port_collection[port_it];
				{
					pa_sink_port_info* _tmp4_;
					const gchar* _tmp5_;
					pa_sink_port_info* _tmp6_;
					const gchar* _tmp7_;
					_tmp4_ = port;
					_tmp5_ = (*_tmp4_).description;
					_tmp6_ = port;
					_tmp7_ = (*_tmp6_).name;
					g_debug ("PulseAudioManager.vala:551: \t\tport: %s (%s)", _tmp5_, _tmp7_);
				}
			}
		}
	}
	_tmp8_ = (*sink).active_port;
	if (_tmp8_ != NULL) {
		pa_sink_port_info* _tmp9_;
		const gchar* _tmp10_;
		pa_sink_port_info* _tmp11_;
		const gchar* _tmp12_;
		_tmp9_ = (*sink).active_port;
		_tmp10_ = (*_tmp9_).description;
		_tmp11_ = (*sink).active_port;
		_tmp12_ = (*_tmp11_).name;
		g_debug ("PulseAudioManager.vala:557: \t\tactive port: %s (%s)", _tmp10_, _tmp12_);
	}
	{
		GeeIterator* _device_it = NULL;
		GeeHashMap* _tmp13_;
		GeeCollection* _tmp14_;
		GeeCollection* _tmp15_;
		GeeCollection* _tmp16_;
		GeeIterator* _tmp17_;
		GeeIterator* _tmp18_;
		_tmp13_ = self->priv->output_devices;
		_tmp14_ = gee_abstract_map_get_values ((GeeAbstractMap*) _tmp13_);
		_tmp15_ = _tmp14_;
		_tmp16_ = _tmp15_;
		_tmp17_ = gee_iterable_iterator ((GeeIterable*) _tmp16_);
		_tmp18_ = _tmp17_;
		_g_object_unref0 (_tmp16_);
		_device_it = _tmp18_;
		while (TRUE) {
			Block12Data* _data12_;
			GeeIterator* _tmp19_;
			GeeIterator* _tmp20_;
			gpointer _tmp21_;
			SoundDevice* _tmp22_;
			guint32 _tmp23_;
			guint32 _tmp24_;
			_data12_ = g_slice_new0 (Block12Data);
			_data12_->_ref_count_ = 1;
			_data12_->self = g_object_ref (self);
			_tmp19_ = _device_it;
			if (!gee_iterator_next (_tmp19_)) {
				block12_data_unref (_data12_);
				_data12_ = NULL;
				break;
			}
			_tmp20_ = _device_it;
			_tmp21_ = gee_iterator_get (_tmp20_);
			_data12_->device = (SoundDevice*) _tmp21_;
			_tmp22_ = _data12_->device;
			_tmp23_ = sound_device_get_card_index (_tmp22_);
			_tmp24_ = _tmp23_;
			if (_tmp24_ == (*sink).card) {
				SoundDevice* _tmp25_;
				const gchar* _tmp26_;
				const gchar* _tmp27_;
				SoundDevice* _tmp28_;
				SoundDevice* _tmp29_;
				const gchar* _tmp30_;
				SoundDevice* _tmp31_;
				const gchar* _tmp32_;
				const gchar* _tmp33_;
				pa_sink_port_info* _tmp34_;
				gboolean _tmp38_ = FALSE;
				pa_sink_port_info* _tmp39_;
				_tmp25_ = _data12_->device;
				_tmp26_ = sound_device_get_id (_tmp25_);
				_tmp27_ = _tmp26_;
				g_debug ("PulseAudioManager.vala:562: \t\tupdating device: %s", _tmp27_);
				_tmp28_ = _data12_->device;
				sound_device_set_card_sink_index (_tmp28_, (gint) (*sink).index);
				_tmp29_ = _data12_->device;
				_tmp30_ = (*sink).name;
				sound_device_set_card_sink_name (_tmp29_, _tmp30_);
				_tmp31_ = _data12_->device;
				_tmp32_ = sound_device_get_card_sink_name (_tmp31_);
				_tmp33_ = _tmp32_;
				g_debug ("PulseAudioManager.vala:565: \t\t\tdevice.card_sink_name: %s", _tmp33_);
				_tmp34_ = (*sink).active_port;
				if (_tmp34_ != NULL) {
					SoundDevice* _tmp35_;
					pa_sink_port_info* _tmp36_;
					const gchar* _tmp37_;
					_tmp35_ = _data12_->device;
					_tmp36_ = (*sink).active_port;
					_tmp37_ = (*_tmp36_).name;
					sound_device_set_card_sink_port_name (_tmp35_, _tmp37_);
				}
				_tmp39_ = (*sink).active_port;
				if (_tmp39_ != NULL) {
					SoundDevice* _tmp40_;
					const gchar* _tmp41_;
					const gchar* _tmp42_;
					pa_sink_port_info* _tmp43_;
					const gchar* _tmp44_;
					_tmp40_ = _data12_->device;
					_tmp41_ = sound_device_get_port_name (_tmp40_);
					_tmp42_ = _tmp41_;
					_tmp43_ = (*sink).active_port;
					_tmp44_ = (*_tmp43_).name;
					_tmp38_ = g_strcmp0 (_tmp42_, _tmp44_) == 0;
				} else {
					_tmp38_ = FALSE;
				}
				if (_tmp38_) {
					SoundDevice* _tmp45_;
					const gchar* _tmp46_;
					SoundDevice* _tmp47_;
					const gchar* _tmp48_;
					const gchar* _tmp49_;
					SoundDevice* _tmp50_;
					SoundDevice* _tmp51_;
					const gchar* _tmp52_;
					const gchar* _tmp53_;
					const gchar* _tmp54_ = NULL;
					SoundDevice* _tmp55_;
					gboolean _tmp56_;
					gboolean _tmp57_;
					SoundDevice* _tmp58_;
					SoundDevice* _tmp59_;
					pa_cvolume _tmp60_;
					SoundDevice* _tmp61_;
					pa_channel_map _tmp62_;
					SoundDevice* _tmp63_;
					pa_channel_map _tmp64_;
					SoundDevice* _tmp65_;
					GeeLinkedList* _tmp66_;
					SoundDevice* _tmp67_;
					GeeLinkedList* _tmp68_;
					gboolean _tmp69_;
					gboolean _tmp70_;
					SoundDevice* _tmp72_;
					gboolean _tmp73_;
					gboolean _tmp74_;
					_tmp45_ = _data12_->device;
					_tmp46_ = (*sink).name;
					sound_device_set_sink_name (_tmp45_, _tmp46_);
					_tmp47_ = _data12_->device;
					_tmp48_ = sound_device_get_card_sink_name (_tmp47_);
					_tmp49_ = _tmp48_;
					g_debug ("PulseAudioManager.vala:573: \t\t\tdevice.sink_name: %s", _tmp49_);
					_tmp50_ = _data12_->device;
					sound_device_set_sink_index (_tmp50_, (gint) (*sink).index);
					_tmp51_ = _data12_->device;
					_tmp52_ = (*sink).name;
					_tmp53_ = self->priv->default_sink_name;
					sound_device_set_is_default (_tmp51_, g_strcmp0 (_tmp52_, _tmp53_) == 0);
					_tmp55_ = _data12_->device;
					_tmp56_ = sound_device_get_is_default (_tmp55_);
					_tmp57_ = _tmp56_;
					if (_tmp57_) {
						_tmp54_ = "true";
					} else {
						_tmp54_ = "false";
					}
					g_debug ("PulseAudioManager.vala:576: \t\t\tis_default: %s", _tmp54_);
					_tmp58_ = _data12_->device;
					sound_device_set_is_muted (_tmp58_, (*sink).mute != 0);
					_tmp59_ = _data12_->device;
					_tmp60_ = (*sink).volume;
					_tmp59_->cvolume = _tmp60_;
					_tmp61_ = _data12_->device;
					_tmp62_ = (*sink).channel_map;
					_tmp61_->channel_map = _tmp62_;
					_tmp63_ = _data12_->device;
					_tmp64_ = (*sink).channel_map;
					sound_device_set_balance (_tmp63_, pa_cvolume_get_balance (&(*sink).volume, &_tmp64_));
					_tmp65_ = _data12_->device;
					_tmp66_ = _tmp65_->volume_operations;
					gee_abstract_collection_foreach ((GeeAbstractCollection*) _tmp66_, _______lambda4__gee_forall_func, _data12_);
					_tmp67_ = _data12_->device;
					_tmp68_ = _tmp67_->volume_operations;
					_tmp69_ = gee_collection_get_is_empty ((GeeCollection*) _tmp68_);
					_tmp70_ = _tmp69_;
					if (_tmp70_) {
						SoundDevice* _tmp71_;
						_tmp71_ = _data12_->device;
						sound_device_set_volume (_tmp71_, sound_pulse_audio_manager_volume_to_double (pa_cvolume_max (&(*sink).volume)));
					}
					_tmp72_ = _data12_->device;
					_tmp73_ = sound_device_get_is_default (_tmp72_);
					_tmp74_ = _tmp73_;
					if (_tmp74_) {
						SoundDevice* _tmp75_;
						_tmp75_ = _data12_->device;
						sound_pulse_audio_manager_set_default_output (self, _tmp75_);
					}
				} else {
					SoundDevice* _tmp76_;
					SoundDevice* _tmp77_;
					SoundDevice* _tmp78_;
					_tmp76_ = _data12_->device;
					sound_device_set_sink_name (_tmp76_, NULL);
					_tmp77_ = _data12_->device;
					sound_device_set_sink_index (_tmp77_, -1);
					_tmp78_ = _data12_->device;
					sound_device_set_is_default (_tmp78_, FALSE);
				}
			}
			block12_data_unref (_data12_);
			_data12_ = NULL;
		}
		_g_object_unref0 (_device_it);
	}
}

static void
sound_pulse_audio_manager_sink_input_info_callback (SoundPulseAudioManager* self,
                                                    pa_context* c,
                                                    pa_sink_input_info* sink_input,
                                                    gint eol)
{
	gboolean _tmp0_ = FALSE;
	pa_proplist* _tmp1_;
	SoundApp* app = NULL;
	SoundApp* _tmp13_;
	SoundApp* _tmp18_;
	const gchar* _tmp19_;
	SoundApp* _tmp20_;
	pa_channel_map _tmp21_;
	SoundApp* _tmp22_;
	gboolean _tmp23_;
	gboolean _tmp24_;
	gdouble volume = 0.0;
	SoundApp* _tmp26_;
	gdouble _tmp27_;
	gdouble _tmp28_;
	SoundApp* _tmp30_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (c != NULL);
	if (sink_input == NULL) {
		return;
	}
	_tmp1_ = (*sink_input).proplist;
	if (pa_proplist_contains (_tmp1_, PA_PROP_APPLICATION_ID) == 0) {
		_tmp0_ = TRUE;
	} else {
		pa_proplist* _tmp2_;
		_tmp2_ = (*sink_input).proplist;
		_tmp0_ = pa_proplist_contains (_tmp2_, PA_PROP_APPLICATION_NAME) == 0;
	}
	if (_tmp0_) {
		return;
	}
	app = NULL;
	{
		guint i = 0U;
		i = (guint) 0;
		{
			gboolean _tmp3_ = FALSE;
			_tmp3_ = TRUE;
			while (TRUE) {
				GListStore* _tmp5_;
				SoundApp* _app = NULL;
				GListStore* _tmp6_;
				GObject* _tmp7_;
				SoundApp* _tmp8_;
				guint32 _tmp9_;
				guint32 _tmp10_;
				if (!_tmp3_) {
					guint _tmp4_;
					_tmp4_ = i;
					i = _tmp4_ + 1;
				}
				_tmp3_ = FALSE;
				_tmp5_ = self->priv->_apps;
				if (!(i < g_list_model_get_n_items ((GListModel*) _tmp5_))) {
					break;
				}
				_tmp6_ = self->priv->_apps;
				_tmp7_ = g_list_model_get_item ((GListModel*) _tmp6_, i);
				_app = G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, SOUND_TYPE_APP, SoundApp);
				_tmp8_ = _app;
				_tmp9_ = sound_app_get_index (_tmp8_);
				_tmp10_ = _tmp9_;
				if ((*sink_input).index == _tmp10_) {
					SoundApp* _tmp11_;
					SoundApp* _tmp12_;
					_tmp11_ = _app;
					_tmp12_ = _g_object_ref0 (_tmp11_);
					_g_object_unref0 (app);
					app = _tmp12_;
					_g_object_unref0 (_app);
					break;
				}
				_g_object_unref0 (_app);
			}
		}
	}
	_tmp13_ = app;
	if (_tmp13_ == NULL) {
		pa_sink_input_info _tmp14_;
		SoundApp* _tmp15_;
		GListStore* _tmp16_;
		SoundApp* _tmp17_;
		_tmp14_ = *sink_input;
		_tmp15_ = sound_app_new_from_sink_input_info (&_tmp14_);
		_g_object_unref0 (app);
		app = _tmp15_;
		_tmp16_ = self->priv->_apps;
		_tmp17_ = app;
		g_list_store_append (_tmp16_, (GObject*) _tmp17_);
	}
	_tmp18_ = app;
	_tmp19_ = (*sink_input).name;
	sound_app_set_media_name (_tmp18_, _tmp19_);
	_tmp20_ = app;
	_tmp21_ = (*sink_input).channel_map;
	sound_app_set_channel_map (_tmp20_, &_tmp21_);
	_tmp22_ = app;
	_tmp23_ = sound_app_get_muted (_tmp22_);
	_tmp24_ = _tmp23_;
	if (((*sink_input).mute != 0) != _tmp24_) {
		SoundApp* _tmp25_;
		_tmp25_ = app;
		sound_app_set_muted (_tmp25_, (*sink_input).mute != 0);
	}
	volume = pa_sw_volume_to_linear (pa_cvolume_avg (&(*sink_input).volume));
	_tmp26_ = app;
	_tmp27_ = sound_app_get_volume (_tmp26_);
	_tmp28_ = _tmp27_;
	if (_tmp28_ != volume) {
		SoundApp* _tmp29_;
		_tmp29_ = app;
		sound_app_set_volume (_tmp29_, volume);
	}
	_tmp30_ = app;
	g_signal_emit_by_name (_tmp30_, "changed");
	_g_object_unref0 (app);
}

static void
_vala_array_add1 (pa_card_port_info** * array,
                  gint* length,
                  gint* size,
                  pa_card_port_info* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (pa_card_port_info*, *array, *size);
	}
	(*array)[(*length)++] = value;
}

static void
sound_pulse_audio_manager_card_info_callback (SoundPulseAudioManager* self,
                                              pa_context* c,
                                              pa_card_info* card,
                                              gint eol)
{
	pa_proplist* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	pa_card_profile_info2* _tmp3_;
	const gchar* _tmp4_;
	pa_proplist* _tmp5_;
	const gchar* _tmp6_;
	pa_proplist* _tmp7_;
	const gchar* _tmp8_;
	gchar* card_active_profile_name = NULL;
	pa_card_profile_info2* _tmp9_;
	const gchar* _tmp10_;
	gchar* _tmp11_;
	pa_card_port_info** relevant_ports = NULL;
	pa_card_port_info** _tmp12_;
	gint relevant_ports_length1;
	gint _relevant_ports_size_;
	pa_card_port_info** _tmp13_;
	gint _tmp13__length1;
	pa_card_port_info** _tmp16_;
	gint _tmp16__length1;
	GeeHashMap* _tmp124_;
	pa_card_port_info** _tmp125_;
	gint _tmp125__length1;
	pa_card_info _tmp126_;
	GeeHashMap* _tmp127_;
	pa_card_port_info** _tmp128_;
	gint _tmp128__length1;
	pa_card_info _tmp129_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (c != NULL);
	if (card == NULL) {
		return;
	}
	g_debug ("PulseAudioManager.vala:655: card info update");
	_tmp0_ = (*card).proplist;
	_tmp1_ = pa_proplist_gets (_tmp0_, PA_PROP_DEVICE_DESCRIPTION);
	_tmp2_ = (*card).name;
	g_debug ("PulseAudioManager.vala:656: \tcard: %u %s (%s)", (guint) (*card).index, _tmp1_, _tmp2_);
	_tmp3_ = (*card).active_profile2;
	_tmp4_ = (*_tmp3_).name;
	g_debug ("PulseAudioManager.vala:657: \t\tactive profile: %s", _tmp4_);
	_tmp5_ = (*card).proplist;
	_tmp6_ = pa_proplist_gets (_tmp5_, PA_PROP_DEVICE_FORM_FACTOR);
	g_debug ("PulseAudioManager.vala:659: \t\tcard form factor: %s", _tmp6_);
	_tmp7_ = (*card).proplist;
	_tmp8_ = pa_proplist_gets (_tmp7_, PA_PROP_MEDIA_ICON_NAME);
	g_debug ("PulseAudioManager.vala:660: \t\tcard icon name: %s", _tmp8_);
	_tmp9_ = (*card).active_profile2;
	_tmp10_ = (*_tmp9_).name;
	_tmp11_ = g_strdup (_tmp10_);
	card_active_profile_name = _tmp11_;
	_tmp12_ = g_new0 (pa_card_port_info*, 0);
	relevant_ports = _tmp12_;
	relevant_ports_length1 = 0;
	_relevant_ports_size_ = relevant_ports_length1;
	_tmp13_ = (*card).ports;
	_tmp13__length1 = (*card).n_ports;
	{
		pa_card_port_info** port_collection = NULL;
		gint port_collection_length1 = 0;
		gint _port_collection_size_ = 0;
		gint port_it = 0;
		port_collection = _tmp13_;
		port_collection_length1 = _tmp13__length1;
		for (port_it = 0; port_it < port_collection_length1; port_it = port_it + 1) {
			pa_card_port_info* port = NULL;
			port = port_collection[port_it];
			{
				pa_card_port_info* _tmp14_;
				pa_card_port_info* _tmp15_;
				_tmp14_ = port;
				if ((*_tmp14_).available == PA_PORT_AVAILABLE_NO) {
					continue;
				}
				_tmp15_ = port;
				_vala_array_add1 (&relevant_ports, &relevant_ports_length1, &_relevant_ports_size_, _tmp15_);
			}
		}
	}
	_tmp16_ = relevant_ports;
	_tmp16__length1 = relevant_ports_length1;
	{
		pa_card_port_info** port_collection = NULL;
		gint port_collection_length1 = 0;
		gint _port_collection_size_ = 0;
		gint port_it = 0;
		port_collection = _tmp16_;
		port_collection_length1 = _tmp16__length1;
		for (port_it = 0; port_it < port_collection_length1; port_it = port_it + 1) {
			pa_card_port_info* port = NULL;
			port = port_collection[port_it];
			{
				gboolean is_input = FALSE;
				pa_card_port_info* _tmp17_;
				const gchar* _tmp18_ = NULL;
				pa_card_port_info* _tmp19_;
				const gchar* _tmp20_;
				pa_card_port_info* _tmp21_;
				const gchar* _tmp22_;
				GeeHashMap* _tmp23_ = NULL;
				GeeHashMap* devices = NULL;
				GeeHashMap* _tmp26_;
				SoundDevice* device = NULL;
				gchar* id = NULL;
				pa_card_port_info* _tmp27_;
				pa_card_info _tmp28_;
				gchar* _tmp29_;
				gboolean is_new = FALSE;
				GeeHashMap* _tmp30_;
				const gchar* _tmp31_;
				SoundDevice* _tmp41_;
				const gchar* _tmp42_;
				SoundDevice* _tmp43_;
				SoundDevice* _tmp44_;
				const gchar* _tmp45_;
				SoundDevice* _tmp46_;
				pa_card_port_info* _tmp47_;
				const gchar* _tmp48_;
				SoundDevice* _tmp49_;
				pa_proplist* _tmp50_;
				const gchar* _tmp51_;
				SoundDevice* _tmp52_;
				pa_card_port_info* _tmp53_;
				pa_proplist* _tmp54_;
				const gchar* _tmp55_;
				SoundDevice* _tmp56_;
				const gchar* _tmp57_;
				const gchar* _tmp58_;
				SoundDevice* _tmp62_;
				pa_card_port_info* _tmp63_;
				pa_proplist* _tmp64_;
				const gchar* _tmp65_;
				SoundDevice* _tmp66_;
				const gchar* _tmp67_;
				const gchar* _tmp68_;
				gboolean _tmp72_ = FALSE;
				SoundDevice* _tmp73_;
				const gchar* _tmp74_;
				const gchar* _tmp75_;
				SoundDevice* _tmp95_;
				const gchar* _tmp96_;
				const gchar* _tmp97_;
				gboolean _tmp100_ = FALSE;
				SoundDevice* _tmp105_;
				pa_card_port_info* _tmp106_;
				GeeArrayList* _tmp107_;
				GeeArrayList* _tmp108_;
				_tmp17_ = port;
				is_input = ((*_tmp17_).direction & PA_DIRECTION_INPUT) == PA_DIRECTION_INPUT;
				if (is_input) {
					_tmp18_ = "input";
				} else {
					_tmp18_ = "output";
				}
				_tmp19_ = port;
				_tmp20_ = (*_tmp19_).description;
				_tmp21_ = port;
				_tmp22_ = (*_tmp21_).name;
				g_debug ("PulseAudioManager.vala:677: \t\t%s port: %s (%s)", _tmp18_, _tmp20_, _tmp22_);
				if (is_input) {
					GeeHashMap* _tmp24_;
					_tmp24_ = self->priv->input_devices;
					_tmp23_ = _tmp24_;
				} else {
					GeeHashMap* _tmp25_;
					_tmp25_ = self->priv->output_devices;
					_tmp23_ = _tmp25_;
				}
				_tmp26_ = _g_object_ref0 (_tmp23_);
				devices = _tmp26_;
				device = NULL;
				_tmp27_ = port;
				_tmp28_ = *card;
				_tmp29_ = sound_pulse_audio_manager_get_device_id (&_tmp28_, _tmp27_);
				id = _tmp29_;
				_tmp30_ = devices;
				_tmp31_ = id;
				is_new = !gee_abstract_map_has_key ((GeeAbstractMap*) _tmp30_, _tmp31_);
				if (is_new) {
					const gchar* _tmp32_;
					const gchar* _tmp33_;
					pa_card_port_info* _tmp34_;
					const gchar* _tmp35_;
					SoundDevice* _tmp36_;
					_tmp32_ = id;
					g_debug ("PulseAudioManager.vala:683: \t\t\tnew device: %s", _tmp32_);
					_tmp33_ = id;
					_tmp34_ = port;
					_tmp35_ = (*_tmp34_).name;
					_tmp36_ = sound_device_new (_tmp33_, (*card).index, _tmp35_);
					_g_object_unref0 (device);
					device = _tmp36_;
				} else {
					const gchar* _tmp37_;
					GeeHashMap* _tmp38_;
					const gchar* _tmp39_;
					gpointer _tmp40_;
					_tmp37_ = id;
					g_debug ("PulseAudioManager.vala:686: \t\t\tupdating device: %s", _tmp37_);
					_tmp38_ = devices;
					_tmp39_ = id;
					_tmp40_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp38_, _tmp39_);
					_g_object_unref0 (device);
					device = (SoundDevice*) _tmp40_;
				}
				_tmp41_ = device;
				_tmp42_ = card_active_profile_name;
				sound_device_set_card_active_profile_name (_tmp41_, _tmp42_);
				_tmp43_ = device;
				sound_device_set_input (_tmp43_, is_input);
				_tmp44_ = device;
				_tmp45_ = (*card).name;
				sound_device_set_card_name (_tmp44_, _tmp45_);
				_tmp46_ = device;
				_tmp47_ = port;
				_tmp48_ = (*_tmp47_).description;
				sound_device_set_description (_tmp46_, _tmp48_);
				_tmp49_ = device;
				_tmp50_ = (*card).proplist;
				_tmp51_ = pa_proplist_gets (_tmp50_, PA_PROP_DEVICE_DESCRIPTION);
				sound_device_set_display_name (_tmp49_, _tmp51_);
				_tmp52_ = device;
				_tmp53_ = port;
				_tmp54_ = (*_tmp53_).proplist;
				_tmp55_ = pa_proplist_gets (_tmp54_, PA_PROP_DEVICE_FORM_FACTOR);
				sound_device_set_form_factor (_tmp52_, _tmp55_);
				_tmp56_ = device;
				_tmp57_ = sound_device_get_form_factor (_tmp56_);
				_tmp58_ = _tmp57_;
				if (_tmp58_ == NULL) {
					SoundDevice* _tmp59_;
					pa_proplist* _tmp60_;
					const gchar* _tmp61_;
					_tmp59_ = device;
					_tmp60_ = (*card).proplist;
					_tmp61_ = pa_proplist_gets (_tmp60_, PA_PROP_DEVICE_FORM_FACTOR);
					sound_device_set_form_factor (_tmp59_, _tmp61_);
				}
				_tmp62_ = device;
				_tmp63_ = port;
				_tmp64_ = (*_tmp63_).proplist;
				_tmp65_ = pa_proplist_gets (_tmp64_, PA_PROP_DEVICE_ICON_NAME);
				sound_device_set_icon_name (_tmp62_, _tmp65_);
				_tmp66_ = device;
				_tmp67_ = sound_device_get_icon_name (_tmp66_);
				_tmp68_ = _tmp67_;
				if (_tmp68_ == NULL) {
					SoundDevice* _tmp69_;
					pa_proplist* _tmp70_;
					const gchar* _tmp71_;
					_tmp69_ = device;
					_tmp70_ = (*card).proplist;
					_tmp71_ = pa_proplist_gets (_tmp70_, PA_PROP_DEVICE_ICON_NAME);
					sound_device_set_icon_name (_tmp69_, _tmp71_);
				}
				_tmp73_ = device;
				_tmp74_ = sound_device_get_icon_name (_tmp73_);
				_tmp75_ = _tmp74_;
				if (_tmp75_ == NULL) {
					SoundDevice* _tmp76_;
					const gchar* _tmp77_;
					const gchar* _tmp78_;
					_tmp76_ = device;
					_tmp77_ = sound_device_get_form_factor (_tmp76_);
					_tmp78_ = _tmp77_;
					_tmp72_ = _tmp78_ != NULL;
				} else {
					_tmp72_ = FALSE;
				}
				if (_tmp72_) {
					SoundDevice* _tmp79_;
					const gchar* _tmp80_;
					const gchar* _tmp81_;
					const gchar* _tmp82_;
					GQuark _tmp84_ = 0U;
					static GQuark _tmp83_label0 = 0;
					static GQuark _tmp83_label1 = 0;
					static GQuark _tmp83_label2 = 0;
					static GQuark _tmp83_label3 = 0;
					static GQuark _tmp83_label4 = 0;
					static GQuark _tmp83_label5 = 0;
					static GQuark _tmp83_label6 = 0;
					static GQuark _tmp83_label7 = 0;
					static GQuark _tmp83_label8 = 0;
					static GQuark _tmp83_label9 = 0;
					static GQuark _tmp83_label10 = 0;
					static GQuark _tmp83_label11 = 0;
					static GQuark _tmp83_label12 = 0;
					_tmp79_ = device;
					_tmp80_ = sound_device_get_form_factor (_tmp79_);
					_tmp81_ = _tmp80_;
					_tmp82_ = _tmp81_;
					_tmp84_ = (NULL == _tmp82_) ? 0 : g_quark_from_string (_tmp82_);
					if (_tmp84_ == ((0 != _tmp83_label0) ? _tmp83_label0 : (_tmp83_label0 = g_quark_from_static_string ("car")))) {
						switch (0) {
							default:
							{
								SoundDevice* _tmp85_;
								_tmp85_ = device;
								sound_device_set_icon_name (_tmp85_, "audio-car");
								break;
							}
						}
					} else if ((_tmp84_ == ((0 != _tmp83_label1) ? _tmp83_label1 : (_tmp83_label1 = g_quark_from_static_string ("computer")))) || (_tmp84_ == ((0 != _tmp83_label2) ? _tmp83_label2 : (_tmp83_label2 = g_quark_from_static_string ("internal"))))) {
						switch (0) {
							default:
							{
								SoundDevice* _tmp86_;
								_tmp86_ = device;
								sound_device_set_icon_name (_tmp86_, "computer");
								break;
							}
						}
					} else if (_tmp84_ == ((0 != _tmp83_label3) ? _tmp83_label3 : (_tmp83_label3 = g_quark_from_static_string ("handset")))) {
						switch (0) {
							default:
							{
								SoundDevice* _tmp87_;
								_tmp87_ = device;
								sound_device_set_icon_name (_tmp87_, "phone");
								break;
							}
						}
					} else if (_tmp84_ == ((0 != _tmp83_label4) ? _tmp83_label4 : (_tmp83_label4 = g_quark_from_static_string ("headphone")))) {
						switch (0) {
							default:
							{
								SoundDevice* _tmp88_;
								_tmp88_ = device;
								sound_device_set_icon_name (_tmp88_, "audio-headphones");
								break;
							}
						}
					} else if ((_tmp84_ == ((0 != _tmp83_label5) ? _tmp83_label5 : (_tmp83_label5 = g_quark_from_static_string ("hands-free")))) || (_tmp84_ == ((0 != _tmp83_label6) ? _tmp83_label6 : (_tmp83_label6 = g_quark_from_static_string ("headset"))))) {
						switch (0) {
							default:
							{
								SoundDevice* _tmp89_;
								_tmp89_ = device;
								sound_device_set_icon_name (_tmp89_, "audio-headset");
								break;
							}
						}
					} else if (_tmp84_ == ((0 != _tmp83_label7) ? _tmp83_label7 : (_tmp83_label7 = g_quark_from_static_string ("hifi")))) {
						switch (0) {
							default:
							{
								SoundDevice* _tmp90_;
								_tmp90_ = device;
								sound_device_set_icon_name (_tmp90_, "audio-subwoofer");
								break;
							}
						}
					} else if (_tmp84_ == ((0 != _tmp83_label8) ? _tmp83_label8 : (_tmp83_label8 = g_quark_from_static_string ("microphone")))) {
						switch (0) {
							default:
							{
								SoundDevice* _tmp91_;
								_tmp91_ = device;
								sound_device_set_icon_name (_tmp91_, "audio-input-microphone");
								break;
							}
						}
					} else if ((_tmp84_ == ((0 != _tmp83_label9) ? _tmp83_label9 : (_tmp83_label9 = g_quark_from_static_string ("portable")))) || (_tmp84_ == ((0 != _tmp83_label10) ? _tmp83_label10 : (_tmp83_label10 = g_quark_from_static_string ("speaker"))))) {
						switch (0) {
							default:
							{
								SoundDevice* _tmp92_;
								_tmp92_ = device;
								sound_device_set_icon_name (_tmp92_, "bluetooth");
								break;
							}
						}
					} else if (_tmp84_ == ((0 != _tmp83_label11) ? _tmp83_label11 : (_tmp83_label11 = g_quark_from_static_string ("tv")))) {
						switch (0) {
							default:
							{
								SoundDevice* _tmp93_;
								_tmp93_ = device;
								sound_device_set_icon_name (_tmp93_, "video-display-tv");
								break;
							}
						}
					} else if (_tmp84_ == ((0 != _tmp83_label12) ? _tmp83_label12 : (_tmp83_label12 = g_quark_from_static_string ("webcam")))) {
						switch (0) {
							default:
							{
								SoundDevice* _tmp94_;
								_tmp94_ = device;
								sound_device_set_icon_name (_tmp94_, "camera-web");
								break;
							}
						}
					}
				}
				_tmp95_ = device;
				_tmp96_ = sound_device_get_icon_name (_tmp95_);
				_tmp97_ = _tmp96_;
				if (_tmp97_ == NULL) {
					const gchar* _tmp98_ = NULL;
					SoundDevice* _tmp99_;
					if (is_input) {
						_tmp98_ = "audio-input-microphone";
					} else {
						_tmp98_ = "audio-card";
					}
					_tmp99_ = device;
					sound_device_set_icon_name (_tmp99_, _tmp98_);
				}
				if (is_input) {
					SoundDevice* _tmp101_;
					const gchar* _tmp102_;
					const gchar* _tmp103_;
					_tmp101_ = device;
					_tmp102_ = sound_device_get_icon_name (_tmp101_);
					_tmp103_ = _tmp102_;
					_tmp100_ = g_str_has_prefix (_tmp103_, "audio-card");
				} else {
					_tmp100_ = FALSE;
				}
				if (_tmp100_) {
					SoundDevice* _tmp104_;
					_tmp104_ = device;
					sound_device_set_icon_name (_tmp104_, "audio-input-microphone");
				}
				_tmp105_ = device;
				_tmp106_ = port;
				_tmp107_ = sound_pulse_audio_manager_get_relevant_card_port_profiles (self, _tmp106_);
				_tmp108_ = _tmp107_;
				sound_device_set_profiles (_tmp105_, _tmp108_);
				_g_object_unref0 (_tmp108_);
				if (sound_pulse_audio_manager_debug_enabled) {
					{
						GeeArrayList* _profile_list = NULL;
						SoundDevice* _tmp109_;
						GeeArrayList* _tmp110_;
						GeeArrayList* _tmp111_;
						gint _profile_size = 0;
						GeeArrayList* _tmp112_;
						gint _tmp113_;
						gint _tmp114_;
						gint _profile_index = 0;
						_tmp109_ = device;
						_tmp110_ = sound_device_get_profiles (_tmp109_);
						_tmp111_ = _tmp110_;
						_profile_list = _tmp111_;
						_tmp112_ = _profile_list;
						_tmp113_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp112_);
						_tmp114_ = _tmp113_;
						_profile_size = _tmp114_;
						_profile_index = -1;
						while (TRUE) {
							gint _tmp115_;
							gint _tmp116_;
							gchar* profile = NULL;
							GeeArrayList* _tmp117_;
							gpointer _tmp118_;
							const gchar* _tmp119_;
							_profile_index = _profile_index + 1;
							_tmp115_ = _profile_index;
							_tmp116_ = _profile_size;
							if (!(_tmp115_ < _tmp116_)) {
								break;
							}
							_tmp117_ = _profile_list;
							_tmp118_ = gee_abstract_list_get ((GeeAbstractList*) _tmp117_, _profile_index);
							profile = (gchar*) _tmp118_;
							_tmp119_ = profile;
							g_debug ("PulseAudioManager.vala:757: \t\t\tprofile: %s", _tmp119_);
							_g_free0 (profile);
						}
					}
				}
				if (is_new) {
					GeeHashMap* _tmp120_;
					const gchar* _tmp121_;
					SoundDevice* _tmp122_;
					SoundDevice* _tmp123_;
					_tmp120_ = devices;
					_tmp121_ = id;
					_tmp122_ = device;
					gee_abstract_map_set ((GeeAbstractMap*) _tmp120_, _tmp121_, _tmp122_);
					_tmp123_ = device;
					g_signal_emit (self, sound_pulse_audio_manager_signals[SOUND_PULSE_AUDIO_MANAGER_NEW_DEVICE_SIGNAL], 0, _tmp123_);
				}
				_g_free0 (id);
				_g_object_unref0 (device);
				_g_object_unref0 (devices);
			}
		}
	}
	_tmp124_ = self->priv->output_devices;
	_tmp125_ = relevant_ports;
	_tmp125__length1 = relevant_ports_length1;
	_tmp126_ = *card;
	sound_pulse_audio_manager_cleanup_devices (self, _tmp124_, &_tmp126_, _tmp125_, (gint) _tmp125__length1);
	_tmp127_ = self->priv->input_devices;
	_tmp128_ = relevant_ports;
	_tmp128__length1 = relevant_ports_length1;
	_tmp129_ = *card;
	sound_pulse_audio_manager_cleanup_devices (self, _tmp127_, &_tmp129_, _tmp128_, (gint) _tmp128__length1);
	relevant_ports = (g_free (relevant_ports), NULL);
	_g_free0 (card_active_profile_name);
}

static void
sound_pulse_audio_manager_cleanup_devices (SoundPulseAudioManager* self,
                                           GeeHashMap* devices,
                                           pa_card_info* card,
                                           pa_card_port_info** relevant_ports,
                                           gint relevant_ports_length1)
{
	GeeMapIterator* iter = NULL;
	GeeMapIterator* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (devices != NULL);
	g_return_if_fail (card != NULL);
	_tmp0_ = gee_abstract_map_map_iterator ((GeeAbstractMap*) devices);
	iter = _tmp0_;
	while (TRUE) {
		GeeMapIterator* _tmp1_;
		SoundDevice* device = NULL;
		GeeMapIterator* _tmp2_;
		gpointer _tmp3_;
		SoundDevice* _tmp4_;
		guint32 _tmp5_;
		guint32 _tmp6_;
		pa_card_info _tmp7_;
		gboolean found = FALSE;
		_tmp1_ = iter;
		if (!gee_map_iterator_next (_tmp1_)) {
			break;
		}
		_tmp2_ = iter;
		_tmp3_ = gee_map_iterator_get_value (_tmp2_);
		device = (SoundDevice*) _tmp3_;
		_tmp4_ = device;
		_tmp5_ = sound_device_get_card_index (_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp7_ = *card;
		if (_tmp6_ != _tmp7_.index) {
			_g_object_unref0 (device);
			continue;
		}
		found = FALSE;
		{
			pa_card_port_info** port_collection = NULL;
			gint port_collection_length1 = 0;
			gint _port_collection_size_ = 0;
			gint port_it = 0;
			port_collection = relevant_ports;
			port_collection_length1 = relevant_ports_length1;
			for (port_it = 0; port_it < port_collection_length1; port_it = port_it + 1) {
				pa_card_port_info* port = NULL;
				port = port_collection[port_it];
				{
					SoundDevice* _tmp8_;
					const gchar* _tmp9_;
					const gchar* _tmp10_;
					pa_card_info _tmp11_;
					pa_card_port_info* _tmp12_;
					gchar* _tmp13_;
					gchar* _tmp14_;
					gboolean _tmp15_;
					_tmp8_ = device;
					_tmp9_ = sound_device_get_id (_tmp8_);
					_tmp10_ = _tmp9_;
					_tmp11_ = *card;
					_tmp12_ = port;
					_tmp13_ = sound_pulse_audio_manager_get_device_id (&_tmp11_, _tmp12_);
					_tmp14_ = _tmp13_;
					_tmp15_ = g_strcmp0 (_tmp10_, _tmp14_) == 0;
					_g_free0 (_tmp14_);
					if (_tmp15_) {
						found = TRUE;
						break;
					}
				}
			}
		}
		if (!found) {
			SoundDevice* _tmp16_;
			const gchar* _tmp17_;
			const gchar* _tmp18_;
			SoundDevice* _tmp19_;
			GeeMapIterator* _tmp20_;
			_tmp16_ = device;
			_tmp17_ = sound_device_get_id (_tmp16_);
			_tmp18_ = _tmp17_;
			g_debug ("PulseAudioManager.vala:790: \t\tremoving device: %s", _tmp18_);
			_tmp19_ = device;
			g_signal_emit_by_name (_tmp19_, "removed");
			_tmp20_ = iter;
			gee_map_iterator_unset (_tmp20_);
		}
		_g_object_unref0 (device);
	}
	_g_object_unref0 (iter);
}

static const gchar*
string_to_string (const gchar* self)
{
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}

static gchar*
sound_pulse_audio_manager_get_device_id (pa_card_info* card,
                                         pa_card_port_info* port)
{
	pa_card_info _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* result;
	g_return_val_if_fail (card != NULL, NULL);
	_tmp0_ = *card;
	_tmp1_ = _tmp0_.name;
	_tmp2_ = string_to_string (_tmp1_);
	_tmp3_ = (*port).name;
	_tmp4_ = string_to_string (_tmp3_);
	_tmp5_ = g_strconcat (_tmp2_, ":", _tmp4_, NULL);
	result = _tmp5_;
	return result;
}

static pa_card_profile_info2**
_vala_array_dup1 (pa_card_profile_info2** self,
                  gssize length)
{
	if (length > 0) {
		return _vala_memdup2 (self, length * sizeof (pa_card_profile_info2*));
	}
	return NULL;
}

static gint
__lambda6_ (SoundPulseAudioManager* self,
            pa_card_profile_info2* a,
            pa_card_profile_info2* b)
{
	gint result;
	if ((*a).priority > (*b).priority) {
		result = -1;
		return result;
	}
	if ((*a).priority < (*b).priority) {
		result = 1;
		return result;
	}
	result = 0;
	return result;
}

static gint
___lambda6__gcompare_data_func (gconstpointer a,
                                gconstpointer b,
                                gpointer self)
{
	gint result;
	result = __lambda6_ ((SoundPulseAudioManager*) self, a, b);
	return result;
}

static GeeArrayList*
sound_pulse_audio_manager_get_relevant_card_port_profiles (SoundPulseAudioManager* self,
                                                           pa_card_port_info* port)
{
	GeeArrayList* profiles_list = NULL;
	pa_card_profile_info2** _tmp0_;
	gint _tmp0__length1;
	pa_card_profile_info2** _tmp1_;
	gint _tmp1__length1;
	GeeArrayList* _tmp2_;
	GeeArrayList* _tmp3_;
	GeeArrayList* profiles = NULL;
	GeeArrayList* _tmp4_;
	GeeArrayList* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = (*port).profiles2;
	_tmp0__length1 = (*port).n_profiles;
	_tmp1_ = (_tmp0_ != NULL) ? _vala_array_dup1 (_tmp0_, _tmp0__length1) : _tmp0_;
	_tmp1__length1 = _tmp0__length1;
	_tmp2_ = gee_array_list_new_wrap (G_TYPE_POINTER, NULL, NULL, _tmp1_, _tmp1__length1, NULL, NULL, NULL);
	profiles_list = _tmp2_;
	_tmp3_ = profiles_list;
	gee_list_sort ((GeeList*) _tmp3_, ___lambda6__gcompare_data_func, g_object_ref (self), g_object_unref);
	_tmp4_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL);
	profiles = _tmp4_;
	{
		GeeArrayList* _item_list = NULL;
		GeeArrayList* _tmp5_;
		gint _item_size = 0;
		GeeArrayList* _tmp6_;
		gint _tmp7_;
		gint _tmp8_;
		gint _item_index = 0;
		_tmp5_ = profiles_list;
		_item_list = _tmp5_;
		_tmp6_ = _item_list;
		_tmp7_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp6_);
		_tmp8_ = _tmp7_;
		_item_size = _tmp8_;
		_item_index = -1;
		while (TRUE) {
			gint _tmp9_;
			gint _tmp10_;
			pa_card_profile_info2* item = NULL;
			GeeArrayList* _tmp11_;
			gpointer _tmp12_;
			GeeArrayList* _tmp13_;
			pa_card_profile_info2* _tmp14_;
			const gchar* _tmp15_;
			_item_index = _item_index + 1;
			_tmp9_ = _item_index;
			_tmp10_ = _item_size;
			if (!(_tmp9_ < _tmp10_)) {
				break;
			}
			_tmp11_ = _item_list;
			_tmp12_ = gee_abstract_list_get ((GeeAbstractList*) _tmp11_, _item_index);
			item = _tmp12_;
			_tmp13_ = profiles;
			_tmp14_ = item;
			_tmp15_ = (*_tmp14_).name;
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp13_, _tmp15_);
		}
	}
	result = profiles;
	_g_object_unref0 (profiles_list);
	return result;
}

static void
sound_pulse_audio_manager_remove_devices_by_card (SoundPulseAudioManager* self,
                                                  GeeHashMap* devices,
                                                  guint32 card_index)
{
	GeeMapIterator* iter = NULL;
	GeeMapIterator* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (devices != NULL);
	_tmp0_ = gee_abstract_map_map_iterator ((GeeAbstractMap*) devices);
	iter = _tmp0_;
	while (TRUE) {
		GeeMapIterator* _tmp1_;
		SoundDevice* device = NULL;
		GeeMapIterator* _tmp2_;
		gpointer _tmp3_;
		SoundDevice* _tmp4_;
		guint32 _tmp5_;
		guint32 _tmp6_;
		_tmp1_ = iter;
		if (!gee_map_iterator_next (_tmp1_)) {
			break;
		}
		_tmp2_ = iter;
		_tmp3_ = gee_map_iterator_get_value (_tmp2_);
		device = (SoundDevice*) _tmp3_;
		_tmp4_ = device;
		_tmp5_ = sound_device_get_card_index (_tmp4_);
		_tmp6_ = _tmp5_;
		if (_tmp6_ == card_index) {
			SoundDevice* _tmp7_;
			const gchar* _tmp8_;
			const gchar* _tmp9_;
			SoundDevice* _tmp10_;
			GeeMapIterator* _tmp11_;
			_tmp7_ = device;
			_tmp8_ = sound_device_get_id (_tmp7_);
			_tmp9_ = _tmp8_;
			g_debug ("PulseAudioManager.vala:831: removing device: %s", _tmp9_);
			_tmp10_ = device;
			g_signal_emit_by_name (_tmp10_, "removed");
			_tmp11_ = iter;
			gee_map_iterator_unset (_tmp11_);
		}
		_g_object_unref0 (device);
	}
	_g_object_unref0 (iter);
}

static void
_sound_pulse_audio_manager_ext_stream_restore_read_sink_callback_pulse_audio_ext_stream_restore_read_cb (pa_context* c,
                                                                                                         pa_ext_stream_restore_info* info,
                                                                                                         gint eol,
                                                                                                         gpointer self)
{
	sound_pulse_audio_manager_ext_stream_restore_read_sink_callback ((SoundPulseAudioManager*) self, c, info, eol);
}

static void
_sound_pulse_audio_manager_ext_stream_restore_read_source_callback_pulse_audio_ext_stream_restore_read_cb (pa_context* c,
                                                                                                           pa_ext_stream_restore_info* info,
                                                                                                           gint eol,
                                                                                                           gpointer self)
{
	sound_pulse_audio_manager_ext_stream_restore_read_source_callback ((SoundPulseAudioManager*) self, c, info, eol);
}

static void
sound_pulse_audio_manager_server_info_callback (SoundPulseAudioManager* self,
                                                pa_context* context,
                                                pa_server_info* server)
{
	const gchar* _tmp0_;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	const gchar* _tmp12_;
	const gchar* _tmp16_;
	const gchar* _tmp17_;
	pa_operation* _tmp24_;
	pa_operation* _tmp25_;
	pa_operation* _tmp26_;
	pa_operation* _tmp27_;
	pa_operation* _tmp28_;
	pa_operation* _tmp29_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (context != NULL);
	g_debug ("PulseAudioManager.vala:839: server info update");
	if (server == NULL) {
		return;
	}
	_tmp0_ = self->priv->default_sink_name;
	if (_tmp0_ == NULL) {
		const gchar* _tmp1_;
		gchar* _tmp2_;
		const gchar* _tmp3_;
		_tmp1_ = (*server).default_sink_name;
		_tmp2_ = g_strdup (_tmp1_);
		_g_free0 (self->priv->default_sink_name);
		self->priv->default_sink_name = _tmp2_;
		_tmp3_ = self->priv->default_sink_name;
		g_debug ("PulseAudioManager.vala:846: \tdefault_sink_name: %s", _tmp3_);
	}
	_tmp4_ = self->priv->default_sink_name;
	_tmp5_ = (*server).default_sink_name;
	if (g_strcmp0 (_tmp4_, _tmp5_) != 0) {
		const gchar* _tmp6_;
		const gchar* _tmp7_;
		const gchar* _tmp8_;
		gchar* _tmp9_;
		pa_operation* _tmp10_;
		pa_operation* _tmp11_;
		_tmp6_ = self->priv->default_sink_name;
		_tmp7_ = (*server).default_sink_name;
		g_debug ("PulseAudioManager.vala:850: \tdefault_sink_name: %s > %s", _tmp6_, _tmp7_);
		_tmp8_ = (*server).default_sink_name;
		_tmp9_ = g_strdup (_tmp8_);
		_g_free0 (self->priv->default_sink_name);
		self->priv->default_sink_name = _tmp9_;
		_tmp10_ = pa_ext_stream_restore_read (context, _sound_pulse_audio_manager_ext_stream_restore_read_sink_callback_pulse_audio_ext_stream_restore_read_cb, self);
		_tmp11_ = _tmp10_;
		_pa_operation_unref0 (_tmp11_);
	}
	_tmp12_ = self->priv->default_source_name;
	if (_tmp12_ == NULL) {
		const gchar* _tmp13_;
		gchar* _tmp14_;
		const gchar* _tmp15_;
		_tmp13_ = (*server).default_source_name;
		_tmp14_ = g_strdup (_tmp13_);
		_g_free0 (self->priv->default_source_name);
		self->priv->default_source_name = _tmp14_;
		_tmp15_ = self->priv->default_source_name;
		g_debug ("PulseAudioManager.vala:857: \tdefault_source_name: %s", _tmp15_);
	}
	_tmp16_ = self->priv->default_source_name;
	_tmp17_ = (*server).default_source_name;
	if (g_strcmp0 (_tmp16_, _tmp17_) != 0) {
		const gchar* _tmp18_;
		const gchar* _tmp19_;
		const gchar* _tmp20_;
		gchar* _tmp21_;
		pa_operation* _tmp22_;
		pa_operation* _tmp23_;
		_tmp18_ = self->priv->default_source_name;
		_tmp19_ = (*server).default_source_name;
		g_debug ("PulseAudioManager.vala:861: \tdefault_source_name: %s > %s", _tmp18_, _tmp19_);
		_tmp20_ = (*server).default_source_name;
		_tmp21_ = g_strdup (_tmp20_);
		_g_free0 (self->priv->default_source_name);
		self->priv->default_source_name = _tmp21_;
		_tmp22_ = pa_ext_stream_restore_read (context, _sound_pulse_audio_manager_ext_stream_restore_read_source_callback_pulse_audio_ext_stream_restore_read_cb, self);
		_tmp23_ = _tmp22_;
		_pa_operation_unref0 (_tmp23_);
	}
	_tmp24_ = pa_context_get_card_info_list (context, _sound_pulse_audio_manager_card_info_callback_pa_card_info_cb_t, self);
	_tmp25_ = _tmp24_;
	_pa_operation_unref0 (_tmp25_);
	_tmp26_ = pa_context_get_source_info_list (context, _sound_pulse_audio_manager_source_info_callback_pa_source_info_cb_t, self);
	_tmp27_ = _tmp26_;
	_pa_operation_unref0 (_tmp27_);
	_tmp28_ = pa_context_get_sink_info_list (context, _sound_pulse_audio_manager_sink_info_callback_pa_sink_info_cb_t, self);
	_tmp29_ = _tmp28_;
	_pa_operation_unref0 (_tmp29_);
}

static void
__lambda5_ (SoundPulseAudioManager* self,
            pa_context* c,
            gint success)
{
	g_return_if_fail (c != NULL);
	if (success != 1) {
		g_warning ("PulseAudioManager.vala:891: Updating source failed");
	}
}

static void
___lambda5__pa_context_success_cb_t (pa_context* c,
                                     gint success,
                                     gpointer self)
{
	__lambda5_ ((SoundPulseAudioManager*) self, c, success);
}

static void
sound_pulse_audio_manager_ext_stream_restore_read_sink_callback (SoundPulseAudioManager* self,
                                                                 pa_context* c,
                                                                 pa_ext_stream_restore_info* info,
                                                                 gint eol)
{
	gboolean _tmp0_ = FALSE;
	pa_ext_stream_restore_info new_info = {0};
	const gchar* _tmp2_;
	pa_channel_map _tmp3_;
	pa_cvolume _tmp4_;
	const gchar* _tmp5_;
	pa_ext_stream_restore_info _tmp6_;
	pa_ext_stream_restore_info* _tmp7_;
	pa_ext_stream_restore_info* _tmp8_;
	gint _tmp8__length1;
	pa_operation* _tmp9_;
	pa_operation* _tmp10_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (c != NULL);
	if (eol != 0) {
		_tmp0_ = TRUE;
	} else {
		const gchar* _tmp1_;
		_tmp1_ = (*info).name;
		_tmp0_ = !g_str_has_prefix (_tmp1_, "sink-input-by");
	}
	if (_tmp0_) {
		return;
	}
	memset (&new_info, 0, sizeof (pa_ext_stream_restore_info));
	_tmp2_ = (*info).name;
	new_info.name = _tmp2_;
	_tmp3_ = (*info).channel_map;
	new_info.channel_map = _tmp3_;
	_tmp4_ = (*info).volume;
	new_info.volume = _tmp4_;
	new_info.mute = (*info).mute;
	_tmp5_ = self->priv->default_sink_name;
	new_info.device = _tmp5_;
	_tmp6_ = new_info;
	_tmp7_ = g_new0 (pa_ext_stream_restore_info, 1);
	_tmp7_[0] = _tmp6_;
	_tmp8_ = _tmp7_;
	_tmp8__length1 = 1;
	_tmp9_ = pa_ext_stream_restore_write (c, PA_UPDATE_REPLACE, _tmp8_, (gint) 1, 1, ___lambda5__pa_context_success_cb_t, self);
	_tmp10_ = _tmp9_;
	_pa_operation_unref0 (_tmp10_);
	_tmp8_ = (g_free (_tmp8_), NULL);
}

static void
sound_pulse_audio_manager_ext_stream_restore_read_source_callback (SoundPulseAudioManager* self,
                                                                   pa_context* c,
                                                                   pa_ext_stream_restore_info* info,
                                                                   gint eol)
{
	gboolean _tmp0_ = FALSE;
	pa_ext_stream_restore_info new_info = {0};
	const gchar* _tmp2_;
	pa_channel_map _tmp3_;
	pa_cvolume _tmp4_;
	const gchar* _tmp5_;
	pa_ext_stream_restore_info _tmp6_;
	pa_ext_stream_restore_info* _tmp7_;
	pa_ext_stream_restore_info* _tmp8_;
	gint _tmp8__length1;
	pa_operation* _tmp9_;
	pa_operation* _tmp10_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (c != NULL);
	if (eol != 0) {
		_tmp0_ = TRUE;
	} else {
		const gchar* _tmp1_;
		_tmp1_ = (*info).name;
		_tmp0_ = !g_str_has_prefix (_tmp1_, "source-output-by");
	}
	if (_tmp0_) {
		return;
	}
	memset (&new_info, 0, sizeof (pa_ext_stream_restore_info));
	_tmp2_ = (*info).name;
	new_info.name = _tmp2_;
	_tmp3_ = (*info).channel_map;
	new_info.channel_map = _tmp3_;
	_tmp4_ = (*info).volume;
	new_info.volume = _tmp4_;
	new_info.mute = (*info).mute;
	_tmp5_ = self->priv->default_source_name;
	new_info.device = _tmp5_;
	_tmp6_ = new_info;
	_tmp7_ = g_new0 (pa_ext_stream_restore_info, 1);
	_tmp7_[0] = _tmp6_;
	_tmp8_ = _tmp7_;
	_tmp8__length1 = 1;
	_tmp9_ = pa_ext_stream_restore_write (c, PA_UPDATE_REPLACE, _tmp8_, (gint) 1, 1, NULL, NULL);
	_tmp10_ = _tmp9_;
	_pa_operation_unref0 (_tmp10_);
	_tmp8_ = (g_free (_tmp8_), NULL);
}

static gdouble
sound_pulse_audio_manager_volume_to_double (pa_volume_t vol)
{
	gdouble tmp = 0.0;
	gdouble result;
	tmp = (gdouble) (vol - PA_VOLUME_MUTED);
	result = (100 * tmp) / ((gdouble) (PA_VOLUME_NORM - PA_VOLUME_MUTED));
	return result;
}

static pa_volume_t
sound_pulse_audio_manager_double_to_volume (gdouble vol)
{
	gdouble tmp = 0.0;
	pa_volume_t result;
	tmp = (((gdouble) (PA_VOLUME_NORM - PA_VOLUME_MUTED)) * vol) / 100;
	result = ((pa_volume_t) tmp) + PA_VOLUME_MUTED;
	return result;
}

static Block13Data*
block13_data_ref (Block13Data* _data13_)
{
	g_atomic_int_inc (&_data13_->_ref_count_);
	return _data13_;
}

static void
block13_data_unref (void * _userdata_)
{
	Block13Data* _data13_;
	_data13_ = (Block13Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data13_->_ref_count_)) {
		SoundPulseAudioManager* self;
		self = _data13_->self;
		_g_object_unref0 (_data13_->app);
		_g_object_unref0 (self);
		g_slice_free (Block13Data, _data13_);
	}
}

static void
__lambda15_ (Block13Data* _data13_,
             pa_context* c,
             gint success)
{
	SoundPulseAudioManager* self;
	self = _data13_->self;
	g_return_if_fail (c != NULL);
	if (success != 1) {
		const gchar* _tmp0_;
		const gchar* _tmp1_;
		_tmp0_ = sound_app_get_name (_data13_->app);
		_tmp1_ = _tmp0_;
		g_warning ("PulseAudioManager.vala:936: Failed to change volume of application '%s" \
"'.", _tmp1_);
	}
}

static void
___lambda15__pa_context_success_cb_t (pa_context* c,
                                      gint success,
                                      gpointer self)
{
	__lambda15_ (self, c, success);
}

void
sound_pulse_audio_manager_change_application_volume (SoundPulseAudioManager* self,
                                                     SoundApp* app,
                                                     gdouble volume)
{
	Block13Data* _data13_;
	SoundApp* _tmp0_;
	pa_cvolume cvol = {0};
	pa_channel_map _tmp1_ = {0};
	pa_channel_map _tmp2_;
	pa_context* _tmp3_;
	guint32 _tmp4_;
	guint32 _tmp5_;
	pa_cvolume _tmp6_;
	pa_operation* _tmp7_;
	pa_operation* _tmp8_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (app != NULL);
	_data13_ = g_slice_new0 (Block13Data);
	_data13_->_ref_count_ = 1;
	_data13_->self = g_object_ref (self);
	_tmp0_ = _g_object_ref0 (app);
	_g_object_unref0 (_data13_->app);
	_data13_->app = _tmp0_;
	pa_cvolume_init (&cvol);
	sound_app_get_channel_map (_data13_->app, &_tmp1_);
	_tmp2_ = _tmp1_;
	pa_cvolume_set (&cvol, _tmp2_.channels, pa_sw_volume_from_linear (volume));
	_tmp3_ = self->priv->_context;
	_tmp4_ = sound_app_get_index (_data13_->app);
	_tmp5_ = _tmp4_;
	_tmp6_ = cvol;
	_tmp7_ = pa_context_set_sink_input_volume (_tmp3_, _tmp5_, &_tmp6_, ___lambda15__pa_context_success_cb_t, _data13_);
	_tmp8_ = _tmp7_;
	_pa_operation_unref0 (_tmp8_);
	block13_data_unref (_data13_);
	_data13_ = NULL;
}

static Block14Data*
block14_data_ref (Block14Data* _data14_)
{
	g_atomic_int_inc (&_data14_->_ref_count_);
	return _data14_;
}

static void
block14_data_unref (void * _userdata_)
{
	Block14Data* _data14_;
	_data14_ = (Block14Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data14_->_ref_count_)) {
		SoundPulseAudioManager* self;
		self = _data14_->self;
		_g_object_unref0 (_data14_->app);
		_g_object_unref0 (self);
		g_slice_free (Block14Data, _data14_);
	}
}

static void
__lambda16_ (Block14Data* _data14_,
             pa_context* c,
             gint success)
{
	SoundPulseAudioManager* self;
	self = _data14_->self;
	g_return_if_fail (c != NULL);
	if (success != 1) {
		const gchar* _tmp0_;
		const gchar* _tmp1_;
		_tmp0_ = sound_app_get_name (_data14_->app);
		_tmp1_ = _tmp0_;
		g_warning ("PulseAudioManager.vala:944: Failed to mute application '%s'.", _tmp1_);
	}
}

static void
___lambda16__pa_context_success_cb_t (pa_context* c,
                                      gint success,
                                      gpointer self)
{
	__lambda16_ (self, c, success);
}

void
sound_pulse_audio_manager_mute_application (SoundPulseAudioManager* self,
                                            SoundApp* app,
                                            gboolean mute)
{
	Block14Data* _data14_;
	SoundApp* _tmp0_;
	pa_context* _tmp1_;
	guint32 _tmp2_;
	guint32 _tmp3_;
	pa_operation* _tmp4_;
	pa_operation* _tmp5_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (app != NULL);
	_data14_ = g_slice_new0 (Block14Data);
	_data14_->_ref_count_ = 1;
	_data14_->self = g_object_ref (self);
	_tmp0_ = _g_object_ref0 (app);
	_g_object_unref0 (_data14_->app);
	_data14_->app = _tmp0_;
	_tmp1_ = self->priv->_context;
	_tmp2_ = sound_app_get_index (_data14_->app);
	_tmp3_ = _tmp2_;
	_tmp4_ = pa_context_set_sink_input_mute (_tmp1_, _tmp3_, mute, ___lambda16__pa_context_success_cb_t, _data14_);
	_tmp5_ = _tmp4_;
	_pa_operation_unref0 (_tmp5_);
	block14_data_unref (_data14_);
	_data14_ = NULL;
}

pa_context*
sound_pulse_audio_manager_get_context (SoundPulseAudioManager* self)
{
	pa_context* result;
	pa_context* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_context;
	result = _tmp0_;
	return result;
}

static gpointer
_pa_context_ref0 (gpointer self)
{
	return self ? pa_context_ref (self) : NULL;
}

static void
sound_pulse_audio_manager_set_context (SoundPulseAudioManager* self,
                                       pa_context* value)
{
	pa_context* old_value;
	g_return_if_fail (self != NULL);
	old_value = sound_pulse_audio_manager_get_context (self);
	if (old_value != value) {
		pa_context* _tmp0_;
		_tmp0_ = _pa_context_ref0 (value);
		_pa_context_unref0 (self->priv->_context);
		self->priv->_context = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, sound_pulse_audio_manager_properties[SOUND_PULSE_AUDIO_MANAGER_CONTEXT_PROPERTY]);
	}
}

GListStore*
sound_pulse_audio_manager_get_apps (SoundPulseAudioManager* self)
{
	GListStore* result;
	GListStore* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_apps;
	result = _tmp0_;
	return result;
}

static void
sound_pulse_audio_manager_set_apps (SoundPulseAudioManager* self,
                                    GListStore* value)
{
	GListStore* old_value;
	g_return_if_fail (self != NULL);
	old_value = sound_pulse_audio_manager_get_apps (self);
	if (old_value != value) {
		GListStore* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_apps);
		self->priv->_apps = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, sound_pulse_audio_manager_properties[SOUND_PULSE_AUDIO_MANAGER_APPS_PROPERTY]);
	}
}

SoundDevice*
sound_pulse_audio_manager_get_default_output (SoundPulseAudioManager* self)
{
	SoundDevice* result;
	SoundDevice* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_default_output;
	result = _tmp0_;
	return result;
}

static void
sound_pulse_audio_manager_set_default_output (SoundPulseAudioManager* self,
                                              SoundDevice* value)
{
	SoundDevice* old_value;
	g_return_if_fail (self != NULL);
	old_value = sound_pulse_audio_manager_get_default_output (self);
	if (old_value != value) {
		SoundDevice* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_default_output);
		self->priv->_default_output = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, sound_pulse_audio_manager_properties[SOUND_PULSE_AUDIO_MANAGER_DEFAULT_OUTPUT_PROPERTY]);
	}
}

SoundDevice*
sound_pulse_audio_manager_get_default_input (SoundPulseAudioManager* self)
{
	SoundDevice* result;
	SoundDevice* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_default_input;
	result = _tmp0_;
	return result;
}

static void
sound_pulse_audio_manager_set_default_input (SoundPulseAudioManager* self,
                                             SoundDevice* value)
{
	SoundDevice* old_value;
	g_return_if_fail (self != NULL);
	old_value = sound_pulse_audio_manager_get_default_input (self);
	if (old_value != value) {
		SoundDevice* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_default_input);
		self->priv->_default_input = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, sound_pulse_audio_manager_properties[SOUND_PULSE_AUDIO_MANAGER_DEFAULT_INPUT_PROPERTY]);
	}
}

static gboolean
_vala_string_array_contains (gchar* * stack,
                             gssize stack_length,
                             const gchar* needle)
{
	gssize i;
	for (i = 0; i < stack_length; i++) {
		if (g_strcmp0 (stack[i], needle) == 0) {
			return TRUE;
		}
	}
	return FALSE;
}

static GObject *
sound_pulse_audio_manager_constructor (GType type,
                                       guint n_construct_properties,
                                       GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	SoundPulseAudioManager * self;
	pa_glib_mainloop* _tmp0_;
	GListStore* _tmp1_;
	GListStore* _tmp2_;
	GeeHashMap* _tmp3_;
	GeeHashMap* _tmp4_;
	GeeHashMap* _tmp5_;
	gchar* messages_debug_raw = NULL;
	const gchar* _tmp6_;
	gchar* _tmp7_;
	const gchar* _tmp8_;
	parent_class = G_OBJECT_CLASS (sound_pulse_audio_manager_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SOUND_TYPE_PULSE_AUDIO_MANAGER, SoundPulseAudioManager);
	_tmp0_ = pa_glib_mainloop_new (NULL);
	_pa_glib_mainloop_free0 (self->priv->loop);
	self->priv->loop = _tmp0_;
	_tmp1_ = g_list_store_new (SOUND_TYPE_APP);
	_tmp2_ = _tmp1_;
	sound_pulse_audio_manager_set_apps (self, _tmp2_);
	_g_object_unref0 (_tmp2_);
	_tmp3_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, SOUND_TYPE_DEVICE, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->input_devices);
	self->priv->input_devices = _tmp3_;
	_tmp4_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, SOUND_TYPE_DEVICE, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->output_devices);
	self->priv->output_devices = _tmp4_;
	_tmp5_ = gee_hash_map_new (G_TYPE_UINT, NULL, NULL, G_TYPE_POINTER, (GBoxedCopyFunc) pa_operation_ref, (GDestroyNotify) pa_operation_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->volume_operations);
	self->priv->volume_operations = _tmp5_;
	_tmp6_ = g_getenv ("G_MESSAGES_DEBUG");
	_tmp7_ = g_strdup (_tmp6_);
	messages_debug_raw = _tmp7_;
	_tmp8_ = messages_debug_raw;
	if (_tmp8_ != NULL) {
		gchar** messages_debug = NULL;
		const gchar* _tmp9_;
		gchar** _tmp10_;
		gchar** _tmp11_;
		gint messages_debug_length1;
		gint _messages_debug_size_;
		gboolean _tmp12_ = FALSE;
		gchar** _tmp13_;
		gint _tmp13__length1;
		_tmp9_ = messages_debug_raw;
		_tmp11_ = _tmp10_ = g_strsplit (_tmp9_, " ", 0);
		messages_debug = _tmp11_;
		messages_debug_length1 = _vala_array_length (_tmp10_);
		_messages_debug_size_ = messages_debug_length1;
		_tmp13_ = messages_debug;
		_tmp13__length1 = messages_debug_length1;
		if (_vala_string_array_contains (_tmp13_, _tmp13__length1, "all")) {
			_tmp12_ = TRUE;
		} else {
			gchar** _tmp14_;
			gint _tmp14__length1;
			_tmp14_ = messages_debug;
			_tmp14__length1 = messages_debug_length1;
			_tmp12_ = _vala_string_array_contains (_tmp14_, _tmp14__length1, "debug");
		}
		sound_pulse_audio_manager_debug_enabled = _tmp12_;
		messages_debug = (_vala_array_free (messages_debug, messages_debug_length1, (GDestroyNotify) g_free), NULL);
	}
	_g_free0 (messages_debug_raw);
	return obj;
}

static void
sound_pulse_audio_manager_class_init (SoundPulseAudioManagerClass * klass,
                                      gpointer klass_data)
{
	sound_pulse_audio_manager_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &SoundPulseAudioManager_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_sound_pulse_audio_manager_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_sound_pulse_audio_manager_set_property;
	G_OBJECT_CLASS (klass)->constructor = sound_pulse_audio_manager_constructor;
	G_OBJECT_CLASS (klass)->finalize = sound_pulse_audio_manager_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), SOUND_PULSE_AUDIO_MANAGER_CONTEXT_PROPERTY, sound_pulse_audio_manager_properties[SOUND_PULSE_AUDIO_MANAGER_CONTEXT_PROPERTY] = g_param_spec_pointer ("context", "context", "context", G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SOUND_PULSE_AUDIO_MANAGER_APPS_PROPERTY, sound_pulse_audio_manager_properties[SOUND_PULSE_AUDIO_MANAGER_APPS_PROPERTY] = g_param_spec_object ("apps", "apps", "apps", g_list_store_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SOUND_PULSE_AUDIO_MANAGER_DEFAULT_OUTPUT_PROPERTY, sound_pulse_audio_manager_properties[SOUND_PULSE_AUDIO_MANAGER_DEFAULT_OUTPUT_PROPERTY] = g_param_spec_object ("default-output", "default-output", "default-output", SOUND_TYPE_DEVICE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SOUND_PULSE_AUDIO_MANAGER_DEFAULT_INPUT_PROPERTY, sound_pulse_audio_manager_properties[SOUND_PULSE_AUDIO_MANAGER_DEFAULT_INPUT_PROPERTY] = g_param_spec_object ("default-input", "default-input", "default-input", SOUND_TYPE_DEVICE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	sound_pulse_audio_manager_signals[SOUND_PULSE_AUDIO_MANAGER_NEW_DEVICE_SIGNAL] = g_signal_new ("new-device", SOUND_TYPE_PULSE_AUDIO_MANAGER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, SOUND_TYPE_DEVICE);
}

static void
sound_pulse_audio_manager_instance_init (SoundPulseAudioManager * self,
                                         gpointer klass)
{
	self->priv = sound_pulse_audio_manager_get_instance_private (self);
	self->priv->is_ready = FALSE;
	self->priv->reconnect_timer_id = 0U;
}

static void
sound_pulse_audio_manager_finalize (GObject * obj)
{
	SoundPulseAudioManager * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SOUND_TYPE_PULSE_AUDIO_MANAGER, SoundPulseAudioManager);
	_pa_context_unref0 (self->priv->_context);
	_g_object_unref0 (self->priv->_apps);
	_pa_glib_mainloop_free0 (self->priv->loop);
	_g_object_unref0 (self->priv->input_devices);
	_g_object_unref0 (self->priv->output_devices);
	_g_object_unref0 (self->priv->_default_output);
	_g_object_unref0 (self->priv->_default_input);
	_g_free0 (self->priv->default_source_name);
	_g_free0 (self->priv->default_sink_name);
	_g_object_unref0 (self->priv->volume_operations);
	G_OBJECT_CLASS (sound_pulse_audio_manager_parent_class)->finalize (obj);
}

static GType
sound_pulse_audio_manager_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SoundPulseAudioManagerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) sound_pulse_audio_manager_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SoundPulseAudioManager), 0, (GInstanceInitFunc) sound_pulse_audio_manager_instance_init, NULL };
	GType sound_pulse_audio_manager_type_id;
	sound_pulse_audio_manager_type_id = g_type_register_static (G_TYPE_OBJECT, "SoundPulseAudioManager", &g_define_type_info, 0);
	SoundPulseAudioManager_private_offset = g_type_add_instance_private (sound_pulse_audio_manager_type_id, sizeof (SoundPulseAudioManagerPrivate));
	return sound_pulse_audio_manager_type_id;
}

GType
sound_pulse_audio_manager_get_type (void)
{
	static volatile gsize sound_pulse_audio_manager_type_id__once = 0;
	if (g_once_init_enter (&sound_pulse_audio_manager_type_id__once)) {
		GType sound_pulse_audio_manager_type_id;
		sound_pulse_audio_manager_type_id = sound_pulse_audio_manager_get_type_once ();
		g_once_init_leave (&sound_pulse_audio_manager_type_id__once, sound_pulse_audio_manager_type_id);
	}
	return sound_pulse_audio_manager_type_id__once;
}

static void
_vala_sound_pulse_audio_manager_get_property (GObject * object,
                                              guint property_id,
                                              GValue * value,
                                              GParamSpec * pspec)
{
	SoundPulseAudioManager * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SOUND_TYPE_PULSE_AUDIO_MANAGER, SoundPulseAudioManager);
	switch (property_id) {
		case SOUND_PULSE_AUDIO_MANAGER_CONTEXT_PROPERTY:
		g_value_set_pointer (value, sound_pulse_audio_manager_get_context (self));
		break;
		case SOUND_PULSE_AUDIO_MANAGER_APPS_PROPERTY:
		g_value_set_object (value, sound_pulse_audio_manager_get_apps (self));
		break;
		case SOUND_PULSE_AUDIO_MANAGER_DEFAULT_OUTPUT_PROPERTY:
		g_value_set_object (value, sound_pulse_audio_manager_get_default_output (self));
		break;
		case SOUND_PULSE_AUDIO_MANAGER_DEFAULT_INPUT_PROPERTY:
		g_value_set_object (value, sound_pulse_audio_manager_get_default_input (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_sound_pulse_audio_manager_set_property (GObject * object,
                                              guint property_id,
                                              const GValue * value,
                                              GParamSpec * pspec)
{
	SoundPulseAudioManager * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SOUND_TYPE_PULSE_AUDIO_MANAGER, SoundPulseAudioManager);
	switch (property_id) {
		case SOUND_PULSE_AUDIO_MANAGER_CONTEXT_PROPERTY:
		sound_pulse_audio_manager_set_context (self, g_value_get_pointer (value));
		break;
		case SOUND_PULSE_AUDIO_MANAGER_APPS_PROPERTY:
		sound_pulse_audio_manager_set_apps (self, g_value_get_object (value));
		break;
		case SOUND_PULSE_AUDIO_MANAGER_DEFAULT_OUTPUT_PROPERTY:
		sound_pulse_audio_manager_set_default_output (self, g_value_get_object (value));
		break;
		case SOUND_PULSE_AUDIO_MANAGER_DEFAULT_INPUT_PROPERTY:
		sound_pulse_audio_manager_set_default_input (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

