/* PasswordEditor.c generated by valac 0.56.17, the Vala compiler
 * generated from PasswordEditor.vala, do not modify */

/*
* Copyright (c) 2014-2017 elementary LLC. (https://elementary.io)
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public
* License as published by the Free Software Foundation; either
* version 3 of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* General Public License for more details.
*
* You should have received a copy of the GNU General Public
* License along with this program; if not, write to the
* Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
* Boston, MA 02110-1301 USA
*/

#include "useraccounts.h"
#include <gtk/gtk.h>
#include <glib-object.h>
#include <granite-7.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <float.h>
#include <math.h>
#include <pwquality.h>
#include <glib/gi18n-lib.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define SWITCHBOARD_PLUG_USER_ACCOUNTS_TYPE_ERROR_REVEALER (switchboard_plug_user_accounts_error_revealer_get_type ())
#define SWITCHBOARD_PLUG_USER_ACCOUNTS_ERROR_REVEALER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SWITCHBOARD_PLUG_USER_ACCOUNTS_TYPE_ERROR_REVEALER, SwitchboardPlugUserAccountsErrorRevealer))
#define SWITCHBOARD_PLUG_USER_ACCOUNTS_ERROR_REVEALER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SWITCHBOARD_PLUG_USER_ACCOUNTS_TYPE_ERROR_REVEALER, SwitchboardPlugUserAccountsErrorRevealerClass))
#define SWITCHBOARD_PLUG_USER_ACCOUNTS_IS_ERROR_REVEALER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SWITCHBOARD_PLUG_USER_ACCOUNTS_TYPE_ERROR_REVEALER))
#define SWITCHBOARD_PLUG_USER_ACCOUNTS_IS_ERROR_REVEALER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SWITCHBOARD_PLUG_USER_ACCOUNTS_TYPE_ERROR_REVEALER))
#define SWITCHBOARD_PLUG_USER_ACCOUNTS_ERROR_REVEALER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SWITCHBOARD_PLUG_USER_ACCOUNTS_TYPE_ERROR_REVEALER, SwitchboardPlugUserAccountsErrorRevealerClass))

typedef struct _SwitchboardPlugUserAccountsErrorRevealer SwitchboardPlugUserAccountsErrorRevealer;
typedef struct _SwitchboardPlugUserAccountsErrorRevealerClass SwitchboardPlugUserAccountsErrorRevealerClass;

#define SWITCHBOARD_PLUG_USER_ACCOUNTS_WIDGETS_PASSWORD_EDITOR_TYPE_VALIDATED_ENTRY (switchboard_plug_user_accounts_widgets_password_editor_validated_entry_get_type ())
#define SWITCHBOARD_PLUG_USER_ACCOUNTS_WIDGETS_PASSWORD_EDITOR_VALIDATED_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SWITCHBOARD_PLUG_USER_ACCOUNTS_WIDGETS_PASSWORD_EDITOR_TYPE_VALIDATED_ENTRY, SwitchboardPlugUserAccountsWidgetsPasswordEditorValidatedEntry))
#define SWITCHBOARD_PLUG_USER_ACCOUNTS_WIDGETS_PASSWORD_EDITOR_VALIDATED_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SWITCHBOARD_PLUG_USER_ACCOUNTS_WIDGETS_PASSWORD_EDITOR_TYPE_VALIDATED_ENTRY, SwitchboardPlugUserAccountsWidgetsPasswordEditorValidatedEntryClass))
#define SWITCHBOARD_PLUG_USER_ACCOUNTS_WIDGETS_PASSWORD_EDITOR_IS_VALIDATED_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SWITCHBOARD_PLUG_USER_ACCOUNTS_WIDGETS_PASSWORD_EDITOR_TYPE_VALIDATED_ENTRY))
#define SWITCHBOARD_PLUG_USER_ACCOUNTS_WIDGETS_PASSWORD_EDITOR_IS_VALIDATED_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SWITCHBOARD_PLUG_USER_ACCOUNTS_WIDGETS_PASSWORD_EDITOR_TYPE_VALIDATED_ENTRY))
#define SWITCHBOARD_PLUG_USER_ACCOUNTS_WIDGETS_PASSWORD_EDITOR_VALIDATED_ENTRY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SWITCHBOARD_PLUG_USER_ACCOUNTS_WIDGETS_PASSWORD_EDITOR_TYPE_VALIDATED_ENTRY, SwitchboardPlugUserAccountsWidgetsPasswordEditorValidatedEntryClass))

typedef struct _SwitchboardPlugUserAccountsWidgetsPasswordEditorValidatedEntry SwitchboardPlugUserAccountsWidgetsPasswordEditorValidatedEntry;
typedef struct _SwitchboardPlugUserAccountsWidgetsPasswordEditorValidatedEntryClass SwitchboardPlugUserAccountsWidgetsPasswordEditorValidatedEntryClass;
enum  {
	SWITCHBOARD_PLUG_USER_ACCOUNTS_WIDGETS_PASSWORD_EDITOR_0_PROPERTY,
	SWITCHBOARD_PLUG_USER_ACCOUNTS_WIDGETS_PASSWORD_EDITOR_CURRENT_PW_ENTRY_PROPERTY,
	SWITCHBOARD_PLUG_USER_ACCOUNTS_WIDGETS_PASSWORD_EDITOR_IS_OBSCURE_PROPERTY,
	SWITCHBOARD_PLUG_USER_ACCOUNTS_WIDGETS_PASSWORD_EDITOR_IS_VALID_PROPERTY,
	SWITCHBOARD_PLUG_USER_ACCOUNTS_WIDGETS_PASSWORD_EDITOR_NUM_PROPERTIES
};
static GParamSpec* switchboard_plug_user_accounts_widgets_password_editor_properties[SWITCHBOARD_PLUG_USER_ACCOUNTS_WIDGETS_PASSWORD_EDITOR_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _pwquality_free_settings0(var) ((var == NULL) ? NULL : (var = (pwquality_free_settings (var), NULL)))
typedef struct _SwitchboardPlugUserAccountsWidgetsPasswordEditorValidatedEntryPrivate SwitchboardPlugUserAccountsWidgetsPasswordEditorValidatedEntryPrivate;
enum  {
	SWITCHBOARD_PLUG_USER_ACCOUNTS_WIDGETS_PASSWORD_EDITOR_VALIDATED_ENTRY_0_PROPERTY,
	SWITCHBOARD_PLUG_USER_ACCOUNTS_WIDGETS_PASSWORD_EDITOR_VALIDATED_ENTRY_IS_VALID_PROPERTY,
	SWITCHBOARD_PLUG_USER_ACCOUNTS_WIDGETS_PASSWORD_EDITOR_VALIDATED_ENTRY_NUM_PROPERTIES
};
static GParamSpec* switchboard_plug_user_accounts_widgets_password_editor_validated_entry_properties[SWITCHBOARD_PLUG_USER_ACCOUNTS_WIDGETS_PASSWORD_EDITOR_VALIDATED_ENTRY_NUM_PROPERTIES];
enum  {
	SWITCHBOARD_PLUG_USER_ACCOUNTS_WIDGETS_PASSWORD_EDITOR_VALIDATION_CHANGED_SIGNAL,
	SWITCHBOARD_PLUG_USER_ACCOUNTS_WIDGETS_PASSWORD_EDITOR_NUM_SIGNALS
};
static guint switchboard_plug_user_accounts_widgets_password_editor_signals[SWITCHBOARD_PLUG_USER_ACCOUNTS_WIDGETS_PASSWORD_EDITOR_NUM_SIGNALS] = {0};

struct _SwitchboardPlugUserAccountsWidgetsPasswordEditorPrivate {
	SwitchboardPlugUserAccountsErrorRevealer* confirm_entry_revealer;
	SwitchboardPlugUserAccountsErrorRevealer* pw_error_revealer;
	GtkLevelBar* pw_levelbar;
	SwitchboardPlugUserAccountsWidgetsPasswordEditorValidatedEntry* pw_entry;
	GraniteValidatedEntry* confirm_entry;
	GtkEntry* _current_pw_entry;
	gboolean _is_obscure;
	gboolean _is_valid;
};

struct _SwitchboardPlugUserAccountsWidgetsPasswordEditorValidatedEntry {
	GtkEntry parent_instance;
	SwitchboardPlugUserAccountsWidgetsPasswordEditorValidatedEntryPrivate * priv;
};

struct _SwitchboardPlugUserAccountsWidgetsPasswordEditorValidatedEntryClass {
	GtkEntryClass parent_class;
};

struct _SwitchboardPlugUserAccountsWidgetsPasswordEditorValidatedEntryPrivate {
	gboolean _is_valid;
};

static gint SwitchboardPlugUserAccountsWidgetsPasswordEditor_private_offset;
static gpointer switchboard_plug_user_accounts_widgets_password_editor_parent_class = NULL;
static gint SwitchboardPlugUserAccountsWidgetsPasswordEditorValidatedEntry_private_offset;
static gpointer switchboard_plug_user_accounts_widgets_password_editor_validated_entry_parent_class = NULL;

VALA_EXTERN GType switchboard_plug_user_accounts_error_revealer_get_type (void) G_GNUC_CONST ;
static GType switchboard_plug_user_accounts_widgets_password_editor_validated_entry_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
static void switchboard_plug_user_accounts_widgets_password_editor_validate_form (SwitchboardPlugUserAccountsWidgetsPasswordEditor* self);
static gboolean switchboard_plug_user_accounts_widgets_password_editor_validated_entry_get_is_valid (SwitchboardPlugUserAccountsWidgetsPasswordEditorValidatedEntry* self);
static void switchboard_plug_user_accounts_widgets_password_editor_set_is_valid (SwitchboardPlugUserAccountsWidgetsPasswordEditor* self,
                                                                          gboolean value);
static gboolean switchboard_plug_user_accounts_widgets_password_editor_check_password (SwitchboardPlugUserAccountsWidgetsPasswordEditor* self);
VALA_EXTERN void switchboard_plug_user_accounts_error_revealer_set_reveal_child (SwitchboardPlugUserAccountsErrorRevealer* self,
                                                                     gboolean value);
static void switchboard_plug_user_accounts_widgets_password_editor_set_is_obscure (SwitchboardPlugUserAccountsWidgetsPasswordEditor* self,
                                                                            gboolean value);
VALA_EXTERN void switchboard_plug_user_accounts_error_revealer_set_label (SwitchboardPlugUserAccountsErrorRevealer* self,
                                                              const gchar* value);
static gboolean switchboard_plug_user_accounts_widgets_password_editor_confirm_password (SwitchboardPlugUserAccountsWidgetsPasswordEditor* self);
static SwitchboardPlugUserAccountsWidgetsPasswordEditorValidatedEntry* switchboard_plug_user_accounts_widgets_password_editor_validated_entry_new (void);
static SwitchboardPlugUserAccountsWidgetsPasswordEditorValidatedEntry* switchboard_plug_user_accounts_widgets_password_editor_validated_entry_construct (GType object_type);
static void switchboard_plug_user_accounts_widgets_password_editor_validated_entry_set_is_valid (SwitchboardPlugUserAccountsWidgetsPasswordEditorValidatedEntry* self,
                                                                                          gboolean value);
static GObject * switchboard_plug_user_accounts_widgets_password_editor_validated_entry_constructor (GType type,
                                                                                              guint n_construct_properties,
                                                                                              GObjectConstructParam * construct_properties);
static void switchboard_plug_user_accounts_widgets_password_editor_validated_entry_finalize (GObject * obj);
static GType switchboard_plug_user_accounts_widgets_password_editor_validated_entry_get_type_once (void);
static void _vala_switchboard_plug_user_accounts_widgets_password_editor_validated_entry_get_property (GObject * object,
                                                                                                guint property_id,
                                                                                                GValue * value,
                                                                                                GParamSpec * pspec);
static void _vala_switchboard_plug_user_accounts_widgets_password_editor_validated_entry_set_property (GObject * object,
                                                                                                guint property_id,
                                                                                                const GValue * value,
                                                                                                GParamSpec * pspec);
static GObject * switchboard_plug_user_accounts_widgets_password_editor_constructor (GType type,
                                                                              guint n_construct_properties,
                                                                              GObjectConstructParam * construct_properties);
VALA_EXTERN SwitchboardPlugUserAccountsErrorRevealer* switchboard_plug_user_accounts_error_revealer_new (const gchar* label);
VALA_EXTERN SwitchboardPlugUserAccountsErrorRevealer* switchboard_plug_user_accounts_error_revealer_construct (GType object_type,
                                                                                                   const gchar* label);
VALA_EXTERN GtkLabel* switchboard_plug_user_accounts_error_revealer_get_label_widget (SwitchboardPlugUserAccountsErrorRevealer* self);
static void _switchboard_plug_user_accounts_widgets_password_editor___lambda18_ (SwitchboardPlugUserAccountsWidgetsPasswordEditor* self);
static void __switchboard_plug_user_accounts_widgets_password_editor___lambda18__gtk_editable_changed (GtkEditable* _sender,
                                                                                                gpointer self);
static void _switchboard_plug_user_accounts_widgets_password_editor___lambda19_ (SwitchboardPlugUserAccountsWidgetsPasswordEditor* self);
static void __switchboard_plug_user_accounts_widgets_password_editor___lambda19__gtk_editable_changed (GtkEditable* _sender,
                                                                                                gpointer self);
static void switchboard_plug_user_accounts_widgets_password_editor_finalize (GObject * obj);
static GType switchboard_plug_user_accounts_widgets_password_editor_get_type_once (void);
static void _vala_switchboard_plug_user_accounts_widgets_password_editor_get_property (GObject * object,
                                                                                guint property_id,
                                                                                GValue * value,
                                                                                GParamSpec * pspec);
static void _vala_switchboard_plug_user_accounts_widgets_password_editor_set_property (GObject * object,
                                                                                guint property_id,
                                                                                const GValue * value,
                                                                                GParamSpec * pspec);

static inline gpointer
switchboard_plug_user_accounts_widgets_password_editor_get_instance_private (SwitchboardPlugUserAccountsWidgetsPasswordEditor* self)
{
	return G_STRUCT_MEMBER_P (self, SwitchboardPlugUserAccountsWidgetsPasswordEditor_private_offset);
}

SwitchboardPlugUserAccountsWidgetsPasswordEditor*
switchboard_plug_user_accounts_widgets_password_editor_construct (GType object_type,
                                                                  GtkEntry* current_pw_entry)
{
	SwitchboardPlugUserAccountsWidgetsPasswordEditor * self = NULL;
	self = (SwitchboardPlugUserAccountsWidgetsPasswordEditor*) g_object_new (object_type, "current-pw-entry", current_pw_entry, NULL);
	return self;
}

SwitchboardPlugUserAccountsWidgetsPasswordEditor*
switchboard_plug_user_accounts_widgets_password_editor_new (GtkEntry* current_pw_entry)
{
	return switchboard_plug_user_accounts_widgets_password_editor_construct (SWITCHBOARD_PLUG_USER_ACCOUNTS_WIDGETS_TYPE_PASSWORD_EDITOR, current_pw_entry);
}

static void
switchboard_plug_user_accounts_widgets_password_editor_validate_form (SwitchboardPlugUserAccountsWidgetsPasswordEditor* self)
{
	gboolean _tmp0_ = FALSE;
	SwitchboardPlugUserAccountsWidgetsPasswordEditorValidatedEntry* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp1_ = self->priv->pw_entry;
	_tmp2_ = switchboard_plug_user_accounts_widgets_password_editor_validated_entry_get_is_valid (_tmp1_);
	_tmp3_ = _tmp2_;
	if (_tmp3_) {
		GraniteValidatedEntry* _tmp4_;
		gboolean _tmp5_;
		gboolean _tmp6_;
		_tmp4_ = self->priv->confirm_entry;
		_tmp5_ = granite_validated_entry_get_is_valid (_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp0_ = _tmp6_;
	} else {
		_tmp0_ = FALSE;
	}
	switchboard_plug_user_accounts_widgets_password_editor_set_is_valid (self, _tmp0_);
	g_signal_emit (self, switchboard_plug_user_accounts_widgets_password_editor_signals[SWITCHBOARD_PLUG_USER_ACCOUNTS_WIDGETS_PASSWORD_EDITOR_VALIDATION_CHANGED_SIGNAL], 0);
}

static gchar*
pwquality_error_to_string (int self,
                           void* auxerror)
{
	gchar* ret = NULL;
	const gchar** retp = NULL;
	const gchar** _tmp0_;
	void* _tmp1_;
	void* res = NULL;
	const gchar** _tmp2_;
	void* _tmp3_;
	void* _tmp4_;
	const gchar** _tmp5_;
	gchar* result;
	ret = NULL;
	retp = &ret;
	_tmp0_ = retp;
	_tmp1_ = g_malloc ((gsize) PWQ_MAX_ERROR_MESSAGE_LEN);
	*_tmp0_ = _tmp1_;
	_tmp2_ = retp;
	_tmp3_ = pwquality_strerror (*_tmp2_, (gsize) PWQ_MAX_ERROR_MESSAGE_LEN, self, auxerror);
	res = _tmp3_;
	_tmp4_ = res;
	_tmp5_ = retp;
	if (_tmp4_ != (*_tmp5_)) {
		const gchar** _tmp6_;
		void* _tmp7_;
		void* _tmp8_;
		gint _tmp9_;
		gint _tmp10_;
		_tmp6_ = retp;
		_tmp7_ = res;
		_tmp8_ = res;
		_tmp9_ = strlen ((const gchar*) _tmp8_);
		_tmp10_ = _tmp9_;
		memcpy (*_tmp6_, _tmp7_, (gsize) (_tmp10_ + 1));
	}
	result = ret;
	return result;
}

static gboolean
switchboard_plug_user_accounts_widgets_password_editor_check_password (SwitchboardPlugUserAccountsWidgetsPasswordEditor* self)
{
	SwitchboardPlugUserAccountsWidgetsPasswordEditorValidatedEntry* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->pw_entry;
	_tmp1_ = gtk_editable_get_text ((GtkEditable*) _tmp0_);
	_tmp2_ = _tmp1_;
	if (g_strcmp0 (_tmp2_, "") == 0) {
		GraniteValidatedEntry* _tmp3_;
		GraniteValidatedEntry* _tmp4_;
		GtkLevelBar* _tmp5_;
		SwitchboardPlugUserAccountsWidgetsPasswordEditorValidatedEntry* _tmp6_;
		SwitchboardPlugUserAccountsErrorRevealer* _tmp7_;
		_tmp3_ = self->priv->confirm_entry;
		gtk_editable_set_text ((GtkEditable*) _tmp3_, "");
		_tmp4_ = self->priv->confirm_entry;
		gtk_widget_set_sensitive ((GtkWidget*) _tmp4_, FALSE);
		_tmp5_ = self->priv->pw_levelbar;
		gtk_level_bar_set_value (_tmp5_, (gdouble) 0);
		_tmp6_ = self->priv->pw_entry;
		gtk_entry_set_icon_from_icon_name ((GtkEntry*) _tmp6_, GTK_ENTRY_ICON_SECONDARY, NULL);
		_tmp7_ = self->priv->pw_error_revealer;
		switchboard_plug_user_accounts_error_revealer_set_reveal_child (_tmp7_, FALSE);
	} else {
		GraniteValidatedEntry* _tmp8_;
		gchar* current_pw = NULL;
		GtkEntry* _tmp9_;
		pwquality_settings_t* pwquality = NULL;
		pwquality_settings_t* _tmp14_;
		void* _error_ = NULL;
		gint quality = 0;
		pwquality_settings_t* _tmp15_;
		SwitchboardPlugUserAccountsWidgetsPasswordEditorValidatedEntry* _tmp16_;
		const gchar* _tmp17_;
		const gchar* _tmp18_;
		const gchar* _tmp19_;
		void* _tmp20_ = NULL;
		gint _tmp21_;
		_tmp8_ = self->priv->confirm_entry;
		gtk_widget_set_sensitive ((GtkWidget*) _tmp8_, TRUE);
		current_pw = NULL;
		_tmp9_ = self->priv->_current_pw_entry;
		if (_tmp9_ != NULL) {
			GtkEntry* _tmp10_;
			const gchar* _tmp11_;
			const gchar* _tmp12_;
			gchar* _tmp13_;
			_tmp10_ = self->priv->_current_pw_entry;
			_tmp11_ = gtk_editable_get_text ((GtkEditable*) _tmp10_);
			_tmp12_ = _tmp11_;
			_tmp13_ = g_strdup (_tmp12_);
			_g_free0 (current_pw);
			current_pw = _tmp13_;
		}
		_tmp14_ = pwquality_default_settings ();
		pwquality = _tmp14_;
		_tmp15_ = pwquality;
		_tmp16_ = self->priv->pw_entry;
		_tmp17_ = gtk_editable_get_text ((GtkEditable*) _tmp16_);
		_tmp18_ = _tmp17_;
		_tmp19_ = current_pw;
		_tmp21_ = pwquality_check (_tmp15_, _tmp18_, _tmp19_, NULL, &_tmp20_);
		_error_ = _tmp20_;
		quality = _tmp21_;
		if (quality >= 0) {
			SwitchboardPlugUserAccountsWidgetsPasswordEditorValidatedEntry* _tmp22_;
			SwitchboardPlugUserAccountsErrorRevealer* _tmp23_;
			GtkLevelBar* _tmp24_;
			_tmp22_ = self->priv->pw_entry;
			gtk_entry_set_icon_from_icon_name ((GtkEntry*) _tmp22_, GTK_ENTRY_ICON_SECONDARY, "process-completed-symbolic");
			_tmp23_ = self->priv->pw_error_revealer;
			switchboard_plug_user_accounts_error_revealer_set_reveal_child (_tmp23_, FALSE);
			_tmp24_ = self->priv->pw_levelbar;
			gtk_level_bar_set_value (_tmp24_, (gdouble) quality);
			switchboard_plug_user_accounts_widgets_password_editor_set_is_obscure (self, TRUE);
		} else {
			SwitchboardPlugUserAccountsWidgetsPasswordEditorValidatedEntry* _tmp25_;
			SwitchboardPlugUserAccountsErrorRevealer* _tmp26_;
			SwitchboardPlugUserAccountsErrorRevealer* _tmp27_;
			void* _tmp28_;
			gchar* _tmp29_;
			gchar* _tmp30_;
			GtkLevelBar* _tmp31_;
			_tmp25_ = self->priv->pw_entry;
			gtk_entry_set_icon_from_icon_name ((GtkEntry*) _tmp25_, GTK_ENTRY_ICON_SECONDARY, "dialog-warning-symbolic");
			_tmp26_ = self->priv->pw_error_revealer;
			switchboard_plug_user_accounts_error_revealer_set_reveal_child (_tmp26_, TRUE);
			_tmp27_ = self->priv->pw_error_revealer;
			_tmp28_ = _error_;
			_tmp29_ = pwquality_error_to_string ((int) quality, _tmp28_);
			_tmp30_ = _tmp29_;
			switchboard_plug_user_accounts_error_revealer_set_label (_tmp27_, _tmp30_);
			_g_free0 (_tmp30_);
			_tmp31_ = self->priv->pw_levelbar;
			gtk_level_bar_set_value (_tmp31_, (gdouble) 0);
			switchboard_plug_user_accounts_widgets_password_editor_set_is_obscure (self, FALSE);
		}
		result = TRUE;
		_pwquality_free_settings0 (pwquality);
		_g_free0 (current_pw);
		return result;
	}
	result = FALSE;
	return result;
}

static gboolean
switchboard_plug_user_accounts_widgets_password_editor_confirm_password (SwitchboardPlugUserAccountsWidgetsPasswordEditor* self)
{
	GraniteValidatedEntry* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->confirm_entry;
	_tmp1_ = gtk_editable_get_text ((GtkEditable*) _tmp0_);
	_tmp2_ = _tmp1_;
	if (g_strcmp0 (_tmp2_, "") != 0) {
		SwitchboardPlugUserAccountsWidgetsPasswordEditorValidatedEntry* _tmp3_;
		const gchar* _tmp4_;
		const gchar* _tmp5_;
		GraniteValidatedEntry* _tmp6_;
		const gchar* _tmp7_;
		const gchar* _tmp8_;
		_tmp3_ = self->priv->pw_entry;
		_tmp4_ = gtk_editable_get_text ((GtkEditable*) _tmp3_);
		_tmp5_ = _tmp4_;
		_tmp6_ = self->priv->confirm_entry;
		_tmp7_ = gtk_editable_get_text ((GtkEditable*) _tmp6_);
		_tmp8_ = _tmp7_;
		if (g_strcmp0 (_tmp5_, _tmp8_) != 0) {
			SwitchboardPlugUserAccountsErrorRevealer* _tmp9_;
			SwitchboardPlugUserAccountsErrorRevealer* _tmp10_;
			_tmp9_ = self->priv->confirm_entry_revealer;
			switchboard_plug_user_accounts_error_revealer_set_label (_tmp9_, _ ("Passwords do not match"));
			_tmp10_ = self->priv->confirm_entry_revealer;
			switchboard_plug_user_accounts_error_revealer_set_reveal_child (_tmp10_, TRUE);
		} else {
			SwitchboardPlugUserAccountsErrorRevealer* _tmp11_;
			_tmp11_ = self->priv->confirm_entry_revealer;
			switchboard_plug_user_accounts_error_revealer_set_reveal_child (_tmp11_, FALSE);
			result = TRUE;
			return result;
		}
	} else {
		SwitchboardPlugUserAccountsErrorRevealer* _tmp12_;
		_tmp12_ = self->priv->confirm_entry_revealer;
		switchboard_plug_user_accounts_error_revealer_set_reveal_child (_tmp12_, FALSE);
	}
	result = FALSE;
	return result;
}

gchar*
switchboard_plug_user_accounts_widgets_password_editor_get_password (SwitchboardPlugUserAccountsWidgetsPasswordEditor* self)
{
	gboolean _tmp0_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_is_valid;
	if (_tmp0_) {
		SwitchboardPlugUserAccountsWidgetsPasswordEditorValidatedEntry* _tmp1_;
		const gchar* _tmp2_;
		const gchar* _tmp3_;
		gchar* _tmp4_;
		_tmp1_ = self->priv->pw_entry;
		_tmp2_ = gtk_editable_get_text ((GtkEditable*) _tmp1_);
		_tmp3_ = _tmp2_;
		_tmp4_ = g_strdup (_tmp3_);
		result = _tmp4_;
		return result;
	} else {
		result = NULL;
		return result;
	}
}

GtkEntry*
switchboard_plug_user_accounts_widgets_password_editor_get_current_pw_entry (SwitchboardPlugUserAccountsWidgetsPasswordEditor* self)
{
	GtkEntry* result;
	GtkEntry* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_current_pw_entry;
	result = _tmp0_;
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
switchboard_plug_user_accounts_widgets_password_editor_set_current_pw_entry (SwitchboardPlugUserAccountsWidgetsPasswordEditor* self,
                                                                             GtkEntry* value)
{
	GtkEntry* old_value;
	g_return_if_fail (self != NULL);
	old_value = switchboard_plug_user_accounts_widgets_password_editor_get_current_pw_entry (self);
	if (old_value != value) {
		GtkEntry* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_current_pw_entry);
		self->priv->_current_pw_entry = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, switchboard_plug_user_accounts_widgets_password_editor_properties[SWITCHBOARD_PLUG_USER_ACCOUNTS_WIDGETS_PASSWORD_EDITOR_CURRENT_PW_ENTRY_PROPERTY]);
	}
}

gboolean
switchboard_plug_user_accounts_widgets_password_editor_get_is_obscure (SwitchboardPlugUserAccountsWidgetsPasswordEditor* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_is_obscure;
	return result;
}

static void
switchboard_plug_user_accounts_widgets_password_editor_set_is_obscure (SwitchboardPlugUserAccountsWidgetsPasswordEditor* self,
                                                                       gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = switchboard_plug_user_accounts_widgets_password_editor_get_is_obscure (self);
	if (old_value != value) {
		self->priv->_is_obscure = value;
		g_object_notify_by_pspec ((GObject *) self, switchboard_plug_user_accounts_widgets_password_editor_properties[SWITCHBOARD_PLUG_USER_ACCOUNTS_WIDGETS_PASSWORD_EDITOR_IS_OBSCURE_PROPERTY]);
	}
}

gboolean
switchboard_plug_user_accounts_widgets_password_editor_get_is_valid (SwitchboardPlugUserAccountsWidgetsPasswordEditor* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_is_valid;
	return result;
}

static void
switchboard_plug_user_accounts_widgets_password_editor_set_is_valid (SwitchboardPlugUserAccountsWidgetsPasswordEditor* self,
                                                                     gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = switchboard_plug_user_accounts_widgets_password_editor_get_is_valid (self);
	if (old_value != value) {
		self->priv->_is_valid = value;
		g_object_notify_by_pspec ((GObject *) self, switchboard_plug_user_accounts_widgets_password_editor_properties[SWITCHBOARD_PLUG_USER_ACCOUNTS_WIDGETS_PASSWORD_EDITOR_IS_VALID_PROPERTY]);
	}
}

static inline gpointer
switchboard_plug_user_accounts_widgets_password_editor_validated_entry_get_instance_private (SwitchboardPlugUserAccountsWidgetsPasswordEditorValidatedEntry* self)
{
	return G_STRUCT_MEMBER_P (self, SwitchboardPlugUserAccountsWidgetsPasswordEditorValidatedEntry_private_offset);
}

static SwitchboardPlugUserAccountsWidgetsPasswordEditorValidatedEntry*
switchboard_plug_user_accounts_widgets_password_editor_validated_entry_construct (GType object_type)
{
	SwitchboardPlugUserAccountsWidgetsPasswordEditorValidatedEntry * self = NULL;
	self = (SwitchboardPlugUserAccountsWidgetsPasswordEditorValidatedEntry*) g_object_new (object_type, NULL);
	return self;
}

static SwitchboardPlugUserAccountsWidgetsPasswordEditorValidatedEntry*
switchboard_plug_user_accounts_widgets_password_editor_validated_entry_new (void)
{
	return switchboard_plug_user_accounts_widgets_password_editor_validated_entry_construct (SWITCHBOARD_PLUG_USER_ACCOUNTS_WIDGETS_PASSWORD_EDITOR_TYPE_VALIDATED_ENTRY);
}

static gboolean
switchboard_plug_user_accounts_widgets_password_editor_validated_entry_get_is_valid (SwitchboardPlugUserAccountsWidgetsPasswordEditorValidatedEntry* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_is_valid;
	return result;
}

static void
switchboard_plug_user_accounts_widgets_password_editor_validated_entry_set_is_valid (SwitchboardPlugUserAccountsWidgetsPasswordEditorValidatedEntry* self,
                                                                                     gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = switchboard_plug_user_accounts_widgets_password_editor_validated_entry_get_is_valid (self);
	if (old_value != value) {
		self->priv->_is_valid = value;
		g_object_notify_by_pspec ((GObject *) self, switchboard_plug_user_accounts_widgets_password_editor_validated_entry_properties[SWITCHBOARD_PLUG_USER_ACCOUNTS_WIDGETS_PASSWORD_EDITOR_VALIDATED_ENTRY_IS_VALID_PROPERTY]);
	}
}

static GObject *
switchboard_plug_user_accounts_widgets_password_editor_validated_entry_constructor (GType type,
                                                                                    guint n_construct_properties,
                                                                                    GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	SwitchboardPlugUserAccountsWidgetsPasswordEditorValidatedEntry * self;
	parent_class = G_OBJECT_CLASS (switchboard_plug_user_accounts_widgets_password_editor_validated_entry_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SWITCHBOARD_PLUG_USER_ACCOUNTS_WIDGETS_PASSWORD_EDITOR_TYPE_VALIDATED_ENTRY, SwitchboardPlugUserAccountsWidgetsPasswordEditorValidatedEntry);
	gtk_entry_set_activates_default ((GtkEntry*) self, TRUE);
	return obj;
}

static void
switchboard_plug_user_accounts_widgets_password_editor_validated_entry_class_init (SwitchboardPlugUserAccountsWidgetsPasswordEditorValidatedEntryClass * klass,
                                                                                   gpointer klass_data)
{
	switchboard_plug_user_accounts_widgets_password_editor_validated_entry_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &SwitchboardPlugUserAccountsWidgetsPasswordEditorValidatedEntry_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_switchboard_plug_user_accounts_widgets_password_editor_validated_entry_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_switchboard_plug_user_accounts_widgets_password_editor_validated_entry_set_property;
	G_OBJECT_CLASS (klass)->constructor = switchboard_plug_user_accounts_widgets_password_editor_validated_entry_constructor;
	G_OBJECT_CLASS (klass)->finalize = switchboard_plug_user_accounts_widgets_password_editor_validated_entry_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), SWITCHBOARD_PLUG_USER_ACCOUNTS_WIDGETS_PASSWORD_EDITOR_VALIDATED_ENTRY_IS_VALID_PROPERTY, switchboard_plug_user_accounts_widgets_password_editor_validated_entry_properties[SWITCHBOARD_PLUG_USER_ACCOUNTS_WIDGETS_PASSWORD_EDITOR_VALIDATED_ENTRY_IS_VALID_PROPERTY] = g_param_spec_boolean ("is-valid", "is-valid", "is-valid", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
}

static void
switchboard_plug_user_accounts_widgets_password_editor_validated_entry_instance_init (SwitchboardPlugUserAccountsWidgetsPasswordEditorValidatedEntry * self,
                                                                                      gpointer klass)
{
	self->priv = switchboard_plug_user_accounts_widgets_password_editor_validated_entry_get_instance_private (self);
	self->priv->_is_valid = FALSE;
}

static void
switchboard_plug_user_accounts_widgets_password_editor_validated_entry_finalize (GObject * obj)
{
	SwitchboardPlugUserAccountsWidgetsPasswordEditorValidatedEntry * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SWITCHBOARD_PLUG_USER_ACCOUNTS_WIDGETS_PASSWORD_EDITOR_TYPE_VALIDATED_ENTRY, SwitchboardPlugUserAccountsWidgetsPasswordEditorValidatedEntry);
	G_OBJECT_CLASS (switchboard_plug_user_accounts_widgets_password_editor_validated_entry_parent_class)->finalize (obj);
}

static GType
switchboard_plug_user_accounts_widgets_password_editor_validated_entry_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SwitchboardPlugUserAccountsWidgetsPasswordEditorValidatedEntryClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) switchboard_plug_user_accounts_widgets_password_editor_validated_entry_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SwitchboardPlugUserAccountsWidgetsPasswordEditorValidatedEntry), 0, (GInstanceInitFunc) switchboard_plug_user_accounts_widgets_password_editor_validated_entry_instance_init, NULL };
	GType switchboard_plug_user_accounts_widgets_password_editor_validated_entry_type_id;
	switchboard_plug_user_accounts_widgets_password_editor_validated_entry_type_id = g_type_register_static (gtk_entry_get_type (), "SwitchboardPlugUserAccountsWidgetsPasswordEditorValidatedEntry", &g_define_type_info, 0);
	SwitchboardPlugUserAccountsWidgetsPasswordEditorValidatedEntry_private_offset = g_type_add_instance_private (switchboard_plug_user_accounts_widgets_password_editor_validated_entry_type_id, sizeof (SwitchboardPlugUserAccountsWidgetsPasswordEditorValidatedEntryPrivate));
	return switchboard_plug_user_accounts_widgets_password_editor_validated_entry_type_id;
}

static GType
switchboard_plug_user_accounts_widgets_password_editor_validated_entry_get_type (void)
{
	static volatile gsize switchboard_plug_user_accounts_widgets_password_editor_validated_entry_type_id__once = 0;
	if (g_once_init_enter (&switchboard_plug_user_accounts_widgets_password_editor_validated_entry_type_id__once)) {
		GType switchboard_plug_user_accounts_widgets_password_editor_validated_entry_type_id;
		switchboard_plug_user_accounts_widgets_password_editor_validated_entry_type_id = switchboard_plug_user_accounts_widgets_password_editor_validated_entry_get_type_once ();
		g_once_init_leave (&switchboard_plug_user_accounts_widgets_password_editor_validated_entry_type_id__once, switchboard_plug_user_accounts_widgets_password_editor_validated_entry_type_id);
	}
	return switchboard_plug_user_accounts_widgets_password_editor_validated_entry_type_id__once;
}

static void
_vala_switchboard_plug_user_accounts_widgets_password_editor_validated_entry_get_property (GObject * object,
                                                                                           guint property_id,
                                                                                           GValue * value,
                                                                                           GParamSpec * pspec)
{
	SwitchboardPlugUserAccountsWidgetsPasswordEditorValidatedEntry * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SWITCHBOARD_PLUG_USER_ACCOUNTS_WIDGETS_PASSWORD_EDITOR_TYPE_VALIDATED_ENTRY, SwitchboardPlugUserAccountsWidgetsPasswordEditorValidatedEntry);
	switch (property_id) {
		case SWITCHBOARD_PLUG_USER_ACCOUNTS_WIDGETS_PASSWORD_EDITOR_VALIDATED_ENTRY_IS_VALID_PROPERTY:
		g_value_set_boolean (value, switchboard_plug_user_accounts_widgets_password_editor_validated_entry_get_is_valid (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_switchboard_plug_user_accounts_widgets_password_editor_validated_entry_set_property (GObject * object,
                                                                                           guint property_id,
                                                                                           const GValue * value,
                                                                                           GParamSpec * pspec)
{
	SwitchboardPlugUserAccountsWidgetsPasswordEditorValidatedEntry * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SWITCHBOARD_PLUG_USER_ACCOUNTS_WIDGETS_PASSWORD_EDITOR_TYPE_VALIDATED_ENTRY, SwitchboardPlugUserAccountsWidgetsPasswordEditorValidatedEntry);
	switch (property_id) {
		case SWITCHBOARD_PLUG_USER_ACCOUNTS_WIDGETS_PASSWORD_EDITOR_VALIDATED_ENTRY_IS_VALID_PROPERTY:
		switchboard_plug_user_accounts_widgets_password_editor_validated_entry_set_is_valid (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_switchboard_plug_user_accounts_widgets_password_editor___lambda18_ (SwitchboardPlugUserAccountsWidgetsPasswordEditor* self)
{
	SwitchboardPlugUserAccountsWidgetsPasswordEditorValidatedEntry* _tmp0_;
	_tmp0_ = self->priv->pw_entry;
	switchboard_plug_user_accounts_widgets_password_editor_validated_entry_set_is_valid (_tmp0_, switchboard_plug_user_accounts_widgets_password_editor_check_password (self));
	switchboard_plug_user_accounts_widgets_password_editor_validate_form (self);
}

static void
__switchboard_plug_user_accounts_widgets_password_editor___lambda18__gtk_editable_changed (GtkEditable* _sender,
                                                                                           gpointer self)
{
	_switchboard_plug_user_accounts_widgets_password_editor___lambda18_ ((SwitchboardPlugUserAccountsWidgetsPasswordEditor*) self);
}

static void
_switchboard_plug_user_accounts_widgets_password_editor___lambda19_ (SwitchboardPlugUserAccountsWidgetsPasswordEditor* self)
{
	GraniteValidatedEntry* _tmp0_;
	_tmp0_ = self->priv->confirm_entry;
	granite_validated_entry_set_is_valid (_tmp0_, switchboard_plug_user_accounts_widgets_password_editor_confirm_password (self));
	switchboard_plug_user_accounts_widgets_password_editor_validate_form (self);
}

static void
__switchboard_plug_user_accounts_widgets_password_editor___lambda19__gtk_editable_changed (GtkEditable* _sender,
                                                                                           gpointer self)
{
	_switchboard_plug_user_accounts_widgets_password_editor___lambda19_ ((SwitchboardPlugUserAccountsWidgetsPasswordEditor*) self);
}

static GObject *
switchboard_plug_user_accounts_widgets_password_editor_constructor (GType type,
                                                                    guint n_construct_properties,
                                                                    GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	SwitchboardPlugUserAccountsWidgetsPasswordEditor * self;
	GraniteHeaderLabel* pw_label = NULL;
	GraniteHeaderLabel* _tmp0_;
	SwitchboardPlugUserAccountsWidgetsPasswordEditorValidatedEntry* _tmp1_;
	SwitchboardPlugUserAccountsWidgetsPasswordEditorValidatedEntry* _tmp2_;
	SwitchboardPlugUserAccountsWidgetsPasswordEditorValidatedEntry* _tmp3_;
	GtkLevelBar* _tmp4_;
	GtkLevelBar* _tmp5_;
	GtkLevelBar* _tmp6_;
	GtkLevelBar* _tmp7_;
	GtkLevelBar* _tmp8_;
	GtkLevelBar* _tmp9_;
	SwitchboardPlugUserAccountsErrorRevealer* _tmp10_;
	SwitchboardPlugUserAccountsErrorRevealer* _tmp11_;
	GtkLabel* _tmp12_;
	GtkLabel* _tmp13_;
	GraniteValidatedEntry* _tmp14_ = NULL;
	GraniteHeaderLabel* confirm_label = NULL;
	GraniteValidatedEntry* _tmp15_;
	GtkWidget* _tmp16_;
	GraniteHeaderLabel* _tmp17_ = NULL;
	SwitchboardPlugUserAccountsErrorRevealer* _tmp18_;
	SwitchboardPlugUserAccountsErrorRevealer* _tmp19_;
	GtkLabel* _tmp20_;
	GtkLabel* _tmp21_;
	GtkCheckButton* show_pw_check = NULL;
	GtkCheckButton* _tmp22_;
	GraniteHeaderLabel* _tmp23_;
	SwitchboardPlugUserAccountsWidgetsPasswordEditorValidatedEntry* _tmp24_;
	GtkLevelBar* _tmp25_;
	SwitchboardPlugUserAccountsErrorRevealer* _tmp26_;
	GraniteHeaderLabel* _tmp27_;
	GraniteValidatedEntry* _tmp28_;
	SwitchboardPlugUserAccountsErrorRevealer* _tmp29_;
	GtkCheckButton* _tmp30_;
	GtkCheckButton* _tmp31_;
	SwitchboardPlugUserAccountsWidgetsPasswordEditorValidatedEntry* _tmp32_;
	GtkCheckButton* _tmp33_;
	GraniteValidatedEntry* _tmp34_;
	SwitchboardPlugUserAccountsWidgetsPasswordEditorValidatedEntry* _tmp35_;
	GraniteValidatedEntry* _tmp36_;
	parent_class = G_OBJECT_CLASS (switchboard_plug_user_accounts_widgets_password_editor_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SWITCHBOARD_PLUG_USER_ACCOUNTS_WIDGETS_TYPE_PASSWORD_EDITOR, SwitchboardPlugUserAccountsWidgetsPasswordEditor);
	_tmp0_ = granite_header_label_new (_ ("Choose a Password"));
	g_object_ref_sink (_tmp0_);
	pw_label = _tmp0_;
	_tmp1_ = switchboard_plug_user_accounts_widgets_password_editor_validated_entry_new ();
	g_object_ref_sink (_tmp1_);
	_g_object_unref0 (self->priv->pw_entry);
	self->priv->pw_entry = _tmp1_;
	_tmp2_ = self->priv->pw_entry;
	gtk_widget_set_hexpand ((GtkWidget*) _tmp2_, TRUE);
	_tmp3_ = self->priv->pw_entry;
	gtk_entry_set_visibility ((GtkEntry*) _tmp3_, FALSE);
	_tmp4_ = (GtkLevelBar*) gtk_level_bar_new_for_interval (0.0, 100.0);
	g_object_ref_sink (_tmp4_);
	_g_object_unref0 (self->priv->pw_levelbar);
	self->priv->pw_levelbar = _tmp4_;
	_tmp5_ = self->priv->pw_levelbar;
	gtk_level_bar_set_mode (_tmp5_, GTK_LEVEL_BAR_MODE_CONTINUOUS);
	_tmp6_ = self->priv->pw_levelbar;
	gtk_level_bar_add_offset_value (_tmp6_, "low", 30.0);
	_tmp7_ = self->priv->pw_levelbar;
	gtk_level_bar_add_offset_value (_tmp7_, "middle", 50.0);
	_tmp8_ = self->priv->pw_levelbar;
	gtk_level_bar_add_offset_value (_tmp8_, "high", 80.0);
	_tmp9_ = self->priv->pw_levelbar;
	gtk_level_bar_add_offset_value (_tmp9_, "full", 100.0);
	_tmp10_ = switchboard_plug_user_accounts_error_revealer_new (".");
	g_object_ref_sink (_tmp10_);
	_g_object_unref0 (self->priv->pw_error_revealer);
	self->priv->pw_error_revealer = _tmp10_;
	_tmp11_ = self->priv->pw_error_revealer;
	_tmp12_ = switchboard_plug_user_accounts_error_revealer_get_label_widget (_tmp11_);
	_tmp13_ = _tmp12_;
	gtk_widget_add_css_class ((GtkWidget*) _tmp13_, GRANITE_STYLE_CLASS_WARNING);
	_tmp14_ = granite_validated_entry_new ();
	gtk_widget_set_sensitive ((GtkWidget*) _tmp14_, FALSE);
	gtk_entry_set_visibility ((GtkEntry*) _tmp14_, FALSE);
	g_object_ref_sink (_tmp14_);
	_g_object_unref0 (self->priv->confirm_entry);
	self->priv->confirm_entry = _tmp14_;
	_tmp15_ = self->priv->confirm_entry;
	_tmp16_ = _g_object_ref0 ((GtkWidget*) _tmp15_);
	_tmp17_ = granite_header_label_new (_ ("Confirm Password"));
	granite_header_label_set_mnemonic_widget (_tmp17_, _tmp16_);
	_g_object_unref0 (_tmp16_);
	g_object_ref_sink (_tmp17_);
	confirm_label = _tmp17_;
	_tmp18_ = switchboard_plug_user_accounts_error_revealer_new (".");
	g_object_ref_sink (_tmp18_);
	_g_object_unref0 (self->priv->confirm_entry_revealer);
	self->priv->confirm_entry_revealer = _tmp18_;
	_tmp19_ = self->priv->confirm_entry_revealer;
	_tmp20_ = switchboard_plug_user_accounts_error_revealer_get_label_widget (_tmp19_);
	_tmp21_ = _tmp20_;
	gtk_widget_add_css_class ((GtkWidget*) _tmp21_, GRANITE_STYLE_CLASS_ERROR);
	_tmp22_ = (GtkCheckButton*) gtk_check_button_new_with_label (_ ("Show passwords"));
	g_object_ref_sink (_tmp22_);
	show_pw_check = _tmp22_;
	gtk_orientable_set_orientation ((GtkOrientable*) self, GTK_ORIENTATION_VERTICAL);
	gtk_box_set_spacing ((GtkBox*) self, 3);
	_tmp23_ = pw_label;
	gtk_box_append ((GtkBox*) self, (GtkWidget*) _tmp23_);
	_tmp24_ = self->priv->pw_entry;
	gtk_box_append ((GtkBox*) self, (GtkWidget*) _tmp24_);
	_tmp25_ = self->priv->pw_levelbar;
	gtk_box_append ((GtkBox*) self, (GtkWidget*) _tmp25_);
	_tmp26_ = self->priv->pw_error_revealer;
	gtk_box_append ((GtkBox*) self, (GtkWidget*) _tmp26_);
	_tmp27_ = confirm_label;
	gtk_box_append ((GtkBox*) self, (GtkWidget*) _tmp27_);
	_tmp28_ = self->priv->confirm_entry;
	gtk_box_append ((GtkBox*) self, (GtkWidget*) _tmp28_);
	_tmp29_ = self->priv->confirm_entry_revealer;
	gtk_box_append ((GtkBox*) self, (GtkWidget*) _tmp29_);
	_tmp30_ = show_pw_check;
	gtk_box_append ((GtkBox*) self, (GtkWidget*) _tmp30_);
	_tmp31_ = show_pw_check;
	_tmp32_ = self->priv->pw_entry;
	g_object_bind_property_with_closures ((GObject*) _tmp31_, "active", (GObject*) _tmp32_, "visibility", G_BINDING_DEFAULT, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	_tmp33_ = show_pw_check;
	_tmp34_ = self->priv->confirm_entry;
	g_object_bind_property_with_closures ((GObject*) _tmp33_, "active", (GObject*) _tmp34_, "visibility", G_BINDING_DEFAULT, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	_tmp35_ = self->priv->pw_entry;
	g_signal_connect_object ((GtkEditable*) _tmp35_, "changed", (GCallback) __switchboard_plug_user_accounts_widgets_password_editor___lambda18__gtk_editable_changed, self, 0);
	_tmp36_ = self->priv->confirm_entry;
	g_signal_connect_object ((GtkEditable*) _tmp36_, "changed", (GCallback) __switchboard_plug_user_accounts_widgets_password_editor___lambda19__gtk_editable_changed, self, 0);
	_g_object_unref0 (show_pw_check);
	_g_object_unref0 (confirm_label);
	_g_object_unref0 (pw_label);
	return obj;
}

static void
switchboard_plug_user_accounts_widgets_password_editor_class_init (SwitchboardPlugUserAccountsWidgetsPasswordEditorClass * klass,
                                                                   gpointer klass_data)
{
	switchboard_plug_user_accounts_widgets_password_editor_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &SwitchboardPlugUserAccountsWidgetsPasswordEditor_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_switchboard_plug_user_accounts_widgets_password_editor_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_switchboard_plug_user_accounts_widgets_password_editor_set_property;
	G_OBJECT_CLASS (klass)->constructor = switchboard_plug_user_accounts_widgets_password_editor_constructor;
	G_OBJECT_CLASS (klass)->finalize = switchboard_plug_user_accounts_widgets_password_editor_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), SWITCHBOARD_PLUG_USER_ACCOUNTS_WIDGETS_PASSWORD_EDITOR_CURRENT_PW_ENTRY_PROPERTY, switchboard_plug_user_accounts_widgets_password_editor_properties[SWITCHBOARD_PLUG_USER_ACCOUNTS_WIDGETS_PASSWORD_EDITOR_CURRENT_PW_ENTRY_PROPERTY] = g_param_spec_object ("current-pw-entry", "current-pw-entry", "current-pw-entry", gtk_entry_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SWITCHBOARD_PLUG_USER_ACCOUNTS_WIDGETS_PASSWORD_EDITOR_IS_OBSCURE_PROPERTY, switchboard_plug_user_accounts_widgets_password_editor_properties[SWITCHBOARD_PLUG_USER_ACCOUNTS_WIDGETS_PASSWORD_EDITOR_IS_OBSCURE_PROPERTY] = g_param_spec_boolean ("is-obscure", "is-obscure", "is-obscure", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SWITCHBOARD_PLUG_USER_ACCOUNTS_WIDGETS_PASSWORD_EDITOR_IS_VALID_PROPERTY, switchboard_plug_user_accounts_widgets_password_editor_properties[SWITCHBOARD_PLUG_USER_ACCOUNTS_WIDGETS_PASSWORD_EDITOR_IS_VALID_PROPERTY] = g_param_spec_boolean ("is-valid", "is-valid", "is-valid", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	switchboard_plug_user_accounts_widgets_password_editor_signals[SWITCHBOARD_PLUG_USER_ACCOUNTS_WIDGETS_PASSWORD_EDITOR_VALIDATION_CHANGED_SIGNAL] = g_signal_new ("validation-changed", SWITCHBOARD_PLUG_USER_ACCOUNTS_WIDGETS_TYPE_PASSWORD_EDITOR, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}

static void
switchboard_plug_user_accounts_widgets_password_editor_instance_init (SwitchboardPlugUserAccountsWidgetsPasswordEditor * self,
                                                                      gpointer klass)
{
	self->priv = switchboard_plug_user_accounts_widgets_password_editor_get_instance_private (self);
	self->priv->_is_obscure = FALSE;
	self->priv->_is_valid = FALSE;
}

static void
switchboard_plug_user_accounts_widgets_password_editor_finalize (GObject * obj)
{
	SwitchboardPlugUserAccountsWidgetsPasswordEditor * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SWITCHBOARD_PLUG_USER_ACCOUNTS_WIDGETS_TYPE_PASSWORD_EDITOR, SwitchboardPlugUserAccountsWidgetsPasswordEditor);
	_g_object_unref0 (self->priv->confirm_entry_revealer);
	_g_object_unref0 (self->priv->pw_error_revealer);
	_g_object_unref0 (self->priv->pw_levelbar);
	_g_object_unref0 (self->priv->pw_entry);
	_g_object_unref0 (self->priv->confirm_entry);
	_g_object_unref0 (self->priv->_current_pw_entry);
	G_OBJECT_CLASS (switchboard_plug_user_accounts_widgets_password_editor_parent_class)->finalize (obj);
}

static GType
switchboard_plug_user_accounts_widgets_password_editor_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SwitchboardPlugUserAccountsWidgetsPasswordEditorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) switchboard_plug_user_accounts_widgets_password_editor_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SwitchboardPlugUserAccountsWidgetsPasswordEditor), 0, (GInstanceInitFunc) switchboard_plug_user_accounts_widgets_password_editor_instance_init, NULL };
	GType switchboard_plug_user_accounts_widgets_password_editor_type_id;
	switchboard_plug_user_accounts_widgets_password_editor_type_id = g_type_register_static (gtk_box_get_type (), "SwitchboardPlugUserAccountsWidgetsPasswordEditor", &g_define_type_info, 0);
	SwitchboardPlugUserAccountsWidgetsPasswordEditor_private_offset = g_type_add_instance_private (switchboard_plug_user_accounts_widgets_password_editor_type_id, sizeof (SwitchboardPlugUserAccountsWidgetsPasswordEditorPrivate));
	return switchboard_plug_user_accounts_widgets_password_editor_type_id;
}

GType
switchboard_plug_user_accounts_widgets_password_editor_get_type (void)
{
	static volatile gsize switchboard_plug_user_accounts_widgets_password_editor_type_id__once = 0;
	if (g_once_init_enter (&switchboard_plug_user_accounts_widgets_password_editor_type_id__once)) {
		GType switchboard_plug_user_accounts_widgets_password_editor_type_id;
		switchboard_plug_user_accounts_widgets_password_editor_type_id = switchboard_plug_user_accounts_widgets_password_editor_get_type_once ();
		g_once_init_leave (&switchboard_plug_user_accounts_widgets_password_editor_type_id__once, switchboard_plug_user_accounts_widgets_password_editor_type_id);
	}
	return switchboard_plug_user_accounts_widgets_password_editor_type_id__once;
}

static void
_vala_switchboard_plug_user_accounts_widgets_password_editor_get_property (GObject * object,
                                                                           guint property_id,
                                                                           GValue * value,
                                                                           GParamSpec * pspec)
{
	SwitchboardPlugUserAccountsWidgetsPasswordEditor * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SWITCHBOARD_PLUG_USER_ACCOUNTS_WIDGETS_TYPE_PASSWORD_EDITOR, SwitchboardPlugUserAccountsWidgetsPasswordEditor);
	switch (property_id) {
		case SWITCHBOARD_PLUG_USER_ACCOUNTS_WIDGETS_PASSWORD_EDITOR_CURRENT_PW_ENTRY_PROPERTY:
		g_value_set_object (value, switchboard_plug_user_accounts_widgets_password_editor_get_current_pw_entry (self));
		break;
		case SWITCHBOARD_PLUG_USER_ACCOUNTS_WIDGETS_PASSWORD_EDITOR_IS_OBSCURE_PROPERTY:
		g_value_set_boolean (value, switchboard_plug_user_accounts_widgets_password_editor_get_is_obscure (self));
		break;
		case SWITCHBOARD_PLUG_USER_ACCOUNTS_WIDGETS_PASSWORD_EDITOR_IS_VALID_PROPERTY:
		g_value_set_boolean (value, switchboard_plug_user_accounts_widgets_password_editor_get_is_valid (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_switchboard_plug_user_accounts_widgets_password_editor_set_property (GObject * object,
                                                                           guint property_id,
                                                                           const GValue * value,
                                                                           GParamSpec * pspec)
{
	SwitchboardPlugUserAccountsWidgetsPasswordEditor * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SWITCHBOARD_PLUG_USER_ACCOUNTS_WIDGETS_TYPE_PASSWORD_EDITOR, SwitchboardPlugUserAccountsWidgetsPasswordEditor);
	switch (property_id) {
		case SWITCHBOARD_PLUG_USER_ACCOUNTS_WIDGETS_PASSWORD_EDITOR_CURRENT_PW_ENTRY_PROPERTY:
		switchboard_plug_user_accounts_widgets_password_editor_set_current_pw_entry (self, g_value_get_object (value));
		break;
		case SWITCHBOARD_PLUG_USER_ACCOUNTS_WIDGETS_PASSWORD_EDITOR_IS_OBSCURE_PROPERTY:
		switchboard_plug_user_accounts_widgets_password_editor_set_is_obscure (self, g_value_get_boolean (value));
		break;
		case SWITCHBOARD_PLUG_USER_ACCOUNTS_WIDGETS_PASSWORD_EDITOR_IS_VALID_PROPERTY:
		switchboard_plug_user_accounts_widgets_password_editor_set_is_valid (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

