/* common-actions.c generated by valac 0.56.17, the Vala compiler
 * generated from common-actions.vala, do not modify */

/*
 * Copyright (C) 2010 Michal Hruby <michal.mhr@gmail.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authored by Michal Hruby <michal.mhr@gmail.com>
 *
 */

#include "synapse-core.h"
#include <glib.h>
#include <glib-object.h>
#include <gee.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>
#include <gio/gio.h>
#include <gio/gdesktopappinfo.h>
#include <gdk/gdk.h>
#include <glib/gstdio.h>
#include <gtk/gtk.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	SYNAPSE_ACTION_0_PROPERTY,
	SYNAPSE_ACTION_DEFAULT_RELEVANCY_PROPERTY,
	SYNAPSE_ACTION_NOTIFY_MATCH_PROPERTY,
	SYNAPSE_ACTION_NUM_PROPERTIES
};
static GParamSpec* synapse_action_properties[SYNAPSE_ACTION_NUM_PROPERTIES];
enum  {
	SYNAPSE_COMMON_ACTIONS_0_PROPERTY,
	SYNAPSE_COMMON_ACTIONS_ENABLED_PROPERTY,
	SYNAPSE_COMMON_ACTIONS_NUM_PROPERTIES
};
static GParamSpec* synapse_common_actions_properties[SYNAPSE_COMMON_ACTIONS_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define SYNAPSE_COMMON_ACTIONS_TYPE_RUNNER (synapse_common_actions_runner_get_type ())
#define SYNAPSE_COMMON_ACTIONS_RUNNER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_COMMON_ACTIONS_TYPE_RUNNER, SynapseCommonActionsRunner))
#define SYNAPSE_COMMON_ACTIONS_RUNNER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SYNAPSE_COMMON_ACTIONS_TYPE_RUNNER, SynapseCommonActionsRunnerClass))
#define SYNAPSE_COMMON_ACTIONS_IS_RUNNER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_COMMON_ACTIONS_TYPE_RUNNER))
#define SYNAPSE_COMMON_ACTIONS_IS_RUNNER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SYNAPSE_COMMON_ACTIONS_TYPE_RUNNER))
#define SYNAPSE_COMMON_ACTIONS_RUNNER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SYNAPSE_COMMON_ACTIONS_TYPE_RUNNER, SynapseCommonActionsRunnerClass))

typedef struct _SynapseCommonActionsRunner SynapseCommonActionsRunner;
typedef struct _SynapseCommonActionsRunnerClass SynapseCommonActionsRunnerClass;
typedef struct _SynapseCommonActionsRunnerPrivate SynapseCommonActionsRunnerPrivate;
enum  {
	SYNAPSE_COMMON_ACTIONS_RUNNER_0_PROPERTY,
	SYNAPSE_COMMON_ACTIONS_RUNNER_NUM_PROPERTIES
};
static GParamSpec* synapse_common_actions_runner_properties[SYNAPSE_COMMON_ACTIONS_RUNNER_NUM_PROPERTIES];
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define SYNAPSE_COMMON_ACTIONS_TYPE_TERMINAL_RUNNER (synapse_common_actions_terminal_runner_get_type ())
#define SYNAPSE_COMMON_ACTIONS_TERMINAL_RUNNER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_COMMON_ACTIONS_TYPE_TERMINAL_RUNNER, SynapseCommonActionsTerminalRunner))
#define SYNAPSE_COMMON_ACTIONS_TERMINAL_RUNNER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SYNAPSE_COMMON_ACTIONS_TYPE_TERMINAL_RUNNER, SynapseCommonActionsTerminalRunnerClass))
#define SYNAPSE_COMMON_ACTIONS_IS_TERMINAL_RUNNER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_COMMON_ACTIONS_TYPE_TERMINAL_RUNNER))
#define SYNAPSE_COMMON_ACTIONS_IS_TERMINAL_RUNNER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SYNAPSE_COMMON_ACTIONS_TYPE_TERMINAL_RUNNER))
#define SYNAPSE_COMMON_ACTIONS_TERMINAL_RUNNER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SYNAPSE_COMMON_ACTIONS_TYPE_TERMINAL_RUNNER, SynapseCommonActionsTerminalRunnerClass))

typedef struct _SynapseCommonActionsTerminalRunner SynapseCommonActionsTerminalRunner;
typedef struct _SynapseCommonActionsTerminalRunnerClass SynapseCommonActionsTerminalRunnerClass;
typedef struct _SynapseCommonActionsTerminalRunnerPrivate SynapseCommonActionsTerminalRunnerPrivate;
enum  {
	SYNAPSE_COMMON_ACTIONS_TERMINAL_RUNNER_0_PROPERTY,
	SYNAPSE_COMMON_ACTIONS_TERMINAL_RUNNER_NUM_PROPERTIES
};
static GParamSpec* synapse_common_actions_terminal_runner_properties[SYNAPSE_COMMON_ACTIONS_TERMINAL_RUNNER_NUM_PROPERTIES];

#define SYNAPSE_COMMON_ACTIONS_TYPE_OPENER (synapse_common_actions_opener_get_type ())
#define SYNAPSE_COMMON_ACTIONS_OPENER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_COMMON_ACTIONS_TYPE_OPENER, SynapseCommonActionsOpener))
#define SYNAPSE_COMMON_ACTIONS_OPENER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SYNAPSE_COMMON_ACTIONS_TYPE_OPENER, SynapseCommonActionsOpenerClass))
#define SYNAPSE_COMMON_ACTIONS_IS_OPENER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_COMMON_ACTIONS_TYPE_OPENER))
#define SYNAPSE_COMMON_ACTIONS_IS_OPENER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SYNAPSE_COMMON_ACTIONS_TYPE_OPENER))
#define SYNAPSE_COMMON_ACTIONS_OPENER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SYNAPSE_COMMON_ACTIONS_TYPE_OPENER, SynapseCommonActionsOpenerClass))

typedef struct _SynapseCommonActionsOpener SynapseCommonActionsOpener;
typedef struct _SynapseCommonActionsOpenerClass SynapseCommonActionsOpenerClass;
typedef struct _SynapseCommonActionsOpenerPrivate SynapseCommonActionsOpenerPrivate;
enum  {
	SYNAPSE_COMMON_ACTIONS_OPENER_0_PROPERTY,
	SYNAPSE_COMMON_ACTIONS_OPENER_NUM_PROPERTIES
};
static GParamSpec* synapse_common_actions_opener_properties[SYNAPSE_COMMON_ACTIONS_OPENER_NUM_PROPERTIES];
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))

#define SYNAPSE_COMMON_ACTIONS_TYPE_OPEN_FOLDER (synapse_common_actions_open_folder_get_type ())
#define SYNAPSE_COMMON_ACTIONS_OPEN_FOLDER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_COMMON_ACTIONS_TYPE_OPEN_FOLDER, SynapseCommonActionsOpenFolder))
#define SYNAPSE_COMMON_ACTIONS_OPEN_FOLDER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SYNAPSE_COMMON_ACTIONS_TYPE_OPEN_FOLDER, SynapseCommonActionsOpenFolderClass))
#define SYNAPSE_COMMON_ACTIONS_IS_OPEN_FOLDER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_COMMON_ACTIONS_TYPE_OPEN_FOLDER))
#define SYNAPSE_COMMON_ACTIONS_IS_OPEN_FOLDER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SYNAPSE_COMMON_ACTIONS_TYPE_OPEN_FOLDER))
#define SYNAPSE_COMMON_ACTIONS_OPEN_FOLDER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SYNAPSE_COMMON_ACTIONS_TYPE_OPEN_FOLDER, SynapseCommonActionsOpenFolderClass))

typedef struct _SynapseCommonActionsOpenFolder SynapseCommonActionsOpenFolder;
typedef struct _SynapseCommonActionsOpenFolderClass SynapseCommonActionsOpenFolderClass;
typedef struct _SynapseCommonActionsOpenFolderPrivate SynapseCommonActionsOpenFolderPrivate;
enum  {
	SYNAPSE_COMMON_ACTIONS_OPEN_FOLDER_0_PROPERTY,
	SYNAPSE_COMMON_ACTIONS_OPEN_FOLDER_NUM_PROPERTIES
};
static GParamSpec* synapse_common_actions_open_folder_properties[SYNAPSE_COMMON_ACTIONS_OPEN_FOLDER_NUM_PROPERTIES];

#define SYNAPSE_COMMON_ACTIONS_TYPE_CLIPBOARD_COPY (synapse_common_actions_clipboard_copy_get_type ())
#define SYNAPSE_COMMON_ACTIONS_CLIPBOARD_COPY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_COMMON_ACTIONS_TYPE_CLIPBOARD_COPY, SynapseCommonActionsClipboardCopy))
#define SYNAPSE_COMMON_ACTIONS_CLIPBOARD_COPY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SYNAPSE_COMMON_ACTIONS_TYPE_CLIPBOARD_COPY, SynapseCommonActionsClipboardCopyClass))
#define SYNAPSE_COMMON_ACTIONS_IS_CLIPBOARD_COPY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_COMMON_ACTIONS_TYPE_CLIPBOARD_COPY))
#define SYNAPSE_COMMON_ACTIONS_IS_CLIPBOARD_COPY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SYNAPSE_COMMON_ACTIONS_TYPE_CLIPBOARD_COPY))
#define SYNAPSE_COMMON_ACTIONS_CLIPBOARD_COPY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SYNAPSE_COMMON_ACTIONS_TYPE_CLIPBOARD_COPY, SynapseCommonActionsClipboardCopyClass))

typedef struct _SynapseCommonActionsClipboardCopy SynapseCommonActionsClipboardCopy;
typedef struct _SynapseCommonActionsClipboardCopyClass SynapseCommonActionsClipboardCopyClass;
typedef struct _SynapseCommonActionsClipboardCopyPrivate SynapseCommonActionsClipboardCopyPrivate;
enum  {
	SYNAPSE_COMMON_ACTIONS_CLIPBOARD_COPY_0_PROPERTY,
	SYNAPSE_COMMON_ACTIONS_CLIPBOARD_COPY_NUM_PROPERTIES
};
static GParamSpec* synapse_common_actions_clipboard_copy_properties[SYNAPSE_COMMON_ACTIONS_CLIPBOARD_COPY_NUM_PROPERTIES];

struct _SynapseActionPrivate {
	gint _default_relevancy;
	gboolean _notify_match;
};

struct _SynapseCommonActionsPrivate {
	gboolean _enabled;
	GeeList* actions;
};

struct _SynapseCommonActionsRunner {
	SynapseAction parent_instance;
	SynapseCommonActionsRunnerPrivate * priv;
};

struct _SynapseCommonActionsRunnerClass {
	SynapseActionClass parent_class;
};

struct _SynapseCommonActionsTerminalRunner {
	SynapseAction parent_instance;
	SynapseCommonActionsTerminalRunnerPrivate * priv;
};

struct _SynapseCommonActionsTerminalRunnerClass {
	SynapseActionClass parent_class;
};

struct _SynapseCommonActionsOpener {
	SynapseAction parent_instance;
	SynapseCommonActionsOpenerPrivate * priv;
};

struct _SynapseCommonActionsOpenerClass {
	SynapseActionClass parent_class;
};

struct _SynapseCommonActionsOpenerPrivate {
	GRegex* web_uri;
	GRegex* file_path;
};

struct _SynapseCommonActionsOpenFolder {
	SynapseAction parent_instance;
	SynapseCommonActionsOpenFolderPrivate * priv;
};

struct _SynapseCommonActionsOpenFolderClass {
	SynapseActionClass parent_class;
};

struct _SynapseCommonActionsClipboardCopy {
	SynapseAction parent_instance;
	SynapseCommonActionsClipboardCopyPrivate * priv;
};

struct _SynapseCommonActionsClipboardCopyClass {
	SynapseActionClass parent_class;
};

static gint SynapseAction_private_offset;
static gpointer synapse_action_parent_class = NULL;
static gint SynapseCommonActions_private_offset;
static gpointer synapse_common_actions_parent_class = NULL;
static gpointer synapse_common_actions_runner_parent_class = NULL;
static gpointer synapse_common_actions_terminal_runner_parent_class = NULL;
static gint SynapseCommonActionsOpener_private_offset;
static gpointer synapse_common_actions_opener_parent_class = NULL;
static gpointer synapse_common_actions_open_folder_parent_class = NULL;
static gpointer synapse_common_actions_clipboard_copy_parent_class = NULL;
static SynapseActivatableIface * synapse_common_actions_synapse_activatable_parent_iface = NULL;
static SynapseActionProviderIface * synapse_common_actions_synapse_action_provider_parent_iface = NULL;

static gboolean synapse_action_real_valid_for_match (SynapseAction* self,
                                              SynapseMatch* match);
static gint synapse_action_real_get_relevancy_for_match (SynapseAction* self,
                                                  SynapseMatch* match);
static void synapse_action_real_do_execute (SynapseAction* self,
                                     SynapseMatch* source,
                                     SynapseMatch* target);
static void synapse_action_real_execute_with_target (SynapseMatch* base,
                                              SynapseMatch* source,
                                              SynapseMatch* target);
static void synapse_action_finalize (GObject * obj);
static GType synapse_action_get_type_once (void);
static void _vala_synapse_action_get_property (GObject * object,
                                        guint property_id,
                                        GValue * value,
                                        GParamSpec * pspec);
static void _vala_synapse_action_set_property (GObject * object,
                                        guint property_id,
                                        const GValue * value,
                                        GParamSpec * pspec);
static void synapse_common_actions_real_activate (SynapseActivatable* base);
static void synapse_common_actions_real_deactivate (SynapseActivatable* base);
static SynapseResultSet* synapse_common_actions_real_find_for_match (SynapseActionProvider* base,
                                                              SynapseQuery* query,
                                                              SynapseMatch* match);
static GType synapse_common_actions_runner_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
static SynapseCommonActionsRunner* synapse_common_actions_runner_new (void);
static SynapseCommonActionsRunner* synapse_common_actions_runner_construct (GType object_type);
static void synapse_common_actions_runner_real_do_execute (SynapseAction* base,
                                                    SynapseMatch* match,
                                                    SynapseMatch* target);
static gboolean synapse_common_actions_runner_real_valid_for_match (SynapseAction* base,
                                                             SynapseMatch* match);
static GType synapse_common_actions_runner_get_type_once (void);
static GType synapse_common_actions_terminal_runner_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
static SynapseCommonActionsTerminalRunner* synapse_common_actions_terminal_runner_new (void);
static SynapseCommonActionsTerminalRunner* synapse_common_actions_terminal_runner_construct (GType object_type);
static void synapse_common_actions_terminal_runner_real_do_execute (SynapseAction* base,
                                                             SynapseMatch* match,
                                                             SynapseMatch* target);
static gboolean synapse_common_actions_terminal_runner_real_valid_for_match (SynapseAction* base,
                                                                      SynapseMatch* match);
static GType synapse_common_actions_terminal_runner_get_type_once (void);
static GType synapse_common_actions_opener_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
static SynapseCommonActionsOpener* synapse_common_actions_opener_new (void);
static SynapseCommonActionsOpener* synapse_common_actions_opener_construct (GType object_type);
static void synapse_common_actions_opener_real_do_execute (SynapseAction* base,
                                                    SynapseMatch* match,
                                                    SynapseMatch* target);
static gboolean synapse_common_actions_opener_real_valid_for_match (SynapseAction* base,
                                                             SynapseMatch* match);
static GObject * synapse_common_actions_opener_constructor (GType type,
                                                     guint n_construct_properties,
                                                     GObjectConstructParam * construct_properties);
static void synapse_common_actions_opener_finalize (GObject * obj);
static GType synapse_common_actions_opener_get_type_once (void);
static GType synapse_common_actions_open_folder_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
static SynapseCommonActionsOpenFolder* synapse_common_actions_open_folder_new (void);
static SynapseCommonActionsOpenFolder* synapse_common_actions_open_folder_construct (GType object_type);
static void synapse_common_actions_open_folder_real_do_execute (SynapseAction* base,
                                                         SynapseMatch* match,
                                                         SynapseMatch* target);
static void _g_object_unref0_ (gpointer var);
static inline void _g_list_free__g_object_unref0_ (GList* self);
static gboolean synapse_common_actions_open_folder_real_valid_for_match (SynapseAction* base,
                                                                  SynapseMatch* match);
static GType synapse_common_actions_open_folder_get_type_once (void);
static GType synapse_common_actions_clipboard_copy_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
static SynapseCommonActionsClipboardCopy* synapse_common_actions_clipboard_copy_new (void);
static SynapseCommonActionsClipboardCopy* synapse_common_actions_clipboard_copy_construct (GType object_type);
static void synapse_common_actions_clipboard_copy_real_do_execute (SynapseAction* base,
                                                            SynapseMatch* match,
                                                            SynapseMatch* target);
static gboolean synapse_common_actions_clipboard_copy_real_valid_for_match (SynapseAction* base,
                                                                     SynapseMatch* match);
static gint synapse_common_actions_clipboard_copy_real_get_relevancy_for_match (SynapseAction* base,
                                                                         SynapseMatch* match);
static GType synapse_common_actions_clipboard_copy_get_type_once (void);
static GObject * synapse_common_actions_constructor (GType type,
                                              guint n_construct_properties,
                                              GObjectConstructParam * construct_properties);
static void synapse_common_actions_finalize (GObject * obj);
static GType synapse_common_actions_get_type_once (void);
static void _vala_synapse_common_actions_get_property (GObject * object,
                                                guint property_id,
                                                GValue * value,
                                                GParamSpec * pspec);
static void _vala_synapse_common_actions_set_property (GObject * object,
                                                guint property_id,
                                                const GValue * value,
                                                GParamSpec * pspec);

static inline gpointer
synapse_action_get_instance_private (SynapseAction* self)
{
	return G_STRUCT_MEMBER_P (self, SynapseAction_private_offset);
}

static gboolean
synapse_action_real_valid_for_match (SynapseAction* self,
                                     SynapseMatch* match)
{
	gboolean _tmp0_ = FALSE;
#line 28 "common-actions.vala"
	g_critical ("Type `%s' does not implement abstract method `synapse_action_valid_for_match'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
#line 28 "common-actions.vala"
	return _tmp0_;
#line 325 "common-actions.c"
}

gboolean
synapse_action_valid_for_match (SynapseAction* self,
                                SynapseMatch* match)
{
	SynapseActionClass* _klass_;
#line 28 "common-actions.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 28 "common-actions.vala"
	_klass_ = SYNAPSE_ACTION_GET_CLASS (self);
#line 28 "common-actions.vala"
	if (_klass_->valid_for_match) {
#line 28 "common-actions.vala"
		return _klass_->valid_for_match (self, match);
#line 341 "common-actions.c"
	}
#line 28 "common-actions.vala"
	return FALSE;
#line 345 "common-actions.c"
}

static gint
synapse_action_real_get_relevancy_for_match (SynapseAction* self,
                                             SynapseMatch* match)
{
	gint _tmp0_;
	gint result;
#line 30 "common-actions.vala"
	g_return_val_if_fail (match != NULL, 0);
#line 32 "common-actions.vala"
	_tmp0_ = self->priv->_default_relevancy;
#line 32 "common-actions.vala"
	result = _tmp0_;
#line 32 "common-actions.vala"
	return result;
#line 362 "common-actions.c"
}

gint
synapse_action_get_relevancy_for_match (SynapseAction* self,
                                        SynapseMatch* match)
{
	SynapseActionClass* _klass_;
#line 30 "common-actions.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 30 "common-actions.vala"
	_klass_ = SYNAPSE_ACTION_GET_CLASS (self);
#line 30 "common-actions.vala"
	if (_klass_->get_relevancy_for_match) {
#line 30 "common-actions.vala"
		return _klass_->get_relevancy_for_match (self, match);
#line 378 "common-actions.c"
	}
#line 30 "common-actions.vala"
	return -1;
#line 382 "common-actions.c"
}

static void
synapse_action_real_do_execute (SynapseAction* self,
                                SynapseMatch* source,
                                SynapseMatch* target)
{
#line 35 "common-actions.vala"
	g_critical ("Type `%s' does not implement abstract method `synapse_action_do_execute'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
#line 35 "common-actions.vala"
	return;
#line 394 "common-actions.c"
}

void
synapse_action_do_execute (SynapseAction* self,
                           SynapseMatch* source,
                           SynapseMatch* target)
{
	SynapseActionClass* _klass_;
#line 35 "common-actions.vala"
	g_return_if_fail (self != NULL);
#line 35 "common-actions.vala"
	_klass_ = SYNAPSE_ACTION_GET_CLASS (self);
#line 35 "common-actions.vala"
	if (_klass_->do_execute) {
#line 35 "common-actions.vala"
		_klass_->do_execute (self, source, target);
#line 411 "common-actions.c"
	}
}

static void
synapse_action_real_execute_with_target (SynapseMatch* base,
                                         SynapseMatch* source,
                                         SynapseMatch* target)
{
	SynapseAction * self;
	gboolean _tmp0_;
#line 37 "common-actions.vala"
	self = (SynapseAction*) base;
#line 37 "common-actions.vala"
	g_return_if_fail (source != NULL);
#line 39 "common-actions.vala"
	synapse_action_do_execute (self, source, target);
#line 40 "common-actions.vala"
	_tmp0_ = self->priv->_notify_match;
#line 40 "common-actions.vala"
	if (_tmp0_) {
#line 40 "common-actions.vala"
		g_signal_emit_by_name (source, "executed");
#line 434 "common-actions.c"
	}
}

SynapseAction*
synapse_action_construct (GType object_type)
{
	SynapseAction * self = NULL;
#line 23 "common-actions.vala"
	self = (SynapseAction*) synapse_match_construct (object_type);
#line 23 "common-actions.vala"
	return self;
#line 446 "common-actions.c"
}

gint
synapse_action_get_default_relevancy (SynapseAction* self)
{
	gint result;
#line 25 "common-actions.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 25 "common-actions.vala"
	result = self->priv->_default_relevancy;
#line 25 "common-actions.vala"
	return result;
#line 459 "common-actions.c"
}

void
synapse_action_set_default_relevancy (SynapseAction* self,
                                      gint value)
{
	gint old_value;
#line 25 "common-actions.vala"
	g_return_if_fail (self != NULL);
#line 25 "common-actions.vala"
	old_value = synapse_action_get_default_relevancy (self);
#line 25 "common-actions.vala"
	if (old_value != value) {
#line 25 "common-actions.vala"
		self->priv->_default_relevancy = value;
#line 25 "common-actions.vala"
		g_object_notify_by_pspec ((GObject *) self, synapse_action_properties[SYNAPSE_ACTION_DEFAULT_RELEVANCY_PROPERTY]);
#line 477 "common-actions.c"
	}
}

gboolean
synapse_action_get_notify_match (SynapseAction* self)
{
	gboolean result;
#line 26 "common-actions.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 26 "common-actions.vala"
	result = self->priv->_notify_match;
#line 26 "common-actions.vala"
	return result;
#line 491 "common-actions.c"
}

void
synapse_action_set_notify_match (SynapseAction* self,
                                 gboolean value)
{
	gboolean old_value;
#line 26 "common-actions.vala"
	g_return_if_fail (self != NULL);
#line 26 "common-actions.vala"
	old_value = synapse_action_get_notify_match (self);
#line 26 "common-actions.vala"
	if (old_value != value) {
#line 26 "common-actions.vala"
		self->priv->_notify_match = value;
#line 26 "common-actions.vala"
		g_object_notify_by_pspec ((GObject *) self, synapse_action_properties[SYNAPSE_ACTION_NOTIFY_MATCH_PROPERTY]);
#line 509 "common-actions.c"
	}
}

static void
synapse_action_class_init (SynapseActionClass * klass,
                           gpointer klass_data)
{
#line 23 "common-actions.vala"
	synapse_action_parent_class = g_type_class_peek_parent (klass);
#line 23 "common-actions.vala"
	g_type_class_adjust_private_offset (klass, &SynapseAction_private_offset);
#line 23 "common-actions.vala"
	((SynapseActionClass *) klass)->valid_for_match = (gboolean (*) (SynapseAction*, SynapseMatch*)) synapse_action_real_valid_for_match;
#line 23 "common-actions.vala"
	((SynapseActionClass *) klass)->get_relevancy_for_match = (gint (*) (SynapseAction*, SynapseMatch*)) synapse_action_real_get_relevancy_for_match;
#line 23 "common-actions.vala"
	((SynapseActionClass *) klass)->do_execute = (void (*) (SynapseAction*, SynapseMatch*, SynapseMatch*)) synapse_action_real_do_execute;
#line 23 "common-actions.vala"
	((SynapseMatchClass *) klass)->execute_with_target = (void (*) (SynapseMatch*, SynapseMatch*, SynapseMatch*)) synapse_action_real_execute_with_target;
#line 23 "common-actions.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_synapse_action_get_property;
#line 23 "common-actions.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_synapse_action_set_property;
#line 23 "common-actions.vala"
	G_OBJECT_CLASS (klass)->finalize = synapse_action_finalize;
#line 23 "common-actions.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_ACTION_DEFAULT_RELEVANCY_PROPERTY, synapse_action_properties[SYNAPSE_ACTION_DEFAULT_RELEVANCY_PROPERTY] = g_param_spec_int ("default-relevancy", "default-relevancy", "default-relevancy", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 23 "common-actions.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_ACTION_NOTIFY_MATCH_PROPERTY, synapse_action_properties[SYNAPSE_ACTION_NOTIFY_MATCH_PROPERTY] = g_param_spec_boolean ("notify-match", "notify-match", "notify-match", TRUE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 539 "common-actions.c"
}

static void
synapse_action_instance_init (SynapseAction * self,
                              gpointer klass)
{
#line 23 "common-actions.vala"
	self->priv = synapse_action_get_instance_private (self);
#line 26 "common-actions.vala"
	self->priv->_notify_match = TRUE;
#line 550 "common-actions.c"
}

static void
synapse_action_finalize (GObject * obj)
{
	SynapseAction * self;
#line 23 "common-actions.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SYNAPSE_TYPE_ACTION, SynapseAction);
#line 23 "common-actions.vala"
	G_OBJECT_CLASS (synapse_action_parent_class)->finalize (obj);
#line 561 "common-actions.c"
}

static GType
synapse_action_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SynapseActionClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) synapse_action_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SynapseAction), 0, (GInstanceInitFunc) synapse_action_instance_init, NULL };
	GType synapse_action_type_id;
	synapse_action_type_id = g_type_register_static (SYNAPSE_TYPE_MATCH, "SynapseAction", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
	SynapseAction_private_offset = g_type_add_instance_private (synapse_action_type_id, sizeof (SynapseActionPrivate));
	return synapse_action_type_id;
}

GType
synapse_action_get_type (void)
{
	static volatile gsize synapse_action_type_id__once = 0;
	if (g_once_init_enter (&synapse_action_type_id__once)) {
		GType synapse_action_type_id;
		synapse_action_type_id = synapse_action_get_type_once ();
		g_once_init_leave (&synapse_action_type_id__once, synapse_action_type_id);
	}
	return synapse_action_type_id__once;
}

static void
_vala_synapse_action_get_property (GObject * object,
                                   guint property_id,
                                   GValue * value,
                                   GParamSpec * pspec)
{
	SynapseAction * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SYNAPSE_TYPE_ACTION, SynapseAction);
#line 23 "common-actions.vala"
	switch (property_id) {
#line 23 "common-actions.vala"
		case SYNAPSE_ACTION_DEFAULT_RELEVANCY_PROPERTY:
#line 23 "common-actions.vala"
		g_value_set_int (value, synapse_action_get_default_relevancy (self));
#line 23 "common-actions.vala"
		break;
#line 23 "common-actions.vala"
		case SYNAPSE_ACTION_NOTIFY_MATCH_PROPERTY:
#line 23 "common-actions.vala"
		g_value_set_boolean (value, synapse_action_get_notify_match (self));
#line 23 "common-actions.vala"
		break;
#line 608 "common-actions.c"
		default:
#line 23 "common-actions.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 23 "common-actions.vala"
		break;
#line 614 "common-actions.c"
	}
}

static void
_vala_synapse_action_set_property (GObject * object,
                                   guint property_id,
                                   const GValue * value,
                                   GParamSpec * pspec)
{
	SynapseAction * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SYNAPSE_TYPE_ACTION, SynapseAction);
#line 23 "common-actions.vala"
	switch (property_id) {
#line 23 "common-actions.vala"
		case SYNAPSE_ACTION_DEFAULT_RELEVANCY_PROPERTY:
#line 23 "common-actions.vala"
		synapse_action_set_default_relevancy (self, g_value_get_int (value));
#line 23 "common-actions.vala"
		break;
#line 23 "common-actions.vala"
		case SYNAPSE_ACTION_NOTIFY_MATCH_PROPERTY:
#line 23 "common-actions.vala"
		synapse_action_set_notify_match (self, g_value_get_boolean (value));
#line 23 "common-actions.vala"
		break;
#line 640 "common-actions.c"
		default:
#line 23 "common-actions.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 23 "common-actions.vala"
		break;
#line 646 "common-actions.c"
	}
}

static inline gpointer
synapse_common_actions_get_instance_private (SynapseCommonActions* self)
{
	return G_STRUCT_MEMBER_P (self, SynapseCommonActions_private_offset);
}

static void
synapse_common_actions_real_activate (SynapseActivatable* base)
{
	SynapseCommonActions * self;
#line 48 "common-actions.vala"
	self = (SynapseCommonActions*) base;
#line 662 "common-actions.c"
}

static void
synapse_common_actions_real_deactivate (SynapseActivatable* base)
{
	SynapseCommonActions * self;
#line 52 "common-actions.vala"
	self = (SynapseCommonActions*) base;
#line 671 "common-actions.c"
}

static SynapseResultSet*
synapse_common_actions_real_find_for_match (SynapseActionProvider* base,
                                            SynapseQuery* query,
                                            SynapseMatch* match)
{
	SynapseCommonActions * self;
	gboolean query_empty = FALSE;
	SynapseQuery _tmp0_;
	const gchar* _tmp1_;
	SynapseResultSet* results = NULL;
	SynapseResultSet* _tmp2_;
	SynapseResultSet* result;
#line 365 "common-actions.vala"
	self = (SynapseCommonActions*) base;
#line 365 "common-actions.vala"
	g_return_val_if_fail (query != NULL, NULL);
#line 365 "common-actions.vala"
	g_return_val_if_fail (match != NULL, NULL);
#line 367 "common-actions.vala"
	_tmp0_ = *query;
#line 367 "common-actions.vala"
	_tmp1_ = _tmp0_.query_string;
#line 367 "common-actions.vala"
	query_empty = g_strcmp0 (_tmp1_, "") == 0;
#line 368 "common-actions.vala"
	_tmp2_ = synapse_result_set_new ();
#line 368 "common-actions.vala"
	results = _tmp2_;
#line 370 "common-actions.vala"
	if (query_empty) {
#line 704 "common-actions.c"
		{
			GeeList* _action_list = NULL;
			GeeList* _tmp3_;
			gint _action_size = 0;
			GeeList* _tmp4_;
			gint _tmp5_;
			gint _tmp6_;
			gint _action_index = 0;
#line 372 "common-actions.vala"
			_tmp3_ = self->priv->actions;
#line 372 "common-actions.vala"
			_action_list = _tmp3_;
#line 372 "common-actions.vala"
			_tmp4_ = _action_list;
#line 372 "common-actions.vala"
			_tmp5_ = gee_collection_get_size ((GeeCollection*) _tmp4_);
#line 372 "common-actions.vala"
			_tmp6_ = _tmp5_;
#line 372 "common-actions.vala"
			_action_size = _tmp6_;
#line 372 "common-actions.vala"
			_action_index = -1;
#line 372 "common-actions.vala"
			while (TRUE) {
#line 729 "common-actions.c"
				gint _tmp7_;
				gint _tmp8_;
				SynapseAction* action = NULL;
				GeeList* _tmp9_;
				gpointer _tmp10_;
				SynapseAction* _tmp11_;
#line 372 "common-actions.vala"
				_action_index = _action_index + 1;
#line 372 "common-actions.vala"
				_tmp7_ = _action_index;
#line 372 "common-actions.vala"
				_tmp8_ = _action_size;
#line 372 "common-actions.vala"
				if (!(_tmp7_ < _tmp8_)) {
#line 372 "common-actions.vala"
					break;
#line 746 "common-actions.c"
				}
#line 372 "common-actions.vala"
				_tmp9_ = _action_list;
#line 372 "common-actions.vala"
				_tmp10_ = gee_list_get (_tmp9_, _action_index);
#line 372 "common-actions.vala"
				action = (SynapseAction*) _tmp10_;
#line 374 "common-actions.vala"
				_tmp11_ = action;
#line 374 "common-actions.vala"
				if (synapse_action_valid_for_match (_tmp11_, match)) {
#line 758 "common-actions.c"
					SynapseResultSet* _tmp12_;
					SynapseAction* _tmp13_;
					SynapseAction* _tmp14_;
#line 376 "common-actions.vala"
					_tmp12_ = results;
#line 376 "common-actions.vala"
					_tmp13_ = action;
#line 376 "common-actions.vala"
					_tmp14_ = action;
#line 376 "common-actions.vala"
					synapse_result_set_add (_tmp12_, (SynapseMatch*) _tmp13_, synapse_action_get_relevancy_for_match (_tmp14_, match));
#line 770 "common-actions.c"
				}
#line 372 "common-actions.vala"
				_g_object_unref0 (action);
#line 774 "common-actions.c"
			}
		}
	} else {
		GeeList* matchers = NULL;
		SynapseQuery _tmp15_;
		const gchar* _tmp16_;
		GeeList* _tmp17_;
#line 382 "common-actions.vala"
		_tmp15_ = *query;
#line 382 "common-actions.vala"
		_tmp16_ = _tmp15_.query_string;
#line 382 "common-actions.vala"
		_tmp17_ = synapse_query_get_matchers_for_query (_tmp16_, 0, G_REGEX_OPTIMIZE | G_REGEX_CASELESS);
#line 382 "common-actions.vala"
		matchers = _tmp17_;
#line 790 "common-actions.c"
		{
			GeeList* _action_list = NULL;
			GeeList* _tmp18_;
			gint _action_size = 0;
			GeeList* _tmp19_;
			gint _tmp20_;
			gint _tmp21_;
			gint _action_index = 0;
#line 384 "common-actions.vala"
			_tmp18_ = self->priv->actions;
#line 384 "common-actions.vala"
			_action_list = _tmp18_;
#line 384 "common-actions.vala"
			_tmp19_ = _action_list;
#line 384 "common-actions.vala"
			_tmp20_ = gee_collection_get_size ((GeeCollection*) _tmp19_);
#line 384 "common-actions.vala"
			_tmp21_ = _tmp20_;
#line 384 "common-actions.vala"
			_action_size = _tmp21_;
#line 384 "common-actions.vala"
			_action_index = -1;
#line 384 "common-actions.vala"
			while (TRUE) {
#line 815 "common-actions.c"
				gint _tmp22_;
				gint _tmp23_;
				SynapseAction* action = NULL;
				GeeList* _tmp24_;
				gpointer _tmp25_;
				SynapseAction* _tmp26_;
#line 384 "common-actions.vala"
				_action_index = _action_index + 1;
#line 384 "common-actions.vala"
				_tmp22_ = _action_index;
#line 384 "common-actions.vala"
				_tmp23_ = _action_size;
#line 384 "common-actions.vala"
				if (!(_tmp22_ < _tmp23_)) {
#line 384 "common-actions.vala"
					break;
#line 832 "common-actions.c"
				}
#line 384 "common-actions.vala"
				_tmp24_ = _action_list;
#line 384 "common-actions.vala"
				_tmp25_ = gee_list_get (_tmp24_, _action_index);
#line 384 "common-actions.vala"
				action = (SynapseAction*) _tmp25_;
#line 386 "common-actions.vala"
				_tmp26_ = action;
#line 386 "common-actions.vala"
				if (!synapse_action_valid_for_match (_tmp26_, match)) {
#line 386 "common-actions.vala"
					_g_object_unref0 (action);
#line 386 "common-actions.vala"
					continue;
#line 848 "common-actions.c"
				}
				{
					GeeList* _matcher_list = NULL;
					GeeList* _tmp27_;
					gint _matcher_size = 0;
					GeeList* _tmp28_;
					gint _tmp29_;
					gint _tmp30_;
					gint _matcher_index = 0;
#line 387 "common-actions.vala"
					_tmp27_ = matchers;
#line 387 "common-actions.vala"
					_matcher_list = _tmp27_;
#line 387 "common-actions.vala"
					_tmp28_ = _matcher_list;
#line 387 "common-actions.vala"
					_tmp29_ = gee_collection_get_size ((GeeCollection*) _tmp28_);
#line 387 "common-actions.vala"
					_tmp30_ = _tmp29_;
#line 387 "common-actions.vala"
					_matcher_size = _tmp30_;
#line 387 "common-actions.vala"
					_matcher_index = -1;
#line 387 "common-actions.vala"
					while (TRUE) {
#line 874 "common-actions.c"
						gint _tmp31_;
						gint _tmp32_;
						GeeMapEntry* matcher = NULL;
						GeeList* _tmp33_;
						gpointer _tmp34_;
						GeeMapEntry* _tmp35_;
						gconstpointer _tmp36_;
						gconstpointer _tmp37_;
						SynapseAction* _tmp38_;
						const gchar* _tmp39_;
						const gchar* _tmp40_;
#line 387 "common-actions.vala"
						_matcher_index = _matcher_index + 1;
#line 387 "common-actions.vala"
						_tmp31_ = _matcher_index;
#line 387 "common-actions.vala"
						_tmp32_ = _matcher_size;
#line 387 "common-actions.vala"
						if (!(_tmp31_ < _tmp32_)) {
#line 387 "common-actions.vala"
							break;
#line 896 "common-actions.c"
						}
#line 387 "common-actions.vala"
						_tmp33_ = _matcher_list;
#line 387 "common-actions.vala"
						_tmp34_ = gee_list_get (_tmp33_, _matcher_index);
#line 387 "common-actions.vala"
						matcher = (GeeMapEntry*) _tmp34_;
#line 389 "common-actions.vala"
						_tmp35_ = matcher;
#line 389 "common-actions.vala"
						_tmp36_ = gee_map_entry_get_key (_tmp35_);
#line 389 "common-actions.vala"
						_tmp37_ = _tmp36_;
#line 389 "common-actions.vala"
						_tmp38_ = action;
#line 389 "common-actions.vala"
						_tmp39_ = synapse_match_get_title ((SynapseMatch*) _tmp38_);
#line 389 "common-actions.vala"
						_tmp40_ = _tmp39_;
#line 389 "common-actions.vala"
						if (g_regex_match ((GRegex*) _tmp37_, _tmp40_, 0, NULL)) {
#line 918 "common-actions.c"
							SynapseResultSet* _tmp41_;
							SynapseAction* _tmp42_;
							GeeMapEntry* _tmp43_;
							gconstpointer _tmp44_;
							gconstpointer _tmp45_;
#line 391 "common-actions.vala"
							_tmp41_ = results;
#line 391 "common-actions.vala"
							_tmp42_ = action;
#line 391 "common-actions.vala"
							_tmp43_ = matcher;
#line 391 "common-actions.vala"
							_tmp44_ = gee_map_entry_get_value (_tmp43_);
#line 391 "common-actions.vala"
							_tmp45_ = _tmp44_;
#line 391 "common-actions.vala"
							synapse_result_set_add (_tmp41_, (SynapseMatch*) _tmp42_, (gint) ((gintptr) _tmp45_));
#line 392 "common-actions.vala"
							_g_object_unref0 (matcher);
#line 392 "common-actions.vala"
							break;
#line 940 "common-actions.c"
						}
#line 387 "common-actions.vala"
						_g_object_unref0 (matcher);
#line 944 "common-actions.c"
					}
				}
#line 384 "common-actions.vala"
				_g_object_unref0 (action);
#line 949 "common-actions.c"
			}
		}
#line 370 "common-actions.vala"
		_g_object_unref0 (matchers);
#line 954 "common-actions.c"
	}
#line 398 "common-actions.vala"
	result = results;
#line 398 "common-actions.vala"
	return result;
#line 960 "common-actions.c"
}

SynapseCommonActions*
synapse_common_actions_construct (GType object_type)
{
	SynapseCommonActions * self = NULL;
#line 44 "common-actions.vala"
	self = (SynapseCommonActions*) g_object_new (object_type, NULL);
#line 44 "common-actions.vala"
	return self;
#line 971 "common-actions.c"
}

SynapseCommonActions*
synapse_common_actions_new (void)
{
#line 44 "common-actions.vala"
	return synapse_common_actions_construct (SYNAPSE_TYPE_COMMON_ACTIONS);
#line 979 "common-actions.c"
}

static gboolean
synapse_common_actions_real_get_enabled (SynapseActivatable* base)
{
	gboolean result;
	SynapseCommonActions* self;
#line 46 "common-actions.vala"
	self = (SynapseCommonActions*) base;
#line 46 "common-actions.vala"
	result = self->priv->_enabled;
#line 46 "common-actions.vala"
	return result;
#line 993 "common-actions.c"
}

static void
synapse_common_actions_real_set_enabled (SynapseActivatable* base,
                                         gboolean value)
{
	SynapseCommonActions* self;
	gboolean old_value;
#line 46 "common-actions.vala"
	self = (SynapseCommonActions*) base;
#line 46 "common-actions.vala"
	old_value = synapse_common_actions_real_get_enabled (base);
#line 46 "common-actions.vala"
	if (old_value != value) {
#line 46 "common-actions.vala"
		self->priv->_enabled = value;
#line 46 "common-actions.vala"
		g_object_notify_by_pspec ((GObject *) self, synapse_common_actions_properties[SYNAPSE_COMMON_ACTIONS_ENABLED_PROPERTY]);
#line 1012 "common-actions.c"
	}
}

static SynapseCommonActionsRunner*
synapse_common_actions_runner_construct (GType object_type)
{
	SynapseCommonActionsRunner * self = NULL;
#line 60 "common-actions.vala"
	self = (SynapseCommonActionsRunner*) g_object_new (object_type, "title", _ ("Run"), "description", _ ("Run an application, action or script"), "icon-name", "system-run", "has-thumbnail", FALSE, "default-relevancy", SYNAPSE_MATCH_SCORE_EXCELLENT, NULL);
#line 58 "common-actions.vala"
	return self;
#line 1024 "common-actions.c"
}

static SynapseCommonActionsRunner*
synapse_common_actions_runner_new (void)
{
#line 58 "common-actions.vala"
	return synapse_common_actions_runner_construct (SYNAPSE_COMMON_ACTIONS_TYPE_RUNNER);
#line 1032 "common-actions.c"
}

static gpointer
_g_object_ref0 (gpointer self)
{
#line 72 "common-actions.vala"
	return self ? g_object_ref (self) : NULL;
#line 1040 "common-actions.c"
}

static void
synapse_common_actions_runner_real_do_execute (SynapseAction* base,
                                               SynapseMatch* match,
                                               SynapseMatch* target)
{
	SynapseCommonActionsRunner * self;
	GError* _inner_error0_ = NULL;
#line 66 "common-actions.vala"
	self = (SynapseCommonActionsRunner*) base;
#line 66 "common-actions.vala"
	g_return_if_fail (match != NULL);
#line 68 "common-actions.vala"
	if (SYNAPSE_IS_APPLICATION_MATCH (match)) {
#line 1056 "common-actions.c"
		SynapseApplicationMatch* app_match = NULL;
		GAppInfo* _tmp0_ = NULL;
		SynapseApplicationMatch* _tmp1_;
		GAppInfo* _tmp2_;
		GAppInfo* _tmp3_;
		GAppInfo* _tmp4_;
		GAppInfo* app = NULL;
		GAppInfo* _tmp9_;
#line 70 "common-actions.vala"
		app_match = G_TYPE_CHECK_INSTANCE_CAST (match, SYNAPSE_TYPE_APPLICATION_MATCH, SynapseApplicationMatch);
#line 72 "common-actions.vala"
		_tmp1_ = app_match;
#line 72 "common-actions.vala"
		_tmp2_ = synapse_application_match_get_app_info (_tmp1_);
#line 72 "common-actions.vala"
		_tmp3_ = _tmp2_;
#line 72 "common-actions.vala"
		_tmp4_ = _g_object_ref0 (_tmp3_);
#line 72 "common-actions.vala"
		_tmp0_ = _tmp4_;
#line 72 "common-actions.vala"
		if (_tmp0_ == NULL) {
#line 1079 "common-actions.c"
			SynapseApplicationMatch* _tmp5_;
			const gchar* _tmp6_;
			const gchar* _tmp7_;
			GDesktopAppInfo* _tmp8_;
#line 73 "common-actions.vala"
			_tmp5_ = app_match;
#line 73 "common-actions.vala"
			_tmp6_ = synapse_application_match_get_filename (_tmp5_);
#line 73 "common-actions.vala"
			_tmp7_ = _tmp6_;
#line 73 "common-actions.vala"
			_tmp8_ = g_desktop_app_info_new_from_filename (_tmp7_);
#line 73 "common-actions.vala"
			_g_object_unref0 (_tmp0_);
#line 73 "common-actions.vala"
			_tmp0_ = (GAppInfo*) _tmp8_;
#line 1096 "common-actions.c"
		}
#line 72 "common-actions.vala"
		_tmp9_ = _tmp0_;
#line 72 "common-actions.vala"
		_tmp0_ = NULL;
#line 72 "common-actions.vala"
		app = _tmp9_;
#line 1104 "common-actions.c"
		{
			GAppInfo* _tmp10_;
			GdkDisplay* _tmp11_;
			GdkAppLaunchContext* _tmp12_;
			GdkAppLaunchContext* _tmp13_;
			SynapseRelevancyService* _tmp14_;
			SynapseRelevancyService* _tmp15_;
			GAppInfo* _tmp16_;
#line 77 "common-actions.vala"
			_tmp10_ = app;
#line 77 "common-actions.vala"
			_tmp11_ = gdk_display_get_default ();
#line 77 "common-actions.vala"
			_tmp12_ = gdk_display_get_app_launch_context (_tmp11_);
#line 77 "common-actions.vala"
			_tmp13_ = _tmp12_;
#line 77 "common-actions.vala"
			g_app_info_launch (_tmp10_, NULL, (GAppLaunchContext*) _tmp13_, &_inner_error0_);
#line 77 "common-actions.vala"
			_g_object_unref0 (_tmp13_);
#line 77 "common-actions.vala"
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 1127 "common-actions.c"
				goto __catch0_g_error;
			}
#line 79 "common-actions.vala"
			_tmp14_ = synapse_relevancy_service_get_default ();
#line 79 "common-actions.vala"
			_tmp15_ = _tmp14_;
#line 79 "common-actions.vala"
			_tmp16_ = app;
#line 79 "common-actions.vala"
			synapse_relevancy_service_application_launched (_tmp15_, _tmp16_);
#line 79 "common-actions.vala"
			_g_object_unref0 (_tmp15_);
#line 1140 "common-actions.c"
		}
		goto __finally0;
		__catch0_g_error:
		{
			GError* err = NULL;
			GError* _tmp17_;
			const gchar* _tmp18_;
#line 75 "common-actions.vala"
			err = _inner_error0_;
#line 75 "common-actions.vala"
			_inner_error0_ = NULL;
#line 83 "common-actions.vala"
			_tmp17_ = err;
#line 83 "common-actions.vala"
			_tmp18_ = _tmp17_->message;
#line 83 "common-actions.vala"
			g_warning ("common-actions.vala:83: %s", _tmp18_);
#line 75 "common-actions.vala"
			_g_error_free0 (err);
#line 1160 "common-actions.c"
		}
		__finally0:
#line 75 "common-actions.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 75 "common-actions.vala"
			_g_object_unref0 (app);
#line 75 "common-actions.vala"
			_g_object_unref0 (_tmp0_);
#line 75 "common-actions.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 75 "common-actions.vala"
			g_clear_error (&_inner_error0_);
#line 75 "common-actions.vala"
			return;
#line 1175 "common-actions.c"
		}
#line 68 "common-actions.vala"
		_g_object_unref0 (app);
#line 68 "common-actions.vala"
		_g_object_unref0 (_tmp0_);
#line 1181 "common-actions.c"
	} else {
#line 86 "common-actions.vala"
		if (SYNAPSE_IS_ACTION_MATCH (match)) {
#line 88 "common-actions.vala"
			synapse_action_match_do_action (G_TYPE_CHECK_INSTANCE_CAST (match, SYNAPSE_TYPE_ACTION_MATCH, SynapseActionMatch));
#line 1187 "common-actions.c"
		} else {
#line 90 "common-actions.vala"
			if (SYNAPSE_IS_ACTION (match)) {
#line 92 "common-actions.vala"
				synapse_action_do_execute (G_TYPE_CHECK_INSTANCE_CAST (match, SYNAPSE_TYPE_ACTION, SynapseAction), match, target);
#line 1193 "common-actions.c"
			} else {
#line 94 "common-actions.vala"
				if (SYNAPSE_IS_URI_MATCH (match)) {
#line 1197 "common-actions.c"
					{
						const gchar* uri = NULL;
						const gchar* _tmp19_;
						const gchar* _tmp20_;
						const gchar* _tmp21_;
#line 98 "common-actions.vala"
						_tmp19_ = synapse_uri_match_get_uri (G_TYPE_CHECK_INSTANCE_CAST (match, SYNAPSE_TYPE_URI_MATCH, SynapseUriMatch));
#line 98 "common-actions.vala"
						_tmp20_ = _tmp19_;
#line 98 "common-actions.vala"
						uri = _tmp20_;
#line 99 "common-actions.vala"
						_tmp21_ = uri;
#line 99 "common-actions.vala"
						if (g_str_has_prefix (_tmp21_, "file:")) {
#line 1213 "common-actions.c"
							GFile* file = NULL;
							const gchar* _tmp22_;
							GFile* _tmp23_;
							GAppInfo* app = NULL;
							GFile* _tmp24_;
							gchar* _tmp25_;
							gchar* _tmp26_;
							GFile* _tmp27_;
							gchar* _tmp28_;
							gchar* _tmp29_;
							GAppInfo* _tmp30_;
							GAppInfo* _tmp31_;
							GAppInfo* _tmp32_;
							GdkDisplay* _tmp33_;
							GdkAppLaunchContext* _tmp34_;
							GdkAppLaunchContext* _tmp35_;
#line 101 "common-actions.vala"
							_tmp22_ = uri;
#line 101 "common-actions.vala"
							_tmp23_ = g_file_new_for_uri (_tmp22_);
#line 101 "common-actions.vala"
							file = _tmp23_;
#line 102 "common-actions.vala"
							_tmp24_ = file;
#line 102 "common-actions.vala"
							_tmp25_ = g_file_get_path (_tmp24_);
#line 102 "common-actions.vala"
							_tmp26_ = _tmp25_;
#line 102 "common-actions.vala"
							_tmp27_ = file;
#line 102 "common-actions.vala"
							_tmp28_ = g_file_get_basename (_tmp27_);
#line 102 "common-actions.vala"
							_tmp29_ = _tmp28_;
#line 102 "common-actions.vala"
							_tmp30_ = g_app_info_create_from_commandline (_tmp26_, _tmp29_, G_APP_INFO_CREATE_NONE, &_inner_error0_);
#line 102 "common-actions.vala"
							_tmp31_ = _tmp30_;
#line 102 "common-actions.vala"
							_g_free0 (_tmp29_);
#line 102 "common-actions.vala"
							_g_free0 (_tmp26_);
#line 102 "common-actions.vala"
							app = _tmp31_;
#line 102 "common-actions.vala"
							if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 102 "common-actions.vala"
								_g_object_unref0 (file);
#line 1262 "common-actions.c"
								goto __catch1_g_error;
							}
#line 105 "common-actions.vala"
							_tmp32_ = app;
#line 105 "common-actions.vala"
							_tmp33_ = gdk_display_get_default ();
#line 105 "common-actions.vala"
							_tmp34_ = gdk_display_get_app_launch_context (_tmp33_);
#line 105 "common-actions.vala"
							_tmp35_ = _tmp34_;
#line 105 "common-actions.vala"
							g_app_info_launch (_tmp32_, NULL, (GAppLaunchContext*) _tmp35_, &_inner_error0_);
#line 105 "common-actions.vala"
							_g_object_unref0 (_tmp35_);
#line 105 "common-actions.vala"
							if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 105 "common-actions.vala"
								_g_object_unref0 (app);
#line 105 "common-actions.vala"
								_g_object_unref0 (file);
#line 1283 "common-actions.c"
								goto __catch1_g_error;
							}
#line 99 "common-actions.vala"
							_g_object_unref0 (app);
#line 99 "common-actions.vala"
							_g_object_unref0 (file);
#line 1290 "common-actions.c"
						}
					}
					goto __finally1;
					__catch1_g_error:
					{
						GError* err = NULL;
						GError* _tmp36_;
						const gchar* _tmp37_;
#line 96 "common-actions.vala"
						err = _inner_error0_;
#line 96 "common-actions.vala"
						_inner_error0_ = NULL;
#line 110 "common-actions.vala"
						_tmp36_ = err;
#line 110 "common-actions.vala"
						_tmp37_ = _tmp36_->message;
#line 110 "common-actions.vala"
						g_warning ("common-actions.vala:110: %s", _tmp37_);
#line 96 "common-actions.vala"
						_g_error_free0 (err);
#line 1311 "common-actions.c"
					}
					__finally1:
#line 96 "common-actions.vala"
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 96 "common-actions.vala"
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 96 "common-actions.vala"
						g_clear_error (&_inner_error0_);
#line 96 "common-actions.vala"
						return;
#line 1322 "common-actions.c"
					}
				} else {
					const gchar* _tmp38_;
					const gchar* _tmp39_;
#line 115 "common-actions.vala"
					_tmp38_ = synapse_match_get_title (match);
#line 115 "common-actions.vala"
					_tmp39_ = _tmp38_;
#line 115 "common-actions.vala"
					g_warning ("common-actions.vala:115: '%s' is not be handled here", _tmp39_);
#line 1333 "common-actions.c"
				}
			}
		}
	}
}

static gboolean
synapse_common_actions_runner_real_valid_for_match (SynapseAction* base,
                                                    SynapseMatch* match)
{
	SynapseCommonActionsRunner * self;
	gboolean _tmp11_ = FALSE;
	gboolean _tmp12_ = FALSE;
	gboolean result;
#line 119 "common-actions.vala"
	self = (SynapseCommonActionsRunner*) base;
#line 119 "common-actions.vala"
	g_return_val_if_fail (match != NULL, FALSE);
#line 121 "common-actions.vala"
	if (SYNAPSE_IS_URI_MATCH (match)) {
#line 1354 "common-actions.c"
		const gchar* uri = NULL;
		const gchar* _tmp0_;
		const gchar* _tmp1_;
		const gchar* _tmp2_;
#line 123 "common-actions.vala"
		_tmp0_ = synapse_uri_match_get_uri (G_TYPE_CHECK_INSTANCE_CAST (match, SYNAPSE_TYPE_URI_MATCH, SynapseUriMatch));
#line 123 "common-actions.vala"
		_tmp1_ = _tmp0_;
#line 123 "common-actions.vala"
		uri = _tmp1_;
#line 124 "common-actions.vala"
		_tmp2_ = uri;
#line 124 "common-actions.vala"
		if (g_str_has_prefix (_tmp2_, "file:")) {
#line 1369 "common-actions.c"
			gchar* path = NULL;
			const gchar* _tmp3_;
			GFile* _tmp4_;
			GFile* _tmp5_;
			gchar* _tmp6_;
			gchar* _tmp7_;
			gboolean _tmp8_ = FALSE;
			const gchar* _tmp9_;
#line 126 "common-actions.vala"
			_tmp3_ = uri;
#line 126 "common-actions.vala"
			_tmp4_ = g_file_new_for_uri (_tmp3_);
#line 126 "common-actions.vala"
			_tmp5_ = _tmp4_;
#line 126 "common-actions.vala"
			_tmp6_ = g_file_get_path (_tmp5_);
#line 126 "common-actions.vala"
			_tmp7_ = _tmp6_;
#line 126 "common-actions.vala"
			_g_object_unref0 (_tmp5_);
#line 126 "common-actions.vala"
			path = _tmp7_;
#line 127 "common-actions.vala"
			_tmp9_ = path;
#line 127 "common-actions.vala"
			if (g_file_test (_tmp9_, G_FILE_TEST_IS_EXECUTABLE)) {
#line 1396 "common-actions.c"
				const gchar* _tmp10_;
#line 127 "common-actions.vala"
				_tmp10_ = path;
#line 127 "common-actions.vala"
				_tmp8_ = !g_file_test (_tmp10_, G_FILE_TEST_IS_DIR);
#line 1402 "common-actions.c"
			} else {
#line 127 "common-actions.vala"
				_tmp8_ = FALSE;
#line 1406 "common-actions.c"
			}
#line 127 "common-actions.vala"
			result = _tmp8_;
#line 127 "common-actions.vala"
			_g_free0 (path);
#line 127 "common-actions.vala"
			return result;
#line 1414 "common-actions.c"
		}
	}
#line 131 "common-actions.vala"
	if (SYNAPSE_IS_ACTION (match)) {
#line 131 "common-actions.vala"
		_tmp12_ = TRUE;
#line 1421 "common-actions.c"
	} else {
#line 132 "common-actions.vala"
		_tmp12_ = SYNAPSE_IS_ACTION_MATCH (match);
#line 1425 "common-actions.c"
	}
#line 131 "common-actions.vala"
	if (_tmp12_) {
#line 131 "common-actions.vala"
		_tmp11_ = TRUE;
#line 1431 "common-actions.c"
	} else {
		gboolean _tmp13_ = FALSE;
#line 133 "common-actions.vala"
		if (SYNAPSE_IS_APPLICATION_MATCH (match)) {
#line 1436 "common-actions.c"
			gboolean _tmp14_;
			gboolean _tmp15_;
#line 133 "common-actions.vala"
			_tmp14_ = synapse_application_match_get_needs_terminal (G_TYPE_CHECK_INSTANCE_CAST (match, SYNAPSE_TYPE_APPLICATION_MATCH, SynapseApplicationMatch));
#line 133 "common-actions.vala"
			_tmp15_ = _tmp14_;
#line 133 "common-actions.vala"
			_tmp13_ = !_tmp15_;
#line 1445 "common-actions.c"
		} else {
#line 133 "common-actions.vala"
			_tmp13_ = FALSE;
#line 1449 "common-actions.c"
		}
#line 133 "common-actions.vala"
		_tmp11_ = _tmp13_;
#line 1453 "common-actions.c"
	}
#line 131 "common-actions.vala"
	result = _tmp11_;
#line 131 "common-actions.vala"
	return result;
#line 1459 "common-actions.c"
}

static void
synapse_common_actions_runner_class_init (SynapseCommonActionsRunnerClass * klass,
                                          gpointer klass_data)
{
#line 56 "common-actions.vala"
	synapse_common_actions_runner_parent_class = g_type_class_peek_parent (klass);
#line 56 "common-actions.vala"
	((SynapseActionClass *) klass)->do_execute = (void (*) (SynapseAction*, SynapseMatch*, SynapseMatch*)) synapse_common_actions_runner_real_do_execute;
#line 56 "common-actions.vala"
	((SynapseActionClass *) klass)->valid_for_match = (gboolean (*) (SynapseAction*, SynapseMatch*)) synapse_common_actions_runner_real_valid_for_match;
#line 1472 "common-actions.c"
}

static void
synapse_common_actions_runner_instance_init (SynapseCommonActionsRunner * self,
                                             gpointer klass)
{
}

static GType
synapse_common_actions_runner_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SynapseCommonActionsRunnerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) synapse_common_actions_runner_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SynapseCommonActionsRunner), 0, (GInstanceInitFunc) synapse_common_actions_runner_instance_init, NULL };
	GType synapse_common_actions_runner_type_id;
	synapse_common_actions_runner_type_id = g_type_register_static (SYNAPSE_TYPE_ACTION, "SynapseCommonActionsRunner", &g_define_type_info, 0);
	return synapse_common_actions_runner_type_id;
}

static GType
synapse_common_actions_runner_get_type (void)
{
	static volatile gsize synapse_common_actions_runner_type_id__once = 0;
	if (g_once_init_enter (&synapse_common_actions_runner_type_id__once)) {
		GType synapse_common_actions_runner_type_id;
		synapse_common_actions_runner_type_id = synapse_common_actions_runner_get_type_once ();
		g_once_init_leave (&synapse_common_actions_runner_type_id__once, synapse_common_actions_runner_type_id);
	}
	return synapse_common_actions_runner_type_id__once;
}

static SynapseCommonActionsTerminalRunner*
synapse_common_actions_terminal_runner_construct (GType object_type)
{
	SynapseCommonActionsTerminalRunner * self = NULL;
#line 141 "common-actions.vala"
	self = (SynapseCommonActionsTerminalRunner*) g_object_new (object_type, "title", _ ("Run in Terminal"), "description", _ ("Run application or command in terminal"), "icon-name", "terminal", "has-thumbnail", FALSE, "default-relevancy", SYNAPSE_MATCH_SCORE_BELOW_AVERAGE, NULL);
#line 139 "common-actions.vala"
	return self;
#line 1510 "common-actions.c"
}

static SynapseCommonActionsTerminalRunner*
synapse_common_actions_terminal_runner_new (void)
{
#line 139 "common-actions.vala"
	return synapse_common_actions_terminal_runner_construct (SYNAPSE_COMMON_ACTIONS_TYPE_TERMINAL_RUNNER);
#line 1518 "common-actions.c"
}

static void
synapse_common_actions_terminal_runner_real_do_execute (SynapseAction* base,
                                                        SynapseMatch* match,
                                                        SynapseMatch* target)
{
	SynapseCommonActionsTerminalRunner * self;
	GError* _inner_error0_ = NULL;
#line 147 "common-actions.vala"
	self = (SynapseCommonActionsTerminalRunner*) base;
#line 147 "common-actions.vala"
	g_return_if_fail (match != NULL);
#line 149 "common-actions.vala"
	if (SYNAPSE_IS_APPLICATION_MATCH (match)) {
#line 1534 "common-actions.c"
		SynapseApplicationMatch* app_match = NULL;
		GAppInfo* _tmp0_ = NULL;
		SynapseApplicationMatch* _tmp1_;
		GAppInfo* _tmp2_;
		GAppInfo* _tmp3_;
		GAppInfo* _tmp4_;
		GAppInfo* original = NULL;
		GAppInfo* _tmp9_;
		GAppInfo* _tmp10_;
		const gchar* _tmp11_;
		GAppInfo* _tmp12_;
		const gchar* _tmp13_;
#line 151 "common-actions.vala"
		app_match = G_TYPE_CHECK_INSTANCE_CAST (match, SYNAPSE_TYPE_APPLICATION_MATCH, SynapseApplicationMatch);
#line 153 "common-actions.vala"
		_tmp1_ = app_match;
#line 153 "common-actions.vala"
		_tmp2_ = synapse_application_match_get_app_info (_tmp1_);
#line 153 "common-actions.vala"
		_tmp3_ = _tmp2_;
#line 153 "common-actions.vala"
		_tmp4_ = _g_object_ref0 (_tmp3_);
#line 153 "common-actions.vala"
		_tmp0_ = _tmp4_;
#line 153 "common-actions.vala"
		if (_tmp0_ == NULL) {
#line 1561 "common-actions.c"
			SynapseApplicationMatch* _tmp5_;
			const gchar* _tmp6_;
			const gchar* _tmp7_;
			GDesktopAppInfo* _tmp8_;
#line 154 "common-actions.vala"
			_tmp5_ = app_match;
#line 154 "common-actions.vala"
			_tmp6_ = synapse_application_match_get_filename (_tmp5_);
#line 154 "common-actions.vala"
			_tmp7_ = _tmp6_;
#line 154 "common-actions.vala"
			_tmp8_ = g_desktop_app_info_new_from_filename (_tmp7_);
#line 154 "common-actions.vala"
			_g_object_unref0 (_tmp0_);
#line 154 "common-actions.vala"
			_tmp0_ = (GAppInfo*) _tmp8_;
#line 1578 "common-actions.c"
		}
#line 153 "common-actions.vala"
		_tmp9_ = _tmp0_;
#line 153 "common-actions.vala"
		_tmp0_ = NULL;
#line 153 "common-actions.vala"
		original = _tmp9_;
#line 156 "common-actions.vala"
		_tmp10_ = original;
#line 156 "common-actions.vala"
		_tmp11_ = g_app_info_get_commandline (_tmp10_);
#line 156 "common-actions.vala"
		_tmp12_ = original;
#line 156 "common-actions.vala"
		_tmp13_ = g_app_info_get_name (_tmp12_);
#line 156 "common-actions.vala"
		synapse_utils_open_command_line (_tmp11_, _tmp13_, TRUE);
#line 149 "common-actions.vala"
		_g_object_unref0 (original);
#line 149 "common-actions.vala"
		_g_object_unref0 (_tmp0_);
#line 1600 "common-actions.c"
	} else {
#line 158 "common-actions.vala"
		if (SYNAPSE_IS_URI_MATCH (match)) {
#line 1604 "common-actions.c"
			{
				const gchar* uri = NULL;
				const gchar* _tmp14_;
				const gchar* _tmp15_;
				const gchar* _tmp16_;
#line 162 "common-actions.vala"
				_tmp14_ = synapse_uri_match_get_uri (G_TYPE_CHECK_INSTANCE_CAST (match, SYNAPSE_TYPE_URI_MATCH, SynapseUriMatch));
#line 162 "common-actions.vala"
				_tmp15_ = _tmp14_;
#line 162 "common-actions.vala"
				uri = _tmp15_;
#line 163 "common-actions.vala"
				_tmp16_ = uri;
#line 163 "common-actions.vala"
				if (g_str_has_prefix (_tmp16_, "file:")) {
#line 1620 "common-actions.c"
					GFile* file = NULL;
					const gchar* _tmp17_;
					GFile* _tmp18_;
					GAppInfo* app = NULL;
					GFile* _tmp19_;
					gchar* _tmp20_;
					gchar* _tmp21_;
					GFile* _tmp22_;
					gchar* _tmp23_;
					gchar* _tmp24_;
					GAppInfo* _tmp25_;
					GAppInfo* _tmp26_;
					GAppInfo* _tmp27_;
					GdkDisplay* _tmp28_;
					GdkAppLaunchContext* _tmp29_;
					GdkAppLaunchContext* _tmp30_;
#line 165 "common-actions.vala"
					_tmp17_ = uri;
#line 165 "common-actions.vala"
					_tmp18_ = g_file_new_for_uri (_tmp17_);
#line 165 "common-actions.vala"
					file = _tmp18_;
#line 166 "common-actions.vala"
					_tmp19_ = file;
#line 166 "common-actions.vala"
					_tmp20_ = g_file_get_path (_tmp19_);
#line 166 "common-actions.vala"
					_tmp21_ = _tmp20_;
#line 166 "common-actions.vala"
					_tmp22_ = file;
#line 166 "common-actions.vala"
					_tmp23_ = g_file_get_basename (_tmp22_);
#line 166 "common-actions.vala"
					_tmp24_ = _tmp23_;
#line 166 "common-actions.vala"
					_tmp25_ = g_app_info_create_from_commandline (_tmp21_, _tmp24_, G_APP_INFO_CREATE_NEEDS_TERMINAL, &_inner_error0_);
#line 166 "common-actions.vala"
					_tmp26_ = _tmp25_;
#line 166 "common-actions.vala"
					_g_free0 (_tmp24_);
#line 166 "common-actions.vala"
					_g_free0 (_tmp21_);
#line 166 "common-actions.vala"
					app = _tmp26_;
#line 166 "common-actions.vala"
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 166 "common-actions.vala"
						_g_object_unref0 (file);
#line 1669 "common-actions.c"
						goto __catch0_g_error;
					}
#line 169 "common-actions.vala"
					_tmp27_ = app;
#line 169 "common-actions.vala"
					_tmp28_ = gdk_display_get_default ();
#line 169 "common-actions.vala"
					_tmp29_ = gdk_display_get_app_launch_context (_tmp28_);
#line 169 "common-actions.vala"
					_tmp30_ = _tmp29_;
#line 169 "common-actions.vala"
					g_app_info_launch (_tmp27_, NULL, (GAppLaunchContext*) _tmp30_, &_inner_error0_);
#line 169 "common-actions.vala"
					_g_object_unref0 (_tmp30_);
#line 169 "common-actions.vala"
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 169 "common-actions.vala"
						_g_object_unref0 (app);
#line 169 "common-actions.vala"
						_g_object_unref0 (file);
#line 1690 "common-actions.c"
						goto __catch0_g_error;
					}
#line 163 "common-actions.vala"
					_g_object_unref0 (app);
#line 163 "common-actions.vala"
					_g_object_unref0 (file);
#line 1697 "common-actions.c"
				}
			}
			goto __finally0;
			__catch0_g_error:
			{
				GError* err = NULL;
				GError* _tmp31_;
				const gchar* _tmp32_;
#line 160 "common-actions.vala"
				err = _inner_error0_;
#line 160 "common-actions.vala"
				_inner_error0_ = NULL;
#line 174 "common-actions.vala"
				_tmp31_ = err;
#line 174 "common-actions.vala"
				_tmp32_ = _tmp31_->message;
#line 174 "common-actions.vala"
				g_warning ("common-actions.vala:174: %s", _tmp32_);
#line 160 "common-actions.vala"
				_g_error_free0 (err);
#line 1718 "common-actions.c"
			}
			__finally0:
#line 160 "common-actions.vala"
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 160 "common-actions.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 160 "common-actions.vala"
				g_clear_error (&_inner_error0_);
#line 160 "common-actions.vala"
				return;
#line 1729 "common-actions.c"
			}
		}
	}
}

static gboolean
synapse_common_actions_terminal_runner_real_valid_for_match (SynapseAction* base,
                                                             SynapseMatch* match)
{
	SynapseCommonActionsTerminalRunner * self;
	gboolean result;
#line 179 "common-actions.vala"
	self = (SynapseCommonActionsTerminalRunner*) base;
#line 179 "common-actions.vala"
	g_return_val_if_fail (match != NULL, FALSE);
#line 181 "common-actions.vala"
	if (SYNAPSE_IS_URI_MATCH (match)) {
#line 1747 "common-actions.c"
		const gchar* uri = NULL;
		const gchar* _tmp0_;
		const gchar* _tmp1_;
		const gchar* _tmp2_;
#line 183 "common-actions.vala"
		_tmp0_ = synapse_uri_match_get_uri (G_TYPE_CHECK_INSTANCE_CAST (match, SYNAPSE_TYPE_URI_MATCH, SynapseUriMatch));
#line 183 "common-actions.vala"
		_tmp1_ = _tmp0_;
#line 183 "common-actions.vala"
		uri = _tmp1_;
#line 184 "common-actions.vala"
		_tmp2_ = uri;
#line 184 "common-actions.vala"
		if (g_str_has_prefix (_tmp2_, "file:")) {
#line 1762 "common-actions.c"
			gchar* path = NULL;
			const gchar* _tmp3_;
			GFile* _tmp4_;
			GFile* _tmp5_;
			gchar* _tmp6_;
			gchar* _tmp7_;
			gboolean _tmp8_ = FALSE;
			const gchar* _tmp9_;
#line 186 "common-actions.vala"
			_tmp3_ = uri;
#line 186 "common-actions.vala"
			_tmp4_ = g_file_new_for_uri (_tmp3_);
#line 186 "common-actions.vala"
			_tmp5_ = _tmp4_;
#line 186 "common-actions.vala"
			_tmp6_ = g_file_get_path (_tmp5_);
#line 186 "common-actions.vala"
			_tmp7_ = _tmp6_;
#line 186 "common-actions.vala"
			_g_object_unref0 (_tmp5_);
#line 186 "common-actions.vala"
			path = _tmp7_;
#line 187 "common-actions.vala"
			_tmp9_ = path;
#line 187 "common-actions.vala"
			if (g_file_test (_tmp9_, G_FILE_TEST_IS_EXECUTABLE)) {
#line 1789 "common-actions.c"
				const gchar* _tmp10_;
#line 187 "common-actions.vala"
				_tmp10_ = path;
#line 187 "common-actions.vala"
				_tmp8_ = !g_file_test (_tmp10_, G_FILE_TEST_IS_DIR);
#line 1795 "common-actions.c"
			} else {
#line 187 "common-actions.vala"
				_tmp8_ = FALSE;
#line 1799 "common-actions.c"
			}
#line 187 "common-actions.vala"
			result = _tmp8_;
#line 187 "common-actions.vala"
			_g_free0 (path);
#line 187 "common-actions.vala"
			return result;
#line 1807 "common-actions.c"
		}
	}
#line 190 "common-actions.vala"
	result = SYNAPSE_IS_APPLICATION_MATCH (match);
#line 190 "common-actions.vala"
	return result;
#line 1814 "common-actions.c"
}

static void
synapse_common_actions_terminal_runner_class_init (SynapseCommonActionsTerminalRunnerClass * klass,
                                                   gpointer klass_data)
{
#line 137 "common-actions.vala"
	synapse_common_actions_terminal_runner_parent_class = g_type_class_peek_parent (klass);
#line 137 "common-actions.vala"
	((SynapseActionClass *) klass)->do_execute = (void (*) (SynapseAction*, SynapseMatch*, SynapseMatch*)) synapse_common_actions_terminal_runner_real_do_execute;
#line 137 "common-actions.vala"
	((SynapseActionClass *) klass)->valid_for_match = (gboolean (*) (SynapseAction*, SynapseMatch*)) synapse_common_actions_terminal_runner_real_valid_for_match;
#line 1827 "common-actions.c"
}

static void
synapse_common_actions_terminal_runner_instance_init (SynapseCommonActionsTerminalRunner * self,
                                                      gpointer klass)
{
}

static GType
synapse_common_actions_terminal_runner_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SynapseCommonActionsTerminalRunnerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) synapse_common_actions_terminal_runner_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SynapseCommonActionsTerminalRunner), 0, (GInstanceInitFunc) synapse_common_actions_terminal_runner_instance_init, NULL };
	GType synapse_common_actions_terminal_runner_type_id;
	synapse_common_actions_terminal_runner_type_id = g_type_register_static (SYNAPSE_TYPE_ACTION, "SynapseCommonActionsTerminalRunner", &g_define_type_info, 0);
	return synapse_common_actions_terminal_runner_type_id;
}

static GType
synapse_common_actions_terminal_runner_get_type (void)
{
	static volatile gsize synapse_common_actions_terminal_runner_type_id__once = 0;
	if (g_once_init_enter (&synapse_common_actions_terminal_runner_type_id__once)) {
		GType synapse_common_actions_terminal_runner_type_id;
		synapse_common_actions_terminal_runner_type_id = synapse_common_actions_terminal_runner_get_type_once ();
		g_once_init_leave (&synapse_common_actions_terminal_runner_type_id__once, synapse_common_actions_terminal_runner_type_id);
	}
	return synapse_common_actions_terminal_runner_type_id__once;
}

static inline gpointer
synapse_common_actions_opener_get_instance_private (SynapseCommonActionsOpener* self)
{
	return G_STRUCT_MEMBER_P (self, SynapseCommonActionsOpener_private_offset);
}

static SynapseCommonActionsOpener*
synapse_common_actions_opener_construct (GType object_type)
{
	SynapseCommonActionsOpener * self = NULL;
#line 198 "common-actions.vala"
	self = (SynapseCommonActionsOpener*) g_object_new (object_type, "title", _ ("Open"), "description", _ ("Open using default application"), "icon-name", "fileopen", "has-thumbnail", FALSE, "default-relevancy", SYNAPSE_MATCH_SCORE_GOOD, NULL);
#line 196 "common-actions.vala"
	return self;
#line 1871 "common-actions.c"
}

static SynapseCommonActionsOpener*
synapse_common_actions_opener_new (void)
{
#line 196 "common-actions.vala"
	return synapse_common_actions_opener_construct (SYNAPSE_COMMON_ACTIONS_TYPE_OPENER);
#line 1879 "common-actions.c"
}

static glong
string_strnlen (gchar* str,
                glong maxlen)
{
	gchar* end = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	glong result;
#line 1501 "glib-2.0.vapi"
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
#line 1501 "glib-2.0.vapi"
	end = _tmp0_;
#line 1502 "glib-2.0.vapi"
	_tmp1_ = end;
#line 1502 "glib-2.0.vapi"
	if (_tmp1_ == NULL) {
#line 1503 "glib-2.0.vapi"
		result = maxlen;
#line 1503 "glib-2.0.vapi"
		return result;
#line 1902 "common-actions.c"
	} else {
		gchar* _tmp2_;
#line 1505 "glib-2.0.vapi"
		_tmp2_ = end;
#line 1505 "glib-2.0.vapi"
		result = (glong) (_tmp2_ - str);
#line 1505 "glib-2.0.vapi"
		return result;
#line 1911 "common-actions.c"
	}
}

static gchar*
string_substring (const gchar* self,
                  glong offset,
                  glong len)
{
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	gchar* _tmp3_;
	gchar* result;
#line 1512 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1514 "glib-2.0.vapi"
	if (offset >= ((glong) 0)) {
#line 1514 "glib-2.0.vapi"
		_tmp0_ = len >= ((glong) 0);
#line 1930 "common-actions.c"
	} else {
#line 1514 "glib-2.0.vapi"
		_tmp0_ = FALSE;
#line 1934 "common-actions.c"
	}
#line 1514 "glib-2.0.vapi"
	if (_tmp0_) {
#line 1516 "glib-2.0.vapi"
		string_length = string_strnlen ((gchar*) self, offset + len);
#line 1940 "common-actions.c"
	} else {
		gint _tmp1_;
		gint _tmp2_;
#line 1518 "glib-2.0.vapi"
		_tmp1_ = strlen (self);
#line 1518 "glib-2.0.vapi"
		_tmp2_ = _tmp1_;
#line 1518 "glib-2.0.vapi"
		string_length = (glong) _tmp2_;
#line 1950 "common-actions.c"
	}
#line 1521 "glib-2.0.vapi"
	if (offset < ((glong) 0)) {
#line 1522 "glib-2.0.vapi"
		offset = string_length + offset;
#line 1523 "glib-2.0.vapi"
		g_return_val_if_fail (offset >= ((glong) 0), NULL);
#line 1958 "common-actions.c"
	} else {
#line 1525 "glib-2.0.vapi"
		g_return_val_if_fail (offset <= string_length, NULL);
#line 1962 "common-actions.c"
	}
#line 1527 "glib-2.0.vapi"
	if (len < ((glong) 0)) {
#line 1528 "glib-2.0.vapi"
		len = string_length - offset;
#line 1968 "common-actions.c"
	}
#line 1530 "glib-2.0.vapi"
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
#line 1531 "glib-2.0.vapi"
	_tmp3_ = g_strndup (((gchar*) self) + offset, (gsize) len);
#line 1531 "glib-2.0.vapi"
	result = _tmp3_;
#line 1531 "glib-2.0.vapi"
	return result;
#line 1978 "common-actions.c"
}

static void
synapse_common_actions_opener_real_do_execute (SynapseAction* base,
                                               SynapseMatch* match,
                                               SynapseMatch* target)
{
	SynapseCommonActionsOpener * self;
	SynapseUriMatch* uri_match = NULL;
	SynapseUriMatch* _tmp0_;
#line 204 "common-actions.vala"
	self = (SynapseCommonActionsOpener*) base;
#line 204 "common-actions.vala"
	g_return_if_fail (match != NULL);
#line 206 "common-actions.vala"
	uri_match = SYNAPSE_IS_URI_MATCH (match) ? ((SynapseUriMatch*) match) : NULL;
#line 208 "common-actions.vala"
	_tmp0_ = uri_match;
#line 208 "common-actions.vala"
	if (_tmp0_ != NULL) {
#line 1999 "common-actions.c"
		SynapseUriMatch* _tmp1_;
		const gchar* _tmp2_;
		const gchar* _tmp3_;
#line 210 "common-actions.vala"
		_tmp1_ = uri_match;
#line 210 "common-actions.vala"
		_tmp2_ = synapse_uri_match_get_uri (_tmp1_);
#line 210 "common-actions.vala"
		_tmp3_ = _tmp2_;
#line 210 "common-actions.vala"
		synapse_utils_open_uri (_tmp3_);
#line 2011 "common-actions.c"
	} else {
		GRegex* _tmp4_;
		const gchar* _tmp5_;
		const gchar* _tmp6_;
#line 212 "common-actions.vala"
		_tmp4_ = self->priv->file_path;
#line 212 "common-actions.vala"
		_tmp5_ = synapse_match_get_title (match);
#line 212 "common-actions.vala"
		_tmp6_ = _tmp5_;
#line 212 "common-actions.vala"
		if (g_regex_match (_tmp4_, _tmp6_, 0, NULL)) {
#line 2024 "common-actions.c"
			GFile* f = NULL;
			const gchar* _tmp7_;
			const gchar* _tmp8_;
			GFile* _tmp20_;
			gchar* _tmp21_;
			gchar* _tmp22_;
#line 215 "common-actions.vala"
			_tmp7_ = synapse_match_get_title (match);
#line 215 "common-actions.vala"
			_tmp8_ = _tmp7_;
#line 215 "common-actions.vala"
			if (g_str_has_prefix (_tmp8_, "~")) {
#line 2037 "common-actions.c"
				const gchar* _tmp9_;
				const gchar* _tmp10_;
				const gchar* _tmp11_;
				gchar* _tmp12_;
				gchar* _tmp13_;
				gchar* _tmp14_;
				gchar* _tmp15_;
				GFile* _tmp16_;
#line 217 "common-actions.vala"
				_tmp9_ = g_get_home_dir ();
#line 217 "common-actions.vala"
				_tmp10_ = synapse_match_get_title (match);
#line 217 "common-actions.vala"
				_tmp11_ = _tmp10_;
#line 217 "common-actions.vala"
				_tmp12_ = string_substring (_tmp11_, (glong) 1, (glong) -1);
#line 217 "common-actions.vala"
				_tmp13_ = _tmp12_;
#line 217 "common-actions.vala"
				_tmp14_ = g_build_filename (_tmp9_, _tmp13_, NULL, NULL);
#line 217 "common-actions.vala"
				_tmp15_ = _tmp14_;
#line 217 "common-actions.vala"
				_tmp16_ = g_file_new_for_path (_tmp15_);
#line 217 "common-actions.vala"
				_g_object_unref0 (f);
#line 217 "common-actions.vala"
				f = _tmp16_;
#line 217 "common-actions.vala"
				_g_free0 (_tmp15_);
#line 217 "common-actions.vala"
				_g_free0 (_tmp13_);
#line 2070 "common-actions.c"
			} else {
				const gchar* _tmp17_;
				const gchar* _tmp18_;
				GFile* _tmp19_;
#line 223 "common-actions.vala"
				_tmp17_ = synapse_match_get_title (match);
#line 223 "common-actions.vala"
				_tmp18_ = _tmp17_;
#line 223 "common-actions.vala"
				_tmp19_ = g_file_new_for_path (_tmp18_);
#line 223 "common-actions.vala"
				_g_object_unref0 (f);
#line 223 "common-actions.vala"
				f = _tmp19_;
#line 2085 "common-actions.c"
			}
#line 225 "common-actions.vala"
			_tmp20_ = f;
#line 225 "common-actions.vala"
			_tmp21_ = g_file_get_uri (_tmp20_);
#line 225 "common-actions.vala"
			_tmp22_ = _tmp21_;
#line 225 "common-actions.vala"
			synapse_utils_open_uri (_tmp22_);
#line 225 "common-actions.vala"
			_g_free0 (_tmp22_);
#line 212 "common-actions.vala"
			_g_object_unref0 (f);
#line 2099 "common-actions.c"
		} else {
			const gchar* _tmp23_;
			const gchar* _tmp24_;
#line 229 "common-actions.vala"
			_tmp23_ = synapse_match_get_title (match);
#line 229 "common-actions.vala"
			_tmp24_ = _tmp23_;
#line 229 "common-actions.vala"
			synapse_utils_open_uri (_tmp24_);
#line 2109 "common-actions.c"
		}
	}
}

static gboolean
synapse_common_actions_opener_real_valid_for_match (SynapseAction* base,
                                                    SynapseMatch* match)
{
	SynapseCommonActionsOpener * self;
	gboolean _tmp0_ = FALSE;
	gboolean result;
#line 233 "common-actions.vala"
	self = (SynapseCommonActionsOpener*) base;
#line 233 "common-actions.vala"
	g_return_val_if_fail (match != NULL, FALSE);
#line 235 "common-actions.vala"
	if (SYNAPSE_IS_URI_MATCH (match)) {
#line 235 "common-actions.vala"
		_tmp0_ = TRUE;
#line 2129 "common-actions.c"
	} else {
		gboolean _tmp1_ = FALSE;
#line 236 "common-actions.vala"
		if (SYNAPSE_IS_UNKNOWN_MATCH (match)) {
#line 2134 "common-actions.c"
			gboolean _tmp2_ = FALSE;
			GRegex* _tmp3_;
			const gchar* _tmp4_;
			const gchar* _tmp5_;
#line 236 "common-actions.vala"
			_tmp3_ = self->priv->web_uri;
#line 236 "common-actions.vala"
			_tmp4_ = synapse_match_get_title (match);
#line 236 "common-actions.vala"
			_tmp5_ = _tmp4_;
#line 236 "common-actions.vala"
			if (g_regex_match (_tmp3_, _tmp5_, 0, NULL)) {
#line 236 "common-actions.vala"
				_tmp2_ = TRUE;
#line 2149 "common-actions.c"
			} else {
				GRegex* _tmp6_;
				const gchar* _tmp7_;
				const gchar* _tmp8_;
#line 236 "common-actions.vala"
				_tmp6_ = self->priv->file_path;
#line 236 "common-actions.vala"
				_tmp7_ = synapse_match_get_title (match);
#line 236 "common-actions.vala"
				_tmp8_ = _tmp7_;
#line 236 "common-actions.vala"
				_tmp2_ = g_regex_match (_tmp6_, _tmp8_, 0, NULL);
#line 2162 "common-actions.c"
			}
#line 236 "common-actions.vala"
			_tmp1_ = _tmp2_;
#line 2166 "common-actions.c"
		} else {
#line 236 "common-actions.vala"
			_tmp1_ = FALSE;
#line 2170 "common-actions.c"
		}
#line 236 "common-actions.vala"
		_tmp0_ = _tmp1_;
#line 2174 "common-actions.c"
	}
#line 235 "common-actions.vala"
	result = _tmp0_;
#line 235 "common-actions.vala"
	return result;
#line 2180 "common-actions.c"
}

static GObject *
synapse_common_actions_opener_constructor (GType type,
                                           guint n_construct_properties,
                                           GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	SynapseCommonActionsOpener * self;
	GError* _inner_error0_ = NULL;
#line 242 "common-actions.vala"
	parent_class = G_OBJECT_CLASS (synapse_common_actions_opener_parent_class);
#line 242 "common-actions.vala"
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
#line 242 "common-actions.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SYNAPSE_COMMON_ACTIONS_TYPE_OPENER, SynapseCommonActionsOpener);
#line 2198 "common-actions.c"
	{
		GRegex* _tmp0_ = NULL;
		GRegex* _tmp1_;
		GRegex* _tmp2_;
		GRegex* _tmp3_ = NULL;
		GRegex* _tmp4_;
		GRegex* _tmp5_;
#line 246 "common-actions.vala"
		_tmp1_ = g_regex_new ("^(ftp|http(s)?)://[^.]+\\.[^.]+", G_REGEX_OPTIMIZE, 0, &_inner_error0_);
#line 246 "common-actions.vala"
		_tmp0_ = _tmp1_;
#line 246 "common-actions.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 2212 "common-actions.c"
			goto __catch0_g_error;
		}
#line 246 "common-actions.vala"
		_tmp2_ = _tmp0_;
#line 246 "common-actions.vala"
		_tmp0_ = NULL;
#line 246 "common-actions.vala"
		_g_regex_unref0 (self->priv->web_uri);
#line 246 "common-actions.vala"
		self->priv->web_uri = _tmp2_;
#line 247 "common-actions.vala"
		_tmp4_ = g_regex_new ("^(/|~/)[^/]+", G_REGEX_OPTIMIZE, 0, &_inner_error0_);
#line 247 "common-actions.vala"
		_tmp3_ = _tmp4_;
#line 247 "common-actions.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 247 "common-actions.vala"
			_g_regex_unref0 (_tmp0_);
#line 2231 "common-actions.c"
			goto __catch0_g_error;
		}
#line 247 "common-actions.vala"
		_tmp5_ = _tmp3_;
#line 247 "common-actions.vala"
		_tmp3_ = NULL;
#line 247 "common-actions.vala"
		_g_regex_unref0 (self->priv->file_path);
#line 247 "common-actions.vala"
		self->priv->file_path = _tmp5_;
#line 244 "common-actions.vala"
		_g_regex_unref0 (_tmp3_);
#line 244 "common-actions.vala"
		_g_regex_unref0 (_tmp0_);
#line 2246 "common-actions.c"
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* err = NULL;
		GError* _tmp6_;
		const gchar* _tmp7_;
#line 244 "common-actions.vala"
		err = _inner_error0_;
#line 244 "common-actions.vala"
		_inner_error0_ = NULL;
#line 251 "common-actions.vala"
		_tmp6_ = err;
#line 251 "common-actions.vala"
		_tmp7_ = _tmp6_->message;
#line 251 "common-actions.vala"
		g_warning ("common-actions.vala:251: %s", _tmp7_);
#line 244 "common-actions.vala"
		_g_error_free0 (err);
#line 2266 "common-actions.c"
	}
	__finally0:
#line 244 "common-actions.vala"
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 244 "common-actions.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 244 "common-actions.vala"
		g_clear_error (&_inner_error0_);
#line 2275 "common-actions.c"
	}
#line 242 "common-actions.vala"
	return obj;
#line 2279 "common-actions.c"
}

static void
synapse_common_actions_opener_class_init (SynapseCommonActionsOpenerClass * klass,
                                          gpointer klass_data)
{
#line 194 "common-actions.vala"
	synapse_common_actions_opener_parent_class = g_type_class_peek_parent (klass);
#line 194 "common-actions.vala"
	g_type_class_adjust_private_offset (klass, &SynapseCommonActionsOpener_private_offset);
#line 194 "common-actions.vala"
	((SynapseActionClass *) klass)->do_execute = (void (*) (SynapseAction*, SynapseMatch*, SynapseMatch*)) synapse_common_actions_opener_real_do_execute;
#line 194 "common-actions.vala"
	((SynapseActionClass *) klass)->valid_for_match = (gboolean (*) (SynapseAction*, SynapseMatch*)) synapse_common_actions_opener_real_valid_for_match;
#line 194 "common-actions.vala"
	G_OBJECT_CLASS (klass)->constructor = synapse_common_actions_opener_constructor;
#line 194 "common-actions.vala"
	G_OBJECT_CLASS (klass)->finalize = synapse_common_actions_opener_finalize;
#line 2298 "common-actions.c"
}

static void
synapse_common_actions_opener_instance_init (SynapseCommonActionsOpener * self,
                                             gpointer klass)
{
#line 194 "common-actions.vala"
	self->priv = synapse_common_actions_opener_get_instance_private (self);
#line 2307 "common-actions.c"
}

static void
synapse_common_actions_opener_finalize (GObject * obj)
{
	SynapseCommonActionsOpener * self;
#line 194 "common-actions.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SYNAPSE_COMMON_ACTIONS_TYPE_OPENER, SynapseCommonActionsOpener);
#line 239 "common-actions.vala"
	_g_regex_unref0 (self->priv->web_uri);
#line 240 "common-actions.vala"
	_g_regex_unref0 (self->priv->file_path);
#line 194 "common-actions.vala"
	G_OBJECT_CLASS (synapse_common_actions_opener_parent_class)->finalize (obj);
#line 2322 "common-actions.c"
}

static GType
synapse_common_actions_opener_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SynapseCommonActionsOpenerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) synapse_common_actions_opener_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SynapseCommonActionsOpener), 0, (GInstanceInitFunc) synapse_common_actions_opener_instance_init, NULL };
	GType synapse_common_actions_opener_type_id;
	synapse_common_actions_opener_type_id = g_type_register_static (SYNAPSE_TYPE_ACTION, "SynapseCommonActionsOpener", &g_define_type_info, 0);
	SynapseCommonActionsOpener_private_offset = g_type_add_instance_private (synapse_common_actions_opener_type_id, sizeof (SynapseCommonActionsOpenerPrivate));
	return synapse_common_actions_opener_type_id;
}

static GType
synapse_common_actions_opener_get_type (void)
{
	static volatile gsize synapse_common_actions_opener_type_id__once = 0;
	if (g_once_init_enter (&synapse_common_actions_opener_type_id__once)) {
		GType synapse_common_actions_opener_type_id;
		synapse_common_actions_opener_type_id = synapse_common_actions_opener_get_type_once ();
		g_once_init_leave (&synapse_common_actions_opener_type_id__once, synapse_common_actions_opener_type_id);
	}
	return synapse_common_actions_opener_type_id__once;
}

static SynapseCommonActionsOpenFolder*
synapse_common_actions_open_folder_construct (GType object_type)
{
	SynapseCommonActionsOpenFolder * self = NULL;
#line 260 "common-actions.vala"
	self = (SynapseCommonActionsOpenFolder*) g_object_new (object_type, "title", _ ("Open folder"), "description", _ ("Open folder containing this file"), "icon-name", "folder-open", "has-thumbnail", FALSE, "default-relevancy", SYNAPSE_MATCH_SCORE_AVERAGE, NULL);
#line 258 "common-actions.vala"
	return self;
#line 2355 "common-actions.c"
}

static SynapseCommonActionsOpenFolder*
synapse_common_actions_open_folder_new (void)
{
#line 258 "common-actions.vala"
	return synapse_common_actions_open_folder_construct (SYNAPSE_COMMON_ACTIONS_TYPE_OPEN_FOLDER);
#line 2363 "common-actions.c"
}

static void
_g_object_unref0_ (gpointer var)
{
#line 278 "common-actions.vala"
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
#line 2371 "common-actions.c"
}

static inline void
_g_list_free__g_object_unref0_ (GList* self)
{
#line 278 "common-actions.vala"
	g_list_free_full (self, (GDestroyNotify) _g_object_unref0_);
#line 2379 "common-actions.c"
}

static void
synapse_common_actions_open_folder_real_do_execute (SynapseAction* base,
                                                    SynapseMatch* match,
                                                    SynapseMatch* target)
{
	SynapseCommonActionsOpenFolder * self;
	SynapseUriMatch* uri_match = NULL;
	SynapseUriMatch* _tmp0_;
	GFile* f = NULL;
	SynapseUriMatch* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	GFile* _tmp4_;
	GFile* _tmp5_;
	GFile* _tmp6_;
	GError* _inner_error0_ = NULL;
#line 266 "common-actions.vala"
	self = (SynapseCommonActionsOpenFolder*) base;
#line 266 "common-actions.vala"
	g_return_if_fail (match != NULL);
#line 268 "common-actions.vala"
	uri_match = SYNAPSE_IS_URI_MATCH (match) ? ((SynapseUriMatch*) match) : NULL;
#line 269 "common-actions.vala"
	_tmp0_ = uri_match;
#line 269 "common-actions.vala"
	g_return_if_fail (_tmp0_ != NULL);
#line 271 "common-actions.vala"
	_tmp1_ = uri_match;
#line 271 "common-actions.vala"
	_tmp2_ = synapse_uri_match_get_uri (_tmp1_);
#line 271 "common-actions.vala"
	_tmp3_ = _tmp2_;
#line 271 "common-actions.vala"
	_tmp4_ = g_file_new_for_uri (_tmp3_);
#line 271 "common-actions.vala"
	f = _tmp4_;
#line 272 "common-actions.vala"
	_tmp5_ = f;
#line 272 "common-actions.vala"
	_tmp6_ = g_file_get_parent (_tmp5_);
#line 272 "common-actions.vala"
	_g_object_unref0 (f);
#line 272 "common-actions.vala"
	f = _tmp6_;
#line 2426 "common-actions.c"
	{
		GAppInfo* app_info = NULL;
		GFile* _tmp7_;
		GAppInfo* _tmp8_;
		GList* files = NULL;
		GFile* _tmp9_;
		GFile* _tmp10_;
		GAppInfo* _tmp11_;
		GList* _tmp12_;
		GdkDisplay* _tmp13_;
		GdkAppLaunchContext* _tmp14_;
		GdkAppLaunchContext* _tmp15_;
#line 275 "common-actions.vala"
		_tmp7_ = f;
#line 275 "common-actions.vala"
		_tmp8_ = g_file_query_default_handler (_tmp7_, NULL, &_inner_error0_);
#line 275 "common-actions.vala"
		app_info = _tmp8_;
#line 275 "common-actions.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 2447 "common-actions.c"
			goto __catch0_g_error;
		}
#line 276 "common-actions.vala"
		files = NULL;
#line 277 "common-actions.vala"
		_tmp9_ = f;
#line 277 "common-actions.vala"
		_tmp10_ = _g_object_ref0 (_tmp9_);
#line 277 "common-actions.vala"
		files = g_list_prepend (files, _tmp10_);
#line 278 "common-actions.vala"
		_tmp11_ = app_info;
#line 278 "common-actions.vala"
		_tmp12_ = files;
#line 278 "common-actions.vala"
		_tmp13_ = gdk_display_get_default ();
#line 278 "common-actions.vala"
		_tmp14_ = gdk_display_get_app_launch_context (_tmp13_);
#line 278 "common-actions.vala"
		_tmp15_ = _tmp14_;
#line 278 "common-actions.vala"
		g_app_info_launch (_tmp11_, _tmp12_, (GAppLaunchContext*) _tmp15_, &_inner_error0_);
#line 278 "common-actions.vala"
		_g_object_unref0 (_tmp15_);
#line 278 "common-actions.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 278 "common-actions.vala"
			(files == NULL) ? NULL : (files = (_g_list_free__g_object_unref0_ (files), NULL));
#line 278 "common-actions.vala"
			_g_object_unref0 (app_info);
#line 2478 "common-actions.c"
			goto __catch0_g_error;
		}
#line 273 "common-actions.vala"
		(files == NULL) ? NULL : (files = (_g_list_free__g_object_unref0_ (files), NULL));
#line 273 "common-actions.vala"
		_g_object_unref0 (app_info);
#line 2485 "common-actions.c"
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* err = NULL;
		GError* _tmp16_;
		const gchar* _tmp17_;
#line 273 "common-actions.vala"
		err = _inner_error0_;
#line 273 "common-actions.vala"
		_inner_error0_ = NULL;
#line 282 "common-actions.vala"
		_tmp16_ = err;
#line 282 "common-actions.vala"
		_tmp17_ = _tmp16_->message;
#line 282 "common-actions.vala"
		g_warning ("common-actions.vala:282: %s", _tmp17_);
#line 273 "common-actions.vala"
		_g_error_free0 (err);
#line 2505 "common-actions.c"
	}
	__finally0:
#line 273 "common-actions.vala"
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 273 "common-actions.vala"
		_g_object_unref0 (f);
#line 273 "common-actions.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 273 "common-actions.vala"
		g_clear_error (&_inner_error0_);
#line 273 "common-actions.vala"
		return;
#line 2518 "common-actions.c"
	}
#line 266 "common-actions.vala"
	_g_object_unref0 (f);
#line 2522 "common-actions.c"
}

static gboolean
synapse_common_actions_open_folder_real_valid_for_match (SynapseAction* base,
                                                         SynapseMatch* match)
{
	SynapseCommonActionsOpenFolder * self;
	SynapseUriMatch* uri_match = NULL;
	SynapseUriMatch* _tmp0_;
	GFile* f = NULL;
	SynapseUriMatch* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	GFile* _tmp4_;
	GFile* parent = NULL;
	GFile* _tmp5_;
	GFile* _tmp6_;
	gboolean _tmp7_ = FALSE;
	GFile* _tmp8_;
	gboolean result;
#line 286 "common-actions.vala"
	self = (SynapseCommonActionsOpenFolder*) base;
#line 286 "common-actions.vala"
	g_return_val_if_fail (match != NULL, FALSE);
#line 288 "common-actions.vala"
	uri_match = SYNAPSE_IS_URI_MATCH (match) ? ((SynapseUriMatch*) match) : NULL;
#line 289 "common-actions.vala"
	_tmp0_ = uri_match;
#line 289 "common-actions.vala"
	if (_tmp0_ == NULL) {
#line 289 "common-actions.vala"
		result = FALSE;
#line 289 "common-actions.vala"
		return result;
#line 2557 "common-actions.c"
	}
#line 291 "common-actions.vala"
	_tmp1_ = uri_match;
#line 291 "common-actions.vala"
	_tmp2_ = synapse_uri_match_get_uri (_tmp1_);
#line 291 "common-actions.vala"
	_tmp3_ = _tmp2_;
#line 291 "common-actions.vala"
	_tmp4_ = g_file_new_for_uri (_tmp3_);
#line 291 "common-actions.vala"
	f = _tmp4_;
#line 292 "common-actions.vala"
	_tmp5_ = f;
#line 292 "common-actions.vala"
	_tmp6_ = g_file_get_parent (_tmp5_);
#line 292 "common-actions.vala"
	parent = _tmp6_;
#line 293 "common-actions.vala"
	_tmp8_ = parent;
#line 293 "common-actions.vala"
	if (_tmp8_ != NULL) {
#line 2579 "common-actions.c"
		GFile* _tmp9_;
#line 293 "common-actions.vala"
		_tmp9_ = f;
#line 293 "common-actions.vala"
		_tmp7_ = g_file_is_native (_tmp9_);
#line 2585 "common-actions.c"
	} else {
#line 293 "common-actions.vala"
		_tmp7_ = FALSE;
#line 2589 "common-actions.c"
	}
#line 293 "common-actions.vala"
	result = _tmp7_;
#line 293 "common-actions.vala"
	_g_object_unref0 (parent);
#line 293 "common-actions.vala"
	_g_object_unref0 (f);
#line 293 "common-actions.vala"
	return result;
#line 2599 "common-actions.c"
}

static void
synapse_common_actions_open_folder_class_init (SynapseCommonActionsOpenFolderClass * klass,
                                               gpointer klass_data)
{
#line 256 "common-actions.vala"
	synapse_common_actions_open_folder_parent_class = g_type_class_peek_parent (klass);
#line 256 "common-actions.vala"
	((SynapseActionClass *) klass)->do_execute = (void (*) (SynapseAction*, SynapseMatch*, SynapseMatch*)) synapse_common_actions_open_folder_real_do_execute;
#line 256 "common-actions.vala"
	((SynapseActionClass *) klass)->valid_for_match = (gboolean (*) (SynapseAction*, SynapseMatch*)) synapse_common_actions_open_folder_real_valid_for_match;
#line 2612 "common-actions.c"
}

static void
synapse_common_actions_open_folder_instance_init (SynapseCommonActionsOpenFolder * self,
                                                  gpointer klass)
{
}

static GType
synapse_common_actions_open_folder_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SynapseCommonActionsOpenFolderClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) synapse_common_actions_open_folder_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SynapseCommonActionsOpenFolder), 0, (GInstanceInitFunc) synapse_common_actions_open_folder_instance_init, NULL };
	GType synapse_common_actions_open_folder_type_id;
	synapse_common_actions_open_folder_type_id = g_type_register_static (SYNAPSE_TYPE_ACTION, "SynapseCommonActionsOpenFolder", &g_define_type_info, 0);
	return synapse_common_actions_open_folder_type_id;
}

static GType
synapse_common_actions_open_folder_get_type (void)
{
	static volatile gsize synapse_common_actions_open_folder_type_id__once = 0;
	if (g_once_init_enter (&synapse_common_actions_open_folder_type_id__once)) {
		GType synapse_common_actions_open_folder_type_id;
		synapse_common_actions_open_folder_type_id = synapse_common_actions_open_folder_get_type_once ();
		g_once_init_leave (&synapse_common_actions_open_folder_type_id__once, synapse_common_actions_open_folder_type_id);
	}
	return synapse_common_actions_open_folder_type_id__once;
}

static SynapseCommonActionsClipboardCopy*
synapse_common_actions_clipboard_copy_construct (GType object_type)
{
	SynapseCommonActionsClipboardCopy * self = NULL;
#line 301 "common-actions.vala"
	self = (SynapseCommonActionsClipboardCopy*) g_object_new (object_type, "title", _ ("Copy to Clipboard"), "description", _ ("Copy selection to clipboard"), "icon-name", "gtk-copy", "has-thumbnail", FALSE, "default-relevancy", SYNAPSE_MATCH_SCORE_AVERAGE, NULL);
#line 299 "common-actions.vala"
	return self;
#line 2650 "common-actions.c"
}

static SynapseCommonActionsClipboardCopy*
synapse_common_actions_clipboard_copy_new (void)
{
#line 299 "common-actions.vala"
	return synapse_common_actions_clipboard_copy_construct (SYNAPSE_COMMON_ACTIONS_TYPE_CLIPBOARD_COPY);
#line 2658 "common-actions.c"
}

static void
synapse_common_actions_clipboard_copy_real_do_execute (SynapseAction* base,
                                                       SynapseMatch* match,
                                                       SynapseMatch* target)
{
	SynapseCommonActionsClipboardCopy * self;
	GtkClipboard* cb = NULL;
	GtkClipboard* _tmp0_;
	GtkClipboard* _tmp1_;
#line 307 "common-actions.vala"
	self = (SynapseCommonActionsClipboardCopy*) base;
#line 307 "common-actions.vala"
	g_return_if_fail (match != NULL);
#line 309 "common-actions.vala"
	_tmp0_ = gtk_clipboard_get (GDK_NONE);
#line 309 "common-actions.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 309 "common-actions.vala"
	cb = _tmp1_;
#line 310 "common-actions.vala"
	if (SYNAPSE_IS_URI_MATCH (match)) {
#line 2682 "common-actions.c"
		SynapseUriMatch* uri_match = NULL;
		GtkClipboard* _tmp2_;
		SynapseUriMatch* _tmp3_;
		const gchar* _tmp4_;
		const gchar* _tmp5_;
#line 312 "common-actions.vala"
		uri_match = G_TYPE_CHECK_INSTANCE_CAST (match, SYNAPSE_TYPE_URI_MATCH, SynapseUriMatch);
#line 323 "common-actions.vala"
		_tmp2_ = cb;
#line 323 "common-actions.vala"
		_tmp3_ = uri_match;
#line 323 "common-actions.vala"
		_tmp4_ = synapse_uri_match_get_uri (_tmp3_);
#line 323 "common-actions.vala"
		_tmp5_ = _tmp4_;
#line 323 "common-actions.vala"
		gtk_clipboard_set_text (_tmp2_, _tmp5_, -1);
#line 2700 "common-actions.c"
	} else {
#line 325 "common-actions.vala"
		if (SYNAPSE_IS_TEXT_MATCH (match)) {
#line 2704 "common-actions.c"
			SynapseTextMatch* text_match = NULL;
			gchar* _tmp6_ = NULL;
			SynapseTextMatch* _tmp7_;
			gchar* content = NULL;
			gchar* _tmp13_;
			GtkClipboard* _tmp14_;
			const gchar* _tmp15_;
#line 327 "common-actions.vala"
			text_match = G_TYPE_CHECK_INSTANCE_CAST (match, SYNAPSE_TYPE_TEXT_MATCH, SynapseTextMatch);
#line 329 "common-actions.vala"
			_tmp7_ = text_match;
#line 329 "common-actions.vala"
			if (_tmp7_ != NULL) {
#line 2718 "common-actions.c"
				SynapseTextMatch* _tmp8_;
				gchar* _tmp9_;
#line 329 "common-actions.vala"
				_tmp8_ = text_match;
#line 329 "common-actions.vala"
				_tmp9_ = synapse_text_match_get_text (_tmp8_);
#line 329 "common-actions.vala"
				_g_free0 (_tmp6_);
#line 329 "common-actions.vala"
				_tmp6_ = _tmp9_;
#line 2729 "common-actions.c"
			} else {
				const gchar* _tmp10_;
				const gchar* _tmp11_;
				gchar* _tmp12_;
#line 329 "common-actions.vala"
				_tmp10_ = synapse_match_get_title (match);
#line 329 "common-actions.vala"
				_tmp11_ = _tmp10_;
#line 329 "common-actions.vala"
				_tmp12_ = g_strdup (_tmp11_);
#line 329 "common-actions.vala"
				_g_free0 (_tmp6_);
#line 329 "common-actions.vala"
				_tmp6_ = _tmp12_;
#line 2744 "common-actions.c"
			}
#line 329 "common-actions.vala"
			_tmp13_ = g_strdup (_tmp6_);
#line 329 "common-actions.vala"
			content = _tmp13_;
#line 331 "common-actions.vala"
			_tmp14_ = cb;
#line 331 "common-actions.vala"
			_tmp15_ = content;
#line 331 "common-actions.vala"
			gtk_clipboard_set_text (_tmp14_, _tmp15_, -1);
#line 325 "common-actions.vala"
			_g_free0 (content);
#line 325 "common-actions.vala"
			_g_free0 (_tmp6_);
#line 2760 "common-actions.c"
		}
	}
#line 307 "common-actions.vala"
	_g_object_unref0 (cb);
#line 2765 "common-actions.c"
}

static gboolean
synapse_common_actions_clipboard_copy_real_valid_for_match (SynapseAction* base,
                                                            SynapseMatch* match)
{
	SynapseCommonActionsClipboardCopy * self;
	gboolean _tmp0_ = FALSE;
	gboolean result;
#line 335 "common-actions.vala"
	self = (SynapseCommonActionsClipboardCopy*) base;
#line 335 "common-actions.vala"
	g_return_val_if_fail (match != NULL, FALSE);
#line 337 "common-actions.vala"
	if (SYNAPSE_IS_URI_MATCH (match)) {
#line 337 "common-actions.vala"
		_tmp0_ = TRUE;
#line 2783 "common-actions.c"
	} else {
#line 337 "common-actions.vala"
		_tmp0_ = SYNAPSE_IS_TEXT_MATCH (match);
#line 2787 "common-actions.c"
	}
#line 337 "common-actions.vala"
	result = _tmp0_;
#line 337 "common-actions.vala"
	return result;
#line 2793 "common-actions.c"
}

static gint
synapse_common_actions_clipboard_copy_real_get_relevancy_for_match (SynapseAction* base,
                                                                    SynapseMatch* match)
{
	SynapseCommonActionsClipboardCopy * self;
	SynapseTextMatch* text_match = NULL;
	gboolean _tmp0_ = FALSE;
	SynapseTextMatch* _tmp1_;
	gint _tmp5_;
	gint _tmp6_;
	gint result;
#line 340 "common-actions.vala"
	self = (SynapseCommonActionsClipboardCopy*) base;
#line 340 "common-actions.vala"
	g_return_val_if_fail (match != NULL, 0);
#line 342 "common-actions.vala"
	text_match = SYNAPSE_IS_TEXT_MATCH (match) ? ((SynapseTextMatch*) match) : NULL;
#line 343 "common-actions.vala"
	_tmp1_ = text_match;
#line 343 "common-actions.vala"
	if (_tmp1_ != NULL) {
#line 2817 "common-actions.c"
		SynapseTextMatch* _tmp2_;
		SynapseTextOrigin _tmp3_;
		SynapseTextOrigin _tmp4_;
#line 343 "common-actions.vala"
		_tmp2_ = text_match;
#line 343 "common-actions.vala"
		_tmp3_ = synapse_text_match_get_text_origin (_tmp2_);
#line 343 "common-actions.vala"
		_tmp4_ = _tmp3_;
#line 343 "common-actions.vala"
		_tmp0_ = _tmp4_ == SYNAPSE_TEXT_ORIGIN_CLIPBOARD;
#line 2829 "common-actions.c"
	} else {
#line 343 "common-actions.vala"
		_tmp0_ = FALSE;
#line 2833 "common-actions.c"
	}
#line 343 "common-actions.vala"
	if (_tmp0_) {
#line 345 "common-actions.vala"
		result = 0;
#line 345 "common-actions.vala"
		return result;
#line 2841 "common-actions.c"
	}
#line 348 "common-actions.vala"
	_tmp5_ = synapse_action_get_default_relevancy ((SynapseAction*) self);
#line 348 "common-actions.vala"
	_tmp6_ = _tmp5_;
#line 348 "common-actions.vala"
	result = _tmp6_;
#line 348 "common-actions.vala"
	return result;
#line 2851 "common-actions.c"
}

static void
synapse_common_actions_clipboard_copy_class_init (SynapseCommonActionsClipboardCopyClass * klass,
                                                  gpointer klass_data)
{
#line 297 "common-actions.vala"
	synapse_common_actions_clipboard_copy_parent_class = g_type_class_peek_parent (klass);
#line 297 "common-actions.vala"
	((SynapseActionClass *) klass)->do_execute = (void (*) (SynapseAction*, SynapseMatch*, SynapseMatch*)) synapse_common_actions_clipboard_copy_real_do_execute;
#line 297 "common-actions.vala"
	((SynapseActionClass *) klass)->valid_for_match = (gboolean (*) (SynapseAction*, SynapseMatch*)) synapse_common_actions_clipboard_copy_real_valid_for_match;
#line 297 "common-actions.vala"
	((SynapseActionClass *) klass)->get_relevancy_for_match = (gint (*) (SynapseAction*, SynapseMatch*)) synapse_common_actions_clipboard_copy_real_get_relevancy_for_match;
#line 2866 "common-actions.c"
}

static void
synapse_common_actions_clipboard_copy_instance_init (SynapseCommonActionsClipboardCopy * self,
                                                     gpointer klass)
{
}

static GType
synapse_common_actions_clipboard_copy_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SynapseCommonActionsClipboardCopyClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) synapse_common_actions_clipboard_copy_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SynapseCommonActionsClipboardCopy), 0, (GInstanceInitFunc) synapse_common_actions_clipboard_copy_instance_init, NULL };
	GType synapse_common_actions_clipboard_copy_type_id;
	synapse_common_actions_clipboard_copy_type_id = g_type_register_static (SYNAPSE_TYPE_ACTION, "SynapseCommonActionsClipboardCopy", &g_define_type_info, 0);
	return synapse_common_actions_clipboard_copy_type_id;
}

static GType
synapse_common_actions_clipboard_copy_get_type (void)
{
	static volatile gsize synapse_common_actions_clipboard_copy_type_id__once = 0;
	if (g_once_init_enter (&synapse_common_actions_clipboard_copy_type_id__once)) {
		GType synapse_common_actions_clipboard_copy_type_id;
		synapse_common_actions_clipboard_copy_type_id = synapse_common_actions_clipboard_copy_get_type_once ();
		g_once_init_leave (&synapse_common_actions_clipboard_copy_type_id__once, synapse_common_actions_clipboard_copy_type_id);
	}
	return synapse_common_actions_clipboard_copy_type_id__once;
}

static GObject *
synapse_common_actions_constructor (GType type,
                                    guint n_construct_properties,
                                    GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	SynapseCommonActions * self;
	GeeArrayList* _tmp0_;
	GeeList* _tmp1_;
	SynapseCommonActionsRunner* _tmp2_;
	SynapseCommonActionsRunner* _tmp3_;
	GeeList* _tmp4_;
	SynapseCommonActionsTerminalRunner* _tmp5_;
	SynapseCommonActionsTerminalRunner* _tmp6_;
	GeeList* _tmp7_;
	SynapseCommonActionsOpener* _tmp8_;
	SynapseCommonActionsOpener* _tmp9_;
	GeeList* _tmp10_;
	SynapseCommonActionsOpenFolder* _tmp11_;
	SynapseCommonActionsOpenFolder* _tmp12_;
	GeeList* _tmp13_;
	SynapseCommonActionsClipboardCopy* _tmp14_;
	SynapseCommonActionsClipboardCopy* _tmp15_;
#line 354 "common-actions.vala"
	parent_class = G_OBJECT_CLASS (synapse_common_actions_parent_class);
#line 354 "common-actions.vala"
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
#line 354 "common-actions.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SYNAPSE_TYPE_COMMON_ACTIONS, SynapseCommonActions);
#line 356 "common-actions.vala"
	_tmp0_ = gee_array_list_new (SYNAPSE_TYPE_ACTION, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
#line 356 "common-actions.vala"
	_g_object_unref0 (self->priv->actions);
#line 356 "common-actions.vala"
	self->priv->actions = (GeeList*) _tmp0_;
#line 358 "common-actions.vala"
	_tmp1_ = self->priv->actions;
#line 358 "common-actions.vala"
	_tmp2_ = synapse_common_actions_runner_new ();
#line 358 "common-actions.vala"
	_tmp3_ = _tmp2_;
#line 358 "common-actions.vala"
	gee_collection_add ((GeeCollection*) _tmp1_, (SynapseAction*) _tmp3_);
#line 358 "common-actions.vala"
	_g_object_unref0 (_tmp3_);
#line 359 "common-actions.vala"
	_tmp4_ = self->priv->actions;
#line 359 "common-actions.vala"
	_tmp5_ = synapse_common_actions_terminal_runner_new ();
#line 359 "common-actions.vala"
	_tmp6_ = _tmp5_;
#line 359 "common-actions.vala"
	gee_collection_add ((GeeCollection*) _tmp4_, (SynapseAction*) _tmp6_);
#line 359 "common-actions.vala"
	_g_object_unref0 (_tmp6_);
#line 360 "common-actions.vala"
	_tmp7_ = self->priv->actions;
#line 360 "common-actions.vala"
	_tmp8_ = synapse_common_actions_opener_new ();
#line 360 "common-actions.vala"
	_tmp9_ = _tmp8_;
#line 360 "common-actions.vala"
	gee_collection_add ((GeeCollection*) _tmp7_, (SynapseAction*) _tmp9_);
#line 360 "common-actions.vala"
	_g_object_unref0 (_tmp9_);
#line 361 "common-actions.vala"
	_tmp10_ = self->priv->actions;
#line 361 "common-actions.vala"
	_tmp11_ = synapse_common_actions_open_folder_new ();
#line 361 "common-actions.vala"
	_tmp12_ = _tmp11_;
#line 361 "common-actions.vala"
	gee_collection_add ((GeeCollection*) _tmp10_, (SynapseAction*) _tmp12_);
#line 361 "common-actions.vala"
	_g_object_unref0 (_tmp12_);
#line 362 "common-actions.vala"
	_tmp13_ = self->priv->actions;
#line 362 "common-actions.vala"
	_tmp14_ = synapse_common_actions_clipboard_copy_new ();
#line 362 "common-actions.vala"
	_tmp15_ = _tmp14_;
#line 362 "common-actions.vala"
	gee_collection_add ((GeeCollection*) _tmp13_, (SynapseAction*) _tmp15_);
#line 362 "common-actions.vala"
	_g_object_unref0 (_tmp15_);
#line 354 "common-actions.vala"
	return obj;
#line 2984 "common-actions.c"
}

static void
synapse_common_actions_class_init (SynapseCommonActionsClass * klass,
                                   gpointer klass_data)
{
#line 44 "common-actions.vala"
	synapse_common_actions_parent_class = g_type_class_peek_parent (klass);
#line 44 "common-actions.vala"
	g_type_class_adjust_private_offset (klass, &SynapseCommonActions_private_offset);
#line 44 "common-actions.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_synapse_common_actions_get_property;
#line 44 "common-actions.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_synapse_common_actions_set_property;
#line 44 "common-actions.vala"
	G_OBJECT_CLASS (klass)->constructor = synapse_common_actions_constructor;
#line 44 "common-actions.vala"
	G_OBJECT_CLASS (klass)->finalize = synapse_common_actions_finalize;
#line 44 "common-actions.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_COMMON_ACTIONS_ENABLED_PROPERTY, synapse_common_actions_properties[SYNAPSE_COMMON_ACTIONS_ENABLED_PROPERTY] = g_param_spec_boolean ("enabled", "enabled", "enabled", TRUE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 3005 "common-actions.c"
}

static void
synapse_common_actions_synapse_activatable_interface_init (SynapseActivatableIface * iface,
                                                           gpointer iface_data)
{
#line 44 "common-actions.vala"
	synapse_common_actions_synapse_activatable_parent_iface = g_type_interface_peek_parent (iface);
#line 44 "common-actions.vala"
	iface->activate = (void (*) (SynapseActivatable*)) synapse_common_actions_real_activate;
#line 44 "common-actions.vala"
	iface->deactivate = (void (*) (SynapseActivatable*)) synapse_common_actions_real_deactivate;
#line 44 "common-actions.vala"
	iface->get_enabled = synapse_common_actions_real_get_enabled;
#line 44 "common-actions.vala"
	iface->set_enabled = synapse_common_actions_real_set_enabled;
#line 3022 "common-actions.c"
}

static void
synapse_common_actions_synapse_action_provider_interface_init (SynapseActionProviderIface * iface,
                                                               gpointer iface_data)
{
#line 44 "common-actions.vala"
	synapse_common_actions_synapse_action_provider_parent_iface = g_type_interface_peek_parent (iface);
#line 44 "common-actions.vala"
	iface->find_for_match = (SynapseResultSet* (*) (SynapseActionProvider*, SynapseQuery*, SynapseMatch*)) synapse_common_actions_real_find_for_match;
#line 3033 "common-actions.c"
}

static void
synapse_common_actions_instance_init (SynapseCommonActions * self,
                                      gpointer klass)
{
#line 44 "common-actions.vala"
	self->priv = synapse_common_actions_get_instance_private (self);
#line 46 "common-actions.vala"
	self->priv->_enabled = TRUE;
#line 3044 "common-actions.c"
}

static void
synapse_common_actions_finalize (GObject * obj)
{
	SynapseCommonActions * self;
#line 44 "common-actions.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SYNAPSE_TYPE_COMMON_ACTIONS, SynapseCommonActions);
#line 352 "common-actions.vala"
	_g_object_unref0 (self->priv->actions);
#line 44 "common-actions.vala"
	G_OBJECT_CLASS (synapse_common_actions_parent_class)->finalize (obj);
#line 3057 "common-actions.c"
}

static GType
synapse_common_actions_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SynapseCommonActionsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) synapse_common_actions_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SynapseCommonActions), 0, (GInstanceInitFunc) synapse_common_actions_instance_init, NULL };
	static const GInterfaceInfo synapse_activatable_info = { (GInterfaceInitFunc) synapse_common_actions_synapse_activatable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	static const GInterfaceInfo synapse_action_provider_info = { (GInterfaceInitFunc) synapse_common_actions_synapse_action_provider_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType synapse_common_actions_type_id;
	synapse_common_actions_type_id = g_type_register_static (G_TYPE_OBJECT, "SynapseCommonActions", &g_define_type_info, 0);
	g_type_add_interface_static (synapse_common_actions_type_id, SYNAPSE_TYPE_ACTIVATABLE, &synapse_activatable_info);
	g_type_add_interface_static (synapse_common_actions_type_id, SYNAPSE_TYPE_ACTION_PROVIDER, &synapse_action_provider_info);
	SynapseCommonActions_private_offset = g_type_add_instance_private (synapse_common_actions_type_id, sizeof (SynapseCommonActionsPrivate));
	return synapse_common_actions_type_id;
}

GType
synapse_common_actions_get_type (void)
{
	static volatile gsize synapse_common_actions_type_id__once = 0;
	if (g_once_init_enter (&synapse_common_actions_type_id__once)) {
		GType synapse_common_actions_type_id;
		synapse_common_actions_type_id = synapse_common_actions_get_type_once ();
		g_once_init_leave (&synapse_common_actions_type_id__once, synapse_common_actions_type_id);
	}
	return synapse_common_actions_type_id__once;
}

static void
_vala_synapse_common_actions_get_property (GObject * object,
                                           guint property_id,
                                           GValue * value,
                                           GParamSpec * pspec)
{
	SynapseCommonActions * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SYNAPSE_TYPE_COMMON_ACTIONS, SynapseCommonActions);
#line 44 "common-actions.vala"
	switch (property_id) {
#line 44 "common-actions.vala"
		case SYNAPSE_COMMON_ACTIONS_ENABLED_PROPERTY:
#line 44 "common-actions.vala"
		g_value_set_boolean (value, synapse_activatable_get_enabled ((SynapseActivatable*) self));
#line 44 "common-actions.vala"
		break;
#line 3102 "common-actions.c"
		default:
#line 44 "common-actions.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 44 "common-actions.vala"
		break;
#line 3108 "common-actions.c"
	}
}

static void
_vala_synapse_common_actions_set_property (GObject * object,
                                           guint property_id,
                                           const GValue * value,
                                           GParamSpec * pspec)
{
	SynapseCommonActions * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SYNAPSE_TYPE_COMMON_ACTIONS, SynapseCommonActions);
#line 44 "common-actions.vala"
	switch (property_id) {
#line 44 "common-actions.vala"
		case SYNAPSE_COMMON_ACTIONS_ENABLED_PROPERTY:
#line 44 "common-actions.vala"
		synapse_activatable_set_enabled ((SynapseActivatable*) self, g_value_get_boolean (value));
#line 44 "common-actions.vala"
		break;
#line 3128 "common-actions.c"
		default:
#line 44 "common-actions.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 44 "common-actions.vala"
		break;
#line 3134 "common-actions.c"
	}
}

