/* chromium-plugin.c generated by valac 0.56.17, the Vala compiler
 * generated from chromium-plugin.vala, do not modify */

/*
 * Copyright (C) 2013 Jan Hrdina <jan.hrdka@gmail.com>
 *
 * This program is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include "plugins.h"
#include <glib.h>
#include <synapse-core.h>
#include <glib-object.h>
#include <gee.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>
#include <gio/gio.h>
#include <json-glib/json-glib.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define SYNAPSE_CHROMIUM_PLUGIN_TYPE_BOOKMARK_MATCH (synapse_chromium_plugin_bookmark_match_get_type ())
#define SYNAPSE_CHROMIUM_PLUGIN_BOOKMARK_MATCH(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_CHROMIUM_PLUGIN_TYPE_BOOKMARK_MATCH, SynapseChromiumPluginBookmarkMatch))
#define SYNAPSE_CHROMIUM_PLUGIN_BOOKMARK_MATCH_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SYNAPSE_CHROMIUM_PLUGIN_TYPE_BOOKMARK_MATCH, SynapseChromiumPluginBookmarkMatchClass))
#define SYNAPSE_CHROMIUM_PLUGIN_IS_BOOKMARK_MATCH(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_CHROMIUM_PLUGIN_TYPE_BOOKMARK_MATCH))
#define SYNAPSE_CHROMIUM_PLUGIN_IS_BOOKMARK_MATCH_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SYNAPSE_CHROMIUM_PLUGIN_TYPE_BOOKMARK_MATCH))
#define SYNAPSE_CHROMIUM_PLUGIN_BOOKMARK_MATCH_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SYNAPSE_CHROMIUM_PLUGIN_TYPE_BOOKMARK_MATCH, SynapseChromiumPluginBookmarkMatchClass))

typedef struct _SynapseChromiumPluginBookmarkMatch SynapseChromiumPluginBookmarkMatch;
typedef struct _SynapseChromiumPluginBookmarkMatchClass SynapseChromiumPluginBookmarkMatchClass;
enum  {
	SYNAPSE_CHROMIUM_PLUGIN_0_PROPERTY,
	SYNAPSE_CHROMIUM_PLUGIN_ENABLED_PROPERTY,
	SYNAPSE_CHROMIUM_PLUGIN_NUM_PROPERTIES
};
static GParamSpec* synapse_chromium_plugin_properties[SYNAPSE_CHROMIUM_PLUGIN_NUM_PROPERTIES];
#define _synapse_utils_async_once_unref0(var) ((var == NULL) ? NULL : (var = (synapse_utils_async_once_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _SynapseChromiumPluginSearchData SynapseChromiumPluginSearchData;
#define _json_object_unref0(var) ((var == NULL) ? NULL : (var = (json_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _SynapseChromiumPluginParseBookmarksData SynapseChromiumPluginParseBookmarksData;
typedef struct _SynapseChromiumPluginBookmarkMatchPrivate SynapseChromiumPluginBookmarkMatchPrivate;
enum  {
	SYNAPSE_CHROMIUM_PLUGIN_BOOKMARK_MATCH_0_PROPERTY,
	SYNAPSE_CHROMIUM_PLUGIN_BOOKMARK_MATCH_NUM_PROPERTIES
};
static GParamSpec* synapse_chromium_plugin_bookmark_match_properties[SYNAPSE_CHROMIUM_PLUGIN_BOOKMARK_MATCH_NUM_PROPERTIES];

struct _SynapseChromiumPluginPrivate {
	gboolean _enabled;
	SynapseUtilsAsyncOnce* bookmarks_once;
};

struct _SynapseChromiumPluginSearchData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	SynapseChromiumPlugin* self;
	SynapseQuery q;
	SynapseResultSet* result;
	SynapseResultSet* _result_;
	SynapseResultSet* _tmp0_;
	SynapseUtilsAsyncOnce* _tmp1_;
	SynapseQuery _tmp2_;
	const gchar* _tmp3_;
	SynapseMatcherFlags flags;
	SynapseQuery _tmp4_;
	SynapseResultSet* _tmp5_;
	SynapseQuery _tmp6_;
	SynapseResultSet* _tmp7_;
	GError* _inner_error0_;
};

struct _SynapseChromiumPluginParseBookmarksData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	SynapseChromiumPlugin* self;
	gboolean is_locked;
	SynapseUtilsAsyncOnce* _tmp0_;
	GeeArrayList* bookmarks;
	GeeArrayList* _tmp1_;
	JsonParser* parser;
	JsonParser* _tmp2_;
	gchar* fpath;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* CONTAINER;
	gchar* _tmp5_;
	GeeHashSet* UNWANTED_SCHEME;
	GeeHashSet* _tmp6_;
	GeeHashSet* _tmp7_;
	GeeHashSet* _tmp8_;
	GeeHashSet* _tmp9_;
	GList* folders;
	GFile* f;
	const gchar* _tmp10_;
	GFile* _tmp11_;
	GFileInputStream* input_stream;
	GFile* _tmp12_;
	GFileInputStream* _tmp13_;
	JsonParser* _tmp14_;
	GFileInputStream* _tmp15_;
	JsonObject* root_object;
	JsonParser* _tmp16_;
	JsonNode* _tmp17_;
	JsonObject* _tmp18_;
	JsonObject* _tmp19_;
	JsonObject* _tmp20_;
	JsonNode* _tmp21_;
	JsonObject* _tmp22_;
	JsonNode* _tmp23_;
	JsonObject* _tmp24_;
	JsonArray* _tmp25_;
	GList* _tmp26_;
	JsonObject* _tmp27_;
	JsonNode* _tmp28_;
	JsonObject* _tmp29_;
	JsonNode* _tmp30_;
	JsonObject* _tmp31_;
	JsonArray* _tmp32_;
	GList* _tmp33_;
	JsonObject* o;
	GList* _tmp34_;
	GList* item_collection;
	GList* item_it;
	JsonNode* item;
	JsonNode* _tmp35_;
	JsonObject* _tmp36_;
	JsonObject* _tmp37_;
	gboolean _tmp38_;
	JsonObject* _tmp39_;
	JsonObject* _tmp40_;
	GeeHashSet* _tmp41_;
	GeeArrayList* _tmp42_;
	JsonObject* _tmp43_;
	const gchar* _tmp44_;
	JsonObject* _tmp45_;
	const gchar* _tmp46_;
	SynapseChromiumPluginBookmarkMatch* _tmp47_;
	SynapseChromiumPluginBookmarkMatch* _tmp48_;
	JsonObject* _tmp49_;
	const gchar* _tmp50_;
	JsonObject* _tmp51_;
	JsonArray* _tmp52_;
	GList* _tmp53_;
	GError* err;
	GError* _tmp54_;
	const gchar* _tmp55_;
	SynapseUtilsAsyncOnce* _tmp56_;
	GeeArrayList* _tmp57_;
	GError* _inner_error0_;
};

struct _SynapseChromiumPluginBookmarkMatch {
	SynapseUriMatch parent_instance;
	SynapseChromiumPluginBookmarkMatchPrivate * priv;
};

struct _SynapseChromiumPluginBookmarkMatchClass {
	SynapseUriMatchClass parent_class;
};

struct _SynapseChromiumPluginBookmarkMatchPrivate {
	gchar* title_folded;
	gchar* uri_folded;
};

static gint SynapseChromiumPlugin_private_offset;
static gpointer synapse_chromium_plugin_parent_class = NULL;
static gint SynapseChromiumPluginBookmarkMatch_private_offset;
static gpointer synapse_chromium_plugin_bookmark_match_parent_class = NULL;
static SynapseActivatableIface * synapse_chromium_plugin_synapse_activatable_parent_iface = NULL;
static SynapseItemProviderIface * synapse_chromium_plugin_synapse_item_provider_parent_iface = NULL;

static GType synapse_chromium_plugin_bookmark_match_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
static void synapse_chromium_plugin_real_activate (SynapseActivatable* base);
static void synapse_chromium_plugin_real_deactivate (SynapseActivatable* base);
static void synapse_chromium_plugin_register_plugin (void);
static void _synapse_chromium_plugin_register_plugin_synapse_plugin_register_func (void);
static void synapse_chromium_plugin_full_search (SynapseChromiumPlugin* self,
                                          SynapseQuery* q,
                                          SynapseResultSet* results,
                                          SynapseMatcherFlags flags);
static const gchar* synapse_chromium_plugin_bookmark_match_get_title_folded (SynapseChromiumPluginBookmarkMatch* self);
static const gchar* synapse_chromium_plugin_bookmark_match_get_uri_folded (SynapseChromiumPluginBookmarkMatch* self);
static gboolean synapse_chromium_plugin_real_handles_query (SynapseItemProvider* base,
                                                     SynapseQuery* query);
static void synapse_chromium_plugin_real_search_data_free (gpointer _data);
static void synapse_chromium_plugin_real_search (SynapseItemProvider* base,
                                          SynapseQuery* q,
                                          GAsyncReadyCallback _callback_,
                                          gpointer _user_data_);
static gboolean synapse_chromium_plugin_real_search_co (SynapseChromiumPluginSearchData* _data_);
static void synapse_chromium_plugin_parse_bookmarks (SynapseChromiumPlugin* self,
                                              GAsyncReadyCallback _callback_,
                                              gpointer _user_data_);
static void synapse_chromium_plugin_parse_bookmarks_finish (SynapseChromiumPlugin* self,
                                                     GAsyncResult* _res_);
static void synapse_chromium_plugin_search_ready (GObject* source_object,
                                           GAsyncResult* _res_,
                                           gpointer _user_data_);
static gboolean synapse_chromium_plugin_is_container (JsonObject* o,
                                               const gchar* container_string);
static gboolean synapse_chromium_plugin_is_bookmark (JsonObject* o);
static gboolean synapse_chromium_plugin_is_good (JsonObject* o,
                                          GeeHashSet* unwanted_scheme);
static void synapse_chromium_plugin_parse_bookmarks_data_free (gpointer _data);
static gboolean synapse_chromium_plugin_parse_bookmarks_co (SynapseChromiumPluginParseBookmarksData* _data_);
static void synapse_chromium_plugin_parse_bookmarks_ready (GObject* source_object,
                                                    GAsyncResult* _res_,
                                                    gpointer _user_data_);
static SynapseChromiumPluginBookmarkMatch* synapse_chromium_plugin_bookmark_match_new_with_content (const gchar* name,
                                                                                             const gchar* url);
static SynapseChromiumPluginBookmarkMatch* synapse_chromium_plugin_bookmark_match_construct_with_content (GType object_type,
                                                                                                   const gchar* name,
                                                                                                   const gchar* url);
static SynapseChromiumPluginBookmarkMatch* synapse_chromium_plugin_bookmark_match_new (void);
static SynapseChromiumPluginBookmarkMatch* synapse_chromium_plugin_bookmark_match_construct (GType object_type);
static void synapse_chromium_plugin_bookmark_match_finalize (GObject * obj);
static GType synapse_chromium_plugin_bookmark_match_get_type_once (void);
static GObject * synapse_chromium_plugin_constructor (GType type,
                                               guint n_construct_properties,
                                               GObjectConstructParam * construct_properties);
static void synapse_chromium_plugin_finalize (GObject * obj);
static GType synapse_chromium_plugin_get_type_once (void);
static void _vala_synapse_chromium_plugin_get_property (GObject * object,
                                                 guint property_id,
                                                 GValue * value,
                                                 GParamSpec * pspec);
static void _vala_synapse_chromium_plugin_set_property (GObject * object,
                                                 guint property_id,
                                                 const GValue * value,
                                                 GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

static inline gpointer
synapse_chromium_plugin_get_instance_private (SynapseChromiumPlugin* self)
{
	return G_STRUCT_MEMBER_P (self, SynapseChromiumPlugin_private_offset);
}

static void
synapse_chromium_plugin_real_activate (SynapseActivatable* base)
{
	SynapseChromiumPlugin * self;
#line 25 "chromium-plugin.vala"
	self = (SynapseChromiumPlugin*) base;
#line 279 "chromium-plugin.c"
}

static void
synapse_chromium_plugin_real_deactivate (SynapseActivatable* base)
{
	SynapseChromiumPlugin * self;
#line 30 "chromium-plugin.vala"
	self = (SynapseChromiumPlugin*) base;
#line 288 "chromium-plugin.c"
}

static void
_synapse_chromium_plugin_register_plugin_synapse_plugin_register_func (void)
{
#line 64 "chromium-plugin.vala"
	synapse_chromium_plugin_register_plugin ();
#line 296 "chromium-plugin.c"
}

static void
synapse_chromium_plugin_register_plugin (void)
{
	gboolean _tmp0_ = FALSE;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gboolean _tmp3_;
	SynapsePluginRegistry* _tmp6_;
	SynapsePluginRegistry* _tmp7_;
#line 70 "chromium-plugin.vala"
	_tmp1_ = g_find_program_in_path ("chromium");
#line 70 "chromium-plugin.vala"
	_tmp2_ = _tmp1_;
#line 70 "chromium-plugin.vala"
	_tmp3_ = _tmp2_ != NULL;
#line 70 "chromium-plugin.vala"
	_g_free0 (_tmp2_);
#line 70 "chromium-plugin.vala"
	if (_tmp3_) {
#line 70 "chromium-plugin.vala"
		_tmp0_ = TRUE;
#line 320 "chromium-plugin.c"
	} else {
		gchar* _tmp4_;
		gchar* _tmp5_;
#line 70 "chromium-plugin.vala"
		_tmp4_ = g_find_program_in_path ("chromium-browser");
#line 70 "chromium-plugin.vala"
		_tmp5_ = _tmp4_;
#line 70 "chromium-plugin.vala"
		_tmp0_ = _tmp5_ != NULL;
#line 70 "chromium-plugin.vala"
		_g_free0 (_tmp5_);
#line 332 "chromium-plugin.c"
	}
#line 64 "chromium-plugin.vala"
	_tmp6_ = synapse_plugin_registry_get_default ();
#line 64 "chromium-plugin.vala"
	_tmp7_ = _tmp6_;
#line 64 "chromium-plugin.vala"
	synapse_plugin_registry_register_plugin (_tmp7_, SYNAPSE_TYPE_CHROMIUM_PLUGIN, _ ("Chromium Plugin"), _ ("Browse and open Chromium bookmarks."), "chromium", _synapse_chromium_plugin_register_plugin_synapse_plugin_register_func, _tmp0_, _ ("Chromium is not installed"));
#line 64 "chromium-plugin.vala"
	_g_object_unref0 (_tmp7_);
#line 342 "chromium-plugin.c"
}

static void
synapse_chromium_plugin_full_search (SynapseChromiumPlugin* self,
                                     SynapseQuery* q,
                                     SynapseResultSet* results,
                                     SynapseMatcherFlags flags)
{
	GeeList* matchers = NULL;
	SynapseQuery _tmp0_;
	const gchar* _tmp1_;
	GeeList* _tmp2_;
#line 87 "chromium-plugin.vala"
	g_return_if_fail (self != NULL);
#line 87 "chromium-plugin.vala"
	g_return_if_fail (q != NULL);
#line 87 "chromium-plugin.vala"
	g_return_if_fail (results != NULL);
#line 91 "chromium-plugin.vala"
	_tmp0_ = *q;
#line 91 "chromium-plugin.vala"
	_tmp1_ = _tmp0_.query_string_folded;
#line 91 "chromium-plugin.vala"
	_tmp2_ = synapse_query_get_matchers_for_query (_tmp1_, flags, G_REGEX_OPTIMIZE);
#line 91 "chromium-plugin.vala"
	matchers = _tmp2_;
#line 369 "chromium-plugin.c"
	{
		GeeList* _bmk_list = NULL;
		SynapseUtilsAsyncOnce* _tmp3_;
		gconstpointer _tmp4_;
		gint _bmk_size = 0;
		GeeList* _tmp5_;
		gint _tmp6_;
		gint _tmp7_;
		gint _bmk_index = 0;
#line 93 "chromium-plugin.vala"
		_tmp3_ = self->priv->bookmarks_once;
#line 93 "chromium-plugin.vala"
		_tmp4_ = synapse_utils_async_once_get_data (_tmp3_);
#line 93 "chromium-plugin.vala"
		_bmk_list = (GeeList*) _tmp4_;
#line 93 "chromium-plugin.vala"
		_tmp5_ = _bmk_list;
#line 93 "chromium-plugin.vala"
		_tmp6_ = gee_collection_get_size ((GeeCollection*) _tmp5_);
#line 93 "chromium-plugin.vala"
		_tmp7_ = _tmp6_;
#line 93 "chromium-plugin.vala"
		_bmk_size = _tmp7_;
#line 93 "chromium-plugin.vala"
		_bmk_index = -1;
#line 93 "chromium-plugin.vala"
		while (TRUE) {
#line 397 "chromium-plugin.c"
			gint _tmp8_;
			gint _tmp9_;
			SynapseChromiumPluginBookmarkMatch* bmk = NULL;
			GeeList* _tmp10_;
			gpointer _tmp11_;
			const gchar* name = NULL;
			SynapseChromiumPluginBookmarkMatch* _tmp12_;
			const gchar* _tmp13_;
			const gchar* url = NULL;
			SynapseChromiumPluginBookmarkMatch* _tmp14_;
			const gchar* _tmp15_;
#line 93 "chromium-plugin.vala"
			_bmk_index = _bmk_index + 1;
#line 93 "chromium-plugin.vala"
			_tmp8_ = _bmk_index;
#line 93 "chromium-plugin.vala"
			_tmp9_ = _bmk_size;
#line 93 "chromium-plugin.vala"
			if (!(_tmp8_ < _tmp9_)) {
#line 93 "chromium-plugin.vala"
				break;
#line 419 "chromium-plugin.c"
			}
#line 93 "chromium-plugin.vala"
			_tmp10_ = _bmk_list;
#line 93 "chromium-plugin.vala"
			_tmp11_ = gee_list_get (_tmp10_, _bmk_index);
#line 93 "chromium-plugin.vala"
			bmk = (SynapseChromiumPluginBookmarkMatch*) _tmp11_;
#line 95 "chromium-plugin.vala"
			_tmp12_ = bmk;
#line 95 "chromium-plugin.vala"
			_tmp13_ = synapse_chromium_plugin_bookmark_match_get_title_folded (_tmp12_);
#line 95 "chromium-plugin.vala"
			name = _tmp13_;
#line 96 "chromium-plugin.vala"
			_tmp14_ = bmk;
#line 96 "chromium-plugin.vala"
			_tmp15_ = synapse_chromium_plugin_bookmark_match_get_uri_folded (_tmp14_);
#line 96 "chromium-plugin.vala"
			url = _tmp15_;
#line 439 "chromium-plugin.c"
			{
				GeeList* _matcher_list = NULL;
				GeeList* _tmp16_;
				gint _matcher_size = 0;
				GeeList* _tmp17_;
				gint _tmp18_;
				gint _tmp19_;
				gint _matcher_index = 0;
#line 98 "chromium-plugin.vala"
				_tmp16_ = matchers;
#line 98 "chromium-plugin.vala"
				_matcher_list = _tmp16_;
#line 98 "chromium-plugin.vala"
				_tmp17_ = _matcher_list;
#line 98 "chromium-plugin.vala"
				_tmp18_ = gee_collection_get_size ((GeeCollection*) _tmp17_);
#line 98 "chromium-plugin.vala"
				_tmp19_ = _tmp18_;
#line 98 "chromium-plugin.vala"
				_matcher_size = _tmp19_;
#line 98 "chromium-plugin.vala"
				_matcher_index = -1;
#line 98 "chromium-plugin.vala"
				while (TRUE) {
#line 464 "chromium-plugin.c"
					gint _tmp20_;
					gint _tmp21_;
					GeeMapEntry* matcher = NULL;
					GeeList* _tmp22_;
					gpointer _tmp23_;
					GeeMapEntry* _tmp24_;
					gconstpointer _tmp25_;
					gconstpointer _tmp26_;
					const gchar* _tmp27_;
					gboolean _tmp32_ = FALSE;
					const gchar* _tmp33_;
#line 98 "chromium-plugin.vala"
					_matcher_index = _matcher_index + 1;
#line 98 "chromium-plugin.vala"
					_tmp20_ = _matcher_index;
#line 98 "chromium-plugin.vala"
					_tmp21_ = _matcher_size;
#line 98 "chromium-plugin.vala"
					if (!(_tmp20_ < _tmp21_)) {
#line 98 "chromium-plugin.vala"
						break;
#line 486 "chromium-plugin.c"
					}
#line 98 "chromium-plugin.vala"
					_tmp22_ = _matcher_list;
#line 98 "chromium-plugin.vala"
					_tmp23_ = gee_list_get (_tmp22_, _matcher_index);
#line 98 "chromium-plugin.vala"
					matcher = (GeeMapEntry*) _tmp23_;
#line 100 "chromium-plugin.vala"
					_tmp24_ = matcher;
#line 100 "chromium-plugin.vala"
					_tmp25_ = gee_map_entry_get_key (_tmp24_);
#line 100 "chromium-plugin.vala"
					_tmp26_ = _tmp25_;
#line 100 "chromium-plugin.vala"
					_tmp27_ = name;
#line 100 "chromium-plugin.vala"
					if (g_regex_match ((GRegex*) _tmp26_, _tmp27_, 0, NULL)) {
#line 504 "chromium-plugin.c"
						SynapseChromiumPluginBookmarkMatch* _tmp28_;
						GeeMapEntry* _tmp29_;
						gconstpointer _tmp30_;
						gconstpointer _tmp31_;
#line 102 "chromium-plugin.vala"
						_tmp28_ = bmk;
#line 102 "chromium-plugin.vala"
						_tmp29_ = matcher;
#line 102 "chromium-plugin.vala"
						_tmp30_ = gee_map_entry_get_value (_tmp29_);
#line 102 "chromium-plugin.vala"
						_tmp31_ = _tmp30_;
#line 102 "chromium-plugin.vala"
						synapse_result_set_add (results, (SynapseMatch*) _tmp28_, (gint) ((gintptr) _tmp31_));
#line 103 "chromium-plugin.vala"
						_g_object_unref0 (matcher);
#line 103 "chromium-plugin.vala"
						break;
#line 523 "chromium-plugin.c"
					}
#line 105 "chromium-plugin.vala"
					_tmp33_ = url;
#line 105 "chromium-plugin.vala"
					if (_tmp33_ != NULL) {
#line 529 "chromium-plugin.c"
						GeeMapEntry* _tmp34_;
						gconstpointer _tmp35_;
						gconstpointer _tmp36_;
						const gchar* _tmp37_;
#line 105 "chromium-plugin.vala"
						_tmp34_ = matcher;
#line 105 "chromium-plugin.vala"
						_tmp35_ = gee_map_entry_get_key (_tmp34_);
#line 105 "chromium-plugin.vala"
						_tmp36_ = _tmp35_;
#line 105 "chromium-plugin.vala"
						_tmp37_ = url;
#line 105 "chromium-plugin.vala"
						_tmp32_ = g_regex_match ((GRegex*) _tmp36_, _tmp37_, 0, NULL);
#line 544 "chromium-plugin.c"
					} else {
#line 105 "chromium-plugin.vala"
						_tmp32_ = FALSE;
#line 548 "chromium-plugin.c"
					}
#line 105 "chromium-plugin.vala"
					if (_tmp32_) {
#line 552 "chromium-plugin.c"
						SynapseChromiumPluginBookmarkMatch* _tmp38_;
						GeeMapEntry* _tmp39_;
						gconstpointer _tmp40_;
						gconstpointer _tmp41_;
#line 107 "chromium-plugin.vala"
						_tmp38_ = bmk;
#line 107 "chromium-plugin.vala"
						_tmp39_ = matcher;
#line 107 "chromium-plugin.vala"
						_tmp40_ = gee_map_entry_get_value (_tmp39_);
#line 107 "chromium-plugin.vala"
						_tmp41_ = _tmp40_;
#line 107 "chromium-plugin.vala"
						synapse_result_set_add (results, (SynapseMatch*) _tmp38_, (gint) ((gintptr) _tmp41_));
#line 108 "chromium-plugin.vala"
						_g_object_unref0 (matcher);
#line 108 "chromium-plugin.vala"
						break;
#line 571 "chromium-plugin.c"
					}
#line 98 "chromium-plugin.vala"
					_g_object_unref0 (matcher);
#line 575 "chromium-plugin.c"
				}
			}
#line 93 "chromium-plugin.vala"
			_g_object_unref0 (bmk);
#line 580 "chromium-plugin.c"
		}
	}
#line 87 "chromium-plugin.vala"
	_g_object_unref0 (matchers);
#line 585 "chromium-plugin.c"
}

static gboolean
synapse_chromium_plugin_real_handles_query (SynapseItemProvider* base,
                                            SynapseQuery* query)
{
	SynapseChromiumPlugin * self;
	SynapseQuery _tmp0_;
	gboolean result;
#line 114 "chromium-plugin.vala"
	self = (SynapseChromiumPlugin*) base;
#line 114 "chromium-plugin.vala"
	g_return_val_if_fail (query != NULL, FALSE);
#line 116 "chromium-plugin.vala"
	_tmp0_ = *query;
#line 116 "chromium-plugin.vala"
	result = (_tmp0_.query_type & SYNAPSE_QUERY_FLAGS_INTERNET) == SYNAPSE_QUERY_FLAGS_INTERNET;
#line 116 "chromium-plugin.vala"
	return result;
#line 605 "chromium-plugin.c"
}

static void
synapse_chromium_plugin_real_search_data_free (gpointer _data)
{
	SynapseChromiumPluginSearchData* _data_;
	_data_ = _data;
#line 21 "chromium-plugin.vala"
	synapse_query_destroy (&_data_->q);
#line 21 "chromium-plugin.vala"
	_g_object_unref0 (_data_->result);
#line 21 "chromium-plugin.vala"
	_g_object_unref0 (_data_->self);
#line 21 "chromium-plugin.vala"
	g_slice_free (SynapseChromiumPluginSearchData, _data_);
#line 621 "chromium-plugin.c"
}

static gpointer
_g_object_ref0 (gpointer self)
{
#line 21 "chromium-plugin.vala"
	return self ? g_object_ref (self) : NULL;
#line 629 "chromium-plugin.c"
}

static void
synapse_chromium_plugin_real_search (SynapseItemProvider* base,
                                     SynapseQuery* q,
                                     GAsyncReadyCallback _callback_,
                                     gpointer _user_data_)
{
	SynapseChromiumPlugin * self;
	SynapseChromiumPluginSearchData* _data_;
	SynapseChromiumPlugin* _tmp0_;
	SynapseQuery _tmp1_;
	SynapseQuery _tmp2_;
	SynapseQuery _tmp3_ = {0};
#line 21 "chromium-plugin.vala"
	g_return_if_fail (q != NULL);
#line 21 "chromium-plugin.vala"
	self = (SynapseChromiumPlugin*) base;
#line 21 "chromium-plugin.vala"
	_data_ = g_slice_new0 (SynapseChromiumPluginSearchData);
#line 21 "chromium-plugin.vala"
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
#line 21 "chromium-plugin.vala"
	g_task_set_task_data (_data_->_async_result, _data_, synapse_chromium_plugin_real_search_data_free);
#line 21 "chromium-plugin.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 21 "chromium-plugin.vala"
	_data_->self = _tmp0_;
#line 21 "chromium-plugin.vala"
	_tmp1_ = *q;
#line 21 "chromium-plugin.vala"
	_tmp2_ = _tmp1_;
#line 21 "chromium-plugin.vala"
	synapse_query_copy (&_tmp2_, &_tmp3_);
#line 21 "chromium-plugin.vala"
	synapse_query_destroy (&_data_->q);
#line 21 "chromium-plugin.vala"
	_data_->q = _tmp3_;
#line 21 "chromium-plugin.vala"
	synapse_chromium_plugin_real_search_co (_data_);
#line 670 "chromium-plugin.c"
}

static SynapseResultSet*
synapse_chromium_plugin_search_finish (SynapseItemProvider* base,
                                       GAsyncResult* _res_,
                                       GError** error)
{
	SynapseResultSet* result;
	SynapseChromiumPluginSearchData* _data_;
#line 21 "chromium-plugin.vala"
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
#line 21 "chromium-plugin.vala"
	if (NULL == _data_) {
#line 21 "chromium-plugin.vala"
		return NULL;
#line 686 "chromium-plugin.c"
	}
#line 21 "chromium-plugin.vala"
	result = _data_->result;
#line 21 "chromium-plugin.vala"
	_data_->result = NULL;
#line 21 "chromium-plugin.vala"
	return result;
#line 694 "chromium-plugin.c"
}

static void
synapse_chromium_plugin_search_ready (GObject* source_object,
                                      GAsyncResult* _res_,
                                      gpointer _user_data_)
{
	SynapseChromiumPluginSearchData* _data_;
#line 125 "chromium-plugin.vala"
	_data_ = _user_data_;
#line 125 "chromium-plugin.vala"
	_data_->_source_object_ = source_object;
#line 125 "chromium-plugin.vala"
	_data_->_res_ = _res_;
#line 125 "chromium-plugin.vala"
	synapse_chromium_plugin_real_search_co (_data_);
#line 711 "chromium-plugin.c"
}

static gboolean
synapse_chromium_plugin_real_search_co (SynapseChromiumPluginSearchData* _data_)
{
#line 119 "chromium-plugin.vala"
	switch (_data_->_state_) {
#line 119 "chromium-plugin.vala"
		case 0:
#line 721 "chromium-plugin.c"
		goto _state_0;
#line 119 "chromium-plugin.vala"
		case 1:
#line 725 "chromium-plugin.c"
		goto _state_1;
		default:
#line 119 "chromium-plugin.vala"
		g_assert_not_reached ();
#line 730 "chromium-plugin.c"
	}
	_state_0:
#line 121 "chromium-plugin.vala"
	_data_->_tmp0_ = synapse_result_set_new ();
#line 121 "chromium-plugin.vala"
	_data_->_result_ = _data_->_tmp0_;
#line 123 "chromium-plugin.vala"
	_data_->_tmp1_ = _data_->self->priv->bookmarks_once;
#line 123 "chromium-plugin.vala"
	if (!synapse_utils_async_once_is_initialized (_data_->_tmp1_)) {
#line 125 "chromium-plugin.vala"
		_data_->_state_ = 1;
#line 125 "chromium-plugin.vala"
		synapse_chromium_plugin_parse_bookmarks (_data_->self, synapse_chromium_plugin_search_ready, _data_);
#line 125 "chromium-plugin.vala"
		return FALSE;
#line 747 "chromium-plugin.c"
		_state_1:
#line 125 "chromium-plugin.vala"
		synapse_chromium_plugin_parse_bookmarks_finish (_data_->self, _data_->_res_);
#line 751 "chromium-plugin.c"
	}
#line 128 "chromium-plugin.vala"
	_data_->_tmp2_ = _data_->q;
#line 128 "chromium-plugin.vala"
	_data_->_tmp3_ = _data_->_tmp2_.query_string;
#line 128 "chromium-plugin.vala"
	if (g_utf8_strlen (_data_->_tmp3_, (gssize) -1) == 1) {
#line 130 "chromium-plugin.vala"
		_data_->flags = (SYNAPSE_MATCHER_FLAGS_NO_SUBSTRING | SYNAPSE_MATCHER_FLAGS_NO_PARTIAL) | SYNAPSE_MATCHER_FLAGS_NO_FUZZY;
#line 132 "chromium-plugin.vala"
		_data_->_tmp4_ = _data_->q;
#line 132 "chromium-plugin.vala"
		_data_->_tmp5_ = _data_->_result_;
#line 132 "chromium-plugin.vala"
		synapse_chromium_plugin_full_search (_data_->self, &_data_->_tmp4_, _data_->_tmp5_, _data_->flags);
#line 767 "chromium-plugin.c"
	} else {
#line 136 "chromium-plugin.vala"
		_data_->_tmp6_ = _data_->q;
#line 136 "chromium-plugin.vala"
		_data_->_tmp7_ = _data_->_result_;
#line 136 "chromium-plugin.vala"
		synapse_chromium_plugin_full_search (_data_->self, &_data_->_tmp6_, _data_->_tmp7_, 0);
#line 775 "chromium-plugin.c"
	}
#line 139 "chromium-plugin.vala"
	synapse_query_check_cancellable (&_data_->q, &_data_->_inner_error0_);
#line 139 "chromium-plugin.vala"
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
#line 139 "chromium-plugin.vala"
		if (_data_->_inner_error0_->domain == SYNAPSE_SEARCH_ERROR) {
#line 139 "chromium-plugin.vala"
			g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
#line 139 "chromium-plugin.vala"
			_g_object_unref0 (_data_->_result_);
#line 139 "chromium-plugin.vala"
			g_object_unref (_data_->_async_result);
#line 139 "chromium-plugin.vala"
			return FALSE;
#line 791 "chromium-plugin.c"
		} else {
#line 139 "chromium-plugin.vala"
			_g_object_unref0 (_data_->_result_);
#line 139 "chromium-plugin.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
#line 139 "chromium-plugin.vala"
			g_clear_error (&_data_->_inner_error0_);
#line 139 "chromium-plugin.vala"
			g_object_unref (_data_->_async_result);
#line 139 "chromium-plugin.vala"
			return FALSE;
#line 803 "chromium-plugin.c"
		}
	}
#line 141 "chromium-plugin.vala"
	_data_->result = _data_->_result_;
#line 141 "chromium-plugin.vala"
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 141 "chromium-plugin.vala"
	if (_data_->_state_ != 0) {
#line 141 "chromium-plugin.vala"
		while (!g_task_get_completed (_data_->_async_result)) {
#line 141 "chromium-plugin.vala"
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 816 "chromium-plugin.c"
		}
	}
#line 141 "chromium-plugin.vala"
	g_object_unref (_data_->_async_result);
#line 141 "chromium-plugin.vala"
	return FALSE;
#line 823 "chromium-plugin.c"
}

static gboolean
synapse_chromium_plugin_is_container (JsonObject* o,
                                      const gchar* container_string)
{
	const gchar* _tmp0_;
	gboolean result;
#line 147 "chromium-plugin.vala"
	g_return_val_if_fail (o != NULL, FALSE);
#line 147 "chromium-plugin.vala"
	g_return_val_if_fail (container_string != NULL, FALSE);
#line 149 "chromium-plugin.vala"
	_tmp0_ = json_object_get_string_member (o, "type");
#line 149 "chromium-plugin.vala"
	result = g_strcmp0 (_tmp0_, container_string) == 0;
#line 149 "chromium-plugin.vala"
	return result;
#line 842 "chromium-plugin.c"
}

static gboolean
synapse_chromium_plugin_is_bookmark (JsonObject* o)
{
	gboolean result;
#line 152 "chromium-plugin.vala"
	g_return_val_if_fail (o != NULL, FALSE);
#line 154 "chromium-plugin.vala"
	result = json_object_has_member (o, "url");
#line 154 "chromium-plugin.vala"
	return result;
#line 855 "chromium-plugin.c"
}

static gboolean
synapse_chromium_plugin_is_good (JsonObject* o,
                                 GeeHashSet* unwanted_scheme)
{
	const gchar* _tmp0_;
	gchar** _tmp1_;
	gchar** _tmp2_;
	gchar** _tmp3_;
	gint _tmp3__length1;
	const gchar* _tmp4_;
	gboolean _tmp5_;
	gboolean result;
#line 157 "chromium-plugin.vala"
	g_return_val_if_fail (o != NULL, FALSE);
#line 157 "chromium-plugin.vala"
	g_return_val_if_fail (unwanted_scheme != NULL, FALSE);
#line 159 "chromium-plugin.vala"
	_tmp0_ = json_object_get_string_member (o, "url");
#line 159 "chromium-plugin.vala"
	_tmp2_ = _tmp1_ = g_strsplit (_tmp0_, ":", 1);
#line 159 "chromium-plugin.vala"
	_tmp3_ = _tmp2_;
#line 159 "chromium-plugin.vala"
	_tmp3__length1 = _vala_array_length (_tmp1_);
#line 159 "chromium-plugin.vala"
	_tmp4_ = _tmp3_[0];
#line 159 "chromium-plugin.vala"
	_tmp5_ = !gee_abstract_collection_contains ((GeeAbstractCollection*) unwanted_scheme, _tmp4_);
#line 159 "chromium-plugin.vala"
	_tmp3_ = (_vala_array_free (_tmp3_, _tmp3__length1, (GDestroyNotify) g_free), NULL);
#line 159 "chromium-plugin.vala"
	result = _tmp5_;
#line 159 "chromium-plugin.vala"
	return result;
#line 892 "chromium-plugin.c"
}

static void
synapse_chromium_plugin_parse_bookmarks_data_free (gpointer _data)
{
	SynapseChromiumPluginParseBookmarksData* _data_;
	_data_ = _data;
#line 21 "chromium-plugin.vala"
	_g_object_unref0 (_data_->self);
#line 21 "chromium-plugin.vala"
	g_slice_free (SynapseChromiumPluginParseBookmarksData, _data_);
#line 904 "chromium-plugin.c"
}

static void
synapse_chromium_plugin_parse_bookmarks (SynapseChromiumPlugin* self,
                                         GAsyncReadyCallback _callback_,
                                         gpointer _user_data_)
{
	SynapseChromiumPluginParseBookmarksData* _data_;
	SynapseChromiumPlugin* _tmp0_;
#line 21 "chromium-plugin.vala"
	g_return_if_fail (self != NULL);
#line 21 "chromium-plugin.vala"
	_data_ = g_slice_new0 (SynapseChromiumPluginParseBookmarksData);
#line 21 "chromium-plugin.vala"
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
#line 21 "chromium-plugin.vala"
	g_task_set_task_data (_data_->_async_result, _data_, synapse_chromium_plugin_parse_bookmarks_data_free);
#line 21 "chromium-plugin.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 21 "chromium-plugin.vala"
	_data_->self = _tmp0_;
#line 21 "chromium-plugin.vala"
	synapse_chromium_plugin_parse_bookmarks_co (_data_);
#line 928 "chromium-plugin.c"
}

static void
synapse_chromium_plugin_parse_bookmarks_finish (SynapseChromiumPlugin* self,
                                                GAsyncResult* _res_)
{
	SynapseChromiumPluginParseBookmarksData* _data_;
#line 21 "chromium-plugin.vala"
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
#line 938 "chromium-plugin.c"
}

static void
synapse_chromium_plugin_parse_bookmarks_ready (GObject* source_object,
                                               GAsyncResult* _res_,
                                               gpointer _user_data_)
{
	SynapseChromiumPluginParseBookmarksData* _data_;
#line 165 "chromium-plugin.vala"
	_data_ = _user_data_;
#line 165 "chromium-plugin.vala"
	_data_->_source_object_ = source_object;
#line 165 "chromium-plugin.vala"
	_data_->_res_ = _res_;
#line 165 "chromium-plugin.vala"
	synapse_chromium_plugin_parse_bookmarks_co (_data_);
#line 955 "chromium-plugin.c"
}

static gpointer
_json_object_ref0 (gpointer self)
{
#line 187 "chromium-plugin.vala"
	return self ? json_object_ref (self) : NULL;
#line 963 "chromium-plugin.c"
}

static gboolean
synapse_chromium_plugin_parse_bookmarks_co (SynapseChromiumPluginParseBookmarksData* _data_)
{
#line 163 "chromium-plugin.vala"
	switch (_data_->_state_) {
#line 163 "chromium-plugin.vala"
		case 0:
#line 973 "chromium-plugin.c"
		goto _state_0;
#line 163 "chromium-plugin.vala"
		case 1:
#line 977 "chromium-plugin.c"
		goto _state_1;
#line 163 "chromium-plugin.vala"
		case 2:
#line 981 "chromium-plugin.c"
		goto _state_2;
#line 163 "chromium-plugin.vala"
		case 3:
#line 985 "chromium-plugin.c"
		goto _state_3;
		default:
#line 163 "chromium-plugin.vala"
		g_assert_not_reached ();
#line 990 "chromium-plugin.c"
	}
	_state_0:
#line 165 "chromium-plugin.vala"
	_data_->_tmp0_ = _data_->self->priv->bookmarks_once;
#line 165 "chromium-plugin.vala"
	_data_->_state_ = 1;
#line 165 "chromium-plugin.vala"
	synapse_utils_async_once_enter (_data_->_tmp0_, synapse_chromium_plugin_parse_bookmarks_ready, _data_);
#line 165 "chromium-plugin.vala"
	return FALSE;
#line 1001 "chromium-plugin.c"
	_state_1:
#line 165 "chromium-plugin.vala"
	_data_->is_locked = synapse_utils_async_once_enter_finish (_data_->_tmp0_, _data_->_res_);
#line 166 "chromium-plugin.vala"
	if (!_data_->is_locked) {
#line 166 "chromium-plugin.vala"
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 166 "chromium-plugin.vala"
		if (_data_->_state_ != 0) {
#line 166 "chromium-plugin.vala"
			while (!g_task_get_completed (_data_->_async_result)) {
#line 166 "chromium-plugin.vala"
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 1015 "chromium-plugin.c"
			}
		}
#line 166 "chromium-plugin.vala"
		g_object_unref (_data_->_async_result);
#line 166 "chromium-plugin.vala"
		return FALSE;
#line 1022 "chromium-plugin.c"
	}
#line 168 "chromium-plugin.vala"
	_data_->_tmp1_ = gee_array_list_new (SYNAPSE_CHROMIUM_PLUGIN_TYPE_BOOKMARK_MATCH, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
#line 168 "chromium-plugin.vala"
	_data_->bookmarks = _data_->_tmp1_;
#line 169 "chromium-plugin.vala"
	_data_->_tmp2_ = json_parser_new ();
#line 169 "chromium-plugin.vala"
	_data_->parser = _data_->_tmp2_;
#line 170 "chromium-plugin.vala"
	_data_->_tmp3_ = g_get_user_config_dir ();
#line 170 "chromium-plugin.vala"
	_data_->_tmp4_ = g_build_filename (_data_->_tmp3_, "chromium", "Default", "Bookmarks", NULL);
#line 170 "chromium-plugin.vala"
	_data_->fpath = _data_->_tmp4_;
#line 173 "chromium-plugin.vala"
	_data_->_tmp5_ = g_strdup ("folder");
#line 173 "chromium-plugin.vala"
	_data_->CONTAINER = _data_->_tmp5_;
#line 174 "chromium-plugin.vala"
	_data_->_tmp6_ = gee_hash_set_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL, NULL, NULL, NULL);
#line 174 "chromium-plugin.vala"
	_data_->UNWANTED_SCHEME = _data_->_tmp6_;
#line 175 "chromium-plugin.vala"
	_data_->_tmp7_ = _data_->UNWANTED_SCHEME;
#line 175 "chromium-plugin.vala"
	gee_abstract_collection_add ((GeeAbstractCollection*) _data_->_tmp7_, "data");
#line 176 "chromium-plugin.vala"
	_data_->_tmp8_ = _data_->UNWANTED_SCHEME;
#line 176 "chromium-plugin.vala"
	gee_abstract_collection_add ((GeeAbstractCollection*) _data_->_tmp8_, "place");
#line 177 "chromium-plugin.vala"
	_data_->_tmp9_ = _data_->UNWANTED_SCHEME;
#line 177 "chromium-plugin.vala"
	gee_abstract_collection_add ((GeeAbstractCollection*) _data_->_tmp9_, "javascript");
#line 179 "chromium-plugin.vala"
	_data_->folders = NULL;
#line 1060 "chromium-plugin.c"
	{
#line 183 "chromium-plugin.vala"
		_data_->_tmp10_ = _data_->fpath;
#line 183 "chromium-plugin.vala"
		_data_->_tmp11_ = g_file_new_for_path (_data_->_tmp10_);
#line 183 "chromium-plugin.vala"
		_data_->f = _data_->_tmp11_;
#line 184 "chromium-plugin.vala"
		_data_->_tmp12_ = _data_->f;
#line 184 "chromium-plugin.vala"
		_data_->_state_ = 2;
#line 184 "chromium-plugin.vala"
		g_file_read_async (_data_->_tmp12_, G_PRIORITY_DEFAULT, NULL, synapse_chromium_plugin_parse_bookmarks_ready, _data_);
#line 184 "chromium-plugin.vala"
		return FALSE;
#line 1076 "chromium-plugin.c"
		_state_2:
#line 184 "chromium-plugin.vala"
		_data_->_tmp13_ = g_file_read_finish (_data_->_tmp12_, _data_->_res_, &_data_->_inner_error0_);
#line 184 "chromium-plugin.vala"
		_data_->input_stream = _data_->_tmp13_;
#line 184 "chromium-plugin.vala"
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
#line 184 "chromium-plugin.vala"
			_g_object_unref0 (_data_->f);
#line 1086 "chromium-plugin.c"
			goto __catch0_g_error;
		}
#line 185 "chromium-plugin.vala"
		_data_->_tmp14_ = _data_->parser;
#line 185 "chromium-plugin.vala"
		_data_->_tmp15_ = _data_->input_stream;
#line 185 "chromium-plugin.vala"
		_data_->_state_ = 3;
#line 185 "chromium-plugin.vala"
		json_parser_load_from_stream_async (_data_->_tmp14_, (GInputStream*) _data_->_tmp15_, NULL, synapse_chromium_plugin_parse_bookmarks_ready, _data_);
#line 185 "chromium-plugin.vala"
		return FALSE;
#line 1099 "chromium-plugin.c"
		_state_3:
#line 185 "chromium-plugin.vala"
		json_parser_load_from_stream_finish (_data_->_tmp14_, _data_->_res_, &_data_->_inner_error0_);
#line 185 "chromium-plugin.vala"
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
#line 185 "chromium-plugin.vala"
			_g_object_unref0 (_data_->input_stream);
#line 185 "chromium-plugin.vala"
			_g_object_unref0 (_data_->f);
#line 1109 "chromium-plugin.c"
			goto __catch0_g_error;
		}
#line 187 "chromium-plugin.vala"
		_data_->_tmp16_ = _data_->parser;
#line 187 "chromium-plugin.vala"
		_data_->_tmp17_ = json_parser_get_root (_data_->_tmp16_);
#line 187 "chromium-plugin.vala"
		_data_->_tmp18_ = json_node_get_object (_data_->_tmp17_);
#line 187 "chromium-plugin.vala"
		_data_->_tmp19_ = _json_object_ref0 (_data_->_tmp18_);
#line 187 "chromium-plugin.vala"
		_data_->root_object = _data_->_tmp19_;
#line 188 "chromium-plugin.vala"
		_data_->_tmp20_ = _data_->root_object;
#line 188 "chromium-plugin.vala"
		_data_->_tmp21_ = json_object_get_member (_data_->_tmp20_, "roots");
#line 188 "chromium-plugin.vala"
		_data_->_tmp22_ = json_node_get_object (_data_->_tmp21_);
#line 188 "chromium-plugin.vala"
		_data_->_tmp23_ = json_object_get_member (_data_->_tmp22_, "bookmark_bar");
#line 188 "chromium-plugin.vala"
		_data_->_tmp24_ = json_node_get_object (_data_->_tmp23_);
#line 188 "chromium-plugin.vala"
		_data_->_tmp25_ = json_object_get_array_member (_data_->_tmp24_, "children");
#line 188 "chromium-plugin.vala"
		_data_->_tmp26_ = json_array_get_elements (_data_->_tmp25_);
#line 188 "chromium-plugin.vala"
		_data_->folders = g_list_concat (_data_->folders, _data_->_tmp26_);
#line 191 "chromium-plugin.vala"
		_data_->_tmp27_ = _data_->root_object;
#line 191 "chromium-plugin.vala"
		_data_->_tmp28_ = json_object_get_member (_data_->_tmp27_, "roots");
#line 191 "chromium-plugin.vala"
		_data_->_tmp29_ = json_node_get_object (_data_->_tmp28_);
#line 191 "chromium-plugin.vala"
		_data_->_tmp30_ = json_object_get_member (_data_->_tmp29_, "other");
#line 191 "chromium-plugin.vala"
		_data_->_tmp31_ = json_node_get_object (_data_->_tmp30_);
#line 191 "chromium-plugin.vala"
		_data_->_tmp32_ = json_object_get_array_member (_data_->_tmp31_, "children");
#line 191 "chromium-plugin.vala"
		_data_->_tmp33_ = json_array_get_elements (_data_->_tmp32_);
#line 191 "chromium-plugin.vala"
		_data_->folders = g_list_concat (_data_->folders, _data_->_tmp33_);
#line 196 "chromium-plugin.vala"
		_data_->_tmp34_ = _data_->folders;
#line 1156 "chromium-plugin.c"
		{
#line 196 "chromium-plugin.vala"
			_data_->item_collection = _data_->_tmp34_;
#line 196 "chromium-plugin.vala"
			for (_data_->item_it = _data_->item_collection; _data_->item_it != NULL; _data_->item_it = _data_->item_it->next) {
#line 196 "chromium-plugin.vala"
				_data_->item = (JsonNode*) _data_->item_it->data;
#line 1164 "chromium-plugin.c"
				{
#line 198 "chromium-plugin.vala"
					_data_->_tmp35_ = _data_->item;
#line 198 "chromium-plugin.vala"
					_data_->_tmp36_ = json_node_get_object (_data_->_tmp35_);
#line 198 "chromium-plugin.vala"
					_data_->_tmp37_ = _json_object_ref0 (_data_->_tmp36_);
#line 198 "chromium-plugin.vala"
					_json_object_unref0 (_data_->o);
#line 198 "chromium-plugin.vala"
					_data_->o = _data_->_tmp37_;
#line 199 "chromium-plugin.vala"
					_data_->_tmp39_ = _data_->o;
#line 199 "chromium-plugin.vala"
					if (synapse_chromium_plugin_is_bookmark (_data_->_tmp39_)) {
#line 199 "chromium-plugin.vala"
						_data_->_tmp40_ = _data_->o;
#line 199 "chromium-plugin.vala"
						_data_->_tmp41_ = _data_->UNWANTED_SCHEME;
#line 199 "chromium-plugin.vala"
						_data_->_tmp38_ = synapse_chromium_plugin_is_good (_data_->_tmp40_, _data_->_tmp41_);
#line 1186 "chromium-plugin.c"
					} else {
#line 199 "chromium-plugin.vala"
						_data_->_tmp38_ = FALSE;
#line 1190 "chromium-plugin.c"
					}
#line 199 "chromium-plugin.vala"
					if (_data_->_tmp38_) {
#line 201 "chromium-plugin.vala"
						_data_->_tmp42_ = _data_->bookmarks;
#line 201 "chromium-plugin.vala"
						_data_->_tmp43_ = _data_->o;
#line 201 "chromium-plugin.vala"
						_data_->_tmp44_ = json_object_get_string_member (_data_->_tmp43_, "name");
#line 201 "chromium-plugin.vala"
						_data_->_tmp45_ = _data_->o;
#line 201 "chromium-plugin.vala"
						_data_->_tmp46_ = json_object_get_string_member (_data_->_tmp45_, "url");
#line 201 "chromium-plugin.vala"
						_data_->_tmp47_ = synapse_chromium_plugin_bookmark_match_new_with_content (_data_->_tmp44_, _data_->_tmp46_);
#line 201 "chromium-plugin.vala"
						_data_->_tmp48_ = _data_->_tmp47_;
#line 201 "chromium-plugin.vala"
						gee_abstract_collection_add ((GeeAbstractCollection*) _data_->_tmp42_, _data_->_tmp48_);
#line 201 "chromium-plugin.vala"
						_g_object_unref0 (_data_->_tmp48_);
#line 1212 "chromium-plugin.c"
					}
#line 205 "chromium-plugin.vala"
					_data_->_tmp49_ = _data_->o;
#line 205 "chromium-plugin.vala"
					_data_->_tmp50_ = _data_->CONTAINER;
#line 205 "chromium-plugin.vala"
					if (synapse_chromium_plugin_is_container (_data_->_tmp49_, _data_->_tmp50_)) {
#line 207 "chromium-plugin.vala"
						_data_->_tmp51_ = _data_->o;
#line 207 "chromium-plugin.vala"
						_data_->_tmp52_ = json_object_get_array_member (_data_->_tmp51_, "children");
#line 207 "chromium-plugin.vala"
						_data_->_tmp53_ = json_array_get_elements (_data_->_tmp52_);
#line 207 "chromium-plugin.vala"
						_data_->folders = g_list_concat (_data_->folders, _data_->_tmp53_);
#line 1228 "chromium-plugin.c"
					}
				}
			}
		}
#line 181 "chromium-plugin.vala"
		_json_object_unref0 (_data_->o);
#line 181 "chromium-plugin.vala"
		_json_object_unref0 (_data_->root_object);
#line 181 "chromium-plugin.vala"
		_g_object_unref0 (_data_->input_stream);
#line 181 "chromium-plugin.vala"
		_g_object_unref0 (_data_->f);
#line 1241 "chromium-plugin.c"
	}
	goto __finally0;
	__catch0_g_error:
	{
#line 181 "chromium-plugin.vala"
		_data_->err = _data_->_inner_error0_;
#line 181 "chromium-plugin.vala"
		_data_->_inner_error0_ = NULL;
#line 213 "chromium-plugin.vala"
		_data_->_tmp54_ = _data_->err;
#line 213 "chromium-plugin.vala"
		_data_->_tmp55_ = _data_->_tmp54_->message;
#line 213 "chromium-plugin.vala"
		g_warning ("chromium-plugin.vala:213: %s", _data_->_tmp55_);
#line 181 "chromium-plugin.vala"
		_g_error_free0 (_data_->err);
#line 1258 "chromium-plugin.c"
	}
	__finally0:
#line 181 "chromium-plugin.vala"
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
#line 181 "chromium-plugin.vala"
		(_data_->folders == NULL) ? NULL : (_data_->folders = (g_list_free (_data_->folders), NULL));
#line 181 "chromium-plugin.vala"
		_g_object_unref0 (_data_->UNWANTED_SCHEME);
#line 181 "chromium-plugin.vala"
		_g_free0 (_data_->CONTAINER);
#line 181 "chromium-plugin.vala"
		_g_free0 (_data_->fpath);
#line 181 "chromium-plugin.vala"
		_g_object_unref0 (_data_->parser);
#line 181 "chromium-plugin.vala"
		_g_object_unref0 (_data_->bookmarks);
#line 181 "chromium-plugin.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
#line 181 "chromium-plugin.vala"
		g_clear_error (&_data_->_inner_error0_);
#line 181 "chromium-plugin.vala"
		g_object_unref (_data_->_async_result);
#line 181 "chromium-plugin.vala"
		return FALSE;
#line 1283 "chromium-plugin.c"
	}
#line 215 "chromium-plugin.vala"
	_data_->_tmp56_ = _data_->self->priv->bookmarks_once;
#line 215 "chromium-plugin.vala"
	_data_->_tmp57_ = _data_->bookmarks;
#line 215 "chromium-plugin.vala"
	synapse_utils_async_once_leave (_data_->_tmp56_, (GeeList*) _data_->_tmp57_);
#line 163 "chromium-plugin.vala"
	(_data_->folders == NULL) ? NULL : (_data_->folders = (g_list_free (_data_->folders), NULL));
#line 163 "chromium-plugin.vala"
	_g_object_unref0 (_data_->UNWANTED_SCHEME);
#line 163 "chromium-plugin.vala"
	_g_free0 (_data_->CONTAINER);
#line 163 "chromium-plugin.vala"
	_g_free0 (_data_->fpath);
#line 163 "chromium-plugin.vala"
	_g_object_unref0 (_data_->parser);
#line 163 "chromium-plugin.vala"
	_g_object_unref0 (_data_->bookmarks);
#line 163 "chromium-plugin.vala"
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 163 "chromium-plugin.vala"
	if (_data_->_state_ != 0) {
#line 163 "chromium-plugin.vala"
		while (!g_task_get_completed (_data_->_async_result)) {
#line 163 "chromium-plugin.vala"
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 1311 "chromium-plugin.c"
		}
	}
#line 163 "chromium-plugin.vala"
	g_object_unref (_data_->_async_result);
#line 163 "chromium-plugin.vala"
	return FALSE;
#line 1318 "chromium-plugin.c"
}

SynapseChromiumPlugin*
synapse_chromium_plugin_construct (GType object_type)
{
	SynapseChromiumPlugin * self = NULL;
#line 21 "chromium-plugin.vala"
	self = (SynapseChromiumPlugin*) g_object_new (object_type, NULL);
#line 21 "chromium-plugin.vala"
	return self;
#line 1329 "chromium-plugin.c"
}

SynapseChromiumPlugin*
synapse_chromium_plugin_new (void)
{
#line 21 "chromium-plugin.vala"
	return synapse_chromium_plugin_construct (SYNAPSE_TYPE_CHROMIUM_PLUGIN);
#line 1337 "chromium-plugin.c"
}

static gboolean
synapse_chromium_plugin_real_get_enabled (SynapseActivatable* base)
{
	gboolean result;
	SynapseChromiumPlugin* self;
#line 23 "chromium-plugin.vala"
	self = (SynapseChromiumPlugin*) base;
#line 23 "chromium-plugin.vala"
	result = self->priv->_enabled;
#line 23 "chromium-plugin.vala"
	return result;
#line 1351 "chromium-plugin.c"
}

static void
synapse_chromium_plugin_real_set_enabled (SynapseActivatable* base,
                                          gboolean value)
{
	SynapseChromiumPlugin* self;
	gboolean old_value;
#line 23 "chromium-plugin.vala"
	self = (SynapseChromiumPlugin*) base;
#line 23 "chromium-plugin.vala"
	old_value = synapse_chromium_plugin_real_get_enabled (base);
#line 23 "chromium-plugin.vala"
	if (old_value != value) {
#line 23 "chromium-plugin.vala"
		self->priv->_enabled = value;
#line 23 "chromium-plugin.vala"
		g_object_notify_by_pspec ((GObject *) self, synapse_chromium_plugin_properties[SYNAPSE_CHROMIUM_PLUGIN_ENABLED_PROPERTY]);
#line 1370 "chromium-plugin.c"
	}
}

static inline gpointer
synapse_chromium_plugin_bookmark_match_get_instance_private (SynapseChromiumPluginBookmarkMatch* self)
{
	return G_STRUCT_MEMBER_P (self, SynapseChromiumPluginBookmarkMatch_private_offset);
}

static const gchar*
synapse_chromium_plugin_bookmark_match_get_title_folded (SynapseChromiumPluginBookmarkMatch* self)
{
	const gchar* _tmp0_;
	const gchar* _tmp4_;
	const gchar* result;
#line 40 "chromium-plugin.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 42 "chromium-plugin.vala"
	_tmp0_ = self->priv->title_folded;
#line 42 "chromium-plugin.vala"
	if (_tmp0_ == NULL) {
#line 1392 "chromium-plugin.c"
		const gchar* _tmp1_;
		const gchar* _tmp2_;
		gchar* _tmp3_;
#line 42 "chromium-plugin.vala"
		_tmp1_ = synapse_match_get_title ((SynapseMatch*) self);
#line 42 "chromium-plugin.vala"
		_tmp2_ = _tmp1_;
#line 42 "chromium-plugin.vala"
		_tmp3_ = g_utf8_casefold (_tmp2_, (gssize) -1);
#line 42 "chromium-plugin.vala"
		_g_free0 (self->priv->title_folded);
#line 42 "chromium-plugin.vala"
		self->priv->title_folded = _tmp3_;
#line 1406 "chromium-plugin.c"
	}
#line 43 "chromium-plugin.vala"
	_tmp4_ = self->priv->title_folded;
#line 43 "chromium-plugin.vala"
	result = _tmp4_;
#line 43 "chromium-plugin.vala"
	return result;
#line 1414 "chromium-plugin.c"
}

static const gchar*
synapse_chromium_plugin_bookmark_match_get_uri_folded (SynapseChromiumPluginBookmarkMatch* self)
{
	const gchar* _tmp0_;
	const gchar* _tmp4_;
	const gchar* result;
#line 46 "chromium-plugin.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 48 "chromium-plugin.vala"
	_tmp0_ = self->priv->uri_folded;
#line 48 "chromium-plugin.vala"
	if (_tmp0_ == NULL) {
#line 1429 "chromium-plugin.c"
		const gchar* _tmp1_;
		const gchar* _tmp2_;
		gchar* _tmp3_;
#line 48 "chromium-plugin.vala"
		_tmp1_ = synapse_uri_match_get_uri ((SynapseUriMatch*) self);
#line 48 "chromium-plugin.vala"
		_tmp2_ = _tmp1_;
#line 48 "chromium-plugin.vala"
		_tmp3_ = g_utf8_casefold (_tmp2_, (gssize) -1);
#line 48 "chromium-plugin.vala"
		_g_free0 (self->priv->uri_folded);
#line 48 "chromium-plugin.vala"
		self->priv->uri_folded = _tmp3_;
#line 1443 "chromium-plugin.c"
	}
#line 49 "chromium-plugin.vala"
	_tmp4_ = self->priv->uri_folded;
#line 49 "chromium-plugin.vala"
	result = _tmp4_;
#line 49 "chromium-plugin.vala"
	return result;
#line 1451 "chromium-plugin.c"
}

static SynapseChromiumPluginBookmarkMatch*
synapse_chromium_plugin_bookmark_match_construct_with_content (GType object_type,
                                                               const gchar* name,
                                                               const gchar* url)
{
	SynapseChromiumPluginBookmarkMatch * self = NULL;
#line 52 "chromium-plugin.vala"
	g_return_val_if_fail (name != NULL, NULL);
#line 52 "chromium-plugin.vala"
	g_return_val_if_fail (url != NULL, NULL);
#line 54 "chromium-plugin.vala"
	self = (SynapseChromiumPluginBookmarkMatch*) g_object_new (object_type, "title", name, "description", url, "uri", url, "mime-type", "text/html", "has-thumbnail", FALSE, "icon-name", "text-html", NULL);
#line 52 "chromium-plugin.vala"
	return self;
#line 1468 "chromium-plugin.c"
}

static SynapseChromiumPluginBookmarkMatch*
synapse_chromium_plugin_bookmark_match_new_with_content (const gchar* name,
                                                         const gchar* url)
{
#line 52 "chromium-plugin.vala"
	return synapse_chromium_plugin_bookmark_match_construct_with_content (SYNAPSE_CHROMIUM_PLUGIN_TYPE_BOOKMARK_MATCH, name, url);
#line 1477 "chromium-plugin.c"
}

static SynapseChromiumPluginBookmarkMatch*
synapse_chromium_plugin_bookmark_match_construct (GType object_type)
{
	SynapseChromiumPluginBookmarkMatch * self = NULL;
#line 35 "chromium-plugin.vala"
	self = (SynapseChromiumPluginBookmarkMatch*) synapse_uri_match_construct (object_type);
#line 35 "chromium-plugin.vala"
	return self;
#line 1488 "chromium-plugin.c"
}

static SynapseChromiumPluginBookmarkMatch*
synapse_chromium_plugin_bookmark_match_new (void)
{
#line 35 "chromium-plugin.vala"
	return synapse_chromium_plugin_bookmark_match_construct (SYNAPSE_CHROMIUM_PLUGIN_TYPE_BOOKMARK_MATCH);
#line 1496 "chromium-plugin.c"
}

static void
synapse_chromium_plugin_bookmark_match_class_init (SynapseChromiumPluginBookmarkMatchClass * klass,
                                                   gpointer klass_data)
{
#line 35 "chromium-plugin.vala"
	synapse_chromium_plugin_bookmark_match_parent_class = g_type_class_peek_parent (klass);
#line 35 "chromium-plugin.vala"
	g_type_class_adjust_private_offset (klass, &SynapseChromiumPluginBookmarkMatch_private_offset);
#line 35 "chromium-plugin.vala"
	G_OBJECT_CLASS (klass)->finalize = synapse_chromium_plugin_bookmark_match_finalize;
#line 1509 "chromium-plugin.c"
}

static void
synapse_chromium_plugin_bookmark_match_instance_init (SynapseChromiumPluginBookmarkMatch * self,
                                                      gpointer klass)
{
#line 35 "chromium-plugin.vala"
	self->priv = synapse_chromium_plugin_bookmark_match_get_instance_private (self);
#line 37 "chromium-plugin.vala"
	self->priv->title_folded = NULL;
#line 38 "chromium-plugin.vala"
	self->priv->uri_folded = NULL;
#line 1522 "chromium-plugin.c"
}

static void
synapse_chromium_plugin_bookmark_match_finalize (GObject * obj)
{
	SynapseChromiumPluginBookmarkMatch * self;
#line 35 "chromium-plugin.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SYNAPSE_CHROMIUM_PLUGIN_TYPE_BOOKMARK_MATCH, SynapseChromiumPluginBookmarkMatch);
#line 37 "chromium-plugin.vala"
	_g_free0 (self->priv->title_folded);
#line 38 "chromium-plugin.vala"
	_g_free0 (self->priv->uri_folded);
#line 35 "chromium-plugin.vala"
	G_OBJECT_CLASS (synapse_chromium_plugin_bookmark_match_parent_class)->finalize (obj);
#line 1537 "chromium-plugin.c"
}

static GType
synapse_chromium_plugin_bookmark_match_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SynapseChromiumPluginBookmarkMatchClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) synapse_chromium_plugin_bookmark_match_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SynapseChromiumPluginBookmarkMatch), 0, (GInstanceInitFunc) synapse_chromium_plugin_bookmark_match_instance_init, NULL };
	GType synapse_chromium_plugin_bookmark_match_type_id;
	synapse_chromium_plugin_bookmark_match_type_id = g_type_register_static (SYNAPSE_TYPE_URI_MATCH, "SynapseChromiumPluginBookmarkMatch", &g_define_type_info, 0);
	SynapseChromiumPluginBookmarkMatch_private_offset = g_type_add_instance_private (synapse_chromium_plugin_bookmark_match_type_id, sizeof (SynapseChromiumPluginBookmarkMatchPrivate));
	return synapse_chromium_plugin_bookmark_match_type_id;
}

static GType
synapse_chromium_plugin_bookmark_match_get_type (void)
{
	static volatile gsize synapse_chromium_plugin_bookmark_match_type_id__once = 0;
	if (g_once_init_enter (&synapse_chromium_plugin_bookmark_match_type_id__once)) {
		GType synapse_chromium_plugin_bookmark_match_type_id;
		synapse_chromium_plugin_bookmark_match_type_id = synapse_chromium_plugin_bookmark_match_get_type_once ();
		g_once_init_leave (&synapse_chromium_plugin_bookmark_match_type_id__once, synapse_chromium_plugin_bookmark_match_type_id);
	}
	return synapse_chromium_plugin_bookmark_match_type_id__once;
}

static GObject *
synapse_chromium_plugin_constructor (GType type,
                                     guint n_construct_properties,
                                     GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	SynapseChromiumPlugin * self;
	SynapseUtilsAsyncOnce* _tmp0_;
#line 82 "chromium-plugin.vala"
	parent_class = G_OBJECT_CLASS (synapse_chromium_plugin_parent_class);
#line 82 "chromium-plugin.vala"
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
#line 82 "chromium-plugin.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SYNAPSE_TYPE_CHROMIUM_PLUGIN, SynapseChromiumPlugin);
#line 84 "chromium-plugin.vala"
	_tmp0_ = synapse_utils_async_once_new (GEE_TYPE_LIST, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref);
#line 84 "chromium-plugin.vala"
	_synapse_utils_async_once_unref0 (self->priv->bookmarks_once);
#line 84 "chromium-plugin.vala"
	self->priv->bookmarks_once = _tmp0_;
#line 82 "chromium-plugin.vala"
	return obj;
#line 1585 "chromium-plugin.c"
}

static void
synapse_chromium_plugin_class_init (SynapseChromiumPluginClass * klass,
                                    gpointer klass_data)
{
#line 21 "chromium-plugin.vala"
	synapse_chromium_plugin_parent_class = g_type_class_peek_parent (klass);
#line 21 "chromium-plugin.vala"
	g_type_class_adjust_private_offset (klass, &SynapseChromiumPlugin_private_offset);
#line 21 "chromium-plugin.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_synapse_chromium_plugin_get_property;
#line 21 "chromium-plugin.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_synapse_chromium_plugin_set_property;
#line 21 "chromium-plugin.vala"
	G_OBJECT_CLASS (klass)->constructor = synapse_chromium_plugin_constructor;
#line 21 "chromium-plugin.vala"
	G_OBJECT_CLASS (klass)->finalize = synapse_chromium_plugin_finalize;
#line 21 "chromium-plugin.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_CHROMIUM_PLUGIN_ENABLED_PROPERTY, synapse_chromium_plugin_properties[SYNAPSE_CHROMIUM_PLUGIN_ENABLED_PROPERTY] = g_param_spec_boolean ("enabled", "enabled", "enabled", TRUE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 77 "chromium-plugin.vala"
	synapse_chromium_plugin_register_plugin ();
#line 1608 "chromium-plugin.c"
}

static void
synapse_chromium_plugin_synapse_activatable_interface_init (SynapseActivatableIface * iface,
                                                            gpointer iface_data)
{
#line 21 "chromium-plugin.vala"
	synapse_chromium_plugin_synapse_activatable_parent_iface = g_type_interface_peek_parent (iface);
#line 21 "chromium-plugin.vala"
	iface->activate = (void (*) (SynapseActivatable*)) synapse_chromium_plugin_real_activate;
#line 21 "chromium-plugin.vala"
	iface->deactivate = (void (*) (SynapseActivatable*)) synapse_chromium_plugin_real_deactivate;
#line 21 "chromium-plugin.vala"
	iface->get_enabled = synapse_chromium_plugin_real_get_enabled;
#line 21 "chromium-plugin.vala"
	iface->set_enabled = synapse_chromium_plugin_real_set_enabled;
#line 1625 "chromium-plugin.c"
}

static void
synapse_chromium_plugin_synapse_item_provider_interface_init (SynapseItemProviderIface * iface,
                                                              gpointer iface_data)
{
#line 21 "chromium-plugin.vala"
	synapse_chromium_plugin_synapse_item_provider_parent_iface = g_type_interface_peek_parent (iface);
#line 21 "chromium-plugin.vala"
	iface->handles_query = (gboolean (*) (SynapseItemProvider*, SynapseQuery*)) synapse_chromium_plugin_real_handles_query;
#line 21 "chromium-plugin.vala"
	iface->search = (void (*) (SynapseItemProvider*, SynapseQuery*, GAsyncReadyCallback, gpointer)) synapse_chromium_plugin_real_search;
#line 21 "chromium-plugin.vala"
	iface->search_finish = (SynapseResultSet* (*) (SynapseItemProvider*, GAsyncResult*, GError**)) synapse_chromium_plugin_search_finish;
#line 1640 "chromium-plugin.c"
}

static void
synapse_chromium_plugin_instance_init (SynapseChromiumPlugin * self,
                                       gpointer klass)
{
#line 21 "chromium-plugin.vala"
	self->priv = synapse_chromium_plugin_get_instance_private (self);
#line 23 "chromium-plugin.vala"
	self->priv->_enabled = TRUE;
#line 1651 "chromium-plugin.c"
}

static void
synapse_chromium_plugin_finalize (GObject * obj)
{
	SynapseChromiumPlugin * self;
#line 21 "chromium-plugin.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SYNAPSE_TYPE_CHROMIUM_PLUGIN, SynapseChromiumPlugin);
#line 80 "chromium-plugin.vala"
	_synapse_utils_async_once_unref0 (self->priv->bookmarks_once);
#line 21 "chromium-plugin.vala"
	G_OBJECT_CLASS (synapse_chromium_plugin_parent_class)->finalize (obj);
#line 1664 "chromium-plugin.c"
}

static GType
synapse_chromium_plugin_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SynapseChromiumPluginClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) synapse_chromium_plugin_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SynapseChromiumPlugin), 0, (GInstanceInitFunc) synapse_chromium_plugin_instance_init, NULL };
	static const GInterfaceInfo synapse_activatable_info = { (GInterfaceInitFunc) synapse_chromium_plugin_synapse_activatable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	static const GInterfaceInfo synapse_item_provider_info = { (GInterfaceInitFunc) synapse_chromium_plugin_synapse_item_provider_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType synapse_chromium_plugin_type_id;
	synapse_chromium_plugin_type_id = g_type_register_static (G_TYPE_OBJECT, "SynapseChromiumPlugin", &g_define_type_info, 0);
	g_type_add_interface_static (synapse_chromium_plugin_type_id, SYNAPSE_TYPE_ACTIVATABLE, &synapse_activatable_info);
	g_type_add_interface_static (synapse_chromium_plugin_type_id, SYNAPSE_TYPE_ITEM_PROVIDER, &synapse_item_provider_info);
	SynapseChromiumPlugin_private_offset = g_type_add_instance_private (synapse_chromium_plugin_type_id, sizeof (SynapseChromiumPluginPrivate));
	return synapse_chromium_plugin_type_id;
}

GType
synapse_chromium_plugin_get_type (void)
{
	static volatile gsize synapse_chromium_plugin_type_id__once = 0;
	if (g_once_init_enter (&synapse_chromium_plugin_type_id__once)) {
		GType synapse_chromium_plugin_type_id;
		synapse_chromium_plugin_type_id = synapse_chromium_plugin_get_type_once ();
		g_once_init_leave (&synapse_chromium_plugin_type_id__once, synapse_chromium_plugin_type_id);
	}
	return synapse_chromium_plugin_type_id__once;
}

static void
_vala_synapse_chromium_plugin_get_property (GObject * object,
                                            guint property_id,
                                            GValue * value,
                                            GParamSpec * pspec)
{
	SynapseChromiumPlugin * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SYNAPSE_TYPE_CHROMIUM_PLUGIN, SynapseChromiumPlugin);
#line 21 "chromium-plugin.vala"
	switch (property_id) {
#line 21 "chromium-plugin.vala"
		case SYNAPSE_CHROMIUM_PLUGIN_ENABLED_PROPERTY:
#line 21 "chromium-plugin.vala"
		g_value_set_boolean (value, synapse_activatable_get_enabled ((SynapseActivatable*) self));
#line 21 "chromium-plugin.vala"
		break;
#line 1709 "chromium-plugin.c"
		default:
#line 21 "chromium-plugin.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 21 "chromium-plugin.vala"
		break;
#line 1715 "chromium-plugin.c"
	}
}

static void
_vala_synapse_chromium_plugin_set_property (GObject * object,
                                            guint property_id,
                                            const GValue * value,
                                            GParamSpec * pspec)
{
	SynapseChromiumPlugin * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SYNAPSE_TYPE_CHROMIUM_PLUGIN, SynapseChromiumPlugin);
#line 21 "chromium-plugin.vala"
	switch (property_id) {
#line 21 "chromium-plugin.vala"
		case SYNAPSE_CHROMIUM_PLUGIN_ENABLED_PROPERTY:
#line 21 "chromium-plugin.vala"
		synapse_activatable_set_enabled ((SynapseActivatable*) self, g_value_get_boolean (value));
#line 21 "chromium-plugin.vala"
		break;
#line 1735 "chromium-plugin.c"
		default:
#line 21 "chromium-plugin.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 21 "chromium-plugin.vala"
		break;
#line 1741 "chromium-plugin.c"
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

