/* locate-plugin.c generated by valac 0.56.17, the Vala compiler
 * generated from locate-plugin.vala, do not modify */

/*
 * Copyright (C) 2010 Michal Hruby <michal.mhr@gmail.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301  USA.
 *
 * Authored by Michal Hruby <michal.mhr@gmail.com>
 *
 */

#include "plugins.h"
#include <glib.h>
#include <synapse-core.h>
#include <glib-object.h>
#include <glib/gi18n-lib.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <gee.h>
#include <gio/gunixinputstream.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define SYNAPSE_LOCATE_PLUGIN_TYPE_LOCATE_ITEM (synapse_locate_plugin_locate_item_get_type ())
#define SYNAPSE_LOCATE_PLUGIN_LOCATE_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_LOCATE_PLUGIN_TYPE_LOCATE_ITEM, SynapseLocatePluginLocateItem))
#define SYNAPSE_LOCATE_PLUGIN_LOCATE_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SYNAPSE_LOCATE_PLUGIN_TYPE_LOCATE_ITEM, SynapseLocatePluginLocateItemClass))
#define SYNAPSE_LOCATE_PLUGIN_IS_LOCATE_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_LOCATE_PLUGIN_TYPE_LOCATE_ITEM))
#define SYNAPSE_LOCATE_PLUGIN_IS_LOCATE_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SYNAPSE_LOCATE_PLUGIN_TYPE_LOCATE_ITEM))
#define SYNAPSE_LOCATE_PLUGIN_LOCATE_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SYNAPSE_LOCATE_PLUGIN_TYPE_LOCATE_ITEM, SynapseLocatePluginLocateItemClass))

typedef struct _SynapseLocatePluginLocateItem SynapseLocatePluginLocateItem;
typedef struct _SynapseLocatePluginLocateItemClass SynapseLocatePluginLocateItemClass;
enum  {
	SYNAPSE_LOCATE_PLUGIN_0_PROPERTY,
	SYNAPSE_LOCATE_PLUGIN_ENABLED_PROPERTY,
	SYNAPSE_LOCATE_PLUGIN_NUM_PROPERTIES
};
static GParamSpec* synapse_locate_plugin_properties[SYNAPSE_LOCATE_PLUGIN_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _synapse_utils_file_info_unref0(var) ((var == NULL) ? NULL : (var = (synapse_utils_file_info_unref (var), NULL)))
typedef struct _SynapseLocatePluginLocateData SynapseLocatePluginLocateData;
typedef struct _SynapseLocatePluginLocateItemPrivate SynapseLocatePluginLocateItemPrivate;
enum  {
	SYNAPSE_LOCATE_PLUGIN_LOCATE_ITEM_0_PROPERTY,
	SYNAPSE_LOCATE_PLUGIN_LOCATE_ITEM_DEFAULT_RELEVANCY_PROPERTY,
	SYNAPSE_LOCATE_PLUGIN_LOCATE_ITEM_NUM_PROPERTIES
};
static GParamSpec* synapse_locate_plugin_locate_item_properties[SYNAPSE_LOCATE_PLUGIN_LOCATE_ITEM_NUM_PROPERTIES];
typedef struct _SynapseLocatePluginLocateItemSearchData SynapseLocatePluginLocateItemSearchData;

struct _SynapseLocatePluginPrivate {
	gboolean _enabled;
	SynapseLocatePluginLocateItem* action;
};

struct _SynapseLocatePluginLocateData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	SynapseLocatePlugin* self;
	SynapseQuery q;
	SynapseResultSet* result;
	SynapseQueryFlags our_results;
	SynapseQueryFlags common_flags;
	SynapseQuery _tmp0_;
	SynapseQuery _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gboolean _tmp4_;
	SynapseQuery _tmp5_;
	const gchar* _tmp6_;
	gchar* regex;
	SynapseQuery _tmp7_;
	const gchar* _tmp8_;
	gchar* _tmp9_;
	gchar** argv;
	gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	SynapseQuery _tmp13_;
	gchar* _tmp14_;
	const gchar* _tmp15_;
	gchar* _tmp16_;
	gchar* _tmp17_;
	gchar* _tmp18_;
	gchar** _tmp19_;
	gchar** _tmp20_;
	gint _tmp20__length1;
	gint argv_length1;
	gint _argv_size_;
	GeeSet* uris;
	GeeHashSet* _tmp21_;
	GPid pid;
	gint read_fd;
	gchar** _tmp22_;
	gint _tmp22__length1;
	GPid _tmp23_;
	gint _tmp24_;
	GUnixInputStream* read_stream;
	GUnixInputStream* _tmp25_;
	GDataInputStream* locate_output;
	GUnixInputStream* _tmp26_;
	GDataInputStream* _tmp27_;
	gchar* line;
	GRegex* filter_re;
	GRegex* _tmp28_;
	gboolean _tmp29_;
	const gchar* _tmp30_;
	gchar* _tmp31_;
	GDataInputStream* _tmp32_;
	SynapseQuery _tmp33_;
	GCancellable* _tmp34_;
	gchar* _tmp35_;
	gchar* _tmp36_;
	const gchar* _tmp37_;
	GRegex* _tmp38_;
	const gchar* _tmp39_;
	GFile* file;
	const gchar* _tmp40_;
	GFile* _tmp41_;
	GeeSet* _tmp42_;
	GFile* _tmp43_;
	gchar* _tmp44_;
	gchar* _tmp45_;
	GError* err;
	GError* _tmp46_;
	const gchar* _tmp47_;
	SynapseResultSet* _result_;
	SynapseResultSet* _tmp48_;
	GeeIterator* _s_it;
	GeeSet* _tmp49_;
	GeeIterator* _tmp50_;
	GeeIterator* _tmp51_;
	gchar* s;
	GeeIterator* _tmp52_;
	gpointer _tmp53_;
	SynapseUtilsFileInfo* fi;
	const gchar* _tmp54_;
	SynapseUtilsFileInfo* _tmp55_;
	SynapseUtilsFileInfo* _tmp56_;
	gboolean _tmp57_;
	SynapseUtilsFileInfo* _tmp58_;
	SynapseUriMatch* _tmp59_;
	SynapseUtilsFileInfo* _tmp60_;
	SynapseQuery _tmp61_;
	gint relevancy;
	SynapseUtilsFileInfo* _tmp62_;
	const gchar* _tmp63_;
	SynapseResultSet* _tmp64_;
	SynapseUtilsFileInfo* _tmp65_;
	SynapseUriMatch* _tmp66_;
	GError* _inner_error0_;
};

struct _SynapseLocatePluginLocateItem {
	SynapseSearchMatch parent_instance;
	SynapseLocatePluginLocateItemPrivate * priv;
};

struct _SynapseLocatePluginLocateItemClass {
	SynapseSearchMatchClass parent_class;
};

struct _SynapseLocatePluginLocateItemPrivate {
	gint _default_relevancy;
	SynapseLocatePlugin* plugin;
};

struct _SynapseLocatePluginLocateItemSearchData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	SynapseLocatePluginLocateItem* self;
	gchar* query;
	SynapseQueryFlags flags;
	SynapseResultSet* dest_result_set;
	GCancellable* cancellable;
	GeeList* result;
	SynapseQuery q;
	GCancellable* _tmp0_;
	SynapseResultSet* results;
	SynapseLocatePlugin* _tmp1_;
	SynapseQuery _tmp2_;
	SynapseResultSet* _tmp3_;
	GeeList* _tmp4_;
	GError* _inner_error0_;
};

static gint SynapseLocatePlugin_private_offset;
static gpointer synapse_locate_plugin_parent_class = NULL;
static gint SynapseLocatePluginLocateItem_private_offset;
static gpointer synapse_locate_plugin_locate_item_parent_class = NULL;
static SynapseActivatableIface * synapse_locate_plugin_synapse_activatable_parent_iface = NULL;
static SynapseActionProviderIface * synapse_locate_plugin_synapse_action_provider_parent_iface = NULL;

static GType synapse_locate_plugin_locate_item_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
static void synapse_locate_plugin_real_activate (SynapseActivatable* base);
static void synapse_locate_plugin_real_deactivate (SynapseActivatable* base);
static void synapse_locate_plugin_register_plugin (void);
static void _synapse_locate_plugin_register_plugin_synapse_plugin_register_func (void);
static gboolean synapse_locate_plugin_real_handles_unknown (SynapseActionProvider* base);
static void synapse_locate_plugin_locate_data_free (gpointer _data);
static gboolean synapse_locate_plugin_locate_co (SynapseLocatePluginLocateData* _data_);
static void synapse_locate_plugin_locate_ready (GObject* source_object,
                                         GAsyncResult* _res_,
                                         gpointer _user_data_);
static SynapseResultSet* synapse_locate_plugin_real_find_for_match (SynapseActionProvider* base,
                                                             SynapseQuery* q,
                                                             SynapseMatch* match);
static gint synapse_locate_plugin_locate_item_get_default_relevancy (SynapseLocatePluginLocateItem* self);
static void synapse_locate_plugin_locate_item_real_search_data_free (gpointer _data);
static void synapse_locate_plugin_locate_item_real_search (SynapseSearchMatch* base,
                                                    const gchar* query,
                                                    SynapseQueryFlags flags,
                                                    SynapseResultSet* dest_result_set,
                                                    GCancellable* cancellable,
                                                    GAsyncReadyCallback _callback_,
                                                    gpointer _user_data_);
static gboolean synapse_locate_plugin_locate_item_real_search_co (SynapseLocatePluginLocateItemSearchData* _data_);
static void synapse_locate_plugin_locate_item_search_ready (GObject* source_object,
                                                     GAsyncResult* _res_,
                                                     gpointer _user_data_);
static SynapseLocatePluginLocateItem* synapse_locate_plugin_locate_item_new (SynapseLocatePlugin* plugin);
static SynapseLocatePluginLocateItem* synapse_locate_plugin_locate_item_construct (GType object_type,
                                                                            SynapseLocatePlugin* plugin);
static void synapse_locate_plugin_locate_item_set_default_relevancy (SynapseLocatePluginLocateItem* self,
                                                              gint value);
static void synapse_locate_plugin_locate_item_finalize (GObject * obj);
static GType synapse_locate_plugin_locate_item_get_type_once (void);
static void _vala_synapse_locate_plugin_locate_item_get_property (GObject * object,
                                                           guint property_id,
                                                           GValue * value,
                                                           GParamSpec * pspec);
static void _vala_synapse_locate_plugin_locate_item_set_property (GObject * object,
                                                           guint property_id,
                                                           const GValue * value,
                                                           GParamSpec * pspec);
static GObject * synapse_locate_plugin_constructor (GType type,
                                             guint n_construct_properties,
                                             GObjectConstructParam * construct_properties);
static void synapse_locate_plugin_finalize (GObject * obj);
static GType synapse_locate_plugin_get_type_once (void);
static void _vala_synapse_locate_plugin_get_property (GObject * object,
                                               guint property_id,
                                               GValue * value,
                                               GParamSpec * pspec);
static void _vala_synapse_locate_plugin_set_property (GObject * object,
                                               guint property_id,
                                               const GValue * value,
                                               GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

static inline gpointer
synapse_locate_plugin_get_instance_private (SynapseLocatePlugin* self)
{
	return G_STRUCT_MEMBER_P (self, SynapseLocatePlugin_private_offset);
}

static void
synapse_locate_plugin_real_activate (SynapseActivatable* base)
{
	SynapseLocatePlugin * self;
#line 28 "locate-plugin.vala"
	self = (SynapseLocatePlugin*) base;
#line 297 "locate-plugin.c"
}

static void
synapse_locate_plugin_real_deactivate (SynapseActivatable* base)
{
	SynapseLocatePlugin * self;
#line 33 "locate-plugin.vala"
	self = (SynapseLocatePlugin*) base;
#line 306 "locate-plugin.c"
}

static void
_synapse_locate_plugin_register_plugin_synapse_plugin_register_func (void)
{
#line 70 "locate-plugin.vala"
	synapse_locate_plugin_register_plugin ();
#line 314 "locate-plugin.c"
}

static void
synapse_locate_plugin_register_plugin (void)
{
	SynapsePluginRegistry* _tmp0_;
	SynapsePluginRegistry* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
#line 70 "locate-plugin.vala"
	_tmp0_ = synapse_plugin_registry_get_default ();
#line 70 "locate-plugin.vala"
	_tmp1_ = _tmp0_;
#line 70 "locate-plugin.vala"
	_tmp2_ = g_find_program_in_path ("locate");
#line 70 "locate-plugin.vala"
	_tmp3_ = _tmp2_;
#line 70 "locate-plugin.vala"
	synapse_plugin_registry_register_plugin (_tmp1_, SYNAPSE_TYPE_LOCATE_PLUGIN, _ ("Locate"), _ ("Runs locate command to find files on the filesystem."), "search", _synapse_locate_plugin_register_plugin_synapse_plugin_register_func, _tmp3_ != NULL, _ ("Unable to find \"locate\" binary"));
#line 70 "locate-plugin.vala"
	_g_free0 (_tmp3_);
#line 70 "locate-plugin.vala"
	_g_object_unref0 (_tmp1_);
#line 338 "locate-plugin.c"
}

static gboolean
synapse_locate_plugin_real_handles_unknown (SynapseActionProvider* base)
{
	SynapseLocatePlugin * self;
	gboolean result;
#line 93 "locate-plugin.vala"
	self = (SynapseLocatePlugin*) base;
#line 95 "locate-plugin.vala"
	result = TRUE;
#line 95 "locate-plugin.vala"
	return result;
#line 352 "locate-plugin.c"
}

static void
synapse_locate_plugin_locate_data_free (gpointer _data)
{
	SynapseLocatePluginLocateData* _data_;
	_data_ = _data;
#line 24 "locate-plugin.vala"
	synapse_query_destroy (&_data_->q);
#line 24 "locate-plugin.vala"
	_g_object_unref0 (_data_->result);
#line 24 "locate-plugin.vala"
	_g_object_unref0 (_data_->self);
#line 24 "locate-plugin.vala"
	g_slice_free (SynapseLocatePluginLocateData, _data_);
#line 368 "locate-plugin.c"
}

static gpointer
_g_object_ref0 (gpointer self)
{
#line 24 "locate-plugin.vala"
	return self ? g_object_ref (self) : NULL;
#line 376 "locate-plugin.c"
}

void
synapse_locate_plugin_locate (SynapseLocatePlugin* self,
                              SynapseQuery* q,
                              GAsyncReadyCallback _callback_,
                              gpointer _user_data_)
{
	SynapseLocatePluginLocateData* _data_;
	SynapseLocatePlugin* _tmp0_;
	SynapseQuery _tmp1_;
	SynapseQuery _tmp2_;
	SynapseQuery _tmp3_ = {0};
#line 24 "locate-plugin.vala"
	g_return_if_fail (self != NULL);
#line 24 "locate-plugin.vala"
	g_return_if_fail (q != NULL);
#line 24 "locate-plugin.vala"
	_data_ = g_slice_new0 (SynapseLocatePluginLocateData);
#line 24 "locate-plugin.vala"
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
#line 24 "locate-plugin.vala"
	g_task_set_task_data (_data_->_async_result, _data_, synapse_locate_plugin_locate_data_free);
#line 24 "locate-plugin.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 24 "locate-plugin.vala"
	_data_->self = _tmp0_;
#line 24 "locate-plugin.vala"
	_tmp1_ = *q;
#line 24 "locate-plugin.vala"
	_tmp2_ = _tmp1_;
#line 24 "locate-plugin.vala"
	synapse_query_copy (&_tmp2_, &_tmp3_);
#line 24 "locate-plugin.vala"
	synapse_query_destroy (&_data_->q);
#line 24 "locate-plugin.vala"
	_data_->q = _tmp3_;
#line 24 "locate-plugin.vala"
	synapse_locate_plugin_locate_co (_data_);
#line 416 "locate-plugin.c"
}

SynapseResultSet*
synapse_locate_plugin_locate_finish (SynapseLocatePlugin* self,
                                     GAsyncResult* _res_,
                                     GError** error)
{
	SynapseResultSet* result;
	SynapseLocatePluginLocateData* _data_;
#line 24 "locate-plugin.vala"
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
#line 24 "locate-plugin.vala"
	if (NULL == _data_) {
#line 24 "locate-plugin.vala"
		return NULL;
#line 432 "locate-plugin.c"
	}
#line 24 "locate-plugin.vala"
	result = _data_->result;
#line 24 "locate-plugin.vala"
	_data_->result = NULL;
#line 24 "locate-plugin.vala"
	return result;
#line 440 "locate-plugin.c"
}

static gchar*
string_strip (const gchar* self)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* result;
#line 1413 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1414 "glib-2.0.vapi"
	_tmp0_ = g_strdup (self);
#line 1414 "glib-2.0.vapi"
	_result_ = _tmp0_;
#line 1415 "glib-2.0.vapi"
	g_strstrip (_result_);
#line 1416 "glib-2.0.vapi"
	result = _result_;
#line 1416 "glib-2.0.vapi"
	return result;
#line 461 "locate-plugin.c"
}

static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError* _inner_error0_ = NULL;
	gchar* result;
#line 1588 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1588 "glib-2.0.vapi"
	g_return_val_if_fail (old != NULL, NULL);
#line 1588 "glib-2.0.vapi"
	g_return_val_if_fail (replacement != NULL, NULL);
#line 1589 "glib-2.0.vapi"
	if ((*((gchar*) self)) == '\0') {
#line 1589 "glib-2.0.vapi"
		_tmp1_ = TRUE;
#line 483 "locate-plugin.c"
	} else {
#line 1589 "glib-2.0.vapi"
		_tmp1_ = (*((gchar*) old)) == '\0';
#line 487 "locate-plugin.c"
	}
#line 1589 "glib-2.0.vapi"
	if (_tmp1_) {
#line 1589 "glib-2.0.vapi"
		_tmp0_ = TRUE;
#line 493 "locate-plugin.c"
	} else {
#line 1589 "glib-2.0.vapi"
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
#line 497 "locate-plugin.c"
	}
#line 1589 "glib-2.0.vapi"
	if (_tmp0_) {
#line 501 "locate-plugin.c"
		gchar* _tmp2_;
#line 1590 "glib-2.0.vapi"
		_tmp2_ = g_strdup (self);
#line 1590 "glib-2.0.vapi"
		result = _tmp2_;
#line 1590 "glib-2.0.vapi"
		return result;
#line 509 "locate-plugin.c"
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
#line 1593 "glib-2.0.vapi"
		_tmp3_ = g_regex_escape_string (old, -1);
#line 1593 "glib-2.0.vapi"
		_tmp4_ = _tmp3_;
#line 1593 "glib-2.0.vapi"
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error0_);
#line 1593 "glib-2.0.vapi"
		_tmp6_ = _tmp5_;
#line 1593 "glib-2.0.vapi"
		_g_free0 (_tmp4_);
#line 1593 "glib-2.0.vapi"
		regex = _tmp6_;
#line 1593 "glib-2.0.vapi"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 1593 "glib-2.0.vapi"
			if (_inner_error0_->domain == G_REGEX_ERROR) {
#line 537 "locate-plugin.c"
				goto __catch0_g_regex_error;
			}
#line 1593 "glib-2.0.vapi"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 1593 "glib-2.0.vapi"
			g_clear_error (&_inner_error0_);
#line 1593 "glib-2.0.vapi"
			return NULL;
#line 546 "locate-plugin.c"
		}
#line 1594 "glib-2.0.vapi"
		_tmp8_ = regex;
#line 1594 "glib-2.0.vapi"
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error0_);
#line 1594 "glib-2.0.vapi"
		_tmp7_ = _tmp9_;
#line 1594 "glib-2.0.vapi"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 1594 "glib-2.0.vapi"
			_g_regex_unref0 (regex);
#line 1594 "glib-2.0.vapi"
			if (_inner_error0_->domain == G_REGEX_ERROR) {
#line 560 "locate-plugin.c"
				goto __catch0_g_regex_error;
			}
#line 1594 "glib-2.0.vapi"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 1594 "glib-2.0.vapi"
			g_clear_error (&_inner_error0_);
#line 1594 "glib-2.0.vapi"
			return NULL;
#line 569 "locate-plugin.c"
		}
#line 1594 "glib-2.0.vapi"
		_tmp10_ = _tmp7_;
#line 1594 "glib-2.0.vapi"
		_tmp7_ = NULL;
#line 1594 "glib-2.0.vapi"
		result = _tmp10_;
#line 1594 "glib-2.0.vapi"
		_g_free0 (_tmp7_);
#line 1594 "glib-2.0.vapi"
		_g_regex_unref0 (regex);
#line 1594 "glib-2.0.vapi"
		return result;
#line 583 "locate-plugin.c"
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
#line 1592 "glib-2.0.vapi"
		g_clear_error (&_inner_error0_);
#line 1596 "glib-2.0.vapi"
		g_assert_not_reached ();
#line 592 "locate-plugin.c"
	}
	__finally0:
#line 1592 "glib-2.0.vapi"
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 1592 "glib-2.0.vapi"
	g_clear_error (&_inner_error0_);
#line 1592 "glib-2.0.vapi"
	return NULL;
#line 601 "locate-plugin.c"
}

static void
synapse_locate_plugin_locate_ready (GObject* source_object,
                                    GAsyncResult* _res_,
                                    gpointer _user_data_)
{
	SynapseLocatePluginLocateData* _data_;
#line 136 "locate-plugin.vala"
	_data_ = _user_data_;
#line 136 "locate-plugin.vala"
	_data_->_source_object_ = source_object;
#line 136 "locate-plugin.vala"
	_data_->_res_ = _res_;
#line 136 "locate-plugin.vala"
	synapse_locate_plugin_locate_co (_data_);
#line 618 "locate-plugin.c"
}

static gboolean
synapse_locate_plugin_locate_co (SynapseLocatePluginLocateData* _data_)
{
#line 98 "locate-plugin.vala"
	switch (_data_->_state_) {
#line 98 "locate-plugin.vala"
		case 0:
#line 628 "locate-plugin.c"
		goto _state_0;
#line 98 "locate-plugin.vala"
		case 1:
#line 632 "locate-plugin.c"
		goto _state_1;
#line 98 "locate-plugin.vala"
		case 2:
#line 636 "locate-plugin.c"
		goto _state_2;
		default:
#line 98 "locate-plugin.vala"
		g_assert_not_reached ();
#line 641 "locate-plugin.c"
	}
	_state_0:
#line 100 "locate-plugin.vala"
	_data_->our_results = (((SYNAPSE_QUERY_FLAGS_AUDIO | SYNAPSE_QUERY_FLAGS_DOCUMENTS) | SYNAPSE_QUERY_FLAGS_IMAGES) | SYNAPSE_QUERY_FLAGS_UNCATEGORIZED) | SYNAPSE_QUERY_FLAGS_VIDEO;
#line 103 "locate-plugin.vala"
	_data_->_tmp0_ = _data_->q;
#line 103 "locate-plugin.vala"
	_data_->common_flags = _data_->_tmp0_.query_type & _data_->our_results;
#line 105 "locate-plugin.vala"
	_data_->_tmp1_ = _data_->q;
#line 105 "locate-plugin.vala"
	_data_->_tmp2_ = _data_->_tmp1_.query_string;
#line 105 "locate-plugin.vala"
	_data_->_tmp3_ = string_strip (_data_->_tmp2_);
#line 105 "locate-plugin.vala"
	_g_free0 (_data_->q.query_string);
#line 105 "locate-plugin.vala"
	_data_->q.query_string = _data_->_tmp3_;
#line 107 "locate-plugin.vala"
	if (_data_->common_flags == 0) {
#line 107 "locate-plugin.vala"
		_data_->_tmp4_ = TRUE;
#line 664 "locate-plugin.c"
	} else {
#line 107 "locate-plugin.vala"
		_data_->_tmp5_ = _data_->q;
#line 107 "locate-plugin.vala"
		_data_->_tmp6_ = _data_->_tmp5_.query_string;
#line 107 "locate-plugin.vala"
		_data_->_tmp4_ = g_utf8_strlen (_data_->_tmp6_, (gssize) -1) <= 1;
#line 672 "locate-plugin.c"
	}
#line 107 "locate-plugin.vala"
	if (_data_->_tmp4_) {
#line 107 "locate-plugin.vala"
		_data_->result = NULL;
#line 107 "locate-plugin.vala"
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 107 "locate-plugin.vala"
		if (_data_->_state_ != 0) {
#line 107 "locate-plugin.vala"
			while (!g_task_get_completed (_data_->_async_result)) {
#line 107 "locate-plugin.vala"
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 686 "locate-plugin.c"
			}
		}
#line 107 "locate-plugin.vala"
		g_object_unref (_data_->_async_result);
#line 107 "locate-plugin.vala"
		return FALSE;
#line 693 "locate-plugin.c"
	}
#line 109 "locate-plugin.vala"
	synapse_query_check_cancellable (&_data_->q, &_data_->_inner_error0_);
#line 109 "locate-plugin.vala"
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
#line 109 "locate-plugin.vala"
		if (_data_->_inner_error0_->domain == SYNAPSE_SEARCH_ERROR) {
#line 109 "locate-plugin.vala"
			g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
#line 109 "locate-plugin.vala"
			g_object_unref (_data_->_async_result);
#line 109 "locate-plugin.vala"
			return FALSE;
#line 707 "locate-plugin.c"
		} else {
#line 109 "locate-plugin.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
#line 109 "locate-plugin.vala"
			g_clear_error (&_data_->_inner_error0_);
#line 109 "locate-plugin.vala"
			g_object_unref (_data_->_async_result);
#line 109 "locate-plugin.vala"
			return FALSE;
#line 717 "locate-plugin.c"
		}
	}
#line 111 "locate-plugin.vala"
	_data_->q.max_results = (guint) 256;
#line 112 "locate-plugin.vala"
	_data_->_tmp7_ = _data_->q;
#line 112 "locate-plugin.vala"
	_data_->_tmp8_ = _data_->_tmp7_.query_string;
#line 112 "locate-plugin.vala"
	_data_->_tmp9_ = g_regex_escape_string (_data_->_tmp8_, -1);
#line 112 "locate-plugin.vala"
	_data_->regex = _data_->_tmp9_;
#line 114 "locate-plugin.vala"
	_data_->_tmp10_ = g_strdup ("locate");
#line 114 "locate-plugin.vala"
	_data_->_tmp11_ = g_strdup ("-i");
#line 114 "locate-plugin.vala"
	_data_->_tmp12_ = g_strdup ("-l");
#line 114 "locate-plugin.vala"
	_data_->_tmp13_ = _data_->q;
#line 114 "locate-plugin.vala"
	_data_->_tmp14_ = g_strdup_printf ("%u", _data_->_tmp13_.max_results);
#line 114 "locate-plugin.vala"
	_data_->_tmp15_ = _data_->regex;
#line 114 "locate-plugin.vala"
	_data_->_tmp16_ = string_replace (_data_->_tmp15_, " ", "*");
#line 114 "locate-plugin.vala"
	_data_->_tmp17_ = _data_->_tmp16_;
#line 114 "locate-plugin.vala"
	_data_->_tmp18_ = g_strdup_printf ("*%s*", _data_->_tmp17_);
#line 114 "locate-plugin.vala"
	_data_->_tmp19_ = g_new0 (gchar*, 5 + 1);
#line 114 "locate-plugin.vala"
	_data_->_tmp19_[0] = _data_->_tmp10_;
#line 114 "locate-plugin.vala"
	_data_->_tmp19_[1] = _data_->_tmp11_;
#line 114 "locate-plugin.vala"
	_data_->_tmp19_[2] = _data_->_tmp12_;
#line 114 "locate-plugin.vala"
	_data_->_tmp19_[3] = _data_->_tmp14_;
#line 114 "locate-plugin.vala"
	_data_->_tmp19_[4] = _data_->_tmp18_;
#line 114 "locate-plugin.vala"
	_data_->_tmp20_ = _data_->_tmp19_;
#line 114 "locate-plugin.vala"
	_data_->_tmp20__length1 = 5;
#line 114 "locate-plugin.vala"
	_g_free0 (_data_->_tmp17_);
#line 114 "locate-plugin.vala"
	_data_->argv = _data_->_tmp20_;
#line 114 "locate-plugin.vala"
	_data_->argv_length1 = _data_->_tmp20__length1;
#line 114 "locate-plugin.vala"
	_data_->_argv_size_ = _data_->argv_length1;
#line 117 "locate-plugin.vala"
	_data_->_tmp21_ = gee_hash_set_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL, NULL, NULL, NULL);
#line 117 "locate-plugin.vala"
	_data_->uris = (GeeSet*) _data_->_tmp21_;
#line 776 "locate-plugin.c"
	{
#line 125 "locate-plugin.vala"
		_data_->_tmp22_ = _data_->argv;
#line 125 "locate-plugin.vala"
		_data_->_tmp22__length1 = _data_->argv_length1;
#line 125 "locate-plugin.vala"
		_data_->_tmp23_ = 0;
#line 125 "locate-plugin.vala"
		_data_->_tmp24_ = 0;
#line 125 "locate-plugin.vala"
		g_spawn_async_with_pipes (NULL, _data_->_tmp22_, NULL, G_SPAWN_SEARCH_PATH, NULL, NULL, &_data_->_tmp23_, NULL, &_data_->_tmp24_, NULL, &_data_->_inner_error0_);
#line 125 "locate-plugin.vala"
		_data_->pid = _data_->_tmp23_;
#line 125 "locate-plugin.vala"
		_data_->read_fd = _data_->_tmp24_;
#line 125 "locate-plugin.vala"
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
#line 794 "locate-plugin.c"
			goto __catch0_g_error;
		}
#line 129 "locate-plugin.vala"
		_data_->_tmp25_ = (GUnixInputStream*) g_unix_input_stream_new (_data_->read_fd, TRUE);
#line 129 "locate-plugin.vala"
		_data_->read_stream = _data_->_tmp25_;
#line 130 "locate-plugin.vala"
		_data_->_tmp26_ = _data_->read_stream;
#line 130 "locate-plugin.vala"
		_data_->_tmp27_ = g_data_input_stream_new ((GInputStream*) _data_->_tmp26_);
#line 130 "locate-plugin.vala"
		_data_->locate_output = _data_->_tmp27_;
#line 131 "locate-plugin.vala"
		_data_->line = NULL;
#line 133 "locate-plugin.vala"
		_data_->_tmp28_ = g_regex_new ("/\\.", 0, 0, &_data_->_inner_error0_);
#line 133 "locate-plugin.vala"
		_data_->filter_re = _data_->_tmp28_;
#line 133 "locate-plugin.vala"
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
#line 133 "locate-plugin.vala"
			_g_free0 (_data_->line);
#line 133 "locate-plugin.vala"
			_g_object_unref0 (_data_->locate_output);
#line 133 "locate-plugin.vala"
			_g_object_unref0 (_data_->read_stream);
#line 821 "locate-plugin.c"
			goto __catch0_g_error;
		}
		{
#line 134 "locate-plugin.vala"
			_data_->_tmp29_ = TRUE;
#line 134 "locate-plugin.vala"
			while (TRUE) {
#line 134 "locate-plugin.vala"
				if (!_data_->_tmp29_) {
#line 143 "locate-plugin.vala"
					_data_->_tmp30_ = _data_->line;
#line 143 "locate-plugin.vala"
					if (!(_data_->_tmp30_ != NULL)) {
#line 143 "locate-plugin.vala"
						break;
#line 837 "locate-plugin.c"
					}
				}
#line 134 "locate-plugin.vala"
				_data_->_tmp29_ = FALSE;
#line 136 "locate-plugin.vala"
				_data_->_tmp32_ = _data_->locate_output;
#line 136 "locate-plugin.vala"
				_data_->_tmp33_ = _data_->q;
#line 136 "locate-plugin.vala"
				_data_->_tmp34_ = _data_->_tmp33_.cancellable;
#line 136 "locate-plugin.vala"
				_data_->_state_ = 1;
#line 136 "locate-plugin.vala"
				g_data_input_stream_read_line_async (_data_->_tmp32_, G_PRIORITY_DEFAULT_IDLE, _data_->_tmp34_, synapse_locate_plugin_locate_ready, _data_);
#line 136 "locate-plugin.vala"
				return FALSE;
#line 854 "locate-plugin.c"
				_state_1:
#line 136 "locate-plugin.vala"
				_data_->_tmp35_ = g_data_input_stream_read_line_finish (_data_->_tmp32_, _data_->_res_, NULL, &_data_->_inner_error0_);
#line 136 "locate-plugin.vala"
				_data_->_tmp31_ = _data_->_tmp35_;
#line 136 "locate-plugin.vala"
				if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
#line 136 "locate-plugin.vala"
					_g_regex_unref0 (_data_->filter_re);
#line 136 "locate-plugin.vala"
					_g_free0 (_data_->line);
#line 136 "locate-plugin.vala"
					_g_object_unref0 (_data_->locate_output);
#line 136 "locate-plugin.vala"
					_g_object_unref0 (_data_->read_stream);
#line 870 "locate-plugin.c"
					goto __catch0_g_error;
				}
#line 136 "locate-plugin.vala"
				_data_->_tmp36_ = _data_->_tmp31_;
#line 136 "locate-plugin.vala"
				_data_->_tmp31_ = NULL;
#line 136 "locate-plugin.vala"
				_g_free0 (_data_->line);
#line 136 "locate-plugin.vala"
				_data_->line = _data_->_tmp36_;
#line 137 "locate-plugin.vala"
				_data_->_tmp37_ = _data_->line;
#line 137 "locate-plugin.vala"
				if (_data_->_tmp37_ != NULL) {
#line 139 "locate-plugin.vala"
					_data_->_tmp38_ = _data_->filter_re;
#line 139 "locate-plugin.vala"
					_data_->_tmp39_ = _data_->line;
#line 139 "locate-plugin.vala"
					if (g_regex_match (_data_->_tmp38_, _data_->_tmp39_, 0, NULL)) {
#line 139 "locate-plugin.vala"
						_g_free0 (_data_->_tmp31_);
#line 139 "locate-plugin.vala"
						continue;
#line 895 "locate-plugin.c"
					}
#line 140 "locate-plugin.vala"
					_data_->_tmp40_ = _data_->line;
#line 140 "locate-plugin.vala"
					_data_->_tmp41_ = g_file_new_for_path (_data_->_tmp40_);
#line 140 "locate-plugin.vala"
					_data_->file = _data_->_tmp41_;
#line 141 "locate-plugin.vala"
					_data_->_tmp42_ = _data_->uris;
#line 141 "locate-plugin.vala"
					_data_->_tmp43_ = _data_->file;
#line 141 "locate-plugin.vala"
					_data_->_tmp44_ = g_file_get_uri (_data_->_tmp43_);
#line 141 "locate-plugin.vala"
					_data_->_tmp45_ = _data_->_tmp44_;
#line 141 "locate-plugin.vala"
					gee_collection_add ((GeeCollection*) _data_->_tmp42_, _data_->_tmp45_);
#line 141 "locate-plugin.vala"
					_g_free0 (_data_->_tmp45_);
#line 137 "locate-plugin.vala"
					_g_object_unref0 (_data_->file);
#line 917 "locate-plugin.c"
				}
#line 134 "locate-plugin.vala"
				_g_free0 (_data_->_tmp31_);
#line 921 "locate-plugin.c"
			}
		}
#line 119 "locate-plugin.vala"
		_g_regex_unref0 (_data_->filter_re);
#line 119 "locate-plugin.vala"
		_g_free0 (_data_->line);
#line 119 "locate-plugin.vala"
		_g_object_unref0 (_data_->locate_output);
#line 119 "locate-plugin.vala"
		_g_object_unref0 (_data_->read_stream);
#line 932 "locate-plugin.c"
	}
	goto __finally0;
	__catch0_g_error:
	{
#line 119 "locate-plugin.vala"
		_data_->err = _data_->_inner_error0_;
#line 119 "locate-plugin.vala"
		_data_->_inner_error0_ = NULL;
#line 147 "locate-plugin.vala"
		if (!synapse_query_is_cancelled (&_data_->q)) {
#line 147 "locate-plugin.vala"
			_data_->_tmp46_ = _data_->err;
#line 147 "locate-plugin.vala"
			_data_->_tmp47_ = _data_->_tmp46_->message;
#line 147 "locate-plugin.vala"
			g_warning ("locate-plugin.vala:147: %s", _data_->_tmp47_);
#line 949 "locate-plugin.c"
		}
#line 119 "locate-plugin.vala"
		_g_error_free0 (_data_->err);
#line 953 "locate-plugin.c"
	}
	__finally0:
#line 119 "locate-plugin.vala"
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
#line 119 "locate-plugin.vala"
		if (_data_->_inner_error0_->domain == SYNAPSE_SEARCH_ERROR) {
#line 119 "locate-plugin.vala"
			g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
#line 119 "locate-plugin.vala"
			_g_object_unref0 (_data_->uris);
#line 119 "locate-plugin.vala"
			_data_->argv = (_vala_array_free (_data_->argv, _data_->argv_length1, (GDestroyNotify) g_free), NULL);
#line 119 "locate-plugin.vala"
			_g_free0 (_data_->regex);
#line 119 "locate-plugin.vala"
			g_object_unref (_data_->_async_result);
#line 119 "locate-plugin.vala"
			return FALSE;
#line 972 "locate-plugin.c"
		} else {
#line 119 "locate-plugin.vala"
			_g_object_unref0 (_data_->uris);
#line 119 "locate-plugin.vala"
			_data_->argv = (_vala_array_free (_data_->argv, _data_->argv_length1, (GDestroyNotify) g_free), NULL);
#line 119 "locate-plugin.vala"
			_g_free0 (_data_->regex);
#line 119 "locate-plugin.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
#line 119 "locate-plugin.vala"
			g_clear_error (&_data_->_inner_error0_);
#line 119 "locate-plugin.vala"
			g_object_unref (_data_->_async_result);
#line 119 "locate-plugin.vala"
			return FALSE;
#line 988 "locate-plugin.c"
		}
	}
#line 150 "locate-plugin.vala"
	synapse_query_check_cancellable (&_data_->q, &_data_->_inner_error0_);
#line 150 "locate-plugin.vala"
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
#line 150 "locate-plugin.vala"
		if (_data_->_inner_error0_->domain == SYNAPSE_SEARCH_ERROR) {
#line 150 "locate-plugin.vala"
			g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
#line 150 "locate-plugin.vala"
			_g_object_unref0 (_data_->uris);
#line 150 "locate-plugin.vala"
			_data_->argv = (_vala_array_free (_data_->argv, _data_->argv_length1, (GDestroyNotify) g_free), NULL);
#line 150 "locate-plugin.vala"
			_g_free0 (_data_->regex);
#line 150 "locate-plugin.vala"
			g_object_unref (_data_->_async_result);
#line 150 "locate-plugin.vala"
			return FALSE;
#line 1009 "locate-plugin.c"
		} else {
#line 150 "locate-plugin.vala"
			_g_object_unref0 (_data_->uris);
#line 150 "locate-plugin.vala"
			_data_->argv = (_vala_array_free (_data_->argv, _data_->argv_length1, (GDestroyNotify) g_free), NULL);
#line 150 "locate-plugin.vala"
			_g_free0 (_data_->regex);
#line 150 "locate-plugin.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
#line 150 "locate-plugin.vala"
			g_clear_error (&_data_->_inner_error0_);
#line 150 "locate-plugin.vala"
			g_object_unref (_data_->_async_result);
#line 150 "locate-plugin.vala"
			return FALSE;
#line 1025 "locate-plugin.c"
		}
	}
#line 152 "locate-plugin.vala"
	_data_->_tmp48_ = synapse_result_set_new ();
#line 152 "locate-plugin.vala"
	_data_->_result_ = _data_->_tmp48_;
#line 1032 "locate-plugin.c"
	{
#line 154 "locate-plugin.vala"
		_data_->_tmp49_ = _data_->uris;
#line 154 "locate-plugin.vala"
		_data_->_tmp50_ = gee_iterable_iterator ((GeeIterable*) _data_->_tmp49_);
#line 154 "locate-plugin.vala"
		_data_->_s_it = _data_->_tmp50_;
#line 154 "locate-plugin.vala"
		while (TRUE) {
#line 154 "locate-plugin.vala"
			_data_->_tmp51_ = _data_->_s_it;
#line 154 "locate-plugin.vala"
			if (!gee_iterator_next (_data_->_tmp51_)) {
#line 154 "locate-plugin.vala"
				break;
#line 1048 "locate-plugin.c"
			}
#line 154 "locate-plugin.vala"
			_data_->_tmp52_ = _data_->_s_it;
#line 154 "locate-plugin.vala"
			_data_->_tmp53_ = gee_iterator_get (_data_->_tmp52_);
#line 154 "locate-plugin.vala"
			_data_->s = (gchar*) _data_->_tmp53_;
#line 156 "locate-plugin.vala"
			_data_->_tmp54_ = _data_->s;
#line 156 "locate-plugin.vala"
			_data_->_tmp55_ = synapse_utils_file_info_new (_data_->_tmp54_, SYNAPSE_TYPE_URI_MATCH);
#line 156 "locate-plugin.vala"
			_data_->fi = _data_->_tmp55_;
#line 157 "locate-plugin.vala"
			_data_->_tmp56_ = _data_->fi;
#line 157 "locate-plugin.vala"
			_data_->_state_ = 2;
#line 157 "locate-plugin.vala"
			synapse_utils_file_info_initialize (_data_->_tmp56_, synapse_locate_plugin_locate_ready, _data_);
#line 157 "locate-plugin.vala"
			return FALSE;
#line 1070 "locate-plugin.c"
			_state_2:
#line 157 "locate-plugin.vala"
			synapse_utils_file_info_initialize_finish (_data_->_tmp56_, _data_->_res_);
#line 158 "locate-plugin.vala"
			_data_->_tmp58_ = _data_->fi;
#line 158 "locate-plugin.vala"
			_data_->_tmp59_ = _data_->_tmp58_->match_obj;
#line 158 "locate-plugin.vala"
			if (_data_->_tmp59_ != NULL) {
#line 158 "locate-plugin.vala"
				_data_->_tmp60_ = _data_->fi;
#line 158 "locate-plugin.vala"
				_data_->_tmp61_ = _data_->q;
#line 158 "locate-plugin.vala"
				_data_->_tmp57_ = (_data_->_tmp61_.query_type & _data_->_tmp60_->file_type) == _data_->_tmp60_->file_type;
#line 1086 "locate-plugin.c"
			} else {
#line 158 "locate-plugin.vala"
				_data_->_tmp57_ = FALSE;
#line 1090 "locate-plugin.c"
			}
#line 158 "locate-plugin.vala"
			if (_data_->_tmp57_) {
#line 160 "locate-plugin.vala"
				_data_->relevancy = (gint) SYNAPSE_MATCH_SCORE_INCREMENT_SMALL;
#line 161 "locate-plugin.vala"
				_data_->_tmp62_ = _data_->fi;
#line 161 "locate-plugin.vala"
				_data_->_tmp63_ = _data_->_tmp62_->uri;
#line 161 "locate-plugin.vala"
				if (g_str_has_prefix (_data_->_tmp63_, "file:///home/")) {
#line 161 "locate-plugin.vala"
					_data_->relevancy += (gint) SYNAPSE_MATCH_SCORE_INCREMENT_MINOR;
#line 1104 "locate-plugin.c"
				}
#line 162 "locate-plugin.vala"
				_data_->_tmp64_ = _data_->_result_;
#line 162 "locate-plugin.vala"
				_data_->_tmp65_ = _data_->fi;
#line 162 "locate-plugin.vala"
				_data_->_tmp66_ = _data_->_tmp65_->match_obj;
#line 162 "locate-plugin.vala"
				synapse_result_set_add (_data_->_tmp64_, (SynapseMatch*) _data_->_tmp66_, _data_->relevancy);
#line 1114 "locate-plugin.c"
			}
#line 164 "locate-plugin.vala"
			synapse_query_check_cancellable (&_data_->q, &_data_->_inner_error0_);
#line 164 "locate-plugin.vala"
			if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
#line 164 "locate-plugin.vala"
				if (_data_->_inner_error0_->domain == SYNAPSE_SEARCH_ERROR) {
#line 164 "locate-plugin.vala"
					g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
#line 164 "locate-plugin.vala"
					_synapse_utils_file_info_unref0 (_data_->fi);
#line 164 "locate-plugin.vala"
					_g_free0 (_data_->s);
#line 164 "locate-plugin.vala"
					_g_object_unref0 (_data_->_s_it);
#line 164 "locate-plugin.vala"
					_g_object_unref0 (_data_->_result_);
#line 164 "locate-plugin.vala"
					_g_object_unref0 (_data_->uris);
#line 164 "locate-plugin.vala"
					_data_->argv = (_vala_array_free (_data_->argv, _data_->argv_length1, (GDestroyNotify) g_free), NULL);
#line 164 "locate-plugin.vala"
					_g_free0 (_data_->regex);
#line 164 "locate-plugin.vala"
					g_object_unref (_data_->_async_result);
#line 164 "locate-plugin.vala"
					return FALSE;
#line 1142 "locate-plugin.c"
				} else {
#line 164 "locate-plugin.vala"
					_synapse_utils_file_info_unref0 (_data_->fi);
#line 164 "locate-plugin.vala"
					_g_free0 (_data_->s);
#line 164 "locate-plugin.vala"
					_g_object_unref0 (_data_->_s_it);
#line 164 "locate-plugin.vala"
					_g_object_unref0 (_data_->_result_);
#line 164 "locate-plugin.vala"
					_g_object_unref0 (_data_->uris);
#line 164 "locate-plugin.vala"
					_data_->argv = (_vala_array_free (_data_->argv, _data_->argv_length1, (GDestroyNotify) g_free), NULL);
#line 164 "locate-plugin.vala"
					_g_free0 (_data_->regex);
#line 164 "locate-plugin.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
#line 164 "locate-plugin.vala"
					g_clear_error (&_data_->_inner_error0_);
#line 164 "locate-plugin.vala"
					g_object_unref (_data_->_async_result);
#line 164 "locate-plugin.vala"
					return FALSE;
#line 1166 "locate-plugin.c"
				}
			}
#line 154 "locate-plugin.vala"
			_synapse_utils_file_info_unref0 (_data_->fi);
#line 154 "locate-plugin.vala"
			_g_free0 (_data_->s);
#line 1173 "locate-plugin.c"
		}
#line 154 "locate-plugin.vala"
		_g_object_unref0 (_data_->_s_it);
#line 1177 "locate-plugin.c"
	}
#line 167 "locate-plugin.vala"
	_data_->result = _data_->_result_;
#line 167 "locate-plugin.vala"
	_g_object_unref0 (_data_->uris);
#line 167 "locate-plugin.vala"
	_data_->argv = (_vala_array_free (_data_->argv, _data_->argv_length1, (GDestroyNotify) g_free), NULL);
#line 167 "locate-plugin.vala"
	_g_free0 (_data_->regex);
#line 167 "locate-plugin.vala"
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 167 "locate-plugin.vala"
	if (_data_->_state_ != 0) {
#line 167 "locate-plugin.vala"
		while (!g_task_get_completed (_data_->_async_result)) {
#line 167 "locate-plugin.vala"
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 1195 "locate-plugin.c"
		}
	}
#line 167 "locate-plugin.vala"
	g_object_unref (_data_->_async_result);
#line 167 "locate-plugin.vala"
	return FALSE;
#line 1202 "locate-plugin.c"
}

static SynapseResultSet*
synapse_locate_plugin_real_find_for_match (SynapseActionProvider* base,
                                           SynapseQuery* q,
                                           SynapseMatch* match)
{
	SynapseLocatePlugin * self;
	SynapseQueryFlags our_results = 0U;
	SynapseQueryFlags common_flags = 0U;
	SynapseQuery _tmp0_;
	gboolean _tmp1_ = FALSE;
	SynapseQuery _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	gboolean query_empty = FALSE;
	SynapseQuery _tmp5_;
	const gchar* _tmp6_;
	SynapseResultSet* results = NULL;
	SynapseResultSet* _tmp7_;
	SynapseResultSet* result;
#line 170 "locate-plugin.vala"
	self = (SynapseLocatePlugin*) base;
#line 170 "locate-plugin.vala"
	g_return_val_if_fail (q != NULL, NULL);
#line 170 "locate-plugin.vala"
	g_return_val_if_fail (match != NULL, NULL);
#line 172 "locate-plugin.vala"
	our_results = (((SYNAPSE_QUERY_FLAGS_AUDIO | SYNAPSE_QUERY_FLAGS_DOCUMENTS) | SYNAPSE_QUERY_FLAGS_IMAGES) | SYNAPSE_QUERY_FLAGS_UNCATEGORIZED) | SYNAPSE_QUERY_FLAGS_VIDEO;
#line 175 "locate-plugin.vala"
	_tmp0_ = *q;
#line 175 "locate-plugin.vala"
	common_flags = _tmp0_.query_type & our_results;
#line 177 "locate-plugin.vala"
	if (common_flags == 0) {
#line 177 "locate-plugin.vala"
		_tmp1_ = TRUE;
#line 1240 "locate-plugin.c"
	} else {
#line 177 "locate-plugin.vala"
		_tmp1_ = !G_TYPE_CHECK_INSTANCE_TYPE (match, SYNAPSE_TYPE_UNKNOWN_MATCH);
#line 1244 "locate-plugin.c"
	}
#line 177 "locate-plugin.vala"
	if (_tmp1_) {
#line 177 "locate-plugin.vala"
		result = NULL;
#line 177 "locate-plugin.vala"
		return result;
#line 1252 "locate-plugin.c"
	}
#line 180 "locate-plugin.vala"
	_tmp2_ = *q;
#line 180 "locate-plugin.vala"
	_tmp3_ = _tmp2_.query_string;
#line 180 "locate-plugin.vala"
	_tmp4_ = string_strip (_tmp3_);
#line 180 "locate-plugin.vala"
	_g_free0 ((*q).query_string);
#line 180 "locate-plugin.vala"
	(*q).query_string = _tmp4_;
#line 181 "locate-plugin.vala"
	_tmp5_ = *q;
#line 181 "locate-plugin.vala"
	_tmp6_ = _tmp5_.query_string;
#line 181 "locate-plugin.vala"
	query_empty = g_strcmp0 (_tmp6_, "") == 0;
#line 182 "locate-plugin.vala"
	_tmp7_ = synapse_result_set_new ();
#line 182 "locate-plugin.vala"
	results = _tmp7_;
#line 184 "locate-plugin.vala"
	if (query_empty) {
#line 1276 "locate-plugin.c"
		SynapseResultSet* _tmp8_;
		SynapseLocatePluginLocateItem* _tmp9_;
		SynapseLocatePluginLocateItem* _tmp10_;
		gint _tmp11_;
		gint _tmp12_;
#line 186 "locate-plugin.vala"
		_tmp8_ = results;
#line 186 "locate-plugin.vala"
		_tmp9_ = self->priv->action;
#line 186 "locate-plugin.vala"
		_tmp10_ = self->priv->action;
#line 186 "locate-plugin.vala"
		_tmp11_ = synapse_locate_plugin_locate_item_get_default_relevancy (_tmp10_);
#line 186 "locate-plugin.vala"
		_tmp12_ = _tmp11_;
#line 186 "locate-plugin.vala"
		synapse_result_set_add (_tmp8_, (SynapseMatch*) _tmp9_, _tmp12_);
#line 1294 "locate-plugin.c"
	} else {
		GeeList* matchers = NULL;
		SynapseQuery _tmp13_;
		const gchar* _tmp14_;
		GeeList* _tmp15_;
#line 190 "locate-plugin.vala"
		_tmp13_ = *q;
#line 190 "locate-plugin.vala"
		_tmp14_ = _tmp13_.query_string;
#line 190 "locate-plugin.vala"
		_tmp15_ = synapse_query_get_matchers_for_query (_tmp14_, 0, G_REGEX_CASELESS);
#line 190 "locate-plugin.vala"
		matchers = _tmp15_;
#line 1308 "locate-plugin.c"
		{
			GeeList* _matcher_list = NULL;
			GeeList* _tmp16_;
			gint _matcher_size = 0;
			GeeList* _tmp17_;
			gint _tmp18_;
			gint _tmp19_;
			gint _matcher_index = 0;
#line 192 "locate-plugin.vala"
			_tmp16_ = matchers;
#line 192 "locate-plugin.vala"
			_matcher_list = _tmp16_;
#line 192 "locate-plugin.vala"
			_tmp17_ = _matcher_list;
#line 192 "locate-plugin.vala"
			_tmp18_ = gee_collection_get_size ((GeeCollection*) _tmp17_);
#line 192 "locate-plugin.vala"
			_tmp19_ = _tmp18_;
#line 192 "locate-plugin.vala"
			_matcher_size = _tmp19_;
#line 192 "locate-plugin.vala"
			_matcher_index = -1;
#line 192 "locate-plugin.vala"
			while (TRUE) {
#line 1333 "locate-plugin.c"
				gint _tmp20_;
				gint _tmp21_;
				GeeMapEntry* matcher = NULL;
				GeeList* _tmp22_;
				gpointer _tmp23_;
				GeeMapEntry* _tmp24_;
				gconstpointer _tmp25_;
				gconstpointer _tmp26_;
				SynapseLocatePluginLocateItem* _tmp27_;
				const gchar* _tmp28_;
				const gchar* _tmp29_;
#line 192 "locate-plugin.vala"
				_matcher_index = _matcher_index + 1;
#line 192 "locate-plugin.vala"
				_tmp20_ = _matcher_index;
#line 192 "locate-plugin.vala"
				_tmp21_ = _matcher_size;
#line 192 "locate-plugin.vala"
				if (!(_tmp20_ < _tmp21_)) {
#line 192 "locate-plugin.vala"
					break;
#line 1355 "locate-plugin.c"
				}
#line 192 "locate-plugin.vala"
				_tmp22_ = _matcher_list;
#line 192 "locate-plugin.vala"
				_tmp23_ = gee_list_get (_tmp22_, _matcher_index);
#line 192 "locate-plugin.vala"
				matcher = (GeeMapEntry*) _tmp23_;
#line 194 "locate-plugin.vala"
				_tmp24_ = matcher;
#line 194 "locate-plugin.vala"
				_tmp25_ = gee_map_entry_get_key (_tmp24_);
#line 194 "locate-plugin.vala"
				_tmp26_ = _tmp25_;
#line 194 "locate-plugin.vala"
				_tmp27_ = self->priv->action;
#line 194 "locate-plugin.vala"
				_tmp28_ = synapse_match_get_title ((SynapseMatch*) _tmp27_);
#line 194 "locate-plugin.vala"
				_tmp29_ = _tmp28_;
#line 194 "locate-plugin.vala"
				if (g_regex_match ((GRegex*) _tmp26_, _tmp29_, 0, NULL)) {
#line 1377 "locate-plugin.c"
					SynapseResultSet* _tmp30_;
					SynapseLocatePluginLocateItem* _tmp31_;
					GeeMapEntry* _tmp32_;
					gconstpointer _tmp33_;
					gconstpointer _tmp34_;
#line 196 "locate-plugin.vala"
					_tmp30_ = results;
#line 196 "locate-plugin.vala"
					_tmp31_ = self->priv->action;
#line 196 "locate-plugin.vala"
					_tmp32_ = matcher;
#line 196 "locate-plugin.vala"
					_tmp33_ = gee_map_entry_get_value (_tmp32_);
#line 196 "locate-plugin.vala"
					_tmp34_ = _tmp33_;
#line 196 "locate-plugin.vala"
					synapse_result_set_add (_tmp30_, (SynapseMatch*) _tmp31_, (gint) ((gintptr) _tmp34_));
#line 197 "locate-plugin.vala"
					_g_object_unref0 (matcher);
#line 197 "locate-plugin.vala"
					break;
#line 1399 "locate-plugin.c"
				}
#line 192 "locate-plugin.vala"
				_g_object_unref0 (matcher);
#line 1403 "locate-plugin.c"
			}
		}
#line 184 "locate-plugin.vala"
		_g_object_unref0 (matchers);
#line 1408 "locate-plugin.c"
	}
#line 202 "locate-plugin.vala"
	result = results;
#line 202 "locate-plugin.vala"
	return result;
#line 1414 "locate-plugin.c"
}

SynapseLocatePlugin*
synapse_locate_plugin_construct (GType object_type)
{
	SynapseLocatePlugin * self = NULL;
#line 24 "locate-plugin.vala"
	self = (SynapseLocatePlugin*) g_object_new (object_type, NULL);
#line 24 "locate-plugin.vala"
	return self;
#line 1425 "locate-plugin.c"
}

SynapseLocatePlugin*
synapse_locate_plugin_new (void)
{
#line 24 "locate-plugin.vala"
	return synapse_locate_plugin_construct (SYNAPSE_TYPE_LOCATE_PLUGIN);
#line 1433 "locate-plugin.c"
}

static gboolean
synapse_locate_plugin_real_get_enabled (SynapseActivatable* base)
{
	gboolean result;
	SynapseLocatePlugin* self;
#line 26 "locate-plugin.vala"
	self = (SynapseLocatePlugin*) base;
#line 26 "locate-plugin.vala"
	result = self->priv->_enabled;
#line 26 "locate-plugin.vala"
	return result;
#line 1447 "locate-plugin.c"
}

static void
synapse_locate_plugin_real_set_enabled (SynapseActivatable* base,
                                        gboolean value)
{
	SynapseLocatePlugin* self;
	gboolean old_value;
#line 26 "locate-plugin.vala"
	self = (SynapseLocatePlugin*) base;
#line 26 "locate-plugin.vala"
	old_value = synapse_locate_plugin_real_get_enabled (base);
#line 26 "locate-plugin.vala"
	if (old_value != value) {
#line 26 "locate-plugin.vala"
		self->priv->_enabled = value;
#line 26 "locate-plugin.vala"
		g_object_notify_by_pspec ((GObject *) self, synapse_locate_plugin_properties[SYNAPSE_LOCATE_PLUGIN_ENABLED_PROPERTY]);
#line 1466 "locate-plugin.c"
	}
}

static inline gpointer
synapse_locate_plugin_locate_item_get_instance_private (SynapseLocatePluginLocateItem* self)
{
	return G_STRUCT_MEMBER_P (self, SynapseLocatePluginLocateItem_private_offset);
}

static void
synapse_locate_plugin_locate_item_real_search_data_free (gpointer _data)
{
	SynapseLocatePluginLocateItemSearchData* _data_;
	_data_ = _data;
#line 38 "locate-plugin.vala"
	_g_free0 (_data_->query);
#line 38 "locate-plugin.vala"
	_g_object_unref0 (_data_->dest_result_set);
#line 38 "locate-plugin.vala"
	_g_object_unref0 (_data_->cancellable);
#line 38 "locate-plugin.vala"
	_g_object_unref0 (_data_->result);
#line 38 "locate-plugin.vala"
	_g_object_unref0 (_data_->self);
#line 38 "locate-plugin.vala"
	g_slice_free (SynapseLocatePluginLocateItemSearchData, _data_);
#line 1493 "locate-plugin.c"
}

static void
synapse_locate_plugin_locate_item_real_search (SynapseSearchMatch* base,
                                               const gchar* query,
                                               SynapseQueryFlags flags,
                                               SynapseResultSet* dest_result_set,
                                               GCancellable* cancellable,
                                               GAsyncReadyCallback _callback_,
                                               gpointer _user_data_)
{
	SynapseLocatePluginLocateItem * self;
	SynapseLocatePluginLocateItemSearchData* _data_;
	SynapseLocatePluginLocateItem* _tmp0_;
	gchar* _tmp1_;
	SynapseResultSet* _tmp2_;
	GCancellable* _tmp3_;
#line 38 "locate-plugin.vala"
	g_return_if_fail (query != NULL);
#line 38 "locate-plugin.vala"
	self = (SynapseLocatePluginLocateItem*) base;
#line 38 "locate-plugin.vala"
	_data_ = g_slice_new0 (SynapseLocatePluginLocateItemSearchData);
#line 38 "locate-plugin.vala"
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
#line 38 "locate-plugin.vala"
	g_task_set_task_data (_data_->_async_result, _data_, synapse_locate_plugin_locate_item_real_search_data_free);
#line 38 "locate-plugin.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 38 "locate-plugin.vala"
	_data_->self = _tmp0_;
#line 38 "locate-plugin.vala"
	_tmp1_ = g_strdup (query);
#line 38 "locate-plugin.vala"
	_g_free0 (_data_->query);
#line 38 "locate-plugin.vala"
	_data_->query = _tmp1_;
#line 38 "locate-plugin.vala"
	_data_->flags = flags;
#line 38 "locate-plugin.vala"
	_tmp2_ = _g_object_ref0 (dest_result_set);
#line 38 "locate-plugin.vala"
	_g_object_unref0 (_data_->dest_result_set);
#line 38 "locate-plugin.vala"
	_data_->dest_result_set = _tmp2_;
#line 38 "locate-plugin.vala"
	_tmp3_ = _g_object_ref0 (cancellable);
#line 38 "locate-plugin.vala"
	_g_object_unref0 (_data_->cancellable);
#line 38 "locate-plugin.vala"
	_data_->cancellable = _tmp3_;
#line 38 "locate-plugin.vala"
	synapse_locate_plugin_locate_item_real_search_co (_data_);
#line 1547 "locate-plugin.c"
}

static GeeList*
synapse_locate_plugin_locate_item_search_finish (SynapseSearchMatch* base,
                                                 GAsyncResult* _res_,
                                                 GError** error)
{
	GeeList* result;
	SynapseLocatePluginLocateItemSearchData* _data_;
#line 38 "locate-plugin.vala"
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
#line 38 "locate-plugin.vala"
	if (NULL == _data_) {
#line 38 "locate-plugin.vala"
		return NULL;
#line 1563 "locate-plugin.c"
	}
#line 38 "locate-plugin.vala"
	result = _data_->result;
#line 38 "locate-plugin.vala"
	_data_->result = NULL;
#line 38 "locate-plugin.vala"
	return result;
#line 1571 "locate-plugin.c"
}

static void
synapse_locate_plugin_locate_item_search_ready (GObject* source_object,
                                                GAsyncResult* _res_,
                                                gpointer _user_data_)
{
	SynapseLocatePluginLocateItemSearchData* _data_;
#line 50 "locate-plugin.vala"
	_data_ = _user_data_;
#line 50 "locate-plugin.vala"
	_data_->_source_object_ = source_object;
#line 50 "locate-plugin.vala"
	_data_->_res_ = _res_;
#line 50 "locate-plugin.vala"
	synapse_locate_plugin_locate_item_real_search_co (_data_);
#line 1588 "locate-plugin.c"
}

static gboolean
synapse_locate_plugin_locate_item_real_search_co (SynapseLocatePluginLocateItemSearchData* _data_)
{
#line 43 "locate-plugin.vala"
	switch (_data_->_state_) {
#line 43 "locate-plugin.vala"
		case 0:
#line 1598 "locate-plugin.c"
		goto _state_0;
#line 43 "locate-plugin.vala"
		case 1:
#line 1602 "locate-plugin.c"
		goto _state_1;
		default:
#line 43 "locate-plugin.vala"
		g_assert_not_reached ();
#line 1607 "locate-plugin.c"
	}
	_state_0:
#line 48 "locate-plugin.vala"
	synapse_query_init (&_data_->q, (guint) 0, _data_->query, _data_->flags, (guint) 96);
#line 49 "locate-plugin.vala"
	_data_->_tmp0_ = _g_object_ref0 (_data_->cancellable);
#line 49 "locate-plugin.vala"
	_g_object_unref0 (_data_->q.cancellable);
#line 49 "locate-plugin.vala"
	_data_->q.cancellable = _data_->_tmp0_;
#line 50 "locate-plugin.vala"
	_data_->_tmp1_ = _data_->self->priv->plugin;
#line 50 "locate-plugin.vala"
	_data_->_tmp2_ = _data_->q;
#line 50 "locate-plugin.vala"
	_data_->_state_ = 1;
#line 50 "locate-plugin.vala"
	synapse_locate_plugin_locate (_data_->_tmp1_, &_data_->_tmp2_, synapse_locate_plugin_locate_item_search_ready, _data_);
#line 50 "locate-plugin.vala"
	return FALSE;
#line 1628 "locate-plugin.c"
	_state_1:
#line 50 "locate-plugin.vala"
	_data_->_tmp3_ = synapse_locate_plugin_locate_finish (_data_->_tmp1_, _data_->_res_, &_data_->_inner_error0_);
#line 50 "locate-plugin.vala"
	_data_->results = _data_->_tmp3_;
#line 50 "locate-plugin.vala"
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
#line 50 "locate-plugin.vala"
		if (_data_->_inner_error0_->domain == SYNAPSE_SEARCH_ERROR) {
#line 50 "locate-plugin.vala"
			g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
#line 50 "locate-plugin.vala"
			synapse_query_destroy (&_data_->q);
#line 50 "locate-plugin.vala"
			g_object_unref (_data_->_async_result);
#line 50 "locate-plugin.vala"
			return FALSE;
#line 1646 "locate-plugin.c"
		} else {
#line 50 "locate-plugin.vala"
			synapse_query_destroy (&_data_->q);
#line 50 "locate-plugin.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
#line 50 "locate-plugin.vala"
			g_clear_error (&_data_->_inner_error0_);
#line 50 "locate-plugin.vala"
			g_object_unref (_data_->_async_result);
#line 50 "locate-plugin.vala"
			return FALSE;
#line 1658 "locate-plugin.c"
		}
	}
#line 51 "locate-plugin.vala"
	synapse_result_set_add_all (_data_->dest_result_set, _data_->results);
#line 53 "locate-plugin.vala"
	_data_->_tmp4_ = synapse_result_set_get_sorted_list (_data_->dest_result_set);
#line 53 "locate-plugin.vala"
	_data_->result = _data_->_tmp4_;
#line 53 "locate-plugin.vala"
	_g_object_unref0 (_data_->results);
#line 53 "locate-plugin.vala"
	synapse_query_destroy (&_data_->q);
#line 53 "locate-plugin.vala"
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 53 "locate-plugin.vala"
	if (_data_->_state_ != 0) {
#line 53 "locate-plugin.vala"
		while (!g_task_get_completed (_data_->_async_result)) {
#line 53 "locate-plugin.vala"
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 1679 "locate-plugin.c"
		}
	}
#line 53 "locate-plugin.vala"
	g_object_unref (_data_->_async_result);
#line 53 "locate-plugin.vala"
	return FALSE;
#line 1686 "locate-plugin.c"
}

static SynapseLocatePluginLocateItem*
synapse_locate_plugin_locate_item_construct (GType object_type,
                                             SynapseLocatePlugin* plugin)
{
	SynapseLocatePluginLocateItem * self = NULL;
#line 58 "locate-plugin.vala"
	g_return_val_if_fail (plugin != NULL, NULL);
#line 60 "locate-plugin.vala"
	self = (SynapseLocatePluginLocateItem*) g_object_new (object_type, "has-thumbnail", FALSE, "icon-name", "search", "title", _ ("Locate"), "description", _ ("Locate files with this name on the filesystem"), NULL);
#line 64 "locate-plugin.vala"
	self->priv->plugin = plugin;
#line 58 "locate-plugin.vala"
	return self;
#line 1702 "locate-plugin.c"
}

static SynapseLocatePluginLocateItem*
synapse_locate_plugin_locate_item_new (SynapseLocatePlugin* plugin)
{
#line 58 "locate-plugin.vala"
	return synapse_locate_plugin_locate_item_construct (SYNAPSE_LOCATE_PLUGIN_TYPE_LOCATE_ITEM, plugin);
#line 1710 "locate-plugin.c"
}

static gint
synapse_locate_plugin_locate_item_get_default_relevancy (SynapseLocatePluginLocateItem* self)
{
	gint result;
#line 40 "locate-plugin.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 40 "locate-plugin.vala"
	result = self->priv->_default_relevancy;
#line 40 "locate-plugin.vala"
	return result;
#line 1723 "locate-plugin.c"
}

static void
synapse_locate_plugin_locate_item_set_default_relevancy (SynapseLocatePluginLocateItem* self,
                                                         gint value)
{
	gint old_value;
#line 40 "locate-plugin.vala"
	g_return_if_fail (self != NULL);
#line 40 "locate-plugin.vala"
	old_value = synapse_locate_plugin_locate_item_get_default_relevancy (self);
#line 40 "locate-plugin.vala"
	if (old_value != value) {
#line 40 "locate-plugin.vala"
		self->priv->_default_relevancy = value;
#line 40 "locate-plugin.vala"
		g_object_notify_by_pspec ((GObject *) self, synapse_locate_plugin_locate_item_properties[SYNAPSE_LOCATE_PLUGIN_LOCATE_ITEM_DEFAULT_RELEVANCY_PROPERTY]);
#line 1741 "locate-plugin.c"
	}
}

static void
synapse_locate_plugin_locate_item_class_init (SynapseLocatePluginLocateItemClass * klass,
                                              gpointer klass_data)
{
#line 38 "locate-plugin.vala"
	synapse_locate_plugin_locate_item_parent_class = g_type_class_peek_parent (klass);
#line 38 "locate-plugin.vala"
	g_type_class_adjust_private_offset (klass, &SynapseLocatePluginLocateItem_private_offset);
#line 38 "locate-plugin.vala"
	((SynapseSearchMatchClass *) klass)->search = (void (*) (SynapseSearchMatch*, const gchar*, SynapseQueryFlags, SynapseResultSet*, GCancellable*, GAsyncReadyCallback, gpointer)) synapse_locate_plugin_locate_item_real_search;
#line 38 "locate-plugin.vala"
	((SynapseSearchMatchClass *) klass)->search_finish = (GeeList* (*) (SynapseSearchMatch*, GAsyncResult*, GError**)) synapse_locate_plugin_locate_item_search_finish;
#line 38 "locate-plugin.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_synapse_locate_plugin_locate_item_get_property;
#line 38 "locate-plugin.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_synapse_locate_plugin_locate_item_set_property;
#line 38 "locate-plugin.vala"
	G_OBJECT_CLASS (klass)->finalize = synapse_locate_plugin_locate_item_finalize;
#line 38 "locate-plugin.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_LOCATE_PLUGIN_LOCATE_ITEM_DEFAULT_RELEVANCY_PROPERTY, synapse_locate_plugin_locate_item_properties[SYNAPSE_LOCATE_PLUGIN_LOCATE_ITEM_DEFAULT_RELEVANCY_PROPERTY] = g_param_spec_int ("default-relevancy", "default-relevancy", "default-relevancy", G_MININT, G_MAXINT, (gint) SYNAPSE_MATCH_SCORE_INCREMENT_SMALL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 1765 "locate-plugin.c"
}

static void
synapse_locate_plugin_locate_item_instance_init (SynapseLocatePluginLocateItem * self,
                                                 gpointer klass)
{
#line 38 "locate-plugin.vala"
	self->priv = synapse_locate_plugin_locate_item_get_instance_private (self);
#line 40 "locate-plugin.vala"
	self->priv->_default_relevancy = (gint) SYNAPSE_MATCH_SCORE_INCREMENT_SMALL;
#line 1776 "locate-plugin.c"
}

static void
synapse_locate_plugin_locate_item_finalize (GObject * obj)
{
	SynapseLocatePluginLocateItem * self;
#line 38 "locate-plugin.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SYNAPSE_LOCATE_PLUGIN_TYPE_LOCATE_ITEM, SynapseLocatePluginLocateItem);
#line 38 "locate-plugin.vala"
	G_OBJECT_CLASS (synapse_locate_plugin_locate_item_parent_class)->finalize (obj);
#line 1787 "locate-plugin.c"
}

static GType
synapse_locate_plugin_locate_item_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SynapseLocatePluginLocateItemClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) synapse_locate_plugin_locate_item_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SynapseLocatePluginLocateItem), 0, (GInstanceInitFunc) synapse_locate_plugin_locate_item_instance_init, NULL };
	GType synapse_locate_plugin_locate_item_type_id;
	synapse_locate_plugin_locate_item_type_id = g_type_register_static (SYNAPSE_TYPE_SEARCH_MATCH, "SynapseLocatePluginLocateItem", &g_define_type_info, 0);
	SynapseLocatePluginLocateItem_private_offset = g_type_add_instance_private (synapse_locate_plugin_locate_item_type_id, sizeof (SynapseLocatePluginLocateItemPrivate));
	return synapse_locate_plugin_locate_item_type_id;
}

static GType
synapse_locate_plugin_locate_item_get_type (void)
{
	static volatile gsize synapse_locate_plugin_locate_item_type_id__once = 0;
	if (g_once_init_enter (&synapse_locate_plugin_locate_item_type_id__once)) {
		GType synapse_locate_plugin_locate_item_type_id;
		synapse_locate_plugin_locate_item_type_id = synapse_locate_plugin_locate_item_get_type_once ();
		g_once_init_leave (&synapse_locate_plugin_locate_item_type_id__once, synapse_locate_plugin_locate_item_type_id);
	}
	return synapse_locate_plugin_locate_item_type_id__once;
}

static void
_vala_synapse_locate_plugin_locate_item_get_property (GObject * object,
                                                      guint property_id,
                                                      GValue * value,
                                                      GParamSpec * pspec)
{
	SynapseLocatePluginLocateItem * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SYNAPSE_LOCATE_PLUGIN_TYPE_LOCATE_ITEM, SynapseLocatePluginLocateItem);
#line 38 "locate-plugin.vala"
	switch (property_id) {
#line 38 "locate-plugin.vala"
		case SYNAPSE_LOCATE_PLUGIN_LOCATE_ITEM_DEFAULT_RELEVANCY_PROPERTY:
#line 38 "locate-plugin.vala"
		g_value_set_int (value, synapse_locate_plugin_locate_item_get_default_relevancy (self));
#line 38 "locate-plugin.vala"
		break;
#line 1828 "locate-plugin.c"
		default:
#line 38 "locate-plugin.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 38 "locate-plugin.vala"
		break;
#line 1834 "locate-plugin.c"
	}
}

static void
_vala_synapse_locate_plugin_locate_item_set_property (GObject * object,
                                                      guint property_id,
                                                      const GValue * value,
                                                      GParamSpec * pspec)
{
	SynapseLocatePluginLocateItem * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SYNAPSE_LOCATE_PLUGIN_TYPE_LOCATE_ITEM, SynapseLocatePluginLocateItem);
#line 38 "locate-plugin.vala"
	switch (property_id) {
#line 38 "locate-plugin.vala"
		case SYNAPSE_LOCATE_PLUGIN_LOCATE_ITEM_DEFAULT_RELEVANCY_PROPERTY:
#line 38 "locate-plugin.vala"
		synapse_locate_plugin_locate_item_set_default_relevancy (self, g_value_get_int (value));
#line 38 "locate-plugin.vala"
		break;
#line 1854 "locate-plugin.c"
		default:
#line 38 "locate-plugin.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 38 "locate-plugin.vala"
		break;
#line 1860 "locate-plugin.c"
	}
}

static GObject *
synapse_locate_plugin_constructor (GType type,
                                   guint n_construct_properties,
                                   GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	SynapseLocatePlugin * self;
	SynapseLocatePluginLocateItem* _tmp0_;
#line 88 "locate-plugin.vala"
	parent_class = G_OBJECT_CLASS (synapse_locate_plugin_parent_class);
#line 88 "locate-plugin.vala"
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
#line 88 "locate-plugin.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SYNAPSE_TYPE_LOCATE_PLUGIN, SynapseLocatePlugin);
#line 90 "locate-plugin.vala"
	_tmp0_ = synapse_locate_plugin_locate_item_new (self);
#line 90 "locate-plugin.vala"
	_g_object_unref0 (self->priv->action);
#line 90 "locate-plugin.vala"
	self->priv->action = _tmp0_;
#line 88 "locate-plugin.vala"
	return obj;
#line 1887 "locate-plugin.c"
}

static void
synapse_locate_plugin_class_init (SynapseLocatePluginClass * klass,
                                  gpointer klass_data)
{
#line 24 "locate-plugin.vala"
	synapse_locate_plugin_parent_class = g_type_class_peek_parent (klass);
#line 24 "locate-plugin.vala"
	g_type_class_adjust_private_offset (klass, &SynapseLocatePlugin_private_offset);
#line 24 "locate-plugin.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_synapse_locate_plugin_get_property;
#line 24 "locate-plugin.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_synapse_locate_plugin_set_property;
#line 24 "locate-plugin.vala"
	G_OBJECT_CLASS (klass)->constructor = synapse_locate_plugin_constructor;
#line 24 "locate-plugin.vala"
	G_OBJECT_CLASS (klass)->finalize = synapse_locate_plugin_finalize;
#line 24 "locate-plugin.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_LOCATE_PLUGIN_ENABLED_PROPERTY, synapse_locate_plugin_properties[SYNAPSE_LOCATE_PLUGIN_ENABLED_PROPERTY] = g_param_spec_boolean ("enabled", "enabled", "enabled", TRUE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 83 "locate-plugin.vala"
	synapse_locate_plugin_register_plugin ();
#line 1910 "locate-plugin.c"
}

static void
synapse_locate_plugin_synapse_activatable_interface_init (SynapseActivatableIface * iface,
                                                          gpointer iface_data)
{
#line 24 "locate-plugin.vala"
	synapse_locate_plugin_synapse_activatable_parent_iface = g_type_interface_peek_parent (iface);
#line 24 "locate-plugin.vala"
	iface->activate = (void (*) (SynapseActivatable*)) synapse_locate_plugin_real_activate;
#line 24 "locate-plugin.vala"
	iface->deactivate = (void (*) (SynapseActivatable*)) synapse_locate_plugin_real_deactivate;
#line 24 "locate-plugin.vala"
	iface->get_enabled = synapse_locate_plugin_real_get_enabled;
#line 24 "locate-plugin.vala"
	iface->set_enabled = synapse_locate_plugin_real_set_enabled;
#line 1927 "locate-plugin.c"
}

static void
synapse_locate_plugin_synapse_action_provider_interface_init (SynapseActionProviderIface * iface,
                                                              gpointer iface_data)
{
#line 24 "locate-plugin.vala"
	synapse_locate_plugin_synapse_action_provider_parent_iface = g_type_interface_peek_parent (iface);
#line 24 "locate-plugin.vala"
	iface->handles_unknown = (gboolean (*) (SynapseActionProvider*)) synapse_locate_plugin_real_handles_unknown;
#line 24 "locate-plugin.vala"
	iface->find_for_match = (SynapseResultSet* (*) (SynapseActionProvider*, SynapseQuery*, SynapseMatch*)) synapse_locate_plugin_real_find_for_match;
#line 1940 "locate-plugin.c"
}

static void
synapse_locate_plugin_instance_init (SynapseLocatePlugin * self,
                                     gpointer klass)
{
#line 24 "locate-plugin.vala"
	self->priv = synapse_locate_plugin_get_instance_private (self);
#line 26 "locate-plugin.vala"
	self->priv->_enabled = TRUE;
#line 1951 "locate-plugin.c"
}

static void
synapse_locate_plugin_finalize (GObject * obj)
{
	SynapseLocatePlugin * self;
#line 24 "locate-plugin.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SYNAPSE_TYPE_LOCATE_PLUGIN, SynapseLocatePlugin);
#line 86 "locate-plugin.vala"
	_g_object_unref0 (self->priv->action);
#line 24 "locate-plugin.vala"
	G_OBJECT_CLASS (synapse_locate_plugin_parent_class)->finalize (obj);
#line 1964 "locate-plugin.c"
}

static GType
synapse_locate_plugin_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SynapseLocatePluginClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) synapse_locate_plugin_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SynapseLocatePlugin), 0, (GInstanceInitFunc) synapse_locate_plugin_instance_init, NULL };
	static const GInterfaceInfo synapse_activatable_info = { (GInterfaceInitFunc) synapse_locate_plugin_synapse_activatable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	static const GInterfaceInfo synapse_action_provider_info = { (GInterfaceInitFunc) synapse_locate_plugin_synapse_action_provider_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType synapse_locate_plugin_type_id;
	synapse_locate_plugin_type_id = g_type_register_static (G_TYPE_OBJECT, "SynapseLocatePlugin", &g_define_type_info, 0);
	g_type_add_interface_static (synapse_locate_plugin_type_id, SYNAPSE_TYPE_ACTIVATABLE, &synapse_activatable_info);
	g_type_add_interface_static (synapse_locate_plugin_type_id, SYNAPSE_TYPE_ACTION_PROVIDER, &synapse_action_provider_info);
	SynapseLocatePlugin_private_offset = g_type_add_instance_private (synapse_locate_plugin_type_id, sizeof (SynapseLocatePluginPrivate));
	return synapse_locate_plugin_type_id;
}

GType
synapse_locate_plugin_get_type (void)
{
	static volatile gsize synapse_locate_plugin_type_id__once = 0;
	if (g_once_init_enter (&synapse_locate_plugin_type_id__once)) {
		GType synapse_locate_plugin_type_id;
		synapse_locate_plugin_type_id = synapse_locate_plugin_get_type_once ();
		g_once_init_leave (&synapse_locate_plugin_type_id__once, synapse_locate_plugin_type_id);
	}
	return synapse_locate_plugin_type_id__once;
}

static void
_vala_synapse_locate_plugin_get_property (GObject * object,
                                          guint property_id,
                                          GValue * value,
                                          GParamSpec * pspec)
{
	SynapseLocatePlugin * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SYNAPSE_TYPE_LOCATE_PLUGIN, SynapseLocatePlugin);
#line 24 "locate-plugin.vala"
	switch (property_id) {
#line 24 "locate-plugin.vala"
		case SYNAPSE_LOCATE_PLUGIN_ENABLED_PROPERTY:
#line 24 "locate-plugin.vala"
		g_value_set_boolean (value, synapse_activatable_get_enabled ((SynapseActivatable*) self));
#line 24 "locate-plugin.vala"
		break;
#line 2009 "locate-plugin.c"
		default:
#line 24 "locate-plugin.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 24 "locate-plugin.vala"
		break;
#line 2015 "locate-plugin.c"
	}
}

static void
_vala_synapse_locate_plugin_set_property (GObject * object,
                                          guint property_id,
                                          const GValue * value,
                                          GParamSpec * pspec)
{
	SynapseLocatePlugin * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SYNAPSE_TYPE_LOCATE_PLUGIN, SynapseLocatePlugin);
#line 24 "locate-plugin.vala"
	switch (property_id) {
#line 24 "locate-plugin.vala"
		case SYNAPSE_LOCATE_PLUGIN_ENABLED_PROPERTY:
#line 24 "locate-plugin.vala"
		synapse_activatable_set_enabled ((SynapseActivatable*) self, g_value_get_boolean (value));
#line 24 "locate-plugin.vala"
		break;
#line 2035 "locate-plugin.c"
		default:
#line 24 "locate-plugin.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 24 "locate-plugin.vala"
		break;
#line 2041 "locate-plugin.c"
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

