unsigned char sysbench_rand_lua[] =
  "-- Copyright (C) 2016-2017 Alexey Kopytov <akopytov@gmail.com>\n"
  "\n"
  "-- This program is free software; you can redistribute it and/or modify\n"
  "-- it under the terms of the GNU General Public License as published by\n"
  "-- the Free Software Foundation; either version 2 of the License, or\n"
  "-- (at your option) any later version.\n"
  "\n"
  "-- This program is distributed in the hope that it will be useful,\n"
  "-- but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
  "-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
  "-- GNU General Public License for more details.\n"
  "\n"
  "-- You should have received a copy of the GNU General Public License\n"
  "-- along with this program; if not, write to the Free Software\n"
  "-- Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA\n"
  "\n"
  "ffi = require(\"ffi\")\n"
  "\n"
  "-- ----------------------------------------------------------------------\n"
  "-- Pseudo-random number generation API\n"
  "-- ----------------------------------------------------------------------\n"
  "\n"
  "sysbench.rand = {}\n"
  "\n"
  "ffi.cdef[[\n"
  "uint64_t sb_rand_uniform_uint64(void);\n"
  "uint32_t sb_rand_default(uint32_t, uint32_t);\n"
  "uint32_t sb_rand_uniform(uint32_t, uint32_t);\n"
  "uint32_t sb_rand_gaussian(uint32_t, uint32_t);\n"
  "uint32_t sb_rand_special(uint32_t, uint32_t);\n"
  "uint32_t sb_rand_pareto(uint32_t, uint32_t);\n"
  "uint32_t sb_rand_unique(void);\n"
  "void sb_rand_str(const char *, char *);\n"
  "double sb_rand_uniform_double(void);\n"
  "]]\n"
  "\n"
  "function sysbench.rand.uniform_uint64()\n"
  "   return ffi.C.sb_rand_uniform_uint64()\n"
  "end\n"
  "\n"
  "function sysbench.rand.default(a, b)\n"
  "   return ffi.C.sb_rand_default(a, b)\n"
  "end\n"
  "\n"
  "function sysbench.rand.uniform(a, b)\n"
  "   return ffi.C.sb_rand_uniform(a, b)\n"
  "end\n"
  "\n"
  "function sysbench.rand.gaussian(a, b)\n"
  "   return ffi.C.sb_rand_gaussian(a, b)\n"
  "end\n"
  "\n"
  "function sysbench.rand.special(a, b)\n"
  "   return ffi.C.sb_rand_special(a, b)\n"
  "end\n"
  "\n"
  "function sysbench.rand.pareto(a, b)\n"
  "   return ffi.C.sb_rand_pareto(a, b)\n"
  "end\n"
  "\n"
  "function sysbench.rand.unique()\n"
  "   return ffi.C.sb_rand_unique()\n"
  "end\n"
  "\n"
  "function sysbench.rand.string(fmt)\n"
  "   local buflen = #fmt\n"
  "   local buf = ffi.new(\"uint8_t[?]\", buflen)\n"
  "   ffi.C.sb_rand_str(fmt, buf)\n"
  "   return ffi.string(buf, buflen)\n"
  "end\n"
  "\n"
  "function sysbench.rand.uniform_double()\n"
  "   return ffi.C.sb_rand_uniform_double()\n"
  "end\n"
;
size_t sysbench_rand_lua_len = sizeof(sysbench_rand_lua) - 1;
