const char error_lua[] =
"-- error.lua (internal file)\n"
"\n"
"local ffi = require('ffi')\n"
"local msgpack = require('msgpack')\n"
"\n"
"local mp_decode = msgpack.decode_unchecked\n"
"\n"
"ffi.cdef[[\n"
"struct type_info;\n"
"\n"
"enum {\n"
"    DIAG_ERRMSG_MAX = 512,\n"
"    DIAG_FILENAME_MAX = 256\n"
"};\n"
"\n"
"typedef void (*error_f)(struct error *e);\n"
"\n"
"struct error_field {\n"
"    char *_data;\n"
"    uint32_t _size;\n"
"    char _name[1];\n"
"};\n"
"\n"
"struct error_payload {\n"
"    int _count;\n"
"    struct error_field **_fields;\n"
"};\n"
"\n"
"struct error {\n"
"    error_f _destroy;\n"
"    error_f _raise;\n"
"    error_f _log;\n"
"    const struct type_info *_type;\n"
"    int64_t _refs;\n"
"    int _saved_errno;\n"
"    int code;\n"
"    struct error_payload _payload;\n"
"    /** Line number. */\n"
"    unsigned _line;\n"
"    /* Source file name. */\n"
"    char _file[DIAG_FILENAME_MAX];\n"
"    /* Error description. */\n"
"    char _errmsg[DIAG_ERRMSG_MAX];\n"
"    struct error *_cause;\n"
"    struct error *_effect;\n"
"};\n"
"\n"
"int\n"
"error_set_prev(struct error *e, struct error *prev);\n"
"\n"
"const char *\n"
"box_error_custom_type(const struct error *e);\n"
"\n"
"void\n"
"error_ref(struct error *e);\n"
"\n"
"void\n"
"error_unref(struct error *e);\n"
"\n"
"const struct error_field *\n"
"error_find_field(const struct error *e, const char *name);\n"
"]]\n"
"\n"
"local function error_base_type(err)\n"
"    return ffi.string(err._type.name)\n"
"end\n"
"\n"
"local function error_type(err)\n"
"    local res = ffi.C.box_error_custom_type(err)\n"
"    if res ~= nil then\n"
"        return ffi.string(res)\n"
"    end\n"
"    return error_base_type(err)\n"
"end\n"
"\n"
"local function error_message(err)\n"
"    return ffi.string(err._errmsg)\n"
"end\n"
"\n"
"local function error_trace(err)\n"
"    if err._file[0] == 0 then\n"
"        return {}\n"
"    end\n"
"    return {\n"
"        { file = ffi.string(err._file), line = tonumber(err._line) };\n"
"    }\n"
"end\n"
"\n"
"local function error_errno(err)\n"
"    local e = err._saved_errno\n"
"    if e == 0 then\n"
"        return nil\n"
"    end\n"
"    return e\n"
"end\n"
"\n"
"local function error_prev(err)\n"
"    local e = err._cause;\n"
"    if e ~= nil then\n"
"        ffi.C.error_ref(e)\n"
"        e = ffi.gc(e, ffi.C.error_unref)\n"
"        return e\n"
"    else\n"
"        return nil\n"
"    end\n"
"end\n"
"\n"
"local function error_set_prev(err, prev)\n"
"    -- First argument must be error.\n"
"    if not ffi.istype('struct error', err) then\n"
"        error(\"Usage: error1:set_prev(error2)\")\n"
"    end\n"
"    -- Second argument must be error or nil.\n"
"    if not ffi.istype('struct error', prev) and prev ~= nil then\n"
"        error(\"Usage: error1:set_prev(error2)\")\n"
"    end\n"
"    ffi.C.error_ref(err)\n"
"    local ok = ffi.C.error_set_prev(err, prev);\n"
"    if ok ~= 0 then\n"
"        error(\"Cycles are not allowed\")\n"
"    end\n"
"\n"
"end\n"
"\n"
"local error_fields = {\n"
"    [\"type\"]        = error_type;\n"
"    [\"message\"]     = error_message;\n"
"    [\"trace\"]       = error_trace;\n"
"    [\"errno\"]       = error_errno;\n"
"    [\"prev\"]        = error_prev;\n"
"    [\"base_type\"]   = error_base_type\n"
"}\n"
"\n"
"local function error_unpack(err)\n"
"    if not ffi.istype('struct error', err) then\n"
"        error(\"Usage: error:unpack()\")\n"
"    end\n"
"    local result = {code = err.code}\n"
"    for key, getter in pairs(error_fields)  do\n"
"        result[key] = getter(err)\n"
"    end\n"
"    local payload = err._payload\n"
"    local fields = payload._fields\n"
"    for i = 0, payload._count - 1 do\n"
"        local f = fields[i]\n"
"        result[ffi.string(f._name)] = mp_decode(f._data)\n"
"    end\n"
"    return result\n"
"end\n"
"\n"
"local function error_raise(err)\n"
"    if not ffi.istype('struct error', err) then\n"
"        error(\"Usage: error:raise()\")\n"
"    end\n"
"    error(err)\n"
"end\n"
"\n"
"local function error_match(err, ...)\n"
"    if not ffi.istype('struct error', err) then\n"
"        error(\"Usage: error:match()\")\n"
"    end\n"
"    return string.match(error_message(err), ...)\n"
"end\n"
"\n"
"local function error_serialize(err)\n"
"    -- Return an error message only in admin console to keep compatibility\n"
"    return error_message(err)\n"
"end\n"
"\n"
"local error_methods = {\n"
"    [\"unpack\"] = error_unpack;\n"
"    [\"raise\"] = error_raise;\n"
"    [\"match\"] = error_match; -- Tarantool 1.6 backward compatibility\n"
"    [\"__serialize\"] = error_serialize;\n"
"    [\"set_prev\"] = error_set_prev;\n"
"}\n"
"\n"
"local function error_index(err, key)\n"
"    local getter = error_fields[key]\n"
"    if getter ~= nil then\n"
"        return getter(err)\n"
"    end\n"
"    local f = ffi.C.error_find_field(err, key)\n"
"    if f ~= nil then\n"
"        return mp_decode(f._data)\n"
"    end\n"
"    return error_methods[key]\n"
"end\n"
"\n"
"local function error_concat(lhs, rhs)\n"
"    if ffi.istype('struct error', lhs) then\n"
"        return tostring(lhs) .. rhs\n"
"    elseif ffi.istype('struct error', rhs) then\n"
"        return lhs .. tostring(rhs)\n"
"    else\n"
"       error('error_mt.__concat(): neither of args is an error')\n"
"    end\n"
"end\n"
"\n"
"local error_mt = {\n"
"    __index = error_index;\n"
"    __tostring = error_message;\n"
"    __concat = error_concat;\n"
"};\n"
"\n"
"ffi.metatype('struct error', error_mt);\n"
"\n"
"return error\n"
""
;
