const char jit_zone_lua[] =
"----------------------------------------------------------------------------\n"
"-- LuaJIT profiler zones.\n"
"--\n"
"-- Copyright (C) 2005-2017 Mike Pall. All rights reserved.\n"
"-- Released under the MIT license. See Copyright Notice in luajit.h\n"
"----------------------------------------------------------------------------\n"
"--\n"
"-- This module implements a simple hierarchical zone model.\n"
"--\n"
"-- Example usage:\n"
"--\n"
"--   local zone = require(\"jit.zone\")\n"
"--   zone(\"AI\")\n"
"--   ...\n"
"--     zone(\"A*\")\n"
"--     ...\n"
"--     print(zone:get()) --> \"A*\"\n"
"--     ...\n"
"--     zone()\n"
"--   ...\n"
"--   print(zone:get()) --> \"AI\"\n"
"--   ...\n"
"--   zone()\n"
"--\n"
"----------------------------------------------------------------------------\n"
"\n"
"local remove = table.remove\n"
"\n"
"return setmetatable({\n"
"  flush = function(t)\n"
"    for i=#t,1,-1 do t[i] = nil end\n"
"  end,\n"
"  get = function(t)\n"
"    return t[#t]\n"
"  end\n"
"}, {\n"
"  __call = function(t, zone)\n"
"    if zone then\n"
"      t[#t+1] = zone\n"
"    else\n"
"      return (assert(remove(t), \"empty zone stack\"))\n"
"    end\n"
"  end\n"
"})\n"
"\n"
""
;
