const char digest_lua[] =
"-- digest.lua (internal file)\n"
"\n"
"local ffi = require('ffi')\n"
"local crypto = require('crypto')\n"
"local bit = require('bit')\n"
"local buffer = require('buffer')\n"
"local cord_ibuf_take = buffer.internal.cord_ibuf_take\n"
"local cord_ibuf_put = buffer.internal.cord_ibuf_put\n"
"\n"
"ffi.cdef[[\n"
"    /* from libc */\n"
"    int snprintf(char *str, size_t size, const char *format, ...);\n"
"\n"
"    typedef uint32_t (*crc32_func)(uint32_t crc,\n"
"        const unsigned char *buf, unsigned int len);\n"
"    extern int32_t guava(uint64_t state, int32_t buckets);\n"
"    extern crc32_func crc32_calc;\n"
"\n"
"    /* base64 */\n"
"    int base64_bufsize(int binsize, int options);\n"
"    int base64_decode(const char *in_base64, int in_len, char *out_bin, int out_len);\n"
"    int base64_encode(const char *in_bin, int in_len, char *out_base64, int out_len, int options);\n"
"\n"
"    /* random */\n"
"    void random_bytes(char *, size_t);\n"
"\n"
"    /* from third_party/PMurHash.h */\n"
"    void PMurHash32_Process(uint32_t *ph1, uint32_t *pcarry, const void *key, int len);\n"
"    uint32_t PMurHash32_Result(uint32_t h1, uint32_t carry, uint32_t total_length);\n"
"    uint32_t PMurHash32(uint32_t seed, const void *key, int len);\n"
"\n"
"    /* from third_party/zstd/lib/common/xxhash.c */\n"
"    typedef enum { XXH_OK=0, XXH_ERROR } XXH_errorcode;\n"
"    struct XXH32_state_s {\n"
"        unsigned total_len_32;\n"
"        unsigned large_len;\n"
"        unsigned v1;\n"
"        unsigned v2;\n"
"        unsigned v3;\n"
"        unsigned v4;\n"
"        unsigned mem32[4];   /* buffer defined as U32 for alignment */\n"
"        unsigned memsize;\n"
"        unsigned reserved;   /* never read nor write, will be removed in a future version */\n"
"    };\n"
"\n"
"    struct XXH64_state_s {\n"
"        unsigned long long total_len;\n"
"        unsigned long long v1;\n"
"        unsigned long long v2;\n"
"        unsigned long long v3;\n"
"        unsigned long long v4;\n"
"        unsigned long long mem64[4];   /* buffer defined as U64 for alignment */\n"
"        unsigned memsize;\n"
"        unsigned reserved[2];          /* never read nor write, will be removed in a future version */\n"
"    };\n"
"\n"
"    typedef unsigned int       XXH32_hash_t;\n"
"    typedef unsigned long long XXH64_hash_t;\n"
"    XXH32_hash_t tnt_XXH32 (const void* input, size_t length, unsigned int seed);\n"
"    XXH64_hash_t tnt_XXH64 (const void* input, size_t length, unsigned long long seed);\n"
"\n"
"    typedef struct XXH32_state_s XXH32_state_t;\n"
"    typedef struct XXH64_state_s XXH64_state_t;\n"
"\n"
"    XXH_errorcode tnt_XXH32_reset  (XXH32_state_t* statePtr, unsigned int seed);\n"
"    XXH_errorcode tnt_XXH32_update (XXH32_state_t* statePtr, const void* input, size_t length);\n"
"    XXH32_hash_t  tnt_XXH32_digest (const XXH32_state_t* statePtr);\n"
"\n"
"    XXH_errorcode tnt_XXH64_reset  (XXH64_state_t* statePtr, unsigned long long seed);\n"
"    XXH_errorcode tnt_XXH64_update (XXH64_state_t* statePtr, const void* input, size_t length);\n"
"    XXH64_hash_t  tnt_XXH64_digest (const XXH64_state_t* statePtr);\n"
"\n"
"    void tnt_XXH32_copyState(XXH32_state_t* restrict dst_state, const XXH32_state_t* restrict src_state);\n"
"    void tnt_XXH64_copyState(XXH64_state_t* restrict dst_state, const XXH64_state_t* restrict src_state);\n"
"]]\n"
"\n"
"local builtin = ffi.C\n"
"\n"
"-- @sa base64.h\n"
"local BASE64_NOPAD = 1\n"
"local BASE64_NOWRAP = 2\n"
"local BASE64_URLSAFE = 7\n"
"\n"
"local digest_shortcuts = {\n"
"    sha1    = 'SHA1',\n"
"    sha224  = 'SHA224',\n"
"    sha256  = 'SHA256',\n"
"    sha384  = 'SHA384',\n"
"    sha512  = 'SHA512',\n"
"    md5     = 'MD5',\n"
"    md4     = 'MD4',\n"
"}\n"
"local internal = require(\"digest.lib\")\n"
"\n"
"local PMurHash\n"
"local PMurHash_methods = {\n"
"\n"
"    update = function(self, str)\n"
"        if type(str) ~= 'string' then\n"
"            error(\"Usage: murhash:update(string)\")\n"
"        end\n"
"        builtin.PMurHash32_Process(self.seed, self.value, str, string.len(str))\n"
"        self.total_length = self.total_length + string.len(str)\n"
"    end,\n"
"\n"
"    result = function(self)\n"
"        return builtin.PMurHash32_Result(self.seed[0], self.value[0], self.total_length)\n"
"    end,\n"
"\n"
"    clear = function(self)\n"
"        self.seed[0] = self.default_seed\n"
"        self.total_length = 0\n"
"        self.value[0] = 0\n"
"    end,\n"
"\n"
"    copy = function(self)\n"
"        local new_self = PMurHash.new()\n"
"        new_self.seed[0] = self.seed[0]\n"
"        new_self.value[0] = self.value[0]\n"
"        new_self.total_length = self.total_length\n"
"        return new_self\n"
"    end\n"
"}\n"
"\n"
"PMurHash = {\n"
"    default_seed = 13,\n"
"\n"
"    new = function(opts)\n"
"        opts = opts or {}\n"
"        local self = setmetatable({}, { __index = PMurHash_methods })\n"
"        self.default_seed = (opts.seed or PMurHash.default_seed)\n"
"        self.seed = ffi.new(\"int[1]\", self.default_seed)\n"
"        self.value = ffi.new(\"int[1]\", 0)\n"
"        self.total_length = 0\n"
"        return self\n"
"    end\n"
"}\n"
"\n"
"setmetatable(PMurHash, {\n"
"    __call = function(self, str)\n"
"        if type(str) ~= 'string' then\n"
"            error(\"Usage: digest.murhash(string)\")\n"
"        end\n"
"        return builtin.PMurHash32(PMurHash.default_seed, str, string.len(str))\n"
"    end\n"
"})\n"
"\n"
"local CRC32\n"
"local CRC32_methods = {\n"
"    result = function(self)\n"
"        return self.value\n"
"    end,\n"
"\n"
"    clear = function(self)\n"
"        self.value = CRC32.crc_begin\n"
"    end,\n"
"\n"
"    copy = function(self)\n"
"        local new_self = CRC32.new()\n"
"        new_self.value = self.value\n"
"        return new_self\n"
"    end\n"
"}\n"
"\n"
"CRC32 = {\n"
"    crc_begin = 4294967295,\n"
"\n"
"    new = function()\n"
"        local self = setmetatable({}, { __index = CRC32_methods })\n"
"        self.value = CRC32.crc_begin\n"
"        return self\n"
"    end\n"
"}\n"
"\n"
"local __crc32 = require('crc32.internal')(CRC32)\n"
"\n"
"CRC32_methods.update = __crc32.update\n"
"\n"
"setmetatable(CRC32, {\n"
"    __call = __crc32.__call\n"
"})\n"
"\n"
"local pbkdf2 = function(pass, salt, iters, digest_len)\n"
"    if type(pass) ~= 'string' or type(salt) ~= 'string' then\n"
"        error(\"Usage: digest.pbkdf2(pass, salt[,iters][,digest_len])\")\n"
"    end\n"
"    if iters and type(iters) ~= 'number' then\n"
"        error(\"iters must be a number\")\n"
"    end\n"
"    if digest_len and type(digest_len) ~= 'number' then\n"
"        error(\"digest_len must be a number\")\n"
"    end\n"
"    iters = iters or 100000\n"
"    digest_len = digest_len or 128\n"
"    if digest_len > 128 then\n"
"        error(\"too big digest size\")\n"
"    end\n"
"    return internal.pbkdf2(pass, salt, iters, digest_len)\n"
"end\n"
"\n"
"local m = {\n"
"    base64_encode = function(bin, options)\n"
"        if type(bin) ~= 'string' or\n"
"           options ~= nil and type(options) ~= 'table' then\n"
"            error('Usage: digest.base64_encode(string[, table])')\n"
"        end\n"
"        local mask = 0\n"
"        if options ~= nil then\n"
"            if options.urlsafe then\n"
"                mask = bit.bor(mask, BASE64_URLSAFE)\n"
"            end\n"
"            if options.nopad then\n"
"                mask = bit.bor(mask, BASE64_NOPAD)\n"
"            end\n"
"            if options.nowrap then\n"
"                mask = bit.bor(mask, BASE64_NOWRAP)\n"
"            end\n"
"        end\n"
"        local blen = #bin\n"
"        local slen = builtin.base64_bufsize(blen, mask)\n"
"        local ibuf = cord_ibuf_take()\n"
"        local str = ibuf:alloc(slen)\n"
"        local len = builtin.base64_encode(bin, blen, str, slen, mask)\n"
"        str = ffi.string(str, len)\n"
"        cord_ibuf_put(ibuf)\n"
"        return str\n"
"    end,\n"
"\n"
"    base64_decode = function(str)\n"
"        if type(str) ~= 'string' then\n"
"            error('Usage: digest.base64_decode(string)')\n"
"        end\n"
"        local slen = #str\n"
"        local blen = math.ceil(slen * 3 / 4)\n"
"        local ibuf = cord_ibuf_take()\n"
"        local bin = ibuf:alloc(blen)\n"
"        local len = builtin.base64_decode(str, slen, bin, blen)\n"
"        bin = ffi.string(bin, len)\n"
"        cord_ibuf_put(ibuf)\n"
"        return bin\n"
"    end,\n"
"\n"
"    crc32 = CRC32,\n"
"\n"
"    crc32_update = function(crc, str)\n"
"        if type(str) ~= 'string' then\n"
"            error(\"Usage: digest.crc32_update(string)\")\n"
"        end\n"
"        return builtin.crc32_calc(tonumber(crc), str, string.len(str))\n"
"    end,\n"
"\n"
"    guava = function(state, buckets)\n"
"        return builtin.guava(state, buckets)\n"
"    end,\n"
"\n"
"    urandom = function(n)\n"
"        if n == nil then\n"
"            error('Usage: digest.urandom(len)')\n"
"        end\n"
"        local ibuf = cord_ibuf_take()\n"
"        local buf = ibuf:alloc(n)\n"
"        builtin.random_bytes(buf, n)\n"
"        buf = ffi.string(buf, n)\n"
"        cord_ibuf_put(ibuf)\n"
"        return buf\n"
"    end,\n"
"\n"
"    murmur = PMurHash,\n"
"\n"
"    pbkdf2 = pbkdf2,\n"
"\n"
"    pbkdf2_hex = function(pass, salt, iters, digest_len)\n"
"        if type(pass) ~= 'string' or type(salt) ~= 'string' then\n"
"            error(\"Usage: digest.pbkdf2_hex(pass, salt)\")\n"
"        end\n"
"        return string.hex(pbkdf2(pass, salt, iters, digest_len))\n"
"    end\n"
"}\n"
"\n"
"for digest, _ in pairs(digest_shortcuts) do\n"
"    m[digest] = function (str)\n"
"        return crypto.digest[digest](str)\n"
"    end\n"
"    m[digest .. '_hex'] = function (str)\n"
"        if type(str) ~= 'string' then\n"
"            error('Usage: digest.'..digest..'_hex(string)')\n"
"        end\n"
"        return string.hex(crypto.digest[digest](str))\n"
"    end\n"
"end\n"
"\n"
"m['aes256cbc'] = {\n"
"    encrypt = function (str, key, iv)\n"
"        return crypto.cipher.aes256.cbc.encrypt(str, key, iv)\n"
"    end,\n"
"    decrypt = function (str, key, iv)\n"
"        return crypto.cipher.aes256.cbc.decrypt(str, key, iv)\n"
"    end\n"
"}\n"
"\n"
"for _, var in ipairs({'32', '64'}) do\n"
"    local xxHash\n"
"\n"
"    local xxh_template = 'tnt_XXH%s_%s'\n"
"    local update_fn_name = string.format(xxh_template, var, 'update')\n"
"    local digest_fn_name = string.format(xxh_template, var, 'digest')\n"
"    local reset_fn_name = string.format(xxh_template, var, 'reset')\n"
"    local copy_fn_name = string.format(xxh_template, var, 'copyState')\n"
"\n"
"    local function update(self, str)\n"
"        if type(str) ~= 'string' then\n"
"            local message = string.format(\"Usage xxhash%s:update(string)\", var)\n"
"            error(message, 2)\n"
"        end\n"
"        builtin[update_fn_name](self.value, str, #str)\n"
"    end\n"
"\n"
"    local function result(self)\n"
"        return builtin[digest_fn_name](self.value)\n"
"    end\n"
"\n"
"    local function clear(self, seed)\n"
"        if seed == nil then\n"
"            seed = self.default_seed\n"
"        end\n"
"        builtin[reset_fn_name](self.value, seed)\n"
"    end\n"
"\n"
"    local function copy(self)\n"
"        local copy = xxHash.new()\n"
"        builtin[copy_fn_name](copy.value, self.value)\n"
"        return copy\n"
"    end\n"
"\n"
"    local state_type_name = string.format('XXH%s_state_t', var)\n"
"    local XXH_state_t = ffi.typeof(state_type_name)\n"
"\n"
"    xxHash = {\n"
"        new = function(seed)\n"
"            local self = {\n"
"                update = update,\n"
"                result = result,\n"
"                clear = clear,\n"
"                copy = copy,\n"
"                value = ffi.new(XXH_state_t),\n"
"                default_seed = seed or 0,\n"
"            }\n"
"            self:clear(self.default_seed)\n"
"            return self\n"
"        end,\n"
"    }\n"
"\n"
"    local call_fn_name = 'tnt_XXH' .. var\n"
"    setmetatable(xxHash, {\n"
"        __call = function(_, str, seed)\n"
"            if type(str) ~= 'string' then\n"
"                local message = string.format(\"Usage digest.xxhash%s(string[, unsigned number])\", var)\n"
"                error(message, 2)\n"
"            end\n"
"            if seed == nil then\n"
"                seed = 0\n"
"            end\n"
"            return builtin[call_fn_name](str, #str, seed)\n"
"        end,\n"
"    })\n"
"\n"
"    m['xxhash' .. var] = xxHash\n"
"end\n"
"\n"
"return m\n"
""
;
