const char metrics_cfg_lua[] =
"-- Based on https://github.com/tarantool/crud/blob/73bf5bf9353f9b9ee69c95bb14c610be8f2daeac/crud/cfg.lua\n"
"\n"
"local checks = require('checks')\n"
"\n"
"local metrics_api = require('metrics.api')\n"
"local const = require('metrics.const')\n"
"local stash = require('metrics.stash')\n"
"local metrics_tarantool = require('metrics.tarantool')\n"
"\n"
"local function set_defaults_if_empty(cfg)\n"
"    if cfg.include == nil then\n"
"        cfg.include = const.ALL\n"
"    end\n"
"\n"
"    if cfg.exclude == nil then\n"
"        cfg.exclude = {}\n"
"    end\n"
"\n"
"    if cfg.labels == nil then\n"
"        cfg.labels = {}\n"
"    end\n"
"\n"
"    return cfg\n"
"end\n"
"\n"
"local function configure(cfg, opts)\n"
"    if opts.include == nil then\n"
"        opts.include = cfg.include\n"
"    end\n"
"\n"
"    if opts.exclude == nil then\n"
"        opts.exclude = cfg.exclude\n"
"    end\n"
"\n"
"    if opts.labels == nil then\n"
"        opts.labels = cfg.labels\n"
"    end\n"
"\n"
"\n"
"    metrics_tarantool.enable_v2(opts.include, opts.exclude)\n"
"    metrics_api.set_global_labels(opts.labels)\n"
"\n"
"    rawset(cfg, 'include', opts.include)\n"
"    rawset(cfg, 'exclude', opts.exclude)\n"
"    rawset(cfg, 'labels', opts.labels)\n"
"end\n"
"\n"
"local _cfg = set_defaults_if_empty(stash.get(stash.name.cfg))\n"
"local _cfg_internal = stash.get(stash.name.cfg_internal)\n"
"\n"
"if _cfg_internal.initialized then\n"
"    configure(_cfg, {})\n"
"end\n"
"\n"
"local function __call(self, opts)\n"
"    checks('table', {\n"
"        include = '\?string|table',\n"
"        exclude = '\?table',\n"
"        labels = '\?table',\n"
"    })\n"
"\n"
"    opts = table.deepcopy(opts) or {}\n"
"\n"
"    configure(_cfg, opts)\n"
"\n"
"    _cfg_internal.initialized = true\n"
"\n"
"    return self\n"
"end\n"
"\n"
"local function __index(_, key)\n"
"    if _cfg_internal.initialized then\n"
"        return _cfg[key]\n"
"    else\n"
"        error('Call metrics.cfg{} first')\n"
"    end\n"
"end\n"
"\n"
"local function __newindex()\n"
"    error('Use metrics.cfg{} instead')\n"
"end\n"
"\n"
"return {\n"
"    -- Iterating through `metrics.cfg` with pairs is not supported yet.\n"
"    cfg = setmetatable({}, {\n"
"        __index = __index,\n"
"        __newindex = __newindex,\n"
"        __call = __call,\n"
"        __serialize = function() return _cfg end\n"
"    }),\n"
"}\n"
""
;
