// Code generated by go-swagger; DO NOT EDIT.

package vault_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	cloud "github.com/hashicorp/hcp-sdk-go/clients/cloud-shared/v1/models"
	"github.com/hashicorp/hcp-sdk-go/clients/cloud-vault-service/stable/2020-11-25/models"
)

// DisableCORSReader is a Reader for the DisableCORS structure.
type DisableCORSReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *DisableCORSReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewDisableCORSOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewDisableCORSDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewDisableCORSOK creates a DisableCORSOK with default headers values
func NewDisableCORSOK() *DisableCORSOK {
	return &DisableCORSOK{}
}

/*
DisableCORSOK describes a response with status code 200, with default header values.

A successful response.
*/
type DisableCORSOK struct {
	Payload models.HashicorpCloudVault20201125DisableCORSResponse
}

// IsSuccess returns true when this disable c o r s o k response has a 2xx status code
func (o *DisableCORSOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this disable c o r s o k response has a 3xx status code
func (o *DisableCORSOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this disable c o r s o k response has a 4xx status code
func (o *DisableCORSOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this disable c o r s o k response has a 5xx status code
func (o *DisableCORSOK) IsServerError() bool {
	return false
}

// IsCode returns true when this disable c o r s o k response a status code equal to that given
func (o *DisableCORSOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the disable c o r s o k response
func (o *DisableCORSOK) Code() int {
	return 200
}

func (o *DisableCORSOK) Error() string {
	return fmt.Sprintf("[DELETE /vault/2020-11-25/organizations/{location.organization_id}/projects/{location.project_id}/clusters/{cluster_id}/disable-cors][%d] disableCORSOK  %+v", 200, o.Payload)
}

func (o *DisableCORSOK) String() string {
	return fmt.Sprintf("[DELETE /vault/2020-11-25/organizations/{location.organization_id}/projects/{location.project_id}/clusters/{cluster_id}/disable-cors][%d] disableCORSOK  %+v", 200, o.Payload)
}

func (o *DisableCORSOK) GetPayload() models.HashicorpCloudVault20201125DisableCORSResponse {
	return o.Payload
}

func (o *DisableCORSOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// response payload
	if err := consumer.Consume(response.Body(), &o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewDisableCORSDefault creates a DisableCORSDefault with default headers values
func NewDisableCORSDefault(code int) *DisableCORSDefault {
	return &DisableCORSDefault{
		_statusCode: code,
	}
}

/*
DisableCORSDefault describes a response with status code -1, with default header values.

An unexpected error response.
*/
type DisableCORSDefault struct {
	_statusCode int

	Payload *cloud.GrpcGatewayRuntimeError
}

// IsSuccess returns true when this disable c o r s default response has a 2xx status code
func (o *DisableCORSDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this disable c o r s default response has a 3xx status code
func (o *DisableCORSDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this disable c o r s default response has a 4xx status code
func (o *DisableCORSDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this disable c o r s default response has a 5xx status code
func (o *DisableCORSDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this disable c o r s default response a status code equal to that given
func (o *DisableCORSDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the disable c o r s default response
func (o *DisableCORSDefault) Code() int {
	return o._statusCode
}

func (o *DisableCORSDefault) Error() string {
	return fmt.Sprintf("[DELETE /vault/2020-11-25/organizations/{location.organization_id}/projects/{location.project_id}/clusters/{cluster_id}/disable-cors][%d] DisableCORS default  %+v", o._statusCode, o.Payload)
}

func (o *DisableCORSDefault) String() string {
	return fmt.Sprintf("[DELETE /vault/2020-11-25/organizations/{location.organization_id}/projects/{location.project_id}/clusters/{cluster_id}/disable-cors][%d] DisableCORS default  %+v", o._statusCode, o.Payload)
}

func (o *DisableCORSDefault) GetPayload() *cloud.GrpcGatewayRuntimeError {
	return o.Payload
}

func (o *DisableCORSDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(cloud.GrpcGatewayRuntimeError)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
