/* This file is autogenerated by u_format_table.py from u_format.yaml. Do not edit directly. */

/**************************************************************************
 *
 * Copyright 2010 VMware, Inc.
 * All Rights Reserved.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the
 * "Software"), to deal in the Software without restriction, including
 * without limitation the rights to use, copy, modify, merge, publish,
 * distribute, sub license, and/or sell copies of the Software, and to
 * permit persons to whom the Software is furnished to do so, subject to
 * the following conditions:
 *
 * The above copyright notice and this permission notice (including the
 * next paragraph) shall be included in all copies or substantial portions
 * of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
 * OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NON-INFRINGEMENT.
 * IN NO EVENT SHALL VMWARE AND/OR ITS SUPPLIERS BE LIABLE FOR
 * ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT,
 * TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE
 * SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 *
 **************************************************************************/

#include "u_format.h"
#include "u_format_s3tc.h"

static const struct util_format_description
util_format_descriptions[PIPE_FORMAT_COUNT] = {
   [PIPE_FORMAT_NONE] = {
      .format = PIPE_FORMAT_NONE,
      .name = "PIPE_FORMAT_NONE",
      .short_name = "none",
      .block = {1, 1, 1, 8},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_PLAIN,
      .nr_channels = 1,	/* nr_channels */
      .is_array = true,	/* is_array */
      .is_bitmask = true,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = false,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
   {
      {UTIL_FORMAT_TYPE_UNSIGNED, false, false, 8, 0},	/* x = r */
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0}
   },
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_0,	/* g */
      PIPE_SWIZZLE_0,	/* b */
      PIPE_SWIZZLE_1	/* a */
   },
      .colorspace = UTIL_FORMAT_COLORSPACE_RGB,
      .srgb_equivalent = PIPE_FORMAT_NONE,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_B8G8R8A8_UNORM] = {
      .format = PIPE_FORMAT_B8G8R8A8_UNORM,
      .name = "PIPE_FORMAT_B8G8R8A8_UNORM",
      .short_name = "b8g8r8a8_unorm",
      .block = {1, 1, 1, 32},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_PLAIN,
      .nr_channels = 4,	/* nr_channels */
      .is_array = true,	/* is_array */
      .is_bitmask = true,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = true,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
#if UTIL_ARCH_BIG_ENDIAN
   {
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 8, 24},	/* x = b */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 8, 16},	/* y = g */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 8, 8},	/* z = r */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 8, 0}	/* w = a */
   },
#else
   {
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 8, 0},	/* x = b */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 8, 8},	/* y = g */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 8, 16},	/* z = r */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 8, 24}	/* w = a */
   },
#endif
#if UTIL_ARCH_BIG_ENDIAN
   {
      PIPE_SWIZZLE_Z,	/* r */
      PIPE_SWIZZLE_Y,	/* g */
      PIPE_SWIZZLE_X,	/* b */
      PIPE_SWIZZLE_W	/* a */
   },
#else
   {
      PIPE_SWIZZLE_Z,	/* r */
      PIPE_SWIZZLE_Y,	/* g */
      PIPE_SWIZZLE_X,	/* b */
      PIPE_SWIZZLE_W	/* a */
   },
#endif
      .colorspace = UTIL_FORMAT_COLORSPACE_RGB,
      .srgb_equivalent = PIPE_FORMAT_B8G8R8A8_SRGB,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_B8G8R8X8_UNORM] = {
      .format = PIPE_FORMAT_B8G8R8X8_UNORM,
      .name = "PIPE_FORMAT_B8G8R8X8_UNORM",
      .short_name = "b8g8r8x8_unorm",
      .block = {1, 1, 1, 32},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_PLAIN,
      .nr_channels = 4,	/* nr_channels */
      .is_array = true,	/* is_array */
      .is_bitmask = true,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = true,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
#if UTIL_ARCH_BIG_ENDIAN
   {
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 8, 24},	/* x = b */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 8, 16},	/* y = g */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 8, 8},	/* z = r */
      {UTIL_FORMAT_TYPE_VOID, false, false, 8, 0}	/* w = x */
   },
#else
   {
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 8, 0},	/* x = b */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 8, 8},	/* y = g */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 8, 16},	/* z = r */
      {UTIL_FORMAT_TYPE_VOID, false, false, 8, 24}	/* w = x */
   },
#endif
#if UTIL_ARCH_BIG_ENDIAN
   {
      PIPE_SWIZZLE_Z,	/* r */
      PIPE_SWIZZLE_Y,	/* g */
      PIPE_SWIZZLE_X,	/* b */
      PIPE_SWIZZLE_1	/* a */
   },
#else
   {
      PIPE_SWIZZLE_Z,	/* r */
      PIPE_SWIZZLE_Y,	/* g */
      PIPE_SWIZZLE_X,	/* b */
      PIPE_SWIZZLE_1	/* a */
   },
#endif
      .colorspace = UTIL_FORMAT_COLORSPACE_RGB,
      .srgb_equivalent = PIPE_FORMAT_B8G8R8X8_SRGB,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_B8G8R8X8_SNORM] = {
      .format = PIPE_FORMAT_B8G8R8X8_SNORM,
      .name = "PIPE_FORMAT_B8G8R8X8_SNORM",
      .short_name = "b8g8r8x8_snorm",
      .block = {1, 1, 1, 32},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_PLAIN,
      .nr_channels = 4,	/* nr_channels */
      .is_array = true,	/* is_array */
      .is_bitmask = true,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = false,	/* is_unorm */
      .is_snorm = true,	/* is_snorm */
#if UTIL_ARCH_BIG_ENDIAN
   {
      {UTIL_FORMAT_TYPE_SIGNED, true, false, 8, 24},	/* x = b */
      {UTIL_FORMAT_TYPE_SIGNED, true, false, 8, 16},	/* y = g */
      {UTIL_FORMAT_TYPE_SIGNED, true, false, 8, 8},	/* z = r */
      {UTIL_FORMAT_TYPE_VOID, false, false, 8, 0}	/* w = x */
   },
#else
   {
      {UTIL_FORMAT_TYPE_SIGNED, true, false, 8, 0},	/* x = b */
      {UTIL_FORMAT_TYPE_SIGNED, true, false, 8, 8},	/* y = g */
      {UTIL_FORMAT_TYPE_SIGNED, true, false, 8, 16},	/* z = r */
      {UTIL_FORMAT_TYPE_VOID, false, false, 8, 24}	/* w = x */
   },
#endif
#if UTIL_ARCH_BIG_ENDIAN
   {
      PIPE_SWIZZLE_Z,	/* r */
      PIPE_SWIZZLE_Y,	/* g */
      PIPE_SWIZZLE_X,	/* b */
      PIPE_SWIZZLE_1	/* a */
   },
#else
   {
      PIPE_SWIZZLE_Z,	/* r */
      PIPE_SWIZZLE_Y,	/* g */
      PIPE_SWIZZLE_X,	/* b */
      PIPE_SWIZZLE_1	/* a */
   },
#endif
      .colorspace = UTIL_FORMAT_COLORSPACE_RGB,
      .srgb_equivalent = PIPE_FORMAT_NONE,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_B8G8R8X8_UINT] = {
      .format = PIPE_FORMAT_B8G8R8X8_UINT,
      .name = "PIPE_FORMAT_B8G8R8X8_UINT",
      .short_name = "b8g8r8x8_uint",
      .block = {1, 1, 1, 32},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_PLAIN,
      .nr_channels = 4,	/* nr_channels */
      .is_array = true,	/* is_array */
      .is_bitmask = true,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = false,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
#if UTIL_ARCH_BIG_ENDIAN
   {
      {UTIL_FORMAT_TYPE_UNSIGNED, false, true, 8, 24},	/* x = b */
      {UTIL_FORMAT_TYPE_UNSIGNED, false, true, 8, 16},	/* y = g */
      {UTIL_FORMAT_TYPE_UNSIGNED, false, true, 8, 8},	/* z = r */
      {UTIL_FORMAT_TYPE_VOID, false, false, 8, 0}	/* w = x */
   },
#else
   {
      {UTIL_FORMAT_TYPE_UNSIGNED, false, true, 8, 0},	/* x = b */
      {UTIL_FORMAT_TYPE_UNSIGNED, false, true, 8, 8},	/* y = g */
      {UTIL_FORMAT_TYPE_UNSIGNED, false, true, 8, 16},	/* z = r */
      {UTIL_FORMAT_TYPE_VOID, false, false, 8, 24}	/* w = x */
   },
#endif
#if UTIL_ARCH_BIG_ENDIAN
   {
      PIPE_SWIZZLE_Z,	/* r */
      PIPE_SWIZZLE_Y,	/* g */
      PIPE_SWIZZLE_X,	/* b */
      PIPE_SWIZZLE_1	/* a */
   },
#else
   {
      PIPE_SWIZZLE_Z,	/* r */
      PIPE_SWIZZLE_Y,	/* g */
      PIPE_SWIZZLE_X,	/* b */
      PIPE_SWIZZLE_1	/* a */
   },
#endif
      .colorspace = UTIL_FORMAT_COLORSPACE_RGB,
      .srgb_equivalent = PIPE_FORMAT_NONE,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_B8G8R8X8_SINT] = {
      .format = PIPE_FORMAT_B8G8R8X8_SINT,
      .name = "PIPE_FORMAT_B8G8R8X8_SINT",
      .short_name = "b8g8r8x8_sint",
      .block = {1, 1, 1, 32},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_PLAIN,
      .nr_channels = 4,	/* nr_channels */
      .is_array = true,	/* is_array */
      .is_bitmask = true,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = false,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
#if UTIL_ARCH_BIG_ENDIAN
   {
      {UTIL_FORMAT_TYPE_SIGNED, false, true, 8, 24},	/* x = b */
      {UTIL_FORMAT_TYPE_SIGNED, false, true, 8, 16},	/* y = g */
      {UTIL_FORMAT_TYPE_SIGNED, false, true, 8, 8},	/* z = r */
      {UTIL_FORMAT_TYPE_VOID, false, false, 8, 0}	/* w = x */
   },
#else
   {
      {UTIL_FORMAT_TYPE_SIGNED, false, true, 8, 0},	/* x = b */
      {UTIL_FORMAT_TYPE_SIGNED, false, true, 8, 8},	/* y = g */
      {UTIL_FORMAT_TYPE_SIGNED, false, true, 8, 16},	/* z = r */
      {UTIL_FORMAT_TYPE_VOID, false, false, 8, 24}	/* w = x */
   },
#endif
#if UTIL_ARCH_BIG_ENDIAN
   {
      PIPE_SWIZZLE_Z,	/* r */
      PIPE_SWIZZLE_Y,	/* g */
      PIPE_SWIZZLE_X,	/* b */
      PIPE_SWIZZLE_1	/* a */
   },
#else
   {
      PIPE_SWIZZLE_Z,	/* r */
      PIPE_SWIZZLE_Y,	/* g */
      PIPE_SWIZZLE_X,	/* b */
      PIPE_SWIZZLE_1	/* a */
   },
#endif
      .colorspace = UTIL_FORMAT_COLORSPACE_RGB,
      .srgb_equivalent = PIPE_FORMAT_NONE,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_A8R8G8B8_UNORM] = {
      .format = PIPE_FORMAT_A8R8G8B8_UNORM,
      .name = "PIPE_FORMAT_A8R8G8B8_UNORM",
      .short_name = "a8r8g8b8_unorm",
      .block = {1, 1, 1, 32},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_PLAIN,
      .nr_channels = 4,	/* nr_channels */
      .is_array = true,	/* is_array */
      .is_bitmask = true,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = true,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
#if UTIL_ARCH_BIG_ENDIAN
   {
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 8, 24},	/* x = a */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 8, 16},	/* y = r */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 8, 8},	/* z = g */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 8, 0}	/* w = b */
   },
#else
   {
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 8, 0},	/* x = a */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 8, 8},	/* y = r */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 8, 16},	/* z = g */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 8, 24}	/* w = b */
   },
#endif
#if UTIL_ARCH_BIG_ENDIAN
   {
      PIPE_SWIZZLE_Y,	/* r */
      PIPE_SWIZZLE_Z,	/* g */
      PIPE_SWIZZLE_W,	/* b */
      PIPE_SWIZZLE_X	/* a */
   },
#else
   {
      PIPE_SWIZZLE_Y,	/* r */
      PIPE_SWIZZLE_Z,	/* g */
      PIPE_SWIZZLE_W,	/* b */
      PIPE_SWIZZLE_X	/* a */
   },
#endif
      .colorspace = UTIL_FORMAT_COLORSPACE_RGB,
      .srgb_equivalent = PIPE_FORMAT_A8R8G8B8_SRGB,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_A8R8G8B8_SNORM] = {
      .format = PIPE_FORMAT_A8R8G8B8_SNORM,
      .name = "PIPE_FORMAT_A8R8G8B8_SNORM",
      .short_name = "a8r8g8b8_snorm",
      .block = {1, 1, 1, 32},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_PLAIN,
      .nr_channels = 4,	/* nr_channels */
      .is_array = true,	/* is_array */
      .is_bitmask = true,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = false,	/* is_unorm */
      .is_snorm = true,	/* is_snorm */
#if UTIL_ARCH_BIG_ENDIAN
   {
      {UTIL_FORMAT_TYPE_SIGNED, true, false, 8, 24},	/* x = a */
      {UTIL_FORMAT_TYPE_SIGNED, true, false, 8, 16},	/* y = r */
      {UTIL_FORMAT_TYPE_SIGNED, true, false, 8, 8},	/* z = g */
      {UTIL_FORMAT_TYPE_SIGNED, true, false, 8, 0}	/* w = b */
   },
#else
   {
      {UTIL_FORMAT_TYPE_SIGNED, true, false, 8, 0},	/* x = a */
      {UTIL_FORMAT_TYPE_SIGNED, true, false, 8, 8},	/* y = r */
      {UTIL_FORMAT_TYPE_SIGNED, true, false, 8, 16},	/* z = g */
      {UTIL_FORMAT_TYPE_SIGNED, true, false, 8, 24}	/* w = b */
   },
#endif
#if UTIL_ARCH_BIG_ENDIAN
   {
      PIPE_SWIZZLE_Y,	/* r */
      PIPE_SWIZZLE_Z,	/* g */
      PIPE_SWIZZLE_W,	/* b */
      PIPE_SWIZZLE_X	/* a */
   },
#else
   {
      PIPE_SWIZZLE_Y,	/* r */
      PIPE_SWIZZLE_Z,	/* g */
      PIPE_SWIZZLE_W,	/* b */
      PIPE_SWIZZLE_X	/* a */
   },
#endif
      .colorspace = UTIL_FORMAT_COLORSPACE_RGB,
      .srgb_equivalent = PIPE_FORMAT_NONE,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_A8R8G8B8_SINT] = {
      .format = PIPE_FORMAT_A8R8G8B8_SINT,
      .name = "PIPE_FORMAT_A8R8G8B8_SINT",
      .short_name = "a8r8g8b8_sint",
      .block = {1, 1, 1, 32},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_PLAIN,
      .nr_channels = 4,	/* nr_channels */
      .is_array = true,	/* is_array */
      .is_bitmask = true,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = false,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
#if UTIL_ARCH_BIG_ENDIAN
   {
      {UTIL_FORMAT_TYPE_SIGNED, false, true, 8, 24},	/* x = a */
      {UTIL_FORMAT_TYPE_SIGNED, false, true, 8, 16},	/* y = r */
      {UTIL_FORMAT_TYPE_SIGNED, false, true, 8, 8},	/* z = g */
      {UTIL_FORMAT_TYPE_SIGNED, false, true, 8, 0}	/* w = b */
   },
#else
   {
      {UTIL_FORMAT_TYPE_SIGNED, false, true, 8, 0},	/* x = a */
      {UTIL_FORMAT_TYPE_SIGNED, false, true, 8, 8},	/* y = r */
      {UTIL_FORMAT_TYPE_SIGNED, false, true, 8, 16},	/* z = g */
      {UTIL_FORMAT_TYPE_SIGNED, false, true, 8, 24}	/* w = b */
   },
#endif
#if UTIL_ARCH_BIG_ENDIAN
   {
      PIPE_SWIZZLE_Y,	/* r */
      PIPE_SWIZZLE_Z,	/* g */
      PIPE_SWIZZLE_W,	/* b */
      PIPE_SWIZZLE_X	/* a */
   },
#else
   {
      PIPE_SWIZZLE_Y,	/* r */
      PIPE_SWIZZLE_Z,	/* g */
      PIPE_SWIZZLE_W,	/* b */
      PIPE_SWIZZLE_X	/* a */
   },
#endif
      .colorspace = UTIL_FORMAT_COLORSPACE_RGB,
      .srgb_equivalent = PIPE_FORMAT_NONE,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_X8R8G8B8_UNORM] = {
      .format = PIPE_FORMAT_X8R8G8B8_UNORM,
      .name = "PIPE_FORMAT_X8R8G8B8_UNORM",
      .short_name = "x8r8g8b8_unorm",
      .block = {1, 1, 1, 32},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_PLAIN,
      .nr_channels = 4,	/* nr_channels */
      .is_array = true,	/* is_array */
      .is_bitmask = true,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = true,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
#if UTIL_ARCH_BIG_ENDIAN
   {
      {UTIL_FORMAT_TYPE_VOID, false, false, 8, 24},	/* x = x */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 8, 16},	/* y = r */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 8, 8},	/* z = g */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 8, 0}	/* w = b */
   },
#else
   {
      {UTIL_FORMAT_TYPE_VOID, false, false, 8, 0},	/* x = x */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 8, 8},	/* y = r */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 8, 16},	/* z = g */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 8, 24}	/* w = b */
   },
#endif
#if UTIL_ARCH_BIG_ENDIAN
   {
      PIPE_SWIZZLE_Y,	/* r */
      PIPE_SWIZZLE_Z,	/* g */
      PIPE_SWIZZLE_W,	/* b */
      PIPE_SWIZZLE_1	/* a */
   },
#else
   {
      PIPE_SWIZZLE_Y,	/* r */
      PIPE_SWIZZLE_Z,	/* g */
      PIPE_SWIZZLE_W,	/* b */
      PIPE_SWIZZLE_1	/* a */
   },
#endif
      .colorspace = UTIL_FORMAT_COLORSPACE_RGB,
      .srgb_equivalent = PIPE_FORMAT_X8R8G8B8_SRGB,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_X8R8G8B8_SNORM] = {
      .format = PIPE_FORMAT_X8R8G8B8_SNORM,
      .name = "PIPE_FORMAT_X8R8G8B8_SNORM",
      .short_name = "x8r8g8b8_snorm",
      .block = {1, 1, 1, 32},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_PLAIN,
      .nr_channels = 4,	/* nr_channels */
      .is_array = true,	/* is_array */
      .is_bitmask = true,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = false,	/* is_unorm */
      .is_snorm = true,	/* is_snorm */
#if UTIL_ARCH_BIG_ENDIAN
   {
      {UTIL_FORMAT_TYPE_VOID, false, false, 8, 24},	/* x = x */
      {UTIL_FORMAT_TYPE_SIGNED, true, false, 8, 16},	/* y = r */
      {UTIL_FORMAT_TYPE_SIGNED, true, false, 8, 8},	/* z = g */
      {UTIL_FORMAT_TYPE_SIGNED, true, false, 8, 0}	/* w = b */
   },
#else
   {
      {UTIL_FORMAT_TYPE_VOID, false, false, 8, 0},	/* x = x */
      {UTIL_FORMAT_TYPE_SIGNED, true, false, 8, 8},	/* y = r */
      {UTIL_FORMAT_TYPE_SIGNED, true, false, 8, 16},	/* z = g */
      {UTIL_FORMAT_TYPE_SIGNED, true, false, 8, 24}	/* w = b */
   },
#endif
#if UTIL_ARCH_BIG_ENDIAN
   {
      PIPE_SWIZZLE_Y,	/* r */
      PIPE_SWIZZLE_Z,	/* g */
      PIPE_SWIZZLE_W,	/* b */
      PIPE_SWIZZLE_1	/* a */
   },
#else
   {
      PIPE_SWIZZLE_Y,	/* r */
      PIPE_SWIZZLE_Z,	/* g */
      PIPE_SWIZZLE_W,	/* b */
      PIPE_SWIZZLE_1	/* a */
   },
#endif
      .colorspace = UTIL_FORMAT_COLORSPACE_RGB,
      .srgb_equivalent = PIPE_FORMAT_NONE,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_X8R8G8B8_SINT] = {
      .format = PIPE_FORMAT_X8R8G8B8_SINT,
      .name = "PIPE_FORMAT_X8R8G8B8_SINT",
      .short_name = "x8r8g8b8_sint",
      .block = {1, 1, 1, 32},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_PLAIN,
      .nr_channels = 4,	/* nr_channels */
      .is_array = true,	/* is_array */
      .is_bitmask = true,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = false,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
#if UTIL_ARCH_BIG_ENDIAN
   {
      {UTIL_FORMAT_TYPE_VOID, false, false, 8, 24},	/* x = x */
      {UTIL_FORMAT_TYPE_SIGNED, false, true, 8, 16},	/* y = r */
      {UTIL_FORMAT_TYPE_SIGNED, false, true, 8, 8},	/* z = g */
      {UTIL_FORMAT_TYPE_SIGNED, false, true, 8, 0}	/* w = b */
   },
#else
   {
      {UTIL_FORMAT_TYPE_VOID, false, false, 8, 0},	/* x = x */
      {UTIL_FORMAT_TYPE_SIGNED, false, true, 8, 8},	/* y = r */
      {UTIL_FORMAT_TYPE_SIGNED, false, true, 8, 16},	/* z = g */
      {UTIL_FORMAT_TYPE_SIGNED, false, true, 8, 24}	/* w = b */
   },
#endif
#if UTIL_ARCH_BIG_ENDIAN
   {
      PIPE_SWIZZLE_Y,	/* r */
      PIPE_SWIZZLE_Z,	/* g */
      PIPE_SWIZZLE_W,	/* b */
      PIPE_SWIZZLE_1	/* a */
   },
#else
   {
      PIPE_SWIZZLE_Y,	/* r */
      PIPE_SWIZZLE_Z,	/* g */
      PIPE_SWIZZLE_W,	/* b */
      PIPE_SWIZZLE_1	/* a */
   },
#endif
      .colorspace = UTIL_FORMAT_COLORSPACE_RGB,
      .srgb_equivalent = PIPE_FORMAT_NONE,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_A8B8G8R8_UNORM] = {
      .format = PIPE_FORMAT_A8B8G8R8_UNORM,
      .name = "PIPE_FORMAT_A8B8G8R8_UNORM",
      .short_name = "a8b8g8r8_unorm",
      .block = {1, 1, 1, 32},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_PLAIN,
      .nr_channels = 4,	/* nr_channels */
      .is_array = true,	/* is_array */
      .is_bitmask = true,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = true,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
#if UTIL_ARCH_BIG_ENDIAN
   {
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 8, 24},	/* x = a */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 8, 16},	/* y = b */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 8, 8},	/* z = g */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 8, 0}	/* w = r */
   },
#else
   {
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 8, 0},	/* x = a */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 8, 8},	/* y = b */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 8, 16},	/* z = g */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 8, 24}	/* w = r */
   },
#endif
#if UTIL_ARCH_BIG_ENDIAN
   {
      PIPE_SWIZZLE_W,	/* r */
      PIPE_SWIZZLE_Z,	/* g */
      PIPE_SWIZZLE_Y,	/* b */
      PIPE_SWIZZLE_X	/* a */
   },
#else
   {
      PIPE_SWIZZLE_W,	/* r */
      PIPE_SWIZZLE_Z,	/* g */
      PIPE_SWIZZLE_Y,	/* b */
      PIPE_SWIZZLE_X	/* a */
   },
#endif
      .colorspace = UTIL_FORMAT_COLORSPACE_RGB,
      .srgb_equivalent = PIPE_FORMAT_A8B8G8R8_SRGB,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_X8B8G8R8_UNORM] = {
      .format = PIPE_FORMAT_X8B8G8R8_UNORM,
      .name = "PIPE_FORMAT_X8B8G8R8_UNORM",
      .short_name = "x8b8g8r8_unorm",
      .block = {1, 1, 1, 32},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_PLAIN,
      .nr_channels = 4,	/* nr_channels */
      .is_array = true,	/* is_array */
      .is_bitmask = true,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = true,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
#if UTIL_ARCH_BIG_ENDIAN
   {
      {UTIL_FORMAT_TYPE_VOID, false, false, 8, 24},	/* x = x */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 8, 16},	/* y = b */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 8, 8},	/* z = g */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 8, 0}	/* w = r */
   },
#else
   {
      {UTIL_FORMAT_TYPE_VOID, false, false, 8, 0},	/* x = x */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 8, 8},	/* y = b */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 8, 16},	/* z = g */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 8, 24}	/* w = r */
   },
#endif
#if UTIL_ARCH_BIG_ENDIAN
   {
      PIPE_SWIZZLE_W,	/* r */
      PIPE_SWIZZLE_Z,	/* g */
      PIPE_SWIZZLE_Y,	/* b */
      PIPE_SWIZZLE_1	/* a */
   },
#else
   {
      PIPE_SWIZZLE_W,	/* r */
      PIPE_SWIZZLE_Z,	/* g */
      PIPE_SWIZZLE_Y,	/* b */
      PIPE_SWIZZLE_1	/* a */
   },
#endif
      .colorspace = UTIL_FORMAT_COLORSPACE_RGB,
      .srgb_equivalent = PIPE_FORMAT_X8B8G8R8_SRGB,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_R8G8B8X8_UNORM] = {
      .format = PIPE_FORMAT_R8G8B8X8_UNORM,
      .name = "PIPE_FORMAT_R8G8B8X8_UNORM",
      .short_name = "r8g8b8x8_unorm",
      .block = {1, 1, 1, 32},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_PLAIN,
      .nr_channels = 4,	/* nr_channels */
      .is_array = true,	/* is_array */
      .is_bitmask = true,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = true,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
#if UTIL_ARCH_BIG_ENDIAN
   {
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 8, 24},	/* x = r */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 8, 16},	/* y = g */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 8, 8},	/* z = b */
      {UTIL_FORMAT_TYPE_VOID, false, false, 8, 0}	/* w = x */
   },
#else
   {
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 8, 0},	/* x = r */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 8, 8},	/* y = g */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 8, 16},	/* z = b */
      {UTIL_FORMAT_TYPE_VOID, false, false, 8, 24}	/* w = x */
   },
#endif
#if UTIL_ARCH_BIG_ENDIAN
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_Y,	/* g */
      PIPE_SWIZZLE_Z,	/* b */
      PIPE_SWIZZLE_1	/* a */
   },
#else
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_Y,	/* g */
      PIPE_SWIZZLE_Z,	/* b */
      PIPE_SWIZZLE_1	/* a */
   },
#endif
      .colorspace = UTIL_FORMAT_COLORSPACE_RGB,
      .srgb_equivalent = PIPE_FORMAT_R8G8B8X8_SRGB,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_R5G5B5A1_UNORM] = {
      .format = PIPE_FORMAT_R5G5B5A1_UNORM,
      .name = "PIPE_FORMAT_R5G5B5A1_UNORM",
      .short_name = "r5g5b5a1_unorm",
      .block = {1, 1, 1, 16},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_PLAIN,
      .nr_channels = 4,	/* nr_channels */
      .is_array = false,	/* is_array */
      .is_bitmask = true,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = true,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
#if UTIL_ARCH_BIG_ENDIAN
   {
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 1, 15},	/* x = a */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 5, 10},	/* y = b */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 5, 5},	/* z = g */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 5, 0}	/* w = r */
   },
#else
   {
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 5, 0},	/* x = r */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 5, 5},	/* y = g */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 5, 10},	/* z = b */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 1, 15}	/* w = a */
   },
#endif
#if UTIL_ARCH_BIG_ENDIAN
   {
      PIPE_SWIZZLE_W,	/* r */
      PIPE_SWIZZLE_Z,	/* g */
      PIPE_SWIZZLE_Y,	/* b */
      PIPE_SWIZZLE_X	/* a */
   },
#else
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_Y,	/* g */
      PIPE_SWIZZLE_Z,	/* b */
      PIPE_SWIZZLE_W	/* a */
   },
#endif
      .colorspace = UTIL_FORMAT_COLORSPACE_RGB,
      .srgb_equivalent = PIPE_FORMAT_NONE,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_R5G5B5X1_UNORM] = {
      .format = PIPE_FORMAT_R5G5B5X1_UNORM,
      .name = "PIPE_FORMAT_R5G5B5X1_UNORM",
      .short_name = "r5g5b5x1_unorm",
      .block = {1, 1, 1, 16},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_PLAIN,
      .nr_channels = 4,	/* nr_channels */
      .is_array = false,	/* is_array */
      .is_bitmask = true,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = true,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
#if UTIL_ARCH_BIG_ENDIAN
   {
      {UTIL_FORMAT_TYPE_VOID, false, false, 1, 15},	/* x = x */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 5, 10},	/* y = b */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 5, 5},	/* z = g */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 5, 0}	/* w = r */
   },
#else
   {
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 5, 0},	/* x = r */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 5, 5},	/* y = g */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 5, 10},	/* z = b */
      {UTIL_FORMAT_TYPE_VOID, false, false, 1, 15}	/* w = x */
   },
#endif
#if UTIL_ARCH_BIG_ENDIAN
   {
      PIPE_SWIZZLE_W,	/* r */
      PIPE_SWIZZLE_Z,	/* g */
      PIPE_SWIZZLE_Y,	/* b */
      PIPE_SWIZZLE_1	/* a */
   },
#else
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_Y,	/* g */
      PIPE_SWIZZLE_Z,	/* b */
      PIPE_SWIZZLE_1	/* a */
   },
#endif
      .colorspace = UTIL_FORMAT_COLORSPACE_RGB,
      .srgb_equivalent = PIPE_FORMAT_NONE,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_B5G5R5X1_UNORM] = {
      .format = PIPE_FORMAT_B5G5R5X1_UNORM,
      .name = "PIPE_FORMAT_B5G5R5X1_UNORM",
      .short_name = "b5g5r5x1_unorm",
      .block = {1, 1, 1, 16},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_PLAIN,
      .nr_channels = 4,	/* nr_channels */
      .is_array = false,	/* is_array */
      .is_bitmask = true,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = true,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
#if UTIL_ARCH_BIG_ENDIAN
   {
      {UTIL_FORMAT_TYPE_VOID, false, false, 1, 15},	/* x = x */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 5, 10},	/* y = r */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 5, 5},	/* z = g */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 5, 0}	/* w = b */
   },
#else
   {
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 5, 0},	/* x = b */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 5, 5},	/* y = g */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 5, 10},	/* z = r */
      {UTIL_FORMAT_TYPE_VOID, false, false, 1, 15}	/* w = x */
   },
#endif
#if UTIL_ARCH_BIG_ENDIAN
   {
      PIPE_SWIZZLE_Y,	/* r */
      PIPE_SWIZZLE_Z,	/* g */
      PIPE_SWIZZLE_W,	/* b */
      PIPE_SWIZZLE_1	/* a */
   },
#else
   {
      PIPE_SWIZZLE_Z,	/* r */
      PIPE_SWIZZLE_Y,	/* g */
      PIPE_SWIZZLE_X,	/* b */
      PIPE_SWIZZLE_1	/* a */
   },
#endif
      .colorspace = UTIL_FORMAT_COLORSPACE_RGB,
      .srgb_equivalent = PIPE_FORMAT_NONE,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_B5G5R5A1_UNORM] = {
      .format = PIPE_FORMAT_B5G5R5A1_UNORM,
      .name = "PIPE_FORMAT_B5G5R5A1_UNORM",
      .short_name = "b5g5r5a1_unorm",
      .block = {1, 1, 1, 16},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_PLAIN,
      .nr_channels = 4,	/* nr_channels */
      .is_array = false,	/* is_array */
      .is_bitmask = true,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = true,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
#if UTIL_ARCH_BIG_ENDIAN
   {
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 1, 15},	/* x = a */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 5, 10},	/* y = r */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 5, 5},	/* z = g */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 5, 0}	/* w = b */
   },
#else
   {
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 5, 0},	/* x = b */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 5, 5},	/* y = g */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 5, 10},	/* z = r */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 1, 15}	/* w = a */
   },
#endif
#if UTIL_ARCH_BIG_ENDIAN
   {
      PIPE_SWIZZLE_Y,	/* r */
      PIPE_SWIZZLE_Z,	/* g */
      PIPE_SWIZZLE_W,	/* b */
      PIPE_SWIZZLE_X	/* a */
   },
#else
   {
      PIPE_SWIZZLE_Z,	/* r */
      PIPE_SWIZZLE_Y,	/* g */
      PIPE_SWIZZLE_X,	/* b */
      PIPE_SWIZZLE_W	/* a */
   },
#endif
      .colorspace = UTIL_FORMAT_COLORSPACE_RGB,
      .srgb_equivalent = PIPE_FORMAT_NONE,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_X1B5G5R5_UNORM] = {
      .format = PIPE_FORMAT_X1B5G5R5_UNORM,
      .name = "PIPE_FORMAT_X1B5G5R5_UNORM",
      .short_name = "x1b5g5r5_unorm",
      .block = {1, 1, 1, 16},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_PLAIN,
      .nr_channels = 4,	/* nr_channels */
      .is_array = false,	/* is_array */
      .is_bitmask = true,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = true,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
#if UTIL_ARCH_BIG_ENDIAN
   {
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 5, 11},	/* x = r */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 5, 6},	/* y = g */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 5, 1},	/* z = b */
      {UTIL_FORMAT_TYPE_VOID, false, false, 1, 0}	/* w = x */
   },
#else
   {
      {UTIL_FORMAT_TYPE_VOID, false, false, 1, 0},	/* x = x */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 5, 1},	/* y = b */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 5, 6},	/* z = g */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 5, 11}	/* w = r */
   },
#endif
#if UTIL_ARCH_BIG_ENDIAN
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_Y,	/* g */
      PIPE_SWIZZLE_Z,	/* b */
      PIPE_SWIZZLE_1	/* a */
   },
#else
   {
      PIPE_SWIZZLE_W,	/* r */
      PIPE_SWIZZLE_Z,	/* g */
      PIPE_SWIZZLE_Y,	/* b */
      PIPE_SWIZZLE_1	/* a */
   },
#endif
      .colorspace = UTIL_FORMAT_COLORSPACE_RGB,
      .srgb_equivalent = PIPE_FORMAT_NONE,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_A1R5G5B5_UNORM] = {
      .format = PIPE_FORMAT_A1R5G5B5_UNORM,
      .name = "PIPE_FORMAT_A1R5G5B5_UNORM",
      .short_name = "a1r5g5b5_unorm",
      .block = {1, 1, 1, 16},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_PLAIN,
      .nr_channels = 4,	/* nr_channels */
      .is_array = false,	/* is_array */
      .is_bitmask = true,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = true,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
#if UTIL_ARCH_BIG_ENDIAN
   {
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 5, 11},	/* x = b */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 5, 6},	/* y = g */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 5, 1},	/* z = r */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 1, 0}	/* w = a */
   },
#else
   {
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 1, 0},	/* x = a */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 5, 1},	/* y = r */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 5, 6},	/* z = g */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 5, 11}	/* w = b */
   },
#endif
#if UTIL_ARCH_BIG_ENDIAN
   {
      PIPE_SWIZZLE_Z,	/* r */
      PIPE_SWIZZLE_Y,	/* g */
      PIPE_SWIZZLE_X,	/* b */
      PIPE_SWIZZLE_W	/* a */
   },
#else
   {
      PIPE_SWIZZLE_Y,	/* r */
      PIPE_SWIZZLE_Z,	/* g */
      PIPE_SWIZZLE_W,	/* b */
      PIPE_SWIZZLE_X	/* a */
   },
#endif
      .colorspace = UTIL_FORMAT_COLORSPACE_RGB,
      .srgb_equivalent = PIPE_FORMAT_NONE,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_X1R5G5B5_UNORM] = {
      .format = PIPE_FORMAT_X1R5G5B5_UNORM,
      .name = "PIPE_FORMAT_X1R5G5B5_UNORM",
      .short_name = "x1r5g5b5_unorm",
      .block = {1, 1, 1, 16},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_PLAIN,
      .nr_channels = 4,	/* nr_channels */
      .is_array = false,	/* is_array */
      .is_bitmask = true,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = true,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
#if UTIL_ARCH_BIG_ENDIAN
   {
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 5, 11},	/* x = b */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 5, 6},	/* y = g */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 5, 1},	/* z = r */
      {UTIL_FORMAT_TYPE_VOID, false, false, 1, 0}	/* w = x */
   },
#else
   {
      {UTIL_FORMAT_TYPE_VOID, false, false, 1, 0},	/* x = x */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 5, 1},	/* y = r */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 5, 6},	/* z = g */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 5, 11}	/* w = b */
   },
#endif
#if UTIL_ARCH_BIG_ENDIAN
   {
      PIPE_SWIZZLE_Z,	/* r */
      PIPE_SWIZZLE_Y,	/* g */
      PIPE_SWIZZLE_X,	/* b */
      PIPE_SWIZZLE_1	/* a */
   },
#else
   {
      PIPE_SWIZZLE_Y,	/* r */
      PIPE_SWIZZLE_Z,	/* g */
      PIPE_SWIZZLE_W,	/* b */
      PIPE_SWIZZLE_1	/* a */
   },
#endif
      .colorspace = UTIL_FORMAT_COLORSPACE_RGB,
      .srgb_equivalent = PIPE_FORMAT_NONE,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_A1B5G5R5_UNORM] = {
      .format = PIPE_FORMAT_A1B5G5R5_UNORM,
      .name = "PIPE_FORMAT_A1B5G5R5_UNORM",
      .short_name = "a1b5g5r5_unorm",
      .block = {1, 1, 1, 16},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_PLAIN,
      .nr_channels = 4,	/* nr_channels */
      .is_array = false,	/* is_array */
      .is_bitmask = true,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = true,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
#if UTIL_ARCH_BIG_ENDIAN
   {
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 5, 11},	/* x = r */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 5, 6},	/* y = g */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 5, 1},	/* z = b */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 1, 0}	/* w = a */
   },
#else
   {
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 1, 0},	/* x = a */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 5, 1},	/* y = b */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 5, 6},	/* z = g */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 5, 11}	/* w = r */
   },
#endif
#if UTIL_ARCH_BIG_ENDIAN
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_Y,	/* g */
      PIPE_SWIZZLE_Z,	/* b */
      PIPE_SWIZZLE_W	/* a */
   },
#else
   {
      PIPE_SWIZZLE_W,	/* r */
      PIPE_SWIZZLE_Z,	/* g */
      PIPE_SWIZZLE_Y,	/* b */
      PIPE_SWIZZLE_X	/* a */
   },
#endif
      .colorspace = UTIL_FORMAT_COLORSPACE_RGB,
      .srgb_equivalent = PIPE_FORMAT_NONE,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_R4G4B4A4_UNORM] = {
      .format = PIPE_FORMAT_R4G4B4A4_UNORM,
      .name = "PIPE_FORMAT_R4G4B4A4_UNORM",
      .short_name = "r4g4b4a4_unorm",
      .block = {1, 1, 1, 16},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_PLAIN,
      .nr_channels = 4,	/* nr_channels */
      .is_array = false,	/* is_array */
      .is_bitmask = true,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = true,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
#if UTIL_ARCH_BIG_ENDIAN
   {
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 4, 12},	/* x = a */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 4, 8},	/* y = b */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 4, 4},	/* z = g */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 4, 0}	/* w = r */
   },
#else
   {
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 4, 0},	/* x = r */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 4, 4},	/* y = g */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 4, 8},	/* z = b */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 4, 12}	/* w = a */
   },
#endif
#if UTIL_ARCH_BIG_ENDIAN
   {
      PIPE_SWIZZLE_W,	/* r */
      PIPE_SWIZZLE_Z,	/* g */
      PIPE_SWIZZLE_Y,	/* b */
      PIPE_SWIZZLE_X	/* a */
   },
#else
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_Y,	/* g */
      PIPE_SWIZZLE_Z,	/* b */
      PIPE_SWIZZLE_W	/* a */
   },
#endif
      .colorspace = UTIL_FORMAT_COLORSPACE_RGB,
      .srgb_equivalent = PIPE_FORMAT_NONE,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_R4G4B4X4_UNORM] = {
      .format = PIPE_FORMAT_R4G4B4X4_UNORM,
      .name = "PIPE_FORMAT_R4G4B4X4_UNORM",
      .short_name = "r4g4b4x4_unorm",
      .block = {1, 1, 1, 16},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_PLAIN,
      .nr_channels = 4,	/* nr_channels */
      .is_array = false,	/* is_array */
      .is_bitmask = true,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = true,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
#if UTIL_ARCH_BIG_ENDIAN
   {
      {UTIL_FORMAT_TYPE_VOID, false, false, 4, 12},	/* x = x */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 4, 8},	/* y = b */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 4, 4},	/* z = g */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 4, 0}	/* w = r */
   },
#else
   {
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 4, 0},	/* x = r */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 4, 4},	/* y = g */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 4, 8},	/* z = b */
      {UTIL_FORMAT_TYPE_VOID, false, false, 4, 12}	/* w = x */
   },
#endif
#if UTIL_ARCH_BIG_ENDIAN
   {
      PIPE_SWIZZLE_W,	/* r */
      PIPE_SWIZZLE_Z,	/* g */
      PIPE_SWIZZLE_Y,	/* b */
      PIPE_SWIZZLE_1	/* a */
   },
#else
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_Y,	/* g */
      PIPE_SWIZZLE_Z,	/* b */
      PIPE_SWIZZLE_1	/* a */
   },
#endif
      .colorspace = UTIL_FORMAT_COLORSPACE_RGB,
      .srgb_equivalent = PIPE_FORMAT_NONE,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_B4G4R4A4_UNORM] = {
      .format = PIPE_FORMAT_B4G4R4A4_UNORM,
      .name = "PIPE_FORMAT_B4G4R4A4_UNORM",
      .short_name = "b4g4r4a4_unorm",
      .block = {1, 1, 1, 16},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_PLAIN,
      .nr_channels = 4,	/* nr_channels */
      .is_array = false,	/* is_array */
      .is_bitmask = true,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = true,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
#if UTIL_ARCH_BIG_ENDIAN
   {
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 4, 12},	/* x = a */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 4, 8},	/* y = r */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 4, 4},	/* z = g */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 4, 0}	/* w = b */
   },
#else
   {
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 4, 0},	/* x = b */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 4, 4},	/* y = g */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 4, 8},	/* z = r */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 4, 12}	/* w = a */
   },
#endif
#if UTIL_ARCH_BIG_ENDIAN
   {
      PIPE_SWIZZLE_Y,	/* r */
      PIPE_SWIZZLE_Z,	/* g */
      PIPE_SWIZZLE_W,	/* b */
      PIPE_SWIZZLE_X	/* a */
   },
#else
   {
      PIPE_SWIZZLE_Z,	/* r */
      PIPE_SWIZZLE_Y,	/* g */
      PIPE_SWIZZLE_X,	/* b */
      PIPE_SWIZZLE_W	/* a */
   },
#endif
      .colorspace = UTIL_FORMAT_COLORSPACE_RGB,
      .srgb_equivalent = PIPE_FORMAT_NONE,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_B4G4R4X4_UNORM] = {
      .format = PIPE_FORMAT_B4G4R4X4_UNORM,
      .name = "PIPE_FORMAT_B4G4R4X4_UNORM",
      .short_name = "b4g4r4x4_unorm",
      .block = {1, 1, 1, 16},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_PLAIN,
      .nr_channels = 4,	/* nr_channels */
      .is_array = false,	/* is_array */
      .is_bitmask = true,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = true,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
#if UTIL_ARCH_BIG_ENDIAN
   {
      {UTIL_FORMAT_TYPE_VOID, false, false, 4, 12},	/* x = x */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 4, 8},	/* y = r */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 4, 4},	/* z = g */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 4, 0}	/* w = b */
   },
#else
   {
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 4, 0},	/* x = b */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 4, 4},	/* y = g */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 4, 8},	/* z = r */
      {UTIL_FORMAT_TYPE_VOID, false, false, 4, 12}	/* w = x */
   },
#endif
#if UTIL_ARCH_BIG_ENDIAN
   {
      PIPE_SWIZZLE_Y,	/* r */
      PIPE_SWIZZLE_Z,	/* g */
      PIPE_SWIZZLE_W,	/* b */
      PIPE_SWIZZLE_1	/* a */
   },
#else
   {
      PIPE_SWIZZLE_Z,	/* r */
      PIPE_SWIZZLE_Y,	/* g */
      PIPE_SWIZZLE_X,	/* b */
      PIPE_SWIZZLE_1	/* a */
   },
#endif
      .colorspace = UTIL_FORMAT_COLORSPACE_RGB,
      .srgb_equivalent = PIPE_FORMAT_NONE,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_A4R4G4B4_UNORM] = {
      .format = PIPE_FORMAT_A4R4G4B4_UNORM,
      .name = "PIPE_FORMAT_A4R4G4B4_UNORM",
      .short_name = "a4r4g4b4_unorm",
      .block = {1, 1, 1, 16},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_PLAIN,
      .nr_channels = 4,	/* nr_channels */
      .is_array = false,	/* is_array */
      .is_bitmask = true,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = true,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
#if UTIL_ARCH_BIG_ENDIAN
   {
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 4, 12},	/* x = b */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 4, 8},	/* y = g */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 4, 4},	/* z = r */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 4, 0}	/* w = a */
   },
#else
   {
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 4, 0},	/* x = a */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 4, 4},	/* y = r */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 4, 8},	/* z = g */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 4, 12}	/* w = b */
   },
#endif
#if UTIL_ARCH_BIG_ENDIAN
   {
      PIPE_SWIZZLE_Z,	/* r */
      PIPE_SWIZZLE_Y,	/* g */
      PIPE_SWIZZLE_X,	/* b */
      PIPE_SWIZZLE_W	/* a */
   },
#else
   {
      PIPE_SWIZZLE_Y,	/* r */
      PIPE_SWIZZLE_Z,	/* g */
      PIPE_SWIZZLE_W,	/* b */
      PIPE_SWIZZLE_X	/* a */
   },
#endif
      .colorspace = UTIL_FORMAT_COLORSPACE_RGB,
      .srgb_equivalent = PIPE_FORMAT_NONE,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_A4B4G4R4_UNORM] = {
      .format = PIPE_FORMAT_A4B4G4R4_UNORM,
      .name = "PIPE_FORMAT_A4B4G4R4_UNORM",
      .short_name = "a4b4g4r4_unorm",
      .block = {1, 1, 1, 16},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_PLAIN,
      .nr_channels = 4,	/* nr_channels */
      .is_array = false,	/* is_array */
      .is_bitmask = true,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = true,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
#if UTIL_ARCH_BIG_ENDIAN
   {
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 4, 12},	/* x = r */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 4, 8},	/* y = g */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 4, 4},	/* z = b */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 4, 0}	/* w = a */
   },
#else
   {
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 4, 0},	/* x = a */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 4, 4},	/* y = b */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 4, 8},	/* z = g */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 4, 12}	/* w = r */
   },
#endif
#if UTIL_ARCH_BIG_ENDIAN
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_Y,	/* g */
      PIPE_SWIZZLE_Z,	/* b */
      PIPE_SWIZZLE_W	/* a */
   },
#else
   {
      PIPE_SWIZZLE_W,	/* r */
      PIPE_SWIZZLE_Z,	/* g */
      PIPE_SWIZZLE_Y,	/* b */
      PIPE_SWIZZLE_X	/* a */
   },
#endif
      .colorspace = UTIL_FORMAT_COLORSPACE_RGB,
      .srgb_equivalent = PIPE_FORMAT_NONE,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_R5G6B5_UNORM] = {
      .format = PIPE_FORMAT_R5G6B5_UNORM,
      .name = "PIPE_FORMAT_R5G6B5_UNORM",
      .short_name = "r5g6b5_unorm",
      .block = {1, 1, 1, 16},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_PLAIN,
      .nr_channels = 3,	/* nr_channels */
      .is_array = false,	/* is_array */
      .is_bitmask = true,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = true,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
#if UTIL_ARCH_BIG_ENDIAN
   {
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 5, 11},	/* x = b */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 6, 5},	/* y = g */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 5, 0},	/* z = r */
      {0, 0, 0, 0, 0}
   },
#else
   {
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 5, 0},	/* x = r */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 6, 5},	/* y = g */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 5, 11},	/* z = b */
      {0, 0, 0, 0, 0}
   },
#endif
#if UTIL_ARCH_BIG_ENDIAN
   {
      PIPE_SWIZZLE_Z,	/* r */
      PIPE_SWIZZLE_Y,	/* g */
      PIPE_SWIZZLE_X,	/* b */
      PIPE_SWIZZLE_1	/* a */
   },
#else
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_Y,	/* g */
      PIPE_SWIZZLE_Z,	/* b */
      PIPE_SWIZZLE_1	/* a */
   },
#endif
      .colorspace = UTIL_FORMAT_COLORSPACE_RGB,
      .srgb_equivalent = PIPE_FORMAT_R5G6B5_SRGB,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_B5G6R5_UNORM] = {
      .format = PIPE_FORMAT_B5G6R5_UNORM,
      .name = "PIPE_FORMAT_B5G6R5_UNORM",
      .short_name = "b5g6r5_unorm",
      .block = {1, 1, 1, 16},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_PLAIN,
      .nr_channels = 3,	/* nr_channels */
      .is_array = false,	/* is_array */
      .is_bitmask = true,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = true,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
#if UTIL_ARCH_BIG_ENDIAN
   {
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 5, 11},	/* x = r */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 6, 5},	/* y = g */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 5, 0},	/* z = b */
      {0, 0, 0, 0, 0}
   },
#else
   {
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 5, 0},	/* x = b */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 6, 5},	/* y = g */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 5, 11},	/* z = r */
      {0, 0, 0, 0, 0}
   },
#endif
#if UTIL_ARCH_BIG_ENDIAN
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_Y,	/* g */
      PIPE_SWIZZLE_Z,	/* b */
      PIPE_SWIZZLE_1	/* a */
   },
#else
   {
      PIPE_SWIZZLE_Z,	/* r */
      PIPE_SWIZZLE_Y,	/* g */
      PIPE_SWIZZLE_X,	/* b */
      PIPE_SWIZZLE_1	/* a */
   },
#endif
      .colorspace = UTIL_FORMAT_COLORSPACE_RGB,
      .srgb_equivalent = PIPE_FORMAT_B5G6R5_SRGB,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_R10G10B10A2_UNORM] = {
      .format = PIPE_FORMAT_R10G10B10A2_UNORM,
      .name = "PIPE_FORMAT_R10G10B10A2_UNORM",
      .short_name = "r10g10b10a2_unorm",
      .block = {1, 1, 1, 32},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_PLAIN,
      .nr_channels = 4,	/* nr_channels */
      .is_array = false,	/* is_array */
      .is_bitmask = true,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = true,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
#if UTIL_ARCH_BIG_ENDIAN
   {
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 2, 30},	/* x = a */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 10, 20},	/* y = b */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 10, 10},	/* z = g */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 10, 0}	/* w = r */
   },
#else
   {
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 10, 0},	/* x = r */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 10, 10},	/* y = g */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 10, 20},	/* z = b */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 2, 30}	/* w = a */
   },
#endif
#if UTIL_ARCH_BIG_ENDIAN
   {
      PIPE_SWIZZLE_W,	/* r */
      PIPE_SWIZZLE_Z,	/* g */
      PIPE_SWIZZLE_Y,	/* b */
      PIPE_SWIZZLE_X	/* a */
   },
#else
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_Y,	/* g */
      PIPE_SWIZZLE_Z,	/* b */
      PIPE_SWIZZLE_W	/* a */
   },
#endif
      .colorspace = UTIL_FORMAT_COLORSPACE_RGB,
      .srgb_equivalent = PIPE_FORMAT_NONE,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_R10G10B10X2_UNORM] = {
      .format = PIPE_FORMAT_R10G10B10X2_UNORM,
      .name = "PIPE_FORMAT_R10G10B10X2_UNORM",
      .short_name = "r10g10b10x2_unorm",
      .block = {1, 1, 1, 32},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_PLAIN,
      .nr_channels = 4,	/* nr_channels */
      .is_array = false,	/* is_array */
      .is_bitmask = true,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = true,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
#if UTIL_ARCH_BIG_ENDIAN
   {
      {UTIL_FORMAT_TYPE_VOID, false, false, 2, 30},	/* x = x */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 10, 20},	/* y = b */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 10, 10},	/* z = g */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 10, 0}	/* w = r */
   },
#else
   {
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 10, 0},	/* x = r */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 10, 10},	/* y = g */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 10, 20},	/* z = b */
      {UTIL_FORMAT_TYPE_VOID, false, false, 2, 30}	/* w = x */
   },
#endif
#if UTIL_ARCH_BIG_ENDIAN
   {
      PIPE_SWIZZLE_W,	/* r */
      PIPE_SWIZZLE_Z,	/* g */
      PIPE_SWIZZLE_Y,	/* b */
      PIPE_SWIZZLE_1	/* a */
   },
#else
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_Y,	/* g */
      PIPE_SWIZZLE_Z,	/* b */
      PIPE_SWIZZLE_1	/* a */
   },
#endif
      .colorspace = UTIL_FORMAT_COLORSPACE_RGB,
      .srgb_equivalent = PIPE_FORMAT_NONE,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_B10G10R10A2_UNORM] = {
      .format = PIPE_FORMAT_B10G10R10A2_UNORM,
      .name = "PIPE_FORMAT_B10G10R10A2_UNORM",
      .short_name = "b10g10r10a2_unorm",
      .block = {1, 1, 1, 32},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_PLAIN,
      .nr_channels = 4,	/* nr_channels */
      .is_array = false,	/* is_array */
      .is_bitmask = true,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = true,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
#if UTIL_ARCH_BIG_ENDIAN
   {
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 2, 30},	/* x = a */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 10, 20},	/* y = r */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 10, 10},	/* z = g */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 10, 0}	/* w = b */
   },
#else
   {
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 10, 0},	/* x = b */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 10, 10},	/* y = g */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 10, 20},	/* z = r */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 2, 30}	/* w = a */
   },
#endif
#if UTIL_ARCH_BIG_ENDIAN
   {
      PIPE_SWIZZLE_Y,	/* r */
      PIPE_SWIZZLE_Z,	/* g */
      PIPE_SWIZZLE_W,	/* b */
      PIPE_SWIZZLE_X	/* a */
   },
#else
   {
      PIPE_SWIZZLE_Z,	/* r */
      PIPE_SWIZZLE_Y,	/* g */
      PIPE_SWIZZLE_X,	/* b */
      PIPE_SWIZZLE_W	/* a */
   },
#endif
      .colorspace = UTIL_FORMAT_COLORSPACE_RGB,
      .srgb_equivalent = PIPE_FORMAT_NONE,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_A2R10G10B10_UNORM] = {
      .format = PIPE_FORMAT_A2R10G10B10_UNORM,
      .name = "PIPE_FORMAT_A2R10G10B10_UNORM",
      .short_name = "a2r10g10b10_unorm",
      .block = {1, 1, 1, 32},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_PLAIN,
      .nr_channels = 4,	/* nr_channels */
      .is_array = false,	/* is_array */
      .is_bitmask = true,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = true,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
#if UTIL_ARCH_BIG_ENDIAN
   {
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 10, 22},	/* x = b */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 10, 12},	/* y = g */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 10, 2},	/* z = r */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 2, 0}	/* w = a */
   },
#else
   {
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 2, 0},	/* x = a */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 10, 2},	/* y = r */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 10, 12},	/* z = g */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 10, 22}	/* w = b */
   },
#endif
#if UTIL_ARCH_BIG_ENDIAN
   {
      PIPE_SWIZZLE_Z,	/* r */
      PIPE_SWIZZLE_Y,	/* g */
      PIPE_SWIZZLE_X,	/* b */
      PIPE_SWIZZLE_W	/* a */
   },
#else
   {
      PIPE_SWIZZLE_Y,	/* r */
      PIPE_SWIZZLE_Z,	/* g */
      PIPE_SWIZZLE_W,	/* b */
      PIPE_SWIZZLE_X	/* a */
   },
#endif
      .colorspace = UTIL_FORMAT_COLORSPACE_RGB,
      .srgb_equivalent = PIPE_FORMAT_NONE,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_A2B10G10R10_UNORM] = {
      .format = PIPE_FORMAT_A2B10G10R10_UNORM,
      .name = "PIPE_FORMAT_A2B10G10R10_UNORM",
      .short_name = "a2b10g10r10_unorm",
      .block = {1, 1, 1, 32},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_PLAIN,
      .nr_channels = 4,	/* nr_channels */
      .is_array = false,	/* is_array */
      .is_bitmask = true,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = true,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
#if UTIL_ARCH_BIG_ENDIAN
   {
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 10, 22},	/* x = r */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 10, 12},	/* y = g */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 10, 2},	/* z = b */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 2, 0}	/* w = a */
   },
#else
   {
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 2, 0},	/* x = a */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 10, 2},	/* y = b */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 10, 12},	/* z = g */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 10, 22}	/* w = r */
   },
#endif
#if UTIL_ARCH_BIG_ENDIAN
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_Y,	/* g */
      PIPE_SWIZZLE_Z,	/* b */
      PIPE_SWIZZLE_W	/* a */
   },
#else
   {
      PIPE_SWIZZLE_W,	/* r */
      PIPE_SWIZZLE_Z,	/* g */
      PIPE_SWIZZLE_Y,	/* b */
      PIPE_SWIZZLE_X	/* a */
   },
#endif
      .colorspace = UTIL_FORMAT_COLORSPACE_RGB,
      .srgb_equivalent = PIPE_FORMAT_NONE,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_R3G3B2_UNORM] = {
      .format = PIPE_FORMAT_R3G3B2_UNORM,
      .name = "PIPE_FORMAT_R3G3B2_UNORM",
      .short_name = "r3g3b2_unorm",
      .block = {1, 1, 1, 8},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_PLAIN,
      .nr_channels = 3,	/* nr_channels */
      .is_array = false,	/* is_array */
      .is_bitmask = true,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = true,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
#if UTIL_ARCH_BIG_ENDIAN
   {
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 2, 6},	/* x = b */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 3, 3},	/* y = g */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 3, 0},	/* z = r */
      {0, 0, 0, 0, 0}
   },
#else
   {
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 3, 0},	/* x = r */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 3, 3},	/* y = g */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 2, 6},	/* z = b */
      {0, 0, 0, 0, 0}
   },
#endif
#if UTIL_ARCH_BIG_ENDIAN
   {
      PIPE_SWIZZLE_Z,	/* r */
      PIPE_SWIZZLE_Y,	/* g */
      PIPE_SWIZZLE_X,	/* b */
      PIPE_SWIZZLE_1	/* a */
   },
#else
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_Y,	/* g */
      PIPE_SWIZZLE_Z,	/* b */
      PIPE_SWIZZLE_1	/* a */
   },
#endif
      .colorspace = UTIL_FORMAT_COLORSPACE_RGB,
      .srgb_equivalent = PIPE_FORMAT_NONE,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_B2G3R3_UNORM] = {
      .format = PIPE_FORMAT_B2G3R3_UNORM,
      .name = "PIPE_FORMAT_B2G3R3_UNORM",
      .short_name = "b2g3r3_unorm",
      .block = {1, 1, 1, 8},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_PLAIN,
      .nr_channels = 3,	/* nr_channels */
      .is_array = false,	/* is_array */
      .is_bitmask = true,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = true,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
#if UTIL_ARCH_BIG_ENDIAN
   {
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 3, 5},	/* x = r */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 3, 2},	/* y = g */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 2, 0},	/* z = b */
      {0, 0, 0, 0, 0}
   },
#else
   {
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 2, 0},	/* x = b */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 3, 2},	/* y = g */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 3, 5},	/* z = r */
      {0, 0, 0, 0, 0}
   },
#endif
#if UTIL_ARCH_BIG_ENDIAN
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_Y,	/* g */
      PIPE_SWIZZLE_Z,	/* b */
      PIPE_SWIZZLE_1	/* a */
   },
#else
   {
      PIPE_SWIZZLE_Z,	/* r */
      PIPE_SWIZZLE_Y,	/* g */
      PIPE_SWIZZLE_X,	/* b */
      PIPE_SWIZZLE_1	/* a */
   },
#endif
      .colorspace = UTIL_FORMAT_COLORSPACE_RGB,
      .srgb_equivalent = PIPE_FORMAT_NONE,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_L8_UNORM] = {
      .format = PIPE_FORMAT_L8_UNORM,
      .name = "PIPE_FORMAT_L8_UNORM",
      .short_name = "l8_unorm",
      .block = {1, 1, 1, 8},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_PLAIN,
      .nr_channels = 1,	/* nr_channels */
      .is_array = true,	/* is_array */
      .is_bitmask = true,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = true,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
   {
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 8, 0},	/* x = rgb */
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0}
   },
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_X,	/* g */
      PIPE_SWIZZLE_X,	/* b */
      PIPE_SWIZZLE_1	/* a */
   },
      .colorspace = UTIL_FORMAT_COLORSPACE_RGB,
      .srgb_equivalent = PIPE_FORMAT_L8_SRGB,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_A8_UNORM] = {
      .format = PIPE_FORMAT_A8_UNORM,
      .name = "PIPE_FORMAT_A8_UNORM",
      .short_name = "a8_unorm",
      .block = {1, 1, 1, 8},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_PLAIN,
      .nr_channels = 1,	/* nr_channels */
      .is_array = true,	/* is_array */
      .is_bitmask = true,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = true,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
   {
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 8, 0},	/* x = a */
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0}
   },
   {
      PIPE_SWIZZLE_0,	/* r */
      PIPE_SWIZZLE_0,	/* g */
      PIPE_SWIZZLE_0,	/* b */
      PIPE_SWIZZLE_X	/* a */
   },
      .colorspace = UTIL_FORMAT_COLORSPACE_RGB,
      .srgb_equivalent = PIPE_FORMAT_NONE,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_I8_UNORM] = {
      .format = PIPE_FORMAT_I8_UNORM,
      .name = "PIPE_FORMAT_I8_UNORM",
      .short_name = "i8_unorm",
      .block = {1, 1, 1, 8},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_PLAIN,
      .nr_channels = 1,	/* nr_channels */
      .is_array = true,	/* is_array */
      .is_bitmask = true,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = true,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
   {
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 8, 0},	/* x = rgba */
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0}
   },
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_X,	/* g */
      PIPE_SWIZZLE_X,	/* b */
      PIPE_SWIZZLE_X	/* a */
   },
      .colorspace = UTIL_FORMAT_COLORSPACE_RGB,
      .srgb_equivalent = PIPE_FORMAT_NONE,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_L4A4_UNORM] = {
      .format = PIPE_FORMAT_L4A4_UNORM,
      .name = "PIPE_FORMAT_L4A4_UNORM",
      .short_name = "l4a4_unorm",
      .block = {1, 1, 1, 8},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_PLAIN,
      .nr_channels = 2,	/* nr_channels */
      .is_array = false,	/* is_array */
      .is_bitmask = true,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = true,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
#if UTIL_ARCH_BIG_ENDIAN
   {
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 4, 4},	/* x = a */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 4, 0},	/* y = rgb */
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0}
   },
#else
   {
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 4, 0},	/* x = rgb */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 4, 4},	/* y = a */
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0}
   },
#endif
#if UTIL_ARCH_BIG_ENDIAN
   {
      PIPE_SWIZZLE_Y,	/* r */
      PIPE_SWIZZLE_Y,	/* g */
      PIPE_SWIZZLE_Y,	/* b */
      PIPE_SWIZZLE_X	/* a */
   },
#else
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_X,	/* g */
      PIPE_SWIZZLE_X,	/* b */
      PIPE_SWIZZLE_Y	/* a */
   },
#endif
      .colorspace = UTIL_FORMAT_COLORSPACE_RGB,
      .srgb_equivalent = PIPE_FORMAT_NONE,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_L8A8_UNORM] = {
      .format = PIPE_FORMAT_L8A8_UNORM,
      .name = "PIPE_FORMAT_L8A8_UNORM",
      .short_name = "l8a8_unorm",
      .block = {1, 1, 1, 16},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_PLAIN,
      .nr_channels = 2,	/* nr_channels */
      .is_array = true,	/* is_array */
      .is_bitmask = true,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = true,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
#if UTIL_ARCH_BIG_ENDIAN
   {
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 8, 8},	/* x = rgb */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 8, 0},	/* y = a */
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0}
   },
#else
   {
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 8, 0},	/* x = rgb */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 8, 8},	/* y = a */
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0}
   },
#endif
#if UTIL_ARCH_BIG_ENDIAN
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_X,	/* g */
      PIPE_SWIZZLE_X,	/* b */
      PIPE_SWIZZLE_Y	/* a */
   },
#else
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_X,	/* g */
      PIPE_SWIZZLE_X,	/* b */
      PIPE_SWIZZLE_Y	/* a */
   },
#endif
      .colorspace = UTIL_FORMAT_COLORSPACE_RGB,
      .srgb_equivalent = PIPE_FORMAT_L8A8_SRGB,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_L16_UNORM] = {
      .format = PIPE_FORMAT_L16_UNORM,
      .name = "PIPE_FORMAT_L16_UNORM",
      .short_name = "l16_unorm",
      .block = {1, 1, 1, 16},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_PLAIN,
      .nr_channels = 1,	/* nr_channels */
      .is_array = true,	/* is_array */
      .is_bitmask = true,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = true,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
   {
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 16, 0},	/* x = rgb */
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0}
   },
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_X,	/* g */
      PIPE_SWIZZLE_X,	/* b */
      PIPE_SWIZZLE_1	/* a */
   },
      .colorspace = UTIL_FORMAT_COLORSPACE_RGB,
      .srgb_equivalent = PIPE_FORMAT_NONE,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_A16_UNORM] = {
      .format = PIPE_FORMAT_A16_UNORM,
      .name = "PIPE_FORMAT_A16_UNORM",
      .short_name = "a16_unorm",
      .block = {1, 1, 1, 16},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_PLAIN,
      .nr_channels = 1,	/* nr_channels */
      .is_array = true,	/* is_array */
      .is_bitmask = true,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = true,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
   {
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 16, 0},	/* x = a */
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0}
   },
   {
      PIPE_SWIZZLE_0,	/* r */
      PIPE_SWIZZLE_0,	/* g */
      PIPE_SWIZZLE_0,	/* b */
      PIPE_SWIZZLE_X	/* a */
   },
      .colorspace = UTIL_FORMAT_COLORSPACE_RGB,
      .srgb_equivalent = PIPE_FORMAT_NONE,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_I16_UNORM] = {
      .format = PIPE_FORMAT_I16_UNORM,
      .name = "PIPE_FORMAT_I16_UNORM",
      .short_name = "i16_unorm",
      .block = {1, 1, 1, 16},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_PLAIN,
      .nr_channels = 1,	/* nr_channels */
      .is_array = true,	/* is_array */
      .is_bitmask = true,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = true,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
   {
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 16, 0},	/* x = rgba */
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0}
   },
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_X,	/* g */
      PIPE_SWIZZLE_X,	/* b */
      PIPE_SWIZZLE_X	/* a */
   },
      .colorspace = UTIL_FORMAT_COLORSPACE_RGB,
      .srgb_equivalent = PIPE_FORMAT_NONE,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_L16A16_UNORM] = {
      .format = PIPE_FORMAT_L16A16_UNORM,
      .name = "PIPE_FORMAT_L16A16_UNORM",
      .short_name = "l16a16_unorm",
      .block = {1, 1, 1, 32},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_PLAIN,
      .nr_channels = 2,	/* nr_channels */
      .is_array = true,	/* is_array */
      .is_bitmask = true,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = true,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
#if UTIL_ARCH_BIG_ENDIAN
   {
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 16, 16},	/* x = rgb */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 16, 0},	/* y = a */
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0}
   },
#else
   {
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 16, 0},	/* x = rgb */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 16, 16},	/* y = a */
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0}
   },
#endif
#if UTIL_ARCH_BIG_ENDIAN
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_X,	/* g */
      PIPE_SWIZZLE_X,	/* b */
      PIPE_SWIZZLE_Y	/* a */
   },
#else
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_X,	/* g */
      PIPE_SWIZZLE_X,	/* b */
      PIPE_SWIZZLE_Y	/* a */
   },
#endif
      .colorspace = UTIL_FORMAT_COLORSPACE_RGB,
      .srgb_equivalent = PIPE_FORMAT_NONE,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_A8_SNORM] = {
      .format = PIPE_FORMAT_A8_SNORM,
      .name = "PIPE_FORMAT_A8_SNORM",
      .short_name = "a8_snorm",
      .block = {1, 1, 1, 8},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_PLAIN,
      .nr_channels = 1,	/* nr_channels */
      .is_array = true,	/* is_array */
      .is_bitmask = true,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = false,	/* is_unorm */
      .is_snorm = true,	/* is_snorm */
   {
      {UTIL_FORMAT_TYPE_SIGNED, true, false, 8, 0},	/* x = a */
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0}
   },
   {
      PIPE_SWIZZLE_0,	/* r */
      PIPE_SWIZZLE_0,	/* g */
      PIPE_SWIZZLE_0,	/* b */
      PIPE_SWIZZLE_X	/* a */
   },
      .colorspace = UTIL_FORMAT_COLORSPACE_RGB,
      .srgb_equivalent = PIPE_FORMAT_NONE,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_L8_SNORM] = {
      .format = PIPE_FORMAT_L8_SNORM,
      .name = "PIPE_FORMAT_L8_SNORM",
      .short_name = "l8_snorm",
      .block = {1, 1, 1, 8},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_PLAIN,
      .nr_channels = 1,	/* nr_channels */
      .is_array = true,	/* is_array */
      .is_bitmask = true,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = false,	/* is_unorm */
      .is_snorm = true,	/* is_snorm */
   {
      {UTIL_FORMAT_TYPE_SIGNED, true, false, 8, 0},	/* x = rgb */
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0}
   },
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_X,	/* g */
      PIPE_SWIZZLE_X,	/* b */
      PIPE_SWIZZLE_1	/* a */
   },
      .colorspace = UTIL_FORMAT_COLORSPACE_RGB,
      .srgb_equivalent = PIPE_FORMAT_NONE,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_L8A8_SNORM] = {
      .format = PIPE_FORMAT_L8A8_SNORM,
      .name = "PIPE_FORMAT_L8A8_SNORM",
      .short_name = "l8a8_snorm",
      .block = {1, 1, 1, 16},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_PLAIN,
      .nr_channels = 2,	/* nr_channels */
      .is_array = true,	/* is_array */
      .is_bitmask = true,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = false,	/* is_unorm */
      .is_snorm = true,	/* is_snorm */
#if UTIL_ARCH_BIG_ENDIAN
   {
      {UTIL_FORMAT_TYPE_SIGNED, true, false, 8, 8},	/* x = rgb */
      {UTIL_FORMAT_TYPE_SIGNED, true, false, 8, 0},	/* y = a */
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0}
   },
#else
   {
      {UTIL_FORMAT_TYPE_SIGNED, true, false, 8, 0},	/* x = rgb */
      {UTIL_FORMAT_TYPE_SIGNED, true, false, 8, 8},	/* y = a */
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0}
   },
#endif
#if UTIL_ARCH_BIG_ENDIAN
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_X,	/* g */
      PIPE_SWIZZLE_X,	/* b */
      PIPE_SWIZZLE_Y	/* a */
   },
#else
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_X,	/* g */
      PIPE_SWIZZLE_X,	/* b */
      PIPE_SWIZZLE_Y	/* a */
   },
#endif
      .colorspace = UTIL_FORMAT_COLORSPACE_RGB,
      .srgb_equivalent = PIPE_FORMAT_NONE,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_I8_SNORM] = {
      .format = PIPE_FORMAT_I8_SNORM,
      .name = "PIPE_FORMAT_I8_SNORM",
      .short_name = "i8_snorm",
      .block = {1, 1, 1, 8},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_PLAIN,
      .nr_channels = 1,	/* nr_channels */
      .is_array = true,	/* is_array */
      .is_bitmask = true,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = false,	/* is_unorm */
      .is_snorm = true,	/* is_snorm */
   {
      {UTIL_FORMAT_TYPE_SIGNED, true, false, 8, 0},	/* x = rgba */
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0}
   },
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_X,	/* g */
      PIPE_SWIZZLE_X,	/* b */
      PIPE_SWIZZLE_X	/* a */
   },
      .colorspace = UTIL_FORMAT_COLORSPACE_RGB,
      .srgb_equivalent = PIPE_FORMAT_NONE,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_A16_SNORM] = {
      .format = PIPE_FORMAT_A16_SNORM,
      .name = "PIPE_FORMAT_A16_SNORM",
      .short_name = "a16_snorm",
      .block = {1, 1, 1, 16},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_PLAIN,
      .nr_channels = 1,	/* nr_channels */
      .is_array = true,	/* is_array */
      .is_bitmask = true,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = false,	/* is_unorm */
      .is_snorm = true,	/* is_snorm */
   {
      {UTIL_FORMAT_TYPE_SIGNED, true, false, 16, 0},	/* x = a */
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0}
   },
   {
      PIPE_SWIZZLE_0,	/* r */
      PIPE_SWIZZLE_0,	/* g */
      PIPE_SWIZZLE_0,	/* b */
      PIPE_SWIZZLE_X	/* a */
   },
      .colorspace = UTIL_FORMAT_COLORSPACE_RGB,
      .srgb_equivalent = PIPE_FORMAT_NONE,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_L16_SNORM] = {
      .format = PIPE_FORMAT_L16_SNORM,
      .name = "PIPE_FORMAT_L16_SNORM",
      .short_name = "l16_snorm",
      .block = {1, 1, 1, 16},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_PLAIN,
      .nr_channels = 1,	/* nr_channels */
      .is_array = true,	/* is_array */
      .is_bitmask = true,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = false,	/* is_unorm */
      .is_snorm = true,	/* is_snorm */
   {
      {UTIL_FORMAT_TYPE_SIGNED, true, false, 16, 0},	/* x = rgb */
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0}
   },
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_X,	/* g */
      PIPE_SWIZZLE_X,	/* b */
      PIPE_SWIZZLE_1	/* a */
   },
      .colorspace = UTIL_FORMAT_COLORSPACE_RGB,
      .srgb_equivalent = PIPE_FORMAT_NONE,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_L16A16_SNORM] = {
      .format = PIPE_FORMAT_L16A16_SNORM,
      .name = "PIPE_FORMAT_L16A16_SNORM",
      .short_name = "l16a16_snorm",
      .block = {1, 1, 1, 32},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_PLAIN,
      .nr_channels = 2,	/* nr_channels */
      .is_array = true,	/* is_array */
      .is_bitmask = true,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = false,	/* is_unorm */
      .is_snorm = true,	/* is_snorm */
#if UTIL_ARCH_BIG_ENDIAN
   {
      {UTIL_FORMAT_TYPE_SIGNED, true, false, 16, 16},	/* x = rgb */
      {UTIL_FORMAT_TYPE_SIGNED, true, false, 16, 0},	/* y = a */
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0}
   },
#else
   {
      {UTIL_FORMAT_TYPE_SIGNED, true, false, 16, 0},	/* x = rgb */
      {UTIL_FORMAT_TYPE_SIGNED, true, false, 16, 16},	/* y = a */
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0}
   },
#endif
#if UTIL_ARCH_BIG_ENDIAN
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_X,	/* g */
      PIPE_SWIZZLE_X,	/* b */
      PIPE_SWIZZLE_Y	/* a */
   },
#else
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_X,	/* g */
      PIPE_SWIZZLE_X,	/* b */
      PIPE_SWIZZLE_Y	/* a */
   },
#endif
      .colorspace = UTIL_FORMAT_COLORSPACE_RGB,
      .srgb_equivalent = PIPE_FORMAT_NONE,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_I16_SNORM] = {
      .format = PIPE_FORMAT_I16_SNORM,
      .name = "PIPE_FORMAT_I16_SNORM",
      .short_name = "i16_snorm",
      .block = {1, 1, 1, 16},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_PLAIN,
      .nr_channels = 1,	/* nr_channels */
      .is_array = true,	/* is_array */
      .is_bitmask = true,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = false,	/* is_unorm */
      .is_snorm = true,	/* is_snorm */
   {
      {UTIL_FORMAT_TYPE_SIGNED, true, false, 16, 0},	/* x = rgba */
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0}
   },
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_X,	/* g */
      PIPE_SWIZZLE_X,	/* b */
      PIPE_SWIZZLE_X	/* a */
   },
      .colorspace = UTIL_FORMAT_COLORSPACE_RGB,
      .srgb_equivalent = PIPE_FORMAT_NONE,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_A16_FLOAT] = {
      .format = PIPE_FORMAT_A16_FLOAT,
      .name = "PIPE_FORMAT_A16_FLOAT",
      .short_name = "a16_float",
      .block = {1, 1, 1, 16},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_PLAIN,
      .nr_channels = 1,	/* nr_channels */
      .is_array = true,	/* is_array */
      .is_bitmask = false,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = false,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
   {
      {UTIL_FORMAT_TYPE_FLOAT, false, false, 16, 0},	/* x = a */
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0}
   },
   {
      PIPE_SWIZZLE_0,	/* r */
      PIPE_SWIZZLE_0,	/* g */
      PIPE_SWIZZLE_0,	/* b */
      PIPE_SWIZZLE_X	/* a */
   },
      .colorspace = UTIL_FORMAT_COLORSPACE_RGB,
      .srgb_equivalent = PIPE_FORMAT_NONE,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_L16_FLOAT] = {
      .format = PIPE_FORMAT_L16_FLOAT,
      .name = "PIPE_FORMAT_L16_FLOAT",
      .short_name = "l16_float",
      .block = {1, 1, 1, 16},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_PLAIN,
      .nr_channels = 1,	/* nr_channels */
      .is_array = true,	/* is_array */
      .is_bitmask = false,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = false,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
   {
      {UTIL_FORMAT_TYPE_FLOAT, false, false, 16, 0},	/* x = rgb */
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0}
   },
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_X,	/* g */
      PIPE_SWIZZLE_X,	/* b */
      PIPE_SWIZZLE_1	/* a */
   },
      .colorspace = UTIL_FORMAT_COLORSPACE_RGB,
      .srgb_equivalent = PIPE_FORMAT_NONE,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_L16A16_FLOAT] = {
      .format = PIPE_FORMAT_L16A16_FLOAT,
      .name = "PIPE_FORMAT_L16A16_FLOAT",
      .short_name = "l16a16_float",
      .block = {1, 1, 1, 32},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_PLAIN,
      .nr_channels = 2,	/* nr_channels */
      .is_array = true,	/* is_array */
      .is_bitmask = false,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = false,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
#if UTIL_ARCH_BIG_ENDIAN
   {
      {UTIL_FORMAT_TYPE_FLOAT, false, false, 16, 16},	/* x = rgb */
      {UTIL_FORMAT_TYPE_FLOAT, false, false, 16, 0},	/* y = a */
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0}
   },
#else
   {
      {UTIL_FORMAT_TYPE_FLOAT, false, false, 16, 0},	/* x = rgb */
      {UTIL_FORMAT_TYPE_FLOAT, false, false, 16, 16},	/* y = a */
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0}
   },
#endif
#if UTIL_ARCH_BIG_ENDIAN
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_X,	/* g */
      PIPE_SWIZZLE_X,	/* b */
      PIPE_SWIZZLE_Y	/* a */
   },
#else
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_X,	/* g */
      PIPE_SWIZZLE_X,	/* b */
      PIPE_SWIZZLE_Y	/* a */
   },
#endif
      .colorspace = UTIL_FORMAT_COLORSPACE_RGB,
      .srgb_equivalent = PIPE_FORMAT_NONE,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_I16_FLOAT] = {
      .format = PIPE_FORMAT_I16_FLOAT,
      .name = "PIPE_FORMAT_I16_FLOAT",
      .short_name = "i16_float",
      .block = {1, 1, 1, 16},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_PLAIN,
      .nr_channels = 1,	/* nr_channels */
      .is_array = true,	/* is_array */
      .is_bitmask = false,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = false,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
   {
      {UTIL_FORMAT_TYPE_FLOAT, false, false, 16, 0},	/* x = rgba */
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0}
   },
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_X,	/* g */
      PIPE_SWIZZLE_X,	/* b */
      PIPE_SWIZZLE_X	/* a */
   },
      .colorspace = UTIL_FORMAT_COLORSPACE_RGB,
      .srgb_equivalent = PIPE_FORMAT_NONE,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_A32_FLOAT] = {
      .format = PIPE_FORMAT_A32_FLOAT,
      .name = "PIPE_FORMAT_A32_FLOAT",
      .short_name = "a32_float",
      .block = {1, 1, 1, 32},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_PLAIN,
      .nr_channels = 1,	/* nr_channels */
      .is_array = true,	/* is_array */
      .is_bitmask = false,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = false,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
   {
      {UTIL_FORMAT_TYPE_FLOAT, false, false, 32, 0},	/* x = a */
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0}
   },
   {
      PIPE_SWIZZLE_0,	/* r */
      PIPE_SWIZZLE_0,	/* g */
      PIPE_SWIZZLE_0,	/* b */
      PIPE_SWIZZLE_X	/* a */
   },
      .colorspace = UTIL_FORMAT_COLORSPACE_RGB,
      .srgb_equivalent = PIPE_FORMAT_NONE,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_L32_FLOAT] = {
      .format = PIPE_FORMAT_L32_FLOAT,
      .name = "PIPE_FORMAT_L32_FLOAT",
      .short_name = "l32_float",
      .block = {1, 1, 1, 32},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_PLAIN,
      .nr_channels = 1,	/* nr_channels */
      .is_array = true,	/* is_array */
      .is_bitmask = false,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = false,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
   {
      {UTIL_FORMAT_TYPE_FLOAT, false, false, 32, 0},	/* x = rgb */
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0}
   },
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_X,	/* g */
      PIPE_SWIZZLE_X,	/* b */
      PIPE_SWIZZLE_1	/* a */
   },
      .colorspace = UTIL_FORMAT_COLORSPACE_RGB,
      .srgb_equivalent = PIPE_FORMAT_NONE,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_L32A32_FLOAT] = {
      .format = PIPE_FORMAT_L32A32_FLOAT,
      .name = "PIPE_FORMAT_L32A32_FLOAT",
      .short_name = "l32a32_float",
      .block = {1, 1, 1, 64},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_PLAIN,
      .nr_channels = 2,	/* nr_channels */
      .is_array = true,	/* is_array */
      .is_bitmask = false,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = false,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
#if UTIL_ARCH_BIG_ENDIAN
   {
      {UTIL_FORMAT_TYPE_FLOAT, false, false, 32, 32},	/* x = rgb */
      {UTIL_FORMAT_TYPE_FLOAT, false, false, 32, 0},	/* y = a */
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0}
   },
#else
   {
      {UTIL_FORMAT_TYPE_FLOAT, false, false, 32, 0},	/* x = rgb */
      {UTIL_FORMAT_TYPE_FLOAT, false, false, 32, 32},	/* y = a */
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0}
   },
#endif
#if UTIL_ARCH_BIG_ENDIAN
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_X,	/* g */
      PIPE_SWIZZLE_X,	/* b */
      PIPE_SWIZZLE_Y	/* a */
   },
#else
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_X,	/* g */
      PIPE_SWIZZLE_X,	/* b */
      PIPE_SWIZZLE_Y	/* a */
   },
#endif
      .colorspace = UTIL_FORMAT_COLORSPACE_RGB,
      .srgb_equivalent = PIPE_FORMAT_NONE,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_I32_FLOAT] = {
      .format = PIPE_FORMAT_I32_FLOAT,
      .name = "PIPE_FORMAT_I32_FLOAT",
      .short_name = "i32_float",
      .block = {1, 1, 1, 32},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_PLAIN,
      .nr_channels = 1,	/* nr_channels */
      .is_array = true,	/* is_array */
      .is_bitmask = false,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = false,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
   {
      {UTIL_FORMAT_TYPE_FLOAT, false, false, 32, 0},	/* x = rgba */
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0}
   },
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_X,	/* g */
      PIPE_SWIZZLE_X,	/* b */
      PIPE_SWIZZLE_X	/* a */
   },
      .colorspace = UTIL_FORMAT_COLORSPACE_RGB,
      .srgb_equivalent = PIPE_FORMAT_NONE,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_L8_SRGB] = {
      .format = PIPE_FORMAT_L8_SRGB,
      .name = "PIPE_FORMAT_L8_SRGB",
      .short_name = "l8_srgb",
      .block = {1, 1, 1, 8},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_PLAIN,
      .nr_channels = 1,	/* nr_channels */
      .is_array = true,	/* is_array */
      .is_bitmask = true,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = true,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
   {
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 8, 0},	/* x = rgb */
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0}
   },
   {
      PIPE_SWIZZLE_X,	/* sr */
      PIPE_SWIZZLE_X,	/* sg */
      PIPE_SWIZZLE_X,	/* sb */
      PIPE_SWIZZLE_1	/* a */
   },
      .colorspace = UTIL_FORMAT_COLORSPACE_SRGB,
      .linear_equivalent = PIPE_FORMAT_L8_UNORM,	/* linear_equivalent */
   },

   [PIPE_FORMAT_R8_SRGB] = {
      .format = PIPE_FORMAT_R8_SRGB,
      .name = "PIPE_FORMAT_R8_SRGB",
      .short_name = "r8_srgb",
      .block = {1, 1, 1, 8},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_PLAIN,
      .nr_channels = 1,	/* nr_channels */
      .is_array = true,	/* is_array */
      .is_bitmask = true,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = true,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
   {
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 8, 0},	/* x = r */
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0}
   },
   {
      PIPE_SWIZZLE_X,	/* sr */
      PIPE_SWIZZLE_0,	/* sg */
      PIPE_SWIZZLE_0,	/* sb */
      PIPE_SWIZZLE_1	/* a */
   },
      .colorspace = UTIL_FORMAT_COLORSPACE_SRGB,
      .linear_equivalent = PIPE_FORMAT_R8_UNORM,	/* linear_equivalent */
   },

   [PIPE_FORMAT_L8A8_SRGB] = {
      .format = PIPE_FORMAT_L8A8_SRGB,
      .name = "PIPE_FORMAT_L8A8_SRGB",
      .short_name = "l8a8_srgb",
      .block = {1, 1, 1, 16},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_PLAIN,
      .nr_channels = 2,	/* nr_channels */
      .is_array = true,	/* is_array */
      .is_bitmask = true,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = true,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
#if UTIL_ARCH_BIG_ENDIAN
   {
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 8, 8},	/* x = rgb */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 8, 0},	/* y = a */
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0}
   },
#else
   {
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 8, 0},	/* x = rgb */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 8, 8},	/* y = a */
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0}
   },
#endif
#if UTIL_ARCH_BIG_ENDIAN
   {
      PIPE_SWIZZLE_X,	/* sr */
      PIPE_SWIZZLE_X,	/* sg */
      PIPE_SWIZZLE_X,	/* sb */
      PIPE_SWIZZLE_Y	/* a */
   },
#else
   {
      PIPE_SWIZZLE_X,	/* sr */
      PIPE_SWIZZLE_X,	/* sg */
      PIPE_SWIZZLE_X,	/* sb */
      PIPE_SWIZZLE_Y	/* a */
   },
#endif
      .colorspace = UTIL_FORMAT_COLORSPACE_SRGB,
      .linear_equivalent = PIPE_FORMAT_L8A8_UNORM,	/* linear_equivalent */
   },

   [PIPE_FORMAT_R8G8_SRGB] = {
      .format = PIPE_FORMAT_R8G8_SRGB,
      .name = "PIPE_FORMAT_R8G8_SRGB",
      .short_name = "r8g8_srgb",
      .block = {1, 1, 1, 16},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_PLAIN,
      .nr_channels = 2,	/* nr_channels */
      .is_array = true,	/* is_array */
      .is_bitmask = true,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = true,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
#if UTIL_ARCH_BIG_ENDIAN
   {
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 8, 8},	/* x = r */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 8, 0},	/* y = g */
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0}
   },
#else
   {
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 8, 0},	/* x = r */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 8, 8},	/* y = g */
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0}
   },
#endif
#if UTIL_ARCH_BIG_ENDIAN
   {
      PIPE_SWIZZLE_X,	/* sr */
      PIPE_SWIZZLE_Y,	/* sg */
      PIPE_SWIZZLE_0,	/* sb */
      PIPE_SWIZZLE_1	/* a */
   },
#else
   {
      PIPE_SWIZZLE_X,	/* sr */
      PIPE_SWIZZLE_Y,	/* sg */
      PIPE_SWIZZLE_0,	/* sb */
      PIPE_SWIZZLE_1	/* a */
   },
#endif
      .colorspace = UTIL_FORMAT_COLORSPACE_SRGB,
      .linear_equivalent = PIPE_FORMAT_R8G8_UNORM,	/* linear_equivalent */
   },

   [PIPE_FORMAT_R8G8B8_SRGB] = {
      .format = PIPE_FORMAT_R8G8B8_SRGB,
      .name = "PIPE_FORMAT_R8G8B8_SRGB",
      .short_name = "r8g8b8_srgb",
      .block = {1, 1, 1, 24},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_PLAIN,
      .nr_channels = 3,	/* nr_channels */
      .is_array = true,	/* is_array */
      .is_bitmask = false,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = true,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
#if UTIL_ARCH_BIG_ENDIAN
   {
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 8, 16},	/* x = r */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 8, 8},	/* y = g */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 8, 0},	/* z = b */
      {0, 0, 0, 0, 0}
   },
#else
   {
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 8, 0},	/* x = r */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 8, 8},	/* y = g */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 8, 16},	/* z = b */
      {0, 0, 0, 0, 0}
   },
#endif
#if UTIL_ARCH_BIG_ENDIAN
   {
      PIPE_SWIZZLE_X,	/* sr */
      PIPE_SWIZZLE_Y,	/* sg */
      PIPE_SWIZZLE_Z,	/* sb */
      PIPE_SWIZZLE_1	/* a */
   },
#else
   {
      PIPE_SWIZZLE_X,	/* sr */
      PIPE_SWIZZLE_Y,	/* sg */
      PIPE_SWIZZLE_Z,	/* sb */
      PIPE_SWIZZLE_1	/* a */
   },
#endif
      .colorspace = UTIL_FORMAT_COLORSPACE_SRGB,
      .linear_equivalent = PIPE_FORMAT_R8G8B8_UNORM,	/* linear_equivalent */
   },

   [PIPE_FORMAT_B8G8R8_SRGB] = {
      .format = PIPE_FORMAT_B8G8R8_SRGB,
      .name = "PIPE_FORMAT_B8G8R8_SRGB",
      .short_name = "b8g8r8_srgb",
      .block = {1, 1, 1, 24},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_PLAIN,
      .nr_channels = 3,	/* nr_channels */
      .is_array = true,	/* is_array */
      .is_bitmask = false,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = true,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
#if UTIL_ARCH_BIG_ENDIAN
   {
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 8, 16},	/* x = b */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 8, 8},	/* y = g */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 8, 0},	/* z = r */
      {0, 0, 0, 0, 0}
   },
#else
   {
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 8, 0},	/* x = b */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 8, 8},	/* y = g */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 8, 16},	/* z = r */
      {0, 0, 0, 0, 0}
   },
#endif
#if UTIL_ARCH_BIG_ENDIAN
   {
      PIPE_SWIZZLE_Z,	/* sr */
      PIPE_SWIZZLE_Y,	/* sg */
      PIPE_SWIZZLE_X,	/* sb */
      PIPE_SWIZZLE_1	/* a */
   },
#else
   {
      PIPE_SWIZZLE_Z,	/* sr */
      PIPE_SWIZZLE_Y,	/* sg */
      PIPE_SWIZZLE_X,	/* sb */
      PIPE_SWIZZLE_1	/* a */
   },
#endif
      .colorspace = UTIL_FORMAT_COLORSPACE_SRGB,
      .linear_equivalent = PIPE_FORMAT_B8G8R8_UNORM,	/* linear_equivalent */
   },

   [PIPE_FORMAT_R8G8B8A8_SRGB] = {
      .format = PIPE_FORMAT_R8G8B8A8_SRGB,
      .name = "PIPE_FORMAT_R8G8B8A8_SRGB",
      .short_name = "r8g8b8a8_srgb",
      .block = {1, 1, 1, 32},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_PLAIN,
      .nr_channels = 4,	/* nr_channels */
      .is_array = true,	/* is_array */
      .is_bitmask = true,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = true,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
#if UTIL_ARCH_BIG_ENDIAN
   {
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 8, 24},	/* x = r */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 8, 16},	/* y = g */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 8, 8},	/* z = b */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 8, 0}	/* w = a */
   },
#else
   {
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 8, 0},	/* x = r */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 8, 8},	/* y = g */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 8, 16},	/* z = b */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 8, 24}	/* w = a */
   },
#endif
#if UTIL_ARCH_BIG_ENDIAN
   {
      PIPE_SWIZZLE_X,	/* sr */
      PIPE_SWIZZLE_Y,	/* sg */
      PIPE_SWIZZLE_Z,	/* sb */
      PIPE_SWIZZLE_W	/* a */
   },
#else
   {
      PIPE_SWIZZLE_X,	/* sr */
      PIPE_SWIZZLE_Y,	/* sg */
      PIPE_SWIZZLE_Z,	/* sb */
      PIPE_SWIZZLE_W	/* a */
   },
#endif
      .colorspace = UTIL_FORMAT_COLORSPACE_SRGB,
      .linear_equivalent = PIPE_FORMAT_R8G8B8A8_UNORM,	/* linear_equivalent */
   },

   [PIPE_FORMAT_A8B8G8R8_SRGB] = {
      .format = PIPE_FORMAT_A8B8G8R8_SRGB,
      .name = "PIPE_FORMAT_A8B8G8R8_SRGB",
      .short_name = "a8b8g8r8_srgb",
      .block = {1, 1, 1, 32},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_PLAIN,
      .nr_channels = 4,	/* nr_channels */
      .is_array = true,	/* is_array */
      .is_bitmask = true,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = true,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
#if UTIL_ARCH_BIG_ENDIAN
   {
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 8, 24},	/* x = a */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 8, 16},	/* y = b */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 8, 8},	/* z = g */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 8, 0}	/* w = r */
   },
#else
   {
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 8, 0},	/* x = a */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 8, 8},	/* y = b */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 8, 16},	/* z = g */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 8, 24}	/* w = r */
   },
#endif
#if UTIL_ARCH_BIG_ENDIAN
   {
      PIPE_SWIZZLE_W,	/* sr */
      PIPE_SWIZZLE_Z,	/* sg */
      PIPE_SWIZZLE_Y,	/* sb */
      PIPE_SWIZZLE_X	/* a */
   },
#else
   {
      PIPE_SWIZZLE_W,	/* sr */
      PIPE_SWIZZLE_Z,	/* sg */
      PIPE_SWIZZLE_Y,	/* sb */
      PIPE_SWIZZLE_X	/* a */
   },
#endif
      .colorspace = UTIL_FORMAT_COLORSPACE_SRGB,
      .linear_equivalent = PIPE_FORMAT_A8B8G8R8_UNORM,	/* linear_equivalent */
   },

   [PIPE_FORMAT_X8B8G8R8_SRGB] = {
      .format = PIPE_FORMAT_X8B8G8R8_SRGB,
      .name = "PIPE_FORMAT_X8B8G8R8_SRGB",
      .short_name = "x8b8g8r8_srgb",
      .block = {1, 1, 1, 32},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_PLAIN,
      .nr_channels = 4,	/* nr_channels */
      .is_array = true,	/* is_array */
      .is_bitmask = true,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = true,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
#if UTIL_ARCH_BIG_ENDIAN
   {
      {UTIL_FORMAT_TYPE_VOID, false, false, 8, 24},	/* x = x */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 8, 16},	/* y = b */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 8, 8},	/* z = g */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 8, 0}	/* w = r */
   },
#else
   {
      {UTIL_FORMAT_TYPE_VOID, false, false, 8, 0},	/* x = x */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 8, 8},	/* y = b */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 8, 16},	/* z = g */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 8, 24}	/* w = r */
   },
#endif
#if UTIL_ARCH_BIG_ENDIAN
   {
      PIPE_SWIZZLE_W,	/* sr */
      PIPE_SWIZZLE_Z,	/* sg */
      PIPE_SWIZZLE_Y,	/* sb */
      PIPE_SWIZZLE_1	/* a */
   },
#else
   {
      PIPE_SWIZZLE_W,	/* sr */
      PIPE_SWIZZLE_Z,	/* sg */
      PIPE_SWIZZLE_Y,	/* sb */
      PIPE_SWIZZLE_1	/* a */
   },
#endif
      .colorspace = UTIL_FORMAT_COLORSPACE_SRGB,
      .linear_equivalent = PIPE_FORMAT_X8B8G8R8_UNORM,	/* linear_equivalent */
   },

   [PIPE_FORMAT_B8G8R8A8_SRGB] = {
      .format = PIPE_FORMAT_B8G8R8A8_SRGB,
      .name = "PIPE_FORMAT_B8G8R8A8_SRGB",
      .short_name = "b8g8r8a8_srgb",
      .block = {1, 1, 1, 32},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_PLAIN,
      .nr_channels = 4,	/* nr_channels */
      .is_array = true,	/* is_array */
      .is_bitmask = true,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = true,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
#if UTIL_ARCH_BIG_ENDIAN
   {
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 8, 24},	/* x = b */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 8, 16},	/* y = g */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 8, 8},	/* z = r */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 8, 0}	/* w = a */
   },
#else
   {
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 8, 0},	/* x = b */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 8, 8},	/* y = g */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 8, 16},	/* z = r */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 8, 24}	/* w = a */
   },
#endif
#if UTIL_ARCH_BIG_ENDIAN
   {
      PIPE_SWIZZLE_Z,	/* sr */
      PIPE_SWIZZLE_Y,	/* sg */
      PIPE_SWIZZLE_X,	/* sb */
      PIPE_SWIZZLE_W	/* a */
   },
#else
   {
      PIPE_SWIZZLE_Z,	/* sr */
      PIPE_SWIZZLE_Y,	/* sg */
      PIPE_SWIZZLE_X,	/* sb */
      PIPE_SWIZZLE_W	/* a */
   },
#endif
      .colorspace = UTIL_FORMAT_COLORSPACE_SRGB,
      .linear_equivalent = PIPE_FORMAT_B8G8R8A8_UNORM,	/* linear_equivalent */
   },

   [PIPE_FORMAT_B8G8R8X8_SRGB] = {
      .format = PIPE_FORMAT_B8G8R8X8_SRGB,
      .name = "PIPE_FORMAT_B8G8R8X8_SRGB",
      .short_name = "b8g8r8x8_srgb",
      .block = {1, 1, 1, 32},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_PLAIN,
      .nr_channels = 4,	/* nr_channels */
      .is_array = true,	/* is_array */
      .is_bitmask = true,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = true,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
#if UTIL_ARCH_BIG_ENDIAN
   {
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 8, 24},	/* x = b */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 8, 16},	/* y = g */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 8, 8},	/* z = r */
      {UTIL_FORMAT_TYPE_VOID, false, false, 8, 0}	/* w = x */
   },
#else
   {
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 8, 0},	/* x = b */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 8, 8},	/* y = g */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 8, 16},	/* z = r */
      {UTIL_FORMAT_TYPE_VOID, false, false, 8, 24}	/* w = x */
   },
#endif
#if UTIL_ARCH_BIG_ENDIAN
   {
      PIPE_SWIZZLE_Z,	/* sr */
      PIPE_SWIZZLE_Y,	/* sg */
      PIPE_SWIZZLE_X,	/* sb */
      PIPE_SWIZZLE_1	/* a */
   },
#else
   {
      PIPE_SWIZZLE_Z,	/* sr */
      PIPE_SWIZZLE_Y,	/* sg */
      PIPE_SWIZZLE_X,	/* sb */
      PIPE_SWIZZLE_1	/* a */
   },
#endif
      .colorspace = UTIL_FORMAT_COLORSPACE_SRGB,
      .linear_equivalent = PIPE_FORMAT_B8G8R8X8_UNORM,	/* linear_equivalent */
   },

   [PIPE_FORMAT_A8R8G8B8_SRGB] = {
      .format = PIPE_FORMAT_A8R8G8B8_SRGB,
      .name = "PIPE_FORMAT_A8R8G8B8_SRGB",
      .short_name = "a8r8g8b8_srgb",
      .block = {1, 1, 1, 32},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_PLAIN,
      .nr_channels = 4,	/* nr_channels */
      .is_array = true,	/* is_array */
      .is_bitmask = true,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = true,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
#if UTIL_ARCH_BIG_ENDIAN
   {
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 8, 24},	/* x = a */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 8, 16},	/* y = r */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 8, 8},	/* z = g */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 8, 0}	/* w = b */
   },
#else
   {
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 8, 0},	/* x = a */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 8, 8},	/* y = r */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 8, 16},	/* z = g */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 8, 24}	/* w = b */
   },
#endif
#if UTIL_ARCH_BIG_ENDIAN
   {
      PIPE_SWIZZLE_Y,	/* sr */
      PIPE_SWIZZLE_Z,	/* sg */
      PIPE_SWIZZLE_W,	/* sb */
      PIPE_SWIZZLE_X	/* a */
   },
#else
   {
      PIPE_SWIZZLE_Y,	/* sr */
      PIPE_SWIZZLE_Z,	/* sg */
      PIPE_SWIZZLE_W,	/* sb */
      PIPE_SWIZZLE_X	/* a */
   },
#endif
      .colorspace = UTIL_FORMAT_COLORSPACE_SRGB,
      .linear_equivalent = PIPE_FORMAT_A8R8G8B8_UNORM,	/* linear_equivalent */
   },

   [PIPE_FORMAT_X8R8G8B8_SRGB] = {
      .format = PIPE_FORMAT_X8R8G8B8_SRGB,
      .name = "PIPE_FORMAT_X8R8G8B8_SRGB",
      .short_name = "x8r8g8b8_srgb",
      .block = {1, 1, 1, 32},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_PLAIN,
      .nr_channels = 4,	/* nr_channels */
      .is_array = true,	/* is_array */
      .is_bitmask = true,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = true,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
#if UTIL_ARCH_BIG_ENDIAN
   {
      {UTIL_FORMAT_TYPE_VOID, false, false, 8, 24},	/* x = x */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 8, 16},	/* y = r */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 8, 8},	/* z = g */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 8, 0}	/* w = b */
   },
#else
   {
      {UTIL_FORMAT_TYPE_VOID, false, false, 8, 0},	/* x = x */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 8, 8},	/* y = r */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 8, 16},	/* z = g */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 8, 24}	/* w = b */
   },
#endif
#if UTIL_ARCH_BIG_ENDIAN
   {
      PIPE_SWIZZLE_Y,	/* sr */
      PIPE_SWIZZLE_Z,	/* sg */
      PIPE_SWIZZLE_W,	/* sb */
      PIPE_SWIZZLE_1	/* a */
   },
#else
   {
      PIPE_SWIZZLE_Y,	/* sr */
      PIPE_SWIZZLE_Z,	/* sg */
      PIPE_SWIZZLE_W,	/* sb */
      PIPE_SWIZZLE_1	/* a */
   },
#endif
      .colorspace = UTIL_FORMAT_COLORSPACE_SRGB,
      .linear_equivalent = PIPE_FORMAT_X8R8G8B8_UNORM,	/* linear_equivalent */
   },

   [PIPE_FORMAT_R8SG8SB8UX8U_NORM] = {
      .format = PIPE_FORMAT_R8SG8SB8UX8U_NORM,
      .name = "PIPE_FORMAT_R8SG8SB8UX8U_NORM",
      .short_name = "r8sg8sb8ux8u_norm",
      .block = {1, 1, 1, 32},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_PLAIN,
      .nr_channels = 4,	/* nr_channels */
      .is_array = false,	/* is_array */
      .is_bitmask = true,	/* is_bitmask */
      .is_mixed = true,	/* is_mixed */
      .is_unorm = false,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
#if UTIL_ARCH_BIG_ENDIAN
   {
      {UTIL_FORMAT_TYPE_VOID, false, false, 8, 24},	/* x = x */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 8, 16},	/* y = b */
      {UTIL_FORMAT_TYPE_SIGNED, true, false, 8, 8},	/* z = g */
      {UTIL_FORMAT_TYPE_SIGNED, true, false, 8, 0}	/* w = r */
   },
#else
   {
      {UTIL_FORMAT_TYPE_SIGNED, true, false, 8, 0},	/* x = r */
      {UTIL_FORMAT_TYPE_SIGNED, true, false, 8, 8},	/* y = g */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 8, 16},	/* z = b */
      {UTIL_FORMAT_TYPE_VOID, false, false, 8, 24}	/* w = x */
   },
#endif
#if UTIL_ARCH_BIG_ENDIAN
   {
      PIPE_SWIZZLE_W,	/* r */
      PIPE_SWIZZLE_Z,	/* g */
      PIPE_SWIZZLE_Y,	/* b */
      PIPE_SWIZZLE_1	/* a */
   },
#else
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_Y,	/* g */
      PIPE_SWIZZLE_Z,	/* b */
      PIPE_SWIZZLE_1	/* a */
   },
#endif
      .colorspace = UTIL_FORMAT_COLORSPACE_RGB,
      .srgb_equivalent = PIPE_FORMAT_NONE,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_R10SG10SB10SA2U_NORM] = {
      .format = PIPE_FORMAT_R10SG10SB10SA2U_NORM,
      .name = "PIPE_FORMAT_R10SG10SB10SA2U_NORM",
      .short_name = "r10sg10sb10sa2u_norm",
      .block = {1, 1, 1, 32},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_PLAIN,
      .nr_channels = 4,	/* nr_channels */
      .is_array = false,	/* is_array */
      .is_bitmask = true,	/* is_bitmask */
      .is_mixed = true,	/* is_mixed */
      .is_unorm = false,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
#if UTIL_ARCH_BIG_ENDIAN
   {
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 2, 30},	/* x = a */
      {UTIL_FORMAT_TYPE_SIGNED, true, false, 10, 20},	/* y = b */
      {UTIL_FORMAT_TYPE_SIGNED, true, false, 10, 10},	/* z = g */
      {UTIL_FORMAT_TYPE_SIGNED, true, false, 10, 0}	/* w = r */
   },
#else
   {
      {UTIL_FORMAT_TYPE_SIGNED, true, false, 10, 0},	/* x = r */
      {UTIL_FORMAT_TYPE_SIGNED, true, false, 10, 10},	/* y = g */
      {UTIL_FORMAT_TYPE_SIGNED, true, false, 10, 20},	/* z = b */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 2, 30}	/* w = a */
   },
#endif
#if UTIL_ARCH_BIG_ENDIAN
   {
      PIPE_SWIZZLE_W,	/* r */
      PIPE_SWIZZLE_Z,	/* g */
      PIPE_SWIZZLE_Y,	/* b */
      PIPE_SWIZZLE_X	/* a */
   },
#else
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_Y,	/* g */
      PIPE_SWIZZLE_Z,	/* b */
      PIPE_SWIZZLE_W	/* a */
   },
#endif
      .colorspace = UTIL_FORMAT_COLORSPACE_RGB,
      .srgb_equivalent = PIPE_FORMAT_NONE,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_R5SG5SB6U_NORM] = {
      .format = PIPE_FORMAT_R5SG5SB6U_NORM,
      .name = "PIPE_FORMAT_R5SG5SB6U_NORM",
      .short_name = "r5sg5sb6u_norm",
      .block = {1, 1, 1, 16},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_PLAIN,
      .nr_channels = 3,	/* nr_channels */
      .is_array = false,	/* is_array */
      .is_bitmask = true,	/* is_bitmask */
      .is_mixed = true,	/* is_mixed */
      .is_unorm = false,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
#if UTIL_ARCH_BIG_ENDIAN
   {
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 6, 10},	/* x = b */
      {UTIL_FORMAT_TYPE_SIGNED, true, false, 5, 5},	/* y = g */
      {UTIL_FORMAT_TYPE_SIGNED, true, false, 5, 0},	/* z = r */
      {0, 0, 0, 0, 0}
   },
#else
   {
      {UTIL_FORMAT_TYPE_SIGNED, true, false, 5, 0},	/* x = r */
      {UTIL_FORMAT_TYPE_SIGNED, true, false, 5, 5},	/* y = g */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 6, 10},	/* z = b */
      {0, 0, 0, 0, 0}
   },
#endif
#if UTIL_ARCH_BIG_ENDIAN
   {
      PIPE_SWIZZLE_Z,	/* r */
      PIPE_SWIZZLE_Y,	/* g */
      PIPE_SWIZZLE_X,	/* b */
      PIPE_SWIZZLE_1	/* a */
   },
#else
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_Y,	/* g */
      PIPE_SWIZZLE_Z,	/* b */
      PIPE_SWIZZLE_1	/* a */
   },
#endif
      .colorspace = UTIL_FORMAT_COLORSPACE_RGB,
      .srgb_equivalent = PIPE_FORMAT_NONE,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_S8_UINT] = {
      .format = PIPE_FORMAT_S8_UINT,
      .name = "PIPE_FORMAT_S8_UINT",
      .short_name = "s8_uint",
      .block = {1, 1, 1, 8},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_PLAIN,
      .nr_channels = 1,	/* nr_channels */
      .is_array = true,	/* is_array */
      .is_bitmask = true,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = false,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
   {
      {UTIL_FORMAT_TYPE_UNSIGNED, false, true, 8, 0},	/* x = s */
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0}
   },
   {
      PIPE_SWIZZLE_NONE,	/* z */
      PIPE_SWIZZLE_X,	/* s */
      PIPE_SWIZZLE_NONE,	/* ignored */
      PIPE_SWIZZLE_NONE	/* ignored */
   },
      .colorspace = UTIL_FORMAT_COLORSPACE_ZS,
      .srgb_equivalent = PIPE_FORMAT_NONE,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_Z16_UNORM] = {
      .format = PIPE_FORMAT_Z16_UNORM,
      .name = "PIPE_FORMAT_Z16_UNORM",
      .short_name = "z16_unorm",
      .block = {1, 1, 1, 16},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_PLAIN,
      .nr_channels = 1,	/* nr_channels */
      .is_array = true,	/* is_array */
      .is_bitmask = true,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = true,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
   {
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 16, 0},	/* x = z */
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0}
   },
   {
      PIPE_SWIZZLE_X,	/* z */
      PIPE_SWIZZLE_NONE,	/* s */
      PIPE_SWIZZLE_NONE,	/* ignored */
      PIPE_SWIZZLE_NONE	/* ignored */
   },
      .colorspace = UTIL_FORMAT_COLORSPACE_ZS,
      .srgb_equivalent = PIPE_FORMAT_NONE,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_Z16_UNORM_S8_UINT] = {
      .format = PIPE_FORMAT_Z16_UNORM_S8_UINT,
      .name = "PIPE_FORMAT_Z16_UNORM_S8_UINT",
      .short_name = "z16_unorm_s8_uint",
      .block = {1, 1, 1, 24},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_PLAIN,
      .nr_channels = 2,	/* nr_channels */
      .is_array = false,	/* is_array */
      .is_bitmask = false,	/* is_bitmask */
      .is_mixed = true,	/* is_mixed */
      .is_unorm = true,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
#if UTIL_ARCH_BIG_ENDIAN
   {
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 16, 8},	/* x = z */
      {UTIL_FORMAT_TYPE_UNSIGNED, false, true, 8, 0},	/* y = s */
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0}
   },
#else
   {
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 16, 0},	/* x = z */
      {UTIL_FORMAT_TYPE_UNSIGNED, false, true, 8, 16},	/* y = s */
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0}
   },
#endif
#if UTIL_ARCH_BIG_ENDIAN
   {
      PIPE_SWIZZLE_X,	/* z */
      PIPE_SWIZZLE_Y,	/* s */
      PIPE_SWIZZLE_NONE,	/* ignored */
      PIPE_SWIZZLE_NONE	/* ignored */
   },
#else
   {
      PIPE_SWIZZLE_X,	/* z */
      PIPE_SWIZZLE_Y,	/* s */
      PIPE_SWIZZLE_NONE,	/* ignored */
      PIPE_SWIZZLE_NONE	/* ignored */
   },
#endif
      .colorspace = UTIL_FORMAT_COLORSPACE_ZS,
      .srgb_equivalent = PIPE_FORMAT_NONE,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_Z32_UNORM] = {
      .format = PIPE_FORMAT_Z32_UNORM,
      .name = "PIPE_FORMAT_Z32_UNORM",
      .short_name = "z32_unorm",
      .block = {1, 1, 1, 32},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_PLAIN,
      .nr_channels = 1,	/* nr_channels */
      .is_array = true,	/* is_array */
      .is_bitmask = true,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = true,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
   {
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 32, 0},	/* x = z */
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0}
   },
   {
      PIPE_SWIZZLE_X,	/* z */
      PIPE_SWIZZLE_NONE,	/* s */
      PIPE_SWIZZLE_NONE,	/* ignored */
      PIPE_SWIZZLE_NONE	/* ignored */
   },
      .colorspace = UTIL_FORMAT_COLORSPACE_ZS,
      .srgb_equivalent = PIPE_FORMAT_NONE,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_Z32_FLOAT] = {
      .format = PIPE_FORMAT_Z32_FLOAT,
      .name = "PIPE_FORMAT_Z32_FLOAT",
      .short_name = "z32_float",
      .block = {1, 1, 1, 32},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_PLAIN,
      .nr_channels = 1,	/* nr_channels */
      .is_array = true,	/* is_array */
      .is_bitmask = false,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = false,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
   {
      {UTIL_FORMAT_TYPE_FLOAT, false, false, 32, 0},	/* x = z */
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0}
   },
   {
      PIPE_SWIZZLE_X,	/* z */
      PIPE_SWIZZLE_NONE,	/* s */
      PIPE_SWIZZLE_NONE,	/* ignored */
      PIPE_SWIZZLE_NONE	/* ignored */
   },
      .colorspace = UTIL_FORMAT_COLORSPACE_ZS,
      .srgb_equivalent = PIPE_FORMAT_NONE,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_Z24_UNORM_S8_UINT] = {
      .format = PIPE_FORMAT_Z24_UNORM_S8_UINT,
      .name = "PIPE_FORMAT_Z24_UNORM_S8_UINT",
      .short_name = "z24_unorm_s8_uint",
      .block = {1, 1, 1, 32},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_PLAIN,
      .nr_channels = 2,	/* nr_channels */
      .is_array = false,	/* is_array */
      .is_bitmask = true,	/* is_bitmask */
      .is_mixed = true,	/* is_mixed */
      .is_unorm = true,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
#if UTIL_ARCH_BIG_ENDIAN
   {
      {UTIL_FORMAT_TYPE_UNSIGNED, false, true, 8, 24},	/* x = s */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 24, 0},	/* y = z */
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0}
   },
#else
   {
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 24, 0},	/* x = z */
      {UTIL_FORMAT_TYPE_UNSIGNED, false, true, 8, 24},	/* y = s */
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0}
   },
#endif
#if UTIL_ARCH_BIG_ENDIAN
   {
      PIPE_SWIZZLE_Y,	/* z */
      PIPE_SWIZZLE_X,	/* s */
      PIPE_SWIZZLE_NONE,	/* ignored */
      PIPE_SWIZZLE_NONE	/* ignored */
   },
#else
   {
      PIPE_SWIZZLE_X,	/* z */
      PIPE_SWIZZLE_Y,	/* s */
      PIPE_SWIZZLE_NONE,	/* ignored */
      PIPE_SWIZZLE_NONE	/* ignored */
   },
#endif
      .colorspace = UTIL_FORMAT_COLORSPACE_ZS,
      .srgb_equivalent = PIPE_FORMAT_NONE,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_S8_UINT_Z24_UNORM] = {
      .format = PIPE_FORMAT_S8_UINT_Z24_UNORM,
      .name = "PIPE_FORMAT_S8_UINT_Z24_UNORM",
      .short_name = "s8_uint_z24_unorm",
      .block = {1, 1, 1, 32},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_PLAIN,
      .nr_channels = 2,	/* nr_channels */
      .is_array = false,	/* is_array */
      .is_bitmask = true,	/* is_bitmask */
      .is_mixed = true,	/* is_mixed */
      .is_unorm = true,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
#if UTIL_ARCH_BIG_ENDIAN
   {
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 24, 8},	/* x = z */
      {UTIL_FORMAT_TYPE_UNSIGNED, false, true, 8, 0},	/* y = s */
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0}
   },
#else
   {
      {UTIL_FORMAT_TYPE_UNSIGNED, false, true, 8, 0},	/* x = s */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 24, 8},	/* y = z */
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0}
   },
#endif
#if UTIL_ARCH_BIG_ENDIAN
   {
      PIPE_SWIZZLE_X,	/* z */
      PIPE_SWIZZLE_Y,	/* s */
      PIPE_SWIZZLE_NONE,	/* ignored */
      PIPE_SWIZZLE_NONE	/* ignored */
   },
#else
   {
      PIPE_SWIZZLE_Y,	/* z */
      PIPE_SWIZZLE_X,	/* s */
      PIPE_SWIZZLE_NONE,	/* ignored */
      PIPE_SWIZZLE_NONE	/* ignored */
   },
#endif
      .colorspace = UTIL_FORMAT_COLORSPACE_ZS,
      .srgb_equivalent = PIPE_FORMAT_NONE,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_X24S8_UINT] = {
      .format = PIPE_FORMAT_X24S8_UINT,
      .name = "PIPE_FORMAT_X24S8_UINT",
      .short_name = "x24s8_uint",
      .block = {1, 1, 1, 32},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_PLAIN,
      .nr_channels = 2,	/* nr_channels */
      .is_array = false,	/* is_array */
      .is_bitmask = true,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = false,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
#if UTIL_ARCH_BIG_ENDIAN
   {
      {UTIL_FORMAT_TYPE_UNSIGNED, false, true, 8, 24},	/* x = s */
      {UTIL_FORMAT_TYPE_VOID, false, false, 24, 0},	/* y = x */
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0}
   },
#else
   {
      {UTIL_FORMAT_TYPE_VOID, false, false, 24, 0},	/* x = x */
      {UTIL_FORMAT_TYPE_UNSIGNED, false, true, 8, 24},	/* y = s */
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0}
   },
#endif
#if UTIL_ARCH_BIG_ENDIAN
   {
      PIPE_SWIZZLE_NONE,	/* z */
      PIPE_SWIZZLE_X,	/* s */
      PIPE_SWIZZLE_NONE,	/* ignored */
      PIPE_SWIZZLE_NONE	/* ignored */
   },
#else
   {
      PIPE_SWIZZLE_NONE,	/* z */
      PIPE_SWIZZLE_Y,	/* s */
      PIPE_SWIZZLE_NONE,	/* ignored */
      PIPE_SWIZZLE_NONE	/* ignored */
   },
#endif
      .colorspace = UTIL_FORMAT_COLORSPACE_ZS,
      .srgb_equivalent = PIPE_FORMAT_NONE,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_S8X24_UINT] = {
      .format = PIPE_FORMAT_S8X24_UINT,
      .name = "PIPE_FORMAT_S8X24_UINT",
      .short_name = "s8x24_uint",
      .block = {1, 1, 1, 32},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_PLAIN,
      .nr_channels = 2,	/* nr_channels */
      .is_array = false,	/* is_array */
      .is_bitmask = true,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = false,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
#if UTIL_ARCH_BIG_ENDIAN
   {
      {UTIL_FORMAT_TYPE_VOID, false, false, 24, 8},	/* x = x */
      {UTIL_FORMAT_TYPE_UNSIGNED, false, true, 8, 0},	/* y = s */
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0}
   },
#else
   {
      {UTIL_FORMAT_TYPE_UNSIGNED, false, true, 8, 0},	/* x = s */
      {UTIL_FORMAT_TYPE_VOID, false, false, 24, 8},	/* y = x */
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0}
   },
#endif
#if UTIL_ARCH_BIG_ENDIAN
   {
      PIPE_SWIZZLE_NONE,	/* z */
      PIPE_SWIZZLE_Y,	/* s */
      PIPE_SWIZZLE_NONE,	/* ignored */
      PIPE_SWIZZLE_NONE	/* ignored */
   },
#else
   {
      PIPE_SWIZZLE_NONE,	/* z */
      PIPE_SWIZZLE_X,	/* s */
      PIPE_SWIZZLE_NONE,	/* ignored */
      PIPE_SWIZZLE_NONE	/* ignored */
   },
#endif
      .colorspace = UTIL_FORMAT_COLORSPACE_ZS,
      .srgb_equivalent = PIPE_FORMAT_NONE,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_Z24X8_UNORM] = {
      .format = PIPE_FORMAT_Z24X8_UNORM,
      .name = "PIPE_FORMAT_Z24X8_UNORM",
      .short_name = "z24x8_unorm",
      .block = {1, 1, 1, 32},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_PLAIN,
      .nr_channels = 2,	/* nr_channels */
      .is_array = false,	/* is_array */
      .is_bitmask = true,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = true,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
#if UTIL_ARCH_BIG_ENDIAN
   {
      {UTIL_FORMAT_TYPE_VOID, false, false, 8, 24},	/* x = x */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 24, 0},	/* y = z */
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0}
   },
#else
   {
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 24, 0},	/* x = z */
      {UTIL_FORMAT_TYPE_VOID, false, false, 8, 24},	/* y = x */
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0}
   },
#endif
#if UTIL_ARCH_BIG_ENDIAN
   {
      PIPE_SWIZZLE_Y,	/* z */
      PIPE_SWIZZLE_NONE,	/* s */
      PIPE_SWIZZLE_NONE,	/* ignored */
      PIPE_SWIZZLE_NONE	/* ignored */
   },
#else
   {
      PIPE_SWIZZLE_X,	/* z */
      PIPE_SWIZZLE_NONE,	/* s */
      PIPE_SWIZZLE_NONE,	/* ignored */
      PIPE_SWIZZLE_NONE	/* ignored */
   },
#endif
      .colorspace = UTIL_FORMAT_COLORSPACE_ZS,
      .srgb_equivalent = PIPE_FORMAT_NONE,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_X8Z24_UNORM] = {
      .format = PIPE_FORMAT_X8Z24_UNORM,
      .name = "PIPE_FORMAT_X8Z24_UNORM",
      .short_name = "x8z24_unorm",
      .block = {1, 1, 1, 32},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_PLAIN,
      .nr_channels = 2,	/* nr_channels */
      .is_array = false,	/* is_array */
      .is_bitmask = true,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = true,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
#if UTIL_ARCH_BIG_ENDIAN
   {
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 24, 8},	/* x = z */
      {UTIL_FORMAT_TYPE_VOID, false, false, 8, 0},	/* y = x */
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0}
   },
#else
   {
      {UTIL_FORMAT_TYPE_VOID, false, false, 8, 0},	/* x = x */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 24, 8},	/* y = z */
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0}
   },
#endif
#if UTIL_ARCH_BIG_ENDIAN
   {
      PIPE_SWIZZLE_X,	/* z */
      PIPE_SWIZZLE_NONE,	/* s */
      PIPE_SWIZZLE_NONE,	/* ignored */
      PIPE_SWIZZLE_NONE	/* ignored */
   },
#else
   {
      PIPE_SWIZZLE_Y,	/* z */
      PIPE_SWIZZLE_NONE,	/* s */
      PIPE_SWIZZLE_NONE,	/* ignored */
      PIPE_SWIZZLE_NONE	/* ignored */
   },
#endif
      .colorspace = UTIL_FORMAT_COLORSPACE_ZS,
      .srgb_equivalent = PIPE_FORMAT_NONE,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_Z32_FLOAT_S8X24_UINT] = {
      .format = PIPE_FORMAT_Z32_FLOAT_S8X24_UINT,
      .name = "PIPE_FORMAT_Z32_FLOAT_S8X24_UINT",
      .short_name = "z32_float_s8x24_uint",
      .block = {1, 1, 1, 64},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_PLAIN,
      .nr_channels = 3,	/* nr_channels */
      .is_array = false,	/* is_array */
      .is_bitmask = false,	/* is_bitmask */
      .is_mixed = true,	/* is_mixed */
      .is_unorm = false,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
#if UTIL_ARCH_BIG_ENDIAN
   {
      {UTIL_FORMAT_TYPE_FLOAT, false, false, 32, 32},	/* x = z */
      {UTIL_FORMAT_TYPE_VOID, false, false, 24, 8},	/* y = x */
      {UTIL_FORMAT_TYPE_UNSIGNED, false, true, 8, 0},	/* z = s */
      {0, 0, 0, 0, 0}
   },
#else
   {
      {UTIL_FORMAT_TYPE_FLOAT, false, false, 32, 0},	/* x = z */
      {UTIL_FORMAT_TYPE_UNSIGNED, false, true, 8, 32},	/* y = s */
      {UTIL_FORMAT_TYPE_VOID, false, false, 24, 40},	/* z = x */
      {0, 0, 0, 0, 0}
   },
#endif
#if UTIL_ARCH_BIG_ENDIAN
   {
      PIPE_SWIZZLE_X,	/* z */
      PIPE_SWIZZLE_Z,	/* s */
      PIPE_SWIZZLE_NONE,	/* ignored */
      PIPE_SWIZZLE_NONE	/* ignored */
   },
#else
   {
      PIPE_SWIZZLE_X,	/* z */
      PIPE_SWIZZLE_Y,	/* s */
      PIPE_SWIZZLE_NONE,	/* ignored */
      PIPE_SWIZZLE_NONE	/* ignored */
   },
#endif
      .colorspace = UTIL_FORMAT_COLORSPACE_ZS,
      .srgb_equivalent = PIPE_FORMAT_NONE,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_X32_S8X24_UINT] = {
      .format = PIPE_FORMAT_X32_S8X24_UINT,
      .name = "PIPE_FORMAT_X32_S8X24_UINT",
      .short_name = "x32_s8x24_uint",
      .block = {1, 1, 1, 64},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_PLAIN,
      .nr_channels = 3,	/* nr_channels */
      .is_array = false,	/* is_array */
      .is_bitmask = false,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = false,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
#if UTIL_ARCH_BIG_ENDIAN
   {
      {UTIL_FORMAT_TYPE_VOID, false, false, 32, 32},	/* x = x */
      {UTIL_FORMAT_TYPE_VOID, false, false, 24, 8},	/* y = x */
      {UTIL_FORMAT_TYPE_UNSIGNED, false, true, 8, 0},	/* z = s */
      {0, 0, 0, 0, 0}
   },
#else
   {
      {UTIL_FORMAT_TYPE_VOID, false, false, 32, 0},	/* x = x */
      {UTIL_FORMAT_TYPE_UNSIGNED, false, true, 8, 32},	/* y = s */
      {UTIL_FORMAT_TYPE_VOID, false, false, 24, 40},	/* z = x */
      {0, 0, 0, 0, 0}
   },
#endif
#if UTIL_ARCH_BIG_ENDIAN
   {
      PIPE_SWIZZLE_NONE,	/* z */
      PIPE_SWIZZLE_Z,	/* s */
      PIPE_SWIZZLE_NONE,	/* ignored */
      PIPE_SWIZZLE_NONE	/* ignored */
   },
#else
   {
      PIPE_SWIZZLE_NONE,	/* z */
      PIPE_SWIZZLE_Y,	/* s */
      PIPE_SWIZZLE_NONE,	/* ignored */
      PIPE_SWIZZLE_NONE	/* ignored */
   },
#endif
      .colorspace = UTIL_FORMAT_COLORSPACE_ZS,
      .srgb_equivalent = PIPE_FORMAT_NONE,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_Z24_UNORM_S8_UINT_AS_R8G8B8A8] = {
      .format = PIPE_FORMAT_Z24_UNORM_S8_UINT_AS_R8G8B8A8,
      .name = "PIPE_FORMAT_Z24_UNORM_S8_UINT_AS_R8G8B8A8",
      .short_name = "z24_unorm_s8_uint_as_r8g8b8a8",
      .block = {1, 1, 1, 32},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_PLAIN,
      .nr_channels = 4,	/* nr_channels */
      .is_array = true,	/* is_array */
      .is_bitmask = true,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = true,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
#if UTIL_ARCH_BIG_ENDIAN
   {
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 8, 24},	/* x = r */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 8, 16},	/* y = g */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 8, 8},	/* z = b */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 8, 0}	/* w = a */
   },
#else
   {
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 8, 0},	/* x = r */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 8, 8},	/* y = g */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 8, 16},	/* z = b */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 8, 24}	/* w = a */
   },
#endif
#if UTIL_ARCH_BIG_ENDIAN
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_Y,	/* g */
      PIPE_SWIZZLE_Z,	/* b */
      PIPE_SWIZZLE_W	/* a */
   },
#else
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_Y,	/* g */
      PIPE_SWIZZLE_Z,	/* b */
      PIPE_SWIZZLE_W	/* a */
   },
#endif
      .colorspace = UTIL_FORMAT_COLORSPACE_RGB,
      .srgb_equivalent = PIPE_FORMAT_NONE,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_U8Y8V8Y8_422_UNORM] = {
      .format = PIPE_FORMAT_U8Y8V8Y8_422_UNORM,
      .name = "PIPE_FORMAT_U8Y8V8Y8_422_UNORM",
      .short_name = "u8y8v8y8_422_unorm",
      .block = {2, 1, 1, 32},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_SUBSAMPLED,
      .nr_channels = 4,	/* nr_channels */
      .is_array = false,	/* is_array */
      .is_bitmask = false,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = true,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
#if UTIL_ARCH_BIG_ENDIAN
   {
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 8, 24},	/* x = x */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 8, 16},	/* y = y */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 8, 8},	/* z = z */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 8, 0}	/* w = w */
   },
#else
   {
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 8, 0},	/* x = x */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 8, 8},	/* y = y */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 8, 16},	/* z = z */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 8, 24}	/* w = w */
   },
#endif
#if UTIL_ARCH_BIG_ENDIAN
   {
      PIPE_SWIZZLE_X,	/* y */
      PIPE_SWIZZLE_Y,	/* u */
      PIPE_SWIZZLE_Z,	/* v */
      PIPE_SWIZZLE_1	/* ignored */
   },
#else
   {
      PIPE_SWIZZLE_X,	/* y */
      PIPE_SWIZZLE_Y,	/* u */
      PIPE_SWIZZLE_Z,	/* v */
      PIPE_SWIZZLE_1	/* ignored */
   },
#endif
      .colorspace = UTIL_FORMAT_COLORSPACE_YUV,
      .srgb_equivalent = PIPE_FORMAT_NONE,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_V8Y8U8Y8_422_UNORM] = {
      .format = PIPE_FORMAT_V8Y8U8Y8_422_UNORM,
      .name = "PIPE_FORMAT_V8Y8U8Y8_422_UNORM",
      .short_name = "v8y8u8y8_422_unorm",
      .block = {2, 1, 1, 32},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_SUBSAMPLED,
      .nr_channels = 4,	/* nr_channels */
      .is_array = false,	/* is_array */
      .is_bitmask = false,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = true,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
#if UTIL_ARCH_BIG_ENDIAN
   {
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 8, 24},	/* x = x */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 8, 16},	/* y = y */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 8, 8},	/* z = z */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 8, 0}	/* w = w */
   },
#else
   {
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 8, 0},	/* x = x */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 8, 8},	/* y = y */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 8, 16},	/* z = z */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 8, 24}	/* w = w */
   },
#endif
#if UTIL_ARCH_BIG_ENDIAN
   {
      PIPE_SWIZZLE_X,	/* y */
      PIPE_SWIZZLE_Y,	/* u */
      PIPE_SWIZZLE_Z,	/* v */
      PIPE_SWIZZLE_1	/* ignored */
   },
#else
   {
      PIPE_SWIZZLE_X,	/* y */
      PIPE_SWIZZLE_Y,	/* u */
      PIPE_SWIZZLE_Z,	/* v */
      PIPE_SWIZZLE_1	/* ignored */
   },
#endif
      .colorspace = UTIL_FORMAT_COLORSPACE_YUV,
      .srgb_equivalent = PIPE_FORMAT_NONE,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_Y8U8Y8V8_422_UNORM] = {
      .format = PIPE_FORMAT_Y8U8Y8V8_422_UNORM,
      .name = "PIPE_FORMAT_Y8U8Y8V8_422_UNORM",
      .short_name = "y8u8y8v8_422_unorm",
      .block = {2, 1, 1, 32},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_SUBSAMPLED,
      .nr_channels = 4,	/* nr_channels */
      .is_array = false,	/* is_array */
      .is_bitmask = false,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = true,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
#if UTIL_ARCH_BIG_ENDIAN
   {
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 8, 24},	/* x = x */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 8, 16},	/* y = y */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 8, 8},	/* z = z */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 8, 0}	/* w = w */
   },
#else
   {
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 8, 0},	/* x = x */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 8, 8},	/* y = y */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 8, 16},	/* z = z */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 8, 24}	/* w = w */
   },
#endif
#if UTIL_ARCH_BIG_ENDIAN
   {
      PIPE_SWIZZLE_X,	/* y */
      PIPE_SWIZZLE_Y,	/* u */
      PIPE_SWIZZLE_Z,	/* v */
      PIPE_SWIZZLE_1	/* ignored */
   },
#else
   {
      PIPE_SWIZZLE_X,	/* y */
      PIPE_SWIZZLE_Y,	/* u */
      PIPE_SWIZZLE_Z,	/* v */
      PIPE_SWIZZLE_1	/* ignored */
   },
#endif
      .colorspace = UTIL_FORMAT_COLORSPACE_YUV,
      .srgb_equivalent = PIPE_FORMAT_NONE,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_Y8V8Y8U8_422_UNORM] = {
      .format = PIPE_FORMAT_Y8V8Y8U8_422_UNORM,
      .name = "PIPE_FORMAT_Y8V8Y8U8_422_UNORM",
      .short_name = "y8v8y8u8_422_unorm",
      .block = {2, 1, 1, 32},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_SUBSAMPLED,
      .nr_channels = 4,	/* nr_channels */
      .is_array = false,	/* is_array */
      .is_bitmask = false,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = true,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
#if UTIL_ARCH_BIG_ENDIAN
   {
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 8, 24},	/* x = x */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 8, 16},	/* y = y */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 8, 8},	/* z = z */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 8, 0}	/* w = w */
   },
#else
   {
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 8, 0},	/* x = x */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 8, 8},	/* y = y */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 8, 16},	/* z = z */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 8, 24}	/* w = w */
   },
#endif
#if UTIL_ARCH_BIG_ENDIAN
   {
      PIPE_SWIZZLE_X,	/* y */
      PIPE_SWIZZLE_Y,	/* u */
      PIPE_SWIZZLE_Z,	/* v */
      PIPE_SWIZZLE_1	/* ignored */
   },
#else
   {
      PIPE_SWIZZLE_X,	/* y */
      PIPE_SWIZZLE_Y,	/* u */
      PIPE_SWIZZLE_Z,	/* v */
      PIPE_SWIZZLE_1	/* ignored */
   },
#endif
      .colorspace = UTIL_FORMAT_COLORSPACE_YUV,
      .srgb_equivalent = PIPE_FORMAT_NONE,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_A8Y8U8V8_444_UNORM] = {
      .format = PIPE_FORMAT_A8Y8U8V8_444_UNORM,
      .name = "PIPE_FORMAT_A8Y8U8V8_444_UNORM",
      .short_name = "a8y8u8v8_444_unorm",
      .block = {4, 4, 1, 8},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_OTHER,
      .nr_channels = 1,	/* nr_channels */
      .is_array = false,	/* is_array */
      .is_bitmask = false,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = true,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
   {
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 8, 0},	/* x = x */
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0}
   },
   {
      PIPE_SWIZZLE_X,	/* y */
      PIPE_SWIZZLE_Y,	/* u */
      PIPE_SWIZZLE_Z,	/* v */
      PIPE_SWIZZLE_W	/* ignored */
   },
      .colorspace = UTIL_FORMAT_COLORSPACE_YUV,
      .srgb_equivalent = PIPE_FORMAT_NONE,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_X8Y8U8V8_444_UNORM] = {
      .format = PIPE_FORMAT_X8Y8U8V8_444_UNORM,
      .name = "PIPE_FORMAT_X8Y8U8V8_444_UNORM",
      .short_name = "x8y8u8v8_444_unorm",
      .block = {4, 4, 1, 8},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_OTHER,
      .nr_channels = 1,	/* nr_channels */
      .is_array = false,	/* is_array */
      .is_bitmask = false,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = true,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
   {
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 8, 0},	/* x = x */
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0}
   },
   {
      PIPE_SWIZZLE_X,	/* y */
      PIPE_SWIZZLE_Y,	/* u */
      PIPE_SWIZZLE_Z,	/* v */
      PIPE_SWIZZLE_1	/* ignored */
   },
      .colorspace = UTIL_FORMAT_COLORSPACE_YUV,
      .srgb_equivalent = PIPE_FORMAT_NONE,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_R8G8_B8G8_422_UNORM] = {
      .format = PIPE_FORMAT_R8G8_B8G8_422_UNORM,
      .name = "PIPE_FORMAT_R8G8_B8G8_422_UNORM",
      .short_name = "r8g8_b8g8_422_unorm",
      .block = {2, 1, 1, 32},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_SUBSAMPLED,
      .nr_channels = 4,	/* nr_channels */
      .is_array = false,	/* is_array */
      .is_bitmask = false,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = true,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
#if UTIL_ARCH_BIG_ENDIAN
   {
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 8, 24},	/* x = x */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 8, 16},	/* y = y */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 8, 8},	/* z = z */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 8, 0}	/* w = w */
   },
#else
   {
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 8, 0},	/* x = x */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 8, 8},	/* y = y */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 8, 16},	/* z = z */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 8, 24}	/* w = w */
   },
#endif
#if UTIL_ARCH_BIG_ENDIAN
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_Y,	/* g */
      PIPE_SWIZZLE_Z,	/* b */
      PIPE_SWIZZLE_1	/* a */
   },
#else
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_Y,	/* g */
      PIPE_SWIZZLE_Z,	/* b */
      PIPE_SWIZZLE_1	/* a */
   },
#endif
      .colorspace = UTIL_FORMAT_COLORSPACE_RGB,
      .srgb_equivalent = PIPE_FORMAT_NONE,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_G8R8_G8B8_422_UNORM] = {
      .format = PIPE_FORMAT_G8R8_G8B8_422_UNORM,
      .name = "PIPE_FORMAT_G8R8_G8B8_422_UNORM",
      .short_name = "g8r8_g8b8_422_unorm",
      .block = {2, 1, 1, 32},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_SUBSAMPLED,
      .nr_channels = 4,	/* nr_channels */
      .is_array = false,	/* is_array */
      .is_bitmask = false,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = true,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
#if UTIL_ARCH_BIG_ENDIAN
   {
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 8, 24},	/* x = x */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 8, 16},	/* y = y */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 8, 8},	/* z = z */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 8, 0}	/* w = w */
   },
#else
   {
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 8, 0},	/* x = x */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 8, 8},	/* y = y */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 8, 16},	/* z = z */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 8, 24}	/* w = w */
   },
#endif
#if UTIL_ARCH_BIG_ENDIAN
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_Y,	/* g */
      PIPE_SWIZZLE_Z,	/* b */
      PIPE_SWIZZLE_1	/* a */
   },
#else
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_Y,	/* g */
      PIPE_SWIZZLE_Z,	/* b */
      PIPE_SWIZZLE_1	/* a */
   },
#endif
      .colorspace = UTIL_FORMAT_COLORSPACE_RGB,
      .srgb_equivalent = PIPE_FORMAT_NONE,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_G8R8_B8R8_422_UNORM] = {
      .format = PIPE_FORMAT_G8R8_B8R8_422_UNORM,
      .name = "PIPE_FORMAT_G8R8_B8R8_422_UNORM",
      .short_name = "g8r8_b8r8_422_unorm",
      .block = {2, 1, 1, 32},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_SUBSAMPLED,
      .nr_channels = 4,	/* nr_channels */
      .is_array = false,	/* is_array */
      .is_bitmask = false,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = true,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
#if UTIL_ARCH_BIG_ENDIAN
   {
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 8, 24},	/* x = x */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 8, 16},	/* y = y */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 8, 8},	/* z = z */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 8, 0}	/* w = w */
   },
#else
   {
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 8, 0},	/* x = x */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 8, 8},	/* y = y */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 8, 16},	/* z = z */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 8, 24}	/* w = w */
   },
#endif
#if UTIL_ARCH_BIG_ENDIAN
   {
      PIPE_SWIZZLE_Z,	/* r */
      PIPE_SWIZZLE_Y,	/* g */
      PIPE_SWIZZLE_X,	/* b */
      PIPE_SWIZZLE_1	/* a */
   },
#else
   {
      PIPE_SWIZZLE_Z,	/* r */
      PIPE_SWIZZLE_Y,	/* g */
      PIPE_SWIZZLE_X,	/* b */
      PIPE_SWIZZLE_1	/* a */
   },
#endif
      .colorspace = UTIL_FORMAT_COLORSPACE_RGB,
      .srgb_equivalent = PIPE_FORMAT_NONE,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_R8G8_R8B8_422_UNORM] = {
      .format = PIPE_FORMAT_R8G8_R8B8_422_UNORM,
      .name = "PIPE_FORMAT_R8G8_R8B8_422_UNORM",
      .short_name = "r8g8_r8b8_422_unorm",
      .block = {2, 1, 1, 32},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_SUBSAMPLED,
      .nr_channels = 4,	/* nr_channels */
      .is_array = false,	/* is_array */
      .is_bitmask = false,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = true,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
#if UTIL_ARCH_BIG_ENDIAN
   {
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 8, 24},	/* x = x */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 8, 16},	/* y = y */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 8, 8},	/* z = z */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 8, 0}	/* w = w */
   },
#else
   {
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 8, 0},	/* x = x */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 8, 8},	/* y = y */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 8, 16},	/* z = z */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 8, 24}	/* w = w */
   },
#endif
#if UTIL_ARCH_BIG_ENDIAN
   {
      PIPE_SWIZZLE_Z,	/* r */
      PIPE_SWIZZLE_Y,	/* g */
      PIPE_SWIZZLE_X,	/* b */
      PIPE_SWIZZLE_1	/* a */
   },
#else
   {
      PIPE_SWIZZLE_Z,	/* r */
      PIPE_SWIZZLE_Y,	/* g */
      PIPE_SWIZZLE_X,	/* b */
      PIPE_SWIZZLE_1	/* a */
   },
#endif
      .colorspace = UTIL_FORMAT_COLORSPACE_RGB,
      .srgb_equivalent = PIPE_FORMAT_NONE,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_B8R8_G8R8_422_UNORM] = {
      .format = PIPE_FORMAT_B8R8_G8R8_422_UNORM,
      .name = "PIPE_FORMAT_B8R8_G8R8_422_UNORM",
      .short_name = "b8r8_g8r8_422_unorm",
      .block = {2, 1, 1, 32},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_SUBSAMPLED,
      .nr_channels = 4,	/* nr_channels */
      .is_array = false,	/* is_array */
      .is_bitmask = false,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = true,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
#if UTIL_ARCH_BIG_ENDIAN
   {
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 8, 24},	/* x = x */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 8, 16},	/* y = y */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 8, 8},	/* z = z */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 8, 0}	/* w = w */
   },
#else
   {
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 8, 0},	/* x = x */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 8, 8},	/* y = y */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 8, 16},	/* z = z */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 8, 24}	/* w = w */
   },
#endif
#if UTIL_ARCH_BIG_ENDIAN
   {
      PIPE_SWIZZLE_Y,	/* r */
      PIPE_SWIZZLE_X,	/* g */
      PIPE_SWIZZLE_Z,	/* b */
      PIPE_SWIZZLE_1	/* a */
   },
#else
   {
      PIPE_SWIZZLE_Y,	/* r */
      PIPE_SWIZZLE_X,	/* g */
      PIPE_SWIZZLE_Z,	/* b */
      PIPE_SWIZZLE_1	/* a */
   },
#endif
      .colorspace = UTIL_FORMAT_COLORSPACE_RGB,
      .srgb_equivalent = PIPE_FORMAT_NONE,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_R8B8_R8G8_422_UNORM] = {
      .format = PIPE_FORMAT_R8B8_R8G8_422_UNORM,
      .name = "PIPE_FORMAT_R8B8_R8G8_422_UNORM",
      .short_name = "r8b8_r8g8_422_unorm",
      .block = {2, 1, 1, 32},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_SUBSAMPLED,
      .nr_channels = 4,	/* nr_channels */
      .is_array = false,	/* is_array */
      .is_bitmask = false,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = true,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
#if UTIL_ARCH_BIG_ENDIAN
   {
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 8, 24},	/* x = x */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 8, 16},	/* y = y */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 8, 8},	/* z = z */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 8, 0}	/* w = w */
   },
#else
   {
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 8, 0},	/* x = x */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 8, 8},	/* y = y */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 8, 16},	/* z = z */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 8, 24}	/* w = w */
   },
#endif
#if UTIL_ARCH_BIG_ENDIAN
   {
      PIPE_SWIZZLE_Y,	/* r */
      PIPE_SWIZZLE_X,	/* g */
      PIPE_SWIZZLE_Z,	/* b */
      PIPE_SWIZZLE_1	/* a */
   },
#else
   {
      PIPE_SWIZZLE_Y,	/* r */
      PIPE_SWIZZLE_X,	/* g */
      PIPE_SWIZZLE_Z,	/* b */
      PIPE_SWIZZLE_1	/* a */
   },
#endif
      .colorspace = UTIL_FORMAT_COLORSPACE_RGB,
      .srgb_equivalent = PIPE_FORMAT_NONE,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_G8B8_G8R8_422_UNORM] = {
      .format = PIPE_FORMAT_G8B8_G8R8_422_UNORM,
      .name = "PIPE_FORMAT_G8B8_G8R8_422_UNORM",
      .short_name = "g8b8_g8r8_422_unorm",
      .block = {2, 1, 1, 32},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_SUBSAMPLED,
      .nr_channels = 4,	/* nr_channels */
      .is_array = false,	/* is_array */
      .is_bitmask = false,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = true,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
#if UTIL_ARCH_BIG_ENDIAN
   {
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 8, 24},	/* x = x */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 8, 16},	/* y = y */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 8, 8},	/* z = z */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 8, 0}	/* w = w */
   },
#else
   {
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 8, 0},	/* x = x */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 8, 8},	/* y = y */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 8, 16},	/* z = z */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 8, 24}	/* w = w */
   },
#endif
#if UTIL_ARCH_BIG_ENDIAN
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_Y,	/* g */
      PIPE_SWIZZLE_Z,	/* b */
      PIPE_SWIZZLE_1	/* a */
   },
#else
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_Y,	/* g */
      PIPE_SWIZZLE_Z,	/* b */
      PIPE_SWIZZLE_1	/* a */
   },
#endif
      .colorspace = UTIL_FORMAT_COLORSPACE_RGB,
      .srgb_equivalent = PIPE_FORMAT_NONE,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_B8G8_R8G8_422_UNORM] = {
      .format = PIPE_FORMAT_B8G8_R8G8_422_UNORM,
      .name = "PIPE_FORMAT_B8G8_R8G8_422_UNORM",
      .short_name = "b8g8_r8g8_422_unorm",
      .block = {2, 1, 1, 32},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_SUBSAMPLED,
      .nr_channels = 4,	/* nr_channels */
      .is_array = false,	/* is_array */
      .is_bitmask = false,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = true,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
#if UTIL_ARCH_BIG_ENDIAN
   {
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 8, 24},	/* x = x */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 8, 16},	/* y = y */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 8, 8},	/* z = z */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 8, 0}	/* w = w */
   },
#else
   {
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 8, 0},	/* x = x */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 8, 8},	/* y = y */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 8, 16},	/* z = z */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 8, 24}	/* w = w */
   },
#endif
#if UTIL_ARCH_BIG_ENDIAN
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_Y,	/* g */
      PIPE_SWIZZLE_Z,	/* b */
      PIPE_SWIZZLE_1	/* a */
   },
#else
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_Y,	/* g */
      PIPE_SWIZZLE_Z,	/* b */
      PIPE_SWIZZLE_1	/* a */
   },
#endif
      .colorspace = UTIL_FORMAT_COLORSPACE_RGB,
      .srgb_equivalent = PIPE_FORMAT_NONE,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_R11G11B10_FLOAT] = {
      .format = PIPE_FORMAT_R11G11B10_FLOAT,
      .name = "PIPE_FORMAT_R11G11B10_FLOAT",
      .short_name = "r11g11b10_float",
      .block = {1, 1, 1, 32},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_OTHER,
      .nr_channels = 3,	/* nr_channels */
      .is_array = false,	/* is_array */
      .is_bitmask = false,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = false,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
#if UTIL_ARCH_BIG_ENDIAN
   {
      {UTIL_FORMAT_TYPE_FLOAT, false, false, 11, 21},	/* x = x */
      {UTIL_FORMAT_TYPE_FLOAT, false, false, 11, 10},	/* y = y */
      {UTIL_FORMAT_TYPE_FLOAT, false, false, 10, 0},	/* z = z */
      {0, 0, 0, 0, 0}
   },
#else
   {
      {UTIL_FORMAT_TYPE_FLOAT, false, false, 11, 0},	/* x = x */
      {UTIL_FORMAT_TYPE_FLOAT, false, false, 11, 11},	/* y = y */
      {UTIL_FORMAT_TYPE_FLOAT, false, false, 10, 22},	/* z = z */
      {0, 0, 0, 0, 0}
   },
#endif
#if UTIL_ARCH_BIG_ENDIAN
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_Y,	/* g */
      PIPE_SWIZZLE_Z,	/* b */
      PIPE_SWIZZLE_1	/* a */
   },
#else
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_Y,	/* g */
      PIPE_SWIZZLE_Z,	/* b */
      PIPE_SWIZZLE_1	/* a */
   },
#endif
      .colorspace = UTIL_FORMAT_COLORSPACE_RGB,
      .srgb_equivalent = PIPE_FORMAT_NONE,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_R9G9B9E5_FLOAT] = {
      .format = PIPE_FORMAT_R9G9B9E5_FLOAT,
      .name = "PIPE_FORMAT_R9G9B9E5_FLOAT",
      .short_name = "r9g9b9e5_float",
      .block = {1, 1, 1, 32},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_OTHER,
      .nr_channels = 4,	/* nr_channels */
      .is_array = false,	/* is_array */
      .is_bitmask = false,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = false,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
#if UTIL_ARCH_BIG_ENDIAN
   {
      {UTIL_FORMAT_TYPE_FLOAT, false, false, 9, 23},	/* x = x */
      {UTIL_FORMAT_TYPE_FLOAT, false, false, 9, 14},	/* y = y */
      {UTIL_FORMAT_TYPE_FLOAT, false, false, 9, 5},	/* z = z */
      {UTIL_FORMAT_TYPE_VOID, false, false, 5, 0}	/* w = w */
   },
#else
   {
      {UTIL_FORMAT_TYPE_FLOAT, false, false, 9, 0},	/* x = x */
      {UTIL_FORMAT_TYPE_FLOAT, false, false, 9, 9},	/* y = y */
      {UTIL_FORMAT_TYPE_FLOAT, false, false, 9, 18},	/* z = z */
      {UTIL_FORMAT_TYPE_VOID, false, false, 5, 27}	/* w = w */
   },
#endif
#if UTIL_ARCH_BIG_ENDIAN
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_Y,	/* g */
      PIPE_SWIZZLE_Z,	/* b */
      PIPE_SWIZZLE_1	/* a */
   },
#else
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_Y,	/* g */
      PIPE_SWIZZLE_Z,	/* b */
      PIPE_SWIZZLE_1	/* a */
   },
#endif
      .colorspace = UTIL_FORMAT_COLORSPACE_RGB,
      .srgb_equivalent = PIPE_FORMAT_NONE,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_R1_UNORM] = {
      .format = PIPE_FORMAT_R1_UNORM,
      .name = "PIPE_FORMAT_R1_UNORM",
      .short_name = "r1_unorm",
      .block = {8, 1, 1, 8},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_OTHER,
      .nr_channels = 1,	/* nr_channels */
      .is_array = false,	/* is_array */
      .is_bitmask = false,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = true,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
   {
      {UTIL_FORMAT_TYPE_VOID, false, false, 8, 0},	/* x = x */
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0}
   },
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_0,	/* g */
      PIPE_SWIZZLE_0,	/* b */
      PIPE_SWIZZLE_1	/* a */
   },
      .colorspace = UTIL_FORMAT_COLORSPACE_RGB,
      .srgb_equivalent = PIPE_FORMAT_NONE,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_R8G8Bx_SNORM] = {
      .format = PIPE_FORMAT_R8G8Bx_SNORM,
      .name = "PIPE_FORMAT_R8G8Bx_SNORM",
      .short_name = "r8g8bx_snorm",
      .block = {1, 1, 1, 16},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_OTHER,
      .nr_channels = 2,	/* nr_channels */
      .is_array = false,	/* is_array */
      .is_bitmask = false,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = false,	/* is_unorm */
      .is_snorm = true,	/* is_snorm */
#if UTIL_ARCH_BIG_ENDIAN
   {
      {UTIL_FORMAT_TYPE_SIGNED, true, false, 8, 8},	/* x = x */
      {UTIL_FORMAT_TYPE_SIGNED, true, false, 8, 0},	/* y = y */
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0}
   },
#else
   {
      {UTIL_FORMAT_TYPE_SIGNED, true, false, 8, 0},	/* x = x */
      {UTIL_FORMAT_TYPE_SIGNED, true, false, 8, 8},	/* y = y */
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0}
   },
#endif
#if UTIL_ARCH_BIG_ENDIAN
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_Y,	/* g */
      PIPE_SWIZZLE_Z,	/* b */
      PIPE_SWIZZLE_1	/* a */
   },
#else
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_Y,	/* g */
      PIPE_SWIZZLE_Z,	/* b */
      PIPE_SWIZZLE_1	/* a */
   },
#endif
      .colorspace = UTIL_FORMAT_COLORSPACE_RGB,
      .srgb_equivalent = PIPE_FORMAT_NONE,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_DXT1_RGB] = {
      .format = PIPE_FORMAT_DXT1_RGB,
      .name = "PIPE_FORMAT_DXT1_RGB",
      .short_name = "dxt1_rgb",
      .block = {4, 4, 1, 64},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_S3TC,
      .nr_channels = 1,	/* nr_channels */
      .is_array = false,	/* is_array */
      .is_bitmask = false,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = true,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
   {
      {UTIL_FORMAT_TYPE_VOID, false, false, 64, 0},	/* x = x */
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0}
   },
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_Y,	/* g */
      PIPE_SWIZZLE_Z,	/* b */
      PIPE_SWIZZLE_1	/* a */
   },
      .colorspace = UTIL_FORMAT_COLORSPACE_RGB,
      .srgb_equivalent = PIPE_FORMAT_DXT1_SRGB,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_DXT1_RGBA] = {
      .format = PIPE_FORMAT_DXT1_RGBA,
      .name = "PIPE_FORMAT_DXT1_RGBA",
      .short_name = "dxt1_rgba",
      .block = {4, 4, 1, 64},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_S3TC,
      .nr_channels = 1,	/* nr_channels */
      .is_array = false,	/* is_array */
      .is_bitmask = false,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = true,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
   {
      {UTIL_FORMAT_TYPE_VOID, false, false, 64, 0},	/* x = x */
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0}
   },
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_Y,	/* g */
      PIPE_SWIZZLE_Z,	/* b */
      PIPE_SWIZZLE_W	/* a */
   },
      .colorspace = UTIL_FORMAT_COLORSPACE_RGB,
      .srgb_equivalent = PIPE_FORMAT_DXT1_SRGBA,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_DXT3_RGBA] = {
      .format = PIPE_FORMAT_DXT3_RGBA,
      .name = "PIPE_FORMAT_DXT3_RGBA",
      .short_name = "dxt3_rgba",
      .block = {4, 4, 1, 128},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_S3TC,
      .nr_channels = 1,	/* nr_channels */
      .is_array = false,	/* is_array */
      .is_bitmask = false,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = true,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
   {
      {UTIL_FORMAT_TYPE_VOID, false, false, 128, 0},	/* x = x */
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0}
   },
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_Y,	/* g */
      PIPE_SWIZZLE_Z,	/* b */
      PIPE_SWIZZLE_W	/* a */
   },
      .colorspace = UTIL_FORMAT_COLORSPACE_RGB,
      .srgb_equivalent = PIPE_FORMAT_DXT3_SRGBA,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_DXT5_RGBA] = {
      .format = PIPE_FORMAT_DXT5_RGBA,
      .name = "PIPE_FORMAT_DXT5_RGBA",
      .short_name = "dxt5_rgba",
      .block = {4, 4, 1, 128},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_S3TC,
      .nr_channels = 1,	/* nr_channels */
      .is_array = false,	/* is_array */
      .is_bitmask = false,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = true,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
   {
      {UTIL_FORMAT_TYPE_VOID, false, false, 128, 0},	/* x = x */
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0}
   },
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_Y,	/* g */
      PIPE_SWIZZLE_Z,	/* b */
      PIPE_SWIZZLE_W	/* a */
   },
      .colorspace = UTIL_FORMAT_COLORSPACE_RGB,
      .srgb_equivalent = PIPE_FORMAT_DXT5_SRGBA,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_DXT1_SRGB] = {
      .format = PIPE_FORMAT_DXT1_SRGB,
      .name = "PIPE_FORMAT_DXT1_SRGB",
      .short_name = "dxt1_srgb",
      .block = {4, 4, 1, 64},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_S3TC,
      .nr_channels = 1,	/* nr_channels */
      .is_array = false,	/* is_array */
      .is_bitmask = false,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = true,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
   {
      {UTIL_FORMAT_TYPE_VOID, false, false, 64, 0},	/* x = x */
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0}
   },
   {
      PIPE_SWIZZLE_X,	/* sr */
      PIPE_SWIZZLE_Y,	/* sg */
      PIPE_SWIZZLE_Z,	/* sb */
      PIPE_SWIZZLE_1	/* a */
   },
      .colorspace = UTIL_FORMAT_COLORSPACE_SRGB,
      .linear_equivalent = PIPE_FORMAT_DXT1_RGB,	/* linear_equivalent */
   },

   [PIPE_FORMAT_DXT1_SRGBA] = {
      .format = PIPE_FORMAT_DXT1_SRGBA,
      .name = "PIPE_FORMAT_DXT1_SRGBA",
      .short_name = "dxt1_srgba",
      .block = {4, 4, 1, 64},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_S3TC,
      .nr_channels = 1,	/* nr_channels */
      .is_array = false,	/* is_array */
      .is_bitmask = false,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = true,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
   {
      {UTIL_FORMAT_TYPE_VOID, false, false, 64, 0},	/* x = x */
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0}
   },
   {
      PIPE_SWIZZLE_X,	/* sr */
      PIPE_SWIZZLE_Y,	/* sg */
      PIPE_SWIZZLE_Z,	/* sb */
      PIPE_SWIZZLE_W	/* a */
   },
      .colorspace = UTIL_FORMAT_COLORSPACE_SRGB,
      .linear_equivalent = PIPE_FORMAT_DXT1_RGBA,	/* linear_equivalent */
   },

   [PIPE_FORMAT_DXT3_SRGBA] = {
      .format = PIPE_FORMAT_DXT3_SRGBA,
      .name = "PIPE_FORMAT_DXT3_SRGBA",
      .short_name = "dxt3_srgba",
      .block = {4, 4, 1, 128},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_S3TC,
      .nr_channels = 1,	/* nr_channels */
      .is_array = false,	/* is_array */
      .is_bitmask = false,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = true,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
   {
      {UTIL_FORMAT_TYPE_VOID, false, false, 128, 0},	/* x = x */
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0}
   },
   {
      PIPE_SWIZZLE_X,	/* sr */
      PIPE_SWIZZLE_Y,	/* sg */
      PIPE_SWIZZLE_Z,	/* sb */
      PIPE_SWIZZLE_W	/* a */
   },
      .colorspace = UTIL_FORMAT_COLORSPACE_SRGB,
      .linear_equivalent = PIPE_FORMAT_DXT3_RGBA,	/* linear_equivalent */
   },

   [PIPE_FORMAT_DXT5_SRGBA] = {
      .format = PIPE_FORMAT_DXT5_SRGBA,
      .name = "PIPE_FORMAT_DXT5_SRGBA",
      .short_name = "dxt5_srgba",
      .block = {4, 4, 1, 128},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_S3TC,
      .nr_channels = 1,	/* nr_channels */
      .is_array = false,	/* is_array */
      .is_bitmask = false,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = true,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
   {
      {UTIL_FORMAT_TYPE_VOID, false, false, 128, 0},	/* x = x */
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0}
   },
   {
      PIPE_SWIZZLE_X,	/* sr */
      PIPE_SWIZZLE_Y,	/* sg */
      PIPE_SWIZZLE_Z,	/* sb */
      PIPE_SWIZZLE_W	/* a */
   },
      .colorspace = UTIL_FORMAT_COLORSPACE_SRGB,
      .linear_equivalent = PIPE_FORMAT_DXT5_RGBA,	/* linear_equivalent */
   },

   [PIPE_FORMAT_FXT1_RGB] = {
      .format = PIPE_FORMAT_FXT1_RGB,
      .name = "PIPE_FORMAT_FXT1_RGB",
      .short_name = "fxt1_rgb",
      .block = {8, 4, 1, 128},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_FXT1,
      .nr_channels = 1,	/* nr_channels */
      .is_array = false,	/* is_array */
      .is_bitmask = false,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = true,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
   {
      {UTIL_FORMAT_TYPE_VOID, false, false, 128, 0},	/* x = x */
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0}
   },
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_Y,	/* g */
      PIPE_SWIZZLE_Z,	/* b */
      PIPE_SWIZZLE_1	/* a */
   },
      .colorspace = UTIL_FORMAT_COLORSPACE_RGB,
      .srgb_equivalent = PIPE_FORMAT_NONE,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_FXT1_RGBA] = {
      .format = PIPE_FORMAT_FXT1_RGBA,
      .name = "PIPE_FORMAT_FXT1_RGBA",
      .short_name = "fxt1_rgba",
      .block = {8, 4, 1, 128},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_FXT1,
      .nr_channels = 1,	/* nr_channels */
      .is_array = false,	/* is_array */
      .is_bitmask = false,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = true,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
   {
      {UTIL_FORMAT_TYPE_VOID, false, false, 128, 0},	/* x = x */
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0}
   },
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_Y,	/* g */
      PIPE_SWIZZLE_Z,	/* b */
      PIPE_SWIZZLE_W	/* a */
   },
      .colorspace = UTIL_FORMAT_COLORSPACE_RGB,
      .srgb_equivalent = PIPE_FORMAT_NONE,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_RGTC1_UNORM] = {
      .format = PIPE_FORMAT_RGTC1_UNORM,
      .name = "PIPE_FORMAT_RGTC1_UNORM",
      .short_name = "rgtc1_unorm",
      .block = {4, 4, 1, 64},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_RGTC,
      .nr_channels = 1,	/* nr_channels */
      .is_array = false,	/* is_array */
      .is_bitmask = false,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = true,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
   {
      {UTIL_FORMAT_TYPE_VOID, false, false, 64, 0},	/* x = x */
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0}
   },
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_0,	/* g */
      PIPE_SWIZZLE_0,	/* b */
      PIPE_SWIZZLE_1	/* a */
   },
      .colorspace = UTIL_FORMAT_COLORSPACE_RGB,
      .srgb_equivalent = PIPE_FORMAT_NONE,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_RGTC1_SNORM] = {
      .format = PIPE_FORMAT_RGTC1_SNORM,
      .name = "PIPE_FORMAT_RGTC1_SNORM",
      .short_name = "rgtc1_snorm",
      .block = {4, 4, 1, 64},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_RGTC,
      .nr_channels = 1,	/* nr_channels */
      .is_array = false,	/* is_array */
      .is_bitmask = false,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = false,	/* is_unorm */
      .is_snorm = true,	/* is_snorm */
   {
      {UTIL_FORMAT_TYPE_VOID, false, false, 64, 0},	/* x = x */
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0}
   },
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_0,	/* g */
      PIPE_SWIZZLE_0,	/* b */
      PIPE_SWIZZLE_1	/* a */
   },
      .colorspace = UTIL_FORMAT_COLORSPACE_RGB,
      .srgb_equivalent = PIPE_FORMAT_NONE,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_RGTC2_UNORM] = {
      .format = PIPE_FORMAT_RGTC2_UNORM,
      .name = "PIPE_FORMAT_RGTC2_UNORM",
      .short_name = "rgtc2_unorm",
      .block = {4, 4, 1, 128},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_RGTC,
      .nr_channels = 1,	/* nr_channels */
      .is_array = false,	/* is_array */
      .is_bitmask = false,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = true,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
   {
      {UTIL_FORMAT_TYPE_VOID, false, false, 128, 0},	/* x = x */
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0}
   },
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_Y,	/* g */
      PIPE_SWIZZLE_0,	/* b */
      PIPE_SWIZZLE_1	/* a */
   },
      .colorspace = UTIL_FORMAT_COLORSPACE_RGB,
      .srgb_equivalent = PIPE_FORMAT_NONE,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_RGTC2_SNORM] = {
      .format = PIPE_FORMAT_RGTC2_SNORM,
      .name = "PIPE_FORMAT_RGTC2_SNORM",
      .short_name = "rgtc2_snorm",
      .block = {4, 4, 1, 128},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_RGTC,
      .nr_channels = 1,	/* nr_channels */
      .is_array = false,	/* is_array */
      .is_bitmask = false,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = false,	/* is_unorm */
      .is_snorm = true,	/* is_snorm */
   {
      {UTIL_FORMAT_TYPE_VOID, false, false, 128, 0},	/* x = x */
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0}
   },
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_Y,	/* g */
      PIPE_SWIZZLE_0,	/* b */
      PIPE_SWIZZLE_1	/* a */
   },
      .colorspace = UTIL_FORMAT_COLORSPACE_RGB,
      .srgb_equivalent = PIPE_FORMAT_NONE,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_LATC1_UNORM] = {
      .format = PIPE_FORMAT_LATC1_UNORM,
      .name = "PIPE_FORMAT_LATC1_UNORM",
      .short_name = "latc1_unorm",
      .block = {4, 4, 1, 64},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_RGTC,
      .nr_channels = 1,	/* nr_channels */
      .is_array = false,	/* is_array */
      .is_bitmask = false,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = true,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
   {
      {UTIL_FORMAT_TYPE_VOID, false, false, 64, 0},	/* x = x */
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0}
   },
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_X,	/* g */
      PIPE_SWIZZLE_X,	/* b */
      PIPE_SWIZZLE_1	/* a */
   },
      .colorspace = UTIL_FORMAT_COLORSPACE_RGB,
      .srgb_equivalent = PIPE_FORMAT_NONE,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_LATC1_SNORM] = {
      .format = PIPE_FORMAT_LATC1_SNORM,
      .name = "PIPE_FORMAT_LATC1_SNORM",
      .short_name = "latc1_snorm",
      .block = {4, 4, 1, 64},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_RGTC,
      .nr_channels = 1,	/* nr_channels */
      .is_array = false,	/* is_array */
      .is_bitmask = false,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = false,	/* is_unorm */
      .is_snorm = true,	/* is_snorm */
   {
      {UTIL_FORMAT_TYPE_VOID, false, false, 64, 0},	/* x = x */
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0}
   },
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_X,	/* g */
      PIPE_SWIZZLE_X,	/* b */
      PIPE_SWIZZLE_1	/* a */
   },
      .colorspace = UTIL_FORMAT_COLORSPACE_RGB,
      .srgb_equivalent = PIPE_FORMAT_NONE,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_LATC2_UNORM] = {
      .format = PIPE_FORMAT_LATC2_UNORM,
      .name = "PIPE_FORMAT_LATC2_UNORM",
      .short_name = "latc2_unorm",
      .block = {4, 4, 1, 128},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_RGTC,
      .nr_channels = 1,	/* nr_channels */
      .is_array = false,	/* is_array */
      .is_bitmask = false,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = true,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
   {
      {UTIL_FORMAT_TYPE_VOID, false, false, 128, 0},	/* x = x */
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0}
   },
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_X,	/* g */
      PIPE_SWIZZLE_X,	/* b */
      PIPE_SWIZZLE_Y	/* a */
   },
      .colorspace = UTIL_FORMAT_COLORSPACE_RGB,
      .srgb_equivalent = PIPE_FORMAT_NONE,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_LATC2_SNORM] = {
      .format = PIPE_FORMAT_LATC2_SNORM,
      .name = "PIPE_FORMAT_LATC2_SNORM",
      .short_name = "latc2_snorm",
      .block = {4, 4, 1, 128},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_RGTC,
      .nr_channels = 1,	/* nr_channels */
      .is_array = false,	/* is_array */
      .is_bitmask = false,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = false,	/* is_unorm */
      .is_snorm = true,	/* is_snorm */
   {
      {UTIL_FORMAT_TYPE_VOID, false, false, 128, 0},	/* x = x */
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0}
   },
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_X,	/* g */
      PIPE_SWIZZLE_X,	/* b */
      PIPE_SWIZZLE_Y	/* a */
   },
      .colorspace = UTIL_FORMAT_COLORSPACE_RGB,
      .srgb_equivalent = PIPE_FORMAT_NONE,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_ETC1_RGB8] = {
      .format = PIPE_FORMAT_ETC1_RGB8,
      .name = "PIPE_FORMAT_ETC1_RGB8",
      .short_name = "etc1_rgb8",
      .block = {4, 4, 1, 64},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_ETC,
      .nr_channels = 1,	/* nr_channels */
      .is_array = false,	/* is_array */
      .is_bitmask = false,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = true,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
   {
      {UTIL_FORMAT_TYPE_VOID, false, false, 64, 0},	/* x = x */
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0}
   },
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_Y,	/* g */
      PIPE_SWIZZLE_Z,	/* b */
      PIPE_SWIZZLE_1	/* a */
   },
      .colorspace = UTIL_FORMAT_COLORSPACE_RGB,
      .srgb_equivalent = PIPE_FORMAT_NONE,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_ETC2_RGB8] = {
      .format = PIPE_FORMAT_ETC2_RGB8,
      .name = "PIPE_FORMAT_ETC2_RGB8",
      .short_name = "etc2_rgb8",
      .block = {4, 4, 1, 64},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_ETC,
      .nr_channels = 1,	/* nr_channels */
      .is_array = false,	/* is_array */
      .is_bitmask = false,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = true,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
   {
      {UTIL_FORMAT_TYPE_VOID, false, false, 64, 0},	/* x = x */
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0}
   },
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_Y,	/* g */
      PIPE_SWIZZLE_Z,	/* b */
      PIPE_SWIZZLE_1	/* a */
   },
      .colorspace = UTIL_FORMAT_COLORSPACE_RGB,
      .srgb_equivalent = PIPE_FORMAT_ETC2_SRGB8,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_ETC2_SRGB8] = {
      .format = PIPE_FORMAT_ETC2_SRGB8,
      .name = "PIPE_FORMAT_ETC2_SRGB8",
      .short_name = "etc2_srgb8",
      .block = {4, 4, 1, 64},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_ETC,
      .nr_channels = 1,	/* nr_channels */
      .is_array = false,	/* is_array */
      .is_bitmask = false,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = true,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
   {
      {UTIL_FORMAT_TYPE_VOID, false, false, 64, 0},	/* x = x */
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0}
   },
   {
      PIPE_SWIZZLE_X,	/* sr */
      PIPE_SWIZZLE_Y,	/* sg */
      PIPE_SWIZZLE_Z,	/* sb */
      PIPE_SWIZZLE_1	/* a */
   },
      .colorspace = UTIL_FORMAT_COLORSPACE_SRGB,
      .linear_equivalent = PIPE_FORMAT_ETC2_RGB8,	/* linear_equivalent */
   },

   [PIPE_FORMAT_ETC2_RGB8A1] = {
      .format = PIPE_FORMAT_ETC2_RGB8A1,
      .name = "PIPE_FORMAT_ETC2_RGB8A1",
      .short_name = "etc2_rgb8a1",
      .block = {4, 4, 1, 64},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_ETC,
      .nr_channels = 1,	/* nr_channels */
      .is_array = false,	/* is_array */
      .is_bitmask = false,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = true,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
   {
      {UTIL_FORMAT_TYPE_VOID, false, false, 64, 0},	/* x = x */
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0}
   },
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_Y,	/* g */
      PIPE_SWIZZLE_Z,	/* b */
      PIPE_SWIZZLE_W	/* a */
   },
      .colorspace = UTIL_FORMAT_COLORSPACE_RGB,
      .srgb_equivalent = PIPE_FORMAT_ETC2_SRGB8A1,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_ETC2_SRGB8A1] = {
      .format = PIPE_FORMAT_ETC2_SRGB8A1,
      .name = "PIPE_FORMAT_ETC2_SRGB8A1",
      .short_name = "etc2_srgb8a1",
      .block = {4, 4, 1, 64},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_ETC,
      .nr_channels = 1,	/* nr_channels */
      .is_array = false,	/* is_array */
      .is_bitmask = false,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = true,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
   {
      {UTIL_FORMAT_TYPE_VOID, false, false, 64, 0},	/* x = x */
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0}
   },
   {
      PIPE_SWIZZLE_X,	/* sr */
      PIPE_SWIZZLE_Y,	/* sg */
      PIPE_SWIZZLE_Z,	/* sb */
      PIPE_SWIZZLE_W	/* a */
   },
      .colorspace = UTIL_FORMAT_COLORSPACE_SRGB,
      .linear_equivalent = PIPE_FORMAT_ETC2_RGB8A1,	/* linear_equivalent */
   },

   [PIPE_FORMAT_ETC2_RGBA8] = {
      .format = PIPE_FORMAT_ETC2_RGBA8,
      .name = "PIPE_FORMAT_ETC2_RGBA8",
      .short_name = "etc2_rgba8",
      .block = {4, 4, 1, 128},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_ETC,
      .nr_channels = 1,	/* nr_channels */
      .is_array = false,	/* is_array */
      .is_bitmask = false,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = true,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
   {
      {UTIL_FORMAT_TYPE_VOID, false, false, 128, 0},	/* x = x */
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0}
   },
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_Y,	/* g */
      PIPE_SWIZZLE_Z,	/* b */
      PIPE_SWIZZLE_W	/* a */
   },
      .colorspace = UTIL_FORMAT_COLORSPACE_RGB,
      .srgb_equivalent = PIPE_FORMAT_ETC2_SRGBA8,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_ETC2_SRGBA8] = {
      .format = PIPE_FORMAT_ETC2_SRGBA8,
      .name = "PIPE_FORMAT_ETC2_SRGBA8",
      .short_name = "etc2_srgba8",
      .block = {4, 4, 1, 128},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_ETC,
      .nr_channels = 1,	/* nr_channels */
      .is_array = false,	/* is_array */
      .is_bitmask = false,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = true,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
   {
      {UTIL_FORMAT_TYPE_VOID, false, false, 128, 0},	/* x = x */
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0}
   },
   {
      PIPE_SWIZZLE_X,	/* sr */
      PIPE_SWIZZLE_Y,	/* sg */
      PIPE_SWIZZLE_Z,	/* sb */
      PIPE_SWIZZLE_W	/* a */
   },
      .colorspace = UTIL_FORMAT_COLORSPACE_SRGB,
      .linear_equivalent = PIPE_FORMAT_ETC2_RGBA8,	/* linear_equivalent */
   },

   [PIPE_FORMAT_ETC2_R11_UNORM] = {
      .format = PIPE_FORMAT_ETC2_R11_UNORM,
      .name = "PIPE_FORMAT_ETC2_R11_UNORM",
      .short_name = "etc2_r11_unorm",
      .block = {4, 4, 1, 64},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_ETC,
      .nr_channels = 1,	/* nr_channels */
      .is_array = false,	/* is_array */
      .is_bitmask = false,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = true,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
   {
      {UTIL_FORMAT_TYPE_VOID, false, false, 64, 0},	/* x = x */
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0}
   },
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_0,	/* g */
      PIPE_SWIZZLE_0,	/* b */
      PIPE_SWIZZLE_1	/* a */
   },
      .colorspace = UTIL_FORMAT_COLORSPACE_RGB,
      .srgb_equivalent = PIPE_FORMAT_NONE,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_ETC2_R11_SNORM] = {
      .format = PIPE_FORMAT_ETC2_R11_SNORM,
      .name = "PIPE_FORMAT_ETC2_R11_SNORM",
      .short_name = "etc2_r11_snorm",
      .block = {4, 4, 1, 64},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_ETC,
      .nr_channels = 1,	/* nr_channels */
      .is_array = false,	/* is_array */
      .is_bitmask = false,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = false,	/* is_unorm */
      .is_snorm = true,	/* is_snorm */
   {
      {UTIL_FORMAT_TYPE_VOID, false, false, 64, 0},	/* x = x */
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0}
   },
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_0,	/* g */
      PIPE_SWIZZLE_0,	/* b */
      PIPE_SWIZZLE_1	/* a */
   },
      .colorspace = UTIL_FORMAT_COLORSPACE_RGB,
      .srgb_equivalent = PIPE_FORMAT_NONE,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_ETC2_RG11_UNORM] = {
      .format = PIPE_FORMAT_ETC2_RG11_UNORM,
      .name = "PIPE_FORMAT_ETC2_RG11_UNORM",
      .short_name = "etc2_rg11_unorm",
      .block = {4, 4, 1, 128},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_ETC,
      .nr_channels = 1,	/* nr_channels */
      .is_array = false,	/* is_array */
      .is_bitmask = false,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = true,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
   {
      {UTIL_FORMAT_TYPE_VOID, false, false, 128, 0},	/* x = x */
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0}
   },
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_Y,	/* g */
      PIPE_SWIZZLE_0,	/* b */
      PIPE_SWIZZLE_1	/* a */
   },
      .colorspace = UTIL_FORMAT_COLORSPACE_RGB,
      .srgb_equivalent = PIPE_FORMAT_NONE,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_ETC2_RG11_SNORM] = {
      .format = PIPE_FORMAT_ETC2_RG11_SNORM,
      .name = "PIPE_FORMAT_ETC2_RG11_SNORM",
      .short_name = "etc2_rg11_snorm",
      .block = {4, 4, 1, 128},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_ETC,
      .nr_channels = 1,	/* nr_channels */
      .is_array = false,	/* is_array */
      .is_bitmask = false,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = false,	/* is_unorm */
      .is_snorm = true,	/* is_snorm */
   {
      {UTIL_FORMAT_TYPE_VOID, false, false, 128, 0},	/* x = x */
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0}
   },
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_Y,	/* g */
      PIPE_SWIZZLE_0,	/* b */
      PIPE_SWIZZLE_1	/* a */
   },
      .colorspace = UTIL_FORMAT_COLORSPACE_RGB,
      .srgb_equivalent = PIPE_FORMAT_NONE,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_BPTC_RGBA_UNORM] = {
      .format = PIPE_FORMAT_BPTC_RGBA_UNORM,
      .name = "PIPE_FORMAT_BPTC_RGBA_UNORM",
      .short_name = "bptc_rgba_unorm",
      .block = {4, 4, 1, 128},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_BPTC,
      .nr_channels = 1,	/* nr_channels */
      .is_array = false,	/* is_array */
      .is_bitmask = false,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = true,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
   {
      {UTIL_FORMAT_TYPE_VOID, false, false, 128, 0},	/* x = x */
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0}
   },
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_Y,	/* g */
      PIPE_SWIZZLE_Z,	/* b */
      PIPE_SWIZZLE_W	/* a */
   },
      .colorspace = UTIL_FORMAT_COLORSPACE_RGB,
      .srgb_equivalent = PIPE_FORMAT_BPTC_SRGBA,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_BPTC_SRGBA] = {
      .format = PIPE_FORMAT_BPTC_SRGBA,
      .name = "PIPE_FORMAT_BPTC_SRGBA",
      .short_name = "bptc_srgba",
      .block = {4, 4, 1, 128},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_BPTC,
      .nr_channels = 1,	/* nr_channels */
      .is_array = false,	/* is_array */
      .is_bitmask = false,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = true,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
   {
      {UTIL_FORMAT_TYPE_VOID, false, false, 128, 0},	/* x = x */
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0}
   },
   {
      PIPE_SWIZZLE_X,	/* sr */
      PIPE_SWIZZLE_Y,	/* sg */
      PIPE_SWIZZLE_Z,	/* sb */
      PIPE_SWIZZLE_W	/* a */
   },
      .colorspace = UTIL_FORMAT_COLORSPACE_SRGB,
      .linear_equivalent = PIPE_FORMAT_BPTC_RGBA_UNORM,	/* linear_equivalent */
   },

   [PIPE_FORMAT_BPTC_RGB_FLOAT] = {
      .format = PIPE_FORMAT_BPTC_RGB_FLOAT,
      .name = "PIPE_FORMAT_BPTC_RGB_FLOAT",
      .short_name = "bptc_rgb_float",
      .block = {4, 4, 1, 128},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_BPTC,
      .nr_channels = 1,	/* nr_channels */
      .is_array = false,	/* is_array */
      .is_bitmask = false,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = false,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
   {
      {UTIL_FORMAT_TYPE_VOID, false, false, 128, 0},	/* x = x */
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0}
   },
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_Y,	/* g */
      PIPE_SWIZZLE_Z,	/* b */
      PIPE_SWIZZLE_1	/* a */
   },
      .colorspace = UTIL_FORMAT_COLORSPACE_RGB,
      .srgb_equivalent = PIPE_FORMAT_NONE,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_BPTC_RGB_UFLOAT] = {
      .format = PIPE_FORMAT_BPTC_RGB_UFLOAT,
      .name = "PIPE_FORMAT_BPTC_RGB_UFLOAT",
      .short_name = "bptc_rgb_ufloat",
      .block = {4, 4, 1, 128},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_BPTC,
      .nr_channels = 1,	/* nr_channels */
      .is_array = false,	/* is_array */
      .is_bitmask = false,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = false,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
   {
      {UTIL_FORMAT_TYPE_VOID, false, false, 128, 0},	/* x = x */
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0}
   },
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_Y,	/* g */
      PIPE_SWIZZLE_Z,	/* b */
      PIPE_SWIZZLE_1	/* a */
   },
      .colorspace = UTIL_FORMAT_COLORSPACE_RGB,
      .srgb_equivalent = PIPE_FORMAT_NONE,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_ASTC_4x4] = {
      .format = PIPE_FORMAT_ASTC_4x4,
      .name = "PIPE_FORMAT_ASTC_4x4",
      .short_name = "astc_4x4",
      .block = {4, 4, 1, 128},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_ASTC,
      .nr_channels = 1,	/* nr_channels */
      .is_array = false,	/* is_array */
      .is_bitmask = false,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = true,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
   {
      {UTIL_FORMAT_TYPE_VOID, false, false, 128, 0},	/* x = x */
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0}
   },
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_Y,	/* g */
      PIPE_SWIZZLE_Z,	/* b */
      PIPE_SWIZZLE_W	/* a */
   },
      .colorspace = UTIL_FORMAT_COLORSPACE_RGB,
      .srgb_equivalent = PIPE_FORMAT_ASTC_4x4_SRGB,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_ASTC_5x4] = {
      .format = PIPE_FORMAT_ASTC_5x4,
      .name = "PIPE_FORMAT_ASTC_5x4",
      .short_name = "astc_5x4",
      .block = {5, 4, 1, 128},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_ASTC,
      .nr_channels = 1,	/* nr_channels */
      .is_array = false,	/* is_array */
      .is_bitmask = false,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = true,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
   {
      {UTIL_FORMAT_TYPE_VOID, false, false, 128, 0},	/* x = x */
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0}
   },
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_Y,	/* g */
      PIPE_SWIZZLE_Z,	/* b */
      PIPE_SWIZZLE_W	/* a */
   },
      .colorspace = UTIL_FORMAT_COLORSPACE_RGB,
      .srgb_equivalent = PIPE_FORMAT_ASTC_5x4_SRGB,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_ASTC_5x5] = {
      .format = PIPE_FORMAT_ASTC_5x5,
      .name = "PIPE_FORMAT_ASTC_5x5",
      .short_name = "astc_5x5",
      .block = {5, 5, 1, 128},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_ASTC,
      .nr_channels = 1,	/* nr_channels */
      .is_array = false,	/* is_array */
      .is_bitmask = false,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = true,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
   {
      {UTIL_FORMAT_TYPE_VOID, false, false, 128, 0},	/* x = x */
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0}
   },
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_Y,	/* g */
      PIPE_SWIZZLE_Z,	/* b */
      PIPE_SWIZZLE_W	/* a */
   },
      .colorspace = UTIL_FORMAT_COLORSPACE_RGB,
      .srgb_equivalent = PIPE_FORMAT_ASTC_5x5_SRGB,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_ASTC_6x5] = {
      .format = PIPE_FORMAT_ASTC_6x5,
      .name = "PIPE_FORMAT_ASTC_6x5",
      .short_name = "astc_6x5",
      .block = {6, 5, 1, 128},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_ASTC,
      .nr_channels = 1,	/* nr_channels */
      .is_array = false,	/* is_array */
      .is_bitmask = false,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = true,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
   {
      {UTIL_FORMAT_TYPE_VOID, false, false, 128, 0},	/* x = x */
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0}
   },
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_Y,	/* g */
      PIPE_SWIZZLE_Z,	/* b */
      PIPE_SWIZZLE_W	/* a */
   },
      .colorspace = UTIL_FORMAT_COLORSPACE_RGB,
      .srgb_equivalent = PIPE_FORMAT_ASTC_6x5_SRGB,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_ASTC_6x6] = {
      .format = PIPE_FORMAT_ASTC_6x6,
      .name = "PIPE_FORMAT_ASTC_6x6",
      .short_name = "astc_6x6",
      .block = {6, 6, 1, 128},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_ASTC,
      .nr_channels = 1,	/* nr_channels */
      .is_array = false,	/* is_array */
      .is_bitmask = false,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = true,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
   {
      {UTIL_FORMAT_TYPE_VOID, false, false, 128, 0},	/* x = x */
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0}
   },
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_Y,	/* g */
      PIPE_SWIZZLE_Z,	/* b */
      PIPE_SWIZZLE_W	/* a */
   },
      .colorspace = UTIL_FORMAT_COLORSPACE_RGB,
      .srgb_equivalent = PIPE_FORMAT_ASTC_6x6_SRGB,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_ASTC_8x5] = {
      .format = PIPE_FORMAT_ASTC_8x5,
      .name = "PIPE_FORMAT_ASTC_8x5",
      .short_name = "astc_8x5",
      .block = {8, 5, 1, 128},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_ASTC,
      .nr_channels = 1,	/* nr_channels */
      .is_array = false,	/* is_array */
      .is_bitmask = false,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = true,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
   {
      {UTIL_FORMAT_TYPE_VOID, false, false, 128, 0},	/* x = x */
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0}
   },
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_Y,	/* g */
      PIPE_SWIZZLE_Z,	/* b */
      PIPE_SWIZZLE_W	/* a */
   },
      .colorspace = UTIL_FORMAT_COLORSPACE_RGB,
      .srgb_equivalent = PIPE_FORMAT_ASTC_8x5_SRGB,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_ASTC_8x6] = {
      .format = PIPE_FORMAT_ASTC_8x6,
      .name = "PIPE_FORMAT_ASTC_8x6",
      .short_name = "astc_8x6",
      .block = {8, 6, 1, 128},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_ASTC,
      .nr_channels = 1,	/* nr_channels */
      .is_array = false,	/* is_array */
      .is_bitmask = false,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = true,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
   {
      {UTIL_FORMAT_TYPE_VOID, false, false, 128, 0},	/* x = x */
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0}
   },
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_Y,	/* g */
      PIPE_SWIZZLE_Z,	/* b */
      PIPE_SWIZZLE_W	/* a */
   },
      .colorspace = UTIL_FORMAT_COLORSPACE_RGB,
      .srgb_equivalent = PIPE_FORMAT_ASTC_8x6_SRGB,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_ASTC_8x8] = {
      .format = PIPE_FORMAT_ASTC_8x8,
      .name = "PIPE_FORMAT_ASTC_8x8",
      .short_name = "astc_8x8",
      .block = {8, 8, 1, 128},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_ASTC,
      .nr_channels = 1,	/* nr_channels */
      .is_array = false,	/* is_array */
      .is_bitmask = false,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = true,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
   {
      {UTIL_FORMAT_TYPE_VOID, false, false, 128, 0},	/* x = x */
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0}
   },
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_Y,	/* g */
      PIPE_SWIZZLE_Z,	/* b */
      PIPE_SWIZZLE_W	/* a */
   },
      .colorspace = UTIL_FORMAT_COLORSPACE_RGB,
      .srgb_equivalent = PIPE_FORMAT_ASTC_8x8_SRGB,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_ASTC_10x5] = {
      .format = PIPE_FORMAT_ASTC_10x5,
      .name = "PIPE_FORMAT_ASTC_10x5",
      .short_name = "astc_10x5",
      .block = {10, 5, 1, 128},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_ASTC,
      .nr_channels = 1,	/* nr_channels */
      .is_array = false,	/* is_array */
      .is_bitmask = false,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = true,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
   {
      {UTIL_FORMAT_TYPE_VOID, false, false, 128, 0},	/* x = x */
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0}
   },
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_Y,	/* g */
      PIPE_SWIZZLE_Z,	/* b */
      PIPE_SWIZZLE_W	/* a */
   },
      .colorspace = UTIL_FORMAT_COLORSPACE_RGB,
      .srgb_equivalent = PIPE_FORMAT_ASTC_10x5_SRGB,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_ASTC_10x6] = {
      .format = PIPE_FORMAT_ASTC_10x6,
      .name = "PIPE_FORMAT_ASTC_10x6",
      .short_name = "astc_10x6",
      .block = {10, 6, 1, 128},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_ASTC,
      .nr_channels = 1,	/* nr_channels */
      .is_array = false,	/* is_array */
      .is_bitmask = false,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = true,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
   {
      {UTIL_FORMAT_TYPE_VOID, false, false, 128, 0},	/* x = x */
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0}
   },
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_Y,	/* g */
      PIPE_SWIZZLE_Z,	/* b */
      PIPE_SWIZZLE_W	/* a */
   },
      .colorspace = UTIL_FORMAT_COLORSPACE_RGB,
      .srgb_equivalent = PIPE_FORMAT_ASTC_10x6_SRGB,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_ASTC_10x8] = {
      .format = PIPE_FORMAT_ASTC_10x8,
      .name = "PIPE_FORMAT_ASTC_10x8",
      .short_name = "astc_10x8",
      .block = {10, 8, 1, 128},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_ASTC,
      .nr_channels = 1,	/* nr_channels */
      .is_array = false,	/* is_array */
      .is_bitmask = false,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = true,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
   {
      {UTIL_FORMAT_TYPE_VOID, false, false, 128, 0},	/* x = x */
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0}
   },
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_Y,	/* g */
      PIPE_SWIZZLE_Z,	/* b */
      PIPE_SWIZZLE_W	/* a */
   },
      .colorspace = UTIL_FORMAT_COLORSPACE_RGB,
      .srgb_equivalent = PIPE_FORMAT_ASTC_10x8_SRGB,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_ASTC_10x10] = {
      .format = PIPE_FORMAT_ASTC_10x10,
      .name = "PIPE_FORMAT_ASTC_10x10",
      .short_name = "astc_10x10",
      .block = {10, 10, 1, 128},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_ASTC,
      .nr_channels = 1,	/* nr_channels */
      .is_array = false,	/* is_array */
      .is_bitmask = false,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = true,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
   {
      {UTIL_FORMAT_TYPE_VOID, false, false, 128, 0},	/* x = x */
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0}
   },
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_Y,	/* g */
      PIPE_SWIZZLE_Z,	/* b */
      PIPE_SWIZZLE_W	/* a */
   },
      .colorspace = UTIL_FORMAT_COLORSPACE_RGB,
      .srgb_equivalent = PIPE_FORMAT_ASTC_10x10_SRGB,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_ASTC_12x10] = {
      .format = PIPE_FORMAT_ASTC_12x10,
      .name = "PIPE_FORMAT_ASTC_12x10",
      .short_name = "astc_12x10",
      .block = {12, 10, 1, 128},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_ASTC,
      .nr_channels = 1,	/* nr_channels */
      .is_array = false,	/* is_array */
      .is_bitmask = false,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = true,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
   {
      {UTIL_FORMAT_TYPE_VOID, false, false, 128, 0},	/* x = x */
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0}
   },
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_Y,	/* g */
      PIPE_SWIZZLE_Z,	/* b */
      PIPE_SWIZZLE_W	/* a */
   },
      .colorspace = UTIL_FORMAT_COLORSPACE_RGB,
      .srgb_equivalent = PIPE_FORMAT_ASTC_12x10_SRGB,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_ASTC_12x12] = {
      .format = PIPE_FORMAT_ASTC_12x12,
      .name = "PIPE_FORMAT_ASTC_12x12",
      .short_name = "astc_12x12",
      .block = {12, 12, 1, 128},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_ASTC,
      .nr_channels = 1,	/* nr_channels */
      .is_array = false,	/* is_array */
      .is_bitmask = false,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = true,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
   {
      {UTIL_FORMAT_TYPE_VOID, false, false, 128, 0},	/* x = x */
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0}
   },
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_Y,	/* g */
      PIPE_SWIZZLE_Z,	/* b */
      PIPE_SWIZZLE_W	/* a */
   },
      .colorspace = UTIL_FORMAT_COLORSPACE_RGB,
      .srgb_equivalent = PIPE_FORMAT_ASTC_12x12_SRGB,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_ASTC_4x4_SRGB] = {
      .format = PIPE_FORMAT_ASTC_4x4_SRGB,
      .name = "PIPE_FORMAT_ASTC_4x4_SRGB",
      .short_name = "astc_4x4_srgb",
      .block = {4, 4, 1, 128},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_ASTC,
      .nr_channels = 1,	/* nr_channels */
      .is_array = false,	/* is_array */
      .is_bitmask = false,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = true,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
   {
      {UTIL_FORMAT_TYPE_VOID, false, false, 128, 0},	/* x = x */
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0}
   },
   {
      PIPE_SWIZZLE_X,	/* sr */
      PIPE_SWIZZLE_Y,	/* sg */
      PIPE_SWIZZLE_Z,	/* sb */
      PIPE_SWIZZLE_W	/* a */
   },
      .colorspace = UTIL_FORMAT_COLORSPACE_SRGB,
      .linear_equivalent = PIPE_FORMAT_ASTC_4x4,	/* linear_equivalent */
   },

   [PIPE_FORMAT_ASTC_5x4_SRGB] = {
      .format = PIPE_FORMAT_ASTC_5x4_SRGB,
      .name = "PIPE_FORMAT_ASTC_5x4_SRGB",
      .short_name = "astc_5x4_srgb",
      .block = {5, 4, 1, 128},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_ASTC,
      .nr_channels = 1,	/* nr_channels */
      .is_array = false,	/* is_array */
      .is_bitmask = false,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = true,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
   {
      {UTIL_FORMAT_TYPE_VOID, false, false, 128, 0},	/* x = x */
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0}
   },
   {
      PIPE_SWIZZLE_X,	/* sr */
      PIPE_SWIZZLE_Y,	/* sg */
      PIPE_SWIZZLE_Z,	/* sb */
      PIPE_SWIZZLE_W	/* a */
   },
      .colorspace = UTIL_FORMAT_COLORSPACE_SRGB,
      .linear_equivalent = PIPE_FORMAT_ASTC_5x4,	/* linear_equivalent */
   },

   [PIPE_FORMAT_ASTC_5x5_SRGB] = {
      .format = PIPE_FORMAT_ASTC_5x5_SRGB,
      .name = "PIPE_FORMAT_ASTC_5x5_SRGB",
      .short_name = "astc_5x5_srgb",
      .block = {5, 5, 1, 128},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_ASTC,
      .nr_channels = 1,	/* nr_channels */
      .is_array = false,	/* is_array */
      .is_bitmask = false,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = true,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
   {
      {UTIL_FORMAT_TYPE_VOID, false, false, 128, 0},	/* x = x */
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0}
   },
   {
      PIPE_SWIZZLE_X,	/* sr */
      PIPE_SWIZZLE_Y,	/* sg */
      PIPE_SWIZZLE_Z,	/* sb */
      PIPE_SWIZZLE_W	/* a */
   },
      .colorspace = UTIL_FORMAT_COLORSPACE_SRGB,
      .linear_equivalent = PIPE_FORMAT_ASTC_5x5,	/* linear_equivalent */
   },

   [PIPE_FORMAT_ASTC_6x5_SRGB] = {
      .format = PIPE_FORMAT_ASTC_6x5_SRGB,
      .name = "PIPE_FORMAT_ASTC_6x5_SRGB",
      .short_name = "astc_6x5_srgb",
      .block = {6, 5, 1, 128},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_ASTC,
      .nr_channels = 1,	/* nr_channels */
      .is_array = false,	/* is_array */
      .is_bitmask = false,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = true,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
   {
      {UTIL_FORMAT_TYPE_VOID, false, false, 128, 0},	/* x = x */
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0}
   },
   {
      PIPE_SWIZZLE_X,	/* sr */
      PIPE_SWIZZLE_Y,	/* sg */
      PIPE_SWIZZLE_Z,	/* sb */
      PIPE_SWIZZLE_W	/* a */
   },
      .colorspace = UTIL_FORMAT_COLORSPACE_SRGB,
      .linear_equivalent = PIPE_FORMAT_ASTC_6x5,	/* linear_equivalent */
   },

   [PIPE_FORMAT_ASTC_6x6_SRGB] = {
      .format = PIPE_FORMAT_ASTC_6x6_SRGB,
      .name = "PIPE_FORMAT_ASTC_6x6_SRGB",
      .short_name = "astc_6x6_srgb",
      .block = {6, 6, 1, 128},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_ASTC,
      .nr_channels = 1,	/* nr_channels */
      .is_array = false,	/* is_array */
      .is_bitmask = false,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = true,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
   {
      {UTIL_FORMAT_TYPE_VOID, false, false, 128, 0},	/* x = x */
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0}
   },
   {
      PIPE_SWIZZLE_X,	/* sr */
      PIPE_SWIZZLE_Y,	/* sg */
      PIPE_SWIZZLE_Z,	/* sb */
      PIPE_SWIZZLE_W	/* a */
   },
      .colorspace = UTIL_FORMAT_COLORSPACE_SRGB,
      .linear_equivalent = PIPE_FORMAT_ASTC_6x6,	/* linear_equivalent */
   },

   [PIPE_FORMAT_ASTC_8x5_SRGB] = {
      .format = PIPE_FORMAT_ASTC_8x5_SRGB,
      .name = "PIPE_FORMAT_ASTC_8x5_SRGB",
      .short_name = "astc_8x5_srgb",
      .block = {8, 5, 1, 128},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_ASTC,
      .nr_channels = 1,	/* nr_channels */
      .is_array = false,	/* is_array */
      .is_bitmask = false,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = true,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
   {
      {UTIL_FORMAT_TYPE_VOID, false, false, 128, 0},	/* x = x */
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0}
   },
   {
      PIPE_SWIZZLE_X,	/* sr */
      PIPE_SWIZZLE_Y,	/* sg */
      PIPE_SWIZZLE_Z,	/* sb */
      PIPE_SWIZZLE_W	/* a */
   },
      .colorspace = UTIL_FORMAT_COLORSPACE_SRGB,
      .linear_equivalent = PIPE_FORMAT_ASTC_8x5,	/* linear_equivalent */
   },

   [PIPE_FORMAT_ASTC_8x6_SRGB] = {
      .format = PIPE_FORMAT_ASTC_8x6_SRGB,
      .name = "PIPE_FORMAT_ASTC_8x6_SRGB",
      .short_name = "astc_8x6_srgb",
      .block = {8, 6, 1, 128},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_ASTC,
      .nr_channels = 1,	/* nr_channels */
      .is_array = false,	/* is_array */
      .is_bitmask = false,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = true,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
   {
      {UTIL_FORMAT_TYPE_VOID, false, false, 128, 0},	/* x = x */
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0}
   },
   {
      PIPE_SWIZZLE_X,	/* sr */
      PIPE_SWIZZLE_Y,	/* sg */
      PIPE_SWIZZLE_Z,	/* sb */
      PIPE_SWIZZLE_W	/* a */
   },
      .colorspace = UTIL_FORMAT_COLORSPACE_SRGB,
      .linear_equivalent = PIPE_FORMAT_ASTC_8x6,	/* linear_equivalent */
   },

   [PIPE_FORMAT_ASTC_8x8_SRGB] = {
      .format = PIPE_FORMAT_ASTC_8x8_SRGB,
      .name = "PIPE_FORMAT_ASTC_8x8_SRGB",
      .short_name = "astc_8x8_srgb",
      .block = {8, 8, 1, 128},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_ASTC,
      .nr_channels = 1,	/* nr_channels */
      .is_array = false,	/* is_array */
      .is_bitmask = false,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = true,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
   {
      {UTIL_FORMAT_TYPE_VOID, false, false, 128, 0},	/* x = x */
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0}
   },
   {
      PIPE_SWIZZLE_X,	/* sr */
      PIPE_SWIZZLE_Y,	/* sg */
      PIPE_SWIZZLE_Z,	/* sb */
      PIPE_SWIZZLE_W	/* a */
   },
      .colorspace = UTIL_FORMAT_COLORSPACE_SRGB,
      .linear_equivalent = PIPE_FORMAT_ASTC_8x8,	/* linear_equivalent */
   },

   [PIPE_FORMAT_ASTC_10x5_SRGB] = {
      .format = PIPE_FORMAT_ASTC_10x5_SRGB,
      .name = "PIPE_FORMAT_ASTC_10x5_SRGB",
      .short_name = "astc_10x5_srgb",
      .block = {10, 5, 1, 128},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_ASTC,
      .nr_channels = 1,	/* nr_channels */
      .is_array = false,	/* is_array */
      .is_bitmask = false,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = true,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
   {
      {UTIL_FORMAT_TYPE_VOID, false, false, 128, 0},	/* x = x */
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0}
   },
   {
      PIPE_SWIZZLE_X,	/* sr */
      PIPE_SWIZZLE_Y,	/* sg */
      PIPE_SWIZZLE_Z,	/* sb */
      PIPE_SWIZZLE_W	/* a */
   },
      .colorspace = UTIL_FORMAT_COLORSPACE_SRGB,
      .linear_equivalent = PIPE_FORMAT_ASTC_10x5,	/* linear_equivalent */
   },

   [PIPE_FORMAT_ASTC_10x6_SRGB] = {
      .format = PIPE_FORMAT_ASTC_10x6_SRGB,
      .name = "PIPE_FORMAT_ASTC_10x6_SRGB",
      .short_name = "astc_10x6_srgb",
      .block = {10, 6, 1, 128},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_ASTC,
      .nr_channels = 1,	/* nr_channels */
      .is_array = false,	/* is_array */
      .is_bitmask = false,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = true,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
   {
      {UTIL_FORMAT_TYPE_VOID, false, false, 128, 0},	/* x = x */
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0}
   },
   {
      PIPE_SWIZZLE_X,	/* sr */
      PIPE_SWIZZLE_Y,	/* sg */
      PIPE_SWIZZLE_Z,	/* sb */
      PIPE_SWIZZLE_W	/* a */
   },
      .colorspace = UTIL_FORMAT_COLORSPACE_SRGB,
      .linear_equivalent = PIPE_FORMAT_ASTC_10x6,	/* linear_equivalent */
   },

   [PIPE_FORMAT_ASTC_10x8_SRGB] = {
      .format = PIPE_FORMAT_ASTC_10x8_SRGB,
      .name = "PIPE_FORMAT_ASTC_10x8_SRGB",
      .short_name = "astc_10x8_srgb",
      .block = {10, 8, 1, 128},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_ASTC,
      .nr_channels = 1,	/* nr_channels */
      .is_array = false,	/* is_array */
      .is_bitmask = false,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = true,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
   {
      {UTIL_FORMAT_TYPE_VOID, false, false, 128, 0},	/* x = x */
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0}
   },
   {
      PIPE_SWIZZLE_X,	/* sr */
      PIPE_SWIZZLE_Y,	/* sg */
      PIPE_SWIZZLE_Z,	/* sb */
      PIPE_SWIZZLE_W	/* a */
   },
      .colorspace = UTIL_FORMAT_COLORSPACE_SRGB,
      .linear_equivalent = PIPE_FORMAT_ASTC_10x8,	/* linear_equivalent */
   },

   [PIPE_FORMAT_ASTC_10x10_SRGB] = {
      .format = PIPE_FORMAT_ASTC_10x10_SRGB,
      .name = "PIPE_FORMAT_ASTC_10x10_SRGB",
      .short_name = "astc_10x10_srgb",
      .block = {10, 10, 1, 128},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_ASTC,
      .nr_channels = 1,	/* nr_channels */
      .is_array = false,	/* is_array */
      .is_bitmask = false,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = true,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
   {
      {UTIL_FORMAT_TYPE_VOID, false, false, 128, 0},	/* x = x */
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0}
   },
   {
      PIPE_SWIZZLE_X,	/* sr */
      PIPE_SWIZZLE_Y,	/* sg */
      PIPE_SWIZZLE_Z,	/* sb */
      PIPE_SWIZZLE_W	/* a */
   },
      .colorspace = UTIL_FORMAT_COLORSPACE_SRGB,
      .linear_equivalent = PIPE_FORMAT_ASTC_10x10,	/* linear_equivalent */
   },

   [PIPE_FORMAT_ASTC_12x10_SRGB] = {
      .format = PIPE_FORMAT_ASTC_12x10_SRGB,
      .name = "PIPE_FORMAT_ASTC_12x10_SRGB",
      .short_name = "astc_12x10_srgb",
      .block = {12, 10, 1, 128},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_ASTC,
      .nr_channels = 1,	/* nr_channels */
      .is_array = false,	/* is_array */
      .is_bitmask = false,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = true,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
   {
      {UTIL_FORMAT_TYPE_VOID, false, false, 128, 0},	/* x = x */
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0}
   },
   {
      PIPE_SWIZZLE_X,	/* sr */
      PIPE_SWIZZLE_Y,	/* sg */
      PIPE_SWIZZLE_Z,	/* sb */
      PIPE_SWIZZLE_W	/* a */
   },
      .colorspace = UTIL_FORMAT_COLORSPACE_SRGB,
      .linear_equivalent = PIPE_FORMAT_ASTC_12x10,	/* linear_equivalent */
   },

   [PIPE_FORMAT_ASTC_12x12_SRGB] = {
      .format = PIPE_FORMAT_ASTC_12x12_SRGB,
      .name = "PIPE_FORMAT_ASTC_12x12_SRGB",
      .short_name = "astc_12x12_srgb",
      .block = {12, 12, 1, 128},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_ASTC,
      .nr_channels = 1,	/* nr_channels */
      .is_array = false,	/* is_array */
      .is_bitmask = false,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = true,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
   {
      {UTIL_FORMAT_TYPE_VOID, false, false, 128, 0},	/* x = x */
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0}
   },
   {
      PIPE_SWIZZLE_X,	/* sr */
      PIPE_SWIZZLE_Y,	/* sg */
      PIPE_SWIZZLE_Z,	/* sb */
      PIPE_SWIZZLE_W	/* a */
   },
      .colorspace = UTIL_FORMAT_COLORSPACE_SRGB,
      .linear_equivalent = PIPE_FORMAT_ASTC_12x12,	/* linear_equivalent */
   },

   [PIPE_FORMAT_ASTC_3x3x3] = {
      .format = PIPE_FORMAT_ASTC_3x3x3,
      .name = "PIPE_FORMAT_ASTC_3x3x3",
      .short_name = "astc_3x3x3",
      .block = {3, 3, 3, 128},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_ASTC,
      .nr_channels = 1,	/* nr_channels */
      .is_array = false,	/* is_array */
      .is_bitmask = false,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = true,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
   {
      {UTIL_FORMAT_TYPE_VOID, false, false, 128, 0},	/* x = x */
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0}
   },
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_Y,	/* g */
      PIPE_SWIZZLE_Z,	/* b */
      PIPE_SWIZZLE_W	/* a */
   },
      .colorspace = UTIL_FORMAT_COLORSPACE_RGB,
      .srgb_equivalent = PIPE_FORMAT_ASTC_3x3x3_SRGB,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_ASTC_4x3x3] = {
      .format = PIPE_FORMAT_ASTC_4x3x3,
      .name = "PIPE_FORMAT_ASTC_4x3x3",
      .short_name = "astc_4x3x3",
      .block = {4, 3, 3, 128},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_ASTC,
      .nr_channels = 1,	/* nr_channels */
      .is_array = false,	/* is_array */
      .is_bitmask = false,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = true,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
   {
      {UTIL_FORMAT_TYPE_VOID, false, false, 128, 0},	/* x = x */
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0}
   },
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_Y,	/* g */
      PIPE_SWIZZLE_Z,	/* b */
      PIPE_SWIZZLE_W	/* a */
   },
      .colorspace = UTIL_FORMAT_COLORSPACE_RGB,
      .srgb_equivalent = PIPE_FORMAT_ASTC_4x3x3_SRGB,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_ASTC_4x4x3] = {
      .format = PIPE_FORMAT_ASTC_4x4x3,
      .name = "PIPE_FORMAT_ASTC_4x4x3",
      .short_name = "astc_4x4x3",
      .block = {4, 4, 3, 128},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_ASTC,
      .nr_channels = 1,	/* nr_channels */
      .is_array = false,	/* is_array */
      .is_bitmask = false,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = true,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
   {
      {UTIL_FORMAT_TYPE_VOID, false, false, 128, 0},	/* x = x */
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0}
   },
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_Y,	/* g */
      PIPE_SWIZZLE_Z,	/* b */
      PIPE_SWIZZLE_W	/* a */
   },
      .colorspace = UTIL_FORMAT_COLORSPACE_RGB,
      .srgb_equivalent = PIPE_FORMAT_ASTC_4x4x3_SRGB,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_ASTC_4x4x4] = {
      .format = PIPE_FORMAT_ASTC_4x4x4,
      .name = "PIPE_FORMAT_ASTC_4x4x4",
      .short_name = "astc_4x4x4",
      .block = {4, 4, 4, 128},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_ASTC,
      .nr_channels = 1,	/* nr_channels */
      .is_array = false,	/* is_array */
      .is_bitmask = false,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = true,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
   {
      {UTIL_FORMAT_TYPE_VOID, false, false, 128, 0},	/* x = x */
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0}
   },
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_Y,	/* g */
      PIPE_SWIZZLE_Z,	/* b */
      PIPE_SWIZZLE_W	/* a */
   },
      .colorspace = UTIL_FORMAT_COLORSPACE_RGB,
      .srgb_equivalent = PIPE_FORMAT_ASTC_4x4x4_SRGB,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_ASTC_5x4x4] = {
      .format = PIPE_FORMAT_ASTC_5x4x4,
      .name = "PIPE_FORMAT_ASTC_5x4x4",
      .short_name = "astc_5x4x4",
      .block = {5, 4, 4, 128},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_ASTC,
      .nr_channels = 1,	/* nr_channels */
      .is_array = false,	/* is_array */
      .is_bitmask = false,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = true,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
   {
      {UTIL_FORMAT_TYPE_VOID, false, false, 128, 0},	/* x = x */
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0}
   },
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_Y,	/* g */
      PIPE_SWIZZLE_Z,	/* b */
      PIPE_SWIZZLE_W	/* a */
   },
      .colorspace = UTIL_FORMAT_COLORSPACE_RGB,
      .srgb_equivalent = PIPE_FORMAT_ASTC_5x4x4_SRGB,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_ASTC_5x5x4] = {
      .format = PIPE_FORMAT_ASTC_5x5x4,
      .name = "PIPE_FORMAT_ASTC_5x5x4",
      .short_name = "astc_5x5x4",
      .block = {5, 5, 4, 128},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_ASTC,
      .nr_channels = 1,	/* nr_channels */
      .is_array = false,	/* is_array */
      .is_bitmask = false,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = true,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
   {
      {UTIL_FORMAT_TYPE_VOID, false, false, 128, 0},	/* x = x */
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0}
   },
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_Y,	/* g */
      PIPE_SWIZZLE_Z,	/* b */
      PIPE_SWIZZLE_W	/* a */
   },
      .colorspace = UTIL_FORMAT_COLORSPACE_RGB,
      .srgb_equivalent = PIPE_FORMAT_ASTC_5x5x4_SRGB,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_ASTC_5x5x5] = {
      .format = PIPE_FORMAT_ASTC_5x5x5,
      .name = "PIPE_FORMAT_ASTC_5x5x5",
      .short_name = "astc_5x5x5",
      .block = {5, 5, 5, 128},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_ASTC,
      .nr_channels = 1,	/* nr_channels */
      .is_array = false,	/* is_array */
      .is_bitmask = false,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = true,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
   {
      {UTIL_FORMAT_TYPE_VOID, false, false, 128, 0},	/* x = x */
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0}
   },
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_Y,	/* g */
      PIPE_SWIZZLE_Z,	/* b */
      PIPE_SWIZZLE_W	/* a */
   },
      .colorspace = UTIL_FORMAT_COLORSPACE_RGB,
      .srgb_equivalent = PIPE_FORMAT_ASTC_5x5x5_SRGB,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_ASTC_6x5x5] = {
      .format = PIPE_FORMAT_ASTC_6x5x5,
      .name = "PIPE_FORMAT_ASTC_6x5x5",
      .short_name = "astc_6x5x5",
      .block = {6, 5, 5, 128},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_ASTC,
      .nr_channels = 1,	/* nr_channels */
      .is_array = false,	/* is_array */
      .is_bitmask = false,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = true,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
   {
      {UTIL_FORMAT_TYPE_VOID, false, false, 128, 0},	/* x = x */
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0}
   },
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_Y,	/* g */
      PIPE_SWIZZLE_Z,	/* b */
      PIPE_SWIZZLE_W	/* a */
   },
      .colorspace = UTIL_FORMAT_COLORSPACE_RGB,
      .srgb_equivalent = PIPE_FORMAT_ASTC_6x5x5_SRGB,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_ASTC_6x6x5] = {
      .format = PIPE_FORMAT_ASTC_6x6x5,
      .name = "PIPE_FORMAT_ASTC_6x6x5",
      .short_name = "astc_6x6x5",
      .block = {6, 6, 5, 128},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_ASTC,
      .nr_channels = 1,	/* nr_channels */
      .is_array = false,	/* is_array */
      .is_bitmask = false,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = true,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
   {
      {UTIL_FORMAT_TYPE_VOID, false, false, 128, 0},	/* x = x */
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0}
   },
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_Y,	/* g */
      PIPE_SWIZZLE_Z,	/* b */
      PIPE_SWIZZLE_W	/* a */
   },
      .colorspace = UTIL_FORMAT_COLORSPACE_RGB,
      .srgb_equivalent = PIPE_FORMAT_ASTC_6x6x5_SRGB,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_ASTC_6x6x6] = {
      .format = PIPE_FORMAT_ASTC_6x6x6,
      .name = "PIPE_FORMAT_ASTC_6x6x6",
      .short_name = "astc_6x6x6",
      .block = {6, 6, 6, 128},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_ASTC,
      .nr_channels = 1,	/* nr_channels */
      .is_array = false,	/* is_array */
      .is_bitmask = false,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = true,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
   {
      {UTIL_FORMAT_TYPE_VOID, false, false, 128, 0},	/* x = x */
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0}
   },
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_Y,	/* g */
      PIPE_SWIZZLE_Z,	/* b */
      PIPE_SWIZZLE_W	/* a */
   },
      .colorspace = UTIL_FORMAT_COLORSPACE_RGB,
      .srgb_equivalent = PIPE_FORMAT_ASTC_6x6x6_SRGB,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_ASTC_3x3x3_SRGB] = {
      .format = PIPE_FORMAT_ASTC_3x3x3_SRGB,
      .name = "PIPE_FORMAT_ASTC_3x3x3_SRGB",
      .short_name = "astc_3x3x3_srgb",
      .block = {3, 3, 3, 128},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_ASTC,
      .nr_channels = 1,	/* nr_channels */
      .is_array = false,	/* is_array */
      .is_bitmask = false,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = true,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
   {
      {UTIL_FORMAT_TYPE_VOID, false, false, 128, 0},	/* x = x */
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0}
   },
   {
      PIPE_SWIZZLE_X,	/* sr */
      PIPE_SWIZZLE_Y,	/* sg */
      PIPE_SWIZZLE_Z,	/* sb */
      PIPE_SWIZZLE_W	/* a */
   },
      .colorspace = UTIL_FORMAT_COLORSPACE_SRGB,
      .linear_equivalent = PIPE_FORMAT_ASTC_3x3x3,	/* linear_equivalent */
   },

   [PIPE_FORMAT_ASTC_4x3x3_SRGB] = {
      .format = PIPE_FORMAT_ASTC_4x3x3_SRGB,
      .name = "PIPE_FORMAT_ASTC_4x3x3_SRGB",
      .short_name = "astc_4x3x3_srgb",
      .block = {4, 3, 3, 128},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_ASTC,
      .nr_channels = 1,	/* nr_channels */
      .is_array = false,	/* is_array */
      .is_bitmask = false,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = true,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
   {
      {UTIL_FORMAT_TYPE_VOID, false, false, 128, 0},	/* x = x */
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0}
   },
   {
      PIPE_SWIZZLE_X,	/* sr */
      PIPE_SWIZZLE_Y,	/* sg */
      PIPE_SWIZZLE_Z,	/* sb */
      PIPE_SWIZZLE_W	/* a */
   },
      .colorspace = UTIL_FORMAT_COLORSPACE_SRGB,
      .linear_equivalent = PIPE_FORMAT_ASTC_4x3x3,	/* linear_equivalent */
   },

   [PIPE_FORMAT_ASTC_4x4x3_SRGB] = {
      .format = PIPE_FORMAT_ASTC_4x4x3_SRGB,
      .name = "PIPE_FORMAT_ASTC_4x4x3_SRGB",
      .short_name = "astc_4x4x3_srgb",
      .block = {4, 4, 3, 128},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_ASTC,
      .nr_channels = 1,	/* nr_channels */
      .is_array = false,	/* is_array */
      .is_bitmask = false,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = true,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
   {
      {UTIL_FORMAT_TYPE_VOID, false, false, 128, 0},	/* x = x */
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0}
   },
   {
      PIPE_SWIZZLE_X,	/* sr */
      PIPE_SWIZZLE_Y,	/* sg */
      PIPE_SWIZZLE_Z,	/* sb */
      PIPE_SWIZZLE_W	/* a */
   },
      .colorspace = UTIL_FORMAT_COLORSPACE_SRGB,
      .linear_equivalent = PIPE_FORMAT_ASTC_4x4x3,	/* linear_equivalent */
   },

   [PIPE_FORMAT_ASTC_4x4x4_SRGB] = {
      .format = PIPE_FORMAT_ASTC_4x4x4_SRGB,
      .name = "PIPE_FORMAT_ASTC_4x4x4_SRGB",
      .short_name = "astc_4x4x4_srgb",
      .block = {4, 4, 4, 128},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_ASTC,
      .nr_channels = 1,	/* nr_channels */
      .is_array = false,	/* is_array */
      .is_bitmask = false,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = true,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
   {
      {UTIL_FORMAT_TYPE_VOID, false, false, 128, 0},	/* x = x */
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0}
   },
   {
      PIPE_SWIZZLE_X,	/* sr */
      PIPE_SWIZZLE_Y,	/* sg */
      PIPE_SWIZZLE_Z,	/* sb */
      PIPE_SWIZZLE_W	/* a */
   },
      .colorspace = UTIL_FORMAT_COLORSPACE_SRGB,
      .linear_equivalent = PIPE_FORMAT_ASTC_4x4x4,	/* linear_equivalent */
   },

   [PIPE_FORMAT_ASTC_5x4x4_SRGB] = {
      .format = PIPE_FORMAT_ASTC_5x4x4_SRGB,
      .name = "PIPE_FORMAT_ASTC_5x4x4_SRGB",
      .short_name = "astc_5x4x4_srgb",
      .block = {5, 4, 4, 128},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_ASTC,
      .nr_channels = 1,	/* nr_channels */
      .is_array = false,	/* is_array */
      .is_bitmask = false,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = true,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
   {
      {UTIL_FORMAT_TYPE_VOID, false, false, 128, 0},	/* x = x */
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0}
   },
   {
      PIPE_SWIZZLE_X,	/* sr */
      PIPE_SWIZZLE_Y,	/* sg */
      PIPE_SWIZZLE_Z,	/* sb */
      PIPE_SWIZZLE_W	/* a */
   },
      .colorspace = UTIL_FORMAT_COLORSPACE_SRGB,
      .linear_equivalent = PIPE_FORMAT_ASTC_5x4x4,	/* linear_equivalent */
   },

   [PIPE_FORMAT_ASTC_5x5x4_SRGB] = {
      .format = PIPE_FORMAT_ASTC_5x5x4_SRGB,
      .name = "PIPE_FORMAT_ASTC_5x5x4_SRGB",
      .short_name = "astc_5x5x4_srgb",
      .block = {5, 5, 4, 128},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_ASTC,
      .nr_channels = 1,	/* nr_channels */
      .is_array = false,	/* is_array */
      .is_bitmask = false,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = true,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
   {
      {UTIL_FORMAT_TYPE_VOID, false, false, 128, 0},	/* x = x */
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0}
   },
   {
      PIPE_SWIZZLE_X,	/* sr */
      PIPE_SWIZZLE_Y,	/* sg */
      PIPE_SWIZZLE_Z,	/* sb */
      PIPE_SWIZZLE_W	/* a */
   },
      .colorspace = UTIL_FORMAT_COLORSPACE_SRGB,
      .linear_equivalent = PIPE_FORMAT_ASTC_5x5x4,	/* linear_equivalent */
   },

   [PIPE_FORMAT_ASTC_5x5x5_SRGB] = {
      .format = PIPE_FORMAT_ASTC_5x5x5_SRGB,
      .name = "PIPE_FORMAT_ASTC_5x5x5_SRGB",
      .short_name = "astc_5x5x5_srgb",
      .block = {5, 5, 5, 128},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_ASTC,
      .nr_channels = 1,	/* nr_channels */
      .is_array = false,	/* is_array */
      .is_bitmask = false,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = true,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
   {
      {UTIL_FORMAT_TYPE_VOID, false, false, 128, 0},	/* x = x */
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0}
   },
   {
      PIPE_SWIZZLE_X,	/* sr */
      PIPE_SWIZZLE_Y,	/* sg */
      PIPE_SWIZZLE_Z,	/* sb */
      PIPE_SWIZZLE_W	/* a */
   },
      .colorspace = UTIL_FORMAT_COLORSPACE_SRGB,
      .linear_equivalent = PIPE_FORMAT_ASTC_5x5x5,	/* linear_equivalent */
   },

   [PIPE_FORMAT_ASTC_6x5x5_SRGB] = {
      .format = PIPE_FORMAT_ASTC_6x5x5_SRGB,
      .name = "PIPE_FORMAT_ASTC_6x5x5_SRGB",
      .short_name = "astc_6x5x5_srgb",
      .block = {6, 5, 5, 128},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_ASTC,
      .nr_channels = 1,	/* nr_channels */
      .is_array = false,	/* is_array */
      .is_bitmask = false,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = true,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
   {
      {UTIL_FORMAT_TYPE_VOID, false, false, 128, 0},	/* x = x */
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0}
   },
   {
      PIPE_SWIZZLE_X,	/* sr */
      PIPE_SWIZZLE_Y,	/* sg */
      PIPE_SWIZZLE_Z,	/* sb */
      PIPE_SWIZZLE_W	/* a */
   },
      .colorspace = UTIL_FORMAT_COLORSPACE_SRGB,
      .linear_equivalent = PIPE_FORMAT_ASTC_6x5x5,	/* linear_equivalent */
   },

   [PIPE_FORMAT_ASTC_6x6x5_SRGB] = {
      .format = PIPE_FORMAT_ASTC_6x6x5_SRGB,
      .name = "PIPE_FORMAT_ASTC_6x6x5_SRGB",
      .short_name = "astc_6x6x5_srgb",
      .block = {6, 6, 5, 128},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_ASTC,
      .nr_channels = 1,	/* nr_channels */
      .is_array = false,	/* is_array */
      .is_bitmask = false,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = true,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
   {
      {UTIL_FORMAT_TYPE_VOID, false, false, 128, 0},	/* x = x */
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0}
   },
   {
      PIPE_SWIZZLE_X,	/* sr */
      PIPE_SWIZZLE_Y,	/* sg */
      PIPE_SWIZZLE_Z,	/* sb */
      PIPE_SWIZZLE_W	/* a */
   },
      .colorspace = UTIL_FORMAT_COLORSPACE_SRGB,
      .linear_equivalent = PIPE_FORMAT_ASTC_6x6x5,	/* linear_equivalent */
   },

   [PIPE_FORMAT_ASTC_6x6x6_SRGB] = {
      .format = PIPE_FORMAT_ASTC_6x6x6_SRGB,
      .name = "PIPE_FORMAT_ASTC_6x6x6_SRGB",
      .short_name = "astc_6x6x6_srgb",
      .block = {6, 6, 6, 128},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_ASTC,
      .nr_channels = 1,	/* nr_channels */
      .is_array = false,	/* is_array */
      .is_bitmask = false,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = true,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
   {
      {UTIL_FORMAT_TYPE_VOID, false, false, 128, 0},	/* x = x */
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0}
   },
   {
      PIPE_SWIZZLE_X,	/* sr */
      PIPE_SWIZZLE_Y,	/* sg */
      PIPE_SWIZZLE_Z,	/* sb */
      PIPE_SWIZZLE_W	/* a */
   },
      .colorspace = UTIL_FORMAT_COLORSPACE_SRGB,
      .linear_equivalent = PIPE_FORMAT_ASTC_6x6x6,	/* linear_equivalent */
   },

   [PIPE_FORMAT_ASTC_4x4_FLOAT] = {
      .format = PIPE_FORMAT_ASTC_4x4_FLOAT,
      .name = "PIPE_FORMAT_ASTC_4x4_FLOAT",
      .short_name = "astc_4x4_float",
      .block = {4, 4, 1, 128},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_ASTC,
      .nr_channels = 1,	/* nr_channels */
      .is_array = false,	/* is_array */
      .is_bitmask = false,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = false,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
   {
      {UTIL_FORMAT_TYPE_VOID, false, false, 128, 0},	/* x = x */
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0}
   },
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_Y,	/* g */
      PIPE_SWIZZLE_Z,	/* b */
      PIPE_SWIZZLE_W	/* a */
   },
      .colorspace = UTIL_FORMAT_COLORSPACE_RGB,
      .srgb_equivalent = PIPE_FORMAT_NONE,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_ASTC_5x4_FLOAT] = {
      .format = PIPE_FORMAT_ASTC_5x4_FLOAT,
      .name = "PIPE_FORMAT_ASTC_5x4_FLOAT",
      .short_name = "astc_5x4_float",
      .block = {5, 4, 1, 128},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_ASTC,
      .nr_channels = 1,	/* nr_channels */
      .is_array = false,	/* is_array */
      .is_bitmask = false,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = false,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
   {
      {UTIL_FORMAT_TYPE_VOID, false, false, 128, 0},	/* x = x */
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0}
   },
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_Y,	/* g */
      PIPE_SWIZZLE_Z,	/* b */
      PIPE_SWIZZLE_W	/* a */
   },
      .colorspace = UTIL_FORMAT_COLORSPACE_RGB,
      .srgb_equivalent = PIPE_FORMAT_NONE,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_ASTC_5x5_FLOAT] = {
      .format = PIPE_FORMAT_ASTC_5x5_FLOAT,
      .name = "PIPE_FORMAT_ASTC_5x5_FLOAT",
      .short_name = "astc_5x5_float",
      .block = {5, 5, 1, 128},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_ASTC,
      .nr_channels = 1,	/* nr_channels */
      .is_array = false,	/* is_array */
      .is_bitmask = false,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = false,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
   {
      {UTIL_FORMAT_TYPE_VOID, false, false, 128, 0},	/* x = x */
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0}
   },
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_Y,	/* g */
      PIPE_SWIZZLE_Z,	/* b */
      PIPE_SWIZZLE_W	/* a */
   },
      .colorspace = UTIL_FORMAT_COLORSPACE_RGB,
      .srgb_equivalent = PIPE_FORMAT_NONE,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_ASTC_6x5_FLOAT] = {
      .format = PIPE_FORMAT_ASTC_6x5_FLOAT,
      .name = "PIPE_FORMAT_ASTC_6x5_FLOAT",
      .short_name = "astc_6x5_float",
      .block = {6, 5, 1, 128},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_ASTC,
      .nr_channels = 1,	/* nr_channels */
      .is_array = false,	/* is_array */
      .is_bitmask = false,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = false,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
   {
      {UTIL_FORMAT_TYPE_VOID, false, false, 128, 0},	/* x = x */
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0}
   },
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_Y,	/* g */
      PIPE_SWIZZLE_Z,	/* b */
      PIPE_SWIZZLE_W	/* a */
   },
      .colorspace = UTIL_FORMAT_COLORSPACE_RGB,
      .srgb_equivalent = PIPE_FORMAT_NONE,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_ASTC_6x6_FLOAT] = {
      .format = PIPE_FORMAT_ASTC_6x6_FLOAT,
      .name = "PIPE_FORMAT_ASTC_6x6_FLOAT",
      .short_name = "astc_6x6_float",
      .block = {6, 6, 1, 128},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_ASTC,
      .nr_channels = 1,	/* nr_channels */
      .is_array = false,	/* is_array */
      .is_bitmask = false,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = false,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
   {
      {UTIL_FORMAT_TYPE_VOID, false, false, 128, 0},	/* x = x */
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0}
   },
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_Y,	/* g */
      PIPE_SWIZZLE_Z,	/* b */
      PIPE_SWIZZLE_W	/* a */
   },
      .colorspace = UTIL_FORMAT_COLORSPACE_RGB,
      .srgb_equivalent = PIPE_FORMAT_NONE,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_ASTC_8x5_FLOAT] = {
      .format = PIPE_FORMAT_ASTC_8x5_FLOAT,
      .name = "PIPE_FORMAT_ASTC_8x5_FLOAT",
      .short_name = "astc_8x5_float",
      .block = {8, 5, 1, 128},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_ASTC,
      .nr_channels = 1,	/* nr_channels */
      .is_array = false,	/* is_array */
      .is_bitmask = false,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = false,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
   {
      {UTIL_FORMAT_TYPE_VOID, false, false, 128, 0},	/* x = x */
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0}
   },
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_Y,	/* g */
      PIPE_SWIZZLE_Z,	/* b */
      PIPE_SWIZZLE_W	/* a */
   },
      .colorspace = UTIL_FORMAT_COLORSPACE_RGB,
      .srgb_equivalent = PIPE_FORMAT_NONE,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_ASTC_8x6_FLOAT] = {
      .format = PIPE_FORMAT_ASTC_8x6_FLOAT,
      .name = "PIPE_FORMAT_ASTC_8x6_FLOAT",
      .short_name = "astc_8x6_float",
      .block = {8, 6, 1, 128},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_ASTC,
      .nr_channels = 1,	/* nr_channels */
      .is_array = false,	/* is_array */
      .is_bitmask = false,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = false,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
   {
      {UTIL_FORMAT_TYPE_VOID, false, false, 128, 0},	/* x = x */
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0}
   },
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_Y,	/* g */
      PIPE_SWIZZLE_Z,	/* b */
      PIPE_SWIZZLE_W	/* a */
   },
      .colorspace = UTIL_FORMAT_COLORSPACE_RGB,
      .srgb_equivalent = PIPE_FORMAT_NONE,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_ASTC_8x8_FLOAT] = {
      .format = PIPE_FORMAT_ASTC_8x8_FLOAT,
      .name = "PIPE_FORMAT_ASTC_8x8_FLOAT",
      .short_name = "astc_8x8_float",
      .block = {8, 8, 1, 128},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_ASTC,
      .nr_channels = 1,	/* nr_channels */
      .is_array = false,	/* is_array */
      .is_bitmask = false,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = false,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
   {
      {UTIL_FORMAT_TYPE_VOID, false, false, 128, 0},	/* x = x */
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0}
   },
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_Y,	/* g */
      PIPE_SWIZZLE_Z,	/* b */
      PIPE_SWIZZLE_W	/* a */
   },
      .colorspace = UTIL_FORMAT_COLORSPACE_RGB,
      .srgb_equivalent = PIPE_FORMAT_NONE,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_ASTC_10x5_FLOAT] = {
      .format = PIPE_FORMAT_ASTC_10x5_FLOAT,
      .name = "PIPE_FORMAT_ASTC_10x5_FLOAT",
      .short_name = "astc_10x5_float",
      .block = {10, 5, 1, 128},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_ASTC,
      .nr_channels = 1,	/* nr_channels */
      .is_array = false,	/* is_array */
      .is_bitmask = false,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = false,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
   {
      {UTIL_FORMAT_TYPE_VOID, false, false, 128, 0},	/* x = x */
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0}
   },
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_Y,	/* g */
      PIPE_SWIZZLE_Z,	/* b */
      PIPE_SWIZZLE_W	/* a */
   },
      .colorspace = UTIL_FORMAT_COLORSPACE_RGB,
      .srgb_equivalent = PIPE_FORMAT_NONE,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_ASTC_10x6_FLOAT] = {
      .format = PIPE_FORMAT_ASTC_10x6_FLOAT,
      .name = "PIPE_FORMAT_ASTC_10x6_FLOAT",
      .short_name = "astc_10x6_float",
      .block = {10, 6, 1, 128},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_ASTC,
      .nr_channels = 1,	/* nr_channels */
      .is_array = false,	/* is_array */
      .is_bitmask = false,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = false,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
   {
      {UTIL_FORMAT_TYPE_VOID, false, false, 128, 0},	/* x = x */
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0}
   },
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_Y,	/* g */
      PIPE_SWIZZLE_Z,	/* b */
      PIPE_SWIZZLE_W	/* a */
   },
      .colorspace = UTIL_FORMAT_COLORSPACE_RGB,
      .srgb_equivalent = PIPE_FORMAT_NONE,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_ASTC_10x8_FLOAT] = {
      .format = PIPE_FORMAT_ASTC_10x8_FLOAT,
      .name = "PIPE_FORMAT_ASTC_10x8_FLOAT",
      .short_name = "astc_10x8_float",
      .block = {10, 8, 1, 128},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_ASTC,
      .nr_channels = 1,	/* nr_channels */
      .is_array = false,	/* is_array */
      .is_bitmask = false,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = false,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
   {
      {UTIL_FORMAT_TYPE_VOID, false, false, 128, 0},	/* x = x */
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0}
   },
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_Y,	/* g */
      PIPE_SWIZZLE_Z,	/* b */
      PIPE_SWIZZLE_W	/* a */
   },
      .colorspace = UTIL_FORMAT_COLORSPACE_RGB,
      .srgb_equivalent = PIPE_FORMAT_NONE,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_ASTC_10x10_FLOAT] = {
      .format = PIPE_FORMAT_ASTC_10x10_FLOAT,
      .name = "PIPE_FORMAT_ASTC_10x10_FLOAT",
      .short_name = "astc_10x10_float",
      .block = {10, 10, 1, 128},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_ASTC,
      .nr_channels = 1,	/* nr_channels */
      .is_array = false,	/* is_array */
      .is_bitmask = false,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = false,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
   {
      {UTIL_FORMAT_TYPE_VOID, false, false, 128, 0},	/* x = x */
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0}
   },
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_Y,	/* g */
      PIPE_SWIZZLE_Z,	/* b */
      PIPE_SWIZZLE_W	/* a */
   },
      .colorspace = UTIL_FORMAT_COLORSPACE_RGB,
      .srgb_equivalent = PIPE_FORMAT_NONE,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_ASTC_12x10_FLOAT] = {
      .format = PIPE_FORMAT_ASTC_12x10_FLOAT,
      .name = "PIPE_FORMAT_ASTC_12x10_FLOAT",
      .short_name = "astc_12x10_float",
      .block = {12, 10, 1, 128},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_ASTC,
      .nr_channels = 1,	/* nr_channels */
      .is_array = false,	/* is_array */
      .is_bitmask = false,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = false,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
   {
      {UTIL_FORMAT_TYPE_VOID, false, false, 128, 0},	/* x = x */
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0}
   },
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_Y,	/* g */
      PIPE_SWIZZLE_Z,	/* b */
      PIPE_SWIZZLE_W	/* a */
   },
      .colorspace = UTIL_FORMAT_COLORSPACE_RGB,
      .srgb_equivalent = PIPE_FORMAT_NONE,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_ASTC_12x12_FLOAT] = {
      .format = PIPE_FORMAT_ASTC_12x12_FLOAT,
      .name = "PIPE_FORMAT_ASTC_12x12_FLOAT",
      .short_name = "astc_12x12_float",
      .block = {12, 12, 1, 128},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_ASTC,
      .nr_channels = 1,	/* nr_channels */
      .is_array = false,	/* is_array */
      .is_bitmask = false,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = false,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
   {
      {UTIL_FORMAT_TYPE_VOID, false, false, 128, 0},	/* x = x */
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0}
   },
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_Y,	/* g */
      PIPE_SWIZZLE_Z,	/* b */
      PIPE_SWIZZLE_W	/* a */
   },
      .colorspace = UTIL_FORMAT_COLORSPACE_RGB,
      .srgb_equivalent = PIPE_FORMAT_NONE,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_ATC_RGB] = {
      .format = PIPE_FORMAT_ATC_RGB,
      .name = "PIPE_FORMAT_ATC_RGB",
      .short_name = "atc_rgb",
      .block = {4, 4, 1, 64},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_ATC,
      .nr_channels = 1,	/* nr_channels */
      .is_array = false,	/* is_array */
      .is_bitmask = false,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = true,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
   {
      {UTIL_FORMAT_TYPE_VOID, false, false, 64, 0},	/* x = x */
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0}
   },
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_Y,	/* g */
      PIPE_SWIZZLE_Z,	/* b */
      PIPE_SWIZZLE_1	/* a */
   },
      .colorspace = UTIL_FORMAT_COLORSPACE_RGB,
      .srgb_equivalent = PIPE_FORMAT_NONE,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_ATC_RGBA_EXPLICIT] = {
      .format = PIPE_FORMAT_ATC_RGBA_EXPLICIT,
      .name = "PIPE_FORMAT_ATC_RGBA_EXPLICIT",
      .short_name = "atc_rgba_explicit",
      .block = {4, 4, 1, 128},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_ATC,
      .nr_channels = 1,	/* nr_channels */
      .is_array = false,	/* is_array */
      .is_bitmask = false,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = true,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
   {
      {UTIL_FORMAT_TYPE_VOID, false, false, 128, 0},	/* x = x */
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0}
   },
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_Y,	/* g */
      PIPE_SWIZZLE_Z,	/* b */
      PIPE_SWIZZLE_W	/* a */
   },
      .colorspace = UTIL_FORMAT_COLORSPACE_RGB,
      .srgb_equivalent = PIPE_FORMAT_NONE,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_ATC_RGBA_INTERPOLATED] = {
      .format = PIPE_FORMAT_ATC_RGBA_INTERPOLATED,
      .name = "PIPE_FORMAT_ATC_RGBA_INTERPOLATED",
      .short_name = "atc_rgba_interpolated",
      .block = {4, 4, 1, 128},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_ATC,
      .nr_channels = 1,	/* nr_channels */
      .is_array = false,	/* is_array */
      .is_bitmask = false,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = true,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
   {
      {UTIL_FORMAT_TYPE_VOID, false, false, 128, 0},	/* x = x */
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0}
   },
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_Y,	/* g */
      PIPE_SWIZZLE_Z,	/* b */
      PIPE_SWIZZLE_W	/* a */
   },
      .colorspace = UTIL_FORMAT_COLORSPACE_RGB,
      .srgb_equivalent = PIPE_FORMAT_NONE,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_R64_FLOAT] = {
      .format = PIPE_FORMAT_R64_FLOAT,
      .name = "PIPE_FORMAT_R64_FLOAT",
      .short_name = "r64_float",
      .block = {1, 1, 1, 64},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_PLAIN,
      .nr_channels = 1,	/* nr_channels */
      .is_array = true,	/* is_array */
      .is_bitmask = false,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = false,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
   {
      {UTIL_FORMAT_TYPE_FLOAT, false, false, 64, 0},	/* x = r */
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0}
   },
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_0,	/* g */
      PIPE_SWIZZLE_0,	/* b */
      PIPE_SWIZZLE_1	/* a */
   },
      .colorspace = UTIL_FORMAT_COLORSPACE_RGB,
      .srgb_equivalent = PIPE_FORMAT_NONE,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_R64G64_FLOAT] = {
      .format = PIPE_FORMAT_R64G64_FLOAT,
      .name = "PIPE_FORMAT_R64G64_FLOAT",
      .short_name = "r64g64_float",
      .block = {1, 1, 1, 128},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_PLAIN,
      .nr_channels = 2,	/* nr_channels */
      .is_array = true,	/* is_array */
      .is_bitmask = false,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = false,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
#if UTIL_ARCH_BIG_ENDIAN
   {
      {UTIL_FORMAT_TYPE_FLOAT, false, false, 64, 64},	/* x = r */
      {UTIL_FORMAT_TYPE_FLOAT, false, false, 64, 0},	/* y = g */
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0}
   },
#else
   {
      {UTIL_FORMAT_TYPE_FLOAT, false, false, 64, 0},	/* x = r */
      {UTIL_FORMAT_TYPE_FLOAT, false, false, 64, 64},	/* y = g */
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0}
   },
#endif
#if UTIL_ARCH_BIG_ENDIAN
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_Y,	/* g */
      PIPE_SWIZZLE_0,	/* b */
      PIPE_SWIZZLE_1	/* a */
   },
#else
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_Y,	/* g */
      PIPE_SWIZZLE_0,	/* b */
      PIPE_SWIZZLE_1	/* a */
   },
#endif
      .colorspace = UTIL_FORMAT_COLORSPACE_RGB,
      .srgb_equivalent = PIPE_FORMAT_NONE,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_R64G64B64_FLOAT] = {
      .format = PIPE_FORMAT_R64G64B64_FLOAT,
      .name = "PIPE_FORMAT_R64G64B64_FLOAT",
      .short_name = "r64g64b64_float",
      .block = {1, 1, 1, 192},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_PLAIN,
      .nr_channels = 3,	/* nr_channels */
      .is_array = true,	/* is_array */
      .is_bitmask = false,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = false,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
#if UTIL_ARCH_BIG_ENDIAN
   {
      {UTIL_FORMAT_TYPE_FLOAT, false, false, 64, 128},	/* x = r */
      {UTIL_FORMAT_TYPE_FLOAT, false, false, 64, 64},	/* y = g */
      {UTIL_FORMAT_TYPE_FLOAT, false, false, 64, 0},	/* z = b */
      {0, 0, 0, 0, 0}
   },
#else
   {
      {UTIL_FORMAT_TYPE_FLOAT, false, false, 64, 0},	/* x = r */
      {UTIL_FORMAT_TYPE_FLOAT, false, false, 64, 64},	/* y = g */
      {UTIL_FORMAT_TYPE_FLOAT, false, false, 64, 128},	/* z = b */
      {0, 0, 0, 0, 0}
   },
#endif
#if UTIL_ARCH_BIG_ENDIAN
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_Y,	/* g */
      PIPE_SWIZZLE_Z,	/* b */
      PIPE_SWIZZLE_1	/* a */
   },
#else
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_Y,	/* g */
      PIPE_SWIZZLE_Z,	/* b */
      PIPE_SWIZZLE_1	/* a */
   },
#endif
      .colorspace = UTIL_FORMAT_COLORSPACE_RGB,
      .srgb_equivalent = PIPE_FORMAT_NONE,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_R64G64B64A64_FLOAT] = {
      .format = PIPE_FORMAT_R64G64B64A64_FLOAT,
      .name = "PIPE_FORMAT_R64G64B64A64_FLOAT",
      .short_name = "r64g64b64a64_float",
      .block = {1, 1, 1, 256},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_PLAIN,
      .nr_channels = 4,	/* nr_channels */
      .is_array = true,	/* is_array */
      .is_bitmask = false,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = false,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
#if UTIL_ARCH_BIG_ENDIAN
   {
      {UTIL_FORMAT_TYPE_FLOAT, false, false, 64, 192},	/* x = r */
      {UTIL_FORMAT_TYPE_FLOAT, false, false, 64, 128},	/* y = g */
      {UTIL_FORMAT_TYPE_FLOAT, false, false, 64, 64},	/* z = b */
      {UTIL_FORMAT_TYPE_FLOAT, false, false, 64, 0}	/* w = a */
   },
#else
   {
      {UTIL_FORMAT_TYPE_FLOAT, false, false, 64, 0},	/* x = r */
      {UTIL_FORMAT_TYPE_FLOAT, false, false, 64, 64},	/* y = g */
      {UTIL_FORMAT_TYPE_FLOAT, false, false, 64, 128},	/* z = b */
      {UTIL_FORMAT_TYPE_FLOAT, false, false, 64, 192}	/* w = a */
   },
#endif
#if UTIL_ARCH_BIG_ENDIAN
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_Y,	/* g */
      PIPE_SWIZZLE_Z,	/* b */
      PIPE_SWIZZLE_W	/* a */
   },
#else
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_Y,	/* g */
      PIPE_SWIZZLE_Z,	/* b */
      PIPE_SWIZZLE_W	/* a */
   },
#endif
      .colorspace = UTIL_FORMAT_COLORSPACE_RGB,
      .srgb_equivalent = PIPE_FORMAT_NONE,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_R32_FLOAT] = {
      .format = PIPE_FORMAT_R32_FLOAT,
      .name = "PIPE_FORMAT_R32_FLOAT",
      .short_name = "r32_float",
      .block = {1, 1, 1, 32},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_PLAIN,
      .nr_channels = 1,	/* nr_channels */
      .is_array = true,	/* is_array */
      .is_bitmask = false,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = false,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
   {
      {UTIL_FORMAT_TYPE_FLOAT, false, false, 32, 0},	/* x = r */
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0}
   },
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_0,	/* g */
      PIPE_SWIZZLE_0,	/* b */
      PIPE_SWIZZLE_1	/* a */
   },
      .colorspace = UTIL_FORMAT_COLORSPACE_RGB,
      .srgb_equivalent = PIPE_FORMAT_NONE,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_R32G32_FLOAT] = {
      .format = PIPE_FORMAT_R32G32_FLOAT,
      .name = "PIPE_FORMAT_R32G32_FLOAT",
      .short_name = "r32g32_float",
      .block = {1, 1, 1, 64},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_PLAIN,
      .nr_channels = 2,	/* nr_channels */
      .is_array = true,	/* is_array */
      .is_bitmask = false,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = false,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
#if UTIL_ARCH_BIG_ENDIAN
   {
      {UTIL_FORMAT_TYPE_FLOAT, false, false, 32, 32},	/* x = r */
      {UTIL_FORMAT_TYPE_FLOAT, false, false, 32, 0},	/* y = g */
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0}
   },
#else
   {
      {UTIL_FORMAT_TYPE_FLOAT, false, false, 32, 0},	/* x = r */
      {UTIL_FORMAT_TYPE_FLOAT, false, false, 32, 32},	/* y = g */
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0}
   },
#endif
#if UTIL_ARCH_BIG_ENDIAN
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_Y,	/* g */
      PIPE_SWIZZLE_0,	/* b */
      PIPE_SWIZZLE_1	/* a */
   },
#else
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_Y,	/* g */
      PIPE_SWIZZLE_0,	/* b */
      PIPE_SWIZZLE_1	/* a */
   },
#endif
      .colorspace = UTIL_FORMAT_COLORSPACE_RGB,
      .srgb_equivalent = PIPE_FORMAT_NONE,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_R32G32B32_FLOAT] = {
      .format = PIPE_FORMAT_R32G32B32_FLOAT,
      .name = "PIPE_FORMAT_R32G32B32_FLOAT",
      .short_name = "r32g32b32_float",
      .block = {1, 1, 1, 96},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_PLAIN,
      .nr_channels = 3,	/* nr_channels */
      .is_array = true,	/* is_array */
      .is_bitmask = false,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = false,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
#if UTIL_ARCH_BIG_ENDIAN
   {
      {UTIL_FORMAT_TYPE_FLOAT, false, false, 32, 64},	/* x = r */
      {UTIL_FORMAT_TYPE_FLOAT, false, false, 32, 32},	/* y = g */
      {UTIL_FORMAT_TYPE_FLOAT, false, false, 32, 0},	/* z = b */
      {0, 0, 0, 0, 0}
   },
#else
   {
      {UTIL_FORMAT_TYPE_FLOAT, false, false, 32, 0},	/* x = r */
      {UTIL_FORMAT_TYPE_FLOAT, false, false, 32, 32},	/* y = g */
      {UTIL_FORMAT_TYPE_FLOAT, false, false, 32, 64},	/* z = b */
      {0, 0, 0, 0, 0}
   },
#endif
#if UTIL_ARCH_BIG_ENDIAN
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_Y,	/* g */
      PIPE_SWIZZLE_Z,	/* b */
      PIPE_SWIZZLE_1	/* a */
   },
#else
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_Y,	/* g */
      PIPE_SWIZZLE_Z,	/* b */
      PIPE_SWIZZLE_1	/* a */
   },
#endif
      .colorspace = UTIL_FORMAT_COLORSPACE_RGB,
      .srgb_equivalent = PIPE_FORMAT_NONE,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_R32G32B32A32_FLOAT] = {
      .format = PIPE_FORMAT_R32G32B32A32_FLOAT,
      .name = "PIPE_FORMAT_R32G32B32A32_FLOAT",
      .short_name = "r32g32b32a32_float",
      .block = {1, 1, 1, 128},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_PLAIN,
      .nr_channels = 4,	/* nr_channels */
      .is_array = true,	/* is_array */
      .is_bitmask = false,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = false,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
#if UTIL_ARCH_BIG_ENDIAN
   {
      {UTIL_FORMAT_TYPE_FLOAT, false, false, 32, 96},	/* x = r */
      {UTIL_FORMAT_TYPE_FLOAT, false, false, 32, 64},	/* y = g */
      {UTIL_FORMAT_TYPE_FLOAT, false, false, 32, 32},	/* z = b */
      {UTIL_FORMAT_TYPE_FLOAT, false, false, 32, 0}	/* w = a */
   },
#else
   {
      {UTIL_FORMAT_TYPE_FLOAT, false, false, 32, 0},	/* x = r */
      {UTIL_FORMAT_TYPE_FLOAT, false, false, 32, 32},	/* y = g */
      {UTIL_FORMAT_TYPE_FLOAT, false, false, 32, 64},	/* z = b */
      {UTIL_FORMAT_TYPE_FLOAT, false, false, 32, 96}	/* w = a */
   },
#endif
#if UTIL_ARCH_BIG_ENDIAN
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_Y,	/* g */
      PIPE_SWIZZLE_Z,	/* b */
      PIPE_SWIZZLE_W	/* a */
   },
#else
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_Y,	/* g */
      PIPE_SWIZZLE_Z,	/* b */
      PIPE_SWIZZLE_W	/* a */
   },
#endif
      .colorspace = UTIL_FORMAT_COLORSPACE_RGB,
      .srgb_equivalent = PIPE_FORMAT_NONE,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_R32_UNORM] = {
      .format = PIPE_FORMAT_R32_UNORM,
      .name = "PIPE_FORMAT_R32_UNORM",
      .short_name = "r32_unorm",
      .block = {1, 1, 1, 32},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_PLAIN,
      .nr_channels = 1,	/* nr_channels */
      .is_array = true,	/* is_array */
      .is_bitmask = true,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = true,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
   {
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 32, 0},	/* x = r */
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0}
   },
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_0,	/* g */
      PIPE_SWIZZLE_0,	/* b */
      PIPE_SWIZZLE_1	/* a */
   },
      .colorspace = UTIL_FORMAT_COLORSPACE_RGB,
      .srgb_equivalent = PIPE_FORMAT_NONE,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_R32G32_UNORM] = {
      .format = PIPE_FORMAT_R32G32_UNORM,
      .name = "PIPE_FORMAT_R32G32_UNORM",
      .short_name = "r32g32_unorm",
      .block = {1, 1, 1, 64},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_PLAIN,
      .nr_channels = 2,	/* nr_channels */
      .is_array = true,	/* is_array */
      .is_bitmask = false,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = true,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
#if UTIL_ARCH_BIG_ENDIAN
   {
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 32, 32},	/* x = r */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 32, 0},	/* y = g */
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0}
   },
#else
   {
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 32, 0},	/* x = r */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 32, 32},	/* y = g */
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0}
   },
#endif
#if UTIL_ARCH_BIG_ENDIAN
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_Y,	/* g */
      PIPE_SWIZZLE_0,	/* b */
      PIPE_SWIZZLE_1	/* a */
   },
#else
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_Y,	/* g */
      PIPE_SWIZZLE_0,	/* b */
      PIPE_SWIZZLE_1	/* a */
   },
#endif
      .colorspace = UTIL_FORMAT_COLORSPACE_RGB,
      .srgb_equivalent = PIPE_FORMAT_NONE,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_R32G32B32_UNORM] = {
      .format = PIPE_FORMAT_R32G32B32_UNORM,
      .name = "PIPE_FORMAT_R32G32B32_UNORM",
      .short_name = "r32g32b32_unorm",
      .block = {1, 1, 1, 96},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_PLAIN,
      .nr_channels = 3,	/* nr_channels */
      .is_array = true,	/* is_array */
      .is_bitmask = false,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = true,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
#if UTIL_ARCH_BIG_ENDIAN
   {
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 32, 64},	/* x = r */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 32, 32},	/* y = g */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 32, 0},	/* z = b */
      {0, 0, 0, 0, 0}
   },
#else
   {
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 32, 0},	/* x = r */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 32, 32},	/* y = g */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 32, 64},	/* z = b */
      {0, 0, 0, 0, 0}
   },
#endif
#if UTIL_ARCH_BIG_ENDIAN
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_Y,	/* g */
      PIPE_SWIZZLE_Z,	/* b */
      PIPE_SWIZZLE_1	/* a */
   },
#else
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_Y,	/* g */
      PIPE_SWIZZLE_Z,	/* b */
      PIPE_SWIZZLE_1	/* a */
   },
#endif
      .colorspace = UTIL_FORMAT_COLORSPACE_RGB,
      .srgb_equivalent = PIPE_FORMAT_NONE,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_R32G32B32A32_UNORM] = {
      .format = PIPE_FORMAT_R32G32B32A32_UNORM,
      .name = "PIPE_FORMAT_R32G32B32A32_UNORM",
      .short_name = "r32g32b32a32_unorm",
      .block = {1, 1, 1, 128},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_PLAIN,
      .nr_channels = 4,	/* nr_channels */
      .is_array = true,	/* is_array */
      .is_bitmask = false,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = true,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
#if UTIL_ARCH_BIG_ENDIAN
   {
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 32, 96},	/* x = r */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 32, 64},	/* y = g */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 32, 32},	/* z = b */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 32, 0}	/* w = a */
   },
#else
   {
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 32, 0},	/* x = r */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 32, 32},	/* y = g */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 32, 64},	/* z = b */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 32, 96}	/* w = a */
   },
#endif
#if UTIL_ARCH_BIG_ENDIAN
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_Y,	/* g */
      PIPE_SWIZZLE_Z,	/* b */
      PIPE_SWIZZLE_W	/* a */
   },
#else
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_Y,	/* g */
      PIPE_SWIZZLE_Z,	/* b */
      PIPE_SWIZZLE_W	/* a */
   },
#endif
      .colorspace = UTIL_FORMAT_COLORSPACE_RGB,
      .srgb_equivalent = PIPE_FORMAT_NONE,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_R32_USCALED] = {
      .format = PIPE_FORMAT_R32_USCALED,
      .name = "PIPE_FORMAT_R32_USCALED",
      .short_name = "r32_uscaled",
      .block = {1, 1, 1, 32},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_PLAIN,
      .nr_channels = 1,	/* nr_channels */
      .is_array = true,	/* is_array */
      .is_bitmask = true,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = false,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
   {
      {UTIL_FORMAT_TYPE_UNSIGNED, false, false, 32, 0},	/* x = r */
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0}
   },
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_0,	/* g */
      PIPE_SWIZZLE_0,	/* b */
      PIPE_SWIZZLE_1	/* a */
   },
      .colorspace = UTIL_FORMAT_COLORSPACE_RGB,
      .srgb_equivalent = PIPE_FORMAT_NONE,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_R32G32_USCALED] = {
      .format = PIPE_FORMAT_R32G32_USCALED,
      .name = "PIPE_FORMAT_R32G32_USCALED",
      .short_name = "r32g32_uscaled",
      .block = {1, 1, 1, 64},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_PLAIN,
      .nr_channels = 2,	/* nr_channels */
      .is_array = true,	/* is_array */
      .is_bitmask = false,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = false,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
#if UTIL_ARCH_BIG_ENDIAN
   {
      {UTIL_FORMAT_TYPE_UNSIGNED, false, false, 32, 32},	/* x = r */
      {UTIL_FORMAT_TYPE_UNSIGNED, false, false, 32, 0},	/* y = g */
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0}
   },
#else
   {
      {UTIL_FORMAT_TYPE_UNSIGNED, false, false, 32, 0},	/* x = r */
      {UTIL_FORMAT_TYPE_UNSIGNED, false, false, 32, 32},	/* y = g */
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0}
   },
#endif
#if UTIL_ARCH_BIG_ENDIAN
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_Y,	/* g */
      PIPE_SWIZZLE_0,	/* b */
      PIPE_SWIZZLE_1	/* a */
   },
#else
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_Y,	/* g */
      PIPE_SWIZZLE_0,	/* b */
      PIPE_SWIZZLE_1	/* a */
   },
#endif
      .colorspace = UTIL_FORMAT_COLORSPACE_RGB,
      .srgb_equivalent = PIPE_FORMAT_NONE,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_R32G32B32_USCALED] = {
      .format = PIPE_FORMAT_R32G32B32_USCALED,
      .name = "PIPE_FORMAT_R32G32B32_USCALED",
      .short_name = "r32g32b32_uscaled",
      .block = {1, 1, 1, 96},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_PLAIN,
      .nr_channels = 3,	/* nr_channels */
      .is_array = true,	/* is_array */
      .is_bitmask = false,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = false,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
#if UTIL_ARCH_BIG_ENDIAN
   {
      {UTIL_FORMAT_TYPE_UNSIGNED, false, false, 32, 64},	/* x = r */
      {UTIL_FORMAT_TYPE_UNSIGNED, false, false, 32, 32},	/* y = g */
      {UTIL_FORMAT_TYPE_UNSIGNED, false, false, 32, 0},	/* z = b */
      {0, 0, 0, 0, 0}
   },
#else
   {
      {UTIL_FORMAT_TYPE_UNSIGNED, false, false, 32, 0},	/* x = r */
      {UTIL_FORMAT_TYPE_UNSIGNED, false, false, 32, 32},	/* y = g */
      {UTIL_FORMAT_TYPE_UNSIGNED, false, false, 32, 64},	/* z = b */
      {0, 0, 0, 0, 0}
   },
#endif
#if UTIL_ARCH_BIG_ENDIAN
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_Y,	/* g */
      PIPE_SWIZZLE_Z,	/* b */
      PIPE_SWIZZLE_1	/* a */
   },
#else
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_Y,	/* g */
      PIPE_SWIZZLE_Z,	/* b */
      PIPE_SWIZZLE_1	/* a */
   },
#endif
      .colorspace = UTIL_FORMAT_COLORSPACE_RGB,
      .srgb_equivalent = PIPE_FORMAT_NONE,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_R32G32B32A32_USCALED] = {
      .format = PIPE_FORMAT_R32G32B32A32_USCALED,
      .name = "PIPE_FORMAT_R32G32B32A32_USCALED",
      .short_name = "r32g32b32a32_uscaled",
      .block = {1, 1, 1, 128},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_PLAIN,
      .nr_channels = 4,	/* nr_channels */
      .is_array = true,	/* is_array */
      .is_bitmask = false,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = false,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
#if UTIL_ARCH_BIG_ENDIAN
   {
      {UTIL_FORMAT_TYPE_UNSIGNED, false, false, 32, 96},	/* x = r */
      {UTIL_FORMAT_TYPE_UNSIGNED, false, false, 32, 64},	/* y = g */
      {UTIL_FORMAT_TYPE_UNSIGNED, false, false, 32, 32},	/* z = b */
      {UTIL_FORMAT_TYPE_UNSIGNED, false, false, 32, 0}	/* w = a */
   },
#else
   {
      {UTIL_FORMAT_TYPE_UNSIGNED, false, false, 32, 0},	/* x = r */
      {UTIL_FORMAT_TYPE_UNSIGNED, false, false, 32, 32},	/* y = g */
      {UTIL_FORMAT_TYPE_UNSIGNED, false, false, 32, 64},	/* z = b */
      {UTIL_FORMAT_TYPE_UNSIGNED, false, false, 32, 96}	/* w = a */
   },
#endif
#if UTIL_ARCH_BIG_ENDIAN
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_Y,	/* g */
      PIPE_SWIZZLE_Z,	/* b */
      PIPE_SWIZZLE_W	/* a */
   },
#else
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_Y,	/* g */
      PIPE_SWIZZLE_Z,	/* b */
      PIPE_SWIZZLE_W	/* a */
   },
#endif
      .colorspace = UTIL_FORMAT_COLORSPACE_RGB,
      .srgb_equivalent = PIPE_FORMAT_NONE,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_R32_SNORM] = {
      .format = PIPE_FORMAT_R32_SNORM,
      .name = "PIPE_FORMAT_R32_SNORM",
      .short_name = "r32_snorm",
      .block = {1, 1, 1, 32},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_PLAIN,
      .nr_channels = 1,	/* nr_channels */
      .is_array = true,	/* is_array */
      .is_bitmask = true,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = false,	/* is_unorm */
      .is_snorm = true,	/* is_snorm */
   {
      {UTIL_FORMAT_TYPE_SIGNED, true, false, 32, 0},	/* x = r */
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0}
   },
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_0,	/* g */
      PIPE_SWIZZLE_0,	/* b */
      PIPE_SWIZZLE_1	/* a */
   },
      .colorspace = UTIL_FORMAT_COLORSPACE_RGB,
      .srgb_equivalent = PIPE_FORMAT_NONE,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_R32G32_SNORM] = {
      .format = PIPE_FORMAT_R32G32_SNORM,
      .name = "PIPE_FORMAT_R32G32_SNORM",
      .short_name = "r32g32_snorm",
      .block = {1, 1, 1, 64},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_PLAIN,
      .nr_channels = 2,	/* nr_channels */
      .is_array = true,	/* is_array */
      .is_bitmask = false,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = false,	/* is_unorm */
      .is_snorm = true,	/* is_snorm */
#if UTIL_ARCH_BIG_ENDIAN
   {
      {UTIL_FORMAT_TYPE_SIGNED, true, false, 32, 32},	/* x = r */
      {UTIL_FORMAT_TYPE_SIGNED, true, false, 32, 0},	/* y = g */
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0}
   },
#else
   {
      {UTIL_FORMAT_TYPE_SIGNED, true, false, 32, 0},	/* x = r */
      {UTIL_FORMAT_TYPE_SIGNED, true, false, 32, 32},	/* y = g */
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0}
   },
#endif
#if UTIL_ARCH_BIG_ENDIAN
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_Y,	/* g */
      PIPE_SWIZZLE_0,	/* b */
      PIPE_SWIZZLE_1	/* a */
   },
#else
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_Y,	/* g */
      PIPE_SWIZZLE_0,	/* b */
      PIPE_SWIZZLE_1	/* a */
   },
#endif
      .colorspace = UTIL_FORMAT_COLORSPACE_RGB,
      .srgb_equivalent = PIPE_FORMAT_NONE,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_R32G32B32_SNORM] = {
      .format = PIPE_FORMAT_R32G32B32_SNORM,
      .name = "PIPE_FORMAT_R32G32B32_SNORM",
      .short_name = "r32g32b32_snorm",
      .block = {1, 1, 1, 96},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_PLAIN,
      .nr_channels = 3,	/* nr_channels */
      .is_array = true,	/* is_array */
      .is_bitmask = false,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = false,	/* is_unorm */
      .is_snorm = true,	/* is_snorm */
#if UTIL_ARCH_BIG_ENDIAN
   {
      {UTIL_FORMAT_TYPE_SIGNED, true, false, 32, 64},	/* x = r */
      {UTIL_FORMAT_TYPE_SIGNED, true, false, 32, 32},	/* y = g */
      {UTIL_FORMAT_TYPE_SIGNED, true, false, 32, 0},	/* z = b */
      {0, 0, 0, 0, 0}
   },
#else
   {
      {UTIL_FORMAT_TYPE_SIGNED, true, false, 32, 0},	/* x = r */
      {UTIL_FORMAT_TYPE_SIGNED, true, false, 32, 32},	/* y = g */
      {UTIL_FORMAT_TYPE_SIGNED, true, false, 32, 64},	/* z = b */
      {0, 0, 0, 0, 0}
   },
#endif
#if UTIL_ARCH_BIG_ENDIAN
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_Y,	/* g */
      PIPE_SWIZZLE_Z,	/* b */
      PIPE_SWIZZLE_1	/* a */
   },
#else
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_Y,	/* g */
      PIPE_SWIZZLE_Z,	/* b */
      PIPE_SWIZZLE_1	/* a */
   },
#endif
      .colorspace = UTIL_FORMAT_COLORSPACE_RGB,
      .srgb_equivalent = PIPE_FORMAT_NONE,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_R32G32B32A32_SNORM] = {
      .format = PIPE_FORMAT_R32G32B32A32_SNORM,
      .name = "PIPE_FORMAT_R32G32B32A32_SNORM",
      .short_name = "r32g32b32a32_snorm",
      .block = {1, 1, 1, 128},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_PLAIN,
      .nr_channels = 4,	/* nr_channels */
      .is_array = true,	/* is_array */
      .is_bitmask = false,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = false,	/* is_unorm */
      .is_snorm = true,	/* is_snorm */
#if UTIL_ARCH_BIG_ENDIAN
   {
      {UTIL_FORMAT_TYPE_SIGNED, true, false, 32, 96},	/* x = r */
      {UTIL_FORMAT_TYPE_SIGNED, true, false, 32, 64},	/* y = g */
      {UTIL_FORMAT_TYPE_SIGNED, true, false, 32, 32},	/* z = b */
      {UTIL_FORMAT_TYPE_SIGNED, true, false, 32, 0}	/* w = a */
   },
#else
   {
      {UTIL_FORMAT_TYPE_SIGNED, true, false, 32, 0},	/* x = r */
      {UTIL_FORMAT_TYPE_SIGNED, true, false, 32, 32},	/* y = g */
      {UTIL_FORMAT_TYPE_SIGNED, true, false, 32, 64},	/* z = b */
      {UTIL_FORMAT_TYPE_SIGNED, true, false, 32, 96}	/* w = a */
   },
#endif
#if UTIL_ARCH_BIG_ENDIAN
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_Y,	/* g */
      PIPE_SWIZZLE_Z,	/* b */
      PIPE_SWIZZLE_W	/* a */
   },
#else
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_Y,	/* g */
      PIPE_SWIZZLE_Z,	/* b */
      PIPE_SWIZZLE_W	/* a */
   },
#endif
      .colorspace = UTIL_FORMAT_COLORSPACE_RGB,
      .srgb_equivalent = PIPE_FORMAT_NONE,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_R32_SSCALED] = {
      .format = PIPE_FORMAT_R32_SSCALED,
      .name = "PIPE_FORMAT_R32_SSCALED",
      .short_name = "r32_sscaled",
      .block = {1, 1, 1, 32},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_PLAIN,
      .nr_channels = 1,	/* nr_channels */
      .is_array = true,	/* is_array */
      .is_bitmask = true,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = false,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
   {
      {UTIL_FORMAT_TYPE_SIGNED, false, false, 32, 0},	/* x = r */
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0}
   },
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_0,	/* g */
      PIPE_SWIZZLE_0,	/* b */
      PIPE_SWIZZLE_1	/* a */
   },
      .colorspace = UTIL_FORMAT_COLORSPACE_RGB,
      .srgb_equivalent = PIPE_FORMAT_NONE,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_R32G32_SSCALED] = {
      .format = PIPE_FORMAT_R32G32_SSCALED,
      .name = "PIPE_FORMAT_R32G32_SSCALED",
      .short_name = "r32g32_sscaled",
      .block = {1, 1, 1, 64},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_PLAIN,
      .nr_channels = 2,	/* nr_channels */
      .is_array = true,	/* is_array */
      .is_bitmask = false,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = false,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
#if UTIL_ARCH_BIG_ENDIAN
   {
      {UTIL_FORMAT_TYPE_SIGNED, false, false, 32, 32},	/* x = r */
      {UTIL_FORMAT_TYPE_SIGNED, false, false, 32, 0},	/* y = g */
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0}
   },
#else
   {
      {UTIL_FORMAT_TYPE_SIGNED, false, false, 32, 0},	/* x = r */
      {UTIL_FORMAT_TYPE_SIGNED, false, false, 32, 32},	/* y = g */
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0}
   },
#endif
#if UTIL_ARCH_BIG_ENDIAN
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_Y,	/* g */
      PIPE_SWIZZLE_0,	/* b */
      PIPE_SWIZZLE_1	/* a */
   },
#else
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_Y,	/* g */
      PIPE_SWIZZLE_0,	/* b */
      PIPE_SWIZZLE_1	/* a */
   },
#endif
      .colorspace = UTIL_FORMAT_COLORSPACE_RGB,
      .srgb_equivalent = PIPE_FORMAT_NONE,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_R32G32B32_SSCALED] = {
      .format = PIPE_FORMAT_R32G32B32_SSCALED,
      .name = "PIPE_FORMAT_R32G32B32_SSCALED",
      .short_name = "r32g32b32_sscaled",
      .block = {1, 1, 1, 96},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_PLAIN,
      .nr_channels = 3,	/* nr_channels */
      .is_array = true,	/* is_array */
      .is_bitmask = false,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = false,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
#if UTIL_ARCH_BIG_ENDIAN
   {
      {UTIL_FORMAT_TYPE_SIGNED, false, false, 32, 64},	/* x = r */
      {UTIL_FORMAT_TYPE_SIGNED, false, false, 32, 32},	/* y = g */
      {UTIL_FORMAT_TYPE_SIGNED, false, false, 32, 0},	/* z = b */
      {0, 0, 0, 0, 0}
   },
#else
   {
      {UTIL_FORMAT_TYPE_SIGNED, false, false, 32, 0},	/* x = r */
      {UTIL_FORMAT_TYPE_SIGNED, false, false, 32, 32},	/* y = g */
      {UTIL_FORMAT_TYPE_SIGNED, false, false, 32, 64},	/* z = b */
      {0, 0, 0, 0, 0}
   },
#endif
#if UTIL_ARCH_BIG_ENDIAN
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_Y,	/* g */
      PIPE_SWIZZLE_Z,	/* b */
      PIPE_SWIZZLE_1	/* a */
   },
#else
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_Y,	/* g */
      PIPE_SWIZZLE_Z,	/* b */
      PIPE_SWIZZLE_1	/* a */
   },
#endif
      .colorspace = UTIL_FORMAT_COLORSPACE_RGB,
      .srgb_equivalent = PIPE_FORMAT_NONE,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_R32G32B32A32_SSCALED] = {
      .format = PIPE_FORMAT_R32G32B32A32_SSCALED,
      .name = "PIPE_FORMAT_R32G32B32A32_SSCALED",
      .short_name = "r32g32b32a32_sscaled",
      .block = {1, 1, 1, 128},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_PLAIN,
      .nr_channels = 4,	/* nr_channels */
      .is_array = true,	/* is_array */
      .is_bitmask = false,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = false,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
#if UTIL_ARCH_BIG_ENDIAN
   {
      {UTIL_FORMAT_TYPE_SIGNED, false, false, 32, 96},	/* x = r */
      {UTIL_FORMAT_TYPE_SIGNED, false, false, 32, 64},	/* y = g */
      {UTIL_FORMAT_TYPE_SIGNED, false, false, 32, 32},	/* z = b */
      {UTIL_FORMAT_TYPE_SIGNED, false, false, 32, 0}	/* w = a */
   },
#else
   {
      {UTIL_FORMAT_TYPE_SIGNED, false, false, 32, 0},	/* x = r */
      {UTIL_FORMAT_TYPE_SIGNED, false, false, 32, 32},	/* y = g */
      {UTIL_FORMAT_TYPE_SIGNED, false, false, 32, 64},	/* z = b */
      {UTIL_FORMAT_TYPE_SIGNED, false, false, 32, 96}	/* w = a */
   },
#endif
#if UTIL_ARCH_BIG_ENDIAN
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_Y,	/* g */
      PIPE_SWIZZLE_Z,	/* b */
      PIPE_SWIZZLE_W	/* a */
   },
#else
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_Y,	/* g */
      PIPE_SWIZZLE_Z,	/* b */
      PIPE_SWIZZLE_W	/* a */
   },
#endif
      .colorspace = UTIL_FORMAT_COLORSPACE_RGB,
      .srgb_equivalent = PIPE_FORMAT_NONE,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_R16_FLOAT] = {
      .format = PIPE_FORMAT_R16_FLOAT,
      .name = "PIPE_FORMAT_R16_FLOAT",
      .short_name = "r16_float",
      .block = {1, 1, 1, 16},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_PLAIN,
      .nr_channels = 1,	/* nr_channels */
      .is_array = true,	/* is_array */
      .is_bitmask = false,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = false,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
   {
      {UTIL_FORMAT_TYPE_FLOAT, false, false, 16, 0},	/* x = r */
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0}
   },
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_0,	/* g */
      PIPE_SWIZZLE_0,	/* b */
      PIPE_SWIZZLE_1	/* a */
   },
      .colorspace = UTIL_FORMAT_COLORSPACE_RGB,
      .srgb_equivalent = PIPE_FORMAT_NONE,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_R16G16_FLOAT] = {
      .format = PIPE_FORMAT_R16G16_FLOAT,
      .name = "PIPE_FORMAT_R16G16_FLOAT",
      .short_name = "r16g16_float",
      .block = {1, 1, 1, 32},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_PLAIN,
      .nr_channels = 2,	/* nr_channels */
      .is_array = true,	/* is_array */
      .is_bitmask = false,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = false,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
#if UTIL_ARCH_BIG_ENDIAN
   {
      {UTIL_FORMAT_TYPE_FLOAT, false, false, 16, 16},	/* x = r */
      {UTIL_FORMAT_TYPE_FLOAT, false, false, 16, 0},	/* y = g */
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0}
   },
#else
   {
      {UTIL_FORMAT_TYPE_FLOAT, false, false, 16, 0},	/* x = r */
      {UTIL_FORMAT_TYPE_FLOAT, false, false, 16, 16},	/* y = g */
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0}
   },
#endif
#if UTIL_ARCH_BIG_ENDIAN
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_Y,	/* g */
      PIPE_SWIZZLE_0,	/* b */
      PIPE_SWIZZLE_1	/* a */
   },
#else
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_Y,	/* g */
      PIPE_SWIZZLE_0,	/* b */
      PIPE_SWIZZLE_1	/* a */
   },
#endif
      .colorspace = UTIL_FORMAT_COLORSPACE_RGB,
      .srgb_equivalent = PIPE_FORMAT_NONE,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_R16G16B16_FLOAT] = {
      .format = PIPE_FORMAT_R16G16B16_FLOAT,
      .name = "PIPE_FORMAT_R16G16B16_FLOAT",
      .short_name = "r16g16b16_float",
      .block = {1, 1, 1, 48},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_PLAIN,
      .nr_channels = 3,	/* nr_channels */
      .is_array = true,	/* is_array */
      .is_bitmask = false,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = false,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
#if UTIL_ARCH_BIG_ENDIAN
   {
      {UTIL_FORMAT_TYPE_FLOAT, false, false, 16, 32},	/* x = r */
      {UTIL_FORMAT_TYPE_FLOAT, false, false, 16, 16},	/* y = g */
      {UTIL_FORMAT_TYPE_FLOAT, false, false, 16, 0},	/* z = b */
      {0, 0, 0, 0, 0}
   },
#else
   {
      {UTIL_FORMAT_TYPE_FLOAT, false, false, 16, 0},	/* x = r */
      {UTIL_FORMAT_TYPE_FLOAT, false, false, 16, 16},	/* y = g */
      {UTIL_FORMAT_TYPE_FLOAT, false, false, 16, 32},	/* z = b */
      {0, 0, 0, 0, 0}
   },
#endif
#if UTIL_ARCH_BIG_ENDIAN
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_Y,	/* g */
      PIPE_SWIZZLE_Z,	/* b */
      PIPE_SWIZZLE_1	/* a */
   },
#else
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_Y,	/* g */
      PIPE_SWIZZLE_Z,	/* b */
      PIPE_SWIZZLE_1	/* a */
   },
#endif
      .colorspace = UTIL_FORMAT_COLORSPACE_RGB,
      .srgb_equivalent = PIPE_FORMAT_NONE,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_R16G16B16A16_FLOAT] = {
      .format = PIPE_FORMAT_R16G16B16A16_FLOAT,
      .name = "PIPE_FORMAT_R16G16B16A16_FLOAT",
      .short_name = "r16g16b16a16_float",
      .block = {1, 1, 1, 64},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_PLAIN,
      .nr_channels = 4,	/* nr_channels */
      .is_array = true,	/* is_array */
      .is_bitmask = false,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = false,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
#if UTIL_ARCH_BIG_ENDIAN
   {
      {UTIL_FORMAT_TYPE_FLOAT, false, false, 16, 48},	/* x = r */
      {UTIL_FORMAT_TYPE_FLOAT, false, false, 16, 32},	/* y = g */
      {UTIL_FORMAT_TYPE_FLOAT, false, false, 16, 16},	/* z = b */
      {UTIL_FORMAT_TYPE_FLOAT, false, false, 16, 0}	/* w = a */
   },
#else
   {
      {UTIL_FORMAT_TYPE_FLOAT, false, false, 16, 0},	/* x = r */
      {UTIL_FORMAT_TYPE_FLOAT, false, false, 16, 16},	/* y = g */
      {UTIL_FORMAT_TYPE_FLOAT, false, false, 16, 32},	/* z = b */
      {UTIL_FORMAT_TYPE_FLOAT, false, false, 16, 48}	/* w = a */
   },
#endif
#if UTIL_ARCH_BIG_ENDIAN
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_Y,	/* g */
      PIPE_SWIZZLE_Z,	/* b */
      PIPE_SWIZZLE_W	/* a */
   },
#else
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_Y,	/* g */
      PIPE_SWIZZLE_Z,	/* b */
      PIPE_SWIZZLE_W	/* a */
   },
#endif
      .colorspace = UTIL_FORMAT_COLORSPACE_RGB,
      .srgb_equivalent = PIPE_FORMAT_NONE,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_R16_UNORM] = {
      .format = PIPE_FORMAT_R16_UNORM,
      .name = "PIPE_FORMAT_R16_UNORM",
      .short_name = "r16_unorm",
      .block = {1, 1, 1, 16},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_PLAIN,
      .nr_channels = 1,	/* nr_channels */
      .is_array = true,	/* is_array */
      .is_bitmask = true,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = true,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
   {
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 16, 0},	/* x = r */
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0}
   },
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_0,	/* g */
      PIPE_SWIZZLE_0,	/* b */
      PIPE_SWIZZLE_1	/* a */
   },
      .colorspace = UTIL_FORMAT_COLORSPACE_RGB,
      .srgb_equivalent = PIPE_FORMAT_NONE,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_R16G16_UNORM] = {
      .format = PIPE_FORMAT_R16G16_UNORM,
      .name = "PIPE_FORMAT_R16G16_UNORM",
      .short_name = "r16g16_unorm",
      .block = {1, 1, 1, 32},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_PLAIN,
      .nr_channels = 2,	/* nr_channels */
      .is_array = true,	/* is_array */
      .is_bitmask = true,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = true,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
#if UTIL_ARCH_BIG_ENDIAN
   {
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 16, 16},	/* x = r */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 16, 0},	/* y = g */
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0}
   },
#else
   {
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 16, 0},	/* x = r */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 16, 16},	/* y = g */
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0}
   },
#endif
#if UTIL_ARCH_BIG_ENDIAN
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_Y,	/* g */
      PIPE_SWIZZLE_0,	/* b */
      PIPE_SWIZZLE_1	/* a */
   },
#else
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_Y,	/* g */
      PIPE_SWIZZLE_0,	/* b */
      PIPE_SWIZZLE_1	/* a */
   },
#endif
      .colorspace = UTIL_FORMAT_COLORSPACE_RGB,
      .srgb_equivalent = PIPE_FORMAT_NONE,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_R16G16B16_UNORM] = {
      .format = PIPE_FORMAT_R16G16B16_UNORM,
      .name = "PIPE_FORMAT_R16G16B16_UNORM",
      .short_name = "r16g16b16_unorm",
      .block = {1, 1, 1, 48},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_PLAIN,
      .nr_channels = 3,	/* nr_channels */
      .is_array = true,	/* is_array */
      .is_bitmask = false,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = true,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
#if UTIL_ARCH_BIG_ENDIAN
   {
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 16, 32},	/* x = r */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 16, 16},	/* y = g */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 16, 0},	/* z = b */
      {0, 0, 0, 0, 0}
   },
#else
   {
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 16, 0},	/* x = r */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 16, 16},	/* y = g */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 16, 32},	/* z = b */
      {0, 0, 0, 0, 0}
   },
#endif
#if UTIL_ARCH_BIG_ENDIAN
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_Y,	/* g */
      PIPE_SWIZZLE_Z,	/* b */
      PIPE_SWIZZLE_1	/* a */
   },
#else
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_Y,	/* g */
      PIPE_SWIZZLE_Z,	/* b */
      PIPE_SWIZZLE_1	/* a */
   },
#endif
      .colorspace = UTIL_FORMAT_COLORSPACE_RGB,
      .srgb_equivalent = PIPE_FORMAT_NONE,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_R16G16B16A16_UNORM] = {
      .format = PIPE_FORMAT_R16G16B16A16_UNORM,
      .name = "PIPE_FORMAT_R16G16B16A16_UNORM",
      .short_name = "r16g16b16a16_unorm",
      .block = {1, 1, 1, 64},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_PLAIN,
      .nr_channels = 4,	/* nr_channels */
      .is_array = true,	/* is_array */
      .is_bitmask = false,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = true,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
#if UTIL_ARCH_BIG_ENDIAN
   {
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 16, 48},	/* x = r */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 16, 32},	/* y = g */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 16, 16},	/* z = b */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 16, 0}	/* w = a */
   },
#else
   {
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 16, 0},	/* x = r */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 16, 16},	/* y = g */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 16, 32},	/* z = b */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 16, 48}	/* w = a */
   },
#endif
#if UTIL_ARCH_BIG_ENDIAN
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_Y,	/* g */
      PIPE_SWIZZLE_Z,	/* b */
      PIPE_SWIZZLE_W	/* a */
   },
#else
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_Y,	/* g */
      PIPE_SWIZZLE_Z,	/* b */
      PIPE_SWIZZLE_W	/* a */
   },
#endif
      .colorspace = UTIL_FORMAT_COLORSPACE_RGB,
      .srgb_equivalent = PIPE_FORMAT_NONE,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_R16_USCALED] = {
      .format = PIPE_FORMAT_R16_USCALED,
      .name = "PIPE_FORMAT_R16_USCALED",
      .short_name = "r16_uscaled",
      .block = {1, 1, 1, 16},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_PLAIN,
      .nr_channels = 1,	/* nr_channels */
      .is_array = true,	/* is_array */
      .is_bitmask = true,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = false,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
   {
      {UTIL_FORMAT_TYPE_UNSIGNED, false, false, 16, 0},	/* x = r */
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0}
   },
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_0,	/* g */
      PIPE_SWIZZLE_0,	/* b */
      PIPE_SWIZZLE_1	/* a */
   },
      .colorspace = UTIL_FORMAT_COLORSPACE_RGB,
      .srgb_equivalent = PIPE_FORMAT_NONE,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_R16G16_USCALED] = {
      .format = PIPE_FORMAT_R16G16_USCALED,
      .name = "PIPE_FORMAT_R16G16_USCALED",
      .short_name = "r16g16_uscaled",
      .block = {1, 1, 1, 32},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_PLAIN,
      .nr_channels = 2,	/* nr_channels */
      .is_array = true,	/* is_array */
      .is_bitmask = true,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = false,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
#if UTIL_ARCH_BIG_ENDIAN
   {
      {UTIL_FORMAT_TYPE_UNSIGNED, false, false, 16, 16},	/* x = r */
      {UTIL_FORMAT_TYPE_UNSIGNED, false, false, 16, 0},	/* y = g */
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0}
   },
#else
   {
      {UTIL_FORMAT_TYPE_UNSIGNED, false, false, 16, 0},	/* x = r */
      {UTIL_FORMAT_TYPE_UNSIGNED, false, false, 16, 16},	/* y = g */
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0}
   },
#endif
#if UTIL_ARCH_BIG_ENDIAN
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_Y,	/* g */
      PIPE_SWIZZLE_0,	/* b */
      PIPE_SWIZZLE_1	/* a */
   },
#else
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_Y,	/* g */
      PIPE_SWIZZLE_0,	/* b */
      PIPE_SWIZZLE_1	/* a */
   },
#endif
      .colorspace = UTIL_FORMAT_COLORSPACE_RGB,
      .srgb_equivalent = PIPE_FORMAT_NONE,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_R16G16B16_USCALED] = {
      .format = PIPE_FORMAT_R16G16B16_USCALED,
      .name = "PIPE_FORMAT_R16G16B16_USCALED",
      .short_name = "r16g16b16_uscaled",
      .block = {1, 1, 1, 48},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_PLAIN,
      .nr_channels = 3,	/* nr_channels */
      .is_array = true,	/* is_array */
      .is_bitmask = false,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = false,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
#if UTIL_ARCH_BIG_ENDIAN
   {
      {UTIL_FORMAT_TYPE_UNSIGNED, false, false, 16, 32},	/* x = r */
      {UTIL_FORMAT_TYPE_UNSIGNED, false, false, 16, 16},	/* y = g */
      {UTIL_FORMAT_TYPE_UNSIGNED, false, false, 16, 0},	/* z = b */
      {0, 0, 0, 0, 0}
   },
#else
   {
      {UTIL_FORMAT_TYPE_UNSIGNED, false, false, 16, 0},	/* x = r */
      {UTIL_FORMAT_TYPE_UNSIGNED, false, false, 16, 16},	/* y = g */
      {UTIL_FORMAT_TYPE_UNSIGNED, false, false, 16, 32},	/* z = b */
      {0, 0, 0, 0, 0}
   },
#endif
#if UTIL_ARCH_BIG_ENDIAN
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_Y,	/* g */
      PIPE_SWIZZLE_Z,	/* b */
      PIPE_SWIZZLE_1	/* a */
   },
#else
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_Y,	/* g */
      PIPE_SWIZZLE_Z,	/* b */
      PIPE_SWIZZLE_1	/* a */
   },
#endif
      .colorspace = UTIL_FORMAT_COLORSPACE_RGB,
      .srgb_equivalent = PIPE_FORMAT_NONE,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_R16G16B16A16_USCALED] = {
      .format = PIPE_FORMAT_R16G16B16A16_USCALED,
      .name = "PIPE_FORMAT_R16G16B16A16_USCALED",
      .short_name = "r16g16b16a16_uscaled",
      .block = {1, 1, 1, 64},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_PLAIN,
      .nr_channels = 4,	/* nr_channels */
      .is_array = true,	/* is_array */
      .is_bitmask = false,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = false,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
#if UTIL_ARCH_BIG_ENDIAN
   {
      {UTIL_FORMAT_TYPE_UNSIGNED, false, false, 16, 48},	/* x = r */
      {UTIL_FORMAT_TYPE_UNSIGNED, false, false, 16, 32},	/* y = g */
      {UTIL_FORMAT_TYPE_UNSIGNED, false, false, 16, 16},	/* z = b */
      {UTIL_FORMAT_TYPE_UNSIGNED, false, false, 16, 0}	/* w = a */
   },
#else
   {
      {UTIL_FORMAT_TYPE_UNSIGNED, false, false, 16, 0},	/* x = r */
      {UTIL_FORMAT_TYPE_UNSIGNED, false, false, 16, 16},	/* y = g */
      {UTIL_FORMAT_TYPE_UNSIGNED, false, false, 16, 32},	/* z = b */
      {UTIL_FORMAT_TYPE_UNSIGNED, false, false, 16, 48}	/* w = a */
   },
#endif
#if UTIL_ARCH_BIG_ENDIAN
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_Y,	/* g */
      PIPE_SWIZZLE_Z,	/* b */
      PIPE_SWIZZLE_W	/* a */
   },
#else
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_Y,	/* g */
      PIPE_SWIZZLE_Z,	/* b */
      PIPE_SWIZZLE_W	/* a */
   },
#endif
      .colorspace = UTIL_FORMAT_COLORSPACE_RGB,
      .srgb_equivalent = PIPE_FORMAT_NONE,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_R16_SNORM] = {
      .format = PIPE_FORMAT_R16_SNORM,
      .name = "PIPE_FORMAT_R16_SNORM",
      .short_name = "r16_snorm",
      .block = {1, 1, 1, 16},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_PLAIN,
      .nr_channels = 1,	/* nr_channels */
      .is_array = true,	/* is_array */
      .is_bitmask = true,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = false,	/* is_unorm */
      .is_snorm = true,	/* is_snorm */
   {
      {UTIL_FORMAT_TYPE_SIGNED, true, false, 16, 0},	/* x = r */
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0}
   },
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_0,	/* g */
      PIPE_SWIZZLE_0,	/* b */
      PIPE_SWIZZLE_1	/* a */
   },
      .colorspace = UTIL_FORMAT_COLORSPACE_RGB,
      .srgb_equivalent = PIPE_FORMAT_NONE,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_R16G16_SNORM] = {
      .format = PIPE_FORMAT_R16G16_SNORM,
      .name = "PIPE_FORMAT_R16G16_SNORM",
      .short_name = "r16g16_snorm",
      .block = {1, 1, 1, 32},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_PLAIN,
      .nr_channels = 2,	/* nr_channels */
      .is_array = true,	/* is_array */
      .is_bitmask = true,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = false,	/* is_unorm */
      .is_snorm = true,	/* is_snorm */
#if UTIL_ARCH_BIG_ENDIAN
   {
      {UTIL_FORMAT_TYPE_SIGNED, true, false, 16, 16},	/* x = r */
      {UTIL_FORMAT_TYPE_SIGNED, true, false, 16, 0},	/* y = g */
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0}
   },
#else
   {
      {UTIL_FORMAT_TYPE_SIGNED, true, false, 16, 0},	/* x = r */
      {UTIL_FORMAT_TYPE_SIGNED, true, false, 16, 16},	/* y = g */
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0}
   },
#endif
#if UTIL_ARCH_BIG_ENDIAN
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_Y,	/* g */
      PIPE_SWIZZLE_0,	/* b */
      PIPE_SWIZZLE_1	/* a */
   },
#else
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_Y,	/* g */
      PIPE_SWIZZLE_0,	/* b */
      PIPE_SWIZZLE_1	/* a */
   },
#endif
      .colorspace = UTIL_FORMAT_COLORSPACE_RGB,
      .srgb_equivalent = PIPE_FORMAT_NONE,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_R16G16B16_SNORM] = {
      .format = PIPE_FORMAT_R16G16B16_SNORM,
      .name = "PIPE_FORMAT_R16G16B16_SNORM",
      .short_name = "r16g16b16_snorm",
      .block = {1, 1, 1, 48},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_PLAIN,
      .nr_channels = 3,	/* nr_channels */
      .is_array = true,	/* is_array */
      .is_bitmask = false,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = false,	/* is_unorm */
      .is_snorm = true,	/* is_snorm */
#if UTIL_ARCH_BIG_ENDIAN
   {
      {UTIL_FORMAT_TYPE_SIGNED, true, false, 16, 32},	/* x = r */
      {UTIL_FORMAT_TYPE_SIGNED, true, false, 16, 16},	/* y = g */
      {UTIL_FORMAT_TYPE_SIGNED, true, false, 16, 0},	/* z = b */
      {0, 0, 0, 0, 0}
   },
#else
   {
      {UTIL_FORMAT_TYPE_SIGNED, true, false, 16, 0},	/* x = r */
      {UTIL_FORMAT_TYPE_SIGNED, true, false, 16, 16},	/* y = g */
      {UTIL_FORMAT_TYPE_SIGNED, true, false, 16, 32},	/* z = b */
      {0, 0, 0, 0, 0}
   },
#endif
#if UTIL_ARCH_BIG_ENDIAN
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_Y,	/* g */
      PIPE_SWIZZLE_Z,	/* b */
      PIPE_SWIZZLE_1	/* a */
   },
#else
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_Y,	/* g */
      PIPE_SWIZZLE_Z,	/* b */
      PIPE_SWIZZLE_1	/* a */
   },
#endif
      .colorspace = UTIL_FORMAT_COLORSPACE_RGB,
      .srgb_equivalent = PIPE_FORMAT_NONE,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_R16G16B16A16_SNORM] = {
      .format = PIPE_FORMAT_R16G16B16A16_SNORM,
      .name = "PIPE_FORMAT_R16G16B16A16_SNORM",
      .short_name = "r16g16b16a16_snorm",
      .block = {1, 1, 1, 64},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_PLAIN,
      .nr_channels = 4,	/* nr_channels */
      .is_array = true,	/* is_array */
      .is_bitmask = false,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = false,	/* is_unorm */
      .is_snorm = true,	/* is_snorm */
#if UTIL_ARCH_BIG_ENDIAN
   {
      {UTIL_FORMAT_TYPE_SIGNED, true, false, 16, 48},	/* x = r */
      {UTIL_FORMAT_TYPE_SIGNED, true, false, 16, 32},	/* y = g */
      {UTIL_FORMAT_TYPE_SIGNED, true, false, 16, 16},	/* z = b */
      {UTIL_FORMAT_TYPE_SIGNED, true, false, 16, 0}	/* w = a */
   },
#else
   {
      {UTIL_FORMAT_TYPE_SIGNED, true, false, 16, 0},	/* x = r */
      {UTIL_FORMAT_TYPE_SIGNED, true, false, 16, 16},	/* y = g */
      {UTIL_FORMAT_TYPE_SIGNED, true, false, 16, 32},	/* z = b */
      {UTIL_FORMAT_TYPE_SIGNED, true, false, 16, 48}	/* w = a */
   },
#endif
#if UTIL_ARCH_BIG_ENDIAN
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_Y,	/* g */
      PIPE_SWIZZLE_Z,	/* b */
      PIPE_SWIZZLE_W	/* a */
   },
#else
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_Y,	/* g */
      PIPE_SWIZZLE_Z,	/* b */
      PIPE_SWIZZLE_W	/* a */
   },
#endif
      .colorspace = UTIL_FORMAT_COLORSPACE_RGB,
      .srgb_equivalent = PIPE_FORMAT_NONE,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_R16_SSCALED] = {
      .format = PIPE_FORMAT_R16_SSCALED,
      .name = "PIPE_FORMAT_R16_SSCALED",
      .short_name = "r16_sscaled",
      .block = {1, 1, 1, 16},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_PLAIN,
      .nr_channels = 1,	/* nr_channels */
      .is_array = true,	/* is_array */
      .is_bitmask = true,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = false,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
   {
      {UTIL_FORMAT_TYPE_SIGNED, false, false, 16, 0},	/* x = r */
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0}
   },
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_0,	/* g */
      PIPE_SWIZZLE_0,	/* b */
      PIPE_SWIZZLE_1	/* a */
   },
      .colorspace = UTIL_FORMAT_COLORSPACE_RGB,
      .srgb_equivalent = PIPE_FORMAT_NONE,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_R16G16_SSCALED] = {
      .format = PIPE_FORMAT_R16G16_SSCALED,
      .name = "PIPE_FORMAT_R16G16_SSCALED",
      .short_name = "r16g16_sscaled",
      .block = {1, 1, 1, 32},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_PLAIN,
      .nr_channels = 2,	/* nr_channels */
      .is_array = true,	/* is_array */
      .is_bitmask = true,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = false,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
#if UTIL_ARCH_BIG_ENDIAN
   {
      {UTIL_FORMAT_TYPE_SIGNED, false, false, 16, 16},	/* x = r */
      {UTIL_FORMAT_TYPE_SIGNED, false, false, 16, 0},	/* y = g */
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0}
   },
#else
   {
      {UTIL_FORMAT_TYPE_SIGNED, false, false, 16, 0},	/* x = r */
      {UTIL_FORMAT_TYPE_SIGNED, false, false, 16, 16},	/* y = g */
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0}
   },
#endif
#if UTIL_ARCH_BIG_ENDIAN
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_Y,	/* g */
      PIPE_SWIZZLE_0,	/* b */
      PIPE_SWIZZLE_1	/* a */
   },
#else
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_Y,	/* g */
      PIPE_SWIZZLE_0,	/* b */
      PIPE_SWIZZLE_1	/* a */
   },
#endif
      .colorspace = UTIL_FORMAT_COLORSPACE_RGB,
      .srgb_equivalent = PIPE_FORMAT_NONE,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_R16G16B16_SSCALED] = {
      .format = PIPE_FORMAT_R16G16B16_SSCALED,
      .name = "PIPE_FORMAT_R16G16B16_SSCALED",
      .short_name = "r16g16b16_sscaled",
      .block = {1, 1, 1, 48},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_PLAIN,
      .nr_channels = 3,	/* nr_channels */
      .is_array = true,	/* is_array */
      .is_bitmask = false,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = false,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
#if UTIL_ARCH_BIG_ENDIAN
   {
      {UTIL_FORMAT_TYPE_SIGNED, false, false, 16, 32},	/* x = r */
      {UTIL_FORMAT_TYPE_SIGNED, false, false, 16, 16},	/* y = g */
      {UTIL_FORMAT_TYPE_SIGNED, false, false, 16, 0},	/* z = b */
      {0, 0, 0, 0, 0}
   },
#else
   {
      {UTIL_FORMAT_TYPE_SIGNED, false, false, 16, 0},	/* x = r */
      {UTIL_FORMAT_TYPE_SIGNED, false, false, 16, 16},	/* y = g */
      {UTIL_FORMAT_TYPE_SIGNED, false, false, 16, 32},	/* z = b */
      {0, 0, 0, 0, 0}
   },
#endif
#if UTIL_ARCH_BIG_ENDIAN
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_Y,	/* g */
      PIPE_SWIZZLE_Z,	/* b */
      PIPE_SWIZZLE_1	/* a */
   },
#else
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_Y,	/* g */
      PIPE_SWIZZLE_Z,	/* b */
      PIPE_SWIZZLE_1	/* a */
   },
#endif
      .colorspace = UTIL_FORMAT_COLORSPACE_RGB,
      .srgb_equivalent = PIPE_FORMAT_NONE,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_R16G16B16A16_SSCALED] = {
      .format = PIPE_FORMAT_R16G16B16A16_SSCALED,
      .name = "PIPE_FORMAT_R16G16B16A16_SSCALED",
      .short_name = "r16g16b16a16_sscaled",
      .block = {1, 1, 1, 64},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_PLAIN,
      .nr_channels = 4,	/* nr_channels */
      .is_array = true,	/* is_array */
      .is_bitmask = false,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = false,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
#if UTIL_ARCH_BIG_ENDIAN
   {
      {UTIL_FORMAT_TYPE_SIGNED, false, false, 16, 48},	/* x = r */
      {UTIL_FORMAT_TYPE_SIGNED, false, false, 16, 32},	/* y = g */
      {UTIL_FORMAT_TYPE_SIGNED, false, false, 16, 16},	/* z = b */
      {UTIL_FORMAT_TYPE_SIGNED, false, false, 16, 0}	/* w = a */
   },
#else
   {
      {UTIL_FORMAT_TYPE_SIGNED, false, false, 16, 0},	/* x = r */
      {UTIL_FORMAT_TYPE_SIGNED, false, false, 16, 16},	/* y = g */
      {UTIL_FORMAT_TYPE_SIGNED, false, false, 16, 32},	/* z = b */
      {UTIL_FORMAT_TYPE_SIGNED, false, false, 16, 48}	/* w = a */
   },
#endif
#if UTIL_ARCH_BIG_ENDIAN
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_Y,	/* g */
      PIPE_SWIZZLE_Z,	/* b */
      PIPE_SWIZZLE_W	/* a */
   },
#else
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_Y,	/* g */
      PIPE_SWIZZLE_Z,	/* b */
      PIPE_SWIZZLE_W	/* a */
   },
#endif
      .colorspace = UTIL_FORMAT_COLORSPACE_RGB,
      .srgb_equivalent = PIPE_FORMAT_NONE,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_R8_UNORM] = {
      .format = PIPE_FORMAT_R8_UNORM,
      .name = "PIPE_FORMAT_R8_UNORM",
      .short_name = "r8_unorm",
      .block = {1, 1, 1, 8},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_PLAIN,
      .nr_channels = 1,	/* nr_channels */
      .is_array = true,	/* is_array */
      .is_bitmask = true,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = true,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
   {
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 8, 0},	/* x = r */
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0}
   },
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_0,	/* g */
      PIPE_SWIZZLE_0,	/* b */
      PIPE_SWIZZLE_1	/* a */
   },
      .colorspace = UTIL_FORMAT_COLORSPACE_RGB,
      .srgb_equivalent = PIPE_FORMAT_R8_SRGB,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_R8G8_UNORM] = {
      .format = PIPE_FORMAT_R8G8_UNORM,
      .name = "PIPE_FORMAT_R8G8_UNORM",
      .short_name = "r8g8_unorm",
      .block = {1, 1, 1, 16},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_PLAIN,
      .nr_channels = 2,	/* nr_channels */
      .is_array = true,	/* is_array */
      .is_bitmask = true,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = true,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
#if UTIL_ARCH_BIG_ENDIAN
   {
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 8, 8},	/* x = r */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 8, 0},	/* y = g */
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0}
   },
#else
   {
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 8, 0},	/* x = r */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 8, 8},	/* y = g */
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0}
   },
#endif
#if UTIL_ARCH_BIG_ENDIAN
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_Y,	/* g */
      PIPE_SWIZZLE_0,	/* b */
      PIPE_SWIZZLE_1	/* a */
   },
#else
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_Y,	/* g */
      PIPE_SWIZZLE_0,	/* b */
      PIPE_SWIZZLE_1	/* a */
   },
#endif
      .colorspace = UTIL_FORMAT_COLORSPACE_RGB,
      .srgb_equivalent = PIPE_FORMAT_R8G8_SRGB,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_R8G8B8_UNORM] = {
      .format = PIPE_FORMAT_R8G8B8_UNORM,
      .name = "PIPE_FORMAT_R8G8B8_UNORM",
      .short_name = "r8g8b8_unorm",
      .block = {1, 1, 1, 24},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_PLAIN,
      .nr_channels = 3,	/* nr_channels */
      .is_array = true,	/* is_array */
      .is_bitmask = false,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = true,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
#if UTIL_ARCH_BIG_ENDIAN
   {
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 8, 16},	/* x = r */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 8, 8},	/* y = g */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 8, 0},	/* z = b */
      {0, 0, 0, 0, 0}
   },
#else
   {
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 8, 0},	/* x = r */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 8, 8},	/* y = g */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 8, 16},	/* z = b */
      {0, 0, 0, 0, 0}
   },
#endif
#if UTIL_ARCH_BIG_ENDIAN
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_Y,	/* g */
      PIPE_SWIZZLE_Z,	/* b */
      PIPE_SWIZZLE_1	/* a */
   },
#else
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_Y,	/* g */
      PIPE_SWIZZLE_Z,	/* b */
      PIPE_SWIZZLE_1	/* a */
   },
#endif
      .colorspace = UTIL_FORMAT_COLORSPACE_RGB,
      .srgb_equivalent = PIPE_FORMAT_R8G8B8_SRGB,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_B8G8R8_UNORM] = {
      .format = PIPE_FORMAT_B8G8R8_UNORM,
      .name = "PIPE_FORMAT_B8G8R8_UNORM",
      .short_name = "b8g8r8_unorm",
      .block = {1, 1, 1, 24},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_PLAIN,
      .nr_channels = 3,	/* nr_channels */
      .is_array = true,	/* is_array */
      .is_bitmask = false,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = true,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
#if UTIL_ARCH_BIG_ENDIAN
   {
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 8, 16},	/* x = b */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 8, 8},	/* y = g */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 8, 0},	/* z = r */
      {0, 0, 0, 0, 0}
   },
#else
   {
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 8, 0},	/* x = b */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 8, 8},	/* y = g */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 8, 16},	/* z = r */
      {0, 0, 0, 0, 0}
   },
#endif
#if UTIL_ARCH_BIG_ENDIAN
   {
      PIPE_SWIZZLE_Z,	/* r */
      PIPE_SWIZZLE_Y,	/* g */
      PIPE_SWIZZLE_X,	/* b */
      PIPE_SWIZZLE_1	/* a */
   },
#else
   {
      PIPE_SWIZZLE_Z,	/* r */
      PIPE_SWIZZLE_Y,	/* g */
      PIPE_SWIZZLE_X,	/* b */
      PIPE_SWIZZLE_1	/* a */
   },
#endif
      .colorspace = UTIL_FORMAT_COLORSPACE_RGB,
      .srgb_equivalent = PIPE_FORMAT_B8G8R8_SRGB,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_R8G8B8A8_UNORM] = {
      .format = PIPE_FORMAT_R8G8B8A8_UNORM,
      .name = "PIPE_FORMAT_R8G8B8A8_UNORM",
      .short_name = "r8g8b8a8_unorm",
      .block = {1, 1, 1, 32},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_PLAIN,
      .nr_channels = 4,	/* nr_channels */
      .is_array = true,	/* is_array */
      .is_bitmask = true,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = true,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
#if UTIL_ARCH_BIG_ENDIAN
   {
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 8, 24},	/* x = r */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 8, 16},	/* y = g */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 8, 8},	/* z = b */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 8, 0}	/* w = a */
   },
#else
   {
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 8, 0},	/* x = r */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 8, 8},	/* y = g */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 8, 16},	/* z = b */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 8, 24}	/* w = a */
   },
#endif
#if UTIL_ARCH_BIG_ENDIAN
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_Y,	/* g */
      PIPE_SWIZZLE_Z,	/* b */
      PIPE_SWIZZLE_W	/* a */
   },
#else
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_Y,	/* g */
      PIPE_SWIZZLE_Z,	/* b */
      PIPE_SWIZZLE_W	/* a */
   },
#endif
      .colorspace = UTIL_FORMAT_COLORSPACE_RGB,
      .srgb_equivalent = PIPE_FORMAT_R8G8B8A8_SRGB,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_R8_USCALED] = {
      .format = PIPE_FORMAT_R8_USCALED,
      .name = "PIPE_FORMAT_R8_USCALED",
      .short_name = "r8_uscaled",
      .block = {1, 1, 1, 8},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_PLAIN,
      .nr_channels = 1,	/* nr_channels */
      .is_array = true,	/* is_array */
      .is_bitmask = true,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = false,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
   {
      {UTIL_FORMAT_TYPE_UNSIGNED, false, false, 8, 0},	/* x = r */
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0}
   },
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_0,	/* g */
      PIPE_SWIZZLE_0,	/* b */
      PIPE_SWIZZLE_1	/* a */
   },
      .colorspace = UTIL_FORMAT_COLORSPACE_RGB,
      .srgb_equivalent = PIPE_FORMAT_NONE,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_R8G8_USCALED] = {
      .format = PIPE_FORMAT_R8G8_USCALED,
      .name = "PIPE_FORMAT_R8G8_USCALED",
      .short_name = "r8g8_uscaled",
      .block = {1, 1, 1, 16},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_PLAIN,
      .nr_channels = 2,	/* nr_channels */
      .is_array = true,	/* is_array */
      .is_bitmask = true,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = false,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
#if UTIL_ARCH_BIG_ENDIAN
   {
      {UTIL_FORMAT_TYPE_UNSIGNED, false, false, 8, 8},	/* x = r */
      {UTIL_FORMAT_TYPE_UNSIGNED, false, false, 8, 0},	/* y = g */
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0}
   },
#else
   {
      {UTIL_FORMAT_TYPE_UNSIGNED, false, false, 8, 0},	/* x = r */
      {UTIL_FORMAT_TYPE_UNSIGNED, false, false, 8, 8},	/* y = g */
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0}
   },
#endif
#if UTIL_ARCH_BIG_ENDIAN
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_Y,	/* g */
      PIPE_SWIZZLE_0,	/* b */
      PIPE_SWIZZLE_1	/* a */
   },
#else
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_Y,	/* g */
      PIPE_SWIZZLE_0,	/* b */
      PIPE_SWIZZLE_1	/* a */
   },
#endif
      .colorspace = UTIL_FORMAT_COLORSPACE_RGB,
      .srgb_equivalent = PIPE_FORMAT_NONE,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_R8G8B8_USCALED] = {
      .format = PIPE_FORMAT_R8G8B8_USCALED,
      .name = "PIPE_FORMAT_R8G8B8_USCALED",
      .short_name = "r8g8b8_uscaled",
      .block = {1, 1, 1, 24},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_PLAIN,
      .nr_channels = 3,	/* nr_channels */
      .is_array = true,	/* is_array */
      .is_bitmask = false,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = false,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
#if UTIL_ARCH_BIG_ENDIAN
   {
      {UTIL_FORMAT_TYPE_UNSIGNED, false, false, 8, 16},	/* x = r */
      {UTIL_FORMAT_TYPE_UNSIGNED, false, false, 8, 8},	/* y = g */
      {UTIL_FORMAT_TYPE_UNSIGNED, false, false, 8, 0},	/* z = b */
      {0, 0, 0, 0, 0}
   },
#else
   {
      {UTIL_FORMAT_TYPE_UNSIGNED, false, false, 8, 0},	/* x = r */
      {UTIL_FORMAT_TYPE_UNSIGNED, false, false, 8, 8},	/* y = g */
      {UTIL_FORMAT_TYPE_UNSIGNED, false, false, 8, 16},	/* z = b */
      {0, 0, 0, 0, 0}
   },
#endif
#if UTIL_ARCH_BIG_ENDIAN
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_Y,	/* g */
      PIPE_SWIZZLE_Z,	/* b */
      PIPE_SWIZZLE_1	/* a */
   },
#else
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_Y,	/* g */
      PIPE_SWIZZLE_Z,	/* b */
      PIPE_SWIZZLE_1	/* a */
   },
#endif
      .colorspace = UTIL_FORMAT_COLORSPACE_RGB,
      .srgb_equivalent = PIPE_FORMAT_NONE,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_B8G8R8_USCALED] = {
      .format = PIPE_FORMAT_B8G8R8_USCALED,
      .name = "PIPE_FORMAT_B8G8R8_USCALED",
      .short_name = "b8g8r8_uscaled",
      .block = {1, 1, 1, 24},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_PLAIN,
      .nr_channels = 3,	/* nr_channels */
      .is_array = true,	/* is_array */
      .is_bitmask = false,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = false,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
#if UTIL_ARCH_BIG_ENDIAN
   {
      {UTIL_FORMAT_TYPE_UNSIGNED, false, false, 8, 16},	/* x = b */
      {UTIL_FORMAT_TYPE_UNSIGNED, false, false, 8, 8},	/* y = g */
      {UTIL_FORMAT_TYPE_UNSIGNED, false, false, 8, 0},	/* z = r */
      {0, 0, 0, 0, 0}
   },
#else
   {
      {UTIL_FORMAT_TYPE_UNSIGNED, false, false, 8, 0},	/* x = b */
      {UTIL_FORMAT_TYPE_UNSIGNED, false, false, 8, 8},	/* y = g */
      {UTIL_FORMAT_TYPE_UNSIGNED, false, false, 8, 16},	/* z = r */
      {0, 0, 0, 0, 0}
   },
#endif
#if UTIL_ARCH_BIG_ENDIAN
   {
      PIPE_SWIZZLE_Z,	/* r */
      PIPE_SWIZZLE_Y,	/* g */
      PIPE_SWIZZLE_X,	/* b */
      PIPE_SWIZZLE_1	/* a */
   },
#else
   {
      PIPE_SWIZZLE_Z,	/* r */
      PIPE_SWIZZLE_Y,	/* g */
      PIPE_SWIZZLE_X,	/* b */
      PIPE_SWIZZLE_1	/* a */
   },
#endif
      .colorspace = UTIL_FORMAT_COLORSPACE_RGB,
      .srgb_equivalent = PIPE_FORMAT_NONE,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_R8G8B8A8_USCALED] = {
      .format = PIPE_FORMAT_R8G8B8A8_USCALED,
      .name = "PIPE_FORMAT_R8G8B8A8_USCALED",
      .short_name = "r8g8b8a8_uscaled",
      .block = {1, 1, 1, 32},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_PLAIN,
      .nr_channels = 4,	/* nr_channels */
      .is_array = true,	/* is_array */
      .is_bitmask = true,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = false,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
#if UTIL_ARCH_BIG_ENDIAN
   {
      {UTIL_FORMAT_TYPE_UNSIGNED, false, false, 8, 24},	/* x = r */
      {UTIL_FORMAT_TYPE_UNSIGNED, false, false, 8, 16},	/* y = g */
      {UTIL_FORMAT_TYPE_UNSIGNED, false, false, 8, 8},	/* z = b */
      {UTIL_FORMAT_TYPE_UNSIGNED, false, false, 8, 0}	/* w = a */
   },
#else
   {
      {UTIL_FORMAT_TYPE_UNSIGNED, false, false, 8, 0},	/* x = r */
      {UTIL_FORMAT_TYPE_UNSIGNED, false, false, 8, 8},	/* y = g */
      {UTIL_FORMAT_TYPE_UNSIGNED, false, false, 8, 16},	/* z = b */
      {UTIL_FORMAT_TYPE_UNSIGNED, false, false, 8, 24}	/* w = a */
   },
#endif
#if UTIL_ARCH_BIG_ENDIAN
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_Y,	/* g */
      PIPE_SWIZZLE_Z,	/* b */
      PIPE_SWIZZLE_W	/* a */
   },
#else
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_Y,	/* g */
      PIPE_SWIZZLE_Z,	/* b */
      PIPE_SWIZZLE_W	/* a */
   },
#endif
      .colorspace = UTIL_FORMAT_COLORSPACE_RGB,
      .srgb_equivalent = PIPE_FORMAT_NONE,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_B8G8R8A8_USCALED] = {
      .format = PIPE_FORMAT_B8G8R8A8_USCALED,
      .name = "PIPE_FORMAT_B8G8R8A8_USCALED",
      .short_name = "b8g8r8a8_uscaled",
      .block = {1, 1, 1, 32},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_PLAIN,
      .nr_channels = 4,	/* nr_channels */
      .is_array = true,	/* is_array */
      .is_bitmask = true,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = false,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
#if UTIL_ARCH_BIG_ENDIAN
   {
      {UTIL_FORMAT_TYPE_UNSIGNED, false, false, 8, 24},	/* x = b */
      {UTIL_FORMAT_TYPE_UNSIGNED, false, false, 8, 16},	/* y = g */
      {UTIL_FORMAT_TYPE_UNSIGNED, false, false, 8, 8},	/* z = r */
      {UTIL_FORMAT_TYPE_UNSIGNED, false, false, 8, 0}	/* w = a */
   },
#else
   {
      {UTIL_FORMAT_TYPE_UNSIGNED, false, false, 8, 0},	/* x = b */
      {UTIL_FORMAT_TYPE_UNSIGNED, false, false, 8, 8},	/* y = g */
      {UTIL_FORMAT_TYPE_UNSIGNED, false, false, 8, 16},	/* z = r */
      {UTIL_FORMAT_TYPE_UNSIGNED, false, false, 8, 24}	/* w = a */
   },
#endif
#if UTIL_ARCH_BIG_ENDIAN
   {
      PIPE_SWIZZLE_Z,	/* r */
      PIPE_SWIZZLE_Y,	/* g */
      PIPE_SWIZZLE_X,	/* b */
      PIPE_SWIZZLE_W	/* a */
   },
#else
   {
      PIPE_SWIZZLE_Z,	/* r */
      PIPE_SWIZZLE_Y,	/* g */
      PIPE_SWIZZLE_X,	/* b */
      PIPE_SWIZZLE_W	/* a */
   },
#endif
      .colorspace = UTIL_FORMAT_COLORSPACE_RGB,
      .srgb_equivalent = PIPE_FORMAT_NONE,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_A8B8G8R8_USCALED] = {
      .format = PIPE_FORMAT_A8B8G8R8_USCALED,
      .name = "PIPE_FORMAT_A8B8G8R8_USCALED",
      .short_name = "a8b8g8r8_uscaled",
      .block = {1, 1, 1, 32},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_PLAIN,
      .nr_channels = 4,	/* nr_channels */
      .is_array = true,	/* is_array */
      .is_bitmask = true,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = false,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
#if UTIL_ARCH_BIG_ENDIAN
   {
      {UTIL_FORMAT_TYPE_UNSIGNED, false, false, 8, 24},	/* x = a */
      {UTIL_FORMAT_TYPE_UNSIGNED, false, false, 8, 16},	/* y = b */
      {UTIL_FORMAT_TYPE_UNSIGNED, false, false, 8, 8},	/* z = g */
      {UTIL_FORMAT_TYPE_UNSIGNED, false, false, 8, 0}	/* w = r */
   },
#else
   {
      {UTIL_FORMAT_TYPE_UNSIGNED, false, false, 8, 0},	/* x = a */
      {UTIL_FORMAT_TYPE_UNSIGNED, false, false, 8, 8},	/* y = b */
      {UTIL_FORMAT_TYPE_UNSIGNED, false, false, 8, 16},	/* z = g */
      {UTIL_FORMAT_TYPE_UNSIGNED, false, false, 8, 24}	/* w = r */
   },
#endif
#if UTIL_ARCH_BIG_ENDIAN
   {
      PIPE_SWIZZLE_W,	/* r */
      PIPE_SWIZZLE_Z,	/* g */
      PIPE_SWIZZLE_Y,	/* b */
      PIPE_SWIZZLE_X	/* a */
   },
#else
   {
      PIPE_SWIZZLE_W,	/* r */
      PIPE_SWIZZLE_Z,	/* g */
      PIPE_SWIZZLE_Y,	/* b */
      PIPE_SWIZZLE_X	/* a */
   },
#endif
      .colorspace = UTIL_FORMAT_COLORSPACE_RGB,
      .srgb_equivalent = PIPE_FORMAT_NONE,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_R8_SNORM] = {
      .format = PIPE_FORMAT_R8_SNORM,
      .name = "PIPE_FORMAT_R8_SNORM",
      .short_name = "r8_snorm",
      .block = {1, 1, 1, 8},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_PLAIN,
      .nr_channels = 1,	/* nr_channels */
      .is_array = true,	/* is_array */
      .is_bitmask = true,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = false,	/* is_unorm */
      .is_snorm = true,	/* is_snorm */
   {
      {UTIL_FORMAT_TYPE_SIGNED, true, false, 8, 0},	/* x = r */
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0}
   },
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_0,	/* g */
      PIPE_SWIZZLE_0,	/* b */
      PIPE_SWIZZLE_1	/* a */
   },
      .colorspace = UTIL_FORMAT_COLORSPACE_RGB,
      .srgb_equivalent = PIPE_FORMAT_NONE,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_R8G8_SNORM] = {
      .format = PIPE_FORMAT_R8G8_SNORM,
      .name = "PIPE_FORMAT_R8G8_SNORM",
      .short_name = "r8g8_snorm",
      .block = {1, 1, 1, 16},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_PLAIN,
      .nr_channels = 2,	/* nr_channels */
      .is_array = true,	/* is_array */
      .is_bitmask = true,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = false,	/* is_unorm */
      .is_snorm = true,	/* is_snorm */
#if UTIL_ARCH_BIG_ENDIAN
   {
      {UTIL_FORMAT_TYPE_SIGNED, true, false, 8, 8},	/* x = r */
      {UTIL_FORMAT_TYPE_SIGNED, true, false, 8, 0},	/* y = g */
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0}
   },
#else
   {
      {UTIL_FORMAT_TYPE_SIGNED, true, false, 8, 0},	/* x = r */
      {UTIL_FORMAT_TYPE_SIGNED, true, false, 8, 8},	/* y = g */
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0}
   },
#endif
#if UTIL_ARCH_BIG_ENDIAN
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_Y,	/* g */
      PIPE_SWIZZLE_0,	/* b */
      PIPE_SWIZZLE_1	/* a */
   },
#else
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_Y,	/* g */
      PIPE_SWIZZLE_0,	/* b */
      PIPE_SWIZZLE_1	/* a */
   },
#endif
      .colorspace = UTIL_FORMAT_COLORSPACE_RGB,
      .srgb_equivalent = PIPE_FORMAT_NONE,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_R8G8B8_SNORM] = {
      .format = PIPE_FORMAT_R8G8B8_SNORM,
      .name = "PIPE_FORMAT_R8G8B8_SNORM",
      .short_name = "r8g8b8_snorm",
      .block = {1, 1, 1, 24},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_PLAIN,
      .nr_channels = 3,	/* nr_channels */
      .is_array = true,	/* is_array */
      .is_bitmask = false,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = false,	/* is_unorm */
      .is_snorm = true,	/* is_snorm */
#if UTIL_ARCH_BIG_ENDIAN
   {
      {UTIL_FORMAT_TYPE_SIGNED, true, false, 8, 16},	/* x = r */
      {UTIL_FORMAT_TYPE_SIGNED, true, false, 8, 8},	/* y = g */
      {UTIL_FORMAT_TYPE_SIGNED, true, false, 8, 0},	/* z = b */
      {0, 0, 0, 0, 0}
   },
#else
   {
      {UTIL_FORMAT_TYPE_SIGNED, true, false, 8, 0},	/* x = r */
      {UTIL_FORMAT_TYPE_SIGNED, true, false, 8, 8},	/* y = g */
      {UTIL_FORMAT_TYPE_SIGNED, true, false, 8, 16},	/* z = b */
      {0, 0, 0, 0, 0}
   },
#endif
#if UTIL_ARCH_BIG_ENDIAN
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_Y,	/* g */
      PIPE_SWIZZLE_Z,	/* b */
      PIPE_SWIZZLE_1	/* a */
   },
#else
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_Y,	/* g */
      PIPE_SWIZZLE_Z,	/* b */
      PIPE_SWIZZLE_1	/* a */
   },
#endif
      .colorspace = UTIL_FORMAT_COLORSPACE_RGB,
      .srgb_equivalent = PIPE_FORMAT_NONE,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_B8G8R8_SNORM] = {
      .format = PIPE_FORMAT_B8G8R8_SNORM,
      .name = "PIPE_FORMAT_B8G8R8_SNORM",
      .short_name = "b8g8r8_snorm",
      .block = {1, 1, 1, 24},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_PLAIN,
      .nr_channels = 3,	/* nr_channels */
      .is_array = true,	/* is_array */
      .is_bitmask = false,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = false,	/* is_unorm */
      .is_snorm = true,	/* is_snorm */
#if UTIL_ARCH_BIG_ENDIAN
   {
      {UTIL_FORMAT_TYPE_SIGNED, true, false, 8, 16},	/* x = b */
      {UTIL_FORMAT_TYPE_SIGNED, true, false, 8, 8},	/* y = g */
      {UTIL_FORMAT_TYPE_SIGNED, true, false, 8, 0},	/* z = r */
      {0, 0, 0, 0, 0}
   },
#else
   {
      {UTIL_FORMAT_TYPE_SIGNED, true, false, 8, 0},	/* x = b */
      {UTIL_FORMAT_TYPE_SIGNED, true, false, 8, 8},	/* y = g */
      {UTIL_FORMAT_TYPE_SIGNED, true, false, 8, 16},	/* z = r */
      {0, 0, 0, 0, 0}
   },
#endif
#if UTIL_ARCH_BIG_ENDIAN
   {
      PIPE_SWIZZLE_Z,	/* r */
      PIPE_SWIZZLE_Y,	/* g */
      PIPE_SWIZZLE_X,	/* b */
      PIPE_SWIZZLE_1	/* a */
   },
#else
   {
      PIPE_SWIZZLE_Z,	/* r */
      PIPE_SWIZZLE_Y,	/* g */
      PIPE_SWIZZLE_X,	/* b */
      PIPE_SWIZZLE_1	/* a */
   },
#endif
      .colorspace = UTIL_FORMAT_COLORSPACE_RGB,
      .srgb_equivalent = PIPE_FORMAT_NONE,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_R8G8B8A8_SNORM] = {
      .format = PIPE_FORMAT_R8G8B8A8_SNORM,
      .name = "PIPE_FORMAT_R8G8B8A8_SNORM",
      .short_name = "r8g8b8a8_snorm",
      .block = {1, 1, 1, 32},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_PLAIN,
      .nr_channels = 4,	/* nr_channels */
      .is_array = true,	/* is_array */
      .is_bitmask = true,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = false,	/* is_unorm */
      .is_snorm = true,	/* is_snorm */
#if UTIL_ARCH_BIG_ENDIAN
   {
      {UTIL_FORMAT_TYPE_SIGNED, true, false, 8, 24},	/* x = r */
      {UTIL_FORMAT_TYPE_SIGNED, true, false, 8, 16},	/* y = g */
      {UTIL_FORMAT_TYPE_SIGNED, true, false, 8, 8},	/* z = b */
      {UTIL_FORMAT_TYPE_SIGNED, true, false, 8, 0}	/* w = a */
   },
#else
   {
      {UTIL_FORMAT_TYPE_SIGNED, true, false, 8, 0},	/* x = r */
      {UTIL_FORMAT_TYPE_SIGNED, true, false, 8, 8},	/* y = g */
      {UTIL_FORMAT_TYPE_SIGNED, true, false, 8, 16},	/* z = b */
      {UTIL_FORMAT_TYPE_SIGNED, true, false, 8, 24}	/* w = a */
   },
#endif
#if UTIL_ARCH_BIG_ENDIAN
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_Y,	/* g */
      PIPE_SWIZZLE_Z,	/* b */
      PIPE_SWIZZLE_W	/* a */
   },
#else
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_Y,	/* g */
      PIPE_SWIZZLE_Z,	/* b */
      PIPE_SWIZZLE_W	/* a */
   },
#endif
      .colorspace = UTIL_FORMAT_COLORSPACE_RGB,
      .srgb_equivalent = PIPE_FORMAT_NONE,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_B8G8R8A8_SNORM] = {
      .format = PIPE_FORMAT_B8G8R8A8_SNORM,
      .name = "PIPE_FORMAT_B8G8R8A8_SNORM",
      .short_name = "b8g8r8a8_snorm",
      .block = {1, 1, 1, 32},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_PLAIN,
      .nr_channels = 4,	/* nr_channels */
      .is_array = true,	/* is_array */
      .is_bitmask = true,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = false,	/* is_unorm */
      .is_snorm = true,	/* is_snorm */
#if UTIL_ARCH_BIG_ENDIAN
   {
      {UTIL_FORMAT_TYPE_SIGNED, true, false, 8, 24},	/* x = b */
      {UTIL_FORMAT_TYPE_SIGNED, true, false, 8, 16},	/* y = g */
      {UTIL_FORMAT_TYPE_SIGNED, true, false, 8, 8},	/* z = r */
      {UTIL_FORMAT_TYPE_SIGNED, true, false, 8, 0}	/* w = a */
   },
#else
   {
      {UTIL_FORMAT_TYPE_SIGNED, true, false, 8, 0},	/* x = b */
      {UTIL_FORMAT_TYPE_SIGNED, true, false, 8, 8},	/* y = g */
      {UTIL_FORMAT_TYPE_SIGNED, true, false, 8, 16},	/* z = r */
      {UTIL_FORMAT_TYPE_SIGNED, true, false, 8, 24}	/* w = a */
   },
#endif
#if UTIL_ARCH_BIG_ENDIAN
   {
      PIPE_SWIZZLE_Z,	/* r */
      PIPE_SWIZZLE_Y,	/* g */
      PIPE_SWIZZLE_X,	/* b */
      PIPE_SWIZZLE_W	/* a */
   },
#else
   {
      PIPE_SWIZZLE_Z,	/* r */
      PIPE_SWIZZLE_Y,	/* g */
      PIPE_SWIZZLE_X,	/* b */
      PIPE_SWIZZLE_W	/* a */
   },
#endif
      .colorspace = UTIL_FORMAT_COLORSPACE_RGB,
      .srgb_equivalent = PIPE_FORMAT_NONE,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_R8_SSCALED] = {
      .format = PIPE_FORMAT_R8_SSCALED,
      .name = "PIPE_FORMAT_R8_SSCALED",
      .short_name = "r8_sscaled",
      .block = {1, 1, 1, 8},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_PLAIN,
      .nr_channels = 1,	/* nr_channels */
      .is_array = true,	/* is_array */
      .is_bitmask = true,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = false,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
   {
      {UTIL_FORMAT_TYPE_SIGNED, false, false, 8, 0},	/* x = r */
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0}
   },
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_0,	/* g */
      PIPE_SWIZZLE_0,	/* b */
      PIPE_SWIZZLE_1	/* a */
   },
      .colorspace = UTIL_FORMAT_COLORSPACE_RGB,
      .srgb_equivalent = PIPE_FORMAT_NONE,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_R8G8_SSCALED] = {
      .format = PIPE_FORMAT_R8G8_SSCALED,
      .name = "PIPE_FORMAT_R8G8_SSCALED",
      .short_name = "r8g8_sscaled",
      .block = {1, 1, 1, 16},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_PLAIN,
      .nr_channels = 2,	/* nr_channels */
      .is_array = true,	/* is_array */
      .is_bitmask = true,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = false,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
#if UTIL_ARCH_BIG_ENDIAN
   {
      {UTIL_FORMAT_TYPE_SIGNED, false, false, 8, 8},	/* x = r */
      {UTIL_FORMAT_TYPE_SIGNED, false, false, 8, 0},	/* y = g */
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0}
   },
#else
   {
      {UTIL_FORMAT_TYPE_SIGNED, false, false, 8, 0},	/* x = r */
      {UTIL_FORMAT_TYPE_SIGNED, false, false, 8, 8},	/* y = g */
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0}
   },
#endif
#if UTIL_ARCH_BIG_ENDIAN
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_Y,	/* g */
      PIPE_SWIZZLE_0,	/* b */
      PIPE_SWIZZLE_1	/* a */
   },
#else
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_Y,	/* g */
      PIPE_SWIZZLE_0,	/* b */
      PIPE_SWIZZLE_1	/* a */
   },
#endif
      .colorspace = UTIL_FORMAT_COLORSPACE_RGB,
      .srgb_equivalent = PIPE_FORMAT_NONE,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_R8G8B8_SSCALED] = {
      .format = PIPE_FORMAT_R8G8B8_SSCALED,
      .name = "PIPE_FORMAT_R8G8B8_SSCALED",
      .short_name = "r8g8b8_sscaled",
      .block = {1, 1, 1, 24},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_PLAIN,
      .nr_channels = 3,	/* nr_channels */
      .is_array = true,	/* is_array */
      .is_bitmask = false,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = false,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
#if UTIL_ARCH_BIG_ENDIAN
   {
      {UTIL_FORMAT_TYPE_SIGNED, false, false, 8, 16},	/* x = r */
      {UTIL_FORMAT_TYPE_SIGNED, false, false, 8, 8},	/* y = g */
      {UTIL_FORMAT_TYPE_SIGNED, false, false, 8, 0},	/* z = b */
      {0, 0, 0, 0, 0}
   },
#else
   {
      {UTIL_FORMAT_TYPE_SIGNED, false, false, 8, 0},	/* x = r */
      {UTIL_FORMAT_TYPE_SIGNED, false, false, 8, 8},	/* y = g */
      {UTIL_FORMAT_TYPE_SIGNED, false, false, 8, 16},	/* z = b */
      {0, 0, 0, 0, 0}
   },
#endif
#if UTIL_ARCH_BIG_ENDIAN
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_Y,	/* g */
      PIPE_SWIZZLE_Z,	/* b */
      PIPE_SWIZZLE_1	/* a */
   },
#else
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_Y,	/* g */
      PIPE_SWIZZLE_Z,	/* b */
      PIPE_SWIZZLE_1	/* a */
   },
#endif
      .colorspace = UTIL_FORMAT_COLORSPACE_RGB,
      .srgb_equivalent = PIPE_FORMAT_NONE,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_B8G8R8_SSCALED] = {
      .format = PIPE_FORMAT_B8G8R8_SSCALED,
      .name = "PIPE_FORMAT_B8G8R8_SSCALED",
      .short_name = "b8g8r8_sscaled",
      .block = {1, 1, 1, 24},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_PLAIN,
      .nr_channels = 3,	/* nr_channels */
      .is_array = true,	/* is_array */
      .is_bitmask = false,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = false,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
#if UTIL_ARCH_BIG_ENDIAN
   {
      {UTIL_FORMAT_TYPE_SIGNED, false, false, 8, 16},	/* x = b */
      {UTIL_FORMAT_TYPE_SIGNED, false, false, 8, 8},	/* y = g */
      {UTIL_FORMAT_TYPE_SIGNED, false, false, 8, 0},	/* z = r */
      {0, 0, 0, 0, 0}
   },
#else
   {
      {UTIL_FORMAT_TYPE_SIGNED, false, false, 8, 0},	/* x = b */
      {UTIL_FORMAT_TYPE_SIGNED, false, false, 8, 8},	/* y = g */
      {UTIL_FORMAT_TYPE_SIGNED, false, false, 8, 16},	/* z = r */
      {0, 0, 0, 0, 0}
   },
#endif
#if UTIL_ARCH_BIG_ENDIAN
   {
      PIPE_SWIZZLE_Z,	/* r */
      PIPE_SWIZZLE_Y,	/* g */
      PIPE_SWIZZLE_X,	/* b */
      PIPE_SWIZZLE_1	/* a */
   },
#else
   {
      PIPE_SWIZZLE_Z,	/* r */
      PIPE_SWIZZLE_Y,	/* g */
      PIPE_SWIZZLE_X,	/* b */
      PIPE_SWIZZLE_1	/* a */
   },
#endif
      .colorspace = UTIL_FORMAT_COLORSPACE_RGB,
      .srgb_equivalent = PIPE_FORMAT_NONE,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_R8G8B8A8_SSCALED] = {
      .format = PIPE_FORMAT_R8G8B8A8_SSCALED,
      .name = "PIPE_FORMAT_R8G8B8A8_SSCALED",
      .short_name = "r8g8b8a8_sscaled",
      .block = {1, 1, 1, 32},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_PLAIN,
      .nr_channels = 4,	/* nr_channels */
      .is_array = true,	/* is_array */
      .is_bitmask = true,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = false,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
#if UTIL_ARCH_BIG_ENDIAN
   {
      {UTIL_FORMAT_TYPE_SIGNED, false, false, 8, 24},	/* x = r */
      {UTIL_FORMAT_TYPE_SIGNED, false, false, 8, 16},	/* y = g */
      {UTIL_FORMAT_TYPE_SIGNED, false, false, 8, 8},	/* z = b */
      {UTIL_FORMAT_TYPE_SIGNED, false, false, 8, 0}	/* w = a */
   },
#else
   {
      {UTIL_FORMAT_TYPE_SIGNED, false, false, 8, 0},	/* x = r */
      {UTIL_FORMAT_TYPE_SIGNED, false, false, 8, 8},	/* y = g */
      {UTIL_FORMAT_TYPE_SIGNED, false, false, 8, 16},	/* z = b */
      {UTIL_FORMAT_TYPE_SIGNED, false, false, 8, 24}	/* w = a */
   },
#endif
#if UTIL_ARCH_BIG_ENDIAN
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_Y,	/* g */
      PIPE_SWIZZLE_Z,	/* b */
      PIPE_SWIZZLE_W	/* a */
   },
#else
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_Y,	/* g */
      PIPE_SWIZZLE_Z,	/* b */
      PIPE_SWIZZLE_W	/* a */
   },
#endif
      .colorspace = UTIL_FORMAT_COLORSPACE_RGB,
      .srgb_equivalent = PIPE_FORMAT_NONE,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_B8G8R8A8_SSCALED] = {
      .format = PIPE_FORMAT_B8G8R8A8_SSCALED,
      .name = "PIPE_FORMAT_B8G8R8A8_SSCALED",
      .short_name = "b8g8r8a8_sscaled",
      .block = {1, 1, 1, 32},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_PLAIN,
      .nr_channels = 4,	/* nr_channels */
      .is_array = true,	/* is_array */
      .is_bitmask = true,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = false,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
#if UTIL_ARCH_BIG_ENDIAN
   {
      {UTIL_FORMAT_TYPE_SIGNED, false, false, 8, 24},	/* x = b */
      {UTIL_FORMAT_TYPE_SIGNED, false, false, 8, 16},	/* y = g */
      {UTIL_FORMAT_TYPE_SIGNED, false, false, 8, 8},	/* z = r */
      {UTIL_FORMAT_TYPE_SIGNED, false, false, 8, 0}	/* w = a */
   },
#else
   {
      {UTIL_FORMAT_TYPE_SIGNED, false, false, 8, 0},	/* x = b */
      {UTIL_FORMAT_TYPE_SIGNED, false, false, 8, 8},	/* y = g */
      {UTIL_FORMAT_TYPE_SIGNED, false, false, 8, 16},	/* z = r */
      {UTIL_FORMAT_TYPE_SIGNED, false, false, 8, 24}	/* w = a */
   },
#endif
#if UTIL_ARCH_BIG_ENDIAN
   {
      PIPE_SWIZZLE_Z,	/* r */
      PIPE_SWIZZLE_Y,	/* g */
      PIPE_SWIZZLE_X,	/* b */
      PIPE_SWIZZLE_W	/* a */
   },
#else
   {
      PIPE_SWIZZLE_Z,	/* r */
      PIPE_SWIZZLE_Y,	/* g */
      PIPE_SWIZZLE_X,	/* b */
      PIPE_SWIZZLE_W	/* a */
   },
#endif
      .colorspace = UTIL_FORMAT_COLORSPACE_RGB,
      .srgb_equivalent = PIPE_FORMAT_NONE,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_A8B8G8R8_SSCALED] = {
      .format = PIPE_FORMAT_A8B8G8R8_SSCALED,
      .name = "PIPE_FORMAT_A8B8G8R8_SSCALED",
      .short_name = "a8b8g8r8_sscaled",
      .block = {1, 1, 1, 32},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_PLAIN,
      .nr_channels = 4,	/* nr_channels */
      .is_array = true,	/* is_array */
      .is_bitmask = true,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = false,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
#if UTIL_ARCH_BIG_ENDIAN
   {
      {UTIL_FORMAT_TYPE_SIGNED, false, false, 8, 24},	/* x = a */
      {UTIL_FORMAT_TYPE_SIGNED, false, false, 8, 16},	/* y = b */
      {UTIL_FORMAT_TYPE_SIGNED, false, false, 8, 8},	/* z = g */
      {UTIL_FORMAT_TYPE_SIGNED, false, false, 8, 0}	/* w = r */
   },
#else
   {
      {UTIL_FORMAT_TYPE_SIGNED, false, false, 8, 0},	/* x = a */
      {UTIL_FORMAT_TYPE_SIGNED, false, false, 8, 8},	/* y = b */
      {UTIL_FORMAT_TYPE_SIGNED, false, false, 8, 16},	/* z = g */
      {UTIL_FORMAT_TYPE_SIGNED, false, false, 8, 24}	/* w = r */
   },
#endif
#if UTIL_ARCH_BIG_ENDIAN
   {
      PIPE_SWIZZLE_W,	/* r */
      PIPE_SWIZZLE_Z,	/* g */
      PIPE_SWIZZLE_Y,	/* b */
      PIPE_SWIZZLE_X	/* a */
   },
#else
   {
      PIPE_SWIZZLE_W,	/* r */
      PIPE_SWIZZLE_Z,	/* g */
      PIPE_SWIZZLE_Y,	/* b */
      PIPE_SWIZZLE_X	/* a */
   },
#endif
      .colorspace = UTIL_FORMAT_COLORSPACE_RGB,
      .srgb_equivalent = PIPE_FORMAT_NONE,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_R32_FIXED] = {
      .format = PIPE_FORMAT_R32_FIXED,
      .name = "PIPE_FORMAT_R32_FIXED",
      .short_name = "r32_fixed",
      .block = {1, 1, 1, 32},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_PLAIN,
      .nr_channels = 1,	/* nr_channels */
      .is_array = true,	/* is_array */
      .is_bitmask = false,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = false,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
   {
      {UTIL_FORMAT_TYPE_FIXED, false, false, 32, 0},	/* x = r */
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0}
   },
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_0,	/* g */
      PIPE_SWIZZLE_0,	/* b */
      PIPE_SWIZZLE_1	/* a */
   },
      .colorspace = UTIL_FORMAT_COLORSPACE_RGB,
      .srgb_equivalent = PIPE_FORMAT_NONE,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_R32G32_FIXED] = {
      .format = PIPE_FORMAT_R32G32_FIXED,
      .name = "PIPE_FORMAT_R32G32_FIXED",
      .short_name = "r32g32_fixed",
      .block = {1, 1, 1, 64},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_PLAIN,
      .nr_channels = 2,	/* nr_channels */
      .is_array = true,	/* is_array */
      .is_bitmask = false,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = false,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
#if UTIL_ARCH_BIG_ENDIAN
   {
      {UTIL_FORMAT_TYPE_FIXED, false, false, 32, 32},	/* x = r */
      {UTIL_FORMAT_TYPE_FIXED, false, false, 32, 0},	/* y = g */
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0}
   },
#else
   {
      {UTIL_FORMAT_TYPE_FIXED, false, false, 32, 0},	/* x = r */
      {UTIL_FORMAT_TYPE_FIXED, false, false, 32, 32},	/* y = g */
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0}
   },
#endif
#if UTIL_ARCH_BIG_ENDIAN
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_Y,	/* g */
      PIPE_SWIZZLE_0,	/* b */
      PIPE_SWIZZLE_1	/* a */
   },
#else
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_Y,	/* g */
      PIPE_SWIZZLE_0,	/* b */
      PIPE_SWIZZLE_1	/* a */
   },
#endif
      .colorspace = UTIL_FORMAT_COLORSPACE_RGB,
      .srgb_equivalent = PIPE_FORMAT_NONE,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_R32G32B32_FIXED] = {
      .format = PIPE_FORMAT_R32G32B32_FIXED,
      .name = "PIPE_FORMAT_R32G32B32_FIXED",
      .short_name = "r32g32b32_fixed",
      .block = {1, 1, 1, 96},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_PLAIN,
      .nr_channels = 3,	/* nr_channels */
      .is_array = true,	/* is_array */
      .is_bitmask = false,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = false,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
#if UTIL_ARCH_BIG_ENDIAN
   {
      {UTIL_FORMAT_TYPE_FIXED, false, false, 32, 64},	/* x = r */
      {UTIL_FORMAT_TYPE_FIXED, false, false, 32, 32},	/* y = g */
      {UTIL_FORMAT_TYPE_FIXED, false, false, 32, 0},	/* z = b */
      {0, 0, 0, 0, 0}
   },
#else
   {
      {UTIL_FORMAT_TYPE_FIXED, false, false, 32, 0},	/* x = r */
      {UTIL_FORMAT_TYPE_FIXED, false, false, 32, 32},	/* y = g */
      {UTIL_FORMAT_TYPE_FIXED, false, false, 32, 64},	/* z = b */
      {0, 0, 0, 0, 0}
   },
#endif
#if UTIL_ARCH_BIG_ENDIAN
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_Y,	/* g */
      PIPE_SWIZZLE_Z,	/* b */
      PIPE_SWIZZLE_1	/* a */
   },
#else
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_Y,	/* g */
      PIPE_SWIZZLE_Z,	/* b */
      PIPE_SWIZZLE_1	/* a */
   },
#endif
      .colorspace = UTIL_FORMAT_COLORSPACE_RGB,
      .srgb_equivalent = PIPE_FORMAT_NONE,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_R32G32B32A32_FIXED] = {
      .format = PIPE_FORMAT_R32G32B32A32_FIXED,
      .name = "PIPE_FORMAT_R32G32B32A32_FIXED",
      .short_name = "r32g32b32a32_fixed",
      .block = {1, 1, 1, 128},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_PLAIN,
      .nr_channels = 4,	/* nr_channels */
      .is_array = true,	/* is_array */
      .is_bitmask = false,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = false,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
#if UTIL_ARCH_BIG_ENDIAN
   {
      {UTIL_FORMAT_TYPE_FIXED, false, false, 32, 96},	/* x = r */
      {UTIL_FORMAT_TYPE_FIXED, false, false, 32, 64},	/* y = g */
      {UTIL_FORMAT_TYPE_FIXED, false, false, 32, 32},	/* z = b */
      {UTIL_FORMAT_TYPE_FIXED, false, false, 32, 0}	/* w = a */
   },
#else
   {
      {UTIL_FORMAT_TYPE_FIXED, false, false, 32, 0},	/* x = r */
      {UTIL_FORMAT_TYPE_FIXED, false, false, 32, 32},	/* y = g */
      {UTIL_FORMAT_TYPE_FIXED, false, false, 32, 64},	/* z = b */
      {UTIL_FORMAT_TYPE_FIXED, false, false, 32, 96}	/* w = a */
   },
#endif
#if UTIL_ARCH_BIG_ENDIAN
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_Y,	/* g */
      PIPE_SWIZZLE_Z,	/* b */
      PIPE_SWIZZLE_W	/* a */
   },
#else
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_Y,	/* g */
      PIPE_SWIZZLE_Z,	/* b */
      PIPE_SWIZZLE_W	/* a */
   },
#endif
      .colorspace = UTIL_FORMAT_COLORSPACE_RGB,
      .srgb_equivalent = PIPE_FORMAT_NONE,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_R10G10B10X2_USCALED] = {
      .format = PIPE_FORMAT_R10G10B10X2_USCALED,
      .name = "PIPE_FORMAT_R10G10B10X2_USCALED",
      .short_name = "r10g10b10x2_uscaled",
      .block = {1, 1, 1, 32},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_PLAIN,
      .nr_channels = 4,	/* nr_channels */
      .is_array = false,	/* is_array */
      .is_bitmask = true,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = false,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
#if UTIL_ARCH_BIG_ENDIAN
   {
      {UTIL_FORMAT_TYPE_VOID, false, false, 2, 30},	/* x = x */
      {UTIL_FORMAT_TYPE_UNSIGNED, false, false, 10, 20},	/* y = b */
      {UTIL_FORMAT_TYPE_UNSIGNED, false, false, 10, 10},	/* z = g */
      {UTIL_FORMAT_TYPE_UNSIGNED, false, false, 10, 0}	/* w = r */
   },
#else
   {
      {UTIL_FORMAT_TYPE_UNSIGNED, false, false, 10, 0},	/* x = r */
      {UTIL_FORMAT_TYPE_UNSIGNED, false, false, 10, 10},	/* y = g */
      {UTIL_FORMAT_TYPE_UNSIGNED, false, false, 10, 20},	/* z = b */
      {UTIL_FORMAT_TYPE_VOID, false, false, 2, 30}	/* w = x */
   },
#endif
#if UTIL_ARCH_BIG_ENDIAN
   {
      PIPE_SWIZZLE_W,	/* r */
      PIPE_SWIZZLE_Z,	/* g */
      PIPE_SWIZZLE_Y,	/* b */
      PIPE_SWIZZLE_1	/* a */
   },
#else
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_Y,	/* g */
      PIPE_SWIZZLE_Z,	/* b */
      PIPE_SWIZZLE_1	/* a */
   },
#endif
      .colorspace = UTIL_FORMAT_COLORSPACE_RGB,
      .srgb_equivalent = PIPE_FORMAT_NONE,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_R10G10B10X2_SNORM] = {
      .format = PIPE_FORMAT_R10G10B10X2_SNORM,
      .name = "PIPE_FORMAT_R10G10B10X2_SNORM",
      .short_name = "r10g10b10x2_snorm",
      .block = {1, 1, 1, 32},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_PLAIN,
      .nr_channels = 4,	/* nr_channels */
      .is_array = false,	/* is_array */
      .is_bitmask = true,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = false,	/* is_unorm */
      .is_snorm = true,	/* is_snorm */
#if UTIL_ARCH_BIG_ENDIAN
   {
      {UTIL_FORMAT_TYPE_VOID, false, false, 2, 30},	/* x = x */
      {UTIL_FORMAT_TYPE_SIGNED, true, false, 10, 20},	/* y = b */
      {UTIL_FORMAT_TYPE_SIGNED, true, false, 10, 10},	/* z = g */
      {UTIL_FORMAT_TYPE_SIGNED, true, false, 10, 0}	/* w = r */
   },
#else
   {
      {UTIL_FORMAT_TYPE_SIGNED, true, false, 10, 0},	/* x = r */
      {UTIL_FORMAT_TYPE_SIGNED, true, false, 10, 10},	/* y = g */
      {UTIL_FORMAT_TYPE_SIGNED, true, false, 10, 20},	/* z = b */
      {UTIL_FORMAT_TYPE_VOID, false, false, 2, 30}	/* w = x */
   },
#endif
#if UTIL_ARCH_BIG_ENDIAN
   {
      PIPE_SWIZZLE_W,	/* r */
      PIPE_SWIZZLE_Z,	/* g */
      PIPE_SWIZZLE_Y,	/* b */
      PIPE_SWIZZLE_1	/* a */
   },
#else
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_Y,	/* g */
      PIPE_SWIZZLE_Z,	/* b */
      PIPE_SWIZZLE_1	/* a */
   },
#endif
      .colorspace = UTIL_FORMAT_COLORSPACE_RGB,
      .srgb_equivalent = PIPE_FORMAT_NONE,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_R10G10B10X2_SINT] = {
      .format = PIPE_FORMAT_R10G10B10X2_SINT,
      .name = "PIPE_FORMAT_R10G10B10X2_SINT",
      .short_name = "r10g10b10x2_sint",
      .block = {1, 1, 1, 32},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_PLAIN,
      .nr_channels = 4,	/* nr_channels */
      .is_array = false,	/* is_array */
      .is_bitmask = true,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = false,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
#if UTIL_ARCH_BIG_ENDIAN
   {
      {UTIL_FORMAT_TYPE_VOID, false, false, 2, 30},	/* x = x */
      {UTIL_FORMAT_TYPE_SIGNED, false, true, 10, 20},	/* y = b */
      {UTIL_FORMAT_TYPE_SIGNED, false, true, 10, 10},	/* z = g */
      {UTIL_FORMAT_TYPE_SIGNED, false, true, 10, 0}	/* w = r */
   },
#else
   {
      {UTIL_FORMAT_TYPE_SIGNED, false, true, 10, 0},	/* x = r */
      {UTIL_FORMAT_TYPE_SIGNED, false, true, 10, 10},	/* y = g */
      {UTIL_FORMAT_TYPE_SIGNED, false, true, 10, 20},	/* z = b */
      {UTIL_FORMAT_TYPE_VOID, false, false, 2, 30}	/* w = x */
   },
#endif
#if UTIL_ARCH_BIG_ENDIAN
   {
      PIPE_SWIZZLE_W,	/* r */
      PIPE_SWIZZLE_Z,	/* g */
      PIPE_SWIZZLE_Y,	/* b */
      PIPE_SWIZZLE_1	/* a */
   },
#else
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_Y,	/* g */
      PIPE_SWIZZLE_Z,	/* b */
      PIPE_SWIZZLE_1	/* a */
   },
#endif
      .colorspace = UTIL_FORMAT_COLORSPACE_RGB,
      .srgb_equivalent = PIPE_FORMAT_NONE,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_Y8_V8_U8_420_UNORM] = {
      .format = PIPE_FORMAT_Y8_V8_U8_420_UNORM,
      .name = "PIPE_FORMAT_Y8_V8_U8_420_UNORM",
      .short_name = "y8_v8_u8_420_unorm",
      .block = {1, 1, 1, 0},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_PLANAR3,
      .nr_channels = 0,	/* nr_channels */
      .is_array = false,	/* is_array */
      .is_bitmask = false,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = true,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
   {
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0}
   },
   {
      PIPE_SWIZZLE_X,	/* y */
      PIPE_SWIZZLE_Y,	/* u */
      PIPE_SWIZZLE_Z,	/* v */
      PIPE_SWIZZLE_W	/* ignored */
   },
      .colorspace = UTIL_FORMAT_COLORSPACE_YUV,
      .srgb_equivalent = PIPE_FORMAT_NONE,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_Y8_V8_U8_422_UNORM] = {
      .format = PIPE_FORMAT_Y8_V8_U8_422_UNORM,
      .name = "PIPE_FORMAT_Y8_V8_U8_422_UNORM",
      .short_name = "y8_v8_u8_422_unorm",
      .block = {1, 1, 1, 0},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_PLANAR3,
      .nr_channels = 0,	/* nr_channels */
      .is_array = false,	/* is_array */
      .is_bitmask = false,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = true,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
   {
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0}
   },
   {
      PIPE_SWIZZLE_X,	/* y */
      PIPE_SWIZZLE_Y,	/* u */
      PIPE_SWIZZLE_Z,	/* v */
      PIPE_SWIZZLE_W	/* ignored */
   },
      .colorspace = UTIL_FORMAT_COLORSPACE_YUV,
      .srgb_equivalent = PIPE_FORMAT_NONE,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_Y8_U8_V8_420_UNORM] = {
      .format = PIPE_FORMAT_Y8_U8_V8_420_UNORM,
      .name = "PIPE_FORMAT_Y8_U8_V8_420_UNORM",
      .short_name = "y8_u8_v8_420_unorm",
      .block = {1, 1, 1, 0},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_PLANAR3,
      .nr_channels = 0,	/* nr_channels */
      .is_array = false,	/* is_array */
      .is_bitmask = false,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = true,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
   {
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0}
   },
   {
      PIPE_SWIZZLE_X,	/* y */
      PIPE_SWIZZLE_Y,	/* u */
      PIPE_SWIZZLE_Z,	/* v */
      PIPE_SWIZZLE_W	/* ignored */
   },
      .colorspace = UTIL_FORMAT_COLORSPACE_YUV,
      .srgb_equivalent = PIPE_FORMAT_NONE,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_Y8_U8V8_420_UNORM] = {
      .format = PIPE_FORMAT_Y8_U8V8_420_UNORM,
      .name = "PIPE_FORMAT_Y8_U8V8_420_UNORM",
      .short_name = "y8_u8v8_420_unorm",
      .block = {1, 1, 1, 0},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_PLANAR2,
      .nr_channels = 0,	/* nr_channels */
      .is_array = false,	/* is_array */
      .is_bitmask = false,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = true,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
   {
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0}
   },
   {
      PIPE_SWIZZLE_X,	/* y */
      PIPE_SWIZZLE_Y,	/* u */
      PIPE_SWIZZLE_Z,	/* v */
      PIPE_SWIZZLE_W	/* ignored */
   },
      .colorspace = UTIL_FORMAT_COLORSPACE_YUV,
      .srgb_equivalent = PIPE_FORMAT_NONE,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_Y8_V8U8_420_UNORM] = {
      .format = PIPE_FORMAT_Y8_V8U8_420_UNORM,
      .name = "PIPE_FORMAT_Y8_V8U8_420_UNORM",
      .short_name = "y8_v8u8_420_unorm",
      .block = {1, 1, 1, 0},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_PLANAR2,
      .nr_channels = 0,	/* nr_channels */
      .is_array = false,	/* is_array */
      .is_bitmask = false,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = true,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
   {
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0}
   },
   {
      PIPE_SWIZZLE_X,	/* y */
      PIPE_SWIZZLE_Y,	/* u */
      PIPE_SWIZZLE_Z,	/* v */
      PIPE_SWIZZLE_W	/* ignored */
   },
      .colorspace = UTIL_FORMAT_COLORSPACE_YUV,
      .srgb_equivalent = PIPE_FORMAT_NONE,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_Y8_400_UNORM] = {
      .format = PIPE_FORMAT_Y8_400_UNORM,
      .name = "PIPE_FORMAT_Y8_400_UNORM",
      .short_name = "y8_400_unorm",
      .block = {1, 1, 1, 8},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_OTHER,
      .nr_channels = 1,	/* nr_channels */
      .is_array = false,	/* is_array */
      .is_bitmask = false,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = true,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
   {
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 8, 0},	/* x = x */
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0}
   },
   {
      PIPE_SWIZZLE_X,	/* y */
      PIPE_SWIZZLE_0,	/* u */
      PIPE_SWIZZLE_0,	/* v */
      PIPE_SWIZZLE_1	/* ignored */
   },
      .colorspace = UTIL_FORMAT_COLORSPACE_YUV,
      .srgb_equivalent = PIPE_FORMAT_NONE,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_Y10_U10V10_420_UNORM] = {
      .format = PIPE_FORMAT_Y10_U10V10_420_UNORM,
      .name = "PIPE_FORMAT_Y10_U10V10_420_UNORM",
      .short_name = "y10_u10v10_420_unorm",
      .block = {1, 1, 1, 0},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_PLANAR2,
      .nr_channels = 0,	/* nr_channels */
      .is_array = false,	/* is_array */
      .is_bitmask = false,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = true,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
   {
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0}
   },
   {
      PIPE_SWIZZLE_X,	/* y */
      PIPE_SWIZZLE_Y,	/* u */
      PIPE_SWIZZLE_Z,	/* v */
      PIPE_SWIZZLE_W	/* ignored */
   },
      .colorspace = UTIL_FORMAT_COLORSPACE_YUV,
      .srgb_equivalent = PIPE_FORMAT_NONE,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_Y10_U10V10_422_UNORM] = {
      .format = PIPE_FORMAT_Y10_U10V10_422_UNORM,
      .name = "PIPE_FORMAT_Y10_U10V10_422_UNORM",
      .short_name = "y10_u10v10_422_unorm",
      .block = {1, 1, 1, 0},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_PLANAR2,
      .nr_channels = 0,	/* nr_channels */
      .is_array = false,	/* is_array */
      .is_bitmask = false,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = true,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
   {
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0}
   },
   {
      PIPE_SWIZZLE_X,	/* y */
      PIPE_SWIZZLE_Y,	/* u */
      PIPE_SWIZZLE_Z,	/* v */
      PIPE_SWIZZLE_W	/* ignored */
   },
      .colorspace = UTIL_FORMAT_COLORSPACE_YUV,
      .srgb_equivalent = PIPE_FORMAT_NONE,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_R8_G8B8_420_UNORM] = {
      .format = PIPE_FORMAT_R8_G8B8_420_UNORM,
      .name = "PIPE_FORMAT_R8_G8B8_420_UNORM",
      .short_name = "r8_g8b8_420_unorm",
      .block = {1, 1, 1, 8},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_PLANAR2,
      .nr_channels = 1,	/* nr_channels */
      .is_array = false,	/* is_array */
      .is_bitmask = false,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = true,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
   {
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 8, 0},	/* x = x */
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0}
   },
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_Y,	/* g */
      PIPE_SWIZZLE_Z,	/* b */
      PIPE_SWIZZLE_W	/* a */
   },
      .colorspace = UTIL_FORMAT_COLORSPACE_RGB,
      .srgb_equivalent = PIPE_FORMAT_NONE,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_R8_B8G8_420_UNORM] = {
      .format = PIPE_FORMAT_R8_B8G8_420_UNORM,
      .name = "PIPE_FORMAT_R8_B8G8_420_UNORM",
      .short_name = "r8_b8g8_420_unorm",
      .block = {1, 1, 1, 8},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_PLANAR2,
      .nr_channels = 1,	/* nr_channels */
      .is_array = false,	/* is_array */
      .is_bitmask = false,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = true,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
   {
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 8, 0},	/* x = x */
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0}
   },
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_Y,	/* g */
      PIPE_SWIZZLE_Z,	/* b */
      PIPE_SWIZZLE_W	/* a */
   },
      .colorspace = UTIL_FORMAT_COLORSPACE_RGB,
      .srgb_equivalent = PIPE_FORMAT_NONE,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_G8_B8R8_420_UNORM] = {
      .format = PIPE_FORMAT_G8_B8R8_420_UNORM,
      .name = "PIPE_FORMAT_G8_B8R8_420_UNORM",
      .short_name = "g8_b8r8_420_unorm",
      .block = {1, 1, 1, 8},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_PLANAR2,
      .nr_channels = 1,	/* nr_channels */
      .is_array = false,	/* is_array */
      .is_bitmask = false,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = true,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
   {
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 8, 0},	/* x = x */
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0}
   },
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_Y,	/* g */
      PIPE_SWIZZLE_Z,	/* b */
      PIPE_SWIZZLE_W	/* a */
   },
      .colorspace = UTIL_FORMAT_COLORSPACE_RGB,
      .srgb_equivalent = PIPE_FORMAT_NONE,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_R8_G8B8_422_UNORM] = {
      .format = PIPE_FORMAT_R8_G8B8_422_UNORM,
      .name = "PIPE_FORMAT_R8_G8B8_422_UNORM",
      .short_name = "r8_g8b8_422_unorm",
      .block = {1, 1, 1, 8},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_PLANAR2,
      .nr_channels = 1,	/* nr_channels */
      .is_array = false,	/* is_array */
      .is_bitmask = false,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = true,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
   {
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 8, 0},	/* x = x */
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0}
   },
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_Y,	/* g */
      PIPE_SWIZZLE_Z,	/* b */
      PIPE_SWIZZLE_W	/* a */
   },
      .colorspace = UTIL_FORMAT_COLORSPACE_RGB,
      .srgb_equivalent = PIPE_FORMAT_NONE,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_R8_B8G8_422_UNORM] = {
      .format = PIPE_FORMAT_R8_B8G8_422_UNORM,
      .name = "PIPE_FORMAT_R8_B8G8_422_UNORM",
      .short_name = "r8_b8g8_422_unorm",
      .block = {1, 1, 1, 8},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_PLANAR2,
      .nr_channels = 1,	/* nr_channels */
      .is_array = false,	/* is_array */
      .is_bitmask = false,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = true,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
   {
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 8, 0},	/* x = x */
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0}
   },
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_Y,	/* g */
      PIPE_SWIZZLE_Z,	/* b */
      PIPE_SWIZZLE_W	/* a */
   },
      .colorspace = UTIL_FORMAT_COLORSPACE_RGB,
      .srgb_equivalent = PIPE_FORMAT_NONE,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_G8_B8R8_422_UNORM] = {
      .format = PIPE_FORMAT_G8_B8R8_422_UNORM,
      .name = "PIPE_FORMAT_G8_B8R8_422_UNORM",
      .short_name = "g8_b8r8_422_unorm",
      .block = {1, 1, 1, 8},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_PLANAR2,
      .nr_channels = 1,	/* nr_channels */
      .is_array = false,	/* is_array */
      .is_bitmask = false,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = true,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
   {
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 8, 0},	/* x = x */
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0}
   },
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_Y,	/* g */
      PIPE_SWIZZLE_Z,	/* b */
      PIPE_SWIZZLE_W	/* a */
   },
      .colorspace = UTIL_FORMAT_COLORSPACE_RGB,
      .srgb_equivalent = PIPE_FORMAT_NONE,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_R10_G10B10_420_UNORM] = {
      .format = PIPE_FORMAT_R10_G10B10_420_UNORM,
      .name = "PIPE_FORMAT_R10_G10B10_420_UNORM",
      .short_name = "r10_g10b10_420_unorm",
      .block = {4, 1, 1, 40},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_PLANAR2,
      .nr_channels = 1,	/* nr_channels */
      .is_array = false,	/* is_array */
      .is_bitmask = false,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = true,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
   {
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 40, 0},	/* x = x */
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0}
   },
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_Y,	/* g */
      PIPE_SWIZZLE_Z,	/* b */
      PIPE_SWIZZLE_W	/* a */
   },
      .colorspace = UTIL_FORMAT_COLORSPACE_RGB,
      .srgb_equivalent = PIPE_FORMAT_NONE,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_R10_G10B10_422_UNORM] = {
      .format = PIPE_FORMAT_R10_G10B10_422_UNORM,
      .name = "PIPE_FORMAT_R10_G10B10_422_UNORM",
      .short_name = "r10_g10b10_422_unorm",
      .block = {4, 1, 1, 40},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_PLANAR2,
      .nr_channels = 1,	/* nr_channels */
      .is_array = false,	/* is_array */
      .is_bitmask = false,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = true,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
   {
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 40, 0},	/* x = x */
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0}
   },
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_Y,	/* g */
      PIPE_SWIZZLE_Z,	/* b */
      PIPE_SWIZZLE_W	/* a */
   },
      .colorspace = UTIL_FORMAT_COLORSPACE_RGB,
      .srgb_equivalent = PIPE_FORMAT_NONE,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_R8_G8_B8_420_UNORM] = {
      .format = PIPE_FORMAT_R8_G8_B8_420_UNORM,
      .name = "PIPE_FORMAT_R8_G8_B8_420_UNORM",
      .short_name = "r8_g8_b8_420_unorm",
      .block = {1, 1, 1, 8},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_PLANAR3,
      .nr_channels = 1,	/* nr_channels */
      .is_array = false,	/* is_array */
      .is_bitmask = false,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = true,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
   {
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 8, 0},	/* x = x */
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0}
   },
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_Y,	/* g */
      PIPE_SWIZZLE_Z,	/* b */
      PIPE_SWIZZLE_W	/* a */
   },
      .colorspace = UTIL_FORMAT_COLORSPACE_RGB,
      .srgb_equivalent = PIPE_FORMAT_NONE,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_R8_B8_G8_420_UNORM] = {
      .format = PIPE_FORMAT_R8_B8_G8_420_UNORM,
      .name = "PIPE_FORMAT_R8_B8_G8_420_UNORM",
      .short_name = "r8_b8_g8_420_unorm",
      .block = {1, 1, 1, 8},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_PLANAR3,
      .nr_channels = 1,	/* nr_channels */
      .is_array = false,	/* is_array */
      .is_bitmask = false,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = true,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
   {
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 8, 0},	/* x = x */
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0}
   },
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_Y,	/* g */
      PIPE_SWIZZLE_Z,	/* b */
      PIPE_SWIZZLE_W	/* a */
   },
      .colorspace = UTIL_FORMAT_COLORSPACE_RGB,
      .srgb_equivalent = PIPE_FORMAT_NONE,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_G8_B8_R8_420_UNORM] = {
      .format = PIPE_FORMAT_G8_B8_R8_420_UNORM,
      .name = "PIPE_FORMAT_G8_B8_R8_420_UNORM",
      .short_name = "g8_b8_r8_420_unorm",
      .block = {1, 1, 1, 8},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_PLANAR3,
      .nr_channels = 1,	/* nr_channels */
      .is_array = false,	/* is_array */
      .is_bitmask = false,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = true,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
   {
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 8, 0},	/* x = x */
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0}
   },
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_Y,	/* g */
      PIPE_SWIZZLE_Z,	/* b */
      PIPE_SWIZZLE_W	/* a */
   },
      .colorspace = UTIL_FORMAT_COLORSPACE_RGB,
      .srgb_equivalent = PIPE_FORMAT_NONE,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_R8_G8_B8_444_UNORM] = {
      .format = PIPE_FORMAT_R8_G8_B8_444_UNORM,
      .name = "PIPE_FORMAT_R8_G8_B8_444_UNORM",
      .short_name = "r8_g8_b8_444_unorm",
      .block = {1, 1, 1, 8},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_PLANAR3,
      .nr_channels = 1,	/* nr_channels */
      .is_array = false,	/* is_array */
      .is_bitmask = false,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = true,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
   {
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 8, 0},	/* x = x */
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0}
   },
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_Y,	/* g */
      PIPE_SWIZZLE_Z,	/* b */
      PIPE_SWIZZLE_W	/* a */
   },
      .colorspace = UTIL_FORMAT_COLORSPACE_RGB,
      .srgb_equivalent = PIPE_FORMAT_NONE,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_X6G10_X6B10X6R10_420_UNORM] = {
      .format = PIPE_FORMAT_X6G10_X6B10X6R10_420_UNORM,
      .name = "PIPE_FORMAT_X6G10_X6B10X6R10_420_UNORM",
      .short_name = "x6g10_x6b10x6r10_420_unorm",
      .block = {1, 1, 1, 16},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_PLANAR2,
      .nr_channels = 2,	/* nr_channels */
      .is_array = false,	/* is_array */
      .is_bitmask = false,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = true,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
#if UTIL_ARCH_BIG_ENDIAN
   {
      {UTIL_FORMAT_TYPE_VOID, false, false, 6, 10},	/* x = x */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 10, 0},	/* y = y */
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0}
   },
#else
   {
      {UTIL_FORMAT_TYPE_VOID, false, false, 6, 0},	/* x = x */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 10, 6},	/* y = y */
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0}
   },
#endif
#if UTIL_ARCH_BIG_ENDIAN
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_Y,	/* g */
      PIPE_SWIZZLE_Z,	/* b */
      PIPE_SWIZZLE_W	/* a */
   },
#else
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_Y,	/* g */
      PIPE_SWIZZLE_Z,	/* b */
      PIPE_SWIZZLE_W	/* a */
   },
#endif
      .colorspace = UTIL_FORMAT_COLORSPACE_RGB,
      .srgb_equivalent = PIPE_FORMAT_NONE,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_X4G12_X4B12X4R12_420_UNORM] = {
      .format = PIPE_FORMAT_X4G12_X4B12X4R12_420_UNORM,
      .name = "PIPE_FORMAT_X4G12_X4B12X4R12_420_UNORM",
      .short_name = "x4g12_x4b12x4r12_420_unorm",
      .block = {1, 1, 1, 16},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_PLANAR2,
      .nr_channels = 2,	/* nr_channels */
      .is_array = false,	/* is_array */
      .is_bitmask = false,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = true,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
#if UTIL_ARCH_BIG_ENDIAN
   {
      {UTIL_FORMAT_TYPE_VOID, false, false, 4, 12},	/* x = x */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 12, 0},	/* y = y */
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0}
   },
#else
   {
      {UTIL_FORMAT_TYPE_VOID, false, false, 4, 0},	/* x = x */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 12, 4},	/* y = y */
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0}
   },
#endif
#if UTIL_ARCH_BIG_ENDIAN
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_Y,	/* g */
      PIPE_SWIZZLE_Z,	/* b */
      PIPE_SWIZZLE_W	/* a */
   },
#else
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_Y,	/* g */
      PIPE_SWIZZLE_Z,	/* b */
      PIPE_SWIZZLE_W	/* a */
   },
#endif
      .colorspace = UTIL_FORMAT_COLORSPACE_RGB,
      .srgb_equivalent = PIPE_FORMAT_NONE,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_R8G8B8_420_UNORM_PACKED] = {
      .format = PIPE_FORMAT_R8G8B8_420_UNORM_PACKED,
      .name = "PIPE_FORMAT_R8G8B8_420_UNORM_PACKED",
      .short_name = "r8g8b8_420_unorm_packed",
      .block = {2, 2, 1, 48},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_SUBSAMPLED,
      .nr_channels = 1,	/* nr_channels */
      .is_array = false,	/* is_array */
      .is_bitmask = false,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = true,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
   {
      {UTIL_FORMAT_TYPE_VOID, false, false, 48, 0},	/* x = x */
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0}
   },
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_Y,	/* g */
      PIPE_SWIZZLE_Z,	/* b */
      PIPE_SWIZZLE_1	/* a */
   },
      .colorspace = UTIL_FORMAT_COLORSPACE_RGB,
      .srgb_equivalent = PIPE_FORMAT_NONE,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_R10G10B10_420_UNORM_PACKED] = {
      .format = PIPE_FORMAT_R10G10B10_420_UNORM_PACKED,
      .name = "PIPE_FORMAT_R10G10B10_420_UNORM_PACKED",
      .short_name = "r10g10b10_420_unorm_packed",
      .block = {4, 2, 1, 120},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_SUBSAMPLED,
      .nr_channels = 1,	/* nr_channels */
      .is_array = false,	/* is_array */
      .is_bitmask = false,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = true,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
   {
      {UTIL_FORMAT_TYPE_VOID, false, false, 120, 0},	/* x = x */
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0}
   },
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_Y,	/* g */
      PIPE_SWIZZLE_Z,	/* b */
      PIPE_SWIZZLE_1	/* a */
   },
      .colorspace = UTIL_FORMAT_COLORSPACE_RGB,
      .srgb_equivalent = PIPE_FORMAT_NONE,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_Y8_UNORM] = {
      .format = PIPE_FORMAT_Y8_UNORM,
      .name = "PIPE_FORMAT_Y8_UNORM",
      .short_name = "y8_unorm",
      .block = {1, 1, 1, 8},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_OTHER,
      .nr_channels = 1,	/* nr_channels */
      .is_array = false,	/* is_array */
      .is_bitmask = false,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = true,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
   {
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 8, 0},	/* x = x */
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0}
   },
   {
      PIPE_SWIZZLE_X,	/* y */
      PIPE_SWIZZLE_0,	/* u */
      PIPE_SWIZZLE_0,	/* v */
      PIPE_SWIZZLE_1	/* ignored */
   },
      .colorspace = UTIL_FORMAT_COLORSPACE_YUV,
      .srgb_equivalent = PIPE_FORMAT_NONE,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_X6R10_UNORM] = {
      .format = PIPE_FORMAT_X6R10_UNORM,
      .name = "PIPE_FORMAT_X6R10_UNORM",
      .short_name = "x6r10_unorm",
      .block = {1, 1, 1, 16},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_PLAIN,
      .nr_channels = 2,	/* nr_channels */
      .is_array = false,	/* is_array */
      .is_bitmask = true,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = true,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
#if UTIL_ARCH_BIG_ENDIAN
   {
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 10, 6},	/* x = r */
      {UTIL_FORMAT_TYPE_VOID, false, false, 6, 0},	/* y = x */
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0}
   },
#else
   {
      {UTIL_FORMAT_TYPE_VOID, false, false, 6, 0},	/* x = x */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 10, 6},	/* y = r */
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0}
   },
#endif
#if UTIL_ARCH_BIG_ENDIAN
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_0,	/* g */
      PIPE_SWIZZLE_0,	/* b */
      PIPE_SWIZZLE_1	/* a */
   },
#else
   {
      PIPE_SWIZZLE_Y,	/* r */
      PIPE_SWIZZLE_0,	/* g */
      PIPE_SWIZZLE_0,	/* b */
      PIPE_SWIZZLE_1	/* a */
   },
#endif
      .colorspace = UTIL_FORMAT_COLORSPACE_RGB,
      .srgb_equivalent = PIPE_FORMAT_NONE,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_X6R10X6G10_UNORM] = {
      .format = PIPE_FORMAT_X6R10X6G10_UNORM,
      .name = "PIPE_FORMAT_X6R10X6G10_UNORM",
      .short_name = "x6r10x6g10_unorm",
      .block = {1, 1, 1, 32},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_PLAIN,
      .nr_channels = 4,	/* nr_channels */
      .is_array = false,	/* is_array */
      .is_bitmask = true,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = true,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
#if UTIL_ARCH_BIG_ENDIAN
   {
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 10, 22},	/* x = g */
      {UTIL_FORMAT_TYPE_VOID, false, false, 6, 16},	/* y = x */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 10, 6},	/* z = r */
      {UTIL_FORMAT_TYPE_VOID, false, false, 6, 0}	/* w = x */
   },
#else
   {
      {UTIL_FORMAT_TYPE_VOID, false, false, 6, 0},	/* x = x */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 10, 6},	/* y = r */
      {UTIL_FORMAT_TYPE_VOID, false, false, 6, 16},	/* z = x */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 10, 22}	/* w = g */
   },
#endif
#if UTIL_ARCH_BIG_ENDIAN
   {
      PIPE_SWIZZLE_Z,	/* r */
      PIPE_SWIZZLE_X,	/* g */
      PIPE_SWIZZLE_0,	/* b */
      PIPE_SWIZZLE_1	/* a */
   },
#else
   {
      PIPE_SWIZZLE_Y,	/* r */
      PIPE_SWIZZLE_W,	/* g */
      PIPE_SWIZZLE_0,	/* b */
      PIPE_SWIZZLE_1	/* a */
   },
#endif
      .colorspace = UTIL_FORMAT_COLORSPACE_RGB,
      .srgb_equivalent = PIPE_FORMAT_NONE,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_X4R12_UNORM] = {
      .format = PIPE_FORMAT_X4R12_UNORM,
      .name = "PIPE_FORMAT_X4R12_UNORM",
      .short_name = "x4r12_unorm",
      .block = {1, 1, 1, 16},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_PLAIN,
      .nr_channels = 2,	/* nr_channels */
      .is_array = false,	/* is_array */
      .is_bitmask = true,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = true,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
#if UTIL_ARCH_BIG_ENDIAN
   {
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 12, 4},	/* x = r */
      {UTIL_FORMAT_TYPE_VOID, false, false, 4, 0},	/* y = x */
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0}
   },
#else
   {
      {UTIL_FORMAT_TYPE_VOID, false, false, 4, 0},	/* x = x */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 12, 4},	/* y = r */
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0}
   },
#endif
#if UTIL_ARCH_BIG_ENDIAN
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_0,	/* g */
      PIPE_SWIZZLE_0,	/* b */
      PIPE_SWIZZLE_1	/* a */
   },
#else
   {
      PIPE_SWIZZLE_Y,	/* r */
      PIPE_SWIZZLE_0,	/* g */
      PIPE_SWIZZLE_0,	/* b */
      PIPE_SWIZZLE_1	/* a */
   },
#endif
      .colorspace = UTIL_FORMAT_COLORSPACE_RGB,
      .srgb_equivalent = PIPE_FORMAT_NONE,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_X4R12X4G12_UNORM] = {
      .format = PIPE_FORMAT_X4R12X4G12_UNORM,
      .name = "PIPE_FORMAT_X4R12X4G12_UNORM",
      .short_name = "x4r12x4g12_unorm",
      .block = {1, 1, 1, 32},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_PLAIN,
      .nr_channels = 4,	/* nr_channels */
      .is_array = false,	/* is_array */
      .is_bitmask = true,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = true,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
#if UTIL_ARCH_BIG_ENDIAN
   {
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 12, 20},	/* x = g */
      {UTIL_FORMAT_TYPE_VOID, false, false, 4, 16},	/* y = x */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 12, 4},	/* z = r */
      {UTIL_FORMAT_TYPE_VOID, false, false, 4, 0}	/* w = x */
   },
#else
   {
      {UTIL_FORMAT_TYPE_VOID, false, false, 4, 0},	/* x = x */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 12, 4},	/* y = r */
      {UTIL_FORMAT_TYPE_VOID, false, false, 4, 16},	/* z = x */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 12, 20}	/* w = g */
   },
#endif
#if UTIL_ARCH_BIG_ENDIAN
   {
      PIPE_SWIZZLE_Z,	/* r */
      PIPE_SWIZZLE_X,	/* g */
      PIPE_SWIZZLE_0,	/* b */
      PIPE_SWIZZLE_1	/* a */
   },
#else
   {
      PIPE_SWIZZLE_Y,	/* r */
      PIPE_SWIZZLE_W,	/* g */
      PIPE_SWIZZLE_0,	/* b */
      PIPE_SWIZZLE_1	/* a */
   },
#endif
      .colorspace = UTIL_FORMAT_COLORSPACE_RGB,
      .srgb_equivalent = PIPE_FORMAT_NONE,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_Y8_U8_V8_422_UNORM] = {
      .format = PIPE_FORMAT_Y8_U8_V8_422_UNORM,
      .name = "PIPE_FORMAT_Y8_U8_V8_422_UNORM",
      .short_name = "y8_u8_v8_422_unorm",
      .block = {1, 1, 1, 0},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_PLANAR3,
      .nr_channels = 0,	/* nr_channels */
      .is_array = false,	/* is_array */
      .is_bitmask = false,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = true,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
   {
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0}
   },
   {
      PIPE_SWIZZLE_X,	/* y */
      PIPE_SWIZZLE_Y,	/* u */
      PIPE_SWIZZLE_Z,	/* v */
      PIPE_SWIZZLE_W	/* ignored */
   },
      .colorspace = UTIL_FORMAT_COLORSPACE_YUV,
      .srgb_equivalent = PIPE_FORMAT_NONE,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_Y8_U8V8_422_UNORM] = {
      .format = PIPE_FORMAT_Y8_U8V8_422_UNORM,
      .name = "PIPE_FORMAT_Y8_U8V8_422_UNORM",
      .short_name = "y8_u8v8_422_unorm",
      .block = {1, 1, 1, 0},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_PLANAR2,
      .nr_channels = 0,	/* nr_channels */
      .is_array = false,	/* is_array */
      .is_bitmask = false,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = true,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
   {
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0}
   },
   {
      PIPE_SWIZZLE_X,	/* y */
      PIPE_SWIZZLE_Y,	/* u */
      PIPE_SWIZZLE_Z,	/* v */
      PIPE_SWIZZLE_W	/* ignored */
   },
      .colorspace = UTIL_FORMAT_COLORSPACE_YUV,
      .srgb_equivalent = PIPE_FORMAT_NONE,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_Y8_U8_V8_444_UNORM] = {
      .format = PIPE_FORMAT_Y8_U8_V8_444_UNORM,
      .name = "PIPE_FORMAT_Y8_U8_V8_444_UNORM",
      .short_name = "y8_u8_v8_444_unorm",
      .block = {1, 1, 1, 0},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_PLANAR3,
      .nr_channels = 0,	/* nr_channels */
      .is_array = false,	/* is_array */
      .is_bitmask = false,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = true,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
   {
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0}
   },
   {
      PIPE_SWIZZLE_X,	/* y */
      PIPE_SWIZZLE_Y,	/* u */
      PIPE_SWIZZLE_Z,	/* v */
      PIPE_SWIZZLE_W	/* ignored */
   },
      .colorspace = UTIL_FORMAT_COLORSPACE_YUV,
      .srgb_equivalent = PIPE_FORMAT_NONE,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_Y8_U8_V8_440_UNORM] = {
      .format = PIPE_FORMAT_Y8_U8_V8_440_UNORM,
      .name = "PIPE_FORMAT_Y8_U8_V8_440_UNORM",
      .short_name = "y8_u8_v8_440_unorm",
      .block = {1, 1, 1, 0},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_PLANAR3,
      .nr_channels = 0,	/* nr_channels */
      .is_array = false,	/* is_array */
      .is_bitmask = false,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = true,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
   {
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0}
   },
   {
      PIPE_SWIZZLE_X,	/* y */
      PIPE_SWIZZLE_Y,	/* u */
      PIPE_SWIZZLE_Z,	/* v */
      PIPE_SWIZZLE_W	/* ignored */
   },
      .colorspace = UTIL_FORMAT_COLORSPACE_YUV,
      .srgb_equivalent = PIPE_FORMAT_NONE,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_Y10X6_U10X6_V10X6_420_UNORM] = {
      .format = PIPE_FORMAT_Y10X6_U10X6_V10X6_420_UNORM,
      .name = "PIPE_FORMAT_Y10X6_U10X6_V10X6_420_UNORM",
      .short_name = "y10x6_u10x6_v10x6_420_unorm",
      .block = {1, 1, 1, 0},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_PLANAR3,
      .nr_channels = 0,	/* nr_channels */
      .is_array = false,	/* is_array */
      .is_bitmask = false,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = true,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
   {
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0}
   },
   {
      PIPE_SWIZZLE_X,	/* y */
      PIPE_SWIZZLE_Y,	/* u */
      PIPE_SWIZZLE_Z,	/* v */
      PIPE_SWIZZLE_W	/* ignored */
   },
      .colorspace = UTIL_FORMAT_COLORSPACE_YUV,
      .srgb_equivalent = PIPE_FORMAT_NONE,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_Y12X4_U12X4_V12X4_420_UNORM] = {
      .format = PIPE_FORMAT_Y12X4_U12X4_V12X4_420_UNORM,
      .name = "PIPE_FORMAT_Y12X4_U12X4_V12X4_420_UNORM",
      .short_name = "y12x4_u12x4_v12x4_420_unorm",
      .block = {1, 1, 1, 0},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_PLANAR3,
      .nr_channels = 0,	/* nr_channels */
      .is_array = false,	/* is_array */
      .is_bitmask = false,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = true,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
   {
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0}
   },
   {
      PIPE_SWIZZLE_X,	/* y */
      PIPE_SWIZZLE_Y,	/* u */
      PIPE_SWIZZLE_Z,	/* v */
      PIPE_SWIZZLE_W	/* ignored */
   },
      .colorspace = UTIL_FORMAT_COLORSPACE_YUV,
      .srgb_equivalent = PIPE_FORMAT_NONE,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_Y16_U16_V16_420_UNORM] = {
      .format = PIPE_FORMAT_Y16_U16_V16_420_UNORM,
      .name = "PIPE_FORMAT_Y16_U16_V16_420_UNORM",
      .short_name = "y16_u16_v16_420_unorm",
      .block = {1, 1, 1, 0},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_PLANAR3,
      .nr_channels = 0,	/* nr_channels */
      .is_array = false,	/* is_array */
      .is_bitmask = false,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = true,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
   {
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0}
   },
   {
      PIPE_SWIZZLE_X,	/* y */
      PIPE_SWIZZLE_Y,	/* u */
      PIPE_SWIZZLE_Z,	/* v */
      PIPE_SWIZZLE_W	/* ignored */
   },
      .colorspace = UTIL_FORMAT_COLORSPACE_YUV,
      .srgb_equivalent = PIPE_FORMAT_NONE,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_Y10X6_U10X6_V10X6_422_UNORM] = {
      .format = PIPE_FORMAT_Y10X6_U10X6_V10X6_422_UNORM,
      .name = "PIPE_FORMAT_Y10X6_U10X6_V10X6_422_UNORM",
      .short_name = "y10x6_u10x6_v10x6_422_unorm",
      .block = {1, 1, 1, 0},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_PLANAR3,
      .nr_channels = 0,	/* nr_channels */
      .is_array = false,	/* is_array */
      .is_bitmask = false,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = true,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
   {
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0}
   },
   {
      PIPE_SWIZZLE_X,	/* y */
      PIPE_SWIZZLE_Y,	/* u */
      PIPE_SWIZZLE_Z,	/* v */
      PIPE_SWIZZLE_W	/* ignored */
   },
      .colorspace = UTIL_FORMAT_COLORSPACE_YUV,
      .srgb_equivalent = PIPE_FORMAT_NONE,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_Y12X4_U12X4_V12X4_422_UNORM] = {
      .format = PIPE_FORMAT_Y12X4_U12X4_V12X4_422_UNORM,
      .name = "PIPE_FORMAT_Y12X4_U12X4_V12X4_422_UNORM",
      .short_name = "y12x4_u12x4_v12x4_422_unorm",
      .block = {1, 1, 1, 0},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_PLANAR3,
      .nr_channels = 0,	/* nr_channels */
      .is_array = false,	/* is_array */
      .is_bitmask = false,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = true,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
   {
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0}
   },
   {
      PIPE_SWIZZLE_X,	/* y */
      PIPE_SWIZZLE_Y,	/* u */
      PIPE_SWIZZLE_Z,	/* v */
      PIPE_SWIZZLE_W	/* ignored */
   },
      .colorspace = UTIL_FORMAT_COLORSPACE_YUV,
      .srgb_equivalent = PIPE_FORMAT_NONE,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_Y16_U16_V16_422_UNORM] = {
      .format = PIPE_FORMAT_Y16_U16_V16_422_UNORM,
      .name = "PIPE_FORMAT_Y16_U16_V16_422_UNORM",
      .short_name = "y16_u16_v16_422_unorm",
      .block = {1, 1, 1, 0},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_PLANAR3,
      .nr_channels = 0,	/* nr_channels */
      .is_array = false,	/* is_array */
      .is_bitmask = false,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = true,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
   {
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0}
   },
   {
      PIPE_SWIZZLE_X,	/* y */
      PIPE_SWIZZLE_Y,	/* u */
      PIPE_SWIZZLE_Z,	/* v */
      PIPE_SWIZZLE_W	/* ignored */
   },
      .colorspace = UTIL_FORMAT_COLORSPACE_YUV,
      .srgb_equivalent = PIPE_FORMAT_NONE,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_Y10X6_U10X6_V10X6_444_UNORM] = {
      .format = PIPE_FORMAT_Y10X6_U10X6_V10X6_444_UNORM,
      .name = "PIPE_FORMAT_Y10X6_U10X6_V10X6_444_UNORM",
      .short_name = "y10x6_u10x6_v10x6_444_unorm",
      .block = {1, 1, 1, 0},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_PLANAR3,
      .nr_channels = 0,	/* nr_channels */
      .is_array = false,	/* is_array */
      .is_bitmask = false,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = true,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
   {
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0}
   },
   {
      PIPE_SWIZZLE_X,	/* y */
      PIPE_SWIZZLE_Y,	/* u */
      PIPE_SWIZZLE_Z,	/* v */
      PIPE_SWIZZLE_W	/* ignored */
   },
      .colorspace = UTIL_FORMAT_COLORSPACE_YUV,
      .srgb_equivalent = PIPE_FORMAT_NONE,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_Y12X4_U12X4_V12X4_444_UNORM] = {
      .format = PIPE_FORMAT_Y12X4_U12X4_V12X4_444_UNORM,
      .name = "PIPE_FORMAT_Y12X4_U12X4_V12X4_444_UNORM",
      .short_name = "y12x4_u12x4_v12x4_444_unorm",
      .block = {1, 1, 1, 0},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_PLANAR3,
      .nr_channels = 0,	/* nr_channels */
      .is_array = false,	/* is_array */
      .is_bitmask = false,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = true,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
   {
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0}
   },
   {
      PIPE_SWIZZLE_X,	/* y */
      PIPE_SWIZZLE_Y,	/* u */
      PIPE_SWIZZLE_Z,	/* v */
      PIPE_SWIZZLE_W	/* ignored */
   },
      .colorspace = UTIL_FORMAT_COLORSPACE_YUV,
      .srgb_equivalent = PIPE_FORMAT_NONE,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_Y16_U16_V16_444_UNORM] = {
      .format = PIPE_FORMAT_Y16_U16_V16_444_UNORM,
      .name = "PIPE_FORMAT_Y16_U16_V16_444_UNORM",
      .short_name = "y16_u16_v16_444_unorm",
      .block = {1, 1, 1, 0},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_PLANAR3,
      .nr_channels = 0,	/* nr_channels */
      .is_array = false,	/* is_array */
      .is_bitmask = false,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = true,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
   {
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0}
   },
   {
      PIPE_SWIZZLE_X,	/* y */
      PIPE_SWIZZLE_Y,	/* u */
      PIPE_SWIZZLE_Z,	/* v */
      PIPE_SWIZZLE_W	/* ignored */
   },
      .colorspace = UTIL_FORMAT_COLORSPACE_YUV,
      .srgb_equivalent = PIPE_FORMAT_NONE,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_Y16_U16V16_422_UNORM] = {
      .format = PIPE_FORMAT_Y16_U16V16_422_UNORM,
      .name = "PIPE_FORMAT_Y16_U16V16_422_UNORM",
      .short_name = "y16_u16v16_422_unorm",
      .block = {1, 1, 1, 0},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_PLANAR2,
      .nr_channels = 0,	/* nr_channels */
      .is_array = false,	/* is_array */
      .is_bitmask = false,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = true,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
   {
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0}
   },
   {
      PIPE_SWIZZLE_X,	/* y */
      PIPE_SWIZZLE_Y,	/* u */
      PIPE_SWIZZLE_Z,	/* v */
      PIPE_SWIZZLE_W	/* ignored */
   },
      .colorspace = UTIL_FORMAT_COLORSPACE_YUV,
      .srgb_equivalent = PIPE_FORMAT_NONE,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_X6Y10_X6U10X6V10_420_UNORM] = {
      .format = PIPE_FORMAT_X6Y10_X6U10X6V10_420_UNORM,
      .name = "PIPE_FORMAT_X6Y10_X6U10X6V10_420_UNORM",
      .short_name = "x6y10_x6u10x6v10_420_unorm",
      .block = {1, 1, 1, 0},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_PLANAR2,
      .nr_channels = 0,	/* nr_channels */
      .is_array = false,	/* is_array */
      .is_bitmask = false,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = true,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
   {
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0}
   },
   {
      PIPE_SWIZZLE_X,	/* y */
      PIPE_SWIZZLE_Y,	/* u */
      PIPE_SWIZZLE_Z,	/* v */
      PIPE_SWIZZLE_W	/* ignored */
   },
      .colorspace = UTIL_FORMAT_COLORSPACE_YUV,
      .srgb_equivalent = PIPE_FORMAT_NONE,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_X4Y12_X4U12X4V12_420_UNORM] = {
      .format = PIPE_FORMAT_X4Y12_X4U12X4V12_420_UNORM,
      .name = "PIPE_FORMAT_X4Y12_X4U12X4V12_420_UNORM",
      .short_name = "x4y12_x4u12x4v12_420_unorm",
      .block = {1, 1, 1, 0},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_PLANAR2,
      .nr_channels = 0,	/* nr_channels */
      .is_array = false,	/* is_array */
      .is_bitmask = false,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = true,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
   {
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0}
   },
   {
      PIPE_SWIZZLE_X,	/* y */
      PIPE_SWIZZLE_Y,	/* u */
      PIPE_SWIZZLE_Z,	/* v */
      PIPE_SWIZZLE_W	/* ignored */
   },
      .colorspace = UTIL_FORMAT_COLORSPACE_YUV,
      .srgb_equivalent = PIPE_FORMAT_NONE,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_Y16_U16V16_420_UNORM] = {
      .format = PIPE_FORMAT_Y16_U16V16_420_UNORM,
      .name = "PIPE_FORMAT_Y16_U16V16_420_UNORM",
      .short_name = "y16_u16v16_420_unorm",
      .block = {1, 1, 1, 0},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_PLANAR2,
      .nr_channels = 0,	/* nr_channels */
      .is_array = false,	/* is_array */
      .is_bitmask = false,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = true,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
   {
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0}
   },
   {
      PIPE_SWIZZLE_X,	/* y */
      PIPE_SWIZZLE_Y,	/* u */
      PIPE_SWIZZLE_Z,	/* v */
      PIPE_SWIZZLE_W	/* ignored */
   },
      .colorspace = UTIL_FORMAT_COLORSPACE_YUV,
      .srgb_equivalent = PIPE_FORMAT_NONE,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_Y10Y10Y10X2_U10V10U10X2V10U10V10X2_420_UNORM] = {
      .format = PIPE_FORMAT_Y10Y10Y10X2_U10V10U10X2V10U10V10X2_420_UNORM,
      .name = "PIPE_FORMAT_Y10Y10Y10X2_U10V10U10X2V10U10V10X2_420_UNORM",
      .short_name = "y10y10y10x2_u10v10u10x2v10u10v10x2_420_unorm",
      .block = {1, 1, 1, 0},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_PLANAR2,
      .nr_channels = 0,	/* nr_channels */
      .is_array = false,	/* is_array */
      .is_bitmask = false,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = true,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
   {
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0}
   },
   {
      PIPE_SWIZZLE_X,	/* y */
      PIPE_SWIZZLE_Y,	/* u */
      PIPE_SWIZZLE_Z,	/* v */
      PIPE_SWIZZLE_W	/* ignored */
   },
      .colorspace = UTIL_FORMAT_COLORSPACE_YUV,
      .srgb_equivalent = PIPE_FORMAT_NONE,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_X6Y10X6U10X6Y10X6V10_422_UNORM] = {
      .format = PIPE_FORMAT_X6Y10X6U10X6Y10X6V10_422_UNORM,
      .name = "PIPE_FORMAT_X6Y10X6U10X6Y10X6V10_422_UNORM",
      .short_name = "x6y10x6u10x6y10x6v10_422_unorm",
      .block = {2, 1, 1, 64},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_SUBSAMPLED,
      .nr_channels = 1,	/* nr_channels */
      .is_array = false,	/* is_array */
      .is_bitmask = false,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = true,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
   {
      {UTIL_FORMAT_TYPE_VOID, false, false, 64, 0},	/* x = x */
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0}
   },
   {
      PIPE_SWIZZLE_X,	/* y */
      PIPE_SWIZZLE_Y,	/* u */
      PIPE_SWIZZLE_Z,	/* v */
      PIPE_SWIZZLE_1	/* ignored */
   },
      .colorspace = UTIL_FORMAT_COLORSPACE_YUV,
      .srgb_equivalent = PIPE_FORMAT_NONE,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_X4Y12X4U12X4Y12X4V12_422_UNORM] = {
      .format = PIPE_FORMAT_X4Y12X4U12X4Y12X4V12_422_UNORM,
      .name = "PIPE_FORMAT_X4Y12X4U12X4Y12X4V12_422_UNORM",
      .short_name = "x4y12x4u12x4y12x4v12_422_unorm",
      .block = {2, 1, 1, 64},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_SUBSAMPLED,
      .nr_channels = 1,	/* nr_channels */
      .is_array = false,	/* is_array */
      .is_bitmask = false,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = true,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
   {
      {UTIL_FORMAT_TYPE_VOID, false, false, 64, 0},	/* x = x */
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0}
   },
   {
      PIPE_SWIZZLE_X,	/* y */
      PIPE_SWIZZLE_Y,	/* u */
      PIPE_SWIZZLE_Z,	/* v */
      PIPE_SWIZZLE_1	/* ignored */
   },
      .colorspace = UTIL_FORMAT_COLORSPACE_YUV,
      .srgb_equivalent = PIPE_FORMAT_NONE,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_Y16U16Y16V16_422_UNORM] = {
      .format = PIPE_FORMAT_Y16U16Y16V16_422_UNORM,
      .name = "PIPE_FORMAT_Y16U16Y16V16_422_UNORM",
      .short_name = "y16u16y16v16_422_unorm",
      .block = {2, 1, 1, 64},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_SUBSAMPLED,
      .nr_channels = 1,	/* nr_channels */
      .is_array = false,	/* is_array */
      .is_bitmask = false,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = true,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
   {
      {UTIL_FORMAT_TYPE_VOID, false, false, 64, 0},	/* x = x */
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0}
   },
   {
      PIPE_SWIZZLE_X,	/* y */
      PIPE_SWIZZLE_Y,	/* u */
      PIPE_SWIZZLE_Z,	/* v */
      PIPE_SWIZZLE_1	/* ignored */
   },
      .colorspace = UTIL_FORMAT_COLORSPACE_YUV,
      .srgb_equivalent = PIPE_FORMAT_NONE,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_U10Y10V10A2_444_UNORM] = {
      .format = PIPE_FORMAT_U10Y10V10A2_444_UNORM,
      .name = "PIPE_FORMAT_U10Y10V10A2_444_UNORM",
      .short_name = "u10y10v10a2_444_unorm",
      .block = {1, 1, 1, 32},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_OTHER,
      .nr_channels = 4,	/* nr_channels */
      .is_array = false,	/* is_array */
      .is_bitmask = false,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = true,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
#if UTIL_ARCH_BIG_ENDIAN
   {
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 10, 22},	/* x = x */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 10, 12},	/* y = y */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 10, 2},	/* z = z */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 2, 0}	/* w = w */
   },
#else
   {
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 10, 0},	/* x = x */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 10, 10},	/* y = y */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 10, 20},	/* z = z */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 2, 30}	/* w = w */
   },
#endif
#if UTIL_ARCH_BIG_ENDIAN
   {
      PIPE_SWIZZLE_Y,	/* y */
      PIPE_SWIZZLE_Z,	/* u */
      PIPE_SWIZZLE_X,	/* v */
      PIPE_SWIZZLE_W	/* ignored */
   },
#else
   {
      PIPE_SWIZZLE_Y,	/* y */
      PIPE_SWIZZLE_Z,	/* u */
      PIPE_SWIZZLE_X,	/* v */
      PIPE_SWIZZLE_W	/* ignored */
   },
#endif
      .colorspace = UTIL_FORMAT_COLORSPACE_YUV,
      .srgb_equivalent = PIPE_FORMAT_NONE,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_X4U12X4Y12X4V12X4A12_444_UNORM] = {
      .format = PIPE_FORMAT_X4U12X4Y12X4V12X4A12_444_UNORM,
      .name = "PIPE_FORMAT_X4U12X4Y12X4V12X4A12_444_UNORM",
      .short_name = "x4u12x4y12x4v12x4a12_444_unorm",
      .block = {1, 1, 1, 64},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_OTHER,
      .nr_channels = 4,	/* nr_channels */
      .is_array = false,	/* is_array */
      .is_bitmask = false,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = true,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
#if UTIL_ARCH_BIG_ENDIAN
   {
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 16, 48},	/* x = x */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 16, 32},	/* y = y */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 16, 16},	/* z = z */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 16, 0}	/* w = w */
   },
#else
   {
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 16, 0},	/* x = x */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 16, 16},	/* y = y */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 16, 32},	/* z = z */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 16, 48}	/* w = w */
   },
#endif
#if UTIL_ARCH_BIG_ENDIAN
   {
      PIPE_SWIZZLE_Y,	/* y */
      PIPE_SWIZZLE_Z,	/* u */
      PIPE_SWIZZLE_X,	/* v */
      PIPE_SWIZZLE_W	/* ignored */
   },
#else
   {
      PIPE_SWIZZLE_Y,	/* y */
      PIPE_SWIZZLE_Z,	/* u */
      PIPE_SWIZZLE_X,	/* v */
      PIPE_SWIZZLE_W	/* ignored */
   },
#endif
      .colorspace = UTIL_FORMAT_COLORSPACE_YUV,
      .srgb_equivalent = PIPE_FORMAT_NONE,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_U16Y16V16A16_444_UNORM] = {
      .format = PIPE_FORMAT_U16Y16V16A16_444_UNORM,
      .name = "PIPE_FORMAT_U16Y16V16A16_444_UNORM",
      .short_name = "u16y16v16a16_444_unorm",
      .block = {1, 1, 1, 64},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_OTHER,
      .nr_channels = 4,	/* nr_channels */
      .is_array = false,	/* is_array */
      .is_bitmask = false,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = true,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
#if UTIL_ARCH_BIG_ENDIAN
   {
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 16, 48},	/* x = x */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 16, 32},	/* y = y */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 16, 16},	/* z = z */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 16, 0}	/* w = w */
   },
#else
   {
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 16, 0},	/* x = x */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 16, 16},	/* y = y */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 16, 32},	/* z = z */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 16, 48}	/* w = w */
   },
#endif
#if UTIL_ARCH_BIG_ENDIAN
   {
      PIPE_SWIZZLE_Y,	/* y */
      PIPE_SWIZZLE_Z,	/* u */
      PIPE_SWIZZLE_X,	/* v */
      PIPE_SWIZZLE_W	/* ignored */
   },
#else
   {
      PIPE_SWIZZLE_Y,	/* y */
      PIPE_SWIZZLE_Z,	/* u */
      PIPE_SWIZZLE_X,	/* v */
      PIPE_SWIZZLE_W	/* ignored */
   },
#endif
      .colorspace = UTIL_FORMAT_COLORSPACE_YUV,
      .srgb_equivalent = PIPE_FORMAT_NONE,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_Y8U8V8_420_UNORM_PACKED] = {
      .format = PIPE_FORMAT_Y8U8V8_420_UNORM_PACKED,
      .name = "PIPE_FORMAT_Y8U8V8_420_UNORM_PACKED",
      .short_name = "y8u8v8_420_unorm_packed",
      .block = {1, 1, 1, 0},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_SUBSAMPLED,
      .nr_channels = 0,	/* nr_channels */
      .is_array = false,	/* is_array */
      .is_bitmask = false,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = true,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
   {
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0}
   },
   {
      PIPE_SWIZZLE_X,	/* y */
      PIPE_SWIZZLE_Y,	/* u */
      PIPE_SWIZZLE_Z,	/* v */
      PIPE_SWIZZLE_W	/* ignored */
   },
      .colorspace = UTIL_FORMAT_COLORSPACE_YUV,
      .srgb_equivalent = PIPE_FORMAT_NONE,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_Y10U10V10_420_UNORM_PACKED] = {
      .format = PIPE_FORMAT_Y10U10V10_420_UNORM_PACKED,
      .name = "PIPE_FORMAT_Y10U10V10_420_UNORM_PACKED",
      .short_name = "y10u10v10_420_unorm_packed",
      .block = {1, 1, 1, 0},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_SUBSAMPLED,
      .nr_channels = 0,	/* nr_channels */
      .is_array = false,	/* is_array */
      .is_bitmask = false,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = true,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
   {
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0}
   },
   {
      PIPE_SWIZZLE_X,	/* y */
      PIPE_SWIZZLE_Y,	/* u */
      PIPE_SWIZZLE_Z,	/* v */
      PIPE_SWIZZLE_W	/* ignored */
   },
      .colorspace = UTIL_FORMAT_COLORSPACE_YUV,
      .srgb_equivalent = PIPE_FORMAT_NONE,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_A4R4_UNORM] = {
      .format = PIPE_FORMAT_A4R4_UNORM,
      .name = "PIPE_FORMAT_A4R4_UNORM",
      .short_name = "a4r4_unorm",
      .block = {1, 1, 1, 8},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_PLAIN,
      .nr_channels = 2,	/* nr_channels */
      .is_array = false,	/* is_array */
      .is_bitmask = true,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = true,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
#if UTIL_ARCH_BIG_ENDIAN
   {
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 4, 4},	/* x = r */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 4, 0},	/* y = a */
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0}
   },
#else
   {
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 4, 0},	/* x = a */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 4, 4},	/* y = r */
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0}
   },
#endif
#if UTIL_ARCH_BIG_ENDIAN
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_0,	/* g */
      PIPE_SWIZZLE_0,	/* b */
      PIPE_SWIZZLE_Y	/* a */
   },
#else
   {
      PIPE_SWIZZLE_Y,	/* r */
      PIPE_SWIZZLE_0,	/* g */
      PIPE_SWIZZLE_0,	/* b */
      PIPE_SWIZZLE_X	/* a */
   },
#endif
      .colorspace = UTIL_FORMAT_COLORSPACE_RGB,
      .srgb_equivalent = PIPE_FORMAT_NONE,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_R4A4_UNORM] = {
      .format = PIPE_FORMAT_R4A4_UNORM,
      .name = "PIPE_FORMAT_R4A4_UNORM",
      .short_name = "r4a4_unorm",
      .block = {1, 1, 1, 8},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_PLAIN,
      .nr_channels = 2,	/* nr_channels */
      .is_array = false,	/* is_array */
      .is_bitmask = true,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = true,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
#if UTIL_ARCH_BIG_ENDIAN
   {
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 4, 4},	/* x = a */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 4, 0},	/* y = r */
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0}
   },
#else
   {
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 4, 0},	/* x = r */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 4, 4},	/* y = a */
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0}
   },
#endif
#if UTIL_ARCH_BIG_ENDIAN
   {
      PIPE_SWIZZLE_Y,	/* r */
      PIPE_SWIZZLE_0,	/* g */
      PIPE_SWIZZLE_0,	/* b */
      PIPE_SWIZZLE_X	/* a */
   },
#else
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_0,	/* g */
      PIPE_SWIZZLE_0,	/* b */
      PIPE_SWIZZLE_Y	/* a */
   },
#endif
      .colorspace = UTIL_FORMAT_COLORSPACE_RGB,
      .srgb_equivalent = PIPE_FORMAT_NONE,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_R8A8_UNORM] = {
      .format = PIPE_FORMAT_R8A8_UNORM,
      .name = "PIPE_FORMAT_R8A8_UNORM",
      .short_name = "r8a8_unorm",
      .block = {1, 1, 1, 16},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_PLAIN,
      .nr_channels = 2,	/* nr_channels */
      .is_array = true,	/* is_array */
      .is_bitmask = true,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = true,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
#if UTIL_ARCH_BIG_ENDIAN
   {
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 8, 8},	/* x = r */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 8, 0},	/* y = a */
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0}
   },
#else
   {
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 8, 0},	/* x = r */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 8, 8},	/* y = a */
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0}
   },
#endif
#if UTIL_ARCH_BIG_ENDIAN
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_0,	/* g */
      PIPE_SWIZZLE_0,	/* b */
      PIPE_SWIZZLE_Y	/* a */
   },
#else
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_0,	/* g */
      PIPE_SWIZZLE_0,	/* b */
      PIPE_SWIZZLE_Y	/* a */
   },
#endif
      .colorspace = UTIL_FORMAT_COLORSPACE_RGB,
      .srgb_equivalent = PIPE_FORMAT_NONE,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_A8R8_UNORM] = {
      .format = PIPE_FORMAT_A8R8_UNORM,
      .name = "PIPE_FORMAT_A8R8_UNORM",
      .short_name = "a8r8_unorm",
      .block = {1, 1, 1, 16},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_PLAIN,
      .nr_channels = 2,	/* nr_channels */
      .is_array = true,	/* is_array */
      .is_bitmask = true,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = true,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
#if UTIL_ARCH_BIG_ENDIAN
   {
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 8, 8},	/* x = a */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 8, 0},	/* y = r */
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0}
   },
#else
   {
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 8, 0},	/* x = a */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 8, 8},	/* y = r */
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0}
   },
#endif
#if UTIL_ARCH_BIG_ENDIAN
   {
      PIPE_SWIZZLE_Y,	/* r */
      PIPE_SWIZZLE_0,	/* g */
      PIPE_SWIZZLE_0,	/* b */
      PIPE_SWIZZLE_X	/* a */
   },
#else
   {
      PIPE_SWIZZLE_Y,	/* r */
      PIPE_SWIZZLE_0,	/* g */
      PIPE_SWIZZLE_0,	/* b */
      PIPE_SWIZZLE_X	/* a */
   },
#endif
      .colorspace = UTIL_FORMAT_COLORSPACE_RGB,
      .srgb_equivalent = PIPE_FORMAT_NONE,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_R10G10B10A2_USCALED] = {
      .format = PIPE_FORMAT_R10G10B10A2_USCALED,
      .name = "PIPE_FORMAT_R10G10B10A2_USCALED",
      .short_name = "r10g10b10a2_uscaled",
      .block = {1, 1, 1, 32},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_PLAIN,
      .nr_channels = 4,	/* nr_channels */
      .is_array = false,	/* is_array */
      .is_bitmask = true,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = false,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
#if UTIL_ARCH_BIG_ENDIAN
   {
      {UTIL_FORMAT_TYPE_UNSIGNED, false, false, 2, 30},	/* x = a */
      {UTIL_FORMAT_TYPE_UNSIGNED, false, false, 10, 20},	/* y = b */
      {UTIL_FORMAT_TYPE_UNSIGNED, false, false, 10, 10},	/* z = g */
      {UTIL_FORMAT_TYPE_UNSIGNED, false, false, 10, 0}	/* w = r */
   },
#else
   {
      {UTIL_FORMAT_TYPE_UNSIGNED, false, false, 10, 0},	/* x = r */
      {UTIL_FORMAT_TYPE_UNSIGNED, false, false, 10, 10},	/* y = g */
      {UTIL_FORMAT_TYPE_UNSIGNED, false, false, 10, 20},	/* z = b */
      {UTIL_FORMAT_TYPE_UNSIGNED, false, false, 2, 30}	/* w = a */
   },
#endif
#if UTIL_ARCH_BIG_ENDIAN
   {
      PIPE_SWIZZLE_W,	/* r */
      PIPE_SWIZZLE_Z,	/* g */
      PIPE_SWIZZLE_Y,	/* b */
      PIPE_SWIZZLE_X	/* a */
   },
#else
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_Y,	/* g */
      PIPE_SWIZZLE_Z,	/* b */
      PIPE_SWIZZLE_W	/* a */
   },
#endif
      .colorspace = UTIL_FORMAT_COLORSPACE_RGB,
      .srgb_equivalent = PIPE_FORMAT_NONE,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_R10G10B10A2_SSCALED] = {
      .format = PIPE_FORMAT_R10G10B10A2_SSCALED,
      .name = "PIPE_FORMAT_R10G10B10A2_SSCALED",
      .short_name = "r10g10b10a2_sscaled",
      .block = {1, 1, 1, 32},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_PLAIN,
      .nr_channels = 4,	/* nr_channels */
      .is_array = false,	/* is_array */
      .is_bitmask = true,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = false,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
#if UTIL_ARCH_BIG_ENDIAN
   {
      {UTIL_FORMAT_TYPE_SIGNED, false, false, 2, 30},	/* x = a */
      {UTIL_FORMAT_TYPE_SIGNED, false, false, 10, 20},	/* y = b */
      {UTIL_FORMAT_TYPE_SIGNED, false, false, 10, 10},	/* z = g */
      {UTIL_FORMAT_TYPE_SIGNED, false, false, 10, 0}	/* w = r */
   },
#else
   {
      {UTIL_FORMAT_TYPE_SIGNED, false, false, 10, 0},	/* x = r */
      {UTIL_FORMAT_TYPE_SIGNED, false, false, 10, 10},	/* y = g */
      {UTIL_FORMAT_TYPE_SIGNED, false, false, 10, 20},	/* z = b */
      {UTIL_FORMAT_TYPE_SIGNED, false, false, 2, 30}	/* w = a */
   },
#endif
#if UTIL_ARCH_BIG_ENDIAN
   {
      PIPE_SWIZZLE_W,	/* r */
      PIPE_SWIZZLE_Z,	/* g */
      PIPE_SWIZZLE_Y,	/* b */
      PIPE_SWIZZLE_X	/* a */
   },
#else
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_Y,	/* g */
      PIPE_SWIZZLE_Z,	/* b */
      PIPE_SWIZZLE_W	/* a */
   },
#endif
      .colorspace = UTIL_FORMAT_COLORSPACE_RGB,
      .srgb_equivalent = PIPE_FORMAT_NONE,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_R10G10B10A2_SNORM] = {
      .format = PIPE_FORMAT_R10G10B10A2_SNORM,
      .name = "PIPE_FORMAT_R10G10B10A2_SNORM",
      .short_name = "r10g10b10a2_snorm",
      .block = {1, 1, 1, 32},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_PLAIN,
      .nr_channels = 4,	/* nr_channels */
      .is_array = false,	/* is_array */
      .is_bitmask = true,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = false,	/* is_unorm */
      .is_snorm = true,	/* is_snorm */
#if UTIL_ARCH_BIG_ENDIAN
   {
      {UTIL_FORMAT_TYPE_SIGNED, true, false, 2, 30},	/* x = a */
      {UTIL_FORMAT_TYPE_SIGNED, true, false, 10, 20},	/* y = b */
      {UTIL_FORMAT_TYPE_SIGNED, true, false, 10, 10},	/* z = g */
      {UTIL_FORMAT_TYPE_SIGNED, true, false, 10, 0}	/* w = r */
   },
#else
   {
      {UTIL_FORMAT_TYPE_SIGNED, true, false, 10, 0},	/* x = r */
      {UTIL_FORMAT_TYPE_SIGNED, true, false, 10, 10},	/* y = g */
      {UTIL_FORMAT_TYPE_SIGNED, true, false, 10, 20},	/* z = b */
      {UTIL_FORMAT_TYPE_SIGNED, true, false, 2, 30}	/* w = a */
   },
#endif
#if UTIL_ARCH_BIG_ENDIAN
   {
      PIPE_SWIZZLE_W,	/* r */
      PIPE_SWIZZLE_Z,	/* g */
      PIPE_SWIZZLE_Y,	/* b */
      PIPE_SWIZZLE_X	/* a */
   },
#else
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_Y,	/* g */
      PIPE_SWIZZLE_Z,	/* b */
      PIPE_SWIZZLE_W	/* a */
   },
#endif
      .colorspace = UTIL_FORMAT_COLORSPACE_RGB,
      .srgb_equivalent = PIPE_FORMAT_NONE,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_B10G10R10A2_USCALED] = {
      .format = PIPE_FORMAT_B10G10R10A2_USCALED,
      .name = "PIPE_FORMAT_B10G10R10A2_USCALED",
      .short_name = "b10g10r10a2_uscaled",
      .block = {1, 1, 1, 32},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_PLAIN,
      .nr_channels = 4,	/* nr_channels */
      .is_array = false,	/* is_array */
      .is_bitmask = true,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = false,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
#if UTIL_ARCH_BIG_ENDIAN
   {
      {UTIL_FORMAT_TYPE_UNSIGNED, false, false, 2, 30},	/* x = a */
      {UTIL_FORMAT_TYPE_UNSIGNED, false, false, 10, 20},	/* y = r */
      {UTIL_FORMAT_TYPE_UNSIGNED, false, false, 10, 10},	/* z = g */
      {UTIL_FORMAT_TYPE_UNSIGNED, false, false, 10, 0}	/* w = b */
   },
#else
   {
      {UTIL_FORMAT_TYPE_UNSIGNED, false, false, 10, 0},	/* x = b */
      {UTIL_FORMAT_TYPE_UNSIGNED, false, false, 10, 10},	/* y = g */
      {UTIL_FORMAT_TYPE_UNSIGNED, false, false, 10, 20},	/* z = r */
      {UTIL_FORMAT_TYPE_UNSIGNED, false, false, 2, 30}	/* w = a */
   },
#endif
#if UTIL_ARCH_BIG_ENDIAN
   {
      PIPE_SWIZZLE_Y,	/* r */
      PIPE_SWIZZLE_Z,	/* g */
      PIPE_SWIZZLE_W,	/* b */
      PIPE_SWIZZLE_X	/* a */
   },
#else
   {
      PIPE_SWIZZLE_Z,	/* r */
      PIPE_SWIZZLE_Y,	/* g */
      PIPE_SWIZZLE_X,	/* b */
      PIPE_SWIZZLE_W	/* a */
   },
#endif
      .colorspace = UTIL_FORMAT_COLORSPACE_RGB,
      .srgb_equivalent = PIPE_FORMAT_NONE,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_B10G10R10A2_SSCALED] = {
      .format = PIPE_FORMAT_B10G10R10A2_SSCALED,
      .name = "PIPE_FORMAT_B10G10R10A2_SSCALED",
      .short_name = "b10g10r10a2_sscaled",
      .block = {1, 1, 1, 32},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_PLAIN,
      .nr_channels = 4,	/* nr_channels */
      .is_array = false,	/* is_array */
      .is_bitmask = true,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = false,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
#if UTIL_ARCH_BIG_ENDIAN
   {
      {UTIL_FORMAT_TYPE_SIGNED, false, false, 2, 30},	/* x = a */
      {UTIL_FORMAT_TYPE_SIGNED, false, false, 10, 20},	/* y = r */
      {UTIL_FORMAT_TYPE_SIGNED, false, false, 10, 10},	/* z = g */
      {UTIL_FORMAT_TYPE_SIGNED, false, false, 10, 0}	/* w = b */
   },
#else
   {
      {UTIL_FORMAT_TYPE_SIGNED, false, false, 10, 0},	/* x = b */
      {UTIL_FORMAT_TYPE_SIGNED, false, false, 10, 10},	/* y = g */
      {UTIL_FORMAT_TYPE_SIGNED, false, false, 10, 20},	/* z = r */
      {UTIL_FORMAT_TYPE_SIGNED, false, false, 2, 30}	/* w = a */
   },
#endif
#if UTIL_ARCH_BIG_ENDIAN
   {
      PIPE_SWIZZLE_Y,	/* r */
      PIPE_SWIZZLE_Z,	/* g */
      PIPE_SWIZZLE_W,	/* b */
      PIPE_SWIZZLE_X	/* a */
   },
#else
   {
      PIPE_SWIZZLE_Z,	/* r */
      PIPE_SWIZZLE_Y,	/* g */
      PIPE_SWIZZLE_X,	/* b */
      PIPE_SWIZZLE_W	/* a */
   },
#endif
      .colorspace = UTIL_FORMAT_COLORSPACE_RGB,
      .srgb_equivalent = PIPE_FORMAT_NONE,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_B10G10R10A2_SNORM] = {
      .format = PIPE_FORMAT_B10G10R10A2_SNORM,
      .name = "PIPE_FORMAT_B10G10R10A2_SNORM",
      .short_name = "b10g10r10a2_snorm",
      .block = {1, 1, 1, 32},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_PLAIN,
      .nr_channels = 4,	/* nr_channels */
      .is_array = false,	/* is_array */
      .is_bitmask = true,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = false,	/* is_unorm */
      .is_snorm = true,	/* is_snorm */
#if UTIL_ARCH_BIG_ENDIAN
   {
      {UTIL_FORMAT_TYPE_SIGNED, true, false, 2, 30},	/* x = a */
      {UTIL_FORMAT_TYPE_SIGNED, true, false, 10, 20},	/* y = r */
      {UTIL_FORMAT_TYPE_SIGNED, true, false, 10, 10},	/* z = g */
      {UTIL_FORMAT_TYPE_SIGNED, true, false, 10, 0}	/* w = b */
   },
#else
   {
      {UTIL_FORMAT_TYPE_SIGNED, true, false, 10, 0},	/* x = b */
      {UTIL_FORMAT_TYPE_SIGNED, true, false, 10, 10},	/* y = g */
      {UTIL_FORMAT_TYPE_SIGNED, true, false, 10, 20},	/* z = r */
      {UTIL_FORMAT_TYPE_SIGNED, true, false, 2, 30}	/* w = a */
   },
#endif
#if UTIL_ARCH_BIG_ENDIAN
   {
      PIPE_SWIZZLE_Y,	/* r */
      PIPE_SWIZZLE_Z,	/* g */
      PIPE_SWIZZLE_W,	/* b */
      PIPE_SWIZZLE_X	/* a */
   },
#else
   {
      PIPE_SWIZZLE_Z,	/* r */
      PIPE_SWIZZLE_Y,	/* g */
      PIPE_SWIZZLE_X,	/* b */
      PIPE_SWIZZLE_W	/* a */
   },
#endif
      .colorspace = UTIL_FORMAT_COLORSPACE_RGB,
      .srgb_equivalent = PIPE_FORMAT_NONE,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_R8_UINT] = {
      .format = PIPE_FORMAT_R8_UINT,
      .name = "PIPE_FORMAT_R8_UINT",
      .short_name = "r8_uint",
      .block = {1, 1, 1, 8},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_PLAIN,
      .nr_channels = 1,	/* nr_channels */
      .is_array = true,	/* is_array */
      .is_bitmask = true,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = false,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
   {
      {UTIL_FORMAT_TYPE_UNSIGNED, false, true, 8, 0},	/* x = r */
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0}
   },
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_0,	/* g */
      PIPE_SWIZZLE_0,	/* b */
      PIPE_SWIZZLE_1	/* a */
   },
      .colorspace = UTIL_FORMAT_COLORSPACE_RGB,
      .srgb_equivalent = PIPE_FORMAT_NONE,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_R8G8_UINT] = {
      .format = PIPE_FORMAT_R8G8_UINT,
      .name = "PIPE_FORMAT_R8G8_UINT",
      .short_name = "r8g8_uint",
      .block = {1, 1, 1, 16},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_PLAIN,
      .nr_channels = 2,	/* nr_channels */
      .is_array = true,	/* is_array */
      .is_bitmask = true,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = false,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
#if UTIL_ARCH_BIG_ENDIAN
   {
      {UTIL_FORMAT_TYPE_UNSIGNED, false, true, 8, 8},	/* x = r */
      {UTIL_FORMAT_TYPE_UNSIGNED, false, true, 8, 0},	/* y = g */
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0}
   },
#else
   {
      {UTIL_FORMAT_TYPE_UNSIGNED, false, true, 8, 0},	/* x = r */
      {UTIL_FORMAT_TYPE_UNSIGNED, false, true, 8, 8},	/* y = g */
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0}
   },
#endif
#if UTIL_ARCH_BIG_ENDIAN
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_Y,	/* g */
      PIPE_SWIZZLE_0,	/* b */
      PIPE_SWIZZLE_1	/* a */
   },
#else
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_Y,	/* g */
      PIPE_SWIZZLE_0,	/* b */
      PIPE_SWIZZLE_1	/* a */
   },
#endif
      .colorspace = UTIL_FORMAT_COLORSPACE_RGB,
      .srgb_equivalent = PIPE_FORMAT_NONE,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_R8G8B8_UINT] = {
      .format = PIPE_FORMAT_R8G8B8_UINT,
      .name = "PIPE_FORMAT_R8G8B8_UINT",
      .short_name = "r8g8b8_uint",
      .block = {1, 1, 1, 24},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_PLAIN,
      .nr_channels = 3,	/* nr_channels */
      .is_array = true,	/* is_array */
      .is_bitmask = false,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = false,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
#if UTIL_ARCH_BIG_ENDIAN
   {
      {UTIL_FORMAT_TYPE_UNSIGNED, false, true, 8, 16},	/* x = r */
      {UTIL_FORMAT_TYPE_UNSIGNED, false, true, 8, 8},	/* y = g */
      {UTIL_FORMAT_TYPE_UNSIGNED, false, true, 8, 0},	/* z = b */
      {0, 0, 0, 0, 0}
   },
#else
   {
      {UTIL_FORMAT_TYPE_UNSIGNED, false, true, 8, 0},	/* x = r */
      {UTIL_FORMAT_TYPE_UNSIGNED, false, true, 8, 8},	/* y = g */
      {UTIL_FORMAT_TYPE_UNSIGNED, false, true, 8, 16},	/* z = b */
      {0, 0, 0, 0, 0}
   },
#endif
#if UTIL_ARCH_BIG_ENDIAN
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_Y,	/* g */
      PIPE_SWIZZLE_Z,	/* b */
      PIPE_SWIZZLE_1	/* a */
   },
#else
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_Y,	/* g */
      PIPE_SWIZZLE_Z,	/* b */
      PIPE_SWIZZLE_1	/* a */
   },
#endif
      .colorspace = UTIL_FORMAT_COLORSPACE_RGB,
      .srgb_equivalent = PIPE_FORMAT_NONE,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_R8G8B8A8_UINT] = {
      .format = PIPE_FORMAT_R8G8B8A8_UINT,
      .name = "PIPE_FORMAT_R8G8B8A8_UINT",
      .short_name = "r8g8b8a8_uint",
      .block = {1, 1, 1, 32},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_PLAIN,
      .nr_channels = 4,	/* nr_channels */
      .is_array = true,	/* is_array */
      .is_bitmask = true,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = false,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
#if UTIL_ARCH_BIG_ENDIAN
   {
      {UTIL_FORMAT_TYPE_UNSIGNED, false, true, 8, 24},	/* x = r */
      {UTIL_FORMAT_TYPE_UNSIGNED, false, true, 8, 16},	/* y = g */
      {UTIL_FORMAT_TYPE_UNSIGNED, false, true, 8, 8},	/* z = b */
      {UTIL_FORMAT_TYPE_UNSIGNED, false, true, 8, 0}	/* w = a */
   },
#else
   {
      {UTIL_FORMAT_TYPE_UNSIGNED, false, true, 8, 0},	/* x = r */
      {UTIL_FORMAT_TYPE_UNSIGNED, false, true, 8, 8},	/* y = g */
      {UTIL_FORMAT_TYPE_UNSIGNED, false, true, 8, 16},	/* z = b */
      {UTIL_FORMAT_TYPE_UNSIGNED, false, true, 8, 24}	/* w = a */
   },
#endif
#if UTIL_ARCH_BIG_ENDIAN
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_Y,	/* g */
      PIPE_SWIZZLE_Z,	/* b */
      PIPE_SWIZZLE_W	/* a */
   },
#else
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_Y,	/* g */
      PIPE_SWIZZLE_Z,	/* b */
      PIPE_SWIZZLE_W	/* a */
   },
#endif
      .colorspace = UTIL_FORMAT_COLORSPACE_RGB,
      .srgb_equivalent = PIPE_FORMAT_NONE,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_R8_SINT] = {
      .format = PIPE_FORMAT_R8_SINT,
      .name = "PIPE_FORMAT_R8_SINT",
      .short_name = "r8_sint",
      .block = {1, 1, 1, 8},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_PLAIN,
      .nr_channels = 1,	/* nr_channels */
      .is_array = true,	/* is_array */
      .is_bitmask = true,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = false,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
   {
      {UTIL_FORMAT_TYPE_SIGNED, false, true, 8, 0},	/* x = r */
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0}
   },
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_0,	/* g */
      PIPE_SWIZZLE_0,	/* b */
      PIPE_SWIZZLE_1	/* a */
   },
      .colorspace = UTIL_FORMAT_COLORSPACE_RGB,
      .srgb_equivalent = PIPE_FORMAT_NONE,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_R8G8_SINT] = {
      .format = PIPE_FORMAT_R8G8_SINT,
      .name = "PIPE_FORMAT_R8G8_SINT",
      .short_name = "r8g8_sint",
      .block = {1, 1, 1, 16},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_PLAIN,
      .nr_channels = 2,	/* nr_channels */
      .is_array = true,	/* is_array */
      .is_bitmask = true,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = false,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
#if UTIL_ARCH_BIG_ENDIAN
   {
      {UTIL_FORMAT_TYPE_SIGNED, false, true, 8, 8},	/* x = r */
      {UTIL_FORMAT_TYPE_SIGNED, false, true, 8, 0},	/* y = g */
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0}
   },
#else
   {
      {UTIL_FORMAT_TYPE_SIGNED, false, true, 8, 0},	/* x = r */
      {UTIL_FORMAT_TYPE_SIGNED, false, true, 8, 8},	/* y = g */
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0}
   },
#endif
#if UTIL_ARCH_BIG_ENDIAN
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_Y,	/* g */
      PIPE_SWIZZLE_0,	/* b */
      PIPE_SWIZZLE_1	/* a */
   },
#else
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_Y,	/* g */
      PIPE_SWIZZLE_0,	/* b */
      PIPE_SWIZZLE_1	/* a */
   },
#endif
      .colorspace = UTIL_FORMAT_COLORSPACE_RGB,
      .srgb_equivalent = PIPE_FORMAT_NONE,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_R8G8B8_SINT] = {
      .format = PIPE_FORMAT_R8G8B8_SINT,
      .name = "PIPE_FORMAT_R8G8B8_SINT",
      .short_name = "r8g8b8_sint",
      .block = {1, 1, 1, 24},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_PLAIN,
      .nr_channels = 3,	/* nr_channels */
      .is_array = true,	/* is_array */
      .is_bitmask = false,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = false,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
#if UTIL_ARCH_BIG_ENDIAN
   {
      {UTIL_FORMAT_TYPE_SIGNED, false, true, 8, 16},	/* x = r */
      {UTIL_FORMAT_TYPE_SIGNED, false, true, 8, 8},	/* y = g */
      {UTIL_FORMAT_TYPE_SIGNED, false, true, 8, 0},	/* z = b */
      {0, 0, 0, 0, 0}
   },
#else
   {
      {UTIL_FORMAT_TYPE_SIGNED, false, true, 8, 0},	/* x = r */
      {UTIL_FORMAT_TYPE_SIGNED, false, true, 8, 8},	/* y = g */
      {UTIL_FORMAT_TYPE_SIGNED, false, true, 8, 16},	/* z = b */
      {0, 0, 0, 0, 0}
   },
#endif
#if UTIL_ARCH_BIG_ENDIAN
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_Y,	/* g */
      PIPE_SWIZZLE_Z,	/* b */
      PIPE_SWIZZLE_1	/* a */
   },
#else
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_Y,	/* g */
      PIPE_SWIZZLE_Z,	/* b */
      PIPE_SWIZZLE_1	/* a */
   },
#endif
      .colorspace = UTIL_FORMAT_COLORSPACE_RGB,
      .srgb_equivalent = PIPE_FORMAT_NONE,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_R8G8B8A8_SINT] = {
      .format = PIPE_FORMAT_R8G8B8A8_SINT,
      .name = "PIPE_FORMAT_R8G8B8A8_SINT",
      .short_name = "r8g8b8a8_sint",
      .block = {1, 1, 1, 32},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_PLAIN,
      .nr_channels = 4,	/* nr_channels */
      .is_array = true,	/* is_array */
      .is_bitmask = true,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = false,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
#if UTIL_ARCH_BIG_ENDIAN
   {
      {UTIL_FORMAT_TYPE_SIGNED, false, true, 8, 24},	/* x = r */
      {UTIL_FORMAT_TYPE_SIGNED, false, true, 8, 16},	/* y = g */
      {UTIL_FORMAT_TYPE_SIGNED, false, true, 8, 8},	/* z = b */
      {UTIL_FORMAT_TYPE_SIGNED, false, true, 8, 0}	/* w = a */
   },
#else
   {
      {UTIL_FORMAT_TYPE_SIGNED, false, true, 8, 0},	/* x = r */
      {UTIL_FORMAT_TYPE_SIGNED, false, true, 8, 8},	/* y = g */
      {UTIL_FORMAT_TYPE_SIGNED, false, true, 8, 16},	/* z = b */
      {UTIL_FORMAT_TYPE_SIGNED, false, true, 8, 24}	/* w = a */
   },
#endif
#if UTIL_ARCH_BIG_ENDIAN
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_Y,	/* g */
      PIPE_SWIZZLE_Z,	/* b */
      PIPE_SWIZZLE_W	/* a */
   },
#else
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_Y,	/* g */
      PIPE_SWIZZLE_Z,	/* b */
      PIPE_SWIZZLE_W	/* a */
   },
#endif
      .colorspace = UTIL_FORMAT_COLORSPACE_RGB,
      .srgb_equivalent = PIPE_FORMAT_NONE,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_R16_UINT] = {
      .format = PIPE_FORMAT_R16_UINT,
      .name = "PIPE_FORMAT_R16_UINT",
      .short_name = "r16_uint",
      .block = {1, 1, 1, 16},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_PLAIN,
      .nr_channels = 1,	/* nr_channels */
      .is_array = true,	/* is_array */
      .is_bitmask = true,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = false,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
   {
      {UTIL_FORMAT_TYPE_UNSIGNED, false, true, 16, 0},	/* x = r */
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0}
   },
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_0,	/* g */
      PIPE_SWIZZLE_0,	/* b */
      PIPE_SWIZZLE_1	/* a */
   },
      .colorspace = UTIL_FORMAT_COLORSPACE_RGB,
      .srgb_equivalent = PIPE_FORMAT_NONE,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_R16G16_UINT] = {
      .format = PIPE_FORMAT_R16G16_UINT,
      .name = "PIPE_FORMAT_R16G16_UINT",
      .short_name = "r16g16_uint",
      .block = {1, 1, 1, 32},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_PLAIN,
      .nr_channels = 2,	/* nr_channels */
      .is_array = true,	/* is_array */
      .is_bitmask = true,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = false,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
#if UTIL_ARCH_BIG_ENDIAN
   {
      {UTIL_FORMAT_TYPE_UNSIGNED, false, true, 16, 16},	/* x = r */
      {UTIL_FORMAT_TYPE_UNSIGNED, false, true, 16, 0},	/* y = g */
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0}
   },
#else
   {
      {UTIL_FORMAT_TYPE_UNSIGNED, false, true, 16, 0},	/* x = r */
      {UTIL_FORMAT_TYPE_UNSIGNED, false, true, 16, 16},	/* y = g */
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0}
   },
#endif
#if UTIL_ARCH_BIG_ENDIAN
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_Y,	/* g */
      PIPE_SWIZZLE_0,	/* b */
      PIPE_SWIZZLE_1	/* a */
   },
#else
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_Y,	/* g */
      PIPE_SWIZZLE_0,	/* b */
      PIPE_SWIZZLE_1	/* a */
   },
#endif
      .colorspace = UTIL_FORMAT_COLORSPACE_RGB,
      .srgb_equivalent = PIPE_FORMAT_NONE,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_R16G16B16_UINT] = {
      .format = PIPE_FORMAT_R16G16B16_UINT,
      .name = "PIPE_FORMAT_R16G16B16_UINT",
      .short_name = "r16g16b16_uint",
      .block = {1, 1, 1, 48},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_PLAIN,
      .nr_channels = 3,	/* nr_channels */
      .is_array = true,	/* is_array */
      .is_bitmask = false,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = false,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
#if UTIL_ARCH_BIG_ENDIAN
   {
      {UTIL_FORMAT_TYPE_UNSIGNED, false, true, 16, 32},	/* x = r */
      {UTIL_FORMAT_TYPE_UNSIGNED, false, true, 16, 16},	/* y = g */
      {UTIL_FORMAT_TYPE_UNSIGNED, false, true, 16, 0},	/* z = b */
      {0, 0, 0, 0, 0}
   },
#else
   {
      {UTIL_FORMAT_TYPE_UNSIGNED, false, true, 16, 0},	/* x = r */
      {UTIL_FORMAT_TYPE_UNSIGNED, false, true, 16, 16},	/* y = g */
      {UTIL_FORMAT_TYPE_UNSIGNED, false, true, 16, 32},	/* z = b */
      {0, 0, 0, 0, 0}
   },
#endif
#if UTIL_ARCH_BIG_ENDIAN
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_Y,	/* g */
      PIPE_SWIZZLE_Z,	/* b */
      PIPE_SWIZZLE_1	/* a */
   },
#else
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_Y,	/* g */
      PIPE_SWIZZLE_Z,	/* b */
      PIPE_SWIZZLE_1	/* a */
   },
#endif
      .colorspace = UTIL_FORMAT_COLORSPACE_RGB,
      .srgb_equivalent = PIPE_FORMAT_NONE,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_R16G16B16A16_UINT] = {
      .format = PIPE_FORMAT_R16G16B16A16_UINT,
      .name = "PIPE_FORMAT_R16G16B16A16_UINT",
      .short_name = "r16g16b16a16_uint",
      .block = {1, 1, 1, 64},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_PLAIN,
      .nr_channels = 4,	/* nr_channels */
      .is_array = true,	/* is_array */
      .is_bitmask = false,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = false,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
#if UTIL_ARCH_BIG_ENDIAN
   {
      {UTIL_FORMAT_TYPE_UNSIGNED, false, true, 16, 48},	/* x = r */
      {UTIL_FORMAT_TYPE_UNSIGNED, false, true, 16, 32},	/* y = g */
      {UTIL_FORMAT_TYPE_UNSIGNED, false, true, 16, 16},	/* z = b */
      {UTIL_FORMAT_TYPE_UNSIGNED, false, true, 16, 0}	/* w = a */
   },
#else
   {
      {UTIL_FORMAT_TYPE_UNSIGNED, false, true, 16, 0},	/* x = r */
      {UTIL_FORMAT_TYPE_UNSIGNED, false, true, 16, 16},	/* y = g */
      {UTIL_FORMAT_TYPE_UNSIGNED, false, true, 16, 32},	/* z = b */
      {UTIL_FORMAT_TYPE_UNSIGNED, false, true, 16, 48}	/* w = a */
   },
#endif
#if UTIL_ARCH_BIG_ENDIAN
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_Y,	/* g */
      PIPE_SWIZZLE_Z,	/* b */
      PIPE_SWIZZLE_W	/* a */
   },
#else
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_Y,	/* g */
      PIPE_SWIZZLE_Z,	/* b */
      PIPE_SWIZZLE_W	/* a */
   },
#endif
      .colorspace = UTIL_FORMAT_COLORSPACE_RGB,
      .srgb_equivalent = PIPE_FORMAT_NONE,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_R16_SINT] = {
      .format = PIPE_FORMAT_R16_SINT,
      .name = "PIPE_FORMAT_R16_SINT",
      .short_name = "r16_sint",
      .block = {1, 1, 1, 16},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_PLAIN,
      .nr_channels = 1,	/* nr_channels */
      .is_array = true,	/* is_array */
      .is_bitmask = true,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = false,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
   {
      {UTIL_FORMAT_TYPE_SIGNED, false, true, 16, 0},	/* x = r */
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0}
   },
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_0,	/* g */
      PIPE_SWIZZLE_0,	/* b */
      PIPE_SWIZZLE_1	/* a */
   },
      .colorspace = UTIL_FORMAT_COLORSPACE_RGB,
      .srgb_equivalent = PIPE_FORMAT_NONE,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_R16G16_SINT] = {
      .format = PIPE_FORMAT_R16G16_SINT,
      .name = "PIPE_FORMAT_R16G16_SINT",
      .short_name = "r16g16_sint",
      .block = {1, 1, 1, 32},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_PLAIN,
      .nr_channels = 2,	/* nr_channels */
      .is_array = true,	/* is_array */
      .is_bitmask = true,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = false,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
#if UTIL_ARCH_BIG_ENDIAN
   {
      {UTIL_FORMAT_TYPE_SIGNED, false, true, 16, 16},	/* x = r */
      {UTIL_FORMAT_TYPE_SIGNED, false, true, 16, 0},	/* y = g */
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0}
   },
#else
   {
      {UTIL_FORMAT_TYPE_SIGNED, false, true, 16, 0},	/* x = r */
      {UTIL_FORMAT_TYPE_SIGNED, false, true, 16, 16},	/* y = g */
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0}
   },
#endif
#if UTIL_ARCH_BIG_ENDIAN
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_Y,	/* g */
      PIPE_SWIZZLE_0,	/* b */
      PIPE_SWIZZLE_1	/* a */
   },
#else
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_Y,	/* g */
      PIPE_SWIZZLE_0,	/* b */
      PIPE_SWIZZLE_1	/* a */
   },
#endif
      .colorspace = UTIL_FORMAT_COLORSPACE_RGB,
      .srgb_equivalent = PIPE_FORMAT_NONE,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_R16G16B16_SINT] = {
      .format = PIPE_FORMAT_R16G16B16_SINT,
      .name = "PIPE_FORMAT_R16G16B16_SINT",
      .short_name = "r16g16b16_sint",
      .block = {1, 1, 1, 48},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_PLAIN,
      .nr_channels = 3,	/* nr_channels */
      .is_array = true,	/* is_array */
      .is_bitmask = false,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = false,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
#if UTIL_ARCH_BIG_ENDIAN
   {
      {UTIL_FORMAT_TYPE_SIGNED, false, true, 16, 32},	/* x = r */
      {UTIL_FORMAT_TYPE_SIGNED, false, true, 16, 16},	/* y = g */
      {UTIL_FORMAT_TYPE_SIGNED, false, true, 16, 0},	/* z = b */
      {0, 0, 0, 0, 0}
   },
#else
   {
      {UTIL_FORMAT_TYPE_SIGNED, false, true, 16, 0},	/* x = r */
      {UTIL_FORMAT_TYPE_SIGNED, false, true, 16, 16},	/* y = g */
      {UTIL_FORMAT_TYPE_SIGNED, false, true, 16, 32},	/* z = b */
      {0, 0, 0, 0, 0}
   },
#endif
#if UTIL_ARCH_BIG_ENDIAN
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_Y,	/* g */
      PIPE_SWIZZLE_Z,	/* b */
      PIPE_SWIZZLE_1	/* a */
   },
#else
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_Y,	/* g */
      PIPE_SWIZZLE_Z,	/* b */
      PIPE_SWIZZLE_1	/* a */
   },
#endif
      .colorspace = UTIL_FORMAT_COLORSPACE_RGB,
      .srgb_equivalent = PIPE_FORMAT_NONE,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_R16G16B16A16_SINT] = {
      .format = PIPE_FORMAT_R16G16B16A16_SINT,
      .name = "PIPE_FORMAT_R16G16B16A16_SINT",
      .short_name = "r16g16b16a16_sint",
      .block = {1, 1, 1, 64},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_PLAIN,
      .nr_channels = 4,	/* nr_channels */
      .is_array = true,	/* is_array */
      .is_bitmask = false,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = false,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
#if UTIL_ARCH_BIG_ENDIAN
   {
      {UTIL_FORMAT_TYPE_SIGNED, false, true, 16, 48},	/* x = r */
      {UTIL_FORMAT_TYPE_SIGNED, false, true, 16, 32},	/* y = g */
      {UTIL_FORMAT_TYPE_SIGNED, false, true, 16, 16},	/* z = b */
      {UTIL_FORMAT_TYPE_SIGNED, false, true, 16, 0}	/* w = a */
   },
#else
   {
      {UTIL_FORMAT_TYPE_SIGNED, false, true, 16, 0},	/* x = r */
      {UTIL_FORMAT_TYPE_SIGNED, false, true, 16, 16},	/* y = g */
      {UTIL_FORMAT_TYPE_SIGNED, false, true, 16, 32},	/* z = b */
      {UTIL_FORMAT_TYPE_SIGNED, false, true, 16, 48}	/* w = a */
   },
#endif
#if UTIL_ARCH_BIG_ENDIAN
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_Y,	/* g */
      PIPE_SWIZZLE_Z,	/* b */
      PIPE_SWIZZLE_W	/* a */
   },
#else
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_Y,	/* g */
      PIPE_SWIZZLE_Z,	/* b */
      PIPE_SWIZZLE_W	/* a */
   },
#endif
      .colorspace = UTIL_FORMAT_COLORSPACE_RGB,
      .srgb_equivalent = PIPE_FORMAT_NONE,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_R32_UINT] = {
      .format = PIPE_FORMAT_R32_UINT,
      .name = "PIPE_FORMAT_R32_UINT",
      .short_name = "r32_uint",
      .block = {1, 1, 1, 32},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_PLAIN,
      .nr_channels = 1,	/* nr_channels */
      .is_array = true,	/* is_array */
      .is_bitmask = true,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = false,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
   {
      {UTIL_FORMAT_TYPE_UNSIGNED, false, true, 32, 0},	/* x = r */
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0}
   },
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_0,	/* g */
      PIPE_SWIZZLE_0,	/* b */
      PIPE_SWIZZLE_1	/* a */
   },
      .colorspace = UTIL_FORMAT_COLORSPACE_RGB,
      .srgb_equivalent = PIPE_FORMAT_NONE,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_R32G32_UINT] = {
      .format = PIPE_FORMAT_R32G32_UINT,
      .name = "PIPE_FORMAT_R32G32_UINT",
      .short_name = "r32g32_uint",
      .block = {1, 1, 1, 64},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_PLAIN,
      .nr_channels = 2,	/* nr_channels */
      .is_array = true,	/* is_array */
      .is_bitmask = false,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = false,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
#if UTIL_ARCH_BIG_ENDIAN
   {
      {UTIL_FORMAT_TYPE_UNSIGNED, false, true, 32, 32},	/* x = r */
      {UTIL_FORMAT_TYPE_UNSIGNED, false, true, 32, 0},	/* y = g */
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0}
   },
#else
   {
      {UTIL_FORMAT_TYPE_UNSIGNED, false, true, 32, 0},	/* x = r */
      {UTIL_FORMAT_TYPE_UNSIGNED, false, true, 32, 32},	/* y = g */
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0}
   },
#endif
#if UTIL_ARCH_BIG_ENDIAN
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_Y,	/* g */
      PIPE_SWIZZLE_0,	/* b */
      PIPE_SWIZZLE_1	/* a */
   },
#else
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_Y,	/* g */
      PIPE_SWIZZLE_0,	/* b */
      PIPE_SWIZZLE_1	/* a */
   },
#endif
      .colorspace = UTIL_FORMAT_COLORSPACE_RGB,
      .srgb_equivalent = PIPE_FORMAT_NONE,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_R32G32B32_UINT] = {
      .format = PIPE_FORMAT_R32G32B32_UINT,
      .name = "PIPE_FORMAT_R32G32B32_UINT",
      .short_name = "r32g32b32_uint",
      .block = {1, 1, 1, 96},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_PLAIN,
      .nr_channels = 3,	/* nr_channels */
      .is_array = true,	/* is_array */
      .is_bitmask = false,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = false,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
#if UTIL_ARCH_BIG_ENDIAN
   {
      {UTIL_FORMAT_TYPE_UNSIGNED, false, true, 32, 64},	/* x = r */
      {UTIL_FORMAT_TYPE_UNSIGNED, false, true, 32, 32},	/* y = g */
      {UTIL_FORMAT_TYPE_UNSIGNED, false, true, 32, 0},	/* z = b */
      {0, 0, 0, 0, 0}
   },
#else
   {
      {UTIL_FORMAT_TYPE_UNSIGNED, false, true, 32, 0},	/* x = r */
      {UTIL_FORMAT_TYPE_UNSIGNED, false, true, 32, 32},	/* y = g */
      {UTIL_FORMAT_TYPE_UNSIGNED, false, true, 32, 64},	/* z = b */
      {0, 0, 0, 0, 0}
   },
#endif
#if UTIL_ARCH_BIG_ENDIAN
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_Y,	/* g */
      PIPE_SWIZZLE_Z,	/* b */
      PIPE_SWIZZLE_1	/* a */
   },
#else
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_Y,	/* g */
      PIPE_SWIZZLE_Z,	/* b */
      PIPE_SWIZZLE_1	/* a */
   },
#endif
      .colorspace = UTIL_FORMAT_COLORSPACE_RGB,
      .srgb_equivalent = PIPE_FORMAT_NONE,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_R32G32B32A32_UINT] = {
      .format = PIPE_FORMAT_R32G32B32A32_UINT,
      .name = "PIPE_FORMAT_R32G32B32A32_UINT",
      .short_name = "r32g32b32a32_uint",
      .block = {1, 1, 1, 128},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_PLAIN,
      .nr_channels = 4,	/* nr_channels */
      .is_array = true,	/* is_array */
      .is_bitmask = false,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = false,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
#if UTIL_ARCH_BIG_ENDIAN
   {
      {UTIL_FORMAT_TYPE_UNSIGNED, false, true, 32, 96},	/* x = r */
      {UTIL_FORMAT_TYPE_UNSIGNED, false, true, 32, 64},	/* y = g */
      {UTIL_FORMAT_TYPE_UNSIGNED, false, true, 32, 32},	/* z = b */
      {UTIL_FORMAT_TYPE_UNSIGNED, false, true, 32, 0}	/* w = a */
   },
#else
   {
      {UTIL_FORMAT_TYPE_UNSIGNED, false, true, 32, 0},	/* x = r */
      {UTIL_FORMAT_TYPE_UNSIGNED, false, true, 32, 32},	/* y = g */
      {UTIL_FORMAT_TYPE_UNSIGNED, false, true, 32, 64},	/* z = b */
      {UTIL_FORMAT_TYPE_UNSIGNED, false, true, 32, 96}	/* w = a */
   },
#endif
#if UTIL_ARCH_BIG_ENDIAN
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_Y,	/* g */
      PIPE_SWIZZLE_Z,	/* b */
      PIPE_SWIZZLE_W	/* a */
   },
#else
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_Y,	/* g */
      PIPE_SWIZZLE_Z,	/* b */
      PIPE_SWIZZLE_W	/* a */
   },
#endif
      .colorspace = UTIL_FORMAT_COLORSPACE_RGB,
      .srgb_equivalent = PIPE_FORMAT_NONE,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_R32_SINT] = {
      .format = PIPE_FORMAT_R32_SINT,
      .name = "PIPE_FORMAT_R32_SINT",
      .short_name = "r32_sint",
      .block = {1, 1, 1, 32},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_PLAIN,
      .nr_channels = 1,	/* nr_channels */
      .is_array = true,	/* is_array */
      .is_bitmask = true,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = false,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
   {
      {UTIL_FORMAT_TYPE_SIGNED, false, true, 32, 0},	/* x = r */
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0}
   },
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_0,	/* g */
      PIPE_SWIZZLE_0,	/* b */
      PIPE_SWIZZLE_1	/* a */
   },
      .colorspace = UTIL_FORMAT_COLORSPACE_RGB,
      .srgb_equivalent = PIPE_FORMAT_NONE,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_R32G32_SINT] = {
      .format = PIPE_FORMAT_R32G32_SINT,
      .name = "PIPE_FORMAT_R32G32_SINT",
      .short_name = "r32g32_sint",
      .block = {1, 1, 1, 64},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_PLAIN,
      .nr_channels = 2,	/* nr_channels */
      .is_array = true,	/* is_array */
      .is_bitmask = false,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = false,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
#if UTIL_ARCH_BIG_ENDIAN
   {
      {UTIL_FORMAT_TYPE_SIGNED, false, true, 32, 32},	/* x = r */
      {UTIL_FORMAT_TYPE_SIGNED, false, true, 32, 0},	/* y = g */
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0}
   },
#else
   {
      {UTIL_FORMAT_TYPE_SIGNED, false, true, 32, 0},	/* x = r */
      {UTIL_FORMAT_TYPE_SIGNED, false, true, 32, 32},	/* y = g */
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0}
   },
#endif
#if UTIL_ARCH_BIG_ENDIAN
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_Y,	/* g */
      PIPE_SWIZZLE_0,	/* b */
      PIPE_SWIZZLE_1	/* a */
   },
#else
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_Y,	/* g */
      PIPE_SWIZZLE_0,	/* b */
      PIPE_SWIZZLE_1	/* a */
   },
#endif
      .colorspace = UTIL_FORMAT_COLORSPACE_RGB,
      .srgb_equivalent = PIPE_FORMAT_NONE,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_R32G32B32_SINT] = {
      .format = PIPE_FORMAT_R32G32B32_SINT,
      .name = "PIPE_FORMAT_R32G32B32_SINT",
      .short_name = "r32g32b32_sint",
      .block = {1, 1, 1, 96},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_PLAIN,
      .nr_channels = 3,	/* nr_channels */
      .is_array = true,	/* is_array */
      .is_bitmask = false,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = false,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
#if UTIL_ARCH_BIG_ENDIAN
   {
      {UTIL_FORMAT_TYPE_SIGNED, false, true, 32, 64},	/* x = r */
      {UTIL_FORMAT_TYPE_SIGNED, false, true, 32, 32},	/* y = g */
      {UTIL_FORMAT_TYPE_SIGNED, false, true, 32, 0},	/* z = b */
      {0, 0, 0, 0, 0}
   },
#else
   {
      {UTIL_FORMAT_TYPE_SIGNED, false, true, 32, 0},	/* x = r */
      {UTIL_FORMAT_TYPE_SIGNED, false, true, 32, 32},	/* y = g */
      {UTIL_FORMAT_TYPE_SIGNED, false, true, 32, 64},	/* z = b */
      {0, 0, 0, 0, 0}
   },
#endif
#if UTIL_ARCH_BIG_ENDIAN
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_Y,	/* g */
      PIPE_SWIZZLE_Z,	/* b */
      PIPE_SWIZZLE_1	/* a */
   },
#else
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_Y,	/* g */
      PIPE_SWIZZLE_Z,	/* b */
      PIPE_SWIZZLE_1	/* a */
   },
#endif
      .colorspace = UTIL_FORMAT_COLORSPACE_RGB,
      .srgb_equivalent = PIPE_FORMAT_NONE,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_R32G32B32A32_SINT] = {
      .format = PIPE_FORMAT_R32G32B32A32_SINT,
      .name = "PIPE_FORMAT_R32G32B32A32_SINT",
      .short_name = "r32g32b32a32_sint",
      .block = {1, 1, 1, 128},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_PLAIN,
      .nr_channels = 4,	/* nr_channels */
      .is_array = true,	/* is_array */
      .is_bitmask = false,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = false,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
#if UTIL_ARCH_BIG_ENDIAN
   {
      {UTIL_FORMAT_TYPE_SIGNED, false, true, 32, 96},	/* x = r */
      {UTIL_FORMAT_TYPE_SIGNED, false, true, 32, 64},	/* y = g */
      {UTIL_FORMAT_TYPE_SIGNED, false, true, 32, 32},	/* z = b */
      {UTIL_FORMAT_TYPE_SIGNED, false, true, 32, 0}	/* w = a */
   },
#else
   {
      {UTIL_FORMAT_TYPE_SIGNED, false, true, 32, 0},	/* x = r */
      {UTIL_FORMAT_TYPE_SIGNED, false, true, 32, 32},	/* y = g */
      {UTIL_FORMAT_TYPE_SIGNED, false, true, 32, 64},	/* z = b */
      {UTIL_FORMAT_TYPE_SIGNED, false, true, 32, 96}	/* w = a */
   },
#endif
#if UTIL_ARCH_BIG_ENDIAN
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_Y,	/* g */
      PIPE_SWIZZLE_Z,	/* b */
      PIPE_SWIZZLE_W	/* a */
   },
#else
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_Y,	/* g */
      PIPE_SWIZZLE_Z,	/* b */
      PIPE_SWIZZLE_W	/* a */
   },
#endif
      .colorspace = UTIL_FORMAT_COLORSPACE_RGB,
      .srgb_equivalent = PIPE_FORMAT_NONE,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_R64_UINT] = {
      .format = PIPE_FORMAT_R64_UINT,
      .name = "PIPE_FORMAT_R64_UINT",
      .short_name = "r64_uint",
      .block = {1, 1, 1, 64},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_PLAIN,
      .nr_channels = 1,	/* nr_channels */
      .is_array = true,	/* is_array */
      .is_bitmask = false,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = false,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
   {
      {UTIL_FORMAT_TYPE_UNSIGNED, false, true, 64, 0},	/* x = r */
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0}
   },
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_0,	/* g */
      PIPE_SWIZZLE_0,	/* b */
      PIPE_SWIZZLE_1	/* a */
   },
      .colorspace = UTIL_FORMAT_COLORSPACE_RGB,
      .srgb_equivalent = PIPE_FORMAT_NONE,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_R64G64_UINT] = {
      .format = PIPE_FORMAT_R64G64_UINT,
      .name = "PIPE_FORMAT_R64G64_UINT",
      .short_name = "r64g64_uint",
      .block = {1, 1, 1, 128},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_PLAIN,
      .nr_channels = 2,	/* nr_channels */
      .is_array = true,	/* is_array */
      .is_bitmask = false,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = false,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
#if UTIL_ARCH_BIG_ENDIAN
   {
      {UTIL_FORMAT_TYPE_UNSIGNED, false, true, 64, 64},	/* x = r */
      {UTIL_FORMAT_TYPE_UNSIGNED, false, true, 64, 0},	/* y = g */
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0}
   },
#else
   {
      {UTIL_FORMAT_TYPE_UNSIGNED, false, true, 64, 0},	/* x = r */
      {UTIL_FORMAT_TYPE_UNSIGNED, false, true, 64, 64},	/* y = g */
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0}
   },
#endif
#if UTIL_ARCH_BIG_ENDIAN
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_Y,	/* g */
      PIPE_SWIZZLE_0,	/* b */
      PIPE_SWIZZLE_1	/* a */
   },
#else
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_Y,	/* g */
      PIPE_SWIZZLE_0,	/* b */
      PIPE_SWIZZLE_1	/* a */
   },
#endif
      .colorspace = UTIL_FORMAT_COLORSPACE_RGB,
      .srgb_equivalent = PIPE_FORMAT_NONE,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_R64G64B64_UINT] = {
      .format = PIPE_FORMAT_R64G64B64_UINT,
      .name = "PIPE_FORMAT_R64G64B64_UINT",
      .short_name = "r64g64b64_uint",
      .block = {1, 1, 1, 192},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_PLAIN,
      .nr_channels = 3,	/* nr_channels */
      .is_array = true,	/* is_array */
      .is_bitmask = false,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = false,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
#if UTIL_ARCH_BIG_ENDIAN
   {
      {UTIL_FORMAT_TYPE_UNSIGNED, false, true, 64, 128},	/* x = r */
      {UTIL_FORMAT_TYPE_UNSIGNED, false, true, 64, 64},	/* y = g */
      {UTIL_FORMAT_TYPE_UNSIGNED, false, true, 64, 0},	/* z = b */
      {0, 0, 0, 0, 0}
   },
#else
   {
      {UTIL_FORMAT_TYPE_UNSIGNED, false, true, 64, 0},	/* x = r */
      {UTIL_FORMAT_TYPE_UNSIGNED, false, true, 64, 64},	/* y = g */
      {UTIL_FORMAT_TYPE_UNSIGNED, false, true, 64, 128},	/* z = b */
      {0, 0, 0, 0, 0}
   },
#endif
#if UTIL_ARCH_BIG_ENDIAN
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_Y,	/* g */
      PIPE_SWIZZLE_Z,	/* b */
      PIPE_SWIZZLE_1	/* a */
   },
#else
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_Y,	/* g */
      PIPE_SWIZZLE_Z,	/* b */
      PIPE_SWIZZLE_1	/* a */
   },
#endif
      .colorspace = UTIL_FORMAT_COLORSPACE_RGB,
      .srgb_equivalent = PIPE_FORMAT_NONE,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_R64G64B64A64_UINT] = {
      .format = PIPE_FORMAT_R64G64B64A64_UINT,
      .name = "PIPE_FORMAT_R64G64B64A64_UINT",
      .short_name = "r64g64b64a64_uint",
      .block = {1, 1, 1, 256},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_PLAIN,
      .nr_channels = 4,	/* nr_channels */
      .is_array = true,	/* is_array */
      .is_bitmask = false,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = false,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
#if UTIL_ARCH_BIG_ENDIAN
   {
      {UTIL_FORMAT_TYPE_UNSIGNED, false, true, 64, 192},	/* x = r */
      {UTIL_FORMAT_TYPE_UNSIGNED, false, true, 64, 128},	/* y = g */
      {UTIL_FORMAT_TYPE_UNSIGNED, false, true, 64, 64},	/* z = b */
      {UTIL_FORMAT_TYPE_UNSIGNED, false, true, 64, 0}	/* w = a */
   },
#else
   {
      {UTIL_FORMAT_TYPE_UNSIGNED, false, true, 64, 0},	/* x = r */
      {UTIL_FORMAT_TYPE_UNSIGNED, false, true, 64, 64},	/* y = g */
      {UTIL_FORMAT_TYPE_UNSIGNED, false, true, 64, 128},	/* z = b */
      {UTIL_FORMAT_TYPE_UNSIGNED, false, true, 64, 192}	/* w = a */
   },
#endif
#if UTIL_ARCH_BIG_ENDIAN
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_Y,	/* g */
      PIPE_SWIZZLE_Z,	/* b */
      PIPE_SWIZZLE_W	/* a */
   },
#else
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_Y,	/* g */
      PIPE_SWIZZLE_Z,	/* b */
      PIPE_SWIZZLE_W	/* a */
   },
#endif
      .colorspace = UTIL_FORMAT_COLORSPACE_RGB,
      .srgb_equivalent = PIPE_FORMAT_NONE,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_R64_SINT] = {
      .format = PIPE_FORMAT_R64_SINT,
      .name = "PIPE_FORMAT_R64_SINT",
      .short_name = "r64_sint",
      .block = {1, 1, 1, 64},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_PLAIN,
      .nr_channels = 1,	/* nr_channels */
      .is_array = true,	/* is_array */
      .is_bitmask = false,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = false,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
   {
      {UTIL_FORMAT_TYPE_SIGNED, false, true, 64, 0},	/* x = r */
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0}
   },
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_0,	/* g */
      PIPE_SWIZZLE_0,	/* b */
      PIPE_SWIZZLE_1	/* a */
   },
      .colorspace = UTIL_FORMAT_COLORSPACE_RGB,
      .srgb_equivalent = PIPE_FORMAT_NONE,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_R64G64_SINT] = {
      .format = PIPE_FORMAT_R64G64_SINT,
      .name = "PIPE_FORMAT_R64G64_SINT",
      .short_name = "r64g64_sint",
      .block = {1, 1, 1, 128},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_PLAIN,
      .nr_channels = 2,	/* nr_channels */
      .is_array = true,	/* is_array */
      .is_bitmask = false,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = false,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
#if UTIL_ARCH_BIG_ENDIAN
   {
      {UTIL_FORMAT_TYPE_SIGNED, false, true, 64, 64},	/* x = r */
      {UTIL_FORMAT_TYPE_SIGNED, false, true, 64, 0},	/* y = g */
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0}
   },
#else
   {
      {UTIL_FORMAT_TYPE_SIGNED, false, true, 64, 0},	/* x = r */
      {UTIL_FORMAT_TYPE_SIGNED, false, true, 64, 64},	/* y = g */
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0}
   },
#endif
#if UTIL_ARCH_BIG_ENDIAN
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_Y,	/* g */
      PIPE_SWIZZLE_0,	/* b */
      PIPE_SWIZZLE_1	/* a */
   },
#else
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_Y,	/* g */
      PIPE_SWIZZLE_0,	/* b */
      PIPE_SWIZZLE_1	/* a */
   },
#endif
      .colorspace = UTIL_FORMAT_COLORSPACE_RGB,
      .srgb_equivalent = PIPE_FORMAT_NONE,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_R64G64B64_SINT] = {
      .format = PIPE_FORMAT_R64G64B64_SINT,
      .name = "PIPE_FORMAT_R64G64B64_SINT",
      .short_name = "r64g64b64_sint",
      .block = {1, 1, 1, 192},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_PLAIN,
      .nr_channels = 3,	/* nr_channels */
      .is_array = true,	/* is_array */
      .is_bitmask = false,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = false,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
#if UTIL_ARCH_BIG_ENDIAN
   {
      {UTIL_FORMAT_TYPE_SIGNED, false, true, 64, 128},	/* x = r */
      {UTIL_FORMAT_TYPE_SIGNED, false, true, 64, 64},	/* y = g */
      {UTIL_FORMAT_TYPE_SIGNED, false, true, 64, 0},	/* z = b */
      {0, 0, 0, 0, 0}
   },
#else
   {
      {UTIL_FORMAT_TYPE_SIGNED, false, true, 64, 0},	/* x = r */
      {UTIL_FORMAT_TYPE_SIGNED, false, true, 64, 64},	/* y = g */
      {UTIL_FORMAT_TYPE_SIGNED, false, true, 64, 128},	/* z = b */
      {0, 0, 0, 0, 0}
   },
#endif
#if UTIL_ARCH_BIG_ENDIAN
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_Y,	/* g */
      PIPE_SWIZZLE_Z,	/* b */
      PIPE_SWIZZLE_1	/* a */
   },
#else
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_Y,	/* g */
      PIPE_SWIZZLE_Z,	/* b */
      PIPE_SWIZZLE_1	/* a */
   },
#endif
      .colorspace = UTIL_FORMAT_COLORSPACE_RGB,
      .srgb_equivalent = PIPE_FORMAT_NONE,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_R64G64B64A64_SINT] = {
      .format = PIPE_FORMAT_R64G64B64A64_SINT,
      .name = "PIPE_FORMAT_R64G64B64A64_SINT",
      .short_name = "r64g64b64a64_sint",
      .block = {1, 1, 1, 256},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_PLAIN,
      .nr_channels = 4,	/* nr_channels */
      .is_array = true,	/* is_array */
      .is_bitmask = false,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = false,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
#if UTIL_ARCH_BIG_ENDIAN
   {
      {UTIL_FORMAT_TYPE_SIGNED, false, true, 64, 192},	/* x = r */
      {UTIL_FORMAT_TYPE_SIGNED, false, true, 64, 128},	/* y = g */
      {UTIL_FORMAT_TYPE_SIGNED, false, true, 64, 64},	/* z = b */
      {UTIL_FORMAT_TYPE_SIGNED, false, true, 64, 0}	/* w = a */
   },
#else
   {
      {UTIL_FORMAT_TYPE_SIGNED, false, true, 64, 0},	/* x = r */
      {UTIL_FORMAT_TYPE_SIGNED, false, true, 64, 64},	/* y = g */
      {UTIL_FORMAT_TYPE_SIGNED, false, true, 64, 128},	/* z = b */
      {UTIL_FORMAT_TYPE_SIGNED, false, true, 64, 192}	/* w = a */
   },
#endif
#if UTIL_ARCH_BIG_ENDIAN
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_Y,	/* g */
      PIPE_SWIZZLE_Z,	/* b */
      PIPE_SWIZZLE_W	/* a */
   },
#else
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_Y,	/* g */
      PIPE_SWIZZLE_Z,	/* b */
      PIPE_SWIZZLE_W	/* a */
   },
#endif
      .colorspace = UTIL_FORMAT_COLORSPACE_RGB,
      .srgb_equivalent = PIPE_FORMAT_NONE,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_A8_UINT] = {
      .format = PIPE_FORMAT_A8_UINT,
      .name = "PIPE_FORMAT_A8_UINT",
      .short_name = "a8_uint",
      .block = {1, 1, 1, 8},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_PLAIN,
      .nr_channels = 1,	/* nr_channels */
      .is_array = true,	/* is_array */
      .is_bitmask = true,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = false,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
   {
      {UTIL_FORMAT_TYPE_UNSIGNED, false, true, 8, 0},	/* x = a */
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0}
   },
   {
      PIPE_SWIZZLE_0,	/* r */
      PIPE_SWIZZLE_0,	/* g */
      PIPE_SWIZZLE_0,	/* b */
      PIPE_SWIZZLE_X	/* a */
   },
      .colorspace = UTIL_FORMAT_COLORSPACE_RGB,
      .srgb_equivalent = PIPE_FORMAT_NONE,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_I8_UINT] = {
      .format = PIPE_FORMAT_I8_UINT,
      .name = "PIPE_FORMAT_I8_UINT",
      .short_name = "i8_uint",
      .block = {1, 1, 1, 8},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_PLAIN,
      .nr_channels = 1,	/* nr_channels */
      .is_array = true,	/* is_array */
      .is_bitmask = true,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = false,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
   {
      {UTIL_FORMAT_TYPE_UNSIGNED, false, true, 8, 0},	/* x = rgba */
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0}
   },
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_X,	/* g */
      PIPE_SWIZZLE_X,	/* b */
      PIPE_SWIZZLE_X	/* a */
   },
      .colorspace = UTIL_FORMAT_COLORSPACE_RGB,
      .srgb_equivalent = PIPE_FORMAT_NONE,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_L8_UINT] = {
      .format = PIPE_FORMAT_L8_UINT,
      .name = "PIPE_FORMAT_L8_UINT",
      .short_name = "l8_uint",
      .block = {1, 1, 1, 8},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_PLAIN,
      .nr_channels = 1,	/* nr_channels */
      .is_array = true,	/* is_array */
      .is_bitmask = true,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = false,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
   {
      {UTIL_FORMAT_TYPE_UNSIGNED, false, true, 8, 0},	/* x = rgb */
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0}
   },
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_X,	/* g */
      PIPE_SWIZZLE_X,	/* b */
      PIPE_SWIZZLE_1	/* a */
   },
      .colorspace = UTIL_FORMAT_COLORSPACE_RGB,
      .srgb_equivalent = PIPE_FORMAT_NONE,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_L8A8_UINT] = {
      .format = PIPE_FORMAT_L8A8_UINT,
      .name = "PIPE_FORMAT_L8A8_UINT",
      .short_name = "l8a8_uint",
      .block = {1, 1, 1, 16},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_PLAIN,
      .nr_channels = 2,	/* nr_channels */
      .is_array = true,	/* is_array */
      .is_bitmask = true,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = false,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
#if UTIL_ARCH_BIG_ENDIAN
   {
      {UTIL_FORMAT_TYPE_UNSIGNED, false, true, 8, 8},	/* x = rgb */
      {UTIL_FORMAT_TYPE_UNSIGNED, false, true, 8, 0},	/* y = a */
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0}
   },
#else
   {
      {UTIL_FORMAT_TYPE_UNSIGNED, false, true, 8, 0},	/* x = rgb */
      {UTIL_FORMAT_TYPE_UNSIGNED, false, true, 8, 8},	/* y = a */
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0}
   },
#endif
#if UTIL_ARCH_BIG_ENDIAN
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_X,	/* g */
      PIPE_SWIZZLE_X,	/* b */
      PIPE_SWIZZLE_Y	/* a */
   },
#else
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_X,	/* g */
      PIPE_SWIZZLE_X,	/* b */
      PIPE_SWIZZLE_Y	/* a */
   },
#endif
      .colorspace = UTIL_FORMAT_COLORSPACE_RGB,
      .srgb_equivalent = PIPE_FORMAT_NONE,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_A8_SINT] = {
      .format = PIPE_FORMAT_A8_SINT,
      .name = "PIPE_FORMAT_A8_SINT",
      .short_name = "a8_sint",
      .block = {1, 1, 1, 8},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_PLAIN,
      .nr_channels = 1,	/* nr_channels */
      .is_array = true,	/* is_array */
      .is_bitmask = true,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = false,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
   {
      {UTIL_FORMAT_TYPE_SIGNED, false, true, 8, 0},	/* x = a */
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0}
   },
   {
      PIPE_SWIZZLE_0,	/* r */
      PIPE_SWIZZLE_0,	/* g */
      PIPE_SWIZZLE_0,	/* b */
      PIPE_SWIZZLE_X	/* a */
   },
      .colorspace = UTIL_FORMAT_COLORSPACE_RGB,
      .srgb_equivalent = PIPE_FORMAT_NONE,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_I8_SINT] = {
      .format = PIPE_FORMAT_I8_SINT,
      .name = "PIPE_FORMAT_I8_SINT",
      .short_name = "i8_sint",
      .block = {1, 1, 1, 8},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_PLAIN,
      .nr_channels = 1,	/* nr_channels */
      .is_array = true,	/* is_array */
      .is_bitmask = true,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = false,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
   {
      {UTIL_FORMAT_TYPE_SIGNED, false, true, 8, 0},	/* x = rgba */
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0}
   },
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_X,	/* g */
      PIPE_SWIZZLE_X,	/* b */
      PIPE_SWIZZLE_X	/* a */
   },
      .colorspace = UTIL_FORMAT_COLORSPACE_RGB,
      .srgb_equivalent = PIPE_FORMAT_NONE,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_L8_SINT] = {
      .format = PIPE_FORMAT_L8_SINT,
      .name = "PIPE_FORMAT_L8_SINT",
      .short_name = "l8_sint",
      .block = {1, 1, 1, 8},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_PLAIN,
      .nr_channels = 1,	/* nr_channels */
      .is_array = true,	/* is_array */
      .is_bitmask = true,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = false,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
   {
      {UTIL_FORMAT_TYPE_SIGNED, false, true, 8, 0},	/* x = rgb */
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0}
   },
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_X,	/* g */
      PIPE_SWIZZLE_X,	/* b */
      PIPE_SWIZZLE_1	/* a */
   },
      .colorspace = UTIL_FORMAT_COLORSPACE_RGB,
      .srgb_equivalent = PIPE_FORMAT_NONE,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_L8A8_SINT] = {
      .format = PIPE_FORMAT_L8A8_SINT,
      .name = "PIPE_FORMAT_L8A8_SINT",
      .short_name = "l8a8_sint",
      .block = {1, 1, 1, 16},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_PLAIN,
      .nr_channels = 2,	/* nr_channels */
      .is_array = true,	/* is_array */
      .is_bitmask = true,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = false,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
#if UTIL_ARCH_BIG_ENDIAN
   {
      {UTIL_FORMAT_TYPE_SIGNED, false, true, 8, 8},	/* x = rgb */
      {UTIL_FORMAT_TYPE_SIGNED, false, true, 8, 0},	/* y = a */
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0}
   },
#else
   {
      {UTIL_FORMAT_TYPE_SIGNED, false, true, 8, 0},	/* x = rgb */
      {UTIL_FORMAT_TYPE_SIGNED, false, true, 8, 8},	/* y = a */
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0}
   },
#endif
#if UTIL_ARCH_BIG_ENDIAN
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_X,	/* g */
      PIPE_SWIZZLE_X,	/* b */
      PIPE_SWIZZLE_Y	/* a */
   },
#else
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_X,	/* g */
      PIPE_SWIZZLE_X,	/* b */
      PIPE_SWIZZLE_Y	/* a */
   },
#endif
      .colorspace = UTIL_FORMAT_COLORSPACE_RGB,
      .srgb_equivalent = PIPE_FORMAT_NONE,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_A16_UINT] = {
      .format = PIPE_FORMAT_A16_UINT,
      .name = "PIPE_FORMAT_A16_UINT",
      .short_name = "a16_uint",
      .block = {1, 1, 1, 16},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_PLAIN,
      .nr_channels = 1,	/* nr_channels */
      .is_array = true,	/* is_array */
      .is_bitmask = true,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = false,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
   {
      {UTIL_FORMAT_TYPE_UNSIGNED, false, true, 16, 0},	/* x = a */
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0}
   },
   {
      PIPE_SWIZZLE_0,	/* r */
      PIPE_SWIZZLE_0,	/* g */
      PIPE_SWIZZLE_0,	/* b */
      PIPE_SWIZZLE_X	/* a */
   },
      .colorspace = UTIL_FORMAT_COLORSPACE_RGB,
      .srgb_equivalent = PIPE_FORMAT_NONE,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_I16_UINT] = {
      .format = PIPE_FORMAT_I16_UINT,
      .name = "PIPE_FORMAT_I16_UINT",
      .short_name = "i16_uint",
      .block = {1, 1, 1, 16},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_PLAIN,
      .nr_channels = 1,	/* nr_channels */
      .is_array = true,	/* is_array */
      .is_bitmask = true,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = false,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
   {
      {UTIL_FORMAT_TYPE_UNSIGNED, false, true, 16, 0},	/* x = rgba */
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0}
   },
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_X,	/* g */
      PIPE_SWIZZLE_X,	/* b */
      PIPE_SWIZZLE_X	/* a */
   },
      .colorspace = UTIL_FORMAT_COLORSPACE_RGB,
      .srgb_equivalent = PIPE_FORMAT_NONE,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_L16_UINT] = {
      .format = PIPE_FORMAT_L16_UINT,
      .name = "PIPE_FORMAT_L16_UINT",
      .short_name = "l16_uint",
      .block = {1, 1, 1, 16},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_PLAIN,
      .nr_channels = 1,	/* nr_channels */
      .is_array = true,	/* is_array */
      .is_bitmask = true,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = false,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
   {
      {UTIL_FORMAT_TYPE_UNSIGNED, false, true, 16, 0},	/* x = rgb */
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0}
   },
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_X,	/* g */
      PIPE_SWIZZLE_X,	/* b */
      PIPE_SWIZZLE_1	/* a */
   },
      .colorspace = UTIL_FORMAT_COLORSPACE_RGB,
      .srgb_equivalent = PIPE_FORMAT_NONE,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_L16A16_UINT] = {
      .format = PIPE_FORMAT_L16A16_UINT,
      .name = "PIPE_FORMAT_L16A16_UINT",
      .short_name = "l16a16_uint",
      .block = {1, 1, 1, 32},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_PLAIN,
      .nr_channels = 2,	/* nr_channels */
      .is_array = true,	/* is_array */
      .is_bitmask = true,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = false,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
#if UTIL_ARCH_BIG_ENDIAN
   {
      {UTIL_FORMAT_TYPE_UNSIGNED, false, true, 16, 16},	/* x = rgb */
      {UTIL_FORMAT_TYPE_UNSIGNED, false, true, 16, 0},	/* y = a */
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0}
   },
#else
   {
      {UTIL_FORMAT_TYPE_UNSIGNED, false, true, 16, 0},	/* x = rgb */
      {UTIL_FORMAT_TYPE_UNSIGNED, false, true, 16, 16},	/* y = a */
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0}
   },
#endif
#if UTIL_ARCH_BIG_ENDIAN
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_X,	/* g */
      PIPE_SWIZZLE_X,	/* b */
      PIPE_SWIZZLE_Y	/* a */
   },
#else
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_X,	/* g */
      PIPE_SWIZZLE_X,	/* b */
      PIPE_SWIZZLE_Y	/* a */
   },
#endif
      .colorspace = UTIL_FORMAT_COLORSPACE_RGB,
      .srgb_equivalent = PIPE_FORMAT_NONE,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_A16_SINT] = {
      .format = PIPE_FORMAT_A16_SINT,
      .name = "PIPE_FORMAT_A16_SINT",
      .short_name = "a16_sint",
      .block = {1, 1, 1, 16},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_PLAIN,
      .nr_channels = 1,	/* nr_channels */
      .is_array = true,	/* is_array */
      .is_bitmask = true,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = false,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
   {
      {UTIL_FORMAT_TYPE_SIGNED, false, true, 16, 0},	/* x = a */
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0}
   },
   {
      PIPE_SWIZZLE_0,	/* r */
      PIPE_SWIZZLE_0,	/* g */
      PIPE_SWIZZLE_0,	/* b */
      PIPE_SWIZZLE_X	/* a */
   },
      .colorspace = UTIL_FORMAT_COLORSPACE_RGB,
      .srgb_equivalent = PIPE_FORMAT_NONE,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_I16_SINT] = {
      .format = PIPE_FORMAT_I16_SINT,
      .name = "PIPE_FORMAT_I16_SINT",
      .short_name = "i16_sint",
      .block = {1, 1, 1, 16},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_PLAIN,
      .nr_channels = 1,	/* nr_channels */
      .is_array = true,	/* is_array */
      .is_bitmask = true,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = false,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
   {
      {UTIL_FORMAT_TYPE_SIGNED, false, true, 16, 0},	/* x = rgba */
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0}
   },
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_X,	/* g */
      PIPE_SWIZZLE_X,	/* b */
      PIPE_SWIZZLE_X	/* a */
   },
      .colorspace = UTIL_FORMAT_COLORSPACE_RGB,
      .srgb_equivalent = PIPE_FORMAT_NONE,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_L16_SINT] = {
      .format = PIPE_FORMAT_L16_SINT,
      .name = "PIPE_FORMAT_L16_SINT",
      .short_name = "l16_sint",
      .block = {1, 1, 1, 16},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_PLAIN,
      .nr_channels = 1,	/* nr_channels */
      .is_array = true,	/* is_array */
      .is_bitmask = true,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = false,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
   {
      {UTIL_FORMAT_TYPE_SIGNED, false, true, 16, 0},	/* x = rgb */
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0}
   },
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_X,	/* g */
      PIPE_SWIZZLE_X,	/* b */
      PIPE_SWIZZLE_1	/* a */
   },
      .colorspace = UTIL_FORMAT_COLORSPACE_RGB,
      .srgb_equivalent = PIPE_FORMAT_NONE,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_L16A16_SINT] = {
      .format = PIPE_FORMAT_L16A16_SINT,
      .name = "PIPE_FORMAT_L16A16_SINT",
      .short_name = "l16a16_sint",
      .block = {1, 1, 1, 32},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_PLAIN,
      .nr_channels = 2,	/* nr_channels */
      .is_array = true,	/* is_array */
      .is_bitmask = true,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = false,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
#if UTIL_ARCH_BIG_ENDIAN
   {
      {UTIL_FORMAT_TYPE_SIGNED, false, true, 16, 16},	/* x = rgb */
      {UTIL_FORMAT_TYPE_SIGNED, false, true, 16, 0},	/* y = a */
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0}
   },
#else
   {
      {UTIL_FORMAT_TYPE_SIGNED, false, true, 16, 0},	/* x = rgb */
      {UTIL_FORMAT_TYPE_SIGNED, false, true, 16, 16},	/* y = a */
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0}
   },
#endif
#if UTIL_ARCH_BIG_ENDIAN
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_X,	/* g */
      PIPE_SWIZZLE_X,	/* b */
      PIPE_SWIZZLE_Y	/* a */
   },
#else
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_X,	/* g */
      PIPE_SWIZZLE_X,	/* b */
      PIPE_SWIZZLE_Y	/* a */
   },
#endif
      .colorspace = UTIL_FORMAT_COLORSPACE_RGB,
      .srgb_equivalent = PIPE_FORMAT_NONE,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_A32_UINT] = {
      .format = PIPE_FORMAT_A32_UINT,
      .name = "PIPE_FORMAT_A32_UINT",
      .short_name = "a32_uint",
      .block = {1, 1, 1, 32},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_PLAIN,
      .nr_channels = 1,	/* nr_channels */
      .is_array = true,	/* is_array */
      .is_bitmask = true,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = false,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
   {
      {UTIL_FORMAT_TYPE_UNSIGNED, false, true, 32, 0},	/* x = a */
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0}
   },
   {
      PIPE_SWIZZLE_0,	/* r */
      PIPE_SWIZZLE_0,	/* g */
      PIPE_SWIZZLE_0,	/* b */
      PIPE_SWIZZLE_X	/* a */
   },
      .colorspace = UTIL_FORMAT_COLORSPACE_RGB,
      .srgb_equivalent = PIPE_FORMAT_NONE,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_I32_UINT] = {
      .format = PIPE_FORMAT_I32_UINT,
      .name = "PIPE_FORMAT_I32_UINT",
      .short_name = "i32_uint",
      .block = {1, 1, 1, 32},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_PLAIN,
      .nr_channels = 1,	/* nr_channels */
      .is_array = true,	/* is_array */
      .is_bitmask = true,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = false,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
   {
      {UTIL_FORMAT_TYPE_UNSIGNED, false, true, 32, 0},	/* x = rgba */
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0}
   },
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_X,	/* g */
      PIPE_SWIZZLE_X,	/* b */
      PIPE_SWIZZLE_X	/* a */
   },
      .colorspace = UTIL_FORMAT_COLORSPACE_RGB,
      .srgb_equivalent = PIPE_FORMAT_NONE,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_L32_UINT] = {
      .format = PIPE_FORMAT_L32_UINT,
      .name = "PIPE_FORMAT_L32_UINT",
      .short_name = "l32_uint",
      .block = {1, 1, 1, 32},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_PLAIN,
      .nr_channels = 1,	/* nr_channels */
      .is_array = true,	/* is_array */
      .is_bitmask = true,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = false,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
   {
      {UTIL_FORMAT_TYPE_UNSIGNED, false, true, 32, 0},	/* x = rgb */
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0}
   },
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_X,	/* g */
      PIPE_SWIZZLE_X,	/* b */
      PIPE_SWIZZLE_1	/* a */
   },
      .colorspace = UTIL_FORMAT_COLORSPACE_RGB,
      .srgb_equivalent = PIPE_FORMAT_NONE,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_L32A32_UINT] = {
      .format = PIPE_FORMAT_L32A32_UINT,
      .name = "PIPE_FORMAT_L32A32_UINT",
      .short_name = "l32a32_uint",
      .block = {1, 1, 1, 64},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_PLAIN,
      .nr_channels = 2,	/* nr_channels */
      .is_array = true,	/* is_array */
      .is_bitmask = false,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = false,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
#if UTIL_ARCH_BIG_ENDIAN
   {
      {UTIL_FORMAT_TYPE_UNSIGNED, false, true, 32, 32},	/* x = rgb */
      {UTIL_FORMAT_TYPE_UNSIGNED, false, true, 32, 0},	/* y = a */
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0}
   },
#else
   {
      {UTIL_FORMAT_TYPE_UNSIGNED, false, true, 32, 0},	/* x = rgb */
      {UTIL_FORMAT_TYPE_UNSIGNED, false, true, 32, 32},	/* y = a */
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0}
   },
#endif
#if UTIL_ARCH_BIG_ENDIAN
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_X,	/* g */
      PIPE_SWIZZLE_X,	/* b */
      PIPE_SWIZZLE_Y	/* a */
   },
#else
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_X,	/* g */
      PIPE_SWIZZLE_X,	/* b */
      PIPE_SWIZZLE_Y	/* a */
   },
#endif
      .colorspace = UTIL_FORMAT_COLORSPACE_RGB,
      .srgb_equivalent = PIPE_FORMAT_NONE,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_A32_SINT] = {
      .format = PIPE_FORMAT_A32_SINT,
      .name = "PIPE_FORMAT_A32_SINT",
      .short_name = "a32_sint",
      .block = {1, 1, 1, 32},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_PLAIN,
      .nr_channels = 1,	/* nr_channels */
      .is_array = true,	/* is_array */
      .is_bitmask = true,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = false,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
   {
      {UTIL_FORMAT_TYPE_SIGNED, false, true, 32, 0},	/* x = a */
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0}
   },
   {
      PIPE_SWIZZLE_0,	/* r */
      PIPE_SWIZZLE_0,	/* g */
      PIPE_SWIZZLE_0,	/* b */
      PIPE_SWIZZLE_X	/* a */
   },
      .colorspace = UTIL_FORMAT_COLORSPACE_RGB,
      .srgb_equivalent = PIPE_FORMAT_NONE,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_I32_SINT] = {
      .format = PIPE_FORMAT_I32_SINT,
      .name = "PIPE_FORMAT_I32_SINT",
      .short_name = "i32_sint",
      .block = {1, 1, 1, 32},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_PLAIN,
      .nr_channels = 1,	/* nr_channels */
      .is_array = true,	/* is_array */
      .is_bitmask = true,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = false,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
   {
      {UTIL_FORMAT_TYPE_SIGNED, false, true, 32, 0},	/* x = rgba */
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0}
   },
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_X,	/* g */
      PIPE_SWIZZLE_X,	/* b */
      PIPE_SWIZZLE_X	/* a */
   },
      .colorspace = UTIL_FORMAT_COLORSPACE_RGB,
      .srgb_equivalent = PIPE_FORMAT_NONE,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_L32_SINT] = {
      .format = PIPE_FORMAT_L32_SINT,
      .name = "PIPE_FORMAT_L32_SINT",
      .short_name = "l32_sint",
      .block = {1, 1, 1, 32},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_PLAIN,
      .nr_channels = 1,	/* nr_channels */
      .is_array = true,	/* is_array */
      .is_bitmask = true,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = false,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
   {
      {UTIL_FORMAT_TYPE_SIGNED, false, true, 32, 0},	/* x = rgb */
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0}
   },
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_X,	/* g */
      PIPE_SWIZZLE_X,	/* b */
      PIPE_SWIZZLE_1	/* a */
   },
      .colorspace = UTIL_FORMAT_COLORSPACE_RGB,
      .srgb_equivalent = PIPE_FORMAT_NONE,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_L32A32_SINT] = {
      .format = PIPE_FORMAT_L32A32_SINT,
      .name = "PIPE_FORMAT_L32A32_SINT",
      .short_name = "l32a32_sint",
      .block = {1, 1, 1, 64},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_PLAIN,
      .nr_channels = 2,	/* nr_channels */
      .is_array = true,	/* is_array */
      .is_bitmask = false,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = false,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
#if UTIL_ARCH_BIG_ENDIAN
   {
      {UTIL_FORMAT_TYPE_SIGNED, false, true, 32, 32},	/* x = rgb */
      {UTIL_FORMAT_TYPE_SIGNED, false, true, 32, 0},	/* y = a */
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0}
   },
#else
   {
      {UTIL_FORMAT_TYPE_SIGNED, false, true, 32, 0},	/* x = rgb */
      {UTIL_FORMAT_TYPE_SIGNED, false, true, 32, 32},	/* y = a */
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0}
   },
#endif
#if UTIL_ARCH_BIG_ENDIAN
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_X,	/* g */
      PIPE_SWIZZLE_X,	/* b */
      PIPE_SWIZZLE_Y	/* a */
   },
#else
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_X,	/* g */
      PIPE_SWIZZLE_X,	/* b */
      PIPE_SWIZZLE_Y	/* a */
   },
#endif
      .colorspace = UTIL_FORMAT_COLORSPACE_RGB,
      .srgb_equivalent = PIPE_FORMAT_NONE,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_B8G8R8_UINT] = {
      .format = PIPE_FORMAT_B8G8R8_UINT,
      .name = "PIPE_FORMAT_B8G8R8_UINT",
      .short_name = "b8g8r8_uint",
      .block = {1, 1, 1, 24},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_PLAIN,
      .nr_channels = 3,	/* nr_channels */
      .is_array = true,	/* is_array */
      .is_bitmask = false,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = false,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
#if UTIL_ARCH_BIG_ENDIAN
   {
      {UTIL_FORMAT_TYPE_UNSIGNED, false, true, 8, 16},	/* x = b */
      {UTIL_FORMAT_TYPE_UNSIGNED, false, true, 8, 8},	/* y = g */
      {UTIL_FORMAT_TYPE_UNSIGNED, false, true, 8, 0},	/* z = r */
      {0, 0, 0, 0, 0}
   },
#else
   {
      {UTIL_FORMAT_TYPE_UNSIGNED, false, true, 8, 0},	/* x = b */
      {UTIL_FORMAT_TYPE_UNSIGNED, false, true, 8, 8},	/* y = g */
      {UTIL_FORMAT_TYPE_UNSIGNED, false, true, 8, 16},	/* z = r */
      {0, 0, 0, 0, 0}
   },
#endif
#if UTIL_ARCH_BIG_ENDIAN
   {
      PIPE_SWIZZLE_Z,	/* r */
      PIPE_SWIZZLE_Y,	/* g */
      PIPE_SWIZZLE_X,	/* b */
      PIPE_SWIZZLE_1	/* a */
   },
#else
   {
      PIPE_SWIZZLE_Z,	/* r */
      PIPE_SWIZZLE_Y,	/* g */
      PIPE_SWIZZLE_X,	/* b */
      PIPE_SWIZZLE_1	/* a */
   },
#endif
      .colorspace = UTIL_FORMAT_COLORSPACE_RGB,
      .srgb_equivalent = PIPE_FORMAT_NONE,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_B8G8R8A8_UINT] = {
      .format = PIPE_FORMAT_B8G8R8A8_UINT,
      .name = "PIPE_FORMAT_B8G8R8A8_UINT",
      .short_name = "b8g8r8a8_uint",
      .block = {1, 1, 1, 32},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_PLAIN,
      .nr_channels = 4,	/* nr_channels */
      .is_array = true,	/* is_array */
      .is_bitmask = true,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = false,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
#if UTIL_ARCH_BIG_ENDIAN
   {
      {UTIL_FORMAT_TYPE_UNSIGNED, false, true, 8, 24},	/* x = b */
      {UTIL_FORMAT_TYPE_UNSIGNED, false, true, 8, 16},	/* y = g */
      {UTIL_FORMAT_TYPE_UNSIGNED, false, true, 8, 8},	/* z = r */
      {UTIL_FORMAT_TYPE_UNSIGNED, false, true, 8, 0}	/* w = a */
   },
#else
   {
      {UTIL_FORMAT_TYPE_UNSIGNED, false, true, 8, 0},	/* x = b */
      {UTIL_FORMAT_TYPE_UNSIGNED, false, true, 8, 8},	/* y = g */
      {UTIL_FORMAT_TYPE_UNSIGNED, false, true, 8, 16},	/* z = r */
      {UTIL_FORMAT_TYPE_UNSIGNED, false, true, 8, 24}	/* w = a */
   },
#endif
#if UTIL_ARCH_BIG_ENDIAN
   {
      PIPE_SWIZZLE_Z,	/* r */
      PIPE_SWIZZLE_Y,	/* g */
      PIPE_SWIZZLE_X,	/* b */
      PIPE_SWIZZLE_W	/* a */
   },
#else
   {
      PIPE_SWIZZLE_Z,	/* r */
      PIPE_SWIZZLE_Y,	/* g */
      PIPE_SWIZZLE_X,	/* b */
      PIPE_SWIZZLE_W	/* a */
   },
#endif
      .colorspace = UTIL_FORMAT_COLORSPACE_RGB,
      .srgb_equivalent = PIPE_FORMAT_NONE,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_B8G8R8_SINT] = {
      .format = PIPE_FORMAT_B8G8R8_SINT,
      .name = "PIPE_FORMAT_B8G8R8_SINT",
      .short_name = "b8g8r8_sint",
      .block = {1, 1, 1, 24},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_PLAIN,
      .nr_channels = 3,	/* nr_channels */
      .is_array = true,	/* is_array */
      .is_bitmask = false,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = false,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
#if UTIL_ARCH_BIG_ENDIAN
   {
      {UTIL_FORMAT_TYPE_SIGNED, false, true, 8, 16},	/* x = b */
      {UTIL_FORMAT_TYPE_SIGNED, false, true, 8, 8},	/* y = g */
      {UTIL_FORMAT_TYPE_SIGNED, false, true, 8, 0},	/* z = r */
      {0, 0, 0, 0, 0}
   },
#else
   {
      {UTIL_FORMAT_TYPE_SIGNED, false, true, 8, 0},	/* x = b */
      {UTIL_FORMAT_TYPE_SIGNED, false, true, 8, 8},	/* y = g */
      {UTIL_FORMAT_TYPE_SIGNED, false, true, 8, 16},	/* z = r */
      {0, 0, 0, 0, 0}
   },
#endif
#if UTIL_ARCH_BIG_ENDIAN
   {
      PIPE_SWIZZLE_Z,	/* r */
      PIPE_SWIZZLE_Y,	/* g */
      PIPE_SWIZZLE_X,	/* b */
      PIPE_SWIZZLE_1	/* a */
   },
#else
   {
      PIPE_SWIZZLE_Z,	/* r */
      PIPE_SWIZZLE_Y,	/* g */
      PIPE_SWIZZLE_X,	/* b */
      PIPE_SWIZZLE_1	/* a */
   },
#endif
      .colorspace = UTIL_FORMAT_COLORSPACE_RGB,
      .srgb_equivalent = PIPE_FORMAT_NONE,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_B8G8R8A8_SINT] = {
      .format = PIPE_FORMAT_B8G8R8A8_SINT,
      .name = "PIPE_FORMAT_B8G8R8A8_SINT",
      .short_name = "b8g8r8a8_sint",
      .block = {1, 1, 1, 32},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_PLAIN,
      .nr_channels = 4,	/* nr_channels */
      .is_array = true,	/* is_array */
      .is_bitmask = true,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = false,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
#if UTIL_ARCH_BIG_ENDIAN
   {
      {UTIL_FORMAT_TYPE_SIGNED, false, true, 8, 24},	/* x = b */
      {UTIL_FORMAT_TYPE_SIGNED, false, true, 8, 16},	/* y = g */
      {UTIL_FORMAT_TYPE_SIGNED, false, true, 8, 8},	/* z = r */
      {UTIL_FORMAT_TYPE_SIGNED, false, true, 8, 0}	/* w = a */
   },
#else
   {
      {UTIL_FORMAT_TYPE_SIGNED, false, true, 8, 0},	/* x = b */
      {UTIL_FORMAT_TYPE_SIGNED, false, true, 8, 8},	/* y = g */
      {UTIL_FORMAT_TYPE_SIGNED, false, true, 8, 16},	/* z = r */
      {UTIL_FORMAT_TYPE_SIGNED, false, true, 8, 24}	/* w = a */
   },
#endif
#if UTIL_ARCH_BIG_ENDIAN
   {
      PIPE_SWIZZLE_Z,	/* r */
      PIPE_SWIZZLE_Y,	/* g */
      PIPE_SWIZZLE_X,	/* b */
      PIPE_SWIZZLE_W	/* a */
   },
#else
   {
      PIPE_SWIZZLE_Z,	/* r */
      PIPE_SWIZZLE_Y,	/* g */
      PIPE_SWIZZLE_X,	/* b */
      PIPE_SWIZZLE_W	/* a */
   },
#endif
      .colorspace = UTIL_FORMAT_COLORSPACE_RGB,
      .srgb_equivalent = PIPE_FORMAT_NONE,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_A8R8G8B8_UINT] = {
      .format = PIPE_FORMAT_A8R8G8B8_UINT,
      .name = "PIPE_FORMAT_A8R8G8B8_UINT",
      .short_name = "a8r8g8b8_uint",
      .block = {1, 1, 1, 32},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_PLAIN,
      .nr_channels = 4,	/* nr_channels */
      .is_array = true,	/* is_array */
      .is_bitmask = true,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = false,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
#if UTIL_ARCH_BIG_ENDIAN
   {
      {UTIL_FORMAT_TYPE_UNSIGNED, false, true, 8, 24},	/* x = a */
      {UTIL_FORMAT_TYPE_UNSIGNED, false, true, 8, 16},	/* y = r */
      {UTIL_FORMAT_TYPE_UNSIGNED, false, true, 8, 8},	/* z = g */
      {UTIL_FORMAT_TYPE_UNSIGNED, false, true, 8, 0}	/* w = b */
   },
#else
   {
      {UTIL_FORMAT_TYPE_UNSIGNED, false, true, 8, 0},	/* x = a */
      {UTIL_FORMAT_TYPE_UNSIGNED, false, true, 8, 8},	/* y = r */
      {UTIL_FORMAT_TYPE_UNSIGNED, false, true, 8, 16},	/* z = g */
      {UTIL_FORMAT_TYPE_UNSIGNED, false, true, 8, 24}	/* w = b */
   },
#endif
#if UTIL_ARCH_BIG_ENDIAN
   {
      PIPE_SWIZZLE_Y,	/* r */
      PIPE_SWIZZLE_Z,	/* g */
      PIPE_SWIZZLE_W,	/* b */
      PIPE_SWIZZLE_X	/* a */
   },
#else
   {
      PIPE_SWIZZLE_Y,	/* r */
      PIPE_SWIZZLE_Z,	/* g */
      PIPE_SWIZZLE_W,	/* b */
      PIPE_SWIZZLE_X	/* a */
   },
#endif
      .colorspace = UTIL_FORMAT_COLORSPACE_RGB,
      .srgb_equivalent = PIPE_FORMAT_NONE,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_A8B8G8R8_UINT] = {
      .format = PIPE_FORMAT_A8B8G8R8_UINT,
      .name = "PIPE_FORMAT_A8B8G8R8_UINT",
      .short_name = "a8b8g8r8_uint",
      .block = {1, 1, 1, 32},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_PLAIN,
      .nr_channels = 4,	/* nr_channels */
      .is_array = true,	/* is_array */
      .is_bitmask = true,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = false,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
#if UTIL_ARCH_BIG_ENDIAN
   {
      {UTIL_FORMAT_TYPE_UNSIGNED, false, true, 8, 24},	/* x = a */
      {UTIL_FORMAT_TYPE_UNSIGNED, false, true, 8, 16},	/* y = b */
      {UTIL_FORMAT_TYPE_UNSIGNED, false, true, 8, 8},	/* z = g */
      {UTIL_FORMAT_TYPE_UNSIGNED, false, true, 8, 0}	/* w = r */
   },
#else
   {
      {UTIL_FORMAT_TYPE_UNSIGNED, false, true, 8, 0},	/* x = a */
      {UTIL_FORMAT_TYPE_UNSIGNED, false, true, 8, 8},	/* y = b */
      {UTIL_FORMAT_TYPE_UNSIGNED, false, true, 8, 16},	/* z = g */
      {UTIL_FORMAT_TYPE_UNSIGNED, false, true, 8, 24}	/* w = r */
   },
#endif
#if UTIL_ARCH_BIG_ENDIAN
   {
      PIPE_SWIZZLE_W,	/* r */
      PIPE_SWIZZLE_Z,	/* g */
      PIPE_SWIZZLE_Y,	/* b */
      PIPE_SWIZZLE_X	/* a */
   },
#else
   {
      PIPE_SWIZZLE_W,	/* r */
      PIPE_SWIZZLE_Z,	/* g */
      PIPE_SWIZZLE_Y,	/* b */
      PIPE_SWIZZLE_X	/* a */
   },
#endif
      .colorspace = UTIL_FORMAT_COLORSPACE_RGB,
      .srgb_equivalent = PIPE_FORMAT_NONE,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_A2R10G10B10_UINT] = {
      .format = PIPE_FORMAT_A2R10G10B10_UINT,
      .name = "PIPE_FORMAT_A2R10G10B10_UINT",
      .short_name = "a2r10g10b10_uint",
      .block = {1, 1, 1, 32},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_PLAIN,
      .nr_channels = 4,	/* nr_channels */
      .is_array = false,	/* is_array */
      .is_bitmask = true,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = false,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
#if UTIL_ARCH_BIG_ENDIAN
   {
      {UTIL_FORMAT_TYPE_UNSIGNED, false, true, 10, 22},	/* x = b */
      {UTIL_FORMAT_TYPE_UNSIGNED, false, true, 10, 12},	/* y = g */
      {UTIL_FORMAT_TYPE_UNSIGNED, false, true, 10, 2},	/* z = r */
      {UTIL_FORMAT_TYPE_UNSIGNED, false, true, 2, 0}	/* w = a */
   },
#else
   {
      {UTIL_FORMAT_TYPE_UNSIGNED, false, true, 2, 0},	/* x = a */
      {UTIL_FORMAT_TYPE_UNSIGNED, false, true, 10, 2},	/* y = r */
      {UTIL_FORMAT_TYPE_UNSIGNED, false, true, 10, 12},	/* z = g */
      {UTIL_FORMAT_TYPE_UNSIGNED, false, true, 10, 22}	/* w = b */
   },
#endif
#if UTIL_ARCH_BIG_ENDIAN
   {
      PIPE_SWIZZLE_Z,	/* r */
      PIPE_SWIZZLE_Y,	/* g */
      PIPE_SWIZZLE_X,	/* b */
      PIPE_SWIZZLE_W	/* a */
   },
#else
   {
      PIPE_SWIZZLE_Y,	/* r */
      PIPE_SWIZZLE_Z,	/* g */
      PIPE_SWIZZLE_W,	/* b */
      PIPE_SWIZZLE_X	/* a */
   },
#endif
      .colorspace = UTIL_FORMAT_COLORSPACE_RGB,
      .srgb_equivalent = PIPE_FORMAT_NONE,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_A2B10G10R10_UINT] = {
      .format = PIPE_FORMAT_A2B10G10R10_UINT,
      .name = "PIPE_FORMAT_A2B10G10R10_UINT",
      .short_name = "a2b10g10r10_uint",
      .block = {1, 1, 1, 32},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_PLAIN,
      .nr_channels = 4,	/* nr_channels */
      .is_array = false,	/* is_array */
      .is_bitmask = true,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = false,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
#if UTIL_ARCH_BIG_ENDIAN
   {
      {UTIL_FORMAT_TYPE_UNSIGNED, false, true, 10, 22},	/* x = r */
      {UTIL_FORMAT_TYPE_UNSIGNED, false, true, 10, 12},	/* y = g */
      {UTIL_FORMAT_TYPE_UNSIGNED, false, true, 10, 2},	/* z = b */
      {UTIL_FORMAT_TYPE_UNSIGNED, false, true, 2, 0}	/* w = a */
   },
#else
   {
      {UTIL_FORMAT_TYPE_UNSIGNED, false, true, 2, 0},	/* x = a */
      {UTIL_FORMAT_TYPE_UNSIGNED, false, true, 10, 2},	/* y = b */
      {UTIL_FORMAT_TYPE_UNSIGNED, false, true, 10, 12},	/* z = g */
      {UTIL_FORMAT_TYPE_UNSIGNED, false, true, 10, 22}	/* w = r */
   },
#endif
#if UTIL_ARCH_BIG_ENDIAN
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_Y,	/* g */
      PIPE_SWIZZLE_Z,	/* b */
      PIPE_SWIZZLE_W	/* a */
   },
#else
   {
      PIPE_SWIZZLE_W,	/* r */
      PIPE_SWIZZLE_Z,	/* g */
      PIPE_SWIZZLE_Y,	/* b */
      PIPE_SWIZZLE_X	/* a */
   },
#endif
      .colorspace = UTIL_FORMAT_COLORSPACE_RGB,
      .srgb_equivalent = PIPE_FORMAT_NONE,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_B10G10R10A2_UINT] = {
      .format = PIPE_FORMAT_B10G10R10A2_UINT,
      .name = "PIPE_FORMAT_B10G10R10A2_UINT",
      .short_name = "b10g10r10a2_uint",
      .block = {1, 1, 1, 32},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_PLAIN,
      .nr_channels = 4,	/* nr_channels */
      .is_array = false,	/* is_array */
      .is_bitmask = true,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = false,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
#if UTIL_ARCH_BIG_ENDIAN
   {
      {UTIL_FORMAT_TYPE_UNSIGNED, false, true, 2, 30},	/* x = a */
      {UTIL_FORMAT_TYPE_UNSIGNED, false, true, 10, 20},	/* y = r */
      {UTIL_FORMAT_TYPE_UNSIGNED, false, true, 10, 10},	/* z = g */
      {UTIL_FORMAT_TYPE_UNSIGNED, false, true, 10, 0}	/* w = b */
   },
#else
   {
      {UTIL_FORMAT_TYPE_UNSIGNED, false, true, 10, 0},	/* x = b */
      {UTIL_FORMAT_TYPE_UNSIGNED, false, true, 10, 10},	/* y = g */
      {UTIL_FORMAT_TYPE_UNSIGNED, false, true, 10, 20},	/* z = r */
      {UTIL_FORMAT_TYPE_UNSIGNED, false, true, 2, 30}	/* w = a */
   },
#endif
#if UTIL_ARCH_BIG_ENDIAN
   {
      PIPE_SWIZZLE_Y,	/* r */
      PIPE_SWIZZLE_Z,	/* g */
      PIPE_SWIZZLE_W,	/* b */
      PIPE_SWIZZLE_X	/* a */
   },
#else
   {
      PIPE_SWIZZLE_Z,	/* r */
      PIPE_SWIZZLE_Y,	/* g */
      PIPE_SWIZZLE_X,	/* b */
      PIPE_SWIZZLE_W	/* a */
   },
#endif
      .colorspace = UTIL_FORMAT_COLORSPACE_RGB,
      .srgb_equivalent = PIPE_FORMAT_NONE,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_B10G10R10A2_SINT] = {
      .format = PIPE_FORMAT_B10G10R10A2_SINT,
      .name = "PIPE_FORMAT_B10G10R10A2_SINT",
      .short_name = "b10g10r10a2_sint",
      .block = {1, 1, 1, 32},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_PLAIN,
      .nr_channels = 4,	/* nr_channels */
      .is_array = false,	/* is_array */
      .is_bitmask = true,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = false,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
#if UTIL_ARCH_BIG_ENDIAN
   {
      {UTIL_FORMAT_TYPE_SIGNED, false, true, 2, 30},	/* x = a */
      {UTIL_FORMAT_TYPE_SIGNED, false, true, 10, 20},	/* y = r */
      {UTIL_FORMAT_TYPE_SIGNED, false, true, 10, 10},	/* z = g */
      {UTIL_FORMAT_TYPE_SIGNED, false, true, 10, 0}	/* w = b */
   },
#else
   {
      {UTIL_FORMAT_TYPE_SIGNED, false, true, 10, 0},	/* x = b */
      {UTIL_FORMAT_TYPE_SIGNED, false, true, 10, 10},	/* y = g */
      {UTIL_FORMAT_TYPE_SIGNED, false, true, 10, 20},	/* z = r */
      {UTIL_FORMAT_TYPE_SIGNED, false, true, 2, 30}	/* w = a */
   },
#endif
#if UTIL_ARCH_BIG_ENDIAN
   {
      PIPE_SWIZZLE_Y,	/* r */
      PIPE_SWIZZLE_Z,	/* g */
      PIPE_SWIZZLE_W,	/* b */
      PIPE_SWIZZLE_X	/* a */
   },
#else
   {
      PIPE_SWIZZLE_Z,	/* r */
      PIPE_SWIZZLE_Y,	/* g */
      PIPE_SWIZZLE_X,	/* b */
      PIPE_SWIZZLE_W	/* a */
   },
#endif
      .colorspace = UTIL_FORMAT_COLORSPACE_RGB,
      .srgb_equivalent = PIPE_FORMAT_NONE,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_R5G6B5_UINT] = {
      .format = PIPE_FORMAT_R5G6B5_UINT,
      .name = "PIPE_FORMAT_R5G6B5_UINT",
      .short_name = "r5g6b5_uint",
      .block = {1, 1, 1, 16},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_PLAIN,
      .nr_channels = 3,	/* nr_channels */
      .is_array = false,	/* is_array */
      .is_bitmask = true,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = false,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
#if UTIL_ARCH_BIG_ENDIAN
   {
      {UTIL_FORMAT_TYPE_UNSIGNED, false, true, 5, 11},	/* x = b */
      {UTIL_FORMAT_TYPE_UNSIGNED, false, true, 6, 5},	/* y = g */
      {UTIL_FORMAT_TYPE_UNSIGNED, false, true, 5, 0},	/* z = r */
      {0, 0, 0, 0, 0}
   },
#else
   {
      {UTIL_FORMAT_TYPE_UNSIGNED, false, true, 5, 0},	/* x = r */
      {UTIL_FORMAT_TYPE_UNSIGNED, false, true, 6, 5},	/* y = g */
      {UTIL_FORMAT_TYPE_UNSIGNED, false, true, 5, 11},	/* z = b */
      {0, 0, 0, 0, 0}
   },
#endif
#if UTIL_ARCH_BIG_ENDIAN
   {
      PIPE_SWIZZLE_Z,	/* r */
      PIPE_SWIZZLE_Y,	/* g */
      PIPE_SWIZZLE_X,	/* b */
      PIPE_SWIZZLE_1	/* a */
   },
#else
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_Y,	/* g */
      PIPE_SWIZZLE_Z,	/* b */
      PIPE_SWIZZLE_1	/* a */
   },
#endif
      .colorspace = UTIL_FORMAT_COLORSPACE_RGB,
      .srgb_equivalent = PIPE_FORMAT_NONE,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_B5G6R5_UINT] = {
      .format = PIPE_FORMAT_B5G6R5_UINT,
      .name = "PIPE_FORMAT_B5G6R5_UINT",
      .short_name = "b5g6r5_uint",
      .block = {1, 1, 1, 16},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_PLAIN,
      .nr_channels = 3,	/* nr_channels */
      .is_array = false,	/* is_array */
      .is_bitmask = true,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = false,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
#if UTIL_ARCH_BIG_ENDIAN
   {
      {UTIL_FORMAT_TYPE_UNSIGNED, false, true, 5, 11},	/* x = r */
      {UTIL_FORMAT_TYPE_UNSIGNED, false, true, 6, 5},	/* y = g */
      {UTIL_FORMAT_TYPE_UNSIGNED, false, true, 5, 0},	/* z = b */
      {0, 0, 0, 0, 0}
   },
#else
   {
      {UTIL_FORMAT_TYPE_UNSIGNED, false, true, 5, 0},	/* x = b */
      {UTIL_FORMAT_TYPE_UNSIGNED, false, true, 6, 5},	/* y = g */
      {UTIL_FORMAT_TYPE_UNSIGNED, false, true, 5, 11},	/* z = r */
      {0, 0, 0, 0, 0}
   },
#endif
#if UTIL_ARCH_BIG_ENDIAN
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_Y,	/* g */
      PIPE_SWIZZLE_Z,	/* b */
      PIPE_SWIZZLE_1	/* a */
   },
#else
   {
      PIPE_SWIZZLE_Z,	/* r */
      PIPE_SWIZZLE_Y,	/* g */
      PIPE_SWIZZLE_X,	/* b */
      PIPE_SWIZZLE_1	/* a */
   },
#endif
      .colorspace = UTIL_FORMAT_COLORSPACE_RGB,
      .srgb_equivalent = PIPE_FORMAT_NONE,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_R3G3B2_UINT] = {
      .format = PIPE_FORMAT_R3G3B2_UINT,
      .name = "PIPE_FORMAT_R3G3B2_UINT",
      .short_name = "r3g3b2_uint",
      .block = {1, 1, 1, 8},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_PLAIN,
      .nr_channels = 3,	/* nr_channels */
      .is_array = false,	/* is_array */
      .is_bitmask = true,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = false,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
#if UTIL_ARCH_BIG_ENDIAN
   {
      {UTIL_FORMAT_TYPE_UNSIGNED, false, true, 2, 6},	/* x = b */
      {UTIL_FORMAT_TYPE_UNSIGNED, false, true, 3, 3},	/* y = g */
      {UTIL_FORMAT_TYPE_UNSIGNED, false, true, 3, 0},	/* z = r */
      {0, 0, 0, 0, 0}
   },
#else
   {
      {UTIL_FORMAT_TYPE_UNSIGNED, false, true, 3, 0},	/* x = r */
      {UTIL_FORMAT_TYPE_UNSIGNED, false, true, 3, 3},	/* y = g */
      {UTIL_FORMAT_TYPE_UNSIGNED, false, true, 2, 6},	/* z = b */
      {0, 0, 0, 0, 0}
   },
#endif
#if UTIL_ARCH_BIG_ENDIAN
   {
      PIPE_SWIZZLE_Z,	/* r */
      PIPE_SWIZZLE_Y,	/* g */
      PIPE_SWIZZLE_X,	/* b */
      PIPE_SWIZZLE_1	/* a */
   },
#else
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_Y,	/* g */
      PIPE_SWIZZLE_Z,	/* b */
      PIPE_SWIZZLE_1	/* a */
   },
#endif
      .colorspace = UTIL_FORMAT_COLORSPACE_RGB,
      .srgb_equivalent = PIPE_FORMAT_NONE,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_B2G3R3_UINT] = {
      .format = PIPE_FORMAT_B2G3R3_UINT,
      .name = "PIPE_FORMAT_B2G3R3_UINT",
      .short_name = "b2g3r3_uint",
      .block = {1, 1, 1, 8},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_PLAIN,
      .nr_channels = 3,	/* nr_channels */
      .is_array = false,	/* is_array */
      .is_bitmask = true,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = false,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
#if UTIL_ARCH_BIG_ENDIAN
   {
      {UTIL_FORMAT_TYPE_UNSIGNED, false, true, 3, 5},	/* x = r */
      {UTIL_FORMAT_TYPE_UNSIGNED, false, true, 3, 2},	/* y = g */
      {UTIL_FORMAT_TYPE_UNSIGNED, false, true, 2, 0},	/* z = b */
      {0, 0, 0, 0, 0}
   },
#else
   {
      {UTIL_FORMAT_TYPE_UNSIGNED, false, true, 2, 0},	/* x = b */
      {UTIL_FORMAT_TYPE_UNSIGNED, false, true, 3, 2},	/* y = g */
      {UTIL_FORMAT_TYPE_UNSIGNED, false, true, 3, 5},	/* z = r */
      {0, 0, 0, 0, 0}
   },
#endif
#if UTIL_ARCH_BIG_ENDIAN
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_Y,	/* g */
      PIPE_SWIZZLE_Z,	/* b */
      PIPE_SWIZZLE_1	/* a */
   },
#else
   {
      PIPE_SWIZZLE_Z,	/* r */
      PIPE_SWIZZLE_Y,	/* g */
      PIPE_SWIZZLE_X,	/* b */
      PIPE_SWIZZLE_1	/* a */
   },
#endif
      .colorspace = UTIL_FORMAT_COLORSPACE_RGB,
      .srgb_equivalent = PIPE_FORMAT_NONE,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_R4G4B4A4_UINT] = {
      .format = PIPE_FORMAT_R4G4B4A4_UINT,
      .name = "PIPE_FORMAT_R4G4B4A4_UINT",
      .short_name = "r4g4b4a4_uint",
      .block = {1, 1, 1, 16},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_PLAIN,
      .nr_channels = 4,	/* nr_channels */
      .is_array = false,	/* is_array */
      .is_bitmask = true,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = false,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
#if UTIL_ARCH_BIG_ENDIAN
   {
      {UTIL_FORMAT_TYPE_UNSIGNED, false, true, 4, 12},	/* x = a */
      {UTIL_FORMAT_TYPE_UNSIGNED, false, true, 4, 8},	/* y = b */
      {UTIL_FORMAT_TYPE_UNSIGNED, false, true, 4, 4},	/* z = g */
      {UTIL_FORMAT_TYPE_UNSIGNED, false, true, 4, 0}	/* w = r */
   },
#else
   {
      {UTIL_FORMAT_TYPE_UNSIGNED, false, true, 4, 0},	/* x = r */
      {UTIL_FORMAT_TYPE_UNSIGNED, false, true, 4, 4},	/* y = g */
      {UTIL_FORMAT_TYPE_UNSIGNED, false, true, 4, 8},	/* z = b */
      {UTIL_FORMAT_TYPE_UNSIGNED, false, true, 4, 12}	/* w = a */
   },
#endif
#if UTIL_ARCH_BIG_ENDIAN
   {
      PIPE_SWIZZLE_W,	/* r */
      PIPE_SWIZZLE_Z,	/* g */
      PIPE_SWIZZLE_Y,	/* b */
      PIPE_SWIZZLE_X	/* a */
   },
#else
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_Y,	/* g */
      PIPE_SWIZZLE_Z,	/* b */
      PIPE_SWIZZLE_W	/* a */
   },
#endif
      .colorspace = UTIL_FORMAT_COLORSPACE_RGB,
      .srgb_equivalent = PIPE_FORMAT_NONE,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_B4G4R4A4_UINT] = {
      .format = PIPE_FORMAT_B4G4R4A4_UINT,
      .name = "PIPE_FORMAT_B4G4R4A4_UINT",
      .short_name = "b4g4r4a4_uint",
      .block = {1, 1, 1, 16},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_PLAIN,
      .nr_channels = 4,	/* nr_channels */
      .is_array = false,	/* is_array */
      .is_bitmask = true,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = false,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
#if UTIL_ARCH_BIG_ENDIAN
   {
      {UTIL_FORMAT_TYPE_UNSIGNED, false, true, 4, 12},	/* x = a */
      {UTIL_FORMAT_TYPE_UNSIGNED, false, true, 4, 8},	/* y = r */
      {UTIL_FORMAT_TYPE_UNSIGNED, false, true, 4, 4},	/* z = g */
      {UTIL_FORMAT_TYPE_UNSIGNED, false, true, 4, 0}	/* w = b */
   },
#else
   {
      {UTIL_FORMAT_TYPE_UNSIGNED, false, true, 4, 0},	/* x = b */
      {UTIL_FORMAT_TYPE_UNSIGNED, false, true, 4, 4},	/* y = g */
      {UTIL_FORMAT_TYPE_UNSIGNED, false, true, 4, 8},	/* z = r */
      {UTIL_FORMAT_TYPE_UNSIGNED, false, true, 4, 12}	/* w = a */
   },
#endif
#if UTIL_ARCH_BIG_ENDIAN
   {
      PIPE_SWIZZLE_Y,	/* r */
      PIPE_SWIZZLE_Z,	/* g */
      PIPE_SWIZZLE_W,	/* b */
      PIPE_SWIZZLE_X	/* a */
   },
#else
   {
      PIPE_SWIZZLE_Z,	/* r */
      PIPE_SWIZZLE_Y,	/* g */
      PIPE_SWIZZLE_X,	/* b */
      PIPE_SWIZZLE_W	/* a */
   },
#endif
      .colorspace = UTIL_FORMAT_COLORSPACE_RGB,
      .srgb_equivalent = PIPE_FORMAT_NONE,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_A4R4G4B4_UINT] = {
      .format = PIPE_FORMAT_A4R4G4B4_UINT,
      .name = "PIPE_FORMAT_A4R4G4B4_UINT",
      .short_name = "a4r4g4b4_uint",
      .block = {1, 1, 1, 16},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_PLAIN,
      .nr_channels = 4,	/* nr_channels */
      .is_array = false,	/* is_array */
      .is_bitmask = true,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = false,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
#if UTIL_ARCH_BIG_ENDIAN
   {
      {UTIL_FORMAT_TYPE_UNSIGNED, false, true, 4, 12},	/* x = b */
      {UTIL_FORMAT_TYPE_UNSIGNED, false, true, 4, 8},	/* y = g */
      {UTIL_FORMAT_TYPE_UNSIGNED, false, true, 4, 4},	/* z = r */
      {UTIL_FORMAT_TYPE_UNSIGNED, false, true, 4, 0}	/* w = a */
   },
#else
   {
      {UTIL_FORMAT_TYPE_UNSIGNED, false, true, 4, 0},	/* x = a */
      {UTIL_FORMAT_TYPE_UNSIGNED, false, true, 4, 4},	/* y = r */
      {UTIL_FORMAT_TYPE_UNSIGNED, false, true, 4, 8},	/* z = g */
      {UTIL_FORMAT_TYPE_UNSIGNED, false, true, 4, 12}	/* w = b */
   },
#endif
#if UTIL_ARCH_BIG_ENDIAN
   {
      PIPE_SWIZZLE_Z,	/* r */
      PIPE_SWIZZLE_Y,	/* g */
      PIPE_SWIZZLE_X,	/* b */
      PIPE_SWIZZLE_W	/* a */
   },
#else
   {
      PIPE_SWIZZLE_Y,	/* r */
      PIPE_SWIZZLE_Z,	/* g */
      PIPE_SWIZZLE_W,	/* b */
      PIPE_SWIZZLE_X	/* a */
   },
#endif
      .colorspace = UTIL_FORMAT_COLORSPACE_RGB,
      .srgb_equivalent = PIPE_FORMAT_NONE,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_A4B4G4R4_UINT] = {
      .format = PIPE_FORMAT_A4B4G4R4_UINT,
      .name = "PIPE_FORMAT_A4B4G4R4_UINT",
      .short_name = "a4b4g4r4_uint",
      .block = {1, 1, 1, 16},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_PLAIN,
      .nr_channels = 4,	/* nr_channels */
      .is_array = false,	/* is_array */
      .is_bitmask = true,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = false,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
#if UTIL_ARCH_BIG_ENDIAN
   {
      {UTIL_FORMAT_TYPE_UNSIGNED, false, true, 4, 12},	/* x = r */
      {UTIL_FORMAT_TYPE_UNSIGNED, false, true, 4, 8},	/* y = g */
      {UTIL_FORMAT_TYPE_UNSIGNED, false, true, 4, 4},	/* z = b */
      {UTIL_FORMAT_TYPE_UNSIGNED, false, true, 4, 0}	/* w = a */
   },
#else
   {
      {UTIL_FORMAT_TYPE_UNSIGNED, false, true, 4, 0},	/* x = a */
      {UTIL_FORMAT_TYPE_UNSIGNED, false, true, 4, 4},	/* y = b */
      {UTIL_FORMAT_TYPE_UNSIGNED, false, true, 4, 8},	/* z = g */
      {UTIL_FORMAT_TYPE_UNSIGNED, false, true, 4, 12}	/* w = r */
   },
#endif
#if UTIL_ARCH_BIG_ENDIAN
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_Y,	/* g */
      PIPE_SWIZZLE_Z,	/* b */
      PIPE_SWIZZLE_W	/* a */
   },
#else
   {
      PIPE_SWIZZLE_W,	/* r */
      PIPE_SWIZZLE_Z,	/* g */
      PIPE_SWIZZLE_Y,	/* b */
      PIPE_SWIZZLE_X	/* a */
   },
#endif
      .colorspace = UTIL_FORMAT_COLORSPACE_RGB,
      .srgb_equivalent = PIPE_FORMAT_NONE,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_A1R5G5B5_UINT] = {
      .format = PIPE_FORMAT_A1R5G5B5_UINT,
      .name = "PIPE_FORMAT_A1R5G5B5_UINT",
      .short_name = "a1r5g5b5_uint",
      .block = {1, 1, 1, 16},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_PLAIN,
      .nr_channels = 4,	/* nr_channels */
      .is_array = false,	/* is_array */
      .is_bitmask = true,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = false,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
#if UTIL_ARCH_BIG_ENDIAN
   {
      {UTIL_FORMAT_TYPE_UNSIGNED, false, true, 5, 11},	/* x = b */
      {UTIL_FORMAT_TYPE_UNSIGNED, false, true, 5, 6},	/* y = g */
      {UTIL_FORMAT_TYPE_UNSIGNED, false, true, 5, 1},	/* z = r */
      {UTIL_FORMAT_TYPE_UNSIGNED, false, true, 1, 0}	/* w = a */
   },
#else
   {
      {UTIL_FORMAT_TYPE_UNSIGNED, false, true, 1, 0},	/* x = a */
      {UTIL_FORMAT_TYPE_UNSIGNED, false, true, 5, 1},	/* y = r */
      {UTIL_FORMAT_TYPE_UNSIGNED, false, true, 5, 6},	/* z = g */
      {UTIL_FORMAT_TYPE_UNSIGNED, false, true, 5, 11}	/* w = b */
   },
#endif
#if UTIL_ARCH_BIG_ENDIAN
   {
      PIPE_SWIZZLE_Z,	/* r */
      PIPE_SWIZZLE_Y,	/* g */
      PIPE_SWIZZLE_X,	/* b */
      PIPE_SWIZZLE_W	/* a */
   },
#else
   {
      PIPE_SWIZZLE_Y,	/* r */
      PIPE_SWIZZLE_Z,	/* g */
      PIPE_SWIZZLE_W,	/* b */
      PIPE_SWIZZLE_X	/* a */
   },
#endif
      .colorspace = UTIL_FORMAT_COLORSPACE_RGB,
      .srgb_equivalent = PIPE_FORMAT_NONE,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_A1B5G5R5_UINT] = {
      .format = PIPE_FORMAT_A1B5G5R5_UINT,
      .name = "PIPE_FORMAT_A1B5G5R5_UINT",
      .short_name = "a1b5g5r5_uint",
      .block = {1, 1, 1, 16},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_PLAIN,
      .nr_channels = 4,	/* nr_channels */
      .is_array = false,	/* is_array */
      .is_bitmask = true,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = false,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
#if UTIL_ARCH_BIG_ENDIAN
   {
      {UTIL_FORMAT_TYPE_UNSIGNED, false, true, 5, 11},	/* x = r */
      {UTIL_FORMAT_TYPE_UNSIGNED, false, true, 5, 6},	/* y = g */
      {UTIL_FORMAT_TYPE_UNSIGNED, false, true, 5, 1},	/* z = b */
      {UTIL_FORMAT_TYPE_UNSIGNED, false, true, 1, 0}	/* w = a */
   },
#else
   {
      {UTIL_FORMAT_TYPE_UNSIGNED, false, true, 1, 0},	/* x = a */
      {UTIL_FORMAT_TYPE_UNSIGNED, false, true, 5, 1},	/* y = b */
      {UTIL_FORMAT_TYPE_UNSIGNED, false, true, 5, 6},	/* z = g */
      {UTIL_FORMAT_TYPE_UNSIGNED, false, true, 5, 11}	/* w = r */
   },
#endif
#if UTIL_ARCH_BIG_ENDIAN
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_Y,	/* g */
      PIPE_SWIZZLE_Z,	/* b */
      PIPE_SWIZZLE_W	/* a */
   },
#else
   {
      PIPE_SWIZZLE_W,	/* r */
      PIPE_SWIZZLE_Z,	/* g */
      PIPE_SWIZZLE_Y,	/* b */
      PIPE_SWIZZLE_X	/* a */
   },
#endif
      .colorspace = UTIL_FORMAT_COLORSPACE_RGB,
      .srgb_equivalent = PIPE_FORMAT_NONE,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_R5G5B5A1_UINT] = {
      .format = PIPE_FORMAT_R5G5B5A1_UINT,
      .name = "PIPE_FORMAT_R5G5B5A1_UINT",
      .short_name = "r5g5b5a1_uint",
      .block = {1, 1, 1, 16},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_PLAIN,
      .nr_channels = 4,	/* nr_channels */
      .is_array = false,	/* is_array */
      .is_bitmask = true,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = false,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
#if UTIL_ARCH_BIG_ENDIAN
   {
      {UTIL_FORMAT_TYPE_UNSIGNED, false, true, 1, 15},	/* x = a */
      {UTIL_FORMAT_TYPE_UNSIGNED, false, true, 5, 10},	/* y = b */
      {UTIL_FORMAT_TYPE_UNSIGNED, false, true, 5, 5},	/* z = g */
      {UTIL_FORMAT_TYPE_UNSIGNED, false, true, 5, 0}	/* w = r */
   },
#else
   {
      {UTIL_FORMAT_TYPE_UNSIGNED, false, true, 5, 0},	/* x = r */
      {UTIL_FORMAT_TYPE_UNSIGNED, false, true, 5, 5},	/* y = g */
      {UTIL_FORMAT_TYPE_UNSIGNED, false, true, 5, 10},	/* z = b */
      {UTIL_FORMAT_TYPE_UNSIGNED, false, true, 1, 15}	/* w = a */
   },
#endif
#if UTIL_ARCH_BIG_ENDIAN
   {
      PIPE_SWIZZLE_W,	/* r */
      PIPE_SWIZZLE_Z,	/* g */
      PIPE_SWIZZLE_Y,	/* b */
      PIPE_SWIZZLE_X	/* a */
   },
#else
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_Y,	/* g */
      PIPE_SWIZZLE_Z,	/* b */
      PIPE_SWIZZLE_W	/* a */
   },
#endif
      .colorspace = UTIL_FORMAT_COLORSPACE_RGB,
      .srgb_equivalent = PIPE_FORMAT_NONE,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_B5G5R5A1_UINT] = {
      .format = PIPE_FORMAT_B5G5R5A1_UINT,
      .name = "PIPE_FORMAT_B5G5R5A1_UINT",
      .short_name = "b5g5r5a1_uint",
      .block = {1, 1, 1, 16},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_PLAIN,
      .nr_channels = 4,	/* nr_channels */
      .is_array = false,	/* is_array */
      .is_bitmask = true,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = false,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
#if UTIL_ARCH_BIG_ENDIAN
   {
      {UTIL_FORMAT_TYPE_UNSIGNED, false, true, 1, 15},	/* x = a */
      {UTIL_FORMAT_TYPE_UNSIGNED, false, true, 5, 10},	/* y = r */
      {UTIL_FORMAT_TYPE_UNSIGNED, false, true, 5, 5},	/* z = g */
      {UTIL_FORMAT_TYPE_UNSIGNED, false, true, 5, 0}	/* w = b */
   },
#else
   {
      {UTIL_FORMAT_TYPE_UNSIGNED, false, true, 5, 0},	/* x = b */
      {UTIL_FORMAT_TYPE_UNSIGNED, false, true, 5, 5},	/* y = g */
      {UTIL_FORMAT_TYPE_UNSIGNED, false, true, 5, 10},	/* z = r */
      {UTIL_FORMAT_TYPE_UNSIGNED, false, true, 1, 15}	/* w = a */
   },
#endif
#if UTIL_ARCH_BIG_ENDIAN
   {
      PIPE_SWIZZLE_Y,	/* r */
      PIPE_SWIZZLE_Z,	/* g */
      PIPE_SWIZZLE_W,	/* b */
      PIPE_SWIZZLE_X	/* a */
   },
#else
   {
      PIPE_SWIZZLE_Z,	/* r */
      PIPE_SWIZZLE_Y,	/* g */
      PIPE_SWIZZLE_X,	/* b */
      PIPE_SWIZZLE_W	/* a */
   },
#endif
      .colorspace = UTIL_FORMAT_COLORSPACE_RGB,
      .srgb_equivalent = PIPE_FORMAT_NONE,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_R8G8B8X8_SNORM] = {
      .format = PIPE_FORMAT_R8G8B8X8_SNORM,
      .name = "PIPE_FORMAT_R8G8B8X8_SNORM",
      .short_name = "r8g8b8x8_snorm",
      .block = {1, 1, 1, 32},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_PLAIN,
      .nr_channels = 4,	/* nr_channels */
      .is_array = true,	/* is_array */
      .is_bitmask = true,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = false,	/* is_unorm */
      .is_snorm = true,	/* is_snorm */
#if UTIL_ARCH_BIG_ENDIAN
   {
      {UTIL_FORMAT_TYPE_SIGNED, true, false, 8, 24},	/* x = r */
      {UTIL_FORMAT_TYPE_SIGNED, true, false, 8, 16},	/* y = g */
      {UTIL_FORMAT_TYPE_SIGNED, true, false, 8, 8},	/* z = b */
      {UTIL_FORMAT_TYPE_VOID, false, false, 8, 0}	/* w = x */
   },
#else
   {
      {UTIL_FORMAT_TYPE_SIGNED, true, false, 8, 0},	/* x = r */
      {UTIL_FORMAT_TYPE_SIGNED, true, false, 8, 8},	/* y = g */
      {UTIL_FORMAT_TYPE_SIGNED, true, false, 8, 16},	/* z = b */
      {UTIL_FORMAT_TYPE_VOID, false, false, 8, 24}	/* w = x */
   },
#endif
#if UTIL_ARCH_BIG_ENDIAN
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_Y,	/* g */
      PIPE_SWIZZLE_Z,	/* b */
      PIPE_SWIZZLE_1	/* a */
   },
#else
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_Y,	/* g */
      PIPE_SWIZZLE_Z,	/* b */
      PIPE_SWIZZLE_1	/* a */
   },
#endif
      .colorspace = UTIL_FORMAT_COLORSPACE_RGB,
      .srgb_equivalent = PIPE_FORMAT_NONE,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_R8G8B8X8_SRGB] = {
      .format = PIPE_FORMAT_R8G8B8X8_SRGB,
      .name = "PIPE_FORMAT_R8G8B8X8_SRGB",
      .short_name = "r8g8b8x8_srgb",
      .block = {1, 1, 1, 32},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_PLAIN,
      .nr_channels = 4,	/* nr_channels */
      .is_array = true,	/* is_array */
      .is_bitmask = true,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = true,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
#if UTIL_ARCH_BIG_ENDIAN
   {
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 8, 24},	/* x = r */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 8, 16},	/* y = g */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 8, 8},	/* z = b */
      {UTIL_FORMAT_TYPE_VOID, false, false, 8, 0}	/* w = x */
   },
#else
   {
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 8, 0},	/* x = r */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 8, 8},	/* y = g */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 8, 16},	/* z = b */
      {UTIL_FORMAT_TYPE_VOID, false, false, 8, 24}	/* w = x */
   },
#endif
#if UTIL_ARCH_BIG_ENDIAN
   {
      PIPE_SWIZZLE_X,	/* sr */
      PIPE_SWIZZLE_Y,	/* sg */
      PIPE_SWIZZLE_Z,	/* sb */
      PIPE_SWIZZLE_1	/* a */
   },
#else
   {
      PIPE_SWIZZLE_X,	/* sr */
      PIPE_SWIZZLE_Y,	/* sg */
      PIPE_SWIZZLE_Z,	/* sb */
      PIPE_SWIZZLE_1	/* a */
   },
#endif
      .colorspace = UTIL_FORMAT_COLORSPACE_SRGB,
      .linear_equivalent = PIPE_FORMAT_R8G8B8X8_UNORM,	/* linear_equivalent */
   },

   [PIPE_FORMAT_R8G8B8X8_UINT] = {
      .format = PIPE_FORMAT_R8G8B8X8_UINT,
      .name = "PIPE_FORMAT_R8G8B8X8_UINT",
      .short_name = "r8g8b8x8_uint",
      .block = {1, 1, 1, 32},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_PLAIN,
      .nr_channels = 4,	/* nr_channels */
      .is_array = true,	/* is_array */
      .is_bitmask = true,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = false,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
#if UTIL_ARCH_BIG_ENDIAN
   {
      {UTIL_FORMAT_TYPE_UNSIGNED, false, true, 8, 24},	/* x = r */
      {UTIL_FORMAT_TYPE_UNSIGNED, false, true, 8, 16},	/* y = g */
      {UTIL_FORMAT_TYPE_UNSIGNED, false, true, 8, 8},	/* z = b */
      {UTIL_FORMAT_TYPE_VOID, false, false, 8, 0}	/* w = x */
   },
#else
   {
      {UTIL_FORMAT_TYPE_UNSIGNED, false, true, 8, 0},	/* x = r */
      {UTIL_FORMAT_TYPE_UNSIGNED, false, true, 8, 8},	/* y = g */
      {UTIL_FORMAT_TYPE_UNSIGNED, false, true, 8, 16},	/* z = b */
      {UTIL_FORMAT_TYPE_VOID, false, false, 8, 24}	/* w = x */
   },
#endif
#if UTIL_ARCH_BIG_ENDIAN
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_Y,	/* g */
      PIPE_SWIZZLE_Z,	/* b */
      PIPE_SWIZZLE_1	/* a */
   },
#else
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_Y,	/* g */
      PIPE_SWIZZLE_Z,	/* b */
      PIPE_SWIZZLE_1	/* a */
   },
#endif
      .colorspace = UTIL_FORMAT_COLORSPACE_RGB,
      .srgb_equivalent = PIPE_FORMAT_NONE,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_R8G8B8X8_SINT] = {
      .format = PIPE_FORMAT_R8G8B8X8_SINT,
      .name = "PIPE_FORMAT_R8G8B8X8_SINT",
      .short_name = "r8g8b8x8_sint",
      .block = {1, 1, 1, 32},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_PLAIN,
      .nr_channels = 4,	/* nr_channels */
      .is_array = true,	/* is_array */
      .is_bitmask = true,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = false,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
#if UTIL_ARCH_BIG_ENDIAN
   {
      {UTIL_FORMAT_TYPE_SIGNED, false, true, 8, 24},	/* x = r */
      {UTIL_FORMAT_TYPE_SIGNED, false, true, 8, 16},	/* y = g */
      {UTIL_FORMAT_TYPE_SIGNED, false, true, 8, 8},	/* z = b */
      {UTIL_FORMAT_TYPE_VOID, false, false, 8, 0}	/* w = x */
   },
#else
   {
      {UTIL_FORMAT_TYPE_SIGNED, false, true, 8, 0},	/* x = r */
      {UTIL_FORMAT_TYPE_SIGNED, false, true, 8, 8},	/* y = g */
      {UTIL_FORMAT_TYPE_SIGNED, false, true, 8, 16},	/* z = b */
      {UTIL_FORMAT_TYPE_VOID, false, false, 8, 24}	/* w = x */
   },
#endif
#if UTIL_ARCH_BIG_ENDIAN
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_Y,	/* g */
      PIPE_SWIZZLE_Z,	/* b */
      PIPE_SWIZZLE_1	/* a */
   },
#else
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_Y,	/* g */
      PIPE_SWIZZLE_Z,	/* b */
      PIPE_SWIZZLE_1	/* a */
   },
#endif
      .colorspace = UTIL_FORMAT_COLORSPACE_RGB,
      .srgb_equivalent = PIPE_FORMAT_NONE,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_B10G10R10X2_UNORM] = {
      .format = PIPE_FORMAT_B10G10R10X2_UNORM,
      .name = "PIPE_FORMAT_B10G10R10X2_UNORM",
      .short_name = "b10g10r10x2_unorm",
      .block = {1, 1, 1, 32},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_PLAIN,
      .nr_channels = 4,	/* nr_channels */
      .is_array = false,	/* is_array */
      .is_bitmask = true,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = true,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
#if UTIL_ARCH_BIG_ENDIAN
   {
      {UTIL_FORMAT_TYPE_VOID, false, false, 2, 30},	/* x = x */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 10, 20},	/* y = r */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 10, 10},	/* z = g */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 10, 0}	/* w = b */
   },
#else
   {
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 10, 0},	/* x = b */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 10, 10},	/* y = g */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 10, 20},	/* z = r */
      {UTIL_FORMAT_TYPE_VOID, false, false, 2, 30}	/* w = x */
   },
#endif
#if UTIL_ARCH_BIG_ENDIAN
   {
      PIPE_SWIZZLE_Y,	/* r */
      PIPE_SWIZZLE_Z,	/* g */
      PIPE_SWIZZLE_W,	/* b */
      PIPE_SWIZZLE_1	/* a */
   },
#else
   {
      PIPE_SWIZZLE_Z,	/* r */
      PIPE_SWIZZLE_Y,	/* g */
      PIPE_SWIZZLE_X,	/* b */
      PIPE_SWIZZLE_1	/* a */
   },
#endif
      .colorspace = UTIL_FORMAT_COLORSPACE_RGB,
      .srgb_equivalent = PIPE_FORMAT_NONE,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_B10G10R10X2_SNORM] = {
      .format = PIPE_FORMAT_B10G10R10X2_SNORM,
      .name = "PIPE_FORMAT_B10G10R10X2_SNORM",
      .short_name = "b10g10r10x2_snorm",
      .block = {1, 1, 1, 32},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_PLAIN,
      .nr_channels = 4,	/* nr_channels */
      .is_array = false,	/* is_array */
      .is_bitmask = true,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = false,	/* is_unorm */
      .is_snorm = true,	/* is_snorm */
#if UTIL_ARCH_BIG_ENDIAN
   {
      {UTIL_FORMAT_TYPE_VOID, false, false, 2, 30},	/* x = x */
      {UTIL_FORMAT_TYPE_SIGNED, true, false, 10, 20},	/* y = r */
      {UTIL_FORMAT_TYPE_SIGNED, true, false, 10, 10},	/* z = g */
      {UTIL_FORMAT_TYPE_SIGNED, true, false, 10, 0}	/* w = b */
   },
#else
   {
      {UTIL_FORMAT_TYPE_SIGNED, true, false, 10, 0},	/* x = b */
      {UTIL_FORMAT_TYPE_SIGNED, true, false, 10, 10},	/* y = g */
      {UTIL_FORMAT_TYPE_SIGNED, true, false, 10, 20},	/* z = r */
      {UTIL_FORMAT_TYPE_VOID, false, false, 2, 30}	/* w = x */
   },
#endif
#if UTIL_ARCH_BIG_ENDIAN
   {
      PIPE_SWIZZLE_Y,	/* r */
      PIPE_SWIZZLE_Z,	/* g */
      PIPE_SWIZZLE_W,	/* b */
      PIPE_SWIZZLE_1	/* a */
   },
#else
   {
      PIPE_SWIZZLE_Z,	/* r */
      PIPE_SWIZZLE_Y,	/* g */
      PIPE_SWIZZLE_X,	/* b */
      PIPE_SWIZZLE_1	/* a */
   },
#endif
      .colorspace = UTIL_FORMAT_COLORSPACE_RGB,
      .srgb_equivalent = PIPE_FORMAT_NONE,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_B10G10R10X2_SINT] = {
      .format = PIPE_FORMAT_B10G10R10X2_SINT,
      .name = "PIPE_FORMAT_B10G10R10X2_SINT",
      .short_name = "b10g10r10x2_sint",
      .block = {1, 1, 1, 32},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_PLAIN,
      .nr_channels = 4,	/* nr_channels */
      .is_array = false,	/* is_array */
      .is_bitmask = true,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = false,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
#if UTIL_ARCH_BIG_ENDIAN
   {
      {UTIL_FORMAT_TYPE_VOID, false, false, 2, 30},	/* x = x */
      {UTIL_FORMAT_TYPE_SIGNED, false, true, 10, 20},	/* y = r */
      {UTIL_FORMAT_TYPE_SIGNED, false, true, 10, 10},	/* z = g */
      {UTIL_FORMAT_TYPE_SIGNED, false, true, 10, 0}	/* w = b */
   },
#else
   {
      {UTIL_FORMAT_TYPE_SIGNED, false, true, 10, 0},	/* x = b */
      {UTIL_FORMAT_TYPE_SIGNED, false, true, 10, 10},	/* y = g */
      {UTIL_FORMAT_TYPE_SIGNED, false, true, 10, 20},	/* z = r */
      {UTIL_FORMAT_TYPE_VOID, false, false, 2, 30}	/* w = x */
   },
#endif
#if UTIL_ARCH_BIG_ENDIAN
   {
      PIPE_SWIZZLE_Y,	/* r */
      PIPE_SWIZZLE_Z,	/* g */
      PIPE_SWIZZLE_W,	/* b */
      PIPE_SWIZZLE_1	/* a */
   },
#else
   {
      PIPE_SWIZZLE_Z,	/* r */
      PIPE_SWIZZLE_Y,	/* g */
      PIPE_SWIZZLE_X,	/* b */
      PIPE_SWIZZLE_1	/* a */
   },
#endif
      .colorspace = UTIL_FORMAT_COLORSPACE_RGB,
      .srgb_equivalent = PIPE_FORMAT_NONE,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_R16G16B16X16_UNORM] = {
      .format = PIPE_FORMAT_R16G16B16X16_UNORM,
      .name = "PIPE_FORMAT_R16G16B16X16_UNORM",
      .short_name = "r16g16b16x16_unorm",
      .block = {1, 1, 1, 64},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_PLAIN,
      .nr_channels = 4,	/* nr_channels */
      .is_array = true,	/* is_array */
      .is_bitmask = false,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = true,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
#if UTIL_ARCH_BIG_ENDIAN
   {
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 16, 48},	/* x = r */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 16, 32},	/* y = g */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 16, 16},	/* z = b */
      {UTIL_FORMAT_TYPE_VOID, false, false, 16, 0}	/* w = x */
   },
#else
   {
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 16, 0},	/* x = r */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 16, 16},	/* y = g */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 16, 32},	/* z = b */
      {UTIL_FORMAT_TYPE_VOID, false, false, 16, 48}	/* w = x */
   },
#endif
#if UTIL_ARCH_BIG_ENDIAN
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_Y,	/* g */
      PIPE_SWIZZLE_Z,	/* b */
      PIPE_SWIZZLE_1	/* a */
   },
#else
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_Y,	/* g */
      PIPE_SWIZZLE_Z,	/* b */
      PIPE_SWIZZLE_1	/* a */
   },
#endif
      .colorspace = UTIL_FORMAT_COLORSPACE_RGB,
      .srgb_equivalent = PIPE_FORMAT_NONE,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_R16G16B16X16_SNORM] = {
      .format = PIPE_FORMAT_R16G16B16X16_SNORM,
      .name = "PIPE_FORMAT_R16G16B16X16_SNORM",
      .short_name = "r16g16b16x16_snorm",
      .block = {1, 1, 1, 64},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_PLAIN,
      .nr_channels = 4,	/* nr_channels */
      .is_array = true,	/* is_array */
      .is_bitmask = false,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = false,	/* is_unorm */
      .is_snorm = true,	/* is_snorm */
#if UTIL_ARCH_BIG_ENDIAN
   {
      {UTIL_FORMAT_TYPE_SIGNED, true, false, 16, 48},	/* x = r */
      {UTIL_FORMAT_TYPE_SIGNED, true, false, 16, 32},	/* y = g */
      {UTIL_FORMAT_TYPE_SIGNED, true, false, 16, 16},	/* z = b */
      {UTIL_FORMAT_TYPE_VOID, false, false, 16, 0}	/* w = x */
   },
#else
   {
      {UTIL_FORMAT_TYPE_SIGNED, true, false, 16, 0},	/* x = r */
      {UTIL_FORMAT_TYPE_SIGNED, true, false, 16, 16},	/* y = g */
      {UTIL_FORMAT_TYPE_SIGNED, true, false, 16, 32},	/* z = b */
      {UTIL_FORMAT_TYPE_VOID, false, false, 16, 48}	/* w = x */
   },
#endif
#if UTIL_ARCH_BIG_ENDIAN
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_Y,	/* g */
      PIPE_SWIZZLE_Z,	/* b */
      PIPE_SWIZZLE_1	/* a */
   },
#else
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_Y,	/* g */
      PIPE_SWIZZLE_Z,	/* b */
      PIPE_SWIZZLE_1	/* a */
   },
#endif
      .colorspace = UTIL_FORMAT_COLORSPACE_RGB,
      .srgb_equivalent = PIPE_FORMAT_NONE,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_R16G16B16X16_FLOAT] = {
      .format = PIPE_FORMAT_R16G16B16X16_FLOAT,
      .name = "PIPE_FORMAT_R16G16B16X16_FLOAT",
      .short_name = "r16g16b16x16_float",
      .block = {1, 1, 1, 64},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_PLAIN,
      .nr_channels = 4,	/* nr_channels */
      .is_array = true,	/* is_array */
      .is_bitmask = false,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = false,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
#if UTIL_ARCH_BIG_ENDIAN
   {
      {UTIL_FORMAT_TYPE_FLOAT, false, false, 16, 48},	/* x = r */
      {UTIL_FORMAT_TYPE_FLOAT, false, false, 16, 32},	/* y = g */
      {UTIL_FORMAT_TYPE_FLOAT, false, false, 16, 16},	/* z = b */
      {UTIL_FORMAT_TYPE_VOID, false, false, 16, 0}	/* w = x */
   },
#else
   {
      {UTIL_FORMAT_TYPE_FLOAT, false, false, 16, 0},	/* x = r */
      {UTIL_FORMAT_TYPE_FLOAT, false, false, 16, 16},	/* y = g */
      {UTIL_FORMAT_TYPE_FLOAT, false, false, 16, 32},	/* z = b */
      {UTIL_FORMAT_TYPE_VOID, false, false, 16, 48}	/* w = x */
   },
#endif
#if UTIL_ARCH_BIG_ENDIAN
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_Y,	/* g */
      PIPE_SWIZZLE_Z,	/* b */
      PIPE_SWIZZLE_1	/* a */
   },
#else
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_Y,	/* g */
      PIPE_SWIZZLE_Z,	/* b */
      PIPE_SWIZZLE_1	/* a */
   },
#endif
      .colorspace = UTIL_FORMAT_COLORSPACE_RGB,
      .srgb_equivalent = PIPE_FORMAT_NONE,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_R16G16B16X16_UINT] = {
      .format = PIPE_FORMAT_R16G16B16X16_UINT,
      .name = "PIPE_FORMAT_R16G16B16X16_UINT",
      .short_name = "r16g16b16x16_uint",
      .block = {1, 1, 1, 64},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_PLAIN,
      .nr_channels = 4,	/* nr_channels */
      .is_array = true,	/* is_array */
      .is_bitmask = false,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = false,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
#if UTIL_ARCH_BIG_ENDIAN
   {
      {UTIL_FORMAT_TYPE_UNSIGNED, false, true, 16, 48},	/* x = r */
      {UTIL_FORMAT_TYPE_UNSIGNED, false, true, 16, 32},	/* y = g */
      {UTIL_FORMAT_TYPE_UNSIGNED, false, true, 16, 16},	/* z = b */
      {UTIL_FORMAT_TYPE_VOID, false, false, 16, 0}	/* w = x */
   },
#else
   {
      {UTIL_FORMAT_TYPE_UNSIGNED, false, true, 16, 0},	/* x = r */
      {UTIL_FORMAT_TYPE_UNSIGNED, false, true, 16, 16},	/* y = g */
      {UTIL_FORMAT_TYPE_UNSIGNED, false, true, 16, 32},	/* z = b */
      {UTIL_FORMAT_TYPE_VOID, false, false, 16, 48}	/* w = x */
   },
#endif
#if UTIL_ARCH_BIG_ENDIAN
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_Y,	/* g */
      PIPE_SWIZZLE_Z,	/* b */
      PIPE_SWIZZLE_1	/* a */
   },
#else
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_Y,	/* g */
      PIPE_SWIZZLE_Z,	/* b */
      PIPE_SWIZZLE_1	/* a */
   },
#endif
      .colorspace = UTIL_FORMAT_COLORSPACE_RGB,
      .srgb_equivalent = PIPE_FORMAT_NONE,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_R16G16B16X16_SINT] = {
      .format = PIPE_FORMAT_R16G16B16X16_SINT,
      .name = "PIPE_FORMAT_R16G16B16X16_SINT",
      .short_name = "r16g16b16x16_sint",
      .block = {1, 1, 1, 64},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_PLAIN,
      .nr_channels = 4,	/* nr_channels */
      .is_array = true,	/* is_array */
      .is_bitmask = false,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = false,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
#if UTIL_ARCH_BIG_ENDIAN
   {
      {UTIL_FORMAT_TYPE_SIGNED, false, true, 16, 48},	/* x = r */
      {UTIL_FORMAT_TYPE_SIGNED, false, true, 16, 32},	/* y = g */
      {UTIL_FORMAT_TYPE_SIGNED, false, true, 16, 16},	/* z = b */
      {UTIL_FORMAT_TYPE_VOID, false, false, 16, 0}	/* w = x */
   },
#else
   {
      {UTIL_FORMAT_TYPE_SIGNED, false, true, 16, 0},	/* x = r */
      {UTIL_FORMAT_TYPE_SIGNED, false, true, 16, 16},	/* y = g */
      {UTIL_FORMAT_TYPE_SIGNED, false, true, 16, 32},	/* z = b */
      {UTIL_FORMAT_TYPE_VOID, false, false, 16, 48}	/* w = x */
   },
#endif
#if UTIL_ARCH_BIG_ENDIAN
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_Y,	/* g */
      PIPE_SWIZZLE_Z,	/* b */
      PIPE_SWIZZLE_1	/* a */
   },
#else
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_Y,	/* g */
      PIPE_SWIZZLE_Z,	/* b */
      PIPE_SWIZZLE_1	/* a */
   },
#endif
      .colorspace = UTIL_FORMAT_COLORSPACE_RGB,
      .srgb_equivalent = PIPE_FORMAT_NONE,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_R32G32B32X32_FLOAT] = {
      .format = PIPE_FORMAT_R32G32B32X32_FLOAT,
      .name = "PIPE_FORMAT_R32G32B32X32_FLOAT",
      .short_name = "r32g32b32x32_float",
      .block = {1, 1, 1, 128},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_PLAIN,
      .nr_channels = 4,	/* nr_channels */
      .is_array = true,	/* is_array */
      .is_bitmask = false,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = false,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
#if UTIL_ARCH_BIG_ENDIAN
   {
      {UTIL_FORMAT_TYPE_FLOAT, false, false, 32, 96},	/* x = r */
      {UTIL_FORMAT_TYPE_FLOAT, false, false, 32, 64},	/* y = g */
      {UTIL_FORMAT_TYPE_FLOAT, false, false, 32, 32},	/* z = b */
      {UTIL_FORMAT_TYPE_VOID, false, false, 32, 0}	/* w = x */
   },
#else
   {
      {UTIL_FORMAT_TYPE_FLOAT, false, false, 32, 0},	/* x = r */
      {UTIL_FORMAT_TYPE_FLOAT, false, false, 32, 32},	/* y = g */
      {UTIL_FORMAT_TYPE_FLOAT, false, false, 32, 64},	/* z = b */
      {UTIL_FORMAT_TYPE_VOID, false, false, 32, 96}	/* w = x */
   },
#endif
#if UTIL_ARCH_BIG_ENDIAN
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_Y,	/* g */
      PIPE_SWIZZLE_Z,	/* b */
      PIPE_SWIZZLE_1	/* a */
   },
#else
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_Y,	/* g */
      PIPE_SWIZZLE_Z,	/* b */
      PIPE_SWIZZLE_1	/* a */
   },
#endif
      .colorspace = UTIL_FORMAT_COLORSPACE_RGB,
      .srgb_equivalent = PIPE_FORMAT_NONE,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_R32G32B32X32_UINT] = {
      .format = PIPE_FORMAT_R32G32B32X32_UINT,
      .name = "PIPE_FORMAT_R32G32B32X32_UINT",
      .short_name = "r32g32b32x32_uint",
      .block = {1, 1, 1, 128},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_PLAIN,
      .nr_channels = 4,	/* nr_channels */
      .is_array = true,	/* is_array */
      .is_bitmask = false,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = false,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
#if UTIL_ARCH_BIG_ENDIAN
   {
      {UTIL_FORMAT_TYPE_UNSIGNED, false, true, 32, 96},	/* x = r */
      {UTIL_FORMAT_TYPE_UNSIGNED, false, true, 32, 64},	/* y = g */
      {UTIL_FORMAT_TYPE_UNSIGNED, false, true, 32, 32},	/* z = b */
      {UTIL_FORMAT_TYPE_VOID, false, false, 32, 0}	/* w = x */
   },
#else
   {
      {UTIL_FORMAT_TYPE_UNSIGNED, false, true, 32, 0},	/* x = r */
      {UTIL_FORMAT_TYPE_UNSIGNED, false, true, 32, 32},	/* y = g */
      {UTIL_FORMAT_TYPE_UNSIGNED, false, true, 32, 64},	/* z = b */
      {UTIL_FORMAT_TYPE_VOID, false, false, 32, 96}	/* w = x */
   },
#endif
#if UTIL_ARCH_BIG_ENDIAN
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_Y,	/* g */
      PIPE_SWIZZLE_Z,	/* b */
      PIPE_SWIZZLE_1	/* a */
   },
#else
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_Y,	/* g */
      PIPE_SWIZZLE_Z,	/* b */
      PIPE_SWIZZLE_1	/* a */
   },
#endif
      .colorspace = UTIL_FORMAT_COLORSPACE_RGB,
      .srgb_equivalent = PIPE_FORMAT_NONE,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_R32G32B32X32_SINT] = {
      .format = PIPE_FORMAT_R32G32B32X32_SINT,
      .name = "PIPE_FORMAT_R32G32B32X32_SINT",
      .short_name = "r32g32b32x32_sint",
      .block = {1, 1, 1, 128},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_PLAIN,
      .nr_channels = 4,	/* nr_channels */
      .is_array = true,	/* is_array */
      .is_bitmask = false,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = false,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
#if UTIL_ARCH_BIG_ENDIAN
   {
      {UTIL_FORMAT_TYPE_SIGNED, false, true, 32, 96},	/* x = r */
      {UTIL_FORMAT_TYPE_SIGNED, false, true, 32, 64},	/* y = g */
      {UTIL_FORMAT_TYPE_SIGNED, false, true, 32, 32},	/* z = b */
      {UTIL_FORMAT_TYPE_VOID, false, false, 32, 0}	/* w = x */
   },
#else
   {
      {UTIL_FORMAT_TYPE_SIGNED, false, true, 32, 0},	/* x = r */
      {UTIL_FORMAT_TYPE_SIGNED, false, true, 32, 32},	/* y = g */
      {UTIL_FORMAT_TYPE_SIGNED, false, true, 32, 64},	/* z = b */
      {UTIL_FORMAT_TYPE_VOID, false, false, 32, 96}	/* w = x */
   },
#endif
#if UTIL_ARCH_BIG_ENDIAN
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_Y,	/* g */
      PIPE_SWIZZLE_Z,	/* b */
      PIPE_SWIZZLE_1	/* a */
   },
#else
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_Y,	/* g */
      PIPE_SWIZZLE_Z,	/* b */
      PIPE_SWIZZLE_1	/* a */
   },
#endif
      .colorspace = UTIL_FORMAT_COLORSPACE_RGB,
      .srgb_equivalent = PIPE_FORMAT_NONE,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_R8A8_SNORM] = {
      .format = PIPE_FORMAT_R8A8_SNORM,
      .name = "PIPE_FORMAT_R8A8_SNORM",
      .short_name = "r8a8_snorm",
      .block = {1, 1, 1, 16},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_PLAIN,
      .nr_channels = 2,	/* nr_channels */
      .is_array = true,	/* is_array */
      .is_bitmask = true,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = false,	/* is_unorm */
      .is_snorm = true,	/* is_snorm */
#if UTIL_ARCH_BIG_ENDIAN
   {
      {UTIL_FORMAT_TYPE_SIGNED, true, false, 8, 8},	/* x = r */
      {UTIL_FORMAT_TYPE_SIGNED, true, false, 8, 0},	/* y = a */
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0}
   },
#else
   {
      {UTIL_FORMAT_TYPE_SIGNED, true, false, 8, 0},	/* x = r */
      {UTIL_FORMAT_TYPE_SIGNED, true, false, 8, 8},	/* y = a */
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0}
   },
#endif
#if UTIL_ARCH_BIG_ENDIAN
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_0,	/* g */
      PIPE_SWIZZLE_0,	/* b */
      PIPE_SWIZZLE_Y	/* a */
   },
#else
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_0,	/* g */
      PIPE_SWIZZLE_0,	/* b */
      PIPE_SWIZZLE_Y	/* a */
   },
#endif
      .colorspace = UTIL_FORMAT_COLORSPACE_RGB,
      .srgb_equivalent = PIPE_FORMAT_NONE,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_R16A16_UNORM] = {
      .format = PIPE_FORMAT_R16A16_UNORM,
      .name = "PIPE_FORMAT_R16A16_UNORM",
      .short_name = "r16a16_unorm",
      .block = {1, 1, 1, 32},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_PLAIN,
      .nr_channels = 2,	/* nr_channels */
      .is_array = true,	/* is_array */
      .is_bitmask = true,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = true,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
#if UTIL_ARCH_BIG_ENDIAN
   {
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 16, 16},	/* x = r */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 16, 0},	/* y = a */
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0}
   },
#else
   {
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 16, 0},	/* x = r */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 16, 16},	/* y = a */
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0}
   },
#endif
#if UTIL_ARCH_BIG_ENDIAN
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_0,	/* g */
      PIPE_SWIZZLE_0,	/* b */
      PIPE_SWIZZLE_Y	/* a */
   },
#else
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_0,	/* g */
      PIPE_SWIZZLE_0,	/* b */
      PIPE_SWIZZLE_Y	/* a */
   },
#endif
      .colorspace = UTIL_FORMAT_COLORSPACE_RGB,
      .srgb_equivalent = PIPE_FORMAT_NONE,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_R16A16_SNORM] = {
      .format = PIPE_FORMAT_R16A16_SNORM,
      .name = "PIPE_FORMAT_R16A16_SNORM",
      .short_name = "r16a16_snorm",
      .block = {1, 1, 1, 32},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_PLAIN,
      .nr_channels = 2,	/* nr_channels */
      .is_array = true,	/* is_array */
      .is_bitmask = true,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = false,	/* is_unorm */
      .is_snorm = true,	/* is_snorm */
#if UTIL_ARCH_BIG_ENDIAN
   {
      {UTIL_FORMAT_TYPE_SIGNED, true, false, 16, 16},	/* x = r */
      {UTIL_FORMAT_TYPE_SIGNED, true, false, 16, 0},	/* y = a */
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0}
   },
#else
   {
      {UTIL_FORMAT_TYPE_SIGNED, true, false, 16, 0},	/* x = r */
      {UTIL_FORMAT_TYPE_SIGNED, true, false, 16, 16},	/* y = a */
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0}
   },
#endif
#if UTIL_ARCH_BIG_ENDIAN
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_0,	/* g */
      PIPE_SWIZZLE_0,	/* b */
      PIPE_SWIZZLE_Y	/* a */
   },
#else
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_0,	/* g */
      PIPE_SWIZZLE_0,	/* b */
      PIPE_SWIZZLE_Y	/* a */
   },
#endif
      .colorspace = UTIL_FORMAT_COLORSPACE_RGB,
      .srgb_equivalent = PIPE_FORMAT_NONE,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_R16A16_FLOAT] = {
      .format = PIPE_FORMAT_R16A16_FLOAT,
      .name = "PIPE_FORMAT_R16A16_FLOAT",
      .short_name = "r16a16_float",
      .block = {1, 1, 1, 32},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_PLAIN,
      .nr_channels = 2,	/* nr_channels */
      .is_array = true,	/* is_array */
      .is_bitmask = false,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = false,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
#if UTIL_ARCH_BIG_ENDIAN
   {
      {UTIL_FORMAT_TYPE_FLOAT, false, false, 16, 16},	/* x = r */
      {UTIL_FORMAT_TYPE_FLOAT, false, false, 16, 0},	/* y = a */
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0}
   },
#else
   {
      {UTIL_FORMAT_TYPE_FLOAT, false, false, 16, 0},	/* x = r */
      {UTIL_FORMAT_TYPE_FLOAT, false, false, 16, 16},	/* y = a */
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0}
   },
#endif
#if UTIL_ARCH_BIG_ENDIAN
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_0,	/* g */
      PIPE_SWIZZLE_0,	/* b */
      PIPE_SWIZZLE_Y	/* a */
   },
#else
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_0,	/* g */
      PIPE_SWIZZLE_0,	/* b */
      PIPE_SWIZZLE_Y	/* a */
   },
#endif
      .colorspace = UTIL_FORMAT_COLORSPACE_RGB,
      .srgb_equivalent = PIPE_FORMAT_NONE,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_R32A32_FLOAT] = {
      .format = PIPE_FORMAT_R32A32_FLOAT,
      .name = "PIPE_FORMAT_R32A32_FLOAT",
      .short_name = "r32a32_float",
      .block = {1, 1, 1, 64},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_PLAIN,
      .nr_channels = 2,	/* nr_channels */
      .is_array = true,	/* is_array */
      .is_bitmask = false,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = false,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
#if UTIL_ARCH_BIG_ENDIAN
   {
      {UTIL_FORMAT_TYPE_FLOAT, false, false, 32, 32},	/* x = r */
      {UTIL_FORMAT_TYPE_FLOAT, false, false, 32, 0},	/* y = a */
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0}
   },
#else
   {
      {UTIL_FORMAT_TYPE_FLOAT, false, false, 32, 0},	/* x = r */
      {UTIL_FORMAT_TYPE_FLOAT, false, false, 32, 32},	/* y = a */
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0}
   },
#endif
#if UTIL_ARCH_BIG_ENDIAN
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_0,	/* g */
      PIPE_SWIZZLE_0,	/* b */
      PIPE_SWIZZLE_Y	/* a */
   },
#else
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_0,	/* g */
      PIPE_SWIZZLE_0,	/* b */
      PIPE_SWIZZLE_Y	/* a */
   },
#endif
      .colorspace = UTIL_FORMAT_COLORSPACE_RGB,
      .srgb_equivalent = PIPE_FORMAT_NONE,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_R8A8_UINT] = {
      .format = PIPE_FORMAT_R8A8_UINT,
      .name = "PIPE_FORMAT_R8A8_UINT",
      .short_name = "r8a8_uint",
      .block = {1, 1, 1, 16},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_PLAIN,
      .nr_channels = 2,	/* nr_channels */
      .is_array = true,	/* is_array */
      .is_bitmask = true,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = false,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
#if UTIL_ARCH_BIG_ENDIAN
   {
      {UTIL_FORMAT_TYPE_UNSIGNED, false, true, 8, 8},	/* x = r */
      {UTIL_FORMAT_TYPE_UNSIGNED, false, true, 8, 0},	/* y = a */
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0}
   },
#else
   {
      {UTIL_FORMAT_TYPE_UNSIGNED, false, true, 8, 0},	/* x = r */
      {UTIL_FORMAT_TYPE_UNSIGNED, false, true, 8, 8},	/* y = a */
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0}
   },
#endif
#if UTIL_ARCH_BIG_ENDIAN
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_0,	/* g */
      PIPE_SWIZZLE_0,	/* b */
      PIPE_SWIZZLE_Y	/* a */
   },
#else
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_0,	/* g */
      PIPE_SWIZZLE_0,	/* b */
      PIPE_SWIZZLE_Y	/* a */
   },
#endif
      .colorspace = UTIL_FORMAT_COLORSPACE_RGB,
      .srgb_equivalent = PIPE_FORMAT_NONE,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_R8A8_SINT] = {
      .format = PIPE_FORMAT_R8A8_SINT,
      .name = "PIPE_FORMAT_R8A8_SINT",
      .short_name = "r8a8_sint",
      .block = {1, 1, 1, 16},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_PLAIN,
      .nr_channels = 2,	/* nr_channels */
      .is_array = true,	/* is_array */
      .is_bitmask = true,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = false,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
#if UTIL_ARCH_BIG_ENDIAN
   {
      {UTIL_FORMAT_TYPE_SIGNED, false, true, 8, 8},	/* x = r */
      {UTIL_FORMAT_TYPE_SIGNED, false, true, 8, 0},	/* y = a */
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0}
   },
#else
   {
      {UTIL_FORMAT_TYPE_SIGNED, false, true, 8, 0},	/* x = r */
      {UTIL_FORMAT_TYPE_SIGNED, false, true, 8, 8},	/* y = a */
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0}
   },
#endif
#if UTIL_ARCH_BIG_ENDIAN
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_0,	/* g */
      PIPE_SWIZZLE_0,	/* b */
      PIPE_SWIZZLE_Y	/* a */
   },
#else
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_0,	/* g */
      PIPE_SWIZZLE_0,	/* b */
      PIPE_SWIZZLE_Y	/* a */
   },
#endif
      .colorspace = UTIL_FORMAT_COLORSPACE_RGB,
      .srgb_equivalent = PIPE_FORMAT_NONE,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_R16A16_UINT] = {
      .format = PIPE_FORMAT_R16A16_UINT,
      .name = "PIPE_FORMAT_R16A16_UINT",
      .short_name = "r16a16_uint",
      .block = {1, 1, 1, 32},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_PLAIN,
      .nr_channels = 2,	/* nr_channels */
      .is_array = true,	/* is_array */
      .is_bitmask = true,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = false,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
#if UTIL_ARCH_BIG_ENDIAN
   {
      {UTIL_FORMAT_TYPE_UNSIGNED, false, true, 16, 16},	/* x = r */
      {UTIL_FORMAT_TYPE_UNSIGNED, false, true, 16, 0},	/* y = a */
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0}
   },
#else
   {
      {UTIL_FORMAT_TYPE_UNSIGNED, false, true, 16, 0},	/* x = r */
      {UTIL_FORMAT_TYPE_UNSIGNED, false, true, 16, 16},	/* y = a */
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0}
   },
#endif
#if UTIL_ARCH_BIG_ENDIAN
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_0,	/* g */
      PIPE_SWIZZLE_0,	/* b */
      PIPE_SWIZZLE_Y	/* a */
   },
#else
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_0,	/* g */
      PIPE_SWIZZLE_0,	/* b */
      PIPE_SWIZZLE_Y	/* a */
   },
#endif
      .colorspace = UTIL_FORMAT_COLORSPACE_RGB,
      .srgb_equivalent = PIPE_FORMAT_NONE,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_R16A16_SINT] = {
      .format = PIPE_FORMAT_R16A16_SINT,
      .name = "PIPE_FORMAT_R16A16_SINT",
      .short_name = "r16a16_sint",
      .block = {1, 1, 1, 32},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_PLAIN,
      .nr_channels = 2,	/* nr_channels */
      .is_array = true,	/* is_array */
      .is_bitmask = true,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = false,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
#if UTIL_ARCH_BIG_ENDIAN
   {
      {UTIL_FORMAT_TYPE_SIGNED, false, true, 16, 16},	/* x = r */
      {UTIL_FORMAT_TYPE_SIGNED, false, true, 16, 0},	/* y = a */
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0}
   },
#else
   {
      {UTIL_FORMAT_TYPE_SIGNED, false, true, 16, 0},	/* x = r */
      {UTIL_FORMAT_TYPE_SIGNED, false, true, 16, 16},	/* y = a */
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0}
   },
#endif
#if UTIL_ARCH_BIG_ENDIAN
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_0,	/* g */
      PIPE_SWIZZLE_0,	/* b */
      PIPE_SWIZZLE_Y	/* a */
   },
#else
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_0,	/* g */
      PIPE_SWIZZLE_0,	/* b */
      PIPE_SWIZZLE_Y	/* a */
   },
#endif
      .colorspace = UTIL_FORMAT_COLORSPACE_RGB,
      .srgb_equivalent = PIPE_FORMAT_NONE,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_R32A32_UINT] = {
      .format = PIPE_FORMAT_R32A32_UINT,
      .name = "PIPE_FORMAT_R32A32_UINT",
      .short_name = "r32a32_uint",
      .block = {1, 1, 1, 64},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_PLAIN,
      .nr_channels = 2,	/* nr_channels */
      .is_array = true,	/* is_array */
      .is_bitmask = false,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = false,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
#if UTIL_ARCH_BIG_ENDIAN
   {
      {UTIL_FORMAT_TYPE_UNSIGNED, false, true, 32, 32},	/* x = r */
      {UTIL_FORMAT_TYPE_UNSIGNED, false, true, 32, 0},	/* y = a */
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0}
   },
#else
   {
      {UTIL_FORMAT_TYPE_UNSIGNED, false, true, 32, 0},	/* x = r */
      {UTIL_FORMAT_TYPE_UNSIGNED, false, true, 32, 32},	/* y = a */
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0}
   },
#endif
#if UTIL_ARCH_BIG_ENDIAN
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_0,	/* g */
      PIPE_SWIZZLE_0,	/* b */
      PIPE_SWIZZLE_Y	/* a */
   },
#else
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_0,	/* g */
      PIPE_SWIZZLE_0,	/* b */
      PIPE_SWIZZLE_Y	/* a */
   },
#endif
      .colorspace = UTIL_FORMAT_COLORSPACE_RGB,
      .srgb_equivalent = PIPE_FORMAT_NONE,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_R32A32_SINT] = {
      .format = PIPE_FORMAT_R32A32_SINT,
      .name = "PIPE_FORMAT_R32A32_SINT",
      .short_name = "r32a32_sint",
      .block = {1, 1, 1, 64},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_PLAIN,
      .nr_channels = 2,	/* nr_channels */
      .is_array = true,	/* is_array */
      .is_bitmask = false,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = false,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
#if UTIL_ARCH_BIG_ENDIAN
   {
      {UTIL_FORMAT_TYPE_SIGNED, false, true, 32, 32},	/* x = r */
      {UTIL_FORMAT_TYPE_SIGNED, false, true, 32, 0},	/* y = a */
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0}
   },
#else
   {
      {UTIL_FORMAT_TYPE_SIGNED, false, true, 32, 0},	/* x = r */
      {UTIL_FORMAT_TYPE_SIGNED, false, true, 32, 32},	/* y = a */
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0}
   },
#endif
#if UTIL_ARCH_BIG_ENDIAN
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_0,	/* g */
      PIPE_SWIZZLE_0,	/* b */
      PIPE_SWIZZLE_Y	/* a */
   },
#else
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_0,	/* g */
      PIPE_SWIZZLE_0,	/* b */
      PIPE_SWIZZLE_Y	/* a */
   },
#endif
      .colorspace = UTIL_FORMAT_COLORSPACE_RGB,
      .srgb_equivalent = PIPE_FORMAT_NONE,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_R10G10B10A2_UINT] = {
      .format = PIPE_FORMAT_R10G10B10A2_UINT,
      .name = "PIPE_FORMAT_R10G10B10A2_UINT",
      .short_name = "r10g10b10a2_uint",
      .block = {1, 1, 1, 32},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_PLAIN,
      .nr_channels = 4,	/* nr_channels */
      .is_array = false,	/* is_array */
      .is_bitmask = true,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = false,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
#if UTIL_ARCH_BIG_ENDIAN
   {
      {UTIL_FORMAT_TYPE_UNSIGNED, false, true, 2, 30},	/* x = a */
      {UTIL_FORMAT_TYPE_UNSIGNED, false, true, 10, 20},	/* y = b */
      {UTIL_FORMAT_TYPE_UNSIGNED, false, true, 10, 10},	/* z = g */
      {UTIL_FORMAT_TYPE_UNSIGNED, false, true, 10, 0}	/* w = r */
   },
#else
   {
      {UTIL_FORMAT_TYPE_UNSIGNED, false, true, 10, 0},	/* x = r */
      {UTIL_FORMAT_TYPE_UNSIGNED, false, true, 10, 10},	/* y = g */
      {UTIL_FORMAT_TYPE_UNSIGNED, false, true, 10, 20},	/* z = b */
      {UTIL_FORMAT_TYPE_UNSIGNED, false, true, 2, 30}	/* w = a */
   },
#endif
#if UTIL_ARCH_BIG_ENDIAN
   {
      PIPE_SWIZZLE_W,	/* r */
      PIPE_SWIZZLE_Z,	/* g */
      PIPE_SWIZZLE_Y,	/* b */
      PIPE_SWIZZLE_X	/* a */
   },
#else
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_Y,	/* g */
      PIPE_SWIZZLE_Z,	/* b */
      PIPE_SWIZZLE_W	/* a */
   },
#endif
      .colorspace = UTIL_FORMAT_COLORSPACE_RGB,
      .srgb_equivalent = PIPE_FORMAT_NONE,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_R10G10B10A2_SINT] = {
      .format = PIPE_FORMAT_R10G10B10A2_SINT,
      .name = "PIPE_FORMAT_R10G10B10A2_SINT",
      .short_name = "r10g10b10a2_sint",
      .block = {1, 1, 1, 32},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_PLAIN,
      .nr_channels = 4,	/* nr_channels */
      .is_array = false,	/* is_array */
      .is_bitmask = true,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = false,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
#if UTIL_ARCH_BIG_ENDIAN
   {
      {UTIL_FORMAT_TYPE_SIGNED, false, true, 2, 30},	/* x = a */
      {UTIL_FORMAT_TYPE_SIGNED, false, true, 10, 20},	/* y = b */
      {UTIL_FORMAT_TYPE_SIGNED, false, true, 10, 10},	/* z = g */
      {UTIL_FORMAT_TYPE_SIGNED, false, true, 10, 0}	/* w = r */
   },
#else
   {
      {UTIL_FORMAT_TYPE_SIGNED, false, true, 10, 0},	/* x = r */
      {UTIL_FORMAT_TYPE_SIGNED, false, true, 10, 10},	/* y = g */
      {UTIL_FORMAT_TYPE_SIGNED, false, true, 10, 20},	/* z = b */
      {UTIL_FORMAT_TYPE_SIGNED, false, true, 2, 30}	/* w = a */
   },
#endif
#if UTIL_ARCH_BIG_ENDIAN
   {
      PIPE_SWIZZLE_W,	/* r */
      PIPE_SWIZZLE_Z,	/* g */
      PIPE_SWIZZLE_Y,	/* b */
      PIPE_SWIZZLE_X	/* a */
   },
#else
   {
      PIPE_SWIZZLE_X,	/* r */
      PIPE_SWIZZLE_Y,	/* g */
      PIPE_SWIZZLE_Z,	/* b */
      PIPE_SWIZZLE_W	/* a */
   },
#endif
      .colorspace = UTIL_FORMAT_COLORSPACE_RGB,
      .srgb_equivalent = PIPE_FORMAT_NONE,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_B5G6R5_SRGB] = {
      .format = PIPE_FORMAT_B5G6R5_SRGB,
      .name = "PIPE_FORMAT_B5G6R5_SRGB",
      .short_name = "b5g6r5_srgb",
      .block = {1, 1, 1, 16},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_PLAIN,
      .nr_channels = 3,	/* nr_channels */
      .is_array = false,	/* is_array */
      .is_bitmask = true,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = true,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
#if UTIL_ARCH_BIG_ENDIAN
   {
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 5, 11},	/* x = r */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 6, 5},	/* y = g */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 5, 0},	/* z = b */
      {0, 0, 0, 0, 0}
   },
#else
   {
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 5, 0},	/* x = b */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 6, 5},	/* y = g */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 5, 11},	/* z = r */
      {0, 0, 0, 0, 0}
   },
#endif
#if UTIL_ARCH_BIG_ENDIAN
   {
      PIPE_SWIZZLE_X,	/* sr */
      PIPE_SWIZZLE_Y,	/* sg */
      PIPE_SWIZZLE_Z,	/* sb */
      PIPE_SWIZZLE_1	/* a */
   },
#else
   {
      PIPE_SWIZZLE_Z,	/* sr */
      PIPE_SWIZZLE_Y,	/* sg */
      PIPE_SWIZZLE_X,	/* sb */
      PIPE_SWIZZLE_1	/* a */
   },
#endif
      .colorspace = UTIL_FORMAT_COLORSPACE_SRGB,
      .linear_equivalent = PIPE_FORMAT_B5G6R5_UNORM,	/* linear_equivalent */
   },

   [PIPE_FORMAT_R5G6B5_SRGB] = {
      .format = PIPE_FORMAT_R5G6B5_SRGB,
      .name = "PIPE_FORMAT_R5G6B5_SRGB",
      .short_name = "r5g6b5_srgb",
      .block = {1, 1, 1, 16},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_PLAIN,
      .nr_channels = 3,	/* nr_channels */
      .is_array = false,	/* is_array */
      .is_bitmask = true,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = true,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
#if UTIL_ARCH_BIG_ENDIAN
   {
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 5, 11},	/* x = b */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 6, 5},	/* y = g */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 5, 0},	/* z = r */
      {0, 0, 0, 0, 0}
   },
#else
   {
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 5, 0},	/* x = r */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 6, 5},	/* y = g */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 5, 11},	/* z = b */
      {0, 0, 0, 0, 0}
   },
#endif
#if UTIL_ARCH_BIG_ENDIAN
   {
      PIPE_SWIZZLE_Z,	/* sr */
      PIPE_SWIZZLE_Y,	/* sg */
      PIPE_SWIZZLE_X,	/* sb */
      PIPE_SWIZZLE_1	/* a */
   },
#else
   {
      PIPE_SWIZZLE_X,	/* sr */
      PIPE_SWIZZLE_Y,	/* sg */
      PIPE_SWIZZLE_Z,	/* sb */
      PIPE_SWIZZLE_1	/* a */
   },
#endif
      .colorspace = UTIL_FORMAT_COLORSPACE_SRGB,
      .linear_equivalent = PIPE_FORMAT_R5G6B5_UNORM,	/* linear_equivalent */
   },

   [PIPE_FORMAT_G8R8_UNORM] = {
      .format = PIPE_FORMAT_G8R8_UNORM,
      .name = "PIPE_FORMAT_G8R8_UNORM",
      .short_name = "g8r8_unorm",
      .block = {1, 1, 1, 16},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_PLAIN,
      .nr_channels = 2,	/* nr_channels */
      .is_array = true,	/* is_array */
      .is_bitmask = true,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = true,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
#if UTIL_ARCH_BIG_ENDIAN
   {
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 8, 8},	/* x = g */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 8, 0},	/* y = r */
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0}
   },
#else
   {
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 8, 0},	/* x = g */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 8, 8},	/* y = r */
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0}
   },
#endif
#if UTIL_ARCH_BIG_ENDIAN
   {
      PIPE_SWIZZLE_Y,	/* r */
      PIPE_SWIZZLE_X,	/* g */
      PIPE_SWIZZLE_0,	/* b */
      PIPE_SWIZZLE_1	/* a */
   },
#else
   {
      PIPE_SWIZZLE_Y,	/* r */
      PIPE_SWIZZLE_X,	/* g */
      PIPE_SWIZZLE_0,	/* b */
      PIPE_SWIZZLE_1	/* a */
   },
#endif
      .colorspace = UTIL_FORMAT_COLORSPACE_RGB,
      .srgb_equivalent = PIPE_FORMAT_NONE,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_G8R8_SNORM] = {
      .format = PIPE_FORMAT_G8R8_SNORM,
      .name = "PIPE_FORMAT_G8R8_SNORM",
      .short_name = "g8r8_snorm",
      .block = {1, 1, 1, 16},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_PLAIN,
      .nr_channels = 2,	/* nr_channels */
      .is_array = true,	/* is_array */
      .is_bitmask = true,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = false,	/* is_unorm */
      .is_snorm = true,	/* is_snorm */
#if UTIL_ARCH_BIG_ENDIAN
   {
      {UTIL_FORMAT_TYPE_SIGNED, true, false, 8, 8},	/* x = g */
      {UTIL_FORMAT_TYPE_SIGNED, true, false, 8, 0},	/* y = r */
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0}
   },
#else
   {
      {UTIL_FORMAT_TYPE_SIGNED, true, false, 8, 0},	/* x = g */
      {UTIL_FORMAT_TYPE_SIGNED, true, false, 8, 8},	/* y = r */
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0}
   },
#endif
#if UTIL_ARCH_BIG_ENDIAN
   {
      PIPE_SWIZZLE_Y,	/* r */
      PIPE_SWIZZLE_X,	/* g */
      PIPE_SWIZZLE_0,	/* b */
      PIPE_SWIZZLE_1	/* a */
   },
#else
   {
      PIPE_SWIZZLE_Y,	/* r */
      PIPE_SWIZZLE_X,	/* g */
      PIPE_SWIZZLE_0,	/* b */
      PIPE_SWIZZLE_1	/* a */
   },
#endif
      .colorspace = UTIL_FORMAT_COLORSPACE_RGB,
      .srgb_equivalent = PIPE_FORMAT_NONE,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_G8R8_SINT] = {
      .format = PIPE_FORMAT_G8R8_SINT,
      .name = "PIPE_FORMAT_G8R8_SINT",
      .short_name = "g8r8_sint",
      .block = {1, 1, 1, 16},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_PLAIN,
      .nr_channels = 2,	/* nr_channels */
      .is_array = true,	/* is_array */
      .is_bitmask = true,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = false,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
#if UTIL_ARCH_BIG_ENDIAN
   {
      {UTIL_FORMAT_TYPE_SIGNED, false, true, 8, 8},	/* x = g */
      {UTIL_FORMAT_TYPE_SIGNED, false, true, 8, 0},	/* y = r */
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0}
   },
#else
   {
      {UTIL_FORMAT_TYPE_SIGNED, false, true, 8, 0},	/* x = g */
      {UTIL_FORMAT_TYPE_SIGNED, false, true, 8, 8},	/* y = r */
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0}
   },
#endif
#if UTIL_ARCH_BIG_ENDIAN
   {
      PIPE_SWIZZLE_Y,	/* r */
      PIPE_SWIZZLE_X,	/* g */
      PIPE_SWIZZLE_0,	/* b */
      PIPE_SWIZZLE_1	/* a */
   },
#else
   {
      PIPE_SWIZZLE_Y,	/* r */
      PIPE_SWIZZLE_X,	/* g */
      PIPE_SWIZZLE_0,	/* b */
      PIPE_SWIZZLE_1	/* a */
   },
#endif
      .colorspace = UTIL_FORMAT_COLORSPACE_RGB,
      .srgb_equivalent = PIPE_FORMAT_NONE,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_G16R16_UNORM] = {
      .format = PIPE_FORMAT_G16R16_UNORM,
      .name = "PIPE_FORMAT_G16R16_UNORM",
      .short_name = "g16r16_unorm",
      .block = {1, 1, 1, 32},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_PLAIN,
      .nr_channels = 2,	/* nr_channels */
      .is_array = true,	/* is_array */
      .is_bitmask = true,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = true,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
#if UTIL_ARCH_BIG_ENDIAN
   {
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 16, 16},	/* x = g */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 16, 0},	/* y = r */
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0}
   },
#else
   {
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 16, 0},	/* x = g */
      {UTIL_FORMAT_TYPE_UNSIGNED, true, false, 16, 16},	/* y = r */
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0}
   },
#endif
#if UTIL_ARCH_BIG_ENDIAN
   {
      PIPE_SWIZZLE_Y,	/* r */
      PIPE_SWIZZLE_X,	/* g */
      PIPE_SWIZZLE_0,	/* b */
      PIPE_SWIZZLE_1	/* a */
   },
#else
   {
      PIPE_SWIZZLE_Y,	/* r */
      PIPE_SWIZZLE_X,	/* g */
      PIPE_SWIZZLE_0,	/* b */
      PIPE_SWIZZLE_1	/* a */
   },
#endif
      .colorspace = UTIL_FORMAT_COLORSPACE_RGB,
      .srgb_equivalent = PIPE_FORMAT_NONE,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_G16R16_SNORM] = {
      .format = PIPE_FORMAT_G16R16_SNORM,
      .name = "PIPE_FORMAT_G16R16_SNORM",
      .short_name = "g16r16_snorm",
      .block = {1, 1, 1, 32},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_PLAIN,
      .nr_channels = 2,	/* nr_channels */
      .is_array = true,	/* is_array */
      .is_bitmask = true,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = false,	/* is_unorm */
      .is_snorm = true,	/* is_snorm */
#if UTIL_ARCH_BIG_ENDIAN
   {
      {UTIL_FORMAT_TYPE_SIGNED, true, false, 16, 16},	/* x = g */
      {UTIL_FORMAT_TYPE_SIGNED, true, false, 16, 0},	/* y = r */
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0}
   },
#else
   {
      {UTIL_FORMAT_TYPE_SIGNED, true, false, 16, 0},	/* x = g */
      {UTIL_FORMAT_TYPE_SIGNED, true, false, 16, 16},	/* y = r */
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0}
   },
#endif
#if UTIL_ARCH_BIG_ENDIAN
   {
      PIPE_SWIZZLE_Y,	/* r */
      PIPE_SWIZZLE_X,	/* g */
      PIPE_SWIZZLE_0,	/* b */
      PIPE_SWIZZLE_1	/* a */
   },
#else
   {
      PIPE_SWIZZLE_Y,	/* r */
      PIPE_SWIZZLE_X,	/* g */
      PIPE_SWIZZLE_0,	/* b */
      PIPE_SWIZZLE_1	/* a */
   },
#endif
      .colorspace = UTIL_FORMAT_COLORSPACE_RGB,
      .srgb_equivalent = PIPE_FORMAT_NONE,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_G16R16_SINT] = {
      .format = PIPE_FORMAT_G16R16_SINT,
      .name = "PIPE_FORMAT_G16R16_SINT",
      .short_name = "g16r16_sint",
      .block = {1, 1, 1, 32},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_PLAIN,
      .nr_channels = 2,	/* nr_channels */
      .is_array = true,	/* is_array */
      .is_bitmask = true,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = false,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
#if UTIL_ARCH_BIG_ENDIAN
   {
      {UTIL_FORMAT_TYPE_SIGNED, false, true, 16, 16},	/* x = g */
      {UTIL_FORMAT_TYPE_SIGNED, false, true, 16, 0},	/* y = r */
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0}
   },
#else
   {
      {UTIL_FORMAT_TYPE_SIGNED, false, true, 16, 0},	/* x = g */
      {UTIL_FORMAT_TYPE_SIGNED, false, true, 16, 16},	/* y = r */
      {0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0}
   },
#endif
#if UTIL_ARCH_BIG_ENDIAN
   {
      PIPE_SWIZZLE_Y,	/* r */
      PIPE_SWIZZLE_X,	/* g */
      PIPE_SWIZZLE_0,	/* b */
      PIPE_SWIZZLE_1	/* a */
   },
#else
   {
      PIPE_SWIZZLE_Y,	/* r */
      PIPE_SWIZZLE_X,	/* g */
      PIPE_SWIZZLE_0,	/* b */
      PIPE_SWIZZLE_1	/* a */
   },
#endif
      .colorspace = UTIL_FORMAT_COLORSPACE_RGB,
      .srgb_equivalent = PIPE_FORMAT_NONE,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_A8B8G8R8_SNORM] = {
      .format = PIPE_FORMAT_A8B8G8R8_SNORM,
      .name = "PIPE_FORMAT_A8B8G8R8_SNORM",
      .short_name = "a8b8g8r8_snorm",
      .block = {1, 1, 1, 32},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_PLAIN,
      .nr_channels = 4,	/* nr_channels */
      .is_array = true,	/* is_array */
      .is_bitmask = true,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = false,	/* is_unorm */
      .is_snorm = true,	/* is_snorm */
#if UTIL_ARCH_BIG_ENDIAN
   {
      {UTIL_FORMAT_TYPE_SIGNED, true, false, 8, 24},	/* x = a */
      {UTIL_FORMAT_TYPE_SIGNED, true, false, 8, 16},	/* y = b */
      {UTIL_FORMAT_TYPE_SIGNED, true, false, 8, 8},	/* z = g */
      {UTIL_FORMAT_TYPE_SIGNED, true, false, 8, 0}	/* w = r */
   },
#else
   {
      {UTIL_FORMAT_TYPE_SIGNED, true, false, 8, 0},	/* x = a */
      {UTIL_FORMAT_TYPE_SIGNED, true, false, 8, 8},	/* y = b */
      {UTIL_FORMAT_TYPE_SIGNED, true, false, 8, 16},	/* z = g */
      {UTIL_FORMAT_TYPE_SIGNED, true, false, 8, 24}	/* w = r */
   },
#endif
#if UTIL_ARCH_BIG_ENDIAN
   {
      PIPE_SWIZZLE_W,	/* r */
      PIPE_SWIZZLE_Z,	/* g */
      PIPE_SWIZZLE_Y,	/* b */
      PIPE_SWIZZLE_X	/* a */
   },
#else
   {
      PIPE_SWIZZLE_W,	/* r */
      PIPE_SWIZZLE_Z,	/* g */
      PIPE_SWIZZLE_Y,	/* b */
      PIPE_SWIZZLE_X	/* a */
   },
#endif
      .colorspace = UTIL_FORMAT_COLORSPACE_RGB,
      .srgb_equivalent = PIPE_FORMAT_NONE,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_A8B8G8R8_SINT] = {
      .format = PIPE_FORMAT_A8B8G8R8_SINT,
      .name = "PIPE_FORMAT_A8B8G8R8_SINT",
      .short_name = "a8b8g8r8_sint",
      .block = {1, 1, 1, 32},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_PLAIN,
      .nr_channels = 4,	/* nr_channels */
      .is_array = true,	/* is_array */
      .is_bitmask = true,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = false,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
#if UTIL_ARCH_BIG_ENDIAN
   {
      {UTIL_FORMAT_TYPE_SIGNED, false, true, 8, 24},	/* x = a */
      {UTIL_FORMAT_TYPE_SIGNED, false, true, 8, 16},	/* y = b */
      {UTIL_FORMAT_TYPE_SIGNED, false, true, 8, 8},	/* z = g */
      {UTIL_FORMAT_TYPE_SIGNED, false, true, 8, 0}	/* w = r */
   },
#else
   {
      {UTIL_FORMAT_TYPE_SIGNED, false, true, 8, 0},	/* x = a */
      {UTIL_FORMAT_TYPE_SIGNED, false, true, 8, 8},	/* y = b */
      {UTIL_FORMAT_TYPE_SIGNED, false, true, 8, 16},	/* z = g */
      {UTIL_FORMAT_TYPE_SIGNED, false, true, 8, 24}	/* w = r */
   },
#endif
#if UTIL_ARCH_BIG_ENDIAN
   {
      PIPE_SWIZZLE_W,	/* r */
      PIPE_SWIZZLE_Z,	/* g */
      PIPE_SWIZZLE_Y,	/* b */
      PIPE_SWIZZLE_X	/* a */
   },
#else
   {
      PIPE_SWIZZLE_W,	/* r */
      PIPE_SWIZZLE_Z,	/* g */
      PIPE_SWIZZLE_Y,	/* b */
      PIPE_SWIZZLE_X	/* a */
   },
#endif
      .colorspace = UTIL_FORMAT_COLORSPACE_RGB,
      .srgb_equivalent = PIPE_FORMAT_NONE,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_X8B8G8R8_SNORM] = {
      .format = PIPE_FORMAT_X8B8G8R8_SNORM,
      .name = "PIPE_FORMAT_X8B8G8R8_SNORM",
      .short_name = "x8b8g8r8_snorm",
      .block = {1, 1, 1, 32},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_PLAIN,
      .nr_channels = 4,	/* nr_channels */
      .is_array = true,	/* is_array */
      .is_bitmask = true,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = false,	/* is_unorm */
      .is_snorm = true,	/* is_snorm */
#if UTIL_ARCH_BIG_ENDIAN
   {
      {UTIL_FORMAT_TYPE_VOID, false, false, 8, 24},	/* x = x */
      {UTIL_FORMAT_TYPE_SIGNED, true, false, 8, 16},	/* y = b */
      {UTIL_FORMAT_TYPE_SIGNED, true, false, 8, 8},	/* z = g */
      {UTIL_FORMAT_TYPE_SIGNED, true, false, 8, 0}	/* w = r */
   },
#else
   {
      {UTIL_FORMAT_TYPE_VOID, false, false, 8, 0},	/* x = x */
      {UTIL_FORMAT_TYPE_SIGNED, true, false, 8, 8},	/* y = b */
      {UTIL_FORMAT_TYPE_SIGNED, true, false, 8, 16},	/* z = g */
      {UTIL_FORMAT_TYPE_SIGNED, true, false, 8, 24}	/* w = r */
   },
#endif
#if UTIL_ARCH_BIG_ENDIAN
   {
      PIPE_SWIZZLE_W,	/* r */
      PIPE_SWIZZLE_Z,	/* g */
      PIPE_SWIZZLE_Y,	/* b */
      PIPE_SWIZZLE_1	/* a */
   },
#else
   {
      PIPE_SWIZZLE_W,	/* r */
      PIPE_SWIZZLE_Z,	/* g */
      PIPE_SWIZZLE_Y,	/* b */
      PIPE_SWIZZLE_1	/* a */
   },
#endif
      .colorspace = UTIL_FORMAT_COLORSPACE_RGB,
      .srgb_equivalent = PIPE_FORMAT_NONE,	/* srgb_equivalent */
   },

   [PIPE_FORMAT_X8B8G8R8_SINT] = {
      .format = PIPE_FORMAT_X8B8G8R8_SINT,
      .name = "PIPE_FORMAT_X8B8G8R8_SINT",
      .short_name = "x8b8g8r8_sint",
      .block = {1, 1, 1, 32},	/* block */
      .layout = UTIL_FORMAT_LAYOUT_PLAIN,
      .nr_channels = 4,	/* nr_channels */
      .is_array = true,	/* is_array */
      .is_bitmask = true,	/* is_bitmask */
      .is_mixed = false,	/* is_mixed */
      .is_unorm = false,	/* is_unorm */
      .is_snorm = false,	/* is_snorm */
#if UTIL_ARCH_BIG_ENDIAN
   {
      {UTIL_FORMAT_TYPE_VOID, false, false, 8, 24},	/* x = x */
      {UTIL_FORMAT_TYPE_SIGNED, false, true, 8, 16},	/* y = b */
      {UTIL_FORMAT_TYPE_SIGNED, false, true, 8, 8},	/* z = g */
      {UTIL_FORMAT_TYPE_SIGNED, false, true, 8, 0}	/* w = r */
   },
#else
   {
      {UTIL_FORMAT_TYPE_VOID, false, false, 8, 0},	/* x = x */
      {UTIL_FORMAT_TYPE_SIGNED, false, true, 8, 8},	/* y = b */
      {UTIL_FORMAT_TYPE_SIGNED, false, true, 8, 16},	/* z = g */
      {UTIL_FORMAT_TYPE_SIGNED, false, true, 8, 24}	/* w = r */
   },
#endif
#if UTIL_ARCH_BIG_ENDIAN
   {
      PIPE_SWIZZLE_W,	/* r */
      PIPE_SWIZZLE_Z,	/* g */
      PIPE_SWIZZLE_Y,	/* b */
      PIPE_SWIZZLE_1	/* a */
   },
#else
   {
      PIPE_SWIZZLE_W,	/* r */
      PIPE_SWIZZLE_Z,	/* g */
      PIPE_SWIZZLE_Y,	/* b */
      PIPE_SWIZZLE_1	/* a */
   },
#endif
      .colorspace = UTIL_FORMAT_COLORSPACE_RGB,
      .srgb_equivalent = PIPE_FORMAT_NONE,	/* srgb_equivalent */
   },

};

ATTRIBUTE_RETURNS_NONNULL const struct util_format_description *
util_format_description(enum pipe_format format)
{
   assert(format < PIPE_FORMAT_COUNT);
   return &util_format_descriptions[format];
}

