/** @file
 * VirtualBox API class wrapper code for IEventSource.
 *
 * DO NOT EDIT! This is a generated file.
 * Generated from: src/VBox/Main/idl/VirtualBox.xidl
 * Generator: src/VBox/Main/idl/apiwrap-server.xsl
 */

/*
 * Copyright (C) 2010-2025 Oracle and/or its affiliates.
 *
 * This file is part of VirtualBox base platform packages, as
 * available from https://www.virtualbox.org.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation, in version 3 of the
 * License.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see <https://www.gnu.org/licenses>.
 *
 * SPDX-License-Identifier: GPL-3.0-only
 */

#define LOG_GROUP LOG_GROUP_MAIN_EVENTSOURCE

#include "EventSourceWrap.h"
#include "LoggingNew.h"
#ifdef VBOX_WITH_DTRACE_R3_MAIN
# include "dtrace/VBoxAPI.h"
#endif

DEFINE_EMPTY_CTOR_DTOR(EventSourceWrap)

//
// IEventSource properties
//


//
// IEventSource methods
//

STDMETHODIMP EventSourceWrap::CreateListener(IEventListener **aListener)
{
    LogRelFlow(("{%p} %s: enter aListener=%p\n", this, "EventSource::createListener", aListener));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aListener);


        ComTypeOutConverter<IEventListener> TmpListener(aListener);

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_EVENTSOURCE_CREATELISTENER_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = createListener(TmpListener.ptr());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_EVENTSOURCE_CREATELISTENER_RETURN(this, hrc, 0 /*normal*/, (void *)TmpListener.ptr());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_EVENTSOURCE_CREATELISTENER_RETURN(this, hrc, 1 /*hrc exception*/, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_EVENTSOURCE_CREATELISTENER_RETURN(this, hrc, 9 /*unhandled exception*/, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave aListener=%p hrc=%Rhrc\n", this, "EventSource::createListener", *aListener, hrc));
    return hrc;
}

STDMETHODIMP EventSourceWrap::CreateAggregator(ComSafeArrayIn(IEventSource *, aSubordinates),
                                               IEventSource **aResult)
{
    LogRelFlow(("{%p} %s: enter aSubordinates=%zu aResult=%p\n", this, "EventSource::createAggregator", aSubordinates, aResult));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aResult);


        ArrayComTypeInConverter<IEventSource> TmpSubordinates(ComSafeArrayInArg(aSubordinates));
        ComTypeOutConverter<IEventSource> TmpResult(aResult);

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_EVENTSOURCE_CREATEAGGREGATOR_ENTER(this, (uint32_t)TmpSubordinates.array().size(), NULL /*for now*/);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = createAggregator(TmpSubordinates.array(),
                                   TmpResult.ptr());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_EVENTSOURCE_CREATEAGGREGATOR_RETURN(this, hrc, 0 /*normal*/, (uint32_t)TmpSubordinates.array().size(), NULL /*for now*/, (void *)TmpResult.ptr());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_EVENTSOURCE_CREATEAGGREGATOR_RETURN(this, hrc, 1 /*hrc exception*/, 0, 0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_EVENTSOURCE_CREATEAGGREGATOR_RETURN(this, hrc, 9 /*unhandled exception*/, 0, 0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave aResult=%p hrc=%Rhrc\n", this, "EventSource::createAggregator", *aResult, hrc));
    return hrc;
}

STDMETHODIMP EventSourceWrap::RegisterListener(IEventListener *aListener,
                                               ComSafeArrayIn(VBoxEventType_T, aInteresting),
                                               BOOL aActive)
{
    LogRelFlow(("{%p} %s: enter aListener=%p aInteresting=%zu aActive=%RTbool\n", this, "EventSource::registerListener", aListener, aInteresting, aActive));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {


        ComTypeInConverter<IEventListener> TmpListener(aListener);
        ArrayInConverter<VBoxEventType_T> TmpInteresting(ComSafeArrayInArg(aInteresting));
        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_EVENTSOURCE_REGISTERLISTENER_ENTER(this, (void *)TmpListener.ptr(), (uint32_t)TmpInteresting.array().size(), NULL /*for now*/, aActive != FALSE);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = registerListener(TmpListener.ptr(),
                                   TmpInteresting.array(),
                                   aActive != FALSE);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_EVENTSOURCE_REGISTERLISTENER_RETURN(this, hrc, 0 /*normal*/, (void *)TmpListener.ptr(), (uint32_t)TmpInteresting.array().size(), NULL /*for now*/, aActive != FALSE);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_EVENTSOURCE_REGISTERLISTENER_RETURN(this, hrc, 1 /*hrc exception*/, 0, 0, 0, aActive != FALSE);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_EVENTSOURCE_REGISTERLISTENER_RETURN(this, hrc, 9 /*unhandled exception*/, 0, 0, 0, aActive != FALSE);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "EventSource::registerListener", hrc));
    return hrc;
}

STDMETHODIMP EventSourceWrap::UnregisterListener(IEventListener *aListener)
{
    LogRelFlow(("{%p} %s: enter aListener=%p\n", this, "EventSource::unregisterListener", aListener));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {


        ComTypeInConverter<IEventListener> TmpListener(aListener);

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_EVENTSOURCE_UNREGISTERLISTENER_ENTER(this, (void *)TmpListener.ptr());
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = unregisterListener(TmpListener.ptr());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_EVENTSOURCE_UNREGISTERLISTENER_RETURN(this, hrc, 0 /*normal*/, (void *)TmpListener.ptr());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_EVENTSOURCE_UNREGISTERLISTENER_RETURN(this, hrc, 1 /*hrc exception*/, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_EVENTSOURCE_UNREGISTERLISTENER_RETURN(this, hrc, 9 /*unhandled exception*/, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "EventSource::unregisterListener", hrc));
    return hrc;
}

STDMETHODIMP EventSourceWrap::FireEvent(IEvent *aEvent,
                                        LONG aTimeout,
                                        BOOL *aResult)
{
    LogRelFlow(("{%p} %s: enter aEvent=%p aTimeout=%RI32 aResult=%p\n", this, "EventSource::fireEvent", aEvent, aTimeout, aResult));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aResult);


        ComTypeInConverter<IEvent> TmpEvent(aEvent);
        
        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_EVENTSOURCE_FIREEVENT_ENTER(this, (void *)TmpEvent.ptr(), aTimeout);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = fireEvent(TmpEvent.ptr(),
                            aTimeout,
                            aResult);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_EVENTSOURCE_FIREEVENT_RETURN(this, hrc, 0 /*normal*/, (void *)TmpEvent.ptr(), aTimeout, *aResult != FALSE);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_EVENTSOURCE_FIREEVENT_RETURN(this, hrc, 1 /*hrc exception*/, 0, aTimeout, *aResult != FALSE);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_EVENTSOURCE_FIREEVENT_RETURN(this, hrc, 9 /*unhandled exception*/, 0, aTimeout, *aResult != FALSE);
#endif
    }

    LogRelFlow(("{%p} %s: leave aResult=%RTbool hrc=%Rhrc\n", this, "EventSource::fireEvent", *aResult, hrc));
    return hrc;
}

STDMETHODIMP EventSourceWrap::GetEvent(IEventListener *aListener,
                                       LONG aTimeout,
                                       IEvent **aEvent)
{
    LogRelFlow(("{%p} %s: enter aListener=%p aTimeout=%RI32 aEvent=%p\n", this, "EventSource::getEvent", aListener, aTimeout, aEvent));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aEvent);


        ComTypeInConverter<IEventListener> TmpListener(aListener);
        
        ComTypeOutConverter<IEvent> TmpEvent(aEvent);

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_EVENTSOURCE_GETEVENT_ENTER(this, (void *)TmpListener.ptr(), aTimeout);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getEvent(TmpListener.ptr(),
                           aTimeout,
                           TmpEvent.ptr());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_EVENTSOURCE_GETEVENT_RETURN(this, hrc, 0 /*normal*/, (void *)TmpListener.ptr(), aTimeout, (void *)TmpEvent.ptr());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_EVENTSOURCE_GETEVENT_RETURN(this, hrc, 1 /*hrc exception*/, 0, aTimeout, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_EVENTSOURCE_GETEVENT_RETURN(this, hrc, 9 /*unhandled exception*/, 0, aTimeout, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave aEvent=%p hrc=%Rhrc\n", this, "EventSource::getEvent", *aEvent, hrc));
    return hrc;
}

STDMETHODIMP EventSourceWrap::EventProcessed(IEventListener *aListener,
                                             IEvent *aEvent)
{
    LogRelFlow(("{%p} %s: enter aListener=%p aEvent=%p\n", this, "EventSource::eventProcessed", aListener, aEvent));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {


        ComTypeInConverter<IEventListener> TmpListener(aListener);
        ComTypeInConverter<IEvent> TmpEvent(aEvent);

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_EVENTSOURCE_EVENTPROCESSED_ENTER(this, (void *)TmpListener.ptr(), (void *)TmpEvent.ptr());
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = eventProcessed(TmpListener.ptr(),
                                 TmpEvent.ptr());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_EVENTSOURCE_EVENTPROCESSED_RETURN(this, hrc, 0 /*normal*/, (void *)TmpListener.ptr(), (void *)TmpEvent.ptr());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_EVENTSOURCE_EVENTPROCESSED_RETURN(this, hrc, 1 /*hrc exception*/, 0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_EVENTSOURCE_EVENTPROCESSED_RETURN(this, hrc, 9 /*unhandled exception*/, 0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "EventSource::eventProcessed", hrc));
    return hrc;
}

#ifdef VBOX_WITH_XPCOM
NS_DECL_CLASSINFO(EventSourceWrap)
NS_IMPL_THREADSAFE_ISUPPORTS1_CI(EventSourceWrap, IEventSource)
#endif // VBOX_WITH_XPCOM
