/** @file
 * VirtualBox API class wrapper code for IExtPackManager.
 *
 * DO NOT EDIT! This is a generated file.
 * Generated from: src/VBox/Main/idl/VirtualBox.xidl
 * Generator: src/VBox/Main/idl/apiwrap-server.xsl
 */

/*
 * Copyright (C) 2010-2025 Oracle and/or its affiliates.
 *
 * This file is part of VirtualBox base platform packages, as
 * available from https://www.virtualbox.org.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation, in version 3 of the
 * License.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see <https://www.gnu.org/licenses>.
 *
 * SPDX-License-Identifier: GPL-3.0-only
 */

#define LOG_GROUP LOG_GROUP_MAIN_EXTPACKMANAGER

#include "ExtPackManagerWrap.h"
#include "LoggingNew.h"
#ifdef VBOX_WITH_DTRACE_R3_MAIN
# include "dtrace/VBoxAPI.h"
#endif

DEFINE_EMPTY_CTOR_DTOR(ExtPackManagerWrap)

//
// IExtPackManager properties
//

STDMETHODIMP ExtPackManagerWrap::COMGETTER(InstalledExtPacks)(ComSafeArrayOut(IExtPack *, aInstalledExtPacks))
{
    LogRelFlow(("{%p} %s: enter aInstalledExtPacks=%p\n", this, "ExtPackManager::getInstalledExtPacks", aInstalledExtPacks));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aInstalledExtPacks);
        ArrayComTypeOutConverter<IExtPack> TmpInstalledExtPacks(ComSafeArrayOutArg(aInstalledExtPacks));
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_EXTPACKMANAGER_GET_INSTALLEDEXTPACKS_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getInstalledExtPacks(TmpInstalledExtPacks.array());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_EXTPACKMANAGER_GET_INSTALLEDEXTPACKS_RETURN(this, hrc, 0 /*normal*/,(uint32_t)TmpInstalledExtPacks.array().size(), NULL /*for now*/);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_EXTPACKMANAGER_GET_INSTALLEDEXTPACKS_RETURN(this, hrc, 1 /*hrc exception*/,0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_EXTPACKMANAGER_GET_INSTALLEDEXTPACKS_RETURN(this, hrc, 9 /*unhandled exception*/,0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aInstalledExtPacks=%zu hrc=%Rhrc\n", this, "ExtPackManager::getInstalledExtPacks", ComSafeArraySize(*aInstalledExtPacks), hrc));
    return hrc;
}

STDMETHODIMP ExtPackManagerWrap::COMGETTER(InternalAndReservedAttribute1IExtPackManager)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP ExtPackManagerWrap::COMGETTER(InternalAndReservedAttribute2IExtPackManager)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP ExtPackManagerWrap::COMGETTER(InternalAndReservedAttribute3IExtPackManager)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP ExtPackManagerWrap::COMGETTER(InternalAndReservedAttribute4IExtPackManager)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP ExtPackManagerWrap::COMGETTER(InternalAndReservedAttribute5IExtPackManager)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP ExtPackManagerWrap::COMGETTER(InternalAndReservedAttribute6IExtPackManager)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP ExtPackManagerWrap::COMGETTER(InternalAndReservedAttribute7IExtPackManager)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP ExtPackManagerWrap::COMGETTER(InternalAndReservedAttribute8IExtPackManager)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}


//
// IExtPackManager methods
//

STDMETHODIMP ExtPackManagerWrap::Find(IN_BSTR aName,
                                      IExtPack **aReturnData)
{
    LogRelFlow(("{%p} %s: enter aName=%ls aReturnData=%p\n", this, "ExtPackManager::find", aName, aReturnData));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aReturnData);


        BSTRInConverter TmpName(aName);
        ComTypeOutConverter<IExtPack> TmpReturnData(aReturnData);

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_EXTPACKMANAGER_FIND_ENTER(this, TmpName.str().c_str());
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = find(TmpName.str(),
                       TmpReturnData.ptr());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_EXTPACKMANAGER_FIND_RETURN(this, hrc, 0 /*normal*/, TmpName.str().c_str(), (void *)TmpReturnData.ptr());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_EXTPACKMANAGER_FIND_RETURN(this, hrc, 1 /*hrc exception*/, 0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_EXTPACKMANAGER_FIND_RETURN(this, hrc, 9 /*unhandled exception*/, 0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave aReturnData=%p hrc=%Rhrc\n", this, "ExtPackManager::find", *aReturnData, hrc));
    return hrc;
}

STDMETHODIMP ExtPackManagerWrap::OpenExtPackFile(IN_BSTR aPath,
                                                 IExtPackFile **aFile)
{
    LogRelFlow(("{%p} %s: enter aPath=%ls aFile=%p\n", this, "ExtPackManager::openExtPackFile", aPath, aFile));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aFile);


        BSTRInConverter TmpPath(aPath);
        ComTypeOutConverter<IExtPackFile> TmpFile(aFile);

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_EXTPACKMANAGER_OPENEXTPACKFILE_ENTER(this, TmpPath.str().c_str());
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = openExtPackFile(TmpPath.str(),
                                  TmpFile.ptr());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_EXTPACKMANAGER_OPENEXTPACKFILE_RETURN(this, hrc, 0 /*normal*/, TmpPath.str().c_str(), (void *)TmpFile.ptr());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_EXTPACKMANAGER_OPENEXTPACKFILE_RETURN(this, hrc, 1 /*hrc exception*/, 0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_EXTPACKMANAGER_OPENEXTPACKFILE_RETURN(this, hrc, 9 /*unhandled exception*/, 0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave aFile=%p hrc=%Rhrc\n", this, "ExtPackManager::openExtPackFile", *aFile, hrc));
    return hrc;
}

STDMETHODIMP ExtPackManagerWrap::Uninstall(IN_BSTR aName,
                                           BOOL aForcedRemoval,
                                           IN_BSTR aDisplayInfo,
                                           IProgress **aProgress)
{
    LogRelFlow(("{%p} %s: enter aName=%ls aForcedRemoval=%RTbool aDisplayInfo=%ls aProgress=%p\n", this, "ExtPackManager::uninstall", aName, aForcedRemoval, aDisplayInfo, aProgress));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aProgress);


        BSTRInConverter TmpName(aName);
        
        BSTRInConverter TmpDisplayInfo(aDisplayInfo);
        ComTypeOutConverter<IProgress> TmpProgress(aProgress);

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_EXTPACKMANAGER_UNINSTALL_ENTER(this, TmpName.str().c_str(), aForcedRemoval != FALSE, TmpDisplayInfo.str().c_str());
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = uninstall(TmpName.str(),
                            aForcedRemoval != FALSE,
                            TmpDisplayInfo.str(),
                            TmpProgress.ptr());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_EXTPACKMANAGER_UNINSTALL_RETURN(this, hrc, 0 /*normal*/, TmpName.str().c_str(), aForcedRemoval != FALSE, TmpDisplayInfo.str().c_str(), (void *)TmpProgress.ptr());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_EXTPACKMANAGER_UNINSTALL_RETURN(this, hrc, 1 /*hrc exception*/, 0, aForcedRemoval != FALSE, 0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_EXTPACKMANAGER_UNINSTALL_RETURN(this, hrc, 9 /*unhandled exception*/, 0, aForcedRemoval != FALSE, 0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave aProgress=%p hrc=%Rhrc\n", this, "ExtPackManager::uninstall", *aProgress, hrc));
    return hrc;
}

STDMETHODIMP ExtPackManagerWrap::Cleanup()
{
    LogRelFlow(("{%p} %s: enter\n", this, "ExtPackManager::cleanup"));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {



#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_EXTPACKMANAGER_CLEANUP_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = cleanup();
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_EXTPACKMANAGER_CLEANUP_RETURN(this, hrc, 0 /*normal*/);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_EXTPACKMANAGER_CLEANUP_RETURN(this, hrc, 1 /*hrc exception*/);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_EXTPACKMANAGER_CLEANUP_RETURN(this, hrc, 9 /*unhandled exception*/);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "ExtPackManager::cleanup", hrc));
    return hrc;
}

STDMETHODIMP ExtPackManagerWrap::QueryAllPlugInsForFrontend(IN_BSTR aFrontendName,
                                                            ComSafeArrayOut(BSTR, aPlugInModules))
{
    LogRelFlow(("{%p} %s: enter aFrontendName=%ls aPlugInModules=%p\n", this, "ExtPackManager::queryAllPlugInsForFrontend", aFrontendName, aPlugInModules));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aPlugInModules);


        BSTRInConverter TmpFrontendName(aFrontendName);
        ArrayBSTROutConverter TmpPlugInModules(ComSafeArrayOutArg(aPlugInModules));

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_EXTPACKMANAGER_QUERYALLPLUGINSFORFRONTEND_ENTER(this, TmpFrontendName.str().c_str());
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = queryAllPlugInsForFrontend(TmpFrontendName.str(),
                                             TmpPlugInModules.array());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_EXTPACKMANAGER_QUERYALLPLUGINSFORFRONTEND_RETURN(this, hrc, 0 /*normal*/, TmpFrontendName.str().c_str(), (uint32_t)TmpPlugInModules.array().size(), NULL /*for now*/);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_EXTPACKMANAGER_QUERYALLPLUGINSFORFRONTEND_RETURN(this, hrc, 1 /*hrc exception*/, 0, 0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_EXTPACKMANAGER_QUERYALLPLUGINSFORFRONTEND_RETURN(this, hrc, 9 /*unhandled exception*/, 0, 0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave aPlugInModules=%zu hrc=%Rhrc\n", this, "ExtPackManager::queryAllPlugInsForFrontend", ComSafeArraySize(*aPlugInModules), hrc));
    return hrc;
}

STDMETHODIMP ExtPackManagerWrap::IsExtPackUsable(IN_BSTR aName,
                                                 BOOL *aUsable)
{
    LogRelFlow(("{%p} %s: enter aName=%ls aUsable=%p\n", this, "ExtPackManager::isExtPackUsable", aName, aUsable));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aUsable);


        BSTRInConverter TmpName(aName);
        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_EXTPACKMANAGER_ISEXTPACKUSABLE_ENTER(this, TmpName.str().c_str());
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = isExtPackUsable(TmpName.str(),
                                  aUsable);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_EXTPACKMANAGER_ISEXTPACKUSABLE_RETURN(this, hrc, 0 /*normal*/, TmpName.str().c_str(), *aUsable != FALSE);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_EXTPACKMANAGER_ISEXTPACKUSABLE_RETURN(this, hrc, 1 /*hrc exception*/, 0, *aUsable != FALSE);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_EXTPACKMANAGER_ISEXTPACKUSABLE_RETURN(this, hrc, 9 /*unhandled exception*/, 0, *aUsable != FALSE);
#endif
    }

    LogRelFlow(("{%p} %s: leave aUsable=%RTbool hrc=%Rhrc\n", this, "ExtPackManager::isExtPackUsable", *aUsable, hrc));
    return hrc;
}

STDMETHODIMP ExtPackManagerWrap::InternalAndReservedMethod1IExtPackManager()
{
    return E_NOTIMPL;
}

STDMETHODIMP ExtPackManagerWrap::InternalAndReservedMethod2IExtPackManager()
{
    return E_NOTIMPL;
}

STDMETHODIMP ExtPackManagerWrap::InternalAndReservedMethod3IExtPackManager()
{
    return E_NOTIMPL;
}

STDMETHODIMP ExtPackManagerWrap::InternalAndReservedMethod4IExtPackManager()
{
    return E_NOTIMPL;
}

#ifdef VBOX_WITH_XPCOM
NS_DECL_CLASSINFO(ExtPackManagerWrap)
NS_IMPL_THREADSAFE_ISUPPORTS1_CI(ExtPackManagerWrap, IExtPackManager)
#endif // VBOX_WITH_XPCOM
