/** @file
 * VirtualBox API class wrapper code for IFirmwareSettings.
 *
 * DO NOT EDIT! This is a generated file.
 * Generated from: src/VBox/Main/idl/VirtualBox.xidl
 * Generator: src/VBox/Main/idl/apiwrap-server.xsl
 */

/*
 * Copyright (C) 2010-2025 Oracle and/or its affiliates.
 *
 * This file is part of VirtualBox base platform packages, as
 * available from https://www.virtualbox.org.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation, in version 3 of the
 * License.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see <https://www.gnu.org/licenses>.
 *
 * SPDX-License-Identifier: GPL-3.0-only
 */

#define LOG_GROUP LOG_GROUP_MAIN_FIRMWARESETTINGS

#include "FirmwareSettingsWrap.h"
#include "LoggingNew.h"
#ifdef VBOX_WITH_DTRACE_R3_MAIN
# include "dtrace/VBoxAPI.h"
#endif

DEFINE_EMPTY_CTOR_DTOR(FirmwareSettingsWrap)

//
// IFirmwareSettings properties
//

STDMETHODIMP FirmwareSettingsWrap::COMGETTER(FirmwareType)(FirmwareType_T *aFirmwareType)
{
    LogRelFlow(("{%p} %s: enter aFirmwareType=%p\n", this, "FirmwareSettings::getFirmwareType", aFirmwareType));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aFirmwareType);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_FIRMWARESETTINGS_GET_FIRMWARETYPE_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getFirmwareType(aFirmwareType);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_FIRMWARESETTINGS_GET_FIRMWARETYPE_RETURN(this, hrc, 0 /*normal*/,*aFirmwareType);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_FIRMWARESETTINGS_GET_FIRMWARETYPE_RETURN(this, hrc, 1 /*hrc exception*/,*aFirmwareType);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_FIRMWARESETTINGS_GET_FIRMWARETYPE_RETURN(this, hrc, 9 /*unhandled exception*/,*aFirmwareType);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aFirmwareType=%RU32 hrc=%Rhrc\n", this, "FirmwareSettings::getFirmwareType", *aFirmwareType, hrc));
    return hrc;
}

STDMETHODIMP FirmwareSettingsWrap::COMSETTER(FirmwareType)(FirmwareType_T aFirmwareType)
{
    LogRelFlow(("{%p} %s: enter aFirmwareType=%RU32\n", this, "FirmwareSettings::setFirmwareType", aFirmwareType));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_FIRMWARESETTINGS_SET_FIRMWARETYPE_ENTER(this, aFirmwareType);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = setFirmwareType(aFirmwareType);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_FIRMWARESETTINGS_SET_FIRMWARETYPE_RETURN(this, hrc, 0 /*normal*/,aFirmwareType);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_FIRMWARESETTINGS_SET_FIRMWARETYPE_RETURN(this, hrc, 1 /*hrc exception*/,aFirmwareType);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_FIRMWARESETTINGS_SET_FIRMWARETYPE_RETURN(this, hrc, 9 /*unhandled exception*/,aFirmwareType);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "FirmwareSettings::setFirmwareType", hrc));
    return hrc;
}

STDMETHODIMP FirmwareSettingsWrap::COMGETTER(LogoFadeIn)(BOOL *aLogoFadeIn)
{
    LogRelFlow(("{%p} %s: enter aLogoFadeIn=%p\n", this, "FirmwareSettings::getLogoFadeIn", aLogoFadeIn));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aLogoFadeIn);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_FIRMWARESETTINGS_GET_LOGOFADEIN_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getLogoFadeIn(aLogoFadeIn);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_FIRMWARESETTINGS_GET_LOGOFADEIN_RETURN(this, hrc, 0 /*normal*/,*aLogoFadeIn != FALSE);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_FIRMWARESETTINGS_GET_LOGOFADEIN_RETURN(this, hrc, 1 /*hrc exception*/,*aLogoFadeIn != FALSE);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_FIRMWARESETTINGS_GET_LOGOFADEIN_RETURN(this, hrc, 9 /*unhandled exception*/,*aLogoFadeIn != FALSE);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aLogoFadeIn=%RTbool hrc=%Rhrc\n", this, "FirmwareSettings::getLogoFadeIn", *aLogoFadeIn, hrc));
    return hrc;
}

STDMETHODIMP FirmwareSettingsWrap::COMSETTER(LogoFadeIn)(BOOL aLogoFadeIn)
{
    LogRelFlow(("{%p} %s: enter aLogoFadeIn=%RTbool\n", this, "FirmwareSettings::setLogoFadeIn", aLogoFadeIn));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_FIRMWARESETTINGS_SET_LOGOFADEIN_ENTER(this, aLogoFadeIn != FALSE);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = setLogoFadeIn(aLogoFadeIn != FALSE);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_FIRMWARESETTINGS_SET_LOGOFADEIN_RETURN(this, hrc, 0 /*normal*/,aLogoFadeIn != FALSE);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_FIRMWARESETTINGS_SET_LOGOFADEIN_RETURN(this, hrc, 1 /*hrc exception*/,aLogoFadeIn != FALSE);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_FIRMWARESETTINGS_SET_LOGOFADEIN_RETURN(this, hrc, 9 /*unhandled exception*/,aLogoFadeIn != FALSE);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "FirmwareSettings::setLogoFadeIn", hrc));
    return hrc;
}

STDMETHODIMP FirmwareSettingsWrap::COMGETTER(LogoFadeOut)(BOOL *aLogoFadeOut)
{
    LogRelFlow(("{%p} %s: enter aLogoFadeOut=%p\n", this, "FirmwareSettings::getLogoFadeOut", aLogoFadeOut));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aLogoFadeOut);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_FIRMWARESETTINGS_GET_LOGOFADEOUT_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getLogoFadeOut(aLogoFadeOut);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_FIRMWARESETTINGS_GET_LOGOFADEOUT_RETURN(this, hrc, 0 /*normal*/,*aLogoFadeOut != FALSE);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_FIRMWARESETTINGS_GET_LOGOFADEOUT_RETURN(this, hrc, 1 /*hrc exception*/,*aLogoFadeOut != FALSE);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_FIRMWARESETTINGS_GET_LOGOFADEOUT_RETURN(this, hrc, 9 /*unhandled exception*/,*aLogoFadeOut != FALSE);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aLogoFadeOut=%RTbool hrc=%Rhrc\n", this, "FirmwareSettings::getLogoFadeOut", *aLogoFadeOut, hrc));
    return hrc;
}

STDMETHODIMP FirmwareSettingsWrap::COMSETTER(LogoFadeOut)(BOOL aLogoFadeOut)
{
    LogRelFlow(("{%p} %s: enter aLogoFadeOut=%RTbool\n", this, "FirmwareSettings::setLogoFadeOut", aLogoFadeOut));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_FIRMWARESETTINGS_SET_LOGOFADEOUT_ENTER(this, aLogoFadeOut != FALSE);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = setLogoFadeOut(aLogoFadeOut != FALSE);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_FIRMWARESETTINGS_SET_LOGOFADEOUT_RETURN(this, hrc, 0 /*normal*/,aLogoFadeOut != FALSE);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_FIRMWARESETTINGS_SET_LOGOFADEOUT_RETURN(this, hrc, 1 /*hrc exception*/,aLogoFadeOut != FALSE);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_FIRMWARESETTINGS_SET_LOGOFADEOUT_RETURN(this, hrc, 9 /*unhandled exception*/,aLogoFadeOut != FALSE);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "FirmwareSettings::setLogoFadeOut", hrc));
    return hrc;
}

STDMETHODIMP FirmwareSettingsWrap::COMGETTER(LogoDisplayTime)(ULONG *aLogoDisplayTime)
{
    LogRelFlow(("{%p} %s: enter aLogoDisplayTime=%p\n", this, "FirmwareSettings::getLogoDisplayTime", aLogoDisplayTime));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aLogoDisplayTime);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_FIRMWARESETTINGS_GET_LOGODISPLAYTIME_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getLogoDisplayTime(aLogoDisplayTime);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_FIRMWARESETTINGS_GET_LOGODISPLAYTIME_RETURN(this, hrc, 0 /*normal*/,*aLogoDisplayTime);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_FIRMWARESETTINGS_GET_LOGODISPLAYTIME_RETURN(this, hrc, 1 /*hrc exception*/,*aLogoDisplayTime);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_FIRMWARESETTINGS_GET_LOGODISPLAYTIME_RETURN(this, hrc, 9 /*unhandled exception*/,*aLogoDisplayTime);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aLogoDisplayTime=%RU32 hrc=%Rhrc\n", this, "FirmwareSettings::getLogoDisplayTime", *aLogoDisplayTime, hrc));
    return hrc;
}

STDMETHODIMP FirmwareSettingsWrap::COMSETTER(LogoDisplayTime)(ULONG aLogoDisplayTime)
{
    LogRelFlow(("{%p} %s: enter aLogoDisplayTime=%RU32\n", this, "FirmwareSettings::setLogoDisplayTime", aLogoDisplayTime));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_FIRMWARESETTINGS_SET_LOGODISPLAYTIME_ENTER(this, aLogoDisplayTime);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = setLogoDisplayTime(aLogoDisplayTime);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_FIRMWARESETTINGS_SET_LOGODISPLAYTIME_RETURN(this, hrc, 0 /*normal*/,aLogoDisplayTime);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_FIRMWARESETTINGS_SET_LOGODISPLAYTIME_RETURN(this, hrc, 1 /*hrc exception*/,aLogoDisplayTime);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_FIRMWARESETTINGS_SET_LOGODISPLAYTIME_RETURN(this, hrc, 9 /*unhandled exception*/,aLogoDisplayTime);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "FirmwareSettings::setLogoDisplayTime", hrc));
    return hrc;
}

STDMETHODIMP FirmwareSettingsWrap::COMGETTER(LogoImagePath)(BSTR *aLogoImagePath)
{
    LogRelFlow(("{%p} %s: enter aLogoImagePath=%p\n", this, "FirmwareSettings::getLogoImagePath", aLogoImagePath));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aLogoImagePath);
        BSTROutConverter TmpLogoImagePath(aLogoImagePath);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_FIRMWARESETTINGS_GET_LOGOIMAGEPATH_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getLogoImagePath(TmpLogoImagePath.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_FIRMWARESETTINGS_GET_LOGOIMAGEPATH_RETURN(this, hrc, 0 /*normal*/,TmpLogoImagePath.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_FIRMWARESETTINGS_GET_LOGOIMAGEPATH_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_FIRMWARESETTINGS_GET_LOGOIMAGEPATH_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aLogoImagePath=%ls hrc=%Rhrc\n", this, "FirmwareSettings::getLogoImagePath", *aLogoImagePath, hrc));
    return hrc;
}

STDMETHODIMP FirmwareSettingsWrap::COMSETTER(LogoImagePath)(IN_BSTR aLogoImagePath)
{
    LogRelFlow(("{%p} %s: enter aLogoImagePath=%ls\n", this, "FirmwareSettings::setLogoImagePath", aLogoImagePath));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        BSTRInConverter TmpLogoImagePath(aLogoImagePath);

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_FIRMWARESETTINGS_SET_LOGOIMAGEPATH_ENTER(this, TmpLogoImagePath.str().c_str());
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = setLogoImagePath(TmpLogoImagePath.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_FIRMWARESETTINGS_SET_LOGOIMAGEPATH_RETURN(this, hrc, 0 /*normal*/,TmpLogoImagePath.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_FIRMWARESETTINGS_SET_LOGOIMAGEPATH_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_FIRMWARESETTINGS_SET_LOGOIMAGEPATH_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "FirmwareSettings::setLogoImagePath", hrc));
    return hrc;
}

STDMETHODIMP FirmwareSettingsWrap::COMGETTER(BootMenuMode)(FirmwareBootMenuMode_T *aBootMenuMode)
{
    LogRelFlow(("{%p} %s: enter aBootMenuMode=%p\n", this, "FirmwareSettings::getBootMenuMode", aBootMenuMode));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aBootMenuMode);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_FIRMWARESETTINGS_GET_BOOTMENUMODE_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getBootMenuMode(aBootMenuMode);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_FIRMWARESETTINGS_GET_BOOTMENUMODE_RETURN(this, hrc, 0 /*normal*/,*aBootMenuMode);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_FIRMWARESETTINGS_GET_BOOTMENUMODE_RETURN(this, hrc, 1 /*hrc exception*/,*aBootMenuMode);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_FIRMWARESETTINGS_GET_BOOTMENUMODE_RETURN(this, hrc, 9 /*unhandled exception*/,*aBootMenuMode);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aBootMenuMode=%RU32 hrc=%Rhrc\n", this, "FirmwareSettings::getBootMenuMode", *aBootMenuMode, hrc));
    return hrc;
}

STDMETHODIMP FirmwareSettingsWrap::COMSETTER(BootMenuMode)(FirmwareBootMenuMode_T aBootMenuMode)
{
    LogRelFlow(("{%p} %s: enter aBootMenuMode=%RU32\n", this, "FirmwareSettings::setBootMenuMode", aBootMenuMode));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_FIRMWARESETTINGS_SET_BOOTMENUMODE_ENTER(this, aBootMenuMode);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = setBootMenuMode(aBootMenuMode);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_FIRMWARESETTINGS_SET_BOOTMENUMODE_RETURN(this, hrc, 0 /*normal*/,aBootMenuMode);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_FIRMWARESETTINGS_SET_BOOTMENUMODE_RETURN(this, hrc, 1 /*hrc exception*/,aBootMenuMode);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_FIRMWARESETTINGS_SET_BOOTMENUMODE_RETURN(this, hrc, 9 /*unhandled exception*/,aBootMenuMode);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "FirmwareSettings::setBootMenuMode", hrc));
    return hrc;
}

STDMETHODIMP FirmwareSettingsWrap::COMGETTER(ACPIEnabled)(BOOL *aACPIEnabled)
{
    LogRelFlow(("{%p} %s: enter aACPIEnabled=%p\n", this, "FirmwareSettings::getACPIEnabled", aACPIEnabled));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aACPIEnabled);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_FIRMWARESETTINGS_GET_ACPIENABLED_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getACPIEnabled(aACPIEnabled);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_FIRMWARESETTINGS_GET_ACPIENABLED_RETURN(this, hrc, 0 /*normal*/,*aACPIEnabled != FALSE);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_FIRMWARESETTINGS_GET_ACPIENABLED_RETURN(this, hrc, 1 /*hrc exception*/,*aACPIEnabled != FALSE);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_FIRMWARESETTINGS_GET_ACPIENABLED_RETURN(this, hrc, 9 /*unhandled exception*/,*aACPIEnabled != FALSE);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aACPIEnabled=%RTbool hrc=%Rhrc\n", this, "FirmwareSettings::getACPIEnabled", *aACPIEnabled, hrc));
    return hrc;
}

STDMETHODIMP FirmwareSettingsWrap::COMSETTER(ACPIEnabled)(BOOL aACPIEnabled)
{
    LogRelFlow(("{%p} %s: enter aACPIEnabled=%RTbool\n", this, "FirmwareSettings::setACPIEnabled", aACPIEnabled));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_FIRMWARESETTINGS_SET_ACPIENABLED_ENTER(this, aACPIEnabled != FALSE);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = setACPIEnabled(aACPIEnabled != FALSE);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_FIRMWARESETTINGS_SET_ACPIENABLED_RETURN(this, hrc, 0 /*normal*/,aACPIEnabled != FALSE);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_FIRMWARESETTINGS_SET_ACPIENABLED_RETURN(this, hrc, 1 /*hrc exception*/,aACPIEnabled != FALSE);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_FIRMWARESETTINGS_SET_ACPIENABLED_RETURN(this, hrc, 9 /*unhandled exception*/,aACPIEnabled != FALSE);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "FirmwareSettings::setACPIEnabled", hrc));
    return hrc;
}

STDMETHODIMP FirmwareSettingsWrap::COMGETTER(IOAPICEnabled)(BOOL *aIOAPICEnabled)
{
    LogRelFlow(("{%p} %s: enter aIOAPICEnabled=%p\n", this, "FirmwareSettings::getIOAPICEnabled", aIOAPICEnabled));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aIOAPICEnabled);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_FIRMWARESETTINGS_GET_IOAPICENABLED_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getIOAPICEnabled(aIOAPICEnabled);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_FIRMWARESETTINGS_GET_IOAPICENABLED_RETURN(this, hrc, 0 /*normal*/,*aIOAPICEnabled != FALSE);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_FIRMWARESETTINGS_GET_IOAPICENABLED_RETURN(this, hrc, 1 /*hrc exception*/,*aIOAPICEnabled != FALSE);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_FIRMWARESETTINGS_GET_IOAPICENABLED_RETURN(this, hrc, 9 /*unhandled exception*/,*aIOAPICEnabled != FALSE);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aIOAPICEnabled=%RTbool hrc=%Rhrc\n", this, "FirmwareSettings::getIOAPICEnabled", *aIOAPICEnabled, hrc));
    return hrc;
}

STDMETHODIMP FirmwareSettingsWrap::COMSETTER(IOAPICEnabled)(BOOL aIOAPICEnabled)
{
    LogRelFlow(("{%p} %s: enter aIOAPICEnabled=%RTbool\n", this, "FirmwareSettings::setIOAPICEnabled", aIOAPICEnabled));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_FIRMWARESETTINGS_SET_IOAPICENABLED_ENTER(this, aIOAPICEnabled != FALSE);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = setIOAPICEnabled(aIOAPICEnabled != FALSE);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_FIRMWARESETTINGS_SET_IOAPICENABLED_RETURN(this, hrc, 0 /*normal*/,aIOAPICEnabled != FALSE);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_FIRMWARESETTINGS_SET_IOAPICENABLED_RETURN(this, hrc, 1 /*hrc exception*/,aIOAPICEnabled != FALSE);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_FIRMWARESETTINGS_SET_IOAPICENABLED_RETURN(this, hrc, 9 /*unhandled exception*/,aIOAPICEnabled != FALSE);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "FirmwareSettings::setIOAPICEnabled", hrc));
    return hrc;
}

STDMETHODIMP FirmwareSettingsWrap::COMGETTER(APICMode)(APICMode_T *aAPICMode)
{
    LogRelFlow(("{%p} %s: enter aAPICMode=%p\n", this, "FirmwareSettings::getAPICMode", aAPICMode));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aAPICMode);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_FIRMWARESETTINGS_GET_APICMODE_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getAPICMode(aAPICMode);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_FIRMWARESETTINGS_GET_APICMODE_RETURN(this, hrc, 0 /*normal*/,*aAPICMode);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_FIRMWARESETTINGS_GET_APICMODE_RETURN(this, hrc, 1 /*hrc exception*/,*aAPICMode);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_FIRMWARESETTINGS_GET_APICMODE_RETURN(this, hrc, 9 /*unhandled exception*/,*aAPICMode);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aAPICMode=%RU32 hrc=%Rhrc\n", this, "FirmwareSettings::getAPICMode", *aAPICMode, hrc));
    return hrc;
}

STDMETHODIMP FirmwareSettingsWrap::COMSETTER(APICMode)(APICMode_T aAPICMode)
{
    LogRelFlow(("{%p} %s: enter aAPICMode=%RU32\n", this, "FirmwareSettings::setAPICMode", aAPICMode));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_FIRMWARESETTINGS_SET_APICMODE_ENTER(this, aAPICMode);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = setAPICMode(aAPICMode);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_FIRMWARESETTINGS_SET_APICMODE_RETURN(this, hrc, 0 /*normal*/,aAPICMode);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_FIRMWARESETTINGS_SET_APICMODE_RETURN(this, hrc, 1 /*hrc exception*/,aAPICMode);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_FIRMWARESETTINGS_SET_APICMODE_RETURN(this, hrc, 9 /*unhandled exception*/,aAPICMode);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "FirmwareSettings::setAPICMode", hrc));
    return hrc;
}

STDMETHODIMP FirmwareSettingsWrap::COMGETTER(TimeOffset)(LONG64 *aTimeOffset)
{
    LogRelFlow(("{%p} %s: enter aTimeOffset=%p\n", this, "FirmwareSettings::getTimeOffset", aTimeOffset));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aTimeOffset);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_FIRMWARESETTINGS_GET_TIMEOFFSET_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getTimeOffset(aTimeOffset);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_FIRMWARESETTINGS_GET_TIMEOFFSET_RETURN(this, hrc, 0 /*normal*/,*aTimeOffset);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_FIRMWARESETTINGS_GET_TIMEOFFSET_RETURN(this, hrc, 1 /*hrc exception*/,*aTimeOffset);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_FIRMWARESETTINGS_GET_TIMEOFFSET_RETURN(this, hrc, 9 /*unhandled exception*/,*aTimeOffset);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aTimeOffset=%RI64 hrc=%Rhrc\n", this, "FirmwareSettings::getTimeOffset", *aTimeOffset, hrc));
    return hrc;
}

STDMETHODIMP FirmwareSettingsWrap::COMSETTER(TimeOffset)(LONG64 aTimeOffset)
{
    LogRelFlow(("{%p} %s: enter aTimeOffset=%RI64\n", this, "FirmwareSettings::setTimeOffset", aTimeOffset));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_FIRMWARESETTINGS_SET_TIMEOFFSET_ENTER(this, aTimeOffset);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = setTimeOffset(aTimeOffset);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_FIRMWARESETTINGS_SET_TIMEOFFSET_RETURN(this, hrc, 0 /*normal*/,aTimeOffset);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_FIRMWARESETTINGS_SET_TIMEOFFSET_RETURN(this, hrc, 1 /*hrc exception*/,aTimeOffset);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_FIRMWARESETTINGS_SET_TIMEOFFSET_RETURN(this, hrc, 9 /*unhandled exception*/,aTimeOffset);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "FirmwareSettings::setTimeOffset", hrc));
    return hrc;
}

STDMETHODIMP FirmwareSettingsWrap::COMGETTER(PXEDebugEnabled)(BOOL *aPXEDebugEnabled)
{
    LogRelFlow(("{%p} %s: enter aPXEDebugEnabled=%p\n", this, "FirmwareSettings::getPXEDebugEnabled", aPXEDebugEnabled));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aPXEDebugEnabled);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_FIRMWARESETTINGS_GET_PXEDEBUGENABLED_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getPXEDebugEnabled(aPXEDebugEnabled);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_FIRMWARESETTINGS_GET_PXEDEBUGENABLED_RETURN(this, hrc, 0 /*normal*/,*aPXEDebugEnabled != FALSE);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_FIRMWARESETTINGS_GET_PXEDEBUGENABLED_RETURN(this, hrc, 1 /*hrc exception*/,*aPXEDebugEnabled != FALSE);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_FIRMWARESETTINGS_GET_PXEDEBUGENABLED_RETURN(this, hrc, 9 /*unhandled exception*/,*aPXEDebugEnabled != FALSE);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aPXEDebugEnabled=%RTbool hrc=%Rhrc\n", this, "FirmwareSettings::getPXEDebugEnabled", *aPXEDebugEnabled, hrc));
    return hrc;
}

STDMETHODIMP FirmwareSettingsWrap::COMSETTER(PXEDebugEnabled)(BOOL aPXEDebugEnabled)
{
    LogRelFlow(("{%p} %s: enter aPXEDebugEnabled=%RTbool\n", this, "FirmwareSettings::setPXEDebugEnabled", aPXEDebugEnabled));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_FIRMWARESETTINGS_SET_PXEDEBUGENABLED_ENTER(this, aPXEDebugEnabled != FALSE);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = setPXEDebugEnabled(aPXEDebugEnabled != FALSE);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_FIRMWARESETTINGS_SET_PXEDEBUGENABLED_RETURN(this, hrc, 0 /*normal*/,aPXEDebugEnabled != FALSE);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_FIRMWARESETTINGS_SET_PXEDEBUGENABLED_RETURN(this, hrc, 1 /*hrc exception*/,aPXEDebugEnabled != FALSE);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_FIRMWARESETTINGS_SET_PXEDEBUGENABLED_RETURN(this, hrc, 9 /*unhandled exception*/,aPXEDebugEnabled != FALSE);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "FirmwareSettings::setPXEDebugEnabled", hrc));
    return hrc;
}

STDMETHODIMP FirmwareSettingsWrap::COMGETTER(SMBIOSUuidLittleEndian)(BOOL *aSMBIOSUuidLittleEndian)
{
    LogRelFlow(("{%p} %s: enter aSMBIOSUuidLittleEndian=%p\n", this, "FirmwareSettings::getSMBIOSUuidLittleEndian", aSMBIOSUuidLittleEndian));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aSMBIOSUuidLittleEndian);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_FIRMWARESETTINGS_GET_SMBIOSUUIDLITTLEENDIAN_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getSMBIOSUuidLittleEndian(aSMBIOSUuidLittleEndian);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_FIRMWARESETTINGS_GET_SMBIOSUUIDLITTLEENDIAN_RETURN(this, hrc, 0 /*normal*/,*aSMBIOSUuidLittleEndian != FALSE);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_FIRMWARESETTINGS_GET_SMBIOSUUIDLITTLEENDIAN_RETURN(this, hrc, 1 /*hrc exception*/,*aSMBIOSUuidLittleEndian != FALSE);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_FIRMWARESETTINGS_GET_SMBIOSUUIDLITTLEENDIAN_RETURN(this, hrc, 9 /*unhandled exception*/,*aSMBIOSUuidLittleEndian != FALSE);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aSMBIOSUuidLittleEndian=%RTbool hrc=%Rhrc\n", this, "FirmwareSettings::getSMBIOSUuidLittleEndian", *aSMBIOSUuidLittleEndian, hrc));
    return hrc;
}

STDMETHODIMP FirmwareSettingsWrap::COMSETTER(SMBIOSUuidLittleEndian)(BOOL aSMBIOSUuidLittleEndian)
{
    LogRelFlow(("{%p} %s: enter aSMBIOSUuidLittleEndian=%RTbool\n", this, "FirmwareSettings::setSMBIOSUuidLittleEndian", aSMBIOSUuidLittleEndian));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_FIRMWARESETTINGS_SET_SMBIOSUUIDLITTLEENDIAN_ENTER(this, aSMBIOSUuidLittleEndian != FALSE);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = setSMBIOSUuidLittleEndian(aSMBIOSUuidLittleEndian != FALSE);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_FIRMWARESETTINGS_SET_SMBIOSUUIDLITTLEENDIAN_RETURN(this, hrc, 0 /*normal*/,aSMBIOSUuidLittleEndian != FALSE);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_FIRMWARESETTINGS_SET_SMBIOSUUIDLITTLEENDIAN_RETURN(this, hrc, 1 /*hrc exception*/,aSMBIOSUuidLittleEndian != FALSE);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_FIRMWARESETTINGS_SET_SMBIOSUUIDLITTLEENDIAN_RETURN(this, hrc, 9 /*unhandled exception*/,aSMBIOSUuidLittleEndian != FALSE);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "FirmwareSettings::setSMBIOSUuidLittleEndian", hrc));
    return hrc;
}

STDMETHODIMP FirmwareSettingsWrap::COMGETTER(AutoSerialNumGen)(BOOL *aAutoSerialNumGen)
{
    LogRelFlow(("{%p} %s: enter aAutoSerialNumGen=%p\n", this, "FirmwareSettings::getAutoSerialNumGen", aAutoSerialNumGen));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aAutoSerialNumGen);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_FIRMWARESETTINGS_GET_AUTOSERIALNUMGEN_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getAutoSerialNumGen(aAutoSerialNumGen);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_FIRMWARESETTINGS_GET_AUTOSERIALNUMGEN_RETURN(this, hrc, 0 /*normal*/,*aAutoSerialNumGen != FALSE);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_FIRMWARESETTINGS_GET_AUTOSERIALNUMGEN_RETURN(this, hrc, 1 /*hrc exception*/,*aAutoSerialNumGen != FALSE);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_FIRMWARESETTINGS_GET_AUTOSERIALNUMGEN_RETURN(this, hrc, 9 /*unhandled exception*/,*aAutoSerialNumGen != FALSE);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aAutoSerialNumGen=%RTbool hrc=%Rhrc\n", this, "FirmwareSettings::getAutoSerialNumGen", *aAutoSerialNumGen, hrc));
    return hrc;
}

STDMETHODIMP FirmwareSettingsWrap::COMSETTER(AutoSerialNumGen)(BOOL aAutoSerialNumGen)
{
    LogRelFlow(("{%p} %s: enter aAutoSerialNumGen=%RTbool\n", this, "FirmwareSettings::setAutoSerialNumGen", aAutoSerialNumGen));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_FIRMWARESETTINGS_SET_AUTOSERIALNUMGEN_ENTER(this, aAutoSerialNumGen != FALSE);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = setAutoSerialNumGen(aAutoSerialNumGen != FALSE);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_FIRMWARESETTINGS_SET_AUTOSERIALNUMGEN_RETURN(this, hrc, 0 /*normal*/,aAutoSerialNumGen != FALSE);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_FIRMWARESETTINGS_SET_AUTOSERIALNUMGEN_RETURN(this, hrc, 1 /*hrc exception*/,aAutoSerialNumGen != FALSE);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_FIRMWARESETTINGS_SET_AUTOSERIALNUMGEN_RETURN(this, hrc, 9 /*unhandled exception*/,aAutoSerialNumGen != FALSE);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "FirmwareSettings::setAutoSerialNumGen", hrc));
    return hrc;
}

STDMETHODIMP FirmwareSettingsWrap::COMGETTER(InternalAndReservedAttribute1IFirmwareSettings)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP FirmwareSettingsWrap::COMGETTER(InternalAndReservedAttribute2IFirmwareSettings)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP FirmwareSettingsWrap::COMGETTER(InternalAndReservedAttribute3IFirmwareSettings)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP FirmwareSettingsWrap::COMGETTER(InternalAndReservedAttribute4IFirmwareSettings)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP FirmwareSettingsWrap::COMGETTER(InternalAndReservedAttribute5IFirmwareSettings)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP FirmwareSettingsWrap::COMGETTER(InternalAndReservedAttribute6IFirmwareSettings)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP FirmwareSettingsWrap::COMGETTER(InternalAndReservedAttribute7IFirmwareSettings)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP FirmwareSettingsWrap::COMGETTER(InternalAndReservedAttribute8IFirmwareSettings)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}


//
// IFirmwareSettings methods
//

STDMETHODIMP FirmwareSettingsWrap::InternalAndReservedMethod1IFirmwareSettings()
{
    return E_NOTIMPL;
}

STDMETHODIMP FirmwareSettingsWrap::InternalAndReservedMethod2IFirmwareSettings()
{
    return E_NOTIMPL;
}

#ifdef VBOX_WITH_XPCOM
NS_DECL_CLASSINFO(FirmwareSettingsWrap)
NS_IMPL_THREADSAFE_ISUPPORTS1_CI(FirmwareSettingsWrap, IFirmwareSettings)
#endif // VBOX_WITH_XPCOM
