/* VpnMenuItem.c generated by valac 0.56.17, the Vala compiler
 * generated from VpnMenuItem.vala, do not modify */

/*
* SPDX-License-Identifier: LGPL-2.1-or-later
* SPDX-FileCopyrightText: 2017-2023 elementary, Inc. (https://elementary.io)
*/

#include "network.h"
#include <NetworkManager.h>
#include <gtk/gtk.h>
#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <pango/pango.h>
#include <granite.h>
#include <gdk/gdk.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	NETWORK_VPN_MENU_ITEM_0_PROPERTY,
	NETWORK_VPN_MENU_ITEM_REMOTE_CONNECTION_PROPERTY,
	NETWORK_VPN_MENU_ITEM_VPN_CONNECTION_PROPERTY,
	NETWORK_VPN_MENU_ITEM_NUM_PROPERTIES
};
static GParamSpec* network_vpn_menu_item_properties[NETWORK_VPN_MENU_ITEM_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _Block6Data Block6Data;

struct _NetworkVpnMenuItemPrivate {
	NMRemoteConnection* _remote_connection;
	NMActiveConnection* _vpn_connection;
	GtkToggleButton* toggle_button;
};

struct _Block6Data {
	int _ref_count_;
	NetworkVpnMenuItem* self;
	GtkLabel* label;
};

static gint NetworkVpnMenuItem_private_offset;
static gpointer network_vpn_menu_item_parent_class = NULL;
static GtkCssProvider* network_vpn_menu_item_provider;
static GtkCssProvider* network_vpn_menu_item_provider = NULL;

static void network_vpn_menu_item_update_state (NetworkVpnMenuItem* self);
static void _network_vpn_menu_item_update_state_nm_vpn_connection_vpn_state_changed (NMVpnConnection* _sender,
                                                                              guint object,
                                                                              guint p0,
                                                                              gpointer self);
static void _network_vpn_menu_item_update_state_nm_active_connection_state_changed (NMActiveConnection* _sender,
                                                                             guint state,
                                                                             guint reason,
                                                                             gpointer self);
static GObject * network_vpn_menu_item_constructor (GType type,
                                             guint n_construct_properties,
                                             GObjectConstructParam * construct_properties);
static Block6Data* block6_data_ref (Block6Data* _data6_);
static void block6_data_unref (void * _userdata_);
static gboolean _network_vpn_menu_item___lambda23_ (NetworkVpnMenuItem* self,
                                             GtkWidget* b,
                                             GdkEventButton* ev);
static gboolean __network_vpn_menu_item___lambda23__gtk_widget_button_release_event (GtkWidget* _sender,
                                                                              GdkEventButton* event,
                                                                              gpointer self);
static void _network_vpn_menu_item___lambda24_ (Block6Data* _data6_);
static void __network_vpn_menu_item___lambda24__nm_connection_changed (NMConnection* _sender,
                                                                gpointer self);
static void network_vpn_menu_item_finalize (GObject * obj);
static GType network_vpn_menu_item_get_type_once (void);
static void _vala_network_vpn_menu_item_get_property (GObject * object,
                                               guint property_id,
                                               GValue * value,
                                               GParamSpec * pspec);
static void _vala_network_vpn_menu_item_set_property (GObject * object,
                                               guint property_id,
                                               const GValue * value,
                                               GParamSpec * pspec);

static inline gpointer
network_vpn_menu_item_get_instance_private (NetworkVpnMenuItem* self)
{
	return G_STRUCT_MEMBER_P (self, NetworkVpnMenuItem_private_offset);
}

NetworkVpnMenuItem*
network_vpn_menu_item_construct (GType object_type,
                                 NMRemoteConnection* remote_connection)
{
	NetworkVpnMenuItem * self = NULL;
	g_return_val_if_fail (remote_connection != NULL, NULL);
	self = (NetworkVpnMenuItem*) g_object_new (object_type, "remote-connection", remote_connection, NULL);
	return self;
}

NetworkVpnMenuItem*
network_vpn_menu_item_new (NMRemoteConnection* remote_connection)
{
	return network_vpn_menu_item_construct (NETWORK_TYPE_VPN_MENU_ITEM, remote_connection);
}

static void
network_vpn_menu_item_update_state (NetworkVpnMenuItem* self)
{
	NMActiveConnection* _tmp0_;
	const gchar* connection_type = NULL;
	NMActiveConnection* _tmp5_;
	const gchar* _tmp6_;
	const gchar* _tmp7_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_vpn_connection;
	if (_tmp0_ == NULL) {
		GtkToggleButton* _tmp1_;
		GtkWidget* _tmp2_;
		GtkWidget* _tmp3_;
		GtkToggleButton* _tmp4_;
		_tmp1_ = self->priv->toggle_button;
		_tmp2_ = gtk_button_get_image ((GtkButton*) _tmp1_);
		_tmp3_ = _tmp2_;
		g_object_set (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, gtk_image_get_type (), GtkImage), "icon-name", "panel-network-vpn-disconnected-symbolic", NULL);
		_tmp4_ = self->priv->toggle_button;
		gtk_toggle_button_set_active (_tmp4_, FALSE);
		return;
	}
	_tmp5_ = self->priv->_vpn_connection;
	_tmp6_ = nm_active_connection_get_connection_type (_tmp5_);
	connection_type = _tmp6_;
	_tmp7_ = connection_type;
	if (g_strcmp0 (_tmp7_, NM_SETTING_VPN_SETTING_NAME) == 0) {
		NMActiveConnection* _tmp8_;
		NMVpnConnectionState _tmp9_;
		NMVpnConnectionState _tmp10_;
		_tmp8_ = self->priv->_vpn_connection;
		_tmp9_ = nm_vpn_connection_get_vpn_state (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, nm_vpn_connection_get_type (), NMVpnConnection));
		_tmp10_ = _tmp9_;
		switch (_tmp10_) {
			case NM_VPN_CONNECTION_STATE_CONNECT:
			case NM_VPN_CONNECTION_STATE_IP_CONFIG_GET:
			case NM_VPN_CONNECTION_STATE_NEED_AUTH:
			case NM_VPN_CONNECTION_STATE_PREPARE:
			{
				GtkToggleButton* _tmp11_;
				GtkWidget* _tmp12_;
				GtkWidget* _tmp13_;
				_tmp11_ = self->priv->toggle_button;
				_tmp12_ = gtk_button_get_image ((GtkButton*) _tmp11_);
				_tmp13_ = _tmp12_;
				g_object_set (G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, gtk_image_get_type (), GtkImage), "icon-name", "panel-network-vpn-acquiring-symbolic", NULL);
				break;
			}
			case NM_VPN_CONNECTION_STATE_ACTIVATED:
			{
				GtkToggleButton* _tmp14_;
				GtkWidget* _tmp15_;
				GtkWidget* _tmp16_;
				GtkToggleButton* _tmp17_;
				_tmp14_ = self->priv->toggle_button;
				_tmp15_ = gtk_button_get_image ((GtkButton*) _tmp14_);
				_tmp16_ = _tmp15_;
				g_object_set (G_TYPE_CHECK_INSTANCE_CAST (_tmp16_, gtk_image_get_type (), GtkImage), "icon-name", "panel-network-vpn-connected-symbolic", NULL);
				_tmp17_ = self->priv->toggle_button;
				gtk_toggle_button_set_active (_tmp17_, TRUE);
				break;
			}
			case NM_VPN_CONNECTION_STATE_DISCONNECTED:
			{
				GtkToggleButton* _tmp18_;
				GtkWidget* _tmp19_;
				GtkWidget* _tmp20_;
				GtkToggleButton* _tmp21_;
				_tmp18_ = self->priv->toggle_button;
				_tmp19_ = gtk_button_get_image ((GtkButton*) _tmp18_);
				_tmp20_ = _tmp19_;
				g_object_set (G_TYPE_CHECK_INSTANCE_CAST (_tmp20_, gtk_image_get_type (), GtkImage), "icon-name", "panel-network-vpn-disconnected-symbolic", NULL);
				_tmp21_ = self->priv->toggle_button;
				gtk_toggle_button_set_active (_tmp21_, FALSE);
				break;
			}
			case NM_VPN_CONNECTION_STATE_FAILED:
			case NM_VPN_CONNECTION_STATE_UNKNOWN:
			{
				GtkToggleButton* _tmp22_;
				GtkWidget* _tmp23_;
				GtkWidget* _tmp24_;
				GtkToggleButton* _tmp25_;
				_tmp22_ = self->priv->toggle_button;
				_tmp23_ = gtk_button_get_image ((GtkButton*) _tmp22_);
				_tmp24_ = _tmp23_;
				g_object_set (G_TYPE_CHECK_INSTANCE_CAST (_tmp24_, gtk_image_get_type (), GtkImage), "icon-name", "panel-network-vpn-error-symbolic", NULL);
				_tmp25_ = self->priv->toggle_button;
				gtk_toggle_button_set_active (_tmp25_, FALSE);
				break;
			}
			default:
			break;
		}
	} else {
		const gchar* _tmp26_;
		_tmp26_ = connection_type;
		if (g_strcmp0 (_tmp26_, NM_SETTING_WIREGUARD_SETTING_NAME) == 0) {
			NMActiveConnection* _tmp27_;
			_tmp27_ = self->priv->_vpn_connection;
			switch (nm_active_connection_get_state (_tmp27_)) {
				case NM_ACTIVE_CONNECTION_STATE_UNKNOWN:
				{
					GtkToggleButton* _tmp28_;
					GtkWidget* _tmp29_;
					GtkWidget* _tmp30_;
					GtkToggleButton* _tmp31_;
					_tmp28_ = self->priv->toggle_button;
					_tmp29_ = gtk_button_get_image ((GtkButton*) _tmp28_);
					_tmp30_ = _tmp29_;
					g_object_set (G_TYPE_CHECK_INSTANCE_CAST (_tmp30_, gtk_image_get_type (), GtkImage), "icon-name", "panel-network-vpn-error-symbolic", NULL);
					_tmp31_ = self->priv->toggle_button;
					gtk_toggle_button_set_active (_tmp31_, FALSE);
					break;
				}
				case NM_ACTIVE_CONNECTION_STATE_DEACTIVATED:
				case NM_ACTIVE_CONNECTION_STATE_DEACTIVATING:
				{
					GtkToggleButton* _tmp32_;
					GtkWidget* _tmp33_;
					GtkWidget* _tmp34_;
					GtkToggleButton* _tmp35_;
					_tmp32_ = self->priv->toggle_button;
					_tmp33_ = gtk_button_get_image ((GtkButton*) _tmp32_);
					_tmp34_ = _tmp33_;
					g_object_set (G_TYPE_CHECK_INSTANCE_CAST (_tmp34_, gtk_image_get_type (), GtkImage), "icon-name", "panel-network-vpn-disconnected-symbolic", NULL);
					_tmp35_ = self->priv->toggle_button;
					gtk_toggle_button_set_active (_tmp35_, FALSE);
					break;
				}
				case NM_ACTIVE_CONNECTION_STATE_ACTIVATING:
				{
					GtkToggleButton* _tmp36_;
					GtkWidget* _tmp37_;
					GtkWidget* _tmp38_;
					_tmp36_ = self->priv->toggle_button;
					_tmp37_ = gtk_button_get_image ((GtkButton*) _tmp36_);
					_tmp38_ = _tmp37_;
					g_object_set (G_TYPE_CHECK_INSTANCE_CAST (_tmp38_, gtk_image_get_type (), GtkImage), "icon-name", "panel-network-vpn-acquiring-symbolic", NULL);
					break;
				}
				case NM_ACTIVE_CONNECTION_STATE_ACTIVATED:
				{
					GtkToggleButton* _tmp39_;
					GtkWidget* _tmp40_;
					GtkWidget* _tmp41_;
					GtkToggleButton* _tmp42_;
					_tmp39_ = self->priv->toggle_button;
					_tmp40_ = gtk_button_get_image ((GtkButton*) _tmp39_);
					_tmp41_ = _tmp40_;
					g_object_set (G_TYPE_CHECK_INSTANCE_CAST (_tmp41_, gtk_image_get_type (), GtkImage), "icon-name", "panel-network-vpn-connected-symbolic", NULL);
					_tmp42_ = self->priv->toggle_button;
					gtk_toggle_button_set_active (_tmp42_, TRUE);
					break;
				}
				default:
				break;
			}
		}
	}
}

NMRemoteConnection*
network_vpn_menu_item_get_remote_connection (NetworkVpnMenuItem* self)
{
	NMRemoteConnection* result;
	NMRemoteConnection* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_remote_connection;
	result = _tmp0_;
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
network_vpn_menu_item_set_remote_connection (NetworkVpnMenuItem* self,
                                             NMRemoteConnection* value)
{
	NMRemoteConnection* old_value;
	g_return_if_fail (self != NULL);
	old_value = network_vpn_menu_item_get_remote_connection (self);
	if (old_value != value) {
		NMRemoteConnection* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_remote_connection);
		self->priv->_remote_connection = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, network_vpn_menu_item_properties[NETWORK_VPN_MENU_ITEM_REMOTE_CONNECTION_PROPERTY]);
	}
}

NMActiveConnection*
network_vpn_menu_item_get_vpn_connection (NetworkVpnMenuItem* self)
{
	NMActiveConnection* result;
	NMActiveConnection* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_vpn_connection;
	result = _tmp0_;
	return result;
}

static void
_network_vpn_menu_item_update_state_nm_vpn_connection_vpn_state_changed (NMVpnConnection* _sender,
                                                                         guint object,
                                                                         guint p0,
                                                                         gpointer self)
{
	network_vpn_menu_item_update_state ((NetworkVpnMenuItem*) self);
}

static void
_network_vpn_menu_item_update_state_nm_active_connection_state_changed (NMActiveConnection* _sender,
                                                                        guint state,
                                                                        guint reason,
                                                                        gpointer self)
{
	network_vpn_menu_item_update_state ((NetworkVpnMenuItem*) self);
}

void
network_vpn_menu_item_set_vpn_connection (NetworkVpnMenuItem* self,
                                          NMActiveConnection* value)
{
	NMActiveConnection* _tmp3_;
	GtkToggleButton* _tmp9_;
	GtkWidget* _tmp10_;
	GtkWidget* _tmp11_;
	GtkToggleButton* _tmp12_;
	g_return_if_fail (self != NULL);
	if (value != NULL) {
		NMActiveConnection* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_vpn_connection);
		self->priv->_vpn_connection = _tmp0_;
		if (nm_active_connection_get_vpn (value)) {
			NMActiveConnection* _tmp1_;
			_tmp1_ = self->priv->_vpn_connection;
			g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, nm_vpn_connection_get_type (), NMVpnConnection), "vpn-state-changed", (GCallback) _network_vpn_menu_item_update_state_nm_vpn_connection_vpn_state_changed, self, 0);
		} else {
			NMActiveConnection* _tmp2_;
			_tmp2_ = self->priv->_vpn_connection;
			g_signal_connect_object (_tmp2_, "state-changed", (GCallback) _network_vpn_menu_item_update_state_nm_active_connection_state_changed, self, 0);
		}
		network_vpn_menu_item_update_state (self);
		return;
	}
	_tmp3_ = self->priv->_vpn_connection;
	if (_tmp3_ != NULL) {
		NMActiveConnection* _tmp4_;
		_tmp4_ = self->priv->_vpn_connection;
		if (nm_active_connection_get_vpn (_tmp4_)) {
			NMActiveConnection* _tmp5_;
			guint _tmp6_;
			_tmp5_ = self->priv->_vpn_connection;
			g_signal_parse_name ("vpn-state-changed", nm_vpn_connection_get_type (), &_tmp6_, NULL, FALSE);
			g_signal_handlers_disconnect_matched (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, nm_vpn_connection_get_type (), NMVpnConnection), G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp6_, 0, NULL, (GCallback) _network_vpn_menu_item_update_state_nm_vpn_connection_vpn_state_changed, self);
		} else {
			NMActiveConnection* _tmp7_;
			guint _tmp8_;
			_tmp7_ = self->priv->_vpn_connection;
			g_signal_parse_name ("state-changed", nm_active_connection_get_type (), &_tmp8_, NULL, FALSE);
			g_signal_handlers_disconnect_matched (_tmp7_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp8_, 0, NULL, (GCallback) _network_vpn_menu_item_update_state_nm_active_connection_state_changed, self);
		}
		_g_object_unref0 (self->priv->_vpn_connection);
		self->priv->_vpn_connection = NULL;
	}
	_tmp9_ = self->priv->toggle_button;
	_tmp10_ = gtk_button_get_image ((GtkButton*) _tmp9_);
	_tmp11_ = _tmp10_;
	g_object_set (G_TYPE_CHECK_INSTANCE_CAST (_tmp11_, gtk_image_get_type (), GtkImage), "icon-name", "panel-network-vpn-disconnected-symbolic", NULL);
	_tmp12_ = self->priv->toggle_button;
	gtk_toggle_button_set_active (_tmp12_, FALSE);
	g_object_notify_by_pspec ((GObject *) self, network_vpn_menu_item_properties[NETWORK_VPN_MENU_ITEM_VPN_CONNECTION_PROPERTY]);
}

static Block6Data*
block6_data_ref (Block6Data* _data6_)
{
	g_atomic_int_inc (&_data6_->_ref_count_);
	return _data6_;
}

static void
block6_data_unref (void * _userdata_)
{
	Block6Data* _data6_;
	_data6_ = (Block6Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data6_->_ref_count_)) {
		NetworkVpnMenuItem* self;
		self = _data6_->self;
		_g_object_unref0 (_data6_->label);
		_g_object_unref0 (self);
		g_slice_free (Block6Data, _data6_);
	}
}

static gboolean
_network_vpn_menu_item___lambda23_ (NetworkVpnMenuItem* self,
                                    GtkWidget* b,
                                    GdkEventButton* ev)
{
	gboolean result;
	g_return_val_if_fail (b != NULL, FALSE);
	g_return_val_if_fail (ev != NULL, FALSE);
	g_signal_emit_by_name ((GtkFlowBoxChild*) self, "activate");
	result = GDK_EVENT_STOP;
	return result;
}

static gboolean
__network_vpn_menu_item___lambda23__gtk_widget_button_release_event (GtkWidget* _sender,
                                                                     GdkEventButton* event,
                                                                     gpointer self)
{
	gboolean result;
	result = _network_vpn_menu_item___lambda23_ ((NetworkVpnMenuItem*) self, _sender, event);
	return result;
}

static void
_network_vpn_menu_item___lambda24_ (Block6Data* _data6_)
{
	NetworkVpnMenuItem* self;
	GtkLabel* _tmp0_;
	NMRemoteConnection* _tmp1_;
	const gchar* _tmp2_;
	self = _data6_->self;
	_tmp0_ = _data6_->label;
	_tmp1_ = self->priv->_remote_connection;
	_tmp2_ = nm_connection_get_id ((NMConnection*) _tmp1_);
	gtk_label_set_label (_tmp0_, _tmp2_);
}

static void
__network_vpn_menu_item___lambda24__nm_connection_changed (NMConnection* _sender,
                                                           gpointer self)
{
	_network_vpn_menu_item___lambda24_ (self);
}

static GObject *
network_vpn_menu_item_constructor (GType type,
                                   guint n_construct_properties,
                                   GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	NetworkVpnMenuItem * self;
	Block6Data* _data6_;
	GtkImage* _tmp0_;
	GtkToggleButton* _tmp1_ = NULL;
	GtkToggleButton* _tmp2_;
	GtkStyleContext* _tmp3_;
	GtkToggleButton* _tmp4_;
	GtkStyleContext* _tmp5_;
	GtkCssProvider* _tmp6_;
	NMRemoteConnection* _tmp7_;
	const gchar* _tmp8_;
	GtkLabel* _tmp9_ = NULL;
	GtkLabel* _tmp10_;
	GtkStyleContext* _tmp11_;
	GtkBox* box = NULL;
	GtkBox* _tmp12_ = NULL;
	GtkBox* _tmp13_;
	GtkToggleButton* _tmp14_;
	GtkBox* _tmp15_;
	GtkLabel* _tmp16_;
	GtkBox* _tmp17_;
	GtkToggleButton* _tmp18_;
	NMRemoteConnection* _tmp19_;
	parent_class = G_OBJECT_CLASS (network_vpn_menu_item_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, NETWORK_TYPE_VPN_MENU_ITEM, NetworkVpnMenuItem);
	_data6_ = g_slice_new0 (Block6Data);
	_data6_->_ref_count_ = 1;
	_data6_->self = g_object_ref (self);
	_tmp0_ = (GtkImage*) gtk_image_new_from_icon_name ("panel-network-vpn-disconnected-symbolic", (GtkIconSize) GTK_ICON_SIZE_MENU);
	g_object_ref_sink (_tmp0_);
	_tmp1_ = (GtkToggleButton*) gtk_toggle_button_new ();
	gtk_widget_set_halign ((GtkWidget*) _tmp1_, GTK_ALIGN_CENTER);
	gtk_button_set_image ((GtkButton*) _tmp1_, (GtkWidget*) _tmp0_);
	_g_object_unref0 (_tmp0_);
	g_object_ref_sink (_tmp1_);
	_g_object_unref0 (self->priv->toggle_button);
	self->priv->toggle_button = _tmp1_;
	_tmp2_ = self->priv->toggle_button;
	_tmp3_ = gtk_widget_get_style_context ((GtkWidget*) _tmp2_);
	gtk_style_context_add_class (_tmp3_, "circular");
	_tmp4_ = self->priv->toggle_button;
	_tmp5_ = gtk_widget_get_style_context ((GtkWidget*) _tmp4_);
	_tmp6_ = network_vpn_menu_item_provider;
	gtk_style_context_add_provider (_tmp5_, (GtkStyleProvider*) _tmp6_, (guint) GTK_STYLE_PROVIDER_PRIORITY_APPLICATION);
	_tmp7_ = self->priv->_remote_connection;
	_tmp8_ = nm_connection_get_id ((NMConnection*) _tmp7_);
	_tmp9_ = (GtkLabel*) gtk_label_new (_tmp8_);
	gtk_label_set_ellipsize (_tmp9_, PANGO_ELLIPSIZE_MIDDLE);
	gtk_label_set_max_width_chars (_tmp9_, 16);
	g_object_ref_sink (_tmp9_);
	_data6_->label = _tmp9_;
	_tmp10_ = _data6_->label;
	_tmp11_ = gtk_widget_get_style_context ((GtkWidget*) _tmp10_);
	gtk_style_context_add_class (_tmp11_, GRANITE_STYLE_CLASS_SMALL_LABEL);
	_tmp12_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 3);
	gtk_widget_set_hexpand ((GtkWidget*) _tmp12_, TRUE);
	g_object_ref_sink (_tmp12_);
	box = _tmp12_;
	_tmp13_ = box;
	_tmp14_ = self->priv->toggle_button;
	gtk_container_add ((GtkContainer*) _tmp13_, (GtkWidget*) _tmp14_);
	_tmp15_ = box;
	_tmp16_ = _data6_->label;
	gtk_container_add ((GtkContainer*) _tmp15_, (GtkWidget*) _tmp16_);
	gtk_widget_set_can_focus ((GtkWidget*) self, FALSE);
	_tmp17_ = box;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp17_);
	_tmp18_ = self->priv->toggle_button;
	g_signal_connect_object ((GtkWidget*) _tmp18_, "button-release-event", (GCallback) __network_vpn_menu_item___lambda23__gtk_widget_button_release_event, self, 0);
	_tmp19_ = self->priv->_remote_connection;
	g_signal_connect_data ((NMConnection*) _tmp19_, "changed", (GCallback) __network_vpn_menu_item___lambda24__nm_connection_changed, block6_data_ref (_data6_), (GClosureNotify) block6_data_unref, 0);
	_g_object_unref0 (box);
	block6_data_unref (_data6_);
	_data6_ = NULL;
	return obj;
}

static void
network_vpn_menu_item_class_init (NetworkVpnMenuItemClass * klass,
                                  gpointer klass_data)
{
	GtkCssProvider* _tmp0_;
	GtkCssProvider* _tmp1_;
	network_vpn_menu_item_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &NetworkVpnMenuItem_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_network_vpn_menu_item_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_network_vpn_menu_item_set_property;
	G_OBJECT_CLASS (klass)->constructor = network_vpn_menu_item_constructor;
	G_OBJECT_CLASS (klass)->finalize = network_vpn_menu_item_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), NETWORK_VPN_MENU_ITEM_REMOTE_CONNECTION_PROPERTY, network_vpn_menu_item_properties[NETWORK_VPN_MENU_ITEM_REMOTE_CONNECTION_PROPERTY] = g_param_spec_object ("remote-connection", "remote-connection", "remote-connection", nm_remote_connection_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), NETWORK_VPN_MENU_ITEM_VPN_CONNECTION_PROPERTY, network_vpn_menu_item_properties[NETWORK_VPN_MENU_ITEM_VPN_CONNECTION_PROPERTY] = g_param_spec_object ("vpn-connection", "vpn-connection", "vpn-connection", nm_active_connection_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	_tmp0_ = gtk_css_provider_new ();
	_g_object_unref0 (network_vpn_menu_item_provider);
	network_vpn_menu_item_provider = _tmp0_;
	_tmp1_ = network_vpn_menu_item_provider;
	gtk_css_provider_load_from_resource (_tmp1_, "io/elementary/wingpanel/network/Indicator.css");
}

static void
network_vpn_menu_item_instance_init (NetworkVpnMenuItem * self,
                                     gpointer klass)
{
	self->priv = network_vpn_menu_item_get_instance_private (self);
	self->cancellable = NULL;
	self->priv->_vpn_connection = NULL;
}

static void
network_vpn_menu_item_finalize (GObject * obj)
{
	NetworkVpnMenuItem * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, NETWORK_TYPE_VPN_MENU_ITEM, NetworkVpnMenuItem);
	_g_object_unref0 (self->priv->_remote_connection);
	_g_object_unref0 (self->cancellable);
	_g_object_unref0 (self->priv->_vpn_connection);
	_g_object_unref0 (self->priv->toggle_button);
	G_OBJECT_CLASS (network_vpn_menu_item_parent_class)->finalize (obj);
}

static GType
network_vpn_menu_item_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (NetworkVpnMenuItemClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) network_vpn_menu_item_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (NetworkVpnMenuItem), 0, (GInstanceInitFunc) network_vpn_menu_item_instance_init, NULL };
	GType network_vpn_menu_item_type_id;
	network_vpn_menu_item_type_id = g_type_register_static (gtk_flow_box_child_get_type (), "NetworkVpnMenuItem", &g_define_type_info, 0);
	NetworkVpnMenuItem_private_offset = g_type_add_instance_private (network_vpn_menu_item_type_id, sizeof (NetworkVpnMenuItemPrivate));
	return network_vpn_menu_item_type_id;
}

GType
network_vpn_menu_item_get_type (void)
{
	static volatile gsize network_vpn_menu_item_type_id__once = 0;
	if (g_once_init_enter (&network_vpn_menu_item_type_id__once)) {
		GType network_vpn_menu_item_type_id;
		network_vpn_menu_item_type_id = network_vpn_menu_item_get_type_once ();
		g_once_init_leave (&network_vpn_menu_item_type_id__once, network_vpn_menu_item_type_id);
	}
	return network_vpn_menu_item_type_id__once;
}

static void
_vala_network_vpn_menu_item_get_property (GObject * object,
                                          guint property_id,
                                          GValue * value,
                                          GParamSpec * pspec)
{
	NetworkVpnMenuItem * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, NETWORK_TYPE_VPN_MENU_ITEM, NetworkVpnMenuItem);
	switch (property_id) {
		case NETWORK_VPN_MENU_ITEM_REMOTE_CONNECTION_PROPERTY:
		g_value_set_object (value, network_vpn_menu_item_get_remote_connection (self));
		break;
		case NETWORK_VPN_MENU_ITEM_VPN_CONNECTION_PROPERTY:
		g_value_set_object (value, network_vpn_menu_item_get_vpn_connection (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_network_vpn_menu_item_set_property (GObject * object,
                                          guint property_id,
                                          const GValue * value,
                                          GParamSpec * pspec)
{
	NetworkVpnMenuItem * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, NETWORK_TYPE_VPN_MENU_ITEM, NetworkVpnMenuItem);
	switch (property_id) {
		case NETWORK_VPN_MENU_ITEM_REMOTE_CONNECTION_PROPERTY:
		network_vpn_menu_item_set_remote_connection (self, g_value_get_object (value));
		break;
		case NETWORK_VPN_MENU_ITEM_VPN_CONNECTION_PROPERTY:
		network_vpn_menu_item_set_vpn_connection (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

