/* PopoverWidget.c generated by valac 0.56.18, the Vala compiler
 * generated from PopoverWidget.vala, do not modify */

/*
 * SPDX-License-Identifier: GPL-2.0-or-later
 * SPDX-FileCopyrightText: 2017-2023 elementary, Inc. (https://elementary.io)
 */

#include "nightlight.h"
#include <gio/gio.h>
#include <granite.h>
#include <gtk/gtk.h>
#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <wingpanel.h>
#include <glib/gi18n-lib.h>
#include <float.h>
#include <math.h>

#define NIGHTLIGHT_WIDGETS_POPOVER_WIDGET_TEMP_CHANGE_DELAY_MS 300
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	NIGHTLIGHT_WIDGETS_POPOVER_WIDGET_0_PROPERTY,
	NIGHTLIGHT_WIDGETS_POPOVER_WIDGET_INDICATOR_PROPERTY,
	NIGHTLIGHT_WIDGETS_POPOVER_WIDGET_SETTINGS_PROPERTY,
	NIGHTLIGHT_WIDGETS_POPOVER_WIDGET_AUTOMATIC_SCHEDULE_PROPERTY,
	NIGHTLIGHT_WIDGETS_POPOVER_WIDGET_SNOOZED_PROPERTY,
	NIGHTLIGHT_WIDGETS_POPOVER_WIDGET_TEMPERATURE_PROPERTY,
	NIGHTLIGHT_WIDGETS_POPOVER_WIDGET_NUM_PROPERTIES
};
static GParamSpec* nightlight_widgets_popover_widget_properties[NIGHTLIGHT_WIDGETS_POPOVER_WIDGET_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

struct _NightlightWidgetsPopoverWidgetPrivate {
	NightlightIndicator* _indicator;
	GSettings* _settings;
	GraniteSwitchModelButton* toggle_switch;
	GtkBox* scale_box;
	GtkImage* image;
	GtkScale* temp_scale;
	guint temp_change_timeout_id;
};

static gint NightlightWidgetsPopoverWidget_private_offset;
static gpointer nightlight_widgets_popover_widget_parent_class = NULL;

static void nightlight_widgets_popover_widget_schedule_temp_change (NightlightWidgetsPopoverWidget* self);
static gboolean __lambda4_ (NightlightWidgetsPopoverWidget* self);
static gboolean ___lambda4__gsource_func (gpointer self);
static void nightlight_widgets_popover_widget_show_settings (NightlightWidgetsPopoverWidget* self);
static GObject * nightlight_widgets_popover_widget_constructor (GType type,
                                                         guint n_construct_properties,
                                                         GObjectConstructParam * construct_properties);
static void _nightlight_widgets_popover_widget_show_settings_gtk_button_clicked (GtkButton* _sender,
                                                                          gpointer self);
static void _nightlight_widgets_popover_widget___lambda6_ (NightlightWidgetsPopoverWidget* self);
static void __nightlight_widgets_popover_widget___lambda6__gtk_range_value_changed (GtkRange* _sender,
                                                                             gpointer self);
static void nightlight_widgets_popover_widget_finalize (GObject * obj);
static GType nightlight_widgets_popover_widget_get_type_once (void);
static void _vala_nightlight_widgets_popover_widget_get_property (GObject * object,
                                                           guint property_id,
                                                           GValue * value,
                                                           GParamSpec * pspec);
static void _vala_nightlight_widgets_popover_widget_set_property (GObject * object,
                                                           guint property_id,
                                                           const GValue * value,
                                                           GParamSpec * pspec);

static inline gpointer
nightlight_widgets_popover_widget_get_instance_private (NightlightWidgetsPopoverWidget* self)
{
	return G_STRUCT_MEMBER_P (self, NightlightWidgetsPopoverWidget_private_offset);
}

NightlightWidgetsPopoverWidget*
nightlight_widgets_popover_widget_construct (GType object_type,
                                             NightlightIndicator* indicator,
                                             GSettings* settings)
{
	NightlightWidgetsPopoverWidget * self = NULL;
	g_return_val_if_fail (indicator != NULL, NULL);
	g_return_val_if_fail (settings != NULL, NULL);
	self = (NightlightWidgetsPopoverWidget*) g_object_new (object_type, "indicator", indicator, "settings", settings, NULL);
	return self;
}

NightlightWidgetsPopoverWidget*
nightlight_widgets_popover_widget_new (NightlightIndicator* indicator,
                                       GSettings* settings)
{
	return nightlight_widgets_popover_widget_construct (NIGHTLIGHT_WIDGETS_TYPE_POPOVER_WIDGET, indicator, settings);
}

static gboolean
__lambda4_ (NightlightWidgetsPopoverWidget* self)
{
	GSettings* _tmp0_;
	GtkScale* _tmp1_;
	gboolean result;
	_tmp0_ = self->priv->_settings;
	_tmp1_ = self->priv->temp_scale;
	g_settings_set_uint (_tmp0_, "night-light-temperature", (guint) gtk_range_get_value ((GtkRange*) _tmp1_));
	self->priv->temp_change_timeout_id = (guint) 0;
	result = FALSE;
	return result;
}

static gboolean
___lambda4__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda4_ ((NightlightWidgetsPopoverWidget*) self);
	return result;
}

static void
nightlight_widgets_popover_widget_schedule_temp_change (NightlightWidgetsPopoverWidget* self)
{
	g_return_if_fail (self != NULL);
	if (self->priv->temp_change_timeout_id != ((guint) 0)) {
		return;
	}
	self->priv->temp_change_timeout_id = g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) NIGHTLIGHT_WIDGETS_POPOVER_WIDGET_TEMP_CHANGE_DELAY_MS, ___lambda4__gsource_func, g_object_ref (self), g_object_unref);
}

static void
nightlight_widgets_popover_widget_show_settings (NightlightWidgetsPopoverWidget* self)
{
	NightlightIndicator* _tmp3_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	{
		GtkWidget* _tmp0_;
		_tmp0_ = gtk_widget_get_toplevel ((GtkWidget*) self);
		gtk_show_uri_on_window (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, gtk_window_get_type (), GtkWindow), "settings://display/night-light", gtk_get_current_event_time (), &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp1_;
		const gchar* _tmp2_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp1_ = e;
		_tmp2_ = _tmp1_->message;
		g_warning ("PopoverWidget.vala:126: Failed to open display settings: %s", _tmp2_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_tmp3_ = self->priv->_indicator;
	g_signal_emit_by_name ((WingpanelIndicator*) _tmp3_, "close");
}

NightlightIndicator*
nightlight_widgets_popover_widget_get_indicator (NightlightWidgetsPopoverWidget* self)
{
	NightlightIndicator* result;
	NightlightIndicator* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_indicator;
	result = _tmp0_;
	return result;
}

void
nightlight_widgets_popover_widget_set_indicator (NightlightWidgetsPopoverWidget* self,
                                                 NightlightIndicator* value)
{
	NightlightIndicator* old_value;
	g_return_if_fail (self != NULL);
	old_value = nightlight_widgets_popover_widget_get_indicator (self);
	if (old_value != value) {
		self->priv->_indicator = value;
		g_object_notify_by_pspec ((GObject *) self, nightlight_widgets_popover_widget_properties[NIGHTLIGHT_WIDGETS_POPOVER_WIDGET_INDICATOR_PROPERTY]);
	}
}

GSettings*
nightlight_widgets_popover_widget_get_settings (NightlightWidgetsPopoverWidget* self)
{
	GSettings* result;
	GSettings* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_settings;
	result = _tmp0_;
	return result;
}

void
nightlight_widgets_popover_widget_set_settings (NightlightWidgetsPopoverWidget* self,
                                                GSettings* value)
{
	GSettings* old_value;
	g_return_if_fail (self != NULL);
	old_value = nightlight_widgets_popover_widget_get_settings (self);
	if (old_value != value) {
		self->priv->_settings = value;
		g_object_notify_by_pspec ((GObject *) self, nightlight_widgets_popover_widget_properties[NIGHTLIGHT_WIDGETS_POPOVER_WIDGET_SETTINGS_PROPERTY]);
	}
}

void
nightlight_widgets_popover_widget_set_automatic_schedule (NightlightWidgetsPopoverWidget* self,
                                                          gboolean value)
{
	g_return_if_fail (self != NULL);
	if (value) {
		GraniteSwitchModelButton* _tmp0_;
		_tmp0_ = self->priv->toggle_switch;
		granite_switch_model_button_set_description (_tmp0_, _ ("Disabled until sunrise"));
	} else {
		GraniteSwitchModelButton* _tmp1_;
		_tmp1_ = self->priv->toggle_switch;
		granite_switch_model_button_set_description (_tmp1_, _ ("Disabled until tomorrow"));
	}
	g_object_notify_by_pspec ((GObject *) self, nightlight_widgets_popover_widget_properties[NIGHTLIGHT_WIDGETS_POPOVER_WIDGET_AUTOMATIC_SCHEDULE_PROPERTY]);
}

void
nightlight_widgets_popover_widget_set_snoozed (NightlightWidgetsPopoverWidget* self,
                                               gboolean value)
{
	GtkBox* _tmp0_;
	GraniteSwitchModelButton* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->scale_box;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp0_, !value);
	_tmp1_ = self->priv->toggle_switch;
	gtk_toggle_button_set_active ((GtkToggleButton*) _tmp1_, value);
	if (value) {
		GtkImage* _tmp2_;
		_tmp2_ = self->priv->image;
		g_object_set (_tmp2_, "icon-name", "indicator-night-light-disabled-symbolic", NULL);
	} else {
		GtkImage* _tmp3_;
		_tmp3_ = self->priv->image;
		g_object_set (_tmp3_, "icon-name", "indicator-night-light-symbolic", NULL);
	}
	g_object_notify_by_pspec ((GObject *) self, nightlight_widgets_popover_widget_properties[NIGHTLIGHT_WIDGETS_POPOVER_WIDGET_SNOOZED_PROPERTY]);
}

void
nightlight_widgets_popover_widget_set_temperature (NightlightWidgetsPopoverWidget* self,
                                                   gint value)
{
	GtkScale* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->temp_scale;
	gtk_range_set_value ((GtkRange*) _tmp0_, (gdouble) value);
	g_object_notify_by_pspec ((GObject *) self, nightlight_widgets_popover_widget_properties[NIGHTLIGHT_WIDGETS_POPOVER_WIDGET_TEMPERATURE_PROPERTY]);
}

static void
_nightlight_widgets_popover_widget_show_settings_gtk_button_clicked (GtkButton* _sender,
                                                                     gpointer self)
{
	nightlight_widgets_popover_widget_show_settings ((NightlightWidgetsPopoverWidget*) self);
}

static void
_nightlight_widgets_popover_widget___lambda6_ (NightlightWidgetsPopoverWidget* self)
{
	nightlight_widgets_popover_widget_schedule_temp_change (self);
}

static void
__nightlight_widgets_popover_widget___lambda6__gtk_range_value_changed (GtkRange* _sender,
                                                                        gpointer self)
{
	_nightlight_widgets_popover_widget___lambda6_ ((NightlightWidgetsPopoverWidget*) self);
}

static GObject *
nightlight_widgets_popover_widget_constructor (GType type,
                                               guint n_construct_properties,
                                               GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	NightlightWidgetsPopoverWidget * self;
	GraniteSwitchModelButton* _tmp0_;
	GtkSeparator* toggle_sep = NULL;
	GtkSeparator* _tmp1_ = NULL;
	GtkImage* _tmp2_ = NULL;
	GtkScale* _tmp3_ = NULL;
	GtkScale* _tmp4_;
	GtkStyleContext* _tmp5_;
	GtkBox* _tmp6_ = NULL;
	GtkBox* _tmp7_;
	GtkImage* _tmp8_;
	GtkBox* _tmp9_;
	GtkScale* _tmp10_;
	GtkSeparator* scale_sep = NULL;
	GtkSeparator* _tmp11_ = NULL;
	GtkModelButton* settings_button = NULL;
	gchar* _tmp12_;
	GtkModelButton* _tmp13_ = NULL;
	GtkModelButton* _tmp14_;
	GraniteSwitchModelButton* _tmp15_;
	GtkSeparator* _tmp16_;
	GtkBox* _tmp17_;
	GtkSeparator* _tmp18_;
	GtkModelButton* _tmp19_;
	NightLightManager* _tmp20_;
	NightLightManager* _tmp21_;
	gboolean _tmp22_;
	gboolean _tmp23_;
	GraniteSwitchModelButton* _tmp24_;
	NightLightManager* _tmp25_;
	NightLightManager* _tmp26_;
	GSettings* _tmp27_;
	GSettings* _tmp28_;
	GtkScale* _tmp29_;
	parent_class = G_OBJECT_CLASS (nightlight_widgets_popover_widget_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, NIGHTLIGHT_WIDGETS_TYPE_POPOVER_WIDGET, NightlightWidgetsPopoverWidget);
	_tmp0_ = granite_switch_model_button_new (_ ("Snooze Night Light"));
	g_object_ref_sink (_tmp0_);
	_g_object_unref0 (self->priv->toggle_switch);
	self->priv->toggle_switch = _tmp0_;
	_tmp1_ = (GtkSeparator*) gtk_separator_new (GTK_ORIENTATION_HORIZONTAL);
	gtk_widget_set_margin_top ((GtkWidget*) _tmp1_, 3);
	gtk_widget_set_margin_bottom ((GtkWidget*) _tmp1_, 3);
	g_object_ref_sink (_tmp1_);
	toggle_sep = _tmp1_;
	_tmp2_ = (GtkImage*) gtk_image_new ();
	gtk_image_set_pixel_size (_tmp2_, 48);
	g_object_ref_sink (_tmp2_);
	_g_object_unref0 (self->priv->image);
	self->priv->image = _tmp2_;
	_tmp3_ = (GtkScale*) gtk_scale_new_with_range (GTK_ORIENTATION_HORIZONTAL, (gdouble) 1500, (gdouble) 6000, (gdouble) 10);
	gtk_scale_set_draw_value (_tmp3_, FALSE);
	gtk_scale_set_has_origin (_tmp3_, FALSE);
	gtk_widget_set_hexpand ((GtkWidget*) _tmp3_, TRUE);
	gtk_range_set_inverted ((GtkRange*) _tmp3_, TRUE);
	g_object_set ((GtkWidget*) _tmp3_, "width-request", 200, NULL);
	g_object_ref_sink (_tmp3_);
	_g_object_unref0 (self->priv->temp_scale);
	self->priv->temp_scale = _tmp3_;
	_tmp4_ = self->priv->temp_scale;
	_tmp5_ = gtk_widget_get_style_context ((GtkWidget*) _tmp4_);
	gtk_style_context_add_class (_tmp5_, "warmth");
	_tmp6_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 6);
	gtk_widget_set_margin_start ((GtkWidget*) _tmp6_, 6);
	gtk_widget_set_margin_end ((GtkWidget*) _tmp6_, 12);
	g_object_ref_sink (_tmp6_);
	_g_object_unref0 (self->priv->scale_box);
	self->priv->scale_box = _tmp6_;
	_tmp7_ = self->priv->scale_box;
	_tmp8_ = self->priv->image;
	gtk_container_add ((GtkContainer*) _tmp7_, (GtkWidget*) _tmp8_);
	_tmp9_ = self->priv->scale_box;
	_tmp10_ = self->priv->temp_scale;
	gtk_container_add ((GtkContainer*) _tmp9_, (GtkWidget*) _tmp10_);
	_tmp11_ = (GtkSeparator*) gtk_separator_new (GTK_ORIENTATION_HORIZONTAL);
	gtk_widget_set_margin_top ((GtkWidget*) _tmp11_, 3);
	gtk_widget_set_margin_bottom ((GtkWidget*) _tmp11_, 3);
	g_object_ref_sink (_tmp11_);
	scale_sep = _tmp11_;
	_tmp12_ = g_strdup (_ ("Night Light Settings…"));
	_tmp13_ = (GtkModelButton*) gtk_model_button_new ();
	g_object_set (_tmp13_, "text", _tmp12_, NULL);
	_g_free0 (_tmp12_);
	g_object_ref_sink (_tmp13_);
	settings_button = _tmp13_;
	_tmp14_ = settings_button;
	g_signal_connect_object ((GtkButton*) _tmp14_, "clicked", (GCallback) _nightlight_widgets_popover_widget_show_settings_gtk_button_clicked, self, 0);
	gtk_orientable_set_orientation ((GtkOrientable*) self, GTK_ORIENTATION_VERTICAL);
	_tmp15_ = self->priv->toggle_switch;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp15_);
	_tmp16_ = toggle_sep;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp16_);
	_tmp17_ = self->priv->scale_box;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp17_);
	_tmp18_ = scale_sep;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp18_);
	_tmp19_ = settings_button;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp19_);
	_tmp20_ = night_light_manager_get_instance ();
	_tmp21_ = _tmp20_;
	_tmp22_ = night_light_manager_get_snoozed (_tmp21_);
	_tmp23_ = _tmp22_;
	nightlight_widgets_popover_widget_set_snoozed (self, _tmp23_);
	_g_object_unref0 (_tmp21_);
	_tmp24_ = self->priv->toggle_switch;
	_tmp25_ = night_light_manager_get_instance ();
	_tmp26_ = _tmp25_;
	g_object_bind_property_with_closures ((GObject*) _tmp24_, "active", (GObject*) _tmp26_, "snoozed", G_BINDING_DEFAULT, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	_g_object_unref0 (_tmp26_);
	_tmp27_ = self->priv->_settings;
	g_settings_bind (_tmp27_, "night-light-temperature", (GObject*) self, "temperature", G_SETTINGS_BIND_GET);
	_tmp28_ = self->priv->_settings;
	g_settings_bind (_tmp28_, "night-light-schedule-automatic", (GObject*) self, "automatic_schedule", G_SETTINGS_BIND_GET);
	_tmp29_ = self->priv->temp_scale;
	g_signal_connect_object ((GtkRange*) _tmp29_, "value-changed", (GCallback) __nightlight_widgets_popover_widget___lambda6__gtk_range_value_changed, self, 0);
	_g_object_unref0 (settings_button);
	_g_object_unref0 (scale_sep);
	_g_object_unref0 (toggle_sep);
	return obj;
}

static void
nightlight_widgets_popover_widget_class_init (NightlightWidgetsPopoverWidgetClass * klass,
                                              gpointer klass_data)
{
	nightlight_widgets_popover_widget_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &NightlightWidgetsPopoverWidget_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_nightlight_widgets_popover_widget_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_nightlight_widgets_popover_widget_set_property;
	G_OBJECT_CLASS (klass)->constructor = nightlight_widgets_popover_widget_constructor;
	G_OBJECT_CLASS (klass)->finalize = nightlight_widgets_popover_widget_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), NIGHTLIGHT_WIDGETS_POPOVER_WIDGET_INDICATOR_PROPERTY, nightlight_widgets_popover_widget_properties[NIGHTLIGHT_WIDGETS_POPOVER_WIDGET_INDICATOR_PROPERTY] = g_param_spec_object ("indicator", "indicator", "indicator", NIGHTLIGHT_TYPE_INDICATOR, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), NIGHTLIGHT_WIDGETS_POPOVER_WIDGET_SETTINGS_PROPERTY, nightlight_widgets_popover_widget_properties[NIGHTLIGHT_WIDGETS_POPOVER_WIDGET_SETTINGS_PROPERTY] = g_param_spec_object ("settings", "settings", "settings", g_settings_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), NIGHTLIGHT_WIDGETS_POPOVER_WIDGET_AUTOMATIC_SCHEDULE_PROPERTY, nightlight_widgets_popover_widget_properties[NIGHTLIGHT_WIDGETS_POPOVER_WIDGET_AUTOMATIC_SCHEDULE_PROPERTY] = g_param_spec_boolean ("automatic-schedule", "automatic-schedule", "automatic-schedule", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), NIGHTLIGHT_WIDGETS_POPOVER_WIDGET_SNOOZED_PROPERTY, nightlight_widgets_popover_widget_properties[NIGHTLIGHT_WIDGETS_POPOVER_WIDGET_SNOOZED_PROPERTY] = g_param_spec_boolean ("snoozed", "snoozed", "snoozed", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), NIGHTLIGHT_WIDGETS_POPOVER_WIDGET_TEMPERATURE_PROPERTY, nightlight_widgets_popover_widget_properties[NIGHTLIGHT_WIDGETS_POPOVER_WIDGET_TEMPERATURE_PROPERTY] = g_param_spec_int ("temperature", "temperature", "temperature", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_WRITABLE));
}

static void
nightlight_widgets_popover_widget_instance_init (NightlightWidgetsPopoverWidget * self,
                                                 gpointer klass)
{
	self->priv = nightlight_widgets_popover_widget_get_instance_private (self);
	self->priv->temp_change_timeout_id = (guint) 0;
}

static void
nightlight_widgets_popover_widget_finalize (GObject * obj)
{
	NightlightWidgetsPopoverWidget * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, NIGHTLIGHT_WIDGETS_TYPE_POPOVER_WIDGET, NightlightWidgetsPopoverWidget);
	_g_object_unref0 (self->priv->toggle_switch);
	_g_object_unref0 (self->priv->scale_box);
	_g_object_unref0 (self->priv->image);
	_g_object_unref0 (self->priv->temp_scale);
	G_OBJECT_CLASS (nightlight_widgets_popover_widget_parent_class)->finalize (obj);
}

static GType
nightlight_widgets_popover_widget_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (NightlightWidgetsPopoverWidgetClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) nightlight_widgets_popover_widget_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (NightlightWidgetsPopoverWidget), 0, (GInstanceInitFunc) nightlight_widgets_popover_widget_instance_init, NULL };
	GType nightlight_widgets_popover_widget_type_id;
	nightlight_widgets_popover_widget_type_id = g_type_register_static (gtk_box_get_type (), "NightlightWidgetsPopoverWidget", &g_define_type_info, 0);
	NightlightWidgetsPopoverWidget_private_offset = g_type_add_instance_private (nightlight_widgets_popover_widget_type_id, sizeof (NightlightWidgetsPopoverWidgetPrivate));
	return nightlight_widgets_popover_widget_type_id;
}

GType
nightlight_widgets_popover_widget_get_type (void)
{
	static volatile gsize nightlight_widgets_popover_widget_type_id__once = 0;
	if (g_once_init_enter (&nightlight_widgets_popover_widget_type_id__once)) {
		GType nightlight_widgets_popover_widget_type_id;
		nightlight_widgets_popover_widget_type_id = nightlight_widgets_popover_widget_get_type_once ();
		g_once_init_leave (&nightlight_widgets_popover_widget_type_id__once, nightlight_widgets_popover_widget_type_id);
	}
	return nightlight_widgets_popover_widget_type_id__once;
}

static void
_vala_nightlight_widgets_popover_widget_get_property (GObject * object,
                                                      guint property_id,
                                                      GValue * value,
                                                      GParamSpec * pspec)
{
	NightlightWidgetsPopoverWidget * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, NIGHTLIGHT_WIDGETS_TYPE_POPOVER_WIDGET, NightlightWidgetsPopoverWidget);
	switch (property_id) {
		case NIGHTLIGHT_WIDGETS_POPOVER_WIDGET_INDICATOR_PROPERTY:
		g_value_set_object (value, nightlight_widgets_popover_widget_get_indicator (self));
		break;
		case NIGHTLIGHT_WIDGETS_POPOVER_WIDGET_SETTINGS_PROPERTY:
		g_value_set_object (value, nightlight_widgets_popover_widget_get_settings (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_nightlight_widgets_popover_widget_set_property (GObject * object,
                                                      guint property_id,
                                                      const GValue * value,
                                                      GParamSpec * pspec)
{
	NightlightWidgetsPopoverWidget * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, NIGHTLIGHT_WIDGETS_TYPE_POPOVER_WIDGET, NightlightWidgetsPopoverWidget);
	switch (property_id) {
		case NIGHTLIGHT_WIDGETS_POPOVER_WIDGET_INDICATOR_PROPERTY:
		nightlight_widgets_popover_widget_set_indicator (self, g_value_get_object (value));
		break;
		case NIGHTLIGHT_WIDGETS_POPOVER_WIDGET_SETTINGS_PROPERTY:
		nightlight_widgets_popover_widget_set_settings (self, g_value_get_object (value));
		break;
		case NIGHTLIGHT_WIDGETS_POPOVER_WIDGET_AUTOMATIC_SCHEDULE_PROPERTY:
		nightlight_widgets_popover_widget_set_automatic_schedule (self, g_value_get_boolean (value));
		break;
		case NIGHTLIGHT_WIDGETS_POPOVER_WIDGET_SNOOZED_PROPERTY:
		nightlight_widgets_popover_widget_set_snoozed (self, g_value_get_boolean (value));
		break;
		case NIGHTLIGHT_WIDGETS_POPOVER_WIDGET_TEMPERATURE_PROPERTY:
		nightlight_widgets_popover_widget_set_temperature (self, g_value_get_int (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

