/*
 * This file is generated by gdbus-codegen, do not modify it.
 *
 * The license of this code is the same as for the D-Bus interface description
 * it was derived from. Note that it links to GLib, so must comply with the
 * LGPL linking clauses.
 */

#ifdef HAVE_CONFIG_H
#  include "config.h"
#endif

#include "sn-item-interface.h"

#include <string.h>
#ifdef G_OS_UNIX
#  include <gio/gunixfdlist.h>
#endif

#ifdef G_ENABLE_DEBUG
#define g_marshal_value_peek_boolean(v)  g_value_get_boolean (v)
#define g_marshal_value_peek_char(v)     g_value_get_schar (v)
#define g_marshal_value_peek_uchar(v)    g_value_get_uchar (v)
#define g_marshal_value_peek_int(v)      g_value_get_int (v)
#define g_marshal_value_peek_uint(v)     g_value_get_uint (v)
#define g_marshal_value_peek_long(v)     g_value_get_long (v)
#define g_marshal_value_peek_ulong(v)    g_value_get_ulong (v)
#define g_marshal_value_peek_int64(v)    g_value_get_int64 (v)
#define g_marshal_value_peek_uint64(v)   g_value_get_uint64 (v)
#define g_marshal_value_peek_enum(v)     g_value_get_enum (v)
#define g_marshal_value_peek_flags(v)    g_value_get_flags (v)
#define g_marshal_value_peek_float(v)    g_value_get_float (v)
#define g_marshal_value_peek_double(v)   g_value_get_double (v)
#define g_marshal_value_peek_string(v)   (char*) g_value_get_string (v)
#define g_marshal_value_peek_param(v)    g_value_get_param (v)
#define g_marshal_value_peek_boxed(v)    g_value_get_boxed (v)
#define g_marshal_value_peek_pointer(v)  g_value_get_pointer (v)
#define g_marshal_value_peek_object(v)   g_value_get_object (v)
#define g_marshal_value_peek_variant(v)  g_value_get_variant (v)
#else /* !G_ENABLE_DEBUG */
/* WARNING: This code accesses GValues directly, which is UNSUPPORTED API.
 *          Do not access GValues directly in your code. Instead, use the
 *          g_value_get_*() functions
 */
#define g_marshal_value_peek_boolean(v)  (v)->data[0].v_int
#define g_marshal_value_peek_char(v)     (v)->data[0].v_int
#define g_marshal_value_peek_uchar(v)    (v)->data[0].v_uint
#define g_marshal_value_peek_int(v)      (v)->data[0].v_int
#define g_marshal_value_peek_uint(v)     (v)->data[0].v_uint
#define g_marshal_value_peek_long(v)     (v)->data[0].v_long
#define g_marshal_value_peek_ulong(v)    (v)->data[0].v_ulong
#define g_marshal_value_peek_int64(v)    (v)->data[0].v_int64
#define g_marshal_value_peek_uint64(v)   (v)->data[0].v_uint64
#define g_marshal_value_peek_enum(v)     (v)->data[0].v_long
#define g_marshal_value_peek_flags(v)    (v)->data[0].v_ulong
#define g_marshal_value_peek_float(v)    (v)->data[0].v_float
#define g_marshal_value_peek_double(v)   (v)->data[0].v_double
#define g_marshal_value_peek_string(v)   (v)->data[0].v_pointer
#define g_marshal_value_peek_param(v)    (v)->data[0].v_pointer
#define g_marshal_value_peek_boxed(v)    (v)->data[0].v_pointer
#define g_marshal_value_peek_pointer(v)  (v)->data[0].v_pointer
#define g_marshal_value_peek_object(v)   (v)->data[0].v_pointer
#define g_marshal_value_peek_variant(v)  (v)->data[0].v_pointer
#endif /* !G_ENABLE_DEBUG */

typedef struct
{
  GDBusArgInfo parent_struct;
  gboolean use_gvariant;
} _ExtendedGDBusArgInfo;

typedef struct
{
  GDBusMethodInfo parent_struct;
  const gchar *signal_name;
  gboolean pass_fdlist;
} _ExtendedGDBusMethodInfo;

typedef struct
{
  GDBusSignalInfo parent_struct;
  const gchar *signal_name;
} _ExtendedGDBusSignalInfo;

typedef struct
{
  GDBusPropertyInfo parent_struct;
  const gchar *hyphen_name;
  guint use_gvariant : 1;
  guint emits_changed_signal : 1;
} _ExtendedGDBusPropertyInfo;

typedef struct
{
  GDBusInterfaceInfo parent_struct;
  const gchar *hyphen_name;
} _ExtendedGDBusInterfaceInfo;

typedef struct
{
  const _ExtendedGDBusPropertyInfo *info;
  guint prop_id;
  GValue orig_value; /* the value before the change */
} ChangedProperty;

static void
_changed_property_free (ChangedProperty *data)
{
  g_value_unset (&data->orig_value);
  g_free (data);
}

static gboolean
_g_strv_equal0 (gchar **a, gchar **b)
{
  gboolean ret = FALSE;
  guint n;
  if (a == NULL && b == NULL)
    {
      ret = TRUE;
      goto out;
    }
  if (a == NULL || b == NULL)
    goto out;
  if (g_strv_length (a) != g_strv_length (b))
    goto out;
  for (n = 0; a[n] != NULL; n++)
    if (g_strcmp0 (a[n], b[n]) != 0)
      goto out;
  ret = TRUE;
out:
  return ret;
}

static gboolean
_g_variant_equal0 (GVariant *a, GVariant *b)
{
  gboolean ret = FALSE;
  if (a == NULL && b == NULL)
    {
      ret = TRUE;
      goto out;
    }
  if (a == NULL || b == NULL)
    goto out;
  ret = g_variant_equal (a, b);
out:
  return ret;
}

G_GNUC_UNUSED static gboolean
_g_value_equal (const GValue *a, const GValue *b)
{
  gboolean ret = FALSE;
  g_assert (G_VALUE_TYPE (a) == G_VALUE_TYPE (b));
  switch (G_VALUE_TYPE (a))
    {
      case G_TYPE_BOOLEAN:
        ret = (g_value_get_boolean (a) == g_value_get_boolean (b));
        break;
      case G_TYPE_UCHAR:
        ret = (g_value_get_uchar (a) == g_value_get_uchar (b));
        break;
      case G_TYPE_INT:
        ret = (g_value_get_int (a) == g_value_get_int (b));
        break;
      case G_TYPE_UINT:
        ret = (g_value_get_uint (a) == g_value_get_uint (b));
        break;
      case G_TYPE_INT64:
        ret = (g_value_get_int64 (a) == g_value_get_int64 (b));
        break;
      case G_TYPE_UINT64:
        ret = (g_value_get_uint64 (a) == g_value_get_uint64 (b));
        break;
      case G_TYPE_DOUBLE:
        {
          /* Avoid -Wfloat-equal warnings by doing a direct bit compare */
          gdouble da = g_value_get_double (a);
          gdouble db = g_value_get_double (b);
          ret = memcmp (&da, &db, sizeof (gdouble)) == 0;
        }
        break;
      case G_TYPE_STRING:
        ret = (g_strcmp0 (g_value_get_string (a), g_value_get_string (b)) == 0);
        break;
      case G_TYPE_VARIANT:
        ret = _g_variant_equal0 (g_value_get_variant (a), g_value_get_variant (b));
        break;
      default:
        if (G_VALUE_TYPE (a) == G_TYPE_STRV)
          ret = _g_strv_equal0 (g_value_get_boxed (a), g_value_get_boxed (b));
        else
          g_critical ("_g_value_equal() does not handle type %s", g_type_name (G_VALUE_TYPE (a)));
        break;
    }
  return ret;
}

static void
_g_dbus_codegen_marshal_BOOLEAN__OBJECT_INT_INT (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint G_GNUC_UNUSED,
    void         *marshal_data)
{
  typedef gboolean (*_GDbusCodegenMarshalBoolean_ObjectIntIntFunc)
       (void *data1,
        GDBusMethodInvocation *arg_method_invocation,
        gint arg_x,
        gint arg_y,
        void *data2);
  _GDbusCodegenMarshalBoolean_ObjectIntIntFunc callback;
  GCClosure *cc = (GCClosure*) closure;
  void *data1, *data2;
  gboolean v_return;

  g_return_if_fail (return_value != NULL);
  g_return_if_fail (n_param_values == 4);

  if (G_CCLOSURE_SWAP_DATA (closure))
    {
      data1 = closure->data;
      data2 = g_value_peek_pointer (param_values + 0);
    }
  else
    {
      data1 = g_value_peek_pointer (param_values + 0);
      data2 = closure->data;
    }

  callback = (_GDbusCodegenMarshalBoolean_ObjectIntIntFunc)
    (marshal_data ? marshal_data : cc->callback);

  v_return =
    callback (data1,
              g_marshal_value_peek_object (param_values + 1),
              g_marshal_value_peek_int (param_values + 2),
              g_marshal_value_peek_int (param_values + 3),
              data2);

  g_value_set_boolean (return_value, v_return);
}

static void
_g_dbus_codegen_marshal_BOOLEAN__OBJECT_INT_STRING (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint G_GNUC_UNUSED,
    void         *marshal_data)
{
  typedef gboolean (*_GDbusCodegenMarshalBoolean_ObjectIntStringFunc)
       (void *data1,
        GDBusMethodInvocation *arg_method_invocation,
        gint arg_delta,
        const gchar *arg_dir,
        void *data2);
  _GDbusCodegenMarshalBoolean_ObjectIntStringFunc callback;
  GCClosure *cc = (GCClosure*) closure;
  void *data1, *data2;
  gboolean v_return;

  g_return_if_fail (return_value != NULL);
  g_return_if_fail (n_param_values == 4);

  if (G_CCLOSURE_SWAP_DATA (closure))
    {
      data1 = closure->data;
      data2 = g_value_peek_pointer (param_values + 0);
    }
  else
    {
      data1 = g_value_peek_pointer (param_values + 0);
      data2 = closure->data;
    }

  callback = (_GDbusCodegenMarshalBoolean_ObjectIntStringFunc)
    (marshal_data ? marshal_data : cc->callback);

  v_return =
    callback (data1,
              g_marshal_value_peek_object (param_values + 1),
              g_marshal_value_peek_int (param_values + 2),
              g_marshal_value_peek_string (param_values + 3),
              data2);

  g_value_set_boolean (return_value, v_return);
}

/* ------------------------------------------------------------------------
 * Code for interface org.kde.StatusNotifierItem
 * ------------------------------------------------------------------------
 */

/**
 * SECTION:SnItemInterface
 * @title: SnItemInterface
 * @short_description: Generated C code for the org.kde.StatusNotifierItem D-Bus interface
 *
 * This section contains code for working with the <link linkend="gdbus-interface-org-kde-StatusNotifierItem.top_of_page">org.kde.StatusNotifierItem</link> D-Bus interface in C.
 */

enum
{
  _SN_ITEM_INTERFACE_NEW_TITLE,
  _SN_ITEM_INTERFACE_NEW_ICON,
  _SN_ITEM_INTERFACE_NEW_ICON_THEME_PATH,
  _SN_ITEM_INTERFACE_NEW_ATTENTION_ICON,
  _SN_ITEM_INTERFACE_NEW_OVERLAY_ICON,
  _SN_ITEM_INTERFACE_NEW_MENU,
  _SN_ITEM_INTERFACE_NEW_TOOL_TIP,
  _SN_ITEM_INTERFACE_NEW_STATUS,
};

static unsigned _SN_ITEM_INTERFACE_SIGNALS[8] = { 0 };

/* ---- Introspection data for org.kde.StatusNotifierItem ---- */

static const _ExtendedGDBusArgInfo _sn_item_interface_method_info_activate_IN_ARG_x =
{
  {
    -1,
    (gchar *) "x",
    (gchar *) "i",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _sn_item_interface_method_info_activate_IN_ARG_y =
{
  {
    -1,
    (gchar *) "y",
    (gchar *) "i",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _sn_item_interface_method_info_activate_IN_ARG_pointers[] =
{
  &_sn_item_interface_method_info_activate_IN_ARG_x.parent_struct,
  &_sn_item_interface_method_info_activate_IN_ARG_y.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _sn_item_interface_method_info_activate =
{
  {
    -1,
    (gchar *) "Activate",
    (GDBusArgInfo **) &_sn_item_interface_method_info_activate_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-activate",
  FALSE
};

static const _ExtendedGDBusArgInfo _sn_item_interface_method_info_secondary_activate_IN_ARG_x =
{
  {
    -1,
    (gchar *) "x",
    (gchar *) "i",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _sn_item_interface_method_info_secondary_activate_IN_ARG_y =
{
  {
    -1,
    (gchar *) "y",
    (gchar *) "i",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _sn_item_interface_method_info_secondary_activate_IN_ARG_pointers[] =
{
  &_sn_item_interface_method_info_secondary_activate_IN_ARG_x.parent_struct,
  &_sn_item_interface_method_info_secondary_activate_IN_ARG_y.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _sn_item_interface_method_info_secondary_activate =
{
  {
    -1,
    (gchar *) "SecondaryActivate",
    (GDBusArgInfo **) &_sn_item_interface_method_info_secondary_activate_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-secondary-activate",
  FALSE
};

static const _ExtendedGDBusArgInfo _sn_item_interface_method_info_context_menu_IN_ARG_x =
{
  {
    -1,
    (gchar *) "x",
    (gchar *) "i",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _sn_item_interface_method_info_context_menu_IN_ARG_y =
{
  {
    -1,
    (gchar *) "y",
    (gchar *) "i",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _sn_item_interface_method_info_context_menu_IN_ARG_pointers[] =
{
  &_sn_item_interface_method_info_context_menu_IN_ARG_x.parent_struct,
  &_sn_item_interface_method_info_context_menu_IN_ARG_y.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _sn_item_interface_method_info_context_menu =
{
  {
    -1,
    (gchar *) "ContextMenu",
    (GDBusArgInfo **) &_sn_item_interface_method_info_context_menu_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-context-menu",
  FALSE
};

static const _ExtendedGDBusArgInfo _sn_item_interface_method_info_scroll_IN_ARG_delta =
{
  {
    -1,
    (gchar *) "delta",
    (gchar *) "i",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _sn_item_interface_method_info_scroll_IN_ARG_dir =
{
  {
    -1,
    (gchar *) "dir",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _sn_item_interface_method_info_scroll_IN_ARG_pointers[] =
{
  &_sn_item_interface_method_info_scroll_IN_ARG_delta.parent_struct,
  &_sn_item_interface_method_info_scroll_IN_ARG_dir.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _sn_item_interface_method_info_scroll =
{
  {
    -1,
    (gchar *) "Scroll",
    (GDBusArgInfo **) &_sn_item_interface_method_info_scroll_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-scroll",
  FALSE
};

static const GDBusMethodInfo * const _sn_item_interface_method_info_pointers[] =
{
  &_sn_item_interface_method_info_activate.parent_struct,
  &_sn_item_interface_method_info_secondary_activate.parent_struct,
  &_sn_item_interface_method_info_context_menu.parent_struct,
  &_sn_item_interface_method_info_scroll.parent_struct,
  NULL
};

static const _ExtendedGDBusSignalInfo _sn_item_interface_signal_info_new_title =
{
  {
    -1,
    (gchar *) "NewTitle",
    NULL,
    NULL
  },
  "new-title"
};

static const _ExtendedGDBusSignalInfo _sn_item_interface_signal_info_new_icon =
{
  {
    -1,
    (gchar *) "NewIcon",
    NULL,
    NULL
  },
  "new-icon"
};

static const _ExtendedGDBusArgInfo _sn_item_interface_signal_info_new_icon_theme_path_ARG_icon_theme_path =
{
  {
    -1,
    (gchar *) "icon_theme_path",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _sn_item_interface_signal_info_new_icon_theme_path_ARG_pointers[] =
{
  &_sn_item_interface_signal_info_new_icon_theme_path_ARG_icon_theme_path.parent_struct,
  NULL
};

static const _ExtendedGDBusSignalInfo _sn_item_interface_signal_info_new_icon_theme_path =
{
  {
    -1,
    (gchar *) "NewIconThemePath",
    (GDBusArgInfo **) &_sn_item_interface_signal_info_new_icon_theme_path_ARG_pointers,
    NULL
  },
  "new-icon-theme-path"
};

static const _ExtendedGDBusSignalInfo _sn_item_interface_signal_info_new_attention_icon =
{
  {
    -1,
    (gchar *) "NewAttentionIcon",
    NULL,
    NULL
  },
  "new-attention-icon"
};

static const _ExtendedGDBusSignalInfo _sn_item_interface_signal_info_new_overlay_icon =
{
  {
    -1,
    (gchar *) "NewOverlayIcon",
    NULL,
    NULL
  },
  "new-overlay-icon"
};

static const _ExtendedGDBusSignalInfo _sn_item_interface_signal_info_new_menu =
{
  {
    -1,
    (gchar *) "NewMenu",
    NULL,
    NULL
  },
  "new-menu"
};

static const _ExtendedGDBusSignalInfo _sn_item_interface_signal_info_new_tool_tip =
{
  {
    -1,
    (gchar *) "NewToolTip",
    NULL,
    NULL
  },
  "new-tool-tip"
};

static const _ExtendedGDBusArgInfo _sn_item_interface_signal_info_new_status_ARG_status =
{
  {
    -1,
    (gchar *) "status",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _sn_item_interface_signal_info_new_status_ARG_pointers[] =
{
  &_sn_item_interface_signal_info_new_status_ARG_status.parent_struct,
  NULL
};

static const _ExtendedGDBusSignalInfo _sn_item_interface_signal_info_new_status =
{
  {
    -1,
    (gchar *) "NewStatus",
    (GDBusArgInfo **) &_sn_item_interface_signal_info_new_status_ARG_pointers,
    NULL
  },
  "new-status"
};

static const GDBusSignalInfo * const _sn_item_interface_signal_info_pointers[] =
{
  &_sn_item_interface_signal_info_new_title.parent_struct,
  &_sn_item_interface_signal_info_new_icon.parent_struct,
  &_sn_item_interface_signal_info_new_icon_theme_path.parent_struct,
  &_sn_item_interface_signal_info_new_attention_icon.parent_struct,
  &_sn_item_interface_signal_info_new_overlay_icon.parent_struct,
  &_sn_item_interface_signal_info_new_menu.parent_struct,
  &_sn_item_interface_signal_info_new_tool_tip.parent_struct,
  &_sn_item_interface_signal_info_new_status.parent_struct,
  NULL
};

static const _ExtendedGDBusPropertyInfo _sn_item_interface_property_info_category =
{
  {
    -1,
    (gchar *) "Category",
    (gchar *) "s",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "category",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _sn_item_interface_property_info_id =
{
  {
    -1,
    (gchar *) "Id",
    (gchar *) "s",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "id",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _sn_item_interface_property_info_title =
{
  {
    -1,
    (gchar *) "Title",
    (gchar *) "s",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "title",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _sn_item_interface_property_info_status =
{
  {
    -1,
    (gchar *) "Status",
    (gchar *) "s",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "status",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _sn_item_interface_property_info_window_id =
{
  {
    -1,
    (gchar *) "WindowId",
    (gchar *) "i",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "window-id",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _sn_item_interface_property_info_menu =
{
  {
    -1,
    (gchar *) "Menu",
    (gchar *) "o",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "menu",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _sn_item_interface_property_info_icon_name =
{
  {
    -1,
    (gchar *) "IconName",
    (gchar *) "s",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "icon-name",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _sn_item_interface_property_info_icon_theme_path =
{
  {
    -1,
    (gchar *) "IconThemePath",
    (gchar *) "s",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "icon-theme-path",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _sn_item_interface_property_info_icon_pixmap =
{
  {
    -1,
    (gchar *) "IconPixmap",
    (gchar *) "a(iiay)",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "icon-pixmap",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _sn_item_interface_property_info_overlay_icon_name =
{
  {
    -1,
    (gchar *) "OverlayIconName",
    (gchar *) "s",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "overlay-icon-name",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _sn_item_interface_property_info_overlay_icon_pixmap =
{
  {
    -1,
    (gchar *) "OverlayIconPixmap",
    (gchar *) "a(iiay)",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "overlay-icon-pixmap",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _sn_item_interface_property_info_attention_icon_name =
{
  {
    -1,
    (gchar *) "AttentionIconName",
    (gchar *) "s",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "attention-icon-name",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _sn_item_interface_property_info_attention_icon_pixmap =
{
  {
    -1,
    (gchar *) "AttentionIconPixmap",
    (gchar *) "a(iiay)",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "attention-icon-pixmap",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _sn_item_interface_property_info_tool_tip =
{
  {
    -1,
    (gchar *) "ToolTip",
    (gchar *) "(sa(iiay)ss)",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "tool-tip",
  FALSE,
  TRUE
};

static const GDBusPropertyInfo * const _sn_item_interface_property_info_pointers[] =
{
  &_sn_item_interface_property_info_category.parent_struct,
  &_sn_item_interface_property_info_id.parent_struct,
  &_sn_item_interface_property_info_title.parent_struct,
  &_sn_item_interface_property_info_status.parent_struct,
  &_sn_item_interface_property_info_window_id.parent_struct,
  &_sn_item_interface_property_info_menu.parent_struct,
  &_sn_item_interface_property_info_icon_name.parent_struct,
  &_sn_item_interface_property_info_icon_theme_path.parent_struct,
  &_sn_item_interface_property_info_icon_pixmap.parent_struct,
  &_sn_item_interface_property_info_overlay_icon_name.parent_struct,
  &_sn_item_interface_property_info_overlay_icon_pixmap.parent_struct,
  &_sn_item_interface_property_info_attention_icon_name.parent_struct,
  &_sn_item_interface_property_info_attention_icon_pixmap.parent_struct,
  &_sn_item_interface_property_info_tool_tip.parent_struct,
  NULL
};

static const _ExtendedGDBusInterfaceInfo _sn_item_interface_interface_info =
{
  {
    -1,
    (gchar *) "org.kde.StatusNotifierItem",
    (GDBusMethodInfo **) &_sn_item_interface_method_info_pointers,
    (GDBusSignalInfo **) &_sn_item_interface_signal_info_pointers,
    (GDBusPropertyInfo **) &_sn_item_interface_property_info_pointers,
    NULL
  },
  "sn-item-interface",
};


/**
 * sn_item_interface_interface_info:
 *
 * Gets a machine-readable description of the <link linkend="gdbus-interface-org-kde-StatusNotifierItem.top_of_page">org.kde.StatusNotifierItem</link> D-Bus interface.
 *
 * Returns: (transfer none): A #GDBusInterfaceInfo. Do not free.
 */
GDBusInterfaceInfo *
sn_item_interface_interface_info (void)
{
  return (GDBusInterfaceInfo *) &_sn_item_interface_interface_info.parent_struct;
}

/**
 * sn_item_interface_override_properties:
 * @klass: The class structure for a #GObject derived class.
 * @property_id_begin: The property id to assign to the first overridden property.
 *
 * Overrides all #GObject properties in the #SnItemInterface interface for a concrete class.
 * The properties are overridden in the order they are defined.
 *
 * Returns: The last property id.
 */
guint
sn_item_interface_override_properties (GObjectClass *klass, guint property_id_begin)
{
  g_object_class_override_property (klass, property_id_begin++, "category");
  g_object_class_override_property (klass, property_id_begin++, "id");
  g_object_class_override_property (klass, property_id_begin++, "title");
  g_object_class_override_property (klass, property_id_begin++, "status");
  g_object_class_override_property (klass, property_id_begin++, "window-id");
  g_object_class_override_property (klass, property_id_begin++, "menu");
  g_object_class_override_property (klass, property_id_begin++, "icon-name");
  g_object_class_override_property (klass, property_id_begin++, "icon-theme-path");
  g_object_class_override_property (klass, property_id_begin++, "icon-pixmap");
  g_object_class_override_property (klass, property_id_begin++, "overlay-icon-name");
  g_object_class_override_property (klass, property_id_begin++, "overlay-icon-pixmap");
  g_object_class_override_property (klass, property_id_begin++, "attention-icon-name");
  g_object_class_override_property (klass, property_id_begin++, "attention-icon-pixmap");
  g_object_class_override_property (klass, property_id_begin++, "tool-tip");
  return property_id_begin - 1;
}


inline static void
sn_item_interface_signal_marshal_new_title (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  g_cclosure_marshal_VOID__VOID (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
sn_item_interface_signal_marshal_new_icon (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  g_cclosure_marshal_VOID__VOID (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
sn_item_interface_signal_marshal_new_icon_theme_path (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  g_cclosure_marshal_VOID__STRING (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
sn_item_interface_signal_marshal_new_attention_icon (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  g_cclosure_marshal_VOID__VOID (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
sn_item_interface_signal_marshal_new_overlay_icon (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  g_cclosure_marshal_VOID__VOID (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
sn_item_interface_signal_marshal_new_menu (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  g_cclosure_marshal_VOID__VOID (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
sn_item_interface_signal_marshal_new_tool_tip (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  g_cclosure_marshal_VOID__VOID (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
sn_item_interface_signal_marshal_new_status (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  g_cclosure_marshal_VOID__STRING (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
sn_item_interface_method_marshal_activate (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_INT_INT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
sn_item_interface_method_marshal_secondary_activate (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_INT_INT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
sn_item_interface_method_marshal_context_menu (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_INT_INT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
sn_item_interface_method_marshal_scroll (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_INT_STRING (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}


/**
 * SnItemInterface:
 *
 * Abstract interface type for the D-Bus interface <link linkend="gdbus-interface-org-kde-StatusNotifierItem.top_of_page">org.kde.StatusNotifierItem</link>.
 */

/**
 * SnItemInterfaceIface:
 * @parent_iface: The parent interface.
 * @handle_activate: Handler for the #SnItemInterface::handle-activate signal.
 * @handle_context_menu: Handler for the #SnItemInterface::handle-context-menu signal.
 * @handle_scroll: Handler for the #SnItemInterface::handle-scroll signal.
 * @handle_secondary_activate: Handler for the #SnItemInterface::handle-secondary-activate signal.
 * @get_attention_icon_name: Getter for the #SnItemInterface:attention-icon-name property.
 * @get_attention_icon_pixmap: Getter for the #SnItemInterface:attention-icon-pixmap property.
 * @get_category: Getter for the #SnItemInterface:category property.
 * @get_icon_name: Getter for the #SnItemInterface:icon-name property.
 * @get_icon_pixmap: Getter for the #SnItemInterface:icon-pixmap property.
 * @get_icon_theme_path: Getter for the #SnItemInterface:icon-theme-path property.
 * @get_id: Getter for the #SnItemInterface:id property.
 * @get_menu: Getter for the #SnItemInterface:menu property.
 * @get_overlay_icon_name: Getter for the #SnItemInterface:overlay-icon-name property.
 * @get_overlay_icon_pixmap: Getter for the #SnItemInterface:overlay-icon-pixmap property.
 * @get_status: Getter for the #SnItemInterface:status property.
 * @get_title: Getter for the #SnItemInterface:title property.
 * @get_tool_tip: Getter for the #SnItemInterface:tool-tip property.
 * @get_window_id: Getter for the #SnItemInterface:window-id property.
 * @new_attention_icon: Handler for the #SnItemInterface::new-attention-icon signal.
 * @new_icon: Handler for the #SnItemInterface::new-icon signal.
 * @new_icon_theme_path: Handler for the #SnItemInterface::new-icon-theme-path signal.
 * @new_menu: Handler for the #SnItemInterface::new-menu signal.
 * @new_overlay_icon: Handler for the #SnItemInterface::new-overlay-icon signal.
 * @new_status: Handler for the #SnItemInterface::new-status signal.
 * @new_title: Handler for the #SnItemInterface::new-title signal.
 * @new_tool_tip: Handler for the #SnItemInterface::new-tool-tip signal.
 *
 * Virtual table for the D-Bus interface <link linkend="gdbus-interface-org-kde-StatusNotifierItem.top_of_page">org.kde.StatusNotifierItem</link>.
 */

typedef SnItemInterfaceIface SnItemInterfaceInterface;
G_DEFINE_INTERFACE (SnItemInterface, sn_item_interface, G_TYPE_OBJECT)

static void
sn_item_interface_default_init (SnItemInterfaceIface *iface)
{
  /* GObject signals for incoming D-Bus method calls: */
  /**
   * SnItemInterface::handle-activate:
   * @object: A #SnItemInterface.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_x: Argument passed by remote caller.
   * @arg_y: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-kde-StatusNotifierItem.Activate">Activate()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call sn_item_interface_complete_activate() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-activate",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (SnItemInterfaceIface, handle_activate),
    g_signal_accumulator_true_handled,
    NULL,
      sn_item_interface_method_marshal_activate,
    G_TYPE_BOOLEAN,
    3,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_INT, G_TYPE_INT);

  /**
   * SnItemInterface::handle-secondary-activate:
   * @object: A #SnItemInterface.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_x: Argument passed by remote caller.
   * @arg_y: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-kde-StatusNotifierItem.SecondaryActivate">SecondaryActivate()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call sn_item_interface_complete_secondary_activate() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-secondary-activate",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (SnItemInterfaceIface, handle_secondary_activate),
    g_signal_accumulator_true_handled,
    NULL,
      sn_item_interface_method_marshal_secondary_activate,
    G_TYPE_BOOLEAN,
    3,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_INT, G_TYPE_INT);

  /**
   * SnItemInterface::handle-context-menu:
   * @object: A #SnItemInterface.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_x: Argument passed by remote caller.
   * @arg_y: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-kde-StatusNotifierItem.ContextMenu">ContextMenu()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call sn_item_interface_complete_context_menu() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-context-menu",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (SnItemInterfaceIface, handle_context_menu),
    g_signal_accumulator_true_handled,
    NULL,
      sn_item_interface_method_marshal_context_menu,
    G_TYPE_BOOLEAN,
    3,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_INT, G_TYPE_INT);

  /**
   * SnItemInterface::handle-scroll:
   * @object: A #SnItemInterface.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_delta: Argument passed by remote caller.
   * @arg_dir: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-kde-StatusNotifierItem.Scroll">Scroll()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call sn_item_interface_complete_scroll() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-scroll",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (SnItemInterfaceIface, handle_scroll),
    g_signal_accumulator_true_handled,
    NULL,
      sn_item_interface_method_marshal_scroll,
    G_TYPE_BOOLEAN,
    3,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_INT, G_TYPE_STRING);

  /* GObject signals for received D-Bus signals: */
  /**
   * SnItemInterface::new-title:
   * @object: A #SnItemInterface.
   *
   * On the client-side, this signal is emitted whenever the D-Bus signal <link linkend="gdbus-signal-org-kde-StatusNotifierItem.NewTitle">"NewTitle"</link> is received.
   *
   * On the service-side, this signal can be used with e.g. g_signal_emit_by_name() to make the object emit the D-Bus signal.
   */
  _SN_ITEM_INTERFACE_SIGNALS[_SN_ITEM_INTERFACE_NEW_TITLE] =
    g_signal_new ("new-title",
      G_TYPE_FROM_INTERFACE (iface),
      G_SIGNAL_RUN_LAST,
      G_STRUCT_OFFSET (SnItemInterfaceIface, new_title),
      NULL,
      NULL,
      sn_item_interface_signal_marshal_new_title,
      G_TYPE_NONE,
      0);

  /**
   * SnItemInterface::new-icon:
   * @object: A #SnItemInterface.
   *
   * On the client-side, this signal is emitted whenever the D-Bus signal <link linkend="gdbus-signal-org-kde-StatusNotifierItem.NewIcon">"NewIcon"</link> is received.
   *
   * On the service-side, this signal can be used with e.g. g_signal_emit_by_name() to make the object emit the D-Bus signal.
   */
  _SN_ITEM_INTERFACE_SIGNALS[_SN_ITEM_INTERFACE_NEW_ICON] =
    g_signal_new ("new-icon",
      G_TYPE_FROM_INTERFACE (iface),
      G_SIGNAL_RUN_LAST,
      G_STRUCT_OFFSET (SnItemInterfaceIface, new_icon),
      NULL,
      NULL,
      sn_item_interface_signal_marshal_new_icon,
      G_TYPE_NONE,
      0);

  /**
   * SnItemInterface::new-icon-theme-path:
   * @object: A #SnItemInterface.
   * @arg_icon_theme_path: Argument.
   *
   * On the client-side, this signal is emitted whenever the D-Bus signal <link linkend="gdbus-signal-org-kde-StatusNotifierItem.NewIconThemePath">"NewIconThemePath"</link> is received.
   *
   * On the service-side, this signal can be used with e.g. g_signal_emit_by_name() to make the object emit the D-Bus signal.
   */
  _SN_ITEM_INTERFACE_SIGNALS[_SN_ITEM_INTERFACE_NEW_ICON_THEME_PATH] =
    g_signal_new ("new-icon-theme-path",
      G_TYPE_FROM_INTERFACE (iface),
      G_SIGNAL_RUN_LAST,
      G_STRUCT_OFFSET (SnItemInterfaceIface, new_icon_theme_path),
      NULL,
      NULL,
      sn_item_interface_signal_marshal_new_icon_theme_path,
      G_TYPE_NONE,
      1, G_TYPE_STRING);

  /**
   * SnItemInterface::new-attention-icon:
   * @object: A #SnItemInterface.
   *
   * On the client-side, this signal is emitted whenever the D-Bus signal <link linkend="gdbus-signal-org-kde-StatusNotifierItem.NewAttentionIcon">"NewAttentionIcon"</link> is received.
   *
   * On the service-side, this signal can be used with e.g. g_signal_emit_by_name() to make the object emit the D-Bus signal.
   */
  _SN_ITEM_INTERFACE_SIGNALS[_SN_ITEM_INTERFACE_NEW_ATTENTION_ICON] =
    g_signal_new ("new-attention-icon",
      G_TYPE_FROM_INTERFACE (iface),
      G_SIGNAL_RUN_LAST,
      G_STRUCT_OFFSET (SnItemInterfaceIface, new_attention_icon),
      NULL,
      NULL,
      sn_item_interface_signal_marshal_new_attention_icon,
      G_TYPE_NONE,
      0);

  /**
   * SnItemInterface::new-overlay-icon:
   * @object: A #SnItemInterface.
   *
   * On the client-side, this signal is emitted whenever the D-Bus signal <link linkend="gdbus-signal-org-kde-StatusNotifierItem.NewOverlayIcon">"NewOverlayIcon"</link> is received.
   *
   * On the service-side, this signal can be used with e.g. g_signal_emit_by_name() to make the object emit the D-Bus signal.
   */
  _SN_ITEM_INTERFACE_SIGNALS[_SN_ITEM_INTERFACE_NEW_OVERLAY_ICON] =
    g_signal_new ("new-overlay-icon",
      G_TYPE_FROM_INTERFACE (iface),
      G_SIGNAL_RUN_LAST,
      G_STRUCT_OFFSET (SnItemInterfaceIface, new_overlay_icon),
      NULL,
      NULL,
      sn_item_interface_signal_marshal_new_overlay_icon,
      G_TYPE_NONE,
      0);

  /**
   * SnItemInterface::new-menu:
   * @object: A #SnItemInterface.
   *
   * On the client-side, this signal is emitted whenever the D-Bus signal <link linkend="gdbus-signal-org-kde-StatusNotifierItem.NewMenu">"NewMenu"</link> is received.
   *
   * On the service-side, this signal can be used with e.g. g_signal_emit_by_name() to make the object emit the D-Bus signal.
   */
  _SN_ITEM_INTERFACE_SIGNALS[_SN_ITEM_INTERFACE_NEW_MENU] =
    g_signal_new ("new-menu",
      G_TYPE_FROM_INTERFACE (iface),
      G_SIGNAL_RUN_LAST,
      G_STRUCT_OFFSET (SnItemInterfaceIface, new_menu),
      NULL,
      NULL,
      sn_item_interface_signal_marshal_new_menu,
      G_TYPE_NONE,
      0);

  /**
   * SnItemInterface::new-tool-tip:
   * @object: A #SnItemInterface.
   *
   * On the client-side, this signal is emitted whenever the D-Bus signal <link linkend="gdbus-signal-org-kde-StatusNotifierItem.NewToolTip">"NewToolTip"</link> is received.
   *
   * On the service-side, this signal can be used with e.g. g_signal_emit_by_name() to make the object emit the D-Bus signal.
   */
  _SN_ITEM_INTERFACE_SIGNALS[_SN_ITEM_INTERFACE_NEW_TOOL_TIP] =
    g_signal_new ("new-tool-tip",
      G_TYPE_FROM_INTERFACE (iface),
      G_SIGNAL_RUN_LAST,
      G_STRUCT_OFFSET (SnItemInterfaceIface, new_tool_tip),
      NULL,
      NULL,
      sn_item_interface_signal_marshal_new_tool_tip,
      G_TYPE_NONE,
      0);

  /**
   * SnItemInterface::new-status:
   * @object: A #SnItemInterface.
   * @arg_status: Argument.
   *
   * On the client-side, this signal is emitted whenever the D-Bus signal <link linkend="gdbus-signal-org-kde-StatusNotifierItem.NewStatus">"NewStatus"</link> is received.
   *
   * On the service-side, this signal can be used with e.g. g_signal_emit_by_name() to make the object emit the D-Bus signal.
   */
  _SN_ITEM_INTERFACE_SIGNALS[_SN_ITEM_INTERFACE_NEW_STATUS] =
    g_signal_new ("new-status",
      G_TYPE_FROM_INTERFACE (iface),
      G_SIGNAL_RUN_LAST,
      G_STRUCT_OFFSET (SnItemInterfaceIface, new_status),
      NULL,
      NULL,
      sn_item_interface_signal_marshal_new_status,
      G_TYPE_NONE,
      1, G_TYPE_STRING);

  /* GObject properties for D-Bus properties: */
  /**
   * SnItemInterface:category:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-kde-StatusNotifierItem.Category">"Category"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_string ("category", "Category", "Category", NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * SnItemInterface:id:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-kde-StatusNotifierItem.Id">"Id"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_string ("id", "Id", "Id", NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * SnItemInterface:title:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-kde-StatusNotifierItem.Title">"Title"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_string ("title", "Title", "Title", NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * SnItemInterface:status:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-kde-StatusNotifierItem.Status">"Status"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_string ("status", "Status", "Status", NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * SnItemInterface:window-id:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-kde-StatusNotifierItem.WindowId">"WindowId"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_int ("window-id", "WindowId", "WindowId", G_MININT32, G_MAXINT32, 0, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * SnItemInterface:menu:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-kde-StatusNotifierItem.Menu">"Menu"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_string ("menu", "Menu", "Menu", NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * SnItemInterface:icon-name:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-kde-StatusNotifierItem.IconName">"IconName"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_string ("icon-name", "IconName", "IconName", NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * SnItemInterface:icon-theme-path:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-kde-StatusNotifierItem.IconThemePath">"IconThemePath"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_string ("icon-theme-path", "IconThemePath", "IconThemePath", NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * SnItemInterface:icon-pixmap:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-kde-StatusNotifierItem.IconPixmap">"IconPixmap"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_variant ("icon-pixmap", "IconPixmap", "IconPixmap", G_VARIANT_TYPE ("a(iiay)"), NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * SnItemInterface:overlay-icon-name:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-kde-StatusNotifierItem.OverlayIconName">"OverlayIconName"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_string ("overlay-icon-name", "OverlayIconName", "OverlayIconName", NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * SnItemInterface:overlay-icon-pixmap:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-kde-StatusNotifierItem.OverlayIconPixmap">"OverlayIconPixmap"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_variant ("overlay-icon-pixmap", "OverlayIconPixmap", "OverlayIconPixmap", G_VARIANT_TYPE ("a(iiay)"), NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * SnItemInterface:attention-icon-name:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-kde-StatusNotifierItem.AttentionIconName">"AttentionIconName"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_string ("attention-icon-name", "AttentionIconName", "AttentionIconName", NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * SnItemInterface:attention-icon-pixmap:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-kde-StatusNotifierItem.AttentionIconPixmap">"AttentionIconPixmap"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_variant ("attention-icon-pixmap", "AttentionIconPixmap", "AttentionIconPixmap", G_VARIANT_TYPE ("a(iiay)"), NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * SnItemInterface:tool-tip:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-kde-StatusNotifierItem.ToolTip">"ToolTip"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_variant ("tool-tip", "ToolTip", "ToolTip", G_VARIANT_TYPE ("(sa(iiay)ss)"), NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
}

/**
 * sn_item_interface_get_category: (skip)
 * @object: A #SnItemInterface.
 *
 * Gets the value of the <link linkend="gdbus-property-org-kde-StatusNotifierItem.Category">"Category"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use sn_item_interface_dup_category() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *
sn_item_interface_get_category (SnItemInterface *object)
{
  g_return_val_if_fail (IS_SN_ITEM_INTERFACE (object), NULL);

  return SN_ITEM_INTERFACE_GET_IFACE (object)->get_category (object);
}

/**
 * sn_item_interface_dup_category: (skip)
 * @object: A #SnItemInterface.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-kde-StatusNotifierItem.Category">"Category"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_free().
 */
gchar *
sn_item_interface_dup_category (SnItemInterface *object)
{
  gchar *value;
  g_object_get (G_OBJECT (object), "category", &value, NULL);
  return value;
}

/**
 * sn_item_interface_set_category: (skip)
 * @object: A #SnItemInterface.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-kde-StatusNotifierItem.Category">"Category"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
sn_item_interface_set_category (SnItemInterface *object, const gchar *value)
{
  g_object_set (G_OBJECT (object), "category", value, NULL);
}

/**
 * sn_item_interface_get_id: (skip)
 * @object: A #SnItemInterface.
 *
 * Gets the value of the <link linkend="gdbus-property-org-kde-StatusNotifierItem.Id">"Id"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use sn_item_interface_dup_id() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *
sn_item_interface_get_id (SnItemInterface *object)
{
  g_return_val_if_fail (IS_SN_ITEM_INTERFACE (object), NULL);

  return SN_ITEM_INTERFACE_GET_IFACE (object)->get_id (object);
}

/**
 * sn_item_interface_dup_id: (skip)
 * @object: A #SnItemInterface.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-kde-StatusNotifierItem.Id">"Id"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_free().
 */
gchar *
sn_item_interface_dup_id (SnItemInterface *object)
{
  gchar *value;
  g_object_get (G_OBJECT (object), "id", &value, NULL);
  return value;
}

/**
 * sn_item_interface_set_id: (skip)
 * @object: A #SnItemInterface.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-kde-StatusNotifierItem.Id">"Id"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
sn_item_interface_set_id (SnItemInterface *object, const gchar *value)
{
  g_object_set (G_OBJECT (object), "id", value, NULL);
}

/**
 * sn_item_interface_get_title: (skip)
 * @object: A #SnItemInterface.
 *
 * Gets the value of the <link linkend="gdbus-property-org-kde-StatusNotifierItem.Title">"Title"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use sn_item_interface_dup_title() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *
sn_item_interface_get_title (SnItemInterface *object)
{
  g_return_val_if_fail (IS_SN_ITEM_INTERFACE (object), NULL);

  return SN_ITEM_INTERFACE_GET_IFACE (object)->get_title (object);
}

/**
 * sn_item_interface_dup_title: (skip)
 * @object: A #SnItemInterface.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-kde-StatusNotifierItem.Title">"Title"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_free().
 */
gchar *
sn_item_interface_dup_title (SnItemInterface *object)
{
  gchar *value;
  g_object_get (G_OBJECT (object), "title", &value, NULL);
  return value;
}

/**
 * sn_item_interface_set_title: (skip)
 * @object: A #SnItemInterface.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-kde-StatusNotifierItem.Title">"Title"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
sn_item_interface_set_title (SnItemInterface *object, const gchar *value)
{
  g_object_set (G_OBJECT (object), "title", value, NULL);
}

/**
 * sn_item_interface_get_status: (skip)
 * @object: A #SnItemInterface.
 *
 * Gets the value of the <link linkend="gdbus-property-org-kde-StatusNotifierItem.Status">"Status"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use sn_item_interface_dup_status() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *
sn_item_interface_get_status (SnItemInterface *object)
{
  g_return_val_if_fail (IS_SN_ITEM_INTERFACE (object), NULL);

  return SN_ITEM_INTERFACE_GET_IFACE (object)->get_status (object);
}

/**
 * sn_item_interface_dup_status: (skip)
 * @object: A #SnItemInterface.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-kde-StatusNotifierItem.Status">"Status"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_free().
 */
gchar *
sn_item_interface_dup_status (SnItemInterface *object)
{
  gchar *value;
  g_object_get (G_OBJECT (object), "status", &value, NULL);
  return value;
}

/**
 * sn_item_interface_set_status: (skip)
 * @object: A #SnItemInterface.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-kde-StatusNotifierItem.Status">"Status"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
sn_item_interface_set_status (SnItemInterface *object, const gchar *value)
{
  g_object_set (G_OBJECT (object), "status", value, NULL);
}

/**
 * sn_item_interface_get_window_id: (skip)
 * @object: A #SnItemInterface.
 *
 * Gets the value of the <link linkend="gdbus-property-org-kde-StatusNotifierItem.WindowId">"WindowId"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
gint 
sn_item_interface_get_window_id (SnItemInterface *object)
{
  g_return_val_if_fail (IS_SN_ITEM_INTERFACE (object), 0);

  return SN_ITEM_INTERFACE_GET_IFACE (object)->get_window_id (object);
}

/**
 * sn_item_interface_set_window_id: (skip)
 * @object: A #SnItemInterface.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-kde-StatusNotifierItem.WindowId">"WindowId"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
sn_item_interface_set_window_id (SnItemInterface *object, gint value)
{
  g_object_set (G_OBJECT (object), "window-id", value, NULL);
}

/**
 * sn_item_interface_get_menu: (skip)
 * @object: A #SnItemInterface.
 *
 * Gets the value of the <link linkend="gdbus-property-org-kde-StatusNotifierItem.Menu">"Menu"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use sn_item_interface_dup_menu() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *
sn_item_interface_get_menu (SnItemInterface *object)
{
  g_return_val_if_fail (IS_SN_ITEM_INTERFACE (object), NULL);

  return SN_ITEM_INTERFACE_GET_IFACE (object)->get_menu (object);
}

/**
 * sn_item_interface_dup_menu: (skip)
 * @object: A #SnItemInterface.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-kde-StatusNotifierItem.Menu">"Menu"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_free().
 */
gchar *
sn_item_interface_dup_menu (SnItemInterface *object)
{
  gchar *value;
  g_object_get (G_OBJECT (object), "menu", &value, NULL);
  return value;
}

/**
 * sn_item_interface_set_menu: (skip)
 * @object: A #SnItemInterface.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-kde-StatusNotifierItem.Menu">"Menu"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
sn_item_interface_set_menu (SnItemInterface *object, const gchar *value)
{
  g_object_set (G_OBJECT (object), "menu", value, NULL);
}

/**
 * sn_item_interface_get_icon_name: (skip)
 * @object: A #SnItemInterface.
 *
 * Gets the value of the <link linkend="gdbus-property-org-kde-StatusNotifierItem.IconName">"IconName"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use sn_item_interface_dup_icon_name() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *
sn_item_interface_get_icon_name (SnItemInterface *object)
{
  g_return_val_if_fail (IS_SN_ITEM_INTERFACE (object), NULL);

  return SN_ITEM_INTERFACE_GET_IFACE (object)->get_icon_name (object);
}

/**
 * sn_item_interface_dup_icon_name: (skip)
 * @object: A #SnItemInterface.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-kde-StatusNotifierItem.IconName">"IconName"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_free().
 */
gchar *
sn_item_interface_dup_icon_name (SnItemInterface *object)
{
  gchar *value;
  g_object_get (G_OBJECT (object), "icon-name", &value, NULL);
  return value;
}

/**
 * sn_item_interface_set_icon_name: (skip)
 * @object: A #SnItemInterface.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-kde-StatusNotifierItem.IconName">"IconName"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
sn_item_interface_set_icon_name (SnItemInterface *object, const gchar *value)
{
  g_object_set (G_OBJECT (object), "icon-name", value, NULL);
}

/**
 * sn_item_interface_get_icon_theme_path: (skip)
 * @object: A #SnItemInterface.
 *
 * Gets the value of the <link linkend="gdbus-property-org-kde-StatusNotifierItem.IconThemePath">"IconThemePath"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use sn_item_interface_dup_icon_theme_path() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *
sn_item_interface_get_icon_theme_path (SnItemInterface *object)
{
  g_return_val_if_fail (IS_SN_ITEM_INTERFACE (object), NULL);

  return SN_ITEM_INTERFACE_GET_IFACE (object)->get_icon_theme_path (object);
}

/**
 * sn_item_interface_dup_icon_theme_path: (skip)
 * @object: A #SnItemInterface.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-kde-StatusNotifierItem.IconThemePath">"IconThemePath"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_free().
 */
gchar *
sn_item_interface_dup_icon_theme_path (SnItemInterface *object)
{
  gchar *value;
  g_object_get (G_OBJECT (object), "icon-theme-path", &value, NULL);
  return value;
}

/**
 * sn_item_interface_set_icon_theme_path: (skip)
 * @object: A #SnItemInterface.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-kde-StatusNotifierItem.IconThemePath">"IconThemePath"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
sn_item_interface_set_icon_theme_path (SnItemInterface *object, const gchar *value)
{
  g_object_set (G_OBJECT (object), "icon-theme-path", value, NULL);
}

/**
 * sn_item_interface_get_icon_pixmap: (skip)
 * @object: A #SnItemInterface.
 *
 * Gets the value of the <link linkend="gdbus-property-org-kde-StatusNotifierItem.IconPixmap">"IconPixmap"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use sn_item_interface_dup_icon_pixmap() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
GVariant *
sn_item_interface_get_icon_pixmap (SnItemInterface *object)
{
  g_return_val_if_fail (IS_SN_ITEM_INTERFACE (object), NULL);

  return SN_ITEM_INTERFACE_GET_IFACE (object)->get_icon_pixmap (object);
}

/**
 * sn_item_interface_dup_icon_pixmap: (skip)
 * @object: A #SnItemInterface.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-kde-StatusNotifierItem.IconPixmap">"IconPixmap"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_variant_unref().
 */
GVariant *
sn_item_interface_dup_icon_pixmap (SnItemInterface *object)
{
  GVariant *value;
  g_object_get (G_OBJECT (object), "icon-pixmap", &value, NULL);
  return value;
}

/**
 * sn_item_interface_set_icon_pixmap: (skip)
 * @object: A #SnItemInterface.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-kde-StatusNotifierItem.IconPixmap">"IconPixmap"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
sn_item_interface_set_icon_pixmap (SnItemInterface *object, GVariant *value)
{
  g_object_set (G_OBJECT (object), "icon-pixmap", value, NULL);
}

/**
 * sn_item_interface_get_overlay_icon_name: (skip)
 * @object: A #SnItemInterface.
 *
 * Gets the value of the <link linkend="gdbus-property-org-kde-StatusNotifierItem.OverlayIconName">"OverlayIconName"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use sn_item_interface_dup_overlay_icon_name() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *
sn_item_interface_get_overlay_icon_name (SnItemInterface *object)
{
  g_return_val_if_fail (IS_SN_ITEM_INTERFACE (object), NULL);

  return SN_ITEM_INTERFACE_GET_IFACE (object)->get_overlay_icon_name (object);
}

/**
 * sn_item_interface_dup_overlay_icon_name: (skip)
 * @object: A #SnItemInterface.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-kde-StatusNotifierItem.OverlayIconName">"OverlayIconName"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_free().
 */
gchar *
sn_item_interface_dup_overlay_icon_name (SnItemInterface *object)
{
  gchar *value;
  g_object_get (G_OBJECT (object), "overlay-icon-name", &value, NULL);
  return value;
}

/**
 * sn_item_interface_set_overlay_icon_name: (skip)
 * @object: A #SnItemInterface.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-kde-StatusNotifierItem.OverlayIconName">"OverlayIconName"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
sn_item_interface_set_overlay_icon_name (SnItemInterface *object, const gchar *value)
{
  g_object_set (G_OBJECT (object), "overlay-icon-name", value, NULL);
}

/**
 * sn_item_interface_get_overlay_icon_pixmap: (skip)
 * @object: A #SnItemInterface.
 *
 * Gets the value of the <link linkend="gdbus-property-org-kde-StatusNotifierItem.OverlayIconPixmap">"OverlayIconPixmap"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use sn_item_interface_dup_overlay_icon_pixmap() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
GVariant *
sn_item_interface_get_overlay_icon_pixmap (SnItemInterface *object)
{
  g_return_val_if_fail (IS_SN_ITEM_INTERFACE (object), NULL);

  return SN_ITEM_INTERFACE_GET_IFACE (object)->get_overlay_icon_pixmap (object);
}

/**
 * sn_item_interface_dup_overlay_icon_pixmap: (skip)
 * @object: A #SnItemInterface.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-kde-StatusNotifierItem.OverlayIconPixmap">"OverlayIconPixmap"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_variant_unref().
 */
GVariant *
sn_item_interface_dup_overlay_icon_pixmap (SnItemInterface *object)
{
  GVariant *value;
  g_object_get (G_OBJECT (object), "overlay-icon-pixmap", &value, NULL);
  return value;
}

/**
 * sn_item_interface_set_overlay_icon_pixmap: (skip)
 * @object: A #SnItemInterface.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-kde-StatusNotifierItem.OverlayIconPixmap">"OverlayIconPixmap"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
sn_item_interface_set_overlay_icon_pixmap (SnItemInterface *object, GVariant *value)
{
  g_object_set (G_OBJECT (object), "overlay-icon-pixmap", value, NULL);
}

/**
 * sn_item_interface_get_attention_icon_name: (skip)
 * @object: A #SnItemInterface.
 *
 * Gets the value of the <link linkend="gdbus-property-org-kde-StatusNotifierItem.AttentionIconName">"AttentionIconName"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use sn_item_interface_dup_attention_icon_name() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *
sn_item_interface_get_attention_icon_name (SnItemInterface *object)
{
  g_return_val_if_fail (IS_SN_ITEM_INTERFACE (object), NULL);

  return SN_ITEM_INTERFACE_GET_IFACE (object)->get_attention_icon_name (object);
}

/**
 * sn_item_interface_dup_attention_icon_name: (skip)
 * @object: A #SnItemInterface.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-kde-StatusNotifierItem.AttentionIconName">"AttentionIconName"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_free().
 */
gchar *
sn_item_interface_dup_attention_icon_name (SnItemInterface *object)
{
  gchar *value;
  g_object_get (G_OBJECT (object), "attention-icon-name", &value, NULL);
  return value;
}

/**
 * sn_item_interface_set_attention_icon_name: (skip)
 * @object: A #SnItemInterface.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-kde-StatusNotifierItem.AttentionIconName">"AttentionIconName"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
sn_item_interface_set_attention_icon_name (SnItemInterface *object, const gchar *value)
{
  g_object_set (G_OBJECT (object), "attention-icon-name", value, NULL);
}

/**
 * sn_item_interface_get_attention_icon_pixmap: (skip)
 * @object: A #SnItemInterface.
 *
 * Gets the value of the <link linkend="gdbus-property-org-kde-StatusNotifierItem.AttentionIconPixmap">"AttentionIconPixmap"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use sn_item_interface_dup_attention_icon_pixmap() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
GVariant *
sn_item_interface_get_attention_icon_pixmap (SnItemInterface *object)
{
  g_return_val_if_fail (IS_SN_ITEM_INTERFACE (object), NULL);

  return SN_ITEM_INTERFACE_GET_IFACE (object)->get_attention_icon_pixmap (object);
}

/**
 * sn_item_interface_dup_attention_icon_pixmap: (skip)
 * @object: A #SnItemInterface.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-kde-StatusNotifierItem.AttentionIconPixmap">"AttentionIconPixmap"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_variant_unref().
 */
GVariant *
sn_item_interface_dup_attention_icon_pixmap (SnItemInterface *object)
{
  GVariant *value;
  g_object_get (G_OBJECT (object), "attention-icon-pixmap", &value, NULL);
  return value;
}

/**
 * sn_item_interface_set_attention_icon_pixmap: (skip)
 * @object: A #SnItemInterface.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-kde-StatusNotifierItem.AttentionIconPixmap">"AttentionIconPixmap"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
sn_item_interface_set_attention_icon_pixmap (SnItemInterface *object, GVariant *value)
{
  g_object_set (G_OBJECT (object), "attention-icon-pixmap", value, NULL);
}

/**
 * sn_item_interface_get_tool_tip: (skip)
 * @object: A #SnItemInterface.
 *
 * Gets the value of the <link linkend="gdbus-property-org-kde-StatusNotifierItem.ToolTip">"ToolTip"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use sn_item_interface_dup_tool_tip() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
GVariant *
sn_item_interface_get_tool_tip (SnItemInterface *object)
{
  g_return_val_if_fail (IS_SN_ITEM_INTERFACE (object), NULL);

  return SN_ITEM_INTERFACE_GET_IFACE (object)->get_tool_tip (object);
}

/**
 * sn_item_interface_dup_tool_tip: (skip)
 * @object: A #SnItemInterface.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-kde-StatusNotifierItem.ToolTip">"ToolTip"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_variant_unref().
 */
GVariant *
sn_item_interface_dup_tool_tip (SnItemInterface *object)
{
  GVariant *value;
  g_object_get (G_OBJECT (object), "tool-tip", &value, NULL);
  return value;
}

/**
 * sn_item_interface_set_tool_tip: (skip)
 * @object: A #SnItemInterface.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-kde-StatusNotifierItem.ToolTip">"ToolTip"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
sn_item_interface_set_tool_tip (SnItemInterface *object, GVariant *value)
{
  g_object_set (G_OBJECT (object), "tool-tip", value, NULL);
}

/**
 * sn_item_interface_emit_new_title:
 * @object: A #SnItemInterface.
 *
 * Emits the <link linkend="gdbus-signal-org-kde-StatusNotifierItem.NewTitle">"NewTitle"</link> D-Bus signal.
 */
void
sn_item_interface_emit_new_title (
    SnItemInterface *object)
{
  g_signal_emit (object, _SN_ITEM_INTERFACE_SIGNALS[_SN_ITEM_INTERFACE_NEW_TITLE], 0);
}

/**
 * sn_item_interface_emit_new_icon:
 * @object: A #SnItemInterface.
 *
 * Emits the <link linkend="gdbus-signal-org-kde-StatusNotifierItem.NewIcon">"NewIcon"</link> D-Bus signal.
 */
void
sn_item_interface_emit_new_icon (
    SnItemInterface *object)
{
  g_signal_emit (object, _SN_ITEM_INTERFACE_SIGNALS[_SN_ITEM_INTERFACE_NEW_ICON], 0);
}

/**
 * sn_item_interface_emit_new_icon_theme_path:
 * @object: A #SnItemInterface.
 * @arg_icon_theme_path: Argument to pass with the signal.
 *
 * Emits the <link linkend="gdbus-signal-org-kde-StatusNotifierItem.NewIconThemePath">"NewIconThemePath"</link> D-Bus signal.
 */
void
sn_item_interface_emit_new_icon_theme_path (
    SnItemInterface *object,
    const gchar *arg_icon_theme_path)
{
  g_signal_emit (object, _SN_ITEM_INTERFACE_SIGNALS[_SN_ITEM_INTERFACE_NEW_ICON_THEME_PATH], 0, arg_icon_theme_path);
}

/**
 * sn_item_interface_emit_new_attention_icon:
 * @object: A #SnItemInterface.
 *
 * Emits the <link linkend="gdbus-signal-org-kde-StatusNotifierItem.NewAttentionIcon">"NewAttentionIcon"</link> D-Bus signal.
 */
void
sn_item_interface_emit_new_attention_icon (
    SnItemInterface *object)
{
  g_signal_emit (object, _SN_ITEM_INTERFACE_SIGNALS[_SN_ITEM_INTERFACE_NEW_ATTENTION_ICON], 0);
}

/**
 * sn_item_interface_emit_new_overlay_icon:
 * @object: A #SnItemInterface.
 *
 * Emits the <link linkend="gdbus-signal-org-kde-StatusNotifierItem.NewOverlayIcon">"NewOverlayIcon"</link> D-Bus signal.
 */
void
sn_item_interface_emit_new_overlay_icon (
    SnItemInterface *object)
{
  g_signal_emit (object, _SN_ITEM_INTERFACE_SIGNALS[_SN_ITEM_INTERFACE_NEW_OVERLAY_ICON], 0);
}

/**
 * sn_item_interface_emit_new_menu:
 * @object: A #SnItemInterface.
 *
 * Emits the <link linkend="gdbus-signal-org-kde-StatusNotifierItem.NewMenu">"NewMenu"</link> D-Bus signal.
 */
void
sn_item_interface_emit_new_menu (
    SnItemInterface *object)
{
  g_signal_emit (object, _SN_ITEM_INTERFACE_SIGNALS[_SN_ITEM_INTERFACE_NEW_MENU], 0);
}

/**
 * sn_item_interface_emit_new_tool_tip:
 * @object: A #SnItemInterface.
 *
 * Emits the <link linkend="gdbus-signal-org-kde-StatusNotifierItem.NewToolTip">"NewToolTip"</link> D-Bus signal.
 */
void
sn_item_interface_emit_new_tool_tip (
    SnItemInterface *object)
{
  g_signal_emit (object, _SN_ITEM_INTERFACE_SIGNALS[_SN_ITEM_INTERFACE_NEW_TOOL_TIP], 0);
}

/**
 * sn_item_interface_emit_new_status:
 * @object: A #SnItemInterface.
 * @arg_status: Argument to pass with the signal.
 *
 * Emits the <link linkend="gdbus-signal-org-kde-StatusNotifierItem.NewStatus">"NewStatus"</link> D-Bus signal.
 */
void
sn_item_interface_emit_new_status (
    SnItemInterface *object,
    const gchar *arg_status)
{
  g_signal_emit (object, _SN_ITEM_INTERFACE_SIGNALS[_SN_ITEM_INTERFACE_NEW_STATUS], 0, arg_status);
}

/**
 * sn_item_interface_call_activate:
 * @proxy: A #SnItemInterfaceProxy.
 * @arg_x: Argument to pass with the method invocation.
 * @arg_y: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-kde-StatusNotifierItem.Activate">Activate()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call sn_item_interface_call_activate_finish() to get the result of the operation.
 *
 * See sn_item_interface_call_activate_sync() for the synchronous, blocking version of this method.
 */
void
sn_item_interface_call_activate (
    SnItemInterface *proxy,
    gint arg_x,
    gint arg_y,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "Activate",
    g_variant_new ("(ii)",
                   arg_x,
                   arg_y),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * sn_item_interface_call_activate_finish:
 * @proxy: A #SnItemInterfaceProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to sn_item_interface_call_activate().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with sn_item_interface_call_activate().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
sn_item_interface_call_activate_finish (
    SnItemInterface *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * sn_item_interface_call_activate_sync:
 * @proxy: A #SnItemInterfaceProxy.
 * @arg_x: Argument to pass with the method invocation.
 * @arg_y: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-kde-StatusNotifierItem.Activate">Activate()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See sn_item_interface_call_activate() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
sn_item_interface_call_activate_sync (
    SnItemInterface *proxy,
    gint arg_x,
    gint arg_y,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "Activate",
    g_variant_new ("(ii)",
                   arg_x,
                   arg_y),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * sn_item_interface_call_secondary_activate:
 * @proxy: A #SnItemInterfaceProxy.
 * @arg_x: Argument to pass with the method invocation.
 * @arg_y: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-kde-StatusNotifierItem.SecondaryActivate">SecondaryActivate()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call sn_item_interface_call_secondary_activate_finish() to get the result of the operation.
 *
 * See sn_item_interface_call_secondary_activate_sync() for the synchronous, blocking version of this method.
 */
void
sn_item_interface_call_secondary_activate (
    SnItemInterface *proxy,
    gint arg_x,
    gint arg_y,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "SecondaryActivate",
    g_variant_new ("(ii)",
                   arg_x,
                   arg_y),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * sn_item_interface_call_secondary_activate_finish:
 * @proxy: A #SnItemInterfaceProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to sn_item_interface_call_secondary_activate().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with sn_item_interface_call_secondary_activate().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
sn_item_interface_call_secondary_activate_finish (
    SnItemInterface *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * sn_item_interface_call_secondary_activate_sync:
 * @proxy: A #SnItemInterfaceProxy.
 * @arg_x: Argument to pass with the method invocation.
 * @arg_y: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-kde-StatusNotifierItem.SecondaryActivate">SecondaryActivate()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See sn_item_interface_call_secondary_activate() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
sn_item_interface_call_secondary_activate_sync (
    SnItemInterface *proxy,
    gint arg_x,
    gint arg_y,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "SecondaryActivate",
    g_variant_new ("(ii)",
                   arg_x,
                   arg_y),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * sn_item_interface_call_context_menu:
 * @proxy: A #SnItemInterfaceProxy.
 * @arg_x: Argument to pass with the method invocation.
 * @arg_y: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-kde-StatusNotifierItem.ContextMenu">ContextMenu()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call sn_item_interface_call_context_menu_finish() to get the result of the operation.
 *
 * See sn_item_interface_call_context_menu_sync() for the synchronous, blocking version of this method.
 */
void
sn_item_interface_call_context_menu (
    SnItemInterface *proxy,
    gint arg_x,
    gint arg_y,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "ContextMenu",
    g_variant_new ("(ii)",
                   arg_x,
                   arg_y),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * sn_item_interface_call_context_menu_finish:
 * @proxy: A #SnItemInterfaceProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to sn_item_interface_call_context_menu().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with sn_item_interface_call_context_menu().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
sn_item_interface_call_context_menu_finish (
    SnItemInterface *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * sn_item_interface_call_context_menu_sync:
 * @proxy: A #SnItemInterfaceProxy.
 * @arg_x: Argument to pass with the method invocation.
 * @arg_y: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-kde-StatusNotifierItem.ContextMenu">ContextMenu()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See sn_item_interface_call_context_menu() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
sn_item_interface_call_context_menu_sync (
    SnItemInterface *proxy,
    gint arg_x,
    gint arg_y,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "ContextMenu",
    g_variant_new ("(ii)",
                   arg_x,
                   arg_y),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * sn_item_interface_call_scroll:
 * @proxy: A #SnItemInterfaceProxy.
 * @arg_delta: Argument to pass with the method invocation.
 * @arg_dir: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-kde-StatusNotifierItem.Scroll">Scroll()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call sn_item_interface_call_scroll_finish() to get the result of the operation.
 *
 * See sn_item_interface_call_scroll_sync() for the synchronous, blocking version of this method.
 */
void
sn_item_interface_call_scroll (
    SnItemInterface *proxy,
    gint arg_delta,
    const gchar *arg_dir,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "Scroll",
    g_variant_new ("(is)",
                   arg_delta,
                   arg_dir),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * sn_item_interface_call_scroll_finish:
 * @proxy: A #SnItemInterfaceProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to sn_item_interface_call_scroll().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with sn_item_interface_call_scroll().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
sn_item_interface_call_scroll_finish (
    SnItemInterface *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * sn_item_interface_call_scroll_sync:
 * @proxy: A #SnItemInterfaceProxy.
 * @arg_delta: Argument to pass with the method invocation.
 * @arg_dir: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-kde-StatusNotifierItem.Scroll">Scroll()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See sn_item_interface_call_scroll() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
sn_item_interface_call_scroll_sync (
    SnItemInterface *proxy,
    gint arg_delta,
    const gchar *arg_dir,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "Scroll",
    g_variant_new ("(is)",
                   arg_delta,
                   arg_dir),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * sn_item_interface_complete_activate:
 * @object: A #SnItemInterface.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-kde-StatusNotifierItem.Activate">Activate()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
sn_item_interface_complete_activate (
    SnItemInterface *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * sn_item_interface_complete_secondary_activate:
 * @object: A #SnItemInterface.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-kde-StatusNotifierItem.SecondaryActivate">SecondaryActivate()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
sn_item_interface_complete_secondary_activate (
    SnItemInterface *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * sn_item_interface_complete_context_menu:
 * @object: A #SnItemInterface.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-kde-StatusNotifierItem.ContextMenu">ContextMenu()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
sn_item_interface_complete_context_menu (
    SnItemInterface *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * sn_item_interface_complete_scroll:
 * @object: A #SnItemInterface.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-kde-StatusNotifierItem.Scroll">Scroll()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
sn_item_interface_complete_scroll (
    SnItemInterface *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/* ------------------------------------------------------------------------ */

/**
 * SnItemInterfaceProxy:
 *
 * The #SnItemInterfaceProxy structure contains only private data and should only be accessed using the provided API.
 */

/**
 * SnItemInterfaceProxyClass:
 * @parent_class: The parent class.
 *
 * Class structure for #SnItemInterfaceProxy.
 */

struct _SnItemInterfaceProxyPrivate
{
  GData *qdata;
};

static void sn_item_interface_proxy_iface_init (SnItemInterfaceIface *iface);

#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (SnItemInterfaceProxy, sn_item_interface_proxy, G_TYPE_DBUS_PROXY,
                         G_ADD_PRIVATE (SnItemInterfaceProxy)
                         G_IMPLEMENT_INTERFACE (TYPE_SN_ITEM_INTERFACE, sn_item_interface_proxy_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (SnItemInterfaceProxy, sn_item_interface_proxy, G_TYPE_DBUS_PROXY,
                         G_IMPLEMENT_INTERFACE (TYPE_SN_ITEM_INTERFACE, sn_item_interface_proxy_iface_init))

#endif
static void
sn_item_interface_proxy_finalize (GObject *object)
{
  SnItemInterfaceProxy *proxy = SN_ITEM_INTERFACE_PROXY (object);
  g_datalist_clear (&proxy->priv->qdata);
  G_OBJECT_CLASS (sn_item_interface_proxy_parent_class)->finalize (object);
}

static void
sn_item_interface_proxy_get_property (GObject      *object,
  guint         prop_id,
  GValue       *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  const _ExtendedGDBusPropertyInfo *info;
  GVariant *variant;
  g_assert (prop_id != 0 && prop_id - 1 < 14);
  info = (const _ExtendedGDBusPropertyInfo *) _sn_item_interface_property_info_pointers[prop_id - 1];
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (object), info->parent_struct.name);
  if (info->use_gvariant)
    {
      g_value_set_variant (value, variant);
    }
  else
    {
      if (variant != NULL)
        g_dbus_gvariant_to_gvalue (variant, value);
    }
  if (variant != NULL)
    g_variant_unref (variant);
}

static void
sn_item_interface_proxy_set_property_cb (GDBusProxy *proxy,
  GAsyncResult *res,
  gpointer      user_data)
{
  const _ExtendedGDBusPropertyInfo *info = user_data;
  GError *error;
  GVariant *_ret;
  error = NULL;
  _ret = g_dbus_proxy_call_finish (proxy, res, &error);
  if (!_ret)
    {
      g_warning ("Error setting property '%s' on interface org.kde.StatusNotifierItem: %s (%s, %d)",
                 info->parent_struct.name, 
                 error->message, g_quark_to_string (error->domain), error->code);
      g_error_free (error);
    }
  else
    {
      g_variant_unref (_ret);
    }
}

static void
sn_item_interface_proxy_set_property (GObject      *object,
  guint         prop_id,
  const GValue *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  const _ExtendedGDBusPropertyInfo *info;
  GVariant *variant;
  g_assert (prop_id != 0 && prop_id - 1 < 14);
  info = (const _ExtendedGDBusPropertyInfo *) _sn_item_interface_property_info_pointers[prop_id - 1];
  variant = g_dbus_gvalue_to_gvariant (value, G_VARIANT_TYPE (info->parent_struct.signature));
  g_dbus_proxy_call (G_DBUS_PROXY (object),
    "org.freedesktop.DBus.Properties.Set",
    g_variant_new ("(ssv)", "org.kde.StatusNotifierItem", info->parent_struct.name, variant),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    NULL, (GAsyncReadyCallback) sn_item_interface_proxy_set_property_cb, (GDBusPropertyInfo *) &info->parent_struct);
  g_variant_unref (variant);
}

static void
sn_item_interface_proxy_g_signal (GDBusProxy *proxy,
  const gchar *sender_name G_GNUC_UNUSED,
  const gchar *signal_name,
  GVariant *parameters)
{
  _ExtendedGDBusSignalInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  gsize n;
  guint signal_id;
  info = (_ExtendedGDBusSignalInfo *) g_dbus_interface_info_lookup_signal ((GDBusInterfaceInfo *) &_sn_item_interface_interface_info.parent_struct, signal_name);
  if (info == NULL)
    return;
  num_params = g_variant_n_children (parameters);
  paramv = g_new0 (GValue, num_params + 1);
  g_value_init (&paramv[0], TYPE_SN_ITEM_INTERFACE);
  g_value_set_object (&paramv[0], proxy);
  g_variant_iter_init (&iter, parameters);
  n = 1;
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.args[n - 1];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, TYPE_SN_ITEM_INTERFACE);
  g_signal_emitv (paramv, signal_id, 0, NULL);
  for (n = 0; n < num_params + 1; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static void
sn_item_interface_proxy_g_properties_changed (GDBusProxy *_proxy,
  GVariant *changed_properties,
  const gchar *const *invalidated_properties)
{
  SnItemInterfaceProxy *proxy = SN_ITEM_INTERFACE_PROXY (_proxy);
  guint n;
  const gchar *key;
  GVariantIter *iter;
  _ExtendedGDBusPropertyInfo *info;
  g_variant_get (changed_properties, "a{sv}", &iter);
  while (g_variant_iter_next (iter, "{&sv}", &key, NULL))
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_sn_item_interface_interface_info.parent_struct, key);
      g_datalist_remove_data (&proxy->priv->qdata, key);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
  g_variant_iter_free (iter);
  for (n = 0; invalidated_properties[n] != NULL; n++)
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_sn_item_interface_interface_info.parent_struct, invalidated_properties[n]);
      g_datalist_remove_data (&proxy->priv->qdata, invalidated_properties[n]);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
}

static const gchar *
sn_item_interface_proxy_get_category (SnItemInterface *object)
{
  SnItemInterfaceProxy *proxy = SN_ITEM_INTERFACE_PROXY (object);
  GVariant *variant;
  const gchar *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "Category");
  if (variant != NULL)
    {
      value = g_variant_get_string (variant, NULL);
      g_variant_unref (variant);
    }
  return value;
}

static const gchar *
sn_item_interface_proxy_get_id (SnItemInterface *object)
{
  SnItemInterfaceProxy *proxy = SN_ITEM_INTERFACE_PROXY (object);
  GVariant *variant;
  const gchar *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "Id");
  if (variant != NULL)
    {
      value = g_variant_get_string (variant, NULL);
      g_variant_unref (variant);
    }
  return value;
}

static const gchar *
sn_item_interface_proxy_get_title (SnItemInterface *object)
{
  SnItemInterfaceProxy *proxy = SN_ITEM_INTERFACE_PROXY (object);
  GVariant *variant;
  const gchar *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "Title");
  if (variant != NULL)
    {
      value = g_variant_get_string (variant, NULL);
      g_variant_unref (variant);
    }
  return value;
}

static const gchar *
sn_item_interface_proxy_get_status (SnItemInterface *object)
{
  SnItemInterfaceProxy *proxy = SN_ITEM_INTERFACE_PROXY (object);
  GVariant *variant;
  const gchar *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "Status");
  if (variant != NULL)
    {
      value = g_variant_get_string (variant, NULL);
      g_variant_unref (variant);
    }
  return value;
}

static gint 
sn_item_interface_proxy_get_window_id (SnItemInterface *object)
{
  SnItemInterfaceProxy *proxy = SN_ITEM_INTERFACE_PROXY (object);
  GVariant *variant;
  gint value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "WindowId");
  if (variant != NULL)
    {
      value = g_variant_get_int32 (variant);
      g_variant_unref (variant);
    }
  return value;
}

static const gchar *
sn_item_interface_proxy_get_menu (SnItemInterface *object)
{
  SnItemInterfaceProxy *proxy = SN_ITEM_INTERFACE_PROXY (object);
  GVariant *variant;
  const gchar *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "Menu");
  if (variant != NULL)
    {
      value = g_variant_get_string (variant, NULL);
      g_variant_unref (variant);
    }
  return value;
}

static const gchar *
sn_item_interface_proxy_get_icon_name (SnItemInterface *object)
{
  SnItemInterfaceProxy *proxy = SN_ITEM_INTERFACE_PROXY (object);
  GVariant *variant;
  const gchar *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "IconName");
  if (variant != NULL)
    {
      value = g_variant_get_string (variant, NULL);
      g_variant_unref (variant);
    }
  return value;
}

static const gchar *
sn_item_interface_proxy_get_icon_theme_path (SnItemInterface *object)
{
  SnItemInterfaceProxy *proxy = SN_ITEM_INTERFACE_PROXY (object);
  GVariant *variant;
  const gchar *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "IconThemePath");
  if (variant != NULL)
    {
      value = g_variant_get_string (variant, NULL);
      g_variant_unref (variant);
    }
  return value;
}

static GVariant *
sn_item_interface_proxy_get_icon_pixmap (SnItemInterface *object)
{
  SnItemInterfaceProxy *proxy = SN_ITEM_INTERFACE_PROXY (object);
  GVariant *variant;
  GVariant *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "IconPixmap");
  value = variant;
  if (variant != NULL)
    g_variant_unref (variant);
  return value;
}

static const gchar *
sn_item_interface_proxy_get_overlay_icon_name (SnItemInterface *object)
{
  SnItemInterfaceProxy *proxy = SN_ITEM_INTERFACE_PROXY (object);
  GVariant *variant;
  const gchar *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "OverlayIconName");
  if (variant != NULL)
    {
      value = g_variant_get_string (variant, NULL);
      g_variant_unref (variant);
    }
  return value;
}

static GVariant *
sn_item_interface_proxy_get_overlay_icon_pixmap (SnItemInterface *object)
{
  SnItemInterfaceProxy *proxy = SN_ITEM_INTERFACE_PROXY (object);
  GVariant *variant;
  GVariant *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "OverlayIconPixmap");
  value = variant;
  if (variant != NULL)
    g_variant_unref (variant);
  return value;
}

static const gchar *
sn_item_interface_proxy_get_attention_icon_name (SnItemInterface *object)
{
  SnItemInterfaceProxy *proxy = SN_ITEM_INTERFACE_PROXY (object);
  GVariant *variant;
  const gchar *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "AttentionIconName");
  if (variant != NULL)
    {
      value = g_variant_get_string (variant, NULL);
      g_variant_unref (variant);
    }
  return value;
}

static GVariant *
sn_item_interface_proxy_get_attention_icon_pixmap (SnItemInterface *object)
{
  SnItemInterfaceProxy *proxy = SN_ITEM_INTERFACE_PROXY (object);
  GVariant *variant;
  GVariant *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "AttentionIconPixmap");
  value = variant;
  if (variant != NULL)
    g_variant_unref (variant);
  return value;
}

static GVariant *
sn_item_interface_proxy_get_tool_tip (SnItemInterface *object)
{
  SnItemInterfaceProxy *proxy = SN_ITEM_INTERFACE_PROXY (object);
  GVariant *variant;
  GVariant *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "ToolTip");
  value = variant;
  if (variant != NULL)
    g_variant_unref (variant);
  return value;
}

static void
sn_item_interface_proxy_init (SnItemInterfaceProxy *proxy)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  proxy->priv = sn_item_interface_proxy_get_instance_private (proxy);
#else
  proxy->priv = G_TYPE_INSTANCE_GET_PRIVATE (proxy, TYPE_SN_ITEM_INTERFACE_PROXY, SnItemInterfaceProxyPrivate);
#endif

  g_dbus_proxy_set_interface_info (G_DBUS_PROXY (proxy), sn_item_interface_interface_info ());
}

static void
sn_item_interface_proxy_class_init (SnItemInterfaceProxyClass *klass)
{
  GObjectClass *gobject_class;
  GDBusProxyClass *proxy_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize     = sn_item_interface_proxy_finalize;
  gobject_class->get_property = sn_item_interface_proxy_get_property;
  gobject_class->set_property = sn_item_interface_proxy_set_property;

  proxy_class = G_DBUS_PROXY_CLASS (klass);
  proxy_class->g_signal = sn_item_interface_proxy_g_signal;
  proxy_class->g_properties_changed = sn_item_interface_proxy_g_properties_changed;

  sn_item_interface_override_properties (gobject_class, 1);

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (SnItemInterfaceProxyPrivate));
#endif
}

static void
sn_item_interface_proxy_iface_init (SnItemInterfaceIface *iface)
{
  iface->get_category = sn_item_interface_proxy_get_category;
  iface->get_id = sn_item_interface_proxy_get_id;
  iface->get_title = sn_item_interface_proxy_get_title;
  iface->get_status = sn_item_interface_proxy_get_status;
  iface->get_window_id = sn_item_interface_proxy_get_window_id;
  iface->get_menu = sn_item_interface_proxy_get_menu;
  iface->get_icon_name = sn_item_interface_proxy_get_icon_name;
  iface->get_icon_theme_path = sn_item_interface_proxy_get_icon_theme_path;
  iface->get_icon_pixmap = sn_item_interface_proxy_get_icon_pixmap;
  iface->get_overlay_icon_name = sn_item_interface_proxy_get_overlay_icon_name;
  iface->get_overlay_icon_pixmap = sn_item_interface_proxy_get_overlay_icon_pixmap;
  iface->get_attention_icon_name = sn_item_interface_proxy_get_attention_icon_name;
  iface->get_attention_icon_pixmap = sn_item_interface_proxy_get_attention_icon_pixmap;
  iface->get_tool_tip = sn_item_interface_proxy_get_tool_tip;
}

/**
 * sn_item_interface_proxy_new:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-kde-StatusNotifierItem.top_of_page">org.kde.StatusNotifierItem</link>. See g_dbus_proxy_new() for more details.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call sn_item_interface_proxy_new_finish() to get the result of the operation.
 *
 * See sn_item_interface_proxy_new_sync() for the synchronous, blocking version of this constructor.
 */
void
sn_item_interface_proxy_new (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (TYPE_SN_ITEM_INTERFACE_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.kde.StatusNotifierItem", NULL);
}

/**
 * sn_item_interface_proxy_new_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to sn_item_interface_proxy_new().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with sn_item_interface_proxy_new().
 *
 * Returns: (transfer full) (type SnItemInterfaceProxy): The constructed proxy object or %NULL if @error is set.
 */
SnItemInterface *
sn_item_interface_proxy_new_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return SN_ITEM_INTERFACE (ret);
  else
    return NULL;
}

/**
 * sn_item_interface_proxy_new_sync:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Synchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-kde-StatusNotifierItem.top_of_page">org.kde.StatusNotifierItem</link>. See g_dbus_proxy_new_sync() for more details.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See sn_item_interface_proxy_new() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type SnItemInterfaceProxy): The constructed proxy object or %NULL if @error is set.
 */
SnItemInterface *
sn_item_interface_proxy_new_sync (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (TYPE_SN_ITEM_INTERFACE_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.kde.StatusNotifierItem", NULL);
  if (ret != NULL)
    return SN_ITEM_INTERFACE (ret);
  else
    return NULL;
}


/**
 * sn_item_interface_proxy_new_for_bus:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Like sn_item_interface_proxy_new() but takes a #GBusType instead of a #GDBusConnection.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call sn_item_interface_proxy_new_for_bus_finish() to get the result of the operation.
 *
 * See sn_item_interface_proxy_new_for_bus_sync() for the synchronous, blocking version of this constructor.
 */
void
sn_item_interface_proxy_new_for_bus (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (TYPE_SN_ITEM_INTERFACE_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.kde.StatusNotifierItem", NULL);
}

/**
 * sn_item_interface_proxy_new_for_bus_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to sn_item_interface_proxy_new_for_bus().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with sn_item_interface_proxy_new_for_bus().
 *
 * Returns: (transfer full) (type SnItemInterfaceProxy): The constructed proxy object or %NULL if @error is set.
 */
SnItemInterface *
sn_item_interface_proxy_new_for_bus_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return SN_ITEM_INTERFACE (ret);
  else
    return NULL;
}

/**
 * sn_item_interface_proxy_new_for_bus_sync:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Like sn_item_interface_proxy_new_sync() but takes a #GBusType instead of a #GDBusConnection.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See sn_item_interface_proxy_new_for_bus() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type SnItemInterfaceProxy): The constructed proxy object or %NULL if @error is set.
 */
SnItemInterface *
sn_item_interface_proxy_new_for_bus_sync (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (TYPE_SN_ITEM_INTERFACE_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.kde.StatusNotifierItem", NULL);
  if (ret != NULL)
    return SN_ITEM_INTERFACE (ret);
  else
    return NULL;
}


/* ------------------------------------------------------------------------ */

/**
 * SnItemInterfaceSkeleton:
 *
 * The #SnItemInterfaceSkeleton structure contains only private data and should only be accessed using the provided API.
 */

/**
 * SnItemInterfaceSkeletonClass:
 * @parent_class: The parent class.
 *
 * Class structure for #SnItemInterfaceSkeleton.
 */

struct _SnItemInterfaceSkeletonPrivate
{
  GValue *properties;
  GList *changed_properties;
  GSource *changed_properties_idle_source;
  GMainContext *context;
  GMutex lock;
};

static void
_sn_item_interface_skeleton_handle_method_call (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name,
  const gchar *method_name,
  GVariant *parameters,
  GDBusMethodInvocation *invocation,
  gpointer user_data)
{
  SnItemInterfaceSkeleton *skeleton = SN_ITEM_INTERFACE_SKELETON (user_data);
  _ExtendedGDBusMethodInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  guint num_extra;
  gsize n;
  guint signal_id;
  GValue return_value = G_VALUE_INIT;
  info = (_ExtendedGDBusMethodInfo *) g_dbus_method_invocation_get_method_info (invocation);
  g_assert (info != NULL);
  num_params = g_variant_n_children (parameters);
  num_extra = info->pass_fdlist ? 3 : 2;  paramv = g_new0 (GValue, num_params + num_extra);
  n = 0;
  g_value_init (&paramv[n], TYPE_SN_ITEM_INTERFACE);
  g_value_set_object (&paramv[n++], skeleton);
  g_value_init (&paramv[n], G_TYPE_DBUS_METHOD_INVOCATION);
  g_value_set_object (&paramv[n++], invocation);
  if (info->pass_fdlist)
    {
#ifdef G_OS_UNIX
      g_value_init (&paramv[n], G_TYPE_UNIX_FD_LIST);
      g_value_set_object (&paramv[n++], g_dbus_message_get_unix_fd_list (g_dbus_method_invocation_get_message (invocation)));
#else
      g_assert_not_reached ();
#endif
    }
  g_variant_iter_init (&iter, parameters);
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.in_args[n - num_extra];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, TYPE_SN_ITEM_INTERFACE);
  g_value_init (&return_value, G_TYPE_BOOLEAN);
  g_signal_emitv (paramv, signal_id, 0, &return_value);
  if (!g_value_get_boolean (&return_value))
    g_dbus_method_invocation_return_error (invocation, G_DBUS_ERROR, G_DBUS_ERROR_UNKNOWN_METHOD, "Method %s is not implemented on interface %s", method_name, interface_name);
  g_value_unset (&return_value);
  for (n = 0; n < num_params + num_extra; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static GVariant *
_sn_item_interface_skeleton_handle_get_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GError **error,
  gpointer user_data)
{
  SnItemInterfaceSkeleton *skeleton = SN_ITEM_INTERFACE_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  GVariant *ret;
  ret = NULL;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_sn_item_interface_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      g_value_init (&value, pspec->value_type);
      g_object_get_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      ret = g_dbus_gvalue_to_gvariant (&value, G_VARIANT_TYPE (info->parent_struct.signature));
      g_value_unset (&value);
    }
  return ret;
}

static gboolean
_sn_item_interface_skeleton_handle_set_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GVariant *variant,
  GError **error,
  gpointer user_data)
{
  SnItemInterfaceSkeleton *skeleton = SN_ITEM_INTERFACE_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  gboolean ret;
  ret = FALSE;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_sn_item_interface_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      if (info->use_gvariant)
        g_value_set_variant (&value, variant);
      else
        g_dbus_gvariant_to_gvalue (variant, &value);
      g_object_set_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      g_value_unset (&value);
      ret = TRUE;
    }
  return ret;
}

static const GDBusInterfaceVTable _sn_item_interface_skeleton_vtable =
{
  _sn_item_interface_skeleton_handle_method_call,
  _sn_item_interface_skeleton_handle_get_property,
  _sn_item_interface_skeleton_handle_set_property,
  {NULL}
};

static GDBusInterfaceInfo *
sn_item_interface_skeleton_dbus_interface_get_info (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return sn_item_interface_interface_info ();
}

static GDBusInterfaceVTable *
sn_item_interface_skeleton_dbus_interface_get_vtable (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return (GDBusInterfaceVTable *) &_sn_item_interface_skeleton_vtable;
}

static GVariant *
sn_item_interface_skeleton_dbus_interface_get_properties (GDBusInterfaceSkeleton *_skeleton)
{
  SnItemInterfaceSkeleton *skeleton = SN_ITEM_INTERFACE_SKELETON (_skeleton);

  GVariantBuilder builder;
  guint n;
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_84
  g_variant_builder_init_static (&builder, G_VARIANT_TYPE ("a{sv}"));
#else
  g_variant_builder_init(&builder, G_VARIANT_TYPE ("a{sv}"));
#endif
  if (_sn_item_interface_interface_info.parent_struct.properties == NULL)
    goto out;
  for (n = 0; _sn_item_interface_interface_info.parent_struct.properties[n] != NULL; n++)
    {
      GDBusPropertyInfo *info = _sn_item_interface_interface_info.parent_struct.properties[n];
      if (info->flags & G_DBUS_PROPERTY_INFO_FLAGS_READABLE)
        {
          GVariant *value;
          value = _sn_item_interface_skeleton_handle_get_property (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)), NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.kde.StatusNotifierItem", info->name, NULL, skeleton);
          if (value != NULL)
            {
              g_variant_take_ref (value);
              g_variant_builder_add (&builder, "{sv}", info->name, value);
              g_variant_unref (value);
            }
        }
    }
out:
  return g_variant_builder_end (&builder);
}

static gboolean _sn_item_interface_emit_changed (gpointer user_data);

static void
sn_item_interface_skeleton_dbus_interface_flush (GDBusInterfaceSkeleton *_skeleton)
{
  SnItemInterfaceSkeleton *skeleton = SN_ITEM_INTERFACE_SKELETON (_skeleton);
  gboolean emit_changed = FALSE;

  g_mutex_lock (&skeleton->priv->lock);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    {
      g_source_destroy (skeleton->priv->changed_properties_idle_source);
      skeleton->priv->changed_properties_idle_source = NULL;
      emit_changed = TRUE;
    }
  g_mutex_unlock (&skeleton->priv->lock);

  if (emit_changed)
    _sn_item_interface_emit_changed (skeleton);
}

static void
_sn_item_interface_on_signal_new_title (
    SnItemInterface *object)
{
  SnItemInterfaceSkeleton *skeleton = SN_ITEM_INTERFACE_SKELETON (object);

  GList      *connections, *l;
  GVariant   *signal_variant;
  connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));

  signal_variant = g_variant_ref_sink (g_variant_new ("()"));
  for (l = connections; l != NULL; l = l->next)
    {
      GDBusConnection *connection = l->data;
      g_dbus_connection_emit_signal (connection,
        NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.kde.StatusNotifierItem", "NewTitle",
        signal_variant, NULL);
    }
  g_variant_unref (signal_variant);
  g_list_free_full (connections, g_object_unref);
}

static void
_sn_item_interface_on_signal_new_icon (
    SnItemInterface *object)
{
  SnItemInterfaceSkeleton *skeleton = SN_ITEM_INTERFACE_SKELETON (object);

  GList      *connections, *l;
  GVariant   *signal_variant;
  connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));

  signal_variant = g_variant_ref_sink (g_variant_new ("()"));
  for (l = connections; l != NULL; l = l->next)
    {
      GDBusConnection *connection = l->data;
      g_dbus_connection_emit_signal (connection,
        NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.kde.StatusNotifierItem", "NewIcon",
        signal_variant, NULL);
    }
  g_variant_unref (signal_variant);
  g_list_free_full (connections, g_object_unref);
}

static void
_sn_item_interface_on_signal_new_icon_theme_path (
    SnItemInterface *object,
    const gchar *arg_icon_theme_path)
{
  SnItemInterfaceSkeleton *skeleton = SN_ITEM_INTERFACE_SKELETON (object);

  GList      *connections, *l;
  GVariant   *signal_variant;
  connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));

  signal_variant = g_variant_ref_sink (g_variant_new ("(s)",
                   arg_icon_theme_path));
  for (l = connections; l != NULL; l = l->next)
    {
      GDBusConnection *connection = l->data;
      g_dbus_connection_emit_signal (connection,
        NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.kde.StatusNotifierItem", "NewIconThemePath",
        signal_variant, NULL);
    }
  g_variant_unref (signal_variant);
  g_list_free_full (connections, g_object_unref);
}

static void
_sn_item_interface_on_signal_new_attention_icon (
    SnItemInterface *object)
{
  SnItemInterfaceSkeleton *skeleton = SN_ITEM_INTERFACE_SKELETON (object);

  GList      *connections, *l;
  GVariant   *signal_variant;
  connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));

  signal_variant = g_variant_ref_sink (g_variant_new ("()"));
  for (l = connections; l != NULL; l = l->next)
    {
      GDBusConnection *connection = l->data;
      g_dbus_connection_emit_signal (connection,
        NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.kde.StatusNotifierItem", "NewAttentionIcon",
        signal_variant, NULL);
    }
  g_variant_unref (signal_variant);
  g_list_free_full (connections, g_object_unref);
}

static void
_sn_item_interface_on_signal_new_overlay_icon (
    SnItemInterface *object)
{
  SnItemInterfaceSkeleton *skeleton = SN_ITEM_INTERFACE_SKELETON (object);

  GList      *connections, *l;
  GVariant   *signal_variant;
  connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));

  signal_variant = g_variant_ref_sink (g_variant_new ("()"));
  for (l = connections; l != NULL; l = l->next)
    {
      GDBusConnection *connection = l->data;
      g_dbus_connection_emit_signal (connection,
        NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.kde.StatusNotifierItem", "NewOverlayIcon",
        signal_variant, NULL);
    }
  g_variant_unref (signal_variant);
  g_list_free_full (connections, g_object_unref);
}

static void
_sn_item_interface_on_signal_new_menu (
    SnItemInterface *object)
{
  SnItemInterfaceSkeleton *skeleton = SN_ITEM_INTERFACE_SKELETON (object);

  GList      *connections, *l;
  GVariant   *signal_variant;
  connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));

  signal_variant = g_variant_ref_sink (g_variant_new ("()"));
  for (l = connections; l != NULL; l = l->next)
    {
      GDBusConnection *connection = l->data;
      g_dbus_connection_emit_signal (connection,
        NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.kde.StatusNotifierItem", "NewMenu",
        signal_variant, NULL);
    }
  g_variant_unref (signal_variant);
  g_list_free_full (connections, g_object_unref);
}

static void
_sn_item_interface_on_signal_new_tool_tip (
    SnItemInterface *object)
{
  SnItemInterfaceSkeleton *skeleton = SN_ITEM_INTERFACE_SKELETON (object);

  GList      *connections, *l;
  GVariant   *signal_variant;
  connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));

  signal_variant = g_variant_ref_sink (g_variant_new ("()"));
  for (l = connections; l != NULL; l = l->next)
    {
      GDBusConnection *connection = l->data;
      g_dbus_connection_emit_signal (connection,
        NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.kde.StatusNotifierItem", "NewToolTip",
        signal_variant, NULL);
    }
  g_variant_unref (signal_variant);
  g_list_free_full (connections, g_object_unref);
}

static void
_sn_item_interface_on_signal_new_status (
    SnItemInterface *object,
    const gchar *arg_status)
{
  SnItemInterfaceSkeleton *skeleton = SN_ITEM_INTERFACE_SKELETON (object);

  GList      *connections, *l;
  GVariant   *signal_variant;
  connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));

  signal_variant = g_variant_ref_sink (g_variant_new ("(s)",
                   arg_status));
  for (l = connections; l != NULL; l = l->next)
    {
      GDBusConnection *connection = l->data;
      g_dbus_connection_emit_signal (connection,
        NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.kde.StatusNotifierItem", "NewStatus",
        signal_variant, NULL);
    }
  g_variant_unref (signal_variant);
  g_list_free_full (connections, g_object_unref);
}

static void sn_item_interface_skeleton_iface_init (SnItemInterfaceIface *iface);
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (SnItemInterfaceSkeleton, sn_item_interface_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_ADD_PRIVATE (SnItemInterfaceSkeleton)
                         G_IMPLEMENT_INTERFACE (TYPE_SN_ITEM_INTERFACE, sn_item_interface_skeleton_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (SnItemInterfaceSkeleton, sn_item_interface_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_IMPLEMENT_INTERFACE (TYPE_SN_ITEM_INTERFACE, sn_item_interface_skeleton_iface_init))

#endif
static void
sn_item_interface_skeleton_finalize (GObject *object)
{
  SnItemInterfaceSkeleton *skeleton = SN_ITEM_INTERFACE_SKELETON (object);
  guint n;
  for (n = 0; n < 14; n++)
    g_value_unset (&skeleton->priv->properties[n]);
  g_free (skeleton->priv->properties);
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    g_source_destroy (skeleton->priv->changed_properties_idle_source);
  g_main_context_unref (skeleton->priv->context);
  g_mutex_clear (&skeleton->priv->lock);
  G_OBJECT_CLASS (sn_item_interface_skeleton_parent_class)->finalize (object);
}

static void
sn_item_interface_skeleton_get_property (GObject      *object,
  guint         prop_id,
  GValue       *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  SnItemInterfaceSkeleton *skeleton = SN_ITEM_INTERFACE_SKELETON (object);
  g_assert (prop_id != 0 && prop_id - 1 < 14);
  g_mutex_lock (&skeleton->priv->lock);
  g_value_copy (&skeleton->priv->properties[prop_id - 1], value);
  g_mutex_unlock (&skeleton->priv->lock);
}

static gboolean
_sn_item_interface_emit_changed (gpointer user_data)
{
  SnItemInterfaceSkeleton *skeleton = SN_ITEM_INTERFACE_SKELETON (user_data);
  GList *l;
  GVariantBuilder builder;
  GVariantBuilder invalidated_builder;
  guint num_changes;

  g_mutex_lock (&skeleton->priv->lock);
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_84
  g_variant_builder_init_static (&builder, G_VARIANT_TYPE ("a{sv}"));
  g_variant_builder_init_static (&invalidated_builder, G_VARIANT_TYPE ("as"));
#else
  g_variant_builder_init (&builder, G_VARIANT_TYPE ("a{sv}"));
  g_variant_builder_init (&invalidated_builder, G_VARIANT_TYPE ("as"));
#endif
  for (l = skeleton->priv->changed_properties, num_changes = 0; l != NULL; l = l->next)
    {
      ChangedProperty *cp = l->data;
      GVariant *variant;
      const GValue *cur_value;

      cur_value = &skeleton->priv->properties[cp->prop_id - 1];
      if (!_g_value_equal (cur_value, &cp->orig_value))
        {
          variant = g_dbus_gvalue_to_gvariant (cur_value, G_VARIANT_TYPE (cp->info->parent_struct.signature));
          g_variant_builder_add (&builder, "{sv}", cp->info->parent_struct.name, variant);
          g_variant_unref (variant);
          num_changes++;
        }
    }
  if (num_changes > 0)
    {
      GList *connections, *ll;
      GVariant *signal_variant;
      signal_variant = g_variant_ref_sink (g_variant_new ("(sa{sv}as)", "org.kde.StatusNotifierItem",
                                           &builder, &invalidated_builder));
      connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));
      for (ll = connections; ll != NULL; ll = ll->next)
        {
          GDBusConnection *connection = ll->data;

          g_dbus_connection_emit_signal (connection,
                                         NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)),
                                         "org.freedesktop.DBus.Properties",
                                         "PropertiesChanged",
                                         signal_variant,
                                         NULL);
        }
      g_variant_unref (signal_variant);
      g_list_free_full (connections, g_object_unref);
    }
  else
    {
      g_variant_builder_clear (&builder);
      g_variant_builder_clear (&invalidated_builder);
    }
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  skeleton->priv->changed_properties = NULL;
  skeleton->priv->changed_properties_idle_source = NULL;
  g_mutex_unlock (&skeleton->priv->lock);
  return FALSE;
}

static void
_sn_item_interface_schedule_emit_changed (SnItemInterfaceSkeleton *skeleton, const _ExtendedGDBusPropertyInfo *info, guint prop_id, const GValue *orig_value)
{
  ChangedProperty *cp;
  GList *l;
  cp = NULL;
  for (l = skeleton->priv->changed_properties; l != NULL; l = l->next)
    {
      ChangedProperty *i_cp = l->data;
      if (i_cp->info == info)
        {
          cp = i_cp;
          break;
        }
    }
  if (cp == NULL)
    {
      cp = g_new0 (ChangedProperty, 1);
      cp->prop_id = prop_id;
      cp->info = info;
      skeleton->priv->changed_properties = g_list_prepend (skeleton->priv->changed_properties, cp);
      g_value_init (&cp->orig_value, G_VALUE_TYPE (orig_value));
      g_value_copy (orig_value, &cp->orig_value);
    }
}

static void
sn_item_interface_skeleton_notify (GObject      *object,
  GParamSpec *pspec G_GNUC_UNUSED)
{
  SnItemInterfaceSkeleton *skeleton = SN_ITEM_INTERFACE_SKELETON (object);
  g_mutex_lock (&skeleton->priv->lock);
  if (skeleton->priv->changed_properties != NULL &&
      skeleton->priv->changed_properties_idle_source == NULL)
    {
      skeleton->priv->changed_properties_idle_source = g_idle_source_new ();
      g_source_set_priority (skeleton->priv->changed_properties_idle_source, G_PRIORITY_DEFAULT);
      g_source_set_callback (skeleton->priv->changed_properties_idle_source, _sn_item_interface_emit_changed, g_object_ref (skeleton), (GDestroyNotify) g_object_unref);
      g_source_set_name (skeleton->priv->changed_properties_idle_source, "[generated] _sn_item_interface_emit_changed");
      g_source_attach (skeleton->priv->changed_properties_idle_source, skeleton->priv->context);
      g_source_unref (skeleton->priv->changed_properties_idle_source);
    }
  g_mutex_unlock (&skeleton->priv->lock);
}

static void
sn_item_interface_skeleton_set_property (GObject      *object,
  guint         prop_id,
  const GValue *value,
  GParamSpec   *pspec)
{
  const _ExtendedGDBusPropertyInfo *info;
  SnItemInterfaceSkeleton *skeleton = SN_ITEM_INTERFACE_SKELETON (object);
  g_assert (prop_id != 0 && prop_id - 1 < 14);
  info = (const _ExtendedGDBusPropertyInfo *) _sn_item_interface_property_info_pointers[prop_id - 1];
  g_mutex_lock (&skeleton->priv->lock);
  g_object_freeze_notify (object);
  if (!_g_value_equal (value, &skeleton->priv->properties[prop_id - 1]))
    {
      if (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)) != NULL &&
          info->emits_changed_signal)
        _sn_item_interface_schedule_emit_changed (skeleton, info, prop_id, &skeleton->priv->properties[prop_id - 1]);
      g_value_copy (value, &skeleton->priv->properties[prop_id - 1]);
      g_object_notify_by_pspec (object, pspec);
    }
  g_mutex_unlock (&skeleton->priv->lock);
  g_object_thaw_notify (object);
}

static void
sn_item_interface_skeleton_init (SnItemInterfaceSkeleton *skeleton)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  skeleton->priv = sn_item_interface_skeleton_get_instance_private (skeleton);
#else
  skeleton->priv = G_TYPE_INSTANCE_GET_PRIVATE (skeleton, TYPE_SN_ITEM_INTERFACE_SKELETON, SnItemInterfaceSkeletonPrivate);
#endif

  g_mutex_init (&skeleton->priv->lock);
  skeleton->priv->context = g_main_context_ref_thread_default ();
  skeleton->priv->properties = g_new0 (GValue, 14);
  g_value_init (&skeleton->priv->properties[0], G_TYPE_STRING);
  g_value_init (&skeleton->priv->properties[1], G_TYPE_STRING);
  g_value_init (&skeleton->priv->properties[2], G_TYPE_STRING);
  g_value_init (&skeleton->priv->properties[3], G_TYPE_STRING);
  g_value_init (&skeleton->priv->properties[4], G_TYPE_INT);
  g_value_init (&skeleton->priv->properties[5], G_TYPE_STRING);
  g_value_init (&skeleton->priv->properties[6], G_TYPE_STRING);
  g_value_init (&skeleton->priv->properties[7], G_TYPE_STRING);
  g_value_init (&skeleton->priv->properties[8], G_TYPE_VARIANT);
  g_value_init (&skeleton->priv->properties[9], G_TYPE_STRING);
  g_value_init (&skeleton->priv->properties[10], G_TYPE_VARIANT);
  g_value_init (&skeleton->priv->properties[11], G_TYPE_STRING);
  g_value_init (&skeleton->priv->properties[12], G_TYPE_VARIANT);
  g_value_init (&skeleton->priv->properties[13], G_TYPE_VARIANT);
}

static const gchar *
sn_item_interface_skeleton_get_category (SnItemInterface *object)
{
  SnItemInterfaceSkeleton *skeleton = SN_ITEM_INTERFACE_SKELETON (object);
  const gchar *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_string (&(skeleton->priv->properties[0]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static const gchar *
sn_item_interface_skeleton_get_id (SnItemInterface *object)
{
  SnItemInterfaceSkeleton *skeleton = SN_ITEM_INTERFACE_SKELETON (object);
  const gchar *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_string (&(skeleton->priv->properties[1]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static const gchar *
sn_item_interface_skeleton_get_title (SnItemInterface *object)
{
  SnItemInterfaceSkeleton *skeleton = SN_ITEM_INTERFACE_SKELETON (object);
  const gchar *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_string (&(skeleton->priv->properties[2]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static const gchar *
sn_item_interface_skeleton_get_status (SnItemInterface *object)
{
  SnItemInterfaceSkeleton *skeleton = SN_ITEM_INTERFACE_SKELETON (object);
  const gchar *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_string (&(skeleton->priv->properties[3]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static gint 
sn_item_interface_skeleton_get_window_id (SnItemInterface *object)
{
  SnItemInterfaceSkeleton *skeleton = SN_ITEM_INTERFACE_SKELETON (object);
  gint value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_int (&(skeleton->priv->properties[4]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static const gchar *
sn_item_interface_skeleton_get_menu (SnItemInterface *object)
{
  SnItemInterfaceSkeleton *skeleton = SN_ITEM_INTERFACE_SKELETON (object);
  const gchar *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_string (&(skeleton->priv->properties[5]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static const gchar *
sn_item_interface_skeleton_get_icon_name (SnItemInterface *object)
{
  SnItemInterfaceSkeleton *skeleton = SN_ITEM_INTERFACE_SKELETON (object);
  const gchar *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_string (&(skeleton->priv->properties[6]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static const gchar *
sn_item_interface_skeleton_get_icon_theme_path (SnItemInterface *object)
{
  SnItemInterfaceSkeleton *skeleton = SN_ITEM_INTERFACE_SKELETON (object);
  const gchar *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_string (&(skeleton->priv->properties[7]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static GVariant *
sn_item_interface_skeleton_get_icon_pixmap (SnItemInterface *object)
{
  SnItemInterfaceSkeleton *skeleton = SN_ITEM_INTERFACE_SKELETON (object);
  GVariant *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_variant (&(skeleton->priv->properties[8]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static const gchar *
sn_item_interface_skeleton_get_overlay_icon_name (SnItemInterface *object)
{
  SnItemInterfaceSkeleton *skeleton = SN_ITEM_INTERFACE_SKELETON (object);
  const gchar *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_string (&(skeleton->priv->properties[9]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static GVariant *
sn_item_interface_skeleton_get_overlay_icon_pixmap (SnItemInterface *object)
{
  SnItemInterfaceSkeleton *skeleton = SN_ITEM_INTERFACE_SKELETON (object);
  GVariant *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_variant (&(skeleton->priv->properties[10]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static const gchar *
sn_item_interface_skeleton_get_attention_icon_name (SnItemInterface *object)
{
  SnItemInterfaceSkeleton *skeleton = SN_ITEM_INTERFACE_SKELETON (object);
  const gchar *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_string (&(skeleton->priv->properties[11]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static GVariant *
sn_item_interface_skeleton_get_attention_icon_pixmap (SnItemInterface *object)
{
  SnItemInterfaceSkeleton *skeleton = SN_ITEM_INTERFACE_SKELETON (object);
  GVariant *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_variant (&(skeleton->priv->properties[12]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static GVariant *
sn_item_interface_skeleton_get_tool_tip (SnItemInterface *object)
{
  SnItemInterfaceSkeleton *skeleton = SN_ITEM_INTERFACE_SKELETON (object);
  GVariant *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_variant (&(skeleton->priv->properties[13]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static void
sn_item_interface_skeleton_class_init (SnItemInterfaceSkeletonClass *klass)
{
  GObjectClass *gobject_class;
  GDBusInterfaceSkeletonClass *skeleton_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize = sn_item_interface_skeleton_finalize;
  gobject_class->get_property = sn_item_interface_skeleton_get_property;
  gobject_class->set_property = sn_item_interface_skeleton_set_property;
  gobject_class->notify       = sn_item_interface_skeleton_notify;


  sn_item_interface_override_properties (gobject_class, 1);

  skeleton_class = G_DBUS_INTERFACE_SKELETON_CLASS (klass);
  skeleton_class->get_info = sn_item_interface_skeleton_dbus_interface_get_info;
  skeleton_class->get_properties = sn_item_interface_skeleton_dbus_interface_get_properties;
  skeleton_class->flush = sn_item_interface_skeleton_dbus_interface_flush;
  skeleton_class->get_vtable = sn_item_interface_skeleton_dbus_interface_get_vtable;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (SnItemInterfaceSkeletonPrivate));
#endif
}

static void
sn_item_interface_skeleton_iface_init (SnItemInterfaceIface *iface)
{
  iface->new_title = _sn_item_interface_on_signal_new_title;
  iface->new_icon = _sn_item_interface_on_signal_new_icon;
  iface->new_icon_theme_path = _sn_item_interface_on_signal_new_icon_theme_path;
  iface->new_attention_icon = _sn_item_interface_on_signal_new_attention_icon;
  iface->new_overlay_icon = _sn_item_interface_on_signal_new_overlay_icon;
  iface->new_menu = _sn_item_interface_on_signal_new_menu;
  iface->new_tool_tip = _sn_item_interface_on_signal_new_tool_tip;
  iface->new_status = _sn_item_interface_on_signal_new_status;
  iface->get_category = sn_item_interface_skeleton_get_category;
  iface->get_id = sn_item_interface_skeleton_get_id;
  iface->get_title = sn_item_interface_skeleton_get_title;
  iface->get_status = sn_item_interface_skeleton_get_status;
  iface->get_window_id = sn_item_interface_skeleton_get_window_id;
  iface->get_menu = sn_item_interface_skeleton_get_menu;
  iface->get_icon_name = sn_item_interface_skeleton_get_icon_name;
  iface->get_icon_theme_path = sn_item_interface_skeleton_get_icon_theme_path;
  iface->get_icon_pixmap = sn_item_interface_skeleton_get_icon_pixmap;
  iface->get_overlay_icon_name = sn_item_interface_skeleton_get_overlay_icon_name;
  iface->get_overlay_icon_pixmap = sn_item_interface_skeleton_get_overlay_icon_pixmap;
  iface->get_attention_icon_name = sn_item_interface_skeleton_get_attention_icon_name;
  iface->get_attention_icon_pixmap = sn_item_interface_skeleton_get_attention_icon_pixmap;
  iface->get_tool_tip = sn_item_interface_skeleton_get_tool_tip;
}

/**
 * sn_item_interface_skeleton_new:
 *
 * Creates a skeleton object for the D-Bus interface <link linkend="gdbus-interface-org-kde-StatusNotifierItem.top_of_page">org.kde.StatusNotifierItem</link>.
 *
 * Returns: (transfer full) (type SnItemInterfaceSkeleton): The skeleton object.
 */
SnItemInterface *
sn_item_interface_skeleton_new (void)
{
  return SN_ITEM_INTERFACE (g_object_new (TYPE_SN_ITEM_INTERFACE_SKELETON, NULL));
}

